/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.ArrayList;
import java.util.List;
import uk.ac.cam.ch.wwmm.opsin.OpsinTrieNode;

class OpsinRadixTrie {
    final OpsinTrieNode rootNode = new OpsinTrieNode("", false);

    OpsinRadixTrie() {
    }

    void addToken(String token) {
        int tokenLength = token.length();
        String remaingStr = token;
        OpsinTrieNode currentNode = this.rootNode;
        int i = 0;
        while (i < tokenLength) {
            int charsMatched = currentNode.getNumberOfMatchingCharacters(remaingStr, 0);
            remaingStr = remaingStr.substring(charsMatched);
            i += charsMatched;
            currentNode = currentNode.add(remaingStr, charsMatched);
        }
        currentNode.setIsEndPoint(true);
    }

    List<Integer> findMatches(String chemicalName, int posInName) {
        int untokenisedChemicalNameLength = chemicalName.length();
        ArrayList<Integer> indexes = null;
        if (this.rootNode.isEndPoint()) {
            indexes = new ArrayList<Integer>();
            indexes.add(posInName);
        }
        OpsinTrieNode node = this.rootNode;
        for (int i = posInName; i < untokenisedChemicalNameLength && (node = node.getChild(chemicalName.charAt(i))) != null; ++i) {
            int nodeLength = node.getValue().length();
            if (nodeLength > 1) {
                int charsMatched = node.getNumberOfMatchingCharacters(chemicalName, i);
                if (charsMatched != nodeLength) break;
                i += charsMatched - 1;
            }
            if (!node.isEndPoint()) continue;
            if (indexes == null) {
                indexes = new ArrayList();
            }
            indexes.add(i + 1);
        }
        return indexes;
    }

    List<Integer> findMatchesReadingStringRightToLeft(String chemicalName, int posInName) {
        ArrayList<Integer> indexes = null;
        if (this.rootNode.isEndPoint()) {
            indexes = new ArrayList<Integer>();
            indexes.add(posInName);
        }
        OpsinTrieNode node = this.rootNode;
        for (int i = posInName - 1; i >= 0 && (node = node.getChild(chemicalName.charAt(i))) != null; --i) {
            int nodeLength = node.getValue().length();
            if (nodeLength > 1) {
                int charsMatched = node.getNumberOfMatchingCharactersInReverse(chemicalName, i);
                if (charsMatched != nodeLength) break;
                i -= charsMatched - 1;
            }
            if (!node.isEndPoint()) continue;
            if (indexes == null) {
                indexes = new ArrayList();
            }
            indexes.add(i);
        }
        return indexes;
    }
}

