/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import uk.ac.cam.ch.wwmm.opsin.Atom;
import uk.ac.cam.ch.wwmm.opsin.Attribute;
import uk.ac.cam.ch.wwmm.opsin.Bond;
import uk.ac.cam.ch.wwmm.opsin.BuildState;
import uk.ac.cam.ch.wwmm.opsin.ChemEl;
import uk.ac.cam.ch.wwmm.opsin.ComponentGenerationException;
import uk.ac.cam.ch.wwmm.opsin.Element;
import uk.ac.cam.ch.wwmm.opsin.Fragment;
import uk.ac.cam.ch.wwmm.opsin.FunctionalAtom;
import uk.ac.cam.ch.wwmm.opsin.OpsinTools;
import uk.ac.cam.ch.wwmm.opsin.OutAtom;
import uk.ac.cam.ch.wwmm.opsin.StringTools;
import uk.ac.cam.ch.wwmm.opsin.StructureBuildingException;
import uk.ac.cam.ch.wwmm.opsin.StructureBuildingMethods;
import uk.ac.cam.ch.wwmm.opsin.WordRule;
import uk.ac.cam.ch.wwmm.opsin.WordType;

class FunctionalReplacement {
    static final Pattern matchChalcogenReplacement = Pattern.compile("thio|seleno|telluro");
    private final BuildState state;

    FunctionalReplacement(BuildState state) {
        this.state = state;
    }

    void processAcidReplacingFunctionalClassNomenclature(Element finalSubOrRootInWord, Element word) throws ComponentGenerationException, StructureBuildingException {
        Element parentWordRule;
        Element wordRule = OpsinTools.getParentWordRule(word);
        if (WordRule.valueOf(wordRule.getAttributeValue("wordRule")) == WordRule.acidReplacingFunctionalGroup && (parentWordRule = word.getParent()).indexOf(word) == 0) {
            int l = parentWordRule.getChildCount();
            for (int i = 1; i < l; ++i) {
                Element acidReplacingWord = parentWordRule.getChild(i);
                if (!acidReplacingWord.getName().equals("word")) {
                    throw new RuntimeException("OPSIN bug: problem with acidReplacingFunctionalGroup word rule");
                }
                String type = acidReplacingWord.getAttributeValue("type");
                if (type.equals(WordType.full.toString())) {
                    this.processAcidReplacingFunctionalClassNomenclatureFullWord(finalSubOrRootInWord, acidReplacingWord);
                    continue;
                }
                if (type.equals(WordType.functionalTerm.toString())) {
                    this.processAcidReplacingFunctionalClassNomenclatureFunctionalWord(finalSubOrRootInWord, acidReplacingWord);
                    continue;
                }
                throw new RuntimeException("OPSIN bug: problem with acidReplacingFunctionalGroup word rule");
            }
        }
    }

    boolean processPrefixFunctionalReplacementNomenclature(List<Element> groups, List<Element> substituents) throws StructureBuildingException, ComponentGenerationException {
        int originalNumberOfGroups = groups.size();
        for (int i = originalNumberOfGroups - 1; i >= 0; --i) {
            Element group = groups.get(i);
            String groupValue = group.getValue();
            PREFIX_REPLACEMENT_TYPE replacementType = null;
            if (matchChalcogenReplacement.matcher(groupValue).matches() && !this.isChalcogenSubstituent(group) || groupValue.equals("thiono")) {
                replacementType = PREFIX_REPLACEMENT_TYPE.chalcogen;
            } else if ("halideOrPseudoHalide".equals(group.getAttributeValue("subType"))) {
                replacementType = PREFIX_REPLACEMENT_TYPE.halideOrPseudoHalide;
            } else if ("dedicatedFunctionalReplacementPrefix".equals(group.getAttributeValue("subType"))) {
                replacementType = PREFIX_REPLACEMENT_TYPE.dedicatedFunctionalReplacementPrefix;
            } else if (groupValue.equals("hydrazono")) {
                replacementType = PREFIX_REPLACEMENT_TYPE.hydrazono;
            } else if (groupValue.equals("peroxy")) {
                replacementType = PREFIX_REPLACEMENT_TYPE.peroxy;
            }
            if (replacementType == null) continue;
            Element substituent = group.getParent();
            Element nextSubOrBracket = OpsinTools.getNextSibling(substituent);
            if (nextSubOrBracket != null && (nextSubOrBracket.getName().equals("root") || nextSubOrBracket.getName().equals("substituent"))) {
                int oxygenReplaced;
                Element groupToBeModified = nextSubOrBracket.getFirstChildElement("group");
                if (this.groupPrecededByElementThatBlocksPrefixReplacementInterpetation(groupToBeModified)) {
                    if (replacementType != PREFIX_REPLACEMENT_TYPE.dedicatedFunctionalReplacementPrefix) continue;
                    throw new ComponentGenerationException("dedicated Functional Replacement Prefix used in an inappropriate position :" + groupValue);
                }
                Element locantEl = null;
                Element multiplierEl = null;
                int numberOfAtomsToReplace = 1;
                Element possibleMultiplier = OpsinTools.getPreviousSibling(group);
                if (possibleMultiplier != null) {
                    Element possibleLocant;
                    if (possibleMultiplier.getName().equals("multiplier")) {
                        numberOfAtomsToReplace = Integer.valueOf(possibleMultiplier.getAttributeValue("value"));
                        possibleLocant = OpsinTools.getPreviousSibling(possibleMultiplier);
                        multiplierEl = possibleMultiplier;
                    } else {
                        possibleLocant = possibleMultiplier;
                    }
                    if (possibleLocant != null && possibleLocant.getName().equals("locant") && possibleLocant.getAttribute("type") == null) {
                        int numberOfLocants = possibleLocant.getValue().split(",").length;
                        if (numberOfLocants == numberOfAtomsToReplace) {
                            locantEl = possibleLocant;
                        } else if (numberOfAtomsToReplace > 1) {
                            if (replacementType != PREFIX_REPLACEMENT_TYPE.dedicatedFunctionalReplacementPrefix) continue;
                            throw new ComponentGenerationException("dedicated Functional Replacement Prefix used in an inappropriate position :" + groupValue);
                        }
                    }
                }
                if (replacementType == PREFIX_REPLACEMENT_TYPE.chalcogen) {
                    oxygenReplaced = this.performChalcogenFunctionalReplacement(groupToBeModified, locantEl, numberOfAtomsToReplace, group.getAttributeValue("value"));
                } else if (replacementType == PREFIX_REPLACEMENT_TYPE.peroxy) {
                    if (nextSubOrBracket.getName().equals("substituent")) continue;
                    oxygenReplaced = this.performPeroxyFunctionalReplacement(groupToBeModified, locantEl, numberOfAtomsToReplace);
                } else if (replacementType == PREFIX_REPLACEMENT_TYPE.dedicatedFunctionalReplacementPrefix) {
                    if (!(groupToBeModified.getAttributeValue("type").equals("nonCarboxylicAcid") || groupToBeModified.getValue().equals("form") && groupValue.equals("imido"))) {
                        throw new ComponentGenerationException("dedicated Functional Replacement Prefix used in an inappropriate position :" + groupValue);
                    }
                    oxygenReplaced = this.performFunctionalReplacementOnAcid(groupToBeModified, locantEl, numberOfAtomsToReplace, group.getAttributeValue("value"));
                    if (oxygenReplaced == 0) {
                        throw new ComponentGenerationException("dedicated Functional Replacement Prefix used in an inappropriate position :" + groupValue);
                    }
                } else if (replacementType == PREFIX_REPLACEMENT_TYPE.hydrazono || replacementType == PREFIX_REPLACEMENT_TYPE.halideOrPseudoHalide) {
                    Fragment acidFrag = groupToBeModified.getFrag();
                    if (!groupToBeModified.getAttributeValue("type").equals("nonCarboxylicAcid") || this.acidHasSufficientHydrogenForSubstitutionInterpretation(acidFrag, group.getFrag().getOutAtom(0).getValency(), locantEl)) continue;
                    oxygenReplaced = this.performFunctionalReplacementOnAcid(groupToBeModified, locantEl, numberOfAtomsToReplace, group.getAttributeValue("value"));
                } else {
                    throw new StructureBuildingException("OPSIN bug: Unexpected prefix replacement type");
                }
                if (oxygenReplaced <= 0) continue;
                this.state.fragManager.removeFragment(group.getFrag());
                substituent.removeChild(group);
                groups.remove(group);
                List<Element> remainingChildren = substituent.getChildElements();
                for (int j = remainingChildren.size() - 1; j >= 0; --j) {
                    Element child = substituent.getChild(j);
                    child.detach();
                    nextSubOrBracket.insertChild(child, 0);
                }
                substituents.remove(substituent);
                substituent.detach();
                if (oxygenReplaced <= 1) continue;
                multiplierEl.detach();
                continue;
            }
            if (replacementType != PREFIX_REPLACEMENT_TYPE.dedicatedFunctionalReplacementPrefix) continue;
            throw new ComponentGenerationException("dedicated Functional Replacement Prefix used in an inappropriate position :" + groupValue);
        }
        return groups.size() != originalNumberOfGroups;
    }

    private boolean isChalcogenSubstituent(Element group) {
        Element suffix;
        Element previousGroup;
        Element next = OpsinTools.getNextSibling(group);
        if (next != null && next.getName().equals("hyphen") && OpsinTools.getPreviousSibling(group) == null && (previousGroup = OpsinTools.getPreviousGroup(group)) != null && ((suffix = OpsinTools.getNextSibling(previousGroup, "suffix")) == null || suffix.getFrag() == null)) {
            for (Atom a : previousGroup.getFrag()) {
                if (a.getElement() != ChemEl.C) continue;
                return true;
            }
        }
        return false;
    }

    private boolean groupPrecededByElementThatBlocksPrefixReplacementInterpetation(Element groupToBeModified) {
        Element previous = OpsinTools.getPreviousSibling(groupToBeModified);
        while (previous != null && (previous.getName().equals("subtractivePrefix") || previous.getName().equals("stereoChemistry") && previous.getAttributeValue("type").equals("carbohydrateConfigurationalPrefix"))) {
            previous = OpsinTools.getPreviousSibling(previous);
        }
        return previous != null;
    }

    void processInfixFunctionalReplacementNomenclature(List<Element> suffixes, List<Fragment> suffixFragments) throws StructureBuildingException, ComponentGenerationException {
        for (int i = 0; i < suffixes.size(); ++i) {
            Element suffix = suffixes.get(i);
            if (suffix.getAttribute("infix") == null) continue;
            Fragment fragToApplyInfixTo = suffix.getFrag();
            Element possibleAcidGroup = OpsinTools.getPreviousSiblingIgnoringCertainElements(suffix, new String[]{"multiplier", "infix", "suffix"});
            if (possibleAcidGroup != null && possibleAcidGroup.getName().equals("group") && (possibleAcidGroup.getAttributeValue("type").equals("nonCarboxylicAcid") || possibleAcidGroup.getAttributeValue("type").equals("chalcogenAcidStem"))) {
                fragToApplyInfixTo = possibleAcidGroup.getFrag();
            }
            if (fragToApplyInfixTo == null) {
                throw new ComponentGenerationException("infix has erroneously been assigned to a suffix which does not correspond to a suffix fragment. suffix: " + suffix.getValue());
            }
            List<String> infixTransformations = StringTools.arrayToList(suffix.getAttributeValue("infix").split(";"));
            List<Atom> atomList = fragToApplyInfixTo.getAtomList();
            LinkedList<Atom> singleBondedOxygen = new LinkedList<Atom>();
            LinkedList<Atom> doubleBondedOxygen = new LinkedList<Atom>();
            this.populateTerminalSingleAndDoubleBondedOxygen(atomList, singleBondedOxygen, doubleBondedOxygen);
            int oxygenAvailable = singleBondedOxygen.size() + doubleBondedOxygen.size();
            this.disambiguateMultipliedInfixMeaning(suffixes, suffixFragments, suffix, infixTransformations, oxygenAvailable);
            Collections.sort(infixTransformations, new SortInfixTransformations());
            for (String infixTransformation : infixTransformations) {
                String[] transformationArray = infixTransformation.split(":");
                if (transformationArray.length != 2) {
                    throw new StructureBuildingException("Atom to be replaced and replacement not specified correctly in infix: " + infixTransformation);
                }
                String[] transformations = transformationArray[0].split(",");
                String replacementSMILES = transformationArray[1];
                boolean acceptDoubleBondedOxygen = false;
                boolean acceptSingleBondedOxygen = false;
                boolean nitrido = false;
                for (String transformation : transformations) {
                    if (transformation.startsWith("=")) {
                        acceptDoubleBondedOxygen = true;
                    } else if (transformation.startsWith("-")) {
                        acceptSingleBondedOxygen = true;
                    } else if (transformation.startsWith("#")) {
                        nitrido = true;
                    } else {
                        throw new StructureBuildingException("Malformed infix transformation. Expected to start with either - or =. Transformation was: " + transformation);
                    }
                    if (transformation.length() >= 2 && transformation.charAt(1) == 'O') continue;
                    throw new StructureBuildingException("Only replacement by oxygen is supported. Check infix defintions");
                }
                boolean infixAssignmentAmbiguous = false;
                if ((acceptSingleBondedOxygen || nitrido) && !acceptDoubleBondedOxygen) {
                    if (singleBondedOxygen.isEmpty()) {
                        throw new StructureBuildingException("Cannot find single bonded oxygen for infix with SMILES: " + replacementSMILES + " to modify!");
                    }
                    if (singleBondedOxygen.size() != 1) {
                        infixAssignmentAmbiguous = true;
                    }
                }
                if (!acceptSingleBondedOxygen && (acceptDoubleBondedOxygen || nitrido)) {
                    if (doubleBondedOxygen.isEmpty()) {
                        throw new StructureBuildingException("Cannot find double bonded oxygen for infix with SMILES: " + replacementSMILES + " to modify!");
                    }
                    if (doubleBondedOxygen.size() != 1) {
                        infixAssignmentAmbiguous = true;
                    }
                }
                if (acceptSingleBondedOxygen && acceptDoubleBondedOxygen) {
                    if (oxygenAvailable == 0) {
                        throw new StructureBuildingException("Cannot find oxygen for infix with SMILES: " + replacementSMILES + " to modify!");
                    }
                    if (oxygenAvailable != 1) {
                        infixAssignmentAmbiguous = true;
                    }
                }
                LinkedHashSet<Atom> ambiguousElementAtoms = new LinkedHashSet<Atom>();
                Atom atomToUse = null;
                if ((acceptDoubleBondedOxygen || nitrido) && doubleBondedOxygen.size() > 0) {
                    atomToUse = doubleBondedOxygen.removeFirst();
                } else if (acceptSingleBondedOxygen && singleBondedOxygen.size() > 0) {
                    atomToUse = singleBondedOxygen.removeFirst();
                } else {
                    throw new StructureBuildingException("Cannot find oxygen for infix with SMILES: " + replacementSMILES + " to modify!");
                }
                Fragment replacementFrag = this.state.fragManager.buildSMILES(replacementSMILES, "suffix", "none");
                if (replacementFrag.getOutAtomCount() > 0) {
                    replacementFrag.removeOutAtom(0);
                }
                Atom atomThatWillReplaceOxygen = replacementFrag.getFirstAtom();
                if (replacementFrag.getAtomCount() == 1 && atomThatWillReplaceOxygen.getElement().isChalcogen()) {
                    atomThatWillReplaceOxygen.setCharge(atomToUse.getCharge());
                    atomThatWillReplaceOxygen.setProtonsExplicitlyAddedOrRemoved(atomToUse.getProtonsExplicitlyAddedOrRemoved());
                }
                this.removeOrMoveObsoleteFunctionalAtoms(atomToUse, replacementFrag);
                this.moveObsoleteOutAtoms(atomToUse, replacementFrag);
                if (nitrido) {
                    atomToUse.getFirstBond().setOrder(3);
                    Atom removedHydroxy = singleBondedOxygen.removeFirst();
                    this.state.fragManager.removeAtomAndAssociatedBonds(removedHydroxy);
                    this.removeAssociatedFunctionalAtom(removedHydroxy);
                }
                this.state.fragManager.incorporateFragment(replacementFrag, atomToUse.getFrag());
                this.state.fragManager.replaceAtomWithAnotherAtomPreservingConnectivity(atomToUse, atomThatWillReplaceOxygen);
                if (infixAssignmentAmbiguous) {
                    ambiguousElementAtoms.add(atomThatWillReplaceOxygen);
                    if (atomThatWillReplaceOxygen.getProperty(Atom.AMBIGUOUS_ELEMENT_ASSIGNMENT) != null) {
                        ambiguousElementAtoms.addAll((Collection)atomThatWillReplaceOxygen.getProperty(Atom.AMBIGUOUS_ELEMENT_ASSIGNMENT));
                    }
                }
                if (!infixAssignmentAmbiguous) continue;
                for (Atom a : doubleBondedOxygen) {
                    ambiguousElementAtoms.add(a);
                    if (a.getProperty(Atom.AMBIGUOUS_ELEMENT_ASSIGNMENT) == null) continue;
                    ambiguousElementAtoms.addAll((Collection)a.getProperty(Atom.AMBIGUOUS_ELEMENT_ASSIGNMENT));
                }
                for (Atom a : singleBondedOxygen) {
                    ambiguousElementAtoms.add(a);
                    if (a.getProperty(Atom.AMBIGUOUS_ELEMENT_ASSIGNMENT) == null) continue;
                    ambiguousElementAtoms.addAll((Collection)a.getProperty(Atom.AMBIGUOUS_ELEMENT_ASSIGNMENT));
                }
                for (Atom atom : ambiguousElementAtoms) {
                    atom.setProperty(Atom.AMBIGUOUS_ELEMENT_ASSIGNMENT, ambiguousElementAtoms);
                }
            }
        }
    }

    private void processAcidReplacingFunctionalClassNomenclatureFullWord(Element acidContainingRoot, Element acidReplacingWord) throws ComponentGenerationException, StructureBuildingException {
        boolean isAmide;
        String locant = acidReplacingWord.getAttributeValue("locant");
        Element acidReplacingGroup = StructureBuildingMethods.findRightMostGroupInBracket(acidReplacingWord);
        if (acidReplacingGroup == null) {
            throw new ComponentGenerationException("OPSIN bug: acid replacing group not found where one was expected for acidReplacingFunctionalGroup wordRule");
        }
        String functionalGroupName = acidReplacingGroup.getValue();
        Fragment acidReplacingFrag = acidReplacingGroup.getFrag();
        if (acidReplacingGroup.getParent().getChildCount() != 1) {
            throw new ComponentGenerationException("Unexpected qualifier to: " + functionalGroupName);
        }
        Element groupToBeModified = acidContainingRoot.getFirstChildElement("group");
        List<Atom> oxygenAtoms = this.findFunctionalOxygenAtomsInApplicableSuffixes(groupToBeModified);
        if (oxygenAtoms.isEmpty()) {
            oxygenAtoms = this.findFunctionalOxygenAtomsInGroup(groupToBeModified);
        }
        if (oxygenAtoms.isEmpty()) {
            List<Element> conjunctiveSuffixElements = OpsinTools.getNextSiblingsOfType(groupToBeModified, "conjunctiveSuffixGroup");
            for (Element conjunctiveSuffixElement : conjunctiveSuffixElements) {
                oxygenAtoms.addAll(this.findFunctionalOxygenAtomsInGroup(conjunctiveSuffixElement));
            }
        }
        if (oxygenAtoms.size() < 1) {
            throw new ComponentGenerationException("Insufficient oxygen to replace with " + functionalGroupName + "s in " + acidContainingRoot.getFirstChildElement("group").getValue());
        }
        boolean bl = isAmide = functionalGroupName.equals("amide") || functionalGroupName.equals("amid");
        if (isAmide) {
            if (acidReplacingFrag.getAtomCount() != 1) {
                throw new ComponentGenerationException("OPSIN bug: " + functionalGroupName + " not found where expected");
            }
            Atom amideNitrogen = acidReplacingFrag.getFirstAtom();
            amideNitrogen.neutraliseCharge();
            amideNitrogen.clearLocants();
            acidReplacingFrag.addMappingToAtomLocantMap("N", amideNitrogen);
        }
        Atom chosenOxygen = locant != null ? this.removeOxygenWithAppropriateLocant(oxygenAtoms, locant) : oxygenAtoms.get(0);
        this.state.fragManager.replaceAtomWithAnotherAtomPreservingConnectivity(chosenOxygen, acidReplacingFrag.getFirstAtom());
        this.removeAssociatedFunctionalAtom(chosenOxygen);
    }

    private void processAcidReplacingFunctionalClassNomenclatureFunctionalWord(Element acidContainingRoot, Element functionalWord) throws ComponentGenerationException, StructureBuildingException {
        if (functionalWord != null && functionalWord.getAttributeValue("type").equals(WordType.functionalTerm.toString())) {
            boolean isAmide;
            Element functionalTerm = functionalWord.getFirstChildElement("functionalTerm");
            if (functionalTerm == null) {
                throw new ComponentGenerationException("OPSIN bug: functionalTerm word not found where one was expected for acidReplacingFunctionalGroup wordRule");
            }
            Element acidReplacingGroup = functionalTerm.getFirstChildElement("functionalGroup");
            String functionalGroupName = acidReplacingGroup.getValue();
            Element possibleLocantOrMultiplier = OpsinTools.getPreviousSibling(acidReplacingGroup);
            int numberOfAcidicHydroxysToReplace = 1;
            String[] locants = null;
            if (possibleLocantOrMultiplier != null) {
                if (possibleLocantOrMultiplier.getName().equals("multiplier")) {
                    numberOfAcidicHydroxysToReplace = Integer.parseInt(possibleLocantOrMultiplier.getAttributeValue("value"));
                    possibleLocantOrMultiplier.detach();
                    possibleLocantOrMultiplier = OpsinTools.getPreviousSibling(acidReplacingGroup);
                }
                if (possibleLocantOrMultiplier != null) {
                    if (possibleLocantOrMultiplier.getName().equals("locant")) {
                        locants = StringTools.removeDashIfPresent(possibleLocantOrMultiplier.getValue()).split(",");
                        possibleLocantOrMultiplier.detach();
                    } else {
                        throw new ComponentGenerationException("Unexpected qualifier to acidReplacingFunctionalGroup functionalTerm");
                    }
                }
            }
            if (functionalTerm.getChildCount() != 1) {
                throw new ComponentGenerationException("Unexpected qualifier to acidReplacingFunctionalGroup functionalTerm");
            }
            Element groupToBeModified = acidContainingRoot.getFirstChildElement("group");
            List<Atom> oxygenAtoms = this.findFunctionalOxygenAtomsInApplicableSuffixes(groupToBeModified);
            if (oxygenAtoms.isEmpty()) {
                oxygenAtoms = this.findFunctionalOxygenAtomsInGroup(groupToBeModified);
            }
            if (oxygenAtoms.isEmpty()) {
                List<Element> conjunctiveSuffixElements = OpsinTools.getNextSiblingsOfType(groupToBeModified, "conjunctiveSuffixGroup");
                for (Element conjunctiveSuffixElement : conjunctiveSuffixElements) {
                    oxygenAtoms.addAll(this.findFunctionalOxygenAtomsInGroup(conjunctiveSuffixElement));
                }
            }
            if (numberOfAcidicHydroxysToReplace > oxygenAtoms.size()) {
                throw new ComponentGenerationException("Insufficient oxygen to replace with nitrogen in " + acidContainingRoot.getFirstChildElement("group").getValue());
            }
            boolean bl = isAmide = functionalGroupName.equals("amide") || functionalGroupName.equals("amid");
            if (isAmide) {
                for (int i = 0; i < numberOfAcidicHydroxysToReplace; ++i) {
                    Atom functionalOxygenToReplace = locants != null ? this.removeOxygenWithAppropriateLocant(oxygenAtoms, locants[i]) : oxygenAtoms.get(i);
                    this.removeAssociatedFunctionalAtom(functionalOxygenToReplace);
                    functionalOxygenToReplace.setElement(ChemEl.N);
                }
            } else {
                String groupValue = acidReplacingGroup.getAttributeValue("value");
                String labelsValue = acidReplacingGroup.getAttributeValue("labels");
                Fragment acidReplacingFrag = this.state.fragManager.buildSMILES(groupValue, "suffix", labelsValue != null ? labelsValue : "none");
                Fragment acidFragment = groupToBeModified.getFrag();
                if (acidFragment.hasLocant("2")) {
                    for (Atom atom : acidReplacingFrag) {
                        atom.clearLocants();
                    }
                }
                Atom firstFunctionalOxygenToReplace = locants != null ? this.removeOxygenWithAppropriateLocant(oxygenAtoms, locants[0]) : oxygenAtoms.get(0);
                this.state.fragManager.replaceAtomWithAnotherAtomPreservingConnectivity(firstFunctionalOxygenToReplace, acidReplacingFrag.getFirstAtom());
                this.removeAssociatedFunctionalAtom(firstFunctionalOxygenToReplace);
                for (int i = 1; i < numberOfAcidicHydroxysToReplace; ++i) {
                    Fragment clonedHydrazide = this.state.fragManager.copyAndRelabelFragment(acidReplacingFrag, i);
                    Atom functionalOxygenToReplace = locants != null ? this.removeOxygenWithAppropriateLocant(oxygenAtoms, locants[i]) : oxygenAtoms.get(i);
                    this.state.fragManager.replaceAtomWithAnotherAtomPreservingConnectivity(functionalOxygenToReplace, clonedHydrazide.getFirstAtom());
                    this.state.fragManager.incorporateFragment(clonedHydrazide, functionalOxygenToReplace.getFrag());
                    this.removeAssociatedFunctionalAtom(functionalOxygenToReplace);
                }
                this.state.fragManager.incorporateFragment(acidReplacingFrag, firstFunctionalOxygenToReplace.getFrag());
            }
        } else {
            throw new ComponentGenerationException("amide word not found where expected, bug?");
        }
    }

    private Atom removeOxygenWithAppropriateLocant(List<Atom> oxygenAtoms, String locant) throws ComponentGenerationException {
        Atom atom;
        Iterator<Atom> iterator = oxygenAtoms.iterator();
        while (iterator.hasNext()) {
            atom = iterator.next();
            if (!atom.hasLocant(locant)) continue;
            iterator.remove();
            return atom;
        }
        iterator = oxygenAtoms.iterator();
        while (iterator.hasNext()) {
            atom = iterator.next();
            if (OpsinTools.depthFirstSearchForNonSuffixAtomWithLocant(atom, locant) == null) continue;
            iterator.remove();
            return atom;
        }
        throw new ComponentGenerationException("Failed to find acid group at locant: " + locant);
    }

    private boolean acidHasSufficientHydrogenForSubstitutionInterpretation(Fragment acidFrag, int hydrogenRequiredForSubstitutionInterpretation, Element locantEl) {
        ArrayList<Atom> atomsThatWouldBeSubstituted = new ArrayList<Atom>();
        if (locantEl != null) {
            String[] possibleLocants;
            for (String locant : possibleLocants = locantEl.getValue().split(",")) {
                Atom atomToBeSubstituted = acidFrag.getAtomByLocant(locant);
                if (atomToBeSubstituted == null) {
                    atomsThatWouldBeSubstituted.clear();
                    atomsThatWouldBeSubstituted.add(acidFrag.getDefaultInAtomOrFirstAtom());
                    break;
                }
                atomsThatWouldBeSubstituted.add(atomToBeSubstituted);
            }
        } else {
            atomsThatWouldBeSubstituted.add(acidFrag.getDefaultInAtomOrFirstAtom());
        }
        for (Atom atom : atomsThatWouldBeSubstituted) {
            if (StructureBuildingMethods.calculateSubstitutableHydrogenAtoms(atom) >= hydrogenRequiredForSubstitutionInterpretation) continue;
            return false;
        }
        return true;
    }

    private int performChalcogenFunctionalReplacement(Element groupToBeModified, Element locantEl, int numberOfAtomsToReplace, String replacementSmiles) throws StructureBuildingException {
        List<Atom> oxygenAtoms = this.findOxygenAtomsInApplicableSuffixes(groupToBeModified);
        if (oxygenAtoms.isEmpty()) {
            oxygenAtoms = this.findOxygenAtomsInGroup(groupToBeModified);
        }
        if (locantEl != null) {
            List<Atom> oxygenWithAppropriateLocants = this.pickOxygensWithAppropriateLocants(locantEl, oxygenAtoms);
            if (oxygenWithAppropriateLocants.size() < numberOfAtomsToReplace) {
                numberOfAtomsToReplace = 1;
            } else {
                locantEl.detach();
                oxygenAtoms = oxygenWithAppropriateLocants;
            }
        }
        ArrayList<Atom> replaceableAtoms = new ArrayList<Atom>();
        if (replacementSmiles.startsWith("=")) {
            replacementSmiles = replacementSmiles.substring(1);
            for (Atom oxygen : oxygenAtoms) {
                int incomingValency = oxygen.getIncomingValency();
                int bondCount = oxygen.getBondCount();
                if (bondCount != 1 || incomingValency != 2) continue;
                replaceableAtoms.add(oxygen);
            }
        } else {
            ArrayList<Atom> doubleBondedOxygen = new ArrayList<Atom>();
            ArrayList<Atom> singleBondedOxygen = new ArrayList<Atom>();
            ArrayList<Atom> ethericOxygen = new ArrayList<Atom>();
            for (Atom oxygen : oxygenAtoms) {
                int incomingValency = oxygen.getIncomingValency();
                int bondCount = oxygen.getBondCount();
                if (bondCount == 1 && incomingValency == 2) {
                    doubleBondedOxygen.add(oxygen);
                    continue;
                }
                if (bondCount == 1 && incomingValency == 1) {
                    singleBondedOxygen.add(oxygen);
                    continue;
                }
                if (bondCount != 2 || incomingValency != 2) continue;
                ethericOxygen.add(oxygen);
            }
            replaceableAtoms.addAll(doubleBondedOxygen);
            replaceableAtoms.addAll(singleBondedOxygen);
            replaceableAtoms.addAll(ethericOxygen);
        }
        int totalOxygen = replaceableAtoms.size();
        if (numberOfAtomsToReplace > 1 && totalOxygen < numberOfAtomsToReplace) {
            numberOfAtomsToReplace = 1;
        }
        int atomsReplaced = 0;
        if (totalOxygen >= numberOfAtomsToReplace) {
            boolean prefixAssignmentAmbiguous = false;
            LinkedHashSet<Atom> ambiguousElementAtoms = new LinkedHashSet<Atom>();
            if (totalOxygen != numberOfAtomsToReplace) {
                prefixAssignmentAmbiguous = true;
            }
            for (Atom atomToReplace : replaceableAtoms) {
                if (atomsReplaced == numberOfAtomsToReplace) {
                    ambiguousElementAtoms.add(atomToReplace);
                    continue;
                }
                this.state.fragManager.replaceAtomWithSmiles(atomToReplace, replacementSmiles);
                if (prefixAssignmentAmbiguous) {
                    ambiguousElementAtoms.add(atomToReplace);
                }
                ++atomsReplaced;
            }
            if (prefixAssignmentAmbiguous) {
                for (Atom atom : ambiguousElementAtoms) {
                    atom.setProperty(Atom.AMBIGUOUS_ELEMENT_ASSIGNMENT, ambiguousElementAtoms);
                }
            }
        }
        return atomsReplaced;
    }

    private int performPeroxyFunctionalReplacement(Element groupToBeModified, Element locantEl, int numberOfAtomsToReplace) throws StructureBuildingException {
        List<Atom> oxygenAtoms = this.findFunctionalOxygenAtomsInApplicableSuffixes(groupToBeModified);
        if (oxygenAtoms.isEmpty()) {
            oxygenAtoms = this.findEthericOxygenAtomsInGroup(groupToBeModified);
            oxygenAtoms.addAll(this.findFunctionalOxygenAtomsInGroup(groupToBeModified));
        }
        if (locantEl != null) {
            List<Atom> oxygenWithAppropriateLocants = this.pickOxygensWithAppropriateLocants(locantEl, oxygenAtoms);
            if (oxygenWithAppropriateLocants.size() < numberOfAtomsToReplace) {
                numberOfAtomsToReplace = 1;
            } else {
                locantEl.detach();
                oxygenAtoms = oxygenWithAppropriateLocants;
            }
        }
        if (numberOfAtomsToReplace > 1 && oxygenAtoms.size() < numberOfAtomsToReplace) {
            numberOfAtomsToReplace = 1;
        }
        int atomsReplaced = 0;
        if (oxygenAtoms.size() >= numberOfAtomsToReplace) {
            atomsReplaced = numberOfAtomsToReplace;
            for (int j = 0; j < numberOfAtomsToReplace; ++j) {
                Atom oxygenToReplace = oxygenAtoms.get(j);
                if (oxygenToReplace.getBondCount() == 2) {
                    Fragment newOxygen = this.state.fragManager.buildSMILES("O", "suffix", "none");
                    Bond bondToRemove = oxygenToReplace.getFirstBond();
                    Atom atomToAttachTo = bondToRemove.getFromAtom() == oxygenToReplace ? bondToRemove.getToAtom() : bondToRemove.getFromAtom();
                    this.state.fragManager.createBond(atomToAttachTo, newOxygen.getFirstAtom(), 1);
                    this.state.fragManager.createBond(newOxygen.getFirstAtom(), oxygenToReplace, 1);
                    this.state.fragManager.removeBond(bondToRemove);
                    this.state.fragManager.incorporateFragment(newOxygen, groupToBeModified.getFrag());
                    continue;
                }
                Fragment replacementFrag = this.state.fragManager.buildSMILES("OO", "suffix", "none");
                this.removeOrMoveObsoleteFunctionalAtoms(oxygenToReplace, replacementFrag);
                this.state.fragManager.replaceAtomWithAnotherAtomPreservingConnectivity(oxygenToReplace, replacementFrag.getFirstAtom());
                this.state.fragManager.incorporateFragment(replacementFrag, groupToBeModified.getFrag());
            }
        }
        return atomsReplaced;
    }

    private int performFunctionalReplacementOnAcid(Element groupToBeModified, Element locantEl, int numberOfAtomsToReplace, String replacementSmiles) throws StructureBuildingException {
        int outValency;
        if (replacementSmiles.startsWith("-")) {
            outValency = 1;
        } else if (replacementSmiles.startsWith("=")) {
            outValency = 2;
        } else if (replacementSmiles.startsWith("#")) {
            outValency = 3;
        } else {
            throw new StructureBuildingException("OPSIN bug: Unexpected valency on fragment for prefix functional replacement");
        }
        replacementSmiles = replacementSmiles.substring(1);
        List<Atom> oxygenAtoms = this.findOxygenAtomsInApplicableSuffixes(groupToBeModified);
        if (oxygenAtoms.isEmpty()) {
            oxygenAtoms = this.findOxygenAtomsInGroup(groupToBeModified);
        }
        if (locantEl != null) {
            List<Atom> oxygenWithAppropriateLocants = this.pickOxygensWithAppropriateLocants(locantEl, oxygenAtoms);
            ArrayList<Atom> singleBondedOxygen = new ArrayList<Atom>();
            ArrayList<Atom> terminalDoubleBondedOxygen = new ArrayList<Atom>();
            this.populateTerminalSingleAndDoubleBondedOxygen(oxygenWithAppropriateLocants, singleBondedOxygen, terminalDoubleBondedOxygen);
            if (outValency == 1) {
                oxygenWithAppropriateLocants.removeAll(terminalDoubleBondedOxygen);
            } else if (outValency == 2) {
                oxygenWithAppropriateLocants.removeAll(singleBondedOxygen);
            }
            if (oxygenWithAppropriateLocants.size() < numberOfAtomsToReplace) {
                numberOfAtomsToReplace = 1;
            } else {
                locantEl.detach();
                oxygenAtoms = oxygenWithAppropriateLocants;
            }
        }
        ArrayList<Atom> singleBondedOxygen = new ArrayList<Atom>();
        ArrayList<Atom> terminalDoubleBondedOxygen = new ArrayList<Atom>();
        this.populateTerminalSingleAndDoubleBondedOxygen(oxygenAtoms, singleBondedOxygen, terminalDoubleBondedOxygen);
        if (outValency == 1) {
            oxygenAtoms.removeAll(terminalDoubleBondedOxygen);
        } else if (outValency == 2) {
            oxygenAtoms.removeAll(singleBondedOxygen);
            oxygenAtoms.removeAll(terminalDoubleBondedOxygen);
            oxygenAtoms.addAll(terminalDoubleBondedOxygen);
        } else {
            if (singleBondedOxygen.isEmpty() || terminalDoubleBondedOxygen.isEmpty()) {
                throw new StructureBuildingException("Both a -OH and =O are required for nitrido prefix functional replacement");
            }
            oxygenAtoms.removeAll(singleBondedOxygen);
        }
        if (numberOfAtomsToReplace > 1 && oxygenAtoms.size() < numberOfAtomsToReplace) {
            numberOfAtomsToReplace = 1;
        }
        int atomsReplaced = 0;
        if (oxygenAtoms.size() >= numberOfAtomsToReplace) {
            for (Atom atomToReplace : oxygenAtoms) {
                if (atomsReplaced == numberOfAtomsToReplace) continue;
                Fragment replacementFrag = this.state.fragManager.buildSMILES(replacementSmiles, atomToReplace.getFrag().getTokenEl(), "none");
                if (outValency == 3) {
                    atomToReplace.getFirstBond().setOrder(3);
                    Atom removedHydroxy = (Atom)singleBondedOxygen.remove(0);
                    this.state.fragManager.removeAtomAndAssociatedBonds(removedHydroxy);
                    this.removeAssociatedFunctionalAtom(removedHydroxy);
                }
                this.state.fragManager.replaceAtomWithAnotherAtomPreservingConnectivity(atomToReplace, replacementFrag.getFirstAtom());
                if (outValency == 1) {
                    this.removeOrMoveObsoleteFunctionalAtoms(atomToReplace, replacementFrag);
                }
                this.moveObsoleteOutAtoms(atomToReplace, replacementFrag);
                this.state.fragManager.incorporateFragment(replacementFrag, atomToReplace.getFrag());
                ++atomsReplaced;
            }
        }
        return atomsReplaced;
    }

    private void disambiguateMultipliedInfixMeaning(List<Element> suffixes, List<Fragment> suffixFragments, Element suffix, List<String> infixTransformations, int oxygenAvailable) throws ComponentGenerationException, StructureBuildingException {
        Element possibleInfix = OpsinTools.getPreviousSibling(suffix);
        if (possibleInfix.getName().equals("infix")) {
            Element possibleMultiplier = OpsinTools.getPreviousSibling(possibleInfix);
            if (possibleMultiplier.getName().equals("multiplier")) {
                int multiplierValue = Integer.parseInt(possibleMultiplier.getAttributeValue("value"));
                if (infixTransformations.size() + multiplierValue - 1 <= oxygenAvailable) {
                    for (int j = 1; j < multiplierValue; ++j) {
                        infixTransformations.add(0, infixTransformations.get(0));
                    }
                } else {
                    Element possibleLocant = OpsinTools.getPreviousSibling(possibleMultiplier);
                    String[] locants = null;
                    if (possibleLocant.getName().equals("locant")) {
                        locants = possibleLocant.getValue().split(",");
                    }
                    if (locants != null) {
                        if (locants.length != multiplierValue) {
                            throw new ComponentGenerationException("Multiplier/locant disagreement when multiplying infixed suffix");
                        }
                        suffix.addAttribute(new Attribute("locant", locants[0]));
                    }
                    suffix.addAttribute(new Attribute("multiplied", "multiplied"));
                    for (int j = 1; j < multiplierValue; ++j) {
                        Element newSuffix = suffix.copy();
                        Fragment newSuffixFrag = this.state.fragManager.copyFragment(suffix.getFrag());
                        newSuffix.setFrag(newSuffixFrag);
                        suffixFragments.add(newSuffixFrag);
                        OpsinTools.insertAfter(suffix, newSuffix);
                        suffixes.add(newSuffix);
                        if (locants == null) continue;
                        newSuffix.getAttribute("locant").setValue(locants[j]);
                    }
                    if (locants != null) {
                        possibleLocant.detach();
                    }
                }
                possibleMultiplier.detach();
                possibleInfix.detach();
            } else {
                throw new ComponentGenerationException("Multiplier expected in front of ambiguous infix");
            }
        }
    }

    private void removeOrMoveObsoleteFunctionalAtoms(Atom atomToBeReplaced, Fragment replacementFrag) {
        List<Atom> replacementAtomList = replacementFrag.getAtomList();
        Fragment origFrag = atomToBeReplaced.getFrag();
        for (int i = origFrag.getFunctionalAtomCount() - 1; i >= 0; --i) {
            FunctionalAtom functionalAtom = origFrag.getFunctionalAtom(i);
            if (!atomToBeReplaced.equals(functionalAtom.getAtom())) continue;
            atomToBeReplaced.getFrag().removeFunctionalAtom(i);
            Atom terminalAtomOfReplacementFrag = replacementAtomList.get(replacementAtomList.size() - 1);
            if ((terminalAtomOfReplacementFrag.getIncomingValency() == 1 || replacementAtomList.size() == 1) && terminalAtomOfReplacementFrag.getElement().isChalcogen()) {
                replacementFrag.addFunctionalAtom(terminalAtomOfReplacementFrag);
                terminalAtomOfReplacementFrag.setCharge(atomToBeReplaced.getCharge());
                terminalAtomOfReplacementFrag.setProtonsExplicitlyAddedOrRemoved(atomToBeReplaced.getProtonsExplicitlyAddedOrRemoved());
            }
            atomToBeReplaced.neutraliseCharge();
        }
    }

    private void moveObsoleteOutAtoms(Atom atomToBeReplaced, Fragment replacementFrag) {
        if (atomToBeReplaced.getOutValency() > 0) {
            List<Atom> replacementAtomList = replacementFrag.getAtomList();
            Fragment origFrag = atomToBeReplaced.getFrag();
            for (int i = origFrag.getOutAtomCount() - 1; i >= 0; --i) {
                OutAtom outAtom = origFrag.getOutAtom(i);
                if (!atomToBeReplaced.equals(outAtom.getAtom())) continue;
                atomToBeReplaced.getFrag().removeOutAtom(i);
                Atom terminalAtomOfReplacementFrag = replacementAtomList.get(replacementAtomList.size() - 1);
                replacementFrag.addOutAtom(terminalAtomOfReplacementFrag, outAtom.getValency(), (Boolean)outAtom.isSetExplicitly());
            }
        }
    }

    private void removeAssociatedFunctionalAtom(Atom atomWithFunctionalAtom) throws StructureBuildingException {
        Fragment frag = atomWithFunctionalAtom.getFrag();
        for (int i = frag.getFunctionalAtomCount() - 1; i >= 0; --i) {
            FunctionalAtom functionalAtom = frag.getFunctionalAtom(i);
            if (!atomWithFunctionalAtom.equals(functionalAtom.getAtom())) continue;
            atomWithFunctionalAtom.getFrag().removeFunctionalAtom(i);
            return;
        }
        throw new StructureBuildingException("OPSIN bug: Unable to find associated functionalAtom");
    }

    private List<Atom> pickOxygensWithAppropriateLocants(Element locantEl, List<Atom> oxygenAtoms) {
        String[] possibleLocants = locantEl.getValue().split(",");
        boolean pLocantSpecialCase = this.allLocantsP(possibleLocants);
        ArrayList<Atom> oxygenWithAppropriateLocants = new ArrayList<Atom>();
        block0: for (Atom atom : oxygenAtoms) {
            List<String> atomlocants = atom.getLocants();
            if (atomlocants.size() > 0) {
                for (String locantVal : possibleLocants) {
                    if (!atomlocants.contains(locantVal)) continue;
                    oxygenWithAppropriateLocants.add(atom);
                    continue block0;
                }
                continue;
            }
            if (pLocantSpecialCase) {
                for (Atom neighbour : atom.getAtomNeighbours()) {
                    if (neighbour.getElement() != ChemEl.P) continue;
                    oxygenWithAppropriateLocants.add(atom);
                    continue block0;
                }
                continue;
            }
            Atom atomWithNumericLocant = OpsinTools.depthFirstSearchForAtomWithNumericLocant(atom);
            if (atomWithNumericLocant == null) continue;
            List<String> atomWithNumericLocantLocants = atomWithNumericLocant.getLocants();
            for (String locantVal : possibleLocants) {
                if (!atomWithNumericLocantLocants.contains(locantVal)) continue;
                oxygenWithAppropriateLocants.add(atom);
                continue block0;
            }
        }
        return oxygenWithAppropriateLocants;
    }

    private boolean allLocantsP(String[] locants) {
        if (locants.length == 0) {
            return false;
        }
        for (String locant : locants) {
            if (locant.equals("P")) continue;
            return false;
        }
        return true;
    }

    private List<Atom> findFunctionalOxygenAtomsInApplicableSuffixes(Element groupToBeModified) {
        List<Element> suffixElements = OpsinTools.getNextSiblingsOfType(groupToBeModified, "suffix");
        ArrayList<Atom> oxygenAtoms = new ArrayList<Atom>();
        for (Element suffix : suffixElements) {
            Fragment suffixFrag = suffix.getFrag();
            if (suffixFrag == null) continue;
            int l = suffixFrag.getFunctionalAtomCount();
            for (int i = 0; i < l; ++i) {
                Atom a = suffixFrag.getFunctionalAtom(i).getAtom();
                if (a.getElement() != ChemEl.O) continue;
                oxygenAtoms.add(a);
            }
        }
        return oxygenAtoms;
    }

    private List<Atom> findFunctionalOxygenAtomsInGroup(Element groupToBeModified) {
        ArrayList<Atom> oxygenAtoms = new ArrayList<Atom>();
        Fragment frag = groupToBeModified.getFrag();
        int l = frag.getFunctionalAtomCount();
        for (int i = 0; i < l; ++i) {
            Atom a = frag.getFunctionalAtom(i).getAtom();
            if (a.getElement() != ChemEl.O) continue;
            oxygenAtoms.add(a);
        }
        return oxygenAtoms;
    }

    private List<Atom> findEthericOxygenAtomsInGroup(Element groupToBeModified) {
        ArrayList<Atom> oxygenAtoms = new ArrayList<Atom>();
        List<Atom> atomList = groupToBeModified.getFrag().getAtomList();
        for (Atom a : atomList) {
            if (a.getElement() != ChemEl.O || a.getBondCount() != 2 || a.getCharge() != 0 || a.getIncomingValency() != 2) continue;
            oxygenAtoms.add(a);
        }
        return oxygenAtoms;
    }

    private List<Atom> findOxygenAtomsInApplicableSuffixes(Element groupToBeModified) {
        List<Element> suffixElements = OpsinTools.getNextSiblingsOfType(groupToBeModified, "suffix");
        ArrayList<Atom> oxygenAtoms = new ArrayList<Atom>();
        for (Element suffix : suffixElements) {
            Fragment suffixFrag = suffix.getFrag();
            if (suffixFrag == null || suffixFrag.getFunctionalAtomCount() <= 0 && !groupToBeModified.getAttributeValue("type").equals("acidStem") && !suffix.getAttributeValue("value").equals("aldehyde")) continue;
            List<Atom> atomList = suffixFrag.getAtomList();
            for (Atom a : atomList) {
                if (a.getElement() != ChemEl.O) continue;
                oxygenAtoms.add(a);
            }
        }
        return oxygenAtoms;
    }

    private List<Atom> findOxygenAtomsInGroup(Element groupToBeModified) {
        ArrayList<Atom> oxygenAtoms = new ArrayList<Atom>();
        List<Atom> atomList = groupToBeModified.getFrag().getAtomList();
        for (Atom a : atomList) {
            if (a.getElement() != ChemEl.O) continue;
            oxygenAtoms.add(a);
        }
        return oxygenAtoms;
    }

    private void populateTerminalSingleAndDoubleBondedOxygen(List<Atom> atomList, List<Atom> singleBondedOxygen, List<Atom> doubleBondedOxygen) throws StructureBuildingException {
        for (Atom a : atomList) {
            if (a.getElement() != ChemEl.O || a.getBondCount() != 1) continue;
            int incomingValency = a.getIncomingValency();
            if (incomingValency == 2) {
                doubleBondedOxygen.add(a);
                continue;
            }
            if (incomingValency == 1) {
                singleBondedOxygen.add(a);
                continue;
            }
            throw new StructureBuildingException("Unexpected bond order to oxygen; excepted 1 or 2 found: " + incomingValency);
        }
    }

    private static enum PREFIX_REPLACEMENT_TYPE {
        chalcogen,
        halideOrPseudoHalide,
        dedicatedFunctionalReplacementPrefix,
        hydrazono,
        peroxy;

    }

    private static class SortInfixTransformations
    implements Comparator<String> {
        private SortInfixTransformations() {
        }

        @Override
        public int compare(String infixTransformation1, String infixTransformation2) {
            int allowedInputs2;
            int allowedInputs1 = infixTransformation1.split(",").length;
            if (allowedInputs1 < (allowedInputs2 = infixTransformation2.split(",").length)) {
                return -1;
            }
            if (allowedInputs1 > allowedInputs2) {
                return 1;
            }
            return 0;
        }
    }
}

