/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import uk.ac.cam.ch.wwmm.opsin.Atom;
import uk.ac.cam.ch.wwmm.opsin.Bond;
import uk.ac.cam.ch.wwmm.opsin.Element;
import uk.ac.cam.ch.wwmm.opsin.FragmentTools;
import uk.ac.cam.ch.wwmm.opsin.FunctionalAtom;
import uk.ac.cam.ch.wwmm.opsin.OpsinTools;
import uk.ac.cam.ch.wwmm.opsin.OutAtom;
import uk.ac.cam.ch.wwmm.opsin.StructureBuildingException;
import uk.ac.cam.ch.wwmm.opsin.TokenEl;
import uk.ac.cam.ch.wwmm.opsin.ValencyChecker;

class Fragment
implements Iterable<Atom> {
    private final Map<Integer, Atom> atomMapFromId = new LinkedHashMap<Integer, Atom>();
    private final Collection<Atom> atomCollection = this.atomMapFromId.values();
    private final Map<String, Atom> atomMapFromLocant = new HashMap<String, Atom>();
    private final Set<Bond> bondSet = new LinkedHashSet<Bond>();
    private Element tokenEl;
    private final List<OutAtom> outAtoms = new ArrayList<OutAtom>();
    private final List<FunctionalAtom> functionalAtoms = new ArrayList<FunctionalAtom>();
    private Atom defaultInAtom = null;
    private final List<Atom> indicatedHydrogen = new ArrayList<Atom>();
    private List<Atom> polymerAttachmentPoints = null;

    Fragment(Element tokenEl) {
        this.tokenEl = tokenEl;
    }

    Fragment(String type) {
        this.tokenEl = new TokenEl("");
        this.tokenEl.addAttribute("type", type);
    }

    void addAtom(Atom atom) {
        List<String> locants = atom.getLocants();
        for (String locant : locants) {
            this.atomMapFromLocant.put(locant, atom);
        }
        this.atomMapFromId.put(atom.getID(), atom);
        atom.setFrag(this);
    }

    int getAtomCount() {
        return this.atomCollection.size();
    }

    List<Atom> getAtomList() {
        return new ArrayList<Atom>(this.atomCollection);
    }

    void addBond(Bond bond) {
        this.bondSet.add(bond);
    }

    boolean removeBond(Bond bond) {
        return this.bondSet.remove(bond);
    }

    Set<Bond> getBondSet() {
        return Collections.unmodifiableSet(this.bondSet);
    }

    int getIDFromLocant(String locant) {
        Atom a = this.getAtomByLocant(locant);
        if (a != null) {
            return a.getID();
        }
        return 0;
    }

    int getIDFromLocantOrThrow(String locant) throws StructureBuildingException {
        int id = this.getIDFromLocant(locant);
        if (id == 0) {
            throw new StructureBuildingException("Couldn't find id from locant " + locant + ".");
        }
        return id;
    }

    Atom getAtomByLocant(String locant) {
        Atom a = this.atomMapFromLocant.get(locant);
        if (a != null) {
            return a;
        }
        Matcher m = OpsinTools.MATCH_AMINOACID_STYLE_LOCANT.matcher(locant);
        if (m.matches()) {
            Atom backboneAtom = this.atomMapFromLocant.get(m.group(3));
            if (backboneAtom == null) {
                return null;
            }
            a = FragmentTools.getAtomByAminoAcidStyleLocant(backboneAtom, m.group(1), m.group(2));
            if (a != null) {
                return a;
            }
        }
        return null;
    }

    Atom getAtomByLocantOrThrow(String locant) throws StructureBuildingException {
        Atom a = this.getAtomByLocant(locant);
        if (a == null) {
            throw new StructureBuildingException("Could not find the atom with locant " + locant + ".");
        }
        return a;
    }

    Atom getAtomByID(int id) {
        return this.atomMapFromId.get(id);
    }

    Atom getAtomByIDOrThrow(int id) throws StructureBuildingException {
        Atom a = this.getAtomByID(id);
        if (a == null) {
            throw new StructureBuildingException("Couldn't find atom with id " + id + ".");
        }
        return a;
    }

    Bond findBond(int ID1, int ID2) {
        Atom a = this.atomMapFromId.get(ID1);
        if (a != null) {
            for (Bond b : a.getBonds()) {
                if ((b.getFrom() != ID1 || b.getTo() != ID2) && (b.getTo() != ID1 || b.getFrom() != ID2)) continue;
                return b;
            }
        }
        return null;
    }

    Bond findBondOrThrow(int ID1, int ID2) throws StructureBuildingException {
        Bond b = this.findBond(ID1, ID2);
        if (b == null) {
            throw new StructureBuildingException("Couldn't find specified bond");
        }
        return b;
    }

    int getChainLength() {
        int length = 0;
        Atom next = this.getAtomByLocant(Integer.toString(length + 1));
        Atom previous = null;
        while (next != null && (previous == null || previous.getBondToAtom(next) != null)) {
            previous = next;
            next = this.getAtomByLocant(Integer.toString(++length + 1));
        }
        return length;
    }

    String getType() {
        String type = this.tokenEl.getAttributeValue("type");
        return type != null ? type : "";
    }

    String getSubType() {
        String subType = this.tokenEl.getAttributeValue("subType");
        return subType != null ? subType : "";
    }

    Element getTokenEl() {
        return this.tokenEl;
    }

    void setTokenEl(Element tokenEl) {
        this.tokenEl = tokenEl;
    }

    int getOutAtomCount() {
        return this.outAtoms.size();
    }

    OutAtom getOutAtom(int i) {
        return this.outAtoms.get(i);
    }

    void addOutAtom(int id, int valency, Boolean setExplicitly) throws StructureBuildingException {
        this.addOutAtom(this.getAtomByIDOrThrow(id), valency, setExplicitly);
    }

    void addOutAtom(Atom atom, int valency, Boolean setExplicitly) {
        this.outAtoms.add(new OutAtom(atom, valency, setExplicitly));
    }

    void incorporateOutAtoms(Fragment frag) {
        this.outAtoms.addAll(frag.outAtoms);
    }

    void removeOutAtom(int i) {
        OutAtom removedOutAtom = this.outAtoms.remove(i);
        if (removedOutAtom.isSetExplicitly()) {
            removedOutAtom.getAtom().addOutValency(-removedOutAtom.getValency());
        }
    }

    void removeOutAtom(OutAtom outAtom) {
        if (this.outAtoms.remove(outAtom) && outAtom.isSetExplicitly()) {
            outAtom.getAtom().addOutValency(-outAtom.getValency());
        }
    }

    int getFunctionalAtomCount() {
        return this.functionalAtoms.size();
    }

    FunctionalAtom getFunctionalAtom(int i) {
        return this.functionalAtoms.get(i);
    }

    void addFunctionalAtom(Atom atom) {
        this.functionalAtoms.add(new FunctionalAtom(atom));
    }

    void incorporateFunctionalAtoms(Fragment frag) {
        this.functionalAtoms.addAll(frag.functionalAtoms);
    }

    FunctionalAtom removeFunctionalAtom(int i) {
        return this.functionalAtoms.remove(i);
    }

    void removeFunctionalAtom(FunctionalAtom functionalAtom) {
        this.functionalAtoms.remove(functionalAtom);
    }

    List<Atom> getPolymerAttachmentPoints() {
        return this.polymerAttachmentPoints;
    }

    void setPolymerAttachmentPoints(List<Atom> polymerAttachmentPoints) {
        this.polymerAttachmentPoints = polymerAttachmentPoints;
    }

    List<Atom> getIntraFragmentAtomNeighbours(Atom atom) {
        ArrayList<Atom> results = new ArrayList<Atom>(atom.getBondCount());
        for (Bond b : atom.getBonds()) {
            Atom otherAtom = b.getOtherAtom(atom);
            if (otherAtom == null) {
                throw new RuntimeException("OPSIN Bug: A bond associated with an atom does not involve it");
            }
            if (this.atomMapFromId.get(otherAtom.getID()) == null) continue;
            results.add(otherAtom);
        }
        return results;
    }

    int getIntraFragmentIncomingValency(Atom atom) throws StructureBuildingException {
        int v = 0;
        for (Bond b : atom.getBonds()) {
            Atom a;
            if (b.getFromAtom() == atom) {
                a = this.getAtomByID(b.getTo());
                if (a == null || a.getType().equals("suffix")) continue;
                v += b.getOrder();
                continue;
            }
            if (b.getToAtom() == atom) {
                a = this.getAtomByID(b.getFrom());
                if (a == null || a.getType().equals("suffix")) continue;
                v += b.getOrder();
                continue;
            }
            throw new StructureBuildingException("A bond associated with an atom does not involve it");
        }
        return v;
    }

    void checkValencies() throws StructureBuildingException {
        for (Atom a : this.atomCollection) {
            if (ValencyChecker.checkValency(a)) continue;
            throw new StructureBuildingException("Atom is in unphysical valency state! Element: " + (Object)((Object)a.getElement()) + " valency: " + a.getIncomingValency());
        }
    }

    void removeAtom(Atom atom) {
        int atomID = atom.getID();
        this.atomMapFromId.remove(atomID);
        for (String l : atom.getLocants()) {
            this.atomMapFromLocant.remove(l);
        }
        if (this.defaultInAtom == atom) {
            this.defaultInAtom = null;
        }
    }

    int getCharge() {
        int charge = 0;
        for (Atom a : this.atomCollection) {
            charge += a.getCharge();
        }
        return charge;
    }

    Atom getDefaultInAtom() {
        return this.defaultInAtom;
    }

    void setDefaultInAtom(Atom inAtom) {
        this.defaultInAtom = inAtom;
    }

    Atom getDefaultInAtomOrFirstAtom() {
        return this.defaultInAtom != null ? this.defaultInAtom : this.getFirstAtom();
    }

    void addMappingToAtomLocantMap(String locant, Atom a) {
        this.atomMapFromLocant.put(locant, a);
    }

    void removeMappingFromAtomLocantMap(String locant) {
        this.atomMapFromLocant.remove(locant);
    }

    boolean hasLocant(String locant) {
        return this.getAtomByLocant(locant) != null;
    }

    Set<String> getLocants() {
        return Collections.unmodifiableSet(this.atomMapFromLocant.keySet());
    }

    List<Atom> getIndicatedHydrogen() {
        return this.indicatedHydrogen;
    }

    void addIndicatedHydrogen(Atom atom) {
        this.indicatedHydrogen.add(atom);
    }

    int getIdOfFirstAtom() {
        return this.getFirstAtom().getID();
    }

    Atom getFirstAtom() {
        Iterator<Atom> atomIterator = this.atomCollection.iterator();
        if (atomIterator.hasNext()) {
            return atomIterator.next();
        }
        return null;
    }

    void reorderAtomCollection(List<Atom> atomList) throws StructureBuildingException {
        if (this.atomMapFromId.size() != atomList.size()) {
            throw new StructureBuildingException("atom list is not the same size as the number of atoms in the fragment");
        }
        this.atomMapFromId.clear();
        for (Atom atom : atomList) {
            this.atomMapFromId.put(atom.getID(), atom);
        }
    }

    void sortAtomListByLocant() throws StructureBuildingException {
        List<Atom> atomList = this.getAtomList();
        Collections.sort(atomList, new FragmentTools.SortByLocants());
        this.reorderAtomCollection(atomList);
    }

    @Override
    public Iterator<Atom> iterator() {
        return this.atomCollection.iterator();
    }
}

