/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import uk.ac.cam.ch.wwmm.opsin.Atom;
import uk.ac.cam.ch.wwmm.opsin.Element;
import uk.ac.cam.ch.wwmm.opsin.Fragment;
import uk.ac.cam.ch.wwmm.opsin.FunctionalAtom;
import uk.ac.cam.ch.wwmm.opsin.OpsinTools;
import uk.ac.cam.ch.wwmm.opsin.OutAtom;
import uk.ac.cam.ch.wwmm.opsin.StructureBuildingException;

class BuildResults {
    private final List<OutAtom> outAtoms = new ArrayList<OutAtom>();
    private final List<FunctionalAtom> functionalAtoms = new ArrayList<FunctionalAtom>();
    private final Set<Fragment> fragments = new LinkedHashSet<Fragment>();

    BuildResults(Element wordSubOrBracket) {
        List<Element> groups = OpsinTools.getDescendantElementsWithTagName(wordSubOrBracket, "group");
        for (Element group : groups) {
            Element parent;
            Fragment frag = group.getFrag();
            this.fragments.add(frag);
            int l = frag.getOutAtomCount();
            for (int i = 0; i < l; ++i) {
                this.outAtoms.add(frag.getOutAtom(i));
            }
            int functionalAtomCount = frag.getFunctionalAtomCount();
            if (functionalAtomCount <= 0 || !(parent = group.getParent()).getName().equals("root") && OpsinTools.getNextGroup(group) != null) continue;
            for (int i = 0; i < functionalAtomCount; ++i) {
                this.functionalAtoms.add(frag.getFunctionalAtom(i));
            }
        }
    }

    BuildResults() {
    }

    Set<Fragment> getFragments() {
        return Collections.unmodifiableSet(this.fragments);
    }

    int getFragmentCount() {
        return this.fragments.size();
    }

    OutAtom getOutAtom(int i) {
        return this.outAtoms.get(i);
    }

    int getOutAtomCount() {
        return this.outAtoms.size();
    }

    OutAtom removeOutAtom(int i) {
        OutAtom outAtom = this.outAtoms.get(i);
        outAtom.getAtom().getFrag().removeOutAtom(outAtom);
        return this.outAtoms.remove(i);
    }

    void removeAllOutAtoms() {
        for (int i = this.outAtoms.size() - 1; i >= 0; --i) {
            this.removeOutAtom(i);
        }
    }

    Atom getFunctionalAtom(int i) {
        return this.functionalAtoms.get(i).getAtom();
    }

    FunctionalAtom removeFunctionalAtom(int i) {
        FunctionalAtom functionalAtom = this.functionalAtoms.get(i);
        functionalAtom.getAtom().getFrag().removeFunctionalAtom(functionalAtom);
        return this.functionalAtoms.remove(i);
    }

    int getFunctionalAtomCount() {
        return this.functionalAtoms.size();
    }

    OutAtom getFirstOutAtom() {
        return this.outAtoms.get(0);
    }

    Atom getAtomByIdOrThrow(int id) throws StructureBuildingException {
        for (Fragment fragment : this.fragments) {
            Atom outAtom = fragment.getAtomByID(id);
            if (outAtom == null) continue;
            return outAtom;
        }
        throw new StructureBuildingException("No fragment contained this id: " + id);
    }

    void mergeBuildResults(BuildResults otherBR) {
        this.outAtoms.addAll(otherBR.outAtoms);
        this.functionalAtoms.addAll(otherBR.functionalAtoms);
        this.fragments.addAll(otherBR.fragments);
    }

    int getCharge() {
        int totalCharge = 0;
        for (Fragment frag : this.fragments) {
            totalCharge += frag.getCharge();
        }
        return totalCharge;
    }
}

