/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import uk.ac.cam.ch.wwmm.opsin.Atom;
import uk.ac.cam.ch.wwmm.opsin.BondStereo;

class Bond {
    private final Atom from;
    private final Atom to;
    private int order;
    private SMILES_BOND_DIRECTION smilesBondDirection = null;
    private BondStereo bondStereo = null;

    Bond(Atom from, Atom to, int order) {
        if (from == to) {
            throw new IllegalArgumentException("Bonds must be made between different atoms");
        }
        if (order < 1 || order > 3) {
            throw new IllegalArgumentException("Bond order must be 1, 2 or 3");
        }
        if (from == null) {
            throw new IllegalArgumentException("From atom was null!");
        }
        if (to == null) {
            throw new IllegalArgumentException("To atom was null!");
        }
        this.from = from;
        this.to = to;
        this.order = order;
    }

    int getFrom() {
        return this.from.getID();
    }

    int getTo() {
        return this.to.getID();
    }

    int getOrder() {
        return this.order;
    }

    void setOrder(int order) {
        this.order = order;
    }

    Atom getFromAtom() {
        return this.from;
    }

    Atom getToAtom() {
        return this.to;
    }

    void addOrder(int o) {
        this.order += o;
    }

    SMILES_BOND_DIRECTION getSmilesStereochemistry() {
        return this.smilesBondDirection;
    }

    void setSmilesStereochemistry(SMILES_BOND_DIRECTION bondDirection) {
        this.smilesBondDirection = bondDirection;
    }

    BondStereo getBondStereo() {
        return this.bondStereo;
    }

    void setBondStereo(BondStereo bondStereo) {
        this.bondStereo = bondStereo;
    }

    void setBondStereoElement(Atom[] atomRefs4, BondStereo.BondStereoValue cOrT) {
        this.bondStereo = new BondStereo(atomRefs4, cOrT);
    }

    Atom getOtherAtom(Atom atom) {
        if (this.from == atom) {
            return this.to;
        }
        if (this.to == atom) {
            return this.from;
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.from.getID();
        result = 31 * result + this.to.getID();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Bond other = (Bond)obj;
        if (this.from == other.from && this.to == other.to) {
            return true;
        }
        return this.from == other.to && this.to == other.from;
    }

    static enum SMILES_BOND_DIRECTION {
        RSLASH,
        LSLASH;

    }
}

