/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.ch.wwmm.opsin;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import uk.ac.cam.ch.wwmm.opsin.Atom;
import uk.ac.cam.ch.wwmm.opsin.Bond;
import uk.ac.cam.ch.wwmm.opsin.ChemEl;
import uk.ac.cam.ch.wwmm.opsin.StereoAnalyser;
import uk.ac.cam.ch.wwmm.opsin.StructureBuildingMethods;

class AmbiguityChecker {
    AmbiguityChecker() {
    }

    static boolean isSubstitutionAmbiguous(List<Atom> substitutableAtoms, int numberToBeSubstituted) {
        if (substitutableAtoms.isEmpty()) {
            throw new IllegalArgumentException("OPSIN Bug: Must provide at least one substituable atom");
        }
        if (substitutableAtoms.size() < numberToBeSubstituted) {
            throw new IllegalArgumentException("OPSIN Bug: substitutableAtoms must be >= numberToBeSubstituted");
        }
        if (substitutableAtoms.size() == numberToBeSubstituted) {
            return false;
        }
        if (AmbiguityChecker.allAtomsConnectToDefaultInAtom(substitutableAtoms, numberToBeSubstituted)) {
            return false;
        }
        HashSet<Atom> uniqueAtoms = new HashSet<Atom>(substitutableAtoms);
        if (uniqueAtoms.size() == 1) {
            return false;
        }
        return !AmbiguityChecker.allAtomsEquivalent(uniqueAtoms) || numberToBeSubstituted != 1 && numberToBeSubstituted != substitutableAtoms.size() - 1;
    }

    static boolean allAtomsEquivalent(Collection<Atom> atoms) {
        StereoAnalyser analyser = AmbiguityChecker.analyseRelevantAtomsAndBonds(atoms);
        HashSet<String> uniqueEnvironments = new HashSet<String>();
        for (Atom a : atoms) {
            uniqueEnvironments.add(AmbiguityChecker.getAtomEnviron(analyser, a));
        }
        return uniqueEnvironments.size() == 1;
    }

    static boolean allBondsEquivalent(Collection<Bond> bonds) {
        HashSet<Atom> relevantAtoms = new HashSet<Atom>();
        for (Bond b : bonds) {
            relevantAtoms.add(b.getFromAtom());
            relevantAtoms.add(b.getToAtom());
        }
        StereoAnalyser analyser = AmbiguityChecker.analyseRelevantAtomsAndBonds(relevantAtoms);
        HashSet<String> uniqueBonds = new HashSet<String>();
        for (Bond b : bonds) {
            uniqueBonds.add(AmbiguityChecker.bondToCanonicalEnvironString(analyser, b));
        }
        return uniqueBonds.size() == 1;
    }

    private static String bondToCanonicalEnvironString(StereoAnalyser analyser, Bond b) {
        String s2;
        String s1 = AmbiguityChecker.getAtomEnviron(analyser, b.getFromAtom());
        if (s1.compareTo(s2 = AmbiguityChecker.getAtomEnviron(analyser, b.getToAtom())) > 0) {
            return s1 + s2;
        }
        return s2 + s1;
    }

    static String getAtomEnviron(StereoAnalyser analyser, Atom a) {
        Integer env = analyser.getAtomEnvironmentNumber(a);
        if (env == null) {
            throw new RuntimeException("OPSIN Bug: Atom was not part of ambiguity analysis");
        }
        return env + "\t" + a.getOutValency();
    }

    private static boolean allAtomsConnectToDefaultInAtom(List<Atom> substitutableAtoms, int numberToBeSubstituted) {
        Atom defaultInAtom = substitutableAtoms.get(0).getFrag().getDefaultInAtom();
        if (defaultInAtom != null) {
            for (int i = 0; i < numberToBeSubstituted; ++i) {
                if (substitutableAtoms.get(i).equals(defaultInAtom)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    static StereoAnalyser analyseRelevantAtomsAndBonds(Collection<Atom> startingAtoms) {
        HashSet<Atom> atoms = new HashSet<Atom>();
        HashSet<Bond> bonds = new HashSet<Bond>();
        ArrayDeque<Atom> stack = new ArrayDeque<Atom>(startingAtoms);
        while (!stack.isEmpty()) {
            Atom a = (Atom)stack.removeLast();
            if (atoms.contains(a)) continue;
            atoms.add(a);
            for (Bond b : a.getBonds()) {
                bonds.add(b);
                stack.add(b.getOtherAtom(a));
            }
        }
        ArrayList<Atom> ghostHydrogens = new ArrayList<Atom>();
        for (Atom atom : atoms) {
            int explicitHydrogensToAdd = StructureBuildingMethods.calculateSubstitutableHydrogenAtoms(atom);
            for (int i = 0; i < explicitHydrogensToAdd; ++i) {
                Atom ghostHydrogen = new Atom(ChemEl.H);
                Bond b = new Bond(ghostHydrogen, atom, 1);
                atom.addBond(b);
                ghostHydrogen.addBond(b);
                ghostHydrogens.add(ghostHydrogen);
            }
        }
        atoms.addAll(ghostHydrogens);
        StereoAnalyser analyzer = new StereoAnalyser(atoms, bonds);
        for (Atom ghostHydrogen : ghostHydrogens) {
            Bond b = ghostHydrogen.getFirstBond();
            b.getOtherAtom(ghostHydrogen).removeBond(b);
        }
        return analyzer;
    }

    static List<Atom> useAtomEnvironmentsToGivePlausibleSubstitution(List<Atom> substitutableAtoms, int numberToBeSubstituted) {
        if (substitutableAtoms.isEmpty()) {
            throw new IllegalArgumentException("OPSIN Bug: Must provide at least one substituable atom");
        }
        if (substitutableAtoms.size() < numberToBeSubstituted) {
            throw new IllegalArgumentException("OPSIN Bug: substitutableAtoms must be >= numberToBeSubstituted");
        }
        if (substitutableAtoms.size() == numberToBeSubstituted) {
            return substitutableAtoms;
        }
        List<Atom> preferredAtoms = AmbiguityChecker.findPlausibleSubstitutionPatternUsingSymmmetry(substitutableAtoms, numberToBeSubstituted);
        if (preferredAtoms != null) {
            return preferredAtoms;
        }
        return AmbiguityChecker.findPlausibleSubstitutionPatternUsingLocalEnvironment(substitutableAtoms, numberToBeSubstituted);
    }

    private static List<Atom> findPlausibleSubstitutionPatternUsingSymmmetry(List<Atom> substitutableAtoms, int numberToBeSubstituted) {
        StereoAnalyser analyser = AmbiguityChecker.analyseRelevantAtomsAndBonds(new HashSet<Atom>(substitutableAtoms));
        HashMap<String, ArrayList<Atom>> atomsInEachEnvironment = new HashMap<String, ArrayList<Atom>>();
        for (Atom a : substitutableAtoms) {
            String env = AmbiguityChecker.getAtomEnviron(analyser, a);
            ArrayList<Atom> atomsInEnvironment = (ArrayList<Atom>)atomsInEachEnvironment.get(env);
            if (atomsInEnvironment == null) {
                atomsInEnvironment = new ArrayList<Atom>();
                atomsInEachEnvironment.put(env, atomsInEnvironment);
            }
            atomsInEnvironment.add(a);
        }
        ArrayList preferredAtoms = null;
        for (List atoms : atomsInEachEnvironment.values()) {
            if (atoms.size() != numberToBeSubstituted) continue;
            if (preferredAtoms != null) {
                return null;
            }
            preferredAtoms = atoms;
        }
        if (preferredAtoms == null) {
            for (List atoms : atomsInEachEnvironment.values()) {
                LinkedHashSet uniquified;
                if (atoms.size() != numberToBeSubstituted * 2 || (uniquified = new LinkedHashSet(atoms)).size() != numberToBeSubstituted) continue;
                if (preferredAtoms != null) {
                    return null;
                }
                preferredAtoms = new ArrayList(uniquified);
            }
        }
        return preferredAtoms;
    }

    private static List<Atom> findPlausibleSubstitutionPatternUsingLocalEnvironment(List<Atom> substitutableAtoms, int numberToBeSubstituted) {
        HashMap<String, ArrayList<Atom>> atomsInEachLocalEnvironment = new HashMap<String, ArrayList<Atom>>();
        for (Atom a : substitutableAtoms) {
            int valency = a.determineValency(true);
            int currentValency = a.getIncomingValency() + a.getOutValency();
            int numOfBonds = valency - currentValency + a.getBondCount();
            String s = a.getElement().toString() + "\t" + valency + "\t" + numOfBonds + "\t" + a.hasSpareValency();
            ArrayList<Atom> atomsInEnvironment = (ArrayList<Atom>)atomsInEachLocalEnvironment.get(s);
            if (atomsInEnvironment == null) {
                atomsInEnvironment = new ArrayList<Atom>();
                atomsInEachLocalEnvironment.put(s, atomsInEnvironment);
            }
            atomsInEnvironment.add(a);
        }
        List preferredAtoms = null;
        for (List atoms : atomsInEachLocalEnvironment.values()) {
            if (atoms.size() != numberToBeSubstituted) continue;
            if (preferredAtoms != null) {
                return null;
            }
            preferredAtoms = atoms;
        }
        return preferredAtoms;
    }
}

