import itertools
from libcst import *


class ChildLinksInserter(CSTTransformer):
    def __init__(self, parent, child, parents, children, parent_ref):
        self.parent = parent
        self.child = child
        self.parents = parents
        self.children = children
        self.parent_ref = parent_ref

    def leave_FunctionDef(self, original_node, updated_node):
        if (not original_node.name.value == f'_add_links_to_{self.child}') and (not original_node.name.value == 'add_hooks'):
            return original_node

        new_body = []
        for item in original_node.body.body:
            new_body.append(item)

        if original_node.name.value == f'_add_links_to_{self.child}':
            new_body.append(self.make_parent_link())
        if original_node.name.value == 'add_hooks':
            new_body.extend(self.add_rel_hooks())

        return updated_node.with_changes(
            body=updated_node.body.with_changes(
                body=new_body
            )
        )

    def make_parent_link(self):
        return If(
            test=Call(
                func=Attribute(
                    value=Name(
                        value=f'{self.child}',
                        lpar=[],
                        rpar=[],
                    ),
                    attr=Name(
                        value='get',
                        lpar=[],
                        rpar=[],
                    ),
                    dot=Dot(
                        whitespace_before=SimpleWhitespace(
                            value='',
                        ),
                        whitespace_after=SimpleWhitespace(
                            value='',
                        ),
                    ),
                    lpar=[],
                    rpar=[],
                ),
                args=[
                    Arg(
                        value=SimpleString(
                            value=f"'{self.parent_ref}'",
                            lpar=[],
                            rpar=[],
                        ),
                        keyword=None,
                        equal=MaybeSentinel.DEFAULT,
                        comma=MaybeSentinel.DEFAULT,
                        star='',
                        whitespace_after_star=SimpleWhitespace(
                            value='',
                        ),
                        whitespace_after_arg=SimpleWhitespace(
                            value='',
                        ),
                    ),
                ],
                lpar=[],
                rpar=[],
                whitespace_after_func=SimpleWhitespace(
                    value='',
                ),
                whitespace_before_args=SimpleWhitespace(
                    value='',
                ),
            ),
            body=IndentedBlock(
                body=[
                    SimpleStatementLine(
                        body=[
                            Assign(
                                targets=[
                                    AssignTarget(
                                        target=Subscript(
                                            value=Subscript(
                                                value=Name(
                                                    value=f'{self.child}',
                                                    lpar=[],
                                                    rpar=[],
                                                ),
                                                slice=[
                                                    SubscriptElement(
                                                        slice=Index(
                                                            value=SimpleString(
                                                                value="'_links'",
                                                                lpar=[],
                                                                rpar=[],
                                                            ),
                                                        ),
                                                        comma=MaybeSentinel.DEFAULT,
                                                    ),
                                                ],
                                                lbracket=LeftSquareBracket(
                                                    whitespace_after=SimpleWhitespace(
                                                        value='',
                                                    ),
                                                ),
                                                rbracket=RightSquareBracket(
                                                    whitespace_before=SimpleWhitespace(
                                                        value='',
                                                    ),
                                                ),
                                                lpar=[],
                                                rpar=[],
                                                whitespace_after_value=SimpleWhitespace(
                                                    value='',
                                                ),
                                            ),
                                            slice=[
                                                SubscriptElement(
                                                    slice=Index(
                                                        value=SimpleString(
                                                            value="'parent'",
                                                            lpar=[],
                                                            rpar=[],
                                                        ),
                                                    ),
                                                    comma=MaybeSentinel.DEFAULT,
                                                ),
                                            ],
                                            lbracket=LeftSquareBracket(
                                                whitespace_after=SimpleWhitespace(
                                                    value='',
                                                ),
                                            ),
                                            rbracket=RightSquareBracket(
                                                whitespace_before=SimpleWhitespace(
                                                    value='',
                                                ),
                                            ),
                                            lpar=[],
                                            rpar=[],
                                            whitespace_after_value=SimpleWhitespace(
                                                value='',
                                            ),
                                        ),
                                        whitespace_before_equal=SimpleWhitespace(
                                            value=' ',
                                        ),
                                        whitespace_after_equal=SimpleWhitespace(
                                            value=' ',
                                        ),
                                    ),
                                ],
                                value=Dict(
                                    elements=[
                                        DictElement(
                                            key=SimpleString(
                                                value="'href'",
                                                lpar=[],
                                                rpar=[],
                                            ),
                                            value=FormattedString(  # ding (make_parent_link, 1)
                                                parts=[
                                                    FormattedStringText(
                                                        value=f'/{self.parents}/',
                                                    ),
                                                    FormattedStringExpression(
                                                        expression=Subscript(
                                                            value=Name(
                                                                value=f'{self.child}',
                                                                lpar=[],
                                                                rpar=[],
                                                            ),
                                                            slice=[
                                                                SubscriptElement(
                                                                    slice=Index(
                                                                        value=SimpleString(
                                                                            value=f'"{self.parent_ref}"',
                                                                            lpar=[],
                                                                            rpar=[],
                                                                        ),
                                                                    ),
                                                                    comma=MaybeSentinel.DEFAULT,
                                                                ),
                                                            ],
                                                            lbracket=LeftSquareBracket(
                                                                whitespace_after=SimpleWhitespace(
                                                                    value='',
                                                                ),
                                                            ),
                                                            rbracket=RightSquareBracket(
                                                                whitespace_before=SimpleWhitespace(
                                                                    value='',
                                                                ),
                                                            ),
                                                            lpar=[],
                                                            rpar=[],
                                                            whitespace_after_value=SimpleWhitespace(
                                                                value='',
                                                            ),
                                                        ),
                                                        conversion=None,
                                                        format_spec=None,
                                                        whitespace_before_expression=SimpleWhitespace(
                                                            value='',
                                                        ),
                                                        whitespace_after_expression=SimpleWhitespace(
                                                            value='',
                                                        ),
                                                        equal=None,
                                                    ),
                                                ],
                                                start="f'",
                                                end="'",
                                                lpar=[],
                                                rpar=[],
                                            ),
                                            comma=Comma(
                                                whitespace_before=SimpleWhitespace(
                                                    value='',
                                                ),
                                                whitespace_after=ParenthesizedWhitespace(
                                                    first_line=TrailingWhitespace(
                                                        whitespace=SimpleWhitespace(
                                                            value='',
                                                        ),
                                                        comment=None,
                                                        newline=Newline(
                                                            value=None,
                                                        ),
                                                    ),
                                                    empty_lines=[],
                                                    indent=True,
                                                    last_line=SimpleWhitespace(
                                                        value='    ',
                                                    ),
                                                ),
                                            ),
                                            whitespace_before_colon=SimpleWhitespace(
                                                value='',
                                            ),
                                            whitespace_after_colon=SimpleWhitespace(
                                                value=' ',
                                            ),
                                        ),
                                        DictElement(
                                            key=SimpleString(
                                                value="'title'",
                                                lpar=[],
                                                rpar=[],
                                            ),
                                            value=SimpleString(
                                                value=f"'{self.parents}'",
                                                lpar=[],
                                                rpar=[],
                                            ),
                                            comma=MaybeSentinel.DEFAULT,
                                            whitespace_before_colon=SimpleWhitespace(
                                                value='',
                                            ),
                                            whitespace_after_colon=SimpleWhitespace(
                                                value=' ',
                                            ),
                                        ),
                                    ],
                                    lbrace=LeftCurlyBrace(
                                        whitespace_after=ParenthesizedWhitespace(
                                            first_line=TrailingWhitespace(
                                                whitespace=SimpleWhitespace(
                                                    value='',
                                                ),
                                                comment=None,
                                                newline=Newline(
                                                    value=None,
                                                ),
                                            ),
                                            empty_lines=[],
                                            indent=True,
                                            last_line=SimpleWhitespace(
                                                value='    ',
                                            ),
                                        ),
                                    ),
                                    rbrace=RightCurlyBrace(
                                        whitespace_before=ParenthesizedWhitespace(
                                            first_line=TrailingWhitespace(
                                                whitespace=SimpleWhitespace(
                                                    value='',
                                                ),
                                                comment=None,
                                                newline=Newline(
                                                    value=None,
                                                ),
                                            ),
                                            empty_lines=[],
                                            indent=True,
                                            last_line=SimpleWhitespace(
                                                value='',
                                            ),
                                        ),
                                    ),
                                    lpar=[],
                                    rpar=[],
                                ),
                                semicolon=MaybeSentinel.DEFAULT,
                            ),
                        ],
                        leading_lines=[],
                        trailing_whitespace=TrailingWhitespace(
                            whitespace=SimpleWhitespace(
                                value='',
                            ),
                            comment=None,
                            newline=Newline(
                                value=None,
                            ),
                        ),
                    ),
                    SimpleStatementLine(
                        body=[
                            Assign(
                                targets=[
                                    AssignTarget(
                                        target=Subscript(
                                            value=Subscript(
                                                value=Name(
                                                    value=f'{self.child}',
                                                    lpar=[],
                                                    rpar=[],
                                                ),
                                                slice=[
                                                    SubscriptElement(
                                                        slice=Index(
                                                            value=SimpleString(
                                                                value="'_links'",
                                                                lpar=[],
                                                                rpar=[],
                                                            ),
                                                        ),
                                                        comma=MaybeSentinel.DEFAULT,
                                                    ),
                                                ],
                                                lbracket=LeftSquareBracket(
                                                    whitespace_after=SimpleWhitespace(
                                                        value='',
                                                    ),
                                                ),
                                                rbracket=RightSquareBracket(
                                                    whitespace_before=SimpleWhitespace(
                                                        value='',
                                                    ),
                                                ),
                                                lpar=[],
                                                rpar=[],
                                                whitespace_after_value=SimpleWhitespace(
                                                    value='',
                                                ),
                                            ),
                                            slice=[
                                                SubscriptElement(
                                                    slice=Index(
                                                        value=SimpleString(
                                                            value="'collection'",
                                                            lpar=[],
                                                            rpar=[],
                                                        ),
                                                    ),
                                                    comma=MaybeSentinel.DEFAULT,
                                                ),
                                            ],
                                            lbracket=LeftSquareBracket(
                                                whitespace_after=SimpleWhitespace(
                                                    value='',
                                                ),
                                            ),
                                            rbracket=RightSquareBracket(
                                                whitespace_before=SimpleWhitespace(
                                                    value='',
                                                ),
                                            ),
                                            lpar=[],
                                            rpar=[],
                                            whitespace_after_value=SimpleWhitespace(
                                                value='',
                                            ),
                                        ),
                                        whitespace_before_equal=SimpleWhitespace(
                                            value=' ',
                                        ),
                                        whitespace_after_equal=SimpleWhitespace(
                                            value=' ',
                                        ),
                                    ),
                                ],
                                value=Dict(
                                    elements=[
                                        DictElement(
                                            key=SimpleString(
                                                value="'href'",
                                                lpar=[],
                                                rpar=[],
                                            ),
                                            value=FormattedString(  # ding (make_parent_link, 2)
                                                parts=[
                                                    FormattedStringText(
                                                        value=f'/{self.parents}/',
                                                    ),
                                                    FormattedStringExpression(
                                                        expression=Subscript(
                                                            value=Name(
                                                                value=f'{self.child}',
                                                                lpar=[],
                                                                rpar=[],
                                                            ),
                                                            slice=[
                                                                SubscriptElement(
                                                                    slice=Index(
                                                                        value=SimpleString(
                                                                            value=f'"{self.parent_ref}"',
                                                                            lpar=[],
                                                                            rpar=[],
                                                                        ),
                                                                    ),
                                                                    comma=MaybeSentinel.DEFAULT,
                                                                ),
                                                            ],
                                                            lbracket=LeftSquareBracket(
                                                                whitespace_after=SimpleWhitespace(
                                                                    value='',
                                                                ),
                                                            ),
                                                            rbracket=RightSquareBracket(
                                                                whitespace_before=SimpleWhitespace(
                                                                    value='',
                                                                ),
                                                            ),
                                                            lpar=[],
                                                            rpar=[],
                                                            whitespace_after_value=SimpleWhitespace(
                                                                value='',
                                                            ),
                                                        ),
                                                        conversion=None,
                                                        format_spec=None,
                                                        whitespace_before_expression=SimpleWhitespace(
                                                            value='',
                                                        ),
                                                        whitespace_after_expression=SimpleWhitespace(
                                                            value='',
                                                        ),
                                                        equal=None,
                                                    ),
                                                    FormattedStringText(
                                                        value=f'/{self.children}',
                                                    ),
                                                ],
                                                start="f'",
                                                end="'",
                                                lpar=[],
                                                rpar=[],
                                            ),
                                            comma=Comma(
                                                whitespace_before=SimpleWhitespace(
                                                    value='',
                                                ),
                                                whitespace_after=ParenthesizedWhitespace(
                                                    first_line=TrailingWhitespace(
                                                        whitespace=SimpleWhitespace(
                                                            value='',
                                                        ),
                                                        comment=None,
                                                        newline=Newline(
                                                            value=None,
                                                        ),
                                                    ),
                                                    empty_lines=[],
                                                    indent=True,
                                                    last_line=SimpleWhitespace(
                                                        value='    ',
                                                    ),
                                                ),
                                            ),
                                            whitespace_before_colon=SimpleWhitespace(
                                                value='',
                                            ),
                                            whitespace_after_colon=SimpleWhitespace(
                                                value=' ',
                                            ),
                                        ),
                                        DictElement(
                                            key=SimpleString(
                                                value="'title'",
                                                lpar=[],
                                                rpar=[],
                                            ),
                                            value=SimpleString(
                                                value=f"'{self.parent}_{self.children}'",
                                                lpar=[],
                                                rpar=[],
                                            ),
                                            comma=MaybeSentinel.DEFAULT,
                                            whitespace_before_colon=SimpleWhitespace(
                                                value='',
                                            ),
                                            whitespace_after_colon=SimpleWhitespace(
                                                value=' ',
                                            ),
                                        ),
                                    ],
                                    lbrace=LeftCurlyBrace(
                                        whitespace_after=ParenthesizedWhitespace(
                                            first_line=TrailingWhitespace(
                                                whitespace=SimpleWhitespace(
                                                    value='',
                                                ),
                                                comment=None,
                                                newline=Newline(
                                                    value=None,
                                                ),
                                            ),
                                            empty_lines=[],
                                            indent=True,
                                            last_line=SimpleWhitespace(
                                                value='    ',
                                            ),
                                        ),
                                    ),
                                    rbrace=RightCurlyBrace(
                                        whitespace_before=ParenthesizedWhitespace(
                                            first_line=TrailingWhitespace(
                                                whitespace=SimpleWhitespace(
                                                    value='',
                                                ),
                                                comment=None,
                                                newline=Newline(
                                                    value=None,
                                                ),
                                            ),
                                            empty_lines=[],
                                            indent=True,
                                            last_line=SimpleWhitespace(
                                                value='',
                                            ),
                                        ),
                                    ),
                                    lpar=[],
                                    rpar=[],
                                ),
                                semicolon=MaybeSentinel.DEFAULT,
                            ),
                        ],
                        leading_lines=[],
                        trailing_whitespace=TrailingWhitespace(
                            whitespace=SimpleWhitespace(
                                value='',
                            ),
                            comment=None,
                            newline=Newline(
                                value=None,
                            ),
                        ),
                    ),
                ],
                header=TrailingWhitespace(
                    whitespace=SimpleWhitespace(
                        value='',
                    ),
                    comment=None,
                    newline=Newline(
                        value=None,
                    ),
                ),
                indent=None,
                footer=[],
            ),
            orelse=Else(
                body=IndentedBlock(
                    body=[
                        SimpleStatementLine(
                            body=[
                                Assign(
                                    targets=[
                                        AssignTarget(
                                            target=Subscript(
                                                value=Subscript(
                                                    value=Name(
                                                        value=f'{self.child}',
                                                        lpar=[],
                                                        rpar=[],
                                                    ),
                                                    slice=[
                                                        SubscriptElement(
                                                            slice=Index(
                                                                value=SimpleString(
                                                                    value="'_links'",
                                                                    lpar=[],
                                                                    rpar=[],
                                                                ),
                                                            ),
                                                            comma=MaybeSentinel.DEFAULT,
                                                        ),
                                                    ],
                                                    lbracket=LeftSquareBracket(
                                                        whitespace_after=SimpleWhitespace(
                                                            value='',
                                                        ),
                                                    ),
                                                    rbracket=RightSquareBracket(
                                                        whitespace_before=SimpleWhitespace(
                                                            value='',
                                                        ),
                                                    ),
                                                    lpar=[],
                                                    rpar=[],
                                                    whitespace_after_value=SimpleWhitespace(
                                                        value='',
                                                    ),
                                                ),
                                                slice=[
                                                    SubscriptElement(
                                                        slice=Index(
                                                            value=SimpleString(
                                                                value="'parent'",
                                                                lpar=[],
                                                                rpar=[],
                                                            ),
                                                        ),
                                                        comma=MaybeSentinel.DEFAULT,
                                                    ),
                                                ],
                                                lbracket=LeftSquareBracket(
                                                    whitespace_after=SimpleWhitespace(
                                                        value='',
                                                    ),
                                                ),
                                                rbracket=RightSquareBracket(
                                                    whitespace_before=SimpleWhitespace(
                                                        value='',
                                                    ),
                                                ),
                                                lpar=[],
                                                rpar=[],
                                                whitespace_after_value=SimpleWhitespace(
                                                    value='',
                                                ),
                                            ),
                                            whitespace_before_equal=SimpleWhitespace(
                                                value=' ',
                                            ),
                                            whitespace_after_equal=SimpleWhitespace(
                                                value=' ',
                                            ),
                                        ),
                                    ],
                                    value=Dict(
                                        elements=[
                                            DictElement(
                                                key=SimpleString(
                                                    value="'href'",
                                                    lpar=[],
                                                    rpar=[],
                                                ),
                                                value=SimpleString(
                                                    value="'/'",
                                                    lpar=[],
                                                    rpar=[],
                                                ),
                                                comma=Comma(
                                                    whitespace_before=SimpleWhitespace(
                                                        value='',
                                                    ),
                                                    whitespace_after=ParenthesizedWhitespace(
                                                        first_line=TrailingWhitespace(
                                                            whitespace=SimpleWhitespace(
                                                                value='',
                                                            ),
                                                            comment=None,
                                                            newline=Newline(
                                                                value=None,
                                                            ),
                                                        ),
                                                        empty_lines=[],
                                                        indent=True,
                                                        last_line=SimpleWhitespace(
                                                            value='    ',
                                                        ),
                                                    ),
                                                ),
                                                whitespace_before_colon=SimpleWhitespace(
                                                    value='',
                                                ),
                                                whitespace_after_colon=SimpleWhitespace(
                                                    value=' ',
                                                ),
                                            ),
                                            DictElement(
                                                key=SimpleString(
                                                    value="'title'",
                                                    lpar=[],
                                                    rpar=[],
                                                ),
                                                value=SimpleString(
                                                    value="'home'",
                                                    lpar=[],
                                                    rpar=[],
                                                ),
                                                comma=MaybeSentinel.DEFAULT,
                                                whitespace_before_colon=SimpleWhitespace(
                                                    value='',
                                                ),
                                                whitespace_after_colon=SimpleWhitespace(
                                                    value=' ',
                                                ),
                                            ),
                                        ],
                                        lbrace=LeftCurlyBrace(
                                            whitespace_after=ParenthesizedWhitespace(
                                                first_line=TrailingWhitespace(
                                                    whitespace=SimpleWhitespace(
                                                        value='',
                                                    ),
                                                    comment=None,
                                                    newline=Newline(
                                                        value=None,
                                                    ),
                                                ),
                                                empty_lines=[],
                                                indent=True,
                                                last_line=SimpleWhitespace(
                                                    value='    ',
                                                ),
                                            ),
                                        ),
                                        rbrace=RightCurlyBrace(
                                            whitespace_before=ParenthesizedWhitespace(
                                                first_line=TrailingWhitespace(
                                                    whitespace=SimpleWhitespace(
                                                        value='',
                                                    ),
                                                    comment=None,
                                                    newline=Newline(
                                                        value=None,
                                                    ),
                                                ),
                                                empty_lines=[],
                                                indent=True,
                                                last_line=SimpleWhitespace(
                                                    value='',
                                                ),
                                            ),
                                        ),
                                        lpar=[],
                                        rpar=[],
                                    ),
                                    semicolon=MaybeSentinel.DEFAULT,
                                ),
                            ],
                            leading_lines=[],
                            trailing_whitespace=TrailingWhitespace(
                                whitespace=SimpleWhitespace(
                                    value='',
                                ),
                                comment=None,
                                newline=Newline(
                                    value=None,
                                ),
                            ),
                        ),
                        SimpleStatementLine(
                            body=[
                                Assign(
                                    targets=[
                                        AssignTarget(
                                            target=Subscript(
                                                value=Subscript(
                                                    value=Name(
                                                        value=f'{self.child}',
                                                        lpar=[],
                                                        rpar=[],
                                                    ),
                                                    slice=[
                                                        SubscriptElement(
                                                            slice=Index(
                                                                value=SimpleString(
                                                                    value="'_links'",
                                                                    lpar=[],
                                                                    rpar=[],
                                                                ),
                                                            ),
                                                            comma=MaybeSentinel.DEFAULT,
                                                        ),
                                                    ],
                                                    lbracket=LeftSquareBracket(
                                                        whitespace_after=SimpleWhitespace(
                                                            value='',
                                                        ),
                                                    ),
                                                    rbracket=RightSquareBracket(
                                                        whitespace_before=SimpleWhitespace(
                                                            value='',
                                                        ),
                                                    ),
                                                    lpar=[],
                                                    rpar=[],
                                                    whitespace_after_value=SimpleWhitespace(
                                                        value='',
                                                    ),
                                                ),
                                                slice=[
                                                    SubscriptElement(
                                                        slice=Index(
                                                            value=SimpleString(
                                                                value="'collection'",
                                                                lpar=[],
                                                                rpar=[],
                                                            ),
                                                        ),
                                                        comma=MaybeSentinel.DEFAULT,
                                                    ),
                                                ],
                                                lbracket=LeftSquareBracket(
                                                    whitespace_after=SimpleWhitespace(
                                                        value='',
                                                    ),
                                                ),
                                                rbracket=RightSquareBracket(
                                                    whitespace_before=SimpleWhitespace(
                                                        value='',
                                                    ),
                                                ),
                                                lpar=[],
                                                rpar=[],
                                                whitespace_after_value=SimpleWhitespace(
                                                    value='',
                                                ),
                                            ),
                                            whitespace_before_equal=SimpleWhitespace(
                                                value=' ',
                                            ),
                                            whitespace_after_equal=SimpleWhitespace(
                                                value=' ',
                                            ),
                                        ),
                                    ],
                                    value=Dict(
                                        elements=[
                                            DictElement(
                                                key=SimpleString(
                                                    value="'href'",
                                                    lpar=[],
                                                    rpar=[],
                                                ),
                                                value=SimpleString(
                                                    value=f"'/{self.children}'",
                                                    lpar=[],
                                                    rpar=[],
                                                ),
                                                comma=Comma(
                                                    whitespace_before=SimpleWhitespace(
                                                        value='',
                                                    ),
                                                    whitespace_after=ParenthesizedWhitespace(
                                                        first_line=TrailingWhitespace(
                                                            whitespace=SimpleWhitespace(
                                                                value='',
                                                            ),
                                                            comment=None,
                                                            newline=Newline(
                                                                value=None,
                                                            ),
                                                        ),
                                                        empty_lines=[],
                                                        indent=True,
                                                        last_line=SimpleWhitespace(
                                                            value='    ',
                                                        ),
                                                    ),
                                                ),
                                                whitespace_before_colon=SimpleWhitespace(
                                                    value='',
                                                ),
                                                whitespace_after_colon=SimpleWhitespace(
                                                    value=' ',
                                                ),
                                            ),
                                            DictElement(
                                                key=SimpleString(
                                                    value="'title'",
                                                    lpar=[],
                                                    rpar=[],
                                                ),
                                                value=SimpleString(
                                                    value=f"'{self.children}'",
                                                    lpar=[],
                                                    rpar=[],
                                                ),
                                                comma=MaybeSentinel.DEFAULT,
                                                whitespace_before_colon=SimpleWhitespace(
                                                    value='',
                                                ),
                                                whitespace_after_colon=SimpleWhitespace(
                                                    value=' ',
                                                ),
                                            ),
                                        ],
                                        lbrace=LeftCurlyBrace(
                                            whitespace_after=ParenthesizedWhitespace(
                                                first_line=TrailingWhitespace(
                                                    whitespace=SimpleWhitespace(
                                                        value='',
                                                    ),
                                                    comment=None,
                                                    newline=Newline(
                                                        value=None,
                                                    ),
                                                ),
                                                empty_lines=[],
                                                indent=True,
                                                last_line=SimpleWhitespace(
                                                    value='    ',
                                                ),
                                            ),
                                        ),
                                        rbrace=RightCurlyBrace(
                                            whitespace_before=ParenthesizedWhitespace(
                                                first_line=TrailingWhitespace(
                                                    whitespace=SimpleWhitespace(
                                                        value='',
                                                    ),
                                                    comment=None,
                                                    newline=Newline(
                                                        value=None,
                                                    ),
                                                ),
                                                empty_lines=[],
                                                indent=True,
                                                last_line=SimpleWhitespace(
                                                    value='',
                                                ),
                                            ),
                                        ),
                                        lpar=[],
                                        rpar=[],
                                    ),
                                    semicolon=MaybeSentinel.DEFAULT,
                                ),
                            ],
                            leading_lines=[],
                            trailing_whitespace=TrailingWhitespace(
                                whitespace=SimpleWhitespace(
                                    value='',
                                ),
                                comment=None,
                                newline=Newline(
                                    value=None,
                                ),
                            ),
                        ),
                    ],
                    header=TrailingWhitespace(
                        whitespace=SimpleWhitespace(
                            value='',
                        ),
                        comment=None,
                        newline=Newline(
                            value=None,
                        ),
                    ),
                    indent=None,
                    footer=[],
                ),
                leading_lines=[],
                whitespace_before_colon=SimpleWhitespace(
                    value='',
                ),
            ),
            leading_lines=[],
            whitespace_before_test=SimpleWhitespace(
                value=' ',
            ),
            whitespace_after_test=SimpleWhitespace(
                value='',
            ),
        )

    def add_rel_hooks(self):
        return [
            SimpleStatementLine(
                body=[
                    AugAssign(
                        target=Attribute(
                            value=Name(
                                value='app',
                                lpar=[],
                                rpar=[],
                            ),
                            attr=Name(
                                value=f'on_fetched_item_{self.parents}_{self.children}',
                                lpar=[],
                                rpar=[],
                            ),
                            dot=Dot(
                                whitespace_before=SimpleWhitespace(
                                    value='',
                                ),
                                whitespace_after=SimpleWhitespace(
                                    value='',
                                ),
                            ),
                            lpar=[],
                            rpar=[],
                        ),
                        operator=AddAssign(
                            whitespace_before=SimpleWhitespace(
                                value=' ',
                            ),
                            whitespace_after=SimpleWhitespace(
                                value=' ',
                            ),
                        ),
                        value=Name(
                            value=f'_add_links_to_{self.child}',
                            lpar=[],
                            rpar=[],
                        ),
                        semicolon=MaybeSentinel.DEFAULT,
                    ),
                ],
                leading_lines=[
                    EmptyLine(
                        indent=False,
                        whitespace=SimpleWhitespace(
                            value='',
                        ),
                        comment=None,
                        newline=Newline(
                            value=None,
                        ),
                    ),
                ],
                trailing_whitespace=TrailingWhitespace(
                    whitespace=SimpleWhitespace(
                        value='',
                    ),
                    comment=None,
                    newline=Newline(
                        value=None,
                    ),
                ),
            ),
            SimpleStatementLine(
                body=[
                    AugAssign(
                        target=Attribute(
                            value=Name(
                                value='app',
                                lpar=[],
                                rpar=[],
                            ),
                            attr=Name(
                                value=f'on_fetched_resource_{self.parents}_{self.children}',
                                lpar=[],
                                rpar=[],
                            ),
                            dot=Dot(
                                whitespace_before=SimpleWhitespace(
                                    value='',
                                ),
                                whitespace_after=SimpleWhitespace(
                                    value='',
                                ),
                            ),
                            lpar=[],
                            rpar=[],
                        ),
                        operator=AddAssign(
                            whitespace_before=SimpleWhitespace(
                                value=' ',
                            ),
                            whitespace_after=SimpleWhitespace(
                                value=' ',
                            ),
                        ),
                        value=Name(
                            value=f'_add_links_to_{self.children}_collection',
                            lpar=[],
                            rpar=[],
                        ),
                        semicolon=MaybeSentinel.DEFAULT,
                    ),
                ],
                leading_lines=[],
                trailing_whitespace=TrailingWhitespace(
                    whitespace=SimpleWhitespace(
                        value='',
                    ),
                    comment=None,
                    newline=Newline(
                        value=None,
                    ),
                ),
            ),
            SimpleStatementLine(
                body=[
                    AugAssign(
                        target=Attribute(
                            value=Name(
                                value='app',
                                lpar=[],
                                rpar=[],
                            ),
                            attr=Name(
                                value=f'on_post_POST_{self.parents}_{self.children}',
                                lpar=[],
                                rpar=[],
                            ),
                            dot=Dot(
                                whitespace_before=SimpleWhitespace(
                                    value='',
                                ),
                                whitespace_after=SimpleWhitespace(
                                    value='',
                                ),
                            ),
                            lpar=[],
                            rpar=[],
                        ),
                        operator=AddAssign(
                            whitespace_before=SimpleWhitespace(
                                value=' ',
                            ),
                            whitespace_after=SimpleWhitespace(
                                value=' ',
                            ),
                        ),
                        value=Name(
                            value=f'_post_{self.children}',
                            lpar=[],
                            rpar=[],
                        ),
                        semicolon=MaybeSentinel.DEFAULT,
                    ),
                ],
                leading_lines=[],
                trailing_whitespace=TrailingWhitespace(
                    whitespace=SimpleWhitespace(
                        value='',
                    ),
                    comment=None,
                    newline=Newline(
                        value=None,
                    ),
                ),
            )
        ]
