"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HeadersReferrerPolicy = exports.HeadersFrameOption = exports.ResponseHeadersPolicy = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const cloudfront_generated_1 = require("./cloudfront.generated");
/**
 * A Response Headers Policy configuration.
 *
 * @stability stable
 * @resource AWS::CloudFront::ResponseHeadersPolicy
 */
class ResponseHeadersPolicy extends core_1.Resource {
    /**
     * @stability stable
     */
    constructor(scope, id, props = {}) {
        var _b;
        super(scope, id, {
            physicalName: props.responseHeadersPolicyName,
        });
        jsiiDeprecationWarnings._aws_cdk_aws_cloudfront_ResponseHeadersPolicyProps(props);
        const responseHeadersPolicyName = (_b = props.responseHeadersPolicyName) !== null && _b !== void 0 ? _b : core_1.Names.uniqueId(this);
        const resource = new cloudfront_generated_1.CfnResponseHeadersPolicy(this, 'Resource', {
            responseHeadersPolicyConfig: {
                name: responseHeadersPolicyName,
                comment: props.comment,
                corsConfig: props.corsBehavior ? this._renderCorsConfig(props.corsBehavior) : undefined,
                customHeadersConfig: props.customHeadersBehavior ? this._renderCustomHeadersConfig(props.customHeadersBehavior) : undefined,
                securityHeadersConfig: props.securityHeadersBehavior ? this._renderSecurityHeadersConfig(props.securityHeadersBehavior) : undefined,
            },
        });
        this.responseHeadersPolicyId = resource.ref;
    }
    /**
     * Import an existing Response Headers Policy from its ID.
     *
     * @stability stable
     */
    static fromResponseHeadersPolicyId(scope, id, responseHeadersPolicyId) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.responseHeadersPolicyId = responseHeadersPolicyId;
            }
        }
        return new Import(scope, id);
    }
    static fromManagedResponseHeadersPolicy(managedResponseHeadersPolicyId) {
        return new class {
            constructor() {
                this.responseHeadersPolicyId = managedResponseHeadersPolicyId;
            }
        };
    }
    _renderCorsConfig(behavior) {
        return {
            accessControlAllowCredentials: behavior.accessControlAllowCredentials,
            accessControlAllowHeaders: { items: behavior.accessControlAllowHeaders },
            accessControlAllowMethods: { items: behavior.accessControlAllowMethods },
            accessControlAllowOrigins: { items: behavior.accessControlAllowOrigins },
            accessControlExposeHeaders: behavior.accessControlExposeHeaders ? { items: behavior.accessControlExposeHeaders } : undefined,
            accessControlMaxAgeSec: behavior.accessControlMaxAge ? behavior.accessControlMaxAge.toSeconds() : undefined,
            originOverride: behavior.originOverride,
        };
    }
    _renderCustomHeadersConfig(behavior) {
        return {
            items: behavior.customHeaders,
        };
    }
    _renderSecurityHeadersConfig(behavior) {
        return {
            contentSecurityPolicy: behavior.contentSecurityPolicy,
            contentTypeOptions: behavior.contentTypeOptions,
            frameOptions: behavior.frameOptions,
            referrerPolicy: behavior.referrerPolicy,
            strictTransportSecurity: behavior.strictTransportSecurity ? {
                ...behavior.strictTransportSecurity,
                accessControlMaxAgeSec: behavior.strictTransportSecurity.accessControlMaxAge.toSeconds(),
            } : undefined,
            xssProtection: behavior.xssProtection,
        };
    }
}
exports.ResponseHeadersPolicy = ResponseHeadersPolicy;
_a = JSII_RTTI_SYMBOL_1;
ResponseHeadersPolicy[_a] = { fqn: "@aws-cdk/aws-cloudfront.ResponseHeadersPolicy", version: "1.139.0" };
/**
 * Use this managed policy to allow simple CORS requests from any origin.
 *
 * @stability stable
 */
ResponseHeadersPolicy.CORS_ALLOW_ALL_ORIGINS = ResponseHeadersPolicy.fromManagedResponseHeadersPolicy('60669652-455b-4ae9-85a4-c4c02393f86c');
/**
 * Use this managed policy to allow CORS requests from any origin, including preflight requests.
 *
 * @stability stable
 */
ResponseHeadersPolicy.CORS_ALLOW_ALL_ORIGINS_WITH_PREFLIGHT = ResponseHeadersPolicy.fromManagedResponseHeadersPolicy('5cc3b908-e619-4b99-88e5-2cf7f45965bd');
/**
 * Use this managed policy to add a set of security headers to all responses that CloudFront sends to viewers.
 *
 * @stability stable
 */
ResponseHeadersPolicy.SECURITY_HEADERS = ResponseHeadersPolicy.fromManagedResponseHeadersPolicy('67f7725c-6f97-4210-82d7-5512b31e9d03');
/**
 * Use this managed policy to allow simple CORS requests from any origin and add a set of security headers to all responses that CloudFront sends to viewers.
 *
 * @stability stable
 */
ResponseHeadersPolicy.CORS_ALLOW_ALL_ORIGINS_AND_SECURITY_HEADERS = ResponseHeadersPolicy.fromManagedResponseHeadersPolicy('e61eb60c-9c35-4d20-a928-2b84e02af89c');
/**
 * Use this managed policy to allow CORS requests from any origin, including preflight requests, and add a set of security headers to all responses that CloudFront sends to viewers.
 *
 * @stability stable
 */
ResponseHeadersPolicy.CORS_ALLOW_ALL_ORIGINS_WITH_PREFLIGHT_AND_SECURITY_HEADERS = ResponseHeadersPolicy.fromManagedResponseHeadersPolicy('eaab4381-ed33-4a86-88ca-d9558dc6cd63');
/**
 * Enum representing possible values of the X-Frame-Options HTTP response header.
 *
 * @stability stable
 */
var HeadersFrameOption;
(function (HeadersFrameOption) {
    HeadersFrameOption["DENY"] = "DENY";
    HeadersFrameOption["SAMEORIGIN"] = "SAMEORIGIN";
})(HeadersFrameOption = exports.HeadersFrameOption || (exports.HeadersFrameOption = {}));
/**
 * Enum representing possible values of the Referrer-Policy HTTP response header.
 *
 * @stability stable
 */
var HeadersReferrerPolicy;
(function (HeadersReferrerPolicy) {
    HeadersReferrerPolicy["NO_REFERRER"] = "no-referrer";
    HeadersReferrerPolicy["NO_REFERRER_WHEN_DOWNGRADE"] = "no-referrer-when-downgrade";
    HeadersReferrerPolicy["ORIGIN"] = "origin";
    HeadersReferrerPolicy["ORIGIN_WHEN_CROSS_ORIGIN"] = "origin-when-cross-origin";
    HeadersReferrerPolicy["SAME_ORIGIN"] = "same-origin";
    HeadersReferrerPolicy["STRICT_ORIGIN"] = "strict-origin";
    HeadersReferrerPolicy["STRICT_ORIGIN_WHEN_CROSS_ORIGIN"] = "strict-origin-when-cross-origin";
    HeadersReferrerPolicy["UNSAFE_URL"] = "unsafe-url";
})(HeadersReferrerPolicy = exports.HeadersReferrerPolicy || (exports.HeadersReferrerPolicy = {}));
//# sourceMappingURL=data:application/json;base64,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