# Autogenerated. Do not modify.
#
# Profile: 21.60
from typing import List as list
from typing import Optional

from fit_tool.base_type import BaseType
from fit_tool.data_message import DataMessage
from fit_tool.definition_message import DefinitionMessage
from fit_tool.developer_field import DeveloperField
from fit_tool.endian import Endian
from fit_tool.field import Field
from fit_tool.profile.profile_type import *
from fit_tool.sub_field import SubField


class WorkoutStepMessage(DataMessage):
    ID = 27
    NAME = 'workout_step'

    @staticmethod
    def __get_field_size(definition_message: DefinitionMessage, field_id: int) -> int:
        size = 0
        if definition_message:
            field_definition = definition_message.get_field_definition(field_id)
            if field_definition:
                size = field_definition.size

        return size

    def __init__(self, definition_message=None, developer_fields=None, local_id: int = 0,
                 endian: Endian = Endian.LITTLE):
        super().__init__(name=WorkoutStepMessage.NAME,
                         global_id=WorkoutStepMessage.ID,
                         local_id=definition_message.local_id if definition_message else local_id,
                         endian=definition_message.endian if definition_message else endian,
                         definition_message=definition_message,
                         developer_fields=developer_fields,
                         fields=[
                             MessageIndexField(
                                 size=self.__get_field_size(definition_message, MessageIndexField.ID),
                                 growable=definition_message is None),
                             WorkoutStepWorkoutStepNameField(
                                 size=self.__get_field_size(definition_message, WorkoutStepWorkoutStepNameField.ID),
                                 growable=definition_message is None),
                             WorkoutStepDurationTypeField(
                                 size=self.__get_field_size(definition_message, WorkoutStepDurationTypeField.ID),
                                 growable=definition_message is None),
                             WorkoutStepDurationValueField(
                                 size=self.__get_field_size(definition_message, WorkoutStepDurationValueField.ID),
                                 growable=definition_message is None),
                             WorkoutStepTargetTypeField(
                                 size=self.__get_field_size(definition_message, WorkoutStepTargetTypeField.ID),
                                 growable=definition_message is None),
                             WorkoutStepTargetValueField(
                                 size=self.__get_field_size(definition_message, WorkoutStepTargetValueField.ID),
                                 growable=definition_message is None),
                             WorkoutStepCustomTargetValueLowField(
                                 size=self.__get_field_size(definition_message,
                                                            WorkoutStepCustomTargetValueLowField.ID),
                                 growable=definition_message is None),
                             WorkoutStepCustomTargetValueHighField(
                                 size=self.__get_field_size(definition_message,
                                                            WorkoutStepCustomTargetValueHighField.ID),
                                 growable=definition_message is None),
                             WorkoutStepIntensityField(
                                 size=self.__get_field_size(definition_message, WorkoutStepIntensityField.ID),
                                 growable=definition_message is None),
                             WorkoutStepNotesField(
                                 size=self.__get_field_size(definition_message, WorkoutStepNotesField.ID),
                                 growable=definition_message is None),
                             WorkoutStepEquipmentField(
                                 size=self.__get_field_size(definition_message, WorkoutStepEquipmentField.ID),
                                 growable=definition_message is None),
                             WorkoutStepExerciseCategoryField(
                                 size=self.__get_field_size(definition_message, WorkoutStepExerciseCategoryField.ID),
                                 growable=definition_message is None),
                             WorkoutStepExerciseNameField(
                                 size=self.__get_field_size(definition_message, WorkoutStepExerciseNameField.ID),
                                 growable=definition_message is None),
                             WorkoutStepExerciseWeightField(
                                 size=self.__get_field_size(definition_message, WorkoutStepExerciseWeightField.ID),
                                 growable=definition_message is None),
                             WorkoutStepWeightDisplayUnitField(
                                 size=self.__get_field_size(definition_message, WorkoutStepWeightDisplayUnitField.ID),
                                 growable=definition_message is None)
                         ])

        self.growable = self.definition_message is None

    @classmethod
    def from_bytes(cls, definition_message: DefinitionMessage, developer_fields: list[DeveloperField],
                   bytes_buffer: bytes, offset: int = 0):
        message = cls(definition_message=definition_message, developer_fields=developer_fields)
        message.read_from_bytes(bytes_buffer, offset)
        return message

    @property
    def message_index(self) -> Optional[int]:
        field = self.get_field(MessageIndexField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @message_index.setter
    def message_index(self, value: int):
        field = self.get_field(MessageIndexField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def workout_step_name(self) -> Optional[str]:
        field = self.get_field(WorkoutStepWorkoutStepNameField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @workout_step_name.setter
    def workout_step_name(self, value: str):
        field = self.get_field(WorkoutStepWorkoutStepNameField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def duration_type(self) -> Optional[WorkoutStepDuration]:
        field = self.get_field(WorkoutStepDurationTypeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @duration_type.setter
    def duration_type(self, value: WorkoutStepDuration):
        field = self.get_field(WorkoutStepDurationTypeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def duration_value(self) -> Optional[int]:
        field = self.get_field(WorkoutStepDurationValueField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @duration_value.setter
    def duration_value(self, value: int):
        field = self.get_field(WorkoutStepDurationValueField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def duration_time(self) -> Optional[float]:
        field = self.get_field(WorkoutStepDurationValueField.ID)
        type_field = self.get_field(WorkoutStepDurationTypeField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [0, 28]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @duration_time.setter
    def duration_time(self, value: float):
        field = self.get_field(WorkoutStepDurationValueField.ID)
        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def duration_distance(self) -> Optional[float]:
        field = self.get_field(WorkoutStepDurationValueField.ID)
        type_field = self.get_field(WorkoutStepDurationTypeField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [1]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @duration_distance.setter
    def duration_distance(self, value: float):
        field = self.get_field(WorkoutStepDurationValueField.ID)
        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def duration_hr(self) -> Optional[int]:
        field = self.get_field(WorkoutStepDurationValueField.ID)
        type_field = self.get_field(WorkoutStepDurationTypeField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [2, 3]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @duration_hr.setter
    def duration_hr(self, value: int):
        field = self.get_field(WorkoutStepDurationValueField.ID)
        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def duration_calories(self) -> Optional[int]:
        field = self.get_field(WorkoutStepDurationValueField.ID)
        type_field = self.get_field(WorkoutStepDurationTypeField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [4]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @duration_calories.setter
    def duration_calories(self, value: int):
        field = self.get_field(WorkoutStepDurationValueField.ID)
        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def duration_step(self) -> Optional[int]:
        field = self.get_field(WorkoutStepDurationValueField.ID)
        type_field = self.get_field(WorkoutStepDurationTypeField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [6, 7, 8, 9, 10, 11, 12, 13]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @duration_step.setter
    def duration_step(self, value: int):
        field = self.get_field(WorkoutStepDurationValueField.ID)
        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def duration_power(self) -> Optional[int]:
        field = self.get_field(WorkoutStepDurationValueField.ID)
        type_field = self.get_field(WorkoutStepDurationTypeField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [14, 15]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @duration_power.setter
    def duration_power(self, value: int):
        field = self.get_field(WorkoutStepDurationValueField.ID)
        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def duration_reps(self) -> Optional[int]:
        field = self.get_field(WorkoutStepDurationValueField.ID)
        type_field = self.get_field(WorkoutStepDurationTypeField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [29]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @duration_reps.setter
    def duration_reps(self, value: int):
        field = self.get_field(WorkoutStepDurationValueField.ID)
        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def target_type(self) -> Optional[WorkoutStepTarget]:
        field = self.get_field(WorkoutStepTargetTypeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @target_type.setter
    def target_type(self, value: WorkoutStepTarget):
        field = self.get_field(WorkoutStepTargetTypeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def target_value(self) -> Optional[int]:
        field = self.get_field(WorkoutStepTargetValueField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @target_value.setter
    def target_value(self, value: int):
        field = self.get_field(WorkoutStepTargetValueField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def target_speed_zone(self) -> Optional[int]:
        field = self.get_field(WorkoutStepTargetValueField.ID)
        type_field = self.get_field(WorkoutStepTargetTypeField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [0]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @target_speed_zone.setter
    def target_speed_zone(self, value: int):
        field = self.get_field(WorkoutStepTargetValueField.ID)
        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def target_hr_zone(self) -> Optional[int]:
        field = self.get_field(WorkoutStepTargetValueField.ID)
        type_field = self.get_field(WorkoutStepTargetTypeField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [1]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @target_hr_zone.setter
    def target_hr_zone(self, value: int):
        field = self.get_field(WorkoutStepTargetValueField.ID)
        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def target_cadence_zone(self) -> Optional[int]:
        field = self.get_field(WorkoutStepTargetValueField.ID)
        type_field = self.get_field(WorkoutStepTargetTypeField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [3]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @target_cadence_zone.setter
    def target_cadence_zone(self, value: int):
        field = self.get_field(WorkoutStepTargetValueField.ID)
        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def target_power_zone(self) -> Optional[int]:
        field = self.get_field(WorkoutStepTargetValueField.ID)
        type_field = self.get_field(WorkoutStepTargetTypeField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [4]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @target_power_zone.setter
    def target_power_zone(self, value: int):
        field = self.get_field(WorkoutStepTargetValueField.ID)
        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def target_repeat_steps(self) -> Optional[int]:
        field = self.get_field(WorkoutStepTargetValueField.ID)
        type_field = self.get_field(WorkoutStepDurationTypeField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [6]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @target_repeat_steps.setter
    def target_repeat_steps(self, value: int):
        field = self.get_field(WorkoutStepTargetValueField.ID)
        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def target_repeat_time(self) -> Optional[float]:
        field = self.get_field(WorkoutStepTargetValueField.ID)
        type_field = self.get_field(WorkoutStepDurationTypeField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [7]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @target_repeat_time.setter
    def target_repeat_time(self, value: float):
        field = self.get_field(WorkoutStepTargetValueField.ID)
        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def target_repeat_distance(self) -> Optional[float]:
        field = self.get_field(WorkoutStepTargetValueField.ID)
        type_field = self.get_field(WorkoutStepDurationTypeField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [8]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @target_repeat_distance.setter
    def target_repeat_distance(self, value: float):
        field = self.get_field(WorkoutStepTargetValueField.ID)
        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def target_repeat_calories(self) -> Optional[int]:
        field = self.get_field(WorkoutStepTargetValueField.ID)
        type_field = self.get_field(WorkoutStepDurationTypeField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [9]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @target_repeat_calories.setter
    def target_repeat_calories(self, value: int):
        field = self.get_field(WorkoutStepTargetValueField.ID)
        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def target_repeat_hr(self) -> Optional[int]:
        field = self.get_field(WorkoutStepTargetValueField.ID)
        type_field = self.get_field(WorkoutStepDurationTypeField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [10, 11]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @target_repeat_hr.setter
    def target_repeat_hr(self, value: int):
        field = self.get_field(WorkoutStepTargetValueField.ID)
        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def target_repeat_power(self) -> Optional[int]:
        field = self.get_field(WorkoutStepTargetValueField.ID)
        type_field = self.get_field(WorkoutStepDurationTypeField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [12, 13]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @target_repeat_power.setter
    def target_repeat_power(self, value: int):
        field = self.get_field(WorkoutStepTargetValueField.ID)
        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def target_stroke_type(self) -> Optional[SwimStroke]:
        field = self.get_field(WorkoutStepTargetValueField.ID)
        type_field = self.get_field(WorkoutStepTargetTypeField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [11]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @target_stroke_type.setter
    def target_stroke_type(self, value: SwimStroke):
        field = self.get_field(WorkoutStepTargetValueField.ID)
        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def custom_target_value_low(self) -> Optional[int]:
        field = self.get_field(WorkoutStepCustomTargetValueLowField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @custom_target_value_low.setter
    def custom_target_value_low(self, value: int):
        field = self.get_field(WorkoutStepCustomTargetValueLowField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def custom_target_speed_low(self) -> Optional[float]:
        field = self.get_field(WorkoutStepCustomTargetValueLowField.ID)
        type_field = self.get_field(WorkoutStepTargetTypeField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [0, 12]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @custom_target_speed_low.setter
    def custom_target_speed_low(self, value: float):
        field = self.get_field(WorkoutStepCustomTargetValueLowField.ID)
        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def custom_target_heart_rate_low(self) -> Optional[int]:
        field = self.get_field(WorkoutStepCustomTargetValueLowField.ID)
        type_field = self.get_field(WorkoutStepTargetTypeField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [1, 13]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @custom_target_heart_rate_low.setter
    def custom_target_heart_rate_low(self, value: int):
        field = self.get_field(WorkoutStepCustomTargetValueLowField.ID)
        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def custom_target_cadence_low(self) -> Optional[int]:
        field = self.get_field(WorkoutStepCustomTargetValueLowField.ID)
        type_field = self.get_field(WorkoutStepTargetTypeField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [3]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @custom_target_cadence_low.setter
    def custom_target_cadence_low(self, value: int):
        field = self.get_field(WorkoutStepCustomTargetValueLowField.ID)
        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def custom_target_power_low(self) -> Optional[int]:
        field = self.get_field(WorkoutStepCustomTargetValueLowField.ID)
        type_field = self.get_field(WorkoutStepTargetTypeField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [4, 7, 8, 9, 10]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @custom_target_power_low.setter
    def custom_target_power_low(self, value: int):
        field = self.get_field(WorkoutStepCustomTargetValueLowField.ID)
        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def custom_target_value_high(self) -> Optional[int]:
        field = self.get_field(WorkoutStepCustomTargetValueHighField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @custom_target_value_high.setter
    def custom_target_value_high(self, value: int):
        field = self.get_field(WorkoutStepCustomTargetValueHighField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def custom_target_speed_high(self) -> Optional[float]:
        field = self.get_field(WorkoutStepCustomTargetValueHighField.ID)
        type_field = self.get_field(WorkoutStepTargetTypeField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [0, 12]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @custom_target_speed_high.setter
    def custom_target_speed_high(self, value: float):
        field = self.get_field(WorkoutStepCustomTargetValueHighField.ID)
        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def custom_target_heart_rate_high(self) -> Optional[int]:
        field = self.get_field(WorkoutStepCustomTargetValueHighField.ID)
        type_field = self.get_field(WorkoutStepTargetTypeField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [1, 13]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @custom_target_heart_rate_high.setter
    def custom_target_heart_rate_high(self, value: int):
        field = self.get_field(WorkoutStepCustomTargetValueHighField.ID)
        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def custom_target_cadence_high(self) -> Optional[int]:
        field = self.get_field(WorkoutStepCustomTargetValueHighField.ID)
        type_field = self.get_field(WorkoutStepTargetTypeField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [3]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @custom_target_cadence_high.setter
    def custom_target_cadence_high(self, value: int):
        field = self.get_field(WorkoutStepCustomTargetValueHighField.ID)
        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def custom_target_power_high(self) -> Optional[int]:
        field = self.get_field(WorkoutStepCustomTargetValueHighField.ID)
        type_field = self.get_field(WorkoutStepTargetTypeField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [4, 7, 8, 9, 10]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @custom_target_power_high.setter
    def custom_target_power_high(self, value: int):
        field = self.get_field(WorkoutStepCustomTargetValueHighField.ID)
        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def intensity(self) -> Optional[Intensity]:
        field = self.get_field(WorkoutStepIntensityField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @intensity.setter
    def intensity(self, value: Intensity):
        field = self.get_field(WorkoutStepIntensityField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def notes(self) -> Optional[str]:
        field = self.get_field(WorkoutStepNotesField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @notes.setter
    def notes(self, value: str):
        field = self.get_field(WorkoutStepNotesField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def equipment(self) -> Optional[WorkoutEquipment]:
        field = self.get_field(WorkoutStepEquipmentField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @equipment.setter
    def equipment(self, value: WorkoutEquipment):
        field = self.get_field(WorkoutStepEquipmentField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def exercise_category(self) -> Optional[int]:
        field = self.get_field(WorkoutStepExerciseCategoryField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @exercise_category.setter
    def exercise_category(self, value: int):
        field = self.get_field(WorkoutStepExerciseCategoryField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def exercise_name(self) -> Optional[int]:
        field = self.get_field(WorkoutStepExerciseNameField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @exercise_name.setter
    def exercise_name(self, value: int):
        field = self.get_field(WorkoutStepExerciseNameField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def exercise_weight(self) -> Optional[float]:
        field = self.get_field(WorkoutStepExerciseWeightField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @exercise_weight.setter
    def exercise_weight(self, value: float):
        field = self.get_field(WorkoutStepExerciseWeightField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def weight_display_unit(self) -> Optional[int]:
        field = self.get_field(WorkoutStepWeightDisplayUnitField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @weight_display_unit.setter
    def weight_display_unit(self, value: int):
        field = self.get_field(WorkoutStepWeightDisplayUnitField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)


class MessageIndexField(Field):
    ID = 254

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='message_index',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class WorkoutStepWorkoutStepNameField(Field):
    ID = 0

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='wkt_step_name',
            field_id=self.ID,
            base_type=BaseType.STRING,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class WorkoutStepDurationTypeField(Field):
    ID = 1

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='duration_type',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class WorkoutStepDurationValueField(Field):
    ID = 2

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='duration_value',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
                SubField(
                    name='duration_time',
                    base_type=BaseType.UINT32,
                    scale=1000,
                    offset=0,
                    units='s',
                    reference_map={
                        WorkoutStepDurationTypeField.ID: [0, 28]
                    }),
                SubField(
                    name='duration_distance',
                    base_type=BaseType.UINT32,
                    scale=100,
                    offset=0,
                    units='m',
                    reference_map={
                        WorkoutStepDurationTypeField.ID: [1]
                    }),
                SubField(
                    name='duration_hr',
                    base_type=BaseType.UINT32,
                    scale=1,
                    offset=0,
                    units='% or bpm',
                    reference_map={
                        WorkoutStepDurationTypeField.ID: [2, 3]
                    }),
                SubField(
                    name='duration_calories',
                    base_type=BaseType.UINT32,
                    scale=1,
                    offset=0,
                    units='calories',
                    reference_map={
                        WorkoutStepDurationTypeField.ID: [4]
                    }),
                SubField(
                    name='duration_step',
                    base_type=BaseType.UINT32,
                    scale=1,
                    offset=0,
                    reference_map={
                        WorkoutStepDurationTypeField.ID: [6, 7, 8, 9, 10, 11, 12, 13]
                    }),
                SubField(
                    name='duration_power',
                    base_type=BaseType.UINT32,
                    scale=1,
                    offset=0,
                    units='% or watts',
                    reference_map={
                        WorkoutStepDurationTypeField.ID: [14, 15]
                    }),
                SubField(
                    name='duration_reps',
                    base_type=BaseType.UINT32,
                    scale=1,
                    offset=0,
                    reference_map={
                        WorkoutStepDurationTypeField.ID: [29]
                    })
            ]
        )


class WorkoutStepTargetTypeField(Field):
    ID = 3

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='target_type',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class WorkoutStepTargetValueField(Field):
    ID = 4

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='target_value',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
                SubField(
                    name='target_speed_zone',
                    base_type=BaseType.UINT32,
                    scale=1,
                    offset=0,
                    reference_map={
                        WorkoutStepTargetTypeField.ID: [0]
                    }),
                SubField(
                    name='target_hr_zone',
                    base_type=BaseType.UINT32,
                    scale=1,
                    offset=0,
                    reference_map={
                        WorkoutStepTargetTypeField.ID: [1]
                    }),
                SubField(
                    name='target_cadence_zone',
                    base_type=BaseType.UINT32,
                    scale=1,
                    offset=0,
                    reference_map={
                        WorkoutStepTargetTypeField.ID: [3]
                    }),
                SubField(
                    name='target_power_zone',
                    base_type=BaseType.UINT32,
                    scale=1,
                    offset=0,
                    reference_map={
                        WorkoutStepTargetTypeField.ID: [4]
                    }),
                SubField(
                    name='repeat_steps',
                    base_type=BaseType.UINT32,
                    scale=1,
                    offset=0,
                    reference_map={
                        WorkoutStepDurationTypeField.ID: [6]
                    }),
                SubField(
                    name='repeat_time',
                    base_type=BaseType.UINT32,
                    scale=1000,
                    offset=0,
                    units='s',
                    reference_map={
                        WorkoutStepDurationTypeField.ID: [7]
                    }),
                SubField(
                    name='repeat_distance',
                    base_type=BaseType.UINT32,
                    scale=100,
                    offset=0,
                    units='m',
                    reference_map={
                        WorkoutStepDurationTypeField.ID: [8]
                    }),
                SubField(
                    name='repeat_calories',
                    base_type=BaseType.UINT32,
                    scale=1,
                    offset=0,
                    units='calories',
                    reference_map={
                        WorkoutStepDurationTypeField.ID: [9]
                    }),
                SubField(
                    name='repeat_hr',
                    base_type=BaseType.UINT32,
                    scale=1,
                    offset=0,
                    units='% or bpm',
                    reference_map={
                        WorkoutStepDurationTypeField.ID: [10, 11]
                    }),
                SubField(
                    name='repeat_power',
                    base_type=BaseType.UINT32,
                    scale=1,
                    offset=0,
                    units='% or watts',
                    reference_map={
                        WorkoutStepDurationTypeField.ID: [12, 13]
                    }),
                SubField(
                    name='target_stroke_type',
                    base_type=BaseType.ENUM,
                    scale=1,
                    offset=0,
                    reference_map={
                        WorkoutStepTargetTypeField.ID: [11]
                    })
            ]
        )


class WorkoutStepCustomTargetValueLowField(Field):
    ID = 5

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='custom_target_value_low',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
                SubField(
                    name='custom_target_speed_low',
                    base_type=BaseType.UINT32,
                    scale=1000,
                    offset=0,
                    units='m/s',
                    reference_map={
                        WorkoutStepTargetTypeField.ID: [0, 12]
                    }),
                SubField(
                    name='custom_target_heart_rate_low',
                    base_type=BaseType.UINT32,
                    scale=1,
                    offset=0,
                    units='% or bpm',
                    reference_map={
                        WorkoutStepTargetTypeField.ID: [1, 13]
                    }),
                SubField(
                    name='custom_target_cadence_low',
                    base_type=BaseType.UINT32,
                    scale=1,
                    offset=0,
                    units='rpm',
                    reference_map={
                        WorkoutStepTargetTypeField.ID: [3]
                    }),
                SubField(
                    name='custom_target_power_low',
                    base_type=BaseType.UINT32,
                    scale=1,
                    offset=0,
                    units='% or watts',
                    reference_map={
                        WorkoutStepTargetTypeField.ID: [4, 7, 8, 9, 10]
                    })
            ]
        )


class WorkoutStepCustomTargetValueHighField(Field):
    ID = 6

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='custom_target_value_high',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
                SubField(
                    name='custom_target_speed_high',
                    base_type=BaseType.UINT32,
                    scale=1000,
                    offset=0,
                    units='m/s',
                    reference_map={
                        WorkoutStepTargetTypeField.ID: [0, 12]
                    }),
                SubField(
                    name='custom_target_heart_rate_high',
                    base_type=BaseType.UINT32,
                    scale=1,
                    offset=0,
                    units='% or bpm',
                    reference_map={
                        WorkoutStepTargetTypeField.ID: [1, 13]
                    }),
                SubField(
                    name='custom_target_cadence_high',
                    base_type=BaseType.UINT32,
                    scale=1,
                    offset=0,
                    units='rpm',
                    reference_map={
                        WorkoutStepTargetTypeField.ID: [3]
                    }),
                SubField(
                    name='custom_target_power_high',
                    base_type=BaseType.UINT32,
                    scale=1,
                    offset=0,
                    units='% or watts',
                    reference_map={
                        WorkoutStepTargetTypeField.ID: [4, 7, 8, 9, 10]
                    })
            ]
        )


class WorkoutStepIntensityField(Field):
    ID = 7

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='intensity',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class WorkoutStepNotesField(Field):
    ID = 8

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='notes',
            field_id=self.ID,
            base_type=BaseType.STRING,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class WorkoutStepEquipmentField(Field):
    ID = 9

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='equipment',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class WorkoutStepExerciseCategoryField(Field):
    ID = 10

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='exercise_category',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class WorkoutStepExerciseNameField(Field):
    ID = 11

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='exercise_name',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class WorkoutStepExerciseWeightField(Field):
    ID = 12

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='exercise_weight',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=100,
            size=size,
            units='kg',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class WorkoutStepWeightDisplayUnitField(Field):
    ID = 13

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='weight_display_unit',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )
