# Autogenerated. Do not modify.
#
# Profile: 21.60
from typing import List as list
from typing import Optional

from fit_tool.base_type import BaseType
from fit_tool.data_message import DataMessage
from fit_tool.definition_message import DefinitionMessage
from fit_tool.developer_field import DeveloperField
from fit_tool.endian import Endian
from fit_tool.field import Field
from fit_tool.profile.profile_type import *
from fit_tool.sub_field import SubField


class SessionMessage(DataMessage):
    ID = 18
    NAME = 'session'

    @staticmethod
    def __get_field_size(definition_message: DefinitionMessage, field_id: int) -> int:
        size = 0
        if definition_message:
            field_definition = definition_message.get_field_definition(field_id)
            if field_definition:
                size = field_definition.size

        return size

    def __init__(self, definition_message=None, developer_fields=None, local_id: int = 0,
                 endian: Endian = Endian.LITTLE):
        super().__init__(name=SessionMessage.NAME,
                         global_id=SessionMessage.ID,
                         local_id=definition_message.local_id if definition_message else local_id,
                         endian=definition_message.endian if definition_message else endian,
                         definition_message=definition_message,
                         developer_fields=developer_fields,
                         fields=[
                             MessageIndexField(
                                 size=self.__get_field_size(definition_message, MessageIndexField.ID),
                                 growable=definition_message is None),
                             TimestampField(
                                 size=self.__get_field_size(definition_message, TimestampField.ID),
                                 growable=definition_message is None),
                             SessionEventField(
                                 size=self.__get_field_size(definition_message, SessionEventField.ID),
                                 growable=definition_message is None),
                             SessionEventTypeField(
                                 size=self.__get_field_size(definition_message, SessionEventTypeField.ID),
                                 growable=definition_message is None),
                             SessionStartTimeField(
                                 size=self.__get_field_size(definition_message, SessionStartTimeField.ID),
                                 growable=definition_message is None),
                             SessionStartPositionLatField(
                                 size=self.__get_field_size(definition_message, SessionStartPositionLatField.ID),
                                 growable=definition_message is None),
                             SessionStartPositionLongField(
                                 size=self.__get_field_size(definition_message, SessionStartPositionLongField.ID),
                                 growable=definition_message is None),
                             SessionSportField(
                                 size=self.__get_field_size(definition_message, SessionSportField.ID),
                                 growable=definition_message is None),
                             SessionSubSportField(
                                 size=self.__get_field_size(definition_message, SessionSubSportField.ID),
                                 growable=definition_message is None),
                             SessionTotalElapsedTimeField(
                                 size=self.__get_field_size(definition_message, SessionTotalElapsedTimeField.ID),
                                 growable=definition_message is None),
                             SessionTotalTimerTimeField(
                                 size=self.__get_field_size(definition_message, SessionTotalTimerTimeField.ID),
                                 growable=definition_message is None),
                             SessionTotalDistanceField(
                                 size=self.__get_field_size(definition_message, SessionTotalDistanceField.ID),
                                 growable=definition_message is None),
                             SessionTotalCyclesField(
                                 size=self.__get_field_size(definition_message, SessionTotalCyclesField.ID),
                                 growable=definition_message is None),
                             SessionTotalCaloriesField(
                                 size=self.__get_field_size(definition_message, SessionTotalCaloriesField.ID),
                                 growable=definition_message is None),
                             SessionTotalFatCaloriesField(
                                 size=self.__get_field_size(definition_message, SessionTotalFatCaloriesField.ID),
                                 growable=definition_message is None),
                             SessionAvgSpeedField(
                                 size=self.__get_field_size(definition_message, SessionAvgSpeedField.ID),
                                 growable=definition_message is None),
                             SessionMaxSpeedField(
                                 size=self.__get_field_size(definition_message, SessionMaxSpeedField.ID),
                                 growable=definition_message is None),
                             SessionAvgHeartRateField(
                                 size=self.__get_field_size(definition_message, SessionAvgHeartRateField.ID),
                                 growable=definition_message is None),
                             SessionMaxHeartRateField(
                                 size=self.__get_field_size(definition_message, SessionMaxHeartRateField.ID),
                                 growable=definition_message is None),
                             SessionAvgCadenceField(
                                 size=self.__get_field_size(definition_message, SessionAvgCadenceField.ID),
                                 growable=definition_message is None),
                             SessionMaxCadenceField(
                                 size=self.__get_field_size(definition_message, SessionMaxCadenceField.ID),
                                 growable=definition_message is None),
                             SessionAvgPowerField(
                                 size=self.__get_field_size(definition_message, SessionAvgPowerField.ID),
                                 growable=definition_message is None),
                             SessionMaxPowerField(
                                 size=self.__get_field_size(definition_message, SessionMaxPowerField.ID),
                                 growable=definition_message is None),
                             SessionTotalAscentField(
                                 size=self.__get_field_size(definition_message, SessionTotalAscentField.ID),
                                 growable=definition_message is None),
                             SessionTotalDescentField(
                                 size=self.__get_field_size(definition_message, SessionTotalDescentField.ID),
                                 growable=definition_message is None),
                             SessionTotalTrainingEffectField(
                                 size=self.__get_field_size(definition_message, SessionTotalTrainingEffectField.ID),
                                 growable=definition_message is None),
                             SessionFirstLapIndexField(
                                 size=self.__get_field_size(definition_message, SessionFirstLapIndexField.ID),
                                 growable=definition_message is None),
                             SessionNumLapsField(
                                 size=self.__get_field_size(definition_message, SessionNumLapsField.ID),
                                 growable=definition_message is None),
                             SessionEventGroupField(
                                 size=self.__get_field_size(definition_message, SessionEventGroupField.ID),
                                 growable=definition_message is None),
                             SessionTriggerField(
                                 size=self.__get_field_size(definition_message, SessionTriggerField.ID),
                                 growable=definition_message is None),
                             SessionNecLatField(
                                 size=self.__get_field_size(definition_message, SessionNecLatField.ID),
                                 growable=definition_message is None),
                             SessionNecLongField(
                                 size=self.__get_field_size(definition_message, SessionNecLongField.ID),
                                 growable=definition_message is None),
                             SessionSwcLatField(
                                 size=self.__get_field_size(definition_message, SessionSwcLatField.ID),
                                 growable=definition_message is None),
                             SessionSwcLongField(
                                 size=self.__get_field_size(definition_message, SessionSwcLongField.ID),
                                 growable=definition_message is None),
                             SessionNumLengthsField(
                                 size=self.__get_field_size(definition_message, SessionNumLengthsField.ID),
                                 growable=definition_message is None),
                             SessionNormalizedPowerField(
                                 size=self.__get_field_size(definition_message, SessionNormalizedPowerField.ID),
                                 growable=definition_message is None),
                             SessionTrainingStressScoreField(
                                 size=self.__get_field_size(definition_message, SessionTrainingStressScoreField.ID),
                                 growable=definition_message is None),
                             SessionIntensityFactorField(
                                 size=self.__get_field_size(definition_message, SessionIntensityFactorField.ID),
                                 growable=definition_message is None),
                             SessionLeftRightBalanceField(
                                 size=self.__get_field_size(definition_message, SessionLeftRightBalanceField.ID),
                                 growable=definition_message is None),
                             SessionAvgStrokeCountField(
                                 size=self.__get_field_size(definition_message, SessionAvgStrokeCountField.ID),
                                 growable=definition_message is None),
                             SessionAvgStrokeDistanceField(
                                 size=self.__get_field_size(definition_message, SessionAvgStrokeDistanceField.ID),
                                 growable=definition_message is None),
                             SessionSwimStrokeField(
                                 size=self.__get_field_size(definition_message, SessionSwimStrokeField.ID),
                                 growable=definition_message is None),
                             SessionPoolLengthField(
                                 size=self.__get_field_size(definition_message, SessionPoolLengthField.ID),
                                 growable=definition_message is None),
                             SessionThresholdPowerField(
                                 size=self.__get_field_size(definition_message, SessionThresholdPowerField.ID),
                                 growable=definition_message is None),
                             SessionPoolLengthUnitField(
                                 size=self.__get_field_size(definition_message, SessionPoolLengthUnitField.ID),
                                 growable=definition_message is None),
                             SessionNumActiveLengthsField(
                                 size=self.__get_field_size(definition_message, SessionNumActiveLengthsField.ID),
                                 growable=definition_message is None),
                             SessionTotalWorkField(
                                 size=self.__get_field_size(definition_message, SessionTotalWorkField.ID),
                                 growable=definition_message is None),
                             SessionAvgAltitudeField(
                                 size=self.__get_field_size(definition_message, SessionAvgAltitudeField.ID),
                                 growable=definition_message is None),
                             SessionMaxAltitudeField(
                                 size=self.__get_field_size(definition_message, SessionMaxAltitudeField.ID),
                                 growable=definition_message is None),
                             SessionGpsAccuracyField(
                                 size=self.__get_field_size(definition_message, SessionGpsAccuracyField.ID),
                                 growable=definition_message is None),
                             SessionAvgGradeField(
                                 size=self.__get_field_size(definition_message, SessionAvgGradeField.ID),
                                 growable=definition_message is None),
                             SessionAvgPosGradeField(
                                 size=self.__get_field_size(definition_message, SessionAvgPosGradeField.ID),
                                 growable=definition_message is None),
                             SessionAvgNegGradeField(
                                 size=self.__get_field_size(definition_message, SessionAvgNegGradeField.ID),
                                 growable=definition_message is None),
                             SessionMaxPosGradeField(
                                 size=self.__get_field_size(definition_message, SessionMaxPosGradeField.ID),
                                 growable=definition_message is None),
                             SessionMaxNegGradeField(
                                 size=self.__get_field_size(definition_message, SessionMaxNegGradeField.ID),
                                 growable=definition_message is None),
                             SessionAvgTemperatureField(
                                 size=self.__get_field_size(definition_message, SessionAvgTemperatureField.ID),
                                 growable=definition_message is None),
                             SessionMaxTemperatureField(
                                 size=self.__get_field_size(definition_message, SessionMaxTemperatureField.ID),
                                 growable=definition_message is None),
                             SessionTotalMovingTimeField(
                                 size=self.__get_field_size(definition_message, SessionTotalMovingTimeField.ID),
                                 growable=definition_message is None),
                             SessionAvgPosVerticalSpeedField(
                                 size=self.__get_field_size(definition_message, SessionAvgPosVerticalSpeedField.ID),
                                 growable=definition_message is None),
                             SessionAvgNegVerticalSpeedField(
                                 size=self.__get_field_size(definition_message, SessionAvgNegVerticalSpeedField.ID),
                                 growable=definition_message is None),
                             SessionMaxPosVerticalSpeedField(
                                 size=self.__get_field_size(definition_message, SessionMaxPosVerticalSpeedField.ID),
                                 growable=definition_message is None),
                             SessionMaxNegVerticalSpeedField(
                                 size=self.__get_field_size(definition_message, SessionMaxNegVerticalSpeedField.ID),
                                 growable=definition_message is None),
                             SessionMinHeartRateField(
                                 size=self.__get_field_size(definition_message, SessionMinHeartRateField.ID),
                                 growable=definition_message is None),
                             SessionTimeInHrZoneField(
                                 size=self.__get_field_size(definition_message, SessionTimeInHrZoneField.ID),
                                 growable=definition_message is None),
                             SessionTimeInSpeedZoneField(
                                 size=self.__get_field_size(definition_message, SessionTimeInSpeedZoneField.ID),
                                 growable=definition_message is None),
                             SessionTimeInCadenceZoneField(
                                 size=self.__get_field_size(definition_message, SessionTimeInCadenceZoneField.ID),
                                 growable=definition_message is None),
                             SessionTimeInPowerZoneField(
                                 size=self.__get_field_size(definition_message, SessionTimeInPowerZoneField.ID),
                                 growable=definition_message is None),
                             SessionAvgLapTimeField(
                                 size=self.__get_field_size(definition_message, SessionAvgLapTimeField.ID),
                                 growable=definition_message is None),
                             SessionBestLapIndexField(
                                 size=self.__get_field_size(definition_message, SessionBestLapIndexField.ID),
                                 growable=definition_message is None),
                             SessionMinAltitudeField(
                                 size=self.__get_field_size(definition_message, SessionMinAltitudeField.ID),
                                 growable=definition_message is None),
                             SessionPlayerScoreField(
                                 size=self.__get_field_size(definition_message, SessionPlayerScoreField.ID),
                                 growable=definition_message is None),
                             SessionOpponentScoreField(
                                 size=self.__get_field_size(definition_message, SessionOpponentScoreField.ID),
                                 growable=definition_message is None),
                             SessionOpponentNameField(
                                 size=self.__get_field_size(definition_message, SessionOpponentNameField.ID),
                                 growable=definition_message is None),
                             SessionStrokeCountField(
                                 size=self.__get_field_size(definition_message, SessionStrokeCountField.ID),
                                 growable=definition_message is None),
                             SessionZoneCountField(
                                 size=self.__get_field_size(definition_message, SessionZoneCountField.ID),
                                 growable=definition_message is None),
                             SessionMaxBallSpeedField(
                                 size=self.__get_field_size(definition_message, SessionMaxBallSpeedField.ID),
                                 growable=definition_message is None),
                             SessionAvgBallSpeedField(
                                 size=self.__get_field_size(definition_message, SessionAvgBallSpeedField.ID),
                                 growable=definition_message is None),
                             SessionAvgVerticalOscillationField(
                                 size=self.__get_field_size(definition_message, SessionAvgVerticalOscillationField.ID),
                                 growable=definition_message is None),
                             SessionAvgStanceTimePercentField(
                                 size=self.__get_field_size(definition_message, SessionAvgStanceTimePercentField.ID),
                                 growable=definition_message is None),
                             SessionAvgStanceTimeField(
                                 size=self.__get_field_size(definition_message, SessionAvgStanceTimeField.ID),
                                 growable=definition_message is None),
                             SessionAvgFractionalCadenceField(
                                 size=self.__get_field_size(definition_message, SessionAvgFractionalCadenceField.ID),
                                 growable=definition_message is None),
                             SessionMaxFractionalCadenceField(
                                 size=self.__get_field_size(definition_message, SessionMaxFractionalCadenceField.ID),
                                 growable=definition_message is None),
                             SessionTotalFractionalCyclesField(
                                 size=self.__get_field_size(definition_message, SessionTotalFractionalCyclesField.ID),
                                 growable=definition_message is None),
                             SessionAvgTotalHemoglobinConcField(
                                 size=self.__get_field_size(definition_message, SessionAvgTotalHemoglobinConcField.ID),
                                 growable=definition_message is None),
                             SessionMinTotalHemoglobinConcField(
                                 size=self.__get_field_size(definition_message, SessionMinTotalHemoglobinConcField.ID),
                                 growable=definition_message is None),
                             SessionMaxTotalHemoglobinConcField(
                                 size=self.__get_field_size(definition_message, SessionMaxTotalHemoglobinConcField.ID),
                                 growable=definition_message is None),
                             SessionAvgSaturatedHemoglobinPercentField(
                                 size=self.__get_field_size(definition_message,
                                                            SessionAvgSaturatedHemoglobinPercentField.ID),
                                 growable=definition_message is None),
                             SessionMinSaturatedHemoglobinPercentField(
                                 size=self.__get_field_size(definition_message,
                                                            SessionMinSaturatedHemoglobinPercentField.ID),
                                 growable=definition_message is None),
                             SessionMaxSaturatedHemoglobinPercentField(
                                 size=self.__get_field_size(definition_message,
                                                            SessionMaxSaturatedHemoglobinPercentField.ID),
                                 growable=definition_message is None),
                             SessionAvgLeftTorqueEffectivenessField(
                                 size=self.__get_field_size(definition_message,
                                                            SessionAvgLeftTorqueEffectivenessField.ID),
                                 growable=definition_message is None),
                             SessionAvgRightTorqueEffectivenessField(
                                 size=self.__get_field_size(definition_message,
                                                            SessionAvgRightTorqueEffectivenessField.ID),
                                 growable=definition_message is None),
                             SessionAvgLeftPedalSmoothnessField(
                                 size=self.__get_field_size(definition_message, SessionAvgLeftPedalSmoothnessField.ID),
                                 growable=definition_message is None),
                             SessionAvgRightPedalSmoothnessField(
                                 size=self.__get_field_size(definition_message, SessionAvgRightPedalSmoothnessField.ID),
                                 growable=definition_message is None),
                             SessionAvgCombinedPedalSmoothnessField(
                                 size=self.__get_field_size(definition_message,
                                                            SessionAvgCombinedPedalSmoothnessField.ID),
                                 growable=definition_message is None),
                             SessionSportIndexField(
                                 size=self.__get_field_size(definition_message, SessionSportIndexField.ID),
                                 growable=definition_message is None),
                             SessionTimeStandingField(
                                 size=self.__get_field_size(definition_message, SessionTimeStandingField.ID),
                                 growable=definition_message is None),
                             SessionStandCountField(
                                 size=self.__get_field_size(definition_message, SessionStandCountField.ID),
                                 growable=definition_message is None),
                             SessionAvgLeftPcoField(
                                 size=self.__get_field_size(definition_message, SessionAvgLeftPcoField.ID),
                                 growable=definition_message is None),
                             SessionAvgRightPcoField(
                                 size=self.__get_field_size(definition_message, SessionAvgRightPcoField.ID),
                                 growable=definition_message is None),
                             SessionAvgLeftPowerPhaseField(
                                 size=self.__get_field_size(definition_message, SessionAvgLeftPowerPhaseField.ID),
                                 growable=definition_message is None),
                             SessionAvgLeftPowerPhasePeakField(
                                 size=self.__get_field_size(definition_message, SessionAvgLeftPowerPhasePeakField.ID),
                                 growable=definition_message is None),
                             SessionAvgRightPowerPhaseField(
                                 size=self.__get_field_size(definition_message, SessionAvgRightPowerPhaseField.ID),
                                 growable=definition_message is None),
                             SessionAvgRightPowerPhasePeakField(
                                 size=self.__get_field_size(definition_message, SessionAvgRightPowerPhasePeakField.ID),
                                 growable=definition_message is None),
                             SessionAvgPowerPositionField(
                                 size=self.__get_field_size(definition_message, SessionAvgPowerPositionField.ID),
                                 growable=definition_message is None),
                             SessionMaxPowerPositionField(
                                 size=self.__get_field_size(definition_message, SessionMaxPowerPositionField.ID),
                                 growable=definition_message is None),
                             SessionAvgCadencePositionField(
                                 size=self.__get_field_size(definition_message, SessionAvgCadencePositionField.ID),
                                 growable=definition_message is None),
                             SessionMaxCadencePositionField(
                                 size=self.__get_field_size(definition_message, SessionMaxCadencePositionField.ID),
                                 growable=definition_message is None),
                             SessionEnhancedAvgSpeedField(
                                 size=self.__get_field_size(definition_message, SessionEnhancedAvgSpeedField.ID),
                                 growable=definition_message is None),
                             SessionEnhancedMaxSpeedField(
                                 size=self.__get_field_size(definition_message, SessionEnhancedMaxSpeedField.ID),
                                 growable=definition_message is None),
                             SessionEnhancedAvgAltitudeField(
                                 size=self.__get_field_size(definition_message, SessionEnhancedAvgAltitudeField.ID),
                                 growable=definition_message is None),
                             SessionEnhancedMinAltitudeField(
                                 size=self.__get_field_size(definition_message, SessionEnhancedMinAltitudeField.ID),
                                 growable=definition_message is None),
                             SessionEnhancedMaxAltitudeField(
                                 size=self.__get_field_size(definition_message, SessionEnhancedMaxAltitudeField.ID),
                                 growable=definition_message is None),
                             SessionAvgLevMotorPowerField(
                                 size=self.__get_field_size(definition_message, SessionAvgLevMotorPowerField.ID),
                                 growable=definition_message is None),
                             SessionMaxLevMotorPowerField(
                                 size=self.__get_field_size(definition_message, SessionMaxLevMotorPowerField.ID),
                                 growable=definition_message is None),
                             SessionLevBatteryConsumptionField(
                                 size=self.__get_field_size(definition_message, SessionLevBatteryConsumptionField.ID),
                                 growable=definition_message is None),
                             SessionAvgVerticalRatioField(
                                 size=self.__get_field_size(definition_message, SessionAvgVerticalRatioField.ID),
                                 growable=definition_message is None),
                             SessionAvgStanceTimeBalanceField(
                                 size=self.__get_field_size(definition_message, SessionAvgStanceTimeBalanceField.ID),
                                 growable=definition_message is None),
                             SessionAvgStepLengthField(
                                 size=self.__get_field_size(definition_message, SessionAvgStepLengthField.ID),
                                 growable=definition_message is None),
                             SessionTotalAnaerobicTrainingEffectField(
                                 size=self.__get_field_size(definition_message,
                                                            SessionTotalAnaerobicTrainingEffectField.ID),
                                 growable=definition_message is None),
                             SessionAvgVamField(
                                 size=self.__get_field_size(definition_message, SessionAvgVamField.ID),
                                 growable=definition_message is None),
                             SessionTotalGritField(
                                 size=self.__get_field_size(definition_message, SessionTotalGritField.ID),
                                 growable=definition_message is None),
                             SessionTotalFlowField(
                                 size=self.__get_field_size(definition_message, SessionTotalFlowField.ID),
                                 growable=definition_message is None),
                             SessionJumpCountField(
                                 size=self.__get_field_size(definition_message, SessionJumpCountField.ID),
                                 growable=definition_message is None),
                             SessionAvgGritField(
                                 size=self.__get_field_size(definition_message, SessionAvgGritField.ID),
                                 growable=definition_message is None),
                             SessionAvgFlowField(
                                 size=self.__get_field_size(definition_message, SessionAvgFlowField.ID),
                                 growable=definition_message is None),
                             SessionTotalFractionalAscentField(
                                 size=self.__get_field_size(definition_message, SessionTotalFractionalAscentField.ID),
                                 growable=definition_message is None),
                             SessionTotalFractionalDescentField(
                                 size=self.__get_field_size(definition_message, SessionTotalFractionalDescentField.ID),
                                 growable=definition_message is None),
                             SessionAvgCoreTemperatureField(
                                 size=self.__get_field_size(definition_message, SessionAvgCoreTemperatureField.ID),
                                 growable=definition_message is None),
                             SessionMinCoreTemperatureField(
                                 size=self.__get_field_size(definition_message, SessionMinCoreTemperatureField.ID),
                                 growable=definition_message is None),
                             SessionMaxCoreTemperatureField(
                                 size=self.__get_field_size(definition_message, SessionMaxCoreTemperatureField.ID),
                                 growable=definition_message is None)
                         ])

        self.growable = self.definition_message is None

    @classmethod
    def from_bytes(cls, definition_message: DefinitionMessage, developer_fields: list[DeveloperField],
                   bytes_buffer: bytes, offset: int = 0):
        message = cls(definition_message=definition_message, developer_fields=developer_fields)
        message.read_from_bytes(bytes_buffer, offset)
        return message

    @property
    def message_index(self) -> Optional[int]:
        field = self.get_field(MessageIndexField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @message_index.setter
    def message_index(self, value: int):
        field = self.get_field(MessageIndexField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    # timestamp : milliseconds from January 1st, 1970 at 00:00:00 UTC

    @property
    def timestamp(self) -> Optional[int]:
        field = self.get_field(TimestampField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    # timestamp : milliseconds from January 1st, 1970 at 00:00:00 UTC

    @timestamp.setter
    def timestamp(self, value: int):
        field = self.get_field(TimestampField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def event(self) -> Optional[Event]:
        field = self.get_field(SessionEventField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @event.setter
    def event(self, value: Event):
        field = self.get_field(SessionEventField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def event_type(self) -> Optional[EventType]:
        field = self.get_field(SessionEventTypeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @event_type.setter
    def event_type(self, value: EventType):
        field = self.get_field(SessionEventTypeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    # timestamp : milliseconds from January 1st, 1970 at 00:00:00 UTC

    @property
    def start_time(self) -> Optional[int]:
        field = self.get_field(SessionStartTimeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    # timestamp : milliseconds from January 1st, 1970 at 00:00:00 UTC

    @start_time.setter
    def start_time(self, value: int):
        field = self.get_field(SessionStartTimeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def start_position_lat(self) -> Optional[float]:
        field = self.get_field(SessionStartPositionLatField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @start_position_lat.setter
    def start_position_lat(self, value: float):
        field = self.get_field(SessionStartPositionLatField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def start_position_long(self) -> Optional[float]:
        field = self.get_field(SessionStartPositionLongField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @start_position_long.setter
    def start_position_long(self, value: float):
        field = self.get_field(SessionStartPositionLongField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def sport(self) -> Optional[Sport]:
        field = self.get_field(SessionSportField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @sport.setter
    def sport(self, value: Sport):
        field = self.get_field(SessionSportField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def sub_sport(self) -> Optional[SubSport]:
        field = self.get_field(SessionSubSportField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @sub_sport.setter
    def sub_sport(self, value: SubSport):
        field = self.get_field(SessionSubSportField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def total_elapsed_time(self) -> Optional[float]:
        field = self.get_field(SessionTotalElapsedTimeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @total_elapsed_time.setter
    def total_elapsed_time(self, value: float):
        field = self.get_field(SessionTotalElapsedTimeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def total_timer_time(self) -> Optional[float]:
        field = self.get_field(SessionTotalTimerTimeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @total_timer_time.setter
    def total_timer_time(self, value: float):
        field = self.get_field(SessionTotalTimerTimeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def total_distance(self) -> Optional[float]:
        field = self.get_field(SessionTotalDistanceField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @total_distance.setter
    def total_distance(self, value: float):
        field = self.get_field(SessionTotalDistanceField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def total_cycles(self) -> Optional[int]:
        field = self.get_field(SessionTotalCyclesField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @total_cycles.setter
    def total_cycles(self, value: int):
        field = self.get_field(SessionTotalCyclesField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def total_strides(self) -> Optional[int]:
        field = self.get_field(SessionTotalCyclesField.ID)
        type_field = self.get_field(SessionSportField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [1, 11]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @total_strides.setter
    def total_strides(self, value: int):
        field = self.get_field(SessionTotalCyclesField.ID)
        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def total_strokes(self) -> Optional[int]:
        field = self.get_field(SessionTotalCyclesField.ID)
        type_field = self.get_field(SessionSportField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [2, 5, 15, 37]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @total_strokes.setter
    def total_strokes(self, value: int):
        field = self.get_field(SessionTotalCyclesField.ID)
        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def total_calories(self) -> Optional[int]:
        field = self.get_field(SessionTotalCaloriesField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @total_calories.setter
    def total_calories(self, value: int):
        field = self.get_field(SessionTotalCaloriesField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def total_fat_calories(self) -> Optional[int]:
        field = self.get_field(SessionTotalFatCaloriesField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @total_fat_calories.setter
    def total_fat_calories(self, value: int):
        field = self.get_field(SessionTotalFatCaloriesField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_speed(self) -> Optional[float]:
        field = self.get_field(SessionAvgSpeedField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_speed.setter
    def avg_speed(self, value: float):
        field = self.get_field(SessionAvgSpeedField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def max_speed(self) -> Optional[float]:
        field = self.get_field(SessionMaxSpeedField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @max_speed.setter
    def max_speed(self, value: float):
        field = self.get_field(SessionMaxSpeedField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_heart_rate(self) -> Optional[int]:
        field = self.get_field(SessionAvgHeartRateField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_heart_rate.setter
    def avg_heart_rate(self, value: int):
        field = self.get_field(SessionAvgHeartRateField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def max_heart_rate(self) -> Optional[int]:
        field = self.get_field(SessionMaxHeartRateField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @max_heart_rate.setter
    def max_heart_rate(self, value: int):
        field = self.get_field(SessionMaxHeartRateField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_cadence(self) -> Optional[int]:
        field = self.get_field(SessionAvgCadenceField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_cadence.setter
    def avg_cadence(self, value: int):
        field = self.get_field(SessionAvgCadenceField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_running_cadence(self) -> Optional[int]:
        field = self.get_field(SessionAvgCadenceField.ID)
        type_field = self.get_field(SessionSportField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [1]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_running_cadence.setter
    def avg_running_cadence(self, value: int):
        field = self.get_field(SessionAvgCadenceField.ID)
        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def max_cadence(self) -> Optional[int]:
        field = self.get_field(SessionMaxCadenceField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @max_cadence.setter
    def max_cadence(self, value: int):
        field = self.get_field(SessionMaxCadenceField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def max_running_cadence(self) -> Optional[int]:
        field = self.get_field(SessionMaxCadenceField.ID)
        type_field = self.get_field(SessionSportField.ID)

        is_sub_field_valid = type_field and type_field.get_value() in [1]
        if field and field.is_valid() and is_sub_field_valid:
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @max_running_cadence.setter
    def max_running_cadence(self, value: int):
        field = self.get_field(SessionMaxCadenceField.ID)
        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_power(self) -> Optional[int]:
        field = self.get_field(SessionAvgPowerField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_power.setter
    def avg_power(self, value: int):
        field = self.get_field(SessionAvgPowerField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def max_power(self) -> Optional[int]:
        field = self.get_field(SessionMaxPowerField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @max_power.setter
    def max_power(self, value: int):
        field = self.get_field(SessionMaxPowerField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def total_ascent(self) -> Optional[int]:
        field = self.get_field(SessionTotalAscentField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @total_ascent.setter
    def total_ascent(self, value: int):
        field = self.get_field(SessionTotalAscentField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def total_descent(self) -> Optional[int]:
        field = self.get_field(SessionTotalDescentField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @total_descent.setter
    def total_descent(self, value: int):
        field = self.get_field(SessionTotalDescentField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def total_training_effect(self) -> Optional[float]:
        field = self.get_field(SessionTotalTrainingEffectField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @total_training_effect.setter
    def total_training_effect(self, value: float):
        field = self.get_field(SessionTotalTrainingEffectField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def first_lap_index(self) -> Optional[int]:
        field = self.get_field(SessionFirstLapIndexField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @first_lap_index.setter
    def first_lap_index(self, value: int):
        field = self.get_field(SessionFirstLapIndexField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def num_laps(self) -> Optional[int]:
        field = self.get_field(SessionNumLapsField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @num_laps.setter
    def num_laps(self, value: int):
        field = self.get_field(SessionNumLapsField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def event_group(self) -> Optional[int]:
        field = self.get_field(SessionEventGroupField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @event_group.setter
    def event_group(self, value: int):
        field = self.get_field(SessionEventGroupField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def trigger(self) -> Optional[SessionTrigger]:
        field = self.get_field(SessionTriggerField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @trigger.setter
    def trigger(self, value: SessionTrigger):
        field = self.get_field(SessionTriggerField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def nec_lat(self) -> Optional[float]:
        field = self.get_field(SessionNecLatField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @nec_lat.setter
    def nec_lat(self, value: float):
        field = self.get_field(SessionNecLatField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def nec_long(self) -> Optional[float]:
        field = self.get_field(SessionNecLongField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @nec_long.setter
    def nec_long(self, value: float):
        field = self.get_field(SessionNecLongField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def swc_lat(self) -> Optional[float]:
        field = self.get_field(SessionSwcLatField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @swc_lat.setter
    def swc_lat(self, value: float):
        field = self.get_field(SessionSwcLatField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def swc_long(self) -> Optional[float]:
        field = self.get_field(SessionSwcLongField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @swc_long.setter
    def swc_long(self, value: float):
        field = self.get_field(SessionSwcLongField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def num_lengths(self) -> Optional[int]:
        field = self.get_field(SessionNumLengthsField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @num_lengths.setter
    def num_lengths(self, value: int):
        field = self.get_field(SessionNumLengthsField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def normalized_power(self) -> Optional[int]:
        field = self.get_field(SessionNormalizedPowerField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @normalized_power.setter
    def normalized_power(self, value: int):
        field = self.get_field(SessionNormalizedPowerField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def training_stress_score(self) -> Optional[float]:
        field = self.get_field(SessionTrainingStressScoreField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @training_stress_score.setter
    def training_stress_score(self, value: float):
        field = self.get_field(SessionTrainingStressScoreField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def intensity_factor(self) -> Optional[float]:
        field = self.get_field(SessionIntensityFactorField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @intensity_factor.setter
    def intensity_factor(self, value: float):
        field = self.get_field(SessionIntensityFactorField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def left_right_balance(self) -> Optional[int]:
        field = self.get_field(SessionLeftRightBalanceField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @left_right_balance.setter
    def left_right_balance(self, value: int):
        field = self.get_field(SessionLeftRightBalanceField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_stroke_count(self) -> Optional[float]:
        field = self.get_field(SessionAvgStrokeCountField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_stroke_count.setter
    def avg_stroke_count(self, value: float):
        field = self.get_field(SessionAvgStrokeCountField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_stroke_distance(self) -> Optional[float]:
        field = self.get_field(SessionAvgStrokeDistanceField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_stroke_distance.setter
    def avg_stroke_distance(self, value: float):
        field = self.get_field(SessionAvgStrokeDistanceField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def swim_stroke(self) -> Optional[SwimStroke]:
        field = self.get_field(SessionSwimStrokeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @swim_stroke.setter
    def swim_stroke(self, value: SwimStroke):
        field = self.get_field(SessionSwimStrokeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def pool_length(self) -> Optional[float]:
        field = self.get_field(SessionPoolLengthField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @pool_length.setter
    def pool_length(self, value: float):
        field = self.get_field(SessionPoolLengthField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def threshold_power(self) -> Optional[int]:
        field = self.get_field(SessionThresholdPowerField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @threshold_power.setter
    def threshold_power(self, value: int):
        field = self.get_field(SessionThresholdPowerField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def pool_length_unit(self) -> Optional[DisplayMeasure]:
        field = self.get_field(SessionPoolLengthUnitField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @pool_length_unit.setter
    def pool_length_unit(self, value: DisplayMeasure):
        field = self.get_field(SessionPoolLengthUnitField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def num_active_lengths(self) -> Optional[int]:
        field = self.get_field(SessionNumActiveLengthsField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @num_active_lengths.setter
    def num_active_lengths(self, value: int):
        field = self.get_field(SessionNumActiveLengthsField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def total_work(self) -> Optional[int]:
        field = self.get_field(SessionTotalWorkField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @total_work.setter
    def total_work(self, value: int):
        field = self.get_field(SessionTotalWorkField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_altitude(self) -> Optional[float]:
        field = self.get_field(SessionAvgAltitudeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_altitude.setter
    def avg_altitude(self, value: float):
        field = self.get_field(SessionAvgAltitudeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def max_altitude(self) -> Optional[float]:
        field = self.get_field(SessionMaxAltitudeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @max_altitude.setter
    def max_altitude(self, value: float):
        field = self.get_field(SessionMaxAltitudeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def gps_accuracy(self) -> Optional[int]:
        field = self.get_field(SessionGpsAccuracyField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @gps_accuracy.setter
    def gps_accuracy(self, value: int):
        field = self.get_field(SessionGpsAccuracyField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_grade(self) -> Optional[float]:
        field = self.get_field(SessionAvgGradeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_grade.setter
    def avg_grade(self, value: float):
        field = self.get_field(SessionAvgGradeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_pos_grade(self) -> Optional[float]:
        field = self.get_field(SessionAvgPosGradeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_pos_grade.setter
    def avg_pos_grade(self, value: float):
        field = self.get_field(SessionAvgPosGradeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_neg_grade(self) -> Optional[float]:
        field = self.get_field(SessionAvgNegGradeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_neg_grade.setter
    def avg_neg_grade(self, value: float):
        field = self.get_field(SessionAvgNegGradeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def max_pos_grade(self) -> Optional[float]:
        field = self.get_field(SessionMaxPosGradeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @max_pos_grade.setter
    def max_pos_grade(self, value: float):
        field = self.get_field(SessionMaxPosGradeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def max_neg_grade(self) -> Optional[float]:
        field = self.get_field(SessionMaxNegGradeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @max_neg_grade.setter
    def max_neg_grade(self, value: float):
        field = self.get_field(SessionMaxNegGradeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_temperature(self) -> Optional[int]:
        field = self.get_field(SessionAvgTemperatureField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_temperature.setter
    def avg_temperature(self, value: int):
        field = self.get_field(SessionAvgTemperatureField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def max_temperature(self) -> Optional[int]:
        field = self.get_field(SessionMaxTemperatureField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @max_temperature.setter
    def max_temperature(self, value: int):
        field = self.get_field(SessionMaxTemperatureField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def total_moving_time(self) -> Optional[float]:
        field = self.get_field(SessionTotalMovingTimeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @total_moving_time.setter
    def total_moving_time(self, value: float):
        field = self.get_field(SessionTotalMovingTimeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_pos_vertical_speed(self) -> Optional[float]:
        field = self.get_field(SessionAvgPosVerticalSpeedField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_pos_vertical_speed.setter
    def avg_pos_vertical_speed(self, value: float):
        field = self.get_field(SessionAvgPosVerticalSpeedField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_neg_vertical_speed(self) -> Optional[float]:
        field = self.get_field(SessionAvgNegVerticalSpeedField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_neg_vertical_speed.setter
    def avg_neg_vertical_speed(self, value: float):
        field = self.get_field(SessionAvgNegVerticalSpeedField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def max_pos_vertical_speed(self) -> Optional[float]:
        field = self.get_field(SessionMaxPosVerticalSpeedField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @max_pos_vertical_speed.setter
    def max_pos_vertical_speed(self, value: float):
        field = self.get_field(SessionMaxPosVerticalSpeedField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def max_neg_vertical_speed(self) -> Optional[float]:
        field = self.get_field(SessionMaxNegVerticalSpeedField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @max_neg_vertical_speed.setter
    def max_neg_vertical_speed(self, value: float):
        field = self.get_field(SessionMaxNegVerticalSpeedField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def min_heart_rate(self) -> Optional[int]:
        field = self.get_field(SessionMinHeartRateField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @min_heart_rate.setter
    def min_heart_rate(self, value: int):
        field = self.get_field(SessionMinHeartRateField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def time_in_hr_zone(self) -> Optional[float]:
        field = self.get_field(SessionTimeInHrZoneField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @time_in_hr_zone.setter
    def time_in_hr_zone(self, value: float):
        field = self.get_field(SessionTimeInHrZoneField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def time_in_speed_zone(self) -> Optional[float]:
        field = self.get_field(SessionTimeInSpeedZoneField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @time_in_speed_zone.setter
    def time_in_speed_zone(self, value: float):
        field = self.get_field(SessionTimeInSpeedZoneField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def time_in_cadence_zone(self) -> Optional[float]:
        field = self.get_field(SessionTimeInCadenceZoneField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @time_in_cadence_zone.setter
    def time_in_cadence_zone(self, value: float):
        field = self.get_field(SessionTimeInCadenceZoneField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def time_in_power_zone(self) -> Optional[float]:
        field = self.get_field(SessionTimeInPowerZoneField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @time_in_power_zone.setter
    def time_in_power_zone(self, value: float):
        field = self.get_field(SessionTimeInPowerZoneField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_lap_time(self) -> Optional[float]:
        field = self.get_field(SessionAvgLapTimeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_lap_time.setter
    def avg_lap_time(self, value: float):
        field = self.get_field(SessionAvgLapTimeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def best_lap_index(self) -> Optional[int]:
        field = self.get_field(SessionBestLapIndexField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @best_lap_index.setter
    def best_lap_index(self, value: int):
        field = self.get_field(SessionBestLapIndexField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def min_altitude(self) -> Optional[float]:
        field = self.get_field(SessionMinAltitudeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @min_altitude.setter
    def min_altitude(self, value: float):
        field = self.get_field(SessionMinAltitudeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def player_score(self) -> Optional[int]:
        field = self.get_field(SessionPlayerScoreField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @player_score.setter
    def player_score(self, value: int):
        field = self.get_field(SessionPlayerScoreField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def opponent_score(self) -> Optional[int]:
        field = self.get_field(SessionOpponentScoreField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @opponent_score.setter
    def opponent_score(self, value: int):
        field = self.get_field(SessionOpponentScoreField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def opponent_name(self) -> Optional[str]:
        field = self.get_field(SessionOpponentNameField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @opponent_name.setter
    def opponent_name(self, value: str):
        field = self.get_field(SessionOpponentNameField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def stroke_count(self) -> Optional[int]:
        field = self.get_field(SessionStrokeCountField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @stroke_count.setter
    def stroke_count(self, value: int):
        field = self.get_field(SessionStrokeCountField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def zone_count(self) -> Optional[int]:
        field = self.get_field(SessionZoneCountField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @zone_count.setter
    def zone_count(self, value: int):
        field = self.get_field(SessionZoneCountField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def max_ball_speed(self) -> Optional[float]:
        field = self.get_field(SessionMaxBallSpeedField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @max_ball_speed.setter
    def max_ball_speed(self, value: float):
        field = self.get_field(SessionMaxBallSpeedField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_ball_speed(self) -> Optional[float]:
        field = self.get_field(SessionAvgBallSpeedField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_ball_speed.setter
    def avg_ball_speed(self, value: float):
        field = self.get_field(SessionAvgBallSpeedField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_vertical_oscillation(self) -> Optional[float]:
        field = self.get_field(SessionAvgVerticalOscillationField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_vertical_oscillation.setter
    def avg_vertical_oscillation(self, value: float):
        field = self.get_field(SessionAvgVerticalOscillationField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_stance_time_percent(self) -> Optional[float]:
        field = self.get_field(SessionAvgStanceTimePercentField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_stance_time_percent.setter
    def avg_stance_time_percent(self, value: float):
        field = self.get_field(SessionAvgStanceTimePercentField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_stance_time(self) -> Optional[float]:
        field = self.get_field(SessionAvgStanceTimeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_stance_time.setter
    def avg_stance_time(self, value: float):
        field = self.get_field(SessionAvgStanceTimeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_fractional_cadence(self) -> Optional[float]:
        field = self.get_field(SessionAvgFractionalCadenceField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_fractional_cadence.setter
    def avg_fractional_cadence(self, value: float):
        field = self.get_field(SessionAvgFractionalCadenceField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def max_fractional_cadence(self) -> Optional[float]:
        field = self.get_field(SessionMaxFractionalCadenceField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @max_fractional_cadence.setter
    def max_fractional_cadence(self, value: float):
        field = self.get_field(SessionMaxFractionalCadenceField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def total_fractional_cycles(self) -> Optional[float]:
        field = self.get_field(SessionTotalFractionalCyclesField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @total_fractional_cycles.setter
    def total_fractional_cycles(self, value: float):
        field = self.get_field(SessionTotalFractionalCyclesField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_total_hemoglobin_conc(self) -> Optional[float]:
        field = self.get_field(SessionAvgTotalHemoglobinConcField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_total_hemoglobin_conc.setter
    def avg_total_hemoglobin_conc(self, value: float):
        field = self.get_field(SessionAvgTotalHemoglobinConcField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def min_total_hemoglobin_conc(self) -> Optional[float]:
        field = self.get_field(SessionMinTotalHemoglobinConcField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @min_total_hemoglobin_conc.setter
    def min_total_hemoglobin_conc(self, value: float):
        field = self.get_field(SessionMinTotalHemoglobinConcField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def max_total_hemoglobin_conc(self) -> Optional[float]:
        field = self.get_field(SessionMaxTotalHemoglobinConcField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @max_total_hemoglobin_conc.setter
    def max_total_hemoglobin_conc(self, value: float):
        field = self.get_field(SessionMaxTotalHemoglobinConcField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_saturated_hemoglobin_percent(self) -> Optional[float]:
        field = self.get_field(SessionAvgSaturatedHemoglobinPercentField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_saturated_hemoglobin_percent.setter
    def avg_saturated_hemoglobin_percent(self, value: float):
        field = self.get_field(SessionAvgSaturatedHemoglobinPercentField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def min_saturated_hemoglobin_percent(self) -> Optional[float]:
        field = self.get_field(SessionMinSaturatedHemoglobinPercentField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @min_saturated_hemoglobin_percent.setter
    def min_saturated_hemoglobin_percent(self, value: float):
        field = self.get_field(SessionMinSaturatedHemoglobinPercentField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def max_saturated_hemoglobin_percent(self) -> Optional[float]:
        field = self.get_field(SessionMaxSaturatedHemoglobinPercentField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @max_saturated_hemoglobin_percent.setter
    def max_saturated_hemoglobin_percent(self, value: float):
        field = self.get_field(SessionMaxSaturatedHemoglobinPercentField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_left_torque_effectiveness(self) -> Optional[float]:
        field = self.get_field(SessionAvgLeftTorqueEffectivenessField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_left_torque_effectiveness.setter
    def avg_left_torque_effectiveness(self, value: float):
        field = self.get_field(SessionAvgLeftTorqueEffectivenessField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_right_torque_effectiveness(self) -> Optional[float]:
        field = self.get_field(SessionAvgRightTorqueEffectivenessField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_right_torque_effectiveness.setter
    def avg_right_torque_effectiveness(self, value: float):
        field = self.get_field(SessionAvgRightTorqueEffectivenessField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_left_pedal_smoothness(self) -> Optional[float]:
        field = self.get_field(SessionAvgLeftPedalSmoothnessField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_left_pedal_smoothness.setter
    def avg_left_pedal_smoothness(self, value: float):
        field = self.get_field(SessionAvgLeftPedalSmoothnessField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_right_pedal_smoothness(self) -> Optional[float]:
        field = self.get_field(SessionAvgRightPedalSmoothnessField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_right_pedal_smoothness.setter
    def avg_right_pedal_smoothness(self, value: float):
        field = self.get_field(SessionAvgRightPedalSmoothnessField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_combined_pedal_smoothness(self) -> Optional[float]:
        field = self.get_field(SessionAvgCombinedPedalSmoothnessField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_combined_pedal_smoothness.setter
    def avg_combined_pedal_smoothness(self, value: float):
        field = self.get_field(SessionAvgCombinedPedalSmoothnessField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def sport_index(self) -> Optional[int]:
        field = self.get_field(SessionSportIndexField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @sport_index.setter
    def sport_index(self, value: int):
        field = self.get_field(SessionSportIndexField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def time_standing(self) -> Optional[float]:
        field = self.get_field(SessionTimeStandingField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @time_standing.setter
    def time_standing(self, value: float):
        field = self.get_field(SessionTimeStandingField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def stand_count(self) -> Optional[int]:
        field = self.get_field(SessionStandCountField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @stand_count.setter
    def stand_count(self, value: int):
        field = self.get_field(SessionStandCountField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_left_pco(self) -> Optional[int]:
        field = self.get_field(SessionAvgLeftPcoField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_left_pco.setter
    def avg_left_pco(self, value: int):
        field = self.get_field(SessionAvgLeftPcoField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_right_pco(self) -> Optional[int]:
        field = self.get_field(SessionAvgRightPcoField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_right_pco.setter
    def avg_right_pco(self, value: int):
        field = self.get_field(SessionAvgRightPcoField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_left_power_phase(self) -> Optional[float]:
        field = self.get_field(SessionAvgLeftPowerPhaseField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_left_power_phase.setter
    def avg_left_power_phase(self, value: float):
        field = self.get_field(SessionAvgLeftPowerPhaseField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_left_power_phase_peak(self) -> Optional[float]:
        field = self.get_field(SessionAvgLeftPowerPhasePeakField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_left_power_phase_peak.setter
    def avg_left_power_phase_peak(self, value: float):
        field = self.get_field(SessionAvgLeftPowerPhasePeakField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_right_power_phase(self) -> Optional[float]:
        field = self.get_field(SessionAvgRightPowerPhaseField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_right_power_phase.setter
    def avg_right_power_phase(self, value: float):
        field = self.get_field(SessionAvgRightPowerPhaseField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_right_power_phase_peak(self) -> Optional[float]:
        field = self.get_field(SessionAvgRightPowerPhasePeakField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_right_power_phase_peak.setter
    def avg_right_power_phase_peak(self, value: float):
        field = self.get_field(SessionAvgRightPowerPhasePeakField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_power_position(self) -> Optional[int]:
        field = self.get_field(SessionAvgPowerPositionField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_power_position.setter
    def avg_power_position(self, value: int):
        field = self.get_field(SessionAvgPowerPositionField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def max_power_position(self) -> Optional[int]:
        field = self.get_field(SessionMaxPowerPositionField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @max_power_position.setter
    def max_power_position(self, value: int):
        field = self.get_field(SessionMaxPowerPositionField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_cadence_position(self) -> Optional[int]:
        field = self.get_field(SessionAvgCadencePositionField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_cadence_position.setter
    def avg_cadence_position(self, value: int):
        field = self.get_field(SessionAvgCadencePositionField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def max_cadence_position(self) -> Optional[int]:
        field = self.get_field(SessionMaxCadencePositionField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @max_cadence_position.setter
    def max_cadence_position(self, value: int):
        field = self.get_field(SessionMaxCadencePositionField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def enhanced_avg_speed(self) -> Optional[float]:
        field = self.get_field(SessionEnhancedAvgSpeedField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @enhanced_avg_speed.setter
    def enhanced_avg_speed(self, value: float):
        field = self.get_field(SessionEnhancedAvgSpeedField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def enhanced_max_speed(self) -> Optional[float]:
        field = self.get_field(SessionEnhancedMaxSpeedField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @enhanced_max_speed.setter
    def enhanced_max_speed(self, value: float):
        field = self.get_field(SessionEnhancedMaxSpeedField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def enhanced_avg_altitude(self) -> Optional[float]:
        field = self.get_field(SessionEnhancedAvgAltitudeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @enhanced_avg_altitude.setter
    def enhanced_avg_altitude(self, value: float):
        field = self.get_field(SessionEnhancedAvgAltitudeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def enhanced_min_altitude(self) -> Optional[float]:
        field = self.get_field(SessionEnhancedMinAltitudeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @enhanced_min_altitude.setter
    def enhanced_min_altitude(self, value: float):
        field = self.get_field(SessionEnhancedMinAltitudeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def enhanced_max_altitude(self) -> Optional[float]:
        field = self.get_field(SessionEnhancedMaxAltitudeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @enhanced_max_altitude.setter
    def enhanced_max_altitude(self, value: float):
        field = self.get_field(SessionEnhancedMaxAltitudeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_lev_motor_power(self) -> Optional[int]:
        field = self.get_field(SessionAvgLevMotorPowerField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_lev_motor_power.setter
    def avg_lev_motor_power(self, value: int):
        field = self.get_field(SessionAvgLevMotorPowerField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def max_lev_motor_power(self) -> Optional[int]:
        field = self.get_field(SessionMaxLevMotorPowerField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @max_lev_motor_power.setter
    def max_lev_motor_power(self, value: int):
        field = self.get_field(SessionMaxLevMotorPowerField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def lev_battery_consumption(self) -> Optional[float]:
        field = self.get_field(SessionLevBatteryConsumptionField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @lev_battery_consumption.setter
    def lev_battery_consumption(self, value: float):
        field = self.get_field(SessionLevBatteryConsumptionField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_vertical_ratio(self) -> Optional[float]:
        field = self.get_field(SessionAvgVerticalRatioField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_vertical_ratio.setter
    def avg_vertical_ratio(self, value: float):
        field = self.get_field(SessionAvgVerticalRatioField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_stance_time_balance(self) -> Optional[float]:
        field = self.get_field(SessionAvgStanceTimeBalanceField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_stance_time_balance.setter
    def avg_stance_time_balance(self, value: float):
        field = self.get_field(SessionAvgStanceTimeBalanceField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_step_length(self) -> Optional[float]:
        field = self.get_field(SessionAvgStepLengthField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_step_length.setter
    def avg_step_length(self, value: float):
        field = self.get_field(SessionAvgStepLengthField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def total_anaerobic_training_effect(self) -> Optional[float]:
        field = self.get_field(SessionTotalAnaerobicTrainingEffectField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @total_anaerobic_training_effect.setter
    def total_anaerobic_training_effect(self, value: float):
        field = self.get_field(SessionTotalAnaerobicTrainingEffectField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_vam(self) -> Optional[float]:
        field = self.get_field(SessionAvgVamField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_vam.setter
    def avg_vam(self, value: float):
        field = self.get_field(SessionAvgVamField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def total_grit(self) -> Optional[float]:
        field = self.get_field(SessionTotalGritField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @total_grit.setter
    def total_grit(self, value: float):
        field = self.get_field(SessionTotalGritField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def total_flow(self) -> Optional[float]:
        field = self.get_field(SessionTotalFlowField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @total_flow.setter
    def total_flow(self, value: float):
        field = self.get_field(SessionTotalFlowField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def jump_count(self) -> Optional[int]:
        field = self.get_field(SessionJumpCountField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @jump_count.setter
    def jump_count(self, value: int):
        field = self.get_field(SessionJumpCountField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_grit(self) -> Optional[float]:
        field = self.get_field(SessionAvgGritField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_grit.setter
    def avg_grit(self, value: float):
        field = self.get_field(SessionAvgGritField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_flow(self) -> Optional[float]:
        field = self.get_field(SessionAvgFlowField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_flow.setter
    def avg_flow(self, value: float):
        field = self.get_field(SessionAvgFlowField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def total_fractional_ascent(self) -> Optional[float]:
        field = self.get_field(SessionTotalFractionalAscentField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @total_fractional_ascent.setter
    def total_fractional_ascent(self, value: float):
        field = self.get_field(SessionTotalFractionalAscentField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def total_fractional_descent(self) -> Optional[float]:
        field = self.get_field(SessionTotalFractionalDescentField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @total_fractional_descent.setter
    def total_fractional_descent(self, value: float):
        field = self.get_field(SessionTotalFractionalDescentField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def avg_core_temperature(self) -> Optional[float]:
        field = self.get_field(SessionAvgCoreTemperatureField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @avg_core_temperature.setter
    def avg_core_temperature(self, value: float):
        field = self.get_field(SessionAvgCoreTemperatureField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def min_core_temperature(self) -> Optional[float]:
        field = self.get_field(SessionMinCoreTemperatureField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @min_core_temperature.setter
    def min_core_temperature(self, value: float):
        field = self.get_field(SessionMinCoreTemperatureField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def max_core_temperature(self) -> Optional[float]:
        field = self.get_field(SessionMaxCoreTemperatureField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @max_core_temperature.setter
    def max_core_temperature(self, value: float):
        field = self.get_field(SessionMaxCoreTemperatureField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)


class MessageIndexField(Field):
    ID = 254

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='message_index',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class TimestampField(Field):
    ID = 253

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='timestamp',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=-631065600000,
            scale=0.001,
            size=size,
            units='ms',
            type_name='date_time',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionEventField(Field):
    ID = 0

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='event',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class SessionEventTypeField(Field):
    ID = 1

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='event_type',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class SessionStartTimeField(Field):
    ID = 2

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='start_time',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=-631065600000,
            scale=0.001,
            size=size,
            units='ms',
            type_name='date_time',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionStartPositionLatField(Field):
    ID = 3

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='start_position_lat',
            field_id=self.ID,
            base_type=BaseType.SINT32,
            offset=0,
            scale=11930464.711111112,
            size=size,
            units='degrees',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionStartPositionLongField(Field):
    ID = 4

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='start_position_long',
            field_id=self.ID,
            base_type=BaseType.SINT32,
            offset=0,
            scale=11930464.711111112,
            size=size,
            units='degrees',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionSportField(Field):
    ID = 5

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='sport',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class SessionSubSportField(Field):
    ID = 6

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='sub_sport',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class SessionTotalElapsedTimeField(Field):
    ID = 7

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='total_elapsed_time',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1000,
            size=size,
            units='s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionTotalTimerTimeField(Field):
    ID = 8

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='total_timer_time',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1000,
            size=size,
            units='s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionTotalDistanceField(Field):
    ID = 9

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='total_distance',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=100,
            size=size,
            units='m',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionTotalCyclesField(Field):
    ID = 10

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='total_cycles',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1,
            size=size,
            units='cycles',
            type_name='',
            growable=growable,
            sub_fields=[
                SubField(
                    name='total_strides',
                    base_type=BaseType.UINT32,
                    scale=1,
                    offset=0,
                    units='strides',
                    reference_map={
                        SessionSportField.ID: [1, 11]
                    }),
                SubField(
                    name='total_strokes',
                    base_type=BaseType.UINT32,
                    scale=1,
                    offset=0,
                    units='strokes',
                    reference_map={
                        SessionSportField.ID: [2, 5, 15, 37]
                    })
            ]
        )


class SessionTotalCaloriesField(Field):
    ID = 11

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='total_calories',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='kcal',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionTotalFatCaloriesField(Field):
    ID = 13

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='total_fat_calories',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='kcal',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionAvgSpeedField(Field):
    ID = 14

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_speed',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1000,
            size=size,
            units='m/s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionMaxSpeedField(Field):
    ID = 15

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='max_speed',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1000,
            size=size,
            units='m/s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionAvgHeartRateField(Field):
    ID = 16

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_heart_rate',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            units='bpm',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionMaxHeartRateField(Field):
    ID = 17

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='max_heart_rate',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            units='bpm',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionAvgCadenceField(Field):
    ID = 18

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_cadence',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            units='rpm',
            type_name='',
            growable=growable,
            sub_fields=[
                SubField(
                    name='avg_running_cadence',
                    base_type=BaseType.UINT8,
                    scale=1,
                    offset=0,
                    units='strides/min',
                    reference_map={
                        SessionSportField.ID: [1]
                    })
            ]
        )


class SessionMaxCadenceField(Field):
    ID = 19

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='max_cadence',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            units='rpm',
            type_name='',
            growable=growable,
            sub_fields=[
                SubField(
                    name='max_running_cadence',
                    base_type=BaseType.UINT8,
                    scale=1,
                    offset=0,
                    units='strides/min',
                    reference_map={
                        SessionSportField.ID: [1]
                    })
            ]
        )


class SessionAvgPowerField(Field):
    ID = 20

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_power',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='watts',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionMaxPowerField(Field):
    ID = 21

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='max_power',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='watts',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionTotalAscentField(Field):
    ID = 22

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='total_ascent',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='m',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionTotalDescentField(Field):
    ID = 23

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='total_descent',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='m',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionTotalTrainingEffectField(Field):
    ID = 24

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='total_training_effect',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=10,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class SessionFirstLapIndexField(Field):
    ID = 25

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='first_lap_index',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class SessionNumLapsField(Field):
    ID = 26

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='num_laps',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class SessionEventGroupField(Field):
    ID = 27

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='event_group',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class SessionTriggerField(Field):
    ID = 28

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='trigger',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class SessionNecLatField(Field):
    ID = 29

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='nec_lat',
            field_id=self.ID,
            base_type=BaseType.SINT32,
            offset=0,
            scale=11930464.711111112,
            size=size,
            units='degrees',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionNecLongField(Field):
    ID = 30

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='nec_long',
            field_id=self.ID,
            base_type=BaseType.SINT32,
            offset=0,
            scale=11930464.711111112,
            size=size,
            units='degrees',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionSwcLatField(Field):
    ID = 31

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='swc_lat',
            field_id=self.ID,
            base_type=BaseType.SINT32,
            offset=0,
            scale=11930464.711111112,
            size=size,
            units='degrees',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionSwcLongField(Field):
    ID = 32

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='swc_long',
            field_id=self.ID,
            base_type=BaseType.SINT32,
            offset=0,
            scale=11930464.711111112,
            size=size,
            units='degrees',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionNumLengthsField(Field):
    ID = 33

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='num_lengths',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='lengths',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionNormalizedPowerField(Field):
    ID = 34

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='normalized_power',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='watts',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionTrainingStressScoreField(Field):
    ID = 35

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='training_stress_score',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=10,
            size=size,
            units='tss',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionIntensityFactorField(Field):
    ID = 36

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='intensity_factor',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1000,
            size=size,
            units='if',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionLeftRightBalanceField(Field):
    ID = 37

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='left_right_balance',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class SessionAvgStrokeCountField(Field):
    ID = 41

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_stroke_count',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=10,
            size=size,
            units='strokes/lap',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionAvgStrokeDistanceField(Field):
    ID = 42

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_stroke_distance',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=100,
            size=size,
            units='m',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionSwimStrokeField(Field):
    ID = 43

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='swim_stroke',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            units='swim_stroke',
            type_name='swim_stroke',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionPoolLengthField(Field):
    ID = 44

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='pool_length',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=100,
            size=size,
            units='m',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionThresholdPowerField(Field):
    ID = 45

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='threshold_power',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='watts',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionPoolLengthUnitField(Field):
    ID = 46

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='pool_length_unit',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class SessionNumActiveLengthsField(Field):
    ID = 47

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='num_active_lengths',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='lengths',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionTotalWorkField(Field):
    ID = 48

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='total_work',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1,
            size=size,
            units='J',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionAvgAltitudeField(Field):
    ID = 49

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_altitude',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=500,
            scale=5,
            size=size,
            units='m',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionMaxAltitudeField(Field):
    ID = 50

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='max_altitude',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=500,
            scale=5,
            size=size,
            units='m',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionGpsAccuracyField(Field):
    ID = 51

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='gps_accuracy',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            units='m',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionAvgGradeField(Field):
    ID = 52

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_grade',
            field_id=self.ID,
            base_type=BaseType.SINT16,
            offset=0,
            scale=100,
            size=size,
            units='%',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionAvgPosGradeField(Field):
    ID = 53

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_pos_grade',
            field_id=self.ID,
            base_type=BaseType.SINT16,
            offset=0,
            scale=100,
            size=size,
            units='%',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionAvgNegGradeField(Field):
    ID = 54

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_neg_grade',
            field_id=self.ID,
            base_type=BaseType.SINT16,
            offset=0,
            scale=100,
            size=size,
            units='%',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionMaxPosGradeField(Field):
    ID = 55

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='max_pos_grade',
            field_id=self.ID,
            base_type=BaseType.SINT16,
            offset=0,
            scale=100,
            size=size,
            units='%',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionMaxNegGradeField(Field):
    ID = 56

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='max_neg_grade',
            field_id=self.ID,
            base_type=BaseType.SINT16,
            offset=0,
            scale=100,
            size=size,
            units='%',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionAvgTemperatureField(Field):
    ID = 57

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_temperature',
            field_id=self.ID,
            base_type=BaseType.SINT8,
            offset=0,
            scale=1,
            size=size,
            units='C',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionMaxTemperatureField(Field):
    ID = 58

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='max_temperature',
            field_id=self.ID,
            base_type=BaseType.SINT8,
            offset=0,
            scale=1,
            size=size,
            units='C',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionTotalMovingTimeField(Field):
    ID = 59

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='total_moving_time',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1000,
            size=size,
            units='s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionAvgPosVerticalSpeedField(Field):
    ID = 60

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_pos_vertical_speed',
            field_id=self.ID,
            base_type=BaseType.SINT16,
            offset=0,
            scale=1000,
            size=size,
            units='m/s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionAvgNegVerticalSpeedField(Field):
    ID = 61

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_neg_vertical_speed',
            field_id=self.ID,
            base_type=BaseType.SINT16,
            offset=0,
            scale=1000,
            size=size,
            units='m/s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionMaxPosVerticalSpeedField(Field):
    ID = 62

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='max_pos_vertical_speed',
            field_id=self.ID,
            base_type=BaseType.SINT16,
            offset=0,
            scale=1000,
            size=size,
            units='m/s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionMaxNegVerticalSpeedField(Field):
    ID = 63

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='max_neg_vertical_speed',
            field_id=self.ID,
            base_type=BaseType.SINT16,
            offset=0,
            scale=1000,
            size=size,
            units='m/s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionMinHeartRateField(Field):
    ID = 64

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='min_heart_rate',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            units='bpm',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionTimeInHrZoneField(Field):
    ID = 65

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='time_in_hr_zone',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1000,
            size=size,
            units='s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionTimeInSpeedZoneField(Field):
    ID = 66

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='time_in_speed_zone',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1000,
            size=size,
            units='s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionTimeInCadenceZoneField(Field):
    ID = 67

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='time_in_cadence_zone',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1000,
            size=size,
            units='s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionTimeInPowerZoneField(Field):
    ID = 68

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='time_in_power_zone',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1000,
            size=size,
            units='s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionAvgLapTimeField(Field):
    ID = 69

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_lap_time',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1000,
            size=size,
            units='s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionBestLapIndexField(Field):
    ID = 70

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='best_lap_index',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class SessionMinAltitudeField(Field):
    ID = 71

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='min_altitude',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=500,
            scale=5,
            size=size,
            units='m',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionPlayerScoreField(Field):
    ID = 82

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='player_score',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class SessionOpponentScoreField(Field):
    ID = 83

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='opponent_score',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class SessionOpponentNameField(Field):
    ID = 84

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='opponent_name',
            field_id=self.ID,
            base_type=BaseType.STRING,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class SessionStrokeCountField(Field):
    ID = 85

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='stroke_count',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='counts',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionZoneCountField(Field):
    ID = 86

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='zone_count',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='counts',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionMaxBallSpeedField(Field):
    ID = 87

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='max_ball_speed',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=100,
            size=size,
            units='m/s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionAvgBallSpeedField(Field):
    ID = 88

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_ball_speed',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=100,
            size=size,
            units='m/s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionAvgVerticalOscillationField(Field):
    ID = 89

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_vertical_oscillation',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=10,
            size=size,
            units='mm',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionAvgStanceTimePercentField(Field):
    ID = 90

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_stance_time_percent',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=100,
            size=size,
            units='percent',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionAvgStanceTimeField(Field):
    ID = 91

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_stance_time',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=10,
            size=size,
            units='ms',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionAvgFractionalCadenceField(Field):
    ID = 92

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_fractional_cadence',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=128,
            size=size,
            units='rpm',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionMaxFractionalCadenceField(Field):
    ID = 93

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='max_fractional_cadence',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=128,
            size=size,
            units='rpm',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionTotalFractionalCyclesField(Field):
    ID = 94

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='total_fractional_cycles',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=128,
            size=size,
            units='cycles',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionAvgTotalHemoglobinConcField(Field):
    ID = 95

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_total_hemoglobin_conc',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=100,
            size=size,
            units='g/dL',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionMinTotalHemoglobinConcField(Field):
    ID = 96

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='min_total_hemoglobin_conc',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=100,
            size=size,
            units='g/dL',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionMaxTotalHemoglobinConcField(Field):
    ID = 97

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='max_total_hemoglobin_conc',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=100,
            size=size,
            units='g/dL',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionAvgSaturatedHemoglobinPercentField(Field):
    ID = 98

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_saturated_hemoglobin_percent',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=10,
            size=size,
            units='%',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionMinSaturatedHemoglobinPercentField(Field):
    ID = 99

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='min_saturated_hemoglobin_percent',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=10,
            size=size,
            units='%',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionMaxSaturatedHemoglobinPercentField(Field):
    ID = 100

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='max_saturated_hemoglobin_percent',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=10,
            size=size,
            units='%',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionAvgLeftTorqueEffectivenessField(Field):
    ID = 101

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_left_torque_effectiveness',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=2,
            size=size,
            units='percent',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionAvgRightTorqueEffectivenessField(Field):
    ID = 102

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_right_torque_effectiveness',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=2,
            size=size,
            units='percent',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionAvgLeftPedalSmoothnessField(Field):
    ID = 103

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_left_pedal_smoothness',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=2,
            size=size,
            units='percent',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionAvgRightPedalSmoothnessField(Field):
    ID = 104

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_right_pedal_smoothness',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=2,
            size=size,
            units='percent',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionAvgCombinedPedalSmoothnessField(Field):
    ID = 105

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_combined_pedal_smoothness',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=2,
            size=size,
            units='percent',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionSportIndexField(Field):
    ID = 111

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='sport_index',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class SessionTimeStandingField(Field):
    ID = 112

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='time_standing',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1000,
            size=size,
            units='s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionStandCountField(Field):
    ID = 113

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='stand_count',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class SessionAvgLeftPcoField(Field):
    ID = 114

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_left_pco',
            field_id=self.ID,
            base_type=BaseType.SINT8,
            offset=0,
            scale=1,
            size=size,
            units='mm',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionAvgRightPcoField(Field):
    ID = 115

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_right_pco',
            field_id=self.ID,
            base_type=BaseType.SINT8,
            offset=0,
            scale=1,
            size=size,
            units='mm',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionAvgLeftPowerPhaseField(Field):
    ID = 116

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_left_power_phase',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=0.7111111,
            size=size,
            units='degrees',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionAvgLeftPowerPhasePeakField(Field):
    ID = 117

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_left_power_phase_peak',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=0.7111111,
            size=size,
            units='degrees',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionAvgRightPowerPhaseField(Field):
    ID = 118

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_right_power_phase',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=0.7111111,
            size=size,
            units='degrees',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionAvgRightPowerPhasePeakField(Field):
    ID = 119

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_right_power_phase_peak',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=0.7111111,
            size=size,
            units='degrees',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionAvgPowerPositionField(Field):
    ID = 120

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_power_position',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='watts',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionMaxPowerPositionField(Field):
    ID = 121

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='max_power_position',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='watts',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionAvgCadencePositionField(Field):
    ID = 122

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_cadence_position',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            units='rpm',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionMaxCadencePositionField(Field):
    ID = 123

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='max_cadence_position',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            units='rpm',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionEnhancedAvgSpeedField(Field):
    ID = 124

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='enhanced_avg_speed',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1000,
            size=size,
            units='m/s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionEnhancedMaxSpeedField(Field):
    ID = 125

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='enhanced_max_speed',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=0,
            scale=1000,
            size=size,
            units='m/s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionEnhancedAvgAltitudeField(Field):
    ID = 126

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='enhanced_avg_altitude',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=500,
            scale=5,
            size=size,
            units='m',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionEnhancedMinAltitudeField(Field):
    ID = 127

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='enhanced_min_altitude',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=500,
            scale=5,
            size=size,
            units='m',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionEnhancedMaxAltitudeField(Field):
    ID = 128

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='enhanced_max_altitude',
            field_id=self.ID,
            base_type=BaseType.UINT32,
            offset=500,
            scale=5,
            size=size,
            units='m',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionAvgLevMotorPowerField(Field):
    ID = 129

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_lev_motor_power',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='watts',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionMaxLevMotorPowerField(Field):
    ID = 130

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='max_lev_motor_power',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            units='watts',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionLevBatteryConsumptionField(Field):
    ID = 131

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='lev_battery_consumption',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=2,
            size=size,
            units='percent',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionAvgVerticalRatioField(Field):
    ID = 132

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_vertical_ratio',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=100,
            size=size,
            units='percent',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionAvgStanceTimeBalanceField(Field):
    ID = 133

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_stance_time_balance',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=100,
            size=size,
            units='percent',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionAvgStepLengthField(Field):
    ID = 134

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_step_length',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=10,
            size=size,
            units='mm',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionTotalAnaerobicTrainingEffectField(Field):
    ID = 137

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='total_anaerobic_training_effect',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=10,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class SessionAvgVamField(Field):
    ID = 139

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_vam',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1000,
            size=size,
            units='m/s',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionTotalGritField(Field):
    ID = 181

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='total_grit',
            field_id=self.ID,
            base_type=BaseType.FLOAT32,
            offset=0,
            scale=1,
            size=size,
            units='kGrit',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionTotalFlowField(Field):
    ID = 182

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='total_flow',
            field_id=self.ID,
            base_type=BaseType.FLOAT32,
            offset=0,
            scale=1,
            size=size,
            units='Flow',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionJumpCountField(Field):
    ID = 183

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='jump_count',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class SessionAvgGritField(Field):
    ID = 186

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_grit',
            field_id=self.ID,
            base_type=BaseType.FLOAT32,
            offset=0,
            scale=1,
            size=size,
            units='kGrit',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionAvgFlowField(Field):
    ID = 187

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_flow',
            field_id=self.ID,
            base_type=BaseType.FLOAT32,
            offset=0,
            scale=1,
            size=size,
            units='Flow',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionTotalFractionalAscentField(Field):
    ID = 199

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='total_fractional_ascent',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=100,
            size=size,
            units='m',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionTotalFractionalDescentField(Field):
    ID = 200

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='total_fractional_descent',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=100,
            size=size,
            units='m',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionAvgCoreTemperatureField(Field):
    ID = 208

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='avg_core_temperature',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=100,
            size=size,
            units='C',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionMinCoreTemperatureField(Field):
    ID = 209

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='min_core_temperature',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=100,
            size=size,
            units='C',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )


class SessionMaxCoreTemperatureField(Field):
    ID = 210

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='max_core_temperature',
            field_id=self.ID,
            base_type=BaseType.UINT16,
            offset=0,
            scale=100,
            size=size,
            units='C',
            type_name='',
            growable=growable,
            sub_fields=[
            ]
        )
