# Autogenerated. Do not modify.
#
# Profile: 21.60
from typing import List as list
from typing import Optional

from fit_tool.base_type import BaseType
from fit_tool.data_message import DataMessage
from fit_tool.definition_message import DefinitionMessage
from fit_tool.developer_field import DeveloperField
from fit_tool.endian import Endian
from fit_tool.field import Field
from fit_tool.profile.profile_type import *


class ExdDataFieldConfigurationMessage(DataMessage):
    ID = 201
    NAME = 'exd_data_field_configuration'

    @staticmethod
    def __get_field_size(definition_message: DefinitionMessage, field_id: int) -> int:
        size = 0
        if definition_message:
            field_definition = definition_message.get_field_definition(field_id)
            if field_definition:
                size = field_definition.size

        return size

    def __init__(self, definition_message=None, developer_fields=None, local_id: int = 0,
                 endian: Endian = Endian.LITTLE):
        super().__init__(name=ExdDataFieldConfigurationMessage.NAME,
                         global_id=ExdDataFieldConfigurationMessage.ID,
                         local_id=definition_message.local_id if definition_message else local_id,
                         endian=definition_message.endian if definition_message else endian,
                         definition_message=definition_message,
                         developer_fields=developer_fields,
                         fields=[
                             ExdDataFieldConfigurationScreenIndexField(
                                 size=self.__get_field_size(definition_message,
                                                            ExdDataFieldConfigurationScreenIndexField.ID),
                                 growable=definition_message is None),
                             ExdDataFieldConfigurationConceptField(
                                 size=self.__get_field_size(definition_message,
                                                            ExdDataFieldConfigurationConceptField.ID),
                                 growable=definition_message is None),
                             ExdDataFieldConfigurationFieldIdField(
                                 size=self.__get_field_size(definition_message,
                                                            ExdDataFieldConfigurationFieldIdField.ID),
                                 growable=definition_message is None),
                             ExdDataFieldConfigurationConceptCountField(
                                 size=self.__get_field_size(definition_message,
                                                            ExdDataFieldConfigurationConceptCountField.ID),
                                 growable=definition_message is None),
                             ExdDataFieldConfigurationDisplayTypeField(
                                 size=self.__get_field_size(definition_message,
                                                            ExdDataFieldConfigurationDisplayTypeField.ID),
                                 growable=definition_message is None),
                             ExdDataFieldConfigurationTitleField(
                                 size=self.__get_field_size(definition_message, ExdDataFieldConfigurationTitleField.ID),
                                 growable=definition_message is None)
                         ])

        self.growable = self.definition_message is None

    @classmethod
    def from_bytes(cls, definition_message: DefinitionMessage, developer_fields: list[DeveloperField],
                   bytes_buffer: bytes, offset: int = 0):
        message = cls(definition_message=definition_message, developer_fields=developer_fields)
        message.read_from_bytes(bytes_buffer, offset)
        return message

    @property
    def screen_index(self) -> Optional[int]:
        field = self.get_field(ExdDataFieldConfigurationScreenIndexField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @screen_index.setter
    def screen_index(self, value: int):
        field = self.get_field(ExdDataFieldConfigurationScreenIndexField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def concept_field(self) -> Optional[int]:
        field = self.get_field(ExdDataFieldConfigurationConceptField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @concept_field.setter
    def concept_field(self, value: int):
        field = self.get_field(ExdDataFieldConfigurationConceptField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def field_id(self) -> Optional[int]:
        field = self.get_field(ExdDataFieldConfigurationFieldIdField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @field_id.setter
    def field_id(self, value: int):
        field = self.get_field(ExdDataFieldConfigurationFieldIdField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def concept_count(self) -> Optional[int]:
        field = self.get_field(ExdDataFieldConfigurationConceptCountField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @concept_count.setter
    def concept_count(self, value: int):
        field = self.get_field(ExdDataFieldConfigurationConceptCountField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def display_type(self) -> Optional[ExdDisplayType]:
        field = self.get_field(ExdDataFieldConfigurationDisplayTypeField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @display_type.setter
    def display_type(self, value: ExdDisplayType):
        field = self.get_field(ExdDataFieldConfigurationDisplayTypeField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)

    @property
    def title(self) -> Optional[str]:
        field = self.get_field(ExdDataFieldConfigurationTitleField.ID)
        if field and field.is_valid():
            sub_field = field.get_valid_sub_field(self.fields)
            return field.get_value(sub_field=sub_field)
        else:
            return None

    @title.setter
    def title(self, value: str):
        field = self.get_field(ExdDataFieldConfigurationTitleField.ID)

        if field:
            if value is None:
                field.clear()
            else:
                sub_field = field.get_valid_sub_field(self.fields)
                field.set_value(0, value, sub_field)


class ExdDataFieldConfigurationScreenIndexField(Field):
    ID = 0

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='screen_index',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class ExdDataFieldConfigurationConceptField(Field):
    ID = 1

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='concept_field',
            field_id=self.ID,
            base_type=BaseType.BYTE,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class ExdDataFieldConfigurationFieldIdField(Field):
    ID = 2

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='field_id',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class ExdDataFieldConfigurationConceptCountField(Field):
    ID = 3

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='concept_count',
            field_id=self.ID,
            base_type=BaseType.UINT8,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class ExdDataFieldConfigurationDisplayTypeField(Field):
    ID = 4

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='display_type',
            field_id=self.ID,
            base_type=BaseType.ENUM,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )


class ExdDataFieldConfigurationTitleField(Field):
    ID = 5

    def __init__(self, size: int = 0, growable: bool = True):
        super().__init__(
            name='title',
            field_id=self.ID,
            base_type=BaseType.STRING,
            offset=0,
            scale=1,
            size=size,
            growable=growable,
            sub_fields=[
            ]
        )
