(self["webpackJsonp"] = self["webpackJsonp"] || []).push([["zone-detail-dialog"],{

/***/ "./node_modules/@material/mwc-base/base-element.js":
/*!*********************************************************!*\
  !*** ./node_modules/@material/mwc-base/base-element.js ***!
  \*********************************************************/
/*! exports provided: observer, addHasRemoveClass, BaseElement */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "BaseElement", function() { return BaseElement; });
/* harmony import */ var lit_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lit-element */ "./node_modules/lit-element/lit-element.js");
/* harmony import */ var _observer_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./observer.js */ "./node_modules/@material/mwc-base/observer.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "observer", function() { return _observer_js__WEBPACK_IMPORTED_MODULE_1__["observer"]; });

/* harmony import */ var _utils_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./utils.js */ "./node_modules/@material/mwc-base/utils.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "addHasRemoveClass", function() { return _utils_js__WEBPACK_IMPORTED_MODULE_2__["addHasRemoveClass"]; });

/**
@license
Copyright 2018 Google Inc. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/



class BaseElement extends lit_element__WEBPACK_IMPORTED_MODULE_0__["LitElement"] {
  /**
   * Create and attach the MDC Foundation to the instance
   */
  createFoundation() {
    if (this.mdcFoundation !== undefined) {
      this.mdcFoundation.destroy();
    }

    this.mdcFoundation = new this.mdcFoundationClass(this.createAdapter());
    this.mdcFoundation.init();
  }

  firstUpdated() {
    this.createFoundation();
  }

}

/***/ }),

/***/ "./node_modules/@material/mwc-base/form-element.js":
/*!*********************************************************!*\
  !*** ./node_modules/@material/mwc-base/form-element.js ***!
  \*********************************************************/
/*! exports provided: FormElement, observer, addHasRemoveClass, BaseElement */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FormElement", function() { return FormElement; });
/* harmony import */ var _base_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./base-element */ "./node_modules/@material/mwc-base/base-element.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "observer", function() { return _base_element__WEBPACK_IMPORTED_MODULE_0__["observer"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "addHasRemoveClass", function() { return _base_element__WEBPACK_IMPORTED_MODULE_0__["addHasRemoveClass"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "BaseElement", function() { return _base_element__WEBPACK_IMPORTED_MODULE_0__["BaseElement"]; });

/**
@license
Copyright 2018 Google Inc. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/


class FormElement extends _base_element__WEBPACK_IMPORTED_MODULE_0__["BaseElement"] {
  createRenderRoot() {
    return this.attachShadow({
      mode: 'open',
      delegatesFocus: true
    });
  }

  click() {
    if (this.formElement) {
      this.formElement.focus();
      this.formElement.click();
    }
  }

  setAriaLabel(label) {
    if (this.formElement) {
      this.formElement.setAttribute('aria-label', label);
    }
  }

  firstUpdated() {
    super.firstUpdated();
    this.mdcRoot.addEventListener('change', e => {
      this.dispatchEvent(new Event('change', e));
    });
  }

}

/***/ }),

/***/ "./node_modules/@material/mwc-base/observer.js":
/*!*****************************************************!*\
  !*** ./node_modules/@material/mwc-base/observer.js ***!
  \*****************************************************/
/*! exports provided: observer */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "observer", function() { return observer; });
const observer = observer => // eslint-disable-next-line @typescript-eslint/no-explicit-any
(proto, propName) => {
  // if we haven't wrapped `updated` in this class, do so
  if (!proto.constructor._observers) {
    proto.constructor._observers = new Map();
    const userUpdated = proto.updated;

    proto.updated = function (changedProperties) {
      userUpdated.call(this, changedProperties);
      changedProperties.forEach((v, k) => {
        const observer = this.constructor._observers.get(k);

        if (observer !== undefined) {
          observer.call(this, this[k], v);
        }
      });
    }; // clone any existing observers (superclasses)

  } else if (!proto.constructor.hasOwnProperty('_observers')) {
    const observers = proto.constructor._observers;
    proto.constructor._observers = new Map();
    observers.forEach( // eslint-disable-next-line @typescript-eslint/no-explicit-any
    (v, k) => proto.constructor._observers.set(k, v));
  } // set this method


  proto.constructor._observers.set(propName, observer);
};

/***/ }),

/***/ "./node_modules/@material/mwc-base/utils.js":
/*!**************************************************!*\
  !*** ./node_modules/@material/mwc-base/utils.js ***!
  \**************************************************/
/*! exports provided: isNodeElement, findAssignedElement, addHasRemoveClass, supportsPassiveEventListener, deepActiveElementPath, doesElementContainFocus */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isNodeElement", function() { return isNodeElement; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "findAssignedElement", function() { return findAssignedElement; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "addHasRemoveClass", function() { return addHasRemoveClass; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "supportsPassiveEventListener", function() { return supportsPassiveEventListener; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "deepActiveElementPath", function() { return deepActiveElementPath; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "doesElementContainFocus", function() { return doesElementContainFocus; });
/* harmony import */ var _material_dom_ponyfill__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @material/dom/ponyfill */ "./node_modules/@material/dom/ponyfill.js");
/**
@license
Copyright 2018 Google Inc. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

/**
 * Return an element assigned to a given slot that matches the given selector
 */

/**
 * Determines whether a node is an element.
 *
 * @param node Node to check
 */

const isNodeElement = node => {
  return node.nodeType === Node.ELEMENT_NODE;
};
function findAssignedElement(slot, selector) {
  for (const node of slot.assignedNodes({
    flatten: true
  })) {
    if (isNodeElement(node)) {
      const el = node;

      if (Object(_material_dom_ponyfill__WEBPACK_IMPORTED_MODULE_0__["matches"])(el, selector)) {
        return el;
      }
    }
  }

  return null;
}
function addHasRemoveClass(element) {
  return {
    addClass: className => {
      element.classList.add(className);
    },
    removeClass: className => {
      element.classList.remove(className);
    },
    hasClass: className => element.classList.contains(className)
  };
}
let supportsPassive = false;

const fn = () => {};

const optionsBlock = {
  get passive() {
    supportsPassive = true;
    return false;
  }

};
document.addEventListener('x', fn, optionsBlock);
document.removeEventListener('x', fn);
/**
 * Do event listeners suport the `passive` option?
 */

const supportsPassiveEventListener = supportsPassive;
const deepActiveElementPath = (doc = window.document) => {
  let activeElement = doc.activeElement;
  const path = [];

  if (!activeElement) {
    return path;
  }

  while (activeElement) {
    path.push(activeElement);

    if (activeElement.shadowRoot) {
      activeElement = activeElement.shadowRoot.activeElement;
    } else {
      break;
    }
  }

  return path;
};
const doesElementContainFocus = element => {
  const activePath = deepActiveElementPath();

  if (!activePath.length) {
    return false;
  }

  const deepActiveElement = activePath[activePath.length - 1];
  const focusEv = new Event('check-if-focused', {
    bubbles: true,
    composed: true
  });
  let composedPath = [];

  const listener = ev => {
    composedPath = ev.composedPath();
  };

  document.body.addEventListener('check-if-focused', listener);
  deepActiveElement.dispatchEvent(focusEv);
  document.body.removeEventListener('check-if-focused', listener);
  return composedPath.indexOf(element) !== -1;
};

/***/ }),

/***/ "./src/common/location/add_distance_to_coord.ts":
/*!******************************************************!*\
  !*** ./src/common/location/add_distance_to_coord.ts ***!
  \******************************************************/
/*! exports provided: addDistanceToCoord */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "addDistanceToCoord", function() { return addDistanceToCoord; });
const addDistanceToCoord = (location, dx, dy) => {
  const rEarth = 6378000;
  const newLatitude = location[0] + dy / rEarth * (180 / Math.PI);
  const newLongitude = location[1] + dx / rEarth * (180 / Math.PI) / Math.cos(location[0] * Math.PI / 180);
  return [newLatitude, newLongitude];
};

/***/ }),

/***/ "./src/panels/config/zone/dialog-zone-detail.ts":
/*!******************************************************!*\
  !*** ./src/panels/config/zone/dialog-zone-detail.ts ***!
  \******************************************************/
/*! no exports provided */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _material_mwc_button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @material/mwc-button */ "./node_modules/@material/mwc-button/mwc-button.js");
/* harmony import */ var _polymer_paper_input_paper_input__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @polymer/paper-input/paper-input */ "./node_modules/@polymer/paper-input/paper-input.js");
/* harmony import */ var lit_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lit-element */ "./node_modules/lit-element/lit-element.js");
/* harmony import */ var _common_location_add_distance_to_coord__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../common/location/add_distance_to_coord */ "./src/common/location/add_distance_to_coord.ts");
/* harmony import */ var _components_ha_dialog__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../components/ha-dialog */ "./src/components/ha-dialog.ts");
/* harmony import */ var _components_ha_switch__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../components/ha-switch */ "./src/components/ha-switch.ts");
/* harmony import */ var _components_map_ha_location_editor__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../components/map/ha-location-editor */ "./src/components/map/ha-location-editor.ts");
/* harmony import */ var _data_zone__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../data/zone */ "./src/data/zone.ts");
/* harmony import */ var _resources_styles__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../resources/styles */ "./src/resources/styles.ts");
function _decorate(decorators, factory, superClass, mixins) { var api = _getDecoratorsApi(); if (mixins) { for (var i = 0; i < mixins.length; i++) { api = mixins[i](api); } } var r = factory(function initialize(O) { api.initializeInstanceElements(O, decorated.elements); }, superClass); var decorated = api.decorateClass(_coalesceClassElements(r.d.map(_createElementDescriptor)), decorators); api.initializeClassElements(r.F, decorated.elements); return api.runClassFinishers(r.F, decorated.finishers); }

function _getDecoratorsApi() { _getDecoratorsApi = function () { return api; }; var api = { elementsDefinitionOrder: [["method"], ["field"]], initializeInstanceElements: function (O, elements) { ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { if (element.kind === kind && element.placement === "own") { this.defineClassElement(O, element); } }, this); }, this); }, initializeClassElements: function (F, elements) { var proto = F.prototype; ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { var placement = element.placement; if (element.kind === kind && (placement === "static" || placement === "prototype")) { var receiver = placement === "static" ? F : proto; this.defineClassElement(receiver, element); } }, this); }, this); }, defineClassElement: function (receiver, element) { var descriptor = element.descriptor; if (element.kind === "field") { var initializer = element.initializer; descriptor = { enumerable: descriptor.enumerable, writable: descriptor.writable, configurable: descriptor.configurable, value: initializer === void 0 ? void 0 : initializer.call(receiver) }; } Object.defineProperty(receiver, element.key, descriptor); }, decorateClass: function (elements, decorators) { var newElements = []; var finishers = []; var placements = { static: [], prototype: [], own: [] }; elements.forEach(function (element) { this.addElementPlacement(element, placements); }, this); elements.forEach(function (element) { if (!_hasDecorators(element)) return newElements.push(element); var elementFinishersExtras = this.decorateElement(element, placements); newElements.push(elementFinishersExtras.element); newElements.push.apply(newElements, elementFinishersExtras.extras); finishers.push.apply(finishers, elementFinishersExtras.finishers); }, this); if (!decorators) { return { elements: newElements, finishers: finishers }; } var result = this.decorateConstructor(newElements, decorators); finishers.push.apply(finishers, result.finishers); result.finishers = finishers; return result; }, addElementPlacement: function (element, placements, silent) { var keys = placements[element.placement]; if (!silent && keys.indexOf(element.key) !== -1) { throw new TypeError("Duplicated element (" + element.key + ")"); } keys.push(element.key); }, decorateElement: function (element, placements) { var extras = []; var finishers = []; for (var decorators = element.decorators, i = decorators.length - 1; i >= 0; i--) { var keys = placements[element.placement]; keys.splice(keys.indexOf(element.key), 1); var elementObject = this.fromElementDescriptor(element); var elementFinisherExtras = this.toElementFinisherExtras((0, decorators[i])(elementObject) || elementObject); element = elementFinisherExtras.element; this.addElementPlacement(element, placements); if (elementFinisherExtras.finisher) { finishers.push(elementFinisherExtras.finisher); } var newExtras = elementFinisherExtras.extras; if (newExtras) { for (var j = 0; j < newExtras.length; j++) { this.addElementPlacement(newExtras[j], placements); } extras.push.apply(extras, newExtras); } } return { element: element, finishers: finishers, extras: extras }; }, decorateConstructor: function (elements, decorators) { var finishers = []; for (var i = decorators.length - 1; i >= 0; i--) { var obj = this.fromClassDescriptor(elements); var elementsAndFinisher = this.toClassDescriptor((0, decorators[i])(obj) || obj); if (elementsAndFinisher.finisher !== undefined) { finishers.push(elementsAndFinisher.finisher); } if (elementsAndFinisher.elements !== undefined) { elements = elementsAndFinisher.elements; for (var j = 0; j < elements.length - 1; j++) { for (var k = j + 1; k < elements.length; k++) { if (elements[j].key === elements[k].key && elements[j].placement === elements[k].placement) { throw new TypeError("Duplicated element (" + elements[j].key + ")"); } } } } } return { elements: elements, finishers: finishers }; }, fromElementDescriptor: function (element) { var obj = { kind: element.kind, key: element.key, placement: element.placement, descriptor: element.descriptor }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); if (element.kind === "field") obj.initializer = element.initializer; return obj; }, toElementDescriptors: function (elementObjects) { if (elementObjects === undefined) return; return _toArray(elementObjects).map(function (elementObject) { var element = this.toElementDescriptor(elementObject); this.disallowProperty(elementObject, "finisher", "An element descriptor"); this.disallowProperty(elementObject, "extras", "An element descriptor"); return element; }, this); }, toElementDescriptor: function (elementObject) { var kind = String(elementObject.kind); if (kind !== "method" && kind !== "field") { throw new TypeError('An element descriptor\'s .kind property must be either "method" or' + ' "field", but a decorator created an element descriptor with' + ' .kind "' + kind + '"'); } var key = _toPropertyKey(elementObject.key); var placement = String(elementObject.placement); if (placement !== "static" && placement !== "prototype" && placement !== "own") { throw new TypeError('An element descriptor\'s .placement property must be one of "static",' + ' "prototype" or "own", but a decorator created an element descriptor' + ' with .placement "' + placement + '"'); } var descriptor = elementObject.descriptor; this.disallowProperty(elementObject, "elements", "An element descriptor"); var element = { kind: kind, key: key, placement: placement, descriptor: Object.assign({}, descriptor) }; if (kind !== "field") { this.disallowProperty(elementObject, "initializer", "A method descriptor"); } else { this.disallowProperty(descriptor, "get", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "set", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "value", "The property descriptor of a field descriptor"); element.initializer = elementObject.initializer; } return element; }, toElementFinisherExtras: function (elementObject) { var element = this.toElementDescriptor(elementObject); var finisher = _optionalCallableProperty(elementObject, "finisher"); var extras = this.toElementDescriptors(elementObject.extras); return { element: element, finisher: finisher, extras: extras }; }, fromClassDescriptor: function (elements) { var obj = { kind: "class", elements: elements.map(this.fromElementDescriptor, this) }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); return obj; }, toClassDescriptor: function (obj) { var kind = String(obj.kind); if (kind !== "class") { throw new TypeError('A class descriptor\'s .kind property must be "class", but a decorator' + ' created a class descriptor with .kind "' + kind + '"'); } this.disallowProperty(obj, "key", "A class descriptor"); this.disallowProperty(obj, "placement", "A class descriptor"); this.disallowProperty(obj, "descriptor", "A class descriptor"); this.disallowProperty(obj, "initializer", "A class descriptor"); this.disallowProperty(obj, "extras", "A class descriptor"); var finisher = _optionalCallableProperty(obj, "finisher"); var elements = this.toElementDescriptors(obj.elements); return { elements: elements, finisher: finisher }; }, runClassFinishers: function (constructor, finishers) { for (var i = 0; i < finishers.length; i++) { var newConstructor = (0, finishers[i])(constructor); if (newConstructor !== undefined) { if (typeof newConstructor !== "function") { throw new TypeError("Finishers must return a constructor."); } constructor = newConstructor; } } return constructor; }, disallowProperty: function (obj, name, objectType) { if (obj[name] !== undefined) { throw new TypeError(objectType + " can't have a ." + name + " property."); } } }; return api; }

function _createElementDescriptor(def) { var key = _toPropertyKey(def.key); var descriptor; if (def.kind === "method") { descriptor = { value: def.value, writable: true, configurable: true, enumerable: false }; } else if (def.kind === "get") { descriptor = { get: def.value, configurable: true, enumerable: false }; } else if (def.kind === "set") { descriptor = { set: def.value, configurable: true, enumerable: false }; } else if (def.kind === "field") { descriptor = { configurable: true, writable: true, enumerable: true }; } var element = { kind: def.kind === "field" ? "field" : "method", key: key, placement: def.static ? "static" : def.kind === "field" ? "own" : "prototype", descriptor: descriptor }; if (def.decorators) element.decorators = def.decorators; if (def.kind === "field") element.initializer = def.value; return element; }

function _coalesceGetterSetter(element, other) { if (element.descriptor.get !== undefined) { other.descriptor.get = element.descriptor.get; } else { other.descriptor.set = element.descriptor.set; } }

function _coalesceClassElements(elements) { var newElements = []; var isSameElement = function (other) { return other.kind === "method" && other.key === element.key && other.placement === element.placement; }; for (var i = 0; i < elements.length; i++) { var element = elements[i]; var other; if (element.kind === "method" && (other = newElements.find(isSameElement))) { if (_isDataDescriptor(element.descriptor) || _isDataDescriptor(other.descriptor)) { if (_hasDecorators(element) || _hasDecorators(other)) { throw new ReferenceError("Duplicated methods (" + element.key + ") can't be decorated."); } other.descriptor = element.descriptor; } else { if (_hasDecorators(element)) { if (_hasDecorators(other)) { throw new ReferenceError("Decorators can't be placed on different accessors with for " + "the same property (" + element.key + ")."); } other.decorators = element.decorators; } _coalesceGetterSetter(element, other); } } else { newElements.push(element); } } return newElements; }

function _hasDecorators(element) { return element.decorators && element.decorators.length; }

function _isDataDescriptor(desc) { return desc !== undefined && !(desc.value === undefined && desc.writable === undefined); }

function _optionalCallableProperty(obj, name) { var value = obj[name]; if (value !== undefined && typeof value !== "function") { throw new TypeError("Expected '" + name + "' to be a function"); } return value; }

function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }

function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }

function _toArray(arr) { return _arrayWithHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(n); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }











let DialogZoneDetail = _decorate(null, function (_initialize, _LitElement) {
  class DialogZoneDetail extends _LitElement {
    constructor(...args) {
      super(...args);

      _initialize(this);
    }

  }

  return {
    F: DialogZoneDetail,
    d: [{
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_2__["property"])()],
      key: "hass",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_2__["property"])()],
      key: "_name",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_2__["property"])()],
      key: "_icon",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_2__["property"])()],
      key: "_latitude",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_2__["property"])()],
      key: "_longitude",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_2__["property"])()],
      key: "_passive",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_2__["property"])()],
      key: "_radius",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_2__["property"])()],
      key: "_error",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_2__["property"])()],
      key: "_params",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_2__["property"])()],
      key: "_submitting",

      value() {
        return false;
      }

    }, {
      kind: "method",
      key: "showDialog",
      value: async function showDialog(params) {
        this._params = params;
        this._error = undefined;

        if (this._params.entry) {
          this._name = this._params.entry.name || "";
          this._icon = this._params.entry.icon || "";
          this._latitude = this._params.entry.latitude || this.hass.config.latitude;
          this._longitude = this._params.entry.longitude || this.hass.config.longitude;
          this._passive = this._params.entry.passive || false;
          this._radius = this._params.entry.radius || 100;
        } else {
          const initConfig = Object(_data_zone__WEBPACK_IMPORTED_MODULE_7__["getZoneEditorInitData"])();
          let movedHomeLocation;

          if (!(initConfig === null || initConfig === void 0 ? void 0 : initConfig.latitude) || !(initConfig === null || initConfig === void 0 ? void 0 : initConfig.longitude)) {
            movedHomeLocation = Object(_common_location_add_distance_to_coord__WEBPACK_IMPORTED_MODULE_3__["addDistanceToCoord"])([this.hass.config.latitude, this.hass.config.longitude], Math.random() * 500 * (Math.random() < 0.5 ? -1 : 1), Math.random() * 500 * (Math.random() < 0.5 ? -1 : 1));
          }

          this._latitude = (initConfig === null || initConfig === void 0 ? void 0 : initConfig.latitude) || movedHomeLocation[0];
          this._longitude = (initConfig === null || initConfig === void 0 ? void 0 : initConfig.longitude) || movedHomeLocation[1];
          this._name = (initConfig === null || initConfig === void 0 ? void 0 : initConfig.name) || "";
          this._icon = (initConfig === null || initConfig === void 0 ? void 0 : initConfig.icon) || "mdi:map-marker";
          this._passive = false;
          this._radius = 100;
        }

        await this.updateComplete;
      }
    }, {
      kind: "method",
      key: "render",
      value: function render() {
        if (!this._params) {
          return lit_element__WEBPACK_IMPORTED_MODULE_2__["html"]``;
        }

        const nameValid = this._name.trim() === "";
        const iconValid = !this._icon.trim().includes(":");
        const latValid = String(this._latitude) === "";
        const lngValid = String(this._longitude) === "";
        const radiusValid = String(this._radius) === "";
        const valid = !nameValid && !iconValid && !latValid && !lngValid && !radiusValid;
        return lit_element__WEBPACK_IMPORTED_MODULE_2__["html"]`
      <ha-dialog
        open
        @closing="${this._close}"
        scrimClickAction=""
        escapeKeyAction=""
        .heading=${Object(_components_ha_dialog__WEBPACK_IMPORTED_MODULE_4__["createCloseHeading"])(this.hass, this._params.entry ? this._params.entry.name : this.hass.localize("ui.panel.config.zone.detail.new_zone"))}
      >
        <div>
          ${this._error ? lit_element__WEBPACK_IMPORTED_MODULE_2__["html"]` <div class="error">${this._error}</div> ` : ""}
          <div class="form">
            <paper-input
              dialogInitialFocus
              .value=${this._name}
              .configValue=${"name"}
              @value-changed=${this._valueChanged}
              .label="${this.hass.localize("ui.panel.config.zone.detail.name")}"
              .errorMessage="${this.hass.localize("ui.panel.config.zone.detail.required_error_msg")}"
              required
              auto-validate
            ></paper-input>
            <paper-input
              .value=${this._icon}
              .configValue=${"icon"}
              @value-changed=${this._valueChanged}
              .label="${this.hass.localize("ui.panel.config.zone.detail.icon")}"
              .errorMessage="${this.hass.localize("ui.panel.config.zone.detail.icon_error_msg")}"
              .invalid=${iconValid}
            ></paper-input>
            <ha-location-editor
              class="flex"
              .location=${this._locationValue}
              .radius=${this._radius}
              .radiusColor=${this._passive ? _data_zone__WEBPACK_IMPORTED_MODULE_7__["passiveRadiusColor"] : _data_zone__WEBPACK_IMPORTED_MODULE_7__["defaultRadiusColor"]}
              .icon=${this._icon}
              @change=${this._locationChanged}
            ></ha-location-editor>
            <div class="location">
              <paper-input
                .value=${this._latitude}
                .configValue=${"latitude"}
                @value-changed=${this._valueChanged}
                .label="${this.hass.localize("ui.panel.config.zone.detail.latitude")}"
                .errorMessage="${this.hass.localize("ui.panel.config.zone.detail.required_error_msg")}"
                .invalid=${latValid}
              ></paper-input>
              <paper-input
                .value=${this._longitude}
                .configValue=${"longitude"}
                @value-changed=${this._valueChanged}
                .label="${this.hass.localize("ui.panel.config.zone.detail.longitude")}"
                .errorMessage="${this.hass.localize("ui.panel.config.zone.detail.required_error_msg")}"
                .invalid=${lngValid}
              ></paper-input>
            </div>
            <paper-input
              .value=${this._radius}
              .configValue=${"radius"}
              @value-changed=${this._valueChanged}
              .label="${this.hass.localize("ui.panel.config.zone.detail.radius")}"
              .errorMessage="${this.hass.localize("ui.panel.config.zone.detail.required_error_msg")}"
              .invalid=${radiusValid}
            ></paper-input>
            <p>
              ${this.hass.localize("ui.panel.config.zone.detail.passive_note")}
            </p>
            <ha-switch .checked=${this._passive} @change=${this._passiveChanged}
              >${this.hass.localize("ui.panel.config.zone.detail.passive")}</ha-switch
            >
          </div>
        </div>
        ${this._params.entry ? lit_element__WEBPACK_IMPORTED_MODULE_2__["html"]`
              <mwc-button
                slot="secondaryAction"
                class="warning"
                @click="${this._deleteEntry}"
                .disabled=${this._submitting}
              >
                ${this.hass.localize("ui.panel.config.zone.detail.delete")}
              </mwc-button>
            ` : lit_element__WEBPACK_IMPORTED_MODULE_2__["html"]``}
        <mwc-button
          slot="primaryAction"
          @click="${this._updateEntry}"
          .disabled=${!valid || this._submitting}
        >
          ${this._params.entry ? this.hass.localize("ui.panel.config.zone.detail.update") : this.hass.localize("ui.panel.config.zone.detail.create")}
        </mwc-button>
      </ha-dialog>
    `;
      }
    }, {
      kind: "get",
      key: "_locationValue",
      value: function _locationValue() {
        return [Number(this._latitude), Number(this._longitude)];
      }
    }, {
      kind: "method",
      key: "_locationChanged",
      value: function _locationChanged(ev) {
        [this._latitude, this._longitude] = ev.currentTarget.location;
        this._radius = ev.currentTarget.radius;
      }
    }, {
      kind: "method",
      key: "_passiveChanged",
      value: function _passiveChanged(ev) {
        this._passive = ev.target.checked;
      }
    }, {
      kind: "method",
      key: "_valueChanged",
      value: function _valueChanged(ev) {
        const configValue = ev.target.configValue;
        this._error = undefined;
        this[`_${configValue}`] = ev.detail.value;
      }
    }, {
      kind: "method",
      key: "_updateEntry",
      value: async function _updateEntry() {
        this._submitting = true;

        try {
          const values = {
            name: this._name.trim(),
            icon: this._icon.trim(),
            latitude: this._latitude,
            longitude: this._longitude,
            passive: this._passive,
            radius: this._radius
          };

          if (this._params.entry) {
            await this._params.updateEntry(values);
          } else {
            await this._params.createEntry(values);
          }

          this._params = undefined;
        } catch (err) {
          this._error = err ? err.message : "Unknown error";
        } finally {
          this._submitting = false;
        }
      }
    }, {
      kind: "method",
      key: "_deleteEntry",
      value: async function _deleteEntry() {
        this._submitting = true;

        try {
          if (await this._params.removeEntry()) {
            this._params = undefined;
          }
        } finally {
          this._submitting = false;
        }
      }
    }, {
      kind: "method",
      key: "_close",
      value: function _close() {
        this._params = undefined;
      }
    }, {
      kind: "get",
      static: true,
      key: "styles",
      value: function styles() {
        return [_resources_styles__WEBPACK_IMPORTED_MODULE_8__["haStyleDialog"], lit_element__WEBPACK_IMPORTED_MODULE_2__["css"]`
        .location {
          display: flex;
        }
        .location > * {
          flex-grow: 1;
          min-width: 0;
        }
        .location > *:first-child {
          margin-right: 4px;
        }
        .location > *:last-child {
          margin-left: 4px;
        }
        ha-location-editor {
          margin-top: 16px;
        }
        ha-user-picker {
          margin-top: 16px;
        }
        a {
          color: var(--primary-color);
        }
      `];
      }
    }]
  };
}, lit_element__WEBPACK_IMPORTED_MODULE_2__["LitElement"]);

customElements.define("dialog-zone-detail", DialogZoneDetail);

/***/ })

}]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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