(self["webpackJsonp"] = self["webpackJsonp"] || []).push([["vendors~load_chart"],{

/***/ "./node_modules/chart.js/dist/Chart.js":
/*!*********************************************!*\
  !*** ./node_modules/chart.js/dist/Chart.js ***!
  \*********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

/*!
 * Chart.js v2.8.0
 * https://www.chartjs.org
 * (c) 2019 Chart.js Contributors
 * Released under the MIT License
 */
(function (global, factory) {
   true ? module.exports = factory(function () {
    try {
      return __webpack_require__(/*! moment */ "./node_modules/moment/moment.js");
    } catch (e) {}
  }()) : undefined;
})(this, function (moment) {
  'use strict';

  moment = moment && moment.hasOwnProperty('default') ? moment['default'] : moment;
  /* MIT license */

  var conversions = {
    rgb2hsl: rgb2hsl,
    rgb2hsv: rgb2hsv,
    rgb2hwb: rgb2hwb,
    rgb2cmyk: rgb2cmyk,
    rgb2keyword: rgb2keyword,
    rgb2xyz: rgb2xyz,
    rgb2lab: rgb2lab,
    rgb2lch: rgb2lch,
    hsl2rgb: hsl2rgb,
    hsl2hsv: hsl2hsv,
    hsl2hwb: hsl2hwb,
    hsl2cmyk: hsl2cmyk,
    hsl2keyword: hsl2keyword,
    hsv2rgb: hsv2rgb,
    hsv2hsl: hsv2hsl,
    hsv2hwb: hsv2hwb,
    hsv2cmyk: hsv2cmyk,
    hsv2keyword: hsv2keyword,
    hwb2rgb: hwb2rgb,
    hwb2hsl: hwb2hsl,
    hwb2hsv: hwb2hsv,
    hwb2cmyk: hwb2cmyk,
    hwb2keyword: hwb2keyword,
    cmyk2rgb: cmyk2rgb,
    cmyk2hsl: cmyk2hsl,
    cmyk2hsv: cmyk2hsv,
    cmyk2hwb: cmyk2hwb,
    cmyk2keyword: cmyk2keyword,
    keyword2rgb: keyword2rgb,
    keyword2hsl: keyword2hsl,
    keyword2hsv: keyword2hsv,
    keyword2hwb: keyword2hwb,
    keyword2cmyk: keyword2cmyk,
    keyword2lab: keyword2lab,
    keyword2xyz: keyword2xyz,
    xyz2rgb: xyz2rgb,
    xyz2lab: xyz2lab,
    xyz2lch: xyz2lch,
    lab2xyz: lab2xyz,
    lab2rgb: lab2rgb,
    lab2lch: lab2lch,
    lch2lab: lch2lab,
    lch2xyz: lch2xyz,
    lch2rgb: lch2rgb
  };

  function rgb2hsl(rgb) {
    var r = rgb[0] / 255,
        g = rgb[1] / 255,
        b = rgb[2] / 255,
        min = Math.min(r, g, b),
        max = Math.max(r, g, b),
        delta = max - min,
        h,
        s,
        l;
    if (max == min) h = 0;else if (r == max) h = (g - b) / delta;else if (g == max) h = 2 + (b - r) / delta;else if (b == max) h = 4 + (r - g) / delta;
    h = Math.min(h * 60, 360);
    if (h < 0) h += 360;
    l = (min + max) / 2;
    if (max == min) s = 0;else if (l <= 0.5) s = delta / (max + min);else s = delta / (2 - max - min);
    return [h, s * 100, l * 100];
  }

  function rgb2hsv(rgb) {
    var r = rgb[0],
        g = rgb[1],
        b = rgb[2],
        min = Math.min(r, g, b),
        max = Math.max(r, g, b),
        delta = max - min,
        h,
        s,
        v;
    if (max == 0) s = 0;else s = delta / max * 1000 / 10;
    if (max == min) h = 0;else if (r == max) h = (g - b) / delta;else if (g == max) h = 2 + (b - r) / delta;else if (b == max) h = 4 + (r - g) / delta;
    h = Math.min(h * 60, 360);
    if (h < 0) h += 360;
    v = max / 255 * 1000 / 10;
    return [h, s, v];
  }

  function rgb2hwb(rgb) {
    var r = rgb[0],
        g = rgb[1],
        b = rgb[2],
        h = rgb2hsl(rgb)[0],
        w = 1 / 255 * Math.min(r, Math.min(g, b)),
        b = 1 - 1 / 255 * Math.max(r, Math.max(g, b));
    return [h, w * 100, b * 100];
  }

  function rgb2cmyk(rgb) {
    var r = rgb[0] / 255,
        g = rgb[1] / 255,
        b = rgb[2] / 255,
        c,
        m,
        y,
        k;
    k = Math.min(1 - r, 1 - g, 1 - b);
    c = (1 - r - k) / (1 - k) || 0;
    m = (1 - g - k) / (1 - k) || 0;
    y = (1 - b - k) / (1 - k) || 0;
    return [c * 100, m * 100, y * 100, k * 100];
  }

  function rgb2keyword(rgb) {
    return reverseKeywords[JSON.stringify(rgb)];
  }

  function rgb2xyz(rgb) {
    var r = rgb[0] / 255,
        g = rgb[1] / 255,
        b = rgb[2] / 255; // assume sRGB

    r = r > 0.04045 ? Math.pow((r + 0.055) / 1.055, 2.4) : r / 12.92;
    g = g > 0.04045 ? Math.pow((g + 0.055) / 1.055, 2.4) : g / 12.92;
    b = b > 0.04045 ? Math.pow((b + 0.055) / 1.055, 2.4) : b / 12.92;
    var x = r * 0.4124 + g * 0.3576 + b * 0.1805;
    var y = r * 0.2126 + g * 0.7152 + b * 0.0722;
    var z = r * 0.0193 + g * 0.1192 + b * 0.9505;
    return [x * 100, y * 100, z * 100];
  }

  function rgb2lab(rgb) {
    var xyz = rgb2xyz(rgb),
        x = xyz[0],
        y = xyz[1],
        z = xyz[2],
        l,
        a,
        b;
    x /= 95.047;
    y /= 100;
    z /= 108.883;
    x = x > 0.008856 ? Math.pow(x, 1 / 3) : 7.787 * x + 16 / 116;
    y = y > 0.008856 ? Math.pow(y, 1 / 3) : 7.787 * y + 16 / 116;
    z = z > 0.008856 ? Math.pow(z, 1 / 3) : 7.787 * z + 16 / 116;
    l = 116 * y - 16;
    a = 500 * (x - y);
    b = 200 * (y - z);
    return [l, a, b];
  }

  function rgb2lch(args) {
    return lab2lch(rgb2lab(args));
  }

  function hsl2rgb(hsl) {
    var h = hsl[0] / 360,
        s = hsl[1] / 100,
        l = hsl[2] / 100,
        t1,
        t2,
        t3,
        rgb,
        val;

    if (s == 0) {
      val = l * 255;
      return [val, val, val];
    }

    if (l < 0.5) t2 = l * (1 + s);else t2 = l + s - l * s;
    t1 = 2 * l - t2;
    rgb = [0, 0, 0];

    for (var i = 0; i < 3; i++) {
      t3 = h + 1 / 3 * -(i - 1);
      t3 < 0 && t3++;
      t3 > 1 && t3--;
      if (6 * t3 < 1) val = t1 + (t2 - t1) * 6 * t3;else if (2 * t3 < 1) val = t2;else if (3 * t3 < 2) val = t1 + (t2 - t1) * (2 / 3 - t3) * 6;else val = t1;
      rgb[i] = val * 255;
    }

    return rgb;
  }

  function hsl2hsv(hsl) {
    var h = hsl[0],
        s = hsl[1] / 100,
        l = hsl[2] / 100,
        sv,
        v;

    if (l === 0) {
      // no need to do calc on black
      // also avoids divide by 0 error
      return [0, 0, 0];
    }

    l *= 2;
    s *= l <= 1 ? l : 2 - l;
    v = (l + s) / 2;
    sv = 2 * s / (l + s);
    return [h, sv * 100, v * 100];
  }

  function hsl2hwb(args) {
    return rgb2hwb(hsl2rgb(args));
  }

  function hsl2cmyk(args) {
    return rgb2cmyk(hsl2rgb(args));
  }

  function hsl2keyword(args) {
    return rgb2keyword(hsl2rgb(args));
  }

  function hsv2rgb(hsv) {
    var h = hsv[0] / 60,
        s = hsv[1] / 100,
        v = hsv[2] / 100,
        hi = Math.floor(h) % 6;
    var f = h - Math.floor(h),
        p = 255 * v * (1 - s),
        q = 255 * v * (1 - s * f),
        t = 255 * v * (1 - s * (1 - f)),
        v = 255 * v;

    switch (hi) {
      case 0:
        return [v, t, p];

      case 1:
        return [q, v, p];

      case 2:
        return [p, v, t];

      case 3:
        return [p, q, v];

      case 4:
        return [t, p, v];

      case 5:
        return [v, p, q];
    }
  }

  function hsv2hsl(hsv) {
    var h = hsv[0],
        s = hsv[1] / 100,
        v = hsv[2] / 100,
        sl,
        l;
    l = (2 - s) * v;
    sl = s * v;
    sl /= l <= 1 ? l : 2 - l;
    sl = sl || 0;
    l /= 2;
    return [h, sl * 100, l * 100];
  }

  function hsv2hwb(args) {
    return rgb2hwb(hsv2rgb(args));
  }

  function hsv2cmyk(args) {
    return rgb2cmyk(hsv2rgb(args));
  }

  function hsv2keyword(args) {
    return rgb2keyword(hsv2rgb(args));
  } // http://dev.w3.org/csswg/css-color/#hwb-to-rgb


  function hwb2rgb(hwb) {
    var h = hwb[0] / 360,
        wh = hwb[1] / 100,
        bl = hwb[2] / 100,
        ratio = wh + bl,
        i,
        v,
        f,
        n; // wh + bl cant be > 1

    if (ratio > 1) {
      wh /= ratio;
      bl /= ratio;
    }

    i = Math.floor(6 * h);
    v = 1 - bl;
    f = 6 * h - i;

    if ((i & 0x01) != 0) {
      f = 1 - f;
    }

    n = wh + f * (v - wh); // linear interpolation

    switch (i) {
      default:
      case 6:
      case 0:
        r = v;
        g = n;
        b = wh;
        break;

      case 1:
        r = n;
        g = v;
        b = wh;
        break;

      case 2:
        r = wh;
        g = v;
        b = n;
        break;

      case 3:
        r = wh;
        g = n;
        b = v;
        break;

      case 4:
        r = n;
        g = wh;
        b = v;
        break;

      case 5:
        r = v;
        g = wh;
        b = n;
        break;
    }

    return [r * 255, g * 255, b * 255];
  }

  function hwb2hsl(args) {
    return rgb2hsl(hwb2rgb(args));
  }

  function hwb2hsv(args) {
    return rgb2hsv(hwb2rgb(args));
  }

  function hwb2cmyk(args) {
    return rgb2cmyk(hwb2rgb(args));
  }

  function hwb2keyword(args) {
    return rgb2keyword(hwb2rgb(args));
  }

  function cmyk2rgb(cmyk) {
    var c = cmyk[0] / 100,
        m = cmyk[1] / 100,
        y = cmyk[2] / 100,
        k = cmyk[3] / 100,
        r,
        g,
        b;
    r = 1 - Math.min(1, c * (1 - k) + k);
    g = 1 - Math.min(1, m * (1 - k) + k);
    b = 1 - Math.min(1, y * (1 - k) + k);
    return [r * 255, g * 255, b * 255];
  }

  function cmyk2hsl(args) {
    return rgb2hsl(cmyk2rgb(args));
  }

  function cmyk2hsv(args) {
    return rgb2hsv(cmyk2rgb(args));
  }

  function cmyk2hwb(args) {
    return rgb2hwb(cmyk2rgb(args));
  }

  function cmyk2keyword(args) {
    return rgb2keyword(cmyk2rgb(args));
  }

  function xyz2rgb(xyz) {
    var x = xyz[0] / 100,
        y = xyz[1] / 100,
        z = xyz[2] / 100,
        r,
        g,
        b;
    r = x * 3.2406 + y * -1.5372 + z * -0.4986;
    g = x * -0.9689 + y * 1.8758 + z * 0.0415;
    b = x * 0.0557 + y * -0.2040 + z * 1.0570; // assume sRGB

    r = r > 0.0031308 ? 1.055 * Math.pow(r, 1.0 / 2.4) - 0.055 : r = r * 12.92;
    g = g > 0.0031308 ? 1.055 * Math.pow(g, 1.0 / 2.4) - 0.055 : g = g * 12.92;
    b = b > 0.0031308 ? 1.055 * Math.pow(b, 1.0 / 2.4) - 0.055 : b = b * 12.92;
    r = Math.min(Math.max(0, r), 1);
    g = Math.min(Math.max(0, g), 1);
    b = Math.min(Math.max(0, b), 1);
    return [r * 255, g * 255, b * 255];
  }

  function xyz2lab(xyz) {
    var x = xyz[0],
        y = xyz[1],
        z = xyz[2],
        l,
        a,
        b;
    x /= 95.047;
    y /= 100;
    z /= 108.883;
    x = x > 0.008856 ? Math.pow(x, 1 / 3) : 7.787 * x + 16 / 116;
    y = y > 0.008856 ? Math.pow(y, 1 / 3) : 7.787 * y + 16 / 116;
    z = z > 0.008856 ? Math.pow(z, 1 / 3) : 7.787 * z + 16 / 116;
    l = 116 * y - 16;
    a = 500 * (x - y);
    b = 200 * (y - z);
    return [l, a, b];
  }

  function xyz2lch(args) {
    return lab2lch(xyz2lab(args));
  }

  function lab2xyz(lab) {
    var l = lab[0],
        a = lab[1],
        b = lab[2],
        x,
        y,
        z,
        y2;

    if (l <= 8) {
      y = l * 100 / 903.3;
      y2 = 7.787 * (y / 100) + 16 / 116;
    } else {
      y = 100 * Math.pow((l + 16) / 116, 3);
      y2 = Math.pow(y / 100, 1 / 3);
    }

    x = x / 95.047 <= 0.008856 ? x = 95.047 * (a / 500 + y2 - 16 / 116) / 7.787 : 95.047 * Math.pow(a / 500 + y2, 3);
    z = z / 108.883 <= 0.008859 ? z = 108.883 * (y2 - b / 200 - 16 / 116) / 7.787 : 108.883 * Math.pow(y2 - b / 200, 3);
    return [x, y, z];
  }

  function lab2lch(lab) {
    var l = lab[0],
        a = lab[1],
        b = lab[2],
        hr,
        h,
        c;
    hr = Math.atan2(b, a);
    h = hr * 360 / 2 / Math.PI;

    if (h < 0) {
      h += 360;
    }

    c = Math.sqrt(a * a + b * b);
    return [l, c, h];
  }

  function lab2rgb(args) {
    return xyz2rgb(lab2xyz(args));
  }

  function lch2lab(lch) {
    var l = lch[0],
        c = lch[1],
        h = lch[2],
        a,
        b,
        hr;
    hr = h / 360 * 2 * Math.PI;
    a = c * Math.cos(hr);
    b = c * Math.sin(hr);
    return [l, a, b];
  }

  function lch2xyz(args) {
    return lab2xyz(lch2lab(args));
  }

  function lch2rgb(args) {
    return lab2rgb(lch2lab(args));
  }

  function keyword2rgb(keyword) {
    return cssKeywords[keyword];
  }

  function keyword2hsl(args) {
    return rgb2hsl(keyword2rgb(args));
  }

  function keyword2hsv(args) {
    return rgb2hsv(keyword2rgb(args));
  }

  function keyword2hwb(args) {
    return rgb2hwb(keyword2rgb(args));
  }

  function keyword2cmyk(args) {
    return rgb2cmyk(keyword2rgb(args));
  }

  function keyword2lab(args) {
    return rgb2lab(keyword2rgb(args));
  }

  function keyword2xyz(args) {
    return rgb2xyz(keyword2rgb(args));
  }

  var cssKeywords = {
    aliceblue: [240, 248, 255],
    antiquewhite: [250, 235, 215],
    aqua: [0, 255, 255],
    aquamarine: [127, 255, 212],
    azure: [240, 255, 255],
    beige: [245, 245, 220],
    bisque: [255, 228, 196],
    black: [0, 0, 0],
    blanchedalmond: [255, 235, 205],
    blue: [0, 0, 255],
    blueviolet: [138, 43, 226],
    brown: [165, 42, 42],
    burlywood: [222, 184, 135],
    cadetblue: [95, 158, 160],
    chartreuse: [127, 255, 0],
    chocolate: [210, 105, 30],
    coral: [255, 127, 80],
    cornflowerblue: [100, 149, 237],
    cornsilk: [255, 248, 220],
    crimson: [220, 20, 60],
    cyan: [0, 255, 255],
    darkblue: [0, 0, 139],
    darkcyan: [0, 139, 139],
    darkgoldenrod: [184, 134, 11],
    darkgray: [169, 169, 169],
    darkgreen: [0, 100, 0],
    darkgrey: [169, 169, 169],
    darkkhaki: [189, 183, 107],
    darkmagenta: [139, 0, 139],
    darkolivegreen: [85, 107, 47],
    darkorange: [255, 140, 0],
    darkorchid: [153, 50, 204],
    darkred: [139, 0, 0],
    darksalmon: [233, 150, 122],
    darkseagreen: [143, 188, 143],
    darkslateblue: [72, 61, 139],
    darkslategray: [47, 79, 79],
    darkslategrey: [47, 79, 79],
    darkturquoise: [0, 206, 209],
    darkviolet: [148, 0, 211],
    deeppink: [255, 20, 147],
    deepskyblue: [0, 191, 255],
    dimgray: [105, 105, 105],
    dimgrey: [105, 105, 105],
    dodgerblue: [30, 144, 255],
    firebrick: [178, 34, 34],
    floralwhite: [255, 250, 240],
    forestgreen: [34, 139, 34],
    fuchsia: [255, 0, 255],
    gainsboro: [220, 220, 220],
    ghostwhite: [248, 248, 255],
    gold: [255, 215, 0],
    goldenrod: [218, 165, 32],
    gray: [128, 128, 128],
    green: [0, 128, 0],
    greenyellow: [173, 255, 47],
    grey: [128, 128, 128],
    honeydew: [240, 255, 240],
    hotpink: [255, 105, 180],
    indianred: [205, 92, 92],
    indigo: [75, 0, 130],
    ivory: [255, 255, 240],
    khaki: [240, 230, 140],
    lavender: [230, 230, 250],
    lavenderblush: [255, 240, 245],
    lawngreen: [124, 252, 0],
    lemonchiffon: [255, 250, 205],
    lightblue: [173, 216, 230],
    lightcoral: [240, 128, 128],
    lightcyan: [224, 255, 255],
    lightgoldenrodyellow: [250, 250, 210],
    lightgray: [211, 211, 211],
    lightgreen: [144, 238, 144],
    lightgrey: [211, 211, 211],
    lightpink: [255, 182, 193],
    lightsalmon: [255, 160, 122],
    lightseagreen: [32, 178, 170],
    lightskyblue: [135, 206, 250],
    lightslategray: [119, 136, 153],
    lightslategrey: [119, 136, 153],
    lightsteelblue: [176, 196, 222],
    lightyellow: [255, 255, 224],
    lime: [0, 255, 0],
    limegreen: [50, 205, 50],
    linen: [250, 240, 230],
    magenta: [255, 0, 255],
    maroon: [128, 0, 0],
    mediumaquamarine: [102, 205, 170],
    mediumblue: [0, 0, 205],
    mediumorchid: [186, 85, 211],
    mediumpurple: [147, 112, 219],
    mediumseagreen: [60, 179, 113],
    mediumslateblue: [123, 104, 238],
    mediumspringgreen: [0, 250, 154],
    mediumturquoise: [72, 209, 204],
    mediumvioletred: [199, 21, 133],
    midnightblue: [25, 25, 112],
    mintcream: [245, 255, 250],
    mistyrose: [255, 228, 225],
    moccasin: [255, 228, 181],
    navajowhite: [255, 222, 173],
    navy: [0, 0, 128],
    oldlace: [253, 245, 230],
    olive: [128, 128, 0],
    olivedrab: [107, 142, 35],
    orange: [255, 165, 0],
    orangered: [255, 69, 0],
    orchid: [218, 112, 214],
    palegoldenrod: [238, 232, 170],
    palegreen: [152, 251, 152],
    paleturquoise: [175, 238, 238],
    palevioletred: [219, 112, 147],
    papayawhip: [255, 239, 213],
    peachpuff: [255, 218, 185],
    peru: [205, 133, 63],
    pink: [255, 192, 203],
    plum: [221, 160, 221],
    powderblue: [176, 224, 230],
    purple: [128, 0, 128],
    rebeccapurple: [102, 51, 153],
    red: [255, 0, 0],
    rosybrown: [188, 143, 143],
    royalblue: [65, 105, 225],
    saddlebrown: [139, 69, 19],
    salmon: [250, 128, 114],
    sandybrown: [244, 164, 96],
    seagreen: [46, 139, 87],
    seashell: [255, 245, 238],
    sienna: [160, 82, 45],
    silver: [192, 192, 192],
    skyblue: [135, 206, 235],
    slateblue: [106, 90, 205],
    slategray: [112, 128, 144],
    slategrey: [112, 128, 144],
    snow: [255, 250, 250],
    springgreen: [0, 255, 127],
    steelblue: [70, 130, 180],
    tan: [210, 180, 140],
    teal: [0, 128, 128],
    thistle: [216, 191, 216],
    tomato: [255, 99, 71],
    turquoise: [64, 224, 208],
    violet: [238, 130, 238],
    wheat: [245, 222, 179],
    white: [255, 255, 255],
    whitesmoke: [245, 245, 245],
    yellow: [255, 255, 0],
    yellowgreen: [154, 205, 50]
  };
  var reverseKeywords = {};

  for (var key in cssKeywords) {
    reverseKeywords[JSON.stringify(cssKeywords[key])] = key;
  }

  var convert = function () {
    return new Converter();
  };

  for (var func in conversions) {
    // export Raw versions
    convert[func + "Raw"] = function (func) {
      // accept array or plain args
      return function (arg) {
        if (typeof arg == "number") arg = Array.prototype.slice.call(arguments);
        return conversions[func](arg);
      };
    }(func);

    var pair = /(\w+)2(\w+)/.exec(func),
        from = pair[1],
        to = pair[2]; // export rgb2hsl and ["rgb"]["hsl"]

    convert[from] = convert[from] || {};

    convert[from][to] = convert[func] = function (func) {
      return function (arg) {
        if (typeof arg == "number") arg = Array.prototype.slice.call(arguments);
        var val = conversions[func](arg);
        if (typeof val == "string" || val === undefined) return val; // keyword

        for (var i = 0; i < val.length; i++) val[i] = Math.round(val[i]);

        return val;
      };
    }(func);
  }
  /* Converter does lazy conversion and caching */


  var Converter = function () {
    this.convs = {};
  };
  /* Either get the values for a space or
    set the values for a space, depending on args */


  Converter.prototype.routeSpace = function (space, args) {
    var values = args[0];

    if (values === undefined) {
      // color.rgb()
      return this.getValues(space);
    } // color.rgb(10, 10, 10)


    if (typeof values == "number") {
      values = Array.prototype.slice.call(args);
    }

    return this.setValues(space, values);
  };
  /* Set the values for a space, invalidating cache */


  Converter.prototype.setValues = function (space, values) {
    this.space = space;
    this.convs = {};
    this.convs[space] = values;
    return this;
  };
  /* Get the values for a space. If there's already
    a conversion for the space, fetch it, otherwise
    compute it */


  Converter.prototype.getValues = function (space) {
    var vals = this.convs[space];

    if (!vals) {
      var fspace = this.space,
          from = this.convs[fspace];
      vals = convert[fspace][space](from);
      this.convs[space] = vals;
    }

    return vals;
  };

  ["rgb", "hsl", "hsv", "cmyk", "keyword"].forEach(function (space) {
    Converter.prototype[space] = function (vals) {
      return this.routeSpace(space, arguments);
    };
  });
  var colorConvert = convert;
  var colorName = {
    "aliceblue": [240, 248, 255],
    "antiquewhite": [250, 235, 215],
    "aqua": [0, 255, 255],
    "aquamarine": [127, 255, 212],
    "azure": [240, 255, 255],
    "beige": [245, 245, 220],
    "bisque": [255, 228, 196],
    "black": [0, 0, 0],
    "blanchedalmond": [255, 235, 205],
    "blue": [0, 0, 255],
    "blueviolet": [138, 43, 226],
    "brown": [165, 42, 42],
    "burlywood": [222, 184, 135],
    "cadetblue": [95, 158, 160],
    "chartreuse": [127, 255, 0],
    "chocolate": [210, 105, 30],
    "coral": [255, 127, 80],
    "cornflowerblue": [100, 149, 237],
    "cornsilk": [255, 248, 220],
    "crimson": [220, 20, 60],
    "cyan": [0, 255, 255],
    "darkblue": [0, 0, 139],
    "darkcyan": [0, 139, 139],
    "darkgoldenrod": [184, 134, 11],
    "darkgray": [169, 169, 169],
    "darkgreen": [0, 100, 0],
    "darkgrey": [169, 169, 169],
    "darkkhaki": [189, 183, 107],
    "darkmagenta": [139, 0, 139],
    "darkolivegreen": [85, 107, 47],
    "darkorange": [255, 140, 0],
    "darkorchid": [153, 50, 204],
    "darkred": [139, 0, 0],
    "darksalmon": [233, 150, 122],
    "darkseagreen": [143, 188, 143],
    "darkslateblue": [72, 61, 139],
    "darkslategray": [47, 79, 79],
    "darkslategrey": [47, 79, 79],
    "darkturquoise": [0, 206, 209],
    "darkviolet": [148, 0, 211],
    "deeppink": [255, 20, 147],
    "deepskyblue": [0, 191, 255],
    "dimgray": [105, 105, 105],
    "dimgrey": [105, 105, 105],
    "dodgerblue": [30, 144, 255],
    "firebrick": [178, 34, 34],
    "floralwhite": [255, 250, 240],
    "forestgreen": [34, 139, 34],
    "fuchsia": [255, 0, 255],
    "gainsboro": [220, 220, 220],
    "ghostwhite": [248, 248, 255],
    "gold": [255, 215, 0],
    "goldenrod": [218, 165, 32],
    "gray": [128, 128, 128],
    "green": [0, 128, 0],
    "greenyellow": [173, 255, 47],
    "grey": [128, 128, 128],
    "honeydew": [240, 255, 240],
    "hotpink": [255, 105, 180],
    "indianred": [205, 92, 92],
    "indigo": [75, 0, 130],
    "ivory": [255, 255, 240],
    "khaki": [240, 230, 140],
    "lavender": [230, 230, 250],
    "lavenderblush": [255, 240, 245],
    "lawngreen": [124, 252, 0],
    "lemonchiffon": [255, 250, 205],
    "lightblue": [173, 216, 230],
    "lightcoral": [240, 128, 128],
    "lightcyan": [224, 255, 255],
    "lightgoldenrodyellow": [250, 250, 210],
    "lightgray": [211, 211, 211],
    "lightgreen": [144, 238, 144],
    "lightgrey": [211, 211, 211],
    "lightpink": [255, 182, 193],
    "lightsalmon": [255, 160, 122],
    "lightseagreen": [32, 178, 170],
    "lightskyblue": [135, 206, 250],
    "lightslategray": [119, 136, 153],
    "lightslategrey": [119, 136, 153],
    "lightsteelblue": [176, 196, 222],
    "lightyellow": [255, 255, 224],
    "lime": [0, 255, 0],
    "limegreen": [50, 205, 50],
    "linen": [250, 240, 230],
    "magenta": [255, 0, 255],
    "maroon": [128, 0, 0],
    "mediumaquamarine": [102, 205, 170],
    "mediumblue": [0, 0, 205],
    "mediumorchid": [186, 85, 211],
    "mediumpurple": [147, 112, 219],
    "mediumseagreen": [60, 179, 113],
    "mediumslateblue": [123, 104, 238],
    "mediumspringgreen": [0, 250, 154],
    "mediumturquoise": [72, 209, 204],
    "mediumvioletred": [199, 21, 133],
    "midnightblue": [25, 25, 112],
    "mintcream": [245, 255, 250],
    "mistyrose": [255, 228, 225],
    "moccasin": [255, 228, 181],
    "navajowhite": [255, 222, 173],
    "navy": [0, 0, 128],
    "oldlace": [253, 245, 230],
    "olive": [128, 128, 0],
    "olivedrab": [107, 142, 35],
    "orange": [255, 165, 0],
    "orangered": [255, 69, 0],
    "orchid": [218, 112, 214],
    "palegoldenrod": [238, 232, 170],
    "palegreen": [152, 251, 152],
    "paleturquoise": [175, 238, 238],
    "palevioletred": [219, 112, 147],
    "papayawhip": [255, 239, 213],
    "peachpuff": [255, 218, 185],
    "peru": [205, 133, 63],
    "pink": [255, 192, 203],
    "plum": [221, 160, 221],
    "powderblue": [176, 224, 230],
    "purple": [128, 0, 128],
    "rebeccapurple": [102, 51, 153],
    "red": [255, 0, 0],
    "rosybrown": [188, 143, 143],
    "royalblue": [65, 105, 225],
    "saddlebrown": [139, 69, 19],
    "salmon": [250, 128, 114],
    "sandybrown": [244, 164, 96],
    "seagreen": [46, 139, 87],
    "seashell": [255, 245, 238],
    "sienna": [160, 82, 45],
    "silver": [192, 192, 192],
    "skyblue": [135, 206, 235],
    "slateblue": [106, 90, 205],
    "slategray": [112, 128, 144],
    "slategrey": [112, 128, 144],
    "snow": [255, 250, 250],
    "springgreen": [0, 255, 127],
    "steelblue": [70, 130, 180],
    "tan": [210, 180, 140],
    "teal": [0, 128, 128],
    "thistle": [216, 191, 216],
    "tomato": [255, 99, 71],
    "turquoise": [64, 224, 208],
    "violet": [238, 130, 238],
    "wheat": [245, 222, 179],
    "white": [255, 255, 255],
    "whitesmoke": [245, 245, 245],
    "yellow": [255, 255, 0],
    "yellowgreen": [154, 205, 50]
  };
  /* MIT license */

  var colorString = {
    getRgba: getRgba,
    getHsla: getHsla,
    getRgb: getRgb,
    getHsl: getHsl,
    getHwb: getHwb,
    getAlpha: getAlpha,
    hexString: hexString,
    rgbString: rgbString,
    rgbaString: rgbaString,
    percentString: percentString,
    percentaString: percentaString,
    hslString: hslString,
    hslaString: hslaString,
    hwbString: hwbString,
    keyword: keyword
  };

  function getRgba(string) {
    if (!string) {
      return;
    }

    var abbr = /^#([a-fA-F0-9]{3,4})$/i,
        hex = /^#([a-fA-F0-9]{6}([a-fA-F0-9]{2})?)$/i,
        rgba = /^rgba?\(\s*([+-]?\d+)\s*,\s*([+-]?\d+)\s*,\s*([+-]?\d+)\s*(?:,\s*([+-]?[\d\.]+)\s*)?\)$/i,
        per = /^rgba?\(\s*([+-]?[\d\.]+)\%\s*,\s*([+-]?[\d\.]+)\%\s*,\s*([+-]?[\d\.]+)\%\s*(?:,\s*([+-]?[\d\.]+)\s*)?\)$/i,
        keyword = /(\w+)/;
    var rgb = [0, 0, 0],
        a = 1,
        match = string.match(abbr),
        hexAlpha = "";

    if (match) {
      match = match[1];
      hexAlpha = match[3];

      for (var i = 0; i < rgb.length; i++) {
        rgb[i] = parseInt(match[i] + match[i], 16);
      }

      if (hexAlpha) {
        a = Math.round(parseInt(hexAlpha + hexAlpha, 16) / 255 * 100) / 100;
      }
    } else if (match = string.match(hex)) {
      hexAlpha = match[2];
      match = match[1];

      for (var i = 0; i < rgb.length; i++) {
        rgb[i] = parseInt(match.slice(i * 2, i * 2 + 2), 16);
      }

      if (hexAlpha) {
        a = Math.round(parseInt(hexAlpha, 16) / 255 * 100) / 100;
      }
    } else if (match = string.match(rgba)) {
      for (var i = 0; i < rgb.length; i++) {
        rgb[i] = parseInt(match[i + 1]);
      }

      a = parseFloat(match[4]);
    } else if (match = string.match(per)) {
      for (var i = 0; i < rgb.length; i++) {
        rgb[i] = Math.round(parseFloat(match[i + 1]) * 2.55);
      }

      a = parseFloat(match[4]);
    } else if (match = string.match(keyword)) {
      if (match[1] == "transparent") {
        return [0, 0, 0, 0];
      }

      rgb = colorName[match[1]];

      if (!rgb) {
        return;
      }
    }

    for (var i = 0; i < rgb.length; i++) {
      rgb[i] = scale(rgb[i], 0, 255);
    }

    if (!a && a != 0) {
      a = 1;
    } else {
      a = scale(a, 0, 1);
    }

    rgb[3] = a;
    return rgb;
  }

  function getHsla(string) {
    if (!string) {
      return;
    }

    var hsl = /^hsla?\(\s*([+-]?\d+)(?:deg)?\s*,\s*([+-]?[\d\.]+)%\s*,\s*([+-]?[\d\.]+)%\s*(?:,\s*([+-]?[\d\.]+)\s*)?\)/;
    var match = string.match(hsl);

    if (match) {
      var alpha = parseFloat(match[4]);
      var h = scale(parseInt(match[1]), 0, 360),
          s = scale(parseFloat(match[2]), 0, 100),
          l = scale(parseFloat(match[3]), 0, 100),
          a = scale(isNaN(alpha) ? 1 : alpha, 0, 1);
      return [h, s, l, a];
    }
  }

  function getHwb(string) {
    if (!string) {
      return;
    }

    var hwb = /^hwb\(\s*([+-]?\d+)(?:deg)?\s*,\s*([+-]?[\d\.]+)%\s*,\s*([+-]?[\d\.]+)%\s*(?:,\s*([+-]?[\d\.]+)\s*)?\)/;
    var match = string.match(hwb);

    if (match) {
      var alpha = parseFloat(match[4]);
      var h = scale(parseInt(match[1]), 0, 360),
          w = scale(parseFloat(match[2]), 0, 100),
          b = scale(parseFloat(match[3]), 0, 100),
          a = scale(isNaN(alpha) ? 1 : alpha, 0, 1);
      return [h, w, b, a];
    }
  }

  function getRgb(string) {
    var rgba = getRgba(string);
    return rgba && rgba.slice(0, 3);
  }

  function getHsl(string) {
    var hsla = getHsla(string);
    return hsla && hsla.slice(0, 3);
  }

  function getAlpha(string) {
    var vals = getRgba(string);

    if (vals) {
      return vals[3];
    } else if (vals = getHsla(string)) {
      return vals[3];
    } else if (vals = getHwb(string)) {
      return vals[3];
    }
  } // generators


  function hexString(rgba, a) {
    var a = a !== undefined && rgba.length === 3 ? a : rgba[3];
    return "#" + hexDouble(rgba[0]) + hexDouble(rgba[1]) + hexDouble(rgba[2]) + (a >= 0 && a < 1 ? hexDouble(Math.round(a * 255)) : "");
  }

  function rgbString(rgba, alpha) {
    if (alpha < 1 || rgba[3] && rgba[3] < 1) {
      return rgbaString(rgba, alpha);
    }

    return "rgb(" + rgba[0] + ", " + rgba[1] + ", " + rgba[2] + ")";
  }

  function rgbaString(rgba, alpha) {
    if (alpha === undefined) {
      alpha = rgba[3] !== undefined ? rgba[3] : 1;
    }

    return "rgba(" + rgba[0] + ", " + rgba[1] + ", " + rgba[2] + ", " + alpha + ")";
  }

  function percentString(rgba, alpha) {
    if (alpha < 1 || rgba[3] && rgba[3] < 1) {
      return percentaString(rgba, alpha);
    }

    var r = Math.round(rgba[0] / 255 * 100),
        g = Math.round(rgba[1] / 255 * 100),
        b = Math.round(rgba[2] / 255 * 100);
    return "rgb(" + r + "%, " + g + "%, " + b + "%)";
  }

  function percentaString(rgba, alpha) {
    var r = Math.round(rgba[0] / 255 * 100),
        g = Math.round(rgba[1] / 255 * 100),
        b = Math.round(rgba[2] / 255 * 100);
    return "rgba(" + r + "%, " + g + "%, " + b + "%, " + (alpha || rgba[3] || 1) + ")";
  }

  function hslString(hsla, alpha) {
    if (alpha < 1 || hsla[3] && hsla[3] < 1) {
      return hslaString(hsla, alpha);
    }

    return "hsl(" + hsla[0] + ", " + hsla[1] + "%, " + hsla[2] + "%)";
  }

  function hslaString(hsla, alpha) {
    if (alpha === undefined) {
      alpha = hsla[3] !== undefined ? hsla[3] : 1;
    }

    return "hsla(" + hsla[0] + ", " + hsla[1] + "%, " + hsla[2] + "%, " + alpha + ")";
  } // hwb is a bit different than rgb(a) & hsl(a) since there is no alpha specific syntax
  // (hwb have alpha optional & 1 is default value)


  function hwbString(hwb, alpha) {
    if (alpha === undefined) {
      alpha = hwb[3] !== undefined ? hwb[3] : 1;
    }

    return "hwb(" + hwb[0] + ", " + hwb[1] + "%, " + hwb[2] + "%" + (alpha !== undefined && alpha !== 1 ? ", " + alpha : "") + ")";
  }

  function keyword(rgb) {
    return reverseNames[rgb.slice(0, 3)];
  } // helpers


  function scale(num, min, max) {
    return Math.min(Math.max(min, num), max);
  }

  function hexDouble(num) {
    var str = num.toString(16).toUpperCase();
    return str.length < 2 ? "0" + str : str;
  } //create a list of reverse color names


  var reverseNames = {};

  for (var name in colorName) {
    reverseNames[colorName[name]] = name;
  }
  /* MIT license */


  var Color = function (obj) {
    if (obj instanceof Color) {
      return obj;
    }

    if (!(this instanceof Color)) {
      return new Color(obj);
    }

    this.valid = false;
    this.values = {
      rgb: [0, 0, 0],
      hsl: [0, 0, 0],
      hsv: [0, 0, 0],
      hwb: [0, 0, 0],
      cmyk: [0, 0, 0, 0],
      alpha: 1
    }; // parse Color() argument

    var vals;

    if (typeof obj === 'string') {
      vals = colorString.getRgba(obj);

      if (vals) {
        this.setValues('rgb', vals);
      } else if (vals = colorString.getHsla(obj)) {
        this.setValues('hsl', vals);
      } else if (vals = colorString.getHwb(obj)) {
        this.setValues('hwb', vals);
      }
    } else if (typeof obj === 'object') {
      vals = obj;

      if (vals.r !== undefined || vals.red !== undefined) {
        this.setValues('rgb', vals);
      } else if (vals.l !== undefined || vals.lightness !== undefined) {
        this.setValues('hsl', vals);
      } else if (vals.v !== undefined || vals.value !== undefined) {
        this.setValues('hsv', vals);
      } else if (vals.w !== undefined || vals.whiteness !== undefined) {
        this.setValues('hwb', vals);
      } else if (vals.c !== undefined || vals.cyan !== undefined) {
        this.setValues('cmyk', vals);
      }
    }
  };

  Color.prototype = {
    isValid: function () {
      return this.valid;
    },
    rgb: function () {
      return this.setSpace('rgb', arguments);
    },
    hsl: function () {
      return this.setSpace('hsl', arguments);
    },
    hsv: function () {
      return this.setSpace('hsv', arguments);
    },
    hwb: function () {
      return this.setSpace('hwb', arguments);
    },
    cmyk: function () {
      return this.setSpace('cmyk', arguments);
    },
    rgbArray: function () {
      return this.values.rgb;
    },
    hslArray: function () {
      return this.values.hsl;
    },
    hsvArray: function () {
      return this.values.hsv;
    },
    hwbArray: function () {
      var values = this.values;

      if (values.alpha !== 1) {
        return values.hwb.concat([values.alpha]);
      }

      return values.hwb;
    },
    cmykArray: function () {
      return this.values.cmyk;
    },
    rgbaArray: function () {
      var values = this.values;
      return values.rgb.concat([values.alpha]);
    },
    hslaArray: function () {
      var values = this.values;
      return values.hsl.concat([values.alpha]);
    },
    alpha: function (val) {
      if (val === undefined) {
        return this.values.alpha;
      }

      this.setValues('alpha', val);
      return this;
    },
    red: function (val) {
      return this.setChannel('rgb', 0, val);
    },
    green: function (val) {
      return this.setChannel('rgb', 1, val);
    },
    blue: function (val) {
      return this.setChannel('rgb', 2, val);
    },
    hue: function (val) {
      if (val) {
        val %= 360;
        val = val < 0 ? 360 + val : val;
      }

      return this.setChannel('hsl', 0, val);
    },
    saturation: function (val) {
      return this.setChannel('hsl', 1, val);
    },
    lightness: function (val) {
      return this.setChannel('hsl', 2, val);
    },
    saturationv: function (val) {
      return this.setChannel('hsv', 1, val);
    },
    whiteness: function (val) {
      return this.setChannel('hwb', 1, val);
    },
    blackness: function (val) {
      return this.setChannel('hwb', 2, val);
    },
    value: function (val) {
      return this.setChannel('hsv', 2, val);
    },
    cyan: function (val) {
      return this.setChannel('cmyk', 0, val);
    },
    magenta: function (val) {
      return this.setChannel('cmyk', 1, val);
    },
    yellow: function (val) {
      return this.setChannel('cmyk', 2, val);
    },
    black: function (val) {
      return this.setChannel('cmyk', 3, val);
    },
    hexString: function () {
      return colorString.hexString(this.values.rgb);
    },
    rgbString: function () {
      return colorString.rgbString(this.values.rgb, this.values.alpha);
    },
    rgbaString: function () {
      return colorString.rgbaString(this.values.rgb, this.values.alpha);
    },
    percentString: function () {
      return colorString.percentString(this.values.rgb, this.values.alpha);
    },
    hslString: function () {
      return colorString.hslString(this.values.hsl, this.values.alpha);
    },
    hslaString: function () {
      return colorString.hslaString(this.values.hsl, this.values.alpha);
    },
    hwbString: function () {
      return colorString.hwbString(this.values.hwb, this.values.alpha);
    },
    keyword: function () {
      return colorString.keyword(this.values.rgb, this.values.alpha);
    },
    rgbNumber: function () {
      var rgb = this.values.rgb;
      return rgb[0] << 16 | rgb[1] << 8 | rgb[2];
    },
    luminosity: function () {
      // http://www.w3.org/TR/WCAG20/#relativeluminancedef
      var rgb = this.values.rgb;
      var lum = [];

      for (var i = 0; i < rgb.length; i++) {
        var chan = rgb[i] / 255;
        lum[i] = chan <= 0.03928 ? chan / 12.92 : Math.pow((chan + 0.055) / 1.055, 2.4);
      }

      return 0.2126 * lum[0] + 0.7152 * lum[1] + 0.0722 * lum[2];
    },
    contrast: function (color2) {
      // http://www.w3.org/TR/WCAG20/#contrast-ratiodef
      var lum1 = this.luminosity();
      var lum2 = color2.luminosity();

      if (lum1 > lum2) {
        return (lum1 + 0.05) / (lum2 + 0.05);
      }

      return (lum2 + 0.05) / (lum1 + 0.05);
    },
    level: function (color2) {
      var contrastRatio = this.contrast(color2);

      if (contrastRatio >= 7.1) {
        return 'AAA';
      }

      return contrastRatio >= 4.5 ? 'AA' : '';
    },
    dark: function () {
      // YIQ equation from http://24ways.org/2010/calculating-color-contrast
      var rgb = this.values.rgb;
      var yiq = (rgb[0] * 299 + rgb[1] * 587 + rgb[2] * 114) / 1000;
      return yiq < 128;
    },
    light: function () {
      return !this.dark();
    },
    negate: function () {
      var rgb = [];

      for (var i = 0; i < 3; i++) {
        rgb[i] = 255 - this.values.rgb[i];
      }

      this.setValues('rgb', rgb);
      return this;
    },
    lighten: function (ratio) {
      var hsl = this.values.hsl;
      hsl[2] += hsl[2] * ratio;
      this.setValues('hsl', hsl);
      return this;
    },
    darken: function (ratio) {
      var hsl = this.values.hsl;
      hsl[2] -= hsl[2] * ratio;
      this.setValues('hsl', hsl);
      return this;
    },
    saturate: function (ratio) {
      var hsl = this.values.hsl;
      hsl[1] += hsl[1] * ratio;
      this.setValues('hsl', hsl);
      return this;
    },
    desaturate: function (ratio) {
      var hsl = this.values.hsl;
      hsl[1] -= hsl[1] * ratio;
      this.setValues('hsl', hsl);
      return this;
    },
    whiten: function (ratio) {
      var hwb = this.values.hwb;
      hwb[1] += hwb[1] * ratio;
      this.setValues('hwb', hwb);
      return this;
    },
    blacken: function (ratio) {
      var hwb = this.values.hwb;
      hwb[2] += hwb[2] * ratio;
      this.setValues('hwb', hwb);
      return this;
    },
    greyscale: function () {
      var rgb = this.values.rgb; // http://en.wikipedia.org/wiki/Grayscale#Converting_color_to_grayscale

      var val = rgb[0] * 0.3 + rgb[1] * 0.59 + rgb[2] * 0.11;
      this.setValues('rgb', [val, val, val]);
      return this;
    },
    clearer: function (ratio) {
      var alpha = this.values.alpha;
      this.setValues('alpha', alpha - alpha * ratio);
      return this;
    },
    opaquer: function (ratio) {
      var alpha = this.values.alpha;
      this.setValues('alpha', alpha + alpha * ratio);
      return this;
    },
    rotate: function (degrees) {
      var hsl = this.values.hsl;
      var hue = (hsl[0] + degrees) % 360;
      hsl[0] = hue < 0 ? 360 + hue : hue;
      this.setValues('hsl', hsl);
      return this;
    },

    /**
     * Ported from sass implementation in C
     * https://github.com/sass/libsass/blob/0e6b4a2850092356aa3ece07c6b249f0221caced/functions.cpp#L209
     */
    mix: function (mixinColor, weight) {
      var color1 = this;
      var color2 = mixinColor;
      var p = weight === undefined ? 0.5 : weight;
      var w = 2 * p - 1;
      var a = color1.alpha() - color2.alpha();
      var w1 = ((w * a === -1 ? w : (w + a) / (1 + w * a)) + 1) / 2.0;
      var w2 = 1 - w1;
      return this.rgb(w1 * color1.red() + w2 * color2.red(), w1 * color1.green() + w2 * color2.green(), w1 * color1.blue() + w2 * color2.blue()).alpha(color1.alpha() * p + color2.alpha() * (1 - p));
    },
    toJSON: function () {
      return this.rgb();
    },
    clone: function () {
      // NOTE(SB): using node-clone creates a dependency to Buffer when using browserify,
      // making the final build way to big to embed in Chart.js. So let's do it manually,
      // assuming that values to clone are 1 dimension arrays containing only numbers,
      // except 'alpha' which is a number.
      var result = new Color();
      var source = this.values;
      var target = result.values;
      var value, type;

      for (var prop in source) {
        if (source.hasOwnProperty(prop)) {
          value = source[prop];
          type = {}.toString.call(value);

          if (type === '[object Array]') {
            target[prop] = value.slice(0);
          } else if (type === '[object Number]') {
            target[prop] = value;
          } else {
            console.error('unexpected color value:', value);
          }
        }
      }

      return result;
    }
  };
  Color.prototype.spaces = {
    rgb: ['red', 'green', 'blue'],
    hsl: ['hue', 'saturation', 'lightness'],
    hsv: ['hue', 'saturation', 'value'],
    hwb: ['hue', 'whiteness', 'blackness'],
    cmyk: ['cyan', 'magenta', 'yellow', 'black']
  };
  Color.prototype.maxes = {
    rgb: [255, 255, 255],
    hsl: [360, 100, 100],
    hsv: [360, 100, 100],
    hwb: [360, 100, 100],
    cmyk: [100, 100, 100, 100]
  };

  Color.prototype.getValues = function (space) {
    var values = this.values;
    var vals = {};

    for (var i = 0; i < space.length; i++) {
      vals[space.charAt(i)] = values[space][i];
    }

    if (values.alpha !== 1) {
      vals.a = values.alpha;
    } // {r: 255, g: 255, b: 255, a: 0.4}


    return vals;
  };

  Color.prototype.setValues = function (space, vals) {
    var values = this.values;
    var spaces = this.spaces;
    var maxes = this.maxes;
    var alpha = 1;
    var i;
    this.valid = true;

    if (space === 'alpha') {
      alpha = vals;
    } else if (vals.length) {
      // [10, 10, 10]
      values[space] = vals.slice(0, space.length);
      alpha = vals[space.length];
    } else if (vals[space.charAt(0)] !== undefined) {
      // {r: 10, g: 10, b: 10}
      for (i = 0; i < space.length; i++) {
        values[space][i] = vals[space.charAt(i)];
      }

      alpha = vals.a;
    } else if (vals[spaces[space][0]] !== undefined) {
      // {red: 10, green: 10, blue: 10}
      var chans = spaces[space];

      for (i = 0; i < space.length; i++) {
        values[space][i] = vals[chans[i]];
      }

      alpha = vals.alpha;
    }

    values.alpha = Math.max(0, Math.min(1, alpha === undefined ? values.alpha : alpha));

    if (space === 'alpha') {
      return false;
    }

    var capped; // cap values of the space prior converting all values

    for (i = 0; i < space.length; i++) {
      capped = Math.max(0, Math.min(maxes[space][i], values[space][i]));
      values[space][i] = Math.round(capped);
    } // convert to all the other color spaces


    for (var sname in spaces) {
      if (sname !== space) {
        values[sname] = colorConvert[space][sname](values[space]);
      }
    }

    return true;
  };

  Color.prototype.setSpace = function (space, args) {
    var vals = args[0];

    if (vals === undefined) {
      // color.rgb()
      return this.getValues(space);
    } // color.rgb(10, 10, 10)


    if (typeof vals === 'number') {
      vals = Array.prototype.slice.call(args);
    }

    this.setValues(space, vals);
    return this;
  };

  Color.prototype.setChannel = function (space, index, val) {
    var svalues = this.values[space];

    if (val === undefined) {
      // color.red()
      return svalues[index];
    } else if (val === svalues[index]) {
      // color.red(color.red())
      return this;
    } // color.red(100)


    svalues[index] = val;
    this.setValues(space, svalues);
    return this;
  };

  if (typeof window !== 'undefined') {
    window.Color = Color;
  }

  var chartjsColor = Color;
  /**
   * @namespace Chart.helpers
   */

  var helpers = {
    /**
     * An empty function that can be used, for example, for optional callback.
     */
    noop: function () {},

    /**
     * Returns a unique id, sequentially generated from a global variable.
     * @returns {number}
     * @function
     */
    uid: function () {
      var id = 0;
      return function () {
        return id++;
      };
    }(),

    /**
     * Returns true if `value` is neither null nor undefined, else returns false.
     * @param {*} value - The value to test.
     * @returns {boolean}
     * @since 2.7.0
     */
    isNullOrUndef: function (value) {
      return value === null || typeof value === 'undefined';
    },

    /**
     * Returns true if `value` is an array (including typed arrays), else returns false.
     * @param {*} value - The value to test.
     * @returns {boolean}
     * @function
     */
    isArray: function (value) {
      if (Array.isArray && Array.isArray(value)) {
        return true;
      }

      var type = Object.prototype.toString.call(value);

      if (type.substr(0, 7) === '[object' && type.substr(-6) === 'Array]') {
        return true;
      }

      return false;
    },

    /**
     * Returns true if `value` is an object (excluding null), else returns false.
     * @param {*} value - The value to test.
     * @returns {boolean}
     * @since 2.7.0
     */
    isObject: function (value) {
      return value !== null && Object.prototype.toString.call(value) === '[object Object]';
    },

    /**
     * Returns true if `value` is a finite number, else returns false
     * @param {*} value  - The value to test.
     * @returns {boolean}
     */
    isFinite: function (value) {
      return (typeof value === 'number' || value instanceof Number) && isFinite(value);
    },

    /**
     * Returns `value` if defined, else returns `defaultValue`.
     * @param {*} value - The value to return if defined.
     * @param {*} defaultValue - The value to return if `value` is undefined.
     * @returns {*}
     */
    valueOrDefault: function (value, defaultValue) {
      return typeof value === 'undefined' ? defaultValue : value;
    },

    /**
     * Returns value at the given `index` in array if defined, else returns `defaultValue`.
     * @param {Array} value - The array to lookup for value at `index`.
     * @param {number} index - The index in `value` to lookup for value.
     * @param {*} defaultValue - The value to return if `value[index]` is undefined.
     * @returns {*}
     */
    valueAtIndexOrDefault: function (value, index, defaultValue) {
      return helpers.valueOrDefault(helpers.isArray(value) ? value[index] : value, defaultValue);
    },

    /**
     * Calls `fn` with the given `args` in the scope defined by `thisArg` and returns the
     * value returned by `fn`. If `fn` is not a function, this method returns undefined.
     * @param {function} fn - The function to call.
     * @param {Array|undefined|null} args - The arguments with which `fn` should be called.
     * @param {object} [thisArg] - The value of `this` provided for the call to `fn`.
     * @returns {*}
     */
    callback: function (fn, args, thisArg) {
      if (fn && typeof fn.call === 'function') {
        return fn.apply(thisArg, args);
      }
    },

    /**
     * Note(SB) for performance sake, this method should only be used when loopable type
     * is unknown or in none intensive code (not called often and small loopable). Else
     * it's preferable to use a regular for() loop and save extra function calls.
     * @param {object|Array} loopable - The object or array to be iterated.
     * @param {function} fn - The function to call for each item.
     * @param {object} [thisArg] - The value of `this` provided for the call to `fn`.
     * @param {boolean} [reverse] - If true, iterates backward on the loopable.
     */
    each: function (loopable, fn, thisArg, reverse) {
      var i, len, keys;

      if (helpers.isArray(loopable)) {
        len = loopable.length;

        if (reverse) {
          for (i = len - 1; i >= 0; i--) {
            fn.call(thisArg, loopable[i], i);
          }
        } else {
          for (i = 0; i < len; i++) {
            fn.call(thisArg, loopable[i], i);
          }
        }
      } else if (helpers.isObject(loopable)) {
        keys = Object.keys(loopable);
        len = keys.length;

        for (i = 0; i < len; i++) {
          fn.call(thisArg, loopable[keys[i]], keys[i]);
        }
      }
    },

    /**
     * Returns true if the `a0` and `a1` arrays have the same content, else returns false.
     * @see https://stackoverflow.com/a/14853974
     * @param {Array} a0 - The array to compare
     * @param {Array} a1 - The array to compare
     * @returns {boolean}
     */
    arrayEquals: function (a0, a1) {
      var i, ilen, v0, v1;

      if (!a0 || !a1 || a0.length !== a1.length) {
        return false;
      }

      for (i = 0, ilen = a0.length; i < ilen; ++i) {
        v0 = a0[i];
        v1 = a1[i];

        if (v0 instanceof Array && v1 instanceof Array) {
          if (!helpers.arrayEquals(v0, v1)) {
            return false;
          }
        } else if (v0 !== v1) {
          // NOTE: two different object instances will never be equal: {x:20} != {x:20}
          return false;
        }
      }

      return true;
    },

    /**
     * Returns a deep copy of `source` without keeping references on objects and arrays.
     * @param {*} source - The value to clone.
     * @returns {*}
     */
    clone: function (source) {
      if (helpers.isArray(source)) {
        return source.map(helpers.clone);
      }

      if (helpers.isObject(source)) {
        var target = {};
        var keys = Object.keys(source);
        var klen = keys.length;
        var k = 0;

        for (; k < klen; ++k) {
          target[keys[k]] = helpers.clone(source[keys[k]]);
        }

        return target;
      }

      return source;
    },

    /**
     * The default merger when Chart.helpers.merge is called without merger option.
     * Note(SB): also used by mergeConfig and mergeScaleConfig as fallback.
     * @private
     */
    _merger: function (key, target, source, options) {
      var tval = target[key];
      var sval = source[key];

      if (helpers.isObject(tval) && helpers.isObject(sval)) {
        helpers.merge(tval, sval, options);
      } else {
        target[key] = helpers.clone(sval);
      }
    },

    /**
     * Merges source[key] in target[key] only if target[key] is undefined.
     * @private
     */
    _mergerIf: function (key, target, source) {
      var tval = target[key];
      var sval = source[key];

      if (helpers.isObject(tval) && helpers.isObject(sval)) {
        helpers.mergeIf(tval, sval);
      } else if (!target.hasOwnProperty(key)) {
        target[key] = helpers.clone(sval);
      }
    },

    /**
     * Recursively deep copies `source` properties into `target` with the given `options`.
     * IMPORTANT: `target` is not cloned and will be updated with `source` properties.
     * @param {object} target - The target object in which all sources are merged into.
     * @param {object|object[]} source - Object(s) to merge into `target`.
     * @param {object} [options] - Merging options:
     * @param {function} [options.merger] - The merge method (key, target, source, options)
     * @returns {object} The `target` object.
     */
    merge: function (target, source, options) {
      var sources = helpers.isArray(source) ? source : [source];
      var ilen = sources.length;
      var merge, i, keys, klen, k;

      if (!helpers.isObject(target)) {
        return target;
      }

      options = options || {};
      merge = options.merger || helpers._merger;

      for (i = 0; i < ilen; ++i) {
        source = sources[i];

        if (!helpers.isObject(source)) {
          continue;
        }

        keys = Object.keys(source);

        for (k = 0, klen = keys.length; k < klen; ++k) {
          merge(keys[k], target, source, options);
        }
      }

      return target;
    },

    /**
     * Recursively deep copies `source` properties into `target` *only* if not defined in target.
     * IMPORTANT: `target` is not cloned and will be updated with `source` properties.
     * @param {object} target - The target object in which all sources are merged into.
     * @param {object|object[]} source - Object(s) to merge into `target`.
     * @returns {object} The `target` object.
     */
    mergeIf: function (target, source) {
      return helpers.merge(target, source, {
        merger: helpers._mergerIf
      });
    },

    /**
     * Applies the contents of two or more objects together into the first object.
     * @param {object} target - The target object in which all objects are merged into.
     * @param {object} arg1 - Object containing additional properties to merge in target.
     * @param {object} argN - Additional objects containing properties to merge in target.
     * @returns {object} The `target` object.
     */
    extend: function (target) {
      var setFn = function (value, key) {
        target[key] = value;
      };

      for (var i = 1, ilen = arguments.length; i < ilen; ++i) {
        helpers.each(arguments[i], setFn);
      }

      return target;
    },

    /**
     * Basic javascript inheritance based on the model created in Backbone.js
     */
    inherits: function (extensions) {
      var me = this;
      var ChartElement = extensions && extensions.hasOwnProperty('constructor') ? extensions.constructor : function () {
        return me.apply(this, arguments);
      };

      var Surrogate = function () {
        this.constructor = ChartElement;
      };

      Surrogate.prototype = me.prototype;
      ChartElement.prototype = new Surrogate();
      ChartElement.extend = helpers.inherits;

      if (extensions) {
        helpers.extend(ChartElement.prototype, extensions);
      }

      ChartElement.__super__ = me.prototype;
      return ChartElement;
    }
  };
  var helpers_core = helpers; // DEPRECATIONS

  /**
   * Provided for backward compatibility, use Chart.helpers.callback instead.
   * @function Chart.helpers.callCallback
   * @deprecated since version 2.6.0
   * @todo remove at version 3
   * @private
   */

  helpers.callCallback = helpers.callback;
  /**
   * Provided for backward compatibility, use Array.prototype.indexOf instead.
   * Array.prototype.indexOf compatibility: Chrome, Opera, Safari, FF1.5+, IE9+
   * @function Chart.helpers.indexOf
   * @deprecated since version 2.7.0
   * @todo remove at version 3
   * @private
   */

  helpers.indexOf = function (array, item, fromIndex) {
    return Array.prototype.indexOf.call(array, item, fromIndex);
  };
  /**
   * Provided for backward compatibility, use Chart.helpers.valueOrDefault instead.
   * @function Chart.helpers.getValueOrDefault
   * @deprecated since version 2.7.0
   * @todo remove at version 3
   * @private
   */


  helpers.getValueOrDefault = helpers.valueOrDefault;
  /**
   * Provided for backward compatibility, use Chart.helpers.valueAtIndexOrDefault instead.
   * @function Chart.helpers.getValueAtIndexOrDefault
   * @deprecated since version 2.7.0
   * @todo remove at version 3
   * @private
   */

  helpers.getValueAtIndexOrDefault = helpers.valueAtIndexOrDefault;
  /**
   * Easing functions adapted from Robert Penner's easing equations.
   * @namespace Chart.helpers.easingEffects
   * @see http://www.robertpenner.com/easing/
   */

  var effects = {
    linear: function (t) {
      return t;
    },
    easeInQuad: function (t) {
      return t * t;
    },
    easeOutQuad: function (t) {
      return -t * (t - 2);
    },
    easeInOutQuad: function (t) {
      if ((t /= 0.5) < 1) {
        return 0.5 * t * t;
      }

      return -0.5 * (--t * (t - 2) - 1);
    },
    easeInCubic: function (t) {
      return t * t * t;
    },
    easeOutCubic: function (t) {
      return (t = t - 1) * t * t + 1;
    },
    easeInOutCubic: function (t) {
      if ((t /= 0.5) < 1) {
        return 0.5 * t * t * t;
      }

      return 0.5 * ((t -= 2) * t * t + 2);
    },
    easeInQuart: function (t) {
      return t * t * t * t;
    },
    easeOutQuart: function (t) {
      return -((t = t - 1) * t * t * t - 1);
    },
    easeInOutQuart: function (t) {
      if ((t /= 0.5) < 1) {
        return 0.5 * t * t * t * t;
      }

      return -0.5 * ((t -= 2) * t * t * t - 2);
    },
    easeInQuint: function (t) {
      return t * t * t * t * t;
    },
    easeOutQuint: function (t) {
      return (t = t - 1) * t * t * t * t + 1;
    },
    easeInOutQuint: function (t) {
      if ((t /= 0.5) < 1) {
        return 0.5 * t * t * t * t * t;
      }

      return 0.5 * ((t -= 2) * t * t * t * t + 2);
    },
    easeInSine: function (t) {
      return -Math.cos(t * (Math.PI / 2)) + 1;
    },
    easeOutSine: function (t) {
      return Math.sin(t * (Math.PI / 2));
    },
    easeInOutSine: function (t) {
      return -0.5 * (Math.cos(Math.PI * t) - 1);
    },
    easeInExpo: function (t) {
      return t === 0 ? 0 : Math.pow(2, 10 * (t - 1));
    },
    easeOutExpo: function (t) {
      return t === 1 ? 1 : -Math.pow(2, -10 * t) + 1;
    },
    easeInOutExpo: function (t) {
      if (t === 0) {
        return 0;
      }

      if (t === 1) {
        return 1;
      }

      if ((t /= 0.5) < 1) {
        return 0.5 * Math.pow(2, 10 * (t - 1));
      }

      return 0.5 * (-Math.pow(2, -10 * --t) + 2);
    },
    easeInCirc: function (t) {
      if (t >= 1) {
        return t;
      }

      return -(Math.sqrt(1 - t * t) - 1);
    },
    easeOutCirc: function (t) {
      return Math.sqrt(1 - (t = t - 1) * t);
    },
    easeInOutCirc: function (t) {
      if ((t /= 0.5) < 1) {
        return -0.5 * (Math.sqrt(1 - t * t) - 1);
      }

      return 0.5 * (Math.sqrt(1 - (t -= 2) * t) + 1);
    },
    easeInElastic: function (t) {
      var s = 1.70158;
      var p = 0;
      var a = 1;

      if (t === 0) {
        return 0;
      }

      if (t === 1) {
        return 1;
      }

      if (!p) {
        p = 0.3;
      }

      if (a < 1) {
        a = 1;
        s = p / 4;
      } else {
        s = p / (2 * Math.PI) * Math.asin(1 / a);
      }

      return -(a * Math.pow(2, 10 * (t -= 1)) * Math.sin((t - s) * (2 * Math.PI) / p));
    },
    easeOutElastic: function (t) {
      var s = 1.70158;
      var p = 0;
      var a = 1;

      if (t === 0) {
        return 0;
      }

      if (t === 1) {
        return 1;
      }

      if (!p) {
        p = 0.3;
      }

      if (a < 1) {
        a = 1;
        s = p / 4;
      } else {
        s = p / (2 * Math.PI) * Math.asin(1 / a);
      }

      return a * Math.pow(2, -10 * t) * Math.sin((t - s) * (2 * Math.PI) / p) + 1;
    },
    easeInOutElastic: function (t) {
      var s = 1.70158;
      var p = 0;
      var a = 1;

      if (t === 0) {
        return 0;
      }

      if ((t /= 0.5) === 2) {
        return 1;
      }

      if (!p) {
        p = 0.45;
      }

      if (a < 1) {
        a = 1;
        s = p / 4;
      } else {
        s = p / (2 * Math.PI) * Math.asin(1 / a);
      }

      if (t < 1) {
        return -0.5 * (a * Math.pow(2, 10 * (t -= 1)) * Math.sin((t - s) * (2 * Math.PI) / p));
      }

      return a * Math.pow(2, -10 * (t -= 1)) * Math.sin((t - s) * (2 * Math.PI) / p) * 0.5 + 1;
    },
    easeInBack: function (t) {
      var s = 1.70158;
      return t * t * ((s + 1) * t - s);
    },
    easeOutBack: function (t) {
      var s = 1.70158;
      return (t = t - 1) * t * ((s + 1) * t + s) + 1;
    },
    easeInOutBack: function (t) {
      var s = 1.70158;

      if ((t /= 0.5) < 1) {
        return 0.5 * (t * t * (((s *= 1.525) + 1) * t - s));
      }

      return 0.5 * ((t -= 2) * t * (((s *= 1.525) + 1) * t + s) + 2);
    },
    easeInBounce: function (t) {
      return 1 - effects.easeOutBounce(1 - t);
    },
    easeOutBounce: function (t) {
      if (t < 1 / 2.75) {
        return 7.5625 * t * t;
      }

      if (t < 2 / 2.75) {
        return 7.5625 * (t -= 1.5 / 2.75) * t + 0.75;
      }

      if (t < 2.5 / 2.75) {
        return 7.5625 * (t -= 2.25 / 2.75) * t + 0.9375;
      }

      return 7.5625 * (t -= 2.625 / 2.75) * t + 0.984375;
    },
    easeInOutBounce: function (t) {
      if (t < 0.5) {
        return effects.easeInBounce(t * 2) * 0.5;
      }

      return effects.easeOutBounce(t * 2 - 1) * 0.5 + 0.5;
    }
  };
  var helpers_easing = {
    effects: effects
  }; // DEPRECATIONS

  /**
   * Provided for backward compatibility, use Chart.helpers.easing.effects instead.
   * @function Chart.helpers.easingEffects
   * @deprecated since version 2.7.0
   * @todo remove at version 3
   * @private
   */

  helpers_core.easingEffects = effects;
  var PI = Math.PI;
  var RAD_PER_DEG = PI / 180;
  var DOUBLE_PI = PI * 2;
  var HALF_PI = PI / 2;
  var QUARTER_PI = PI / 4;
  var TWO_THIRDS_PI = PI * 2 / 3;
  /**
   * @namespace Chart.helpers.canvas
   */

  var exports$1 = {
    /**
     * Clears the entire canvas associated to the given `chart`.
     * @param {Chart} chart - The chart for which to clear the canvas.
     */
    clear: function (chart) {
      chart.ctx.clearRect(0, 0, chart.width, chart.height);
    },

    /**
     * Creates a "path" for a rectangle with rounded corners at position (x, y) with a
     * given size (width, height) and the same `radius` for all corners.
     * @param {CanvasRenderingContext2D} ctx - The canvas 2D Context.
     * @param {number} x - The x axis of the coordinate for the rectangle starting point.
     * @param {number} y - The y axis of the coordinate for the rectangle starting point.
     * @param {number} width - The rectangle's width.
     * @param {number} height - The rectangle's height.
     * @param {number} radius - The rounded amount (in pixels) for the four corners.
     * @todo handle `radius` as top-left, top-right, bottom-right, bottom-left array/object?
     */
    roundedRect: function (ctx, x, y, width, height, radius) {
      if (radius) {
        var r = Math.min(radius, height / 2, width / 2);
        var left = x + r;
        var top = y + r;
        var right = x + width - r;
        var bottom = y + height - r;
        ctx.moveTo(x, top);

        if (left < right && top < bottom) {
          ctx.arc(left, top, r, -PI, -HALF_PI);
          ctx.arc(right, top, r, -HALF_PI, 0);
          ctx.arc(right, bottom, r, 0, HALF_PI);
          ctx.arc(left, bottom, r, HALF_PI, PI);
        } else if (left < right) {
          ctx.moveTo(left, y);
          ctx.arc(right, top, r, -HALF_PI, HALF_PI);
          ctx.arc(left, top, r, HALF_PI, PI + HALF_PI);
        } else if (top < bottom) {
          ctx.arc(left, top, r, -PI, 0);
          ctx.arc(left, bottom, r, 0, PI);
        } else {
          ctx.arc(left, top, r, -PI, PI);
        }

        ctx.closePath();
        ctx.moveTo(x, y);
      } else {
        ctx.rect(x, y, width, height);
      }
    },
    drawPoint: function (ctx, style, radius, x, y, rotation) {
      var type, xOffset, yOffset, size, cornerRadius;
      var rad = (rotation || 0) * RAD_PER_DEG;

      if (style && typeof style === 'object') {
        type = style.toString();

        if (type === '[object HTMLImageElement]' || type === '[object HTMLCanvasElement]') {
          ctx.drawImage(style, x - style.width / 2, y - style.height / 2, style.width, style.height);
          return;
        }
      }

      if (isNaN(radius) || radius <= 0) {
        return;
      }

      ctx.beginPath();

      switch (style) {
        // Default includes circle
        default:
          ctx.arc(x, y, radius, 0, DOUBLE_PI);
          ctx.closePath();
          break;

        case 'triangle':
          ctx.moveTo(x + Math.sin(rad) * radius, y - Math.cos(rad) * radius);
          rad += TWO_THIRDS_PI;
          ctx.lineTo(x + Math.sin(rad) * radius, y - Math.cos(rad) * radius);
          rad += TWO_THIRDS_PI;
          ctx.lineTo(x + Math.sin(rad) * radius, y - Math.cos(rad) * radius);
          ctx.closePath();
          break;

        case 'rectRounded':
          // NOTE: the rounded rect implementation changed to use `arc` instead of
          // `quadraticCurveTo` since it generates better results when rect is
          // almost a circle. 0.516 (instead of 0.5) produces results with visually
          // closer proportion to the previous impl and it is inscribed in the
          // circle with `radius`. For more details, see the following PRs:
          // https://github.com/chartjs/Chart.js/issues/5597
          // https://github.com/chartjs/Chart.js/issues/5858
          cornerRadius = radius * 0.516;
          size = radius - cornerRadius;
          xOffset = Math.cos(rad + QUARTER_PI) * size;
          yOffset = Math.sin(rad + QUARTER_PI) * size;
          ctx.arc(x - xOffset, y - yOffset, cornerRadius, rad - PI, rad - HALF_PI);
          ctx.arc(x + yOffset, y - xOffset, cornerRadius, rad - HALF_PI, rad);
          ctx.arc(x + xOffset, y + yOffset, cornerRadius, rad, rad + HALF_PI);
          ctx.arc(x - yOffset, y + xOffset, cornerRadius, rad + HALF_PI, rad + PI);
          ctx.closePath();
          break;

        case 'rect':
          if (!rotation) {
            size = Math.SQRT1_2 * radius;
            ctx.rect(x - size, y - size, 2 * size, 2 * size);
            break;
          }

          rad += QUARTER_PI;

        /* falls through */

        case 'rectRot':
          xOffset = Math.cos(rad) * radius;
          yOffset = Math.sin(rad) * radius;
          ctx.moveTo(x - xOffset, y - yOffset);
          ctx.lineTo(x + yOffset, y - xOffset);
          ctx.lineTo(x + xOffset, y + yOffset);
          ctx.lineTo(x - yOffset, y + xOffset);
          ctx.closePath();
          break;

        case 'crossRot':
          rad += QUARTER_PI;

        /* falls through */

        case 'cross':
          xOffset = Math.cos(rad) * radius;
          yOffset = Math.sin(rad) * radius;
          ctx.moveTo(x - xOffset, y - yOffset);
          ctx.lineTo(x + xOffset, y + yOffset);
          ctx.moveTo(x + yOffset, y - xOffset);
          ctx.lineTo(x - yOffset, y + xOffset);
          break;

        case 'star':
          xOffset = Math.cos(rad) * radius;
          yOffset = Math.sin(rad) * radius;
          ctx.moveTo(x - xOffset, y - yOffset);
          ctx.lineTo(x + xOffset, y + yOffset);
          ctx.moveTo(x + yOffset, y - xOffset);
          ctx.lineTo(x - yOffset, y + xOffset);
          rad += QUARTER_PI;
          xOffset = Math.cos(rad) * radius;
          yOffset = Math.sin(rad) * radius;
          ctx.moveTo(x - xOffset, y - yOffset);
          ctx.lineTo(x + xOffset, y + yOffset);
          ctx.moveTo(x + yOffset, y - xOffset);
          ctx.lineTo(x - yOffset, y + xOffset);
          break;

        case 'line':
          xOffset = Math.cos(rad) * radius;
          yOffset = Math.sin(rad) * radius;
          ctx.moveTo(x - xOffset, y - yOffset);
          ctx.lineTo(x + xOffset, y + yOffset);
          break;

        case 'dash':
          ctx.moveTo(x, y);
          ctx.lineTo(x + Math.cos(rad) * radius, y + Math.sin(rad) * radius);
          break;
      }

      ctx.fill();
      ctx.stroke();
    },

    /**
     * Returns true if the point is inside the rectangle
     * @param {object} point - The point to test
     * @param {object} area - The rectangle
     * @returns {boolean}
     * @private
     */
    _isPointInArea: function (point, area) {
      var epsilon = 1e-6; // 1e-6 is margin in pixels for accumulated error.

      return point.x > area.left - epsilon && point.x < area.right + epsilon && point.y > area.top - epsilon && point.y < area.bottom + epsilon;
    },
    clipArea: function (ctx, area) {
      ctx.save();
      ctx.beginPath();
      ctx.rect(area.left, area.top, area.right - area.left, area.bottom - area.top);
      ctx.clip();
    },
    unclipArea: function (ctx) {
      ctx.restore();
    },
    lineTo: function (ctx, previous, target, flip) {
      var stepped = target.steppedLine;

      if (stepped) {
        if (stepped === 'middle') {
          var midpoint = (previous.x + target.x) / 2.0;
          ctx.lineTo(midpoint, flip ? target.y : previous.y);
          ctx.lineTo(midpoint, flip ? previous.y : target.y);
        } else if (stepped === 'after' && !flip || stepped !== 'after' && flip) {
          ctx.lineTo(previous.x, target.y);
        } else {
          ctx.lineTo(target.x, previous.y);
        }

        ctx.lineTo(target.x, target.y);
        return;
      }

      if (!target.tension) {
        ctx.lineTo(target.x, target.y);
        return;
      }

      ctx.bezierCurveTo(flip ? previous.controlPointPreviousX : previous.controlPointNextX, flip ? previous.controlPointPreviousY : previous.controlPointNextY, flip ? target.controlPointNextX : target.controlPointPreviousX, flip ? target.controlPointNextY : target.controlPointPreviousY, target.x, target.y);
    }
  };
  var helpers_canvas = exports$1; // DEPRECATIONS

  /**
   * Provided for backward compatibility, use Chart.helpers.canvas.clear instead.
   * @namespace Chart.helpers.clear
   * @deprecated since version 2.7.0
   * @todo remove at version 3
   * @private
   */

  helpers_core.clear = exports$1.clear;
  /**
   * Provided for backward compatibility, use Chart.helpers.canvas.roundedRect instead.
   * @namespace Chart.helpers.drawRoundedRectangle
   * @deprecated since version 2.7.0
   * @todo remove at version 3
   * @private
   */

  helpers_core.drawRoundedRectangle = function (ctx) {
    ctx.beginPath();
    exports$1.roundedRect.apply(exports$1, arguments);
  };

  var defaults = {
    /**
     * @private
     */
    _set: function (scope, values) {
      return helpers_core.merge(this[scope] || (this[scope] = {}), values);
    }
  };

  defaults._set('global', {
    defaultColor: 'rgba(0,0,0,0.1)',
    defaultFontColor: '#666',
    defaultFontFamily: "'Helvetica Neue', 'Helvetica', 'Arial', sans-serif",
    defaultFontSize: 12,
    defaultFontStyle: 'normal',
    defaultLineHeight: 1.2,
    showLines: true
  });

  var core_defaults = defaults;
  var valueOrDefault = helpers_core.valueOrDefault;
  /**
   * Converts the given font object into a CSS font string.
   * @param {object} font - A font object.
   * @return {string} The CSS font string. See https://developer.mozilla.org/en-US/docs/Web/CSS/font
   * @private
   */

  function toFontString(font) {
    if (!font || helpers_core.isNullOrUndef(font.size) || helpers_core.isNullOrUndef(font.family)) {
      return null;
    }

    return (font.style ? font.style + ' ' : '') + (font.weight ? font.weight + ' ' : '') + font.size + 'px ' + font.family;
  }
  /**
   * @alias Chart.helpers.options
   * @namespace
   */


  var helpers_options = {
    /**
     * Converts the given line height `value` in pixels for a specific font `size`.
     * @param {number|string} value - The lineHeight to parse (eg. 1.6, '14px', '75%', '1.6em').
     * @param {number} size - The font size (in pixels) used to resolve relative `value`.
     * @returns {number} The effective line height in pixels (size * 1.2 if value is invalid).
     * @see https://developer.mozilla.org/en-US/docs/Web/CSS/line-height
     * @since 2.7.0
     */
    toLineHeight: function (value, size) {
      var matches = ('' + value).match(/^(normal|(\d+(?:\.\d+)?)(px|em|%)?)$/);

      if (!matches || matches[1] === 'normal') {
        return size * 1.2;
      }

      value = +matches[2];

      switch (matches[3]) {
        case 'px':
          return value;

        case '%':
          value /= 100;
          break;

        default:
          break;
      }

      return size * value;
    },

    /**
     * Converts the given value into a padding object with pre-computed width/height.
     * @param {number|object} value - If a number, set the value to all TRBL component,
     *  else, if and object, use defined properties and sets undefined ones to 0.
     * @returns {object} The padding values (top, right, bottom, left, width, height)
     * @since 2.7.0
     */
    toPadding: function (value) {
      var t, r, b, l;

      if (helpers_core.isObject(value)) {
        t = +value.top || 0;
        r = +value.right || 0;
        b = +value.bottom || 0;
        l = +value.left || 0;
      } else {
        t = r = b = l = +value || 0;
      }

      return {
        top: t,
        right: r,
        bottom: b,
        left: l,
        height: t + b,
        width: l + r
      };
    },

    /**
     * Parses font options and returns the font object.
     * @param {object} options - A object that contains font options to be parsed.
     * @return {object} The font object.
     * @todo Support font.* options and renamed to toFont().
     * @private
     */
    _parseFont: function (options) {
      var globalDefaults = core_defaults.global;
      var size = valueOrDefault(options.fontSize, globalDefaults.defaultFontSize);
      var font = {
        family: valueOrDefault(options.fontFamily, globalDefaults.defaultFontFamily),
        lineHeight: helpers_core.options.toLineHeight(valueOrDefault(options.lineHeight, globalDefaults.defaultLineHeight), size),
        size: size,
        style: valueOrDefault(options.fontStyle, globalDefaults.defaultFontStyle),
        weight: null,
        string: ''
      };
      font.string = toFontString(font);
      return font;
    },

    /**
     * Evaluates the given `inputs` sequentially and returns the first defined value.
     * @param {Array} inputs - An array of values, falling back to the last value.
     * @param {object} [context] - If defined and the current value is a function, the value
     * is called with `context` as first argument and the result becomes the new input.
     * @param {number} [index] - If defined and the current value is an array, the value
     * at `index` become the new input.
     * @since 2.7.0
     */
    resolve: function (inputs, context, index) {
      var i, ilen, value;

      for (i = 0, ilen = inputs.length; i < ilen; ++i) {
        value = inputs[i];

        if (value === undefined) {
          continue;
        }

        if (context !== undefined && typeof value === 'function') {
          value = value(context);
        }

        if (index !== undefined && helpers_core.isArray(value)) {
          value = value[index];
        }

        if (value !== undefined) {
          return value;
        }
      }
    }
  };
  var helpers$1 = helpers_core;
  var easing = helpers_easing;
  var canvas = helpers_canvas;
  var options = helpers_options;
  helpers$1.easing = easing;
  helpers$1.canvas = canvas;
  helpers$1.options = options;

  function interpolate(start, view, model, ease) {
    var keys = Object.keys(model);
    var i, ilen, key, actual, origin, target, type, c0, c1;

    for (i = 0, ilen = keys.length; i < ilen; ++i) {
      key = keys[i];
      target = model[key]; // if a value is added to the model after pivot() has been called, the view
      // doesn't contain it, so let's initialize the view to the target value.

      if (!view.hasOwnProperty(key)) {
        view[key] = target;
      }

      actual = view[key];

      if (actual === target || key[0] === '_') {
        continue;
      }

      if (!start.hasOwnProperty(key)) {
        start[key] = actual;
      }

      origin = start[key];
      type = typeof target;

      if (type === typeof origin) {
        if (type === 'string') {
          c0 = chartjsColor(origin);

          if (c0.valid) {
            c1 = chartjsColor(target);

            if (c1.valid) {
              view[key] = c1.mix(c0, ease).rgbString();
              continue;
            }
          }
        } else if (helpers$1.isFinite(origin) && helpers$1.isFinite(target)) {
          view[key] = origin + (target - origin) * ease;
          continue;
        }
      }

      view[key] = target;
    }
  }

  var Element = function (configuration) {
    helpers$1.extend(this, configuration);
    this.initialize.apply(this, arguments);
  };

  helpers$1.extend(Element.prototype, {
    initialize: function () {
      this.hidden = false;
    },
    pivot: function () {
      var me = this;

      if (!me._view) {
        me._view = helpers$1.clone(me._model);
      }

      me._start = {};
      return me;
    },
    transition: function (ease) {
      var me = this;
      var model = me._model;
      var start = me._start;
      var view = me._view; // No animation -> No Transition

      if (!model || ease === 1) {
        me._view = model;
        me._start = null;
        return me;
      }

      if (!view) {
        view = me._view = {};
      }

      if (!start) {
        start = me._start = {};
      }

      interpolate(start, view, model, ease);
      return me;
    },
    tooltipPosition: function () {
      return {
        x: this._model.x,
        y: this._model.y
      };
    },
    hasValue: function () {
      return helpers$1.isNumber(this._model.x) && helpers$1.isNumber(this._model.y);
    }
  });
  Element.extend = helpers$1.inherits;
  var core_element = Element;
  var exports$2 = core_element.extend({
    chart: null,
    // the animation associated chart instance
    currentStep: 0,
    // the current animation step
    numSteps: 60,
    // default number of steps
    easing: '',
    // the easing to use for this animation
    render: null,
    // render function used by the animation service
    onAnimationProgress: null,
    // user specified callback to fire on each step of the animation
    onAnimationComplete: null // user specified callback to fire when the animation finishes

  });
  var core_animation = exports$2; // DEPRECATIONS

  /**
   * Provided for backward compatibility, use Chart.Animation instead
   * @prop Chart.Animation#animationObject
   * @deprecated since version 2.6.0
   * @todo remove at version 3
   */

  Object.defineProperty(exports$2.prototype, 'animationObject', {
    get: function () {
      return this;
    }
  });
  /**
   * Provided for backward compatibility, use Chart.Animation#chart instead
   * @prop Chart.Animation#chartInstance
   * @deprecated since version 2.6.0
   * @todo remove at version 3
   */

  Object.defineProperty(exports$2.prototype, 'chartInstance', {
    get: function () {
      return this.chart;
    },
    set: function (value) {
      this.chart = value;
    }
  });

  core_defaults._set('global', {
    animation: {
      duration: 1000,
      easing: 'easeOutQuart',
      onProgress: helpers$1.noop,
      onComplete: helpers$1.noop
    }
  });

  var core_animations = {
    animations: [],
    request: null,

    /**
     * @param {Chart} chart - The chart to animate.
     * @param {Chart.Animation} animation - The animation that we will animate.
     * @param {number} duration - The animation duration in ms.
     * @param {boolean} lazy - if true, the chart is not marked as animating to enable more responsive interactions
     */
    addAnimation: function (chart, animation, duration, lazy) {
      var animations = this.animations;
      var i, ilen;
      animation.chart = chart;
      animation.startTime = Date.now();
      animation.duration = duration;

      if (!lazy) {
        chart.animating = true;
      }

      for (i = 0, ilen = animations.length; i < ilen; ++i) {
        if (animations[i].chart === chart) {
          animations[i] = animation;
          return;
        }
      }

      animations.push(animation); // If there are no animations queued, manually kickstart a digest, for lack of a better word

      if (animations.length === 1) {
        this.requestAnimationFrame();
      }
    },
    cancelAnimation: function (chart) {
      var index = helpers$1.findIndex(this.animations, function (animation) {
        return animation.chart === chart;
      });

      if (index !== -1) {
        this.animations.splice(index, 1);
        chart.animating = false;
      }
    },
    requestAnimationFrame: function () {
      var me = this;

      if (me.request === null) {
        // Skip animation frame requests until the active one is executed.
        // This can happen when processing mouse events, e.g. 'mousemove'
        // and 'mouseout' events will trigger multiple renders.
        me.request = helpers$1.requestAnimFrame.call(window, function () {
          me.request = null;
          me.startDigest();
        });
      }
    },

    /**
     * @private
     */
    startDigest: function () {
      var me = this;
      me.advance(); // Do we have more stuff to animate?

      if (me.animations.length > 0) {
        me.requestAnimationFrame();
      }
    },

    /**
     * @private
     */
    advance: function () {
      var animations = this.animations;
      var animation, chart, numSteps, nextStep;
      var i = 0; // 1 animation per chart, so we are looping charts here

      while (i < animations.length) {
        animation = animations[i];
        chart = animation.chart;
        numSteps = animation.numSteps; // Make sure that currentStep starts at 1
        // https://github.com/chartjs/Chart.js/issues/6104

        nextStep = Math.floor((Date.now() - animation.startTime) / animation.duration * numSteps) + 1;
        animation.currentStep = Math.min(nextStep, numSteps);
        helpers$1.callback(animation.render, [chart, animation], chart);
        helpers$1.callback(animation.onAnimationProgress, [animation], chart);

        if (animation.currentStep >= numSteps) {
          helpers$1.callback(animation.onAnimationComplete, [animation], chart);
          chart.animating = false;
          animations.splice(i, 1);
        } else {
          ++i;
        }
      }
    }
  };
  var resolve = helpers$1.options.resolve;
  var arrayEvents = ['push', 'pop', 'shift', 'splice', 'unshift'];
  /**
   * Hooks the array methods that add or remove values ('push', pop', 'shift', 'splice',
   * 'unshift') and notify the listener AFTER the array has been altered. Listeners are
   * called on the 'onData*' callbacks (e.g. onDataPush, etc.) with same arguments.
   */

  function listenArrayEvents(array, listener) {
    if (array._chartjs) {
      array._chartjs.listeners.push(listener);

      return;
    }

    Object.defineProperty(array, '_chartjs', {
      configurable: true,
      enumerable: false,
      value: {
        listeners: [listener]
      }
    });
    arrayEvents.forEach(function (key) {
      var method = 'onData' + key.charAt(0).toUpperCase() + key.slice(1);
      var base = array[key];
      Object.defineProperty(array, key, {
        configurable: true,
        enumerable: false,
        value: function () {
          var args = Array.prototype.slice.call(arguments);
          var res = base.apply(this, args);
          helpers$1.each(array._chartjs.listeners, function (object) {
            if (typeof object[method] === 'function') {
              object[method].apply(object, args);
            }
          });
          return res;
        }
      });
    });
  }
  /**
   * Removes the given array event listener and cleanup extra attached properties (such as
   * the _chartjs stub and overridden methods) if array doesn't have any more listeners.
   */


  function unlistenArrayEvents(array, listener) {
    var stub = array._chartjs;

    if (!stub) {
      return;
    }

    var listeners = stub.listeners;
    var index = listeners.indexOf(listener);

    if (index !== -1) {
      listeners.splice(index, 1);
    }

    if (listeners.length > 0) {
      return;
    }

    arrayEvents.forEach(function (key) {
      delete array[key];
    });
    delete array._chartjs;
  } // Base class for all dataset controllers (line, bar, etc)


  var DatasetController = function (chart, datasetIndex) {
    this.initialize(chart, datasetIndex);
  };

  helpers$1.extend(DatasetController.prototype, {
    /**
     * Element type used to generate a meta dataset (e.g. Chart.element.Line).
     * @type {Chart.core.element}
     */
    datasetElementType: null,

    /**
     * Element type used to generate a meta data (e.g. Chart.element.Point).
     * @type {Chart.core.element}
     */
    dataElementType: null,
    initialize: function (chart, datasetIndex) {
      var me = this;
      me.chart = chart;
      me.index = datasetIndex;
      me.linkScales();
      me.addElements();
    },
    updateIndex: function (datasetIndex) {
      this.index = datasetIndex;
    },
    linkScales: function () {
      var me = this;
      var meta = me.getMeta();
      var dataset = me.getDataset();

      if (meta.xAxisID === null || !(meta.xAxisID in me.chart.scales)) {
        meta.xAxisID = dataset.xAxisID || me.chart.options.scales.xAxes[0].id;
      }

      if (meta.yAxisID === null || !(meta.yAxisID in me.chart.scales)) {
        meta.yAxisID = dataset.yAxisID || me.chart.options.scales.yAxes[0].id;
      }
    },
    getDataset: function () {
      return this.chart.data.datasets[this.index];
    },
    getMeta: function () {
      return this.chart.getDatasetMeta(this.index);
    },
    getScaleForId: function (scaleID) {
      return this.chart.scales[scaleID];
    },

    /**
     * @private
     */
    _getValueScaleId: function () {
      return this.getMeta().yAxisID;
    },

    /**
     * @private
     */
    _getIndexScaleId: function () {
      return this.getMeta().xAxisID;
    },

    /**
     * @private
     */
    _getValueScale: function () {
      return this.getScaleForId(this._getValueScaleId());
    },

    /**
     * @private
     */
    _getIndexScale: function () {
      return this.getScaleForId(this._getIndexScaleId());
    },
    reset: function () {
      this.update(true);
    },

    /**
     * @private
     */
    destroy: function () {
      if (this._data) {
        unlistenArrayEvents(this._data, this);
      }
    },
    createMetaDataset: function () {
      var me = this;
      var type = me.datasetElementType;
      return type && new type({
        _chart: me.chart,
        _datasetIndex: me.index
      });
    },
    createMetaData: function (index) {
      var me = this;
      var type = me.dataElementType;
      return type && new type({
        _chart: me.chart,
        _datasetIndex: me.index,
        _index: index
      });
    },
    addElements: function () {
      var me = this;
      var meta = me.getMeta();
      var data = me.getDataset().data || [];
      var metaData = meta.data;
      var i, ilen;

      for (i = 0, ilen = data.length; i < ilen; ++i) {
        metaData[i] = metaData[i] || me.createMetaData(i);
      }

      meta.dataset = meta.dataset || me.createMetaDataset();
    },
    addElementAndReset: function (index) {
      var element = this.createMetaData(index);
      this.getMeta().data.splice(index, 0, element);
      this.updateElement(element, index, true);
    },
    buildOrUpdateElements: function () {
      var me = this;
      var dataset = me.getDataset();
      var data = dataset.data || (dataset.data = []); // In order to correctly handle data addition/deletion animation (an thus simulate
      // real-time charts), we need to monitor these data modifications and synchronize
      // the internal meta data accordingly.

      if (me._data !== data) {
        if (me._data) {
          // This case happens when the user replaced the data array instance.
          unlistenArrayEvents(me._data, me);
        }

        if (data && Object.isExtensible(data)) {
          listenArrayEvents(data, me);
        }

        me._data = data;
      } // Re-sync meta data in case the user replaced the data array or if we missed
      // any updates and so make sure that we handle number of datapoints changing.


      me.resyncElements();
    },
    update: helpers$1.noop,
    transition: function (easingValue) {
      var meta = this.getMeta();
      var elements = meta.data || [];
      var ilen = elements.length;
      var i = 0;

      for (; i < ilen; ++i) {
        elements[i].transition(easingValue);
      }

      if (meta.dataset) {
        meta.dataset.transition(easingValue);
      }
    },
    draw: function () {
      var meta = this.getMeta();
      var elements = meta.data || [];
      var ilen = elements.length;
      var i = 0;

      if (meta.dataset) {
        meta.dataset.draw();
      }

      for (; i < ilen; ++i) {
        elements[i].draw();
      }
    },
    removeHoverStyle: function (element) {
      helpers$1.merge(element._model, element.$previousStyle || {});
      delete element.$previousStyle;
    },
    setHoverStyle: function (element) {
      var dataset = this.chart.data.datasets[element._datasetIndex];
      var index = element._index;
      var custom = element.custom || {};
      var model = element._model;
      var getHoverColor = helpers$1.getHoverColor;
      element.$previousStyle = {
        backgroundColor: model.backgroundColor,
        borderColor: model.borderColor,
        borderWidth: model.borderWidth
      };
      model.backgroundColor = resolve([custom.hoverBackgroundColor, dataset.hoverBackgroundColor, getHoverColor(model.backgroundColor)], undefined, index);
      model.borderColor = resolve([custom.hoverBorderColor, dataset.hoverBorderColor, getHoverColor(model.borderColor)], undefined, index);
      model.borderWidth = resolve([custom.hoverBorderWidth, dataset.hoverBorderWidth, model.borderWidth], undefined, index);
    },

    /**
     * @private
     */
    resyncElements: function () {
      var me = this;
      var meta = me.getMeta();
      var data = me.getDataset().data;
      var numMeta = meta.data.length;
      var numData = data.length;

      if (numData < numMeta) {
        meta.data.splice(numData, numMeta - numData);
      } else if (numData > numMeta) {
        me.insertElements(numMeta, numData - numMeta);
      }
    },

    /**
     * @private
     */
    insertElements: function (start, count) {
      for (var i = 0; i < count; ++i) {
        this.addElementAndReset(start + i);
      }
    },

    /**
     * @private
     */
    onDataPush: function () {
      var count = arguments.length;
      this.insertElements(this.getDataset().data.length - count, count);
    },

    /**
     * @private
     */
    onDataPop: function () {
      this.getMeta().data.pop();
    },

    /**
     * @private
     */
    onDataShift: function () {
      this.getMeta().data.shift();
    },

    /**
     * @private
     */
    onDataSplice: function (start, count) {
      this.getMeta().data.splice(start, count);
      this.insertElements(start, arguments.length - 2);
    },

    /**
     * @private
     */
    onDataUnshift: function () {
      this.insertElements(0, arguments.length);
    }
  });
  DatasetController.extend = helpers$1.inherits;
  var core_datasetController = DatasetController;

  core_defaults._set('global', {
    elements: {
      arc: {
        backgroundColor: core_defaults.global.defaultColor,
        borderColor: '#fff',
        borderWidth: 2,
        borderAlign: 'center'
      }
    }
  });

  var element_arc = core_element.extend({
    inLabelRange: function (mouseX) {
      var vm = this._view;

      if (vm) {
        return Math.pow(mouseX - vm.x, 2) < Math.pow(vm.radius + vm.hoverRadius, 2);
      }

      return false;
    },
    inRange: function (chartX, chartY) {
      var vm = this._view;

      if (vm) {
        var pointRelativePosition = helpers$1.getAngleFromPoint(vm, {
          x: chartX,
          y: chartY
        });
        var angle = pointRelativePosition.angle;
        var distance = pointRelativePosition.distance; // Sanitise angle range

        var startAngle = vm.startAngle;
        var endAngle = vm.endAngle;

        while (endAngle < startAngle) {
          endAngle += 2.0 * Math.PI;
        }

        while (angle > endAngle) {
          angle -= 2.0 * Math.PI;
        }

        while (angle < startAngle) {
          angle += 2.0 * Math.PI;
        } // Check if within the range of the open/close angle


        var betweenAngles = angle >= startAngle && angle <= endAngle;
        var withinRadius = distance >= vm.innerRadius && distance <= vm.outerRadius;
        return betweenAngles && withinRadius;
      }

      return false;
    },
    getCenterPoint: function () {
      var vm = this._view;
      var halfAngle = (vm.startAngle + vm.endAngle) / 2;
      var halfRadius = (vm.innerRadius + vm.outerRadius) / 2;
      return {
        x: vm.x + Math.cos(halfAngle) * halfRadius,
        y: vm.y + Math.sin(halfAngle) * halfRadius
      };
    },
    getArea: function () {
      var vm = this._view;
      return Math.PI * ((vm.endAngle - vm.startAngle) / (2 * Math.PI)) * (Math.pow(vm.outerRadius, 2) - Math.pow(vm.innerRadius, 2));
    },
    tooltipPosition: function () {
      var vm = this._view;
      var centreAngle = vm.startAngle + (vm.endAngle - vm.startAngle) / 2;
      var rangeFromCentre = (vm.outerRadius - vm.innerRadius) / 2 + vm.innerRadius;
      return {
        x: vm.x + Math.cos(centreAngle) * rangeFromCentre,
        y: vm.y + Math.sin(centreAngle) * rangeFromCentre
      };
    },
    draw: function () {
      var ctx = this._chart.ctx;
      var vm = this._view;
      var sA = vm.startAngle;
      var eA = vm.endAngle;
      var pixelMargin = vm.borderAlign === 'inner' ? 0.33 : 0;
      var angleMargin;
      ctx.save();
      ctx.beginPath();
      ctx.arc(vm.x, vm.y, Math.max(vm.outerRadius - pixelMargin, 0), sA, eA);
      ctx.arc(vm.x, vm.y, vm.innerRadius, eA, sA, true);
      ctx.closePath();
      ctx.fillStyle = vm.backgroundColor;
      ctx.fill();

      if (vm.borderWidth) {
        if (vm.borderAlign === 'inner') {
          // Draw an inner border by cliping the arc and drawing a double-width border
          // Enlarge the clipping arc by 0.33 pixels to eliminate glitches between borders
          ctx.beginPath();
          angleMargin = pixelMargin / vm.outerRadius;
          ctx.arc(vm.x, vm.y, vm.outerRadius, sA - angleMargin, eA + angleMargin);

          if (vm.innerRadius > pixelMargin) {
            angleMargin = pixelMargin / vm.innerRadius;
            ctx.arc(vm.x, vm.y, vm.innerRadius - pixelMargin, eA + angleMargin, sA - angleMargin, true);
          } else {
            ctx.arc(vm.x, vm.y, pixelMargin, eA + Math.PI / 2, sA - Math.PI / 2);
          }

          ctx.closePath();
          ctx.clip();
          ctx.beginPath();
          ctx.arc(vm.x, vm.y, vm.outerRadius, sA, eA);
          ctx.arc(vm.x, vm.y, vm.innerRadius, eA, sA, true);
          ctx.closePath();
          ctx.lineWidth = vm.borderWidth * 2;
          ctx.lineJoin = 'round';
        } else {
          ctx.lineWidth = vm.borderWidth;
          ctx.lineJoin = 'bevel';
        }

        ctx.strokeStyle = vm.borderColor;
        ctx.stroke();
      }

      ctx.restore();
    }
  });
  var valueOrDefault$1 = helpers$1.valueOrDefault;
  var defaultColor = core_defaults.global.defaultColor;

  core_defaults._set('global', {
    elements: {
      line: {
        tension: 0.4,
        backgroundColor: defaultColor,
        borderWidth: 3,
        borderColor: defaultColor,
        borderCapStyle: 'butt',
        borderDash: [],
        borderDashOffset: 0.0,
        borderJoinStyle: 'miter',
        capBezierPoints: true,
        fill: true // do we fill in the area between the line and its base axis

      }
    }
  });

  var element_line = core_element.extend({
    draw: function () {
      var me = this;
      var vm = me._view;
      var ctx = me._chart.ctx;
      var spanGaps = vm.spanGaps;

      var points = me._children.slice(); // clone array


      var globalDefaults = core_defaults.global;
      var globalOptionLineElements = globalDefaults.elements.line;
      var lastDrawnIndex = -1;
      var index, current, previous, currentVM; // If we are looping, adding the first point again

      if (me._loop && points.length) {
        points.push(points[0]);
      }

      ctx.save(); // Stroke Line Options

      ctx.lineCap = vm.borderCapStyle || globalOptionLineElements.borderCapStyle; // IE 9 and 10 do not support line dash

      if (ctx.setLineDash) {
        ctx.setLineDash(vm.borderDash || globalOptionLineElements.borderDash);
      }

      ctx.lineDashOffset = valueOrDefault$1(vm.borderDashOffset, globalOptionLineElements.borderDashOffset);
      ctx.lineJoin = vm.borderJoinStyle || globalOptionLineElements.borderJoinStyle;
      ctx.lineWidth = valueOrDefault$1(vm.borderWidth, globalOptionLineElements.borderWidth);
      ctx.strokeStyle = vm.borderColor || globalDefaults.defaultColor; // Stroke Line

      ctx.beginPath();
      lastDrawnIndex = -1;

      for (index = 0; index < points.length; ++index) {
        current = points[index];
        previous = helpers$1.previousItem(points, index);
        currentVM = current._view; // First point moves to it's starting position no matter what

        if (index === 0) {
          if (!currentVM.skip) {
            ctx.moveTo(currentVM.x, currentVM.y);
            lastDrawnIndex = index;
          }
        } else {
          previous = lastDrawnIndex === -1 ? previous : points[lastDrawnIndex];

          if (!currentVM.skip) {
            if (lastDrawnIndex !== index - 1 && !spanGaps || lastDrawnIndex === -1) {
              // There was a gap and this is the first point after the gap
              ctx.moveTo(currentVM.x, currentVM.y);
            } else {
              // Line to next point
              helpers$1.canvas.lineTo(ctx, previous._view, current._view);
            }

            lastDrawnIndex = index;
          }
        }
      }

      ctx.stroke();
      ctx.restore();
    }
  });
  var valueOrDefault$2 = helpers$1.valueOrDefault;
  var defaultColor$1 = core_defaults.global.defaultColor;

  core_defaults._set('global', {
    elements: {
      point: {
        radius: 3,
        pointStyle: 'circle',
        backgroundColor: defaultColor$1,
        borderColor: defaultColor$1,
        borderWidth: 1,
        // Hover
        hitRadius: 1,
        hoverRadius: 4,
        hoverBorderWidth: 1
      }
    }
  });

  function xRange(mouseX) {
    var vm = this._view;
    return vm ? Math.abs(mouseX - vm.x) < vm.radius + vm.hitRadius : false;
  }

  function yRange(mouseY) {
    var vm = this._view;
    return vm ? Math.abs(mouseY - vm.y) < vm.radius + vm.hitRadius : false;
  }

  var element_point = core_element.extend({
    inRange: function (mouseX, mouseY) {
      var vm = this._view;
      return vm ? Math.pow(mouseX - vm.x, 2) + Math.pow(mouseY - vm.y, 2) < Math.pow(vm.hitRadius + vm.radius, 2) : false;
    },
    inLabelRange: xRange,
    inXRange: xRange,
    inYRange: yRange,
    getCenterPoint: function () {
      var vm = this._view;
      return {
        x: vm.x,
        y: vm.y
      };
    },
    getArea: function () {
      return Math.PI * Math.pow(this._view.radius, 2);
    },
    tooltipPosition: function () {
      var vm = this._view;
      return {
        x: vm.x,
        y: vm.y,
        padding: vm.radius + vm.borderWidth
      };
    },
    draw: function (chartArea) {
      var vm = this._view;
      var ctx = this._chart.ctx;
      var pointStyle = vm.pointStyle;
      var rotation = vm.rotation;
      var radius = vm.radius;
      var x = vm.x;
      var y = vm.y;
      var globalDefaults = core_defaults.global;
      var defaultColor = globalDefaults.defaultColor; // eslint-disable-line no-shadow

      if (vm.skip) {
        return;
      } // Clipping for Points.


      if (chartArea === undefined || helpers$1.canvas._isPointInArea(vm, chartArea)) {
        ctx.strokeStyle = vm.borderColor || defaultColor;
        ctx.lineWidth = valueOrDefault$2(vm.borderWidth, globalDefaults.elements.point.borderWidth);
        ctx.fillStyle = vm.backgroundColor || defaultColor;
        helpers$1.canvas.drawPoint(ctx, pointStyle, radius, x, y, rotation);
      }
    }
  });
  var defaultColor$2 = core_defaults.global.defaultColor;

  core_defaults._set('global', {
    elements: {
      rectangle: {
        backgroundColor: defaultColor$2,
        borderColor: defaultColor$2,
        borderSkipped: 'bottom',
        borderWidth: 0
      }
    }
  });

  function isVertical(vm) {
    return vm && vm.width !== undefined;
  }
  /**
   * Helper function to get the bounds of the bar regardless of the orientation
   * @param bar {Chart.Element.Rectangle} the bar
   * @return {Bounds} bounds of the bar
   * @private
   */


  function getBarBounds(vm) {
    var x1, x2, y1, y2, half;

    if (isVertical(vm)) {
      half = vm.width / 2;
      x1 = vm.x - half;
      x2 = vm.x + half;
      y1 = Math.min(vm.y, vm.base);
      y2 = Math.max(vm.y, vm.base);
    } else {
      half = vm.height / 2;
      x1 = Math.min(vm.x, vm.base);
      x2 = Math.max(vm.x, vm.base);
      y1 = vm.y - half;
      y2 = vm.y + half;
    }

    return {
      left: x1,
      top: y1,
      right: x2,
      bottom: y2
    };
  }

  function swap(orig, v1, v2) {
    return orig === v1 ? v2 : orig === v2 ? v1 : orig;
  }

  function parseBorderSkipped(vm) {
    var edge = vm.borderSkipped;
    var res = {};

    if (!edge) {
      return res;
    }

    if (vm.horizontal) {
      if (vm.base > vm.x) {
        edge = swap(edge, 'left', 'right');
      }
    } else if (vm.base < vm.y) {
      edge = swap(edge, 'bottom', 'top');
    }

    res[edge] = true;
    return res;
  }

  function parseBorderWidth(vm, maxW, maxH) {
    var value = vm.borderWidth;
    var skip = parseBorderSkipped(vm);
    var t, r, b, l;

    if (helpers$1.isObject(value)) {
      t = +value.top || 0;
      r = +value.right || 0;
      b = +value.bottom || 0;
      l = +value.left || 0;
    } else {
      t = r = b = l = +value || 0;
    }

    return {
      t: skip.top || t < 0 ? 0 : t > maxH ? maxH : t,
      r: skip.right || r < 0 ? 0 : r > maxW ? maxW : r,
      b: skip.bottom || b < 0 ? 0 : b > maxH ? maxH : b,
      l: skip.left || l < 0 ? 0 : l > maxW ? maxW : l
    };
  }

  function boundingRects(vm) {
    var bounds = getBarBounds(vm);
    var width = bounds.right - bounds.left;
    var height = bounds.bottom - bounds.top;
    var border = parseBorderWidth(vm, width / 2, height / 2);
    return {
      outer: {
        x: bounds.left,
        y: bounds.top,
        w: width,
        h: height
      },
      inner: {
        x: bounds.left + border.l,
        y: bounds.top + border.t,
        w: width - border.l - border.r,
        h: height - border.t - border.b
      }
    };
  }

  function inRange(vm, x, y) {
    var skipX = x === null;
    var skipY = y === null;
    var bounds = !vm || skipX && skipY ? false : getBarBounds(vm);
    return bounds && (skipX || x >= bounds.left && x <= bounds.right) && (skipY || y >= bounds.top && y <= bounds.bottom);
  }

  var element_rectangle = core_element.extend({
    draw: function () {
      var ctx = this._chart.ctx;
      var vm = this._view;
      var rects = boundingRects(vm);
      var outer = rects.outer;
      var inner = rects.inner;
      ctx.fillStyle = vm.backgroundColor;
      ctx.fillRect(outer.x, outer.y, outer.w, outer.h);

      if (outer.w === inner.w && outer.h === inner.h) {
        return;
      }

      ctx.save();
      ctx.beginPath();
      ctx.rect(outer.x, outer.y, outer.w, outer.h);
      ctx.clip();
      ctx.fillStyle = vm.borderColor;
      ctx.rect(inner.x, inner.y, inner.w, inner.h);
      ctx.fill('evenodd');
      ctx.restore();
    },
    height: function () {
      var vm = this._view;
      return vm.base - vm.y;
    },
    inRange: function (mouseX, mouseY) {
      return inRange(this._view, mouseX, mouseY);
    },
    inLabelRange: function (mouseX, mouseY) {
      var vm = this._view;
      return isVertical(vm) ? inRange(vm, mouseX, null) : inRange(vm, null, mouseY);
    },
    inXRange: function (mouseX) {
      return inRange(this._view, mouseX, null);
    },
    inYRange: function (mouseY) {
      return inRange(this._view, null, mouseY);
    },
    getCenterPoint: function () {
      var vm = this._view;
      var x, y;

      if (isVertical(vm)) {
        x = vm.x;
        y = (vm.y + vm.base) / 2;
      } else {
        x = (vm.x + vm.base) / 2;
        y = vm.y;
      }

      return {
        x: x,
        y: y
      };
    },
    getArea: function () {
      var vm = this._view;
      return isVertical(vm) ? vm.width * Math.abs(vm.y - vm.base) : vm.height * Math.abs(vm.x - vm.base);
    },
    tooltipPosition: function () {
      var vm = this._view;
      return {
        x: vm.x,
        y: vm.y
      };
    }
  });
  var elements = {};
  var Arc = element_arc;
  var Line = element_line;
  var Point = element_point;
  var Rectangle = element_rectangle;
  elements.Arc = Arc;
  elements.Line = Line;
  elements.Point = Point;
  elements.Rectangle = Rectangle;
  var resolve$1 = helpers$1.options.resolve;

  core_defaults._set('bar', {
    hover: {
      mode: 'label'
    },
    scales: {
      xAxes: [{
        type: 'category',
        categoryPercentage: 0.8,
        barPercentage: 0.9,
        offset: true,
        gridLines: {
          offsetGridLines: true
        }
      }],
      yAxes: [{
        type: 'linear'
      }]
    }
  });
  /**
   * Computes the "optimal" sample size to maintain bars equally sized while preventing overlap.
   * @private
   */


  function computeMinSampleSize(scale, pixels) {
    var min = scale.isHorizontal() ? scale.width : scale.height;
    var ticks = scale.getTicks();
    var prev, curr, i, ilen;

    for (i = 1, ilen = pixels.length; i < ilen; ++i) {
      min = Math.min(min, Math.abs(pixels[i] - pixels[i - 1]));
    }

    for (i = 0, ilen = ticks.length; i < ilen; ++i) {
      curr = scale.getPixelForTick(i);
      min = i > 0 ? Math.min(min, curr - prev) : min;
      prev = curr;
    }

    return min;
  }
  /**
   * Computes an "ideal" category based on the absolute bar thickness or, if undefined or null,
   * uses the smallest interval (see computeMinSampleSize) that prevents bar overlapping. This
   * mode currently always generates bars equally sized (until we introduce scriptable options?).
   * @private
   */


  function computeFitCategoryTraits(index, ruler, options) {
    var thickness = options.barThickness;
    var count = ruler.stackCount;
    var curr = ruler.pixels[index];
    var size, ratio;

    if (helpers$1.isNullOrUndef(thickness)) {
      size = ruler.min * options.categoryPercentage;
      ratio = options.barPercentage;
    } else {
      // When bar thickness is enforced, category and bar percentages are ignored.
      // Note(SB): we could add support for relative bar thickness (e.g. barThickness: '50%')
      // and deprecate barPercentage since this value is ignored when thickness is absolute.
      size = thickness * count;
      ratio = 1;
    }

    return {
      chunk: size / count,
      ratio: ratio,
      start: curr - size / 2
    };
  }
  /**
   * Computes an "optimal" category that globally arranges bars side by side (no gap when
   * percentage options are 1), based on the previous and following categories. This mode
   * generates bars with different widths when data are not evenly spaced.
   * @private
   */


  function computeFlexCategoryTraits(index, ruler, options) {
    var pixels = ruler.pixels;
    var curr = pixels[index];
    var prev = index > 0 ? pixels[index - 1] : null;
    var next = index < pixels.length - 1 ? pixels[index + 1] : null;
    var percent = options.categoryPercentage;
    var start, size;

    if (prev === null) {
      // first data: its size is double based on the next point or,
      // if it's also the last data, we use the scale size.
      prev = curr - (next === null ? ruler.end - ruler.start : next - curr);
    }

    if (next === null) {
      // last data: its size is also double based on the previous point.
      next = curr + curr - prev;
    }

    start = curr - (curr - Math.min(prev, next)) / 2 * percent;
    size = Math.abs(next - prev) / 2 * percent;
    return {
      chunk: size / ruler.stackCount,
      ratio: options.barPercentage,
      start: start
    };
  }

  var controller_bar = core_datasetController.extend({
    dataElementType: elements.Rectangle,
    initialize: function () {
      var me = this;
      var meta;
      core_datasetController.prototype.initialize.apply(me, arguments);
      meta = me.getMeta();
      meta.stack = me.getDataset().stack;
      meta.bar = true;
    },
    update: function (reset) {
      var me = this;
      var rects = me.getMeta().data;
      var i, ilen;
      me._ruler = me.getRuler();

      for (i = 0, ilen = rects.length; i < ilen; ++i) {
        me.updateElement(rects[i], i, reset);
      }
    },
    updateElement: function (rectangle, index, reset) {
      var me = this;
      var meta = me.getMeta();
      var dataset = me.getDataset();

      var options = me._resolveElementOptions(rectangle, index);

      rectangle._xScale = me.getScaleForId(meta.xAxisID);
      rectangle._yScale = me.getScaleForId(meta.yAxisID);
      rectangle._datasetIndex = me.index;
      rectangle._index = index;
      rectangle._model = {
        backgroundColor: options.backgroundColor,
        borderColor: options.borderColor,
        borderSkipped: options.borderSkipped,
        borderWidth: options.borderWidth,
        datasetLabel: dataset.label,
        label: me.chart.data.labels[index]
      };

      me._updateElementGeometry(rectangle, index, reset);

      rectangle.pivot();
    },

    /**
     * @private
     */
    _updateElementGeometry: function (rectangle, index, reset) {
      var me = this;
      var model = rectangle._model;

      var vscale = me._getValueScale();

      var base = vscale.getBasePixel();
      var horizontal = vscale.isHorizontal();
      var ruler = me._ruler || me.getRuler();
      var vpixels = me.calculateBarValuePixels(me.index, index);
      var ipixels = me.calculateBarIndexPixels(me.index, index, ruler);
      model.horizontal = horizontal;
      model.base = reset ? base : vpixels.base;
      model.x = horizontal ? reset ? base : vpixels.head : ipixels.center;
      model.y = horizontal ? ipixels.center : reset ? base : vpixels.head;
      model.height = horizontal ? ipixels.size : undefined;
      model.width = horizontal ? undefined : ipixels.size;
    },

    /**
     * Returns the stacks based on groups and bar visibility.
     * @param {number} [last] - The dataset index
     * @returns {string[]} The list of stack IDs
     * @private
     */
    _getStacks: function (last) {
      var me = this;
      var chart = me.chart;

      var scale = me._getIndexScale();

      var stacked = scale.options.stacked;
      var ilen = last === undefined ? chart.data.datasets.length : last + 1;
      var stacks = [];
      var i, meta;

      for (i = 0; i < ilen; ++i) {
        meta = chart.getDatasetMeta(i);

        if (meta.bar && chart.isDatasetVisible(i) && (stacked === false || stacked === true && stacks.indexOf(meta.stack) === -1 || stacked === undefined && (meta.stack === undefined || stacks.indexOf(meta.stack) === -1))) {
          stacks.push(meta.stack);
        }
      }

      return stacks;
    },

    /**
     * Returns the effective number of stacks based on groups and bar visibility.
     * @private
     */
    getStackCount: function () {
      return this._getStacks().length;
    },

    /**
     * Returns the stack index for the given dataset based on groups and bar visibility.
     * @param {number} [datasetIndex] - The dataset index
     * @param {string} [name] - The stack name to find
     * @returns {number} The stack index
     * @private
     */
    getStackIndex: function (datasetIndex, name) {
      var stacks = this._getStacks(datasetIndex);

      var index = name !== undefined ? stacks.indexOf(name) : -1; // indexOf returns -1 if element is not present

      return index === -1 ? stacks.length - 1 : index;
    },

    /**
     * @private
     */
    getRuler: function () {
      var me = this;

      var scale = me._getIndexScale();

      var stackCount = me.getStackCount();
      var datasetIndex = me.index;
      var isHorizontal = scale.isHorizontal();
      var start = isHorizontal ? scale.left : scale.top;
      var end = start + (isHorizontal ? scale.width : scale.height);
      var pixels = [];
      var i, ilen, min;

      for (i = 0, ilen = me.getMeta().data.length; i < ilen; ++i) {
        pixels.push(scale.getPixelForValue(null, i, datasetIndex));
      }

      min = helpers$1.isNullOrUndef(scale.options.barThickness) ? computeMinSampleSize(scale, pixels) : -1;
      return {
        min: min,
        pixels: pixels,
        start: start,
        end: end,
        stackCount: stackCount,
        scale: scale
      };
    },

    /**
     * Note: pixel values are not clamped to the scale area.
     * @private
     */
    calculateBarValuePixels: function (datasetIndex, index) {
      var me = this;
      var chart = me.chart;
      var meta = me.getMeta();

      var scale = me._getValueScale();

      var isHorizontal = scale.isHorizontal();
      var datasets = chart.data.datasets;
      var value = +scale.getRightValue(datasets[datasetIndex].data[index]);
      var minBarLength = scale.options.minBarLength;
      var stacked = scale.options.stacked;
      var stack = meta.stack;
      var start = 0;
      var i, imeta, ivalue, base, head, size;

      if (stacked || stacked === undefined && stack !== undefined) {
        for (i = 0; i < datasetIndex; ++i) {
          imeta = chart.getDatasetMeta(i);

          if (imeta.bar && imeta.stack === stack && imeta.controller._getValueScaleId() === scale.id && chart.isDatasetVisible(i)) {
            ivalue = +scale.getRightValue(datasets[i].data[index]);

            if (value < 0 && ivalue < 0 || value >= 0 && ivalue > 0) {
              start += ivalue;
            }
          }
        }
      }

      base = scale.getPixelForValue(start);
      head = scale.getPixelForValue(start + value);
      size = head - base;

      if (minBarLength !== undefined && Math.abs(size) < minBarLength) {
        size = minBarLength;

        if (value >= 0 && !isHorizontal || value < 0 && isHorizontal) {
          head = base - minBarLength;
        } else {
          head = base + minBarLength;
        }
      }

      return {
        size: size,
        base: base,
        head: head,
        center: head + size / 2
      };
    },

    /**
     * @private
     */
    calculateBarIndexPixels: function (datasetIndex, index, ruler) {
      var me = this;
      var options = ruler.scale.options;
      var range = options.barThickness === 'flex' ? computeFlexCategoryTraits(index, ruler, options) : computeFitCategoryTraits(index, ruler, options);
      var stackIndex = me.getStackIndex(datasetIndex, me.getMeta().stack);
      var center = range.start + range.chunk * stackIndex + range.chunk / 2;
      var size = Math.min(helpers$1.valueOrDefault(options.maxBarThickness, Infinity), range.chunk * range.ratio);
      return {
        base: center - size / 2,
        head: center + size / 2,
        center: center,
        size: size
      };
    },
    draw: function () {
      var me = this;
      var chart = me.chart;

      var scale = me._getValueScale();

      var rects = me.getMeta().data;
      var dataset = me.getDataset();
      var ilen = rects.length;
      var i = 0;
      helpers$1.canvas.clipArea(chart.ctx, chart.chartArea);

      for (; i < ilen; ++i) {
        if (!isNaN(scale.getRightValue(dataset.data[i]))) {
          rects[i].draw();
        }
      }

      helpers$1.canvas.unclipArea(chart.ctx);
    },

    /**
     * @private
     */
    _resolveElementOptions: function (rectangle, index) {
      var me = this;
      var chart = me.chart;
      var datasets = chart.data.datasets;
      var dataset = datasets[me.index];
      var custom = rectangle.custom || {};
      var options = chart.options.elements.rectangle;
      var values = {};
      var i, ilen, key; // Scriptable options

      var context = {
        chart: chart,
        dataIndex: index,
        dataset: dataset,
        datasetIndex: me.index
      };
      var keys = ['backgroundColor', 'borderColor', 'borderSkipped', 'borderWidth'];

      for (i = 0, ilen = keys.length; i < ilen; ++i) {
        key = keys[i];
        values[key] = resolve$1([custom[key], dataset[key], options[key]], context, index);
      }

      return values;
    }
  });
  var valueOrDefault$3 = helpers$1.valueOrDefault;
  var resolve$2 = helpers$1.options.resolve;

  core_defaults._set('bubble', {
    hover: {
      mode: 'single'
    },
    scales: {
      xAxes: [{
        type: 'linear',
        // bubble should probably use a linear scale by default
        position: 'bottom',
        id: 'x-axis-0' // need an ID so datasets can reference the scale

      }],
      yAxes: [{
        type: 'linear',
        position: 'left',
        id: 'y-axis-0'
      }]
    },
    tooltips: {
      callbacks: {
        title: function () {
          // Title doesn't make sense for scatter since we format the data as a point
          return '';
        },
        label: function (item, data) {
          var datasetLabel = data.datasets[item.datasetIndex].label || '';
          var dataPoint = data.datasets[item.datasetIndex].data[item.index];
          return datasetLabel + ': (' + item.xLabel + ', ' + item.yLabel + ', ' + dataPoint.r + ')';
        }
      }
    }
  });

  var controller_bubble = core_datasetController.extend({
    /**
     * @protected
     */
    dataElementType: elements.Point,

    /**
     * @protected
     */
    update: function (reset) {
      var me = this;
      var meta = me.getMeta();
      var points = meta.data; // Update Points

      helpers$1.each(points, function (point, index) {
        me.updateElement(point, index, reset);
      });
    },

    /**
     * @protected
     */
    updateElement: function (point, index, reset) {
      var me = this;
      var meta = me.getMeta();
      var custom = point.custom || {};
      var xScale = me.getScaleForId(meta.xAxisID);
      var yScale = me.getScaleForId(meta.yAxisID);

      var options = me._resolveElementOptions(point, index);

      var data = me.getDataset().data[index];
      var dsIndex = me.index;
      var x = reset ? xScale.getPixelForDecimal(0.5) : xScale.getPixelForValue(typeof data === 'object' ? data : NaN, index, dsIndex);
      var y = reset ? yScale.getBasePixel() : yScale.getPixelForValue(data, index, dsIndex);
      point._xScale = xScale;
      point._yScale = yScale;
      point._options = options;
      point._datasetIndex = dsIndex;
      point._index = index;
      point._model = {
        backgroundColor: options.backgroundColor,
        borderColor: options.borderColor,
        borderWidth: options.borderWidth,
        hitRadius: options.hitRadius,
        pointStyle: options.pointStyle,
        rotation: options.rotation,
        radius: reset ? 0 : options.radius,
        skip: custom.skip || isNaN(x) || isNaN(y),
        x: x,
        y: y
      };
      point.pivot();
    },

    /**
     * @protected
     */
    setHoverStyle: function (point) {
      var model = point._model;
      var options = point._options;
      var getHoverColor = helpers$1.getHoverColor;
      point.$previousStyle = {
        backgroundColor: model.backgroundColor,
        borderColor: model.borderColor,
        borderWidth: model.borderWidth,
        radius: model.radius
      };
      model.backgroundColor = valueOrDefault$3(options.hoverBackgroundColor, getHoverColor(options.backgroundColor));
      model.borderColor = valueOrDefault$3(options.hoverBorderColor, getHoverColor(options.borderColor));
      model.borderWidth = valueOrDefault$3(options.hoverBorderWidth, options.borderWidth);
      model.radius = options.radius + options.hoverRadius;
    },

    /**
     * @private
     */
    _resolveElementOptions: function (point, index) {
      var me = this;
      var chart = me.chart;
      var datasets = chart.data.datasets;
      var dataset = datasets[me.index];
      var custom = point.custom || {};
      var options = chart.options.elements.point;
      var data = dataset.data[index];
      var values = {};
      var i, ilen, key; // Scriptable options

      var context = {
        chart: chart,
        dataIndex: index,
        dataset: dataset,
        datasetIndex: me.index
      };
      var keys = ['backgroundColor', 'borderColor', 'borderWidth', 'hoverBackgroundColor', 'hoverBorderColor', 'hoverBorderWidth', 'hoverRadius', 'hitRadius', 'pointStyle', 'rotation'];

      for (i = 0, ilen = keys.length; i < ilen; ++i) {
        key = keys[i];
        values[key] = resolve$2([custom[key], dataset[key], options[key]], context, index);
      } // Custom radius resolution


      values.radius = resolve$2([custom.radius, data ? data.r : undefined, dataset.radius, options.radius], context, index);
      return values;
    }
  });
  var resolve$3 = helpers$1.options.resolve;
  var valueOrDefault$4 = helpers$1.valueOrDefault;

  core_defaults._set('doughnut', {
    animation: {
      // Boolean - Whether we animate the rotation of the Doughnut
      animateRotate: true,
      // Boolean - Whether we animate scaling the Doughnut from the centre
      animateScale: false
    },
    hover: {
      mode: 'single'
    },
    legendCallback: function (chart) {
      var text = [];
      text.push('<ul class="' + chart.id + '-legend">');
      var data = chart.data;
      var datasets = data.datasets;
      var labels = data.labels;

      if (datasets.length) {
        for (var i = 0; i < datasets[0].data.length; ++i) {
          text.push('<li><span style="background-color:' + datasets[0].backgroundColor[i] + '"></span>');

          if (labels[i]) {
            text.push(labels[i]);
          }

          text.push('</li>');
        }
      }

      text.push('</ul>');
      return text.join('');
    },
    legend: {
      labels: {
        generateLabels: function (chart) {
          var data = chart.data;

          if (data.labels.length && data.datasets.length) {
            return data.labels.map(function (label, i) {
              var meta = chart.getDatasetMeta(0);
              var ds = data.datasets[0];
              var arc = meta.data[i];
              var custom = arc && arc.custom || {};
              var arcOpts = chart.options.elements.arc;
              var fill = resolve$3([custom.backgroundColor, ds.backgroundColor, arcOpts.backgroundColor], undefined, i);
              var stroke = resolve$3([custom.borderColor, ds.borderColor, arcOpts.borderColor], undefined, i);
              var bw = resolve$3([custom.borderWidth, ds.borderWidth, arcOpts.borderWidth], undefined, i);
              return {
                text: label,
                fillStyle: fill,
                strokeStyle: stroke,
                lineWidth: bw,
                hidden: isNaN(ds.data[i]) || meta.data[i].hidden,
                // Extra data used for toggling the correct item
                index: i
              };
            });
          }

          return [];
        }
      },
      onClick: function (e, legendItem) {
        var index = legendItem.index;
        var chart = this.chart;
        var i, ilen, meta;

        for (i = 0, ilen = (chart.data.datasets || []).length; i < ilen; ++i) {
          meta = chart.getDatasetMeta(i); // toggle visibility of index if exists

          if (meta.data[index]) {
            meta.data[index].hidden = !meta.data[index].hidden;
          }
        }

        chart.update();
      }
    },
    // The percentage of the chart that we cut out of the middle.
    cutoutPercentage: 50,
    // The rotation of the chart, where the first data arc begins.
    rotation: Math.PI * -0.5,
    // The total circumference of the chart.
    circumference: Math.PI * 2.0,
    // Need to override these to give a nice default
    tooltips: {
      callbacks: {
        title: function () {
          return '';
        },
        label: function (tooltipItem, data) {
          var dataLabel = data.labels[tooltipItem.index];
          var value = ': ' + data.datasets[tooltipItem.datasetIndex].data[tooltipItem.index];

          if (helpers$1.isArray(dataLabel)) {
            // show value on first line of multiline label
            // need to clone because we are changing the value
            dataLabel = dataLabel.slice();
            dataLabel[0] += value;
          } else {
            dataLabel += value;
          }

          return dataLabel;
        }
      }
    }
  });

  var controller_doughnut = core_datasetController.extend({
    dataElementType: elements.Arc,
    linkScales: helpers$1.noop,
    // Get index of the dataset in relation to the visible datasets. This allows determining the inner and outer radius correctly
    getRingIndex: function (datasetIndex) {
      var ringIndex = 0;

      for (var j = 0; j < datasetIndex; ++j) {
        if (this.chart.isDatasetVisible(j)) {
          ++ringIndex;
        }
      }

      return ringIndex;
    },
    update: function (reset) {
      var me = this;
      var chart = me.chart;
      var chartArea = chart.chartArea;
      var opts = chart.options;
      var availableWidth = chartArea.right - chartArea.left;
      var availableHeight = chartArea.bottom - chartArea.top;
      var minSize = Math.min(availableWidth, availableHeight);
      var offset = {
        x: 0,
        y: 0
      };
      var meta = me.getMeta();
      var arcs = meta.data;
      var cutoutPercentage = opts.cutoutPercentage;
      var circumference = opts.circumference;

      var chartWeight = me._getRingWeight(me.index);

      var i, ilen; // If the chart's circumference isn't a full circle, calculate minSize as a ratio of the width/height of the arc

      if (circumference < Math.PI * 2.0) {
        var startAngle = opts.rotation % (Math.PI * 2.0);
        startAngle += Math.PI * 2.0 * (startAngle >= Math.PI ? -1 : startAngle < -Math.PI ? 1 : 0);
        var endAngle = startAngle + circumference;
        var start = {
          x: Math.cos(startAngle),
          y: Math.sin(startAngle)
        };
        var end = {
          x: Math.cos(endAngle),
          y: Math.sin(endAngle)
        };
        var contains0 = startAngle <= 0 && endAngle >= 0 || startAngle <= Math.PI * 2.0 && Math.PI * 2.0 <= endAngle;
        var contains90 = startAngle <= Math.PI * 0.5 && Math.PI * 0.5 <= endAngle || startAngle <= Math.PI * 2.5 && Math.PI * 2.5 <= endAngle;
        var contains180 = startAngle <= -Math.PI && -Math.PI <= endAngle || startAngle <= Math.PI && Math.PI <= endAngle;
        var contains270 = startAngle <= -Math.PI * 0.5 && -Math.PI * 0.5 <= endAngle || startAngle <= Math.PI * 1.5 && Math.PI * 1.5 <= endAngle;
        var cutout = cutoutPercentage / 100.0;
        var min = {
          x: contains180 ? -1 : Math.min(start.x * (start.x < 0 ? 1 : cutout), end.x * (end.x < 0 ? 1 : cutout)),
          y: contains270 ? -1 : Math.min(start.y * (start.y < 0 ? 1 : cutout), end.y * (end.y < 0 ? 1 : cutout))
        };
        var max = {
          x: contains0 ? 1 : Math.max(start.x * (start.x > 0 ? 1 : cutout), end.x * (end.x > 0 ? 1 : cutout)),
          y: contains90 ? 1 : Math.max(start.y * (start.y > 0 ? 1 : cutout), end.y * (end.y > 0 ? 1 : cutout))
        };
        var size = {
          width: (max.x - min.x) * 0.5,
          height: (max.y - min.y) * 0.5
        };
        minSize = Math.min(availableWidth / size.width, availableHeight / size.height);
        offset = {
          x: (max.x + min.x) * -0.5,
          y: (max.y + min.y) * -0.5
        };
      }

      for (i = 0, ilen = arcs.length; i < ilen; ++i) {
        arcs[i]._options = me._resolveElementOptions(arcs[i], i);
      }

      chart.borderWidth = me.getMaxBorderWidth();
      chart.outerRadius = Math.max((minSize - chart.borderWidth) / 2, 0);
      chart.innerRadius = Math.max(cutoutPercentage ? chart.outerRadius / 100 * cutoutPercentage : 0, 0);
      chart.radiusLength = (chart.outerRadius - chart.innerRadius) / (me._getVisibleDatasetWeightTotal() || 1);
      chart.offsetX = offset.x * chart.outerRadius;
      chart.offsetY = offset.y * chart.outerRadius;
      meta.total = me.calculateTotal();
      me.outerRadius = chart.outerRadius - chart.radiusLength * me._getRingWeightOffset(me.index);
      me.innerRadius = Math.max(me.outerRadius - chart.radiusLength * chartWeight, 0);

      for (i = 0, ilen = arcs.length; i < ilen; ++i) {
        me.updateElement(arcs[i], i, reset);
      }
    },
    updateElement: function (arc, index, reset) {
      var me = this;
      var chart = me.chart;
      var chartArea = chart.chartArea;
      var opts = chart.options;
      var animationOpts = opts.animation;
      var centerX = (chartArea.left + chartArea.right) / 2;
      var centerY = (chartArea.top + chartArea.bottom) / 2;
      var startAngle = opts.rotation; // non reset case handled later

      var endAngle = opts.rotation; // non reset case handled later

      var dataset = me.getDataset();
      var circumference = reset && animationOpts.animateRotate ? 0 : arc.hidden ? 0 : me.calculateCircumference(dataset.data[index]) * (opts.circumference / (2.0 * Math.PI));
      var innerRadius = reset && animationOpts.animateScale ? 0 : me.innerRadius;
      var outerRadius = reset && animationOpts.animateScale ? 0 : me.outerRadius;
      var options = arc._options || {};
      helpers$1.extend(arc, {
        // Utility
        _datasetIndex: me.index,
        _index: index,
        // Desired view properties
        _model: {
          backgroundColor: options.backgroundColor,
          borderColor: options.borderColor,
          borderWidth: options.borderWidth,
          borderAlign: options.borderAlign,
          x: centerX + chart.offsetX,
          y: centerY + chart.offsetY,
          startAngle: startAngle,
          endAngle: endAngle,
          circumference: circumference,
          outerRadius: outerRadius,
          innerRadius: innerRadius,
          label: helpers$1.valueAtIndexOrDefault(dataset.label, index, chart.data.labels[index])
        }
      });
      var model = arc._model; // Set correct angles if not resetting

      if (!reset || !animationOpts.animateRotate) {
        if (index === 0) {
          model.startAngle = opts.rotation;
        } else {
          model.startAngle = me.getMeta().data[index - 1]._model.endAngle;
        }

        model.endAngle = model.startAngle + model.circumference;
      }

      arc.pivot();
    },
    calculateTotal: function () {
      var dataset = this.getDataset();
      var meta = this.getMeta();
      var total = 0;
      var value;
      helpers$1.each(meta.data, function (element, index) {
        value = dataset.data[index];

        if (!isNaN(value) && !element.hidden) {
          total += Math.abs(value);
        }
      });
      /* if (total === 0) {
      	total = NaN;
      }*/

      return total;
    },
    calculateCircumference: function (value) {
      var total = this.getMeta().total;

      if (total > 0 && !isNaN(value)) {
        return Math.PI * 2.0 * (Math.abs(value) / total);
      }

      return 0;
    },
    // gets the max border or hover width to properly scale pie charts
    getMaxBorderWidth: function (arcs) {
      var me = this;
      var max = 0;
      var chart = me.chart;
      var i, ilen, meta, arc, controller, options, borderWidth, hoverWidth;

      if (!arcs) {
        // Find the outmost visible dataset
        for (i = 0, ilen = chart.data.datasets.length; i < ilen; ++i) {
          if (chart.isDatasetVisible(i)) {
            meta = chart.getDatasetMeta(i);
            arcs = meta.data;

            if (i !== me.index) {
              controller = meta.controller;
            }

            break;
          }
        }
      }

      if (!arcs) {
        return 0;
      }

      for (i = 0, ilen = arcs.length; i < ilen; ++i) {
        arc = arcs[i];
        options = controller ? controller._resolveElementOptions(arc, i) : arc._options;

        if (options.borderAlign !== 'inner') {
          borderWidth = options.borderWidth;
          hoverWidth = options.hoverBorderWidth;
          max = borderWidth > max ? borderWidth : max;
          max = hoverWidth > max ? hoverWidth : max;
        }
      }

      return max;
    },

    /**
     * @protected
     */
    setHoverStyle: function (arc) {
      var model = arc._model;
      var options = arc._options;
      var getHoverColor = helpers$1.getHoverColor;
      arc.$previousStyle = {
        backgroundColor: model.backgroundColor,
        borderColor: model.borderColor,
        borderWidth: model.borderWidth
      };
      model.backgroundColor = valueOrDefault$4(options.hoverBackgroundColor, getHoverColor(options.backgroundColor));
      model.borderColor = valueOrDefault$4(options.hoverBorderColor, getHoverColor(options.borderColor));
      model.borderWidth = valueOrDefault$4(options.hoverBorderWidth, options.borderWidth);
    },

    /**
     * @private
     */
    _resolveElementOptions: function (arc, index) {
      var me = this;
      var chart = me.chart;
      var dataset = me.getDataset();
      var custom = arc.custom || {};
      var options = chart.options.elements.arc;
      var values = {};
      var i, ilen, key; // Scriptable options

      var context = {
        chart: chart,
        dataIndex: index,
        dataset: dataset,
        datasetIndex: me.index
      };
      var keys = ['backgroundColor', 'borderColor', 'borderWidth', 'borderAlign', 'hoverBackgroundColor', 'hoverBorderColor', 'hoverBorderWidth'];

      for (i = 0, ilen = keys.length; i < ilen; ++i) {
        key = keys[i];
        values[key] = resolve$3([custom[key], dataset[key], options[key]], context, index);
      }

      return values;
    },

    /**
     * Get radius length offset of the dataset in relation to the visible datasets weights. This allows determining the inner and outer radius correctly
     * @private
     */
    _getRingWeightOffset: function (datasetIndex) {
      var ringWeightOffset = 0;

      for (var i = 0; i < datasetIndex; ++i) {
        if (this.chart.isDatasetVisible(i)) {
          ringWeightOffset += this._getRingWeight(i);
        }
      }

      return ringWeightOffset;
    },

    /**
     * @private
     */
    _getRingWeight: function (dataSetIndex) {
      return Math.max(valueOrDefault$4(this.chart.data.datasets[dataSetIndex].weight, 1), 0);
    },

    /**
     * Returns the sum of all visibile data set weights.  This value can be 0.
     * @private
     */
    _getVisibleDatasetWeightTotal: function () {
      return this._getRingWeightOffset(this.chart.data.datasets.length);
    }
  });

  core_defaults._set('horizontalBar', {
    hover: {
      mode: 'index',
      axis: 'y'
    },
    scales: {
      xAxes: [{
        type: 'linear',
        position: 'bottom'
      }],
      yAxes: [{
        type: 'category',
        position: 'left',
        categoryPercentage: 0.8,
        barPercentage: 0.9,
        offset: true,
        gridLines: {
          offsetGridLines: true
        }
      }]
    },
    elements: {
      rectangle: {
        borderSkipped: 'left'
      }
    },
    tooltips: {
      mode: 'index',
      axis: 'y'
    }
  });

  var controller_horizontalBar = controller_bar.extend({
    /**
     * @private
     */
    _getValueScaleId: function () {
      return this.getMeta().xAxisID;
    },

    /**
     * @private
     */
    _getIndexScaleId: function () {
      return this.getMeta().yAxisID;
    }
  });
  var valueOrDefault$5 = helpers$1.valueOrDefault;
  var resolve$4 = helpers$1.options.resolve;
  var isPointInArea = helpers$1.canvas._isPointInArea;

  core_defaults._set('line', {
    showLines: true,
    spanGaps: false,
    hover: {
      mode: 'label'
    },
    scales: {
      xAxes: [{
        type: 'category',
        id: 'x-axis-0'
      }],
      yAxes: [{
        type: 'linear',
        id: 'y-axis-0'
      }]
    }
  });

  function lineEnabled(dataset, options) {
    return valueOrDefault$5(dataset.showLine, options.showLines);
  }

  var controller_line = core_datasetController.extend({
    datasetElementType: elements.Line,
    dataElementType: elements.Point,
    update: function (reset) {
      var me = this;
      var meta = me.getMeta();
      var line = meta.dataset;
      var points = meta.data || [];
      var scale = me.getScaleForId(meta.yAxisID);
      var dataset = me.getDataset();
      var showLine = lineEnabled(dataset, me.chart.options);
      var i, ilen; // Update Line

      if (showLine) {
        // Compatibility: If the properties are defined with only the old name, use those values
        if (dataset.tension !== undefined && dataset.lineTension === undefined) {
          dataset.lineTension = dataset.tension;
        } // Utility


        line._scale = scale;
        line._datasetIndex = me.index; // Data

        line._children = points; // Model

        line._model = me._resolveLineOptions(line);
        line.pivot();
      } // Update Points


      for (i = 0, ilen = points.length; i < ilen; ++i) {
        me.updateElement(points[i], i, reset);
      }

      if (showLine && line._model.tension !== 0) {
        me.updateBezierControlPoints();
      } // Now pivot the point for animation


      for (i = 0, ilen = points.length; i < ilen; ++i) {
        points[i].pivot();
      }
    },
    updateElement: function (point, index, reset) {
      var me = this;
      var meta = me.getMeta();
      var custom = point.custom || {};
      var dataset = me.getDataset();
      var datasetIndex = me.index;
      var value = dataset.data[index];
      var yScale = me.getScaleForId(meta.yAxisID);
      var xScale = me.getScaleForId(meta.xAxisID);
      var lineModel = meta.dataset._model;
      var x, y;

      var options = me._resolvePointOptions(point, index);

      x = xScale.getPixelForValue(typeof value === 'object' ? value : NaN, index, datasetIndex);
      y = reset ? yScale.getBasePixel() : me.calculatePointY(value, index, datasetIndex); // Utility

      point._xScale = xScale;
      point._yScale = yScale;
      point._options = options;
      point._datasetIndex = datasetIndex;
      point._index = index; // Desired view properties

      point._model = {
        x: x,
        y: y,
        skip: custom.skip || isNaN(x) || isNaN(y),
        // Appearance
        radius: options.radius,
        pointStyle: options.pointStyle,
        rotation: options.rotation,
        backgroundColor: options.backgroundColor,
        borderColor: options.borderColor,
        borderWidth: options.borderWidth,
        tension: valueOrDefault$5(custom.tension, lineModel ? lineModel.tension : 0),
        steppedLine: lineModel ? lineModel.steppedLine : false,
        // Tooltip
        hitRadius: options.hitRadius
      };
    },

    /**
     * @private
     */
    _resolvePointOptions: function (element, index) {
      var me = this;
      var chart = me.chart;
      var dataset = chart.data.datasets[me.index];
      var custom = element.custom || {};
      var options = chart.options.elements.point;
      var values = {};
      var i, ilen, key; // Scriptable options

      var context = {
        chart: chart,
        dataIndex: index,
        dataset: dataset,
        datasetIndex: me.index
      };
      var ELEMENT_OPTIONS = {
        backgroundColor: 'pointBackgroundColor',
        borderColor: 'pointBorderColor',
        borderWidth: 'pointBorderWidth',
        hitRadius: 'pointHitRadius',
        hoverBackgroundColor: 'pointHoverBackgroundColor',
        hoverBorderColor: 'pointHoverBorderColor',
        hoverBorderWidth: 'pointHoverBorderWidth',
        hoverRadius: 'pointHoverRadius',
        pointStyle: 'pointStyle',
        radius: 'pointRadius',
        rotation: 'pointRotation'
      };
      var keys = Object.keys(ELEMENT_OPTIONS);

      for (i = 0, ilen = keys.length; i < ilen; ++i) {
        key = keys[i];
        values[key] = resolve$4([custom[key], dataset[ELEMENT_OPTIONS[key]], dataset[key], options[key]], context, index);
      }

      return values;
    },

    /**
     * @private
     */
    _resolveLineOptions: function (element) {
      var me = this;
      var chart = me.chart;
      var dataset = chart.data.datasets[me.index];
      var custom = element.custom || {};
      var options = chart.options;
      var elementOptions = options.elements.line;
      var values = {};
      var i, ilen, key;
      var keys = ['backgroundColor', 'borderWidth', 'borderColor', 'borderCapStyle', 'borderDash', 'borderDashOffset', 'borderJoinStyle', 'fill', 'cubicInterpolationMode'];

      for (i = 0, ilen = keys.length; i < ilen; ++i) {
        key = keys[i];
        values[key] = resolve$4([custom[key], dataset[key], elementOptions[key]]);
      } // The default behavior of lines is to break at null values, according
      // to https://github.com/chartjs/Chart.js/issues/2435#issuecomment-216718158
      // This option gives lines the ability to span gaps


      values.spanGaps = valueOrDefault$5(dataset.spanGaps, options.spanGaps);
      values.tension = valueOrDefault$5(dataset.lineTension, elementOptions.tension);
      values.steppedLine = resolve$4([custom.steppedLine, dataset.steppedLine, elementOptions.stepped]);
      return values;
    },
    calculatePointY: function (value, index, datasetIndex) {
      var me = this;
      var chart = me.chart;
      var meta = me.getMeta();
      var yScale = me.getScaleForId(meta.yAxisID);
      var sumPos = 0;
      var sumNeg = 0;
      var i, ds, dsMeta;

      if (yScale.options.stacked) {
        for (i = 0; i < datasetIndex; i++) {
          ds = chart.data.datasets[i];
          dsMeta = chart.getDatasetMeta(i);

          if (dsMeta.type === 'line' && dsMeta.yAxisID === yScale.id && chart.isDatasetVisible(i)) {
            var stackedRightValue = Number(yScale.getRightValue(ds.data[index]));

            if (stackedRightValue < 0) {
              sumNeg += stackedRightValue || 0;
            } else {
              sumPos += stackedRightValue || 0;
            }
          }
        }

        var rightValue = Number(yScale.getRightValue(value));

        if (rightValue < 0) {
          return yScale.getPixelForValue(sumNeg + rightValue);
        }

        return yScale.getPixelForValue(sumPos + rightValue);
      }

      return yScale.getPixelForValue(value);
    },
    updateBezierControlPoints: function () {
      var me = this;
      var chart = me.chart;
      var meta = me.getMeta();
      var lineModel = meta.dataset._model;
      var area = chart.chartArea;
      var points = meta.data || [];
      var i, ilen, model, controlPoints; // Only consider points that are drawn in case the spanGaps option is used

      if (lineModel.spanGaps) {
        points = points.filter(function (pt) {
          return !pt._model.skip;
        });
      }

      function capControlPoint(pt, min, max) {
        return Math.max(Math.min(pt, max), min);
      }

      if (lineModel.cubicInterpolationMode === 'monotone') {
        helpers$1.splineCurveMonotone(points);
      } else {
        for (i = 0, ilen = points.length; i < ilen; ++i) {
          model = points[i]._model;
          controlPoints = helpers$1.splineCurve(helpers$1.previousItem(points, i)._model, model, helpers$1.nextItem(points, i)._model, lineModel.tension);
          model.controlPointPreviousX = controlPoints.previous.x;
          model.controlPointPreviousY = controlPoints.previous.y;
          model.controlPointNextX = controlPoints.next.x;
          model.controlPointNextY = controlPoints.next.y;
        }
      }

      if (chart.options.elements.line.capBezierPoints) {
        for (i = 0, ilen = points.length; i < ilen; ++i) {
          model = points[i]._model;

          if (isPointInArea(model, area)) {
            if (i > 0 && isPointInArea(points[i - 1]._model, area)) {
              model.controlPointPreviousX = capControlPoint(model.controlPointPreviousX, area.left, area.right);
              model.controlPointPreviousY = capControlPoint(model.controlPointPreviousY, area.top, area.bottom);
            }

            if (i < points.length - 1 && isPointInArea(points[i + 1]._model, area)) {
              model.controlPointNextX = capControlPoint(model.controlPointNextX, area.left, area.right);
              model.controlPointNextY = capControlPoint(model.controlPointNextY, area.top, area.bottom);
            }
          }
        }
      }
    },
    draw: function () {
      var me = this;
      var chart = me.chart;
      var meta = me.getMeta();
      var points = meta.data || [];
      var area = chart.chartArea;
      var ilen = points.length;
      var halfBorderWidth;
      var i = 0;

      if (lineEnabled(me.getDataset(), chart.options)) {
        halfBorderWidth = (meta.dataset._model.borderWidth || 0) / 2;
        helpers$1.canvas.clipArea(chart.ctx, {
          left: area.left,
          right: area.right,
          top: area.top - halfBorderWidth,
          bottom: area.bottom + halfBorderWidth
        });
        meta.dataset.draw();
        helpers$1.canvas.unclipArea(chart.ctx);
      } // Draw the points


      for (; i < ilen; ++i) {
        points[i].draw(area);
      }
    },

    /**
     * @protected
     */
    setHoverStyle: function (point) {
      var model = point._model;
      var options = point._options;
      var getHoverColor = helpers$1.getHoverColor;
      point.$previousStyle = {
        backgroundColor: model.backgroundColor,
        borderColor: model.borderColor,
        borderWidth: model.borderWidth,
        radius: model.radius
      };
      model.backgroundColor = valueOrDefault$5(options.hoverBackgroundColor, getHoverColor(options.backgroundColor));
      model.borderColor = valueOrDefault$5(options.hoverBorderColor, getHoverColor(options.borderColor));
      model.borderWidth = valueOrDefault$5(options.hoverBorderWidth, options.borderWidth);
      model.radius = valueOrDefault$5(options.hoverRadius, options.radius);
    }
  });
  var resolve$5 = helpers$1.options.resolve;

  core_defaults._set('polarArea', {
    scale: {
      type: 'radialLinear',
      angleLines: {
        display: false
      },
      gridLines: {
        circular: true
      },
      pointLabels: {
        display: false
      },
      ticks: {
        beginAtZero: true
      }
    },
    // Boolean - Whether to animate the rotation of the chart
    animation: {
      animateRotate: true,
      animateScale: true
    },
    startAngle: -0.5 * Math.PI,
    legendCallback: function (chart) {
      var text = [];
      text.push('<ul class="' + chart.id + '-legend">');
      var data = chart.data;
      var datasets = data.datasets;
      var labels = data.labels;

      if (datasets.length) {
        for (var i = 0; i < datasets[0].data.length; ++i) {
          text.push('<li><span style="background-color:' + datasets[0].backgroundColor[i] + '"></span>');

          if (labels[i]) {
            text.push(labels[i]);
          }

          text.push('</li>');
        }
      }

      text.push('</ul>');
      return text.join('');
    },
    legend: {
      labels: {
        generateLabels: function (chart) {
          var data = chart.data;

          if (data.labels.length && data.datasets.length) {
            return data.labels.map(function (label, i) {
              var meta = chart.getDatasetMeta(0);
              var ds = data.datasets[0];
              var arc = meta.data[i];
              var custom = arc.custom || {};
              var arcOpts = chart.options.elements.arc;
              var fill = resolve$5([custom.backgroundColor, ds.backgroundColor, arcOpts.backgroundColor], undefined, i);
              var stroke = resolve$5([custom.borderColor, ds.borderColor, arcOpts.borderColor], undefined, i);
              var bw = resolve$5([custom.borderWidth, ds.borderWidth, arcOpts.borderWidth], undefined, i);
              return {
                text: label,
                fillStyle: fill,
                strokeStyle: stroke,
                lineWidth: bw,
                hidden: isNaN(ds.data[i]) || meta.data[i].hidden,
                // Extra data used for toggling the correct item
                index: i
              };
            });
          }

          return [];
        }
      },
      onClick: function (e, legendItem) {
        var index = legendItem.index;
        var chart = this.chart;
        var i, ilen, meta;

        for (i = 0, ilen = (chart.data.datasets || []).length; i < ilen; ++i) {
          meta = chart.getDatasetMeta(i);
          meta.data[index].hidden = !meta.data[index].hidden;
        }

        chart.update();
      }
    },
    // Need to override these to give a nice default
    tooltips: {
      callbacks: {
        title: function () {
          return '';
        },
        label: function (item, data) {
          return data.labels[item.index] + ': ' + item.yLabel;
        }
      }
    }
  });

  var controller_polarArea = core_datasetController.extend({
    dataElementType: elements.Arc,
    linkScales: helpers$1.noop,
    update: function (reset) {
      var me = this;
      var dataset = me.getDataset();
      var meta = me.getMeta();
      var start = me.chart.options.startAngle || 0;
      var starts = me._starts = [];
      var angles = me._angles = [];
      var arcs = meta.data;
      var i, ilen, angle;

      me._updateRadius();

      meta.count = me.countVisibleElements();

      for (i = 0, ilen = dataset.data.length; i < ilen; i++) {
        starts[i] = start;
        angle = me._computeAngle(i);
        angles[i] = angle;
        start += angle;
      }

      for (i = 0, ilen = arcs.length; i < ilen; ++i) {
        arcs[i]._options = me._resolveElementOptions(arcs[i], i);
        me.updateElement(arcs[i], i, reset);
      }
    },

    /**
     * @private
     */
    _updateRadius: function () {
      var me = this;
      var chart = me.chart;
      var chartArea = chart.chartArea;
      var opts = chart.options;
      var minSize = Math.min(chartArea.right - chartArea.left, chartArea.bottom - chartArea.top);
      chart.outerRadius = Math.max(minSize / 2, 0);
      chart.innerRadius = Math.max(opts.cutoutPercentage ? chart.outerRadius / 100 * opts.cutoutPercentage : 1, 0);
      chart.radiusLength = (chart.outerRadius - chart.innerRadius) / chart.getVisibleDatasetCount();
      me.outerRadius = chart.outerRadius - chart.radiusLength * me.index;
      me.innerRadius = me.outerRadius - chart.radiusLength;
    },
    updateElement: function (arc, index, reset) {
      var me = this;
      var chart = me.chart;
      var dataset = me.getDataset();
      var opts = chart.options;
      var animationOpts = opts.animation;
      var scale = chart.scale;
      var labels = chart.data.labels;
      var centerX = scale.xCenter;
      var centerY = scale.yCenter; // var negHalfPI = -0.5 * Math.PI;

      var datasetStartAngle = opts.startAngle;
      var distance = arc.hidden ? 0 : scale.getDistanceFromCenterForValue(dataset.data[index]);
      var startAngle = me._starts[index];
      var endAngle = startAngle + (arc.hidden ? 0 : me._angles[index]);
      var resetRadius = animationOpts.animateScale ? 0 : scale.getDistanceFromCenterForValue(dataset.data[index]);
      var options = arc._options || {};
      helpers$1.extend(arc, {
        // Utility
        _datasetIndex: me.index,
        _index: index,
        _scale: scale,
        // Desired view properties
        _model: {
          backgroundColor: options.backgroundColor,
          borderColor: options.borderColor,
          borderWidth: options.borderWidth,
          borderAlign: options.borderAlign,
          x: centerX,
          y: centerY,
          innerRadius: 0,
          outerRadius: reset ? resetRadius : distance,
          startAngle: reset && animationOpts.animateRotate ? datasetStartAngle : startAngle,
          endAngle: reset && animationOpts.animateRotate ? datasetStartAngle : endAngle,
          label: helpers$1.valueAtIndexOrDefault(labels, index, labels[index])
        }
      });
      arc.pivot();
    },
    countVisibleElements: function () {
      var dataset = this.getDataset();
      var meta = this.getMeta();
      var count = 0;
      helpers$1.each(meta.data, function (element, index) {
        if (!isNaN(dataset.data[index]) && !element.hidden) {
          count++;
        }
      });
      return count;
    },

    /**
     * @protected
     */
    setHoverStyle: function (arc) {
      var model = arc._model;
      var options = arc._options;
      var getHoverColor = helpers$1.getHoverColor;
      var valueOrDefault = helpers$1.valueOrDefault;
      arc.$previousStyle = {
        backgroundColor: model.backgroundColor,
        borderColor: model.borderColor,
        borderWidth: model.borderWidth
      };
      model.backgroundColor = valueOrDefault(options.hoverBackgroundColor, getHoverColor(options.backgroundColor));
      model.borderColor = valueOrDefault(options.hoverBorderColor, getHoverColor(options.borderColor));
      model.borderWidth = valueOrDefault(options.hoverBorderWidth, options.borderWidth);
    },

    /**
     * @private
     */
    _resolveElementOptions: function (arc, index) {
      var me = this;
      var chart = me.chart;
      var dataset = me.getDataset();
      var custom = arc.custom || {};
      var options = chart.options.elements.arc;
      var values = {};
      var i, ilen, key; // Scriptable options

      var context = {
        chart: chart,
        dataIndex: index,
        dataset: dataset,
        datasetIndex: me.index
      };
      var keys = ['backgroundColor', 'borderColor', 'borderWidth', 'borderAlign', 'hoverBackgroundColor', 'hoverBorderColor', 'hoverBorderWidth'];

      for (i = 0, ilen = keys.length; i < ilen; ++i) {
        key = keys[i];
        values[key] = resolve$5([custom[key], dataset[key], options[key]], context, index);
      }

      return values;
    },

    /**
     * @private
     */
    _computeAngle: function (index) {
      var me = this;
      var count = this.getMeta().count;
      var dataset = me.getDataset();
      var meta = me.getMeta();

      if (isNaN(dataset.data[index]) || meta.data[index].hidden) {
        return 0;
      } // Scriptable options


      var context = {
        chart: me.chart,
        dataIndex: index,
        dataset: dataset,
        datasetIndex: me.index
      };
      return resolve$5([me.chart.options.elements.arc.angle, 2 * Math.PI / count], context, index);
    }
  });

  core_defaults._set('pie', helpers$1.clone(core_defaults.doughnut));

  core_defaults._set('pie', {
    cutoutPercentage: 0
  }); // Pie charts are Doughnut chart with different defaults


  var controller_pie = controller_doughnut;
  var valueOrDefault$6 = helpers$1.valueOrDefault;
  var resolve$6 = helpers$1.options.resolve;

  core_defaults._set('radar', {
    scale: {
      type: 'radialLinear'
    },
    elements: {
      line: {
        tension: 0 // no bezier in radar

      }
    }
  });

  var controller_radar = core_datasetController.extend({
    datasetElementType: elements.Line,
    dataElementType: elements.Point,
    linkScales: helpers$1.noop,
    update: function (reset) {
      var me = this;
      var meta = me.getMeta();
      var line = meta.dataset;
      var points = meta.data || [];
      var scale = me.chart.scale;
      var dataset = me.getDataset();
      var i, ilen; // Compatibility: If the properties are defined with only the old name, use those values

      if (dataset.tension !== undefined && dataset.lineTension === undefined) {
        dataset.lineTension = dataset.tension;
      } // Utility


      line._scale = scale;
      line._datasetIndex = me.index; // Data

      line._children = points;
      line._loop = true; // Model

      line._model = me._resolveLineOptions(line);
      line.pivot(); // Update Points

      for (i = 0, ilen = points.length; i < ilen; ++i) {
        me.updateElement(points[i], i, reset);
      } // Update bezier control points


      me.updateBezierControlPoints(); // Now pivot the point for animation

      for (i = 0, ilen = points.length; i < ilen; ++i) {
        points[i].pivot();
      }
    },
    updateElement: function (point, index, reset) {
      var me = this;
      var custom = point.custom || {};
      var dataset = me.getDataset();
      var scale = me.chart.scale;
      var pointPosition = scale.getPointPositionForValue(index, dataset.data[index]);

      var options = me._resolvePointOptions(point, index);

      var lineModel = me.getMeta().dataset._model;

      var x = reset ? scale.xCenter : pointPosition.x;
      var y = reset ? scale.yCenter : pointPosition.y; // Utility

      point._scale = scale;
      point._options = options;
      point._datasetIndex = me.index;
      point._index = index; // Desired view properties

      point._model = {
        x: x,
        // value not used in dataset scale, but we want a consistent API between scales
        y: y,
        skip: custom.skip || isNaN(x) || isNaN(y),
        // Appearance
        radius: options.radius,
        pointStyle: options.pointStyle,
        rotation: options.rotation,
        backgroundColor: options.backgroundColor,
        borderColor: options.borderColor,
        borderWidth: options.borderWidth,
        tension: valueOrDefault$6(custom.tension, lineModel ? lineModel.tension : 0),
        // Tooltip
        hitRadius: options.hitRadius
      };
    },

    /**
     * @private
     */
    _resolvePointOptions: function (element, index) {
      var me = this;
      var chart = me.chart;
      var dataset = chart.data.datasets[me.index];
      var custom = element.custom || {};
      var options = chart.options.elements.point;
      var values = {};
      var i, ilen, key; // Scriptable options

      var context = {
        chart: chart,
        dataIndex: index,
        dataset: dataset,
        datasetIndex: me.index
      };
      var ELEMENT_OPTIONS = {
        backgroundColor: 'pointBackgroundColor',
        borderColor: 'pointBorderColor',
        borderWidth: 'pointBorderWidth',
        hitRadius: 'pointHitRadius',
        hoverBackgroundColor: 'pointHoverBackgroundColor',
        hoverBorderColor: 'pointHoverBorderColor',
        hoverBorderWidth: 'pointHoverBorderWidth',
        hoverRadius: 'pointHoverRadius',
        pointStyle: 'pointStyle',
        radius: 'pointRadius',
        rotation: 'pointRotation'
      };
      var keys = Object.keys(ELEMENT_OPTIONS);

      for (i = 0, ilen = keys.length; i < ilen; ++i) {
        key = keys[i];
        values[key] = resolve$6([custom[key], dataset[ELEMENT_OPTIONS[key]], dataset[key], options[key]], context, index);
      }

      return values;
    },

    /**
     * @private
     */
    _resolveLineOptions: function (element) {
      var me = this;
      var chart = me.chart;
      var dataset = chart.data.datasets[me.index];
      var custom = element.custom || {};
      var options = chart.options.elements.line;
      var values = {};
      var i, ilen, key;
      var keys = ['backgroundColor', 'borderWidth', 'borderColor', 'borderCapStyle', 'borderDash', 'borderDashOffset', 'borderJoinStyle', 'fill'];

      for (i = 0, ilen = keys.length; i < ilen; ++i) {
        key = keys[i];
        values[key] = resolve$6([custom[key], dataset[key], options[key]]);
      }

      values.tension = valueOrDefault$6(dataset.lineTension, options.tension);
      return values;
    },
    updateBezierControlPoints: function () {
      var me = this;
      var meta = me.getMeta();
      var area = me.chart.chartArea;
      var points = meta.data || [];
      var i, ilen, model, controlPoints;

      function capControlPoint(pt, min, max) {
        return Math.max(Math.min(pt, max), min);
      }

      for (i = 0, ilen = points.length; i < ilen; ++i) {
        model = points[i]._model;
        controlPoints = helpers$1.splineCurve(helpers$1.previousItem(points, i, true)._model, model, helpers$1.nextItem(points, i, true)._model, model.tension); // Prevent the bezier going outside of the bounds of the graph

        model.controlPointPreviousX = capControlPoint(controlPoints.previous.x, area.left, area.right);
        model.controlPointPreviousY = capControlPoint(controlPoints.previous.y, area.top, area.bottom);
        model.controlPointNextX = capControlPoint(controlPoints.next.x, area.left, area.right);
        model.controlPointNextY = capControlPoint(controlPoints.next.y, area.top, area.bottom);
      }
    },
    setHoverStyle: function (point) {
      var model = point._model;
      var options = point._options;
      var getHoverColor = helpers$1.getHoverColor;
      point.$previousStyle = {
        backgroundColor: model.backgroundColor,
        borderColor: model.borderColor,
        borderWidth: model.borderWidth,
        radius: model.radius
      };
      model.backgroundColor = valueOrDefault$6(options.hoverBackgroundColor, getHoverColor(options.backgroundColor));
      model.borderColor = valueOrDefault$6(options.hoverBorderColor, getHoverColor(options.borderColor));
      model.borderWidth = valueOrDefault$6(options.hoverBorderWidth, options.borderWidth);
      model.radius = valueOrDefault$6(options.hoverRadius, options.radius);
    }
  });

  core_defaults._set('scatter', {
    hover: {
      mode: 'single'
    },
    scales: {
      xAxes: [{
        id: 'x-axis-1',
        // need an ID so datasets can reference the scale
        type: 'linear',
        // scatter should not use a category axis
        position: 'bottom'
      }],
      yAxes: [{
        id: 'y-axis-1',
        type: 'linear',
        position: 'left'
      }]
    },
    showLines: false,
    tooltips: {
      callbacks: {
        title: function () {
          return ''; // doesn't make sense for scatter since data are formatted as a point
        },
        label: function (item) {
          return '(' + item.xLabel + ', ' + item.yLabel + ')';
        }
      }
    }
  }); // Scatter charts use line controllers


  var controller_scatter = controller_line; // NOTE export a map in which the key represents the controller type, not
  // the class, and so must be CamelCase in order to be correctly retrieved
  // by the controller in core.controller.js (`controllers[meta.type]`).

  var controllers = {
    bar: controller_bar,
    bubble: controller_bubble,
    doughnut: controller_doughnut,
    horizontalBar: controller_horizontalBar,
    line: controller_line,
    polarArea: controller_polarArea,
    pie: controller_pie,
    radar: controller_radar,
    scatter: controller_scatter
  };
  /**
   * Helper function to get relative position for an event
   * @param {Event|IEvent} event - The event to get the position for
   * @param {Chart} chart - The chart
   * @returns {object} the event position
   */

  function getRelativePosition(e, chart) {
    if (e.native) {
      return {
        x: e.x,
        y: e.y
      };
    }

    return helpers$1.getRelativePosition(e, chart);
  }
  /**
   * Helper function to traverse all of the visible elements in the chart
   * @param {Chart} chart - the chart
   * @param {function} handler - the callback to execute for each visible item
   */


  function parseVisibleItems(chart, handler) {
    var datasets = chart.data.datasets;
    var meta, i, j, ilen, jlen;

    for (i = 0, ilen = datasets.length; i < ilen; ++i) {
      if (!chart.isDatasetVisible(i)) {
        continue;
      }

      meta = chart.getDatasetMeta(i);

      for (j = 0, jlen = meta.data.length; j < jlen; ++j) {
        var element = meta.data[j];

        if (!element._view.skip) {
          handler(element);
        }
      }
    }
  }
  /**
   * Helper function to get the items that intersect the event position
   * @param {ChartElement[]} items - elements to filter
   * @param {object} position - the point to be nearest to
   * @return {ChartElement[]} the nearest items
   */


  function getIntersectItems(chart, position) {
    var elements = [];
    parseVisibleItems(chart, function (element) {
      if (element.inRange(position.x, position.y)) {
        elements.push(element);
      }
    });
    return elements;
  }
  /**
   * Helper function to get the items nearest to the event position considering all visible items in teh chart
   * @param {Chart} chart - the chart to look at elements from
   * @param {object} position - the point to be nearest to
   * @param {boolean} intersect - if true, only consider items that intersect the position
   * @param {function} distanceMetric - function to provide the distance between points
   * @return {ChartElement[]} the nearest items
   */


  function getNearestItems(chart, position, intersect, distanceMetric) {
    var minDistance = Number.POSITIVE_INFINITY;
    var nearestItems = [];
    parseVisibleItems(chart, function (element) {
      if (intersect && !element.inRange(position.x, position.y)) {
        return;
      }

      var center = element.getCenterPoint();
      var distance = distanceMetric(position, center);

      if (distance < minDistance) {
        nearestItems = [element];
        minDistance = distance;
      } else if (distance === minDistance) {
        // Can have multiple items at the same distance in which case we sort by size
        nearestItems.push(element);
      }
    });
    return nearestItems;
  }
  /**
   * Get a distance metric function for two points based on the
   * axis mode setting
   * @param {string} axis - the axis mode. x|y|xy
   */


  function getDistanceMetricForAxis(axis) {
    var useX = axis.indexOf('x') !== -1;
    var useY = axis.indexOf('y') !== -1;
    return function (pt1, pt2) {
      var deltaX = useX ? Math.abs(pt1.x - pt2.x) : 0;
      var deltaY = useY ? Math.abs(pt1.y - pt2.y) : 0;
      return Math.sqrt(Math.pow(deltaX, 2) + Math.pow(deltaY, 2));
    };
  }

  function indexMode(chart, e, options) {
    var position = getRelativePosition(e, chart); // Default axis for index mode is 'x' to match old behaviour

    options.axis = options.axis || 'x';
    var distanceMetric = getDistanceMetricForAxis(options.axis);
    var items = options.intersect ? getIntersectItems(chart, position) : getNearestItems(chart, position, false, distanceMetric);
    var elements = [];

    if (!items.length) {
      return [];
    }

    chart.data.datasets.forEach(function (dataset, datasetIndex) {
      if (chart.isDatasetVisible(datasetIndex)) {
        var meta = chart.getDatasetMeta(datasetIndex);
        var element = meta.data[items[0]._index]; // don't count items that are skipped (null data)

        if (element && !element._view.skip) {
          elements.push(element);
        }
      }
    });
    return elements;
  }
  /**
   * @interface IInteractionOptions
   */

  /**
   * If true, only consider items that intersect the point
   * @name IInterfaceOptions#boolean
   * @type Boolean
   */

  /**
   * Contains interaction related functions
   * @namespace Chart.Interaction
   */


  var core_interaction = {
    // Helper function for different modes
    modes: {
      single: function (chart, e) {
        var position = getRelativePosition(e, chart);
        var elements = [];
        parseVisibleItems(chart, function (element) {
          if (element.inRange(position.x, position.y)) {
            elements.push(element);
            return elements;
          }
        });
        return elements.slice(0, 1);
      },

      /**
       * @function Chart.Interaction.modes.label
       * @deprecated since version 2.4.0
       * @todo remove at version 3
       * @private
       */
      label: indexMode,

      /**
       * Returns items at the same index. If the options.intersect parameter is true, we only return items if we intersect something
       * If the options.intersect mode is false, we find the nearest item and return the items at the same index as that item
       * @function Chart.Interaction.modes.index
       * @since v2.4.0
       * @param {Chart} chart - the chart we are returning items from
       * @param {Event} e - the event we are find things at
       * @param {IInteractionOptions} options - options to use during interaction
       * @return {Chart.Element[]} Array of elements that are under the point. If none are found, an empty array is returned
       */
      index: indexMode,

      /**
       * Returns items in the same dataset. If the options.intersect parameter is true, we only return items if we intersect something
       * If the options.intersect is false, we find the nearest item and return the items in that dataset
       * @function Chart.Interaction.modes.dataset
       * @param {Chart} chart - the chart we are returning items from
       * @param {Event} e - the event we are find things at
       * @param {IInteractionOptions} options - options to use during interaction
       * @return {Chart.Element[]} Array of elements that are under the point. If none are found, an empty array is returned
       */
      dataset: function (chart, e, options) {
        var position = getRelativePosition(e, chart);
        options.axis = options.axis || 'xy';
        var distanceMetric = getDistanceMetricForAxis(options.axis);
        var items = options.intersect ? getIntersectItems(chart, position) : getNearestItems(chart, position, false, distanceMetric);

        if (items.length > 0) {
          items = chart.getDatasetMeta(items[0]._datasetIndex).data;
        }

        return items;
      },

      /**
       * @function Chart.Interaction.modes.x-axis
       * @deprecated since version 2.4.0. Use index mode and intersect == true
       * @todo remove at version 3
       * @private
       */
      'x-axis': function (chart, e) {
        return indexMode(chart, e, {
          intersect: false
        });
      },

      /**
       * Point mode returns all elements that hit test based on the event position
       * of the event
       * @function Chart.Interaction.modes.intersect
       * @param {Chart} chart - the chart we are returning items from
       * @param {Event} e - the event we are find things at
       * @return {Chart.Element[]} Array of elements that are under the point. If none are found, an empty array is returned
       */
      point: function (chart, e) {
        var position = getRelativePosition(e, chart);
        return getIntersectItems(chart, position);
      },

      /**
       * nearest mode returns the element closest to the point
       * @function Chart.Interaction.modes.intersect
       * @param {Chart} chart - the chart we are returning items from
       * @param {Event} e - the event we are find things at
       * @param {IInteractionOptions} options - options to use
       * @return {Chart.Element[]} Array of elements that are under the point. If none are found, an empty array is returned
       */
      nearest: function (chart, e, options) {
        var position = getRelativePosition(e, chart);
        options.axis = options.axis || 'xy';
        var distanceMetric = getDistanceMetricForAxis(options.axis);
        return getNearestItems(chart, position, options.intersect, distanceMetric);
      },

      /**
       * x mode returns the elements that hit-test at the current x coordinate
       * @function Chart.Interaction.modes.x
       * @param {Chart} chart - the chart we are returning items from
       * @param {Event} e - the event we are find things at
       * @param {IInteractionOptions} options - options to use
       * @return {Chart.Element[]} Array of elements that are under the point. If none are found, an empty array is returned
       */
      x: function (chart, e, options) {
        var position = getRelativePosition(e, chart);
        var items = [];
        var intersectsItem = false;
        parseVisibleItems(chart, function (element) {
          if (element.inXRange(position.x)) {
            items.push(element);
          }

          if (element.inRange(position.x, position.y)) {
            intersectsItem = true;
          }
        }); // If we want to trigger on an intersect and we don't have any items
        // that intersect the position, return nothing

        if (options.intersect && !intersectsItem) {
          items = [];
        }

        return items;
      },

      /**
       * y mode returns the elements that hit-test at the current y coordinate
       * @function Chart.Interaction.modes.y
       * @param {Chart} chart - the chart we are returning items from
       * @param {Event} e - the event we are find things at
       * @param {IInteractionOptions} options - options to use
       * @return {Chart.Element[]} Array of elements that are under the point. If none are found, an empty array is returned
       */
      y: function (chart, e, options) {
        var position = getRelativePosition(e, chart);
        var items = [];
        var intersectsItem = false;
        parseVisibleItems(chart, function (element) {
          if (element.inYRange(position.y)) {
            items.push(element);
          }

          if (element.inRange(position.x, position.y)) {
            intersectsItem = true;
          }
        }); // If we want to trigger on an intersect and we don't have any items
        // that intersect the position, return nothing

        if (options.intersect && !intersectsItem) {
          items = [];
        }

        return items;
      }
    }
  };

  function filterByPosition(array, position) {
    return helpers$1.where(array, function (v) {
      return v.position === position;
    });
  }

  function sortByWeight(array, reverse) {
    array.forEach(function (v, i) {
      v._tmpIndex_ = i;
      return v;
    });
    array.sort(function (a, b) {
      var v0 = reverse ? b : a;
      var v1 = reverse ? a : b;
      return v0.weight === v1.weight ? v0._tmpIndex_ - v1._tmpIndex_ : v0.weight - v1.weight;
    });
    array.forEach(function (v) {
      delete v._tmpIndex_;
    });
  }

  function findMaxPadding(boxes) {
    var top = 0;
    var left = 0;
    var bottom = 0;
    var right = 0;
    helpers$1.each(boxes, function (box) {
      if (box.getPadding) {
        var boxPadding = box.getPadding();
        top = Math.max(top, boxPadding.top);
        left = Math.max(left, boxPadding.left);
        bottom = Math.max(bottom, boxPadding.bottom);
        right = Math.max(right, boxPadding.right);
      }
    });
    return {
      top: top,
      left: left,
      bottom: bottom,
      right: right
    };
  }

  function addSizeByPosition(boxes, size) {
    helpers$1.each(boxes, function (box) {
      size[box.position] += box.isHorizontal() ? box.height : box.width;
    });
  }

  core_defaults._set('global', {
    layout: {
      padding: {
        top: 0,
        right: 0,
        bottom: 0,
        left: 0
      }
    }
  });
  /**
   * @interface ILayoutItem
   * @prop {string} position - The position of the item in the chart layout. Possible values are
   * 'left', 'top', 'right', 'bottom', and 'chartArea'
   * @prop {number} weight - The weight used to sort the item. Higher weights are further away from the chart area
   * @prop {boolean} fullWidth - if true, and the item is horizontal, then push vertical boxes down
   * @prop {function} isHorizontal - returns true if the layout item is horizontal (ie. top or bottom)
   * @prop {function} update - Takes two parameters: width and height. Returns size of item
   * @prop {function} getPadding -  Returns an object with padding on the edges
   * @prop {number} width - Width of item. Must be valid after update()
   * @prop {number} height - Height of item. Must be valid after update()
   * @prop {number} left - Left edge of the item. Set by layout system and cannot be used in update
   * @prop {number} top - Top edge of the item. Set by layout system and cannot be used in update
   * @prop {number} right - Right edge of the item. Set by layout system and cannot be used in update
   * @prop {number} bottom - Bottom edge of the item. Set by layout system and cannot be used in update
   */
  // The layout service is very self explanatory.  It's responsible for the layout within a chart.
  // Scales, Legends and Plugins all rely on the layout service and can easily register to be placed anywhere they need
  // It is this service's responsibility of carrying out that layout.


  var core_layouts = {
    defaults: {},

    /**
     * Register a box to a chart.
     * A box is simply a reference to an object that requires layout. eg. Scales, Legend, Title.
     * @param {Chart} chart - the chart to use
     * @param {ILayoutItem} item - the item to add to be layed out
     */
    addBox: function (chart, item) {
      if (!chart.boxes) {
        chart.boxes = [];
      } // initialize item with default values


      item.fullWidth = item.fullWidth || false;
      item.position = item.position || 'top';
      item.weight = item.weight || 0;
      chart.boxes.push(item);
    },

    /**
     * Remove a layoutItem from a chart
     * @param {Chart} chart - the chart to remove the box from
     * @param {ILayoutItem} layoutItem - the item to remove from the layout
     */
    removeBox: function (chart, layoutItem) {
      var index = chart.boxes ? chart.boxes.indexOf(layoutItem) : -1;

      if (index !== -1) {
        chart.boxes.splice(index, 1);
      }
    },

    /**
     * Sets (or updates) options on the given `item`.
     * @param {Chart} chart - the chart in which the item lives (or will be added to)
     * @param {ILayoutItem} item - the item to configure with the given options
     * @param {object} options - the new item options.
     */
    configure: function (chart, item, options) {
      var props = ['fullWidth', 'position', 'weight'];
      var ilen = props.length;
      var i = 0;
      var prop;

      for (; i < ilen; ++i) {
        prop = props[i];

        if (options.hasOwnProperty(prop)) {
          item[prop] = options[prop];
        }
      }
    },

    /**
     * Fits boxes of the given chart into the given size by having each box measure itself
     * then running a fitting algorithm
     * @param {Chart} chart - the chart
     * @param {number} width - the width to fit into
     * @param {number} height - the height to fit into
     */
    update: function (chart, width, height) {
      if (!chart) {
        return;
      }

      var layoutOptions = chart.options.layout || {};
      var padding = helpers$1.options.toPadding(layoutOptions.padding);
      var leftPadding = padding.left;
      var rightPadding = padding.right;
      var topPadding = padding.top;
      var bottomPadding = padding.bottom;
      var leftBoxes = filterByPosition(chart.boxes, 'left');
      var rightBoxes = filterByPosition(chart.boxes, 'right');
      var topBoxes = filterByPosition(chart.boxes, 'top');
      var bottomBoxes = filterByPosition(chart.boxes, 'bottom');
      var chartAreaBoxes = filterByPosition(chart.boxes, 'chartArea'); // Sort boxes by weight. A higher weight is further away from the chart area

      sortByWeight(leftBoxes, true);
      sortByWeight(rightBoxes, false);
      sortByWeight(topBoxes, true);
      sortByWeight(bottomBoxes, false);
      var verticalBoxes = leftBoxes.concat(rightBoxes);
      var horizontalBoxes = topBoxes.concat(bottomBoxes);
      var outerBoxes = verticalBoxes.concat(horizontalBoxes); // Essentially we now have any number of boxes on each of the 4 sides.
      // Our canvas looks like the following.
      // The areas L1 and L2 are the left axes. R1 is the right axis, T1 is the top axis and
      // B1 is the bottom axis
      // There are also 4 quadrant-like locations (left to right instead of clockwise) reserved for chart overlays
      // These locations are single-box locations only, when trying to register a chartArea location that is already taken,
      // an error will be thrown.
      //
      // |----------------------------------------------------|
      // |                  T1 (Full Width)                   |
      // |----------------------------------------------------|
      // |    |    |                 T2                  |    |
      // |    |----|-------------------------------------|----|
      // |    |    | C1 |                           | C2 |    |
      // |    |    |----|                           |----|    |
      // |    |    |                                     |    |
      // | L1 | L2 |           ChartArea (C0)            | R1 |
      // |    |    |                                     |    |
      // |    |    |----|                           |----|    |
      // |    |    | C3 |                           | C4 |    |
      // |    |----|-------------------------------------|----|
      // |    |    |                 B1                  |    |
      // |----------------------------------------------------|
      // |                  B2 (Full Width)                   |
      // |----------------------------------------------------|
      //
      // What we do to find the best sizing, we do the following
      // 1. Determine the minimum size of the chart area.
      // 2. Split the remaining width equally between each vertical axis
      // 3. Split the remaining height equally between each horizontal axis
      // 4. Give each layout the maximum size it can be. The layout will return it's minimum size
      // 5. Adjust the sizes of each axis based on it's minimum reported size.
      // 6. Refit each axis
      // 7. Position each axis in the final location
      // 8. Tell the chart the final location of the chart area
      // 9. Tell any axes that overlay the chart area the positions of the chart area
      // Step 1

      var chartWidth = width - leftPadding - rightPadding;
      var chartHeight = height - topPadding - bottomPadding;
      var chartAreaWidth = chartWidth / 2; // min 50%
      // Step 2

      var verticalBoxWidth = (width - chartAreaWidth) / verticalBoxes.length; // Step 3
      // TODO re-limit horizontal axis height (this limit has affected only padding calculation since PR 1837)
      // var horizontalBoxHeight = (height - chartAreaHeight) / horizontalBoxes.length;
      // Step 4

      var maxChartAreaWidth = chartWidth;
      var maxChartAreaHeight = chartHeight;
      var outerBoxSizes = {
        top: topPadding,
        left: leftPadding,
        bottom: bottomPadding,
        right: rightPadding
      };
      var minBoxSizes = [];
      var maxPadding;

      function getMinimumBoxSize(box) {
        var minSize;
        var isHorizontal = box.isHorizontal();

        if (isHorizontal) {
          minSize = box.update(box.fullWidth ? chartWidth : maxChartAreaWidth, chartHeight / 2);
          maxChartAreaHeight -= minSize.height;
        } else {
          minSize = box.update(verticalBoxWidth, maxChartAreaHeight);
          maxChartAreaWidth -= minSize.width;
        }

        minBoxSizes.push({
          horizontal: isHorizontal,
          width: minSize.width,
          box: box
        });
      }

      helpers$1.each(outerBoxes, getMinimumBoxSize); // If a horizontal box has padding, we move the left boxes over to avoid ugly charts (see issue #2478)

      maxPadding = findMaxPadding(outerBoxes); // At this point, maxChartAreaHeight and maxChartAreaWidth are the size the chart area could
      // be if the axes are drawn at their minimum sizes.
      // Steps 5 & 6
      // Function to fit a box

      function fitBox(box) {
        var minBoxSize = helpers$1.findNextWhere(minBoxSizes, function (minBox) {
          return minBox.box === box;
        });

        if (minBoxSize) {
          if (minBoxSize.horizontal) {
            var scaleMargin = {
              left: Math.max(outerBoxSizes.left, maxPadding.left),
              right: Math.max(outerBoxSizes.right, maxPadding.right),
              top: 0,
              bottom: 0
            }; // Don't use min size here because of label rotation. When the labels are rotated, their rotation highly depends
            // on the margin. Sometimes they need to increase in size slightly

            box.update(box.fullWidth ? chartWidth : maxChartAreaWidth, chartHeight / 2, scaleMargin);
          } else {
            box.update(minBoxSize.width, maxChartAreaHeight);
          }
        }
      } // Update, and calculate the left and right margins for the horizontal boxes


      helpers$1.each(verticalBoxes, fitBox);
      addSizeByPosition(verticalBoxes, outerBoxSizes); // Set the Left and Right margins for the horizontal boxes

      helpers$1.each(horizontalBoxes, fitBox);
      addSizeByPosition(horizontalBoxes, outerBoxSizes);

      function finalFitVerticalBox(box) {
        var minBoxSize = helpers$1.findNextWhere(minBoxSizes, function (minSize) {
          return minSize.box === box;
        });
        var scaleMargin = {
          left: 0,
          right: 0,
          top: outerBoxSizes.top,
          bottom: outerBoxSizes.bottom
        };

        if (minBoxSize) {
          box.update(minBoxSize.width, maxChartAreaHeight, scaleMargin);
        }
      } // Let the left layout know the final margin


      helpers$1.each(verticalBoxes, finalFitVerticalBox); // Recalculate because the size of each layout might have changed slightly due to the margins (label rotation for instance)

      outerBoxSizes = {
        top: topPadding,
        left: leftPadding,
        bottom: bottomPadding,
        right: rightPadding
      };
      addSizeByPosition(outerBoxes, outerBoxSizes); // We may be adding some padding to account for rotated x axis labels

      var leftPaddingAddition = Math.max(maxPadding.left - outerBoxSizes.left, 0);
      outerBoxSizes.left += leftPaddingAddition;
      outerBoxSizes.right += Math.max(maxPadding.right - outerBoxSizes.right, 0);
      var topPaddingAddition = Math.max(maxPadding.top - outerBoxSizes.top, 0);
      outerBoxSizes.top += topPaddingAddition;
      outerBoxSizes.bottom += Math.max(maxPadding.bottom - outerBoxSizes.bottom, 0); // Figure out if our chart area changed. This would occur if the dataset layout label rotation
      // changed due to the application of the margins in step 6. Since we can only get bigger, this is safe to do
      // without calling `fit` again

      var newMaxChartAreaHeight = height - outerBoxSizes.top - outerBoxSizes.bottom;
      var newMaxChartAreaWidth = width - outerBoxSizes.left - outerBoxSizes.right;

      if (newMaxChartAreaWidth !== maxChartAreaWidth || newMaxChartAreaHeight !== maxChartAreaHeight) {
        helpers$1.each(verticalBoxes, function (box) {
          box.height = newMaxChartAreaHeight;
        });
        helpers$1.each(horizontalBoxes, function (box) {
          if (!box.fullWidth) {
            box.width = newMaxChartAreaWidth;
          }
        });
        maxChartAreaHeight = newMaxChartAreaHeight;
        maxChartAreaWidth = newMaxChartAreaWidth;
      } // Step 7 - Position the boxes


      var left = leftPadding + leftPaddingAddition;
      var top = topPadding + topPaddingAddition;

      function placeBox(box) {
        if (box.isHorizontal()) {
          box.left = box.fullWidth ? leftPadding : outerBoxSizes.left;
          box.right = box.fullWidth ? width - rightPadding : outerBoxSizes.left + maxChartAreaWidth;
          box.top = top;
          box.bottom = top + box.height; // Move to next point

          top = box.bottom;
        } else {
          box.left = left;
          box.right = left + box.width;
          box.top = outerBoxSizes.top;
          box.bottom = outerBoxSizes.top + maxChartAreaHeight; // Move to next point

          left = box.right;
        }
      }

      helpers$1.each(leftBoxes.concat(topBoxes), placeBox); // Account for chart width and height

      left += maxChartAreaWidth;
      top += maxChartAreaHeight;
      helpers$1.each(rightBoxes, placeBox);
      helpers$1.each(bottomBoxes, placeBox); // Step 8

      chart.chartArea = {
        left: outerBoxSizes.left,
        top: outerBoxSizes.top,
        right: outerBoxSizes.left + maxChartAreaWidth,
        bottom: outerBoxSizes.top + maxChartAreaHeight
      }; // Step 9

      helpers$1.each(chartAreaBoxes, function (box) {
        box.left = chart.chartArea.left;
        box.top = chart.chartArea.top;
        box.right = chart.chartArea.right;
        box.bottom = chart.chartArea.bottom;
        box.update(maxChartAreaWidth, maxChartAreaHeight);
      });
    }
  };
  /**
   * Platform fallback implementation (minimal).
   * @see https://github.com/chartjs/Chart.js/pull/4591#issuecomment-319575939
   */

  var platform_basic = {
    acquireContext: function (item) {
      if (item && item.canvas) {
        // Support for any object associated to a canvas (including a context2d)
        item = item.canvas;
      }

      return item && item.getContext('2d') || null;
    }
  };
  var platform_dom = "/*\n * DOM element rendering detection\n * https://davidwalsh.name/detect-node-insertion\n */\n@keyframes chartjs-render-animation {\n\tfrom { opacity: 0.99; }\n\tto { opacity: 1; }\n}\n\n.chartjs-render-monitor {\n\tanimation: chartjs-render-animation 0.001s;\n}\n\n/*\n * DOM element resizing detection\n * https://github.com/marcj/css-element-queries\n */\n.chartjs-size-monitor,\n.chartjs-size-monitor-expand,\n.chartjs-size-monitor-shrink {\n\tposition: absolute;\n\tdirection: ltr;\n\tleft: 0;\n\ttop: 0;\n\tright: 0;\n\tbottom: 0;\n\toverflow: hidden;\n\tpointer-events: none;\n\tvisibility: hidden;\n\tz-index: -1;\n}\n\n.chartjs-size-monitor-expand > div {\n\tposition: absolute;\n\twidth: 1000000px;\n\theight: 1000000px;\n\tleft: 0;\n\ttop: 0;\n}\n\n.chartjs-size-monitor-shrink > div {\n\tposition: absolute;\n\twidth: 200%;\n\theight: 200%;\n\tleft: 0;\n\ttop: 0;\n}\n";
  var platform_dom$1 = /*#__PURE__*/Object.freeze({
    default: platform_dom
  });

  function getCjsExportFromNamespace(n) {
    return n && n.default || n;
  }

  var stylesheet = getCjsExportFromNamespace(platform_dom$1);
  var EXPANDO_KEY = '$chartjs';
  var CSS_PREFIX = 'chartjs-';
  var CSS_SIZE_MONITOR = CSS_PREFIX + 'size-monitor';
  var CSS_RENDER_MONITOR = CSS_PREFIX + 'render-monitor';
  var CSS_RENDER_ANIMATION = CSS_PREFIX + 'render-animation';
  var ANIMATION_START_EVENTS = ['animationstart', 'webkitAnimationStart'];
  /**
   * DOM event types -> Chart.js event types.
   * Note: only events with different types are mapped.
   * @see https://developer.mozilla.org/en-US/docs/Web/Events
   */

  var EVENT_TYPES = {
    touchstart: 'mousedown',
    touchmove: 'mousemove',
    touchend: 'mouseup',
    pointerenter: 'mouseenter',
    pointerdown: 'mousedown',
    pointermove: 'mousemove',
    pointerup: 'mouseup',
    pointerleave: 'mouseout',
    pointerout: 'mouseout'
  };
  /**
   * The "used" size is the final value of a dimension property after all calculations have
   * been performed. This method uses the computed style of `element` but returns undefined
   * if the computed style is not expressed in pixels. That can happen in some cases where
   * `element` has a size relative to its parent and this last one is not yet displayed,
   * for example because of `display: none` on a parent node.
   * @see https://developer.mozilla.org/en-US/docs/Web/CSS/used_value
   * @returns {number} Size in pixels or undefined if unknown.
   */

  function readUsedSize(element, property) {
    var value = helpers$1.getStyle(element, property);
    var matches = value && value.match(/^(\d+)(\.\d+)?px$/);
    return matches ? Number(matches[1]) : undefined;
  }
  /**
   * Initializes the canvas style and render size without modifying the canvas display size,
   * since responsiveness is handled by the controller.resize() method. The config is used
   * to determine the aspect ratio to apply in case no explicit height has been specified.
   */


  function initCanvas(canvas, config) {
    var style = canvas.style; // NOTE(SB) canvas.getAttribute('width') !== canvas.width: in the first case it
    // returns null or '' if no explicit value has been set to the canvas attribute.

    var renderHeight = canvas.getAttribute('height');
    var renderWidth = canvas.getAttribute('width'); // Chart.js modifies some canvas values that we want to restore on destroy

    canvas[EXPANDO_KEY] = {
      initial: {
        height: renderHeight,
        width: renderWidth,
        style: {
          display: style.display,
          height: style.height,
          width: style.width
        }
      }
    }; // Force canvas to display as block to avoid extra space caused by inline
    // elements, which would interfere with the responsive resize process.
    // https://github.com/chartjs/Chart.js/issues/2538

    style.display = style.display || 'block';

    if (renderWidth === null || renderWidth === '') {
      var displayWidth = readUsedSize(canvas, 'width');

      if (displayWidth !== undefined) {
        canvas.width = displayWidth;
      }
    }

    if (renderHeight === null || renderHeight === '') {
      if (canvas.style.height === '') {
        // If no explicit render height and style height, let's apply the aspect ratio,
        // which one can be specified by the user but also by charts as default option
        // (i.e. options.aspectRatio). If not specified, use canvas aspect ratio of 2.
        canvas.height = canvas.width / (config.options.aspectRatio || 2);
      } else {
        var displayHeight = readUsedSize(canvas, 'height');

        if (displayWidth !== undefined) {
          canvas.height = displayHeight;
        }
      }
    }

    return canvas;
  }
  /**
   * Detects support for options object argument in addEventListener.
   * https://developer.mozilla.org/en-US/docs/Web/API/EventTarget/addEventListener#Safely_detecting_option_support
   * @private
   */


  var supportsEventListenerOptions = function () {
    var supports = false;

    try {
      var options = Object.defineProperty({}, 'passive', {
        // eslint-disable-next-line getter-return
        get: function () {
          supports = true;
        }
      });
      window.addEventListener('e', null, options);
    } catch (e) {// continue regardless of error
    }

    return supports;
  }(); // Default passive to true as expected by Chrome for 'touchstart' and 'touchend' events.
  // https://github.com/chartjs/Chart.js/issues/4287


  var eventListenerOptions = supportsEventListenerOptions ? {
    passive: true
  } : false;

  function addListener(node, type, listener) {
    node.addEventListener(type, listener, eventListenerOptions);
  }

  function removeListener(node, type, listener) {
    node.removeEventListener(type, listener, eventListenerOptions);
  }

  function createEvent(type, chart, x, y, nativeEvent) {
    return {
      type: type,
      chart: chart,
      native: nativeEvent || null,
      x: x !== undefined ? x : null,
      y: y !== undefined ? y : null
    };
  }

  function fromNativeEvent(event, chart) {
    var type = EVENT_TYPES[event.type] || event.type;
    var pos = helpers$1.getRelativePosition(event, chart);
    return createEvent(type, chart, pos.x, pos.y, event);
  }

  function throttled(fn, thisArg) {
    var ticking = false;
    var args = [];
    return function () {
      args = Array.prototype.slice.call(arguments);
      thisArg = thisArg || this;

      if (!ticking) {
        ticking = true;
        helpers$1.requestAnimFrame.call(window, function () {
          ticking = false;
          fn.apply(thisArg, args);
        });
      }
    };
  }

  function createDiv(cls) {
    var el = document.createElement('div');
    el.className = cls || '';
    return el;
  } // Implementation based on https://github.com/marcj/css-element-queries


  function createResizer(handler) {
    var maxSize = 1000000; // NOTE(SB) Don't use innerHTML because it could be considered unsafe.
    // https://github.com/chartjs/Chart.js/issues/5902

    var resizer = createDiv(CSS_SIZE_MONITOR);
    var expand = createDiv(CSS_SIZE_MONITOR + '-expand');
    var shrink = createDiv(CSS_SIZE_MONITOR + '-shrink');
    expand.appendChild(createDiv());
    shrink.appendChild(createDiv());
    resizer.appendChild(expand);
    resizer.appendChild(shrink);

    resizer._reset = function () {
      expand.scrollLeft = maxSize;
      expand.scrollTop = maxSize;
      shrink.scrollLeft = maxSize;
      shrink.scrollTop = maxSize;
    };

    var onScroll = function () {
      resizer._reset();

      handler();
    };

    addListener(expand, 'scroll', onScroll.bind(expand, 'expand'));
    addListener(shrink, 'scroll', onScroll.bind(shrink, 'shrink'));
    return resizer;
  } // https://davidwalsh.name/detect-node-insertion


  function watchForRender(node, handler) {
    var expando = node[EXPANDO_KEY] || (node[EXPANDO_KEY] = {});

    var proxy = expando.renderProxy = function (e) {
      if (e.animationName === CSS_RENDER_ANIMATION) {
        handler();
      }
    };

    helpers$1.each(ANIMATION_START_EVENTS, function (type) {
      addListener(node, type, proxy);
    }); // #4737: Chrome might skip the CSS animation when the CSS_RENDER_MONITOR class
    // is removed then added back immediately (same animation frame?). Accessing the
    // `offsetParent` property will force a reflow and re-evaluate the CSS animation.
    // https://gist.github.com/paulirish/5d52fb081b3570c81e3a#box-metrics
    // https://github.com/chartjs/Chart.js/issues/4737

    expando.reflow = !!node.offsetParent;
    node.classList.add(CSS_RENDER_MONITOR);
  }

  function unwatchForRender(node) {
    var expando = node[EXPANDO_KEY] || {};
    var proxy = expando.renderProxy;

    if (proxy) {
      helpers$1.each(ANIMATION_START_EVENTS, function (type) {
        removeListener(node, type, proxy);
      });
      delete expando.renderProxy;
    }

    node.classList.remove(CSS_RENDER_MONITOR);
  }

  function addResizeListener(node, listener, chart) {
    var expando = node[EXPANDO_KEY] || (node[EXPANDO_KEY] = {}); // Let's keep track of this added resizer and thus avoid DOM query when removing it.

    var resizer = expando.resizer = createResizer(throttled(function () {
      if (expando.resizer) {
        var container = chart.options.maintainAspectRatio && node.parentNode;
        var w = container ? container.clientWidth : 0;
        listener(createEvent('resize', chart));

        if (container && container.clientWidth < w && chart.canvas) {
          // If the container size shrank during chart resize, let's assume
          // scrollbar appeared. So we resize again with the scrollbar visible -
          // effectively making chart smaller and the scrollbar hidden again.
          // Because we are inside `throttled`, and currently `ticking`, scroll
          // events are ignored during this whole 2 resize process.
          // If we assumed wrong and something else happened, we are resizing
          // twice in a frame (potential performance issue)
          listener(createEvent('resize', chart));
        }
      }
    })); // The resizer needs to be attached to the node parent, so we first need to be
    // sure that `node` is attached to the DOM before injecting the resizer element.

    watchForRender(node, function () {
      if (expando.resizer) {
        var container = node.parentNode;

        if (container && container !== resizer.parentNode) {
          container.insertBefore(resizer, container.firstChild);
        } // The container size might have changed, let's reset the resizer state.


        resizer._reset();
      }
    });
  }

  function removeResizeListener(node) {
    var expando = node[EXPANDO_KEY] || {};
    var resizer = expando.resizer;
    delete expando.resizer;
    unwatchForRender(node);

    if (resizer && resizer.parentNode) {
      resizer.parentNode.removeChild(resizer);
    }
  }

  function injectCSS(platform, css) {
    // https://stackoverflow.com/q/3922139
    var style = platform._style || document.createElement('style');

    if (!platform._style) {
      platform._style = style;
      css = '/* Chart.js */\n' + css;
      style.setAttribute('type', 'text/css');
      document.getElementsByTagName('head')[0].appendChild(style);
    }

    style.appendChild(document.createTextNode(css));
  }

  var platform_dom$2 = {
    /**
     * When `true`, prevents the automatic injection of the stylesheet required to
     * correctly detect when the chart is added to the DOM and then resized. This
     * switch has been added to allow external stylesheet (`dist/Chart(.min)?.js`)
     * to be manually imported to make this library compatible with any CSP.
     * See https://github.com/chartjs/Chart.js/issues/5208
     */
    disableCSSInjection: false,

    /**
     * This property holds whether this platform is enabled for the current environment.
     * Currently used by platform.js to select the proper implementation.
     * @private
     */
    _enabled: typeof window !== 'undefined' && typeof document !== 'undefined',

    /**
     * @private
     */
    _ensureLoaded: function () {
      if (this._loaded) {
        return;
      }

      this._loaded = true; // https://github.com/chartjs/Chart.js/issues/5208

      if (!this.disableCSSInjection) {
        injectCSS(this, stylesheet);
      }
    },
    acquireContext: function (item, config) {
      if (typeof item === 'string') {
        item = document.getElementById(item);
      } else if (item.length) {
        // Support for array based queries (such as jQuery)
        item = item[0];
      }

      if (item && item.canvas) {
        // Support for any object associated to a canvas (including a context2d)
        item = item.canvas;
      } // To prevent canvas fingerprinting, some add-ons undefine the getContext
      // method, for example: https://github.com/kkapsner/CanvasBlocker
      // https://github.com/chartjs/Chart.js/issues/2807


      var context = item && item.getContext && item.getContext('2d'); // Load platform resources on first chart creation, to make possible to change
      // platform options after importing the library (e.g. `disableCSSInjection`).

      this._ensureLoaded(); // `instanceof HTMLCanvasElement/CanvasRenderingContext2D` fails when the item is
      // inside an iframe or when running in a protected environment. We could guess the
      // types from their toString() value but let's keep things flexible and assume it's
      // a sufficient condition if the item has a context2D which has item as `canvas`.
      // https://github.com/chartjs/Chart.js/issues/3887
      // https://github.com/chartjs/Chart.js/issues/4102
      // https://github.com/chartjs/Chart.js/issues/4152


      if (context && context.canvas === item) {
        initCanvas(item, config);
        return context;
      }

      return null;
    },
    releaseContext: function (context) {
      var canvas = context.canvas;

      if (!canvas[EXPANDO_KEY]) {
        return;
      }

      var initial = canvas[EXPANDO_KEY].initial;
      ['height', 'width'].forEach(function (prop) {
        var value = initial[prop];

        if (helpers$1.isNullOrUndef(value)) {
          canvas.removeAttribute(prop);
        } else {
          canvas.setAttribute(prop, value);
        }
      });
      helpers$1.each(initial.style || {}, function (value, key) {
        canvas.style[key] = value;
      }); // The canvas render size might have been changed (and thus the state stack discarded),
      // we can't use save() and restore() to restore the initial state. So make sure that at
      // least the canvas context is reset to the default state by setting the canvas width.
      // https://www.w3.org/TR/2011/WD-html5-20110525/the-canvas-element.html
      // eslint-disable-next-line no-self-assign

      canvas.width = canvas.width;
      delete canvas[EXPANDO_KEY];
    },
    addEventListener: function (chart, type, listener) {
      var canvas = chart.canvas;

      if (type === 'resize') {
        // Note: the resize event is not supported on all browsers.
        addResizeListener(canvas, listener, chart);
        return;
      }

      var expando = listener[EXPANDO_KEY] || (listener[EXPANDO_KEY] = {});
      var proxies = expando.proxies || (expando.proxies = {});

      var proxy = proxies[chart.id + '_' + type] = function (event) {
        listener(fromNativeEvent(event, chart));
      };

      addListener(canvas, type, proxy);
    },
    removeEventListener: function (chart, type, listener) {
      var canvas = chart.canvas;

      if (type === 'resize') {
        // Note: the resize event is not supported on all browsers.
        removeResizeListener(canvas);
        return;
      }

      var expando = listener[EXPANDO_KEY] || {};
      var proxies = expando.proxies || {};
      var proxy = proxies[chart.id + '_' + type];

      if (!proxy) {
        return;
      }

      removeListener(canvas, type, proxy);
    }
  }; // DEPRECATIONS

  /**
   * Provided for backward compatibility, use EventTarget.addEventListener instead.
   * EventTarget.addEventListener compatibility: Chrome, Opera 7, Safari, FF1.5+, IE9+
   * @see https://developer.mozilla.org/en-US/docs/Web/API/EventTarget/addEventListener
   * @function Chart.helpers.addEvent
   * @deprecated since version 2.7.0
   * @todo remove at version 3
   * @private
   */

  helpers$1.addEvent = addListener;
  /**
   * Provided for backward compatibility, use EventTarget.removeEventListener instead.
   * EventTarget.removeEventListener compatibility: Chrome, Opera 7, Safari, FF1.5+, IE9+
   * @see https://developer.mozilla.org/en-US/docs/Web/API/EventTarget/removeEventListener
   * @function Chart.helpers.removeEvent
   * @deprecated since version 2.7.0
   * @todo remove at version 3
   * @private
   */

  helpers$1.removeEvent = removeListener; // @TODO Make possible to select another platform at build time.

  var implementation = platform_dom$2._enabled ? platform_dom$2 : platform_basic;
  /**
   * @namespace Chart.platform
   * @see https://chartjs.gitbooks.io/proposals/content/Platform.html
   * @since 2.4.0
   */

  var platform = helpers$1.extend({
    /**
     * @since 2.7.0
     */
    initialize: function () {},

    /**
     * Called at chart construction time, returns a context2d instance implementing
     * the [W3C Canvas 2D Context API standard]{@link https://www.w3.org/TR/2dcontext/}.
     * @param {*} item - The native item from which to acquire context (platform specific)
     * @param {object} options - The chart options
     * @returns {CanvasRenderingContext2D} context2d instance
     */
    acquireContext: function () {},

    /**
     * Called at chart destruction time, releases any resources associated to the context
     * previously returned by the acquireContext() method.
     * @param {CanvasRenderingContext2D} context - The context2d instance
     * @returns {boolean} true if the method succeeded, else false
     */
    releaseContext: function () {},

    /**
     * Registers the specified listener on the given chart.
     * @param {Chart} chart - Chart from which to listen for event
     * @param {string} type - The ({@link IEvent}) type to listen for
     * @param {function} listener - Receives a notification (an object that implements
     * the {@link IEvent} interface) when an event of the specified type occurs.
     */
    addEventListener: function () {},

    /**
     * Removes the specified listener previously registered with addEventListener.
     * @param {Chart} chart - Chart from which to remove the listener
     * @param {string} type - The ({@link IEvent}) type to remove
     * @param {function} listener - The listener function to remove from the event target.
     */
    removeEventListener: function () {}
  }, implementation);

  core_defaults._set('global', {
    plugins: {}
  });
  /**
   * The plugin service singleton
   * @namespace Chart.plugins
   * @since 2.1.0
   */


  var core_plugins = {
    /**
     * Globally registered plugins.
     * @private
     */
    _plugins: [],

    /**
     * This identifier is used to invalidate the descriptors cache attached to each chart
     * when a global plugin is registered or unregistered. In this case, the cache ID is
     * incremented and descriptors are regenerated during following API calls.
     * @private
     */
    _cacheId: 0,

    /**
     * Registers the given plugin(s) if not already registered.
     * @param {IPlugin[]|IPlugin} plugins plugin instance(s).
     */
    register: function (plugins) {
      var p = this._plugins;
      [].concat(plugins).forEach(function (plugin) {
        if (p.indexOf(plugin) === -1) {
          p.push(plugin);
        }
      });
      this._cacheId++;
    },

    /**
     * Unregisters the given plugin(s) only if registered.
     * @param {IPlugin[]|IPlugin} plugins plugin instance(s).
     */
    unregister: function (plugins) {
      var p = this._plugins;
      [].concat(plugins).forEach(function (plugin) {
        var idx = p.indexOf(plugin);

        if (idx !== -1) {
          p.splice(idx, 1);
        }
      });
      this._cacheId++;
    },

    /**
     * Remove all registered plugins.
     * @since 2.1.5
     */
    clear: function () {
      this._plugins = [];
      this._cacheId++;
    },

    /**
     * Returns the number of registered plugins?
     * @returns {number}
     * @since 2.1.5
     */
    count: function () {
      return this._plugins.length;
    },

    /**
     * Returns all registered plugin instances.
     * @returns {IPlugin[]} array of plugin objects.
     * @since 2.1.5
     */
    getAll: function () {
      return this._plugins;
    },

    /**
     * Calls enabled plugins for `chart` on the specified hook and with the given args.
     * This method immediately returns as soon as a plugin explicitly returns false. The
     * returned value can be used, for instance, to interrupt the current action.
     * @param {Chart} chart - The chart instance for which plugins should be called.
     * @param {string} hook - The name of the plugin method to call (e.g. 'beforeUpdate').
     * @param {Array} [args] - Extra arguments to apply to the hook call.
     * @returns {boolean} false if any of the plugins return false, else returns true.
     */
    notify: function (chart, hook, args) {
      var descriptors = this.descriptors(chart);
      var ilen = descriptors.length;
      var i, descriptor, plugin, params, method;

      for (i = 0; i < ilen; ++i) {
        descriptor = descriptors[i];
        plugin = descriptor.plugin;
        method = plugin[hook];

        if (typeof method === 'function') {
          params = [chart].concat(args || []);
          params.push(descriptor.options);

          if (method.apply(plugin, params) === false) {
            return false;
          }
        }
      }

      return true;
    },

    /**
     * Returns descriptors of enabled plugins for the given chart.
     * @returns {object[]} [{ plugin, options }]
     * @private
     */
    descriptors: function (chart) {
      var cache = chart.$plugins || (chart.$plugins = {});

      if (cache.id === this._cacheId) {
        return cache.descriptors;
      }

      var plugins = [];
      var descriptors = [];
      var config = chart && chart.config || {};
      var options = config.options && config.options.plugins || {};

      this._plugins.concat(config.plugins || []).forEach(function (plugin) {
        var idx = plugins.indexOf(plugin);

        if (idx !== -1) {
          return;
        }

        var id = plugin.id;
        var opts = options[id];

        if (opts === false) {
          return;
        }

        if (opts === true) {
          opts = helpers$1.clone(core_defaults.global.plugins[id]);
        }

        plugins.push(plugin);
        descriptors.push({
          plugin: plugin,
          options: opts || {}
        });
      });

      cache.descriptors = descriptors;
      cache.id = this._cacheId;
      return descriptors;
    },

    /**
     * Invalidates cache for the given chart: descriptors hold a reference on plugin option,
     * but in some cases, this reference can be changed by the user when updating options.
     * https://github.com/chartjs/Chart.js/issues/5111#issuecomment-355934167
     * @private
     */
    _invalidate: function (chart) {
      delete chart.$plugins;
    }
  };
  var core_scaleService = {
    // Scale registration object. Extensions can register new scale types (such as log or DB scales) and then
    // use the new chart options to grab the correct scale
    constructors: {},
    // Use a registration function so that we can move to an ES6 map when we no longer need to support
    // old browsers
    // Scale config defaults
    defaults: {},
    registerScaleType: function (type, scaleConstructor, scaleDefaults) {
      this.constructors[type] = scaleConstructor;
      this.defaults[type] = helpers$1.clone(scaleDefaults);
    },
    getScaleConstructor: function (type) {
      return this.constructors.hasOwnProperty(type) ? this.constructors[type] : undefined;
    },
    getScaleDefaults: function (type) {
      // Return the scale defaults merged with the global settings so that we always use the latest ones
      return this.defaults.hasOwnProperty(type) ? helpers$1.merge({}, [core_defaults.scale, this.defaults[type]]) : {};
    },
    updateScaleDefaults: function (type, additions) {
      var me = this;

      if (me.defaults.hasOwnProperty(type)) {
        me.defaults[type] = helpers$1.extend(me.defaults[type], additions);
      }
    },
    addScalesToLayout: function (chart) {
      // Adds each scale to the chart.boxes array to be sized accordingly
      helpers$1.each(chart.scales, function (scale) {
        // Set ILayoutItem parameters for backwards compatibility
        scale.fullWidth = scale.options.fullWidth;
        scale.position = scale.options.position;
        scale.weight = scale.options.weight;
        core_layouts.addBox(chart, scale);
      });
    }
  };
  var valueOrDefault$7 = helpers$1.valueOrDefault;

  core_defaults._set('global', {
    tooltips: {
      enabled: true,
      custom: null,
      mode: 'nearest',
      position: 'average',
      intersect: true,
      backgroundColor: 'rgba(0,0,0,0.8)',
      titleFontStyle: 'bold',
      titleSpacing: 2,
      titleMarginBottom: 6,
      titleFontColor: '#fff',
      titleAlign: 'left',
      bodySpacing: 2,
      bodyFontColor: '#fff',
      bodyAlign: 'left',
      footerFontStyle: 'bold',
      footerSpacing: 2,
      footerMarginTop: 6,
      footerFontColor: '#fff',
      footerAlign: 'left',
      yPadding: 6,
      xPadding: 6,
      caretPadding: 2,
      caretSize: 5,
      cornerRadius: 6,
      multiKeyBackground: '#fff',
      displayColors: true,
      borderColor: 'rgba(0,0,0,0)',
      borderWidth: 0,
      callbacks: {
        // Args are: (tooltipItems, data)
        beforeTitle: helpers$1.noop,
        title: function (tooltipItems, data) {
          var title = '';
          var labels = data.labels;
          var labelCount = labels ? labels.length : 0;

          if (tooltipItems.length > 0) {
            var item = tooltipItems[0];

            if (item.label) {
              title = item.label;
            } else if (item.xLabel) {
              title = item.xLabel;
            } else if (labelCount > 0 && item.index < labelCount) {
              title = labels[item.index];
            }
          }

          return title;
        },
        afterTitle: helpers$1.noop,
        // Args are: (tooltipItems, data)
        beforeBody: helpers$1.noop,
        // Args are: (tooltipItem, data)
        beforeLabel: helpers$1.noop,
        label: function (tooltipItem, data) {
          var label = data.datasets[tooltipItem.datasetIndex].label || '';

          if (label) {
            label += ': ';
          }

          if (!helpers$1.isNullOrUndef(tooltipItem.value)) {
            label += tooltipItem.value;
          } else {
            label += tooltipItem.yLabel;
          }

          return label;
        },
        labelColor: function (tooltipItem, chart) {
          var meta = chart.getDatasetMeta(tooltipItem.datasetIndex);
          var activeElement = meta.data[tooltipItem.index];
          var view = activeElement._view;
          return {
            borderColor: view.borderColor,
            backgroundColor: view.backgroundColor
          };
        },
        labelTextColor: function () {
          return this._options.bodyFontColor;
        },
        afterLabel: helpers$1.noop,
        // Args are: (tooltipItems, data)
        afterBody: helpers$1.noop,
        // Args are: (tooltipItems, data)
        beforeFooter: helpers$1.noop,
        footer: helpers$1.noop,
        afterFooter: helpers$1.noop
      }
    }
  });

  var positioners = {
    /**
     * Average mode places the tooltip at the average position of the elements shown
     * @function Chart.Tooltip.positioners.average
     * @param elements {ChartElement[]} the elements being displayed in the tooltip
     * @returns {object} tooltip position
     */
    average: function (elements) {
      if (!elements.length) {
        return false;
      }

      var i, len;
      var x = 0;
      var y = 0;
      var count = 0;

      for (i = 0, len = elements.length; i < len; ++i) {
        var el = elements[i];

        if (el && el.hasValue()) {
          var pos = el.tooltipPosition();
          x += pos.x;
          y += pos.y;
          ++count;
        }
      }

      return {
        x: x / count,
        y: y / count
      };
    },

    /**
     * Gets the tooltip position nearest of the item nearest to the event position
     * @function Chart.Tooltip.positioners.nearest
     * @param elements {Chart.Element[]} the tooltip elements
     * @param eventPosition {object} the position of the event in canvas coordinates
     * @returns {object} the tooltip position
     */
    nearest: function (elements, eventPosition) {
      var x = eventPosition.x;
      var y = eventPosition.y;
      var minDistance = Number.POSITIVE_INFINITY;
      var i, len, nearestElement;

      for (i = 0, len = elements.length; i < len; ++i) {
        var el = elements[i];

        if (el && el.hasValue()) {
          var center = el.getCenterPoint();
          var d = helpers$1.distanceBetweenPoints(eventPosition, center);

          if (d < minDistance) {
            minDistance = d;
            nearestElement = el;
          }
        }
      }

      if (nearestElement) {
        var tp = nearestElement.tooltipPosition();
        x = tp.x;
        y = tp.y;
      }

      return {
        x: x,
        y: y
      };
    }
  }; // Helper to push or concat based on if the 2nd parameter is an array or not

  function pushOrConcat(base, toPush) {
    if (toPush) {
      if (helpers$1.isArray(toPush)) {
        // base = base.concat(toPush);
        Array.prototype.push.apply(base, toPush);
      } else {
        base.push(toPush);
      }
    }

    return base;
  }
  /**
   * Returns array of strings split by newline
   * @param {string} value - The value to split by newline.
   * @returns {string[]} value if newline present - Returned from String split() method
   * @function
   */


  function splitNewlines(str) {
    if ((typeof str === 'string' || str instanceof String) && str.indexOf('\n') > -1) {
      return str.split('\n');
    }

    return str;
  }
  /**
   * Private helper to create a tooltip item model
   * @param element - the chart element (point, arc, bar) to create the tooltip item for
   * @return new tooltip item
   */


  function createTooltipItem(element) {
    var xScale = element._xScale;
    var yScale = element._yScale || element._scale; // handle radar || polarArea charts

    var index = element._index;
    var datasetIndex = element._datasetIndex;

    var controller = element._chart.getDatasetMeta(datasetIndex).controller;

    var indexScale = controller._getIndexScale();

    var valueScale = controller._getValueScale();

    return {
      xLabel: xScale ? xScale.getLabelForIndex(index, datasetIndex) : '',
      yLabel: yScale ? yScale.getLabelForIndex(index, datasetIndex) : '',
      label: indexScale ? '' + indexScale.getLabelForIndex(index, datasetIndex) : '',
      value: valueScale ? '' + valueScale.getLabelForIndex(index, datasetIndex) : '',
      index: index,
      datasetIndex: datasetIndex,
      x: element._model.x,
      y: element._model.y
    };
  }
  /**
   * Helper to get the reset model for the tooltip
   * @param tooltipOpts {object} the tooltip options
   */


  function getBaseModel(tooltipOpts) {
    var globalDefaults = core_defaults.global;
    return {
      // Positioning
      xPadding: tooltipOpts.xPadding,
      yPadding: tooltipOpts.yPadding,
      xAlign: tooltipOpts.xAlign,
      yAlign: tooltipOpts.yAlign,
      // Body
      bodyFontColor: tooltipOpts.bodyFontColor,
      _bodyFontFamily: valueOrDefault$7(tooltipOpts.bodyFontFamily, globalDefaults.defaultFontFamily),
      _bodyFontStyle: valueOrDefault$7(tooltipOpts.bodyFontStyle, globalDefaults.defaultFontStyle),
      _bodyAlign: tooltipOpts.bodyAlign,
      bodyFontSize: valueOrDefault$7(tooltipOpts.bodyFontSize, globalDefaults.defaultFontSize),
      bodySpacing: tooltipOpts.bodySpacing,
      // Title
      titleFontColor: tooltipOpts.titleFontColor,
      _titleFontFamily: valueOrDefault$7(tooltipOpts.titleFontFamily, globalDefaults.defaultFontFamily),
      _titleFontStyle: valueOrDefault$7(tooltipOpts.titleFontStyle, globalDefaults.defaultFontStyle),
      titleFontSize: valueOrDefault$7(tooltipOpts.titleFontSize, globalDefaults.defaultFontSize),
      _titleAlign: tooltipOpts.titleAlign,
      titleSpacing: tooltipOpts.titleSpacing,
      titleMarginBottom: tooltipOpts.titleMarginBottom,
      // Footer
      footerFontColor: tooltipOpts.footerFontColor,
      _footerFontFamily: valueOrDefault$7(tooltipOpts.footerFontFamily, globalDefaults.defaultFontFamily),
      _footerFontStyle: valueOrDefault$7(tooltipOpts.footerFontStyle, globalDefaults.defaultFontStyle),
      footerFontSize: valueOrDefault$7(tooltipOpts.footerFontSize, globalDefaults.defaultFontSize),
      _footerAlign: tooltipOpts.footerAlign,
      footerSpacing: tooltipOpts.footerSpacing,
      footerMarginTop: tooltipOpts.footerMarginTop,
      // Appearance
      caretSize: tooltipOpts.caretSize,
      cornerRadius: tooltipOpts.cornerRadius,
      backgroundColor: tooltipOpts.backgroundColor,
      opacity: 0,
      legendColorBackground: tooltipOpts.multiKeyBackground,
      displayColors: tooltipOpts.displayColors,
      borderColor: tooltipOpts.borderColor,
      borderWidth: tooltipOpts.borderWidth
    };
  }
  /**
   * Get the size of the tooltip
   */


  function getTooltipSize(tooltip, model) {
    var ctx = tooltip._chart.ctx;
    var height = model.yPadding * 2; // Tooltip Padding

    var width = 0; // Count of all lines in the body

    var body = model.body;
    var combinedBodyLength = body.reduce(function (count, bodyItem) {
      return count + bodyItem.before.length + bodyItem.lines.length + bodyItem.after.length;
    }, 0);
    combinedBodyLength += model.beforeBody.length + model.afterBody.length;
    var titleLineCount = model.title.length;
    var footerLineCount = model.footer.length;
    var titleFontSize = model.titleFontSize;
    var bodyFontSize = model.bodyFontSize;
    var footerFontSize = model.footerFontSize;
    height += titleLineCount * titleFontSize; // Title Lines

    height += titleLineCount ? (titleLineCount - 1) * model.titleSpacing : 0; // Title Line Spacing

    height += titleLineCount ? model.titleMarginBottom : 0; // Title's bottom Margin

    height += combinedBodyLength * bodyFontSize; // Body Lines

    height += combinedBodyLength ? (combinedBodyLength - 1) * model.bodySpacing : 0; // Body Line Spacing

    height += footerLineCount ? model.footerMarginTop : 0; // Footer Margin

    height += footerLineCount * footerFontSize; // Footer Lines

    height += footerLineCount ? (footerLineCount - 1) * model.footerSpacing : 0; // Footer Line Spacing
    // Title width

    var widthPadding = 0;

    var maxLineWidth = function (line) {
      width = Math.max(width, ctx.measureText(line).width + widthPadding);
    };

    ctx.font = helpers$1.fontString(titleFontSize, model._titleFontStyle, model._titleFontFamily);
    helpers$1.each(model.title, maxLineWidth); // Body width

    ctx.font = helpers$1.fontString(bodyFontSize, model._bodyFontStyle, model._bodyFontFamily);
    helpers$1.each(model.beforeBody.concat(model.afterBody), maxLineWidth); // Body lines may include some extra width due to the color box

    widthPadding = model.displayColors ? bodyFontSize + 2 : 0;
    helpers$1.each(body, function (bodyItem) {
      helpers$1.each(bodyItem.before, maxLineWidth);
      helpers$1.each(bodyItem.lines, maxLineWidth);
      helpers$1.each(bodyItem.after, maxLineWidth);
    }); // Reset back to 0

    widthPadding = 0; // Footer width

    ctx.font = helpers$1.fontString(footerFontSize, model._footerFontStyle, model._footerFontFamily);
    helpers$1.each(model.footer, maxLineWidth); // Add padding

    width += 2 * model.xPadding;
    return {
      width: width,
      height: height
    };
  }
  /**
   * Helper to get the alignment of a tooltip given the size
   */


  function determineAlignment(tooltip, size) {
    var model = tooltip._model;
    var chart = tooltip._chart;
    var chartArea = tooltip._chart.chartArea;
    var xAlign = 'center';
    var yAlign = 'center';

    if (model.y < size.height) {
      yAlign = 'top';
    } else if (model.y > chart.height - size.height) {
      yAlign = 'bottom';
    }

    var lf, rf; // functions to determine left, right alignment

    var olf, orf; // functions to determine if left/right alignment causes tooltip to go outside chart

    var yf; // function to get the y alignment if the tooltip goes outside of the left or right edges

    var midX = (chartArea.left + chartArea.right) / 2;
    var midY = (chartArea.top + chartArea.bottom) / 2;

    if (yAlign === 'center') {
      lf = function (x) {
        return x <= midX;
      };

      rf = function (x) {
        return x > midX;
      };
    } else {
      lf = function (x) {
        return x <= size.width / 2;
      };

      rf = function (x) {
        return x >= chart.width - size.width / 2;
      };
    }

    olf = function (x) {
      return x + size.width + model.caretSize + model.caretPadding > chart.width;
    };

    orf = function (x) {
      return x - size.width - model.caretSize - model.caretPadding < 0;
    };

    yf = function (y) {
      return y <= midY ? 'top' : 'bottom';
    };

    if (lf(model.x)) {
      xAlign = 'left'; // Is tooltip too wide and goes over the right side of the chart.?

      if (olf(model.x)) {
        xAlign = 'center';
        yAlign = yf(model.y);
      }
    } else if (rf(model.x)) {
      xAlign = 'right'; // Is tooltip too wide and goes outside left edge of canvas?

      if (orf(model.x)) {
        xAlign = 'center';
        yAlign = yf(model.y);
      }
    }

    var opts = tooltip._options;
    return {
      xAlign: opts.xAlign ? opts.xAlign : xAlign,
      yAlign: opts.yAlign ? opts.yAlign : yAlign
    };
  }
  /**
   * Helper to get the location a tooltip needs to be placed at given the initial position (via the vm) and the size and alignment
   */


  function getBackgroundPoint(vm, size, alignment, chart) {
    // Background Position
    var x = vm.x;
    var y = vm.y;
    var caretSize = vm.caretSize;
    var caretPadding = vm.caretPadding;
    var cornerRadius = vm.cornerRadius;
    var xAlign = alignment.xAlign;
    var yAlign = alignment.yAlign;
    var paddingAndSize = caretSize + caretPadding;
    var radiusAndPadding = cornerRadius + caretPadding;

    if (xAlign === 'right') {
      x -= size.width;
    } else if (xAlign === 'center') {
      x -= size.width / 2;

      if (x + size.width > chart.width) {
        x = chart.width - size.width;
      }

      if (x < 0) {
        x = 0;
      }
    }

    if (yAlign === 'top') {
      y += paddingAndSize;
    } else if (yAlign === 'bottom') {
      y -= size.height + paddingAndSize;
    } else {
      y -= size.height / 2;
    }

    if (yAlign === 'center') {
      if (xAlign === 'left') {
        x += paddingAndSize;
      } else if (xAlign === 'right') {
        x -= paddingAndSize;
      }
    } else if (xAlign === 'left') {
      x -= radiusAndPadding;
    } else if (xAlign === 'right') {
      x += radiusAndPadding;
    }

    return {
      x: x,
      y: y
    };
  }

  function getAlignedX(vm, align) {
    return align === 'center' ? vm.x + vm.width / 2 : align === 'right' ? vm.x + vm.width - vm.xPadding : vm.x + vm.xPadding;
  }
  /**
   * Helper to build before and after body lines
   */


  function getBeforeAfterBodyLines(callback) {
    return pushOrConcat([], splitNewlines(callback));
  }

  var exports$3 = core_element.extend({
    initialize: function () {
      this._model = getBaseModel(this._options);
      this._lastActive = [];
    },
    // Get the title
    // Args are: (tooltipItem, data)
    getTitle: function () {
      var me = this;
      var opts = me._options;
      var callbacks = opts.callbacks;
      var beforeTitle = callbacks.beforeTitle.apply(me, arguments);
      var title = callbacks.title.apply(me, arguments);
      var afterTitle = callbacks.afterTitle.apply(me, arguments);
      var lines = [];
      lines = pushOrConcat(lines, splitNewlines(beforeTitle));
      lines = pushOrConcat(lines, splitNewlines(title));
      lines = pushOrConcat(lines, splitNewlines(afterTitle));
      return lines;
    },
    // Args are: (tooltipItem, data)
    getBeforeBody: function () {
      return getBeforeAfterBodyLines(this._options.callbacks.beforeBody.apply(this, arguments));
    },
    // Args are: (tooltipItem, data)
    getBody: function (tooltipItems, data) {
      var me = this;
      var callbacks = me._options.callbacks;
      var bodyItems = [];
      helpers$1.each(tooltipItems, function (tooltipItem) {
        var bodyItem = {
          before: [],
          lines: [],
          after: []
        };
        pushOrConcat(bodyItem.before, splitNewlines(callbacks.beforeLabel.call(me, tooltipItem, data)));
        pushOrConcat(bodyItem.lines, callbacks.label.call(me, tooltipItem, data));
        pushOrConcat(bodyItem.after, splitNewlines(callbacks.afterLabel.call(me, tooltipItem, data)));
        bodyItems.push(bodyItem);
      });
      return bodyItems;
    },
    // Args are: (tooltipItem, data)
    getAfterBody: function () {
      return getBeforeAfterBodyLines(this._options.callbacks.afterBody.apply(this, arguments));
    },
    // Get the footer and beforeFooter and afterFooter lines
    // Args are: (tooltipItem, data)
    getFooter: function () {
      var me = this;
      var callbacks = me._options.callbacks;
      var beforeFooter = callbacks.beforeFooter.apply(me, arguments);
      var footer = callbacks.footer.apply(me, arguments);
      var afterFooter = callbacks.afterFooter.apply(me, arguments);
      var lines = [];
      lines = pushOrConcat(lines, splitNewlines(beforeFooter));
      lines = pushOrConcat(lines, splitNewlines(footer));
      lines = pushOrConcat(lines, splitNewlines(afterFooter));
      return lines;
    },
    update: function (changed) {
      var me = this;
      var opts = me._options; // Need to regenerate the model because its faster than using extend and it is necessary due to the optimization in Chart.Element.transition
      // that does _view = _model if ease === 1. This causes the 2nd tooltip update to set properties in both the view and model at the same time
      // which breaks any animations.

      var existingModel = me._model;
      var model = me._model = getBaseModel(opts);
      var active = me._active;
      var data = me._data; // In the case where active.length === 0 we need to keep these at existing values for good animations

      var alignment = {
        xAlign: existingModel.xAlign,
        yAlign: existingModel.yAlign
      };
      var backgroundPoint = {
        x: existingModel.x,
        y: existingModel.y
      };
      var tooltipSize = {
        width: existingModel.width,
        height: existingModel.height
      };
      var tooltipPosition = {
        x: existingModel.caretX,
        y: existingModel.caretY
      };
      var i, len;

      if (active.length) {
        model.opacity = 1;
        var labelColors = [];
        var labelTextColors = [];
        tooltipPosition = positioners[opts.position].call(me, active, me._eventPosition);
        var tooltipItems = [];

        for (i = 0, len = active.length; i < len; ++i) {
          tooltipItems.push(createTooltipItem(active[i]));
        } // If the user provided a filter function, use it to modify the tooltip items


        if (opts.filter) {
          tooltipItems = tooltipItems.filter(function (a) {
            return opts.filter(a, data);
          });
        } // If the user provided a sorting function, use it to modify the tooltip items


        if (opts.itemSort) {
          tooltipItems = tooltipItems.sort(function (a, b) {
            return opts.itemSort(a, b, data);
          });
        } // Determine colors for boxes


        helpers$1.each(tooltipItems, function (tooltipItem) {
          labelColors.push(opts.callbacks.labelColor.call(me, tooltipItem, me._chart));
          labelTextColors.push(opts.callbacks.labelTextColor.call(me, tooltipItem, me._chart));
        }); // Build the Text Lines

        model.title = me.getTitle(tooltipItems, data);
        model.beforeBody = me.getBeforeBody(tooltipItems, data);
        model.body = me.getBody(tooltipItems, data);
        model.afterBody = me.getAfterBody(tooltipItems, data);
        model.footer = me.getFooter(tooltipItems, data); // Initial positioning and colors

        model.x = tooltipPosition.x;
        model.y = tooltipPosition.y;
        model.caretPadding = opts.caretPadding;
        model.labelColors = labelColors;
        model.labelTextColors = labelTextColors; // data points

        model.dataPoints = tooltipItems; // We need to determine alignment of the tooltip

        tooltipSize = getTooltipSize(this, model);
        alignment = determineAlignment(this, tooltipSize); // Final Size and Position

        backgroundPoint = getBackgroundPoint(model, tooltipSize, alignment, me._chart);
      } else {
        model.opacity = 0;
      }

      model.xAlign = alignment.xAlign;
      model.yAlign = alignment.yAlign;
      model.x = backgroundPoint.x;
      model.y = backgroundPoint.y;
      model.width = tooltipSize.width;
      model.height = tooltipSize.height; // Point where the caret on the tooltip points to

      model.caretX = tooltipPosition.x;
      model.caretY = tooltipPosition.y;
      me._model = model;

      if (changed && opts.custom) {
        opts.custom.call(me, model);
      }

      return me;
    },
    drawCaret: function (tooltipPoint, size) {
      var ctx = this._chart.ctx;
      var vm = this._view;
      var caretPosition = this.getCaretPosition(tooltipPoint, size, vm);
      ctx.lineTo(caretPosition.x1, caretPosition.y1);
      ctx.lineTo(caretPosition.x2, caretPosition.y2);
      ctx.lineTo(caretPosition.x3, caretPosition.y3);
    },
    getCaretPosition: function (tooltipPoint, size, vm) {
      var x1, x2, x3, y1, y2, y3;
      var caretSize = vm.caretSize;
      var cornerRadius = vm.cornerRadius;
      var xAlign = vm.xAlign;
      var yAlign = vm.yAlign;
      var ptX = tooltipPoint.x;
      var ptY = tooltipPoint.y;
      var width = size.width;
      var height = size.height;

      if (yAlign === 'center') {
        y2 = ptY + height / 2;

        if (xAlign === 'left') {
          x1 = ptX;
          x2 = x1 - caretSize;
          x3 = x1;
          y1 = y2 + caretSize;
          y3 = y2 - caretSize;
        } else {
          x1 = ptX + width;
          x2 = x1 + caretSize;
          x3 = x1;
          y1 = y2 - caretSize;
          y3 = y2 + caretSize;
        }
      } else {
        if (xAlign === 'left') {
          x2 = ptX + cornerRadius + caretSize;
          x1 = x2 - caretSize;
          x3 = x2 + caretSize;
        } else if (xAlign === 'right') {
          x2 = ptX + width - cornerRadius - caretSize;
          x1 = x2 - caretSize;
          x3 = x2 + caretSize;
        } else {
          x2 = vm.caretX;
          x1 = x2 - caretSize;
          x3 = x2 + caretSize;
        }

        if (yAlign === 'top') {
          y1 = ptY;
          y2 = y1 - caretSize;
          y3 = y1;
        } else {
          y1 = ptY + height;
          y2 = y1 + caretSize;
          y3 = y1; // invert drawing order

          var tmp = x3;
          x3 = x1;
          x1 = tmp;
        }
      }

      return {
        x1: x1,
        x2: x2,
        x3: x3,
        y1: y1,
        y2: y2,
        y3: y3
      };
    },
    drawTitle: function (pt, vm, ctx) {
      var title = vm.title;

      if (title.length) {
        pt.x = getAlignedX(vm, vm._titleAlign);
        ctx.textAlign = vm._titleAlign;
        ctx.textBaseline = 'top';
        var titleFontSize = vm.titleFontSize;
        var titleSpacing = vm.titleSpacing;
        ctx.fillStyle = vm.titleFontColor;
        ctx.font = helpers$1.fontString(titleFontSize, vm._titleFontStyle, vm._titleFontFamily);
        var i, len;

        for (i = 0, len = title.length; i < len; ++i) {
          ctx.fillText(title[i], pt.x, pt.y);
          pt.y += titleFontSize + titleSpacing; // Line Height and spacing

          if (i + 1 === title.length) {
            pt.y += vm.titleMarginBottom - titleSpacing; // If Last, add margin, remove spacing
          }
        }
      }
    },
    drawBody: function (pt, vm, ctx) {
      var bodyFontSize = vm.bodyFontSize;
      var bodySpacing = vm.bodySpacing;
      var bodyAlign = vm._bodyAlign;
      var body = vm.body;
      var drawColorBoxes = vm.displayColors;
      var labelColors = vm.labelColors;
      var xLinePadding = 0;
      var colorX = drawColorBoxes ? getAlignedX(vm, 'left') : 0;
      var textColor;
      ctx.textAlign = bodyAlign;
      ctx.textBaseline = 'top';
      ctx.font = helpers$1.fontString(bodyFontSize, vm._bodyFontStyle, vm._bodyFontFamily);
      pt.x = getAlignedX(vm, bodyAlign); // Before Body

      var fillLineOfText = function (line) {
        ctx.fillText(line, pt.x + xLinePadding, pt.y);
        pt.y += bodyFontSize + bodySpacing;
      }; // Before body lines


      ctx.fillStyle = vm.bodyFontColor;
      helpers$1.each(vm.beforeBody, fillLineOfText);
      xLinePadding = drawColorBoxes && bodyAlign !== 'right' ? bodyAlign === 'center' ? bodyFontSize / 2 + 1 : bodyFontSize + 2 : 0; // Draw body lines now

      helpers$1.each(body, function (bodyItem, i) {
        textColor = vm.labelTextColors[i];
        ctx.fillStyle = textColor;
        helpers$1.each(bodyItem.before, fillLineOfText);
        helpers$1.each(bodyItem.lines, function (line) {
          // Draw Legend-like boxes if needed
          if (drawColorBoxes) {
            // Fill a white rect so that colours merge nicely if the opacity is < 1
            ctx.fillStyle = vm.legendColorBackground;
            ctx.fillRect(colorX, pt.y, bodyFontSize, bodyFontSize); // Border

            ctx.lineWidth = 1;
            ctx.strokeStyle = labelColors[i].borderColor;
            ctx.strokeRect(colorX, pt.y, bodyFontSize, bodyFontSize); // Inner square

            ctx.fillStyle = labelColors[i].backgroundColor;
            ctx.fillRect(colorX + 1, pt.y + 1, bodyFontSize - 2, bodyFontSize - 2);
            ctx.fillStyle = textColor;
          }

          fillLineOfText(line);
        });
        helpers$1.each(bodyItem.after, fillLineOfText);
      }); // Reset back to 0 for after body

      xLinePadding = 0; // After body lines

      helpers$1.each(vm.afterBody, fillLineOfText);
      pt.y -= bodySpacing; // Remove last body spacing
    },
    drawFooter: function (pt, vm, ctx) {
      var footer = vm.footer;

      if (footer.length) {
        pt.x = getAlignedX(vm, vm._footerAlign);
        pt.y += vm.footerMarginTop;
        ctx.textAlign = vm._footerAlign;
        ctx.textBaseline = 'top';
        ctx.fillStyle = vm.footerFontColor;
        ctx.font = helpers$1.fontString(vm.footerFontSize, vm._footerFontStyle, vm._footerFontFamily);
        helpers$1.each(footer, function (line) {
          ctx.fillText(line, pt.x, pt.y);
          pt.y += vm.footerFontSize + vm.footerSpacing;
        });
      }
    },
    drawBackground: function (pt, vm, ctx, tooltipSize) {
      ctx.fillStyle = vm.backgroundColor;
      ctx.strokeStyle = vm.borderColor;
      ctx.lineWidth = vm.borderWidth;
      var xAlign = vm.xAlign;
      var yAlign = vm.yAlign;
      var x = pt.x;
      var y = pt.y;
      var width = tooltipSize.width;
      var height = tooltipSize.height;
      var radius = vm.cornerRadius;
      ctx.beginPath();
      ctx.moveTo(x + radius, y);

      if (yAlign === 'top') {
        this.drawCaret(pt, tooltipSize);
      }

      ctx.lineTo(x + width - radius, y);
      ctx.quadraticCurveTo(x + width, y, x + width, y + radius);

      if (yAlign === 'center' && xAlign === 'right') {
        this.drawCaret(pt, tooltipSize);
      }

      ctx.lineTo(x + width, y + height - radius);
      ctx.quadraticCurveTo(x + width, y + height, x + width - radius, y + height);

      if (yAlign === 'bottom') {
        this.drawCaret(pt, tooltipSize);
      }

      ctx.lineTo(x + radius, y + height);
      ctx.quadraticCurveTo(x, y + height, x, y + height - radius);

      if (yAlign === 'center' && xAlign === 'left') {
        this.drawCaret(pt, tooltipSize);
      }

      ctx.lineTo(x, y + radius);
      ctx.quadraticCurveTo(x, y, x + radius, y);
      ctx.closePath();
      ctx.fill();

      if (vm.borderWidth > 0) {
        ctx.stroke();
      }
    },
    draw: function () {
      var ctx = this._chart.ctx;
      var vm = this._view;

      if (vm.opacity === 0) {
        return;
      }

      var tooltipSize = {
        width: vm.width,
        height: vm.height
      };
      var pt = {
        x: vm.x,
        y: vm.y
      }; // IE11/Edge does not like very small opacities, so snap to 0

      var opacity = Math.abs(vm.opacity < 1e-3) ? 0 : vm.opacity; // Truthy/falsey value for empty tooltip

      var hasTooltipContent = vm.title.length || vm.beforeBody.length || vm.body.length || vm.afterBody.length || vm.footer.length;

      if (this._options.enabled && hasTooltipContent) {
        ctx.save();
        ctx.globalAlpha = opacity; // Draw Background

        this.drawBackground(pt, vm, ctx, tooltipSize); // Draw Title, Body, and Footer

        pt.y += vm.yPadding; // Titles

        this.drawTitle(pt, vm, ctx); // Body

        this.drawBody(pt, vm, ctx); // Footer

        this.drawFooter(pt, vm, ctx);
        ctx.restore();
      }
    },

    /**
     * Handle an event
     * @private
     * @param {IEvent} event - The event to handle
     * @returns {boolean} true if the tooltip changed
     */
    handleEvent: function (e) {
      var me = this;
      var options = me._options;
      var changed = false;
      me._lastActive = me._lastActive || []; // Find Active Elements for tooltips

      if (e.type === 'mouseout') {
        me._active = [];
      } else {
        me._active = me._chart.getElementsAtEventForMode(e, options.mode, options);
      } // Remember Last Actives


      changed = !helpers$1.arrayEquals(me._active, me._lastActive); // Only handle target event on tooltip change

      if (changed) {
        me._lastActive = me._active;

        if (options.enabled || options.custom) {
          me._eventPosition = {
            x: e.x,
            y: e.y
          };
          me.update(true);
          me.pivot();
        }
      }

      return changed;
    }
  });
  /**
   * @namespace Chart.Tooltip.positioners
   */

  var positioners_1 = positioners;
  var core_tooltip = exports$3;
  core_tooltip.positioners = positioners_1;
  var valueOrDefault$8 = helpers$1.valueOrDefault;

  core_defaults._set('global', {
    elements: {},
    events: ['mousemove', 'mouseout', 'click', 'touchstart', 'touchmove'],
    hover: {
      onHover: null,
      mode: 'nearest',
      intersect: true,
      animationDuration: 400
    },
    onClick: null,
    maintainAspectRatio: true,
    responsive: true,
    responsiveAnimationDuration: 0
  });
  /**
   * Recursively merge the given config objects representing the `scales` option
   * by incorporating scale defaults in `xAxes` and `yAxes` array items, then
   * returns a deep copy of the result, thus doesn't alter inputs.
   */


  function mergeScaleConfig()
  /* config objects ... */
  {
    return helpers$1.merge({}, [].slice.call(arguments), {
      merger: function (key, target, source, options) {
        if (key === 'xAxes' || key === 'yAxes') {
          var slen = source[key].length;
          var i, type, scale;

          if (!target[key]) {
            target[key] = [];
          }

          for (i = 0; i < slen; ++i) {
            scale = source[key][i];
            type = valueOrDefault$8(scale.type, key === 'xAxes' ? 'category' : 'linear');

            if (i >= target[key].length) {
              target[key].push({});
            }

            if (!target[key][i].type || scale.type && scale.type !== target[key][i].type) {
              // new/untyped scale or type changed: let's apply the new defaults
              // then merge source scale to correctly overwrite the defaults.
              helpers$1.merge(target[key][i], [core_scaleService.getScaleDefaults(type), scale]);
            } else {
              // scales type are the same
              helpers$1.merge(target[key][i], scale);
            }
          }
        } else {
          helpers$1._merger(key, target, source, options);
        }
      }
    });
  }
  /**
   * Recursively merge the given config objects as the root options by handling
   * default scale options for the `scales` and `scale` properties, then returns
   * a deep copy of the result, thus doesn't alter inputs.
   */


  function mergeConfig()
  /* config objects ... */
  {
    return helpers$1.merge({}, [].slice.call(arguments), {
      merger: function (key, target, source, options) {
        var tval = target[key] || {};
        var sval = source[key];

        if (key === 'scales') {
          // scale config merging is complex. Add our own function here for that
          target[key] = mergeScaleConfig(tval, sval);
        } else if (key === 'scale') {
          // used in polar area & radar charts since there is only one scale
          target[key] = helpers$1.merge(tval, [core_scaleService.getScaleDefaults(sval.type), sval]);
        } else {
          helpers$1._merger(key, target, source, options);
        }
      }
    });
  }

  function initConfig(config) {
    config = config || {}; // Do NOT use mergeConfig for the data object because this method merges arrays
    // and so would change references to labels and datasets, preventing data updates.

    var data = config.data = config.data || {};
    data.datasets = data.datasets || [];
    data.labels = data.labels || [];
    config.options = mergeConfig(core_defaults.global, core_defaults[config.type], config.options || {});
    return config;
  }

  function updateConfig(chart) {
    var newOptions = chart.options;
    helpers$1.each(chart.scales, function (scale) {
      core_layouts.removeBox(chart, scale);
    });
    newOptions = mergeConfig(core_defaults.global, core_defaults[chart.config.type], newOptions);
    chart.options = chart.config.options = newOptions;
    chart.ensureScalesHaveIDs();
    chart.buildOrUpdateScales(); // Tooltip

    chart.tooltip._options = newOptions.tooltips;
    chart.tooltip.initialize();
  }

  function positionIsHorizontal(position) {
    return position === 'top' || position === 'bottom';
  }

  var Chart = function (item, config) {
    this.construct(item, config);
    return this;
  };

  helpers$1.extend(Chart.prototype,
  /** @lends Chart */
  {
    /**
     * @private
     */
    construct: function (item, config) {
      var me = this;
      config = initConfig(config);
      var context = platform.acquireContext(item, config);
      var canvas = context && context.canvas;
      var height = canvas && canvas.height;
      var width = canvas && canvas.width;
      me.id = helpers$1.uid();
      me.ctx = context;
      me.canvas = canvas;
      me.config = config;
      me.width = width;
      me.height = height;
      me.aspectRatio = height ? width / height : null;
      me.options = config.options;
      me._bufferedRender = false;
      /**
       * Provided for backward compatibility, Chart and Chart.Controller have been merged,
       * the "instance" still need to be defined since it might be called from plugins.
       * @prop Chart#chart
       * @deprecated since version 2.6.0
       * @todo remove at version 3
       * @private
       */

      me.chart = me;
      me.controller = me; // chart.chart.controller #inception
      // Add the chart instance to the global namespace

      Chart.instances[me.id] = me; // Define alias to the config data: `chart.data === chart.config.data`

      Object.defineProperty(me, 'data', {
        get: function () {
          return me.config.data;
        },
        set: function (value) {
          me.config.data = value;
        }
      });

      if (!context || !canvas) {
        // The given item is not a compatible context2d element, let's return before finalizing
        // the chart initialization but after setting basic chart / controller properties that
        // can help to figure out that the chart is not valid (e.g chart.canvas !== null);
        // https://github.com/chartjs/Chart.js/issues/2807
        console.error("Failed to create chart: can't acquire context from the given item");
        return;
      }

      me.initialize();
      me.update();
    },

    /**
     * @private
     */
    initialize: function () {
      var me = this; // Before init plugin notification

      core_plugins.notify(me, 'beforeInit');
      helpers$1.retinaScale(me, me.options.devicePixelRatio);
      me.bindEvents();

      if (me.options.responsive) {
        // Initial resize before chart draws (must be silent to preserve initial animations).
        me.resize(true);
      } // Make sure scales have IDs and are built before we build any controllers.


      me.ensureScalesHaveIDs();
      me.buildOrUpdateScales();
      me.initToolTip(); // After init plugin notification

      core_plugins.notify(me, 'afterInit');
      return me;
    },
    clear: function () {
      helpers$1.canvas.clear(this);
      return this;
    },
    stop: function () {
      // Stops any current animation loop occurring
      core_animations.cancelAnimation(this);
      return this;
    },
    resize: function (silent) {
      var me = this;
      var options = me.options;
      var canvas = me.canvas;
      var aspectRatio = options.maintainAspectRatio && me.aspectRatio || null; // the canvas render width and height will be casted to integers so make sure that
      // the canvas display style uses the same integer values to avoid blurring effect.
      // Set to 0 instead of canvas.size because the size defaults to 300x150 if the element is collapsed

      var newWidth = Math.max(0, Math.floor(helpers$1.getMaximumWidth(canvas)));
      var newHeight = Math.max(0, Math.floor(aspectRatio ? newWidth / aspectRatio : helpers$1.getMaximumHeight(canvas)));

      if (me.width === newWidth && me.height === newHeight) {
        return;
      }

      canvas.width = me.width = newWidth;
      canvas.height = me.height = newHeight;
      canvas.style.width = newWidth + 'px';
      canvas.style.height = newHeight + 'px';
      helpers$1.retinaScale(me, options.devicePixelRatio);

      if (!silent) {
        // Notify any plugins about the resize
        var newSize = {
          width: newWidth,
          height: newHeight
        };
        core_plugins.notify(me, 'resize', [newSize]); // Notify of resize

        if (options.onResize) {
          options.onResize(me, newSize);
        }

        me.stop();
        me.update({
          duration: options.responsiveAnimationDuration
        });
      }
    },
    ensureScalesHaveIDs: function () {
      var options = this.options;
      var scalesOptions = options.scales || {};
      var scaleOptions = options.scale;
      helpers$1.each(scalesOptions.xAxes, function (xAxisOptions, index) {
        xAxisOptions.id = xAxisOptions.id || 'x-axis-' + index;
      });
      helpers$1.each(scalesOptions.yAxes, function (yAxisOptions, index) {
        yAxisOptions.id = yAxisOptions.id || 'y-axis-' + index;
      });

      if (scaleOptions) {
        scaleOptions.id = scaleOptions.id || 'scale';
      }
    },

    /**
     * Builds a map of scale ID to scale object for future lookup.
     */
    buildOrUpdateScales: function () {
      var me = this;
      var options = me.options;
      var scales = me.scales || {};
      var items = [];
      var updated = Object.keys(scales).reduce(function (obj, id) {
        obj[id] = false;
        return obj;
      }, {});

      if (options.scales) {
        items = items.concat((options.scales.xAxes || []).map(function (xAxisOptions) {
          return {
            options: xAxisOptions,
            dtype: 'category',
            dposition: 'bottom'
          };
        }), (options.scales.yAxes || []).map(function (yAxisOptions) {
          return {
            options: yAxisOptions,
            dtype: 'linear',
            dposition: 'left'
          };
        }));
      }

      if (options.scale) {
        items.push({
          options: options.scale,
          dtype: 'radialLinear',
          isDefault: true,
          dposition: 'chartArea'
        });
      }

      helpers$1.each(items, function (item) {
        var scaleOptions = item.options;
        var id = scaleOptions.id;
        var scaleType = valueOrDefault$8(scaleOptions.type, item.dtype);

        if (positionIsHorizontal(scaleOptions.position) !== positionIsHorizontal(item.dposition)) {
          scaleOptions.position = item.dposition;
        }

        updated[id] = true;
        var scale = null;

        if (id in scales && scales[id].type === scaleType) {
          scale = scales[id];
          scale.options = scaleOptions;
          scale.ctx = me.ctx;
          scale.chart = me;
        } else {
          var scaleClass = core_scaleService.getScaleConstructor(scaleType);

          if (!scaleClass) {
            return;
          }

          scale = new scaleClass({
            id: id,
            type: scaleType,
            options: scaleOptions,
            ctx: me.ctx,
            chart: me
          });
          scales[scale.id] = scale;
        }

        scale.mergeTicksOptions(); // TODO(SB): I think we should be able to remove this custom case (options.scale)
        // and consider it as a regular scale part of the "scales"" map only! This would
        // make the logic easier and remove some useless? custom code.

        if (item.isDefault) {
          me.scale = scale;
        }
      }); // clear up discarded scales

      helpers$1.each(updated, function (hasUpdated, id) {
        if (!hasUpdated) {
          delete scales[id];
        }
      });
      me.scales = scales;
      core_scaleService.addScalesToLayout(this);
    },
    buildOrUpdateControllers: function () {
      var me = this;
      var newControllers = [];
      helpers$1.each(me.data.datasets, function (dataset, datasetIndex) {
        var meta = me.getDatasetMeta(datasetIndex);
        var type = dataset.type || me.config.type;

        if (meta.type && meta.type !== type) {
          me.destroyDatasetMeta(datasetIndex);
          meta = me.getDatasetMeta(datasetIndex);
        }

        meta.type = type;

        if (meta.controller) {
          meta.controller.updateIndex(datasetIndex);
          meta.controller.linkScales();
        } else {
          var ControllerClass = controllers[meta.type];

          if (ControllerClass === undefined) {
            throw new Error('"' + meta.type + '" is not a chart type.');
          }

          meta.controller = new ControllerClass(me, datasetIndex);
          newControllers.push(meta.controller);
        }
      }, me);
      return newControllers;
    },

    /**
     * Reset the elements of all datasets
     * @private
     */
    resetElements: function () {
      var me = this;
      helpers$1.each(me.data.datasets, function (dataset, datasetIndex) {
        me.getDatasetMeta(datasetIndex).controller.reset();
      }, me);
    },

    /**
    * Resets the chart back to it's state before the initial animation
    */
    reset: function () {
      this.resetElements();
      this.tooltip.initialize();
    },
    update: function (config) {
      var me = this;

      if (!config || typeof config !== 'object') {
        // backwards compatibility
        config = {
          duration: config,
          lazy: arguments[1]
        };
      }

      updateConfig(me); // plugins options references might have change, let's invalidate the cache
      // https://github.com/chartjs/Chart.js/issues/5111#issuecomment-355934167

      core_plugins._invalidate(me);

      if (core_plugins.notify(me, 'beforeUpdate') === false) {
        return;
      } // In case the entire data object changed


      me.tooltip._data = me.data; // Make sure dataset controllers are updated and new controllers are reset

      var newControllers = me.buildOrUpdateControllers(); // Make sure all dataset controllers have correct meta data counts

      helpers$1.each(me.data.datasets, function (dataset, datasetIndex) {
        me.getDatasetMeta(datasetIndex).controller.buildOrUpdateElements();
      }, me);
      me.updateLayout(); // Can only reset the new controllers after the scales have been updated

      if (me.options.animation && me.options.animation.duration) {
        helpers$1.each(newControllers, function (controller) {
          controller.reset();
        });
      }

      me.updateDatasets(); // Need to reset tooltip in case it is displayed with elements that are removed
      // after update.

      me.tooltip.initialize(); // Last active contains items that were previously in the tooltip.
      // When we reset the tooltip, we need to clear it

      me.lastActive = []; // Do this before render so that any plugins that need final scale updates can use it

      core_plugins.notify(me, 'afterUpdate');

      if (me._bufferedRender) {
        me._bufferedRequest = {
          duration: config.duration,
          easing: config.easing,
          lazy: config.lazy
        };
      } else {
        me.render(config);
      }
    },

    /**
     * Updates the chart layout unless a plugin returns `false` to the `beforeLayout`
     * hook, in which case, plugins will not be called on `afterLayout`.
     * @private
     */
    updateLayout: function () {
      var me = this;

      if (core_plugins.notify(me, 'beforeLayout') === false) {
        return;
      }

      core_layouts.update(this, this.width, this.height);
      /**
       * Provided for backward compatibility, use `afterLayout` instead.
       * @method IPlugin#afterScaleUpdate
       * @deprecated since version 2.5.0
       * @todo remove at version 3
       * @private
       */

      core_plugins.notify(me, 'afterScaleUpdate');
      core_plugins.notify(me, 'afterLayout');
    },

    /**
     * Updates all datasets unless a plugin returns `false` to the `beforeDatasetsUpdate`
     * hook, in which case, plugins will not be called on `afterDatasetsUpdate`.
     * @private
     */
    updateDatasets: function () {
      var me = this;

      if (core_plugins.notify(me, 'beforeDatasetsUpdate') === false) {
        return;
      }

      for (var i = 0, ilen = me.data.datasets.length; i < ilen; ++i) {
        me.updateDataset(i);
      }

      core_plugins.notify(me, 'afterDatasetsUpdate');
    },

    /**
     * Updates dataset at index unless a plugin returns `false` to the `beforeDatasetUpdate`
     * hook, in which case, plugins will not be called on `afterDatasetUpdate`.
     * @private
     */
    updateDataset: function (index) {
      var me = this;
      var meta = me.getDatasetMeta(index);
      var args = {
        meta: meta,
        index: index
      };

      if (core_plugins.notify(me, 'beforeDatasetUpdate', [args]) === false) {
        return;
      }

      meta.controller.update();
      core_plugins.notify(me, 'afterDatasetUpdate', [args]);
    },
    render: function (config) {
      var me = this;

      if (!config || typeof config !== 'object') {
        // backwards compatibility
        config = {
          duration: config,
          lazy: arguments[1]
        };
      }

      var animationOptions = me.options.animation;
      var duration = valueOrDefault$8(config.duration, animationOptions && animationOptions.duration);
      var lazy = config.lazy;

      if (core_plugins.notify(me, 'beforeRender') === false) {
        return;
      }

      var onComplete = function (animation) {
        core_plugins.notify(me, 'afterRender');
        helpers$1.callback(animationOptions && animationOptions.onComplete, [animation], me);
      };

      if (animationOptions && duration) {
        var animation = new core_animation({
          numSteps: duration / 16.66,
          // 60 fps
          easing: config.easing || animationOptions.easing,
          render: function (chart, animationObject) {
            var easingFunction = helpers$1.easing.effects[animationObject.easing];
            var currentStep = animationObject.currentStep;
            var stepDecimal = currentStep / animationObject.numSteps;
            chart.draw(easingFunction(stepDecimal), stepDecimal, currentStep);
          },
          onAnimationProgress: animationOptions.onProgress,
          onAnimationComplete: onComplete
        });
        core_animations.addAnimation(me, animation, duration, lazy);
      } else {
        me.draw(); // See https://github.com/chartjs/Chart.js/issues/3781

        onComplete(new core_animation({
          numSteps: 0,
          chart: me
        }));
      }

      return me;
    },
    draw: function (easingValue) {
      var me = this;
      me.clear();

      if (helpers$1.isNullOrUndef(easingValue)) {
        easingValue = 1;
      }

      me.transition(easingValue);

      if (me.width <= 0 || me.height <= 0) {
        return;
      }

      if (core_plugins.notify(me, 'beforeDraw', [easingValue]) === false) {
        return;
      } // Draw all the scales


      helpers$1.each(me.boxes, function (box) {
        box.draw(me.chartArea);
      }, me);
      me.drawDatasets(easingValue);

      me._drawTooltip(easingValue);

      core_plugins.notify(me, 'afterDraw', [easingValue]);
    },

    /**
     * @private
     */
    transition: function (easingValue) {
      var me = this;

      for (var i = 0, ilen = (me.data.datasets || []).length; i < ilen; ++i) {
        if (me.isDatasetVisible(i)) {
          me.getDatasetMeta(i).controller.transition(easingValue);
        }
      }

      me.tooltip.transition(easingValue);
    },

    /**
     * Draws all datasets unless a plugin returns `false` to the `beforeDatasetsDraw`
     * hook, in which case, plugins will not be called on `afterDatasetsDraw`.
     * @private
     */
    drawDatasets: function (easingValue) {
      var me = this;

      if (core_plugins.notify(me, 'beforeDatasetsDraw', [easingValue]) === false) {
        return;
      } // Draw datasets reversed to support proper line stacking


      for (var i = (me.data.datasets || []).length - 1; i >= 0; --i) {
        if (me.isDatasetVisible(i)) {
          me.drawDataset(i, easingValue);
        }
      }

      core_plugins.notify(me, 'afterDatasetsDraw', [easingValue]);
    },

    /**
     * Draws dataset at index unless a plugin returns `false` to the `beforeDatasetDraw`
     * hook, in which case, plugins will not be called on `afterDatasetDraw`.
     * @private
     */
    drawDataset: function (index, easingValue) {
      var me = this;
      var meta = me.getDatasetMeta(index);
      var args = {
        meta: meta,
        index: index,
        easingValue: easingValue
      };

      if (core_plugins.notify(me, 'beforeDatasetDraw', [args]) === false) {
        return;
      }

      meta.controller.draw(easingValue);
      core_plugins.notify(me, 'afterDatasetDraw', [args]);
    },

    /**
     * Draws tooltip unless a plugin returns `false` to the `beforeTooltipDraw`
     * hook, in which case, plugins will not be called on `afterTooltipDraw`.
     * @private
     */
    _drawTooltip: function (easingValue) {
      var me = this;
      var tooltip = me.tooltip;
      var args = {
        tooltip: tooltip,
        easingValue: easingValue
      };

      if (core_plugins.notify(me, 'beforeTooltipDraw', [args]) === false) {
        return;
      }

      tooltip.draw();
      core_plugins.notify(me, 'afterTooltipDraw', [args]);
    },

    /**
     * Get the single element that was clicked on
     * @return An object containing the dataset index and element index of the matching element. Also contains the rectangle that was draw
     */
    getElementAtEvent: function (e) {
      return core_interaction.modes.single(this, e);
    },
    getElementsAtEvent: function (e) {
      return core_interaction.modes.label(this, e, {
        intersect: true
      });
    },
    getElementsAtXAxis: function (e) {
      return core_interaction.modes['x-axis'](this, e, {
        intersect: true
      });
    },
    getElementsAtEventForMode: function (e, mode, options) {
      var method = core_interaction.modes[mode];

      if (typeof method === 'function') {
        return method(this, e, options);
      }

      return [];
    },
    getDatasetAtEvent: function (e) {
      return core_interaction.modes.dataset(this, e, {
        intersect: true
      });
    },
    getDatasetMeta: function (datasetIndex) {
      var me = this;
      var dataset = me.data.datasets[datasetIndex];

      if (!dataset._meta) {
        dataset._meta = {};
      }

      var meta = dataset._meta[me.id];

      if (!meta) {
        meta = dataset._meta[me.id] = {
          type: null,
          data: [],
          dataset: null,
          controller: null,
          hidden: null,
          // See isDatasetVisible() comment
          xAxisID: null,
          yAxisID: null
        };
      }

      return meta;
    },
    getVisibleDatasetCount: function () {
      var count = 0;

      for (var i = 0, ilen = this.data.datasets.length; i < ilen; ++i) {
        if (this.isDatasetVisible(i)) {
          count++;
        }
      }

      return count;
    },
    isDatasetVisible: function (datasetIndex) {
      var meta = this.getDatasetMeta(datasetIndex); // meta.hidden is a per chart dataset hidden flag override with 3 states: if true or false,
      // the dataset.hidden value is ignored, else if null, the dataset hidden state is returned.

      return typeof meta.hidden === 'boolean' ? !meta.hidden : !this.data.datasets[datasetIndex].hidden;
    },
    generateLegend: function () {
      return this.options.legendCallback(this);
    },

    /**
     * @private
     */
    destroyDatasetMeta: function (datasetIndex) {
      var id = this.id;
      var dataset = this.data.datasets[datasetIndex];
      var meta = dataset._meta && dataset._meta[id];

      if (meta) {
        meta.controller.destroy();
        delete dataset._meta[id];
      }
    },
    destroy: function () {
      var me = this;
      var canvas = me.canvas;
      var i, ilen;
      me.stop(); // dataset controllers need to cleanup associated data

      for (i = 0, ilen = me.data.datasets.length; i < ilen; ++i) {
        me.destroyDatasetMeta(i);
      }

      if (canvas) {
        me.unbindEvents();
        helpers$1.canvas.clear(me);
        platform.releaseContext(me.ctx);
        me.canvas = null;
        me.ctx = null;
      }

      core_plugins.notify(me, 'destroy');
      delete Chart.instances[me.id];
    },
    toBase64Image: function () {
      return this.canvas.toDataURL.apply(this.canvas, arguments);
    },
    initToolTip: function () {
      var me = this;
      me.tooltip = new core_tooltip({
        _chart: me,
        _chartInstance: me,
        // deprecated, backward compatibility
        _data: me.data,
        _options: me.options.tooltips
      }, me);
    },

    /**
     * @private
     */
    bindEvents: function () {
      var me = this;
      var listeners = me._listeners = {};

      var listener = function () {
        me.eventHandler.apply(me, arguments);
      };

      helpers$1.each(me.options.events, function (type) {
        platform.addEventListener(me, type, listener);
        listeners[type] = listener;
      }); // Elements used to detect size change should not be injected for non responsive charts.
      // See https://github.com/chartjs/Chart.js/issues/2210

      if (me.options.responsive) {
        listener = function () {
          me.resize();
        };

        platform.addEventListener(me, 'resize', listener);
        listeners.resize = listener;
      }
    },

    /**
     * @private
     */
    unbindEvents: function () {
      var me = this;
      var listeners = me._listeners;

      if (!listeners) {
        return;
      }

      delete me._listeners;
      helpers$1.each(listeners, function (listener, type) {
        platform.removeEventListener(me, type, listener);
      });
    },
    updateHoverStyle: function (elements, mode, enabled) {
      var method = enabled ? 'setHoverStyle' : 'removeHoverStyle';
      var element, i, ilen;

      for (i = 0, ilen = elements.length; i < ilen; ++i) {
        element = elements[i];

        if (element) {
          this.getDatasetMeta(element._datasetIndex).controller[method](element);
        }
      }
    },

    /**
     * @private
     */
    eventHandler: function (e) {
      var me = this;
      var tooltip = me.tooltip;

      if (core_plugins.notify(me, 'beforeEvent', [e]) === false) {
        return;
      } // Buffer any update calls so that renders do not occur


      me._bufferedRender = true;
      me._bufferedRequest = null;
      var changed = me.handleEvent(e); // for smooth tooltip animations issue #4989
      // the tooltip should be the source of change
      // Animation check workaround:
      // tooltip._start will be null when tooltip isn't animating

      if (tooltip) {
        changed = tooltip._start ? tooltip.handleEvent(e) : changed | tooltip.handleEvent(e);
      }

      core_plugins.notify(me, 'afterEvent', [e]);
      var bufferedRequest = me._bufferedRequest;

      if (bufferedRequest) {
        // If we have an update that was triggered, we need to do a normal render
        me.render(bufferedRequest);
      } else if (changed && !me.animating) {
        // If entering, leaving, or changing elements, animate the change via pivot
        me.stop(); // We only need to render at this point. Updating will cause scales to be
        // recomputed generating flicker & using more memory than necessary.

        me.render({
          duration: me.options.hover.animationDuration,
          lazy: true
        });
      }

      me._bufferedRender = false;
      me._bufferedRequest = null;
      return me;
    },

    /**
     * Handle an event
     * @private
     * @param {IEvent} event the event to handle
     * @return {boolean} true if the chart needs to re-render
     */
    handleEvent: function (e) {
      var me = this;
      var options = me.options || {};
      var hoverOptions = options.hover;
      var changed = false;
      me.lastActive = me.lastActive || []; // Find Active Elements for hover and tooltips

      if (e.type === 'mouseout') {
        me.active = [];
      } else {
        me.active = me.getElementsAtEventForMode(e, hoverOptions.mode, hoverOptions);
      } // Invoke onHover hook
      // Need to call with native event here to not break backwards compatibility


      helpers$1.callback(options.onHover || options.hover.onHover, [e.native, me.active], me);

      if (e.type === 'mouseup' || e.type === 'click') {
        if (options.onClick) {
          // Use e.native here for backwards compatibility
          options.onClick.call(me, e.native, me.active);
        }
      } // Remove styling for last active (even if it may still be active)


      if (me.lastActive.length) {
        me.updateHoverStyle(me.lastActive, hoverOptions.mode, false);
      } // Built in hover styling


      if (me.active.length && hoverOptions.mode) {
        me.updateHoverStyle(me.active, hoverOptions.mode, true);
      }

      changed = !helpers$1.arrayEquals(me.active, me.lastActive); // Remember Last Actives

      me.lastActive = me.active;
      return changed;
    }
  });
  /**
   * NOTE(SB) We actually don't use this container anymore but we need to keep it
   * for backward compatibility. Though, it can still be useful for plugins that
   * would need to work on multiple charts?!
   */

  Chart.instances = {};
  var core_controller = Chart; // DEPRECATIONS

  /**
   * Provided for backward compatibility, use Chart instead.
   * @class Chart.Controller
   * @deprecated since version 2.6
   * @todo remove at version 3
   * @private
   */

  Chart.Controller = Chart;
  /**
   * Provided for backward compatibility, not available anymore.
   * @namespace Chart
   * @deprecated since version 2.8
   * @todo remove at version 3
   * @private
   */

  Chart.types = {};
  /**
   * Provided for backward compatibility, not available anymore.
   * @namespace Chart.helpers.configMerge
   * @deprecated since version 2.8.0
   * @todo remove at version 3
   * @private
   */

  helpers$1.configMerge = mergeConfig;
  /**
   * Provided for backward compatibility, not available anymore.
   * @namespace Chart.helpers.scaleMerge
   * @deprecated since version 2.8.0
   * @todo remove at version 3
   * @private
   */

  helpers$1.scaleMerge = mergeScaleConfig;

  var core_helpers = function () {
    // -- Basic js utility methods
    helpers$1.where = function (collection, filterCallback) {
      if (helpers$1.isArray(collection) && Array.prototype.filter) {
        return collection.filter(filterCallback);
      }

      var filtered = [];
      helpers$1.each(collection, function (item) {
        if (filterCallback(item)) {
          filtered.push(item);
        }
      });
      return filtered;
    };

    helpers$1.findIndex = Array.prototype.findIndex ? function (array, callback, scope) {
      return array.findIndex(callback, scope);
    } : function (array, callback, scope) {
      scope = scope === undefined ? array : scope;

      for (var i = 0, ilen = array.length; i < ilen; ++i) {
        if (callback.call(scope, array[i], i, array)) {
          return i;
        }
      }

      return -1;
    };

    helpers$1.findNextWhere = function (arrayToSearch, filterCallback, startIndex) {
      // Default to start of the array
      if (helpers$1.isNullOrUndef(startIndex)) {
        startIndex = -1;
      }

      for (var i = startIndex + 1; i < arrayToSearch.length; i++) {
        var currentItem = arrayToSearch[i];

        if (filterCallback(currentItem)) {
          return currentItem;
        }
      }
    };

    helpers$1.findPreviousWhere = function (arrayToSearch, filterCallback, startIndex) {
      // Default to end of the array
      if (helpers$1.isNullOrUndef(startIndex)) {
        startIndex = arrayToSearch.length;
      }

      for (var i = startIndex - 1; i >= 0; i--) {
        var currentItem = arrayToSearch[i];

        if (filterCallback(currentItem)) {
          return currentItem;
        }
      }
    }; // -- Math methods


    helpers$1.isNumber = function (n) {
      return !isNaN(parseFloat(n)) && isFinite(n);
    };

    helpers$1.almostEquals = function (x, y, epsilon) {
      return Math.abs(x - y) < epsilon;
    };

    helpers$1.almostWhole = function (x, epsilon) {
      var rounded = Math.round(x);
      return rounded - epsilon < x && rounded + epsilon > x;
    };

    helpers$1.max = function (array) {
      return array.reduce(function (max, value) {
        if (!isNaN(value)) {
          return Math.max(max, value);
        }

        return max;
      }, Number.NEGATIVE_INFINITY);
    };

    helpers$1.min = function (array) {
      return array.reduce(function (min, value) {
        if (!isNaN(value)) {
          return Math.min(min, value);
        }

        return min;
      }, Number.POSITIVE_INFINITY);
    };

    helpers$1.sign = Math.sign ? function (x) {
      return Math.sign(x);
    } : function (x) {
      x = +x; // convert to a number

      if (x === 0 || isNaN(x)) {
        return x;
      }

      return x > 0 ? 1 : -1;
    };
    helpers$1.log10 = Math.log10 ? function (x) {
      return Math.log10(x);
    } : function (x) {
      var exponent = Math.log(x) * Math.LOG10E; // Math.LOG10E = 1 / Math.LN10.
      // Check for whole powers of 10,
      // which due to floating point rounding error should be corrected.

      var powerOf10 = Math.round(exponent);
      var isPowerOf10 = x === Math.pow(10, powerOf10);
      return isPowerOf10 ? powerOf10 : exponent;
    };

    helpers$1.toRadians = function (degrees) {
      return degrees * (Math.PI / 180);
    };

    helpers$1.toDegrees = function (radians) {
      return radians * (180 / Math.PI);
    };
    /**
     * Returns the number of decimal places
     * i.e. the number of digits after the decimal point, of the value of this Number.
     * @param {number} x - A number.
     * @returns {number} The number of decimal places.
     * @private
     */


    helpers$1._decimalPlaces = function (x) {
      if (!helpers$1.isFinite(x)) {
        return;
      }

      var e = 1;
      var p = 0;

      while (Math.round(x * e) / e !== x) {
        e *= 10;
        p++;
      }

      return p;
    }; // Gets the angle from vertical upright to the point about a centre.


    helpers$1.getAngleFromPoint = function (centrePoint, anglePoint) {
      var distanceFromXCenter = anglePoint.x - centrePoint.x;
      var distanceFromYCenter = anglePoint.y - centrePoint.y;
      var radialDistanceFromCenter = Math.sqrt(distanceFromXCenter * distanceFromXCenter + distanceFromYCenter * distanceFromYCenter);
      var angle = Math.atan2(distanceFromYCenter, distanceFromXCenter);

      if (angle < -0.5 * Math.PI) {
        angle += 2.0 * Math.PI; // make sure the returned angle is in the range of (-PI/2, 3PI/2]
      }

      return {
        angle: angle,
        distance: radialDistanceFromCenter
      };
    };

    helpers$1.distanceBetweenPoints = function (pt1, pt2) {
      return Math.sqrt(Math.pow(pt2.x - pt1.x, 2) + Math.pow(pt2.y - pt1.y, 2));
    };
    /**
     * Provided for backward compatibility, not available anymore
     * @function Chart.helpers.aliasPixel
     * @deprecated since version 2.8.0
     * @todo remove at version 3
     */


    helpers$1.aliasPixel = function (pixelWidth) {
      return pixelWidth % 2 === 0 ? 0 : 0.5;
    };
    /**
     * Returns the aligned pixel value to avoid anti-aliasing blur
     * @param {Chart} chart - The chart instance.
     * @param {number} pixel - A pixel value.
     * @param {number} width - The width of the element.
     * @returns {number} The aligned pixel value.
     * @private
     */


    helpers$1._alignPixel = function (chart, pixel, width) {
      var devicePixelRatio = chart.currentDevicePixelRatio;
      var halfWidth = width / 2;
      return Math.round((pixel - halfWidth) * devicePixelRatio) / devicePixelRatio + halfWidth;
    };

    helpers$1.splineCurve = function (firstPoint, middlePoint, afterPoint, t) {
      // Props to Rob Spencer at scaled innovation for his post on splining between points
      // http://scaledinnovation.com/analytics/splines/aboutSplines.html
      // This function must also respect "skipped" points
      var previous = firstPoint.skip ? middlePoint : firstPoint;
      var current = middlePoint;
      var next = afterPoint.skip ? middlePoint : afterPoint;
      var d01 = Math.sqrt(Math.pow(current.x - previous.x, 2) + Math.pow(current.y - previous.y, 2));
      var d12 = Math.sqrt(Math.pow(next.x - current.x, 2) + Math.pow(next.y - current.y, 2));
      var s01 = d01 / (d01 + d12);
      var s12 = d12 / (d01 + d12); // If all points are the same, s01 & s02 will be inf

      s01 = isNaN(s01) ? 0 : s01;
      s12 = isNaN(s12) ? 0 : s12;
      var fa = t * s01; // scaling factor for triangle Ta

      var fb = t * s12;
      return {
        previous: {
          x: current.x - fa * (next.x - previous.x),
          y: current.y - fa * (next.y - previous.y)
        },
        next: {
          x: current.x + fb * (next.x - previous.x),
          y: current.y + fb * (next.y - previous.y)
        }
      };
    };

    helpers$1.EPSILON = Number.EPSILON || 1e-14;

    helpers$1.splineCurveMonotone = function (points) {
      // This function calculates Bézier control points in a similar way than |splineCurve|,
      // but preserves monotonicity of the provided data and ensures no local extremums are added
      // between the dataset discrete points due to the interpolation.
      // See : https://en.wikipedia.org/wiki/Monotone_cubic_interpolation
      var pointsWithTangents = (points || []).map(function (point) {
        return {
          model: point._model,
          deltaK: 0,
          mK: 0
        };
      }); // Calculate slopes (deltaK) and initialize tangents (mK)

      var pointsLen = pointsWithTangents.length;
      var i, pointBefore, pointCurrent, pointAfter;

      for (i = 0; i < pointsLen; ++i) {
        pointCurrent = pointsWithTangents[i];

        if (pointCurrent.model.skip) {
          continue;
        }

        pointBefore = i > 0 ? pointsWithTangents[i - 1] : null;
        pointAfter = i < pointsLen - 1 ? pointsWithTangents[i + 1] : null;

        if (pointAfter && !pointAfter.model.skip) {
          var slopeDeltaX = pointAfter.model.x - pointCurrent.model.x; // In the case of two points that appear at the same x pixel, slopeDeltaX is 0

          pointCurrent.deltaK = slopeDeltaX !== 0 ? (pointAfter.model.y - pointCurrent.model.y) / slopeDeltaX : 0;
        }

        if (!pointBefore || pointBefore.model.skip) {
          pointCurrent.mK = pointCurrent.deltaK;
        } else if (!pointAfter || pointAfter.model.skip) {
          pointCurrent.mK = pointBefore.deltaK;
        } else if (this.sign(pointBefore.deltaK) !== this.sign(pointCurrent.deltaK)) {
          pointCurrent.mK = 0;
        } else {
          pointCurrent.mK = (pointBefore.deltaK + pointCurrent.deltaK) / 2;
        }
      } // Adjust tangents to ensure monotonic properties


      var alphaK, betaK, tauK, squaredMagnitude;

      for (i = 0; i < pointsLen - 1; ++i) {
        pointCurrent = pointsWithTangents[i];
        pointAfter = pointsWithTangents[i + 1];

        if (pointCurrent.model.skip || pointAfter.model.skip) {
          continue;
        }

        if (helpers$1.almostEquals(pointCurrent.deltaK, 0, this.EPSILON)) {
          pointCurrent.mK = pointAfter.mK = 0;
          continue;
        }

        alphaK = pointCurrent.mK / pointCurrent.deltaK;
        betaK = pointAfter.mK / pointCurrent.deltaK;
        squaredMagnitude = Math.pow(alphaK, 2) + Math.pow(betaK, 2);

        if (squaredMagnitude <= 9) {
          continue;
        }

        tauK = 3 / Math.sqrt(squaredMagnitude);
        pointCurrent.mK = alphaK * tauK * pointCurrent.deltaK;
        pointAfter.mK = betaK * tauK * pointCurrent.deltaK;
      } // Compute control points


      var deltaX;

      for (i = 0; i < pointsLen; ++i) {
        pointCurrent = pointsWithTangents[i];

        if (pointCurrent.model.skip) {
          continue;
        }

        pointBefore = i > 0 ? pointsWithTangents[i - 1] : null;
        pointAfter = i < pointsLen - 1 ? pointsWithTangents[i + 1] : null;

        if (pointBefore && !pointBefore.model.skip) {
          deltaX = (pointCurrent.model.x - pointBefore.model.x) / 3;
          pointCurrent.model.controlPointPreviousX = pointCurrent.model.x - deltaX;
          pointCurrent.model.controlPointPreviousY = pointCurrent.model.y - deltaX * pointCurrent.mK;
        }

        if (pointAfter && !pointAfter.model.skip) {
          deltaX = (pointAfter.model.x - pointCurrent.model.x) / 3;
          pointCurrent.model.controlPointNextX = pointCurrent.model.x + deltaX;
          pointCurrent.model.controlPointNextY = pointCurrent.model.y + deltaX * pointCurrent.mK;
        }
      }
    };

    helpers$1.nextItem = function (collection, index, loop) {
      if (loop) {
        return index >= collection.length - 1 ? collection[0] : collection[index + 1];
      }

      return index >= collection.length - 1 ? collection[collection.length - 1] : collection[index + 1];
    };

    helpers$1.previousItem = function (collection, index, loop) {
      if (loop) {
        return index <= 0 ? collection[collection.length - 1] : collection[index - 1];
      }

      return index <= 0 ? collection[0] : collection[index - 1];
    }; // Implementation of the nice number algorithm used in determining where axis labels will go


    helpers$1.niceNum = function (range, round) {
      var exponent = Math.floor(helpers$1.log10(range));
      var fraction = range / Math.pow(10, exponent);
      var niceFraction;

      if (round) {
        if (fraction < 1.5) {
          niceFraction = 1;
        } else if (fraction < 3) {
          niceFraction = 2;
        } else if (fraction < 7) {
          niceFraction = 5;
        } else {
          niceFraction = 10;
        }
      } else if (fraction <= 1.0) {
        niceFraction = 1;
      } else if (fraction <= 2) {
        niceFraction = 2;
      } else if (fraction <= 5) {
        niceFraction = 5;
      } else {
        niceFraction = 10;
      }

      return niceFraction * Math.pow(10, exponent);
    }; // Request animation polyfill - https://www.paulirish.com/2011/requestanimationframe-for-smart-animating/


    helpers$1.requestAnimFrame = function () {
      if (typeof window === 'undefined') {
        return function (callback) {
          callback();
        };
      }

      return window.requestAnimationFrame || window.webkitRequestAnimationFrame || window.mozRequestAnimationFrame || window.oRequestAnimationFrame || window.msRequestAnimationFrame || function (callback) {
        return window.setTimeout(callback, 1000 / 60);
      };
    }(); // -- DOM methods


    helpers$1.getRelativePosition = function (evt, chart) {
      var mouseX, mouseY;
      var e = evt.originalEvent || evt;
      var canvas = evt.target || evt.srcElement;
      var boundingRect = canvas.getBoundingClientRect();
      var touches = e.touches;

      if (touches && touches.length > 0) {
        mouseX = touches[0].clientX;
        mouseY = touches[0].clientY;
      } else {
        mouseX = e.clientX;
        mouseY = e.clientY;
      } // Scale mouse coordinates into canvas coordinates
      // by following the pattern laid out by 'jerryj' in the comments of
      // https://www.html5canvastutorials.com/advanced/html5-canvas-mouse-coordinates/


      var paddingLeft = parseFloat(helpers$1.getStyle(canvas, 'padding-left'));
      var paddingTop = parseFloat(helpers$1.getStyle(canvas, 'padding-top'));
      var paddingRight = parseFloat(helpers$1.getStyle(canvas, 'padding-right'));
      var paddingBottom = parseFloat(helpers$1.getStyle(canvas, 'padding-bottom'));
      var width = boundingRect.right - boundingRect.left - paddingLeft - paddingRight;
      var height = boundingRect.bottom - boundingRect.top - paddingTop - paddingBottom; // We divide by the current device pixel ratio, because the canvas is scaled up by that amount in each direction. However
      // the backend model is in unscaled coordinates. Since we are going to deal with our model coordinates, we go back here

      mouseX = Math.round((mouseX - boundingRect.left - paddingLeft) / width * canvas.width / chart.currentDevicePixelRatio);
      mouseY = Math.round((mouseY - boundingRect.top - paddingTop) / height * canvas.height / chart.currentDevicePixelRatio);
      return {
        x: mouseX,
        y: mouseY
      };
    }; // Private helper function to convert max-width/max-height values that may be percentages into a number


    function parseMaxStyle(styleValue, node, parentProperty) {
      var valueInPixels;

      if (typeof styleValue === 'string') {
        valueInPixels = parseInt(styleValue, 10);

        if (styleValue.indexOf('%') !== -1) {
          // percentage * size in dimension
          valueInPixels = valueInPixels / 100 * node.parentNode[parentProperty];
        }
      } else {
        valueInPixels = styleValue;
      }

      return valueInPixels;
    }
    /**
     * Returns if the given value contains an effective constraint.
     * @private
     */


    function isConstrainedValue(value) {
      return value !== undefined && value !== null && value !== 'none';
    }
    /**
     * Returns the max width or height of the given DOM node in a cross-browser compatible fashion
     * @param {HTMLElement} domNode - the node to check the constraint on
     * @param {string} maxStyle - the style that defines the maximum for the direction we are using ('max-width' / 'max-height')
     * @param {string} percentageProperty - property of parent to use when calculating width as a percentage
     * @see {@link https://www.nathanaeljones.com/blog/2013/reading-max-width-cross-browser}
     */


    function getConstraintDimension(domNode, maxStyle, percentageProperty) {
      var view = document.defaultView;

      var parentNode = helpers$1._getParentNode(domNode);

      var constrainedNode = view.getComputedStyle(domNode)[maxStyle];
      var constrainedContainer = view.getComputedStyle(parentNode)[maxStyle];
      var hasCNode = isConstrainedValue(constrainedNode);
      var hasCContainer = isConstrainedValue(constrainedContainer);
      var infinity = Number.POSITIVE_INFINITY;

      if (hasCNode || hasCContainer) {
        return Math.min(hasCNode ? parseMaxStyle(constrainedNode, domNode, percentageProperty) : infinity, hasCContainer ? parseMaxStyle(constrainedContainer, parentNode, percentageProperty) : infinity);
      }

      return 'none';
    } // returns Number or undefined if no constraint


    helpers$1.getConstraintWidth = function (domNode) {
      return getConstraintDimension(domNode, 'max-width', 'clientWidth');
    }; // returns Number or undefined if no constraint


    helpers$1.getConstraintHeight = function (domNode) {
      return getConstraintDimension(domNode, 'max-height', 'clientHeight');
    };
    /**
     * @private
    	 */


    helpers$1._calculatePadding = function (container, padding, parentDimension) {
      padding = helpers$1.getStyle(container, padding);
      return padding.indexOf('%') > -1 ? parentDimension * parseInt(padding, 10) / 100 : parseInt(padding, 10);
    };
    /**
     * @private
     */


    helpers$1._getParentNode = function (domNode) {
      var parent = domNode.parentNode;

      if (parent && parent.toString() === '[object ShadowRoot]') {
        parent = parent.host;
      }

      return parent;
    };

    helpers$1.getMaximumWidth = function (domNode) {
      var container = helpers$1._getParentNode(domNode);

      if (!container) {
        return domNode.clientWidth;
      }

      var clientWidth = container.clientWidth;

      var paddingLeft = helpers$1._calculatePadding(container, 'padding-left', clientWidth);

      var paddingRight = helpers$1._calculatePadding(container, 'padding-right', clientWidth);

      var w = clientWidth - paddingLeft - paddingRight;
      var cw = helpers$1.getConstraintWidth(domNode);
      return isNaN(cw) ? w : Math.min(w, cw);
    };

    helpers$1.getMaximumHeight = function (domNode) {
      var container = helpers$1._getParentNode(domNode);

      if (!container) {
        return domNode.clientHeight;
      }

      var clientHeight = container.clientHeight;

      var paddingTop = helpers$1._calculatePadding(container, 'padding-top', clientHeight);

      var paddingBottom = helpers$1._calculatePadding(container, 'padding-bottom', clientHeight);

      var h = clientHeight - paddingTop - paddingBottom;
      var ch = helpers$1.getConstraintHeight(domNode);
      return isNaN(ch) ? h : Math.min(h, ch);
    };

    helpers$1.getStyle = function (el, property) {
      return el.currentStyle ? el.currentStyle[property] : document.defaultView.getComputedStyle(el, null).getPropertyValue(property);
    };

    helpers$1.retinaScale = function (chart, forceRatio) {
      var pixelRatio = chart.currentDevicePixelRatio = forceRatio || typeof window !== 'undefined' && window.devicePixelRatio || 1;

      if (pixelRatio === 1) {
        return;
      }

      var canvas = chart.canvas;
      var height = chart.height;
      var width = chart.width;
      canvas.height = height * pixelRatio;
      canvas.width = width * pixelRatio;
      chart.ctx.scale(pixelRatio, pixelRatio); // If no style has been set on the canvas, the render size is used as display size,
      // making the chart visually bigger, so let's enforce it to the "correct" values.
      // See https://github.com/chartjs/Chart.js/issues/3575

      if (!canvas.style.height && !canvas.style.width) {
        canvas.style.height = height + 'px';
        canvas.style.width = width + 'px';
      }
    }; // -- Canvas methods


    helpers$1.fontString = function (pixelSize, fontStyle, fontFamily) {
      return fontStyle + ' ' + pixelSize + 'px ' + fontFamily;
    };

    helpers$1.longestText = function (ctx, font, arrayOfThings, cache) {
      cache = cache || {};
      var data = cache.data = cache.data || {};
      var gc = cache.garbageCollect = cache.garbageCollect || [];

      if (cache.font !== font) {
        data = cache.data = {};
        gc = cache.garbageCollect = [];
        cache.font = font;
      }

      ctx.font = font;
      var longest = 0;
      helpers$1.each(arrayOfThings, function (thing) {
        // Undefined strings and arrays should not be measured
        if (thing !== undefined && thing !== null && helpers$1.isArray(thing) !== true) {
          longest = helpers$1.measureText(ctx, data, gc, longest, thing);
        } else if (helpers$1.isArray(thing)) {
          // if it is an array lets measure each element
          // to do maybe simplify this function a bit so we can do this more recursively?
          helpers$1.each(thing, function (nestedThing) {
            // Undefined strings and arrays should not be measured
            if (nestedThing !== undefined && nestedThing !== null && !helpers$1.isArray(nestedThing)) {
              longest = helpers$1.measureText(ctx, data, gc, longest, nestedThing);
            }
          });
        }
      });
      var gcLen = gc.length / 2;

      if (gcLen > arrayOfThings.length) {
        for (var i = 0; i < gcLen; i++) {
          delete data[gc[i]];
        }

        gc.splice(0, gcLen);
      }

      return longest;
    };

    helpers$1.measureText = function (ctx, data, gc, longest, string) {
      var textWidth = data[string];

      if (!textWidth) {
        textWidth = data[string] = ctx.measureText(string).width;
        gc.push(string);
      }

      if (textWidth > longest) {
        longest = textWidth;
      }

      return longest;
    };

    helpers$1.numberOfLabelLines = function (arrayOfThings) {
      var numberOfLines = 1;
      helpers$1.each(arrayOfThings, function (thing) {
        if (helpers$1.isArray(thing)) {
          if (thing.length > numberOfLines) {
            numberOfLines = thing.length;
          }
        }
      });
      return numberOfLines;
    };

    helpers$1.color = !chartjsColor ? function (value) {
      console.error('Color.js not found!');
      return value;
    } : function (value) {
      /* global CanvasGradient */
      if (value instanceof CanvasGradient) {
        value = core_defaults.global.defaultColor;
      }

      return chartjsColor(value);
    };

    helpers$1.getHoverColor = function (colorValue) {
      /* global CanvasPattern */
      return colorValue instanceof CanvasPattern || colorValue instanceof CanvasGradient ? colorValue : helpers$1.color(colorValue).saturate(0.5).darken(0.1).rgbString();
    };
  };

  function abstract() {
    throw new Error('This method is not implemented: either no adapter can ' + 'be found or an incomplete integration was provided.');
  }
  /**
   * Date adapter (current used by the time scale)
   * @namespace Chart._adapters._date
   * @memberof Chart._adapters
   * @private
   */

  /**
   * Currently supported unit string values.
   * @typedef {('millisecond'|'second'|'minute'|'hour'|'day'|'week'|'month'|'quarter'|'year')}
   * @memberof Chart._adapters._date
   * @name Unit
   */

  /**
   * @class
   */


  function DateAdapter(options) {
    this.options = options || {};
  }

  helpers$1.extend(DateAdapter.prototype,
  /** @lends DateAdapter */
  {
    /**
     * Returns a map of time formats for the supported formatting units defined
     * in Unit as well as 'datetime' representing a detailed date/time string.
     * @returns {{string: string}}
     */
    formats: abstract,

    /**
     * Parses the given `value` and return the associated timestamp.
     * @param {any} value - the value to parse (usually comes from the data)
     * @param {string} [format] - the expected data format
     * @returns {(number|null)}
     * @function
     */
    parse: abstract,

    /**
     * Returns the formatted date in the specified `format` for a given `timestamp`.
     * @param {number} timestamp - the timestamp to format
     * @param {string} format - the date/time token
     * @return {string}
     * @function
     */
    format: abstract,

    /**
     * Adds the specified `amount` of `unit` to the given `timestamp`.
     * @param {number} timestamp - the input timestamp
     * @param {number} amount - the amount to add
     * @param {Unit} unit - the unit as string
     * @return {number}
     * @function
     */
    add: abstract,

    /**
     * Returns the number of `unit` between the given timestamps.
     * @param {number} max - the input timestamp (reference)
     * @param {number} min - the timestamp to substract
     * @param {Unit} unit - the unit as string
     * @return {number}
     * @function
     */
    diff: abstract,

    /**
     * Returns start of `unit` for the given `timestamp`.
     * @param {number} timestamp - the input timestamp
     * @param {Unit} unit - the unit as string
     * @param {number} [weekday] - the ISO day of the week with 1 being Monday
     * and 7 being Sunday (only needed if param *unit* is `isoWeek`).
     * @function
     */
    startOf: abstract,

    /**
     * Returns end of `unit` for the given `timestamp`.
     * @param {number} timestamp - the input timestamp
     * @param {Unit} unit - the unit as string
     * @function
     */
    endOf: abstract,
    // DEPRECATIONS

    /**
     * Provided for backward compatibility for scale.getValueForPixel(),
     * this method should be overridden only by the moment adapter.
     * @deprecated since version 2.8.0
     * @todo remove at version 3
     * @private
     */
    _create: function (value) {
      return value;
    }
  });

  DateAdapter.override = function (members) {
    helpers$1.extend(DateAdapter.prototype, members);
  };

  var _date = DateAdapter;
  var core_adapters = {
    _date: _date
  };
  /**
   * Namespace to hold static tick generation functions
   * @namespace Chart.Ticks
   */

  var core_ticks = {
    /**
     * Namespace to hold formatters for different types of ticks
     * @namespace Chart.Ticks.formatters
     */
    formatters: {
      /**
       * Formatter for value labels
       * @method Chart.Ticks.formatters.values
       * @param value the value to display
       * @return {string|string[]} the label to display
       */
      values: function (value) {
        return helpers$1.isArray(value) ? value : '' + value;
      },

      /**
       * Formatter for linear numeric ticks
       * @method Chart.Ticks.formatters.linear
       * @param tickValue {number} the value to be formatted
       * @param index {number} the position of the tickValue parameter in the ticks array
       * @param ticks {number[]} the list of ticks being converted
       * @return {string} string representation of the tickValue parameter
       */
      linear: function (tickValue, index, ticks) {
        // If we have lots of ticks, don't use the ones
        var delta = ticks.length > 3 ? ticks[2] - ticks[1] : ticks[1] - ticks[0]; // If we have a number like 2.5 as the delta, figure out how many decimal places we need

        if (Math.abs(delta) > 1) {
          if (tickValue !== Math.floor(tickValue)) {
            // not an integer
            delta = tickValue - Math.floor(tickValue);
          }
        }

        var logDelta = helpers$1.log10(Math.abs(delta));
        var tickString = '';

        if (tickValue !== 0) {
          var maxTick = Math.max(Math.abs(ticks[0]), Math.abs(ticks[ticks.length - 1]));

          if (maxTick < 1e-4) {
            // all ticks are small numbers; use scientific notation
            var logTick = helpers$1.log10(Math.abs(tickValue));
            tickString = tickValue.toExponential(Math.floor(logTick) - Math.floor(logDelta));
          } else {
            var numDecimal = -1 * Math.floor(logDelta);
            numDecimal = Math.max(Math.min(numDecimal, 20), 0); // toFixed has a max of 20 decimal places

            tickString = tickValue.toFixed(numDecimal);
          }
        } else {
          tickString = '0'; // never show decimal places for 0
        }

        return tickString;
      },
      logarithmic: function (tickValue, index, ticks) {
        var remain = tickValue / Math.pow(10, Math.floor(helpers$1.log10(tickValue)));

        if (tickValue === 0) {
          return '0';
        } else if (remain === 1 || remain === 2 || remain === 5 || index === 0 || index === ticks.length - 1) {
          return tickValue.toExponential();
        }

        return '';
      }
    }
  };
  var valueOrDefault$9 = helpers$1.valueOrDefault;
  var valueAtIndexOrDefault = helpers$1.valueAtIndexOrDefault;

  core_defaults._set('scale', {
    display: true,
    position: 'left',
    offset: false,
    // grid line settings
    gridLines: {
      display: true,
      color: 'rgba(0, 0, 0, 0.1)',
      lineWidth: 1,
      drawBorder: true,
      drawOnChartArea: true,
      drawTicks: true,
      tickMarkLength: 10,
      zeroLineWidth: 1,
      zeroLineColor: 'rgba(0,0,0,0.25)',
      zeroLineBorderDash: [],
      zeroLineBorderDashOffset: 0.0,
      offsetGridLines: false,
      borderDash: [],
      borderDashOffset: 0.0
    },
    // scale label
    scaleLabel: {
      // display property
      display: false,
      // actual label
      labelString: '',
      // top/bottom padding
      padding: {
        top: 4,
        bottom: 4
      }
    },
    // label settings
    ticks: {
      beginAtZero: false,
      minRotation: 0,
      maxRotation: 50,
      mirror: false,
      padding: 0,
      reverse: false,
      display: true,
      autoSkip: true,
      autoSkipPadding: 0,
      labelOffset: 0,
      // We pass through arrays to be rendered as multiline labels, we convert Others to strings here.
      callback: core_ticks.formatters.values,
      minor: {},
      major: {}
    }
  });

  function labelsFromTicks(ticks) {
    var labels = [];
    var i, ilen;

    for (i = 0, ilen = ticks.length; i < ilen; ++i) {
      labels.push(ticks[i].label);
    }

    return labels;
  }

  function getPixelForGridLine(scale, index, offsetGridLines) {
    var lineValue = scale.getPixelForTick(index);

    if (offsetGridLines) {
      if (scale.getTicks().length === 1) {
        lineValue -= scale.isHorizontal() ? Math.max(lineValue - scale.left, scale.right - lineValue) : Math.max(lineValue - scale.top, scale.bottom - lineValue);
      } else if (index === 0) {
        lineValue -= (scale.getPixelForTick(1) - lineValue) / 2;
      } else {
        lineValue -= (lineValue - scale.getPixelForTick(index - 1)) / 2;
      }
    }

    return lineValue;
  }

  function computeTextSize(context, tick, font) {
    return helpers$1.isArray(tick) ? helpers$1.longestText(context, font, tick) : context.measureText(tick).width;
  }

  var core_scale = core_element.extend({
    /**
     * Get the padding needed for the scale
     * @method getPadding
     * @private
     * @returns {Padding} the necessary padding
     */
    getPadding: function () {
      var me = this;
      return {
        left: me.paddingLeft || 0,
        top: me.paddingTop || 0,
        right: me.paddingRight || 0,
        bottom: me.paddingBottom || 0
      };
    },

    /**
     * Returns the scale tick objects ({label, major})
     * @since 2.7
     */
    getTicks: function () {
      return this._ticks;
    },
    // These methods are ordered by lifecyle. Utilities then follow.
    // Any function defined here is inherited by all scale types.
    // Any function can be extended by the scale type
    mergeTicksOptions: function () {
      var ticks = this.options.ticks;

      if (ticks.minor === false) {
        ticks.minor = {
          display: false
        };
      }

      if (ticks.major === false) {
        ticks.major = {
          display: false
        };
      }

      for (var key in ticks) {
        if (key !== 'major' && key !== 'minor') {
          if (typeof ticks.minor[key] === 'undefined') {
            ticks.minor[key] = ticks[key];
          }

          if (typeof ticks.major[key] === 'undefined') {
            ticks.major[key] = ticks[key];
          }
        }
      }
    },
    beforeUpdate: function () {
      helpers$1.callback(this.options.beforeUpdate, [this]);
    },
    update: function (maxWidth, maxHeight, margins) {
      var me = this;
      var i, ilen, labels, label, ticks, tick; // Update Lifecycle - Probably don't want to ever extend or overwrite this function ;)

      me.beforeUpdate(); // Absorb the master measurements

      me.maxWidth = maxWidth;
      me.maxHeight = maxHeight;
      me.margins = helpers$1.extend({
        left: 0,
        right: 0,
        top: 0,
        bottom: 0
      }, margins);
      me._maxLabelLines = 0;
      me.longestLabelWidth = 0;
      me.longestTextCache = me.longestTextCache || {}; // Dimensions

      me.beforeSetDimensions();
      me.setDimensions();
      me.afterSetDimensions(); // Data min/max

      me.beforeDataLimits();
      me.determineDataLimits();
      me.afterDataLimits(); // Ticks - `this.ticks` is now DEPRECATED!
      // Internal ticks are now stored as objects in the PRIVATE `this._ticks` member
      // and must not be accessed directly from outside this class. `this.ticks` being
      // around for long time and not marked as private, we can't change its structure
      // without unexpected breaking changes. If you need to access the scale ticks,
      // use scale.getTicks() instead.

      me.beforeBuildTicks(); // New implementations should return an array of objects but for BACKWARD COMPAT,
      // we still support no return (`this.ticks` internally set by calling this method).

      ticks = me.buildTicks() || []; // Allow modification of ticks in callback.

      ticks = me.afterBuildTicks(ticks) || ticks;
      me.beforeTickToLabelConversion(); // New implementations should return the formatted tick labels but for BACKWARD
      // COMPAT, we still support no return (`this.ticks` internally changed by calling
      // this method and supposed to contain only string values).

      labels = me.convertTicksToLabels(ticks) || me.ticks;
      me.afterTickToLabelConversion();
      me.ticks = labels; // BACKWARD COMPATIBILITY
      // IMPORTANT: from this point, we consider that `this.ticks` will NEVER change!
      // BACKWARD COMPAT: synchronize `_ticks` with labels (so potentially `this.ticks`)

      for (i = 0, ilen = labels.length; i < ilen; ++i) {
        label = labels[i];
        tick = ticks[i];

        if (!tick) {
          ticks.push(tick = {
            label: label,
            major: false
          });
        } else {
          tick.label = label;
        }
      }

      me._ticks = ticks; // Tick Rotation

      me.beforeCalculateTickRotation();
      me.calculateTickRotation();
      me.afterCalculateTickRotation(); // Fit

      me.beforeFit();
      me.fit();
      me.afterFit(); //

      me.afterUpdate();
      return me.minSize;
    },
    afterUpdate: function () {
      helpers$1.callback(this.options.afterUpdate, [this]);
    },
    //
    beforeSetDimensions: function () {
      helpers$1.callback(this.options.beforeSetDimensions, [this]);
    },
    setDimensions: function () {
      var me = this; // Set the unconstrained dimension before label rotation

      if (me.isHorizontal()) {
        // Reset position before calculating rotation
        me.width = me.maxWidth;
        me.left = 0;
        me.right = me.width;
      } else {
        me.height = me.maxHeight; // Reset position before calculating rotation

        me.top = 0;
        me.bottom = me.height;
      } // Reset padding


      me.paddingLeft = 0;
      me.paddingTop = 0;
      me.paddingRight = 0;
      me.paddingBottom = 0;
    },
    afterSetDimensions: function () {
      helpers$1.callback(this.options.afterSetDimensions, [this]);
    },
    // Data limits
    beforeDataLimits: function () {
      helpers$1.callback(this.options.beforeDataLimits, [this]);
    },
    determineDataLimits: helpers$1.noop,
    afterDataLimits: function () {
      helpers$1.callback(this.options.afterDataLimits, [this]);
    },
    //
    beforeBuildTicks: function () {
      helpers$1.callback(this.options.beforeBuildTicks, [this]);
    },
    buildTicks: helpers$1.noop,
    afterBuildTicks: function (ticks) {
      var me = this; // ticks is empty for old axis implementations here

      if (helpers$1.isArray(ticks) && ticks.length) {
        return helpers$1.callback(me.options.afterBuildTicks, [me, ticks]);
      } // Support old implementations (that modified `this.ticks` directly in buildTicks)


      me.ticks = helpers$1.callback(me.options.afterBuildTicks, [me, me.ticks]) || me.ticks;
      return ticks;
    },
    beforeTickToLabelConversion: function () {
      helpers$1.callback(this.options.beforeTickToLabelConversion, [this]);
    },
    convertTicksToLabels: function () {
      var me = this; // Convert ticks to strings

      var tickOpts = me.options.ticks;
      me.ticks = me.ticks.map(tickOpts.userCallback || tickOpts.callback, this);
    },
    afterTickToLabelConversion: function () {
      helpers$1.callback(this.options.afterTickToLabelConversion, [this]);
    },
    //
    beforeCalculateTickRotation: function () {
      helpers$1.callback(this.options.beforeCalculateTickRotation, [this]);
    },
    calculateTickRotation: function () {
      var me = this;
      var context = me.ctx;
      var tickOpts = me.options.ticks;
      var labels = labelsFromTicks(me._ticks); // Get the width of each grid by calculating the difference
      // between x offsets between 0 and 1.

      var tickFont = helpers$1.options._parseFont(tickOpts);

      context.font = tickFont.string;
      var labelRotation = tickOpts.minRotation || 0;

      if (labels.length && me.options.display && me.isHorizontal()) {
        var originalLabelWidth = helpers$1.longestText(context, tickFont.string, labels, me.longestTextCache);
        var labelWidth = originalLabelWidth;
        var cosRotation, sinRotation; // Allow 3 pixels x2 padding either side for label readability

        var tickWidth = me.getPixelForTick(1) - me.getPixelForTick(0) - 6; // Max label rotation can be set or default to 90 - also act as a loop counter

        while (labelWidth > tickWidth && labelRotation < tickOpts.maxRotation) {
          var angleRadians = helpers$1.toRadians(labelRotation);
          cosRotation = Math.cos(angleRadians);
          sinRotation = Math.sin(angleRadians);

          if (sinRotation * originalLabelWidth > me.maxHeight) {
            // go back one step
            labelRotation--;
            break;
          }

          labelRotation++;
          labelWidth = cosRotation * originalLabelWidth;
        }
      }

      me.labelRotation = labelRotation;
    },
    afterCalculateTickRotation: function () {
      helpers$1.callback(this.options.afterCalculateTickRotation, [this]);
    },
    //
    beforeFit: function () {
      helpers$1.callback(this.options.beforeFit, [this]);
    },
    fit: function () {
      var me = this; // Reset

      var minSize = me.minSize = {
        width: 0,
        height: 0
      };
      var labels = labelsFromTicks(me._ticks);
      var opts = me.options;
      var tickOpts = opts.ticks;
      var scaleLabelOpts = opts.scaleLabel;
      var gridLineOpts = opts.gridLines;

      var display = me._isVisible();

      var position = opts.position;
      var isHorizontal = me.isHorizontal();
      var parseFont = helpers$1.options._parseFont;
      var tickFont = parseFont(tickOpts);
      var tickMarkLength = opts.gridLines.tickMarkLength; // Width

      if (isHorizontal) {
        // subtract the margins to line up with the chartArea if we are a full width scale
        minSize.width = me.isFullWidth() ? me.maxWidth - me.margins.left - me.margins.right : me.maxWidth;
      } else {
        minSize.width = display && gridLineOpts.drawTicks ? tickMarkLength : 0;
      } // height


      if (isHorizontal) {
        minSize.height = display && gridLineOpts.drawTicks ? tickMarkLength : 0;
      } else {
        minSize.height = me.maxHeight; // fill all the height
      } // Are we showing a title for the scale?


      if (scaleLabelOpts.display && display) {
        var scaleLabelFont = parseFont(scaleLabelOpts);
        var scaleLabelPadding = helpers$1.options.toPadding(scaleLabelOpts.padding);
        var deltaHeight = scaleLabelFont.lineHeight + scaleLabelPadding.height;

        if (isHorizontal) {
          minSize.height += deltaHeight;
        } else {
          minSize.width += deltaHeight;
        }
      } // Don't bother fitting the ticks if we are not showing the labels


      if (tickOpts.display && display) {
        var largestTextWidth = helpers$1.longestText(me.ctx, tickFont.string, labels, me.longestTextCache);
        var tallestLabelHeightInLines = helpers$1.numberOfLabelLines(labels);
        var lineSpace = tickFont.size * 0.5;
        var tickPadding = me.options.ticks.padding; // Store max number of lines and widest label for _autoSkip

        me._maxLabelLines = tallestLabelHeightInLines;
        me.longestLabelWidth = largestTextWidth;

        if (isHorizontal) {
          var angleRadians = helpers$1.toRadians(me.labelRotation);
          var cosRotation = Math.cos(angleRadians);
          var sinRotation = Math.sin(angleRadians); // TODO - improve this calculation

          var labelHeight = sinRotation * largestTextWidth + tickFont.lineHeight * tallestLabelHeightInLines + lineSpace; // padding

          minSize.height = Math.min(me.maxHeight, minSize.height + labelHeight + tickPadding);
          me.ctx.font = tickFont.string;
          var firstLabelWidth = computeTextSize(me.ctx, labels[0], tickFont.string);
          var lastLabelWidth = computeTextSize(me.ctx, labels[labels.length - 1], tickFont.string);
          var offsetLeft = me.getPixelForTick(0) - me.left;
          var offsetRight = me.right - me.getPixelForTick(labels.length - 1);
          var paddingLeft, paddingRight; // Ensure that our ticks are always inside the canvas. When rotated, ticks are right aligned
          // which means that the right padding is dominated by the font height

          if (me.labelRotation !== 0) {
            paddingLeft = position === 'bottom' ? cosRotation * firstLabelWidth : cosRotation * lineSpace;
            paddingRight = position === 'bottom' ? cosRotation * lineSpace : cosRotation * lastLabelWidth;
          } else {
            paddingLeft = firstLabelWidth / 2;
            paddingRight = lastLabelWidth / 2;
          }

          me.paddingLeft = Math.max(paddingLeft - offsetLeft, 0) + 3; // add 3 px to move away from canvas edges

          me.paddingRight = Math.max(paddingRight - offsetRight, 0) + 3;
        } else {
          // A vertical axis is more constrained by the width. Labels are the
          // dominant factor here, so get that length first and account for padding
          if (tickOpts.mirror) {
            largestTextWidth = 0;
          } else {
            // use lineSpace for consistency with horizontal axis
            // tickPadding is not implemented for horizontal
            largestTextWidth += tickPadding + lineSpace;
          }

          minSize.width = Math.min(me.maxWidth, minSize.width + largestTextWidth);
          me.paddingTop = tickFont.size / 2;
          me.paddingBottom = tickFont.size / 2;
        }
      }

      me.handleMargins();
      me.width = minSize.width;
      me.height = minSize.height;
    },

    /**
     * Handle margins and padding interactions
     * @private
     */
    handleMargins: function () {
      var me = this;

      if (me.margins) {
        me.paddingLeft = Math.max(me.paddingLeft - me.margins.left, 0);
        me.paddingTop = Math.max(me.paddingTop - me.margins.top, 0);
        me.paddingRight = Math.max(me.paddingRight - me.margins.right, 0);
        me.paddingBottom = Math.max(me.paddingBottom - me.margins.bottom, 0);
      }
    },
    afterFit: function () {
      helpers$1.callback(this.options.afterFit, [this]);
    },
    // Shared Methods
    isHorizontal: function () {
      return this.options.position === 'top' || this.options.position === 'bottom';
    },
    isFullWidth: function () {
      return this.options.fullWidth;
    },
    // Get the correct value. NaN bad inputs, If the value type is object get the x or y based on whether we are horizontal or not
    getRightValue: function (rawValue) {
      // Null and undefined values first
      if (helpers$1.isNullOrUndef(rawValue)) {
        return NaN;
      } // isNaN(object) returns true, so make sure NaN is checking for a number; Discard Infinite values


      if ((typeof rawValue === 'number' || rawValue instanceof Number) && !isFinite(rawValue)) {
        return NaN;
      } // If it is in fact an object, dive in one more level


      if (rawValue) {
        if (this.isHorizontal()) {
          if (rawValue.x !== undefined) {
            return this.getRightValue(rawValue.x);
          }
        } else if (rawValue.y !== undefined) {
          return this.getRightValue(rawValue.y);
        }
      } // Value is good, return it


      return rawValue;
    },

    /**
     * Used to get the value to display in the tooltip for the data at the given index
     * @param index
     * @param datasetIndex
     */
    getLabelForIndex: helpers$1.noop,

    /**
     * Returns the location of the given data point. Value can either be an index or a numerical value
     * The coordinate (0, 0) is at the upper-left corner of the canvas
     * @param value
     * @param index
     * @param datasetIndex
     */
    getPixelForValue: helpers$1.noop,

    /**
     * Used to get the data value from a given pixel. This is the inverse of getPixelForValue
     * The coordinate (0, 0) is at the upper-left corner of the canvas
     * @param pixel
     */
    getValueForPixel: helpers$1.noop,

    /**
     * Returns the location of the tick at the given index
     * The coordinate (0, 0) is at the upper-left corner of the canvas
     */
    getPixelForTick: function (index) {
      var me = this;
      var offset = me.options.offset;

      if (me.isHorizontal()) {
        var innerWidth = me.width - (me.paddingLeft + me.paddingRight);
        var tickWidth = innerWidth / Math.max(me._ticks.length - (offset ? 0 : 1), 1);
        var pixel = tickWidth * index + me.paddingLeft;

        if (offset) {
          pixel += tickWidth / 2;
        }

        var finalVal = me.left + pixel;
        finalVal += me.isFullWidth() ? me.margins.left : 0;
        return finalVal;
      }

      var innerHeight = me.height - (me.paddingTop + me.paddingBottom);
      return me.top + index * (innerHeight / (me._ticks.length - 1));
    },

    /**
     * Utility for getting the pixel location of a percentage of scale
     * The coordinate (0, 0) is at the upper-left corner of the canvas
     */
    getPixelForDecimal: function (decimal) {
      var me = this;

      if (me.isHorizontal()) {
        var innerWidth = me.width - (me.paddingLeft + me.paddingRight);
        var valueOffset = innerWidth * decimal + me.paddingLeft;
        var finalVal = me.left + valueOffset;
        finalVal += me.isFullWidth() ? me.margins.left : 0;
        return finalVal;
      }

      return me.top + decimal * me.height;
    },

    /**
     * Returns the pixel for the minimum chart value
     * The coordinate (0, 0) is at the upper-left corner of the canvas
     */
    getBasePixel: function () {
      return this.getPixelForValue(this.getBaseValue());
    },
    getBaseValue: function () {
      var me = this;
      var min = me.min;
      var max = me.max;
      return me.beginAtZero ? 0 : min < 0 && max < 0 ? max : min > 0 && max > 0 ? min : 0;
    },

    /**
     * Returns a subset of ticks to be plotted to avoid overlapping labels.
     * @private
     */
    _autoSkip: function (ticks) {
      var me = this;
      var isHorizontal = me.isHorizontal();
      var optionTicks = me.options.ticks.minor;
      var tickCount = ticks.length;
      var skipRatio = false;
      var maxTicks = optionTicks.maxTicksLimit; // Total space needed to display all ticks. First and last ticks are
      // drawn as their center at end of axis, so tickCount-1

      var ticksLength = me._tickSize() * (tickCount - 1); // Axis length

      var axisLength = isHorizontal ? me.width - (me.paddingLeft + me.paddingRight) : me.height - (me.paddingTop + me.PaddingBottom);
      var result = [];
      var i, tick;

      if (ticksLength > axisLength) {
        skipRatio = 1 + Math.floor(ticksLength / axisLength);
      } // if they defined a max number of optionTicks,
      // increase skipRatio until that number is met


      if (tickCount > maxTicks) {
        skipRatio = Math.max(skipRatio, 1 + Math.floor(tickCount / maxTicks));
      }

      for (i = 0; i < tickCount; i++) {
        tick = ticks[i];

        if (skipRatio > 1 && i % skipRatio > 0) {
          // leave tick in place but make sure it's not displayed (#4635)
          delete tick.label;
        }

        result.push(tick);
      }

      return result;
    },

    /**
     * @private
     */
    _tickSize: function () {
      var me = this;
      var isHorizontal = me.isHorizontal();
      var optionTicks = me.options.ticks.minor; // Calculate space needed by label in axis direction.

      var rot = helpers$1.toRadians(me.labelRotation);
      var cos = Math.abs(Math.cos(rot));
      var sin = Math.abs(Math.sin(rot));
      var padding = optionTicks.autoSkipPadding || 0;
      var w = me.longestLabelWidth + padding || 0;

      var tickFont = helpers$1.options._parseFont(optionTicks);

      var h = me._maxLabelLines * tickFont.lineHeight + padding || 0; // Calculate space needed for 1 tick in axis direction.

      return isHorizontal ? h * cos > w * sin ? w / cos : h / sin : h * sin < w * cos ? h / cos : w / sin;
    },

    /**
     * @private
     */
    _isVisible: function () {
      var me = this;
      var chart = me.chart;
      var display = me.options.display;
      var i, ilen, meta;

      if (display !== 'auto') {
        return !!display;
      } // When 'auto', the scale is visible if at least one associated dataset is visible.


      for (i = 0, ilen = chart.data.datasets.length; i < ilen; ++i) {
        if (chart.isDatasetVisible(i)) {
          meta = chart.getDatasetMeta(i);

          if (meta.xAxisID === me.id || meta.yAxisID === me.id) {
            return true;
          }
        }
      }

      return false;
    },

    /**
     * Actually draw the scale on the canvas
     * @param {object} chartArea - the area of the chart to draw full grid lines on
     */
    draw: function (chartArea) {
      var me = this;
      var options = me.options;

      if (!me._isVisible()) {
        return;
      }

      var chart = me.chart;
      var context = me.ctx;
      var globalDefaults = core_defaults.global;
      var defaultFontColor = globalDefaults.defaultFontColor;
      var optionTicks = options.ticks.minor;
      var optionMajorTicks = options.ticks.major || optionTicks;
      var gridLines = options.gridLines;
      var scaleLabel = options.scaleLabel;
      var position = options.position;
      var isRotated = me.labelRotation !== 0;
      var isMirrored = optionTicks.mirror;
      var isHorizontal = me.isHorizontal();
      var parseFont = helpers$1.options._parseFont;
      var ticks = optionTicks.display && optionTicks.autoSkip ? me._autoSkip(me.getTicks()) : me.getTicks();
      var tickFontColor = valueOrDefault$9(optionTicks.fontColor, defaultFontColor);
      var tickFont = parseFont(optionTicks);
      var lineHeight = tickFont.lineHeight;
      var majorTickFontColor = valueOrDefault$9(optionMajorTicks.fontColor, defaultFontColor);
      var majorTickFont = parseFont(optionMajorTicks);
      var tickPadding = optionTicks.padding;
      var labelOffset = optionTicks.labelOffset;
      var tl = gridLines.drawTicks ? gridLines.tickMarkLength : 0;
      var scaleLabelFontColor = valueOrDefault$9(scaleLabel.fontColor, defaultFontColor);
      var scaleLabelFont = parseFont(scaleLabel);
      var scaleLabelPadding = helpers$1.options.toPadding(scaleLabel.padding);
      var labelRotationRadians = helpers$1.toRadians(me.labelRotation);
      var itemsToDraw = [];
      var axisWidth = gridLines.drawBorder ? valueAtIndexOrDefault(gridLines.lineWidth, 0, 0) : 0;
      var alignPixel = helpers$1._alignPixel;
      var borderValue, tickStart, tickEnd;

      if (position === 'top') {
        borderValue = alignPixel(chart, me.bottom, axisWidth);
        tickStart = me.bottom - tl;
        tickEnd = borderValue - axisWidth / 2;
      } else if (position === 'bottom') {
        borderValue = alignPixel(chart, me.top, axisWidth);
        tickStart = borderValue + axisWidth / 2;
        tickEnd = me.top + tl;
      } else if (position === 'left') {
        borderValue = alignPixel(chart, me.right, axisWidth);
        tickStart = me.right - tl;
        tickEnd = borderValue - axisWidth / 2;
      } else {
        borderValue = alignPixel(chart, me.left, axisWidth);
        tickStart = borderValue + axisWidth / 2;
        tickEnd = me.left + tl;
      }

      var epsilon = 0.0000001; // 0.0000001 is margin in pixels for Accumulated error.

      helpers$1.each(ticks, function (tick, index) {
        // autoskipper skipped this tick (#4635)
        if (helpers$1.isNullOrUndef(tick.label)) {
          return;
        }

        var label = tick.label;
        var lineWidth, lineColor, borderDash, borderDashOffset;

        if (index === me.zeroLineIndex && options.offset === gridLines.offsetGridLines) {
          // Draw the first index specially
          lineWidth = gridLines.zeroLineWidth;
          lineColor = gridLines.zeroLineColor;
          borderDash = gridLines.zeroLineBorderDash || [];
          borderDashOffset = gridLines.zeroLineBorderDashOffset || 0.0;
        } else {
          lineWidth = valueAtIndexOrDefault(gridLines.lineWidth, index);
          lineColor = valueAtIndexOrDefault(gridLines.color, index);
          borderDash = gridLines.borderDash || [];
          borderDashOffset = gridLines.borderDashOffset || 0.0;
        } // Common properties


        var tx1, ty1, tx2, ty2, x1, y1, x2, y2, labelX, labelY, textOffset, textAlign;
        var labelCount = helpers$1.isArray(label) ? label.length : 1;
        var lineValue = getPixelForGridLine(me, index, gridLines.offsetGridLines);

        if (isHorizontal) {
          var labelYOffset = tl + tickPadding;

          if (lineValue < me.left - epsilon) {
            lineColor = 'rgba(0,0,0,0)';
          }

          tx1 = tx2 = x1 = x2 = alignPixel(chart, lineValue, lineWidth);
          ty1 = tickStart;
          ty2 = tickEnd;
          labelX = me.getPixelForTick(index) + labelOffset; // x values for optionTicks (need to consider offsetLabel option)

          if (position === 'top') {
            y1 = alignPixel(chart, chartArea.top, axisWidth) + axisWidth / 2;
            y2 = chartArea.bottom;
            textOffset = ((!isRotated ? 0.5 : 1) - labelCount) * lineHeight;
            textAlign = !isRotated ? 'center' : 'left';
            labelY = me.bottom - labelYOffset;
          } else {
            y1 = chartArea.top;
            y2 = alignPixel(chart, chartArea.bottom, axisWidth) - axisWidth / 2;
            textOffset = (!isRotated ? 0.5 : 0) * lineHeight;
            textAlign = !isRotated ? 'center' : 'right';
            labelY = me.top + labelYOffset;
          }
        } else {
          var labelXOffset = (isMirrored ? 0 : tl) + tickPadding;

          if (lineValue < me.top - epsilon) {
            lineColor = 'rgba(0,0,0,0)';
          }

          tx1 = tickStart;
          tx2 = tickEnd;
          ty1 = ty2 = y1 = y2 = alignPixel(chart, lineValue, lineWidth);
          labelY = me.getPixelForTick(index) + labelOffset;
          textOffset = (1 - labelCount) * lineHeight / 2;

          if (position === 'left') {
            x1 = alignPixel(chart, chartArea.left, axisWidth) + axisWidth / 2;
            x2 = chartArea.right;
            textAlign = isMirrored ? 'left' : 'right';
            labelX = me.right - labelXOffset;
          } else {
            x1 = chartArea.left;
            x2 = alignPixel(chart, chartArea.right, axisWidth) - axisWidth / 2;
            textAlign = isMirrored ? 'right' : 'left';
            labelX = me.left + labelXOffset;
          }
        }

        itemsToDraw.push({
          tx1: tx1,
          ty1: ty1,
          tx2: tx2,
          ty2: ty2,
          x1: x1,
          y1: y1,
          x2: x2,
          y2: y2,
          labelX: labelX,
          labelY: labelY,
          glWidth: lineWidth,
          glColor: lineColor,
          glBorderDash: borderDash,
          glBorderDashOffset: borderDashOffset,
          rotation: -1 * labelRotationRadians,
          label: label,
          major: tick.major,
          textOffset: textOffset,
          textAlign: textAlign
        });
      }); // Draw all of the tick labels, tick marks, and grid lines at the correct places

      helpers$1.each(itemsToDraw, function (itemToDraw) {
        var glWidth = itemToDraw.glWidth;
        var glColor = itemToDraw.glColor;

        if (gridLines.display && glWidth && glColor) {
          context.save();
          context.lineWidth = glWidth;
          context.strokeStyle = glColor;

          if (context.setLineDash) {
            context.setLineDash(itemToDraw.glBorderDash);
            context.lineDashOffset = itemToDraw.glBorderDashOffset;
          }

          context.beginPath();

          if (gridLines.drawTicks) {
            context.moveTo(itemToDraw.tx1, itemToDraw.ty1);
            context.lineTo(itemToDraw.tx2, itemToDraw.ty2);
          }

          if (gridLines.drawOnChartArea) {
            context.moveTo(itemToDraw.x1, itemToDraw.y1);
            context.lineTo(itemToDraw.x2, itemToDraw.y2);
          }

          context.stroke();
          context.restore();
        }

        if (optionTicks.display) {
          // Make sure we draw text in the correct color and font
          context.save();
          context.translate(itemToDraw.labelX, itemToDraw.labelY);
          context.rotate(itemToDraw.rotation);
          context.font = itemToDraw.major ? majorTickFont.string : tickFont.string;
          context.fillStyle = itemToDraw.major ? majorTickFontColor : tickFontColor;
          context.textBaseline = 'middle';
          context.textAlign = itemToDraw.textAlign;
          var label = itemToDraw.label;
          var y = itemToDraw.textOffset;

          if (helpers$1.isArray(label)) {
            for (var i = 0; i < label.length; ++i) {
              // We just make sure the multiline element is a string here..
              context.fillText('' + label[i], 0, y);
              y += lineHeight;
            }
          } else {
            context.fillText(label, 0, y);
          }

          context.restore();
        }
      });

      if (scaleLabel.display) {
        // Draw the scale label
        var scaleLabelX;
        var scaleLabelY;
        var rotation = 0;
        var halfLineHeight = scaleLabelFont.lineHeight / 2;

        if (isHorizontal) {
          scaleLabelX = me.left + (me.right - me.left) / 2; // midpoint of the width

          scaleLabelY = position === 'bottom' ? me.bottom - halfLineHeight - scaleLabelPadding.bottom : me.top + halfLineHeight + scaleLabelPadding.top;
        } else {
          var isLeft = position === 'left';
          scaleLabelX = isLeft ? me.left + halfLineHeight + scaleLabelPadding.top : me.right - halfLineHeight - scaleLabelPadding.top;
          scaleLabelY = me.top + (me.bottom - me.top) / 2;
          rotation = isLeft ? -0.5 * Math.PI : 0.5 * Math.PI;
        }

        context.save();
        context.translate(scaleLabelX, scaleLabelY);
        context.rotate(rotation);
        context.textAlign = 'center';
        context.textBaseline = 'middle';
        context.fillStyle = scaleLabelFontColor; // render in correct colour

        context.font = scaleLabelFont.string;
        context.fillText(scaleLabel.labelString, 0, 0);
        context.restore();
      }

      if (axisWidth) {
        // Draw the line at the edge of the axis
        var firstLineWidth = axisWidth;
        var lastLineWidth = valueAtIndexOrDefault(gridLines.lineWidth, ticks.length - 1, 0);
        var x1, x2, y1, y2;

        if (isHorizontal) {
          x1 = alignPixel(chart, me.left, firstLineWidth) - firstLineWidth / 2;
          x2 = alignPixel(chart, me.right, lastLineWidth) + lastLineWidth / 2;
          y1 = y2 = borderValue;
        } else {
          y1 = alignPixel(chart, me.top, firstLineWidth) - firstLineWidth / 2;
          y2 = alignPixel(chart, me.bottom, lastLineWidth) + lastLineWidth / 2;
          x1 = x2 = borderValue;
        }

        context.lineWidth = axisWidth;
        context.strokeStyle = valueAtIndexOrDefault(gridLines.color, 0);
        context.beginPath();
        context.moveTo(x1, y1);
        context.lineTo(x2, y2);
        context.stroke();
      }
    }
  });
  var defaultConfig = {
    position: 'bottom'
  };
  var scale_category = core_scale.extend({
    /**
    * Internal function to get the correct labels. If data.xLabels or data.yLabels are defined, use those
    * else fall back to data.labels
    * @private
    */
    getLabels: function () {
      var data = this.chart.data;
      return this.options.labels || (this.isHorizontal() ? data.xLabels : data.yLabels) || data.labels;
    },
    determineDataLimits: function () {
      var me = this;
      var labels = me.getLabels();
      me.minIndex = 0;
      me.maxIndex = labels.length - 1;
      var findIndex;

      if (me.options.ticks.min !== undefined) {
        // user specified min value
        findIndex = labels.indexOf(me.options.ticks.min);
        me.minIndex = findIndex !== -1 ? findIndex : me.minIndex;
      }

      if (me.options.ticks.max !== undefined) {
        // user specified max value
        findIndex = labels.indexOf(me.options.ticks.max);
        me.maxIndex = findIndex !== -1 ? findIndex : me.maxIndex;
      }

      me.min = labels[me.minIndex];
      me.max = labels[me.maxIndex];
    },
    buildTicks: function () {
      var me = this;
      var labels = me.getLabels(); // If we are viewing some subset of labels, slice the original array

      me.ticks = me.minIndex === 0 && me.maxIndex === labels.length - 1 ? labels : labels.slice(me.minIndex, me.maxIndex + 1);
    },
    getLabelForIndex: function (index, datasetIndex) {
      var me = this;
      var chart = me.chart;

      if (chart.getDatasetMeta(datasetIndex).controller._getValueScaleId() === me.id) {
        return me.getRightValue(chart.data.datasets[datasetIndex].data[index]);
      }

      return me.ticks[index - me.minIndex];
    },
    // Used to get data value locations.  Value can either be an index or a numerical value
    getPixelForValue: function (value, index) {
      var me = this;
      var offset = me.options.offset; // 1 is added because we need the length but we have the indexes

      var offsetAmt = Math.max(me.maxIndex + 1 - me.minIndex - (offset ? 0 : 1), 1); // If value is a data object, then index is the index in the data array,
      // not the index of the scale. We need to change that.

      var valueCategory;

      if (value !== undefined && value !== null) {
        valueCategory = me.isHorizontal() ? value.x : value.y;
      }

      if (valueCategory !== undefined || value !== undefined && isNaN(index)) {
        var labels = me.getLabels();
        value = valueCategory || value;
        var idx = labels.indexOf(value);
        index = idx !== -1 ? idx : index;
      }

      if (me.isHorizontal()) {
        var valueWidth = me.width / offsetAmt;
        var widthOffset = valueWidth * (index - me.minIndex);

        if (offset) {
          widthOffset += valueWidth / 2;
        }

        return me.left + widthOffset;
      }

      var valueHeight = me.height / offsetAmt;
      var heightOffset = valueHeight * (index - me.minIndex);

      if (offset) {
        heightOffset += valueHeight / 2;
      }

      return me.top + heightOffset;
    },
    getPixelForTick: function (index) {
      return this.getPixelForValue(this.ticks[index], index + this.minIndex, null);
    },
    getValueForPixel: function (pixel) {
      var me = this;
      var offset = me.options.offset;
      var value;
      var offsetAmt = Math.max(me._ticks.length - (offset ? 0 : 1), 1);
      var horz = me.isHorizontal();
      var valueDimension = (horz ? me.width : me.height) / offsetAmt;
      pixel -= horz ? me.left : me.top;

      if (offset) {
        pixel -= valueDimension / 2;
      }

      if (pixel <= 0) {
        value = 0;
      } else {
        value = Math.round(pixel / valueDimension);
      }

      return value + me.minIndex;
    },
    getBasePixel: function () {
      return this.bottom;
    }
  }); // INTERNAL: static default options, registered in src/index.js

  var _defaults = defaultConfig;
  scale_category._defaults = _defaults;
  var noop = helpers$1.noop;
  var isNullOrUndef = helpers$1.isNullOrUndef;
  /**
   * Generate a set of linear ticks
   * @param generationOptions the options used to generate the ticks
   * @param dataRange the range of the data
   * @returns {number[]} array of tick values
   */

  function generateTicks(generationOptions, dataRange) {
    var ticks = []; // To get a "nice" value for the tick spacing, we will use the appropriately named
    // "nice number" algorithm. See https://stackoverflow.com/questions/8506881/nice-label-algorithm-for-charts-with-minimum-ticks
    // for details.

    var MIN_SPACING = 1e-14;
    var stepSize = generationOptions.stepSize;
    var unit = stepSize || 1;
    var maxNumSpaces = generationOptions.maxTicks - 1;
    var min = generationOptions.min;
    var max = generationOptions.max;
    var precision = generationOptions.precision;
    var rmin = dataRange.min;
    var rmax = dataRange.max;
    var spacing = helpers$1.niceNum((rmax - rmin) / maxNumSpaces / unit) * unit;
    var factor, niceMin, niceMax, numSpaces; // Beyond MIN_SPACING floating point numbers being to lose precision
    // such that we can't do the math necessary to generate ticks

    if (spacing < MIN_SPACING && isNullOrUndef(min) && isNullOrUndef(max)) {
      return [rmin, rmax];
    }

    numSpaces = Math.ceil(rmax / spacing) - Math.floor(rmin / spacing);

    if (numSpaces > maxNumSpaces) {
      // If the calculated num of spaces exceeds maxNumSpaces, recalculate it
      spacing = helpers$1.niceNum(numSpaces * spacing / maxNumSpaces / unit) * unit;
    }

    if (stepSize || isNullOrUndef(precision)) {
      // If a precision is not specified, calculate factor based on spacing
      factor = Math.pow(10, helpers$1._decimalPlaces(spacing));
    } else {
      // If the user specified a precision, round to that number of decimal places
      factor = Math.pow(10, precision);
      spacing = Math.ceil(spacing * factor) / factor;
    }

    niceMin = Math.floor(rmin / spacing) * spacing;
    niceMax = Math.ceil(rmax / spacing) * spacing; // If min, max and stepSize is set and they make an evenly spaced scale use it.

    if (stepSize) {
      // If very close to our whole number, use it.
      if (!isNullOrUndef(min) && helpers$1.almostWhole(min / spacing, spacing / 1000)) {
        niceMin = min;
      }

      if (!isNullOrUndef(max) && helpers$1.almostWhole(max / spacing, spacing / 1000)) {
        niceMax = max;
      }
    }

    numSpaces = (niceMax - niceMin) / spacing; // If very close to our rounded value, use it.

    if (helpers$1.almostEquals(numSpaces, Math.round(numSpaces), spacing / 1000)) {
      numSpaces = Math.round(numSpaces);
    } else {
      numSpaces = Math.ceil(numSpaces);
    }

    niceMin = Math.round(niceMin * factor) / factor;
    niceMax = Math.round(niceMax * factor) / factor;
    ticks.push(isNullOrUndef(min) ? niceMin : min);

    for (var j = 1; j < numSpaces; ++j) {
      ticks.push(Math.round((niceMin + j * spacing) * factor) / factor);
    }

    ticks.push(isNullOrUndef(max) ? niceMax : max);
    return ticks;
  }

  var scale_linearbase = core_scale.extend({
    getRightValue: function (value) {
      if (typeof value === 'string') {
        return +value;
      }

      return core_scale.prototype.getRightValue.call(this, value);
    },
    handleTickRangeOptions: function () {
      var me = this;
      var opts = me.options;
      var tickOpts = opts.ticks; // If we are forcing it to begin at 0, but 0 will already be rendered on the chart,
      // do nothing since that would make the chart weird. If the user really wants a weird chart
      // axis, they can manually override it

      if (tickOpts.beginAtZero) {
        var minSign = helpers$1.sign(me.min);
        var maxSign = helpers$1.sign(me.max);

        if (minSign < 0 && maxSign < 0) {
          // move the top up to 0
          me.max = 0;
        } else if (minSign > 0 && maxSign > 0) {
          // move the bottom down to 0
          me.min = 0;
        }
      }

      var setMin = tickOpts.min !== undefined || tickOpts.suggestedMin !== undefined;
      var setMax = tickOpts.max !== undefined || tickOpts.suggestedMax !== undefined;

      if (tickOpts.min !== undefined) {
        me.min = tickOpts.min;
      } else if (tickOpts.suggestedMin !== undefined) {
        if (me.min === null) {
          me.min = tickOpts.suggestedMin;
        } else {
          me.min = Math.min(me.min, tickOpts.suggestedMin);
        }
      }

      if (tickOpts.max !== undefined) {
        me.max = tickOpts.max;
      } else if (tickOpts.suggestedMax !== undefined) {
        if (me.max === null) {
          me.max = tickOpts.suggestedMax;
        } else {
          me.max = Math.max(me.max, tickOpts.suggestedMax);
        }
      }

      if (setMin !== setMax) {
        // We set the min or the max but not both.
        // So ensure that our range is good
        // Inverted or 0 length range can happen when
        // ticks.min is set, and no datasets are visible
        if (me.min >= me.max) {
          if (setMin) {
            me.max = me.min + 1;
          } else {
            me.min = me.max - 1;
          }
        }
      }

      if (me.min === me.max) {
        me.max++;

        if (!tickOpts.beginAtZero) {
          me.min--;
        }
      }
    },
    getTickLimit: function () {
      var me = this;
      var tickOpts = me.options.ticks;
      var stepSize = tickOpts.stepSize;
      var maxTicksLimit = tickOpts.maxTicksLimit;
      var maxTicks;

      if (stepSize) {
        maxTicks = Math.ceil(me.max / stepSize) - Math.floor(me.min / stepSize) + 1;
      } else {
        maxTicks = me._computeTickLimit();
        maxTicksLimit = maxTicksLimit || 11;
      }

      if (maxTicksLimit) {
        maxTicks = Math.min(maxTicksLimit, maxTicks);
      }

      return maxTicks;
    },
    _computeTickLimit: function () {
      return Number.POSITIVE_INFINITY;
    },
    handleDirectionalChanges: noop,
    buildTicks: function () {
      var me = this;
      var opts = me.options;
      var tickOpts = opts.ticks; // Figure out what the max number of ticks we can support it is based on the size of
      // the axis area. For now, we say that the minimum tick spacing in pixels must be 40
      // We also limit the maximum number of ticks to 11 which gives a nice 10 squares on
      // the graph. Make sure we always have at least 2 ticks

      var maxTicks = me.getTickLimit();
      maxTicks = Math.max(2, maxTicks);
      var numericGeneratorOptions = {
        maxTicks: maxTicks,
        min: tickOpts.min,
        max: tickOpts.max,
        precision: tickOpts.precision,
        stepSize: helpers$1.valueOrDefault(tickOpts.fixedStepSize, tickOpts.stepSize)
      };
      var ticks = me.ticks = generateTicks(numericGeneratorOptions, me);
      me.handleDirectionalChanges(); // At this point, we need to update our max and min given the tick values since we have expanded the
      // range of the scale

      me.max = helpers$1.max(ticks);
      me.min = helpers$1.min(ticks);

      if (tickOpts.reverse) {
        ticks.reverse();
        me.start = me.max;
        me.end = me.min;
      } else {
        me.start = me.min;
        me.end = me.max;
      }
    },
    convertTicksToLabels: function () {
      var me = this;
      me.ticksAsNumbers = me.ticks.slice();
      me.zeroLineIndex = me.ticks.indexOf(0);
      core_scale.prototype.convertTicksToLabels.call(me);
    }
  });
  var defaultConfig$1 = {
    position: 'left',
    ticks: {
      callback: core_ticks.formatters.linear
    }
  };
  var scale_linear = scale_linearbase.extend({
    determineDataLimits: function () {
      var me = this;
      var opts = me.options;
      var chart = me.chart;
      var data = chart.data;
      var datasets = data.datasets;
      var isHorizontal = me.isHorizontal();
      var DEFAULT_MIN = 0;
      var DEFAULT_MAX = 1;

      function IDMatches(meta) {
        return isHorizontal ? meta.xAxisID === me.id : meta.yAxisID === me.id;
      } // First Calculate the range


      me.min = null;
      me.max = null;
      var hasStacks = opts.stacked;

      if (hasStacks === undefined) {
        helpers$1.each(datasets, function (dataset, datasetIndex) {
          if (hasStacks) {
            return;
          }

          var meta = chart.getDatasetMeta(datasetIndex);

          if (chart.isDatasetVisible(datasetIndex) && IDMatches(meta) && meta.stack !== undefined) {
            hasStacks = true;
          }
        });
      }

      if (opts.stacked || hasStacks) {
        var valuesPerStack = {};
        helpers$1.each(datasets, function (dataset, datasetIndex) {
          var meta = chart.getDatasetMeta(datasetIndex);
          var key = [meta.type, // we have a separate stack for stack=undefined datasets when the opts.stacked is undefined
          opts.stacked === undefined && meta.stack === undefined ? datasetIndex : '', meta.stack].join('.');

          if (valuesPerStack[key] === undefined) {
            valuesPerStack[key] = {
              positiveValues: [],
              negativeValues: []
            };
          } // Store these per type


          var positiveValues = valuesPerStack[key].positiveValues;
          var negativeValues = valuesPerStack[key].negativeValues;

          if (chart.isDatasetVisible(datasetIndex) && IDMatches(meta)) {
            helpers$1.each(dataset.data, function (rawValue, index) {
              var value = +me.getRightValue(rawValue);

              if (isNaN(value) || meta.data[index].hidden) {
                return;
              }

              positiveValues[index] = positiveValues[index] || 0;
              negativeValues[index] = negativeValues[index] || 0;

              if (opts.relativePoints) {
                positiveValues[index] = 100;
              } else if (value < 0) {
                negativeValues[index] += value;
              } else {
                positiveValues[index] += value;
              }
            });
          }
        });
        helpers$1.each(valuesPerStack, function (valuesForType) {
          var values = valuesForType.positiveValues.concat(valuesForType.negativeValues);
          var minVal = helpers$1.min(values);
          var maxVal = helpers$1.max(values);
          me.min = me.min === null ? minVal : Math.min(me.min, minVal);
          me.max = me.max === null ? maxVal : Math.max(me.max, maxVal);
        });
      } else {
        helpers$1.each(datasets, function (dataset, datasetIndex) {
          var meta = chart.getDatasetMeta(datasetIndex);

          if (chart.isDatasetVisible(datasetIndex) && IDMatches(meta)) {
            helpers$1.each(dataset.data, function (rawValue, index) {
              var value = +me.getRightValue(rawValue);

              if (isNaN(value) || meta.data[index].hidden) {
                return;
              }

              if (me.min === null) {
                me.min = value;
              } else if (value < me.min) {
                me.min = value;
              }

              if (me.max === null) {
                me.max = value;
              } else if (value > me.max) {
                me.max = value;
              }
            });
          }
        });
      }

      me.min = isFinite(me.min) && !isNaN(me.min) ? me.min : DEFAULT_MIN;
      me.max = isFinite(me.max) && !isNaN(me.max) ? me.max : DEFAULT_MAX; // Common base implementation to handle ticks.min, ticks.max, ticks.beginAtZero

      this.handleTickRangeOptions();
    },
    // Returns the maximum number of ticks based on the scale dimension
    _computeTickLimit: function () {
      var me = this;
      var tickFont;

      if (me.isHorizontal()) {
        return Math.ceil(me.width / 40);
      }

      tickFont = helpers$1.options._parseFont(me.options.ticks);
      return Math.ceil(me.height / tickFont.lineHeight);
    },
    // Called after the ticks are built. We need
    handleDirectionalChanges: function () {
      if (!this.isHorizontal()) {
        // We are in a vertical orientation. The top value is the highest. So reverse the array
        this.ticks.reverse();
      }
    },
    getLabelForIndex: function (index, datasetIndex) {
      return +this.getRightValue(this.chart.data.datasets[datasetIndex].data[index]);
    },
    // Utils
    getPixelForValue: function (value) {
      // This must be called after fit has been run so that
      // this.left, this.top, this.right, and this.bottom have been defined
      var me = this;
      var start = me.start;
      var rightValue = +me.getRightValue(value);
      var pixel;
      var range = me.end - start;

      if (me.isHorizontal()) {
        pixel = me.left + me.width / range * (rightValue - start);
      } else {
        pixel = me.bottom - me.height / range * (rightValue - start);
      }

      return pixel;
    },
    getValueForPixel: function (pixel) {
      var me = this;
      var isHorizontal = me.isHorizontal();
      var innerDimension = isHorizontal ? me.width : me.height;
      var offset = (isHorizontal ? pixel - me.left : me.bottom - pixel) / innerDimension;
      return me.start + (me.end - me.start) * offset;
    },
    getPixelForTick: function (index) {
      return this.getPixelForValue(this.ticksAsNumbers[index]);
    }
  }); // INTERNAL: static default options, registered in src/index.js

  var _defaults$1 = defaultConfig$1;
  scale_linear._defaults = _defaults$1;
  var valueOrDefault$a = helpers$1.valueOrDefault;
  /**
   * Generate a set of logarithmic ticks
   * @param generationOptions the options used to generate the ticks
   * @param dataRange the range of the data
   * @returns {number[]} array of tick values
   */

  function generateTicks$1(generationOptions, dataRange) {
    var ticks = [];
    var tickVal = valueOrDefault$a(generationOptions.min, Math.pow(10, Math.floor(helpers$1.log10(dataRange.min))));
    var endExp = Math.floor(helpers$1.log10(dataRange.max));
    var endSignificand = Math.ceil(dataRange.max / Math.pow(10, endExp));
    var exp, significand;

    if (tickVal === 0) {
      exp = Math.floor(helpers$1.log10(dataRange.minNotZero));
      significand = Math.floor(dataRange.minNotZero / Math.pow(10, exp));
      ticks.push(tickVal);
      tickVal = significand * Math.pow(10, exp);
    } else {
      exp = Math.floor(helpers$1.log10(tickVal));
      significand = Math.floor(tickVal / Math.pow(10, exp));
    }

    var precision = exp < 0 ? Math.pow(10, Math.abs(exp)) : 1;

    do {
      ticks.push(tickVal);
      ++significand;

      if (significand === 10) {
        significand = 1;
        ++exp;
        precision = exp >= 0 ? 1 : precision;
      }

      tickVal = Math.round(significand * Math.pow(10, exp) * precision) / precision;
    } while (exp < endExp || exp === endExp && significand < endSignificand);

    var lastTick = valueOrDefault$a(generationOptions.max, tickVal);
    ticks.push(lastTick);
    return ticks;
  }

  var defaultConfig$2 = {
    position: 'left',
    // label settings
    ticks: {
      callback: core_ticks.formatters.logarithmic
    }
  }; // TODO(v3): change this to positiveOrDefault

  function nonNegativeOrDefault(value, defaultValue) {
    return helpers$1.isFinite(value) && value >= 0 ? value : defaultValue;
  }

  var scale_logarithmic = core_scale.extend({
    determineDataLimits: function () {
      var me = this;
      var opts = me.options;
      var chart = me.chart;
      var data = chart.data;
      var datasets = data.datasets;
      var isHorizontal = me.isHorizontal();

      function IDMatches(meta) {
        return isHorizontal ? meta.xAxisID === me.id : meta.yAxisID === me.id;
      } // Calculate Range


      me.min = null;
      me.max = null;
      me.minNotZero = null;
      var hasStacks = opts.stacked;

      if (hasStacks === undefined) {
        helpers$1.each(datasets, function (dataset, datasetIndex) {
          if (hasStacks) {
            return;
          }

          var meta = chart.getDatasetMeta(datasetIndex);

          if (chart.isDatasetVisible(datasetIndex) && IDMatches(meta) && meta.stack !== undefined) {
            hasStacks = true;
          }
        });
      }

      if (opts.stacked || hasStacks) {
        var valuesPerStack = {};
        helpers$1.each(datasets, function (dataset, datasetIndex) {
          var meta = chart.getDatasetMeta(datasetIndex);
          var key = [meta.type, // we have a separate stack for stack=undefined datasets when the opts.stacked is undefined
          opts.stacked === undefined && meta.stack === undefined ? datasetIndex : '', meta.stack].join('.');

          if (chart.isDatasetVisible(datasetIndex) && IDMatches(meta)) {
            if (valuesPerStack[key] === undefined) {
              valuesPerStack[key] = [];
            }

            helpers$1.each(dataset.data, function (rawValue, index) {
              var values = valuesPerStack[key];
              var value = +me.getRightValue(rawValue); // invalid, hidden and negative values are ignored

              if (isNaN(value) || meta.data[index].hidden || value < 0) {
                return;
              }

              values[index] = values[index] || 0;
              values[index] += value;
            });
          }
        });
        helpers$1.each(valuesPerStack, function (valuesForType) {
          if (valuesForType.length > 0) {
            var minVal = helpers$1.min(valuesForType);
            var maxVal = helpers$1.max(valuesForType);
            me.min = me.min === null ? minVal : Math.min(me.min, minVal);
            me.max = me.max === null ? maxVal : Math.max(me.max, maxVal);
          }
        });
      } else {
        helpers$1.each(datasets, function (dataset, datasetIndex) {
          var meta = chart.getDatasetMeta(datasetIndex);

          if (chart.isDatasetVisible(datasetIndex) && IDMatches(meta)) {
            helpers$1.each(dataset.data, function (rawValue, index) {
              var value = +me.getRightValue(rawValue); // invalid, hidden and negative values are ignored

              if (isNaN(value) || meta.data[index].hidden || value < 0) {
                return;
              }

              if (me.min === null) {
                me.min = value;
              } else if (value < me.min) {
                me.min = value;
              }

              if (me.max === null) {
                me.max = value;
              } else if (value > me.max) {
                me.max = value;
              }

              if (value !== 0 && (me.minNotZero === null || value < me.minNotZero)) {
                me.minNotZero = value;
              }
            });
          }
        });
      } // Common base implementation to handle ticks.min, ticks.max


      this.handleTickRangeOptions();
    },
    handleTickRangeOptions: function () {
      var me = this;
      var tickOpts = me.options.ticks;
      var DEFAULT_MIN = 1;
      var DEFAULT_MAX = 10;
      me.min = nonNegativeOrDefault(tickOpts.min, me.min);
      me.max = nonNegativeOrDefault(tickOpts.max, me.max);

      if (me.min === me.max) {
        if (me.min !== 0 && me.min !== null) {
          me.min = Math.pow(10, Math.floor(helpers$1.log10(me.min)) - 1);
          me.max = Math.pow(10, Math.floor(helpers$1.log10(me.max)) + 1);
        } else {
          me.min = DEFAULT_MIN;
          me.max = DEFAULT_MAX;
        }
      }

      if (me.min === null) {
        me.min = Math.pow(10, Math.floor(helpers$1.log10(me.max)) - 1);
      }

      if (me.max === null) {
        me.max = me.min !== 0 ? Math.pow(10, Math.floor(helpers$1.log10(me.min)) + 1) : DEFAULT_MAX;
      }

      if (me.minNotZero === null) {
        if (me.min > 0) {
          me.minNotZero = me.min;
        } else if (me.max < 1) {
          me.minNotZero = Math.pow(10, Math.floor(helpers$1.log10(me.max)));
        } else {
          me.minNotZero = DEFAULT_MIN;
        }
      }
    },
    buildTicks: function () {
      var me = this;
      var tickOpts = me.options.ticks;
      var reverse = !me.isHorizontal();
      var generationOptions = {
        min: nonNegativeOrDefault(tickOpts.min),
        max: nonNegativeOrDefault(tickOpts.max)
      };
      var ticks = me.ticks = generateTicks$1(generationOptions, me); // At this point, we need to update our max and min given the tick values since we have expanded the
      // range of the scale

      me.max = helpers$1.max(ticks);
      me.min = helpers$1.min(ticks);

      if (tickOpts.reverse) {
        reverse = !reverse;
        me.start = me.max;
        me.end = me.min;
      } else {
        me.start = me.min;
        me.end = me.max;
      }

      if (reverse) {
        ticks.reverse();
      }
    },
    convertTicksToLabels: function () {
      this.tickValues = this.ticks.slice();
      core_scale.prototype.convertTicksToLabels.call(this);
    },
    // Get the correct tooltip label
    getLabelForIndex: function (index, datasetIndex) {
      return +this.getRightValue(this.chart.data.datasets[datasetIndex].data[index]);
    },
    getPixelForTick: function (index) {
      return this.getPixelForValue(this.tickValues[index]);
    },

    /**
     * Returns the value of the first tick.
     * @param {number} value - The minimum not zero value.
     * @return {number} The first tick value.
     * @private
     */
    _getFirstTickValue: function (value) {
      var exp = Math.floor(helpers$1.log10(value));
      var significand = Math.floor(value / Math.pow(10, exp));
      return significand * Math.pow(10, exp);
    },
    getPixelForValue: function (value) {
      var me = this;
      var tickOpts = me.options.ticks;
      var reverse = tickOpts.reverse;
      var log10 = helpers$1.log10;

      var firstTickValue = me._getFirstTickValue(me.minNotZero);

      var offset = 0;
      var innerDimension, pixel, start, end, sign;
      value = +me.getRightValue(value);

      if (reverse) {
        start = me.end;
        end = me.start;
        sign = -1;
      } else {
        start = me.start;
        end = me.end;
        sign = 1;
      }

      if (me.isHorizontal()) {
        innerDimension = me.width;
        pixel = reverse ? me.right : me.left;
      } else {
        innerDimension = me.height;
        sign *= -1; // invert, since the upper-left corner of the canvas is at pixel (0, 0)

        pixel = reverse ? me.top : me.bottom;
      }

      if (value !== start) {
        if (start === 0) {
          // include zero tick
          offset = valueOrDefault$a(tickOpts.fontSize, core_defaults.global.defaultFontSize);
          innerDimension -= offset;
          start = firstTickValue;
        }

        if (value !== 0) {
          offset += innerDimension / (log10(end) - log10(start)) * (log10(value) - log10(start));
        }

        pixel += sign * offset;
      }

      return pixel;
    },
    getValueForPixel: function (pixel) {
      var me = this;
      var tickOpts = me.options.ticks;
      var reverse = tickOpts.reverse;
      var log10 = helpers$1.log10;

      var firstTickValue = me._getFirstTickValue(me.minNotZero);

      var innerDimension, start, end, value;

      if (reverse) {
        start = me.end;
        end = me.start;
      } else {
        start = me.start;
        end = me.end;
      }

      if (me.isHorizontal()) {
        innerDimension = me.width;
        value = reverse ? me.right - pixel : pixel - me.left;
      } else {
        innerDimension = me.height;
        value = reverse ? pixel - me.top : me.bottom - pixel;
      }

      if (value !== start) {
        if (start === 0) {
          // include zero tick
          var offset = valueOrDefault$a(tickOpts.fontSize, core_defaults.global.defaultFontSize);
          value -= offset;
          innerDimension -= offset;
          start = firstTickValue;
        }

        value *= log10(end) - log10(start);
        value /= innerDimension;
        value = Math.pow(10, log10(start) + value);
      }

      return value;
    }
  }); // INTERNAL: static default options, registered in src/index.js

  var _defaults$2 = defaultConfig$2;
  scale_logarithmic._defaults = _defaults$2;
  var valueOrDefault$b = helpers$1.valueOrDefault;
  var valueAtIndexOrDefault$1 = helpers$1.valueAtIndexOrDefault;
  var resolve$7 = helpers$1.options.resolve;
  var defaultConfig$3 = {
    display: true,
    // Boolean - Whether to animate scaling the chart from the centre
    animate: true,
    position: 'chartArea',
    angleLines: {
      display: true,
      color: 'rgba(0, 0, 0, 0.1)',
      lineWidth: 1,
      borderDash: [],
      borderDashOffset: 0.0
    },
    gridLines: {
      circular: false
    },
    // label settings
    ticks: {
      // Boolean - Show a backdrop to the scale label
      showLabelBackdrop: true,
      // String - The colour of the label backdrop
      backdropColor: 'rgba(255,255,255,0.75)',
      // Number - The backdrop padding above & below the label in pixels
      backdropPaddingY: 2,
      // Number - The backdrop padding to the side of the label in pixels
      backdropPaddingX: 2,
      callback: core_ticks.formatters.linear
    },
    pointLabels: {
      // Boolean - if true, show point labels
      display: true,
      // Number - Point label font size in pixels
      fontSize: 10,
      // Function - Used to convert point labels
      callback: function (label) {
        return label;
      }
    }
  };

  function getValueCount(scale) {
    var opts = scale.options;
    return opts.angleLines.display || opts.pointLabels.display ? scale.chart.data.labels.length : 0;
  }

  function getTickBackdropHeight(opts) {
    var tickOpts = opts.ticks;

    if (tickOpts.display && opts.display) {
      return valueOrDefault$b(tickOpts.fontSize, core_defaults.global.defaultFontSize) + tickOpts.backdropPaddingY * 2;
    }

    return 0;
  }

  function measureLabelSize(ctx, lineHeight, label) {
    if (helpers$1.isArray(label)) {
      return {
        w: helpers$1.longestText(ctx, ctx.font, label),
        h: label.length * lineHeight
      };
    }

    return {
      w: ctx.measureText(label).width,
      h: lineHeight
    };
  }

  function determineLimits(angle, pos, size, min, max) {
    if (angle === min || angle === max) {
      return {
        start: pos - size / 2,
        end: pos + size / 2
      };
    } else if (angle < min || angle > max) {
      return {
        start: pos - size,
        end: pos
      };
    }

    return {
      start: pos,
      end: pos + size
    };
  }
  /**
   * Helper function to fit a radial linear scale with point labels
   */


  function fitWithPointLabels(scale) {
    // Right, this is really confusing and there is a lot of maths going on here
    // The gist of the problem is here: https://gist.github.com/nnnick/696cc9c55f4b0beb8fe9
    //
    // Reaction: https://dl.dropboxusercontent.com/u/34601363/toomuchscience.gif
    //
    // Solution:
    //
    // We assume the radius of the polygon is half the size of the canvas at first
    // at each index we check if the text overlaps.
    //
    // Where it does, we store that angle and that index.
    //
    // After finding the largest index and angle we calculate how much we need to remove
    // from the shape radius to move the point inwards by that x.
    //
    // We average the left and right distances to get the maximum shape radius that can fit in the box
    // along with labels.
    //
    // Once we have that, we can find the centre point for the chart, by taking the x text protrusion
    // on each side, removing that from the size, halving it and adding the left x protrusion width.
    //
    // This will mean we have a shape fitted to the canvas, as large as it can be with the labels
    // and position it in the most space efficient manner
    //
    // https://dl.dropboxusercontent.com/u/34601363/yeahscience.gif
    var plFont = helpers$1.options._parseFont(scale.options.pointLabels); // Get maximum radius of the polygon. Either half the height (minus the text width) or half the width.
    // Use this to calculate the offset + change. - Make sure L/R protrusion is at least 0 to stop issues with centre points


    var furthestLimits = {
      l: 0,
      r: scale.width,
      t: 0,
      b: scale.height - scale.paddingTop
    };
    var furthestAngles = {};
    var i, textSize, pointPosition;
    scale.ctx.font = plFont.string;
    scale._pointLabelSizes = [];
    var valueCount = getValueCount(scale);

    for (i = 0; i < valueCount; i++) {
      pointPosition = scale.getPointPosition(i, scale.drawingArea + 5);
      textSize = measureLabelSize(scale.ctx, plFont.lineHeight, scale.pointLabels[i] || '');
      scale._pointLabelSizes[i] = textSize; // Add quarter circle to make degree 0 mean top of circle

      var angleRadians = scale.getIndexAngle(i);
      var angle = helpers$1.toDegrees(angleRadians) % 360;
      var hLimits = determineLimits(angle, pointPosition.x, textSize.w, 0, 180);
      var vLimits = determineLimits(angle, pointPosition.y, textSize.h, 90, 270);

      if (hLimits.start < furthestLimits.l) {
        furthestLimits.l = hLimits.start;
        furthestAngles.l = angleRadians;
      }

      if (hLimits.end > furthestLimits.r) {
        furthestLimits.r = hLimits.end;
        furthestAngles.r = angleRadians;
      }

      if (vLimits.start < furthestLimits.t) {
        furthestLimits.t = vLimits.start;
        furthestAngles.t = angleRadians;
      }

      if (vLimits.end > furthestLimits.b) {
        furthestLimits.b = vLimits.end;
        furthestAngles.b = angleRadians;
      }
    }

    scale.setReductions(scale.drawingArea, furthestLimits, furthestAngles);
  }

  function getTextAlignForAngle(angle) {
    if (angle === 0 || angle === 180) {
      return 'center';
    } else if (angle < 180) {
      return 'left';
    }

    return 'right';
  }

  function fillText(ctx, text, position, lineHeight) {
    var y = position.y + lineHeight / 2;
    var i, ilen;

    if (helpers$1.isArray(text)) {
      for (i = 0, ilen = text.length; i < ilen; ++i) {
        ctx.fillText(text[i], position.x, y);
        y += lineHeight;
      }
    } else {
      ctx.fillText(text, position.x, y);
    }
  }

  function adjustPointPositionForLabelHeight(angle, textSize, position) {
    if (angle === 90 || angle === 270) {
      position.y -= textSize.h / 2;
    } else if (angle > 270 || angle < 90) {
      position.y -= textSize.h;
    }
  }

  function drawPointLabels(scale) {
    var ctx = scale.ctx;
    var opts = scale.options;
    var angleLineOpts = opts.angleLines;
    var gridLineOpts = opts.gridLines;
    var pointLabelOpts = opts.pointLabels;
    var lineWidth = valueOrDefault$b(angleLineOpts.lineWidth, gridLineOpts.lineWidth);
    var lineColor = valueOrDefault$b(angleLineOpts.color, gridLineOpts.color);
    var tickBackdropHeight = getTickBackdropHeight(opts);
    ctx.save();
    ctx.lineWidth = lineWidth;
    ctx.strokeStyle = lineColor;

    if (ctx.setLineDash) {
      ctx.setLineDash(resolve$7([angleLineOpts.borderDash, gridLineOpts.borderDash, []]));
      ctx.lineDashOffset = resolve$7([angleLineOpts.borderDashOffset, gridLineOpts.borderDashOffset, 0.0]);
    }

    var outerDistance = scale.getDistanceFromCenterForValue(opts.ticks.reverse ? scale.min : scale.max); // Point Label Font

    var plFont = helpers$1.options._parseFont(pointLabelOpts);

    ctx.font = plFont.string;
    ctx.textBaseline = 'middle';

    for (var i = getValueCount(scale) - 1; i >= 0; i--) {
      if (angleLineOpts.display && lineWidth && lineColor) {
        var outerPosition = scale.getPointPosition(i, outerDistance);
        ctx.beginPath();
        ctx.moveTo(scale.xCenter, scale.yCenter);
        ctx.lineTo(outerPosition.x, outerPosition.y);
        ctx.stroke();
      }

      if (pointLabelOpts.display) {
        // Extra pixels out for some label spacing
        var extra = i === 0 ? tickBackdropHeight / 2 : 0;
        var pointLabelPosition = scale.getPointPosition(i, outerDistance + extra + 5); // Keep this in loop since we may support array properties here

        var pointLabelFontColor = valueAtIndexOrDefault$1(pointLabelOpts.fontColor, i, core_defaults.global.defaultFontColor);
        ctx.fillStyle = pointLabelFontColor;
        var angleRadians = scale.getIndexAngle(i);
        var angle = helpers$1.toDegrees(angleRadians);
        ctx.textAlign = getTextAlignForAngle(angle);
        adjustPointPositionForLabelHeight(angle, scale._pointLabelSizes[i], pointLabelPosition);
        fillText(ctx, scale.pointLabels[i] || '', pointLabelPosition, plFont.lineHeight);
      }
    }

    ctx.restore();
  }

  function drawRadiusLine(scale, gridLineOpts, radius, index) {
    var ctx = scale.ctx;
    var circular = gridLineOpts.circular;
    var valueCount = getValueCount(scale);
    var lineColor = valueAtIndexOrDefault$1(gridLineOpts.color, index - 1);
    var lineWidth = valueAtIndexOrDefault$1(gridLineOpts.lineWidth, index - 1);
    var pointPosition;

    if (!circular && !valueCount || !lineColor || !lineWidth) {
      return;
    }

    ctx.save();
    ctx.strokeStyle = lineColor;
    ctx.lineWidth = lineWidth;

    if (ctx.setLineDash) {
      ctx.setLineDash(gridLineOpts.borderDash || []);
      ctx.lineDashOffset = gridLineOpts.borderDashOffset || 0.0;
    }

    ctx.beginPath();

    if (circular) {
      // Draw circular arcs between the points
      ctx.arc(scale.xCenter, scale.yCenter, radius, 0, Math.PI * 2);
    } else {
      // Draw straight lines connecting each index
      pointPosition = scale.getPointPosition(0, radius);
      ctx.moveTo(pointPosition.x, pointPosition.y);

      for (var i = 1; i < valueCount; i++) {
        pointPosition = scale.getPointPosition(i, radius);
        ctx.lineTo(pointPosition.x, pointPosition.y);
      }
    }

    ctx.closePath();
    ctx.stroke();
    ctx.restore();
  }

  function numberOrZero(param) {
    return helpers$1.isNumber(param) ? param : 0;
  }

  var scale_radialLinear = scale_linearbase.extend({
    setDimensions: function () {
      var me = this; // Set the unconstrained dimension before label rotation

      me.width = me.maxWidth;
      me.height = me.maxHeight;
      me.paddingTop = getTickBackdropHeight(me.options) / 2;
      me.xCenter = Math.floor(me.width / 2);
      me.yCenter = Math.floor((me.height - me.paddingTop) / 2);
      me.drawingArea = Math.min(me.height - me.paddingTop, me.width) / 2;
    },
    determineDataLimits: function () {
      var me = this;
      var chart = me.chart;
      var min = Number.POSITIVE_INFINITY;
      var max = Number.NEGATIVE_INFINITY;
      helpers$1.each(chart.data.datasets, function (dataset, datasetIndex) {
        if (chart.isDatasetVisible(datasetIndex)) {
          var meta = chart.getDatasetMeta(datasetIndex);
          helpers$1.each(dataset.data, function (rawValue, index) {
            var value = +me.getRightValue(rawValue);

            if (isNaN(value) || meta.data[index].hidden) {
              return;
            }

            min = Math.min(value, min);
            max = Math.max(value, max);
          });
        }
      });
      me.min = min === Number.POSITIVE_INFINITY ? 0 : min;
      me.max = max === Number.NEGATIVE_INFINITY ? 0 : max; // Common base implementation to handle ticks.min, ticks.max, ticks.beginAtZero

      me.handleTickRangeOptions();
    },
    // Returns the maximum number of ticks based on the scale dimension
    _computeTickLimit: function () {
      return Math.ceil(this.drawingArea / getTickBackdropHeight(this.options));
    },
    convertTicksToLabels: function () {
      var me = this;
      scale_linearbase.prototype.convertTicksToLabels.call(me); // Point labels

      me.pointLabels = me.chart.data.labels.map(me.options.pointLabels.callback, me);
    },
    getLabelForIndex: function (index, datasetIndex) {
      return +this.getRightValue(this.chart.data.datasets[datasetIndex].data[index]);
    },
    fit: function () {
      var me = this;
      var opts = me.options;

      if (opts.display && opts.pointLabels.display) {
        fitWithPointLabels(me);
      } else {
        me.setCenterPoint(0, 0, 0, 0);
      }
    },

    /**
     * Set radius reductions and determine new radius and center point
     * @private
     */
    setReductions: function (largestPossibleRadius, furthestLimits, furthestAngles) {
      var me = this;
      var radiusReductionLeft = furthestLimits.l / Math.sin(furthestAngles.l);
      var radiusReductionRight = Math.max(furthestLimits.r - me.width, 0) / Math.sin(furthestAngles.r);
      var radiusReductionTop = -furthestLimits.t / Math.cos(furthestAngles.t);
      var radiusReductionBottom = -Math.max(furthestLimits.b - (me.height - me.paddingTop), 0) / Math.cos(furthestAngles.b);
      radiusReductionLeft = numberOrZero(radiusReductionLeft);
      radiusReductionRight = numberOrZero(radiusReductionRight);
      radiusReductionTop = numberOrZero(radiusReductionTop);
      radiusReductionBottom = numberOrZero(radiusReductionBottom);
      me.drawingArea = Math.min(Math.floor(largestPossibleRadius - (radiusReductionLeft + radiusReductionRight) / 2), Math.floor(largestPossibleRadius - (radiusReductionTop + radiusReductionBottom) / 2));
      me.setCenterPoint(radiusReductionLeft, radiusReductionRight, radiusReductionTop, radiusReductionBottom);
    },
    setCenterPoint: function (leftMovement, rightMovement, topMovement, bottomMovement) {
      var me = this;
      var maxRight = me.width - rightMovement - me.drawingArea;
      var maxLeft = leftMovement + me.drawingArea;
      var maxTop = topMovement + me.drawingArea;
      var maxBottom = me.height - me.paddingTop - bottomMovement - me.drawingArea;
      me.xCenter = Math.floor((maxLeft + maxRight) / 2 + me.left);
      me.yCenter = Math.floor((maxTop + maxBottom) / 2 + me.top + me.paddingTop);
    },
    getIndexAngle: function (index) {
      var angleMultiplier = Math.PI * 2 / getValueCount(this);
      var startAngle = this.chart.options && this.chart.options.startAngle ? this.chart.options.startAngle : 0;
      var startAngleRadians = startAngle * Math.PI * 2 / 360; // Start from the top instead of right, so remove a quarter of the circle

      return index * angleMultiplier + startAngleRadians;
    },
    getDistanceFromCenterForValue: function (value) {
      var me = this;

      if (value === null) {
        return 0; // null always in center
      } // Take into account half font size + the yPadding of the top value


      var scalingFactor = me.drawingArea / (me.max - me.min);

      if (me.options.ticks.reverse) {
        return (me.max - value) * scalingFactor;
      }

      return (value - me.min) * scalingFactor;
    },
    getPointPosition: function (index, distanceFromCenter) {
      var me = this;
      var thisAngle = me.getIndexAngle(index) - Math.PI / 2;
      return {
        x: Math.cos(thisAngle) * distanceFromCenter + me.xCenter,
        y: Math.sin(thisAngle) * distanceFromCenter + me.yCenter
      };
    },
    getPointPositionForValue: function (index, value) {
      return this.getPointPosition(index, this.getDistanceFromCenterForValue(value));
    },
    getBasePosition: function () {
      var me = this;
      var min = me.min;
      var max = me.max;
      return me.getPointPositionForValue(0, me.beginAtZero ? 0 : min < 0 && max < 0 ? max : min > 0 && max > 0 ? min : 0);
    },
    draw: function () {
      var me = this;
      var opts = me.options;
      var gridLineOpts = opts.gridLines;
      var tickOpts = opts.ticks;

      if (opts.display) {
        var ctx = me.ctx;
        var startAngle = this.getIndexAngle(0);

        var tickFont = helpers$1.options._parseFont(tickOpts);

        if (opts.angleLines.display || opts.pointLabels.display) {
          drawPointLabels(me);
        }

        helpers$1.each(me.ticks, function (label, index) {
          // Don't draw a centre value (if it is minimum)
          if (index > 0 || tickOpts.reverse) {
            var yCenterOffset = me.getDistanceFromCenterForValue(me.ticksAsNumbers[index]); // Draw circular lines around the scale

            if (gridLineOpts.display && index !== 0) {
              drawRadiusLine(me, gridLineOpts, yCenterOffset, index);
            }

            if (tickOpts.display) {
              var tickFontColor = valueOrDefault$b(tickOpts.fontColor, core_defaults.global.defaultFontColor);
              ctx.font = tickFont.string;
              ctx.save();
              ctx.translate(me.xCenter, me.yCenter);
              ctx.rotate(startAngle);

              if (tickOpts.showLabelBackdrop) {
                var labelWidth = ctx.measureText(label).width;
                ctx.fillStyle = tickOpts.backdropColor;
                ctx.fillRect(-labelWidth / 2 - tickOpts.backdropPaddingX, -yCenterOffset - tickFont.size / 2 - tickOpts.backdropPaddingY, labelWidth + tickOpts.backdropPaddingX * 2, tickFont.size + tickOpts.backdropPaddingY * 2);
              }

              ctx.textAlign = 'center';
              ctx.textBaseline = 'middle';
              ctx.fillStyle = tickFontColor;
              ctx.fillText(label, 0, -yCenterOffset);
              ctx.restore();
            }
          }
        });
      }
    }
  }); // INTERNAL: static default options, registered in src/index.js

  var _defaults$3 = defaultConfig$3;
  scale_radialLinear._defaults = _defaults$3;
  var valueOrDefault$c = helpers$1.valueOrDefault; // Integer constants are from the ES6 spec.

  var MIN_INTEGER = Number.MIN_SAFE_INTEGER || -9007199254740991;
  var MAX_INTEGER = Number.MAX_SAFE_INTEGER || 9007199254740991;
  var INTERVALS = {
    millisecond: {
      common: true,
      size: 1,
      steps: [1, 2, 5, 10, 20, 50, 100, 250, 500]
    },
    second: {
      common: true,
      size: 1000,
      steps: [1, 2, 5, 10, 15, 30]
    },
    minute: {
      common: true,
      size: 60000,
      steps: [1, 2, 5, 10, 15, 30]
    },
    hour: {
      common: true,
      size: 3600000,
      steps: [1, 2, 3, 6, 12]
    },
    day: {
      common: true,
      size: 86400000,
      steps: [1, 2, 5]
    },
    week: {
      common: false,
      size: 604800000,
      steps: [1, 2, 3, 4]
    },
    month: {
      common: true,
      size: 2.628e9,
      steps: [1, 2, 3]
    },
    quarter: {
      common: false,
      size: 7.884e9,
      steps: [1, 2, 3, 4]
    },
    year: {
      common: true,
      size: 3.154e10
    }
  };
  var UNITS = Object.keys(INTERVALS);

  function sorter(a, b) {
    return a - b;
  }

  function arrayUnique(items) {
    var hash = {};
    var out = [];
    var i, ilen, item;

    for (i = 0, ilen = items.length; i < ilen; ++i) {
      item = items[i];

      if (!hash[item]) {
        hash[item] = true;
        out.push(item);
      }
    }

    return out;
  }
  /**
   * Returns an array of {time, pos} objects used to interpolate a specific `time` or position
   * (`pos`) on the scale, by searching entries before and after the requested value. `pos` is
   * a decimal between 0 and 1: 0 being the start of the scale (left or top) and 1 the other
   * extremity (left + width or top + height). Note that it would be more optimized to directly
   * store pre-computed pixels, but the scale dimensions are not guaranteed at the time we need
   * to create the lookup table. The table ALWAYS contains at least two items: min and max.
   *
   * @param {number[]} timestamps - timestamps sorted from lowest to highest.
   * @param {string} distribution - If 'linear', timestamps will be spread linearly along the min
   * and max range, so basically, the table will contains only two items: {min, 0} and {max, 1}.
   * If 'series', timestamps will be positioned at the same distance from each other. In this
   * case, only timestamps that break the time linearity are registered, meaning that in the
   * best case, all timestamps are linear, the table contains only min and max.
   */


  function buildLookupTable(timestamps, min, max, distribution) {
    if (distribution === 'linear' || !timestamps.length) {
      return [{
        time: min,
        pos: 0
      }, {
        time: max,
        pos: 1
      }];
    }

    var table = [];
    var items = [min];
    var i, ilen, prev, curr, next;

    for (i = 0, ilen = timestamps.length; i < ilen; ++i) {
      curr = timestamps[i];

      if (curr > min && curr < max) {
        items.push(curr);
      }
    }

    items.push(max);

    for (i = 0, ilen = items.length; i < ilen; ++i) {
      next = items[i + 1];
      prev = items[i - 1];
      curr = items[i]; // only add points that breaks the scale linearity

      if (prev === undefined || next === undefined || Math.round((next + prev) / 2) !== curr) {
        table.push({
          time: curr,
          pos: i / (ilen - 1)
        });
      }
    }

    return table;
  } // @see adapted from https://www.anujgakhar.com/2014/03/01/binary-search-in-javascript/


  function lookup(table, key, value) {
    var lo = 0;
    var hi = table.length - 1;
    var mid, i0, i1;

    while (lo >= 0 && lo <= hi) {
      mid = lo + hi >> 1;
      i0 = table[mid - 1] || null;
      i1 = table[mid];

      if (!i0) {
        // given value is outside table (before first item)
        return {
          lo: null,
          hi: i1
        };
      } else if (i1[key] < value) {
        lo = mid + 1;
      } else if (i0[key] > value) {
        hi = mid - 1;
      } else {
        return {
          lo: i0,
          hi: i1
        };
      }
    } // given value is outside table (after last item)


    return {
      lo: i1,
      hi: null
    };
  }
  /**
   * Linearly interpolates the given source `value` using the table items `skey` values and
   * returns the associated `tkey` value. For example, interpolate(table, 'time', 42, 'pos')
   * returns the position for a timestamp equal to 42. If value is out of bounds, values at
   * index [0, 1] or [n - 1, n] are used for the interpolation.
   */


  function interpolate$1(table, skey, sval, tkey) {
    var range = lookup(table, skey, sval); // Note: the lookup table ALWAYS contains at least 2 items (min and max)

    var prev = !range.lo ? table[0] : !range.hi ? table[table.length - 2] : range.lo;
    var next = !range.lo ? table[1] : !range.hi ? table[table.length - 1] : range.hi;
    var span = next[skey] - prev[skey];
    var ratio = span ? (sval - prev[skey]) / span : 0;
    var offset = (next[tkey] - prev[tkey]) * ratio;
    return prev[tkey] + offset;
  }

  function toTimestamp(scale, input) {
    var adapter = scale._adapter;
    var options = scale.options.time;
    var parser = options.parser;
    var format = parser || options.format;
    var value = input;

    if (typeof parser === 'function') {
      value = parser(value);
    } // Only parse if its not a timestamp already


    if (!helpers$1.isFinite(value)) {
      value = typeof format === 'string' ? adapter.parse(value, format) : adapter.parse(value);
    }

    if (value !== null) {
      return +value;
    } // Labels are in an incompatible format and no `parser` has been provided.
    // The user might still use the deprecated `format` option for parsing.


    if (!parser && typeof format === 'function') {
      value = format(input); // `format` could return something else than a timestamp, if so, parse it

      if (!helpers$1.isFinite(value)) {
        value = adapter.parse(value);
      }
    }

    return value;
  }

  function parse(scale, input) {
    if (helpers$1.isNullOrUndef(input)) {
      return null;
    }

    var options = scale.options.time;
    var value = toTimestamp(scale, scale.getRightValue(input));

    if (value === null) {
      return value;
    }

    if (options.round) {
      value = +scale._adapter.startOf(value, options.round);
    }

    return value;
  }
  /**
   * Returns the number of unit to skip to be able to display up to `capacity` number of ticks
   * in `unit` for the given `min` / `max` range and respecting the interval steps constraints.
   */


  function determineStepSize(min, max, unit, capacity) {
    var range = max - min;
    var interval = INTERVALS[unit];
    var milliseconds = interval.size;
    var steps = interval.steps;
    var i, ilen, factor;

    if (!steps) {
      return Math.ceil(range / (capacity * milliseconds));
    }

    for (i = 0, ilen = steps.length; i < ilen; ++i) {
      factor = steps[i];

      if (Math.ceil(range / (milliseconds * factor)) <= capacity) {
        break;
      }
    }

    return factor;
  }
  /**
   * Figures out what unit results in an appropriate number of auto-generated ticks
   */


  function determineUnitForAutoTicks(minUnit, min, max, capacity) {
    var ilen = UNITS.length;
    var i, interval, factor;

    for (i = UNITS.indexOf(minUnit); i < ilen - 1; ++i) {
      interval = INTERVALS[UNITS[i]];
      factor = interval.steps ? interval.steps[interval.steps.length - 1] : MAX_INTEGER;

      if (interval.common && Math.ceil((max - min) / (factor * interval.size)) <= capacity) {
        return UNITS[i];
      }
    }

    return UNITS[ilen - 1];
  }
  /**
   * Figures out what unit to format a set of ticks with
   */


  function determineUnitForFormatting(scale, ticks, minUnit, min, max) {
    var ilen = UNITS.length;
    var i, unit;

    for (i = ilen - 1; i >= UNITS.indexOf(minUnit); i--) {
      unit = UNITS[i];

      if (INTERVALS[unit].common && scale._adapter.diff(max, min, unit) >= ticks.length) {
        return unit;
      }
    }

    return UNITS[minUnit ? UNITS.indexOf(minUnit) : 0];
  }

  function determineMajorUnit(unit) {
    for (var i = UNITS.indexOf(unit) + 1, ilen = UNITS.length; i < ilen; ++i) {
      if (INTERVALS[UNITS[i]].common) {
        return UNITS[i];
      }
    }
  }
  /**
   * Generates a maximum of `capacity` timestamps between min and max, rounded to the
   * `minor` unit, aligned on the `major` unit and using the given scale time `options`.
   * Important: this method can return ticks outside the min and max range, it's the
   * responsibility of the calling code to clamp values if needed.
   */


  function generate(scale, min, max, capacity) {
    var adapter = scale._adapter;
    var options = scale.options;
    var timeOpts = options.time;
    var minor = timeOpts.unit || determineUnitForAutoTicks(timeOpts.minUnit, min, max, capacity);
    var major = determineMajorUnit(minor);
    var stepSize = valueOrDefault$c(timeOpts.stepSize, timeOpts.unitStepSize);
    var weekday = minor === 'week' ? timeOpts.isoWeekday : false;
    var majorTicksEnabled = options.ticks.major.enabled;
    var interval = INTERVALS[minor];
    var first = min;
    var last = max;
    var ticks = [];
    var time;

    if (!stepSize) {
      stepSize = determineStepSize(min, max, minor, capacity);
    } // For 'week' unit, handle the first day of week option


    if (weekday) {
      first = +adapter.startOf(first, 'isoWeek', weekday);
      last = +adapter.startOf(last, 'isoWeek', weekday);
    } // Align first/last ticks on unit


    first = +adapter.startOf(first, weekday ? 'day' : minor);
    last = +adapter.startOf(last, weekday ? 'day' : minor); // Make sure that the last tick include max

    if (last < max) {
      last = +adapter.add(last, 1, minor);
    }

    time = first;

    if (majorTicksEnabled && major && !weekday && !timeOpts.round) {
      // Align the first tick on the previous `minor` unit aligned on the `major` unit:
      // we first aligned time on the previous `major` unit then add the number of full
      // stepSize there is between first and the previous major time.
      time = +adapter.startOf(time, major);
      time = +adapter.add(time, ~~((first - time) / (interval.size * stepSize)) * stepSize, minor);
    }

    for (; time < last; time = +adapter.add(time, stepSize, minor)) {
      ticks.push(+time);
    }

    ticks.push(+time);
    return ticks;
  }
  /**
   * Returns the start and end offsets from edges in the form of {start, end}
   * where each value is a relative width to the scale and ranges between 0 and 1.
   * They add extra margins on the both sides by scaling down the original scale.
   * Offsets are added when the `offset` option is true.
   */


  function computeOffsets(table, ticks, min, max, options) {
    var start = 0;
    var end = 0;
    var first, last;

    if (options.offset && ticks.length) {
      if (!options.time.min) {
        first = interpolate$1(table, 'time', ticks[0], 'pos');

        if (ticks.length === 1) {
          start = 1 - first;
        } else {
          start = (interpolate$1(table, 'time', ticks[1], 'pos') - first) / 2;
        }
      }

      if (!options.time.max) {
        last = interpolate$1(table, 'time', ticks[ticks.length - 1], 'pos');

        if (ticks.length === 1) {
          end = last;
        } else {
          end = (last - interpolate$1(table, 'time', ticks[ticks.length - 2], 'pos')) / 2;
        }
      }
    }

    return {
      start: start,
      end: end
    };
  }

  function ticksFromTimestamps(scale, values, majorUnit) {
    var ticks = [];
    var i, ilen, value, major;

    for (i = 0, ilen = values.length; i < ilen; ++i) {
      value = values[i];
      major = majorUnit ? value === +scale._adapter.startOf(value, majorUnit) : false;
      ticks.push({
        value: value,
        major: major
      });
    }

    return ticks;
  }

  var defaultConfig$4 = {
    position: 'bottom',

    /**
     * Data distribution along the scale:
     * - 'linear': data are spread according to their time (distances can vary),
     * - 'series': data are spread at the same distance from each other.
     * @see https://github.com/chartjs/Chart.js/pull/4507
     * @since 2.7.0
     */
    distribution: 'linear',

    /**
     * Scale boundary strategy (bypassed by min/max time options)
     * - `data`: make sure data are fully visible, ticks outside are removed
     * - `ticks`: make sure ticks are fully visible, data outside are truncated
     * @see https://github.com/chartjs/Chart.js/pull/4556
     * @since 2.7.0
     */
    bounds: 'data',
    adapters: {},
    time: {
      parser: false,
      // false == a pattern string from https://momentjs.com/docs/#/parsing/string-format/ or a custom callback that converts its argument to a moment
      format: false,
      // DEPRECATED false == date objects, moment object, callback or a pattern string from https://momentjs.com/docs/#/parsing/string-format/
      unit: false,
      // false == automatic or override with week, month, year, etc.
      round: false,
      // none, or override with week, month, year, etc.
      displayFormat: false,
      // DEPRECATED
      isoWeekday: false,
      // override week start day - see https://momentjs.com/docs/#/get-set/iso-weekday/
      minUnit: 'millisecond',
      displayFormats: {}
    },
    ticks: {
      autoSkip: false,

      /**
       * Ticks generation input values:
       * - 'auto': generates "optimal" ticks based on scale size and time options.
       * - 'data': generates ticks from data (including labels from data {t|x|y} objects).
       * - 'labels': generates ticks from user given `data.labels` values ONLY.
       * @see https://github.com/chartjs/Chart.js/pull/4507
       * @since 2.7.0
       */
      source: 'auto',
      major: {
        enabled: false
      }
    }
  };
  var scale_time = core_scale.extend({
    initialize: function () {
      this.mergeTicksOptions();
      core_scale.prototype.initialize.call(this);
    },
    update: function () {
      var me = this;
      var options = me.options;
      var time = options.time || (options.time = {});
      var adapter = me._adapter = new core_adapters._date(options.adapters.date); // DEPRECATIONS: output a message only one time per update

      if (time.format) {
        console.warn('options.time.format is deprecated and replaced by options.time.parser.');
      } // Backward compatibility: before introducing adapter, `displayFormats` was
      // supposed to contain *all* unit/string pairs but this can't be resolved
      // when loading the scale (adapters are loaded afterward), so let's populate
      // missing formats on update


      helpers$1.mergeIf(time.displayFormats, adapter.formats());
      return core_scale.prototype.update.apply(me, arguments);
    },

    /**
     * Allows data to be referenced via 't' attribute
     */
    getRightValue: function (rawValue) {
      if (rawValue && rawValue.t !== undefined) {
        rawValue = rawValue.t;
      }

      return core_scale.prototype.getRightValue.call(this, rawValue);
    },
    determineDataLimits: function () {
      var me = this;
      var chart = me.chart;
      var adapter = me._adapter;
      var timeOpts = me.options.time;
      var unit = timeOpts.unit || 'day';
      var min = MAX_INTEGER;
      var max = MIN_INTEGER;
      var timestamps = [];
      var datasets = [];
      var labels = [];
      var i, j, ilen, jlen, data, timestamp;
      var dataLabels = chart.data.labels || []; // Convert labels to timestamps

      for (i = 0, ilen = dataLabels.length; i < ilen; ++i) {
        labels.push(parse(me, dataLabels[i]));
      } // Convert data to timestamps


      for (i = 0, ilen = (chart.data.datasets || []).length; i < ilen; ++i) {
        if (chart.isDatasetVisible(i)) {
          data = chart.data.datasets[i].data; // Let's consider that all data have the same format.

          if (helpers$1.isObject(data[0])) {
            datasets[i] = [];

            for (j = 0, jlen = data.length; j < jlen; ++j) {
              timestamp = parse(me, data[j]);
              timestamps.push(timestamp);
              datasets[i][j] = timestamp;
            }
          } else {
            for (j = 0, jlen = labels.length; j < jlen; ++j) {
              timestamps.push(labels[j]);
            }

            datasets[i] = labels.slice(0);
          }
        } else {
          datasets[i] = [];
        }
      }

      if (labels.length) {
        // Sort labels **after** data have been converted
        labels = arrayUnique(labels).sort(sorter);
        min = Math.min(min, labels[0]);
        max = Math.max(max, labels[labels.length - 1]);
      }

      if (timestamps.length) {
        timestamps = arrayUnique(timestamps).sort(sorter);
        min = Math.min(min, timestamps[0]);
        max = Math.max(max, timestamps[timestamps.length - 1]);
      }

      min = parse(me, timeOpts.min) || min;
      max = parse(me, timeOpts.max) || max; // In case there is no valid min/max, set limits based on unit time option

      min = min === MAX_INTEGER ? +adapter.startOf(Date.now(), unit) : min;
      max = max === MIN_INTEGER ? +adapter.endOf(Date.now(), unit) + 1 : max; // Make sure that max is strictly higher than min (required by the lookup table)

      me.min = Math.min(min, max);
      me.max = Math.max(min + 1, max); // PRIVATE

      me._horizontal = me.isHorizontal();
      me._table = [];
      me._timestamps = {
        data: timestamps,
        datasets: datasets,
        labels: labels
      };
    },
    buildTicks: function () {
      var me = this;
      var min = me.min;
      var max = me.max;
      var options = me.options;
      var timeOpts = options.time;
      var timestamps = [];
      var ticks = [];
      var i, ilen, timestamp;

      switch (options.ticks.source) {
        case 'data':
          timestamps = me._timestamps.data;
          break;

        case 'labels':
          timestamps = me._timestamps.labels;
          break;

        case 'auto':
        default:
          timestamps = generate(me, min, max, me.getLabelCapacity(min), options);
      }

      if (options.bounds === 'ticks' && timestamps.length) {
        min = timestamps[0];
        max = timestamps[timestamps.length - 1];
      } // Enforce limits with user min/max options


      min = parse(me, timeOpts.min) || min;
      max = parse(me, timeOpts.max) || max; // Remove ticks outside the min/max range

      for (i = 0, ilen = timestamps.length; i < ilen; ++i) {
        timestamp = timestamps[i];

        if (timestamp >= min && timestamp <= max) {
          ticks.push(timestamp);
        }
      }

      me.min = min;
      me.max = max; // PRIVATE

      me._unit = timeOpts.unit || determineUnitForFormatting(me, ticks, timeOpts.minUnit, me.min, me.max);
      me._majorUnit = determineMajorUnit(me._unit);
      me._table = buildLookupTable(me._timestamps.data, min, max, options.distribution);
      me._offsets = computeOffsets(me._table, ticks, min, max, options);

      if (options.ticks.reverse) {
        ticks.reverse();
      }

      return ticksFromTimestamps(me, ticks, me._majorUnit);
    },
    getLabelForIndex: function (index, datasetIndex) {
      var me = this;
      var adapter = me._adapter;
      var data = me.chart.data;
      var timeOpts = me.options.time;
      var label = data.labels && index < data.labels.length ? data.labels[index] : '';
      var value = data.datasets[datasetIndex].data[index];

      if (helpers$1.isObject(value)) {
        label = me.getRightValue(value);
      }

      if (timeOpts.tooltipFormat) {
        return adapter.format(toTimestamp(me, label), timeOpts.tooltipFormat);
      }

      if (typeof label === 'string') {
        return label;
      }

      return adapter.format(toTimestamp(me, label), timeOpts.displayFormats.datetime);
    },

    /**
     * Function to format an individual tick mark
     * @private
     */
    tickFormatFunction: function (time, index, ticks, format) {
      var me = this;
      var adapter = me._adapter;
      var options = me.options;
      var formats = options.time.displayFormats;
      var minorFormat = formats[me._unit];
      var majorUnit = me._majorUnit;
      var majorFormat = formats[majorUnit];
      var majorTime = +adapter.startOf(time, majorUnit);
      var majorTickOpts = options.ticks.major;
      var major = majorTickOpts.enabled && majorUnit && majorFormat && time === majorTime;
      var label = adapter.format(time, format ? format : major ? majorFormat : minorFormat);
      var tickOpts = major ? majorTickOpts : options.ticks.minor;
      var formatter = valueOrDefault$c(tickOpts.callback, tickOpts.userCallback);
      return formatter ? formatter(label, index, ticks) : label;
    },
    convertTicksToLabels: function (ticks) {
      var labels = [];
      var i, ilen;

      for (i = 0, ilen = ticks.length; i < ilen; ++i) {
        labels.push(this.tickFormatFunction(ticks[i].value, i, ticks));
      }

      return labels;
    },

    /**
     * @private
     */
    getPixelForOffset: function (time) {
      var me = this;
      var isReverse = me.options.ticks.reverse;
      var size = me._horizontal ? me.width : me.height;
      var start = me._horizontal ? isReverse ? me.right : me.left : isReverse ? me.bottom : me.top;
      var pos = interpolate$1(me._table, 'time', time, 'pos');
      var offset = size * (me._offsets.start + pos) / (me._offsets.start + 1 + me._offsets.end);
      return isReverse ? start - offset : start + offset;
    },
    getPixelForValue: function (value, index, datasetIndex) {
      var me = this;
      var time = null;

      if (index !== undefined && datasetIndex !== undefined) {
        time = me._timestamps.datasets[datasetIndex][index];
      }

      if (time === null) {
        time = parse(me, value);
      }

      if (time !== null) {
        return me.getPixelForOffset(time);
      }
    },
    getPixelForTick: function (index) {
      var ticks = this.getTicks();
      return index >= 0 && index < ticks.length ? this.getPixelForOffset(ticks[index].value) : null;
    },
    getValueForPixel: function (pixel) {
      var me = this;
      var size = me._horizontal ? me.width : me.height;
      var start = me._horizontal ? me.left : me.top;
      var pos = (size ? (pixel - start) / size : 0) * (me._offsets.start + 1 + me._offsets.start) - me._offsets.end;
      var time = interpolate$1(me._table, 'pos', pos, 'time'); // DEPRECATION, we should return time directly

      return me._adapter._create(time);
    },

    /**
     * Crude approximation of what the label width might be
     * @private
     */
    getLabelWidth: function (label) {
      var me = this;
      var ticksOpts = me.options.ticks;
      var tickLabelWidth = me.ctx.measureText(label).width;
      var angle = helpers$1.toRadians(ticksOpts.maxRotation);
      var cosRotation = Math.cos(angle);
      var sinRotation = Math.sin(angle);
      var tickFontSize = valueOrDefault$c(ticksOpts.fontSize, core_defaults.global.defaultFontSize);
      return tickLabelWidth * cosRotation + tickFontSize * sinRotation;
    },

    /**
     * @private
     */
    getLabelCapacity: function (exampleTime) {
      var me = this; // pick the longest format (milliseconds) for guestimation

      var format = me.options.time.displayFormats.millisecond;
      var exampleLabel = me.tickFormatFunction(exampleTime, 0, [], format);
      var tickLabelWidth = me.getLabelWidth(exampleLabel);
      var innerWidth = me.isHorizontal() ? me.width : me.height;
      var capacity = Math.floor(innerWidth / tickLabelWidth);
      return capacity > 0 ? capacity : 1;
    }
  }); // INTERNAL: static default options, registered in src/index.js

  var _defaults$4 = defaultConfig$4;
  scale_time._defaults = _defaults$4;
  var scales = {
    category: scale_category,
    linear: scale_linear,
    logarithmic: scale_logarithmic,
    radialLinear: scale_radialLinear,
    time: scale_time
  };
  var FORMATS = {
    datetime: 'MMM D, YYYY, h:mm:ss a',
    millisecond: 'h:mm:ss.SSS a',
    second: 'h:mm:ss a',
    minute: 'h:mm a',
    hour: 'hA',
    day: 'MMM D',
    week: 'll',
    month: 'MMM YYYY',
    quarter: '[Q]Q - YYYY',
    year: 'YYYY'
  };

  core_adapters._date.override(typeof moment === 'function' ? {
    _id: 'moment',
    // DEBUG ONLY
    formats: function () {
      return FORMATS;
    },
    parse: function (value, format) {
      if (typeof value === 'string' && typeof format === 'string') {
        value = moment(value, format);
      } else if (!(value instanceof moment)) {
        value = moment(value);
      }

      return value.isValid() ? value.valueOf() : null;
    },
    format: function (time, format) {
      return moment(time).format(format);
    },
    add: function (time, amount, unit) {
      return moment(time).add(amount, unit).valueOf();
    },
    diff: function (max, min, unit) {
      return moment.duration(moment(max).diff(moment(min))).as(unit);
    },
    startOf: function (time, unit, weekday) {
      time = moment(time);

      if (unit === 'isoWeek') {
        return time.isoWeekday(weekday).valueOf();
      }

      return time.startOf(unit).valueOf();
    },
    endOf: function (time, unit) {
      return moment(time).endOf(unit).valueOf();
    },
    // DEPRECATIONS

    /**
     * Provided for backward compatibility with scale.getValueForPixel().
     * @deprecated since version 2.8.0
     * @todo remove at version 3
     * @private
     */
    _create: function (time) {
      return moment(time);
    }
  } : {});

  core_defaults._set('global', {
    plugins: {
      filler: {
        propagate: true
      }
    }
  });

  var mappers = {
    dataset: function (source) {
      var index = source.fill;
      var chart = source.chart;
      var meta = chart.getDatasetMeta(index);
      var visible = meta && chart.isDatasetVisible(index);
      var points = visible && meta.dataset._children || [];
      var length = points.length || 0;
      return !length ? null : function (point, i) {
        return i < length && points[i]._view || null;
      };
    },
    boundary: function (source) {
      var boundary = source.boundary;
      var x = boundary ? boundary.x : null;
      var y = boundary ? boundary.y : null;
      return function (point) {
        return {
          x: x === null ? point.x : x,
          y: y === null ? point.y : y
        };
      };
    }
  }; // @todo if (fill[0] === '#')

  function decodeFill(el, index, count) {
    var model = el._model || {};
    var fill = model.fill;
    var target;

    if (fill === undefined) {
      fill = !!model.backgroundColor;
    }

    if (fill === false || fill === null) {
      return false;
    }

    if (fill === true) {
      return 'origin';
    }

    target = parseFloat(fill, 10);

    if (isFinite(target) && Math.floor(target) === target) {
      if (fill[0] === '-' || fill[0] === '+') {
        target = index + target;
      }

      if (target === index || target < 0 || target >= count) {
        return false;
      }

      return target;
    }

    switch (fill) {
      // compatibility
      case 'bottom':
        return 'start';

      case 'top':
        return 'end';

      case 'zero':
        return 'origin';
      // supported boundaries

      case 'origin':
      case 'start':
      case 'end':
        return fill;
      // invalid fill values

      default:
        return false;
    }
  }

  function computeBoundary(source) {
    var model = source.el._model || {};
    var scale = source.el._scale || {};
    var fill = source.fill;
    var target = null;
    var horizontal;

    if (isFinite(fill)) {
      return null;
    } // Backward compatibility: until v3, we still need to support boundary values set on
    // the model (scaleTop, scaleBottom and scaleZero) because some external plugins and
    // controllers might still use it (e.g. the Smith chart).


    if (fill === 'start') {
      target = model.scaleBottom === undefined ? scale.bottom : model.scaleBottom;
    } else if (fill === 'end') {
      target = model.scaleTop === undefined ? scale.top : model.scaleTop;
    } else if (model.scaleZero !== undefined) {
      target = model.scaleZero;
    } else if (scale.getBasePosition) {
      target = scale.getBasePosition();
    } else if (scale.getBasePixel) {
      target = scale.getBasePixel();
    }

    if (target !== undefined && target !== null) {
      if (target.x !== undefined && target.y !== undefined) {
        return target;
      }

      if (helpers$1.isFinite(target)) {
        horizontal = scale.isHorizontal();
        return {
          x: horizontal ? target : null,
          y: horizontal ? null : target
        };
      }
    }

    return null;
  }

  function resolveTarget(sources, index, propagate) {
    var source = sources[index];
    var fill = source.fill;
    var visited = [index];
    var target;

    if (!propagate) {
      return fill;
    }

    while (fill !== false && visited.indexOf(fill) === -1) {
      if (!isFinite(fill)) {
        return fill;
      }

      target = sources[fill];

      if (!target) {
        return false;
      }

      if (target.visible) {
        return fill;
      }

      visited.push(fill);
      fill = target.fill;
    }

    return false;
  }

  function createMapper(source) {
    var fill = source.fill;
    var type = 'dataset';

    if (fill === false) {
      return null;
    }

    if (!isFinite(fill)) {
      type = 'boundary';
    }

    return mappers[type](source);
  }

  function isDrawable(point) {
    return point && !point.skip;
  }

  function drawArea(ctx, curve0, curve1, len0, len1) {
    var i;

    if (!len0 || !len1) {
      return;
    } // building first area curve (normal)


    ctx.moveTo(curve0[0].x, curve0[0].y);

    for (i = 1; i < len0; ++i) {
      helpers$1.canvas.lineTo(ctx, curve0[i - 1], curve0[i]);
    } // joining the two area curves


    ctx.lineTo(curve1[len1 - 1].x, curve1[len1 - 1].y); // building opposite area curve (reverse)

    for (i = len1 - 1; i > 0; --i) {
      helpers$1.canvas.lineTo(ctx, curve1[i], curve1[i - 1], true);
    }
  }

  function doFill(ctx, points, mapper, view, color, loop) {
    var count = points.length;
    var span = view.spanGaps;
    var curve0 = [];
    var curve1 = [];
    var len0 = 0;
    var len1 = 0;
    var i, ilen, index, p0, p1, d0, d1;
    ctx.beginPath();

    for (i = 0, ilen = count + !!loop; i < ilen; ++i) {
      index = i % count;
      p0 = points[index]._view;
      p1 = mapper(p0, index, view);
      d0 = isDrawable(p0);
      d1 = isDrawable(p1);

      if (d0 && d1) {
        len0 = curve0.push(p0);
        len1 = curve1.push(p1);
      } else if (len0 && len1) {
        if (!span) {
          drawArea(ctx, curve0, curve1, len0, len1);
          len0 = len1 = 0;
          curve0 = [];
          curve1 = [];
        } else {
          if (d0) {
            curve0.push(p0);
          }

          if (d1) {
            curve1.push(p1);
          }
        }
      }
    }

    drawArea(ctx, curve0, curve1, len0, len1);
    ctx.closePath();
    ctx.fillStyle = color;
    ctx.fill();
  }

  var plugin_filler = {
    id: 'filler',
    afterDatasetsUpdate: function (chart, options) {
      var count = (chart.data.datasets || []).length;
      var propagate = options.propagate;
      var sources = [];
      var meta, i, el, source;

      for (i = 0; i < count; ++i) {
        meta = chart.getDatasetMeta(i);
        el = meta.dataset;
        source = null;

        if (el && el._model && el instanceof elements.Line) {
          source = {
            visible: chart.isDatasetVisible(i),
            fill: decodeFill(el, i, count),
            chart: chart,
            el: el
          };
        }

        meta.$filler = source;
        sources.push(source);
      }

      for (i = 0; i < count; ++i) {
        source = sources[i];

        if (!source) {
          continue;
        }

        source.fill = resolveTarget(sources, i, propagate);
        source.boundary = computeBoundary(source);
        source.mapper = createMapper(source);
      }
    },
    beforeDatasetDraw: function (chart, args) {
      var meta = args.meta.$filler;

      if (!meta) {
        return;
      }

      var ctx = chart.ctx;
      var el = meta.el;
      var view = el._view;
      var points = el._children || [];
      var mapper = meta.mapper;
      var color = view.backgroundColor || core_defaults.global.defaultColor;

      if (mapper && color && points.length) {
        helpers$1.canvas.clipArea(ctx, chart.chartArea);
        doFill(ctx, points, mapper, view, color, el._loop);
        helpers$1.canvas.unclipArea(ctx);
      }
    }
  };
  var noop$1 = helpers$1.noop;
  var valueOrDefault$d = helpers$1.valueOrDefault;

  core_defaults._set('global', {
    legend: {
      display: true,
      position: 'top',
      fullWidth: true,
      reverse: false,
      weight: 1000,
      // a callback that will handle
      onClick: function (e, legendItem) {
        var index = legendItem.datasetIndex;
        var ci = this.chart;
        var meta = ci.getDatasetMeta(index); // See controller.isDatasetVisible comment

        meta.hidden = meta.hidden === null ? !ci.data.datasets[index].hidden : null; // We hid a dataset ... rerender the chart

        ci.update();
      },
      onHover: null,
      onLeave: null,
      labels: {
        boxWidth: 40,
        padding: 10,
        // Generates labels shown in the legend
        // Valid properties to return:
        // text : text to display
        // fillStyle : fill of coloured box
        // strokeStyle: stroke of coloured box
        // hidden : if this legend item refers to a hidden item
        // lineCap : cap style for line
        // lineDash
        // lineDashOffset :
        // lineJoin :
        // lineWidth :
        generateLabels: function (chart) {
          var data = chart.data;
          return helpers$1.isArray(data.datasets) ? data.datasets.map(function (dataset, i) {
            return {
              text: dataset.label,
              fillStyle: !helpers$1.isArray(dataset.backgroundColor) ? dataset.backgroundColor : dataset.backgroundColor[0],
              hidden: !chart.isDatasetVisible(i),
              lineCap: dataset.borderCapStyle,
              lineDash: dataset.borderDash,
              lineDashOffset: dataset.borderDashOffset,
              lineJoin: dataset.borderJoinStyle,
              lineWidth: dataset.borderWidth,
              strokeStyle: dataset.borderColor,
              pointStyle: dataset.pointStyle,
              // Below is extra data used for toggling the datasets
              datasetIndex: i
            };
          }, this) : [];
        }
      }
    },
    legendCallback: function (chart) {
      var text = [];
      text.push('<ul class="' + chart.id + '-legend">');

      for (var i = 0; i < chart.data.datasets.length; i++) {
        text.push('<li><span style="background-color:' + chart.data.datasets[i].backgroundColor + '"></span>');

        if (chart.data.datasets[i].label) {
          text.push(chart.data.datasets[i].label);
        }

        text.push('</li>');
      }

      text.push('</ul>');
      return text.join('');
    }
  });
  /**
   * Helper function to get the box width based on the usePointStyle option
   * @param {object} labelopts - the label options on the legend
   * @param {number} fontSize - the label font size
   * @return {number} width of the color box area
   */


  function getBoxWidth(labelOpts, fontSize) {
    return labelOpts.usePointStyle && labelOpts.boxWidth > fontSize ? fontSize : labelOpts.boxWidth;
  }
  /**
   * IMPORTANT: this class is exposed publicly as Chart.Legend, backward compatibility required!
   */


  var Legend = core_element.extend({
    initialize: function (config) {
      helpers$1.extend(this, config); // Contains hit boxes for each dataset (in dataset order)

      this.legendHitBoxes = [];
      /**
      	 * @private
      	 */

      this._hoveredItem = null; // Are we in doughnut mode which has a different data type

      this.doughnutMode = false;
    },
    // These methods are ordered by lifecycle. Utilities then follow.
    // Any function defined here is inherited by all legend types.
    // Any function can be extended by the legend type
    beforeUpdate: noop$1,
    update: function (maxWidth, maxHeight, margins) {
      var me = this; // Update Lifecycle - Probably don't want to ever extend or overwrite this function ;)

      me.beforeUpdate(); // Absorb the master measurements

      me.maxWidth = maxWidth;
      me.maxHeight = maxHeight;
      me.margins = margins; // Dimensions

      me.beforeSetDimensions();
      me.setDimensions();
      me.afterSetDimensions(); // Labels

      me.beforeBuildLabels();
      me.buildLabels();
      me.afterBuildLabels(); // Fit

      me.beforeFit();
      me.fit();
      me.afterFit(); //

      me.afterUpdate();
      return me.minSize;
    },
    afterUpdate: noop$1,
    //
    beforeSetDimensions: noop$1,
    setDimensions: function () {
      var me = this; // Set the unconstrained dimension before label rotation

      if (me.isHorizontal()) {
        // Reset position before calculating rotation
        me.width = me.maxWidth;
        me.left = 0;
        me.right = me.width;
      } else {
        me.height = me.maxHeight; // Reset position before calculating rotation

        me.top = 0;
        me.bottom = me.height;
      } // Reset padding


      me.paddingLeft = 0;
      me.paddingTop = 0;
      me.paddingRight = 0;
      me.paddingBottom = 0; // Reset minSize

      me.minSize = {
        width: 0,
        height: 0
      };
    },
    afterSetDimensions: noop$1,
    //
    beforeBuildLabels: noop$1,
    buildLabels: function () {
      var me = this;
      var labelOpts = me.options.labels || {};
      var legendItems = helpers$1.callback(labelOpts.generateLabels, [me.chart], me) || [];

      if (labelOpts.filter) {
        legendItems = legendItems.filter(function (item) {
          return labelOpts.filter(item, me.chart.data);
        });
      }

      if (me.options.reverse) {
        legendItems.reverse();
      }

      me.legendItems = legendItems;
    },
    afterBuildLabels: noop$1,
    //
    beforeFit: noop$1,
    fit: function () {
      var me = this;
      var opts = me.options;
      var labelOpts = opts.labels;
      var display = opts.display;
      var ctx = me.ctx;

      var labelFont = helpers$1.options._parseFont(labelOpts);

      var fontSize = labelFont.size; // Reset hit boxes

      var hitboxes = me.legendHitBoxes = [];
      var minSize = me.minSize;
      var isHorizontal = me.isHorizontal();

      if (isHorizontal) {
        minSize.width = me.maxWidth; // fill all the width

        minSize.height = display ? 10 : 0;
      } else {
        minSize.width = display ? 10 : 0;
        minSize.height = me.maxHeight; // fill all the height
      } // Increase sizes here


      if (display) {
        ctx.font = labelFont.string;

        if (isHorizontal) {
          // Labels
          // Width of each line of legend boxes. Labels wrap onto multiple lines when there are too many to fit on one
          var lineWidths = me.lineWidths = [0];
          var totalHeight = 0;
          ctx.textAlign = 'left';
          ctx.textBaseline = 'top';
          helpers$1.each(me.legendItems, function (legendItem, i) {
            var boxWidth = getBoxWidth(labelOpts, fontSize);
            var width = boxWidth + fontSize / 2 + ctx.measureText(legendItem.text).width;

            if (i === 0 || lineWidths[lineWidths.length - 1] + width + labelOpts.padding > minSize.width) {
              totalHeight += fontSize + labelOpts.padding;
              lineWidths[lineWidths.length - (i > 0 ? 0 : 1)] = labelOpts.padding;
            } // Store the hitbox width and height here. Final position will be updated in `draw`


            hitboxes[i] = {
              left: 0,
              top: 0,
              width: width,
              height: fontSize
            };
            lineWidths[lineWidths.length - 1] += width + labelOpts.padding;
          });
          minSize.height += totalHeight;
        } else {
          var vPadding = labelOpts.padding;
          var columnWidths = me.columnWidths = [];
          var totalWidth = labelOpts.padding;
          var currentColWidth = 0;
          var currentColHeight = 0;
          var itemHeight = fontSize + vPadding;
          helpers$1.each(me.legendItems, function (legendItem, i) {
            var boxWidth = getBoxWidth(labelOpts, fontSize);
            var itemWidth = boxWidth + fontSize / 2 + ctx.measureText(legendItem.text).width; // If too tall, go to new column

            if (i > 0 && currentColHeight + itemHeight > minSize.height - vPadding) {
              totalWidth += currentColWidth + labelOpts.padding;
              columnWidths.push(currentColWidth); // previous column width

              currentColWidth = 0;
              currentColHeight = 0;
            } // Get max width


            currentColWidth = Math.max(currentColWidth, itemWidth);
            currentColHeight += itemHeight; // Store the hitbox width and height here. Final position will be updated in `draw`

            hitboxes[i] = {
              left: 0,
              top: 0,
              width: itemWidth,
              height: fontSize
            };
          });
          totalWidth += currentColWidth;
          columnWidths.push(currentColWidth);
          minSize.width += totalWidth;
        }
      }

      me.width = minSize.width;
      me.height = minSize.height;
    },
    afterFit: noop$1,
    // Shared Methods
    isHorizontal: function () {
      return this.options.position === 'top' || this.options.position === 'bottom';
    },
    // Actually draw the legend on the canvas
    draw: function () {
      var me = this;
      var opts = me.options;
      var labelOpts = opts.labels;
      var globalDefaults = core_defaults.global;
      var defaultColor = globalDefaults.defaultColor;
      var lineDefault = globalDefaults.elements.line;
      var legendWidth = me.width;
      var lineWidths = me.lineWidths;

      if (opts.display) {
        var ctx = me.ctx;
        var fontColor = valueOrDefault$d(labelOpts.fontColor, globalDefaults.defaultFontColor);

        var labelFont = helpers$1.options._parseFont(labelOpts);

        var fontSize = labelFont.size;
        var cursor; // Canvas setup

        ctx.textAlign = 'left';
        ctx.textBaseline = 'middle';
        ctx.lineWidth = 0.5;
        ctx.strokeStyle = fontColor; // for strikethrough effect

        ctx.fillStyle = fontColor; // render in correct colour

        ctx.font = labelFont.string;
        var boxWidth = getBoxWidth(labelOpts, fontSize);
        var hitboxes = me.legendHitBoxes; // current position

        var drawLegendBox = function (x, y, legendItem) {
          if (isNaN(boxWidth) || boxWidth <= 0) {
            return;
          } // Set the ctx for the box


          ctx.save();
          var lineWidth = valueOrDefault$d(legendItem.lineWidth, lineDefault.borderWidth);
          ctx.fillStyle = valueOrDefault$d(legendItem.fillStyle, defaultColor);
          ctx.lineCap = valueOrDefault$d(legendItem.lineCap, lineDefault.borderCapStyle);
          ctx.lineDashOffset = valueOrDefault$d(legendItem.lineDashOffset, lineDefault.borderDashOffset);
          ctx.lineJoin = valueOrDefault$d(legendItem.lineJoin, lineDefault.borderJoinStyle);
          ctx.lineWidth = lineWidth;
          ctx.strokeStyle = valueOrDefault$d(legendItem.strokeStyle, defaultColor);

          if (ctx.setLineDash) {
            // IE 9 and 10 do not support line dash
            ctx.setLineDash(valueOrDefault$d(legendItem.lineDash, lineDefault.borderDash));
          }

          if (opts.labels && opts.labels.usePointStyle) {
            // Recalculate x and y for drawPoint() because its expecting
            // x and y to be center of figure (instead of top left)
            var radius = boxWidth * Math.SQRT2 / 2;
            var centerX = x + boxWidth / 2;
            var centerY = y + fontSize / 2; // Draw pointStyle as legend symbol

            helpers$1.canvas.drawPoint(ctx, legendItem.pointStyle, radius, centerX, centerY);
          } else {
            // Draw box as legend symbol
            if (lineWidth !== 0) {
              ctx.strokeRect(x, y, boxWidth, fontSize);
            }

            ctx.fillRect(x, y, boxWidth, fontSize);
          }

          ctx.restore();
        };

        var fillText = function (x, y, legendItem, textWidth) {
          var halfFontSize = fontSize / 2;
          var xLeft = boxWidth + halfFontSize + x;
          var yMiddle = y + halfFontSize;
          ctx.fillText(legendItem.text, xLeft, yMiddle);

          if (legendItem.hidden) {
            // Strikethrough the text if hidden
            ctx.beginPath();
            ctx.lineWidth = 2;
            ctx.moveTo(xLeft, yMiddle);
            ctx.lineTo(xLeft + textWidth, yMiddle);
            ctx.stroke();
          }
        }; // Horizontal


        var isHorizontal = me.isHorizontal();

        if (isHorizontal) {
          cursor = {
            x: me.left + (legendWidth - lineWidths[0]) / 2 + labelOpts.padding,
            y: me.top + labelOpts.padding,
            line: 0
          };
        } else {
          cursor = {
            x: me.left + labelOpts.padding,
            y: me.top + labelOpts.padding,
            line: 0
          };
        }

        var itemHeight = fontSize + labelOpts.padding;
        helpers$1.each(me.legendItems, function (legendItem, i) {
          var textWidth = ctx.measureText(legendItem.text).width;
          var width = boxWidth + fontSize / 2 + textWidth;
          var x = cursor.x;
          var y = cursor.y; // Use (me.left + me.minSize.width) and (me.top + me.minSize.height)
          // instead of me.right and me.bottom because me.width and me.height
          // may have been changed since me.minSize was calculated

          if (isHorizontal) {
            if (i > 0 && x + width + labelOpts.padding > me.left + me.minSize.width) {
              y = cursor.y += itemHeight;
              cursor.line++;
              x = cursor.x = me.left + (legendWidth - lineWidths[cursor.line]) / 2 + labelOpts.padding;
            }
          } else if (i > 0 && y + itemHeight > me.top + me.minSize.height) {
            x = cursor.x = x + me.columnWidths[cursor.line] + labelOpts.padding;
            y = cursor.y = me.top + labelOpts.padding;
            cursor.line++;
          }

          drawLegendBox(x, y, legendItem);
          hitboxes[i].left = x;
          hitboxes[i].top = y; // Fill the actual label

          fillText(x, y, legendItem, textWidth);

          if (isHorizontal) {
            cursor.x += width + labelOpts.padding;
          } else {
            cursor.y += itemHeight;
          }
        });
      }
    },

    /**
     * @private
     */
    _getLegendItemAt: function (x, y) {
      var me = this;
      var i, hitBox, lh;

      if (x >= me.left && x <= me.right && y >= me.top && y <= me.bottom) {
        // See if we are touching one of the dataset boxes
        lh = me.legendHitBoxes;

        for (i = 0; i < lh.length; ++i) {
          hitBox = lh[i];

          if (x >= hitBox.left && x <= hitBox.left + hitBox.width && y >= hitBox.top && y <= hitBox.top + hitBox.height) {
            // Touching an element
            return me.legendItems[i];
          }
        }
      }

      return null;
    },

    /**
     * Handle an event
     * @private
     * @param {IEvent} event - The event to handle
     */
    handleEvent: function (e) {
      var me = this;
      var opts = me.options;
      var type = e.type === 'mouseup' ? 'click' : e.type;
      var hoveredItem;

      if (type === 'mousemove') {
        if (!opts.onHover && !opts.onLeave) {
          return;
        }
      } else if (type === 'click') {
        if (!opts.onClick) {
          return;
        }
      } else {
        return;
      } // Chart event already has relative position in it


      hoveredItem = me._getLegendItemAt(e.x, e.y);

      if (type === 'click') {
        if (hoveredItem && opts.onClick) {
          // use e.native for backwards compatibility
          opts.onClick.call(me, e.native, hoveredItem);
        }
      } else {
        if (opts.onLeave && hoveredItem !== me._hoveredItem) {
          if (me._hoveredItem) {
            opts.onLeave.call(me, e.native, me._hoveredItem);
          }

          me._hoveredItem = hoveredItem;
        }

        if (opts.onHover && hoveredItem) {
          // use e.native for backwards compatibility
          opts.onHover.call(me, e.native, hoveredItem);
        }
      }
    }
  });

  function createNewLegendAndAttach(chart, legendOpts) {
    var legend = new Legend({
      ctx: chart.ctx,
      options: legendOpts,
      chart: chart
    });
    core_layouts.configure(chart, legend, legendOpts);
    core_layouts.addBox(chart, legend);
    chart.legend = legend;
  }

  var plugin_legend = {
    id: 'legend',

    /**
     * Backward compatibility: since 2.1.5, the legend is registered as a plugin, making
     * Chart.Legend obsolete. To avoid a breaking change, we export the Legend as part of
     * the plugin, which one will be re-exposed in the chart.js file.
     * https://github.com/chartjs/Chart.js/pull/2640
     * @private
     */
    _element: Legend,
    beforeInit: function (chart) {
      var legendOpts = chart.options.legend;

      if (legendOpts) {
        createNewLegendAndAttach(chart, legendOpts);
      }
    },
    beforeUpdate: function (chart) {
      var legendOpts = chart.options.legend;
      var legend = chart.legend;

      if (legendOpts) {
        helpers$1.mergeIf(legendOpts, core_defaults.global.legend);

        if (legend) {
          core_layouts.configure(chart, legend, legendOpts);
          legend.options = legendOpts;
        } else {
          createNewLegendAndAttach(chart, legendOpts);
        }
      } else if (legend) {
        core_layouts.removeBox(chart, legend);
        delete chart.legend;
      }
    },
    afterEvent: function (chart, e) {
      var legend = chart.legend;

      if (legend) {
        legend.handleEvent(e);
      }
    }
  };
  var noop$2 = helpers$1.noop;

  core_defaults._set('global', {
    title: {
      display: false,
      fontStyle: 'bold',
      fullWidth: true,
      padding: 10,
      position: 'top',
      text: '',
      weight: 2000 // by default greater than legend (1000) to be above

    }
  });
  /**
   * IMPORTANT: this class is exposed publicly as Chart.Legend, backward compatibility required!
   */


  var Title = core_element.extend({
    initialize: function (config) {
      var me = this;
      helpers$1.extend(me, config); // Contains hit boxes for each dataset (in dataset order)

      me.legendHitBoxes = [];
    },
    // These methods are ordered by lifecycle. Utilities then follow.
    beforeUpdate: noop$2,
    update: function (maxWidth, maxHeight, margins) {
      var me = this; // Update Lifecycle - Probably don't want to ever extend or overwrite this function ;)

      me.beforeUpdate(); // Absorb the master measurements

      me.maxWidth = maxWidth;
      me.maxHeight = maxHeight;
      me.margins = margins; // Dimensions

      me.beforeSetDimensions();
      me.setDimensions();
      me.afterSetDimensions(); // Labels

      me.beforeBuildLabels();
      me.buildLabels();
      me.afterBuildLabels(); // Fit

      me.beforeFit();
      me.fit();
      me.afterFit(); //

      me.afterUpdate();
      return me.minSize;
    },
    afterUpdate: noop$2,
    //
    beforeSetDimensions: noop$2,
    setDimensions: function () {
      var me = this; // Set the unconstrained dimension before label rotation

      if (me.isHorizontal()) {
        // Reset position before calculating rotation
        me.width = me.maxWidth;
        me.left = 0;
        me.right = me.width;
      } else {
        me.height = me.maxHeight; // Reset position before calculating rotation

        me.top = 0;
        me.bottom = me.height;
      } // Reset padding


      me.paddingLeft = 0;
      me.paddingTop = 0;
      me.paddingRight = 0;
      me.paddingBottom = 0; // Reset minSize

      me.minSize = {
        width: 0,
        height: 0
      };
    },
    afterSetDimensions: noop$2,
    //
    beforeBuildLabels: noop$2,
    buildLabels: noop$2,
    afterBuildLabels: noop$2,
    //
    beforeFit: noop$2,
    fit: function () {
      var me = this;
      var opts = me.options;
      var display = opts.display;
      var minSize = me.minSize;
      var lineCount = helpers$1.isArray(opts.text) ? opts.text.length : 1;

      var fontOpts = helpers$1.options._parseFont(opts);

      var textSize = display ? lineCount * fontOpts.lineHeight + opts.padding * 2 : 0;

      if (me.isHorizontal()) {
        minSize.width = me.maxWidth; // fill all the width

        minSize.height = textSize;
      } else {
        minSize.width = textSize;
        minSize.height = me.maxHeight; // fill all the height
      }

      me.width = minSize.width;
      me.height = minSize.height;
    },
    afterFit: noop$2,
    // Shared Methods
    isHorizontal: function () {
      var pos = this.options.position;
      return pos === 'top' || pos === 'bottom';
    },
    // Actually draw the title block on the canvas
    draw: function () {
      var me = this;
      var ctx = me.ctx;
      var opts = me.options;

      if (opts.display) {
        var fontOpts = helpers$1.options._parseFont(opts);

        var lineHeight = fontOpts.lineHeight;
        var offset = lineHeight / 2 + opts.padding;
        var rotation = 0;
        var top = me.top;
        var left = me.left;
        var bottom = me.bottom;
        var right = me.right;
        var maxWidth, titleX, titleY;
        ctx.fillStyle = helpers$1.valueOrDefault(opts.fontColor, core_defaults.global.defaultFontColor); // render in correct colour

        ctx.font = fontOpts.string; // Horizontal

        if (me.isHorizontal()) {
          titleX = left + (right - left) / 2; // midpoint of the width

          titleY = top + offset;
          maxWidth = right - left;
        } else {
          titleX = opts.position === 'left' ? left + offset : right - offset;
          titleY = top + (bottom - top) / 2;
          maxWidth = bottom - top;
          rotation = Math.PI * (opts.position === 'left' ? -0.5 : 0.5);
        }

        ctx.save();
        ctx.translate(titleX, titleY);
        ctx.rotate(rotation);
        ctx.textAlign = 'center';
        ctx.textBaseline = 'middle';
        var text = opts.text;

        if (helpers$1.isArray(text)) {
          var y = 0;

          for (var i = 0; i < text.length; ++i) {
            ctx.fillText(text[i], 0, y, maxWidth);
            y += lineHeight;
          }
        } else {
          ctx.fillText(text, 0, 0, maxWidth);
        }

        ctx.restore();
      }
    }
  });

  function createNewTitleBlockAndAttach(chart, titleOpts) {
    var title = new Title({
      ctx: chart.ctx,
      options: titleOpts,
      chart: chart
    });
    core_layouts.configure(chart, title, titleOpts);
    core_layouts.addBox(chart, title);
    chart.titleBlock = title;
  }

  var plugin_title = {
    id: 'title',

    /**
     * Backward compatibility: since 2.1.5, the title is registered as a plugin, making
     * Chart.Title obsolete. To avoid a breaking change, we export the Title as part of
     * the plugin, which one will be re-exposed in the chart.js file.
     * https://github.com/chartjs/Chart.js/pull/2640
     * @private
     */
    _element: Title,
    beforeInit: function (chart) {
      var titleOpts = chart.options.title;

      if (titleOpts) {
        createNewTitleBlockAndAttach(chart, titleOpts);
      }
    },
    beforeUpdate: function (chart) {
      var titleOpts = chart.options.title;
      var titleBlock = chart.titleBlock;

      if (titleOpts) {
        helpers$1.mergeIf(titleOpts, core_defaults.global.title);

        if (titleBlock) {
          core_layouts.configure(chart, titleBlock, titleOpts);
          titleBlock.options = titleOpts;
        } else {
          createNewTitleBlockAndAttach(chart, titleOpts);
        }
      } else if (titleBlock) {
        core_layouts.removeBox(chart, titleBlock);
        delete chart.titleBlock;
      }
    }
  };
  var plugins = {};
  var filler = plugin_filler;
  var legend = plugin_legend;
  var title = plugin_title;
  plugins.filler = filler;
  plugins.legend = legend;
  plugins.title = title;
  /**
   * @namespace Chart
   */

  core_controller.helpers = helpers$1; // @todo dispatch these helpers into appropriated helpers/helpers.* file and write unit tests!

  core_helpers(core_controller);
  core_controller._adapters = core_adapters;
  core_controller.Animation = core_animation;
  core_controller.animationService = core_animations;
  core_controller.controllers = controllers;
  core_controller.DatasetController = core_datasetController;
  core_controller.defaults = core_defaults;
  core_controller.Element = core_element;
  core_controller.elements = elements;
  core_controller.Interaction = core_interaction;
  core_controller.layouts = core_layouts;
  core_controller.platform = platform;
  core_controller.plugins = core_plugins;
  core_controller.Scale = core_scale;
  core_controller.scaleService = core_scaleService;
  core_controller.Ticks = core_ticks;
  core_controller.Tooltip = core_tooltip; // Register built-in scales

  core_controller.helpers.each(scales, function (scale, type) {
    core_controller.scaleService.registerScaleType(type, scale, scale._defaults);
  }); // Load to register built-in adapters (as side effects)
  // Loading built-in plugins

  for (var k in plugins) {
    if (plugins.hasOwnProperty(k)) {
      core_controller.plugins.register(plugins[k]);
    }
  }

  core_controller.platform.initialize();
  var src = core_controller;

  if (typeof window !== 'undefined') {
    window.Chart = core_controller;
  } // DEPRECATIONS

  /**
   * Provided for backward compatibility, not available anymore
   * @namespace Chart.Chart
   * @deprecated since version 2.8.0
   * @todo remove at version 3
   * @private
   */


  core_controller.Chart = core_controller;
  /**
   * Provided for backward compatibility, not available anymore
   * @namespace Chart.Legend
   * @deprecated since version 2.1.5
   * @todo remove at version 3
   * @private
   */

  core_controller.Legend = plugins.legend._element;
  /**
   * Provided for backward compatibility, not available anymore
   * @namespace Chart.Title
   * @deprecated since version 2.1.5
   * @todo remove at version 3
   * @private
   */

  core_controller.Title = plugins.title._element;
  /**
   * Provided for backward compatibility, use Chart.plugins instead
   * @namespace Chart.pluginService
   * @deprecated since version 2.1.5
   * @todo remove at version 3
   * @private
   */

  core_controller.pluginService = core_controller.plugins;
  /**
   * Provided for backward compatibility, inheriting from Chart.PlugingBase has no
   * effect, instead simply create/register plugins via plain JavaScript objects.
   * @interface Chart.PluginBase
   * @deprecated since version 2.5.0
   * @todo remove at version 3
   * @private
   */

  core_controller.PluginBase = core_controller.Element.extend({});
  /**
   * Provided for backward compatibility, use Chart.helpers.canvas instead.
   * @namespace Chart.canvasHelpers
   * @deprecated since version 2.6.0
   * @todo remove at version 3
   * @private
   */

  core_controller.canvasHelpers = core_controller.helpers.canvas;
  /**
   * Provided for backward compatibility, use Chart.layouts instead.
   * @namespace Chart.layoutService
   * @deprecated since version 2.7.3
   * @todo remove at version 3
   * @private
   */

  core_controller.layoutService = core_controller.layouts;
  /**
   * Provided for backward compatibility, not available anymore.
   * @namespace Chart.LinearScaleBase
   * @deprecated since version 2.8
   * @todo remove at version 3
   * @private
   */

  core_controller.LinearScaleBase = scale_linearbase;
  /**
   * Provided for backward compatibility, instead we should create a new Chart
   * by setting the type in the config (`new Chart(id, {type: '{chart-type}'}`).
   * @deprecated since version 2.8.0
   * @todo remove at version 3
   */

  core_controller.helpers.each(['Bar', 'Bubble', 'Doughnut', 'Line', 'PolarArea', 'Radar', 'Scatter'], function (klass) {
    core_controller[klass] = function (ctx, cfg) {
      return new core_controller(ctx, core_controller.helpers.merge(cfg || {}, {
        type: klass.charAt(0).toLowerCase() + klass.slice(1)
      }));
    };
  });
  return src;
});

/***/ }),

/***/ "./node_modules/chartjs-chart-timeline/src/timeline.js":
/*!*************************************************************!*\
  !*** ./node_modules/chartjs-chart-timeline/src/timeline.js ***!
  \*************************************************************/
/*! no exports provided */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var chart_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! chart.js */ "./node_modules/chart.js/dist/Chart.js");
/* harmony import */ var chart_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(chart_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! moment */ "./node_modules/moment/moment.js");
/* harmony import */ var moment__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(moment__WEBPACK_IMPORTED_MODULE_1__);


const helpers = chart_js__WEBPACK_IMPORTED_MODULE_0___default.a.helpers;
const isArray = helpers.isArray;
var TimelineConfig = {
  position: 'bottom',
  tooltips: {
    mode: 'nearest'
  },
  adapters: {},
  time: {
    parser: false,
    // false == a pattern string from http://momentjs.com/docs/#/parsing/string-format/ or a custom callback that converts its argument to a moment
    format: false,
    // DEPRECATED false == date objects, moment object, callback or a pattern string from http://momentjs.com/docs/#/parsing/string-format/
    unit: false,
    // false == automatic or override with week, month, year, etc.
    round: false,
    // none, or override with week, month, year, etc.
    displayFormat: false,
    // DEPRECATED
    isoWeekday: false,
    // override week start day - see http://momentjs.com/docs/#/get-set/iso-weekday/
    minUnit: 'millisecond',
    distribution: 'linear',
    bounds: 'data',
    // defaults to unit's corresponding unitFormat below or override using pattern string from http://momentjs.com/docs/#/displaying/format/
    displayFormats: {
      millisecond: 'h:mm:ss.SSS a',
      // 11:20:01.123 AM,
      second: 'h:mm:ss a',
      // 11:20:01 AM
      minute: 'h:mm a',
      // 11:20 AM
      hour: 'hA',
      // 5PM
      day: 'MMM D',
      // Sep 4
      week: 'll',
      // Week 46, or maybe "[W]WW - YYYY" ?
      month: 'MMM YYYY',
      // Sept 2015
      quarter: '[Q]Q - YYYY',
      // Q3
      year: 'YYYY' // 2015

    }
  },
  ticks: {
    autoSkip: false
  }
};
/**
 * Convert the given value to a moment object using the given time options.
 * @see http://momentjs.com/docs/#/parsing/
 */

function momentify(value, options) {
  var parser = options.parser;
  var format = options.parser || options.format;

  if (typeof parser === 'function') {
    return parser(value);
  }

  if (typeof value === 'string' && typeof format === 'string') {
    return moment__WEBPACK_IMPORTED_MODULE_1___default()(value, format);
  }

  if (!(value instanceof moment__WEBPACK_IMPORTED_MODULE_1___default.a)) {
    value = moment__WEBPACK_IMPORTED_MODULE_1___default()(value);
  }

  if (value.isValid()) {
    return value;
  } // Labels are in an incompatible moment format and no `parser` has been provided.
  // The user might still use the deprecated `format` option to convert his inputs.


  if (typeof format === 'function') {
    return format(value);
  }

  return value;
}

function parse(input, scale) {
  if (helpers.isNullOrUndef(input)) {
    return null;
  }

  var options = scale.options.time;
  var value = momentify(scale.getRightValue(input), options);

  if (!value.isValid()) {
    return null;
  }

  if (options.round) {
    value.startOf(options.round);
  }

  return value.valueOf();
}

function arrayUnique(items) {
  var hash = {};
  var out = [];
  var i, ilen, item;

  for (i = 0, ilen = items.length; i < ilen; ++i) {
    item = items[i];

    if (!hash[item]) {
      hash[item] = true;
      out.push(item);
    }
  }

  return out;
}

var MIN_INTEGER = Number.MIN_SAFE_INTEGER || -9007199254740991;
var MAX_INTEGER = Number.MAX_SAFE_INTEGER || 9007199254740991;
var TimelineScale = chart_js__WEBPACK_IMPORTED_MODULE_0___default.a.scaleService.getScaleConstructor('time').extend({
  determineDataLimits: function () {
    var me = this;
    var chart = me.chart;
    var timeOpts = me.options.time;
    var min = MAX_INTEGER;
    var max = MIN_INTEGER;
    var timestamps = [];
    var timestampobj = {};
    var datasets = [];
    var i, j, ilen, jlen, data, timestamp0, timestamp1; // Convert data to timestamps

    for (i = 0, ilen = (chart.data.datasets || []).length; i < ilen; ++i) {
      if (chart.isDatasetVisible(i)) {
        data = chart.data.datasets[i].data;
        datasets[i] = [];

        for (j = 0, jlen = data.length; j < jlen; ++j) {
          timestamp0 = parse(data[j][0], me);
          timestamp1 = parse(data[j][1], me);

          if (timestamp0 > timestamp1) {
            [timestamp0, timestamp1] = [timestamp1, timestamp0];
          }

          if (min > timestamp0 && timestamp0) {
            min = timestamp0;
          }

          if (max < timestamp1 && timestamp1) {
            max = timestamp1;
          }

          datasets[i][j] = [timestamp0, timestamp1, data[j][2]];

          if (timestampobj.hasOwnProperty(timestamp0)) {
            timestampobj[timestamp0] = true;
            timestamps.push(timestamp0);
          }

          if (timestampobj.hasOwnProperty(timestamp1)) {
            timestampobj[timestamp1] = true;
            timestamps.push(timestamp1);
          }
        }
      } else {
        datasets[i] = [];
      }
    }

    if (timestamps.size) {
      timestamps.sort(function (a, b) {
        return a - b;
      });
    }

    min = parse(timeOpts.min, me) || min;
    max = parse(timeOpts.max, me) || max; // In case there is no valid min/max, var's use today limits

    min = min === MAX_INTEGER ? +moment__WEBPACK_IMPORTED_MODULE_1___default()().startOf('day') : min;
    max = max === MIN_INTEGER ? +moment__WEBPACK_IMPORTED_MODULE_1___default()().endOf('day') + 1 : max; // Make sure that max is strictly higher than min (required by the lookup table)

    me.min = Math.min(min, max);
    me.max = Math.max(min + 1, max); // PRIVATE

    me._horizontal = me.isHorizontal();
    me._table = [];
    me._timestamps = {
      data: timestamps,
      datasets: datasets,
      labels: []
    };
  }
});
chart_js__WEBPACK_IMPORTED_MODULE_0___default.a.scaleService.registerScaleType('timeline', TimelineScale, TimelineConfig);
chart_js__WEBPACK_IMPORTED_MODULE_0___default.a.controllers.timeline = chart_js__WEBPACK_IMPORTED_MODULE_0___default.a.controllers.bar.extend({
  getBarBounds: function (bar) {
    var vm = bar._view;
    var x1, x2, y1, y2;
    x1 = vm.x;
    x2 = vm.x + vm.width;
    y1 = vm.y;
    y2 = vm.y + vm.height;
    return {
      left: x1,
      top: y1,
      right: x2,
      bottom: y2
    };
  },
  update: function (reset) {
    var me = this;
    var meta = me.getMeta();
    var chartOpts = me.chart.options;

    if (chartOpts.textPadding || chartOpts.minBarWidth || chartOpts.showText || chartOpts.colorFunction) {
      var elemOpts = me.chart.options.elements;
      elemOpts.textPadding = chartOpts.textPadding || elemOpts.textPadding;
      elemOpts.minBarWidth = chartOpts.minBarWidth || elemOpts.minBarWidth;
      elemOpts.colorFunction = chartOpts.colorFunction || elemOpts.colorFunction;
      elemOpts.minBarWidth = chartOpts.minBarWidth || elemOpts.minBarWidth;

      if (chart_js__WEBPACK_IMPORTED_MODULE_0___default.a._tl_depwarn !== true) {
        console.log('Timeline Chart: Configuration deprecated. Please check document on Github.');
        chart_js__WEBPACK_IMPORTED_MODULE_0___default.a._tl_depwarn = true;
      }
    }

    helpers.each(meta.data, function (rectangle, index) {
      me.updateElement(rectangle, index, reset);
    }, me);
  },
  updateElement: function (rectangle, index, reset) {
    var me = this;
    var meta = me.getMeta();
    var xScale = me.getScaleForId(meta.xAxisID);
    var yScale = me.getScaleForId(meta.yAxisID);
    var dataset = me.getDataset();
    var data = dataset.data[index];
    var custom = rectangle.custom || {};
    var datasetIndex = me.index;
    var opts = me.chart.options;
    var elemOpts = opts.elements || {};
    var rectangleElementOptions = elemOpts.rectangle;
    var textPad = elemOpts.textPadding;
    var minBarWidth = elemOpts.minBarWidth;
    rectangle._xScale = xScale;
    rectangle._yScale = yScale;
    rectangle._datasetIndex = me.index;
    rectangle._index = index;
    var text = data[2];
    var ruler = me.getRuler(index);
    var x = xScale.getPixelForValue(data[0]);
    var end = xScale.getPixelForValue(data[1]);
    var y = yScale.getPixelForValue(data, datasetIndex, datasetIndex);
    var width = end - x;
    var height = me.calculateBarHeight(ruler);
    var color = elemOpts.colorFunction(text, data, dataset, index);
    var showText = elemOpts.showText;
    var font = elemOpts.font;

    if (!font) {
      font = '12px bold Arial';
    } // This one has in account the size of the tick and the height of the bar, so we just
    // divide both of them by two and subtract the height part and add the tick part
    // to the real position of the element y. The purpose here is to place the bar
    // in the middle of the tick.


    var boxY = y - height / 2;
    rectangle._model = {
      x: reset ? x - width : x,
      // Top left of rectangle
      y: boxY,
      // Top left of rectangle
      width: Math.max(width, minBarWidth),
      height: height,
      base: x + width,
      backgroundColor: color.rgbaString(),
      borderSkipped: custom.borderSkipped ? custom.borderSkipped : rectangleElementOptions.borderSkipped,
      borderColor: custom.borderColor ? custom.borderColor : helpers.getValueAtIndexOrDefault(dataset.borderColor, index, rectangleElementOptions.borderColor),
      borderWidth: custom.borderWidth ? custom.borderWidth : helpers.getValueAtIndexOrDefault(dataset.borderWidth, index, rectangleElementOptions.borderWidth),
      // Tooltip
      label: me.chart.data.labels[index],
      datasetLabel: dataset.label,
      text: text,
      textColor: color.luminosity() > 0.5 ? '#000000' : '#ffffff'
    };

    rectangle.draw = function () {
      var ctx = this._chart.ctx;
      var vm = this._view;
      var oldAlpha = ctx.globalAlpha;
      var oldOperation = ctx.globalCompositeOperation; // Draw new rectangle with Alpha-Mix.

      ctx.fillStyle = vm.backgroundColor;
      ctx.lineWidth = vm.borderWidth;
      ctx.globalCompositeOperation = 'destination-over';
      ctx.fillRect(vm.x, vm.y, vm.width, vm.height);
      ctx.globalAlpha = 0.5;
      ctx.globalCompositeOperation = 'source-over';
      ctx.fillRect(vm.x, vm.y, vm.width, vm.height);
      ctx.globalAlpha = oldAlpha;
      ctx.globalCompositeOperation = oldOperation;

      if (showText) {
        ctx.beginPath();
        var textRect = ctx.measureText(vm.text);

        if (textRect.width > 0 && textRect.width + textPad + 2 < vm.width) {
          ctx.font = font;
          ctx.fillStyle = vm.textColor;
          ctx.lineWidth = 0;
          ctx.strokeStyle = vm.textColor;
          ctx.textBaseline = 'middle';
          ctx.fillText(vm.text, vm.x + textPad, vm.y + vm.height / 2);
        }

        ctx.fill();
      }
    };

    rectangle.inXRange = function (mouseX) {
      var bounds = me.getBarBounds(this);
      return mouseX >= bounds.left && mouseX <= bounds.right;
    };

    rectangle.tooltipPosition = function () {
      var vm = this.getCenterPoint();
      return {
        x: vm.x,
        y: vm.y
      };
    };

    rectangle.getCenterPoint = function () {
      var vm = this._view;
      var x, y;
      x = vm.x + vm.width / 2;
      y = vm.y + vm.height / 2;
      return {
        x: x,
        y: y
      };
    };

    rectangle.inRange = function (mouseX, mouseY) {
      var inRange = false;

      if (this._view) {
        var bounds = me.getBarBounds(this);
        inRange = mouseX >= bounds.left && mouseX <= bounds.right && mouseY >= bounds.top && mouseY <= bounds.bottom;
      }

      return inRange;
    };

    rectangle.pivot();
  },
  getBarCount: function () {
    var me = this;
    var barCount = 0;
    helpers.each(me.chart.data.datasets, function (dataset, datasetIndex) {
      var meta = me.chart.getDatasetMeta(datasetIndex);

      if (meta.bar && me.chart.isDatasetVisible(datasetIndex)) {
        ++barCount;
      }
    }, me);
    return barCount;
  },
  // draw
  draw: function (ease) {
    var easingDecimal = ease || 1;
    var i, len;
    var metaData = this.getMeta().data;

    for (i = 0, len = metaData.length; i < len; i++) {
      metaData[i].transition(easingDecimal).draw();
    }
  },
  // From controller.bar
  calculateBarHeight: function (ruler) {
    var me = this;
    var yScale = me.getScaleForId(me.getMeta().yAxisID);

    if (yScale.options.barThickness) {
      return yScale.options.barThickness;
    }

    return yScale.options.stacked ? ruler.categoryHeight : ruler.barHeight;
  },
  removeHoverStyle: function (e) {// TODO
  },
  setHoverStyle: function (e) {// TODO: Implement this
  }
});
chart_js__WEBPACK_IMPORTED_MODULE_0___default.a.defaults.timeline = {
  elements: {
    colorFunction: function () {
      return Color('black');
    },
    showText: true,
    textPadding: 4,
    minBarWidth: 1
  },
  layout: {
    padding: {
      left: 0,
      right: 0,
      top: 0,
      bottom: 0
    }
  },
  legend: {
    display: false
  },
  scales: {
    xAxes: [{
      type: 'timeline',
      position: 'bottom',
      distribution: 'linear',
      categoryPercentage: 0.8,
      barPercentage: 0.9,
      gridLines: {
        display: true,
        // offsetGridLines: true,
        drawBorder: true,
        drawTicks: true
      },
      ticks: {
        maxRotation: 0
      },
      unit: 'day'
    }],
    yAxes: [{
      type: 'category',
      position: 'left',
      barThickness: 20,
      categoryPercentage: 0.8,
      barPercentage: 0.9,
      offset: true,
      gridLines: {
        display: true,
        offsetGridLines: true,
        drawBorder: true,
        drawTicks: true
      }
    }]
  },
  tooltips: {
    callbacks: {
      title: function (tooltipItems, data) {
        var d = data.labels[tooltipItems[0].datasetIndex];
        return d;
      },
      label: function (tooltipItem, data) {
        var d = data.datasets[tooltipItem.datasetIndex].data[tooltipItem.index];
        return [d[2], moment__WEBPACK_IMPORTED_MODULE_1___default()(d[0]).format('L LTS'), moment__WEBPACK_IMPORTED_MODULE_1___default()(d[1]).format('L LTS')];
      }
    }
  }
};

/***/ })

}]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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