(self["webpackJsonp"] = self["webpackJsonp"] || []).push([["vendors~legacy-support"],{

/***/ "./node_modules/@polymer/polymer/lib/elements/array-selector.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@polymer/polymer/lib/elements/array-selector.js ***!
  \**********************************************************************/
/*! exports provided: ArraySelectorMixin, ArraySelector */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ArraySelectorMixin", function() { return ArraySelectorMixin; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ArraySelector", function() { return ArraySelector; });
/* harmony import */ var _polymer_element_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../polymer-element.js */ "./node_modules/@polymer/polymer/polymer-element.js");
/* harmony import */ var _utils_mixin_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/mixin.js */ "./node_modules/@polymer/polymer/lib/utils/mixin.js");
/* harmony import */ var _utils_array_splice_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/array-splice.js */ "./node_modules/@polymer/polymer/lib/utils/array-splice.js");
/* harmony import */ var _mixins_element_mixin_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../mixins/element-mixin.js */ "./node_modules/@polymer/polymer/lib/mixins/element-mixin.js");
/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/




/**
 * Element mixin for recording dynamic associations between item paths in a
 * master `items` array and a `selected` array such that path changes to the
 * master array (at the host) element or elsewhere via data-binding) are
 * correctly propagated to items in the selected array and vice-versa.
 *
 * The `items` property accepts an array of user data, and via the
 * `select(item)` and `deselect(item)` API, updates the `selected` property
 * which may be bound to other parts of the application, and any changes to
 * sub-fields of `selected` item(s) will be kept in sync with items in the
 * `items` array.  When `multi` is false, `selected` is a property
 * representing the last selected item.  When `multi` is true, `selected`
 * is an array of multiply selected items.
 *
 * @polymer
 * @mixinFunction
 * @appliesMixin ElementMixin
 * @summary Element mixin for recording dynamic associations between item paths in a
 * master `items` array and a `selected` array
 */

let ArraySelectorMixin = Object(_utils_mixin_js__WEBPACK_IMPORTED_MODULE_1__["dedupingMixin"])(superClass => {
  /**
   * @constructor
   * @extends {superClass}
   * @implements {Polymer_ElementMixin}
   * @private
   */
  let elementBase = Object(_mixins_element_mixin_js__WEBPACK_IMPORTED_MODULE_3__["ElementMixin"])(superClass);
  /**
   * @polymer
   * @mixinClass
   * @implements {Polymer_ArraySelectorMixin}
   * @unrestricted
   */

  class ArraySelectorMixin extends elementBase {
    static get properties() {
      return {
        /**
         * An array containing items from which selection will be made.
         */
        items: {
          type: Array
        },

        /**
         * When `true`, multiple items may be selected at once (in this case,
         * `selected` is an array of currently selected items).  When `false`,
         * only one item may be selected at a time.
         */
        multi: {
          type: Boolean,
          value: false
        },

        /**
         * When `multi` is true, this is an array that contains any selected.
         * When `multi` is false, this is the currently selected item, or `null`
         * if no item is selected.
         * @type {?(Object|Array<!Object>)}
         */
        selected: {
          type: Object,
          notify: true
        },

        /**
         * When `multi` is false, this is the currently selected item, or `null`
         * if no item is selected.
         * @type {?Object}
         */
        selectedItem: {
          type: Object,
          notify: true
        },

        /**
         * When `true`, calling `select` on an item that is already selected
         * will deselect the item.
         */
        toggle: {
          type: Boolean,
          value: false
        }
      };
    }

    static get observers() {
      return ['__updateSelection(multi, items.*)'];
    }

    constructor() {
      super();
      this.__lastItems = null;
      this.__lastMulti = null;
      this.__selectedMap = null;
    }

    __updateSelection(multi, itemsInfo) {
      let path = itemsInfo.path;

      if (path == 'items') {
        // Case 1 - items array changed, so diff against previous array and
        // deselect any removed items and adjust selected indices
        let newItems = itemsInfo.base || [];
        let lastItems = this.__lastItems;
        let lastMulti = this.__lastMulti;

        if (multi !== lastMulti) {
          this.clearSelection();
        }

        if (lastItems) {
          let splices = Object(_utils_array_splice_js__WEBPACK_IMPORTED_MODULE_2__["calculateSplices"])(newItems, lastItems);

          this.__applySplices(splices);
        }

        this.__lastItems = newItems;
        this.__lastMulti = multi;
      } else if (itemsInfo.path == 'items.splices') {
        // Case 2 - got specific splice information describing the array mutation:
        // deselect any removed items and adjust selected indices
        this.__applySplices(itemsInfo.value.indexSplices);
      } else {
        // Case 3 - an array element was changed, so deselect the previous
        // item for that index if it was previously selected
        let part = path.slice('items.'.length);
        let idx = parseInt(part, 10);

        if (part.indexOf('.') < 0 && part == idx) {
          this.__deselectChangedIdx(idx);
        }
      }
    }

    __applySplices(splices) {
      let selected = this.__selectedMap; // Adjust selected indices and mark removals

      for (let i = 0; i < splices.length; i++) {
        let s = splices[i];
        selected.forEach((idx, item) => {
          if (idx < s.index) {// no change
          } else if (idx >= s.index + s.removed.length) {
            // adjust index
            selected.set(item, idx + s.addedCount - s.removed.length);
          } else {
            // remove index
            selected.set(item, -1);
          }
        });

        for (let j = 0; j < s.addedCount; j++) {
          let idx = s.index + j;

          if (selected.has(this.items[idx])) {
            selected.set(this.items[idx], idx);
          }
        }
      } // Update linked paths


      this.__updateLinks(); // Remove selected items that were removed from the items array


      let sidx = 0;
      selected.forEach((idx, item) => {
        if (idx < 0) {
          if (this.multi) {
            this.splice('selected', sidx, 1);
          } else {
            this.selected = this.selectedItem = null;
          }

          selected.delete(item);
        } else {
          sidx++;
        }
      });
    }

    __updateLinks() {
      this.__dataLinkedPaths = {};

      if (this.multi) {
        let sidx = 0;

        this.__selectedMap.forEach(idx => {
          if (idx >= 0) {
            this.linkPaths('items.' + idx, 'selected.' + sidx++);
          }
        });
      } else {
        this.__selectedMap.forEach(idx => {
          this.linkPaths('selected', 'items.' + idx);
          this.linkPaths('selectedItem', 'items.' + idx);
        });
      }
    }
    /**
     * Clears the selection state.
     * @return {void}
     */


    clearSelection() {
      // Unbind previous selection
      this.__dataLinkedPaths = {}; // The selected map stores 3 pieces of information:
      // key: items array object
      // value: items array index
      // order: selected array index

      this.__selectedMap = new Map(); // Initialize selection

      this.selected = this.multi ? [] : null;
      this.selectedItem = null;
    }
    /**
     * Returns whether the item is currently selected.
     *
     * @param {*} item Item from `items` array to test
     * @return {boolean} Whether the item is selected
     */


    isSelected(item) {
      return this.__selectedMap.has(item);
    }
    /**
     * Returns whether the item is currently selected.
     *
     * @param {number} idx Index from `items` array to test
     * @return {boolean} Whether the item is selected
     */


    isIndexSelected(idx) {
      return this.isSelected(this.items[idx]);
    }

    __deselectChangedIdx(idx) {
      let sidx = this.__selectedIndexForItemIndex(idx);

      if (sidx >= 0) {
        let i = 0;

        this.__selectedMap.forEach((idx, item) => {
          if (sidx == i++) {
            this.deselect(item);
          }
        });
      }
    }

    __selectedIndexForItemIndex(idx) {
      let selected = this.__dataLinkedPaths['items.' + idx];

      if (selected) {
        return parseInt(selected.slice('selected.'.length), 10);
      }
    }
    /**
     * Deselects the given item if it is already selected.
     *
     * @param {*} item Item from `items` array to deselect
     * @return {void}
     */


    deselect(item) {
      let idx = this.__selectedMap.get(item);

      if (idx >= 0) {
        this.__selectedMap.delete(item);

        let sidx;

        if (this.multi) {
          sidx = this.__selectedIndexForItemIndex(idx);
        }

        this.__updateLinks();

        if (this.multi) {
          this.splice('selected', sidx, 1);
        } else {
          this.selected = this.selectedItem = null;
        }
      }
    }
    /**
     * Deselects the given index if it is already selected.
     *
     * @param {number} idx Index from `items` array to deselect
     * @return {void}
     */


    deselectIndex(idx) {
      this.deselect(this.items[idx]);
    }
    /**
     * Selects the given item.  When `toggle` is true, this will automatically
     * deselect the item if already selected.
     *
     * @param {*} item Item from `items` array to select
     * @return {void}
     */


    select(item) {
      this.selectIndex(this.items.indexOf(item));
    }
    /**
     * Selects the given index.  When `toggle` is true, this will automatically
     * deselect the item if already selected.
     *
     * @param {number} idx Index from `items` array to select
     * @return {void}
     */


    selectIndex(idx) {
      let item = this.items[idx];

      if (!this.isSelected(item)) {
        if (!this.multi) {
          this.__selectedMap.clear();
        }

        this.__selectedMap.set(item, idx);

        this.__updateLinks();

        if (this.multi) {
          this.push('selected', item);
        } else {
          this.selected = this.selectedItem = item;
        }
      } else if (this.toggle) {
        this.deselectIndex(idx);
      }
    }

  }

  return ArraySelectorMixin;
}); // export mixin


/**
 * @constructor
 * @extends {PolymerElement}
 * @implements {Polymer_ArraySelectorMixin}
 * @private
 */

let baseArraySelector = ArraySelectorMixin(_polymer_element_js__WEBPACK_IMPORTED_MODULE_0__["PolymerElement"]);
/**
 * Element implementing the `ArraySelector` mixin, which records
 * dynamic associations between item paths in a master `items` array and a
 * `selected` array such that path changes to the master array (at the host)
 * element or elsewhere via data-binding) are correctly propagated to items
 * in the selected array and vice-versa.
 *
 * The `items` property accepts an array of user data, and via the
 * `select(item)` and `deselect(item)` API, updates the `selected` property
 * which may be bound to other parts of the application, and any changes to
 * sub-fields of `selected` item(s) will be kept in sync with items in the
 * `items` array.  When `multi` is false, `selected` is a property
 * representing the last selected item.  When `multi` is true, `selected`
 * is an array of multiply selected items.
 *
 * Example:
 *
 * ```js
 * import {PolymerElement} from '@polymer/polymer';
 * import '@polymer/polymer/lib/elements/array-selector.js';
 *
 * class EmployeeList extends PolymerElement {
 *   static get _template() {
 *     return html`
 *         <div> Employee list: </div>
 *         <dom-repeat id="employeeList" items="{{employees}}">
 *           <template>
 *             <div>First name: <span>{{item.first}}</span></div>
 *               <div>Last name: <span>{{item.last}}</span></div>
 *               <button on-click="toggleSelection">Select</button>
 *           </template>
 *         </dom-repeat>
 *
 *         <array-selector id="selector"
 *                         items="{{employees}}"
 *                         selected="{{selected}}"
 *                         multi toggle></array-selector>
 *
 *         <div> Selected employees: </div>
 *         <dom-repeat items="{{selected}}">
 *           <template>
 *             <div>First name: <span>{{item.first}}</span></div>
 *             <div>Last name: <span>{{item.last}}</span></div>
 *           </template>
 *         </dom-repeat>`;
 *   }
 *   static get is() { return 'employee-list'; }
 *   static get properties() {
 *     return {
 *       employees: {
 *         value() {
 *           return [
 *             {first: 'Bob', last: 'Smith'},
 *             {first: 'Sally', last: 'Johnson'},
 *             ...
 *           ];
 *         }
 *       }
 *     };
 *   }
 *   toggleSelection(e) {
 *     const item = this.$.employeeList.itemForElement(e.target);
 *     this.$.selector.select(item);
 *   }
 * }
 * ```
 *
 * @polymer
 * @customElement
 * @extends {baseArraySelector}
 * @appliesMixin ArraySelectorMixin
 * @summary Custom element that links paths between an input `items` array and
 *   an output `selected` item or array based on calls to its selection API.
 */

class ArraySelector extends baseArraySelector {
  // Not needed to find template; can be removed once the analyzer
  // can find the tag name from customElements.define call
  static get is() {
    return 'array-selector';
  }

}

customElements.define(ArraySelector.is, ArraySelector);


/***/ }),

/***/ "./node_modules/@polymer/polymer/lib/elements/custom-style.js":
/*!********************************************************************!*\
  !*** ./node_modules/@polymer/polymer/lib/elements/custom-style.js ***!
  \********************************************************************/
/*! exports provided: CustomStyle */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CustomStyle", function() { return CustomStyle; });
/* harmony import */ var _webcomponents_shadycss_entrypoints_custom_style_interface_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @webcomponents/shadycss/entrypoints/custom-style-interface.js */ "./node_modules/@webcomponents/shadycss/entrypoints/custom-style-interface.js");
/* harmony import */ var _utils_style_gather_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/style-gather.js */ "./node_modules/@polymer/polymer/lib/utils/style-gather.js");
/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/


const attr = 'include';
const CustomStyleInterface = window.ShadyCSS.CustomStyleInterface;
/**
 * Custom element for defining styles in the main document that can take
 * advantage of [shady DOM](https://github.com/webcomponents/shadycss) shims
 * for style encapsulation, custom properties, and custom mixins.
 *
 * - Document styles defined in a `<custom-style>` are shimmed to ensure they
 *   do not leak into local DOM when running on browsers without native
 *   Shadow DOM.
 * - Custom properties can be defined in a `<custom-style>`. Use the `html` selector
 *   to define custom properties that apply to all custom elements.
 * - Custom mixins can be defined in a `<custom-style>`, if you import the optional
 *   [apply shim](https://github.com/webcomponents/shadycss#about-applyshim)
 *   (`shadycss/apply-shim.html`).
 *
 * To use:
 *
 * - Import `custom-style.html`.
 * - Place a `<custom-style>` element in the main document, wrapping an inline `<style>` tag that
 *   contains the CSS rules you want to shim.
 *
 * For example:
 *
 * ```html
 * <!-- import apply shim--only required if using mixins -->
 * <link rel="import" href="bower_components/shadycss/apply-shim.html">
 * <!-- import custom-style element -->
 * <link rel="import" href="bower_components/polymer/lib/elements/custom-style.html">
 *
 * <custom-style>
 *   <style>
 *     html {
 *       --custom-color: blue;
 *       --custom-mixin: {
 *         font-weight: bold;
 *         color: red;
 *       };
 *     }
 *   </style>
 * </custom-style>
 * ```
 *
 * @customElement
 * @extends HTMLElement
 * @summary Custom element for defining styles in the main document that can
 *   take advantage of Polymer's style scoping and custom properties shims.
 */

class CustomStyle extends HTMLElement {
  constructor() {
    super();
    this._style = null;
    CustomStyleInterface.addCustomStyle(this);
  }
  /**
   * Returns the light-DOM `<style>` child this element wraps.  Upon first
   * call any style modules referenced via the `include` attribute will be
   * concatenated to this element's `<style>`.
   *
   * @export
   * @return {HTMLStyleElement} This element's light-DOM `<style>`
   */


  getStyle() {
    if (this._style) {
      return this._style;
    }

    const style =
    /** @type {HTMLStyleElement} */
    this.querySelector('style');

    if (!style) {
      return null;
    }

    this._style = style;
    const include = style.getAttribute(attr);

    if (include) {
      style.removeAttribute(attr);
      style.textContent = Object(_utils_style_gather_js__WEBPACK_IMPORTED_MODULE_1__["cssFromModules"])(include) + style.textContent;
    }
    /*
    HTML Imports styling the main document are deprecated in Chrome
    https://crbug.com/523952
     If this element is not in the main document, then it must be in an HTML Import document.
    In that case, move the custom style to the main document.
     The ordering of `<custom-style>` should stay the same as when loaded by HTML Imports, but there may be odd
    cases of ordering w.r.t the main document styles.
    */


    if (this.ownerDocument !== window.document) {
      window.document.head.appendChild(this);
    }

    return this._style;
  }

}
window.customElements.define('custom-style', CustomStyle);

/***/ }),

/***/ "./node_modules/@polymer/polymer/lib/elements/dom-bind.js":
/*!****************************************************************!*\
  !*** ./node_modules/@polymer/polymer/lib/elements/dom-bind.js ***!
  \****************************************************************/
/*! exports provided: DomBind */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DomBind", function() { return DomBind; });
/* harmony import */ var _utils_boot_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/boot.js */ "./node_modules/@polymer/polymer/lib/utils/boot.js");
/* harmony import */ var _mixins_property_effects_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../mixins/property-effects.js */ "./node_modules/@polymer/polymer/lib/mixins/property-effects.js");
/* harmony import */ var _mixins_mutable_data_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../mixins/mutable-data.js */ "./node_modules/@polymer/polymer/lib/mixins/mutable-data.js");
/* harmony import */ var _mixins_gesture_event_listeners_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../mixins/gesture-event-listeners.js */ "./node_modules/@polymer/polymer/lib/mixins/gesture-event-listeners.js");
/* harmony import */ var _utils_settings_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/settings.js */ "./node_modules/@polymer/polymer/lib/utils/settings.js");
/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/





/**
 * @constructor
 * @extends {HTMLElement}
 * @implements {Polymer_PropertyEffects}
 * @implements {Polymer_OptionalMutableData}
 * @implements {Polymer_GestureEventListeners}
 * @private
 */

const domBindBase = Object(_mixins_gesture_event_listeners_js__WEBPACK_IMPORTED_MODULE_3__["GestureEventListeners"])(Object(_mixins_mutable_data_js__WEBPACK_IMPORTED_MODULE_2__["OptionalMutableData"])(Object(_mixins_property_effects_js__WEBPACK_IMPORTED_MODULE_1__["PropertyEffects"])(HTMLElement)));
/**
 * Custom element to allow using Polymer's template features (data binding,
 * declarative event listeners, etc.) in the main document without defining
 * a new custom element.
 *
 * `<template>` tags utilizing bindings may be wrapped with the `<dom-bind>`
 * element, which will immediately stamp the wrapped template into the main
 * document and bind elements to the `dom-bind` element itself as the
 * binding scope.
 *
 * @polymer
 * @customElement
 * @appliesMixin PropertyEffects
 * @appliesMixin OptionalMutableData
 * @appliesMixin GestureEventListeners
 * @extends {domBindBase}
 * @summary Custom element to allow using Polymer's template features (data
 *   binding, declarative event listeners, etc.) in the main document.
 */

class DomBind extends domBindBase {
  static get observedAttributes() {
    return ['mutable-data'];
  }

  constructor() {
    super();

    if (_utils_settings_js__WEBPACK_IMPORTED_MODULE_4__["strictTemplatePolicy"]) {
      throw new Error(`strictTemplatePolicy: dom-bind not allowed`);
    }

    this.root = null;
    this.$ = null;
    this.__children = null;
  }
  /**
   * @override
   * @return {void}
   */


  attributeChangedCallback() {
    // assumes only one observed attribute
    this.mutableData = true;
  }
  /**
   * @override
   * @return {void}
   */


  connectedCallback() {
    this.style.display = 'none';
    this.render();
  }
  /**
   * @override
   * @return {void}
   */


  disconnectedCallback() {
    this.__removeChildren();
  }

  __insertChildren() {
    this.parentNode.insertBefore(this.root, this);
  }

  __removeChildren() {
    if (this.__children) {
      for (let i = 0; i < this.__children.length; i++) {
        this.root.appendChild(this.__children[i]);
      }
    }
  }
  /**
   * Forces the element to render its content. This is typically only
   * necessary to call if HTMLImports with the async attribute are used.
   * @return {void}
   */


  render() {
    let template;

    if (!this.__children) {
      template =
      /** @type {HTMLTemplateElement} */
      template || this.querySelector('template');

      if (!template) {
        // Wait until childList changes and template should be there by then
        let observer = new MutationObserver(() => {
          template =
          /** @type {HTMLTemplateElement} */
          this.querySelector('template');

          if (template) {
            observer.disconnect();
            this.render();
          } else {
            throw new Error('dom-bind requires a <template> child');
          }
        });
        observer.observe(this, {
          childList: true
        });
        return;
      }

      this.root = this._stampTemplate(
      /** @type {!HTMLTemplateElement} */
      template);
      this.$ = this.root.$;
      this.__children = [];

      for (let n = this.root.firstChild; n; n = n.nextSibling) {
        this.__children[this.__children.length] = n;
      }

      this._enableProperties();
    }

    this.__insertChildren();

    this.dispatchEvent(new CustomEvent('dom-change', {
      bubbles: true,
      composed: true
    }));
  }

}
customElements.define('dom-bind', DomBind);

/***/ }),

/***/ "./node_modules/@polymer/polymer/lib/elements/dom-if.js":
/*!**************************************************************!*\
  !*** ./node_modules/@polymer/polymer/lib/elements/dom-if.js ***!
  \**************************************************************/
/*! exports provided: DomIf */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DomIf", function() { return DomIf; });
/* harmony import */ var _polymer_element_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../polymer-element.js */ "./node_modules/@polymer/polymer/polymer-element.js");
/* harmony import */ var _utils_templatize_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/templatize.js */ "./node_modules/@polymer/polymer/lib/utils/templatize.js");
/* harmony import */ var _utils_debounce_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/debounce.js */ "./node_modules/@polymer/polymer/lib/utils/debounce.js");
/* harmony import */ var _utils_flush_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/flush.js */ "./node_modules/@polymer/polymer/lib/utils/flush.js");
/* harmony import */ var _utils_async_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/async.js */ "./node_modules/@polymer/polymer/lib/utils/async.js");
/* harmony import */ var _utils_path_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../utils/path.js */ "./node_modules/@polymer/polymer/lib/utils/path.js");
/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/






/**
 * The `<dom-if>` element will stamp a light-dom `<template>` child when
 * the `if` property becomes truthy, and the template can use Polymer
 * data-binding and declarative event features when used in the context of
 * a Polymer element's template.
 *
 * When `if` becomes falsy, the stamped content is hidden but not
 * removed from dom. When `if` subsequently becomes truthy again, the content
 * is simply re-shown. This approach is used due to its favorable performance
 * characteristics: the expense of creating template content is paid only
 * once and lazily.
 *
 * Set the `restamp` property to true to force the stamped content to be
 * created / destroyed when the `if` condition changes.
 *
 * @customElement
 * @polymer
 * @extends PolymerElement
 * @summary Custom element that conditionally stamps and hides or removes
 *   template content based on a boolean flag.
 */

class DomIf extends _polymer_element_js__WEBPACK_IMPORTED_MODULE_0__["PolymerElement"] {
  // Not needed to find template; can be removed once the analyzer
  // can find the tag name from customElements.define call
  static get is() {
    return 'dom-if';
  }

  static get template() {
    return null;
  }

  static get properties() {
    return {
      /**
       * Fired whenever DOM is added or removed/hidden by this template (by
       * default, rendering occurs lazily).  To force immediate rendering, call
       * `render`.
       *
       * @event dom-change
       */

      /**
       * A boolean indicating whether this template should stamp.
       */
      if: {
        type: Boolean,
        observer: '__debounceRender'
      },

      /**
       * When true, elements will be removed from DOM and discarded when `if`
       * becomes false and re-created and added back to the DOM when `if`
       * becomes true.  By default, stamped elements will be hidden but left
       * in the DOM when `if` becomes false, which is generally results
       * in better performance.
       */
      restamp: {
        type: Boolean,
        observer: '__debounceRender'
      }
    };
  }

  constructor() {
    super();
    this.__renderDebouncer = null;
    this.__invalidProps = null;
    this.__instance = null;
    this._lastIf = false;
    this.__ctor = null;
    this.__hideTemplateChildren__ = false;
  }

  __debounceRender() {
    // Render is async for 2 reasons:
    // 1. To eliminate dom creation trashing if user code thrashes `if` in the
    //    same turn. This was more common in 1.x where a compound computed
    //    property could result in the result changing multiple times, but is
    //    mitigated to a large extent by batched property processing in 2.x.
    // 2. To avoid double object propagation when a bag including values bound
    //    to the `if` property as well as one or more hostProps could enqueue
    //    the <dom-if> to flush before the <template>'s host property
    //    forwarding. In that scenario creating an instance would result in
    //    the host props being set once, and then the enqueued changes on the
    //    template would set properties a second time, potentially causing an
    //    object to be set to an instance more than once.  Creating the
    //    instance async from flushing data ensures this doesn't happen. If
    //    we wanted a sync option in the future, simply having <dom-if> flush
    //    (or clear) its template's pending host properties before creating
    //    the instance would also avoid the problem.
    this.__renderDebouncer = _utils_debounce_js__WEBPACK_IMPORTED_MODULE_2__["Debouncer"].debounce(this.__renderDebouncer, _utils_async_js__WEBPACK_IMPORTED_MODULE_4__["microTask"], () => this.__render());
    Object(_utils_flush_js__WEBPACK_IMPORTED_MODULE_3__["enqueueDebouncer"])(this.__renderDebouncer);
  }
  /**
   * @override
   * @return {void}
   */


  disconnectedCallback() {
    super.disconnectedCallback();

    if (!this.parentNode || this.parentNode.nodeType == Node.DOCUMENT_FRAGMENT_NODE && !this.parentNode.host) {
      this.__teardownInstance();
    }
  }
  /**
   * @override
   * @return {void}
   */


  connectedCallback() {
    super.connectedCallback();
    this.style.display = 'none';

    if (this.if) {
      this.__debounceRender();
    }
  }
  /**
   * Forces the element to render its content. Normally rendering is
   * asynchronous to a provoking change. This is done for efficiency so
   * that multiple changes trigger only a single render. The render method
   * should be called if, for example, template rendering is required to
   * validate application state.
   * @return {void}
   */


  render() {
    Object(_utils_flush_js__WEBPACK_IMPORTED_MODULE_3__["flush"])();
  }

  __render() {
    if (this.if) {
      if (!this.__ensureInstance()) {
        // No template found yet
        return;
      }

      this._showHideChildren();
    } else if (this.restamp) {
      this.__teardownInstance();
    }

    if (!this.restamp && this.__instance) {
      this._showHideChildren();
    }

    if (this.if != this._lastIf) {
      this.dispatchEvent(new CustomEvent('dom-change', {
        bubbles: true,
        composed: true
      }));
      this._lastIf = this.if;
    }
  }

  __ensureInstance() {
    let parentNode = this.parentNode; // Guard against element being detached while render was queued

    if (parentNode) {
      if (!this.__ctor) {
        let template =
        /** @type {HTMLTemplateElement} */
        this.querySelector('template');

        if (!template) {
          // Wait until childList changes and template should be there by then
          let observer = new MutationObserver(() => {
            if (this.querySelector('template')) {
              observer.disconnect();

              this.__render();
            } else {
              throw new Error('dom-if requires a <template> child');
            }
          });
          observer.observe(this, {
            childList: true
          });
          return false;
        }

        this.__ctor = Object(_utils_templatize_js__WEBPACK_IMPORTED_MODULE_1__["templatize"])(template, this, {
          // dom-if templatizer instances require `mutable: true`, as
          // `__syncHostProperties` relies on that behavior to sync objects
          mutableData: true,

          /**
           * @param {string} prop Property to forward
           * @param {*} value Value of property
           * @this {DomIf}
           */
          forwardHostProp: function (prop, value) {
            if (this.__instance) {
              if (this.if) {
                this.__instance.forwardHostProp(prop, value);
              } else {
                // If we have an instance but are squelching host property
                // forwarding due to if being false, note the invalidated
                // properties so `__syncHostProperties` can sync them the next
                // time `if` becomes true
                this.__invalidProps = this.__invalidProps || Object.create(null);
                this.__invalidProps[Object(_utils_path_js__WEBPACK_IMPORTED_MODULE_5__["root"])(prop)] = true;
              }
            }
          }
        });
      }

      if (!this.__instance) {
        this.__instance = new this.__ctor();
        parentNode.insertBefore(this.__instance.root, this);
      } else {
        this.__syncHostProperties();

        let c$ = this.__instance.children;

        if (c$ && c$.length) {
          // Detect case where dom-if was re-attached in new position
          let lastChild = this.previousSibling;

          if (lastChild !== c$[c$.length - 1]) {
            for (let i = 0, n; i < c$.length && (n = c$[i]); i++) {
              parentNode.insertBefore(n, this);
            }
          }
        }
      }
    }

    return true;
  }

  __syncHostProperties() {
    let props = this.__invalidProps;

    if (props) {
      for (let prop in props) {
        this.__instance._setPendingProperty(prop, this.__dataHost[prop]);
      }

      this.__invalidProps = null;

      this.__instance._flushProperties();
    }
  }

  __teardownInstance() {
    if (this.__instance) {
      let c$ = this.__instance.children;

      if (c$ && c$.length) {
        // use first child parent, for case when dom-if may have been detached
        let parent = c$[0].parentNode; // Instance children may be disconnected from parents when dom-if
        // detaches if a tree was innerHTML'ed

        if (parent) {
          for (let i = 0, n; i < c$.length && (n = c$[i]); i++) {
            parent.removeChild(n);
          }
        }
      }

      this.__instance = null;
      this.__invalidProps = null;
    }
  }
  /**
   * Shows or hides the template instance top level child elements. For
   * text nodes, `textContent` is removed while "hidden" and replaced when
   * "shown."
   * @return {void}
   * @protected
   * @suppress {visibility}
   */


  _showHideChildren() {
    let hidden = this.__hideTemplateChildren__ || !this.if;

    if (this.__instance) {
      this.__instance._showHideChildren(hidden);
    }
  }

}
customElements.define(DomIf.is, DomIf);

/***/ }),

/***/ "./node_modules/@polymer/polymer/lib/elements/dom-module.js":
/*!******************************************************************!*\
  !*** ./node_modules/@polymer/polymer/lib/elements/dom-module.js ***!
  \******************************************************************/
/*! exports provided: DomModule */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DomModule", function() { return DomModule; });
/* harmony import */ var _utils_boot_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/boot.js */ "./node_modules/@polymer/polymer/lib/utils/boot.js");
/* harmony import */ var _utils_resolve_url_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/resolve-url.js */ "./node_modules/@polymer/polymer/lib/utils/resolve-url.js");
/* harmony import */ var _utils_settings_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/settings.js */ "./node_modules/@polymer/polymer/lib/utils/settings.js");
/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/



let modules = {};
let lcModules = {};
/**
 * Sets a dom-module into the global registry by id.
 *
 * @param {string} id dom-module id
 * @param {DomModule} module dom-module instance
 * @return {void}
 */

function setModule(id, module) {
  // store id separate from lowercased id so that
  // in all cases mixedCase id will stored distinctly
  // and lowercase version is a fallback
  modules[id] = lcModules[id.toLowerCase()] = module;
}
/**
 * Retrieves a dom-module from the global registry by id.
 *
 * @param {string} id dom-module id
 * @return {DomModule!} dom-module instance
 */


function findModule(id) {
  return modules[id] || lcModules[id.toLowerCase()];
}

function styleOutsideTemplateCheck(inst) {
  if (inst.querySelector('style')) {
    console.warn('dom-module %s has style outside template', inst.id);
  }
}
/**
 * The `dom-module` element registers the dom it contains to the name given
 * by the module's id attribute. It provides a unified database of dom
 * accessible via its static `import` API.
 *
 * A key use case of `dom-module` is for providing custom element `<template>`s
 * via HTML imports that are parsed by the native HTML parser, that can be
 * relocated during a bundling pass and still looked up by `id`.
 *
 * Example:
 *
 *     <dom-module id="foo">
 *       <img src="stuff.png">
 *     </dom-module>
 *
 * Then in code in some other location that cannot access the dom-module above
 *
 *     let img = customElements.get('dom-module').import('foo', 'img');
 *
 * @customElement
 * @extends HTMLElement
 * @summary Custom element that provides a registry of relocatable DOM content
 *   by `id` that is agnostic to bundling.
 * @unrestricted
 */


class DomModule extends HTMLElement {
  static get observedAttributes() {
    return ['id'];
  }
  /**
   * Retrieves the element specified by the css `selector` in the module
   * registered by `id`. For example, this.import('foo', 'img');
   * @param {string} id The id of the dom-module in which to search.
   * @param {string=} selector The css selector by which to find the element.
   * @return {Element} Returns the element which matches `selector` in the
   * module registered at the specified `id`.
   *
   * @export
   * @nocollapse Referred to indirectly in style-gather.js
   */


  static import(id, selector) {
    if (id) {
      let m = findModule(id);

      if (m && selector) {
        return m.querySelector(selector);
      }

      return m;
    }

    return null;
  }
  /* eslint-disable no-unused-vars */

  /**
   * @param {string} name Name of attribute.
   * @param {?string} old Old value of attribute.
   * @param {?string} value Current value of attribute.
   * @param {?string} namespace Attribute namespace.
   * @return {void}
   * @override
   */


  attributeChangedCallback(name, old, value, namespace) {
    if (old !== value) {
      this.register();
    }
  }
  /* eslint-enable no-unused-args */

  /**
   * The absolute URL of the original location of this `dom-module`.
   *
   * This value will differ from this element's `ownerDocument` in the
   * following ways:
   * - Takes into account any `assetpath` attribute added during bundling
   *   to indicate the original location relative to the bundled location
   * - Uses the HTMLImports polyfill's `importForElement` API to ensure
   *   the path is relative to the import document's location since
   *   `ownerDocument` is not currently polyfilled
   */


  get assetpath() {
    // Don't override existing assetpath.
    if (!this.__assetpath) {
      // note: assetpath set via an attribute must be relative to this
      // element's location; accomodate polyfilled HTMLImports
      const owner = window.HTMLImports && HTMLImports.importForElement ? HTMLImports.importForElement(this) || document : this.ownerDocument;
      const url = Object(_utils_resolve_url_js__WEBPACK_IMPORTED_MODULE_1__["resolveUrl"])(this.getAttribute('assetpath') || '', owner.baseURI);
      this.__assetpath = Object(_utils_resolve_url_js__WEBPACK_IMPORTED_MODULE_1__["pathFromUrl"])(url);
    }

    return this.__assetpath;
  }
  /**
   * Registers the dom-module at a given id. This method should only be called
   * when a dom-module is imperatively created. For
   * example, `document.createElement('dom-module').register('foo')`.
   * @param {string=} id The id at which to register the dom-module.
   * @return {void}
   */


  register(id) {
    id = id || this.id;

    if (id) {
      // Under strictTemplatePolicy, reject and null out any re-registered
      // dom-module since it is ambiguous whether first-in or last-in is trusted
      if (_utils_settings_js__WEBPACK_IMPORTED_MODULE_2__["strictTemplatePolicy"] && findModule(id) !== undefined) {
        setModule(id, null);
        throw new Error(`strictTemplatePolicy: dom-module ${id} re-registered`);
      }

      this.id = id;
      setModule(id, this);
      styleOutsideTemplateCheck(this);
    }
  }

}
DomModule.prototype['modules'] = modules;
customElements.define('dom-module', DomModule);

/***/ }),

/***/ "./node_modules/@polymer/polymer/lib/elements/dom-repeat.js":
/*!******************************************************************!*\
  !*** ./node_modules/@polymer/polymer/lib/elements/dom-repeat.js ***!
  \******************************************************************/
/*! exports provided: DomRepeat */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DomRepeat", function() { return DomRepeat; });
/* harmony import */ var _polymer_element_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../polymer-element.js */ "./node_modules/@polymer/polymer/polymer-element.js");
/* harmony import */ var _utils_templatize_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/templatize.js */ "./node_modules/@polymer/polymer/lib/utils/templatize.js");
/* harmony import */ var _utils_debounce_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/debounce.js */ "./node_modules/@polymer/polymer/lib/utils/debounce.js");
/* harmony import */ var _utils_flush_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/flush.js */ "./node_modules/@polymer/polymer/lib/utils/flush.js");
/* harmony import */ var _mixins_mutable_data_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../mixins/mutable-data.js */ "./node_modules/@polymer/polymer/lib/mixins/mutable-data.js");
/* harmony import */ var _utils_path_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../utils/path.js */ "./node_modules/@polymer/polymer/lib/utils/path.js");
/* harmony import */ var _utils_async_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../utils/async.js */ "./node_modules/@polymer/polymer/lib/utils/async.js");
/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/

 // eslint-disable-line no-unused-vars






/**
 * @constructor
 * @implements {Polymer_OptionalMutableData}
 * @extends {PolymerElement}
 * @private
 */

const domRepeatBase = Object(_mixins_mutable_data_js__WEBPACK_IMPORTED_MODULE_4__["OptionalMutableData"])(_polymer_element_js__WEBPACK_IMPORTED_MODULE_0__["PolymerElement"]);
/**
 * The `<dom-repeat>` element will automatically stamp and binds one instance
 * of template content to each object in a user-provided array.
 * `dom-repeat` accepts an `items` property, and one instance of the template
 * is stamped for each item into the DOM at the location of the `dom-repeat`
 * element.  The `item` property will be set on each instance's binding
 * scope, thus templates should bind to sub-properties of `item`.
 *
 * Example:
 *
 * ```html
 * <dom-module id="employee-list">
 *
 *   <template>
 *
 *     <div> Employee list: </div>
 *     <dom-repeat items="{{employees}}">
 *       <template>
 *         <div>First name: <span>{{item.first}}</span></div>
 *         <div>Last name: <span>{{item.last}}</span></div>
 *       </template>
 *     </dom-repeat>
 *
 *   </template>
 *
 * </dom-module>
 * ```
 *
 * With the following custom element definition:
 *
 * ```js
 * class EmployeeList extends PolymerElement {
 *   static get is() { return 'employee-list'; }
 *   static get properties() {
 *     return {
 *       employees: {
 *         value() {
 *           return [
 *             {first: 'Bob', last: 'Smith'},
 *             {first: 'Sally', last: 'Johnson'},
 *             ...
 *           ];
 *         }
 *       }
 *     };
 *   }
 * }
 * ```
 *
 * Notifications for changes to items sub-properties will be forwarded to template
 * instances, which will update via the normal structured data notification system.
 *
 * Mutations to the `items` array itself should be made using the Array
 * mutation API's on the PropertyEffects mixin (`push`, `pop`, `splice`,
 * `shift`, `unshift`), and template instances will be kept in sync with the
 * data in the array.
 *
 * Events caught by event handlers within the `dom-repeat` template will be
 * decorated with a `model` property, which represents the binding scope for
 * each template instance.  The model should be used to manipulate data on the
 * instance, for example `event.model.set('item.checked', true);`.
 *
 * Alternatively, the model for a template instance for an element stamped by
 * a `dom-repeat` can be obtained using the `modelForElement` API on the
 * `dom-repeat` that stamped it, for example
 * `this.$.domRepeat.modelForElement(event.target).set('item.checked', true);`.
 * This may be useful for manipulating instance data of event targets obtained
 * by event handlers on parents of the `dom-repeat` (event delegation).
 *
 * A view-specific filter/sort may be applied to each `dom-repeat` by supplying a
 * `filter` and/or `sort` property.  This may be a string that names a function on
 * the host, or a function may be assigned to the property directly.  The functions
 * should implemented following the standard `Array` filter/sort API.
 *
 * In order to re-run the filter or sort functions based on changes to sub-fields
 * of `items`, the `observe` property may be set as a space-separated list of
 * `item` sub-fields that should cause a re-filter/sort when modified.  If
 * the filter or sort function depends on properties not contained in `items`,
 * the user should observe changes to those properties and call `render` to update
 * the view based on the dependency change.
 *
 * For example, for an `dom-repeat` with a filter of the following:
 *
 * ```js
 * isEngineer(item) {
 *   return item.type == 'engineer' || item.manager.type == 'engineer';
 * }
 * ```
 *
 * Then the `observe` property should be configured as follows:
 *
 * ```html
 * <dom-repeat items="{{employees}}" filter="isEngineer" observe="type manager.type">
 * ```
 *
 * @customElement
 * @polymer
 * @extends {domRepeatBase}
 * @appliesMixin OptionalMutableData
 * @summary Custom element for stamping instance of a template bound to
 *   items in an array.
 */

class DomRepeat extends domRepeatBase {
  // Not needed to find template; can be removed once the analyzer
  // can find the tag name from customElements.define call
  static get is() {
    return 'dom-repeat';
  }

  static get template() {
    return null;
  }

  static get properties() {
    /**
     * Fired whenever DOM is added or removed by this template (by
     * default, rendering occurs lazily).  To force immediate rendering, call
     * `render`.
     *
     * @event dom-change
     */
    return {
      /**
       * An array containing items determining how many instances of the template
       * to stamp and that that each template instance should bind to.
       */
      items: {
        type: Array
      },

      /**
       * The name of the variable to add to the binding scope for the array
       * element associated with a given template instance.
       */
      as: {
        type: String,
        value: 'item'
      },

      /**
       * The name of the variable to add to the binding scope with the index
       * of the instance in the sorted and filtered list of rendered items.
       * Note, for the index in the `this.items` array, use the value of the
       * `itemsIndexAs` property.
       */
      indexAs: {
        type: String,
        value: 'index'
      },

      /**
       * The name of the variable to add to the binding scope with the index
       * of the instance in the `this.items` array. Note, for the index of
       * this instance in the sorted and filtered list of rendered items,
       * use the value of the `indexAs` property.
       */
      itemsIndexAs: {
        type: String,
        value: 'itemsIndex'
      },

      /**
       * A function that should determine the sort order of the items.  This
       * property should either be provided as a string, indicating a method
       * name on the element's host, or else be an actual function.  The
       * function should match the sort function passed to `Array.sort`.
       * Using a sort function has no effect on the underlying `items` array.
       */
      sort: {
        type: Function,
        observer: '__sortChanged'
      },

      /**
       * A function that can be used to filter items out of the view.  This
       * property should either be provided as a string, indicating a method
       * name on the element's host, or else be an actual function.  The
       * function should match the sort function passed to `Array.filter`.
       * Using a filter function has no effect on the underlying `items` array.
       */
      filter: {
        type: Function,
        observer: '__filterChanged'
      },

      /**
       * When using a `filter` or `sort` function, the `observe` property
       * should be set to a space-separated list of the names of item
       * sub-fields that should trigger a re-sort or re-filter when changed.
       * These should generally be fields of `item` that the sort or filter
       * function depends on.
       */
      observe: {
        type: String,
        observer: '__observeChanged'
      },

      /**
       * When using a `filter` or `sort` function, the `delay` property
       * determines a debounce time in ms after a change to observed item
       * properties that must pass before the filter or sort is re-run.
       * This is useful in rate-limiting shuffling of the view when
       * item changes may be frequent.
       */
      delay: Number,

      /**
       * Count of currently rendered items after `filter` (if any) has been applied.
       * If "chunking mode" is enabled, `renderedItemCount` is updated each time a
       * set of template instances is rendered.
       *
       */
      renderedItemCount: {
        type: Number,
        notify: true,
        readOnly: true
      },

      /**
       * Defines an initial count of template instances to render after setting
       * the `items` array, before the next paint, and puts the `dom-repeat`
       * into "chunking mode".  The remaining items will be created and rendered
       * incrementally at each animation frame therof until all instances have
       * been rendered.
       */
      initialCount: {
        type: Number,
        observer: '__initializeChunking'
      },

      /**
       * When `initialCount` is used, this property defines a frame rate (in
       * fps) to target by throttling the number of instances rendered each
       * frame to not exceed the budget for the target frame rate.  The
       * framerate is effectively the number of `requestAnimationFrame`s that
       * it tries to allow to actually fire in a given second. It does this
       * by measuring the time between `rAF`s and continuously adjusting the
       * number of items created each `rAF` to maintain the target framerate.
       * Setting this to a higher number allows lower latency and higher
       * throughput for event handlers and other tasks, but results in a
       * longer time for the remaining items to complete rendering.
       */
      targetFramerate: {
        type: Number,
        value: 20
      },
      _targetFrameTime: {
        type: Number,
        computed: '__computeFrameTime(targetFramerate)'
      }
    };
  }

  static get observers() {
    return ['__itemsChanged(items.*)'];
  }

  constructor() {
    super();
    this.__instances = [];
    this.__limit = Infinity;
    this.__pool = [];
    this.__renderDebouncer = null;
    this.__itemsIdxToInstIdx = {};
    this.__chunkCount = null;
    this.__lastChunkTime = null;
    this.__sortFn = null;
    this.__filterFn = null;
    this.__observePaths = null;
    /** @type {?function(new:Polymer.TemplateInstanceBase, *)} */

    this.__ctor = null;
    this.__isDetached = true;
    this.template = null;
  }
  /**
   * @override
   * @return {void}
   */


  disconnectedCallback() {
    super.disconnectedCallback();
    this.__isDetached = true;

    for (let i = 0; i < this.__instances.length; i++) {
      this.__detachInstance(i);
    }
  }
  /**
   * @override
   * @return {void}
   */


  connectedCallback() {
    super.connectedCallback();
    this.style.display = 'none'; // only perform attachment if the element was previously detached.

    if (this.__isDetached) {
      this.__isDetached = false;
      let parent = this.parentNode;

      for (let i = 0; i < this.__instances.length; i++) {
        this.__attachInstance(i, parent);
      }
    }
  }

  __ensureTemplatized() {
    // Templatizing (generating the instance constructor) needs to wait
    // until ready, since won't have its template content handed back to
    // it until then
    if (!this.__ctor) {
      let template = this.template =
      /** @type {HTMLTemplateElement} */
      this.querySelector('template');

      if (!template) {
        // // Wait until childList changes and template should be there by then
        let observer = new MutationObserver(() => {
          if (this.querySelector('template')) {
            observer.disconnect();

            this.__render();
          } else {
            throw new Error('dom-repeat requires a <template> child');
          }
        });
        observer.observe(this, {
          childList: true
        });
        return false;
      } // Template instance props that should be excluded from forwarding


      let instanceProps = {};
      instanceProps[this.as] = true;
      instanceProps[this.indexAs] = true;
      instanceProps[this.itemsIndexAs] = true;
      this.__ctor = Object(_utils_templatize_js__WEBPACK_IMPORTED_MODULE_1__["templatize"])(template, this, {
        mutableData: this.mutableData,
        parentModel: true,
        instanceProps: instanceProps,

        /**
         * @this {DomRepeat}
         * @param {string} prop Property to set
         * @param {*} value Value to set property to
         */
        forwardHostProp: function (prop, value) {
          let i$ = this.__instances;

          for (let i = 0, inst; i < i$.length && (inst = i$[i]); i++) {
            inst.forwardHostProp(prop, value);
          }
        },

        /**
         * @this {DomRepeat}
         * @param {Object} inst Instance to notify
         * @param {string} prop Property to notify
         * @param {*} value Value to notify
         */
        notifyInstanceProp: function (inst, prop, value) {
          if (Object(_utils_path_js__WEBPACK_IMPORTED_MODULE_5__["matches"])(this.as, prop)) {
            let idx = inst[this.itemsIndexAs];

            if (prop == this.as) {
              this.items[idx] = value;
            }

            let path = Object(_utils_path_js__WEBPACK_IMPORTED_MODULE_5__["translate"])(this.as, 'items.' + idx, prop);
            this.notifyPath(path, value);
          }
        }
      });
    }

    return true;
  }

  __getMethodHost() {
    // Technically this should be the owner of the outermost template.
    // In shadow dom, this is always getRootNode().host, but we can
    // approximate this via cooperation with our dataHost always setting
    // `_methodHost` as long as there were bindings (or id's) on this
    // instance causing it to get a dataHost.
    return this.__dataHost._methodHost || this.__dataHost;
  }

  __functionFromPropertyValue(functionOrMethodName) {
    if (typeof functionOrMethodName === 'string') {
      let methodName = functionOrMethodName;

      let obj = this.__getMethodHost();

      return function () {
        return obj[methodName].apply(obj, arguments);
      };
    }

    return functionOrMethodName;
  }

  __sortChanged(sort) {
    this.__sortFn = this.__functionFromPropertyValue(sort);

    if (this.items) {
      this.__debounceRender(this.__render);
    }
  }

  __filterChanged(filter) {
    this.__filterFn = this.__functionFromPropertyValue(filter);

    if (this.items) {
      this.__debounceRender(this.__render);
    }
  }

  __computeFrameTime(rate) {
    return Math.ceil(1000 / rate);
  }

  __initializeChunking() {
    if (this.initialCount) {
      this.__limit = this.initialCount;
      this.__chunkCount = this.initialCount;
      this.__lastChunkTime = performance.now();
    }
  }

  __tryRenderChunk() {
    // Debounced so that multiple calls through `_render` between animation
    // frames only queue one new rAF (e.g. array mutation & chunked render)
    if (this.items && this.__limit < this.items.length) {
      this.__debounceRender(this.__requestRenderChunk);
    }
  }

  __requestRenderChunk() {
    requestAnimationFrame(() => this.__renderChunk());
  }

  __renderChunk() {
    // Simple auto chunkSize throttling algorithm based on feedback loop:
    // measure actual time between frames and scale chunk count by ratio
    // of target/actual frame time
    let currChunkTime = performance.now();
    let ratio = this._targetFrameTime / (currChunkTime - this.__lastChunkTime);
    this.__chunkCount = Math.round(this.__chunkCount * ratio) || 1;
    this.__limit += this.__chunkCount;
    this.__lastChunkTime = currChunkTime;

    this.__debounceRender(this.__render);
  }

  __observeChanged() {
    this.__observePaths = this.observe && this.observe.replace('.*', '.').split(' ');
  }

  __itemsChanged(change) {
    if (this.items && !Array.isArray(this.items)) {
      console.warn('dom-repeat expected array for `items`, found', this.items);
    } // If path was to an item (e.g. 'items.3' or 'items.3.foo'), forward the
    // path to that instance synchronously (returns false for non-item paths)


    if (!this.__handleItemPath(change.path, change.value)) {
      // Otherwise, the array was reset ('items') or spliced ('items.splices'),
      // so queue a full refresh
      this.__initializeChunking();

      this.__debounceRender(this.__render);
    }
  }

  __handleObservedPaths(path) {
    // Handle cases where path changes should cause a re-sort/filter
    if (this.__sortFn || this.__filterFn) {
      if (!path) {
        // Always re-render if the item itself changed
        this.__debounceRender(this.__render, this.delay);
      } else if (this.__observePaths) {
        // Otherwise, re-render if the path changed matches an observed path
        let paths = this.__observePaths;

        for (let i = 0; i < paths.length; i++) {
          if (path.indexOf(paths[i]) === 0) {
            this.__debounceRender(this.__render, this.delay);
          }
        }
      }
    }
  }
  /**
   * @param {function(this:DomRepeat)} fn Function to debounce.
   * @param {number=} delay Delay in ms to debounce by.
   */


  __debounceRender(fn, delay = 0) {
    this.__renderDebouncer = _utils_debounce_js__WEBPACK_IMPORTED_MODULE_2__["Debouncer"].debounce(this.__renderDebouncer, delay > 0 ? _utils_async_js__WEBPACK_IMPORTED_MODULE_6__["timeOut"].after(delay) : _utils_async_js__WEBPACK_IMPORTED_MODULE_6__["microTask"], fn.bind(this));
    Object(_utils_flush_js__WEBPACK_IMPORTED_MODULE_3__["enqueueDebouncer"])(this.__renderDebouncer);
  }
  /**
   * Forces the element to render its content. Normally rendering is
   * asynchronous to a provoking change. This is done for efficiency so
   * that multiple changes trigger only a single render. The render method
   * should be called if, for example, template rendering is required to
   * validate application state.
   * @return {void}
   */


  render() {
    // Queue this repeater, then flush all in order
    this.__debounceRender(this.__render);

    Object(_utils_flush_js__WEBPACK_IMPORTED_MODULE_3__["flush"])();
  }

  __render() {
    if (!this.__ensureTemplatized()) {
      // No template found yet
      return;
    }

    this.__applyFullRefresh(); // Reset the pool
    // TODO(kschaaf): Reuse pool across turns and nested templates
    // Now that objects/arrays are re-evaluated when set, we can safely
    // reuse pooled instances across turns, however we still need to decide
    // semantics regarding how long to hold, how many to hold, etc.


    this.__pool.length = 0; // Set rendered item count

    this._setRenderedItemCount(this.__instances.length); // Notify users


    this.dispatchEvent(new CustomEvent('dom-change', {
      bubbles: true,
      composed: true
    })); // Check to see if we need to render more items

    this.__tryRenderChunk();
  }

  __applyFullRefresh() {
    let items = this.items || [];
    let isntIdxToItemsIdx = new Array(items.length);

    for (let i = 0; i < items.length; i++) {
      isntIdxToItemsIdx[i] = i;
    } // Apply user filter


    if (this.__filterFn) {
      isntIdxToItemsIdx = isntIdxToItemsIdx.filter((i, idx, array) => this.__filterFn(items[i], idx, array));
    } // Apply user sort


    if (this.__sortFn) {
      isntIdxToItemsIdx.sort((a, b) => this.__sortFn(items[a], items[b]));
    } // items->inst map kept for item path forwarding


    const itemsIdxToInstIdx = this.__itemsIdxToInstIdx = {};
    let instIdx = 0; // Generate instances and assign items

    const limit = Math.min(isntIdxToItemsIdx.length, this.__limit);

    for (; instIdx < limit; instIdx++) {
      let inst = this.__instances[instIdx];
      let itemIdx = isntIdxToItemsIdx[instIdx];
      let item = items[itemIdx];
      itemsIdxToInstIdx[itemIdx] = instIdx;

      if (inst) {
        inst._setPendingProperty(this.as, item);

        inst._setPendingProperty(this.indexAs, instIdx);

        inst._setPendingProperty(this.itemsIndexAs, itemIdx);

        inst._flushProperties();
      } else {
        this.__insertInstance(item, instIdx, itemIdx);
      }
    } // Remove any extra instances from previous state


    for (let i = this.__instances.length - 1; i >= instIdx; i--) {
      this.__detachAndRemoveInstance(i);
    }
  }

  __detachInstance(idx) {
    let inst = this.__instances[idx];

    for (let i = 0; i < inst.children.length; i++) {
      let el = inst.children[i];
      inst.root.appendChild(el);
    }

    return inst;
  }

  __attachInstance(idx, parent) {
    let inst = this.__instances[idx];
    parent.insertBefore(inst.root, this);
  }

  __detachAndRemoveInstance(idx) {
    let inst = this.__detachInstance(idx);

    if (inst) {
      this.__pool.push(inst);
    }

    this.__instances.splice(idx, 1);
  }

  __stampInstance(item, instIdx, itemIdx) {
    let model = {};
    model[this.as] = item;
    model[this.indexAs] = instIdx;
    model[this.itemsIndexAs] = itemIdx;
    return new this.__ctor(model);
  }

  __insertInstance(item, instIdx, itemIdx) {
    let inst = this.__pool.pop();

    if (inst) {
      // TODO(kschaaf): If the pool is shared across turns, hostProps
      // need to be re-set to reused instances in addition to item
      inst._setPendingProperty(this.as, item);

      inst._setPendingProperty(this.indexAs, instIdx);

      inst._setPendingProperty(this.itemsIndexAs, itemIdx);

      inst._flushProperties();
    } else {
      inst = this.__stampInstance(item, instIdx, itemIdx);
    }

    let beforeRow = this.__instances[instIdx + 1];
    let beforeNode = beforeRow ? beforeRow.children[0] : this;
    this.parentNode.insertBefore(inst.root, beforeNode);
    this.__instances[instIdx] = inst;
    return inst;
  } // Implements extension point from Templatize mixin

  /**
   * Shows or hides the template instance top level child elements. For
   * text nodes, `textContent` is removed while "hidden" and replaced when
   * "shown."
   * @param {boolean} hidden Set to true to hide the children;
   * set to false to show them.
   * @return {void}
   * @protected
   */


  _showHideChildren(hidden) {
    for (let i = 0; i < this.__instances.length; i++) {
      this.__instances[i]._showHideChildren(hidden);
    }
  } // Called as a side effect of a host items.<key>.<path> path change,
  // responsible for notifying item.<path> changes to inst for key


  __handleItemPath(path, value) {
    let itemsPath = path.slice(6); // 'items.'.length == 6

    let dot = itemsPath.indexOf('.');
    let itemsIdx = dot < 0 ? itemsPath : itemsPath.substring(0, dot); // If path was index into array...

    if (itemsIdx == parseInt(itemsIdx, 10)) {
      let itemSubPath = dot < 0 ? '' : itemsPath.substring(dot + 1); // If the path is observed, it will trigger a full refresh

      this.__handleObservedPaths(itemSubPath); // Note, even if a rull refresh is triggered, always do the path
      // notification because unless mutableData is used for dom-repeat
      // and all elements in the instance subtree, a full refresh may
      // not trigger the proper update.


      let instIdx = this.__itemsIdxToInstIdx[itemsIdx];
      let inst = this.__instances[instIdx];

      if (inst) {
        let itemPath = this.as + (itemSubPath ? '.' + itemSubPath : ''); // This is effectively `notifyPath`, but avoids some of the overhead
        // of the public API

        inst._setPendingPropertyOrPath(itemPath, value, false, true);

        inst._flushProperties();
      }

      return true;
    }
  }
  /**
   * Returns the item associated with a given element stamped by
   * this `dom-repeat`.
   *
   * Note, to modify sub-properties of the item,
   * `modelForElement(el).set('item.<sub-prop>', value)`
   * should be used.
   *
   * @param {!HTMLElement} el Element for which to return the item.
   * @return {*} Item associated with the element.
   */


  itemForElement(el) {
    let instance = this.modelForElement(el);
    return instance && instance[this.as];
  }
  /**
   * Returns the inst index for a given element stamped by this `dom-repeat`.
   * If `sort` is provided, the index will reflect the sorted order (rather
   * than the original array order).
   *
   * @param {!HTMLElement} el Element for which to return the index.
   * @return {?number} Row index associated with the element (note this may
   *   not correspond to the array index if a user `sort` is applied).
   */


  indexForElement(el) {
    let instance = this.modelForElement(el);
    return instance && instance[this.indexAs];
  }
  /**
   * Returns the template "model" associated with a given element, which
   * serves as the binding scope for the template instance the element is
   * contained in. A template model
   * should be used to manipulate data associated with this template instance.
   *
   * Example:
   *
   *   let model = modelForElement(el);
   *   if (model.index < 10) {
   *     model.set('item.checked', true);
   *   }
   *
   * @param {!HTMLElement} el Element for which to return a template model.
   * @return {TemplateInstanceBase} Model representing the binding scope for
   *   the element.
   */


  modelForElement(el) {
    return Object(_utils_templatize_js__WEBPACK_IMPORTED_MODULE_1__["modelForElement"])(this.template, el);
  }

}
customElements.define(DomRepeat.is, DomRepeat);

/***/ }),

/***/ "./node_modules/@polymer/polymer/lib/legacy/class.js":
/*!***********************************************************!*\
  !*** ./node_modules/@polymer/polymer/lib/legacy/class.js ***!
  \***********************************************************/
/*! exports provided: mixinBehaviors, Class */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "mixinBehaviors", function() { return mixinBehaviors; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Class", function() { return Class; });
/* harmony import */ var _legacy_element_mixin_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./legacy-element-mixin.js */ "./node_modules/@polymer/polymer/lib/legacy/legacy-element-mixin.js");
/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/

let metaProps = {
  attached: true,
  detached: true,
  ready: true,
  created: true,
  beforeRegister: true,
  registered: true,
  attributeChanged: true,
  // meta objects
  behaviors: true
};
/**
 * Applies a "legacy" behavior or array of behaviors to the provided class.
 *
 * Note: this method will automatically also apply the `LegacyElementMixin`
 * to ensure that any legacy behaviors can rely on legacy Polymer API on
 * the underlying element.
 *
 * @function
 * @template T
 * @param {!Object|!Array<!Object>} behaviors Behavior object or array of behaviors.
 * @param {function(new:T)} klass Element class.
 * @return {?} Returns a new Element class extended by the
 * passed in `behaviors` and also by `LegacyElementMixin`.
 * @suppress {invalidCasts, checkTypes}
 */

function mixinBehaviors(behaviors, klass) {
  if (!behaviors) {
    klass =
    /** @type {HTMLElement} */
    klass; // eslint-disable-line no-self-assign

    return klass;
  } // NOTE: ensure the behavior is extending a class with
  // legacy element api. This is necessary since behaviors expect to be able
  // to access 1.x legacy api.


  klass = Object(_legacy_element_mixin_js__WEBPACK_IMPORTED_MODULE_0__["LegacyElementMixin"])(klass);

  if (!Array.isArray(behaviors)) {
    behaviors = [behaviors];
  }

  let superBehaviors = klass.prototype.behaviors; // get flattened, deduped list of behaviors *not* already on super class

  behaviors = flattenBehaviors(behaviors, null, superBehaviors); // mixin new behaviors

  klass = _mixinBehaviors(behaviors, klass);

  if (superBehaviors) {
    behaviors = superBehaviors.concat(behaviors);
  } // Set behaviors on prototype for BC...


  klass.prototype.behaviors = behaviors;
  return klass;
} // NOTE:
// 1.x
// Behaviors were mixed in *in reverse order* and de-duped on the fly.
// The rule was that behavior properties were copied onto the element
// prototype if and only if the property did not already exist.
// Given: Polymer{ behaviors: [A, B, C, A, B]}, property copy order was:
// (1), B, (2), A, (3) C. This means prototype properties win over
// B properties win over A win over C. This mirrors what would happen
// with inheritance if element extended B extended A extended C.
//
// Again given, Polymer{ behaviors: [A, B, C, A, B]}, the resulting
// `behaviors` array was [C, A, B].
// Behavior lifecycle methods were called in behavior array order
// followed by the element, e.g. (1) C.created, (2) A.created,
// (3) B.created, (4) element.created. There was no support for
// super, and "super-behavior" methods were callable only by name).
//
// 2.x
// Behaviors are made into proper mixins which live in the
// element's prototype chain. Behaviors are placed in the element prototype
// eldest to youngest and de-duped youngest to oldest:
// So, first [A, B, C, A, B] becomes [C, A, B] then,
// the element prototype becomes (oldest) (1) PolymerElement, (2) class(C),
// (3) class(A), (4) class(B), (5) class(Polymer({...})).
// Result:
// This means element properties win over B properties win over A win
// over C. (same as 1.x)
// If lifecycle is called (super then me), order is
// (1) C.created, (2) A.created, (3) B.created, (4) element.created
// (again same as 1.x)

function _mixinBehaviors(behaviors, klass) {
  for (let i = 0; i < behaviors.length; i++) {
    let b = behaviors[i];

    if (b) {
      klass = Array.isArray(b) ? _mixinBehaviors(b, klass) : GenerateClassFromInfo(b, klass);
    }
  }

  return klass;
}
/**
 * @param {Array} behaviors List of behaviors to flatten.
 * @param {Array=} list Target list to flatten behaviors into.
 * @param {Array=} exclude List of behaviors to exclude from the list.
 * @return {!Array} Returns the list of flattened behaviors.
 */


function flattenBehaviors(behaviors, list, exclude) {
  list = list || [];

  for (let i = behaviors.length - 1; i >= 0; i--) {
    let b = behaviors[i];

    if (b) {
      if (Array.isArray(b)) {
        flattenBehaviors(b, list);
      } else {
        // dedup
        if (list.indexOf(b) < 0 && (!exclude || exclude.indexOf(b) < 0)) {
          list.unshift(b);
        }
      }
    } else {
      console.warn('behavior is null, check for missing or 404 import');
    }
  }

  return list;
}
/**
 * @param {!PolymerInit} info Polymer info object
 * @param {function(new:HTMLElement)} Base base class to extend with info object
 * @return {function(new:HTMLElement)} Generated class
 * @suppress {checkTypes}
 * @private
 */


function GenerateClassFromInfo(info, Base) {
  /** @private */
  class PolymerGenerated extends Base {
    static get properties() {
      return info.properties;
    }

    static get observers() {
      return info.observers;
    }
    /**
     * @return {void}
     */


    created() {
      super.created();

      if (info.created) {
        info.created.call(this);
      }
    }
    /**
     * @return {void}
     */


    _registered() {
      super._registered();
      /* NOTE: `beforeRegister` is called here for bc, but the behavior
       is different than in 1.x. In 1.0, the method was called *after*
       mixing prototypes together but *before* processing of meta-objects.
       However, dynamic effects can still be set here and can be done either
       in `beforeRegister` or `registered`. It is no longer possible to set
       `is` in `beforeRegister` as you could in 1.x.
      */


      if (info.beforeRegister) {
        info.beforeRegister.call(Object.getPrototypeOf(this));
      }

      if (info.registered) {
        info.registered.call(Object.getPrototypeOf(this));
      }
    }
    /**
     * @return {void}
     */


    _applyListeners() {
      super._applyListeners();

      if (info.listeners) {
        for (let l in info.listeners) {
          this._addMethodEventListenerToNode(this, l, info.listeners[l]);
        }
      }
    } // note: exception to "super then me" rule;
    // do work before calling super so that super attributes
    // only apply if not already set.

    /**
     * @return {void}
     */


    _ensureAttributes() {
      if (info.hostAttributes) {
        for (let a in info.hostAttributes) {
          this._ensureAttribute(a, info.hostAttributes[a]);
        }
      }

      super._ensureAttributes();
    }
    /**
     * @return {void}
     */


    ready() {
      super.ready();

      if (info.ready) {
        info.ready.call(this);
      }
    }
    /**
     * @return {void}
     */


    attached() {
      super.attached();

      if (info.attached) {
        info.attached.call(this);
      }
    }
    /**
     * @return {void}
     */


    detached() {
      super.detached();

      if (info.detached) {
        info.detached.call(this);
      }
    }
    /**
     * Implements native Custom Elements `attributeChangedCallback` to
     * set an attribute value to a property via `_attributeToProperty`.
     *
     * @param {string} name Name of attribute that changed
     * @param {?string} old Old attribute value
     * @param {?string} value New attribute value
     * @return {void}
     */


    attributeChanged(name, old, value) {
      super.attributeChanged(name, old, value);

      if (info.attributeChanged) {
        info.attributeChanged.call(this, name, old, value);
      }
    }

  }

  PolymerGenerated.generatedFrom = info;

  for (let p in info) {
    // NOTE: cannot copy `metaProps` methods onto prototype at least because
    // `super.ready` must be called and is not included in the user fn.
    if (!(p in metaProps)) {
      let pd = Object.getOwnPropertyDescriptor(info, p);

      if (pd) {
        Object.defineProperty(PolymerGenerated.prototype, p, pd);
      }
    }
  }

  return PolymerGenerated;
}
/**
 * Generates a class that extends `LegacyElement` based on the
 * provided info object.  Metadata objects on the `info` object
 * (`properties`, `observers`, `listeners`, `behaviors`, `is`) are used
 * for Polymer's meta-programming systems, and any functions are copied
 * to the generated class.
 *
 * Valid "metadata" values are as follows:
 *
 * `is`: String providing the tag name to register the element under. In
 * addition, if a `dom-module` with the same id exists, the first template
 * in that `dom-module` will be stamped into the shadow root of this element,
 * with support for declarative event listeners (`on-...`), Polymer data
 * bindings (`[[...]]` and `{{...}}`), and id-based node finding into
 * `this.$`.
 *
 * `properties`: Object describing property-related metadata used by Polymer
 * features (key: property names, value: object containing property metadata).
 * Valid keys in per-property metadata include:
 * - `type` (String|Number|Object|Array|...): Used by
 *   `attributeChangedCallback` to determine how string-based attributes
 *   are deserialized to JavaScript property values.
 * - `notify` (boolean): Causes a change in the property to fire a
 *   non-bubbling event called `<property>-changed`. Elements that have
 *   enabled two-way binding to the property use this event to observe changes.
 * - `readOnly` (boolean): Creates a getter for the property, but no setter.
 *   To set a read-only property, use the private setter method
 *   `_setProperty(property, value)`.
 * - `observer` (string): Observer method name that will be called when
 *   the property changes. The arguments of the method are
 *   `(value, previousValue)`.
 * - `computed` (string): String describing method and dependent properties
 *   for computing the value of this property (e.g. `'computeFoo(bar, zot)'`).
 *   Computed properties are read-only by default and can only be changed
 *   via the return value of the computing method.
 *
 * `observers`: Array of strings describing multi-property observer methods
 *  and their dependent properties (e.g. `'observeABC(a, b, c)'`).
 *
 * `listeners`: Object describing event listeners to be added to each
 *  instance of this element (key: event name, value: method name).
 *
 * `behaviors`: Array of additional `info` objects containing metadata
 * and callbacks in the same format as the `info` object here which are
 * merged into this element.
 *
 * `hostAttributes`: Object listing attributes to be applied to the host
 *  once created (key: attribute name, value: attribute value).  Values
 *  are serialized based on the type of the value.  Host attributes should
 *  generally be limited to attributes such as `tabIndex` and `aria-...`.
 *  Attributes in `hostAttributes` are only applied if a user-supplied
 *  attribute is not already present (attributes in markup override
 *  `hostAttributes`).
 *
 * In addition, the following Polymer-specific callbacks may be provided:
 * - `registered`: called after first instance of this element,
 * - `created`: called during `constructor`
 * - `attached`: called during `connectedCallback`
 * - `detached`: called during `disconnectedCallback`
 * - `ready`: called before first `attached`, after all properties of
 *   this element have been propagated to its template and all observers
 *   have run
 *
 * @param {!PolymerInit} info Object containing Polymer metadata and functions
 *   to become class methods.
 * @template T
 * @param {function(T):T} mixin Optional mixin to apply to legacy base class
 *   before extending with Polymer metaprogramming.
 * @return {function(new:HTMLElement)} Generated class
 */


const Class = function (info, mixin) {
  if (!info) {
    console.warn(`Polymer's Class function requires \`info\` argument`);
  }

  const baseWithBehaviors = info.behaviors ? // note: mixinBehaviors ensures `LegacyElementMixin`.
  mixinBehaviors(info.behaviors, HTMLElement) : Object(_legacy_element_mixin_js__WEBPACK_IMPORTED_MODULE_0__["LegacyElementMixin"])(HTMLElement);
  const baseWithMixin = mixin ? mixin(baseWithBehaviors) : baseWithBehaviors;
  const klass = GenerateClassFromInfo(info, baseWithMixin); // decorate klass with registration info

  klass.is = info.is;
  return klass;
};

/***/ }),

/***/ "./node_modules/@polymer/polymer/lib/legacy/legacy-element-mixin.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@polymer/polymer/lib/legacy/legacy-element-mixin.js ***!
  \**************************************************************************/
/*! exports provided: LegacyElementMixin */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "LegacyElementMixin", function() { return LegacyElementMixin; });
/* harmony import */ var _webcomponents_shadycss_entrypoints_apply_shim_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @webcomponents/shadycss/entrypoints/apply-shim.js */ "./node_modules/@webcomponents/shadycss/entrypoints/apply-shim.js");
/* harmony import */ var _mixins_element_mixin_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../mixins/element-mixin.js */ "./node_modules/@polymer/polymer/lib/mixins/element-mixin.js");
/* harmony import */ var _mixins_gesture_event_listeners_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../mixins/gesture-event-listeners.js */ "./node_modules/@polymer/polymer/lib/mixins/gesture-event-listeners.js");
/* harmony import */ var _mixins_dir_mixin_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../mixins/dir-mixin.js */ "./node_modules/@polymer/polymer/lib/mixins/dir-mixin.js");
/* harmony import */ var _utils_mixin_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/mixin.js */ "./node_modules/@polymer/polymer/lib/utils/mixin.js");
/* harmony import */ var _utils_render_status_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../utils/render-status.js */ "./node_modules/@polymer/polymer/lib/utils/render-status.js");
/* harmony import */ var _utils_unresolved_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../utils/unresolved.js */ "./node_modules/@polymer/polymer/lib/utils/unresolved.js");
/* harmony import */ var _polymer_dom_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./polymer.dom.js */ "./node_modules/@polymer/polymer/lib/legacy/polymer.dom.js");
/* harmony import */ var _utils_gestures_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../utils/gestures.js */ "./node_modules/@polymer/polymer/lib/utils/gestures.js");
/* harmony import */ var _utils_debounce_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../utils/debounce.js */ "./node_modules/@polymer/polymer/lib/utils/debounce.js");
/* harmony import */ var _utils_async_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../utils/async.js */ "./node_modules/@polymer/polymer/lib/utils/async.js");
/* harmony import */ var _utils_path_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../utils/path.js */ "./node_modules/@polymer/polymer/lib/utils/path.js");
/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/












let styleInterface = window.ShadyCSS;
/**
 * Element class mixin that provides Polymer's "legacy" API intended to be
 * backward-compatible to the greatest extent possible with the API
 * found on the Polymer 1.x `Polymer.Base` prototype applied to all elements
 * defined using the `Polymer({...})` function.
 *
 * @mixinFunction
 * @polymer
 * @appliesMixin ElementMixin
 * @appliesMixin GestureEventListeners
 * @property isAttached {boolean} Set to `true` in this element's
 *   `connectedCallback` and `false` in `disconnectedCallback`
 * @summary Element class mixin that provides Polymer's "legacy" API
 */

const LegacyElementMixin = Object(_utils_mixin_js__WEBPACK_IMPORTED_MODULE_4__["dedupingMixin"])(base => {
  /**
   * @constructor
   * @extends {base}
   * @implements {Polymer_ElementMixin}
   * @implements {Polymer_GestureEventListeners}
   * @implements {Polymer_DirMixin}
   * @private
   */
  const legacyElementBase = Object(_mixins_dir_mixin_js__WEBPACK_IMPORTED_MODULE_3__["DirMixin"])(Object(_mixins_gesture_event_listeners_js__WEBPACK_IMPORTED_MODULE_2__["GestureEventListeners"])(Object(_mixins_element_mixin_js__WEBPACK_IMPORTED_MODULE_1__["ElementMixin"])(base)));
  /**
   * Map of simple names to touch action names
   * @dict
   */

  const DIRECTION_MAP = {
    'x': 'pan-x',
    'y': 'pan-y',
    'none': 'none',
    'all': 'auto'
  };
  /**
   * @polymer
   * @mixinClass
   * @extends {legacyElementBase}
   * @implements {Polymer_LegacyElementMixin}
   * @unrestricted
   */

  class LegacyElement extends legacyElementBase {
    constructor() {
      super();
      /** @type {boolean} */

      this.isAttached;
      /** @type {WeakMap<!Element, !Object<string, !Function>>} */

      this.__boundListeners;
      /** @type {Object<string, Function>} */

      this._debouncers; // Ensure listeners are applied immediately so that they are
      // added before declarative event listeners. This allows an element to
      // decorate itself via an event prior to any declarative listeners
      // seeing the event. Note, this ensures compatibility with 1.x ordering.

      this._applyListeners();
    }
    /**
     * Forwards `importMeta` from the prototype (i.e. from the info object
     * passed to `Polymer({...})`) to the static API.
     *
     * @return {!Object} The `import.meta` object set on the prototype
     * @suppress {missingProperties} `this` is always in the instance in
     *  closure for some reason even in a static method, rather than the class
     */


    static get importMeta() {
      return this.prototype.importMeta;
    }
    /**
     * Legacy callback called during the `constructor`, for overriding
     * by the user.
     * @return {void}
     */


    created() {}
    /**
     * Provides an implementation of `connectedCallback`
     * which adds Polymer legacy API's `attached` method.
     * @return {void}
     * @override
     */


    connectedCallback() {
      super.connectedCallback();
      this.isAttached = true;
      this.attached();
    }
    /**
     * Legacy callback called during `connectedCallback`, for overriding
     * by the user.
     * @return {void}
     */


    attached() {}
    /**
     * Provides an implementation of `disconnectedCallback`
     * which adds Polymer legacy API's `detached` method.
     * @return {void}
     * @override
     */


    disconnectedCallback() {
      super.disconnectedCallback();
      this.isAttached = false;
      this.detached();
    }
    /**
     * Legacy callback called during `disconnectedCallback`, for overriding
     * by the user.
     * @return {void}
     */


    detached() {}
    /**
     * Provides an override implementation of `attributeChangedCallback`
     * which adds the Polymer legacy API's `attributeChanged` method.
     * @param {string} name Name of attribute.
     * @param {?string} old Old value of attribute.
     * @param {?string} value Current value of attribute.
     * @param {?string} namespace Attribute namespace.
     * @return {void}
     * @override
     */


    attributeChangedCallback(name, old, value, namespace) {
      if (old !== value) {
        super.attributeChangedCallback(name, old, value, namespace);
        this.attributeChanged(name, old, value);
      }
    }
    /**
     * Legacy callback called during `attributeChangedChallback`, for overriding
     * by the user.
     * @param {string} name Name of attribute.
     * @param {?string} old Old value of attribute.
     * @param {?string} value Current value of attribute.
     * @return {void}
     */


    attributeChanged(name, old, value) {} // eslint-disable-line no-unused-vars

    /**
     * Overrides the default `Polymer.PropertyEffects` implementation to
     * add support for class initialization via the `_registered` callback.
     * This is called only when the first instance of the element is created.
     *
     * @return {void}
     * @override
     * @suppress {invalidCasts}
     */


    _initializeProperties() {
      let proto = Object.getPrototypeOf(this);

      if (!proto.hasOwnProperty('__hasRegisterFinished')) {
        proto.__hasRegisterFinished = true;

        this._registered();
      }

      super._initializeProperties();

      this.root =
      /** @type {HTMLElement} */
      this;
      this.created();
    }
    /**
     * Called automatically when an element is initializing.
     * Users may override this method to perform class registration time
     * work. The implementation should ensure the work is performed
     * only once for the class.
     * @protected
     * @return {void}
     */


    _registered() {}
    /**
     * Overrides the default `Polymer.PropertyEffects` implementation to
     * add support for installing `hostAttributes` and `listeners`.
     *
     * @return {void}
     * @override
     */


    ready() {
      this._ensureAttributes();

      super.ready();
    }
    /**
     * Ensures an element has required attributes. Called when the element
     * is being readied via `ready`. Users should override to set the
     * element's required attributes. The implementation should be sure
     * to check and not override existing attributes added by
     * the user of the element. Typically, setting attributes should be left
     * to the element user and not done here; reasonable exceptions include
     * setting aria roles and focusability.
     * @protected
     * @return {void}
     */


    _ensureAttributes() {}
    /**
     * Adds element event listeners. Called when the element
     * is being readied via `ready`. Users should override to
     * add any required element event listeners.
     * In performance critical elements, the work done here should be kept
     * to a minimum since it is done before the element is rendered. In
     * these elements, consider adding listeners asynchronously so as not to
     * block render.
     * @protected
     * @return {void}
     */


    _applyListeners() {}
    /**
     * Converts a typed JavaScript value to a string.
     *
     * Note this method is provided as backward-compatible legacy API
     * only.  It is not directly called by any Polymer features. To customize
     * how properties are serialized to attributes for attribute bindings and
     * `reflectToAttribute: true` properties as well as this method, override
     * the `_serializeValue` method provided by `Polymer.PropertyAccessors`.
     *
     * @param {*} value Value to deserialize
     * @return {string | undefined} Serialized value
     */


    serialize(value) {
      return this._serializeValue(value);
    }
    /**
     * Converts a string to a typed JavaScript value.
     *
     * Note this method is provided as backward-compatible legacy API
     * only.  It is not directly called by any Polymer features.  To customize
     * how attributes are deserialized to properties for in
     * `attributeChangedCallback`, override `_deserializeValue` method
     * provided by `Polymer.PropertyAccessors`.
     *
     * @param {string} value String to deserialize
     * @param {*} type Type to deserialize the string to
     * @return {*} Returns the deserialized value in the `type` given.
     */


    deserialize(value, type) {
      return this._deserializeValue(value, type);
    }
    /**
     * Serializes a property to its associated attribute.
     *
     * Note this method is provided as backward-compatible legacy API
     * only.  It is not directly called by any Polymer features.
     *
     * @param {string} property Property name to reflect.
     * @param {string=} attribute Attribute name to reflect.
     * @param {*=} value Property value to reflect.
     * @return {void}
     */


    reflectPropertyToAttribute(property, attribute, value) {
      this._propertyToAttribute(property, attribute, value);
    }
    /**
     * Sets a typed value to an HTML attribute on a node.
     *
     * Note this method is provided as backward-compatible legacy API
     * only.  It is not directly called by any Polymer features.
     *
     * @param {*} value Value to serialize.
     * @param {string} attribute Attribute name to serialize to.
     * @param {Element} node Element to set attribute to.
     * @return {void}
     */


    serializeValueToAttribute(value, attribute, node) {
      this._valueToNodeAttribute(
      /** @type {Element} */
      node || this, value, attribute);
    }
    /**
     * Copies own properties (including accessor descriptors) from a source
     * object to a target object.
     *
     * @param {Object} prototype Target object to copy properties to.
     * @param {Object} api Source object to copy properties from.
     * @return {Object} prototype object that was passed as first argument.
     */


    extend(prototype, api) {
      if (!(prototype && api)) {
        return prototype || api;
      }

      let n$ = Object.getOwnPropertyNames(api);

      for (let i = 0, n; i < n$.length && (n = n$[i]); i++) {
        let pd = Object.getOwnPropertyDescriptor(api, n);

        if (pd) {
          Object.defineProperty(prototype, n, pd);
        }
      }

      return prototype;
    }
    /**
     * Copies props from a source object to a target object.
     *
     * Note, this method uses a simple `for...in` strategy for enumerating
     * properties.  To ensure only `ownProperties` are copied from source
     * to target and that accessor implementations are copied, use `extend`.
     *
     * @param {!Object} target Target object to copy properties to.
     * @param {!Object} source Source object to copy properties from.
     * @return {!Object} Target object that was passed as first argument.
     */


    mixin(target, source) {
      for (let i in source) {
        target[i] = source[i];
      }

      return target;
    }
    /**
     * Sets the prototype of an object.
     *
     * Note this method is provided as backward-compatible legacy API
     * only.  It is not directly called by any Polymer features.
     * @param {Object} object The object on which to set the prototype.
     * @param {Object} prototype The prototype that will be set on the given
     * `object`.
     * @return {Object} Returns the given `object` with its prototype set
     * to the given `prototype` object.
     */


    chainObject(object, prototype) {
      if (object && prototype && object !== prototype) {
        object.__proto__ = prototype;
      }

      return object;
    }
    /* **** Begin Template **** */

    /**
     * Calls `importNode` on the `content` of the `template` specified and
     * returns a document fragment containing the imported content.
     *
     * @param {HTMLTemplateElement} template HTML template element to instance.
     * @return {!DocumentFragment} Document fragment containing the imported
     *   template content.
    */


    instanceTemplate(template) {
      let content = this.constructor._contentForTemplate(template);

      let dom =
      /** @type {!DocumentFragment} */
      document.importNode(content, true);
      return dom;
    }
    /* **** Begin Events **** */

    /**
     * Dispatches a custom event with an optional detail value.
     *
     * @param {string} type Name of event type.
     * @param {*=} detail Detail value containing event-specific
     *   payload.
     * @param {{ bubbles: (boolean|undefined), cancelable: (boolean|undefined), composed: (boolean|undefined) }=}
     *  options Object specifying options.  These may include:
     *  `bubbles` (boolean, defaults to `true`),
     *  `cancelable` (boolean, defaults to false), and
     *  `node` on which to fire the event (HTMLElement, defaults to `this`).
     * @return {!Event} The new event that was fired.
     */


    fire(type, detail, options) {
      options = options || {};
      detail = detail === null || detail === undefined ? {} : detail;
      let event = new Event(type, {
        bubbles: options.bubbles === undefined ? true : options.bubbles,
        cancelable: Boolean(options.cancelable),
        composed: options.composed === undefined ? true : options.composed
      });
      event.detail = detail;
      let node = options.node || this;
      node.dispatchEvent(event);
      return event;
    }
    /**
     * Convenience method to add an event listener on a given element,
     * late bound to a named method on this element.
     *
     * @param {?EventTarget} node Element to add event listener to.
     * @param {string} eventName Name of event to listen for.
     * @param {string} methodName Name of handler method on `this` to call.
     * @return {void}
     */


    listen(node, eventName, methodName) {
      node =
      /** @type {!EventTarget} */
      node || this;
      let hbl = this.__boundListeners || (this.__boundListeners = new WeakMap());
      let bl = hbl.get(node);

      if (!bl) {
        bl = {};
        hbl.set(node, bl);
      }

      let key = eventName + methodName;

      if (!bl[key]) {
        bl[key] = this._addMethodEventListenerToNode(node, eventName, methodName, this);
      }
    }
    /**
     * Convenience method to remove an event listener from a given element,
     * late bound to a named method on this element.
     *
     * @param {?EventTarget} node Element to remove event listener from.
     * @param {string} eventName Name of event to stop listening to.
     * @param {string} methodName Name of handler method on `this` to not call
     anymore.
     * @return {void}
     */


    unlisten(node, eventName, methodName) {
      node =
      /** @type {!EventTarget} */
      node || this;

      let bl = this.__boundListeners && this.__boundListeners.get(node);

      let key = eventName + methodName;
      let handler = bl && bl[key];

      if (handler) {
        this._removeEventListenerFromNode(node, eventName, handler);

        bl[key] = null;
      }
    }
    /**
     * Override scrolling behavior to all direction, one direction, or none.
     *
     * Valid scroll directions:
     *   - 'all': scroll in any direction
     *   - 'x': scroll only in the 'x' direction
     *   - 'y': scroll only in the 'y' direction
     *   - 'none': disable scrolling for this node
     *
     * @param {string=} direction Direction to allow scrolling
     * Defaults to `all`.
     * @param {Element=} node Element to apply scroll direction setting.
     * Defaults to `this`.
     * @return {void}
     */


    setScrollDirection(direction, node) {
      Object(_utils_gestures_js__WEBPACK_IMPORTED_MODULE_8__["setTouchAction"])(
      /** @type {Element} */
      node || this, DIRECTION_MAP[direction] || 'auto');
    }
    /* **** End Events **** */

    /**
     * Convenience method to run `querySelector` on this local DOM scope.
     *
     * This function calls `Polymer.dom(this.root).querySelector(slctr)`.
     *
     * @param {string} slctr Selector to run on this local DOM scope
     * @return {Element} Element found by the selector, or null if not found.
     */


    $$(slctr) {
      return this.root.querySelector(slctr);
    }
    /**
     * Return the element whose local dom within which this element
     * is contained. This is a shorthand for
     * `this.getRootNode().host`.
     * @this {Element}
     */


    get domHost() {
      let root = this.getRootNode();
      return root instanceof DocumentFragment ?
      /** @type {ShadowRoot} */
      root.host : root;
    }
    /**
     * Force this element to distribute its children to its local dom.
     * This should not be necessary as of Polymer 2.0.2 and is provided only
     * for backwards compatibility.
     * @return {void}
     */


    distributeContent() {
      if (window.ShadyDOM && this.shadowRoot) {
        ShadyDOM.flush();
      }
    }
    /**
     * Returns a list of nodes that are the effective childNodes. The effective
     * childNodes list is the same as the element's childNodes except that
     * any `<content>` elements are replaced with the list of nodes distributed
     * to the `<content>`, the result of its `getDistributedNodes` method.
     * @return {!Array<!Node>} List of effective child nodes.
     * @suppress {invalidCasts} LegacyElementMixin must be applied to an HTMLElement
     */


    getEffectiveChildNodes() {
      const thisEl =
      /** @type {Element} */
      this;
      const domApi =
      /** @type {DomApi} */
      Object(_polymer_dom_js__WEBPACK_IMPORTED_MODULE_7__["dom"])(thisEl);
      return domApi.getEffectiveChildNodes();
    }
    /**
     * Returns a list of nodes distributed within this element that match
     * `selector`. These can be dom children or elements distributed to
     * children that are insertion points.
     * @param {string} selector Selector to run.
     * @return {!Array<!Node>} List of distributed elements that match selector.
     * @suppress {invalidCasts} LegacyElementMixin must be applied to an HTMLElement
     */


    queryDistributedElements(selector) {
      const thisEl =
      /** @type {Element} */
      this;
      const domApi =
      /** @type {DomApi} */
      Object(_polymer_dom_js__WEBPACK_IMPORTED_MODULE_7__["dom"])(thisEl);
      return domApi.queryDistributedElements(selector);
    }
    /**
     * Returns a list of elements that are the effective children. The effective
     * children list is the same as the element's children except that
     * any `<content>` elements are replaced with the list of elements
     * distributed to the `<content>`.
     *
     * @return {!Array<!Node>} List of effective children.
     */


    getEffectiveChildren() {
      let list = this.getEffectiveChildNodes();
      return list.filter(function (
      /** @type {!Node} */
      n) {
        return n.nodeType === Node.ELEMENT_NODE;
      });
    }
    /**
     * Returns a string of text content that is the concatenation of the
     * text content's of the element's effective childNodes (the elements
     * returned by <a href="#getEffectiveChildNodes>getEffectiveChildNodes</a>.
     *
     * @return {string} List of effective children.
     */


    getEffectiveTextContent() {
      let cn = this.getEffectiveChildNodes();
      let tc = [];

      for (let i = 0, c; c = cn[i]; i++) {
        if (c.nodeType !== Node.COMMENT_NODE) {
          tc.push(c.textContent);
        }
      }

      return tc.join('');
    }
    /**
     * Returns the first effective childNode within this element that
     * match `selector`. These can be dom child nodes or elements distributed
     * to children that are insertion points.
     * @param {string} selector Selector to run.
     * @return {Node} First effective child node that matches selector.
     */


    queryEffectiveChildren(selector) {
      let e$ = this.queryDistributedElements(selector);
      return e$ && e$[0];
    }
    /**
     * Returns a list of effective childNodes within this element that
     * match `selector`. These can be dom child nodes or elements distributed
     * to children that are insertion points.
     * @param {string} selector Selector to run.
     * @return {!Array<!Node>} List of effective child nodes that match selector.
     */


    queryAllEffectiveChildren(selector) {
      return this.queryDistributedElements(selector);
    }
    /**
     * Returns a list of nodes distributed to this element's `<slot>`.
     *
     * If this element contains more than one `<slot>` in its local DOM,
     * an optional selector may be passed to choose the desired content.
     *
     * @param {string=} slctr CSS selector to choose the desired
     *   `<slot>`.  Defaults to `content`.
     * @return {!Array<!Node>} List of distributed nodes for the `<slot>`.
     */


    getContentChildNodes(slctr) {
      let content = this.root.querySelector(slctr || 'slot');
      return content ?
      /** @type {DomApi} */
      Object(_polymer_dom_js__WEBPACK_IMPORTED_MODULE_7__["dom"])(content).getDistributedNodes() : [];
    }
    /**
     * Returns a list of element children distributed to this element's
     * `<slot>`.
     *
     * If this element contains more than one `<slot>` in its
     * local DOM, an optional selector may be passed to choose the desired
     * content.  This method differs from `getContentChildNodes` in that only
     * elements are returned.
     *
     * @param {string=} slctr CSS selector to choose the desired
     *   `<content>`.  Defaults to `content`.
     * @return {!Array<!HTMLElement>} List of distributed nodes for the
     *   `<slot>`.
     * @suppress {invalidCasts}
     */


    getContentChildren(slctr) {
      let children =
      /** @type {!Array<!HTMLElement>} */
      this.getContentChildNodes(slctr).filter(function (n) {
        return n.nodeType === Node.ELEMENT_NODE;
      });
      return children;
    }
    /**
     * Checks whether an element is in this element's light DOM tree.
     *
     * @param {?Node} node The element to be checked.
     * @return {boolean} true if node is in this element's light DOM tree.
     * @suppress {invalidCasts} LegacyElementMixin must be applied to an HTMLElement
     */


    isLightDescendant(node) {
      const thisNode =
      /** @type {Node} */
      this;
      return thisNode !== node && thisNode.contains(node) && thisNode.getRootNode() === node.getRootNode();
    }
    /**
     * Checks whether an element is in this element's local DOM tree.
     *
     * @param {!Element} node The element to be checked.
     * @return {boolean} true if node is in this element's local DOM tree.
     */


    isLocalDescendant(node) {
      return this.root === node.getRootNode();
    }
    /**
     * No-op for backwards compatibility. This should now be handled by
     * ShadyCss library.
     * @param  {*} container Unused
     * @param  {*} shouldObserve Unused
     * @return {void}
     */


    scopeSubtree(container, shouldObserve) {} // eslint-disable-line no-unused-vars

    /**
     * Returns the computed style value for the given property.
     * @param {string} property The css property name.
     * @return {string} Returns the computed css property value for the given
     * `property`.
     * @suppress {invalidCasts} LegacyElementMixin must be applied to an HTMLElement
     */


    getComputedStyleValue(property) {
      return styleInterface.getComputedStyleValue(
      /** @type {!Element} */
      this, property);
    } // debounce

    /**
     * Call `debounce` to collapse multiple requests for a named task into
     * one invocation which is made after the wait time has elapsed with
     * no new request.  If no wait time is given, the callback will be called
     * at microtask timing (guaranteed before paint).
     *
     *     debouncedClickAction(e) {
     *       // will not call `processClick` more than once per 100ms
     *       this.debounce('click', function() {
     *        this.processClick();
     *       } 100);
     *     }
     *
     * @param {string} jobName String to identify the debounce job.
     * @param {function():void} callback Function that is called (with `this`
     *   context) when the wait time elapses.
     * @param {number} wait Optional wait time in milliseconds (ms) after the
     *   last signal that must elapse before invoking `callback`
     * @return {!Object} Returns a debouncer object on which exists the
     * following methods: `isActive()` returns true if the debouncer is
     * active; `cancel()` cancels the debouncer if it is active;
     * `flush()` immediately invokes the debounced callback if the debouncer
     * is active.
     */


    debounce(jobName, callback, wait) {
      this._debouncers = this._debouncers || {};
      return this._debouncers[jobName] = _utils_debounce_js__WEBPACK_IMPORTED_MODULE_9__["Debouncer"].debounce(this._debouncers[jobName], wait > 0 ? _utils_async_js__WEBPACK_IMPORTED_MODULE_10__["timeOut"].after(wait) : _utils_async_js__WEBPACK_IMPORTED_MODULE_10__["microTask"], callback.bind(this));
    }
    /**
     * Returns whether a named debouncer is active.
     *
     * @param {string} jobName The name of the debouncer started with `debounce`
     * @return {boolean} Whether the debouncer is active (has not yet fired).
     */


    isDebouncerActive(jobName) {
      this._debouncers = this._debouncers || {};
      let debouncer = this._debouncers[jobName];
      return !!(debouncer && debouncer.isActive());
    }
    /**
     * Immediately calls the debouncer `callback` and inactivates it.
     *
     * @param {string} jobName The name of the debouncer started with `debounce`
     * @return {void}
     */


    flushDebouncer(jobName) {
      this._debouncers = this._debouncers || {};
      let debouncer = this._debouncers[jobName];

      if (debouncer) {
        debouncer.flush();
      }
    }
    /**
     * Cancels an active debouncer.  The `callback` will not be called.
     *
     * @param {string} jobName The name of the debouncer started with `debounce`
     * @return {void}
     */


    cancelDebouncer(jobName) {
      this._debouncers = this._debouncers || {};
      let debouncer = this._debouncers[jobName];

      if (debouncer) {
        debouncer.cancel();
      }
    }
    /**
     * Runs a callback function asynchronously.
     *
     * By default (if no waitTime is specified), async callbacks are run at
     * microtask timing, which will occur before paint.
     *
     * @param {!Function} callback The callback function to run, bound to `this`.
     * @param {number=} waitTime Time to wait before calling the
     *   `callback`.  If unspecified or 0, the callback will be run at microtask
     *   timing (before paint).
     * @return {number} Handle that may be used to cancel the async job.
     */


    async(callback, waitTime) {
      return waitTime > 0 ? _utils_async_js__WEBPACK_IMPORTED_MODULE_10__["timeOut"].run(callback.bind(this), waitTime) : ~_utils_async_js__WEBPACK_IMPORTED_MODULE_10__["microTask"].run(callback.bind(this));
    }
    /**
     * Cancels an async operation started with `async`.
     *
     * @param {number} handle Handle returned from original `async` call to
     *   cancel.
     * @return {void}
     */


    cancelAsync(handle) {
      handle < 0 ? _utils_async_js__WEBPACK_IMPORTED_MODULE_10__["microTask"].cancel(~handle) : _utils_async_js__WEBPACK_IMPORTED_MODULE_10__["timeOut"].cancel(handle);
    } // other

    /**
     * Convenience method for creating an element and configuring it.
     *
     * @param {string} tag HTML element tag to create.
     * @param {Object=} props Object of properties to configure on the
     *    instance.
     * @return {!Element} Newly created and configured element.
     */


    create(tag, props) {
      let elt = document.createElement(tag);

      if (props) {
        if (elt.setProperties) {
          elt.setProperties(props);
        } else {
          for (let n in props) {
            elt[n] = props[n];
          }
        }
      }

      return elt;
    }
    /**
     * Polyfill for Element.prototype.matches, which is sometimes still
     * prefixed.
     *
     * @param {string} selector Selector to test.
     * @param {!Element=} node Element to test the selector against.
     * @return {boolean} Whether the element matches the selector.
     */


    elementMatches(selector, node) {
      return Object(_polymer_dom_js__WEBPACK_IMPORTED_MODULE_7__["matchesSelector"])(node || this, selector);
    }
    /**
     * Toggles an HTML attribute on or off.
     *
     * @param {string} name HTML attribute name
     * @param {boolean=} bool Boolean to force the attribute on or off.
     *    When unspecified, the state of the attribute will be reversed.
     * @return {boolean} true if the attribute now exists
     */


    toggleAttribute(name, bool) {
      let node =
      /** @type {Element} */
      this;

      if (arguments.length === 3) {
        node =
        /** @type {Element} */
        arguments[2];
      }

      if (arguments.length == 1) {
        bool = !node.hasAttribute(name);
      }

      if (bool) {
        node.setAttribute(name, '');
        return true;
      } else {
        node.removeAttribute(name);
        return false;
      }
    }
    /**
     * Toggles a CSS class on or off.
     *
     * @param {string} name CSS class name
     * @param {boolean=} bool Boolean to force the class on or off.
     *    When unspecified, the state of the class will be reversed.
     * @param {Element=} node Node to target.  Defaults to `this`.
     * @return {void}
     */


    toggleClass(name, bool, node) {
      node =
      /** @type {Element} */
      node || this;

      if (arguments.length == 1) {
        bool = !node.classList.contains(name);
      }

      if (bool) {
        node.classList.add(name);
      } else {
        node.classList.remove(name);
      }
    }
    /**
     * Cross-platform helper for setting an element's CSS `transform` property.
     *
     * @param {string} transformText Transform setting.
     * @param {Element=} node Element to apply the transform to.
     * Defaults to `this`
     * @return {void}
     */


    transform(transformText, node) {
      node =
      /** @type {Element} */
      node || this;
      node.style.webkitTransform = transformText;
      node.style.transform = transformText;
    }
    /**
     * Cross-platform helper for setting an element's CSS `translate3d`
     * property.
     *
     * @param {number} x X offset.
     * @param {number} y Y offset.
     * @param {number} z Z offset.
     * @param {Element=} node Element to apply the transform to.
     * Defaults to `this`.
     * @return {void}
     */


    translate3d(x, y, z, node) {
      node =
      /** @type {Element} */
      node || this;
      this.transform('translate3d(' + x + ',' + y + ',' + z + ')', node);
    }
    /**
     * Removes an item from an array, if it exists.
     *
     * If the array is specified by path, a change notification is
     * generated, so that observers, data bindings and computed
     * properties watching that path can update.
     *
     * If the array is passed directly, **no change
     * notification is generated**.
     *
     * @param {string | !Array<number|string>} arrayOrPath Path to array from which to remove the item
     *   (or the array itself).
     * @param {*} item Item to remove.
     * @return {Array} Array containing item removed.
     */


    arrayDelete(arrayOrPath, item) {
      let index;

      if (Array.isArray(arrayOrPath)) {
        index = arrayOrPath.indexOf(item);

        if (index >= 0) {
          return arrayOrPath.splice(index, 1);
        }
      } else {
        let arr = Object(_utils_path_js__WEBPACK_IMPORTED_MODULE_11__["get"])(this, arrayOrPath);
        index = arr.indexOf(item);

        if (index >= 0) {
          return this.splice(arrayOrPath, index, 1);
        }
      }

      return null;
    } // logging

    /**
     * Facades `console.log`/`warn`/`error` as override point.
     *
     * @param {string} level One of 'log', 'warn', 'error'
     * @param {Array} args Array of strings or objects to log
     * @return {void}
     */


    _logger(level, args) {
      // accept ['foo', 'bar'] and [['foo', 'bar']]
      if (Array.isArray(args) && args.length === 1 && Array.isArray(args[0])) {
        args = args[0];
      }

      switch (level) {
        case 'log':
        case 'warn':
        case 'error':
          console[level](...args);
      }
    }
    /**
     * Facades `console.log` as an override point.
     *
     * @param {...*} args Array of strings or objects to log
     * @return {void}
     */


    _log(...args) {
      this._logger('log', args);
    }
    /**
     * Facades `console.warn` as an override point.
     *
     * @param {...*} args Array of strings or objects to log
     * @return {void}
     */


    _warn(...args) {
      this._logger('warn', args);
    }
    /**
     * Facades `console.error` as an override point.
     *
     * @param {...*} args Array of strings or objects to log
     * @return {void}
     */


    _error(...args) {
      this._logger('error', args);
    }
    /**
     * Formats a message using the element type an a method name.
     *
     * @param {string} methodName Method name to associate with message
     * @param {...*} args Array of strings or objects to log
     * @return {Array} Array with formatting information for `console`
     *   logging.
     */


    _logf(methodName, ...args) {
      return ['[%s::%s]', this.is, methodName, ...args];
    }

  }

  LegacyElement.prototype.is = '';
  return LegacyElement;
});

/***/ }),

/***/ "./node_modules/@polymer/polymer/lib/legacy/mutable-data-behavior.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@polymer/polymer/lib/legacy/mutable-data-behavior.js ***!
  \***************************************************************************/
/*! exports provided: MutableDataBehavior, OptionalMutableDataBehavior */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "MutableDataBehavior", function() { return MutableDataBehavior; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "OptionalMutableDataBehavior", function() { return OptionalMutableDataBehavior; });
/* harmony import */ var _mixins_mutable_data_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../mixins/mutable-data.js */ "./node_modules/@polymer/polymer/lib/mixins/mutable-data.js");
/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/

let mutablePropertyChange;
/** @suppress {missingProperties} */

(() => {
  mutablePropertyChange = _mixins_mutable_data_js__WEBPACK_IMPORTED_MODULE_0__["MutableData"]._mutablePropertyChange;
})();
/**
 * Legacy element behavior to skip strict dirty-checking for objects and arrays,
 * (always consider them to be "dirty") for use on legacy API Polymer elements.
 *
 * By default, `Polymer.PropertyEffects` performs strict dirty checking on
 * objects, which means that any deep modifications to an object or array will
 * not be propagated unless "immutable" data patterns are used (i.e. all object
 * references from the root to the mutation were changed).
 *
 * Polymer also provides a proprietary data mutation and path notification API
 * (e.g. `notifyPath`, `set`, and array mutation API's) that allow efficient
 * mutation and notification of deep changes in an object graph to all elements
 * bound to the same object graph.
 *
 * In cases where neither immutable patterns nor the data mutation API can be
 * used, applying this mixin will cause Polymer to skip dirty checking for
 * objects and arrays (always consider them to be "dirty").  This allows a
 * user to make a deep modification to a bound object graph, and then either
 * simply re-set the object (e.g. `this.items = this.items`) or call `notifyPath`
 * (e.g. `this.notifyPath('items')`) to update the tree.  Note that all
 * elements that wish to be updated based on deep mutations must apply this
 * mixin or otherwise skip strict dirty checking for objects/arrays.
 * Specifically, any elements in the binding tree between the source of a
 * mutation and the consumption of it must apply this behavior or enable the
 * `Polymer.OptionalMutableDataBehavior`.
 *
 * In order to make the dirty check strategy configurable, see
 * `Polymer.OptionalMutableDataBehavior`.
 *
 * Note, the performance characteristics of propagating large object graphs
 * will be worse as opposed to using strict dirty checking with immutable
 * patterns or Polymer's path notification API.
 *
 * @polymerBehavior
 * @summary Behavior to skip strict dirty-checking for objects and
 *   arrays
 */


const MutableDataBehavior = {
  /**
   * Overrides `Polymer.PropertyEffects` to provide option for skipping
   * strict equality checking for Objects and Arrays.
   *
   * This method pulls the value to dirty check against from the `__dataTemp`
   * cache (rather than the normal `__data` cache) for Objects.  Since the temp
   * cache is cleared at the end of a turn, this implementation allows
   * side-effects of deep object changes to be processed by re-setting the
   * same object (using the temp cache as an in-turn backstop to prevent
   * cycles due to 2-way notification).
   *
   * @param {string} property Property name
   * @param {*} value New property value
   * @param {*} old Previous property value
   * @return {boolean} Whether the property should be considered a change
   * @protected
   */
  _shouldPropertyChange(property, value, old) {
    return mutablePropertyChange(this, property, value, old, true);
  }

};
/**
 * Legacy element behavior to add the optional ability to skip strict
 * dirty-checking for objects and arrays (always consider them to be
 * "dirty") by setting a `mutable-data` attribute on an element instance.
 *
 * By default, `Polymer.PropertyEffects` performs strict dirty checking on
 * objects, which means that any deep modifications to an object or array will
 * not be propagated unless "immutable" data patterns are used (i.e. all object
 * references from the root to the mutation were changed).
 *
 * Polymer also provides a proprietary data mutation and path notification API
 * (e.g. `notifyPath`, `set`, and array mutation API's) that allow efficient
 * mutation and notification of deep changes in an object graph to all elements
 * bound to the same object graph.
 *
 * In cases where neither immutable patterns nor the data mutation API can be
 * used, applying this mixin will allow Polymer to skip dirty checking for
 * objects and arrays (always consider them to be "dirty").  This allows a
 * user to make a deep modification to a bound object graph, and then either
 * simply re-set the object (e.g. `this.items = this.items`) or call `notifyPath`
 * (e.g. `this.notifyPath('items')`) to update the tree.  Note that all
 * elements that wish to be updated based on deep mutations must apply this
 * mixin or otherwise skip strict dirty checking for objects/arrays.
 * Specifically, any elements in the binding tree between the source of a
 * mutation and the consumption of it must enable this behavior or apply the
 * `Polymer.OptionalMutableDataBehavior`.
 *
 * While this behavior adds the ability to forgo Object/Array dirty checking,
 * the `mutableData` flag defaults to false and must be set on the instance.
 *
 * Note, the performance characteristics of propagating large object graphs
 * will be worse by relying on `mutableData: true` as opposed to using
 * strict dirty checking with immutable patterns or Polymer's path notification
 * API.
 *
 * @polymerBehavior
 * @summary Behavior to optionally skip strict dirty-checking for objects and
 *   arrays
 */

const OptionalMutableDataBehavior = {
  properties: {
    /**
     * Instance-level flag for configuring the dirty-checking strategy
     * for this element.  When true, Objects and Arrays will skip dirty
     * checking, otherwise strict equality checking will be used.
     */
    mutableData: Boolean
  },

  /**
   * Overrides `Polymer.PropertyEffects` to skip strict equality checking
   * for Objects and Arrays.
   *
   * Pulls the value to dirty check against from the `__dataTemp` cache
   * (rather than the normal `__data` cache) for Objects.  Since the temp
   * cache is cleared at the end of a turn, this implementation allows
   * side-effects of deep object changes to be processed by re-setting the
   * same object (using the temp cache as an in-turn backstop to prevent
   * cycles due to 2-way notification).
   *
   * @param {string} property Property name
   * @param {*} value New property value
   * @param {*} old Previous property value
   * @return {boolean} Whether the property should be considered a change
   * @this {this}
   * @protected
   */
  _shouldPropertyChange(property, value, old) {
    return mutablePropertyChange(this, property, value, old, this.mutableData);
  }

};

/***/ }),

/***/ "./node_modules/@polymer/polymer/lib/legacy/polymer-fn.js":
/*!****************************************************************!*\
  !*** ./node_modules/@polymer/polymer/lib/legacy/polymer-fn.js ***!
  \****************************************************************/
/*! exports provided: Polymer */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Polymer", function() { return Polymer; });
/* harmony import */ var _class_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./class.js */ "./node_modules/@polymer/polymer/lib/legacy/class.js");
/* harmony import */ var _utils_boot_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/boot.js */ "./node_modules/@polymer/polymer/lib/utils/boot.js");
/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/


/**
 * Legacy class factory and registration helper for defining Polymer
 * elements.
 *
 * This method is equivalent to
 *
 *     import {Class} from '@polymer/polymer/lib/legacy/class.js';
 *     customElements.define(info.is, Class(info));
 *
 * See `Class` for details on valid legacy metadata format for `info`.
 *
 * @global
 * @override
 * @function
 * @param {!PolymerInit} info Object containing Polymer metadata and functions
 *   to become class methods.
 * @return {function(new: HTMLElement)} Generated class
 * @suppress {duplicate, invalidCasts, checkTypes}
 */

const Polymer = function (info) {
  // if input is a `class` (aka a function with a prototype), use the prototype
  // remember that the `constructor` will never be called
  let klass;

  if (typeof info === 'function') {
    klass = info;
  } else {
    klass = Polymer.Class(info);
  }

  customElements.define(klass.is,
  /** @type {!HTMLElement} */
  klass);
  return klass;
};

Polymer.Class = _class_js__WEBPACK_IMPORTED_MODULE_0__["Class"];


/***/ }),

/***/ "./node_modules/@polymer/polymer/lib/legacy/polymer.dom.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@polymer/polymer/lib/legacy/polymer.dom.js ***!
  \*****************************************************************/
/*! exports provided: flush, addDebouncer, matchesSelector, DomApi, EventApi, dom */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "matchesSelector", function() { return matchesSelector; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DomApi", function() { return DomApi; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "EventApi", function() { return EventApi; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "dom", function() { return dom; });
/* harmony import */ var _utils_boot_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/boot.js */ "./node_modules/@polymer/polymer/lib/utils/boot.js");
/* harmony import */ var _utils_settings_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/settings.js */ "./node_modules/@polymer/polymer/lib/utils/settings.js");
/* harmony import */ var _utils_flattened_nodes_observer_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/flattened-nodes-observer.js */ "./node_modules/@polymer/polymer/lib/utils/flattened-nodes-observer.js");
/* harmony import */ var _utils_flush_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/flush.js */ "./node_modules/@polymer/polymer/lib/utils/flush.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "flush", function() { return _utils_flush_js__WEBPACK_IMPORTED_MODULE_3__["flush"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "addDebouncer", function() { return _utils_flush_js__WEBPACK_IMPORTED_MODULE_3__["enqueueDebouncer"]; });

/* harmony import */ var _utils_debounce_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/debounce.js */ "./node_modules/@polymer/polymer/lib/utils/debounce.js");
/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/




/* eslint-disable no-unused-vars */

 // used in type annotations

/* eslint-enable no-unused-vars */

const p = Element.prototype;
/**
 * @const {function(this:Node, string): boolean}
 */

const normalizedMatchesSelector = p.matches || p.matchesSelector || p.mozMatchesSelector || p.msMatchesSelector || p.oMatchesSelector || p.webkitMatchesSelector;
/**
 * Cross-platform `element.matches` shim.
 *
 * @function matchesSelector
 * @param {!Node} node Node to check selector against
 * @param {string} selector Selector to match
 * @return {boolean} True if node matched selector
 */

const matchesSelector = function (node, selector) {
  return normalizedMatchesSelector.call(node, selector);
};
/**
 * Node API wrapper class returned from `Polymer.dom.(target)` when
 * `target` is a `Node`.
 *
 */

class DomApi {
  /**
   * @param {Node} node Node for which to create a Polymer.dom helper object.
   */
  constructor(node) {
    this.node = node;
  }
  /**
   * Returns an instance of `FlattenedNodesObserver` that
   * listens for node changes on this element.
   *
   * @param {function(this:HTMLElement, { target: !HTMLElement, addedNodes: !Array<!Element>, removedNodes: !Array<!Element> }):void} callback Called when direct or distributed children
   *   of this element changes
   * @return {!FlattenedNodesObserver} Observer instance
   */


  observeNodes(callback) {
    return new _utils_flattened_nodes_observer_js__WEBPACK_IMPORTED_MODULE_2__["FlattenedNodesObserver"](
    /** @type {!HTMLElement} */
    this.node, callback);
  }
  /**
   * Disconnects an observer previously created via `observeNodes`
   *
   * @param {!FlattenedNodesObserver} observerHandle Observer instance
   *   to disconnect.
   * @return {void}
   */


  unobserveNodes(observerHandle) {
    observerHandle.disconnect();
  }
  /**
   * Provided as a backwards-compatible API only.  This method does nothing.
   * @return {void}
   */


  notifyObserver() {}
  /**
   * Returns true if the provided node is contained with this element's
   * light-DOM children or shadow root, including any nested shadow roots
   * of children therein.
   *
   * @param {Node} node Node to test
   * @return {boolean} Returns true if the given `node` is contained within
   *   this element's light or shadow DOM.
   */


  deepContains(node) {
    if (this.node.contains(node)) {
      return true;
    }

    let n = node;
    let doc = node.ownerDocument; // walk from node to `this` or `document`

    while (n && n !== doc && n !== this.node) {
      // use logical parentnode, or native ShadowRoot host
      n = n.parentNode || n.host;
    }

    return n === this.node;
  }
  /**
   * Returns the root node of this node.  Equivalent to `getRootNode()`.
   *
   * @return {Node} Top most element in the dom tree in which the node
   * exists. If the node is connected to a document this is either a
   * shadowRoot or the document; otherwise, it may be the node
   * itself or a node or document fragment containing it.
   */


  getOwnerRoot() {
    return this.node.getRootNode();
  }
  /**
   * For slot elements, returns the nodes assigned to the slot; otherwise
   * an empty array. It is equivalent to `<slot>.addignedNodes({flatten:true})`.
   *
   * @return {!Array<!Node>} Array of assigned nodes
   */


  getDistributedNodes() {
    return this.node.localName === 'slot' ? this.node.assignedNodes({
      flatten: true
    }) : [];
  }
  /**
   * Returns an array of all slots this element was distributed to.
   *
   * @return {!Array<!HTMLSlotElement>} Description
   */


  getDestinationInsertionPoints() {
    let ip$ = [];
    let n = this.node.assignedSlot;

    while (n) {
      ip$.push(n);
      n = n.assignedSlot;
    }

    return ip$;
  }
  /**
   * Calls `importNode` on the `ownerDocument` for this node.
   *
   * @param {!Node} node Node to import
   * @param {boolean} deep True if the node should be cloned deeply during
   *   import
   * @return {Node} Clone of given node imported to this owner document
   */


  importNode(node, deep) {
    let doc = this.node instanceof Document ? this.node : this.node.ownerDocument;
    return doc.importNode(node, deep);
  }
  /**
   * @return {!Array<!Node>} Returns a flattened list of all child nodes and
   * nodes assigned to child slots.
   */


  getEffectiveChildNodes() {
    return _utils_flattened_nodes_observer_js__WEBPACK_IMPORTED_MODULE_2__["FlattenedNodesObserver"].getFlattenedNodes(
    /** @type {!HTMLElement} */
    this.node);
  }
  /**
   * Returns a filtered list of flattened child elements for this element based
   * on the given selector.
   *
   * @param {string} selector Selector to filter nodes against
   * @return {!Array<!HTMLElement>} List of flattened child elements
   */


  queryDistributedElements(selector) {
    let c$ = this.getEffectiveChildNodes();
    let list = [];

    for (let i = 0, l = c$.length, c; i < l && (c = c$[i]); i++) {
      if (c.nodeType === Node.ELEMENT_NODE && matchesSelector(c, selector)) {
        list.push(c);
      }
    }

    return list;
  }
  /**
   * For shadow roots, returns the currently focused element within this
   * shadow root.
   *
   * @return {Node|undefined} Currently focused element
   */


  get activeElement() {
    let node = this.node;
    return node._activeElement !== undefined ? node._activeElement : node.activeElement;
  }

}

function forwardMethods(proto, methods) {
  for (let i = 0; i < methods.length; i++) {
    let method = methods[i];
    /* eslint-disable valid-jsdoc */

    proto[method] =
    /** @this {DomApi} */
    function () {
      return this.node[method].apply(this.node, arguments);
    };
    /* eslint-enable */

  }
}

function forwardReadOnlyProperties(proto, properties) {
  for (let i = 0; i < properties.length; i++) {
    let name = properties[i];
    Object.defineProperty(proto, name, {
      get: function () {
        const domApi =
        /** @type {DomApi} */
        this;
        return domApi.node[name];
      },
      configurable: true
    });
  }
}

function forwardProperties(proto, properties) {
  for (let i = 0; i < properties.length; i++) {
    let name = properties[i];
    Object.defineProperty(proto, name, {
      /**
       * @this {DomApi}
       * @return {*} .
       */
      get: function () {
        return this.node[name];
      },

      /**
       * @this {DomApi}
       * @param {*} value .
       */
      set: function (value) {
        this.node[name] = value;
      },
      configurable: true
    });
  }
}
/**
 * Event API wrapper class returned from `dom.(target)` when
 * `target` is an `Event`.
 */


class EventApi {
  constructor(event) {
    this.event = event;
  }
  /**
   * Returns the first node on the `composedPath` of this event.
   *
   * @return {!EventTarget} The node this event was dispatched to
   */


  get rootTarget() {
    return this.event.composedPath()[0];
  }
  /**
   * Returns the local (re-targeted) target for this event.
   *
   * @return {!EventTarget} The local (re-targeted) target for this event.
   */


  get localTarget() {
    return this.event.target;
  }
  /**
   * Returns the `composedPath` for this event.
   * @return {!Array<!EventTarget>} The nodes this event propagated through
   */


  get path() {
    return this.event.composedPath();
  }

}
/**
 * @function
 * @param {boolean=} deep
 * @return {!Node}
 */

DomApi.prototype.cloneNode;
/**
 * @function
 * @param {!Node} node
 * @return {!Node}
 */

DomApi.prototype.appendChild;
/**
 * @function
 * @param {!Node} newChild
 * @param {Node} refChild
 * @return {!Node}
 */

DomApi.prototype.insertBefore;
/**
 * @function
 * @param {!Node} node
 * @return {!Node}
 */

DomApi.prototype.removeChild;
/**
 * @function
 * @param {!Node} oldChild
 * @param {!Node} newChild
 * @return {!Node}
 */

DomApi.prototype.replaceChild;
/**
 * @function
 * @param {string} name
 * @param {string} value
 * @return {void}
 */

DomApi.prototype.setAttribute;
/**
 * @function
 * @param {string} name
 * @return {void}
 */

DomApi.prototype.removeAttribute;
/**
 * @function
 * @param {string} selector
 * @return {?Element}
 */

DomApi.prototype.querySelector;
/**
 * @function
 * @param {string} selector
 * @return {!NodeList<!Element>}
 */

DomApi.prototype.querySelectorAll;
/** @type {?Node} */

DomApi.prototype.parentNode;
/** @type {?Node} */

DomApi.prototype.firstChild;
/** @type {?Node} */

DomApi.prototype.lastChild;
/** @type {?Node} */

DomApi.prototype.nextSibling;
/** @type {?Node} */

DomApi.prototype.previousSibling;
/** @type {?HTMLElement} */

DomApi.prototype.firstElementChild;
/** @type {?HTMLElement} */

DomApi.prototype.lastElementChild;
/** @type {?HTMLElement} */

DomApi.prototype.nextElementSibling;
/** @type {?HTMLElement} */

DomApi.prototype.previousElementSibling;
/** @type {!Array<!Node>} */

DomApi.prototype.childNodes;
/** @type {!Array<!HTMLElement>} */

DomApi.prototype.children;
/** @type {?DOMTokenList} */

DomApi.prototype.classList;
/** @type {string} */

DomApi.prototype.textContent;
/** @type {string} */

DomApi.prototype.innerHTML;
forwardMethods(DomApi.prototype, ['cloneNode', 'appendChild', 'insertBefore', 'removeChild', 'replaceChild', 'setAttribute', 'removeAttribute', 'querySelector', 'querySelectorAll']);
forwardReadOnlyProperties(DomApi.prototype, ['parentNode', 'firstChild', 'lastChild', 'nextSibling', 'previousSibling', 'firstElementChild', 'lastElementChild', 'nextElementSibling', 'previousElementSibling', 'childNodes', 'children', 'classList']);
forwardProperties(DomApi.prototype, ['textContent', 'innerHTML']);
/**
 * Legacy DOM and Event manipulation API wrapper factory used to abstract
 * differences between native Shadow DOM and "Shady DOM" when polyfilling on
 * older browsers.
 *
 * Note that in Polymer 2.x use of `Polymer.dom` is no longer required and
 * in the majority of cases simply facades directly to the standard native
 * API.
 *
 * @summary Legacy DOM and Event manipulation API wrapper factory used to
 * abstract differences between native Shadow DOM and "Shady DOM."
 * @param {(Node|Event)=} obj Node or event to operate on
 * @return {!DomApi|!EventApi} Wrapper providing either node API or event API
 */

const dom = function (obj) {
  obj = obj || document;

  if (!obj.__domApi) {
    let helper;

    if (obj instanceof Event) {
      helper = new EventApi(obj);
    } else {
      helper = new DomApi(obj);
    }

    obj.__domApi = helper;
  }

  return obj.__domApi;
};

/***/ }),

/***/ "./node_modules/@polymer/polymer/lib/legacy/templatizer-behavior.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@polymer/polymer/lib/legacy/templatizer-behavior.js ***!
  \**************************************************************************/
/*! exports provided: Templatizer */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Templatizer", function() { return Templatizer; });
/* harmony import */ var _utils_templatize_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/templatize.js */ "./node_modules/@polymer/polymer/lib/utils/templatize.js");
/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/
 // eslint-disable-line no-unused-vars

/**
 * @typedef {{
 *   _templatizerTemplate: HTMLTemplateElement,
 *   _parentModel: boolean,
 *   _instanceProps: Object,
 *   _forwardHostPropV2: Function,
 *   _notifyInstancePropV2: Function,
 *   ctor: TemplateInstanceBase
 * }}
 */

let TemplatizerUser; // eslint-disable-line

/**
 * The `Templatizer` behavior adds methods to generate instances of
 * templates that are each managed by an anonymous `PropertyEffects`
 * instance where data-bindings in the stamped template content are bound to
 * accessors on itself.
 *
 * This behavior is provided in Polymer 2.x-3.x as a hybrid-element convenience
 * only.  For non-hybrid usage, the `Templatize` library
 * should be used instead.
 *
 * Example:
 *
 *     import {dom} from '@polymer/polymer/lib/legacy/polymer.dom.js';
 *     // Get a template from somewhere, e.g. light DOM
 *     let template = this.querySelector('template');
 *     // Prepare the template
 *     this.templatize(template);
 *     // Instance the template with an initial data model
 *     let instance = this.stamp({myProp: 'initial'});
 *     // Insert the instance's DOM somewhere, e.g. light DOM
 *     dom(this).appendChild(instance.root);
 *     // Changing a property on the instance will propagate to bindings
 *     // in the template
 *     instance.myProp = 'new value';
 *
 * Users of `Templatizer` may need to implement the following abstract
 * API's to determine how properties and paths from the host should be
 * forwarded into to instances:
 *
 *     _forwardHostPropV2: function(prop, value)
 *
 * Likewise, users may implement these additional abstract API's to determine
 * how instance-specific properties that change on the instance should be
 * forwarded out to the host, if necessary.
 *
 *     _notifyInstancePropV2: function(inst, prop, value)
 *
 * In order to determine which properties are instance-specific and require
 * custom notification via `_notifyInstanceProp`, define an `_instanceProps`
 * object containing keys for each instance prop, for example:
 *
 *     _instanceProps: {
 *       item: true,
 *       index: true
 *     }
 *
 * Any properties used in the template that are not defined in _instanceProp
 * will be forwarded out to the Templatize `owner` automatically.
 *
 * Users may also implement the following abstract function to show or
 * hide any DOM generated using `stamp`:
 *
 *     _showHideChildren: function(shouldHide)
 *
 * Note that some callbacks are suffixed with `V2` in the Polymer 2.x behavior
 * as the implementations will need to differ from the callbacks required
 * by the 1.x Templatizer API due to changes in the `TemplateInstance` API
 * between versions 1.x and 2.x.
 *
 * @polymerBehavior
 */

const Templatizer = {
  /**
   * Generates an anonymous `TemplateInstance` class (stored as `this.ctor`)
   * for the provided template.  This method should be called once per
   * template to prepare an element for stamping the template, followed
   * by `stamp` to create new instances of the template.
   *
   * @param {!HTMLTemplateElement} template Template to prepare
   * @param {boolean=} mutableData When `true`, the generated class will skip
   *   strict dirty-checking for objects and arrays (always consider them to
   *   be "dirty"). Defaults to false.
   * @return {void}
   * @this {TemplatizerUser}
   */
  templatize(template, mutableData) {
    this._templatizerTemplate = template;
    this.ctor = Object(_utils_templatize_js__WEBPACK_IMPORTED_MODULE_0__["templatize"])(template, this, {
      mutableData: Boolean(mutableData),
      parentModel: this._parentModel,
      instanceProps: this._instanceProps,
      forwardHostProp: this._forwardHostPropV2,
      notifyInstanceProp: this._notifyInstancePropV2
    });
  },

  /**
   * Creates an instance of the template prepared by `templatize`.  The object
   * returned is an instance of the anonymous class generated by `templatize`
   * whose `root` property is a document fragment containing newly cloned
   * template content, and which has property accessors corresponding to
   * properties referenced in template bindings.
   *
   * @param {Object=} model Object containing initial property values to
   *   populate into the template bindings.
   * @return {TemplateInstanceBase} Returns the created instance of
   * the template prepared by `templatize`.
   * @this {TemplatizerUser}
   */
  stamp(model) {
    return new this.ctor(model);
  },

  /**
   * Returns the template "model" (`TemplateInstance`) associated with
   * a given element, which serves as the binding scope for the template
   * instance the element is contained in.  A template model should be used
   * to manipulate data associated with this template instance.
   *
   * @param {HTMLElement} el Element for which to return a template model.
   * @return {TemplateInstanceBase} Model representing the binding scope for
   *   the element.
   * @this {TemplatizerUser}
   */
  modelForElement(el) {
    return Object(_utils_templatize_js__WEBPACK_IMPORTED_MODULE_0__["modelForElement"])(this._templatizerTemplate, el);
  }

};

/***/ }),

/***/ "./node_modules/@polymer/polymer/lib/mixins/dir-mixin.js":
/*!***************************************************************!*\
  !*** ./node_modules/@polymer/polymer/lib/mixins/dir-mixin.js ***!
  \***************************************************************/
/*! exports provided: DirMixin */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DirMixin", function() { return DirMixin; });
/* harmony import */ var _property_accessors_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./property-accessors.js */ "./node_modules/@polymer/polymer/lib/mixins/property-accessors.js");
/* harmony import */ var _utils_mixin_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/mixin.js */ "./node_modules/@polymer/polymer/lib/utils/mixin.js");
/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/


const HOST_DIR = /:host\(:dir\((ltr|rtl)\)\)/g;
const HOST_DIR_REPLACMENT = ':host([dir="$1"])';
const EL_DIR = /([\s\w-#\.\[\]\*]*):dir\((ltr|rtl)\)/g;
const EL_DIR_REPLACMENT = ':host([dir="$2"]) $1';
/**
 * @type {!Array<!Polymer_DirMixin>}
 */

const DIR_INSTANCES = [];
/** @type {MutationObserver} */

let observer = null;
let DOCUMENT_DIR = '';

function getRTL() {
  DOCUMENT_DIR = document.documentElement.getAttribute('dir');
}
/**
 * @param {!Polymer_DirMixin} instance Instance to set RTL status on
 */


function setRTL(instance) {
  if (!instance.__autoDirOptOut) {
    const el =
    /** @type {!HTMLElement} */
    instance;
    el.setAttribute('dir', DOCUMENT_DIR);
  }
}

function updateDirection() {
  getRTL();
  DOCUMENT_DIR = document.documentElement.getAttribute('dir');

  for (let i = 0; i < DIR_INSTANCES.length; i++) {
    setRTL(DIR_INSTANCES[i]);
  }
}

function takeRecords() {
  if (observer && observer.takeRecords().length) {
    updateDirection();
  }
}
/**
 * Element class mixin that allows elements to use the `:dir` CSS Selector to
 * have text direction specific styling.
 *
 * With this mixin, any stylesheet provided in the template will transform
 * `:dir` into `:host([dir])` and sync direction with the page via the
 * element's `dir` attribute.
 *
 * Elements can opt out of the global page text direction by setting the `dir`
 * attribute directly in `ready()` or in HTML.
 *
 * Caveats:
 * - Applications must set `<html dir="ltr">` or `<html dir="rtl">` to sync
 *   direction
 * - Automatic left-to-right or right-to-left styling is sync'd with the
 *   `<html>` element only.
 * - Changing `dir` at runtime is supported.
 * - Opting out of the global direction styling is permanent
 *
 * @mixinFunction
 * @polymer
 * @appliesMixin PropertyAccessors
 */


const DirMixin = Object(_utils_mixin_js__WEBPACK_IMPORTED_MODULE_1__["dedupingMixin"])(base => {
  if (!observer) {
    getRTL();
    observer = new MutationObserver(updateDirection);
    observer.observe(document.documentElement, {
      attributes: true,
      attributeFilter: ['dir']
    });
  }
  /**
   * @constructor
   * @extends {base}
   * @implements {Polymer_PropertyAccessors}
   * @private
   */


  const elementBase = Object(_property_accessors_js__WEBPACK_IMPORTED_MODULE_0__["PropertyAccessors"])(base);
  /**
   * @polymer
   * @mixinClass
   * @implements {Polymer_DirMixin}
   */

  class Dir extends elementBase {
    /**
     * @override
     * @suppress {missingProperties} Interfaces in closure do not inherit statics, but classes do
     */
    static _processStyleText(cssText, baseURI) {
      cssText = super._processStyleText(cssText, baseURI);
      cssText = this._replaceDirInCssText(cssText);
      return cssText;
    }
    /**
     * Replace `:dir` in the given CSS text
     *
     * @param {string} text CSS text to replace DIR
     * @return {string} Modified CSS
     */


    static _replaceDirInCssText(text) {
      let replacedText = text;
      replacedText = replacedText.replace(HOST_DIR, HOST_DIR_REPLACMENT);
      replacedText = replacedText.replace(EL_DIR, EL_DIR_REPLACMENT);

      if (text !== replacedText) {
        this.__activateDir = true;
      }

      return replacedText;
    }

    constructor() {
      super();
      /** @type {boolean} */

      this.__autoDirOptOut = false;
    }
    /**
     * @suppress {invalidCasts} Closure doesn't understand that `this` is an HTMLElement
     * @return {void}
     */


    ready() {
      super.ready();
      this.__autoDirOptOut =
      /** @type {!HTMLElement} */
      this.hasAttribute('dir');
    }
    /**
     * @suppress {missingProperties} If it exists on elementBase, it can be super'd
     * @return {void}
     */


    connectedCallback() {
      if (elementBase.prototype.connectedCallback) {
        super.connectedCallback();
      }

      if (this.constructor.__activateDir) {
        takeRecords();
        DIR_INSTANCES.push(this);
        setRTL(this);
      }
    }
    /**
     * @suppress {missingProperties} If it exists on elementBase, it can be super'd
     * @return {void}
     */


    disconnectedCallback() {
      if (elementBase.prototype.disconnectedCallback) {
        super.disconnectedCallback();
      }

      if (this.constructor.__activateDir) {
        const idx = DIR_INSTANCES.indexOf(this);

        if (idx > -1) {
          DIR_INSTANCES.splice(idx, 1);
        }
      }
    }

  }

  Dir.__activateDir = false;
  return Dir;
});

/***/ }),

/***/ "./node_modules/@polymer/polymer/lib/mixins/element-mixin.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@polymer/polymer/lib/mixins/element-mixin.js ***!
  \*******************************************************************/
/*! exports provided: version, ElementMixin, instanceCount, registrations, register, dumpRegistrations, updateStyles */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "version", function() { return version; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ElementMixin", function() { return ElementMixin; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "instanceCount", function() { return instanceCount; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "registrations", function() { return registrations; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "register", function() { return register; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "dumpRegistrations", function() { return dumpRegistrations; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "updateStyles", function() { return updateStyles; });
/* harmony import */ var _utils_boot_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/boot.js */ "./node_modules/@polymer/polymer/lib/utils/boot.js");
/* harmony import */ var _utils_settings_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/settings.js */ "./node_modules/@polymer/polymer/lib/utils/settings.js");
/* harmony import */ var _utils_mixin_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/mixin.js */ "./node_modules/@polymer/polymer/lib/utils/mixin.js");
/* harmony import */ var _utils_style_gather_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/style-gather.js */ "./node_modules/@polymer/polymer/lib/utils/style-gather.js");
/* harmony import */ var _utils_resolve_url_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/resolve-url.js */ "./node_modules/@polymer/polymer/lib/utils/resolve-url.js");
/* harmony import */ var _elements_dom_module_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../elements/dom-module.js */ "./node_modules/@polymer/polymer/lib/elements/dom-module.js");
/* harmony import */ var _property_effects_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./property-effects.js */ "./node_modules/@polymer/polymer/lib/mixins/property-effects.js");
/* harmony import */ var _properties_mixin_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./properties-mixin.js */ "./node_modules/@polymer/polymer/lib/mixins/properties-mixin.js");
/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/








/**
 * Current Polymer version in Semver notation.
 * @type {string} Semver notation of the current version of Polymer.
 */

const version = '3.0.5';
/**
 * Element class mixin that provides the core API for Polymer's meta-programming
 * features including template stamping, data-binding, attribute deserialization,
 * and property change observation.
 *
 * Subclassers may provide the following static getters to return metadata
 * used to configure Polymer's features for the class:
 *
 * - `static get is()`: When the template is provided via a `dom-module`,
 *   users should return the `dom-module` id from a static `is` getter.  If
 *   no template is needed or the template is provided directly via the
 *   `template` getter, there is no need to define `is` for the element.
 *
 * - `static get template()`: Users may provide the template directly (as
 *   opposed to via `dom-module`) by implementing a static `template` getter.
 *   The getter must return an `HTMLTemplateElement`.
 *
 * - `static get properties()`: Should return an object describing
 *   property-related metadata used by Polymer features (key: property name
 *   value: object containing property metadata). Valid keys in per-property
 *   metadata include:
 *   - `type` (String|Number|Object|Array|...): Used by
 *     `attributeChangedCallback` to determine how string-based attributes
 *     are deserialized to JavaScript property values.
 *   - `notify` (boolean): Causes a change in the property to fire a
 *     non-bubbling event called `<property>-changed`. Elements that have
 *     enabled two-way binding to the property use this event to observe changes.
 *   - `readOnly` (boolean): Creates a getter for the property, but no setter.
 *     To set a read-only property, use the private setter method
 *     `_setProperty(property, value)`.
 *   - `observer` (string): Observer method name that will be called when
 *     the property changes. The arguments of the method are
 *     `(value, previousValue)`.
 *   - `computed` (string): String describing method and dependent properties
 *     for computing the value of this property (e.g. `'computeFoo(bar, zot)'`).
 *     Computed properties are read-only by default and can only be changed
 *     via the return value of the computing method.
 *
 * - `static get observers()`: Array of strings describing multi-property
 *   observer methods and their dependent properties (e.g.
 *   `'observeABC(a, b, c)'`).
 *
 * The base class provides default implementations for the following standard
 * custom element lifecycle callbacks; users may override these, but should
 * call the super method to ensure
 * - `constructor`: Run when the element is created or upgraded
 * - `connectedCallback`: Run each time the element is connected to the
 *   document
 * - `disconnectedCallback`: Run each time the element is disconnected from
 *   the document
 * - `attributeChangedCallback`: Run each time an attribute in
 *   `observedAttributes` is set or removed (note: this element's default
 *   `observedAttributes` implementation will automatically return an array
 *   of dash-cased attributes based on `properties`)
 *
 * @mixinFunction
 * @polymer
 * @appliesMixin PropertyEffects
 * @appliesMixin PropertiesMixin
 * @property rootPath {string} Set to the value of `rootPath`,
 *   which defaults to the main document path
 * @property importPath {string} Set to the value of the class's static
 *   `importPath` property, which defaults to the path of this element's
 *   `dom-module` (when `is` is used), but can be overridden for other
 *   import strategies.
 * @summary Element class mixin that provides the core API for Polymer's
 * meta-programming features.
 */

const ElementMixin = Object(_utils_mixin_js__WEBPACK_IMPORTED_MODULE_2__["dedupingMixin"])(base => {
  /**
   * @constructor
   * @extends {base}
   * @implements {Polymer_PropertyEffects}
   * @implements {Polymer_PropertiesMixin}
   * @private
   */
  const polymerElementBase = Object(_properties_mixin_js__WEBPACK_IMPORTED_MODULE_7__["PropertiesMixin"])(Object(_property_effects_js__WEBPACK_IMPORTED_MODULE_6__["PropertyEffects"])(base));
  /**
   * Returns a list of properties with default values.
   * This list is created as an optimization since it is a subset of
   * the list returned from `_properties`.
   * This list is used in `_initializeProperties` to set property defaults.
   *
   * @param {PolymerElementConstructor} constructor Element class
   * @return {PolymerElementProperties} Flattened properties for this class
   *   that have default values
   * @private
   */

  function propertyDefaults(constructor) {
    if (!constructor.hasOwnProperty(JSCompiler_renameProperty('__propertyDefaults', constructor))) {
      constructor.__propertyDefaults = null;
      let props = constructor._properties;

      for (let p in props) {
        let info = props[p];

        if ('value' in info) {
          constructor.__propertyDefaults = constructor.__propertyDefaults || {};
          constructor.__propertyDefaults[p] = info;
        }
      }
    }

    return constructor.__propertyDefaults;
  }
  /**
   * Returns a memoized version of the `observers` array.
   * @param {PolymerElementConstructor} constructor Element class
   * @return {Array} Array containing own observers for the given class
   * @protected
   */


  function ownObservers(constructor) {
    if (!constructor.hasOwnProperty(JSCompiler_renameProperty('__ownObservers', constructor))) {
      constructor.__ownObservers = constructor.hasOwnProperty(JSCompiler_renameProperty('observers', constructor)) ?
      /** @type {PolymerElementConstructor} */
      constructor.observers : null;
    }

    return constructor.__ownObservers;
  }
  /**
   * Creates effects for a property.
   *
   * Note, once a property has been set to
   * `readOnly`, `computed`, `reflectToAttribute`, or `notify`
   * these values may not be changed. For example, a subclass cannot
   * alter these settings. However, additional `observers` may be added
   * by subclasses.
   *
   * The info object should contain property metadata as follows:
   *
   * * `type`: {function} type to which an attribute matching the property
   * is deserialized. Note the property is camel-cased from a dash-cased
   * attribute. For example, 'foo-bar' attribute is deserialized to a
   * property named 'fooBar'.
   *
   * * `readOnly`: {boolean} creates a readOnly property and
   * makes a private setter for the private of the form '_setFoo' for a
   * property 'foo',
   *
   * * `computed`: {string} creates a computed property. A computed property
   * is also automatically set to `readOnly: true`. The value is calculated
   * by running a method and arguments parsed from the given string. For
   * example 'compute(foo)' will compute a given property when the
   * 'foo' property changes by executing the 'compute' method. This method
   * must return the computed value.
   *
   * * `reflectToAttribute`: {boolean} If true, the property value is reflected
   * to an attribute of the same name. Note, the attribute is dash-cased
   * so a property named 'fooBar' is reflected as 'foo-bar'.
   *
   * * `notify`: {boolean} sends a non-bubbling notification event when
   * the property changes. For example, a property named 'foo' sends an
   * event named 'foo-changed' with `event.detail` set to the value of
   * the property.
   *
   * * observer: {string} name of a method that runs when the property
   * changes. The arguments of the method are (value, previousValue).
   *
   * Note: Users may want control over modifying property
   * effects via subclassing. For example, a user might want to make a
   * reflectToAttribute property not do so in a subclass. We've chosen to
   * disable this because it leads to additional complication.
   * For example, a readOnly effect generates a special setter. If a subclass
   * disables the effect, the setter would fail unexpectedly.
   * Based on feedback, we may want to try to make effects more malleable
   * and/or provide an advanced api for manipulating them.
   * Also consider adding warnings when an effect cannot be changed.
   *
   * @param {!PolymerElement} proto Element class prototype to add accessors
   *   and effects to
   * @param {string} name Name of the property.
   * @param {Object} info Info object from which to create property effects.
   * Supported keys:
   * @param {Object} allProps Flattened map of all properties defined in this
   *   element (including inherited properties)
   * @return {void}
   * @private
   */


  function createPropertyFromConfig(proto, name, info, allProps) {
    // computed forces readOnly...
    if (info.computed) {
      info.readOnly = true;
    } // Note, since all computed properties are readOnly, this prevents
    // adding additional computed property effects (which leads to a confusing
    // setup where multiple triggers for setting a property)
    // While we do have `hasComputedEffect` this is set on the property's
    // dependencies rather than itself.


    if (info.computed && !proto._hasReadOnlyEffect(name)) {
      proto._createComputedProperty(name, info.computed, allProps);
    }

    if (info.readOnly && !proto._hasReadOnlyEffect(name)) {
      proto._createReadOnlyProperty(name, !info.computed);
    }

    if (info.reflectToAttribute && !proto._hasReflectEffect(name)) {
      proto._createReflectedProperty(name);
    }

    if (info.notify && !proto._hasNotifyEffect(name)) {
      proto._createNotifyingProperty(name);
    } // always add observer


    if (info.observer) {
      proto._createPropertyObserver(name, info.observer, allProps[info.observer]);
    } // always create the mapping from attribute back to property for deserialization.


    proto._addPropertyToAttributeMap(name);
  }
  /**
   * Process all style elements in the element template. Styles with the
   * `include` attribute are processed such that any styles in
   * the associated "style modules" are included in the element template.
   * @param {PolymerElementConstructor} klass Element class
   * @param {!HTMLTemplateElement} template Template to process
   * @param {string} is Name of element
   * @param {string} baseURI Base URI for element
   * @private
   */


  function processElementStyles(klass, template, is, baseURI) {
    const templateStyles = template.content.querySelectorAll('style');
    const stylesWithImports = Object(_utils_style_gather_js__WEBPACK_IMPORTED_MODULE_3__["stylesFromTemplate"])(template); // insert styles from <link rel="import" type="css"> at the top of the template

    const linkedStyles = Object(_utils_style_gather_js__WEBPACK_IMPORTED_MODULE_3__["stylesFromModuleImports"])(is);
    const firstTemplateChild = template.content.firstElementChild;

    for (let idx = 0; idx < linkedStyles.length; idx++) {
      let s = linkedStyles[idx];
      s.textContent = klass._processStyleText(s.textContent, baseURI);
      template.content.insertBefore(s, firstTemplateChild);
    } // keep track of the last "concrete" style in the template we have encountered


    let templateStyleIndex = 0; // ensure all gathered styles are actually in this template.

    for (let i = 0; i < stylesWithImports.length; i++) {
      let s = stylesWithImports[i];
      let templateStyle = templateStyles[templateStyleIndex]; // if the style is not in this template, it's been "included" and
      // we put a clone of it in the template before the style that included it

      if (templateStyle !== s) {
        s = s.cloneNode(true);
        templateStyle.parentNode.insertBefore(s, templateStyle);
      } else {
        templateStyleIndex++;
      }

      s.textContent = klass._processStyleText(s.textContent, baseURI);
    }

    if (window.ShadyCSS) {
      window.ShadyCSS.prepareTemplate(template, is);
    }
  }
  /**
   * Look up template from dom-module for element
   *
   * @param {!string} is Element name to look up
   * @return {!HTMLTemplateElement} Template found in dom module, or
   *   undefined if not found
   * @protected
   */


  function getTemplateFromDomModule(is) {
    let template = null; // Under strictTemplatePolicy in 3.x+, dom-module lookup is only allowed
    // when opted-in via allowTemplateFromDomModule

    if (is && (!_utils_settings_js__WEBPACK_IMPORTED_MODULE_1__["strictTemplatePolicy"] || _utils_settings_js__WEBPACK_IMPORTED_MODULE_1__["allowTemplateFromDomModule"])) {
      template = _elements_dom_module_js__WEBPACK_IMPORTED_MODULE_5__["DomModule"].import(is, 'template'); // Under strictTemplatePolicy, require any element with an `is`
      // specified to have a dom-module

      if (_utils_settings_js__WEBPACK_IMPORTED_MODULE_1__["strictTemplatePolicy"] && !template) {
        throw new Error(`strictTemplatePolicy: expecting dom-module or null template for ${is}`);
      }
    }

    return template;
  }
  /**
   * @polymer
   * @mixinClass
   * @unrestricted
   * @implements {Polymer_ElementMixin}
   */


  class PolymerElement extends polymerElementBase {
    /**
     * Current Polymer version in Semver notation.
     * @type {string} Semver notation of the current version of Polymer.
     */
    static get polymerElementVersion() {
      return version;
    }
    /**
     * Override of PropertiesMixin _finalizeClass to create observers and
     * find the template.
     * @return {void}
     * @protected
     * @override
     * @suppress {missingProperties} Interfaces in closure do not inherit statics, but classes do
     */


    static _finalizeClass() {
      super._finalizeClass();

      if (this.hasOwnProperty(JSCompiler_renameProperty('is', this)) && this.is) {
        register(this.prototype);
      }

      const observers = ownObservers(this);

      if (observers) {
        this.createObservers(observers, this._properties);
      } // note: create "working" template that is finalized at instance time


      let template =
      /** @type {PolymerElementConstructor} */
      this.template;

      if (template) {
        if (typeof template === 'string') {
          console.error('template getter must return HTMLTemplateElement');
          template = null;
        } else {
          template = template.cloneNode(true);
        }
      }

      this.prototype._template = template;
    }
    /**
     * Override of PropertiesChanged createProperties to create accessors
     * and property effects for all of the properties.
     * @return {void}
     * @protected
     * @override
     */


    static createProperties(props) {
      for (let p in props) {
        createPropertyFromConfig(this.prototype, p, props[p], props);
      }
    }
    /**
     * Creates observers for the given `observers` array.
     * Leverages `PropertyEffects` to create observers.
     * @param {Object} observers Array of observer descriptors for
     *   this class
     * @param {Object} dynamicFns Object containing keys for any properties
     *   that are functions and should trigger the effect when the function
     *   reference is changed
     * @return {void}
     * @protected
     */


    static createObservers(observers, dynamicFns) {
      const proto = this.prototype;

      for (let i = 0; i < observers.length; i++) {
        proto._createMethodObserver(observers[i], dynamicFns);
      }
    }
    /**
     * Returns the template that will be stamped into this element's shadow root.
     *
     * If a `static get is()` getter is defined, the default implementation
     * will return the first `<template>` in a `dom-module` whose `id`
     * matches this element's `is`.
     *
     * Users may override this getter to return an arbitrary template
     * (in which case the `is` getter is unnecessary). The template returned
     * must be an `HTMLTemplateElement`.
     *
     * Note that when subclassing, if the super class overrode the default
     * implementation and the subclass would like to provide an alternate
     * template via a `dom-module`, it should override this getter and
     * return `DomModule.import(this.is, 'template')`.
     *
     * If a subclass would like to modify the super class template, it should
     * clone it rather than modify it in place.  If the getter does expensive
     * work such as cloning/modifying a template, it should memoize the
     * template for maximum performance:
     *
     *   let memoizedTemplate;
     *   class MySubClass extends MySuperClass {
     *     static get template() {
     *       if (!memoizedTemplate) {
     *         memoizedTemplate = super.template.cloneNode(true);
     *         let subContent = document.createElement('div');
     *         subContent.textContent = 'This came from MySubClass';
     *         memoizedTemplate.content.appendChild(subContent);
     *       }
     *       return memoizedTemplate;
     *     }
     *   }
     *
     * @return {!HTMLTemplateElement|string} Template to be stamped
     */


    static get template() {
      // Explanation of template-related properties:
      // - constructor.template (this getter): the template for the class.
      //     This can come from the prototype (for legacy elements), from a
      //     dom-module, or from the super class's template (or can be overridden
      //     altogether by the user)
      // - constructor._template: memoized version of constructor.template
      // - prototype._template: working template for the element, which will be
      //     parsed and modified in place. It is a cloned version of
      //     constructor.template, saved in _finalizeClass(). Note that before
      //     this getter is called, for legacy elements this could be from a
      //     _template field on the info object passed to Polymer(), a behavior,
      //     or set in registered(); once the static getter runs, a clone of it
      //     will overwrite it on the prototype as the working template.
      if (!this.hasOwnProperty(JSCompiler_renameProperty('_template', this))) {
        this._template = // If user has put template on prototype (e.g. in legacy via registered
        // callback or info object), prefer that first
        this.prototype.hasOwnProperty(JSCompiler_renameProperty('_template', this.prototype)) ? this.prototype._template : // Look in dom-module associated with this element's is
        getTemplateFromDomModule(
        /** @type {PolymerElementConstructor}*/
        this.is) || // Next look for superclass template (call the super impl this
        // way so that `this` points to the superclass)
        Object.getPrototypeOf(
        /** @type {PolymerElementConstructor}*/
        this.prototype).constructor.template;
      }

      return this._template;
    }
    /**
     * Set the template.
     *
     * @param {!HTMLTemplateElement|string} value Template to set.
     */


    static set template(value) {
      this._template = value;
    }
    /**
     * Path matching the url from which the element was imported.
     *
     * This path is used to resolve url's in template style cssText.
     * The `importPath` property is also set on element instances and can be
     * used to create bindings relative to the import path.
     *
     * For elements defined in ES modules, users should implement
     * `static get importMeta() { return import.meta; }`, and the default
     * implementation of `importPath` will  return `import.meta.url`'s path.
     * For elements defined in HTML imports, this getter will return the path
     * to the document containing a `dom-module` element matching this
     * element's static `is` property.
     *
     * Note, this path should contain a trailing `/`.
     *
     * @return {string} The import path for this element class
     * @suppress {missingProperties}
     */


    static get importPath() {
      if (!this.hasOwnProperty(JSCompiler_renameProperty('_importPath', this))) {
        const meta = this.importMeta;

        if (meta) {
          this._importPath = Object(_utils_resolve_url_js__WEBPACK_IMPORTED_MODULE_4__["pathFromUrl"])(meta.url);
        } else {
          const module = _elements_dom_module_js__WEBPACK_IMPORTED_MODULE_5__["DomModule"].import(
          /** @type {PolymerElementConstructor} */
          this.is);
          this._importPath = module && module.assetpath || Object.getPrototypeOf(
          /** @type {PolymerElementConstructor}*/
          this.prototype).constructor.importPath;
        }
      }

      return this._importPath;
    }

    constructor() {
      super();
      /** @type {HTMLTemplateElement} */

      this._template;
      /** @type {string} */

      this._importPath;
      /** @type {string} */

      this.rootPath;
      /** @type {string} */

      this.importPath;
      /** @type {StampedTemplate | HTMLElement | ShadowRoot} */

      this.root;
      /** @type {!Object<string, !Element>} */

      this.$;
    }
    /**
     * Overrides the default `PropertyAccessors` to ensure class
     * metaprogramming related to property accessors and effects has
     * completed (calls `finalize`).
     *
     * It also initializes any property defaults provided via `value` in
     * `properties` metadata.
     *
     * @return {void}
     * @override
     * @suppress {invalidCasts}
     */


    _initializeProperties() {
      instanceCount++;
      this.constructor.finalize(); // note: finalize template when we have access to `localName` to
      // avoid dependence on `is` for polyfilling styling.

      this.constructor._finalizeTemplate(
      /** @type {!HTMLElement} */
      this.localName);

      super._initializeProperties(); // set path defaults


      this.rootPath = _utils_settings_js__WEBPACK_IMPORTED_MODULE_1__["rootPath"];
      this.importPath = this.constructor.importPath; // apply property defaults...

      let p$ = propertyDefaults(this.constructor);

      if (!p$) {
        return;
      }

      for (let p in p$) {
        let info = p$[p]; // Don't set default value if there is already an own property, which
        // happens when a `properties` property with default but no effects had
        // a property set (e.g. bound) by its host before upgrade

        if (!this.hasOwnProperty(p)) {
          let value = typeof info.value == 'function' ? info.value.call(this) : info.value; // Set via `_setProperty` if there is an accessor, to enable
          // initializing readOnly property defaults

          if (this._hasAccessor(p)) {
            this._setPendingProperty(p, value, true);
          } else {
            this[p] = value;
          }
        }
      }
    }
    /**
     * Gather style text for a style element in the template.
     *
     * @param {string} cssText Text containing styling to process
     * @param {string} baseURI Base URI to rebase CSS paths against
     * @return {string} The processed CSS text
     * @protected
     */


    static _processStyleText(cssText, baseURI) {
      return Object(_utils_resolve_url_js__WEBPACK_IMPORTED_MODULE_4__["resolveCss"])(cssText, baseURI);
    }
    /**
    * Configures an element `proto` to function with a given `template`.
    * The element name `is` and extends `ext` must be specified for ShadyCSS
    * style scoping.
    *
    * @param {string} is Tag name (or type extension name) for this element
    * @return {void}
    * @protected
    */


    static _finalizeTemplate(is) {
      /** @const {HTMLTemplateElement} */
      const template = this.prototype._template;

      if (template && !template.__polymerFinalized) {
        template.__polymerFinalized = true;
        const importPath = this.importPath;
        const baseURI = importPath ? Object(_utils_resolve_url_js__WEBPACK_IMPORTED_MODULE_4__["resolveUrl"])(importPath) : ''; // e.g. support `include="module-name"`, and ShadyCSS

        processElementStyles(this, template, is, baseURI);

        this.prototype._bindTemplate(template);
      }
    }
    /**
     * Provides a default implementation of the standard Custom Elements
     * `connectedCallback`.
     *
     * The default implementation enables the property effects system and
     * flushes any pending properties, and updates shimmed CSS properties
     * when using the ShadyCSS scoping/custom properties polyfill.
     *
     * @suppress {missingProperties, invalidCasts} Super may or may not implement the callback
     * @return {void}
     */


    connectedCallback() {
      if (window.ShadyCSS && this._template) {
        window.ShadyCSS.styleElement(
        /** @type {!HTMLElement} */
        this);
      }

      super.connectedCallback();
    }
    /**
     * Stamps the element template.
     *
     * @return {void}
     * @override
     */


    ready() {
      if (this._template) {
        this.root = this._stampTemplate(this._template);
        this.$ = this.root.$;
      }

      super.ready();
    }
    /**
     * Implements `PropertyEffects`'s `_readyClients` call. Attaches
     * element dom by calling `_attachDom` with the dom stamped from the
     * element's template via `_stampTemplate`. Note that this allows
     * client dom to be attached to the element prior to any observers
     * running.
     *
     * @return {void}
     * @override
     */


    _readyClients() {
      if (this._template) {
        this.root = this._attachDom(
        /** @type {StampedTemplate} */
        this.root);
      } // The super._readyClients here sets the clients initialized flag.
      // We must wait to do this until after client dom is created/attached
      // so that this flag can be checked to prevent notifications fired
      // during this process from being handled before clients are ready.


      super._readyClients();
    }
    /**
     * Attaches an element's stamped dom to itself. By default,
     * this method creates a `shadowRoot` and adds the dom to it.
     * However, this method may be overridden to allow an element
     * to put its dom in another location.
     *
     * @throws {Error}
     * @suppress {missingReturn}
     * @param {StampedTemplate} dom to attach to the element.
     * @return {ShadowRoot} node to which the dom has been attached.
     */


    _attachDom(dom) {
      if (this.attachShadow) {
        if (dom) {
          if (!this.shadowRoot) {
            this.attachShadow({
              mode: 'open'
            });
          }

          this.shadowRoot.appendChild(dom);
          return this.shadowRoot;
        }

        return null;
      } else {
        throw new Error('ShadowDOM not available. ' + // TODO(sorvell): move to compile-time conditional when supported
        'PolymerElement can create dom as children instead of in ' + 'ShadowDOM by setting `this.root = this;\` before \`ready\`.');
      }
    }
    /**
     * When using the ShadyCSS scoping and custom property shim, causes all
     * shimmed styles in this element (and its subtree) to be updated
     * based on current custom property values.
     *
     * The optional parameter overrides inline custom property styles with an
     * object of properties where the keys are CSS properties, and the values
     * are strings.
     *
     * Example: `this.updateStyles({'--color': 'blue'})`
     *
     * These properties are retained unless a value of `null` is set.
     *
     * Note: This function does not support updating CSS mixins.
     * You can not dynamically change the value of an `@apply`.
     *
     * @param {Object=} properties Bag of custom property key/values to
     *   apply to this element.
     * @return {void}
     * @suppress {invalidCasts}
     */


    updateStyles(properties) {
      if (window.ShadyCSS) {
        window.ShadyCSS.styleSubtree(
        /** @type {!HTMLElement} */
        this, properties);
      }
    }
    /**
     * Rewrites a given URL relative to a base URL. The base URL defaults to
     * the original location of the document containing the `dom-module` for
     * this element. This method will return the same URL before and after
     * bundling.
     *
     * Note that this function performs no resolution for URLs that start
     * with `/` (absolute URLs) or `#` (hash identifiers).  For general purpose
     * URL resolution, use `window.URL`.
     *
     * @param {string} url URL to resolve.
     * @param {string=} base Optional base URL to resolve against, defaults
     * to the element's `importPath`
     * @return {string} Rewritten URL relative to base
     */


    resolveUrl(url, base) {
      if (!base && this.importPath) {
        base = Object(_utils_resolve_url_js__WEBPACK_IMPORTED_MODULE_4__["resolveUrl"])(this.importPath);
      }

      return Object(_utils_resolve_url_js__WEBPACK_IMPORTED_MODULE_4__["resolveUrl"])(url, base);
    }
    /**
     * Overrides `PropertyAccessors` to add map of dynamic functions on
     * template info, for consumption by `PropertyEffects` template binding
     * code. This map determines which method templates should have accessors
     * created for them.
     *
     * @override
     * @suppress {missingProperties} Interfaces in closure do not inherit statics, but classes do
     */


    static _parseTemplateContent(template, templateInfo, nodeInfo) {
      templateInfo.dynamicFns = templateInfo.dynamicFns || this._properties;
      return super._parseTemplateContent(template, templateInfo, nodeInfo);
    }

  }

  return PolymerElement;
});
/**
 * Total number of Polymer element instances created.
 * @type {number}
 */

let instanceCount = 0;
/**
 * Array of Polymer element classes that have been finalized.
 * @type {Array<PolymerElement>}
 */

const registrations = [];
/**
 * @param {!PolymerElementConstructor} prototype Element prototype to log
 * @this {this}
 * @private
 */

function _regLog(prototype) {
  console.log('[' + prototype.is + ']: registered');
}
/**
 * Registers a class prototype for telemetry purposes.
 * @param {HTMLElement} prototype Element prototype to register
 * @this {this}
 * @protected
 */


function register(prototype) {
  registrations.push(prototype);
}
/**
 * Logs all elements registered with an `is` to the console.
 * @public
 * @this {this}
 */

function dumpRegistrations() {
  registrations.forEach(_regLog);
}
/**
 * When using the ShadyCSS scoping and custom property shim, causes all
 * shimmed `styles` (via `custom-style`) in the document (and its subtree)
 * to be updated based on current custom property values.
 *
 * The optional parameter overrides inline custom property styles with an
 * object of properties where the keys are CSS properties, and the values
 * are strings.
 *
 * Example: `updateStyles({'--color': 'blue'})`
 *
 * These properties are retained unless a value of `null` is set.
 *
 * @param {Object=} props Bag of custom property key/values to
 *   apply to the document.
 * @return {void}
 */

const updateStyles = function (props) {
  if (window.ShadyCSS) {
    window.ShadyCSS.styleDocument(props);
  }
};

/***/ }),

/***/ "./node_modules/@polymer/polymer/lib/mixins/gesture-event-listeners.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@polymer/polymer/lib/mixins/gesture-event-listeners.js ***!
  \*****************************************************************************/
/*! exports provided: GestureEventListeners */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "GestureEventListeners", function() { return GestureEventListeners; });
/* harmony import */ var _utils_boot_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/boot.js */ "./node_modules/@polymer/polymer/lib/utils/boot.js");
/* harmony import */ var _utils_mixin_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/mixin.js */ "./node_modules/@polymer/polymer/lib/utils/mixin.js");
/* harmony import */ var _utils_gestures_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/gestures.js */ "./node_modules/@polymer/polymer/lib/utils/gestures.js");
/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/



/**
 * Element class mixin that provides API for adding Polymer's cross-platform
 * gesture events to nodes.
 *
 * The API is designed to be compatible with override points implemented
 * in `TemplateStamp` such that declarative event listeners in
 * templates will support gesture events when this mixin is applied along with
 * `TemplateStamp`.
 *
 * @mixinFunction
 * @polymer
 * @summary Element class mixin that provides API for adding Polymer's
 *   cross-platform
 * gesture events to nodes
 */

const GestureEventListeners = Object(_utils_mixin_js__WEBPACK_IMPORTED_MODULE_1__["dedupingMixin"])(
/**
 * @template T
 * @param {function(new:T)} superClass Class to apply mixin to.
 * @return {function(new:T)} superClass with mixin applied.
 */
superClass => {
  /**
   * @polymer
   * @mixinClass
   * @implements {Polymer_GestureEventListeners}
   */
  class GestureEventListeners extends superClass {
    /**
     * Add the event listener to the node if it is a gestures event.
     *
     * @param {!EventTarget} node Node to add event listener to
     * @param {string} eventName Name of event
     * @param {function(!Event):void} handler Listener function to add
     * @return {void}
     * @override
     */
    _addEventListenerToNode(node, eventName, handler) {
      if (!Object(_utils_gestures_js__WEBPACK_IMPORTED_MODULE_2__["addListener"])(node, eventName, handler)) {
        super._addEventListenerToNode(node, eventName, handler);
      }
    }
    /**
     * Remove the event listener to the node if it is a gestures event.
     *
     * @param {!EventTarget} node Node to remove event listener from
     * @param {string} eventName Name of event
     * @param {function(!Event):void} handler Listener function to remove
     * @return {void}
     * @override
     */


    _removeEventListenerFromNode(node, eventName, handler) {
      if (!Object(_utils_gestures_js__WEBPACK_IMPORTED_MODULE_2__["removeListener"])(node, eventName, handler)) {
        super._removeEventListenerFromNode(node, eventName, handler);
      }
    }

  }

  return GestureEventListeners;
});

/***/ }),

/***/ "./node_modules/@polymer/polymer/lib/mixins/mutable-data.js":
/*!******************************************************************!*\
  !*** ./node_modules/@polymer/polymer/lib/mixins/mutable-data.js ***!
  \******************************************************************/
/*! exports provided: MutableData, OptionalMutableData */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "MutableData", function() { return MutableData; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "OptionalMutableData", function() { return OptionalMutableData; });
/* harmony import */ var _utils_mixin_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/mixin.js */ "./node_modules/@polymer/polymer/lib/utils/mixin.js");
/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/
 // Common implementation for mixin & behavior

function mutablePropertyChange(inst, property, value, old, mutableData) {
  let isObject;

  if (mutableData) {
    isObject = typeof value === 'object' && value !== null; // Pull `old` for Objects from temp cache, but treat `null` as a primitive

    if (isObject) {
      old = inst.__dataTemp[property];
    }
  } // Strict equality check, but return false for NaN===NaN


  let shouldChange = old !== value && (old === old || value === value); // Objects are stored in temporary cache (cleared at end of
  // turn), which is used for dirty-checking

  if (isObject && shouldChange) {
    inst.__dataTemp[property] = value;
  }

  return shouldChange;
}
/**
 * Element class mixin to skip strict dirty-checking for objects and arrays
 * (always consider them to be "dirty"), for use on elements utilizing
 * `PropertyEffects`
 *
 * By default, `PropertyEffects` performs strict dirty checking on
 * objects, which means that any deep modifications to an object or array will
 * not be propagated unless "immutable" data patterns are used (i.e. all object
 * references from the root to the mutation were changed).
 *
 * Polymer also provides a proprietary data mutation and path notification API
 * (e.g. `notifyPath`, `set`, and array mutation API's) that allow efficient
 * mutation and notification of deep changes in an object graph to all elements
 * bound to the same object graph.
 *
 * In cases where neither immutable patterns nor the data mutation API can be
 * used, applying this mixin will cause Polymer to skip dirty checking for
 * objects and arrays (always consider them to be "dirty").  This allows a
 * user to make a deep modification to a bound object graph, and then either
 * simply re-set the object (e.g. `this.items = this.items`) or call `notifyPath`
 * (e.g. `this.notifyPath('items')`) to update the tree.  Note that all
 * elements that wish to be updated based on deep mutations must apply this
 * mixin or otherwise skip strict dirty checking for objects/arrays.
 * Specifically, any elements in the binding tree between the source of a
 * mutation and the consumption of it must apply this mixin or enable the
 * `OptionalMutableData` mixin.
 *
 * In order to make the dirty check strategy configurable, see
 * `OptionalMutableData`.
 *
 * Note, the performance characteristics of propagating large object graphs
 * will be worse as opposed to using strict dirty checking with immutable
 * patterns or Polymer's path notification API.
 *
 * @mixinFunction
 * @polymer
 * @summary Element class mixin to skip strict dirty-checking for objects
 *   and arrays
 */


const MutableData = Object(_utils_mixin_js__WEBPACK_IMPORTED_MODULE_0__["dedupingMixin"])(superClass => {
  /**
   * @polymer
   * @mixinClass
   * @implements {Polymer_MutableData}
   */
  class MutableData extends superClass {
    /**
     * Overrides `PropertyEffects` to provide option for skipping
     * strict equality checking for Objects and Arrays.
     *
     * This method pulls the value to dirty check against from the `__dataTemp`
     * cache (rather than the normal `__data` cache) for Objects.  Since the temp
     * cache is cleared at the end of a turn, this implementation allows
     * side-effects of deep object changes to be processed by re-setting the
     * same object (using the temp cache as an in-turn backstop to prevent
     * cycles due to 2-way notification).
     *
     * @param {string} property Property name
     * @param {*} value New property value
     * @param {*} old Previous property value
     * @return {boolean} Whether the property should be considered a change
     * @protected
     */
    _shouldPropertyChange(property, value, old) {
      return mutablePropertyChange(this, property, value, old, true);
    }

  }

  return MutableData;
});
/**
 * Element class mixin to add the optional ability to skip strict
 * dirty-checking for objects and arrays (always consider them to be
 * "dirty") by setting a `mutable-data` attribute on an element instance.
 *
 * By default, `PropertyEffects` performs strict dirty checking on
 * objects, which means that any deep modifications to an object or array will
 * not be propagated unless "immutable" data patterns are used (i.e. all object
 * references from the root to the mutation were changed).
 *
 * Polymer also provides a proprietary data mutation and path notification API
 * (e.g. `notifyPath`, `set`, and array mutation API's) that allow efficient
 * mutation and notification of deep changes in an object graph to all elements
 * bound to the same object graph.
 *
 * In cases where neither immutable patterns nor the data mutation API can be
 * used, applying this mixin will allow Polymer to skip dirty checking for
 * objects and arrays (always consider them to be "dirty").  This allows a
 * user to make a deep modification to a bound object graph, and then either
 * simply re-set the object (e.g. `this.items = this.items`) or call `notifyPath`
 * (e.g. `this.notifyPath('items')`) to update the tree.  Note that all
 * elements that wish to be updated based on deep mutations must apply this
 * mixin or otherwise skip strict dirty checking for objects/arrays.
 * Specifically, any elements in the binding tree between the source of a
 * mutation and the consumption of it must enable this mixin or apply the
 * `MutableData` mixin.
 *
 * While this mixin adds the ability to forgo Object/Array dirty checking,
 * the `mutableData` flag defaults to false and must be set on the instance.
 *
 * Note, the performance characteristics of propagating large object graphs
 * will be worse by relying on `mutableData: true` as opposed to using
 * strict dirty checking with immutable patterns or Polymer's path notification
 * API.
 *
 * @mixinFunction
 * @polymer
 * @summary Element class mixin to optionally skip strict dirty-checking
 *   for objects and arrays
 */

const OptionalMutableData = Object(_utils_mixin_js__WEBPACK_IMPORTED_MODULE_0__["dedupingMixin"])(superClass => {
  /**
   * @mixinClass
   * @polymer
   * @implements {Polymer_OptionalMutableData}
   */
  class OptionalMutableData extends superClass {
    static get properties() {
      return {
        /**
         * Instance-level flag for configuring the dirty-checking strategy
         * for this element.  When true, Objects and Arrays will skip dirty
         * checking, otherwise strict equality checking will be used.
         */
        mutableData: Boolean
      };
    }
    /**
     * Overrides `PropertyEffects` to provide option for skipping
     * strict equality checking for Objects and Arrays.
     *
     * When `this.mutableData` is true on this instance, this method
     * pulls the value to dirty check against from the `__dataTemp` cache
     * (rather than the normal `__data` cache) for Objects.  Since the temp
     * cache is cleared at the end of a turn, this implementation allows
     * side-effects of deep object changes to be processed by re-setting the
     * same object (using the temp cache as an in-turn backstop to prevent
     * cycles due to 2-way notification).
     *
     * @param {string} property Property name
     * @param {*} value New property value
     * @param {*} old Previous property value
     * @return {boolean} Whether the property should be considered a change
     * @protected
     */


    _shouldPropertyChange(property, value, old) {
      return mutablePropertyChange(this, property, value, old, this.mutableData);
    }

  }

  return OptionalMutableData;
}); // Export for use by legacy behavior

MutableData._mutablePropertyChange = mutablePropertyChange;

/***/ }),

/***/ "./node_modules/@polymer/polymer/lib/mixins/properties-changed.js":
/*!************************************************************************!*\
  !*** ./node_modules/@polymer/polymer/lib/mixins/properties-changed.js ***!
  \************************************************************************/
/*! exports provided: PropertiesChanged */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PropertiesChanged", function() { return PropertiesChanged; });
/* harmony import */ var _utils_boot_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/boot.js */ "./node_modules/@polymer/polymer/lib/utils/boot.js");
/* harmony import */ var _utils_mixin_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/mixin.js */ "./node_modules/@polymer/polymer/lib/utils/mixin.js");
/* harmony import */ var _utils_async_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/async.js */ "./node_modules/@polymer/polymer/lib/utils/async.js");
/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/



/** @const {!AsyncInterface} */

const microtask = _utils_async_js__WEBPACK_IMPORTED_MODULE_2__["microTask"];
/**
 * Element class mixin that provides basic meta-programming for creating one
 * or more property accessors (getter/setter pair) that enqueue an async
 * (batched) `_propertiesChanged` callback.
 *
 * For basic usage of this mixin, call `MyClass.createProperties(props)`
 * once at class definition time to create property accessors for properties
 * named in props, implement `_propertiesChanged` to react as desired to
 * property changes, and implement `static get observedAttributes()` and
 * include lowercase versions of any property names that should be set from
 * attributes. Last, call `this._enableProperties()` in the element's
 * `connectedCallback` to enable the accessors.
 *
 * @mixinFunction
 * @polymer
 * @summary Element class mixin for reacting to property changes from
 *   generated property accessors.
 */

const PropertiesChanged = Object(_utils_mixin_js__WEBPACK_IMPORTED_MODULE_1__["dedupingMixin"])(
/**
 * @template T
 * @param {function(new:T)} superClass Class to apply mixin to.
 * @return {function(new:T)} superClass with mixin applied.
 */
superClass => {
  /**
   * @polymer
   * @mixinClass
   * @implements {Polymer_PropertiesChanged}
   * @unrestricted
   */
  class PropertiesChanged extends superClass {
    /**
     * Creates property accessors for the given property names.
     * @param {!Object} props Object whose keys are names of accessors.
     * @return {void}
     * @protected
     */
    static createProperties(props) {
      const proto = this.prototype;

      for (let prop in props) {
        // don't stomp an existing accessor
        if (!(prop in proto)) {
          proto._createPropertyAccessor(prop);
        }
      }
    }
    /**
     * Returns an attribute name that corresponds to the given property.
     * The attribute name is the lowercased property name. Override to
     * customize this mapping.
     * @param {string} property Property to convert
     * @return {string} Attribute name corresponding to the given property.
     *
     * @protected
     */


    static attributeNameForProperty(property) {
      return property.toLowerCase();
    }
    /**
     * Override point to provide a type to which to deserialize a value to
     * a given property.
     * @param {string} name Name of property
     *
     * @protected
     */


    static typeForProperty(name) {} //eslint-disable-line no-unused-vars

    /**
     * Creates a setter/getter pair for the named property with its own
     * local storage.  The getter returns the value in the local storage,
     * and the setter calls `_setProperty`, which updates the local storage
     * for the property and enqueues a `_propertiesChanged` callback.
     *
     * This method may be called on a prototype or an instance.  Calling
     * this method may overwrite a property value that already exists on
     * the prototype/instance by creating the accessor.
     *
     * @param {string} property Name of the property
     * @param {boolean=} readOnly When true, no setter is created; the
     *   protected `_setProperty` function must be used to set the property
     * @return {void}
     * @protected
     * @override
     */


    _createPropertyAccessor(property, readOnly) {
      this._addPropertyToAttributeMap(property);

      if (!this.hasOwnProperty('__dataHasAccessor')) {
        this.__dataHasAccessor = Object.assign({}, this.__dataHasAccessor);
      }

      if (!this.__dataHasAccessor[property]) {
        this.__dataHasAccessor[property] = true;

        this._definePropertyAccessor(property, readOnly);
      }
    }
    /**
     * Adds the given `property` to a map matching attribute names
     * to property names, using `attributeNameForProperty`. This map is
     * used when deserializing attribute values to properties.
     *
     * @param {string} property Name of the property
     * @override
     */


    _addPropertyToAttributeMap(property) {
      if (!this.hasOwnProperty('__dataAttributes')) {
        this.__dataAttributes = Object.assign({}, this.__dataAttributes);
      }

      if (!this.__dataAttributes[property]) {
        const attr = this.constructor.attributeNameForProperty(property);
        this.__dataAttributes[attr] = property;
      }
    }
    /**
     * Defines a property accessor for the given property.
     * @param {string} property Name of the property
     * @param {boolean=} readOnly When true, no setter is created
     * @return {void}
     * @override
     */


    _definePropertyAccessor(property, readOnly) {
      Object.defineProperty(this, property, {
        /* eslint-disable valid-jsdoc */

        /** @this {PropertiesChanged} */
        get() {
          return this._getProperty(property);
        },

        /** @this {PropertiesChanged} */
        set: readOnly ? function () {} : function (value) {
          this._setProperty(property, value);
        }
        /* eslint-enable */

      });
    }

    constructor() {
      super();
      this.__dataEnabled = false;
      this.__dataReady = false;
      this.__dataInvalid = false;
      this.__data = {};
      this.__dataPending = null;
      this.__dataOld = null;
      this.__dataInstanceProps = null;
      this.__serializing = false;

      this._initializeProperties();
    }
    /**
     * Lifecycle callback called when properties are enabled via
     * `_enableProperties`.
     *
     * Users may override this function to implement behavior that is
     * dependent on the element having its property data initialized, e.g.
     * from defaults (initialized from `constructor`, `_initializeProperties`),
     * `attributeChangedCallback`, or values propagated from host e.g. via
     * bindings.  `super.ready()` must be called to ensure the data system
     * becomes enabled.
     *
     * @return {void}
     * @public
     * @override
     */


    ready() {
      this.__dataReady = true;

      this._flushProperties();
    }
    /**
     * Initializes the local storage for property accessors.
     *
     * Provided as an override point for performing any setup work prior
     * to initializing the property accessor system.
     *
     * @return {void}
     * @protected
     * @override
     */


    _initializeProperties() {
      // Capture instance properties; these will be set into accessors
      // during first flush. Don't set them here, since we want
      // these to overwrite defaults/constructor assignments
      for (let p in this.__dataHasAccessor) {
        if (this.hasOwnProperty(p)) {
          this.__dataInstanceProps = this.__dataInstanceProps || {};
          this.__dataInstanceProps[p] = this[p];
          delete this[p];
        }
      }
    }
    /**
     * Called at ready time with bag of instance properties that overwrote
     * accessors when the element upgraded.
     *
     * The default implementation sets these properties back into the
     * setter at ready time.  This method is provided as an override
     * point for customizing or providing more efficient initialization.
     *
     * @param {Object} props Bag of property values that were overwritten
     *   when creating property accessors.
     * @return {void}
     * @protected
     * @override
     */


    _initializeInstanceProperties(props) {
      Object.assign(this, props);
    }
    /**
     * Updates the local storage for a property (via `_setPendingProperty`)
     * and enqueues a `_proeprtiesChanged` callback.
     *
     * @param {string} property Name of the property
     * @param {*} value Value to set
     * @return {void}
     * @protected
     * @override
     */


    _setProperty(property, value) {
      if (this._setPendingProperty(property, value)) {
        this._invalidateProperties();
      }
    }
    /**
     * Returns the value for the given property.
     * @param {string} property Name of property
     * @return {*} Value for the given property
     * @protected
     * @override
     */


    _getProperty(property) {
      return this.__data[property];
    }
    /* eslint-disable no-unused-vars */

    /**
     * Updates the local storage for a property, records the previous value,
     * and adds it to the set of "pending changes" that will be passed to the
     * `_propertiesChanged` callback.  This method does not enqueue the
     * `_propertiesChanged` callback.
     *
     * @param {string} property Name of the property
     * @param {*} value Value to set
     * @param {boolean=} ext Not used here; affordance for closure
     * @return {boolean} Returns true if the property changed
     * @protected
     * @override
     */


    _setPendingProperty(property, value, ext) {
      let old = this.__data[property];

      let changed = this._shouldPropertyChange(property, value, old);

      if (changed) {
        if (!this.__dataPending) {
          this.__dataPending = {};
          this.__dataOld = {};
        } // Ensure old is captured from the last turn


        if (this.__dataOld && !(property in this.__dataOld)) {
          this.__dataOld[property] = old;
        }

        this.__data[property] = value;
        this.__dataPending[property] = value;
      }

      return changed;
    }
    /* eslint-enable */

    /**
     * Marks the properties as invalid, and enqueues an async
     * `_propertiesChanged` callback.
     *
     * @return {void}
     * @protected
     * @override
     */


    _invalidateProperties() {
      if (!this.__dataInvalid && this.__dataReady) {
        this.__dataInvalid = true;
        microtask.run(() => {
          if (this.__dataInvalid) {
            this.__dataInvalid = false;

            this._flushProperties();
          }
        });
      }
    }
    /**
     * Call to enable property accessor processing. Before this method is
     * called accessor values will be set but side effects are
     * queued. When called, any pending side effects occur immediately.
     * For elements, generally `connectedCallback` is a normal spot to do so.
     * It is safe to call this method multiple times as it only turns on
     * property accessors once.
     *
     * @return {void}
     * @protected
     * @override
     */


    _enableProperties() {
      if (!this.__dataEnabled) {
        this.__dataEnabled = true;

        if (this.__dataInstanceProps) {
          this._initializeInstanceProperties(this.__dataInstanceProps);

          this.__dataInstanceProps = null;
        }

        this.ready();
      }
    }
    /**
     * Calls the `_propertiesChanged` callback with the current set of
     * pending changes (and old values recorded when pending changes were
     * set), and resets the pending set of changes. Generally, this method
     * should not be called in user code.
     *
     * @return {void}
     * @protected
     * @override
     */


    _flushProperties() {
      const props = this.__data;
      const changedProps = this.__dataPending;
      const old = this.__dataOld;

      if (this._shouldPropertiesChange(props, changedProps, old)) {
        this.__dataPending = null;
        this.__dataOld = null;

        this._propertiesChanged(props, changedProps, old);
      }
    }
    /**
     * Called in `_flushProperties` to determine if `_propertiesChanged`
     * should be called. The default implementation returns true if
     * properties are pending. Override to customize when
     * `_propertiesChanged` is called.
     * @param {!Object} currentProps Bag of all current accessor values
     * @param {?Object} changedProps Bag of properties changed since the last
     *   call to `_propertiesChanged`
     * @param {?Object} oldProps Bag of previous values for each property
     *   in `changedProps`
     * @return {boolean} true if changedProps is truthy
     * @override
     */


    _shouldPropertiesChange(currentProps, changedProps, oldProps) {
      // eslint-disable-line no-unused-vars
      return Boolean(changedProps);
    }
    /**
     * Callback called when any properties with accessors created via
     * `_createPropertyAccessor` have been set.
     *
     * @param {!Object} currentProps Bag of all current accessor values
     * @param {?Object} changedProps Bag of properties changed since the last
     *   call to `_propertiesChanged`
     * @param {?Object} oldProps Bag of previous values for each property
     *   in `changedProps`
     * @return {void}
     * @protected
     * @override
     */


    _propertiesChanged(currentProps, changedProps, oldProps) {} // eslint-disable-line no-unused-vars

    /**
     * Method called to determine whether a property value should be
     * considered as a change and cause the `_propertiesChanged` callback
     * to be enqueued.
     *
     * The default implementation returns `true` if a strict equality
     * check fails. The method always returns false for `NaN`.
     *
     * Override this method to e.g. provide stricter checking for
     * Objects/Arrays when using immutable patterns.
     *
     * @param {string} property Property name
     * @param {*} value New property value
     * @param {*} old Previous property value
     * @return {boolean} Whether the property should be considered a change
     *   and enqueue a `_proeprtiesChanged` callback
     * @protected
     * @override
     */


    _shouldPropertyChange(property, value, old) {
      return (// Strict equality check
        old !== value && ( // This ensures (old==NaN, value==NaN) always returns false
        old === old || value === value)
      );
    }
    /**
     * Implements native Custom Elements `attributeChangedCallback` to
     * set an attribute value to a property via `_attributeToProperty`.
     *
     * @param {string} name Name of attribute that changed
     * @param {?string} old Old attribute value
     * @param {?string} value New attribute value
     * @param {?string} namespace Attribute namespace.
     * @return {void}
     * @suppress {missingProperties} Super may or may not implement the callback
     * @override
     */


    attributeChangedCallback(name, old, value, namespace) {
      if (old !== value) {
        this._attributeToProperty(name, value);
      }

      if (super.attributeChangedCallback) {
        super.attributeChangedCallback(name, old, value, namespace);
      }
    }
    /**
     * Deserializes an attribute to its associated property.
     *
     * This method calls the `_deserializeValue` method to convert the string to
     * a typed value.
     *
     * @param {string} attribute Name of attribute to deserialize.
     * @param {?string} value of the attribute.
     * @param {*=} type type to deserialize to, defaults to the value
     * returned from `typeForProperty`
     * @return {void}
     * @override
     */


    _attributeToProperty(attribute, value, type) {
      if (!this.__serializing) {
        const map = this.__dataAttributes;
        const property = map && map[attribute] || attribute;
        this[property] = this._deserializeValue(value, type || this.constructor.typeForProperty(property));
      }
    }
    /**
     * Serializes a property to its associated attribute.
     *
     * @suppress {invalidCasts} Closure can't figure out `this` is an element.
     *
     * @param {string} property Property name to reflect.
     * @param {string=} attribute Attribute name to reflect to.
     * @param {*=} value Property value to refect.
     * @return {void}
     * @override
     */


    _propertyToAttribute(property, attribute, value) {
      this.__serializing = true;
      value = arguments.length < 3 ? this[property] : value;

      this._valueToNodeAttribute(
      /** @type {!HTMLElement} */
      this, value, attribute || this.constructor.attributeNameForProperty(property));

      this.__serializing = false;
    }
    /**
     * Sets a typed value to an HTML attribute on a node.
     *
     * This method calls the `_serializeValue` method to convert the typed
     * value to a string.  If the `_serializeValue` method returns `undefined`,
     * the attribute will be removed (this is the default for boolean
     * type `false`).
     *
     * @param {Element} node Element to set attribute to.
     * @param {*} value Value to serialize.
     * @param {string} attribute Attribute name to serialize to.
     * @return {void}
     * @override
     */


    _valueToNodeAttribute(node, value, attribute) {
      const str = this._serializeValue(value);

      if (str === undefined) {
        node.removeAttribute(attribute);
      } else {
        node.setAttribute(attribute, str);
      }
    }
    /**
     * Converts a typed JavaScript value to a string.
     *
     * This method is called when setting JS property values to
     * HTML attributes.  Users may override this method to provide
     * serialization for custom types.
     *
     * @param {*} value Property value to serialize.
     * @return {string | undefined} String serialized from the provided
     * property  value.
     * @override
     */


    _serializeValue(value) {
      switch (typeof value) {
        case 'boolean':
          return value ? '' : undefined;

        default:
          return value != null ? value.toString() : undefined;
      }
    }
    /**
     * Converts a string to a typed JavaScript value.
     *
     * This method is called when reading HTML attribute values to
     * JS properties.  Users may override this method to provide
     * deserialization for custom `type`s. Types for `Boolean`, `String`,
     * and `Number` convert attributes to the expected types.
     *
     * @param {?string} value Value to deserialize.
     * @param {*=} type Type to deserialize the string to.
     * @return {*} Typed value deserialized from the provided string.
     * @override
     */


    _deserializeValue(value, type) {
      switch (type) {
        case Boolean:
          return value !== null;

        case Number:
          return Number(value);

        default:
          return value;
      }
    }

  }

  return PropertiesChanged;
});

/***/ }),

/***/ "./node_modules/@polymer/polymer/lib/mixins/properties-mixin.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@polymer/polymer/lib/mixins/properties-mixin.js ***!
  \**********************************************************************/
/*! exports provided: PropertiesMixin */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PropertiesMixin", function() { return PropertiesMixin; });
/* harmony import */ var _utils_boot_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/boot.js */ "./node_modules/@polymer/polymer/lib/utils/boot.js");
/* harmony import */ var _utils_mixin_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/mixin.js */ "./node_modules/@polymer/polymer/lib/utils/mixin.js");
/* harmony import */ var _properties_changed_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./properties-changed.js */ "./node_modules/@polymer/polymer/lib/mixins/properties-changed.js");
/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/



/**
 * Creates a copy of `props` with each property normalized such that
 * upgraded it is an object with at least a type property { type: Type}.
 *
 * @param {Object} props Properties to normalize
 * @return {Object} Copy of input `props` with normalized properties that
 * are in the form {type: Type}
 * @private
 */

function normalizeProperties(props) {
  const output = {};

  for (let p in props) {
    const o = props[p];
    output[p] = typeof o === 'function' ? {
      type: o
    } : o;
  }

  return output;
}
/**
 * Mixin that provides a minimal starting point to using the PropertiesChanged
 * mixin by providing a mechanism to declare properties in a static
 * getter (e.g. static get properties() { return { foo: String } }). Changes
 * are reported via the `_propertiesChanged` method.
 *
 * This mixin provides no specific support for rendering. Users are expected
 * to create a ShadowRoot and put content into it and update it in whatever
 * way makes sense. This can be done in reaction to properties changing by
 * implementing `_propertiesChanged`.
 *
 * @mixinFunction
 * @polymer
 * @appliesMixin PropertiesChanged
 * @summary Mixin that provides a minimal starting point for using
 * the PropertiesChanged mixin by providing a declarative `properties` object.
 */


const PropertiesMixin = Object(_utils_mixin_js__WEBPACK_IMPORTED_MODULE_1__["dedupingMixin"])(superClass => {
  /**
   * @constructor
   * @implements {Polymer_PropertiesChanged}
   * @private
   */
  const base = Object(_properties_changed_js__WEBPACK_IMPORTED_MODULE_2__["PropertiesChanged"])(superClass);
  /**
   * Returns the super class constructor for the given class, if it is an
   * instance of the PropertiesMixin.
   *
   * @param {!PropertiesMixinConstructor} constructor PropertiesMixin constructor
   * @return {?PropertiesMixinConstructor} Super class constructor
   */

  function superPropertiesClass(constructor) {
    const superCtor = Object.getPrototypeOf(constructor); // Note, the `PropertiesMixin` class below only refers to the class
    // generated by this call to the mixin; the instanceof test only works
    // because the mixin is deduped and guaranteed only to apply once, hence
    // all constructors in a proto chain will see the same `PropertiesMixin`

    return superCtor.prototype instanceof PropertiesMixin ?
    /** @type {!PropertiesMixinConstructor} */
    superCtor : null;
  }
  /**
   * Returns a memoized version of the `properties` object for the
   * given class. Properties not in object format are converted to at
   * least {type}.
   *
   * @param {PropertiesMixinConstructor} constructor PropertiesMixin constructor
   * @return {Object} Memoized properties object
   */


  function ownProperties(constructor) {
    if (!constructor.hasOwnProperty(JSCompiler_renameProperty('__ownProperties', constructor))) {
      let props = null;

      if (constructor.hasOwnProperty(JSCompiler_renameProperty('properties', constructor))) {
        const properties = constructor.properties;

        if (properties) {
          props = normalizeProperties(properties);
        }
      }

      constructor.__ownProperties = props;
    }

    return constructor.__ownProperties;
  }
  /**
   * @polymer
   * @mixinClass
   * @extends {base}
   * @implements {Polymer_PropertiesMixin}
   * @unrestricted
   */


  class PropertiesMixin extends base {
    /**
     * Implements standard custom elements getter to observes the attributes
     * listed in `properties`.
     * @suppress {missingProperties} Interfaces in closure do not inherit statics, but classes do
     */
    static get observedAttributes() {
      const props = this._properties;
      return props ? Object.keys(props).map(p => this.attributeNameForProperty(p)) : [];
    }
    /**
     * Finalizes an element definition, including ensuring any super classes
     * are also finalized. This includes ensuring property
     * accessors exist on the element prototype. This method calls
     * `_finalizeClass` to finalize each constructor in the prototype chain.
     * @return {void}
     */


    static finalize() {
      if (!this.hasOwnProperty(JSCompiler_renameProperty('__finalized', this))) {
        const superCtor = superPropertiesClass(
        /** @type {!PropertiesMixinConstructor} */
        this);

        if (superCtor) {
          superCtor.finalize();
        }

        this.__finalized = true;

        this._finalizeClass();
      }
    }
    /**
     * Finalize an element class. This includes ensuring property
     * accessors exist on the element prototype. This method is called by
     * `finalize` and finalizes the class constructor.
     *
     * @protected
     */


    static _finalizeClass() {
      const props = ownProperties(
      /** @type {!PropertiesMixinConstructor} */
      this);

      if (props) {
        this.createProperties(props);
      }
    }
    /**
     * Returns a memoized version of all properties, including those inherited
     * from super classes. Properties not in object format are converted to
     * at least {type}.
     *
     * @return {Object} Object containing properties for this class
     * @protected
     */


    static get _properties() {
      if (!this.hasOwnProperty(JSCompiler_renameProperty('__properties', this))) {
        const superCtor = superPropertiesClass(
        /** @type {!PropertiesMixinConstructor} */
        this);
        this.__properties = Object.assign({}, superCtor && superCtor._properties, ownProperties(
        /** @type {PropertiesMixinConstructor} */
        this));
      }

      return this.__properties;
    }
    /**
     * Overrides `PropertiesChanged` method to return type specified in the
     * static `properties` object for the given property.
     * @param {string} name Name of property
     * @return {*} Type to which to deserialize attribute
     *
     * @protected
     */


    static typeForProperty(name) {
      const info = this._properties[name];
      return info && info.type;
    }
    /**
     * Overrides `PropertiesChanged` method and adds a call to
     * `finalize` which lazily configures the element's property accessors.
     * @override
     * @return {void}
     */


    _initializeProperties() {
      this.constructor.finalize();

      super._initializeProperties();
    }
    /**
     * Called when the element is added to a document.
     * Calls `_enableProperties` to turn on property system from
     * `PropertiesChanged`.
     * @suppress {missingProperties} Super may or may not implement the callback
     * @return {void}
     * @override
     */


    connectedCallback() {
      if (super.connectedCallback) {
        super.connectedCallback();
      }

      this._enableProperties();
    }
    /**
     * Called when the element is removed from a document
     * @suppress {missingProperties} Super may or may not implement the callback
     * @return {void}
     * @override
     */


    disconnectedCallback() {
      if (super.disconnectedCallback) {
        super.disconnectedCallback();
      }
    }

  }

  return PropertiesMixin;
});

/***/ }),

/***/ "./node_modules/@polymer/polymer/lib/mixins/property-accessors.js":
/*!************************************************************************!*\
  !*** ./node_modules/@polymer/polymer/lib/mixins/property-accessors.js ***!
  \************************************************************************/
/*! exports provided: PropertyAccessors */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PropertyAccessors", function() { return PropertyAccessors; });
/* harmony import */ var _utils_boot_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/boot.js */ "./node_modules/@polymer/polymer/lib/utils/boot.js");
/* harmony import */ var _utils_mixin_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/mixin.js */ "./node_modules/@polymer/polymer/lib/utils/mixin.js");
/* harmony import */ var _utils_case_map_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/case-map.js */ "./node_modules/@polymer/polymer/lib/utils/case-map.js");
/* harmony import */ var _properties_changed_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./properties-changed.js */ "./node_modules/@polymer/polymer/lib/mixins/properties-changed.js");
/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/



 // Save map of native properties; this forms a blacklist or properties
// that won't have their values "saved" by `saveAccessorValue`, since
// reading from an HTMLElement accessor from the context of a prototype throws

const nativeProperties = {};
let proto = HTMLElement.prototype;

while (proto) {
  let props = Object.getOwnPropertyNames(proto);

  for (let i = 0; i < props.length; i++) {
    nativeProperties[props[i]] = true;
  }

  proto = Object.getPrototypeOf(proto);
}
/**
 * Used to save the value of a property that will be overridden with
 * an accessor. If the `model` is a prototype, the values will be saved
 * in `__dataProto`, and it's up to the user (or downstream mixin) to
 * decide how/when to set these values back into the accessors.
 * If `model` is already an instance (it has a `__data` property), then
 * the value will be set as a pending property, meaning the user should
 * call `_invalidateProperties` or `_flushProperties` to take effect
 *
 * @param {Object} model Prototype or instance
 * @param {string} property Name of property
 * @return {void}
 * @private
 */


function saveAccessorValue(model, property) {
  // Don't read/store value for any native properties since they could throw
  if (!nativeProperties[property]) {
    let value = model[property];

    if (value !== undefined) {
      if (model.__data) {
        // Adding accessor to instance; update the property
        // It is the user's responsibility to call _flushProperties
        model._setPendingProperty(property, value);
      } else {
        // Adding accessor to proto; save proto's value for instance-time use
        if (!model.__dataProto) {
          model.__dataProto = {};
        } else if (!model.hasOwnProperty(JSCompiler_renameProperty('__dataProto', model))) {
          model.__dataProto = Object.create(model.__dataProto);
        }

        model.__dataProto[property] = value;
      }
    }
  }
}
/**
 * Element class mixin that provides basic meta-programming for creating one
 * or more property accessors (getter/setter pair) that enqueue an async
 * (batched) `_propertiesChanged` callback.
 *
 * For basic usage of this mixin:
 *
 * -   Declare attributes to observe via the standard `static get observedAttributes()`. Use
 *     `dash-case` attribute names to represent `camelCase` property names.
 * -   Implement the `_propertiesChanged` callback on the class.
 * -   Call `MyClass.createPropertiesForAttributes()` **once** on the class to generate
 *     property accessors for each observed attribute. This must be called before the first
 *     instance is created, for example, by calling it before calling `customElements.define`.
 *     It can also be called lazily from the element's `constructor`, as long as it's guarded so
 *     that the call is only made once, when the first instance is created.
 * -   Call `this._enableProperties()` in the element's `connectedCallback` to enable
 *     the accessors.
 *
 * Any `observedAttributes` will automatically be
 * deserialized via `attributeChangedCallback` and set to the associated
 * property using `dash-case`-to-`camelCase` convention.
 *
 * @mixinFunction
 * @polymer
 * @appliesMixin PropertiesChanged
 * @summary Element class mixin for reacting to property changes from
 *   generated property accessors.
 */


const PropertyAccessors = Object(_utils_mixin_js__WEBPACK_IMPORTED_MODULE_1__["dedupingMixin"])(superClass => {
  /**
   * @constructor
   * @extends {superClass}
   * @implements {Polymer_PropertiesChanged}
   * @unrestricted
   * @private
   */
  const base = Object(_properties_changed_js__WEBPACK_IMPORTED_MODULE_3__["PropertiesChanged"])(superClass);
  /**
   * @polymer
   * @mixinClass
   * @implements {Polymer_PropertyAccessors}
   * @extends {base}
   * @unrestricted
   */

  class PropertyAccessors extends base {
    /**
     * Generates property accessors for all attributes in the standard
     * static `observedAttributes` array.
     *
     * Attribute names are mapped to property names using the `dash-case` to
     * `camelCase` convention
     *
     * @return {void}
     */
    static createPropertiesForAttributes() {
      let a$ = this.observedAttributes;

      for (let i = 0; i < a$.length; i++) {
        this.prototype._createPropertyAccessor(Object(_utils_case_map_js__WEBPACK_IMPORTED_MODULE_2__["dashToCamelCase"])(a$[i]));
      }
    }
    /**
     * Returns an attribute name that corresponds to the given property.
     * By default, converts camel to dash case, e.g. `fooBar` to `foo-bar`.
     * @param {string} property Property to convert
     * @return {string} Attribute name corresponding to the given property.
     *
     * @protected
     */


    static attributeNameForProperty(property) {
      return Object(_utils_case_map_js__WEBPACK_IMPORTED_MODULE_2__["camelToDashCase"])(property);
    }
    /**
     * Overrides PropertiesChanged implementation to initialize values for
     * accessors created for values that already existed on the element
     * prototype.
     *
     * @return {void}
     * @protected
     */


    _initializeProperties() {
      if (this.__dataProto) {
        this._initializeProtoProperties(this.__dataProto);

        this.__dataProto = null;
      }

      super._initializeProperties();
    }
    /**
     * Called at instance time with bag of properties that were overwritten
     * by accessors on the prototype when accessors were created.
     *
     * The default implementation sets these properties back into the
     * setter at instance time.  This method is provided as an override
     * point for customizing or providing more efficient initialization.
     *
     * @param {Object} props Bag of property values that were overwritten
     *   when creating property accessors.
     * @return {void}
     * @protected
     */


    _initializeProtoProperties(props) {
      for (let p in props) {
        this._setProperty(p, props[p]);
      }
    }
    /**
     * Ensures the element has the given attribute. If it does not,
     * assigns the given value to the attribute.
     *
     * @suppress {invalidCasts} Closure can't figure out `this` is infact an element
     *
     * @param {string} attribute Name of attribute to ensure is set.
     * @param {string} value of the attribute.
     * @return {void}
     */


    _ensureAttribute(attribute, value) {
      const el =
      /** @type {!HTMLElement} */
      this;

      if (!el.hasAttribute(attribute)) {
        this._valueToNodeAttribute(el, value, attribute);
      }
    }
    /**
     * Overrides PropertiesChanged implemention to serialize objects as JSON.
     *
     * @param {*} value Property value to serialize.
     * @return {string | undefined} String serialized from the provided property value.
     */


    _serializeValue(value) {
      /* eslint-disable no-fallthrough */
      switch (typeof value) {
        case 'object':
          if (value instanceof Date) {
            return value.toString();
          } else if (value) {
            try {
              return JSON.stringify(value);
            } catch (x) {
              return '';
            }
          }

        default:
          return super._serializeValue(value);
      }
    }
    /**
     * Converts a string to a typed JavaScript value.
     *
     * This method is called by Polymer when reading HTML attribute values to
     * JS properties.  Users may override this method on Polymer element
     * prototypes to provide deserialization for custom `type`s.  Note,
     * the `type` argument is the value of the `type` field provided in the
     * `properties` configuration object for a given property, and is
     * by convention the constructor for the type to deserialize.
     *
     *
     * @param {?string} value Attribute value to deserialize.
     * @param {*=} type Type to deserialize the string to.
     * @return {*} Typed value deserialized from the provided string.
     */


    _deserializeValue(value, type) {
      /**
       * @type {*}
       */
      let outValue;

      switch (type) {
        case Object:
          try {
            outValue = JSON.parse(
            /** @type {string} */
            value);
          } catch (x) {
            // allow non-JSON literals like Strings and Numbers
            outValue = value;
          }

          break;

        case Array:
          try {
            outValue = JSON.parse(
            /** @type {string} */
            value);
          } catch (x) {
            outValue = null;
            console.warn(`Polymer::Attributes: couldn't decode Array as JSON: ${value}`);
          }

          break;

        case Date:
          outValue = isNaN(value) ? String(value) : Number(value);
          outValue = new Date(outValue);
          break;

        default:
          outValue = super._deserializeValue(value, type);
          break;
      }

      return outValue;
    }
    /* eslint-enable no-fallthrough */

    /**
     * Overrides PropertiesChanged implementation to save existing prototype
     * property value so that it can be reset.
     * @param {string} property Name of the property
     * @param {boolean=} readOnly When true, no setter is created
     *
     * When calling on a prototype, any overwritten values are saved in
     * `__dataProto`, and it is up to the subclasser to decide how/when
     * to set those properties back into the accessor.  When calling on an
     * instance, the overwritten value is set via `_setPendingProperty`,
     * and the user should call `_invalidateProperties` or `_flushProperties`
     * for the values to take effect.
     * @protected
     * @return {void}
     */


    _definePropertyAccessor(property, readOnly) {
      saveAccessorValue(this, property);

      super._definePropertyAccessor(property, readOnly);
    }
    /**
     * Returns true if this library created an accessor for the given property.
     *
     * @param {string} property Property name
     * @return {boolean} True if an accessor was created
     */


    _hasAccessor(property) {
      return this.__dataHasAccessor && this.__dataHasAccessor[property];
    }
    /**
     * Returns true if the specified property has a pending change.
     *
     * @param {string} prop Property name
     * @return {boolean} True if property has a pending change
     * @protected
     */


    _isPropertyPending(prop) {
      return Boolean(this.__dataPending && prop in this.__dataPending);
    }

  }

  return PropertyAccessors;
});

/***/ }),

/***/ "./node_modules/@polymer/polymer/lib/mixins/property-effects.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@polymer/polymer/lib/mixins/property-effects.js ***!
  \**********************************************************************/
/*! exports provided: PropertyEffects */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PropertyEffects", function() { return PropertyEffects; });
/* harmony import */ var _utils_boot_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/boot.js */ "./node_modules/@polymer/polymer/lib/utils/boot.js");
/* harmony import */ var _utils_mixin_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/mixin.js */ "./node_modules/@polymer/polymer/lib/utils/mixin.js");
/* harmony import */ var _utils_path_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/path.js */ "./node_modules/@polymer/polymer/lib/utils/path.js");
/* harmony import */ var _utils_case_map_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/case-map.js */ "./node_modules/@polymer/polymer/lib/utils/case-map.js");
/* harmony import */ var _property_accessors_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./property-accessors.js */ "./node_modules/@polymer/polymer/lib/mixins/property-accessors.js");
/* harmony import */ var _template_stamp_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./template-stamp.js */ "./node_modules/@polymer/polymer/lib/mixins/template-stamp.js");
/* harmony import */ var _utils_settings_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../utils/settings.js */ "./node_modules/@polymer/polymer/lib/utils/settings.js");
/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/



/* for notify, reflect */



/* for annotated effects */


 // Monotonically increasing unique ID used for de-duping effects triggered
// from multiple properties in the same turn

let dedupeId = 0;
/**
 * Property effect types; effects are stored on the prototype using these keys
 * @enum {string}
 */

const TYPES = {
  COMPUTE: '__computeEffects',
  REFLECT: '__reflectEffects',
  NOTIFY: '__notifyEffects',
  PROPAGATE: '__propagateEffects',
  OBSERVE: '__observeEffects',
  READ_ONLY: '__readOnly'
};
/** @const {RegExp} */

const capitalAttributeRegex = /[A-Z]/;
/**
 * @typedef {{
 * name: (string | undefined),
 * structured: (boolean | undefined),
 * wildcard: (boolean | undefined)
 * }}
 */

let DataTrigger; //eslint-disable-line no-unused-vars

/**
 * @typedef {{
 * info: ?,
 * trigger: (!DataTrigger | undefined),
 * fn: (!Function | undefined)
 * }}
 */

let DataEffect; //eslint-disable-line no-unused-vars

let PropertyEffectsType; //eslint-disable-line no-unused-vars

/**
 * Ensures that the model has an own-property map of effects for the given type.
 * The model may be a prototype or an instance.
 *
 * Property effects are stored as arrays of effects by property in a map,
 * by named type on the model. e.g.
 *
 *   __computeEffects: {
 *     foo: [ ... ],
 *     bar: [ ... ]
 *   }
 *
 * If the model does not yet have an effect map for the type, one is created
 * and returned.  If it does, but it is not an own property (i.e. the
 * prototype had effects), the the map is deeply cloned and the copy is
 * set on the model and returned, ready for new effects to be added.
 *
 * @param {Object} model Prototype or instance
 * @param {string} type Property effect type
 * @return {Object} The own-property map of effects for the given type
 * @private
 */

function ensureOwnEffectMap(model, type) {
  let effects = model[type];

  if (!effects) {
    effects = model[type] = {};
  } else if (!model.hasOwnProperty(type)) {
    effects = model[type] = Object.create(model[type]);

    for (let p in effects) {
      let protoFx = effects[p];
      let instFx = effects[p] = Array(protoFx.length);

      for (let i = 0; i < protoFx.length; i++) {
        instFx[i] = protoFx[i];
      }
    }
  }

  return effects;
} // -- effects ----------------------------------------------

/**
 * Runs all effects of a given type for the given set of property changes
 * on an instance.
 *
 * @param {!PropertyEffectsType} inst The instance with effects to run
 * @param {Object} effects Object map of property-to-Array of effects
 * @param {Object} props Bag of current property changes
 * @param {Object=} oldProps Bag of previous values for changed properties
 * @param {boolean=} hasPaths True with `props` contains one or more paths
 * @param {*=} extraArgs Additional metadata to pass to effect function
 * @return {boolean} True if an effect ran for this property
 * @private
 */


function runEffects(inst, effects, props, oldProps, hasPaths, extraArgs) {
  if (effects) {
    let ran = false;
    let id = dedupeId++;

    for (let prop in props) {
      if (runEffectsForProperty(inst, effects, id, prop, props, oldProps, hasPaths, extraArgs)) {
        ran = true;
      }
    }

    return ran;
  }

  return false;
}
/**
 * Runs a list of effects for a given property.
 *
 * @param {!PropertyEffectsType} inst The instance with effects to run
 * @param {Object} effects Object map of property-to-Array of effects
 * @param {number} dedupeId Counter used for de-duping effects
 * @param {string} prop Name of changed property
 * @param {*} props Changed properties
 * @param {*} oldProps Old properties
 * @param {boolean=} hasPaths True with `props` contains one or more paths
 * @param {*=} extraArgs Additional metadata to pass to effect function
 * @return {boolean} True if an effect ran for this property
 * @private
 */


function runEffectsForProperty(inst, effects, dedupeId, prop, props, oldProps, hasPaths, extraArgs) {
  let ran = false;
  let rootProperty = hasPaths ? Object(_utils_path_js__WEBPACK_IMPORTED_MODULE_2__["root"])(prop) : prop;
  let fxs = effects[rootProperty];

  if (fxs) {
    for (let i = 0, l = fxs.length, fx; i < l && (fx = fxs[i]); i++) {
      if ((!fx.info || fx.info.lastRun !== dedupeId) && (!hasPaths || pathMatchesTrigger(prop, fx.trigger))) {
        if (fx.info) {
          fx.info.lastRun = dedupeId;
        }

        fx.fn(inst, prop, props, oldProps, fx.info, hasPaths, extraArgs);
        ran = true;
      }
    }
  }

  return ran;
}
/**
 * Determines whether a property/path that has changed matches the trigger
 * criteria for an effect.  A trigger is a descriptor with the following
 * structure, which matches the descriptors returned from `parseArg`.
 * e.g. for `foo.bar.*`:
 * ```
 * trigger: {
 *   name: 'a.b',
 *   structured: true,
 *   wildcard: true
 * }
 * ```
 * If no trigger is given, the path is deemed to match.
 *
 * @param {string} path Path or property that changed
 * @param {DataTrigger} trigger Descriptor
 * @return {boolean} Whether the path matched the trigger
 */


function pathMatchesTrigger(path, trigger) {
  if (trigger) {
    let triggerPath = trigger.name;
    return triggerPath == path || trigger.structured && Object(_utils_path_js__WEBPACK_IMPORTED_MODULE_2__["isAncestor"])(triggerPath, path) || trigger.wildcard && Object(_utils_path_js__WEBPACK_IMPORTED_MODULE_2__["isDescendant"])(triggerPath, path);
  } else {
    return true;
  }
}
/**
 * Implements the "observer" effect.
 *
 * Calls the method with `info.methodName` on the instance, passing the
 * new and old values.
 *
 * @param {!PropertyEffectsType} inst The instance the effect will be run on
 * @param {string} property Name of property
 * @param {Object} props Bag of current property changes
 * @param {Object} oldProps Bag of previous values for changed properties
 * @param {?} info Effect metadata
 * @return {void}
 * @private
 */


function runObserverEffect(inst, property, props, oldProps, info) {
  let fn = typeof info.method === "string" ? inst[info.method] : info.method;
  let changedProp = info.property;

  if (fn) {
    fn.call(inst, inst.__data[changedProp], oldProps[changedProp]);
  } else if (!info.dynamicFn) {
    console.warn('observer method `' + info.method + '` not defined');
  }
}
/**
 * Runs "notify" effects for a set of changed properties.
 *
 * This method differs from the generic `runEffects` method in that it
 * will dispatch path notification events in the case that the property
 * changed was a path and the root property for that path didn't have a
 * "notify" effect.  This is to maintain 1.0 behavior that did not require
 * `notify: true` to ensure object sub-property notifications were
 * sent.
 *
 * @param {!PropertyEffectsType} inst The instance with effects to run
 * @param {Object} notifyProps Bag of properties to notify
 * @param {Object} props Bag of current property changes
 * @param {Object} oldProps Bag of previous values for changed properties
 * @param {boolean} hasPaths True with `props` contains one or more paths
 * @return {void}
 * @private
 */


function runNotifyEffects(inst, notifyProps, props, oldProps, hasPaths) {
  // Notify
  let fxs = inst[TYPES.NOTIFY];
  let notified;
  let id = dedupeId++; // Try normal notify effects; if none, fall back to try path notification

  for (let prop in notifyProps) {
    if (notifyProps[prop]) {
      if (fxs && runEffectsForProperty(inst, fxs, id, prop, props, oldProps, hasPaths)) {
        notified = true;
      } else if (hasPaths && notifyPath(inst, prop, props)) {
        notified = true;
      }
    }
  } // Flush host if we actually notified and host was batching
  // And the host has already initialized clients; this prevents
  // an issue with a host observing data changes before clients are ready.


  let host;

  if (notified && (host = inst.__dataHost) && host._invalidateProperties) {
    host._invalidateProperties();
  }
}
/**
 * Dispatches {property}-changed events with path information in the detail
 * object to indicate a sub-path of the property was changed.
 *
 * @param {!PropertyEffectsType} inst The element from which to fire the event
 * @param {string} path The path that was changed
 * @param {Object} props Bag of current property changes
 * @return {boolean} Returns true if the path was notified
 * @private
 */


function notifyPath(inst, path, props) {
  let rootProperty = Object(_utils_path_js__WEBPACK_IMPORTED_MODULE_2__["root"])(path);

  if (rootProperty !== path) {
    let eventName = Object(_utils_case_map_js__WEBPACK_IMPORTED_MODULE_3__["camelToDashCase"])(rootProperty) + '-changed';
    dispatchNotifyEvent(inst, eventName, props[path], path);
    return true;
  }

  return false;
}
/**
 * Dispatches {property}-changed events to indicate a property (or path)
 * changed.
 *
 * @param {!PropertyEffectsType} inst The element from which to fire the event
 * @param {string} eventName The name of the event to send ('{property}-changed')
 * @param {*} value The value of the changed property
 * @param {string | null | undefined} path If a sub-path of this property changed, the path
 *   that changed (optional).
 * @return {void}
 * @private
 * @suppress {invalidCasts}
 */


function dispatchNotifyEvent(inst, eventName, value, path) {
  let detail = {
    value: value,
    queueProperty: true
  };

  if (path) {
    detail.path = path;
  }
  /** @type {!HTMLElement} */


  inst.dispatchEvent(new CustomEvent(eventName, {
    detail
  }));
}
/**
 * Implements the "notify" effect.
 *
 * Dispatches a non-bubbling event named `info.eventName` on the instance
 * with a detail object containing the new `value`.
 *
 * @param {!PropertyEffectsType} inst The instance the effect will be run on
 * @param {string} property Name of property
 * @param {Object} props Bag of current property changes
 * @param {Object} oldProps Bag of previous values for changed properties
 * @param {?} info Effect metadata
 * @param {boolean} hasPaths True with `props` contains one or more paths
 * @return {void}
 * @private
 */


function runNotifyEffect(inst, property, props, oldProps, info, hasPaths) {
  let rootProperty = hasPaths ? Object(_utils_path_js__WEBPACK_IMPORTED_MODULE_2__["root"])(property) : property;
  let path = rootProperty != property ? property : null;
  let value = path ? Object(_utils_path_js__WEBPACK_IMPORTED_MODULE_2__["get"])(inst, path) : inst.__data[property];

  if (path && value === undefined) {
    value = props[property]; // specifically for .splices
  }

  dispatchNotifyEvent(inst, info.eventName, value, path);
}
/**
 * Handler function for 2-way notification events. Receives context
 * information captured in the `addNotifyListener` closure from the
 * `__notifyListeners` metadata.
 *
 * Sets the value of the notified property to the host property or path.  If
 * the event contained path information, translate that path to the host
 * scope's name for that path first.
 *
 * @param {CustomEvent} event Notification event (e.g. '<property>-changed')
 * @param {!PropertyEffectsType} inst Host element instance handling the notification event
 * @param {string} fromProp Child element property that was bound
 * @param {string} toPath Host property/path that was bound
 * @param {boolean} negate Whether the binding was negated
 * @return {void}
 * @private
 */


function handleNotification(event, inst, fromProp, toPath, negate) {
  let value;
  let detail =
  /** @type {Object} */
  event.detail;
  let fromPath = detail && detail.path;

  if (fromPath) {
    toPath = Object(_utils_path_js__WEBPACK_IMPORTED_MODULE_2__["translate"])(fromProp, toPath, fromPath);
    value = detail && detail.value;
  } else {
    value = event.currentTarget[fromProp];
  }

  value = negate ? !value : value;

  if (!inst[TYPES.READ_ONLY] || !inst[TYPES.READ_ONLY][toPath]) {
    if (inst._setPendingPropertyOrPath(toPath, value, true, Boolean(fromPath)) && (!detail || !detail.queueProperty)) {
      inst._invalidateProperties();
    }
  }
}
/**
 * Implements the "reflect" effect.
 *
 * Sets the attribute named `info.attrName` to the given property value.
 *
 * @param {!PropertyEffectsType} inst The instance the effect will be run on
 * @param {string} property Name of property
 * @param {Object} props Bag of current property changes
 * @param {Object} oldProps Bag of previous values for changed properties
 * @param {?} info Effect metadata
 * @return {void}
 * @private
 */


function runReflectEffect(inst, property, props, oldProps, info) {
  let value = inst.__data[property];

  if (_utils_settings_js__WEBPACK_IMPORTED_MODULE_6__["sanitizeDOMValue"]) {
    value = Object(_utils_settings_js__WEBPACK_IMPORTED_MODULE_6__["sanitizeDOMValue"])(value, info.attrName, 'attribute',
    /** @type {Node} */
    inst);
  }

  inst._propertyToAttribute(property, info.attrName, value);
}
/**
 * Runs "computed" effects for a set of changed properties.
 *
 * This method differs from the generic `runEffects` method in that it
 * continues to run computed effects based on the output of each pass until
 * there are no more newly computed properties.  This ensures that all
 * properties that will be computed by the initial set of changes are
 * computed before other effects (binding propagation, observers, and notify)
 * run.
 *
 * @param {!PropertyEffectsType} inst The instance the effect will be run on
 * @param {!Object} changedProps Bag of changed properties
 * @param {!Object} oldProps Bag of previous values for changed properties
 * @param {boolean} hasPaths True with `props` contains one or more paths
 * @return {void}
 * @private
 */


function runComputedEffects(inst, changedProps, oldProps, hasPaths) {
  let computeEffects = inst[TYPES.COMPUTE];

  if (computeEffects) {
    let inputProps = changedProps;

    while (runEffects(inst, computeEffects, inputProps, oldProps, hasPaths)) {
      Object.assign(oldProps, inst.__dataOld);
      Object.assign(changedProps, inst.__dataPending);
      inputProps = inst.__dataPending;
      inst.__dataPending = null;
    }
  }
}
/**
 * Implements the "computed property" effect by running the method with the
 * values of the arguments specified in the `info` object and setting the
 * return value to the computed property specified.
 *
 * @param {!PropertyEffectsType} inst The instance the effect will be run on
 * @param {string} property Name of property
 * @param {Object} props Bag of current property changes
 * @param {Object} oldProps Bag of previous values for changed properties
 * @param {?} info Effect metadata
 * @return {void}
 * @private
 */


function runComputedEffect(inst, property, props, oldProps, info) {
  let result = runMethodEffect(inst, property, props, oldProps, info);
  let computedProp = info.methodInfo;

  if (inst.__dataHasAccessor && inst.__dataHasAccessor[computedProp]) {
    inst._setPendingProperty(computedProp, result, true);
  } else {
    inst[computedProp] = result;
  }
}
/**
 * Computes path changes based on path links set up using the `linkPaths`
 * API.
 *
 * @param {!PropertyEffectsType} inst The instance whose props are changing
 * @param {string | !Array<(string|number)>} path Path that has changed
 * @param {*} value Value of changed path
 * @return {void}
 * @private
 */


function computeLinkedPaths(inst, path, value) {
  let links = inst.__dataLinkedPaths;

  if (links) {
    let link;

    for (let a in links) {
      let b = links[a];

      if (Object(_utils_path_js__WEBPACK_IMPORTED_MODULE_2__["isDescendant"])(a, path)) {
        link = Object(_utils_path_js__WEBPACK_IMPORTED_MODULE_2__["translate"])(a, b, path);

        inst._setPendingPropertyOrPath(link, value, true, true);
      } else if (Object(_utils_path_js__WEBPACK_IMPORTED_MODULE_2__["isDescendant"])(b, path)) {
        link = Object(_utils_path_js__WEBPACK_IMPORTED_MODULE_2__["translate"])(b, a, path);

        inst._setPendingPropertyOrPath(link, value, true, true);
      }
    }
  }
} // -- bindings ----------------------------------------------

/**
 * Adds binding metadata to the current `nodeInfo`, and binding effects
 * for all part dependencies to `templateInfo`.
 *
 * @param {Function} constructor Class that `_parseTemplate` is currently
 *   running on
 * @param {TemplateInfo} templateInfo Template metadata for current template
 * @param {NodeInfo} nodeInfo Node metadata for current template node
 * @param {string} kind Binding kind, either 'property', 'attribute', or 'text'
 * @param {string} target Target property name
 * @param {!Array<!BindingPart>} parts Array of binding part metadata
 * @param {string=} literal Literal text surrounding binding parts (specified
 *   only for 'property' bindings, since these must be initialized as part
 *   of boot-up)
 * @return {void}
 * @private
 */


function addBinding(constructor, templateInfo, nodeInfo, kind, target, parts, literal) {
  // Create binding metadata and add to nodeInfo
  nodeInfo.bindings = nodeInfo.bindings || [];
  let
  /** Binding */
  binding = {
    kind,
    target,
    parts,
    literal,
    isCompound: parts.length !== 1
  };
  nodeInfo.bindings.push(binding); // Add listener info to binding metadata

  if (shouldAddListener(binding)) {
    let {
      event,
      negate
    } = binding.parts[0];
    binding.listenerEvent = event || Object(_utils_case_map_js__WEBPACK_IMPORTED_MODULE_3__["camelToDashCase"])(target) + '-changed';
    binding.listenerNegate = negate;
  } // Add "propagate" property effects to templateInfo


  let index = templateInfo.nodeInfoList.length;

  for (let i = 0; i < binding.parts.length; i++) {
    let part = binding.parts[i];
    part.compoundIndex = i;
    addEffectForBindingPart(constructor, templateInfo, binding, part, index);
  }
}
/**
 * Adds property effects to the given `templateInfo` for the given binding
 * part.
 *
 * @param {Function} constructor Class that `_parseTemplate` is currently
 *   running on
 * @param {TemplateInfo} templateInfo Template metadata for current template
 * @param {!Binding} binding Binding metadata
 * @param {!BindingPart} part Binding part metadata
 * @param {number} index Index into `nodeInfoList` for this node
 * @return {void}
 */


function addEffectForBindingPart(constructor, templateInfo, binding, part, index) {
  if (!part.literal) {
    if (binding.kind === 'attribute' && binding.target[0] === '-') {
      console.warn('Cannot set attribute ' + binding.target + ' because "-" is not a valid attribute starting character');
    } else {
      let dependencies = part.dependencies;
      let info = {
        index,
        binding,
        part,
        evaluator: constructor
      };

      for (let j = 0; j < dependencies.length; j++) {
        let trigger = dependencies[j];

        if (typeof trigger == 'string') {
          trigger = parseArg(trigger);
          trigger.wildcard = true;
        }

        constructor._addTemplatePropertyEffect(templateInfo, trigger.rootProperty, {
          fn: runBindingEffect,
          info,
          trigger
        });
      }
    }
  }
}
/**
 * Implements the "binding" (property/path binding) effect.
 *
 * Note that binding syntax is overridable via `_parseBindings` and
 * `_evaluateBinding`.  This method will call `_evaluateBinding` for any
 * non-literal parts returned from `_parseBindings`.  However,
 * there is no support for _path_ bindings via custom binding parts,
 * as this is specific to Polymer's path binding syntax.
 *
 * @param {!PropertyEffectsType} inst The instance the effect will be run on
 * @param {string} path Name of property
 * @param {Object} props Bag of current property changes
 * @param {Object} oldProps Bag of previous values for changed properties
 * @param {?} info Effect metadata
 * @param {boolean} hasPaths True with `props` contains one or more paths
 * @param {Array} nodeList List of nodes associated with `nodeInfoList` template
 *   metadata
 * @return {void}
 * @private
 */


function runBindingEffect(inst, path, props, oldProps, info, hasPaths, nodeList) {
  let node = nodeList[info.index];
  let binding = info.binding;
  let part = info.part; // Subpath notification: transform path and set to client
  // e.g.: foo="{{obj.sub}}", path: 'obj.sub.prop', set 'foo.prop'=obj.sub.prop

  if (hasPaths && part.source && path.length > part.source.length && binding.kind == 'property' && !binding.isCompound && node.__isPropertyEffectsClient && node.__dataHasAccessor && node.__dataHasAccessor[binding.target]) {
    let value = props[path];
    path = Object(_utils_path_js__WEBPACK_IMPORTED_MODULE_2__["translate"])(part.source, binding.target, path);

    if (node._setPendingPropertyOrPath(path, value, false, true)) {
      inst._enqueueClient(node);
    }
  } else {
    let value = info.evaluator._evaluateBinding(inst, part, path, props, oldProps, hasPaths); // Propagate value to child


    applyBindingValue(inst, node, binding, part, value);
  }
}
/**
 * Sets the value for an "binding" (binding) effect to a node,
 * either as a property or attribute.
 *
 * @param {!PropertyEffectsType} inst The instance owning the binding effect
 * @param {Node} node Target node for binding
 * @param {!Binding} binding Binding metadata
 * @param {!BindingPart} part Binding part metadata
 * @param {*} value Value to set
 * @return {void}
 * @private
 */


function applyBindingValue(inst, node, binding, part, value) {
  value = computeBindingValue(node, value, binding, part);

  if (_utils_settings_js__WEBPACK_IMPORTED_MODULE_6__["sanitizeDOMValue"]) {
    value = Object(_utils_settings_js__WEBPACK_IMPORTED_MODULE_6__["sanitizeDOMValue"])(value, binding.target, binding.kind, node);
  }

  if (binding.kind == 'attribute') {
    // Attribute binding
    inst._valueToNodeAttribute(
    /** @type {Element} */
    node, value, binding.target);
  } else {
    // Property binding
    let prop = binding.target;

    if (node.__isPropertyEffectsClient && node.__dataHasAccessor && node.__dataHasAccessor[prop]) {
      if (!node[TYPES.READ_ONLY] || !node[TYPES.READ_ONLY][prop]) {
        if (node._setPendingProperty(prop, value)) {
          inst._enqueueClient(node);
        }
      }
    } else {
      inst._setUnmanagedPropertyToNode(node, prop, value);
    }
  }
}
/**
 * Transforms an "binding" effect value based on compound & negation
 * effect metadata, as well as handling for special-case properties
 *
 * @param {Node} node Node the value will be set to
 * @param {*} value Value to set
 * @param {!Binding} binding Binding metadata
 * @param {!BindingPart} part Binding part metadata
 * @return {*} Transformed value to set
 * @private
 */


function computeBindingValue(node, value, binding, part) {
  if (binding.isCompound) {
    let storage = node.__dataCompoundStorage[binding.target];
    storage[part.compoundIndex] = value;
    value = storage.join('');
  }

  if (binding.kind !== 'attribute') {
    // Some browsers serialize `undefined` to `"undefined"`
    if (binding.target === 'textContent' || binding.target === 'value' && (node.localName === 'input' || node.localName === 'textarea')) {
      value = value == undefined ? '' : value;
    }
  }

  return value;
}
/**
 * Returns true if a binding's metadata meets all the requirements to allow
 * 2-way binding, and therefore a `<property>-changed` event listener should be
 * added:
 * - used curly braces
 * - is a property (not attribute) binding
 * - is not a textContent binding
 * - is not compound
 *
 * @param {!Binding} binding Binding metadata
 * @return {boolean} True if 2-way listener should be added
 * @private
 */


function shouldAddListener(binding) {
  return Boolean(binding.target) && binding.kind != 'attribute' && binding.kind != 'text' && !binding.isCompound && binding.parts[0].mode === '{';
}
/**
 * Setup compound binding storage structures, notify listeners, and dataHost
 * references onto the bound nodeList.
 *
 * @param {!PropertyEffectsType} inst Instance that bas been previously bound
 * @param {TemplateInfo} templateInfo Template metadata
 * @return {void}
 * @private
 */


function setupBindings(inst, templateInfo) {
  // Setup compound storage, dataHost, and notify listeners
  let {
    nodeList,
    nodeInfoList
  } = templateInfo;

  if (nodeInfoList.length) {
    for (let i = 0; i < nodeInfoList.length; i++) {
      let info = nodeInfoList[i];
      let node = nodeList[i];
      let bindings = info.bindings;

      if (bindings) {
        for (let i = 0; i < bindings.length; i++) {
          let binding = bindings[i];
          setupCompoundStorage(node, binding);
          addNotifyListener(node, inst, binding);
        }
      }

      node.__dataHost = inst;
    }
  }
}
/**
 * Initializes `__dataCompoundStorage` local storage on a bound node with
 * initial literal data for compound bindings, and sets the joined
 * literal parts to the bound property.
 *
 * When changes to compound parts occur, they are first set into the compound
 * storage array for that property, and then the array is joined to result in
 * the final value set to the property/attribute.
 *
 * @param {Node} node Bound node to initialize
 * @param {Binding} binding Binding metadata
 * @return {void}
 * @private
 */


function setupCompoundStorage(node, binding) {
  if (binding.isCompound) {
    // Create compound storage map
    let storage = node.__dataCompoundStorage || (node.__dataCompoundStorage = {});
    let parts = binding.parts; // Copy literals from parts into storage for this binding

    let literals = new Array(parts.length);

    for (let j = 0; j < parts.length; j++) {
      literals[j] = parts[j].literal;
    }

    let target = binding.target;
    storage[target] = literals; // Configure properties with their literal parts

    if (binding.literal && binding.kind == 'property') {
      node[target] = binding.literal;
    }
  }
}
/**
 * Adds a 2-way binding notification event listener to the node specified
 *
 * @param {Object} node Child element to add listener to
 * @param {!PropertyEffectsType} inst Host element instance to handle notification event
 * @param {Binding} binding Binding metadata
 * @return {void}
 * @private
 */


function addNotifyListener(node, inst, binding) {
  if (binding.listenerEvent) {
    let part = binding.parts[0];
    node.addEventListener(binding.listenerEvent, function (e) {
      handleNotification(e, inst, binding.target, part.source, part.negate);
    });
  }
} // -- for method-based effects (complexObserver & computed) --------------

/**
 * Adds property effects for each argument in the method signature (and
 * optionally, for the method name if `dynamic` is true) that calls the
 * provided effect function.
 *
 * @param {Element | Object} model Prototype or instance
 * @param {!MethodSignature} sig Method signature metadata
 * @param {string} type Type of property effect to add
 * @param {Function} effectFn Function to run when arguments change
 * @param {*=} methodInfo Effect-specific information to be included in
 *   method effect metadata
 * @param {boolean|Object=} dynamicFn Boolean or object map indicating whether
 *   method names should be included as a dependency to the effect. Note,
 *   defaults to true if the signature is static (sig.static is true).
 * @return {void}
 * @private
 */


function createMethodEffect(model, sig, type, effectFn, methodInfo, dynamicFn) {
  dynamicFn = sig.static || dynamicFn && (typeof dynamicFn !== 'object' || dynamicFn[sig.methodName]);
  let info = {
    methodName: sig.methodName,
    args: sig.args,
    methodInfo,
    dynamicFn
  };

  for (let i = 0, arg; i < sig.args.length && (arg = sig.args[i]); i++) {
    if (!arg.literal) {
      model._addPropertyEffect(arg.rootProperty, type, {
        fn: effectFn,
        info: info,
        trigger: arg
      });
    }
  }

  if (dynamicFn) {
    model._addPropertyEffect(sig.methodName, type, {
      fn: effectFn,
      info: info
    });
  }
}
/**
 * Calls a method with arguments marshaled from properties on the instance
 * based on the method signature contained in the effect metadata.
 *
 * Multi-property observers, computed properties, and inline computing
 * functions call this function to invoke the method, then use the return
 * value accordingly.
 *
 * @param {!PropertyEffectsType} inst The instance the effect will be run on
 * @param {string} property Name of property
 * @param {Object} props Bag of current property changes
 * @param {Object} oldProps Bag of previous values for changed properties
 * @param {?} info Effect metadata
 * @return {*} Returns the return value from the method invocation
 * @private
 */


function runMethodEffect(inst, property, props, oldProps, info) {
  // Instances can optionally have a _methodHost which allows redirecting where
  // to find methods. Currently used by `templatize`.
  let context = inst._methodHost || inst;
  let fn = context[info.methodName];

  if (fn) {
    let args = inst._marshalArgs(info.args, property, props);

    return fn.apply(context, args);
  } else if (!info.dynamicFn) {
    console.warn('method `' + info.methodName + '` not defined');
  }
}

const emptyArray = []; // Regular expressions used for binding

const IDENT = '(?:' + '[a-zA-Z_$][\\w.:$\\-*]*' + ')';
const NUMBER = '(?:' + '[-+]?[0-9]*\\.?[0-9]+(?:[eE][-+]?[0-9]+)?' + ')';
const SQUOTE_STRING = '(?:' + '\'(?:[^\'\\\\]|\\\\.)*\'' + ')';
const DQUOTE_STRING = '(?:' + '"(?:[^"\\\\]|\\\\.)*"' + ')';
const STRING = '(?:' + SQUOTE_STRING + '|' + DQUOTE_STRING + ')';
const ARGUMENT = '(?:(' + IDENT + '|' + NUMBER + '|' + STRING + ')\\s*' + ')';
const ARGUMENTS = '(?:' + ARGUMENT + '(?:,\\s*' + ARGUMENT + ')*' + ')';
const ARGUMENT_LIST = '(?:' + '\\(\\s*' + '(?:' + ARGUMENTS + '?' + ')' + '\\)\\s*' + ')';
const BINDING = '(' + IDENT + '\\s*' + ARGUMENT_LIST + '?' + ')'; // Group 3

const OPEN_BRACKET = '(\\[\\[|{{)' + '\\s*';
const CLOSE_BRACKET = '(?:]]|}})';
const NEGATE = '(?:(!)\\s*)?'; // Group 2

const EXPRESSION = OPEN_BRACKET + NEGATE + BINDING + CLOSE_BRACKET;
const bindingRegex = new RegExp(EXPRESSION, "g");
/**
 * Create a string from binding parts of all the literal parts
 *
 * @param {!Array<BindingPart>} parts All parts to stringify
 * @return {string} String made from the literal parts
 */

function literalFromParts(parts) {
  let s = '';

  for (let i = 0; i < parts.length; i++) {
    let literal = parts[i].literal;
    s += literal || '';
  }

  return s;
}
/**
 * Parses an expression string for a method signature, and returns a metadata
 * describing the method in terms of `methodName`, `static` (whether all the
 * arguments are literals), and an array of `args`
 *
 * @param {string} expression The expression to parse
 * @return {?MethodSignature} The method metadata object if a method expression was
 *   found, otherwise `undefined`
 * @private
 */


function parseMethod(expression) {
  // tries to match valid javascript property names
  let m = expression.match(/([^\s]+?)\(([\s\S]*)\)/);

  if (m) {
    let methodName = m[1];
    let sig = {
      methodName,
      static: true,
      args: emptyArray
    };

    if (m[2].trim()) {
      // replace escaped commas with comma entity, split on un-escaped commas
      let args = m[2].replace(/\\,/g, '&comma;').split(',');
      return parseArgs(args, sig);
    } else {
      return sig;
    }
  }

  return null;
}
/**
 * Parses an array of arguments and sets the `args` property of the supplied
 * signature metadata object. Sets the `static` property to false if any
 * argument is a non-literal.
 *
 * @param {!Array<string>} argList Array of argument names
 * @param {!MethodSignature} sig Method signature metadata object
 * @return {!MethodSignature} The updated signature metadata object
 * @private
 */


function parseArgs(argList, sig) {
  sig.args = argList.map(function (rawArg) {
    let arg = parseArg(rawArg);

    if (!arg.literal) {
      sig.static = false;
    }

    return arg;
  }, this);
  return sig;
}
/**
 * Parses an individual argument, and returns an argument metadata object
 * with the following fields:
 *
 *   {
 *     value: 'prop',        // property/path or literal value
 *     literal: false,       // whether argument is a literal
 *     structured: false,    // whether the property is a path
 *     rootProperty: 'prop', // the root property of the path
 *     wildcard: false       // whether the argument was a wildcard '.*' path
 *   }
 *
 * @param {string} rawArg The string value of the argument
 * @return {!MethodArg} Argument metadata object
 * @private
 */


function parseArg(rawArg) {
  // clean up whitespace
  let arg = rawArg.trim() // replace comma entity with comma
  .replace(/&comma;/g, ',') // repair extra escape sequences; note only commas strictly need
  // escaping, but we allow any other char to be escaped since its
  // likely users will do this
  .replace(/\\(.)/g, '\$1'); // basic argument descriptor

  let a = {
    name: arg,
    value: '',
    literal: false
  }; // detect literal value (must be String or Number)

  let fc = arg[0];

  if (fc === '-') {
    fc = arg[1];
  }

  if (fc >= '0' && fc <= '9') {
    fc = '#';
  }

  switch (fc) {
    case "'":
    case '"':
      a.value = arg.slice(1, -1);
      a.literal = true;
      break;

    case '#':
      a.value = Number(arg);
      a.literal = true;
      break;
  } // if not literal, look for structured path


  if (!a.literal) {
    a.rootProperty = Object(_utils_path_js__WEBPACK_IMPORTED_MODULE_2__["root"])(arg); // detect structured path (has dots)

    a.structured = Object(_utils_path_js__WEBPACK_IMPORTED_MODULE_2__["isPath"])(arg);

    if (a.structured) {
      a.wildcard = arg.slice(-2) == '.*';

      if (a.wildcard) {
        a.name = arg.slice(0, -2);
      }
    }
  }

  return a;
} // data api

/**
 * Sends array splice notifications (`.splices` and `.length`)
 *
 * Note: this implementation only accepts normalized paths
 *
 * @param {!PropertyEffectsType} inst Instance to send notifications to
 * @param {Array} array The array the mutations occurred on
 * @param {string} path The path to the array that was mutated
 * @param {Array} splices Array of splice records
 * @return {void}
 * @private
 */


function notifySplices(inst, array, path, splices) {
  let splicesPath = path + '.splices';
  inst.notifyPath(splicesPath, {
    indexSplices: splices
  });
  inst.notifyPath(path + '.length', array.length); // Null here to allow potentially large splice records to be GC'ed.

  inst.__data[splicesPath] = {
    indexSplices: null
  };
}
/**
 * Creates a splice record and sends an array splice notification for
 * the described mutation
 *
 * Note: this implementation only accepts normalized paths
 *
 * @param {!PropertyEffectsType} inst Instance to send notifications to
 * @param {Array} array The array the mutations occurred on
 * @param {string} path The path to the array that was mutated
 * @param {number} index Index at which the array mutation occurred
 * @param {number} addedCount Number of added items
 * @param {Array} removed Array of removed items
 * @return {void}
 * @private
 */


function notifySplice(inst, array, path, index, addedCount, removed) {
  notifySplices(inst, array, path, [{
    index: index,
    addedCount: addedCount,
    removed: removed,
    object: array,
    type: 'splice'
  }]);
}
/**
 * Returns an upper-cased version of the string.
 *
 * @param {string} name String to uppercase
 * @return {string} Uppercased string
 * @private
 */


function upper(name) {
  return name[0].toUpperCase() + name.substring(1);
}
/**
 * Element class mixin that provides meta-programming for Polymer's template
 * binding and data observation (collectively, "property effects") system.
 *
 * This mixin uses provides the following key static methods for adding
 * property effects to an element class:
 * - `addPropertyEffect`
 * - `createPropertyObserver`
 * - `createMethodObserver`
 * - `createNotifyingProperty`
 * - `createReadOnlyProperty`
 * - `createReflectedProperty`
 * - `createComputedProperty`
 * - `bindTemplate`
 *
 * Each method creates one or more property accessors, along with metadata
 * used by this mixin's implementation of `_propertiesChanged` to perform
 * the property effects.
 *
 * Underscored versions of the above methods also exist on the element
 * prototype for adding property effects on instances at runtime.
 *
 * Note that this mixin overrides several `PropertyAccessors` methods, in
 * many cases to maintain guarantees provided by the Polymer 1.x features;
 * notably it changes property accessors to be synchronous by default
 * whereas the default when using `PropertyAccessors` standalone is to be
 * async by default.
 *
 * @mixinFunction
 * @polymer
 * @appliesMixin TemplateStamp
 * @appliesMixin PropertyAccessors
 * @summary Element class mixin that provides meta-programming for Polymer's
 * template binding and data observation system.
 */


const PropertyEffects = Object(_utils_mixin_js__WEBPACK_IMPORTED_MODULE_1__["dedupingMixin"])(superClass => {
  /**
   * @constructor
   * @extends {superClass}
   * @implements {Polymer_PropertyAccessors}
   * @implements {Polymer_TemplateStamp}
   * @unrestricted
   * @private
   */
  const propertyEffectsBase = Object(_template_stamp_js__WEBPACK_IMPORTED_MODULE_5__["TemplateStamp"])(Object(_property_accessors_js__WEBPACK_IMPORTED_MODULE_4__["PropertyAccessors"])(superClass));
  /**
   * @polymer
   * @mixinClass
   * @implements {Polymer_PropertyEffects}
   * @extends {propertyEffectsBase}
   * @unrestricted
   */

  class PropertyEffects extends propertyEffectsBase {
    constructor() {
      super();
      /** @type {boolean} */
      // Used to identify users of this mixin, ala instanceof

      this.__isPropertyEffectsClient = true;
      /** @type {number} */
      // NOTE: used to track re-entrant calls to `_flushProperties`
      // path changes dirty check against `__dataTemp` only during one "turn"
      // and are cleared when `__dataCounter` returns to 0.

      this.__dataCounter = 0;
      /** @type {boolean} */

      this.__dataClientsReady;
      /** @type {Array} */

      this.__dataPendingClients;
      /** @type {Object} */

      this.__dataToNotify;
      /** @type {Object} */

      this.__dataLinkedPaths;
      /** @type {boolean} */

      this.__dataHasPaths;
      /** @type {Object} */

      this.__dataCompoundStorage;
      /** @type {Polymer_PropertyEffects} */

      this.__dataHost;
      /** @type {!Object} */

      this.__dataTemp;
      /** @type {boolean} */

      this.__dataClientsInitialized;
      /** @type {!Object} */

      this.__data;
      /** @type {!Object} */

      this.__dataPending;
      /** @type {!Object} */

      this.__dataOld;
      /** @type {Object} */

      this.__computeEffects;
      /** @type {Object} */

      this.__reflectEffects;
      /** @type {Object} */

      this.__notifyEffects;
      /** @type {Object} */

      this.__propagateEffects;
      /** @type {Object} */

      this.__observeEffects;
      /** @type {Object} */

      this.__readOnly;
      /** @type {!TemplateInfo} */

      this.__templateInfo;
    }

    get PROPERTY_EFFECT_TYPES() {
      return TYPES;
    }
    /**
     * @return {void}
     */


    _initializeProperties() {
      super._initializeProperties();

      hostStack.registerHost(this);
      this.__dataClientsReady = false;
      this.__dataPendingClients = null;
      this.__dataToNotify = null;
      this.__dataLinkedPaths = null;
      this.__dataHasPaths = false; // May be set on instance prior to upgrade

      this.__dataCompoundStorage = this.__dataCompoundStorage || null;
      this.__dataHost = this.__dataHost || null;
      this.__dataTemp = {};
      this.__dataClientsInitialized = false;
    }
    /**
     * Overrides `PropertyAccessors` implementation to provide a
     * more efficient implementation of initializing properties from
     * the prototype on the instance.
     *
     * @override
     * @param {Object} props Properties to initialize on the prototype
     * @return {void}
     */


    _initializeProtoProperties(props) {
      this.__data = Object.create(props);
      this.__dataPending = Object.create(props);
      this.__dataOld = {};
    }
    /**
     * Overrides `PropertyAccessors` implementation to avoid setting
     * `_setProperty`'s `shouldNotify: true`.
     *
     * @override
     * @param {Object} props Properties to initialize on the instance
     * @return {void}
     */


    _initializeInstanceProperties(props) {
      let readOnly = this[TYPES.READ_ONLY];

      for (let prop in props) {
        if (!readOnly || !readOnly[prop]) {
          this.__dataPending = this.__dataPending || {};
          this.__dataOld = this.__dataOld || {};
          this.__data[prop] = this.__dataPending[prop] = props[prop];
        }
      }
    } // Prototype setup ----------------------------------------

    /**
     * Equivalent to static `addPropertyEffect` API but can be called on
     * an instance to add effects at runtime.  See that method for
     * full API docs.
     *
     * @param {string} property Property that should trigger the effect
     * @param {string} type Effect type, from this.PROPERTY_EFFECT_TYPES
     * @param {Object=} effect Effect metadata object
     * @return {void}
     * @protected
     */


    _addPropertyEffect(property, type, effect) {
      this._createPropertyAccessor(property, type == TYPES.READ_ONLY); // effects are accumulated into arrays per property based on type


      let effects = ensureOwnEffectMap(this, type)[property];

      if (!effects) {
        effects = this[type][property] = [];
      }

      effects.push(effect);
    }
    /**
     * Removes the given property effect.
     *
     * @param {string} property Property the effect was associated with
     * @param {string} type Effect type, from this.PROPERTY_EFFECT_TYPES
     * @param {Object=} effect Effect metadata object to remove
     * @return {void}
     */


    _removePropertyEffect(property, type, effect) {
      let effects = ensureOwnEffectMap(this, type)[property];
      let idx = effects.indexOf(effect);

      if (idx >= 0) {
        effects.splice(idx, 1);
      }
    }
    /**
     * Returns whether the current prototype/instance has a property effect
     * of a certain type.
     *
     * @param {string} property Property name
     * @param {string=} type Effect type, from this.PROPERTY_EFFECT_TYPES
     * @return {boolean} True if the prototype/instance has an effect of this type
     * @protected
     */


    _hasPropertyEffect(property, type) {
      let effects = this[type];
      return Boolean(effects && effects[property]);
    }
    /**
     * Returns whether the current prototype/instance has a "read only"
     * accessor for the given property.
     *
     * @param {string} property Property name
     * @return {boolean} True if the prototype/instance has an effect of this type
     * @protected
     */


    _hasReadOnlyEffect(property) {
      return this._hasPropertyEffect(property, TYPES.READ_ONLY);
    }
    /**
     * Returns whether the current prototype/instance has a "notify"
     * property effect for the given property.
     *
     * @param {string} property Property name
     * @return {boolean} True if the prototype/instance has an effect of this type
     * @protected
     */


    _hasNotifyEffect(property) {
      return this._hasPropertyEffect(property, TYPES.NOTIFY);
    }
    /**
     * Returns whether the current prototype/instance has a "reflect to attribute"
     * property effect for the given property.
     *
     * @param {string} property Property name
     * @return {boolean} True if the prototype/instance has an effect of this type
     * @protected
     */


    _hasReflectEffect(property) {
      return this._hasPropertyEffect(property, TYPES.REFLECT);
    }
    /**
     * Returns whether the current prototype/instance has a "computed"
     * property effect for the given property.
     *
     * @param {string} property Property name
     * @return {boolean} True if the prototype/instance has an effect of this type
     * @protected
     */


    _hasComputedEffect(property) {
      return this._hasPropertyEffect(property, TYPES.COMPUTE);
    } // Runtime ----------------------------------------

    /**
     * Sets a pending property or path.  If the root property of the path in
     * question had no accessor, the path is set, otherwise it is enqueued
     * via `_setPendingProperty`.
     *
     * This function isolates relatively expensive functionality necessary
     * for the public API (`set`, `setProperties`, `notifyPath`, and property
     * change listeners via {{...}} bindings), such that it is only done
     * when paths enter the system, and not at every propagation step.  It
     * also sets a `__dataHasPaths` flag on the instance which is used to
     * fast-path slower path-matching code in the property effects host paths.
     *
     * `path` can be a path string or array of path parts as accepted by the
     * public API.
     *
     * @param {string | !Array<number|string>} path Path to set
     * @param {*} value Value to set
     * @param {boolean=} shouldNotify Set to true if this change should
     *  cause a property notification event dispatch
     * @param {boolean=} isPathNotification If the path being set is a path
     *   notification of an already changed value, as opposed to a request
     *   to set and notify the change.  In the latter `false` case, a dirty
     *   check is performed and then the value is set to the path before
     *   enqueuing the pending property change.
     * @return {boolean} Returns true if the property/path was enqueued in
     *   the pending changes bag.
     * @protected
     */


    _setPendingPropertyOrPath(path, value, shouldNotify, isPathNotification) {
      if (isPathNotification || Object(_utils_path_js__WEBPACK_IMPORTED_MODULE_2__["root"])(Array.isArray(path) ? path[0] : path) !== path) {
        // Dirty check changes being set to a path against the actual object,
        // since this is the entry point for paths into the system; from here
        // the only dirty checks are against the `__dataTemp` cache to prevent
        // duplicate work in the same turn only. Note, if this was a notification
        // of a change already set to a path (isPathNotification: true),
        // we always let the change through and skip the `set` since it was
        // already dirty checked at the point of entry and the underlying
        // object has already been updated
        if (!isPathNotification) {
          let old = Object(_utils_path_js__WEBPACK_IMPORTED_MODULE_2__["get"])(this, path);
          path =
          /** @type {string} */
          Object(_utils_path_js__WEBPACK_IMPORTED_MODULE_2__["set"])(this, path, value); // Use property-accessor's simpler dirty check

          if (!path || !super._shouldPropertyChange(path, value, old)) {
            return false;
          }
        }

        this.__dataHasPaths = true;

        if (this._setPendingProperty(
        /**@type{string}*/
        path, value, shouldNotify)) {
          computeLinkedPaths(this, path, value);
          return true;
        }
      } else {
        if (this.__dataHasAccessor && this.__dataHasAccessor[path]) {
          return this._setPendingProperty(
          /**@type{string}*/
          path, value, shouldNotify);
        } else {
          this[path] = value;
        }
      }

      return false;
    }
    /**
     * Applies a value to a non-Polymer element/node's property.
     *
     * The implementation makes a best-effort at binding interop:
     * Some native element properties have side-effects when
     * re-setting the same value (e.g. setting `<input>.value` resets the
     * cursor position), so we do a dirty-check before setting the value.
     * However, for better interop with non-Polymer custom elements that
     * accept objects, we explicitly re-set object changes coming from the
     * Polymer world (which may include deep object changes without the
     * top reference changing), erring on the side of providing more
     * information.
     *
     * Users may override this method to provide alternate approaches.
     *
     * @param {!Node} node The node to set a property on
     * @param {string} prop The property to set
     * @param {*} value The value to set
     * @return {void}
     * @protected
     */


    _setUnmanagedPropertyToNode(node, prop, value) {
      // It is a judgment call that resetting primitives is
      // "bad" and resettings objects is also "good"; alternatively we could
      // implement a whitelist of tag & property values that should never
      // be reset (e.g. <input>.value && <select>.value)
      if (value !== node[prop] || typeof value == 'object') {
        node[prop] = value;
      }
    }
    /**
     * Overrides the `PropertiesChanged` implementation to introduce special
     * dirty check logic depending on the property & value being set:
     *
     * 1. Any value set to a path (e.g. 'obj.prop': 42 or 'obj.prop': {...})
     *    Stored in `__dataTemp`, dirty checked against `__dataTemp`
     * 2. Object set to simple property (e.g. 'prop': {...})
     *    Stored in `__dataTemp` and `__data`, dirty checked against
     *    `__dataTemp` by default implementation of `_shouldPropertyChange`
     * 3. Primitive value set to simple property (e.g. 'prop': 42)
     *    Stored in `__data`, dirty checked against `__data`
     *
     * The dirty-check is important to prevent cycles due to two-way
     * notification, but paths and objects are only dirty checked against any
     * previous value set during this turn via a "temporary cache" that is
     * cleared when the last `_propertiesChanged` exits. This is so:
     * a. any cached array paths (e.g. 'array.3.prop') may be invalidated
     *    due to array mutations like shift/unshift/splice; this is fine
     *    since path changes are dirty-checked at user entry points like `set`
     * b. dirty-checking for objects only lasts one turn to allow the user
     *    to mutate the object in-place and re-set it with the same identity
     *    and have all sub-properties re-propagated in a subsequent turn.
     *
     * The temp cache is not necessarily sufficient to prevent invalid array
     * paths, since a splice can happen during the same turn (with pathological
     * user code); we could introduce a "fixup" for temporarily cached array
     * paths if needed: https://github.com/Polymer/polymer/issues/4227
     *
     * @override
     * @param {string} property Name of the property
     * @param {*} value Value to set
     * @param {boolean=} shouldNotify True if property should fire notification
     *   event (applies only for `notify: true` properties)
     * @return {boolean} Returns true if the property changed
     */


    _setPendingProperty(property, value, shouldNotify) {
      let propIsPath = this.__dataHasPaths && Object(_utils_path_js__WEBPACK_IMPORTED_MODULE_2__["isPath"])(property);
      let prevProps = propIsPath ? this.__dataTemp : this.__data;

      if (this._shouldPropertyChange(property, value, prevProps[property])) {
        if (!this.__dataPending) {
          this.__dataPending = {};
          this.__dataOld = {};
        } // Ensure old is captured from the last turn


        if (!(property in this.__dataOld)) {
          this.__dataOld[property] = this.__data[property];
        } // Paths are stored in temporary cache (cleared at end of turn),
        // which is used for dirty-checking, all others stored in __data


        if (propIsPath) {
          this.__dataTemp[property] = value;
        } else {
          this.__data[property] = value;
        } // All changes go into pending property bag, passed to _propertiesChanged


        this.__dataPending[property] = value; // Track properties that should notify separately

        if (propIsPath || this[TYPES.NOTIFY] && this[TYPES.NOTIFY][property]) {
          this.__dataToNotify = this.__dataToNotify || {};
          this.__dataToNotify[property] = shouldNotify;
        }

        return true;
      }

      return false;
    }
    /**
     * Overrides base implementation to ensure all accessors set `shouldNotify`
     * to true, for per-property notification tracking.
     *
     * @override
     * @param {string} property Name of the property
     * @param {*} value Value to set
     * @return {void}
     */


    _setProperty(property, value) {
      if (this._setPendingProperty(property, value, true)) {
        this._invalidateProperties();
      }
    }
    /**
     * Overrides `PropertyAccessor`'s default async queuing of
     * `_propertiesChanged`: if `__dataReady` is false (has not yet been
     * manually flushed), the function no-ops; otherwise flushes
     * `_propertiesChanged` synchronously.
     *
     * @override
     * @return {void}
     */


    _invalidateProperties() {
      if (this.__dataReady) {
        this._flushProperties();
      }
    }
    /**
     * Enqueues the given client on a list of pending clients, whose
     * pending property changes can later be flushed via a call to
     * `_flushClients`.
     *
     * @param {Object} client PropertyEffects client to enqueue
     * @return {void}
     * @protected
     */


    _enqueueClient(client) {
      this.__dataPendingClients = this.__dataPendingClients || [];

      if (client !== this) {
        this.__dataPendingClients.push(client);
      }
    }
    /**
     * Overrides superclass implementation.
     *
     * @return {void}
     * @protected
     */


    _flushProperties() {
      this.__dataCounter++;

      super._flushProperties();

      this.__dataCounter--;
    }
    /**
     * Flushes any clients previously enqueued via `_enqueueClient`, causing
     * their `_flushProperties` method to run.
     *
     * @return {void}
     * @protected
     */


    _flushClients() {
      if (!this.__dataClientsReady) {
        this.__dataClientsReady = true;

        this._readyClients(); // Override point where accessors are turned on; importantly,
        // this is after clients have fully readied, providing a guarantee
        // that any property effects occur only after all clients are ready.


        this.__dataReady = true;
      } else {
        this.__enableOrFlushClients();
      }
    } // NOTE: We ensure clients either enable or flush as appropriate. This
    // handles two corner cases:
    // (1) clients flush properly when connected/enabled before the host
    // enables; e.g.
    //   (a) Templatize stamps with no properties and does not flush and
    //   (b) the instance is inserted into dom and
    //   (c) then the instance flushes.
    // (2) clients enable properly when not connected/enabled when the host
    // flushes; e.g.
    //   (a) a template is runtime stamped and not yet connected/enabled
    //   (b) a host sets a property, causing stamped dom to flush
    //   (c) the stamped dom enables.


    __enableOrFlushClients() {
      let clients = this.__dataPendingClients;

      if (clients) {
        this.__dataPendingClients = null;

        for (let i = 0; i < clients.length; i++) {
          let client = clients[i];

          if (!client.__dataEnabled) {
            client._enableProperties();
          } else if (client.__dataPending) {
            client._flushProperties();
          }
        }
      }
    }
    /**
     * Perform any initial setup on client dom. Called before the first
     * `_flushProperties` call on client dom and before any element
     * observers are called.
     *
     * @return {void}
     * @protected
     */


    _readyClients() {
      this.__enableOrFlushClients();
    }
    /**
     * Sets a bag of property changes to this instance, and
     * synchronously processes all effects of the properties as a batch.
     *
     * Property names must be simple properties, not paths.  Batched
     * path propagation is not supported.
     *
     * @param {Object} props Bag of one or more key-value pairs whose key is
     *   a property and value is the new value to set for that property.
     * @param {boolean=} setReadOnly When true, any private values set in
     *   `props` will be set. By default, `setProperties` will not set
     *   `readOnly: true` root properties.
     * @return {void}
     * @public
     */


    setProperties(props, setReadOnly) {
      for (let path in props) {
        if (setReadOnly || !this[TYPES.READ_ONLY] || !this[TYPES.READ_ONLY][path]) {
          //TODO(kschaaf): explicitly disallow paths in setProperty?
          // wildcard observers currently only pass the first changed path
          // in the `info` object, and you could do some odd things batching
          // paths, e.g. {'foo.bar': {...}, 'foo': null}
          this._setPendingPropertyOrPath(path, props[path], true);
        }
      }

      this._invalidateProperties();
    }
    /**
     * Overrides `PropertyAccessors` so that property accessor
     * side effects are not enabled until after client dom is fully ready.
     * Also calls `_flushClients` callback to ensure client dom is enabled
     * that was not enabled as a result of flushing properties.
     *
     * @override
     * @return {void}
     */


    ready() {
      // It is important that `super.ready()` is not called here as it
      // immediately turns on accessors. Instead, we wait until `readyClients`
      // to enable accessors to provide a guarantee that clients are ready
      // before processing any accessors side effects.
      this._flushProperties(); // If no data was pending, `_flushProperties` will not `flushClients`
      // so ensure this is done.


      if (!this.__dataClientsReady) {
        this._flushClients();
      } // Before ready, client notifications do not trigger _flushProperties.
      // Therefore a flush is necessary here if data has been set.


      if (this.__dataPending) {
        this._flushProperties();
      }
    }
    /**
     * Implements `PropertyAccessors`'s properties changed callback.
     *
     * Runs each class of effects for the batch of changed properties in
     * a specific order (compute, propagate, reflect, observe, notify).
     *
     * @param {!Object} currentProps Bag of all current accessor values
     * @param {?Object} changedProps Bag of properties changed since the last
     *   call to `_propertiesChanged`
     * @param {?Object} oldProps Bag of previous values for each property
     *   in `changedProps`
     * @return {void}
     */


    _propertiesChanged(currentProps, changedProps, oldProps) {
      // ----------------------------
      // let c = Object.getOwnPropertyNames(changedProps || {});
      // window.debug && console.group(this.localName + '#' + this.id + ': ' + c);
      // if (window.debug) { debugger; }
      // ----------------------------
      let hasPaths = this.__dataHasPaths;
      this.__dataHasPaths = false; // Compute properties

      runComputedEffects(this, changedProps, oldProps, hasPaths); // Clear notify properties prior to possible reentry (propagate, observe),
      // but after computing effects have a chance to add to them

      let notifyProps = this.__dataToNotify;
      this.__dataToNotify = null; // Propagate properties to clients

      this._propagatePropertyChanges(changedProps, oldProps, hasPaths); // Flush clients


      this._flushClients(); // Reflect properties


      runEffects(this, this[TYPES.REFLECT], changedProps, oldProps, hasPaths); // Observe properties

      runEffects(this, this[TYPES.OBSERVE], changedProps, oldProps, hasPaths); // Notify properties to host

      if (notifyProps) {
        runNotifyEffects(this, notifyProps, changedProps, oldProps, hasPaths);
      } // Clear temporary cache at end of turn


      if (this.__dataCounter == 1) {
        this.__dataTemp = {};
      } // ----------------------------
      // window.debug && console.groupEnd(this.localName + '#' + this.id + ': ' + c);
      // ----------------------------

    }
    /**
     * Called to propagate any property changes to stamped template nodes
     * managed by this element.
     *
     * @param {Object} changedProps Bag of changed properties
     * @param {Object} oldProps Bag of previous values for changed properties
     * @param {boolean} hasPaths True with `props` contains one or more paths
     * @return {void}
     * @protected
     */


    _propagatePropertyChanges(changedProps, oldProps, hasPaths) {
      if (this[TYPES.PROPAGATE]) {
        runEffects(this, this[TYPES.PROPAGATE], changedProps, oldProps, hasPaths);
      }

      let templateInfo = this.__templateInfo;

      while (templateInfo) {
        runEffects(this, templateInfo.propertyEffects, changedProps, oldProps, hasPaths, templateInfo.nodeList);
        templateInfo = templateInfo.nextTemplateInfo;
      }
    }
    /**
     * Aliases one data path as another, such that path notifications from one
     * are routed to the other.
     *
     * @param {string | !Array<string|number>} to Target path to link.
     * @param {string | !Array<string|number>} from Source path to link.
     * @return {void}
     * @public
     */


    linkPaths(to, from) {
      to = Object(_utils_path_js__WEBPACK_IMPORTED_MODULE_2__["normalize"])(to);
      from = Object(_utils_path_js__WEBPACK_IMPORTED_MODULE_2__["normalize"])(from);
      this.__dataLinkedPaths = this.__dataLinkedPaths || {};
      this.__dataLinkedPaths[to] = from;
    }
    /**
     * Removes a data path alias previously established with `_linkPaths`.
     *
     * Note, the path to unlink should be the target (`to`) used when
     * linking the paths.
     *
     * @param {string | !Array<string|number>} path Target path to unlink.
     * @return {void}
     * @public
     */


    unlinkPaths(path) {
      path = Object(_utils_path_js__WEBPACK_IMPORTED_MODULE_2__["normalize"])(path);

      if (this.__dataLinkedPaths) {
        delete this.__dataLinkedPaths[path];
      }
    }
    /**
     * Notify that an array has changed.
     *
     * Example:
     *
     *     this.items = [ {name: 'Jim'}, {name: 'Todd'}, {name: 'Bill'} ];
     *     ...
     *     this.items.splice(1, 1, {name: 'Sam'});
     *     this.items.push({name: 'Bob'});
     *     this.notifySplices('items', [
     *       { index: 1, removed: [{name: 'Todd'}], addedCount: 1, object: this.items, type: 'splice' },
     *       { index: 3, removed: [], addedCount: 1, object: this.items, type: 'splice'}
     *     ]);
     *
     * @param {string} path Path that should be notified.
     * @param {Array} splices Array of splice records indicating ordered
     *   changes that occurred to the array. Each record should have the
     *   following fields:
     *    * index: index at which the change occurred
     *    * removed: array of items that were removed from this index
     *    * addedCount: number of new items added at this index
     *    * object: a reference to the array in question
     *    * type: the string literal 'splice'
     *
     *   Note that splice records _must_ be normalized such that they are
     *   reported in index order (raw results from `Object.observe` are not
     *   ordered and must be normalized/merged before notifying).
     * @return {void}
     * @public
    */


    notifySplices(path, splices) {
      let info = {
        path: ''
      };
      let array =
      /** @type {Array} */
      Object(_utils_path_js__WEBPACK_IMPORTED_MODULE_2__["get"])(this, path, info);
      notifySplices(this, array, info.path, splices);
    }
    /**
     * Convenience method for reading a value from a path.
     *
     * Note, if any part in the path is undefined, this method returns
     * `undefined` (this method does not throw when dereferencing undefined
     * paths).
     *
     * @param {(string|!Array<(string|number)>)} path Path to the value
     *   to read.  The path may be specified as a string (e.g. `foo.bar.baz`)
     *   or an array of path parts (e.g. `['foo.bar', 'baz']`).  Note that
     *   bracketed expressions are not supported; string-based path parts
     *   *must* be separated by dots.  Note that when dereferencing array
     *   indices, the index may be used as a dotted part directly
     *   (e.g. `users.12.name` or `['users', 12, 'name']`).
     * @param {Object=} root Root object from which the path is evaluated.
     * @return {*} Value at the path, or `undefined` if any part of the path
     *   is undefined.
     * @public
     */


    get(path, root) {
      return Object(_utils_path_js__WEBPACK_IMPORTED_MODULE_2__["get"])(root || this, path);
    }
    /**
     * Convenience method for setting a value to a path and notifying any
     * elements bound to the same path.
     *
     * Note, if any part in the path except for the last is undefined,
     * this method does nothing (this method does not throw when
     * dereferencing undefined paths).
     *
     * @param {(string|!Array<(string|number)>)} path Path to the value
     *   to write.  The path may be specified as a string (e.g. `'foo.bar.baz'`)
     *   or an array of path parts (e.g. `['foo.bar', 'baz']`).  Note that
     *   bracketed expressions are not supported; string-based path parts
     *   *must* be separated by dots.  Note that when dereferencing array
     *   indices, the index may be used as a dotted part directly
     *   (e.g. `'users.12.name'` or `['users', 12, 'name']`).
     * @param {*} value Value to set at the specified path.
     * @param {Object=} root Root object from which the path is evaluated.
     *   When specified, no notification will occur.
     * @return {void}
     * @public
    */


    set(path, value, root) {
      if (root) {
        Object(_utils_path_js__WEBPACK_IMPORTED_MODULE_2__["set"])(root, path, value);
      } else {
        if (!this[TYPES.READ_ONLY] || !this[TYPES.READ_ONLY][
        /** @type {string} */
        path]) {
          if (this._setPendingPropertyOrPath(path, value, true)) {
            this._invalidateProperties();
          }
        }
      }
    }
    /**
     * Adds items onto the end of the array at the path specified.
     *
     * The arguments after `path` and return value match that of
     * `Array.prototype.push`.
     *
     * This method notifies other paths to the same array that a
     * splice occurred to the array.
     *
     * @param {string | !Array<string|number>} path Path to array.
     * @param {...*} items Items to push onto array
     * @return {number} New length of the array.
     * @public
     */


    push(path, ...items) {
      let info = {
        path: ''
      };
      let array =
      /** @type {Array}*/
      Object(_utils_path_js__WEBPACK_IMPORTED_MODULE_2__["get"])(this, path, info);
      let len = array.length;
      let ret = array.push(...items);

      if (items.length) {
        notifySplice(this, array, info.path, len, items.length, []);
      }

      return ret;
    }
    /**
     * Removes an item from the end of array at the path specified.
     *
     * The arguments after `path` and return value match that of
     * `Array.prototype.pop`.
     *
     * This method notifies other paths to the same array that a
     * splice occurred to the array.
     *
     * @param {string | !Array<string|number>} path Path to array.
     * @return {*} Item that was removed.
     * @public
     */


    pop(path) {
      let info = {
        path: ''
      };
      let array =
      /** @type {Array} */
      Object(_utils_path_js__WEBPACK_IMPORTED_MODULE_2__["get"])(this, path, info);
      let hadLength = Boolean(array.length);
      let ret = array.pop();

      if (hadLength) {
        notifySplice(this, array, info.path, array.length, 0, [ret]);
      }

      return ret;
    }
    /**
     * Starting from the start index specified, removes 0 or more items
     * from the array and inserts 0 or more new items in their place.
     *
     * The arguments after `path` and return value match that of
     * `Array.prototype.splice`.
     *
     * This method notifies other paths to the same array that a
     * splice occurred to the array.
     *
     * @param {string | !Array<string|number>} path Path to array.
     * @param {number} start Index from which to start removing/inserting.
     * @param {number=} deleteCount Number of items to remove.
     * @param {...*} items Items to insert into array.
     * @return {Array} Array of removed items.
     * @public
     */


    splice(path, start, deleteCount, ...items) {
      let info = {
        path: ''
      };
      let array =
      /** @type {Array} */
      Object(_utils_path_js__WEBPACK_IMPORTED_MODULE_2__["get"])(this, path, info); // Normalize fancy native splice handling of crazy start values

      if (start < 0) {
        start = array.length - Math.floor(-start);
      } else if (start) {
        start = Math.floor(start);
      } // array.splice does different things based on the number of arguments
      // you pass in. Therefore, array.splice(0) and array.splice(0, undefined)
      // do different things. In the former, the whole array is cleared. In the
      // latter, no items are removed.
      // This means that we need to detect whether 1. one of the arguments
      // is actually passed in and then 2. determine how many arguments
      // we should pass on to the native array.splice
      //


      let ret; // Omit any additional arguments if they were not passed in

      if (arguments.length === 2) {
        ret = array.splice(start); // Either start was undefined and the others were defined, but in this
        // case we can safely pass on all arguments
        //
        // Note: this includes the case where none of the arguments were passed in,
        // e.g. this.splice('array'). However, if both start and deleteCount
        // are undefined, array.splice will not modify the array (as expected)
      } else {
        ret = array.splice(start, deleteCount, ...items);
      } // At the end, check whether any items were passed in (e.g. insertions)
      // or if the return array contains items (e.g. deletions).
      // Only notify if items were added or deleted.


      if (items.length || ret.length) {
        notifySplice(this, array, info.path, start, items.length, ret);
      }

      return ret;
    }
    /**
     * Removes an item from the beginning of array at the path specified.
     *
     * The arguments after `path` and return value match that of
     * `Array.prototype.pop`.
     *
     * This method notifies other paths to the same array that a
     * splice occurred to the array.
     *
     * @param {string | !Array<string|number>} path Path to array.
     * @return {*} Item that was removed.
     * @public
     */


    shift(path) {
      let info = {
        path: ''
      };
      let array =
      /** @type {Array} */
      Object(_utils_path_js__WEBPACK_IMPORTED_MODULE_2__["get"])(this, path, info);
      let hadLength = Boolean(array.length);
      let ret = array.shift();

      if (hadLength) {
        notifySplice(this, array, info.path, 0, 0, [ret]);
      }

      return ret;
    }
    /**
     * Adds items onto the beginning of the array at the path specified.
     *
     * The arguments after `path` and return value match that of
     * `Array.prototype.push`.
     *
     * This method notifies other paths to the same array that a
     * splice occurred to the array.
     *
     * @param {string | !Array<string|number>} path Path to array.
     * @param {...*} items Items to insert info array
     * @return {number} New length of the array.
     * @public
     */


    unshift(path, ...items) {
      let info = {
        path: ''
      };
      let array =
      /** @type {Array} */
      Object(_utils_path_js__WEBPACK_IMPORTED_MODULE_2__["get"])(this, path, info);
      let ret = array.unshift(...items);

      if (items.length) {
        notifySplice(this, array, info.path, 0, items.length, []);
      }

      return ret;
    }
    /**
     * Notify that a path has changed.
     *
     * Example:
     *
     *     this.item.user.name = 'Bob';
     *     this.notifyPath('item.user.name');
     *
     * @param {string} path Path that should be notified.
     * @param {*=} value Value at the path (optional).
     * @return {void}
     * @public
    */


    notifyPath(path, value) {
      /** @type {string} */
      let propPath;

      if (arguments.length == 1) {
        // Get value if not supplied
        let info = {
          path: ''
        };
        value = Object(_utils_path_js__WEBPACK_IMPORTED_MODULE_2__["get"])(this, path, info);
        propPath = info.path;
      } else if (Array.isArray(path)) {
        // Normalize path if needed
        propPath = Object(_utils_path_js__WEBPACK_IMPORTED_MODULE_2__["normalize"])(path);
      } else {
        propPath =
        /** @type{string} */
        path;
      }

      if (this._setPendingPropertyOrPath(propPath, value, true, true)) {
        this._invalidateProperties();
      }
    }
    /**
     * Equivalent to static `createReadOnlyProperty` API but can be called on
     * an instance to add effects at runtime.  See that method for
     * full API docs.
     *
     * @param {string} property Property name
     * @param {boolean=} protectedSetter Creates a custom protected setter
     *   when `true`.
     * @return {void}
     * @protected
     */


    _createReadOnlyProperty(property, protectedSetter) {
      this._addPropertyEffect(property, TYPES.READ_ONLY);

      if (protectedSetter) {
        this['_set' + upper(property)] =
        /** @this {PropertyEffects} */
        function (value) {
          this._setProperty(property, value);
        };
      }
    }
    /**
     * Equivalent to static `createPropertyObserver` API but can be called on
     * an instance to add effects at runtime.  See that method for
     * full API docs.
     *
     * @param {string} property Property name
     * @param {string|function(*,*)} method Function or name of observer method to call
     * @param {boolean=} dynamicFn Whether the method name should be included as
     *   a dependency to the effect.
     * @return {void}
     * @protected
     */


    _createPropertyObserver(property, method, dynamicFn) {
      let info = {
        property,
        method,
        dynamicFn: Boolean(dynamicFn)
      };

      this._addPropertyEffect(property, TYPES.OBSERVE, {
        fn: runObserverEffect,
        info,
        trigger: {
          name: property
        }
      });

      if (dynamicFn) {
        this._addPropertyEffect(
        /** @type {string} */
        method, TYPES.OBSERVE, {
          fn: runObserverEffect,
          info,
          trigger: {
            name: method
          }
        });
      }
    }
    /**
     * Equivalent to static `createMethodObserver` API but can be called on
     * an instance to add effects at runtime.  See that method for
     * full API docs.
     *
     * @param {string} expression Method expression
     * @param {boolean|Object=} dynamicFn Boolean or object map indicating
     *   whether method names should be included as a dependency to the effect.
     * @return {void}
     * @protected
     */


    _createMethodObserver(expression, dynamicFn) {
      let sig = parseMethod(expression);

      if (!sig) {
        throw new Error("Malformed observer expression '" + expression + "'");
      }

      createMethodEffect(this, sig, TYPES.OBSERVE, runMethodEffect, null, dynamicFn);
    }
    /**
     * Equivalent to static `createNotifyingProperty` API but can be called on
     * an instance to add effects at runtime.  See that method for
     * full API docs.
     *
     * @param {string} property Property name
     * @return {void}
     * @protected
     */


    _createNotifyingProperty(property) {
      this._addPropertyEffect(property, TYPES.NOTIFY, {
        fn: runNotifyEffect,
        info: {
          eventName: Object(_utils_case_map_js__WEBPACK_IMPORTED_MODULE_3__["camelToDashCase"])(property) + '-changed',
          property: property
        }
      });
    }
    /**
     * Equivalent to static `createReflectedProperty` API but can be called on
     * an instance to add effects at runtime.  See that method for
     * full API docs.
     *
     * @param {string} property Property name
     * @return {void}
     * @protected
     */


    _createReflectedProperty(property) {
      let attr = this.constructor.attributeNameForProperty(property);

      if (attr[0] === '-') {
        console.warn('Property ' + property + ' cannot be reflected to attribute ' + attr + ' because "-" is not a valid starting attribute name. Use a lowercase first letter for the property instead.');
      } else {
        this._addPropertyEffect(property, TYPES.REFLECT, {
          fn: runReflectEffect,
          info: {
            attrName: attr
          }
        });
      }
    }
    /**
     * Equivalent to static `createComputedProperty` API but can be called on
     * an instance to add effects at runtime.  See that method for
     * full API docs.
     *
     * @param {string} property Name of computed property to set
     * @param {string} expression Method expression
     * @param {boolean|Object=} dynamicFn Boolean or object map indicating
     *   whether method names should be included as a dependency to the effect.
     * @return {void}
     * @protected
     */


    _createComputedProperty(property, expression, dynamicFn) {
      let sig = parseMethod(expression);

      if (!sig) {
        throw new Error("Malformed computed expression '" + expression + "'");
      }

      createMethodEffect(this, sig, TYPES.COMPUTE, runComputedEffect, property, dynamicFn);
    }
    /**
     * Gather the argument values for a method specified in the provided array
     * of argument metadata.
     *
     * The `path` and `value` arguments are used to fill in wildcard descriptor
     * when the method is being called as a result of a path notification.
     *
     * @param {!Array<!MethodArg>} args Array of argument metadata
     * @param {string} path Property/path name that triggered the method effect
     * @param {Object} props Bag of current property changes
     * @return {Array<*>} Array of argument values
     * @private
     */


    _marshalArgs(args, path, props) {
      const data = this.__data;
      let values = [];

      for (let i = 0, l = args.length; i < l; i++) {
        let arg = args[i];
        let name = arg.name;
        let v;

        if (arg.literal) {
          v = arg.value;
        } else {
          if (arg.structured) {
            v = Object(_utils_path_js__WEBPACK_IMPORTED_MODULE_2__["get"])(data, name); // when data is not stored e.g. `splices`

            if (v === undefined) {
              v = props[name];
            }
          } else {
            v = data[name];
          }
        }

        if (arg.wildcard) {
          // Only send the actual path changed info if the change that
          // caused the observer to run matched the wildcard
          let baseChanged = name.indexOf(path + '.') === 0;
          let matches = path.indexOf(name) === 0 && !baseChanged;
          values[i] = {
            path: matches ? path : name,
            value: matches ? props[path] : v,
            base: v
          };
        } else {
          values[i] = v;
        }
      }

      return values;
    } // -- static class methods ------------

    /**
     * Ensures an accessor exists for the specified property, and adds
     * to a list of "property effects" that will run when the accessor for
     * the specified property is set.  Effects are grouped by "type", which
     * roughly corresponds to a phase in effect processing.  The effect
     * metadata should be in the following form:
     *
     *     {
     *       fn: effectFunction, // Reference to function to call to perform effect
     *       info: { ... }       // Effect metadata passed to function
     *       trigger: {          // Optional triggering metadata; if not provided
     *         name: string      // the property is treated as a wildcard
     *         structured: boolean
     *         wildcard: boolean
     *       }
     *     }
     *
     * Effects are called from `_propertiesChanged` in the following order by
     * type:
     *
     * 1. COMPUTE
     * 2. PROPAGATE
     * 3. REFLECT
     * 4. OBSERVE
     * 5. NOTIFY
     *
     * Effect functions are called with the following signature:
     *
     *     effectFunction(inst, path, props, oldProps, info, hasPaths)
     *
     * @param {string} property Property that should trigger the effect
     * @param {string} type Effect type, from this.PROPERTY_EFFECT_TYPES
     * @param {Object=} effect Effect metadata object
     * @return {void}
     * @protected
     */


    static addPropertyEffect(property, type, effect) {
      this.prototype._addPropertyEffect(property, type, effect);
    }
    /**
     * Creates a single-property observer for the given property.
     *
     * @param {string} property Property name
     * @param {string|function(*,*)} method Function or name of observer method to call
     * @param {boolean=} dynamicFn Whether the method name should be included as
     *   a dependency to the effect.
     * @return {void}
     * @protected
     */


    static createPropertyObserver(property, method, dynamicFn) {
      this.prototype._createPropertyObserver(property, method, dynamicFn);
    }
    /**
     * Creates a multi-property "method observer" based on the provided
     * expression, which should be a string in the form of a normal JavaScript
     * function signature: `'methodName(arg1, [..., argn])'`.  Each argument
     * should correspond to a property or path in the context of this
     * prototype (or instance), or may be a literal string or number.
     *
     * @param {string} expression Method expression
     * @param {boolean|Object=} dynamicFn Boolean or object map indicating
     * @return {void}
     *   whether method names should be included as a dependency to the effect.
     * @protected
     */


    static createMethodObserver(expression, dynamicFn) {
      this.prototype._createMethodObserver(expression, dynamicFn);
    }
    /**
     * Causes the setter for the given property to dispatch `<property>-changed`
     * events to notify of changes to the property.
     *
     * @param {string} property Property name
     * @return {void}
     * @protected
     */


    static createNotifyingProperty(property) {
      this.prototype._createNotifyingProperty(property);
    }
    /**
     * Creates a read-only accessor for the given property.
     *
     * To set the property, use the protected `_setProperty` API.
     * To create a custom protected setter (e.g. `_setMyProp()` for
     * property `myProp`), pass `true` for `protectedSetter`.
     *
     * Note, if the property will have other property effects, this method
     * should be called first, before adding other effects.
     *
     * @param {string} property Property name
     * @param {boolean=} protectedSetter Creates a custom protected setter
     *   when `true`.
     * @return {void}
     * @protected
     */


    static createReadOnlyProperty(property, protectedSetter) {
      this.prototype._createReadOnlyProperty(property, protectedSetter);
    }
    /**
     * Causes the setter for the given property to reflect the property value
     * to a (dash-cased) attribute of the same name.
     *
     * @param {string} property Property name
     * @return {void}
     * @protected
     */


    static createReflectedProperty(property) {
      this.prototype._createReflectedProperty(property);
    }
    /**
     * Creates a computed property whose value is set to the result of the
     * method described by the given `expression` each time one or more
     * arguments to the method changes.  The expression should be a string
     * in the form of a normal JavaScript function signature:
     * `'methodName(arg1, [..., argn])'`
     *
     * @param {string} property Name of computed property to set
     * @param {string} expression Method expression
     * @param {boolean|Object=} dynamicFn Boolean or object map indicating whether
     *   method names should be included as a dependency to the effect.
     * @return {void}
     * @protected
     */


    static createComputedProperty(property, expression, dynamicFn) {
      this.prototype._createComputedProperty(property, expression, dynamicFn);
    }
    /**
     * Parses the provided template to ensure binding effects are created
     * for them, and then ensures property accessors are created for any
     * dependent properties in the template.  Binding effects for bound
     * templates are stored in a linked list on the instance so that
     * templates can be efficiently stamped and unstamped.
     *
     * @param {!HTMLTemplateElement} template Template containing binding
     *   bindings
     * @return {!TemplateInfo} Template metadata object
     * @protected
     */


    static bindTemplate(template) {
      return this.prototype._bindTemplate(template);
    } // -- binding ----------------------------------------------

    /**
     * Equivalent to static `bindTemplate` API but can be called on
     * an instance to add effects at runtime.  See that method for
     * full API docs.
     *
     * This method may be called on the prototype (for prototypical template
     * binding, to avoid creating accessors every instance) once per prototype,
     * and will be called with `runtimeBinding: true` by `_stampTemplate` to
     * create and link an instance of the template metadata associated with a
     * particular stamping.
     *
     * @param {!HTMLTemplateElement} template Template containing binding
     *   bindings
     * @param {boolean=} instanceBinding When false (default), performs
     *   "prototypical" binding of the template and overwrites any previously
     *   bound template for the class. When true (as passed from
     *   `_stampTemplate`), the template info is instanced and linked into
     *   the list of bound templates.
     * @return {!TemplateInfo} Template metadata object; for `runtimeBinding`,
     *   this is an instance of the prototypical template info
     * @protected
     */


    _bindTemplate(template, instanceBinding) {
      let templateInfo = this.constructor._parseTemplate(template);

      let wasPreBound = this.__templateInfo == templateInfo; // Optimization: since this is called twice for proto-bound templates,
      // don't attempt to recreate accessors if this template was pre-bound

      if (!wasPreBound) {
        for (let prop in templateInfo.propertyEffects) {
          this._createPropertyAccessor(prop);
        }
      }

      if (instanceBinding) {
        // For instance-time binding, create instance of template metadata
        // and link into list of templates if necessary
        templateInfo =
        /** @type {!TemplateInfo} */
        Object.create(templateInfo);
        templateInfo.wasPreBound = wasPreBound;

        if (!wasPreBound && this.__templateInfo) {
          let last = this.__templateInfoLast || this.__templateInfo;
          this.__templateInfoLast = last.nextTemplateInfo = templateInfo;
          templateInfo.previousTemplateInfo = last;
          return templateInfo;
        }
      }

      return this.__templateInfo = templateInfo;
    }
    /**
     * Adds a property effect to the given template metadata, which is run
     * at the "propagate" stage of `_propertiesChanged` when the template
     * has been bound to the element via `_bindTemplate`.
     *
     * The `effect` object should match the format in `_addPropertyEffect`.
     *
     * @param {Object} templateInfo Template metadata to add effect to
     * @param {string} prop Property that should trigger the effect
     * @param {Object=} effect Effect metadata object
     * @return {void}
     * @protected
     */


    static _addTemplatePropertyEffect(templateInfo, prop, effect) {
      let hostProps = templateInfo.hostProps = templateInfo.hostProps || {};
      hostProps[prop] = true;
      let effects = templateInfo.propertyEffects = templateInfo.propertyEffects || {};
      let propEffects = effects[prop] = effects[prop] || [];
      propEffects.push(effect);
    }
    /**
     * Stamps the provided template and performs instance-time setup for
     * Polymer template features, including data bindings, declarative event
     * listeners, and the `this.$` map of `id`'s to nodes.  A document fragment
     * is returned containing the stamped DOM, ready for insertion into the
     * DOM.
     *
     * This method may be called more than once; however note that due to
     * `shadycss` polyfill limitations, only styles from templates prepared
     * using `ShadyCSS.prepareTemplate` will be correctly polyfilled (scoped
     * to the shadow root and support CSS custom properties), and note that
     * `ShadyCSS.prepareTemplate` may only be called once per element. As such,
     * any styles required by in runtime-stamped templates must be included
     * in the main element template.
     *
     * @param {!HTMLTemplateElement} template Template to stamp
     * @return {!StampedTemplate} Cloned template content
     * @override
     * @protected
     */


    _stampTemplate(template) {
      // Ensures that created dom is `_enqueueClient`'d to this element so
      // that it can be flushed on next call to `_flushProperties`
      hostStack.beginHosting(this);

      let dom = super._stampTemplate(template);

      hostStack.endHosting(this);

      let templateInfo =
      /** @type {!TemplateInfo} */
      this._bindTemplate(template, true); // Add template-instance-specific data to instanced templateInfo


      templateInfo.nodeList = dom.nodeList; // Capture child nodes to allow unstamping of non-prototypical templates

      if (!templateInfo.wasPreBound) {
        let nodes = templateInfo.childNodes = [];

        for (let n = dom.firstChild; n; n = n.nextSibling) {
          nodes.push(n);
        }
      }

      dom.templateInfo = templateInfo; // Setup compound storage, 2-way listeners, and dataHost for bindings

      setupBindings(this, templateInfo); // Flush properties into template nodes if already booted

      if (this.__dataReady) {
        runEffects(this, templateInfo.propertyEffects, this.__data, null, false, templateInfo.nodeList);
      }

      return dom;
    }
    /**
     * Removes and unbinds the nodes previously contained in the provided
     * DocumentFragment returned from `_stampTemplate`.
     *
     * @param {!StampedTemplate} dom DocumentFragment previously returned
     *   from `_stampTemplate` associated with the nodes to be removed
     * @return {void}
     * @protected
     */


    _removeBoundDom(dom) {
      // Unlink template info
      let templateInfo = dom.templateInfo;

      if (templateInfo.previousTemplateInfo) {
        templateInfo.previousTemplateInfo.nextTemplateInfo = templateInfo.nextTemplateInfo;
      }

      if (templateInfo.nextTemplateInfo) {
        templateInfo.nextTemplateInfo.previousTemplateInfo = templateInfo.previousTemplateInfo;
      }

      if (this.__templateInfoLast == templateInfo) {
        this.__templateInfoLast = templateInfo.previousTemplateInfo;
      }

      templateInfo.previousTemplateInfo = templateInfo.nextTemplateInfo = null; // Remove stamped nodes

      let nodes = templateInfo.childNodes;

      for (let i = 0; i < nodes.length; i++) {
        let node = nodes[i];
        node.parentNode.removeChild(node);
      }
    }
    /**
     * Overrides default `TemplateStamp` implementation to add support for
     * parsing bindings from `TextNode`'s' `textContent`.  A `bindings`
     * array is added to `nodeInfo` and populated with binding metadata
     * with information capturing the binding target, and a `parts` array
     * with one or more metadata objects capturing the source(s) of the
     * binding.
     *
     * @override
     * @param {Node} node Node to parse
     * @param {TemplateInfo} templateInfo Template metadata for current template
     * @param {NodeInfo} nodeInfo Node metadata for current template node
     * @return {boolean} `true` if the visited node added node-specific
     *   metadata to `nodeInfo`
     * @protected
     * @suppress {missingProperties} Interfaces in closure do not inherit statics, but classes do
     */


    static _parseTemplateNode(node, templateInfo, nodeInfo) {
      let noted = super._parseTemplateNode(node, templateInfo, nodeInfo);

      if (node.nodeType === Node.TEXT_NODE) {
        let parts = this._parseBindings(node.textContent, templateInfo);

        if (parts) {
          // Initialize the textContent with any literal parts
          // NOTE: default to a space here so the textNode remains; some browsers
          // (IE) omit an empty textNode following cloneNode/importNode.
          node.textContent = literalFromParts(parts) || ' ';
          addBinding(this, templateInfo, nodeInfo, 'text', 'textContent', parts);
          noted = true;
        }
      }

      return noted;
    }
    /**
     * Overrides default `TemplateStamp` implementation to add support for
     * parsing bindings from attributes.  A `bindings`
     * array is added to `nodeInfo` and populated with binding metadata
     * with information capturing the binding target, and a `parts` array
     * with one or more metadata objects capturing the source(s) of the
     * binding.
     *
     * @override
     * @param {Element} node Node to parse
     * @param {TemplateInfo} templateInfo Template metadata for current template
     * @param {NodeInfo} nodeInfo Node metadata for current template node
     * @param {string} name Attribute name
     * @param {string} value Attribute value
     * @return {boolean} `true` if the visited node added node-specific
     *   metadata to `nodeInfo`
     * @protected
     * @suppress {missingProperties} Interfaces in closure do not inherit statics, but classes do
     */


    static _parseTemplateNodeAttribute(node, templateInfo, nodeInfo, name, value) {
      let parts = this._parseBindings(value, templateInfo);

      if (parts) {
        // Attribute or property
        let origName = name;
        let kind = 'property'; // The only way we see a capital letter here is if the attr has
        // a capital letter in it per spec. In this case, to make sure
        // this binding works, we go ahead and make the binding to the attribute.

        if (capitalAttributeRegex.test(name)) {
          kind = 'attribute';
        } else if (name[name.length - 1] == '$') {
          name = name.slice(0, -1);
          kind = 'attribute';
        } // Initialize attribute bindings with any literal parts


        let literal = literalFromParts(parts);

        if (literal && kind == 'attribute') {
          node.setAttribute(name, literal);
        } // Clear attribute before removing, since IE won't allow removing
        // `value` attribute if it previously had a value (can't
        // unconditionally set '' before removing since attributes with `$`
        // can't be set using setAttribute)


        if (node.localName === 'input' && origName === 'value') {
          node.setAttribute(origName, '');
        } // Remove annotation


        node.removeAttribute(origName); // Case hackery: attributes are lower-case, but bind targets
        // (properties) are case sensitive. Gambit is to map dash-case to
        // camel-case: `foo-bar` becomes `fooBar`.
        // Attribute bindings are excepted.

        if (kind === 'property') {
          name = Object(_utils_case_map_js__WEBPACK_IMPORTED_MODULE_3__["dashToCamelCase"])(name);
        }

        addBinding(this, templateInfo, nodeInfo, kind, name, parts, literal);
        return true;
      } else {
        return super._parseTemplateNodeAttribute(node, templateInfo, nodeInfo, name, value);
      }
    }
    /**
     * Overrides default `TemplateStamp` implementation to add support for
     * binding the properties that a nested template depends on to the template
     * as `_host_<property>`.
     *
     * @override
     * @param {Node} node Node to parse
     * @param {TemplateInfo} templateInfo Template metadata for current template
     * @param {NodeInfo} nodeInfo Node metadata for current template node
     * @return {boolean} `true` if the visited node added node-specific
     *   metadata to `nodeInfo`
     * @protected
     * @suppress {missingProperties} Interfaces in closure do not inherit statics, but classes do
     */


    static _parseTemplateNestedTemplate(node, templateInfo, nodeInfo) {
      let noted = super._parseTemplateNestedTemplate(node, templateInfo, nodeInfo); // Merge host props into outer template and add bindings


      let hostProps = nodeInfo.templateInfo.hostProps;
      let mode = '{';

      for (let source in hostProps) {
        let parts = [{
          mode,
          source,
          dependencies: [source]
        }];
        addBinding(this, templateInfo, nodeInfo, 'property', '_host_' + source, parts);
      }

      return noted;
    }
    /**
     * Called to parse text in a template (either attribute values or
     * textContent) into binding metadata.
     *
     * Any overrides of this method should return an array of binding part
     * metadata  representing one or more bindings found in the provided text
     * and any "literal" text in between.  Any non-literal parts will be passed
     * to `_evaluateBinding` when any dependencies change.  The only required
     * fields of each "part" in the returned array are as follows:
     *
     * - `dependencies` - Array containing trigger metadata for each property
     *   that should trigger the binding to update
     * - `literal` - String containing text if the part represents a literal;
     *   in this case no `dependencies` are needed
     *
     * Additional metadata for use by `_evaluateBinding` may be provided in
     * each part object as needed.
     *
     * The default implementation handles the following types of bindings
     * (one or more may be intermixed with literal strings):
     * - Property binding: `[[prop]]`
     * - Path binding: `[[object.prop]]`
     * - Negated property or path bindings: `[[!prop]]` or `[[!object.prop]]`
     * - Two-way property or path bindings (supports negation):
     *   `{{prop}}`, `{{object.prop}}`, `{{!prop}}` or `{{!object.prop}}`
     * - Inline computed method (supports negation):
     *   `[[compute(a, 'literal', b)]]`, `[[!compute(a, 'literal', b)]]`
     *
     * The default implementation uses a regular expression for best
     * performance. However, the regular expression uses a white-list of
     * allowed characters in a data-binding, which causes problems for
     * data-bindings that do use characters not in this white-list.
     *
     * Instead of updating the white-list with all allowed characters,
     * there is a StrictBindingParser (see lib/mixins/strict-binding-parser)
     * that uses a state machine instead. This state machine is able to handle
     * all characters. However, it is slightly less performant, therefore we
     * extracted it into a separate optional mixin.
     *
     * @param {string} text Text to parse from attribute or textContent
     * @param {Object} templateInfo Current template metadata
     * @return {Array<!BindingPart>} Array of binding part metadata
     * @protected
     */


    static _parseBindings(text, templateInfo) {
      let parts = [];
      let lastIndex = 0;
      let m; // Example: "literal1{{prop}}literal2[[!compute(foo,bar)]]final"
      // Regex matches:
      //        Iteration 1:  Iteration 2:
      // m[1]: '{{'          '[['
      // m[2]: ''            '!'
      // m[3]: 'prop'        'compute(foo,bar)'

      while ((m = bindingRegex.exec(text)) !== null) {
        // Add literal part
        if (m.index > lastIndex) {
          parts.push({
            literal: text.slice(lastIndex, m.index)
          });
        } // Add binding part


        let mode = m[1][0];
        let negate = Boolean(m[2]);
        let source = m[3].trim();
        let customEvent = false,
            notifyEvent = '',
            colon = -1;

        if (mode == '{' && (colon = source.indexOf('::')) > 0) {
          notifyEvent = source.substring(colon + 2);
          source = source.substring(0, colon);
          customEvent = true;
        }

        let signature = parseMethod(source);
        let dependencies = [];

        if (signature) {
          // Inline computed function
          let {
            args,
            methodName
          } = signature;

          for (let i = 0; i < args.length; i++) {
            let arg = args[i];

            if (!arg.literal) {
              dependencies.push(arg);
            }
          }

          let dynamicFns = templateInfo.dynamicFns;

          if (dynamicFns && dynamicFns[methodName] || signature.static) {
            dependencies.push(methodName);
            signature.dynamicFn = true;
          }
        } else {
          // Property or path
          dependencies.push(source);
        }

        parts.push({
          source,
          mode,
          negate,
          customEvent,
          signature,
          dependencies,
          event: notifyEvent
        });
        lastIndex = bindingRegex.lastIndex;
      } // Add a final literal part


      if (lastIndex && lastIndex < text.length) {
        let literal = text.substring(lastIndex);

        if (literal) {
          parts.push({
            literal: literal
          });
        }
      }

      if (parts.length) {
        return parts;
      } else {
        return null;
      }
    }
    /**
     * Called to evaluate a previously parsed binding part based on a set of
     * one or more changed dependencies.
     *
     * @param {this} inst Element that should be used as scope for
     *   binding dependencies
     * @param {BindingPart} part Binding part metadata
     * @param {string} path Property/path that triggered this effect
     * @param {Object} props Bag of current property changes
     * @param {Object} oldProps Bag of previous values for changed properties
     * @param {boolean} hasPaths True with `props` contains one or more paths
     * @return {*} Value the binding part evaluated to
     * @protected
     */


    static _evaluateBinding(inst, part, path, props, oldProps, hasPaths) {
      let value;

      if (part.signature) {
        value = runMethodEffect(inst, path, props, oldProps, part.signature);
      } else if (path != part.source) {
        value = Object(_utils_path_js__WEBPACK_IMPORTED_MODULE_2__["get"])(inst, part.source);
      } else {
        if (hasPaths && Object(_utils_path_js__WEBPACK_IMPORTED_MODULE_2__["isPath"])(path)) {
          value = Object(_utils_path_js__WEBPACK_IMPORTED_MODULE_2__["get"])(inst, path);
        } else {
          value = inst.__data[path];
        }
      }

      if (part.negate) {
        value = !value;
      }

      return value;
    }

  } // make a typing for closure :P


  PropertyEffectsType = PropertyEffects;
  return PropertyEffects;
});
/**
 * Helper api for enqueuing client dom created by a host element.
 *
 * By default elements are flushed via `_flushProperties` when
 * `connectedCallback` is called. Elements attach their client dom to
 * themselves at `ready` time which results from this first flush.
 * This provides an ordering guarantee that the client dom an element
 * creates is flushed before the element itself (i.e. client `ready`
 * fires before host `ready`).
 *
 * However, if `_flushProperties` is called *before* an element is connected,
 * as for example `Templatize` does, this ordering guarantee cannot be
 * satisfied because no elements are connected. (Note: Bound elements that
 * receive data do become enqueued clients and are properly ordered but
 * unbound elements are not.)
 *
 * To maintain the desired "client before host" ordering guarantee for this
 * case we rely on the "host stack. Client nodes registers themselves with
 * the creating host element when created. This ensures that all client dom
 * is readied in the proper order, maintaining the desired guarantee.
 *
 * @private
 */

class HostStack {
  constructor() {
    this.stack = [];
  }
  /**
   * @param {*} inst Instance to add to hostStack
   * @return {void}
   */


  registerHost(inst) {
    if (this.stack.length) {
      let host = this.stack[this.stack.length - 1];

      host._enqueueClient(inst);
    }
  }
  /**
   * @param {*} inst Instance to begin hosting
   * @return {void}
   */


  beginHosting(inst) {
    this.stack.push(inst);
  }
  /**
   * @param {*} inst Instance to end hosting
   * @return {void}
   */


  endHosting(inst) {
    let stackLen = this.stack.length;

    if (stackLen && this.stack[stackLen - 1] == inst) {
      this.stack.pop();
    }
  }

}

const hostStack = new HostStack();

/***/ }),

/***/ "./node_modules/@polymer/polymer/lib/mixins/template-stamp.js":
/*!********************************************************************!*\
  !*** ./node_modules/@polymer/polymer/lib/mixins/template-stamp.js ***!
  \********************************************************************/
/*! exports provided: TemplateStamp */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "TemplateStamp", function() { return TemplateStamp; });
/* harmony import */ var _utils_boot_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/boot.js */ "./node_modules/@polymer/polymer/lib/utils/boot.js");
/* harmony import */ var _utils_mixin_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/mixin.js */ "./node_modules/@polymer/polymer/lib/utils/mixin.js");
/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/

 // 1.x backwards-compatible auto-wrapper for template type extensions
// This is a clear layering violation and gives favored-nation status to
// dom-if and dom-repeat templates.  This is a conceit we're choosing to keep
// a.) to ease 1.x backwards-compatibility due to loss of `is`, and
// b.) to maintain if/repeat capability in parser-constrained elements
//     (e.g. table, select) in lieu of native CE type extensions without
//     massive new invention in this space (e.g. directive system)

const templateExtensions = {
  'dom-if': true,
  'dom-repeat': true
};

function wrapTemplateExtension(node) {
  let is = node.getAttribute('is');

  if (is && templateExtensions[is]) {
    let t = node;
    t.removeAttribute('is');
    node = t.ownerDocument.createElement(is);
    t.parentNode.replaceChild(node, t);
    node.appendChild(t);

    while (t.attributes.length) {
      node.setAttribute(t.attributes[0].name, t.attributes[0].value);
      t.removeAttribute(t.attributes[0].name);
    }
  }

  return node;
}

function findTemplateNode(root, nodeInfo) {
  // recursively ascend tree until we hit root
  let parent = nodeInfo.parentInfo && findTemplateNode(root, nodeInfo.parentInfo); // unwind the stack, returning the indexed node at each level

  if (parent) {
    // note: marginally faster than indexing via childNodes
    // (http://jsperf.com/childnodes-lookup)
    for (let n = parent.firstChild, i = 0; n; n = n.nextSibling) {
      if (nodeInfo.parentIndex === i++) {
        return n;
      }
    }
  } else {
    return root;
  }
} // construct `$` map (from id annotations)


function applyIdToMap(inst, map, node, nodeInfo) {
  if (nodeInfo.id) {
    map[nodeInfo.id] = node;
  }
} // install event listeners (from event annotations)


function applyEventListener(inst, node, nodeInfo) {
  if (nodeInfo.events && nodeInfo.events.length) {
    for (let j = 0, e$ = nodeInfo.events, e; j < e$.length && (e = e$[j]); j++) {
      inst._addMethodEventListenerToNode(node, e.name, e.value, inst);
    }
  }
} // push configuration references at configure time


function applyTemplateContent(inst, node, nodeInfo) {
  if (nodeInfo.templateInfo) {
    node._templateInfo = nodeInfo.templateInfo;
  }
}

function createNodeEventHandler(context, eventName, methodName) {
  // Instances can optionally have a _methodHost which allows redirecting where
  // to find methods. Currently used by `templatize`.
  context = context._methodHost || context;

  let handler = function (e) {
    if (context[methodName]) {
      context[methodName](e, e.detail);
    } else {
      console.warn('listener method `' + methodName + '` not defined');
    }
  };

  return handler;
}
/**
 * Element mixin that provides basic template parsing and stamping, including
 * the following template-related features for stamped templates:
 *
 * - Declarative event listeners (`on-eventname="listener"`)
 * - Map of node id's to stamped node instances (`this.$.id`)
 * - Nested template content caching/removal and re-installation (performance
 *   optimization)
 *
 * @mixinFunction
 * @polymer
 * @summary Element class mixin that provides basic template parsing and stamping
 */


const TemplateStamp = Object(_utils_mixin_js__WEBPACK_IMPORTED_MODULE_1__["dedupingMixin"])(
/**
 * @template T
 * @param {function(new:T)} superClass Class to apply mixin to.
 * @return {function(new:T)} superClass with mixin applied.
 */
superClass => {
  /**
   * @polymer
   * @mixinClass
   * @implements {Polymer_TemplateStamp}
   */
  class TemplateStamp extends superClass {
    /**
     * Scans a template to produce template metadata.
     *
     * Template-specific metadata are stored in the object returned, and node-
     * specific metadata are stored in objects in its flattened `nodeInfoList`
     * array.  Only nodes in the template that were parsed as nodes of
     * interest contain an object in `nodeInfoList`.  Each `nodeInfo` object
     * contains an `index` (`childNodes` index in parent) and optionally
     * `parent`, which points to node info of its parent (including its index).
     *
     * The template metadata object returned from this method has the following
     * structure (many fields optional):
     *
     * ```js
     *   {
     *     // Flattened list of node metadata (for nodes that generated metadata)
     *     nodeInfoList: [
     *       {
     *         // `id` attribute for any nodes with id's for generating `$` map
     *         id: {string},
     *         // `on-event="handler"` metadata
     *         events: [
     *           {
     *             name: {string},   // event name
     *             value: {string},  // handler method name
     *           }, ...
     *         ],
     *         // Notes when the template contained a `<slot>` for shady DOM
     *         // optimization purposes
     *         hasInsertionPoint: {boolean},
     *         // For nested `<template>`` nodes, nested template metadata
     *         templateInfo: {object}, // nested template metadata
     *         // Metadata to allow efficient retrieval of instanced node
     *         // corresponding to this metadata
     *         parentInfo: {number},   // reference to parent nodeInfo>
     *         parentIndex: {number},  // index in parent's `childNodes` collection
     *         infoIndex: {number},    // index of this `nodeInfo` in `templateInfo.nodeInfoList`
     *       },
     *       ...
     *     ],
     *     // When true, the template had the `strip-whitespace` attribute
     *     // or was nested in a template with that setting
     *     stripWhitespace: {boolean},
     *     // For nested templates, nested template content is moved into
     *     // a document fragment stored here; this is an optimization to
     *     // avoid the cost of nested template cloning
     *     content: {DocumentFragment}
     *   }
     * ```
     *
     * This method kicks off a recursive treewalk as follows:
     *
     * ```
     *    _parseTemplate <---------------------+
     *      _parseTemplateContent              |
     *        _parseTemplateNode  <------------|--+
     *          _parseTemplateNestedTemplate --+  |
     *          _parseTemplateChildNodes ---------+
     *          _parseTemplateNodeAttributes
     *            _parseTemplateNodeAttribute
     *
     * ```
     *
     * These methods may be overridden to add custom metadata about templates
     * to either `templateInfo` or `nodeInfo`.
     *
     * Note that this method may be destructive to the template, in that
     * e.g. event annotations may be removed after being noted in the
     * template metadata.
     *
     * @param {!HTMLTemplateElement} template Template to parse
     * @param {TemplateInfo=} outerTemplateInfo Template metadata from the outer
     *   template, for parsing nested templates
     * @return {!TemplateInfo} Parsed template metadata
     */
    static _parseTemplate(template, outerTemplateInfo) {
      // since a template may be re-used, memo-ize metadata
      if (!template._templateInfo) {
        let templateInfo = template._templateInfo = {};
        templateInfo.nodeInfoList = [];
        templateInfo.stripWhiteSpace = outerTemplateInfo && outerTemplateInfo.stripWhiteSpace || template.hasAttribute('strip-whitespace');

        this._parseTemplateContent(template, templateInfo, {
          parent: null
        });
      }

      return template._templateInfo;
    }

    static _parseTemplateContent(template, templateInfo, nodeInfo) {
      return this._parseTemplateNode(template.content, templateInfo, nodeInfo);
    }
    /**
     * Parses template node and adds template and node metadata based on
     * the current node, and its `childNodes` and `attributes`.
     *
     * This method may be overridden to add custom node or template specific
     * metadata based on this node.
     *
     * @param {Node} node Node to parse
     * @param {!TemplateInfo} templateInfo Template metadata for current template
     * @param {!NodeInfo} nodeInfo Node metadata for current template.
     * @return {boolean} `true` if the visited node added node-specific
     *   metadata to `nodeInfo`
     */


    static _parseTemplateNode(node, templateInfo, nodeInfo) {
      let noted;
      let element =
      /** @type {Element} */
      node;

      if (element.localName == 'template' && !element.hasAttribute('preserve-content')) {
        noted = this._parseTemplateNestedTemplate(element, templateInfo, nodeInfo) || noted;
      } else if (element.localName === 'slot') {
        // For ShadyDom optimization, indicating there is an insertion point
        templateInfo.hasInsertionPoint = true;
      }

      if (element.firstChild) {
        noted = this._parseTemplateChildNodes(element, templateInfo, nodeInfo) || noted;
      }

      if (element.hasAttributes && element.hasAttributes()) {
        noted = this._parseTemplateNodeAttributes(element, templateInfo, nodeInfo) || noted;
      }

      return noted;
    }
    /**
     * Parses template child nodes for the given root node.
     *
     * This method also wraps whitelisted legacy template extensions
     * (`is="dom-if"` and `is="dom-repeat"`) with their equivalent element
     * wrappers, collapses text nodes, and strips whitespace from the template
     * if the `templateInfo.stripWhitespace` setting was provided.
     *
     * @param {Node} root Root node whose `childNodes` will be parsed
     * @param {!TemplateInfo} templateInfo Template metadata for current template
     * @param {!NodeInfo} nodeInfo Node metadata for current template.
     * @return {void}
     */


    static _parseTemplateChildNodes(root, templateInfo, nodeInfo) {
      if (root.localName === 'script' || root.localName === 'style') {
        return;
      }

      for (let node = root.firstChild, parentIndex = 0, next; node; node = next) {
        // Wrap templates
        if (node.localName == 'template') {
          node = wrapTemplateExtension(node);
        } // collapse adjacent textNodes: fixes an IE issue that can cause
        // text nodes to be inexplicably split =(
        // note that root.normalize() should work but does not so we do this
        // manually.


        next = node.nextSibling;

        if (node.nodeType === Node.TEXT_NODE) {
          let
          /** Node */
          n = next;

          while (n && n.nodeType === Node.TEXT_NODE) {
            node.textContent += n.textContent;
            next = n.nextSibling;
            root.removeChild(n);
            n = next;
          } // optionally strip whitespace


          if (templateInfo.stripWhiteSpace && !node.textContent.trim()) {
            root.removeChild(node);
            continue;
          }
        }

        let childInfo = {
          parentIndex,
          parentInfo: nodeInfo
        };

        if (this._parseTemplateNode(node, templateInfo, childInfo)) {
          childInfo.infoIndex = templateInfo.nodeInfoList.push(
          /** @type {!NodeInfo} */
          childInfo) - 1;
        } // Increment if not removed


        if (node.parentNode) {
          parentIndex++;
        }
      }
    }
    /**
     * Parses template content for the given nested `<template>`.
     *
     * Nested template info is stored as `templateInfo` in the current node's
     * `nodeInfo`. `template.content` is removed and stored in `templateInfo`.
     * It will then be the responsibility of the host to set it back to the
     * template and for users stamping nested templates to use the
     * `_contentForTemplate` method to retrieve the content for this template
     * (an optimization to avoid the cost of cloning nested template content).
     *
     * @param {HTMLTemplateElement} node Node to parse (a <template>)
     * @param {TemplateInfo} outerTemplateInfo Template metadata for current template
     *   that includes the template `node`
     * @param {!NodeInfo} nodeInfo Node metadata for current template.
     * @return {boolean} `true` if the visited node added node-specific
     *   metadata to `nodeInfo`
     */


    static _parseTemplateNestedTemplate(node, outerTemplateInfo, nodeInfo) {
      let templateInfo = this._parseTemplate(node, outerTemplateInfo);

      let content = templateInfo.content = node.content.ownerDocument.createDocumentFragment();
      content.appendChild(node.content);
      nodeInfo.templateInfo = templateInfo;
      return true;
    }
    /**
     * Parses template node attributes and adds node metadata to `nodeInfo`
     * for nodes of interest.
     *
     * @param {Element} node Node to parse
     * @param {TemplateInfo} templateInfo Template metadata for current template
     * @param {NodeInfo} nodeInfo Node metadata for current template.
     * @return {boolean} `true` if the visited node added node-specific
     *   metadata to `nodeInfo`
     */


    static _parseTemplateNodeAttributes(node, templateInfo, nodeInfo) {
      // Make copy of original attribute list, since the order may change
      // as attributes are added and removed
      let noted = false;
      let attrs = Array.from(node.attributes);

      for (let i = attrs.length - 1, a; a = attrs[i]; i--) {
        noted = this._parseTemplateNodeAttribute(node, templateInfo, nodeInfo, a.name, a.value) || noted;
      }

      return noted;
    }
    /**
     * Parses a single template node attribute and adds node metadata to
     * `nodeInfo` for attributes of interest.
     *
     * This implementation adds metadata for `on-event="handler"` attributes
     * and `id` attributes.
     *
     * @param {Element} node Node to parse
     * @param {!TemplateInfo} templateInfo Template metadata for current template
     * @param {!NodeInfo} nodeInfo Node metadata for current template.
     * @param {string} name Attribute name
     * @param {string} value Attribute value
     * @return {boolean} `true` if the visited node added node-specific
     *   metadata to `nodeInfo`
     */


    static _parseTemplateNodeAttribute(node, templateInfo, nodeInfo, name, value) {
      // events (on-*)
      if (name.slice(0, 3) === 'on-') {
        node.removeAttribute(name);
        nodeInfo.events = nodeInfo.events || [];
        nodeInfo.events.push({
          name: name.slice(3),
          value
        });
        return true;
      } // static id
      else if (name === 'id') {
          nodeInfo.id = value;
          return true;
        }

      return false;
    }
    /**
     * Returns the `content` document fragment for a given template.
     *
     * For nested templates, Polymer performs an optimization to cache nested
     * template content to avoid the cost of cloning deeply nested templates.
     * This method retrieves the cached content for a given template.
     *
     * @param {HTMLTemplateElement} template Template to retrieve `content` for
     * @return {DocumentFragment} Content fragment
     */


    static _contentForTemplate(template) {
      let templateInfo =
      /** @type {HTMLTemplateElementWithInfo} */
      template._templateInfo;
      return templateInfo && templateInfo.content || template.content;
    }
    /**
     * Clones the provided template content and returns a document fragment
     * containing the cloned dom.
     *
     * The template is parsed (once and memoized) using this library's
     * template parsing features, and provides the following value-added
     * features:
     * * Adds declarative event listeners for `on-event="handler"` attributes
     * * Generates an "id map" for all nodes with id's under `$` on returned
     *   document fragment
     * * Passes template info including `content` back to templates as
     *   `_templateInfo` (a performance optimization to avoid deep template
     *   cloning)
     *
     * Note that the memoized template parsing process is destructive to the
     * template: attributes for bindings and declarative event listeners are
     * removed after being noted in notes, and any nested `<template>.content`
     * is removed and stored in notes as well.
     *
     * @param {!HTMLTemplateElement} template Template to stamp
     * @return {!StampedTemplate} Cloned template content
     * @override
     */


    _stampTemplate(template) {
      // Polyfill support: bootstrap the template if it has not already been
      if (template && !template.content && window.HTMLTemplateElement && HTMLTemplateElement.decorate) {
        HTMLTemplateElement.decorate(template);
      }

      let templateInfo = this.constructor._parseTemplate(template);

      let nodeInfo = templateInfo.nodeInfoList;
      let content = templateInfo.content || template.content;
      let dom =
      /** @type {DocumentFragment} */
      document.importNode(content, true); // NOTE: ShadyDom optimization indicating there is an insertion point

      dom.__noInsertionPoint = !templateInfo.hasInsertionPoint;
      let nodes = dom.nodeList = new Array(nodeInfo.length);
      dom.$ = {};

      for (let i = 0, l = nodeInfo.length, info; i < l && (info = nodeInfo[i]); i++) {
        let node = nodes[i] = findTemplateNode(dom, info);
        applyIdToMap(this, dom.$, node, info);
        applyTemplateContent(this, node, info);
        applyEventListener(this, node, info);
      }

      dom =
      /** @type {!StampedTemplate} */
      dom; // eslint-disable-line no-self-assign

      return dom;
    }
    /**
     * Adds an event listener by method name for the event provided.
     *
     * This method generates a handler function that looks up the method
     * name at handling time.
     *
     * @param {!EventTarget} node Node to add listener on
     * @param {string} eventName Name of event
     * @param {string} methodName Name of method
     * @param {*=} context Context the method will be called on (defaults
     *   to `node`)
     * @return {Function} Generated handler function
     * @override
     */


    _addMethodEventListenerToNode(node, eventName, methodName, context) {
      context = context || node;
      let handler = createNodeEventHandler(context, eventName, methodName);

      this._addEventListenerToNode(node, eventName, handler);

      return handler;
    }
    /**
     * Override point for adding custom or simulated event handling.
     *
     * @param {!EventTarget} node Node to add event listener to
     * @param {string} eventName Name of event
     * @param {function(!Event):void} handler Listener function to add
     * @return {void}
     * @override
     */


    _addEventListenerToNode(node, eventName, handler) {
      node.addEventListener(eventName, handler);
    }
    /**
     * Override point for adding custom or simulated event handling.
     *
     * @param {!EventTarget} node Node to remove event listener from
     * @param {string} eventName Name of event
     * @param {function(!Event):void} handler Listener function to remove
     * @return {void}
     * @override
     */


    _removeEventListenerFromNode(node, eventName, handler) {
      node.removeEventListener(eventName, handler);
    }

  }

  return TemplateStamp;
});

/***/ }),

/***/ "./node_modules/@polymer/polymer/lib/utils/array-splice.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@polymer/polymer/lib/utils/array-splice.js ***!
  \*****************************************************************/
/*! exports provided: calculateSplices */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "calculateSplices", function() { return calculateSplices; });
/* harmony import */ var _boot_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./boot.js */ "./node_modules/@polymer/polymer/lib/utils/boot.js");
/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/


function newSplice(index, removed, addedCount) {
  return {
    index: index,
    removed: removed,
    addedCount: addedCount
  };
}

const EDIT_LEAVE = 0;
const EDIT_UPDATE = 1;
const EDIT_ADD = 2;
const EDIT_DELETE = 3; // Note: This function is *based* on the computation of the Levenshtein
// "edit" distance. The one change is that "updates" are treated as two
// edits - not one. With Array splices, an update is really a delete
// followed by an add. By retaining this, we optimize for "keeping" the
// maximum array items in the original array. For example:
//
//   'xxxx123' -> '123yyyy'
//
// With 1-edit updates, the shortest path would be just to update all seven
// characters. With 2-edit updates, we delete 4, leave 3, and add 4. This
// leaves the substring '123' intact.

function calcEditDistances(current, currentStart, currentEnd, old, oldStart, oldEnd) {
  // "Deletion" columns
  let rowCount = oldEnd - oldStart + 1;
  let columnCount = currentEnd - currentStart + 1;
  let distances = new Array(rowCount); // "Addition" rows. Initialize null column.

  for (let i = 0; i < rowCount; i++) {
    distances[i] = new Array(columnCount);
    distances[i][0] = i;
  } // Initialize null row


  for (let j = 0; j < columnCount; j++) distances[0][j] = j;

  for (let i = 1; i < rowCount; i++) {
    for (let j = 1; j < columnCount; j++) {
      if (equals(current[currentStart + j - 1], old[oldStart + i - 1])) distances[i][j] = distances[i - 1][j - 1];else {
        let north = distances[i - 1][j] + 1;
        let west = distances[i][j - 1] + 1;
        distances[i][j] = north < west ? north : west;
      }
    }
  }

  return distances;
} // This starts at the final weight, and walks "backward" by finding
// the minimum previous weight recursively until the origin of the weight
// matrix.


function spliceOperationsFromEditDistances(distances) {
  let i = distances.length - 1;
  let j = distances[0].length - 1;
  let current = distances[i][j];
  let edits = [];

  while (i > 0 || j > 0) {
    if (i == 0) {
      edits.push(EDIT_ADD);
      j--;
      continue;
    }

    if (j == 0) {
      edits.push(EDIT_DELETE);
      i--;
      continue;
    }

    let northWest = distances[i - 1][j - 1];
    let west = distances[i - 1][j];
    let north = distances[i][j - 1];
    let min;
    if (west < north) min = west < northWest ? west : northWest;else min = north < northWest ? north : northWest;

    if (min == northWest) {
      if (northWest == current) {
        edits.push(EDIT_LEAVE);
      } else {
        edits.push(EDIT_UPDATE);
        current = northWest;
      }

      i--;
      j--;
    } else if (min == west) {
      edits.push(EDIT_DELETE);
      i--;
      current = west;
    } else {
      edits.push(EDIT_ADD);
      j--;
      current = north;
    }
  }

  edits.reverse();
  return edits;
}
/**
 * Splice Projection functions:
 *
 * A splice map is a representation of how a previous array of items
 * was transformed into a new array of items. Conceptually it is a list of
 * tuples of
 *
 *   <index, removed, addedCount>
 *
 * which are kept in ascending index order of. The tuple represents that at
 * the |index|, |removed| sequence of items were removed, and counting forward
 * from |index|, |addedCount| items were added.
 */

/**
 * Lacking individual splice mutation information, the minimal set of
 * splices can be synthesized given the previous state and final state of an
 * array. The basic approach is to calculate the edit distance matrix and
 * choose the shortest path through it.
 *
 * Complexity: O(l * p)
 *   l: The length of the current array
 *   p: The length of the old array
 *
 * @param {!Array} current The current "changed" array for which to
 * calculate splices.
 * @param {number} currentStart Starting index in the `current` array for
 * which splices are calculated.
 * @param {number} currentEnd Ending index in the `current` array for
 * which splices are calculated.
 * @param {!Array} old The original "unchanged" array to compare `current`
 * against to determine splices.
 * @param {number} oldStart Starting index in the `old` array for
 * which splices are calculated.
 * @param {number} oldEnd Ending index in the `old` array for
 * which splices are calculated.
 * @return {!Array} Returns an array of splice record objects. Each of these
 * contains: `index` the location where the splice occurred; `removed`
 * the array of removed items from this location; `addedCount` the number
 * of items added at this location.
 */


function calcSplices(current, currentStart, currentEnd, old, oldStart, oldEnd) {
  let prefixCount = 0;
  let suffixCount = 0;
  let splice;
  let minLength = Math.min(currentEnd - currentStart, oldEnd - oldStart);
  if (currentStart == 0 && oldStart == 0) prefixCount = sharedPrefix(current, old, minLength);
  if (currentEnd == current.length && oldEnd == old.length) suffixCount = sharedSuffix(current, old, minLength - prefixCount);
  currentStart += prefixCount;
  oldStart += prefixCount;
  currentEnd -= suffixCount;
  oldEnd -= suffixCount;
  if (currentEnd - currentStart == 0 && oldEnd - oldStart == 0) return [];

  if (currentStart == currentEnd) {
    splice = newSplice(currentStart, [], 0);

    while (oldStart < oldEnd) splice.removed.push(old[oldStart++]);

    return [splice];
  } else if (oldStart == oldEnd) return [newSplice(currentStart, [], currentEnd - currentStart)];

  let ops = spliceOperationsFromEditDistances(calcEditDistances(current, currentStart, currentEnd, old, oldStart, oldEnd));
  splice = undefined;
  let splices = [];
  let index = currentStart;
  let oldIndex = oldStart;

  for (let i = 0; i < ops.length; i++) {
    switch (ops[i]) {
      case EDIT_LEAVE:
        if (splice) {
          splices.push(splice);
          splice = undefined;
        }

        index++;
        oldIndex++;
        break;

      case EDIT_UPDATE:
        if (!splice) splice = newSplice(index, [], 0);
        splice.addedCount++;
        index++;
        splice.removed.push(old[oldIndex]);
        oldIndex++;
        break;

      case EDIT_ADD:
        if (!splice) splice = newSplice(index, [], 0);
        splice.addedCount++;
        index++;
        break;

      case EDIT_DELETE:
        if (!splice) splice = newSplice(index, [], 0);
        splice.removed.push(old[oldIndex]);
        oldIndex++;
        break;
    }
  }

  if (splice) {
    splices.push(splice);
  }

  return splices;
}

function sharedPrefix(current, old, searchLength) {
  for (let i = 0; i < searchLength; i++) if (!equals(current[i], old[i])) return i;

  return searchLength;
}

function sharedSuffix(current, old, searchLength) {
  let index1 = current.length;
  let index2 = old.length;
  let count = 0;

  while (count < searchLength && equals(current[--index1], old[--index2])) count++;

  return count;
}
/**
 * Returns an array of splice records indicating the minimum edits required
 * to transform the `previous` array into the `current` array.
 *
 * Splice records are ordered by index and contain the following fields:
 * - `index`: index where edit started
 * - `removed`: array of removed items from this index
 * - `addedCount`: number of items added at this index
 *
 * This function is based on the Levenshtein "minimum edit distance"
 * algorithm. Note that updates are treated as removal followed by addition.
 *
 * The worst-case time complexity of this algorithm is `O(l * p)`
 *   l: The length of the current array
 *   p: The length of the previous array
 *
 * However, the worst-case complexity is reduced by an `O(n)` optimization
 * to detect any shared prefix & suffix between the two arrays and only
 * perform the more expensive minimum edit distance calculation over the
 * non-shared portions of the arrays.
 *
 * @function
 * @param {!Array} current The "changed" array for which splices will be
 * calculated.
 * @param {!Array} previous The "unchanged" original array to compare
 * `current` against to determine the splices.
 * @return {!Array} Returns an array of splice record objects. Each of these
 * contains: `index` the location where the splice occurred; `removed`
 * the array of removed items from this location; `addedCount` the number
 * of items added at this location.
 */


function calculateSplices(current, previous) {
  return calcSplices(current, 0, current.length, previous, 0, previous.length);
}

function equals(currentValue, previousValue) {
  return currentValue === previousValue;
}

/***/ }),

/***/ "./node_modules/@polymer/polymer/lib/utils/async.js":
/*!**********************************************************!*\
  !*** ./node_modules/@polymer/polymer/lib/utils/async.js ***!
  \**********************************************************/
/*! exports provided: timeOut, animationFrame, idlePeriod, microTask */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "timeOut", function() { return timeOut; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "animationFrame", function() { return animationFrame; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "idlePeriod", function() { return idlePeriod; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "microTask", function() { return microTask; });
/* harmony import */ var _boot_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./boot.js */ "./node_modules/@polymer/polymer/lib/utils/boot.js");
/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/

/**
 * @fileoverview
 *
 * This module provides a number of strategies for enqueuing asynchronous
 * tasks. Each sub-module provides a standard `run(fn)` interface that returns a
 * handle, and a `cancel(handle)` interface for canceling async tasks before
 * they run.
 *
 * @summary Module that provides a number of strategies for enqueuing
 * asynchronous tasks.
 */
 // Microtask implemented using Mutation Observer

let microtaskCurrHandle = 0;
let microtaskLastHandle = 0;
let microtaskCallbacks = [];
let microtaskNodeContent = 0;
let microtaskNode = document.createTextNode('');
new window.MutationObserver(microtaskFlush).observe(microtaskNode, {
  characterData: true
});

function microtaskFlush() {
  const len = microtaskCallbacks.length;

  for (let i = 0; i < len; i++) {
    let cb = microtaskCallbacks[i];

    if (cb) {
      try {
        cb();
      } catch (e) {
        setTimeout(() => {
          throw e;
        });
      }
    }
  }

  microtaskCallbacks.splice(0, len);
  microtaskLastHandle += len;
}
/**
 * Async interface wrapper around `setTimeout`.
 *
 * @namespace
 * @summary Async interface wrapper around `setTimeout`.
 */


const timeOut = {
  /**
   * Returns a sub-module with the async interface providing the provided
   * delay.
   *
   * @memberof timeOut
   * @param {number=} delay Time to wait before calling callbacks in ms
   * @return {!AsyncInterface} An async timeout interface
   */
  after(delay) {
    return {
      run(fn) {
        return window.setTimeout(fn, delay);
      },

      cancel(handle) {
        window.clearTimeout(handle);
      }

    };
  },

  /**
   * Enqueues a function called in the next task.
   *
   * @memberof timeOut
   * @param {!Function} fn Callback to run
   * @param {number=} delay Delay in milliseconds
   * @return {number} Handle used for canceling task
   */
  run(fn, delay) {
    return window.setTimeout(fn, delay);
  },

  /**
   * Cancels a previously enqueued `timeOut` callback.
   *
   * @memberof timeOut
   * @param {number} handle Handle returned from `run` of callback to cancel
   * @return {void}
   */
  cancel(handle) {
    window.clearTimeout(handle);
  }

};

/**
 * Async interface wrapper around `requestAnimationFrame`.
 *
 * @namespace
 * @summary Async interface wrapper around `requestAnimationFrame`.
 */

const animationFrame = {
  /**
   * Enqueues a function called at `requestAnimationFrame` timing.
   *
   * @memberof animationFrame
   * @param {function(number):void} fn Callback to run
   * @return {number} Handle used for canceling task
   */
  run(fn) {
    return window.requestAnimationFrame(fn);
  },

  /**
   * Cancels a previously enqueued `animationFrame` callback.
   *
   * @memberof animationFrame
   * @param {number} handle Handle returned from `run` of callback to cancel
   * @return {void}
   */
  cancel(handle) {
    window.cancelAnimationFrame(handle);
  }

};

/**
 * Async interface wrapper around `requestIdleCallback`.  Falls back to
 * `setTimeout` on browsers that do not support `requestIdleCallback`.
 *
 * @namespace
 * @summary Async interface wrapper around `requestIdleCallback`.
 */

const idlePeriod = {
  /**
   * Enqueues a function called at `requestIdleCallback` timing.
   *
   * @memberof idlePeriod
   * @param {function(!IdleDeadline):void} fn Callback to run
   * @return {number} Handle used for canceling task
   */
  run(fn) {
    return window.requestIdleCallback ? window.requestIdleCallback(fn) : window.setTimeout(fn, 16);
  },

  /**
   * Cancels a previously enqueued `idlePeriod` callback.
   *
   * @memberof idlePeriod
   * @param {number} handle Handle returned from `run` of callback to cancel
   * @return {void}
   */
  cancel(handle) {
    window.cancelIdleCallback ? window.cancelIdleCallback(handle) : window.clearTimeout(handle);
  }

};

/**
 * Async interface for enqueuing callbacks that run at microtask timing.
 *
 * Note that microtask timing is achieved via a single `MutationObserver`,
 * and thus callbacks enqueued with this API will all run in a single
 * batch, and not interleaved with other microtasks such as promises.
 * Promises are avoided as an implementation choice for the time being
 * due to Safari bugs that cause Promises to lack microtask guarantees.
 *
 * @namespace
 * @summary Async interface for enqueuing callbacks that run at microtask
 *   timing.
 */

const microTask = {
  /**
   * Enqueues a function called at microtask timing.
   *
   * @memberof microTask
   * @param {!Function=} callback Callback to run
   * @return {number} Handle used for canceling task
   */
  run(callback) {
    microtaskNode.textContent = microtaskNodeContent++;
    microtaskCallbacks.push(callback);
    return microtaskCurrHandle++;
  },

  /**
   * Cancels a previously enqueued `microTask` callback.
   *
   * @memberof microTask
   * @param {number} handle Handle returned from `run` of callback to cancel
   * @return {void}
   */
  cancel(handle) {
    const idx = handle - microtaskLastHandle;

    if (idx >= 0) {
      if (!microtaskCallbacks[idx]) {
        throw new Error('invalid async handle: ' + handle);
      }

      microtaskCallbacks[idx] = null;
    }
  }

};


/***/ }),

/***/ "./node_modules/@polymer/polymer/lib/utils/boot.js":
/*!*********************************************************!*\
  !*** ./node_modules/@polymer/polymer/lib/utils/boot.js ***!
  \*********************************************************/
/*! no exports provided */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/

/* eslint-disable no-unused-vars */

/**
 * When using Closure Compiler, JSCompiler_renameProperty(property, object) is replaced by the munged name for object[property]
 * We cannot alias this function, so we have to use a small shim that has the same behavior when not compiling.
 *
 * @param {string} prop Property name
 * @param {?Object} obj Reference object
 * @return {string} Potentially renamed property name
 */
window.JSCompiler_renameProperty = function (prop, obj) {
  return prop;
};
/* eslint-enable */




/***/ }),

/***/ "./node_modules/@polymer/polymer/lib/utils/case-map.js":
/*!*************************************************************!*\
  !*** ./node_modules/@polymer/polymer/lib/utils/case-map.js ***!
  \*************************************************************/
/*! exports provided: dashToCamelCase, camelToDashCase */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "dashToCamelCase", function() { return dashToCamelCase; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "camelToDashCase", function() { return camelToDashCase; });
/* harmony import */ var _boot_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./boot.js */ "./node_modules/@polymer/polymer/lib/utils/boot.js");
/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/

const caseMap = {};
const DASH_TO_CAMEL = /-[a-z]/g;
const CAMEL_TO_DASH = /([A-Z])/g;
/**
 * @fileoverview Module with utilities for converting between "dash-case" and
 * "camelCase" identifiers.
 */

/**
 * Converts "dash-case" identifier (e.g. `foo-bar-baz`) to "camelCase"
 * (e.g. `fooBarBaz`).
 *
 * @param {string} dash Dash-case identifier
 * @return {string} Camel-case representation of the identifier
 */

function dashToCamelCase(dash) {
  return caseMap[dash] || (caseMap[dash] = dash.indexOf('-') < 0 ? dash : dash.replace(DASH_TO_CAMEL, m => m[1].toUpperCase()));
}
/**
 * Converts "camelCase" identifier (e.g. `fooBarBaz`) to "dash-case"
 * (e.g. `foo-bar-baz`).
 *
 * @param {string} camel Camel-case identifier
 * @return {string} Dash-case representation of the identifier
 */

function camelToDashCase(camel) {
  return caseMap[camel] || (caseMap[camel] = camel.replace(CAMEL_TO_DASH, '-$1').toLowerCase());
}

/***/ }),

/***/ "./node_modules/@polymer/polymer/lib/utils/debounce.js":
/*!*************************************************************!*\
  !*** ./node_modules/@polymer/polymer/lib/utils/debounce.js ***!
  \*************************************************************/
/*! exports provided: Debouncer */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Debouncer", function() { return Debouncer; });
/* harmony import */ var _boot_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./boot.js */ "./node_modules/@polymer/polymer/lib/utils/boot.js");
/* harmony import */ var _mixin_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./mixin.js */ "./node_modules/@polymer/polymer/lib/utils/mixin.js");
/* harmony import */ var _async_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./async.js */ "./node_modules/@polymer/polymer/lib/utils/async.js");
/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/



/**
 * @summary Collapse multiple callbacks into one invocation after a timer.
 */

class Debouncer {
  constructor() {
    this._asyncModule = null;
    this._callback = null;
    this._timer = null;
  }
  /**
   * Sets the scheduler; that is, a module with the Async interface,
   * a callback and optional arguments to be passed to the run function
   * from the async module.
   *
   * @param {!AsyncInterface} asyncModule Object with Async interface.
   * @param {function()} callback Callback to run.
   * @return {void}
   */


  setConfig(asyncModule, callback) {
    this._asyncModule = asyncModule;
    this._callback = callback;
    this._timer = this._asyncModule.run(() => {
      this._timer = null;

      this._callback();
    });
  }
  /**
   * Cancels an active debouncer and returns a reference to itself.
   *
   * @return {void}
   */


  cancel() {
    if (this.isActive()) {
      this._asyncModule.cancel(
      /** @type {number} */
      this._timer);

      this._timer = null;
    }
  }
  /**
   * Flushes an active debouncer and returns a reference to itself.
   *
   * @return {void}
   */


  flush() {
    if (this.isActive()) {
      this.cancel();

      this._callback();
    }
  }
  /**
   * Returns true if the debouncer is active.
   *
   * @return {boolean} True if active.
   */


  isActive() {
    return this._timer != null;
  }
  /**
   * Creates a debouncer if no debouncer is passed as a parameter
   * or it cancels an active debouncer otherwise. The following
   * example shows how a debouncer can be called multiple times within a
   * microtask and "debounced" such that the provided callback function is
   * called once. Add this method to a custom element:
   *
   * ```js
   * import {microTask} from '@polymer/polymer/lib/utils/async.js';
   * import {Debouncer} from '@polymer/polymer/lib/utils/debounce.js';
   * // ...
   *
   * _debounceWork() {
   *   this._debounceJob = Debouncer.debounce(this._debounceJob,
   *       microTask, () => this._doWork());
   * }
   * ```
   *
   * If the `_debounceWork` method is called multiple times within the same
   * microtask, the `_doWork` function will be called only once at the next
   * microtask checkpoint.
   *
   * Note: In testing it is often convenient to avoid asynchrony. To accomplish
   * this with a debouncer, you can use `enqueueDebouncer` and
   * `flush`. For example, extend the above example by adding
   * `enqueueDebouncer(this._debounceJob)` at the end of the
   * `_debounceWork` method. Then in a test, call `flush` to ensure
   * the debouncer has completed.
   *
   * @param {Debouncer?} debouncer Debouncer object.
   * @param {!AsyncInterface} asyncModule Object with Async interface
   * @param {function()} callback Callback to run.
   * @return {!Debouncer} Returns a debouncer object.
   */


  static debounce(debouncer, asyncModule, callback) {
    if (debouncer instanceof Debouncer) {
      debouncer.cancel();
    } else {
      debouncer = new Debouncer();
    }

    debouncer.setConfig(asyncModule, callback);
    return debouncer;
  }

}

/***/ }),

/***/ "./node_modules/@polymer/polymer/lib/utils/flattened-nodes-observer.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@polymer/polymer/lib/utils/flattened-nodes-observer.js ***!
  \*****************************************************************************/
/*! exports provided: FlattenedNodesObserver */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FlattenedNodesObserver", function() { return FlattenedNodesObserver; });
/* harmony import */ var _boot_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./boot.js */ "./node_modules/@polymer/polymer/lib/utils/boot.js");
/* harmony import */ var _array_splice_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./array-splice.js */ "./node_modules/@polymer/polymer/lib/utils/array-splice.js");
/* harmony import */ var _async_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./async.js */ "./node_modules/@polymer/polymer/lib/utils/async.js");
/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/



/**
 * Returns true if `node` is a slot element
 * @param {!Node} node Node to test.
 * @return {boolean} Returns true if the given `node` is a slot
 * @private
 */

function isSlot(node) {
  return node.localName === 'slot';
}
/**
 * Class that listens for changes (additions or removals) to
 * "flattened nodes" on a given `node`. The list of flattened nodes consists
 * of a node's children and, for any children that are `<slot>` elements,
 * the expanded flattened list of `assignedNodes`.
 * For example, if the observed node has children `<a></a><slot></slot><b></b>`
 * and the `<slot>` has one `<div>` assigned to it, then the flattened
 * nodes list is `<a></a><div></div><b></b>`. If the `<slot>` has other
 * `<slot>` elements assigned to it, these are flattened as well.
 *
 * The provided `callback` is called whenever any change to this list
 * of flattened nodes occurs, where an addition or removal of a node is
 * considered a change. The `callback` is called with one argument, an object
 * containing an array of any `addedNodes` and `removedNodes`.
 *
 * Note: the callback is called asynchronous to any changes
 * at a microtask checkpoint. This is because observation is performed using
 * `MutationObserver` and the `<slot>` element's `slotchange` event which
 * are asynchronous.
 *
 * An example:
 * ```js
 * class TestSelfObserve extends PolymerElement {
 *   static get is() { return 'test-self-observe';}
 *   connectedCallback() {
 *     super.connectedCallback();
 *     this._observer = new FlattenedNodesObserver(this, (info) => {
 *       this.info = info;
 *     });
 *   }
 *   disconnectedCallback() {
 *     super.disconnectedCallback();
 *     this._observer.disconnect();
 *   }
 * }
 * customElements.define(TestSelfObserve.is, TestSelfObserve);
 * ```
 *
 * @summary Class that listens for changes (additions or removals) to
 * "flattened nodes" on a given `node`.
 */


class FlattenedNodesObserver {
  /**
   * Returns the list of flattened nodes for the given `node`.
   * This list consists of a node's children and, for any children
   * that are `<slot>` elements, the expanded flattened list of `assignedNodes`.
   * For example, if the observed node has children `<a></a><slot></slot><b></b>`
   * and the `<slot>` has one `<div>` assigned to it, then the flattened
   * nodes list is `<a></a><div></div><b></b>`. If the `<slot>` has other
   * `<slot>` elements assigned to it, these are flattened as well.
   *
   * @param {!HTMLElement|!HTMLSlotElement} node The node for which to
   *      return the list of flattened nodes.
   * @return {!Array<!Node>} The list of flattened nodes for the given `node`.
   * @nocollapse See https://github.com/google/closure-compiler/issues/2763
   */
  static getFlattenedNodes(node) {
    if (isSlot(node)) {
      node =
      /** @type {!HTMLSlotElement} */
      node; // eslint-disable-line no-self-assign

      return node.assignedNodes({
        flatten: true
      });
    } else {
      return Array.from(node.childNodes).map(node => {
        if (isSlot(node)) {
          node =
          /** @type {!HTMLSlotElement} */
          node; // eslint-disable-line no-self-assign

          return node.assignedNodes({
            flatten: true
          });
        } else {
          return [node];
        }
      }).reduce((a, b) => a.concat(b), []);
    }
  }
  /**
   * @param {!HTMLElement} target Node on which to listen for changes.
   * @param {?function(this: Element, { target: !HTMLElement, addedNodes: !Array<!Element>, removedNodes: !Array<!Element> }):void} callback Function called when there are additions
   * or removals from the target's list of flattened nodes.
   */


  constructor(target, callback) {
    /**
     * @type {MutationObserver}
     * @private
     */
    this._shadyChildrenObserver = null;
    /**
     * @type {MutationObserver}
     * @private
     */

    this._nativeChildrenObserver = null;
    this._connected = false;
    /**
     * @type {!HTMLElement}
     * @private
     */

    this._target = target;
    this.callback = callback;
    this._effectiveNodes = [];
    this._observer = null;
    this._scheduled = false;
    /**
     * @type {function()}
     * @private
     */

    this._boundSchedule = () => {
      this._schedule();
    };

    this.connect();

    this._schedule();
  }
  /**
   * Activates an observer. This method is automatically called when
   * a `FlattenedNodesObserver` is created. It should only be called to
   * re-activate an observer that has been deactivated via the `disconnect` method.
   *
   * @return {void}
   */


  connect() {
    if (isSlot(this._target)) {
      this._listenSlots([this._target]);
    } else if (this._target.children) {
      this._listenSlots(
      /** @type {!NodeList<!Node>} */
      this._target.children);

      if (window.ShadyDOM) {
        this._shadyChildrenObserver = ShadyDOM.observeChildren(this._target, mutations => {
          this._processMutations(mutations);
        });
      } else {
        this._nativeChildrenObserver = new MutationObserver(mutations => {
          this._processMutations(mutations);
        });

        this._nativeChildrenObserver.observe(this._target, {
          childList: true
        });
      }
    }

    this._connected = true;
  }
  /**
   * Deactivates the flattened nodes observer. After calling this method
   * the observer callback will not be called when changes to flattened nodes
   * occur. The `connect` method may be subsequently called to reactivate
   * the observer.
   *
   * @return {void}
   */


  disconnect() {
    if (isSlot(this._target)) {
      this._unlistenSlots([this._target]);
    } else if (this._target.children) {
      this._unlistenSlots(
      /** @type {!NodeList<!Node>} */
      this._target.children);

      if (window.ShadyDOM && this._shadyChildrenObserver) {
        ShadyDOM.unobserveChildren(this._shadyChildrenObserver);
        this._shadyChildrenObserver = null;
      } else if (this._nativeChildrenObserver) {
        this._nativeChildrenObserver.disconnect();

        this._nativeChildrenObserver = null;
      }
    }

    this._connected = false;
  }
  /**
   * @return {void}
   * @private
   */


  _schedule() {
    if (!this._scheduled) {
      this._scheduled = true;
      _async_js__WEBPACK_IMPORTED_MODULE_2__["microTask"].run(() => this.flush());
    }
  }
  /**
   * @param {Array<MutationRecord>} mutations Mutations signaled by the mutation observer
   * @return {void}
   * @private
   */


  _processMutations(mutations) {
    this._processSlotMutations(mutations);

    this.flush();
  }
  /**
   * @param {Array<MutationRecord>} mutations Mutations signaled by the mutation observer
   * @return {void}
   * @private
   */


  _processSlotMutations(mutations) {
    if (mutations) {
      for (let i = 0; i < mutations.length; i++) {
        let mutation = mutations[i];

        if (mutation.addedNodes) {
          this._listenSlots(mutation.addedNodes);
        }

        if (mutation.removedNodes) {
          this._unlistenSlots(mutation.removedNodes);
        }
      }
    }
  }
  /**
   * Flushes the observer causing any pending changes to be immediately
   * delivered the observer callback. By default these changes are delivered
   * asynchronously at the next microtask checkpoint.
   *
   * @return {boolean} Returns true if any pending changes caused the observer
   * callback to run.
   */


  flush() {
    if (!this._connected) {
      return false;
    }

    if (window.ShadyDOM) {
      ShadyDOM.flush();
    }

    if (this._nativeChildrenObserver) {
      this._processSlotMutations(this._nativeChildrenObserver.takeRecords());
    } else if (this._shadyChildrenObserver) {
      this._processSlotMutations(this._shadyChildrenObserver.takeRecords());
    }

    this._scheduled = false;
    let info = {
      target: this._target,
      addedNodes: [],
      removedNodes: []
    };
    let newNodes = this.constructor.getFlattenedNodes(this._target);
    let splices = Object(_array_splice_js__WEBPACK_IMPORTED_MODULE_1__["calculateSplices"])(newNodes, this._effectiveNodes); // process removals

    for (let i = 0, s; i < splices.length && (s = splices[i]); i++) {
      for (let j = 0, n; j < s.removed.length && (n = s.removed[j]); j++) {
        info.removedNodes.push(n);
      }
    } // process adds


    for (let i = 0, s; i < splices.length && (s = splices[i]); i++) {
      for (let j = s.index; j < s.index + s.addedCount; j++) {
        info.addedNodes.push(newNodes[j]);
      }
    } // update cache


    this._effectiveNodes = newNodes;
    let didFlush = false;

    if (info.addedNodes.length || info.removedNodes.length) {
      didFlush = true;
      this.callback.call(this._target, info);
    }

    return didFlush;
  }
  /**
   * @param {!Array<!Node>|!NodeList<!Node>} nodeList Nodes that could change
   * @return {void}
   * @private
   */


  _listenSlots(nodeList) {
    for (let i = 0; i < nodeList.length; i++) {
      let n = nodeList[i];

      if (isSlot(n)) {
        n.addEventListener('slotchange', this._boundSchedule);
      }
    }
  }
  /**
   * @param {!Array<!Node>|!NodeList<!Node>} nodeList Nodes that could change
   * @return {void}
   * @private
   */


  _unlistenSlots(nodeList) {
    for (let i = 0; i < nodeList.length; i++) {
      let n = nodeList[i];

      if (isSlot(n)) {
        n.removeEventListener('slotchange', this._boundSchedule);
      }
    }
  }

}

/***/ }),

/***/ "./node_modules/@polymer/polymer/lib/utils/flush.js":
/*!**********************************************************!*\
  !*** ./node_modules/@polymer/polymer/lib/utils/flush.js ***!
  \**********************************************************/
/*! exports provided: enqueueDebouncer, flush */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "enqueueDebouncer", function() { return enqueueDebouncer; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "flush", function() { return flush; });
/* harmony import */ var _boot_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./boot.js */ "./node_modules/@polymer/polymer/lib/utils/boot.js");
/* harmony import */ var _utils_debounce_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/debounce.js */ "./node_modules/@polymer/polymer/lib/utils/debounce.js");
/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/

/* eslint-disable no-unused-vars */

 // used in type annotations

/* eslint-enable no-unused-vars */

let debouncerQueue = [];
/**
 * Adds a `Debouncer` to a list of globally flushable tasks.
 *
 * @param {!Debouncer} debouncer Debouncer to enqueue
 * @return {void}
 */

const enqueueDebouncer = function (debouncer) {
  debouncerQueue.push(debouncer);
};

function flushDebouncers() {
  const didFlush = Boolean(debouncerQueue.length);

  while (debouncerQueue.length) {
    try {
      debouncerQueue.shift().flush();
    } catch (e) {
      setTimeout(() => {
        throw e;
      });
    }
  }

  return didFlush;
}
/**
 * Forces several classes of asynchronously queued tasks to flush:
 * - Debouncers added via `enqueueDebouncer`
 * - ShadyDOM distribution
 *
 * @return {void}
 */


const flush = function () {
  let shadyDOM, debouncers;

  do {
    shadyDOM = window.ShadyDOM && ShadyDOM.flush();

    if (window.ShadyCSS && window.ShadyCSS.ScopingShim) {
      window.ShadyCSS.ScopingShim.flush();
    }

    debouncers = flushDebouncers();
  } while (shadyDOM || debouncers);
};

/***/ }),

/***/ "./node_modules/@polymer/polymer/lib/utils/gestures.js":
/*!*************************************************************!*\
  !*** ./node_modules/@polymer/polymer/lib/utils/gestures.js ***!
  \*************************************************************/
/*! exports provided: gestures, recognizers, deepTargetFind, addListener, removeListener, register, setTouchAction, prevent, resetMouseCanceller, findOriginalTarget, add, remove */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "gestures", function() { return gestures; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "recognizers", function() { return recognizers; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "deepTargetFind", function() { return deepTargetFind; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "addListener", function() { return addListener; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "removeListener", function() { return removeListener; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "register", function() { return register; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "setTouchAction", function() { return setTouchAction; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "prevent", function() { return prevent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "resetMouseCanceller", function() { return resetMouseCanceller; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "findOriginalTarget", function() { return findOriginalTarget; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "add", function() { return add; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "remove", function() { return remove; });
/* harmony import */ var _boot_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./boot.js */ "./node_modules/@polymer/polymer/lib/utils/boot.js");
/* harmony import */ var _async_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./async.js */ "./node_modules/@polymer/polymer/lib/utils/async.js");
/* harmony import */ var _debounce_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./debounce.js */ "./node_modules/@polymer/polymer/lib/utils/debounce.js");
/* harmony import */ var _settings_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./settings.js */ "./node_modules/@polymer/polymer/lib/utils/settings.js");
/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/

/**
 * @fileoverview
 *
 * Module for adding listeners to a node for the following normalized
 * cross-platform "gesture" events:
 * - `down` - mouse or touch went down
 * - `up` - mouse or touch went up
 * - `tap` - mouse click or finger tap
 * - `track` - mouse drag or touch move
 *
 * @summary Module for adding cross-platform gesture event listeners.
 */



 // detect native touch action support

let HAS_NATIVE_TA = typeof document.head.style.touchAction === 'string';
let GESTURE_KEY = '__polymerGestures';
let HANDLED_OBJ = '__polymerGesturesHandled';
let TOUCH_ACTION = '__polymerGesturesTouchAction'; // radius for tap and track

let TAP_DISTANCE = 25;
let TRACK_DISTANCE = 5; // number of last N track positions to keep

let TRACK_LENGTH = 2; // Disabling "mouse" handlers for 2500ms is enough

let MOUSE_TIMEOUT = 2500;
let MOUSE_EVENTS = ['mousedown', 'mousemove', 'mouseup', 'click']; // an array of bitmask values for mapping MouseEvent.which to MouseEvent.buttons

let MOUSE_WHICH_TO_BUTTONS = [0, 1, 4, 2];

let MOUSE_HAS_BUTTONS = function () {
  try {
    return new MouseEvent('test', {
      buttons: 1
    }).buttons === 1;
  } catch (e) {
    return false;
  }
}();
/**
 * @param {string} name Possible mouse event name
 * @return {boolean} true if mouse event, false if not
 */


function isMouseEvent(name) {
  return MOUSE_EVENTS.indexOf(name) > -1;
}
/* eslint no-empty: ["error", { "allowEmptyCatch": true }] */
// check for passive event listeners


let SUPPORTS_PASSIVE = false;

(function () {
  try {
    let opts = Object.defineProperty({}, 'passive', {
      get() {
        SUPPORTS_PASSIVE = true;
      }

    });
    window.addEventListener('test', null, opts);
    window.removeEventListener('test', null, opts);
  } catch (e) {}
})();
/**
 * Generate settings for event listeners, dependant on `passiveTouchGestures`
 *
 * @param {string} eventName Event name to determine if `{passive}` option is
 *   needed
 * @return {{passive: boolean} | undefined} Options to use for addEventListener
 *   and removeEventListener
 */


function PASSIVE_TOUCH(eventName) {
  if (isMouseEvent(eventName) || eventName === 'touchend') {
    return;
  }

  if (HAS_NATIVE_TA && SUPPORTS_PASSIVE && _settings_js__WEBPACK_IMPORTED_MODULE_3__["passiveTouchGestures"]) {
    return {
      passive: true
    };
  } else {
    return;
  }
} // Check for touch-only devices


let IS_TOUCH_ONLY = navigator.userAgent.match(/iP(?:[oa]d|hone)|Android/); // keep track of any labels hit by the mouseCanceller

/** @type {!Array<!HTMLLabelElement>} */

const clickedLabels = [];
/** @type {!Object<boolean>} */

const labellable = {
  'button': true,
  'input': true,
  'keygen': true,
  'meter': true,
  'output': true,
  'textarea': true,
  'progress': true,
  'select': true
}; // Defined at https://html.spec.whatwg.org/multipage/form-control-infrastructure.html#enabling-and-disabling-form-controls:-the-disabled-attribute

/** @type {!Object<boolean>} */

const canBeDisabled = {
  'button': true,
  'command': true,
  'fieldset': true,
  'input': true,
  'keygen': true,
  'optgroup': true,
  'option': true,
  'select': true,
  'textarea': true
};
/**
 * @param {HTMLElement} el Element to check labelling status
 * @return {boolean} element can have labels
 */

function canBeLabelled(el) {
  return labellable[el.localName] || false;
}
/**
 * @param {HTMLElement} el Element that may be labelled.
 * @return {!Array<!HTMLLabelElement>} Relevant label for `el`
 */


function matchingLabels(el) {
  let labels = Array.prototype.slice.call(
  /** @type {HTMLInputElement} */
  el.labels || []); // IE doesn't have `labels` and Safari doesn't populate `labels`
  // if element is in a shadowroot.
  // In this instance, finding the non-ancestor labels is enough,
  // as the mouseCancellor code will handle ancstor labels

  if (!labels.length) {
    labels = [];
    let root = el.getRootNode(); // if there is an id on `el`, check for all labels with a matching `for` attribute

    if (el.id) {
      let matching = root.querySelectorAll(`label[for = ${el.id}]`);

      for (let i = 0; i < matching.length; i++) {
        labels.push(
        /** @type {!HTMLLabelElement} */
        matching[i]);
      }
    }
  }

  return labels;
} // touch will make synthetic mouse events
// `preventDefault` on touchend will cancel them,
// but this breaks `<input>` focus and link clicks
// disable mouse handlers for MOUSE_TIMEOUT ms after
// a touchend to ignore synthetic mouse events


let mouseCanceller = function (mouseEvent) {
  // Check for sourceCapabilities, used to distinguish synthetic events
  // if mouseEvent did not come from a device that fires touch events,
  // it was made by a real mouse and should be counted
  // http://wicg.github.io/InputDeviceCapabilities/#dom-inputdevicecapabilities-firestouchevents
  let sc = mouseEvent.sourceCapabilities;

  if (sc && !sc.firesTouchEvents) {
    return;
  } // skip synthetic mouse events


  mouseEvent[HANDLED_OBJ] = {
    skip: true
  }; // disable "ghost clicks"

  if (mouseEvent.type === 'click') {
    let clickFromLabel = false;
    let path = mouseEvent.composedPath && mouseEvent.composedPath();

    if (path) {
      for (let i = 0; i < path.length; i++) {
        if (path[i].nodeType === Node.ELEMENT_NODE) {
          if (path[i].localName === 'label') {
            clickedLabels.push(path[i]);
          } else if (canBeLabelled(path[i])) {
            let ownerLabels = matchingLabels(path[i]); // check if one of the clicked labels is labelling this element

            for (let j = 0; j < ownerLabels.length; j++) {
              clickFromLabel = clickFromLabel || clickedLabels.indexOf(ownerLabels[j]) > -1;
            }
          }
        }

        if (path[i] === POINTERSTATE.mouse.target) {
          return;
        }
      }
    } // if one of the clicked labels was labelling the target element,
    // this is not a ghost click


    if (clickFromLabel) {
      return;
    }

    mouseEvent.preventDefault();
    mouseEvent.stopPropagation();
  }
};
/**
 * @param {boolean=} setup True to add, false to remove.
 * @return {void}
 */


function setupTeardownMouseCanceller(setup) {
  let events = IS_TOUCH_ONLY ? ['click'] : MOUSE_EVENTS;

  for (let i = 0, en; i < events.length; i++) {
    en = events[i];

    if (setup) {
      // reset clickLabels array
      clickedLabels.length = 0;
      document.addEventListener(en, mouseCanceller, true);
    } else {
      document.removeEventListener(en, mouseCanceller, true);
    }
  }
}

function ignoreMouse(e) {
  if (!POINTERSTATE.mouse.mouseIgnoreJob) {
    setupTeardownMouseCanceller(true);
  }

  let unset = function () {
    setupTeardownMouseCanceller();
    POINTERSTATE.mouse.target = null;
    POINTERSTATE.mouse.mouseIgnoreJob = null;
  };

  POINTERSTATE.mouse.target = e.composedPath()[0];
  POINTERSTATE.mouse.mouseIgnoreJob = _debounce_js__WEBPACK_IMPORTED_MODULE_2__["Debouncer"].debounce(POINTERSTATE.mouse.mouseIgnoreJob, _async_js__WEBPACK_IMPORTED_MODULE_1__["timeOut"].after(MOUSE_TIMEOUT), unset);
}
/**
 * @param {MouseEvent} ev event to test for left mouse button down
 * @return {boolean} has left mouse button down
 */


function hasLeftMouseButton(ev) {
  let type = ev.type; // exit early if the event is not a mouse event

  if (!isMouseEvent(type)) {
    return false;
  } // ev.button is not reliable for mousemove (0 is overloaded as both left button and no buttons)
  // instead we use ev.buttons (bitmask of buttons) or fall back to ev.which (deprecated, 0 for no buttons, 1 for left button)


  if (type === 'mousemove') {
    // allow undefined for testing events
    let buttons = ev.buttons === undefined ? 1 : ev.buttons;

    if (ev instanceof window.MouseEvent && !MOUSE_HAS_BUTTONS) {
      buttons = MOUSE_WHICH_TO_BUTTONS[ev.which] || 0;
    } // buttons is a bitmask, check that the left button bit is set (1)


    return Boolean(buttons & 1);
  } else {
    // allow undefined for testing events
    let button = ev.button === undefined ? 0 : ev.button; // ev.button is 0 in mousedown/mouseup/click for left button activation

    return button === 0;
  }
}

function isSyntheticClick(ev) {
  if (ev.type === 'click') {
    // ev.detail is 0 for HTMLElement.click in most browsers
    if (ev.detail === 0) {
      return true;
    } // in the worst case, check that the x/y position of the click is within
    // the bounding box of the target of the event
    // Thanks IE 10 >:(


    let t = _findOriginalTarget(ev); // make sure the target of the event is an element so we can use getBoundingClientRect,
    // if not, just assume it is a synthetic click


    if (!t.nodeType ||
    /** @type {Element} */
    t.nodeType !== Node.ELEMENT_NODE) {
      return true;
    }

    let bcr =
    /** @type {Element} */
    t.getBoundingClientRect(); // use page x/y to account for scrolling

    let x = ev.pageX,
        y = ev.pageY; // ev is a synthetic click if the position is outside the bounding box of the target

    return !(x >= bcr.left && x <= bcr.right && y >= bcr.top && y <= bcr.bottom);
  }

  return false;
}

let POINTERSTATE = {
  mouse: {
    target: null,
    mouseIgnoreJob: null
  },
  touch: {
    x: 0,
    y: 0,
    id: -1,
    scrollDecided: false
  }
};

function firstTouchAction(ev) {
  let ta = 'auto';
  let path = ev.composedPath && ev.composedPath();

  if (path) {
    for (let i = 0, n; i < path.length; i++) {
      n = path[i];

      if (n[TOUCH_ACTION]) {
        ta = n[TOUCH_ACTION];
        break;
      }
    }
  }

  return ta;
}

function trackDocument(stateObj, movefn, upfn) {
  stateObj.movefn = movefn;
  stateObj.upfn = upfn;
  document.addEventListener('mousemove', movefn);
  document.addEventListener('mouseup', upfn);
}

function untrackDocument(stateObj) {
  document.removeEventListener('mousemove', stateObj.movefn);
  document.removeEventListener('mouseup', stateObj.upfn);
  stateObj.movefn = null;
  stateObj.upfn = null;
} // use a document-wide touchend listener to start the ghost-click prevention mechanism
// Use passive event listeners, if supported, to not affect scrolling performance


document.addEventListener('touchend', ignoreMouse, SUPPORTS_PASSIVE ? {
  passive: true
} : false);
/** @type {!Object<string, !GestureRecognizer>} */

const gestures = {};
/** @type {!Array<!GestureRecognizer>} */

const recognizers = [];
/**
 * Finds the element rendered on the screen at the provided coordinates.
 *
 * Similar to `document.elementFromPoint`, but pierces through
 * shadow roots.
 *
 * @param {number} x Horizontal pixel coordinate
 * @param {number} y Vertical pixel coordinate
 * @return {Element} Returns the deepest shadowRoot inclusive element
 * found at the screen position given.
 */

function deepTargetFind(x, y) {
  let node = document.elementFromPoint(x, y);
  let next = node; // this code path is only taken when native ShadowDOM is used
  // if there is a shadowroot, it may have a node at x/y
  // if there is not a shadowroot, exit the loop

  while (next && next.shadowRoot && !window.ShadyDOM) {
    // if there is a node at x/y in the shadowroot, look deeper
    let oldNext = next;
    next = next.shadowRoot.elementFromPoint(x, y); // on Safari, elementFromPoint may return the shadowRoot host

    if (oldNext === next) {
      break;
    }

    if (next) {
      node = next;
    }
  }

  return node;
}
/**
 * a cheaper check than ev.composedPath()[0];
 *
 * @private
 * @param {Event|Touch} ev Event.
 * @return {EventTarget} Returns the event target.
 */

function _findOriginalTarget(ev) {
  // shadowdom
  if (ev.composedPath) {
    const targets =
    /** @type {!Array<!EventTarget>} */
    ev.composedPath(); // It shouldn't be, but sometimes targets is empty (window on Safari).

    return targets.length > 0 ? targets[0] : ev.target;
  } // shadydom


  return ev.target;
}
/**
 * @private
 * @param {Event} ev Event.
 * @return {void}
 */


function _handleNative(ev) {
  let handled;
  let type = ev.type;
  let node = ev.currentTarget;
  let gobj = node[GESTURE_KEY];

  if (!gobj) {
    return;
  }

  let gs = gobj[type];

  if (!gs) {
    return;
  }

  if (!ev[HANDLED_OBJ]) {
    ev[HANDLED_OBJ] = {};

    if (type.slice(0, 5) === 'touch') {
      ev =
      /** @type {TouchEvent} */
      ev; // eslint-disable-line no-self-assign

      let t = ev.changedTouches[0];

      if (type === 'touchstart') {
        // only handle the first finger
        if (ev.touches.length === 1) {
          POINTERSTATE.touch.id = t.identifier;
        }
      }

      if (POINTERSTATE.touch.id !== t.identifier) {
        return;
      }

      if (!HAS_NATIVE_TA) {
        if (type === 'touchstart' || type === 'touchmove') {
          _handleTouchAction(ev);
        }
      }
    }
  }

  handled = ev[HANDLED_OBJ]; // used to ignore synthetic mouse events

  if (handled.skip) {
    return;
  } // reset recognizer state


  for (let i = 0, r; i < recognizers.length; i++) {
    r = recognizers[i];

    if (gs[r.name] && !handled[r.name]) {
      if (r.flow && r.flow.start.indexOf(ev.type) > -1 && r.reset) {
        r.reset();
      }
    }
  } // enforce gesture recognizer order


  for (let i = 0, r; i < recognizers.length; i++) {
    r = recognizers[i];

    if (gs[r.name] && !handled[r.name]) {
      handled[r.name] = true;
      r[type](ev);
    }
  }
}
/**
 * @private
 * @param {TouchEvent} ev Event.
 * @return {void}
 */


function _handleTouchAction(ev) {
  let t = ev.changedTouches[0];
  let type = ev.type;

  if (type === 'touchstart') {
    POINTERSTATE.touch.x = t.clientX;
    POINTERSTATE.touch.y = t.clientY;
    POINTERSTATE.touch.scrollDecided = false;
  } else if (type === 'touchmove') {
    if (POINTERSTATE.touch.scrollDecided) {
      return;
    }

    POINTERSTATE.touch.scrollDecided = true;
    let ta = firstTouchAction(ev);
    let shouldPrevent = false;
    let dx = Math.abs(POINTERSTATE.touch.x - t.clientX);
    let dy = Math.abs(POINTERSTATE.touch.y - t.clientY);

    if (!ev.cancelable) {// scrolling is happening
    } else if (ta === 'none') {
      shouldPrevent = true;
    } else if (ta === 'pan-x') {
      shouldPrevent = dy > dx;
    } else if (ta === 'pan-y') {
      shouldPrevent = dx > dy;
    }

    if (shouldPrevent) {
      ev.preventDefault();
    } else {
      prevent('track');
    }
  }
}
/**
 * Adds an event listener to a node for the given gesture type.
 *
 * @param {!EventTarget} node Node to add listener on
 * @param {string} evType Gesture type: `down`, `up`, `track`, or `tap`
 * @param {!function(!Event):void} handler Event listener function to call
 * @return {boolean} Returns true if a gesture event listener was added.
 */


function addListener(node, evType, handler) {
  if (gestures[evType]) {
    _add(node, evType, handler);

    return true;
  }

  return false;
}
/**
 * Removes an event listener from a node for the given gesture type.
 *
 * @param {!EventTarget} node Node to remove listener from
 * @param {string} evType Gesture type: `down`, `up`, `track`, or `tap`
 * @param {!function(!Event):void} handler Event listener function previously passed to
 *  `addListener`.
 * @return {boolean} Returns true if a gesture event listener was removed.
 */

function removeListener(node, evType, handler) {
  if (gestures[evType]) {
    _remove(node, evType, handler);

    return true;
  }

  return false;
}
/**
 * automate the event listeners for the native events
 *
 * @private
 * @param {!EventTarget} node Node on which to add the event.
 * @param {string} evType Event type to add.
 * @param {function(!Event)} handler Event handler function.
 * @return {void}
 */

function _add(node, evType, handler) {
  let recognizer = gestures[evType];
  let deps = recognizer.deps;
  let name = recognizer.name;
  let gobj = node[GESTURE_KEY];

  if (!gobj) {
    node[GESTURE_KEY] = gobj = {};
  }

  for (let i = 0, dep, gd; i < deps.length; i++) {
    dep = deps[i]; // don't add mouse handlers on iOS because they cause gray selection overlays

    if (IS_TOUCH_ONLY && isMouseEvent(dep) && dep !== 'click') {
      continue;
    }

    gd = gobj[dep];

    if (!gd) {
      gobj[dep] = gd = {
        _count: 0
      };
    }

    if (gd._count === 0) {
      node.addEventListener(dep, _handleNative, PASSIVE_TOUCH(dep));
    }

    gd[name] = (gd[name] || 0) + 1;
    gd._count = (gd._count || 0) + 1;
  }

  node.addEventListener(evType, handler);

  if (recognizer.touchAction) {
    setTouchAction(node, recognizer.touchAction);
  }
}
/**
 * automate event listener removal for native events
 *
 * @private
 * @param {!EventTarget} node Node on which to remove the event.
 * @param {string} evType Event type to remove.
 * @param {function(!Event): void} handler Event handler function.
 * @return {void}
 */


function _remove(node, evType, handler) {
  let recognizer = gestures[evType];
  let deps = recognizer.deps;
  let name = recognizer.name;
  let gobj = node[GESTURE_KEY];

  if (gobj) {
    for (let i = 0, dep, gd; i < deps.length; i++) {
      dep = deps[i];
      gd = gobj[dep];

      if (gd && gd[name]) {
        gd[name] = (gd[name] || 1) - 1;
        gd._count = (gd._count || 1) - 1;

        if (gd._count === 0) {
          node.removeEventListener(dep, _handleNative, PASSIVE_TOUCH(dep));
        }
      }
    }
  }

  node.removeEventListener(evType, handler);
}
/**
 * Registers a new gesture event recognizer for adding new custom
 * gesture event types.
 *
 * @param {!GestureRecognizer} recog Gesture recognizer descriptor
 * @return {void}
 */


function register(recog) {
  recognizers.push(recog);

  for (let i = 0; i < recog.emits.length; i++) {
    gestures[recog.emits[i]] = recog;
  }
}
/**
 * @private
 * @param {string} evName Event name.
 * @return {Object} Returns the gesture for the given event name.
 */

function _findRecognizerByEvent(evName) {
  for (let i = 0, r; i < recognizers.length; i++) {
    r = recognizers[i];

    for (let j = 0, n; j < r.emits.length; j++) {
      n = r.emits[j];

      if (n === evName) {
        return r;
      }
    }
  }

  return null;
}
/**
 * Sets scrolling direction on node.
 *
 * This value is checked on first move, thus it should be called prior to
 * adding event listeners.
 *
 * @param {!EventTarget} node Node to set touch action setting on
 * @param {string} value Touch action value
 * @return {void}
 */


function setTouchAction(node, value) {
  if (HAS_NATIVE_TA && node instanceof HTMLElement) {
    // NOTE: add touchAction async so that events can be added in
    // custom element constructors. Otherwise we run afoul of custom
    // elements restriction against settings attributes (style) in the
    // constructor.
    _async_js__WEBPACK_IMPORTED_MODULE_1__["microTask"].run(() => {
      node.style.touchAction = value;
    });
  }

  node[TOUCH_ACTION] = value;
}
/**
 * Dispatches an event on the `target` element of `type` with the given
 * `detail`.
 * @private
 * @param {!EventTarget} target The element on which to fire an event.
 * @param {string} type The type of event to fire.
 * @param {!Object=} detail The detail object to populate on the event.
 * @return {void}
 */

function _fire(target, type, detail) {
  let ev = new Event(type, {
    bubbles: true,
    cancelable: true,
    composed: true
  });
  ev.detail = detail;
  target.dispatchEvent(ev); // forward `preventDefault` in a clean way

  if (ev.defaultPrevented) {
    let preventer = detail.preventer || detail.sourceEvent;

    if (preventer && preventer.preventDefault) {
      preventer.preventDefault();
    }
  }
}
/**
 * Prevents the dispatch and default action of the given event name.
 *
 * @param {string} evName Event name.
 * @return {void}
 */


function prevent(evName) {
  let recognizer = _findRecognizerByEvent(evName);

  if (recognizer.info) {
    recognizer.info.prevent = true;
  }
}
/**
 * Reset the 2500ms timeout on processing mouse input after detecting touch input.
 *
 * Touch inputs create synthesized mouse inputs anywhere from 0 to 2000ms after the touch.
 * This method should only be called during testing with simulated touch inputs.
 * Calling this method in production may cause duplicate taps or other Gestures.
 *
 * @return {void}
 */

function resetMouseCanceller() {
  if (POINTERSTATE.mouse.mouseIgnoreJob) {
    POINTERSTATE.mouse.mouseIgnoreJob.flush();
  }
}
/* eslint-disable valid-jsdoc */

register({
  name: 'downup',
  deps: ['mousedown', 'touchstart', 'touchend'],
  flow: {
    start: ['mousedown', 'touchstart'],
    end: ['mouseup', 'touchend']
  },
  emits: ['down', 'up'],
  info: {
    movefn: null,
    upfn: null
  },

  /**
   * @this {GestureRecognizer}
   * @return {void}
   */
  reset: function () {
    untrackDocument(this.info);
  },

  /**
   * @this {GestureRecognizer}
   * @param {MouseEvent} e
   * @return {void}
   */
  mousedown: function (e) {
    if (!hasLeftMouseButton(e)) {
      return;
    }

    let t = _findOriginalTarget(e);

    let self = this;

    let movefn = function movefn(e) {
      if (!hasLeftMouseButton(e)) {
        downupFire('up', t, e);
        untrackDocument(self.info);
      }
    };

    let upfn = function upfn(e) {
      if (hasLeftMouseButton(e)) {
        downupFire('up', t, e);
      }

      untrackDocument(self.info);
    };

    trackDocument(this.info, movefn, upfn);
    downupFire('down', t, e);
  },

  /**
   * @this {GestureRecognizer}
   * @param {TouchEvent} e
   * @return {void}
   */
  touchstart: function (e) {
    downupFire('down', _findOriginalTarget(e), e.changedTouches[0], e);
  },

  /**
   * @this {GestureRecognizer}
   * @param {TouchEvent} e
   * @return {void}
   */
  touchend: function (e) {
    downupFire('up', _findOriginalTarget(e), e.changedTouches[0], e);
  }
});
/**
 * @param {string} type
 * @param {EventTarget} target
 * @param {Event|Touch} event
 * @param {Event=} preventer
 * @return {void}
 */

function downupFire(type, target, event, preventer) {
  if (!target) {
    return;
  }

  _fire(target, type, {
    x: event.clientX,
    y: event.clientY,
    sourceEvent: event,
    preventer: preventer,
    prevent: function (e) {
      return prevent(e);
    }
  });
}

register({
  name: 'track',
  touchAction: 'none',
  deps: ['mousedown', 'touchstart', 'touchmove', 'touchend'],
  flow: {
    start: ['mousedown', 'touchstart'],
    end: ['mouseup', 'touchend']
  },
  emits: ['track'],
  info: {
    x: 0,
    y: 0,
    state: 'start',
    started: false,
    moves: [],

    /** @this {GestureInfo} */
    addMove: function (move) {
      if (this.moves.length > TRACK_LENGTH) {
        this.moves.shift();
      }

      this.moves.push(move);
    },
    movefn: null,
    upfn: null,
    prevent: false
  },

  /**
   * @this {GestureRecognizer}
   * @return {void}
   */
  reset: function () {
    this.info.state = 'start';
    this.info.started = false;
    this.info.moves = [];
    this.info.x = 0;
    this.info.y = 0;
    this.info.prevent = false;
    untrackDocument(this.info);
  },

  /**
   * @this {GestureRecognizer}
   * @param {MouseEvent} e
   * @return {void}
   */
  mousedown: function (e) {
    if (!hasLeftMouseButton(e)) {
      return;
    }

    let t = _findOriginalTarget(e);

    let self = this;

    let movefn = function movefn(e) {
      let x = e.clientX,
          y = e.clientY;

      if (trackHasMovedEnough(self.info, x, y)) {
        // first move is 'start', subsequent moves are 'move', mouseup is 'end'
        self.info.state = self.info.started ? e.type === 'mouseup' ? 'end' : 'track' : 'start';

        if (self.info.state === 'start') {
          // if and only if tracking, always prevent tap
          prevent('tap');
        }

        self.info.addMove({
          x: x,
          y: y
        });

        if (!hasLeftMouseButton(e)) {
          // always fire "end"
          self.info.state = 'end';
          untrackDocument(self.info);
        }

        if (t) {
          trackFire(self.info, t, e);
        }

        self.info.started = true;
      }
    };

    let upfn = function upfn(e) {
      if (self.info.started) {
        movefn(e);
      } // remove the temporary listeners


      untrackDocument(self.info);
    }; // add temporary document listeners as mouse retargets


    trackDocument(this.info, movefn, upfn);
    this.info.x = e.clientX;
    this.info.y = e.clientY;
  },

  /**
   * @this {GestureRecognizer}
   * @param {TouchEvent} e
   * @return {void}
   */
  touchstart: function (e) {
    let ct = e.changedTouches[0];
    this.info.x = ct.clientX;
    this.info.y = ct.clientY;
  },

  /**
   * @this {GestureRecognizer}
   * @param {TouchEvent} e
   * @return {void}
   */
  touchmove: function (e) {
    let t = _findOriginalTarget(e);

    let ct = e.changedTouches[0];
    let x = ct.clientX,
        y = ct.clientY;

    if (trackHasMovedEnough(this.info, x, y)) {
      if (this.info.state === 'start') {
        // if and only if tracking, always prevent tap
        prevent('tap');
      }

      this.info.addMove({
        x: x,
        y: y
      });
      trackFire(this.info, t, ct);
      this.info.state = 'track';
      this.info.started = true;
    }
  },

  /**
   * @this {GestureRecognizer}
   * @param {TouchEvent} e
   * @return {void}
   */
  touchend: function (e) {
    let t = _findOriginalTarget(e);

    let ct = e.changedTouches[0]; // only trackend if track was started and not aborted

    if (this.info.started) {
      // reset started state on up
      this.info.state = 'end';
      this.info.addMove({
        x: ct.clientX,
        y: ct.clientY
      });
      trackFire(this.info, t, ct);
    }
  }
});
/**
 * @param {!GestureInfo} info
 * @param {number} x
 * @param {number} y
 * @return {boolean}
 */

function trackHasMovedEnough(info, x, y) {
  if (info.prevent) {
    return false;
  }

  if (info.started) {
    return true;
  }

  let dx = Math.abs(info.x - x);
  let dy = Math.abs(info.y - y);
  return dx >= TRACK_DISTANCE || dy >= TRACK_DISTANCE;
}
/**
 * @param {!GestureInfo} info
 * @param {?EventTarget} target
 * @param {Touch} touch
 * @return {void}
 */


function trackFire(info, target, touch) {
  if (!target) {
    return;
  }

  let secondlast = info.moves[info.moves.length - 2];
  let lastmove = info.moves[info.moves.length - 1];
  let dx = lastmove.x - info.x;
  let dy = lastmove.y - info.y;
  let ddx,
      ddy = 0;

  if (secondlast) {
    ddx = lastmove.x - secondlast.x;
    ddy = lastmove.y - secondlast.y;
  }

  _fire(target, 'track', {
    state: info.state,
    x: touch.clientX,
    y: touch.clientY,
    dx: dx,
    dy: dy,
    ddx: ddx,
    ddy: ddy,
    sourceEvent: touch,
    hover: function () {
      return deepTargetFind(touch.clientX, touch.clientY);
    }
  });
}

register({
  name: 'tap',
  deps: ['mousedown', 'click', 'touchstart', 'touchend'],
  flow: {
    start: ['mousedown', 'touchstart'],
    end: ['click', 'touchend']
  },
  emits: ['tap'],
  info: {
    x: NaN,
    y: NaN,
    prevent: false
  },

  /**
   * @this {GestureRecognizer}
   * @return {void}
   */
  reset: function () {
    this.info.x = NaN;
    this.info.y = NaN;
    this.info.prevent = false;
  },

  /**
   * @this {GestureRecognizer}
   * @param {MouseEvent} e
   * @return {void}
   */
  mousedown: function (e) {
    if (hasLeftMouseButton(e)) {
      this.info.x = e.clientX;
      this.info.y = e.clientY;
    }
  },

  /**
   * @this {GestureRecognizer}
   * @param {MouseEvent} e
   * @return {void}
   */
  click: function (e) {
    if (hasLeftMouseButton(e)) {
      trackForward(this.info, e);
    }
  },

  /**
   * @this {GestureRecognizer}
   * @param {TouchEvent} e
   * @return {void}
   */
  touchstart: function (e) {
    const touch = e.changedTouches[0];
    this.info.x = touch.clientX;
    this.info.y = touch.clientY;
  },

  /**
   * @this {GestureRecognizer}
   * @param {TouchEvent} e
   * @return {void}
   */
  touchend: function (e) {
    trackForward(this.info, e.changedTouches[0], e);
  }
});
/**
 * @param {!GestureInfo} info
 * @param {Event | Touch} e
 * @param {Event=} preventer
 * @return {void}
 */

function trackForward(info, e, preventer) {
  let dx = Math.abs(e.clientX - info.x);
  let dy = Math.abs(e.clientY - info.y); // find original target from `preventer` for TouchEvents, or `e` for MouseEvents

  let t = _findOriginalTarget(preventer || e);

  if (!t || canBeDisabled[
  /** @type {!HTMLElement} */
  t.localName] && t.hasAttribute('disabled')) {
    return;
  } // dx,dy can be NaN if `click` has been simulated and there was no `down` for `start`


  if (isNaN(dx) || isNaN(dy) || dx <= TAP_DISTANCE && dy <= TAP_DISTANCE || isSyntheticClick(e)) {
    // prevent taps from being generated if an event has canceled them
    if (!info.prevent) {
      _fire(t, 'tap', {
        x: e.clientX,
        y: e.clientY,
        sourceEvent: e,
        preventer: preventer
      });
    }
  }
}
/* eslint-enable valid-jsdoc */

/** @deprecated */


const findOriginalTarget = _findOriginalTarget;
/** @deprecated */

const add = addListener;
/** @deprecated */

const remove = removeListener;

/***/ }),

/***/ "./node_modules/@polymer/polymer/lib/utils/html-tag.js":
/*!*************************************************************!*\
  !*** ./node_modules/@polymer/polymer/lib/utils/html-tag.js ***!
  \*************************************************************/
/*! exports provided: html, htmlLiteral */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "html", function() { return html; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "htmlLiteral", function() { return htmlLiteral; });
/* harmony import */ var _boot_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./boot.js */ "./node_modules/@polymer/polymer/lib/utils/boot.js");
/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/

/**
 * Class representing a static string value which can be used to filter
 * strings by asseting that they have been created via this class. The
 * `value` property returns the string passed to the constructor.
 */

class LiteralString {
  constructor(string) {
    /** @type {string} */
    this.value = string.toString();
  }
  /**
   * @return {string} LiteralString string value
   * @override
   */


  toString() {
    return this.value;
  }

}
/**
 * @param {*} value Object to stringify into HTML
 * @return {string} HTML stringified form of `obj`
 */


function literalValue(value) {
  if (value instanceof LiteralString) {
    return (
      /** @type {!LiteralString} */
      value.value
    );
  } else {
    throw new Error(`non-literal value passed to Polymer's htmlLiteral function: ${value}`);
  }
}
/**
 * @param {*} value Object to stringify into HTML
 * @return {string} HTML stringified form of `obj`
 */


function htmlValue(value) {
  if (value instanceof HTMLTemplateElement) {
    return (
      /** @type {!HTMLTemplateElement } */
      value.innerHTML
    );
  } else if (value instanceof LiteralString) {
    return literalValue(value);
  } else {
    throw new Error(`non-template value passed to Polymer's html function: ${value}`);
  }
}
/**
 * A template literal tag that creates an HTML <template> element from the
 * contents of the string.
 *
 * This allows you to write a Polymer Template in JavaScript.
 *
 * Templates can be composed by interpolating `HTMLTemplateElement`s in
 * expressions in the JavaScript template literal. The nested template's
 * `innerHTML` is included in the containing template.  The only other
 * values allowed in expressions are those returned from `htmlLiteral`
 * which ensures only literal values from JS source ever reach the HTML, to
 * guard against XSS risks.
 *
 * All other values are disallowed in expressions to help prevent XSS
 * attacks; however, `htmlLiteral` can be used to compose static
 * string values into templates. This is useful to compose strings into
 * places that do not accept html, like the css text of a `style`
 * element.
 *
 * Example:
 *
 *     static get template() {
 *       return html`
 *         <style>:host{ content:"..." }</style>
 *         <div class="shadowed">${this.partialTemplate}</div>
 *         ${super.template}
 *       `;
 *     }
 *     static get partialTemplate() { return html`<span>Partial!</span>`; }
 *
 * @param {!ITemplateArray} strings Constant parts of tagged template literal
 * @param {...*} values Variable parts of tagged template literal
 * @return {!HTMLTemplateElement} Constructed HTMLTemplateElement
 */


const html = function html(strings, ...values) {
  const template =
  /** @type {!HTMLTemplateElement} */
  document.createElement('template');
  template.innerHTML = values.reduce((acc, v, idx) => acc + htmlValue(v) + strings[idx + 1], strings[0]);
  return template;
};
/**
 * An html literal tag that can be used with `html` to compose.
 * a literal string.
 *
 * Example:
 *
 *     static get template() {
 *       return html`
 *         <style>
 *           :host { display: block; }
 *           ${this.styleTemplate()}
 *         </style>
 *         <div class="shadowed">${staticValue}</div>
 *         ${super.template}
 *       `;
 *     }
 *     static get styleTemplate() {
 *        return htmlLiteral`.shadowed { background: gray; }`;
 *     }
 *
 * @param {!ITemplateArray} strings Constant parts of tagged template literal
 * @param {...*} values Variable parts of tagged template literal
 * @return {!LiteralString} Constructed literal string
 */

const htmlLiteral = function (strings, ...values) {
  return new LiteralString(values.reduce((acc, v, idx) => acc + literalValue(v) + strings[idx + 1], strings[0]));
};

/***/ }),

/***/ "./node_modules/@polymer/polymer/lib/utils/mixin.js":
/*!**********************************************************!*\
  !*** ./node_modules/@polymer/polymer/lib/utils/mixin.js ***!
  \**********************************************************/
/*! exports provided: dedupingMixin */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "dedupingMixin", function() { return dedupingMixin; });
/* harmony import */ var _boot_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./boot.js */ "./node_modules/@polymer/polymer/lib/utils/boot.js");
/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/
 // unique global id for deduping mixins.

let dedupeId = 0;
/**
 * @constructor
 * @extends {Function}
 * @private
 */

function MixinFunction() {}
/** @type {(WeakMap | undefined)} */


MixinFunction.prototype.__mixinApplications;
/** @type {(Object | undefined)} */

MixinFunction.prototype.__mixinSet;
/* eslint-disable valid-jsdoc */

/**
 * Wraps an ES6 class expression mixin such that the mixin is only applied
 * if it has not already been applied its base argument. Also memoizes mixin
 * applications.
 *
 * @template T
 * @param {T} mixin ES6 class expression mixin to wrap
 * @return {T}
 * @suppress {invalidCasts}
 */

const dedupingMixin = function (mixin) {
  let mixinApplications =
  /** @type {!MixinFunction} */
  mixin.__mixinApplications;

  if (!mixinApplications) {
    mixinApplications = new WeakMap();
    /** @type {!MixinFunction} */

    mixin.__mixinApplications = mixinApplications;
  } // maintain a unique id for each mixin


  let mixinDedupeId = dedupeId++;

  function dedupingMixin(base) {
    let baseSet =
    /** @type {!MixinFunction} */
    base.__mixinSet;

    if (baseSet && baseSet[mixinDedupeId]) {
      return base;
    }

    let map = mixinApplications;
    let extended = map.get(base);

    if (!extended) {
      extended =
      /** @type {!Function} */
      mixin(base);
      map.set(base, extended);
    } // copy inherited mixin set from the extended class, or the base class
    // NOTE: we avoid use of Set here because some browser (IE11)
    // cannot extend a base Set via the constructor.


    let mixinSet = Object.create(
    /** @type {!MixinFunction} */
    extended.__mixinSet || baseSet || null);
    mixinSet[mixinDedupeId] = true;
    /** @type {!MixinFunction} */

    extended.__mixinSet = mixinSet;
    return extended;
  }

  return dedupingMixin;
};
/* eslint-enable valid-jsdoc */

/***/ }),

/***/ "./node_modules/@polymer/polymer/lib/utils/path.js":
/*!*********************************************************!*\
  !*** ./node_modules/@polymer/polymer/lib/utils/path.js ***!
  \*********************************************************/
/*! exports provided: isPath, root, isAncestor, isDescendant, translate, matches, normalize, split, get, set, isDeep */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isPath", function() { return isPath; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "root", function() { return root; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isAncestor", function() { return isAncestor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isDescendant", function() { return isDescendant; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "translate", function() { return translate; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "matches", function() { return matches; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "normalize", function() { return normalize; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "split", function() { return split; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "get", function() { return get; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "set", function() { return set; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isDeep", function() { return isDeep; });
/* harmony import */ var _boot_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./boot.js */ "./node_modules/@polymer/polymer/lib/utils/boot.js");
/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/

/**
 * Module with utilities for manipulating structured data path strings.
 *
 * @summary Module with utilities for manipulating structured data path strings.
 */

/**
 * Returns true if the given string is a structured data path (has dots).
 *
 * Example:
 *
 * ```
 * isPath('foo.bar.baz') // true
 * isPath('foo')         // false
 * ```
 *
 * @param {string} path Path string
 * @return {boolean} True if the string contained one or more dots
 */

function isPath(path) {
  return path.indexOf('.') >= 0;
}
/**
 * Returns the root property name for the given path.
 *
 * Example:
 *
 * ```
 * root('foo.bar.baz') // 'foo'
 * root('foo')         // 'foo'
 * ```
 *
 * @param {string} path Path string
 * @return {string} Root property name
 */

function root(path) {
  let dotIndex = path.indexOf('.');

  if (dotIndex === -1) {
    return path;
  }

  return path.slice(0, dotIndex);
}
/**
 * Given `base` is `foo.bar`, `foo` is an ancestor, `foo.bar` is not
 * Returns true if the given path is an ancestor of the base path.
 *
 * Example:
 *
 * ```
 * isAncestor('foo.bar', 'foo')         // true
 * isAncestor('foo.bar', 'foo.bar')     // false
 * isAncestor('foo.bar', 'foo.bar.baz') // false
 * ```
 *
 * @param {string} base Path string to test against.
 * @param {string} path Path string to test.
 * @return {boolean} True if `path` is an ancestor of `base`.
 */

function isAncestor(base, path) {
  //     base.startsWith(path + '.');
  return base.indexOf(path + '.') === 0;
}
/**
 * Given `base` is `foo.bar`, `foo.bar.baz` is an descendant
 *
 * Example:
 *
 * ```
 * isDescendant('foo.bar', 'foo.bar.baz') // true
 * isDescendant('foo.bar', 'foo.bar')     // false
 * isDescendant('foo.bar', 'foo')         // false
 * ```
 *
 * @param {string} base Path string to test against.
 * @param {string} path Path string to test.
 * @return {boolean} True if `path` is a descendant of `base`.
 */

function isDescendant(base, path) {
  //     path.startsWith(base + '.');
  return path.indexOf(base + '.') === 0;
}
/**
 * Replaces a previous base path with a new base path, preserving the
 * remainder of the path.
 *
 * User must ensure `path` has a prefix of `base`.
 *
 * Example:
 *
 * ```
 * translate('foo.bar', 'zot', 'foo.bar.baz') // 'zot.baz'
 * ```
 *
 * @param {string} base Current base string to remove
 * @param {string} newBase New base string to replace with
 * @param {string} path Path to translate
 * @return {string} Translated string
 */

function translate(base, newBase, path) {
  return newBase + path.slice(base.length);
}
/**
 * @param {string} base Path string to test against
 * @param {string} path Path string to test
 * @return {boolean} True if `path` is equal to `base`
 */

function matches(base, path) {
  return base === path || isAncestor(base, path) || isDescendant(base, path);
}
/**
 * Converts array-based paths to flattened path.  String-based paths
 * are returned as-is.
 *
 * Example:
 *
 * ```
 * normalize(['foo.bar', 0, 'baz'])  // 'foo.bar.0.baz'
 * normalize('foo.bar.0.baz')        // 'foo.bar.0.baz'
 * ```
 *
 * @param {string | !Array<string|number>} path Input path
 * @return {string} Flattened path
 */

function normalize(path) {
  if (Array.isArray(path)) {
    let parts = [];

    for (let i = 0; i < path.length; i++) {
      let args = path[i].toString().split('.');

      for (let j = 0; j < args.length; j++) {
        parts.push(args[j]);
      }
    }

    return parts.join('.');
  } else {
    return path;
  }
}
/**
 * Splits a path into an array of property names. Accepts either arrays
 * of path parts or strings.
 *
 * Example:
 *
 * ```
 * split(['foo.bar', 0, 'baz'])  // ['foo', 'bar', '0', 'baz']
 * split('foo.bar.0.baz')        // ['foo', 'bar', '0', 'baz']
 * ```
 *
 * @param {string | !Array<string|number>} path Input path
 * @return {!Array<string>} Array of path parts
 * @suppress {checkTypes}
 */

function split(path) {
  if (Array.isArray(path)) {
    return normalize(path).split('.');
  }

  return path.toString().split('.');
}
/**
 * Reads a value from a path.  If any sub-property in the path is `undefined`,
 * this method returns `undefined` (will never throw.
 *
 * @param {Object} root Object from which to dereference path from
 * @param {string | !Array<string|number>} path Path to read
 * @param {Object=} info If an object is provided to `info`, the normalized
 *  (flattened) path will be set to `info.path`.
 * @return {*} Value at path, or `undefined` if the path could not be
 *  fully dereferenced.
 */

function get(root, path, info) {
  let prop = root;
  let parts = split(path); // Loop over path parts[0..n-1] and dereference

  for (let i = 0; i < parts.length; i++) {
    if (!prop) {
      return;
    }

    let part = parts[i];
    prop = prop[part];
  }

  if (info) {
    info.path = parts.join('.');
  }

  return prop;
}
/**
 * Sets a value to a path.  If any sub-property in the path is `undefined`,
 * this method will no-op.
 *
 * @param {Object} root Object from which to dereference path from
 * @param {string | !Array<string|number>} path Path to set
 * @param {*} value Value to set to path
 * @return {string | undefined} The normalized version of the input path
 */

function set(root, path, value) {
  let prop = root;
  let parts = split(path);
  let last = parts[parts.length - 1];

  if (parts.length > 1) {
    // Loop over path parts[0..n-2] and dereference
    for (let i = 0; i < parts.length - 1; i++) {
      let part = parts[i];
      prop = prop[part];

      if (!prop) {
        return;
      }
    } // Set value to object at end of path


    prop[last] = value;
  } else {
    // Simple property set
    prop[path] = value;
  }

  return parts.join('.');
}
/**
 * Returns true if the given string is a structured data path (has dots).
 *
 * This function is deprecated.  Use `isPath` instead.
 *
 * Example:
 *
 * ```
 * isDeep('foo.bar.baz') // true
 * isDeep('foo')         // false
 * ```
 *
 * @deprecated
 * @param {string} path Path string
 * @return {boolean} True if the string contained one or more dots
 */

const isDeep = isPath;

/***/ }),

/***/ "./node_modules/@polymer/polymer/lib/utils/render-status.js":
/*!******************************************************************!*\
  !*** ./node_modules/@polymer/polymer/lib/utils/render-status.js ***!
  \******************************************************************/
/*! exports provided: flush, beforeNextRender, afterNextRender */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "flush", function() { return flush; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "beforeNextRender", function() { return beforeNextRender; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "afterNextRender", function() { return afterNextRender; });
/* harmony import */ var _boot_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./boot.js */ "./node_modules/@polymer/polymer/lib/utils/boot.js");
/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/

/**
 * Module for scheduling flushable pre-render and post-render tasks.
 *
 * @summary Module for scheduling flushable pre-render and post-render tasks.
 */

let scheduled = false;
let beforeRenderQueue = [];
let afterRenderQueue = [];

function schedule() {
  scheduled = true; // before next render

  requestAnimationFrame(function () {
    scheduled = false;
    flushQueue(beforeRenderQueue); // after the render

    setTimeout(function () {
      runQueue(afterRenderQueue);
    });
  });
}

function flushQueue(queue) {
  while (queue.length) {
    callMethod(queue.shift());
  }
}

function runQueue(queue) {
  for (let i = 0, l = queue.length; i < l; i++) {
    callMethod(queue.shift());
  }
}

function callMethod(info) {
  const context = info[0];
  const callback = info[1];
  const args = info[2];

  try {
    callback.apply(context, args);
  } catch (e) {
    setTimeout(() => {
      throw e;
    });
  }
}
/**
 * Flushes all `beforeNextRender` tasks, followed by all `afterNextRender`
 * tasks.
 *
 * @return {void}
 */


function flush() {
  while (beforeRenderQueue.length || afterRenderQueue.length) {
    flushQueue(beforeRenderQueue);
    flushQueue(afterRenderQueue);
  }

  scheduled = false;
}
/**
 * Enqueues a callback which will be run before the next render, at
 * `requestAnimationFrame` timing.
 *
 * This method is useful for enqueuing work that requires DOM measurement,
 * since measurement may not be reliable in custom element callbacks before
 * the first render, as well as for batching measurement tasks in general.
 *
 * Tasks in this queue may be flushed by calling `flush()`.
 *
 * @param {*} context Context object the callback function will be bound to
 * @param {function(...*):void} callback Callback function
 * @param {!Array=} args An array of arguments to call the callback function with
 * @return {void}
 */

function beforeNextRender(context, callback, args) {
  if (!scheduled) {
    schedule();
  }

  beforeRenderQueue.push([context, callback, args]);
}
/**
 * Enqueues a callback which will be run after the next render, equivalent
 * to one task (`setTimeout`) after the next `requestAnimationFrame`.
 *
 * This method is useful for tuning the first-render performance of an
 * element or application by deferring non-critical work until after the
 * first paint.  Typical non-render-critical work may include adding UI
 * event listeners and aria attributes.
 *
 * @param {*} context Context object the callback function will be bound to
 * @param {function(...*):void} callback Callback function
 * @param {!Array=} args An array of arguments to call the callback function with
 * @return {void}
 */

function afterNextRender(context, callback, args) {
  if (!scheduled) {
    schedule();
  }

  afterRenderQueue.push([context, callback, args]);
}

/***/ }),

/***/ "./node_modules/@polymer/polymer/lib/utils/resolve-url.js":
/*!****************************************************************!*\
  !*** ./node_modules/@polymer/polymer/lib/utils/resolve-url.js ***!
  \****************************************************************/
/*! exports provided: resolveUrl, resolveCss, pathFromUrl */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "resolveUrl", function() { return resolveUrl; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "resolveCss", function() { return resolveCss; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "pathFromUrl", function() { return pathFromUrl; });
/* harmony import */ var _boot_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./boot.js */ "./node_modules/@polymer/polymer/lib/utils/boot.js");
/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/

let CSS_URL_RX = /(url\()([^)]*)(\))/g;
let ABS_URL = /(^\/)|(^#)|(^[\w-\d]*:)/;
let workingURL;
let resolveDoc;
/**
 * Resolves the given URL against the provided `baseUri'.
 *
 * Note that this function performs no resolution for URLs that start
 * with `/` (absolute URLs) or `#` (hash identifiers).  For general purpose
 * URL resolution, use `window.URL`.
 *
 * @param {string} url Input URL to resolve
 * @param {?string=} baseURI Base URI to resolve the URL against
 * @return {string} resolved URL
 */

function resolveUrl(url, baseURI) {
  if (url && ABS_URL.test(url)) {
    return url;
  } // Lazy feature detection.


  if (workingURL === undefined) {
    workingURL = false;

    try {
      const u = new URL('b', 'http://a');
      u.pathname = 'c%20d';
      workingURL = u.href === 'http://a/c%20d';
    } catch (e) {// silently fail
    }
  }

  if (!baseURI) {
    baseURI = document.baseURI || window.location.href;
  }

  if (workingURL) {
    return new URL(url, baseURI).href;
  } // Fallback to creating an anchor into a disconnected document.


  if (!resolveDoc) {
    resolveDoc = document.implementation.createHTMLDocument('temp');
    resolveDoc.base = resolveDoc.createElement('base');
    resolveDoc.head.appendChild(resolveDoc.base);
    resolveDoc.anchor = resolveDoc.createElement('a');
    resolveDoc.body.appendChild(resolveDoc.anchor);
  }

  resolveDoc.base.href = baseURI;
  resolveDoc.anchor.href = url;
  return resolveDoc.anchor.href || url;
}
/**
 * Resolves any relative URL's in the given CSS text against the provided
 * `ownerDocument`'s `baseURI`.
 *
 * @param {string} cssText CSS text to process
 * @param {string} baseURI Base URI to resolve the URL against
 * @return {string} Processed CSS text with resolved URL's
 */

function resolveCss(cssText, baseURI) {
  return cssText.replace(CSS_URL_RX, function (m, pre, url, post) {
    return pre + '\'' + resolveUrl(url.replace(/["']/g, ''), baseURI) + '\'' + post;
  });
}
/**
 * Returns a path from a given `url`. The path includes the trailing
 * `/` from the url.
 *
 * @param {string} url Input URL to transform
 * @return {string} resolved path
 */

function pathFromUrl(url) {
  return url.substring(0, url.lastIndexOf('/') + 1);
}

/***/ }),

/***/ "./node_modules/@polymer/polymer/lib/utils/settings.js":
/*!*************************************************************!*\
  !*** ./node_modules/@polymer/polymer/lib/utils/settings.js ***!
  \*************************************************************/
/*! exports provided: useShadow, useNativeCSSProperties, useNativeCustomElements, rootPath, setRootPath, sanitizeDOMValue, setSanitizeDOMValue, passiveTouchGestures, setPassiveTouchGestures, strictTemplatePolicy, setStrictTemplatePolicy, allowTemplateFromDomModule, setAllowTemplateFromDomModule */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "useShadow", function() { return useShadow; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "useNativeCSSProperties", function() { return useNativeCSSProperties; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "useNativeCustomElements", function() { return useNativeCustomElements; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "rootPath", function() { return rootPath; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "setRootPath", function() { return setRootPath; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "sanitizeDOMValue", function() { return sanitizeDOMValue; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "setSanitizeDOMValue", function() { return setSanitizeDOMValue; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "passiveTouchGestures", function() { return passiveTouchGestures; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "setPassiveTouchGestures", function() { return setPassiveTouchGestures; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "strictTemplatePolicy", function() { return strictTemplatePolicy; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "setStrictTemplatePolicy", function() { return setStrictTemplatePolicy; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "allowTemplateFromDomModule", function() { return allowTemplateFromDomModule; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "setAllowTemplateFromDomModule", function() { return setAllowTemplateFromDomModule; });
/* harmony import */ var _boot_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./boot.js */ "./node_modules/@polymer/polymer/lib/utils/boot.js");
/* harmony import */ var _resolve_url_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./resolve-url.js */ "./node_modules/@polymer/polymer/lib/utils/resolve-url.js");
/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/


const useShadow = !window.ShadyDOM;
const useNativeCSSProperties = Boolean(!window.ShadyCSS || window.ShadyCSS.nativeCss);
const useNativeCustomElements = !window.customElements.polyfillWrapFlushCallback;
/**
 * Globally settable property that is automatically assigned to
 * `ElementMixin` instances, useful for binding in templates to
 * make URL's relative to an application's root.  Defaults to the main
 * document URL, but can be overridden by users.  It may be useful to set
 * `rootPath` to provide a stable application mount path when
 * using client side routing.
 */

let rootPath = undefined || Object(_resolve_url_js__WEBPACK_IMPORTED_MODULE_1__["pathFromUrl"])(document.baseURI || window.location.href);
/**
 * Sets the global rootPath property used by `ElementMixin` and
 * available via `rootPath`.
 *
 * @param {string} path The new root path
 * @return {void}
 */

const setRootPath = function (path) {
  rootPath = path;
};
/**
 * A global callback used to sanitize any value before inserting it into the DOM.
 * The callback signature is:
 *
 *  function sanitizeDOMValue(value, name, type, node) { ... }
 *
 * Where:
 *
 * `value` is the value to sanitize.
 * `name` is the name of an attribute or property (for example, href).
 * `type` indicates where the value is being inserted: one of property, attribute, or text.
 * `node` is the node where the value is being inserted.
 *
 * @type {(function(*,string,string,Node):*)|undefined}
 */

let sanitizeDOMValue = window.Polymer && window.Polymer.sanitizeDOMValue || undefined;
/**
 * Sets the global sanitizeDOMValue available via this module's exported
 * `sanitizeDOMValue` variable.
 *
 * @param {(function(*,string,string,Node):*)|undefined} newSanitizeDOMValue the global sanitizeDOMValue callback
 * @return {void}
 */

const setSanitizeDOMValue = function (newSanitizeDOMValue) {
  sanitizeDOMValue = newSanitizeDOMValue;
};
/**
 * Globally settable property to make Polymer Gestures use passive TouchEvent listeners when recognizing gestures.
 * When set to `true`, gestures made from touch will not be able to prevent scrolling, allowing for smoother
 * scrolling performance.
 * Defaults to `false` for backwards compatibility.
 */

let passiveTouchGestures = false;
/**
 * Sets `passiveTouchGestures` globally for all elements using Polymer Gestures.
 *
 * @param {boolean} usePassive enable or disable passive touch gestures globally
 * @return {void}
 */

const setPassiveTouchGestures = function (usePassive) {
  passiveTouchGestures = usePassive;
};
/**
 * Setting to ensure Polymer template evaluation only occurs based on tempates
 * defined in trusted script.  When true, `<dom-module>` re-registration is
 * disallowed, `<dom-bind>` is disabled, and `<dom-if>`/`<dom-repeat>`
 * templates will only evaluate in the context of a trusted element template.
 */

let strictTemplatePolicy = false;
/**
 * Sets `strictTemplatePolicy` globally for all elements
 *
 * @param {boolean} useStrictPolicy enable or disable strict template policy
 *   globally
 * @return {void}
 */

const setStrictTemplatePolicy = function (useStrictPolicy) {
  strictTemplatePolicy = useStrictPolicy;
};
/**
 * Setting to enable dom-module lookup from Polymer.Element.  By default,
 * templates must be defined in script using the `static get template()`
 * getter and the `html` tag function.  To enable legacy loading of templates
 * via dom-module, set this flag to true.
 */

let allowTemplateFromDomModule = false;
/**
 * Sets `lookupTemplateFromDomModule` globally for all elements
 *
 * @param {boolean} allowDomModule enable or disable template lookup 
 *   globally
 * @return {void}
 */

const setAllowTemplateFromDomModule = function (allowDomModule) {
  allowTemplateFromDomModule = allowDomModule;
};

/***/ }),

/***/ "./node_modules/@polymer/polymer/lib/utils/style-gather.js":
/*!*****************************************************************!*\
  !*** ./node_modules/@polymer/polymer/lib/utils/style-gather.js ***!
  \*****************************************************************/
/*! exports provided: stylesFromModules, stylesFromModule, stylesFromTemplate, stylesFromModuleImports, cssFromModules, cssFromModule, cssFromTemplate, cssFromModuleImports */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "stylesFromModules", function() { return stylesFromModules; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "stylesFromModule", function() { return stylesFromModule; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "stylesFromTemplate", function() { return stylesFromTemplate; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "stylesFromModuleImports", function() { return stylesFromModuleImports; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "cssFromModules", function() { return cssFromModules; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "cssFromModule", function() { return cssFromModule; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "cssFromTemplate", function() { return cssFromTemplate; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "cssFromModuleImports", function() { return cssFromModuleImports; });
/* harmony import */ var _elements_dom_module_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../elements/dom-module.js */ "./node_modules/@polymer/polymer/lib/elements/dom-module.js");
/* harmony import */ var _resolve_url_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./resolve-url.js */ "./node_modules/@polymer/polymer/lib/utils/resolve-url.js");
/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/

/**
 * Module with utilities for collection CSS text from `<templates>`, external
 * stylesheets, and `dom-module`s.
 *
 * @summary Module with utilities for collection CSS text from various sources.
 */


const MODULE_STYLE_LINK_SELECTOR = 'link[rel=import][type~=css]';
const INCLUDE_ATTR = 'include';
const SHADY_UNSCOPED_ATTR = 'shady-unscoped';
/**
 * @param {string} moduleId .
 * @return {?DomModule} .
 */

function importModule(moduleId) {
  return (
    /** @type {?DomModule} */
    _elements_dom_module_js__WEBPACK_IMPORTED_MODULE_0__["DomModule"].import(moduleId)
  );
}

function styleForImport(importDoc) {
  // NOTE: polyfill affordance.
  // under the HTMLImports polyfill, there will be no 'body',
  // but the import pseudo-doc can be used directly.
  let container = importDoc.body ? importDoc.body : importDoc;
  const importCss = Object(_resolve_url_js__WEBPACK_IMPORTED_MODULE_1__["resolveCss"])(container.textContent, importDoc.baseURI);
  const style = document.createElement('style');
  style.textContent = importCss;
  return style;
}
/** @typedef {{assetpath: string}} */


let templateWithAssetPath; // eslint-disable-line no-unused-vars

/**
 * Returns a list of <style> elements in a space-separated list of `dom-module`s.
 *
 * @function
 * @param {string} moduleIds List of dom-module id's within which to
 * search for css.
 * @return {!Array<!HTMLStyleElement>} Array of contained <style> elements
 */

function stylesFromModules(moduleIds) {
  const modules = moduleIds.trim().split(/\s+/);
  const styles = [];

  for (let i = 0; i < modules.length; i++) {
    styles.push(...stylesFromModule(modules[i]));
  }

  return styles;
}
/**
 * Returns a list of <style> elements in a given `dom-module`.
 * Styles in a `dom-module` can come either from `<style>`s within the
 * first `<template>`, or else from one or more
 * `<link rel="import" type="css">` links outside the template.
 *
 * @param {string} moduleId dom-module id to gather styles from
 * @return {!Array<!HTMLStyleElement>} Array of contained styles.
 */

function stylesFromModule(moduleId) {
  const m = importModule(moduleId);

  if (!m) {
    console.warn('Could not find style data in module named', moduleId);
    return [];
  }

  if (m._styles === undefined) {
    const styles = []; // module imports: <link rel="import" type="css">

    styles.push(..._stylesFromModuleImports(m)); // include css from the first template in the module

    const template =
    /** @type {?HTMLTemplateElement} */
    m.querySelector('template');

    if (template) {
      styles.push(...stylesFromTemplate(template,
      /** @type {templateWithAssetPath} */
      m.assetpath));
    }

    m._styles = styles;
  }

  return m._styles;
}
/**
 * Returns the `<style>` elements within a given template.
 *
 * @param {!HTMLTemplateElement} template Template to gather styles from
 * @param {string} baseURI baseURI for style content
 * @return {!Array<!HTMLStyleElement>} Array of styles
 */

function stylesFromTemplate(template, baseURI) {
  if (!template._styles) {
    const styles = []; // if element is a template, get content from its .content

    const e$ = template.content.querySelectorAll('style');

    for (let i = 0; i < e$.length; i++) {
      let e = e$[i]; // support style sharing by allowing styles to "include"
      // other dom-modules that contain styling

      let include = e.getAttribute(INCLUDE_ATTR);

      if (include) {
        styles.push(...stylesFromModules(include).filter(function (item, index, self) {
          return self.indexOf(item) === index;
        }));
      }

      if (baseURI) {
        e.textContent = Object(_resolve_url_js__WEBPACK_IMPORTED_MODULE_1__["resolveCss"])(e.textContent, baseURI);
      }

      styles.push(e);
    }

    template._styles = styles;
  }

  return template._styles;
}
/**
 * Returns a list of <style> elements  from stylesheets loaded via `<link rel="import" type="css">` links within the specified `dom-module`.
 *
 * @param {string} moduleId Id of `dom-module` to gather CSS from
 * @return {!Array<!HTMLStyleElement>} Array of contained styles.
 */

function stylesFromModuleImports(moduleId) {
  let m = importModule(moduleId);
  return m ? _stylesFromModuleImports(m) : [];
}
/**
 * @param {!HTMLElement} module dom-module element that could contain `<link rel="import" type="css">` styles
 * @return {!Array<!HTMLStyleElement>} Array of contained styles
 */

function _stylesFromModuleImports(module) {
  const styles = [];
  const p$ = module.querySelectorAll(MODULE_STYLE_LINK_SELECTOR);

  for (let i = 0; i < p$.length; i++) {
    let p = p$[i];

    if (p.import) {
      const importDoc = p.import;
      const unscoped = p.hasAttribute(SHADY_UNSCOPED_ATTR);

      if (unscoped && !importDoc._unscopedStyle) {
        const style = styleForImport(importDoc);
        style.setAttribute(SHADY_UNSCOPED_ATTR, '');
        importDoc._unscopedStyle = style;
      } else if (!importDoc._style) {
        importDoc._style = styleForImport(importDoc);
      }

      styles.push(unscoped ? importDoc._unscopedStyle : importDoc._style);
    }
  }

  return styles;
}
/**
 *
 * Returns CSS text of styles in a space-separated list of `dom-module`s.
 * Note: This method is deprecated, use `stylesFromModules` instead.
 *
 * @deprecated
 * @param {string} moduleIds List of dom-module id's within which to
 * search for css.
 * @return {string} Concatenated CSS content from specified `dom-module`s
 */


function cssFromModules(moduleIds) {
  let modules = moduleIds.trim().split(/\s+/);
  let cssText = '';

  for (let i = 0; i < modules.length; i++) {
    cssText += cssFromModule(modules[i]);
  }

  return cssText;
}
/**
 * Returns CSS text of styles in a given `dom-module`.  CSS in a `dom-module`
 * can come either from `<style>`s within the first `<template>`, or else
 * from one or more `<link rel="import" type="css">` links outside the
 * template.
 *
 * Any `<styles>` processed are removed from their original location.
 * Note: This method is deprecated, use `styleFromModule` instead.
 *
 * @deprecated
 * @param {string} moduleId dom-module id to gather styles from
 * @return {string} Concatenated CSS content from specified `dom-module`
 */

function cssFromModule(moduleId) {
  let m = importModule(moduleId);

  if (m && m._cssText === undefined) {
    // module imports: <link rel="import" type="css">
    let cssText = _cssFromModuleImports(m); // include css from the first template in the module


    let t =
    /** @type {?HTMLTemplateElement} */
    m.querySelector('template');

    if (t) {
      cssText += cssFromTemplate(t,
      /** @type {templateWithAssetPath} */
      m.assetpath);
    }

    m._cssText = cssText || null;
  }

  if (!m) {
    console.warn('Could not find style data in module named', moduleId);
  }

  return m && m._cssText || '';
}
/**
 * Returns CSS text of `<styles>` within a given template.
 *
 * Any `<styles>` processed are removed from their original location.
 * Note: This method is deprecated, use `styleFromTemplate` instead.
 *
 * @deprecated
 * @param {!HTMLTemplateElement} template Template to gather styles from
 * @param {string} baseURI Base URI to resolve the URL against
 * @return {string} Concatenated CSS content from specified template
 */

function cssFromTemplate(template, baseURI) {
  let cssText = '';
  const e$ = stylesFromTemplate(template, baseURI); // if element is a template, get content from its .content

  for (let i = 0; i < e$.length; i++) {
    let e = e$[i];

    if (e.parentNode) {
      e.parentNode.removeChild(e);
    }

    cssText += e.textContent;
  }

  return cssText;
}
/**
 * Returns CSS text from stylesheets loaded via `<link rel="import" type="css">`
 * links within the specified `dom-module`.
 *
 * Note: This method is deprecated, use `stylesFromModuleImports` instead.
 *
 * @deprecated
 *
 * @param {string} moduleId Id of `dom-module` to gather CSS from
 * @return {string} Concatenated CSS content from links in specified `dom-module`
 */

function cssFromModuleImports(moduleId) {
  let m = importModule(moduleId);
  return m ? _cssFromModuleImports(m) : '';
}
/**
 * @deprecated
 * @param {!HTMLElement} module dom-module element that could contain `<link rel="import" type="css">` styles
 * @return {string} Concatenated CSS content from links in the dom-module
 */

function _cssFromModuleImports(module) {
  let cssText = '';

  let styles = _stylesFromModuleImports(module);

  for (let i = 0; i < styles.length; i++) {
    cssText += styles[i].textContent;
  }

  return cssText;
}

/***/ }),

/***/ "./node_modules/@polymer/polymer/lib/utils/templatize.js":
/*!***************************************************************!*\
  !*** ./node_modules/@polymer/polymer/lib/utils/templatize.js ***!
  \***************************************************************/
/*! exports provided: templatize, modelForElement, TemplateInstanceBase */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "templatize", function() { return templatize; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "modelForElement", function() { return modelForElement; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "TemplateInstanceBase", function() { return TemplateInstanceBase; });
/* harmony import */ var _boot_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./boot.js */ "./node_modules/@polymer/polymer/lib/utils/boot.js");
/* harmony import */ var _mixins_property_effects_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../mixins/property-effects.js */ "./node_modules/@polymer/polymer/lib/mixins/property-effects.js");
/* harmony import */ var _mixins_mutable_data_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../mixins/mutable-data.js */ "./node_modules/@polymer/polymer/lib/mixins/mutable-data.js");
/* harmony import */ var _utils_settings_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/settings.js */ "./node_modules/@polymer/polymer/lib/utils/settings.js");
/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/

/**
 * Module for preparing and stamping instances of templates that utilize
 * Polymer's data-binding and declarative event listener features.
 *
 * Example:
 *
 *     // Get a template from somewhere, e.g. light DOM
 *     let template = this.querySelector('template');
 *     // Prepare the template
 *     let TemplateClass = Templatize.templatize(template);
 *     // Instance the template with an initial data model
 *     let instance = new TemplateClass({myProp: 'initial'});
 *     // Insert the instance's DOM somewhere, e.g. element's shadow DOM
 *     this.shadowRoot.appendChild(instance.root);
 *     // Changing a property on the instance will propagate to bindings
 *     // in the template
 *     instance.myProp = 'new value';
 *
 * The `options` dictionary passed to `templatize` allows for customizing
 * features of the generated template class, including how outer-scope host
 * properties should be forwarded into template instances, how any instance
 * properties added into the template's scope should be notified out to
 * the host, and whether the instance should be decorated as a "parent model"
 * of any event handlers.
 *
 *     // Customize property forwarding and event model decoration
 *     let TemplateClass = Templatize.templatize(template, this, {
 *       parentModel: true,
 *       forwardHostProp(property, value) {...},
 *       instanceProps: {...},
 *       notifyInstanceProp(instance, property, value) {...},
 *     });
 *
 * @summary Module for preparing and stamping instances of templates
 *   utilizing Polymer templating features.
 */



 // Base class for HTMLTemplateElement extension that has property effects
// machinery for propagating host properties to children. This is an ES5
// class only because Babel (incorrectly) requires super() in the class
// constructor even though no `this` is used and it returns an instance.

let newInstance = null;
/**
 * @constructor
 * @extends {HTMLTemplateElement}
 * @private
 */

function HTMLTemplateElementExtension() {
  return newInstance;
}

HTMLTemplateElementExtension.prototype = Object.create(HTMLTemplateElement.prototype, {
  constructor: {
    value: HTMLTemplateElementExtension,
    writable: true
  }
});
/**
 * @constructor
 * @implements {Polymer_PropertyEffects}
 * @extends {HTMLTemplateElementExtension}
 * @private
 */

const DataTemplate = Object(_mixins_property_effects_js__WEBPACK_IMPORTED_MODULE_1__["PropertyEffects"])(HTMLTemplateElementExtension);
/**
 * @constructor
 * @implements {Polymer_MutableData}
 * @extends {DataTemplate}
 * @private
 */

const MutableDataTemplate = Object(_mixins_mutable_data_js__WEBPACK_IMPORTED_MODULE_2__["MutableData"])(DataTemplate); // Applies a DataTemplate subclass to a <template> instance

function upgradeTemplate(template, constructor) {
  newInstance = template;
  Object.setPrototypeOf(template, constructor.prototype);
  new constructor();
  newInstance = null;
}
/**
 * Base class for TemplateInstance.
 * @constructor
 * @implements {Polymer_PropertyEffects}
 * @private
 */


const base = Object(_mixins_property_effects_js__WEBPACK_IMPORTED_MODULE_1__["PropertyEffects"])(class {});
/**
 * @polymer
 * @customElement
 * @appliesMixin PropertyEffects
 * @unrestricted
 */

class TemplateInstanceBase extends base {
  constructor(props) {
    super();

    this._configureProperties(props);

    this.root = this._stampTemplate(this.__dataHost); // Save list of stamped children

    let children = this.children = [];

    for (let n = this.root.firstChild; n; n = n.nextSibling) {
      children.push(n);
      n.__templatizeInstance = this;
    }

    if (this.__templatizeOwner && this.__templatizeOwner.__hideTemplateChildren__) {
      this._showHideChildren(true);
    } // Flush props only when props are passed if instance props exist
    // or when there isn't instance props.


    let options = this.__templatizeOptions;

    if (props && options.instanceProps || !options.instanceProps) {
      this._enableProperties();
    }
  }
  /**
   * Configure the given `props` by calling `_setPendingProperty`. Also
   * sets any properties stored in `__hostProps`.
   * @private
   * @param {Object} props Object of property name-value pairs to set.
   * @return {void}
   */


  _configureProperties(props) {
    let options = this.__templatizeOptions;

    if (options.forwardHostProp) {
      for (let hprop in this.__hostProps) {
        this._setPendingProperty(hprop, this.__dataHost['_host_' + hprop]);
      }
    } // Any instance props passed in the constructor will overwrite host props;
    // normally this would be a user error but we don't specifically filter them


    for (let iprop in props) {
      this._setPendingProperty(iprop, props[iprop]);
    }
  }
  /**
   * Forwards a host property to this instance.  This method should be
   * called on instances from the `options.forwardHostProp` callback
   * to propagate changes of host properties to each instance.
   *
   * Note this method enqueues the change, which are flushed as a batch.
   *
   * @param {string} prop Property or path name
   * @param {*} value Value of the property to forward
   * @return {void}
   */


  forwardHostProp(prop, value) {
    if (this._setPendingPropertyOrPath(prop, value, false, true)) {
      this.__dataHost._enqueueClient(this);
    }
  }
  /**
   * Override point for adding custom or simulated event handling.
   *
   * @override
   * @param {!Node} node Node to add event listener to
   * @param {string} eventName Name of event
   * @param {function(!Event):void} handler Listener function to add
   * @return {void}
   */


  _addEventListenerToNode(node, eventName, handler) {
    if (this._methodHost && this.__templatizeOptions.parentModel) {
      // If this instance should be considered a parent model, decorate
      // events this template instance as `model`
      this._methodHost._addEventListenerToNode(node, eventName, e => {
        e.model = this;
        handler(e);
      });
    } else {
      // Otherwise delegate to the template's host (which could be)
      // another template instance
      let templateHost = this.__dataHost.__dataHost;

      if (templateHost) {
        templateHost._addEventListenerToNode(node, eventName, handler);
      }
    }
  }
  /**
   * Shows or hides the template instance top level child elements. For
   * text nodes, `textContent` is removed while "hidden" and replaced when
   * "shown."
   * @param {boolean} hide Set to true to hide the children;
   * set to false to show them.
   * @return {void}
   * @protected
   */


  _showHideChildren(hide) {
    let c = this.children;

    for (let i = 0; i < c.length; i++) {
      let n = c[i]; // Ignore non-changes

      if (Boolean(hide) != Boolean(n.__hideTemplateChildren__)) {
        if (n.nodeType === Node.TEXT_NODE) {
          if (hide) {
            n.__polymerTextContent__ = n.textContent;
            n.textContent = '';
          } else {
            n.textContent = n.__polymerTextContent__;
          } // remove and replace slot

        } else if (n.localName === 'slot') {
          if (hide) {
            n.__polymerReplaced__ = document.createComment('hidden-slot');
            n.parentNode.replaceChild(n.__polymerReplaced__, n);
          } else {
            const replace = n.__polymerReplaced__;

            if (replace) {
              replace.parentNode.replaceChild(n, replace);
            }
          }
        } else if (n.style) {
          if (hide) {
            n.__polymerDisplay__ = n.style.display;
            n.style.display = 'none';
          } else {
            n.style.display = n.__polymerDisplay__;
          }
        }
      }

      n.__hideTemplateChildren__ = hide;

      if (n._showHideChildren) {
        n._showHideChildren(hide);
      }
    }
  }
  /**
   * Overrides default property-effects implementation to intercept
   * textContent bindings while children are "hidden" and cache in
   * private storage for later retrieval.
   *
   * @override
   * @param {!Node} node The node to set a property on
   * @param {string} prop The property to set
   * @param {*} value The value to set
   * @return {void}
   * @protected
   */


  _setUnmanagedPropertyToNode(node, prop, value) {
    if (node.__hideTemplateChildren__ && node.nodeType == Node.TEXT_NODE && prop == 'textContent') {
      node.__polymerTextContent__ = value;
    } else {
      super._setUnmanagedPropertyToNode(node, prop, value);
    }
  }
  /**
   * Find the parent model of this template instance.  The parent model
   * is either another templatize instance that had option `parentModel: true`,
   * or else the host element.
   *
   * @return {!Polymer_PropertyEffects} The parent model of this instance
   */


  get parentModel() {
    let model = this.__parentModel;

    if (!model) {
      let options;
      model = this;

      do {
        // A template instance's `__dataHost` is a <template>
        // `model.__dataHost.__dataHost` is the template's host
        model = model.__dataHost.__dataHost;
      } while ((options = model.__templatizeOptions) && !options.parentModel);

      this.__parentModel = model;
    }

    return model;
  }
  /**
   * Stub of HTMLElement's `dispatchEvent`, so that effects that may
   * dispatch events safely no-op.
   *
   * @param {Event} event Event to dispatch
   * @return {boolean} Always true.
   */


  dispatchEvent(event) {
    // eslint-disable-line no-unused-vars
    return true;
  }

}
/** @type {!DataTemplate} */


TemplateInstanceBase.prototype.__dataHost;
/** @type {!TemplatizeOptions} */

TemplateInstanceBase.prototype.__templatizeOptions;
/** @type {!Polymer_PropertyEffects} */

TemplateInstanceBase.prototype._methodHost;
/** @type {!Object} */

TemplateInstanceBase.prototype.__templatizeOwner;
/** @type {!Object} */

TemplateInstanceBase.prototype.__hostProps;
/**
 * @constructor
 * @extends {TemplateInstanceBase}
 * @implements {Polymer_MutableData}
 * @private
 */

const MutableTemplateInstanceBase = Object(_mixins_mutable_data_js__WEBPACK_IMPORTED_MODULE_2__["MutableData"])(TemplateInstanceBase);

function findMethodHost(template) {
  // Technically this should be the owner of the outermost template.
  // In shadow dom, this is always getRootNode().host, but we can
  // approximate this via cooperation with our dataHost always setting
  // `_methodHost` as long as there were bindings (or id's) on this
  // instance causing it to get a dataHost.
  let templateHost = template.__dataHost;
  return templateHost && templateHost._methodHost || templateHost;
}
/* eslint-disable valid-jsdoc */

/**
 * @suppress {missingProperties} class.prototype is not defined for some reason
 */


function createTemplatizerClass(template, templateInfo, options) {
  // Anonymous class created by the templatize
  let base = options.mutableData ? MutableTemplateInstanceBase : TemplateInstanceBase;
  /**
   * @constructor
   * @extends {base}
   * @private
   */

  let klass = class extends base {};
  klass.prototype.__templatizeOptions = options;

  klass.prototype._bindTemplate(template);

  addNotifyEffects(klass, template, templateInfo, options);
  return klass;
}
/**
 * @suppress {missingProperties} class.prototype is not defined for some reason
 */


function addPropagateEffects(template, templateInfo, options) {
  let userForwardHostProp = options.forwardHostProp;

  if (userForwardHostProp) {
    // Provide data API and property effects on memoized template class
    let klass = templateInfo.templatizeTemplateClass;

    if (!klass) {
      let base = options.mutableData ? MutableDataTemplate : DataTemplate;
      /** @private */

      klass = templateInfo.templatizeTemplateClass = class TemplatizedTemplate extends base {}; // Add template - >instances effects
      // and host <- template effects

      let hostProps = templateInfo.hostProps;

      for (let prop in hostProps) {
        klass.prototype._addPropertyEffect('_host_' + prop, klass.prototype.PROPERTY_EFFECT_TYPES.PROPAGATE, {
          fn: createForwardHostPropEffect(prop, userForwardHostProp)
        });

        klass.prototype._createNotifyingProperty('_host_' + prop);
      }
    }

    upgradeTemplate(template, klass); // Mix any pre-bound data into __data; no need to flush this to
    // instances since they pull from the template at instance-time

    if (template.__dataProto) {
      // Note, generally `__dataProto` could be chained, but it's guaranteed
      // to not be since this is a vanilla template we just added effects to
      Object.assign(template.__data, template.__dataProto);
    } // Clear any pending data for performance


    template.__dataTemp = {};
    template.__dataPending = null;
    template.__dataOld = null;

    template._enableProperties();
  }
}
/* eslint-enable valid-jsdoc */


function createForwardHostPropEffect(hostProp, userForwardHostProp) {
  return function forwardHostProp(template, prop, props) {
    userForwardHostProp.call(template.__templatizeOwner, prop.substring('_host_'.length), props[prop]);
  };
}

function addNotifyEffects(klass, template, templateInfo, options) {
  let hostProps = templateInfo.hostProps || {};

  for (let iprop in options.instanceProps) {
    delete hostProps[iprop];
    let userNotifyInstanceProp = options.notifyInstanceProp;

    if (userNotifyInstanceProp) {
      klass.prototype._addPropertyEffect(iprop, klass.prototype.PROPERTY_EFFECT_TYPES.NOTIFY, {
        fn: createNotifyInstancePropEffect(iprop, userNotifyInstanceProp)
      });
    }
  }

  if (options.forwardHostProp && template.__dataHost) {
    for (let hprop in hostProps) {
      klass.prototype._addPropertyEffect(hprop, klass.prototype.PROPERTY_EFFECT_TYPES.NOTIFY, {
        fn: createNotifyHostPropEffect()
      });
    }
  }
}

function createNotifyInstancePropEffect(instProp, userNotifyInstanceProp) {
  return function notifyInstanceProp(inst, prop, props) {
    userNotifyInstanceProp.call(inst.__templatizeOwner, inst, prop, props[prop]);
  };
}

function createNotifyHostPropEffect() {
  return function notifyHostProp(inst, prop, props) {
    inst.__dataHost._setPendingPropertyOrPath('_host_' + prop, props[prop], true, true);
  };
}
/**
 * Returns an anonymous `PropertyEffects` class bound to the
 * `<template>` provided.  Instancing the class will result in the
 * template being stamped into a document fragment stored as the instance's
 * `root` property, after which it can be appended to the DOM.
 *
 * Templates may utilize all Polymer data-binding features as well as
 * declarative event listeners.  Event listeners and inline computing
 * functions in the template will be called on the host of the template.
 *
 * The constructor returned takes a single argument dictionary of initial
 * property values to propagate into template bindings.  Additionally
 * host properties can be forwarded in, and instance properties can be
 * notified out by providing optional callbacks in the `options` dictionary.
 *
 * Valid configuration in `options` are as follows:
 *
 * - `forwardHostProp(property, value)`: Called when a property referenced
 *   in the template changed on the template's host. As this library does
 *   not retain references to templates instanced by the user, it is the
 *   templatize owner's responsibility to forward host property changes into
 *   user-stamped instances.  The `instance.forwardHostProp(property, value)`
 *    method on the generated class should be called to forward host
 *   properties into the template to prevent unnecessary property-changed
 *   notifications. Any properties referenced in the template that are not
 *   defined in `instanceProps` will be notified up to the template's host
 *   automatically.
 * - `instanceProps`: Dictionary of property names that will be added
 *   to the instance by the templatize owner.  These properties shadow any
 *   host properties, and changes within the template to these properties
 *   will result in `notifyInstanceProp` being called.
 * - `mutableData`: When `true`, the generated class will skip strict
 *   dirty-checking for objects and arrays (always consider them to be
 *   "dirty").
 * - `notifyInstanceProp(instance, property, value)`: Called when
 *   an instance property changes.  Users may choose to call `notifyPath`
 *   on e.g. the owner to notify the change.
 * - `parentModel`: When `true`, events handled by declarative event listeners
 *   (`on-event="handler"`) will be decorated with a `model` property pointing
 *   to the template instance that stamped it.  It will also be returned
 *   from `instance.parentModel` in cases where template instance nesting
 *   causes an inner model to shadow an outer model.
 *
 * All callbacks are called bound to the `owner`. Any context
 * needed for the callbacks (such as references to `instances` stamped)
 * should be stored on the `owner` such that they can be retrieved via
 * `this`.
 *
 * When `options.forwardHostProp` is declared as an option, any properties
 * referenced in the template will be automatically forwarded from the host of
 * the `<template>` to instances, with the exception of any properties listed in
 * the `options.instanceProps` object.  `instanceProps` are assumed to be
 * managed by the owner of the instances, either passed into the constructor
 * or set after the fact.  Note, any properties passed into the constructor will
 * always be set to the instance (regardless of whether they would normally
 * be forwarded from the host).
 *
 * Note that `templatize()` can be run only once for a given `<template>`.
 * Further calls will result in an error. Also, there is a special
 * behavior if the template was duplicated through a mechanism such as
 * `<dom-repeat>` or `<test-fixture>`. In this case, all calls to
 * `templatize()` return the same class for all duplicates of a template.
 * The class returned from `templatize()` is generated only once using
 * the `options` from the first call. This means that any `options`
 * provided to subsequent calls will be ignored. Therefore, it is very
 * important not to close over any variables inside the callbacks. Also,
 * arrow functions must be avoided because they bind the outer `this`.
 * Inside the callbacks, any contextual information can be accessed
 * through `this`, which points to the `owner`.
 *
 * @param {!HTMLTemplateElement} template Template to templatize
 * @param {Polymer_PropertyEffects=} owner Owner of the template instances;
 *   any optional callbacks will be bound to this owner.
 * @param {Object=} options Options dictionary (see summary for details)
 * @return {function(new:TemplateInstanceBase)} Generated class bound to the template
 *   provided
 * @suppress {invalidCasts}
 */


function templatize(template, owner, options) {
  // Under strictTemplatePolicy, the templatized element must be owned
  // by a (trusted) Polymer element, indicated by existence of _methodHost;
  // e.g. for dom-if & dom-repeat in main document, _methodHost is null
  if (_utils_settings_js__WEBPACK_IMPORTED_MODULE_3__["strictTemplatePolicy"] && !findMethodHost(template)) {
    throw new Error('strictTemplatePolicy: template owner not trusted');
  }

  options =
  /** @type {!TemplatizeOptions} */
  options || {};

  if (template.__templatizeOwner) {
    throw new Error('A <template> can only be templatized once');
  }

  template.__templatizeOwner = owner;
  const ctor = owner ? owner.constructor : TemplateInstanceBase;

  let templateInfo = ctor._parseTemplate(template); // Get memoized base class for the prototypical template, which
  // includes property effects for binding template & forwarding


  let baseClass = templateInfo.templatizeInstanceClass;

  if (!baseClass) {
    baseClass = createTemplatizerClass(template, templateInfo, options);
    templateInfo.templatizeInstanceClass = baseClass;
  } // Host property forwarding must be installed onto template instance


  addPropagateEffects(template, templateInfo, options); // Subclass base class and add reference for this specific template

  /** @private */

  let klass = class TemplateInstance extends baseClass {};
  klass.prototype._methodHost = findMethodHost(template);
  klass.prototype.__dataHost = template;
  klass.prototype.__templatizeOwner = owner;
  klass.prototype.__hostProps = templateInfo.hostProps;
  klass =
  /** @type {function(new:TemplateInstanceBase)} */
  klass; //eslint-disable-line no-self-assign

  return klass;
}
/**
 * Returns the template "model" associated with a given element, which
 * serves as the binding scope for the template instance the element is
 * contained in. A template model is an instance of
 * `TemplateInstanceBase`, and should be used to manipulate data
 * associated with this template instance.
 *
 * Example:
 *
 *   let model = modelForElement(el);
 *   if (model.index < 10) {
 *     model.set('item.checked', true);
 *   }
 *
 * @param {HTMLTemplateElement} template The model will be returned for
 *   elements stamped from this template
 * @param {Node=} node Node for which to return a template model.
 * @return {TemplateInstanceBase} Template instance representing the
 *   binding scope for the element
 */

function modelForElement(template, node) {
  let model;

  while (node) {
    // An element with a __templatizeInstance marks the top boundary
    // of a scope; walk up until we find one, and then ensure that
    // its __dataHost matches `this`, meaning this dom-repeat stamped it
    if (model = node.__templatizeInstance) {
      // Found an element stamped by another template; keep walking up
      // from its __dataHost
      if (model.__dataHost != template) {
        node = model.__dataHost;
      } else {
        return model;
      }
    } else {
      // Still in a template scope, keep going up until
      // a __templatizeInstance is found
      node = node.parentNode;
    }
  }

  return null;
}


/***/ }),

/***/ "./node_modules/@polymer/polymer/lib/utils/unresolved.js":
/*!***************************************************************!*\
  !*** ./node_modules/@polymer/polymer/lib/utils/unresolved.js ***!
  \***************************************************************/
/*! no exports provided */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/
function resolve() {
  document.body.removeAttribute('unresolved');
}

if (document.readyState === 'interactive' || document.readyState === 'complete') {
  resolve();
} else {
  window.addEventListener('DOMContentLoaded', resolve);
}



/***/ }),

/***/ "./node_modules/@polymer/polymer/polymer-element.js":
/*!**********************************************************!*\
  !*** ./node_modules/@polymer/polymer/polymer-element.js ***!
  \**********************************************************/
/*! exports provided: html, version, PolymerElement */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PolymerElement", function() { return PolymerElement; });
/* harmony import */ var _lib_mixins_element_mixin_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./lib/mixins/element-mixin.js */ "./node_modules/@polymer/polymer/lib/mixins/element-mixin.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "version", function() { return _lib_mixins_element_mixin_js__WEBPACK_IMPORTED_MODULE_0__["version"]; });

/* harmony import */ var _lib_utils_html_tag_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./lib/utils/html-tag.js */ "./node_modules/@polymer/polymer/lib/utils/html-tag.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "html", function() { return _lib_utils_html_tag_js__WEBPACK_IMPORTED_MODULE_1__["html"]; });

/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/



/**
 * Base class that provides the core API for Polymer's meta-programming
 * features including template stamping, data-binding, attribute deserialization,
 * and property change observation.
 *
 * @customElement
 * @polymer
 * @constructor
 * @implements {Polymer_ElementMixin}
 * @extends HTMLElement
 * @appliesMixin ElementMixin
 * @summary Custom element base class that provides the core API for Polymer's
 *   key meta-programming features including template stamping, data-binding,
 *   attribute deserialization, and property change observation
 */

const PolymerElement = Object(_lib_mixins_element_mixin_js__WEBPACK_IMPORTED_MODULE_0__["ElementMixin"])(HTMLElement);

/***/ }),

/***/ "./node_modules/@polymer/polymer/polymer-legacy.js":
/*!*********************************************************!*\
  !*** ./node_modules/@polymer/polymer/polymer-legacy.js ***!
  \*********************************************************/
/*! exports provided: Polymer, html, Base */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Base", function() { return Base; });
/* harmony import */ var _lib_legacy_legacy_element_mixin_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./lib/legacy/legacy-element-mixin.js */ "./node_modules/@polymer/polymer/lib/legacy/legacy-element-mixin.js");
/* harmony import */ var _lib_legacy_polymer_fn_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./lib/legacy/polymer-fn.js */ "./node_modules/@polymer/polymer/lib/legacy/polymer-fn.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Polymer", function() { return _lib_legacy_polymer_fn_js__WEBPACK_IMPORTED_MODULE_1__["Polymer"]; });

/* harmony import */ var _lib_legacy_templatizer_behavior_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./lib/legacy/templatizer-behavior.js */ "./node_modules/@polymer/polymer/lib/legacy/templatizer-behavior.js");
/* harmony import */ var _lib_elements_dom_bind_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./lib/elements/dom-bind.js */ "./node_modules/@polymer/polymer/lib/elements/dom-bind.js");
/* harmony import */ var _lib_elements_dom_repeat_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./lib/elements/dom-repeat.js */ "./node_modules/@polymer/polymer/lib/elements/dom-repeat.js");
/* harmony import */ var _lib_elements_dom_if_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./lib/elements/dom-if.js */ "./node_modules/@polymer/polymer/lib/elements/dom-if.js");
/* harmony import */ var _lib_elements_array_selector_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./lib/elements/array-selector.js */ "./node_modules/@polymer/polymer/lib/elements/array-selector.js");
/* harmony import */ var _lib_elements_custom_style_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./lib/elements/custom-style.js */ "./node_modules/@polymer/polymer/lib/elements/custom-style.js");
/* harmony import */ var _lib_legacy_mutable_data_behavior_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./lib/legacy/mutable-data-behavior.js */ "./node_modules/@polymer/polymer/lib/legacy/mutable-data-behavior.js");
/* harmony import */ var _lib_utils_html_tag_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./lib/utils/html-tag.js */ "./node_modules/@polymer/polymer/lib/utils/html-tag.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "html", function() { return _lib_utils_html_tag_js__WEBPACK_IMPORTED_MODULE_9__["html"]; });

/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/


/* template elements */






/* custom-style */


/* bc behaviors */


/* import html-tag to export html */

 // bc

const Base = Object(_lib_legacy_legacy_element_mixin_js__WEBPACK_IMPORTED_MODULE_0__["LegacyElementMixin"])(HTMLElement).prototype;

/***/ }),

/***/ "./node_modules/@webcomponents/shadycss/entrypoints/apply-shim.js":
/*!************************************************************************!*\
  !*** ./node_modules/@webcomponents/shadycss/entrypoints/apply-shim.js ***!
  \************************************************************************/
/*! no exports provided */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _src_apply_shim_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../src/apply-shim.js */ "./node_modules/@webcomponents/shadycss/src/apply-shim.js");
/* harmony import */ var _src_template_map_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../src/template-map.js */ "./node_modules/@webcomponents/shadycss/src/template-map.js");
/* harmony import */ var _src_style_util_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../src/style-util.js */ "./node_modules/@webcomponents/shadycss/src/style-util.js");
/* harmony import */ var _src_apply_shim_utils_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../src/apply-shim-utils.js */ "./node_modules/@webcomponents/shadycss/src/apply-shim-utils.js");
/* harmony import */ var _src_common_utils_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../src/common-utils.js */ "./node_modules/@webcomponents/shadycss/src/common-utils.js");
/* harmony import */ var _src_custom_style_interface_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../src/custom-style-interface.js */ "./node_modules/@webcomponents/shadycss/src/custom-style-interface.js");
/* harmony import */ var _src_style_settings_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../src/style-settings.js */ "./node_modules/@webcomponents/shadycss/src/style-settings.js");
/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/







 // eslint-disable-line no-unused-vars


/** @const {ApplyShim} */

const applyShim = new _src_apply_shim_js__WEBPACK_IMPORTED_MODULE_0__["default"]();

class ApplyShimInterface {
  constructor() {
    /** @type {?CustomStyleInterfaceInterface} */
    this.customStyleInterface = null;
    applyShim['invalidCallback'] = _src_apply_shim_utils_js__WEBPACK_IMPORTED_MODULE_3__["invalidate"];
  }

  ensure() {
    if (this.customStyleInterface) {
      return;
    }

    if (window.ShadyCSS.CustomStyleInterface) {
      this.customStyleInterface =
      /** @type {!CustomStyleInterfaceInterface} */
      window.ShadyCSS.CustomStyleInterface;

      this.customStyleInterface['transformCallback'] = style => {
        applyShim.transformCustomStyle(style);
      };

      this.customStyleInterface['validateCallback'] = () => {
        requestAnimationFrame(() => {
          if (this.customStyleInterface['enqueued']) {
            this.flushCustomStyles();
          }
        });
      };
    }
  }
  /**
   * @param {!HTMLTemplateElement} template
   * @param {string} elementName
   */


  prepareTemplate(template, elementName) {
    this.ensure();

    if (Object(_src_style_util_js__WEBPACK_IMPORTED_MODULE_2__["elementHasBuiltCss"])(template)) {
      return;
    }

    _src_template_map_js__WEBPACK_IMPORTED_MODULE_1__["default"][elementName] = template;
    let ast = applyShim.transformTemplate(template, elementName); // save original style ast to use for revalidating instances

    template['_styleAst'] = ast;
  }

  flushCustomStyles() {
    this.ensure();

    if (!this.customStyleInterface) {
      return;
    }

    let styles = this.customStyleInterface['processStyles']();

    if (!this.customStyleInterface['enqueued']) {
      return;
    }

    for (let i = 0; i < styles.length; i++) {
      let cs = styles[i];
      let style = this.customStyleInterface['getStyleForCustomStyle'](cs);

      if (style) {
        applyShim.transformCustomStyle(style);
      }
    }

    this.customStyleInterface['enqueued'] = false;
  }
  /**
   * @param {HTMLElement} element
   * @param {Object=} properties
   */


  styleSubtree(element, properties) {
    this.ensure();

    if (properties) {
      Object(_src_common_utils_js__WEBPACK_IMPORTED_MODULE_4__["updateNativeProperties"])(element, properties);
    }

    if (element.shadowRoot) {
      this.styleElement(element);
      let shadowChildren =
      /** @type {!ParentNode} */
      element.shadowRoot.children || element.shadowRoot.childNodes;

      for (let i = 0; i < shadowChildren.length; i++) {
        this.styleSubtree(
        /** @type {HTMLElement} */
        shadowChildren[i]);
      }
    } else {
      let children = element.children || element.childNodes;

      for (let i = 0; i < children.length; i++) {
        this.styleSubtree(
        /** @type {HTMLElement} */
        children[i]);
      }
    }
  }
  /**
   * @param {HTMLElement} element
   */


  styleElement(element) {
    this.ensure();
    let {
      is
    } = Object(_src_style_util_js__WEBPACK_IMPORTED_MODULE_2__["getIsExtends"])(element);
    let template = _src_template_map_js__WEBPACK_IMPORTED_MODULE_1__["default"][is];

    if (template && Object(_src_style_util_js__WEBPACK_IMPORTED_MODULE_2__["elementHasBuiltCss"])(template)) {
      return;
    }

    if (template && !_src_apply_shim_utils_js__WEBPACK_IMPORTED_MODULE_3__["templateIsValid"](template)) {
      // only revalidate template once
      if (!_src_apply_shim_utils_js__WEBPACK_IMPORTED_MODULE_3__["templateIsValidating"](template)) {
        this.prepareTemplate(template, is);
        _src_apply_shim_utils_js__WEBPACK_IMPORTED_MODULE_3__["startValidatingTemplate"](template);
      } // update this element instance


      let root = element.shadowRoot;

      if (root) {
        let style =
        /** @type {HTMLStyleElement} */
        root.querySelector('style');

        if (style) {
          // reuse the template's style ast, it has all the original css text
          style['__cssRules'] = template['_styleAst'];
          style.textContent = Object(_src_style_util_js__WEBPACK_IMPORTED_MODULE_2__["toCssText"])(template['_styleAst']);
        }
      }
    }
  }
  /**
   * @param {Object=} properties
   */


  styleDocument(properties) {
    this.ensure();
    this.styleSubtree(document.body, properties);
  }

}

if (!window.ShadyCSS || !window.ShadyCSS.ScopingShim) {
  const applyShimInterface = new ApplyShimInterface();
  let CustomStyleInterface = window.ShadyCSS && window.ShadyCSS.CustomStyleInterface;
  /** @suppress {duplicate} */

  window.ShadyCSS = {
    /**
     * @param {!HTMLTemplateElement} template
     * @param {string} elementName
     * @param {string=} elementExtends
     */
    prepareTemplate(template, elementName, elementExtends) {
      // eslint-disable-line no-unused-vars
      applyShimInterface.flushCustomStyles();
      applyShimInterface.prepareTemplate(template, elementName);
    },

    /**
     * @param {!HTMLTemplateElement} template
     * @param {string} elementName
     * @param {string=} elementExtends
     */
    prepareTemplateStyles(template, elementName, elementExtends) {
      window.ShadyCSS.prepareTemplate(template, elementName, elementExtends);
    },

    /**
     * @param {!HTMLTemplateElement} template
     * @param {string} elementName
     */
    prepareTemplateDom(template, elementName) {},

    // eslint-disable-line no-unused-vars

    /**
     * @param {!HTMLElement} element
     * @param {Object=} properties
     */
    styleSubtree(element, properties) {
      applyShimInterface.flushCustomStyles();
      applyShimInterface.styleSubtree(element, properties);
    },

    /**
     * @param {!HTMLElement} element
     */
    styleElement(element) {
      applyShimInterface.flushCustomStyles();
      applyShimInterface.styleElement(element);
    },

    /**
     * @param {Object=} properties
     */
    styleDocument(properties) {
      applyShimInterface.flushCustomStyles();
      applyShimInterface.styleDocument(properties);
    },

    /**
     * @param {Element} element
     * @param {string} property
     * @return {string}
     */
    getComputedStyleValue(element, property) {
      return Object(_src_common_utils_js__WEBPACK_IMPORTED_MODULE_4__["getComputedStyleValue"])(element, property);
    },

    flushCustomStyles() {
      applyShimInterface.flushCustomStyles();
    },

    nativeCss: _src_style_settings_js__WEBPACK_IMPORTED_MODULE_6__["nativeCssVariables"],
    nativeShadow: _src_style_settings_js__WEBPACK_IMPORTED_MODULE_6__["nativeShadow"],
    cssBuild: _src_style_settings_js__WEBPACK_IMPORTED_MODULE_6__["cssBuild"],
    disableRuntime: _src_style_settings_js__WEBPACK_IMPORTED_MODULE_6__["disableRuntime"]
  };

  if (CustomStyleInterface) {
    window.ShadyCSS.CustomStyleInterface = CustomStyleInterface;
  }
}

window.ShadyCSS.ApplyShim = applyShim;

/***/ }),

/***/ "./node_modules/@webcomponents/shadycss/entrypoints/custom-style-interface.js":
/*!************************************************************************************!*\
  !*** ./node_modules/@webcomponents/shadycss/entrypoints/custom-style-interface.js ***!
  \************************************************************************************/
/*! no exports provided */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _src_custom_style_interface_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../src/custom-style-interface.js */ "./node_modules/@webcomponents/shadycss/src/custom-style-interface.js");
/* harmony import */ var _src_common_utils_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../src/common-utils.js */ "./node_modules/@webcomponents/shadycss/src/common-utils.js");
/* harmony import */ var _src_style_settings_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../src/style-settings.js */ "./node_modules/@webcomponents/shadycss/src/style-settings.js");
/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/





const customStyleInterface = new _src_custom_style_interface_js__WEBPACK_IMPORTED_MODULE_0__["default"]();

if (!window.ShadyCSS) {
  window.ShadyCSS = {
    /**
     * @param {!HTMLTemplateElement} template
     * @param {string} elementName
     * @param {string=} elementExtends
     */
    prepareTemplate(template, elementName, elementExtends) {},

    // eslint-disable-line no-unused-vars

    /**
     * @param {!HTMLTemplateElement} template
     * @param {string} elementName
     */
    prepareTemplateDom(template, elementName) {},

    // eslint-disable-line no-unused-vars

    /**
     * @param {!HTMLTemplateElement} template
     * @param {string} elementName
     * @param {string=} elementExtends
     */
    prepareTemplateStyles(template, elementName, elementExtends) {},

    // eslint-disable-line no-unused-vars

    /**
     * @param {Element} element
     * @param {Object=} properties
     */
    styleSubtree(element, properties) {
      customStyleInterface.processStyles();
      Object(_src_common_utils_js__WEBPACK_IMPORTED_MODULE_1__["updateNativeProperties"])(element, properties);
    },

    /**
     * @param {Element} element
     */
    styleElement(element) {
      // eslint-disable-line no-unused-vars
      customStyleInterface.processStyles();
    },

    /**
     * @param {Object=} properties
     */
    styleDocument(properties) {
      customStyleInterface.processStyles();
      Object(_src_common_utils_js__WEBPACK_IMPORTED_MODULE_1__["updateNativeProperties"])(document.body, properties);
    },

    /**
     * @param {Element} element
     * @param {string} property
     * @return {string}
     */
    getComputedStyleValue(element, property) {
      return Object(_src_common_utils_js__WEBPACK_IMPORTED_MODULE_1__["getComputedStyleValue"])(element, property);
    },

    flushCustomStyles() {},

    nativeCss: _src_style_settings_js__WEBPACK_IMPORTED_MODULE_2__["nativeCssVariables"],
    nativeShadow: _src_style_settings_js__WEBPACK_IMPORTED_MODULE_2__["nativeShadow"],
    cssBuild: _src_style_settings_js__WEBPACK_IMPORTED_MODULE_2__["cssBuild"],
    disableRuntime: _src_style_settings_js__WEBPACK_IMPORTED_MODULE_2__["disableRuntime"]
  };
}

window.ShadyCSS.CustomStyleInterface = customStyleInterface;

/***/ }),

/***/ "./node_modules/@webcomponents/shadycss/src/apply-shim-utils.js":
/*!**********************************************************************!*\
  !*** ./node_modules/@webcomponents/shadycss/src/apply-shim-utils.js ***!
  \**********************************************************************/
/*! exports provided: invalidate, invalidateTemplate, isValid, templateIsValid, isValidating, templateIsValidating, startValidating, startValidatingTemplate, elementsAreInvalid */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "invalidate", function() { return invalidate; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "invalidateTemplate", function() { return invalidateTemplate; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isValid", function() { return isValid; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "templateIsValid", function() { return templateIsValid; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isValidating", function() { return isValidating; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "templateIsValidating", function() { return templateIsValidating; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "startValidating", function() { return startValidating; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "startValidatingTemplate", function() { return startValidatingTemplate; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "elementsAreInvalid", function() { return elementsAreInvalid; });
/* harmony import */ var _template_map_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./template-map.js */ "./node_modules/@webcomponents/shadycss/src/template-map.js");
/* harmony import */ var _css_parse_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./css-parse.js */ "./node_modules/@webcomponents/shadycss/src/css-parse.js");
/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/



 // eslint-disable-line no-unused-vars

/*
 * Utilities for handling invalidating apply-shim mixins for a given template.
 *
 * The invalidation strategy involves keeping track of the "current" version of a template's mixins, and updating that count when a mixin is invalidated.
 * The template
 */

/** @const {string} */

const CURRENT_VERSION = '_applyShimCurrentVersion';
/** @const {string} */

const NEXT_VERSION = '_applyShimNextVersion';
/** @const {string} */

const VALIDATING_VERSION = '_applyShimValidatingVersion';
/**
 * @const {Promise<void>}
 */

const promise = Promise.resolve();
/**
 * @param {string} elementName
 */

function invalidate(elementName) {
  let template = _template_map_js__WEBPACK_IMPORTED_MODULE_0__["default"][elementName];

  if (template) {
    invalidateTemplate(template);
  }
}
/**
 * This function can be called multiple times to mark a template invalid
 * and signal that the style inside must be regenerated.
 *
 * Use `startValidatingTemplate` to begin an asynchronous validation cycle.
 * During that cycle, call `templateIsValidating` to see if the template must
 * be revalidated
 * @param {HTMLTemplateElement} template
 */

function invalidateTemplate(template) {
  // default the current version to 0
  template[CURRENT_VERSION] = template[CURRENT_VERSION] || 0; // ensure the "validating for" flag exists

  template[VALIDATING_VERSION] = template[VALIDATING_VERSION] || 0; // increment the next version

  template[NEXT_VERSION] = (template[NEXT_VERSION] || 0) + 1;
}
/**
 * @param {string} elementName
 * @return {boolean}
 */

function isValid(elementName) {
  let template = _template_map_js__WEBPACK_IMPORTED_MODULE_0__["default"][elementName];

  if (template) {
    return templateIsValid(template);
  }

  return true;
}
/**
 * @param {HTMLTemplateElement} template
 * @return {boolean}
 */

function templateIsValid(template) {
  return template[CURRENT_VERSION] === template[NEXT_VERSION];
}
/**
 * @param {string} elementName
 * @return {boolean}
 */

function isValidating(elementName) {
  let template = _template_map_js__WEBPACK_IMPORTED_MODULE_0__["default"][elementName];

  if (template) {
    return templateIsValidating(template);
  }

  return false;
}
/**
 * Returns true if the template is currently invalid and `startValidating` has been called since the last invalidation.
 * If false, the template must be validated.
 * @param {HTMLTemplateElement} template
 * @return {boolean}
 */

function templateIsValidating(template) {
  return !templateIsValid(template) && template[VALIDATING_VERSION] === template[NEXT_VERSION];
}
/**
 * the template is marked as `validating` for one microtask so that all instances
 * found in the tree crawl of `applyStyle` will update themselves,
 * but the template will only be updated once.
 * @param {string} elementName
*/

function startValidating(elementName) {
  let template = _template_map_js__WEBPACK_IMPORTED_MODULE_0__["default"][elementName];
  startValidatingTemplate(template);
}
/**
 * Begin an asynchronous invalidation cycle.
 * This should be called after every validation of a template
 *
 * After one microtask, the template will be marked as valid until the next call to `invalidateTemplate`
 * @param {HTMLTemplateElement} template
 */

function startValidatingTemplate(template) {
  // remember that the current "next version" is the reason for this validation cycle
  template[VALIDATING_VERSION] = template[NEXT_VERSION]; // however, there only needs to be one async task to clear the counters

  if (!template._validating) {
    template._validating = true;
    promise.then(function () {
      // sync the current version to let future invalidations cause a refresh cycle
      template[CURRENT_VERSION] = template[NEXT_VERSION];
      template._validating = false;
    });
  }
}
/**
 * @return {boolean}
 */

function elementsAreInvalid() {
  for (let elementName in _template_map_js__WEBPACK_IMPORTED_MODULE_0__["default"]) {
    let template = _template_map_js__WEBPACK_IMPORTED_MODULE_0__["default"][elementName];

    if (!templateIsValid(template)) {
      return true;
    }
  }

  return false;
}

/***/ }),

/***/ "./node_modules/@webcomponents/shadycss/src/apply-shim.js":
/*!****************************************************************!*\
  !*** ./node_modules/@webcomponents/shadycss/src/apply-shim.js ***!
  \****************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _style_util_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./style-util.js */ "./node_modules/@webcomponents/shadycss/src/style-util.js");
/* harmony import */ var _common_regex_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./common-regex.js */ "./node_modules/@webcomponents/shadycss/src/common-regex.js");
/* harmony import */ var _common_utils_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./common-utils.js */ "./node_modules/@webcomponents/shadycss/src/common-utils.js");
/* harmony import */ var _css_parse_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./css-parse.js */ "./node_modules/@webcomponents/shadycss/src/css-parse.js");
/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/

/*
 * The apply shim simulates the behavior of `@apply` proposed at
 * https://tabatkins.github.io/specs/css-apply-rule/.
 * The approach is to convert a property like this:
 *
 *    --foo: {color: red; background: blue;}
 *
 * to this:
 *
 *    --foo_-_color: red;
 *    --foo_-_background: blue;
 *
 * Then where `@apply --foo` is used, that is converted to:
 *
 *    color: var(--foo_-_color);
 *    background: var(--foo_-_background);
 *
 * This approach generally works but there are some issues and limitations.
 * Consider, for example, that somewhere *between* where `--foo` is set and used,
 * another element sets it to:
 *
 *    --foo: { border: 2px solid red; }
 *
 * We must now ensure that the color and background from the previous setting
 * do not apply. This is accomplished by changing the property set to this:
 *
 *    --foo_-_border: 2px solid red;
 *    --foo_-_color: initial;
 *    --foo_-_background: initial;
 *
 * This works but introduces one new issue.
 * Consider this setup at the point where the `@apply` is used:
 *
 *    background: orange;
 *    `@apply` --foo;
 *
 * In this case the background will be unset (initial) rather than the desired
 * `orange`. We address this by altering the property set to use a fallback
 * value like this:
 *
 *    color: var(--foo_-_color);
 *    background: var(--foo_-_background, orange);
 *    border: var(--foo_-_border);
 *
 * Note that the default is retained in the property set and the `background` is
 * the desired `orange`. This leads us to a limitation.
 *
 * Limitation 1:

 * Only properties in the rule where the `@apply`
 * is used are considered as default values.
 * If another rule matches the element and sets `background` with
 * less specificity than the rule in which `@apply` appears,
 * the `background` will not be set.
 *
 * Limitation 2:
 *
 * When using Polymer's `updateStyles` api, new properties may not be set for
 * `@apply` properties.

*/





 // eslint-disable-line no-unused-vars

const APPLY_NAME_CLEAN = /;\s*/m;
const INITIAL_INHERIT = /^\s*(initial)|(inherit)\s*$/;
const IMPORTANT = /\s*!important/; // separator used between mixin-name and mixin-property-name when producing properties
// NOTE: plain '-' may cause collisions in user styles

const MIXIN_VAR_SEP = '_-_';
/**
 * @typedef {!Object<string, string>}
 */

let PropertyEntry; // eslint-disable-line no-unused-vars

/**
 * @typedef {!Object<string, boolean>}
 */

let DependantsEntry; // eslint-disable-line no-unused-vars

/** @typedef {{
 *    properties: PropertyEntry,
 *    dependants: DependantsEntry
 * }}
 */

let MixinMapEntry; // eslint-disable-line no-unused-vars
// map of mixin to property names
// --foo: {border: 2px} -> {properties: {(--foo, ['border'])}, dependants: {'element-name': proto}}

class MixinMap {
  constructor() {
    /** @type {!Object<string, !MixinMapEntry>} */
    this._map = {};
  }
  /**
   * @param {string} name
   * @param {!PropertyEntry} props
   */


  set(name, props) {
    name = name.trim();
    this._map[name] = {
      properties: props,
      dependants: {}
    };
  }
  /**
   * @param {string} name
   * @return {MixinMapEntry}
   */


  get(name) {
    name = name.trim();
    return this._map[name] || null;
  }

}
/**
 * Callback for when an element is marked invalid
 * @type {?function(string)}
 */


let invalidCallback = null;
/** @unrestricted */

class ApplyShim {
  constructor() {
    /** @type {?string} */
    this._currentElement = null;
    /** @type {HTMLMetaElement} */

    this._measureElement = null;
    this._map = new MixinMap();
  }
  /**
   * return true if `cssText` contains a mixin definition or consumption
   * @param {string} cssText
   * @return {boolean}
   */


  detectMixin(cssText) {
    return Object(_common_utils_js__WEBPACK_IMPORTED_MODULE_2__["detectMixin"])(cssText);
  }
  /**
   * Gather styles into one style for easier processing
   * @param {!HTMLTemplateElement} template
   * @return {HTMLStyleElement}
   */


  gatherStyles(template) {
    const styleText = Object(_style_util_js__WEBPACK_IMPORTED_MODULE_0__["gatherStyleText"])(template.content);

    if (styleText) {
      const style =
      /** @type {!HTMLStyleElement} */
      document.createElement('style');
      style.textContent = styleText;
      template.content.insertBefore(style, template.content.firstChild);
      return style;
    }

    return null;
  }
  /**
   * @param {!HTMLTemplateElement} template
   * @param {string} elementName
   * @return {StyleNode}
   */


  transformTemplate(template, elementName) {
    if (template._gatheredStyle === undefined) {
      template._gatheredStyle = this.gatherStyles(template);
    }
    /** @type {HTMLStyleElement} */


    const style = template._gatheredStyle;
    return style ? this.transformStyle(style, elementName) : null;
  }
  /**
   * @param {!HTMLStyleElement} style
   * @param {string} elementName
   * @return {StyleNode}
   */


  transformStyle(style, elementName = '') {
    let ast = Object(_style_util_js__WEBPACK_IMPORTED_MODULE_0__["rulesForStyle"])(style);
    this.transformRules(ast, elementName);
    style.textContent = Object(_style_util_js__WEBPACK_IMPORTED_MODULE_0__["toCssText"])(ast);
    return ast;
  }
  /**
   * @param {!HTMLStyleElement} style
   * @return {StyleNode}
   */


  transformCustomStyle(style) {
    let ast = Object(_style_util_js__WEBPACK_IMPORTED_MODULE_0__["rulesForStyle"])(style);
    Object(_style_util_js__WEBPACK_IMPORTED_MODULE_0__["forEachRule"])(ast, rule => {
      if (rule['selector'] === ':root') {
        rule['selector'] = 'html';
      }

      this.transformRule(rule);
    });
    style.textContent = Object(_style_util_js__WEBPACK_IMPORTED_MODULE_0__["toCssText"])(ast);
    return ast;
  }
  /**
   * @param {StyleNode} rules
   * @param {string} elementName
   */


  transformRules(rules, elementName) {
    this._currentElement = elementName;
    Object(_style_util_js__WEBPACK_IMPORTED_MODULE_0__["forEachRule"])(rules, r => {
      this.transformRule(r);
    });
    this._currentElement = null;
  }
  /**
   * @param {!StyleNode} rule
   */


  transformRule(rule) {
    rule['cssText'] = this.transformCssText(rule['parsedCssText'], rule); // :root was only used for variable assignment in property shim,
    // but generates invalid selectors with real properties.
    // replace with `:host > *`, which serves the same effect

    if (rule['selector'] === ':root') {
      rule['selector'] = ':host > *';
    }
  }
  /**
   * @param {string} cssText
   * @param {!StyleNode} rule
   * @return {string}
   */


  transformCssText(cssText, rule) {
    // produce variables
    cssText = cssText.replace(_common_regex_js__WEBPACK_IMPORTED_MODULE_1__["VAR_ASSIGN"], (matchText, propertyName, valueProperty, valueMixin) => this._produceCssProperties(matchText, propertyName, valueProperty, valueMixin, rule)); // consume mixins

    return this._consumeCssProperties(cssText, rule);
  }
  /**
   * @param {string} property
   * @return {string}
   */


  _getInitialValueForProperty(property) {
    if (!this._measureElement) {
      this._measureElement =
      /** @type {HTMLMetaElement} */
      document.createElement('meta');

      this._measureElement.setAttribute('apply-shim-measure', '');

      this._measureElement.style.all = 'initial';
      document.head.appendChild(this._measureElement);
    }

    return window.getComputedStyle(this._measureElement).getPropertyValue(property);
  }
  /**
   * Walk over all rules before this rule to find fallbacks for mixins
   *
   * @param {!StyleNode} startRule
   * @return {!Object}
   */


  _fallbacksFromPreviousRules(startRule) {
    // find the "top" rule
    let topRule = startRule;

    while (topRule['parent']) {
      topRule = topRule['parent'];
    }

    const fallbacks = {};
    let seenStartRule = false;
    Object(_style_util_js__WEBPACK_IMPORTED_MODULE_0__["forEachRule"])(topRule, r => {
      // stop when we hit the input rule
      seenStartRule = seenStartRule || r === startRule;

      if (seenStartRule) {
        return;
      } // NOTE: Only matching selectors are "safe" for this fallback processing
      // It would be prohibitive to run `matchesSelector()` on each selector,
      // so we cheat and only check if the same selector string is used, which
      // guarantees things like specificity matching


      if (r['selector'] === startRule['selector']) {
        Object.assign(fallbacks, this._cssTextToMap(r['parsedCssText']));
      }
    });
    return fallbacks;
  }
  /**
   * replace mixin consumption with variable consumption
   * @param {string} text
   * @param {!StyleNode=} rule
   * @return {string}
   */


  _consumeCssProperties(text, rule) {
    /** @type {Array} */
    let m = null; // loop over text until all mixins with defintions have been applied

    while (m = _common_regex_js__WEBPACK_IMPORTED_MODULE_1__["MIXIN_MATCH"].exec(text)) {
      let matchText = m[0];
      let mixinName = m[1];
      let idx = m.index; // collect properties before apply to be "defaults" if mixin might override them
      // match includes a "prefix", so find the start and end positions of @apply

      let applyPos = idx + matchText.indexOf('@apply');
      let afterApplyPos = idx + matchText.length; // find props defined before this @apply

      let textBeforeApply = text.slice(0, applyPos);
      let textAfterApply = text.slice(afterApplyPos);
      let defaults = rule ? this._fallbacksFromPreviousRules(rule) : {};
      Object.assign(defaults, this._cssTextToMap(textBeforeApply));

      let replacement = this._atApplyToCssProperties(mixinName, defaults); // use regex match position to replace mixin, keep linear processing time


      text = `${textBeforeApply}${replacement}${textAfterApply}`; // move regex search to _after_ replacement

      _common_regex_js__WEBPACK_IMPORTED_MODULE_1__["MIXIN_MATCH"].lastIndex = idx + replacement.length;
    }

    return text;
  }
  /**
   * produce variable consumption at the site of mixin consumption
   * `@apply` --foo; -> for all props (${propname}: var(--foo_-_${propname}, ${fallback[propname]}}))
   * Example:
   *  border: var(--foo_-_border); padding: var(--foo_-_padding, 2px)
   *
   * @param {string} mixinName
   * @param {Object} fallbacks
   * @return {string}
   */


  _atApplyToCssProperties(mixinName, fallbacks) {
    mixinName = mixinName.replace(APPLY_NAME_CLEAN, '');
    let vars = [];

    let mixinEntry = this._map.get(mixinName); // if we depend on a mixin before it is created
    // make a sentinel entry in the map to add this element as a dependency for when it is defined.


    if (!mixinEntry) {
      this._map.set(mixinName, {});

      mixinEntry = this._map.get(mixinName);
    }

    if (mixinEntry) {
      if (this._currentElement) {
        mixinEntry.dependants[this._currentElement] = true;
      }

      let p, parts, f;
      const properties = mixinEntry.properties;

      for (p in properties) {
        f = fallbacks && fallbacks[p];
        parts = [p, ': var(', mixinName, MIXIN_VAR_SEP, p];

        if (f) {
          parts.push(',', f.replace(IMPORTANT, ''));
        }

        parts.push(')');

        if (IMPORTANT.test(properties[p])) {
          parts.push(' !important');
        }

        vars.push(parts.join(''));
      }
    }

    return vars.join('; ');
  }
  /**
   * @param {string} property
   * @param {string} value
   * @return {string}
   */


  _replaceInitialOrInherit(property, value) {
    let match = INITIAL_INHERIT.exec(value);

    if (match) {
      if (match[1]) {
        // initial
        // replace `initial` with the concrete initial value for this property
        value = this._getInitialValueForProperty(property);
      } else {
        // inherit
        // with this purposfully illegal value, the variable will be invalid at
        // compute time (https://www.w3.org/TR/css-variables/#invalid-at-computed-value-time)
        // and for inheriting values, will behave similarly
        // we cannot support the same behavior for non inheriting values like 'border'
        value = 'apply-shim-inherit';
      }
    }

    return value;
  }
  /**
   * "parse" a mixin definition into a map of properties and values
   * cssTextToMap('border: 2px solid black') -> ('border', '2px solid black')
   * @param {string} text
   * @param {boolean=} replaceInitialOrInherit
   * @return {!Object<string, string>}
   */


  _cssTextToMap(text, replaceInitialOrInherit = false) {
    let props = text.split(';');
    let property, value;
    let out = {};

    for (let i = 0, p, sp; i < props.length; i++) {
      p = props[i];

      if (p) {
        sp = p.split(':'); // ignore lines that aren't definitions like @media

        if (sp.length > 1) {
          property = sp[0].trim(); // some properties may have ':' in the value, like data urls

          value = sp.slice(1).join(':');

          if (replaceInitialOrInherit) {
            value = this._replaceInitialOrInherit(property, value);
          }

          out[property] = value;
        }
      }
    }

    return out;
  }
  /**
   * @param {MixinMapEntry} mixinEntry
   */


  _invalidateMixinEntry(mixinEntry) {
    if (!invalidCallback) {
      return;
    }

    for (let elementName in mixinEntry.dependants) {
      if (elementName !== this._currentElement) {
        invalidCallback(elementName);
      }
    }
  }
  /**
   * @param {string} matchText
   * @param {string} propertyName
   * @param {?string} valueProperty
   * @param {?string} valueMixin
   * @param {!StyleNode} rule
   * @return {string}
   */


  _produceCssProperties(matchText, propertyName, valueProperty, valueMixin, rule) {
    // handle case where property value is a mixin
    if (valueProperty) {
      // form: --mixin2: var(--mixin1), where --mixin1 is in the map
      Object(_style_util_js__WEBPACK_IMPORTED_MODULE_0__["processVariableAndFallback"])(valueProperty, (prefix, value) => {
        if (value && this._map.get(value)) {
          valueMixin = `@apply ${value};`;
        }
      });
    }

    if (!valueMixin) {
      return matchText;
    }

    let mixinAsProperties = this._consumeCssProperties('' + valueMixin, rule);

    let prefix = matchText.slice(0, matchText.indexOf('--')); // `initial` and `inherit` as properties in a map should be replaced because
    // these keywords are eagerly evaluated when the mixin becomes CSS Custom Properties,
    // and would set the variable value, rather than carry the keyword to the `var()` usage.

    let mixinValues = this._cssTextToMap(mixinAsProperties, true);

    let combinedProps = mixinValues;

    let mixinEntry = this._map.get(propertyName);

    let oldProps = mixinEntry && mixinEntry.properties;

    if (oldProps) {
      // NOTE: since we use mixin, the map of properties is updated here
      // and this is what we want.
      combinedProps = Object.assign(Object.create(oldProps), mixinValues);
    } else {
      this._map.set(propertyName, combinedProps);
    }

    let out = [];
    let p, v; // set variables defined by current mixin

    let needToInvalidate = false;

    for (p in combinedProps) {
      v = mixinValues[p]; // if property not defined by current mixin, set initial

      if (v === undefined) {
        v = 'initial';
      }

      if (oldProps && !(p in oldProps)) {
        needToInvalidate = true;
      }

      out.push(`${propertyName}${MIXIN_VAR_SEP}${p}: ${v}`);
    }

    if (needToInvalidate) {
      this._invalidateMixinEntry(mixinEntry);
    }

    if (mixinEntry) {
      mixinEntry.properties = combinedProps;
    } // because the mixinMap is global, the mixin might conflict with
    // a different scope's simple variable definition:
    // Example:
    // some style somewhere:
    // --mixin1:{ ... }
    // --mixin2: var(--mixin1);
    // some other element:
    // --mixin1: 10px solid red;
    // --foo: var(--mixin1);
    // In this case, we leave the original variable definition in place.


    if (valueProperty) {
      prefix = `${matchText};${prefix}`;
    }

    return `${prefix}${out.join('; ')};`;
  }

}
/* exports */

/* eslint-disable no-self-assign */


ApplyShim.prototype['detectMixin'] = ApplyShim.prototype.detectMixin;
ApplyShim.prototype['transformStyle'] = ApplyShim.prototype.transformStyle;
ApplyShim.prototype['transformCustomStyle'] = ApplyShim.prototype.transformCustomStyle;
ApplyShim.prototype['transformRules'] = ApplyShim.prototype.transformRules;
ApplyShim.prototype['transformRule'] = ApplyShim.prototype.transformRule;
ApplyShim.prototype['transformTemplate'] = ApplyShim.prototype.transformTemplate;
ApplyShim.prototype['_separator'] = MIXIN_VAR_SEP;
/* eslint-enable no-self-assign */

Object.defineProperty(ApplyShim.prototype, 'invalidCallback', {
  /** @return {?function(string)} */
  get() {
    return invalidCallback;
  },

  /** @param {?function(string)} cb */
  set(cb) {
    invalidCallback = cb;
  }

});
/* harmony default export */ __webpack_exports__["default"] = (ApplyShim);

/***/ }),

/***/ "./node_modules/@webcomponents/shadycss/src/common-regex.js":
/*!******************************************************************!*\
  !*** ./node_modules/@webcomponents/shadycss/src/common-regex.js ***!
  \******************************************************************/
/*! exports provided: VAR_ASSIGN, MIXIN_MATCH, VAR_CONSUMED, ANIMATION_MATCH, MEDIA_MATCH, IS_VAR, BRACKETED, HOST_PREFIX, HOST_SUFFIX */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "VAR_ASSIGN", function() { return VAR_ASSIGN; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "MIXIN_MATCH", function() { return MIXIN_MATCH; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "VAR_CONSUMED", function() { return VAR_CONSUMED; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ANIMATION_MATCH", function() { return ANIMATION_MATCH; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "MEDIA_MATCH", function() { return MEDIA_MATCH; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "IS_VAR", function() { return IS_VAR; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "BRACKETED", function() { return BRACKETED; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HOST_PREFIX", function() { return HOST_PREFIX; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HOST_SUFFIX", function() { return HOST_SUFFIX; });
/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/
const VAR_ASSIGN = /(?:^|[;\s{]\s*)(--[\w-]*?)\s*:\s*(?:((?:'(?:\\'|.)*?'|"(?:\\"|.)*?"|\([^)]*?\)|[^};{])+)|\{([^}]*)\}(?:(?=[;\s}])|$))/gi;
const MIXIN_MATCH = /(?:^|\W+)@apply\s*\(?([^);\n]*)\)?/gi;
const VAR_CONSUMED = /(--[\w-]+)\s*([:,;)]|$)/gi;
const ANIMATION_MATCH = /(animation\s*:)|(animation-name\s*:)/;
const MEDIA_MATCH = /@media\s(.*)/;
const IS_VAR = /^--/;
const BRACKETED = /\{[^}]*\}/g;
const HOST_PREFIX = '(?:^|[^.#[:])';
const HOST_SUFFIX = '($|[.:[\\s>+~])';

/***/ }),

/***/ "./node_modules/@webcomponents/shadycss/src/common-utils.js":
/*!******************************************************************!*\
  !*** ./node_modules/@webcomponents/shadycss/src/common-utils.js ***!
  \******************************************************************/
/*! exports provided: updateNativeProperties, getComputedStyleValue, detectMixin */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "updateNativeProperties", function() { return updateNativeProperties; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getComputedStyleValue", function() { return getComputedStyleValue; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "detectMixin", function() { return detectMixin; });
/* harmony import */ var _common_regex_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./common-regex.js */ "./node_modules/@webcomponents/shadycss/src/common-regex.js");
/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/



/**
 * @param {Element} element
 * @param {Object=} properties
 */

function updateNativeProperties(element, properties) {
  // remove previous properties
  for (let p in properties) {
    // NOTE: for bc with shim, don't apply null values.
    if (p === null) {
      element.style.removeProperty(p);
    } else {
      element.style.setProperty(p, properties[p]);
    }
  }
}
/**
 * @param {Element} element
 * @param {string} property
 * @return {string}
 */

function getComputedStyleValue(element, property) {
  /**
   * @const {string}
   */
  const value = window.getComputedStyle(element).getPropertyValue(property);

  if (!value) {
    return '';
  } else {
    return value.trim();
  }
}
/**
 * return true if `cssText` contains a mixin definition or consumption
 * @param {string} cssText
 * @return {boolean}
 */

function detectMixin(cssText) {
  const has = _common_regex_js__WEBPACK_IMPORTED_MODULE_0__["MIXIN_MATCH"].test(cssText) || _common_regex_js__WEBPACK_IMPORTED_MODULE_0__["VAR_ASSIGN"].test(cssText); // reset state of the regexes

  _common_regex_js__WEBPACK_IMPORTED_MODULE_0__["MIXIN_MATCH"].lastIndex = 0;
  _common_regex_js__WEBPACK_IMPORTED_MODULE_0__["VAR_ASSIGN"].lastIndex = 0;
  return has;
}

/***/ }),

/***/ "./node_modules/@webcomponents/shadycss/src/css-parse.js":
/*!***************************************************************!*\
  !*** ./node_modules/@webcomponents/shadycss/src/css-parse.js ***!
  \***************************************************************/
/*! exports provided: StyleNode, parse, stringify, removeCustomPropAssignment, types */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "StyleNode", function() { return StyleNode; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "parse", function() { return parse; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "stringify", function() { return stringify; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "removeCustomPropAssignment", function() { return removeCustomPropAssignment; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "types", function() { return types; });
/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/

/*
Extremely simple css parser. Intended to be not more than what we need
and definitely not necessarily correct =).
*/

/** @unrestricted */

class StyleNode {
  constructor() {
    /** @type {number} */
    this['start'] = 0;
    /** @type {number} */

    this['end'] = 0;
    /** @type {StyleNode} */

    this['previous'] = null;
    /** @type {StyleNode} */

    this['parent'] = null;
    /** @type {Array<StyleNode>} */

    this['rules'] = null;
    /** @type {string} */

    this['parsedCssText'] = '';
    /** @type {string} */

    this['cssText'] = '';
    /** @type {boolean} */

    this['atRule'] = false;
    /** @type {number} */

    this['type'] = 0;
    /** @type {string} */

    this['keyframesName'] = '';
    /** @type {string} */

    this['selector'] = '';
    /** @type {string} */

    this['parsedSelector'] = '';
  }

}

 // given a string of css, return a simple rule tree

/**
 * @param {string} text
 * @return {StyleNode}
 */

function parse(text) {
  text = clean(text);
  return parseCss(lex(text), text);
} // remove stuff we don't care about that may hinder parsing

/**
 * @param {string} cssText
 * @return {string}
 */

function clean(cssText) {
  return cssText.replace(RX.comments, '').replace(RX.port, '');
} // super simple {...} lexer that returns a node tree

/**
 * @param {string} text
 * @return {StyleNode}
 */


function lex(text) {
  let root = new StyleNode();
  root['start'] = 0;
  root['end'] = text.length;
  let n = root;

  for (let i = 0, l = text.length; i < l; i++) {
    if (text[i] === OPEN_BRACE) {
      if (!n['rules']) {
        n['rules'] = [];
      }

      let p = n;
      let previous = p['rules'][p['rules'].length - 1] || null;
      n = new StyleNode();
      n['start'] = i + 1;
      n['parent'] = p;
      n['previous'] = previous;
      p['rules'].push(n);
    } else if (text[i] === CLOSE_BRACE) {
      n['end'] = i + 1;
      n = n['parent'] || root;
    }
  }

  return root;
} // add selectors/cssText to node tree

/**
 * @param {StyleNode} node
 * @param {string} text
 * @return {StyleNode}
 */


function parseCss(node, text) {
  let t = text.substring(node['start'], node['end'] - 1);
  node['parsedCssText'] = node['cssText'] = t.trim();

  if (node['parent']) {
    let ss = node['previous'] ? node['previous']['end'] : node['parent']['start'];
    t = text.substring(ss, node['start'] - 1);
    t = _expandUnicodeEscapes(t);
    t = t.replace(RX.multipleSpaces, ' '); // TODO(sorvell): ad hoc; make selector include only after last ;
    // helps with mixin syntax

    t = t.substring(t.lastIndexOf(';') + 1);
    let s = node['parsedSelector'] = node['selector'] = t.trim();
    node['atRule'] = s.indexOf(AT_START) === 0; // note, support a subset of rule types...

    if (node['atRule']) {
      if (s.indexOf(MEDIA_START) === 0) {
        node['type'] = types.MEDIA_RULE;
      } else if (s.match(RX.keyframesRule)) {
        node['type'] = types.KEYFRAMES_RULE;
        node['keyframesName'] = node['selector'].split(RX.multipleSpaces).pop();
      }
    } else {
      if (s.indexOf(VAR_START) === 0) {
        node['type'] = types.MIXIN_RULE;
      } else {
        node['type'] = types.STYLE_RULE;
      }
    }
  }

  let r$ = node['rules'];

  if (r$) {
    for (let i = 0, l = r$.length, r; i < l && (r = r$[i]); i++) {
      parseCss(r, text);
    }
  }

  return node;
}
/**
 * conversion of sort unicode escapes with spaces like `\33 ` (and longer) into
 * expanded form that doesn't require trailing space `\000033`
 * @param {string} s
 * @return {string}
 */


function _expandUnicodeEscapes(s) {
  return s.replace(/\\([0-9a-f]{1,6})\s/gi, function () {
    let code = arguments[1],
        repeat = 6 - code.length;

    while (repeat--) {
      code = '0' + code;
    }

    return '\\' + code;
  });
}
/**
 * stringify parsed css.
 * @param {StyleNode} node
 * @param {boolean=} preserveProperties
 * @param {string=} text
 * @return {string}
 */


function stringify(node, preserveProperties, text = '') {
  // calc rule cssText
  let cssText = '';

  if (node['cssText'] || node['rules']) {
    let r$ = node['rules'];

    if (r$ && !_hasMixinRules(r$)) {
      for (let i = 0, l = r$.length, r; i < l && (r = r$[i]); i++) {
        cssText = stringify(r, preserveProperties, cssText);
      }
    } else {
      cssText = preserveProperties ? node['cssText'] : removeCustomProps(node['cssText']);
      cssText = cssText.trim();

      if (cssText) {
        cssText = '  ' + cssText + '\n';
      }
    }
  } // emit rule if there is cssText


  if (cssText) {
    if (node['selector']) {
      text += node['selector'] + ' ' + OPEN_BRACE + '\n';
    }

    text += cssText;

    if (node['selector']) {
      text += CLOSE_BRACE + '\n\n';
    }
  }

  return text;
}
/**
 * @param {Array<StyleNode>} rules
 * @return {boolean}
 */

function _hasMixinRules(rules) {
  let r = rules[0];
  return Boolean(r) && Boolean(r['selector']) && r['selector'].indexOf(VAR_START) === 0;
}
/**
 * @param {string} cssText
 * @return {string}
 */


function removeCustomProps(cssText) {
  cssText = removeCustomPropAssignment(cssText);
  return removeCustomPropApply(cssText);
}
/**
 * @param {string} cssText
 * @return {string}
 */


function removeCustomPropAssignment(cssText) {
  return cssText.replace(RX.customProp, '').replace(RX.mixinProp, '');
}
/**
 * @param {string} cssText
 * @return {string}
 */

function removeCustomPropApply(cssText) {
  return cssText.replace(RX.mixinApply, '').replace(RX.varApply, '');
}
/** @enum {number} */


const types = {
  STYLE_RULE: 1,
  KEYFRAMES_RULE: 7,
  MEDIA_RULE: 4,
  MIXIN_RULE: 1000
};
const OPEN_BRACE = '{';
const CLOSE_BRACE = '}'; // helper regexp's

const RX = {
  comments: /\/\*[^*]*\*+([^/*][^*]*\*+)*\//gim,
  port: /@import[^;]*;/gim,
  customProp: /(?:^[^;\-\s}]+)?--[^;{}]*?:[^{};]*?(?:[;\n]|$)/gim,
  mixinProp: /(?:^[^;\-\s}]+)?--[^;{}]*?:[^{};]*?{[^}]*?}(?:[;\n]|$)?/gim,
  mixinApply: /@apply\s*\(?[^);]*\)?\s*(?:[;\n]|$)?/gim,
  varApply: /[^;:]*?:[^;]*?var\([^;]*\)(?:[;\n]|$)?/gim,
  keyframesRule: /^@[^\s]*keyframes/,
  multipleSpaces: /\s+/g
};
const VAR_START = '--';
const MEDIA_START = '@media';
const AT_START = '@';

/***/ }),

/***/ "./node_modules/@webcomponents/shadycss/src/custom-style-interface.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@webcomponents/shadycss/src/custom-style-interface.js ***!
  \****************************************************************************/
/*! exports provided: CustomStyleProvider, default, CustomStyleInterfaceInterface */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CustomStyleProvider", function() { return CustomStyleProvider; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return CustomStyleInterface; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CustomStyleInterfaceInterface", function() { return CustomStyleInterfaceInterface; });
/* harmony import */ var _document_wait_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./document-wait.js */ "./node_modules/@webcomponents/shadycss/src/document-wait.js");
/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/



/**
 * @typedef {HTMLStyleElement | {getStyle: function():HTMLStyleElement}}
 */

let CustomStyleProvider;
const SEEN_MARKER = '__seenByShadyCSS';
const CACHED_STYLE = '__shadyCSSCachedStyle';
/** @type {?function(!HTMLStyleElement)} */

let transformFn = null;
/** @type {?function()} */

let validateFn = null;
/**
This interface is provided to add document-level <style> elements to ShadyCSS for processing.
These styles must be processed by ShadyCSS to simulate ShadowRoot upper-bound encapsulation from outside styles
In addition, these styles may also need to be processed for @apply rules and CSS Custom Properties

To add document-level styles to ShadyCSS, one can call `ShadyCSS.addDocumentStyle(styleElement)` or `ShadyCSS.addDocumentStyle({getStyle: () => styleElement})`

In addition, if the process used to discover document-level styles can be synchronously flushed, one should set `ShadyCSS.documentStyleFlush`.
This function will be called when calculating styles.

An example usage of the document-level styling api can be found in `examples/document-style-lib.js`

@unrestricted
*/

class CustomStyleInterface {
  constructor() {
    /** @type {!Array<!CustomStyleProvider>} */
    this['customStyles'] = [];
    this['enqueued'] = false; // NOTE(dfreedm): use quotes here to prevent closure inlining to `function(){}`;

    Object(_document_wait_js__WEBPACK_IMPORTED_MODULE_0__["default"])(() => {
      if (window['ShadyCSS']['flushCustomStyles']) {
        window['ShadyCSS']['flushCustomStyles']();
      }
    });
  }
  /**
   * Queue a validation for new custom styles to batch style recalculations
   */


  enqueueDocumentValidation() {
    if (this['enqueued'] || !validateFn) {
      return;
    }

    this['enqueued'] = true;
    Object(_document_wait_js__WEBPACK_IMPORTED_MODULE_0__["default"])(validateFn);
  }
  /**
   * @param {!HTMLStyleElement} style
   */


  addCustomStyle(style) {
    if (!style[SEEN_MARKER]) {
      style[SEEN_MARKER] = true;
      this['customStyles'].push(style);
      this.enqueueDocumentValidation();
    }
  }
  /**
   * @param {!CustomStyleProvider} customStyle
   * @return {HTMLStyleElement}
   */


  getStyleForCustomStyle(customStyle) {
    if (customStyle[CACHED_STYLE]) {
      return customStyle[CACHED_STYLE];
    }

    let style;

    if (customStyle['getStyle']) {
      style = customStyle['getStyle']();
    } else {
      style = customStyle;
    }

    return style;
  }
  /**
   * @return {!Array<!CustomStyleProvider>}
   */


  processStyles() {
    const cs = this['customStyles'];

    for (let i = 0; i < cs.length; i++) {
      const customStyle = cs[i];

      if (customStyle[CACHED_STYLE]) {
        continue;
      }

      const style = this.getStyleForCustomStyle(customStyle);

      if (style) {
        // HTMLImports polyfill may have cloned the style into the main document,
        // which is referenced with __appliedElement.
        const styleToTransform =
        /** @type {!HTMLStyleElement} */
        style['__appliedElement'] || style;

        if (transformFn) {
          transformFn(styleToTransform);
        }

        customStyle[CACHED_STYLE] = styleToTransform;
      }
    }

    return cs;
  }

}
/* eslint-disable no-self-assign */

CustomStyleInterface.prototype['addCustomStyle'] = CustomStyleInterface.prototype.addCustomStyle;
CustomStyleInterface.prototype['getStyleForCustomStyle'] = CustomStyleInterface.prototype.getStyleForCustomStyle;
CustomStyleInterface.prototype['processStyles'] = CustomStyleInterface.prototype.processStyles;
/* eslint-enable no-self-assign */

Object.defineProperties(CustomStyleInterface.prototype, {
  'transformCallback': {
    /** @return {?function(!HTMLStyleElement)} */
    get() {
      return transformFn;
    },

    /** @param {?function(!HTMLStyleElement)} fn */
    set(fn) {
      transformFn = fn;
    }

  },
  'validateCallback': {
    /** @return {?function()} */
    get() {
      return validateFn;
    },

    /**
     * @param {?function()} fn
     * @this {CustomStyleInterface}
     */
    set(fn) {
      let needsEnqueue = false;

      if (!validateFn) {
        needsEnqueue = true;
      }

      validateFn = fn;

      if (needsEnqueue) {
        this.enqueueDocumentValidation();
      }
    }

  }
});
/** @typedef {{
 * customStyles: !Array<!CustomStyleProvider>,
 * addCustomStyle: function(!CustomStyleProvider),
 * getStyleForCustomStyle: function(!CustomStyleProvider): HTMLStyleElement,
 * findStyles: function(),
 * transformCallback: ?function(!HTMLStyleElement),
 * validateCallback: ?function()
 * }}
 */

const CustomStyleInterfaceInterface = {};

/***/ }),

/***/ "./node_modules/@webcomponents/shadycss/src/document-wait.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@webcomponents/shadycss/src/document-wait.js ***!
  \*******************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return documentWait; });
/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/

/** @type {Promise<void>} */

let readyPromise = null;
/** @type {?function(?function())} */

let whenReady = window['HTMLImports'] && window['HTMLImports']['whenReady'] || null;
/** @type {function()} */

let resolveFn;
/**
 * @param {?function()} callback
 */

function documentWait(callback) {
  requestAnimationFrame(function () {
    if (whenReady) {
      whenReady(callback);
    } else {
      if (!readyPromise) {
        readyPromise = new Promise(resolve => {
          resolveFn = resolve;
        });

        if (document.readyState === 'complete') {
          resolveFn();
        } else {
          document.addEventListener('readystatechange', () => {
            if (document.readyState === 'complete') {
              resolveFn();
            }
          });
        }
      }

      readyPromise.then(function () {
        callback && callback();
      });
    }
  });
}

/***/ }),

/***/ "./node_modules/@webcomponents/shadycss/src/style-settings.js":
/*!********************************************************************!*\
  !*** ./node_modules/@webcomponents/shadycss/src/style-settings.js ***!
  \********************************************************************/
/*! exports provided: nativeShadow, cssBuild, disableRuntime, nativeCssVariables */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "nativeShadow", function() { return nativeShadow; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "cssBuild", function() { return cssBuild; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "disableRuntime", function() { return disableRuntime; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "nativeCssVariables", function() { return nativeCssVariables; });
/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/


const nativeShadow = !(window['ShadyDOM'] && window['ShadyDOM']['inUse']);
let nativeCssVariables_;
/**
 * @param {(ShadyCSSOptions | ShadyCSSInterface)=} settings
 */

function calcCssVariables(settings) {
  if (settings && settings['shimcssproperties']) {
    nativeCssVariables_ = false;
  } else {
    // chrome 49 has semi-working css vars, check if box-shadow works
    // safari 9.1 has a recalc bug: https://bugs.webkit.org/show_bug.cgi?id=155782
    // However, shim css custom properties are only supported with ShadyDOM enabled,
    // so fall back on native if we do not detect ShadyDOM
    // Edge 15: custom properties used in ::before and ::after will also be used in the parent element
    // https://developer.microsoft.com/en-us/microsoft-edge/platform/issues/12414257/
    nativeCssVariables_ = nativeShadow || Boolean(!navigator.userAgent.match(/AppleWebKit\/601|Edge\/15/) && window.CSS && CSS.supports && CSS.supports('box-shadow', '0 0 0 var(--foo)'));
  }
}
/** @type {string | undefined} */


let cssBuild;

if (window.ShadyCSS && window.ShadyCSS.cssBuild !== undefined) {
  cssBuild = window.ShadyCSS.cssBuild;
}
/** @type {boolean} */


const disableRuntime = Boolean(window.ShadyCSS && window.ShadyCSS.disableRuntime);

if (window.ShadyCSS && window.ShadyCSS.nativeCss !== undefined) {
  nativeCssVariables_ = window.ShadyCSS.nativeCss;
} else if (window.ShadyCSS) {
  calcCssVariables(window.ShadyCSS); // reset window variable to let ShadyCSS API take its place

  window.ShadyCSS = undefined;
} else {
  calcCssVariables(window['WebComponents'] && window['WebComponents']['flags']);
} // Hack for type error under new type inference which doesn't like that
// nativeCssVariables is updated in a function and assigns the type
// `function(): ?` instead of `boolean`.


const nativeCssVariables =
/** @type {boolean} */
nativeCssVariables_;

/***/ }),

/***/ "./node_modules/@webcomponents/shadycss/src/style-util.js":
/*!****************************************************************!*\
  !*** ./node_modules/@webcomponents/shadycss/src/style-util.js ***!
  \****************************************************************/
/*! exports provided: toCssText, rulesForStyle, isKeyframesSelector, forEachRule, applyCss, createScopeStyle, applyStylePlaceHolder, applyStyle, isTargetedBuild, findMatchingParen, processVariableAndFallback, setElementClassRaw, wrap, getIsExtends, gatherStyleText, splitSelectorList, getCssBuild, elementHasBuiltCss, getBuildComment, isOptimalCssBuild */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "toCssText", function() { return toCssText; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "rulesForStyle", function() { return rulesForStyle; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isKeyframesSelector", function() { return isKeyframesSelector; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "forEachRule", function() { return forEachRule; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "applyCss", function() { return applyCss; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "createScopeStyle", function() { return createScopeStyle; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "applyStylePlaceHolder", function() { return applyStylePlaceHolder; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "applyStyle", function() { return applyStyle; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isTargetedBuild", function() { return isTargetedBuild; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "findMatchingParen", function() { return findMatchingParen; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "processVariableAndFallback", function() { return processVariableAndFallback; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "setElementClassRaw", function() { return setElementClassRaw; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "wrap", function() { return wrap; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getIsExtends", function() { return getIsExtends; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "gatherStyleText", function() { return gatherStyleText; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "splitSelectorList", function() { return splitSelectorList; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getCssBuild", function() { return getCssBuild; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "elementHasBuiltCss", function() { return elementHasBuiltCss; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getBuildComment", function() { return getBuildComment; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isOptimalCssBuild", function() { return isOptimalCssBuild; });
/* harmony import */ var _style_settings_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./style-settings.js */ "./node_modules/@webcomponents/shadycss/src/style-settings.js");
/* harmony import */ var _css_parse_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./css-parse.js */ "./node_modules/@webcomponents/shadycss/src/css-parse.js");
/* harmony import */ var _common_regex_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./common-regex.js */ "./node_modules/@webcomponents/shadycss/src/common-regex.js");
/* harmony import */ var _unscoped_style_handler_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./unscoped-style-handler.js */ "./node_modules/@webcomponents/shadycss/src/unscoped-style-handler.js");
/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/



 // eslint-disable-line no-unused-vars



/**
 * @param {string|StyleNode} rules
 * @param {function(StyleNode)=} callback
 * @return {string}
 */

function toCssText(rules, callback) {
  if (!rules) {
    return '';
  }

  if (typeof rules === 'string') {
    rules = Object(_css_parse_js__WEBPACK_IMPORTED_MODULE_1__["parse"])(rules);
  }

  if (callback) {
    forEachRule(rules, callback);
  }

  return Object(_css_parse_js__WEBPACK_IMPORTED_MODULE_1__["stringify"])(rules, _style_settings_js__WEBPACK_IMPORTED_MODULE_0__["nativeCssVariables"]);
}
/**
 * @param {HTMLStyleElement} style
 * @return {StyleNode}
 */

function rulesForStyle(style) {
  if (!style['__cssRules'] && style.textContent) {
    style['__cssRules'] = Object(_css_parse_js__WEBPACK_IMPORTED_MODULE_1__["parse"])(style.textContent);
  }

  return style['__cssRules'] || null;
} // Tests if a rule is a keyframes selector, which looks almost exactly
// like a normal selector but is not (it has nothing to do with scoping
// for example).

/**
 * @param {StyleNode} rule
 * @return {boolean}
 */

function isKeyframesSelector(rule) {
  return Boolean(rule['parent']) && rule['parent']['type'] === _css_parse_js__WEBPACK_IMPORTED_MODULE_1__["types"].KEYFRAMES_RULE;
}
/**
 * @param {StyleNode} node
 * @param {Function=} styleRuleCallback
 * @param {Function=} keyframesRuleCallback
 * @param {boolean=} onlyActiveRules
 */

function forEachRule(node, styleRuleCallback, keyframesRuleCallback, onlyActiveRules) {
  if (!node) {
    return;
  }

  let skipRules = false;
  let type = node['type'];

  if (onlyActiveRules) {
    if (type === _css_parse_js__WEBPACK_IMPORTED_MODULE_1__["types"].MEDIA_RULE) {
      let matchMedia = node['selector'].match(_common_regex_js__WEBPACK_IMPORTED_MODULE_2__["MEDIA_MATCH"]);

      if (matchMedia) {
        // if rule is a non matching @media rule, skip subrules
        if (!window.matchMedia(matchMedia[1]).matches) {
          skipRules = true;
        }
      }
    }
  }

  if (type === _css_parse_js__WEBPACK_IMPORTED_MODULE_1__["types"].STYLE_RULE) {
    styleRuleCallback(node);
  } else if (keyframesRuleCallback && type === _css_parse_js__WEBPACK_IMPORTED_MODULE_1__["types"].KEYFRAMES_RULE) {
    keyframesRuleCallback(node);
  } else if (type === _css_parse_js__WEBPACK_IMPORTED_MODULE_1__["types"].MIXIN_RULE) {
    skipRules = true;
  }

  let r$ = node['rules'];

  if (r$ && !skipRules) {
    for (let i = 0, l = r$.length, r; i < l && (r = r$[i]); i++) {
      forEachRule(r, styleRuleCallback, keyframesRuleCallback, onlyActiveRules);
    }
  }
} // add a string of cssText to the document.

/**
 * @param {string} cssText
 * @param {string} moniker
 * @param {Node} target
 * @param {Node} contextNode
 * @return {HTMLStyleElement}
 */

function applyCss(cssText, moniker, target, contextNode) {
  let style = createScopeStyle(cssText, moniker);
  applyStyle(style, target, contextNode);
  return style;
}
/**
 * @param {string} cssText
 * @param {string} moniker
 * @return {HTMLStyleElement}
 */

function createScopeStyle(cssText, moniker) {
  let style =
  /** @type {HTMLStyleElement} */
  document.createElement('style');

  if (moniker) {
    style.setAttribute('scope', moniker);
  }

  style.textContent = cssText;
  return style;
}
/**
 * Track the position of the last added style for placing placeholders
 * @type {Node}
 */

let lastHeadApplyNode = null; // insert a comment node as a styling position placeholder.

/**
 * @param {string} moniker
 * @return {!Comment}
 */

function applyStylePlaceHolder(moniker) {
  let placeHolder = document.createComment(' Shady DOM styles for ' + moniker + ' ');
  let after = lastHeadApplyNode ? lastHeadApplyNode['nextSibling'] : null;
  let scope = document.head;
  scope.insertBefore(placeHolder, after || scope.firstChild);
  lastHeadApplyNode = placeHolder;
  return placeHolder;
}
/**
 * @param {HTMLStyleElement} style
 * @param {?Node} target
 * @param {?Node} contextNode
 */

function applyStyle(style, target, contextNode) {
  target = target || document.head;
  let after = contextNode && contextNode.nextSibling || target.firstChild;
  target.insertBefore(style, after);

  if (!lastHeadApplyNode) {
    lastHeadApplyNode = style;
  } else {
    // only update lastHeadApplyNode if the new style is inserted after the old lastHeadApplyNode
    let position = style.compareDocumentPosition(lastHeadApplyNode);

    if (position === Node.DOCUMENT_POSITION_PRECEDING) {
      lastHeadApplyNode = style;
    }
  }
}
/**
 * @param {string} buildType
 * @return {boolean}
 */

function isTargetedBuild(buildType) {
  return _style_settings_js__WEBPACK_IMPORTED_MODULE_0__["nativeShadow"] ? buildType === 'shadow' : buildType === 'shady';
}
/**
 * Walk from text[start] matching parens and
 * returns position of the outer end paren
 * @param {string} text
 * @param {number} start
 * @return {number}
 */

function findMatchingParen(text, start) {
  let level = 0;

  for (let i = start, l = text.length; i < l; i++) {
    if (text[i] === '(') {
      level++;
    } else if (text[i] === ')') {
      if (--level === 0) {
        return i;
      }
    }
  }

  return -1;
}
/**
 * @param {string} str
 * @param {function(string, string, string, string)} callback
 */

function processVariableAndFallback(str, callback) {
  // find 'var('
  let start = str.indexOf('var(');

  if (start === -1) {
    // no var?, everything is prefix
    return callback(str, '', '', '');
  } //${prefix}var(${inner})${suffix}


  let end = findMatchingParen(str, start + 3);
  let inner = str.substring(start + 4, end);
  let prefix = str.substring(0, start); // suffix may have other variables

  let suffix = processVariableAndFallback(str.substring(end + 1), callback);
  let comma = inner.indexOf(','); // value and fallback args should be trimmed to match in property lookup

  if (comma === -1) {
    // variable, no fallback
    return callback(prefix, inner.trim(), '', suffix);
  } // var(${value},${fallback})


  let value = inner.substring(0, comma).trim();
  let fallback = inner.substring(comma + 1).trim();
  return callback(prefix, value, fallback, suffix);
}
/**
 * @param {Element} element
 * @param {string} value
 */

function setElementClassRaw(element, value) {
  // use native setAttribute provided by ShadyDOM when setAttribute is patched
  if (_style_settings_js__WEBPACK_IMPORTED_MODULE_0__["nativeShadow"]) {
    element.setAttribute('class', value);
  } else {
    window['ShadyDOM']['nativeMethods']['setAttribute'].call(element, 'class', value);
  }
}
/**
 * @type {function(*):*}
 */

const wrap = window['ShadyDOM'] && window['ShadyDOM']['wrap'] || (node => node);
/**
 * @param {Element | {is: string, extends: string}} element
 * @return {{is: string, typeExtension: string}}
 */

function getIsExtends(element) {
  let localName = element['localName'];
  let is = '',
      typeExtension = '';
  /*
  NOTE: technically, this can be wrong for certain svg elements
  with `-` in the name like `<font-face>`
  */

  if (localName) {
    if (localName.indexOf('-') > -1) {
      is = localName;
    } else {
      typeExtension = localName;
      is = element.getAttribute && element.getAttribute('is') || '';
    }
  } else {
    is =
    /** @type {?} */
    element.is;
    typeExtension =
    /** @type {?} */
    element.extends;
  }

  return {
    is,
    typeExtension
  };
}
/**
 * @param {Element|DocumentFragment} element
 * @return {string}
 */

function gatherStyleText(element) {
  /** @type {!Array<string>} */
  const styleTextParts = [];
  const styles =
  /** @type {!NodeList<!HTMLStyleElement>} */
  element.querySelectorAll('style');

  for (let i = 0; i < styles.length; i++) {
    const style = styles[i];

    if (Object(_unscoped_style_handler_js__WEBPACK_IMPORTED_MODULE_3__["isUnscopedStyle"])(style)) {
      if (!_style_settings_js__WEBPACK_IMPORTED_MODULE_0__["nativeShadow"]) {
        Object(_unscoped_style_handler_js__WEBPACK_IMPORTED_MODULE_3__["processUnscopedStyle"])(style);
        style.parentNode.removeChild(style);
      }
    } else {
      styleTextParts.push(style.textContent);
      style.parentNode.removeChild(style);
    }
  }

  return styleTextParts.join('').trim();
}
/**
 * Split a selector separated by commas into an array in a smart way
 * @param {string} selector
 * @return {!Array<string>}
 */

function splitSelectorList(selector) {
  const parts = [];
  let part = '';

  for (let i = 0; i >= 0 && i < selector.length; i++) {
    // A selector with parentheses will be one complete part
    if (selector[i] === '(') {
      // find the matching paren
      const end = findMatchingParen(selector, i); // push the paren block into the part

      part += selector.slice(i, end + 1); // move the index to after the paren block

      i = end;
    } else if (selector[i] === ',') {
      parts.push(part);
      part = '';
    } else {
      part += selector[i];
    }
  } // catch any pieces after the last comma


  if (part) {
    parts.push(part);
  }

  return parts;
}
const CSS_BUILD_ATTR = 'css-build';
/**
 * Return the polymer-css-build "build type" applied to this element
 *
 * @param {!HTMLElement} element
 * @return {string} Can be "", "shady", or "shadow"
 */

function getCssBuild(element) {
  if (_style_settings_js__WEBPACK_IMPORTED_MODULE_0__["cssBuild"] !== undefined) {
    return (
      /** @type {string} */
      _style_settings_js__WEBPACK_IMPORTED_MODULE_0__["cssBuild"]
    );
  }

  if (element.__cssBuild === undefined) {
    // try attribute first, as it is the common case
    const attrValue = element.getAttribute(CSS_BUILD_ATTR);

    if (attrValue) {
      element.__cssBuild = attrValue;
    } else {
      const buildComment = getBuildComment(element);

      if (buildComment !== '') {
        // remove build comment so it is not needlessly copied into every element instance
        removeBuildComment(element);
      }

      element.__cssBuild = buildComment;
    }
  }

  return element.__cssBuild || '';
}
/**
 * Check if the given element, either a <template> or <style>, has been processed
 * by polymer-css-build.
 *
 * If so, then we can make a number of optimizations:
 * - polymer-css-build will decompose mixins into individual CSS Custom Properties,
 * so the ApplyShim can be skipped entirely.
 * - Under native ShadowDOM, the style text can just be copied into each instance
 * without modification
 * - If the build is "shady" and ShadyDOM is in use, the styling does not need
 * scoping beyond the shimming of CSS Custom Properties
 *
 * @param {!HTMLElement} element
 * @return {boolean}
 */

function elementHasBuiltCss(element) {
  return getCssBuild(element) !== '';
}
/**
 * For templates made with tagged template literals, polymer-css-build will
 * insert a comment of the form `<!--css-build:shadow-->`
 *
 * @param {!HTMLElement} element
 * @return {string}
 */

function getBuildComment(element) {
  const buildComment = element.localName === 'template' ?
  /** @type {!HTMLTemplateElement} */
  element.content.firstChild : element.firstChild;

  if (buildComment instanceof Comment) {
    const commentParts = buildComment.textContent.trim().split(':');

    if (commentParts[0] === CSS_BUILD_ATTR) {
      return commentParts[1];
    }
  }

  return '';
}
/**
 * Check if the css build status is optimal, and do no unneeded work.
 *
 * @param {string=} cssBuild CSS build status
 * @return {boolean} css build is optimal or not
 */

function isOptimalCssBuild(cssBuild = '') {
  // CSS custom property shim always requires work
  if (cssBuild === '' || !_style_settings_js__WEBPACK_IMPORTED_MODULE_0__["nativeCssVariables"]) {
    return false;
  }

  return _style_settings_js__WEBPACK_IMPORTED_MODULE_0__["nativeShadow"] ? cssBuild === 'shadow' : cssBuild === 'shady';
}
/**
 * @param {!HTMLElement} element
 */

function removeBuildComment(element) {
  const buildComment = element.localName === 'template' ?
  /** @type {!HTMLTemplateElement} */
  element.content.firstChild : element.firstChild;
  buildComment.parentNode.removeChild(buildComment);
}

/***/ }),

/***/ "./node_modules/@webcomponents/shadycss/src/template-map.js":
/*!******************************************************************!*\
  !*** ./node_modules/@webcomponents/shadycss/src/template-map.js ***!
  \******************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/

/**
 * @const {!Object<string, !HTMLTemplateElement>}
 */

const templateMap = {};
/* harmony default export */ __webpack_exports__["default"] = (templateMap);

/***/ }),

/***/ "./node_modules/@webcomponents/shadycss/src/unscoped-style-handler.js":
/*!****************************************************************************!*\
  !*** ./node_modules/@webcomponents/shadycss/src/unscoped-style-handler.js ***!
  \****************************************************************************/
/*! exports provided: scopingAttribute, processUnscopedStyle, isUnscopedStyle */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "scopingAttribute", function() { return scopingAttribute; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "processUnscopedStyle", function() { return processUnscopedStyle; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isUnscopedStyle", function() { return isUnscopedStyle; });
/**
@license
Copyright (c) 2017 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/

/** @type {!Set<string>} */

const styleTextSet = new Set();
const scopingAttribute = 'shady-unscoped';
/**
 * Add a specifically-marked style to the document directly, and only one copy of that style.
 *
 * @param {!HTMLStyleElement} style
 * @return {undefined}
 */

function processUnscopedStyle(style) {
  const text = style.textContent;

  if (!styleTextSet.has(text)) {
    styleTextSet.add(text);
    const newStyle = style.cloneNode(true);
    document.head.appendChild(newStyle);
  }
}
/**
 * Check if a style is supposed to be unscoped
 * @param {!HTMLStyleElement} style
 * @return {boolean} true if the style has the unscoping attribute
 */

function isUnscopedStyle(style) {
  return style.hasAttribute(scopingAttribute);
}

/***/ })

}]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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