(self["webpackJsonp"] = self["webpackJsonp"] || []).push([["vendors~leaflet"],{

/***/ "./node_modules/leaflet/dist/leaflet-src.js":
/*!**************************************************!*\
  !*** ./node_modules/leaflet/dist/leaflet-src.js ***!
  \**************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

/* @preserve
 * Leaflet 1.4.0, a JS library for interactive maps. http://leafletjs.com
 * (c) 2010-2018 Vladimir Agafonkin, (c) 2010-2011 CloudMade
 */
(function (global, factory) {
   true ? factory(exports) : undefined;
})(this, function (exports) {
  'use strict';

  var version = "1.4.0";
  /*
   * @namespace Util
   *
   * Various utility functions, used by Leaflet internally.
   */

  var freeze = Object.freeze;

  Object.freeze = function (obj) {
    return obj;
  }; // @function extend(dest: Object, src?: Object): Object
  // Merges the properties of the `src` object (or multiple objects) into `dest` object and returns the latter. Has an `L.extend` shortcut.


  function extend(dest) {
    var i, j, len, src;

    for (j = 1, len = arguments.length; j < len; j++) {
      src = arguments[j];

      for (i in src) {
        dest[i] = src[i];
      }
    }

    return dest;
  } // @function create(proto: Object, properties?: Object): Object
  // Compatibility polyfill for [Object.create](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object/create)


  var create = Object.create || function () {
    function F() {}

    return function (proto) {
      F.prototype = proto;
      return new F();
    };
  }(); // @function bind(fn: Function, …): Function
  // Returns a new function bound to the arguments passed, like [Function.prototype.bind](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Function/bind).
  // Has a `L.bind()` shortcut.


  function bind(fn, obj) {
    var slice = Array.prototype.slice;

    if (fn.bind) {
      return fn.bind.apply(fn, slice.call(arguments, 1));
    }

    var args = slice.call(arguments, 2);
    return function () {
      return fn.apply(obj, args.length ? args.concat(slice.call(arguments)) : arguments);
    };
  } // @property lastId: Number
  // Last unique ID used by [`stamp()`](#util-stamp)


  var lastId = 0; // @function stamp(obj: Object): Number
  // Returns the unique ID of an object, assigning it one if it doesn't have it.

  function stamp(obj) {
    /*eslint-disable */
    obj._leaflet_id = obj._leaflet_id || ++lastId;
    return obj._leaflet_id;
    /* eslint-enable */
  } // @function throttle(fn: Function, time: Number, context: Object): Function
  // Returns a function which executes function `fn` with the given scope `context`
  // (so that the `this` keyword refers to `context` inside `fn`'s code). The function
  // `fn` will be called no more than one time per given amount of `time`. The arguments
  // received by the bound function will be any arguments passed when binding the
  // function, followed by any arguments passed when invoking the bound function.
  // Has an `L.throttle` shortcut.


  function throttle(fn, time, context) {
    var lock, args, wrapperFn, later;

    later = function () {
      // reset lock and call if queued
      lock = false;

      if (args) {
        wrapperFn.apply(context, args);
        args = false;
      }
    };

    wrapperFn = function () {
      if (lock) {
        // called too soon, queue to call later
        args = arguments;
      } else {
        // call and lock until later
        fn.apply(context, arguments);
        setTimeout(later, time);
        lock = true;
      }
    };

    return wrapperFn;
  } // @function wrapNum(num: Number, range: Number[], includeMax?: Boolean): Number
  // Returns the number `num` modulo `range` in such a way so it lies within
  // `range[0]` and `range[1]`. The returned value will be always smaller than
  // `range[1]` unless `includeMax` is set to `true`.


  function wrapNum(x, range, includeMax) {
    var max = range[1],
        min = range[0],
        d = max - min;
    return x === max && includeMax ? x : ((x - min) % d + d) % d + min;
  } // @function falseFn(): Function
  // Returns a function which always returns `false`.


  function falseFn() {
    return false;
  } // @function formatNum(num: Number, digits?: Number): Number
  // Returns the number `num` rounded to `digits` decimals, or to 6 decimals by default.


  function formatNum(num, digits) {
    var pow = Math.pow(10, digits === undefined ? 6 : digits);
    return Math.round(num * pow) / pow;
  } // @function trim(str: String): String
  // Compatibility polyfill for [String.prototype.trim](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String/Trim)


  function trim(str) {
    return str.trim ? str.trim() : str.replace(/^\s+|\s+$/g, '');
  } // @function splitWords(str: String): String[]
  // Trims and splits the string on whitespace and returns the array of parts.


  function splitWords(str) {
    return trim(str).split(/\s+/);
  } // @function setOptions(obj: Object, options: Object): Object
  // Merges the given properties to the `options` of the `obj` object, returning the resulting options. See `Class options`. Has an `L.setOptions` shortcut.


  function setOptions(obj, options) {
    if (!obj.hasOwnProperty('options')) {
      obj.options = obj.options ? create(obj.options) : {};
    }

    for (var i in options) {
      obj.options[i] = options[i];
    }

    return obj.options;
  } // @function getParamString(obj: Object, existingUrl?: String, uppercase?: Boolean): String
  // Converts an object into a parameter URL string, e.g. `{a: "foo", b: "bar"}`
  // translates to `'?a=foo&b=bar'`. If `existingUrl` is set, the parameters will
  // be appended at the end. If `uppercase` is `true`, the parameter names will
  // be uppercased (e.g. `'?A=foo&B=bar'`)


  function getParamString(obj, existingUrl, uppercase) {
    var params = [];

    for (var i in obj) {
      params.push(encodeURIComponent(uppercase ? i.toUpperCase() : i) + '=' + encodeURIComponent(obj[i]));
    }

    return (!existingUrl || existingUrl.indexOf('?') === -1 ? '?' : '&') + params.join('&');
  }

  var templateRe = /\{ *([\w_-]+) *\}/g; // @function template(str: String, data: Object): String
  // Simple templating facility, accepts a template string of the form `'Hello {a}, {b}'`
  // and a data object like `{a: 'foo', b: 'bar'}`, returns evaluated string
  // `('Hello foo, bar')`. You can also specify functions instead of strings for
  // data values — they will be evaluated passing `data` as an argument.

  function template(str, data) {
    return str.replace(templateRe, function (str, key) {
      var value = data[key];

      if (value === undefined) {
        throw new Error('No value provided for variable ' + str);
      } else if (typeof value === 'function') {
        value = value(data);
      }

      return value;
    });
  } // @function isArray(obj): Boolean
  // Compatibility polyfill for [Array.isArray](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Array/isArray)


  var isArray = Array.isArray || function (obj) {
    return Object.prototype.toString.call(obj) === '[object Array]';
  }; // @function indexOf(array: Array, el: Object): Number
  // Compatibility polyfill for [Array.prototype.indexOf](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Array/indexOf)


  function indexOf(array, el) {
    for (var i = 0; i < array.length; i++) {
      if (array[i] === el) {
        return i;
      }
    }

    return -1;
  } // @property emptyImageUrl: String
  // Data URI string containing a base64-encoded empty GIF image.
  // Used as a hack to free memory from unused images on WebKit-powered
  // mobile devices (by setting image `src` to this string).


  var emptyImageUrl = 'data:image/gif;base64,R0lGODlhAQABAAD/ACwAAAAAAQABAAACADs='; // inspired by http://paulirish.com/2011/requestanimationframe-for-smart-animating/

  function getPrefixed(name) {
    return window['webkit' + name] || window['moz' + name] || window['ms' + name];
  }

  var lastTime = 0; // fallback for IE 7-8

  function timeoutDefer(fn) {
    var time = +new Date(),
        timeToCall = Math.max(0, 16 - (time - lastTime));
    lastTime = time + timeToCall;
    return window.setTimeout(fn, timeToCall);
  }

  var requestFn = window.requestAnimationFrame || getPrefixed('RequestAnimationFrame') || timeoutDefer;

  var cancelFn = window.cancelAnimationFrame || getPrefixed('CancelAnimationFrame') || getPrefixed('CancelRequestAnimationFrame') || function (id) {
    window.clearTimeout(id);
  }; // @function requestAnimFrame(fn: Function, context?: Object, immediate?: Boolean): Number
  // Schedules `fn` to be executed when the browser repaints. `fn` is bound to
  // `context` if given. When `immediate` is set, `fn` is called immediately if
  // the browser doesn't have native support for
  // [`window.requestAnimationFrame`](https://developer.mozilla.org/docs/Web/API/window/requestAnimationFrame),
  // otherwise it's delayed. Returns a request ID that can be used to cancel the request.


  function requestAnimFrame(fn, context, immediate) {
    if (immediate && requestFn === timeoutDefer) {
      fn.call(context);
    } else {
      return requestFn.call(window, bind(fn, context));
    }
  } // @function cancelAnimFrame(id: Number): undefined
  // Cancels a previous `requestAnimFrame`. See also [window.cancelAnimationFrame](https://developer.mozilla.org/docs/Web/API/window/cancelAnimationFrame).


  function cancelAnimFrame(id) {
    if (id) {
      cancelFn.call(window, id);
    }
  }

  var Util = (Object.freeze || Object)({
    freeze: freeze,
    extend: extend,
    create: create,
    bind: bind,
    lastId: lastId,
    stamp: stamp,
    throttle: throttle,
    wrapNum: wrapNum,
    falseFn: falseFn,
    formatNum: formatNum,
    trim: trim,
    splitWords: splitWords,
    setOptions: setOptions,
    getParamString: getParamString,
    template: template,
    isArray: isArray,
    indexOf: indexOf,
    emptyImageUrl: emptyImageUrl,
    requestFn: requestFn,
    cancelFn: cancelFn,
    requestAnimFrame: requestAnimFrame,
    cancelAnimFrame: cancelAnimFrame
  }); // @class Class
  // @aka L.Class
  // @section
  // @uninheritable
  // Thanks to John Resig and Dean Edwards for inspiration!

  function Class() {}

  Class.extend = function (props) {
    // @function extend(props: Object): Function
    // [Extends the current class](#class-inheritance) given the properties to be included.
    // Returns a Javascript function that is a class constructor (to be called with `new`).
    var NewClass = function () {
      // call the constructor
      if (this.initialize) {
        this.initialize.apply(this, arguments);
      } // call all constructor hooks


      this.callInitHooks();
    };

    var parentProto = NewClass.__super__ = this.prototype;
    var proto = create(parentProto);
    proto.constructor = NewClass;
    NewClass.prototype = proto; // inherit parent's statics

    for (var i in this) {
      if (this.hasOwnProperty(i) && i !== 'prototype' && i !== '__super__') {
        NewClass[i] = this[i];
      }
    } // mix static properties into the class


    if (props.statics) {
      extend(NewClass, props.statics);
      delete props.statics;
    } // mix includes into the prototype


    if (props.includes) {
      checkDeprecatedMixinEvents(props.includes);
      extend.apply(null, [proto].concat(props.includes));
      delete props.includes;
    } // merge options


    if (proto.options) {
      props.options = extend(create(proto.options), props.options);
    } // mix given properties into the prototype


    extend(proto, props);
    proto._initHooks = []; // add method for calling all hooks

    proto.callInitHooks = function () {
      if (this._initHooksCalled) {
        return;
      }

      if (parentProto.callInitHooks) {
        parentProto.callInitHooks.call(this);
      }

      this._initHooksCalled = true;

      for (var i = 0, len = proto._initHooks.length; i < len; i++) {
        proto._initHooks[i].call(this);
      }
    };

    return NewClass;
  }; // @function include(properties: Object): this
  // [Includes a mixin](#class-includes) into the current class.


  Class.include = function (props) {
    extend(this.prototype, props);
    return this;
  }; // @function mergeOptions(options: Object): this
  // [Merges `options`](#class-options) into the defaults of the class.


  Class.mergeOptions = function (options) {
    extend(this.prototype.options, options);
    return this;
  }; // @function addInitHook(fn: Function): this
  // Adds a [constructor hook](#class-constructor-hooks) to the class.


  Class.addInitHook = function (fn) {
    // (Function) || (String, args...)
    var args = Array.prototype.slice.call(arguments, 1);
    var init = typeof fn === 'function' ? fn : function () {
      this[fn].apply(this, args);
    };
    this.prototype._initHooks = this.prototype._initHooks || [];

    this.prototype._initHooks.push(init);

    return this;
  };

  function checkDeprecatedMixinEvents(includes) {
    if (typeof L === 'undefined' || !L || !L.Mixin) {
      return;
    }

    includes = isArray(includes) ? includes : [includes];

    for (var i = 0; i < includes.length; i++) {
      if (includes[i] === L.Mixin.Events) {
        console.warn('Deprecated include of L.Mixin.Events: ' + 'this property will be removed in future releases, ' + 'please inherit from L.Evented instead.', new Error().stack);
      }
    }
  }
  /*
   * @class Evented
   * @aka L.Evented
   * @inherits Class
   *
   * A set of methods shared between event-powered classes (like `Map` and `Marker`). Generally, events allow you to execute some function when something happens with an object (e.g. the user clicks on the map, causing the map to fire `'click'` event).
   *
   * @example
   *
   * ```js
   * map.on('click', function(e) {
   * 	alert(e.latlng);
   * } );
   * ```
   *
   * Leaflet deals with event listeners by reference, so if you want to add a listener and then remove it, define it as a function:
   *
   * ```js
   * function onClick(e) { ... }
   *
   * map.on('click', onClick);
   * map.off('click', onClick);
   * ```
   */


  var Events = {
    /* @method on(type: String, fn: Function, context?: Object): this
     * Adds a listener function (`fn`) to a particular event type of the object. You can optionally specify the context of the listener (object the this keyword will point to). You can also pass several space-separated types (e.g. `'click dblclick'`).
     *
     * @alternative
     * @method on(eventMap: Object): this
     * Adds a set of type/listener pairs, e.g. `{click: onClick, mousemove: onMouseMove}`
     */
    on: function (types, fn, context) {
      // types can be a map of types/handlers
      if (typeof types === 'object') {
        for (var type in types) {
          // we don't process space-separated events here for performance;
          // it's a hot path since Layer uses the on(obj) syntax
          this._on(type, types[type], fn);
        }
      } else {
        // types can be a string of space-separated words
        types = splitWords(types);

        for (var i = 0, len = types.length; i < len; i++) {
          this._on(types[i], fn, context);
        }
      }

      return this;
    },

    /* @method off(type: String, fn?: Function, context?: Object): this
     * Removes a previously added listener function. If no function is specified, it will remove all the listeners of that particular event from the object. Note that if you passed a custom context to `on`, you must pass the same context to `off` in order to remove the listener.
     *
     * @alternative
     * @method off(eventMap: Object): this
     * Removes a set of type/listener pairs.
     *
     * @alternative
     * @method off: this
     * Removes all listeners to all events on the object.
     */
    off: function (types, fn, context) {
      if (!types) {
        // clear all listeners if called without arguments
        delete this._events;
      } else if (typeof types === 'object') {
        for (var type in types) {
          this._off(type, types[type], fn);
        }
      } else {
        types = splitWords(types);

        for (var i = 0, len = types.length; i < len; i++) {
          this._off(types[i], fn, context);
        }
      }

      return this;
    },
    // attach listener (without syntactic sugar now)
    _on: function (type, fn, context) {
      this._events = this._events || {};
      /* get/init listeners for type */

      var typeListeners = this._events[type];

      if (!typeListeners) {
        typeListeners = [];
        this._events[type] = typeListeners;
      }

      if (context === this) {
        // Less memory footprint.
        context = undefined;
      }

      var newListener = {
        fn: fn,
        ctx: context
      },
          listeners = typeListeners; // check if fn already there

      for (var i = 0, len = listeners.length; i < len; i++) {
        if (listeners[i].fn === fn && listeners[i].ctx === context) {
          return;
        }
      }

      listeners.push(newListener);
    },
    _off: function (type, fn, context) {
      var listeners, i, len;

      if (!this._events) {
        return;
      }

      listeners = this._events[type];

      if (!listeners) {
        return;
      }

      if (!fn) {
        // Set all removed listeners to noop so they are not called if remove happens in fire
        for (i = 0, len = listeners.length; i < len; i++) {
          listeners[i].fn = falseFn;
        } // clear all listeners for a type if function isn't specified


        delete this._events[type];
        return;
      }

      if (context === this) {
        context = undefined;
      }

      if (listeners) {
        // find fn and remove it
        for (i = 0, len = listeners.length; i < len; i++) {
          var l = listeners[i];

          if (l.ctx !== context) {
            continue;
          }

          if (l.fn === fn) {
            // set the removed listener to noop so that's not called if remove happens in fire
            l.fn = falseFn;

            if (this._firingCount) {
              /* copy array in case events are being fired */
              this._events[type] = listeners = listeners.slice();
            }

            listeners.splice(i, 1);
            return;
          }
        }
      }
    },
    // @method fire(type: String, data?: Object, propagate?: Boolean): this
    // Fires an event of the specified type. You can optionally provide an data
    // object — the first argument of the listener function will contain its
    // properties. The event can optionally be propagated to event parents.
    fire: function (type, data, propagate) {
      if (!this.listens(type, propagate)) {
        return this;
      }

      var event = extend({}, data, {
        type: type,
        target: this,
        sourceTarget: data && data.sourceTarget || this
      });

      if (this._events) {
        var listeners = this._events[type];

        if (listeners) {
          this._firingCount = this._firingCount + 1 || 1;

          for (var i = 0, len = listeners.length; i < len; i++) {
            var l = listeners[i];
            l.fn.call(l.ctx || this, event);
          }

          this._firingCount--;
        }
      }

      if (propagate) {
        // propagate the event to parents (set with addEventParent)
        this._propagateEvent(event);
      }

      return this;
    },
    // @method listens(type: String): Boolean
    // Returns `true` if a particular event type has any listeners attached to it.
    listens: function (type, propagate) {
      var listeners = this._events && this._events[type];

      if (listeners && listeners.length) {
        return true;
      }

      if (propagate) {
        // also check parents for listeners if event propagates
        for (var id in this._eventParents) {
          if (this._eventParents[id].listens(type, propagate)) {
            return true;
          }
        }
      }

      return false;
    },
    // @method once(…): this
    // Behaves as [`on(…)`](#evented-on), except the listener will only get fired once and then removed.
    once: function (types, fn, context) {
      if (typeof types === 'object') {
        for (var type in types) {
          this.once(type, types[type], fn);
        }

        return this;
      }

      var handler = bind(function () {
        this.off(types, fn, context).off(types, handler, context);
      }, this); // add a listener that's executed once and removed after that

      return this.on(types, fn, context).on(types, handler, context);
    },
    // @method addEventParent(obj: Evented): this
    // Adds an event parent - an `Evented` that will receive propagated events
    addEventParent: function (obj) {
      this._eventParents = this._eventParents || {};
      this._eventParents[stamp(obj)] = obj;
      return this;
    },
    // @method removeEventParent(obj: Evented): this
    // Removes an event parent, so it will stop receiving propagated events
    removeEventParent: function (obj) {
      if (this._eventParents) {
        delete this._eventParents[stamp(obj)];
      }

      return this;
    },
    _propagateEvent: function (e) {
      for (var id in this._eventParents) {
        this._eventParents[id].fire(e.type, extend({
          layer: e.target,
          propagatedFrom: e.target
        }, e), true);
      }
    }
  }; // aliases; we should ditch those eventually
  // @method addEventListener(…): this
  // Alias to [`on(…)`](#evented-on)

  Events.addEventListener = Events.on; // @method removeEventListener(…): this
  // Alias to [`off(…)`](#evented-off)
  // @method clearAllEventListeners(…): this
  // Alias to [`off()`](#evented-off)

  Events.removeEventListener = Events.clearAllEventListeners = Events.off; // @method addOneTimeEventListener(…): this
  // Alias to [`once(…)`](#evented-once)

  Events.addOneTimeEventListener = Events.once; // @method fireEvent(…): this
  // Alias to [`fire(…)`](#evented-fire)

  Events.fireEvent = Events.fire; // @method hasEventListeners(…): Boolean
  // Alias to [`listens(…)`](#evented-listens)

  Events.hasEventListeners = Events.listens;
  var Evented = Class.extend(Events);
  /*
   * @class Point
   * @aka L.Point
   *
   * Represents a point with `x` and `y` coordinates in pixels.
   *
   * @example
   *
   * ```js
   * var point = L.point(200, 300);
   * ```
   *
   * All Leaflet methods and options that accept `Point` objects also accept them in a simple Array form (unless noted otherwise), so these lines are equivalent:
   *
   * ```js
   * map.panBy([200, 300]);
   * map.panBy(L.point(200, 300));
   * ```
   *
   * Note that `Point` does not inherit from Leafet's `Class` object,
   * which means new classes can't inherit from it, and new methods
   * can't be added to it with the `include` function.
   */

  function Point(x, y, round) {
    // @property x: Number; The `x` coordinate of the point
    this.x = round ? Math.round(x) : x; // @property y: Number; The `y` coordinate of the point

    this.y = round ? Math.round(y) : y;
  }

  var trunc = Math.trunc || function (v) {
    return v > 0 ? Math.floor(v) : Math.ceil(v);
  };

  Point.prototype = {
    // @method clone(): Point
    // Returns a copy of the current point.
    clone: function () {
      return new Point(this.x, this.y);
    },
    // @method add(otherPoint: Point): Point
    // Returns the result of addition of the current and the given points.
    add: function (point) {
      // non-destructive, returns a new point
      return this.clone()._add(toPoint(point));
    },
    _add: function (point) {
      // destructive, used directly for performance in situations where it's safe to modify existing point
      this.x += point.x;
      this.y += point.y;
      return this;
    },
    // @method subtract(otherPoint: Point): Point
    // Returns the result of subtraction of the given point from the current.
    subtract: function (point) {
      return this.clone()._subtract(toPoint(point));
    },
    _subtract: function (point) {
      this.x -= point.x;
      this.y -= point.y;
      return this;
    },
    // @method divideBy(num: Number): Point
    // Returns the result of division of the current point by the given number.
    divideBy: function (num) {
      return this.clone()._divideBy(num);
    },
    _divideBy: function (num) {
      this.x /= num;
      this.y /= num;
      return this;
    },
    // @method multiplyBy(num: Number): Point
    // Returns the result of multiplication of the current point by the given number.
    multiplyBy: function (num) {
      return this.clone()._multiplyBy(num);
    },
    _multiplyBy: function (num) {
      this.x *= num;
      this.y *= num;
      return this;
    },
    // @method scaleBy(scale: Point): Point
    // Multiply each coordinate of the current point by each coordinate of
    // `scale`. In linear algebra terms, multiply the point by the
    // [scaling matrix](https://en.wikipedia.org/wiki/Scaling_%28geometry%29#Matrix_representation)
    // defined by `scale`.
    scaleBy: function (point) {
      return new Point(this.x * point.x, this.y * point.y);
    },
    // @method unscaleBy(scale: Point): Point
    // Inverse of `scaleBy`. Divide each coordinate of the current point by
    // each coordinate of `scale`.
    unscaleBy: function (point) {
      return new Point(this.x / point.x, this.y / point.y);
    },
    // @method round(): Point
    // Returns a copy of the current point with rounded coordinates.
    round: function () {
      return this.clone()._round();
    },
    _round: function () {
      this.x = Math.round(this.x);
      this.y = Math.round(this.y);
      return this;
    },
    // @method floor(): Point
    // Returns a copy of the current point with floored coordinates (rounded down).
    floor: function () {
      return this.clone()._floor();
    },
    _floor: function () {
      this.x = Math.floor(this.x);
      this.y = Math.floor(this.y);
      return this;
    },
    // @method ceil(): Point
    // Returns a copy of the current point with ceiled coordinates (rounded up).
    ceil: function () {
      return this.clone()._ceil();
    },
    _ceil: function () {
      this.x = Math.ceil(this.x);
      this.y = Math.ceil(this.y);
      return this;
    },
    // @method trunc(): Point
    // Returns a copy of the current point with truncated coordinates (rounded towards zero).
    trunc: function () {
      return this.clone()._trunc();
    },
    _trunc: function () {
      this.x = trunc(this.x);
      this.y = trunc(this.y);
      return this;
    },
    // @method distanceTo(otherPoint: Point): Number
    // Returns the cartesian distance between the current and the given points.
    distanceTo: function (point) {
      point = toPoint(point);
      var x = point.x - this.x,
          y = point.y - this.y;
      return Math.sqrt(x * x + y * y);
    },
    // @method equals(otherPoint: Point): Boolean
    // Returns `true` if the given point has the same coordinates.
    equals: function (point) {
      point = toPoint(point);
      return point.x === this.x && point.y === this.y;
    },
    // @method contains(otherPoint: Point): Boolean
    // Returns `true` if both coordinates of the given point are less than the corresponding current point coordinates (in absolute values).
    contains: function (point) {
      point = toPoint(point);
      return Math.abs(point.x) <= Math.abs(this.x) && Math.abs(point.y) <= Math.abs(this.y);
    },
    // @method toString(): String
    // Returns a string representation of the point for debugging purposes.
    toString: function () {
      return 'Point(' + formatNum(this.x) + ', ' + formatNum(this.y) + ')';
    }
  }; // @factory L.point(x: Number, y: Number, round?: Boolean)
  // Creates a Point object with the given `x` and `y` coordinates. If optional `round` is set to true, rounds the `x` and `y` values.
  // @alternative
  // @factory L.point(coords: Number[])
  // Expects an array of the form `[x, y]` instead.
  // @alternative
  // @factory L.point(coords: Object)
  // Expects a plain object of the form `{x: Number, y: Number}` instead.

  function toPoint(x, y, round) {
    if (x instanceof Point) {
      return x;
    }

    if (isArray(x)) {
      return new Point(x[0], x[1]);
    }

    if (x === undefined || x === null) {
      return x;
    }

    if (typeof x === 'object' && 'x' in x && 'y' in x) {
      return new Point(x.x, x.y);
    }

    return new Point(x, y, round);
  }
  /*
   * @class Bounds
   * @aka L.Bounds
   *
   * Represents a rectangular area in pixel coordinates.
   *
   * @example
   *
   * ```js
   * var p1 = L.point(10, 10),
   * p2 = L.point(40, 60),
   * bounds = L.bounds(p1, p2);
   * ```
   *
   * All Leaflet methods that accept `Bounds` objects also accept them in a simple Array form (unless noted otherwise), so the bounds example above can be passed like this:
   *
   * ```js
   * otherBounds.intersects([[10, 10], [40, 60]]);
   * ```
   *
   * Note that `Bounds` does not inherit from Leafet's `Class` object,
   * which means new classes can't inherit from it, and new methods
   * can't be added to it with the `include` function.
   */


  function Bounds(a, b) {
    if (!a) {
      return;
    }

    var points = b ? [a, b] : a;

    for (var i = 0, len = points.length; i < len; i++) {
      this.extend(points[i]);
    }
  }

  Bounds.prototype = {
    // @method extend(point: Point): this
    // Extends the bounds to contain the given point.
    extend: function (point) {
      // (Point)
      point = toPoint(point); // @property min: Point
      // The top left corner of the rectangle.
      // @property max: Point
      // The bottom right corner of the rectangle.

      if (!this.min && !this.max) {
        this.min = point.clone();
        this.max = point.clone();
      } else {
        this.min.x = Math.min(point.x, this.min.x);
        this.max.x = Math.max(point.x, this.max.x);
        this.min.y = Math.min(point.y, this.min.y);
        this.max.y = Math.max(point.y, this.max.y);
      }

      return this;
    },
    // @method getCenter(round?: Boolean): Point
    // Returns the center point of the bounds.
    getCenter: function (round) {
      return new Point((this.min.x + this.max.x) / 2, (this.min.y + this.max.y) / 2, round);
    },
    // @method getBottomLeft(): Point
    // Returns the bottom-left point of the bounds.
    getBottomLeft: function () {
      return new Point(this.min.x, this.max.y);
    },
    // @method getTopRight(): Point
    // Returns the top-right point of the bounds.
    getTopRight: function () {
      // -> Point
      return new Point(this.max.x, this.min.y);
    },
    // @method getTopLeft(): Point
    // Returns the top-left point of the bounds (i.e. [`this.min`](#bounds-min)).
    getTopLeft: function () {
      return this.min; // left, top
    },
    // @method getBottomRight(): Point
    // Returns the bottom-right point of the bounds (i.e. [`this.max`](#bounds-max)).
    getBottomRight: function () {
      return this.max; // right, bottom
    },
    // @method getSize(): Point
    // Returns the size of the given bounds
    getSize: function () {
      return this.max.subtract(this.min);
    },
    // @method contains(otherBounds: Bounds): Boolean
    // Returns `true` if the rectangle contains the given one.
    // @alternative
    // @method contains(point: Point): Boolean
    // Returns `true` if the rectangle contains the given point.
    contains: function (obj) {
      var min, max;

      if (typeof obj[0] === 'number' || obj instanceof Point) {
        obj = toPoint(obj);
      } else {
        obj = toBounds(obj);
      }

      if (obj instanceof Bounds) {
        min = obj.min;
        max = obj.max;
      } else {
        min = max = obj;
      }

      return min.x >= this.min.x && max.x <= this.max.x && min.y >= this.min.y && max.y <= this.max.y;
    },
    // @method intersects(otherBounds: Bounds): Boolean
    // Returns `true` if the rectangle intersects the given bounds. Two bounds
    // intersect if they have at least one point in common.
    intersects: function (bounds) {
      // (Bounds) -> Boolean
      bounds = toBounds(bounds);
      var min = this.min,
          max = this.max,
          min2 = bounds.min,
          max2 = bounds.max,
          xIntersects = max2.x >= min.x && min2.x <= max.x,
          yIntersects = max2.y >= min.y && min2.y <= max.y;
      return xIntersects && yIntersects;
    },
    // @method overlaps(otherBounds: Bounds): Boolean
    // Returns `true` if the rectangle overlaps the given bounds. Two bounds
    // overlap if their intersection is an area.
    overlaps: function (bounds) {
      // (Bounds) -> Boolean
      bounds = toBounds(bounds);
      var min = this.min,
          max = this.max,
          min2 = bounds.min,
          max2 = bounds.max,
          xOverlaps = max2.x > min.x && min2.x < max.x,
          yOverlaps = max2.y > min.y && min2.y < max.y;
      return xOverlaps && yOverlaps;
    },
    isValid: function () {
      return !!(this.min && this.max);
    }
  }; // @factory L.bounds(corner1: Point, corner2: Point)
  // Creates a Bounds object from two corners coordinate pairs.
  // @alternative
  // @factory L.bounds(points: Point[])
  // Creates a Bounds object from the given array of points.

  function toBounds(a, b) {
    if (!a || a instanceof Bounds) {
      return a;
    }

    return new Bounds(a, b);
  }
  /*
   * @class LatLngBounds
   * @aka L.LatLngBounds
   *
   * Represents a rectangular geographical area on a map.
   *
   * @example
   *
   * ```js
   * var corner1 = L.latLng(40.712, -74.227),
   * corner2 = L.latLng(40.774, -74.125),
   * bounds = L.latLngBounds(corner1, corner2);
   * ```
   *
   * All Leaflet methods that accept LatLngBounds objects also accept them in a simple Array form (unless noted otherwise), so the bounds example above can be passed like this:
   *
   * ```js
   * map.fitBounds([
   * 	[40.712, -74.227],
   * 	[40.774, -74.125]
   * ]);
   * ```
   *
   * Caution: if the area crosses the antimeridian (often confused with the International Date Line), you must specify corners _outside_ the [-180, 180] degrees longitude range.
   *
   * Note that `LatLngBounds` does not inherit from Leafet's `Class` object,
   * which means new classes can't inherit from it, and new methods
   * can't be added to it with the `include` function.
   */


  function LatLngBounds(corner1, corner2) {
    // (LatLng, LatLng) or (LatLng[])
    if (!corner1) {
      return;
    }

    var latlngs = corner2 ? [corner1, corner2] : corner1;

    for (var i = 0, len = latlngs.length; i < len; i++) {
      this.extend(latlngs[i]);
    }
  }

  LatLngBounds.prototype = {
    // @method extend(latlng: LatLng): this
    // Extend the bounds to contain the given point
    // @alternative
    // @method extend(otherBounds: LatLngBounds): this
    // Extend the bounds to contain the given bounds
    extend: function (obj) {
      var sw = this._southWest,
          ne = this._northEast,
          sw2,
          ne2;

      if (obj instanceof LatLng) {
        sw2 = obj;
        ne2 = obj;
      } else if (obj instanceof LatLngBounds) {
        sw2 = obj._southWest;
        ne2 = obj._northEast;

        if (!sw2 || !ne2) {
          return this;
        }
      } else {
        return obj ? this.extend(toLatLng(obj) || toLatLngBounds(obj)) : this;
      }

      if (!sw && !ne) {
        this._southWest = new LatLng(sw2.lat, sw2.lng);
        this._northEast = new LatLng(ne2.lat, ne2.lng);
      } else {
        sw.lat = Math.min(sw2.lat, sw.lat);
        sw.lng = Math.min(sw2.lng, sw.lng);
        ne.lat = Math.max(ne2.lat, ne.lat);
        ne.lng = Math.max(ne2.lng, ne.lng);
      }

      return this;
    },
    // @method pad(bufferRatio: Number): LatLngBounds
    // Returns bounds created by extending or retracting the current bounds by a given ratio in each direction.
    // For example, a ratio of 0.5 extends the bounds by 50% in each direction.
    // Negative values will retract the bounds.
    pad: function (bufferRatio) {
      var sw = this._southWest,
          ne = this._northEast,
          heightBuffer = Math.abs(sw.lat - ne.lat) * bufferRatio,
          widthBuffer = Math.abs(sw.lng - ne.lng) * bufferRatio;
      return new LatLngBounds(new LatLng(sw.lat - heightBuffer, sw.lng - widthBuffer), new LatLng(ne.lat + heightBuffer, ne.lng + widthBuffer));
    },
    // @method getCenter(): LatLng
    // Returns the center point of the bounds.
    getCenter: function () {
      return new LatLng((this._southWest.lat + this._northEast.lat) / 2, (this._southWest.lng + this._northEast.lng) / 2);
    },
    // @method getSouthWest(): LatLng
    // Returns the south-west point of the bounds.
    getSouthWest: function () {
      return this._southWest;
    },
    // @method getNorthEast(): LatLng
    // Returns the north-east point of the bounds.
    getNorthEast: function () {
      return this._northEast;
    },
    // @method getNorthWest(): LatLng
    // Returns the north-west point of the bounds.
    getNorthWest: function () {
      return new LatLng(this.getNorth(), this.getWest());
    },
    // @method getSouthEast(): LatLng
    // Returns the south-east point of the bounds.
    getSouthEast: function () {
      return new LatLng(this.getSouth(), this.getEast());
    },
    // @method getWest(): Number
    // Returns the west longitude of the bounds
    getWest: function () {
      return this._southWest.lng;
    },
    // @method getSouth(): Number
    // Returns the south latitude of the bounds
    getSouth: function () {
      return this._southWest.lat;
    },
    // @method getEast(): Number
    // Returns the east longitude of the bounds
    getEast: function () {
      return this._northEast.lng;
    },
    // @method getNorth(): Number
    // Returns the north latitude of the bounds
    getNorth: function () {
      return this._northEast.lat;
    },
    // @method contains(otherBounds: LatLngBounds): Boolean
    // Returns `true` if the rectangle contains the given one.
    // @alternative
    // @method contains (latlng: LatLng): Boolean
    // Returns `true` if the rectangle contains the given point.
    contains: function (obj) {
      // (LatLngBounds) or (LatLng) -> Boolean
      if (typeof obj[0] === 'number' || obj instanceof LatLng || 'lat' in obj) {
        obj = toLatLng(obj);
      } else {
        obj = toLatLngBounds(obj);
      }

      var sw = this._southWest,
          ne = this._northEast,
          sw2,
          ne2;

      if (obj instanceof LatLngBounds) {
        sw2 = obj.getSouthWest();
        ne2 = obj.getNorthEast();
      } else {
        sw2 = ne2 = obj;
      }

      return sw2.lat >= sw.lat && ne2.lat <= ne.lat && sw2.lng >= sw.lng && ne2.lng <= ne.lng;
    },
    // @method intersects(otherBounds: LatLngBounds): Boolean
    // Returns `true` if the rectangle intersects the given bounds. Two bounds intersect if they have at least one point in common.
    intersects: function (bounds) {
      bounds = toLatLngBounds(bounds);
      var sw = this._southWest,
          ne = this._northEast,
          sw2 = bounds.getSouthWest(),
          ne2 = bounds.getNorthEast(),
          latIntersects = ne2.lat >= sw.lat && sw2.lat <= ne.lat,
          lngIntersects = ne2.lng >= sw.lng && sw2.lng <= ne.lng;
      return latIntersects && lngIntersects;
    },
    // @method overlaps(otherBounds: Bounds): Boolean
    // Returns `true` if the rectangle overlaps the given bounds. Two bounds overlap if their intersection is an area.
    overlaps: function (bounds) {
      bounds = toLatLngBounds(bounds);
      var sw = this._southWest,
          ne = this._northEast,
          sw2 = bounds.getSouthWest(),
          ne2 = bounds.getNorthEast(),
          latOverlaps = ne2.lat > sw.lat && sw2.lat < ne.lat,
          lngOverlaps = ne2.lng > sw.lng && sw2.lng < ne.lng;
      return latOverlaps && lngOverlaps;
    },
    // @method toBBoxString(): String
    // Returns a string with bounding box coordinates in a 'southwest_lng,southwest_lat,northeast_lng,northeast_lat' format. Useful for sending requests to web services that return geo data.
    toBBoxString: function () {
      return [this.getWest(), this.getSouth(), this.getEast(), this.getNorth()].join(',');
    },
    // @method equals(otherBounds: LatLngBounds, maxMargin?: Number): Boolean
    // Returns `true` if the rectangle is equivalent (within a small margin of error) to the given bounds. The margin of error can be overridden by setting `maxMargin` to a small number.
    equals: function (bounds, maxMargin) {
      if (!bounds) {
        return false;
      }

      bounds = toLatLngBounds(bounds);
      return this._southWest.equals(bounds.getSouthWest(), maxMargin) && this._northEast.equals(bounds.getNorthEast(), maxMargin);
    },
    // @method isValid(): Boolean
    // Returns `true` if the bounds are properly initialized.
    isValid: function () {
      return !!(this._southWest && this._northEast);
    }
  }; // TODO International date line?
  // @factory L.latLngBounds(corner1: LatLng, corner2: LatLng)
  // Creates a `LatLngBounds` object by defining two diagonally opposite corners of the rectangle.
  // @alternative
  // @factory L.latLngBounds(latlngs: LatLng[])
  // Creates a `LatLngBounds` object defined by the geographical points it contains. Very useful for zooming the map to fit a particular set of locations with [`fitBounds`](#map-fitbounds).

  function toLatLngBounds(a, b) {
    if (a instanceof LatLngBounds) {
      return a;
    }

    return new LatLngBounds(a, b);
  }
  /* @class LatLng
   * @aka L.LatLng
   *
   * Represents a geographical point with a certain latitude and longitude.
   *
   * @example
   *
   * ```
   * var latlng = L.latLng(50.5, 30.5);
   * ```
   *
   * All Leaflet methods that accept LatLng objects also accept them in a simple Array form and simple object form (unless noted otherwise), so these lines are equivalent:
   *
   * ```
   * map.panTo([50, 30]);
   * map.panTo({lon: 30, lat: 50});
   * map.panTo({lat: 50, lng: 30});
   * map.panTo(L.latLng(50, 30));
   * ```
   *
   * Note that `LatLng` does not inherit from Leaflet's `Class` object,
   * which means new classes can't inherit from it, and new methods
   * can't be added to it with the `include` function.
   */


  function LatLng(lat, lng, alt) {
    if (isNaN(lat) || isNaN(lng)) {
      throw new Error('Invalid LatLng object: (' + lat + ', ' + lng + ')');
    } // @property lat: Number
    // Latitude in degrees


    this.lat = +lat; // @property lng: Number
    // Longitude in degrees

    this.lng = +lng; // @property alt: Number
    // Altitude in meters (optional)

    if (alt !== undefined) {
      this.alt = +alt;
    }
  }

  LatLng.prototype = {
    // @method equals(otherLatLng: LatLng, maxMargin?: Number): Boolean
    // Returns `true` if the given `LatLng` point is at the same position (within a small margin of error). The margin of error can be overridden by setting `maxMargin` to a small number.
    equals: function (obj, maxMargin) {
      if (!obj) {
        return false;
      }

      obj = toLatLng(obj);
      var margin = Math.max(Math.abs(this.lat - obj.lat), Math.abs(this.lng - obj.lng));
      return margin <= (maxMargin === undefined ? 1.0E-9 : maxMargin);
    },
    // @method toString(): String
    // Returns a string representation of the point (for debugging purposes).
    toString: function (precision) {
      return 'LatLng(' + formatNum(this.lat, precision) + ', ' + formatNum(this.lng, precision) + ')';
    },
    // @method distanceTo(otherLatLng: LatLng): Number
    // Returns the distance (in meters) to the given `LatLng` calculated using the [Spherical Law of Cosines](https://en.wikipedia.org/wiki/Spherical_law_of_cosines).
    distanceTo: function (other) {
      return Earth.distance(this, toLatLng(other));
    },
    // @method wrap(): LatLng
    // Returns a new `LatLng` object with the longitude wrapped so it's always between -180 and +180 degrees.
    wrap: function () {
      return Earth.wrapLatLng(this);
    },
    // @method toBounds(sizeInMeters: Number): LatLngBounds
    // Returns a new `LatLngBounds` object in which each boundary is `sizeInMeters/2` meters apart from the `LatLng`.
    toBounds: function (sizeInMeters) {
      var latAccuracy = 180 * sizeInMeters / 40075017,
          lngAccuracy = latAccuracy / Math.cos(Math.PI / 180 * this.lat);
      return toLatLngBounds([this.lat - latAccuracy, this.lng - lngAccuracy], [this.lat + latAccuracy, this.lng + lngAccuracy]);
    },
    clone: function () {
      return new LatLng(this.lat, this.lng, this.alt);
    }
  }; // @factory L.latLng(latitude: Number, longitude: Number, altitude?: Number): LatLng
  // Creates an object representing a geographical point with the given latitude and longitude (and optionally altitude).
  // @alternative
  // @factory L.latLng(coords: Array): LatLng
  // Expects an array of the form `[Number, Number]` or `[Number, Number, Number]` instead.
  // @alternative
  // @factory L.latLng(coords: Object): LatLng
  // Expects an plain object of the form `{lat: Number, lng: Number}` or `{lat: Number, lng: Number, alt: Number}` instead.

  function toLatLng(a, b, c) {
    if (a instanceof LatLng) {
      return a;
    }

    if (isArray(a) && typeof a[0] !== 'object') {
      if (a.length === 3) {
        return new LatLng(a[0], a[1], a[2]);
      }

      if (a.length === 2) {
        return new LatLng(a[0], a[1]);
      }

      return null;
    }

    if (a === undefined || a === null) {
      return a;
    }

    if (typeof a === 'object' && 'lat' in a) {
      return new LatLng(a.lat, 'lng' in a ? a.lng : a.lon, a.alt);
    }

    if (b === undefined) {
      return null;
    }

    return new LatLng(a, b, c);
  }
  /*
   * @namespace CRS
   * @crs L.CRS.Base
   * Object that defines coordinate reference systems for projecting
   * geographical points into pixel (screen) coordinates and back (and to
   * coordinates in other units for [WMS](https://en.wikipedia.org/wiki/Web_Map_Service) services). See
   * [spatial reference system](http://en.wikipedia.org/wiki/Coordinate_reference_system).
   *
   * Leaflet defines the most usual CRSs by default. If you want to use a
   * CRS not defined by default, take a look at the
   * [Proj4Leaflet](https://github.com/kartena/Proj4Leaflet) plugin.
   *
   * Note that the CRS instances do not inherit from Leafet's `Class` object,
   * and can't be instantiated. Also, new classes can't inherit from them,
   * and methods can't be added to them with the `include` function.
   */


  var CRS = {
    // @method latLngToPoint(latlng: LatLng, zoom: Number): Point
    // Projects geographical coordinates into pixel coordinates for a given zoom.
    latLngToPoint: function (latlng, zoom) {
      var projectedPoint = this.projection.project(latlng),
          scale = this.scale(zoom);
      return this.transformation._transform(projectedPoint, scale);
    },
    // @method pointToLatLng(point: Point, zoom: Number): LatLng
    // The inverse of `latLngToPoint`. Projects pixel coordinates on a given
    // zoom into geographical coordinates.
    pointToLatLng: function (point, zoom) {
      var scale = this.scale(zoom),
          untransformedPoint = this.transformation.untransform(point, scale);
      return this.projection.unproject(untransformedPoint);
    },
    // @method project(latlng: LatLng): Point
    // Projects geographical coordinates into coordinates in units accepted for
    // this CRS (e.g. meters for EPSG:3857, for passing it to WMS services).
    project: function (latlng) {
      return this.projection.project(latlng);
    },
    // @method unproject(point: Point): LatLng
    // Given a projected coordinate returns the corresponding LatLng.
    // The inverse of `project`.
    unproject: function (point) {
      return this.projection.unproject(point);
    },
    // @method scale(zoom: Number): Number
    // Returns the scale used when transforming projected coordinates into
    // pixel coordinates for a particular zoom. For example, it returns
    // `256 * 2^zoom` for Mercator-based CRS.
    scale: function (zoom) {
      return 256 * Math.pow(2, zoom);
    },
    // @method zoom(scale: Number): Number
    // Inverse of `scale()`, returns the zoom level corresponding to a scale
    // factor of `scale`.
    zoom: function (scale) {
      return Math.log(scale / 256) / Math.LN2;
    },
    // @method getProjectedBounds(zoom: Number): Bounds
    // Returns the projection's bounds scaled and transformed for the provided `zoom`.
    getProjectedBounds: function (zoom) {
      if (this.infinite) {
        return null;
      }

      var b = this.projection.bounds,
          s = this.scale(zoom),
          min = this.transformation.transform(b.min, s),
          max = this.transformation.transform(b.max, s);
      return new Bounds(min, max);
    },
    // @method distance(latlng1: LatLng, latlng2: LatLng): Number
    // Returns the distance between two geographical coordinates.
    // @property code: String
    // Standard code name of the CRS passed into WMS services (e.g. `'EPSG:3857'`)
    //
    // @property wrapLng: Number[]
    // An array of two numbers defining whether the longitude (horizontal) coordinate
    // axis wraps around a given range and how. Defaults to `[-180, 180]` in most
    // geographical CRSs. If `undefined`, the longitude axis does not wrap around.
    //
    // @property wrapLat: Number[]
    // Like `wrapLng`, but for the latitude (vertical) axis.
    // wrapLng: [min, max],
    // wrapLat: [min, max],
    // @property infinite: Boolean
    // If true, the coordinate space will be unbounded (infinite in both axes)
    infinite: false,
    // @method wrapLatLng(latlng: LatLng): LatLng
    // Returns a `LatLng` where lat and lng has been wrapped according to the
    // CRS's `wrapLat` and `wrapLng` properties, if they are outside the CRS's bounds.
    wrapLatLng: function (latlng) {
      var lng = this.wrapLng ? wrapNum(latlng.lng, this.wrapLng, true) : latlng.lng,
          lat = this.wrapLat ? wrapNum(latlng.lat, this.wrapLat, true) : latlng.lat,
          alt = latlng.alt;
      return new LatLng(lat, lng, alt);
    },
    // @method wrapLatLngBounds(bounds: LatLngBounds): LatLngBounds
    // Returns a `LatLngBounds` with the same size as the given one, ensuring
    // that its center is within the CRS's bounds.
    // Only accepts actual `L.LatLngBounds` instances, not arrays.
    wrapLatLngBounds: function (bounds) {
      var center = bounds.getCenter(),
          newCenter = this.wrapLatLng(center),
          latShift = center.lat - newCenter.lat,
          lngShift = center.lng - newCenter.lng;

      if (latShift === 0 && lngShift === 0) {
        return bounds;
      }

      var sw = bounds.getSouthWest(),
          ne = bounds.getNorthEast(),
          newSw = new LatLng(sw.lat - latShift, sw.lng - lngShift),
          newNe = new LatLng(ne.lat - latShift, ne.lng - lngShift);
      return new LatLngBounds(newSw, newNe);
    }
  };
  /*
   * @namespace CRS
   * @crs L.CRS.Earth
   *
   * Serves as the base for CRS that are global such that they cover the earth.
   * Can only be used as the base for other CRS and cannot be used directly,
   * since it does not have a `code`, `projection` or `transformation`. `distance()` returns
   * meters.
   */

  var Earth = extend({}, CRS, {
    wrapLng: [-180, 180],
    // Mean Earth Radius, as recommended for use by
    // the International Union of Geodesy and Geophysics,
    // see http://rosettacode.org/wiki/Haversine_formula
    R: 6371000,
    // distance between two geographical points using spherical law of cosines approximation
    distance: function (latlng1, latlng2) {
      var rad = Math.PI / 180,
          lat1 = latlng1.lat * rad,
          lat2 = latlng2.lat * rad,
          sinDLat = Math.sin((latlng2.lat - latlng1.lat) * rad / 2),
          sinDLon = Math.sin((latlng2.lng - latlng1.lng) * rad / 2),
          a = sinDLat * sinDLat + Math.cos(lat1) * Math.cos(lat2) * sinDLon * sinDLon,
          c = 2 * Math.atan2(Math.sqrt(a), Math.sqrt(1 - a));
      return this.R * c;
    }
  });
  /*
   * @namespace Projection
   * @projection L.Projection.SphericalMercator
   *
   * Spherical Mercator projection — the most common projection for online maps,
   * used by almost all free and commercial tile providers. Assumes that Earth is
   * a sphere. Used by the `EPSG:3857` CRS.
   */

  var SphericalMercator = {
    R: 6378137,
    MAX_LATITUDE: 85.0511287798,
    project: function (latlng) {
      var d = Math.PI / 180,
          max = this.MAX_LATITUDE,
          lat = Math.max(Math.min(max, latlng.lat), -max),
          sin = Math.sin(lat * d);
      return new Point(this.R * latlng.lng * d, this.R * Math.log((1 + sin) / (1 - sin)) / 2);
    },
    unproject: function (point) {
      var d = 180 / Math.PI;
      return new LatLng((2 * Math.atan(Math.exp(point.y / this.R)) - Math.PI / 2) * d, point.x * d / this.R);
    },
    bounds: function () {
      var d = 6378137 * Math.PI;
      return new Bounds([-d, -d], [d, d]);
    }()
  };
  /*
   * @class Transformation
   * @aka L.Transformation
   *
   * Represents an affine transformation: a set of coefficients `a`, `b`, `c`, `d`
   * for transforming a point of a form `(x, y)` into `(a*x + b, c*y + d)` and doing
   * the reverse. Used by Leaflet in its projections code.
   *
   * @example
   *
   * ```js
   * var transformation = L.transformation(2, 5, -1, 10),
   * 	p = L.point(1, 2),
   * 	p2 = transformation.transform(p), //  L.point(7, 8)
   * 	p3 = transformation.untransform(p2); //  L.point(1, 2)
   * ```
   */
  // factory new L.Transformation(a: Number, b: Number, c: Number, d: Number)
  // Creates a `Transformation` object with the given coefficients.

  function Transformation(a, b, c, d) {
    if (isArray(a)) {
      // use array properties
      this._a = a[0];
      this._b = a[1];
      this._c = a[2];
      this._d = a[3];
      return;
    }

    this._a = a;
    this._b = b;
    this._c = c;
    this._d = d;
  }

  Transformation.prototype = {
    // @method transform(point: Point, scale?: Number): Point
    // Returns a transformed point, optionally multiplied by the given scale.
    // Only accepts actual `L.Point` instances, not arrays.
    transform: function (point, scale) {
      // (Point, Number) -> Point
      return this._transform(point.clone(), scale);
    },
    // destructive transform (faster)
    _transform: function (point, scale) {
      scale = scale || 1;
      point.x = scale * (this._a * point.x + this._b);
      point.y = scale * (this._c * point.y + this._d);
      return point;
    },
    // @method untransform(point: Point, scale?: Number): Point
    // Returns the reverse transformation of the given point, optionally divided
    // by the given scale. Only accepts actual `L.Point` instances, not arrays.
    untransform: function (point, scale) {
      scale = scale || 1;
      return new Point((point.x / scale - this._b) / this._a, (point.y / scale - this._d) / this._c);
    }
  }; // factory L.transformation(a: Number, b: Number, c: Number, d: Number)
  // @factory L.transformation(a: Number, b: Number, c: Number, d: Number)
  // Instantiates a Transformation object with the given coefficients.
  // @alternative
  // @factory L.transformation(coefficients: Array): Transformation
  // Expects an coefficients array of the form
  // `[a: Number, b: Number, c: Number, d: Number]`.

  function toTransformation(a, b, c, d) {
    return new Transformation(a, b, c, d);
  }
  /*
   * @namespace CRS
   * @crs L.CRS.EPSG3857
   *
   * The most common CRS for online maps, used by almost all free and commercial
   * tile providers. Uses Spherical Mercator projection. Set in by default in
   * Map's `crs` option.
   */


  var EPSG3857 = extend({}, Earth, {
    code: 'EPSG:3857',
    projection: SphericalMercator,
    transformation: function () {
      var scale = 0.5 / (Math.PI * SphericalMercator.R);
      return toTransformation(scale, 0.5, -scale, 0.5);
    }()
  });
  var EPSG900913 = extend({}, EPSG3857, {
    code: 'EPSG:900913'
  }); // @namespace SVG; @section
  // There are several static functions which can be called without instantiating L.SVG:
  // @function create(name: String): SVGElement
  // Returns a instance of [SVGElement](https://developer.mozilla.org/docs/Web/API/SVGElement),
  // corresponding to the class name passed. For example, using 'line' will return
  // an instance of [SVGLineElement](https://developer.mozilla.org/docs/Web/API/SVGLineElement).

  function svgCreate(name) {
    return document.createElementNS('http://www.w3.org/2000/svg', name);
  } // @function pointsToPath(rings: Point[], closed: Boolean): String
  // Generates a SVG path string for multiple rings, with each ring turning
  // into "M..L..L.." instructions


  function pointsToPath(rings, closed) {
    var str = '',
        i,
        j,
        len,
        len2,
        points,
        p;

    for (i = 0, len = rings.length; i < len; i++) {
      points = rings[i];

      for (j = 0, len2 = points.length; j < len2; j++) {
        p = points[j];
        str += (j ? 'L' : 'M') + p.x + ' ' + p.y;
      } // closes the ring for polygons; "x" is VML syntax


      str += closed ? svg ? 'z' : 'x' : '';
    } // SVG complains about empty path strings


    return str || 'M0 0';
  }
  /*
   * @namespace Browser
   * @aka L.Browser
   *
   * A namespace with static properties for browser/feature detection used by Leaflet internally.
   *
   * @example
   *
   * ```js
   * if (L.Browser.ielt9) {
   *   alert('Upgrade your browser, dude!');
   * }
   * ```
   */


  var style$1 = document.documentElement.style; // @property ie: Boolean; `true` for all Internet Explorer versions (not Edge).

  var ie = ('ActiveXObject' in window); // @property ielt9: Boolean; `true` for Internet Explorer versions less than 9.

  var ielt9 = ie && !document.addEventListener; // @property edge: Boolean; `true` for the Edge web browser.

  var edge = 'msLaunchUri' in navigator && !('documentMode' in document); // @property webkit: Boolean;
  // `true` for webkit-based browsers like Chrome and Safari (including mobile versions).

  var webkit = userAgentContains('webkit'); // @property android: Boolean
  // `true` for any browser running on an Android platform.

  var android = userAgentContains('android'); // @property android23: Boolean; `true` for browsers running on Android 2 or Android 3.

  var android23 = userAgentContains('android 2') || userAgentContains('android 3');
  /* See https://stackoverflow.com/a/17961266 for details on detecting stock Android */

  var webkitVer = parseInt(/WebKit\/([0-9]+)|$/.exec(navigator.userAgent)[1], 10); // also matches AppleWebKit
  // @property androidStock: Boolean; `true` for the Android stock browser (i.e. not Chrome)

  var androidStock = android && userAgentContains('Google') && webkitVer < 537 && !('AudioNode' in window); // @property opera: Boolean; `true` for the Opera browser

  var opera = !!window.opera; // @property chrome: Boolean; `true` for the Chrome browser.

  var chrome = userAgentContains('chrome'); // @property gecko: Boolean; `true` for gecko-based browsers like Firefox.

  var gecko = userAgentContains('gecko') && !webkit && !opera && !ie; // @property safari: Boolean; `true` for the Safari browser.

  var safari = !chrome && userAgentContains('safari');
  var phantom = userAgentContains('phantom'); // @property opera12: Boolean
  // `true` for the Opera browser supporting CSS transforms (version 12 or later).

  var opera12 = ('OTransition' in style$1); // @property win: Boolean; `true` when the browser is running in a Windows platform

  var win = navigator.platform.indexOf('Win') === 0; // @property ie3d: Boolean; `true` for all Internet Explorer versions supporting CSS transforms.

  var ie3d = ie && 'transition' in style$1; // @property webkit3d: Boolean; `true` for webkit-based browsers supporting CSS transforms.

  var webkit3d = 'WebKitCSSMatrix' in window && 'm11' in new window.WebKitCSSMatrix() && !android23; // @property gecko3d: Boolean; `true` for gecko-based browsers supporting CSS transforms.

  var gecko3d = ('MozPerspective' in style$1); // @property any3d: Boolean
  // `true` for all browsers supporting CSS transforms.

  var any3d = !window.L_DISABLE_3D && (ie3d || webkit3d || gecko3d) && !opera12 && !phantom; // @property mobile: Boolean; `true` for all browsers running in a mobile device.

  var mobile = typeof orientation !== 'undefined' || userAgentContains('mobile'); // @property mobileWebkit: Boolean; `true` for all webkit-based browsers in a mobile device.

  var mobileWebkit = mobile && webkit; // @property mobileWebkit3d: Boolean
  // `true` for all webkit-based browsers in a mobile device supporting CSS transforms.

  var mobileWebkit3d = mobile && webkit3d; // @property msPointer: Boolean
  // `true` for browsers implementing the Microsoft touch events model (notably IE10).

  var msPointer = !window.PointerEvent && window.MSPointerEvent; // @property pointer: Boolean
  // `true` for all browsers supporting [pointer events](https://msdn.microsoft.com/en-us/library/dn433244%28v=vs.85%29.aspx).

  var pointer = !!(window.PointerEvent || msPointer); // @property touch: Boolean
  // `true` for all browsers supporting [touch events](https://developer.mozilla.org/docs/Web/API/Touch_events).
  // This does not necessarily mean that the browser is running in a computer with
  // a touchscreen, it only means that the browser is capable of understanding
  // touch events.

  var touch = !window.L_NO_TOUCH && (pointer || 'ontouchstart' in window || window.DocumentTouch && document instanceof window.DocumentTouch); // @property mobileOpera: Boolean; `true` for the Opera browser in a mobile device.

  var mobileOpera = mobile && opera; // @property mobileGecko: Boolean
  // `true` for gecko-based browsers running in a mobile device.

  var mobileGecko = mobile && gecko; // @property retina: Boolean
  // `true` for browsers on a high-resolution "retina" screen or on any screen when browser's display zoom is more than 100%.

  var retina = (window.devicePixelRatio || window.screen.deviceXDPI / window.screen.logicalXDPI) > 1; // @property canvas: Boolean
  // `true` when the browser supports [`<canvas>`](https://developer.mozilla.org/docs/Web/API/Canvas_API).

  var canvas = function () {
    return !!document.createElement('canvas').getContext;
  }(); // @property svg: Boolean
  // `true` when the browser supports [SVG](https://developer.mozilla.org/docs/Web/SVG).


  var svg = !!(document.createElementNS && svgCreate('svg').createSVGRect); // @property vml: Boolean
  // `true` if the browser supports [VML](https://en.wikipedia.org/wiki/Vector_Markup_Language).

  var vml = !svg && function () {
    try {
      var div = document.createElement('div');
      div.innerHTML = '<v:shape adj="1"/>';
      var shape = div.firstChild;
      shape.style.behavior = 'url(#default#VML)';
      return shape && typeof shape.adj === 'object';
    } catch (e) {
      return false;
    }
  }();

  function userAgentContains(str) {
    return navigator.userAgent.toLowerCase().indexOf(str) >= 0;
  }

  var Browser = (Object.freeze || Object)({
    ie: ie,
    ielt9: ielt9,
    edge: edge,
    webkit: webkit,
    android: android,
    android23: android23,
    androidStock: androidStock,
    opera: opera,
    chrome: chrome,
    gecko: gecko,
    safari: safari,
    phantom: phantom,
    opera12: opera12,
    win: win,
    ie3d: ie3d,
    webkit3d: webkit3d,
    gecko3d: gecko3d,
    any3d: any3d,
    mobile: mobile,
    mobileWebkit: mobileWebkit,
    mobileWebkit3d: mobileWebkit3d,
    msPointer: msPointer,
    pointer: pointer,
    touch: touch,
    mobileOpera: mobileOpera,
    mobileGecko: mobileGecko,
    retina: retina,
    canvas: canvas,
    svg: svg,
    vml: vml
  });
  /*
   * Extends L.DomEvent to provide touch support for Internet Explorer and Windows-based devices.
   */

  var POINTER_DOWN = msPointer ? 'MSPointerDown' : 'pointerdown';
  var POINTER_MOVE = msPointer ? 'MSPointerMove' : 'pointermove';
  var POINTER_UP = msPointer ? 'MSPointerUp' : 'pointerup';
  var POINTER_CANCEL = msPointer ? 'MSPointerCancel' : 'pointercancel';
  var TAG_WHITE_LIST = ['INPUT', 'SELECT', 'OPTION'];
  var _pointers = {};
  var _pointerDocListener = false; // DomEvent.DoubleTap needs to know about this

  var _pointersCount = 0; // Provides a touch events wrapper for (ms)pointer events.
  // ref http://www.w3.org/TR/pointerevents/ https://www.w3.org/Bugs/Public/show_bug.cgi?id=22890

  function addPointerListener(obj, type, handler, id) {
    if (type === 'touchstart') {
      _addPointerStart(obj, handler, id);
    } else if (type === 'touchmove') {
      _addPointerMove(obj, handler, id);
    } else if (type === 'touchend') {
      _addPointerEnd(obj, handler, id);
    }

    return this;
  }

  function removePointerListener(obj, type, id) {
    var handler = obj['_leaflet_' + type + id];

    if (type === 'touchstart') {
      obj.removeEventListener(POINTER_DOWN, handler, false);
    } else if (type === 'touchmove') {
      obj.removeEventListener(POINTER_MOVE, handler, false);
    } else if (type === 'touchend') {
      obj.removeEventListener(POINTER_UP, handler, false);
      obj.removeEventListener(POINTER_CANCEL, handler, false);
    }

    return this;
  }

  function _addPointerStart(obj, handler, id) {
    var onDown = bind(function (e) {
      if (e.pointerType !== 'mouse' && e.MSPOINTER_TYPE_MOUSE && e.pointerType !== e.MSPOINTER_TYPE_MOUSE) {
        // In IE11, some touch events needs to fire for form controls, or
        // the controls will stop working. We keep a whitelist of tag names that
        // need these events. For other target tags, we prevent default on the event.
        if (TAG_WHITE_LIST.indexOf(e.target.tagName) < 0) {
          preventDefault(e);
        } else {
          return;
        }
      }

      _handlePointer(e, handler);
    });
    obj['_leaflet_touchstart' + id] = onDown;
    obj.addEventListener(POINTER_DOWN, onDown, false); // need to keep track of what pointers and how many are active to provide e.touches emulation

    if (!_pointerDocListener) {
      // we listen documentElement as any drags that end by moving the touch off the screen get fired there
      document.documentElement.addEventListener(POINTER_DOWN, _globalPointerDown, true);
      document.documentElement.addEventListener(POINTER_MOVE, _globalPointerMove, true);
      document.documentElement.addEventListener(POINTER_UP, _globalPointerUp, true);
      document.documentElement.addEventListener(POINTER_CANCEL, _globalPointerUp, true);
      _pointerDocListener = true;
    }
  }

  function _globalPointerDown(e) {
    _pointers[e.pointerId] = e;
    _pointersCount++;
  }

  function _globalPointerMove(e) {
    if (_pointers[e.pointerId]) {
      _pointers[e.pointerId] = e;
    }
  }

  function _globalPointerUp(e) {
    delete _pointers[e.pointerId];
    _pointersCount--;
  }

  function _handlePointer(e, handler) {
    e.touches = [];

    for (var i in _pointers) {
      e.touches.push(_pointers[i]);
    }

    e.changedTouches = [e];
    handler(e);
  }

  function _addPointerMove(obj, handler, id) {
    var onMove = function (e) {
      // don't fire touch moves when mouse isn't down
      if ((e.pointerType === e.MSPOINTER_TYPE_MOUSE || e.pointerType === 'mouse') && e.buttons === 0) {
        return;
      }

      _handlePointer(e, handler);
    };

    obj['_leaflet_touchmove' + id] = onMove;
    obj.addEventListener(POINTER_MOVE, onMove, false);
  }

  function _addPointerEnd(obj, handler, id) {
    var onUp = function (e) {
      _handlePointer(e, handler);
    };

    obj['_leaflet_touchend' + id] = onUp;
    obj.addEventListener(POINTER_UP, onUp, false);
    obj.addEventListener(POINTER_CANCEL, onUp, false);
  }
  /*
   * Extends the event handling code with double tap support for mobile browsers.
   */


  var _touchstart = msPointer ? 'MSPointerDown' : pointer ? 'pointerdown' : 'touchstart';

  var _touchend = msPointer ? 'MSPointerUp' : pointer ? 'pointerup' : 'touchend';

  var _pre = '_leaflet_'; // inspired by Zepto touch code by Thomas Fuchs

  function addDoubleTapListener(obj, handler, id) {
    var last,
        touch$$1,
        doubleTap = false,
        delay = 250;

    function onTouchStart(e) {
      var count;

      if (pointer) {
        if (!edge || e.pointerType === 'mouse') {
          return;
        }

        count = _pointersCount;
      } else {
        count = e.touches.length;
      }

      if (count > 1) {
        return;
      }

      var now = Date.now(),
          delta = now - (last || now);
      touch$$1 = e.touches ? e.touches[0] : e;
      doubleTap = delta > 0 && delta <= delay;
      last = now;
    }

    function onTouchEnd(e) {
      if (doubleTap && !touch$$1.cancelBubble) {
        if (pointer) {
          if (!edge || e.pointerType === 'mouse') {
            return;
          } // work around .type being readonly with MSPointer* events


          var newTouch = {},
              prop,
              i;

          for (i in touch$$1) {
            prop = touch$$1[i];
            newTouch[i] = prop && prop.bind ? prop.bind(touch$$1) : prop;
          }

          touch$$1 = newTouch;
        }

        touch$$1.type = 'dblclick';
        handler(touch$$1);
        last = null;
      }
    }

    obj[_pre + _touchstart + id] = onTouchStart;
    obj[_pre + _touchend + id] = onTouchEnd;
    obj[_pre + 'dblclick' + id] = handler;
    obj.addEventListener(_touchstart, onTouchStart, false);
    obj.addEventListener(_touchend, onTouchEnd, false); // On some platforms (notably, chrome<55 on win10 + touchscreen + mouse),
    // the browser doesn't fire touchend/pointerup events but does fire
    // native dblclicks. See #4127.
    // Edge 14 also fires native dblclicks, but only for pointerType mouse, see #5180.

    obj.addEventListener('dblclick', handler, false);
    return this;
  }

  function removeDoubleTapListener(obj, id) {
    var touchstart = obj[_pre + _touchstart + id],
        touchend = obj[_pre + _touchend + id],
        dblclick = obj[_pre + 'dblclick' + id];
    obj.removeEventListener(_touchstart, touchstart, false);
    obj.removeEventListener(_touchend, touchend, false);

    if (!edge) {
      obj.removeEventListener('dblclick', dblclick, false);
    }

    return this;
  }
  /*
   * @namespace DomUtil
   *
   * Utility functions to work with the [DOM](https://developer.mozilla.org/docs/Web/API/Document_Object_Model)
   * tree, used by Leaflet internally.
   *
   * Most functions expecting or returning a `HTMLElement` also work for
   * SVG elements. The only difference is that classes refer to CSS classes
   * in HTML and SVG classes in SVG.
   */
  // @property TRANSFORM: String
  // Vendor-prefixed transform style name (e.g. `'webkitTransform'` for WebKit).


  var TRANSFORM = testProp(['transform', 'webkitTransform', 'OTransform', 'MozTransform', 'msTransform']); // webkitTransition comes first because some browser versions that drop vendor prefix don't do
  // the same for the transitionend event, in particular the Android 4.1 stock browser
  // @property TRANSITION: String
  // Vendor-prefixed transition style name.

  var TRANSITION = testProp(['webkitTransition', 'transition', 'OTransition', 'MozTransition', 'msTransition']); // @property TRANSITION_END: String
  // Vendor-prefixed transitionend event name.

  var TRANSITION_END = TRANSITION === 'webkitTransition' || TRANSITION === 'OTransition' ? TRANSITION + 'End' : 'transitionend'; // @function get(id: String|HTMLElement): HTMLElement
  // Returns an element given its DOM id, or returns the element itself
  // if it was passed directly.

  function get(id) {
    return typeof id === 'string' ? document.getElementById(id) : id;
  } // @function getStyle(el: HTMLElement, styleAttrib: String): String
  // Returns the value for a certain style attribute on an element,
  // including computed values or values set through CSS.


  function getStyle(el, style) {
    var value = el.style[style] || el.currentStyle && el.currentStyle[style];

    if ((!value || value === 'auto') && document.defaultView) {
      var css = document.defaultView.getComputedStyle(el, null);
      value = css ? css[style] : null;
    }

    return value === 'auto' ? null : value;
  } // @function create(tagName: String, className?: String, container?: HTMLElement): HTMLElement
  // Creates an HTML element with `tagName`, sets its class to `className`, and optionally appends it to `container` element.


  function create$1(tagName, className, container) {
    var el = document.createElement(tagName);
    el.className = className || '';

    if (container) {
      container.appendChild(el);
    }

    return el;
  } // @function remove(el: HTMLElement)
  // Removes `el` from its parent element


  function remove(el) {
    var parent = el.parentNode;

    if (parent) {
      parent.removeChild(el);
    }
  } // @function empty(el: HTMLElement)
  // Removes all of `el`'s children elements from `el`


  function empty(el) {
    while (el.firstChild) {
      el.removeChild(el.firstChild);
    }
  } // @function toFront(el: HTMLElement)
  // Makes `el` the last child of its parent, so it renders in front of the other children.


  function toFront(el) {
    var parent = el.parentNode;

    if (parent && parent.lastChild !== el) {
      parent.appendChild(el);
    }
  } // @function toBack(el: HTMLElement)
  // Makes `el` the first child of its parent, so it renders behind the other children.


  function toBack(el) {
    var parent = el.parentNode;

    if (parent && parent.firstChild !== el) {
      parent.insertBefore(el, parent.firstChild);
    }
  } // @function hasClass(el: HTMLElement, name: String): Boolean
  // Returns `true` if the element's class attribute contains `name`.


  function hasClass(el, name) {
    if (el.classList !== undefined) {
      return el.classList.contains(name);
    }

    var className = getClass(el);
    return className.length > 0 && new RegExp('(^|\\s)' + name + '(\\s|$)').test(className);
  } // @function addClass(el: HTMLElement, name: String)
  // Adds `name` to the element's class attribute.


  function addClass(el, name) {
    if (el.classList !== undefined) {
      var classes = splitWords(name);

      for (var i = 0, len = classes.length; i < len; i++) {
        el.classList.add(classes[i]);
      }
    } else if (!hasClass(el, name)) {
      var className = getClass(el);
      setClass(el, (className ? className + ' ' : '') + name);
    }
  } // @function removeClass(el: HTMLElement, name: String)
  // Removes `name` from the element's class attribute.


  function removeClass(el, name) {
    if (el.classList !== undefined) {
      el.classList.remove(name);
    } else {
      setClass(el, trim((' ' + getClass(el) + ' ').replace(' ' + name + ' ', ' ')));
    }
  } // @function setClass(el: HTMLElement, name: String)
  // Sets the element's class.


  function setClass(el, name) {
    if (el.className.baseVal === undefined) {
      el.className = name;
    } else {
      // in case of SVG element
      el.className.baseVal = name;
    }
  } // @function getClass(el: HTMLElement): String
  // Returns the element's class.


  function getClass(el) {
    // Check if the element is an SVGElementInstance and use the correspondingElement instead
    // (Required for linked SVG elements in IE11.)
    if (el.correspondingElement) {
      el = el.correspondingElement;
    }

    return el.className.baseVal === undefined ? el.className : el.className.baseVal;
  } // @function setOpacity(el: HTMLElement, opacity: Number)
  // Set the opacity of an element (including old IE support).
  // `opacity` must be a number from `0` to `1`.


  function setOpacity(el, value) {
    if ('opacity' in el.style) {
      el.style.opacity = value;
    } else if ('filter' in el.style) {
      _setOpacityIE(el, value);
    }
  }

  function _setOpacityIE(el, value) {
    var filter = false,
        filterName = 'DXImageTransform.Microsoft.Alpha'; // filters collection throws an error if we try to retrieve a filter that doesn't exist

    try {
      filter = el.filters.item(filterName);
    } catch (e) {
      // don't set opacity to 1 if we haven't already set an opacity,
      // it isn't needed and breaks transparent pngs.
      if (value === 1) {
        return;
      }
    }

    value = Math.round(value * 100);

    if (filter) {
      filter.Enabled = value !== 100;
      filter.Opacity = value;
    } else {
      el.style.filter += ' progid:' + filterName + '(opacity=' + value + ')';
    }
  } // @function testProp(props: String[]): String|false
  // Goes through the array of style names and returns the first name
  // that is a valid style name for an element. If no such name is found,
  // it returns false. Useful for vendor-prefixed styles like `transform`.


  function testProp(props) {
    var style = document.documentElement.style;

    for (var i = 0; i < props.length; i++) {
      if (props[i] in style) {
        return props[i];
      }
    }

    return false;
  } // @function setTransform(el: HTMLElement, offset: Point, scale?: Number)
  // Resets the 3D CSS transform of `el` so it is translated by `offset` pixels
  // and optionally scaled by `scale`. Does not have an effect if the
  // browser doesn't support 3D CSS transforms.


  function setTransform(el, offset, scale) {
    var pos = offset || new Point(0, 0);
    el.style[TRANSFORM] = (ie3d ? 'translate(' + pos.x + 'px,' + pos.y + 'px)' : 'translate3d(' + pos.x + 'px,' + pos.y + 'px,0)') + (scale ? ' scale(' + scale + ')' : '');
  } // @function setPosition(el: HTMLElement, position: Point)
  // Sets the position of `el` to coordinates specified by `position`,
  // using CSS translate or top/left positioning depending on the browser
  // (used by Leaflet internally to position its layers).


  function setPosition(el, point) {
    /*eslint-disable */
    el._leaflet_pos = point;
    /* eslint-enable */

    if (any3d) {
      setTransform(el, point);
    } else {
      el.style.left = point.x + 'px';
      el.style.top = point.y + 'px';
    }
  } // @function getPosition(el: HTMLElement): Point
  // Returns the coordinates of an element previously positioned with setPosition.


  function getPosition(el) {
    // this method is only used for elements previously positioned using setPosition,
    // so it's safe to cache the position for performance
    return el._leaflet_pos || new Point(0, 0);
  } // @function disableTextSelection()
  // Prevents the user from generating `selectstart` DOM events, usually generated
  // when the user drags the mouse through a page with text. Used internally
  // by Leaflet to override the behaviour of any click-and-drag interaction on
  // the map. Affects drag interactions on the whole document.
  // @function enableTextSelection()
  // Cancels the effects of a previous [`L.DomUtil.disableTextSelection`](#domutil-disabletextselection).


  var disableTextSelection;
  var enableTextSelection;

  var _userSelect;

  if ('onselectstart' in document) {
    disableTextSelection = function () {
      on(window, 'selectstart', preventDefault);
    };

    enableTextSelection = function () {
      off(window, 'selectstart', preventDefault);
    };
  } else {
    var userSelectProperty = testProp(['userSelect', 'WebkitUserSelect', 'OUserSelect', 'MozUserSelect', 'msUserSelect']);

    disableTextSelection = function () {
      if (userSelectProperty) {
        var style = document.documentElement.style;
        _userSelect = style[userSelectProperty];
        style[userSelectProperty] = 'none';
      }
    };

    enableTextSelection = function () {
      if (userSelectProperty) {
        document.documentElement.style[userSelectProperty] = _userSelect;
        _userSelect = undefined;
      }
    };
  } // @function disableImageDrag()
  // As [`L.DomUtil.disableTextSelection`](#domutil-disabletextselection), but
  // for `dragstart` DOM events, usually generated when the user drags an image.


  function disableImageDrag() {
    on(window, 'dragstart', preventDefault);
  } // @function enableImageDrag()
  // Cancels the effects of a previous [`L.DomUtil.disableImageDrag`](#domutil-disabletextselection).


  function enableImageDrag() {
    off(window, 'dragstart', preventDefault);
  }

  var _outlineElement;

  var _outlineStyle; // @function preventOutline(el: HTMLElement)
  // Makes the [outline](https://developer.mozilla.org/docs/Web/CSS/outline)
  // of the element `el` invisible. Used internally by Leaflet to prevent
  // focusable elements from displaying an outline when the user performs a
  // drag interaction on them.


  function preventOutline(element) {
    while (element.tabIndex === -1) {
      element = element.parentNode;
    }

    if (!element.style) {
      return;
    }

    restoreOutline();
    _outlineElement = element;
    _outlineStyle = element.style.outline;
    element.style.outline = 'none';
    on(window, 'keydown', restoreOutline);
  } // @function restoreOutline()
  // Cancels the effects of a previous [`L.DomUtil.preventOutline`]().


  function restoreOutline() {
    if (!_outlineElement) {
      return;
    }

    _outlineElement.style.outline = _outlineStyle;
    _outlineElement = undefined;
    _outlineStyle = undefined;
    off(window, 'keydown', restoreOutline);
  } // @function getSizedParentNode(el: HTMLElement): HTMLElement
  // Finds the closest parent node which size (width and height) is not null.


  function getSizedParentNode(element) {
    do {
      element = element.parentNode;
    } while ((!element.offsetWidth || !element.offsetHeight) && element !== document.body);

    return element;
  } // @function getScale(el: HTMLElement): Object
  // Computes the CSS scale currently applied on the element.
  // Returns an object with `x` and `y` members as horizontal and vertical scales respectively,
  // and `boundingClientRect` as the result of [`getBoundingClientRect()`](https://developer.mozilla.org/en-US/docs/Web/API/Element/getBoundingClientRect).


  function getScale(element) {
    var rect = element.getBoundingClientRect(); // Read-only in old browsers.

    return {
      x: rect.width / element.offsetWidth || 1,
      y: rect.height / element.offsetHeight || 1,
      boundingClientRect: rect
    };
  }

  var DomUtil = (Object.freeze || Object)({
    TRANSFORM: TRANSFORM,
    TRANSITION: TRANSITION,
    TRANSITION_END: TRANSITION_END,
    get: get,
    getStyle: getStyle,
    create: create$1,
    remove: remove,
    empty: empty,
    toFront: toFront,
    toBack: toBack,
    hasClass: hasClass,
    addClass: addClass,
    removeClass: removeClass,
    setClass: setClass,
    getClass: getClass,
    setOpacity: setOpacity,
    testProp: testProp,
    setTransform: setTransform,
    setPosition: setPosition,
    getPosition: getPosition,
    disableTextSelection: disableTextSelection,
    enableTextSelection: enableTextSelection,
    disableImageDrag: disableImageDrag,
    enableImageDrag: enableImageDrag,
    preventOutline: preventOutline,
    restoreOutline: restoreOutline,
    getSizedParentNode: getSizedParentNode,
    getScale: getScale
  });
  /*
   * @namespace DomEvent
   * Utility functions to work with the [DOM events](https://developer.mozilla.org/docs/Web/API/Event), used by Leaflet internally.
   */
  // Inspired by John Resig, Dean Edwards and YUI addEvent implementations.
  // @function on(el: HTMLElement, types: String, fn: Function, context?: Object): this
  // Adds a listener function (`fn`) to a particular DOM event type of the
  // element `el`. You can optionally specify the context of the listener
  // (object the `this` keyword will point to). You can also pass several
  // space-separated types (e.g. `'click dblclick'`).
  // @alternative
  // @function on(el: HTMLElement, eventMap: Object, context?: Object): this
  // Adds a set of type/listener pairs, e.g. `{click: onClick, mousemove: onMouseMove}`

  function on(obj, types, fn, context) {
    if (typeof types === 'object') {
      for (var type in types) {
        addOne(obj, type, types[type], fn);
      }
    } else {
      types = splitWords(types);

      for (var i = 0, len = types.length; i < len; i++) {
        addOne(obj, types[i], fn, context);
      }
    }

    return this;
  }

  var eventsKey = '_leaflet_events'; // @function off(el: HTMLElement, types: String, fn: Function, context?: Object): this
  // Removes a previously added listener function.
  // Note that if you passed a custom context to on, you must pass the same
  // context to `off` in order to remove the listener.
  // @alternative
  // @function off(el: HTMLElement, eventMap: Object, context?: Object): this
  // Removes a set of type/listener pairs, e.g. `{click: onClick, mousemove: onMouseMove}`

  function off(obj, types, fn, context) {
    if (typeof types === 'object') {
      for (var type in types) {
        removeOne(obj, type, types[type], fn);
      }
    } else if (types) {
      types = splitWords(types);

      for (var i = 0, len = types.length; i < len; i++) {
        removeOne(obj, types[i], fn, context);
      }
    } else {
      for (var j in obj[eventsKey]) {
        removeOne(obj, j, obj[eventsKey][j]);
      }

      delete obj[eventsKey];
    }

    return this;
  }

  function addOne(obj, type, fn, context) {
    var id = type + stamp(fn) + (context ? '_' + stamp(context) : '');

    if (obj[eventsKey] && obj[eventsKey][id]) {
      return this;
    }

    var handler = function (e) {
      return fn.call(context || obj, e || window.event);
    };

    var originalHandler = handler;

    if (pointer && type.indexOf('touch') === 0) {
      // Needs DomEvent.Pointer.js
      addPointerListener(obj, type, handler, id);
    } else if (touch && type === 'dblclick' && addDoubleTapListener && !(pointer && chrome)) {
      // Chrome >55 does not need the synthetic dblclicks from addDoubleTapListener
      // See #5180
      addDoubleTapListener(obj, handler, id);
    } else if ('addEventListener' in obj) {
      if (type === 'mousewheel') {
        obj.addEventListener('onwheel' in obj ? 'wheel' : 'mousewheel', handler, false);
      } else if (type === 'mouseenter' || type === 'mouseleave') {
        handler = function (e) {
          e = e || window.event;

          if (isExternalTarget(obj, e)) {
            originalHandler(e);
          }
        };

        obj.addEventListener(type === 'mouseenter' ? 'mouseover' : 'mouseout', handler, false);
      } else {
        if (type === 'click' && android) {
          handler = function (e) {
            filterClick(e, originalHandler);
          };
        }

        obj.addEventListener(type, handler, false);
      }
    } else if ('attachEvent' in obj) {
      obj.attachEvent('on' + type, handler);
    }

    obj[eventsKey] = obj[eventsKey] || {};
    obj[eventsKey][id] = handler;
  }

  function removeOne(obj, type, fn, context) {
    var id = type + stamp(fn) + (context ? '_' + stamp(context) : ''),
        handler = obj[eventsKey] && obj[eventsKey][id];

    if (!handler) {
      return this;
    }

    if (pointer && type.indexOf('touch') === 0) {
      removePointerListener(obj, type, id);
    } else if (touch && type === 'dblclick' && removeDoubleTapListener && !(pointer && chrome)) {
      removeDoubleTapListener(obj, id);
    } else if ('removeEventListener' in obj) {
      if (type === 'mousewheel') {
        obj.removeEventListener('onwheel' in obj ? 'wheel' : 'mousewheel', handler, false);
      } else {
        obj.removeEventListener(type === 'mouseenter' ? 'mouseover' : type === 'mouseleave' ? 'mouseout' : type, handler, false);
      }
    } else if ('detachEvent' in obj) {
      obj.detachEvent('on' + type, handler);
    }

    obj[eventsKey][id] = null;
  } // @function stopPropagation(ev: DOMEvent): this
  // Stop the given event from propagation to parent elements. Used inside the listener functions:
  // ```js
  // L.DomEvent.on(div, 'click', function (ev) {
  // 	L.DomEvent.stopPropagation(ev);
  // });
  // ```


  function stopPropagation(e) {
    if (e.stopPropagation) {
      e.stopPropagation();
    } else if (e.originalEvent) {
      // In case of Leaflet event.
      e.originalEvent._stopped = true;
    } else {
      e.cancelBubble = true;
    }

    skipped(e);
    return this;
  } // @function disableScrollPropagation(el: HTMLElement): this
  // Adds `stopPropagation` to the element's `'mousewheel'` events (plus browser variants).


  function disableScrollPropagation(el) {
    addOne(el, 'mousewheel', stopPropagation);
    return this;
  } // @function disableClickPropagation(el: HTMLElement): this
  // Adds `stopPropagation` to the element's `'click'`, `'doubleclick'`,
  // `'mousedown'` and `'touchstart'` events (plus browser variants).


  function disableClickPropagation(el) {
    on(el, 'mousedown touchstart dblclick', stopPropagation);
    addOne(el, 'click', fakeStop);
    return this;
  } // @function preventDefault(ev: DOMEvent): this
  // Prevents the default action of the DOM Event `ev` from happening (such as
  // following a link in the href of the a element, or doing a POST request
  // with page reload when a `<form>` is submitted).
  // Use it inside listener functions.


  function preventDefault(e) {
    if (e.preventDefault) {
      e.preventDefault();
    } else {
      e.returnValue = false;
    }

    return this;
  } // @function stop(ev: DOMEvent): this
  // Does `stopPropagation` and `preventDefault` at the same time.


  function stop(e) {
    preventDefault(e);
    stopPropagation(e);
    return this;
  } // @function getMousePosition(ev: DOMEvent, container?: HTMLElement): Point
  // Gets normalized mouse position from a DOM event relative to the
  // `container` (border excluded) or to the whole page if not specified.


  function getMousePosition(e, container) {
    if (!container) {
      return new Point(e.clientX, e.clientY);
    }

    var scale = getScale(container),
        offset = scale.boundingClientRect; // left and top  values are in page scale (like the event clientX/Y)

    return new Point( // offset.left/top values are in page scale (like clientX/Y),
    // whereas clientLeft/Top (border width) values are the original values (before CSS scale applies).
    (e.clientX - offset.left) / scale.x - container.clientLeft, (e.clientY - offset.top) / scale.y - container.clientTop);
  } // Chrome on Win scrolls double the pixels as in other platforms (see #4538),
  // and Firefox scrolls device pixels, not CSS pixels


  var wheelPxFactor = win && chrome ? 2 * window.devicePixelRatio : gecko ? window.devicePixelRatio : 1; // @function getWheelDelta(ev: DOMEvent): Number
  // Gets normalized wheel delta from a mousewheel DOM event, in vertical
  // pixels scrolled (negative if scrolling down).
  // Events from pointing devices without precise scrolling are mapped to
  // a best guess of 60 pixels.

  function getWheelDelta(e) {
    return edge ? e.wheelDeltaY / 2 : // Don't trust window-geometry-based delta
    e.deltaY && e.deltaMode === 0 ? -e.deltaY / wheelPxFactor : // Pixels
    e.deltaY && e.deltaMode === 1 ? -e.deltaY * 20 : // Lines
    e.deltaY && e.deltaMode === 2 ? -e.deltaY * 60 : // Pages
    e.deltaX || e.deltaZ ? 0 : // Skip horizontal/depth wheel events
    e.wheelDelta ? (e.wheelDeltaY || e.wheelDelta) / 2 : // Legacy IE pixels
    e.detail && Math.abs(e.detail) < 32765 ? -e.detail * 20 : // Legacy Moz lines
    e.detail ? e.detail / -32765 * 60 : // Legacy Moz pages
    0;
  }

  var skipEvents = {};

  function fakeStop(e) {
    // fakes stopPropagation by setting a special event flag, checked/reset with skipped(e)
    skipEvents[e.type] = true;
  }

  function skipped(e) {
    var events = skipEvents[e.type]; // reset when checking, as it's only used in map container and propagates outside of the map

    skipEvents[e.type] = false;
    return events;
  } // check if element really left/entered the event target (for mouseenter/mouseleave)


  function isExternalTarget(el, e) {
    var related = e.relatedTarget;

    if (!related) {
      return true;
    }

    try {
      while (related && related !== el) {
        related = related.parentNode;
      }
    } catch (err) {
      return false;
    }

    return related !== el;
  }

  var lastClick; // this is a horrible workaround for a bug in Android where a single touch triggers two click events

  function filterClick(e, handler) {
    var timeStamp = e.timeStamp || e.originalEvent && e.originalEvent.timeStamp,
        elapsed = lastClick && timeStamp - lastClick; // are they closer together than 500ms yet more than 100ms?
    // Android typically triggers them ~300ms apart while multiple listeners
    // on the same event should be triggered far faster;
    // or check if click is simulated on the element, and if it is, reject any non-simulated events

    if (elapsed && elapsed > 100 && elapsed < 500 || e.target._simulatedClick && !e._simulated) {
      stop(e);
      return;
    }

    lastClick = timeStamp;
    handler(e);
  }

  var DomEvent = (Object.freeze || Object)({
    on: on,
    off: off,
    stopPropagation: stopPropagation,
    disableScrollPropagation: disableScrollPropagation,
    disableClickPropagation: disableClickPropagation,
    preventDefault: preventDefault,
    stop: stop,
    getMousePosition: getMousePosition,
    getWheelDelta: getWheelDelta,
    fakeStop: fakeStop,
    skipped: skipped,
    isExternalTarget: isExternalTarget,
    addListener: on,
    removeListener: off
  });
  /*
   * @class PosAnimation
   * @aka L.PosAnimation
   * @inherits Evented
   * Used internally for panning animations, utilizing CSS3 Transitions for modern browsers and a timer fallback for IE6-9.
   *
   * @example
   * ```js
   * var fx = new L.PosAnimation();
   * fx.run(el, [300, 500], 0.5);
   * ```
   *
   * @constructor L.PosAnimation()
   * Creates a `PosAnimation` object.
   *
   */

  var PosAnimation = Evented.extend({
    // @method run(el: HTMLElement, newPos: Point, duration?: Number, easeLinearity?: Number)
    // Run an animation of a given element to a new position, optionally setting
    // duration in seconds (`0.25` by default) and easing linearity factor (3rd
    // argument of the [cubic bezier curve](http://cubic-bezier.com/#0,0,.5,1),
    // `0.5` by default).
    run: function (el, newPos, duration, easeLinearity) {
      this.stop();
      this._el = el;
      this._inProgress = true;
      this._duration = duration || 0.25;
      this._easeOutPower = 1 / Math.max(easeLinearity || 0.5, 0.2);
      this._startPos = getPosition(el);
      this._offset = newPos.subtract(this._startPos);
      this._startTime = +new Date(); // @event start: Event
      // Fired when the animation starts

      this.fire('start');

      this._animate();
    },
    // @method stop()
    // Stops the animation (if currently running).
    stop: function () {
      if (!this._inProgress) {
        return;
      }

      this._step(true);

      this._complete();
    },
    _animate: function () {
      // animation loop
      this._animId = requestAnimFrame(this._animate, this);

      this._step();
    },
    _step: function (round) {
      var elapsed = +new Date() - this._startTime,
          duration = this._duration * 1000;

      if (elapsed < duration) {
        this._runFrame(this._easeOut(elapsed / duration), round);
      } else {
        this._runFrame(1);

        this._complete();
      }
    },
    _runFrame: function (progress, round) {
      var pos = this._startPos.add(this._offset.multiplyBy(progress));

      if (round) {
        pos._round();
      }

      setPosition(this._el, pos); // @event step: Event
      // Fired continuously during the animation.

      this.fire('step');
    },
    _complete: function () {
      cancelAnimFrame(this._animId);
      this._inProgress = false; // @event end: Event
      // Fired when the animation ends.

      this.fire('end');
    },
    _easeOut: function (t) {
      return 1 - Math.pow(1 - t, this._easeOutPower);
    }
  });
  /*
   * @class Map
   * @aka L.Map
   * @inherits Evented
   *
   * The central class of the API — it is used to create a map on a page and manipulate it.
   *
   * @example
   *
   * ```js
   * // initialize the map on the "map" div with a given center and zoom
   * var map = L.map('map', {
   * 	center: [51.505, -0.09],
   * 	zoom: 13
   * });
   * ```
   *
   */

  var Map = Evented.extend({
    options: {
      // @section Map State Options
      // @option crs: CRS = L.CRS.EPSG3857
      // The [Coordinate Reference System](#crs) to use. Don't change this if you're not
      // sure what it means.
      crs: EPSG3857,
      // @option center: LatLng = undefined
      // Initial geographic center of the map
      center: undefined,
      // @option zoom: Number = undefined
      // Initial map zoom level
      zoom: undefined,
      // @option minZoom: Number = *
      // Minimum zoom level of the map.
      // If not specified and at least one `GridLayer` or `TileLayer` is in the map,
      // the lowest of their `minZoom` options will be used instead.
      minZoom: undefined,
      // @option maxZoom: Number = *
      // Maximum zoom level of the map.
      // If not specified and at least one `GridLayer` or `TileLayer` is in the map,
      // the highest of their `maxZoom` options will be used instead.
      maxZoom: undefined,
      // @option layers: Layer[] = []
      // Array of layers that will be added to the map initially
      layers: [],
      // @option maxBounds: LatLngBounds = null
      // When this option is set, the map restricts the view to the given
      // geographical bounds, bouncing the user back if the user tries to pan
      // outside the view. To set the restriction dynamically, use
      // [`setMaxBounds`](#map-setmaxbounds) method.
      maxBounds: undefined,
      // @option renderer: Renderer = *
      // The default method for drawing vector layers on the map. `L.SVG`
      // or `L.Canvas` by default depending on browser support.
      renderer: undefined,
      // @section Animation Options
      // @option zoomAnimation: Boolean = true
      // Whether the map zoom animation is enabled. By default it's enabled
      // in all browsers that support CSS3 Transitions except Android.
      zoomAnimation: true,
      // @option zoomAnimationThreshold: Number = 4
      // Won't animate zoom if the zoom difference exceeds this value.
      zoomAnimationThreshold: 4,
      // @option fadeAnimation: Boolean = true
      // Whether the tile fade animation is enabled. By default it's enabled
      // in all browsers that support CSS3 Transitions except Android.
      fadeAnimation: true,
      // @option markerZoomAnimation: Boolean = true
      // Whether markers animate their zoom with the zoom animation, if disabled
      // they will disappear for the length of the animation. By default it's
      // enabled in all browsers that support CSS3 Transitions except Android.
      markerZoomAnimation: true,
      // @option transform3DLimit: Number = 2^23
      // Defines the maximum size of a CSS translation transform. The default
      // value should not be changed unless a web browser positions layers in
      // the wrong place after doing a large `panBy`.
      transform3DLimit: 8388608,
      // Precision limit of a 32-bit float
      // @section Interaction Options
      // @option zoomSnap: Number = 1
      // Forces the map's zoom level to always be a multiple of this, particularly
      // right after a [`fitBounds()`](#map-fitbounds) or a pinch-zoom.
      // By default, the zoom level snaps to the nearest integer; lower values
      // (e.g. `0.5` or `0.1`) allow for greater granularity. A value of `0`
      // means the zoom level will not be snapped after `fitBounds` or a pinch-zoom.
      zoomSnap: 1,
      // @option zoomDelta: Number = 1
      // Controls how much the map's zoom level will change after a
      // [`zoomIn()`](#map-zoomin), [`zoomOut()`](#map-zoomout), pressing `+`
      // or `-` on the keyboard, or using the [zoom controls](#control-zoom).
      // Values smaller than `1` (e.g. `0.5`) allow for greater granularity.
      zoomDelta: 1,
      // @option trackResize: Boolean = true
      // Whether the map automatically handles browser window resize to update itself.
      trackResize: true
    },
    initialize: function (id, options) {
      // (HTMLElement or String, Object)
      options = setOptions(this, options); // Make sure to assign internal flags at the beginning,
      // to avoid inconsistent state in some edge cases.

      this._handlers = [];
      this._layers = {};
      this._zoomBoundLayers = {};
      this._sizeChanged = true;

      this._initContainer(id);

      this._initLayout(); // hack for https://github.com/Leaflet/Leaflet/issues/1980


      this._onResize = bind(this._onResize, this);

      this._initEvents();

      if (options.maxBounds) {
        this.setMaxBounds(options.maxBounds);
      }

      if (options.zoom !== undefined) {
        this._zoom = this._limitZoom(options.zoom);
      }

      if (options.center && options.zoom !== undefined) {
        this.setView(toLatLng(options.center), options.zoom, {
          reset: true
        });
      }

      this.callInitHooks(); // don't animate on browsers without hardware-accelerated transitions or old Android/Opera

      this._zoomAnimated = TRANSITION && any3d && !mobileOpera && this.options.zoomAnimation; // zoom transitions run with the same duration for all layers, so if one of transitionend events
      // happens after starting zoom animation (propagating to the map pane), we know that it ended globally

      if (this._zoomAnimated) {
        this._createAnimProxy();

        on(this._proxy, TRANSITION_END, this._catchTransitionEnd, this);
      }

      this._addLayers(this.options.layers);
    },
    // @section Methods for modifying map state
    // @method setView(center: LatLng, zoom: Number, options?: Zoom/pan options): this
    // Sets the view of the map (geographical center and zoom) with the given
    // animation options.
    setView: function (center, zoom, options) {
      zoom = zoom === undefined ? this._zoom : this._limitZoom(zoom);
      center = this._limitCenter(toLatLng(center), zoom, this.options.maxBounds);
      options = options || {};

      this._stop();

      if (this._loaded && !options.reset && options !== true) {
        if (options.animate !== undefined) {
          options.zoom = extend({
            animate: options.animate
          }, options.zoom);
          options.pan = extend({
            animate: options.animate,
            duration: options.duration
          }, options.pan);
        } // try animating pan or zoom


        var moved = this._zoom !== zoom ? this._tryAnimatedZoom && this._tryAnimatedZoom(center, zoom, options.zoom) : this._tryAnimatedPan(center, options.pan);

        if (moved) {
          // prevent resize handler call, the view will refresh after animation anyway
          clearTimeout(this._sizeTimer);
          return this;
        }
      } // animation didn't start, just reset the map view


      this._resetView(center, zoom);

      return this;
    },
    // @method setZoom(zoom: Number, options?: Zoom/pan options): this
    // Sets the zoom of the map.
    setZoom: function (zoom, options) {
      if (!this._loaded) {
        this._zoom = zoom;
        return this;
      }

      return this.setView(this.getCenter(), zoom, {
        zoom: options
      });
    },
    // @method zoomIn(delta?: Number, options?: Zoom options): this
    // Increases the zoom of the map by `delta` ([`zoomDelta`](#map-zoomdelta) by default).
    zoomIn: function (delta, options) {
      delta = delta || (any3d ? this.options.zoomDelta : 1);
      return this.setZoom(this._zoom + delta, options);
    },
    // @method zoomOut(delta?: Number, options?: Zoom options): this
    // Decreases the zoom of the map by `delta` ([`zoomDelta`](#map-zoomdelta) by default).
    zoomOut: function (delta, options) {
      delta = delta || (any3d ? this.options.zoomDelta : 1);
      return this.setZoom(this._zoom - delta, options);
    },
    // @method setZoomAround(latlng: LatLng, zoom: Number, options: Zoom options): this
    // Zooms the map while keeping a specified geographical point on the map
    // stationary (e.g. used internally for scroll zoom and double-click zoom).
    // @alternative
    // @method setZoomAround(offset: Point, zoom: Number, options: Zoom options): this
    // Zooms the map while keeping a specified pixel on the map (relative to the top-left corner) stationary.
    setZoomAround: function (latlng, zoom, options) {
      var scale = this.getZoomScale(zoom),
          viewHalf = this.getSize().divideBy(2),
          containerPoint = latlng instanceof Point ? latlng : this.latLngToContainerPoint(latlng),
          centerOffset = containerPoint.subtract(viewHalf).multiplyBy(1 - 1 / scale),
          newCenter = this.containerPointToLatLng(viewHalf.add(centerOffset));
      return this.setView(newCenter, zoom, {
        zoom: options
      });
    },
    _getBoundsCenterZoom: function (bounds, options) {
      options = options || {};
      bounds = bounds.getBounds ? bounds.getBounds() : toLatLngBounds(bounds);
      var paddingTL = toPoint(options.paddingTopLeft || options.padding || [0, 0]),
          paddingBR = toPoint(options.paddingBottomRight || options.padding || [0, 0]),
          zoom = this.getBoundsZoom(bounds, false, paddingTL.add(paddingBR));
      zoom = typeof options.maxZoom === 'number' ? Math.min(options.maxZoom, zoom) : zoom;

      if (zoom === Infinity) {
        return {
          center: bounds.getCenter(),
          zoom: zoom
        };
      }

      var paddingOffset = paddingBR.subtract(paddingTL).divideBy(2),
          swPoint = this.project(bounds.getSouthWest(), zoom),
          nePoint = this.project(bounds.getNorthEast(), zoom),
          center = this.unproject(swPoint.add(nePoint).divideBy(2).add(paddingOffset), zoom);
      return {
        center: center,
        zoom: zoom
      };
    },
    // @method fitBounds(bounds: LatLngBounds, options?: fitBounds options): this
    // Sets a map view that contains the given geographical bounds with the
    // maximum zoom level possible.
    fitBounds: function (bounds, options) {
      bounds = toLatLngBounds(bounds);

      if (!bounds.isValid()) {
        throw new Error('Bounds are not valid.');
      }

      var target = this._getBoundsCenterZoom(bounds, options);

      return this.setView(target.center, target.zoom, options);
    },
    // @method fitWorld(options?: fitBounds options): this
    // Sets a map view that mostly contains the whole world with the maximum
    // zoom level possible.
    fitWorld: function (options) {
      return this.fitBounds([[-90, -180], [90, 180]], options);
    },
    // @method panTo(latlng: LatLng, options?: Pan options): this
    // Pans the map to a given center.
    panTo: function (center, options) {
      // (LatLng)
      return this.setView(center, this._zoom, {
        pan: options
      });
    },
    // @method panBy(offset: Point, options?: Pan options): this
    // Pans the map by a given number of pixels (animated).
    panBy: function (offset, options) {
      offset = toPoint(offset).round();
      options = options || {};

      if (!offset.x && !offset.y) {
        return this.fire('moveend');
      } // If we pan too far, Chrome gets issues with tiles
      // and makes them disappear or appear in the wrong place (slightly offset) #2602


      if (options.animate !== true && !this.getSize().contains(offset)) {
        this._resetView(this.unproject(this.project(this.getCenter()).add(offset)), this.getZoom());

        return this;
      }

      if (!this._panAnim) {
        this._panAnim = new PosAnimation();

        this._panAnim.on({
          'step': this._onPanTransitionStep,
          'end': this._onPanTransitionEnd
        }, this);
      } // don't fire movestart if animating inertia


      if (!options.noMoveStart) {
        this.fire('movestart');
      } // animate pan unless animate: false specified


      if (options.animate !== false) {
        addClass(this._mapPane, 'leaflet-pan-anim');

        var newPos = this._getMapPanePos().subtract(offset).round();

        this._panAnim.run(this._mapPane, newPos, options.duration || 0.25, options.easeLinearity);
      } else {
        this._rawPanBy(offset);

        this.fire('move').fire('moveend');
      }

      return this;
    },
    // @method flyTo(latlng: LatLng, zoom?: Number, options?: Zoom/pan options): this
    // Sets the view of the map (geographical center and zoom) performing a smooth
    // pan-zoom animation.
    flyTo: function (targetCenter, targetZoom, options) {
      options = options || {};

      if (options.animate === false || !any3d) {
        return this.setView(targetCenter, targetZoom, options);
      }

      this._stop();

      var from = this.project(this.getCenter()),
          to = this.project(targetCenter),
          size = this.getSize(),
          startZoom = this._zoom;
      targetCenter = toLatLng(targetCenter);
      targetZoom = targetZoom === undefined ? startZoom : targetZoom;
      var w0 = Math.max(size.x, size.y),
          w1 = w0 * this.getZoomScale(startZoom, targetZoom),
          u1 = to.distanceTo(from) || 1,
          rho = 1.42,
          rho2 = rho * rho;

      function r(i) {
        var s1 = i ? -1 : 1,
            s2 = i ? w1 : w0,
            t1 = w1 * w1 - w0 * w0 + s1 * rho2 * rho2 * u1 * u1,
            b1 = 2 * s2 * rho2 * u1,
            b = t1 / b1,
            sq = Math.sqrt(b * b + 1) - b; // workaround for floating point precision bug when sq = 0, log = -Infinite,
        // thus triggering an infinite loop in flyTo

        var log = sq < 0.000000001 ? -18 : Math.log(sq);
        return log;
      }

      function sinh(n) {
        return (Math.exp(n) - Math.exp(-n)) / 2;
      }

      function cosh(n) {
        return (Math.exp(n) + Math.exp(-n)) / 2;
      }

      function tanh(n) {
        return sinh(n) / cosh(n);
      }

      var r0 = r(0);

      function w(s) {
        return w0 * (cosh(r0) / cosh(r0 + rho * s));
      }

      function u(s) {
        return w0 * (cosh(r0) * tanh(r0 + rho * s) - sinh(r0)) / rho2;
      }

      function easeOut(t) {
        return 1 - Math.pow(1 - t, 1.5);
      }

      var start = Date.now(),
          S = (r(1) - r0) / rho,
          duration = options.duration ? 1000 * options.duration : 1000 * S * 0.8;

      function frame() {
        var t = (Date.now() - start) / duration,
            s = easeOut(t) * S;

        if (t <= 1) {
          this._flyToFrame = requestAnimFrame(frame, this);

          this._move(this.unproject(from.add(to.subtract(from).multiplyBy(u(s) / u1)), startZoom), this.getScaleZoom(w0 / w(s), startZoom), {
            flyTo: true
          });
        } else {
          this._move(targetCenter, targetZoom)._moveEnd(true);
        }
      }

      this._moveStart(true, options.noMoveStart);

      frame.call(this);
      return this;
    },
    // @method flyToBounds(bounds: LatLngBounds, options?: fitBounds options): this
    // Sets the view of the map with a smooth animation like [`flyTo`](#map-flyto),
    // but takes a bounds parameter like [`fitBounds`](#map-fitbounds).
    flyToBounds: function (bounds, options) {
      var target = this._getBoundsCenterZoom(bounds, options);

      return this.flyTo(target.center, target.zoom, options);
    },
    // @method setMaxBounds(bounds: Bounds): this
    // Restricts the map view to the given bounds (see the [maxBounds](#map-maxbounds) option).
    setMaxBounds: function (bounds) {
      bounds = toLatLngBounds(bounds);

      if (!bounds.isValid()) {
        this.options.maxBounds = null;
        return this.off('moveend', this._panInsideMaxBounds);
      } else if (this.options.maxBounds) {
        this.off('moveend', this._panInsideMaxBounds);
      }

      this.options.maxBounds = bounds;

      if (this._loaded) {
        this._panInsideMaxBounds();
      }

      return this.on('moveend', this._panInsideMaxBounds);
    },
    // @method setMinZoom(zoom: Number): this
    // Sets the lower limit for the available zoom levels (see the [minZoom](#map-minzoom) option).
    setMinZoom: function (zoom) {
      var oldZoom = this.options.minZoom;
      this.options.minZoom = zoom;

      if (this._loaded && oldZoom !== zoom) {
        this.fire('zoomlevelschange');

        if (this.getZoom() < this.options.minZoom) {
          return this.setZoom(zoom);
        }
      }

      return this;
    },
    // @method setMaxZoom(zoom: Number): this
    // Sets the upper limit for the available zoom levels (see the [maxZoom](#map-maxzoom) option).
    setMaxZoom: function (zoom) {
      var oldZoom = this.options.maxZoom;
      this.options.maxZoom = zoom;

      if (this._loaded && oldZoom !== zoom) {
        this.fire('zoomlevelschange');

        if (this.getZoom() > this.options.maxZoom) {
          return this.setZoom(zoom);
        }
      }

      return this;
    },
    // @method panInsideBounds(bounds: LatLngBounds, options?: Pan options): this
    // Pans the map to the closest view that would lie inside the given bounds (if it's not already), controlling the animation using the options specific, if any.
    panInsideBounds: function (bounds, options) {
      this._enforcingBounds = true;

      var center = this.getCenter(),
          newCenter = this._limitCenter(center, this._zoom, toLatLngBounds(bounds));

      if (!center.equals(newCenter)) {
        this.panTo(newCenter, options);
      }

      this._enforcingBounds = false;
      return this;
    },
    // @method panInside(latlng: LatLng, options?: options): this
    // Pans the map the minimum amount to make the `latlng` visible. Use
    // `padding`, `paddingTopLeft` and `paddingTopRight` options to fit
    // the display to more restricted bounds, like [`fitBounds`](#map-fitbounds).
    // If `latlng` is already within the (optionally padded) display bounds,
    // the map will not be panned.
    panInside: function (latlng, options) {
      options = options || {};
      var paddingTL = toPoint(options.paddingTopLeft || options.padding || [0, 0]),
          paddingBR = toPoint(options.paddingBottomRight || options.padding || [0, 0]),
          center = this.getCenter(),
          pixelCenter = this.project(center),
          pixelPoint = this.project(latlng),
          pixelBounds = this.getPixelBounds(),
          halfPixelBounds = pixelBounds.getSize().divideBy(2),
          paddedBounds = toBounds([pixelBounds.min.add(paddingTL), pixelBounds.max.subtract(paddingBR)]);

      if (!paddedBounds.contains(pixelPoint)) {
        this._enforcingBounds = true;
        var diff = pixelCenter.subtract(pixelPoint),
            newCenter = toPoint(pixelPoint.x + diff.x, pixelPoint.y + diff.y);

        if (pixelPoint.x < paddedBounds.min.x || pixelPoint.x > paddedBounds.max.x) {
          newCenter.x = pixelCenter.x - diff.x;

          if (diff.x > 0) {
            newCenter.x += halfPixelBounds.x - paddingTL.x;
          } else {
            newCenter.x -= halfPixelBounds.x - paddingBR.x;
          }
        }

        if (pixelPoint.y < paddedBounds.min.y || pixelPoint.y > paddedBounds.max.y) {
          newCenter.y = pixelCenter.y - diff.y;

          if (diff.y > 0) {
            newCenter.y += halfPixelBounds.y - paddingTL.y;
          } else {
            newCenter.y -= halfPixelBounds.y - paddingBR.y;
          }
        }

        this.panTo(this.unproject(newCenter), options);
        this._enforcingBounds = false;
      }

      return this;
    },
    // @method invalidateSize(options: Zoom/pan options): this
    // Checks if the map container size changed and updates the map if so —
    // call it after you've changed the map size dynamically, also animating
    // pan by default. If `options.pan` is `false`, panning will not occur.
    // If `options.debounceMoveend` is `true`, it will delay `moveend` event so
    // that it doesn't happen often even if the method is called many
    // times in a row.
    // @alternative
    // @method invalidateSize(animate: Boolean): this
    // Checks if the map container size changed and updates the map if so —
    // call it after you've changed the map size dynamically, also animating
    // pan by default.
    invalidateSize: function (options) {
      if (!this._loaded) {
        return this;
      }

      options = extend({
        animate: false,
        pan: true
      }, options === true ? {
        animate: true
      } : options);
      var oldSize = this.getSize();
      this._sizeChanged = true;
      this._lastCenter = null;
      var newSize = this.getSize(),
          oldCenter = oldSize.divideBy(2).round(),
          newCenter = newSize.divideBy(2).round(),
          offset = oldCenter.subtract(newCenter);

      if (!offset.x && !offset.y) {
        return this;
      }

      if (options.animate && options.pan) {
        this.panBy(offset);
      } else {
        if (options.pan) {
          this._rawPanBy(offset);
        }

        this.fire('move');

        if (options.debounceMoveend) {
          clearTimeout(this._sizeTimer);
          this._sizeTimer = setTimeout(bind(this.fire, this, 'moveend'), 200);
        } else {
          this.fire('moveend');
        }
      } // @section Map state change events
      // @event resize: ResizeEvent
      // Fired when the map is resized.


      return this.fire('resize', {
        oldSize: oldSize,
        newSize: newSize
      });
    },
    // @section Methods for modifying map state
    // @method stop(): this
    // Stops the currently running `panTo` or `flyTo` animation, if any.
    stop: function () {
      this.setZoom(this._limitZoom(this._zoom));

      if (!this.options.zoomSnap) {
        this.fire('viewreset');
      }

      return this._stop();
    },
    // @section Geolocation methods
    // @method locate(options?: Locate options): this
    // Tries to locate the user using the Geolocation API, firing a [`locationfound`](#map-locationfound)
    // event with location data on success or a [`locationerror`](#map-locationerror) event on failure,
    // and optionally sets the map view to the user's location with respect to
    // detection accuracy (or to the world view if geolocation failed).
    // Note that, if your page doesn't use HTTPS, this method will fail in
    // modern browsers ([Chrome 50 and newer](https://sites.google.com/a/chromium.org/dev/Home/chromium-security/deprecating-powerful-features-on-insecure-origins))
    // See `Locate options` for more details.
    locate: function (options) {
      options = this._locateOptions = extend({
        timeout: 10000,
        watch: false // setView: false
        // maxZoom: <Number>
        // maximumAge: 0
        // enableHighAccuracy: false

      }, options);

      if (!('geolocation' in navigator)) {
        this._handleGeolocationError({
          code: 0,
          message: 'Geolocation not supported.'
        });

        return this;
      }

      var onResponse = bind(this._handleGeolocationResponse, this),
          onError = bind(this._handleGeolocationError, this);

      if (options.watch) {
        this._locationWatchId = navigator.geolocation.watchPosition(onResponse, onError, options);
      } else {
        navigator.geolocation.getCurrentPosition(onResponse, onError, options);
      }

      return this;
    },
    // @method stopLocate(): this
    // Stops watching location previously initiated by `map.locate({watch: true})`
    // and aborts resetting the map view if map.locate was called with
    // `{setView: true}`.
    stopLocate: function () {
      if (navigator.geolocation && navigator.geolocation.clearWatch) {
        navigator.geolocation.clearWatch(this._locationWatchId);
      }

      if (this._locateOptions) {
        this._locateOptions.setView = false;
      }

      return this;
    },
    _handleGeolocationError: function (error) {
      var c = error.code,
          message = error.message || (c === 1 ? 'permission denied' : c === 2 ? 'position unavailable' : 'timeout');

      if (this._locateOptions.setView && !this._loaded) {
        this.fitWorld();
      } // @section Location events
      // @event locationerror: ErrorEvent
      // Fired when geolocation (using the [`locate`](#map-locate) method) failed.


      this.fire('locationerror', {
        code: c,
        message: 'Geolocation error: ' + message + '.'
      });
    },
    _handleGeolocationResponse: function (pos) {
      var lat = pos.coords.latitude,
          lng = pos.coords.longitude,
          latlng = new LatLng(lat, lng),
          bounds = latlng.toBounds(pos.coords.accuracy * 2),
          options = this._locateOptions;

      if (options.setView) {
        var zoom = this.getBoundsZoom(bounds);
        this.setView(latlng, options.maxZoom ? Math.min(zoom, options.maxZoom) : zoom);
      }

      var data = {
        latlng: latlng,
        bounds: bounds,
        timestamp: pos.timestamp
      };

      for (var i in pos.coords) {
        if (typeof pos.coords[i] === 'number') {
          data[i] = pos.coords[i];
        }
      } // @event locationfound: LocationEvent
      // Fired when geolocation (using the [`locate`](#map-locate) method)
      // went successfully.


      this.fire('locationfound', data);
    },
    // TODO Appropriate docs section?
    // @section Other Methods
    // @method addHandler(name: String, HandlerClass: Function): this
    // Adds a new `Handler` to the map, given its name and constructor function.
    addHandler: function (name, HandlerClass) {
      if (!HandlerClass) {
        return this;
      }

      var handler = this[name] = new HandlerClass(this);

      this._handlers.push(handler);

      if (this.options[name]) {
        handler.enable();
      }

      return this;
    },
    // @method remove(): this
    // Destroys the map and clears all related event listeners.
    remove: function () {
      this._initEvents(true);

      if (this._containerId !== this._container._leaflet_id) {
        throw new Error('Map container is being reused by another instance');
      }

      try {
        // throws error in IE6-8
        delete this._container._leaflet_id;
        delete this._containerId;
      } catch (e) {
        /*eslint-disable */
        this._container._leaflet_id = undefined;
        /* eslint-enable */

        this._containerId = undefined;
      }

      if (this._locationWatchId !== undefined) {
        this.stopLocate();
      }

      this._stop();

      remove(this._mapPane);

      if (this._clearControlPos) {
        this._clearControlPos();
      }

      if (this._resizeRequest) {
        cancelAnimFrame(this._resizeRequest);
        this._resizeRequest = null;
      }

      this._clearHandlers();

      if (this._loaded) {
        // @section Map state change events
        // @event unload: Event
        // Fired when the map is destroyed with [remove](#map-remove) method.
        this.fire('unload');
      }

      var i;

      for (i in this._layers) {
        this._layers[i].remove();
      }

      for (i in this._panes) {
        remove(this._panes[i]);
      }

      this._layers = [];
      this._panes = [];
      delete this._mapPane;
      delete this._renderer;
      return this;
    },
    // @section Other Methods
    // @method createPane(name: String, container?: HTMLElement): HTMLElement
    // Creates a new [map pane](#map-pane) with the given name if it doesn't exist already,
    // then returns it. The pane is created as a child of `container`, or
    // as a child of the main map pane if not set.
    createPane: function (name, container) {
      var className = 'leaflet-pane' + (name ? ' leaflet-' + name.replace('Pane', '') + '-pane' : ''),
          pane = create$1('div', className, container || this._mapPane);

      if (name) {
        this._panes[name] = pane;
      }

      return pane;
    },
    // @section Methods for Getting Map State
    // @method getCenter(): LatLng
    // Returns the geographical center of the map view
    getCenter: function () {
      this._checkIfLoaded();

      if (this._lastCenter && !this._moved()) {
        return this._lastCenter;
      }

      return this.layerPointToLatLng(this._getCenterLayerPoint());
    },
    // @method getZoom(): Number
    // Returns the current zoom level of the map view
    getZoom: function () {
      return this._zoom;
    },
    // @method getBounds(): LatLngBounds
    // Returns the geographical bounds visible in the current map view
    getBounds: function () {
      var bounds = this.getPixelBounds(),
          sw = this.unproject(bounds.getBottomLeft()),
          ne = this.unproject(bounds.getTopRight());
      return new LatLngBounds(sw, ne);
    },
    // @method getMinZoom(): Number
    // Returns the minimum zoom level of the map (if set in the `minZoom` option of the map or of any layers), or `0` by default.
    getMinZoom: function () {
      return this.options.minZoom === undefined ? this._layersMinZoom || 0 : this.options.minZoom;
    },
    // @method getMaxZoom(): Number
    // Returns the maximum zoom level of the map (if set in the `maxZoom` option of the map or of any layers).
    getMaxZoom: function () {
      return this.options.maxZoom === undefined ? this._layersMaxZoom === undefined ? Infinity : this._layersMaxZoom : this.options.maxZoom;
    },
    // @method getBoundsZoom(bounds: LatLngBounds, inside?: Boolean, padding?: Point): Number
    // Returns the maximum zoom level on which the given bounds fit to the map
    // view in its entirety. If `inside` (optional) is set to `true`, the method
    // instead returns the minimum zoom level on which the map view fits into
    // the given bounds in its entirety.
    getBoundsZoom: function (bounds, inside, padding) {
      // (LatLngBounds[, Boolean, Point]) -> Number
      bounds = toLatLngBounds(bounds);
      padding = toPoint(padding || [0, 0]);
      var zoom = this.getZoom() || 0,
          min = this.getMinZoom(),
          max = this.getMaxZoom(),
          nw = bounds.getNorthWest(),
          se = bounds.getSouthEast(),
          size = this.getSize().subtract(padding),
          boundsSize = toBounds(this.project(se, zoom), this.project(nw, zoom)).getSize(),
          snap = any3d ? this.options.zoomSnap : 1,
          scalex = size.x / boundsSize.x,
          scaley = size.y / boundsSize.y,
          scale = inside ? Math.max(scalex, scaley) : Math.min(scalex, scaley);
      zoom = this.getScaleZoom(scale, zoom);

      if (snap) {
        zoom = Math.round(zoom / (snap / 100)) * (snap / 100); // don't jump if within 1% of a snap level

        zoom = inside ? Math.ceil(zoom / snap) * snap : Math.floor(zoom / snap) * snap;
      }

      return Math.max(min, Math.min(max, zoom));
    },
    // @method getSize(): Point
    // Returns the current size of the map container (in pixels).
    getSize: function () {
      if (!this._size || this._sizeChanged) {
        this._size = new Point(this._container.clientWidth || 0, this._container.clientHeight || 0);
        this._sizeChanged = false;
      }

      return this._size.clone();
    },
    // @method getPixelBounds(): Bounds
    // Returns the bounds of the current map view in projected pixel
    // coordinates (sometimes useful in layer and overlay implementations).
    getPixelBounds: function (center, zoom) {
      var topLeftPoint = this._getTopLeftPoint(center, zoom);

      return new Bounds(topLeftPoint, topLeftPoint.add(this.getSize()));
    },
    // TODO: Check semantics - isn't the pixel origin the 0,0 coord relative to
    // the map pane? "left point of the map layer" can be confusing, specially
    // since there can be negative offsets.
    // @method getPixelOrigin(): Point
    // Returns the projected pixel coordinates of the top left point of
    // the map layer (useful in custom layer and overlay implementations).
    getPixelOrigin: function () {
      this._checkIfLoaded();

      return this._pixelOrigin;
    },
    // @method getPixelWorldBounds(zoom?: Number): Bounds
    // Returns the world's bounds in pixel coordinates for zoom level `zoom`.
    // If `zoom` is omitted, the map's current zoom level is used.
    getPixelWorldBounds: function (zoom) {
      return this.options.crs.getProjectedBounds(zoom === undefined ? this.getZoom() : zoom);
    },
    // @section Other Methods
    // @method getPane(pane: String|HTMLElement): HTMLElement
    // Returns a [map pane](#map-pane), given its name or its HTML element (its identity).
    getPane: function (pane) {
      return typeof pane === 'string' ? this._panes[pane] : pane;
    },
    // @method getPanes(): Object
    // Returns a plain object containing the names of all [panes](#map-pane) as keys and
    // the panes as values.
    getPanes: function () {
      return this._panes;
    },
    // @method getContainer: HTMLElement
    // Returns the HTML element that contains the map.
    getContainer: function () {
      return this._container;
    },
    // @section Conversion Methods
    // @method getZoomScale(toZoom: Number, fromZoom: Number): Number
    // Returns the scale factor to be applied to a map transition from zoom level
    // `fromZoom` to `toZoom`. Used internally to help with zoom animations.
    getZoomScale: function (toZoom, fromZoom) {
      // TODO replace with universal implementation after refactoring projections
      var crs = this.options.crs;
      fromZoom = fromZoom === undefined ? this._zoom : fromZoom;
      return crs.scale(toZoom) / crs.scale(fromZoom);
    },
    // @method getScaleZoom(scale: Number, fromZoom: Number): Number
    // Returns the zoom level that the map would end up at, if it is at `fromZoom`
    // level and everything is scaled by a factor of `scale`. Inverse of
    // [`getZoomScale`](#map-getZoomScale).
    getScaleZoom: function (scale, fromZoom) {
      var crs = this.options.crs;
      fromZoom = fromZoom === undefined ? this._zoom : fromZoom;
      var zoom = crs.zoom(scale * crs.scale(fromZoom));
      return isNaN(zoom) ? Infinity : zoom;
    },
    // @method project(latlng: LatLng, zoom: Number): Point
    // Projects a geographical coordinate `LatLng` according to the projection
    // of the map's CRS, then scales it according to `zoom` and the CRS's
    // `Transformation`. The result is pixel coordinate relative to
    // the CRS origin.
    project: function (latlng, zoom) {
      zoom = zoom === undefined ? this._zoom : zoom;
      return this.options.crs.latLngToPoint(toLatLng(latlng), zoom);
    },
    // @method unproject(point: Point, zoom: Number): LatLng
    // Inverse of [`project`](#map-project).
    unproject: function (point, zoom) {
      zoom = zoom === undefined ? this._zoom : zoom;
      return this.options.crs.pointToLatLng(toPoint(point), zoom);
    },
    // @method layerPointToLatLng(point: Point): LatLng
    // Given a pixel coordinate relative to the [origin pixel](#map-getpixelorigin),
    // returns the corresponding geographical coordinate (for the current zoom level).
    layerPointToLatLng: function (point) {
      var projectedPoint = toPoint(point).add(this.getPixelOrigin());
      return this.unproject(projectedPoint);
    },
    // @method latLngToLayerPoint(latlng: LatLng): Point
    // Given a geographical coordinate, returns the corresponding pixel coordinate
    // relative to the [origin pixel](#map-getpixelorigin).
    latLngToLayerPoint: function (latlng) {
      var projectedPoint = this.project(toLatLng(latlng))._round();

      return projectedPoint._subtract(this.getPixelOrigin());
    },
    // @method wrapLatLng(latlng: LatLng): LatLng
    // Returns a `LatLng` where `lat` and `lng` has been wrapped according to the
    // map's CRS's `wrapLat` and `wrapLng` properties, if they are outside the
    // CRS's bounds.
    // By default this means longitude is wrapped around the dateline so its
    // value is between -180 and +180 degrees.
    wrapLatLng: function (latlng) {
      return this.options.crs.wrapLatLng(toLatLng(latlng));
    },
    // @method wrapLatLngBounds(bounds: LatLngBounds): LatLngBounds
    // Returns a `LatLngBounds` with the same size as the given one, ensuring that
    // its center is within the CRS's bounds.
    // By default this means the center longitude is wrapped around the dateline so its
    // value is between -180 and +180 degrees, and the majority of the bounds
    // overlaps the CRS's bounds.
    wrapLatLngBounds: function (latlng) {
      return this.options.crs.wrapLatLngBounds(toLatLngBounds(latlng));
    },
    // @method distance(latlng1: LatLng, latlng2: LatLng): Number
    // Returns the distance between two geographical coordinates according to
    // the map's CRS. By default this measures distance in meters.
    distance: function (latlng1, latlng2) {
      return this.options.crs.distance(toLatLng(latlng1), toLatLng(latlng2));
    },
    // @method containerPointToLayerPoint(point: Point): Point
    // Given a pixel coordinate relative to the map container, returns the corresponding
    // pixel coordinate relative to the [origin pixel](#map-getpixelorigin).
    containerPointToLayerPoint: function (point) {
      // (Point)
      return toPoint(point).subtract(this._getMapPanePos());
    },
    // @method layerPointToContainerPoint(point: Point): Point
    // Given a pixel coordinate relative to the [origin pixel](#map-getpixelorigin),
    // returns the corresponding pixel coordinate relative to the map container.
    layerPointToContainerPoint: function (point) {
      // (Point)
      return toPoint(point).add(this._getMapPanePos());
    },
    // @method containerPointToLatLng(point: Point): LatLng
    // Given a pixel coordinate relative to the map container, returns
    // the corresponding geographical coordinate (for the current zoom level).
    containerPointToLatLng: function (point) {
      var layerPoint = this.containerPointToLayerPoint(toPoint(point));
      return this.layerPointToLatLng(layerPoint);
    },
    // @method latLngToContainerPoint(latlng: LatLng): Point
    // Given a geographical coordinate, returns the corresponding pixel coordinate
    // relative to the map container.
    latLngToContainerPoint: function (latlng) {
      return this.layerPointToContainerPoint(this.latLngToLayerPoint(toLatLng(latlng)));
    },
    // @method mouseEventToContainerPoint(ev: MouseEvent): Point
    // Given a MouseEvent object, returns the pixel coordinate relative to the
    // map container where the event took place.
    mouseEventToContainerPoint: function (e) {
      return getMousePosition(e, this._container);
    },
    // @method mouseEventToLayerPoint(ev: MouseEvent): Point
    // Given a MouseEvent object, returns the pixel coordinate relative to
    // the [origin pixel](#map-getpixelorigin) where the event took place.
    mouseEventToLayerPoint: function (e) {
      return this.containerPointToLayerPoint(this.mouseEventToContainerPoint(e));
    },
    // @method mouseEventToLatLng(ev: MouseEvent): LatLng
    // Given a MouseEvent object, returns geographical coordinate where the
    // event took place.
    mouseEventToLatLng: function (e) {
      // (MouseEvent)
      return this.layerPointToLatLng(this.mouseEventToLayerPoint(e));
    },
    // map initialization methods
    _initContainer: function (id) {
      var container = this._container = get(id);

      if (!container) {
        throw new Error('Map container not found.');
      } else if (container._leaflet_id) {
        throw new Error('Map container is already initialized.');
      }

      on(container, 'scroll', this._onScroll, this);
      this._containerId = stamp(container);
    },
    _initLayout: function () {
      var container = this._container;
      this._fadeAnimated = this.options.fadeAnimation && any3d;
      addClass(container, 'leaflet-container' + (touch ? ' leaflet-touch' : '') + (retina ? ' leaflet-retina' : '') + (ielt9 ? ' leaflet-oldie' : '') + (safari ? ' leaflet-safari' : '') + (this._fadeAnimated ? ' leaflet-fade-anim' : ''));
      var position = getStyle(container, 'position');

      if (position !== 'absolute' && position !== 'relative' && position !== 'fixed') {
        container.style.position = 'relative';
      }

      this._initPanes();

      if (this._initControlPos) {
        this._initControlPos();
      }
    },
    _initPanes: function () {
      var panes = this._panes = {};
      this._paneRenderers = {}; // @section
      //
      // Panes are DOM elements used to control the ordering of layers on the map. You
      // can access panes with [`map.getPane`](#map-getpane) or
      // [`map.getPanes`](#map-getpanes) methods. New panes can be created with the
      // [`map.createPane`](#map-createpane) method.
      //
      // Every map has the following default panes that differ only in zIndex.
      //
      // @pane mapPane: HTMLElement = 'auto'
      // Pane that contains all other map panes

      this._mapPane = this.createPane('mapPane', this._container);
      setPosition(this._mapPane, new Point(0, 0)); // @pane tilePane: HTMLElement = 200
      // Pane for `GridLayer`s and `TileLayer`s

      this.createPane('tilePane'); // @pane overlayPane: HTMLElement = 400
      // Pane for vectors (`Path`s, like `Polyline`s and `Polygon`s), `ImageOverlay`s and `VideoOverlay`s

      this.createPane('shadowPane'); // @pane shadowPane: HTMLElement = 500
      // Pane for overlay shadows (e.g. `Marker` shadows)

      this.createPane('overlayPane'); // @pane markerPane: HTMLElement = 600
      // Pane for `Icon`s of `Marker`s

      this.createPane('markerPane'); // @pane tooltipPane: HTMLElement = 650
      // Pane for `Tooltip`s.

      this.createPane('tooltipPane'); // @pane popupPane: HTMLElement = 700
      // Pane for `Popup`s.

      this.createPane('popupPane');

      if (!this.options.markerZoomAnimation) {
        addClass(panes.markerPane, 'leaflet-zoom-hide');
        addClass(panes.shadowPane, 'leaflet-zoom-hide');
      }
    },
    // private methods that modify map state
    // @section Map state change events
    _resetView: function (center, zoom) {
      setPosition(this._mapPane, new Point(0, 0));
      var loading = !this._loaded;
      this._loaded = true;
      zoom = this._limitZoom(zoom);
      this.fire('viewprereset');
      var zoomChanged = this._zoom !== zoom;

      this._moveStart(zoomChanged, false)._move(center, zoom)._moveEnd(zoomChanged); // @event viewreset: Event
      // Fired when the map needs to redraw its content (this usually happens
      // on map zoom or load). Very useful for creating custom overlays.


      this.fire('viewreset'); // @event load: Event
      // Fired when the map is initialized (when its center and zoom are set
      // for the first time).

      if (loading) {
        this.fire('load');
      }
    },
    _moveStart: function (zoomChanged, noMoveStart) {
      // @event zoomstart: Event
      // Fired when the map zoom is about to change (e.g. before zoom animation).
      // @event movestart: Event
      // Fired when the view of the map starts changing (e.g. user starts dragging the map).
      if (zoomChanged) {
        this.fire('zoomstart');
      }

      if (!noMoveStart) {
        this.fire('movestart');
      }

      return this;
    },
    _move: function (center, zoom, data) {
      if (zoom === undefined) {
        zoom = this._zoom;
      }

      var zoomChanged = this._zoom !== zoom;
      this._zoom = zoom;
      this._lastCenter = center;
      this._pixelOrigin = this._getNewPixelOrigin(center); // @event zoom: Event
      // Fired repeatedly during any change in zoom level, including zoom
      // and fly animations.

      if (zoomChanged || data && data.pinch) {
        // Always fire 'zoom' if pinching because #3530
        this.fire('zoom', data);
      } // @event move: Event
      // Fired repeatedly during any movement of the map, including pan and
      // fly animations.


      return this.fire('move', data);
    },
    _moveEnd: function (zoomChanged) {
      // @event zoomend: Event
      // Fired when the map has changed, after any animations.
      if (zoomChanged) {
        this.fire('zoomend');
      } // @event moveend: Event
      // Fired when the center of the map stops changing (e.g. user stopped
      // dragging the map).


      return this.fire('moveend');
    },
    _stop: function () {
      cancelAnimFrame(this._flyToFrame);

      if (this._panAnim) {
        this._panAnim.stop();
      }

      return this;
    },
    _rawPanBy: function (offset) {
      setPosition(this._mapPane, this._getMapPanePos().subtract(offset));
    },
    _getZoomSpan: function () {
      return this.getMaxZoom() - this.getMinZoom();
    },
    _panInsideMaxBounds: function () {
      if (!this._enforcingBounds) {
        this.panInsideBounds(this.options.maxBounds);
      }
    },
    _checkIfLoaded: function () {
      if (!this._loaded) {
        throw new Error('Set map center and zoom first.');
      }
    },
    // DOM event handling
    // @section Interaction events
    _initEvents: function (remove$$1) {
      this._targets = {};
      this._targets[stamp(this._container)] = this;
      var onOff = remove$$1 ? off : on; // @event click: MouseEvent
      // Fired when the user clicks (or taps) the map.
      // @event dblclick: MouseEvent
      // Fired when the user double-clicks (or double-taps) the map.
      // @event mousedown: MouseEvent
      // Fired when the user pushes the mouse button on the map.
      // @event mouseup: MouseEvent
      // Fired when the user releases the mouse button on the map.
      // @event mouseover: MouseEvent
      // Fired when the mouse enters the map.
      // @event mouseout: MouseEvent
      // Fired when the mouse leaves the map.
      // @event mousemove: MouseEvent
      // Fired while the mouse moves over the map.
      // @event contextmenu: MouseEvent
      // Fired when the user pushes the right mouse button on the map, prevents
      // default browser context menu from showing if there are listeners on
      // this event. Also fired on mobile when the user holds a single touch
      // for a second (also called long press).
      // @event keypress: KeyboardEvent
      // Fired when the user presses a key from the keyboard while the map is focused.

      onOff(this._container, 'click dblclick mousedown mouseup ' + 'mouseover mouseout mousemove contextmenu keypress', this._handleDOMEvent, this);

      if (this.options.trackResize) {
        onOff(window, 'resize', this._onResize, this);
      }

      if (any3d && this.options.transform3DLimit) {
        (remove$$1 ? this.off : this.on).call(this, 'moveend', this._onMoveEnd);
      }
    },
    _onResize: function () {
      cancelAnimFrame(this._resizeRequest);
      this._resizeRequest = requestAnimFrame(function () {
        this.invalidateSize({
          debounceMoveend: true
        });
      }, this);
    },
    _onScroll: function () {
      this._container.scrollTop = 0;
      this._container.scrollLeft = 0;
    },
    _onMoveEnd: function () {
      var pos = this._getMapPanePos();

      if (Math.max(Math.abs(pos.x), Math.abs(pos.y)) >= this.options.transform3DLimit) {
        // https://bugzilla.mozilla.org/show_bug.cgi?id=1203873 but Webkit also have
        // a pixel offset on very high values, see: http://jsfiddle.net/dg6r5hhb/
        this._resetView(this.getCenter(), this.getZoom());
      }
    },
    _findEventTargets: function (e, type) {
      var targets = [],
          target,
          isHover = type === 'mouseout' || type === 'mouseover',
          src = e.target || e.srcElement,
          dragging = false;

      while (src) {
        target = this._targets[stamp(src)];

        if (target && (type === 'click' || type === 'preclick') && !e._simulated && this._draggableMoved(target)) {
          // Prevent firing click after you just dragged an object.
          dragging = true;
          break;
        }

        if (target && target.listens(type, true)) {
          if (isHover && !isExternalTarget(src, e)) {
            break;
          }

          targets.push(target);

          if (isHover) {
            break;
          }
        }

        if (src === this._container) {
          break;
        }

        src = src.parentNode;
      }

      if (!targets.length && !dragging && !isHover && isExternalTarget(src, e)) {
        targets = [this];
      }

      return targets;
    },
    _handleDOMEvent: function (e) {
      if (!this._loaded || skipped(e)) {
        return;
      }

      var type = e.type;

      if (type === 'mousedown' || type === 'keypress') {
        // prevents outline when clicking on keyboard-focusable element
        preventOutline(e.target || e.srcElement);
      }

      this._fireDOMEvent(e, type);
    },
    _mouseEvents: ['click', 'dblclick', 'mouseover', 'mouseout', 'contextmenu'],
    _fireDOMEvent: function (e, type, targets) {
      if (e.type === 'click') {
        // Fire a synthetic 'preclick' event which propagates up (mainly for closing popups).
        // @event preclick: MouseEvent
        // Fired before mouse click on the map (sometimes useful when you
        // want something to happen on click before any existing click
        // handlers start running).
        var synth = extend({}, e);
        synth.type = 'preclick';

        this._fireDOMEvent(synth, synth.type, targets);
      }

      if (e._stopped) {
        return;
      } // Find the layer the event is propagating from and its parents.


      targets = (targets || []).concat(this._findEventTargets(e, type));

      if (!targets.length) {
        return;
      }

      var target = targets[0];

      if (type === 'contextmenu' && target.listens(type, true)) {
        preventDefault(e);
      }

      var data = {
        originalEvent: e
      };

      if (e.type !== 'keypress') {
        var isMarker = target.getLatLng && (!target._radius || target._radius <= 10);
        data.containerPoint = isMarker ? this.latLngToContainerPoint(target.getLatLng()) : this.mouseEventToContainerPoint(e);
        data.layerPoint = this.containerPointToLayerPoint(data.containerPoint);
        data.latlng = isMarker ? target.getLatLng() : this.layerPointToLatLng(data.layerPoint);
      }

      for (var i = 0; i < targets.length; i++) {
        targets[i].fire(type, data, true);

        if (data.originalEvent._stopped || targets[i].options.bubblingMouseEvents === false && indexOf(this._mouseEvents, type) !== -1) {
          return;
        }
      }
    },
    _draggableMoved: function (obj) {
      obj = obj.dragging && obj.dragging.enabled() ? obj : this;
      return obj.dragging && obj.dragging.moved() || this.boxZoom && this.boxZoom.moved();
    },
    _clearHandlers: function () {
      for (var i = 0, len = this._handlers.length; i < len; i++) {
        this._handlers[i].disable();
      }
    },
    // @section Other Methods
    // @method whenReady(fn: Function, context?: Object): this
    // Runs the given function `fn` when the map gets initialized with
    // a view (center and zoom) and at least one layer, or immediately
    // if it's already initialized, optionally passing a function context.
    whenReady: function (callback, context) {
      if (this._loaded) {
        callback.call(context || this, {
          target: this
        });
      } else {
        this.on('load', callback, context);
      }

      return this;
    },
    // private methods for getting map state
    _getMapPanePos: function () {
      return getPosition(this._mapPane) || new Point(0, 0);
    },
    _moved: function () {
      var pos = this._getMapPanePos();

      return pos && !pos.equals([0, 0]);
    },
    _getTopLeftPoint: function (center, zoom) {
      var pixelOrigin = center && zoom !== undefined ? this._getNewPixelOrigin(center, zoom) : this.getPixelOrigin();
      return pixelOrigin.subtract(this._getMapPanePos());
    },
    _getNewPixelOrigin: function (center, zoom) {
      var viewHalf = this.getSize()._divideBy(2);

      return this.project(center, zoom)._subtract(viewHalf)._add(this._getMapPanePos())._round();
    },
    _latLngToNewLayerPoint: function (latlng, zoom, center) {
      var topLeft = this._getNewPixelOrigin(center, zoom);

      return this.project(latlng, zoom)._subtract(topLeft);
    },
    _latLngBoundsToNewLayerBounds: function (latLngBounds, zoom, center) {
      var topLeft = this._getNewPixelOrigin(center, zoom);

      return toBounds([this.project(latLngBounds.getSouthWest(), zoom)._subtract(topLeft), this.project(latLngBounds.getNorthWest(), zoom)._subtract(topLeft), this.project(latLngBounds.getSouthEast(), zoom)._subtract(topLeft), this.project(latLngBounds.getNorthEast(), zoom)._subtract(topLeft)]);
    },
    // layer point of the current center
    _getCenterLayerPoint: function () {
      return this.containerPointToLayerPoint(this.getSize()._divideBy(2));
    },
    // offset of the specified place to the current center in pixels
    _getCenterOffset: function (latlng) {
      return this.latLngToLayerPoint(latlng).subtract(this._getCenterLayerPoint());
    },
    // adjust center for view to get inside bounds
    _limitCenter: function (center, zoom, bounds) {
      if (!bounds) {
        return center;
      }

      var centerPoint = this.project(center, zoom),
          viewHalf = this.getSize().divideBy(2),
          viewBounds = new Bounds(centerPoint.subtract(viewHalf), centerPoint.add(viewHalf)),
          offset = this._getBoundsOffset(viewBounds, bounds, zoom); // If offset is less than a pixel, ignore.
      // This prevents unstable projections from getting into
      // an infinite loop of tiny offsets.


      if (offset.round().equals([0, 0])) {
        return center;
      }

      return this.unproject(centerPoint.add(offset), zoom);
    },
    // adjust offset for view to get inside bounds
    _limitOffset: function (offset, bounds) {
      if (!bounds) {
        return offset;
      }

      var viewBounds = this.getPixelBounds(),
          newBounds = new Bounds(viewBounds.min.add(offset), viewBounds.max.add(offset));
      return offset.add(this._getBoundsOffset(newBounds, bounds));
    },
    // returns offset needed for pxBounds to get inside maxBounds at a specified zoom
    _getBoundsOffset: function (pxBounds, maxBounds, zoom) {
      var projectedMaxBounds = toBounds(this.project(maxBounds.getNorthEast(), zoom), this.project(maxBounds.getSouthWest(), zoom)),
          minOffset = projectedMaxBounds.min.subtract(pxBounds.min),
          maxOffset = projectedMaxBounds.max.subtract(pxBounds.max),
          dx = this._rebound(minOffset.x, -maxOffset.x),
          dy = this._rebound(minOffset.y, -maxOffset.y);

      return new Point(dx, dy);
    },
    _rebound: function (left, right) {
      return left + right > 0 ? Math.round(left - right) / 2 : Math.max(0, Math.ceil(left)) - Math.max(0, Math.floor(right));
    },
    _limitZoom: function (zoom) {
      var min = this.getMinZoom(),
          max = this.getMaxZoom(),
          snap = any3d ? this.options.zoomSnap : 1;

      if (snap) {
        zoom = Math.round(zoom / snap) * snap;
      }

      return Math.max(min, Math.min(max, zoom));
    },
    _onPanTransitionStep: function () {
      this.fire('move');
    },
    _onPanTransitionEnd: function () {
      removeClass(this._mapPane, 'leaflet-pan-anim');
      this.fire('moveend');
    },
    _tryAnimatedPan: function (center, options) {
      // difference between the new and current centers in pixels
      var offset = this._getCenterOffset(center)._trunc(); // don't animate too far unless animate: true specified in options


      if ((options && options.animate) !== true && !this.getSize().contains(offset)) {
        return false;
      }

      this.panBy(offset, options);
      return true;
    },
    _createAnimProxy: function () {
      var proxy = this._proxy = create$1('div', 'leaflet-proxy leaflet-zoom-animated');

      this._panes.mapPane.appendChild(proxy);

      this.on('zoomanim', function (e) {
        var prop = TRANSFORM,
            transform = this._proxy.style[prop];
        setTransform(this._proxy, this.project(e.center, e.zoom), this.getZoomScale(e.zoom, 1)); // workaround for case when transform is the same and so transitionend event is not fired

        if (transform === this._proxy.style[prop] && this._animatingZoom) {
          this._onZoomTransitionEnd();
        }
      }, this);
      this.on('load moveend', function () {
        var c = this.getCenter(),
            z = this.getZoom();
        setTransform(this._proxy, this.project(c, z), this.getZoomScale(z, 1));
      }, this);

      this._on('unload', this._destroyAnimProxy, this);
    },
    _destroyAnimProxy: function () {
      remove(this._proxy);
      delete this._proxy;
    },
    _catchTransitionEnd: function (e) {
      if (this._animatingZoom && e.propertyName.indexOf('transform') >= 0) {
        this._onZoomTransitionEnd();
      }
    },
    _nothingToAnimate: function () {
      return !this._container.getElementsByClassName('leaflet-zoom-animated').length;
    },
    _tryAnimatedZoom: function (center, zoom, options) {
      if (this._animatingZoom) {
        return true;
      }

      options = options || {}; // don't animate if disabled, not supported or zoom difference is too large

      if (!this._zoomAnimated || options.animate === false || this._nothingToAnimate() || Math.abs(zoom - this._zoom) > this.options.zoomAnimationThreshold) {
        return false;
      } // offset is the pixel coords of the zoom origin relative to the current center


      var scale = this.getZoomScale(zoom),
          offset = this._getCenterOffset(center)._divideBy(1 - 1 / scale); // don't animate if the zoom origin isn't within one screen from the current center, unless forced


      if (options.animate !== true && !this.getSize().contains(offset)) {
        return false;
      }

      requestAnimFrame(function () {
        this._moveStart(true, false)._animateZoom(center, zoom, true);
      }, this);
      return true;
    },
    _animateZoom: function (center, zoom, startAnim, noUpdate) {
      if (!this._mapPane) {
        return;
      }

      if (startAnim) {
        this._animatingZoom = true; // remember what center/zoom to set after animation

        this._animateToCenter = center;
        this._animateToZoom = zoom;
        addClass(this._mapPane, 'leaflet-zoom-anim');
      } // @event zoomanim: ZoomAnimEvent
      // Fired at least once per zoom animation. For continous zoom, like pinch zooming, fired once per frame during zoom.


      this.fire('zoomanim', {
        center: center,
        zoom: zoom,
        noUpdate: noUpdate
      }); // Work around webkit not firing 'transitionend', see https://github.com/Leaflet/Leaflet/issues/3689, 2693

      setTimeout(bind(this._onZoomTransitionEnd, this), 250);
    },
    _onZoomTransitionEnd: function () {
      if (!this._animatingZoom) {
        return;
      }

      if (this._mapPane) {
        removeClass(this._mapPane, 'leaflet-zoom-anim');
      }

      this._animatingZoom = false;

      this._move(this._animateToCenter, this._animateToZoom); // This anim frame should prevent an obscure iOS webkit tile loading race condition.


      requestAnimFrame(function () {
        this._moveEnd(true);
      }, this);
    }
  }); // @section
  // @factory L.map(id: String, options?: Map options)
  // Instantiates a map object given the DOM ID of a `<div>` element
  // and optionally an object literal with `Map options`.
  //
  // @alternative
  // @factory L.map(el: HTMLElement, options?: Map options)
  // Instantiates a map object given an instance of a `<div>` HTML element
  // and optionally an object literal with `Map options`.

  function createMap(id, options) {
    return new Map(id, options);
  }
  /*
   * @class Control
   * @aka L.Control
   * @inherits Class
   *
   * L.Control is a base class for implementing map controls. Handles positioning.
   * All other controls extend from this class.
   */


  var Control = Class.extend({
    // @section
    // @aka Control options
    options: {
      // @option position: String = 'topright'
      // The position of the control (one of the map corners). Possible values are `'topleft'`,
      // `'topright'`, `'bottomleft'` or `'bottomright'`
      position: 'topright'
    },
    initialize: function (options) {
      setOptions(this, options);
    },

    /* @section
     * Classes extending L.Control will inherit the following methods:
     *
     * @method getPosition: string
     * Returns the position of the control.
     */
    getPosition: function () {
      return this.options.position;
    },
    // @method setPosition(position: string): this
    // Sets the position of the control.
    setPosition: function (position) {
      var map = this._map;

      if (map) {
        map.removeControl(this);
      }

      this.options.position = position;

      if (map) {
        map.addControl(this);
      }

      return this;
    },
    // @method getContainer: HTMLElement
    // Returns the HTMLElement that contains the control.
    getContainer: function () {
      return this._container;
    },
    // @method addTo(map: Map): this
    // Adds the control to the given map.
    addTo: function (map) {
      this.remove();
      this._map = map;
      var container = this._container = this.onAdd(map),
          pos = this.getPosition(),
          corner = map._controlCorners[pos];
      addClass(container, 'leaflet-control');

      if (pos.indexOf('bottom') !== -1) {
        corner.insertBefore(container, corner.firstChild);
      } else {
        corner.appendChild(container);
      }

      return this;
    },
    // @method remove: this
    // Removes the control from the map it is currently active on.
    remove: function () {
      if (!this._map) {
        return this;
      }

      remove(this._container);

      if (this.onRemove) {
        this.onRemove(this._map);
      }

      this._map = null;
      return this;
    },
    _refocusOnMap: function (e) {
      // if map exists and event is not a keyboard event
      if (this._map && e && e.screenX > 0 && e.screenY > 0) {
        this._map.getContainer().focus();
      }
    }
  });

  var control = function (options) {
    return new Control(options);
  };
  /* @section Extension methods
   * @uninheritable
   *
   * Every control should extend from `L.Control` and (re-)implement the following methods.
   *
   * @method onAdd(map: Map): HTMLElement
   * Should return the container DOM element for the control and add listeners on relevant map events. Called on [`control.addTo(map)`](#control-addTo).
   *
   * @method onRemove(map: Map)
   * Optional method. Should contain all clean up code that removes the listeners previously added in [`onAdd`](#control-onadd). Called on [`control.remove()`](#control-remove).
   */

  /* @namespace Map
   * @section Methods for Layers and Controls
   */


  Map.include({
    // @method addControl(control: Control): this
    // Adds the given control to the map
    addControl: function (control) {
      control.addTo(this);
      return this;
    },
    // @method removeControl(control: Control): this
    // Removes the given control from the map
    removeControl: function (control) {
      control.remove();
      return this;
    },
    _initControlPos: function () {
      var corners = this._controlCorners = {},
          l = 'leaflet-',
          container = this._controlContainer = create$1('div', l + 'control-container', this._container);

      function createCorner(vSide, hSide) {
        var className = l + vSide + ' ' + l + hSide;
        corners[vSide + hSide] = create$1('div', className, container);
      }

      createCorner('top', 'left');
      createCorner('top', 'right');
      createCorner('bottom', 'left');
      createCorner('bottom', 'right');
    },
    _clearControlPos: function () {
      for (var i in this._controlCorners) {
        remove(this._controlCorners[i]);
      }

      remove(this._controlContainer);
      delete this._controlCorners;
      delete this._controlContainer;
    }
  });
  /*
   * @class Control.Layers
   * @aka L.Control.Layers
   * @inherits Control
   *
   * The layers control gives users the ability to switch between different base layers and switch overlays on/off (check out the [detailed example](http://leafletjs.com/examples/layers-control/)). Extends `Control`.
   *
   * @example
   *
   * ```js
   * var baseLayers = {
   * 	"Mapbox": mapbox,
   * 	"OpenStreetMap": osm
   * };
   *
   * var overlays = {
   * 	"Marker": marker,
   * 	"Roads": roadsLayer
   * };
   *
   * L.control.layers(baseLayers, overlays).addTo(map);
   * ```
   *
   * The `baseLayers` and `overlays` parameters are object literals with layer names as keys and `Layer` objects as values:
   *
   * ```js
   * {
   *     "<someName1>": layer1,
   *     "<someName2>": layer2
   * }
   * ```
   *
   * The layer names can contain HTML, which allows you to add additional styling to the items:
   *
   * ```js
   * {"<img src='my-layer-icon' /> <span class='my-layer-item'>My Layer</span>": myLayer}
   * ```
   */

  var Layers = Control.extend({
    // @section
    // @aka Control.Layers options
    options: {
      // @option collapsed: Boolean = true
      // If `true`, the control will be collapsed into an icon and expanded on mouse hover or touch.
      collapsed: true,
      position: 'topright',
      // @option autoZIndex: Boolean = true
      // If `true`, the control will assign zIndexes in increasing order to all of its layers so that the order is preserved when switching them on/off.
      autoZIndex: true,
      // @option hideSingleBase: Boolean = false
      // If `true`, the base layers in the control will be hidden when there is only one.
      hideSingleBase: false,
      // @option sortLayers: Boolean = false
      // Whether to sort the layers. When `false`, layers will keep the order
      // in which they were added to the control.
      sortLayers: false,
      // @option sortFunction: Function = *
      // A [compare function](https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Array/sort)
      // that will be used for sorting the layers, when `sortLayers` is `true`.
      // The function receives both the `L.Layer` instances and their names, as in
      // `sortFunction(layerA, layerB, nameA, nameB)`.
      // By default, it sorts layers alphabetically by their name.
      sortFunction: function (layerA, layerB, nameA, nameB) {
        return nameA < nameB ? -1 : nameB < nameA ? 1 : 0;
      }
    },
    initialize: function (baseLayers, overlays, options) {
      setOptions(this, options);
      this._layerControlInputs = [];
      this._layers = [];
      this._lastZIndex = 0;
      this._handlingClick = false;

      for (var i in baseLayers) {
        this._addLayer(baseLayers[i], i);
      }

      for (i in overlays) {
        this._addLayer(overlays[i], i, true);
      }
    },
    onAdd: function (map) {
      this._initLayout();

      this._update();

      this._map = map;
      map.on('zoomend', this._checkDisabledLayers, this);

      for (var i = 0; i < this._layers.length; i++) {
        this._layers[i].layer.on('add remove', this._onLayerChange, this);
      }

      return this._container;
    },
    addTo: function (map) {
      Control.prototype.addTo.call(this, map); // Trigger expand after Layers Control has been inserted into DOM so that is now has an actual height.

      return this._expandIfNotCollapsed();
    },
    onRemove: function () {
      this._map.off('zoomend', this._checkDisabledLayers, this);

      for (var i = 0; i < this._layers.length; i++) {
        this._layers[i].layer.off('add remove', this._onLayerChange, this);
      }
    },
    // @method addBaseLayer(layer: Layer, name: String): this
    // Adds a base layer (radio button entry) with the given name to the control.
    addBaseLayer: function (layer, name) {
      this._addLayer(layer, name);

      return this._map ? this._update() : this;
    },
    // @method addOverlay(layer: Layer, name: String): this
    // Adds an overlay (checkbox entry) with the given name to the control.
    addOverlay: function (layer, name) {
      this._addLayer(layer, name, true);

      return this._map ? this._update() : this;
    },
    // @method removeLayer(layer: Layer): this
    // Remove the given layer from the control.
    removeLayer: function (layer) {
      layer.off('add remove', this._onLayerChange, this);

      var obj = this._getLayer(stamp(layer));

      if (obj) {
        this._layers.splice(this._layers.indexOf(obj), 1);
      }

      return this._map ? this._update() : this;
    },
    // @method expand(): this
    // Expand the control container if collapsed.
    expand: function () {
      addClass(this._container, 'leaflet-control-layers-expanded');
      this._section.style.height = null;
      var acceptableHeight = this._map.getSize().y - (this._container.offsetTop + 50);

      if (acceptableHeight < this._section.clientHeight) {
        addClass(this._section, 'leaflet-control-layers-scrollbar');
        this._section.style.height = acceptableHeight + 'px';
      } else {
        removeClass(this._section, 'leaflet-control-layers-scrollbar');
      }

      this._checkDisabledLayers();

      return this;
    },
    // @method collapse(): this
    // Collapse the control container if expanded.
    collapse: function () {
      removeClass(this._container, 'leaflet-control-layers-expanded');
      return this;
    },
    _initLayout: function () {
      var className = 'leaflet-control-layers',
          container = this._container = create$1('div', className),
          collapsed = this.options.collapsed; // makes this work on IE touch devices by stopping it from firing a mouseout event when the touch is released

      container.setAttribute('aria-haspopup', true);
      disableClickPropagation(container);
      disableScrollPropagation(container);
      var section = this._section = create$1('section', className + '-list');

      if (collapsed) {
        this._map.on('click', this.collapse, this);

        if (!android) {
          on(container, {
            mouseenter: this.expand,
            mouseleave: this.collapse
          }, this);
        }
      }

      var link = this._layersLink = create$1('a', className + '-toggle', container);
      link.href = '#';
      link.title = 'Layers';

      if (touch) {
        on(link, 'click', stop);
        on(link, 'click', this.expand, this);
      } else {
        on(link, 'focus', this.expand, this);
      }

      if (!collapsed) {
        this.expand();
      }

      this._baseLayersList = create$1('div', className + '-base', section);
      this._separator = create$1('div', className + '-separator', section);
      this._overlaysList = create$1('div', className + '-overlays', section);
      container.appendChild(section);
    },
    _getLayer: function (id) {
      for (var i = 0; i < this._layers.length; i++) {
        if (this._layers[i] && stamp(this._layers[i].layer) === id) {
          return this._layers[i];
        }
      }
    },
    _addLayer: function (layer, name, overlay) {
      if (this._map) {
        layer.on('add remove', this._onLayerChange, this);
      }

      this._layers.push({
        layer: layer,
        name: name,
        overlay: overlay
      });

      if (this.options.sortLayers) {
        this._layers.sort(bind(function (a, b) {
          return this.options.sortFunction(a.layer, b.layer, a.name, b.name);
        }, this));
      }

      if (this.options.autoZIndex && layer.setZIndex) {
        this._lastZIndex++;
        layer.setZIndex(this._lastZIndex);
      }

      this._expandIfNotCollapsed();
    },
    _update: function () {
      if (!this._container) {
        return this;
      }

      empty(this._baseLayersList);
      empty(this._overlaysList);
      this._layerControlInputs = [];
      var baseLayersPresent,
          overlaysPresent,
          i,
          obj,
          baseLayersCount = 0;

      for (i = 0; i < this._layers.length; i++) {
        obj = this._layers[i];

        this._addItem(obj);

        overlaysPresent = overlaysPresent || obj.overlay;
        baseLayersPresent = baseLayersPresent || !obj.overlay;
        baseLayersCount += !obj.overlay ? 1 : 0;
      } // Hide base layers section if there's only one layer.


      if (this.options.hideSingleBase) {
        baseLayersPresent = baseLayersPresent && baseLayersCount > 1;
        this._baseLayersList.style.display = baseLayersPresent ? '' : 'none';
      }

      this._separator.style.display = overlaysPresent && baseLayersPresent ? '' : 'none';
      return this;
    },
    _onLayerChange: function (e) {
      if (!this._handlingClick) {
        this._update();
      }

      var obj = this._getLayer(stamp(e.target)); // @namespace Map
      // @section Layer events
      // @event baselayerchange: LayersControlEvent
      // Fired when the base layer is changed through the [layer control](#control-layers).
      // @event overlayadd: LayersControlEvent
      // Fired when an overlay is selected through the [layer control](#control-layers).
      // @event overlayremove: LayersControlEvent
      // Fired when an overlay is deselected through the [layer control](#control-layers).
      // @namespace Control.Layers


      var type = obj.overlay ? e.type === 'add' ? 'overlayadd' : 'overlayremove' : e.type === 'add' ? 'baselayerchange' : null;

      if (type) {
        this._map.fire(type, obj);
      }
    },
    // IE7 bugs out if you create a radio dynamically, so you have to do it this hacky way (see http://bit.ly/PqYLBe)
    _createRadioElement: function (name, checked) {
      var radioHtml = '<input type="radio" class="leaflet-control-layers-selector" name="' + name + '"' + (checked ? ' checked="checked"' : '') + '/>';
      var radioFragment = document.createElement('div');
      radioFragment.innerHTML = radioHtml;
      return radioFragment.firstChild;
    },
    _addItem: function (obj) {
      var label = document.createElement('label'),
          checked = this._map.hasLayer(obj.layer),
          input;

      if (obj.overlay) {
        input = document.createElement('input');
        input.type = 'checkbox';
        input.className = 'leaflet-control-layers-selector';
        input.defaultChecked = checked;
      } else {
        input = this._createRadioElement('leaflet-base-layers', checked);
      }

      this._layerControlInputs.push(input);

      input.layerId = stamp(obj.layer);
      on(input, 'click', this._onInputClick, this);
      var name = document.createElement('span');
      name.innerHTML = ' ' + obj.name; // Helps from preventing layer control flicker when checkboxes are disabled
      // https://github.com/Leaflet/Leaflet/issues/2771

      var holder = document.createElement('div');
      label.appendChild(holder);
      holder.appendChild(input);
      holder.appendChild(name);
      var container = obj.overlay ? this._overlaysList : this._baseLayersList;
      container.appendChild(label);

      this._checkDisabledLayers();

      return label;
    },
    _onInputClick: function () {
      var inputs = this._layerControlInputs,
          input,
          layer;
      var addedLayers = [],
          removedLayers = [];
      this._handlingClick = true;

      for (var i = inputs.length - 1; i >= 0; i--) {
        input = inputs[i];
        layer = this._getLayer(input.layerId).layer;

        if (input.checked) {
          addedLayers.push(layer);
        } else if (!input.checked) {
          removedLayers.push(layer);
        }
      } // Bugfix issue 2318: Should remove all old layers before readding new ones


      for (i = 0; i < removedLayers.length; i++) {
        if (this._map.hasLayer(removedLayers[i])) {
          this._map.removeLayer(removedLayers[i]);
        }
      }

      for (i = 0; i < addedLayers.length; i++) {
        if (!this._map.hasLayer(addedLayers[i])) {
          this._map.addLayer(addedLayers[i]);
        }
      }

      this._handlingClick = false;

      this._refocusOnMap();
    },
    _checkDisabledLayers: function () {
      var inputs = this._layerControlInputs,
          input,
          layer,
          zoom = this._map.getZoom();

      for (var i = inputs.length - 1; i >= 0; i--) {
        input = inputs[i];
        layer = this._getLayer(input.layerId).layer;
        input.disabled = layer.options.minZoom !== undefined && zoom < layer.options.minZoom || layer.options.maxZoom !== undefined && zoom > layer.options.maxZoom;
      }
    },
    _expandIfNotCollapsed: function () {
      if (this._map && !this.options.collapsed) {
        this.expand();
      }

      return this;
    },
    _expand: function () {
      // Backward compatibility, remove me in 1.1.
      return this.expand();
    },
    _collapse: function () {
      // Backward compatibility, remove me in 1.1.
      return this.collapse();
    }
  }); // @factory L.control.layers(baselayers?: Object, overlays?: Object, options?: Control.Layers options)
  // Creates an attribution control with the given layers. Base layers will be switched with radio buttons, while overlays will be switched with checkboxes. Note that all base layers should be passed in the base layers object, but only one should be added to the map during map instantiation.

  var layers = function (baseLayers, overlays, options) {
    return new Layers(baseLayers, overlays, options);
  };
  /*
   * @class Control.Zoom
   * @aka L.Control.Zoom
   * @inherits Control
   *
   * A basic zoom control with two buttons (zoom in and zoom out). It is put on the map by default unless you set its [`zoomControl` option](#map-zoomcontrol) to `false`. Extends `Control`.
   */


  var Zoom = Control.extend({
    // @section
    // @aka Control.Zoom options
    options: {
      position: 'topleft',
      // @option zoomInText: String = '+'
      // The text set on the 'zoom in' button.
      zoomInText: '+',
      // @option zoomInTitle: String = 'Zoom in'
      // The title set on the 'zoom in' button.
      zoomInTitle: 'Zoom in',
      // @option zoomOutText: String = '&#x2212;'
      // The text set on the 'zoom out' button.
      zoomOutText: '&#x2212;',
      // @option zoomOutTitle: String = 'Zoom out'
      // The title set on the 'zoom out' button.
      zoomOutTitle: 'Zoom out'
    },
    onAdd: function (map) {
      var zoomName = 'leaflet-control-zoom',
          container = create$1('div', zoomName + ' leaflet-bar'),
          options = this.options;
      this._zoomInButton = this._createButton(options.zoomInText, options.zoomInTitle, zoomName + '-in', container, this._zoomIn);
      this._zoomOutButton = this._createButton(options.zoomOutText, options.zoomOutTitle, zoomName + '-out', container, this._zoomOut);

      this._updateDisabled();

      map.on('zoomend zoomlevelschange', this._updateDisabled, this);
      return container;
    },
    onRemove: function (map) {
      map.off('zoomend zoomlevelschange', this._updateDisabled, this);
    },
    disable: function () {
      this._disabled = true;

      this._updateDisabled();

      return this;
    },
    enable: function () {
      this._disabled = false;

      this._updateDisabled();

      return this;
    },
    _zoomIn: function (e) {
      if (!this._disabled && this._map._zoom < this._map.getMaxZoom()) {
        this._map.zoomIn(this._map.options.zoomDelta * (e.shiftKey ? 3 : 1));
      }
    },
    _zoomOut: function (e) {
      if (!this._disabled && this._map._zoom > this._map.getMinZoom()) {
        this._map.zoomOut(this._map.options.zoomDelta * (e.shiftKey ? 3 : 1));
      }
    },
    _createButton: function (html, title, className, container, fn) {
      var link = create$1('a', className, container);
      link.innerHTML = html;
      link.href = '#';
      link.title = title;
      /*
       * Will force screen readers like VoiceOver to read this as "Zoom in - button"
       */

      link.setAttribute('role', 'button');
      link.setAttribute('aria-label', title);
      disableClickPropagation(link);
      on(link, 'click', stop);
      on(link, 'click', fn, this);
      on(link, 'click', this._refocusOnMap, this);
      return link;
    },
    _updateDisabled: function () {
      var map = this._map,
          className = 'leaflet-disabled';
      removeClass(this._zoomInButton, className);
      removeClass(this._zoomOutButton, className);

      if (this._disabled || map._zoom === map.getMinZoom()) {
        addClass(this._zoomOutButton, className);
      }

      if (this._disabled || map._zoom === map.getMaxZoom()) {
        addClass(this._zoomInButton, className);
      }
    }
  }); // @namespace Map
  // @section Control options
  // @option zoomControl: Boolean = true
  // Whether a [zoom control](#control-zoom) is added to the map by default.

  Map.mergeOptions({
    zoomControl: true
  });
  Map.addInitHook(function () {
    if (this.options.zoomControl) {
      // @section Controls
      // @property zoomControl: Control.Zoom
      // The default zoom control (only available if the
      // [`zoomControl` option](#map-zoomcontrol) was `true` when creating the map).
      this.zoomControl = new Zoom();
      this.addControl(this.zoomControl);
    }
  }); // @namespace Control.Zoom
  // @factory L.control.zoom(options: Control.Zoom options)
  // Creates a zoom control

  var zoom = function (options) {
    return new Zoom(options);
  };
  /*
   * @class Control.Scale
   * @aka L.Control.Scale
   * @inherits Control
   *
   * A simple scale control that shows the scale of the current center of screen in metric (m/km) and imperial (mi/ft) systems. Extends `Control`.
   *
   * @example
   *
   * ```js
   * L.control.scale().addTo(map);
   * ```
   */


  var Scale = Control.extend({
    // @section
    // @aka Control.Scale options
    options: {
      position: 'bottomleft',
      // @option maxWidth: Number = 100
      // Maximum width of the control in pixels. The width is set dynamically to show round values (e.g. 100, 200, 500).
      maxWidth: 100,
      // @option metric: Boolean = True
      // Whether to show the metric scale line (m/km).
      metric: true,
      // @option imperial: Boolean = True
      // Whether to show the imperial scale line (mi/ft).
      imperial: true // @option updateWhenIdle: Boolean = false
      // If `true`, the control is updated on [`moveend`](#map-moveend), otherwise it's always up-to-date (updated on [`move`](#map-move)).

    },
    onAdd: function (map) {
      var className = 'leaflet-control-scale',
          container = create$1('div', className),
          options = this.options;

      this._addScales(options, className + '-line', container);

      map.on(options.updateWhenIdle ? 'moveend' : 'move', this._update, this);
      map.whenReady(this._update, this);
      return container;
    },
    onRemove: function (map) {
      map.off(this.options.updateWhenIdle ? 'moveend' : 'move', this._update, this);
    },
    _addScales: function (options, className, container) {
      if (options.metric) {
        this._mScale = create$1('div', className, container);
      }

      if (options.imperial) {
        this._iScale = create$1('div', className, container);
      }
    },
    _update: function () {
      var map = this._map,
          y = map.getSize().y / 2;
      var maxMeters = map.distance(map.containerPointToLatLng([0, y]), map.containerPointToLatLng([this.options.maxWidth, y]));

      this._updateScales(maxMeters);
    },
    _updateScales: function (maxMeters) {
      if (this.options.metric && maxMeters) {
        this._updateMetric(maxMeters);
      }

      if (this.options.imperial && maxMeters) {
        this._updateImperial(maxMeters);
      }
    },
    _updateMetric: function (maxMeters) {
      var meters = this._getRoundNum(maxMeters),
          label = meters < 1000 ? meters + ' m' : meters / 1000 + ' km';

      this._updateScale(this._mScale, label, meters / maxMeters);
    },
    _updateImperial: function (maxMeters) {
      var maxFeet = maxMeters * 3.2808399,
          maxMiles,
          miles,
          feet;

      if (maxFeet > 5280) {
        maxMiles = maxFeet / 5280;
        miles = this._getRoundNum(maxMiles);

        this._updateScale(this._iScale, miles + ' mi', miles / maxMiles);
      } else {
        feet = this._getRoundNum(maxFeet);

        this._updateScale(this._iScale, feet + ' ft', feet / maxFeet);
      }
    },
    _updateScale: function (scale, text, ratio) {
      scale.style.width = Math.round(this.options.maxWidth * ratio) + 'px';
      scale.innerHTML = text;
    },
    _getRoundNum: function (num) {
      var pow10 = Math.pow(10, (Math.floor(num) + '').length - 1),
          d = num / pow10;
      d = d >= 10 ? 10 : d >= 5 ? 5 : d >= 3 ? 3 : d >= 2 ? 2 : 1;
      return pow10 * d;
    }
  }); // @factory L.control.scale(options?: Control.Scale options)
  // Creates an scale control with the given options.

  var scale = function (options) {
    return new Scale(options);
  };
  /*
   * @class Control.Attribution
   * @aka L.Control.Attribution
   * @inherits Control
   *
   * The attribution control allows you to display attribution data in a small text box on a map. It is put on the map by default unless you set its [`attributionControl` option](#map-attributioncontrol) to `false`, and it fetches attribution texts from layers with the [`getAttribution` method](#layer-getattribution) automatically. Extends Control.
   */


  var Attribution = Control.extend({
    // @section
    // @aka Control.Attribution options
    options: {
      position: 'bottomright',
      // @option prefix: String = 'Leaflet'
      // The HTML text shown before the attributions. Pass `false` to disable.
      prefix: '<a href="http://leafletjs.com" title="A JS library for interactive maps">Leaflet</a>'
    },
    initialize: function (options) {
      setOptions(this, options);
      this._attributions = {};
    },
    onAdd: function (map) {
      map.attributionControl = this;
      this._container = create$1('div', 'leaflet-control-attribution');
      disableClickPropagation(this._container); // TODO ugly, refactor

      for (var i in map._layers) {
        if (map._layers[i].getAttribution) {
          this.addAttribution(map._layers[i].getAttribution());
        }
      }

      this._update();

      return this._container;
    },
    // @method setPrefix(prefix: String): this
    // Sets the text before the attributions.
    setPrefix: function (prefix) {
      this.options.prefix = prefix;

      this._update();

      return this;
    },
    // @method addAttribution(text: String): this
    // Adds an attribution text (e.g. `'Vector data &copy; Mapbox'`).
    addAttribution: function (text) {
      if (!text) {
        return this;
      }

      if (!this._attributions[text]) {
        this._attributions[text] = 0;
      }

      this._attributions[text]++;

      this._update();

      return this;
    },
    // @method removeAttribution(text: String): this
    // Removes an attribution text.
    removeAttribution: function (text) {
      if (!text) {
        return this;
      }

      if (this._attributions[text]) {
        this._attributions[text]--;

        this._update();
      }

      return this;
    },
    _update: function () {
      if (!this._map) {
        return;
      }

      var attribs = [];

      for (var i in this._attributions) {
        if (this._attributions[i]) {
          attribs.push(i);
        }
      }

      var prefixAndAttribs = [];

      if (this.options.prefix) {
        prefixAndAttribs.push(this.options.prefix);
      }

      if (attribs.length) {
        prefixAndAttribs.push(attribs.join(', '));
      }

      this._container.innerHTML = prefixAndAttribs.join(' | ');
    }
  }); // @namespace Map
  // @section Control options
  // @option attributionControl: Boolean = true
  // Whether a [attribution control](#control-attribution) is added to the map by default.

  Map.mergeOptions({
    attributionControl: true
  });
  Map.addInitHook(function () {
    if (this.options.attributionControl) {
      new Attribution().addTo(this);
    }
  }); // @namespace Control.Attribution
  // @factory L.control.attribution(options: Control.Attribution options)
  // Creates an attribution control.

  var attribution = function (options) {
    return new Attribution(options);
  };

  Control.Layers = Layers;
  Control.Zoom = Zoom;
  Control.Scale = Scale;
  Control.Attribution = Attribution;
  control.layers = layers;
  control.zoom = zoom;
  control.scale = scale;
  control.attribution = attribution;
  /*
  	L.Handler is a base class for handler classes that are used internally to inject
  	interaction features like dragging to classes like Map and Marker.
  */
  // @class Handler
  // @aka L.Handler
  // Abstract class for map interaction handlers

  var Handler = Class.extend({
    initialize: function (map) {
      this._map = map;
    },
    // @method enable(): this
    // Enables the handler
    enable: function () {
      if (this._enabled) {
        return this;
      }

      this._enabled = true;
      this.addHooks();
      return this;
    },
    // @method disable(): this
    // Disables the handler
    disable: function () {
      if (!this._enabled) {
        return this;
      }

      this._enabled = false;
      this.removeHooks();
      return this;
    },
    // @method enabled(): Boolean
    // Returns `true` if the handler is enabled
    enabled: function () {
      return !!this._enabled;
    } // @section Extension methods
    // Classes inheriting from `Handler` must implement the two following methods:
    // @method addHooks()
    // Called when the handler is enabled, should add event hooks.
    // @method removeHooks()
    // Called when the handler is disabled, should remove the event hooks added previously.

  }); // @section There is static function which can be called without instantiating L.Handler:
  // @function addTo(map: Map, name: String): this
  // Adds a new Handler to the given map with the given name.

  Handler.addTo = function (map, name) {
    map.addHandler(name, this);
    return this;
  };

  var Mixin = {
    Events: Events
  };
  /*
   * @class Draggable
   * @aka L.Draggable
   * @inherits Evented
   *
   * A class for making DOM elements draggable (including touch support).
   * Used internally for map and marker dragging. Only works for elements
   * that were positioned with [`L.DomUtil.setPosition`](#domutil-setposition).
   *
   * @example
   * ```js
   * var draggable = new L.Draggable(elementToDrag);
   * draggable.enable();
   * ```
   */

  var START = touch ? 'touchstart mousedown' : 'mousedown';
  var END = {
    mousedown: 'mouseup',
    touchstart: 'touchend',
    pointerdown: 'touchend',
    MSPointerDown: 'touchend'
  };
  var MOVE = {
    mousedown: 'mousemove',
    touchstart: 'touchmove',
    pointerdown: 'touchmove',
    MSPointerDown: 'touchmove'
  };
  var Draggable = Evented.extend({
    options: {
      // @section
      // @aka Draggable options
      // @option clickTolerance: Number = 3
      // The max number of pixels a user can shift the mouse pointer during a click
      // for it to be considered a valid click (as opposed to a mouse drag).
      clickTolerance: 3
    },
    // @constructor L.Draggable(el: HTMLElement, dragHandle?: HTMLElement, preventOutline?: Boolean, options?: Draggable options)
    // Creates a `Draggable` object for moving `el` when you start dragging the `dragHandle` element (equals `el` itself by default).
    initialize: function (element, dragStartTarget, preventOutline$$1, options) {
      setOptions(this, options);
      this._element = element;
      this._dragStartTarget = dragStartTarget || element;
      this._preventOutline = preventOutline$$1;
    },
    // @method enable()
    // Enables the dragging ability
    enable: function () {
      if (this._enabled) {
        return;
      }

      on(this._dragStartTarget, START, this._onDown, this);
      this._enabled = true;
    },
    // @method disable()
    // Disables the dragging ability
    disable: function () {
      if (!this._enabled) {
        return;
      } // If we're currently dragging this draggable,
      // disabling it counts as first ending the drag.


      if (Draggable._dragging === this) {
        this.finishDrag();
      }

      off(this._dragStartTarget, START, this._onDown, this);
      this._enabled = false;
      this._moved = false;
    },
    _onDown: function (e) {
      // Ignore simulated events, since we handle both touch and
      // mouse explicitly; otherwise we risk getting duplicates of
      // touch events, see #4315.
      // Also ignore the event if disabled; this happens in IE11
      // under some circumstances, see #3666.
      if (e._simulated || !this._enabled) {
        return;
      }

      this._moved = false;

      if (hasClass(this._element, 'leaflet-zoom-anim')) {
        return;
      }

      if (Draggable._dragging || e.shiftKey || e.which !== 1 && e.button !== 1 && !e.touches) {
        return;
      }

      Draggable._dragging = this; // Prevent dragging multiple objects at once.

      if (this._preventOutline) {
        preventOutline(this._element);
      }

      disableImageDrag();
      disableTextSelection();

      if (this._moving) {
        return;
      } // @event down: Event
      // Fired when a drag is about to start.


      this.fire('down');
      var first = e.touches ? e.touches[0] : e,
          sizedParent = getSizedParentNode(this._element);
      this._startPoint = new Point(first.clientX, first.clientY); // Cache the scale, so that we can continuously compensate for it during drag (_onMove).

      this._parentScale = getScale(sizedParent);
      on(document, MOVE[e.type], this._onMove, this);
      on(document, END[e.type], this._onUp, this);
    },
    _onMove: function (e) {
      // Ignore simulated events, since we handle both touch and
      // mouse explicitly; otherwise we risk getting duplicates of
      // touch events, see #4315.
      // Also ignore the event if disabled; this happens in IE11
      // under some circumstances, see #3666.
      if (e._simulated || !this._enabled) {
        return;
      }

      if (e.touches && e.touches.length > 1) {
        this._moved = true;
        return;
      }

      var first = e.touches && e.touches.length === 1 ? e.touches[0] : e,
          offset = new Point(first.clientX, first.clientY)._subtract(this._startPoint);

      if (!offset.x && !offset.y) {
        return;
      }

      if (Math.abs(offset.x) + Math.abs(offset.y) < this.options.clickTolerance) {
        return;
      } // We assume that the parent container's position, border and scale do not change for the duration of the drag.
      // Therefore there is no need to account for the position and border (they are eliminated by the subtraction)
      // and we can use the cached value for the scale.


      offset.x /= this._parentScale.x;
      offset.y /= this._parentScale.y;
      preventDefault(e);

      if (!this._moved) {
        // @event dragstart: Event
        // Fired when a drag starts
        this.fire('dragstart');
        this._moved = true;
        this._startPos = getPosition(this._element).subtract(offset);
        addClass(document.body, 'leaflet-dragging');
        this._lastTarget = e.target || e.srcElement; // IE and Edge do not give the <use> element, so fetch it
        // if necessary

        if (window.SVGElementInstance && this._lastTarget instanceof SVGElementInstance) {
          this._lastTarget = this._lastTarget.correspondingUseElement;
        }

        addClass(this._lastTarget, 'leaflet-drag-target');
      }

      this._newPos = this._startPos.add(offset);
      this._moving = true;
      cancelAnimFrame(this._animRequest);
      this._lastEvent = e;
      this._animRequest = requestAnimFrame(this._updatePosition, this, true);
    },
    _updatePosition: function () {
      var e = {
        originalEvent: this._lastEvent
      }; // @event predrag: Event
      // Fired continuously during dragging *before* each corresponding
      // update of the element's position.

      this.fire('predrag', e);
      setPosition(this._element, this._newPos); // @event drag: Event
      // Fired continuously during dragging.

      this.fire('drag', e);
    },
    _onUp: function (e) {
      // Ignore simulated events, since we handle both touch and
      // mouse explicitly; otherwise we risk getting duplicates of
      // touch events, see #4315.
      // Also ignore the event if disabled; this happens in IE11
      // under some circumstances, see #3666.
      if (e._simulated || !this._enabled) {
        return;
      }

      this.finishDrag();
    },
    finishDrag: function () {
      removeClass(document.body, 'leaflet-dragging');

      if (this._lastTarget) {
        removeClass(this._lastTarget, 'leaflet-drag-target');
        this._lastTarget = null;
      }

      for (var i in MOVE) {
        off(document, MOVE[i], this._onMove, this);
        off(document, END[i], this._onUp, this);
      }

      enableImageDrag();
      enableTextSelection();

      if (this._moved && this._moving) {
        // ensure drag is not fired after dragend
        cancelAnimFrame(this._animRequest); // @event dragend: DragEndEvent
        // Fired when the drag ends.

        this.fire('dragend', {
          distance: this._newPos.distanceTo(this._startPos)
        });
      }

      this._moving = false;
      Draggable._dragging = false;
    }
  });
  /*
   * @namespace LineUtil
   *
   * Various utility functions for polyline points processing, used by Leaflet internally to make polylines lightning-fast.
   */
  // Simplify polyline with vertex reduction and Douglas-Peucker simplification.
  // Improves rendering performance dramatically by lessening the number of points to draw.
  // @function simplify(points: Point[], tolerance: Number): Point[]
  // Dramatically reduces the number of points in a polyline while retaining
  // its shape and returns a new array of simplified points, using the
  // [Douglas-Peucker algorithm](http://en.wikipedia.org/wiki/Douglas-Peucker_algorithm).
  // Used for a huge performance boost when processing/displaying Leaflet polylines for
  // each zoom level and also reducing visual noise. tolerance affects the amount of
  // simplification (lesser value means higher quality but slower and with more points).
  // Also released as a separated micro-library [Simplify.js](http://mourner.github.com/simplify-js/).

  function simplify(points, tolerance) {
    if (!tolerance || !points.length) {
      return points.slice();
    }

    var sqTolerance = tolerance * tolerance; // stage 1: vertex reduction

    points = _reducePoints(points, sqTolerance); // stage 2: Douglas-Peucker simplification

    points = _simplifyDP(points, sqTolerance);
    return points;
  } // @function pointToSegmentDistance(p: Point, p1: Point, p2: Point): Number
  // Returns the distance between point `p` and segment `p1` to `p2`.


  function pointToSegmentDistance(p, p1, p2) {
    return Math.sqrt(_sqClosestPointOnSegment(p, p1, p2, true));
  } // @function closestPointOnSegment(p: Point, p1: Point, p2: Point): Number
  // Returns the closest point from a point `p` on a segment `p1` to `p2`.


  function closestPointOnSegment(p, p1, p2) {
    return _sqClosestPointOnSegment(p, p1, p2);
  } // Douglas-Peucker simplification, see http://en.wikipedia.org/wiki/Douglas-Peucker_algorithm


  function _simplifyDP(points, sqTolerance) {
    var len = points.length,
        ArrayConstructor = typeof Uint8Array !== undefined + '' ? Uint8Array : Array,
        markers = new ArrayConstructor(len);
    markers[0] = markers[len - 1] = 1;

    _simplifyDPStep(points, markers, sqTolerance, 0, len - 1);

    var i,
        newPoints = [];

    for (i = 0; i < len; i++) {
      if (markers[i]) {
        newPoints.push(points[i]);
      }
    }

    return newPoints;
  }

  function _simplifyDPStep(points, markers, sqTolerance, first, last) {
    var maxSqDist = 0,
        index,
        i,
        sqDist;

    for (i = first + 1; i <= last - 1; i++) {
      sqDist = _sqClosestPointOnSegment(points[i], points[first], points[last], true);

      if (sqDist > maxSqDist) {
        index = i;
        maxSqDist = sqDist;
      }
    }

    if (maxSqDist > sqTolerance) {
      markers[index] = 1;

      _simplifyDPStep(points, markers, sqTolerance, first, index);

      _simplifyDPStep(points, markers, sqTolerance, index, last);
    }
  } // reduce points that are too close to each other to a single point


  function _reducePoints(points, sqTolerance) {
    var reducedPoints = [points[0]];

    for (var i = 1, prev = 0, len = points.length; i < len; i++) {
      if (_sqDist(points[i], points[prev]) > sqTolerance) {
        reducedPoints.push(points[i]);
        prev = i;
      }
    }

    if (prev < len - 1) {
      reducedPoints.push(points[len - 1]);
    }

    return reducedPoints;
  }

  var _lastCode; // @function clipSegment(a: Point, b: Point, bounds: Bounds, useLastCode?: Boolean, round?: Boolean): Point[]|Boolean
  // Clips the segment a to b by rectangular bounds with the
  // [Cohen-Sutherland algorithm](https://en.wikipedia.org/wiki/Cohen%E2%80%93Sutherland_algorithm)
  // (modifying the segment points directly!). Used by Leaflet to only show polyline
  // points that are on the screen or near, increasing performance.


  function clipSegment(a, b, bounds, useLastCode, round) {
    var codeA = useLastCode ? _lastCode : _getBitCode(a, bounds),
        codeB = _getBitCode(b, bounds),
        codeOut,
        p,
        newCode; // save 2nd code to avoid calculating it on the next segment


    _lastCode = codeB;

    while (true) {
      // if a,b is inside the clip window (trivial accept)
      if (!(codeA | codeB)) {
        return [a, b];
      } // if a,b is outside the clip window (trivial reject)


      if (codeA & codeB) {
        return false;
      } // other cases


      codeOut = codeA || codeB;
      p = _getEdgeIntersection(a, b, codeOut, bounds, round);
      newCode = _getBitCode(p, bounds);

      if (codeOut === codeA) {
        a = p;
        codeA = newCode;
      } else {
        b = p;
        codeB = newCode;
      }
    }
  }

  function _getEdgeIntersection(a, b, code, bounds, round) {
    var dx = b.x - a.x,
        dy = b.y - a.y,
        min = bounds.min,
        max = bounds.max,
        x,
        y;

    if (code & 8) {
      // top
      x = a.x + dx * (max.y - a.y) / dy;
      y = max.y;
    } else if (code & 4) {
      // bottom
      x = a.x + dx * (min.y - a.y) / dy;
      y = min.y;
    } else if (code & 2) {
      // right
      x = max.x;
      y = a.y + dy * (max.x - a.x) / dx;
    } else if (code & 1) {
      // left
      x = min.x;
      y = a.y + dy * (min.x - a.x) / dx;
    }

    return new Point(x, y, round);
  }

  function _getBitCode(p, bounds) {
    var code = 0;

    if (p.x < bounds.min.x) {
      // left
      code |= 1;
    } else if (p.x > bounds.max.x) {
      // right
      code |= 2;
    }

    if (p.y < bounds.min.y) {
      // bottom
      code |= 4;
    } else if (p.y > bounds.max.y) {
      // top
      code |= 8;
    }

    return code;
  } // square distance (to avoid unnecessary Math.sqrt calls)


  function _sqDist(p1, p2) {
    var dx = p2.x - p1.x,
        dy = p2.y - p1.y;
    return dx * dx + dy * dy;
  } // return closest point on segment or distance to that point


  function _sqClosestPointOnSegment(p, p1, p2, sqDist) {
    var x = p1.x,
        y = p1.y,
        dx = p2.x - x,
        dy = p2.y - y,
        dot = dx * dx + dy * dy,
        t;

    if (dot > 0) {
      t = ((p.x - x) * dx + (p.y - y) * dy) / dot;

      if (t > 1) {
        x = p2.x;
        y = p2.y;
      } else if (t > 0) {
        x += dx * t;
        y += dy * t;
      }
    }

    dx = p.x - x;
    dy = p.y - y;
    return sqDist ? dx * dx + dy * dy : new Point(x, y);
  } // @function isFlat(latlngs: LatLng[]): Boolean
  // Returns true if `latlngs` is a flat array, false is nested.


  function isFlat(latlngs) {
    return !isArray(latlngs[0]) || typeof latlngs[0][0] !== 'object' && typeof latlngs[0][0] !== 'undefined';
  }

  function _flat(latlngs) {
    console.warn('Deprecated use of _flat, please use L.LineUtil.isFlat instead.');
    return isFlat(latlngs);
  }

  var LineUtil = (Object.freeze || Object)({
    simplify: simplify,
    pointToSegmentDistance: pointToSegmentDistance,
    closestPointOnSegment: closestPointOnSegment,
    clipSegment: clipSegment,
    _getEdgeIntersection: _getEdgeIntersection,
    _getBitCode: _getBitCode,
    _sqClosestPointOnSegment: _sqClosestPointOnSegment,
    isFlat: isFlat,
    _flat: _flat
  });
  /*
   * @namespace PolyUtil
   * Various utility functions for polygon geometries.
   */

  /* @function clipPolygon(points: Point[], bounds: Bounds, round?: Boolean): Point[]
   * Clips the polygon geometry defined by the given `points` by the given bounds (using the [Sutherland-Hodgman algorithm](https://en.wikipedia.org/wiki/Sutherland%E2%80%93Hodgman_algorithm)).
   * Used by Leaflet to only show polygon points that are on the screen or near, increasing
   * performance. Note that polygon points needs different algorithm for clipping
   * than polyline, so there's a separate method for it.
   */

  function clipPolygon(points, bounds, round) {
    var clippedPoints,
        edges = [1, 4, 2, 8],
        i,
        j,
        k,
        a,
        b,
        len,
        edge,
        p;

    for (i = 0, len = points.length; i < len; i++) {
      points[i]._code = _getBitCode(points[i], bounds);
    } // for each edge (left, bottom, right, top)


    for (k = 0; k < 4; k++) {
      edge = edges[k];
      clippedPoints = [];

      for (i = 0, len = points.length, j = len - 1; i < len; j = i++) {
        a = points[i];
        b = points[j]; // if a is inside the clip window

        if (!(a._code & edge)) {
          // if b is outside the clip window (a->b goes out of screen)
          if (b._code & edge) {
            p = _getEdgeIntersection(b, a, edge, bounds, round);
            p._code = _getBitCode(p, bounds);
            clippedPoints.push(p);
          }

          clippedPoints.push(a); // else if b is inside the clip window (a->b enters the screen)
        } else if (!(b._code & edge)) {
          p = _getEdgeIntersection(b, a, edge, bounds, round);
          p._code = _getBitCode(p, bounds);
          clippedPoints.push(p);
        }
      }

      points = clippedPoints;
    }

    return points;
  }

  var PolyUtil = (Object.freeze || Object)({
    clipPolygon: clipPolygon
  });
  /*
   * @namespace Projection
   * @section
   * Leaflet comes with a set of already defined Projections out of the box:
   *
   * @projection L.Projection.LonLat
   *
   * Equirectangular, or Plate Carree projection — the most simple projection,
   * mostly used by GIS enthusiasts. Directly maps `x` as longitude, and `y` as
   * latitude. Also suitable for flat worlds, e.g. game maps. Used by the
   * `EPSG:4326` and `Simple` CRS.
   */

  var LonLat = {
    project: function (latlng) {
      return new Point(latlng.lng, latlng.lat);
    },
    unproject: function (point) {
      return new LatLng(point.y, point.x);
    },
    bounds: new Bounds([-180, -90], [180, 90])
  };
  /*
   * @namespace Projection
   * @projection L.Projection.Mercator
   *
   * Elliptical Mercator projection — more complex than Spherical Mercator. Takes into account that Earth is a geoid, not a perfect sphere. Used by the EPSG:3395 CRS.
   */

  var Mercator = {
    R: 6378137,
    R_MINOR: 6356752.314245179,
    bounds: new Bounds([-20037508.34279, -15496570.73972], [20037508.34279, 18764656.23138]),
    project: function (latlng) {
      var d = Math.PI / 180,
          r = this.R,
          y = latlng.lat * d,
          tmp = this.R_MINOR / r,
          e = Math.sqrt(1 - tmp * tmp),
          con = e * Math.sin(y);
      var ts = Math.tan(Math.PI / 4 - y / 2) / Math.pow((1 - con) / (1 + con), e / 2);
      y = -r * Math.log(Math.max(ts, 1E-10));
      return new Point(latlng.lng * d * r, y);
    },
    unproject: function (point) {
      var d = 180 / Math.PI,
          r = this.R,
          tmp = this.R_MINOR / r,
          e = Math.sqrt(1 - tmp * tmp),
          ts = Math.exp(-point.y / r),
          phi = Math.PI / 2 - 2 * Math.atan(ts);

      for (var i = 0, dphi = 0.1, con; i < 15 && Math.abs(dphi) > 1e-7; i++) {
        con = e * Math.sin(phi);
        con = Math.pow((1 - con) / (1 + con), e / 2);
        dphi = Math.PI / 2 - 2 * Math.atan(ts * con) - phi;
        phi += dphi;
      }

      return new LatLng(phi * d, point.x * d / r);
    }
  };
  /*
   * @class Projection
  
   * An object with methods for projecting geographical coordinates of the world onto
   * a flat surface (and back). See [Map projection](http://en.wikipedia.org/wiki/Map_projection).
  
   * @property bounds: Bounds
   * The bounds (specified in CRS units) where the projection is valid
  
   * @method project(latlng: LatLng): Point
   * Projects geographical coordinates into a 2D point.
   * Only accepts actual `L.LatLng` instances, not arrays.
  
   * @method unproject(point: Point): LatLng
   * The inverse of `project`. Projects a 2D point into a geographical location.
   * Only accepts actual `L.Point` instances, not arrays.
  
   * Note that the projection instances do not inherit from Leafet's `Class` object,
   * and can't be instantiated. Also, new classes can't inherit from them,
   * and methods can't be added to them with the `include` function.
  
   */

  var index = (Object.freeze || Object)({
    LonLat: LonLat,
    Mercator: Mercator,
    SphericalMercator: SphericalMercator
  });
  /*
   * @namespace CRS
   * @crs L.CRS.EPSG3395
   *
   * Rarely used by some commercial tile providers. Uses Elliptical Mercator projection.
   */

  var EPSG3395 = extend({}, Earth, {
    code: 'EPSG:3395',
    projection: Mercator,
    transformation: function () {
      var scale = 0.5 / (Math.PI * Mercator.R);
      return toTransformation(scale, 0.5, -scale, 0.5);
    }()
  });
  /*
   * @namespace CRS
   * @crs L.CRS.EPSG4326
   *
   * A common CRS among GIS enthusiasts. Uses simple Equirectangular projection.
   *
   * Leaflet 1.0.x complies with the [TMS coordinate scheme for EPSG:4326](https://wiki.osgeo.org/wiki/Tile_Map_Service_Specification#global-geodetic),
   * which is a breaking change from 0.7.x behaviour.  If you are using a `TileLayer`
   * with this CRS, ensure that there are two 256x256 pixel tiles covering the
   * whole earth at zoom level zero, and that the tile coordinate origin is (-180,+90),
   * or (-180,-90) for `TileLayer`s with [the `tms` option](#tilelayer-tms) set.
   */

  var EPSG4326 = extend({}, Earth, {
    code: 'EPSG:4326',
    projection: LonLat,
    transformation: toTransformation(1 / 180, 1, -1 / 180, 0.5)
  });
  /*
   * @namespace CRS
   * @crs L.CRS.Simple
   *
   * A simple CRS that maps longitude and latitude into `x` and `y` directly.
   * May be used for maps of flat surfaces (e.g. game maps). Note that the `y`
   * axis should still be inverted (going from bottom to top). `distance()` returns
   * simple euclidean distance.
   */

  var Simple = extend({}, CRS, {
    projection: LonLat,
    transformation: toTransformation(1, 0, -1, 0),
    scale: function (zoom) {
      return Math.pow(2, zoom);
    },
    zoom: function (scale) {
      return Math.log(scale) / Math.LN2;
    },
    distance: function (latlng1, latlng2) {
      var dx = latlng2.lng - latlng1.lng,
          dy = latlng2.lat - latlng1.lat;
      return Math.sqrt(dx * dx + dy * dy);
    },
    infinite: true
  });
  CRS.Earth = Earth;
  CRS.EPSG3395 = EPSG3395;
  CRS.EPSG3857 = EPSG3857;
  CRS.EPSG900913 = EPSG900913;
  CRS.EPSG4326 = EPSG4326;
  CRS.Simple = Simple;
  /*
   * @class Layer
   * @inherits Evented
   * @aka L.Layer
   * @aka ILayer
   *
   * A set of methods from the Layer base class that all Leaflet layers use.
   * Inherits all methods, options and events from `L.Evented`.
   *
   * @example
   *
   * ```js
   * var layer = L.Marker(latlng).addTo(map);
   * layer.addTo(map);
   * layer.remove();
   * ```
   *
   * @event add: Event
   * Fired after the layer is added to a map
   *
   * @event remove: Event
   * Fired after the layer is removed from a map
   */

  var Layer = Evented.extend({
    // Classes extending `L.Layer` will inherit the following options:
    options: {
      // @option pane: String = 'overlayPane'
      // By default the layer will be added to the map's [overlay pane](#map-overlaypane). Overriding this option will cause the layer to be placed on another pane by default.
      pane: 'overlayPane',
      // @option attribution: String = null
      // String to be shown in the attribution control, e.g. "© OpenStreetMap contributors". It describes the layer data and is often a legal obligation towards copyright holders and tile providers.
      attribution: null,
      bubblingMouseEvents: true
    },

    /* @section
     * Classes extending `L.Layer` will inherit the following methods:
     *
     * @method addTo(map: Map|LayerGroup): this
     * Adds the layer to the given map or layer group.
     */
    addTo: function (map) {
      map.addLayer(this);
      return this;
    },
    // @method remove: this
    // Removes the layer from the map it is currently active on.
    remove: function () {
      return this.removeFrom(this._map || this._mapToAdd);
    },
    // @method removeFrom(map: Map): this
    // Removes the layer from the given map
    removeFrom: function (obj) {
      if (obj) {
        obj.removeLayer(this);
      }

      return this;
    },
    // @method getPane(name? : String): HTMLElement
    // Returns the `HTMLElement` representing the named pane on the map. If `name` is omitted, returns the pane for this layer.
    getPane: function (name) {
      return this._map.getPane(name ? this.options[name] || name : this.options.pane);
    },
    addInteractiveTarget: function (targetEl) {
      this._map._targets[stamp(targetEl)] = this;
      return this;
    },
    removeInteractiveTarget: function (targetEl) {
      delete this._map._targets[stamp(targetEl)];
      return this;
    },
    // @method getAttribution: String
    // Used by the `attribution control`, returns the [attribution option](#gridlayer-attribution).
    getAttribution: function () {
      return this.options.attribution;
    },
    _layerAdd: function (e) {
      var map = e.target; // check in case layer gets added and then removed before the map is ready

      if (!map.hasLayer(this)) {
        return;
      }

      this._map = map;
      this._zoomAnimated = map._zoomAnimated;

      if (this.getEvents) {
        var events = this.getEvents();
        map.on(events, this);
        this.once('remove', function () {
          map.off(events, this);
        }, this);
      }

      this.onAdd(map);

      if (this.getAttribution && map.attributionControl) {
        map.attributionControl.addAttribution(this.getAttribution());
      }

      this.fire('add');
      map.fire('layeradd', {
        layer: this
      });
    }
  });
  /* @section Extension methods
   * @uninheritable
   *
   * Every layer should extend from `L.Layer` and (re-)implement the following methods.
   *
   * @method onAdd(map: Map): this
   * Should contain code that creates DOM elements for the layer, adds them to `map panes` where they should belong and puts listeners on relevant map events. Called on [`map.addLayer(layer)`](#map-addlayer).
   *
   * @method onRemove(map: Map): this
   * Should contain all clean up code that removes the layer's elements from the DOM and removes listeners previously added in [`onAdd`](#layer-onadd). Called on [`map.removeLayer(layer)`](#map-removelayer).
   *
   * @method getEvents(): Object
   * This optional method should return an object like `{ viewreset: this._reset }` for [`addEventListener`](#evented-addeventlistener). The event handlers in this object will be automatically added and removed from the map with your layer.
   *
   * @method getAttribution(): String
   * This optional method should return a string containing HTML to be shown on the `Attribution control` whenever the layer is visible.
   *
   * @method beforeAdd(map: Map): this
   * Optional method. Called on [`map.addLayer(layer)`](#map-addlayer), before the layer is added to the map, before events are initialized, without waiting until the map is in a usable state. Use for early initialization only.
   */

  /* @namespace Map
   * @section Layer events
   *
   * @event layeradd: LayerEvent
   * Fired when a new layer is added to the map.
   *
   * @event layerremove: LayerEvent
   * Fired when some layer is removed from the map
   *
   * @section Methods for Layers and Controls
   */

  Map.include({
    // @method addLayer(layer: Layer): this
    // Adds the given layer to the map
    addLayer: function (layer) {
      if (!layer._layerAdd) {
        throw new Error('The provided object is not a Layer.');
      }

      var id = stamp(layer);

      if (this._layers[id]) {
        return this;
      }

      this._layers[id] = layer;
      layer._mapToAdd = this;

      if (layer.beforeAdd) {
        layer.beforeAdd(this);
      }

      this.whenReady(layer._layerAdd, layer);
      return this;
    },
    // @method removeLayer(layer: Layer): this
    // Removes the given layer from the map.
    removeLayer: function (layer) {
      var id = stamp(layer);

      if (!this._layers[id]) {
        return this;
      }

      if (this._loaded) {
        layer.onRemove(this);
      }

      if (layer.getAttribution && this.attributionControl) {
        this.attributionControl.removeAttribution(layer.getAttribution());
      }

      delete this._layers[id];

      if (this._loaded) {
        this.fire('layerremove', {
          layer: layer
        });
        layer.fire('remove');
      }

      layer._map = layer._mapToAdd = null;
      return this;
    },
    // @method hasLayer(layer: Layer): Boolean
    // Returns `true` if the given layer is currently added to the map
    hasLayer: function (layer) {
      return !!layer && stamp(layer) in this._layers;
    },

    /* @method eachLayer(fn: Function, context?: Object): this
     * Iterates over the layers of the map, optionally specifying context of the iterator function.
     * ```
     * map.eachLayer(function(layer){
     *     layer.bindPopup('Hello');
     * });
     * ```
     */
    eachLayer: function (method, context) {
      for (var i in this._layers) {
        method.call(context, this._layers[i]);
      }

      return this;
    },
    _addLayers: function (layers) {
      layers = layers ? isArray(layers) ? layers : [layers] : [];

      for (var i = 0, len = layers.length; i < len; i++) {
        this.addLayer(layers[i]);
      }
    },
    _addZoomLimit: function (layer) {
      if (isNaN(layer.options.maxZoom) || !isNaN(layer.options.minZoom)) {
        this._zoomBoundLayers[stamp(layer)] = layer;

        this._updateZoomLevels();
      }
    },
    _removeZoomLimit: function (layer) {
      var id = stamp(layer);

      if (this._zoomBoundLayers[id]) {
        delete this._zoomBoundLayers[id];

        this._updateZoomLevels();
      }
    },
    _updateZoomLevels: function () {
      var minZoom = Infinity,
          maxZoom = -Infinity,
          oldZoomSpan = this._getZoomSpan();

      for (var i in this._zoomBoundLayers) {
        var options = this._zoomBoundLayers[i].options;
        minZoom = options.minZoom === undefined ? minZoom : Math.min(minZoom, options.minZoom);
        maxZoom = options.maxZoom === undefined ? maxZoom : Math.max(maxZoom, options.maxZoom);
      }

      this._layersMaxZoom = maxZoom === -Infinity ? undefined : maxZoom;
      this._layersMinZoom = minZoom === Infinity ? undefined : minZoom; // @section Map state change events
      // @event zoomlevelschange: Event
      // Fired when the number of zoomlevels on the map is changed due
      // to adding or removing a layer.

      if (oldZoomSpan !== this._getZoomSpan()) {
        this.fire('zoomlevelschange');
      }

      if (this.options.maxZoom === undefined && this._layersMaxZoom && this.getZoom() > this._layersMaxZoom) {
        this.setZoom(this._layersMaxZoom);
      }

      if (this.options.minZoom === undefined && this._layersMinZoom && this.getZoom() < this._layersMinZoom) {
        this.setZoom(this._layersMinZoom);
      }
    }
  });
  /*
   * @class LayerGroup
   * @aka L.LayerGroup
   * @inherits Layer
   *
   * Used to group several layers and handle them as one. If you add it to the map,
   * any layers added or removed from the group will be added/removed on the map as
   * well. Extends `Layer`.
   *
   * @example
   *
   * ```js
   * L.layerGroup([marker1, marker2])
   * 	.addLayer(polyline)
   * 	.addTo(map);
   * ```
   */

  var LayerGroup = Layer.extend({
    initialize: function (layers, options) {
      setOptions(this, options);
      this._layers = {};
      var i, len;

      if (layers) {
        for (i = 0, len = layers.length; i < len; i++) {
          this.addLayer(layers[i]);
        }
      }
    },
    // @method addLayer(layer: Layer): this
    // Adds the given layer to the group.
    addLayer: function (layer) {
      var id = this.getLayerId(layer);
      this._layers[id] = layer;

      if (this._map) {
        this._map.addLayer(layer);
      }

      return this;
    },
    // @method removeLayer(layer: Layer): this
    // Removes the given layer from the group.
    // @alternative
    // @method removeLayer(id: Number): this
    // Removes the layer with the given internal ID from the group.
    removeLayer: function (layer) {
      var id = layer in this._layers ? layer : this.getLayerId(layer);

      if (this._map && this._layers[id]) {
        this._map.removeLayer(this._layers[id]);
      }

      delete this._layers[id];
      return this;
    },
    // @method hasLayer(layer: Layer): Boolean
    // Returns `true` if the given layer is currently added to the group.
    // @alternative
    // @method hasLayer(id: Number): Boolean
    // Returns `true` if the given internal ID is currently added to the group.
    hasLayer: function (layer) {
      return !!layer && (layer in this._layers || this.getLayerId(layer) in this._layers);
    },
    // @method clearLayers(): this
    // Removes all the layers from the group.
    clearLayers: function () {
      return this.eachLayer(this.removeLayer, this);
    },
    // @method invoke(methodName: String, …): this
    // Calls `methodName` on every layer contained in this group, passing any
    // additional parameters. Has no effect if the layers contained do not
    // implement `methodName`.
    invoke: function (methodName) {
      var args = Array.prototype.slice.call(arguments, 1),
          i,
          layer;

      for (i in this._layers) {
        layer = this._layers[i];

        if (layer[methodName]) {
          layer[methodName].apply(layer, args);
        }
      }

      return this;
    },
    onAdd: function (map) {
      this.eachLayer(map.addLayer, map);
    },
    onRemove: function (map) {
      this.eachLayer(map.removeLayer, map);
    },
    // @method eachLayer(fn: Function, context?: Object): this
    // Iterates over the layers of the group, optionally specifying context of the iterator function.
    // ```js
    // group.eachLayer(function (layer) {
    // 	layer.bindPopup('Hello');
    // });
    // ```
    eachLayer: function (method, context) {
      for (var i in this._layers) {
        method.call(context, this._layers[i]);
      }

      return this;
    },
    // @method getLayer(id: Number): Layer
    // Returns the layer with the given internal ID.
    getLayer: function (id) {
      return this._layers[id];
    },
    // @method getLayers(): Layer[]
    // Returns an array of all the layers added to the group.
    getLayers: function () {
      var layers = [];
      this.eachLayer(layers.push, layers);
      return layers;
    },
    // @method setZIndex(zIndex: Number): this
    // Calls `setZIndex` on every layer contained in this group, passing the z-index.
    setZIndex: function (zIndex) {
      return this.invoke('setZIndex', zIndex);
    },
    // @method getLayerId(layer: Layer): Number
    // Returns the internal ID for a layer
    getLayerId: function (layer) {
      return stamp(layer);
    }
  }); // @factory L.layerGroup(layers?: Layer[], options?: Object)
  // Create a layer group, optionally given an initial set of layers and an `options` object.

  var layerGroup = function (layers, options) {
    return new LayerGroup(layers, options);
  };
  /*
   * @class FeatureGroup
   * @aka L.FeatureGroup
   * @inherits LayerGroup
   *
   * Extended `LayerGroup` that makes it easier to do the same thing to all its member layers:
   *  * [`bindPopup`](#layer-bindpopup) binds a popup to all of the layers at once (likewise with [`bindTooltip`](#layer-bindtooltip))
   *  * Events are propagated to the `FeatureGroup`, so if the group has an event
   * handler, it will handle events from any of the layers. This includes mouse events
   * and custom events.
   *  * Has `layeradd` and `layerremove` events
   *
   * @example
   *
   * ```js
   * L.featureGroup([marker1, marker2, polyline])
   * 	.bindPopup('Hello world!')
   * 	.on('click', function() { alert('Clicked on a member of the group!'); })
   * 	.addTo(map);
   * ```
   */


  var FeatureGroup = LayerGroup.extend({
    addLayer: function (layer) {
      if (this.hasLayer(layer)) {
        return this;
      }

      layer.addEventParent(this);
      LayerGroup.prototype.addLayer.call(this, layer); // @event layeradd: LayerEvent
      // Fired when a layer is added to this `FeatureGroup`

      return this.fire('layeradd', {
        layer: layer
      });
    },
    removeLayer: function (layer) {
      if (!this.hasLayer(layer)) {
        return this;
      }

      if (layer in this._layers) {
        layer = this._layers[layer];
      }

      layer.removeEventParent(this);
      LayerGroup.prototype.removeLayer.call(this, layer); // @event layerremove: LayerEvent
      // Fired when a layer is removed from this `FeatureGroup`

      return this.fire('layerremove', {
        layer: layer
      });
    },
    // @method setStyle(style: Path options): this
    // Sets the given path options to each layer of the group that has a `setStyle` method.
    setStyle: function (style) {
      return this.invoke('setStyle', style);
    },
    // @method bringToFront(): this
    // Brings the layer group to the top of all other layers
    bringToFront: function () {
      return this.invoke('bringToFront');
    },
    // @method bringToBack(): this
    // Brings the layer group to the back of all other layers
    bringToBack: function () {
      return this.invoke('bringToBack');
    },
    // @method getBounds(): LatLngBounds
    // Returns the LatLngBounds of the Feature Group (created from bounds and coordinates of its children).
    getBounds: function () {
      var bounds = new LatLngBounds();

      for (var id in this._layers) {
        var layer = this._layers[id];
        bounds.extend(layer.getBounds ? layer.getBounds() : layer.getLatLng());
      }

      return bounds;
    }
  }); // @factory L.featureGroup(layers: Layer[])
  // Create a feature group, optionally given an initial set of layers.

  var featureGroup = function (layers) {
    return new FeatureGroup(layers);
  };
  /*
   * @class Icon
   * @aka L.Icon
   *
   * Represents an icon to provide when creating a marker.
   *
   * @example
   *
   * ```js
   * var myIcon = L.icon({
   *     iconUrl: 'my-icon.png',
   *     iconRetinaUrl: 'my-icon@2x.png',
   *     iconSize: [38, 95],
   *     iconAnchor: [22, 94],
   *     popupAnchor: [-3, -76],
   *     shadowUrl: 'my-icon-shadow.png',
   *     shadowRetinaUrl: 'my-icon-shadow@2x.png',
   *     shadowSize: [68, 95],
   *     shadowAnchor: [22, 94]
   * });
   *
   * L.marker([50.505, 30.57], {icon: myIcon}).addTo(map);
   * ```
   *
   * `L.Icon.Default` extends `L.Icon` and is the blue icon Leaflet uses for markers by default.
   *
   */


  var Icon = Class.extend({
    /* @section
     * @aka Icon options
     *
     * @option iconUrl: String = null
     * **(required)** The URL to the icon image (absolute or relative to your script path).
     *
     * @option iconRetinaUrl: String = null
     * The URL to a retina sized version of the icon image (absolute or relative to your
     * script path). Used for Retina screen devices.
     *
     * @option iconSize: Point = null
     * Size of the icon image in pixels.
     *
     * @option iconAnchor: Point = null
     * The coordinates of the "tip" of the icon (relative to its top left corner). The icon
     * will be aligned so that this point is at the marker's geographical location. Centered
     * by default if size is specified, also can be set in CSS with negative margins.
     *
     * @option popupAnchor: Point = [0, 0]
     * The coordinates of the point from which popups will "open", relative to the icon anchor.
     *
     * @option tooltipAnchor: Point = [0, 0]
     * The coordinates of the point from which tooltips will "open", relative to the icon anchor.
     *
     * @option shadowUrl: String = null
     * The URL to the icon shadow image. If not specified, no shadow image will be created.
     *
     * @option shadowRetinaUrl: String = null
     *
     * @option shadowSize: Point = null
     * Size of the shadow image in pixels.
     *
     * @option shadowAnchor: Point = null
     * The coordinates of the "tip" of the shadow (relative to its top left corner) (the same
     * as iconAnchor if not specified).
     *
     * @option className: String = ''
     * A custom class name to assign to both icon and shadow images. Empty by default.
     */
    options: {
      popupAnchor: [0, 0],
      tooltipAnchor: [0, 0]
    },
    initialize: function (options) {
      setOptions(this, options);
    },
    // @method createIcon(oldIcon?: HTMLElement): HTMLElement
    // Called internally when the icon has to be shown, returns a `<img>` HTML element
    // styled according to the options.
    createIcon: function (oldIcon) {
      return this._createIcon('icon', oldIcon);
    },
    // @method createShadow(oldIcon?: HTMLElement): HTMLElement
    // As `createIcon`, but for the shadow beneath it.
    createShadow: function (oldIcon) {
      return this._createIcon('shadow', oldIcon);
    },
    _createIcon: function (name, oldIcon) {
      var src = this._getIconUrl(name);

      if (!src) {
        if (name === 'icon') {
          throw new Error('iconUrl not set in Icon options (see the docs).');
        }

        return null;
      }

      var img = this._createImg(src, oldIcon && oldIcon.tagName === 'IMG' ? oldIcon : null);

      this._setIconStyles(img, name);

      return img;
    },
    _setIconStyles: function (img, name) {
      var options = this.options;
      var sizeOption = options[name + 'Size'];

      if (typeof sizeOption === 'number') {
        sizeOption = [sizeOption, sizeOption];
      }

      var size = toPoint(sizeOption),
          anchor = toPoint(name === 'shadow' && options.shadowAnchor || options.iconAnchor || size && size.divideBy(2, true));
      img.className = 'leaflet-marker-' + name + ' ' + (options.className || '');

      if (anchor) {
        img.style.marginLeft = -anchor.x + 'px';
        img.style.marginTop = -anchor.y + 'px';
      }

      if (size) {
        img.style.width = size.x + 'px';
        img.style.height = size.y + 'px';
      }
    },
    _createImg: function (src, el) {
      el = el || document.createElement('img');
      el.src = src;
      return el;
    },
    _getIconUrl: function (name) {
      return retina && this.options[name + 'RetinaUrl'] || this.options[name + 'Url'];
    }
  }); // @factory L.icon(options: Icon options)
  // Creates an icon instance with the given options.

  function icon(options) {
    return new Icon(options);
  }
  /*
   * @miniclass Icon.Default (Icon)
   * @aka L.Icon.Default
   * @section
   *
   * A trivial subclass of `Icon`, represents the icon to use in `Marker`s when
   * no icon is specified. Points to the blue marker image distributed with Leaflet
   * releases.
   *
   * In order to customize the default icon, just change the properties of `L.Icon.Default.prototype.options`
   * (which is a set of `Icon options`).
   *
   * If you want to _completely_ replace the default icon, override the
   * `L.Marker.prototype.options.icon` with your own icon instead.
   */


  var IconDefault = Icon.extend({
    options: {
      iconUrl: 'marker-icon.png',
      iconRetinaUrl: 'marker-icon-2x.png',
      shadowUrl: 'marker-shadow.png',
      iconSize: [25, 41],
      iconAnchor: [12, 41],
      popupAnchor: [1, -34],
      tooltipAnchor: [16, -28],
      shadowSize: [41, 41]
    },
    _getIconUrl: function (name) {
      if (!IconDefault.imagePath) {
        // Deprecated, backwards-compatibility only
        IconDefault.imagePath = this._detectIconPath();
      } // @option imagePath: String
      // `Icon.Default` will try to auto-detect the location of the
      // blue icon images. If you are placing these images in a non-standard
      // way, set this option to point to the right path.


      return (this.options.imagePath || IconDefault.imagePath) + Icon.prototype._getIconUrl.call(this, name);
    },
    _detectIconPath: function () {
      var el = create$1('div', 'leaflet-default-icon-path', document.body);
      var path = getStyle(el, 'background-image') || getStyle(el, 'backgroundImage'); // IE8

      document.body.removeChild(el);

      if (path === null || path.indexOf('url') !== 0) {
        path = '';
      } else {
        path = path.replace(/^url\(["']?/, '').replace(/marker-icon\.png["']?\)$/, '');
      }

      return path;
    }
  });
  /*
   * L.Handler.MarkerDrag is used internally by L.Marker to make the markers draggable.
   */

  /* @namespace Marker
   * @section Interaction handlers
   *
   * Interaction handlers are properties of a marker instance that allow you to control interaction behavior in runtime, enabling or disabling certain features such as dragging (see `Handler` methods). Example:
   *
   * ```js
   * marker.dragging.disable();
   * ```
   *
   * @property dragging: Handler
   * Marker dragging handler (by both mouse and touch). Only valid when the marker is on the map (Otherwise set [`marker.options.draggable`](#marker-draggable)).
   */

  var MarkerDrag = Handler.extend({
    initialize: function (marker) {
      this._marker = marker;
    },
    addHooks: function () {
      var icon = this._marker._icon;

      if (!this._draggable) {
        this._draggable = new Draggable(icon, icon, true);
      }

      this._draggable.on({
        dragstart: this._onDragStart,
        predrag: this._onPreDrag,
        drag: this._onDrag,
        dragend: this._onDragEnd
      }, this).enable();

      addClass(icon, 'leaflet-marker-draggable');
    },
    removeHooks: function () {
      this._draggable.off({
        dragstart: this._onDragStart,
        predrag: this._onPreDrag,
        drag: this._onDrag,
        dragend: this._onDragEnd
      }, this).disable();

      if (this._marker._icon) {
        removeClass(this._marker._icon, 'leaflet-marker-draggable');
      }
    },
    moved: function () {
      return this._draggable && this._draggable._moved;
    },
    _adjustPan: function (e) {
      var marker = this._marker,
          map = marker._map,
          speed = this._marker.options.autoPanSpeed,
          padding = this._marker.options.autoPanPadding,
          iconPos = getPosition(marker._icon),
          bounds = map.getPixelBounds(),
          origin = map.getPixelOrigin();
      var panBounds = toBounds(bounds.min._subtract(origin).add(padding), bounds.max._subtract(origin).subtract(padding));

      if (!panBounds.contains(iconPos)) {
        // Compute incremental movement
        var movement = toPoint((Math.max(panBounds.max.x, iconPos.x) - panBounds.max.x) / (bounds.max.x - panBounds.max.x) - (Math.min(panBounds.min.x, iconPos.x) - panBounds.min.x) / (bounds.min.x - panBounds.min.x), (Math.max(panBounds.max.y, iconPos.y) - panBounds.max.y) / (bounds.max.y - panBounds.max.y) - (Math.min(panBounds.min.y, iconPos.y) - panBounds.min.y) / (bounds.min.y - panBounds.min.y)).multiplyBy(speed);
        map.panBy(movement, {
          animate: false
        });

        this._draggable._newPos._add(movement);

        this._draggable._startPos._add(movement);

        setPosition(marker._icon, this._draggable._newPos);

        this._onDrag(e);

        this._panRequest = requestAnimFrame(this._adjustPan.bind(this, e));
      }
    },
    _onDragStart: function () {
      // @section Dragging events
      // @event dragstart: Event
      // Fired when the user starts dragging the marker.
      // @event movestart: Event
      // Fired when the marker starts moving (because of dragging).
      this._oldLatLng = this._marker.getLatLng();

      this._marker.closePopup().fire('movestart').fire('dragstart');
    },
    _onPreDrag: function (e) {
      if (this._marker.options.autoPan) {
        cancelAnimFrame(this._panRequest);
        this._panRequest = requestAnimFrame(this._adjustPan.bind(this, e));
      }
    },
    _onDrag: function (e) {
      var marker = this._marker,
          shadow = marker._shadow,
          iconPos = getPosition(marker._icon),
          latlng = marker._map.layerPointToLatLng(iconPos); // update shadow position


      if (shadow) {
        setPosition(shadow, iconPos);
      }

      marker._latlng = latlng;
      e.latlng = latlng;
      e.oldLatLng = this._oldLatLng; // @event drag: Event
      // Fired repeatedly while the user drags the marker.

      marker.fire('move', e).fire('drag', e);
    },
    _onDragEnd: function (e) {
      // @event dragend: DragEndEvent
      // Fired when the user stops dragging the marker.
      cancelAnimFrame(this._panRequest); // @event moveend: Event
      // Fired when the marker stops moving (because of dragging).

      delete this._oldLatLng;

      this._marker.fire('moveend').fire('dragend', e);
    }
  });
  /*
   * @class Marker
   * @inherits Interactive layer
   * @aka L.Marker
   * L.Marker is used to display clickable/draggable icons on the map. Extends `Layer`.
   *
   * @example
   *
   * ```js
   * L.marker([50.5, 30.5]).addTo(map);
   * ```
   */

  var Marker = Layer.extend({
    // @section
    // @aka Marker options
    options: {
      // @option icon: Icon = *
      // Icon instance to use for rendering the marker.
      // See [Icon documentation](#L.Icon) for details on how to customize the marker icon.
      // If not specified, a common instance of `L.Icon.Default` is used.
      icon: new IconDefault(),
      // Option inherited from "Interactive layer" abstract class
      interactive: true,
      // @option keyboard: Boolean = true
      // Whether the marker can be tabbed to with a keyboard and clicked by pressing enter.
      keyboard: true,
      // @option title: String = ''
      // Text for the browser tooltip that appear on marker hover (no tooltip by default).
      title: '',
      // @option alt: String = ''
      // Text for the `alt` attribute of the icon image (useful for accessibility).
      alt: '',
      // @option zIndexOffset: Number = 0
      // By default, marker images zIndex is set automatically based on its latitude. Use this option if you want to put the marker on top of all others (or below), specifying a high value like `1000` (or high negative value, respectively).
      zIndexOffset: 0,
      // @option opacity: Number = 1.0
      // The opacity of the marker.
      opacity: 1,
      // @option riseOnHover: Boolean = false
      // If `true`, the marker will get on top of others when you hover the mouse over it.
      riseOnHover: false,
      // @option riseOffset: Number = 250
      // The z-index offset used for the `riseOnHover` feature.
      riseOffset: 250,
      // @option pane: String = 'markerPane'
      // `Map pane` where the markers icon will be added.
      pane: 'markerPane',
      // @option bubblingMouseEvents: Boolean = false
      // When `true`, a mouse event on this marker will trigger the same event on the map
      // (unless [`L.DomEvent.stopPropagation`](#domevent-stoppropagation) is used).
      bubblingMouseEvents: false,
      // @section Draggable marker options
      // @option draggable: Boolean = false
      // Whether the marker is draggable with mouse/touch or not.
      draggable: false,
      // @option autoPan: Boolean = false
      // Whether to pan the map when dragging this marker near its edge or not.
      autoPan: false,
      // @option autoPanPadding: Point = Point(50, 50)
      // Distance (in pixels to the left/right and to the top/bottom) of the
      // map edge to start panning the map.
      autoPanPadding: [50, 50],
      // @option autoPanSpeed: Number = 10
      // Number of pixels the map should pan by.
      autoPanSpeed: 10
    },

    /* @section
     *
     * In addition to [shared layer methods](#Layer) like `addTo()` and `remove()` and [popup methods](#Popup) like bindPopup() you can also use the following methods:
     */
    initialize: function (latlng, options) {
      setOptions(this, options);
      this._latlng = toLatLng(latlng);
    },
    onAdd: function (map) {
      this._zoomAnimated = this._zoomAnimated && map.options.markerZoomAnimation;

      if (this._zoomAnimated) {
        map.on('zoomanim', this._animateZoom, this);
      }

      this._initIcon();

      this.update();
    },
    onRemove: function (map) {
      if (this.dragging && this.dragging.enabled()) {
        this.options.draggable = true;
        this.dragging.removeHooks();
      }

      delete this.dragging;

      if (this._zoomAnimated) {
        map.off('zoomanim', this._animateZoom, this);
      }

      this._removeIcon();

      this._removeShadow();
    },
    getEvents: function () {
      return {
        zoom: this.update,
        viewreset: this.update
      };
    },
    // @method getLatLng: LatLng
    // Returns the current geographical position of the marker.
    getLatLng: function () {
      return this._latlng;
    },
    // @method setLatLng(latlng: LatLng): this
    // Changes the marker position to the given point.
    setLatLng: function (latlng) {
      var oldLatLng = this._latlng;
      this._latlng = toLatLng(latlng);
      this.update(); // @event move: Event
      // Fired when the marker is moved via [`setLatLng`](#marker-setlatlng) or by [dragging](#marker-dragging). Old and new coordinates are included in event arguments as `oldLatLng`, `latlng`.

      return this.fire('move', {
        oldLatLng: oldLatLng,
        latlng: this._latlng
      });
    },
    // @method setZIndexOffset(offset: Number): this
    // Changes the [zIndex offset](#marker-zindexoffset) of the marker.
    setZIndexOffset: function (offset) {
      this.options.zIndexOffset = offset;
      return this.update();
    },
    // @method setIcon(icon: Icon): this
    // Changes the marker icon.
    setIcon: function (icon) {
      this.options.icon = icon;

      if (this._map) {
        this._initIcon();

        this.update();
      }

      if (this._popup) {
        this.bindPopup(this._popup, this._popup.options);
      }

      return this;
    },
    getElement: function () {
      return this._icon;
    },
    update: function () {
      if (this._icon && this._map) {
        var pos = this._map.latLngToLayerPoint(this._latlng).round();

        this._setPos(pos);
      }

      return this;
    },
    _initIcon: function () {
      var options = this.options,
          classToAdd = 'leaflet-zoom-' + (this._zoomAnimated ? 'animated' : 'hide');
      var icon = options.icon.createIcon(this._icon),
          addIcon = false; // if we're not reusing the icon, remove the old one and init new one

      if (icon !== this._icon) {
        if (this._icon) {
          this._removeIcon();
        }

        addIcon = true;

        if (options.title) {
          icon.title = options.title;
        }

        if (icon.tagName === 'IMG') {
          icon.alt = options.alt || '';
        }
      }

      addClass(icon, classToAdd);

      if (options.keyboard) {
        icon.tabIndex = '0';
      }

      this._icon = icon;

      if (options.riseOnHover) {
        this.on({
          mouseover: this._bringToFront,
          mouseout: this._resetZIndex
        });
      }

      var newShadow = options.icon.createShadow(this._shadow),
          addShadow = false;

      if (newShadow !== this._shadow) {
        this._removeShadow();

        addShadow = true;
      }

      if (newShadow) {
        addClass(newShadow, classToAdd);
        newShadow.alt = '';
      }

      this._shadow = newShadow;

      if (options.opacity < 1) {
        this._updateOpacity();
      }

      if (addIcon) {
        this.getPane().appendChild(this._icon);
      }

      this._initInteraction();

      if (newShadow && addShadow) {
        this.getPane('shadowPane').appendChild(this._shadow);
      }
    },
    _removeIcon: function () {
      if (this.options.riseOnHover) {
        this.off({
          mouseover: this._bringToFront,
          mouseout: this._resetZIndex
        });
      }

      remove(this._icon);
      this.removeInteractiveTarget(this._icon);
      this._icon = null;
    },
    _removeShadow: function () {
      if (this._shadow) {
        remove(this._shadow);
      }

      this._shadow = null;
    },
    _setPos: function (pos) {
      setPosition(this._icon, pos);

      if (this._shadow) {
        setPosition(this._shadow, pos);
      }

      this._zIndex = pos.y + this.options.zIndexOffset;

      this._resetZIndex();
    },
    _updateZIndex: function (offset) {
      this._icon.style.zIndex = this._zIndex + offset;
    },
    _animateZoom: function (opt) {
      var pos = this._map._latLngToNewLayerPoint(this._latlng, opt.zoom, opt.center).round();

      this._setPos(pos);
    },
    _initInteraction: function () {
      if (!this.options.interactive) {
        return;
      }

      addClass(this._icon, 'leaflet-interactive');
      this.addInteractiveTarget(this._icon);

      if (MarkerDrag) {
        var draggable = this.options.draggable;

        if (this.dragging) {
          draggable = this.dragging.enabled();
          this.dragging.disable();
        }

        this.dragging = new MarkerDrag(this);

        if (draggable) {
          this.dragging.enable();
        }
      }
    },
    // @method setOpacity(opacity: Number): this
    // Changes the opacity of the marker.
    setOpacity: function (opacity) {
      this.options.opacity = opacity;

      if (this._map) {
        this._updateOpacity();
      }

      return this;
    },
    _updateOpacity: function () {
      var opacity = this.options.opacity;
      setOpacity(this._icon, opacity);

      if (this._shadow) {
        setOpacity(this._shadow, opacity);
      }
    },
    _bringToFront: function () {
      this._updateZIndex(this.options.riseOffset);
    },
    _resetZIndex: function () {
      this._updateZIndex(0);
    },
    _getPopupAnchor: function () {
      return this.options.icon.options.popupAnchor;
    },
    _getTooltipAnchor: function () {
      return this.options.icon.options.tooltipAnchor;
    }
  }); // factory L.marker(latlng: LatLng, options? : Marker options)
  // @factory L.marker(latlng: LatLng, options? : Marker options)
  // Instantiates a Marker object given a geographical point and optionally an options object.

  function marker(latlng, options) {
    return new Marker(latlng, options);
  }
  /*
   * @class Path
   * @aka L.Path
   * @inherits Interactive layer
   *
   * An abstract class that contains options and constants shared between vector
   * overlays (Polygon, Polyline, Circle). Do not use it directly. Extends `Layer`.
   */


  var Path = Layer.extend({
    // @section
    // @aka Path options
    options: {
      // @option stroke: Boolean = true
      // Whether to draw stroke along the path. Set it to `false` to disable borders on polygons or circles.
      stroke: true,
      // @option color: String = '#3388ff'
      // Stroke color
      color: '#3388ff',
      // @option weight: Number = 3
      // Stroke width in pixels
      weight: 3,
      // @option opacity: Number = 1.0
      // Stroke opacity
      opacity: 1,
      // @option lineCap: String= 'round'
      // A string that defines [shape to be used at the end](https://developer.mozilla.org/docs/Web/SVG/Attribute/stroke-linecap) of the stroke.
      lineCap: 'round',
      // @option lineJoin: String = 'round'
      // A string that defines [shape to be used at the corners](https://developer.mozilla.org/docs/Web/SVG/Attribute/stroke-linejoin) of the stroke.
      lineJoin: 'round',
      // @option dashArray: String = null
      // A string that defines the stroke [dash pattern](https://developer.mozilla.org/docs/Web/SVG/Attribute/stroke-dasharray). Doesn't work on `Canvas`-powered layers in [some old browsers](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/setLineDash#Browser_compatibility).
      dashArray: null,
      // @option dashOffset: String = null
      // A string that defines the [distance into the dash pattern to start the dash](https://developer.mozilla.org/docs/Web/SVG/Attribute/stroke-dashoffset). Doesn't work on `Canvas`-powered layers in [some old browsers](https://developer.mozilla.org/docs/Web/API/CanvasRenderingContext2D/setLineDash#Browser_compatibility).
      dashOffset: null,
      // @option fill: Boolean = depends
      // Whether to fill the path with color. Set it to `false` to disable filling on polygons or circles.
      fill: false,
      // @option fillColor: String = *
      // Fill color. Defaults to the value of the [`color`](#path-color) option
      fillColor: null,
      // @option fillOpacity: Number = 0.2
      // Fill opacity.
      fillOpacity: 0.2,
      // @option fillRule: String = 'evenodd'
      // A string that defines [how the inside of a shape](https://developer.mozilla.org/docs/Web/SVG/Attribute/fill-rule) is determined.
      fillRule: 'evenodd',
      // className: '',
      // Option inherited from "Interactive layer" abstract class
      interactive: true,
      // @option bubblingMouseEvents: Boolean = true
      // When `true`, a mouse event on this path will trigger the same event on the map
      // (unless [`L.DomEvent.stopPropagation`](#domevent-stoppropagation) is used).
      bubblingMouseEvents: true
    },
    beforeAdd: function (map) {
      // Renderer is set here because we need to call renderer.getEvents
      // before this.getEvents.
      this._renderer = map.getRenderer(this);
    },
    onAdd: function () {
      this._renderer._initPath(this);

      this._reset();

      this._renderer._addPath(this);
    },
    onRemove: function () {
      this._renderer._removePath(this);
    },
    // @method redraw(): this
    // Redraws the layer. Sometimes useful after you changed the coordinates that the path uses.
    redraw: function () {
      if (this._map) {
        this._renderer._updatePath(this);
      }

      return this;
    },
    // @method setStyle(style: Path options): this
    // Changes the appearance of a Path based on the options in the `Path options` object.
    setStyle: function (style) {
      setOptions(this, style);

      if (this._renderer) {
        this._renderer._updateStyle(this);
      }

      return this;
    },
    // @method bringToFront(): this
    // Brings the layer to the top of all path layers.
    bringToFront: function () {
      if (this._renderer) {
        this._renderer._bringToFront(this);
      }

      return this;
    },
    // @method bringToBack(): this
    // Brings the layer to the bottom of all path layers.
    bringToBack: function () {
      if (this._renderer) {
        this._renderer._bringToBack(this);
      }

      return this;
    },
    getElement: function () {
      return this._path;
    },
    _reset: function () {
      // defined in child classes
      this._project();

      this._update();
    },
    _clickTolerance: function () {
      // used when doing hit detection for Canvas layers
      return (this.options.stroke ? this.options.weight / 2 : 0) + this._renderer.options.tolerance;
    }
  });
  /*
   * @class CircleMarker
   * @aka L.CircleMarker
   * @inherits Path
   *
   * A circle of a fixed size with radius specified in pixels. Extends `Path`.
   */

  var CircleMarker = Path.extend({
    // @section
    // @aka CircleMarker options
    options: {
      fill: true,
      // @option radius: Number = 10
      // Radius of the circle marker, in pixels
      radius: 10
    },
    initialize: function (latlng, options) {
      setOptions(this, options);
      this._latlng = toLatLng(latlng);
      this._radius = this.options.radius;
    },
    // @method setLatLng(latLng: LatLng): this
    // Sets the position of a circle marker to a new location.
    setLatLng: function (latlng) {
      this._latlng = toLatLng(latlng);
      this.redraw();
      return this.fire('move', {
        latlng: this._latlng
      });
    },
    // @method getLatLng(): LatLng
    // Returns the current geographical position of the circle marker
    getLatLng: function () {
      return this._latlng;
    },
    // @method setRadius(radius: Number): this
    // Sets the radius of a circle marker. Units are in pixels.
    setRadius: function (radius) {
      this.options.radius = this._radius = radius;
      return this.redraw();
    },
    // @method getRadius(): Number
    // Returns the current radius of the circle
    getRadius: function () {
      return this._radius;
    },
    setStyle: function (options) {
      var radius = options && options.radius || this._radius;
      Path.prototype.setStyle.call(this, options);
      this.setRadius(radius);
      return this;
    },
    _project: function () {
      this._point = this._map.latLngToLayerPoint(this._latlng);

      this._updateBounds();
    },
    _updateBounds: function () {
      var r = this._radius,
          r2 = this._radiusY || r,
          w = this._clickTolerance(),
          p = [r + w, r2 + w];

      this._pxBounds = new Bounds(this._point.subtract(p), this._point.add(p));
    },
    _update: function () {
      if (this._map) {
        this._updatePath();
      }
    },
    _updatePath: function () {
      this._renderer._updateCircle(this);
    },
    _empty: function () {
      return this._radius && !this._renderer._bounds.intersects(this._pxBounds);
    },
    // Needed by the `Canvas` renderer for interactivity
    _containsPoint: function (p) {
      return p.distanceTo(this._point) <= this._radius + this._clickTolerance();
    }
  }); // @factory L.circleMarker(latlng: LatLng, options?: CircleMarker options)
  // Instantiates a circle marker object given a geographical point, and an optional options object.

  function circleMarker(latlng, options) {
    return new CircleMarker(latlng, options);
  }
  /*
   * @class Circle
   * @aka L.Circle
   * @inherits CircleMarker
   *
   * A class for drawing circle overlays on a map. Extends `CircleMarker`.
   *
   * It's an approximation and starts to diverge from a real circle closer to poles (due to projection distortion).
   *
   * @example
   *
   * ```js
   * L.circle([50.5, 30.5], {radius: 200}).addTo(map);
   * ```
   */


  var Circle = CircleMarker.extend({
    initialize: function (latlng, options, legacyOptions) {
      if (typeof options === 'number') {
        // Backwards compatibility with 0.7.x factory (latlng, radius, options?)
        options = extend({}, legacyOptions, {
          radius: options
        });
      }

      setOptions(this, options);
      this._latlng = toLatLng(latlng);

      if (isNaN(this.options.radius)) {
        throw new Error('Circle radius cannot be NaN');
      } // @section
      // @aka Circle options
      // @option radius: Number; Radius of the circle, in meters.


      this._mRadius = this.options.radius;
    },
    // @method setRadius(radius: Number): this
    // Sets the radius of a circle. Units are in meters.
    setRadius: function (radius) {
      this._mRadius = radius;
      return this.redraw();
    },
    // @method getRadius(): Number
    // Returns the current radius of a circle. Units are in meters.
    getRadius: function () {
      return this._mRadius;
    },
    // @method getBounds(): LatLngBounds
    // Returns the `LatLngBounds` of the path.
    getBounds: function () {
      var half = [this._radius, this._radiusY || this._radius];
      return new LatLngBounds(this._map.layerPointToLatLng(this._point.subtract(half)), this._map.layerPointToLatLng(this._point.add(half)));
    },
    setStyle: Path.prototype.setStyle,
    _project: function () {
      var lng = this._latlng.lng,
          lat = this._latlng.lat,
          map = this._map,
          crs = map.options.crs;

      if (crs.distance === Earth.distance) {
        var d = Math.PI / 180,
            latR = this._mRadius / Earth.R / d,
            top = map.project([lat + latR, lng]),
            bottom = map.project([lat - latR, lng]),
            p = top.add(bottom).divideBy(2),
            lat2 = map.unproject(p).lat,
            lngR = Math.acos((Math.cos(latR * d) - Math.sin(lat * d) * Math.sin(lat2 * d)) / (Math.cos(lat * d) * Math.cos(lat2 * d))) / d;

        if (isNaN(lngR) || lngR === 0) {
          lngR = latR / Math.cos(Math.PI / 180 * lat); // Fallback for edge case, #2425
        }

        this._point = p.subtract(map.getPixelOrigin());
        this._radius = isNaN(lngR) ? 0 : p.x - map.project([lat2, lng - lngR]).x;
        this._radiusY = p.y - top.y;
      } else {
        var latlng2 = crs.unproject(crs.project(this._latlng).subtract([this._mRadius, 0]));
        this._point = map.latLngToLayerPoint(this._latlng);
        this._radius = this._point.x - map.latLngToLayerPoint(latlng2).x;
      }

      this._updateBounds();
    }
  }); // @factory L.circle(latlng: LatLng, options?: Circle options)
  // Instantiates a circle object given a geographical point, and an options object
  // which contains the circle radius.
  // @alternative
  // @factory L.circle(latlng: LatLng, radius: Number, options?: Circle options)
  // Obsolete way of instantiating a circle, for compatibility with 0.7.x code.
  // Do not use in new applications or plugins.

  function circle(latlng, options, legacyOptions) {
    return new Circle(latlng, options, legacyOptions);
  }
  /*
   * @class Polyline
   * @aka L.Polyline
   * @inherits Path
   *
   * A class for drawing polyline overlays on a map. Extends `Path`.
   *
   * @example
   *
   * ```js
   * // create a red polyline from an array of LatLng points
   * var latlngs = [
   * 	[45.51, -122.68],
   * 	[37.77, -122.43],
   * 	[34.04, -118.2]
   * ];
   *
   * var polyline = L.polyline(latlngs, {color: 'red'}).addTo(map);
   *
   * // zoom the map to the polyline
   * map.fitBounds(polyline.getBounds());
   * ```
   *
   * You can also pass a multi-dimensional array to represent a `MultiPolyline` shape:
   *
   * ```js
   * // create a red polyline from an array of arrays of LatLng points
   * var latlngs = [
   * 	[[45.51, -122.68],
   * 	 [37.77, -122.43],
   * 	 [34.04, -118.2]],
   * 	[[40.78, -73.91],
   * 	 [41.83, -87.62],
   * 	 [32.76, -96.72]]
   * ];
   * ```
   */


  var Polyline = Path.extend({
    // @section
    // @aka Polyline options
    options: {
      // @option smoothFactor: Number = 1.0
      // How much to simplify the polyline on each zoom level. More means
      // better performance and smoother look, and less means more accurate representation.
      smoothFactor: 1.0,
      // @option noClip: Boolean = false
      // Disable polyline clipping.
      noClip: false
    },
    initialize: function (latlngs, options) {
      setOptions(this, options);

      this._setLatLngs(latlngs);
    },
    // @method getLatLngs(): LatLng[]
    // Returns an array of the points in the path, or nested arrays of points in case of multi-polyline.
    getLatLngs: function () {
      return this._latlngs;
    },
    // @method setLatLngs(latlngs: LatLng[]): this
    // Replaces all the points in the polyline with the given array of geographical points.
    setLatLngs: function (latlngs) {
      this._setLatLngs(latlngs);

      return this.redraw();
    },
    // @method isEmpty(): Boolean
    // Returns `true` if the Polyline has no LatLngs.
    isEmpty: function () {
      return !this._latlngs.length;
    },
    // @method closestLayerPoint(p: Point): Point
    // Returns the point closest to `p` on the Polyline.
    closestLayerPoint: function (p) {
      var minDistance = Infinity,
          minPoint = null,
          closest = _sqClosestPointOnSegment,
          p1,
          p2;

      for (var j = 0, jLen = this._parts.length; j < jLen; j++) {
        var points = this._parts[j];

        for (var i = 1, len = points.length; i < len; i++) {
          p1 = points[i - 1];
          p2 = points[i];
          var sqDist = closest(p, p1, p2, true);

          if (sqDist < minDistance) {
            minDistance = sqDist;
            minPoint = closest(p, p1, p2);
          }
        }
      }

      if (minPoint) {
        minPoint.distance = Math.sqrt(minDistance);
      }

      return minPoint;
    },
    // @method getCenter(): LatLng
    // Returns the center ([centroid](http://en.wikipedia.org/wiki/Centroid)) of the polyline.
    getCenter: function () {
      // throws error when not yet added to map as this center calculation requires projected coordinates
      if (!this._map) {
        throw new Error('Must add layer to map before using getCenter()');
      }

      var i,
          halfDist,
          segDist,
          dist,
          p1,
          p2,
          ratio,
          points = this._rings[0],
          len = points.length;

      if (!len) {
        return null;
      } // polyline centroid algorithm; only uses the first ring if there are multiple


      for (i = 0, halfDist = 0; i < len - 1; i++) {
        halfDist += points[i].distanceTo(points[i + 1]) / 2;
      } // The line is so small in the current view that all points are on the same pixel.


      if (halfDist === 0) {
        return this._map.layerPointToLatLng(points[0]);
      }

      for (i = 0, dist = 0; i < len - 1; i++) {
        p1 = points[i];
        p2 = points[i + 1];
        segDist = p1.distanceTo(p2);
        dist += segDist;

        if (dist > halfDist) {
          ratio = (dist - halfDist) / segDist;
          return this._map.layerPointToLatLng([p2.x - ratio * (p2.x - p1.x), p2.y - ratio * (p2.y - p1.y)]);
        }
      }
    },
    // @method getBounds(): LatLngBounds
    // Returns the `LatLngBounds` of the path.
    getBounds: function () {
      return this._bounds;
    },
    // @method addLatLng(latlng: LatLng, latlngs? LatLng[]): this
    // Adds a given point to the polyline. By default, adds to the first ring of
    // the polyline in case of a multi-polyline, but can be overridden by passing
    // a specific ring as a LatLng array (that you can earlier access with [`getLatLngs`](#polyline-getlatlngs)).
    addLatLng: function (latlng, latlngs) {
      latlngs = latlngs || this._defaultShape();
      latlng = toLatLng(latlng);
      latlngs.push(latlng);

      this._bounds.extend(latlng);

      return this.redraw();
    },
    _setLatLngs: function (latlngs) {
      this._bounds = new LatLngBounds();
      this._latlngs = this._convertLatLngs(latlngs);
    },
    _defaultShape: function () {
      return isFlat(this._latlngs) ? this._latlngs : this._latlngs[0];
    },
    // recursively convert latlngs input into actual LatLng instances; calculate bounds along the way
    _convertLatLngs: function (latlngs) {
      var result = [],
          flat = isFlat(latlngs);

      for (var i = 0, len = latlngs.length; i < len; i++) {
        if (flat) {
          result[i] = toLatLng(latlngs[i]);

          this._bounds.extend(result[i]);
        } else {
          result[i] = this._convertLatLngs(latlngs[i]);
        }
      }

      return result;
    },
    _project: function () {
      var pxBounds = new Bounds();
      this._rings = [];

      this._projectLatlngs(this._latlngs, this._rings, pxBounds);

      var w = this._clickTolerance(),
          p = new Point(w, w);

      if (this._bounds.isValid() && pxBounds.isValid()) {
        pxBounds.min._subtract(p);

        pxBounds.max._add(p);

        this._pxBounds = pxBounds;
      }
    },
    // recursively turns latlngs into a set of rings with projected coordinates
    _projectLatlngs: function (latlngs, result, projectedBounds) {
      var flat = latlngs[0] instanceof LatLng,
          len = latlngs.length,
          i,
          ring;

      if (flat) {
        ring = [];

        for (i = 0; i < len; i++) {
          ring[i] = this._map.latLngToLayerPoint(latlngs[i]);
          projectedBounds.extend(ring[i]);
        }

        result.push(ring);
      } else {
        for (i = 0; i < len; i++) {
          this._projectLatlngs(latlngs[i], result, projectedBounds);
        }
      }
    },
    // clip polyline by renderer bounds so that we have less to render for performance
    _clipPoints: function () {
      var bounds = this._renderer._bounds;
      this._parts = [];

      if (!this._pxBounds || !this._pxBounds.intersects(bounds)) {
        return;
      }

      if (this.options.noClip) {
        this._parts = this._rings;
        return;
      }

      var parts = this._parts,
          i,
          j,
          k,
          len,
          len2,
          segment,
          points;

      for (i = 0, k = 0, len = this._rings.length; i < len; i++) {
        points = this._rings[i];

        for (j = 0, len2 = points.length; j < len2 - 1; j++) {
          segment = clipSegment(points[j], points[j + 1], bounds, j, true);

          if (!segment) {
            continue;
          }

          parts[k] = parts[k] || [];
          parts[k].push(segment[0]); // if segment goes out of screen, or it's the last one, it's the end of the line part

          if (segment[1] !== points[j + 1] || j === len2 - 2) {
            parts[k].push(segment[1]);
            k++;
          }
        }
      }
    },
    // simplify each clipped part of the polyline for performance
    _simplifyPoints: function () {
      var parts = this._parts,
          tolerance = this.options.smoothFactor;

      for (var i = 0, len = parts.length; i < len; i++) {
        parts[i] = simplify(parts[i], tolerance);
      }
    },
    _update: function () {
      if (!this._map) {
        return;
      }

      this._clipPoints();

      this._simplifyPoints();

      this._updatePath();
    },
    _updatePath: function () {
      this._renderer._updatePoly(this);
    },
    // Needed by the `Canvas` renderer for interactivity
    _containsPoint: function (p, closed) {
      var i,
          j,
          k,
          len,
          len2,
          part,
          w = this._clickTolerance();

      if (!this._pxBounds || !this._pxBounds.contains(p)) {
        return false;
      } // hit detection for polylines


      for (i = 0, len = this._parts.length; i < len; i++) {
        part = this._parts[i];

        for (j = 0, len2 = part.length, k = len2 - 1; j < len2; k = j++) {
          if (!closed && j === 0) {
            continue;
          }

          if (pointToSegmentDistance(p, part[k], part[j]) <= w) {
            return true;
          }
        }
      }

      return false;
    }
  }); // @factory L.polyline(latlngs: LatLng[], options?: Polyline options)
  // Instantiates a polyline object given an array of geographical points and
  // optionally an options object. You can create a `Polyline` object with
  // multiple separate lines (`MultiPolyline`) by passing an array of arrays
  // of geographic points.

  function polyline(latlngs, options) {
    return new Polyline(latlngs, options);
  } // Retrocompat. Allow plugins to support Leaflet versions before and after 1.1.


  Polyline._flat = _flat;
  /*
   * @class Polygon
   * @aka L.Polygon
   * @inherits Polyline
   *
   * A class for drawing polygon overlays on a map. Extends `Polyline`.
   *
   * Note that points you pass when creating a polygon shouldn't have an additional last point equal to the first one — it's better to filter out such points.
   *
   *
   * @example
   *
   * ```js
   * // create a red polygon from an array of LatLng points
   * var latlngs = [[37, -109.05],[41, -109.03],[41, -102.05],[37, -102.04]];
   *
   * var polygon = L.polygon(latlngs, {color: 'red'}).addTo(map);
   *
   * // zoom the map to the polygon
   * map.fitBounds(polygon.getBounds());
   * ```
   *
   * You can also pass an array of arrays of latlngs, with the first array representing the outer shape and the other arrays representing holes in the outer shape:
   *
   * ```js
   * var latlngs = [
   *   [[37, -109.05],[41, -109.03],[41, -102.05],[37, -102.04]], // outer ring
   *   [[37.29, -108.58],[40.71, -108.58],[40.71, -102.50],[37.29, -102.50]] // hole
   * ];
   * ```
   *
   * Additionally, you can pass a multi-dimensional array to represent a MultiPolygon shape.
   *
   * ```js
   * var latlngs = [
   *   [ // first polygon
   *     [[37, -109.05],[41, -109.03],[41, -102.05],[37, -102.04]], // outer ring
   *     [[37.29, -108.58],[40.71, -108.58],[40.71, -102.50],[37.29, -102.50]] // hole
   *   ],
   *   [ // second polygon
   *     [[41, -111.03],[45, -111.04],[45, -104.05],[41, -104.05]]
   *   ]
   * ];
   * ```
   */

  var Polygon = Polyline.extend({
    options: {
      fill: true
    },
    isEmpty: function () {
      return !this._latlngs.length || !this._latlngs[0].length;
    },
    getCenter: function () {
      // throws error when not yet added to map as this center calculation requires projected coordinates
      if (!this._map) {
        throw new Error('Must add layer to map before using getCenter()');
      }

      var i,
          j,
          p1,
          p2,
          f,
          area,
          x,
          y,
          center,
          points = this._rings[0],
          len = points.length;

      if (!len) {
        return null;
      } // polygon centroid algorithm; only uses the first ring if there are multiple


      area = x = y = 0;

      for (i = 0, j = len - 1; i < len; j = i++) {
        p1 = points[i];
        p2 = points[j];
        f = p1.y * p2.x - p2.y * p1.x;
        x += (p1.x + p2.x) * f;
        y += (p1.y + p2.y) * f;
        area += f * 3;
      }

      if (area === 0) {
        // Polygon is so small that all points are on same pixel.
        center = points[0];
      } else {
        center = [x / area, y / area];
      }

      return this._map.layerPointToLatLng(center);
    },
    _convertLatLngs: function (latlngs) {
      var result = Polyline.prototype._convertLatLngs.call(this, latlngs),
          len = result.length; // remove last point if it equals first one


      if (len >= 2 && result[0] instanceof LatLng && result[0].equals(result[len - 1])) {
        result.pop();
      }

      return result;
    },
    _setLatLngs: function (latlngs) {
      Polyline.prototype._setLatLngs.call(this, latlngs);

      if (isFlat(this._latlngs)) {
        this._latlngs = [this._latlngs];
      }
    },
    _defaultShape: function () {
      return isFlat(this._latlngs[0]) ? this._latlngs[0] : this._latlngs[0][0];
    },
    _clipPoints: function () {
      // polygons need a different clipping algorithm so we redefine that
      var bounds = this._renderer._bounds,
          w = this.options.weight,
          p = new Point(w, w); // increase clip padding by stroke width to avoid stroke on clip edges

      bounds = new Bounds(bounds.min.subtract(p), bounds.max.add(p));
      this._parts = [];

      if (!this._pxBounds || !this._pxBounds.intersects(bounds)) {
        return;
      }

      if (this.options.noClip) {
        this._parts = this._rings;
        return;
      }

      for (var i = 0, len = this._rings.length, clipped; i < len; i++) {
        clipped = clipPolygon(this._rings[i], bounds, true);

        if (clipped.length) {
          this._parts.push(clipped);
        }
      }
    },
    _updatePath: function () {
      this._renderer._updatePoly(this, true);
    },
    // Needed by the `Canvas` renderer for interactivity
    _containsPoint: function (p) {
      var inside = false,
          part,
          p1,
          p2,
          i,
          j,
          k,
          len,
          len2;

      if (!this._pxBounds || !this._pxBounds.contains(p)) {
        return false;
      } // ray casting algorithm for detecting if point is in polygon


      for (i = 0, len = this._parts.length; i < len; i++) {
        part = this._parts[i];

        for (j = 0, len2 = part.length, k = len2 - 1; j < len2; k = j++) {
          p1 = part[j];
          p2 = part[k];

          if (p1.y > p.y !== p2.y > p.y && p.x < (p2.x - p1.x) * (p.y - p1.y) / (p2.y - p1.y) + p1.x) {
            inside = !inside;
          }
        }
      } // also check if it's on polygon stroke


      return inside || Polyline.prototype._containsPoint.call(this, p, true);
    }
  }); // @factory L.polygon(latlngs: LatLng[], options?: Polyline options)

  function polygon(latlngs, options) {
    return new Polygon(latlngs, options);
  }
  /*
   * @class GeoJSON
   * @aka L.GeoJSON
   * @inherits FeatureGroup
   *
   * Represents a GeoJSON object or an array of GeoJSON objects. Allows you to parse
   * GeoJSON data and display it on the map. Extends `FeatureGroup`.
   *
   * @example
   *
   * ```js
   * L.geoJSON(data, {
   * 	style: function (feature) {
   * 		return {color: feature.properties.color};
   * 	}
   * }).bindPopup(function (layer) {
   * 	return layer.feature.properties.description;
   * }).addTo(map);
   * ```
   */


  var GeoJSON = FeatureGroup.extend({
    /* @section
     * @aka GeoJSON options
     *
     * @option pointToLayer: Function = *
     * A `Function` defining how GeoJSON points spawn Leaflet layers. It is internally
     * called when data is added, passing the GeoJSON point feature and its `LatLng`.
     * The default is to spawn a default `Marker`:
     * ```js
     * function(geoJsonPoint, latlng) {
     * 	return L.marker(latlng);
     * }
     * ```
     *
     * @option style: Function = *
     * A `Function` defining the `Path options` for styling GeoJSON lines and polygons,
     * called internally when data is added.
     * The default value is to not override any defaults:
     * ```js
     * function (geoJsonFeature) {
     * 	return {}
     * }
     * ```
     *
     * @option onEachFeature: Function = *
     * A `Function` that will be called once for each created `Feature`, after it has
     * been created and styled. Useful for attaching events and popups to features.
     * The default is to do nothing with the newly created layers:
     * ```js
     * function (feature, layer) {}
     * ```
     *
     * @option filter: Function = *
     * A `Function` that will be used to decide whether to include a feature or not.
     * The default is to include all features:
     * ```js
     * function (geoJsonFeature) {
     * 	return true;
     * }
     * ```
     * Note: dynamically changing the `filter` option will have effect only on newly
     * added data. It will _not_ re-evaluate already included features.
     *
     * @option coordsToLatLng: Function = *
     * A `Function` that will be used for converting GeoJSON coordinates to `LatLng`s.
     * The default is the `coordsToLatLng` static method.
     */
    initialize: function (geojson, options) {
      setOptions(this, options);
      this._layers = {};

      if (geojson) {
        this.addData(geojson);
      }
    },
    // @method addData( <GeoJSON> data ): this
    // Adds a GeoJSON object to the layer.
    addData: function (geojson) {
      var features = isArray(geojson) ? geojson : geojson.features,
          i,
          len,
          feature;

      if (features) {
        for (i = 0, len = features.length; i < len; i++) {
          // only add this if geometry or geometries are set and not null
          feature = features[i];

          if (feature.geometries || feature.geometry || feature.features || feature.coordinates) {
            this.addData(feature);
          }
        }

        return this;
      }

      var options = this.options;

      if (options.filter && !options.filter(geojson)) {
        return this;
      }

      var layer = geometryToLayer(geojson, options);

      if (!layer) {
        return this;
      }

      layer.feature = asFeature(geojson);
      layer.defaultOptions = layer.options;
      this.resetStyle(layer);

      if (options.onEachFeature) {
        options.onEachFeature(geojson, layer);
      }

      return this.addLayer(layer);
    },
    // @method resetStyle( <Path> layer ): this
    // Resets the given vector layer's style to the original GeoJSON style, useful for resetting style after hover events.
    resetStyle: function (layer) {
      // reset any custom styles
      layer.options = extend({}, layer.defaultOptions);

      this._setLayerStyle(layer, this.options.style);

      return this;
    },
    // @method setStyle( <Function> style ): this
    // Changes styles of GeoJSON vector layers with the given style function.
    setStyle: function (style) {
      return this.eachLayer(function (layer) {
        this._setLayerStyle(layer, style);
      }, this);
    },
    _setLayerStyle: function (layer, style) {
      if (typeof style === 'function') {
        style = style(layer.feature);
      }

      if (layer.setStyle) {
        layer.setStyle(style);
      }
    }
  }); // @section
  // There are several static functions which can be called without instantiating L.GeoJSON:
  // @function geometryToLayer(featureData: Object, options?: GeoJSON options): Layer
  // Creates a `Layer` from a given GeoJSON feature. Can use a custom
  // [`pointToLayer`](#geojson-pointtolayer) and/or [`coordsToLatLng`](#geojson-coordstolatlng)
  // functions if provided as options.

  function geometryToLayer(geojson, options) {
    var geometry = geojson.type === 'Feature' ? geojson.geometry : geojson,
        coords = geometry ? geometry.coordinates : null,
        layers = [],
        pointToLayer = options && options.pointToLayer,
        _coordsToLatLng = options && options.coordsToLatLng || coordsToLatLng,
        latlng,
        latlngs,
        i,
        len;

    if (!coords && !geometry) {
      return null;
    }

    switch (geometry.type) {
      case 'Point':
        latlng = _coordsToLatLng(coords);
        return pointToLayer ? pointToLayer(geojson, latlng) : new Marker(latlng);

      case 'MultiPoint':
        for (i = 0, len = coords.length; i < len; i++) {
          latlng = _coordsToLatLng(coords[i]);
          layers.push(pointToLayer ? pointToLayer(geojson, latlng) : new Marker(latlng));
        }

        return new FeatureGroup(layers);

      case 'LineString':
      case 'MultiLineString':
        latlngs = coordsToLatLngs(coords, geometry.type === 'LineString' ? 0 : 1, _coordsToLatLng);
        return new Polyline(latlngs, options);

      case 'Polygon':
      case 'MultiPolygon':
        latlngs = coordsToLatLngs(coords, geometry.type === 'Polygon' ? 1 : 2, _coordsToLatLng);
        return new Polygon(latlngs, options);

      case 'GeometryCollection':
        for (i = 0, len = geometry.geometries.length; i < len; i++) {
          var layer = geometryToLayer({
            geometry: geometry.geometries[i],
            type: 'Feature',
            properties: geojson.properties
          }, options);

          if (layer) {
            layers.push(layer);
          }
        }

        return new FeatureGroup(layers);

      default:
        throw new Error('Invalid GeoJSON object.');
    }
  } // @function coordsToLatLng(coords: Array): LatLng
  // Creates a `LatLng` object from an array of 2 numbers (longitude, latitude)
  // or 3 numbers (longitude, latitude, altitude) used in GeoJSON for points.


  function coordsToLatLng(coords) {
    return new LatLng(coords[1], coords[0], coords[2]);
  } // @function coordsToLatLngs(coords: Array, levelsDeep?: Number, coordsToLatLng?: Function): Array
  // Creates a multidimensional array of `LatLng`s from a GeoJSON coordinates array.
  // `levelsDeep` specifies the nesting level (0 is for an array of points, 1 for an array of arrays of points, etc., 0 by default).
  // Can use a custom [`coordsToLatLng`](#geojson-coordstolatlng) function.


  function coordsToLatLngs(coords, levelsDeep, _coordsToLatLng) {
    var latlngs = [];

    for (var i = 0, len = coords.length, latlng; i < len; i++) {
      latlng = levelsDeep ? coordsToLatLngs(coords[i], levelsDeep - 1, _coordsToLatLng) : (_coordsToLatLng || coordsToLatLng)(coords[i]);
      latlngs.push(latlng);
    }

    return latlngs;
  } // @function latLngToCoords(latlng: LatLng, precision?: Number): Array
  // Reverse of [`coordsToLatLng`](#geojson-coordstolatlng)


  function latLngToCoords(latlng, precision) {
    precision = typeof precision === 'number' ? precision : 6;
    return latlng.alt !== undefined ? [formatNum(latlng.lng, precision), formatNum(latlng.lat, precision), formatNum(latlng.alt, precision)] : [formatNum(latlng.lng, precision), formatNum(latlng.lat, precision)];
  } // @function latLngsToCoords(latlngs: Array, levelsDeep?: Number, closed?: Boolean): Array
  // Reverse of [`coordsToLatLngs`](#geojson-coordstolatlngs)
  // `closed` determines whether the first point should be appended to the end of the array to close the feature, only used when `levelsDeep` is 0. False by default.


  function latLngsToCoords(latlngs, levelsDeep, closed, precision) {
    var coords = [];

    for (var i = 0, len = latlngs.length; i < len; i++) {
      coords.push(levelsDeep ? latLngsToCoords(latlngs[i], levelsDeep - 1, closed, precision) : latLngToCoords(latlngs[i], precision));
    }

    if (!levelsDeep && closed) {
      coords.push(coords[0]);
    }

    return coords;
  }

  function getFeature(layer, newGeometry) {
    return layer.feature ? extend({}, layer.feature, {
      geometry: newGeometry
    }) : asFeature(newGeometry);
  } // @function asFeature(geojson: Object): Object
  // Normalize GeoJSON geometries/features into GeoJSON features.


  function asFeature(geojson) {
    if (geojson.type === 'Feature' || geojson.type === 'FeatureCollection') {
      return geojson;
    }

    return {
      type: 'Feature',
      properties: {},
      geometry: geojson
    };
  }

  var PointToGeoJSON = {
    toGeoJSON: function (precision) {
      return getFeature(this, {
        type: 'Point',
        coordinates: latLngToCoords(this.getLatLng(), precision)
      });
    }
  }; // @namespace Marker
  // @method toGeoJSON(): Object
  // Returns a [`GeoJSON`](http://en.wikipedia.org/wiki/GeoJSON) representation of the marker (as a GeoJSON `Point` Feature).

  Marker.include(PointToGeoJSON); // @namespace CircleMarker
  // @method toGeoJSON(): Object
  // Returns a [`GeoJSON`](http://en.wikipedia.org/wiki/GeoJSON) representation of the circle marker (as a GeoJSON `Point` Feature).

  Circle.include(PointToGeoJSON);
  CircleMarker.include(PointToGeoJSON); // @namespace Polyline
  // @method toGeoJSON(): Object
  // Returns a [`GeoJSON`](http://en.wikipedia.org/wiki/GeoJSON) representation of the polyline (as a GeoJSON `LineString` or `MultiLineString` Feature).

  Polyline.include({
    toGeoJSON: function (precision) {
      var multi = !isFlat(this._latlngs);
      var coords = latLngsToCoords(this._latlngs, multi ? 1 : 0, false, precision);
      return getFeature(this, {
        type: (multi ? 'Multi' : '') + 'LineString',
        coordinates: coords
      });
    }
  }); // @namespace Polygon
  // @method toGeoJSON(): Object
  // Returns a [`GeoJSON`](http://en.wikipedia.org/wiki/GeoJSON) representation of the polygon (as a GeoJSON `Polygon` or `MultiPolygon` Feature).

  Polygon.include({
    toGeoJSON: function (precision) {
      var holes = !isFlat(this._latlngs),
          multi = holes && !isFlat(this._latlngs[0]);
      var coords = latLngsToCoords(this._latlngs, multi ? 2 : holes ? 1 : 0, true, precision);

      if (!holes) {
        coords = [coords];
      }

      return getFeature(this, {
        type: (multi ? 'Multi' : '') + 'Polygon',
        coordinates: coords
      });
    }
  }); // @namespace LayerGroup

  LayerGroup.include({
    toMultiPoint: function (precision) {
      var coords = [];
      this.eachLayer(function (layer) {
        coords.push(layer.toGeoJSON(precision).geometry.coordinates);
      });
      return getFeature(this, {
        type: 'MultiPoint',
        coordinates: coords
      });
    },
    // @method toGeoJSON(): Object
    // Returns a [`GeoJSON`](http://en.wikipedia.org/wiki/GeoJSON) representation of the layer group (as a GeoJSON `FeatureCollection`, `GeometryCollection`, or `MultiPoint`).
    toGeoJSON: function (precision) {
      var type = this.feature && this.feature.geometry && this.feature.geometry.type;

      if (type === 'MultiPoint') {
        return this.toMultiPoint(precision);
      }

      var isGeometryCollection = type === 'GeometryCollection',
          jsons = [];
      this.eachLayer(function (layer) {
        if (layer.toGeoJSON) {
          var json = layer.toGeoJSON(precision);

          if (isGeometryCollection) {
            jsons.push(json.geometry);
          } else {
            var feature = asFeature(json); // Squash nested feature collections

            if (feature.type === 'FeatureCollection') {
              jsons.push.apply(jsons, feature.features);
            } else {
              jsons.push(feature);
            }
          }
        }
      });

      if (isGeometryCollection) {
        return getFeature(this, {
          geometries: jsons,
          type: 'GeometryCollection'
        });
      }

      return {
        type: 'FeatureCollection',
        features: jsons
      };
    }
  }); // @namespace GeoJSON
  // @factory L.geoJSON(geojson?: Object, options?: GeoJSON options)
  // Creates a GeoJSON layer. Optionally accepts an object in
  // [GeoJSON format](https://tools.ietf.org/html/rfc7946) to display on the map
  // (you can alternatively add it later with `addData` method) and an `options` object.

  function geoJSON(geojson, options) {
    return new GeoJSON(geojson, options);
  } // Backward compatibility.


  var geoJson = geoJSON;
  /*
   * @class ImageOverlay
   * @aka L.ImageOverlay
   * @inherits Interactive layer
   *
   * Used to load and display a single image over specific bounds of the map. Extends `Layer`.
   *
   * @example
   *
   * ```js
   * var imageUrl = 'http://www.lib.utexas.edu/maps/historical/newark_nj_1922.jpg',
   * 	imageBounds = [[40.712216, -74.22655], [40.773941, -74.12544]];
   * L.imageOverlay(imageUrl, imageBounds).addTo(map);
   * ```
   */

  var ImageOverlay = Layer.extend({
    // @section
    // @aka ImageOverlay options
    options: {
      // @option opacity: Number = 1.0
      // The opacity of the image overlay.
      opacity: 1,
      // @option alt: String = ''
      // Text for the `alt` attribute of the image (useful for accessibility).
      alt: '',
      // @option interactive: Boolean = false
      // If `true`, the image overlay will emit [mouse events](#interactive-layer) when clicked or hovered.
      interactive: false,
      // @option crossOrigin: Boolean|String = false
      // Whether the crossOrigin attribute will be added to the image.
      // If a String is provided, the image will have its crossOrigin attribute set to the String provided. This is needed if you want to access image pixel data.
      // Refer to [CORS Settings](https://developer.mozilla.org/en-US/docs/Web/HTML/CORS_settings_attributes) for valid String values.
      crossOrigin: false,
      // @option errorOverlayUrl: String = ''
      // URL to the overlay image to show in place of the overlay that failed to load.
      errorOverlayUrl: '',
      // @option zIndex: Number = 1
      // The explicit [zIndex](https://developer.mozilla.org/docs/Web/CSS/CSS_Positioning/Understanding_z_index) of the overlay layer.
      zIndex: 1,
      // @option className: String = ''
      // A custom class name to assign to the image. Empty by default.
      className: ''
    },
    initialize: function (url, bounds, options) {
      // (String, LatLngBounds, Object)
      this._url = url;
      this._bounds = toLatLngBounds(bounds);
      setOptions(this, options);
    },
    onAdd: function () {
      if (!this._image) {
        this._initImage();

        if (this.options.opacity < 1) {
          this._updateOpacity();
        }
      }

      if (this.options.interactive) {
        addClass(this._image, 'leaflet-interactive');
        this.addInteractiveTarget(this._image);
      }

      this.getPane().appendChild(this._image);

      this._reset();
    },
    onRemove: function () {
      remove(this._image);

      if (this.options.interactive) {
        this.removeInteractiveTarget(this._image);
      }
    },
    // @method setOpacity(opacity: Number): this
    // Sets the opacity of the overlay.
    setOpacity: function (opacity) {
      this.options.opacity = opacity;

      if (this._image) {
        this._updateOpacity();
      }

      return this;
    },
    setStyle: function (styleOpts) {
      if (styleOpts.opacity) {
        this.setOpacity(styleOpts.opacity);
      }

      return this;
    },
    // @method bringToFront(): this
    // Brings the layer to the top of all overlays.
    bringToFront: function () {
      if (this._map) {
        toFront(this._image);
      }

      return this;
    },
    // @method bringToBack(): this
    // Brings the layer to the bottom of all overlays.
    bringToBack: function () {
      if (this._map) {
        toBack(this._image);
      }

      return this;
    },
    // @method setUrl(url: String): this
    // Changes the URL of the image.
    setUrl: function (url) {
      this._url = url;

      if (this._image) {
        this._image.src = url;
      }

      return this;
    },
    // @method setBounds(bounds: LatLngBounds): this
    // Update the bounds that this ImageOverlay covers
    setBounds: function (bounds) {
      this._bounds = toLatLngBounds(bounds);

      if (this._map) {
        this._reset();
      }

      return this;
    },
    getEvents: function () {
      var events = {
        zoom: this._reset,
        viewreset: this._reset
      };

      if (this._zoomAnimated) {
        events.zoomanim = this._animateZoom;
      }

      return events;
    },
    // @method setZIndex(value: Number): this
    // Changes the [zIndex](#imageoverlay-zindex) of the image overlay.
    setZIndex: function (value) {
      this.options.zIndex = value;

      this._updateZIndex();

      return this;
    },
    // @method getBounds(): LatLngBounds
    // Get the bounds that this ImageOverlay covers
    getBounds: function () {
      return this._bounds;
    },
    // @method getElement(): HTMLElement
    // Returns the instance of [`HTMLImageElement`](https://developer.mozilla.org/docs/Web/API/HTMLImageElement)
    // used by this overlay.
    getElement: function () {
      return this._image;
    },
    _initImage: function () {
      var wasElementSupplied = this._url.tagName === 'IMG';
      var img = this._image = wasElementSupplied ? this._url : create$1('img');
      addClass(img, 'leaflet-image-layer');

      if (this._zoomAnimated) {
        addClass(img, 'leaflet-zoom-animated');
      }

      if (this.options.className) {
        addClass(img, this.options.className);
      }

      img.onselectstart = falseFn;
      img.onmousemove = falseFn; // @event load: Event
      // Fired when the ImageOverlay layer has loaded its image

      img.onload = bind(this.fire, this, 'load');
      img.onerror = bind(this._overlayOnError, this, 'error');

      if (this.options.crossOrigin || this.options.crossOrigin === '') {
        img.crossOrigin = this.options.crossOrigin === true ? '' : this.options.crossOrigin;
      }

      if (this.options.zIndex) {
        this._updateZIndex();
      }

      if (wasElementSupplied) {
        this._url = img.src;
        return;
      }

      img.src = this._url;
      img.alt = this.options.alt;
    },
    _animateZoom: function (e) {
      var scale = this._map.getZoomScale(e.zoom),
          offset = this._map._latLngBoundsToNewLayerBounds(this._bounds, e.zoom, e.center).min;

      setTransform(this._image, offset, scale);
    },
    _reset: function () {
      var image = this._image,
          bounds = new Bounds(this._map.latLngToLayerPoint(this._bounds.getNorthWest()), this._map.latLngToLayerPoint(this._bounds.getSouthEast())),
          size = bounds.getSize();
      setPosition(image, bounds.min);
      image.style.width = size.x + 'px';
      image.style.height = size.y + 'px';
    },
    _updateOpacity: function () {
      setOpacity(this._image, this.options.opacity);
    },
    _updateZIndex: function () {
      if (this._image && this.options.zIndex !== undefined && this.options.zIndex !== null) {
        this._image.style.zIndex = this.options.zIndex;
      }
    },
    _overlayOnError: function () {
      // @event error: Event
      // Fired when the ImageOverlay layer fails to load its image
      this.fire('error');
      var errorUrl = this.options.errorOverlayUrl;

      if (errorUrl && this._url !== errorUrl) {
        this._url = errorUrl;
        this._image.src = errorUrl;
      }
    }
  }); // @factory L.imageOverlay(imageUrl: String, bounds: LatLngBounds, options?: ImageOverlay options)
  // Instantiates an image overlay object given the URL of the image and the
  // geographical bounds it is tied to.

  var imageOverlay = function (url, bounds, options) {
    return new ImageOverlay(url, bounds, options);
  };
  /*
   * @class VideoOverlay
   * @aka L.VideoOverlay
   * @inherits ImageOverlay
   *
   * Used to load and display a video player over specific bounds of the map. Extends `ImageOverlay`.
   *
   * A video overlay uses the [`<video>`](https://developer.mozilla.org/docs/Web/HTML/Element/video)
   * HTML5 element.
   *
   * @example
   *
   * ```js
   * var videoUrl = 'https://www.mapbox.com/bites/00188/patricia_nasa.webm',
   * 	videoBounds = [[ 32, -130], [ 13, -100]];
   * L.videoOverlay(videoUrl, videoBounds ).addTo(map);
   * ```
   */


  var VideoOverlay = ImageOverlay.extend({
    // @section
    // @aka VideoOverlay options
    options: {
      // @option autoplay: Boolean = true
      // Whether the video starts playing automatically when loaded.
      autoplay: true,
      // @option loop: Boolean = true
      // Whether the video will loop back to the beginning when played.
      loop: true
    },
    _initImage: function () {
      var wasElementSupplied = this._url.tagName === 'VIDEO';
      var vid = this._image = wasElementSupplied ? this._url : create$1('video');
      addClass(vid, 'leaflet-image-layer');

      if (this._zoomAnimated) {
        addClass(vid, 'leaflet-zoom-animated');
      }

      vid.onselectstart = falseFn;
      vid.onmousemove = falseFn; // @event load: Event
      // Fired when the video has finished loading the first frame

      vid.onloadeddata = bind(this.fire, this, 'load');

      if (wasElementSupplied) {
        var sourceElements = vid.getElementsByTagName('source');
        var sources = [];

        for (var j = 0; j < sourceElements.length; j++) {
          sources.push(sourceElements[j].src);
        }

        this._url = sourceElements.length > 0 ? sources : [vid.src];
        return;
      }

      if (!isArray(this._url)) {
        this._url = [this._url];
      }

      vid.autoplay = !!this.options.autoplay;
      vid.loop = !!this.options.loop;

      for (var i = 0; i < this._url.length; i++) {
        var source = create$1('source');
        source.src = this._url[i];
        vid.appendChild(source);
      }
    } // @method getElement(): HTMLVideoElement
    // Returns the instance of [`HTMLVideoElement`](https://developer.mozilla.org/docs/Web/API/HTMLVideoElement)
    // used by this overlay.

  }); // @factory L.videoOverlay(video: String|Array|HTMLVideoElement, bounds: LatLngBounds, options?: VideoOverlay options)
  // Instantiates an image overlay object given the URL of the video (or array of URLs, or even a video element) and the
  // geographical bounds it is tied to.

  function videoOverlay(video, bounds, options) {
    return new VideoOverlay(video, bounds, options);
  }
  /*
   * @class DivOverlay
   * @inherits Layer
   * @aka L.DivOverlay
   * Base model for L.Popup and L.Tooltip. Inherit from it for custom popup like plugins.
   */
  // @namespace DivOverlay


  var DivOverlay = Layer.extend({
    // @section
    // @aka DivOverlay options
    options: {
      // @option offset: Point = Point(0, 7)
      // The offset of the popup position. Useful to control the anchor
      // of the popup when opening it on some overlays.
      offset: [0, 7],
      // @option className: String = ''
      // A custom CSS class name to assign to the popup.
      className: '',
      // @option pane: String = 'popupPane'
      // `Map pane` where the popup will be added.
      pane: 'popupPane'
    },
    initialize: function (options, source) {
      setOptions(this, options);
      this._source = source;
    },
    onAdd: function (map) {
      this._zoomAnimated = map._zoomAnimated;

      if (!this._container) {
        this._initLayout();
      }

      if (map._fadeAnimated) {
        setOpacity(this._container, 0);
      }

      clearTimeout(this._removeTimeout);
      this.getPane().appendChild(this._container);
      this.update();

      if (map._fadeAnimated) {
        setOpacity(this._container, 1);
      }

      this.bringToFront();
    },
    onRemove: function (map) {
      if (map._fadeAnimated) {
        setOpacity(this._container, 0);
        this._removeTimeout = setTimeout(bind(remove, undefined, this._container), 200);
      } else {
        remove(this._container);
      }
    },
    // @namespace Popup
    // @method getLatLng: LatLng
    // Returns the geographical point of popup.
    getLatLng: function () {
      return this._latlng;
    },
    // @method setLatLng(latlng: LatLng): this
    // Sets the geographical point where the popup will open.
    setLatLng: function (latlng) {
      this._latlng = toLatLng(latlng);

      if (this._map) {
        this._updatePosition();

        this._adjustPan();
      }

      return this;
    },
    // @method getContent: String|HTMLElement
    // Returns the content of the popup.
    getContent: function () {
      return this._content;
    },
    // @method setContent(htmlContent: String|HTMLElement|Function): this
    // Sets the HTML content of the popup. If a function is passed the source layer will be passed to the function. The function should return a `String` or `HTMLElement` to be used in the popup.
    setContent: function (content) {
      this._content = content;
      this.update();
      return this;
    },
    // @method getElement: String|HTMLElement
    // Alias for [getContent()](#popup-getcontent)
    getElement: function () {
      return this._container;
    },
    // @method update: null
    // Updates the popup content, layout and position. Useful for updating the popup after something inside changed, e.g. image loaded.
    update: function () {
      if (!this._map) {
        return;
      }

      this._container.style.visibility = 'hidden';

      this._updateContent();

      this._updateLayout();

      this._updatePosition();

      this._container.style.visibility = '';

      this._adjustPan();
    },
    getEvents: function () {
      var events = {
        zoom: this._updatePosition,
        viewreset: this._updatePosition
      };

      if (this._zoomAnimated) {
        events.zoomanim = this._animateZoom;
      }

      return events;
    },
    // @method isOpen: Boolean
    // Returns `true` when the popup is visible on the map.
    isOpen: function () {
      return !!this._map && this._map.hasLayer(this);
    },
    // @method bringToFront: this
    // Brings this popup in front of other popups (in the same map pane).
    bringToFront: function () {
      if (this._map) {
        toFront(this._container);
      }

      return this;
    },
    // @method bringToBack: this
    // Brings this popup to the back of other popups (in the same map pane).
    bringToBack: function () {
      if (this._map) {
        toBack(this._container);
      }

      return this;
    },
    _updateContent: function () {
      if (!this._content) {
        return;
      }

      var node = this._contentNode;
      var content = typeof this._content === 'function' ? this._content(this._source || this) : this._content;

      if (typeof content === 'string') {
        node.innerHTML = content;
      } else {
        while (node.hasChildNodes()) {
          node.removeChild(node.firstChild);
        }

        node.appendChild(content);
      }

      this.fire('contentupdate');
    },
    _updatePosition: function () {
      if (!this._map) {
        return;
      }

      var pos = this._map.latLngToLayerPoint(this._latlng),
          offset = toPoint(this.options.offset),
          anchor = this._getAnchor();

      if (this._zoomAnimated) {
        setPosition(this._container, pos.add(anchor));
      } else {
        offset = offset.add(pos).add(anchor);
      }

      var bottom = this._containerBottom = -offset.y,
          left = this._containerLeft = -Math.round(this._containerWidth / 2) + offset.x; // bottom position the popup in case the height of the popup changes (images loading etc)

      this._container.style.bottom = bottom + 'px';
      this._container.style.left = left + 'px';
    },
    _getAnchor: function () {
      return [0, 0];
    }
  });
  /*
   * @class Popup
   * @inherits DivOverlay
   * @aka L.Popup
   * Used to open popups in certain places of the map. Use [Map.openPopup](#map-openpopup) to
   * open popups while making sure that only one popup is open at one time
   * (recommended for usability), or use [Map.addLayer](#map-addlayer) to open as many as you want.
   *
   * @example
   *
   * If you want to just bind a popup to marker click and then open it, it's really easy:
   *
   * ```js
   * marker.bindPopup(popupContent).openPopup();
   * ```
   * Path overlays like polylines also have a `bindPopup` method.
   * Here's a more complicated way to open a popup on a map:
   *
   * ```js
   * var popup = L.popup()
   * 	.setLatLng(latlng)
   * 	.setContent('<p>Hello world!<br />This is a nice popup.</p>')
   * 	.openOn(map);
   * ```
   */
  // @namespace Popup

  var Popup = DivOverlay.extend({
    // @section
    // @aka Popup options
    options: {
      // @option maxWidth: Number = 300
      // Max width of the popup, in pixels.
      maxWidth: 300,
      // @option minWidth: Number = 50
      // Min width of the popup, in pixels.
      minWidth: 50,
      // @option maxHeight: Number = null
      // If set, creates a scrollable container of the given height
      // inside a popup if its content exceeds it.
      maxHeight: null,
      // @option autoPan: Boolean = true
      // Set it to `false` if you don't want the map to do panning animation
      // to fit the opened popup.
      autoPan: true,
      // @option autoPanPaddingTopLeft: Point = null
      // The margin between the popup and the top left corner of the map
      // view after autopanning was performed.
      autoPanPaddingTopLeft: null,
      // @option autoPanPaddingBottomRight: Point = null
      // The margin between the popup and the bottom right corner of the map
      // view after autopanning was performed.
      autoPanPaddingBottomRight: null,
      // @option autoPanPadding: Point = Point(5, 5)
      // Equivalent of setting both top left and bottom right autopan padding to the same value.
      autoPanPadding: [5, 5],
      // @option keepInView: Boolean = false
      // Set it to `true` if you want to prevent users from panning the popup
      // off of the screen while it is open.
      keepInView: false,
      // @option closeButton: Boolean = true
      // Controls the presence of a close button in the popup.
      closeButton: true,
      // @option autoClose: Boolean = true
      // Set it to `false` if you want to override the default behavior of
      // the popup closing when another popup is opened.
      autoClose: true,
      // @option closeOnEscapeKey: Boolean = true
      // Set it to `false` if you want to override the default behavior of
      // the ESC key for closing of the popup.
      closeOnEscapeKey: true,
      // @option closeOnClick: Boolean = *
      // Set it if you want to override the default behavior of the popup closing when user clicks
      // on the map. Defaults to the map's [`closePopupOnClick`](#map-closepopuponclick) option.
      // @option className: String = ''
      // A custom CSS class name to assign to the popup.
      className: ''
    },
    // @namespace Popup
    // @method openOn(map: Map): this
    // Adds the popup to the map and closes the previous one. The same as `map.openPopup(popup)`.
    openOn: function (map) {
      map.openPopup(this);
      return this;
    },
    onAdd: function (map) {
      DivOverlay.prototype.onAdd.call(this, map); // @namespace Map
      // @section Popup events
      // @event popupopen: PopupEvent
      // Fired when a popup is opened in the map

      map.fire('popupopen', {
        popup: this
      });

      if (this._source) {
        // @namespace Layer
        // @section Popup events
        // @event popupopen: PopupEvent
        // Fired when a popup bound to this layer is opened
        this._source.fire('popupopen', {
          popup: this
        }, true); // For non-path layers, we toggle the popup when clicking
        // again the layer, so prevent the map to reopen it.


        if (!(this._source instanceof Path)) {
          this._source.on('preclick', stopPropagation);
        }
      }
    },
    onRemove: function (map) {
      DivOverlay.prototype.onRemove.call(this, map); // @namespace Map
      // @section Popup events
      // @event popupclose: PopupEvent
      // Fired when a popup in the map is closed

      map.fire('popupclose', {
        popup: this
      });

      if (this._source) {
        // @namespace Layer
        // @section Popup events
        // @event popupclose: PopupEvent
        // Fired when a popup bound to this layer is closed
        this._source.fire('popupclose', {
          popup: this
        }, true);

        if (!(this._source instanceof Path)) {
          this._source.off('preclick', stopPropagation);
        }
      }
    },
    getEvents: function () {
      var events = DivOverlay.prototype.getEvents.call(this);

      if (this.options.closeOnClick !== undefined ? this.options.closeOnClick : this._map.options.closePopupOnClick) {
        events.preclick = this._close;
      }

      if (this.options.keepInView) {
        events.moveend = this._adjustPan;
      }

      return events;
    },
    _close: function () {
      if (this._map) {
        this._map.closePopup(this);
      }
    },
    _initLayout: function () {
      var prefix = 'leaflet-popup',
          container = this._container = create$1('div', prefix + ' ' + (this.options.className || '') + ' leaflet-zoom-animated');
      var wrapper = this._wrapper = create$1('div', prefix + '-content-wrapper', container);
      this._contentNode = create$1('div', prefix + '-content', wrapper);
      disableClickPropagation(wrapper);
      disableScrollPropagation(this._contentNode);
      on(wrapper, 'contextmenu', stopPropagation);
      this._tipContainer = create$1('div', prefix + '-tip-container', container);
      this._tip = create$1('div', prefix + '-tip', this._tipContainer);

      if (this.options.closeButton) {
        var closeButton = this._closeButton = create$1('a', prefix + '-close-button', container);
        closeButton.href = '#close';
        closeButton.innerHTML = '&#215;';
        on(closeButton, 'click', this._onCloseButtonClick, this);
      }
    },
    _updateLayout: function () {
      var container = this._contentNode,
          style = container.style;
      style.width = '';
      style.whiteSpace = 'nowrap';
      var width = container.offsetWidth;
      width = Math.min(width, this.options.maxWidth);
      width = Math.max(width, this.options.minWidth);
      style.width = width + 1 + 'px';
      style.whiteSpace = '';
      style.height = '';
      var height = container.offsetHeight,
          maxHeight = this.options.maxHeight,
          scrolledClass = 'leaflet-popup-scrolled';

      if (maxHeight && height > maxHeight) {
        style.height = maxHeight + 'px';
        addClass(container, scrolledClass);
      } else {
        removeClass(container, scrolledClass);
      }

      this._containerWidth = this._container.offsetWidth;
    },
    _animateZoom: function (e) {
      var pos = this._map._latLngToNewLayerPoint(this._latlng, e.zoom, e.center),
          anchor = this._getAnchor();

      setPosition(this._container, pos.add(anchor));
    },
    _adjustPan: function () {
      if (!this.options.autoPan) {
        return;
      }

      if (this._map._panAnim) {
        this._map._panAnim.stop();
      }

      var map = this._map,
          marginBottom = parseInt(getStyle(this._container, 'marginBottom'), 10) || 0,
          containerHeight = this._container.offsetHeight + marginBottom,
          containerWidth = this._containerWidth,
          layerPos = new Point(this._containerLeft, -containerHeight - this._containerBottom);

      layerPos._add(getPosition(this._container));

      var containerPos = map.layerPointToContainerPoint(layerPos),
          padding = toPoint(this.options.autoPanPadding),
          paddingTL = toPoint(this.options.autoPanPaddingTopLeft || padding),
          paddingBR = toPoint(this.options.autoPanPaddingBottomRight || padding),
          size = map.getSize(),
          dx = 0,
          dy = 0;

      if (containerPos.x + containerWidth + paddingBR.x > size.x) {
        // right
        dx = containerPos.x + containerWidth - size.x + paddingBR.x;
      }

      if (containerPos.x - dx - paddingTL.x < 0) {
        // left
        dx = containerPos.x - paddingTL.x;
      }

      if (containerPos.y + containerHeight + paddingBR.y > size.y) {
        // bottom
        dy = containerPos.y + containerHeight - size.y + paddingBR.y;
      }

      if (containerPos.y - dy - paddingTL.y < 0) {
        // top
        dy = containerPos.y - paddingTL.y;
      } // @namespace Map
      // @section Popup events
      // @event autopanstart: Event
      // Fired when the map starts autopanning when opening a popup.


      if (dx || dy) {
        map.fire('autopanstart').panBy([dx, dy]);
      }
    },
    _onCloseButtonClick: function (e) {
      this._close();

      stop(e);
    },
    _getAnchor: function () {
      // Where should we anchor the popup on the source layer?
      return toPoint(this._source && this._source._getPopupAnchor ? this._source._getPopupAnchor() : [0, 0]);
    }
  }); // @namespace Popup
  // @factory L.popup(options?: Popup options, source?: Layer)
  // Instantiates a `Popup` object given an optional `options` object that describes its appearance and location and an optional `source` object that is used to tag the popup with a reference to the Layer to which it refers.

  var popup = function (options, source) {
    return new Popup(options, source);
  };
  /* @namespace Map
   * @section Interaction Options
   * @option closePopupOnClick: Boolean = true
   * Set it to `false` if you don't want popups to close when user clicks the map.
   */


  Map.mergeOptions({
    closePopupOnClick: true
  }); // @namespace Map
  // @section Methods for Layers and Controls

  Map.include({
    // @method openPopup(popup: Popup): this
    // Opens the specified popup while closing the previously opened (to make sure only one is opened at one time for usability).
    // @alternative
    // @method openPopup(content: String|HTMLElement, latlng: LatLng, options?: Popup options): this
    // Creates a popup with the specified content and options and opens it in the given point on a map.
    openPopup: function (popup, latlng, options) {
      if (!(popup instanceof Popup)) {
        popup = new Popup(options).setContent(popup);
      }

      if (latlng) {
        popup.setLatLng(latlng);
      }

      if (this.hasLayer(popup)) {
        return this;
      }

      if (this._popup && this._popup.options.autoClose) {
        this.closePopup();
      }

      this._popup = popup;
      return this.addLayer(popup);
    },
    // @method closePopup(popup?: Popup): this
    // Closes the popup previously opened with [openPopup](#map-openpopup) (or the given one).
    closePopup: function (popup) {
      if (!popup || popup === this._popup) {
        popup = this._popup;
        this._popup = null;
      }

      if (popup) {
        this.removeLayer(popup);
      }

      return this;
    }
  });
  /*
   * @namespace Layer
   * @section Popup methods example
   *
   * All layers share a set of methods convenient for binding popups to it.
   *
   * ```js
   * var layer = L.Polygon(latlngs).bindPopup('Hi There!').addTo(map);
   * layer.openPopup();
   * layer.closePopup();
   * ```
   *
   * Popups will also be automatically opened when the layer is clicked on and closed when the layer is removed from the map or another popup is opened.
   */
  // @section Popup methods

  Layer.include({
    // @method bindPopup(content: String|HTMLElement|Function|Popup, options?: Popup options): this
    // Binds a popup to the layer with the passed `content` and sets up the
    // necessary event listeners. If a `Function` is passed it will receive
    // the layer as the first argument and should return a `String` or `HTMLElement`.
    bindPopup: function (content, options) {
      if (content instanceof Popup) {
        setOptions(content, options);
        this._popup = content;
        content._source = this;
      } else {
        if (!this._popup || options) {
          this._popup = new Popup(options, this);
        }

        this._popup.setContent(content);
      }

      if (!this._popupHandlersAdded) {
        this.on({
          click: this._openPopup,
          keypress: this._onKeyPress,
          remove: this.closePopup,
          move: this._movePopup
        });
        this._popupHandlersAdded = true;
      }

      return this;
    },
    // @method unbindPopup(): this
    // Removes the popup previously bound with `bindPopup`.
    unbindPopup: function () {
      if (this._popup) {
        this.off({
          click: this._openPopup,
          keypress: this._onKeyPress,
          remove: this.closePopup,
          move: this._movePopup
        });
        this._popupHandlersAdded = false;
        this._popup = null;
      }

      return this;
    },
    // @method openPopup(latlng?: LatLng): this
    // Opens the bound popup at the specified `latlng` or at the default popup anchor if no `latlng` is passed.
    openPopup: function (layer, latlng) {
      if (!(layer instanceof Layer)) {
        latlng = layer;
        layer = this;
      }

      if (layer instanceof FeatureGroup) {
        for (var id in this._layers) {
          layer = this._layers[id];
          break;
        }
      }

      if (!latlng) {
        latlng = layer.getCenter ? layer.getCenter() : layer.getLatLng();
      }

      if (this._popup && this._map) {
        // set popup source to this layer
        this._popup._source = layer; // update the popup (content, layout, ect...)

        this._popup.update(); // open the popup on the map


        this._map.openPopup(this._popup, latlng);
      }

      return this;
    },
    // @method closePopup(): this
    // Closes the popup bound to this layer if it is open.
    closePopup: function () {
      if (this._popup) {
        this._popup._close();
      }

      return this;
    },
    // @method togglePopup(): this
    // Opens or closes the popup bound to this layer depending on its current state.
    togglePopup: function (target) {
      if (this._popup) {
        if (this._popup._map) {
          this.closePopup();
        } else {
          this.openPopup(target);
        }
      }

      return this;
    },
    // @method isPopupOpen(): boolean
    // Returns `true` if the popup bound to this layer is currently open.
    isPopupOpen: function () {
      return this._popup ? this._popup.isOpen() : false;
    },
    // @method setPopupContent(content: String|HTMLElement|Popup): this
    // Sets the content of the popup bound to this layer.
    setPopupContent: function (content) {
      if (this._popup) {
        this._popup.setContent(content);
      }

      return this;
    },
    // @method getPopup(): Popup
    // Returns the popup bound to this layer.
    getPopup: function () {
      return this._popup;
    },
    _openPopup: function (e) {
      var layer = e.layer || e.target;

      if (!this._popup) {
        return;
      }

      if (!this._map) {
        return;
      } // prevent map click


      stop(e); // if this inherits from Path its a vector and we can just
      // open the popup at the new location

      if (layer instanceof Path) {
        this.openPopup(e.layer || e.target, e.latlng);
        return;
      } // otherwise treat it like a marker and figure out
      // if we should toggle it open/closed


      if (this._map.hasLayer(this._popup) && this._popup._source === layer) {
        this.closePopup();
      } else {
        this.openPopup(layer, e.latlng);
      }
    },
    _movePopup: function (e) {
      this._popup.setLatLng(e.latlng);
    },
    _onKeyPress: function (e) {
      if (e.originalEvent.keyCode === 13) {
        this._openPopup(e);
      }
    }
  });
  /*
   * @class Tooltip
   * @inherits DivOverlay
   * @aka L.Tooltip
   * Used to display small texts on top of map layers.
   *
   * @example
   *
   * ```js
   * marker.bindTooltip("my tooltip text").openTooltip();
   * ```
   * Note about tooltip offset. Leaflet takes two options in consideration
   * for computing tooltip offsetting:
   * - the `offset` Tooltip option: it defaults to [0, 0], and it's specific to one tooltip.
   *   Add a positive x offset to move the tooltip to the right, and a positive y offset to
   *   move it to the bottom. Negatives will move to the left and top.
   * - the `tooltipAnchor` Icon option: this will only be considered for Marker. You
   *   should adapt this value if you use a custom icon.
   */
  // @namespace Tooltip

  var Tooltip = DivOverlay.extend({
    // @section
    // @aka Tooltip options
    options: {
      // @option pane: String = 'tooltipPane'
      // `Map pane` where the tooltip will be added.
      pane: 'tooltipPane',
      // @option offset: Point = Point(0, 0)
      // Optional offset of the tooltip position.
      offset: [0, 0],
      // @option direction: String = 'auto'
      // Direction where to open the tooltip. Possible values are: `right`, `left`,
      // `top`, `bottom`, `center`, `auto`.
      // `auto` will dynamically switch between `right` and `left` according to the tooltip
      // position on the map.
      direction: 'auto',
      // @option permanent: Boolean = false
      // Whether to open the tooltip permanently or only on mouseover.
      permanent: false,
      // @option sticky: Boolean = false
      // If true, the tooltip will follow the mouse instead of being fixed at the feature center.
      sticky: false,
      // @option interactive: Boolean = false
      // If true, the tooltip will listen to the feature events.
      interactive: false,
      // @option opacity: Number = 0.9
      // Tooltip container opacity.
      opacity: 0.9
    },
    onAdd: function (map) {
      DivOverlay.prototype.onAdd.call(this, map);
      this.setOpacity(this.options.opacity); // @namespace Map
      // @section Tooltip events
      // @event tooltipopen: TooltipEvent
      // Fired when a tooltip is opened in the map.

      map.fire('tooltipopen', {
        tooltip: this
      });

      if (this._source) {
        // @namespace Layer
        // @section Tooltip events
        // @event tooltipopen: TooltipEvent
        // Fired when a tooltip bound to this layer is opened.
        this._source.fire('tooltipopen', {
          tooltip: this
        }, true);
      }
    },
    onRemove: function (map) {
      DivOverlay.prototype.onRemove.call(this, map); // @namespace Map
      // @section Tooltip events
      // @event tooltipclose: TooltipEvent
      // Fired when a tooltip in the map is closed.

      map.fire('tooltipclose', {
        tooltip: this
      });

      if (this._source) {
        // @namespace Layer
        // @section Tooltip events
        // @event tooltipclose: TooltipEvent
        // Fired when a tooltip bound to this layer is closed.
        this._source.fire('tooltipclose', {
          tooltip: this
        }, true);
      }
    },
    getEvents: function () {
      var events = DivOverlay.prototype.getEvents.call(this);

      if (touch && !this.options.permanent) {
        events.preclick = this._close;
      }

      return events;
    },
    _close: function () {
      if (this._map) {
        this._map.closeTooltip(this);
      }
    },
    _initLayout: function () {
      var prefix = 'leaflet-tooltip',
          className = prefix + ' ' + (this.options.className || '') + ' leaflet-zoom-' + (this._zoomAnimated ? 'animated' : 'hide');
      this._contentNode = this._container = create$1('div', className);
    },
    _updateLayout: function () {},
    _adjustPan: function () {},
    _setPosition: function (pos) {
      var map = this._map,
          container = this._container,
          centerPoint = map.latLngToContainerPoint(map.getCenter()),
          tooltipPoint = map.layerPointToContainerPoint(pos),
          direction = this.options.direction,
          tooltipWidth = container.offsetWidth,
          tooltipHeight = container.offsetHeight,
          offset = toPoint(this.options.offset),
          anchor = this._getAnchor();

      if (direction === 'top') {
        pos = pos.add(toPoint(-tooltipWidth / 2 + offset.x, -tooltipHeight + offset.y + anchor.y, true));
      } else if (direction === 'bottom') {
        pos = pos.subtract(toPoint(tooltipWidth / 2 - offset.x, -offset.y, true));
      } else if (direction === 'center') {
        pos = pos.subtract(toPoint(tooltipWidth / 2 + offset.x, tooltipHeight / 2 - anchor.y + offset.y, true));
      } else if (direction === 'right' || direction === 'auto' && tooltipPoint.x < centerPoint.x) {
        direction = 'right';
        pos = pos.add(toPoint(offset.x + anchor.x, anchor.y - tooltipHeight / 2 + offset.y, true));
      } else {
        direction = 'left';
        pos = pos.subtract(toPoint(tooltipWidth + anchor.x - offset.x, tooltipHeight / 2 - anchor.y - offset.y, true));
      }

      removeClass(container, 'leaflet-tooltip-right');
      removeClass(container, 'leaflet-tooltip-left');
      removeClass(container, 'leaflet-tooltip-top');
      removeClass(container, 'leaflet-tooltip-bottom');
      addClass(container, 'leaflet-tooltip-' + direction);
      setPosition(container, pos);
    },
    _updatePosition: function () {
      var pos = this._map.latLngToLayerPoint(this._latlng);

      this._setPosition(pos);
    },
    setOpacity: function (opacity) {
      this.options.opacity = opacity;

      if (this._container) {
        setOpacity(this._container, opacity);
      }
    },
    _animateZoom: function (e) {
      var pos = this._map._latLngToNewLayerPoint(this._latlng, e.zoom, e.center);

      this._setPosition(pos);
    },
    _getAnchor: function () {
      // Where should we anchor the tooltip on the source layer?
      return toPoint(this._source && this._source._getTooltipAnchor && !this.options.sticky ? this._source._getTooltipAnchor() : [0, 0]);
    }
  }); // @namespace Tooltip
  // @factory L.tooltip(options?: Tooltip options, source?: Layer)
  // Instantiates a Tooltip object given an optional `options` object that describes its appearance and location and an optional `source` object that is used to tag the tooltip with a reference to the Layer to which it refers.

  var tooltip = function (options, source) {
    return new Tooltip(options, source);
  }; // @namespace Map
  // @section Methods for Layers and Controls


  Map.include({
    // @method openTooltip(tooltip: Tooltip): this
    // Opens the specified tooltip.
    // @alternative
    // @method openTooltip(content: String|HTMLElement, latlng: LatLng, options?: Tooltip options): this
    // Creates a tooltip with the specified content and options and open it.
    openTooltip: function (tooltip, latlng, options) {
      if (!(tooltip instanceof Tooltip)) {
        tooltip = new Tooltip(options).setContent(tooltip);
      }

      if (latlng) {
        tooltip.setLatLng(latlng);
      }

      if (this.hasLayer(tooltip)) {
        return this;
      }

      return this.addLayer(tooltip);
    },
    // @method closeTooltip(tooltip?: Tooltip): this
    // Closes the tooltip given as parameter.
    closeTooltip: function (tooltip) {
      if (tooltip) {
        this.removeLayer(tooltip);
      }

      return this;
    }
  });
  /*
   * @namespace Layer
   * @section Tooltip methods example
   *
   * All layers share a set of methods convenient for binding tooltips to it.
   *
   * ```js
   * var layer = L.Polygon(latlngs).bindTooltip('Hi There!').addTo(map);
   * layer.openTooltip();
   * layer.closeTooltip();
   * ```
   */
  // @section Tooltip methods

  Layer.include({
    // @method bindTooltip(content: String|HTMLElement|Function|Tooltip, options?: Tooltip options): this
    // Binds a tooltip to the layer with the passed `content` and sets up the
    // necessary event listeners. If a `Function` is passed it will receive
    // the layer as the first argument and should return a `String` or `HTMLElement`.
    bindTooltip: function (content, options) {
      if (content instanceof Tooltip) {
        setOptions(content, options);
        this._tooltip = content;
        content._source = this;
      } else {
        if (!this._tooltip || options) {
          this._tooltip = new Tooltip(options, this);
        }

        this._tooltip.setContent(content);
      }

      this._initTooltipInteractions();

      if (this._tooltip.options.permanent && this._map && this._map.hasLayer(this)) {
        this.openTooltip();
      }

      return this;
    },
    // @method unbindTooltip(): this
    // Removes the tooltip previously bound with `bindTooltip`.
    unbindTooltip: function () {
      if (this._tooltip) {
        this._initTooltipInteractions(true);

        this.closeTooltip();
        this._tooltip = null;
      }

      return this;
    },
    _initTooltipInteractions: function (remove$$1) {
      if (!remove$$1 && this._tooltipHandlersAdded) {
        return;
      }

      var onOff = remove$$1 ? 'off' : 'on',
          events = {
        remove: this.closeTooltip,
        move: this._moveTooltip
      };

      if (!this._tooltip.options.permanent) {
        events.mouseover = this._openTooltip;
        events.mouseout = this.closeTooltip;

        if (this._tooltip.options.sticky) {
          events.mousemove = this._moveTooltip;
        }

        if (touch) {
          events.click = this._openTooltip;
        }
      } else {
        events.add = this._openTooltip;
      }

      this[onOff](events);
      this._tooltipHandlersAdded = !remove$$1;
    },
    // @method openTooltip(latlng?: LatLng): this
    // Opens the bound tooltip at the specified `latlng` or at the default tooltip anchor if no `latlng` is passed.
    openTooltip: function (layer, latlng) {
      if (!(layer instanceof Layer)) {
        latlng = layer;
        layer = this;
      }

      if (layer instanceof FeatureGroup) {
        for (var id in this._layers) {
          layer = this._layers[id];
          break;
        }
      }

      if (!latlng) {
        latlng = layer.getCenter ? layer.getCenter() : layer.getLatLng();
      }

      if (this._tooltip && this._map) {
        // set tooltip source to this layer
        this._tooltip._source = layer; // update the tooltip (content, layout, ect...)

        this._tooltip.update(); // open the tooltip on the map


        this._map.openTooltip(this._tooltip, latlng); // Tooltip container may not be defined if not permanent and never
        // opened.


        if (this._tooltip.options.interactive && this._tooltip._container) {
          addClass(this._tooltip._container, 'leaflet-clickable');
          this.addInteractiveTarget(this._tooltip._container);
        }
      }

      return this;
    },
    // @method closeTooltip(): this
    // Closes the tooltip bound to this layer if it is open.
    closeTooltip: function () {
      if (this._tooltip) {
        this._tooltip._close();

        if (this._tooltip.options.interactive && this._tooltip._container) {
          removeClass(this._tooltip._container, 'leaflet-clickable');
          this.removeInteractiveTarget(this._tooltip._container);
        }
      }

      return this;
    },
    // @method toggleTooltip(): this
    // Opens or closes the tooltip bound to this layer depending on its current state.
    toggleTooltip: function (target) {
      if (this._tooltip) {
        if (this._tooltip._map) {
          this.closeTooltip();
        } else {
          this.openTooltip(target);
        }
      }

      return this;
    },
    // @method isTooltipOpen(): boolean
    // Returns `true` if the tooltip bound to this layer is currently open.
    isTooltipOpen: function () {
      return this._tooltip.isOpen();
    },
    // @method setTooltipContent(content: String|HTMLElement|Tooltip): this
    // Sets the content of the tooltip bound to this layer.
    setTooltipContent: function (content) {
      if (this._tooltip) {
        this._tooltip.setContent(content);
      }

      return this;
    },
    // @method getTooltip(): Tooltip
    // Returns the tooltip bound to this layer.
    getTooltip: function () {
      return this._tooltip;
    },
    _openTooltip: function (e) {
      var layer = e.layer || e.target;

      if (!this._tooltip || !this._map) {
        return;
      }

      this.openTooltip(layer, this._tooltip.options.sticky ? e.latlng : undefined);
    },
    _moveTooltip: function (e) {
      var latlng = e.latlng,
          containerPoint,
          layerPoint;

      if (this._tooltip.options.sticky && e.originalEvent) {
        containerPoint = this._map.mouseEventToContainerPoint(e.originalEvent);
        layerPoint = this._map.containerPointToLayerPoint(containerPoint);
        latlng = this._map.layerPointToLatLng(layerPoint);
      }

      this._tooltip.setLatLng(latlng);
    }
  });
  /*
   * @class DivIcon
   * @aka L.DivIcon
   * @inherits Icon
   *
   * Represents a lightweight icon for markers that uses a simple `<div>`
   * element instead of an image. Inherits from `Icon` but ignores the `iconUrl` and shadow options.
   *
   * @example
   * ```js
   * var myIcon = L.divIcon({className: 'my-div-icon'});
   * // you can set .my-div-icon styles in CSS
   *
   * L.marker([50.505, 30.57], {icon: myIcon}).addTo(map);
   * ```
   *
   * By default, it has a 'leaflet-div-icon' CSS class and is styled as a little white square with a shadow.
   */

  var DivIcon = Icon.extend({
    options: {
      // @section
      // @aka DivIcon options
      iconSize: [12, 12],
      // also can be set through CSS
      // iconAnchor: (Point),
      // popupAnchor: (Point),
      // @option html: String = ''
      // Custom HTML code to put inside the div element, empty by default.
      html: false,
      // @option bgPos: Point = [0, 0]
      // Optional relative position of the background, in pixels
      bgPos: null,
      className: 'leaflet-div-icon'
    },
    createIcon: function (oldIcon) {
      var div = oldIcon && oldIcon.tagName === 'DIV' ? oldIcon : document.createElement('div'),
          options = this.options;
      div.innerHTML = options.html !== false ? options.html : '';

      if (options.bgPos) {
        var bgPos = toPoint(options.bgPos);
        div.style.backgroundPosition = -bgPos.x + 'px ' + -bgPos.y + 'px';
      }

      this._setIconStyles(div, 'icon');

      return div;
    },
    createShadow: function () {
      return null;
    }
  }); // @factory L.divIcon(options: DivIcon options)
  // Creates a `DivIcon` instance with the given options.

  function divIcon(options) {
    return new DivIcon(options);
  }

  Icon.Default = IconDefault;
  /*
   * @class GridLayer
   * @inherits Layer
   * @aka L.GridLayer
   *
   * Generic class for handling a tiled grid of HTML elements. This is the base class for all tile layers and replaces `TileLayer.Canvas`.
   * GridLayer can be extended to create a tiled grid of HTML elements like `<canvas>`, `<img>` or `<div>`. GridLayer will handle creating and animating these DOM elements for you.
   *
   *
   * @section Synchronous usage
   * @example
   *
   * To create a custom layer, extend GridLayer and implement the `createTile()` method, which will be passed a `Point` object with the `x`, `y`, and `z` (zoom level) coordinates to draw your tile.
   *
   * ```js
   * var CanvasLayer = L.GridLayer.extend({
   *     createTile: function(coords){
   *         // create a <canvas> element for drawing
   *         var tile = L.DomUtil.create('canvas', 'leaflet-tile');
   *
   *         // setup tile width and height according to the options
   *         var size = this.getTileSize();
   *         tile.width = size.x;
   *         tile.height = size.y;
   *
   *         // get a canvas context and draw something on it using coords.x, coords.y and coords.z
   *         var ctx = tile.getContext('2d');
   *
   *         // return the tile so it can be rendered on screen
   *         return tile;
   *     }
   * });
   * ```
   *
   * @section Asynchronous usage
   * @example
   *
   * Tile creation can also be asynchronous, this is useful when using a third-party drawing library. Once the tile is finished drawing it can be passed to the `done()` callback.
   *
   * ```js
   * var CanvasLayer = L.GridLayer.extend({
   *     createTile: function(coords, done){
   *         var error;
   *
   *         // create a <canvas> element for drawing
   *         var tile = L.DomUtil.create('canvas', 'leaflet-tile');
   *
   *         // setup tile width and height according to the options
   *         var size = this.getTileSize();
   *         tile.width = size.x;
   *         tile.height = size.y;
   *
   *         // draw something asynchronously and pass the tile to the done() callback
   *         setTimeout(function() {
   *             done(error, tile);
   *         }, 1000);
   *
   *         return tile;
   *     }
   * });
   * ```
   *
   * @section
   */

  var GridLayer = Layer.extend({
    // @section
    // @aka GridLayer options
    options: {
      // @option tileSize: Number|Point = 256
      // Width and height of tiles in the grid. Use a number if width and height are equal, or `L.point(width, height)` otherwise.
      tileSize: 256,
      // @option opacity: Number = 1.0
      // Opacity of the tiles. Can be used in the `createTile()` function.
      opacity: 1,
      // @option updateWhenIdle: Boolean = (depends)
      // Load new tiles only when panning ends.
      // `true` by default on mobile browsers, in order to avoid too many requests and keep smooth navigation.
      // `false` otherwise in order to display new tiles _during_ panning, since it is easy to pan outside the
      // [`keepBuffer`](#gridlayer-keepbuffer) option in desktop browsers.
      updateWhenIdle: mobile,
      // @option updateWhenZooming: Boolean = true
      // By default, a smooth zoom animation (during a [touch zoom](#map-touchzoom) or a [`flyTo()`](#map-flyto)) will update grid layers every integer zoom level. Setting this option to `false` will update the grid layer only when the smooth animation ends.
      updateWhenZooming: true,
      // @option updateInterval: Number = 200
      // Tiles will not update more than once every `updateInterval` milliseconds when panning.
      updateInterval: 200,
      // @option zIndex: Number = 1
      // The explicit zIndex of the tile layer.
      zIndex: 1,
      // @option bounds: LatLngBounds = undefined
      // If set, tiles will only be loaded inside the set `LatLngBounds`.
      bounds: null,
      // @option minZoom: Number = 0
      // The minimum zoom level down to which this layer will be displayed (inclusive).
      minZoom: 0,
      // @option maxZoom: Number = undefined
      // The maximum zoom level up to which this layer will be displayed (inclusive).
      maxZoom: undefined,
      // @option maxNativeZoom: Number = undefined
      // Maximum zoom number the tile source has available. If it is specified,
      // the tiles on all zoom levels higher than `maxNativeZoom` will be loaded
      // from `maxNativeZoom` level and auto-scaled.
      maxNativeZoom: undefined,
      // @option minNativeZoom: Number = undefined
      // Minimum zoom number the tile source has available. If it is specified,
      // the tiles on all zoom levels lower than `minNativeZoom` will be loaded
      // from `minNativeZoom` level and auto-scaled.
      minNativeZoom: undefined,
      // @option noWrap: Boolean = false
      // Whether the layer is wrapped around the antimeridian. If `true`, the
      // GridLayer will only be displayed once at low zoom levels. Has no
      // effect when the [map CRS](#map-crs) doesn't wrap around. Can be used
      // in combination with [`bounds`](#gridlayer-bounds) to prevent requesting
      // tiles outside the CRS limits.
      noWrap: false,
      // @option pane: String = 'tilePane'
      // `Map pane` where the grid layer will be added.
      pane: 'tilePane',
      // @option className: String = ''
      // A custom class name to assign to the tile layer. Empty by default.
      className: '',
      // @option keepBuffer: Number = 2
      // When panning the map, keep this many rows and columns of tiles before unloading them.
      keepBuffer: 2
    },
    initialize: function (options) {
      setOptions(this, options);
    },
    onAdd: function () {
      this._initContainer();

      this._levels = {};
      this._tiles = {};

      this._resetView();

      this._update();
    },
    beforeAdd: function (map) {
      map._addZoomLimit(this);
    },
    onRemove: function (map) {
      this._removeAllTiles();

      remove(this._container);

      map._removeZoomLimit(this);

      this._container = null;
      this._tileZoom = undefined;
    },
    // @method bringToFront: this
    // Brings the tile layer to the top of all tile layers.
    bringToFront: function () {
      if (this._map) {
        toFront(this._container);

        this._setAutoZIndex(Math.max);
      }

      return this;
    },
    // @method bringToBack: this
    // Brings the tile layer to the bottom of all tile layers.
    bringToBack: function () {
      if (this._map) {
        toBack(this._container);

        this._setAutoZIndex(Math.min);
      }

      return this;
    },
    // @method getContainer: HTMLElement
    // Returns the HTML element that contains the tiles for this layer.
    getContainer: function () {
      return this._container;
    },
    // @method setOpacity(opacity: Number): this
    // Changes the [opacity](#gridlayer-opacity) of the grid layer.
    setOpacity: function (opacity) {
      this.options.opacity = opacity;

      this._updateOpacity();

      return this;
    },
    // @method setZIndex(zIndex: Number): this
    // Changes the [zIndex](#gridlayer-zindex) of the grid layer.
    setZIndex: function (zIndex) {
      this.options.zIndex = zIndex;

      this._updateZIndex();

      return this;
    },
    // @method isLoading: Boolean
    // Returns `true` if any tile in the grid layer has not finished loading.
    isLoading: function () {
      return this._loading;
    },
    // @method redraw: this
    // Causes the layer to clear all the tiles and request them again.
    redraw: function () {
      if (this._map) {
        this._removeAllTiles();

        this._update();
      }

      return this;
    },
    getEvents: function () {
      var events = {
        viewprereset: this._invalidateAll,
        viewreset: this._resetView,
        zoom: this._resetView,
        moveend: this._onMoveEnd
      };

      if (!this.options.updateWhenIdle) {
        // update tiles on move, but not more often than once per given interval
        if (!this._onMove) {
          this._onMove = throttle(this._onMoveEnd, this.options.updateInterval, this);
        }

        events.move = this._onMove;
      }

      if (this._zoomAnimated) {
        events.zoomanim = this._animateZoom;
      }

      return events;
    },
    // @section Extension methods
    // Layers extending `GridLayer` shall reimplement the following method.
    // @method createTile(coords: Object, done?: Function): HTMLElement
    // Called only internally, must be overridden by classes extending `GridLayer`.
    // Returns the `HTMLElement` corresponding to the given `coords`. If the `done` callback
    // is specified, it must be called when the tile has finished loading and drawing.
    createTile: function () {
      return document.createElement('div');
    },
    // @section
    // @method getTileSize: Point
    // Normalizes the [tileSize option](#gridlayer-tilesize) into a point. Used by the `createTile()` method.
    getTileSize: function () {
      var s = this.options.tileSize;
      return s instanceof Point ? s : new Point(s, s);
    },
    _updateZIndex: function () {
      if (this._container && this.options.zIndex !== undefined && this.options.zIndex !== null) {
        this._container.style.zIndex = this.options.zIndex;
      }
    },
    _setAutoZIndex: function (compare) {
      // go through all other layers of the same pane, set zIndex to max + 1 (front) or min - 1 (back)
      var layers = this.getPane().children,
          edgeZIndex = -compare(-Infinity, Infinity); // -Infinity for max, Infinity for min

      for (var i = 0, len = layers.length, zIndex; i < len; i++) {
        zIndex = layers[i].style.zIndex;

        if (layers[i] !== this._container && zIndex) {
          edgeZIndex = compare(edgeZIndex, +zIndex);
        }
      }

      if (isFinite(edgeZIndex)) {
        this.options.zIndex = edgeZIndex + compare(-1, 1);

        this._updateZIndex();
      }
    },
    _updateOpacity: function () {
      if (!this._map) {
        return;
      } // IE doesn't inherit filter opacity properly, so we're forced to set it on tiles


      if (ielt9) {
        return;
      }

      setOpacity(this._container, this.options.opacity);
      var now = +new Date(),
          nextFrame = false,
          willPrune = false;

      for (var key in this._tiles) {
        var tile = this._tiles[key];

        if (!tile.current || !tile.loaded) {
          continue;
        }

        var fade = Math.min(1, (now - tile.loaded) / 200);
        setOpacity(tile.el, fade);

        if (fade < 1) {
          nextFrame = true;
        } else {
          if (tile.active) {
            willPrune = true;
          } else {
            this._onOpaqueTile(tile);
          }

          tile.active = true;
        }
      }

      if (willPrune && !this._noPrune) {
        this._pruneTiles();
      }

      if (nextFrame) {
        cancelAnimFrame(this._fadeFrame);
        this._fadeFrame = requestAnimFrame(this._updateOpacity, this);
      }
    },
    _onOpaqueTile: falseFn,
    _initContainer: function () {
      if (this._container) {
        return;
      }

      this._container = create$1('div', 'leaflet-layer ' + (this.options.className || ''));

      this._updateZIndex();

      if (this.options.opacity < 1) {
        this._updateOpacity();
      }

      this.getPane().appendChild(this._container);
    },
    _updateLevels: function () {
      var zoom = this._tileZoom,
          maxZoom = this.options.maxZoom;

      if (zoom === undefined) {
        return undefined;
      }

      for (var z in this._levels) {
        if (this._levels[z].el.children.length || z === zoom) {
          this._levels[z].el.style.zIndex = maxZoom - Math.abs(zoom - z);

          this._onUpdateLevel(z);
        } else {
          remove(this._levels[z].el);

          this._removeTilesAtZoom(z);

          this._onRemoveLevel(z);

          delete this._levels[z];
        }
      }

      var level = this._levels[zoom],
          map = this._map;

      if (!level) {
        level = this._levels[zoom] = {};
        level.el = create$1('div', 'leaflet-tile-container leaflet-zoom-animated', this._container);
        level.el.style.zIndex = maxZoom;
        level.origin = map.project(map.unproject(map.getPixelOrigin()), zoom).round();
        level.zoom = zoom;

        this._setZoomTransform(level, map.getCenter(), map.getZoom()); // force the browser to consider the newly added element for transition


        falseFn(level.el.offsetWidth);

        this._onCreateLevel(level);
      }

      this._level = level;
      return level;
    },
    _onUpdateLevel: falseFn,
    _onRemoveLevel: falseFn,
    _onCreateLevel: falseFn,
    _pruneTiles: function () {
      if (!this._map) {
        return;
      }

      var key, tile;

      var zoom = this._map.getZoom();

      if (zoom > this.options.maxZoom || zoom < this.options.minZoom) {
        this._removeAllTiles();

        return;
      }

      for (key in this._tiles) {
        tile = this._tiles[key];
        tile.retain = tile.current;
      }

      for (key in this._tiles) {
        tile = this._tiles[key];

        if (tile.current && !tile.active) {
          var coords = tile.coords;

          if (!this._retainParent(coords.x, coords.y, coords.z, coords.z - 5)) {
            this._retainChildren(coords.x, coords.y, coords.z, coords.z + 2);
          }
        }
      }

      for (key in this._tiles) {
        if (!this._tiles[key].retain) {
          this._removeTile(key);
        }
      }
    },
    _removeTilesAtZoom: function (zoom) {
      for (var key in this._tiles) {
        if (this._tiles[key].coords.z !== zoom) {
          continue;
        }

        this._removeTile(key);
      }
    },
    _removeAllTiles: function () {
      for (var key in this._tiles) {
        this._removeTile(key);
      }
    },
    _invalidateAll: function () {
      for (var z in this._levels) {
        remove(this._levels[z].el);

        this._onRemoveLevel(z);

        delete this._levels[z];
      }

      this._removeAllTiles();

      this._tileZoom = undefined;
    },
    _retainParent: function (x, y, z, minZoom) {
      var x2 = Math.floor(x / 2),
          y2 = Math.floor(y / 2),
          z2 = z - 1,
          coords2 = new Point(+x2, +y2);
      coords2.z = +z2;

      var key = this._tileCoordsToKey(coords2),
          tile = this._tiles[key];

      if (tile && tile.active) {
        tile.retain = true;
        return true;
      } else if (tile && tile.loaded) {
        tile.retain = true;
      }

      if (z2 > minZoom) {
        return this._retainParent(x2, y2, z2, minZoom);
      }

      return false;
    },
    _retainChildren: function (x, y, z, maxZoom) {
      for (var i = 2 * x; i < 2 * x + 2; i++) {
        for (var j = 2 * y; j < 2 * y + 2; j++) {
          var coords = new Point(i, j);
          coords.z = z + 1;

          var key = this._tileCoordsToKey(coords),
              tile = this._tiles[key];

          if (tile && tile.active) {
            tile.retain = true;
            continue;
          } else if (tile && tile.loaded) {
            tile.retain = true;
          }

          if (z + 1 < maxZoom) {
            this._retainChildren(i, j, z + 1, maxZoom);
          }
        }
      }
    },
    _resetView: function (e) {
      var animating = e && (e.pinch || e.flyTo);

      this._setView(this._map.getCenter(), this._map.getZoom(), animating, animating);
    },
    _animateZoom: function (e) {
      this._setView(e.center, e.zoom, true, e.noUpdate);
    },
    _clampZoom: function (zoom) {
      var options = this.options;

      if (undefined !== options.minNativeZoom && zoom < options.minNativeZoom) {
        return options.minNativeZoom;
      }

      if (undefined !== options.maxNativeZoom && options.maxNativeZoom < zoom) {
        return options.maxNativeZoom;
      }

      return zoom;
    },
    _setView: function (center, zoom, noPrune, noUpdate) {
      var tileZoom = this._clampZoom(Math.round(zoom));

      if (this.options.maxZoom !== undefined && tileZoom > this.options.maxZoom || this.options.minZoom !== undefined && tileZoom < this.options.minZoom) {
        tileZoom = undefined;
      }

      var tileZoomChanged = this.options.updateWhenZooming && tileZoom !== this._tileZoom;

      if (!noUpdate || tileZoomChanged) {
        this._tileZoom = tileZoom;

        if (this._abortLoading) {
          this._abortLoading();
        }

        this._updateLevels();

        this._resetGrid();

        if (tileZoom !== undefined) {
          this._update(center);
        }

        if (!noPrune) {
          this._pruneTiles();
        } // Flag to prevent _updateOpacity from pruning tiles during
        // a zoom anim or a pinch gesture


        this._noPrune = !!noPrune;
      }

      this._setZoomTransforms(center, zoom);
    },
    _setZoomTransforms: function (center, zoom) {
      for (var i in this._levels) {
        this._setZoomTransform(this._levels[i], center, zoom);
      }
    },
    _setZoomTransform: function (level, center, zoom) {
      var scale = this._map.getZoomScale(zoom, level.zoom),
          translate = level.origin.multiplyBy(scale).subtract(this._map._getNewPixelOrigin(center, zoom)).round();

      if (any3d) {
        setTransform(level.el, translate, scale);
      } else {
        setPosition(level.el, translate);
      }
    },
    _resetGrid: function () {
      var map = this._map,
          crs = map.options.crs,
          tileSize = this._tileSize = this.getTileSize(),
          tileZoom = this._tileZoom;

      var bounds = this._map.getPixelWorldBounds(this._tileZoom);

      if (bounds) {
        this._globalTileRange = this._pxBoundsToTileRange(bounds);
      }

      this._wrapX = crs.wrapLng && !this.options.noWrap && [Math.floor(map.project([0, crs.wrapLng[0]], tileZoom).x / tileSize.x), Math.ceil(map.project([0, crs.wrapLng[1]], tileZoom).x / tileSize.y)];
      this._wrapY = crs.wrapLat && !this.options.noWrap && [Math.floor(map.project([crs.wrapLat[0], 0], tileZoom).y / tileSize.x), Math.ceil(map.project([crs.wrapLat[1], 0], tileZoom).y / tileSize.y)];
    },
    _onMoveEnd: function () {
      if (!this._map || this._map._animatingZoom) {
        return;
      }

      this._update();
    },
    _getTiledPixelBounds: function (center) {
      var map = this._map,
          mapZoom = map._animatingZoom ? Math.max(map._animateToZoom, map.getZoom()) : map.getZoom(),
          scale = map.getZoomScale(mapZoom, this._tileZoom),
          pixelCenter = map.project(center, this._tileZoom).floor(),
          halfSize = map.getSize().divideBy(scale * 2);
      return new Bounds(pixelCenter.subtract(halfSize), pixelCenter.add(halfSize));
    },
    // Private method to load tiles in the grid's active zoom level according to map bounds
    _update: function (center) {
      var map = this._map;

      if (!map) {
        return;
      }

      var zoom = this._clampZoom(map.getZoom());

      if (center === undefined) {
        center = map.getCenter();
      }

      if (this._tileZoom === undefined) {
        return;
      } // if out of minzoom/maxzoom


      var pixelBounds = this._getTiledPixelBounds(center),
          tileRange = this._pxBoundsToTileRange(pixelBounds),
          tileCenter = tileRange.getCenter(),
          queue = [],
          margin = this.options.keepBuffer,
          noPruneRange = new Bounds(tileRange.getBottomLeft().subtract([margin, -margin]), tileRange.getTopRight().add([margin, -margin])); // Sanity check: panic if the tile range contains Infinity somewhere.


      if (!(isFinite(tileRange.min.x) && isFinite(tileRange.min.y) && isFinite(tileRange.max.x) && isFinite(tileRange.max.y))) {
        throw new Error('Attempted to load an infinite number of tiles');
      }

      for (var key in this._tiles) {
        var c = this._tiles[key].coords;

        if (c.z !== this._tileZoom || !noPruneRange.contains(new Point(c.x, c.y))) {
          this._tiles[key].current = false;
        }
      } // _update just loads more tiles. If the tile zoom level differs too much
      // from the map's, let _setView reset levels and prune old tiles.


      if (Math.abs(zoom - this._tileZoom) > 1) {
        this._setView(center, zoom);

        return;
      } // create a queue of coordinates to load tiles from


      for (var j = tileRange.min.y; j <= tileRange.max.y; j++) {
        for (var i = tileRange.min.x; i <= tileRange.max.x; i++) {
          var coords = new Point(i, j);
          coords.z = this._tileZoom;

          if (!this._isValidTile(coords)) {
            continue;
          }

          var tile = this._tiles[this._tileCoordsToKey(coords)];

          if (tile) {
            tile.current = true;
          } else {
            queue.push(coords);
          }
        }
      } // sort tile queue to load tiles in order of their distance to center


      queue.sort(function (a, b) {
        return a.distanceTo(tileCenter) - b.distanceTo(tileCenter);
      });

      if (queue.length !== 0) {
        // if it's the first batch of tiles to load
        if (!this._loading) {
          this._loading = true; // @event loading: Event
          // Fired when the grid layer starts loading tiles.

          this.fire('loading');
        } // create DOM fragment to append tiles in one batch


        var fragment = document.createDocumentFragment();

        for (i = 0; i < queue.length; i++) {
          this._addTile(queue[i], fragment);
        }

        this._level.el.appendChild(fragment);
      }
    },
    _isValidTile: function (coords) {
      var crs = this._map.options.crs;

      if (!crs.infinite) {
        // don't load tile if it's out of bounds and not wrapped
        var bounds = this._globalTileRange;

        if (!crs.wrapLng && (coords.x < bounds.min.x || coords.x > bounds.max.x) || !crs.wrapLat && (coords.y < bounds.min.y || coords.y > bounds.max.y)) {
          return false;
        }
      }

      if (!this.options.bounds) {
        return true;
      } // don't load tile if it doesn't intersect the bounds in options


      var tileBounds = this._tileCoordsToBounds(coords);

      return toLatLngBounds(this.options.bounds).overlaps(tileBounds);
    },
    _keyToBounds: function (key) {
      return this._tileCoordsToBounds(this._keyToTileCoords(key));
    },
    _tileCoordsToNwSe: function (coords) {
      var map = this._map,
          tileSize = this.getTileSize(),
          nwPoint = coords.scaleBy(tileSize),
          sePoint = nwPoint.add(tileSize),
          nw = map.unproject(nwPoint, coords.z),
          se = map.unproject(sePoint, coords.z);
      return [nw, se];
    },
    // converts tile coordinates to its geographical bounds
    _tileCoordsToBounds: function (coords) {
      var bp = this._tileCoordsToNwSe(coords),
          bounds = new LatLngBounds(bp[0], bp[1]);

      if (!this.options.noWrap) {
        bounds = this._map.wrapLatLngBounds(bounds);
      }

      return bounds;
    },
    // converts tile coordinates to key for the tile cache
    _tileCoordsToKey: function (coords) {
      return coords.x + ':' + coords.y + ':' + coords.z;
    },
    // converts tile cache key to coordinates
    _keyToTileCoords: function (key) {
      var k = key.split(':'),
          coords = new Point(+k[0], +k[1]);
      coords.z = +k[2];
      return coords;
    },
    _removeTile: function (key) {
      var tile = this._tiles[key];

      if (!tile) {
        return;
      }

      remove(tile.el);
      delete this._tiles[key]; // @event tileunload: TileEvent
      // Fired when a tile is removed (e.g. when a tile goes off the screen).

      this.fire('tileunload', {
        tile: tile.el,
        coords: this._keyToTileCoords(key)
      });
    },
    _initTile: function (tile) {
      addClass(tile, 'leaflet-tile');
      var tileSize = this.getTileSize();
      tile.style.width = tileSize.x + 'px';
      tile.style.height = tileSize.y + 'px';
      tile.onselectstart = falseFn;
      tile.onmousemove = falseFn; // update opacity on tiles in IE7-8 because of filter inheritance problems

      if (ielt9 && this.options.opacity < 1) {
        setOpacity(tile, this.options.opacity);
      } // without this hack, tiles disappear after zoom on Chrome for Android
      // https://github.com/Leaflet/Leaflet/issues/2078


      if (android && !android23) {
        tile.style.WebkitBackfaceVisibility = 'hidden';
      }
    },
    _addTile: function (coords, container) {
      var tilePos = this._getTilePos(coords),
          key = this._tileCoordsToKey(coords);

      var tile = this.createTile(this._wrapCoords(coords), bind(this._tileReady, this, coords));

      this._initTile(tile); // if createTile is defined with a second argument ("done" callback),
      // we know that tile is async and will be ready later; otherwise


      if (this.createTile.length < 2) {
        // mark tile as ready, but delay one frame for opacity animation to happen
        requestAnimFrame(bind(this._tileReady, this, coords, null, tile));
      }

      setPosition(tile, tilePos); // save tile in cache

      this._tiles[key] = {
        el: tile,
        coords: coords,
        current: true
      };
      container.appendChild(tile); // @event tileloadstart: TileEvent
      // Fired when a tile is requested and starts loading.

      this.fire('tileloadstart', {
        tile: tile,
        coords: coords
      });
    },
    _tileReady: function (coords, err, tile) {
      if (err) {
        // @event tileerror: TileErrorEvent
        // Fired when there is an error loading a tile.
        this.fire('tileerror', {
          error: err,
          tile: tile,
          coords: coords
        });
      }

      var key = this._tileCoordsToKey(coords);

      tile = this._tiles[key];

      if (!tile) {
        return;
      }

      tile.loaded = +new Date();

      if (this._map._fadeAnimated) {
        setOpacity(tile.el, 0);
        cancelAnimFrame(this._fadeFrame);
        this._fadeFrame = requestAnimFrame(this._updateOpacity, this);
      } else {
        tile.active = true;

        this._pruneTiles();
      }

      if (!err) {
        addClass(tile.el, 'leaflet-tile-loaded'); // @event tileload: TileEvent
        // Fired when a tile loads.

        this.fire('tileload', {
          tile: tile.el,
          coords: coords
        });
      }

      if (this._noTilesToLoad()) {
        this._loading = false; // @event load: Event
        // Fired when the grid layer loaded all visible tiles.

        this.fire('load');

        if (ielt9 || !this._map._fadeAnimated) {
          requestAnimFrame(this._pruneTiles, this);
        } else {
          // Wait a bit more than 0.2 secs (the duration of the tile fade-in)
          // to trigger a pruning.
          setTimeout(bind(this._pruneTiles, this), 250);
        }
      }
    },
    _getTilePos: function (coords) {
      return coords.scaleBy(this.getTileSize()).subtract(this._level.origin);
    },
    _wrapCoords: function (coords) {
      var newCoords = new Point(this._wrapX ? wrapNum(coords.x, this._wrapX) : coords.x, this._wrapY ? wrapNum(coords.y, this._wrapY) : coords.y);
      newCoords.z = coords.z;
      return newCoords;
    },
    _pxBoundsToTileRange: function (bounds) {
      var tileSize = this.getTileSize();
      return new Bounds(bounds.min.unscaleBy(tileSize).floor(), bounds.max.unscaleBy(tileSize).ceil().subtract([1, 1]));
    },
    _noTilesToLoad: function () {
      for (var key in this._tiles) {
        if (!this._tiles[key].loaded) {
          return false;
        }
      }

      return true;
    }
  }); // @factory L.gridLayer(options?: GridLayer options)
  // Creates a new instance of GridLayer with the supplied options.

  function gridLayer(options) {
    return new GridLayer(options);
  }
  /*
   * @class TileLayer
   * @inherits GridLayer
   * @aka L.TileLayer
   * Used to load and display tile layers on the map. Note that most tile servers require attribution, which you can set under `Layer`. Extends `GridLayer`.
   *
   * @example
   *
   * ```js
   * L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png?{foo}', {foo: 'bar', attribution: 'Map data &copy; <a href="https://www.openstreetmap.org/">OpenStreetMap</a> contributors, <a href="https://creativecommons.org/licenses/by-sa/2.0/">CC-BY-SA</a>'}).addTo(map);
   * ```
   *
   * @section URL template
   * @example
   *
   * A string of the following form:
   *
   * ```
   * 'http://{s}.somedomain.com/blabla/{z}/{x}/{y}{r}.png'
   * ```
   *
   * `{s}` means one of the available subdomains (used sequentially to help with browser parallel requests per domain limitation; subdomain values are specified in options; `a`, `b` or `c` by default, can be omitted), `{z}` — zoom level, `{x}` and `{y}` — tile coordinates. `{r}` can be used to add "&commat;2x" to the URL to load retina tiles.
   *
   * You can use custom keys in the template, which will be [evaluated](#util-template) from TileLayer options, like this:
   *
   * ```
   * L.tileLayer('http://{s}.somedomain.com/{foo}/{z}/{x}/{y}.png', {foo: 'bar'});
   * ```
   */


  var TileLayer = GridLayer.extend({
    // @section
    // @aka TileLayer options
    options: {
      // @option minZoom: Number = 0
      // The minimum zoom level down to which this layer will be displayed (inclusive).
      minZoom: 0,
      // @option maxZoom: Number = 18
      // The maximum zoom level up to which this layer will be displayed (inclusive).
      maxZoom: 18,
      // @option subdomains: String|String[] = 'abc'
      // Subdomains of the tile service. Can be passed in the form of one string (where each letter is a subdomain name) or an array of strings.
      subdomains: 'abc',
      // @option errorTileUrl: String = ''
      // URL to the tile image to show in place of the tile that failed to load.
      errorTileUrl: '',
      // @option zoomOffset: Number = 0
      // The zoom number used in tile URLs will be offset with this value.
      zoomOffset: 0,
      // @option tms: Boolean = false
      // If `true`, inverses Y axis numbering for tiles (turn this on for [TMS](https://en.wikipedia.org/wiki/Tile_Map_Service) services).
      tms: false,
      // @option zoomReverse: Boolean = false
      // If set to true, the zoom number used in tile URLs will be reversed (`maxZoom - zoom` instead of `zoom`)
      zoomReverse: false,
      // @option detectRetina: Boolean = false
      // If `true` and user is on a retina display, it will request four tiles of half the specified size and a bigger zoom level in place of one to utilize the high resolution.
      detectRetina: false,
      // @option crossOrigin: Boolean|String = false
      // Whether the crossOrigin attribute will be added to the tiles.
      // If a String is provided, all tiles will have their crossOrigin attribute set to the String provided. This is needed if you want to access tile pixel data.
      // Refer to [CORS Settings](https://developer.mozilla.org/en-US/docs/Web/HTML/CORS_settings_attributes) for valid String values.
      crossOrigin: false
    },
    initialize: function (url, options) {
      this._url = url;
      options = setOptions(this, options); // detecting retina displays, adjusting tileSize and zoom levels

      if (options.detectRetina && retina && options.maxZoom > 0) {
        options.tileSize = Math.floor(options.tileSize / 2);

        if (!options.zoomReverse) {
          options.zoomOffset++;
          options.maxZoom--;
        } else {
          options.zoomOffset--;
          options.minZoom++;
        }

        options.minZoom = Math.max(0, options.minZoom);
      }

      if (typeof options.subdomains === 'string') {
        options.subdomains = options.subdomains.split('');
      } // for https://github.com/Leaflet/Leaflet/issues/137


      if (!android) {
        this.on('tileunload', this._onTileRemove);
      }
    },
    // @method setUrl(url: String, noRedraw?: Boolean): this
    // Updates the layer's URL template and redraws it (unless `noRedraw` is set to `true`).
    // If the URL does not change, the layer will not be redrawn unless
    // the noRedraw parameter is set to false.
    setUrl: function (url, noRedraw) {
      if (this._url === url && noRedraw === undefined) {
        noRedraw = true;
      }

      this._url = url;

      if (!noRedraw) {
        this.redraw();
      }

      return this;
    },
    // @method createTile(coords: Object, done?: Function): HTMLElement
    // Called only internally, overrides GridLayer's [`createTile()`](#gridlayer-createtile)
    // to return an `<img>` HTML element with the appropriate image URL given `coords`. The `done`
    // callback is called when the tile has been loaded.
    createTile: function (coords, done) {
      var tile = document.createElement('img');
      on(tile, 'load', bind(this._tileOnLoad, this, done, tile));
      on(tile, 'error', bind(this._tileOnError, this, done, tile));

      if (this.options.crossOrigin || this.options.crossOrigin === '') {
        tile.crossOrigin = this.options.crossOrigin === true ? '' : this.options.crossOrigin;
      }
      /*
       Alt tag is set to empty string to keep screen readers from reading URL and for compliance reasons
       http://www.w3.org/TR/WCAG20-TECHS/H67
      */


      tile.alt = '';
      /*
       Set role="presentation" to force screen readers to ignore this
       https://www.w3.org/TR/wai-aria/roles#textalternativecomputation
      */

      tile.setAttribute('role', 'presentation');
      tile.src = this.getTileUrl(coords);
      return tile;
    },
    // @section Extension methods
    // @uninheritable
    // Layers extending `TileLayer` might reimplement the following method.
    // @method getTileUrl(coords: Object): String
    // Called only internally, returns the URL for a tile given its coordinates.
    // Classes extending `TileLayer` can override this function to provide custom tile URL naming schemes.
    getTileUrl: function (coords) {
      var data = {
        r: retina ? '@2x' : '',
        s: this._getSubdomain(coords),
        x: coords.x,
        y: coords.y,
        z: this._getZoomForUrl()
      };

      if (this._map && !this._map.options.crs.infinite) {
        var invertedY = this._globalTileRange.max.y - coords.y;

        if (this.options.tms) {
          data['y'] = invertedY;
        }

        data['-y'] = invertedY;
      }

      return template(this._url, extend(data, this.options));
    },
    _tileOnLoad: function (done, tile) {
      // For https://github.com/Leaflet/Leaflet/issues/3332
      if (ielt9) {
        setTimeout(bind(done, this, null, tile), 0);
      } else {
        done(null, tile);
      }
    },
    _tileOnError: function (done, tile, e) {
      var errorUrl = this.options.errorTileUrl;

      if (errorUrl && tile.getAttribute('src') !== errorUrl) {
        tile.src = errorUrl;
      }

      done(e, tile);
    },
    _onTileRemove: function (e) {
      e.tile.onload = null;
    },
    _getZoomForUrl: function () {
      var zoom = this._tileZoom,
          maxZoom = this.options.maxZoom,
          zoomReverse = this.options.zoomReverse,
          zoomOffset = this.options.zoomOffset;

      if (zoomReverse) {
        zoom = maxZoom - zoom;
      }

      return zoom + zoomOffset;
    },
    _getSubdomain: function (tilePoint) {
      var index = Math.abs(tilePoint.x + tilePoint.y) % this.options.subdomains.length;
      return this.options.subdomains[index];
    },
    // stops loading all tiles in the background layer
    _abortLoading: function () {
      var i, tile;

      for (i in this._tiles) {
        if (this._tiles[i].coords.z !== this._tileZoom) {
          tile = this._tiles[i].el;
          tile.onload = falseFn;
          tile.onerror = falseFn;

          if (!tile.complete) {
            tile.src = emptyImageUrl;
            remove(tile);
            delete this._tiles[i];
          }
        }
      }
    },
    _removeTile: function (key) {
      var tile = this._tiles[key];

      if (!tile) {
        return;
      } // Cancels any pending http requests associated with the tile
      // unless we're on Android's stock browser,
      // see https://github.com/Leaflet/Leaflet/issues/137


      if (!androidStock) {
        tile.el.setAttribute('src', emptyImageUrl);
      }

      return GridLayer.prototype._removeTile.call(this, key);
    },
    _tileReady: function (coords, err, tile) {
      if (!this._map || tile && tile.getAttribute('src') === emptyImageUrl) {
        return;
      }

      return GridLayer.prototype._tileReady.call(this, coords, err, tile);
    }
  }); // @factory L.tilelayer(urlTemplate: String, options?: TileLayer options)
  // Instantiates a tile layer object given a `URL template` and optionally an options object.

  function tileLayer(url, options) {
    return new TileLayer(url, options);
  }
  /*
   * @class TileLayer.WMS
   * @inherits TileLayer
   * @aka L.TileLayer.WMS
   * Used to display [WMS](https://en.wikipedia.org/wiki/Web_Map_Service) services as tile layers on the map. Extends `TileLayer`.
   *
   * @example
   *
   * ```js
   * var nexrad = L.tileLayer.wms("http://mesonet.agron.iastate.edu/cgi-bin/wms/nexrad/n0r.cgi", {
   * 	layers: 'nexrad-n0r-900913',
   * 	format: 'image/png',
   * 	transparent: true,
   * 	attribution: "Weather data © 2012 IEM Nexrad"
   * });
   * ```
   */


  var TileLayerWMS = TileLayer.extend({
    // @section
    // @aka TileLayer.WMS options
    // If any custom options not documented here are used, they will be sent to the
    // WMS server as extra parameters in each request URL. This can be useful for
    // [non-standard vendor WMS parameters](http://docs.geoserver.org/stable/en/user/services/wms/vendor.html).
    defaultWmsParams: {
      service: 'WMS',
      request: 'GetMap',
      // @option layers: String = ''
      // **(required)** Comma-separated list of WMS layers to show.
      layers: '',
      // @option styles: String = ''
      // Comma-separated list of WMS styles.
      styles: '',
      // @option format: String = 'image/jpeg'
      // WMS image format (use `'image/png'` for layers with transparency).
      format: 'image/jpeg',
      // @option transparent: Boolean = false
      // If `true`, the WMS service will return images with transparency.
      transparent: false,
      // @option version: String = '1.1.1'
      // Version of the WMS service to use
      version: '1.1.1'
    },
    options: {
      // @option crs: CRS = null
      // Coordinate Reference System to use for the WMS requests, defaults to
      // map CRS. Don't change this if you're not sure what it means.
      crs: null,
      // @option uppercase: Boolean = false
      // If `true`, WMS request parameter keys will be uppercase.
      uppercase: false
    },
    initialize: function (url, options) {
      this._url = url;
      var wmsParams = extend({}, this.defaultWmsParams); // all keys that are not TileLayer options go to WMS params

      for (var i in options) {
        if (!(i in this.options)) {
          wmsParams[i] = options[i];
        }
      }

      options = setOptions(this, options);
      var realRetina = options.detectRetina && retina ? 2 : 1;
      var tileSize = this.getTileSize();
      wmsParams.width = tileSize.x * realRetina;
      wmsParams.height = tileSize.y * realRetina;
      this.wmsParams = wmsParams;
    },
    onAdd: function (map) {
      this._crs = this.options.crs || map.options.crs;
      this._wmsVersion = parseFloat(this.wmsParams.version);
      var projectionKey = this._wmsVersion >= 1.3 ? 'crs' : 'srs';
      this.wmsParams[projectionKey] = this._crs.code;
      TileLayer.prototype.onAdd.call(this, map);
    },
    getTileUrl: function (coords) {
      var tileBounds = this._tileCoordsToNwSe(coords),
          crs = this._crs,
          bounds = toBounds(crs.project(tileBounds[0]), crs.project(tileBounds[1])),
          min = bounds.min,
          max = bounds.max,
          bbox = (this._wmsVersion >= 1.3 && this._crs === EPSG4326 ? [min.y, min.x, max.y, max.x] : [min.x, min.y, max.x, max.y]).join(','),
          url = TileLayer.prototype.getTileUrl.call(this, coords);

      return url + getParamString(this.wmsParams, url, this.options.uppercase) + (this.options.uppercase ? '&BBOX=' : '&bbox=') + bbox;
    },
    // @method setParams(params: Object, noRedraw?: Boolean): this
    // Merges an object with the new parameters and re-requests tiles on the current screen (unless `noRedraw` was set to true).
    setParams: function (params, noRedraw) {
      extend(this.wmsParams, params);

      if (!noRedraw) {
        this.redraw();
      }

      return this;
    }
  }); // @factory L.tileLayer.wms(baseUrl: String, options: TileLayer.WMS options)
  // Instantiates a WMS tile layer object given a base URL of the WMS service and a WMS parameters/options object.

  function tileLayerWMS(url, options) {
    return new TileLayerWMS(url, options);
  }

  TileLayer.WMS = TileLayerWMS;
  tileLayer.wms = tileLayerWMS;
  /*
   * @class Renderer
   * @inherits Layer
   * @aka L.Renderer
   *
   * Base class for vector renderer implementations (`SVG`, `Canvas`). Handles the
   * DOM container of the renderer, its bounds, and its zoom animation.
   *
   * A `Renderer` works as an implicit layer group for all `Path`s - the renderer
   * itself can be added or removed to the map. All paths use a renderer, which can
   * be implicit (the map will decide the type of renderer and use it automatically)
   * or explicit (using the [`renderer`](#path-renderer) option of the path).
   *
   * Do not use this class directly, use `SVG` and `Canvas` instead.
   *
   * @event update: Event
   * Fired when the renderer updates its bounds, center and zoom, for example when
   * its map has moved
   */

  var Renderer = Layer.extend({
    // @section
    // @aka Renderer options
    options: {
      // @option padding: Number = 0.1
      // How much to extend the clip area around the map view (relative to its size)
      // e.g. 0.1 would be 10% of map view in each direction
      padding: 0.1,
      // @option tolerance: Number = 0
      // How much to extend click tolerance round a path/object on the map
      tolerance: 0
    },
    initialize: function (options) {
      setOptions(this, options);
      stamp(this);
      this._layers = this._layers || {};
    },
    onAdd: function () {
      if (!this._container) {
        this._initContainer(); // defined by renderer implementations


        if (this._zoomAnimated) {
          addClass(this._container, 'leaflet-zoom-animated');
        }
      }

      this.getPane().appendChild(this._container);

      this._update();

      this.on('update', this._updatePaths, this);
    },
    onRemove: function () {
      this.off('update', this._updatePaths, this);

      this._destroyContainer();
    },
    getEvents: function () {
      var events = {
        viewreset: this._reset,
        zoom: this._onZoom,
        moveend: this._update,
        zoomend: this._onZoomEnd
      };

      if (this._zoomAnimated) {
        events.zoomanim = this._onAnimZoom;
      }

      return events;
    },
    _onAnimZoom: function (ev) {
      this._updateTransform(ev.center, ev.zoom);
    },
    _onZoom: function () {
      this._updateTransform(this._map.getCenter(), this._map.getZoom());
    },
    _updateTransform: function (center, zoom) {
      var scale = this._map.getZoomScale(zoom, this._zoom),
          position = getPosition(this._container),
          viewHalf = this._map.getSize().multiplyBy(0.5 + this.options.padding),
          currentCenterPoint = this._map.project(this._center, zoom),
          destCenterPoint = this._map.project(center, zoom),
          centerOffset = destCenterPoint.subtract(currentCenterPoint),
          topLeftOffset = viewHalf.multiplyBy(-scale).add(position).add(viewHalf).subtract(centerOffset);

      if (any3d) {
        setTransform(this._container, topLeftOffset, scale);
      } else {
        setPosition(this._container, topLeftOffset);
      }
    },
    _reset: function () {
      this._update();

      this._updateTransform(this._center, this._zoom);

      for (var id in this._layers) {
        this._layers[id]._reset();
      }
    },
    _onZoomEnd: function () {
      for (var id in this._layers) {
        this._layers[id]._project();
      }
    },
    _updatePaths: function () {
      for (var id in this._layers) {
        this._layers[id]._update();
      }
    },
    _update: function () {
      // Update pixel bounds of renderer container (for positioning/sizing/clipping later)
      // Subclasses are responsible of firing the 'update' event.
      var p = this.options.padding,
          size = this._map.getSize(),
          min = this._map.containerPointToLayerPoint(size.multiplyBy(-p)).round();

      this._bounds = new Bounds(min, min.add(size.multiplyBy(1 + p * 2)).round());
      this._center = this._map.getCenter();
      this._zoom = this._map.getZoom();
    }
  });
  /*
   * @class Canvas
   * @inherits Renderer
   * @aka L.Canvas
   *
   * Allows vector layers to be displayed with [`<canvas>`](https://developer.mozilla.org/docs/Web/API/Canvas_API).
   * Inherits `Renderer`.
   *
   * Due to [technical limitations](http://caniuse.com/#search=canvas), Canvas is not
   * available in all web browsers, notably IE8, and overlapping geometries might
   * not display properly in some edge cases.
   *
   * @example
   *
   * Use Canvas by default for all paths in the map:
   *
   * ```js
   * var map = L.map('map', {
   * 	renderer: L.canvas()
   * });
   * ```
   *
   * Use a Canvas renderer with extra padding for specific vector geometries:
   *
   * ```js
   * var map = L.map('map');
   * var myRenderer = L.canvas({ padding: 0.5 });
   * var line = L.polyline( coordinates, { renderer: myRenderer } );
   * var circle = L.circle( center, { renderer: myRenderer } );
   * ```
   */

  var Canvas = Renderer.extend({
    getEvents: function () {
      var events = Renderer.prototype.getEvents.call(this);
      events.viewprereset = this._onViewPreReset;
      return events;
    },
    _onViewPreReset: function () {
      // Set a flag so that a viewprereset+moveend+viewreset only updates&redraws once
      this._postponeUpdatePaths = true;
    },
    onAdd: function () {
      Renderer.prototype.onAdd.call(this); // Redraw vectors since canvas is cleared upon removal,
      // in case of removing the renderer itself from the map.

      this._draw();
    },
    _initContainer: function () {
      var container = this._container = document.createElement('canvas');
      on(container, 'mousemove', throttle(this._onMouseMove, 32, this), this);
      on(container, 'click dblclick mousedown mouseup contextmenu', this._onClick, this);
      on(container, 'mouseout', this._handleMouseOut, this);
      this._ctx = container.getContext('2d');
    },
    _destroyContainer: function () {
      cancelAnimFrame(this._redrawRequest);
      delete this._ctx;
      remove(this._container);
      off(this._container);
      delete this._container;
    },
    _updatePaths: function () {
      if (this._postponeUpdatePaths) {
        return;
      }

      var layer;
      this._redrawBounds = null;

      for (var id in this._layers) {
        layer = this._layers[id];

        layer._update();
      }

      this._redraw();
    },
    _update: function () {
      if (this._map._animatingZoom && this._bounds) {
        return;
      }

      Renderer.prototype._update.call(this);

      var b = this._bounds,
          container = this._container,
          size = b.getSize(),
          m = retina ? 2 : 1;
      setPosition(container, b.min); // set canvas size (also clearing it); use double size on retina

      container.width = m * size.x;
      container.height = m * size.y;
      container.style.width = size.x + 'px';
      container.style.height = size.y + 'px';

      if (retina) {
        this._ctx.scale(2, 2);
      } // translate so we use the same path coordinates after canvas element moves


      this._ctx.translate(-b.min.x, -b.min.y); // Tell paths to redraw themselves


      this.fire('update');
    },
    _reset: function () {
      Renderer.prototype._reset.call(this);

      if (this._postponeUpdatePaths) {
        this._postponeUpdatePaths = false;

        this._updatePaths();
      }
    },
    _initPath: function (layer) {
      this._updateDashArray(layer);

      this._layers[stamp(layer)] = layer;
      var order = layer._order = {
        layer: layer,
        prev: this._drawLast,
        next: null
      };

      if (this._drawLast) {
        this._drawLast.next = order;
      }

      this._drawLast = order;
      this._drawFirst = this._drawFirst || this._drawLast;
    },
    _addPath: function (layer) {
      this._requestRedraw(layer);
    },
    _removePath: function (layer) {
      var order = layer._order;
      var next = order.next;
      var prev = order.prev;

      if (next) {
        next.prev = prev;
      } else {
        this._drawLast = prev;
      }

      if (prev) {
        prev.next = next;
      } else {
        this._drawFirst = next;
      }

      delete layer._order;
      delete this._layers[stamp(layer)];

      this._requestRedraw(layer);
    },
    _updatePath: function (layer) {
      // Redraw the union of the layer's old pixel
      // bounds and the new pixel bounds.
      this._extendRedrawBounds(layer);

      layer._project();

      layer._update(); // The redraw will extend the redraw bounds
      // with the new pixel bounds.


      this._requestRedraw(layer);
    },
    _updateStyle: function (layer) {
      this._updateDashArray(layer);

      this._requestRedraw(layer);
    },
    _updateDashArray: function (layer) {
      if (typeof layer.options.dashArray === 'string') {
        var parts = layer.options.dashArray.split(/[, ]+/),
            dashArray = [],
            dashValue,
            i;

        for (i = 0; i < parts.length; i++) {
          dashValue = Number(parts[i]); // Ignore dash array containing invalid lengths

          if (isNaN(dashValue)) {
            return;
          }

          dashArray.push(dashValue);
        }

        layer.options._dashArray = dashArray;
      } else {
        layer.options._dashArray = layer.options.dashArray;
      }
    },
    _requestRedraw: function (layer) {
      if (!this._map) {
        return;
      }

      this._extendRedrawBounds(layer);

      this._redrawRequest = this._redrawRequest || requestAnimFrame(this._redraw, this);
    },
    _extendRedrawBounds: function (layer) {
      if (layer._pxBounds) {
        var padding = (layer.options.weight || 0) + 1;
        this._redrawBounds = this._redrawBounds || new Bounds();

        this._redrawBounds.extend(layer._pxBounds.min.subtract([padding, padding]));

        this._redrawBounds.extend(layer._pxBounds.max.add([padding, padding]));
      }
    },
    _redraw: function () {
      this._redrawRequest = null;

      if (this._redrawBounds) {
        this._redrawBounds.min._floor();

        this._redrawBounds.max._ceil();
      }

      this._clear(); // clear layers in redraw bounds


      this._draw(); // draw layers


      this._redrawBounds = null;
    },
    _clear: function () {
      var bounds = this._redrawBounds;

      if (bounds) {
        var size = bounds.getSize();

        this._ctx.clearRect(bounds.min.x, bounds.min.y, size.x, size.y);
      } else {
        this._ctx.clearRect(0, 0, this._container.width, this._container.height);
      }
    },
    _draw: function () {
      var layer,
          bounds = this._redrawBounds;

      this._ctx.save();

      if (bounds) {
        var size = bounds.getSize();

        this._ctx.beginPath();

        this._ctx.rect(bounds.min.x, bounds.min.y, size.x, size.y);

        this._ctx.clip();
      }

      this._drawing = true;

      for (var order = this._drawFirst; order; order = order.next) {
        layer = order.layer;

        if (!bounds || layer._pxBounds && layer._pxBounds.intersects(bounds)) {
          layer._updatePath();
        }
      }

      this._drawing = false;

      this._ctx.restore(); // Restore state before clipping.

    },
    _updatePoly: function (layer, closed) {
      if (!this._drawing) {
        return;
      }

      var i,
          j,
          len2,
          p,
          parts = layer._parts,
          len = parts.length,
          ctx = this._ctx;

      if (!len) {
        return;
      }

      ctx.beginPath();

      for (i = 0; i < len; i++) {
        for (j = 0, len2 = parts[i].length; j < len2; j++) {
          p = parts[i][j];
          ctx[j ? 'lineTo' : 'moveTo'](p.x, p.y);
        }

        if (closed) {
          ctx.closePath();
        }
      }

      this._fillStroke(ctx, layer); // TODO optimization: 1 fill/stroke for all features with equal style instead of 1 for each feature

    },
    _updateCircle: function (layer) {
      if (!this._drawing || layer._empty()) {
        return;
      }

      var p = layer._point,
          ctx = this._ctx,
          r = Math.max(Math.round(layer._radius), 1),
          s = (Math.max(Math.round(layer._radiusY), 1) || r) / r;

      if (s !== 1) {
        ctx.save();
        ctx.scale(1, s);
      }

      ctx.beginPath();
      ctx.arc(p.x, p.y / s, r, 0, Math.PI * 2, false);

      if (s !== 1) {
        ctx.restore();
      }

      this._fillStroke(ctx, layer);
    },
    _fillStroke: function (ctx, layer) {
      var options = layer.options;

      if (options.fill) {
        ctx.globalAlpha = options.fillOpacity;
        ctx.fillStyle = options.fillColor || options.color;
        ctx.fill(options.fillRule || 'evenodd');
      }

      if (options.stroke && options.weight !== 0) {
        if (ctx.setLineDash) {
          ctx.setLineDash(layer.options && layer.options._dashArray || []);
        }

        ctx.globalAlpha = options.opacity;
        ctx.lineWidth = options.weight;
        ctx.strokeStyle = options.color;
        ctx.lineCap = options.lineCap;
        ctx.lineJoin = options.lineJoin;
        ctx.stroke();
      }
    },
    // Canvas obviously doesn't have mouse events for individual drawn objects,
    // so we emulate that by calculating what's under the mouse on mousemove/click manually
    _onClick: function (e) {
      var point = this._map.mouseEventToLayerPoint(e),
          layer,
          clickedLayer;

      for (var order = this._drawFirst; order; order = order.next) {
        layer = order.layer;

        if (layer.options.interactive && layer._containsPoint(point) && !this._map._draggableMoved(layer)) {
          clickedLayer = layer;
        }
      }

      if (clickedLayer) {
        fakeStop(e);

        this._fireEvent([clickedLayer], e);
      }
    },
    _onMouseMove: function (e) {
      if (!this._map || this._map.dragging.moving() || this._map._animatingZoom) {
        return;
      }

      var point = this._map.mouseEventToLayerPoint(e);

      this._handleMouseHover(e, point);
    },
    _handleMouseOut: function (e) {
      var layer = this._hoveredLayer;

      if (layer) {
        // if we're leaving the layer, fire mouseout
        removeClass(this._container, 'leaflet-interactive');

        this._fireEvent([layer], e, 'mouseout');

        this._hoveredLayer = null;
      }
    },
    _handleMouseHover: function (e, point) {
      var layer, candidateHoveredLayer;

      for (var order = this._drawFirst; order; order = order.next) {
        layer = order.layer;

        if (layer.options.interactive && layer._containsPoint(point)) {
          candidateHoveredLayer = layer;
        }
      }

      if (candidateHoveredLayer !== this._hoveredLayer) {
        this._handleMouseOut(e);

        if (candidateHoveredLayer) {
          addClass(this._container, 'leaflet-interactive'); // change cursor

          this._fireEvent([candidateHoveredLayer], e, 'mouseover');

          this._hoveredLayer = candidateHoveredLayer;
        }
      }

      if (this._hoveredLayer) {
        this._fireEvent([this._hoveredLayer], e);
      }
    },
    _fireEvent: function (layers, e, type) {
      this._map._fireDOMEvent(e, type || e.type, layers);
    },
    _bringToFront: function (layer) {
      var order = layer._order;

      if (!order) {
        return;
      }

      var next = order.next;
      var prev = order.prev;

      if (next) {
        next.prev = prev;
      } else {
        // Already last
        return;
      }

      if (prev) {
        prev.next = next;
      } else if (next) {
        // Update first entry unless this is the
        // single entry
        this._drawFirst = next;
      }

      order.prev = this._drawLast;
      this._drawLast.next = order;
      order.next = null;
      this._drawLast = order;

      this._requestRedraw(layer);
    },
    _bringToBack: function (layer) {
      var order = layer._order;

      if (!order) {
        return;
      }

      var next = order.next;
      var prev = order.prev;

      if (prev) {
        prev.next = next;
      } else {
        // Already first
        return;
      }

      if (next) {
        next.prev = prev;
      } else if (prev) {
        // Update last entry unless this is the
        // single entry
        this._drawLast = prev;
      }

      order.prev = null;
      order.next = this._drawFirst;
      this._drawFirst.prev = order;
      this._drawFirst = order;

      this._requestRedraw(layer);
    }
  }); // @factory L.canvas(options?: Renderer options)
  // Creates a Canvas renderer with the given options.

  function canvas$1(options) {
    return canvas ? new Canvas(options) : null;
  }
  /*
   * Thanks to Dmitry Baranovsky and his Raphael library for inspiration!
   */


  var vmlCreate = function () {
    try {
      document.namespaces.add('lvml', 'urn:schemas-microsoft-com:vml');
      return function (name) {
        return document.createElement('<lvml:' + name + ' class="lvml">');
      };
    } catch (e) {
      return function (name) {
        return document.createElement('<' + name + ' xmlns="urn:schemas-microsoft.com:vml" class="lvml">');
      };
    }
  }();
  /*
   * @class SVG
   *
   *
   * VML was deprecated in 2012, which means VML functionality exists only for backwards compatibility
   * with old versions of Internet Explorer.
   */
  // mixin to redefine some SVG methods to handle VML syntax which is similar but with some differences


  var vmlMixin = {
    _initContainer: function () {
      this._container = create$1('div', 'leaflet-vml-container');
    },
    _update: function () {
      if (this._map._animatingZoom) {
        return;
      }

      Renderer.prototype._update.call(this);

      this.fire('update');
    },
    _initPath: function (layer) {
      var container = layer._container = vmlCreate('shape');
      addClass(container, 'leaflet-vml-shape ' + (this.options.className || ''));
      container.coordsize = '1 1';
      layer._path = vmlCreate('path');
      container.appendChild(layer._path);

      this._updateStyle(layer);

      this._layers[stamp(layer)] = layer;
    },
    _addPath: function (layer) {
      var container = layer._container;

      this._container.appendChild(container);

      if (layer.options.interactive) {
        layer.addInteractiveTarget(container);
      }
    },
    _removePath: function (layer) {
      var container = layer._container;
      remove(container);
      layer.removeInteractiveTarget(container);
      delete this._layers[stamp(layer)];
    },
    _updateStyle: function (layer) {
      var stroke = layer._stroke,
          fill = layer._fill,
          options = layer.options,
          container = layer._container;
      container.stroked = !!options.stroke;
      container.filled = !!options.fill;

      if (options.stroke) {
        if (!stroke) {
          stroke = layer._stroke = vmlCreate('stroke');
        }

        container.appendChild(stroke);
        stroke.weight = options.weight + 'px';
        stroke.color = options.color;
        stroke.opacity = options.opacity;

        if (options.dashArray) {
          stroke.dashStyle = isArray(options.dashArray) ? options.dashArray.join(' ') : options.dashArray.replace(/( *, *)/g, ' ');
        } else {
          stroke.dashStyle = '';
        }

        stroke.endcap = options.lineCap.replace('butt', 'flat');
        stroke.joinstyle = options.lineJoin;
      } else if (stroke) {
        container.removeChild(stroke);
        layer._stroke = null;
      }

      if (options.fill) {
        if (!fill) {
          fill = layer._fill = vmlCreate('fill');
        }

        container.appendChild(fill);
        fill.color = options.fillColor || options.color;
        fill.opacity = options.fillOpacity;
      } else if (fill) {
        container.removeChild(fill);
        layer._fill = null;
      }
    },
    _updateCircle: function (layer) {
      var p = layer._point.round(),
          r = Math.round(layer._radius),
          r2 = Math.round(layer._radiusY || r);

      this._setPath(layer, layer._empty() ? 'M0 0' : 'AL ' + p.x + ',' + p.y + ' ' + r + ',' + r2 + ' 0,' + 65535 * 360);
    },
    _setPath: function (layer, path) {
      layer._path.v = path;
    },
    _bringToFront: function (layer) {
      toFront(layer._container);
    },
    _bringToBack: function (layer) {
      toBack(layer._container);
    }
  };
  var create$2 = vml ? vmlCreate : svgCreate;
  /*
   * @class SVG
   * @inherits Renderer
   * @aka L.SVG
   *
   * Allows vector layers to be displayed with [SVG](https://developer.mozilla.org/docs/Web/SVG).
   * Inherits `Renderer`.
   *
   * Due to [technical limitations](http://caniuse.com/#search=svg), SVG is not
   * available in all web browsers, notably Android 2.x and 3.x.
   *
   * Although SVG is not available on IE7 and IE8, these browsers support
   * [VML](https://en.wikipedia.org/wiki/Vector_Markup_Language)
   * (a now deprecated technology), and the SVG renderer will fall back to VML in
   * this case.
   *
   * @example
   *
   * Use SVG by default for all paths in the map:
   *
   * ```js
   * var map = L.map('map', {
   * 	renderer: L.svg()
   * });
   * ```
   *
   * Use a SVG renderer with extra padding for specific vector geometries:
   *
   * ```js
   * var map = L.map('map');
   * var myRenderer = L.svg({ padding: 0.5 });
   * var line = L.polyline( coordinates, { renderer: myRenderer } );
   * var circle = L.circle( center, { renderer: myRenderer } );
   * ```
   */

  var SVG = Renderer.extend({
    getEvents: function () {
      var events = Renderer.prototype.getEvents.call(this);
      events.zoomstart = this._onZoomStart;
      return events;
    },
    _initContainer: function () {
      this._container = create$2('svg'); // makes it possible to click through svg root; we'll reset it back in individual paths

      this._container.setAttribute('pointer-events', 'none');

      this._rootGroup = create$2('g');

      this._container.appendChild(this._rootGroup);
    },
    _destroyContainer: function () {
      remove(this._container);
      off(this._container);
      delete this._container;
      delete this._rootGroup;
      delete this._svgSize;
    },
    _onZoomStart: function () {
      // Drag-then-pinch interactions might mess up the center and zoom.
      // In this case, the easiest way to prevent this is re-do the renderer
      //   bounds and padding when the zooming starts.
      this._update();
    },
    _update: function () {
      if (this._map._animatingZoom && this._bounds) {
        return;
      }

      Renderer.prototype._update.call(this);

      var b = this._bounds,
          size = b.getSize(),
          container = this._container; // set size of svg-container if changed

      if (!this._svgSize || !this._svgSize.equals(size)) {
        this._svgSize = size;
        container.setAttribute('width', size.x);
        container.setAttribute('height', size.y);
      } // movement: update container viewBox so that we don't have to change coordinates of individual layers


      setPosition(container, b.min);
      container.setAttribute('viewBox', [b.min.x, b.min.y, size.x, size.y].join(' '));
      this.fire('update');
    },
    // methods below are called by vector layers implementations
    _initPath: function (layer) {
      var path = layer._path = create$2('path'); // @namespace Path
      // @option className: String = null
      // Custom class name set on an element. Only for SVG renderer.

      if (layer.options.className) {
        addClass(path, layer.options.className);
      }

      if (layer.options.interactive) {
        addClass(path, 'leaflet-interactive');
      }

      this._updateStyle(layer);

      this._layers[stamp(layer)] = layer;
    },
    _addPath: function (layer) {
      if (!this._rootGroup) {
        this._initContainer();
      }

      this._rootGroup.appendChild(layer._path);

      layer.addInteractiveTarget(layer._path);
    },
    _removePath: function (layer) {
      remove(layer._path);
      layer.removeInteractiveTarget(layer._path);
      delete this._layers[stamp(layer)];
    },
    _updatePath: function (layer) {
      layer._project();

      layer._update();
    },
    _updateStyle: function (layer) {
      var path = layer._path,
          options = layer.options;

      if (!path) {
        return;
      }

      if (options.stroke) {
        path.setAttribute('stroke', options.color);
        path.setAttribute('stroke-opacity', options.opacity);
        path.setAttribute('stroke-width', options.weight);
        path.setAttribute('stroke-linecap', options.lineCap);
        path.setAttribute('stroke-linejoin', options.lineJoin);

        if (options.dashArray) {
          path.setAttribute('stroke-dasharray', options.dashArray);
        } else {
          path.removeAttribute('stroke-dasharray');
        }

        if (options.dashOffset) {
          path.setAttribute('stroke-dashoffset', options.dashOffset);
        } else {
          path.removeAttribute('stroke-dashoffset');
        }
      } else {
        path.setAttribute('stroke', 'none');
      }

      if (options.fill) {
        path.setAttribute('fill', options.fillColor || options.color);
        path.setAttribute('fill-opacity', options.fillOpacity);
        path.setAttribute('fill-rule', options.fillRule || 'evenodd');
      } else {
        path.setAttribute('fill', 'none');
      }
    },
    _updatePoly: function (layer, closed) {
      this._setPath(layer, pointsToPath(layer._parts, closed));
    },
    _updateCircle: function (layer) {
      var p = layer._point,
          r = Math.max(Math.round(layer._radius), 1),
          r2 = Math.max(Math.round(layer._radiusY), 1) || r,
          arc = 'a' + r + ',' + r2 + ' 0 1,0 '; // drawing a circle with two half-arcs

      var d = layer._empty() ? 'M0 0' : 'M' + (p.x - r) + ',' + p.y + arc + r * 2 + ',0 ' + arc + -r * 2 + ',0 ';

      this._setPath(layer, d);
    },
    _setPath: function (layer, path) {
      layer._path.setAttribute('d', path);
    },
    // SVG does not have the concept of zIndex so we resort to changing the DOM order of elements
    _bringToFront: function (layer) {
      toFront(layer._path);
    },
    _bringToBack: function (layer) {
      toBack(layer._path);
    }
  });

  if (vml) {
    SVG.include(vmlMixin);
  } // @namespace SVG
  // @factory L.svg(options?: Renderer options)
  // Creates a SVG renderer with the given options.


  function svg$1(options) {
    return svg || vml ? new SVG(options) : null;
  }

  Map.include({
    // @namespace Map; @method getRenderer(layer: Path): Renderer
    // Returns the instance of `Renderer` that should be used to render the given
    // `Path`. It will ensure that the `renderer` options of the map and paths
    // are respected, and that the renderers do exist on the map.
    getRenderer: function (layer) {
      // @namespace Path; @option renderer: Renderer
      // Use this specific instance of `Renderer` for this path. Takes
      // precedence over the map's [default renderer](#map-renderer).
      var renderer = layer.options.renderer || this._getPaneRenderer(layer.options.pane) || this.options.renderer || this._renderer;

      if (!renderer) {
        renderer = this._renderer = this._createRenderer();
      }

      if (!this.hasLayer(renderer)) {
        this.addLayer(renderer);
      }

      return renderer;
    },
    _getPaneRenderer: function (name) {
      if (name === 'overlayPane' || name === undefined) {
        return false;
      }

      var renderer = this._paneRenderers[name];

      if (renderer === undefined) {
        renderer = this._createRenderer({
          pane: name
        });
        this._paneRenderers[name] = renderer;
      }

      return renderer;
    },
    _createRenderer: function (options) {
      // @namespace Map; @option preferCanvas: Boolean = false
      // Whether `Path`s should be rendered on a `Canvas` renderer.
      // By default, all `Path`s are rendered in a `SVG` renderer.
      return this.options.preferCanvas && canvas$1(options) || svg$1(options);
    }
  });
  /*
   * L.Rectangle extends Polygon and creates a rectangle when passed a LatLngBounds object.
   */

  /*
   * @class Rectangle
   * @aka L.Rectangle
   * @inherits Polygon
   *
   * A class for drawing rectangle overlays on a map. Extends `Polygon`.
   *
   * @example
   *
   * ```js
   * // define rectangle geographical bounds
   * var bounds = [[54.559322, -5.767822], [56.1210604, -3.021240]];
   *
   * // create an orange rectangle
   * L.rectangle(bounds, {color: "#ff7800", weight: 1}).addTo(map);
   *
   * // zoom the map to the rectangle bounds
   * map.fitBounds(bounds);
   * ```
   *
   */

  var Rectangle = Polygon.extend({
    initialize: function (latLngBounds, options) {
      Polygon.prototype.initialize.call(this, this._boundsToLatLngs(latLngBounds), options);
    },
    // @method setBounds(latLngBounds: LatLngBounds): this
    // Redraws the rectangle with the passed bounds.
    setBounds: function (latLngBounds) {
      return this.setLatLngs(this._boundsToLatLngs(latLngBounds));
    },
    _boundsToLatLngs: function (latLngBounds) {
      latLngBounds = toLatLngBounds(latLngBounds);
      return [latLngBounds.getSouthWest(), latLngBounds.getNorthWest(), latLngBounds.getNorthEast(), latLngBounds.getSouthEast()];
    }
  }); // @factory L.rectangle(latLngBounds: LatLngBounds, options?: Polyline options)

  function rectangle(latLngBounds, options) {
    return new Rectangle(latLngBounds, options);
  }

  SVG.create = create$2;
  SVG.pointsToPath = pointsToPath;
  GeoJSON.geometryToLayer = geometryToLayer;
  GeoJSON.coordsToLatLng = coordsToLatLng;
  GeoJSON.coordsToLatLngs = coordsToLatLngs;
  GeoJSON.latLngToCoords = latLngToCoords;
  GeoJSON.latLngsToCoords = latLngsToCoords;
  GeoJSON.getFeature = getFeature;
  GeoJSON.asFeature = asFeature;
  /*
   * L.Handler.BoxZoom is used to add shift-drag zoom interaction to the map
   * (zoom to a selected bounding box), enabled by default.
   */
  // @namespace Map
  // @section Interaction Options

  Map.mergeOptions({
    // @option boxZoom: Boolean = true
    // Whether the map can be zoomed to a rectangular area specified by
    // dragging the mouse while pressing the shift key.
    boxZoom: true
  });
  var BoxZoom = Handler.extend({
    initialize: function (map) {
      this._map = map;
      this._container = map._container;
      this._pane = map._panes.overlayPane;
      this._resetStateTimeout = 0;
      map.on('unload', this._destroy, this);
    },
    addHooks: function () {
      on(this._container, 'mousedown', this._onMouseDown, this);
    },
    removeHooks: function () {
      off(this._container, 'mousedown', this._onMouseDown, this);
    },
    moved: function () {
      return this._moved;
    },
    _destroy: function () {
      remove(this._pane);
      delete this._pane;
    },
    _resetState: function () {
      this._resetStateTimeout = 0;
      this._moved = false;
    },
    _clearDeferredResetState: function () {
      if (this._resetStateTimeout !== 0) {
        clearTimeout(this._resetStateTimeout);
        this._resetStateTimeout = 0;
      }
    },
    _onMouseDown: function (e) {
      if (!e.shiftKey || e.which !== 1 && e.button !== 1) {
        return false;
      } // Clear the deferred resetState if it hasn't executed yet, otherwise it
      // will interrupt the interaction and orphan a box element in the container.


      this._clearDeferredResetState();

      this._resetState();

      disableTextSelection();
      disableImageDrag();
      this._startPoint = this._map.mouseEventToContainerPoint(e);
      on(document, {
        contextmenu: stop,
        mousemove: this._onMouseMove,
        mouseup: this._onMouseUp,
        keydown: this._onKeyDown
      }, this);
    },
    _onMouseMove: function (e) {
      if (!this._moved) {
        this._moved = true;
        this._box = create$1('div', 'leaflet-zoom-box', this._container);
        addClass(this._container, 'leaflet-crosshair');

        this._map.fire('boxzoomstart');
      }

      this._point = this._map.mouseEventToContainerPoint(e);
      var bounds = new Bounds(this._point, this._startPoint),
          size = bounds.getSize();
      setPosition(this._box, bounds.min);
      this._box.style.width = size.x + 'px';
      this._box.style.height = size.y + 'px';
    },
    _finish: function () {
      if (this._moved) {
        remove(this._box);
        removeClass(this._container, 'leaflet-crosshair');
      }

      enableTextSelection();
      enableImageDrag();
      off(document, {
        contextmenu: stop,
        mousemove: this._onMouseMove,
        mouseup: this._onMouseUp,
        keydown: this._onKeyDown
      }, this);
    },
    _onMouseUp: function (e) {
      if (e.which !== 1 && e.button !== 1) {
        return;
      }

      this._finish();

      if (!this._moved) {
        return;
      } // Postpone to next JS tick so internal click event handling
      // still see it as "moved".


      this._clearDeferredResetState();

      this._resetStateTimeout = setTimeout(bind(this._resetState, this), 0);
      var bounds = new LatLngBounds(this._map.containerPointToLatLng(this._startPoint), this._map.containerPointToLatLng(this._point));

      this._map.fitBounds(bounds).fire('boxzoomend', {
        boxZoomBounds: bounds
      });
    },
    _onKeyDown: function (e) {
      if (e.keyCode === 27) {
        this._finish();
      }
    }
  }); // @section Handlers
  // @property boxZoom: Handler
  // Box (shift-drag with mouse) zoom handler.

  Map.addInitHook('addHandler', 'boxZoom', BoxZoom);
  /*
   * L.Handler.DoubleClickZoom is used to handle double-click zoom on the map, enabled by default.
   */
  // @namespace Map
  // @section Interaction Options

  Map.mergeOptions({
    // @option doubleClickZoom: Boolean|String = true
    // Whether the map can be zoomed in by double clicking on it and
    // zoomed out by double clicking while holding shift. If passed
    // `'center'`, double-click zoom will zoom to the center of the
    //  view regardless of where the mouse was.
    doubleClickZoom: true
  });
  var DoubleClickZoom = Handler.extend({
    addHooks: function () {
      this._map.on('dblclick', this._onDoubleClick, this);
    },
    removeHooks: function () {
      this._map.off('dblclick', this._onDoubleClick, this);
    },
    _onDoubleClick: function (e) {
      var map = this._map,
          oldZoom = map.getZoom(),
          delta = map.options.zoomDelta,
          zoom = e.originalEvent.shiftKey ? oldZoom - delta : oldZoom + delta;

      if (map.options.doubleClickZoom === 'center') {
        map.setZoom(zoom);
      } else {
        map.setZoomAround(e.containerPoint, zoom);
      }
    }
  }); // @section Handlers
  //
  // Map properties include interaction handlers that allow you to control
  // interaction behavior in runtime, enabling or disabling certain features such
  // as dragging or touch zoom (see `Handler` methods). For example:
  //
  // ```js
  // map.doubleClickZoom.disable();
  // ```
  //
  // @property doubleClickZoom: Handler
  // Double click zoom handler.

  Map.addInitHook('addHandler', 'doubleClickZoom', DoubleClickZoom);
  /*
   * L.Handler.MapDrag is used to make the map draggable (with panning inertia), enabled by default.
   */
  // @namespace Map
  // @section Interaction Options

  Map.mergeOptions({
    // @option dragging: Boolean = true
    // Whether the map be draggable with mouse/touch or not.
    dragging: true,
    // @section Panning Inertia Options
    // @option inertia: Boolean = *
    // If enabled, panning of the map will have an inertia effect where
    // the map builds momentum while dragging and continues moving in
    // the same direction for some time. Feels especially nice on touch
    // devices. Enabled by default unless running on old Android devices.
    inertia: !android23,
    // @option inertiaDeceleration: Number = 3000
    // The rate with which the inertial movement slows down, in pixels/second².
    inertiaDeceleration: 3400,
    // px/s^2
    // @option inertiaMaxSpeed: Number = Infinity
    // Max speed of the inertial movement, in pixels/second.
    inertiaMaxSpeed: Infinity,
    // px/s
    // @option easeLinearity: Number = 0.2
    easeLinearity: 0.2,
    // TODO refactor, move to CRS
    // @option worldCopyJump: Boolean = false
    // With this option enabled, the map tracks when you pan to another "copy"
    // of the world and seamlessly jumps to the original one so that all overlays
    // like markers and vector layers are still visible.
    worldCopyJump: false,
    // @option maxBoundsViscosity: Number = 0.0
    // If `maxBounds` is set, this option will control how solid the bounds
    // are when dragging the map around. The default value of `0.0` allows the
    // user to drag outside the bounds at normal speed, higher values will
    // slow down map dragging outside bounds, and `1.0` makes the bounds fully
    // solid, preventing the user from dragging outside the bounds.
    maxBoundsViscosity: 0.0
  });
  var Drag = Handler.extend({
    addHooks: function () {
      if (!this._draggable) {
        var map = this._map;
        this._draggable = new Draggable(map._mapPane, map._container);

        this._draggable.on({
          dragstart: this._onDragStart,
          drag: this._onDrag,
          dragend: this._onDragEnd
        }, this);

        this._draggable.on('predrag', this._onPreDragLimit, this);

        if (map.options.worldCopyJump) {
          this._draggable.on('predrag', this._onPreDragWrap, this);

          map.on('zoomend', this._onZoomEnd, this);
          map.whenReady(this._onZoomEnd, this);
        }
      }

      addClass(this._map._container, 'leaflet-grab leaflet-touch-drag');

      this._draggable.enable();

      this._positions = [];
      this._times = [];
    },
    removeHooks: function () {
      removeClass(this._map._container, 'leaflet-grab');
      removeClass(this._map._container, 'leaflet-touch-drag');

      this._draggable.disable();
    },
    moved: function () {
      return this._draggable && this._draggable._moved;
    },
    moving: function () {
      return this._draggable && this._draggable._moving;
    },
    _onDragStart: function () {
      var map = this._map;

      map._stop();

      if (this._map.options.maxBounds && this._map.options.maxBoundsViscosity) {
        var bounds = toLatLngBounds(this._map.options.maxBounds);
        this._offsetLimit = toBounds(this._map.latLngToContainerPoint(bounds.getNorthWest()).multiplyBy(-1), this._map.latLngToContainerPoint(bounds.getSouthEast()).multiplyBy(-1).add(this._map.getSize()));
        this._viscosity = Math.min(1.0, Math.max(0.0, this._map.options.maxBoundsViscosity));
      } else {
        this._offsetLimit = null;
      }

      map.fire('movestart').fire('dragstart');

      if (map.options.inertia) {
        this._positions = [];
        this._times = [];
      }
    },
    _onDrag: function (e) {
      if (this._map.options.inertia) {
        var time = this._lastTime = +new Date(),
            pos = this._lastPos = this._draggable._absPos || this._draggable._newPos;

        this._positions.push(pos);

        this._times.push(time);

        this._prunePositions(time);
      }

      this._map.fire('move', e).fire('drag', e);
    },
    _prunePositions: function (time) {
      while (this._positions.length > 1 && time - this._times[0] > 50) {
        this._positions.shift();

        this._times.shift();
      }
    },
    _onZoomEnd: function () {
      var pxCenter = this._map.getSize().divideBy(2),
          pxWorldCenter = this._map.latLngToLayerPoint([0, 0]);

      this._initialWorldOffset = pxWorldCenter.subtract(pxCenter).x;
      this._worldWidth = this._map.getPixelWorldBounds().getSize().x;
    },
    _viscousLimit: function (value, threshold) {
      return value - (value - threshold) * this._viscosity;
    },
    _onPreDragLimit: function () {
      if (!this._viscosity || !this._offsetLimit) {
        return;
      }

      var offset = this._draggable._newPos.subtract(this._draggable._startPos);

      var limit = this._offsetLimit;

      if (offset.x < limit.min.x) {
        offset.x = this._viscousLimit(offset.x, limit.min.x);
      }

      if (offset.y < limit.min.y) {
        offset.y = this._viscousLimit(offset.y, limit.min.y);
      }

      if (offset.x > limit.max.x) {
        offset.x = this._viscousLimit(offset.x, limit.max.x);
      }

      if (offset.y > limit.max.y) {
        offset.y = this._viscousLimit(offset.y, limit.max.y);
      }

      this._draggable._newPos = this._draggable._startPos.add(offset);
    },
    _onPreDragWrap: function () {
      // TODO refactor to be able to adjust map pane position after zoom
      var worldWidth = this._worldWidth,
          halfWidth = Math.round(worldWidth / 2),
          dx = this._initialWorldOffset,
          x = this._draggable._newPos.x,
          newX1 = (x - halfWidth + dx) % worldWidth + halfWidth - dx,
          newX2 = (x + halfWidth + dx) % worldWidth - halfWidth - dx,
          newX = Math.abs(newX1 + dx) < Math.abs(newX2 + dx) ? newX1 : newX2;
      this._draggable._absPos = this._draggable._newPos.clone();
      this._draggable._newPos.x = newX;
    },
    _onDragEnd: function (e) {
      var map = this._map,
          options = map.options,
          noInertia = !options.inertia || this._times.length < 2;
      map.fire('dragend', e);

      if (noInertia) {
        map.fire('moveend');
      } else {
        this._prunePositions(+new Date());

        var direction = this._lastPos.subtract(this._positions[0]),
            duration = (this._lastTime - this._times[0]) / 1000,
            ease = options.easeLinearity,
            speedVector = direction.multiplyBy(ease / duration),
            speed = speedVector.distanceTo([0, 0]),
            limitedSpeed = Math.min(options.inertiaMaxSpeed, speed),
            limitedSpeedVector = speedVector.multiplyBy(limitedSpeed / speed),
            decelerationDuration = limitedSpeed / (options.inertiaDeceleration * ease),
            offset = limitedSpeedVector.multiplyBy(-decelerationDuration / 2).round();

        if (!offset.x && !offset.y) {
          map.fire('moveend');
        } else {
          offset = map._limitOffset(offset, map.options.maxBounds);
          requestAnimFrame(function () {
            map.panBy(offset, {
              duration: decelerationDuration,
              easeLinearity: ease,
              noMoveStart: true,
              animate: true
            });
          });
        }
      }
    }
  }); // @section Handlers
  // @property dragging: Handler
  // Map dragging handler (by both mouse and touch).

  Map.addInitHook('addHandler', 'dragging', Drag);
  /*
   * L.Map.Keyboard is handling keyboard interaction with the map, enabled by default.
   */
  // @namespace Map
  // @section Keyboard Navigation Options

  Map.mergeOptions({
    // @option keyboard: Boolean = true
    // Makes the map focusable and allows users to navigate the map with keyboard
    // arrows and `+`/`-` keys.
    keyboard: true,
    // @option keyboardPanDelta: Number = 80
    // Amount of pixels to pan when pressing an arrow key.
    keyboardPanDelta: 80
  });
  var Keyboard = Handler.extend({
    keyCodes: {
      left: [37],
      right: [39],
      down: [40],
      up: [38],
      zoomIn: [187, 107, 61, 171],
      zoomOut: [189, 109, 54, 173]
    },
    initialize: function (map) {
      this._map = map;

      this._setPanDelta(map.options.keyboardPanDelta);

      this._setZoomDelta(map.options.zoomDelta);
    },
    addHooks: function () {
      var container = this._map._container; // make the container focusable by tabbing

      if (container.tabIndex <= 0) {
        container.tabIndex = '0';
      }

      on(container, {
        focus: this._onFocus,
        blur: this._onBlur,
        mousedown: this._onMouseDown
      }, this);

      this._map.on({
        focus: this._addHooks,
        blur: this._removeHooks
      }, this);
    },
    removeHooks: function () {
      this._removeHooks();

      off(this._map._container, {
        focus: this._onFocus,
        blur: this._onBlur,
        mousedown: this._onMouseDown
      }, this);

      this._map.off({
        focus: this._addHooks,
        blur: this._removeHooks
      }, this);
    },
    _onMouseDown: function () {
      if (this._focused) {
        return;
      }

      var body = document.body,
          docEl = document.documentElement,
          top = body.scrollTop || docEl.scrollTop,
          left = body.scrollLeft || docEl.scrollLeft;

      this._map._container.focus();

      window.scrollTo(left, top);
    },
    _onFocus: function () {
      this._focused = true;

      this._map.fire('focus');
    },
    _onBlur: function () {
      this._focused = false;

      this._map.fire('blur');
    },
    _setPanDelta: function (panDelta) {
      var keys = this._panKeys = {},
          codes = this.keyCodes,
          i,
          len;

      for (i = 0, len = codes.left.length; i < len; i++) {
        keys[codes.left[i]] = [-1 * panDelta, 0];
      }

      for (i = 0, len = codes.right.length; i < len; i++) {
        keys[codes.right[i]] = [panDelta, 0];
      }

      for (i = 0, len = codes.down.length; i < len; i++) {
        keys[codes.down[i]] = [0, panDelta];
      }

      for (i = 0, len = codes.up.length; i < len; i++) {
        keys[codes.up[i]] = [0, -1 * panDelta];
      }
    },
    _setZoomDelta: function (zoomDelta) {
      var keys = this._zoomKeys = {},
          codes = this.keyCodes,
          i,
          len;

      for (i = 0, len = codes.zoomIn.length; i < len; i++) {
        keys[codes.zoomIn[i]] = zoomDelta;
      }

      for (i = 0, len = codes.zoomOut.length; i < len; i++) {
        keys[codes.zoomOut[i]] = -zoomDelta;
      }
    },
    _addHooks: function () {
      on(document, 'keydown', this._onKeyDown, this);
    },
    _removeHooks: function () {
      off(document, 'keydown', this._onKeyDown, this);
    },
    _onKeyDown: function (e) {
      if (e.altKey || e.ctrlKey || e.metaKey) {
        return;
      }

      var key = e.keyCode,
          map = this._map,
          offset;

      if (key in this._panKeys) {
        if (!map._panAnim || !map._panAnim._inProgress) {
          offset = this._panKeys[key];

          if (e.shiftKey) {
            offset = toPoint(offset).multiplyBy(3);
          }

          map.panBy(offset);

          if (map.options.maxBounds) {
            map.panInsideBounds(map.options.maxBounds);
          }
        }
      } else if (key in this._zoomKeys) {
        map.setZoom(map.getZoom() + (e.shiftKey ? 3 : 1) * this._zoomKeys[key]);
      } else if (key === 27 && map._popup && map._popup.options.closeOnEscapeKey) {
        map.closePopup();
      } else {
        return;
      }

      stop(e);
    }
  }); // @section Handlers
  // @section Handlers
  // @property keyboard: Handler
  // Keyboard navigation handler.

  Map.addInitHook('addHandler', 'keyboard', Keyboard);
  /*
   * L.Handler.ScrollWheelZoom is used by L.Map to enable mouse scroll wheel zoom on the map.
   */
  // @namespace Map
  // @section Interaction Options

  Map.mergeOptions({
    // @section Mousewheel options
    // @option scrollWheelZoom: Boolean|String = true
    // Whether the map can be zoomed by using the mouse wheel. If passed `'center'`,
    // it will zoom to the center of the view regardless of where the mouse was.
    scrollWheelZoom: true,
    // @option wheelDebounceTime: Number = 40
    // Limits the rate at which a wheel can fire (in milliseconds). By default
    // user can't zoom via wheel more often than once per 40 ms.
    wheelDebounceTime: 40,
    // @option wheelPxPerZoomLevel: Number = 60
    // How many scroll pixels (as reported by [L.DomEvent.getWheelDelta](#domevent-getwheeldelta))
    // mean a change of one full zoom level. Smaller values will make wheel-zooming
    // faster (and vice versa).
    wheelPxPerZoomLevel: 60
  });
  var ScrollWheelZoom = Handler.extend({
    addHooks: function () {
      on(this._map._container, 'mousewheel', this._onWheelScroll, this);
      this._delta = 0;
    },
    removeHooks: function () {
      off(this._map._container, 'mousewheel', this._onWheelScroll, this);
    },
    _onWheelScroll: function (e) {
      var delta = getWheelDelta(e);
      var debounce = this._map.options.wheelDebounceTime;
      this._delta += delta;
      this._lastMousePos = this._map.mouseEventToContainerPoint(e);

      if (!this._startTime) {
        this._startTime = +new Date();
      }

      var left = Math.max(debounce - (+new Date() - this._startTime), 0);
      clearTimeout(this._timer);
      this._timer = setTimeout(bind(this._performZoom, this), left);
      stop(e);
    },
    _performZoom: function () {
      var map = this._map,
          zoom = map.getZoom(),
          snap = this._map.options.zoomSnap || 0;

      map._stop(); // stop panning and fly animations if any
      // map the delta with a sigmoid function to -4..4 range leaning on -1..1


      var d2 = this._delta / (this._map.options.wheelPxPerZoomLevel * 4),
          d3 = 4 * Math.log(2 / (1 + Math.exp(-Math.abs(d2)))) / Math.LN2,
          d4 = snap ? Math.ceil(d3 / snap) * snap : d3,
          delta = map._limitZoom(zoom + (this._delta > 0 ? d4 : -d4)) - zoom;
      this._delta = 0;
      this._startTime = null;

      if (!delta) {
        return;
      }

      if (map.options.scrollWheelZoom === 'center') {
        map.setZoom(zoom + delta);
      } else {
        map.setZoomAround(this._lastMousePos, zoom + delta);
      }
    }
  }); // @section Handlers
  // @property scrollWheelZoom: Handler
  // Scroll wheel zoom handler.

  Map.addInitHook('addHandler', 'scrollWheelZoom', ScrollWheelZoom);
  /*
   * L.Map.Tap is used to enable mobile hacks like quick taps and long hold.
   */
  // @namespace Map
  // @section Interaction Options

  Map.mergeOptions({
    // @section Touch interaction options
    // @option tap: Boolean = true
    // Enables mobile hacks for supporting instant taps (fixing 200ms click
    // delay on iOS/Android) and touch holds (fired as `contextmenu` events).
    tap: true,
    // @option tapTolerance: Number = 15
    // The max number of pixels a user can shift his finger during touch
    // for it to be considered a valid tap.
    tapTolerance: 15
  });
  var Tap = Handler.extend({
    addHooks: function () {
      on(this._map._container, 'touchstart', this._onDown, this);
    },
    removeHooks: function () {
      off(this._map._container, 'touchstart', this._onDown, this);
    },
    _onDown: function (e) {
      if (!e.touches) {
        return;
      }

      preventDefault(e);
      this._fireClick = true; // don't simulate click or track longpress if more than 1 touch

      if (e.touches.length > 1) {
        this._fireClick = false;
        clearTimeout(this._holdTimeout);
        return;
      }

      var first = e.touches[0],
          el = first.target;
      this._startPos = this._newPos = new Point(first.clientX, first.clientY); // if touching a link, highlight it

      if (el.tagName && el.tagName.toLowerCase() === 'a') {
        addClass(el, 'leaflet-active');
      } // simulate long hold but setting a timeout


      this._holdTimeout = setTimeout(bind(function () {
        if (this._isTapValid()) {
          this._fireClick = false;

          this._onUp();

          this._simulateEvent('contextmenu', first);
        }
      }, this), 1000);

      this._simulateEvent('mousedown', first);

      on(document, {
        touchmove: this._onMove,
        touchend: this._onUp
      }, this);
    },
    _onUp: function (e) {
      clearTimeout(this._holdTimeout);
      off(document, {
        touchmove: this._onMove,
        touchend: this._onUp
      }, this);

      if (this._fireClick && e && e.changedTouches) {
        var first = e.changedTouches[0],
            el = first.target;

        if (el && el.tagName && el.tagName.toLowerCase() === 'a') {
          removeClass(el, 'leaflet-active');
        }

        this._simulateEvent('mouseup', first); // simulate click if the touch didn't move too much


        if (this._isTapValid()) {
          this._simulateEvent('click', first);
        }
      }
    },
    _isTapValid: function () {
      return this._newPos.distanceTo(this._startPos) <= this._map.options.tapTolerance;
    },
    _onMove: function (e) {
      var first = e.touches[0];
      this._newPos = new Point(first.clientX, first.clientY);

      this._simulateEvent('mousemove', first);
    },
    _simulateEvent: function (type, e) {
      var simulatedEvent = document.createEvent('MouseEvents');
      simulatedEvent._simulated = true;
      e.target._simulatedClick = true;
      simulatedEvent.initMouseEvent(type, true, true, window, 1, e.screenX, e.screenY, e.clientX, e.clientY, false, false, false, false, 0, null);
      e.target.dispatchEvent(simulatedEvent);
    }
  }); // @section Handlers
  // @property tap: Handler
  // Mobile touch hacks (quick tap and touch hold) handler.

  if (touch && !pointer) {
    Map.addInitHook('addHandler', 'tap', Tap);
  }
  /*
   * L.Handler.TouchZoom is used by L.Map to add pinch zoom on supported mobile browsers.
   */
  // @namespace Map
  // @section Interaction Options


  Map.mergeOptions({
    // @section Touch interaction options
    // @option touchZoom: Boolean|String = *
    // Whether the map can be zoomed by touch-dragging with two fingers. If
    // passed `'center'`, it will zoom to the center of the view regardless of
    // where the touch events (fingers) were. Enabled for touch-capable web
    // browsers except for old Androids.
    touchZoom: touch && !android23,
    // @option bounceAtZoomLimits: Boolean = true
    // Set it to false if you don't want the map to zoom beyond min/max zoom
    // and then bounce back when pinch-zooming.
    bounceAtZoomLimits: true
  });
  var TouchZoom = Handler.extend({
    addHooks: function () {
      addClass(this._map._container, 'leaflet-touch-zoom');
      on(this._map._container, 'touchstart', this._onTouchStart, this);
    },
    removeHooks: function () {
      removeClass(this._map._container, 'leaflet-touch-zoom');
      off(this._map._container, 'touchstart', this._onTouchStart, this);
    },
    _onTouchStart: function (e) {
      var map = this._map;

      if (!e.touches || e.touches.length !== 2 || map._animatingZoom || this._zooming) {
        return;
      }

      var p1 = map.mouseEventToContainerPoint(e.touches[0]),
          p2 = map.mouseEventToContainerPoint(e.touches[1]);
      this._centerPoint = map.getSize()._divideBy(2);
      this._startLatLng = map.containerPointToLatLng(this._centerPoint);

      if (map.options.touchZoom !== 'center') {
        this._pinchStartLatLng = map.containerPointToLatLng(p1.add(p2)._divideBy(2));
      }

      this._startDist = p1.distanceTo(p2);
      this._startZoom = map.getZoom();
      this._moved = false;
      this._zooming = true;

      map._stop();

      on(document, 'touchmove', this._onTouchMove, this);
      on(document, 'touchend', this._onTouchEnd, this);
      preventDefault(e);
    },
    _onTouchMove: function (e) {
      if (!e.touches || e.touches.length !== 2 || !this._zooming) {
        return;
      }

      var map = this._map,
          p1 = map.mouseEventToContainerPoint(e.touches[0]),
          p2 = map.mouseEventToContainerPoint(e.touches[1]),
          scale = p1.distanceTo(p2) / this._startDist;

      this._zoom = map.getScaleZoom(scale, this._startZoom);

      if (!map.options.bounceAtZoomLimits && (this._zoom < map.getMinZoom() && scale < 1 || this._zoom > map.getMaxZoom() && scale > 1)) {
        this._zoom = map._limitZoom(this._zoom);
      }

      if (map.options.touchZoom === 'center') {
        this._center = this._startLatLng;

        if (scale === 1) {
          return;
        }
      } else {
        // Get delta from pinch to center, so centerLatLng is delta applied to initial pinchLatLng
        var delta = p1._add(p2)._divideBy(2)._subtract(this._centerPoint);

        if (scale === 1 && delta.x === 0 && delta.y === 0) {
          return;
        }

        this._center = map.unproject(map.project(this._pinchStartLatLng, this._zoom).subtract(delta), this._zoom);
      }

      if (!this._moved) {
        map._moveStart(true, false);

        this._moved = true;
      }

      cancelAnimFrame(this._animRequest);
      var moveFn = bind(map._move, map, this._center, this._zoom, {
        pinch: true,
        round: false
      });
      this._animRequest = requestAnimFrame(moveFn, this, true);
      preventDefault(e);
    },
    _onTouchEnd: function () {
      if (!this._moved || !this._zooming) {
        this._zooming = false;
        return;
      }

      this._zooming = false;
      cancelAnimFrame(this._animRequest);
      off(document, 'touchmove', this._onTouchMove);
      off(document, 'touchend', this._onTouchEnd); // Pinch updates GridLayers' levels only when zoomSnap is off, so zoomSnap becomes noUpdate.

      if (this._map.options.zoomAnimation) {
        this._map._animateZoom(this._center, this._map._limitZoom(this._zoom), true, this._map.options.zoomSnap);
      } else {
        this._map._resetView(this._center, this._map._limitZoom(this._zoom));
      }
    }
  }); // @section Handlers
  // @property touchZoom: Handler
  // Touch zoom handler.

  Map.addInitHook('addHandler', 'touchZoom', TouchZoom);
  Map.BoxZoom = BoxZoom;
  Map.DoubleClickZoom = DoubleClickZoom;
  Map.Drag = Drag;
  Map.Keyboard = Keyboard;
  Map.ScrollWheelZoom = ScrollWheelZoom;
  Map.Tap = Tap;
  Map.TouchZoom = TouchZoom;
  Object.freeze = freeze;
  exports.version = version;
  exports.Control = Control;
  exports.control = control;
  exports.Browser = Browser;
  exports.Evented = Evented;
  exports.Mixin = Mixin;
  exports.Util = Util;
  exports.Class = Class;
  exports.Handler = Handler;
  exports.extend = extend;
  exports.bind = bind;
  exports.stamp = stamp;
  exports.setOptions = setOptions;
  exports.DomEvent = DomEvent;
  exports.DomUtil = DomUtil;
  exports.PosAnimation = PosAnimation;
  exports.Draggable = Draggable;
  exports.LineUtil = LineUtil;
  exports.PolyUtil = PolyUtil;
  exports.Point = Point;
  exports.point = toPoint;
  exports.Bounds = Bounds;
  exports.bounds = toBounds;
  exports.Transformation = Transformation;
  exports.transformation = toTransformation;
  exports.Projection = index;
  exports.LatLng = LatLng;
  exports.latLng = toLatLng;
  exports.LatLngBounds = LatLngBounds;
  exports.latLngBounds = toLatLngBounds;
  exports.CRS = CRS;
  exports.GeoJSON = GeoJSON;
  exports.geoJSON = geoJSON;
  exports.geoJson = geoJson;
  exports.Layer = Layer;
  exports.LayerGroup = LayerGroup;
  exports.layerGroup = layerGroup;
  exports.FeatureGroup = FeatureGroup;
  exports.featureGroup = featureGroup;
  exports.ImageOverlay = ImageOverlay;
  exports.imageOverlay = imageOverlay;
  exports.VideoOverlay = VideoOverlay;
  exports.videoOverlay = videoOverlay;
  exports.DivOverlay = DivOverlay;
  exports.Popup = Popup;
  exports.popup = popup;
  exports.Tooltip = Tooltip;
  exports.tooltip = tooltip;
  exports.Icon = Icon;
  exports.icon = icon;
  exports.DivIcon = DivIcon;
  exports.divIcon = divIcon;
  exports.Marker = Marker;
  exports.marker = marker;
  exports.TileLayer = TileLayer;
  exports.tileLayer = tileLayer;
  exports.GridLayer = GridLayer;
  exports.gridLayer = gridLayer;
  exports.SVG = SVG;
  exports.svg = svg$1;
  exports.Renderer = Renderer;
  exports.Canvas = Canvas;
  exports.canvas = canvas$1;
  exports.Path = Path;
  exports.CircleMarker = CircleMarker;
  exports.circleMarker = circleMarker;
  exports.Circle = Circle;
  exports.circle = circle;
  exports.Polyline = Polyline;
  exports.polyline = polyline;
  exports.Polygon = Polygon;
  exports.polygon = polygon;
  exports.Rectangle = Rectangle;
  exports.rectangle = rectangle;
  exports.Map = Map;
  exports.map = createMap;
  var oldL = window.L;

  exports.noConflict = function () {
    window.L = oldL;
    return this;
  }; // Always export us to window global (see #2364)


  window.L = exports;
});

/***/ })

}]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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