(self["webpackJsonp"] = self["webpackJsonp"] || []).push([["vendors~hui-unused-entities~panel-config-areas~panel-config-automation~panel-config-devices~panel-co~ec251abe"],{

/***/ "./node_modules/lit-virtualizer/lib/lit-virtualizer.js":
/*!*************************************************************!*\
  !*** ./node_modules/lit-virtualizer/lib/lit-virtualizer.js ***!
  \*************************************************************/
/*! exports provided: LitVirtualizer */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "LitVirtualizer", function() { return LitVirtualizer; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var lit_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lit-element */ "./node_modules/lit-element/lit-element.js");
/* harmony import */ var _scroll_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./scroll.js */ "./node_modules/lit-virtualizer/lib/scroll.js");



/**
 * A LitElement wrapper of the scroll directive.
 *
 * Import this module to declare the lit-virtualizer custom element.
 * Pass an items array, renderItem method, and scroll target as properties
 * to the <lit-virtualizer> element.
 */

let LitVirtualizer = class LitVirtualizer extends lit_element__WEBPACK_IMPORTED_MODULE_1__["LitElement"] {
  constructor() {
    super();
    this.renderRoot = this;
  }
  /**
   * The method used for rendering each item.
   */


  get renderItem() {
    return this._renderItem;
  }

  set renderItem(renderItem) {
    if (renderItem !== this.renderItem) {
      this._renderItem = renderItem;
      this.requestUpdate();
    }
  }
  /**
   * Scroll to the specified index, placing that item at the given position
   * in the scroll view.
   */


  async scrollToIndex(index, position = 'start') {
    this._scrollToIndex = {
      index,
      position
    };
    this.requestUpdate();
    await this.updateComplete;
    this._scrollToIndex = null;
  }

  render() {
    return lit_element__WEBPACK_IMPORTED_MODULE_1__["html"]`${Object(_scroll_js__WEBPACK_IMPORTED_MODULE_2__["scroll"])({
      items: this.items,
      renderItem: this._renderItem,
      scrollTarget: this.scrollTarget,
      scrollToIndex: this._scrollToIndex,
      useShadowDOM: true // TODO: allow configuration of a layout.

    })}`;
  }

};

tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([Object(lit_element__WEBPACK_IMPORTED_MODULE_1__["property"])()], LitVirtualizer.prototype, "_renderItem", void 0);

tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([Object(lit_element__WEBPACK_IMPORTED_MODULE_1__["property"])()], LitVirtualizer.prototype, "items", void 0);

tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([Object(lit_element__WEBPACK_IMPORTED_MODULE_1__["property"])()], LitVirtualizer.prototype, "scrollTarget", void 0);

LitVirtualizer = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([Object(lit_element__WEBPACK_IMPORTED_MODULE_1__["customElement"])('lit-virtualizer')], LitVirtualizer);


/***/ }),

/***/ "./node_modules/lit-virtualizer/lib/repeat.js":
/*!****************************************************!*\
  !*** ./node_modules/lit-virtualizer/lib/repeat.js ***!
  \****************************************************/
/*! exports provided: LitMixin, LitRepeater, repeat */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "LitMixin", function() { return LitMixin; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "LitRepeater", function() { return LitRepeater; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "repeat", function() { return repeat; });
/* harmony import */ var lit_html__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lit-html */ "./node_modules/lit-html/lit-html.js");
/* harmony import */ var _uni_virtualizer_lib_VirtualRepeater_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./uni-virtualizer/lib/VirtualRepeater.js */ "./node_modules/lit-virtualizer/lib/uni-virtualizer/lib/VirtualRepeater.js");


/**
 * Mixin for VirtualRepeater and VirtualScroller. This mixin overrides the generic
 * methods in those classes to provide lit-specific implementations of element
 * creation and manipulation.
 *
 * This mixin implements child recycling, so children can be reused after removal
 * from the DOM.
 */

const LitMixin = Superclass => class extends Superclass {
  constructor(config) {
    const {
      part,
      renderItem,
      useShadowDOM,
      layout
    } = config;
    const container = part.startNode.parentNode;
    const scrollTarget = config.scrollTarget || container;
    super({
      container,
      scrollTarget,
      useShadowDOM,
      layout
    });
    this._pool = [];
    this._renderItem = renderItem;
    this._hostPart = part;
  }

  createElement() {
    return this._pool.pop() || new lit_html__WEBPACK_IMPORTED_MODULE_0__["NodePart"](this._hostPart.options);
  }

  updateElement(part, item, idx) {
    part.setValue(this._renderItem(item, idx));
    part.commit();
  }

  recycleElement(part) {
    this._pool.push(part);
  }
  /*
   * Lit-specific overrides for node manipulation
   */


  get _kids() {
    return this._ordered.map(p => p.startNode.nextElementSibling);
  }

  _node(part) {
    return part.startNode;
  }

  _nextSibling(part) {
    return part.endNode.nextSibling;
  }

  _insertBefore(part, referenceNode) {
    if (referenceNode === null) {
      referenceNode = this._hostPart.endNode;
    }

    if (!this._childIsAttached(part)) {
      // Inserting new part
      part.startNode = Object(lit_html__WEBPACK_IMPORTED_MODULE_0__["createMarker"])();
      part.endNode = Object(lit_html__WEBPACK_IMPORTED_MODULE_0__["createMarker"])();

      super._insertBefore(part.startNode, referenceNode);

      super._insertBefore(part.endNode, referenceNode);
    } else {
      // Inserting existing part
      const boundary = part.endNode.nextSibling;

      if (referenceNode !== part.startNode && referenceNode !== boundary) {
        // Part is not already in the right place
        for (let node = part.startNode; node !== boundary;) {
          const n = node.nextSibling;

          super._insertBefore(node, referenceNode);

          node = n;
        }
      }
    }
  }

  _hideChild(part) {
    let node = part.startNode;

    while (node && node !== part.endNode) {
      super._hideChild(node);

      node = node.nextSibling;
    }
  }

  _showChild(part) {
    let node = part.startNode;

    while (node && node !== part.endNode) {
      super._showChild(node);

      node = node.nextSibling;
    }
  }

  _measureChild(part) {
    // Currently, we assume there's only one node in the part (between start and
    // end nodes)
    return super._measureChild(part.startNode.nextElementSibling);
  }

};
class LitRepeater extends LitMixin(_uni_virtualizer_lib_VirtualRepeater_js__WEBPACK_IMPORTED_MODULE_1__["VirtualRepeater"]) {}
;
const partToRepeater = new WeakMap();
const repeat = Object(lit_html__WEBPACK_IMPORTED_MODULE_0__["directive"])(config => async part => {
  // Retain the repeater so that re-rendering the directive's parent won't
  // create another one.
  let repeater = partToRepeater.get(part);

  if (!repeater) {
    if (!part.startNode.isConnected) {
      await Promise.resolve();
    }

    repeater = new LitRepeater({
      part,
      renderItem: config.renderItem
    });
    partToRepeater.set(part, repeater);
  }

  const {
    first,
    num,
    totalItems
  } = config;
  Object.assign(repeater, {
    first,
    num,
    totalItems
  });
});

/***/ }),

/***/ "./node_modules/lit-virtualizer/lib/scroll.js":
/*!****************************************************!*\
  !*** ./node_modules/lit-virtualizer/lib/scroll.js ***!
  \****************************************************/
/*! exports provided: LitScroller, scroll */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "LitScroller", function() { return LitScroller; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "scroll", function() { return scroll; });
/* harmony import */ var lit_html__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lit-html */ "./node_modules/lit-html/lit-html.js");
/* harmony import */ var _uni_virtualizer_lib_VirtualScroller_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./uni-virtualizer/lib/VirtualScroller.js */ "./node_modules/lit-virtualizer/lib/uni-virtualizer/lib/VirtualScroller.js");
/* harmony import */ var _repeat_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./repeat.js */ "./node_modules/lit-virtualizer/lib/repeat.js");



class LitScroller extends Object(_repeat_js__WEBPACK_IMPORTED_MODULE_2__["LitMixin"])(_uni_virtualizer_lib_VirtualScroller_js__WEBPACK_IMPORTED_MODULE_1__["VirtualScroller"]) {}
const partToScroller = new WeakMap();
/**
 * A lit-html directive that turns its parent node into a virtual scroller.
 *
 * See ScrollConfig interface for configuration options.
 */

const scroll = Object(lit_html__WEBPACK_IMPORTED_MODULE_0__["directive"])(config => async part => {
  // Retain the scroller so that re-rendering the directive's parent won't
  // create another one.
  let scroller = partToScroller.get(part);

  if (!scroller) {
    if (!part.startNode.isConnected) {
      await Promise.resolve();
    }

    const {
      renderItem,
      layout,
      scrollTarget,
      useShadowDOM
    } = config;
    scroller = new LitScroller({
      part,
      renderItem,
      layout,
      scrollTarget,
      useShadowDOM
    });
    partToScroller.set(part, scroller);
  }

  Object.assign(scroller, {
    items: config.items,
    totalItems: config.totalItems === undefined ? null : config.totalItems,
    scrollToIndex: config.scrollToIndex === undefined ? null : config.scrollToIndex
  });
});

/***/ }),

/***/ "./node_modules/lit-virtualizer/lib/uni-virtualizer/lib/VirtualRepeater.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/lit-virtualizer/lib/uni-virtualizer/lib/VirtualRepeater.js ***!
  \*********************************************************************************/
/*! exports provided: VirtualRepeater */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "VirtualRepeater", function() { return VirtualRepeater; });
class VirtualRepeater {
  constructor(config) {
    /**
     * Invoked when a new (not recycled) child needs to be displayed.
     * Set by createElement.
     */
    this._createElementFn = null;
    /**
     * Invoked on new (including recycled) children after the range changes.
     * Set by updateElement.
     */

    this._updateElementFn = null;
    /**
     * Invoked on outgoing children after the range changes. Set by recycleElement.
     */

    this._recycleElementFn = null;
    /**
     * Used for generating a key for storing references to children. Set by elementKey.
     */

    this._elementKeyFn = null;
    /**
     * Items to render. Set by items.
     */

    this._items = [];
    /**
     * Total number of items to render. Set by totalItems.
     */

    this._totalItems = null;
    /**
     * Flag for asynchnronous reset requests. Resetting clears and reinserts
     * children in the range.
     */

    this._needsReset = false;
    /**
     * Flag for asynchnronous remeasure requests. Signals that all children
     * should be remeasured.
     */

    this._needsRemeasure = false;
    /**
     * Used to keep track of children that can be cleaned up after a range update.
     */

    this._active = new Map();
    this._prevActive = new Map();
    /**
     * Used for recycling purposes.
     */

    this._keyToChild = new Map();
    this._childToKey = new WeakMap();
    /**
     * Used to keep track of measures by index.
     */

    this._indexToMeasure = {};
    this.__incremental = false;
    /**
     * Invoked at the end of each render cycle: children in the range are
     * measured, and their dimensions passed to this callback. Use it to layout
     * children as needed.
     */

    this._measureCallback = null;
    /**
     * Number of children in the range. Set by num.
     * TODO @straversi: Consider renaming this. count? visibleElements?
     */

    this._num = Infinity;
    /**
     * Index of the first child in the range, not necessarily the first visible child.
     * TODO @straversi: Consider renaming these.
     */

    this._first = 0;
    /**
     * Index of the last child in the range.
     */

    this._last = 0;
    /**
     * Previous first rendered index. Used to avoid unnecessary updates.
     */

    this._prevFirst = 0;
    /**
     * Previous last rendered index. Used to avoid unnecessary updates.
     */

    this._prevLast = 0;
    /**
     * Flag for asynchnronous render requests. Renders can be requested several
     * times before a render actually happens.
     */

    this._pendingRender = null;
    /**
     * Containing element. Set by container.
     */

    this._container = null;
    /**
     * Children in the rendered order.
     */

    this._ordered = [];

    if (config) {
      Object.assign(this, config);
    }
  } // API

  /**
   * The parent of all child nodes to be rendered.
   */


  get container() {
    return this._container;
  }

  set container(container) {
    if (container === this._container) {
      return;
    }

    if (this._container) {
      // Remove children from old container.
      this._ordered.forEach(child => this._removeChild(child));
    }

    this._container = container;

    if (container) {
      // Insert children in new container.
      this._ordered.forEach(child => this._insertBefore(child, null));
    } else {
      this._ordered.length = 0;

      this._active.clear();

      this._prevActive.clear();
    }

    this.requestReset();
  }
  /**
   * Invoked to create a child.
   * Override or set directly to control element creation.
   */


  get createElement() {
    return this._createElementFn;
  }

  set createElement(fn) {
    if (fn !== this._createElementFn) {
      this._createElementFn = fn;

      this._keyToChild.clear();

      this.requestReset();
    }
  }
  /**
   * Invoked to update a child.
   * Override or set directly to control element updates.
   */


  get updateElement() {
    return this._updateElementFn;
  }

  set updateElement(fn) {
    if (fn !== this._updateElementFn) {
      this._updateElementFn = fn;
      this.requestReset();
    }
  }
  /**
   * Invoked in place of removing a child from the DOM, so that it can be reused.
   * Override or set directly to prepare children for reuse.
   */


  get recycleElement() {
    return this._recycleElementFn;
  }

  set recycleElement(fn) {
    if (fn !== this._recycleElementFn) {
      this._recycleElementFn = fn;
      this.requestReset();
    }
  }
  /**
   * Invoked to generate a key for an element.
   * Override or set directly to control how keys are generated for children.
   */


  get elementKey() {
    return this._elementKeyFn;
  }

  set elementKey(fn) {
    if (fn !== this._elementKeyFn) {
      this._elementKeyFn = fn;

      this._keyToChild.clear();

      this.requestReset();
    }
  }
  /**
   * The index of the first child in the range.
   */


  get first() {
    return this._first;
  }

  set first(idx) {
    if (typeof idx !== 'number') {
      throw new Error('New value must be a number.');
    }

    const newFirst = Math.max(0, Math.min(idx, this.totalItems - this._num));

    if (newFirst !== this._first) {
      this._first = newFirst;

      this._scheduleRender();
    }
  }
  /**
   * The number of children in the range.
   */


  get num() {
    return this._num;
  }

  set num(n) {
    if (typeof n !== 'number') {
      throw new Error('New value must be a number.');
    }

    if (n !== this._num) {
      this._num = n;
      this.first = this._first;

      this._scheduleRender();
    }
  }
  /**
   * An array of data to be used to render child nodes.
   */


  get items() {
    return this._items;
  }

  set items(items) {
    if (items !== this._items && Array.isArray(items)) {
      this._items = items;
      this.requestReset();
    }
  }
  /**
   * The total number of items, regardless of the range, that can be rendered
   * as child nodes.
   */


  get totalItems() {
    return this._totalItems === null ? this._items.length : this._totalItems;
  }

  set totalItems(num) {
    if (typeof num !== 'number' && num !== null) {
      throw new Error('New value must be a number.');
    } // TODO(valdrin) should we check if it is a finite number?
    // Technically, Infinity would break Layout, not VirtualRepeater.


    if (num !== this._totalItems) {
      this._totalItems = num;
      this.first = this._first;
      this.requestReset();
    }
  }
  /**
   * TODO @straversi: Document this.
   */


  get _incremental() {
    return this.__incremental;
  }

  set _incremental(inc) {
    if (inc !== this.__incremental) {
      this.__incremental = inc;

      this._scheduleRender();
    }
  }
  /**
   * Invoke to request that all elements in the range be measured.
   */


  requestRemeasure() {
    this._needsRemeasure = true;

    this._scheduleRender();
  } // Core functionality


  _shouldRender() {
    return Boolean(this.container && this.createElement);
  }
  /**
   * Render at the next opportunity.
   */


  async _scheduleRender() {
    if (!this._pendingRender) {
      this._pendingRender = true;
      await Promise.resolve();
      this._pendingRender = false;

      if (this._shouldRender()) {
        this._render();
      } // this._pendingRender = requestAnimationFrame(() => {
      //   this._pendingRender = null;
      //   if (this._shouldRender()) {
      //     this._render();
      //   }
      // });

    }
  }
  /**
   * Invoke to request that all elements in the range be updated.
   */


  requestReset() {
    this._needsReset = true;

    this._scheduleRender();
  }
  /**
   * Returns those children that are about to be displayed and that require to
   * be positioned. If reset or remeasure has been triggered, all children are
   * returned.
   */


  get _toMeasure() {
    return this._ordered.reduce((toMeasure, c, i) => {
      const idx = this._first + i;

      if (this._needsReset || this._needsRemeasure || idx < this._prevFirst || idx > this._prevLast) {
        toMeasure.indices.push(idx);
        toMeasure.children.push(c);
      }

      return toMeasure;
    }, {
      indices: [],
      children: []
    });
  }
  /**
   * Measures each child bounds and builds a map of index/bounds to be passed
   * to the `_measureCallback`
   */


  async _measureChildren({
    indices,
    children
  }) {
    await new Promise(resolve => {
      requestAnimationFrame(resolve);
    });
    const pm = children.map(c => this._measureChild(c));
    const mm =
    /** @type {{number: {width: number, height: number}}} */
    pm.reduce((out, cur, i) => {
      out[indices[i]] = this._indexToMeasure[indices[i]] = cur;
      return out;
    }, {});

    this._measureCallback(mm);
  }
  /**
   * Render items within the current range to the DOM.
   */


  async _render() {
    const rangeChanged = this._first !== this._prevFirst || this._num !== this._prevNum; // Create/update/recycle DOM.

    if (rangeChanged || this._needsReset) {
      this._last = this._first + Math.min(this._num, this.totalItems - this._first) - 1;

      if (this._num || this._prevNum) {
        if (this._needsReset) {
          this._reset(this._first, this._last);
        } else {
          // Remove old children and insert new children without touching
          // shared children.
          this._discardHead();

          this._discardTail();

          this._addHead();

          this._addTail();
        }
      }
    }

    if (this._needsRemeasure || this._needsReset) {
      this._indexToMeasure = {};
    } // Retrieve DOM to be measured.
    // Do it right before cleanup and reset of properties.


    const shouldMeasure = this._num > 0 && this._measureCallback && (rangeChanged || this._needsRemeasure || this._needsReset);
    const toMeasure = shouldMeasure ? this._toMeasure : null; // Cleanup.

    if (!this._incremental) {
      this._prevActive.forEach((idx, child) => this._unassignChild(child, idx));

      this._prevActive.clear();
    } // Reset internal properties.


    this._prevFirst = this._first;
    this._prevLast = this._last;
    this._prevNum = this._num;
    this._needsReset = false;
    this._needsRemeasure = false; // Notify render completed.

    this._didRender(); // Measure DOM.


    if (toMeasure) {
      await this._measureChildren(toMeasure);
    }
  }
  /**
   * Invoked after DOM is updated, and before it gets measured.
   */


  _didRender() {}
  /**
   * Unassigns any children at indices lower than the start of the current
   * range.
   */


  _discardHead() {
    const o = this._ordered;

    for (let idx = this._prevFirst; o.length && idx < this._first; idx++) {
      this._unassignChild(o.shift(), idx);
    }
  }
  /**
   * Unassigns any children at indices higher than the end of the current
   * range.
   */


  _discardTail() {
    const o = this._ordered;

    for (let idx = this._prevLast; o.length && idx > this._last; idx--) {
      this._unassignChild(o.pop(), idx);
    }
  }
  /**
   * Assigns and inserts non-existent children from the current range with
   * indices lower than the start of the previous range.
   */


  _addHead() {
    const start = this._first;
    const end = Math.min(this._last, this._prevFirst - 1);

    for (let idx = end; idx >= start; idx--) {
      const child = this._assignChild(idx); // Maintain dom order.


      this._insertBefore(child, this._firstChild);

      if (this.updateElement) {
        this.updateElement(child, this._items[idx], idx);
      }

      this._ordered.unshift(child);
    }
  }
  /**
   * Assigns and appends non-existent children from the current range with
   * indices higher than the end of the previous range.
   */


  _addTail() {
    const start = Math.max(this._first, this._prevLast + 1);
    const end = this._last;

    for (let idx = start; idx <= end; idx++) {
      const child = this._assignChild(idx); // Maintain dom order.


      this._insertBefore(child, null);

      if (this.updateElement) {
        this.updateElement(child, this._items[idx], idx);
      }

      this._ordered.push(child);
    }
  }
  /**
   * Re-insert and update children in the given range.
   */


  _reset(first, last) {
    // Swapping prevActive with active affects _assignChild.
    // Upon resetting, the current active children become potentially inactive.
    // _assignChild will remove a child from _prevActive if it is still active.
    const prevActive = this._active;
    this._active = this._prevActive;
    this._prevActive = prevActive;
    this._ordered.length = 0;
    let currentMarker = this._firstChild;

    for (let i = first; i <= last; i++) {
      const child = this._assignChild(i);

      this._ordered.push(child);

      if (currentMarker) {
        if (currentMarker === this._node(child)) {
          currentMarker = this._nextSibling(child);
        } else {
          this._insertBefore(child, currentMarker);
        }
      } else if (!this._childIsAttached(child)) {
        this._insertBefore(child, null);
      }

      if (this.updateElement) {
        this.updateElement(child, this._items[i], i);
      }
    }
  }
  /**
   * Instantiates, tracks, and returns the child at idx.
   * Prevents cleanup of children that already exist.
   * Returns the new child at idx.
   */


  _assignChild(idx) {
    const key = this.elementKey ? this.elementKey(idx) : idx;
    let child;

    if (child = this._keyToChild.get(key)) {
      this._prevActive.delete(child);
    } else {
      child = this.createElement(this._items[idx], idx);

      this._keyToChild.set(key, child);

      this._childToKey.set(child, key);
    }

    this._showChild(child);

    this._active.set(child, idx);

    return child;
  }
  /**
   * Removes the child at idx, recycling it if possible.
   */


  _unassignChild(child, idx) {
    this._hideChild(child);

    if (this._incremental) {
      this._active.delete(child);

      this._prevActive.set(child, idx);
    } else {
      const key = this._childToKey.get(child);

      this._childToKey.delete(child);

      this._keyToChild.delete(key);

      this._active.delete(child);

      if (this.recycleElement) {
        this.recycleElement(child, idx);
      } else if (this._node(child).parentNode) {
        this._removeChild(child);
      }
    }
  }
  /**
   * Returns the node for the first child in the current range, if the node is
   * in the DOM.
   * TODO: Is this the right name?
   */


  get _firstChild() {
    return this._ordered.length && this._childIsAttached(this._ordered[0]) ? this._node(this._ordered[0]) : null;
  }
  /**
   * Overridable abstractions for child manipulation
   */

  /**
   * Return the node for child.
   * Override if child !== child's node.
   */


  _node(child) {
    return child;
  }
  /**
   * Returns the next node sibling of a child node.
   */


  _nextSibling(child) {
    return child.nextSibling;
  }
  /**
   * Inserts child before referenceNode in the container.
   * Override to control child insertion.
   */


  _insertBefore(child, referenceNode) {
    this._container.insertBefore(child, referenceNode);
  }
  /**
   * Removes child from the DOM.
   * TODO @straversi: this will not work (_node should be called on child), but
   * is not currently being used or tested.
   */


  _removeChild(child) {
    child.parentNode.removeChild(child);
  }
  /**
   * Returns whether the child's node is a child of the container
   * element.
   */


  _childIsAttached(child) {
    const node = this._node(child);

    return node && node.parentNode === this._container;
  }
  /**
   * Sets the display style of the given node to 'none'.
   */


  _hideChild(child) {
    if (child instanceof HTMLElement) {
      child.style.display = 'none';
    }
  }
  /**
   * Sets the display style of the given node to null.
   */


  _showChild(child) {
    if (child instanceof HTMLElement) {
      child.style.display = null;
    }
  }
  /**
   * Returns the width, height, and margins of the given child.
   * Override if child !== child's node.
   */


  _measureChild(child) {
    // offsetWidth doesn't take transforms in consideration, so we use
    // getBoundingClientRect which does.
    const {
      width,
      height
    } = child.getBoundingClientRect();
    return Object.assign({
      width,
      height
    }, getMargins(child));
  }

}

function getMargins(el) {
  const style = window.getComputedStyle(el);
  return {
    marginTop: getMarginValue(style.marginTop),
    marginRight: getMarginValue(style.marginRight),
    marginBottom: getMarginValue(style.marginBottom),
    marginLeft: getMarginValue(style.marginLeft)
  };
}

function getMarginValue(value) {
  const float = value ? parseFloat(value) : NaN;
  return Number.isNaN(float) ? 0 : float;
}

/***/ }),

/***/ "./node_modules/lit-virtualizer/lib/uni-virtualizer/lib/VirtualScroller.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/lit-virtualizer/lib/uni-virtualizer/lib/VirtualScroller.js ***!
  \*********************************************************************************/
/*! exports provided: RangeChangeEvent, VirtualScroller */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "RangeChangeEvent", function() { return RangeChangeEvent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "VirtualScroller", function() { return VirtualScroller; });
/* harmony import */ var _VirtualRepeater_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./VirtualRepeater.js */ "./node_modules/lit-virtualizer/lib/uni-virtualizer/lib/VirtualRepeater.js");
/* harmony import */ var _polyfillLoaders_ResizeObserver_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./polyfillLoaders/ResizeObserver.js */ "./node_modules/lit-virtualizer/lib/uni-virtualizer/lib/polyfillLoaders/ResizeObserver.js");


const HOST_CLASSNAME = 'uni-virtualizer-host';
let globalContainerStylesheet = null;

function containerStyles(hostSel, childSel) {
  return `
    ${hostSel} {
      display: block;
      position: relative;
      contain: strict;
      height: 150px;
      overflow: auto;
    }
    ${childSel} {
      box-sizing: border-box;
    }`;
}

function attachGlobalContainerStylesheet() {
  if (!globalContainerStylesheet) {
    globalContainerStylesheet = document.createElement('style');
    globalContainerStylesheet.textContent = containerStyles(`.${HOST_CLASSNAME}`, `.${HOST_CLASSNAME} > *`);
    document.head.appendChild(globalContainerStylesheet);
  }
}

class RangeChangeEvent extends Event {
  constructor(type, init) {
    super(type, init);
    this._first = Math.floor(init.first || 0);
    this._last = Math.floor(init.last || 0);
    this._firstVisible = Math.floor(init.firstVisible || 0);
    this._lastVisible = Math.floor(init.lastVisible || 0);
  }

  get first() {
    return this._first;
  }

  get last() {
    return this._last;
  }

  get firstVisible() {
    return this._firstVisible;
  }

  get lastVisible() {
    return this._lastVisible;
  }

}
/**
 * Provides virtual scrolling boilerplate.
 *
 * Extensions of this class must set container, layout, scrollTarget, and
 * useShadowDOM.
 *
 * Extensions of this class must also override VirtualRepeater's DOM
 * manipulation methods.
 */

class VirtualScroller extends _VirtualRepeater_js__WEBPACK_IMPORTED_MODULE_0__["VirtualRepeater"] {
  constructor(config) {
    super({});
    /**
     * Whether the layout should receive an updated viewport size on the next
     * render.
     */

    this._needsUpdateView = false;
    this._layout = null;
    /**
     * Whether to import the default (1d) layout on first render.
     */

    this._lazyLoadDefaultLayout = true;
    /**
     * The element that generates scroll events and defines the container
     * viewport. Set by scrollTarget.
     */

    this._scrollTarget = null;
    /**
     * A sentinel element that sizes the container when it is a scrolling
     * element. This ensures the scroll bar accurately reflects the total
     * size of the list.
     */

    this._sizer = null;
    /**
     * Layout provides these values, we set them on _render().
     * TODO @straversi: Can we find an XOR type, usable for the key here?
     */

    this._scrollSize = null;
    /**
     * Difference between scroll target's current and required scroll offsets.
     * Provided by layout.
     */

    this._scrollErr = null;
    /**
     * A list of the positions (top, left) of the children in the current range.
     */

    this._childrenPos = null;
    /**
     * The parent of all child nodes to be rendered. Set by container.
     */

    this._containerElement = null;
    /**
     * Keep track of original inline style of the container, so it can be
     * restored when container is changed.
     */

    this._containerInlineStyle = null;
    /**
     * Keep track of original container stylesheet, so it can be restored
     * when container is changed.
     */

    this._containerStylesheet = null;
    /**
     * Whether to build the virtual scroller within a shadow DOM.
     */

    this._useShadowDOM = true;
    /**
     * Size of the container.
     */

    this._containerSize = null;
    /**
     * Resize observer attached to container.
     */

    this._containerRO = null;
    /**
     * Resize observer attached to children.
     */

    this._childrenRO = null;
    /**
     * Flag for skipping a children measurement if that computation was just
     * completed.
     */

    this._skipNextChildrenSizeChanged = false;
    /**
     * Index and position of item to scroll to.
     */

    this._scrollToIndex = null;
    this._num = 0;
    this._first = -1;
    this._last = -1;
    this._prevFirst = -1;
    this._prevLast = -1;

    if (config) {
      Object.assign(this, config);
    }
  }

  get container() {
    return super.container;
  }

  set container(container) {
    super.container = container;

    this._initResizeObservers().then(() => {
      const oldEl = this._containerElement; // Consider document fragments as shadowRoots.

      const newEl = container && container.nodeType === Node.DOCUMENT_FRAGMENT_NODE ? container.host : container;

      if (oldEl === newEl) {
        return;
      }

      this._containerRO.disconnect();

      this._containerSize = null;

      if (oldEl) {
        if (this._containerInlineStyle) {
          oldEl.setAttribute('style', this._containerInlineStyle);
        } else {
          oldEl.removeAttribute('style');
        }

        this._containerInlineStyle = null;

        if (oldEl === this._scrollTarget) {
          oldEl.removeEventListener('scroll', this, {
            passive: true
          });
          this._sizer && this._sizer.remove();
        }
      } else {
        // First time container was setup, add listeners only now.
        addEventListener('scroll', this, {
          passive: true
        });
      }

      this._containerElement = newEl;

      if (newEl) {
        this._containerInlineStyle = newEl.getAttribute('style') || null;

        this._applyContainerStyles();

        if (newEl === this._scrollTarget) {
          this._sizer = this._sizer || this._createContainerSizer();

          this._container.prepend(this._sizer);
        }

        this._scheduleUpdateView();

        this._containerRO.observe(newEl);
      }
    });
  }

  get layout() {
    return this._layout;
  }

  set layout(layout) {
    if (layout === this._layout) {
      return;
    }

    if (this._layout) {
      this._measureCallback = null;

      this._layout.removeEventListener('scrollsizechange', this);

      this._layout.removeEventListener('scrollerrorchange', this);

      this._layout.removeEventListener('itempositionchange', this);

      this._layout.removeEventListener('rangechange', this); // Reset container size so layout can get correct viewport size.


      if (this._containerElement) {
        this._sizeContainer(undefined);
      }
    }

    this._layout = layout;

    if (this._layout) {
      if (typeof this._layout.updateItemSizes === 'function') {
        this._measureCallback = this._layout.updateItemSizes.bind(this._layout);
        this.requestRemeasure();
      }

      this._layout.addEventListener('scrollsizechange', this);

      this._layout.addEventListener('scrollerrorchange', this);

      this._layout.addEventListener('itempositionchange', this);

      this._layout.addEventListener('rangechange', this);

      this._scheduleUpdateView();
    }
  }
  /**
   * The element that generates scroll events and defines the container
   * viewport. The value `null` (default) corresponds to `window` as scroll
   * target.
   */


  get scrollTarget() {
    return this._scrollTarget;
  }

  set scrollTarget(target) {
    // Consider window as null.
    if (target === window) {
      target = null;
    }

    if (this._scrollTarget === target) {
      return;
    }

    if (this._scrollTarget) {
      this._scrollTarget.removeEventListener('scroll', this, {
        passive: true
      });

      if (this._sizer && this._scrollTarget === this._containerElement) {
        this._sizer.remove();
      }
    }

    this._scrollTarget = target;

    if (target) {
      target.addEventListener('scroll', this, {
        passive: true
      });

      if (target === this._containerElement) {
        this._sizer = this._sizer || this._createContainerSizer();

        this._container.prepend(this._sizer);
      }
    }
  }

  get useShadowDOM() {
    return this._useShadowDOM;
  }

  set useShadowDOM(newVal) {
    if (this._useShadowDOM !== newVal) {
      this._useShadowDOM = Boolean(newVal);

      if (this._containerStylesheet) {
        this._containerStylesheet.parentElement.removeChild(this._containerStylesheet);

        this._containerStylesheet = null;
      }

      this._applyContainerStyles();
    }
  }
  /**
   * Index and position of item to scroll to. The scroller will fix to that point
   * until the user scrolls.
   */


  set scrollToIndex(newValue) {
    this._scrollToIndex = newValue;

    this._scheduleUpdateView();
  }
  /**
   * Display the items in the current range.
   * Continue relayout of child positions until they have stabilized.
   */


  async _render() {
    if (this._lazyLoadDefaultLayout && !this._layout) {
      this._lazyLoadDefaultLayout = false;
      const {
        Layout1d
      } = await Promise.resolve(/*! import() */).then(__webpack_require__.bind(null, /*! ./layouts/Layout1d */ "./node_modules/lit-virtualizer/lib/uni-virtualizer/lib/layouts/Layout1d.js"));
      this.layout = new Layout1d({});
      return;
    }

    this._childrenRO.disconnect(); // Update layout properties before rendering to have correct first, num,
    // scroll size, children positions.


    this._layout.totalItems = this.totalItems;

    if (this._needsUpdateView) {
      this._needsUpdateView = false;

      this._updateView();
    }

    if (this._scrollToIndex !== null) {
      this._layout.scrollToIndex(this._scrollToIndex.index, this._scrollToIndex.position);

      this._scrollToIndex = null;
    }

    this._layout.reflowIfNeeded(); // Keep rendering until there is no more scheduled renders.


    while (true) {
      if (this._pendingRender) {
        // cancelAnimationFrame(this._pendingRender);
        this._pendingRender = false;
      } // Update scroll size and correct scroll error before rendering.


      this._sizeContainer(this._scrollSize);

      if (this._scrollErr) {
        // This triggers a 'scroll' event (async) which triggers another
        // _updateView().
        this._correctScrollError(this._scrollErr);

        this._scrollErr = null;
      } // Position children (_didRender()), and provide their measures to layout.


      await super._render();

      this._layout.reflowIfNeeded(); // If layout reflow did not provoke another render, we're done.


      if (!this._pendingRender) {
        break;
      }
    } // We want to skip the first ResizeObserver callback call as we already
    // measured the children.


    this._skipNextChildrenSizeChanged = true;

    this._kids.forEach(child => this._childrenRO.observe(child));
  }
  /**
   * Position children before they get measured. Measuring will force relayout,
   * so by positioning them first, we reduce computations.
   */


  _didRender() {
    if (this._childrenPos) {
      this._positionChildren(this._childrenPos);

      this._childrenPos = null;
    }
  }

  handleEvent(event) {
    switch (event.type) {
      case 'scroll':
        if (!this._scrollTarget || event.target === this._scrollTarget) {
          this._scheduleUpdateView();
        }

        break;

      case 'scrollsizechange':
        this._scrollSize = event.detail;

        this._scheduleRender();

        break;

      case 'scrollerrorchange':
        this._scrollErr = event.detail;

        this._scheduleRender();

        break;

      case 'itempositionchange':
        this._childrenPos = event.detail;

        this._scheduleRender();

        break;

      case 'rangechange':
        this._adjustRange(event.detail);

        break;

      default:
        console.warn('event not handled', event);
    }
  }

  async _initResizeObservers() {
    if (this._containerRO === null) {
      const ResizeObserver = await Object(_polyfillLoaders_ResizeObserver_js__WEBPACK_IMPORTED_MODULE_1__["default"])();
      this._containerRO = new ResizeObserver(entries => this._containerSizeChanged(entries[0].contentRect));
      this._childrenRO = new ResizeObserver(() => this._childrenSizeChanged());
    }
  }

  _applyContainerStyles() {
    if (this._useShadowDOM) {
      if (this._containerStylesheet === null) {
        const sheet = this._containerStylesheet = document.createElement('style');
        sheet.textContent = containerStyles(':host', '::slotted(*)');
      }

      const root = this._containerElement.shadowRoot || this._containerElement.attachShadow({
        mode: 'open'
      });

      const slot = root.querySelector('slot:not([name])');
      root.appendChild(this._containerStylesheet);

      if (!slot) {
        root.appendChild(document.createElement('slot'));
      }
    } else {
      attachGlobalContainerStylesheet();

      if (this._containerElement) {
        this._containerElement.classList.add(HOST_CLASSNAME);
      }
    }
  }

  _createContainerSizer() {
    const sizer = document.createElement('div'); // When the scrollHeight is large, the height of this element might be
    // ignored. Setting content and font-size ensures the element has a size.

    Object.assign(sizer.style, {
      position: 'absolute',
      margin: '-2px 0 0 0',
      padding: 0,
      visibility: 'hidden',
      fontSize: '2px'
    });
    sizer.innerHTML = '&nbsp;';
    return sizer;
  }
  /**
   * TODO: Rename _ordered to _kids?
   */


  get _kids() {
    return this._ordered;
  }
  /**
   * Render and update the view at the next opportunity.
   */


  _scheduleUpdateView() {
    this._needsUpdateView = true;

    this._scheduleRender();
  }

  _updateView() {
    let width, height, top, left;

    if (this._scrollTarget === this._containerElement) {
      width = this._containerSize.width;
      height = this._containerSize.height;
      left = this._containerElement.scrollLeft;
      top = this._containerElement.scrollTop;
    } else {
      const containerBounds = this._containerElement.getBoundingClientRect();

      const scrollBounds = this._scrollTarget ? this._scrollTarget.getBoundingClientRect() : {
        top: containerBounds.top + scrollY,
        left: containerBounds.left + scrollX,
        width: innerWidth,
        height: innerHeight
      };
      const scrollerWidth = scrollBounds.width;
      const scrollerHeight = scrollBounds.height;
      const xMin = Math.max(0, Math.min(scrollerWidth, containerBounds.left - scrollBounds.left));
      const yMin = Math.max(0, Math.min(scrollerHeight, containerBounds.top - scrollBounds.top)); // TODO: Direction is intended to be a layout-level concept, not a scroller-level concept,
      // so this feels like a factoring problem

      const xMax = this._layout.direction === 'vertical' ? Math.max(0, Math.min(scrollerWidth, containerBounds.right - scrollBounds.left)) : scrollerWidth;
      const yMax = this._layout.direction === 'vertical' ? scrollerHeight : Math.max(0, Math.min(scrollerHeight, containerBounds.bottom - scrollBounds.top));
      width = xMax - xMin;
      height = yMax - yMin;
      left = Math.max(0, -(containerBounds.left - scrollBounds.left));
      top = Math.max(0, -(containerBounds.top - scrollBounds.top));
    }

    this._layout.viewportSize = {
      width,
      height
    };
    this._layout.viewportScroll = {
      top,
      left
    };
  }
  /**
   * Styles the _sizer element or the container so that its size reflects the
   * total size of all items.
   */


  _sizeContainer(size) {
    if (this._scrollTarget === this._containerElement) {
      const left = size && size.width ? size.width - 1 : 0;
      const top = size && size.height ? size.height - 1 : 0;
      this._sizer.style.transform = `translate(${left}px, ${top}px)`;
    } else {
      const style = this._containerElement.style;
      style.minWidth = size && size.width ? size.width + 'px' : null;
      style.minHeight = size && size.height ? size.height + 'px' : null;
    }
  }
  /**
   * Sets the top and left transform style of the children from the values in
   * pos.
   */


  _positionChildren(pos) {
    const kids = this._kids;
    Object.keys(pos).forEach(key => {
      const idx = key - this._first;
      const child = kids[idx];

      if (child) {
        const {
          top,
          left
        } = pos[key];
        child.style.position = 'absolute';
        child.style.transform = `translate(${left}px, ${top}px)`;
      }
    });
  }

  _adjustRange(range) {
    this.num = range.num;
    this.first = range.first;
    const visiblityChanged = this._firstVisible !== range.firstVisible || this._lastVisible !== range.lastVisible;
    this._firstVisible = range.firstVisible;
    this._lastVisible = range.lastVisible;
    this._incremental = !range.stable;

    if (range.remeasure) {
      this.requestRemeasure();
    } else if (range.stable || visiblityChanged) {
      this._notifyRange();
    }
  }

  _shouldRender() {
    if (!super._shouldRender() || !this._containerElement || !this._layout && !this._lazyLoadDefaultLayout) {
      return false;
    } // NOTE: we're about to render, but the ResizeObserver didn't execute yet.
    // Since we want to keep rAF timing, we compute _containerSize now. Would
    // be nice to have a way to flush ResizeObservers.


    if (this._containerSize === null) {
      const {
        width,
        height
      } = this._containerElement.getBoundingClientRect();

      this._containerSize = {
        width,
        height
      };
    }

    return this._containerSize.width > 0 || this._containerSize.height > 0;
  }

  _correctScrollError(err) {
    if (this._scrollTarget) {
      this._scrollTarget.scrollTop -= err.top;
      this._scrollTarget.scrollLeft -= err.left;
    } else {
      window.scroll(window.scrollX - err.left, window.scrollY - err.top);
    }
  }
  /**
   * Emits a rangechange event with the current first, last, firstVisible, and
   * lastVisible.
   */


  _notifyRange() {
    const {
      first,
      num
    } = this;
    const last = first + num - 1;

    this._container.dispatchEvent(new RangeChangeEvent('rangechange', {
      first,
      last,
      firstVisible: this._firstVisible,
      lastVisible: this._lastVisible
    }));
  }
  /**
   * Render and update the view at the next opportunity with the given
   * container size.
   */


  _containerSizeChanged(size) {
    const {
      width,
      height
    } = size;
    this._containerSize = {
      width,
      height
    };

    this._scheduleUpdateView();
  }

  _childrenSizeChanged() {
    if (this._skipNextChildrenSizeChanged) {
      this._skipNextChildrenSizeChanged = false;
    } else {
      this.requestRemeasure();
    }
  }

}

/***/ }),

/***/ "./node_modules/lit-virtualizer/lib/uni-virtualizer/lib/layouts/Layout1d.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/lit-virtualizer/lib/uni-virtualizer/lib/layouts/Layout1d.js ***!
  \**********************************************************************************/
/*! exports provided: Layout1d */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Layout1d", function() { return Layout1d; });
/* harmony import */ var _Layout1dBase_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Layout1dBase.js */ "./node_modules/lit-virtualizer/lib/uni-virtualizer/lib/layouts/Layout1dBase.js");

class Layout1d extends _Layout1dBase_js__WEBPACK_IMPORTED_MODULE_0__["Layout1dBase"] {
  constructor(config) {
    super(config);
    /**
     * Indices of children mapped to their (position and length) in the scrolling
     * direction. Used to keep track of children that are in range.
     */

    this._physicalItems = new Map();
    /**
     * Used in tandem with _physicalItems to track children in range across
     * reflows.
     */

    this._newPhysicalItems = new Map();
    /**
     * Width and height of children by their index.
     */

    this._metrics = new Map();
    /**
     * anchorIdx is the anchor around which we reflow. It is designed to allow
     * jumping to any point of the scroll size. We choose it once and stick with
     * it until stable. _first and _last are deduced around it.
     */

    this._anchorIdx = null;
    /**
     * Position in the scrolling direction of the anchor child.
     */

    this._anchorPos = null;
    /**
     * Whether all children in range were in range during the previous reflow.
     */

    this._stable = true;
    /**
     * Whether to remeasure children during the next reflow.
     */

    this._needsRemeasure = false;
    /**
     * Number of children to lay out.
     */

    this._nMeasured = 0;
    /**
     * Total length in the scrolling direction of the laid out children.
     */

    this._tMeasured = 0;
    this._estimate = true;
  }
  /**
   * Determine the average size of all children represented in the sizes
   * argument.
   */


  updateItemSizes(sizes) {
    Object.keys(sizes).forEach(key => {
      const metrics = sizes[key],
            mi = this._getMetrics(Number(key)),
            prevSize = mi[this._sizeDim]; // TODO(valdrin) Handle margin collapsing.
      // https://developer.mozilla.org/en-US/docs/Web/CSS/CSS_Box_Model/Mastering_margin_collapsing


      mi.width = metrics.width + (metrics.marginLeft || 0) + (metrics.marginRight || 0);
      mi.height = metrics.height + (metrics.marginTop || 0) + (metrics.marginBottom || 0);
      const size = mi[this._sizeDim];

      const item = this._getPhysicalItem(Number(key));

      if (item) {
        let delta;

        if (size !== undefined) {
          item.size = size;

          if (prevSize === undefined) {
            delta = size;
            this._nMeasured++;
          } else {
            delta = size - prevSize;
          }
        }

        this._tMeasured = this._tMeasured + delta;
      }
    });

    if (!this._nMeasured) {
      console.warn(`No items measured yet.`);
    } else {
      this._updateItemSize();

      this._scheduleReflow();
    }
  }
  /**
   * Set the average item size based on the total length and number of children
   * in range.
   */


  _updateItemSize() {
    // Keep integer values.
    this._itemSize[this._sizeDim] = Math.round(this._tMeasured / this._nMeasured);
  }

  _getMetrics(idx) {
    return this._metrics[idx] = this._metrics[idx] || {};
  }

  _getPhysicalItem(idx) {
    return this._newPhysicalItems.get(idx) || this._physicalItems.get(idx);
  }

  _getSize(idx) {
    const item = this._getPhysicalItem(idx);

    return item && item.size;
  }
  /**
   * Returns the position in the scrolling direction of the item at idx.
   * Estimates it if the item at idx is not in the DOM.
   */


  _getPosition(idx) {
    const item = this._physicalItems.get(idx);

    return item ? item.pos : idx * this._delta + this._spacing;
  }

  _calculateAnchor(lower, upper) {
    if (lower === 0) {
      return 0;
    }

    if (upper > this._scrollSize - this._viewDim1) {
      return this._totalItems - 1;
    }

    return Math.max(0, Math.min(this._totalItems - 1, Math.floor((lower + upper) / 2 / this._delta)));
  }

  _getAnchor(lower, upper) {
    if (this._physicalItems.size === 0) {
      return this._calculateAnchor(lower, upper);
    }

    if (this._first < 0) {
      console.error('_getAnchor: negative _first');
      return this._calculateAnchor(lower, upper);
    }

    if (this._last < 0) {
      console.error('_getAnchor: negative _last');
      return this._calculateAnchor(lower, upper);
    }

    const firstItem = this._getPhysicalItem(this._first),
          lastItem = this._getPhysicalItem(this._last),
          firstMin = firstItem.pos,
          firstMax = firstMin + firstItem.size,
          lastMin = lastItem.pos,
          lastMax = lastMin + lastItem.size;

    if (lastMax < lower) {
      // Window is entirely past physical items, calculate new anchor
      return this._calculateAnchor(lower, upper);
    }

    if (firstMin > upper) {
      // Window is entirely before physical items, calculate new anchor
      return this._calculateAnchor(lower, upper);
    }

    if (firstMin >= lower || firstMax >= lower) {
      // First physical item overlaps window, choose it
      return this._first;
    }

    if (lastMax <= upper || lastMin <= upper) {
      // Last physical overlaps window, choose it
      return this._last;
    } // Window contains a physical item, but not the first or last


    let maxIdx = this._last,
        minIdx = this._first;

    while (true) {
      const candidateIdx = Math.round((maxIdx + minIdx) / 2),
            candidate = this._physicalItems.get(candidateIdx),
            cMin = candidate.pos,
            cMax = cMin + candidate.size;

      if (cMin >= lower && cMin <= upper || cMax >= lower && cMax <= upper) {
        return candidateIdx;
      } else if (cMax < lower) {
        minIdx = candidateIdx + 1;
      } else if (cMin > upper) {
        maxIdx = candidateIdx - 1;
      }
    }
  }
  /**
   * Updates _first and _last based on items that should be in the current
   * viewed range.
   */


  _getActiveItems() {
    if (this._viewDim1 === 0 || this._totalItems === 0) {
      this._clearItems();
    } else {
      const upper = Math.min(this._scrollSize, this._scrollPosition + this._viewDim1 + this._overhang),
            lower = Math.max(0, upper - this._viewDim1 - 2 * this._overhang);

      this._getItems(lower, upper);
    }
  }
  /**
   * Sets the range to empty.
   */


  _clearItems() {
    this._first = -1;
    this._last = -1;
    this._physicalMin = 0;
    this._physicalMax = 0;
    const items = this._newPhysicalItems;
    this._newPhysicalItems = this._physicalItems;

    this._newPhysicalItems.clear();

    this._physicalItems = items;
    this._stable = true;
  }
  /*
   * Updates _first and _last based on items that should be in the given range.
   */


  _getItems(lower, upper) {
    const items = this._newPhysicalItems; // The anchorIdx is the anchor around which we reflow. It is designed to
    // allow jumping to any point of the scroll size. We choose it once and
    // stick with it until stable. first and last are deduced around it.

    if (this._anchorIdx === null || this._anchorPos === null) {
      this._anchorIdx = this._getAnchor(lower, upper);
      this._anchorPos = this._getPosition(this._anchorIdx);
    }

    let anchorSize = this._getSize(this._anchorIdx);

    if (anchorSize === undefined) {
      anchorSize = this._itemDim1;
    } // Anchor might be outside bounds, so prefer correcting the error and keep
    // that anchorIdx.


    let anchorErr = 0;

    if (this._anchorPos + anchorSize + this._spacing < lower) {
      anchorErr = lower - (this._anchorPos + anchorSize + this._spacing);
    }

    if (this._anchorPos > upper) {
      anchorErr = upper - this._anchorPos;
    }

    if (anchorErr) {
      this._scrollPosition -= anchorErr;
      lower -= anchorErr;
      upper -= anchorErr;
      this._scrollError += anchorErr;
    } // TODO @straversi: If size is always itemDim1, then why keep track of it?


    items.set(this._anchorIdx, {
      pos: this._anchorPos,
      size: anchorSize
    });
    this._first = this._last = this._anchorIdx;
    this._physicalMin = this._physicalMax = this._anchorPos;
    this._stable = true;

    while (this._physicalMin > lower && this._first > 0) {
      let size = this._getSize(--this._first);

      if (size === undefined) {
        this._stable = false;
        size = this._itemDim1;
      }

      const pos = this._physicalMin -= size + this._spacing;
      items.set(this._first, {
        pos,
        size
      });

      if (this._stable === false && this._estimate === false) {
        break;
      }
    }

    while (this._physicalMax < upper && this._last < this._totalItems) {
      let size = this._getSize(this._last);

      if (size === undefined) {
        this._stable = false;
        size = this._itemDim1;
      }

      items.set(this._last++, {
        pos: this._physicalMax,
        size
      });

      if (this._stable === false && this._estimate === false) {
        break;
      } else {
        this._physicalMax += size + this._spacing;
      }
    }

    this._last--; // This handles the cases where we were relying on estimated sizes.

    const extentErr = this._calculateError();

    if (extentErr) {
      this._physicalMin -= extentErr;
      this._physicalMax -= extentErr;
      this._anchorPos -= extentErr;
      this._scrollPosition -= extentErr;
      items.forEach(item => item.pos -= extentErr);
      this._scrollError += extentErr;
    }

    if (this._stable) {
      this._newPhysicalItems = this._physicalItems;

      this._newPhysicalItems.clear();

      this._physicalItems = items;
    }
  }

  _calculateError() {
    if (this._first === 0) {
      return this._physicalMin;
    } else if (this._physicalMin <= 0) {
      return this._physicalMin - this._first * this._delta;
    } else if (this._last === this._totalItems - 1) {
      return this._physicalMax - this._scrollSize;
    } else if (this._physicalMax >= this._scrollSize) {
      return this._physicalMax - this._scrollSize + (this._totalItems - 1 - this._last) * this._delta;
    }

    return 0;
  }

  _updateScrollSize() {
    // Reuse previously calculated physical max, as it might be higher than the
    // estimated size.
    super._updateScrollSize();

    this._scrollSize = Math.max(this._physicalMax, this._scrollSize);
  } // TODO: Can this be made to inherit from base, with proper hooks?


  _reflow() {
    const {
      _first,
      _last,
      _scrollSize
    } = this;

    this._updateScrollSize();

    this._getActiveItems();

    this._scrollIfNeeded();

    if (this._scrollSize !== _scrollSize) {
      this._emitScrollSize();
    }

    this._updateVisibleIndices();

    this._emitRange();

    if (this._first === -1 && this._last === -1) {
      this._resetReflowState();
    } else if (this._first !== _first || this._last !== _last || this._needsRemeasure) {
      this._emitChildPositions();

      this._emitScrollError();
    } else {
      this._emitChildPositions();

      this._emitScrollError();

      this._resetReflowState();
    }
  }

  _resetReflowState() {
    this._anchorIdx = null;
    this._anchorPos = null;
    this._stable = true;
  }
  /**
   * Returns the top and left positioning of the item at idx.
   */


  _getItemPosition(idx) {
    return {
      [this._positionDim]: this._getPosition(idx),
      [this._secondaryPositionDim]: 0
    };
  }
  /**
   * Returns the height and width of the item at idx.
   */


  _getItemSize(idx) {
    return {
      [this._sizeDim]: this._getSize(idx) || this._itemDim1,
      [this._secondarySizeDim]: this._itemDim2
    };
  }

  _viewDim2Changed() {
    this._needsRemeasure = true;

    this._scheduleReflow();
  }

  _emitRange() {
    const remeasure = this._needsRemeasure;
    const stable = this._stable;
    this._needsRemeasure = false;

    super._emitRange({
      remeasure,
      stable
    });
  }

}

/***/ }),

/***/ "./node_modules/lit-virtualizer/lib/uni-virtualizer/lib/layouts/Layout1dBase.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/lit-virtualizer/lib/uni-virtualizer/lib/layouts/Layout1dBase.js ***!
  \**************************************************************************************/
/*! exports provided: Layout1dBase */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Layout1dBase", function() { return Layout1dBase; });
/* harmony import */ var _polyfillLoaders_EventTarget_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../polyfillLoaders/EventTarget.js */ "./node_modules/lit-virtualizer/lib/uni-virtualizer/lib/polyfillLoaders/EventTarget.js");

class Layout1dBase {
  constructor(config) {
    /**
     * The last set viewport scroll position.
     */
    this._latestCoords = {
      left: 0,
      top: 0
    };
    /**
     * Scrolling direction.
     */

    this._direction = 'vertical';
    /**
     * Dimensions of the viewport.
     */

    this._viewportSize = {
      width: 0,
      height: 0
    };
    /**
     * Flag for debouncing asynchnronous reflow requests.
     */

    this._pendingReflow = false;
    /**
     * Index of the item that has been scrolled to via the public API. When the
     * container is otherwise scrolled, this value is set back to -1.
     */

    this._scrollToIndex = -1;
    /**
     * When a child is scrolled to, the offset from the top of the child and the
     * top of the viewport. Value is a proportion of the item size.
     */

    this._scrollToAnchor = 0;
    this._eventTargetPromise = Object(_polyfillLoaders_EventTarget_js__WEBPACK_IMPORTED_MODULE_0__["default"])().then(Ctor => this._eventTarget = new Ctor());
    /**
     * Pixel offset in the scroll direction of the first child.
     */

    this._physicalMin = 0;
    /**
     * Pixel offset in the scroll direction of the last child.
     */

    this._physicalMax = 0;
    /**
     * Index of the first child.
     */

    this._first = -1;
    /**
     * Index of the last child.
     */

    this._last = -1;
    /**
     * The _estimated_ size of a child.
     */

    this._itemSize = {
      width: 100,
      height: 100
    };
    /**
     * Space in pixels between children.
     */

    this._spacing = 0;
    /**
     * Length in the scrolling direction.
     */

    this._sizeDim = 'height';
    /**
     * Length in the non-scrolling direction.
     */

    this._secondarySizeDim = 'width';
    /**
     * Position in the scrolling direction.
     */

    this._positionDim = 'top';
    /**
     * Position in the non-scrolling direction.
     */

    this._secondaryPositionDim = 'left';
    /**
     * Current scroll offset in pixels.
     */

    this._scrollPosition = 0;
    /**
     * Difference between current scroll offset and scroll offset calculated due
     * to a reflow.
     */

    this._scrollError = 0;
    /**
     * Total number of items that could possibly be displayed. Used to help
     * calculate the scroll size.
     */

    this._totalItems = 0;
    /**
     * The total (estimated) length of all items in the scrolling direction.
     */

    this._scrollSize = 1;
    /**
     * Number of pixels beyond the visible size of the container to still include
     * in the active range of items.
     */

    this._overhang = 150;
    Object.assign(this, config);
  }
  /**
   * Maximum index of children + 1, to help estimate total height of the scroll
   * space.
   */


  get totalItems() {
    return this._totalItems;
  }

  set totalItems(num) {
    if (num !== this._totalItems) {
      this._totalItems = num;

      this._scheduleReflow();
    }
  }
  /**
   * Primary scrolling direction.
   */


  get direction() {
    return this._direction;
  }

  set direction(dir) {
    // Force it to be either horizontal or vertical.
    dir = dir === 'horizontal' ? dir : 'vertical';

    if (dir !== this._direction) {
      this._direction = dir;
      this._sizeDim = dir === 'horizontal' ? 'width' : 'height';
      this._secondarySizeDim = dir === 'horizontal' ? 'height' : 'width';
      this._positionDim = dir === 'horizontal' ? 'left' : 'top';
      this._secondaryPositionDim = dir === 'horizontal' ? 'top' : 'left';

      this._scheduleReflow();
    }
  }
  /**
   * Estimate of the dimensions of a single child.
   */


  get itemSize() {
    return this._itemSize;
  }

  set itemSize(dims) {
    const {
      _itemDim1,
      _itemDim2
    } = this;
    Object.assign(this._itemSize, dims);

    if (_itemDim1 !== this._itemDim1 || _itemDim2 !== this._itemDim2) {
      if (_itemDim2 !== this._itemDim2) {
        this._itemDim2Changed();
      } else {
        this._scheduleReflow();
      }
    }
  }
  /**
   * Amount of space in between items.
   */


  get spacing() {
    return this._spacing;
  }

  set spacing(px) {
    if (px !== this._spacing) {
      this._spacing = px;

      this._scheduleReflow();
    }
  }
  /**
   * Height and width of the viewport.
   */


  get viewportSize() {
    return this._viewportSize;
  }

  set viewportSize(dims) {
    const {
      _viewDim1,
      _viewDim2
    } = this;
    Object.assign(this._viewportSize, dims);

    if (_viewDim2 !== this._viewDim2) {
      this._viewDim2Changed();
    } else if (_viewDim1 !== this._viewDim1) {
      this._checkThresholds();
    }
  }
  /**
   * Scroll offset of the viewport.
   */


  get viewportScroll() {
    return this._latestCoords;
  }

  set viewportScroll(coords) {
    Object.assign(this._latestCoords, coords);
    const oldPos = this._scrollPosition;
    this._scrollPosition = this._latestCoords[this._positionDim];

    if (oldPos !== this._scrollPosition) {
      this._scrollPositionChanged(oldPos, this._scrollPosition);

      this._updateVisibleIndices();
    }

    this._checkThresholds();
  }
  /**
   * Perform a reflow if one has been scheduled.
   */


  reflowIfNeeded() {
    if (this._pendingReflow) {
      this._pendingReflow = false;

      this._reflow();
    }
  }
  /**
   * Scroll to the child at the given index, and the given position within that
   * child.
   */


  scrollToIndex(index, position = 'start') {
    if (!Number.isFinite(index)) return;
    index = Math.min(this.totalItems, Math.max(0, index));
    this._scrollToIndex = index;

    if (position === 'nearest') {
      position = index > this._first + this._num / 2 ? 'end' : 'start';
    }

    switch (position) {
      case 'start':
        this._scrollToAnchor = 0;
        break;

      case 'center':
        this._scrollToAnchor = 0.5;
        break;

      case 'end':
        this._scrollToAnchor = 1;
        break;

      default:
        throw new TypeError('position must be one of: start, center, end, nearest');
    }

    this._scheduleReflow();

    this.reflowIfNeeded();
  }

  async dispatchEvent(...args) {
    await this._eventTargetPromise;

    this._eventTarget.dispatchEvent(...args);
  }

  async addEventListener(...args) {
    await this._eventTargetPromise;

    this._eventTarget.addEventListener(...args);
  }

  async removeEventListener(...args) {
    await this._eventTargetPromise;

    this._eventTarget.removeEventListener(...args);
  }

  updateItemSizes(_sizes) {// Override
  }

  _itemDim2Changed() {// Override
  }

  _viewDim2Changed() {// Override
  }

  _getItemSize(_idx) {
    return {
      [this._sizeDim]: this._itemDim1,
      [this._secondarySizeDim]: this._itemDim2
    };
  }
  /**
   * The size of an item in the scrolling direction + space between items.
   */


  get _delta() {
    return this._itemDim1 + this._spacing;
  }
  /**
   * The height or width of an item, whichever corresponds to the scrolling direction.
   */


  get _itemDim1() {
    return this._itemSize[this._sizeDim];
  }
  /**
   * The height or width of an item, whichever does NOT correspond to the scrolling direction.
   */


  get _itemDim2() {
    return this._itemSize[this._secondarySizeDim];
  }
  /**
   * The height or width of the viewport, whichever corresponds to the scrolling direction.
   */


  get _viewDim1() {
    return this._viewportSize[this._sizeDim];
  }
  /**
   * The height or width of the viewport, whichever does NOT correspond to the scrolling direction.
   */


  get _viewDim2() {
    return this._viewportSize[this._secondarySizeDim];
  }

  _scheduleReflow() {
    this._pendingReflow = true;
  }

  _reflow() {
    const {
      _first,
      _last,
      _scrollSize
    } = this;

    this._updateScrollSize();

    this._getActiveItems();

    this._scrollIfNeeded();

    if (this._scrollSize !== _scrollSize) {
      this._emitScrollSize();
    }

    if (this._first === -1 && this._last === -1) {
      // TODO: have default empty object for emitRange instead
      this._emitRange();
    } else if (this._first !== _first || this._last !== _last || this._spacingChanged) {
      // TODO: have default empty object for emitRange instead
      this._emitRange();

      this._emitChildPositions();
    }

    this._emitScrollError();
  }
  /**
   * Estimates the total length of all items in the scrolling direction, including spacing.
   */


  _updateScrollSize() {
    // Ensure we have at least 1px - this allows getting at least 1 item to be
    // rendered.
    this._scrollSize = Math.max(1, this._totalItems * this._delta);
  }

  _scrollIfNeeded() {
    if (this._scrollToIndex === -1) {
      return;
    }

    const index = this._scrollToIndex;
    const anchor = this._scrollToAnchor;

    const pos = this._getItemPosition(index)[this._positionDim];

    const size = this._getItemSize(index)[this._sizeDim];

    const curAnchorPos = this._scrollPosition + this._viewDim1 * anchor;
    const newAnchorPos = pos + size * anchor; // Ensure scroll position is an integer within scroll bounds.

    const scrollPosition = Math.floor(Math.min(this._scrollSize - this._viewDim1, Math.max(0, this._scrollPosition - curAnchorPos + newAnchorPos)));
    this._scrollError += this._scrollPosition - scrollPosition;
    this._scrollPosition = scrollPosition;
  }

  _emitRange(inProps = undefined) {
    const detail = Object.assign({
      first: this._first,
      last: this._last,
      num: this._num,
      stable: true,
      firstVisible: this._firstVisible,
      lastVisible: this._lastVisible
    }, inProps);
    this.dispatchEvent(new CustomEvent('rangechange', {
      detail
    }));
  }

  _emitScrollSize() {
    const detail = {
      [this._sizeDim]: this._scrollSize
    };
    this.dispatchEvent(new CustomEvent('scrollsizechange', {
      detail
    }));
  }

  _emitScrollError() {
    if (this._scrollError) {
      const detail = {
        [this._positionDim]: this._scrollError,
        [this._secondaryPositionDim]: 0
      };
      this.dispatchEvent(new CustomEvent('scrollerrorchange', {
        detail
      }));
      this._scrollError = 0;
    }
  }
  /**
   * Get or estimate the top and left positions of items in the current range.
   * Emit an itempositionchange event with these positions.
   */


  _emitChildPositions() {
    const detail = {};

    for (let idx = this._first; idx <= this._last; idx++) {
      detail[idx] = this._getItemPosition(idx);
    }

    this.dispatchEvent(new CustomEvent('itempositionchange', {
      detail
    }));
  }
  /**
   * Number of items to display.
   */


  get _num() {
    if (this._first === -1 || this._last === -1) {
      return 0;
    }

    return this._last - this._first + 1;
  }

  _checkThresholds() {
    if (this._viewDim1 === 0 && this._num > 0) {
      this._scheduleReflow();
    } else {
      const min = Math.max(0, this._scrollPosition - this._overhang);
      const max = Math.min(this._scrollSize, this._scrollPosition + this._viewDim1 + this._overhang);

      if (this._physicalMin > min || this._physicalMax < max) {
        this._scheduleReflow();
      }
    }
  }
  /**
   * Find the indices of the first and last items to intersect the viewport.
   * Emit a visibleindiceschange event when either index changes.
   */


  _updateVisibleIndices() {
    let firstVisible = this._firstVisible;
    let lastVisible = this._lastVisible;

    for (let i = this._first; i <= this._last; i++) {
      const itemY = this._getItemPosition(i)[this._positionDim];

      if (itemY <= this._scrollPosition) {
        firstVisible = i;
      }

      if (itemY < this._scrollPosition + this._viewDim1) {
        lastVisible = i;
      }
    } // If scrolling is occurring very quickly, item positions may change
    // during this calculation. Ignore the results when that happens.


    if (firstVisible > lastVisible) {
      return;
    }

    if (firstVisible !== this._firstVisible || lastVisible !== this._lastVisible) {
      this._firstVisible = firstVisible;
      this._lastVisible = lastVisible;

      this._emitRange();
    }
  }

  _scrollPositionChanged(oldPos, newPos) {
    // When both values are bigger than the max scroll position, keep the
    // current _scrollToIndex, otherwise invalidate it.
    const maxPos = this._scrollSize - this._viewDim1;

    if (oldPos < maxPos || newPos < maxPos) {
      this._scrollToIndex = -1;
    }
  }

}

/***/ }),

/***/ "./node_modules/lit-virtualizer/lib/uni-virtualizer/lib/layouts/Layout1dGrid.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/lit-virtualizer/lib/uni-virtualizer/lib/layouts/Layout1dGrid.js ***!
  \**************************************************************************************/
/*! exports provided: Layout1dGrid */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Layout1dGrid", function() { return Layout1dGrid; });
/* harmony import */ var _Layout1dBase_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Layout1dBase.js */ "./node_modules/lit-virtualizer/lib/uni-virtualizer/lib/layouts/Layout1dBase.js");

/**
 * TODO @straversi: document and test this Layout.
 */

class Layout1dGrid extends _Layout1dBase_js__WEBPACK_IMPORTED_MODULE_0__["Layout1dBase"] {
  constructor(config) {
    super(config);
    this._rolumns = 1;
  }

  updateItemSizes(sizes) {
    // Assume all items have the same size.
    const size = Object.values(sizes)[0];

    if (size) {
      this.itemSize = size;
    }
  }

  _viewDim2Changed() {
    this._defineGrid();
  }

  _itemDim2Changed() {
    this._defineGrid();
  }

  _getActiveItems() {
    const min = Math.max(0, this._scrollPosition - this._overhang);
    const max = Math.min(this._scrollSize, this._scrollPosition + this._viewDim1 + this._overhang);
    const firstCow = Math.floor(min / this._delta);
    const lastCow = Math.ceil(max / this._delta) - 1;
    this._first = firstCow * this._rolumns;
    this._last = Math.min((lastCow + 1) * this._rolumns - 1, this._totalItems);
    this._physicalMin = this._delta * firstCow;
    this._physicalMax = this._delta * (lastCow + 1);
  }

  _getItemPosition(idx) {
    return {
      [this._positionDim]: Math.floor(idx / this._rolumns) * this._delta,
      [this._secondaryPositionDim]: this._spacing + idx % this._rolumns * (this._spacing + this._itemDim2)
    };
  }

  _defineGrid() {
    const {
      _spacing
    } = this;
    this._rolumns = Math.max(1, Math.floor(this._viewDim2 / this._itemDim2));

    if (this._rolumns > 1) {
      this._spacing = this._viewDim2 % (this._rolumns * this._itemDim2) / (this._rolumns + 1);
    } else {
      this._spacing = 0;
    }

    this._spacingChanged = !(_spacing === this._spacing);

    this._scheduleReflow();
  }

  _updateScrollSize() {
    this._scrollSize = Math.max(1, Math.ceil(this._totalItems / this._rolumns) * this._delta);
  }

}

/***/ }),

/***/ "./node_modules/lit-virtualizer/lib/uni-virtualizer/lib/polyfillLoaders/EventTarget.js":
/*!*********************************************************************************************!*\
  !*** ./node_modules/lit-virtualizer/lib/uni-virtualizer/lib/polyfillLoaders/EventTarget.js ***!
  \*********************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return EventTarget; });
let ET;
async function EventTarget() {
  return ET || init();
}

async function init() {
  ET = window.EventTarget;

  try {
    new ET();
  } catch (_a) {
    ET = (await __webpack_require__.e(/*! import() */ 70).then(__webpack_require__.t.bind(null, /*! event-target-shim */ "./node_modules/event-target-shim/dist/event-target-shim.js", 7))).EventTarget;
  }

  return ET;
}

/***/ }),

/***/ "./node_modules/lit-virtualizer/lib/uni-virtualizer/lib/polyfillLoaders/ResizeObserver.js":
/*!************************************************************************************************!*\
  !*** ./node_modules/lit-virtualizer/lib/uni-virtualizer/lib/polyfillLoaders/ResizeObserver.js ***!
  \************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return ResizeObserver; });
let RO;
async function ResizeObserver() {
  return RO || init();
}

async function init() {
  RO = window.ResizeObserver;

  try {
    new RO(function () {});
  } catch (e) {
    RO = (await __webpack_require__.e(/*! import() */ 60).then(__webpack_require__.bind(null, /*! resize-observer-polyfill */ "./node_modules/resize-observer-polyfill/dist/ResizeObserver.es.js"))).default;
  }

  return RO;
}

/***/ }),

/***/ "./node_modules/lit-virtualizer/lib/uni-virtualizer/uni-virtualizer.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/lit-virtualizer/lib/uni-virtualizer/uni-virtualizer.js ***!
  \*****************************************************************************/
/*! exports provided: VirtualRepeater, VirtualScroller, RangeChangeEvent, Layout1d, Layout1dGrid */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _lib_VirtualRepeater_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./lib/VirtualRepeater.js */ "./node_modules/lit-virtualizer/lib/uni-virtualizer/lib/VirtualRepeater.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "VirtualRepeater", function() { return _lib_VirtualRepeater_js__WEBPACK_IMPORTED_MODULE_0__["VirtualRepeater"]; });

/* harmony import */ var _lib_VirtualScroller_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./lib/VirtualScroller.js */ "./node_modules/lit-virtualizer/lib/uni-virtualizer/lib/VirtualScroller.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "VirtualScroller", function() { return _lib_VirtualScroller_js__WEBPACK_IMPORTED_MODULE_1__["VirtualScroller"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "RangeChangeEvent", function() { return _lib_VirtualScroller_js__WEBPACK_IMPORTED_MODULE_1__["RangeChangeEvent"]; });

/* harmony import */ var _lib_layouts_Layout1d_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./lib/layouts/Layout1d.js */ "./node_modules/lit-virtualizer/lib/uni-virtualizer/lib/layouts/Layout1d.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Layout1d", function() { return _lib_layouts_Layout1d_js__WEBPACK_IMPORTED_MODULE_2__["Layout1d"]; });

/* harmony import */ var _lib_layouts_Layout1dGrid_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./lib/layouts/Layout1dGrid.js */ "./node_modules/lit-virtualizer/lib/uni-virtualizer/lib/layouts/Layout1dGrid.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Layout1dGrid", function() { return _lib_layouts_Layout1dGrid_js__WEBPACK_IMPORTED_MODULE_3__["Layout1dGrid"]; });






/***/ }),

/***/ "./node_modules/lit-virtualizer/lit-virtualizer.js":
/*!*********************************************************!*\
  !*** ./node_modules/lit-virtualizer/lit-virtualizer.js ***!
  \*********************************************************/
/*! exports provided: repeat, scroll, Layout1d, Layout1dGrid, RangeChangeEvent, LitVirtualizer */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _lib_repeat_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./lib/repeat.js */ "./node_modules/lit-virtualizer/lib/repeat.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "repeat", function() { return _lib_repeat_js__WEBPACK_IMPORTED_MODULE_0__["repeat"]; });

/* harmony import */ var _lib_scroll_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./lib/scroll.js */ "./node_modules/lit-virtualizer/lib/scroll.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "scroll", function() { return _lib_scroll_js__WEBPACK_IMPORTED_MODULE_1__["scroll"]; });

/* harmony import */ var _lib_uni_virtualizer_uni_virtualizer_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./lib/uni-virtualizer/uni-virtualizer.js */ "./node_modules/lit-virtualizer/lib/uni-virtualizer/uni-virtualizer.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Layout1d", function() { return _lib_uni_virtualizer_uni_virtualizer_js__WEBPACK_IMPORTED_MODULE_2__["Layout1d"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Layout1dGrid", function() { return _lib_uni_virtualizer_uni_virtualizer_js__WEBPACK_IMPORTED_MODULE_2__["Layout1dGrid"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "RangeChangeEvent", function() { return _lib_uni_virtualizer_uni_virtualizer_js__WEBPACK_IMPORTED_MODULE_2__["RangeChangeEvent"]; });

/* harmony import */ var _lib_lit_virtualizer_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./lib/lit-virtualizer.js */ "./node_modules/lit-virtualizer/lib/lit-virtualizer.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "LitVirtualizer", function() { return _lib_lit_virtualizer_js__WEBPACK_IMPORTED_MODULE_3__["LitVirtualizer"]; });






/***/ })

}]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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