(self["webpackJsonp"] = self["webpackJsonp"] || []).push([["panel-lovelace"],{

/***/ "./node_modules/@polymer/app-layout/app-scroll-effects/effects/waterfall.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/@polymer/app-layout/app-scroll-effects/effects/waterfall.js ***!
  \**********************************************************************************/
/*! no exports provided */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _app_scroll_effects_behavior_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../app-scroll-effects-behavior.js */ "./node_modules/@polymer/app-layout/app-scroll-effects/app-scroll-effects-behavior.js");
/* harmony import */ var _helpers_helpers_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../helpers/helpers.js */ "./node_modules/@polymer/app-layout/helpers/helpers.js");
/**
@license
Copyright (c) 2016 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at
http://polymer.github.io/LICENSE.txt The complete set of authors may be found at
http://polymer.github.io/AUTHORS.txt The complete set of contributors may be
found at http://polymer.github.io/CONTRIBUTORS.txt Code distributed by Google as
part of the polymer project is also subject to an additional IP rights grant
found at http://polymer.github.io/PATENTS.txt
*/


/**
 * Toggles the shadow property in app-header when content is scrolled to create
 * a sense of depth between the element and the content underneath.
 */

Object(_helpers_helpers_js__WEBPACK_IMPORTED_MODULE_1__["registerEffect"])('waterfall', {
  /**
   *  @this Polymer.AppLayout.ElementWithBackground
   */
  run: function run() {
    this.shadow = this.isOnScreen() && this.isContentBelow();
  }
});

/***/ }),

/***/ "./node_modules/lit-html/directives/if-defined.js":
/*!********************************************************!*\
  !*** ./node_modules/lit-html/directives/if-defined.js ***!
  \********************************************************/
/*! exports provided: ifDefined */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ifDefined", function() { return ifDefined; });
/* harmony import */ var _lit_html_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../lit-html.js */ "./node_modules/lit-html/lit-html.js");
/**
 * @license
 * Copyright (c) 2018 The Polymer Project Authors. All rights reserved.
 * This code may only be used under the BSD style license found at
 * http://polymer.github.io/LICENSE.txt
 * The complete set of authors may be found at
 * http://polymer.github.io/AUTHORS.txt
 * The complete set of contributors may be found at
 * http://polymer.github.io/CONTRIBUTORS.txt
 * Code distributed by Google as part of the polymer project is also
 * subject to an additional IP rights grant found at
 * http://polymer.github.io/PATENTS.txt
 */

/**
 * For AttributeParts, sets the attribute if the value is defined and removes
 * the attribute if the value is undefined.
 *
 * For other part types, this directive is a no-op.
 */

const ifDefined = Object(_lit_html_js__WEBPACK_IMPORTED_MODULE_0__["directive"])(value => part => {
  if (value === undefined && part instanceof _lit_html_js__WEBPACK_IMPORTED_MODULE_0__["AttributePart"]) {
    if (value !== part.value) {
      const name = part.committer.name;
      part.committer.element.removeAttribute(name);
    }
  } else {
    part.setValue(value);
  }
});

/***/ }),

/***/ "./src/common/config/is_component_loaded.ts":
/*!**************************************************!*\
  !*** ./src/common/config/is_component_loaded.ts ***!
  \**************************************************/
/*! exports provided: isComponentLoaded */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isComponentLoaded", function() { return isComponentLoaded; });
/** Return if a component is loaded. */
const isComponentLoaded = (hass, component) => hass && hass.config.components.indexOf(component) !== -1;

/***/ }),

/***/ "./src/common/dom/load_resource.ts":
/*!*****************************************!*\
  !*** ./src/common/dom/load_resource.ts ***!
  \*****************************************/
/*! exports provided: loadCSS, loadJS, loadImg, loadModule */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "loadCSS", function() { return loadCSS; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "loadJS", function() { return loadJS; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "loadImg", function() { return loadImg; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "loadModule", function() { return loadModule; });
// Load a resource and get a promise when loading done.
// From: https://davidwalsh.name/javascript-loader
const _load = (tag, url, type) => {
  // This promise will be used by Promise.all to determine success or failure
  return new Promise((resolve, reject) => {
    const element = document.createElement(tag);
    let attr = "src";
    let parent = "body"; // Important success and error for the promise

    element.onload = () => resolve(url);

    element.onerror = () => reject(url); // Need to set different attributes depending on tag type


    switch (tag) {
      case "script":
        element.async = true;

        if (type) {
          element.type = type;
        }

        break;

      case "link":
        element.type = "text/css";
        element.rel = "stylesheet";
        attr = "href";
        parent = "head";
    } // Inject into document to kick off loading


    element[attr] = url;
    document[parent].appendChild(element);
  });
};

const loadCSS = url => _load("link", url);
const loadJS = url => _load("script", url);
const loadImg = url => _load("img", url);
const loadModule = url => _load("script", url, "module");

/***/ }),

/***/ "./src/common/dom/scroll-to-target.ts":
/*!********************************************!*\
  !*** ./src/common/dom/scroll-to-target.ts ***!
  \********************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return scrollToTarget; });
/**
 * Scroll to a specific y coordinate.
 *
 * Copied from paper-scroll-header-panel.
 *
 * @method scroll
 * @param {number} top The coordinate to scroll to, along the y-axis.
 * @param {boolean} smooth true if the scroll position should be smoothly adjusted.
 */
function scrollToTarget(element, target) {
  // the scroll event will trigger _updateScrollState directly,
  // However, _updateScrollState relies on the previous `scrollTop` to update the states.
  // Calling _updateScrollState will ensure that the states are synced correctly.
  const top = 0;
  const scroller = target;

  const easingFn = function easeOutQuad(t, b, c, d) {
    /* eslint-disable no-param-reassign, space-infix-ops, no-mixed-operators */
    t /= d;
    return -c * t * (t - 2) + b;
    /* eslint-enable no-param-reassign, space-infix-ops, no-mixed-operators */
  };

  const animationId = Math.random();
  const duration = 200;
  const startTime = Date.now();
  const currentScrollTop = scroller.scrollTop;
  const deltaScrollTop = top - currentScrollTop;
  element._currentAnimationId = animationId;
  (function updateFrame() {
    const now = Date.now();
    const elapsedTime = now - startTime;

    if (elapsedTime > duration) {
      scroller.scrollTop = top;
    } else if (element._currentAnimationId === animationId) {
      scroller.scrollTop = easingFn(elapsedTime, currentScrollTop, deltaScrollTop, duration);
      requestAnimationFrame(updateFrame.bind(element));
    }
  }).call(element);
}

/***/ }),

/***/ "./src/common/string/compare.ts":
/*!**************************************!*\
  !*** ./src/common/string/compare.ts ***!
  \**************************************/
/*! exports provided: compare, caseInsensitiveCompare */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "compare", function() { return compare; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "caseInsensitiveCompare", function() { return caseInsensitiveCompare; });
const compare = (a, b) => {
  if (a < b) {
    return -1;
  }

  if (a > b) {
    return 1;
  }

  return 0;
};
const caseInsensitiveCompare = (a, b) => compare(a.toLowerCase(), b.toLowerCase());

/***/ }),

/***/ "./src/components/ha-icon.ts":
/*!***********************************!*\
  !*** ./src/components/ha-icon.ts ***!
  \***********************************/
/*! exports provided: HaIcon */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HaIcon", function() { return HaIcon; });
/* harmony import */ var _polymer_iron_icon_iron_icon__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @polymer/iron-icon/iron-icon */ "./node_modules/@polymer/iron-icon/iron-icon.js");
function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }


const ironIconClass = customElements.get("iron-icon");
let loaded = false;
class HaIcon extends ironIconClass {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "_iconsetName", void 0);
  }

  listen(node, eventName, methodName) {
    super.listen(node, eventName, methodName);

    if (!loaded && this._iconsetName === "mdi") {
      loaded = true;
      __webpack_require__.e(/*! import() | mdi-icons */ "mdi-icons").then(__webpack_require__.bind(null, /*! ../resources/mdi-icons */ "./src/resources/mdi-icons.js"));
    }
  }

}
customElements.define("ha-icon", HaIcon);

/***/ }),

/***/ "./src/components/ha-paper-icon-button-arrow-next.ts":
/*!***********************************************************!*\
  !*** ./src/components/ha-paper-icon-button-arrow-next.ts ***!
  \***********************************************************/
/*! exports provided: HaPaperIconButtonArrowNext */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HaPaperIconButtonArrowNext", function() { return HaPaperIconButtonArrowNext; });
/* harmony import */ var _polymer_paper_icon_button_paper_icon_button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @polymer/paper-icon-button/paper-icon-button */ "./node_modules/@polymer/paper-icon-button/paper-icon-button.js");

const paperIconButtonClass = customElements.get("paper-icon-button");
class HaPaperIconButtonArrowNext extends paperIconButtonClass {
  connectedCallback() {
    super.connectedCallback(); // wait to check for direction since otherwise direction is wrong even though top level is RTL

    setTimeout(() => {
      this.icon = window.getComputedStyle(this).direction === "ltr" ? "hass:arrow-right" : "hass:arrow-left";
    }, 100);
  }

}
customElements.define("ha-paper-icon-button-arrow-next", HaPaperIconButtonArrowNext);

/***/ }),

/***/ "./src/data/area_registry.ts":
/*!***********************************!*\
  !*** ./src/data/area_registry.ts ***!
  \***********************************/
/*! exports provided: createAreaRegistryEntry, updateAreaRegistryEntry, deleteAreaRegistryEntry, subscribeAreaRegistry */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "createAreaRegistryEntry", function() { return createAreaRegistryEntry; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "updateAreaRegistryEntry", function() { return updateAreaRegistryEntry; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "deleteAreaRegistryEntry", function() { return deleteAreaRegistryEntry; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "subscribeAreaRegistry", function() { return subscribeAreaRegistry; });
/* harmony import */ var home_assistant_js_websocket__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! home-assistant-js-websocket */ "./node_modules/home-assistant-js-websocket/dist/index.js");
/* harmony import */ var _common_string_compare__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../common/string/compare */ "./src/common/string/compare.ts");
/* harmony import */ var _common_util_debounce__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../common/util/debounce */ "./src/common/util/debounce.ts");



const createAreaRegistryEntry = (hass, values) => hass.callWS(Object.assign({
  type: "config/area_registry/create"
}, values));
const updateAreaRegistryEntry = (hass, areaId, updates) => hass.callWS(Object.assign({
  type: "config/area_registry/update",
  area_id: areaId
}, updates));
const deleteAreaRegistryEntry = (hass, areaId) => hass.callWS({
  type: "config/area_registry/delete",
  area_id: areaId
});

const fetchAreaRegistry = conn => conn.sendMessagePromise({
  type: "config/area_registry/list"
}).then(areas => areas.sort((ent1, ent2) => Object(_common_string_compare__WEBPACK_IMPORTED_MODULE_1__["compare"])(ent1.name, ent2.name)));

const subscribeAreaRegistryUpdates = (conn, store) => conn.subscribeEvents(Object(_common_util_debounce__WEBPACK_IMPORTED_MODULE_2__["debounce"])(() => fetchAreaRegistry(conn).then(areas => store.setState(areas, true)), 500, true), "area_registry_updated");

const subscribeAreaRegistry = (conn, onChange) => Object(home_assistant_js_websocket__WEBPACK_IMPORTED_MODULE_0__["createCollection"])("_areaRegistry", fetchAreaRegistry, subscribeAreaRegistryUpdates, conn, onChange);

/***/ }),

/***/ "./src/data/device_registry.ts":
/*!*************************************!*\
  !*** ./src/data/device_registry.ts ***!
  \*************************************/
/*! exports provided: fallbackDeviceName, computeDeviceName, devicesInArea, updateDeviceRegistryEntry, subscribeDeviceRegistry */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "fallbackDeviceName", function() { return fallbackDeviceName; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "computeDeviceName", function() { return computeDeviceName; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "devicesInArea", function() { return devicesInArea; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "updateDeviceRegistryEntry", function() { return updateDeviceRegistryEntry; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "subscribeDeviceRegistry", function() { return subscribeDeviceRegistry; });
/* harmony import */ var home_assistant_js_websocket__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! home-assistant-js-websocket */ "./node_modules/home-assistant-js-websocket/dist/index.js");
/* harmony import */ var _common_entity_compute_state_name__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../common/entity/compute_state_name */ "./src/common/entity/compute_state_name.ts");
/* harmony import */ var _common_util_debounce__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../common/util/debounce */ "./src/common/util/debounce.ts");



const fallbackDeviceName = (hass, entities) => {
  for (const entity of entities || []) {
    const entityId = typeof entity === "string" ? entity : entity.entity_id;
    const stateObj = hass.states[entityId];

    if (stateObj) {
      return Object(_common_entity_compute_state_name__WEBPACK_IMPORTED_MODULE_1__["computeStateName"])(stateObj);
    }
  }

  return undefined;
};
const computeDeviceName = (device, hass, entities) => {
  return device.name_by_user || device.name || entities && fallbackDeviceName(hass, entities) || hass.localize("ui.panel.config.devices.unnamed_device");
};
const devicesInArea = (devices, areaId) => devices.filter(device => device.area_id === areaId);
const updateDeviceRegistryEntry = (hass, deviceId, updates) => hass.callWS(Object.assign({
  type: "config/device_registry/update",
  device_id: deviceId
}, updates));

const fetchDeviceRegistry = conn => conn.sendMessagePromise({
  type: "config/device_registry/list"
});

const subscribeDeviceRegistryUpdates = (conn, store) => conn.subscribeEvents(Object(_common_util_debounce__WEBPACK_IMPORTED_MODULE_2__["debounce"])(() => fetchDeviceRegistry(conn).then(devices => store.setState(devices, true)), 500, true), "device_registry_updated");

const subscribeDeviceRegistry = (conn, onChange) => Object(home_assistant_js_websocket__WEBPACK_IMPORTED_MODULE_0__["createCollection"])("_dr", fetchDeviceRegistry, subscribeDeviceRegistryUpdates, conn, onChange);

/***/ }),

/***/ "./src/data/lovelace.ts":
/*!******************************!*\
  !*** ./src/data/lovelace.ts ***!
  \******************************/
/*! exports provided: fetchResources, createResource, updateResource, deleteResource, fetchDashboards, createDashboard, updateDashboard, deleteDashboard, fetchConfig, saveConfig, deleteConfig, subscribeLovelaceUpdates, getLovelaceCollection, getLegacyLovelaceCollection */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "fetchResources", function() { return fetchResources; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "createResource", function() { return createResource; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "updateResource", function() { return updateResource; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "deleteResource", function() { return deleteResource; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "fetchDashboards", function() { return fetchDashboards; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "createDashboard", function() { return createDashboard; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "updateDashboard", function() { return updateDashboard; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "deleteDashboard", function() { return deleteDashboard; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "fetchConfig", function() { return fetchConfig; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "saveConfig", function() { return saveConfig; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "deleteConfig", function() { return deleteConfig; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "subscribeLovelaceUpdates", function() { return subscribeLovelaceUpdates; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getLovelaceCollection", function() { return getLovelaceCollection; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getLegacyLovelaceCollection", function() { return getLegacyLovelaceCollection; });
/* harmony import */ var home_assistant_js_websocket__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! home-assistant-js-websocket */ "./node_modules/home-assistant-js-websocket/dist/index.js");

const fetchResources = conn => conn.sendMessagePromise({
  type: "lovelace/resources"
});
const createResource = (hass, values) => hass.callWS(Object.assign({
  type: "lovelace/resources/create"
}, values));
const updateResource = (hass, id, updates) => hass.callWS(Object.assign({
  type: "lovelace/resources/update",
  resource_id: id
}, updates));
const deleteResource = (hass, id) => hass.callWS({
  type: "lovelace/resources/delete",
  resource_id: id
});
const fetchDashboards = hass => hass.callWS({
  type: "lovelace/dashboards/list"
});
const createDashboard = (hass, values) => hass.callWS(Object.assign({
  type: "lovelace/dashboards/create"
}, values));
const updateDashboard = (hass, id, updates) => hass.callWS(Object.assign({
  type: "lovelace/dashboards/update",
  dashboard_id: id
}, updates));
const deleteDashboard = (hass, id) => hass.callWS({
  type: "lovelace/dashboards/delete",
  dashboard_id: id
});
const fetchConfig = (conn, urlPath, force) => conn.sendMessagePromise({
  type: "lovelace/config",
  url_path: urlPath,
  force
});
const saveConfig = (hass, urlPath, config) => hass.callWS({
  type: "lovelace/config/save",
  url_path: urlPath,
  config
});
const deleteConfig = (hass, urlPath) => hass.callWS({
  type: "lovelace/config/delete",
  url_path: urlPath
});
const subscribeLovelaceUpdates = (conn, urlPath, onChange) => conn.subscribeEvents(ev => {
  if (ev.data.url_path === urlPath) {
    onChange();
  }
}, "lovelace_updated");
const getLovelaceCollection = (conn, urlPath = null) => Object(home_assistant_js_websocket__WEBPACK_IMPORTED_MODULE_0__["getCollection"])(conn, `_lovelace_${urlPath !== null && urlPath !== void 0 ? urlPath : ""}`, conn2 => fetchConfig(conn2, urlPath, false), (_conn, store) => subscribeLovelaceUpdates(conn, urlPath, () => fetchConfig(conn, urlPath, false).then(config => store.setState(config, true)))); // Legacy functions to support cast for Home Assistion < 0.107

const fetchLegacyConfig = (conn, force) => conn.sendMessagePromise({
  type: "lovelace/config",
  force
});

const subscribeLegacyLovelaceUpdates = (conn, onChange) => conn.subscribeEvents(onChange, "lovelace_updated");

const getLegacyLovelaceCollection = conn => Object(home_assistant_js_websocket__WEBPACK_IMPORTED_MODULE_0__["getCollection"])(conn, "_lovelace", conn2 => fetchLegacyConfig(conn2, false), (_conn, store) => subscribeLegacyLovelaceUpdates(conn, () => fetchLegacyConfig(conn, false).then(config => store.setState(config, true))));

/***/ }),

/***/ "./src/dialogs/generic/show-dialog-box.ts":
/*!************************************************!*\
  !*** ./src/dialogs/generic/show-dialog-box.ts ***!
  \************************************************/
/*! exports provided: loadGenericDialog, showAlertDialog, showConfirmationDialog, showPromptDialog */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "loadGenericDialog", function() { return loadGenericDialog; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "showAlertDialog", function() { return showAlertDialog; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "showConfirmationDialog", function() { return showConfirmationDialog; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "showPromptDialog", function() { return showPromptDialog; });
/* harmony import */ var _common_dom_fire_event__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../common/dom/fire_event */ "./src/common/dom/fire_event.ts");

const loadGenericDialog = () => Promise.all(/*! import() | confirmation */[__webpack_require__.e(1), __webpack_require__.e(4), __webpack_require__.e(5), __webpack_require__.e("vendors~cloud-webhook-manage-dialog~config-entry-system-options~confirmation~device-registry-detail-~836e8839"), __webpack_require__.e(13), __webpack_require__.e("vendors~confirmation"), __webpack_require__.e(14), __webpack_require__.e("confirmation")]).then(__webpack_require__.bind(null, /*! ./dialog-box */ "./src/dialogs/generic/dialog-box.ts"));

const showDialogHelper = (element, dialogParams, extra) => new Promise(resolve => {
  const origCancel = dialogParams.cancel;
  const origConfirm = dialogParams.confirm;
  Object(_common_dom_fire_event__WEBPACK_IMPORTED_MODULE_0__["fireEvent"])(element, "show-dialog", {
    dialogTag: "dialog-box",
    dialogImport: loadGenericDialog,
    dialogParams: Object.assign({}, dialogParams, {}, extra, {
      cancel: () => {
        resolve((extra === null || extra === void 0 ? void 0 : extra.prompt) ? null : false);

        if (origCancel) {
          origCancel();
        }
      },
      confirm: out => {
        resolve((extra === null || extra === void 0 ? void 0 : extra.prompt) ? out : true);

        if (origConfirm) {
          origConfirm(out);
        }
      }
    })
  });
});

const showAlertDialog = (element, dialogParams) => showDialogHelper(element, dialogParams);
const showConfirmationDialog = (element, dialogParams) => showDialogHelper(element, dialogParams, {
  confirmation: true
});
const showPromptDialog = (element, dialogParams) => showDialogHelper(element, dialogParams, {
  prompt: true
});

/***/ }),

/***/ "./src/dialogs/voice-command-dialog/show-ha-voice-command-dialog.ts":
/*!**************************************************************************!*\
  !*** ./src/dialogs/voice-command-dialog/show-ha-voice-command-dialog.ts ***!
  \**************************************************************************/
/*! exports provided: showVoiceCommandDialog */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "showVoiceCommandDialog", function() { return showVoiceCommandDialog; });
/* harmony import */ var _common_dom_fire_event__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../common/dom/fire_event */ "./src/common/dom/fire_event.ts");


const loadVoiceCommandDialog = () => Promise.all(/*! import() | ha-voice-command-dialog */[__webpack_require__.e("vendors~cloud-webhook-manage-dialog~config-entry-system-options~confirmation~device-registry-detail-~836e8839"), __webpack_require__.e("ha-voice-command-dialog")]).then(__webpack_require__.bind(null, /*! ./ha-voice-command-dialog */ "./src/dialogs/voice-command-dialog/ha-voice-command-dialog.ts"));

const showVoiceCommandDialog = element => {
  Object(_common_dom_fire_event__WEBPACK_IMPORTED_MODULE_0__["fireEvent"])(element, "show-dialog", {
    dialogTag: "ha-voice-command-dialog",
    dialogImport: loadVoiceCommandDialog,
    dialogParams: {}
  });
};

/***/ }),

/***/ "./src/layouts/ha-app-layout.js":
/*!**************************************!*\
  !*** ./src/layouts/ha-app-layout.js ***!
  \**************************************/
/*! no exports provided */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _polymer_app_layout_app_header_layout_app_header_layout__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @polymer/app-layout/app-header-layout/app-header-layout */ "./node_modules/@polymer/app-layout/app-header-layout/app-header-layout.js");
/* harmony import */ var _polymer_polymer_lib_utils_html_tag__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @polymer/polymer/lib/utils/html-tag */ "./node_modules/@polymer/polymer/lib/utils/html-tag.js");
/* harmony import */ var _polymer_polymer_polymer_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @polymer/polymer/polymer-element */ "./node_modules/@polymer/polymer/polymer-element.js");
/**
@license
Copyright (c) 2015 The Polymer Project Authors. All rights reserved.
This code may only be used under the BSD style license found at http://polymer.github.io/LICENSE.txt
The complete set of authors may be found at http://polymer.github.io/AUTHORS.txt
The complete set of contributors may be found at http://polymer.github.io/CONTRIBUTORS.txt
Code distributed by Google as part of the polymer project is also
subject to an additional IP rights grant found at http://polymer.github.io/PATENTS.txt
*/

/*
This code is copied from app-header-layout.
'fullbleed' support is removed as Home Assisstant doesn't use it.
transform: translate(0) is added.
*/

/*
  FIXME(polymer-modulizer): the above comments were extracted
  from HTML and may be out of place here. Review them and
  then delete this comment!
*/




class HaAppLayout extends customElements.get("app-header-layout") {
  static get template() {
    return _polymer_polymer_lib_utils_html_tag__WEBPACK_IMPORTED_MODULE_1__["html"]`
      <style>
        :host {
          display: block;
          /**
         * Force app-header-layout to have its own stacking context so that its parent can
         * control the stacking of it relative to other elements (e.g. app-drawer-layout).
         * This could be done using \`isolation: isolate\`, but that's not well supported
         * across browsers.
         */
          position: relative;
          z-index: 0;
        }

        #wrapper ::slotted([slot="header"]) {
          @apply --layout-fixed-top;
          z-index: 1;
        }

        #wrapper.initializing ::slotted([slot="header"]) {
          position: relative;
        }

        :host([has-scrolling-region]) {
          height: 100%;
        }

        :host([has-scrolling-region]) #wrapper ::slotted([slot="header"]) {
          position: absolute;
        }

        :host([has-scrolling-region])
          #wrapper.initializing
          ::slotted([slot="header"]) {
          position: relative;
        }

        :host([has-scrolling-region]) #wrapper #contentContainer {
          @apply --layout-fit;
          overflow-y: auto;
          -webkit-overflow-scrolling: touch;
        }

        :host([has-scrolling-region]) #wrapper.initializing #contentContainer {
          position: relative;
        }

        #contentContainer {
          /* Create a stacking context here so that all children appear below the header. */
          position: relative;
          z-index: 0;
          /* Using 'transform' will cause 'position: fixed' elements to behave like
           'position: absolute' relative to this element. */
          transform: translate(0);
        }

        @media print {
          :host([has-scrolling-region]) #wrapper #contentContainer {
            overflow-y: visible;
          }
        }
      </style>

      <div id="wrapper" class="initializing">
        <slot id="headerSlot" name="header"></slot>

        <div id="contentContainer"><slot></slot></div>
        <slot id="fab" name="fab"></slot>
      </div>
    `;
  }

}

customElements.define("ha-app-layout", HaAppLayout);

/***/ }),

/***/ "./src/panels/lovelace/badges/hui-state-label-badge.ts":
/*!*************************************************************!*\
  !*** ./src/panels/lovelace/badges/hui-state-label-badge.ts ***!
  \*************************************************************/
/*! exports provided: HuiStateLabelBadge */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HuiStateLabelBadge", function() { return HuiStateLabelBadge; });
/* harmony import */ var lit_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lit-element */ "./node_modules/lit-element/lit-element.js");
/* harmony import */ var lit_html_directives_if_defined__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lit-html/directives/if-defined */ "./node_modules/lit-html/directives/if-defined.js");
/* harmony import */ var _components_entity_ha_state_label_badge__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../components/entity/ha-state-label-badge */ "./src/components/entity/ha-state-label-badge.ts");
/* harmony import */ var _common_directives_action_handler_directive__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../common/directives/action-handler-directive */ "./src/panels/lovelace/common/directives/action-handler-directive.ts");
/* harmony import */ var _common_handle_action__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../common/handle-action */ "./src/panels/lovelace/common/handle-action.ts");
/* harmony import */ var _common_has_action__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../common/has-action */ "./src/panels/lovelace/common/has-action.ts");
/* harmony import */ var _components_hui_warning_element__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../components/hui-warning-element */ "./src/panels/lovelace/components/hui-warning-element.ts");
function _decorate(decorators, factory, superClass, mixins) { var api = _getDecoratorsApi(); if (mixins) { for (var i = 0; i < mixins.length; i++) { api = mixins[i](api); } } var r = factory(function initialize(O) { api.initializeInstanceElements(O, decorated.elements); }, superClass); var decorated = api.decorateClass(_coalesceClassElements(r.d.map(_createElementDescriptor)), decorators); api.initializeClassElements(r.F, decorated.elements); return api.runClassFinishers(r.F, decorated.finishers); }

function _getDecoratorsApi() { _getDecoratorsApi = function () { return api; }; var api = { elementsDefinitionOrder: [["method"], ["field"]], initializeInstanceElements: function (O, elements) { ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { if (element.kind === kind && element.placement === "own") { this.defineClassElement(O, element); } }, this); }, this); }, initializeClassElements: function (F, elements) { var proto = F.prototype; ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { var placement = element.placement; if (element.kind === kind && (placement === "static" || placement === "prototype")) { var receiver = placement === "static" ? F : proto; this.defineClassElement(receiver, element); } }, this); }, this); }, defineClassElement: function (receiver, element) { var descriptor = element.descriptor; if (element.kind === "field") { var initializer = element.initializer; descriptor = { enumerable: descriptor.enumerable, writable: descriptor.writable, configurable: descriptor.configurable, value: initializer === void 0 ? void 0 : initializer.call(receiver) }; } Object.defineProperty(receiver, element.key, descriptor); }, decorateClass: function (elements, decorators) { var newElements = []; var finishers = []; var placements = { static: [], prototype: [], own: [] }; elements.forEach(function (element) { this.addElementPlacement(element, placements); }, this); elements.forEach(function (element) { if (!_hasDecorators(element)) return newElements.push(element); var elementFinishersExtras = this.decorateElement(element, placements); newElements.push(elementFinishersExtras.element); newElements.push.apply(newElements, elementFinishersExtras.extras); finishers.push.apply(finishers, elementFinishersExtras.finishers); }, this); if (!decorators) { return { elements: newElements, finishers: finishers }; } var result = this.decorateConstructor(newElements, decorators); finishers.push.apply(finishers, result.finishers); result.finishers = finishers; return result; }, addElementPlacement: function (element, placements, silent) { var keys = placements[element.placement]; if (!silent && keys.indexOf(element.key) !== -1) { throw new TypeError("Duplicated element (" + element.key + ")"); } keys.push(element.key); }, decorateElement: function (element, placements) { var extras = []; var finishers = []; for (var decorators = element.decorators, i = decorators.length - 1; i >= 0; i--) { var keys = placements[element.placement]; keys.splice(keys.indexOf(element.key), 1); var elementObject = this.fromElementDescriptor(element); var elementFinisherExtras = this.toElementFinisherExtras((0, decorators[i])(elementObject) || elementObject); element = elementFinisherExtras.element; this.addElementPlacement(element, placements); if (elementFinisherExtras.finisher) { finishers.push(elementFinisherExtras.finisher); } var newExtras = elementFinisherExtras.extras; if (newExtras) { for (var j = 0; j < newExtras.length; j++) { this.addElementPlacement(newExtras[j], placements); } extras.push.apply(extras, newExtras); } } return { element: element, finishers: finishers, extras: extras }; }, decorateConstructor: function (elements, decorators) { var finishers = []; for (var i = decorators.length - 1; i >= 0; i--) { var obj = this.fromClassDescriptor(elements); var elementsAndFinisher = this.toClassDescriptor((0, decorators[i])(obj) || obj); if (elementsAndFinisher.finisher !== undefined) { finishers.push(elementsAndFinisher.finisher); } if (elementsAndFinisher.elements !== undefined) { elements = elementsAndFinisher.elements; for (var j = 0; j < elements.length - 1; j++) { for (var k = j + 1; k < elements.length; k++) { if (elements[j].key === elements[k].key && elements[j].placement === elements[k].placement) { throw new TypeError("Duplicated element (" + elements[j].key + ")"); } } } } } return { elements: elements, finishers: finishers }; }, fromElementDescriptor: function (element) { var obj = { kind: element.kind, key: element.key, placement: element.placement, descriptor: element.descriptor }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); if (element.kind === "field") obj.initializer = element.initializer; return obj; }, toElementDescriptors: function (elementObjects) { if (elementObjects === undefined) return; return _toArray(elementObjects).map(function (elementObject) { var element = this.toElementDescriptor(elementObject); this.disallowProperty(elementObject, "finisher", "An element descriptor"); this.disallowProperty(elementObject, "extras", "An element descriptor"); return element; }, this); }, toElementDescriptor: function (elementObject) { var kind = String(elementObject.kind); if (kind !== "method" && kind !== "field") { throw new TypeError('An element descriptor\'s .kind property must be either "method" or' + ' "field", but a decorator created an element descriptor with' + ' .kind "' + kind + '"'); } var key = _toPropertyKey(elementObject.key); var placement = String(elementObject.placement); if (placement !== "static" && placement !== "prototype" && placement !== "own") { throw new TypeError('An element descriptor\'s .placement property must be one of "static",' + ' "prototype" or "own", but a decorator created an element descriptor' + ' with .placement "' + placement + '"'); } var descriptor = elementObject.descriptor; this.disallowProperty(elementObject, "elements", "An element descriptor"); var element = { kind: kind, key: key, placement: placement, descriptor: Object.assign({}, descriptor) }; if (kind !== "field") { this.disallowProperty(elementObject, "initializer", "A method descriptor"); } else { this.disallowProperty(descriptor, "get", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "set", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "value", "The property descriptor of a field descriptor"); element.initializer = elementObject.initializer; } return element; }, toElementFinisherExtras: function (elementObject) { var element = this.toElementDescriptor(elementObject); var finisher = _optionalCallableProperty(elementObject, "finisher"); var extras = this.toElementDescriptors(elementObject.extras); return { element: element, finisher: finisher, extras: extras }; }, fromClassDescriptor: function (elements) { var obj = { kind: "class", elements: elements.map(this.fromElementDescriptor, this) }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); return obj; }, toClassDescriptor: function (obj) { var kind = String(obj.kind); if (kind !== "class") { throw new TypeError('A class descriptor\'s .kind property must be "class", but a decorator' + ' created a class descriptor with .kind "' + kind + '"'); } this.disallowProperty(obj, "key", "A class descriptor"); this.disallowProperty(obj, "placement", "A class descriptor"); this.disallowProperty(obj, "descriptor", "A class descriptor"); this.disallowProperty(obj, "initializer", "A class descriptor"); this.disallowProperty(obj, "extras", "A class descriptor"); var finisher = _optionalCallableProperty(obj, "finisher"); var elements = this.toElementDescriptors(obj.elements); return { elements: elements, finisher: finisher }; }, runClassFinishers: function (constructor, finishers) { for (var i = 0; i < finishers.length; i++) { var newConstructor = (0, finishers[i])(constructor); if (newConstructor !== undefined) { if (typeof newConstructor !== "function") { throw new TypeError("Finishers must return a constructor."); } constructor = newConstructor; } } return constructor; }, disallowProperty: function (obj, name, objectType) { if (obj[name] !== undefined) { throw new TypeError(objectType + " can't have a ." + name + " property."); } } }; return api; }

function _createElementDescriptor(def) { var key = _toPropertyKey(def.key); var descriptor; if (def.kind === "method") { descriptor = { value: def.value, writable: true, configurable: true, enumerable: false }; } else if (def.kind === "get") { descriptor = { get: def.value, configurable: true, enumerable: false }; } else if (def.kind === "set") { descriptor = { set: def.value, configurable: true, enumerable: false }; } else if (def.kind === "field") { descriptor = { configurable: true, writable: true, enumerable: true }; } var element = { kind: def.kind === "field" ? "field" : "method", key: key, placement: def.static ? "static" : def.kind === "field" ? "own" : "prototype", descriptor: descriptor }; if (def.decorators) element.decorators = def.decorators; if (def.kind === "field") element.initializer = def.value; return element; }

function _coalesceGetterSetter(element, other) { if (element.descriptor.get !== undefined) { other.descriptor.get = element.descriptor.get; } else { other.descriptor.set = element.descriptor.set; } }

function _coalesceClassElements(elements) { var newElements = []; var isSameElement = function (other) { return other.kind === "method" && other.key === element.key && other.placement === element.placement; }; for (var i = 0; i < elements.length; i++) { var element = elements[i]; var other; if (element.kind === "method" && (other = newElements.find(isSameElement))) { if (_isDataDescriptor(element.descriptor) || _isDataDescriptor(other.descriptor)) { if (_hasDecorators(element) || _hasDecorators(other)) { throw new ReferenceError("Duplicated methods (" + element.key + ") can't be decorated."); } other.descriptor = element.descriptor; } else { if (_hasDecorators(element)) { if (_hasDecorators(other)) { throw new ReferenceError("Decorators can't be placed on different accessors with for " + "the same property (" + element.key + ")."); } other.decorators = element.decorators; } _coalesceGetterSetter(element, other); } } else { newElements.push(element); } } return newElements; }

function _hasDecorators(element) { return element.decorators && element.decorators.length; }

function _isDataDescriptor(desc) { return desc !== undefined && !(desc.value === undefined && desc.writable === undefined); }

function _optionalCallableProperty(obj, name) { var value = obj[name]; if (value !== undefined && typeof value !== "function") { throw new TypeError("Expected '" + name + "' to be a function"); } return value; }

function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }

function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }

function _toArray(arr) { return _arrayWithHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(n); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }








let HuiStateLabelBadge = _decorate([Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["customElement"])("hui-state-label-badge")], function (_initialize, _LitElement) {
  class HuiStateLabelBadge extends _LitElement {
    constructor(...args) {
      super(...args);

      _initialize(this);
    }

  }

  return {
    F: HuiStateLabelBadge,
    d: [{
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "hass",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "_config",
      value: void 0
    }, {
      kind: "method",
      key: "setConfig",
      value: function setConfig(config) {
        this._config = config;
      }
    }, {
      kind: "method",
      key: "render",
      value: function render() {
        if (!this._config || !this.hass) {
          return lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]``;
        }

        const stateObj = this.hass.states[this._config.entity];
        return lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
      <ha-state-label-badge
        .hass=${this.hass}
        .state=${stateObj}
        .name=${this._config.name}
        .icon=${this._config.icon}
        .image=${this._config.image}
        @action=${this._handleAction}
        .actionHandler=${Object(_common_directives_action_handler_directive__WEBPACK_IMPORTED_MODULE_3__["actionHandler"])({
          hasHold: Object(_common_has_action__WEBPACK_IMPORTED_MODULE_5__["hasAction"])(this._config.hold_action),
          hasDoubleClick: Object(_common_has_action__WEBPACK_IMPORTED_MODULE_5__["hasAction"])(this._config.double_tap_action)
        })}
        tabindex=${Object(lit_html_directives_if_defined__WEBPACK_IMPORTED_MODULE_1__["ifDefined"])(Object(_common_has_action__WEBPACK_IMPORTED_MODULE_5__["hasAction"])(this._config.tap_action) || this._config.entity ? "0" : undefined)}
      ></ha-state-label-badge>
    `;
      }
    }, {
      kind: "method",
      key: "_handleAction",
      value: function _handleAction(ev) {
        Object(_common_handle_action__WEBPACK_IMPORTED_MODULE_4__["handleAction"])(this, this.hass, this._config, ev.detail.action);
      }
    }, {
      kind: "get",
      static: true,
      key: "styles",
      value: function styles() {
        return lit_element__WEBPACK_IMPORTED_MODULE_0__["css"]`
      ha-state-label-badge:focus {
        outline: none;
        background: var(--divider-color);
        border-radius: 4px;
      }
      ha-state-label-badge {
        display: inline-block;
        padding: 4px 2px 4px 2px;
        margin: -4px -2px -4px -2px;
      }
    `;
      }
    }]
  };
}, lit_element__WEBPACK_IMPORTED_MODULE_0__["LitElement"]);

/***/ }),

/***/ "./src/panels/lovelace/common/load-resources.ts":
/*!******************************************************!*\
  !*** ./src/panels/lovelace/common/load-resources.ts ***!
  \******************************************************/
/*! exports provided: loadLovelaceResources */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "loadLovelaceResources", function() { return loadLovelaceResources; });
/* harmony import */ var _common_dom_load_resource__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../common/dom/load_resource */ "./src/common/dom/load_resource.ts");

// CSS and JS should only be imported once. Modules and HTML are safe.
const CSS_CACHE = {};
const JS_CACHE = {};
const loadLovelaceResources = (resources, hassUrl) => resources.forEach(resource => {
  const normalizedUrl = new URL(resource.url, hassUrl).toString();

  switch (resource.type) {
    case "css":
      if (normalizedUrl in CSS_CACHE) {
        break;
      }

      CSS_CACHE[normalizedUrl] = Object(_common_dom_load_resource__WEBPACK_IMPORTED_MODULE_0__["loadCSS"])(normalizedUrl);
      break;

    case "js":
      if (normalizedUrl in JS_CACHE) {
        break;
      }

      JS_CACHE[normalizedUrl] = Object(_common_dom_load_resource__WEBPACK_IMPORTED_MODULE_0__["loadJS"])(normalizedUrl);
      break;

    case "module":
      Object(_common_dom_load_resource__WEBPACK_IMPORTED_MODULE_0__["loadModule"])(normalizedUrl);
      break;

    case "html":
      __webpack_require__.e(/*! import() | import-href-polyfill */ "import-href-polyfill").then(__webpack_require__.bind(null, /*! ../../../resources/html-import/import-href */ "./src/resources/html-import/import-href.js")).then(({
        importHref
      }) => importHref(normalizedUrl));
      break;

    default:
      // eslint-disable-next-line
      console.warn(`Unknown resource type specified: ${resource.type}`);
  }
});

/***/ }),

/***/ "./src/panels/lovelace/create-element/create-badge-element.ts":
/*!********************************************************************!*\
  !*** ./src/panels/lovelace/create-element/create-badge-element.ts ***!
  \********************************************************************/
/*! exports provided: createBadgeElement */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "createBadgeElement", function() { return createBadgeElement; });
/* harmony import */ var _badges_hui_state_label_badge__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../badges/hui-state-label-badge */ "./src/panels/lovelace/badges/hui-state-label-badge.ts");
/* harmony import */ var _create_element_base__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./create-element-base */ "./src/panels/lovelace/create-element/create-element-base.ts");


const ALWAYS_LOADED_TYPES = new Set(["error", "state-label"]);
const LAZY_LOAD_TYPES = {
  "entity-filter": () => __webpack_require__.e(/*! import() */ 67).then(__webpack_require__.bind(null, /*! ../badges/hui-entity-filter-badge */ "./src/panels/lovelace/badges/hui-entity-filter-badge.ts"))
};
const createBadgeElement = config => Object(_create_element_base__WEBPACK_IMPORTED_MODULE_1__["createLovelaceElement"])("badge", config, ALWAYS_LOADED_TYPES, LAZY_LOAD_TYPES, undefined, "state-label");

/***/ }),

/***/ "./src/panels/lovelace/editor/lovelace-editor/show-edit-lovelace-dialog.ts":
/*!*********************************************************************************!*\
  !*** ./src/panels/lovelace/editor/lovelace-editor/show-edit-lovelace-dialog.ts ***!
  \*********************************************************************************/
/*! exports provided: showEditLovelaceDialog */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "showEditLovelaceDialog", function() { return showEditLovelaceDialog; });
/* harmony import */ var _common_dom_fire_event__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../common/dom/fire_event */ "./src/common/dom/fire_event.ts");

let registeredDialog = false;
const dialogShowEvent = "show-edit-lovelace";
const dialogTag = "hui-dialog-edit-lovelace";

const registerEditLovelaceDialog = element => Object(_common_dom_fire_event__WEBPACK_IMPORTED_MODULE_0__["fireEvent"])(element, "register-dialog", {
  dialogShowEvent,
  dialogTag,
  dialogImport: () => Promise.all(/*! import() | hui-dialog-edit-lovelace */[__webpack_require__.e("vendors~cloud-webhook-manage-dialog~config-entry-system-options~confirmation~device-registry-detail-~836e8839"), __webpack_require__.e("hui-dialog-edit-lovelace")]).then(__webpack_require__.bind(null, /*! ./hui-dialog-edit-lovelace */ "./src/panels/lovelace/editor/lovelace-editor/hui-dialog-edit-lovelace.ts"))
});

const showEditLovelaceDialog = (element, lovelace) => {
  if (!registeredDialog) {
    registeredDialog = true;
    registerEditLovelaceDialog(element);
  }

  Object(_common_dom_fire_event__WEBPACK_IMPORTED_MODULE_0__["fireEvent"])(element, dialogShowEvent, lovelace);
};

/***/ }),

/***/ "./src/panels/lovelace/editor/show-save-config-dialog.ts":
/*!***************************************************************!*\
  !*** ./src/panels/lovelace/editor/show-save-config-dialog.ts ***!
  \***************************************************************/
/*! exports provided: showSaveDialog */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "showSaveDialog", function() { return showSaveDialog; });
/* harmony import */ var _common_dom_fire_event__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../common/dom/fire_event */ "./src/common/dom/fire_event.ts");

const dialogShowEvent = "show-save-config";
const dialogTag = "hui-dialog-save-config";
let registeredDialog = false;
const showSaveDialog = (element, saveDialogParams) => {
  if (!registeredDialog) {
    registeredDialog = true;
    Object(_common_dom_fire_event__WEBPACK_IMPORTED_MODULE_0__["fireEvent"])(element, "register-dialog", {
      dialogShowEvent,
      dialogTag,
      dialogImport: () => Promise.all(/*! import() | hui-dialog-save-config */[__webpack_require__.e("vendors~cloud-webhook-manage-dialog~config-entry-system-options~confirmation~device-registry-detail-~836e8839"), __webpack_require__.e(17), __webpack_require__.e(18), __webpack_require__.e("hui-dialog-save-config~hui-dialog-suggest-card~panel-config-automation~panel-config-script"), __webpack_require__.e("hui-dialog-save-config")]).then(__webpack_require__.bind(null, /*! ./hui-dialog-save-config */ "./src/panels/lovelace/editor/hui-dialog-save-config.ts"))
    });
  }

  Object(_common_dom_fire_event__WEBPACK_IMPORTED_MODULE_0__["fireEvent"])(element, dialogShowEvent, saveDialogParams);
};

/***/ }),

/***/ "./src/panels/lovelace/editor/view-editor/show-edit-view-dialog.ts":
/*!*************************************************************************!*\
  !*** ./src/panels/lovelace/editor/view-editor/show-edit-view-dialog.ts ***!
  \*************************************************************************/
/*! exports provided: showEditViewDialog */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "showEditViewDialog", function() { return showEditViewDialog; });
/* harmony import */ var _common_dom_fire_event__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../common/dom/fire_event */ "./src/common/dom/fire_event.ts");

let registeredDialog = false;
const dialogShowEvent = "show-edit-view";
const dialogTag = "hui-dialog-edit-view";

const registerEditViewDialog = element => Object(_common_dom_fire_event__WEBPACK_IMPORTED_MODULE_0__["fireEvent"])(element, "register-dialog", {
  dialogShowEvent,
  dialogTag,
  dialogImport: () => Promise.all(/*! import() | hui-dialog-edit-view */[__webpack_require__.e(6), __webpack_require__.e(7), __webpack_require__.e(8), __webpack_require__.e("vendors~cloud-webhook-manage-dialog~config-entry-system-options~confirmation~device-registry-detail-~836e8839"), __webpack_require__.e("vendors~hui-dialog-edit-view"), __webpack_require__.e(10), __webpack_require__.e("hui-alarm-panel-card-editor~hui-button-card-editor~hui-dialog-edit-view~hui-entities-card-editor~hui~192a43f6"), __webpack_require__.e("hui-button-card-editor~hui-dialog-edit-view~hui-entities-card-editor~hui-entity-card-editor~hui-gaug~aa2f21d6"), __webpack_require__.e("hui-dialog-edit-view")]).then(__webpack_require__.bind(null, /*! ./hui-dialog-edit-view */ "./src/panels/lovelace/editor/view-editor/hui-dialog-edit-view.ts"))
});

const showEditViewDialog = (element, editViewDialogParams) => {
  if (!registeredDialog) {
    registeredDialog = true;
    registerEditViewDialog(element);
  }

  Object(_common_dom_fire_event__WEBPACK_IMPORTED_MODULE_0__["fireEvent"])(element, dialogShowEvent, editViewDialogParams);
};

/***/ }),

/***/ "./src/panels/lovelace/ha-panel-lovelace.ts":
/*!**************************************************!*\
  !*** ./src/panels/lovelace/ha-panel-lovelace.ts ***!
  \**************************************************/
/*! no exports provided */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _material_mwc_button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @material/mwc-button */ "./node_modules/@material/mwc-button/mwc-button.js");
/* harmony import */ var deep_freeze__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! deep-freeze */ "./node_modules/deep-freeze/index.js");
/* harmony import */ var deep_freeze__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(deep_freeze__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var lit_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lit-element */ "./node_modules/lit-element/lit-element.js");
/* harmony import */ var _data_integration__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../data/integration */ "./src/data/integration.ts");
/* harmony import */ var _data_lovelace__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../data/lovelace */ "./src/data/lovelace.ts");
/* harmony import */ var _layouts_hass_error_screen__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../layouts/hass-error-screen */ "./src/layouts/hass-error-screen.ts");
/* harmony import */ var _layouts_hass_loading_screen__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../layouts/hass-loading-screen */ "./src/layouts/hass-loading-screen.ts");
/* harmony import */ var _util_toast__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../util/toast */ "./src/util/toast.ts");
/* harmony import */ var _common_generate_lovelace_config__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./common/generate-lovelace-config */ "./src/panels/lovelace/common/generate-lovelace-config.ts");
/* harmony import */ var _common_load_resources__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./common/load-resources */ "./src/panels/lovelace/common/load-resources.ts");
/* harmony import */ var _editor_show_save_config_dialog__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./editor/show-save-config-dialog */ "./src/panels/lovelace/editor/show-save-config-dialog.ts");
/* harmony import */ var _hui_root__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./hui-root */ "./src/panels/lovelace/hui-root.ts");
function _decorate(decorators, factory, superClass, mixins) { var api = _getDecoratorsApi(); if (mixins) { for (var i = 0; i < mixins.length; i++) { api = mixins[i](api); } } var r = factory(function initialize(O) { api.initializeInstanceElements(O, decorated.elements); }, superClass); var decorated = api.decorateClass(_coalesceClassElements(r.d.map(_createElementDescriptor)), decorators); api.initializeClassElements(r.F, decorated.elements); return api.runClassFinishers(r.F, decorated.finishers); }

function _getDecoratorsApi() { _getDecoratorsApi = function () { return api; }; var api = { elementsDefinitionOrder: [["method"], ["field"]], initializeInstanceElements: function (O, elements) { ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { if (element.kind === kind && element.placement === "own") { this.defineClassElement(O, element); } }, this); }, this); }, initializeClassElements: function (F, elements) { var proto = F.prototype; ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { var placement = element.placement; if (element.kind === kind && (placement === "static" || placement === "prototype")) { var receiver = placement === "static" ? F : proto; this.defineClassElement(receiver, element); } }, this); }, this); }, defineClassElement: function (receiver, element) { var descriptor = element.descriptor; if (element.kind === "field") { var initializer = element.initializer; descriptor = { enumerable: descriptor.enumerable, writable: descriptor.writable, configurable: descriptor.configurable, value: initializer === void 0 ? void 0 : initializer.call(receiver) }; } Object.defineProperty(receiver, element.key, descriptor); }, decorateClass: function (elements, decorators) { var newElements = []; var finishers = []; var placements = { static: [], prototype: [], own: [] }; elements.forEach(function (element) { this.addElementPlacement(element, placements); }, this); elements.forEach(function (element) { if (!_hasDecorators(element)) return newElements.push(element); var elementFinishersExtras = this.decorateElement(element, placements); newElements.push(elementFinishersExtras.element); newElements.push.apply(newElements, elementFinishersExtras.extras); finishers.push.apply(finishers, elementFinishersExtras.finishers); }, this); if (!decorators) { return { elements: newElements, finishers: finishers }; } var result = this.decorateConstructor(newElements, decorators); finishers.push.apply(finishers, result.finishers); result.finishers = finishers; return result; }, addElementPlacement: function (element, placements, silent) { var keys = placements[element.placement]; if (!silent && keys.indexOf(element.key) !== -1) { throw new TypeError("Duplicated element (" + element.key + ")"); } keys.push(element.key); }, decorateElement: function (element, placements) { var extras = []; var finishers = []; for (var decorators = element.decorators, i = decorators.length - 1; i >= 0; i--) { var keys = placements[element.placement]; keys.splice(keys.indexOf(element.key), 1); var elementObject = this.fromElementDescriptor(element); var elementFinisherExtras = this.toElementFinisherExtras((0, decorators[i])(elementObject) || elementObject); element = elementFinisherExtras.element; this.addElementPlacement(element, placements); if (elementFinisherExtras.finisher) { finishers.push(elementFinisherExtras.finisher); } var newExtras = elementFinisherExtras.extras; if (newExtras) { for (var j = 0; j < newExtras.length; j++) { this.addElementPlacement(newExtras[j], placements); } extras.push.apply(extras, newExtras); } } return { element: element, finishers: finishers, extras: extras }; }, decorateConstructor: function (elements, decorators) { var finishers = []; for (var i = decorators.length - 1; i >= 0; i--) { var obj = this.fromClassDescriptor(elements); var elementsAndFinisher = this.toClassDescriptor((0, decorators[i])(obj) || obj); if (elementsAndFinisher.finisher !== undefined) { finishers.push(elementsAndFinisher.finisher); } if (elementsAndFinisher.elements !== undefined) { elements = elementsAndFinisher.elements; for (var j = 0; j < elements.length - 1; j++) { for (var k = j + 1; k < elements.length; k++) { if (elements[j].key === elements[k].key && elements[j].placement === elements[k].placement) { throw new TypeError("Duplicated element (" + elements[j].key + ")"); } } } } } return { elements: elements, finishers: finishers }; }, fromElementDescriptor: function (element) { var obj = { kind: element.kind, key: element.key, placement: element.placement, descriptor: element.descriptor }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); if (element.kind === "field") obj.initializer = element.initializer; return obj; }, toElementDescriptors: function (elementObjects) { if (elementObjects === undefined) return; return _toArray(elementObjects).map(function (elementObject) { var element = this.toElementDescriptor(elementObject); this.disallowProperty(elementObject, "finisher", "An element descriptor"); this.disallowProperty(elementObject, "extras", "An element descriptor"); return element; }, this); }, toElementDescriptor: function (elementObject) { var kind = String(elementObject.kind); if (kind !== "method" && kind !== "field") { throw new TypeError('An element descriptor\'s .kind property must be either "method" or' + ' "field", but a decorator created an element descriptor with' + ' .kind "' + kind + '"'); } var key = _toPropertyKey(elementObject.key); var placement = String(elementObject.placement); if (placement !== "static" && placement !== "prototype" && placement !== "own") { throw new TypeError('An element descriptor\'s .placement property must be one of "static",' + ' "prototype" or "own", but a decorator created an element descriptor' + ' with .placement "' + placement + '"'); } var descriptor = elementObject.descriptor; this.disallowProperty(elementObject, "elements", "An element descriptor"); var element = { kind: kind, key: key, placement: placement, descriptor: Object.assign({}, descriptor) }; if (kind !== "field") { this.disallowProperty(elementObject, "initializer", "A method descriptor"); } else { this.disallowProperty(descriptor, "get", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "set", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "value", "The property descriptor of a field descriptor"); element.initializer = elementObject.initializer; } return element; }, toElementFinisherExtras: function (elementObject) { var element = this.toElementDescriptor(elementObject); var finisher = _optionalCallableProperty(elementObject, "finisher"); var extras = this.toElementDescriptors(elementObject.extras); return { element: element, finisher: finisher, extras: extras }; }, fromClassDescriptor: function (elements) { var obj = { kind: "class", elements: elements.map(this.fromElementDescriptor, this) }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); return obj; }, toClassDescriptor: function (obj) { var kind = String(obj.kind); if (kind !== "class") { throw new TypeError('A class descriptor\'s .kind property must be "class", but a decorator' + ' created a class descriptor with .kind "' + kind + '"'); } this.disallowProperty(obj, "key", "A class descriptor"); this.disallowProperty(obj, "placement", "A class descriptor"); this.disallowProperty(obj, "descriptor", "A class descriptor"); this.disallowProperty(obj, "initializer", "A class descriptor"); this.disallowProperty(obj, "extras", "A class descriptor"); var finisher = _optionalCallableProperty(obj, "finisher"); var elements = this.toElementDescriptors(obj.elements); return { elements: elements, finisher: finisher }; }, runClassFinishers: function (constructor, finishers) { for (var i = 0; i < finishers.length; i++) { var newConstructor = (0, finishers[i])(constructor); if (newConstructor !== undefined) { if (typeof newConstructor !== "function") { throw new TypeError("Finishers must return a constructor."); } constructor = newConstructor; } } return constructor; }, disallowProperty: function (obj, name, objectType) { if (obj[name] !== undefined) { throw new TypeError(objectType + " can't have a ." + name + " property."); } } }; return api; }

function _createElementDescriptor(def) { var key = _toPropertyKey(def.key); var descriptor; if (def.kind === "method") { descriptor = { value: def.value, writable: true, configurable: true, enumerable: false }; } else if (def.kind === "get") { descriptor = { get: def.value, configurable: true, enumerable: false }; } else if (def.kind === "set") { descriptor = { set: def.value, configurable: true, enumerable: false }; } else if (def.kind === "field") { descriptor = { configurable: true, writable: true, enumerable: true }; } var element = { kind: def.kind === "field" ? "field" : "method", key: key, placement: def.static ? "static" : def.kind === "field" ? "own" : "prototype", descriptor: descriptor }; if (def.decorators) element.decorators = def.decorators; if (def.kind === "field") element.initializer = def.value; return element; }

function _coalesceGetterSetter(element, other) { if (element.descriptor.get !== undefined) { other.descriptor.get = element.descriptor.get; } else { other.descriptor.set = element.descriptor.set; } }

function _coalesceClassElements(elements) { var newElements = []; var isSameElement = function (other) { return other.kind === "method" && other.key === element.key && other.placement === element.placement; }; for (var i = 0; i < elements.length; i++) { var element = elements[i]; var other; if (element.kind === "method" && (other = newElements.find(isSameElement))) { if (_isDataDescriptor(element.descriptor) || _isDataDescriptor(other.descriptor)) { if (_hasDecorators(element) || _hasDecorators(other)) { throw new ReferenceError("Duplicated methods (" + element.key + ") can't be decorated."); } other.descriptor = element.descriptor; } else { if (_hasDecorators(element)) { if (_hasDecorators(other)) { throw new ReferenceError("Decorators can't be placed on different accessors with for " + "the same property (" + element.key + ")."); } other.decorators = element.decorators; } _coalesceGetterSetter(element, other); } } else { newElements.push(element); } } return newElements; }

function _hasDecorators(element) { return element.decorators && element.decorators.length; }

function _isDataDescriptor(desc) { return desc !== undefined && !(desc.value === undefined && desc.writable === undefined); }

function _optionalCallableProperty(obj, name) { var value = obj[name]; if (value !== undefined && typeof value !== "function") { throw new TypeError("Expected '" + name + "' to be a function"); } return value; }

function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }

function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }

function _toArray(arr) { return _arrayWithHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(n); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get; } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return _get(target, property, receiver || target); }

function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }














window.loadCardHelpers = () => Promise.all(/*! import() */[__webpack_require__.e(20), __webpack_require__.e(22), __webpack_require__.e(28), __webpack_require__.e(80)]).then(__webpack_require__.bind(null, /*! ./custom-card-helpers */ "./src/panels/lovelace/custom-card-helpers.ts"));

let editorLoaded = false;
let resourcesLoaded = false;

let LovelacePanel = _decorate(null, function (_initialize, _LitElement) {
  class LovelacePanel extends _LitElement {
    constructor() {
      super();

      _initialize(this);

      this._closeEditor = this._closeEditor.bind(this);
    }

  }

  return {
    F: LovelacePanel,
    d: [{
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_2__["property"])()],
      key: "panel",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_2__["property"])()],
      key: "hass",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_2__["property"])()],
      key: "narrow",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_2__["property"])()],
      key: "route",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_2__["property"])()],
      key: "_columns",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_2__["property"])()],
      key: "_state",

      value() {
        return "loading";
      }

    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_2__["property"])()],
      key: "_errorMsg",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_2__["property"])()],
      key: "lovelace",
      value: void 0
    }, {
      kind: "field",
      key: "mqls",
      value: void 0
    }, {
      kind: "field",
      key: "_ignoreNextUpdateEvent",

      value() {
        return false;
      }

    }, {
      kind: "field",
      key: "_fetchConfigOnConnect",

      value() {
        return false;
      }

    }, {
      kind: "field",
      key: "_unsubUpdates",
      value: void 0
    }, {
      kind: "method",
      key: "connectedCallback",
      value: function connectedCallback() {
        _get(_getPrototypeOf(LovelacePanel.prototype), "connectedCallback", this).call(this);

        if (this.lovelace && this.hass && this.lovelace.language !== this.hass.language) {
          // language has been changed, rebuild UI
          this._setLovelaceConfig(this.lovelace.config, this.lovelace.mode);
        } else if (this.lovelace && this.lovelace.mode === "generated") {
          // When lovelace is generated, we re-generate each time a user goes
          // to the states panel to make sure new entities are shown.
          this._state = "loading";

          this._regenerateConfig();
        } else if (this._fetchConfigOnConnect) {
          // Config was changed when we were not at the lovelace panel
          this._fetchConfig(false);
        }
      }
    }, {
      kind: "method",
      key: "disconnectedCallback",
      value: function disconnectedCallback() {
        _get(_getPrototypeOf(LovelacePanel.prototype), "disconnectedCallback", this).call(this); // On the main dashboard we want to stay subscribed as that one is cached.


        if (this.urlPath !== null && this._unsubUpdates) {
          this._unsubUpdates();
        }
      }
    }, {
      kind: "method",
      key: "render",
      value: function render() {
        const state = this._state;

        if (state === "loaded") {
          return lit_element__WEBPACK_IMPORTED_MODULE_2__["html"]`
        <hui-root
          .hass=${this.hass}
          .lovelace=${this.lovelace}
          .route=${this.route}
          .columns=${this._columns}
          .narrow=${this.narrow}
          @config-refresh=${this._forceFetchConfig}
        ></hui-root>
      `;
        }

        if (state === "error") {
          return lit_element__WEBPACK_IMPORTED_MODULE_2__["html"]`
        <hass-error-screen
          title="${Object(_data_integration__WEBPACK_IMPORTED_MODULE_3__["domainToName"])(this.hass.localize, "lovelace")}"
          .error="${this._errorMsg}"
        >
          <mwc-button raised @click=${this._forceFetchConfig}>
            ${this.hass.localize("ui.panel.lovelace.reload_lovelace")}
          </mwc-button>
        </hass-error-screen>
      `;
        }

        if (state === "yaml-editor") {
          return lit_element__WEBPACK_IMPORTED_MODULE_2__["html"]`
        <hui-editor
          .hass=${this.hass}
          .lovelace="${this.lovelace}"
          .closeEditor="${this._closeEditor}"
        ></hui-editor>
      `;
        }

        return lit_element__WEBPACK_IMPORTED_MODULE_2__["html"]`
      <hass-loading-screen
        rootnav
        .hass=${this.hass}
        .narrow=${this.narrow}
      ></hass-loading-screen>
    `;
      }
    }, {
      kind: "method",
      key: "updated",
      value: function updated(changedProps) {
        _get(_getPrototypeOf(LovelacePanel.prototype), "updated", this).call(this, changedProps);

        if (changedProps.has("narrow")) {
          this._updateColumns();

          return;
        }

        if (!changedProps.has("hass")) {
          return;
        }

        const oldHass = changedProps.get("hass");

        if (oldHass && this.hass.dockedSidebar !== oldHass.dockedSidebar) {
          this._updateColumns();
        }
      }
    }, {
      kind: "method",
      key: "firstUpdated",
      value: function firstUpdated() {
        this._fetchConfig(false);

        if (!this._unsubUpdates) {
          this._subscribeUpdates();
        } // reload lovelace on reconnect so we are sure we have the latest config


        window.addEventListener("connection-status", ev => {
          if (ev.detail === "connected") {
            this._fetchConfig(false);
          }
        });
        this._updateColumns = this._updateColumns.bind(this);
        this.mqls = [300, 600, 900, 1200].map(width => {
          const mql = matchMedia(`(min-width: ${width}px)`);
          mql.addListener(this._updateColumns);
          return mql;
        });

        this._updateColumns();
      }
    }, {
      kind: "method",
      key: "_regenerateConfig",
      value: async function _regenerateConfig() {
        const conf = await Object(_common_generate_lovelace_config__WEBPACK_IMPORTED_MODULE_8__["generateLovelaceConfigFromHass"])(this.hass);

        this._setLovelaceConfig(conf, "generated");

        this._state = "loaded";
      }
    }, {
      kind: "method",
      key: "_subscribeUpdates",
      value: async function _subscribeUpdates() {
        this._unsubUpdates = await Object(_data_lovelace__WEBPACK_IMPORTED_MODULE_4__["subscribeLovelaceUpdates"])(this.hass.connection, this.urlPath, () => this._lovelaceChanged());
      }
    }, {
      kind: "method",
      key: "_closeEditor",
      value: function _closeEditor() {
        this._state = "loaded";
      }
    }, {
      kind: "method",
      key: "_updateColumns",
      value: function _updateColumns() {
        const matchColumns = this.mqls.reduce((cols, mql) => cols + Number(mql.matches), 0); // Do -1 column if the menu is docked and open

        this._columns = Math.max(1, matchColumns - Number(!this.narrow && this.hass.dockedSidebar === "docked"));
      }
    }, {
      kind: "method",
      key: "_lovelaceChanged",
      value: function _lovelaceChanged() {
        if (this._ignoreNextUpdateEvent) {
          this._ignoreNextUpdateEvent = false;
          return;
        }

        if (!this.isConnected) {
          // We can't fire events from an element that is not connected
          // Make sure we fetch the config as soon as the user goes back to Lovelace
          this._fetchConfigOnConnect = true;
          return;
        }

        Object(_util_toast__WEBPACK_IMPORTED_MODULE_7__["showToast"])(this, {
          message: this.hass.localize("ui.panel.lovelace.changed_toast.message"),
          action: {
            action: () => this._fetchConfig(false),
            text: this.hass.localize("ui.panel.lovelace.changed_toast.refresh")
          },
          duration: 0,
          dismissable: false
        });
      }
    }, {
      kind: "get",
      key: "urlPath",
      value: function urlPath() {
        return this.panel.url_path === "lovelace" ? null : this.panel.url_path;
      }
    }, {
      kind: "method",
      key: "_forceFetchConfig",
      value: function _forceFetchConfig() {
        this._fetchConfig(true);
      }
    }, {
      kind: "method",
      key: "_fetchConfig",
      value: async function _fetchConfig(forceDiskRefresh) {
        let conf;
        let confMode = this.panel.config.mode;
        let confProm;
        const llWindow = window; // On first load, we speed up loading page by having LL promise ready

        if (llWindow.llConfProm) {
          confProm = llWindow.llConfProm;
          llWindow.llConfProm = undefined;
        }

        if (!resourcesLoaded) {
          resourcesLoaded = true;
          (llWindow.llConfProm || Object(_data_lovelace__WEBPACK_IMPORTED_MODULE_4__["fetchResources"])(this.hass.connection)).then(resources => Object(_common_load_resources__WEBPACK_IMPORTED_MODULE_9__["loadLovelaceResources"])(resources, this.hass.auth.data.hassUrl));
        }

        if (this.urlPath !== null || !confProm) {
          // Refreshing a YAML config can trigger an update event. We will ignore
          // all update events while fetching the config and for 2 seconds after the config is back.
          // We ignore because we already have the latest config.
          if (this.lovelace && this.lovelace.mode === "yaml") {
            this._ignoreNextUpdateEvent = true;
          }

          confProm = Object(_data_lovelace__WEBPACK_IMPORTED_MODULE_4__["fetchConfig"])(this.hass.connection, this.urlPath, forceDiskRefresh);
        }

        try {
          conf = await confProm;
        } catch (err) {
          if (err.code !== "config_not_found") {
            // eslint-disable-next-line
            console.log(err);
            this._state = "error";
            this._errorMsg = err.message;
            return;
          }

          conf = await Object(_common_generate_lovelace_config__WEBPACK_IMPORTED_MODULE_8__["generateLovelaceConfigFromHass"])(this.hass);
          confMode = "generated";
        } finally {
          // Ignore updates for another 2 seconds.
          if (this.lovelace && this.lovelace.mode === "yaml") {
            setTimeout(() => {
              this._ignoreNextUpdateEvent = false;
            }, 2000);
          }
        }

        this._state = "loaded";

        this._setLovelaceConfig(conf, confMode);
      }
    }, {
      kind: "method",
      key: "_checkLovelaceConfig",
      value: function _checkLovelaceConfig(config) {
        // Somehow there can be badges with value null, we remove those
        let checkedConfig = !Object.isFrozen(config) ? config : undefined;
        config.views.forEach((view, index) => {
          if (view.badges && !view.badges.every(Boolean)) {
            checkedConfig = checkedConfig || Object.assign({}, config, {
              views: [...config.views]
            });
            checkedConfig.views[index] = Object.assign({}, view);
            checkedConfig.views[index].badges = view.badges.filter(Boolean);
          }
        });
        return checkedConfig ? deep_freeze__WEBPACK_IMPORTED_MODULE_1___default()(checkedConfig) : config;
      }
    }, {
      kind: "method",
      key: "_setLovelaceConfig",
      value: function _setLovelaceConfig(config, mode) {
        config = this._checkLovelaceConfig(config);
        const urlPath = this.urlPath;
        this.lovelace = {
          config,
          mode,
          editMode: this.lovelace ? this.lovelace.editMode : false,
          language: this.hass.language,
          enableFullEditMode: () => {
            if (!editorLoaded) {
              editorLoaded = true;
              Promise.all(/*! import() | lovelace-yaml-editor */[__webpack_require__.e("vendors~hui-alarm-panel-card-editor~hui-button-card-editor~hui-conditional-card-editor~hui-entities-~37aad430"), __webpack_require__.e(17), __webpack_require__.e(18), __webpack_require__.e("lovelace-yaml-editor")]).then(__webpack_require__.bind(null, /*! ./hui-editor */ "./src/panels/lovelace/hui-editor.ts"));
            }

            this._state = "yaml-editor";
          },
          setEditMode: editMode => {
            if (!editMode || this.lovelace.mode !== "generated") {
              this._updateLovelace({
                editMode
              });

              return;
            }

            Object(_editor_show_save_config_dialog__WEBPACK_IMPORTED_MODULE_10__["showSaveDialog"])(this, {
              lovelace: this.lovelace,
              mode: this.panel.config.mode
            });
          },
          saveConfig: async newConfig => {
            const {
              config: previousConfig,
              mode: previousMode
            } = this.lovelace;
            newConfig = this._checkLovelaceConfig(newConfig);

            try {
              // Optimistic update
              this._updateLovelace({
                config: newConfig,
                mode: "storage"
              });

              this._ignoreNextUpdateEvent = true;
              await Object(_data_lovelace__WEBPACK_IMPORTED_MODULE_4__["saveConfig"])(this.hass, urlPath, newConfig);
            } catch (err) {
              // eslint-disable-next-line
              console.error(err); // Rollback the optimistic update

              this._updateLovelace({
                config: previousConfig,
                mode: previousMode
              });

              throw err;
            }
          },
          deleteConfig: async () => {
            const {
              config: previousConfig,
              mode: previousMode
            } = this.lovelace;

            try {
              // Optimistic update
              this._updateLovelace({
                config: await Object(_common_generate_lovelace_config__WEBPACK_IMPORTED_MODULE_8__["generateLovelaceConfigFromHass"])(this.hass),
                mode: "generated",
                editMode: false
              });

              this._ignoreNextUpdateEvent = true;
              await Object(_data_lovelace__WEBPACK_IMPORTED_MODULE_4__["deleteConfig"])(this.hass, urlPath);
            } catch (err) {
              // eslint-disable-next-line
              console.error(err); // Rollback the optimistic update

              this._updateLovelace({
                config: previousConfig,
                mode: previousMode
              });

              throw err;
            }
          }
        };
      }
    }, {
      kind: "method",
      key: "_updateLovelace",
      value: function _updateLovelace(props) {
        this.lovelace = Object.assign({}, this.lovelace, {}, props);
      }
    }]
  };
}, lit_element__WEBPACK_IMPORTED_MODULE_2__["LitElement"]);

customElements.define("ha-panel-lovelace", LovelacePanel);

/***/ }),

/***/ "./src/panels/lovelace/hui-root.ts":
/*!*****************************************!*\
  !*** ./src/panels/lovelace/hui-root.ts ***!
  \*****************************************/
/*! no exports provided */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _material_mwc_button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @material/mwc-button */ "./node_modules/@material/mwc-button/mwc-button.js");
/* harmony import */ var _polymer_app_layout_app_header_layout_app_header_layout__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @polymer/app-layout/app-header-layout/app-header-layout */ "./node_modules/@polymer/app-layout/app-header-layout/app-header-layout.js");
/* harmony import */ var _polymer_app_layout_app_header_app_header__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @polymer/app-layout/app-header/app-header */ "./node_modules/@polymer/app-layout/app-header/app-header.js");
/* harmony import */ var _polymer_app_layout_app_scroll_effects_effects_waterfall__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @polymer/app-layout/app-scroll-effects/effects/waterfall */ "./node_modules/@polymer/app-layout/app-scroll-effects/effects/waterfall.js");
/* harmony import */ var _polymer_app_layout_app_toolbar_app_toolbar__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @polymer/app-layout/app-toolbar/app-toolbar */ "./node_modules/@polymer/app-layout/app-toolbar/app-toolbar.js");
/* harmony import */ var _polymer_paper_icon_button_paper_icon_button__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @polymer/paper-icon-button/paper-icon-button */ "./node_modules/@polymer/paper-icon-button/paper-icon-button.js");
/* harmony import */ var _polymer_paper_item_paper_item__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @polymer/paper-item/paper-item */ "./node_modules/@polymer/paper-item/paper-item.js");
/* harmony import */ var _polymer_paper_listbox_paper_listbox__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @polymer/paper-listbox/paper-listbox */ "./node_modules/@polymer/paper-listbox/paper-listbox.js");
/* harmony import */ var _polymer_paper_menu_button_paper_menu_button__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @polymer/paper-menu-button/paper-menu-button */ "./node_modules/@polymer/paper-menu-button/paper-menu-button.js");
/* harmony import */ var _polymer_paper_tabs_paper_tab__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @polymer/paper-tabs/paper-tab */ "./node_modules/@polymer/paper-tabs/paper-tab.js");
/* harmony import */ var _polymer_paper_tabs_paper_tabs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @polymer/paper-tabs/paper-tabs */ "./node_modules/@polymer/paper-tabs/paper-tabs.js");
/* harmony import */ var lit_element__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! lit-element */ "./node_modules/lit-element/lit-element.js");
/* harmony import */ var lit_html_directives_class_map__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! lit-html/directives/class-map */ "./node_modules/lit-html/directives/class-map.js");
/* harmony import */ var memoize_one__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! memoize-one */ "./node_modules/memoize-one/dist/memoize-one.esm.js");
/* harmony import */ var _common_config_is_component_loaded__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../common/config/is_component_loaded */ "./src/common/config/is_component_loaded.ts");
/* harmony import */ var _common_dom_fire_event__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../common/dom/fire_event */ "./src/common/dom/fire_event.ts");
/* harmony import */ var _common_dom_scroll_to_target__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../common/dom/scroll-to-target */ "./src/common/dom/scroll-to-target.ts");
/* harmony import */ var _common_navigate__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../common/navigate */ "./src/common/navigate.ts");
/* harmony import */ var _common_util_compute_rtl__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../../common/util/compute_rtl */ "./src/common/util/compute_rtl.ts");
/* harmony import */ var _common_util_debounce__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../../common/util/debounce */ "./src/common/util/debounce.ts");
/* harmony import */ var _common_util_render_status__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../../common/util/render-status */ "./src/common/util/render-status.ts");
/* harmony import */ var _components_ha_icon__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../../components/ha-icon */ "./src/components/ha-icon.ts");
/* harmony import */ var _components_ha_menu_button__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ../../components/ha-menu-button */ "./src/components/ha-menu-button.ts");
/* harmony import */ var _components_ha_paper_icon_button_arrow_next__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ../../components/ha-paper-icon-button-arrow-next */ "./src/components/ha-paper-icon-button-arrow-next.ts");
/* harmony import */ var _components_ha_paper_icon_button_arrow_prev__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ../../components/ha-paper-icon-button-arrow-prev */ "./src/components/ha-paper-icon-button-arrow-prev.ts");
/* harmony import */ var _dialogs_generic_show_dialog_box__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ../../dialogs/generic/show-dialog-box */ "./src/dialogs/generic/show-dialog-box.ts");
/* harmony import */ var _dialogs_voice_command_dialog_show_ha_voice_command_dialog__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ../../dialogs/voice-command-dialog/show-ha-voice-command-dialog */ "./src/dialogs/voice-command-dialog/show-ha-voice-command-dialog.ts");
/* harmony import */ var _layouts_ha_app_layout__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! ../../layouts/ha-app-layout */ "./src/layouts/ha-app-layout.js");
/* harmony import */ var _resources_styles__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ../../resources/styles */ "./src/resources/styles.ts");
/* harmony import */ var _editor_config_util__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! ./editor/config-util */ "./src/panels/lovelace/editor/config-util.ts");
/* harmony import */ var _editor_lovelace_editor_show_edit_lovelace_dialog__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! ./editor/lovelace-editor/show-edit-lovelace-dialog */ "./src/panels/lovelace/editor/lovelace-editor/show-edit-lovelace-dialog.ts");
/* harmony import */ var _editor_view_editor_show_edit_view_dialog__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! ./editor/view-editor/show-edit-view-dialog */ "./src/panels/lovelace/editor/view-editor/show-edit-view-dialog.ts");
/* harmony import */ var _views_hui_panel_view__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! ./views/hui-panel-view */ "./src/panels/lovelace/views/hui-panel-view.ts");
/* harmony import */ var _views_hui_view__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! ./views/hui-view */ "./src/panels/lovelace/views/hui-view.ts");
function _decorate(decorators, factory, superClass, mixins) { var api = _getDecoratorsApi(); if (mixins) { for (var i = 0; i < mixins.length; i++) { api = mixins[i](api); } } var r = factory(function initialize(O) { api.initializeInstanceElements(O, decorated.elements); }, superClass); var decorated = api.decorateClass(_coalesceClassElements(r.d.map(_createElementDescriptor)), decorators); api.initializeClassElements(r.F, decorated.elements); return api.runClassFinishers(r.F, decorated.finishers); }

function _getDecoratorsApi() { _getDecoratorsApi = function () { return api; }; var api = { elementsDefinitionOrder: [["method"], ["field"]], initializeInstanceElements: function (O, elements) { ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { if (element.kind === kind && element.placement === "own") { this.defineClassElement(O, element); } }, this); }, this); }, initializeClassElements: function (F, elements) { var proto = F.prototype; ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { var placement = element.placement; if (element.kind === kind && (placement === "static" || placement === "prototype")) { var receiver = placement === "static" ? F : proto; this.defineClassElement(receiver, element); } }, this); }, this); }, defineClassElement: function (receiver, element) { var descriptor = element.descriptor; if (element.kind === "field") { var initializer = element.initializer; descriptor = { enumerable: descriptor.enumerable, writable: descriptor.writable, configurable: descriptor.configurable, value: initializer === void 0 ? void 0 : initializer.call(receiver) }; } Object.defineProperty(receiver, element.key, descriptor); }, decorateClass: function (elements, decorators) { var newElements = []; var finishers = []; var placements = { static: [], prototype: [], own: [] }; elements.forEach(function (element) { this.addElementPlacement(element, placements); }, this); elements.forEach(function (element) { if (!_hasDecorators(element)) return newElements.push(element); var elementFinishersExtras = this.decorateElement(element, placements); newElements.push(elementFinishersExtras.element); newElements.push.apply(newElements, elementFinishersExtras.extras); finishers.push.apply(finishers, elementFinishersExtras.finishers); }, this); if (!decorators) { return { elements: newElements, finishers: finishers }; } var result = this.decorateConstructor(newElements, decorators); finishers.push.apply(finishers, result.finishers); result.finishers = finishers; return result; }, addElementPlacement: function (element, placements, silent) { var keys = placements[element.placement]; if (!silent && keys.indexOf(element.key) !== -1) { throw new TypeError("Duplicated element (" + element.key + ")"); } keys.push(element.key); }, decorateElement: function (element, placements) { var extras = []; var finishers = []; for (var decorators = element.decorators, i = decorators.length - 1; i >= 0; i--) { var keys = placements[element.placement]; keys.splice(keys.indexOf(element.key), 1); var elementObject = this.fromElementDescriptor(element); var elementFinisherExtras = this.toElementFinisherExtras((0, decorators[i])(elementObject) || elementObject); element = elementFinisherExtras.element; this.addElementPlacement(element, placements); if (elementFinisherExtras.finisher) { finishers.push(elementFinisherExtras.finisher); } var newExtras = elementFinisherExtras.extras; if (newExtras) { for (var j = 0; j < newExtras.length; j++) { this.addElementPlacement(newExtras[j], placements); } extras.push.apply(extras, newExtras); } } return { element: element, finishers: finishers, extras: extras }; }, decorateConstructor: function (elements, decorators) { var finishers = []; for (var i = decorators.length - 1; i >= 0; i--) { var obj = this.fromClassDescriptor(elements); var elementsAndFinisher = this.toClassDescriptor((0, decorators[i])(obj) || obj); if (elementsAndFinisher.finisher !== undefined) { finishers.push(elementsAndFinisher.finisher); } if (elementsAndFinisher.elements !== undefined) { elements = elementsAndFinisher.elements; for (var j = 0; j < elements.length - 1; j++) { for (var k = j + 1; k < elements.length; k++) { if (elements[j].key === elements[k].key && elements[j].placement === elements[k].placement) { throw new TypeError("Duplicated element (" + elements[j].key + ")"); } } } } } return { elements: elements, finishers: finishers }; }, fromElementDescriptor: function (element) { var obj = { kind: element.kind, key: element.key, placement: element.placement, descriptor: element.descriptor }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); if (element.kind === "field") obj.initializer = element.initializer; return obj; }, toElementDescriptors: function (elementObjects) { if (elementObjects === undefined) return; return _toArray(elementObjects).map(function (elementObject) { var element = this.toElementDescriptor(elementObject); this.disallowProperty(elementObject, "finisher", "An element descriptor"); this.disallowProperty(elementObject, "extras", "An element descriptor"); return element; }, this); }, toElementDescriptor: function (elementObject) { var kind = String(elementObject.kind); if (kind !== "method" && kind !== "field") { throw new TypeError('An element descriptor\'s .kind property must be either "method" or' + ' "field", but a decorator created an element descriptor with' + ' .kind "' + kind + '"'); } var key = _toPropertyKey(elementObject.key); var placement = String(elementObject.placement); if (placement !== "static" && placement !== "prototype" && placement !== "own") { throw new TypeError('An element descriptor\'s .placement property must be one of "static",' + ' "prototype" or "own", but a decorator created an element descriptor' + ' with .placement "' + placement + '"'); } var descriptor = elementObject.descriptor; this.disallowProperty(elementObject, "elements", "An element descriptor"); var element = { kind: kind, key: key, placement: placement, descriptor: Object.assign({}, descriptor) }; if (kind !== "field") { this.disallowProperty(elementObject, "initializer", "A method descriptor"); } else { this.disallowProperty(descriptor, "get", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "set", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "value", "The property descriptor of a field descriptor"); element.initializer = elementObject.initializer; } return element; }, toElementFinisherExtras: function (elementObject) { var element = this.toElementDescriptor(elementObject); var finisher = _optionalCallableProperty(elementObject, "finisher"); var extras = this.toElementDescriptors(elementObject.extras); return { element: element, finisher: finisher, extras: extras }; }, fromClassDescriptor: function (elements) { var obj = { kind: "class", elements: elements.map(this.fromElementDescriptor, this) }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); return obj; }, toClassDescriptor: function (obj) { var kind = String(obj.kind); if (kind !== "class") { throw new TypeError('A class descriptor\'s .kind property must be "class", but a decorator' + ' created a class descriptor with .kind "' + kind + '"'); } this.disallowProperty(obj, "key", "A class descriptor"); this.disallowProperty(obj, "placement", "A class descriptor"); this.disallowProperty(obj, "descriptor", "A class descriptor"); this.disallowProperty(obj, "initializer", "A class descriptor"); this.disallowProperty(obj, "extras", "A class descriptor"); var finisher = _optionalCallableProperty(obj, "finisher"); var elements = this.toElementDescriptors(obj.elements); return { elements: elements, finisher: finisher }; }, runClassFinishers: function (constructor, finishers) { for (var i = 0; i < finishers.length; i++) { var newConstructor = (0, finishers[i])(constructor); if (newConstructor !== undefined) { if (typeof newConstructor !== "function") { throw new TypeError("Finishers must return a constructor."); } constructor = newConstructor; } } return constructor; }, disallowProperty: function (obj, name, objectType) { if (obj[name] !== undefined) { throw new TypeError(objectType + " can't have a ." + name + " property."); } } }; return api; }

function _createElementDescriptor(def) { var key = _toPropertyKey(def.key); var descriptor; if (def.kind === "method") { descriptor = { value: def.value, writable: true, configurable: true, enumerable: false }; } else if (def.kind === "get") { descriptor = { get: def.value, configurable: true, enumerable: false }; } else if (def.kind === "set") { descriptor = { set: def.value, configurable: true, enumerable: false }; } else if (def.kind === "field") { descriptor = { configurable: true, writable: true, enumerable: true }; } var element = { kind: def.kind === "field" ? "field" : "method", key: key, placement: def.static ? "static" : def.kind === "field" ? "own" : "prototype", descriptor: descriptor }; if (def.decorators) element.decorators = def.decorators; if (def.kind === "field") element.initializer = def.value; return element; }

function _coalesceGetterSetter(element, other) { if (element.descriptor.get !== undefined) { other.descriptor.get = element.descriptor.get; } else { other.descriptor.set = element.descriptor.set; } }

function _coalesceClassElements(elements) { var newElements = []; var isSameElement = function (other) { return other.kind === "method" && other.key === element.key && other.placement === element.placement; }; for (var i = 0; i < elements.length; i++) { var element = elements[i]; var other; if (element.kind === "method" && (other = newElements.find(isSameElement))) { if (_isDataDescriptor(element.descriptor) || _isDataDescriptor(other.descriptor)) { if (_hasDecorators(element) || _hasDecorators(other)) { throw new ReferenceError("Duplicated methods (" + element.key + ") can't be decorated."); } other.descriptor = element.descriptor; } else { if (_hasDecorators(element)) { if (_hasDecorators(other)) { throw new ReferenceError("Decorators can't be placed on different accessors with for " + "the same property (" + element.key + ")."); } other.decorators = element.decorators; } _coalesceGetterSetter(element, other); } } else { newElements.push(element); } } return newElements; }

function _hasDecorators(element) { return element.decorators && element.decorators.length; }

function _isDataDescriptor(desc) { return desc !== undefined && !(desc.value === undefined && desc.writable === undefined); }

function _optionalCallableProperty(obj, name) { var value = obj[name]; if (value !== undefined && typeof value !== "function") { throw new TypeError("Expected '" + name + "' to be a function"); } return value; }

function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }

function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }

function _toArray(arr) { return _arrayWithHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(n); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get; } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return _get(target, property, receiver || target); }

function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }




































let HUIRoot = _decorate(null, function (_initialize, _LitElement) {
  class HUIRoot extends _LitElement {
    constructor() {
      super(); // The view can trigger a re-render when it knows that certain
      // web components have been loaded.

      _initialize(this);

      this._debouncedConfigChanged = Object(_common_util_debounce__WEBPACK_IMPORTED_MODULE_19__["debounce"])(() => this._selectView(this._curView, true), 100, false);
    }

  }

  return {
    F: HUIRoot,
    d: [{
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_11__["property"])()],
      key: "hass",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_11__["property"])()],
      key: "lovelace",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_11__["property"])()],
      key: "columns",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_11__["property"])()],
      key: "narrow",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_11__["property"])()],
      key: "route",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_11__["property"])()],
      key: "_curView",
      value: void 0
    }, {
      kind: "field",
      key: "_viewCache",
      value: void 0
    }, {
      kind: "field",
      key: "_debouncedConfigChanged",
      value: void 0
    }, {
      kind: "field",
      key: "_conversation",

      value() {
        return Object(memoize_one__WEBPACK_IMPORTED_MODULE_13__["default"])(_components => Object(_common_config_is_component_loaded__WEBPACK_IMPORTED_MODULE_14__["isComponentLoaded"])(this.hass, "conversation"));
      }

    }, {
      kind: "method",
      key: "render",
      value: function render() {
        var _ref, _this$hass$panels$lov;

        return lit_element__WEBPACK_IMPORTED_MODULE_11__["html"]`
      <ha-app-layout id="layout">
        <app-header
          slot="header"
          effects="waterfall"
          class=${Object(lit_html_directives_class_map__WEBPACK_IMPORTED_MODULE_12__["classMap"])({
          "edit-mode": this._editMode
        })}
          fixed
          condenses
        >
          ${this._editMode ? lit_element__WEBPACK_IMPORTED_MODULE_11__["html"]`
                <app-toolbar class="edit-mode">
                  <paper-icon-button
                    aria-label="${this.hass.localize("ui.panel.lovelace.menu.exit_edit_mode")}"
                    title="${this.hass.localize("ui.panel.lovelace.menu.close")}"
                    icon="hass:close"
                    @click="${this._editModeDisable}"
                  ></paper-icon-button>
                  <div main-title>
                    ${this.config.title || this.hass.localize("ui.panel.lovelace.editor.header")}
                    <paper-icon-button
                      aria-label="${this.hass.localize("ui.panel.lovelace.editor.edit_lovelace.edit_title")}"
                      title="${this.hass.localize("ui.panel.lovelace.editor.edit_lovelace.edit_title")}"
                      icon="hass:pencil"
                      class="edit-icon"
                      @click="${this._editLovelace}"
                    ></paper-icon-button>
                  </div>
                  <paper-icon-button
                    icon="hass:help-circle"
                    title="${this.hass.localize("ui.panel.lovelace.menu.help")}"
                    @click="${this._handleHelp}"
                  ></paper-icon-button>
                  <paper-menu-button
                    no-animations
                    horizontal-align="right"
                    horizontal-offset="-5"
                  >
                    <paper-icon-button
                      aria-label=${this.hass.localize("ui.panel.lovelace.editor.menu.open")}
                      title="${this.hass.localize("ui.panel.lovelace.editor.menu.open")}"
                      icon="hass:dots-vertical"
                      slot="dropdown-trigger"
                    ></paper-icon-button>
                    <paper-listbox
                      @iron-select="${this._deselect}"
                      slot="dropdown-content"
                    >
                      ${ false
        /* No unused entities available in the demo */
        ? undefined : lit_element__WEBPACK_IMPORTED_MODULE_11__["html"]`
                            <paper-item
                              aria-label=${this.hass.localize("ui.panel.lovelace.unused_entities.title")}
                              @tap="${this._handleUnusedEntities}"
                            >
                              ${this.hass.localize("ui.panel.lovelace.unused_entities.title")}
                            </paper-item>
                          `}
                      <paper-item @tap="${this.lovelace.enableFullEditMode}">
                        ${this.hass.localize("ui.panel.lovelace.editor.menu.raw_editor")}
                      </paper-item>
                    </paper-listbox>
                  </paper-menu-button>
                </app-toolbar>
              ` : lit_element__WEBPACK_IMPORTED_MODULE_11__["html"]`
                <app-toolbar>
                  <ha-menu-button
                    .hass=${this.hass}
                    .narrow=${this.narrow}
                  ></ha-menu-button>
                  <div main-title>${this.config.title || "Home Assistant"}</div>
                  ${this._conversation(this.hass.config.components) ? lit_element__WEBPACK_IMPORTED_MODULE_11__["html"]`
                        <paper-icon-button
                          aria-label="Start conversation"
                          icon="hass:microphone"
                          @click=${this._showVoiceCommandDialog}
                        ></paper-icon-button>
                      ` : ""}
                  <paper-menu-button
                    no-animations
                    horizontal-align="right"
                    horizontal-offset="-5"
                  >
                    <paper-icon-button
                      aria-label=${this.hass.localize("ui.panel.lovelace.editor.menu.open")}
                      title="${this.hass.localize("ui.panel.lovelace.editor.menu.open")}"
                      icon="hass:dots-vertical"
                      slot="dropdown-trigger"
                    ></paper-icon-button>
                    <paper-listbox
                      @iron-select="${this._deselect}"
                      slot="dropdown-content"
                    >
                      ${this._yamlMode ? lit_element__WEBPACK_IMPORTED_MODULE_11__["html"]`
                            <paper-item
                              aria-label=${this.hass.localize("ui.panel.lovelace.menu.refresh")}
                              @tap="${this._handleRefresh}"
                            >
                              ${this.hass.localize("ui.panel.lovelace.menu.refresh")}
                            </paper-item>
                            <paper-item
                              aria-label=${this.hass.localize("ui.panel.lovelace.unused_entities.title")}
                              @tap="${this._handleUnusedEntities}"
                            >
                              ${this.hass.localize("ui.panel.lovelace.unused_entities.title")}
                            </paper-item>
                          ` : ""}
                      ${((_ref = (_this$hass$panels$lov = this.hass.panels.lovelace) === null || _this$hass$panels$lov === void 0 ? void 0 : _this$hass$panels$lov.config) === null || _ref === void 0 ? void 0 : _ref.mode) === "yaml" ? lit_element__WEBPACK_IMPORTED_MODULE_11__["html"]`
                            <paper-item
                              aria-label=${this.hass.localize("ui.panel.lovelace.menu.reload_resources")}
                              @tap="${this._handleReloadResources}"
                            >
                              ${this.hass.localize("ui.panel.lovelace.menu.reload_resources")}
                            </paper-item>
                          ` : ""}
                      ${this.hass.user.is_admin && !this.hass.config.safe_mode ? lit_element__WEBPACK_IMPORTED_MODULE_11__["html"]`
                            <paper-item
                              aria-label=${this.hass.localize("ui.panel.lovelace.menu.configure_ui")}
                              @tap="${this._editModeEnable}"
                            >
                              ${this.hass.localize("ui.panel.lovelace.menu.configure_ui")}
                            </paper-item>
                          ` : ""}
                      <paper-item
                        aria-label=${this.hass.localize("ui.panel.lovelace.menu.help")}
                        @tap="${this._handleHelp}"
                      >
                        ${this.hass.localize("ui.panel.lovelace.menu.help")}
                      </paper-item>
                    </paper-listbox>
                  </paper-menu-button>
                </app-toolbar>
              `}
          ${this.lovelace.config.views.length > 1 || this._editMode ? lit_element__WEBPACK_IMPORTED_MODULE_11__["html"]`
                <div sticky>
                  <paper-tabs
                    scrollable
                    .selected="${this._curView}"
                    @iron-activate="${this._handleViewSelected}"
                    dir="${Object(_common_util_compute_rtl__WEBPACK_IMPORTED_MODULE_18__["computeRTLDirection"])(this.hass)}"
                  >
                    ${this.lovelace.config.views.map(view => lit_element__WEBPACK_IMPORTED_MODULE_11__["html"]`
                        <paper-tab
                          aria-label="${view.title}"
                          class="${Object(lit_html_directives_class_map__WEBPACK_IMPORTED_MODULE_12__["classMap"])({
          "hide-tab": Boolean(!this._editMode && view.visible !== undefined && (Array.isArray(view.visible) && !view.visible.some(e => e.user === this.hass.user.id) || view.visible === false))
        })}"
                        >
                          ${this._editMode ? lit_element__WEBPACK_IMPORTED_MODULE_11__["html"]`
                                <ha-paper-icon-button-arrow-prev
                                  title="${this.hass.localize("ui.panel.lovelace.editor.edit_view.move_left")}"
                                  class="edit-icon view"
                                  @click="${this._moveViewLeft}"
                                  ?disabled="${this._curView === 0}"
                                ></ha-paper-icon-button-arrow-prev>
                              ` : ""}
                          ${view.icon ? lit_element__WEBPACK_IMPORTED_MODULE_11__["html"]`
                                <ha-icon
                                  title="${view.title}"
                                  .icon="${view.icon}"
                                ></ha-icon>
                              ` : view.title || "Unnamed view"}
                          ${this._editMode ? lit_element__WEBPACK_IMPORTED_MODULE_11__["html"]`
                                <ha-icon
                                  title="${this.hass.localize("ui.panel.lovelace.editor.edit_view.edit")}"
                                  class="edit-icon view"
                                  icon="hass:pencil"
                                  @click="${this._editView}"
                                ></ha-icon>
                                <ha-paper-icon-button-arrow-next
                                  title="${this.hass.localize("ui.panel.lovelace.editor.edit_view.move_right")}"
                                  class="edit-icon view"
                                  @click="${this._moveViewRight}"
                                  ?disabled="${this._curView + 1 === this.lovelace.config.views.length}"
                                ></ha-paper-icon-button-arrow-next>
                              ` : ""}
                        </paper-tab>
                      `)}
                    ${this._editMode ? lit_element__WEBPACK_IMPORTED_MODULE_11__["html"]`
                          <paper-icon-button
                            id="add-view"
                            @click="${this._addView}"
                            title="${this.hass.localize("ui.panel.lovelace.editor.edit_view.add")}"
                            icon="hass:plus"
                          ></paper-icon-button>
                        ` : ""}
                  </paper-tabs>
                </div>
              ` : ""}
        </app-header>
        <div
          id="view"
          class="${Object(lit_html_directives_class_map__WEBPACK_IMPORTED_MODULE_12__["classMap"])({
          "tabs-hidden": !this._editMode && this.lovelace.config.views.length < 2
        })}"
          @ll-rebuild="${this._debouncedConfigChanged}"
        ></div>
      </ha-app-layout>
    `;
      }
    }, {
      kind: "get",
      static: true,
      key: "styles",
      value: function styles() {
        return [_resources_styles__WEBPACK_IMPORTED_MODULE_28__["haStyle"], lit_element__WEBPACK_IMPORTED_MODULE_11__["css"]`
        :host {
          --dark-color: #455a64;
          --text-dark-color: #fff;
          -ms-user-select: none;
          -webkit-user-select: none;
          -moz-user-select: none;
        }

        ha-app-layout {
          min-height: 100%;
        }
        paper-menu-button {
          padding: 0;
        }
        paper-tabs {
          margin-left: 12px;
          --paper-tabs-selection-bar-color: var(--text-primary-color, #fff);
          text-transform: uppercase;
        }
        .edit-mode {
          background-color: var(--dark-color, #455a64);
          color: var(--text-dark-color);
        }
        .edit-mode div[main-title] {
          pointer-events: auto;
        }
        paper-tab.iron-selected .edit-icon {
          display: inline-flex;
        }
        .edit-icon {
          color: var(--accent-color);
          padding-left: 8px;
        }
        .edit-icon[disabled] {
          color: var(--disabled-text-color);
        }
        .edit-icon.view {
          display: none;
        }
        #add-view {
          position: absolute;
          height: 44px;
        }
        #add-view ha-icon {
          background-color: var(--accent-color);
          border-radius: 5px;
          margin-top: 4px;
        }
        app-toolbar a {
          color: var(--text-primary-color, white);
        }
        mwc-button.warning:not([disabled]) {
          color: var(--google-red-500);
        }
        #view {
          min-height: calc(100vh - 112px);
          /**
          * Since we only set min-height, if child nodes need percentage
          * heights they must use absolute positioning so we need relative
          * positioning here.
          *
          * https://www.w3.org/TR/CSS2/visudet.html#the-height-property
          */
          position: relative;
          display: flex;
        }
        #view > * {
          /**
          * The view could get larger than the window in Firefox
          * to prevent that we set the max-width to 100%
          * flex-grow: 1 and flex-basis: 100% should make sure the view
          * stays full width.
          *
          * https://github.com/home-assistant/home-assistant-polymer/pull/3806
          */
          flex: 1 1 100%;
          max-width: 100%;
        }
        #view.tabs-hidden {
          min-height: calc(100vh - 64px);
        }
        paper-item {
          cursor: pointer;
        }
        .hide-tab {
          display: none;
        }
      `];
      }
    }, {
      kind: "method",
      key: "updated",
      value: function updated(changedProperties) {
        _get(_getPrototypeOf(HUIRoot.prototype), "updated", this).call(this, changedProperties);

        const view = this._viewRoot;
        const huiView = view.lastChild;

        if (changedProperties.has("columns") && huiView && huiView instanceof _views_hui_view__WEBPACK_IMPORTED_MODULE_33__["HUIView"]) {
          huiView.columns = this.columns;
        }

        if (changedProperties.has("hass") && huiView) {
          huiView.hass = this.hass;
        }

        let newSelectView;
        let force = false;
        const viewPath = this.route.path.split("/")[1];

        if (changedProperties.has("route")) {
          const views = this.config.views;

          if (!viewPath && views.length) {
            Object(_common_navigate__WEBPACK_IMPORTED_MODULE_17__["navigate"])(this, `${this.route.prefix}/${views[0].path || 0}`, true);
            newSelectView = 0;
          } else if (viewPath === "hass-unused-entities") {
            newSelectView = "hass-unused-entities";
          } else if (viewPath) {
            const selectedView = viewPath;
            const selectedViewInt = Number(selectedView);
            let index = 0;

            for (let i = 0; i < views.length; i++) {
              if (views[i].path === selectedView || i === selectedViewInt) {
                index = i;
                break;
              }
            }

            newSelectView = index;
          }
        }

        if (changedProperties.has("lovelace")) {
          const oldLovelace = changedProperties.get("lovelace");

          if (!oldLovelace || oldLovelace.config !== this.lovelace.config) {
            // On config change, recreate the current view from scratch.
            force = true;
          }

          if (!oldLovelace || oldLovelace.editMode !== this.lovelace.editMode) {
            // Leave unused entities when leaving edit mode
            if (this.lovelace.mode === "storage" && viewPath === "hass-unused-entities") {
              var _this$route, _views$;

              const views = this.config && this.config.views;
              Object(_common_navigate__WEBPACK_IMPORTED_MODULE_17__["navigate"])(this, `${(_this$route = this.route) === null || _this$route === void 0 ? void 0 : _this$route.prefix}/${((_views$ = views[0]) === null || _views$ === void 0 ? void 0 : _views$.path) || 0}`);
              newSelectView = 0;
            } // On edit mode change, recreate the current view from scratch


            force = true;
          }
        }

        if (newSelectView !== undefined || force) {
          if (force && newSelectView === undefined) {
            newSelectView = this._curView;
          } // Will allow for ripples to start rendering


          Object(_common_util_render_status__WEBPACK_IMPORTED_MODULE_20__["afterNextRender"])(() => this._selectView(newSelectView, force));
        }
      }
    }, {
      kind: "get",
      key: "config",
      value: function config() {
        return this.lovelace.config;
      }
    }, {
      kind: "get",
      key: "_yamlMode",
      value: function _yamlMode() {
        return this.lovelace.mode === "yaml";
      }
    }, {
      kind: "get",
      key: "_editMode",
      value: function _editMode() {
        return this.lovelace.editMode;
      }
    }, {
      kind: "get",
      key: "_layout",
      value: function _layout() {
        return this.shadowRoot.getElementById("layout");
      }
    }, {
      kind: "get",
      key: "_viewRoot",
      value: function _viewRoot() {
        return this.shadowRoot.getElementById("view");
      }
    }, {
      kind: "method",
      key: "_handleRefresh",
      value: function _handleRefresh() {
        Object(_common_dom_fire_event__WEBPACK_IMPORTED_MODULE_15__["fireEvent"])(this, "config-refresh");
      }
    }, {
      kind: "method",
      key: "_handleReloadResources",
      value: function _handleReloadResources() {
        this.hass.callService("lovelace", "reload_resources");
        Object(_dialogs_generic_show_dialog_box__WEBPACK_IMPORTED_MODULE_25__["showConfirmationDialog"])(this, {
          title: this.hass.localize("ui.panel.lovelace.reload_resources.refresh_header"),
          text: this.hass.localize("ui.panel.lovelace.reload_resources.refresh_body"),
          confirm: () => location.reload()
        });
      }
    }, {
      kind: "method",
      key: "_handleUnusedEntities",
      value: function _handleUnusedEntities() {
        var _this$route2;

        Object(_common_navigate__WEBPACK_IMPORTED_MODULE_17__["navigate"])(this, `${(_this$route2 = this.route) === null || _this$route2 === void 0 ? void 0 : _this$route2.prefix}/hass-unused-entities`);
      }
    }, {
      kind: "method",
      key: "_deselect",
      value: function _deselect(ev) {
        ev.target.selected = null;
      }
    }, {
      kind: "method",
      key: "_showVoiceCommandDialog",
      value: function _showVoiceCommandDialog() {
        Object(_dialogs_voice_command_dialog_show_ha_voice_command_dialog__WEBPACK_IMPORTED_MODULE_26__["showVoiceCommandDialog"])(this);
      }
    }, {
      kind: "method",
      key: "_handleHelp",
      value: function _handleHelp() {
        window.open("https://www.home-assistant.io/lovelace/", "_blank");
      }
    }, {
      kind: "method",
      key: "_editModeEnable",
      value: function _editModeEnable() {
        if (this._yamlMode) {
          Object(_dialogs_generic_show_dialog_box__WEBPACK_IMPORTED_MODULE_25__["showAlertDialog"])(this, {
            text: "The edit UI is not available when in YAML mode."
          });
          return;
        }

        this.lovelace.setEditMode(true);
      }
    }, {
      kind: "method",
      key: "_editModeDisable",
      value: function _editModeDisable() {
        this.lovelace.setEditMode(false);
      }
    }, {
      kind: "method",
      key: "_editLovelace",
      value: function _editLovelace() {
        Object(_editor_lovelace_editor_show_edit_lovelace_dialog__WEBPACK_IMPORTED_MODULE_30__["showEditLovelaceDialog"])(this, this.lovelace);
      }
    }, {
      kind: "method",
      key: "_editView",
      value: function _editView() {
        Object(_editor_view_editor_show_edit_view_dialog__WEBPACK_IMPORTED_MODULE_31__["showEditViewDialog"])(this, {
          lovelace: this.lovelace,
          viewIndex: this._curView
        });
      }
    }, {
      kind: "method",
      key: "_moveViewLeft",
      value: function _moveViewLeft() {
        const lovelace = this.lovelace;
        const oldIndex = this._curView;
        const newIndex = this._curView - 1;
        this._curView = newIndex;
        lovelace.saveConfig(Object(_editor_config_util__WEBPACK_IMPORTED_MODULE_29__["swapView"])(lovelace.config, oldIndex, newIndex));
      }
    }, {
      kind: "method",
      key: "_moveViewRight",
      value: function _moveViewRight() {
        const lovelace = this.lovelace;
        const oldIndex = this._curView;
        const newIndex = this._curView + 1;
        this._curView = newIndex;
        lovelace.saveConfig(Object(_editor_config_util__WEBPACK_IMPORTED_MODULE_29__["swapView"])(lovelace.config, oldIndex, newIndex));
      }
    }, {
      kind: "method",
      key: "_addView",
      value: function _addView() {
        Object(_editor_view_editor_show_edit_view_dialog__WEBPACK_IMPORTED_MODULE_31__["showEditViewDialog"])(this, {
          lovelace: this.lovelace
        });
      }
    }, {
      kind: "method",
      key: "_handleViewSelected",
      value: function _handleViewSelected(ev) {
        const viewIndex = ev.detail.selected;

        if (viewIndex !== this._curView) {
          var _this$route3;

          const path = this.config.views[viewIndex].path || viewIndex;
          Object(_common_navigate__WEBPACK_IMPORTED_MODULE_17__["navigate"])(this, `${(_this$route3 = this.route) === null || _this$route3 === void 0 ? void 0 : _this$route3.prefix}/${path}`);
        }

        Object(_common_dom_scroll_to_target__WEBPACK_IMPORTED_MODULE_16__["default"])(this, this._layout.header.scrollTarget);
      }
    }, {
      kind: "method",
      key: "_selectView",
      value: function _selectView(viewIndex, force) {
        if (!force && this._curView === viewIndex) {
          return;
        }

        viewIndex = viewIndex === undefined ? 0 : viewIndex;
        this._curView = viewIndex;

        if (force) {
          this._viewCache = {};
        } // Recreate a new element to clear the applied themes.


        const root = this._viewRoot;

        if (root.lastChild) {
          root.removeChild(root.lastChild);
        }

        if (viewIndex === "hass-unused-entities") {
          const unusedEntities = document.createElement("hui-unused-entities"); // Wait for promise to resolve so that the element has been upgraded.

          Promise.all(/*! import() | hui-unused-entities */[__webpack_require__.e("vendors~hui-unused-entities~panel-config-areas~panel-config-automation~panel-config-devices~panel-co~ec251abe"), __webpack_require__.e("vendors~hui-unused-entities~panel-config-areas~panel-config-automation~panel-config-devices~panel-co~c0ce165d"), __webpack_require__.e("vendors~hui-unused-entities~hui-view-editable~panel-config-areas~panel-config-automation~panel-confi~41c12095"), __webpack_require__.e("dialog-config-flow~hui-conditional-card-editor~hui-dialog-edit-card~hui-stack-card-editor~hui-unused~c9cf7b12"), __webpack_require__.e("hui-unused-entities~panel-config-areas~panel-config-automation~panel-config-devices~panel-config-ent~b613bca1"), __webpack_require__.e("hui-unused-entities~hui-view-editable~panel-config-areas~panel-config-automation~panel-config-helper~c9d97d21"), __webpack_require__.e("hui-unused-entities")]).then(__webpack_require__.bind(null, /*! ./editor/unused-entities/hui-unused-entities */ "./src/panels/lovelace/editor/unused-entities/hui-unused-entities.ts")).then(() => {
            unusedEntities.hass = this.hass;
            unusedEntities.lovelace = this.lovelace;
            unusedEntities.narrow = this.narrow;
          });

          if (this.config.background) {
            unusedEntities.style.setProperty("--lovelace-background", this.config.background);
          }

          root.appendChild(unusedEntities);
          return;
        }

        let view;
        const viewConfig = this.config.views[viewIndex];

        if (!viewConfig) {
          this._editModeEnable();

          return;
        }

        if (!force && this._viewCache[viewIndex]) {
          view = this._viewCache[viewIndex];
        } else {
          if (viewConfig.panel && viewConfig.cards && viewConfig.cards.length > 0) {
            view = document.createElement("hui-panel-view");
            view.config = viewConfig;
            view.lovelace = this.lovelace;
            view.index = viewIndex;
          } else {
            view = document.createElement("hui-view");
            view.lovelace = this.lovelace;
            view.columns = this.columns;
            view.index = viewIndex;
          }

          this._viewCache[viewIndex] = view;
        }

        view.hass = this.hass;
        const configBackground = viewConfig.background || this.config.background;

        if (configBackground) {
          view.style.setProperty("--lovelace-background", configBackground);
        }

        root.appendChild(view); // Recalculate to see if we need to adjust content area for tab bar

        Object(_common_dom_fire_event__WEBPACK_IMPORTED_MODULE_15__["fireEvent"])(this, "iron-resize");
      }
    }]
  };
}, lit_element__WEBPACK_IMPORTED_MODULE_11__["LitElement"]);

customElements.define("hui-root", HUIRoot);

/***/ }),

/***/ "./src/panels/lovelace/views/hui-panel-view.ts":
/*!*****************************************************!*\
  !*** ./src/panels/lovelace/views/hui-panel-view.ts ***!
  \*****************************************************/
/*! exports provided: HUIPanelView */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HUIPanelView", function() { return HUIPanelView; });
/* harmony import */ var lit_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lit-element */ "./node_modules/lit-element/lit-element.js");
/* harmony import */ var _common_dom_apply_themes_on_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../common/dom/apply_themes_on_element */ "./src/common/dom/apply_themes_on_element.ts");
/* harmony import */ var _create_element_create_card_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../create-element/create-card-element */ "./src/panels/lovelace/create-element/create-card-element.ts");
function _decorate(decorators, factory, superClass, mixins) { var api = _getDecoratorsApi(); if (mixins) { for (var i = 0; i < mixins.length; i++) { api = mixins[i](api); } } var r = factory(function initialize(O) { api.initializeInstanceElements(O, decorated.elements); }, superClass); var decorated = api.decorateClass(_coalesceClassElements(r.d.map(_createElementDescriptor)), decorators); api.initializeClassElements(r.F, decorated.elements); return api.runClassFinishers(r.F, decorated.finishers); }

function _getDecoratorsApi() { _getDecoratorsApi = function () { return api; }; var api = { elementsDefinitionOrder: [["method"], ["field"]], initializeInstanceElements: function (O, elements) { ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { if (element.kind === kind && element.placement === "own") { this.defineClassElement(O, element); } }, this); }, this); }, initializeClassElements: function (F, elements) { var proto = F.prototype; ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { var placement = element.placement; if (element.kind === kind && (placement === "static" || placement === "prototype")) { var receiver = placement === "static" ? F : proto; this.defineClassElement(receiver, element); } }, this); }, this); }, defineClassElement: function (receiver, element) { var descriptor = element.descriptor; if (element.kind === "field") { var initializer = element.initializer; descriptor = { enumerable: descriptor.enumerable, writable: descriptor.writable, configurable: descriptor.configurable, value: initializer === void 0 ? void 0 : initializer.call(receiver) }; } Object.defineProperty(receiver, element.key, descriptor); }, decorateClass: function (elements, decorators) { var newElements = []; var finishers = []; var placements = { static: [], prototype: [], own: [] }; elements.forEach(function (element) { this.addElementPlacement(element, placements); }, this); elements.forEach(function (element) { if (!_hasDecorators(element)) return newElements.push(element); var elementFinishersExtras = this.decorateElement(element, placements); newElements.push(elementFinishersExtras.element); newElements.push.apply(newElements, elementFinishersExtras.extras); finishers.push.apply(finishers, elementFinishersExtras.finishers); }, this); if (!decorators) { return { elements: newElements, finishers: finishers }; } var result = this.decorateConstructor(newElements, decorators); finishers.push.apply(finishers, result.finishers); result.finishers = finishers; return result; }, addElementPlacement: function (element, placements, silent) { var keys = placements[element.placement]; if (!silent && keys.indexOf(element.key) !== -1) { throw new TypeError("Duplicated element (" + element.key + ")"); } keys.push(element.key); }, decorateElement: function (element, placements) { var extras = []; var finishers = []; for (var decorators = element.decorators, i = decorators.length - 1; i >= 0; i--) { var keys = placements[element.placement]; keys.splice(keys.indexOf(element.key), 1); var elementObject = this.fromElementDescriptor(element); var elementFinisherExtras = this.toElementFinisherExtras((0, decorators[i])(elementObject) || elementObject); element = elementFinisherExtras.element; this.addElementPlacement(element, placements); if (elementFinisherExtras.finisher) { finishers.push(elementFinisherExtras.finisher); } var newExtras = elementFinisherExtras.extras; if (newExtras) { for (var j = 0; j < newExtras.length; j++) { this.addElementPlacement(newExtras[j], placements); } extras.push.apply(extras, newExtras); } } return { element: element, finishers: finishers, extras: extras }; }, decorateConstructor: function (elements, decorators) { var finishers = []; for (var i = decorators.length - 1; i >= 0; i--) { var obj = this.fromClassDescriptor(elements); var elementsAndFinisher = this.toClassDescriptor((0, decorators[i])(obj) || obj); if (elementsAndFinisher.finisher !== undefined) { finishers.push(elementsAndFinisher.finisher); } if (elementsAndFinisher.elements !== undefined) { elements = elementsAndFinisher.elements; for (var j = 0; j < elements.length - 1; j++) { for (var k = j + 1; k < elements.length; k++) { if (elements[j].key === elements[k].key && elements[j].placement === elements[k].placement) { throw new TypeError("Duplicated element (" + elements[j].key + ")"); } } } } } return { elements: elements, finishers: finishers }; }, fromElementDescriptor: function (element) { var obj = { kind: element.kind, key: element.key, placement: element.placement, descriptor: element.descriptor }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); if (element.kind === "field") obj.initializer = element.initializer; return obj; }, toElementDescriptors: function (elementObjects) { if (elementObjects === undefined) return; return _toArray(elementObjects).map(function (elementObject) { var element = this.toElementDescriptor(elementObject); this.disallowProperty(elementObject, "finisher", "An element descriptor"); this.disallowProperty(elementObject, "extras", "An element descriptor"); return element; }, this); }, toElementDescriptor: function (elementObject) { var kind = String(elementObject.kind); if (kind !== "method" && kind !== "field") { throw new TypeError('An element descriptor\'s .kind property must be either "method" or' + ' "field", but a decorator created an element descriptor with' + ' .kind "' + kind + '"'); } var key = _toPropertyKey(elementObject.key); var placement = String(elementObject.placement); if (placement !== "static" && placement !== "prototype" && placement !== "own") { throw new TypeError('An element descriptor\'s .placement property must be one of "static",' + ' "prototype" or "own", but a decorator created an element descriptor' + ' with .placement "' + placement + '"'); } var descriptor = elementObject.descriptor; this.disallowProperty(elementObject, "elements", "An element descriptor"); var element = { kind: kind, key: key, placement: placement, descriptor: Object.assign({}, descriptor) }; if (kind !== "field") { this.disallowProperty(elementObject, "initializer", "A method descriptor"); } else { this.disallowProperty(descriptor, "get", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "set", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "value", "The property descriptor of a field descriptor"); element.initializer = elementObject.initializer; } return element; }, toElementFinisherExtras: function (elementObject) { var element = this.toElementDescriptor(elementObject); var finisher = _optionalCallableProperty(elementObject, "finisher"); var extras = this.toElementDescriptors(elementObject.extras); return { element: element, finisher: finisher, extras: extras }; }, fromClassDescriptor: function (elements) { var obj = { kind: "class", elements: elements.map(this.fromElementDescriptor, this) }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); return obj; }, toClassDescriptor: function (obj) { var kind = String(obj.kind); if (kind !== "class") { throw new TypeError('A class descriptor\'s .kind property must be "class", but a decorator' + ' created a class descriptor with .kind "' + kind + '"'); } this.disallowProperty(obj, "key", "A class descriptor"); this.disallowProperty(obj, "placement", "A class descriptor"); this.disallowProperty(obj, "descriptor", "A class descriptor"); this.disallowProperty(obj, "initializer", "A class descriptor"); this.disallowProperty(obj, "extras", "A class descriptor"); var finisher = _optionalCallableProperty(obj, "finisher"); var elements = this.toElementDescriptors(obj.elements); return { elements: elements, finisher: finisher }; }, runClassFinishers: function (constructor, finishers) { for (var i = 0; i < finishers.length; i++) { var newConstructor = (0, finishers[i])(constructor); if (newConstructor !== undefined) { if (typeof newConstructor !== "function") { throw new TypeError("Finishers must return a constructor."); } constructor = newConstructor; } } return constructor; }, disallowProperty: function (obj, name, objectType) { if (obj[name] !== undefined) { throw new TypeError(objectType + " can't have a ." + name + " property."); } } }; return api; }

function _createElementDescriptor(def) { var key = _toPropertyKey(def.key); var descriptor; if (def.kind === "method") { descriptor = { value: def.value, writable: true, configurable: true, enumerable: false }; } else if (def.kind === "get") { descriptor = { get: def.value, configurable: true, enumerable: false }; } else if (def.kind === "set") { descriptor = { set: def.value, configurable: true, enumerable: false }; } else if (def.kind === "field") { descriptor = { configurable: true, writable: true, enumerable: true }; } var element = { kind: def.kind === "field" ? "field" : "method", key: key, placement: def.static ? "static" : def.kind === "field" ? "own" : "prototype", descriptor: descriptor }; if (def.decorators) element.decorators = def.decorators; if (def.kind === "field") element.initializer = def.value; return element; }

function _coalesceGetterSetter(element, other) { if (element.descriptor.get !== undefined) { other.descriptor.get = element.descriptor.get; } else { other.descriptor.set = element.descriptor.set; } }

function _coalesceClassElements(elements) { var newElements = []; var isSameElement = function (other) { return other.kind === "method" && other.key === element.key && other.placement === element.placement; }; for (var i = 0; i < elements.length; i++) { var element = elements[i]; var other; if (element.kind === "method" && (other = newElements.find(isSameElement))) { if (_isDataDescriptor(element.descriptor) || _isDataDescriptor(other.descriptor)) { if (_hasDecorators(element) || _hasDecorators(other)) { throw new ReferenceError("Duplicated methods (" + element.key + ") can't be decorated."); } other.descriptor = element.descriptor; } else { if (_hasDecorators(element)) { if (_hasDecorators(other)) { throw new ReferenceError("Decorators can't be placed on different accessors with for " + "the same property (" + element.key + ")."); } other.decorators = element.decorators; } _coalesceGetterSetter(element, other); } } else { newElements.push(element); } } return newElements; }

function _hasDecorators(element) { return element.decorators && element.decorators.length; }

function _isDataDescriptor(desc) { return desc !== undefined && !(desc.value === undefined && desc.writable === undefined); }

function _optionalCallableProperty(obj, name) { var value = obj[name]; if (value !== undefined && typeof value !== "function") { throw new TypeError("Expected '" + name + "' to be a function"); } return value; }

function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }

function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }

function _toArray(arr) { return _arrayWithHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(n); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get; } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return _get(target, property, receiver || target); }

function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }




let editCodeLoaded = false;
let HUIPanelView = _decorate([Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["customElement"])("hui-panel-view")], function (_initialize, _UpdatingElement) {
  class HUIPanelView extends _UpdatingElement {
    constructor(...args) {
      super(...args);

      _initialize(this);
    }

  }

  return {
    F: HUIPanelView,
    d: [{
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "hass",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "lovelace",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "config",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])({
        type: Number
      })],
      key: "index",
      value: void 0
    }, {
      kind: "method",
      key: "firstUpdated",
      value: function firstUpdated(changedProperties) {
        _get(_getPrototypeOf(HUIPanelView.prototype), "firstUpdated", this).call(this, changedProperties);

        this.style.setProperty("background", "var(--lovelace-background)");
      }
    }, {
      kind: "method",
      key: "update",
      value: function update(changedProperties) {
        _get(_getPrototypeOf(HUIPanelView.prototype), "update", this).call(this, changedProperties);

        const hass = this.hass;
        const lovelace = this.lovelace;
        const hassChanged = changedProperties.has("hass");
        const oldHass = changedProperties.get("hass");
        const configChanged = changedProperties.has("config");

        if (lovelace.editMode && !editCodeLoaded) {
          editCodeLoaded = true;
          Promise.all(/*! import() | hui-view-editable */[__webpack_require__.e("vendors~hui-unused-entities~hui-view-editable~panel-config-areas~panel-config-automation~panel-confi~41c12095"), __webpack_require__.e("hui-unused-entities~hui-view-editable~panel-config-areas~panel-config-automation~panel-config-helper~c9d97d21"), __webpack_require__.e("hui-view-editable")]).then(__webpack_require__.bind(null, /*! ./hui-view-editable */ "./src/panels/lovelace/views/hui-view-editable.ts"));
        }

        let editModeChanged = false;

        if (changedProperties.has("lovelace")) {
          const oldLovelace = changedProperties.get("lovelace");
          editModeChanged = !oldLovelace || lovelace.editMode !== oldLovelace.editMode;
        }

        if (editModeChanged || configChanged) {
          this._createCard();
        } else if (hassChanged) {
          this.lastChild.hass = this.hass;
        }

        if (configChanged || hassChanged && oldHass && (hass.themes !== oldHass.themes || hass.selectedTheme !== oldHass.selectedTheme)) {
          Object(_common_dom_apply_themes_on_element__WEBPACK_IMPORTED_MODULE_1__["applyThemesOnElement"])(this, hass.themes, this.config.theme);
        }
      }
    }, {
      kind: "method",
      key: "_createCard",
      value: function _createCard() {
        while (this.lastChild) {
          this.removeChild(this.lastChild);
        }

        const card = Object(_create_element_create_card_element__WEBPACK_IMPORTED_MODULE_2__["createCardElement"])(this.config.cards[0]);
        card.hass = this.hass;
        card.isPanel = true;

        if (!this.lovelace.editMode) {
          this.appendChild(card);
          return;
        }

        const wrapper = document.createElement("hui-card-options");
        wrapper.hass = this.hass;
        wrapper.lovelace = this.lovelace;
        wrapper.path = [this.index, 0];
        card.editMode = true;
        wrapper.appendChild(card);
        this.appendChild(wrapper);

        if (this.config.cards.length > 1) {
          const warning = document.createElement("hui-warning");
          warning.setAttribute("style", "position: absolute; top: 0; width: 100%; box-sizing: border-box;");
          warning.innerText = this.hass.localize("ui.panel.lovelace.editor.view.panel_mode.warning_multiple_cards");
          this.appendChild(warning);
        }
      }
    }]
  };
}, lit_element__WEBPACK_IMPORTED_MODULE_0__["UpdatingElement"]);

/***/ }),

/***/ "./src/panels/lovelace/views/hui-view.ts":
/*!***********************************************!*\
  !*** ./src/panels/lovelace/views/hui-view.ts ***!
  \***********************************************/
/*! exports provided: HUIView */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HUIView", function() { return HUIView; });
/* harmony import */ var lit_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lit-element */ "./node_modules/lit-element/lit-element.js");
/* harmony import */ var lit_html_directives_class_map__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lit-html/directives/class-map */ "./node_modules/lit-html/directives/class-map.js");
/* harmony import */ var _common_dom_apply_themes_on_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../common/dom/apply_themes_on_element */ "./src/common/dom/apply_themes_on_element.ts");
/* harmony import */ var _common_util_compute_rtl__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../common/util/compute_rtl */ "./src/common/util/compute_rtl.ts");
/* harmony import */ var _components_entity_ha_state_label_badge__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../components/entity/ha-state-label-badge */ "./src/components/entity/ha-state-label-badge.ts");
/* harmony import */ var _common_compute_card_size__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../common/compute-card-size */ "./src/panels/lovelace/common/compute-card-size.ts");
/* harmony import */ var _common_process_config_entities__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../common/process-config-entities */ "./src/panels/lovelace/common/process-config-entities.ts");
/* harmony import */ var _create_element_create_badge_element__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../create-element/create-badge-element */ "./src/panels/lovelace/create-element/create-badge-element.ts");
/* harmony import */ var _create_element_create_card_element__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../create-element/create-card-element */ "./src/panels/lovelace/create-element/create-card-element.ts");
/* harmony import */ var _editor_card_editor_show_edit_card_dialog__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../editor/card-editor/show-edit-card-dialog */ "./src/panels/lovelace/editor/card-editor/show-edit-card-dialog.ts");
function _decorate(decorators, factory, superClass, mixins) { var api = _getDecoratorsApi(); if (mixins) { for (var i = 0; i < mixins.length; i++) { api = mixins[i](api); } } var r = factory(function initialize(O) { api.initializeInstanceElements(O, decorated.elements); }, superClass); var decorated = api.decorateClass(_coalesceClassElements(r.d.map(_createElementDescriptor)), decorators); api.initializeClassElements(r.F, decorated.elements); return api.runClassFinishers(r.F, decorated.finishers); }

function _getDecoratorsApi() { _getDecoratorsApi = function () { return api; }; var api = { elementsDefinitionOrder: [["method"], ["field"]], initializeInstanceElements: function (O, elements) { ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { if (element.kind === kind && element.placement === "own") { this.defineClassElement(O, element); } }, this); }, this); }, initializeClassElements: function (F, elements) { var proto = F.prototype; ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { var placement = element.placement; if (element.kind === kind && (placement === "static" || placement === "prototype")) { var receiver = placement === "static" ? F : proto; this.defineClassElement(receiver, element); } }, this); }, this); }, defineClassElement: function (receiver, element) { var descriptor = element.descriptor; if (element.kind === "field") { var initializer = element.initializer; descriptor = { enumerable: descriptor.enumerable, writable: descriptor.writable, configurable: descriptor.configurable, value: initializer === void 0 ? void 0 : initializer.call(receiver) }; } Object.defineProperty(receiver, element.key, descriptor); }, decorateClass: function (elements, decorators) { var newElements = []; var finishers = []; var placements = { static: [], prototype: [], own: [] }; elements.forEach(function (element) { this.addElementPlacement(element, placements); }, this); elements.forEach(function (element) { if (!_hasDecorators(element)) return newElements.push(element); var elementFinishersExtras = this.decorateElement(element, placements); newElements.push(elementFinishersExtras.element); newElements.push.apply(newElements, elementFinishersExtras.extras); finishers.push.apply(finishers, elementFinishersExtras.finishers); }, this); if (!decorators) { return { elements: newElements, finishers: finishers }; } var result = this.decorateConstructor(newElements, decorators); finishers.push.apply(finishers, result.finishers); result.finishers = finishers; return result; }, addElementPlacement: function (element, placements, silent) { var keys = placements[element.placement]; if (!silent && keys.indexOf(element.key) !== -1) { throw new TypeError("Duplicated element (" + element.key + ")"); } keys.push(element.key); }, decorateElement: function (element, placements) { var extras = []; var finishers = []; for (var decorators = element.decorators, i = decorators.length - 1; i >= 0; i--) { var keys = placements[element.placement]; keys.splice(keys.indexOf(element.key), 1); var elementObject = this.fromElementDescriptor(element); var elementFinisherExtras = this.toElementFinisherExtras((0, decorators[i])(elementObject) || elementObject); element = elementFinisherExtras.element; this.addElementPlacement(element, placements); if (elementFinisherExtras.finisher) { finishers.push(elementFinisherExtras.finisher); } var newExtras = elementFinisherExtras.extras; if (newExtras) { for (var j = 0; j < newExtras.length; j++) { this.addElementPlacement(newExtras[j], placements); } extras.push.apply(extras, newExtras); } } return { element: element, finishers: finishers, extras: extras }; }, decorateConstructor: function (elements, decorators) { var finishers = []; for (var i = decorators.length - 1; i >= 0; i--) { var obj = this.fromClassDescriptor(elements); var elementsAndFinisher = this.toClassDescriptor((0, decorators[i])(obj) || obj); if (elementsAndFinisher.finisher !== undefined) { finishers.push(elementsAndFinisher.finisher); } if (elementsAndFinisher.elements !== undefined) { elements = elementsAndFinisher.elements; for (var j = 0; j < elements.length - 1; j++) { for (var k = j + 1; k < elements.length; k++) { if (elements[j].key === elements[k].key && elements[j].placement === elements[k].placement) { throw new TypeError("Duplicated element (" + elements[j].key + ")"); } } } } } return { elements: elements, finishers: finishers }; }, fromElementDescriptor: function (element) { var obj = { kind: element.kind, key: element.key, placement: element.placement, descriptor: element.descriptor }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); if (element.kind === "field") obj.initializer = element.initializer; return obj; }, toElementDescriptors: function (elementObjects) { if (elementObjects === undefined) return; return _toArray(elementObjects).map(function (elementObject) { var element = this.toElementDescriptor(elementObject); this.disallowProperty(elementObject, "finisher", "An element descriptor"); this.disallowProperty(elementObject, "extras", "An element descriptor"); return element; }, this); }, toElementDescriptor: function (elementObject) { var kind = String(elementObject.kind); if (kind !== "method" && kind !== "field") { throw new TypeError('An element descriptor\'s .kind property must be either "method" or' + ' "field", but a decorator created an element descriptor with' + ' .kind "' + kind + '"'); } var key = _toPropertyKey(elementObject.key); var placement = String(elementObject.placement); if (placement !== "static" && placement !== "prototype" && placement !== "own") { throw new TypeError('An element descriptor\'s .placement property must be one of "static",' + ' "prototype" or "own", but a decorator created an element descriptor' + ' with .placement "' + placement + '"'); } var descriptor = elementObject.descriptor; this.disallowProperty(elementObject, "elements", "An element descriptor"); var element = { kind: kind, key: key, placement: placement, descriptor: Object.assign({}, descriptor) }; if (kind !== "field") { this.disallowProperty(elementObject, "initializer", "A method descriptor"); } else { this.disallowProperty(descriptor, "get", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "set", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "value", "The property descriptor of a field descriptor"); element.initializer = elementObject.initializer; } return element; }, toElementFinisherExtras: function (elementObject) { var element = this.toElementDescriptor(elementObject); var finisher = _optionalCallableProperty(elementObject, "finisher"); var extras = this.toElementDescriptors(elementObject.extras); return { element: element, finisher: finisher, extras: extras }; }, fromClassDescriptor: function (elements) { var obj = { kind: "class", elements: elements.map(this.fromElementDescriptor, this) }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); return obj; }, toClassDescriptor: function (obj) { var kind = String(obj.kind); if (kind !== "class") { throw new TypeError('A class descriptor\'s .kind property must be "class", but a decorator' + ' created a class descriptor with .kind "' + kind + '"'); } this.disallowProperty(obj, "key", "A class descriptor"); this.disallowProperty(obj, "placement", "A class descriptor"); this.disallowProperty(obj, "descriptor", "A class descriptor"); this.disallowProperty(obj, "initializer", "A class descriptor"); this.disallowProperty(obj, "extras", "A class descriptor"); var finisher = _optionalCallableProperty(obj, "finisher"); var elements = this.toElementDescriptors(obj.elements); return { elements: elements, finisher: finisher }; }, runClassFinishers: function (constructor, finishers) { for (var i = 0; i < finishers.length; i++) { var newConstructor = (0, finishers[i])(constructor); if (newConstructor !== undefined) { if (typeof newConstructor !== "function") { throw new TypeError("Finishers must return a constructor."); } constructor = newConstructor; } } return constructor; }, disallowProperty: function (obj, name, objectType) { if (obj[name] !== undefined) { throw new TypeError(objectType + " can't have a ." + name + " property."); } } }; return api; }

function _createElementDescriptor(def) { var key = _toPropertyKey(def.key); var descriptor; if (def.kind === "method") { descriptor = { value: def.value, writable: true, configurable: true, enumerable: false }; } else if (def.kind === "get") { descriptor = { get: def.value, configurable: true, enumerable: false }; } else if (def.kind === "set") { descriptor = { set: def.value, configurable: true, enumerable: false }; } else if (def.kind === "field") { descriptor = { configurable: true, writable: true, enumerable: true }; } var element = { kind: def.kind === "field" ? "field" : "method", key: key, placement: def.static ? "static" : def.kind === "field" ? "own" : "prototype", descriptor: descriptor }; if (def.decorators) element.decorators = def.decorators; if (def.kind === "field") element.initializer = def.value; return element; }

function _coalesceGetterSetter(element, other) { if (element.descriptor.get !== undefined) { other.descriptor.get = element.descriptor.get; } else { other.descriptor.set = element.descriptor.set; } }

function _coalesceClassElements(elements) { var newElements = []; var isSameElement = function (other) { return other.kind === "method" && other.key === element.key && other.placement === element.placement; }; for (var i = 0; i < elements.length; i++) { var element = elements[i]; var other; if (element.kind === "method" && (other = newElements.find(isSameElement))) { if (_isDataDescriptor(element.descriptor) || _isDataDescriptor(other.descriptor)) { if (_hasDecorators(element) || _hasDecorators(other)) { throw new ReferenceError("Duplicated methods (" + element.key + ") can't be decorated."); } other.descriptor = element.descriptor; } else { if (_hasDecorators(element)) { if (_hasDecorators(other)) { throw new ReferenceError("Decorators can't be placed on different accessors with for " + "the same property (" + element.key + ")."); } other.decorators = element.decorators; } _coalesceGetterSetter(element, other); } } else { newElements.push(element); } } return newElements; }

function _hasDecorators(element) { return element.decorators && element.decorators.length; }

function _isDataDescriptor(desc) { return desc !== undefined && !(desc.value === undefined && desc.writable === undefined); }

function _optionalCallableProperty(obj, name) { var value = obj[name]; if (value !== undefined && typeof value !== "function") { throw new TypeError("Expected '" + name + "' to be a function"); } return value; }

function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }

function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }

function _toArray(arr) { return _arrayWithHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(n); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get; } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return _get(target, property, receiver || target); }

function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

 // This one is for types










let editCodeLoaded = false; // Find column with < 5 entities, else column with lowest count

const getColumnIndex = (columnEntityCount, size) => {
  let minIndex = 0;

  for (let i = 0; i < columnEntityCount.length; i++) {
    if (columnEntityCount[i] < 5) {
      minIndex = i;
      break;
    }

    if (columnEntityCount[i] < columnEntityCount[minIndex]) {
      minIndex = i;
    }
  }

  columnEntityCount[minIndex] += size;
  return minIndex;
};

let HUIView = _decorate(null, function (_initialize, _LitElement) {
  class HUIView extends _LitElement {
    constructor(...args) {
      super(...args);

      _initialize(this);
    }

  }

  return {
    F: HUIView,
    d: [{
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "hass",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "lovelace",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])({
        type: Number
      })],
      key: "columns",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])({
        type: Number
      })],
      key: "index",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "_cards",

      value() {
        return [];
      }

    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "_badges",

      value() {
        return [];
      }

    }, {
      kind: "method",
      key: "createCardElement",
      value: // Public to make demo happy
      function createCardElement(cardConfig) {
        const element = Object(_create_element_create_card_element__WEBPACK_IMPORTED_MODULE_8__["createCardElement"])(cardConfig);

        element.hass = this.hass;
        element.addEventListener("ll-rebuild", ev => {
          // In edit mode let it go to hui-root and rebuild whole view.
          if (!this.lovelace.editMode) {
            ev.stopPropagation();

            this._rebuildCard(element, cardConfig);
          }
        }, {
          once: true
        });
        return element;
      }
    }, {
      kind: "method",
      key: "createBadgeElement",
      value: function createBadgeElement(badgeConfig) {
        const element = Object(_create_element_create_badge_element__WEBPACK_IMPORTED_MODULE_7__["createBadgeElement"])(badgeConfig);

        element.hass = this.hass;
        element.addEventListener("ll-badge-rebuild", () => {
          this._rebuildBadge(element, badgeConfig);
        }, {
          once: true
        });
        return element;
      }
    }, {
      kind: "method",
      key: "render",
      value: function render() {
        return lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
      ${this.renderStyles()}
      <div id="badges"></div>
      <div id="columns"></div>
      ${this.lovelace.editMode ? lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
            <ha-fab
              icon="hass:plus"
              title="${this.hass.localize("ui.panel.lovelace.editor.edit_card.add")}"
              @click="${this._addCard}"
              class="${Object(lit_html_directives_class_map__WEBPACK_IMPORTED_MODULE_1__["classMap"])({
          rtl: Object(_common_util_compute_rtl__WEBPACK_IMPORTED_MODULE_3__["computeRTL"])(this.hass)
        })}"
            ></ha-fab>
          ` : ""}
    `;
      }
    }, {
      kind: "method",
      key: "renderStyles",
      value: function renderStyles() {
        return lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
      <style>
        :host {
          display: block;
          box-sizing: border-box;
          padding: 4px 4px 0;
          transform: translateZ(0);
          position: relative;
          color: var(--primary-text-color);
          background: var(
            --lovelace-background,
            var(--primary-background-color)
          );
        }

        #badges {
          margin: 8px 16px;
          font-size: 85%;
          text-align: center;
        }

        #columns {
          display: flex;
          flex-direction: row;
          justify-content: center;
        }

        .column {
          flex: 1 0 0;
          max-width: 500px;
          min-width: 0;
          /* on iOS devices the column can become wider when toggling a switch */
          overflow-x: hidden;
        }

        .column > * {
          display: block;
          margin: 4px 4px 8px;
        }

        ha-fab {
          position: sticky;
          float: right;
          bottom: 16px;
          right: 16px;
          z-index: 1;
        }

        ha-fab.rtl {
          float: left;
          right: auto;
          left: 16px;
        }

        @media (max-width: 500px) {
          :host {
            padding-left: 0;
            padding-right: 0;
          }

          .column > * {
            margin-left: 0;
            margin-right: 0;
          }
        }

        @media (max-width: 599px) {
          .column {
            max-width: 600px;
          }
        }
      </style>
    `;
      }
    }, {
      kind: "method",
      key: "updated",
      value: function updated(changedProperties) {
        _get(_getPrototypeOf(HUIView.prototype), "updated", this).call(this, changedProperties);

        const hass = this.hass;
        const lovelace = this.lovelace;

        if (lovelace.editMode && !editCodeLoaded) {
          editCodeLoaded = true;
          Promise.all(/*! import() | hui-view-editable */[__webpack_require__.e("vendors~hui-unused-entities~hui-view-editable~panel-config-areas~panel-config-automation~panel-confi~41c12095"), __webpack_require__.e("hui-unused-entities~hui-view-editable~panel-config-areas~panel-config-automation~panel-config-helper~c9d97d21"), __webpack_require__.e("hui-view-editable")]).then(__webpack_require__.bind(null, /*! ./hui-view-editable */ "./src/panels/lovelace/views/hui-view-editable.ts"));
        }

        const hassChanged = changedProperties.has("hass");
        let editModeChanged = false;
        let configChanged = false;

        if (changedProperties.has("index")) {
          configChanged = true;
        } else if (changedProperties.has("lovelace")) {
          const oldLovelace = changedProperties.get("lovelace");
          editModeChanged = !oldLovelace || lovelace.editMode !== oldLovelace.editMode;
          configChanged = !oldLovelace || lovelace.config !== oldLovelace.config;
        }

        if (configChanged) {
          this._createBadges(lovelace.config.views[this.index]);
        } else if (hassChanged) {
          this._badges.forEach(badge => {
            badge.hass = hass;
          });
        }

        if (configChanged || editModeChanged || changedProperties.has("columns")) {
          this._createCards(lovelace.config.views[this.index]);
        } else if (hassChanged) {
          this._cards.forEach(element => {
            element.hass = this.hass;
          });
        }

        const oldHass = changedProperties.get("hass");

        if (configChanged || editModeChanged || hassChanged && oldHass && (hass.themes !== oldHass.themes || hass.selectedTheme !== oldHass.selectedTheme)) {
          Object(_common_dom_apply_themes_on_element__WEBPACK_IMPORTED_MODULE_2__["applyThemesOnElement"])(this, hass.themes, lovelace.config.views[this.index].theme);
        }
      }
    }, {
      kind: "method",
      key: "_addCard",
      value: function _addCard() {
        Object(_editor_card_editor_show_edit_card_dialog__WEBPACK_IMPORTED_MODULE_9__["showEditCardDialog"])(this, {
          lovelaceConfig: this.lovelace.config,
          saveConfig: this.lovelace.saveConfig,
          path: [this.index]
        });
      }
    }, {
      kind: "method",
      key: "_createBadges",
      value: function _createBadges(config) {
        const root = this.shadowRoot.getElementById("badges");

        while (root.lastChild) {
          root.removeChild(root.lastChild);
        }

        if (!config || !config.badges || !Array.isArray(config.badges)) {
          root.style.display = "none";
          this._badges = [];
          return;
        }

        const elements = [];
        const badges = Object(_common_process_config_entities__WEBPACK_IMPORTED_MODULE_6__["processConfigEntities"])(config.badges);
        badges.forEach(badge => {
          const element = Object(_create_element_create_badge_element__WEBPACK_IMPORTED_MODULE_7__["createBadgeElement"])(badge);

          element.hass = this.hass;
          elements.push(element);
          root.appendChild(element);
        });
        this._badges = elements;
        root.style.display = elements.length > 0 ? "block" : "none";
      }
    }, {
      kind: "method",
      key: "_createCards",
      value: function _createCards(config) {
        const root = this.shadowRoot.getElementById("columns");

        while (root.lastChild) {
          root.removeChild(root.lastChild);
        }

        if (!config || !config.cards || !Array.isArray(config.cards)) {
          this._cards = [];
          return;
        }

        const elements = [];
        const elementsToAppend = [];
        config.cards.forEach((cardConfig, cardIndex) => {
          const element = this.createCardElement(cardConfig);
          elements.push(element);

          if (!this.lovelace.editMode) {
            elementsToAppend.push(element);
            return;
          }

          const wrapper = document.createElement("hui-card-options");
          wrapper.hass = this.hass;
          wrapper.lovelace = this.lovelace;
          wrapper.path = [this.index, cardIndex];
          element.editMode = true;
          wrapper.appendChild(element);
          elementsToAppend.push(wrapper);
        });
        let columns = [];
        const columnEntityCount = [];

        for (let i = 0; i < this.columns; i++) {
          columns.push([]);
          columnEntityCount.push(0);
        }

        elements.forEach((el, index) => {
          const cardSize = Object(_common_compute_card_size__WEBPACK_IMPORTED_MODULE_5__["computeCardSize"])(el); // Element to append might be the wrapped card when we're editing.

          columns[getColumnIndex(columnEntityCount, cardSize)].push(elementsToAppend[index]);
        }); // Remove empty columns

        columns = columns.filter(val => val.length > 0);
        columns.forEach(column => {
          const columnEl = document.createElement("div");
          columnEl.classList.add("column");
          column.forEach(el => columnEl.appendChild(el));
          root.appendChild(columnEl);
        });
        this._cards = elements;
      }
    }, {
      kind: "method",
      key: "_rebuildCard",
      value: function _rebuildCard(cardElToReplace, config) {
        const newCardEl = this.createCardElement(config);
        cardElToReplace.parentElement.replaceChild(newCardEl, cardElToReplace);
        this._cards = this._cards.map(curCardEl => curCardEl === cardElToReplace ? newCardEl : curCardEl);
      }
    }, {
      kind: "method",
      key: "_rebuildBadge",
      value: function _rebuildBadge(badgeElToReplace, config) {
        const newBadgeEl = this.createBadgeElement(config);
        badgeElToReplace.parentElement.replaceChild(newBadgeEl, badgeElToReplace);
        this._badges = this._cards.map(curBadgeEl => curBadgeEl === badgeElToReplace ? newBadgeEl : curBadgeEl);
      }
    }]
  };
}, lit_element__WEBPACK_IMPORTED_MODULE_0__["LitElement"]);
customElements.define("hui-view", HUIView);

/***/ })

}]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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