(self["webpackJsonp"] = self["webpackJsonp"] || []).push([["panel-config-integrations"],{

/***/ "./src/common/entity/compute_object_id.ts":
/*!************************************************!*\
  !*** ./src/common/entity/compute_object_id.ts ***!
  \************************************************/
/*! exports provided: computeObjectId */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "computeObjectId", function() { return computeObjectId; });
/** Compute the object ID of a state. */
const computeObjectId = entityId => {
  return entityId.substr(entityId.indexOf(".") + 1);
};

/***/ }),

/***/ "./src/common/entity/compute_state_name.ts":
/*!*************************************************!*\
  !*** ./src/common/entity/compute_state_name.ts ***!
  \*************************************************/
/*! exports provided: computeStateName */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "computeStateName", function() { return computeStateName; });
/* harmony import */ var _compute_object_id__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./compute_object_id */ "./src/common/entity/compute_object_id.ts");

const computeStateName = stateObj => {
  return stateObj.attributes.friendly_name === undefined ? Object(_compute_object_id__WEBPACK_IMPORTED_MODULE_0__["computeObjectId"])(stateObj.entity_id).replace(/_/g, " ") : stateObj.attributes.friendly_name || "";
};

/***/ }),

/***/ "./src/common/string/compare.ts":
/*!**************************************!*\
  !*** ./src/common/string/compare.ts ***!
  \**************************************/
/*! exports provided: compare, caseInsensitiveCompare */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "compare", function() { return compare; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "caseInsensitiveCompare", function() { return caseInsensitiveCompare; });
const compare = (a, b) => {
  if (a < b) {
    return -1;
  }

  if (a > b) {
    return 1;
  }

  return 0;
};
const caseInsensitiveCompare = (a, b) => compare(a.toLowerCase(), b.toLowerCase());

/***/ }),

/***/ "./src/common/util/render-status.ts":
/*!******************************************!*\
  !*** ./src/common/util/render-status.ts ***!
  \******************************************/
/*! exports provided: afterNextRender, nextRender */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "afterNextRender", function() { return afterNextRender; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "nextRender", function() { return nextRender; });
const afterNextRender = cb => {
  requestAnimationFrame(() => setTimeout(cb, 0));
};
const nextRender = () => {
  return new Promise(resolve => {
    afterNextRender(resolve);
  });
};

/***/ }),

/***/ "./src/components/entity/ha-state-icon.js":
/*!************************************************!*\
  !*** ./src/components/entity/ha-state-icon.js ***!
  \************************************************/
/*! no exports provided */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _polymer_polymer_lib_utils_html_tag__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @polymer/polymer/lib/utils/html-tag */ "./node_modules/@polymer/polymer/lib/utils/html-tag.js");
/* harmony import */ var _polymer_polymer_polymer_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @polymer/polymer/polymer-element */ "./node_modules/@polymer/polymer/polymer-element.js");
/* harmony import */ var _common_entity_state_icon__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../common/entity/state_icon */ "./src/common/entity/state_icon.ts");
/* harmony import */ var _ha_icon__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../ha-icon */ "./src/components/ha-icon.ts");

/* eslint-plugin-disable lit */





class HaStateIcon extends _polymer_polymer_polymer_element__WEBPACK_IMPORTED_MODULE_1__["PolymerElement"] {
  static get template() {
    return _polymer_polymer_lib_utils_html_tag__WEBPACK_IMPORTED_MODULE_0__["html"]` <ha-icon icon="[[computeIcon(stateObj)]]"></ha-icon> `;
  }

  static get properties() {
    return {
      stateObj: {
        type: Object
      }
    };
  }

  computeIcon(stateObj) {
    return Object(_common_entity_state_icon__WEBPACK_IMPORTED_MODULE_2__["stateIcon"])(stateObj);
  }

}

customElements.define("ha-state-icon", HaStateIcon);

/***/ }),

/***/ "./src/components/ha-icon-next.ts":
/*!****************************************!*\
  !*** ./src/components/ha-icon-next.ts ***!
  \****************************************/
/*! exports provided: HaIconNext */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HaIconNext", function() { return HaIconNext; });
/* harmony import */ var _polymer_iron_icon_iron_icon__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @polymer/iron-icon/iron-icon */ "./node_modules/@polymer/iron-icon/iron-icon.js");
/* harmony import */ var _ha_icon__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ha-icon */ "./src/components/ha-icon.ts");
 // Not duplicate, this is for typing.
// eslint-disable-next-line


class HaIconNext extends _ha_icon__WEBPACK_IMPORTED_MODULE_1__["HaIcon"] {
  connectedCallback() {
    super.connectedCallback(); // wait to check for direction since otherwise direction is wrong even though top level is RTL

    setTimeout(() => {
      this.icon = window.getComputedStyle(this).direction === "ltr" ? "hass:chevron-right" : "hass:chevron-left";
    }, 100);
  }

}
customElements.define("ha-icon-next", HaIconNext);

/***/ }),

/***/ "./src/components/ha-icon.ts":
/*!***********************************!*\
  !*** ./src/components/ha-icon.ts ***!
  \***********************************/
/*! exports provided: HaIcon */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HaIcon", function() { return HaIcon; });
/* harmony import */ var _polymer_iron_icon_iron_icon__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @polymer/iron-icon/iron-icon */ "./node_modules/@polymer/iron-icon/iron-icon.js");
function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }


const ironIconClass = customElements.get("iron-icon");
let loaded = false;
class HaIcon extends ironIconClass {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "_iconsetName", void 0);
  }

  listen(node, eventName, methodName) {
    super.listen(node, eventName, methodName);

    if (!loaded && this._iconsetName === "mdi") {
      loaded = true;
      __webpack_require__.e(/*! import() | mdi-icons */ "mdi-icons").then(__webpack_require__.bind(null, /*! ../resources/mdi-icons */ "./src/resources/mdi-icons.js"));
    }
  }

}
customElements.define("ha-icon", HaIcon);

/***/ }),

/***/ "./src/data/config_entries.ts":
/*!************************************!*\
  !*** ./src/data/config_entries.ts ***!
  \************************************/
/*! exports provided: getConfigEntries, updateConfigEntry, deleteConfigEntry, getConfigEntrySystemOptions, updateConfigEntrySystemOptions */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getConfigEntries", function() { return getConfigEntries; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "updateConfigEntry", function() { return updateConfigEntry; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "deleteConfigEntry", function() { return deleteConfigEntry; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getConfigEntrySystemOptions", function() { return getConfigEntrySystemOptions; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "updateConfigEntrySystemOptions", function() { return updateConfigEntrySystemOptions; });
const getConfigEntries = hass => hass.callApi("GET", "config/config_entries/entry");
const updateConfigEntry = (hass, configEntryId, updatedValues) => hass.callWS(Object.assign({
  type: "config_entries/update",
  entry_id: configEntryId
}, updatedValues));
const deleteConfigEntry = (hass, configEntryId) => hass.callApi("DELETE", `config/config_entries/entry/${configEntryId}`);
const getConfigEntrySystemOptions = (hass, configEntryId) => hass.callWS({
  type: "config_entries/system_options/list",
  entry_id: configEntryId
});
const updateConfigEntrySystemOptions = (hass, configEntryId, params) => hass.callWS(Object.assign({
  type: "config_entries/system_options/update",
  entry_id: configEntryId
}, params));

/***/ }),

/***/ "./src/data/config_flow.ts":
/*!*********************************!*\
  !*** ./src/data/config_flow.ts ***!
  \*********************************/
/*! exports provided: DISCOVERY_SOURCES, createConfigFlow, fetchConfigFlow, handleConfigFlowStep, ignoreConfigFlow, deleteConfigFlow, getConfigFlowHandlers, getConfigFlowInProgressCollection, subscribeConfigFlowInProgress, localizeConfigFlowTitle */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DISCOVERY_SOURCES", function() { return DISCOVERY_SOURCES; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "createConfigFlow", function() { return createConfigFlow; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "fetchConfigFlow", function() { return fetchConfigFlow; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "handleConfigFlowStep", function() { return handleConfigFlowStep; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ignoreConfigFlow", function() { return ignoreConfigFlow; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "deleteConfigFlow", function() { return deleteConfigFlow; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getConfigFlowHandlers", function() { return getConfigFlowHandlers; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getConfigFlowInProgressCollection", function() { return getConfigFlowInProgressCollection; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "subscribeConfigFlowInProgress", function() { return subscribeConfigFlowInProgress; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "localizeConfigFlowTitle", function() { return localizeConfigFlowTitle; });
/* harmony import */ var home_assistant_js_websocket__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! home-assistant-js-websocket */ "./node_modules/home-assistant-js-websocket/dist/index.js");
/* harmony import */ var _common_util_debounce__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../common/util/debounce */ "./src/common/util/debounce.ts");
/* harmony import */ var _integration__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./integration */ "./src/data/integration.ts");



const DISCOVERY_SOURCES = ["unignore", "homekit", "ssdp", "zeroconf"];
const createConfigFlow = (hass, handler) => {
  var _hass$userData;

  return hass.callApi("POST", "config/config_entries/flow", {
    handler,
    show_advanced_options: Boolean((_hass$userData = hass.userData) === null || _hass$userData === void 0 ? void 0 : _hass$userData.showAdvanced)
  });
};
const fetchConfigFlow = (hass, flowId) => hass.callApi("GET", `config/config_entries/flow/${flowId}`);
const handleConfigFlowStep = (hass, flowId, data) => hass.callApi("POST", `config/config_entries/flow/${flowId}`, data);
const ignoreConfigFlow = (hass, flowId) => hass.callWS({
  type: "config_entries/ignore_flow",
  flow_id: flowId
});
const deleteConfigFlow = (hass, flowId) => hass.callApi("DELETE", `config/config_entries/flow/${flowId}`);
const getConfigFlowHandlers = hass => hass.callApi("GET", "config/config_entries/flow_handlers");

const fetchConfigFlowInProgress = conn => conn.sendMessagePromise({
  type: "config_entries/flow/progress"
});

const subscribeConfigFlowInProgressUpdates = (conn, store) => conn.subscribeEvents(Object(_common_util_debounce__WEBPACK_IMPORTED_MODULE_1__["debounce"])(() => fetchConfigFlowInProgress(conn).then(flows => store.setState(flows, true)), 500, true), "config_entry_discovered");

const getConfigFlowInProgressCollection = conn => Object(home_assistant_js_websocket__WEBPACK_IMPORTED_MODULE_0__["getCollection"])(conn, "_configFlowProgress", fetchConfigFlowInProgress, subscribeConfigFlowInProgressUpdates);
const subscribeConfigFlowInProgress = (hass, onChange) => getConfigFlowInProgressCollection(hass.connection).subscribe(onChange);
const localizeConfigFlowTitle = (localize, flow) => {
  const placeholders = flow.context.title_placeholders || {};
  const placeholderKeys = Object.keys(placeholders);

  if (placeholderKeys.length === 0) {
    return Object(_integration__WEBPACK_IMPORTED_MODULE_2__["domainToName"])(localize, flow.handler);
  }

  const args = [];
  placeholderKeys.forEach(key => {
    args.push(key);
    args.push(placeholders[key]);
  });
  return localize(`component.${flow.handler}.config.flow_title`, ...args);
};

/***/ }),

/***/ "./src/data/device_registry.ts":
/*!*************************************!*\
  !*** ./src/data/device_registry.ts ***!
  \*************************************/
/*! exports provided: fallbackDeviceName, computeDeviceName, devicesInArea, updateDeviceRegistryEntry, subscribeDeviceRegistry */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "fallbackDeviceName", function() { return fallbackDeviceName; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "computeDeviceName", function() { return computeDeviceName; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "devicesInArea", function() { return devicesInArea; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "updateDeviceRegistryEntry", function() { return updateDeviceRegistryEntry; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "subscribeDeviceRegistry", function() { return subscribeDeviceRegistry; });
/* harmony import */ var home_assistant_js_websocket__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! home-assistant-js-websocket */ "./node_modules/home-assistant-js-websocket/dist/index.js");
/* harmony import */ var _common_entity_compute_state_name__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../common/entity/compute_state_name */ "./src/common/entity/compute_state_name.ts");
/* harmony import */ var _common_util_debounce__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../common/util/debounce */ "./src/common/util/debounce.ts");



const fallbackDeviceName = (hass, entities) => {
  for (const entity of entities || []) {
    const entityId = typeof entity === "string" ? entity : entity.entity_id;
    const stateObj = hass.states[entityId];

    if (stateObj) {
      return Object(_common_entity_compute_state_name__WEBPACK_IMPORTED_MODULE_1__["computeStateName"])(stateObj);
    }
  }

  return undefined;
};
const computeDeviceName = (device, hass, entities) => {
  return device.name_by_user || device.name || entities && fallbackDeviceName(hass, entities) || hass.localize("ui.panel.config.devices.unnamed_device");
};
const devicesInArea = (devices, areaId) => devices.filter(device => device.area_id === areaId);
const updateDeviceRegistryEntry = (hass, deviceId, updates) => hass.callWS(Object.assign({
  type: "config/device_registry/update",
  device_id: deviceId
}, updates));

const fetchDeviceRegistry = conn => conn.sendMessagePromise({
  type: "config/device_registry/list"
});

const subscribeDeviceRegistryUpdates = (conn, store) => conn.subscribeEvents(Object(_common_util_debounce__WEBPACK_IMPORTED_MODULE_2__["debounce"])(() => fetchDeviceRegistry(conn).then(devices => store.setState(devices, true)), 500, true), "device_registry_updated");

const subscribeDeviceRegistry = (conn, onChange) => Object(home_assistant_js_websocket__WEBPACK_IMPORTED_MODULE_0__["createCollection"])("_dr", fetchDeviceRegistry, subscribeDeviceRegistryUpdates, conn, onChange);

/***/ }),

/***/ "./src/data/entity_registry.ts":
/*!*************************************!*\
  !*** ./src/data/entity_registry.ts ***!
  \*************************************/
/*! exports provided: findBatteryEntity, computeEntityRegistryName, getExtendedEntityRegistryEntry, updateEntityRegistryEntry, removeEntityRegistryEntry, subscribeEntityRegistry */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "findBatteryEntity", function() { return findBatteryEntity; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "computeEntityRegistryName", function() { return computeEntityRegistryName; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getExtendedEntityRegistryEntry", function() { return getExtendedEntityRegistryEntry; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "updateEntityRegistryEntry", function() { return updateEntityRegistryEntry; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "removeEntityRegistryEntry", function() { return removeEntityRegistryEntry; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "subscribeEntityRegistry", function() { return subscribeEntityRegistry; });
/* harmony import */ var home_assistant_js_websocket__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! home-assistant-js-websocket */ "./node_modules/home-assistant-js-websocket/dist/index.js");
/* harmony import */ var _common_entity_compute_state_name__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../common/entity/compute_state_name */ "./src/common/entity/compute_state_name.ts");
/* harmony import */ var _common_util_debounce__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../common/util/debounce */ "./src/common/util/debounce.ts");



const findBatteryEntity = (hass, entities) => entities.find(entity => hass.states[entity.entity_id] && hass.states[entity.entity_id].attributes.device_class === "battery");
const computeEntityRegistryName = (hass, entry) => {
  if (entry.name) {
    return entry.name;
  }

  const state = hass.states[entry.entity_id];
  return state ? Object(_common_entity_compute_state_name__WEBPACK_IMPORTED_MODULE_1__["computeStateName"])(state) : null;
};
const getExtendedEntityRegistryEntry = (hass, entityId) => hass.callWS({
  type: "config/entity_registry/get",
  entity_id: entityId
});
const updateEntityRegistryEntry = (hass, entityId, updates) => hass.callWS(Object.assign({
  type: "config/entity_registry/update",
  entity_id: entityId
}, updates));
const removeEntityRegistryEntry = (hass, entityId) => hass.callWS({
  type: "config/entity_registry/remove",
  entity_id: entityId
});

const fetchEntityRegistry = conn => conn.sendMessagePromise({
  type: "config/entity_registry/list"
});

const subscribeEntityRegistryUpdates = (conn, store) => conn.subscribeEvents(Object(_common_util_debounce__WEBPACK_IMPORTED_MODULE_2__["debounce"])(() => fetchEntityRegistry(conn).then(entities => store.setState(entities, true)), 500, true), "entity_registry_updated");

const subscribeEntityRegistry = (conn, onChange) => Object(home_assistant_js_websocket__WEBPACK_IMPORTED_MODULE_0__["createCollection"])("_entityRegistry", fetchEntityRegistry, subscribeEntityRegistryUpdates, conn, onChange);

/***/ }),

/***/ "./src/data/integration.ts":
/*!*********************************!*\
  !*** ./src/data/integration.ts ***!
  \*********************************/
/*! exports provided: integrationIssuesUrl, domainToName, fetchIntegrationManifests, fetchIntegrationManifest */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "integrationIssuesUrl", function() { return integrationIssuesUrl; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "domainToName", function() { return domainToName; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "fetchIntegrationManifests", function() { return fetchIntegrationManifests; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "fetchIntegrationManifest", function() { return fetchIntegrationManifest; });
const integrationIssuesUrl = domain => `https://github.com/home-assistant/home-assistant/issues?q=is%3Aissue+is%3Aopen+label%3A%22integration%3A+${domain}%22`;
const domainToName = (localize, domain) => localize(`component.${domain}.title`) || domain;
const fetchIntegrationManifests = hass => hass.callWS({
  type: "manifest/list"
});
const fetchIntegrationManifest = (hass, integration) => hass.callWS({
  type: "manifest/get",
  integration
});

/***/ }),

/***/ "./src/data/options_flow.ts":
/*!**********************************!*\
  !*** ./src/data/options_flow.ts ***!
  \**********************************/
/*! exports provided: createOptionsFlow, fetchOptionsFlow, handleOptionsFlowStep, deleteOptionsFlow */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "createOptionsFlow", function() { return createOptionsFlow; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "fetchOptionsFlow", function() { return fetchOptionsFlow; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "handleOptionsFlowStep", function() { return handleOptionsFlowStep; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "deleteOptionsFlow", function() { return deleteOptionsFlow; });
const createOptionsFlow = (hass, handler) => {
  var _hass$userData;

  return hass.callApi("POST", "config/config_entries/options/flow", {
    handler,
    show_advanced_options: Boolean((_hass$userData = hass.userData) === null || _hass$userData === void 0 ? void 0 : _hass$userData.showAdvanced)
  });
};
const fetchOptionsFlow = (hass, flowId) => hass.callApi("GET", `config/config_entries/options/flow/${flowId}`);
const handleOptionsFlowStep = (hass, flowId, data) => hass.callApi("POST", `config/config_entries/options/flow/${flowId}`, data);
const deleteOptionsFlow = (hass, flowId) => hass.callApi("DELETE", `config/config_entries/options/flow/${flowId}`);

/***/ }),

/***/ "./src/dialogs/config-entry-system-options/show-dialog-config-entry-system-options.ts":
/*!********************************************************************************************!*\
  !*** ./src/dialogs/config-entry-system-options/show-dialog-config-entry-system-options.ts ***!
  \********************************************************************************************/
/*! exports provided: loadConfigEntrySystemOptionsDialog, showConfigEntrySystemOptionsDialog */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "loadConfigEntrySystemOptionsDialog", function() { return loadConfigEntrySystemOptionsDialog; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "showConfigEntrySystemOptionsDialog", function() { return showConfigEntrySystemOptionsDialog; });
/* harmony import */ var _common_dom_fire_event__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../common/dom/fire_event */ "./src/common/dom/fire_event.ts");

const loadConfigEntrySystemOptionsDialog = () => Promise.all(/*! import() | config-entry-system-options */[__webpack_require__.e(1), __webpack_require__.e("vendors~cloud-webhook-manage-dialog~config-entry-system-options~confirmation~device-registry-detail-~836e8839"), __webpack_require__.e(13), __webpack_require__.e("vendors~config-entry-system-options"), __webpack_require__.e(14), __webpack_require__.e("config-entry-system-options")]).then(__webpack_require__.bind(null, /*! ./dialog-config-entry-system-options */ "./src/dialogs/config-entry-system-options/dialog-config-entry-system-options.ts"));
const showConfigEntrySystemOptionsDialog = (element, systemLogDetailParams) => {
  Object(_common_dom_fire_event__WEBPACK_IMPORTED_MODULE_0__["fireEvent"])(element, "show-dialog", {
    dialogTag: "dialog-config-entry-system-options",
    dialogImport: loadConfigEntrySystemOptionsDialog,
    dialogParams: systemLogDetailParams
  });
};

/***/ }),

/***/ "./src/dialogs/config-flow/show-dialog-config-flow.ts":
/*!************************************************************!*\
  !*** ./src/dialogs/config-flow/show-dialog-config-flow.ts ***!
  \************************************************************/
/*! exports provided: loadConfigFlowDialog, showConfigFlowDialog */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "loadConfigFlowDialog", function() { return loadConfigFlowDialog; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "showConfigFlowDialog", function() { return showConfigFlowDialog; });
/* harmony import */ var lit_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lit-element */ "./node_modules/lit-element/lit-element.js");
/* harmony import */ var _common_string_compare__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../common/string/compare */ "./src/common/string/compare.ts");
/* harmony import */ var _common_translations_localize__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../common/translations/localize */ "./src/common/translations/localize.ts");
/* harmony import */ var _data_config_flow__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../data/config_flow */ "./src/data/config_flow.ts");
/* harmony import */ var _data_integration__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../data/integration */ "./src/data/integration.ts");
/* harmony import */ var _show_dialog_data_entry_flow__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./show-dialog-data-entry-flow */ "./src/dialogs/config-flow/show-dialog-data-entry-flow.ts");






const loadConfigFlowDialog = _show_dialog_data_entry_flow__WEBPACK_IMPORTED_MODULE_5__["loadDataEntryFlowDialog"];
const showConfigFlowDialog = (element, dialogParams) => Object(_show_dialog_data_entry_flow__WEBPACK_IMPORTED_MODULE_5__["showFlowDialog"])(element, dialogParams, {
  loadDevicesAndAreas: true,
  getFlowHandlers: async hass => {
    const [handlers] = await Promise.all([Object(_data_config_flow__WEBPACK_IMPORTED_MODULE_3__["getConfigFlowHandlers"])(hass), hass.loadBackendTranslation("title", undefined, true)]);
    return handlers.sort((handlerA, handlerB) => Object(_common_string_compare__WEBPACK_IMPORTED_MODULE_1__["caseInsensitiveCompare"])(Object(_data_integration__WEBPACK_IMPORTED_MODULE_4__["domainToName"])(hass.localize, handlerA), Object(_data_integration__WEBPACK_IMPORTED_MODULE_4__["domainToName"])(hass.localize, handlerB)));
  },
  createFlow: async (hass, handler) => {
    const [step] = await Promise.all([Object(_data_config_flow__WEBPACK_IMPORTED_MODULE_3__["createConfigFlow"])(hass, handler), hass.loadBackendTranslation("config", handler)]);
    return step;
  },
  fetchFlow: async (hass, flowId) => {
    const step = await Object(_data_config_flow__WEBPACK_IMPORTED_MODULE_3__["fetchConfigFlow"])(hass, flowId);
    await hass.loadBackendTranslation("config", step.handler);
    return step;
  },
  handleFlowStep: _data_config_flow__WEBPACK_IMPORTED_MODULE_3__["handleConfigFlowStep"],
  deleteFlow: _data_config_flow__WEBPACK_IMPORTED_MODULE_3__["deleteConfigFlow"],

  renderAbortDescription(hass, step) {
    const description = Object(_common_translations_localize__WEBPACK_IMPORTED_MODULE_2__["localizeKey"])(hass.localize, `component.${step.handler}.config.abort.${step.reason}`, step.description_placeholders);
    return description ? lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
            <ha-markdown allowsvg breaks .content=${description}></ha-markdown>
          ` : "";
  },

  renderShowFormStepHeader(hass, step) {
    return hass.localize(`component.${step.handler}.config.step.${step.step_id}.title`) || hass.localize(`component.${step.handler}.title`);
  },

  renderShowFormStepDescription(hass, step) {
    const description = Object(_common_translations_localize__WEBPACK_IMPORTED_MODULE_2__["localizeKey"])(hass.localize, `component.${step.handler}.config.step.${step.step_id}.description`, step.description_placeholders);
    return description ? lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
            <ha-markdown allowsvg breaks .content=${description}></ha-markdown>
          ` : "";
  },

  renderShowFormStepFieldLabel(hass, step, field) {
    return hass.localize(`component.${step.handler}.config.step.${step.step_id}.data.${field.name}`);
  },

  renderShowFormStepFieldError(hass, step, error) {
    return hass.localize(`component.${step.handler}.config.error.${error}`);
  },

  renderExternalStepHeader(hass, step) {
    return hass.localize(`component.${step.handler}.config.step.${step.step_id}.title`);
  },

  renderExternalStepDescription(hass, step) {
    const description = Object(_common_translations_localize__WEBPACK_IMPORTED_MODULE_2__["localizeKey"])(hass.localize, `component.${step.handler}.config.${step.step_id}.description`, step.description_placeholders);
    return lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
        <p>
          ${hass.localize("ui.panel.config.integrations.config_flow.external_step.description")}
        </p>
        ${description ? lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
              <ha-markdown
                allowsvg
                breaks
                .content=${description}
              ></ha-markdown>
            ` : ""}
      `;
  },

  renderCreateEntryDescription(hass, step) {
    const description = Object(_common_translations_localize__WEBPACK_IMPORTED_MODULE_2__["localizeKey"])(hass.localize, `component.${step.handler}.config.create_entry.${step.description || "default"}`, step.description_placeholders);
    return lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
        ${description ? lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
              <ha-markdown
                allowsvg
                breaks
                .content=${description}
              ></ha-markdown>
            ` : ""}
        <p>
          ${hass.localize("ui.panel.config.integrations.config_flow.created_config", "name", step.title)}
        </p>
      `;
  }

});

/***/ }),

/***/ "./src/dialogs/config-flow/show-dialog-data-entry-flow.ts":
/*!****************************************************************!*\
  !*** ./src/dialogs/config-flow/show-dialog-data-entry-flow.ts ***!
  \****************************************************************/
/*! exports provided: loadDataEntryFlowDialog, showFlowDialog */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "loadDataEntryFlowDialog", function() { return loadDataEntryFlowDialog; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "showFlowDialog", function() { return showFlowDialog; });
/* harmony import */ var _common_dom_fire_event__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../common/dom/fire_event */ "./src/common/dom/fire_event.ts");

const loadDataEntryFlowDialog = () => Promise.all(/*! import() | dialog-config-flow */[__webpack_require__.e(1), __webpack_require__.e(0), __webpack_require__.e(2), __webpack_require__.e(3), __webpack_require__.e(6), __webpack_require__.e(7), __webpack_require__.e(8), __webpack_require__.e("vendors~cloud-webhook-manage-dialog~config-entry-system-options~confirmation~device-registry-detail-~836e8839"), __webpack_require__.e(16), __webpack_require__.e(15), __webpack_require__.e("vendors~dialog-config-flow~ha-mfa-module-setup-flow~hui-dialog-suggest-card~more-info-dialog~panel-c~e54ccf84"), __webpack_require__.e("vendors~dialog-config-flow~hui-conditional-card-editor~hui-dialog-edit-card~hui-stack-card-editor~pa~f9cbd3da"), __webpack_require__.e("vendors~dialog-config-flow~more-info-dialog~panel-config-automation~panel-config-script~person-detail-dialog"), __webpack_require__.e("vendors~dialog-config-flow~dialog-zha-device-info~more-info-dialog~onboarding-core-config"), __webpack_require__.e("vendors~dialog-config-flow~dialog-zha-device-zigbee-info~hui-dialog-suggest-card~more-info-dialog"), __webpack_require__.e("vendors~dialog-config-flow~dialog-zha-device-info~more-info-dialog"), __webpack_require__.e("vendors~device-registry-detail-dialog~dialog-config-flow"), __webpack_require__.e("vendors~dialog-config-flow"), __webpack_require__.e("dialog-config-flow~hui-conditional-card-editor~hui-dialog-edit-card~hui-stack-card-editor~hui-unused~c9cf7b12"), __webpack_require__.e("device-registry-detail-dialog~dialog-config-flow~entity-editor-dialog~panel-config-automation~panel-~da811c14"), __webpack_require__.e(21), __webpack_require__.e("dialog-config-flow~ha-mfa-module-setup-flow~more-info-dialog~panel-config-automation~panel-config-script"), __webpack_require__.e("dialog-config-flow~ha-mfa-module-setup-flow~panel-config-automation~panel-config-script"), __webpack_require__.e("device-registry-detail-dialog~dialog-config-flow"), __webpack_require__.e("dialog-config-flow")]).then(__webpack_require__.bind(null, /*! ./dialog-data-entry-flow */ "./src/dialogs/config-flow/dialog-data-entry-flow.ts"));
const showFlowDialog = (element, dialogParams, flowConfig) => {
  Object(_common_dom_fire_event__WEBPACK_IMPORTED_MODULE_0__["fireEvent"])(element, "show-dialog", {
    dialogTag: "dialog-data-entry-flow",
    dialogImport: loadDataEntryFlowDialog,
    dialogParams: Object.assign({}, dialogParams, {
      flowConfig
    })
  });
};

/***/ }),

/***/ "./src/dialogs/config-flow/show-dialog-options-flow.ts":
/*!*************************************************************!*\
  !*** ./src/dialogs/config-flow/show-dialog-options-flow.ts ***!
  \*************************************************************/
/*! exports provided: loadOptionsFlowDialog, showOptionsFlowDialog */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "loadOptionsFlowDialog", function() { return loadOptionsFlowDialog; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "showOptionsFlowDialog", function() { return showOptionsFlowDialog; });
/* harmony import */ var lit_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lit-element */ "./node_modules/lit-element/lit-element.js");
/* harmony import */ var _common_translations_localize__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../common/translations/localize */ "./src/common/translations/localize.ts");
/* harmony import */ var _data_options_flow__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../data/options_flow */ "./src/data/options_flow.ts");
/* harmony import */ var _show_dialog_data_entry_flow__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./show-dialog-data-entry-flow */ "./src/dialogs/config-flow/show-dialog-data-entry-flow.ts");




const loadOptionsFlowDialog = _show_dialog_data_entry_flow__WEBPACK_IMPORTED_MODULE_3__["loadDataEntryFlowDialog"];
const showOptionsFlowDialog = (element, configEntry) => Object(_show_dialog_data_entry_flow__WEBPACK_IMPORTED_MODULE_3__["showFlowDialog"])(element, {
  startFlowHandler: configEntry.entry_id
}, {
  loadDevicesAndAreas: false,
  createFlow: async (hass, handler) => {
    const [step] = await Promise.all([Object(_data_options_flow__WEBPACK_IMPORTED_MODULE_2__["createOptionsFlow"])(hass, handler), hass.loadBackendTranslation("options", configEntry.domain)]);
    return step;
  },
  fetchFlow: async (hass, flowId) => {
    const [step] = await Promise.all([Object(_data_options_flow__WEBPACK_IMPORTED_MODULE_2__["fetchOptionsFlow"])(hass, flowId), hass.loadBackendTranslation("options", configEntry.domain)]);
    return step;
  },
  handleFlowStep: _data_options_flow__WEBPACK_IMPORTED_MODULE_2__["handleOptionsFlowStep"],
  deleteFlow: _data_options_flow__WEBPACK_IMPORTED_MODULE_2__["deleteOptionsFlow"],

  renderAbortDescription(hass, step) {
    const description = Object(_common_translations_localize__WEBPACK_IMPORTED_MODULE_1__["localizeKey"])(hass.localize, `component.${configEntry.domain}.options.abort.${step.reason}`, step.description_placeholders);
    return description ? lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
              <ha-markdown
                breaks
                allowsvg
                .content=${description}
              ></ha-markdown>
            ` : "";
  },

  renderShowFormStepHeader(hass, step) {
    return hass.localize(`component.${configEntry.domain}.options.step.${step.step_id}.title`) || hass.localize(`ui.dialogs.options_flow.form.header`);
  },

  renderShowFormStepDescription(hass, step) {
    const description = Object(_common_translations_localize__WEBPACK_IMPORTED_MODULE_1__["localizeKey"])(hass.localize, `component.${configEntry.domain}.options.step.${step.step_id}.description`, step.description_placeholders);
    return description ? lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
              <ha-markdown
                allowsvg
                breaks
                .content=${description}
              ></ha-markdown>
            ` : "";
  },

  renderShowFormStepFieldLabel(hass, step, field) {
    return hass.localize(`component.${configEntry.domain}.options.step.${step.step_id}.data.${field.name}`);
  },

  renderShowFormStepFieldError(hass, _step, error) {
    return hass.localize(`component.${configEntry.domain}.options.error.${error}`);
  },

  renderExternalStepHeader(_hass, _step) {
    return "";
  },

  renderExternalStepDescription(_hass, _step) {
    return "";
  },

  renderCreateEntryDescription(hass, _step) {
    return lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
          <p>${hass.localize(`ui.dialogs.options_flow.success.description`)}</p>
        `;
  }

});

/***/ }),

/***/ "./src/dialogs/generic/show-dialog-box.ts":
/*!************************************************!*\
  !*** ./src/dialogs/generic/show-dialog-box.ts ***!
  \************************************************/
/*! exports provided: loadGenericDialog, showAlertDialog, showConfirmationDialog, showPromptDialog */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "loadGenericDialog", function() { return loadGenericDialog; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "showAlertDialog", function() { return showAlertDialog; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "showConfirmationDialog", function() { return showConfirmationDialog; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "showPromptDialog", function() { return showPromptDialog; });
/* harmony import */ var _common_dom_fire_event__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../common/dom/fire_event */ "./src/common/dom/fire_event.ts");

const loadGenericDialog = () => Promise.all(/*! import() | confirmation */[__webpack_require__.e(1), __webpack_require__.e(4), __webpack_require__.e(5), __webpack_require__.e("vendors~cloud-webhook-manage-dialog~config-entry-system-options~confirmation~device-registry-detail-~836e8839"), __webpack_require__.e(13), __webpack_require__.e("vendors~confirmation"), __webpack_require__.e(14), __webpack_require__.e("confirmation")]).then(__webpack_require__.bind(null, /*! ./dialog-box */ "./src/dialogs/generic/dialog-box.ts"));

const showDialogHelper = (element, dialogParams, extra) => new Promise(resolve => {
  const origCancel = dialogParams.cancel;
  const origConfirm = dialogParams.confirm;
  Object(_common_dom_fire_event__WEBPACK_IMPORTED_MODULE_0__["fireEvent"])(element, "show-dialog", {
    dialogTag: "dialog-box",
    dialogImport: loadGenericDialog,
    dialogParams: Object.assign({}, dialogParams, {}, extra, {
      cancel: () => {
        resolve((extra === null || extra === void 0 ? void 0 : extra.prompt) ? null : false);

        if (origCancel) {
          origCancel();
        }
      },
      confirm: out => {
        resolve((extra === null || extra === void 0 ? void 0 : extra.prompt) ? out : true);

        if (origConfirm) {
          origConfirm(out);
        }
      }
    })
  });
});

const showAlertDialog = (element, dialogParams) => showDialogHelper(element, dialogParams);
const showConfirmationDialog = (element, dialogParams) => showDialogHelper(element, dialogParams, {
  confirmation: true
});
const showPromptDialog = (element, dialogParams) => showDialogHelper(element, dialogParams, {
  prompt: true
});

/***/ }),

/***/ "./src/panels/config/integrations/ha-config-integrations.ts":
/*!******************************************************************!*\
  !*** ./src/panels/config/integrations/ha-config-integrations.ts ***!
  \******************************************************************/
/*! no exports provided */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _polymer_app_route_app_route__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @polymer/app-route/app-route */ "./node_modules/@polymer/app-route/app-route.js");
/* harmony import */ var lit_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lit-element */ "./node_modules/lit-element/lit-element.js");
/* harmony import */ var memoize_one__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! memoize-one */ "./node_modules/memoize-one/dist/memoize-one.esm.js");
/* harmony import */ var fuse_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! fuse.js */ "./node_modules/fuse.js/dist/fuse.js");
/* harmony import */ var fuse_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(fuse_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _common_string_compare__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../common/string/compare */ "./src/common/string/compare.ts");
/* harmony import */ var _common_util_compute_rtl__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../common/util/compute_rtl */ "./src/common/util/compute_rtl.ts");
/* harmony import */ var _common_util_render_status__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../common/util/render-status */ "./src/common/util/render-status.ts");
/* harmony import */ var _components_entity_ha_state_icon__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../components/entity/ha-state-icon */ "./src/components/entity/ha-state-icon.js");
/* harmony import */ var _components_ha_card__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../components/ha-card */ "./src/components/ha-card.ts");
/* harmony import */ var _components_ha_fab__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../../components/ha-fab */ "./src/components/ha-fab.ts");
/* harmony import */ var _data_config_entries__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../../data/config_entries */ "./src/data/config_entries.ts");
/* harmony import */ var _data_config_flow__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../../data/config_flow */ "./src/data/config_flow.ts");
/* harmony import */ var _data_device_registry__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../../data/device_registry */ "./src/data/device_registry.ts");
/* harmony import */ var _data_entity_registry__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../../data/entity_registry */ "./src/data/entity_registry.ts");
/* harmony import */ var _data_integration__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../../data/integration */ "./src/data/integration.ts");
/* harmony import */ var _dialogs_config_flow_show_dialog_config_flow__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../../dialogs/config-flow/show-dialog-config-flow */ "./src/dialogs/config-flow/show-dialog-config-flow.ts");
/* harmony import */ var _dialogs_generic_show_dialog_box__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../../dialogs/generic/show-dialog-box */ "./src/dialogs/generic/show-dialog-box.ts");
/* harmony import */ var _layouts_hass_tabs_subpage__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../../layouts/hass-tabs-subpage */ "./src/layouts/hass-tabs-subpage.ts");
/* harmony import */ var _mixins_subscribe_mixin__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../../../mixins/subscribe-mixin */ "./src/mixins/subscribe-mixin.ts");
/* harmony import */ var _resources_styles__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../../../resources/styles */ "./src/resources/styles.ts");
/* harmony import */ var _ha_panel_config__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../ha-panel-config */ "./src/panels/config/ha-panel-config.ts");
/* harmony import */ var _common_search_search_input__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../../../common/search/search-input */ "./src/common/search/search-input.ts");
/* harmony import */ var _ha_integration_card__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./ha-integration-card */ "./src/panels/config/integrations/ha-integration-card.ts");
function _decorate(decorators, factory, superClass, mixins) { var api = _getDecoratorsApi(); if (mixins) { for (var i = 0; i < mixins.length; i++) { api = mixins[i](api); } } var r = factory(function initialize(O) { api.initializeInstanceElements(O, decorated.elements); }, superClass); var decorated = api.decorateClass(_coalesceClassElements(r.d.map(_createElementDescriptor)), decorators); api.initializeClassElements(r.F, decorated.elements); return api.runClassFinishers(r.F, decorated.finishers); }

function _getDecoratorsApi() { _getDecoratorsApi = function () { return api; }; var api = { elementsDefinitionOrder: [["method"], ["field"]], initializeInstanceElements: function (O, elements) { ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { if (element.kind === kind && element.placement === "own") { this.defineClassElement(O, element); } }, this); }, this); }, initializeClassElements: function (F, elements) { var proto = F.prototype; ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { var placement = element.placement; if (element.kind === kind && (placement === "static" || placement === "prototype")) { var receiver = placement === "static" ? F : proto; this.defineClassElement(receiver, element); } }, this); }, this); }, defineClassElement: function (receiver, element) { var descriptor = element.descriptor; if (element.kind === "field") { var initializer = element.initializer; descriptor = { enumerable: descriptor.enumerable, writable: descriptor.writable, configurable: descriptor.configurable, value: initializer === void 0 ? void 0 : initializer.call(receiver) }; } Object.defineProperty(receiver, element.key, descriptor); }, decorateClass: function (elements, decorators) { var newElements = []; var finishers = []; var placements = { static: [], prototype: [], own: [] }; elements.forEach(function (element) { this.addElementPlacement(element, placements); }, this); elements.forEach(function (element) { if (!_hasDecorators(element)) return newElements.push(element); var elementFinishersExtras = this.decorateElement(element, placements); newElements.push(elementFinishersExtras.element); newElements.push.apply(newElements, elementFinishersExtras.extras); finishers.push.apply(finishers, elementFinishersExtras.finishers); }, this); if (!decorators) { return { elements: newElements, finishers: finishers }; } var result = this.decorateConstructor(newElements, decorators); finishers.push.apply(finishers, result.finishers); result.finishers = finishers; return result; }, addElementPlacement: function (element, placements, silent) { var keys = placements[element.placement]; if (!silent && keys.indexOf(element.key) !== -1) { throw new TypeError("Duplicated element (" + element.key + ")"); } keys.push(element.key); }, decorateElement: function (element, placements) { var extras = []; var finishers = []; for (var decorators = element.decorators, i = decorators.length - 1; i >= 0; i--) { var keys = placements[element.placement]; keys.splice(keys.indexOf(element.key), 1); var elementObject = this.fromElementDescriptor(element); var elementFinisherExtras = this.toElementFinisherExtras((0, decorators[i])(elementObject) || elementObject); element = elementFinisherExtras.element; this.addElementPlacement(element, placements); if (elementFinisherExtras.finisher) { finishers.push(elementFinisherExtras.finisher); } var newExtras = elementFinisherExtras.extras; if (newExtras) { for (var j = 0; j < newExtras.length; j++) { this.addElementPlacement(newExtras[j], placements); } extras.push.apply(extras, newExtras); } } return { element: element, finishers: finishers, extras: extras }; }, decorateConstructor: function (elements, decorators) { var finishers = []; for (var i = decorators.length - 1; i >= 0; i--) { var obj = this.fromClassDescriptor(elements); var elementsAndFinisher = this.toClassDescriptor((0, decorators[i])(obj) || obj); if (elementsAndFinisher.finisher !== undefined) { finishers.push(elementsAndFinisher.finisher); } if (elementsAndFinisher.elements !== undefined) { elements = elementsAndFinisher.elements; for (var j = 0; j < elements.length - 1; j++) { for (var k = j + 1; k < elements.length; k++) { if (elements[j].key === elements[k].key && elements[j].placement === elements[k].placement) { throw new TypeError("Duplicated element (" + elements[j].key + ")"); } } } } } return { elements: elements, finishers: finishers }; }, fromElementDescriptor: function (element) { var obj = { kind: element.kind, key: element.key, placement: element.placement, descriptor: element.descriptor }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); if (element.kind === "field") obj.initializer = element.initializer; return obj; }, toElementDescriptors: function (elementObjects) { if (elementObjects === undefined) return; return _toArray(elementObjects).map(function (elementObject) { var element = this.toElementDescriptor(elementObject); this.disallowProperty(elementObject, "finisher", "An element descriptor"); this.disallowProperty(elementObject, "extras", "An element descriptor"); return element; }, this); }, toElementDescriptor: function (elementObject) { var kind = String(elementObject.kind); if (kind !== "method" && kind !== "field") { throw new TypeError('An element descriptor\'s .kind property must be either "method" or' + ' "field", but a decorator created an element descriptor with' + ' .kind "' + kind + '"'); } var key = _toPropertyKey(elementObject.key); var placement = String(elementObject.placement); if (placement !== "static" && placement !== "prototype" && placement !== "own") { throw new TypeError('An element descriptor\'s .placement property must be one of "static",' + ' "prototype" or "own", but a decorator created an element descriptor' + ' with .placement "' + placement + '"'); } var descriptor = elementObject.descriptor; this.disallowProperty(elementObject, "elements", "An element descriptor"); var element = { kind: kind, key: key, placement: placement, descriptor: Object.assign({}, descriptor) }; if (kind !== "field") { this.disallowProperty(elementObject, "initializer", "A method descriptor"); } else { this.disallowProperty(descriptor, "get", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "set", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "value", "The property descriptor of a field descriptor"); element.initializer = elementObject.initializer; } return element; }, toElementFinisherExtras: function (elementObject) { var element = this.toElementDescriptor(elementObject); var finisher = _optionalCallableProperty(elementObject, "finisher"); var extras = this.toElementDescriptors(elementObject.extras); return { element: element, finisher: finisher, extras: extras }; }, fromClassDescriptor: function (elements) { var obj = { kind: "class", elements: elements.map(this.fromElementDescriptor, this) }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); return obj; }, toClassDescriptor: function (obj) { var kind = String(obj.kind); if (kind !== "class") { throw new TypeError('A class descriptor\'s .kind property must be "class", but a decorator' + ' created a class descriptor with .kind "' + kind + '"'); } this.disallowProperty(obj, "key", "A class descriptor"); this.disallowProperty(obj, "placement", "A class descriptor"); this.disallowProperty(obj, "descriptor", "A class descriptor"); this.disallowProperty(obj, "initializer", "A class descriptor"); this.disallowProperty(obj, "extras", "A class descriptor"); var finisher = _optionalCallableProperty(obj, "finisher"); var elements = this.toElementDescriptors(obj.elements); return { elements: elements, finisher: finisher }; }, runClassFinishers: function (constructor, finishers) { for (var i = 0; i < finishers.length; i++) { var newConstructor = (0, finishers[i])(constructor); if (newConstructor !== undefined) { if (typeof newConstructor !== "function") { throw new TypeError("Finishers must return a constructor."); } constructor = newConstructor; } } return constructor; }, disallowProperty: function (obj, name, objectType) { if (obj[name] !== undefined) { throw new TypeError(objectType + " can't have a ." + name + " property."); } } }; return api; }

function _createElementDescriptor(def) { var key = _toPropertyKey(def.key); var descriptor; if (def.kind === "method") { descriptor = { value: def.value, writable: true, configurable: true, enumerable: false }; } else if (def.kind === "get") { descriptor = { get: def.value, configurable: true, enumerable: false }; } else if (def.kind === "set") { descriptor = { set: def.value, configurable: true, enumerable: false }; } else if (def.kind === "field") { descriptor = { configurable: true, writable: true, enumerable: true }; } var element = { kind: def.kind === "field" ? "field" : "method", key: key, placement: def.static ? "static" : def.kind === "field" ? "own" : "prototype", descriptor: descriptor }; if (def.decorators) element.decorators = def.decorators; if (def.kind === "field") element.initializer = def.value; return element; }

function _coalesceGetterSetter(element, other) { if (element.descriptor.get !== undefined) { other.descriptor.get = element.descriptor.get; } else { other.descriptor.set = element.descriptor.set; } }

function _coalesceClassElements(elements) { var newElements = []; var isSameElement = function (other) { return other.kind === "method" && other.key === element.key && other.placement === element.placement; }; for (var i = 0; i < elements.length; i++) { var element = elements[i]; var other; if (element.kind === "method" && (other = newElements.find(isSameElement))) { if (_isDataDescriptor(element.descriptor) || _isDataDescriptor(other.descriptor)) { if (_hasDecorators(element) || _hasDecorators(other)) { throw new ReferenceError("Duplicated methods (" + element.key + ") can't be decorated."); } other.descriptor = element.descriptor; } else { if (_hasDecorators(element)) { if (_hasDecorators(other)) { throw new ReferenceError("Decorators can't be placed on different accessors with for " + "the same property (" + element.key + ")."); } other.decorators = element.decorators; } _coalesceGetterSetter(element, other); } } else { newElements.push(element); } } return newElements; }

function _hasDecorators(element) { return element.decorators && element.decorators.length; }

function _isDataDescriptor(desc) { return desc !== undefined && !(desc.value === undefined && desc.writable === undefined); }

function _optionalCallableProperty(obj, name) { var value = obj[name]; if (value !== undefined && typeof value !== "function") { throw new TypeError("Expected '" + name + "' to be a function"); } return value; }

function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }

function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }

function _toArray(arr) { return _arrayWithHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(n); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get; } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return _get(target, property, receiver || target); }

function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

























const groupByIntegration = entries => {
  const result = new Map();
  entries.forEach(entry => {
    if (result.has(entry.domain)) {
      result.get(entry.domain).push(entry);
    } else {
      result.set(entry.domain, [entry]);
    }
  });
  return result;
};

let HaConfigIntegrations = _decorate([Object(lit_element__WEBPACK_IMPORTED_MODULE_1__["customElement"])("ha-config-integrations")], function (_initialize, _SubscribeMixin) {
  class HaConfigIntegrations extends _SubscribeMixin {
    constructor(...args) {
      super(...args);

      _initialize(this);
    }

  }

  return {
    F: HaConfigIntegrations,
    d: [{
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_1__["property"])()],
      key: "hass",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_1__["property"])()],
      key: "narrow",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_1__["property"])()],
      key: "isWide",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_1__["property"])()],
      key: "showAdvanced",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_1__["property"])()],
      key: "route",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_1__["property"])()],
      key: "_configEntries",

      value() {
        return [];
      }

    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_1__["property"])()],
      key: "_configEntriesInProgress",

      value() {
        return [];
      }

    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_1__["property"])()],
      key: "_entityRegistryEntries",

      value() {
        return [];
      }

    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_1__["property"])()],
      key: "_deviceRegistryEntries",

      value() {
        return [];
      }

    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_1__["property"])()],
      key: "_showIgnored",

      value() {
        return false;
      }

    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_1__["property"])()],
      key: "_searchParms",

      value() {
        return new URLSearchParams(window.location.hash.substring(1));
      }

    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_1__["property"])()],
      key: "_filter",
      value: void 0
    }, {
      kind: "method",
      key: "hassSubscribe",
      value: function hassSubscribe() {
        return [Object(_data_entity_registry__WEBPACK_IMPORTED_MODULE_13__["subscribeEntityRegistry"])(this.hass.connection, entries => {
          this._entityRegistryEntries = entries;
        }), Object(_data_device_registry__WEBPACK_IMPORTED_MODULE_12__["subscribeDeviceRegistry"])(this.hass.connection, entries => {
          this._deviceRegistryEntries = entries;
        }), Object(_data_config_flow__WEBPACK_IMPORTED_MODULE_11__["subscribeConfigFlowInProgress"])(this.hass, async flowsInProgress => {
          const translationsPromisses = [];
          flowsInProgress.forEach(flow => {
            // To render title placeholders
            if (flow.context.title_placeholders) {
              translationsPromisses.push(this.hass.loadBackendTranslation("config", flow.handler));
            }
          });
          await Promise.all(translationsPromisses);
          await Object(_common_util_render_status__WEBPACK_IMPORTED_MODULE_6__["nextRender"])();
          this._configEntriesInProgress = flowsInProgress.map(flow => {
            return Object.assign({}, flow, {
              localized_title: Object(_data_config_flow__WEBPACK_IMPORTED_MODULE_11__["localizeConfigFlowTitle"])(this.hass.localize, flow)
            });
          });
        })];
      }
    }, {
      kind: "field",
      key: "_filterConfigEntries",

      value() {
        return Object(memoize_one__WEBPACK_IMPORTED_MODULE_2__["default"])((configEntries, filter) => {
          if (!filter) {
            return configEntries;
          }

          const options = {
            keys: ["domain", "localized_domain_name", "title"],
            caseSensitive: false,
            minMatchCharLength: 2,
            threshold: 0.2
          };
          const fuse = new fuse_js__WEBPACK_IMPORTED_MODULE_3__(configEntries, options);
          return fuse.search(filter);
        });
      }

    }, {
      kind: "field",
      key: "_filterGroupConfigEntries",

      value() {
        return Object(memoize_one__WEBPACK_IMPORTED_MODULE_2__["default"])((configEntries, filter) => {
          const filteredConfigEnties = this._filterConfigEntries(configEntries, filter);

          const ignored = [];
          filteredConfigEnties.forEach((item, index) => {
            if (item.source === "ignore") {
              ignored.push(filteredConfigEnties.splice(index, 1)[0]);
            }
          });
          return [groupByIntegration(filteredConfigEnties), ignored];
        });
      }

    }, {
      kind: "field",
      key: "_filterConfigEntriesInProgress",

      value() {
        return Object(memoize_one__WEBPACK_IMPORTED_MODULE_2__["default"])((configEntriesInProgress, filter) => {
          configEntriesInProgress = configEntriesInProgress.map(flow => Object.assign({}, flow, {
            title: Object(_data_config_flow__WEBPACK_IMPORTED_MODULE_11__["localizeConfigFlowTitle"])(this.hass.localize, flow)
          }));

          if (!filter) {
            return configEntriesInProgress;
          }

          const options = {
            keys: ["handler", "localized_title"],
            caseSensitive: false,
            minMatchCharLength: 2,
            threshold: 0.2
          };
          const fuse = new fuse_js__WEBPACK_IMPORTED_MODULE_3__(configEntriesInProgress, options);
          return fuse.search(filter);
        });
      }

    }, {
      kind: "method",
      key: "firstUpdated",
      value: function firstUpdated(changed) {
        _get(_getPrototypeOf(HaConfigIntegrations.prototype), "firstUpdated", this).call(this, changed);

        this._loadConfigEntries();

        this.hass.loadBackendTranslation("title", undefined, true);
      }
    }, {
      kind: "method",
      key: "updated",
      value: function updated(changed) {
        _get(_getPrototypeOf(HaConfigIntegrations.prototype), "updated", this).call(this, changed);

        if (this._searchParms.has("config_entry") && changed.has("_configEntries") && !changed.get("_configEntries").length && this._configEntries.length) {
          Object(_common_util_render_status__WEBPACK_IMPORTED_MODULE_6__["afterNextRender"])(() => {
            const entryId = this._searchParms.get("config_entry");

            const configEntry = this._configEntries.find(entry => entry.entry_id === entryId);

            if (!configEntry) {
              return;
            }

            const card = this.shadowRoot.querySelector(`[data-domain=${configEntry === null || configEntry === void 0 ? void 0 : configEntry.domain}]`);

            if (card) {
              card.scrollIntoView({
                block: "center"
              });
              card.classList.add("highlight");
              card.selectedConfigEntryId = entryId;
            }
          });
        }
      }
    }, {
      kind: "method",
      key: "render",
      value: function render() {
        const [groupedConfigEntries, ignoredConfigEntries] = this._filterGroupConfigEntries(this._configEntries, this._filter);

        const configEntriesInProgress = this._filterConfigEntriesInProgress(this._configEntriesInProgress, this._filter);

        return lit_element__WEBPACK_IMPORTED_MODULE_1__["html"]`
      <hass-tabs-subpage
        .hass=${this.hass}
        .narrow=${this.narrow}
        back-path="/config"
        .route=${this.route}
        .tabs=${_ha_panel_config__WEBPACK_IMPORTED_MODULE_20__["configSections"].integrations}
      >
        ${this.narrow ? lit_element__WEBPACK_IMPORTED_MODULE_1__["html"]`
              <div slot="header">
                <slot name="header">
                  <search-input
                    .filter=${this._filter}
                    class="header"
                    no-label-float
                    no-underline
                    @value-changed=${this._handleSearchChange}
                  ></search-input>
                </slot>
              </div>
            ` : ""}
        <paper-menu-button
          close-on-activate
          no-animations
          horizontal-align="right"
          horizontal-offset="-5"
          slot="toolbar-icon"
        >
          <paper-icon-button
            icon="hass:dots-vertical"
            slot="dropdown-trigger"
            alt="menu"
          ></paper-icon-button>
          <paper-listbox slot="dropdown-content" role="listbox">
            <paper-item @tap=${this._toggleShowIgnored}>
              ${this.hass.localize(this._showIgnored ? "ui.panel.config.integrations.ignore.hide_ignored" : "ui.panel.config.integrations.ignore.show_ignored")}
            </paper-item>
          </paper-listbox>
        </paper-menu-button>

        ${!this.narrow ? lit_element__WEBPACK_IMPORTED_MODULE_1__["html"]`
              <div class="search">
                <search-input
                  no-label-float
                  no-underline
                  .filter=${this._filter}
                  @value-changed=${this._handleSearchChange}
                ></search-input>
              </div>
            ` : ""}

        <div
          class="container"
          @entry-removed=${this._handleRemoved}
          @entry-updated=${this._handleUpdated}
        >
          ${this._showIgnored ? ignoredConfigEntries.map(item => lit_element__WEBPACK_IMPORTED_MODULE_1__["html"]`
                  <ha-card class="ignored">
                    <div class="header">
                      ${this.hass.localize("ui.panel.config.integrations.ignore.ignored")}
                    </div>
                    <div class="card-content">
                      <div class="image">
                        <img
                          src="https://brands.home-assistant.io/${item.domain}/logo.png"
                          referrerpolicy="no-referrer"
                          @error=${this._onImageError}
                          @load=${this._onImageLoad}
                        />
                      </div>
                      <h2>
                        ${item.localized_domain_name}
                      </h2>
                      <mwc-button
                        @click=${this._removeIgnoredIntegration}
                        .entry=${item}
                        aria-label=${this.hass.localize("ui.panel.config.integrations.ignore.stop_ignore")}
                        >${this.hass.localize("ui.panel.config.integrations.ignore.stop_ignore")}</mwc-button
                      >
                    </div>
                  </ha-card>
                `) : ""}
          ${configEntriesInProgress.length ? configEntriesInProgress.map(flow => lit_element__WEBPACK_IMPORTED_MODULE_1__["html"]`
                  <ha-card class="discovered">
                    <div class="header">
                      ${this.hass.localize("ui.panel.config.integrations.discovered")}
                    </div>
                    <div class="card-content">
                      <div class="image">
                        <img
                          src="https://brands.home-assistant.io/${flow.handler}/logo.png"
                          referrerpolicy="no-referrer"
                          @error=${this._onImageError}
                          @load=${this._onImageLoad}
                        />
                      </div>
                      <h2>
                        ${flow.localized_title}
                      </h2>
                      <div>
                        <mwc-button
                          unelevated
                          @click=${this._continueFlow}
                          .flowId=${flow.flow_id}
                        >
                          ${this.hass.localize("ui.panel.config.integrations.configure")}
                        </mwc-button>
                        ${_data_config_flow__WEBPACK_IMPORTED_MODULE_11__["DISCOVERY_SOURCES"].includes(flow.context.source) && flow.context.unique_id ? lit_element__WEBPACK_IMPORTED_MODULE_1__["html"]`
                              <mwc-button
                                @click=${this._ignoreFlow}
                                .flow=${flow}
                              >
                                ${this.hass.localize("ui.panel.config.integrations.ignore.ignore")}
                              </mwc-button>
                            ` : ""}
                      </div>
                    </div>
                  </ha-card>
                `) : ""}
          ${groupedConfigEntries.size ? Array.from(groupedConfigEntries.entries()).map(([domain, items]) => lit_element__WEBPACK_IMPORTED_MODULE_1__["html"]`<ha-integration-card
                    data-domain=${domain}
                    .hass=${this.hass}
                    .domain=${domain}
                    .items=${items}
                    .entityRegistryEntries=${this._entityRegistryEntries}
                    .deviceRegistryEntries=${this._deviceRegistryEntries}
                  ></ha-integration-card>`) : !this._configEntries.length ? lit_element__WEBPACK_IMPORTED_MODULE_1__["html"]`
                <ha-card>
                  <div class="card-content">
                    <h1>
                      ${this.hass.localize("ui.panel.config.integrations.none")}
                    </h1>
                    <p>
                      ${this.hass.localize("ui.panel.config.integrations.no_integrations")}
                    </p>
                    <mwc-button @click=${this._createFlow} unelevated
                      >${this.hass.localize("ui.panel.config.integrations.add")}</mwc-button
                    >
                  </div>
                </ha-card>
              ` : ""}
          ${this._filter && !configEntriesInProgress.length && !groupedConfigEntries.size && this._configEntries.length ? lit_element__WEBPACK_IMPORTED_MODULE_1__["html"]`
                <div class="none-found">
                  <h1>
                    ${this.hass.localize("ui.panel.config.integrations.none_found")}
                  </h1>
                  <p>
                    ${this.hass.localize("ui.panel.config.integrations.none_found_detail")}
                  </p>
                </div>
              ` : ""}
        </div>
        <ha-fab
          icon="hass:plus"
          aria-label=${this.hass.localize("ui.panel.config.integrations.new")}
          title=${this.hass.localize("ui.panel.config.integrations.new")}
          @click=${this._createFlow}
          ?is-wide=${this.isWide}
          ?narrow=${this.narrow}
          ?rtl=${Object(_common_util_compute_rtl__WEBPACK_IMPORTED_MODULE_5__["computeRTL"])(this.hass)}
        ></ha-fab>
      </hass-tabs-subpage>
    `;
      }
    }, {
      kind: "method",
      key: "_loadConfigEntries",
      value: function _loadConfigEntries() {
        Object(_data_config_entries__WEBPACK_IMPORTED_MODULE_10__["getConfigEntries"])(this.hass).then(configEntries => {
          this._configEntries = configEntries.map(entry => Object.assign({}, entry, {
            localized_domain_name: Object(_data_integration__WEBPACK_IMPORTED_MODULE_14__["domainToName"])(this.hass.localize, entry.domain)
          })).sort((conf1, conf2) => Object(_common_string_compare__WEBPACK_IMPORTED_MODULE_4__["caseInsensitiveCompare"])(conf1.localized_domain_name + conf1.title, conf2.localized_domain_name + conf2.title));
        });
      }
    }, {
      kind: "method",
      key: "_handleRemoved",
      value: function _handleRemoved(ev) {
        this._configEntries = this._configEntries.filter(entry => entry.entry_id !== ev.detail.entryId);
      }
    }, {
      kind: "method",
      key: "_handleUpdated",
      value: function _handleUpdated(ev) {
        const newEntry = ev.detail.entry;
        this._configEntries = this._configEntries.map(entry => entry.entry_id === newEntry.entry_id ? Object.assign({}, newEntry, {
          localized_domain_name: entry.localized_domain_name
        }) : entry);
      }
    }, {
      kind: "method",
      key: "_createFlow",
      value: function _createFlow() {
        Object(_dialogs_config_flow_show_dialog_config_flow__WEBPACK_IMPORTED_MODULE_15__["showConfigFlowDialog"])(this, {
          dialogClosedCallback: () => {
            this._loadConfigEntries();

            Object(_data_config_flow__WEBPACK_IMPORTED_MODULE_11__["getConfigFlowInProgressCollection"])(this.hass.connection).refresh();
          },
          showAdvanced: this.showAdvanced
        }); // For config entries. Also loading config flow ones for add integration

        this.hass.loadBackendTranslation("title", undefined, true);
      }
    }, {
      kind: "method",
      key: "_continueFlow",
      value: function _continueFlow(ev) {
        Object(_dialogs_config_flow_show_dialog_config_flow__WEBPACK_IMPORTED_MODULE_15__["showConfigFlowDialog"])(this, {
          continueFlowId: ev.target.flowId,
          dialogClosedCallback: () => {
            this._loadConfigEntries();

            Object(_data_config_flow__WEBPACK_IMPORTED_MODULE_11__["getConfigFlowInProgressCollection"])(this.hass.connection).refresh();
          }
        });
      }
    }, {
      kind: "method",
      key: "_ignoreFlow",
      value: async function _ignoreFlow(ev) {
        const flow = ev.target.flow;
        const confirmed = await Object(_dialogs_generic_show_dialog_box__WEBPACK_IMPORTED_MODULE_16__["showConfirmationDialog"])(this, {
          title: this.hass.localize("ui.panel.config.integrations.ignore.confirm_ignore_title", "name", Object(_data_config_flow__WEBPACK_IMPORTED_MODULE_11__["localizeConfigFlowTitle"])(this.hass.localize, flow)),
          text: this.hass.localize("ui.panel.config.integrations.ignore.confirm_ignore"),
          confirmText: this.hass.localize("ui.panel.config.integrations.ignore.ignore")
        });

        if (!confirmed) {
          return;
        }

        await Object(_data_config_flow__WEBPACK_IMPORTED_MODULE_11__["ignoreConfigFlow"])(this.hass, flow.flow_id);

        this._loadConfigEntries();

        Object(_data_config_flow__WEBPACK_IMPORTED_MODULE_11__["getConfigFlowInProgressCollection"])(this.hass.connection).refresh();
      }
    }, {
      kind: "method",
      key: "_toggleShowIgnored",
      value: function _toggleShowIgnored() {
        this._showIgnored = !this._showIgnored;
      }
    }, {
      kind: "method",
      key: "_removeIgnoredIntegration",
      value: async function _removeIgnoredIntegration(ev) {
        const entry = ev.target.entry;
        Object(_dialogs_generic_show_dialog_box__WEBPACK_IMPORTED_MODULE_16__["showConfirmationDialog"])(this, {
          title: this.hass.localize("ui.panel.config.integrations.ignore.confirm_delete_ignore_title", "name", this.hass.localize(`component.${entry.domain}.title`)),
          text: this.hass.localize("ui.panel.config.integrations.ignore.confirm_delete_ignore"),
          confirmText: this.hass.localize("ui.panel.config.integrations.ignore.stop_ignore"),
          confirm: async () => {
            const result = await Object(_data_config_entries__WEBPACK_IMPORTED_MODULE_10__["deleteConfigEntry"])(this.hass, entry.entry_id);

            if (result.require_restart) {
              alert(this.hass.localize("ui.panel.config.integrations.config_entry.restart_confirm"));
            }

            this._loadConfigEntries();
          }
        });
      }
    }, {
      kind: "method",
      key: "_handleSearchChange",
      value: function _handleSearchChange(ev) {
        this._filter = ev.detail.value;
      }
    }, {
      kind: "method",
      key: "_onImageLoad",
      value: function _onImageLoad(ev) {
        ev.target.style.visibility = "initial";
      }
    }, {
      kind: "method",
      key: "_onImageError",
      value: function _onImageError(ev) {
        ev.target.style.visibility = "hidden";
      }
    }, {
      kind: "get",
      static: true,
      key: "styles",
      value: function styles() {
        return [_resources_styles__WEBPACK_IMPORTED_MODULE_19__["haStyle"], lit_element__WEBPACK_IMPORTED_MODULE_1__["css"]`
        .container {
          display: grid;
          grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
          grid-gap: 16px 16px;
          padding: 8px 16px 16px;
          margin-bottom: 64px;
        }
        ha-card {
          max-width: 500px;
          display: flex;
          flex-direction: column;
          justify-content: space-between;
        }
        .discovered {
          border: 1px solid var(--primary-color);
        }
        .discovered .header {
          background: var(--primary-color);
          color: var(--text-primary-color);
          padding: 8px;
          text-align: center;
        }
        .ignored {
          border: 1px solid var(--light-theme-disabled-color);
        }
        .ignored .header {
          background: var(--light-theme-disabled-color);
          color: var(--text-primary-color);
          padding: 8px;
          text-align: center;
        }
        .card-content {
          display: flex;
          height: 100%;
          margin-top: 0;
          padding: 16px;
          text-align: center;
          flex-direction: column;
          justify-content: space-between;
        }
        .image {
          display: flex;
          align-items: center;
          justify-content: center;
          height: 60px;
          margin-bottom: 16px;
          vertical-align: middle;
        }
        .none-found {
          margin: auto;
          text-align: center;
        }
        search-input.header {
          display: block;
          position: relative;
          left: -8px;
          top: -7px;
          color: var(--secondary-text-color);
          margin-left: 16px;
        }
        .search {
          padding: 0 16px;
          background: var(--sidebar-background-color);
          border-bottom: 1px solid var(--divider-color);
        }
        .search search-input {
          position: relative;
          top: 2px;
        }
        img {
          max-height: 100%;
          max-width: 90%;
        }
        .none-found {
          margin: auto;
          text-align: center;
        }
        h1 {
          margin-bottom: 0;
        }
        h2 {
          margin-top: 0;
        }
        ha-fab {
          position: fixed;
          bottom: 16px;
          right: 16px;
          z-index: 1;
        }
        ha-fab[is-wide] {
          bottom: 24px;
          right: 24px;
        }
        ha-fab[narrow] {
          bottom: 84px;
        }
        ha-fab[rtl] {
          right: auto;
          left: 16px;
        }
        ha-fab[is-wide].rtl {
          bottom: 24px;
          left: 24px;
          right: auto;
        }
      `];
      }
    }]
  };
}, Object(_mixins_subscribe_mixin__WEBPACK_IMPORTED_MODULE_18__["SubscribeMixin"])(lit_element__WEBPACK_IMPORTED_MODULE_1__["LitElement"]));

/***/ }),

/***/ "./src/panels/config/integrations/ha-integration-card.ts":
/*!***************************************************************!*\
  !*** ./src/panels/config/integrations/ha-integration-card.ts ***!
  \***************************************************************/
/*! exports provided: HaIntegrationCard */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HaIntegrationCard", function() { return HaIntegrationCard; });
/* harmony import */ var lit_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lit-element */ "./node_modules/lit-element/lit-element.js");
/* harmony import */ var _data_integration__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../data/integration */ "./src/data/integration.ts");
/* harmony import */ var _data_config_entries__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../data/config_entries */ "./src/data/config_entries.ts");
/* harmony import */ var _dialogs_config_flow_show_dialog_options_flow__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../dialogs/config-flow/show-dialog-options-flow */ "./src/dialogs/config-flow/show-dialog-options-flow.ts");
/* harmony import */ var _dialogs_config_entry_system_options_show_dialog_config_entry_system_options__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../dialogs/config-entry-system-options/show-dialog-config-entry-system-options */ "./src/dialogs/config-entry-system-options/show-dialog-config-entry-system-options.ts");
/* harmony import */ var _dialogs_generic_show_dialog_box__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../dialogs/generic/show-dialog-box */ "./src/dialogs/generic/show-dialog-box.ts");
/* harmony import */ var _resources_styles__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../resources/styles */ "./src/resources/styles.ts");
/* harmony import */ var _components_ha_icon_next__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../components/ha-icon-next */ "./src/components/ha-icon-next.ts");
/* harmony import */ var _common_dom_fire_event__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../common/dom/fire_event */ "./src/common/dom/fire_event.ts");
function _decorate(decorators, factory, superClass, mixins) { var api = _getDecoratorsApi(); if (mixins) { for (var i = 0; i < mixins.length; i++) { api = mixins[i](api); } } var r = factory(function initialize(O) { api.initializeInstanceElements(O, decorated.elements); }, superClass); var decorated = api.decorateClass(_coalesceClassElements(r.d.map(_createElementDescriptor)), decorators); api.initializeClassElements(r.F, decorated.elements); return api.runClassFinishers(r.F, decorated.finishers); }

function _getDecoratorsApi() { _getDecoratorsApi = function () { return api; }; var api = { elementsDefinitionOrder: [["method"], ["field"]], initializeInstanceElements: function (O, elements) { ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { if (element.kind === kind && element.placement === "own") { this.defineClassElement(O, element); } }, this); }, this); }, initializeClassElements: function (F, elements) { var proto = F.prototype; ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { var placement = element.placement; if (element.kind === kind && (placement === "static" || placement === "prototype")) { var receiver = placement === "static" ? F : proto; this.defineClassElement(receiver, element); } }, this); }, this); }, defineClassElement: function (receiver, element) { var descriptor = element.descriptor; if (element.kind === "field") { var initializer = element.initializer; descriptor = { enumerable: descriptor.enumerable, writable: descriptor.writable, configurable: descriptor.configurable, value: initializer === void 0 ? void 0 : initializer.call(receiver) }; } Object.defineProperty(receiver, element.key, descriptor); }, decorateClass: function (elements, decorators) { var newElements = []; var finishers = []; var placements = { static: [], prototype: [], own: [] }; elements.forEach(function (element) { this.addElementPlacement(element, placements); }, this); elements.forEach(function (element) { if (!_hasDecorators(element)) return newElements.push(element); var elementFinishersExtras = this.decorateElement(element, placements); newElements.push(elementFinishersExtras.element); newElements.push.apply(newElements, elementFinishersExtras.extras); finishers.push.apply(finishers, elementFinishersExtras.finishers); }, this); if (!decorators) { return { elements: newElements, finishers: finishers }; } var result = this.decorateConstructor(newElements, decorators); finishers.push.apply(finishers, result.finishers); result.finishers = finishers; return result; }, addElementPlacement: function (element, placements, silent) { var keys = placements[element.placement]; if (!silent && keys.indexOf(element.key) !== -1) { throw new TypeError("Duplicated element (" + element.key + ")"); } keys.push(element.key); }, decorateElement: function (element, placements) { var extras = []; var finishers = []; for (var decorators = element.decorators, i = decorators.length - 1; i >= 0; i--) { var keys = placements[element.placement]; keys.splice(keys.indexOf(element.key), 1); var elementObject = this.fromElementDescriptor(element); var elementFinisherExtras = this.toElementFinisherExtras((0, decorators[i])(elementObject) || elementObject); element = elementFinisherExtras.element; this.addElementPlacement(element, placements); if (elementFinisherExtras.finisher) { finishers.push(elementFinisherExtras.finisher); } var newExtras = elementFinisherExtras.extras; if (newExtras) { for (var j = 0; j < newExtras.length; j++) { this.addElementPlacement(newExtras[j], placements); } extras.push.apply(extras, newExtras); } } return { element: element, finishers: finishers, extras: extras }; }, decorateConstructor: function (elements, decorators) { var finishers = []; for (var i = decorators.length - 1; i >= 0; i--) { var obj = this.fromClassDescriptor(elements); var elementsAndFinisher = this.toClassDescriptor((0, decorators[i])(obj) || obj); if (elementsAndFinisher.finisher !== undefined) { finishers.push(elementsAndFinisher.finisher); } if (elementsAndFinisher.elements !== undefined) { elements = elementsAndFinisher.elements; for (var j = 0; j < elements.length - 1; j++) { for (var k = j + 1; k < elements.length; k++) { if (elements[j].key === elements[k].key && elements[j].placement === elements[k].placement) { throw new TypeError("Duplicated element (" + elements[j].key + ")"); } } } } } return { elements: elements, finishers: finishers }; }, fromElementDescriptor: function (element) { var obj = { kind: element.kind, key: element.key, placement: element.placement, descriptor: element.descriptor }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); if (element.kind === "field") obj.initializer = element.initializer; return obj; }, toElementDescriptors: function (elementObjects) { if (elementObjects === undefined) return; return _toArray(elementObjects).map(function (elementObject) { var element = this.toElementDescriptor(elementObject); this.disallowProperty(elementObject, "finisher", "An element descriptor"); this.disallowProperty(elementObject, "extras", "An element descriptor"); return element; }, this); }, toElementDescriptor: function (elementObject) { var kind = String(elementObject.kind); if (kind !== "method" && kind !== "field") { throw new TypeError('An element descriptor\'s .kind property must be either "method" or' + ' "field", but a decorator created an element descriptor with' + ' .kind "' + kind + '"'); } var key = _toPropertyKey(elementObject.key); var placement = String(elementObject.placement); if (placement !== "static" && placement !== "prototype" && placement !== "own") { throw new TypeError('An element descriptor\'s .placement property must be one of "static",' + ' "prototype" or "own", but a decorator created an element descriptor' + ' with .placement "' + placement + '"'); } var descriptor = elementObject.descriptor; this.disallowProperty(elementObject, "elements", "An element descriptor"); var element = { kind: kind, key: key, placement: placement, descriptor: Object.assign({}, descriptor) }; if (kind !== "field") { this.disallowProperty(elementObject, "initializer", "A method descriptor"); } else { this.disallowProperty(descriptor, "get", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "set", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "value", "The property descriptor of a field descriptor"); element.initializer = elementObject.initializer; } return element; }, toElementFinisherExtras: function (elementObject) { var element = this.toElementDescriptor(elementObject); var finisher = _optionalCallableProperty(elementObject, "finisher"); var extras = this.toElementDescriptors(elementObject.extras); return { element: element, finisher: finisher, extras: extras }; }, fromClassDescriptor: function (elements) { var obj = { kind: "class", elements: elements.map(this.fromElementDescriptor, this) }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); return obj; }, toClassDescriptor: function (obj) { var kind = String(obj.kind); if (kind !== "class") { throw new TypeError('A class descriptor\'s .kind property must be "class", but a decorator' + ' created a class descriptor with .kind "' + kind + '"'); } this.disallowProperty(obj, "key", "A class descriptor"); this.disallowProperty(obj, "placement", "A class descriptor"); this.disallowProperty(obj, "descriptor", "A class descriptor"); this.disallowProperty(obj, "initializer", "A class descriptor"); this.disallowProperty(obj, "extras", "A class descriptor"); var finisher = _optionalCallableProperty(obj, "finisher"); var elements = this.toElementDescriptors(obj.elements); return { elements: elements, finisher: finisher }; }, runClassFinishers: function (constructor, finishers) { for (var i = 0; i < finishers.length; i++) { var newConstructor = (0, finishers[i])(constructor); if (newConstructor !== undefined) { if (typeof newConstructor !== "function") { throw new TypeError("Finishers must return a constructor."); } constructor = newConstructor; } } return constructor; }, disallowProperty: function (obj, name, objectType) { if (obj[name] !== undefined) { throw new TypeError(objectType + " can't have a ." + name + " property."); } } }; return api; }

function _createElementDescriptor(def) { var key = _toPropertyKey(def.key); var descriptor; if (def.kind === "method") { descriptor = { value: def.value, writable: true, configurable: true, enumerable: false }; } else if (def.kind === "get") { descriptor = { get: def.value, configurable: true, enumerable: false }; } else if (def.kind === "set") { descriptor = { set: def.value, configurable: true, enumerable: false }; } else if (def.kind === "field") { descriptor = { configurable: true, writable: true, enumerable: true }; } var element = { kind: def.kind === "field" ? "field" : "method", key: key, placement: def.static ? "static" : def.kind === "field" ? "own" : "prototype", descriptor: descriptor }; if (def.decorators) element.decorators = def.decorators; if (def.kind === "field") element.initializer = def.value; return element; }

function _coalesceGetterSetter(element, other) { if (element.descriptor.get !== undefined) { other.descriptor.get = element.descriptor.get; } else { other.descriptor.set = element.descriptor.set; } }

function _coalesceClassElements(elements) { var newElements = []; var isSameElement = function (other) { return other.kind === "method" && other.key === element.key && other.placement === element.placement; }; for (var i = 0; i < elements.length; i++) { var element = elements[i]; var other; if (element.kind === "method" && (other = newElements.find(isSameElement))) { if (_isDataDescriptor(element.descriptor) || _isDataDescriptor(other.descriptor)) { if (_hasDecorators(element) || _hasDecorators(other)) { throw new ReferenceError("Duplicated methods (" + element.key + ") can't be decorated."); } other.descriptor = element.descriptor; } else { if (_hasDecorators(element)) { if (_hasDecorators(other)) { throw new ReferenceError("Decorators can't be placed on different accessors with for " + "the same property (" + element.key + ")."); } other.decorators = element.decorators; } _coalesceGetterSetter(element, other); } } else { newElements.push(element); } } return newElements; }

function _hasDecorators(element) { return element.decorators && element.decorators.length; }

function _isDataDescriptor(desc) { return desc !== undefined && !(desc.value === undefined && desc.writable === undefined); }

function _optionalCallableProperty(obj, name) { var value = obj[name]; if (value !== undefined && typeof value !== "function") { throw new TypeError("Expected '" + name + "' to be a function"); } return value; }

function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }

function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }

function _toArray(arr) { return _arrayWithHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(n); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }










let HaIntegrationCard = _decorate([Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["customElement"])("ha-integration-card")], function (_initialize, _LitElement) {
  class HaIntegrationCard extends _LitElement {
    constructor(...args) {
      super(...args);

      _initialize(this);
    }

  }

  return {
    F: HaIntegrationCard,
    d: [{
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "hass",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "domain",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "items",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "entityRegistryEntries",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "deviceRegistryEntries",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "selectedConfigEntryId",
      value: void 0
    }, {
      kind: "method",
      key: "render",
      value: function render() {
        if (this.items.length === 1) {
          return this._renderSingleEntry(this.items[0]);
        }

        if (this.selectedConfigEntryId) {
          const configEntry = this.items.find(entry => entry.entry_id === this.selectedConfigEntryId);

          if (configEntry) {
            return this._renderSingleEntry(configEntry);
          }
        }

        return this._renderGroupedIntegration();
      }
    }, {
      kind: "method",
      key: "_renderGroupedIntegration",
      value: function _renderGroupedIntegration() {
        return lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
      <ha-card class="group">
        <div class="group-header">
          <img
            src="https://brands.home-assistant.io/${this.domain}/icon.png"
            referrerpolicy="no-referrer"
            @error=${this._onImageError}
            @load=${this._onImageLoad}
          />
          <h1>
            ${Object(_data_integration__WEBPACK_IMPORTED_MODULE_1__["domainToName"])(this.hass.localize, this.domain)}
          </h1>
        </div>
        <paper-listbox>
          ${this.items.map(item => lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`<paper-item
                .entryId=${item.entry_id}
                @click=${this._selectConfigEntry}
                ><paper-item-body>${item.title}</paper-item-body
                ><ha-icon-next></ha-icon-next
              ></paper-item>`)}
        </paper-listbox>
      </ha-card>
    `;
      }
    }, {
      kind: "method",
      key: "_renderSingleEntry",
      value: function _renderSingleEntry(item) {
        const devices = this._getDevices(item);

        const entities = this._getEntities(item);

        return lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
      <ha-card
        class="single integration"
        .configEntry=${item}
        .id=${item.entry_id}
      >
        ${this.items.length > 1 ? lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`<paper-icon-button
              class="back-btn"
              icon="hass:chevron-left"
              @click=${this._back}
            ></paper-icon-button>` : ""}
        <div class="card-content">
          <div class="image">
            <img
              src="https://brands.home-assistant.io/${item.domain}/logo.png"
              referrerpolicy="no-referrer"
              @error=${this._onImageError}
              @load=${this._onImageLoad}
            />
          </div>
          <h1>
            ${item.localized_domain_name}
          </h1>
          <h2>
            ${item.localized_domain_name === item.title ? "" : item.title}
          </h2>
          ${devices.length || entities.length ? lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
                <div>
                  ${devices.length ? lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
                        <a
                          href=${`/config/devices/dashboard?historyBack=1&config_entry=${item.entry_id}`}
                          >${this.hass.localize("ui.panel.config.integrations.config_entry.devices", "count", devices.length)}</a
                        >
                      ` : ""}
                  ${devices.length && entities.length ? "and" : ""}
                  ${entities.length ? lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
                        <a
                          href=${`/config/entities?historyBack=1&config_entry=${item.entry_id}`}
                          >${this.hass.localize("ui.panel.config.integrations.config_entry.entities", "count", entities.length)}</a
                        >
                      ` : ""}
                </div>
              ` : ""}
        </div>
        <div class="card-actions">
          <div>
            <mwc-button @click=${this._editEntryName}
              >${this.hass.localize("ui.panel.config.integrations.config_entry.rename")}</mwc-button
            >
            ${item.supports_options ? lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
                  <mwc-button @click=${this._showOptions}
                    >${this.hass.localize("ui.panel.config.integrations.config_entry.options")}</mwc-button
                  >
                ` : ""}
          </div>
          <paper-menu-button
            horizontal-align="right"
            vertical-align="top"
            vertical-offset="40"
            close-on-activate
          >
            <paper-icon-button
              icon="hass:dots-vertical"
              slot="dropdown-trigger"
              aria-label=${this.hass.localize("ui.panel.lovelace.editor.edit_card.options")}
            ></paper-icon-button>
            <paper-listbox slot="dropdown-content">
              <paper-item @tap=${this._showSystemOptions}>
                ${this.hass.localize("ui.panel.config.integrations.config_entry.system_options")}</paper-item
              >
              <paper-item class="warning" @tap=${this._removeIntegration}>
                ${this.hass.localize("ui.panel.config.integrations.config_entry.delete")}</paper-item
              >
            </paper-listbox>
          </paper-menu-button>
        </div>
      </ha-card>
    `;
      }
    }, {
      kind: "method",
      key: "_selectConfigEntry",
      value: function _selectConfigEntry(ev) {
        this.selectedConfigEntryId = ev.currentTarget.entryId;
      }
    }, {
      kind: "method",
      key: "_back",
      value: function _back() {
        this.selectedConfigEntryId = undefined;
        this.classList.remove("highlight");
      }
    }, {
      kind: "method",
      key: "_getEntities",
      value: function _getEntities(configEntry) {
        if (!this.entityRegistryEntries) {
          return [];
        }

        return this.entityRegistryEntries.filter(entity => entity.config_entry_id === configEntry.entry_id);
      }
    }, {
      kind: "method",
      key: "_getDevices",
      value: function _getDevices(configEntry) {
        if (!this.deviceRegistryEntries) {
          return [];
        }

        return this.deviceRegistryEntries.filter(device => device.config_entries.includes(configEntry.entry_id));
      }
    }, {
      kind: "method",
      key: "_onImageLoad",
      value: function _onImageLoad(ev) {
        ev.target.style.visibility = "initial";
      }
    }, {
      kind: "method",
      key: "_onImageError",
      value: function _onImageError(ev) {
        ev.target.style.visibility = "hidden";
      }
    }, {
      kind: "method",
      key: "_showOptions",
      value: function _showOptions(ev) {
        Object(_dialogs_config_flow_show_dialog_options_flow__WEBPACK_IMPORTED_MODULE_3__["showOptionsFlowDialog"])(this, ev.target.closest("ha-card").configEntry);
      }
    }, {
      kind: "method",
      key: "_showSystemOptions",
      value: function _showSystemOptions(ev) {
        Object(_dialogs_config_entry_system_options_show_dialog_config_entry_system_options__WEBPACK_IMPORTED_MODULE_4__["showConfigEntrySystemOptionsDialog"])(this, {
          entry: ev.target.closest("ha-card").configEntry
        });
      }
    }, {
      kind: "method",
      key: "_editEntryName",
      value: async function _editEntryName(ev) {
        const configEntry = ev.target.closest("ha-card").configEntry;
        const newName = await Object(_dialogs_generic_show_dialog_box__WEBPACK_IMPORTED_MODULE_5__["showPromptDialog"])(this, {
          title: this.hass.localize("ui.panel.config.integrations.rename_dialog"),
          defaultValue: configEntry.title,
          inputLabel: this.hass.localize("ui.panel.config.integrations.rename_input_label")
        });

        if (newName === null) {
          return;
        }

        const newEntry = await Object(_data_config_entries__WEBPACK_IMPORTED_MODULE_2__["updateConfigEntry"])(this.hass, configEntry.entry_id, {
          title: newName
        });
        Object(_common_dom_fire_event__WEBPACK_IMPORTED_MODULE_8__["fireEvent"])(this, "entry-updated", {
          entry: newEntry
        });
      }
    }, {
      kind: "method",
      key: "_removeIntegration",
      value: async function _removeIntegration(ev) {
        const entryId = ev.target.closest("ha-card").configEntry.entry_id;
        const confirmed = await Object(_dialogs_generic_show_dialog_box__WEBPACK_IMPORTED_MODULE_5__["showConfirmationDialog"])(this, {
          text: this.hass.localize("ui.panel.config.integrations.config_entry.delete_confirm")
        });

        if (!confirmed) {
          return;
        }

        Object(_data_config_entries__WEBPACK_IMPORTED_MODULE_2__["deleteConfigEntry"])(this.hass, entryId).then(result => {
          Object(_common_dom_fire_event__WEBPACK_IMPORTED_MODULE_8__["fireEvent"])(this, "entry-removed", {
            entryId
          });

          if (result.require_restart) {
            Object(_dialogs_generic_show_dialog_box__WEBPACK_IMPORTED_MODULE_5__["showAlertDialog"])(this, {
              text: this.hass.localize("ui.panel.config.integrations.config_entry.restart_confirm")
            });
          }
        });
      }
    }, {
      kind: "get",
      static: true,
      key: "styles",
      value: function styles() {
        return [_resources_styles__WEBPACK_IMPORTED_MODULE_6__["haStyle"], lit_element__WEBPACK_IMPORTED_MODULE_0__["css"]`
        :host {
          max-width: 500px;
        }
        ha-card {
          display: flex;
          flex-direction: column;
          height: 100%;
        }
        ha-card.single {
          justify-content: space-between;
        }
        :host(.highlight) ha-card {
          border: 1px solid var(--accent-color);
        }
        .card-content {
          padding: 16px;
          text-align: center;
        }
        ha-card.integration .card-content {
          padding-bottom: 3px;
        }
        .card-actions {
          border-top: none;
          display: flex;
          justify-content: space-between;
          align-items: center;
          padding-right: 5px;
        }
        .group-header {
          display: flex;
          align-items: center;
          height: 40px;
          padding: 16px 16px 8px 16px;
          vertical-align: middle;
        }
        .group-header h1 {
          margin: 0;
        }
        .group-header img {
          margin-right: 8px;
        }
        .image {
          display: flex;
          align-items: center;
          justify-content: center;
          height: 60px;
          margin-bottom: 16px;
          vertical-align: middle;
        }
        img {
          max-height: 100%;
          max-width: 90%;
        }

        .none-found {
          margin: auto;
          text-align: center;
        }
        a {
          color: var(--primary-color);
        }
        h1 {
          margin-bottom: 0;
        }
        h2 {
          margin-top: 0;
          min-height: 24px;
        }
        paper-menu-button {
          color: var(--secondary-text-color);
          padding: 0;
        }
        @media (min-width: 563px) {
          paper-listbox {
            max-height: 150px;
            overflow: auto;
          }
        }
        paper-item {
          cursor: pointer;
          min-height: 35px;
        }
        .back-btn {
          position: absolute;
          background: #ffffffe0;
          border-radius: 50%;
        }
      `];
      }
    }]
  };
}, lit_element__WEBPACK_IMPORTED_MODULE_0__["LitElement"]);

/***/ })

}]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicGFuZWwtY29uZmlnLWludGVncmF0aW9ucy5jaHVuay5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy8uL3NyYy9jb21tb24vZW50aXR5L2NvbXB1dGVfb2JqZWN0X2lkLnRzIiwid2VicGFjazovLy8uL3NyYy9jb21tb24vZW50aXR5L2NvbXB1dGVfc3RhdGVfbmFtZS50cyIsIndlYnBhY2s6Ly8vLi9zcmMvY29tbW9uL3N0cmluZy9jb21wYXJlLnRzIiwid2VicGFjazovLy8uL3NyYy9jb21tb24vdXRpbC9yZW5kZXItc3RhdHVzLnRzIiwid2VicGFjazovLy8uL3NyYy9jb21wb25lbnRzL2VudGl0eS9oYS1zdGF0ZS1pY29uLmpzIiwid2VicGFjazovLy8uL3NyYy9jb21wb25lbnRzL2hhLWljb24tbmV4dC50cyIsIndlYnBhY2s6Ly8vLi9zcmMvY29tcG9uZW50cy9oYS1pY29uLnRzIiwid2VicGFjazovLy8uL3NyYy9kYXRhL2NvbmZpZ19lbnRyaWVzLnRzIiwid2VicGFjazovLy8uL3NyYy9kYXRhL2NvbmZpZ19mbG93LnRzIiwid2VicGFjazovLy8uL3NyYy9kYXRhL2RldmljZV9yZWdpc3RyeS50cyIsIndlYnBhY2s6Ly8vLi9zcmMvZGF0YS9lbnRpdHlfcmVnaXN0cnkudHMiLCJ3ZWJwYWNrOi8vLy4vc3JjL2RhdGEvaW50ZWdyYXRpb24udHMiLCJ3ZWJwYWNrOi8vLy4vc3JjL2RhdGEvb3B0aW9uc19mbG93LnRzIiwid2VicGFjazovLy8uL3NyYy9kaWFsb2dzL2NvbmZpZy1lbnRyeS1zeXN0ZW0tb3B0aW9ucy9zaG93LWRpYWxvZy1jb25maWctZW50cnktc3lzdGVtLW9wdGlvbnMudHMiLCJ3ZWJwYWNrOi8vLy4vc3JjL2RpYWxvZ3MvY29uZmlnLWZsb3cvc2hvdy1kaWFsb2ctY29uZmlnLWZsb3cudHMiLCJ3ZWJwYWNrOi8vLy4vc3JjL2RpYWxvZ3MvY29uZmlnLWZsb3cvc2hvdy1kaWFsb2ctZGF0YS1lbnRyeS1mbG93LnRzIiwid2VicGFjazovLy8uL3NyYy9kaWFsb2dzL2NvbmZpZy1mbG93L3Nob3ctZGlhbG9nLW9wdGlvbnMtZmxvdy50cyIsIndlYnBhY2s6Ly8vLi9zcmMvZGlhbG9ncy9nZW5lcmljL3Nob3ctZGlhbG9nLWJveC50cyIsIndlYnBhY2s6Ly8vLi9zcmMvcGFuZWxzL2NvbmZpZy9pbnRlZ3JhdGlvbnMvaGEtY29uZmlnLWludGVncmF0aW9ucy50cyIsIndlYnBhY2s6Ly8vLi9zcmMvcGFuZWxzL2NvbmZpZy9pbnRlZ3JhdGlvbnMvaGEtaW50ZWdyYXRpb24tY2FyZC50cyJdLCJzb3VyY2VzQ29udGVudCI6WyIvKiogQ29tcHV0ZSB0aGUgb2JqZWN0IElEIG9mIGEgc3RhdGUuICovXG5leHBvcnQgY29uc3QgY29tcHV0ZU9iamVjdElkID0gKGVudGl0eUlkOiBzdHJpbmcpOiBzdHJpbmcgPT4ge1xuICByZXR1cm4gZW50aXR5SWQuc3Vic3RyKGVudGl0eUlkLmluZGV4T2YoXCIuXCIpICsgMSk7XG59O1xuIiwiaW1wb3J0IHsgSGFzc0VudGl0eSB9IGZyb20gXCJob21lLWFzc2lzdGFudC1qcy13ZWJzb2NrZXRcIjtcbmltcG9ydCB7IGNvbXB1dGVPYmplY3RJZCB9IGZyb20gXCIuL2NvbXB1dGVfb2JqZWN0X2lkXCI7XG5cbmV4cG9ydCBjb25zdCBjb21wdXRlU3RhdGVOYW1lID0gKHN0YXRlT2JqOiBIYXNzRW50aXR5KTogc3RyaW5nID0+IHtcbiAgcmV0dXJuIHN0YXRlT2JqLmF0dHJpYnV0ZXMuZnJpZW5kbHlfbmFtZSA9PT0gdW5kZWZpbmVkXG4gICAgPyBjb21wdXRlT2JqZWN0SWQoc3RhdGVPYmouZW50aXR5X2lkKS5yZXBsYWNlKC9fL2csIFwiIFwiKVxuICAgIDogc3RhdGVPYmouYXR0cmlidXRlcy5mcmllbmRseV9uYW1lIHx8IFwiXCI7XG59O1xuIiwiZXhwb3J0IGNvbnN0IGNvbXBhcmUgPSAoYTogc3RyaW5nLCBiOiBzdHJpbmcpID0+IHtcbiAgaWYgKGEgPCBiKSB7XG4gICAgcmV0dXJuIC0xO1xuICB9XG4gIGlmIChhID4gYikge1xuICAgIHJldHVybiAxO1xuICB9XG5cbiAgcmV0dXJuIDA7XG59O1xuXG5leHBvcnQgY29uc3QgY2FzZUluc2Vuc2l0aXZlQ29tcGFyZSA9IChhOiBzdHJpbmcsIGI6IHN0cmluZykgPT5cbiAgY29tcGFyZShhLnRvTG93ZXJDYXNlKCksIGIudG9Mb3dlckNhc2UoKSk7XG4iLCJleHBvcnQgY29uc3QgYWZ0ZXJOZXh0UmVuZGVyID0gKGNiOiAoKSA9PiB2b2lkKTogdm9pZCA9PiB7XG4gIHJlcXVlc3RBbmltYXRpb25GcmFtZSgoKSA9PiBzZXRUaW1lb3V0KGNiLCAwKSk7XG59O1xuXG5leHBvcnQgY29uc3QgbmV4dFJlbmRlciA9ICgpID0+IHtcbiAgcmV0dXJuIG5ldyBQcm9taXNlKChyZXNvbHZlKSA9PiB7XG4gICAgYWZ0ZXJOZXh0UmVuZGVyKHJlc29sdmUpO1xuICB9KTtcbn07XG4iLCJpbXBvcnQgeyBodG1sIH0gZnJvbSBcIkBwb2x5bWVyL3BvbHltZXIvbGliL3V0aWxzL2h0bWwtdGFnXCI7XG4vKiBlc2xpbnQtcGx1Z2luLWRpc2FibGUgbGl0ICovXG5pbXBvcnQgeyBQb2x5bWVyRWxlbWVudCB9IGZyb20gXCJAcG9seW1lci9wb2x5bWVyL3BvbHltZXItZWxlbWVudFwiO1xuaW1wb3J0IHsgc3RhdGVJY29uIH0gZnJvbSBcIi4uLy4uL2NvbW1vbi9lbnRpdHkvc3RhdGVfaWNvblwiO1xuaW1wb3J0IFwiLi4vaGEtaWNvblwiO1xuXG5jbGFzcyBIYVN0YXRlSWNvbiBleHRlbmRzIFBvbHltZXJFbGVtZW50IHtcbiAgc3RhdGljIGdldCB0ZW1wbGF0ZSgpIHtcbiAgICByZXR1cm4gaHRtbGAgPGhhLWljb24gaWNvbj1cIltbY29tcHV0ZUljb24oc3RhdGVPYmopXV1cIj48L2hhLWljb24+IGA7XG4gIH1cblxuICBzdGF0aWMgZ2V0IHByb3BlcnRpZXMoKSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIHN0YXRlT2JqOiB7XG4gICAgICAgIHR5cGU6IE9iamVjdCxcbiAgICAgIH0sXG4gICAgfTtcbiAgfVxuXG4gIGNvbXB1dGVJY29uKHN0YXRlT2JqKSB7XG4gICAgcmV0dXJuIHN0YXRlSWNvbihzdGF0ZU9iaik7XG4gIH1cbn1cblxuY3VzdG9tRWxlbWVudHMuZGVmaW5lKFwiaGEtc3RhdGUtaWNvblwiLCBIYVN0YXRlSWNvbik7XG4iLCJpbXBvcnQgXCJAcG9seW1lci9pcm9uLWljb24vaXJvbi1pY29uXCI7XG4vLyBOb3QgZHVwbGljYXRlLCB0aGlzIGlzIGZvciB0eXBpbmcuXG4vLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmVcbmltcG9ydCB7IEhhSWNvbiB9IGZyb20gXCIuL2hhLWljb25cIjtcblxuZXhwb3J0IGNsYXNzIEhhSWNvbk5leHQgZXh0ZW5kcyBIYUljb24ge1xuICBwdWJsaWMgY29ubmVjdGVkQ2FsbGJhY2soKSB7XG4gICAgc3VwZXIuY29ubmVjdGVkQ2FsbGJhY2soKTtcblxuICAgIC8vIHdhaXQgdG8gY2hlY2sgZm9yIGRpcmVjdGlvbiBzaW5jZSBvdGhlcndpc2UgZGlyZWN0aW9uIGlzIHdyb25nIGV2ZW4gdGhvdWdoIHRvcCBsZXZlbCBpcyBSVExcbiAgICBzZXRUaW1lb3V0KCgpID0+IHtcbiAgICAgIHRoaXMuaWNvbiA9XG4gICAgICAgIHdpbmRvdy5nZXRDb21wdXRlZFN0eWxlKHRoaXMpLmRpcmVjdGlvbiA9PT0gXCJsdHJcIlxuICAgICAgICAgID8gXCJoYXNzOmNoZXZyb24tcmlnaHRcIlxuICAgICAgICAgIDogXCJoYXNzOmNoZXZyb24tbGVmdFwiO1xuICAgIH0sIDEwMCk7XG4gIH1cbn1cblxuZGVjbGFyZSBnbG9iYWwge1xuICBpbnRlcmZhY2UgSFRNTEVsZW1lbnRUYWdOYW1lTWFwIHtcbiAgICBcImhhLWljb24tbmV4dFwiOiBIYUljb25OZXh0O1xuICB9XG59XG5cbmN1c3RvbUVsZW1lbnRzLmRlZmluZShcImhhLWljb24tbmV4dFwiLCBIYUljb25OZXh0KTtcbiIsImltcG9ydCBcIkBwb2x5bWVyL2lyb24taWNvbi9pcm9uLWljb25cIjtcbmltcG9ydCB0eXBlIHsgSXJvbkljb25FbGVtZW50IH0gZnJvbSBcIkBwb2x5bWVyL2lyb24taWNvbi9pcm9uLWljb25cIjtcbmltcG9ydCB7IENvbnN0cnVjdG9yIH0gZnJvbSBcIi4uL3R5cGVzXCI7XG5cbmNvbnN0IGlyb25JY29uQ2xhc3MgPSBjdXN0b21FbGVtZW50cy5nZXQoXCJpcm9uLWljb25cIikgYXMgQ29uc3RydWN0b3I8XG4gIElyb25JY29uRWxlbWVudFxuPjtcblxubGV0IGxvYWRlZCA9IGZhbHNlO1xuXG5leHBvcnQgY2xhc3MgSGFJY29uIGV4dGVuZHMgaXJvbkljb25DbGFzcyB7XG4gIHByaXZhdGUgX2ljb25zZXROYW1lPzogc3RyaW5nO1xuXG4gIHB1YmxpYyBsaXN0ZW4oXG4gICAgbm9kZTogRXZlbnRUYXJnZXQgfCBudWxsLFxuICAgIGV2ZW50TmFtZTogc3RyaW5nLFxuICAgIG1ldGhvZE5hbWU6IHN0cmluZ1xuICApOiB2b2lkIHtcbiAgICBzdXBlci5saXN0ZW4obm9kZSwgZXZlbnROYW1lLCBtZXRob2ROYW1lKTtcblxuICAgIGlmICghbG9hZGVkICYmIHRoaXMuX2ljb25zZXROYW1lID09PSBcIm1kaVwiKSB7XG4gICAgICBsb2FkZWQgPSB0cnVlO1xuICAgICAgaW1wb3J0KC8qIHdlYnBhY2tDaHVua05hbWU6IFwibWRpLWljb25zXCIgKi8gXCIuLi9yZXNvdXJjZXMvbWRpLWljb25zXCIpO1xuICAgIH1cbiAgfVxufVxuXG5kZWNsYXJlIGdsb2JhbCB7XG4gIGludGVyZmFjZSBIVE1MRWxlbWVudFRhZ05hbWVNYXAge1xuICAgIFwiaGEtaWNvblwiOiBIYUljb247XG4gIH1cbn1cblxuY3VzdG9tRWxlbWVudHMuZGVmaW5lKFwiaGEtaWNvblwiLCBIYUljb24pO1xuIiwiaW1wb3J0IHsgSG9tZUFzc2lzdGFudCB9IGZyb20gXCIuLi90eXBlc1wiO1xuXG5leHBvcnQgaW50ZXJmYWNlIENvbmZpZ0VudHJ5IHtcbiAgZW50cnlfaWQ6IHN0cmluZztcbiAgZG9tYWluOiBzdHJpbmc7XG4gIHRpdGxlOiBzdHJpbmc7XG4gIHNvdXJjZTogc3RyaW5nO1xuICBzdGF0ZTogc3RyaW5nO1xuICBjb25uZWN0aW9uX2NsYXNzOiBzdHJpbmc7XG4gIHN1cHBvcnRzX29wdGlvbnM6IGJvb2xlYW47XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgQ29uZmlnRW50cnlNdXRhYmxlUGFyYW1zIHtcbiAgdGl0bGU6IHN0cmluZztcbn1cblxuZXhwb3J0IGludGVyZmFjZSBDb25maWdFbnRyeVN5c3RlbU9wdGlvbnMge1xuICBkaXNhYmxlX25ld19lbnRpdGllczogYm9vbGVhbjtcbn1cblxuZXhwb3J0IGNvbnN0IGdldENvbmZpZ0VudHJpZXMgPSAoaGFzczogSG9tZUFzc2lzdGFudCkgPT5cbiAgaGFzcy5jYWxsQXBpPENvbmZpZ0VudHJ5W10+KFwiR0VUXCIsIFwiY29uZmlnL2NvbmZpZ19lbnRyaWVzL2VudHJ5XCIpO1xuXG5leHBvcnQgY29uc3QgdXBkYXRlQ29uZmlnRW50cnkgPSAoXG4gIGhhc3M6IEhvbWVBc3Npc3RhbnQsXG4gIGNvbmZpZ0VudHJ5SWQ6IHN0cmluZyxcbiAgdXBkYXRlZFZhbHVlczogUGFydGlhbDxDb25maWdFbnRyeU11dGFibGVQYXJhbXM+XG4pID0+XG4gIGhhc3MuY2FsbFdTPENvbmZpZ0VudHJ5Pih7XG4gICAgdHlwZTogXCJjb25maWdfZW50cmllcy91cGRhdGVcIixcbiAgICBlbnRyeV9pZDogY29uZmlnRW50cnlJZCxcbiAgICAuLi51cGRhdGVkVmFsdWVzLFxuICB9KTtcblxuZXhwb3J0IGNvbnN0IGRlbGV0ZUNvbmZpZ0VudHJ5ID0gKGhhc3M6IEhvbWVBc3Npc3RhbnQsIGNvbmZpZ0VudHJ5SWQ6IHN0cmluZykgPT5cbiAgaGFzcy5jYWxsQXBpPHtcbiAgICByZXF1aXJlX3Jlc3RhcnQ6IGJvb2xlYW47XG4gIH0+KFwiREVMRVRFXCIsIGBjb25maWcvY29uZmlnX2VudHJpZXMvZW50cnkvJHtjb25maWdFbnRyeUlkfWApO1xuXG5leHBvcnQgY29uc3QgZ2V0Q29uZmlnRW50cnlTeXN0ZW1PcHRpb25zID0gKFxuICBoYXNzOiBIb21lQXNzaXN0YW50LFxuICBjb25maWdFbnRyeUlkOiBzdHJpbmdcbikgPT5cbiAgaGFzcy5jYWxsV1M8Q29uZmlnRW50cnlTeXN0ZW1PcHRpb25zPih7XG4gICAgdHlwZTogXCJjb25maWdfZW50cmllcy9zeXN0ZW1fb3B0aW9ucy9saXN0XCIsXG4gICAgZW50cnlfaWQ6IGNvbmZpZ0VudHJ5SWQsXG4gIH0pO1xuXG5leHBvcnQgY29uc3QgdXBkYXRlQ29uZmlnRW50cnlTeXN0ZW1PcHRpb25zID0gKFxuICBoYXNzOiBIb21lQXNzaXN0YW50LFxuICBjb25maWdFbnRyeUlkOiBzdHJpbmcsXG4gIHBhcmFtczogUGFydGlhbDxDb25maWdFbnRyeVN5c3RlbU9wdGlvbnM+XG4pID0+XG4gIGhhc3MuY2FsbFdTKHtcbiAgICB0eXBlOiBcImNvbmZpZ19lbnRyaWVzL3N5c3RlbV9vcHRpb25zL3VwZGF0ZVwiLFxuICAgIGVudHJ5X2lkOiBjb25maWdFbnRyeUlkLFxuICAgIC4uLnBhcmFtcyxcbiAgfSk7XG4iLCJpbXBvcnQgeyBDb25uZWN0aW9uLCBnZXRDb2xsZWN0aW9uIH0gZnJvbSBcImhvbWUtYXNzaXN0YW50LWpzLXdlYnNvY2tldFwiO1xuaW1wb3J0IHsgTG9jYWxpemVGdW5jIH0gZnJvbSBcIi4uL2NvbW1vbi90cmFuc2xhdGlvbnMvbG9jYWxpemVcIjtcbmltcG9ydCB7IGRlYm91bmNlIH0gZnJvbSBcIi4uL2NvbW1vbi91dGlsL2RlYm91bmNlXCI7XG5pbXBvcnQgeyBIb21lQXNzaXN0YW50IH0gZnJvbSBcIi4uL3R5cGVzXCI7XG5pbXBvcnQgeyBEYXRhRW50cnlGbG93UHJvZ3Jlc3MsIERhdGFFbnRyeUZsb3dTdGVwIH0gZnJvbSBcIi4vZGF0YV9lbnRyeV9mbG93XCI7XG5pbXBvcnQgeyBkb21haW5Ub05hbWUgfSBmcm9tIFwiLi9pbnRlZ3JhdGlvblwiO1xuXG5leHBvcnQgY29uc3QgRElTQ09WRVJZX1NPVVJDRVMgPSBbXCJ1bmlnbm9yZVwiLCBcImhvbWVraXRcIiwgXCJzc2RwXCIsIFwiemVyb2NvbmZcIl07XG5cbmV4cG9ydCBjb25zdCBjcmVhdGVDb25maWdGbG93ID0gKGhhc3M6IEhvbWVBc3Npc3RhbnQsIGhhbmRsZXI6IHN0cmluZykgPT5cbiAgaGFzcy5jYWxsQXBpPERhdGFFbnRyeUZsb3dTdGVwPihcIlBPU1RcIiwgXCJjb25maWcvY29uZmlnX2VudHJpZXMvZmxvd1wiLCB7XG4gICAgaGFuZGxlcixcbiAgICBzaG93X2FkdmFuY2VkX29wdGlvbnM6IEJvb2xlYW4oaGFzcy51c2VyRGF0YT8uc2hvd0FkdmFuY2VkKSxcbiAgfSk7XG5cbmV4cG9ydCBjb25zdCBmZXRjaENvbmZpZ0Zsb3cgPSAoaGFzczogSG9tZUFzc2lzdGFudCwgZmxvd0lkOiBzdHJpbmcpID0+XG4gIGhhc3MuY2FsbEFwaTxEYXRhRW50cnlGbG93U3RlcD4oXG4gICAgXCJHRVRcIixcbiAgICBgY29uZmlnL2NvbmZpZ19lbnRyaWVzL2Zsb3cvJHtmbG93SWR9YFxuICApO1xuXG5leHBvcnQgY29uc3QgaGFuZGxlQ29uZmlnRmxvd1N0ZXAgPSAoXG4gIGhhc3M6IEhvbWVBc3Npc3RhbnQsXG4gIGZsb3dJZDogc3RyaW5nLFxuICBkYXRhOiB7IFtrZXk6IHN0cmluZ106IGFueSB9XG4pID0+XG4gIGhhc3MuY2FsbEFwaTxEYXRhRW50cnlGbG93U3RlcD4oXG4gICAgXCJQT1NUXCIsXG4gICAgYGNvbmZpZy9jb25maWdfZW50cmllcy9mbG93LyR7Zmxvd0lkfWAsXG4gICAgZGF0YVxuICApO1xuXG5leHBvcnQgY29uc3QgaWdub3JlQ29uZmlnRmxvdyA9IChoYXNzOiBIb21lQXNzaXN0YW50LCBmbG93SWQ6IHN0cmluZykgPT5cbiAgaGFzcy5jYWxsV1MoeyB0eXBlOiBcImNvbmZpZ19lbnRyaWVzL2lnbm9yZV9mbG93XCIsIGZsb3dfaWQ6IGZsb3dJZCB9KTtcblxuZXhwb3J0IGNvbnN0IGRlbGV0ZUNvbmZpZ0Zsb3cgPSAoaGFzczogSG9tZUFzc2lzdGFudCwgZmxvd0lkOiBzdHJpbmcpID0+XG4gIGhhc3MuY2FsbEFwaShcIkRFTEVURVwiLCBgY29uZmlnL2NvbmZpZ19lbnRyaWVzL2Zsb3cvJHtmbG93SWR9YCk7XG5cbmV4cG9ydCBjb25zdCBnZXRDb25maWdGbG93SGFuZGxlcnMgPSAoaGFzczogSG9tZUFzc2lzdGFudCkgPT5cbiAgaGFzcy5jYWxsQXBpPHN0cmluZ1tdPihcIkdFVFwiLCBcImNvbmZpZy9jb25maWdfZW50cmllcy9mbG93X2hhbmRsZXJzXCIpO1xuXG5jb25zdCBmZXRjaENvbmZpZ0Zsb3dJblByb2dyZXNzID0gKGNvbm4pID0+XG4gIGNvbm4uc2VuZE1lc3NhZ2VQcm9taXNlKHtcbiAgICB0eXBlOiBcImNvbmZpZ19lbnRyaWVzL2Zsb3cvcHJvZ3Jlc3NcIixcbiAgfSk7XG5cbmNvbnN0IHN1YnNjcmliZUNvbmZpZ0Zsb3dJblByb2dyZXNzVXBkYXRlcyA9IChjb25uLCBzdG9yZSkgPT5cbiAgY29ubi5zdWJzY3JpYmVFdmVudHMoXG4gICAgZGVib3VuY2UoXG4gICAgICAoKSA9PlxuICAgICAgICBmZXRjaENvbmZpZ0Zsb3dJblByb2dyZXNzKGNvbm4pLnRoZW4oKGZsb3dzKSA9PlxuICAgICAgICAgIHN0b3JlLnNldFN0YXRlKGZsb3dzLCB0cnVlKVxuICAgICAgICApLFxuICAgICAgNTAwLFxuICAgICAgdHJ1ZVxuICAgICksXG4gICAgXCJjb25maWdfZW50cnlfZGlzY292ZXJlZFwiXG4gICk7XG5cbmV4cG9ydCBjb25zdCBnZXRDb25maWdGbG93SW5Qcm9ncmVzc0NvbGxlY3Rpb24gPSAoY29ubjogQ29ubmVjdGlvbikgPT5cbiAgZ2V0Q29sbGVjdGlvbjxEYXRhRW50cnlGbG93UHJvZ3Jlc3NbXT4oXG4gICAgY29ubixcbiAgICBcIl9jb25maWdGbG93UHJvZ3Jlc3NcIixcbiAgICBmZXRjaENvbmZpZ0Zsb3dJblByb2dyZXNzLFxuICAgIHN1YnNjcmliZUNvbmZpZ0Zsb3dJblByb2dyZXNzVXBkYXRlc1xuICApO1xuXG5leHBvcnQgY29uc3Qgc3Vic2NyaWJlQ29uZmlnRmxvd0luUHJvZ3Jlc3MgPSAoXG4gIGhhc3M6IEhvbWVBc3Npc3RhbnQsXG4gIG9uQ2hhbmdlOiAoZmxvd3M6IERhdGFFbnRyeUZsb3dQcm9ncmVzc1tdKSA9PiB2b2lkXG4pID0+IGdldENvbmZpZ0Zsb3dJblByb2dyZXNzQ29sbGVjdGlvbihoYXNzLmNvbm5lY3Rpb24pLnN1YnNjcmliZShvbkNoYW5nZSk7XG5cbmV4cG9ydCBjb25zdCBsb2NhbGl6ZUNvbmZpZ0Zsb3dUaXRsZSA9IChcbiAgbG9jYWxpemU6IExvY2FsaXplRnVuYyxcbiAgZmxvdzogRGF0YUVudHJ5Rmxvd1Byb2dyZXNzXG4pID0+IHtcbiAgY29uc3QgcGxhY2Vob2xkZXJzID0gZmxvdy5jb250ZXh0LnRpdGxlX3BsYWNlaG9sZGVycyB8fCB7fTtcbiAgY29uc3QgcGxhY2Vob2xkZXJLZXlzID0gT2JqZWN0LmtleXMocGxhY2Vob2xkZXJzKTtcbiAgaWYgKHBsYWNlaG9sZGVyS2V5cy5sZW5ndGggPT09IDApIHtcbiAgICByZXR1cm4gZG9tYWluVG9OYW1lKGxvY2FsaXplLCBmbG93LmhhbmRsZXIpO1xuICB9XG4gIGNvbnN0IGFyZ3M6IHN0cmluZ1tdID0gW107XG4gIHBsYWNlaG9sZGVyS2V5cy5mb3JFYWNoKChrZXkpID0+IHtcbiAgICBhcmdzLnB1c2goa2V5KTtcbiAgICBhcmdzLnB1c2gocGxhY2Vob2xkZXJzW2tleV0pO1xuICB9KTtcbiAgcmV0dXJuIGxvY2FsaXplKGBjb21wb25lbnQuJHtmbG93LmhhbmRsZXJ9LmNvbmZpZy5mbG93X3RpdGxlYCwgLi4uYXJncyk7XG59O1xuIiwiaW1wb3J0IHsgQ29ubmVjdGlvbiwgY3JlYXRlQ29sbGVjdGlvbiB9IGZyb20gXCJob21lLWFzc2lzdGFudC1qcy13ZWJzb2NrZXRcIjtcbmltcG9ydCB7IGNvbXB1dGVTdGF0ZU5hbWUgfSBmcm9tIFwiLi4vY29tbW9uL2VudGl0eS9jb21wdXRlX3N0YXRlX25hbWVcIjtcbmltcG9ydCB7IGRlYm91bmNlIH0gZnJvbSBcIi4uL2NvbW1vbi91dGlsL2RlYm91bmNlXCI7XG5pbXBvcnQgeyBIb21lQXNzaXN0YW50IH0gZnJvbSBcIi4uL3R5cGVzXCI7XG5pbXBvcnQgeyBFbnRpdHlSZWdpc3RyeUVudHJ5IH0gZnJvbSBcIi4vZW50aXR5X3JlZ2lzdHJ5XCI7XG5cbmV4cG9ydCBpbnRlcmZhY2UgRGV2aWNlUmVnaXN0cnlFbnRyeSB7XG4gIGlkOiBzdHJpbmc7XG4gIGNvbmZpZ19lbnRyaWVzOiBzdHJpbmdbXTtcbiAgY29ubmVjdGlvbnM6IEFycmF5PFtzdHJpbmcsIHN0cmluZ10+O1xuICBtYW51ZmFjdHVyZXI6IHN0cmluZztcbiAgbW9kZWw/OiBzdHJpbmc7XG4gIG5hbWU/OiBzdHJpbmc7XG4gIHN3X3ZlcnNpb24/OiBzdHJpbmc7XG4gIHZpYV9kZXZpY2VfaWQ/OiBzdHJpbmc7XG4gIGFyZWFfaWQ/OiBzdHJpbmc7XG4gIG5hbWVfYnlfdXNlcj86IHN0cmluZztcbn1cblxuZXhwb3J0IGludGVyZmFjZSBEZXZpY2VFbnRpdHlMb29rdXAge1xuICBbZGV2aWNlSWQ6IHN0cmluZ106IEVudGl0eVJlZ2lzdHJ5RW50cnlbXTtcbn1cblxuZXhwb3J0IGludGVyZmFjZSBEZXZpY2VSZWdpc3RyeUVudHJ5TXV0YWJsZVBhcmFtcyB7XG4gIGFyZWFfaWQ/OiBzdHJpbmcgfCBudWxsO1xuICBuYW1lX2J5X3VzZXI/OiBzdHJpbmcgfCBudWxsO1xufVxuXG5leHBvcnQgY29uc3QgZmFsbGJhY2tEZXZpY2VOYW1lID0gKFxuICBoYXNzOiBIb21lQXNzaXN0YW50LFxuICBlbnRpdGllczogRW50aXR5UmVnaXN0cnlFbnRyeVtdIHwgc3RyaW5nW11cbikgPT4ge1xuICBmb3IgKGNvbnN0IGVudGl0eSBvZiBlbnRpdGllcyB8fCBbXSkge1xuICAgIGNvbnN0IGVudGl0eUlkID0gdHlwZW9mIGVudGl0eSA9PT0gXCJzdHJpbmdcIiA/IGVudGl0eSA6IGVudGl0eS5lbnRpdHlfaWQ7XG4gICAgY29uc3Qgc3RhdGVPYmogPSBoYXNzLnN0YXRlc1tlbnRpdHlJZF07XG4gICAgaWYgKHN0YXRlT2JqKSB7XG4gICAgICByZXR1cm4gY29tcHV0ZVN0YXRlTmFtZShzdGF0ZU9iaik7XG4gICAgfVxuICB9XG4gIHJldHVybiB1bmRlZmluZWQ7XG59O1xuXG5leHBvcnQgY29uc3QgY29tcHV0ZURldmljZU5hbWUgPSAoXG4gIGRldmljZTogRGV2aWNlUmVnaXN0cnlFbnRyeSxcbiAgaGFzczogSG9tZUFzc2lzdGFudCxcbiAgZW50aXRpZXM/OiBFbnRpdHlSZWdpc3RyeUVudHJ5W10gfCBzdHJpbmdbXVxuKSA9PiB7XG4gIHJldHVybiAoXG4gICAgZGV2aWNlLm5hbWVfYnlfdXNlciB8fFxuICAgIGRldmljZS5uYW1lIHx8XG4gICAgKGVudGl0aWVzICYmIGZhbGxiYWNrRGV2aWNlTmFtZShoYXNzLCBlbnRpdGllcykpIHx8XG4gICAgaGFzcy5sb2NhbGl6ZShcInVpLnBhbmVsLmNvbmZpZy5kZXZpY2VzLnVubmFtZWRfZGV2aWNlXCIpXG4gICk7XG59O1xuXG5leHBvcnQgY29uc3QgZGV2aWNlc0luQXJlYSA9IChkZXZpY2VzOiBEZXZpY2VSZWdpc3RyeUVudHJ5W10sIGFyZWFJZDogc3RyaW5nKSA9PlxuICBkZXZpY2VzLmZpbHRlcigoZGV2aWNlKSA9PiBkZXZpY2UuYXJlYV9pZCA9PT0gYXJlYUlkKTtcblxuZXhwb3J0IGNvbnN0IHVwZGF0ZURldmljZVJlZ2lzdHJ5RW50cnkgPSAoXG4gIGhhc3M6IEhvbWVBc3Npc3RhbnQsXG4gIGRldmljZUlkOiBzdHJpbmcsXG4gIHVwZGF0ZXM6IFBhcnRpYWw8RGV2aWNlUmVnaXN0cnlFbnRyeU11dGFibGVQYXJhbXM+XG4pID0+XG4gIGhhc3MuY2FsbFdTPERldmljZVJlZ2lzdHJ5RW50cnk+KHtcbiAgICB0eXBlOiBcImNvbmZpZy9kZXZpY2VfcmVnaXN0cnkvdXBkYXRlXCIsXG4gICAgZGV2aWNlX2lkOiBkZXZpY2VJZCxcbiAgICAuLi51cGRhdGVzLFxuICB9KTtcblxuY29uc3QgZmV0Y2hEZXZpY2VSZWdpc3RyeSA9IChjb25uKSA9PlxuICBjb25uLnNlbmRNZXNzYWdlUHJvbWlzZSh7XG4gICAgdHlwZTogXCJjb25maWcvZGV2aWNlX3JlZ2lzdHJ5L2xpc3RcIixcbiAgfSk7XG5cbmNvbnN0IHN1YnNjcmliZURldmljZVJlZ2lzdHJ5VXBkYXRlcyA9IChjb25uLCBzdG9yZSkgPT5cbiAgY29ubi5zdWJzY3JpYmVFdmVudHMoXG4gICAgZGVib3VuY2UoXG4gICAgICAoKSA9PlxuICAgICAgICBmZXRjaERldmljZVJlZ2lzdHJ5KGNvbm4pLnRoZW4oKGRldmljZXMpID0+XG4gICAgICAgICAgc3RvcmUuc2V0U3RhdGUoZGV2aWNlcywgdHJ1ZSlcbiAgICAgICAgKSxcbiAgICAgIDUwMCxcbiAgICAgIHRydWVcbiAgICApLFxuICAgIFwiZGV2aWNlX3JlZ2lzdHJ5X3VwZGF0ZWRcIlxuICApO1xuXG5leHBvcnQgY29uc3Qgc3Vic2NyaWJlRGV2aWNlUmVnaXN0cnkgPSAoXG4gIGNvbm46IENvbm5lY3Rpb24sXG4gIG9uQ2hhbmdlOiAoZGV2aWNlczogRGV2aWNlUmVnaXN0cnlFbnRyeVtdKSA9PiB2b2lkXG4pID0+XG4gIGNyZWF0ZUNvbGxlY3Rpb248RGV2aWNlUmVnaXN0cnlFbnRyeVtdPihcbiAgICBcIl9kclwiLFxuICAgIGZldGNoRGV2aWNlUmVnaXN0cnksXG4gICAgc3Vic2NyaWJlRGV2aWNlUmVnaXN0cnlVcGRhdGVzLFxuICAgIGNvbm4sXG4gICAgb25DaGFuZ2VcbiAgKTtcbiIsImltcG9ydCB7IENvbm5lY3Rpb24sIGNyZWF0ZUNvbGxlY3Rpb24gfSBmcm9tIFwiaG9tZS1hc3Npc3RhbnQtanMtd2Vic29ja2V0XCI7XG5pbXBvcnQgeyBjb21wdXRlU3RhdGVOYW1lIH0gZnJvbSBcIi4uL2NvbW1vbi9lbnRpdHkvY29tcHV0ZV9zdGF0ZV9uYW1lXCI7XG5pbXBvcnQgeyBkZWJvdW5jZSB9IGZyb20gXCIuLi9jb21tb24vdXRpbC9kZWJvdW5jZVwiO1xuaW1wb3J0IHsgSG9tZUFzc2lzdGFudCB9IGZyb20gXCIuLi90eXBlc1wiO1xuXG5leHBvcnQgaW50ZXJmYWNlIEVudGl0eVJlZ2lzdHJ5RW50cnkge1xuICBlbnRpdHlfaWQ6IHN0cmluZztcbiAgbmFtZTogc3RyaW5nO1xuICBpY29uPzogc3RyaW5nO1xuICBwbGF0Zm9ybTogc3RyaW5nO1xuICBjb25maWdfZW50cnlfaWQ/OiBzdHJpbmc7XG4gIGRldmljZV9pZD86IHN0cmluZztcbiAgZGlzYWJsZWRfYnk6IHN0cmluZyB8IG51bGw7XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgRXh0RW50aXR5UmVnaXN0cnlFbnRyeSBleHRlbmRzIEVudGl0eVJlZ2lzdHJ5RW50cnkge1xuICB1bmlxdWVfaWQ6IHN0cmluZztcbiAgY2FwYWJpbGl0aWVzOiBvYmplY3Q7XG4gIG9yaWdpbmFsX25hbWU/OiBzdHJpbmc7XG4gIG9yaWdpbmFsX2ljb24/OiBzdHJpbmc7XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgRW50aXR5UmVnaXN0cnlFbnRyeVVwZGF0ZVBhcmFtcyB7XG4gIG5hbWU/OiBzdHJpbmcgfCBudWxsO1xuICBpY29uPzogc3RyaW5nIHwgbnVsbDtcbiAgZGlzYWJsZWRfYnk/OiBzdHJpbmcgfCBudWxsO1xuICBuZXdfZW50aXR5X2lkPzogc3RyaW5nO1xufVxuXG5leHBvcnQgY29uc3QgZmluZEJhdHRlcnlFbnRpdHkgPSAoXG4gIGhhc3M6IEhvbWVBc3Npc3RhbnQsXG4gIGVudGl0aWVzOiBFbnRpdHlSZWdpc3RyeUVudHJ5W11cbik6IEVudGl0eVJlZ2lzdHJ5RW50cnkgfCB1bmRlZmluZWQgPT5cbiAgZW50aXRpZXMuZmluZChcbiAgICAoZW50aXR5KSA9PlxuICAgICAgaGFzcy5zdGF0ZXNbZW50aXR5LmVudGl0eV9pZF0gJiZcbiAgICAgIGhhc3Muc3RhdGVzW2VudGl0eS5lbnRpdHlfaWRdLmF0dHJpYnV0ZXMuZGV2aWNlX2NsYXNzID09PSBcImJhdHRlcnlcIlxuICApO1xuXG5leHBvcnQgY29uc3QgY29tcHV0ZUVudGl0eVJlZ2lzdHJ5TmFtZSA9IChcbiAgaGFzczogSG9tZUFzc2lzdGFudCxcbiAgZW50cnk6IEVudGl0eVJlZ2lzdHJ5RW50cnlcbik6IHN0cmluZyB8IG51bGwgPT4ge1xuICBpZiAoZW50cnkubmFtZSkge1xuICAgIHJldHVybiBlbnRyeS5uYW1lO1xuICB9XG4gIGNvbnN0IHN0YXRlID0gaGFzcy5zdGF0ZXNbZW50cnkuZW50aXR5X2lkXTtcbiAgcmV0dXJuIHN0YXRlID8gY29tcHV0ZVN0YXRlTmFtZShzdGF0ZSkgOiBudWxsO1xufTtcblxuZXhwb3J0IGNvbnN0IGdldEV4dGVuZGVkRW50aXR5UmVnaXN0cnlFbnRyeSA9IChcbiAgaGFzczogSG9tZUFzc2lzdGFudCxcbiAgZW50aXR5SWQ6IHN0cmluZ1xuKTogUHJvbWlzZTxFeHRFbnRpdHlSZWdpc3RyeUVudHJ5PiA9PlxuICBoYXNzLmNhbGxXUyh7XG4gICAgdHlwZTogXCJjb25maWcvZW50aXR5X3JlZ2lzdHJ5L2dldFwiLFxuICAgIGVudGl0eV9pZDogZW50aXR5SWQsXG4gIH0pO1xuXG5leHBvcnQgY29uc3QgdXBkYXRlRW50aXR5UmVnaXN0cnlFbnRyeSA9IChcbiAgaGFzczogSG9tZUFzc2lzdGFudCxcbiAgZW50aXR5SWQ6IHN0cmluZyxcbiAgdXBkYXRlczogUGFydGlhbDxFbnRpdHlSZWdpc3RyeUVudHJ5VXBkYXRlUGFyYW1zPlxuKTogUHJvbWlzZTxFeHRFbnRpdHlSZWdpc3RyeUVudHJ5PiA9PlxuICBoYXNzLmNhbGxXUyh7XG4gICAgdHlwZTogXCJjb25maWcvZW50aXR5X3JlZ2lzdHJ5L3VwZGF0ZVwiLFxuICAgIGVudGl0eV9pZDogZW50aXR5SWQsXG4gICAgLi4udXBkYXRlcyxcbiAgfSk7XG5cbmV4cG9ydCBjb25zdCByZW1vdmVFbnRpdHlSZWdpc3RyeUVudHJ5ID0gKFxuICBoYXNzOiBIb21lQXNzaXN0YW50LFxuICBlbnRpdHlJZDogc3RyaW5nXG4pOiBQcm9taXNlPHZvaWQ+ID0+XG4gIGhhc3MuY2FsbFdTKHtcbiAgICB0eXBlOiBcImNvbmZpZy9lbnRpdHlfcmVnaXN0cnkvcmVtb3ZlXCIsXG4gICAgZW50aXR5X2lkOiBlbnRpdHlJZCxcbiAgfSk7XG5cbmNvbnN0IGZldGNoRW50aXR5UmVnaXN0cnkgPSAoY29ubikgPT5cbiAgY29ubi5zZW5kTWVzc2FnZVByb21pc2Uoe1xuICAgIHR5cGU6IFwiY29uZmlnL2VudGl0eV9yZWdpc3RyeS9saXN0XCIsXG4gIH0pO1xuXG5jb25zdCBzdWJzY3JpYmVFbnRpdHlSZWdpc3RyeVVwZGF0ZXMgPSAoY29ubiwgc3RvcmUpID0+XG4gIGNvbm4uc3Vic2NyaWJlRXZlbnRzKFxuICAgIGRlYm91bmNlKFxuICAgICAgKCkgPT5cbiAgICAgICAgZmV0Y2hFbnRpdHlSZWdpc3RyeShjb25uKS50aGVuKChlbnRpdGllcykgPT5cbiAgICAgICAgICBzdG9yZS5zZXRTdGF0ZShlbnRpdGllcywgdHJ1ZSlcbiAgICAgICAgKSxcbiAgICAgIDUwMCxcbiAgICAgIHRydWVcbiAgICApLFxuICAgIFwiZW50aXR5X3JlZ2lzdHJ5X3VwZGF0ZWRcIlxuICApO1xuXG5leHBvcnQgY29uc3Qgc3Vic2NyaWJlRW50aXR5UmVnaXN0cnkgPSAoXG4gIGNvbm46IENvbm5lY3Rpb24sXG4gIG9uQ2hhbmdlOiAoZW50aXRpZXM6IEVudGl0eVJlZ2lzdHJ5RW50cnlbXSkgPT4gdm9pZFxuKSA9PlxuICBjcmVhdGVDb2xsZWN0aW9uPEVudGl0eVJlZ2lzdHJ5RW50cnlbXT4oXG4gICAgXCJfZW50aXR5UmVnaXN0cnlcIixcbiAgICBmZXRjaEVudGl0eVJlZ2lzdHJ5LFxuICAgIHN1YnNjcmliZUVudGl0eVJlZ2lzdHJ5VXBkYXRlcyxcbiAgICBjb25uLFxuICAgIG9uQ2hhbmdlXG4gICk7XG4iLCJpbXBvcnQgeyBMb2NhbGl6ZUZ1bmMgfSBmcm9tIFwiLi4vY29tbW9uL3RyYW5zbGF0aW9ucy9sb2NhbGl6ZVwiO1xuaW1wb3J0IHsgSG9tZUFzc2lzdGFudCB9IGZyb20gXCIuLi90eXBlc1wiO1xuXG5leHBvcnQgaW50ZXJmYWNlIEludGVncmF0aW9uTWFuaWZlc3Qge1xuICBpc19idWlsdF9pbjogYm9vbGVhbjtcbiAgZG9tYWluOiBzdHJpbmc7XG4gIG5hbWU6IHN0cmluZztcbiAgY29uZmlnX2Zsb3c6IGJvb2xlYW47XG4gIGRvY3VtZW50YXRpb246IHN0cmluZztcbiAgZGVwZW5kZW5jaWVzPzogc3RyaW5nW107XG4gIGFmdGVyX2RlcGVuZGVuY2llcz86IHN0cmluZ1tdO1xuICBjb2Rlb3duZXJzPzogc3RyaW5nW107XG4gIHJlcXVpcmVtZW50cz86IHN0cmluZ1tdO1xuICBzc2RwPzogQXJyYXk8eyBtYW51ZmFjdHVyZXI/OiBzdHJpbmc7IG1vZGVsTmFtZT86IHN0cmluZzsgc3Q/OiBzdHJpbmcgfT47XG4gIHplcm9jb25mPzogc3RyaW5nW107XG4gIGhvbWVraXQ/OiB7IG1vZGVsczogc3RyaW5nW10gfTtcbiAgcXVhbGl0eV9zY2FsZT86IHN0cmluZztcbn1cblxuZXhwb3J0IGNvbnN0IGludGVncmF0aW9uSXNzdWVzVXJsID0gKGRvbWFpbjogc3RyaW5nKSA9PlxuICBgaHR0cHM6Ly9naXRodWIuY29tL2hvbWUtYXNzaXN0YW50L2hvbWUtYXNzaXN0YW50L2lzc3Vlcz9xPWlzJTNBaXNzdWUraXMlM0FvcGVuK2xhYmVsJTNBJTIyaW50ZWdyYXRpb24lM0ErJHtkb21haW59JTIyYDtcblxuZXhwb3J0IGNvbnN0IGRvbWFpblRvTmFtZSA9IChsb2NhbGl6ZTogTG9jYWxpemVGdW5jLCBkb21haW46IHN0cmluZykgPT5cbiAgbG9jYWxpemUoYGNvbXBvbmVudC4ke2RvbWFpbn0udGl0bGVgKSB8fCBkb21haW47XG5cbmV4cG9ydCBjb25zdCBmZXRjaEludGVncmF0aW9uTWFuaWZlc3RzID0gKGhhc3M6IEhvbWVBc3Npc3RhbnQpID0+XG4gIGhhc3MuY2FsbFdTPEludGVncmF0aW9uTWFuaWZlc3RbXT4oeyB0eXBlOiBcIm1hbmlmZXN0L2xpc3RcIiB9KTtcblxuZXhwb3J0IGNvbnN0IGZldGNoSW50ZWdyYXRpb25NYW5pZmVzdCA9IChcbiAgaGFzczogSG9tZUFzc2lzdGFudCxcbiAgaW50ZWdyYXRpb246IHN0cmluZ1xuKSA9PiBoYXNzLmNhbGxXUzxJbnRlZ3JhdGlvbk1hbmlmZXN0Pih7IHR5cGU6IFwibWFuaWZlc3QvZ2V0XCIsIGludGVncmF0aW9uIH0pO1xuIiwiaW1wb3J0IHsgSG9tZUFzc2lzdGFudCB9IGZyb20gXCIuLi90eXBlc1wiO1xuaW1wb3J0IHsgRGF0YUVudHJ5Rmxvd1N0ZXAgfSBmcm9tIFwiLi9kYXRhX2VudHJ5X2Zsb3dcIjtcblxuZXhwb3J0IGNvbnN0IGNyZWF0ZU9wdGlvbnNGbG93ID0gKGhhc3M6IEhvbWVBc3Npc3RhbnQsIGhhbmRsZXI6IHN0cmluZykgPT5cbiAgaGFzcy5jYWxsQXBpPERhdGFFbnRyeUZsb3dTdGVwPihcbiAgICBcIlBPU1RcIixcbiAgICBcImNvbmZpZy9jb25maWdfZW50cmllcy9vcHRpb25zL2Zsb3dcIixcbiAgICB7XG4gICAgICBoYW5kbGVyLFxuICAgICAgc2hvd19hZHZhbmNlZF9vcHRpb25zOiBCb29sZWFuKGhhc3MudXNlckRhdGE/LnNob3dBZHZhbmNlZCksXG4gICAgfVxuICApO1xuXG5leHBvcnQgY29uc3QgZmV0Y2hPcHRpb25zRmxvdyA9IChoYXNzOiBIb21lQXNzaXN0YW50LCBmbG93SWQ6IHN0cmluZykgPT5cbiAgaGFzcy5jYWxsQXBpPERhdGFFbnRyeUZsb3dTdGVwPihcbiAgICBcIkdFVFwiLFxuICAgIGBjb25maWcvY29uZmlnX2VudHJpZXMvb3B0aW9ucy9mbG93LyR7Zmxvd0lkfWBcbiAgKTtcblxuZXhwb3J0IGNvbnN0IGhhbmRsZU9wdGlvbnNGbG93U3RlcCA9IChcbiAgaGFzczogSG9tZUFzc2lzdGFudCxcbiAgZmxvd0lkOiBzdHJpbmcsXG4gIGRhdGE6IHsgW2tleTogc3RyaW5nXTogYW55IH1cbikgPT5cbiAgaGFzcy5jYWxsQXBpPERhdGFFbnRyeUZsb3dTdGVwPihcbiAgICBcIlBPU1RcIixcbiAgICBgY29uZmlnL2NvbmZpZ19lbnRyaWVzL29wdGlvbnMvZmxvdy8ke2Zsb3dJZH1gLFxuICAgIGRhdGFcbiAgKTtcblxuZXhwb3J0IGNvbnN0IGRlbGV0ZU9wdGlvbnNGbG93ID0gKGhhc3M6IEhvbWVBc3Npc3RhbnQsIGZsb3dJZDogc3RyaW5nKSA9PlxuICBoYXNzLmNhbGxBcGkoXCJERUxFVEVcIiwgYGNvbmZpZy9jb25maWdfZW50cmllcy9vcHRpb25zL2Zsb3cvJHtmbG93SWR9YCk7XG4iLCJpbXBvcnQgeyBmaXJlRXZlbnQgfSBmcm9tIFwiLi4vLi4vY29tbW9uL2RvbS9maXJlX2V2ZW50XCI7XG5pbXBvcnQgeyBDb25maWdFbnRyeSB9IGZyb20gXCIuLi8uLi9kYXRhL2NvbmZpZ19lbnRyaWVzXCI7XG5cbmV4cG9ydCBpbnRlcmZhY2UgQ29uZmlnRW50cnlTeXN0ZW1PcHRpb25zRGlhbG9nUGFyYW1zIHtcbiAgZW50cnk6IENvbmZpZ0VudHJ5O1xuICAvLyB1cGRhdGVFbnRyeTogKFxuICAvLyAgIHVwZGF0ZXM6IFBhcnRpYWw8RW50aXR5UmVnaXN0cnlFbnRyeVVwZGF0ZVBhcmFtcz5cbiAgLy8gKSA9PiBQcm9taXNlPHVua25vd24+O1xuICAvLyByZW1vdmVFbnRyeTogKCkgPT4gUHJvbWlzZTxib29sZWFuPjtcbn1cblxuZXhwb3J0IGNvbnN0IGxvYWRDb25maWdFbnRyeVN5c3RlbU9wdGlvbnNEaWFsb2cgPSAoKSA9PlxuICBpbXBvcnQoXG4gICAgLyogd2VicGFja0NodW5rTmFtZTogXCJjb25maWctZW50cnktc3lzdGVtLW9wdGlvbnNcIiAqLyBcIi4vZGlhbG9nLWNvbmZpZy1lbnRyeS1zeXN0ZW0tb3B0aW9uc1wiXG4gICk7XG5cbmV4cG9ydCBjb25zdCBzaG93Q29uZmlnRW50cnlTeXN0ZW1PcHRpb25zRGlhbG9nID0gKFxuICBlbGVtZW50OiBIVE1MRWxlbWVudCxcbiAgc3lzdGVtTG9nRGV0YWlsUGFyYW1zOiBDb25maWdFbnRyeVN5c3RlbU9wdGlvbnNEaWFsb2dQYXJhbXNcbik6IHZvaWQgPT4ge1xuICBmaXJlRXZlbnQoZWxlbWVudCwgXCJzaG93LWRpYWxvZ1wiLCB7XG4gICAgZGlhbG9nVGFnOiBcImRpYWxvZy1jb25maWctZW50cnktc3lzdGVtLW9wdGlvbnNcIixcbiAgICBkaWFsb2dJbXBvcnQ6IGxvYWRDb25maWdFbnRyeVN5c3RlbU9wdGlvbnNEaWFsb2csXG4gICAgZGlhbG9nUGFyYW1zOiBzeXN0ZW1Mb2dEZXRhaWxQYXJhbXMsXG4gIH0pO1xufTtcbiIsImltcG9ydCB7IGh0bWwgfSBmcm9tIFwibGl0LWVsZW1lbnRcIjtcbmltcG9ydCB7IGNhc2VJbnNlbnNpdGl2ZUNvbXBhcmUgfSBmcm9tIFwiLi4vLi4vY29tbW9uL3N0cmluZy9jb21wYXJlXCI7XG5pbXBvcnQgeyBsb2NhbGl6ZUtleSB9IGZyb20gXCIuLi8uLi9jb21tb24vdHJhbnNsYXRpb25zL2xvY2FsaXplXCI7XG5pbXBvcnQge1xuICBjcmVhdGVDb25maWdGbG93LFxuICBkZWxldGVDb25maWdGbG93LFxuICBmZXRjaENvbmZpZ0Zsb3csXG4gIGdldENvbmZpZ0Zsb3dIYW5kbGVycyxcbiAgaGFuZGxlQ29uZmlnRmxvd1N0ZXAsXG59IGZyb20gXCIuLi8uLi9kYXRhL2NvbmZpZ19mbG93XCI7XG5pbXBvcnQgeyBkb21haW5Ub05hbWUgfSBmcm9tIFwiLi4vLi4vZGF0YS9pbnRlZ3JhdGlvblwiO1xuaW1wb3J0IHtcbiAgRGF0YUVudHJ5Rmxvd0RpYWxvZ1BhcmFtcyxcbiAgbG9hZERhdGFFbnRyeUZsb3dEaWFsb2csXG4gIHNob3dGbG93RGlhbG9nLFxufSBmcm9tIFwiLi9zaG93LWRpYWxvZy1kYXRhLWVudHJ5LWZsb3dcIjtcblxuZXhwb3J0IGNvbnN0IGxvYWRDb25maWdGbG93RGlhbG9nID0gbG9hZERhdGFFbnRyeUZsb3dEaWFsb2c7XG5cbmV4cG9ydCBjb25zdCBzaG93Q29uZmlnRmxvd0RpYWxvZyA9IChcbiAgZWxlbWVudDogSFRNTEVsZW1lbnQsXG4gIGRpYWxvZ1BhcmFtczogT21pdDxEYXRhRW50cnlGbG93RGlhbG9nUGFyYW1zLCBcImZsb3dDb25maWdcIj5cbik6IHZvaWQgPT5cbiAgc2hvd0Zsb3dEaWFsb2coZWxlbWVudCwgZGlhbG9nUGFyYW1zLCB7XG4gICAgbG9hZERldmljZXNBbmRBcmVhczogdHJ1ZSxcbiAgICBnZXRGbG93SGFuZGxlcnM6IGFzeW5jIChoYXNzKSA9PiB7XG4gICAgICBjb25zdCBbaGFuZGxlcnNdID0gYXdhaXQgUHJvbWlzZS5hbGwoW1xuICAgICAgICBnZXRDb25maWdGbG93SGFuZGxlcnMoaGFzcyksXG4gICAgICAgIGhhc3MubG9hZEJhY2tlbmRUcmFuc2xhdGlvbihcInRpdGxlXCIsIHVuZGVmaW5lZCwgdHJ1ZSksXG4gICAgICBdKTtcblxuICAgICAgcmV0dXJuIGhhbmRsZXJzLnNvcnQoKGhhbmRsZXJBLCBoYW5kbGVyQikgPT5cbiAgICAgICAgY2FzZUluc2Vuc2l0aXZlQ29tcGFyZShcbiAgICAgICAgICBkb21haW5Ub05hbWUoaGFzcy5sb2NhbGl6ZSwgaGFuZGxlckEpLFxuICAgICAgICAgIGRvbWFpblRvTmFtZShoYXNzLmxvY2FsaXplLCBoYW5kbGVyQilcbiAgICAgICAgKVxuICAgICAgKTtcbiAgICB9LFxuICAgIGNyZWF0ZUZsb3c6IGFzeW5jIChoYXNzLCBoYW5kbGVyKSA9PiB7XG4gICAgICBjb25zdCBbc3RlcF0gPSBhd2FpdCBQcm9taXNlLmFsbChbXG4gICAgICAgIGNyZWF0ZUNvbmZpZ0Zsb3coaGFzcywgaGFuZGxlciksXG4gICAgICAgIGhhc3MubG9hZEJhY2tlbmRUcmFuc2xhdGlvbihcImNvbmZpZ1wiLCBoYW5kbGVyKSxcbiAgICAgIF0pO1xuICAgICAgcmV0dXJuIHN0ZXA7XG4gICAgfSxcbiAgICBmZXRjaEZsb3c6IGFzeW5jIChoYXNzLCBmbG93SWQpID0+IHtcbiAgICAgIGNvbnN0IHN0ZXAgPSBhd2FpdCBmZXRjaENvbmZpZ0Zsb3coaGFzcywgZmxvd0lkKTtcbiAgICAgIGF3YWl0IGhhc3MubG9hZEJhY2tlbmRUcmFuc2xhdGlvbihcImNvbmZpZ1wiLCBzdGVwLmhhbmRsZXIpO1xuICAgICAgcmV0dXJuIHN0ZXA7XG4gICAgfSxcbiAgICBoYW5kbGVGbG93U3RlcDogaGFuZGxlQ29uZmlnRmxvd1N0ZXAsXG4gICAgZGVsZXRlRmxvdzogZGVsZXRlQ29uZmlnRmxvdyxcblxuICAgIHJlbmRlckFib3J0RGVzY3JpcHRpb24oaGFzcywgc3RlcCkge1xuICAgICAgY29uc3QgZGVzY3JpcHRpb24gPSBsb2NhbGl6ZUtleShcbiAgICAgICAgaGFzcy5sb2NhbGl6ZSxcbiAgICAgICAgYGNvbXBvbmVudC4ke3N0ZXAuaGFuZGxlcn0uY29uZmlnLmFib3J0LiR7c3RlcC5yZWFzb259YCxcbiAgICAgICAgc3RlcC5kZXNjcmlwdGlvbl9wbGFjZWhvbGRlcnNcbiAgICAgICk7XG5cbiAgICAgIHJldHVybiBkZXNjcmlwdGlvblxuICAgICAgICA/IGh0bWxgXG4gICAgICAgICAgICA8aGEtbWFya2Rvd24gYWxsb3dzdmcgYnJlYWtzIC5jb250ZW50PSR7ZGVzY3JpcHRpb259PjwvaGEtbWFya2Rvd24+XG4gICAgICAgICAgYFxuICAgICAgICA6IFwiXCI7XG4gICAgfSxcblxuICAgIHJlbmRlclNob3dGb3JtU3RlcEhlYWRlcihoYXNzLCBzdGVwKSB7XG4gICAgICByZXR1cm4gKFxuICAgICAgICBoYXNzLmxvY2FsaXplKFxuICAgICAgICAgIGBjb21wb25lbnQuJHtzdGVwLmhhbmRsZXJ9LmNvbmZpZy5zdGVwLiR7c3RlcC5zdGVwX2lkfS50aXRsZWBcbiAgICAgICAgKSB8fCBoYXNzLmxvY2FsaXplKGBjb21wb25lbnQuJHtzdGVwLmhhbmRsZXJ9LnRpdGxlYClcbiAgICAgICk7XG4gICAgfSxcblxuICAgIHJlbmRlclNob3dGb3JtU3RlcERlc2NyaXB0aW9uKGhhc3MsIHN0ZXApIHtcbiAgICAgIGNvbnN0IGRlc2NyaXB0aW9uID0gbG9jYWxpemVLZXkoXG4gICAgICAgIGhhc3MubG9jYWxpemUsXG4gICAgICAgIGBjb21wb25lbnQuJHtzdGVwLmhhbmRsZXJ9LmNvbmZpZy5zdGVwLiR7c3RlcC5zdGVwX2lkfS5kZXNjcmlwdGlvbmAsXG4gICAgICAgIHN0ZXAuZGVzY3JpcHRpb25fcGxhY2Vob2xkZXJzXG4gICAgICApO1xuICAgICAgcmV0dXJuIGRlc2NyaXB0aW9uXG4gICAgICAgID8gaHRtbGBcbiAgICAgICAgICAgIDxoYS1tYXJrZG93biBhbGxvd3N2ZyBicmVha3MgLmNvbnRlbnQ9JHtkZXNjcmlwdGlvbn0+PC9oYS1tYXJrZG93bj5cbiAgICAgICAgICBgXG4gICAgICAgIDogXCJcIjtcbiAgICB9LFxuXG4gICAgcmVuZGVyU2hvd0Zvcm1TdGVwRmllbGRMYWJlbChoYXNzLCBzdGVwLCBmaWVsZCkge1xuICAgICAgcmV0dXJuIGhhc3MubG9jYWxpemUoXG4gICAgICAgIGBjb21wb25lbnQuJHtzdGVwLmhhbmRsZXJ9LmNvbmZpZy5zdGVwLiR7c3RlcC5zdGVwX2lkfS5kYXRhLiR7ZmllbGQubmFtZX1gXG4gICAgICApO1xuICAgIH0sXG5cbiAgICByZW5kZXJTaG93Rm9ybVN0ZXBGaWVsZEVycm9yKGhhc3MsIHN0ZXAsIGVycm9yKSB7XG4gICAgICByZXR1cm4gaGFzcy5sb2NhbGl6ZShgY29tcG9uZW50LiR7c3RlcC5oYW5kbGVyfS5jb25maWcuZXJyb3IuJHtlcnJvcn1gKTtcbiAgICB9LFxuXG4gICAgcmVuZGVyRXh0ZXJuYWxTdGVwSGVhZGVyKGhhc3MsIHN0ZXApIHtcbiAgICAgIHJldHVybiBoYXNzLmxvY2FsaXplKFxuICAgICAgICBgY29tcG9uZW50LiR7c3RlcC5oYW5kbGVyfS5jb25maWcuc3RlcC4ke3N0ZXAuc3RlcF9pZH0udGl0bGVgXG4gICAgICApO1xuICAgIH0sXG5cbiAgICByZW5kZXJFeHRlcm5hbFN0ZXBEZXNjcmlwdGlvbihoYXNzLCBzdGVwKSB7XG4gICAgICBjb25zdCBkZXNjcmlwdGlvbiA9IGxvY2FsaXplS2V5KFxuICAgICAgICBoYXNzLmxvY2FsaXplLFxuICAgICAgICBgY29tcG9uZW50LiR7c3RlcC5oYW5kbGVyfS5jb25maWcuJHtzdGVwLnN0ZXBfaWR9LmRlc2NyaXB0aW9uYCxcbiAgICAgICAgc3RlcC5kZXNjcmlwdGlvbl9wbGFjZWhvbGRlcnNcbiAgICAgICk7XG5cbiAgICAgIHJldHVybiBodG1sYFxuICAgICAgICA8cD5cbiAgICAgICAgICAke2hhc3MubG9jYWxpemUoXG4gICAgICAgICAgICBcInVpLnBhbmVsLmNvbmZpZy5pbnRlZ3JhdGlvbnMuY29uZmlnX2Zsb3cuZXh0ZXJuYWxfc3RlcC5kZXNjcmlwdGlvblwiXG4gICAgICAgICAgKX1cbiAgICAgICAgPC9wPlxuICAgICAgICAke2Rlc2NyaXB0aW9uXG4gICAgICAgICAgPyBodG1sYFxuICAgICAgICAgICAgICA8aGEtbWFya2Rvd25cbiAgICAgICAgICAgICAgICBhbGxvd3N2Z1xuICAgICAgICAgICAgICAgIGJyZWFrc1xuICAgICAgICAgICAgICAgIC5jb250ZW50PSR7ZGVzY3JpcHRpb259XG4gICAgICAgICAgICAgID48L2hhLW1hcmtkb3duPlxuICAgICAgICAgICAgYFxuICAgICAgICAgIDogXCJcIn1cbiAgICAgIGA7XG4gICAgfSxcblxuICAgIHJlbmRlckNyZWF0ZUVudHJ5RGVzY3JpcHRpb24oaGFzcywgc3RlcCkge1xuICAgICAgY29uc3QgZGVzY3JpcHRpb24gPSBsb2NhbGl6ZUtleShcbiAgICAgICAgaGFzcy5sb2NhbGl6ZSxcbiAgICAgICAgYGNvbXBvbmVudC4ke3N0ZXAuaGFuZGxlcn0uY29uZmlnLmNyZWF0ZV9lbnRyeS4ke1xuICAgICAgICAgIHN0ZXAuZGVzY3JpcHRpb24gfHwgXCJkZWZhdWx0XCJcbiAgICAgICAgfWAsXG4gICAgICAgIHN0ZXAuZGVzY3JpcHRpb25fcGxhY2Vob2xkZXJzXG4gICAgICApO1xuXG4gICAgICByZXR1cm4gaHRtbGBcbiAgICAgICAgJHtkZXNjcmlwdGlvblxuICAgICAgICAgID8gaHRtbGBcbiAgICAgICAgICAgICAgPGhhLW1hcmtkb3duXG4gICAgICAgICAgICAgICAgYWxsb3dzdmdcbiAgICAgICAgICAgICAgICBicmVha3NcbiAgICAgICAgICAgICAgICAuY29udGVudD0ke2Rlc2NyaXB0aW9ufVxuICAgICAgICAgICAgICA+PC9oYS1tYXJrZG93bj5cbiAgICAgICAgICAgIGBcbiAgICAgICAgICA6IFwiXCJ9XG4gICAgICAgIDxwPlxuICAgICAgICAgICR7aGFzcy5sb2NhbGl6ZShcbiAgICAgICAgICAgIFwidWkucGFuZWwuY29uZmlnLmludGVncmF0aW9ucy5jb25maWdfZmxvdy5jcmVhdGVkX2NvbmZpZ1wiLFxuICAgICAgICAgICAgXCJuYW1lXCIsXG4gICAgICAgICAgICBzdGVwLnRpdGxlXG4gICAgICAgICAgKX1cbiAgICAgICAgPC9wPlxuICAgICAgYDtcbiAgICB9LFxuICB9KTtcbiIsImltcG9ydCB7IFRlbXBsYXRlUmVzdWx0IH0gZnJvbSBcImxpdC1odG1sXCI7XG5pbXBvcnQgeyBmaXJlRXZlbnQgfSBmcm9tIFwiLi4vLi4vY29tbW9uL2RvbS9maXJlX2V2ZW50XCI7XG5pbXBvcnQgeyBIYUZvcm1TY2hlbWEgfSBmcm9tIFwiLi4vLi4vY29tcG9uZW50cy9oYS1mb3JtL2hhLWZvcm1cIjtcbmltcG9ydCB7XG4gIERhdGFFbnRyeUZsb3dTdGVwLFxuICBEYXRhRW50cnlGbG93U3RlcEFib3J0LFxuICBEYXRhRW50cnlGbG93U3RlcENyZWF0ZUVudHJ5LFxuICBEYXRhRW50cnlGbG93U3RlcEV4dGVybmFsLFxuICBEYXRhRW50cnlGbG93U3RlcEZvcm0sXG59IGZyb20gXCIuLi8uLi9kYXRhL2RhdGFfZW50cnlfZmxvd1wiO1xuaW1wb3J0IHsgSG9tZUFzc2lzdGFudCB9IGZyb20gXCIuLi8uLi90eXBlc1wiO1xuXG5leHBvcnQgaW50ZXJmYWNlIEZsb3dDb25maWcge1xuICBsb2FkRGV2aWNlc0FuZEFyZWFzOiBib29sZWFuO1xuXG4gIGdldEZsb3dIYW5kbGVycz86IChoYXNzOiBIb21lQXNzaXN0YW50KSA9PiBQcm9taXNlPHN0cmluZ1tdPjtcblxuICBjcmVhdGVGbG93KGhhc3M6IEhvbWVBc3Npc3RhbnQsIGhhbmRsZXI6IHN0cmluZyk6IFByb21pc2U8RGF0YUVudHJ5Rmxvd1N0ZXA+O1xuXG4gIGZldGNoRmxvdyhoYXNzOiBIb21lQXNzaXN0YW50LCBmbG93SWQ6IHN0cmluZyk6IFByb21pc2U8RGF0YUVudHJ5Rmxvd1N0ZXA+O1xuXG4gIGhhbmRsZUZsb3dTdGVwKFxuICAgIGhhc3M6IEhvbWVBc3Npc3RhbnQsXG4gICAgZmxvd0lkOiBzdHJpbmcsXG4gICAgZGF0YTogeyBba2V5OiBzdHJpbmddOiBhbnkgfVxuICApOiBQcm9taXNlPERhdGFFbnRyeUZsb3dTdGVwPjtcblxuICBkZWxldGVGbG93KGhhc3M6IEhvbWVBc3Npc3RhbnQsIGZsb3dJZDogc3RyaW5nKTogUHJvbWlzZTx1bmtub3duPjtcblxuICByZW5kZXJBYm9ydERlc2NyaXB0aW9uKFxuICAgIGhhc3M6IEhvbWVBc3Npc3RhbnQsXG4gICAgc3RlcDogRGF0YUVudHJ5Rmxvd1N0ZXBBYm9ydFxuICApOiBUZW1wbGF0ZVJlc3VsdCB8IFwiXCI7XG5cbiAgcmVuZGVyU2hvd0Zvcm1TdGVwSGVhZGVyKFxuICAgIGhhc3M6IEhvbWVBc3Npc3RhbnQsXG4gICAgc3RlcDogRGF0YUVudHJ5Rmxvd1N0ZXBGb3JtXG4gICk6IHN0cmluZztcblxuICByZW5kZXJTaG93Rm9ybVN0ZXBEZXNjcmlwdGlvbihcbiAgICBoYXNzOiBIb21lQXNzaXN0YW50LFxuICAgIHN0ZXA6IERhdGFFbnRyeUZsb3dTdGVwRm9ybVxuICApOiBUZW1wbGF0ZVJlc3VsdCB8IFwiXCI7XG5cbiAgcmVuZGVyU2hvd0Zvcm1TdGVwRmllbGRMYWJlbChcbiAgICBoYXNzOiBIb21lQXNzaXN0YW50LFxuICAgIHN0ZXA6IERhdGFFbnRyeUZsb3dTdGVwRm9ybSxcbiAgICBmaWVsZDogSGFGb3JtU2NoZW1hXG4gICk6IHN0cmluZztcblxuICByZW5kZXJTaG93Rm9ybVN0ZXBGaWVsZEVycm9yKFxuICAgIGhhc3M6IEhvbWVBc3Npc3RhbnQsXG4gICAgc3RlcDogRGF0YUVudHJ5Rmxvd1N0ZXBGb3JtLFxuICAgIGVycm9yOiBzdHJpbmdcbiAgKTogc3RyaW5nO1xuXG4gIHJlbmRlckV4dGVybmFsU3RlcEhlYWRlcihcbiAgICBoYXNzOiBIb21lQXNzaXN0YW50LFxuICAgIHN0ZXA6IERhdGFFbnRyeUZsb3dTdGVwRXh0ZXJuYWxcbiAgKTogc3RyaW5nO1xuXG4gIHJlbmRlckV4dGVybmFsU3RlcERlc2NyaXB0aW9uKFxuICAgIGhhc3M6IEhvbWVBc3Npc3RhbnQsXG4gICAgc3RlcDogRGF0YUVudHJ5Rmxvd1N0ZXBFeHRlcm5hbFxuICApOiBUZW1wbGF0ZVJlc3VsdCB8IFwiXCI7XG5cbiAgcmVuZGVyQ3JlYXRlRW50cnlEZXNjcmlwdGlvbihcbiAgICBoYXNzOiBIb21lQXNzaXN0YW50LFxuICAgIHN0ZXA6IERhdGFFbnRyeUZsb3dTdGVwQ3JlYXRlRW50cnlcbiAgKTogVGVtcGxhdGVSZXN1bHQgfCBcIlwiO1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIERhdGFFbnRyeUZsb3dEaWFsb2dQYXJhbXMge1xuICBzdGFydEZsb3dIYW5kbGVyPzogc3RyaW5nO1xuICBjb250aW51ZUZsb3dJZD86IHN0cmluZztcbiAgZGlhbG9nQ2xvc2VkQ2FsbGJhY2s/OiAocGFyYW1zOiB7IGZsb3dGaW5pc2hlZDogYm9vbGVhbiB9KSA9PiB2b2lkO1xuICBmbG93Q29uZmlnOiBGbG93Q29uZmlnO1xuICBzaG93QWR2YW5jZWQ/OiBib29sZWFuO1xufVxuXG5leHBvcnQgY29uc3QgbG9hZERhdGFFbnRyeUZsb3dEaWFsb2cgPSAoKSA9PlxuICBpbXBvcnQoXG4gICAgLyogd2VicGFja0NodW5rTmFtZTogXCJkaWFsb2ctY29uZmlnLWZsb3dcIiAqLyBcIi4vZGlhbG9nLWRhdGEtZW50cnktZmxvd1wiXG4gICk7XG5cbmV4cG9ydCBjb25zdCBzaG93Rmxvd0RpYWxvZyA9IChcbiAgZWxlbWVudDogSFRNTEVsZW1lbnQsXG4gIGRpYWxvZ1BhcmFtczogT21pdDxEYXRhRW50cnlGbG93RGlhbG9nUGFyYW1zLCBcImZsb3dDb25maWdcIj4sXG4gIGZsb3dDb25maWc6IEZsb3dDb25maWdcbik6IHZvaWQgPT4ge1xuICBmaXJlRXZlbnQoZWxlbWVudCwgXCJzaG93LWRpYWxvZ1wiLCB7XG4gICAgZGlhbG9nVGFnOiBcImRpYWxvZy1kYXRhLWVudHJ5LWZsb3dcIixcbiAgICBkaWFsb2dJbXBvcnQ6IGxvYWREYXRhRW50cnlGbG93RGlhbG9nLFxuICAgIGRpYWxvZ1BhcmFtczoge1xuICAgICAgLi4uZGlhbG9nUGFyYW1zLFxuICAgICAgZmxvd0NvbmZpZyxcbiAgICB9LFxuICB9KTtcbn07XG4iLCJpbXBvcnQgeyBodG1sIH0gZnJvbSBcImxpdC1lbGVtZW50XCI7XG5pbXBvcnQgeyBsb2NhbGl6ZUtleSB9IGZyb20gXCIuLi8uLi9jb21tb24vdHJhbnNsYXRpb25zL2xvY2FsaXplXCI7XG5pbXBvcnQgeyBDb25maWdFbnRyeSB9IGZyb20gXCIuLi8uLi9kYXRhL2NvbmZpZ19lbnRyaWVzXCI7XG5pbXBvcnQge1xuICBjcmVhdGVPcHRpb25zRmxvdyxcbiAgZGVsZXRlT3B0aW9uc0Zsb3csXG4gIGZldGNoT3B0aW9uc0Zsb3csXG4gIGhhbmRsZU9wdGlvbnNGbG93U3RlcCxcbn0gZnJvbSBcIi4uLy4uL2RhdGEvb3B0aW9uc19mbG93XCI7XG5pbXBvcnQge1xuICBsb2FkRGF0YUVudHJ5Rmxvd0RpYWxvZyxcbiAgc2hvd0Zsb3dEaWFsb2csXG59IGZyb20gXCIuL3Nob3ctZGlhbG9nLWRhdGEtZW50cnktZmxvd1wiO1xuXG5leHBvcnQgY29uc3QgbG9hZE9wdGlvbnNGbG93RGlhbG9nID0gbG9hZERhdGFFbnRyeUZsb3dEaWFsb2c7XG5cbmV4cG9ydCBjb25zdCBzaG93T3B0aW9uc0Zsb3dEaWFsb2cgPSAoXG4gIGVsZW1lbnQ6IEhUTUxFbGVtZW50LFxuICBjb25maWdFbnRyeTogQ29uZmlnRW50cnlcbik6IHZvaWQgPT5cbiAgc2hvd0Zsb3dEaWFsb2coXG4gICAgZWxlbWVudCxcbiAgICB7XG4gICAgICBzdGFydEZsb3dIYW5kbGVyOiBjb25maWdFbnRyeS5lbnRyeV9pZCxcbiAgICB9LFxuICAgIHtcbiAgICAgIGxvYWREZXZpY2VzQW5kQXJlYXM6IGZhbHNlLFxuICAgICAgY3JlYXRlRmxvdzogYXN5bmMgKGhhc3MsIGhhbmRsZXIpID0+IHtcbiAgICAgICAgY29uc3QgW3N0ZXBdID0gYXdhaXQgUHJvbWlzZS5hbGwoW1xuICAgICAgICAgIGNyZWF0ZU9wdGlvbnNGbG93KGhhc3MsIGhhbmRsZXIpLFxuICAgICAgICAgIGhhc3MubG9hZEJhY2tlbmRUcmFuc2xhdGlvbihcIm9wdGlvbnNcIiwgY29uZmlnRW50cnkuZG9tYWluKSxcbiAgICAgICAgXSk7XG4gICAgICAgIHJldHVybiBzdGVwO1xuICAgICAgfSxcbiAgICAgIGZldGNoRmxvdzogYXN5bmMgKGhhc3MsIGZsb3dJZCkgPT4ge1xuICAgICAgICBjb25zdCBbc3RlcF0gPSBhd2FpdCBQcm9taXNlLmFsbChbXG4gICAgICAgICAgZmV0Y2hPcHRpb25zRmxvdyhoYXNzLCBmbG93SWQpLFxuICAgICAgICAgIGhhc3MubG9hZEJhY2tlbmRUcmFuc2xhdGlvbihcIm9wdGlvbnNcIiwgY29uZmlnRW50cnkuZG9tYWluKSxcbiAgICAgICAgXSk7XG4gICAgICAgIHJldHVybiBzdGVwO1xuICAgICAgfSxcbiAgICAgIGhhbmRsZUZsb3dTdGVwOiBoYW5kbGVPcHRpb25zRmxvd1N0ZXAsXG4gICAgICBkZWxldGVGbG93OiBkZWxldGVPcHRpb25zRmxvdyxcblxuICAgICAgcmVuZGVyQWJvcnREZXNjcmlwdGlvbihoYXNzLCBzdGVwKSB7XG4gICAgICAgIGNvbnN0IGRlc2NyaXB0aW9uID0gbG9jYWxpemVLZXkoXG4gICAgICAgICAgaGFzcy5sb2NhbGl6ZSxcbiAgICAgICAgICBgY29tcG9uZW50LiR7Y29uZmlnRW50cnkuZG9tYWlufS5vcHRpb25zLmFib3J0LiR7c3RlcC5yZWFzb259YCxcbiAgICAgICAgICBzdGVwLmRlc2NyaXB0aW9uX3BsYWNlaG9sZGVyc1xuICAgICAgICApO1xuXG4gICAgICAgIHJldHVybiBkZXNjcmlwdGlvblxuICAgICAgICAgID8gaHRtbGBcbiAgICAgICAgICAgICAgPGhhLW1hcmtkb3duXG4gICAgICAgICAgICAgICAgYnJlYWtzXG4gICAgICAgICAgICAgICAgYWxsb3dzdmdcbiAgICAgICAgICAgICAgICAuY29udGVudD0ke2Rlc2NyaXB0aW9ufVxuICAgICAgICAgICAgICA+PC9oYS1tYXJrZG93bj5cbiAgICAgICAgICAgIGBcbiAgICAgICAgICA6IFwiXCI7XG4gICAgICB9LFxuXG4gICAgICByZW5kZXJTaG93Rm9ybVN0ZXBIZWFkZXIoaGFzcywgc3RlcCkge1xuICAgICAgICByZXR1cm4gKFxuICAgICAgICAgIGhhc3MubG9jYWxpemUoXG4gICAgICAgICAgICBgY29tcG9uZW50LiR7Y29uZmlnRW50cnkuZG9tYWlufS5vcHRpb25zLnN0ZXAuJHtzdGVwLnN0ZXBfaWR9LnRpdGxlYFxuICAgICAgICAgICkgfHwgaGFzcy5sb2NhbGl6ZShgdWkuZGlhbG9ncy5vcHRpb25zX2Zsb3cuZm9ybS5oZWFkZXJgKVxuICAgICAgICApO1xuICAgICAgfSxcblxuICAgICAgcmVuZGVyU2hvd0Zvcm1TdGVwRGVzY3JpcHRpb24oaGFzcywgc3RlcCkge1xuICAgICAgICBjb25zdCBkZXNjcmlwdGlvbiA9IGxvY2FsaXplS2V5KFxuICAgICAgICAgIGhhc3MubG9jYWxpemUsXG4gICAgICAgICAgYGNvbXBvbmVudC4ke2NvbmZpZ0VudHJ5LmRvbWFpbn0ub3B0aW9ucy5zdGVwLiR7c3RlcC5zdGVwX2lkfS5kZXNjcmlwdGlvbmAsXG4gICAgICAgICAgc3RlcC5kZXNjcmlwdGlvbl9wbGFjZWhvbGRlcnNcbiAgICAgICAgKTtcbiAgICAgICAgcmV0dXJuIGRlc2NyaXB0aW9uXG4gICAgICAgICAgPyBodG1sYFxuICAgICAgICAgICAgICA8aGEtbWFya2Rvd25cbiAgICAgICAgICAgICAgICBhbGxvd3N2Z1xuICAgICAgICAgICAgICAgIGJyZWFrc1xuICAgICAgICAgICAgICAgIC5jb250ZW50PSR7ZGVzY3JpcHRpb259XG4gICAgICAgICAgICAgID48L2hhLW1hcmtkb3duPlxuICAgICAgICAgICAgYFxuICAgICAgICAgIDogXCJcIjtcbiAgICAgIH0sXG5cbiAgICAgIHJlbmRlclNob3dGb3JtU3RlcEZpZWxkTGFiZWwoaGFzcywgc3RlcCwgZmllbGQpIHtcbiAgICAgICAgcmV0dXJuIGhhc3MubG9jYWxpemUoXG4gICAgICAgICAgYGNvbXBvbmVudC4ke2NvbmZpZ0VudHJ5LmRvbWFpbn0ub3B0aW9ucy5zdGVwLiR7c3RlcC5zdGVwX2lkfS5kYXRhLiR7ZmllbGQubmFtZX1gXG4gICAgICAgICk7XG4gICAgICB9LFxuXG4gICAgICByZW5kZXJTaG93Rm9ybVN0ZXBGaWVsZEVycm9yKGhhc3MsIF9zdGVwLCBlcnJvcikge1xuICAgICAgICByZXR1cm4gaGFzcy5sb2NhbGl6ZShcbiAgICAgICAgICBgY29tcG9uZW50LiR7Y29uZmlnRW50cnkuZG9tYWlufS5vcHRpb25zLmVycm9yLiR7ZXJyb3J9YFxuICAgICAgICApO1xuICAgICAgfSxcblxuICAgICAgcmVuZGVyRXh0ZXJuYWxTdGVwSGVhZGVyKF9oYXNzLCBfc3RlcCkge1xuICAgICAgICByZXR1cm4gXCJcIjtcbiAgICAgIH0sXG5cbiAgICAgIHJlbmRlckV4dGVybmFsU3RlcERlc2NyaXB0aW9uKF9oYXNzLCBfc3RlcCkge1xuICAgICAgICByZXR1cm4gXCJcIjtcbiAgICAgIH0sXG5cbiAgICAgIHJlbmRlckNyZWF0ZUVudHJ5RGVzY3JpcHRpb24oaGFzcywgX3N0ZXApIHtcbiAgICAgICAgcmV0dXJuIGh0bWxgXG4gICAgICAgICAgPHA+JHtoYXNzLmxvY2FsaXplKGB1aS5kaWFsb2dzLm9wdGlvbnNfZmxvdy5zdWNjZXNzLmRlc2NyaXB0aW9uYCl9PC9wPlxuICAgICAgICBgO1xuICAgICAgfSxcbiAgICB9XG4gICk7XG4iLCJpbXBvcnQgeyBUZW1wbGF0ZVJlc3VsdCB9IGZyb20gXCJsaXQtaHRtbFwiO1xuaW1wb3J0IHsgZmlyZUV2ZW50IH0gZnJvbSBcIi4uLy4uL2NvbW1vbi9kb20vZmlyZV9ldmVudFwiO1xuXG5pbnRlcmZhY2UgQmFzZURpYWxvZ1BhcmFtcyB7XG4gIGNvbmZpcm1UZXh0Pzogc3RyaW5nO1xuICB0ZXh0Pzogc3RyaW5nIHwgVGVtcGxhdGVSZXN1bHQ7XG4gIHRpdGxlPzogc3RyaW5nO1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIEFsZXJ0RGlhbG9nUGFyYW1zIGV4dGVuZHMgQmFzZURpYWxvZ1BhcmFtcyB7XG4gIGNvbmZpcm0/OiAoKSA9PiB2b2lkO1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIENvbmZpcm1hdGlvbkRpYWxvZ1BhcmFtcyBleHRlbmRzIEJhc2VEaWFsb2dQYXJhbXMge1xuICBkaXNtaXNzVGV4dD86IHN0cmluZztcbiAgY29uZmlybT86ICgpID0+IHZvaWQ7XG4gIGNhbmNlbD86ICgpID0+IHZvaWQ7XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgUHJvbXB0RGlhbG9nUGFyYW1zIGV4dGVuZHMgQmFzZURpYWxvZ1BhcmFtcyB7XG4gIGlucHV0TGFiZWw/OiBzdHJpbmc7XG4gIGlucHV0VHlwZT86IHN0cmluZztcbiAgZGVmYXVsdFZhbHVlPzogc3RyaW5nO1xuICBjb25maXJtPzogKG91dD86IHN0cmluZykgPT4gdm9pZDtcbn1cblxuZXhwb3J0IGludGVyZmFjZSBEaWFsb2dQYXJhbXNcbiAgZXh0ZW5kcyBDb25maXJtYXRpb25EaWFsb2dQYXJhbXMsXG4gICAgUHJvbXB0RGlhbG9nUGFyYW1zIHtcbiAgY29uZmlybT86IChvdXQ/OiBzdHJpbmcpID0+IHZvaWQ7XG4gIGNvbmZpcm1hdGlvbj86IGJvb2xlYW47XG4gIHByb21wdD86IGJvb2xlYW47XG59XG5cbmV4cG9ydCBjb25zdCBsb2FkR2VuZXJpY0RpYWxvZyA9ICgpID0+XG4gIGltcG9ydCgvKiB3ZWJwYWNrQ2h1bmtOYW1lOiBcImNvbmZpcm1hdGlvblwiICovIFwiLi9kaWFsb2ctYm94XCIpO1xuXG5jb25zdCBzaG93RGlhbG9nSGVscGVyID0gKFxuICBlbGVtZW50OiBIVE1MRWxlbWVudCxcbiAgZGlhbG9nUGFyYW1zOiBEaWFsb2dQYXJhbXMsXG4gIGV4dHJhPzoge1xuICAgIGNvbmZpcm1hdGlvbj86IERpYWxvZ1BhcmFtc1tcImNvbmZpcm1hdGlvblwiXTtcbiAgICBwcm9tcHQ/OiBEaWFsb2dQYXJhbXNbXCJwcm9tcHRcIl07XG4gIH1cbikgPT5cbiAgbmV3IFByb21pc2UoKHJlc29sdmUpID0+IHtcbiAgICBjb25zdCBvcmlnQ2FuY2VsID0gZGlhbG9nUGFyYW1zLmNhbmNlbDtcbiAgICBjb25zdCBvcmlnQ29uZmlybSA9IGRpYWxvZ1BhcmFtcy5jb25maXJtO1xuXG4gICAgZmlyZUV2ZW50KGVsZW1lbnQsIFwic2hvdy1kaWFsb2dcIiwge1xuICAgICAgZGlhbG9nVGFnOiBcImRpYWxvZy1ib3hcIixcbiAgICAgIGRpYWxvZ0ltcG9ydDogbG9hZEdlbmVyaWNEaWFsb2csXG4gICAgICBkaWFsb2dQYXJhbXM6IHtcbiAgICAgICAgLi4uZGlhbG9nUGFyYW1zLFxuICAgICAgICAuLi5leHRyYSxcbiAgICAgICAgY2FuY2VsOiAoKSA9PiB7XG4gICAgICAgICAgcmVzb2x2ZShleHRyYT8ucHJvbXB0ID8gbnVsbCA6IGZhbHNlKTtcbiAgICAgICAgICBpZiAob3JpZ0NhbmNlbCkge1xuICAgICAgICAgICAgb3JpZ0NhbmNlbCgpO1xuICAgICAgICAgIH1cbiAgICAgICAgfSxcbiAgICAgICAgY29uZmlybTogKG91dCkgPT4ge1xuICAgICAgICAgIHJlc29sdmUoZXh0cmE/LnByb21wdCA/IG91dCA6IHRydWUpO1xuICAgICAgICAgIGlmIChvcmlnQ29uZmlybSkge1xuICAgICAgICAgICAgb3JpZ0NvbmZpcm0ob3V0KTtcbiAgICAgICAgICB9XG4gICAgICAgIH0sXG4gICAgICB9LFxuICAgIH0pO1xuICB9KTtcblxuZXhwb3J0IGNvbnN0IHNob3dBbGVydERpYWxvZyA9IChcbiAgZWxlbWVudDogSFRNTEVsZW1lbnQsXG4gIGRpYWxvZ1BhcmFtczogQWxlcnREaWFsb2dQYXJhbXNcbikgPT4gc2hvd0RpYWxvZ0hlbHBlcihlbGVtZW50LCBkaWFsb2dQYXJhbXMpO1xuXG5leHBvcnQgY29uc3Qgc2hvd0NvbmZpcm1hdGlvbkRpYWxvZyA9IChcbiAgZWxlbWVudDogSFRNTEVsZW1lbnQsXG4gIGRpYWxvZ1BhcmFtczogQ29uZmlybWF0aW9uRGlhbG9nUGFyYW1zXG4pID0+XG4gIHNob3dEaWFsb2dIZWxwZXIoZWxlbWVudCwgZGlhbG9nUGFyYW1zLCB7IGNvbmZpcm1hdGlvbjogdHJ1ZSB9KSBhcyBQcm9taXNlPFxuICAgIGJvb2xlYW5cbiAgPjtcblxuZXhwb3J0IGNvbnN0IHNob3dQcm9tcHREaWFsb2cgPSAoXG4gIGVsZW1lbnQ6IEhUTUxFbGVtZW50LFxuICBkaWFsb2dQYXJhbXM6IFByb21wdERpYWxvZ1BhcmFtc1xuKSA9PlxuICBzaG93RGlhbG9nSGVscGVyKGVsZW1lbnQsIGRpYWxvZ1BhcmFtcywgeyBwcm9tcHQ6IHRydWUgfSkgYXMgUHJvbWlzZTxcbiAgICBudWxsIHwgc3RyaW5nXG4gID47XG4iLCJpbXBvcnQgXCJAcG9seW1lci9hcHAtcm91dGUvYXBwLXJvdXRlXCI7XG5pbXBvcnQgeyBVbnN1YnNjcmliZUZ1bmMgfSBmcm9tIFwiaG9tZS1hc3Npc3RhbnQtanMtd2Vic29ja2V0XCI7XG5pbXBvcnQge1xuICBjc3MsXG4gIENTU1Jlc3VsdCxcbiAgY3VzdG9tRWxlbWVudCxcbiAgaHRtbCxcbiAgTGl0RWxlbWVudCxcbiAgcHJvcGVydHksXG4gIFByb3BlcnR5VmFsdWVzLFxuICBUZW1wbGF0ZVJlc3VsdCxcbn0gZnJvbSBcImxpdC1lbGVtZW50XCI7XG5pbXBvcnQgbWVtb2l6ZU9uZSBmcm9tIFwibWVtb2l6ZS1vbmVcIjtcbmltcG9ydCAqIGFzIEZ1c2UgZnJvbSBcImZ1c2UuanNcIjtcbmltcG9ydCB7IGNhc2VJbnNlbnNpdGl2ZUNvbXBhcmUgfSBmcm9tIFwiLi4vLi4vLi4vY29tbW9uL3N0cmluZy9jb21wYXJlXCI7XG5pbXBvcnQgeyBjb21wdXRlUlRMIH0gZnJvbSBcIi4uLy4uLy4uL2NvbW1vbi91dGlsL2NvbXB1dGVfcnRsXCI7XG5pbXBvcnQge1xuICBhZnRlck5leHRSZW5kZXIsXG4gIG5leHRSZW5kZXIsXG59IGZyb20gXCIuLi8uLi8uLi9jb21tb24vdXRpbC9yZW5kZXItc3RhdHVzXCI7XG5pbXBvcnQgXCIuLi8uLi8uLi9jb21wb25lbnRzL2VudGl0eS9oYS1zdGF0ZS1pY29uXCI7XG5pbXBvcnQgXCIuLi8uLi8uLi9jb21wb25lbnRzL2hhLWNhcmRcIjtcbmltcG9ydCBcIi4uLy4uLy4uL2NvbXBvbmVudHMvaGEtZmFiXCI7XG5pbXBvcnQge1xuICBDb25maWdFbnRyeSxcbiAgZGVsZXRlQ29uZmlnRW50cnksXG4gIGdldENvbmZpZ0VudHJpZXMsXG59IGZyb20gXCIuLi8uLi8uLi9kYXRhL2NvbmZpZ19lbnRyaWVzXCI7XG5pbXBvcnQge1xuICBESVNDT1ZFUllfU09VUkNFUyxcbiAgZ2V0Q29uZmlnRmxvd0luUHJvZ3Jlc3NDb2xsZWN0aW9uLFxuICBpZ25vcmVDb25maWdGbG93LFxuICBsb2NhbGl6ZUNvbmZpZ0Zsb3dUaXRsZSxcbiAgc3Vic2NyaWJlQ29uZmlnRmxvd0luUHJvZ3Jlc3MsXG59IGZyb20gXCIuLi8uLi8uLi9kYXRhL2NvbmZpZ19mbG93XCI7XG5pbXBvcnQgdHlwZSB7IERhdGFFbnRyeUZsb3dQcm9ncmVzcyB9IGZyb20gXCIuLi8uLi8uLi9kYXRhL2RhdGFfZW50cnlfZmxvd1wiO1xuaW1wb3J0IHtcbiAgRGV2aWNlUmVnaXN0cnlFbnRyeSxcbiAgc3Vic2NyaWJlRGV2aWNlUmVnaXN0cnksXG59IGZyb20gXCIuLi8uLi8uLi9kYXRhL2RldmljZV9yZWdpc3RyeVwiO1xuaW1wb3J0IHtcbiAgRW50aXR5UmVnaXN0cnlFbnRyeSxcbiAgc3Vic2NyaWJlRW50aXR5UmVnaXN0cnksXG59IGZyb20gXCIuLi8uLi8uLi9kYXRhL2VudGl0eV9yZWdpc3RyeVwiO1xuaW1wb3J0IHsgZG9tYWluVG9OYW1lIH0gZnJvbSBcIi4uLy4uLy4uL2RhdGEvaW50ZWdyYXRpb25cIjtcbmltcG9ydCB7IHNob3dDb25maWdGbG93RGlhbG9nIH0gZnJvbSBcIi4uLy4uLy4uL2RpYWxvZ3MvY29uZmlnLWZsb3cvc2hvdy1kaWFsb2ctY29uZmlnLWZsb3dcIjtcbmltcG9ydCB7IHNob3dDb25maXJtYXRpb25EaWFsb2cgfSBmcm9tIFwiLi4vLi4vLi4vZGlhbG9ncy9nZW5lcmljL3Nob3ctZGlhbG9nLWJveFwiO1xuaW1wb3J0IFwiLi4vLi4vLi4vbGF5b3V0cy9oYXNzLXRhYnMtc3VicGFnZVwiO1xuaW1wb3J0IHsgU3Vic2NyaWJlTWl4aW4gfSBmcm9tIFwiLi4vLi4vLi4vbWl4aW5zL3N1YnNjcmliZS1taXhpblwiO1xuaW1wb3J0IHsgaGFTdHlsZSB9IGZyb20gXCIuLi8uLi8uLi9yZXNvdXJjZXMvc3R5bGVzXCI7XG5pbXBvcnQgeyBIb21lQXNzaXN0YW50LCBSb3V0ZSB9IGZyb20gXCIuLi8uLi8uLi90eXBlc1wiO1xuaW1wb3J0IHsgY29uZmlnU2VjdGlvbnMgfSBmcm9tIFwiLi4vaGEtcGFuZWwtY29uZmlnXCI7XG5pbXBvcnQgXCIuLi8uLi8uLi9jb21tb24vc2VhcmNoL3NlYXJjaC1pbnB1dFwiO1xuaW1wb3J0IFwiLi9oYS1pbnRlZ3JhdGlvbi1jYXJkXCI7XG5pbXBvcnQgdHlwZSB7XG4gIENvbmZpZ0VudHJ5UmVtb3ZlZEV2ZW50LFxuICBDb25maWdFbnRyeVVwZGF0ZWRFdmVudCxcbiAgSGFJbnRlZ3JhdGlvbkNhcmQsXG59IGZyb20gXCIuL2hhLWludGVncmF0aW9uLWNhcmRcIjtcbmltcG9ydCB7IEhBU1NEb21FdmVudCB9IGZyb20gXCIuLi8uLi8uLi9jb21tb24vZG9tL2ZpcmVfZXZlbnRcIjtcblxuaW50ZXJmYWNlIERhdGFFbnRyeUZsb3dQcm9ncmVzc0V4dGVuZGVkIGV4dGVuZHMgRGF0YUVudHJ5Rmxvd1Byb2dyZXNzIHtcbiAgbG9jYWxpemVkX3RpdGxlPzogc3RyaW5nO1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIENvbmZpZ0VudHJ5RXh0ZW5kZWQgZXh0ZW5kcyBDb25maWdFbnRyeSB7XG4gIGxvY2FsaXplZF9kb21haW5fbmFtZT86IHN0cmluZztcbn1cblxuY29uc3QgZ3JvdXBCeUludGVncmF0aW9uID0gKFxuICBlbnRyaWVzOiBDb25maWdFbnRyeUV4dGVuZGVkW11cbik6IE1hcDxzdHJpbmcsIENvbmZpZ0VudHJ5RXh0ZW5kZWRbXT4gPT4ge1xuICBjb25zdCByZXN1bHQgPSBuZXcgTWFwKCk7XG4gIGVudHJpZXMuZm9yRWFjaCgoZW50cnkpID0+IHtcbiAgICBpZiAocmVzdWx0LmhhcyhlbnRyeS5kb21haW4pKSB7XG4gICAgICByZXN1bHQuZ2V0KGVudHJ5LmRvbWFpbikucHVzaChlbnRyeSk7XG4gICAgfSBlbHNlIHtcbiAgICAgIHJlc3VsdC5zZXQoZW50cnkuZG9tYWluLCBbZW50cnldKTtcbiAgICB9XG4gIH0pO1xuICByZXR1cm4gcmVzdWx0O1xufTtcblxuQGN1c3RvbUVsZW1lbnQoXCJoYS1jb25maWctaW50ZWdyYXRpb25zXCIpXG5jbGFzcyBIYUNvbmZpZ0ludGVncmF0aW9ucyBleHRlbmRzIFN1YnNjcmliZU1peGluKExpdEVsZW1lbnQpIHtcbiAgQHByb3BlcnR5KCkgcHVibGljIGhhc3MhOiBIb21lQXNzaXN0YW50O1xuXG4gIEBwcm9wZXJ0eSgpIHB1YmxpYyBuYXJyb3chOiBib29sZWFuO1xuXG4gIEBwcm9wZXJ0eSgpIHB1YmxpYyBpc1dpZGUhOiBib29sZWFuO1xuXG4gIEBwcm9wZXJ0eSgpIHB1YmxpYyBzaG93QWR2YW5jZWQhOiBib29sZWFuO1xuXG4gIEBwcm9wZXJ0eSgpIHB1YmxpYyByb3V0ZSE6IFJvdXRlO1xuXG4gIEBwcm9wZXJ0eSgpIHByaXZhdGUgX2NvbmZpZ0VudHJpZXM6IENvbmZpZ0VudHJ5RXh0ZW5kZWRbXSA9IFtdO1xuXG4gIEBwcm9wZXJ0eSgpXG4gIHByaXZhdGUgX2NvbmZpZ0VudHJpZXNJblByb2dyZXNzOiBEYXRhRW50cnlGbG93UHJvZ3Jlc3NFeHRlbmRlZFtdID0gW107XG5cbiAgQHByb3BlcnR5KCkgcHJpdmF0ZSBfZW50aXR5UmVnaXN0cnlFbnRyaWVzOiBFbnRpdHlSZWdpc3RyeUVudHJ5W10gPSBbXTtcblxuICBAcHJvcGVydHkoKSBwcml2YXRlIF9kZXZpY2VSZWdpc3RyeUVudHJpZXM6IERldmljZVJlZ2lzdHJ5RW50cnlbXSA9IFtdO1xuXG4gIEBwcm9wZXJ0eSgpIHByaXZhdGUgX3Nob3dJZ25vcmVkID0gZmFsc2U7XG5cbiAgQHByb3BlcnR5KCkgcHJpdmF0ZSBfc2VhcmNoUGFybXMgPSBuZXcgVVJMU2VhcmNoUGFyYW1zKFxuICAgIHdpbmRvdy5sb2NhdGlvbi5oYXNoLnN1YnN0cmluZygxKVxuICApO1xuXG4gIEBwcm9wZXJ0eSgpIHByaXZhdGUgX2ZpbHRlcj86IHN0cmluZztcblxuICBwdWJsaWMgaGFzc1N1YnNjcmliZSgpOiBVbnN1YnNjcmliZUZ1bmNbXSB7XG4gICAgcmV0dXJuIFtcbiAgICAgIHN1YnNjcmliZUVudGl0eVJlZ2lzdHJ5KHRoaXMuaGFzcy5jb25uZWN0aW9uLCAoZW50cmllcykgPT4ge1xuICAgICAgICB0aGlzLl9lbnRpdHlSZWdpc3RyeUVudHJpZXMgPSBlbnRyaWVzO1xuICAgICAgfSksXG4gICAgICBzdWJzY3JpYmVEZXZpY2VSZWdpc3RyeSh0aGlzLmhhc3MuY29ubmVjdGlvbiwgKGVudHJpZXMpID0+IHtcbiAgICAgICAgdGhpcy5fZGV2aWNlUmVnaXN0cnlFbnRyaWVzID0gZW50cmllcztcbiAgICAgIH0pLFxuICAgICAgc3Vic2NyaWJlQ29uZmlnRmxvd0luUHJvZ3Jlc3ModGhpcy5oYXNzLCBhc3luYyAoZmxvd3NJblByb2dyZXNzKSA9PiB7XG4gICAgICAgIGNvbnN0IHRyYW5zbGF0aW9uc1Byb21pc3NlczogUHJvbWlzZTx2b2lkPltdID0gW107XG4gICAgICAgIGZsb3dzSW5Qcm9ncmVzcy5mb3JFYWNoKChmbG93KSA9PiB7XG4gICAgICAgICAgLy8gVG8gcmVuZGVyIHRpdGxlIHBsYWNlaG9sZGVyc1xuICAgICAgICAgIGlmIChmbG93LmNvbnRleHQudGl0bGVfcGxhY2Vob2xkZXJzKSB7XG4gICAgICAgICAgICB0cmFuc2xhdGlvbnNQcm9taXNzZXMucHVzaChcbiAgICAgICAgICAgICAgdGhpcy5oYXNzLmxvYWRCYWNrZW5kVHJhbnNsYXRpb24oXCJjb25maWdcIiwgZmxvdy5oYW5kbGVyKVxuICAgICAgICAgICAgKTtcbiAgICAgICAgICB9XG4gICAgICAgIH0pO1xuICAgICAgICBhd2FpdCBQcm9taXNlLmFsbCh0cmFuc2xhdGlvbnNQcm9taXNzZXMpO1xuICAgICAgICBhd2FpdCBuZXh0UmVuZGVyKCk7XG4gICAgICAgIHRoaXMuX2NvbmZpZ0VudHJpZXNJblByb2dyZXNzID0gZmxvd3NJblByb2dyZXNzLm1hcCgoZmxvdykgPT4ge1xuICAgICAgICAgIHJldHVybiB7XG4gICAgICAgICAgICAuLi5mbG93LFxuICAgICAgICAgICAgbG9jYWxpemVkX3RpdGxlOiBsb2NhbGl6ZUNvbmZpZ0Zsb3dUaXRsZSh0aGlzLmhhc3MubG9jYWxpemUsIGZsb3cpLFxuICAgICAgICAgIH07XG4gICAgICAgIH0pO1xuICAgICAgfSksXG4gICAgXTtcbiAgfVxuXG4gIHByaXZhdGUgX2ZpbHRlckNvbmZpZ0VudHJpZXMgPSBtZW1vaXplT25lKFxuICAgIChcbiAgICAgIGNvbmZpZ0VudHJpZXM6IENvbmZpZ0VudHJ5RXh0ZW5kZWRbXSxcbiAgICAgIGZpbHRlcj86IHN0cmluZ1xuICAgICk6IENvbmZpZ0VudHJ5RXh0ZW5kZWRbXSA9PiB7XG4gICAgICBpZiAoIWZpbHRlcikge1xuICAgICAgICByZXR1cm4gY29uZmlnRW50cmllcztcbiAgICAgIH1cbiAgICAgIGNvbnN0IG9wdGlvbnM6IEZ1c2UuRnVzZU9wdGlvbnM8Q29uZmlnRW50cnlFeHRlbmRlZD4gPSB7XG4gICAgICAgIGtleXM6IFtcImRvbWFpblwiLCBcImxvY2FsaXplZF9kb21haW5fbmFtZVwiLCBcInRpdGxlXCJdLFxuICAgICAgICBjYXNlU2Vuc2l0aXZlOiBmYWxzZSxcbiAgICAgICAgbWluTWF0Y2hDaGFyTGVuZ3RoOiAyLFxuICAgICAgICB0aHJlc2hvbGQ6IDAuMixcbiAgICAgIH07XG4gICAgICBjb25zdCBmdXNlID0gbmV3IEZ1c2UoY29uZmlnRW50cmllcywgb3B0aW9ucyk7XG4gICAgICByZXR1cm4gZnVzZS5zZWFyY2goZmlsdGVyKTtcbiAgICB9XG4gICk7XG5cbiAgcHJpdmF0ZSBfZmlsdGVyR3JvdXBDb25maWdFbnRyaWVzID0gbWVtb2l6ZU9uZShcbiAgICAoXG4gICAgICBjb25maWdFbnRyaWVzOiBDb25maWdFbnRyeUV4dGVuZGVkW10sXG4gICAgICBmaWx0ZXI/OiBzdHJpbmdcbiAgICApOiBbTWFwPHN0cmluZywgQ29uZmlnRW50cnlFeHRlbmRlZFtdPiwgQ29uZmlnRW50cnlFeHRlbmRlZFtdXSA9PiB7XG4gICAgICBjb25zdCBmaWx0ZXJlZENvbmZpZ0VudGllcyA9IHRoaXMuX2ZpbHRlckNvbmZpZ0VudHJpZXMoXG4gICAgICAgIGNvbmZpZ0VudHJpZXMsXG4gICAgICAgIGZpbHRlclxuICAgICAgKTtcbiAgICAgIGNvbnN0IGlnbm9yZWQ6IENvbmZpZ0VudHJ5RXh0ZW5kZWRbXSA9IFtdO1xuICAgICAgZmlsdGVyZWRDb25maWdFbnRpZXMuZm9yRWFjaCgoaXRlbSwgaW5kZXgpID0+IHtcbiAgICAgICAgaWYgKGl0ZW0uc291cmNlID09PSBcImlnbm9yZVwiKSB7XG4gICAgICAgICAgaWdub3JlZC5wdXNoKGZpbHRlcmVkQ29uZmlnRW50aWVzLnNwbGljZShpbmRleCwgMSlbMF0pO1xuICAgICAgICB9XG4gICAgICB9KTtcbiAgICAgIHJldHVybiBbZ3JvdXBCeUludGVncmF0aW9uKGZpbHRlcmVkQ29uZmlnRW50aWVzKSwgaWdub3JlZF07XG4gICAgfVxuICApO1xuXG4gIHByaXZhdGUgX2ZpbHRlckNvbmZpZ0VudHJpZXNJblByb2dyZXNzID0gbWVtb2l6ZU9uZShcbiAgICAoXG4gICAgICBjb25maWdFbnRyaWVzSW5Qcm9ncmVzczogRGF0YUVudHJ5Rmxvd1Byb2dyZXNzRXh0ZW5kZWRbXSxcbiAgICAgIGZpbHRlcj86IHN0cmluZ1xuICAgICk6IERhdGFFbnRyeUZsb3dQcm9ncmVzc0V4dGVuZGVkW10gPT4ge1xuICAgICAgY29uZmlnRW50cmllc0luUHJvZ3Jlc3MgPSBjb25maWdFbnRyaWVzSW5Qcm9ncmVzcy5tYXAoXG4gICAgICAgIChmbG93OiBEYXRhRW50cnlGbG93UHJvZ3Jlc3NFeHRlbmRlZCkgPT4gKHtcbiAgICAgICAgICAuLi5mbG93LFxuICAgICAgICAgIHRpdGxlOiBsb2NhbGl6ZUNvbmZpZ0Zsb3dUaXRsZSh0aGlzLmhhc3MubG9jYWxpemUsIGZsb3cpLFxuICAgICAgICB9KVxuICAgICAgKTtcbiAgICAgIGlmICghZmlsdGVyKSB7XG4gICAgICAgIHJldHVybiBjb25maWdFbnRyaWVzSW5Qcm9ncmVzcztcbiAgICAgIH1cbiAgICAgIGNvbnN0IG9wdGlvbnM6IEZ1c2UuRnVzZU9wdGlvbnM8RGF0YUVudHJ5Rmxvd1Byb2dyZXNzRXh0ZW5kZWQ+ID0ge1xuICAgICAgICBrZXlzOiBbXCJoYW5kbGVyXCIsIFwibG9jYWxpemVkX3RpdGxlXCJdLFxuICAgICAgICBjYXNlU2Vuc2l0aXZlOiBmYWxzZSxcbiAgICAgICAgbWluTWF0Y2hDaGFyTGVuZ3RoOiAyLFxuICAgICAgICB0aHJlc2hvbGQ6IDAuMixcbiAgICAgIH07XG4gICAgICBjb25zdCBmdXNlID0gbmV3IEZ1c2UoY29uZmlnRW50cmllc0luUHJvZ3Jlc3MsIG9wdGlvbnMpO1xuICAgICAgcmV0dXJuIGZ1c2Uuc2VhcmNoKGZpbHRlcik7XG4gICAgfVxuICApO1xuXG4gIHByb3RlY3RlZCBmaXJzdFVwZGF0ZWQoY2hhbmdlZDogUHJvcGVydHlWYWx1ZXMpIHtcbiAgICBzdXBlci5maXJzdFVwZGF0ZWQoY2hhbmdlZCk7XG4gICAgdGhpcy5fbG9hZENvbmZpZ0VudHJpZXMoKTtcbiAgICB0aGlzLmhhc3MubG9hZEJhY2tlbmRUcmFuc2xhdGlvbihcInRpdGxlXCIsIHVuZGVmaW5lZCwgdHJ1ZSk7XG4gIH1cblxuICBwcm90ZWN0ZWQgdXBkYXRlZChjaGFuZ2VkOiBQcm9wZXJ0eVZhbHVlcykge1xuICAgIHN1cGVyLnVwZGF0ZWQoY2hhbmdlZCk7XG4gICAgaWYgKFxuICAgICAgdGhpcy5fc2VhcmNoUGFybXMuaGFzKFwiY29uZmlnX2VudHJ5XCIpICYmXG4gICAgICBjaGFuZ2VkLmhhcyhcIl9jb25maWdFbnRyaWVzXCIpICYmXG4gICAgICAhKGNoYW5nZWQuZ2V0KFwiX2NvbmZpZ0VudHJpZXNcIikgYXMgQ29uZmlnRW50cnlbXSkubGVuZ3RoICYmXG4gICAgICB0aGlzLl9jb25maWdFbnRyaWVzLmxlbmd0aFxuICAgICkge1xuICAgICAgYWZ0ZXJOZXh0UmVuZGVyKCgpID0+IHtcbiAgICAgICAgY29uc3QgZW50cnlJZCA9IHRoaXMuX3NlYXJjaFBhcm1zLmdldChcImNvbmZpZ19lbnRyeVwiKSE7XG4gICAgICAgIGNvbnN0IGNvbmZpZ0VudHJ5ID0gdGhpcy5fY29uZmlnRW50cmllcy5maW5kKFxuICAgICAgICAgIChlbnRyeSkgPT4gZW50cnkuZW50cnlfaWQgPT09IGVudHJ5SWRcbiAgICAgICAgKTtcbiAgICAgICAgaWYgKCFjb25maWdFbnRyeSkge1xuICAgICAgICAgIHJldHVybjtcbiAgICAgICAgfVxuICAgICAgICBjb25zdCBjYXJkOiBIYUludGVncmF0aW9uQ2FyZCA9IHRoaXMuc2hhZG93Um9vdCEucXVlcnlTZWxlY3RvcihcbiAgICAgICAgICBgW2RhdGEtZG9tYWluPSR7Y29uZmlnRW50cnk/LmRvbWFpbn1dYFxuICAgICAgICApIGFzIEhhSW50ZWdyYXRpb25DYXJkO1xuICAgICAgICBpZiAoY2FyZCkge1xuICAgICAgICAgIGNhcmQuc2Nyb2xsSW50b1ZpZXcoe1xuICAgICAgICAgICAgYmxvY2s6IFwiY2VudGVyXCIsXG4gICAgICAgICAgfSk7XG4gICAgICAgICAgY2FyZC5jbGFzc0xpc3QuYWRkKFwiaGlnaGxpZ2h0XCIpO1xuICAgICAgICAgIGNhcmQuc2VsZWN0ZWRDb25maWdFbnRyeUlkID0gZW50cnlJZDtcbiAgICAgICAgfVxuICAgICAgfSk7XG4gICAgfVxuICB9XG5cbiAgcHJvdGVjdGVkIHJlbmRlcigpOiBUZW1wbGF0ZVJlc3VsdCB7XG4gICAgY29uc3QgW1xuICAgICAgZ3JvdXBlZENvbmZpZ0VudHJpZXMsXG4gICAgICBpZ25vcmVkQ29uZmlnRW50cmllcyxcbiAgICBdID0gdGhpcy5fZmlsdGVyR3JvdXBDb25maWdFbnRyaWVzKHRoaXMuX2NvbmZpZ0VudHJpZXMsIHRoaXMuX2ZpbHRlcik7XG4gICAgY29uc3QgY29uZmlnRW50cmllc0luUHJvZ3Jlc3MgPSB0aGlzLl9maWx0ZXJDb25maWdFbnRyaWVzSW5Qcm9ncmVzcyhcbiAgICAgIHRoaXMuX2NvbmZpZ0VudHJpZXNJblByb2dyZXNzLFxuICAgICAgdGhpcy5fZmlsdGVyXG4gICAgKTtcblxuICAgIHJldHVybiBodG1sYFxuICAgICAgPGhhc3MtdGFicy1zdWJwYWdlXG4gICAgICAgIC5oYXNzPSR7dGhpcy5oYXNzfVxuICAgICAgICAubmFycm93PSR7dGhpcy5uYXJyb3d9XG4gICAgICAgIGJhY2stcGF0aD1cIi9jb25maWdcIlxuICAgICAgICAucm91dGU9JHt0aGlzLnJvdXRlfVxuICAgICAgICAudGFicz0ke2NvbmZpZ1NlY3Rpb25zLmludGVncmF0aW9uc31cbiAgICAgID5cbiAgICAgICAgJHt0aGlzLm5hcnJvd1xuICAgICAgICAgID8gaHRtbGBcbiAgICAgICAgICAgICAgPGRpdiBzbG90PVwiaGVhZGVyXCI+XG4gICAgICAgICAgICAgICAgPHNsb3QgbmFtZT1cImhlYWRlclwiPlxuICAgICAgICAgICAgICAgICAgPHNlYXJjaC1pbnB1dFxuICAgICAgICAgICAgICAgICAgICAuZmlsdGVyPSR7dGhpcy5fZmlsdGVyfVxuICAgICAgICAgICAgICAgICAgICBjbGFzcz1cImhlYWRlclwiXG4gICAgICAgICAgICAgICAgICAgIG5vLWxhYmVsLWZsb2F0XG4gICAgICAgICAgICAgICAgICAgIG5vLXVuZGVybGluZVxuICAgICAgICAgICAgICAgICAgICBAdmFsdWUtY2hhbmdlZD0ke3RoaXMuX2hhbmRsZVNlYXJjaENoYW5nZX1cbiAgICAgICAgICAgICAgICAgID48L3NlYXJjaC1pbnB1dD5cbiAgICAgICAgICAgICAgICA8L3Nsb3Q+XG4gICAgICAgICAgICAgIDwvZGl2PlxuICAgICAgICAgICAgYFxuICAgICAgICAgIDogXCJcIn1cbiAgICAgICAgPHBhcGVyLW1lbnUtYnV0dG9uXG4gICAgICAgICAgY2xvc2Utb24tYWN0aXZhdGVcbiAgICAgICAgICBuby1hbmltYXRpb25zXG4gICAgICAgICAgaG9yaXpvbnRhbC1hbGlnbj1cInJpZ2h0XCJcbiAgICAgICAgICBob3Jpem9udGFsLW9mZnNldD1cIi01XCJcbiAgICAgICAgICBzbG90PVwidG9vbGJhci1pY29uXCJcbiAgICAgICAgPlxuICAgICAgICAgIDxwYXBlci1pY29uLWJ1dHRvblxuICAgICAgICAgICAgaWNvbj1cImhhc3M6ZG90cy12ZXJ0aWNhbFwiXG4gICAgICAgICAgICBzbG90PVwiZHJvcGRvd24tdHJpZ2dlclwiXG4gICAgICAgICAgICBhbHQ9XCJtZW51XCJcbiAgICAgICAgICA+PC9wYXBlci1pY29uLWJ1dHRvbj5cbiAgICAgICAgICA8cGFwZXItbGlzdGJveCBzbG90PVwiZHJvcGRvd24tY29udGVudFwiIHJvbGU9XCJsaXN0Ym94XCI+XG4gICAgICAgICAgICA8cGFwZXItaXRlbSBAdGFwPSR7dGhpcy5fdG9nZ2xlU2hvd0lnbm9yZWR9PlxuICAgICAgICAgICAgICAke3RoaXMuaGFzcy5sb2NhbGl6ZShcbiAgICAgICAgICAgICAgICB0aGlzLl9zaG93SWdub3JlZFxuICAgICAgICAgICAgICAgICAgPyBcInVpLnBhbmVsLmNvbmZpZy5pbnRlZ3JhdGlvbnMuaWdub3JlLmhpZGVfaWdub3JlZFwiXG4gICAgICAgICAgICAgICAgICA6IFwidWkucGFuZWwuY29uZmlnLmludGVncmF0aW9ucy5pZ25vcmUuc2hvd19pZ25vcmVkXCJcbiAgICAgICAgICAgICAgKX1cbiAgICAgICAgICAgIDwvcGFwZXItaXRlbT5cbiAgICAgICAgICA8L3BhcGVyLWxpc3Rib3g+XG4gICAgICAgIDwvcGFwZXItbWVudS1idXR0b24+XG5cbiAgICAgICAgJHshdGhpcy5uYXJyb3dcbiAgICAgICAgICA/IGh0bWxgXG4gICAgICAgICAgICAgIDxkaXYgY2xhc3M9XCJzZWFyY2hcIj5cbiAgICAgICAgICAgICAgICA8c2VhcmNoLWlucHV0XG4gICAgICAgICAgICAgICAgICBuby1sYWJlbC1mbG9hdFxuICAgICAgICAgICAgICAgICAgbm8tdW5kZXJsaW5lXG4gICAgICAgICAgICAgICAgICAuZmlsdGVyPSR7dGhpcy5fZmlsdGVyfVxuICAgICAgICAgICAgICAgICAgQHZhbHVlLWNoYW5nZWQ9JHt0aGlzLl9oYW5kbGVTZWFyY2hDaGFuZ2V9XG4gICAgICAgICAgICAgICAgPjwvc2VhcmNoLWlucHV0PlxuICAgICAgICAgICAgICA8L2Rpdj5cbiAgICAgICAgICAgIGBcbiAgICAgICAgICA6IFwiXCJ9XG5cbiAgICAgICAgPGRpdlxuICAgICAgICAgIGNsYXNzPVwiY29udGFpbmVyXCJcbiAgICAgICAgICBAZW50cnktcmVtb3ZlZD0ke3RoaXMuX2hhbmRsZVJlbW92ZWR9XG4gICAgICAgICAgQGVudHJ5LXVwZGF0ZWQ9JHt0aGlzLl9oYW5kbGVVcGRhdGVkfVxuICAgICAgICA+XG4gICAgICAgICAgJHt0aGlzLl9zaG93SWdub3JlZFxuICAgICAgICAgICAgPyBpZ25vcmVkQ29uZmlnRW50cmllcy5tYXAoXG4gICAgICAgICAgICAgICAgKGl0ZW06IENvbmZpZ0VudHJ5RXh0ZW5kZWQpID0+IGh0bWxgXG4gICAgICAgICAgICAgICAgICA8aGEtY2FyZCBjbGFzcz1cImlnbm9yZWRcIj5cbiAgICAgICAgICAgICAgICAgICAgPGRpdiBjbGFzcz1cImhlYWRlclwiPlxuICAgICAgICAgICAgICAgICAgICAgICR7dGhpcy5oYXNzLmxvY2FsaXplKFxuICAgICAgICAgICAgICAgICAgICAgICAgXCJ1aS5wYW5lbC5jb25maWcuaW50ZWdyYXRpb25zLmlnbm9yZS5pZ25vcmVkXCJcbiAgICAgICAgICAgICAgICAgICAgICApfVxuICAgICAgICAgICAgICAgICAgICA8L2Rpdj5cbiAgICAgICAgICAgICAgICAgICAgPGRpdiBjbGFzcz1cImNhcmQtY29udGVudFwiPlxuICAgICAgICAgICAgICAgICAgICAgIDxkaXYgY2xhc3M9XCJpbWFnZVwiPlxuICAgICAgICAgICAgICAgICAgICAgICAgPGltZ1xuICAgICAgICAgICAgICAgICAgICAgICAgICBzcmM9XCJodHRwczovL2JyYW5kcy5ob21lLWFzc2lzdGFudC5pby8ke2l0ZW0uZG9tYWlufS9sb2dvLnBuZ1wiXG4gICAgICAgICAgICAgICAgICAgICAgICAgIHJlZmVycmVycG9saWN5PVwibm8tcmVmZXJyZXJcIlxuICAgICAgICAgICAgICAgICAgICAgICAgICBAZXJyb3I9JHt0aGlzLl9vbkltYWdlRXJyb3J9XG4gICAgICAgICAgICAgICAgICAgICAgICAgIEBsb2FkPSR7dGhpcy5fb25JbWFnZUxvYWR9XG4gICAgICAgICAgICAgICAgICAgICAgICAvPlxuICAgICAgICAgICAgICAgICAgICAgIDwvZGl2PlxuICAgICAgICAgICAgICAgICAgICAgIDxoMj5cbiAgICAgICAgICAgICAgICAgICAgICAgICR7aXRlbS5sb2NhbGl6ZWRfZG9tYWluX25hbWV9XG4gICAgICAgICAgICAgICAgICAgICAgPC9oMj5cbiAgICAgICAgICAgICAgICAgICAgICA8bXdjLWJ1dHRvblxuICAgICAgICAgICAgICAgICAgICAgICAgQGNsaWNrPSR7dGhpcy5fcmVtb3ZlSWdub3JlZEludGVncmF0aW9ufVxuICAgICAgICAgICAgICAgICAgICAgICAgLmVudHJ5PSR7aXRlbX1cbiAgICAgICAgICAgICAgICAgICAgICAgIGFyaWEtbGFiZWw9JHt0aGlzLmhhc3MubG9jYWxpemUoXG4gICAgICAgICAgICAgICAgICAgICAgICAgIFwidWkucGFuZWwuY29uZmlnLmludGVncmF0aW9ucy5pZ25vcmUuc3RvcF9pZ25vcmVcIlxuICAgICAgICAgICAgICAgICAgICAgICAgKX1cbiAgICAgICAgICAgICAgICAgICAgICAgID4ke3RoaXMuaGFzcy5sb2NhbGl6ZShcbiAgICAgICAgICAgICAgICAgICAgICAgICAgXCJ1aS5wYW5lbC5jb25maWcuaW50ZWdyYXRpb25zLmlnbm9yZS5zdG9wX2lnbm9yZVwiXG4gICAgICAgICAgICAgICAgICAgICAgICApfTwvbXdjLWJ1dHRvblxuICAgICAgICAgICAgICAgICAgICAgID5cbiAgICAgICAgICAgICAgICAgICAgPC9kaXY+XG4gICAgICAgICAgICAgICAgICA8L2hhLWNhcmQ+XG4gICAgICAgICAgICAgICAgYFxuICAgICAgICAgICAgICApXG4gICAgICAgICAgICA6IFwiXCJ9XG4gICAgICAgICAgJHtjb25maWdFbnRyaWVzSW5Qcm9ncmVzcy5sZW5ndGhcbiAgICAgICAgICAgID8gY29uZmlnRW50cmllc0luUHJvZ3Jlc3MubWFwKFxuICAgICAgICAgICAgICAgIChmbG93OiBEYXRhRW50cnlGbG93UHJvZ3Jlc3NFeHRlbmRlZCkgPT4gaHRtbGBcbiAgICAgICAgICAgICAgICAgIDxoYS1jYXJkIGNsYXNzPVwiZGlzY292ZXJlZFwiPlxuICAgICAgICAgICAgICAgICAgICA8ZGl2IGNsYXNzPVwiaGVhZGVyXCI+XG4gICAgICAgICAgICAgICAgICAgICAgJHt0aGlzLmhhc3MubG9jYWxpemUoXG4gICAgICAgICAgICAgICAgICAgICAgICBcInVpLnBhbmVsLmNvbmZpZy5pbnRlZ3JhdGlvbnMuZGlzY292ZXJlZFwiXG4gICAgICAgICAgICAgICAgICAgICAgKX1cbiAgICAgICAgICAgICAgICAgICAgPC9kaXY+XG4gICAgICAgICAgICAgICAgICAgIDxkaXYgY2xhc3M9XCJjYXJkLWNvbnRlbnRcIj5cbiAgICAgICAgICAgICAgICAgICAgICA8ZGl2IGNsYXNzPVwiaW1hZ2VcIj5cbiAgICAgICAgICAgICAgICAgICAgICAgIDxpbWdcbiAgICAgICAgICAgICAgICAgICAgICAgICAgc3JjPVwiaHR0cHM6Ly9icmFuZHMuaG9tZS1hc3Npc3RhbnQuaW8vJHtmbG93LmhhbmRsZXJ9L2xvZ28ucG5nXCJcbiAgICAgICAgICAgICAgICAgICAgICAgICAgcmVmZXJyZXJwb2xpY3k9XCJuby1yZWZlcnJlclwiXG4gICAgICAgICAgICAgICAgICAgICAgICAgIEBlcnJvcj0ke3RoaXMuX29uSW1hZ2VFcnJvcn1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgQGxvYWQ9JHt0aGlzLl9vbkltYWdlTG9hZH1cbiAgICAgICAgICAgICAgICAgICAgICAgIC8+XG4gICAgICAgICAgICAgICAgICAgICAgPC9kaXY+XG4gICAgICAgICAgICAgICAgICAgICAgPGgyPlxuICAgICAgICAgICAgICAgICAgICAgICAgJHtmbG93LmxvY2FsaXplZF90aXRsZX1cbiAgICAgICAgICAgICAgICAgICAgICA8L2gyPlxuICAgICAgICAgICAgICAgICAgICAgIDxkaXY+XG4gICAgICAgICAgICAgICAgICAgICAgICA8bXdjLWJ1dHRvblxuICAgICAgICAgICAgICAgICAgICAgICAgICB1bmVsZXZhdGVkXG4gICAgICAgICAgICAgICAgICAgICAgICAgIEBjbGljaz0ke3RoaXMuX2NvbnRpbnVlRmxvd31cbiAgICAgICAgICAgICAgICAgICAgICAgICAgLmZsb3dJZD0ke2Zsb3cuZmxvd19pZH1cbiAgICAgICAgICAgICAgICAgICAgICAgID5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgJHt0aGlzLmhhc3MubG9jYWxpemUoXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJ1aS5wYW5lbC5jb25maWcuaW50ZWdyYXRpb25zLmNvbmZpZ3VyZVwiXG4gICAgICAgICAgICAgICAgICAgICAgICAgICl9XG4gICAgICAgICAgICAgICAgICAgICAgICA8L213Yy1idXR0b24+XG4gICAgICAgICAgICAgICAgICAgICAgICAke0RJU0NPVkVSWV9TT1VSQ0VTLmluY2x1ZGVzKGZsb3cuY29udGV4dC5zb3VyY2UpICYmXG4gICAgICAgICAgICAgICAgICAgICAgICBmbG93LmNvbnRleHQudW5pcXVlX2lkXG4gICAgICAgICAgICAgICAgICAgICAgICAgID8gaHRtbGBcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIDxtd2MtYnV0dG9uXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIEBjbGljaz0ke3RoaXMuX2lnbm9yZUZsb3d9XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIC5mbG93PSR7Zmxvd31cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgID5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgJHt0aGlzLmhhc3MubG9jYWxpemUoXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJ1aS5wYW5lbC5jb25maWcuaW50ZWdyYXRpb25zLmlnbm9yZS5pZ25vcmVcIlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICApfVxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgPC9td2MtYnV0dG9uPlxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGBcbiAgICAgICAgICAgICAgICAgICAgICAgICAgOiBcIlwifVxuICAgICAgICAgICAgICAgICAgICAgIDwvZGl2PlxuICAgICAgICAgICAgICAgICAgICA8L2Rpdj5cbiAgICAgICAgICAgICAgICAgIDwvaGEtY2FyZD5cbiAgICAgICAgICAgICAgICBgXG4gICAgICAgICAgICAgIClcbiAgICAgICAgICAgIDogXCJcIn1cbiAgICAgICAgICAke2dyb3VwZWRDb25maWdFbnRyaWVzLnNpemVcbiAgICAgICAgICAgID8gQXJyYXkuZnJvbShncm91cGVkQ29uZmlnRW50cmllcy5lbnRyaWVzKCkpLm1hcChcbiAgICAgICAgICAgICAgICAoW2RvbWFpbiwgaXRlbXNdKSA9PlxuICAgICAgICAgICAgICAgICAgaHRtbGA8aGEtaW50ZWdyYXRpb24tY2FyZFxuICAgICAgICAgICAgICAgICAgICBkYXRhLWRvbWFpbj0ke2RvbWFpbn1cbiAgICAgICAgICAgICAgICAgICAgLmhhc3M9JHt0aGlzLmhhc3N9XG4gICAgICAgICAgICAgICAgICAgIC5kb21haW49JHtkb21haW59XG4gICAgICAgICAgICAgICAgICAgIC5pdGVtcz0ke2l0ZW1zfVxuICAgICAgICAgICAgICAgICAgICAuZW50aXR5UmVnaXN0cnlFbnRyaWVzPSR7dGhpcy5fZW50aXR5UmVnaXN0cnlFbnRyaWVzfVxuICAgICAgICAgICAgICAgICAgICAuZGV2aWNlUmVnaXN0cnlFbnRyaWVzPSR7dGhpcy5fZGV2aWNlUmVnaXN0cnlFbnRyaWVzfVxuICAgICAgICAgICAgICAgICAgPjwvaGEtaW50ZWdyYXRpb24tY2FyZD5gXG4gICAgICAgICAgICAgIClcbiAgICAgICAgICAgIDogIXRoaXMuX2NvbmZpZ0VudHJpZXMubGVuZ3RoXG4gICAgICAgICAgICA/IGh0bWxgXG4gICAgICAgICAgICAgICAgPGhhLWNhcmQ+XG4gICAgICAgICAgICAgICAgICA8ZGl2IGNsYXNzPVwiY2FyZC1jb250ZW50XCI+XG4gICAgICAgICAgICAgICAgICAgIDxoMT5cbiAgICAgICAgICAgICAgICAgICAgICAke3RoaXMuaGFzcy5sb2NhbGl6ZShcInVpLnBhbmVsLmNvbmZpZy5pbnRlZ3JhdGlvbnMubm9uZVwiKX1cbiAgICAgICAgICAgICAgICAgICAgPC9oMT5cbiAgICAgICAgICAgICAgICAgICAgPHA+XG4gICAgICAgICAgICAgICAgICAgICAgJHt0aGlzLmhhc3MubG9jYWxpemUoXG4gICAgICAgICAgICAgICAgICAgICAgICBcInVpLnBhbmVsLmNvbmZpZy5pbnRlZ3JhdGlvbnMubm9faW50ZWdyYXRpb25zXCJcbiAgICAgICAgICAgICAgICAgICAgICApfVxuICAgICAgICAgICAgICAgICAgICA8L3A+XG4gICAgICAgICAgICAgICAgICAgIDxtd2MtYnV0dG9uIEBjbGljaz0ke3RoaXMuX2NyZWF0ZUZsb3d9IHVuZWxldmF0ZWRcbiAgICAgICAgICAgICAgICAgICAgICA+JHt0aGlzLmhhc3MubG9jYWxpemUoXG4gICAgICAgICAgICAgICAgICAgICAgICBcInVpLnBhbmVsLmNvbmZpZy5pbnRlZ3JhdGlvbnMuYWRkXCJcbiAgICAgICAgICAgICAgICAgICAgICApfTwvbXdjLWJ1dHRvblxuICAgICAgICAgICAgICAgICAgICA+XG4gICAgICAgICAgICAgICAgICA8L2Rpdj5cbiAgICAgICAgICAgICAgICA8L2hhLWNhcmQ+XG4gICAgICAgICAgICAgIGBcbiAgICAgICAgICAgIDogXCJcIn1cbiAgICAgICAgICAke3RoaXMuX2ZpbHRlciAmJlxuICAgICAgICAgICFjb25maWdFbnRyaWVzSW5Qcm9ncmVzcy5sZW5ndGggJiZcbiAgICAgICAgICAhZ3JvdXBlZENvbmZpZ0VudHJpZXMuc2l6ZSAmJlxuICAgICAgICAgIHRoaXMuX2NvbmZpZ0VudHJpZXMubGVuZ3RoXG4gICAgICAgICAgICA/IGh0bWxgXG4gICAgICAgICAgICAgICAgPGRpdiBjbGFzcz1cIm5vbmUtZm91bmRcIj5cbiAgICAgICAgICAgICAgICAgIDxoMT5cbiAgICAgICAgICAgICAgICAgICAgJHt0aGlzLmhhc3MubG9jYWxpemUoXG4gICAgICAgICAgICAgICAgICAgICAgXCJ1aS5wYW5lbC5jb25maWcuaW50ZWdyYXRpb25zLm5vbmVfZm91bmRcIlxuICAgICAgICAgICAgICAgICAgICApfVxuICAgICAgICAgICAgICAgICAgPC9oMT5cbiAgICAgICAgICAgICAgICAgIDxwPlxuICAgICAgICAgICAgICAgICAgICAke3RoaXMuaGFzcy5sb2NhbGl6ZShcbiAgICAgICAgICAgICAgICAgICAgICBcInVpLnBhbmVsLmNvbmZpZy5pbnRlZ3JhdGlvbnMubm9uZV9mb3VuZF9kZXRhaWxcIlxuICAgICAgICAgICAgICAgICAgICApfVxuICAgICAgICAgICAgICAgICAgPC9wPlxuICAgICAgICAgICAgICAgIDwvZGl2PlxuICAgICAgICAgICAgICBgXG4gICAgICAgICAgICA6IFwiXCJ9XG4gICAgICAgIDwvZGl2PlxuICAgICAgICA8aGEtZmFiXG4gICAgICAgICAgaWNvbj1cImhhc3M6cGx1c1wiXG4gICAgICAgICAgYXJpYS1sYWJlbD0ke3RoaXMuaGFzcy5sb2NhbGl6ZShcInVpLnBhbmVsLmNvbmZpZy5pbnRlZ3JhdGlvbnMubmV3XCIpfVxuICAgICAgICAgIHRpdGxlPSR7dGhpcy5oYXNzLmxvY2FsaXplKFwidWkucGFuZWwuY29uZmlnLmludGVncmF0aW9ucy5uZXdcIil9XG4gICAgICAgICAgQGNsaWNrPSR7dGhpcy5fY3JlYXRlRmxvd31cbiAgICAgICAgICA/aXMtd2lkZT0ke3RoaXMuaXNXaWRlfVxuICAgICAgICAgID9uYXJyb3c9JHt0aGlzLm5hcnJvd31cbiAgICAgICAgICA/cnRsPSR7Y29tcHV0ZVJUTCh0aGlzLmhhc3MhKX1cbiAgICAgICAgPjwvaGEtZmFiPlxuICAgICAgPC9oYXNzLXRhYnMtc3VicGFnZT5cbiAgICBgO1xuICB9XG5cbiAgcHJpdmF0ZSBfbG9hZENvbmZpZ0VudHJpZXMoKSB7XG4gICAgZ2V0Q29uZmlnRW50cmllcyh0aGlzLmhhc3MpLnRoZW4oKGNvbmZpZ0VudHJpZXMpID0+IHtcbiAgICAgIHRoaXMuX2NvbmZpZ0VudHJpZXMgPSBjb25maWdFbnRyaWVzXG4gICAgICAgIC5tYXAoXG4gICAgICAgICAgKGVudHJ5OiBDb25maWdFbnRyeSk6IENvbmZpZ0VudHJ5RXh0ZW5kZWQgPT4gKHtcbiAgICAgICAgICAgIC4uLmVudHJ5LFxuICAgICAgICAgICAgbG9jYWxpemVkX2RvbWFpbl9uYW1lOiBkb21haW5Ub05hbWUoXG4gICAgICAgICAgICAgIHRoaXMuaGFzcy5sb2NhbGl6ZSxcbiAgICAgICAgICAgICAgZW50cnkuZG9tYWluXG4gICAgICAgICAgICApLFxuICAgICAgICAgIH0pXG4gICAgICAgIClcbiAgICAgICAgLnNvcnQoKGNvbmYxLCBjb25mMikgPT5cbiAgICAgICAgICBjYXNlSW5zZW5zaXRpdmVDb21wYXJlKFxuICAgICAgICAgICAgY29uZjEubG9jYWxpemVkX2RvbWFpbl9uYW1lICsgY29uZjEudGl0bGUsXG4gICAgICAgICAgICBjb25mMi5sb2NhbGl6ZWRfZG9tYWluX25hbWUgKyBjb25mMi50aXRsZVxuICAgICAgICAgIClcbiAgICAgICAgKTtcbiAgICB9KTtcbiAgfVxuXG4gIHByaXZhdGUgX2hhbmRsZVJlbW92ZWQoZXY6IEhBU1NEb21FdmVudDxDb25maWdFbnRyeVJlbW92ZWRFdmVudD4pIHtcbiAgICB0aGlzLl9jb25maWdFbnRyaWVzID0gdGhpcy5fY29uZmlnRW50cmllcy5maWx0ZXIoXG4gICAgICAoZW50cnkpID0+IGVudHJ5LmVudHJ5X2lkICE9PSBldi5kZXRhaWwuZW50cnlJZFxuICAgICk7XG4gIH1cblxuICBwcml2YXRlIF9oYW5kbGVVcGRhdGVkKGV2OiBIQVNTRG9tRXZlbnQ8Q29uZmlnRW50cnlVcGRhdGVkRXZlbnQ+KSB7XG4gICAgY29uc3QgbmV3RW50cnkgPSBldi5kZXRhaWwuZW50cnk7XG4gICAgdGhpcy5fY29uZmlnRW50cmllcyA9IHRoaXMuX2NvbmZpZ0VudHJpZXMhLm1hcCgoZW50cnkpID0+XG4gICAgICBlbnRyeS5lbnRyeV9pZCA9PT0gbmV3RW50cnkuZW50cnlfaWRcbiAgICAgICAgPyB7IC4uLm5ld0VudHJ5LCBsb2NhbGl6ZWRfZG9tYWluX25hbWU6IGVudHJ5LmxvY2FsaXplZF9kb21haW5fbmFtZSB9XG4gICAgICAgIDogZW50cnlcbiAgICApO1xuICB9XG5cbiAgcHJpdmF0ZSBfY3JlYXRlRmxvdygpIHtcbiAgICBzaG93Q29uZmlnRmxvd0RpYWxvZyh0aGlzLCB7XG4gICAgICBkaWFsb2dDbG9zZWRDYWxsYmFjazogKCkgPT4ge1xuICAgICAgICB0aGlzLl9sb2FkQ29uZmlnRW50cmllcygpO1xuICAgICAgICBnZXRDb25maWdGbG93SW5Qcm9ncmVzc0NvbGxlY3Rpb24odGhpcy5oYXNzLmNvbm5lY3Rpb24pLnJlZnJlc2goKTtcbiAgICAgIH0sXG4gICAgICBzaG93QWR2YW5jZWQ6IHRoaXMuc2hvd0FkdmFuY2VkLFxuICAgIH0pO1xuICAgIC8vIEZvciBjb25maWcgZW50cmllcy4gQWxzbyBsb2FkaW5nIGNvbmZpZyBmbG93IG9uZXMgZm9yIGFkZCBpbnRlZ3JhdGlvblxuICAgIHRoaXMuaGFzcy5sb2FkQmFja2VuZFRyYW5zbGF0aW9uKFwidGl0bGVcIiwgdW5kZWZpbmVkLCB0cnVlKTtcbiAgfVxuXG4gIHByaXZhdGUgX2NvbnRpbnVlRmxvdyhldjogRXZlbnQpIHtcbiAgICBzaG93Q29uZmlnRmxvd0RpYWxvZyh0aGlzLCB7XG4gICAgICBjb250aW51ZUZsb3dJZDogKGV2LnRhcmdldCEgYXMgYW55KS5mbG93SWQsXG4gICAgICBkaWFsb2dDbG9zZWRDYWxsYmFjazogKCkgPT4ge1xuICAgICAgICB0aGlzLl9sb2FkQ29uZmlnRW50cmllcygpO1xuICAgICAgICBnZXRDb25maWdGbG93SW5Qcm9ncmVzc0NvbGxlY3Rpb24odGhpcy5oYXNzLmNvbm5lY3Rpb24pLnJlZnJlc2goKTtcbiAgICAgIH0sXG4gICAgfSk7XG4gIH1cblxuICBwcml2YXRlIGFzeW5jIF9pZ25vcmVGbG93KGV2OiBFdmVudCkge1xuICAgIGNvbnN0IGZsb3cgPSAoZXYudGFyZ2V0ISBhcyBhbnkpLmZsb3c7XG4gICAgY29uc3QgY29uZmlybWVkID0gYXdhaXQgc2hvd0NvbmZpcm1hdGlvbkRpYWxvZyh0aGlzLCB7XG4gICAgICB0aXRsZTogdGhpcy5oYXNzIS5sb2NhbGl6ZShcbiAgICAgICAgXCJ1aS5wYW5lbC5jb25maWcuaW50ZWdyYXRpb25zLmlnbm9yZS5jb25maXJtX2lnbm9yZV90aXRsZVwiLFxuICAgICAgICBcIm5hbWVcIixcbiAgICAgICAgbG9jYWxpemVDb25maWdGbG93VGl0bGUodGhpcy5oYXNzLmxvY2FsaXplLCBmbG93KVxuICAgICAgKSxcbiAgICAgIHRleHQ6IHRoaXMuaGFzcyEubG9jYWxpemUoXG4gICAgICAgIFwidWkucGFuZWwuY29uZmlnLmludGVncmF0aW9ucy5pZ25vcmUuY29uZmlybV9pZ25vcmVcIlxuICAgICAgKSxcbiAgICAgIGNvbmZpcm1UZXh0OiB0aGlzLmhhc3MhLmxvY2FsaXplKFxuICAgICAgICBcInVpLnBhbmVsLmNvbmZpZy5pbnRlZ3JhdGlvbnMuaWdub3JlLmlnbm9yZVwiXG4gICAgICApLFxuICAgIH0pO1xuICAgIGlmICghY29uZmlybWVkKSB7XG4gICAgICByZXR1cm47XG4gICAgfVxuICAgIGF3YWl0IGlnbm9yZUNvbmZpZ0Zsb3codGhpcy5oYXNzLCBmbG93LmZsb3dfaWQpO1xuICAgIHRoaXMuX2xvYWRDb25maWdFbnRyaWVzKCk7XG4gICAgZ2V0Q29uZmlnRmxvd0luUHJvZ3Jlc3NDb2xsZWN0aW9uKHRoaXMuaGFzcy5jb25uZWN0aW9uKS5yZWZyZXNoKCk7XG4gIH1cblxuICBwcml2YXRlIF90b2dnbGVTaG93SWdub3JlZCgpIHtcbiAgICB0aGlzLl9zaG93SWdub3JlZCA9ICF0aGlzLl9zaG93SWdub3JlZDtcbiAgfVxuXG4gIHByaXZhdGUgYXN5bmMgX3JlbW92ZUlnbm9yZWRJbnRlZ3JhdGlvbihldjogRXZlbnQpIHtcbiAgICBjb25zdCBlbnRyeSA9IChldi50YXJnZXQhIGFzIGFueSkuZW50cnk7XG4gICAgc2hvd0NvbmZpcm1hdGlvbkRpYWxvZyh0aGlzLCB7XG4gICAgICB0aXRsZTogdGhpcy5oYXNzIS5sb2NhbGl6ZShcbiAgICAgICAgXCJ1aS5wYW5lbC5jb25maWcuaW50ZWdyYXRpb25zLmlnbm9yZS5jb25maXJtX2RlbGV0ZV9pZ25vcmVfdGl0bGVcIixcbiAgICAgICAgXCJuYW1lXCIsXG4gICAgICAgIHRoaXMuaGFzcy5sb2NhbGl6ZShgY29tcG9uZW50LiR7ZW50cnkuZG9tYWlufS50aXRsZWApXG4gICAgICApLFxuICAgICAgdGV4dDogdGhpcy5oYXNzIS5sb2NhbGl6ZShcbiAgICAgICAgXCJ1aS5wYW5lbC5jb25maWcuaW50ZWdyYXRpb25zLmlnbm9yZS5jb25maXJtX2RlbGV0ZV9pZ25vcmVcIlxuICAgICAgKSxcbiAgICAgIGNvbmZpcm1UZXh0OiB0aGlzLmhhc3MhLmxvY2FsaXplKFxuICAgICAgICBcInVpLnBhbmVsLmNvbmZpZy5pbnRlZ3JhdGlvbnMuaWdub3JlLnN0b3BfaWdub3JlXCJcbiAgICAgICksXG4gICAgICBjb25maXJtOiBhc3luYyAoKSA9PiB7XG4gICAgICAgIGNvbnN0IHJlc3VsdCA9IGF3YWl0IGRlbGV0ZUNvbmZpZ0VudHJ5KHRoaXMuaGFzcywgZW50cnkuZW50cnlfaWQpO1xuICAgICAgICBpZiAocmVzdWx0LnJlcXVpcmVfcmVzdGFydCkge1xuICAgICAgICAgIGFsZXJ0KFxuICAgICAgICAgICAgdGhpcy5oYXNzLmxvY2FsaXplKFxuICAgICAgICAgICAgICBcInVpLnBhbmVsLmNvbmZpZy5pbnRlZ3JhdGlvbnMuY29uZmlnX2VudHJ5LnJlc3RhcnRfY29uZmlybVwiXG4gICAgICAgICAgICApXG4gICAgICAgICAgKTtcbiAgICAgICAgfVxuICAgICAgICB0aGlzLl9sb2FkQ29uZmlnRW50cmllcygpO1xuICAgICAgfSxcbiAgICB9KTtcbiAgfVxuXG4gIHByaXZhdGUgX2hhbmRsZVNlYXJjaENoYW5nZShldjogQ3VzdG9tRXZlbnQpIHtcbiAgICB0aGlzLl9maWx0ZXIgPSBldi5kZXRhaWwudmFsdWU7XG4gIH1cblxuICBwcml2YXRlIF9vbkltYWdlTG9hZChldikge1xuICAgIGV2LnRhcmdldC5zdHlsZS52aXNpYmlsaXR5ID0gXCJpbml0aWFsXCI7XG4gIH1cblxuICBwcml2YXRlIF9vbkltYWdlRXJyb3IoZXYpIHtcbiAgICBldi50YXJnZXQuc3R5bGUudmlzaWJpbGl0eSA9IFwiaGlkZGVuXCI7XG4gIH1cblxuICBzdGF0aWMgZ2V0IHN0eWxlcygpOiBDU1NSZXN1bHRbXSB7XG4gICAgcmV0dXJuIFtcbiAgICAgIGhhU3R5bGUsXG4gICAgICBjc3NgXG4gICAgICAgIC5jb250YWluZXIge1xuICAgICAgICAgIGRpc3BsYXk6IGdyaWQ7XG4gICAgICAgICAgZ3JpZC10ZW1wbGF0ZS1jb2x1bW5zOiByZXBlYXQoYXV0by1maXQsIG1pbm1heCgyNTBweCwgMWZyKSk7XG4gICAgICAgICAgZ3JpZC1nYXA6IDE2cHggMTZweDtcbiAgICAgICAgICBwYWRkaW5nOiA4cHggMTZweCAxNnB4O1xuICAgICAgICAgIG1hcmdpbi1ib3R0b206IDY0cHg7XG4gICAgICAgIH1cbiAgICAgICAgaGEtY2FyZCB7XG4gICAgICAgICAgbWF4LXdpZHRoOiA1MDBweDtcbiAgICAgICAgICBkaXNwbGF5OiBmbGV4O1xuICAgICAgICAgIGZsZXgtZGlyZWN0aW9uOiBjb2x1bW47XG4gICAgICAgICAganVzdGlmeS1jb250ZW50OiBzcGFjZS1iZXR3ZWVuO1xuICAgICAgICB9XG4gICAgICAgIC5kaXNjb3ZlcmVkIHtcbiAgICAgICAgICBib3JkZXI6IDFweCBzb2xpZCB2YXIoLS1wcmltYXJ5LWNvbG9yKTtcbiAgICAgICAgfVxuICAgICAgICAuZGlzY292ZXJlZCAuaGVhZGVyIHtcbiAgICAgICAgICBiYWNrZ3JvdW5kOiB2YXIoLS1wcmltYXJ5LWNvbG9yKTtcbiAgICAgICAgICBjb2xvcjogdmFyKC0tdGV4dC1wcmltYXJ5LWNvbG9yKTtcbiAgICAgICAgICBwYWRkaW5nOiA4cHg7XG4gICAgICAgICAgdGV4dC1hbGlnbjogY2VudGVyO1xuICAgICAgICB9XG4gICAgICAgIC5pZ25vcmVkIHtcbiAgICAgICAgICBib3JkZXI6IDFweCBzb2xpZCB2YXIoLS1saWdodC10aGVtZS1kaXNhYmxlZC1jb2xvcik7XG4gICAgICAgIH1cbiAgICAgICAgLmlnbm9yZWQgLmhlYWRlciB7XG4gICAgICAgICAgYmFja2dyb3VuZDogdmFyKC0tbGlnaHQtdGhlbWUtZGlzYWJsZWQtY29sb3IpO1xuICAgICAgICAgIGNvbG9yOiB2YXIoLS10ZXh0LXByaW1hcnktY29sb3IpO1xuICAgICAgICAgIHBhZGRpbmc6IDhweDtcbiAgICAgICAgICB0ZXh0LWFsaWduOiBjZW50ZXI7XG4gICAgICAgIH1cbiAgICAgICAgLmNhcmQtY29udGVudCB7XG4gICAgICAgICAgZGlzcGxheTogZmxleDtcbiAgICAgICAgICBoZWlnaHQ6IDEwMCU7XG4gICAgICAgICAgbWFyZ2luLXRvcDogMDtcbiAgICAgICAgICBwYWRkaW5nOiAxNnB4O1xuICAgICAgICAgIHRleHQtYWxpZ246IGNlbnRlcjtcbiAgICAgICAgICBmbGV4LWRpcmVjdGlvbjogY29sdW1uO1xuICAgICAgICAgIGp1c3RpZnktY29udGVudDogc3BhY2UtYmV0d2VlbjtcbiAgICAgICAgfVxuICAgICAgICAuaW1hZ2Uge1xuICAgICAgICAgIGRpc3BsYXk6IGZsZXg7XG4gICAgICAgICAgYWxpZ24taXRlbXM6IGNlbnRlcjtcbiAgICAgICAgICBqdXN0aWZ5LWNvbnRlbnQ6IGNlbnRlcjtcbiAgICAgICAgICBoZWlnaHQ6IDYwcHg7XG4gICAgICAgICAgbWFyZ2luLWJvdHRvbTogMTZweDtcbiAgICAgICAgICB2ZXJ0aWNhbC1hbGlnbjogbWlkZGxlO1xuICAgICAgICB9XG4gICAgICAgIC5ub25lLWZvdW5kIHtcbiAgICAgICAgICBtYXJnaW46IGF1dG87XG4gICAgICAgICAgdGV4dC1hbGlnbjogY2VudGVyO1xuICAgICAgICB9XG4gICAgICAgIHNlYXJjaC1pbnB1dC5oZWFkZXIge1xuICAgICAgICAgIGRpc3BsYXk6IGJsb2NrO1xuICAgICAgICAgIHBvc2l0aW9uOiByZWxhdGl2ZTtcbiAgICAgICAgICBsZWZ0OiAtOHB4O1xuICAgICAgICAgIHRvcDogLTdweDtcbiAgICAgICAgICBjb2xvcjogdmFyKC0tc2Vjb25kYXJ5LXRleHQtY29sb3IpO1xuICAgICAgICAgIG1hcmdpbi1sZWZ0OiAxNnB4O1xuICAgICAgICB9XG4gICAgICAgIC5zZWFyY2gge1xuICAgICAgICAgIHBhZGRpbmc6IDAgMTZweDtcbiAgICAgICAgICBiYWNrZ3JvdW5kOiB2YXIoLS1zaWRlYmFyLWJhY2tncm91bmQtY29sb3IpO1xuICAgICAgICAgIGJvcmRlci1ib3R0b206IDFweCBzb2xpZCB2YXIoLS1kaXZpZGVyLWNvbG9yKTtcbiAgICAgICAgfVxuICAgICAgICAuc2VhcmNoIHNlYXJjaC1pbnB1dCB7XG4gICAgICAgICAgcG9zaXRpb246IHJlbGF0aXZlO1xuICAgICAgICAgIHRvcDogMnB4O1xuICAgICAgICB9XG4gICAgICAgIGltZyB7XG4gICAgICAgICAgbWF4LWhlaWdodDogMTAwJTtcbiAgICAgICAgICBtYXgtd2lkdGg6IDkwJTtcbiAgICAgICAgfVxuICAgICAgICAubm9uZS1mb3VuZCB7XG4gICAgICAgICAgbWFyZ2luOiBhdXRvO1xuICAgICAgICAgIHRleHQtYWxpZ246IGNlbnRlcjtcbiAgICAgICAgfVxuICAgICAgICBoMSB7XG4gICAgICAgICAgbWFyZ2luLWJvdHRvbTogMDtcbiAgICAgICAgfVxuICAgICAgICBoMiB7XG4gICAgICAgICAgbWFyZ2luLXRvcDogMDtcbiAgICAgICAgfVxuICAgICAgICBoYS1mYWIge1xuICAgICAgICAgIHBvc2l0aW9uOiBmaXhlZDtcbiAgICAgICAgICBib3R0b206IDE2cHg7XG4gICAgICAgICAgcmlnaHQ6IDE2cHg7XG4gICAgICAgICAgei1pbmRleDogMTtcbiAgICAgICAgfVxuICAgICAgICBoYS1mYWJbaXMtd2lkZV0ge1xuICAgICAgICAgIGJvdHRvbTogMjRweDtcbiAgICAgICAgICByaWdodDogMjRweDtcbiAgICAgICAgfVxuICAgICAgICBoYS1mYWJbbmFycm93XSB7XG4gICAgICAgICAgYm90dG9tOiA4NHB4O1xuICAgICAgICB9XG4gICAgICAgIGhhLWZhYltydGxdIHtcbiAgICAgICAgICByaWdodDogYXV0bztcbiAgICAgICAgICBsZWZ0OiAxNnB4O1xuICAgICAgICB9XG4gICAgICAgIGhhLWZhYltpcy13aWRlXS5ydGwge1xuICAgICAgICAgIGJvdHRvbTogMjRweDtcbiAgICAgICAgICBsZWZ0OiAyNHB4O1xuICAgICAgICAgIHJpZ2h0OiBhdXRvO1xuICAgICAgICB9XG4gICAgICBgLFxuICAgIF07XG4gIH1cbn1cblxuZGVjbGFyZSBnbG9iYWwge1xuICBpbnRlcmZhY2UgSFRNTEVsZW1lbnRUYWdOYW1lTWFwIHtcbiAgICBcImhhLWNvbmZpZy1pbnRlZ3JhdGlvbnNcIjogSGFDb25maWdJbnRlZ3JhdGlvbnM7XG4gIH1cbn1cbiIsImltcG9ydCB7XG4gIGN1c3RvbUVsZW1lbnQsXG4gIExpdEVsZW1lbnQsXG4gIHByb3BlcnR5LFxuICBodG1sLFxuICBDU1NSZXN1bHQsXG4gIGNzcyxcbiAgVGVtcGxhdGVSZXN1bHQsXG59IGZyb20gXCJsaXQtZWxlbWVudFwiO1xuaW1wb3J0IHsgSG9tZUFzc2lzdGFudCB9IGZyb20gXCIuLi8uLi8uLi90eXBlc1wiO1xuaW1wb3J0IHsgQ29uZmlnRW50cnlFeHRlbmRlZCB9IGZyb20gXCIuL2hhLWNvbmZpZy1pbnRlZ3JhdGlvbnNcIjtcbmltcG9ydCB7IGRvbWFpblRvTmFtZSB9IGZyb20gXCIuLi8uLi8uLi9kYXRhL2ludGVncmF0aW9uXCI7XG5pbXBvcnQge1xuICBDb25maWdFbnRyeSxcbiAgdXBkYXRlQ29uZmlnRW50cnksXG4gIGRlbGV0ZUNvbmZpZ0VudHJ5LFxufSBmcm9tIFwiLi4vLi4vLi4vZGF0YS9jb25maWdfZW50cmllc1wiO1xuaW1wb3J0IHsgRW50aXR5UmVnaXN0cnlFbnRyeSB9IGZyb20gXCIuLi8uLi8uLi9kYXRhL2VudGl0eV9yZWdpc3RyeVwiO1xuaW1wb3J0IHsgRGV2aWNlUmVnaXN0cnlFbnRyeSB9IGZyb20gXCIuLi8uLi8uLi9kYXRhL2RldmljZV9yZWdpc3RyeVwiO1xuaW1wb3J0IHsgc2hvd09wdGlvbnNGbG93RGlhbG9nIH0gZnJvbSBcIi4uLy4uLy4uL2RpYWxvZ3MvY29uZmlnLWZsb3cvc2hvdy1kaWFsb2ctb3B0aW9ucy1mbG93XCI7XG5pbXBvcnQgeyBzaG93Q29uZmlnRW50cnlTeXN0ZW1PcHRpb25zRGlhbG9nIH0gZnJvbSBcIi4uLy4uLy4uL2RpYWxvZ3MvY29uZmlnLWVudHJ5LXN5c3RlbS1vcHRpb25zL3Nob3ctZGlhbG9nLWNvbmZpZy1lbnRyeS1zeXN0ZW0tb3B0aW9uc1wiO1xuaW1wb3J0IHtcbiAgc2hvd1Byb21wdERpYWxvZyxcbiAgc2hvd0NvbmZpcm1hdGlvbkRpYWxvZyxcbiAgc2hvd0FsZXJ0RGlhbG9nLFxufSBmcm9tIFwiLi4vLi4vLi4vZGlhbG9ncy9nZW5lcmljL3Nob3ctZGlhbG9nLWJveFwiO1xuaW1wb3J0IHsgaGFTdHlsZSB9IGZyb20gXCIuLi8uLi8uLi9yZXNvdXJjZXMvc3R5bGVzXCI7XG5pbXBvcnQgXCIuLi8uLi8uLi9jb21wb25lbnRzL2hhLWljb24tbmV4dFwiO1xuaW1wb3J0IHsgZmlyZUV2ZW50IH0gZnJvbSBcIi4uLy4uLy4uL2NvbW1vbi9kb20vZmlyZV9ldmVudFwiO1xuXG5leHBvcnQgaW50ZXJmYWNlIENvbmZpZ0VudHJ5VXBkYXRlZEV2ZW50IHtcbiAgZW50cnk6IENvbmZpZ0VudHJ5O1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIENvbmZpZ0VudHJ5UmVtb3ZlZEV2ZW50IHtcbiAgZW50cnlJZDogc3RyaW5nO1xufVxuXG5kZWNsYXJlIGdsb2JhbCB7XG4gIC8vIGZvciBmaXJlIGV2ZW50XG4gIGludGVyZmFjZSBIQVNTRG9tRXZlbnRzIHtcbiAgICBcImVudHJ5LXVwZGF0ZWRcIjogQ29uZmlnRW50cnlVcGRhdGVkRXZlbnQ7XG4gICAgXCJlbnRyeS1yZW1vdmVkXCI6IENvbmZpZ0VudHJ5UmVtb3ZlZEV2ZW50O1xuICB9XG59XG5cbkBjdXN0b21FbGVtZW50KFwiaGEtaW50ZWdyYXRpb24tY2FyZFwiKVxuZXhwb3J0IGNsYXNzIEhhSW50ZWdyYXRpb25DYXJkIGV4dGVuZHMgTGl0RWxlbWVudCB7XG4gIEBwcm9wZXJ0eSgpIHB1YmxpYyBoYXNzITogSG9tZUFzc2lzdGFudDtcblxuICBAcHJvcGVydHkoKSBwdWJsaWMgZG9tYWluITogc3RyaW5nO1xuXG4gIEBwcm9wZXJ0eSgpIHB1YmxpYyBpdGVtcyE6IENvbmZpZ0VudHJ5RXh0ZW5kZWRbXTtcblxuICBAcHJvcGVydHkoKSBwdWJsaWMgZW50aXR5UmVnaXN0cnlFbnRyaWVzITogRW50aXR5UmVnaXN0cnlFbnRyeVtdO1xuXG4gIEBwcm9wZXJ0eSgpIHB1YmxpYyBkZXZpY2VSZWdpc3RyeUVudHJpZXMhOiBEZXZpY2VSZWdpc3RyeUVudHJ5W107XG5cbiAgQHByb3BlcnR5KCkgcHVibGljIHNlbGVjdGVkQ29uZmlnRW50cnlJZD86IHN0cmluZztcblxuICBwcm90ZWN0ZWQgcmVuZGVyKCk6IFRlbXBsYXRlUmVzdWx0IHtcbiAgICBpZiAodGhpcy5pdGVtcy5sZW5ndGggPT09IDEpIHtcbiAgICAgIHJldHVybiB0aGlzLl9yZW5kZXJTaW5nbGVFbnRyeSh0aGlzLml0ZW1zWzBdKTtcbiAgICB9XG4gICAgaWYgKHRoaXMuc2VsZWN0ZWRDb25maWdFbnRyeUlkKSB7XG4gICAgICBjb25zdCBjb25maWdFbnRyeSA9IHRoaXMuaXRlbXMuZmluZChcbiAgICAgICAgKGVudHJ5KSA9PiBlbnRyeS5lbnRyeV9pZCA9PT0gdGhpcy5zZWxlY3RlZENvbmZpZ0VudHJ5SWRcbiAgICAgICk7XG4gICAgICBpZiAoY29uZmlnRW50cnkpIHtcbiAgICAgICAgcmV0dXJuIHRoaXMuX3JlbmRlclNpbmdsZUVudHJ5KGNvbmZpZ0VudHJ5KTtcbiAgICAgIH1cbiAgICB9XG4gICAgcmV0dXJuIHRoaXMuX3JlbmRlckdyb3VwZWRJbnRlZ3JhdGlvbigpO1xuICB9XG5cbiAgcHJpdmF0ZSBfcmVuZGVyR3JvdXBlZEludGVncmF0aW9uKCk6IFRlbXBsYXRlUmVzdWx0IHtcbiAgICByZXR1cm4gaHRtbGBcbiAgICAgIDxoYS1jYXJkIGNsYXNzPVwiZ3JvdXBcIj5cbiAgICAgICAgPGRpdiBjbGFzcz1cImdyb3VwLWhlYWRlclwiPlxuICAgICAgICAgIDxpbWdcbiAgICAgICAgICAgIHNyYz1cImh0dHBzOi8vYnJhbmRzLmhvbWUtYXNzaXN0YW50LmlvLyR7dGhpcy5kb21haW59L2ljb24ucG5nXCJcbiAgICAgICAgICAgIHJlZmVycmVycG9saWN5PVwibm8tcmVmZXJyZXJcIlxuICAgICAgICAgICAgQGVycm9yPSR7dGhpcy5fb25JbWFnZUVycm9yfVxuICAgICAgICAgICAgQGxvYWQ9JHt0aGlzLl9vbkltYWdlTG9hZH1cbiAgICAgICAgICAvPlxuICAgICAgICAgIDxoMT5cbiAgICAgICAgICAgICR7ZG9tYWluVG9OYW1lKHRoaXMuaGFzcy5sb2NhbGl6ZSwgdGhpcy5kb21haW4pfVxuICAgICAgICAgIDwvaDE+XG4gICAgICAgIDwvZGl2PlxuICAgICAgICA8cGFwZXItbGlzdGJveD5cbiAgICAgICAgICAke3RoaXMuaXRlbXMubWFwKFxuICAgICAgICAgICAgKGl0ZW0pID0+XG4gICAgICAgICAgICAgIGh0bWxgPHBhcGVyLWl0ZW1cbiAgICAgICAgICAgICAgICAuZW50cnlJZD0ke2l0ZW0uZW50cnlfaWR9XG4gICAgICAgICAgICAgICAgQGNsaWNrPSR7dGhpcy5fc2VsZWN0Q29uZmlnRW50cnl9XG4gICAgICAgICAgICAgICAgPjxwYXBlci1pdGVtLWJvZHk+JHtpdGVtLnRpdGxlfTwvcGFwZXItaXRlbS1ib2R5XG4gICAgICAgICAgICAgICAgPjxoYS1pY29uLW5leHQ+PC9oYS1pY29uLW5leHRcbiAgICAgICAgICAgICAgPjwvcGFwZXItaXRlbT5gXG4gICAgICAgICAgKX1cbiAgICAgICAgPC9wYXBlci1saXN0Ym94PlxuICAgICAgPC9oYS1jYXJkPlxuICAgIGA7XG4gIH1cblxuICBwcml2YXRlIF9yZW5kZXJTaW5nbGVFbnRyeShpdGVtOiBDb25maWdFbnRyeUV4dGVuZGVkKTogVGVtcGxhdGVSZXN1bHQge1xuICAgIGNvbnN0IGRldmljZXMgPSB0aGlzLl9nZXREZXZpY2VzKGl0ZW0pO1xuICAgIGNvbnN0IGVudGl0aWVzID0gdGhpcy5fZ2V0RW50aXRpZXMoaXRlbSk7XG4gICAgcmV0dXJuIGh0bWxgXG4gICAgICA8aGEtY2FyZFxuICAgICAgICBjbGFzcz1cInNpbmdsZSBpbnRlZ3JhdGlvblwiXG4gICAgICAgIC5jb25maWdFbnRyeT0ke2l0ZW19XG4gICAgICAgIC5pZD0ke2l0ZW0uZW50cnlfaWR9XG4gICAgICA+XG4gICAgICAgICR7dGhpcy5pdGVtcy5sZW5ndGggPiAxXG4gICAgICAgICAgPyBodG1sYDxwYXBlci1pY29uLWJ1dHRvblxuICAgICAgICAgICAgICBjbGFzcz1cImJhY2stYnRuXCJcbiAgICAgICAgICAgICAgaWNvbj1cImhhc3M6Y2hldnJvbi1sZWZ0XCJcbiAgICAgICAgICAgICAgQGNsaWNrPSR7dGhpcy5fYmFja31cbiAgICAgICAgICAgID48L3BhcGVyLWljb24tYnV0dG9uPmBcbiAgICAgICAgICA6IFwiXCJ9XG4gICAgICAgIDxkaXYgY2xhc3M9XCJjYXJkLWNvbnRlbnRcIj5cbiAgICAgICAgICA8ZGl2IGNsYXNzPVwiaW1hZ2VcIj5cbiAgICAgICAgICAgIDxpbWdcbiAgICAgICAgICAgICAgc3JjPVwiaHR0cHM6Ly9icmFuZHMuaG9tZS1hc3Npc3RhbnQuaW8vJHtpdGVtLmRvbWFpbn0vbG9nby5wbmdcIlxuICAgICAgICAgICAgICByZWZlcnJlcnBvbGljeT1cIm5vLXJlZmVycmVyXCJcbiAgICAgICAgICAgICAgQGVycm9yPSR7dGhpcy5fb25JbWFnZUVycm9yfVxuICAgICAgICAgICAgICBAbG9hZD0ke3RoaXMuX29uSW1hZ2VMb2FkfVxuICAgICAgICAgICAgLz5cbiAgICAgICAgICA8L2Rpdj5cbiAgICAgICAgICA8aDE+XG4gICAgICAgICAgICAke2l0ZW0ubG9jYWxpemVkX2RvbWFpbl9uYW1lfVxuICAgICAgICAgIDwvaDE+XG4gICAgICAgICAgPGgyPlxuICAgICAgICAgICAgJHtpdGVtLmxvY2FsaXplZF9kb21haW5fbmFtZSA9PT0gaXRlbS50aXRsZSA/IFwiXCIgOiBpdGVtLnRpdGxlfVxuICAgICAgICAgIDwvaDI+XG4gICAgICAgICAgJHtkZXZpY2VzLmxlbmd0aCB8fCBlbnRpdGllcy5sZW5ndGhcbiAgICAgICAgICAgID8gaHRtbGBcbiAgICAgICAgICAgICAgICA8ZGl2PlxuICAgICAgICAgICAgICAgICAgJHtkZXZpY2VzLmxlbmd0aFxuICAgICAgICAgICAgICAgICAgICA/IGh0bWxgXG4gICAgICAgICAgICAgICAgICAgICAgICA8YVxuICAgICAgICAgICAgICAgICAgICAgICAgICBocmVmPSR7YC9jb25maWcvZGV2aWNlcy9kYXNoYm9hcmQ/aGlzdG9yeUJhY2s9MSZjb25maWdfZW50cnk9JHtpdGVtLmVudHJ5X2lkfWB9XG4gICAgICAgICAgICAgICAgICAgICAgICAgID4ke3RoaXMuaGFzcy5sb2NhbGl6ZShcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBcInVpLnBhbmVsLmNvbmZpZy5pbnRlZ3JhdGlvbnMuY29uZmlnX2VudHJ5LmRldmljZXNcIixcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBcImNvdW50XCIsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgZGV2aWNlcy5sZW5ndGhcbiAgICAgICAgICAgICAgICAgICAgICAgICAgKX08L2FcbiAgICAgICAgICAgICAgICAgICAgICAgID5cbiAgICAgICAgICAgICAgICAgICAgICBgXG4gICAgICAgICAgICAgICAgICAgIDogXCJcIn1cbiAgICAgICAgICAgICAgICAgICR7ZGV2aWNlcy5sZW5ndGggJiYgZW50aXRpZXMubGVuZ3RoID8gXCJhbmRcIiA6IFwiXCJ9XG4gICAgICAgICAgICAgICAgICAke2VudGl0aWVzLmxlbmd0aFxuICAgICAgICAgICAgICAgICAgICA/IGh0bWxgXG4gICAgICAgICAgICAgICAgICAgICAgICA8YVxuICAgICAgICAgICAgICAgICAgICAgICAgICBocmVmPSR7YC9jb25maWcvZW50aXRpZXM/aGlzdG9yeUJhY2s9MSZjb25maWdfZW50cnk9JHtpdGVtLmVudHJ5X2lkfWB9XG4gICAgICAgICAgICAgICAgICAgICAgICAgID4ke3RoaXMuaGFzcy5sb2NhbGl6ZShcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBcInVpLnBhbmVsLmNvbmZpZy5pbnRlZ3JhdGlvbnMuY29uZmlnX2VudHJ5LmVudGl0aWVzXCIsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgXCJjb3VudFwiLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgIGVudGl0aWVzLmxlbmd0aFxuICAgICAgICAgICAgICAgICAgICAgICAgICApfTwvYVxuICAgICAgICAgICAgICAgICAgICAgICAgPlxuICAgICAgICAgICAgICAgICAgICAgIGBcbiAgICAgICAgICAgICAgICAgICAgOiBcIlwifVxuICAgICAgICAgICAgICAgIDwvZGl2PlxuICAgICAgICAgICAgICBgXG4gICAgICAgICAgICA6IFwiXCJ9XG4gICAgICAgIDwvZGl2PlxuICAgICAgICA8ZGl2IGNsYXNzPVwiY2FyZC1hY3Rpb25zXCI+XG4gICAgICAgICAgPGRpdj5cbiAgICAgICAgICAgIDxtd2MtYnV0dG9uIEBjbGljaz0ke3RoaXMuX2VkaXRFbnRyeU5hbWV9XG4gICAgICAgICAgICAgID4ke3RoaXMuaGFzcy5sb2NhbGl6ZShcbiAgICAgICAgICAgICAgICBcInVpLnBhbmVsLmNvbmZpZy5pbnRlZ3JhdGlvbnMuY29uZmlnX2VudHJ5LnJlbmFtZVwiXG4gICAgICAgICAgICAgICl9PC9td2MtYnV0dG9uXG4gICAgICAgICAgICA+XG4gICAgICAgICAgICAke2l0ZW0uc3VwcG9ydHNfb3B0aW9uc1xuICAgICAgICAgICAgICA/IGh0bWxgXG4gICAgICAgICAgICAgICAgICA8bXdjLWJ1dHRvbiBAY2xpY2s9JHt0aGlzLl9zaG93T3B0aW9uc31cbiAgICAgICAgICAgICAgICAgICAgPiR7dGhpcy5oYXNzLmxvY2FsaXplKFxuICAgICAgICAgICAgICAgICAgICAgIFwidWkucGFuZWwuY29uZmlnLmludGVncmF0aW9ucy5jb25maWdfZW50cnkub3B0aW9uc1wiXG4gICAgICAgICAgICAgICAgICAgICl9PC9td2MtYnV0dG9uXG4gICAgICAgICAgICAgICAgICA+XG4gICAgICAgICAgICAgICAgYFxuICAgICAgICAgICAgICA6IFwiXCJ9XG4gICAgICAgICAgPC9kaXY+XG4gICAgICAgICAgPHBhcGVyLW1lbnUtYnV0dG9uXG4gICAgICAgICAgICBob3Jpem9udGFsLWFsaWduPVwicmlnaHRcIlxuICAgICAgICAgICAgdmVydGljYWwtYWxpZ249XCJ0b3BcIlxuICAgICAgICAgICAgdmVydGljYWwtb2Zmc2V0PVwiNDBcIlxuICAgICAgICAgICAgY2xvc2Utb24tYWN0aXZhdGVcbiAgICAgICAgICA+XG4gICAgICAgICAgICA8cGFwZXItaWNvbi1idXR0b25cbiAgICAgICAgICAgICAgaWNvbj1cImhhc3M6ZG90cy12ZXJ0aWNhbFwiXG4gICAgICAgICAgICAgIHNsb3Q9XCJkcm9wZG93bi10cmlnZ2VyXCJcbiAgICAgICAgICAgICAgYXJpYS1sYWJlbD0ke3RoaXMuaGFzcyEubG9jYWxpemUoXG4gICAgICAgICAgICAgICAgXCJ1aS5wYW5lbC5sb3ZlbGFjZS5lZGl0b3IuZWRpdF9jYXJkLm9wdGlvbnNcIlxuICAgICAgICAgICAgICApfVxuICAgICAgICAgICAgPjwvcGFwZXItaWNvbi1idXR0b24+XG4gICAgICAgICAgICA8cGFwZXItbGlzdGJveCBzbG90PVwiZHJvcGRvd24tY29udGVudFwiPlxuICAgICAgICAgICAgICA8cGFwZXItaXRlbSBAdGFwPSR7dGhpcy5fc2hvd1N5c3RlbU9wdGlvbnN9PlxuICAgICAgICAgICAgICAgICR7dGhpcy5oYXNzLmxvY2FsaXplKFxuICAgICAgICAgICAgICAgICAgXCJ1aS5wYW5lbC5jb25maWcuaW50ZWdyYXRpb25zLmNvbmZpZ19lbnRyeS5zeXN0ZW1fb3B0aW9uc1wiXG4gICAgICAgICAgICAgICAgKX08L3BhcGVyLWl0ZW1cbiAgICAgICAgICAgICAgPlxuICAgICAgICAgICAgICA8cGFwZXItaXRlbSBjbGFzcz1cIndhcm5pbmdcIiBAdGFwPSR7dGhpcy5fcmVtb3ZlSW50ZWdyYXRpb259PlxuICAgICAgICAgICAgICAgICR7dGhpcy5oYXNzLmxvY2FsaXplKFxuICAgICAgICAgICAgICAgICAgXCJ1aS5wYW5lbC5jb25maWcuaW50ZWdyYXRpb25zLmNvbmZpZ19lbnRyeS5kZWxldGVcIlxuICAgICAgICAgICAgICAgICl9PC9wYXBlci1pdGVtXG4gICAgICAgICAgICAgID5cbiAgICAgICAgICAgIDwvcGFwZXItbGlzdGJveD5cbiAgICAgICAgICA8L3BhcGVyLW1lbnUtYnV0dG9uPlxuICAgICAgICA8L2Rpdj5cbiAgICAgIDwvaGEtY2FyZD5cbiAgICBgO1xuICB9XG5cbiAgcHJpdmF0ZSBfc2VsZWN0Q29uZmlnRW50cnkoZXY6IEV2ZW50KSB7XG4gICAgdGhpcy5zZWxlY3RlZENvbmZpZ0VudHJ5SWQgPSAoZXYuY3VycmVudFRhcmdldCBhcyBhbnkpLmVudHJ5SWQ7XG4gIH1cblxuICBwcml2YXRlIF9iYWNrKCkge1xuICAgIHRoaXMuc2VsZWN0ZWRDb25maWdFbnRyeUlkID0gdW5kZWZpbmVkO1xuICAgIHRoaXMuY2xhc3NMaXN0LnJlbW92ZShcImhpZ2hsaWdodFwiKTtcbiAgfVxuXG4gIHByaXZhdGUgX2dldEVudGl0aWVzKGNvbmZpZ0VudHJ5OiBDb25maWdFbnRyeSk6IEVudGl0eVJlZ2lzdHJ5RW50cnlbXSB7XG4gICAgaWYgKCF0aGlzLmVudGl0eVJlZ2lzdHJ5RW50cmllcykge1xuICAgICAgcmV0dXJuIFtdO1xuICAgIH1cbiAgICByZXR1cm4gdGhpcy5lbnRpdHlSZWdpc3RyeUVudHJpZXMuZmlsdGVyKFxuICAgICAgKGVudGl0eSkgPT4gZW50aXR5LmNvbmZpZ19lbnRyeV9pZCA9PT0gY29uZmlnRW50cnkuZW50cnlfaWRcbiAgICApO1xuICB9XG5cbiAgcHJpdmF0ZSBfZ2V0RGV2aWNlcyhjb25maWdFbnRyeTogQ29uZmlnRW50cnkpOiBEZXZpY2VSZWdpc3RyeUVudHJ5W10ge1xuICAgIGlmICghdGhpcy5kZXZpY2VSZWdpc3RyeUVudHJpZXMpIHtcbiAgICAgIHJldHVybiBbXTtcbiAgICB9XG4gICAgcmV0dXJuIHRoaXMuZGV2aWNlUmVnaXN0cnlFbnRyaWVzLmZpbHRlcigoZGV2aWNlKSA9PlxuICAgICAgZGV2aWNlLmNvbmZpZ19lbnRyaWVzLmluY2x1ZGVzKGNvbmZpZ0VudHJ5LmVudHJ5X2lkKVxuICAgICk7XG4gIH1cblxuICBwcml2YXRlIF9vbkltYWdlTG9hZChldikge1xuICAgIGV2LnRhcmdldC5zdHlsZS52aXNpYmlsaXR5ID0gXCJpbml0aWFsXCI7XG4gIH1cblxuICBwcml2YXRlIF9vbkltYWdlRXJyb3IoZXYpIHtcbiAgICBldi50YXJnZXQuc3R5bGUudmlzaWJpbGl0eSA9IFwiaGlkZGVuXCI7XG4gIH1cblxuICBwcml2YXRlIF9zaG93T3B0aW9ucyhldikge1xuICAgIHNob3dPcHRpb25zRmxvd0RpYWxvZyh0aGlzLCBldi50YXJnZXQuY2xvc2VzdChcImhhLWNhcmRcIikuY29uZmlnRW50cnkpO1xuICB9XG5cbiAgcHJpdmF0ZSBfc2hvd1N5c3RlbU9wdGlvbnMoZXYpIHtcbiAgICBzaG93Q29uZmlnRW50cnlTeXN0ZW1PcHRpb25zRGlhbG9nKHRoaXMsIHtcbiAgICAgIGVudHJ5OiBldi50YXJnZXQuY2xvc2VzdChcImhhLWNhcmRcIikuY29uZmlnRW50cnksXG4gICAgfSk7XG4gIH1cblxuICBwcml2YXRlIGFzeW5jIF9lZGl0RW50cnlOYW1lKGV2KSB7XG4gICAgY29uc3QgY29uZmlnRW50cnkgPSBldi50YXJnZXQuY2xvc2VzdChcImhhLWNhcmRcIikuY29uZmlnRW50cnk7XG4gICAgY29uc3QgbmV3TmFtZSA9IGF3YWl0IHNob3dQcm9tcHREaWFsb2codGhpcywge1xuICAgICAgdGl0bGU6IHRoaXMuaGFzcy5sb2NhbGl6ZShcInVpLnBhbmVsLmNvbmZpZy5pbnRlZ3JhdGlvbnMucmVuYW1lX2RpYWxvZ1wiKSxcbiAgICAgIGRlZmF1bHRWYWx1ZTogY29uZmlnRW50cnkudGl0bGUsXG4gICAgICBpbnB1dExhYmVsOiB0aGlzLmhhc3MubG9jYWxpemUoXG4gICAgICAgIFwidWkucGFuZWwuY29uZmlnLmludGVncmF0aW9ucy5yZW5hbWVfaW5wdXRfbGFiZWxcIlxuICAgICAgKSxcbiAgICB9KTtcbiAgICBpZiAobmV3TmFtZSA9PT0gbnVsbCkge1xuICAgICAgcmV0dXJuO1xuICAgIH1cbiAgICBjb25zdCBuZXdFbnRyeSA9IGF3YWl0IHVwZGF0ZUNvbmZpZ0VudHJ5KHRoaXMuaGFzcywgY29uZmlnRW50cnkuZW50cnlfaWQsIHtcbiAgICAgIHRpdGxlOiBuZXdOYW1lLFxuICAgIH0pO1xuICAgIGZpcmVFdmVudCh0aGlzLCBcImVudHJ5LXVwZGF0ZWRcIiwgeyBlbnRyeTogbmV3RW50cnkgfSk7XG4gIH1cblxuICBwcml2YXRlIGFzeW5jIF9yZW1vdmVJbnRlZ3JhdGlvbihldikge1xuICAgIGNvbnN0IGVudHJ5SWQgPSBldi50YXJnZXQuY2xvc2VzdChcImhhLWNhcmRcIikuY29uZmlnRW50cnkuZW50cnlfaWQ7XG5cbiAgICBjb25zdCBjb25maXJtZWQgPSBhd2FpdCBzaG93Q29uZmlybWF0aW9uRGlhbG9nKHRoaXMsIHtcbiAgICAgIHRleHQ6IHRoaXMuaGFzcy5sb2NhbGl6ZShcbiAgICAgICAgXCJ1aS5wYW5lbC5jb25maWcuaW50ZWdyYXRpb25zLmNvbmZpZ19lbnRyeS5kZWxldGVfY29uZmlybVwiXG4gICAgICApLFxuICAgIH0pO1xuXG4gICAgaWYgKCFjb25maXJtZWQpIHtcbiAgICAgIHJldHVybjtcbiAgICB9XG4gICAgZGVsZXRlQ29uZmlnRW50cnkodGhpcy5oYXNzLCBlbnRyeUlkKS50aGVuKChyZXN1bHQpID0+IHtcbiAgICAgIGZpcmVFdmVudCh0aGlzLCBcImVudHJ5LXJlbW92ZWRcIiwgeyBlbnRyeUlkIH0pO1xuXG4gICAgICBpZiAocmVzdWx0LnJlcXVpcmVfcmVzdGFydCkge1xuICAgICAgICBzaG93QWxlcnREaWFsb2codGhpcywge1xuICAgICAgICAgIHRleHQ6IHRoaXMuaGFzcy5sb2NhbGl6ZShcbiAgICAgICAgICAgIFwidWkucGFuZWwuY29uZmlnLmludGVncmF0aW9ucy5jb25maWdfZW50cnkucmVzdGFydF9jb25maXJtXCJcbiAgICAgICAgICApLFxuICAgICAgICB9KTtcbiAgICAgIH1cbiAgICB9KTtcbiAgfVxuXG4gIHN0YXRpYyBnZXQgc3R5bGVzKCk6IENTU1Jlc3VsdFtdIHtcbiAgICByZXR1cm4gW1xuICAgICAgaGFTdHlsZSxcbiAgICAgIGNzc2BcbiAgICAgICAgOmhvc3Qge1xuICAgICAgICAgIG1heC13aWR0aDogNTAwcHg7XG4gICAgICAgIH1cbiAgICAgICAgaGEtY2FyZCB7XG4gICAgICAgICAgZGlzcGxheTogZmxleDtcbiAgICAgICAgICBmbGV4LWRpcmVjdGlvbjogY29sdW1uO1xuICAgICAgICAgIGhlaWdodDogMTAwJTtcbiAgICAgICAgfVxuICAgICAgICBoYS1jYXJkLnNpbmdsZSB7XG4gICAgICAgICAganVzdGlmeS1jb250ZW50OiBzcGFjZS1iZXR3ZWVuO1xuICAgICAgICB9XG4gICAgICAgIDpob3N0KC5oaWdobGlnaHQpIGhhLWNhcmQge1xuICAgICAgICAgIGJvcmRlcjogMXB4IHNvbGlkIHZhcigtLWFjY2VudC1jb2xvcik7XG4gICAgICAgIH1cbiAgICAgICAgLmNhcmQtY29udGVudCB7XG4gICAgICAgICAgcGFkZGluZzogMTZweDtcbiAgICAgICAgICB0ZXh0LWFsaWduOiBjZW50ZXI7XG4gICAgICAgIH1cbiAgICAgICAgaGEtY2FyZC5pbnRlZ3JhdGlvbiAuY2FyZC1jb250ZW50IHtcbiAgICAgICAgICBwYWRkaW5nLWJvdHRvbTogM3B4O1xuICAgICAgICB9XG4gICAgICAgIC5jYXJkLWFjdGlvbnMge1xuICAgICAgICAgIGJvcmRlci10b3A6IG5vbmU7XG4gICAgICAgICAgZGlzcGxheTogZmxleDtcbiAgICAgICAgICBqdXN0aWZ5LWNvbnRlbnQ6IHNwYWNlLWJldHdlZW47XG4gICAgICAgICAgYWxpZ24taXRlbXM6IGNlbnRlcjtcbiAgICAgICAgICBwYWRkaW5nLXJpZ2h0OiA1cHg7XG4gICAgICAgIH1cbiAgICAgICAgLmdyb3VwLWhlYWRlciB7XG4gICAgICAgICAgZGlzcGxheTogZmxleDtcbiAgICAgICAgICBhbGlnbi1pdGVtczogY2VudGVyO1xuICAgICAgICAgIGhlaWdodDogNDBweDtcbiAgICAgICAgICBwYWRkaW5nOiAxNnB4IDE2cHggOHB4IDE2cHg7XG4gICAgICAgICAgdmVydGljYWwtYWxpZ246IG1pZGRsZTtcbiAgICAgICAgfVxuICAgICAgICAuZ3JvdXAtaGVhZGVyIGgxIHtcbiAgICAgICAgICBtYXJnaW46IDA7XG4gICAgICAgIH1cbiAgICAgICAgLmdyb3VwLWhlYWRlciBpbWcge1xuICAgICAgICAgIG1hcmdpbi1yaWdodDogOHB4O1xuICAgICAgICB9XG4gICAgICAgIC5pbWFnZSB7XG4gICAgICAgICAgZGlzcGxheTogZmxleDtcbiAgICAgICAgICBhbGlnbi1pdGVtczogY2VudGVyO1xuICAgICAgICAgIGp1c3RpZnktY29udGVudDogY2VudGVyO1xuICAgICAgICAgIGhlaWdodDogNjBweDtcbiAgICAgICAgICBtYXJnaW4tYm90dG9tOiAxNnB4O1xuICAgICAgICAgIHZlcnRpY2FsLWFsaWduOiBtaWRkbGU7XG4gICAgICAgIH1cbiAgICAgICAgaW1nIHtcbiAgICAgICAgICBtYXgtaGVpZ2h0OiAxMDAlO1xuICAgICAgICAgIG1heC13aWR0aDogOTAlO1xuICAgICAgICB9XG5cbiAgICAgICAgLm5vbmUtZm91bmQge1xuICAgICAgICAgIG1hcmdpbjogYXV0bztcbiAgICAgICAgICB0ZXh0LWFsaWduOiBjZW50ZXI7XG4gICAgICAgIH1cbiAgICAgICAgYSB7XG4gICAgICAgICAgY29sb3I6IHZhcigtLXByaW1hcnktY29sb3IpO1xuICAgICAgICB9XG4gICAgICAgIGgxIHtcbiAgICAgICAgICBtYXJnaW4tYm90dG9tOiAwO1xuICAgICAgICB9XG4gICAgICAgIGgyIHtcbiAgICAgICAgICBtYXJnaW4tdG9wOiAwO1xuICAgICAgICAgIG1pbi1oZWlnaHQ6IDI0cHg7XG4gICAgICAgIH1cbiAgICAgICAgcGFwZXItbWVudS1idXR0b24ge1xuICAgICAgICAgIGNvbG9yOiB2YXIoLS1zZWNvbmRhcnktdGV4dC1jb2xvcik7XG4gICAgICAgICAgcGFkZGluZzogMDtcbiAgICAgICAgfVxuICAgICAgICBAbWVkaWEgKG1pbi13aWR0aDogNTYzcHgpIHtcbiAgICAgICAgICBwYXBlci1saXN0Ym94IHtcbiAgICAgICAgICAgIG1heC1oZWlnaHQ6IDE1MHB4O1xuICAgICAgICAgICAgb3ZlcmZsb3c6IGF1dG87XG4gICAgICAgICAgfVxuICAgICAgICB9XG4gICAgICAgIHBhcGVyLWl0ZW0ge1xuICAgICAgICAgIGN1cnNvcjogcG9pbnRlcjtcbiAgICAgICAgICBtaW4taGVpZ2h0OiAzNXB4O1xuICAgICAgICB9XG4gICAgICAgIC5iYWNrLWJ0biB7XG4gICAgICAgICAgcG9zaXRpb246IGFic29sdXRlO1xuICAgICAgICAgIGJhY2tncm91bmQ6ICNmZmZmZmZlMDtcbiAgICAgICAgICBib3JkZXItcmFkaXVzOiA1MCU7XG4gICAgICAgIH1cbiAgICAgIGAsXG4gICAgXTtcbiAgfVxufVxuXG5kZWNsYXJlIGdsb2JhbCB7XG4gIGludGVyZmFjZSBIVE1MRWxlbWVudFRhZ05hbWVNYXAge1xuICAgIFwiaGEtaW50ZWdyYXRpb24tY2FyZFwiOiBIYUludGVncmF0aW9uQ2FyZDtcbiAgfVxufVxuIl0sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7O0FBQUE7QUFBQTtBQUFBO0FBQ0E7QUFDQTtBQUNBOzs7Ozs7Ozs7Ozs7QUNGQTtBQUFBO0FBQUE7QUFBQTtBQUVBO0FBQ0E7QUFHQTs7Ozs7Ozs7Ozs7O0FDUEE7QUFBQTtBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUVBOzs7Ozs7Ozs7Ozs7QUNYQTtBQUFBO0FBQUE7QUFBQTtBQUNBO0FBQ0E7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOzs7Ozs7Ozs7Ozs7QUNSQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFEQTtBQURBO0FBS0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBaEJBO0FBQ0E7QUFpQkE7Ozs7Ozs7Ozs7OztBQ3hCQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBRUE7QUFDQTtBQUFBO0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFFQTtBQUNBO0FBSUE7QUFDQTtBQUNBO0FBWkE7QUFvQkE7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDekJBO0FBSUE7QUFJQTtBQUVBO0FBQUE7QUFBQTtBQUNBO0FBREE7QUFBQTtBQUNBO0FBRUE7QUFLQTtBQUNBO0FBQ0E7QUFDQTtBQUNBLHVLQUFBO0FBQ0E7QUFDQTtBQUNBO0FBZkE7QUF1QkE7Ozs7Ozs7Ozs7OztBQ2JBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBR0E7QUFNQTtBQUNBO0FBRkE7QUFNQTtBQUtBO0FBS0E7QUFDQTtBQUZBO0FBS0E7QUFNQTtBQUNBO0FBRkE7Ozs7Ozs7Ozs7OztBQ3JEQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFFQTtBQUdBO0FBRUE7QUFFQTtBQUFBO0FBQ0E7QUFEQTtBQUVBO0FBQ0E7QUFGQTtBQURBO0FBTUE7QUFNQTtBQVdBO0FBQ0E7QUFBQTtBQUFBO0FBRUE7QUFHQTtBQUNBO0FBRUE7QUFFQTtBQURBO0FBQ0E7QUFHQTtBQUNBO0FBWUE7QUFRQTtBQUtBO0FBSUE7QUFDQTtBQUNBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTs7Ozs7Ozs7Ozs7O0FDdkZBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQ0E7QUFDQTtBQTBCQTtBQUlBO0FBQ0E7QUFDQTtBQUNBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUFBO0FBQ0E7QUFFQTtBQUtBO0FBTUE7QUFFQTtBQUdBO0FBTUE7QUFDQTtBQUZBO0FBQ0E7QUFLQTtBQUVBO0FBREE7QUFDQTtBQUdBO0FBQ0E7QUFZQTs7Ozs7Ozs7Ozs7O0FDdkZBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFDQTtBQUNBO0FBMkJBO0FBVUE7QUFJQTtBQUNBO0FBQ0E7QUFDQTtBQUFBO0FBQ0E7QUFDQTtBQUVBO0FBS0E7QUFDQTtBQUZBO0FBS0E7QUFNQTtBQUNBO0FBRkE7QUFNQTtBQUtBO0FBQ0E7QUFGQTtBQUNBO0FBSUE7QUFFQTtBQURBO0FBQ0E7QUFHQTtBQUNBO0FBWUE7Ozs7Ozs7Ozs7OztBQzlFQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFHQTtBQUdBO0FBQ0E7QUFBQTtBQUVBO0FBR0E7QUFBQTtBQUFBOzs7Ozs7Ozs7Ozs7QUM1QkE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFDQTtBQURBO0FBS0E7QUFDQTtBQUZBO0FBSkE7QUFVQTtBQU1BO0FBV0E7Ozs7Ozs7Ozs7OztBQzlCQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBV0EsMmxCQUVBO0FBR0E7QUFJQTtBQUNBO0FBQ0E7QUFDQTtBQUhBO0FBS0E7Ozs7Ozs7Ozs7OztBQ3pCQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUNBO0FBQ0E7QUFDQTtBQU9BO0FBQ0E7QUFNQTtBQUVBO0FBS0E7QUFDQTtBQUNBO0FBS0E7QUFNQTtBQUNBO0FBQ0E7QUFJQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFNQTtBQUVBO0FBRkE7QUFLQTtBQUNBO0FBQ0E7QUFDQTtBQUtBO0FBQ0E7QUFDQTtBQUNBO0FBS0E7QUFFQTtBQUZBO0FBS0E7QUFDQTtBQUNBO0FBQ0E7QUFHQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBR0E7QUFDQTtBQUNBO0FBQ0E7QUFNQTs7QUFFQTs7QUFJQTs7OztBQUtBOztBQUxBO0FBTkE7QUFnQkE7QUFDQTtBQUNBO0FBQ0E7QUFRQTtBQUNBOzs7O0FBS0E7O0FBTEE7O0FBVUE7O0FBWEE7QUFrQkE7QUFDQTtBQXRJQTs7Ozs7Ozs7Ozs7O0FDdEJBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUErRUEsMmtFQUVBO0FBR0E7QUFLQTtBQUNBO0FBQ0E7QUFDQTtBQUVBO0FBRkE7QUFIQTtBQVFBOzs7Ozs7Ozs7Ozs7QUNsR0E7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUNBO0FBRUE7QUFNQTtBQUtBO0FBRUE7QUFPQTtBQURBO0FBSUE7QUFDQTtBQUNBO0FBSUE7QUFDQTtBQUNBO0FBQ0E7QUFJQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQU1BOzs7O0FBS0E7O0FBTEE7QUFTQTtBQUNBO0FBQ0E7QUFDQTtBQUtBO0FBQ0E7QUFDQTtBQUNBO0FBS0E7Ozs7QUFLQTs7QUFMQTtBQVNBO0FBQ0E7QUFDQTtBQUNBO0FBR0E7QUFDQTtBQUNBO0FBQ0E7QUFHQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQURBO0FBR0E7QUFDQTtBQXZGQTs7Ozs7Ozs7Ozs7O0FDeEJBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBaUNBLDZnQkFDQTtBQUNBO0FBQ0E7QUFTQTtBQUNBO0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFHQTtBQUNBO0FBQ0E7QUFBQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBZEE7QUFIQTtBQW9CQTtBQUNBO0FBQ0E7QUFLQTtBQUlBO0FBQUE7QUFJQTtBQUlBO0FBQUE7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQ3hGQTtBQUVBO0FBVUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUlBO0FBQ0E7QUFDQTtBQUNBO0FBS0E7QUFRQTtBQUlBO0FBSUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFlQTtBQUdBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFFQTtBQURBO0FBQ0E7QUFBQTtBQUNBO0FBREE7QUFBQTtBQUNBO0FBREE7QUFDQTs7QUFEQTs7O0FBQ0E7Ozs7O0FBRUE7Ozs7O0FBRUE7Ozs7O0FBRUE7Ozs7O0FBRUE7Ozs7O0FBRUE7Ozs7QUFBQTs7Ozs7QUFFQTs7OztBQUNBOzs7OztBQUVBOzs7O0FBQUE7Ozs7O0FBRUE7Ozs7QUFBQTs7Ozs7QUFFQTs7OztBQUFBOzs7OztBQUVBOzs7O0FBQUE7Ozs7O0FBSUE7Ozs7OztBQUVBO0FBQ0E7QUFFQTtBQUNBO0FBRUE7QUFDQTtBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFHQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFFQTtBQUZBO0FBSUE7QUFDQTtBQUVBOzs7Ozs7QUFFQTtBQUtBO0FBQ0E7QUFDQTtBQUNBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUpBO0FBTUE7QUFDQTtBQUNBOzs7Ozs7OztBQUdBO0FBS0E7QUFDQTtBQUdBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7Ozs7Ozs7O0FBR0E7QUFLQTtBQUdBO0FBRkE7QUFDQTtBQUlBO0FBQ0E7QUFDQTtBQUNBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUpBO0FBTUE7QUFDQTtBQUNBOzs7Ozs7QUFHQTtBQUNBO0FBQ0E7QUFBQTtBQUNBO0FBQUE7QUFDQTs7OztBQUVBO0FBQ0E7QUFDQTtBQUFBO0FBTUE7QUFDQTtBQUNBO0FBQUE7QUFDQTtBQUVBO0FBQ0E7QUFDQTtBQUNBO0FBQUE7QUFDQTtBQUVBO0FBQ0E7QUFDQTtBQURBO0FBR0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOzs7O0FBRUE7QUFDQTtBQUNBO0FBR0E7QUFDQTtBQUlBOztBQUVBO0FBQ0E7O0FBRUE7QUFDQTs7QUFFQTs7OztBQUtBOzs7O0FBSUE7Ozs7QUFUQTs7Ozs7Ozs7Ozs7Ozs7QUE0QkE7QUFDQTs7Ozs7QUFTQTs7Ozs7QUFNQTtBQUNBOzs7QUFQQTtBQUNBOzs7QUFjQTtBQUNBOztBQUVBOzs7QUFLQTs7Ozs7QUFPQTs7QUFFQTtBQUNBOzs7O0FBSUE7OztBQUdBO0FBQ0E7QUFDQTtBQUdBOzs7O0FBMUJBO0FBbUNBOzs7QUFLQTs7Ozs7QUFPQTs7QUFFQTtBQUNBOzs7O0FBSUE7Ozs7O0FBS0E7QUFDQTs7QUFFQTs7QUFJQTs7QUFJQTtBQUNBOztBQUVBOztBQVBBOzs7O0FBOUJBO0FBaURBO0FBSUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBUkE7Ozs7QUFnQkE7OztBQUdBOztBQUlBO0FBQ0E7Ozs7QUFiQTtBQXFCQTs7O0FBT0E7OztBQUtBOzs7QUFaQTs7OztBQXNCQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7OztBQWxOQTtBQXNOQTs7OztBQUVBO0FBQ0E7QUFDQTtBQUlBO0FBRkE7QUFjQTtBQUNBOzs7O0FBRUE7QUFDQTtBQUdBOzs7O0FBRUE7QUFDQTtBQUNBO0FBRUE7QUFEQTtBQUlBOzs7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUFBO0FBQ0E7QUFDQTtBQUxBO0FBQ0E7QUFPQTtBQUNBOzs7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQUE7QUFDQTtBQUxBO0FBT0E7Ozs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUtBO0FBR0E7QUFUQTtBQUNBO0FBWUE7QUFDQTtBQUNBO0FBQ0E7QUFBQTtBQUNBO0FBQUE7QUFDQTtBQUFBO0FBQ0E7Ozs7QUFFQTtBQUNBO0FBQ0E7Ozs7QUFFQTtBQUNBO0FBQ0E7QUFDQTtBQUtBO0FBR0E7QUFHQTtBQUNBO0FBQ0E7QUFBQTtBQUNBO0FBS0E7QUFDQTtBQUFBO0FBQ0E7QUF0QkE7QUF3QkE7Ozs7QUFFQTtBQUNBO0FBQ0E7Ozs7QUFFQTtBQUNBO0FBQ0E7Ozs7QUFFQTtBQUNBO0FBQ0E7Ozs7O0FBRUE7QUFDQTs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQUFBO0FBOEdBOzs7QUEzbUJBOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDcEZBO0FBV0E7QUFDQTtBQU9BO0FBQ0E7QUFDQTtBQUtBO0FBQ0E7QUFDQTtBQW1CQTtBQURBO0FBQ0E7QUFBQTtBQUNBO0FBREE7QUFBQTtBQUNBO0FBREE7QUFDQTtBQURBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTtBQWNBO0FBQ0E7QUFDQTtBQUNBO0FBQUE7QUFDQTtBQUNBO0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUFBO0FBQ0E7QUExQkE7QUFBQTtBQUFBO0FBQUE7QUE2QkE7Ozs7QUFJQTs7QUFFQTtBQUNBOzs7QUFHQTs7OztBQUlBO0FBR0E7QUFDQTtBQUNBOztBQUxBOzs7QUFkQTtBQTBCQTtBQXZEQTtBQUFBO0FBQUE7QUFBQTtBQTBEQTtBQUNBO0FBQUE7QUFDQTtBQUFBOzs7QUFHQTtBQUNBOztBQUVBOzs7QUFJQTtBQUpBOzs7O0FBVUE7O0FBRUE7QUFDQTs7OztBQUlBOzs7QUFHQTs7QUFFQTs7QUFHQTs7QUFHQTtBQUNBOztBQUpBO0FBWUE7QUFDQTs7QUFHQTtBQUNBOztBQUpBOztBQWhCQTs7OztBQWtDQTtBQUNBOztBQUlBO0FBRUE7QUFDQTs7QUFIQTs7Ozs7Ozs7Ozs7QUFtQkE7OztBQUtBO0FBQ0E7O0FBSUE7QUFDQTs7Ozs7O0FBakdBO0FBMEdBO0FBdEtBO0FBQUE7QUFBQTtBQUFBO0FBeUtBO0FBQ0E7QUExS0E7QUFBQTtBQUFBO0FBQUE7QUE2S0E7QUFDQTtBQUNBO0FBL0tBO0FBQUE7QUFBQTtBQUFBO0FBa0xBO0FBQ0E7QUFDQTtBQUNBO0FBQUE7QUFHQTtBQXhMQTtBQUFBO0FBQUE7QUFBQTtBQTJMQTtBQUNBO0FBQ0E7QUFDQTtBQUFBO0FBR0E7QUFqTUE7QUFBQTtBQUFBO0FBQUE7QUFvTUE7QUFDQTtBQXJNQTtBQUFBO0FBQUE7QUFBQTtBQXdNQTtBQUNBO0FBek1BO0FBQUE7QUFBQTtBQUFBO0FBNE1BO0FBQ0E7QUE3TUE7QUFBQTtBQUFBO0FBQUE7QUFnTkE7QUFDQTtBQURBO0FBR0E7QUFuTkE7QUFBQTtBQUFBO0FBQUE7QUFzTkE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUhBO0FBQ0E7QUFNQTtBQUNBO0FBQ0E7QUFDQTtBQUFBO0FBQ0E7QUFEQTtBQUdBO0FBQUE7QUFBQTtBQUNBO0FBck9BO0FBQUE7QUFBQTtBQUFBO0FBd09BO0FBRUE7QUFDQTtBQURBO0FBQ0E7QUFLQTtBQUNBO0FBQ0E7QUFDQTtBQUFBO0FBQ0E7QUFBQTtBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFEQTtBQUtBO0FBQ0E7QUFDQTtBQTlQQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBaVFBOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FBQUE7QUE0RkE7QUE3VkE7QUFBQTtBQUFBOzs7O0EiLCJzb3VyY2VSb290IjoiIn0=