(self["webpackJsonp"] = self["webpackJsonp"] || []).push([["panel-config-devices"],{

/***/ "./src/common/datetime/format_date.ts":
/*!********************************************!*\
  !*** ./src/common/datetime/format_date.ts ***!
  \********************************************/
/*! exports provided: formatDate */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "formatDate", function() { return formatDate; });
/* harmony import */ var fecha__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! fecha */ "./node_modules/fecha/src/fecha.js");
/* harmony import */ var _check_options_support__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./check_options_support */ "./src/common/datetime/check_options_support.ts");


const formatDate = _check_options_support__WEBPACK_IMPORTED_MODULE_1__["toLocaleDateStringSupportsOptions"] ? (dateObj, locales) => dateObj.toLocaleDateString(locales, {
  year: "numeric",
  month: "long",
  day: "numeric"
}) : dateObj => fecha__WEBPACK_IMPORTED_MODULE_0__["default"].format(dateObj, "longDate");

/***/ }),

/***/ "./src/common/datetime/format_time.ts":
/*!********************************************!*\
  !*** ./src/common/datetime/format_time.ts ***!
  \********************************************/
/*! exports provided: formatTime, formatTimeWithSeconds */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "formatTime", function() { return formatTime; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "formatTimeWithSeconds", function() { return formatTimeWithSeconds; });
/* harmony import */ var fecha__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! fecha */ "./node_modules/fecha/src/fecha.js");
/* harmony import */ var _check_options_support__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./check_options_support */ "./src/common/datetime/check_options_support.ts");


const formatTime = _check_options_support__WEBPACK_IMPORTED_MODULE_1__["toLocaleTimeStringSupportsOptions"] ? (dateObj, locales) => dateObj.toLocaleTimeString(locales, {
  hour: "numeric",
  minute: "2-digit"
}) : dateObj => fecha__WEBPACK_IMPORTED_MODULE_0__["default"].format(dateObj, "shortTime");
const formatTimeWithSeconds = _check_options_support__WEBPACK_IMPORTED_MODULE_1__["toLocaleTimeStringSupportsOptions"] ? (dateObj, locales) => dateObj.toLocaleTimeString(locales, {
  hour: "numeric",
  minute: "2-digit",
  second: "2-digit"
}) : dateObj => fecha__WEBPACK_IMPORTED_MODULE_0__["default"].format(dateObj, "mediumTime");

/***/ }),

/***/ "./src/common/entity/compute_state_display.ts":
/*!****************************************************!*\
  !*** ./src/common/entity/compute_state_display.ts ***!
  \****************************************************/
/*! exports provided: computeStateDisplay */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "computeStateDisplay", function() { return computeStateDisplay; });
/* harmony import */ var _data_entity__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../data/entity */ "./src/data/entity.ts");
/* harmony import */ var _datetime_format_date__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../datetime/format_date */ "./src/common/datetime/format_date.ts");
/* harmony import */ var _datetime_format_date_time__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../datetime/format_date_time */ "./src/common/datetime/format_date_time.ts");
/* harmony import */ var _datetime_format_time__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../datetime/format_time */ "./src/common/datetime/format_time.ts");
/* harmony import */ var _compute_state_domain__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./compute_state_domain */ "./src/common/entity/compute_state_domain.ts");





const computeStateDisplay = (localize, stateObj, language) => {
  if (stateObj.state === _data_entity__WEBPACK_IMPORTED_MODULE_0__["UNKNOWN"] || stateObj.state === _data_entity__WEBPACK_IMPORTED_MODULE_0__["UNAVAILABLE"]) {
    return localize(`state.default.${stateObj.state}`);
  }

  if (stateObj.attributes.unit_of_measurement) {
    return `${stateObj.state} ${stateObj.attributes.unit_of_measurement}`;
  }

  const domain = Object(_compute_state_domain__WEBPACK_IMPORTED_MODULE_4__["computeStateDomain"])(stateObj);

  if (domain === "input_datetime") {
    let date;

    if (!stateObj.attributes.has_time) {
      date = new Date(stateObj.attributes.year, stateObj.attributes.month - 1, stateObj.attributes.day);
      return Object(_datetime_format_date__WEBPACK_IMPORTED_MODULE_1__["formatDate"])(date, language);
    }

    if (!stateObj.attributes.has_date) {
      const now = new Date();
      date = new Date( // Due to bugs.chromium.org/p/chromium/issues/detail?id=797548
      // don't use artificial 1970 year.
      now.getFullYear(), now.getMonth(), now.getDay(), stateObj.attributes.hour, stateObj.attributes.minute);
      return Object(_datetime_format_time__WEBPACK_IMPORTED_MODULE_3__["formatTime"])(date, language);
    }

    date = new Date(stateObj.attributes.year, stateObj.attributes.month - 1, stateObj.attributes.day, stateObj.attributes.hour, stateObj.attributes.minute);
    return Object(_datetime_format_date_time__WEBPACK_IMPORTED_MODULE_2__["formatDateTime"])(date, language);
  }

  return (// Return device class translation
    stateObj.attributes.device_class && localize(`component.${domain}.state.${stateObj.attributes.device_class}.${stateObj.state}`) || // Return default translation
    localize(`component.${domain}.state._.${stateObj.state}`) || // We don't know! Return the raw state.
    stateObj.state
  );
};

/***/ }),

/***/ "./src/common/string/compare.ts":
/*!**************************************!*\
  !*** ./src/common/string/compare.ts ***!
  \**************************************/
/*! exports provided: compare, caseInsensitiveCompare */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "compare", function() { return compare; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "caseInsensitiveCompare", function() { return caseInsensitiveCompare; });
const compare = (a, b) => {
  if (a < b) {
    return -1;
  }

  if (a > b) {
    return 1;
  }

  return 0;
};
const caseInsensitiveCompare = (a, b) => compare(a.toLowerCase(), b.toLowerCase());

/***/ }),

/***/ "./src/components/entity/ha-state-icon.js":
/*!************************************************!*\
  !*** ./src/components/entity/ha-state-icon.js ***!
  \************************************************/
/*! no exports provided */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _polymer_polymer_lib_utils_html_tag__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @polymer/polymer/lib/utils/html-tag */ "./node_modules/@polymer/polymer/lib/utils/html-tag.js");
/* harmony import */ var _polymer_polymer_polymer_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @polymer/polymer/polymer-element */ "./node_modules/@polymer/polymer/polymer-element.js");
/* harmony import */ var _common_entity_state_icon__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../common/entity/state_icon */ "./src/common/entity/state_icon.ts");
/* harmony import */ var _ha_icon__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../ha-icon */ "./src/components/ha-icon.ts");

/* eslint-plugin-disable lit */





class HaStateIcon extends _polymer_polymer_polymer_element__WEBPACK_IMPORTED_MODULE_1__["PolymerElement"] {
  static get template() {
    return _polymer_polymer_lib_utils_html_tag__WEBPACK_IMPORTED_MODULE_0__["html"]` <ha-icon icon="[[computeIcon(stateObj)]]"></ha-icon> `;
  }

  static get properties() {
    return {
      stateObj: {
        type: Object
      }
    };
  }

  computeIcon(stateObj) {
    return Object(_common_entity_state_icon__WEBPACK_IMPORTED_MODULE_2__["stateIcon"])(stateObj);
  }

}

customElements.define("ha-state-icon", HaStateIcon);

/***/ }),

/***/ "./src/components/ha-icon-next.ts":
/*!****************************************!*\
  !*** ./src/components/ha-icon-next.ts ***!
  \****************************************/
/*! exports provided: HaIconNext */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HaIconNext", function() { return HaIconNext; });
/* harmony import */ var _polymer_iron_icon_iron_icon__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @polymer/iron-icon/iron-icon */ "./node_modules/@polymer/iron-icon/iron-icon.js");
/* harmony import */ var _ha_icon__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ha-icon */ "./src/components/ha-icon.ts");
 // Not duplicate, this is for typing.
// eslint-disable-next-line


class HaIconNext extends _ha_icon__WEBPACK_IMPORTED_MODULE_1__["HaIcon"] {
  connectedCallback() {
    super.connectedCallback(); // wait to check for direction since otherwise direction is wrong even though top level is RTL

    setTimeout(() => {
      this.icon = window.getComputedStyle(this).direction === "ltr" ? "hass:chevron-right" : "hass:chevron-left";
    }, 100);
  }

}
customElements.define("ha-icon-next", HaIconNext);

/***/ }),

/***/ "./src/data/area_registry.ts":
/*!***********************************!*\
  !*** ./src/data/area_registry.ts ***!
  \***********************************/
/*! exports provided: createAreaRegistryEntry, updateAreaRegistryEntry, deleteAreaRegistryEntry, subscribeAreaRegistry */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "createAreaRegistryEntry", function() { return createAreaRegistryEntry; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "updateAreaRegistryEntry", function() { return updateAreaRegistryEntry; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "deleteAreaRegistryEntry", function() { return deleteAreaRegistryEntry; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "subscribeAreaRegistry", function() { return subscribeAreaRegistry; });
/* harmony import */ var home_assistant_js_websocket__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! home-assistant-js-websocket */ "./node_modules/home-assistant-js-websocket/dist/index.js");
/* harmony import */ var _common_string_compare__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../common/string/compare */ "./src/common/string/compare.ts");
/* harmony import */ var _common_util_debounce__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../common/util/debounce */ "./src/common/util/debounce.ts");



const createAreaRegistryEntry = (hass, values) => hass.callWS(Object.assign({
  type: "config/area_registry/create"
}, values));
const updateAreaRegistryEntry = (hass, areaId, updates) => hass.callWS(Object.assign({
  type: "config/area_registry/update",
  area_id: areaId
}, updates));
const deleteAreaRegistryEntry = (hass, areaId) => hass.callWS({
  type: "config/area_registry/delete",
  area_id: areaId
});

const fetchAreaRegistry = conn => conn.sendMessagePromise({
  type: "config/area_registry/list"
}).then(areas => areas.sort((ent1, ent2) => Object(_common_string_compare__WEBPACK_IMPORTED_MODULE_1__["compare"])(ent1.name, ent2.name)));

const subscribeAreaRegistryUpdates = (conn, store) => conn.subscribeEvents(Object(_common_util_debounce__WEBPACK_IMPORTED_MODULE_2__["debounce"])(() => fetchAreaRegistry(conn).then(areas => store.setState(areas, true)), 500, true), "area_registry_updated");

const subscribeAreaRegistry = (conn, onChange) => Object(home_assistant_js_websocket__WEBPACK_IMPORTED_MODULE_0__["createCollection"])("_areaRegistry", fetchAreaRegistry, subscribeAreaRegistryUpdates, conn, onChange);

/***/ }),

/***/ "./src/data/config_entries.ts":
/*!************************************!*\
  !*** ./src/data/config_entries.ts ***!
  \************************************/
/*! exports provided: getConfigEntries, updateConfigEntry, deleteConfigEntry, getConfigEntrySystemOptions, updateConfigEntrySystemOptions */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getConfigEntries", function() { return getConfigEntries; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "updateConfigEntry", function() { return updateConfigEntry; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "deleteConfigEntry", function() { return deleteConfigEntry; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getConfigEntrySystemOptions", function() { return getConfigEntrySystemOptions; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "updateConfigEntrySystemOptions", function() { return updateConfigEntrySystemOptions; });
const getConfigEntries = hass => hass.callApi("GET", "config/config_entries/entry");
const updateConfigEntry = (hass, configEntryId, updatedValues) => hass.callWS(Object.assign({
  type: "config_entries/update",
  entry_id: configEntryId
}, updatedValues));
const deleteConfigEntry = (hass, configEntryId) => hass.callApi("DELETE", `config/config_entries/entry/${configEntryId}`);
const getConfigEntrySystemOptions = (hass, configEntryId) => hass.callWS({
  type: "config_entries/system_options/list",
  entry_id: configEntryId
});
const updateConfigEntrySystemOptions = (hass, configEntryId, params) => hass.callWS(Object.assign({
  type: "config_entries/system_options/update",
  entry_id: configEntryId
}, params));

/***/ }),

/***/ "./src/data/device_registry.ts":
/*!*************************************!*\
  !*** ./src/data/device_registry.ts ***!
  \*************************************/
/*! exports provided: fallbackDeviceName, computeDeviceName, devicesInArea, updateDeviceRegistryEntry, subscribeDeviceRegistry */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "fallbackDeviceName", function() { return fallbackDeviceName; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "computeDeviceName", function() { return computeDeviceName; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "devicesInArea", function() { return devicesInArea; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "updateDeviceRegistryEntry", function() { return updateDeviceRegistryEntry; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "subscribeDeviceRegistry", function() { return subscribeDeviceRegistry; });
/* harmony import */ var home_assistant_js_websocket__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! home-assistant-js-websocket */ "./node_modules/home-assistant-js-websocket/dist/index.js");
/* harmony import */ var _common_entity_compute_state_name__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../common/entity/compute_state_name */ "./src/common/entity/compute_state_name.ts");
/* harmony import */ var _common_util_debounce__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../common/util/debounce */ "./src/common/util/debounce.ts");



const fallbackDeviceName = (hass, entities) => {
  for (const entity of entities || []) {
    const entityId = typeof entity === "string" ? entity : entity.entity_id;
    const stateObj = hass.states[entityId];

    if (stateObj) {
      return Object(_common_entity_compute_state_name__WEBPACK_IMPORTED_MODULE_1__["computeStateName"])(stateObj);
    }
  }

  return undefined;
};
const computeDeviceName = (device, hass, entities) => {
  return device.name_by_user || device.name || entities && fallbackDeviceName(hass, entities) || hass.localize("ui.panel.config.devices.unnamed_device");
};
const devicesInArea = (devices, areaId) => devices.filter(device => device.area_id === areaId);
const updateDeviceRegistryEntry = (hass, deviceId, updates) => hass.callWS(Object.assign({
  type: "config/device_registry/update",
  device_id: deviceId
}, updates));

const fetchDeviceRegistry = conn => conn.sendMessagePromise({
  type: "config/device_registry/list"
});

const subscribeDeviceRegistryUpdates = (conn, store) => conn.subscribeEvents(Object(_common_util_debounce__WEBPACK_IMPORTED_MODULE_2__["debounce"])(() => fetchDeviceRegistry(conn).then(devices => store.setState(devices, true)), 500, true), "device_registry_updated");

const subscribeDeviceRegistry = (conn, onChange) => Object(home_assistant_js_websocket__WEBPACK_IMPORTED_MODULE_0__["createCollection"])("_dr", fetchDeviceRegistry, subscribeDeviceRegistryUpdates, conn, onChange);

/***/ }),

/***/ "./src/data/lovelace.ts":
/*!******************************!*\
  !*** ./src/data/lovelace.ts ***!
  \******************************/
/*! exports provided: fetchResources, createResource, updateResource, deleteResource, fetchDashboards, createDashboard, updateDashboard, deleteDashboard, fetchConfig, saveConfig, deleteConfig, subscribeLovelaceUpdates, getLovelaceCollection, getLegacyLovelaceCollection */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "fetchResources", function() { return fetchResources; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "createResource", function() { return createResource; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "updateResource", function() { return updateResource; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "deleteResource", function() { return deleteResource; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "fetchDashboards", function() { return fetchDashboards; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "createDashboard", function() { return createDashboard; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "updateDashboard", function() { return updateDashboard; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "deleteDashboard", function() { return deleteDashboard; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "fetchConfig", function() { return fetchConfig; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "saveConfig", function() { return saveConfig; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "deleteConfig", function() { return deleteConfig; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "subscribeLovelaceUpdates", function() { return subscribeLovelaceUpdates; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getLovelaceCollection", function() { return getLovelaceCollection; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getLegacyLovelaceCollection", function() { return getLegacyLovelaceCollection; });
/* harmony import */ var home_assistant_js_websocket__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! home-assistant-js-websocket */ "./node_modules/home-assistant-js-websocket/dist/index.js");

const fetchResources = conn => conn.sendMessagePromise({
  type: "lovelace/resources"
});
const createResource = (hass, values) => hass.callWS(Object.assign({
  type: "lovelace/resources/create"
}, values));
const updateResource = (hass, id, updates) => hass.callWS(Object.assign({
  type: "lovelace/resources/update",
  resource_id: id
}, updates));
const deleteResource = (hass, id) => hass.callWS({
  type: "lovelace/resources/delete",
  resource_id: id
});
const fetchDashboards = hass => hass.callWS({
  type: "lovelace/dashboards/list"
});
const createDashboard = (hass, values) => hass.callWS(Object.assign({
  type: "lovelace/dashboards/create"
}, values));
const updateDashboard = (hass, id, updates) => hass.callWS(Object.assign({
  type: "lovelace/dashboards/update",
  dashboard_id: id
}, updates));
const deleteDashboard = (hass, id) => hass.callWS({
  type: "lovelace/dashboards/delete",
  dashboard_id: id
});
const fetchConfig = (conn, urlPath, force) => conn.sendMessagePromise({
  type: "lovelace/config",
  url_path: urlPath,
  force
});
const saveConfig = (hass, urlPath, config) => hass.callWS({
  type: "lovelace/config/save",
  url_path: urlPath,
  config
});
const deleteConfig = (hass, urlPath) => hass.callWS({
  type: "lovelace/config/delete",
  url_path: urlPath
});
const subscribeLovelaceUpdates = (conn, urlPath, onChange) => conn.subscribeEvents(ev => {
  if (ev.data.url_path === urlPath) {
    onChange();
  }
}, "lovelace_updated");
const getLovelaceCollection = (conn, urlPath = null) => Object(home_assistant_js_websocket__WEBPACK_IMPORTED_MODULE_0__["getCollection"])(conn, `_lovelace_${urlPath !== null && urlPath !== void 0 ? urlPath : ""}`, conn2 => fetchConfig(conn2, urlPath, false), (_conn, store) => subscribeLovelaceUpdates(conn, urlPath, () => fetchConfig(conn, urlPath, false).then(config => store.setState(config, true)))); // Legacy functions to support cast for Home Assistion < 0.107

const fetchLegacyConfig = (conn, force) => conn.sendMessagePromise({
  type: "lovelace/config",
  force
});

const subscribeLegacyLovelaceUpdates = (conn, onChange) => conn.subscribeEvents(onChange, "lovelace_updated");

const getLegacyLovelaceCollection = conn => Object(home_assistant_js_websocket__WEBPACK_IMPORTED_MODULE_0__["getCollection"])(conn, "_lovelace", conn2 => fetchLegacyConfig(conn2, false), (_conn, store) => subscribeLegacyLovelaceUpdates(conn, () => fetchLegacyConfig(conn, false).then(config => store.setState(config, true))));

/***/ }),

/***/ "./src/data/mqtt.ts":
/*!**************************!*\
  !*** ./src/data/mqtt.ts ***!
  \**************************/
/*! exports provided: subscribeMQTTTopic, removeMQTTDeviceEntry, fetchMQTTDebugInfo */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "subscribeMQTTTopic", function() { return subscribeMQTTTopic; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "removeMQTTDeviceEntry", function() { return removeMQTTDeviceEntry; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "fetchMQTTDebugInfo", function() { return fetchMQTTDebugInfo; });
const subscribeMQTTTopic = (hass, topic, callback) => {
  return hass.connection.subscribeMessage(callback, {
    type: "mqtt/subscribe",
    topic
  });
};
const removeMQTTDeviceEntry = (hass, deviceId) => hass.callWS({
  type: "mqtt/device/remove",
  device_id: deviceId
});
const fetchMQTTDebugInfo = (hass, deviceId) => hass.callWS({
  type: "mqtt/device/debug_info",
  device_id: deviceId
});

/***/ }),

/***/ "./src/data/search.ts":
/*!****************************!*\
  !*** ./src/data/search.ts ***!
  \****************************/
/*! exports provided: findRelated */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "findRelated", function() { return findRelated; });
const findRelated = (hass, itemType, itemId) => hass.callWS({
  type: "search/related",
  item_type: itemType,
  item_id: itemId
});

/***/ }),

/***/ "./src/dialogs/device-registry-detail/show-dialog-device-registry-detail.ts":
/*!**********************************************************************************!*\
  !*** ./src/dialogs/device-registry-detail/show-dialog-device-registry-detail.ts ***!
  \**********************************************************************************/
/*! exports provided: loadDeviceRegistryDetailDialog, showDeviceRegistryDetailDialog */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "loadDeviceRegistryDetailDialog", function() { return loadDeviceRegistryDetailDialog; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "showDeviceRegistryDetailDialog", function() { return showDeviceRegistryDetailDialog; });
/* harmony import */ var _common_dom_fire_event__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../common/dom/fire_event */ "./src/common/dom/fire_event.ts");

const loadDeviceRegistryDetailDialog = () => Promise.all(/*! import() | device-registry-detail-dialog */[__webpack_require__.e(1), __webpack_require__.e(0), __webpack_require__.e(2), __webpack_require__.e(3), __webpack_require__.e(6), __webpack_require__.e(7), __webpack_require__.e(8), __webpack_require__.e("vendors~cloud-webhook-manage-dialog~config-entry-system-options~confirmation~device-registry-detail-~836e8839"), __webpack_require__.e("vendors~device-registry-detail-dialog~dialog-config-flow"), __webpack_require__.e("device-registry-detail-dialog~dialog-config-flow~entity-editor-dialog~panel-config-automation~panel-~da811c14"), __webpack_require__.e("device-registry-detail-dialog~dialog-config-flow"), __webpack_require__.e("device-registry-detail-dialog")]).then(__webpack_require__.bind(null, /*! ./dialog-device-registry-detail */ "./src/dialogs/device-registry-detail/dialog-device-registry-detail.ts"));
const showDeviceRegistryDetailDialog = (element, deviceRegistryDetailParams) => {
  Object(_common_dom_fire_event__WEBPACK_IMPORTED_MODULE_0__["fireEvent"])(element, "show-dialog", {
    dialogTag: "dialog-device-registry-detail",
    dialogImport: loadDeviceRegistryDetailDialog,
    dialogParams: deviceRegistryDetailParams
  });
};

/***/ }),

/***/ "./src/dialogs/generic/show-dialog-box.ts":
/*!************************************************!*\
  !*** ./src/dialogs/generic/show-dialog-box.ts ***!
  \************************************************/
/*! exports provided: loadGenericDialog, showAlertDialog, showConfirmationDialog, showPromptDialog */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "loadGenericDialog", function() { return loadGenericDialog; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "showAlertDialog", function() { return showAlertDialog; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "showConfirmationDialog", function() { return showConfirmationDialog; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "showPromptDialog", function() { return showPromptDialog; });
/* harmony import */ var _common_dom_fire_event__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../common/dom/fire_event */ "./src/common/dom/fire_event.ts");

const loadGenericDialog = () => Promise.all(/*! import() | confirmation */[__webpack_require__.e(1), __webpack_require__.e(4), __webpack_require__.e(5), __webpack_require__.e("vendors~cloud-webhook-manage-dialog~config-entry-system-options~confirmation~device-registry-detail-~836e8839"), __webpack_require__.e(13), __webpack_require__.e("vendors~confirmation"), __webpack_require__.e(14), __webpack_require__.e("confirmation")]).then(__webpack_require__.bind(null, /*! ./dialog-box */ "./src/dialogs/generic/dialog-box.ts"));

const showDialogHelper = (element, dialogParams, extra) => new Promise(resolve => {
  const origCancel = dialogParams.cancel;
  const origConfirm = dialogParams.confirm;
  Object(_common_dom_fire_event__WEBPACK_IMPORTED_MODULE_0__["fireEvent"])(element, "show-dialog", {
    dialogTag: "dialog-box",
    dialogImport: loadGenericDialog,
    dialogParams: Object.assign({}, dialogParams, {}, extra, {
      cancel: () => {
        resolve((extra === null || extra === void 0 ? void 0 : extra.prompt) ? null : false);

        if (origCancel) {
          origCancel();
        }
      },
      confirm: out => {
        resolve((extra === null || extra === void 0 ? void 0 : extra.prompt) ? out : true);

        if (origConfirm) {
          origConfirm(out);
        }
      }
    })
  });
});

const showAlertDialog = (element, dialogParams) => showDialogHelper(element, dialogParams);
const showConfirmationDialog = (element, dialogParams) => showDialogHelper(element, dialogParams, {
  confirmation: true
});
const showPromptDialog = (element, dialogParams) => showDialogHelper(element, dialogParams, {
  prompt: true
});

/***/ }),

/***/ "./src/dialogs/mqtt-device-debug-info-dialog/show-dialog-mqtt-device-debug-info.ts":
/*!*****************************************************************************************!*\
  !*** ./src/dialogs/mqtt-device-debug-info-dialog/show-dialog-mqtt-device-debug-info.ts ***!
  \*****************************************************************************************/
/*! exports provided: loadMQTTDeviceDebugInfoDialog, showMQTTDeviceDebugInfoDialog */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "loadMQTTDeviceDebugInfoDialog", function() { return loadMQTTDeviceDebugInfoDialog; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "showMQTTDeviceDebugInfoDialog", function() { return showMQTTDeviceDebugInfoDialog; });
/* harmony import */ var _common_dom_fire_event__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../common/dom/fire_event */ "./src/common/dom/fire_event.ts");

const loadMQTTDeviceDebugInfoDialog = () => Promise.all(/*! import() | dialog-mqtt-device-debug-info */[__webpack_require__.e(17), __webpack_require__.e("vendors~add-user-dialog~device-automation-dialog~dialog-mqtt-device-debug-info~dialog-zha-device-zig~61d72af3"), __webpack_require__.e("add-user-dialog~device-automation-dialog~dialog-mqtt-device-debug-info~dialog-zha-device-zigbee-info~af4b98d6"), __webpack_require__.e("dialog-mqtt-device-debug-info")]).then(__webpack_require__.bind(null, /*! ./dialog-mqtt-device-debug-info */ "./src/dialogs/mqtt-device-debug-info-dialog/dialog-mqtt-device-debug-info.ts"));
const showMQTTDeviceDebugInfoDialog = (element, mqttDeviceInfoParams) => {
  Object(_common_dom_fire_event__WEBPACK_IMPORTED_MODULE_0__["fireEvent"])(element, "show-dialog", {
    dialogTag: "dialog-mqtt-device-debug-info",
    dialogImport: loadMQTTDeviceDebugInfoDialog,
    dialogParams: mqttDeviceInfoParams
  });
};

/***/ }),

/***/ "./src/panels/config/devices/device-detail/ha-device-card-mqtt.ts":
/*!************************************************************************!*\
  !*** ./src/panels/config/devices/device-detail/ha-device-card-mqtt.ts ***!
  \************************************************************************/
/*! exports provided: HaDeviceCardMqtt */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HaDeviceCardMqtt", function() { return HaDeviceCardMqtt; });
/* harmony import */ var lit_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lit-element */ "./node_modules/lit-element/lit-element.js");
/* harmony import */ var _data_mqtt__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../data/mqtt */ "./src/data/mqtt.ts");
/* harmony import */ var _dialogs_generic_show_dialog_box__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../dialogs/generic/show-dialog-box */ "./src/dialogs/generic/show-dialog-box.ts");
/* harmony import */ var _dialogs_mqtt_device_debug_info_dialog_show_dialog_mqtt_device_debug_info__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../dialogs/mqtt-device-debug-info-dialog/show-dialog-mqtt-device-debug-info */ "./src/dialogs/mqtt-device-debug-info-dialog/show-dialog-mqtt-device-debug-info.ts");
/* harmony import */ var _resources_styles__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../resources/styles */ "./src/resources/styles.ts");
function _decorate(decorators, factory, superClass, mixins) { var api = _getDecoratorsApi(); if (mixins) { for (var i = 0; i < mixins.length; i++) { api = mixins[i](api); } } var r = factory(function initialize(O) { api.initializeInstanceElements(O, decorated.elements); }, superClass); var decorated = api.decorateClass(_coalesceClassElements(r.d.map(_createElementDescriptor)), decorators); api.initializeClassElements(r.F, decorated.elements); return api.runClassFinishers(r.F, decorated.finishers); }

function _getDecoratorsApi() { _getDecoratorsApi = function () { return api; }; var api = { elementsDefinitionOrder: [["method"], ["field"]], initializeInstanceElements: function (O, elements) { ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { if (element.kind === kind && element.placement === "own") { this.defineClassElement(O, element); } }, this); }, this); }, initializeClassElements: function (F, elements) { var proto = F.prototype; ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { var placement = element.placement; if (element.kind === kind && (placement === "static" || placement === "prototype")) { var receiver = placement === "static" ? F : proto; this.defineClassElement(receiver, element); } }, this); }, this); }, defineClassElement: function (receiver, element) { var descriptor = element.descriptor; if (element.kind === "field") { var initializer = element.initializer; descriptor = { enumerable: descriptor.enumerable, writable: descriptor.writable, configurable: descriptor.configurable, value: initializer === void 0 ? void 0 : initializer.call(receiver) }; } Object.defineProperty(receiver, element.key, descriptor); }, decorateClass: function (elements, decorators) { var newElements = []; var finishers = []; var placements = { static: [], prototype: [], own: [] }; elements.forEach(function (element) { this.addElementPlacement(element, placements); }, this); elements.forEach(function (element) { if (!_hasDecorators(element)) return newElements.push(element); var elementFinishersExtras = this.decorateElement(element, placements); newElements.push(elementFinishersExtras.element); newElements.push.apply(newElements, elementFinishersExtras.extras); finishers.push.apply(finishers, elementFinishersExtras.finishers); }, this); if (!decorators) { return { elements: newElements, finishers: finishers }; } var result = this.decorateConstructor(newElements, decorators); finishers.push.apply(finishers, result.finishers); result.finishers = finishers; return result; }, addElementPlacement: function (element, placements, silent) { var keys = placements[element.placement]; if (!silent && keys.indexOf(element.key) !== -1) { throw new TypeError("Duplicated element (" + element.key + ")"); } keys.push(element.key); }, decorateElement: function (element, placements) { var extras = []; var finishers = []; for (var decorators = element.decorators, i = decorators.length - 1; i >= 0; i--) { var keys = placements[element.placement]; keys.splice(keys.indexOf(element.key), 1); var elementObject = this.fromElementDescriptor(element); var elementFinisherExtras = this.toElementFinisherExtras((0, decorators[i])(elementObject) || elementObject); element = elementFinisherExtras.element; this.addElementPlacement(element, placements); if (elementFinisherExtras.finisher) { finishers.push(elementFinisherExtras.finisher); } var newExtras = elementFinisherExtras.extras; if (newExtras) { for (var j = 0; j < newExtras.length; j++) { this.addElementPlacement(newExtras[j], placements); } extras.push.apply(extras, newExtras); } } return { element: element, finishers: finishers, extras: extras }; }, decorateConstructor: function (elements, decorators) { var finishers = []; for (var i = decorators.length - 1; i >= 0; i--) { var obj = this.fromClassDescriptor(elements); var elementsAndFinisher = this.toClassDescriptor((0, decorators[i])(obj) || obj); if (elementsAndFinisher.finisher !== undefined) { finishers.push(elementsAndFinisher.finisher); } if (elementsAndFinisher.elements !== undefined) { elements = elementsAndFinisher.elements; for (var j = 0; j < elements.length - 1; j++) { for (var k = j + 1; k < elements.length; k++) { if (elements[j].key === elements[k].key && elements[j].placement === elements[k].placement) { throw new TypeError("Duplicated element (" + elements[j].key + ")"); } } } } } return { elements: elements, finishers: finishers }; }, fromElementDescriptor: function (element) { var obj = { kind: element.kind, key: element.key, placement: element.placement, descriptor: element.descriptor }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); if (element.kind === "field") obj.initializer = element.initializer; return obj; }, toElementDescriptors: function (elementObjects) { if (elementObjects === undefined) return; return _toArray(elementObjects).map(function (elementObject) { var element = this.toElementDescriptor(elementObject); this.disallowProperty(elementObject, "finisher", "An element descriptor"); this.disallowProperty(elementObject, "extras", "An element descriptor"); return element; }, this); }, toElementDescriptor: function (elementObject) { var kind = String(elementObject.kind); if (kind !== "method" && kind !== "field") { throw new TypeError('An element descriptor\'s .kind property must be either "method" or' + ' "field", but a decorator created an element descriptor with' + ' .kind "' + kind + '"'); } var key = _toPropertyKey(elementObject.key); var placement = String(elementObject.placement); if (placement !== "static" && placement !== "prototype" && placement !== "own") { throw new TypeError('An element descriptor\'s .placement property must be one of "static",' + ' "prototype" or "own", but a decorator created an element descriptor' + ' with .placement "' + placement + '"'); } var descriptor = elementObject.descriptor; this.disallowProperty(elementObject, "elements", "An element descriptor"); var element = { kind: kind, key: key, placement: placement, descriptor: Object.assign({}, descriptor) }; if (kind !== "field") { this.disallowProperty(elementObject, "initializer", "A method descriptor"); } else { this.disallowProperty(descriptor, "get", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "set", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "value", "The property descriptor of a field descriptor"); element.initializer = elementObject.initializer; } return element; }, toElementFinisherExtras: function (elementObject) { var element = this.toElementDescriptor(elementObject); var finisher = _optionalCallableProperty(elementObject, "finisher"); var extras = this.toElementDescriptors(elementObject.extras); return { element: element, finisher: finisher, extras: extras }; }, fromClassDescriptor: function (elements) { var obj = { kind: "class", elements: elements.map(this.fromElementDescriptor, this) }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); return obj; }, toClassDescriptor: function (obj) { var kind = String(obj.kind); if (kind !== "class") { throw new TypeError('A class descriptor\'s .kind property must be "class", but a decorator' + ' created a class descriptor with .kind "' + kind + '"'); } this.disallowProperty(obj, "key", "A class descriptor"); this.disallowProperty(obj, "placement", "A class descriptor"); this.disallowProperty(obj, "descriptor", "A class descriptor"); this.disallowProperty(obj, "initializer", "A class descriptor"); this.disallowProperty(obj, "extras", "A class descriptor"); var finisher = _optionalCallableProperty(obj, "finisher"); var elements = this.toElementDescriptors(obj.elements); return { elements: elements, finisher: finisher }; }, runClassFinishers: function (constructor, finishers) { for (var i = 0; i < finishers.length; i++) { var newConstructor = (0, finishers[i])(constructor); if (newConstructor !== undefined) { if (typeof newConstructor !== "function") { throw new TypeError("Finishers must return a constructor."); } constructor = newConstructor; } } return constructor; }, disallowProperty: function (obj, name, objectType) { if (obj[name] !== undefined) { throw new TypeError(objectType + " can't have a ." + name + " property."); } } }; return api; }

function _createElementDescriptor(def) { var key = _toPropertyKey(def.key); var descriptor; if (def.kind === "method") { descriptor = { value: def.value, writable: true, configurable: true, enumerable: false }; } else if (def.kind === "get") { descriptor = { get: def.value, configurable: true, enumerable: false }; } else if (def.kind === "set") { descriptor = { set: def.value, configurable: true, enumerable: false }; } else if (def.kind === "field") { descriptor = { configurable: true, writable: true, enumerable: true }; } var element = { kind: def.kind === "field" ? "field" : "method", key: key, placement: def.static ? "static" : def.kind === "field" ? "own" : "prototype", descriptor: descriptor }; if (def.decorators) element.decorators = def.decorators; if (def.kind === "field") element.initializer = def.value; return element; }

function _coalesceGetterSetter(element, other) { if (element.descriptor.get !== undefined) { other.descriptor.get = element.descriptor.get; } else { other.descriptor.set = element.descriptor.set; } }

function _coalesceClassElements(elements) { var newElements = []; var isSameElement = function (other) { return other.kind === "method" && other.key === element.key && other.placement === element.placement; }; for (var i = 0; i < elements.length; i++) { var element = elements[i]; var other; if (element.kind === "method" && (other = newElements.find(isSameElement))) { if (_isDataDescriptor(element.descriptor) || _isDataDescriptor(other.descriptor)) { if (_hasDecorators(element) || _hasDecorators(other)) { throw new ReferenceError("Duplicated methods (" + element.key + ") can't be decorated."); } other.descriptor = element.descriptor; } else { if (_hasDecorators(element)) { if (_hasDecorators(other)) { throw new ReferenceError("Decorators can't be placed on different accessors with for " + "the same property (" + element.key + ")."); } other.decorators = element.decorators; } _coalesceGetterSetter(element, other); } } else { newElements.push(element); } } return newElements; }

function _hasDecorators(element) { return element.decorators && element.decorators.length; }

function _isDataDescriptor(desc) { return desc !== undefined && !(desc.value === undefined && desc.writable === undefined); }

function _optionalCallableProperty(obj, name) { var value = obj[name]; if (value !== undefined && typeof value !== "function") { throw new TypeError("Expected '" + name + "' to be a function"); } return value; }

function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }

function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }

function _toArray(arr) { return _arrayWithHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(n); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }






let HaDeviceCardMqtt = _decorate([Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["customElement"])("ha-device-card-mqtt")], function (_initialize, _LitElement) {
  class HaDeviceCardMqtt extends _LitElement {
    constructor(...args) {
      super(...args);

      _initialize(this);
    }

  }

  return {
    F: HaDeviceCardMqtt,
    d: [{
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "hass",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "device",
      value: void 0
    }, {
      kind: "method",
      key: "render",
      value: function render() {
        return lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
      <mwc-button @click=${this._showDebugInfo}>
        MQTT Info
      </mwc-button>
      <mwc-button class="warning" @click="${this._confirmDeleteEntry}">
        ${this.hass.localize("ui.panel.config.devices.delete")}
      </mwc-button>
    `;
      }
    }, {
      kind: "method",
      key: "_confirmDeleteEntry",
      value: async function _confirmDeleteEntry() {
        const confirmed = await Object(_dialogs_generic_show_dialog_box__WEBPACK_IMPORTED_MODULE_2__["showConfirmationDialog"])(this, {
          text: this.hass.localize("ui.panel.config.devices.confirm_delete")
        });

        if (!confirmed) {
          return;
        }

        await Object(_data_mqtt__WEBPACK_IMPORTED_MODULE_1__["removeMQTTDeviceEntry"])(this.hass, this.device.id);
      }
    }, {
      kind: "method",
      key: "_showDebugInfo",
      value: async function _showDebugInfo() {
        const device = this.device;
        await Object(_dialogs_mqtt_device_debug_info_dialog_show_dialog_mqtt_device_debug_info__WEBPACK_IMPORTED_MODULE_3__["showMQTTDeviceDebugInfoDialog"])(this, {
          device
        });
      }
    }, {
      kind: "get",
      static: true,
      key: "styles",
      value: function styles() {
        return _resources_styles__WEBPACK_IMPORTED_MODULE_4__["haStyle"];
      }
    }]
  };
}, lit_element__WEBPACK_IMPORTED_MODULE_0__["LitElement"]);

/***/ }),

/***/ "./src/panels/config/devices/device-detail/ha-device-entities-card.ts":
/*!****************************************************************************!*\
  !*** ./src/panels/config/devices/device-detail/ha-device-entities-card.ts ***!
  \****************************************************************************/
/*! exports provided: HaDeviceEntitiesCard */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HaDeviceEntitiesCard", function() { return HaDeviceEntitiesCard; });
/* harmony import */ var _polymer_paper_item_paper_icon_item__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @polymer/paper-item/paper-icon-item */ "./node_modules/@polymer/paper-item/paper-icon-item.js");
/* harmony import */ var _polymer_paper_item_paper_item__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @polymer/paper-item/paper-item */ "./node_modules/@polymer/paper-item/paper-item.js");
/* harmony import */ var _polymer_paper_item_paper_item_body__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @polymer/paper-item/paper-item-body */ "./node_modules/@polymer/paper-item/paper-item-body.js");
/* harmony import */ var lit_element__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lit-element */ "./node_modules/lit-element/lit-element.js");
/* harmony import */ var _common_entity_compute_domain__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../../common/entity/compute_domain */ "./src/common/entity/compute_domain.ts");
/* harmony import */ var _common_entity_domain_icon__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../../common/entity/domain_icon */ "./src/common/entity/domain_icon.ts");
/* harmony import */ var _components_entity_state_badge__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../../components/entity/state-badge */ "./src/components/entity/state-badge.ts");
/* harmony import */ var _components_ha_card__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../../components/ha-card */ "./src/components/ha-card.ts");
/* harmony import */ var _components_ha_icon__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../../components/ha-icon */ "./src/components/ha-icon.ts");
/* harmony import */ var _lovelace_create_element_create_row_element__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../../lovelace/create-element/create-row-element */ "./src/panels/lovelace/create-element/create-row-element.ts");
/* harmony import */ var _lovelace_editor_add_entities_to_view__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../../lovelace/editor/add-entities-to-view */ "./src/panels/lovelace/editor/add-entities-to-view.ts");
/* harmony import */ var _entities_show_dialog_entity_editor__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../entities/show-dialog-entity-editor */ "./src/panels/config/entities/show-dialog-entity-editor.ts");
function _decorate(decorators, factory, superClass, mixins) { var api = _getDecoratorsApi(); if (mixins) { for (var i = 0; i < mixins.length; i++) { api = mixins[i](api); } } var r = factory(function initialize(O) { api.initializeInstanceElements(O, decorated.elements); }, superClass); var decorated = api.decorateClass(_coalesceClassElements(r.d.map(_createElementDescriptor)), decorators); api.initializeClassElements(r.F, decorated.elements); return api.runClassFinishers(r.F, decorated.finishers); }

function _getDecoratorsApi() { _getDecoratorsApi = function () { return api; }; var api = { elementsDefinitionOrder: [["method"], ["field"]], initializeInstanceElements: function (O, elements) { ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { if (element.kind === kind && element.placement === "own") { this.defineClassElement(O, element); } }, this); }, this); }, initializeClassElements: function (F, elements) { var proto = F.prototype; ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { var placement = element.placement; if (element.kind === kind && (placement === "static" || placement === "prototype")) { var receiver = placement === "static" ? F : proto; this.defineClassElement(receiver, element); } }, this); }, this); }, defineClassElement: function (receiver, element) { var descriptor = element.descriptor; if (element.kind === "field") { var initializer = element.initializer; descriptor = { enumerable: descriptor.enumerable, writable: descriptor.writable, configurable: descriptor.configurable, value: initializer === void 0 ? void 0 : initializer.call(receiver) }; } Object.defineProperty(receiver, element.key, descriptor); }, decorateClass: function (elements, decorators) { var newElements = []; var finishers = []; var placements = { static: [], prototype: [], own: [] }; elements.forEach(function (element) { this.addElementPlacement(element, placements); }, this); elements.forEach(function (element) { if (!_hasDecorators(element)) return newElements.push(element); var elementFinishersExtras = this.decorateElement(element, placements); newElements.push(elementFinishersExtras.element); newElements.push.apply(newElements, elementFinishersExtras.extras); finishers.push.apply(finishers, elementFinishersExtras.finishers); }, this); if (!decorators) { return { elements: newElements, finishers: finishers }; } var result = this.decorateConstructor(newElements, decorators); finishers.push.apply(finishers, result.finishers); result.finishers = finishers; return result; }, addElementPlacement: function (element, placements, silent) { var keys = placements[element.placement]; if (!silent && keys.indexOf(element.key) !== -1) { throw new TypeError("Duplicated element (" + element.key + ")"); } keys.push(element.key); }, decorateElement: function (element, placements) { var extras = []; var finishers = []; for (var decorators = element.decorators, i = decorators.length - 1; i >= 0; i--) { var keys = placements[element.placement]; keys.splice(keys.indexOf(element.key), 1); var elementObject = this.fromElementDescriptor(element); var elementFinisherExtras = this.toElementFinisherExtras((0, decorators[i])(elementObject) || elementObject); element = elementFinisherExtras.element; this.addElementPlacement(element, placements); if (elementFinisherExtras.finisher) { finishers.push(elementFinisherExtras.finisher); } var newExtras = elementFinisherExtras.extras; if (newExtras) { for (var j = 0; j < newExtras.length; j++) { this.addElementPlacement(newExtras[j], placements); } extras.push.apply(extras, newExtras); } } return { element: element, finishers: finishers, extras: extras }; }, decorateConstructor: function (elements, decorators) { var finishers = []; for (var i = decorators.length - 1; i >= 0; i--) { var obj = this.fromClassDescriptor(elements); var elementsAndFinisher = this.toClassDescriptor((0, decorators[i])(obj) || obj); if (elementsAndFinisher.finisher !== undefined) { finishers.push(elementsAndFinisher.finisher); } if (elementsAndFinisher.elements !== undefined) { elements = elementsAndFinisher.elements; for (var j = 0; j < elements.length - 1; j++) { for (var k = j + 1; k < elements.length; k++) { if (elements[j].key === elements[k].key && elements[j].placement === elements[k].placement) { throw new TypeError("Duplicated element (" + elements[j].key + ")"); } } } } } return { elements: elements, finishers: finishers }; }, fromElementDescriptor: function (element) { var obj = { kind: element.kind, key: element.key, placement: element.placement, descriptor: element.descriptor }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); if (element.kind === "field") obj.initializer = element.initializer; return obj; }, toElementDescriptors: function (elementObjects) { if (elementObjects === undefined) return; return _toArray(elementObjects).map(function (elementObject) { var element = this.toElementDescriptor(elementObject); this.disallowProperty(elementObject, "finisher", "An element descriptor"); this.disallowProperty(elementObject, "extras", "An element descriptor"); return element; }, this); }, toElementDescriptor: function (elementObject) { var kind = String(elementObject.kind); if (kind !== "method" && kind !== "field") { throw new TypeError('An element descriptor\'s .kind property must be either "method" or' + ' "field", but a decorator created an element descriptor with' + ' .kind "' + kind + '"'); } var key = _toPropertyKey(elementObject.key); var placement = String(elementObject.placement); if (placement !== "static" && placement !== "prototype" && placement !== "own") { throw new TypeError('An element descriptor\'s .placement property must be one of "static",' + ' "prototype" or "own", but a decorator created an element descriptor' + ' with .placement "' + placement + '"'); } var descriptor = elementObject.descriptor; this.disallowProperty(elementObject, "elements", "An element descriptor"); var element = { kind: kind, key: key, placement: placement, descriptor: Object.assign({}, descriptor) }; if (kind !== "field") { this.disallowProperty(elementObject, "initializer", "A method descriptor"); } else { this.disallowProperty(descriptor, "get", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "set", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "value", "The property descriptor of a field descriptor"); element.initializer = elementObject.initializer; } return element; }, toElementFinisherExtras: function (elementObject) { var element = this.toElementDescriptor(elementObject); var finisher = _optionalCallableProperty(elementObject, "finisher"); var extras = this.toElementDescriptors(elementObject.extras); return { element: element, finisher: finisher, extras: extras }; }, fromClassDescriptor: function (elements) { var obj = { kind: "class", elements: elements.map(this.fromElementDescriptor, this) }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); return obj; }, toClassDescriptor: function (obj) { var kind = String(obj.kind); if (kind !== "class") { throw new TypeError('A class descriptor\'s .kind property must be "class", but a decorator' + ' created a class descriptor with .kind "' + kind + '"'); } this.disallowProperty(obj, "key", "A class descriptor"); this.disallowProperty(obj, "placement", "A class descriptor"); this.disallowProperty(obj, "descriptor", "A class descriptor"); this.disallowProperty(obj, "initializer", "A class descriptor"); this.disallowProperty(obj, "extras", "A class descriptor"); var finisher = _optionalCallableProperty(obj, "finisher"); var elements = this.toElementDescriptors(obj.elements); return { elements: elements, finisher: finisher }; }, runClassFinishers: function (constructor, finishers) { for (var i = 0; i < finishers.length; i++) { var newConstructor = (0, finishers[i])(constructor); if (newConstructor !== undefined) { if (typeof newConstructor !== "function") { throw new TypeError("Finishers must return a constructor."); } constructor = newConstructor; } } return constructor; }, disallowProperty: function (obj, name, objectType) { if (obj[name] !== undefined) { throw new TypeError(objectType + " can't have a ." + name + " property."); } } }; return api; }

function _createElementDescriptor(def) { var key = _toPropertyKey(def.key); var descriptor; if (def.kind === "method") { descriptor = { value: def.value, writable: true, configurable: true, enumerable: false }; } else if (def.kind === "get") { descriptor = { get: def.value, configurable: true, enumerable: false }; } else if (def.kind === "set") { descriptor = { set: def.value, configurable: true, enumerable: false }; } else if (def.kind === "field") { descriptor = { configurable: true, writable: true, enumerable: true }; } var element = { kind: def.kind === "field" ? "field" : "method", key: key, placement: def.static ? "static" : def.kind === "field" ? "own" : "prototype", descriptor: descriptor }; if (def.decorators) element.decorators = def.decorators; if (def.kind === "field") element.initializer = def.value; return element; }

function _coalesceGetterSetter(element, other) { if (element.descriptor.get !== undefined) { other.descriptor.get = element.descriptor.get; } else { other.descriptor.set = element.descriptor.set; } }

function _coalesceClassElements(elements) { var newElements = []; var isSameElement = function (other) { return other.kind === "method" && other.key === element.key && other.placement === element.placement; }; for (var i = 0; i < elements.length; i++) { var element = elements[i]; var other; if (element.kind === "method" && (other = newElements.find(isSameElement))) { if (_isDataDescriptor(element.descriptor) || _isDataDescriptor(other.descriptor)) { if (_hasDecorators(element) || _hasDecorators(other)) { throw new ReferenceError("Duplicated methods (" + element.key + ") can't be decorated."); } other.descriptor = element.descriptor; } else { if (_hasDecorators(element)) { if (_hasDecorators(other)) { throw new ReferenceError("Decorators can't be placed on different accessors with for " + "the same property (" + element.key + ")."); } other.decorators = element.decorators; } _coalesceGetterSetter(element, other); } } else { newElements.push(element); } } return newElements; }

function _hasDecorators(element) { return element.decorators && element.decorators.length; }

function _isDataDescriptor(desc) { return desc !== undefined && !(desc.value === undefined && desc.writable === undefined); }

function _optionalCallableProperty(obj, name) { var value = obj[name]; if (value !== undefined && typeof value !== "function") { throw new TypeError("Expected '" + name + "' to be a function"); } return value; }

function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }

function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }

function _toArray(arr) { return _arrayWithHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(n); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }













let HaDeviceEntitiesCard = _decorate([Object(lit_element__WEBPACK_IMPORTED_MODULE_3__["customElement"])("ha-device-entities-card")], function (_initialize, _LitElement) {
  class HaDeviceEntitiesCard extends _LitElement {
    constructor(...args) {
      super(...args);

      _initialize(this);
    }

  }

  return {
    F: HaDeviceEntitiesCard,
    d: [{
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_3__["property"])()],
      key: "hass",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_3__["property"])()],
      key: "entities",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_3__["property"])()],
      key: "_showDisabled",

      value() {
        return false;
      }

    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_3__["queryAll"])("#entities > *")],
      key: "_entityRows",
      value: void 0
    }, {
      kind: "method",
      key: "shouldUpdate",
      value: function shouldUpdate(changedProps) {
        if (changedProps.has("hass")) {
          var _this$_entityRows;

          (_this$_entityRows = this._entityRows) === null || _this$_entityRows === void 0 ? void 0 : _this$_entityRows.forEach(element => {
            element.hass = this.hass;
          });
          return changedProps.size > 1;
        }

        return true;
      }
    }, {
      kind: "method",
      key: "render",
      value: function render() {
        const disabledEntities = [];
        return lit_element__WEBPACK_IMPORTED_MODULE_3__["html"]`
      <ha-card
        .header=${this.hass.localize("ui.panel.config.devices.entities.entities")}
      >
        ${this.entities.length ? lit_element__WEBPACK_IMPORTED_MODULE_3__["html"]`
              <div id="entities">
                ${this.entities.map(entry => {
          if (entry.disabled_by) {
            disabledEntities.push(entry);
            return "";
          }

          return this.hass.states[entry.entity_id] ? this._renderEntity(entry) : this._renderEntry(entry);
        })}
              </div>
              ${disabledEntities.length ? !this._showDisabled ? lit_element__WEBPACK_IMPORTED_MODULE_3__["html"]`
                      <button
                        class="show-more"
                        @click=${this._toggleShowDisabled}
                      >
                        +${disabledEntities.length} disabled entities
                      </button>
                    ` : lit_element__WEBPACK_IMPORTED_MODULE_3__["html"]`
                      ${disabledEntities.map(entry => this._renderEntry(entry))}
                      <button
                        class="show-more"
                        @click=${this._toggleShowDisabled}
                      >
                        Hide disabled
                      </button>
                    ` : ""}
              <div class="card-actions">
                <mwc-button @click=${this._addToLovelaceView}>
                  ${this.hass.localize("ui.panel.config.devices.entities.add_entities_lovelace")}
                </mwc-button>
              </div>
            ` : lit_element__WEBPACK_IMPORTED_MODULE_3__["html"]`
              <div class="config-entry-row">
                <paper-item-body two-line>
                  <div>
                    ${this.hass.localize("ui.panel.config.devices.entities.none")}
                  </div>
                </paper-item-body>
              </div>
            `}
      </ha-card>
    `;
      }
    }, {
      kind: "method",
      key: "_toggleShowDisabled",
      value: function _toggleShowDisabled() {
        this._showDisabled = !this._showDisabled;
      }
    }, {
      kind: "method",
      key: "_renderEntity",
      value: function _renderEntity(entry) {
        const element = Object(_lovelace_create_element_create_row_element__WEBPACK_IMPORTED_MODULE_9__["createRowElement"])({
          entity: entry.entity_id
        });

        if (this.hass) {
          element.hass = this.hass;
        } // @ts-ignore


        element.entry = entry;
        element.addEventListener("hass-more-info", ev => this._openEditEntry(ev));
        return lit_element__WEBPACK_IMPORTED_MODULE_3__["html"]` <div>${element}</div> `;
      }
    }, {
      kind: "method",
      key: "_renderEntry",
      value: function _renderEntry(entry) {
        return lit_element__WEBPACK_IMPORTED_MODULE_3__["html"]`
      <paper-icon-item .entry=${entry} @click=${this._openEditEntry}>
        <ha-icon
          slot="item-icon"
          .icon=${Object(_common_entity_domain_icon__WEBPACK_IMPORTED_MODULE_5__["domainIcon"])(Object(_common_entity_compute_domain__WEBPACK_IMPORTED_MODULE_4__["computeDomain"])(entry.entity_id))}
        ></ha-icon>
        <paper-item-body>
          <div class="name">
            ${entry.stateName || entry.entity_id}
          </div>
        </paper-item-body>
      </paper-icon-item>
    `;
      }
    }, {
      kind: "method",
      key: "_openEditEntry",
      value: function _openEditEntry(ev) {
        ev.stopPropagation();
        const entry = ev.currentTarget.entry;
        Object(_entities_show_dialog_entity_editor__WEBPACK_IMPORTED_MODULE_11__["showEntityEditorDialog"])(this, {
          entry,
          entity_id: entry.entity_id
        });
      }
    }, {
      kind: "method",
      key: "_addToLovelaceView",
      value: function _addToLovelaceView() {
        Object(_lovelace_editor_add_entities_to_view__WEBPACK_IMPORTED_MODULE_10__["addEntitiesToLovelaceView"])(this, this.hass, this.entities.filter(entity => !entity.disabled_by).map(entity => entity.entity_id));
      }
    }, {
      kind: "get",
      static: true,
      key: "styles",
      value: function styles() {
        return lit_element__WEBPACK_IMPORTED_MODULE_3__["css"]`
      :host {
        display: block;
      }
      ha-icon {
        width: 40px;
      }
      .entity-id {
        color: var(--secondary-text-color);
      }
      .buttons {
        text-align: right;
        margin: 0 0 0 8px;
      }
      .disabled-entry {
        color: var(--secondary-text-color);
      }
      #entities > * {
        margin: 8px 16px 8px 8px;
      }
      #entities > paper-icon-item {
        margin: 0;
      }
      paper-icon-item {
        min-height: 40px;
        padding: 0 8px;
        cursor: pointer;
      }
      .name {
        font-size: 14px;
      }
      button.show-more {
        color: var(--primary-color);
        text-align: left;
        cursor: pointer;
        background: none;
        border-width: initial;
        border-style: none;
        border-color: initial;
        border-image: initial;
        padding: 16px;
        font: inherit;
      }
      button.show-more:focus {
        outline: none;
        text-decoration: underline;
      }
    `;
      }
    }]
  };
}, lit_element__WEBPACK_IMPORTED_MODULE_3__["LitElement"]);

/***/ }),

/***/ "./src/panels/config/devices/device-detail/ha-device-info-card.ts":
/*!************************************************************************!*\
  !*** ./src/panels/config/devices/device-detail/ha-device-info-card.ts ***!
  \************************************************************************/
/*! exports provided: HaDeviceCard */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HaDeviceCard", function() { return HaDeviceCard; });
/* harmony import */ var lit_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lit-element */ "./node_modules/lit-element/lit-element.js");
/* harmony import */ var _data_device_registry__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../data/device_registry */ "./src/data/device_registry.ts");
/* harmony import */ var _dialogs_device_registry_detail_show_dialog_device_registry_detail__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../dialogs/device-registry-detail/show-dialog-device-registry-detail */ "./src/dialogs/device-registry-detail/show-dialog-device-registry-detail.ts");
function _decorate(decorators, factory, superClass, mixins) { var api = _getDecoratorsApi(); if (mixins) { for (var i = 0; i < mixins.length; i++) { api = mixins[i](api); } } var r = factory(function initialize(O) { api.initializeInstanceElements(O, decorated.elements); }, superClass); var decorated = api.decorateClass(_coalesceClassElements(r.d.map(_createElementDescriptor)), decorators); api.initializeClassElements(r.F, decorated.elements); return api.runClassFinishers(r.F, decorated.finishers); }

function _getDecoratorsApi() { _getDecoratorsApi = function () { return api; }; var api = { elementsDefinitionOrder: [["method"], ["field"]], initializeInstanceElements: function (O, elements) { ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { if (element.kind === kind && element.placement === "own") { this.defineClassElement(O, element); } }, this); }, this); }, initializeClassElements: function (F, elements) { var proto = F.prototype; ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { var placement = element.placement; if (element.kind === kind && (placement === "static" || placement === "prototype")) { var receiver = placement === "static" ? F : proto; this.defineClassElement(receiver, element); } }, this); }, this); }, defineClassElement: function (receiver, element) { var descriptor = element.descriptor; if (element.kind === "field") { var initializer = element.initializer; descriptor = { enumerable: descriptor.enumerable, writable: descriptor.writable, configurable: descriptor.configurable, value: initializer === void 0 ? void 0 : initializer.call(receiver) }; } Object.defineProperty(receiver, element.key, descriptor); }, decorateClass: function (elements, decorators) { var newElements = []; var finishers = []; var placements = { static: [], prototype: [], own: [] }; elements.forEach(function (element) { this.addElementPlacement(element, placements); }, this); elements.forEach(function (element) { if (!_hasDecorators(element)) return newElements.push(element); var elementFinishersExtras = this.decorateElement(element, placements); newElements.push(elementFinishersExtras.element); newElements.push.apply(newElements, elementFinishersExtras.extras); finishers.push.apply(finishers, elementFinishersExtras.finishers); }, this); if (!decorators) { return { elements: newElements, finishers: finishers }; } var result = this.decorateConstructor(newElements, decorators); finishers.push.apply(finishers, result.finishers); result.finishers = finishers; return result; }, addElementPlacement: function (element, placements, silent) { var keys = placements[element.placement]; if (!silent && keys.indexOf(element.key) !== -1) { throw new TypeError("Duplicated element (" + element.key + ")"); } keys.push(element.key); }, decorateElement: function (element, placements) { var extras = []; var finishers = []; for (var decorators = element.decorators, i = decorators.length - 1; i >= 0; i--) { var keys = placements[element.placement]; keys.splice(keys.indexOf(element.key), 1); var elementObject = this.fromElementDescriptor(element); var elementFinisherExtras = this.toElementFinisherExtras((0, decorators[i])(elementObject) || elementObject); element = elementFinisherExtras.element; this.addElementPlacement(element, placements); if (elementFinisherExtras.finisher) { finishers.push(elementFinisherExtras.finisher); } var newExtras = elementFinisherExtras.extras; if (newExtras) { for (var j = 0; j < newExtras.length; j++) { this.addElementPlacement(newExtras[j], placements); } extras.push.apply(extras, newExtras); } } return { element: element, finishers: finishers, extras: extras }; }, decorateConstructor: function (elements, decorators) { var finishers = []; for (var i = decorators.length - 1; i >= 0; i--) { var obj = this.fromClassDescriptor(elements); var elementsAndFinisher = this.toClassDescriptor((0, decorators[i])(obj) || obj); if (elementsAndFinisher.finisher !== undefined) { finishers.push(elementsAndFinisher.finisher); } if (elementsAndFinisher.elements !== undefined) { elements = elementsAndFinisher.elements; for (var j = 0; j < elements.length - 1; j++) { for (var k = j + 1; k < elements.length; k++) { if (elements[j].key === elements[k].key && elements[j].placement === elements[k].placement) { throw new TypeError("Duplicated element (" + elements[j].key + ")"); } } } } } return { elements: elements, finishers: finishers }; }, fromElementDescriptor: function (element) { var obj = { kind: element.kind, key: element.key, placement: element.placement, descriptor: element.descriptor }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); if (element.kind === "field") obj.initializer = element.initializer; return obj; }, toElementDescriptors: function (elementObjects) { if (elementObjects === undefined) return; return _toArray(elementObjects).map(function (elementObject) { var element = this.toElementDescriptor(elementObject); this.disallowProperty(elementObject, "finisher", "An element descriptor"); this.disallowProperty(elementObject, "extras", "An element descriptor"); return element; }, this); }, toElementDescriptor: function (elementObject) { var kind = String(elementObject.kind); if (kind !== "method" && kind !== "field") { throw new TypeError('An element descriptor\'s .kind property must be either "method" or' + ' "field", but a decorator created an element descriptor with' + ' .kind "' + kind + '"'); } var key = _toPropertyKey(elementObject.key); var placement = String(elementObject.placement); if (placement !== "static" && placement !== "prototype" && placement !== "own") { throw new TypeError('An element descriptor\'s .placement property must be one of "static",' + ' "prototype" or "own", but a decorator created an element descriptor' + ' with .placement "' + placement + '"'); } var descriptor = elementObject.descriptor; this.disallowProperty(elementObject, "elements", "An element descriptor"); var element = { kind: kind, key: key, placement: placement, descriptor: Object.assign({}, descriptor) }; if (kind !== "field") { this.disallowProperty(elementObject, "initializer", "A method descriptor"); } else { this.disallowProperty(descriptor, "get", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "set", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "value", "The property descriptor of a field descriptor"); element.initializer = elementObject.initializer; } return element; }, toElementFinisherExtras: function (elementObject) { var element = this.toElementDescriptor(elementObject); var finisher = _optionalCallableProperty(elementObject, "finisher"); var extras = this.toElementDescriptors(elementObject.extras); return { element: element, finisher: finisher, extras: extras }; }, fromClassDescriptor: function (elements) { var obj = { kind: "class", elements: elements.map(this.fromElementDescriptor, this) }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); return obj; }, toClassDescriptor: function (obj) { var kind = String(obj.kind); if (kind !== "class") { throw new TypeError('A class descriptor\'s .kind property must be "class", but a decorator' + ' created a class descriptor with .kind "' + kind + '"'); } this.disallowProperty(obj, "key", "A class descriptor"); this.disallowProperty(obj, "placement", "A class descriptor"); this.disallowProperty(obj, "descriptor", "A class descriptor"); this.disallowProperty(obj, "initializer", "A class descriptor"); this.disallowProperty(obj, "extras", "A class descriptor"); var finisher = _optionalCallableProperty(obj, "finisher"); var elements = this.toElementDescriptors(obj.elements); return { elements: elements, finisher: finisher }; }, runClassFinishers: function (constructor, finishers) { for (var i = 0; i < finishers.length; i++) { var newConstructor = (0, finishers[i])(constructor); if (newConstructor !== undefined) { if (typeof newConstructor !== "function") { throw new TypeError("Finishers must return a constructor."); } constructor = newConstructor; } } return constructor; }, disallowProperty: function (obj, name, objectType) { if (obj[name] !== undefined) { throw new TypeError(objectType + " can't have a ." + name + " property."); } } }; return api; }

function _createElementDescriptor(def) { var key = _toPropertyKey(def.key); var descriptor; if (def.kind === "method") { descriptor = { value: def.value, writable: true, configurable: true, enumerable: false }; } else if (def.kind === "get") { descriptor = { get: def.value, configurable: true, enumerable: false }; } else if (def.kind === "set") { descriptor = { set: def.value, configurable: true, enumerable: false }; } else if (def.kind === "field") { descriptor = { configurable: true, writable: true, enumerable: true }; } var element = { kind: def.kind === "field" ? "field" : "method", key: key, placement: def.static ? "static" : def.kind === "field" ? "own" : "prototype", descriptor: descriptor }; if (def.decorators) element.decorators = def.decorators; if (def.kind === "field") element.initializer = def.value; return element; }

function _coalesceGetterSetter(element, other) { if (element.descriptor.get !== undefined) { other.descriptor.get = element.descriptor.get; } else { other.descriptor.set = element.descriptor.set; } }

function _coalesceClassElements(elements) { var newElements = []; var isSameElement = function (other) { return other.kind === "method" && other.key === element.key && other.placement === element.placement; }; for (var i = 0; i < elements.length; i++) { var element = elements[i]; var other; if (element.kind === "method" && (other = newElements.find(isSameElement))) { if (_isDataDescriptor(element.descriptor) || _isDataDescriptor(other.descriptor)) { if (_hasDecorators(element) || _hasDecorators(other)) { throw new ReferenceError("Duplicated methods (" + element.key + ") can't be decorated."); } other.descriptor = element.descriptor; } else { if (_hasDecorators(element)) { if (_hasDecorators(other)) { throw new ReferenceError("Decorators can't be placed on different accessors with for " + "the same property (" + element.key + ")."); } other.decorators = element.decorators; } _coalesceGetterSetter(element, other); } } else { newElements.push(element); } } return newElements; }

function _hasDecorators(element) { return element.decorators && element.decorators.length; }

function _isDataDescriptor(desc) { return desc !== undefined && !(desc.value === undefined && desc.writable === undefined); }

function _optionalCallableProperty(obj, name) { var value = obj[name]; if (value !== undefined && typeof value !== "function") { throw new TypeError("Expected '" + name + "' to be a function"); } return value; }

function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }

function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }

function _toArray(arr) { return _arrayWithHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(n); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get; } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return _get(target, property, receiver || target); }

function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }




let HaDeviceCard = _decorate([Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["customElement"])("ha-device-info-card")], function (_initialize, _LitElement) {
  class HaDeviceCard extends _LitElement {
    constructor(...args) {
      super(...args);

      _initialize(this);
    }

  }

  return {
    F: HaDeviceCard,
    d: [{
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "hass",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "device",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "devices",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "areas",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "narrow",
      value: void 0
    }, {
      kind: "method",
      key: "render",
      value: function render() {
        return lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
      <ha-card header="Device info">
        <div class="card-content">
          ${this.device.model ? lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]` <div class="model">${this.device.model}</div> ` : ""}
          ${this.device.manufacturer ? lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
                <div class="manuf">
                  ${this.hass.localize("ui.panel.config.integrations.config_entry.manuf", "manufacturer", this.device.manufacturer)}
                </div>
              ` : ""}
          ${this.device.via_device_id ? lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
                <div class="extra-info">
                  ${this.hass.localize("ui.panel.config.integrations.config_entry.via")}
                  <span class="hub"
                    >${this._computeDeviceName(this.devices, this.device.via_device_id)}</span
                  >
                </div>
              ` : ""}
          ${this.device.sw_version ? lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
                <div class="extra-info">
                  ${this.hass.localize("ui.panel.config.integrations.config_entry.firmware", "version", this.device.sw_version)}
                </div>
              ` : ""}
          <slot></slot>
        </div>
      </ha-card>
    `;
      }
    }, {
      kind: "method",
      key: "firstUpdated",
      value: function firstUpdated(changedProps) {
        _get(_getPrototypeOf(HaDeviceCard.prototype), "firstUpdated", this).call(this, changedProps);

        Object(_dialogs_device_registry_detail_show_dialog_device_registry_detail__WEBPACK_IMPORTED_MODULE_2__["loadDeviceRegistryDetailDialog"])();
      }
    }, {
      kind: "method",
      key: "_computeDeviceName",
      value: function _computeDeviceName(devices, deviceId) {
        const device = devices.find(dev => dev.id === deviceId);
        return device ? Object(_data_device_registry__WEBPACK_IMPORTED_MODULE_1__["computeDeviceName"])(device, this.hass) : `(${this.hass.localize("ui.panel.config.integrations.config_entry.device_unavailable")})`;
      }
    }, {
      kind: "get",
      static: true,
      key: "styles",
      value: function styles() {
        return lit_element__WEBPACK_IMPORTED_MODULE_0__["css"]`
      :host {
        display: block;
      }
      ha-card {
        flex: 1 0 100%;
        padding-bottom: 10px;
        min-width: 0;
      }
      .device {
        width: 30%;
      }
      .area {
        color: var(--primary-text-color);
      }
      .extra-info {
        margin-top: 8px;
      }
      .manuf,
      .entity-id,
      .model {
        color: var(--secondary-text-color);
      }
    `;
      }
    }]
  };
}, lit_element__WEBPACK_IMPORTED_MODULE_0__["LitElement"]);

/***/ }),

/***/ "./src/panels/config/devices/device-detail/show-dialog-device-automation.ts":
/*!**********************************************************************************!*\
  !*** ./src/panels/config/devices/device-detail/show-dialog-device-automation.ts ***!
  \**********************************************************************************/
/*! exports provided: loadDeviceAutomationDialog, showDeviceAutomationDialog */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "loadDeviceAutomationDialog", function() { return loadDeviceAutomationDialog; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "showDeviceAutomationDialog", function() { return showDeviceAutomationDialog; });
/* harmony import */ var _common_dom_fire_event__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../common/dom/fire_event */ "./src/common/dom/fire_event.ts");

const loadDeviceAutomationDialog = () => Promise.all(/*! import() | device-automation-dialog */[__webpack_require__.e("vendors~add-user-dialog~device-automation-dialog~dialog-mqtt-device-debug-info~dialog-zha-device-zig~61d72af3"), __webpack_require__.e("vendors~device-automation-dialog"), __webpack_require__.e("add-user-dialog~device-automation-dialog~dialog-mqtt-device-debug-info~dialog-zha-device-zigbee-info~af4b98d6"), __webpack_require__.e("device-automation-dialog")]).then(__webpack_require__.bind(null, /*! ./ha-device-automation-dialog */ "./src/panels/config/devices/device-detail/ha-device-automation-dialog.ts"));
const showDeviceAutomationDialog = (element, detailParams) => {
  Object(_common_dom_fire_event__WEBPACK_IMPORTED_MODULE_0__["fireEvent"])(element, "show-dialog", {
    dialogTag: "dialog-device-automation",
    dialogImport: loadDeviceAutomationDialog,
    dialogParams: detailParams
  });
};

/***/ }),

/***/ "./src/panels/config/devices/ha-config-device-page.ts":
/*!************************************************************!*\
  !*** ./src/panels/config/devices/ha-config-device-page.ts ***!
  \************************************************************/
/*! exports provided: HaConfigDevicePage */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HaConfigDevicePage", function() { return HaConfigDevicePage; });
/* harmony import */ var _polymer_paper_tooltip_paper_tooltip__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @polymer/paper-tooltip/paper-tooltip */ "./node_modules/@polymer/paper-tooltip/paper-tooltip.js");
/* harmony import */ var lit_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lit-element */ "./node_modules/lit-element/lit-element.js");
/* harmony import */ var lit_html_directives_if_defined__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lit-html/directives/if-defined */ "./node_modules/lit-html/directives/if-defined.js");
/* harmony import */ var memoize_one__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! memoize-one */ "./node_modules/memoize-one/dist/memoize-one.esm.js");
/* harmony import */ var _common_config_is_component_loaded__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../common/config/is_component_loaded */ "./src/common/config/is_component_loaded.ts");
/* harmony import */ var _common_entity_compute_state_name__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../common/entity/compute_state_name */ "./src/common/entity/compute_state_name.ts");
/* harmony import */ var _common_entity_valid_entity_id__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../common/entity/valid_entity_id */ "./src/common/entity/valid_entity_id.ts");
/* harmony import */ var _common_string_compare__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../common/string/compare */ "./src/common/string/compare.ts");
/* harmony import */ var _components_entity_ha_state_icon__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../components/entity/ha-state-icon */ "./src/components/entity/ha-state-icon.js");
/* harmony import */ var _components_ha_icon_next__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../../components/ha-icon-next */ "./src/components/ha-icon-next.ts");
/* harmony import */ var _data_device_registry__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../../data/device_registry */ "./src/data/device_registry.ts");
/* harmony import */ var _data_entity_registry__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../../data/entity_registry */ "./src/data/entity_registry.ts");
/* harmony import */ var _data_scene__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../../data/scene */ "./src/data/scene.ts");
/* harmony import */ var _data_search__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../../data/search */ "./src/data/search.ts");
/* harmony import */ var _dialogs_device_registry_detail_show_dialog_device_registry_detail__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../../dialogs/device-registry-detail/show-dialog-device-registry-detail */ "./src/dialogs/device-registry-detail/show-dialog-device-registry-detail.ts");
/* harmony import */ var _layouts_hass_error_screen__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../../layouts/hass-error-screen */ "./src/layouts/hass-error-screen.ts");
/* harmony import */ var _layouts_hass_tabs_subpage__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../../layouts/hass-tabs-subpage */ "./src/layouts/hass-tabs-subpage.ts");
/* harmony import */ var _ha_config_section__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../ha-config-section */ "./src/panels/config/ha-config-section.ts");
/* harmony import */ var _ha_panel_config__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../ha-panel-config */ "./src/panels/config/ha-panel-config.ts");
/* harmony import */ var _device_detail_ha_device_card_mqtt__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./device-detail/ha-device-card-mqtt */ "./src/panels/config/devices/device-detail/ha-device-card-mqtt.ts");
/* harmony import */ var _device_detail_ha_device_entities_card__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./device-detail/ha-device-entities-card */ "./src/panels/config/devices/device-detail/ha-device-entities-card.ts");
/* harmony import */ var _device_detail_ha_device_info_card__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./device-detail/ha-device-info-card */ "./src/panels/config/devices/device-detail/ha-device-info-card.ts");
/* harmony import */ var _device_detail_show_dialog_device_automation__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./device-detail/show-dialog-device-automation */ "./src/panels/config/devices/device-detail/show-dialog-device-automation.ts");
function _decorate(decorators, factory, superClass, mixins) { var api = _getDecoratorsApi(); if (mixins) { for (var i = 0; i < mixins.length; i++) { api = mixins[i](api); } } var r = factory(function initialize(O) { api.initializeInstanceElements(O, decorated.elements); }, superClass); var decorated = api.decorateClass(_coalesceClassElements(r.d.map(_createElementDescriptor)), decorators); api.initializeClassElements(r.F, decorated.elements); return api.runClassFinishers(r.F, decorated.finishers); }

function _getDecoratorsApi() { _getDecoratorsApi = function () { return api; }; var api = { elementsDefinitionOrder: [["method"], ["field"]], initializeInstanceElements: function (O, elements) { ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { if (element.kind === kind && element.placement === "own") { this.defineClassElement(O, element); } }, this); }, this); }, initializeClassElements: function (F, elements) { var proto = F.prototype; ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { var placement = element.placement; if (element.kind === kind && (placement === "static" || placement === "prototype")) { var receiver = placement === "static" ? F : proto; this.defineClassElement(receiver, element); } }, this); }, this); }, defineClassElement: function (receiver, element) { var descriptor = element.descriptor; if (element.kind === "field") { var initializer = element.initializer; descriptor = { enumerable: descriptor.enumerable, writable: descriptor.writable, configurable: descriptor.configurable, value: initializer === void 0 ? void 0 : initializer.call(receiver) }; } Object.defineProperty(receiver, element.key, descriptor); }, decorateClass: function (elements, decorators) { var newElements = []; var finishers = []; var placements = { static: [], prototype: [], own: [] }; elements.forEach(function (element) { this.addElementPlacement(element, placements); }, this); elements.forEach(function (element) { if (!_hasDecorators(element)) return newElements.push(element); var elementFinishersExtras = this.decorateElement(element, placements); newElements.push(elementFinishersExtras.element); newElements.push.apply(newElements, elementFinishersExtras.extras); finishers.push.apply(finishers, elementFinishersExtras.finishers); }, this); if (!decorators) { return { elements: newElements, finishers: finishers }; } var result = this.decorateConstructor(newElements, decorators); finishers.push.apply(finishers, result.finishers); result.finishers = finishers; return result; }, addElementPlacement: function (element, placements, silent) { var keys = placements[element.placement]; if (!silent && keys.indexOf(element.key) !== -1) { throw new TypeError("Duplicated element (" + element.key + ")"); } keys.push(element.key); }, decorateElement: function (element, placements) { var extras = []; var finishers = []; for (var decorators = element.decorators, i = decorators.length - 1; i >= 0; i--) { var keys = placements[element.placement]; keys.splice(keys.indexOf(element.key), 1); var elementObject = this.fromElementDescriptor(element); var elementFinisherExtras = this.toElementFinisherExtras((0, decorators[i])(elementObject) || elementObject); element = elementFinisherExtras.element; this.addElementPlacement(element, placements); if (elementFinisherExtras.finisher) { finishers.push(elementFinisherExtras.finisher); } var newExtras = elementFinisherExtras.extras; if (newExtras) { for (var j = 0; j < newExtras.length; j++) { this.addElementPlacement(newExtras[j], placements); } extras.push.apply(extras, newExtras); } } return { element: element, finishers: finishers, extras: extras }; }, decorateConstructor: function (elements, decorators) { var finishers = []; for (var i = decorators.length - 1; i >= 0; i--) { var obj = this.fromClassDescriptor(elements); var elementsAndFinisher = this.toClassDescriptor((0, decorators[i])(obj) || obj); if (elementsAndFinisher.finisher !== undefined) { finishers.push(elementsAndFinisher.finisher); } if (elementsAndFinisher.elements !== undefined) { elements = elementsAndFinisher.elements; for (var j = 0; j < elements.length - 1; j++) { for (var k = j + 1; k < elements.length; k++) { if (elements[j].key === elements[k].key && elements[j].placement === elements[k].placement) { throw new TypeError("Duplicated element (" + elements[j].key + ")"); } } } } } return { elements: elements, finishers: finishers }; }, fromElementDescriptor: function (element) { var obj = { kind: element.kind, key: element.key, placement: element.placement, descriptor: element.descriptor }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); if (element.kind === "field") obj.initializer = element.initializer; return obj; }, toElementDescriptors: function (elementObjects) { if (elementObjects === undefined) return; return _toArray(elementObjects).map(function (elementObject) { var element = this.toElementDescriptor(elementObject); this.disallowProperty(elementObject, "finisher", "An element descriptor"); this.disallowProperty(elementObject, "extras", "An element descriptor"); return element; }, this); }, toElementDescriptor: function (elementObject) { var kind = String(elementObject.kind); if (kind !== "method" && kind !== "field") { throw new TypeError('An element descriptor\'s .kind property must be either "method" or' + ' "field", but a decorator created an element descriptor with' + ' .kind "' + kind + '"'); } var key = _toPropertyKey(elementObject.key); var placement = String(elementObject.placement); if (placement !== "static" && placement !== "prototype" && placement !== "own") { throw new TypeError('An element descriptor\'s .placement property must be one of "static",' + ' "prototype" or "own", but a decorator created an element descriptor' + ' with .placement "' + placement + '"'); } var descriptor = elementObject.descriptor; this.disallowProperty(elementObject, "elements", "An element descriptor"); var element = { kind: kind, key: key, placement: placement, descriptor: Object.assign({}, descriptor) }; if (kind !== "field") { this.disallowProperty(elementObject, "initializer", "A method descriptor"); } else { this.disallowProperty(descriptor, "get", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "set", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "value", "The property descriptor of a field descriptor"); element.initializer = elementObject.initializer; } return element; }, toElementFinisherExtras: function (elementObject) { var element = this.toElementDescriptor(elementObject); var finisher = _optionalCallableProperty(elementObject, "finisher"); var extras = this.toElementDescriptors(elementObject.extras); return { element: element, finisher: finisher, extras: extras }; }, fromClassDescriptor: function (elements) { var obj = { kind: "class", elements: elements.map(this.fromElementDescriptor, this) }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); return obj; }, toClassDescriptor: function (obj) { var kind = String(obj.kind); if (kind !== "class") { throw new TypeError('A class descriptor\'s .kind property must be "class", but a decorator' + ' created a class descriptor with .kind "' + kind + '"'); } this.disallowProperty(obj, "key", "A class descriptor"); this.disallowProperty(obj, "placement", "A class descriptor"); this.disallowProperty(obj, "descriptor", "A class descriptor"); this.disallowProperty(obj, "initializer", "A class descriptor"); this.disallowProperty(obj, "extras", "A class descriptor"); var finisher = _optionalCallableProperty(obj, "finisher"); var elements = this.toElementDescriptors(obj.elements); return { elements: elements, finisher: finisher }; }, runClassFinishers: function (constructor, finishers) { for (var i = 0; i < finishers.length; i++) { var newConstructor = (0, finishers[i])(constructor); if (newConstructor !== undefined) { if (typeof newConstructor !== "function") { throw new TypeError("Finishers must return a constructor."); } constructor = newConstructor; } } return constructor; }, disallowProperty: function (obj, name, objectType) { if (obj[name] !== undefined) { throw new TypeError(objectType + " can't have a ." + name + " property."); } } }; return api; }

function _createElementDescriptor(def) { var key = _toPropertyKey(def.key); var descriptor; if (def.kind === "method") { descriptor = { value: def.value, writable: true, configurable: true, enumerable: false }; } else if (def.kind === "get") { descriptor = { get: def.value, configurable: true, enumerable: false }; } else if (def.kind === "set") { descriptor = { set: def.value, configurable: true, enumerable: false }; } else if (def.kind === "field") { descriptor = { configurable: true, writable: true, enumerable: true }; } var element = { kind: def.kind === "field" ? "field" : "method", key: key, placement: def.static ? "static" : def.kind === "field" ? "own" : "prototype", descriptor: descriptor }; if (def.decorators) element.decorators = def.decorators; if (def.kind === "field") element.initializer = def.value; return element; }

function _coalesceGetterSetter(element, other) { if (element.descriptor.get !== undefined) { other.descriptor.get = element.descriptor.get; } else { other.descriptor.set = element.descriptor.set; } }

function _coalesceClassElements(elements) { var newElements = []; var isSameElement = function (other) { return other.kind === "method" && other.key === element.key && other.placement === element.placement; }; for (var i = 0; i < elements.length; i++) { var element = elements[i]; var other; if (element.kind === "method" && (other = newElements.find(isSameElement))) { if (_isDataDescriptor(element.descriptor) || _isDataDescriptor(other.descriptor)) { if (_hasDecorators(element) || _hasDecorators(other)) { throw new ReferenceError("Duplicated methods (" + element.key + ") can't be decorated."); } other.descriptor = element.descriptor; } else { if (_hasDecorators(element)) { if (_hasDecorators(other)) { throw new ReferenceError("Decorators can't be placed on different accessors with for " + "the same property (" + element.key + ")."); } other.decorators = element.decorators; } _coalesceGetterSetter(element, other); } } else { newElements.push(element); } } return newElements; }

function _hasDecorators(element) { return element.decorators && element.decorators.length; }

function _isDataDescriptor(desc) { return desc !== undefined && !(desc.value === undefined && desc.writable === undefined); }

function _optionalCallableProperty(obj, name) { var value = obj[name]; if (value !== undefined && typeof value !== "function") { throw new TypeError("Expected '" + name + "' to be a function"); } return value; }

function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }

function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }

function _toArray(arr) { return _arrayWithHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(n); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get; } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return _get(target, property, receiver || target); }

function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
























let HaConfigDevicePage = _decorate([Object(lit_element__WEBPACK_IMPORTED_MODULE_1__["customElement"])("ha-config-device-page")], function (_initialize, _LitElement) {
  class HaConfigDevicePage extends _LitElement {
    constructor(...args) {
      super(...args);

      _initialize(this);
    }

  }

  return {
    F: HaConfigDevicePage,
    d: [{
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_1__["property"])()],
      key: "hass",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_1__["property"])()],
      key: "devices",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_1__["property"])()],
      key: "entries",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_1__["property"])()],
      key: "entities",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_1__["property"])()],
      key: "areas",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_1__["property"])()],
      key: "deviceId",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_1__["property"])({
        type: Boolean,
        reflect: true
      })],
      key: "narrow",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_1__["property"])()],
      key: "isWide",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_1__["property"])()],
      key: "showAdvanced",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_1__["property"])()],
      key: "route",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_1__["property"])()],
      key: "_related",
      value: void 0
    }, {
      kind: "field",
      key: "_device",

      value() {
        return Object(memoize_one__WEBPACK_IMPORTED_MODULE_3__["default"])((deviceId, devices) => devices ? devices.find(device => device.id === deviceId) : undefined);
      }

    }, {
      kind: "field",
      key: "_integrations",

      value() {
        return Object(memoize_one__WEBPACK_IMPORTED_MODULE_3__["default"])((device, entries) => entries.filter(entry => device.config_entries.includes(entry.entry_id)).map(entry => entry.domain));
      }

    }, {
      kind: "field",
      key: "_entities",

      value() {
        return Object(memoize_one__WEBPACK_IMPORTED_MODULE_3__["default"])((deviceId, entities) => entities.filter(entity => entity.device_id === deviceId).map(entity => {
          return Object.assign({}, entity, {
            stateName: this._computeEntityName(entity)
          });
        }).sort((ent1, ent2) => Object(_common_string_compare__WEBPACK_IMPORTED_MODULE_7__["compare"])(ent1.stateName || `zzz${ent1.entity_id}`, ent2.stateName || `zzz${ent2.entity_id}`)));
      }

    }, {
      kind: "field",
      key: "_computeArea",

      value() {
        return Object(memoize_one__WEBPACK_IMPORTED_MODULE_3__["default"])((areas, device) => {
          if (!areas || !device || !device.area_id) {
            return undefined;
          }

          return areas.find(area => area.area_id === device.area_id);
        });
      }

    }, {
      kind: "field",
      key: "_batteryEntity",

      value() {
        return Object(memoize_one__WEBPACK_IMPORTED_MODULE_3__["default"])(entities => Object(_data_entity_registry__WEBPACK_IMPORTED_MODULE_11__["findBatteryEntity"])(this.hass, entities));
      }

    }, {
      kind: "method",
      key: "firstUpdated",
      value: function firstUpdated(changedProps) {
        _get(_getPrototypeOf(HaConfigDevicePage.prototype), "firstUpdated", this).call(this, changedProps);

        Object(_dialogs_device_registry_detail_show_dialog_device_registry_detail__WEBPACK_IMPORTED_MODULE_14__["loadDeviceRegistryDetailDialog"])();
      }
    }, {
      kind: "method",
      key: "updated",
      value: function updated(changedProps) {
        _get(_getPrototypeOf(HaConfigDevicePage.prototype), "updated", this).call(this, changedProps);

        if (changedProps.has("deviceId")) {
          this._findRelated();
        }
      }
    }, {
      kind: "method",
      key: "render",
      value: function render() {
        var _this$_related, _this$_related$automa, _this$_related2, _this$_related2$scene, _this$_related3, _this$_related3$scrip;

        const device = this._device(this.deviceId, this.devices);

        if (!device) {
          return lit_element__WEBPACK_IMPORTED_MODULE_1__["html"]`
        <hass-error-screen
          error="${this.hass.localize("ui.panel.config.devices.device_not_found")}"
        ></hass-error-screen>
      `;
        }

        const integrations = this._integrations(device, this.entries);

        const entities = this._entities(this.deviceId, this.entities);

        const batteryEntity = this._batteryEntity(entities);

        const batteryState = batteryEntity ? this.hass.states[batteryEntity.entity_id] : undefined;

        const area = this._computeArea(this.areas, device);

        return lit_element__WEBPACK_IMPORTED_MODULE_1__["html"]`
      <hass-tabs-subpage
        .hass=${this.hass}
        .narrow=${this.narrow}
        .tabs=${_ha_panel_config__WEBPACK_IMPORTED_MODULE_18__["configSections"].integrations}
        .route=${this.route}
      >
        ${this.narrow ? lit_element__WEBPACK_IMPORTED_MODULE_1__["html"]`
                <span slot="header">
                  ${Object(_data_device_registry__WEBPACK_IMPORTED_MODULE_10__["computeDeviceName"])(device, this.hass)}
                </span>
              ` : ""}

        <paper-icon-button
          slot="toolbar-icon"
          icon="hass:settings"
          @click=${this._showSettings}
        ></paper-icon-button>

        <div class="container">
          <div class="header fullwidth">
            ${this.narrow ? "" : lit_element__WEBPACK_IMPORTED_MODULE_1__["html"]`
                    <div>
                      <h1>${Object(_data_device_registry__WEBPACK_IMPORTED_MODULE_10__["computeDeviceName"])(device, this.hass)}</h1>
                      ${area ? lit_element__WEBPACK_IMPORTED_MODULE_1__["html"]`
                            <a href="/config/areas/area/${area.area_id}"
                              >${this.hass.localize("ui.panel.config.integrations.config_entry.area", "area", area.name || "Unnamed Area")}</a
                            >
                          ` : ""}
                    </div>
                  `}
                <div class="header-right">
                  ${batteryState ? lit_element__WEBPACK_IMPORTED_MODULE_1__["html"]`
                          <div class="battery">
                            ${batteryState.state}%
                            <ha-state-icon
                              .hass=${this.hass}
                              .stateObj=${batteryState}
                            ></ha-state-icon>
                          </div>
                        ` : ""}
                  <img
                    src="https://brands.home-assistant.io/${integrations[0]}/logo.png"
                    referrerpolicy="no-referrer"
                    @load=${this._onImageLoad}
                    @error=${this._onImageError}
                  />
                </div>
          </div>
          <div class="column">
              <ha-device-info-card
                .hass=${this.hass}
                .areas=${this.areas}
                .devices=${this.devices}
                .device=${device}
              >
              ${integrations.includes("mqtt") ? lit_element__WEBPACK_IMPORTED_MODULE_1__["html"]`
                      <ha-device-card-mqtt
                        .hass=${this.hass}
                        .device=${device}
                      ></ha-device-card-mqtt>
                    ` : lit_element__WEBPACK_IMPORTED_MODULE_1__["html"]``}
              </ha-device-info-card>

            ${entities.length ? lit_element__WEBPACK_IMPORTED_MODULE_1__["html"]`
                    <ha-device-entities-card
                      .hass=${this.hass}
                      .entities=${entities}
                    >
                    </ha-device-entities-card>
                  ` : lit_element__WEBPACK_IMPORTED_MODULE_1__["html"]``}
          </div>
            <div class="column">
            ${Object(_common_config_is_component_loaded__WEBPACK_IMPORTED_MODULE_4__["isComponentLoaded"])(this.hass, "automation") ? lit_element__WEBPACK_IMPORTED_MODULE_1__["html"]`
                    <ha-card>
                      <div class="card-header">
                        ${this.hass.localize("ui.panel.config.devices.automation.automations")}
                        <paper-icon-button
                          @click=${this._showAutomationDialog}
                          title=${this.hass.localize("ui.panel.config.devices.automation.create")}
                          icon="hass:plus-circle"
                        ></paper-icon-button>
                      </div>
                      ${((_this$_related = this._related) === null || _this$_related === void 0 ? void 0 : (_this$_related$automa = _this$_related.automation) === null || _this$_related$automa === void 0 ? void 0 : _this$_related$automa.length) ? this._related.automation.map(automation => {
          const state = this.hass.states[automation];
          return state ? lit_element__WEBPACK_IMPORTED_MODULE_1__["html"]`
                                  <div>
                                    <a
                                      href=${Object(lit_html_directives_if_defined__WEBPACK_IMPORTED_MODULE_2__["ifDefined"])(state.attributes.id ? `/config/automation/edit/${state.attributes.id}` : undefined)}
                                    >
                                      <paper-item
                                        .automation=${state}
                                        .disabled=${!state.attributes.id}
                                      >
                                        <paper-item-body>
                                          ${Object(_common_entity_compute_state_name__WEBPACK_IMPORTED_MODULE_5__["computeStateName"])(state)}
                                        </paper-item-body>
                                        <ha-icon-next></ha-icon-next>
                                      </paper-item>
                                    </a>
                                    ${!state.attributes.id ? lit_element__WEBPACK_IMPORTED_MODULE_1__["html"]`
                                          <paper-tooltip
                                            >${this.hass.localize("ui.panel.config.devices.cant_edit")}
                                          </paper-tooltip>
                                        ` : ""}
                                  </div>
                                ` : "";
        }) : lit_element__WEBPACK_IMPORTED_MODULE_1__["html"]`
                            <paper-item class="no-link"
                              >${this.hass.localize("ui.panel.config.devices.automation.no_automations")}</paper-item
                            >
                          `}
                    </ha-card>
                  ` : ""}
            </div>
            <div class="column">
            ${Object(_common_config_is_component_loaded__WEBPACK_IMPORTED_MODULE_4__["isComponentLoaded"])(this.hass, "scene") && entities.length ? lit_element__WEBPACK_IMPORTED_MODULE_1__["html"]`
                    <ha-card>
                        <div class="card-header">
                          ${this.hass.localize("ui.panel.config.devices.scene.scenes")}

                                  <paper-icon-button
                                    @click=${this._createScene}
                                    title=${this.hass.localize("ui.panel.config.devices.scene.create")}
                                    icon="hass:plus-circle"
                                  ></paper-icon-button>
                        </div>

                        ${((_this$_related2 = this._related) === null || _this$_related2 === void 0 ? void 0 : (_this$_related2$scene = _this$_related2.scene) === null || _this$_related2$scene === void 0 ? void 0 : _this$_related2$scene.length) ? this._related.scene.map(scene => {
          const state = this.hass.states[scene];
          return state ? lit_element__WEBPACK_IMPORTED_MODULE_1__["html"]`
                                      <div>
                                        <a
                                          href=${Object(lit_html_directives_if_defined__WEBPACK_IMPORTED_MODULE_2__["ifDefined"])(state.attributes.id ? `/config/scene/edit/${state.attributes.id}` : undefined)}
                                        >
                                          <paper-item
                                            .scene=${state}
                                            .disabled=${!state.attributes.id}
                                          >
                                            <paper-item-body>
                                              ${Object(_common_entity_compute_state_name__WEBPACK_IMPORTED_MODULE_5__["computeStateName"])(state)}
                                            </paper-item-body>
                                            <ha-icon-next></ha-icon-next>
                                          </paper-item>
                                        </a>
                                        ${!state.attributes.id ? lit_element__WEBPACK_IMPORTED_MODULE_1__["html"]`
                                              <paper-tooltip
                                                >${this.hass.localize("ui.panel.config.devices.cant_edit")}
                                              </paper-tooltip>
                                            ` : ""}
                                      </div>
                                    ` : "";
        }) : lit_element__WEBPACK_IMPORTED_MODULE_1__["html"]`
                                <paper-item class="no-link"
                                  >${this.hass.localize("ui.panel.config.devices.scene.no_scenes")}</paper-item
                                >
                              `}
                      </ha-card>
                    </ha-card>
                  ` : ""}
              ${Object(_common_config_is_component_loaded__WEBPACK_IMPORTED_MODULE_4__["isComponentLoaded"])(this.hass, "script") ? lit_element__WEBPACK_IMPORTED_MODULE_1__["html"]`
                      <ha-card>
                        <div class="card-header">
                          ${this.hass.localize("ui.panel.config.devices.script.scripts")}
                          <paper-icon-button
                            @click=${this._showScriptDialog}
                            title=${this.hass.localize("ui.panel.config.devices.script.create")}
                            icon="hass:plus-circle"
                          ></paper-icon-button>
                        </div>
                        ${((_this$_related3 = this._related) === null || _this$_related3 === void 0 ? void 0 : (_this$_related3$scrip = _this$_related3.script) === null || _this$_related3$scrip === void 0 ? void 0 : _this$_related3$scrip.length) ? this._related.script.map(script => {
          const state = this.hass.states[script];
          return state ? lit_element__WEBPACK_IMPORTED_MODULE_1__["html"]`
                                    <a
                                      href=${Object(lit_html_directives_if_defined__WEBPACK_IMPORTED_MODULE_2__["ifDefined"])(state.attributes.id ? `/config/script/edit/${state.attributes.id}` : undefined)}
                                    >
                                      <paper-item .script=${script}>
                                        <paper-item-body>
                                          ${Object(_common_entity_compute_state_name__WEBPACK_IMPORTED_MODULE_5__["computeStateName"])(state)}
                                        </paper-item-body>
                                        <ha-icon-next></ha-icon-next>
                                      </paper-item>
                                    </a>
                                  ` : "";
        }) : lit_element__WEBPACK_IMPORTED_MODULE_1__["html"]`
                              <paper-item class="no-link">
                                ${this.hass.localize("ui.panel.config.devices.script.no_scripts")}</paper-item
                              >
                            `}
                      </ha-card>
                    ` : ""}
            </div>
        </div>
        </ha-config-section>
      </hass-tabs-subpage>    `;
      }
    }, {
      kind: "method",
      key: "_computeEntityName",
      value: function _computeEntityName(entity) {
        if (entity.name) {
          return entity.name;
        }

        const state = this.hass.states[entity.entity_id];
        return state ? Object(_common_entity_compute_state_name__WEBPACK_IMPORTED_MODULE_5__["computeStateName"])(state) : null;
      }
    }, {
      kind: "method",
      key: "_onImageLoad",
      value: function _onImageLoad(ev) {
        ev.target.style.display = "inline-block";
      }
    }, {
      kind: "method",
      key: "_onImageError",
      value: function _onImageError(ev) {
        ev.target.style.display = "none";
      }
    }, {
      kind: "method",
      key: "_findRelated",
      value: async function _findRelated() {
        this._related = await Object(_data_search__WEBPACK_IMPORTED_MODULE_13__["findRelated"])(this.hass, "device", this.deviceId);
      }
    }, {
      kind: "method",
      key: "_createScene",
      value: function _createScene() {
        const entities = {};

        this._entities(this.deviceId, this.entities).forEach(entity => {
          entities[entity.entity_id] = "";
        });

        Object(_data_scene__WEBPACK_IMPORTED_MODULE_12__["showSceneEditor"])(this, {
          entities
        });
      }
    }, {
      kind: "method",
      key: "_showScriptDialog",
      value: function _showScriptDialog() {
        Object(_device_detail_show_dialog_device_automation__WEBPACK_IMPORTED_MODULE_22__["showDeviceAutomationDialog"])(this, {
          deviceId: this.deviceId,
          script: true
        });
      }
    }, {
      kind: "method",
      key: "_showAutomationDialog",
      value: function _showAutomationDialog() {
        Object(_device_detail_show_dialog_device_automation__WEBPACK_IMPORTED_MODULE_22__["showDeviceAutomationDialog"])(this, {
          deviceId: this.deviceId,
          script: false
        });
      }
    }, {
      kind: "method",
      key: "_showSettings",
      value: async function _showSettings() {
        const device = this._device(this.deviceId, this.devices);

        Object(_dialogs_device_registry_detail_show_dialog_device_registry_detail__WEBPACK_IMPORTED_MODULE_14__["showDeviceRegistryDetailDialog"])(this, {
          device,
          updateEntry: async updates => {
            const oldDeviceName = device.name_by_user || device.name;
            const newDeviceName = updates.name_by_user;
            await Object(_data_device_registry__WEBPACK_IMPORTED_MODULE_10__["updateDeviceRegistryEntry"])(this.hass, this.deviceId, updates);

            if (!oldDeviceName || !newDeviceName || oldDeviceName === newDeviceName) {
              return;
            }

            const entities = this._entities(this.deviceId, this.entities);

            const renameEntityid = this.showAdvanced && confirm(this.hass.localize("ui.panel.config.devices.confirm_rename_entity_ids"));
            const updateProms = entities.map(entity => {
              const name = entity.name || entity.stateName;
              let newEntityId = null;
              let newName = null;

              if (name && name.includes(oldDeviceName)) {
                newName = name.replace(oldDeviceName, newDeviceName);
              }

              if (renameEntityid) {
                const oldSearch = Object(_common_entity_valid_entity_id__WEBPACK_IMPORTED_MODULE_6__["createValidEntityId"])(oldDeviceName);

                if (entity.entity_id.includes(oldSearch)) {
                  newEntityId = entity.entity_id.replace(oldSearch, Object(_common_entity_valid_entity_id__WEBPACK_IMPORTED_MODULE_6__["createValidEntityId"])(newDeviceName));
                }
              }

              if (!newName && !newEntityId) {
                return new Promise(resolve => resolve());
              }

              return Object(_data_entity_registry__WEBPACK_IMPORTED_MODULE_11__["updateEntityRegistryEntry"])(this.hass, entity.entity_id, {
                name: newName || name,
                disabled_by: entity.disabled_by,
                new_entity_id: newEntityId || entity.entity_id
              });
            });
            await Promise.all(updateProms);
          }
        });
      }
    }, {
      kind: "get",
      static: true,
      key: "styles",
      value: function styles() {
        return lit_element__WEBPACK_IMPORTED_MODULE_1__["css"]`
      .container {
        display: flex;
        flex-wrap: wrap;
        margin: auto;
        max-width: 1000px;
        margin-top: 32px;
        margin-bottom: 32px;
      }

      .card-header {
        display: flex;
        align-items: center;
        justify-content: space-between;
      }

      .card-header paper-icon-button {
        margin-right: -8px;
        color: var(--primary-color);
        height: auto;
      }

      .device-info {
        padding: 16px;
      }

      .show-more {
      }

      h1 {
        margin: 0;
        font-family: var(--paper-font-headline_-_font-family);
        -webkit-font-smoothing: var(
          --paper-font-headline_-_-webkit-font-smoothing
        );
        font-size: var(--paper-font-headline_-_font-size);
        font-weight: var(--paper-font-headline_-_font-weight);
        letter-spacing: var(--paper-font-headline_-_letter-spacing);
        line-height: var(--paper-font-headline_-_line-height);
        opacity: var(--dark-primary-opacity);
      }

      .header {
        display: flex;
        justify-content: space-between;
      }

      .column,
      .fullwidth {
        padding: 8px;
        box-sizing: border-box;
      }
      .column {
        width: 33%;
        flex-grow: 1;
      }
      .fullwidth {
        width: 100%;
        flex-grow: 1;
      }

      .header-right {
        align-self: center;
      }

      .header-right img {
        height: 30px;
      }

      .header-right {
        display: flex;
      }

      .header-right:first-child {
        width: 100%;
        justify-content: flex-end;
      }

      .header-right > *:not(:first-child) {
        margin-left: 16px;
      }

      .battery {
        align-self: center;
        align-items: center;
        display: flex;
      }

      .column > *:not(:first-child) {
        margin-top: 16px;
      }

      :host([narrow]) .column {
        width: 100%;
      }

      :host([narrow]) .container {
        margin-top: 0;
      }

      paper-item {
        cursor: pointer;
      }

      paper-item.no-link {
        cursor: default;
      }

      a {
        text-decoration: none;
        color: var(--primary-color);
      }

      ha-card a {
        color: var(--primary-text-color);
      }
    `;
      }
    }]
  };
}, lit_element__WEBPACK_IMPORTED_MODULE_1__["LitElement"]);

/***/ }),

/***/ "./src/panels/config/devices/ha-config-devices-dashboard.ts":
/*!******************************************************************!*\
  !*** ./src/panels/config/devices/ha-config-devices-dashboard.ts ***!
  \******************************************************************/
/*! exports provided: HaConfigDeviceDashboard */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HaConfigDeviceDashboard", function() { return HaConfigDeviceDashboard; });
/* harmony import */ var lit_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lit-element */ "./node_modules/lit-element/lit-element.js");
/* harmony import */ var memoize_one__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! memoize-one */ "./node_modules/memoize-one/dist/memoize-one.esm.js");
/* harmony import */ var _common_navigate__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../common/navigate */ "./src/common/navigate.ts");
/* harmony import */ var _components_entity_ha_state_icon__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../components/entity/ha-state-icon */ "./src/components/entity/ha-state-icon.js");
/* harmony import */ var _data_device_registry__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../data/device_registry */ "./src/data/device_registry.ts");
/* harmony import */ var _data_entity_registry__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../data/entity_registry */ "./src/data/entity_registry.ts");
/* harmony import */ var _data_integration__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../data/integration */ "./src/data/integration.ts");
/* harmony import */ var _layouts_hass_tabs_subpage_data_table__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../layouts/hass-tabs-subpage-data-table */ "./src/layouts/hass-tabs-subpage-data-table.ts");
/* harmony import */ var _ha_panel_config__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../ha-panel-config */ "./src/panels/config/ha-panel-config.ts");
function _decorate(decorators, factory, superClass, mixins) { var api = _getDecoratorsApi(); if (mixins) { for (var i = 0; i < mixins.length; i++) { api = mixins[i](api); } } var r = factory(function initialize(O) { api.initializeInstanceElements(O, decorated.elements); }, superClass); var decorated = api.decorateClass(_coalesceClassElements(r.d.map(_createElementDescriptor)), decorators); api.initializeClassElements(r.F, decorated.elements); return api.runClassFinishers(r.F, decorated.finishers); }

function _getDecoratorsApi() { _getDecoratorsApi = function () { return api; }; var api = { elementsDefinitionOrder: [["method"], ["field"]], initializeInstanceElements: function (O, elements) { ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { if (element.kind === kind && element.placement === "own") { this.defineClassElement(O, element); } }, this); }, this); }, initializeClassElements: function (F, elements) { var proto = F.prototype; ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { var placement = element.placement; if (element.kind === kind && (placement === "static" || placement === "prototype")) { var receiver = placement === "static" ? F : proto; this.defineClassElement(receiver, element); } }, this); }, this); }, defineClassElement: function (receiver, element) { var descriptor = element.descriptor; if (element.kind === "field") { var initializer = element.initializer; descriptor = { enumerable: descriptor.enumerable, writable: descriptor.writable, configurable: descriptor.configurable, value: initializer === void 0 ? void 0 : initializer.call(receiver) }; } Object.defineProperty(receiver, element.key, descriptor); }, decorateClass: function (elements, decorators) { var newElements = []; var finishers = []; var placements = { static: [], prototype: [], own: [] }; elements.forEach(function (element) { this.addElementPlacement(element, placements); }, this); elements.forEach(function (element) { if (!_hasDecorators(element)) return newElements.push(element); var elementFinishersExtras = this.decorateElement(element, placements); newElements.push(elementFinishersExtras.element); newElements.push.apply(newElements, elementFinishersExtras.extras); finishers.push.apply(finishers, elementFinishersExtras.finishers); }, this); if (!decorators) { return { elements: newElements, finishers: finishers }; } var result = this.decorateConstructor(newElements, decorators); finishers.push.apply(finishers, result.finishers); result.finishers = finishers; return result; }, addElementPlacement: function (element, placements, silent) { var keys = placements[element.placement]; if (!silent && keys.indexOf(element.key) !== -1) { throw new TypeError("Duplicated element (" + element.key + ")"); } keys.push(element.key); }, decorateElement: function (element, placements) { var extras = []; var finishers = []; for (var decorators = element.decorators, i = decorators.length - 1; i >= 0; i--) { var keys = placements[element.placement]; keys.splice(keys.indexOf(element.key), 1); var elementObject = this.fromElementDescriptor(element); var elementFinisherExtras = this.toElementFinisherExtras((0, decorators[i])(elementObject) || elementObject); element = elementFinisherExtras.element; this.addElementPlacement(element, placements); if (elementFinisherExtras.finisher) { finishers.push(elementFinisherExtras.finisher); } var newExtras = elementFinisherExtras.extras; if (newExtras) { for (var j = 0; j < newExtras.length; j++) { this.addElementPlacement(newExtras[j], placements); } extras.push.apply(extras, newExtras); } } return { element: element, finishers: finishers, extras: extras }; }, decorateConstructor: function (elements, decorators) { var finishers = []; for (var i = decorators.length - 1; i >= 0; i--) { var obj = this.fromClassDescriptor(elements); var elementsAndFinisher = this.toClassDescriptor((0, decorators[i])(obj) || obj); if (elementsAndFinisher.finisher !== undefined) { finishers.push(elementsAndFinisher.finisher); } if (elementsAndFinisher.elements !== undefined) { elements = elementsAndFinisher.elements; for (var j = 0; j < elements.length - 1; j++) { for (var k = j + 1; k < elements.length; k++) { if (elements[j].key === elements[k].key && elements[j].placement === elements[k].placement) { throw new TypeError("Duplicated element (" + elements[j].key + ")"); } } } } } return { elements: elements, finishers: finishers }; }, fromElementDescriptor: function (element) { var obj = { kind: element.kind, key: element.key, placement: element.placement, descriptor: element.descriptor }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); if (element.kind === "field") obj.initializer = element.initializer; return obj; }, toElementDescriptors: function (elementObjects) { if (elementObjects === undefined) return; return _toArray(elementObjects).map(function (elementObject) { var element = this.toElementDescriptor(elementObject); this.disallowProperty(elementObject, "finisher", "An element descriptor"); this.disallowProperty(elementObject, "extras", "An element descriptor"); return element; }, this); }, toElementDescriptor: function (elementObject) { var kind = String(elementObject.kind); if (kind !== "method" && kind !== "field") { throw new TypeError('An element descriptor\'s .kind property must be either "method" or' + ' "field", but a decorator created an element descriptor with' + ' .kind "' + kind + '"'); } var key = _toPropertyKey(elementObject.key); var placement = String(elementObject.placement); if (placement !== "static" && placement !== "prototype" && placement !== "own") { throw new TypeError('An element descriptor\'s .placement property must be one of "static",' + ' "prototype" or "own", but a decorator created an element descriptor' + ' with .placement "' + placement + '"'); } var descriptor = elementObject.descriptor; this.disallowProperty(elementObject, "elements", "An element descriptor"); var element = { kind: kind, key: key, placement: placement, descriptor: Object.assign({}, descriptor) }; if (kind !== "field") { this.disallowProperty(elementObject, "initializer", "A method descriptor"); } else { this.disallowProperty(descriptor, "get", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "set", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "value", "The property descriptor of a field descriptor"); element.initializer = elementObject.initializer; } return element; }, toElementFinisherExtras: function (elementObject) { var element = this.toElementDescriptor(elementObject); var finisher = _optionalCallableProperty(elementObject, "finisher"); var extras = this.toElementDescriptors(elementObject.extras); return { element: element, finisher: finisher, extras: extras }; }, fromClassDescriptor: function (elements) { var obj = { kind: "class", elements: elements.map(this.fromElementDescriptor, this) }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); return obj; }, toClassDescriptor: function (obj) { var kind = String(obj.kind); if (kind !== "class") { throw new TypeError('A class descriptor\'s .kind property must be "class", but a decorator' + ' created a class descriptor with .kind "' + kind + '"'); } this.disallowProperty(obj, "key", "A class descriptor"); this.disallowProperty(obj, "placement", "A class descriptor"); this.disallowProperty(obj, "descriptor", "A class descriptor"); this.disallowProperty(obj, "initializer", "A class descriptor"); this.disallowProperty(obj, "extras", "A class descriptor"); var finisher = _optionalCallableProperty(obj, "finisher"); var elements = this.toElementDescriptors(obj.elements); return { elements: elements, finisher: finisher }; }, runClassFinishers: function (constructor, finishers) { for (var i = 0; i < finishers.length; i++) { var newConstructor = (0, finishers[i])(constructor); if (newConstructor !== undefined) { if (typeof newConstructor !== "function") { throw new TypeError("Finishers must return a constructor."); } constructor = newConstructor; } } return constructor; }, disallowProperty: function (obj, name, objectType) { if (obj[name] !== undefined) { throw new TypeError(objectType + " can't have a ." + name + " property."); } } }; return api; }

function _createElementDescriptor(def) { var key = _toPropertyKey(def.key); var descriptor; if (def.kind === "method") { descriptor = { value: def.value, writable: true, configurable: true, enumerable: false }; } else if (def.kind === "get") { descriptor = { get: def.value, configurable: true, enumerable: false }; } else if (def.kind === "set") { descriptor = { set: def.value, configurable: true, enumerable: false }; } else if (def.kind === "field") { descriptor = { configurable: true, writable: true, enumerable: true }; } var element = { kind: def.kind === "field" ? "field" : "method", key: key, placement: def.static ? "static" : def.kind === "field" ? "own" : "prototype", descriptor: descriptor }; if (def.decorators) element.decorators = def.decorators; if (def.kind === "field") element.initializer = def.value; return element; }

function _coalesceGetterSetter(element, other) { if (element.descriptor.get !== undefined) { other.descriptor.get = element.descriptor.get; } else { other.descriptor.set = element.descriptor.set; } }

function _coalesceClassElements(elements) { var newElements = []; var isSameElement = function (other) { return other.kind === "method" && other.key === element.key && other.placement === element.placement; }; for (var i = 0; i < elements.length; i++) { var element = elements[i]; var other; if (element.kind === "method" && (other = newElements.find(isSameElement))) { if (_isDataDescriptor(element.descriptor) || _isDataDescriptor(other.descriptor)) { if (_hasDecorators(element) || _hasDecorators(other)) { throw new ReferenceError("Duplicated methods (" + element.key + ") can't be decorated."); } other.descriptor = element.descriptor; } else { if (_hasDecorators(element)) { if (_hasDecorators(other)) { throw new ReferenceError("Decorators can't be placed on different accessors with for " + "the same property (" + element.key + ")."); } other.decorators = element.decorators; } _coalesceGetterSetter(element, other); } } else { newElements.push(element); } } return newElements; }

function _hasDecorators(element) { return element.decorators && element.decorators.length; }

function _isDataDescriptor(desc) { return desc !== undefined && !(desc.value === undefined && desc.writable === undefined); }

function _optionalCallableProperty(obj, name) { var value = obj[name]; if (value !== undefined && typeof value !== "function") { throw new TypeError("Expected '" + name + "' to be a function"); } return value; }

function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }

function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }

function _toArray(arr) { return _arrayWithHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(n); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }










let HaConfigDeviceDashboard = _decorate([Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["customElement"])("ha-config-devices-dashboard")], function (_initialize, _LitElement) {
  class HaConfigDeviceDashboard extends _LitElement {
    constructor() {
      super();

      _initialize(this);

      window.addEventListener("location-changed", () => {
        this._searchParms = new URLSearchParams(window.location.search);
      });
      window.addEventListener("popstate", () => {
        this._searchParms = new URLSearchParams(window.location.search);
      });
    }

  }

  return {
    F: HaConfigDeviceDashboard,
    d: [{
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "hass",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "narrow",

      value() {
        return false;
      }

    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "isWide",

      value() {
        return false;
      }

    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "devices",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "entries",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "entities",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "areas",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "route",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "_searchParms",

      value() {
        return new URLSearchParams(window.location.search);
      }

    }, {
      kind: "field",
      key: "_activeFilters",

      value() {
        return Object(memoize_one__WEBPACK_IMPORTED_MODULE_1__["default"])((entries, filters, localize) => {
          const filterTexts = [];
          filters.forEach((value, key) => {
            switch (key) {
              case "config_entry":
                {
                  const configEntry = entries.find(entry => entry.entry_id === value);

                  if (!configEntry) {
                    break;
                  }

                  const integrationName = Object(_data_integration__WEBPACK_IMPORTED_MODULE_6__["domainToName"])(localize, configEntry.domain);
                  filterTexts.push(`${this.hass.localize("ui.panel.config.integrations.integration")} ${integrationName}${integrationName !== configEntry.title ? `: ${configEntry.title}` : ""}`);
                  break;
                }
            }
          });
          return filterTexts.length ? filterTexts : undefined;
        });
      }

    }, {
      kind: "field",
      key: "_devices",

      value() {
        return Object(memoize_one__WEBPACK_IMPORTED_MODULE_1__["default"])((devices, entries, entities, areas, filters, localize) => {
          // Some older installations might have devices pointing at invalid entryIDs
          // So we guard for that.
          let outputDevices = devices;
          const deviceLookup = {};

          for (const device of devices) {
            deviceLookup[device.id] = device;
          }

          const deviceEntityLookup = {};

          for (const entity of entities) {
            if (!entity.device_id) {
              continue;
            }

            if (!(entity.device_id in deviceEntityLookup)) {
              deviceEntityLookup[entity.device_id] = [];
            }

            deviceEntityLookup[entity.device_id].push(entity);
          }

          const entryLookup = {};

          for (const entry of entries) {
            entryLookup[entry.entry_id] = entry;
          }

          const areaLookup = {};

          for (const area of areas) {
            areaLookup[area.area_id] = area;
          }

          filters.forEach((value, key) => {
            switch (key) {
              case "config_entry":
                outputDevices = outputDevices.filter(device => device.config_entries.includes(value));
                break;
            }
          });
          outputDevices = outputDevices.map(device => {
            return Object.assign({}, device, {
              name: Object(_data_device_registry__WEBPACK_IMPORTED_MODULE_4__["computeDeviceName"])(device, this.hass, deviceEntityLookup[device.id]),
              model: device.model || "<unknown>",
              manufacturer: device.manufacturer || "<unknown>",
              area: device.area_id ? areaLookup[device.area_id].name : "No area",
              integration: device.config_entries.length ? device.config_entries.filter(entId => entId in entryLookup).map(entId => localize(`component.${entryLookup[entId].domain}.title`) || entryLookup[entId].domain).join(", ") : "No integration",
              battery_entity: this._batteryEntity(device.id, deviceEntityLookup)
            });
          });
          return outputDevices;
        });
      }

    }, {
      kind: "field",
      key: "_columns",

      value() {
        return Object(memoize_one__WEBPACK_IMPORTED_MODULE_1__["default"])(narrow => narrow ? {
          name: {
            title: "Device",
            sortable: true,
            filterable: true,
            direction: "asc",
            grows: true,
            template: (name, device) => {
              return lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
                  ${name}
                  <div class="secondary">
                    ${device.area} | ${device.integration}
                  </div>
                `;
            }
          },
          battery_entity: {
            title: this.hass.localize("ui.panel.config.devices.data_table.battery"),
            sortable: true,
            type: "numeric",
            width: "90px",
            template: batteryEntity => {
              const battery = batteryEntity ? this.hass.states[batteryEntity] : undefined;
              return battery ? lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
                      ${isNaN(battery.state) ? "-" : battery.state}%
                      <ha-state-icon
                        .hass=${this.hass}
                        .stateObj=${battery}
                      ></ha-state-icon>
                    ` : lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]` - `;
            }
          }
        } : {
          name: {
            title: this.hass.localize("ui.panel.config.devices.data_table.device"),
            sortable: true,
            filterable: true,
            grows: true,
            direction: "asc"
          },
          manufacturer: {
            title: this.hass.localize("ui.panel.config.devices.data_table.manufacturer"),
            sortable: true,
            filterable: true,
            width: "15%"
          },
          model: {
            title: this.hass.localize("ui.panel.config.devices.data_table.model"),
            sortable: true,
            filterable: true,
            width: "15%"
          },
          area: {
            title: this.hass.localize("ui.panel.config.devices.data_table.area"),
            sortable: true,
            filterable: true,
            width: "15%"
          },
          integration: {
            title: this.hass.localize("ui.panel.config.devices.data_table.integration"),
            sortable: true,
            filterable: true,
            width: "15%"
          },
          battery_entity: {
            title: this.hass.localize("ui.panel.config.devices.data_table.battery"),
            sortable: true,
            type: "numeric",
            width: "15%",
            maxWidth: "90px",
            template: batteryEntity => {
              const battery = batteryEntity ? this.hass.states[batteryEntity] : undefined;
              return battery && !isNaN(battery.state) ? lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
                      ${battery.state}%
                      <ha-state-icon
                        .hass=${this.hass}
                        .stateObj=${battery}
                      ></ha-state-icon>
                    ` : lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]` - `;
            }
          }
        });
      }

    }, {
      kind: "method",
      key: "render",
      value: function render() {
        return lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
      <hass-tabs-subpage-data-table
        .hass=${this.hass}
        .narrow=${this.narrow}
        .backPath=${this._searchParms.has("historyBack") ? undefined : "/config"}
        .tabs=${_ha_panel_config__WEBPACK_IMPORTED_MODULE_8__["configSections"].integrations}
        .route=${this.route}
        .columns=${this._columns(this.narrow)}
        .data=${this._devices(this.devices, this.entries, this.entities, this.areas, this._searchParms, this.hass.localize)}
        .activeFilters=${this._activeFilters(this.entries, this._searchParms, this.hass.localize)}
        @row-click=${this._handleRowClicked}
      >
      </hass-tabs-subpage-data-table>
    `;
      }
    }, {
      kind: "method",
      key: "_batteryEntity",
      value: function _batteryEntity(deviceId, deviceEntityLookup) {
        const batteryEntity = Object(_data_entity_registry__WEBPACK_IMPORTED_MODULE_5__["findBatteryEntity"])(this.hass, deviceEntityLookup[deviceId] || []);
        return batteryEntity ? batteryEntity.entity_id : undefined;
      }
    }, {
      kind: "method",
      key: "_handleRowClicked",
      value: function _handleRowClicked(ev) {
        const deviceId = ev.detail.id;
        Object(_common_navigate__WEBPACK_IMPORTED_MODULE_2__["navigate"])(this, `/config/devices/device/${deviceId}`);
      }
    }]
  };
}, lit_element__WEBPACK_IMPORTED_MODULE_0__["LitElement"]);

/***/ }),

/***/ "./src/panels/config/devices/ha-config-devices.ts":
/*!********************************************************!*\
  !*** ./src/panels/config/devices/ha-config-devices.ts ***!
  \********************************************************/
/*! no exports provided */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var lit_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lit-element */ "./node_modules/lit-element/lit-element.js");
/* harmony import */ var _data_area_registry__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../data/area_registry */ "./src/data/area_registry.ts");
/* harmony import */ var _data_config_entries__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../data/config_entries */ "./src/data/config_entries.ts");
/* harmony import */ var _data_device_registry__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../data/device_registry */ "./src/data/device_registry.ts");
/* harmony import */ var _data_entity_registry__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../data/entity_registry */ "./src/data/entity_registry.ts");
/* harmony import */ var _layouts_hass_router_page__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../layouts/hass-router-page */ "./src/layouts/hass-router-page.ts");
/* harmony import */ var _ha_config_device_page__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./ha-config-device-page */ "./src/panels/config/devices/ha-config-device-page.ts");
/* harmony import */ var _ha_config_devices_dashboard__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./ha-config-devices-dashboard */ "./src/panels/config/devices/ha-config-devices-dashboard.ts");
function _decorate(decorators, factory, superClass, mixins) { var api = _getDecoratorsApi(); if (mixins) { for (var i = 0; i < mixins.length; i++) { api = mixins[i](api); } } var r = factory(function initialize(O) { api.initializeInstanceElements(O, decorated.elements); }, superClass); var decorated = api.decorateClass(_coalesceClassElements(r.d.map(_createElementDescriptor)), decorators); api.initializeClassElements(r.F, decorated.elements); return api.runClassFinishers(r.F, decorated.finishers); }

function _getDecoratorsApi() { _getDecoratorsApi = function () { return api; }; var api = { elementsDefinitionOrder: [["method"], ["field"]], initializeInstanceElements: function (O, elements) { ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { if (element.kind === kind && element.placement === "own") { this.defineClassElement(O, element); } }, this); }, this); }, initializeClassElements: function (F, elements) { var proto = F.prototype; ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { var placement = element.placement; if (element.kind === kind && (placement === "static" || placement === "prototype")) { var receiver = placement === "static" ? F : proto; this.defineClassElement(receiver, element); } }, this); }, this); }, defineClassElement: function (receiver, element) { var descriptor = element.descriptor; if (element.kind === "field") { var initializer = element.initializer; descriptor = { enumerable: descriptor.enumerable, writable: descriptor.writable, configurable: descriptor.configurable, value: initializer === void 0 ? void 0 : initializer.call(receiver) }; } Object.defineProperty(receiver, element.key, descriptor); }, decorateClass: function (elements, decorators) { var newElements = []; var finishers = []; var placements = { static: [], prototype: [], own: [] }; elements.forEach(function (element) { this.addElementPlacement(element, placements); }, this); elements.forEach(function (element) { if (!_hasDecorators(element)) return newElements.push(element); var elementFinishersExtras = this.decorateElement(element, placements); newElements.push(elementFinishersExtras.element); newElements.push.apply(newElements, elementFinishersExtras.extras); finishers.push.apply(finishers, elementFinishersExtras.finishers); }, this); if (!decorators) { return { elements: newElements, finishers: finishers }; } var result = this.decorateConstructor(newElements, decorators); finishers.push.apply(finishers, result.finishers); result.finishers = finishers; return result; }, addElementPlacement: function (element, placements, silent) { var keys = placements[element.placement]; if (!silent && keys.indexOf(element.key) !== -1) { throw new TypeError("Duplicated element (" + element.key + ")"); } keys.push(element.key); }, decorateElement: function (element, placements) { var extras = []; var finishers = []; for (var decorators = element.decorators, i = decorators.length - 1; i >= 0; i--) { var keys = placements[element.placement]; keys.splice(keys.indexOf(element.key), 1); var elementObject = this.fromElementDescriptor(element); var elementFinisherExtras = this.toElementFinisherExtras((0, decorators[i])(elementObject) || elementObject); element = elementFinisherExtras.element; this.addElementPlacement(element, placements); if (elementFinisherExtras.finisher) { finishers.push(elementFinisherExtras.finisher); } var newExtras = elementFinisherExtras.extras; if (newExtras) { for (var j = 0; j < newExtras.length; j++) { this.addElementPlacement(newExtras[j], placements); } extras.push.apply(extras, newExtras); } } return { element: element, finishers: finishers, extras: extras }; }, decorateConstructor: function (elements, decorators) { var finishers = []; for (var i = decorators.length - 1; i >= 0; i--) { var obj = this.fromClassDescriptor(elements); var elementsAndFinisher = this.toClassDescriptor((0, decorators[i])(obj) || obj); if (elementsAndFinisher.finisher !== undefined) { finishers.push(elementsAndFinisher.finisher); } if (elementsAndFinisher.elements !== undefined) { elements = elementsAndFinisher.elements; for (var j = 0; j < elements.length - 1; j++) { for (var k = j + 1; k < elements.length; k++) { if (elements[j].key === elements[k].key && elements[j].placement === elements[k].placement) { throw new TypeError("Duplicated element (" + elements[j].key + ")"); } } } } } return { elements: elements, finishers: finishers }; }, fromElementDescriptor: function (element) { var obj = { kind: element.kind, key: element.key, placement: element.placement, descriptor: element.descriptor }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); if (element.kind === "field") obj.initializer = element.initializer; return obj; }, toElementDescriptors: function (elementObjects) { if (elementObjects === undefined) return; return _toArray(elementObjects).map(function (elementObject) { var element = this.toElementDescriptor(elementObject); this.disallowProperty(elementObject, "finisher", "An element descriptor"); this.disallowProperty(elementObject, "extras", "An element descriptor"); return element; }, this); }, toElementDescriptor: function (elementObject) { var kind = String(elementObject.kind); if (kind !== "method" && kind !== "field") { throw new TypeError('An element descriptor\'s .kind property must be either "method" or' + ' "field", but a decorator created an element descriptor with' + ' .kind "' + kind + '"'); } var key = _toPropertyKey(elementObject.key); var placement = String(elementObject.placement); if (placement !== "static" && placement !== "prototype" && placement !== "own") { throw new TypeError('An element descriptor\'s .placement property must be one of "static",' + ' "prototype" or "own", but a decorator created an element descriptor' + ' with .placement "' + placement + '"'); } var descriptor = elementObject.descriptor; this.disallowProperty(elementObject, "elements", "An element descriptor"); var element = { kind: kind, key: key, placement: placement, descriptor: Object.assign({}, descriptor) }; if (kind !== "field") { this.disallowProperty(elementObject, "initializer", "A method descriptor"); } else { this.disallowProperty(descriptor, "get", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "set", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "value", "The property descriptor of a field descriptor"); element.initializer = elementObject.initializer; } return element; }, toElementFinisherExtras: function (elementObject) { var element = this.toElementDescriptor(elementObject); var finisher = _optionalCallableProperty(elementObject, "finisher"); var extras = this.toElementDescriptors(elementObject.extras); return { element: element, finisher: finisher, extras: extras }; }, fromClassDescriptor: function (elements) { var obj = { kind: "class", elements: elements.map(this.fromElementDescriptor, this) }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); return obj; }, toClassDescriptor: function (obj) { var kind = String(obj.kind); if (kind !== "class") { throw new TypeError('A class descriptor\'s .kind property must be "class", but a decorator' + ' created a class descriptor with .kind "' + kind + '"'); } this.disallowProperty(obj, "key", "A class descriptor"); this.disallowProperty(obj, "placement", "A class descriptor"); this.disallowProperty(obj, "descriptor", "A class descriptor"); this.disallowProperty(obj, "initializer", "A class descriptor"); this.disallowProperty(obj, "extras", "A class descriptor"); var finisher = _optionalCallableProperty(obj, "finisher"); var elements = this.toElementDescriptors(obj.elements); return { elements: elements, finisher: finisher }; }, runClassFinishers: function (constructor, finishers) { for (var i = 0; i < finishers.length; i++) { var newConstructor = (0, finishers[i])(constructor); if (newConstructor !== undefined) { if (typeof newConstructor !== "function") { throw new TypeError("Finishers must return a constructor."); } constructor = newConstructor; } } return constructor; }, disallowProperty: function (obj, name, objectType) { if (obj[name] !== undefined) { throw new TypeError(objectType + " can't have a ." + name + " property."); } } }; return api; }

function _createElementDescriptor(def) { var key = _toPropertyKey(def.key); var descriptor; if (def.kind === "method") { descriptor = { value: def.value, writable: true, configurable: true, enumerable: false }; } else if (def.kind === "get") { descriptor = { get: def.value, configurable: true, enumerable: false }; } else if (def.kind === "set") { descriptor = { set: def.value, configurable: true, enumerable: false }; } else if (def.kind === "field") { descriptor = { configurable: true, writable: true, enumerable: true }; } var element = { kind: def.kind === "field" ? "field" : "method", key: key, placement: def.static ? "static" : def.kind === "field" ? "own" : "prototype", descriptor: descriptor }; if (def.decorators) element.decorators = def.decorators; if (def.kind === "field") element.initializer = def.value; return element; }

function _coalesceGetterSetter(element, other) { if (element.descriptor.get !== undefined) { other.descriptor.get = element.descriptor.get; } else { other.descriptor.set = element.descriptor.set; } }

function _coalesceClassElements(elements) { var newElements = []; var isSameElement = function (other) { return other.kind === "method" && other.key === element.key && other.placement === element.placement; }; for (var i = 0; i < elements.length; i++) { var element = elements[i]; var other; if (element.kind === "method" && (other = newElements.find(isSameElement))) { if (_isDataDescriptor(element.descriptor) || _isDataDescriptor(other.descriptor)) { if (_hasDecorators(element) || _hasDecorators(other)) { throw new ReferenceError("Duplicated methods (" + element.key + ") can't be decorated."); } other.descriptor = element.descriptor; } else { if (_hasDecorators(element)) { if (_hasDecorators(other)) { throw new ReferenceError("Decorators can't be placed on different accessors with for " + "the same property (" + element.key + ")."); } other.decorators = element.decorators; } _coalesceGetterSetter(element, other); } } else { newElements.push(element); } } return newElements; }

function _hasDecorators(element) { return element.decorators && element.decorators.length; }

function _isDataDescriptor(desc) { return desc !== undefined && !(desc.value === undefined && desc.writable === undefined); }

function _optionalCallableProperty(obj, name) { var value = obj[name]; if (value !== undefined && typeof value !== "function") { throw new TypeError("Expected '" + name + "' to be a function"); } return value; }

function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }

function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }

function _toArray(arr) { return _arrayWithHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(n); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get; } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return _get(target, property, receiver || target); }

function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }










let HaConfigDevices = _decorate([Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["customElement"])("ha-config-devices")], function (_initialize, _HassRouterPage) {
  class HaConfigDevices extends _HassRouterPage {
    constructor(...args) {
      super(...args);

      _initialize(this);
    }

  }

  return {
    F: HaConfigDevices,
    d: [{
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "hass",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "narrow",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "isWide",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "showAdvanced",
      value: void 0
    }, {
      kind: "field",
      key: "routerOptions",

      value() {
        return {
          defaultPage: "dashboard",
          routes: {
            dashboard: {
              tag: "ha-config-devices-dashboard",
              cache: true
            },
            device: {
              tag: "ha-config-device-page"
            }
          }
        };
      }

    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "_configEntries",

      value() {
        return [];
      }

    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "_entityRegistryEntries",

      value() {
        return [];
      }

    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "_deviceRegistryEntries",

      value() {
        return [];
      }

    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "_areas",

      value() {
        return [];
      }

    }, {
      kind: "field",
      key: "_unsubs",
      value: void 0
    }, {
      kind: "method",
      key: "connectedCallback",
      value: function connectedCallback() {
        _get(_getPrototypeOf(HaConfigDevices.prototype), "connectedCallback", this).call(this);

        if (!this.hass) {
          return;
        }

        this._loadData();
      }
    }, {
      kind: "method",
      key: "disconnectedCallback",
      value: function disconnectedCallback() {
        _get(_getPrototypeOf(HaConfigDevices.prototype), "disconnectedCallback", this).call(this);

        if (this._unsubs) {
          while (this._unsubs.length) {
            this._unsubs.pop()();
          }

          this._unsubs = undefined;
        }
      }
    }, {
      kind: "method",
      key: "firstUpdated",
      value: function firstUpdated(changedProps) {
        _get(_getPrototypeOf(HaConfigDevices.prototype), "firstUpdated", this).call(this, changedProps);

        this.addEventListener("hass-reload-entries", () => {
          this._loadData();
        });
      }
    }, {
      kind: "method",
      key: "updated",
      value: function updated(changedProps) {
        _get(_getPrototypeOf(HaConfigDevices.prototype), "updated", this).call(this, changedProps);

        if (!this._unsubs && changedProps.has("hass")) {
          this._loadData();
        }
      }
    }, {
      kind: "method",
      key: "updatePageEl",
      value: function updatePageEl(pageEl) {
        pageEl.hass = this.hass;

        if (this._currentPage === "device") {
          pageEl.deviceId = this.routeTail.path.substr(1);
        }

        pageEl.entities = this._entityRegistryEntries;
        pageEl.entries = this._configEntries;
        pageEl.devices = this._deviceRegistryEntries;
        pageEl.areas = this._areas;
        pageEl.narrow = this.narrow;
        pageEl.isWide = this.isWide;
        pageEl.showAdvanced = this.showAdvanced;
        pageEl.route = this.routeTail;
      }
    }, {
      kind: "method",
      key: "_loadData",
      value: function _loadData() {
        Object(_data_config_entries__WEBPACK_IMPORTED_MODULE_2__["getConfigEntries"])(this.hass).then(configEntries => {
          this._configEntries = configEntries;
        });

        if (this._unsubs) {
          return;
        }

        this._unsubs = [Object(_data_area_registry__WEBPACK_IMPORTED_MODULE_1__["subscribeAreaRegistry"])(this.hass.connection, areas => {
          this._areas = areas;
        }), Object(_data_entity_registry__WEBPACK_IMPORTED_MODULE_4__["subscribeEntityRegistry"])(this.hass.connection, entries => {
          this._entityRegistryEntries = entries;
        }), Object(_data_device_registry__WEBPACK_IMPORTED_MODULE_3__["subscribeDeviceRegistry"])(this.hass.connection, entries => {
          this._deviceRegistryEntries = entries;
        })];
      }
    }]
  };
}, _layouts_hass_router_page__WEBPACK_IMPORTED_MODULE_5__["HassRouterPage"]);

/***/ }),

/***/ "./src/panels/config/entities/show-dialog-entity-editor.ts":
/*!*****************************************************************!*\
  !*** ./src/panels/config/entities/show-dialog-entity-editor.ts ***!
  \*****************************************************************/
/*! exports provided: loadEntityEditorDialog, showEntityEditorDialog */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "loadEntityEditorDialog", function() { return loadEntityEditorDialog; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "showEntityEditorDialog", function() { return showEntityEditorDialog; });
/* harmony import */ var _common_dom_fire_event__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../common/dom/fire_event */ "./src/common/dom/fire_event.ts");

const loadEntityEditorDialog = () => Promise.all(/*! import() | entity-editor-dialog */[__webpack_require__.e(1), __webpack_require__.e(0), __webpack_require__.e(2), __webpack_require__.e("vendors~cloud-webhook-manage-dialog~config-entry-system-options~confirmation~device-registry-detail-~836e8839"), __webpack_require__.e(13), __webpack_require__.e("vendors~entity-editor-dialog~hui-conditional-card-editor~hui-stack-card-editor~panel-developer-tools~838abec3"), __webpack_require__.e("vendors~entity-editor-dialog"), __webpack_require__.e(14), __webpack_require__.e("device-registry-detail-dialog~dialog-config-flow~entity-editor-dialog~panel-config-automation~panel-~da811c14"), __webpack_require__.e("entity-editor-dialog~helper-detail-dialog~hui-button-card-editor~hui-entity-card-editor~hui-light-ca~1d54093c"), __webpack_require__.e("entity-editor-dialog")]).then(__webpack_require__.bind(null, /*! ./dialog-entity-editor */ "./src/panels/config/entities/dialog-entity-editor.ts"));

const getDialog = () => {
  return document.querySelector("home-assistant").shadowRoot.querySelector("dialog-entity-editor");
};

const showEntityEditorDialog = (element, entityDetailParams) => {
  Object(_common_dom_fire_event__WEBPACK_IMPORTED_MODULE_0__["fireEvent"])(element, "show-dialog", {
    dialogTag: "dialog-entity-editor",
    dialogImport: loadEntityEditorDialog,
    dialogParams: entityDetailParams
  });
  return getDialog;
};

/***/ }),

/***/ "./src/panels/lovelace/editor/add-entities-to-view.ts":
/*!************************************************************!*\
  !*** ./src/panels/lovelace/editor/add-entities-to-view.ts ***!
  \************************************************************/
/*! exports provided: addEntitiesToLovelaceView */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "addEntitiesToLovelaceView", function() { return addEntitiesToLovelaceView; });
/* harmony import */ var _data_lovelace__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../data/lovelace */ "./src/data/lovelace.ts");
/* harmony import */ var _card_editor_show_suggest_card_dialog__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./card-editor/show-suggest-card-dialog */ "./src/panels/lovelace/editor/card-editor/show-suggest-card-dialog.ts");
/* harmony import */ var _select_view_show_select_view_dialog__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./select-view/show-select-view-dialog */ "./src/panels/lovelace/editor/select-view/show-select-view-dialog.ts");



const addEntitiesToLovelaceView = async (element, hass, entities, lovelaceConfig, saveConfigFunc) => {
  var _ref, _panels$lovelace;

  if (((_ref = (_panels$lovelace = hass.panels.lovelace) === null || _panels$lovelace === void 0 ? void 0 : _panels$lovelace.config) === null || _ref === void 0 ? void 0 : _ref.mode) === "yaml") {
    Object(_card_editor_show_suggest_card_dialog__WEBPACK_IMPORTED_MODULE_1__["showSuggestCardDialog"])(element, {
      entities
    });
    return;
  }

  if (!lovelaceConfig) {
    try {
      lovelaceConfig = await Object(_data_lovelace__WEBPACK_IMPORTED_MODULE_0__["fetchConfig"])(hass.connection, null, false);
    } catch {
      alert(hass.localize("ui.panel.lovelace.editor.add_entities.generated_unsupported"));
      return;
    }
  }

  if (!lovelaceConfig.views.length) {
    alert("You don't have any Lovelace views, first create a view in Lovelace.");
    return;
  }

  if (!saveConfigFunc) {
    saveConfigFunc = async newConfig => {
      try {
        await Object(_data_lovelace__WEBPACK_IMPORTED_MODULE_0__["saveConfig"])(hass, null, newConfig);
      } catch {
        alert(hass.localize("ui.panel.config.devices.add_entities.saving_failed"));
      }
    };
  }

  if (lovelaceConfig.views.length === 1) {
    Object(_card_editor_show_suggest_card_dialog__WEBPACK_IMPORTED_MODULE_1__["showSuggestCardDialog"])(element, {
      lovelaceConfig: lovelaceConfig,
      saveConfig: saveConfigFunc,
      path: [0],
      entities
    });
    return;
  }

  Object(_select_view_show_select_view_dialog__WEBPACK_IMPORTED_MODULE_2__["showSelectViewDialog"])(element, {
    lovelaceConfig,
    viewSelectedCallback: view => {
      Object(_card_editor_show_suggest_card_dialog__WEBPACK_IMPORTED_MODULE_1__["showSuggestCardDialog"])(element, {
        lovelaceConfig: lovelaceConfig,
        saveConfig: saveConfigFunc,
        path: [view],
        entities
      });
    }
  });
};

/***/ }),

/***/ "./src/panels/lovelace/editor/card-editor/show-suggest-card-dialog.ts":
/*!****************************************************************************!*\
  !*** ./src/panels/lovelace/editor/card-editor/show-suggest-card-dialog.ts ***!
  \****************************************************************************/
/*! exports provided: showSuggestCardDialog */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "showSuggestCardDialog", function() { return showSuggestCardDialog; });
/* harmony import */ var _common_dom_fire_event__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../common/dom/fire_event */ "./src/common/dom/fire_event.ts");


const importsuggestCardDialog = () => Promise.all(/*! import() | hui-dialog-suggest-card */[__webpack_require__.e(1), __webpack_require__.e("vendors~cloud-webhook-manage-dialog~config-entry-system-options~confirmation~device-registry-detail-~836e8839"), __webpack_require__.e(13), __webpack_require__.e("vendors~hui-button-card-editor~hui-dialog-delete-card~hui-dialog-edit-card~hui-dialog-suggest-card~h~a8cf51a3"), __webpack_require__.e(17), __webpack_require__.e("vendors~dialog-config-flow~ha-mfa-module-setup-flow~hui-dialog-suggest-card~more-info-dialog~panel-c~e54ccf84"), __webpack_require__.e("vendors~hui-dialog-suggest-card~more-info-dialog~panel-history~panel-lovelace"), __webpack_require__.e("vendors~dialog-config-flow~dialog-zha-device-zigbee-info~hui-dialog-suggest-card~more-info-dialog"), __webpack_require__.e("vendors~hui-dialog-suggest-card~panel-lovelace"), __webpack_require__.e(14), __webpack_require__.e(18), __webpack_require__.e("hui-dialog-suggest-card~more-info-dialog~panel-config-automation~panel-config-devices~panel-lovelace"), __webpack_require__.e("hui-dialog-suggest-card~more-info-dialog~panel-history~panel-lovelace"), __webpack_require__.e("hui-dialog-save-config~hui-dialog-suggest-card~panel-config-automation~panel-config-script"), __webpack_require__.e("hui-dialog-suggest-card~panel-config-devices~panel-lovelace"), __webpack_require__.e("hui-dialog-suggest-card~panel-lovelace"), __webpack_require__.e("hui-dialog-suggest-card")]).then(__webpack_require__.bind(null, /*! ./hui-dialog-suggest-card */ "./src/panels/lovelace/editor/card-editor/hui-dialog-suggest-card.ts"));

const showSuggestCardDialog = (element, suggestCardDialogParams) => {
  Object(_common_dom_fire_event__WEBPACK_IMPORTED_MODULE_0__["fireEvent"])(element, "show-dialog", {
    dialogTag: "hui-dialog-suggest-card",
    dialogImport: importsuggestCardDialog,
    dialogParams: suggestCardDialogParams
  });
};

/***/ }),

/***/ "./src/panels/lovelace/editor/select-view/show-select-view-dialog.ts":
/*!***************************************************************************!*\
  !*** ./src/panels/lovelace/editor/select-view/show-select-view-dialog.ts ***!
  \***************************************************************************/
/*! exports provided: showSelectViewDialog */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "showSelectViewDialog", function() { return showSelectViewDialog; });
/* harmony import */ var _common_dom_fire_event__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../common/dom/fire_event */ "./src/common/dom/fire_event.ts");

const showSelectViewDialog = (element, selectViewDialogParams) => {
  Object(_common_dom_fire_event__WEBPACK_IMPORTED_MODULE_0__["fireEvent"])(element, "show-dialog", {
    dialogTag: "hui-dialog-select-view",
    dialogImport: () => Promise.all(/*! import() | hui-dialog-select-view */[__webpack_require__.e(1), __webpack_require__.e(0), __webpack_require__.e(2), __webpack_require__.e("vendors~cloud-webhook-manage-dialog~config-entry-system-options~confirmation~device-registry-detail-~836e8839"), __webpack_require__.e("vendors~hui-dialog-select-view"), __webpack_require__.e("hui-dialog-move-card-view~hui-dialog-select-view"), __webpack_require__.e("hui-dialog-select-view")]).then(__webpack_require__.bind(null, /*! ./hui-dialog-select-view */ "./src/panels/lovelace/editor/select-view/hui-dialog-select-view.ts")),
    dialogParams: selectViewDialogParams
  });
};

/***/ })

}]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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