(self["webpackJsonp"] = self["webpackJsonp"] || []).push([["hui-dialog-suggest-card~panel-lovelace"],{

/***/ "./src/common/entity/extract_views.ts":
/*!********************************************!*\
  !*** ./src/common/entity/extract_views.ts ***!
  \********************************************/
/*! exports provided: extractViews */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "extractViews", function() { return extractViews; });
/* harmony import */ var _const__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../const */ "./src/common/const.ts");
 // Return an ordered array of available views

const extractViews = entities => {
  const views = [];
  Object.keys(entities).forEach(entityId => {
    const entity = entities[entityId];

    if (entity.attributes.view) {
      views.push(entity);
    }
  });
  views.sort((view1, view2) => {
    if (view1.entity_id === _const__WEBPACK_IMPORTED_MODULE_0__["DEFAULT_VIEW_ENTITY_ID"]) {
      return -1;
    }

    if (view2.entity_id === _const__WEBPACK_IMPORTED_MODULE_0__["DEFAULT_VIEW_ENTITY_ID"]) {
      return 1;
    }

    return view1.attributes.order - view2.attributes.order;
  });
  return views;
};

/***/ }),

/***/ "./src/common/entity/get_group_entities.ts":
/*!*************************************************!*\
  !*** ./src/common/entity/get_group_entities.ts ***!
  \*************************************************/
/*! exports provided: getGroupEntities */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getGroupEntities", function() { return getGroupEntities; });
const getGroupEntities = (entities, group) => {
  const result = {};
  group.attributes.entity_id.forEach(entityId => {
    const entity = entities[entityId];

    if (entity) {
      result[entity.entity_id] = entity;
    }
  });
  return result;
};

/***/ }),

/***/ "./src/common/entity/get_view_entities.ts":
/*!************************************************!*\
  !*** ./src/common/entity/get_view_entities.ts ***!
  \************************************************/
/*! exports provided: getViewEntities */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getViewEntities", function() { return getViewEntities; });
/* harmony import */ var _compute_domain__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./compute_domain */ "./src/common/entity/compute_domain.ts");
/* harmony import */ var _get_group_entities__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./get_group_entities */ "./src/common/entity/get_group_entities.ts");

 // Return an object containing all entities that the view will show
// including embedded groups.

const getViewEntities = (entities, view) => {
  const viewEntities = {};
  view.attributes.entity_id.forEach(entityId => {
    const entity = entities[entityId];

    if (entity && !entity.attributes.hidden) {
      viewEntities[entity.entity_id] = entity;

      if (Object(_compute_domain__WEBPACK_IMPORTED_MODULE_0__["computeDomain"])(entity.entity_id) === "group") {
        const groupEntities = Object(_get_group_entities__WEBPACK_IMPORTED_MODULE_1__["getGroupEntities"])(entities, entity);
        Object.keys(groupEntities).forEach(grEntityId => {
          const grEntity = groupEntities[grEntityId];

          if (!grEntity.attributes.hidden) {
            viewEntities[grEntityId] = grEntity;
          }
        });
      }
    }
  });
  return viewEntities;
};

/***/ }),

/***/ "./src/common/entity/split_by_groups.ts":
/*!**********************************************!*\
  !*** ./src/common/entity/split_by_groups.ts ***!
  \**********************************************/
/*! exports provided: splitByGroups */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "splitByGroups", function() { return splitByGroups; });
/* harmony import */ var _compute_domain__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./compute_domain */ "./src/common/entity/compute_domain.ts");
 // Split a collection into a list of groups and a 'rest' list of ungrouped
// entities.
// Returns { groups: [], ungrouped: {} }

const splitByGroups = entities => {
  const groups = [];
  const ungrouped = {};
  Object.keys(entities).forEach(entityId => {
    const entity = entities[entityId];

    if (Object(_compute_domain__WEBPACK_IMPORTED_MODULE_0__["computeDomain"])(entityId) === "group") {
      groups.push(entity);
    } else {
      ungrouped[entityId] = entity;
    }
  });
  groups.forEach(group => group.attributes.entity_id.forEach(entityId => {
    delete ungrouped[entityId];
  }));
  return {
    groups,
    ungrouped
  };
};

/***/ }),

/***/ "./src/common/util/render-status.ts":
/*!******************************************!*\
  !*** ./src/common/util/render-status.ts ***!
  \******************************************/
/*! exports provided: afterNextRender, nextRender */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "afterNextRender", function() { return afterNextRender; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "nextRender", function() { return nextRender; });
const afterNextRender = cb => {
  requestAnimationFrame(() => setTimeout(cb, 0));
};
const nextRender = () => {
  return new Promise(resolve => {
    afterNextRender(resolve);
  });
};

/***/ }),

/***/ "./src/common/util/subscribe-one.ts":
/*!******************************************!*\
  !*** ./src/common/util/subscribe-one.ts ***!
  \******************************************/
/*! exports provided: subscribeOne */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "subscribeOne", function() { return subscribeOne; });
const subscribeOne = async (conn, subscribe) => new Promise(resolve => {
  const unsub = subscribe(conn, items => {
    unsub();
    resolve(items);
  });
});

/***/ }),

/***/ "./src/data/climate.ts":
/*!*****************************!*\
  !*** ./src/data/climate.ts ***!
  \*****************************/
/*! exports provided: CLIMATE_PRESET_NONE, CLIMATE_SUPPORT_TARGET_TEMPERATURE, CLIMATE_SUPPORT_TARGET_TEMPERATURE_RANGE, CLIMATE_SUPPORT_TARGET_HUMIDITY, CLIMATE_SUPPORT_FAN_MODE, CLIMATE_SUPPORT_PRESET_MODE, CLIMATE_SUPPORT_SWING_MODE, CLIMATE_SUPPORT_AUX_HEAT, compareClimateHvacModes */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CLIMATE_PRESET_NONE", function() { return CLIMATE_PRESET_NONE; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CLIMATE_SUPPORT_TARGET_TEMPERATURE", function() { return CLIMATE_SUPPORT_TARGET_TEMPERATURE; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CLIMATE_SUPPORT_TARGET_TEMPERATURE_RANGE", function() { return CLIMATE_SUPPORT_TARGET_TEMPERATURE_RANGE; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CLIMATE_SUPPORT_TARGET_HUMIDITY", function() { return CLIMATE_SUPPORT_TARGET_HUMIDITY; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CLIMATE_SUPPORT_FAN_MODE", function() { return CLIMATE_SUPPORT_FAN_MODE; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CLIMATE_SUPPORT_PRESET_MODE", function() { return CLIMATE_SUPPORT_PRESET_MODE; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CLIMATE_SUPPORT_SWING_MODE", function() { return CLIMATE_SUPPORT_SWING_MODE; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CLIMATE_SUPPORT_AUX_HEAT", function() { return CLIMATE_SUPPORT_AUX_HEAT; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "compareClimateHvacModes", function() { return compareClimateHvacModes; });
const CLIMATE_PRESET_NONE = "none";
const CLIMATE_SUPPORT_TARGET_TEMPERATURE = 1;
const CLIMATE_SUPPORT_TARGET_TEMPERATURE_RANGE = 2;
const CLIMATE_SUPPORT_TARGET_HUMIDITY = 4;
const CLIMATE_SUPPORT_FAN_MODE = 8;
const CLIMATE_SUPPORT_PRESET_MODE = 16;
const CLIMATE_SUPPORT_SWING_MODE = 32;
const CLIMATE_SUPPORT_AUX_HEAT = 64;
const hvacModeOrdering = {
  auto: 1,
  heat_cool: 2,
  heat: 3,
  cool: 4,
  dry: 5,
  fan_only: 6,
  off: 7
};
const compareClimateHvacModes = (mode1, mode2) => hvacModeOrdering[mode1] - hvacModeOrdering[mode2];

/***/ }),

/***/ "./src/data/light.ts":
/*!***************************!*\
  !*** ./src/data/light.ts ***!
  \***************************/
/*! exports provided: SUPPORT_BRIGHTNESS, SUPPORT_COLOR_TEMP, SUPPORT_EFFECT, SUPPORT_FLASH, SUPPORT_COLOR, SUPPORT_TRANSITION, SUPPORT_WHITE_VALUE */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SUPPORT_BRIGHTNESS", function() { return SUPPORT_BRIGHTNESS; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SUPPORT_COLOR_TEMP", function() { return SUPPORT_COLOR_TEMP; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SUPPORT_EFFECT", function() { return SUPPORT_EFFECT; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SUPPORT_FLASH", function() { return SUPPORT_FLASH; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SUPPORT_COLOR", function() { return SUPPORT_COLOR; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SUPPORT_TRANSITION", function() { return SUPPORT_TRANSITION; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SUPPORT_WHITE_VALUE", function() { return SUPPORT_WHITE_VALUE; });
const SUPPORT_BRIGHTNESS = 1;
const SUPPORT_COLOR_TEMP = 2;
const SUPPORT_EFFECT = 4;
const SUPPORT_FLASH = 8;
const SUPPORT_COLOR = 16;
const SUPPORT_TRANSITION = 32;
const SUPPORT_WHITE_VALUE = 128;

/***/ }),

/***/ "./src/data/weather.ts":
/*!*****************************!*\
  !*** ./src/data/weather.ts ***!
  \*****************************/
/*! exports provided: weatherImages, weatherIcons, cardinalDirections, getWindBearing, getWeatherUnit, getSecondaryWeatherAttribute */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "weatherImages", function() { return weatherImages; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "weatherIcons", function() { return weatherIcons; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "cardinalDirections", function() { return cardinalDirections; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getWindBearing", function() { return getWindBearing; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getWeatherUnit", function() { return getWeatherUnit; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getSecondaryWeatherAttribute", function() { return getSecondaryWeatherAttribute; });
const weatherImages = {
  "clear-night": "/static/images/weather/night.png",
  cloudy: "/static/images/weather/cloudy.png",
  fog: "/static/images/weather/cloudy.png",
  lightning: "/static/images/weather/lightning.png",
  "lightning-rainy": "/static/images/weather/lightning-rainy.png",
  partlycloudy: "/static/images/weather/partly-cloudy.png",
  pouring: "/static/images/weather/pouring.png",
  rainy: "/static/images/weather/rainy.png",
  hail: "/static/images/weather/rainy.png",
  snowy: "/static/images/weather/snowy.png",
  "snowy-rainy": "/static/images/weather/snowy.png",
  sunny: "/static/images/weather/sunny.png",
  windy: "/static/images/weather/windy.png",
  "windy-variant": "/static/images/weather/windy.png"
};
const weatherIcons = {
  exceptional: "hass:alert-circle-outline"
};
const cardinalDirections = ["N", "NNE", "NE", "ENE", "E", "ESE", "SE", "SSE", "S", "SSW", "SW", "WSW", "W", "WNW", "NW", "NNW", "N"];

const getWindBearingText = degree => {
  const degreenum = parseInt(degree, 10);

  if (isFinite(degreenum)) {
    // eslint-disable-next-line no-bitwise
    return cardinalDirections[((degreenum + 11.25) / 22.5 | 0) % 16];
  }

  return degree;
};

const getWindBearing = bearing => {
  if (bearing != null) {
    return getWindBearingText(bearing);
  }

  return "";
};
const getWeatherUnit = (hass, measure) => {
  const lengthUnit = hass.config.unit_system.length || "";

  switch (measure) {
    case "pressure":
      return lengthUnit === "km" ? "hPa" : "inHg";

    case "wind_speed":
      return `${lengthUnit}/h`;

    case "length":
      return lengthUnit;

    case "precipitation":
      return lengthUnit === "km" ? "mm" : "in";

    case "humidity":
    case "precipitation_probability":
      return "%";

    default:
      return hass.config.unit_system[measure] || "";
  }
};
const getSecondaryWeatherAttribute = (hass, stateObj) => {
  var _stateObj$attributes$;

  const extrema = getWeatherExtrema(hass, stateObj);

  if (extrema) {
    return extrema;
  }

  let value;
  let attribute;

  if (((_stateObj$attributes$ = stateObj.attributes.forecast) === null || _stateObj$attributes$ === void 0 ? void 0 : _stateObj$attributes$.length) && stateObj.attributes.forecast[0].precipitation !== undefined && stateObj.attributes.forecast[0].precipitation !== null) {
    value = stateObj.attributes.forecast[0].precipitation;
    attribute = "precipitation";
  } else if ("humidity" in stateObj.attributes) {
    value = stateObj.attributes.humidity;
    attribute = "humidity";
  } else {
    return undefined;
  }

  return `
    ${hass.localize(`ui.card.weather.attributes.${attribute}`)} ${value} ${getWeatherUnit(hass, attribute)}
  `;
};

const getWeatherExtrema = (hass, stateObj) => {
  var _stateObj$attributes$2;

  if (!((_stateObj$attributes$2 = stateObj.attributes.forecast) === null || _stateObj$attributes$2 === void 0 ? void 0 : _stateObj$attributes$2.length)) {
    return undefined;
  }

  let tempLow;
  let tempHigh;
  const today = new Date().getDate();

  for (const forecast of stateObj.attributes.forecast) {
    if (new Date(forecast.datetime).getDate() !== today) {
      break;
    }

    if (!tempHigh || forecast.temperature > tempHigh) {
      tempHigh = forecast.temperature;
    }

    if (!tempLow || forecast.templow && forecast.templow < tempLow) {
      tempLow = forecast.templow;
    }

    if (!forecast.templow && (!tempLow || forecast.temperature < tempLow)) {
      tempLow = forecast.temperature;
    }
  }

  if (!tempLow && !tempHigh) {
    return undefined;
  }

  const unit = getWeatherUnit(hass, "temperature");
  return `
    ${tempHigh ? `
            ${tempHigh} ${unit}
          ` : ""}
    ${tempLow && tempHigh ? " / " : ""}
    ${tempLow ? `
          ${tempLow} ${unit}
        ` : ""}
  `;
};

/***/ }),

/***/ "./src/panels/lovelace/cards/hui-button-card.ts":
/*!******************************************************!*\
  !*** ./src/panels/lovelace/cards/hui-button-card.ts ***!
  \******************************************************/
/*! exports provided: HuiButtonCard */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HuiButtonCard", function() { return HuiButtonCard; });
/* harmony import */ var _material_mwc_ripple__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @material/mwc-ripple */ "./node_modules/@material/mwc-ripple/mwc-ripple.js");
/* harmony import */ var lit_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lit-element */ "./node_modules/lit-element/lit-element.js");
/* harmony import */ var lit_html_directives_if_defined__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lit-html/directives/if-defined */ "./node_modules/lit-html/directives/if-defined.js");
/* harmony import */ var lit_html_directives_style_map__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lit-html/directives/style-map */ "./node_modules/lit-html/directives/style-map.js");
/* harmony import */ var _common_const__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../common/const */ "./src/common/const.ts");
/* harmony import */ var _common_dom_apply_themes_on_element__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../common/dom/apply_themes_on_element */ "./src/common/dom/apply_themes_on_element.ts");
/* harmony import */ var _common_entity_compute_active_state__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../common/entity/compute_active_state */ "./src/common/entity/compute_active_state.ts");
/* harmony import */ var _common_entity_compute_domain__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../common/entity/compute_domain */ "./src/common/entity/compute_domain.ts");
/* harmony import */ var _common_entity_compute_state_domain__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../common/entity/compute_state_domain */ "./src/common/entity/compute_state_domain.ts");
/* harmony import */ var _common_entity_compute_state_name__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../../common/entity/compute_state_name */ "./src/common/entity/compute_state_name.ts");
/* harmony import */ var _common_entity_state_icon__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../../common/entity/state_icon */ "./src/common/entity/state_icon.ts");
/* harmony import */ var _common_entity_valid_entity_id__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../../common/entity/valid_entity_id */ "./src/common/entity/valid_entity_id.ts");
/* harmony import */ var _common_style_icon_color_css__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../../common/style/icon_color_css */ "./src/common/style/icon_color_css.ts");
/* harmony import */ var _components_ha_card__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../../components/ha-card */ "./src/components/ha-card.ts");
/* harmony import */ var _common_directives_action_handler_directive__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../common/directives/action-handler-directive */ "./src/panels/lovelace/common/directives/action-handler-directive.ts");
/* harmony import */ var _common_find_entites__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../common/find-entites */ "./src/panels/lovelace/common/find-entites.ts");
/* harmony import */ var _common_handle_action__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../common/handle-action */ "./src/panels/lovelace/common/handle-action.ts");
/* harmony import */ var _common_has_action__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../common/has-action */ "./src/panels/lovelace/common/has-action.ts");
/* harmony import */ var _components_hui_warning__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../components/hui-warning */ "./src/panels/lovelace/components/hui-warning.ts");
function _decorate(decorators, factory, superClass, mixins) { var api = _getDecoratorsApi(); if (mixins) { for (var i = 0; i < mixins.length; i++) { api = mixins[i](api); } } var r = factory(function initialize(O) { api.initializeInstanceElements(O, decorated.elements); }, superClass); var decorated = api.decorateClass(_coalesceClassElements(r.d.map(_createElementDescriptor)), decorators); api.initializeClassElements(r.F, decorated.elements); return api.runClassFinishers(r.F, decorated.finishers); }

function _getDecoratorsApi() { _getDecoratorsApi = function () { return api; }; var api = { elementsDefinitionOrder: [["method"], ["field"]], initializeInstanceElements: function (O, elements) { ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { if (element.kind === kind && element.placement === "own") { this.defineClassElement(O, element); } }, this); }, this); }, initializeClassElements: function (F, elements) { var proto = F.prototype; ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { var placement = element.placement; if (element.kind === kind && (placement === "static" || placement === "prototype")) { var receiver = placement === "static" ? F : proto; this.defineClassElement(receiver, element); } }, this); }, this); }, defineClassElement: function (receiver, element) { var descriptor = element.descriptor; if (element.kind === "field") { var initializer = element.initializer; descriptor = { enumerable: descriptor.enumerable, writable: descriptor.writable, configurable: descriptor.configurable, value: initializer === void 0 ? void 0 : initializer.call(receiver) }; } Object.defineProperty(receiver, element.key, descriptor); }, decorateClass: function (elements, decorators) { var newElements = []; var finishers = []; var placements = { static: [], prototype: [], own: [] }; elements.forEach(function (element) { this.addElementPlacement(element, placements); }, this); elements.forEach(function (element) { if (!_hasDecorators(element)) return newElements.push(element); var elementFinishersExtras = this.decorateElement(element, placements); newElements.push(elementFinishersExtras.element); newElements.push.apply(newElements, elementFinishersExtras.extras); finishers.push.apply(finishers, elementFinishersExtras.finishers); }, this); if (!decorators) { return { elements: newElements, finishers: finishers }; } var result = this.decorateConstructor(newElements, decorators); finishers.push.apply(finishers, result.finishers); result.finishers = finishers; return result; }, addElementPlacement: function (element, placements, silent) { var keys = placements[element.placement]; if (!silent && keys.indexOf(element.key) !== -1) { throw new TypeError("Duplicated element (" + element.key + ")"); } keys.push(element.key); }, decorateElement: function (element, placements) { var extras = []; var finishers = []; for (var decorators = element.decorators, i = decorators.length - 1; i >= 0; i--) { var keys = placements[element.placement]; keys.splice(keys.indexOf(element.key), 1); var elementObject = this.fromElementDescriptor(element); var elementFinisherExtras = this.toElementFinisherExtras((0, decorators[i])(elementObject) || elementObject); element = elementFinisherExtras.element; this.addElementPlacement(element, placements); if (elementFinisherExtras.finisher) { finishers.push(elementFinisherExtras.finisher); } var newExtras = elementFinisherExtras.extras; if (newExtras) { for (var j = 0; j < newExtras.length; j++) { this.addElementPlacement(newExtras[j], placements); } extras.push.apply(extras, newExtras); } } return { element: element, finishers: finishers, extras: extras }; }, decorateConstructor: function (elements, decorators) { var finishers = []; for (var i = decorators.length - 1; i >= 0; i--) { var obj = this.fromClassDescriptor(elements); var elementsAndFinisher = this.toClassDescriptor((0, decorators[i])(obj) || obj); if (elementsAndFinisher.finisher !== undefined) { finishers.push(elementsAndFinisher.finisher); } if (elementsAndFinisher.elements !== undefined) { elements = elementsAndFinisher.elements; for (var j = 0; j < elements.length - 1; j++) { for (var k = j + 1; k < elements.length; k++) { if (elements[j].key === elements[k].key && elements[j].placement === elements[k].placement) { throw new TypeError("Duplicated element (" + elements[j].key + ")"); } } } } } return { elements: elements, finishers: finishers }; }, fromElementDescriptor: function (element) { var obj = { kind: element.kind, key: element.key, placement: element.placement, descriptor: element.descriptor }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); if (element.kind === "field") obj.initializer = element.initializer; return obj; }, toElementDescriptors: function (elementObjects) { if (elementObjects === undefined) return; return _toArray(elementObjects).map(function (elementObject) { var element = this.toElementDescriptor(elementObject); this.disallowProperty(elementObject, "finisher", "An element descriptor"); this.disallowProperty(elementObject, "extras", "An element descriptor"); return element; }, this); }, toElementDescriptor: function (elementObject) { var kind = String(elementObject.kind); if (kind !== "method" && kind !== "field") { throw new TypeError('An element descriptor\'s .kind property must be either "method" or' + ' "field", but a decorator created an element descriptor with' + ' .kind "' + kind + '"'); } var key = _toPropertyKey(elementObject.key); var placement = String(elementObject.placement); if (placement !== "static" && placement !== "prototype" && placement !== "own") { throw new TypeError('An element descriptor\'s .placement property must be one of "static",' + ' "prototype" or "own", but a decorator created an element descriptor' + ' with .placement "' + placement + '"'); } var descriptor = elementObject.descriptor; this.disallowProperty(elementObject, "elements", "An element descriptor"); var element = { kind: kind, key: key, placement: placement, descriptor: Object.assign({}, descriptor) }; if (kind !== "field") { this.disallowProperty(elementObject, "initializer", "A method descriptor"); } else { this.disallowProperty(descriptor, "get", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "set", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "value", "The property descriptor of a field descriptor"); element.initializer = elementObject.initializer; } return element; }, toElementFinisherExtras: function (elementObject) { var element = this.toElementDescriptor(elementObject); var finisher = _optionalCallableProperty(elementObject, "finisher"); var extras = this.toElementDescriptors(elementObject.extras); return { element: element, finisher: finisher, extras: extras }; }, fromClassDescriptor: function (elements) { var obj = { kind: "class", elements: elements.map(this.fromElementDescriptor, this) }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); return obj; }, toClassDescriptor: function (obj) { var kind = String(obj.kind); if (kind !== "class") { throw new TypeError('A class descriptor\'s .kind property must be "class", but a decorator' + ' created a class descriptor with .kind "' + kind + '"'); } this.disallowProperty(obj, "key", "A class descriptor"); this.disallowProperty(obj, "placement", "A class descriptor"); this.disallowProperty(obj, "descriptor", "A class descriptor"); this.disallowProperty(obj, "initializer", "A class descriptor"); this.disallowProperty(obj, "extras", "A class descriptor"); var finisher = _optionalCallableProperty(obj, "finisher"); var elements = this.toElementDescriptors(obj.elements); return { elements: elements, finisher: finisher }; }, runClassFinishers: function (constructor, finishers) { for (var i = 0; i < finishers.length; i++) { var newConstructor = (0, finishers[i])(constructor); if (newConstructor !== undefined) { if (typeof newConstructor !== "function") { throw new TypeError("Finishers must return a constructor."); } constructor = newConstructor; } } return constructor; }, disallowProperty: function (obj, name, objectType) { if (obj[name] !== undefined) { throw new TypeError(objectType + " can't have a ." + name + " property."); } } }; return api; }

function _createElementDescriptor(def) { var key = _toPropertyKey(def.key); var descriptor; if (def.kind === "method") { descriptor = { value: def.value, writable: true, configurable: true, enumerable: false }; } else if (def.kind === "get") { descriptor = { get: def.value, configurable: true, enumerable: false }; } else if (def.kind === "set") { descriptor = { set: def.value, configurable: true, enumerable: false }; } else if (def.kind === "field") { descriptor = { configurable: true, writable: true, enumerable: true }; } var element = { kind: def.kind === "field" ? "field" : "method", key: key, placement: def.static ? "static" : def.kind === "field" ? "own" : "prototype", descriptor: descriptor }; if (def.decorators) element.decorators = def.decorators; if (def.kind === "field") element.initializer = def.value; return element; }

function _coalesceGetterSetter(element, other) { if (element.descriptor.get !== undefined) { other.descriptor.get = element.descriptor.get; } else { other.descriptor.set = element.descriptor.set; } }

function _coalesceClassElements(elements) { var newElements = []; var isSameElement = function (other) { return other.kind === "method" && other.key === element.key && other.placement === element.placement; }; for (var i = 0; i < elements.length; i++) { var element = elements[i]; var other; if (element.kind === "method" && (other = newElements.find(isSameElement))) { if (_isDataDescriptor(element.descriptor) || _isDataDescriptor(other.descriptor)) { if (_hasDecorators(element) || _hasDecorators(other)) { throw new ReferenceError("Duplicated methods (" + element.key + ") can't be decorated."); } other.descriptor = element.descriptor; } else { if (_hasDecorators(element)) { if (_hasDecorators(other)) { throw new ReferenceError("Decorators can't be placed on different accessors with for " + "the same property (" + element.key + ")."); } other.decorators = element.decorators; } _coalesceGetterSetter(element, other); } } else { newElements.push(element); } } return newElements; }

function _hasDecorators(element) { return element.decorators && element.decorators.length; }

function _isDataDescriptor(desc) { return desc !== undefined && !(desc.value === undefined && desc.writable === undefined); }

function _optionalCallableProperty(obj, name) { var value = obj[name]; if (value !== undefined && typeof value !== "function") { throw new TypeError("Expected '" + name + "' to be a function"); } return value; }

function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }

function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }

function _toArray(arr) { return _arrayWithHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(n); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get; } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return _get(target, property, receiver || target); }

function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }




















let HuiButtonCard = _decorate([Object(lit_element__WEBPACK_IMPORTED_MODULE_1__["customElement"])("hui-button-card")], function (_initialize, _LitElement) {
  class HuiButtonCard extends _LitElement {
    constructor(...args) {
      super(...args);

      _initialize(this);
    }

  }

  return {
    F: HuiButtonCard,
    d: [{
      kind: "method",
      static: true,
      key: "getConfigElement",
      value: async function getConfigElement() {
        await Promise.all(/*! import() | hui-button-card-editor */[__webpack_require__.e(1), __webpack_require__.e(0), __webpack_require__.e(2), __webpack_require__.e(3), __webpack_require__.e(6), __webpack_require__.e(7), __webpack_require__.e(8), __webpack_require__.e("vendors~hui-alarm-panel-card-editor~hui-button-card-editor~hui-conditional-card-editor~hui-entities-~37aad430"), __webpack_require__.e("vendors~hui-button-card-editor~hui-dialog-delete-card~hui-dialog-edit-card~hui-dialog-suggest-card~h~a8cf51a3"), __webpack_require__.e("vendors~hui-button-card-editor"), __webpack_require__.e(10), __webpack_require__.e("hui-alarm-panel-card-editor~hui-button-card-editor~hui-dialog-edit-view~hui-entities-card-editor~hui~192a43f6"), __webpack_require__.e("hui-button-card-editor~hui-dialog-edit-view~hui-entities-card-editor~hui-entity-card-editor~hui-gaug~aa2f21d6"), __webpack_require__.e("entity-editor-dialog~helper-detail-dialog~hui-button-card-editor~hui-entity-card-editor~hui-light-ca~1d54093c"), __webpack_require__.e("hui-button-card-editor~hui-entity-card-editor~hui-light-card-editor~hui-picture-card-editor~hui-pict~6832566a"), __webpack_require__.e("hui-button-card-editor")]).then(__webpack_require__.bind(null, /*! ../editor/config-elements/hui-button-card-editor */ "./src/panels/lovelace/editor/config-elements/hui-button-card-editor.ts"));
        return document.createElement("hui-button-card-editor");
      }
    }, {
      kind: "method",
      static: true,
      key: "getStubConfig",
      value: function getStubConfig(hass, entities, entitiesFallback) {
        const maxEntities = 1;
        const foundEntities = Object(_common_find_entites__WEBPACK_IMPORTED_MODULE_15__["findEntities"])(hass, maxEntities, entities, entitiesFallback, ["light", "switch"]);
        return {
          type: "button",
          tap_action: {
            action: "toggle"
          },
          hold_action: {
            action: "more-info"
          },
          show_icon: true,
          show_name: true,
          entity: foundEntities[0] || ""
        };
      }
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_1__["property"])()],
      key: "hass",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_1__["property"])()],
      key: "_config",
      value: void 0
    }, {
      kind: "method",
      key: "getCardSize",
      value: function getCardSize() {
        return 2;
      }
    }, {
      kind: "method",
      key: "setConfig",
      value: function setConfig(config) {
        if (config.entity && !Object(_common_entity_valid_entity_id__WEBPACK_IMPORTED_MODULE_11__["isValidEntityId"])(config.entity)) {
          throw new Error("Invalid Entity");
        }

        this._config = Object.assign({
          hold_action: {
            action: "more-info"
          },
          double_tap_action: {
            action: "none"
          },
          show_icon: true,
          show_name: true,
          state_color: true
        }, config);

        if (config.entity && _common_const__WEBPACK_IMPORTED_MODULE_4__["DOMAINS_TOGGLE"].has(Object(_common_entity_compute_domain__WEBPACK_IMPORTED_MODULE_7__["computeDomain"])(config.entity))) {
          this._config = Object.assign({
            tap_action: {
              action: "toggle"
            }
          }, this._config);
        } else {
          this._config = Object.assign({
            tap_action: {
              action: "more-info"
            }
          }, this._config);
        }
      }
    }, {
      kind: "method",
      key: "shouldUpdate",
      value: function shouldUpdate(changedProps) {
        if (changedProps.has("_config")) {
          return true;
        }

        const oldHass = changedProps.get("hass");

        if (!oldHass || oldHass.themes !== this.hass.themes || oldHass.language !== this.hass.language) {
          return true;
        }

        return Boolean(this._config.entity) && oldHass.states[this._config.entity] !== this.hass.states[this._config.entity];
      }
    }, {
      kind: "method",
      key: "render",
      value: function render() {
        if (!this._config || !this.hass) {
          return lit_element__WEBPACK_IMPORTED_MODULE_1__["html"]``;
        }

        const stateObj = this._config.entity ? this.hass.states[this._config.entity] : undefined;

        if (this._config.entity && !stateObj) {
          return lit_element__WEBPACK_IMPORTED_MODULE_1__["html"]`
        <hui-warning
          >${this.hass.localize("ui.panel.lovelace.warning.entity_not_found", "entity", this._config.entity)}</hui-warning
        >
      `;
        }

        return lit_element__WEBPACK_IMPORTED_MODULE_1__["html"]`
      <ha-card
        @action=${this._handleAction}
        .actionHandler=${Object(_common_directives_action_handler_directive__WEBPACK_IMPORTED_MODULE_14__["actionHandler"])({
          hasHold: Object(_common_has_action__WEBPACK_IMPORTED_MODULE_17__["hasAction"])(this._config.hold_action),
          hasDoubleClick: Object(_common_has_action__WEBPACK_IMPORTED_MODULE_17__["hasAction"])(this._config.double_tap_action)
        })}
        tabindex=${Object(lit_html_directives_if_defined__WEBPACK_IMPORTED_MODULE_2__["ifDefined"])(Object(_common_has_action__WEBPACK_IMPORTED_MODULE_17__["hasAction"])(this._config.tap_action) ? "0" : undefined)}
      >
        ${this._config.show_icon ? lit_element__WEBPACK_IMPORTED_MODULE_1__["html"]`
              <ha-icon
                tabindex="-1"
                data-domain=${Object(lit_html_directives_if_defined__WEBPACK_IMPORTED_MODULE_2__["ifDefined"])(this._config.state_color && stateObj ? Object(_common_entity_compute_state_domain__WEBPACK_IMPORTED_MODULE_8__["computeStateDomain"])(stateObj) : undefined)}
                data-state=${Object(lit_html_directives_if_defined__WEBPACK_IMPORTED_MODULE_2__["ifDefined"])(stateObj ? Object(_common_entity_compute_active_state__WEBPACK_IMPORTED_MODULE_6__["computeActiveState"])(stateObj) : undefined)}
                .icon=${this._config.icon || (stateObj ? Object(_common_entity_state_icon__WEBPACK_IMPORTED_MODULE_10__["stateIcon"])(stateObj) : "")}
                style=${Object(lit_html_directives_style_map__WEBPACK_IMPORTED_MODULE_3__["styleMap"])({
          filter: stateObj ? this._computeBrightness(stateObj) : "",
          color: stateObj ? this._computeColor(stateObj) : "",
          height: this._config.icon_height ? this._config.icon_height : "auto"
        })}
              ></ha-icon>
            ` : ""}
        ${this._config.show_name ? lit_element__WEBPACK_IMPORTED_MODULE_1__["html"]`
              <span tabindex="-1">
                ${this._config.name || (stateObj ? Object(_common_entity_compute_state_name__WEBPACK_IMPORTED_MODULE_9__["computeStateName"])(stateObj) : "")}
              </span>
            ` : ""}
        <mwc-ripple></mwc-ripple>
      </ha-card>
    `;
      }
    }, {
      kind: "method",
      key: "updated",
      value: function updated(changedProps) {
        _get(_getPrototypeOf(HuiButtonCard.prototype), "updated", this).call(this, changedProps);

        if (!this._config || !this.hass) {
          return;
        }

        const oldHass = changedProps.get("hass");
        const oldConfig = changedProps.get("_config");

        if (!oldHass || !oldConfig || oldHass.themes !== this.hass.themes || oldConfig.theme !== this._config.theme) {
          Object(_common_dom_apply_themes_on_element__WEBPACK_IMPORTED_MODULE_5__["applyThemesOnElement"])(this, this.hass.themes, this._config.theme);
        }
      }
    }, {
      kind: "get",
      static: true,
      key: "styles",
      value: function styles() {
        return lit_element__WEBPACK_IMPORTED_MODULE_1__["css"]`
      ha-card {
        cursor: pointer;
        display: flex;
        flex-direction: column;
        align-items: center;
        text-align: center;
        padding: 4% 0;
        font-size: 1.2rem;
        height: 100%;
        box-sizing: border-box;
        justify-content: center;
      }

      ha-card:focus {
        outline: none;
        background: var(--divider-color);
      }

      ha-icon {
        width: 40%;
        height: auto;
        color: var(--paper-item-icon-color, #44739e);
      }

      ha-icon,
      span {
        outline: none;
      }

      ${_common_style_icon_color_css__WEBPACK_IMPORTED_MODULE_12__["iconColorCSS"]}
    `;
      }
    }, {
      kind: "method",
      key: "_computeBrightness",
      value: function _computeBrightness(stateObj) {
        var _this$_config;

        if (!stateObj.attributes.brightness || !((_this$_config = this._config) === null || _this$_config === void 0 ? void 0 : _this$_config.state_color)) {
          return "";
        }

        const brightness = stateObj.attributes.brightness;
        return `brightness(${(brightness + 245) / 5}%)`;
      }
    }, {
      kind: "method",
      key: "_computeColor",
      value: function _computeColor(stateObj) {
        var _this$_config2;

        if (!stateObj.attributes.hs_color || !((_this$_config2 = this._config) === null || _this$_config2 === void 0 ? void 0 : _this$_config2.state_color)) {
          return "";
        }

        const [hue, sat] = stateObj.attributes.hs_color;

        if (sat <= 10) {
          return "";
        }

        return `hsl(${hue}, 100%, ${100 - sat / 2}%)`;
      }
    }, {
      kind: "method",
      key: "_handleAction",
      value: function _handleAction(ev) {
        Object(_common_handle_action__WEBPACK_IMPORTED_MODULE_16__["handleAction"])(this, this.hass, this._config, ev.detail.action);
      }
    }]
  };
}, lit_element__WEBPACK_IMPORTED_MODULE_1__["LitElement"]);

/***/ }),

/***/ "./src/panels/lovelace/cards/hui-entities-card.ts":
/*!********************************************************!*\
  !*** ./src/panels/lovelace/cards/hui-entities-card.ts ***!
  \********************************************************/
/*! no exports provided */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var lit_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lit-element */ "./node_modules/lit-element/lit-element.js");
/* harmony import */ var _common_const__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../common/const */ "./src/common/const.ts");
/* harmony import */ var _common_dom_apply_themes_on_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../common/dom/apply_themes_on_element */ "./src/common/dom/apply_themes_on_element.ts");
/* harmony import */ var _common_entity_compute_domain__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../common/entity/compute_domain */ "./src/common/entity/compute_domain.ts");
/* harmony import */ var _components_ha_card__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../components/ha-card */ "./src/components/ha-card.ts");
/* harmony import */ var _common_find_entites__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../common/find-entites */ "./src/panels/lovelace/common/find-entites.ts");
/* harmony import */ var _common_process_config_entities__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../common/process-config-entities */ "./src/panels/lovelace/common/process-config-entities.ts");
/* harmony import */ var _components_hui_entities_toggle__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../components/hui-entities-toggle */ "./src/panels/lovelace/components/hui-entities-toggle.ts");
/* harmony import */ var _create_element_create_header_footer_element__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../create-element/create-header-footer-element */ "./src/panels/lovelace/create-element/create-header-footer-element.ts");
/* harmony import */ var _create_element_create_row_element__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../create-element/create-row-element */ "./src/panels/lovelace/create-element/create-row-element.ts");
function _decorate(decorators, factory, superClass, mixins) { var api = _getDecoratorsApi(); if (mixins) { for (var i = 0; i < mixins.length; i++) { api = mixins[i](api); } } var r = factory(function initialize(O) { api.initializeInstanceElements(O, decorated.elements); }, superClass); var decorated = api.decorateClass(_coalesceClassElements(r.d.map(_createElementDescriptor)), decorators); api.initializeClassElements(r.F, decorated.elements); return api.runClassFinishers(r.F, decorated.finishers); }

function _getDecoratorsApi() { _getDecoratorsApi = function () { return api; }; var api = { elementsDefinitionOrder: [["method"], ["field"]], initializeInstanceElements: function (O, elements) { ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { if (element.kind === kind && element.placement === "own") { this.defineClassElement(O, element); } }, this); }, this); }, initializeClassElements: function (F, elements) { var proto = F.prototype; ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { var placement = element.placement; if (element.kind === kind && (placement === "static" || placement === "prototype")) { var receiver = placement === "static" ? F : proto; this.defineClassElement(receiver, element); } }, this); }, this); }, defineClassElement: function (receiver, element) { var descriptor = element.descriptor; if (element.kind === "field") { var initializer = element.initializer; descriptor = { enumerable: descriptor.enumerable, writable: descriptor.writable, configurable: descriptor.configurable, value: initializer === void 0 ? void 0 : initializer.call(receiver) }; } Object.defineProperty(receiver, element.key, descriptor); }, decorateClass: function (elements, decorators) { var newElements = []; var finishers = []; var placements = { static: [], prototype: [], own: [] }; elements.forEach(function (element) { this.addElementPlacement(element, placements); }, this); elements.forEach(function (element) { if (!_hasDecorators(element)) return newElements.push(element); var elementFinishersExtras = this.decorateElement(element, placements); newElements.push(elementFinishersExtras.element); newElements.push.apply(newElements, elementFinishersExtras.extras); finishers.push.apply(finishers, elementFinishersExtras.finishers); }, this); if (!decorators) { return { elements: newElements, finishers: finishers }; } var result = this.decorateConstructor(newElements, decorators); finishers.push.apply(finishers, result.finishers); result.finishers = finishers; return result; }, addElementPlacement: function (element, placements, silent) { var keys = placements[element.placement]; if (!silent && keys.indexOf(element.key) !== -1) { throw new TypeError("Duplicated element (" + element.key + ")"); } keys.push(element.key); }, decorateElement: function (element, placements) { var extras = []; var finishers = []; for (var decorators = element.decorators, i = decorators.length - 1; i >= 0; i--) { var keys = placements[element.placement]; keys.splice(keys.indexOf(element.key), 1); var elementObject = this.fromElementDescriptor(element); var elementFinisherExtras = this.toElementFinisherExtras((0, decorators[i])(elementObject) || elementObject); element = elementFinisherExtras.element; this.addElementPlacement(element, placements); if (elementFinisherExtras.finisher) { finishers.push(elementFinisherExtras.finisher); } var newExtras = elementFinisherExtras.extras; if (newExtras) { for (var j = 0; j < newExtras.length; j++) { this.addElementPlacement(newExtras[j], placements); } extras.push.apply(extras, newExtras); } } return { element: element, finishers: finishers, extras: extras }; }, decorateConstructor: function (elements, decorators) { var finishers = []; for (var i = decorators.length - 1; i >= 0; i--) { var obj = this.fromClassDescriptor(elements); var elementsAndFinisher = this.toClassDescriptor((0, decorators[i])(obj) || obj); if (elementsAndFinisher.finisher !== undefined) { finishers.push(elementsAndFinisher.finisher); } if (elementsAndFinisher.elements !== undefined) { elements = elementsAndFinisher.elements; for (var j = 0; j < elements.length - 1; j++) { for (var k = j + 1; k < elements.length; k++) { if (elements[j].key === elements[k].key && elements[j].placement === elements[k].placement) { throw new TypeError("Duplicated element (" + elements[j].key + ")"); } } } } } return { elements: elements, finishers: finishers }; }, fromElementDescriptor: function (element) { var obj = { kind: element.kind, key: element.key, placement: element.placement, descriptor: element.descriptor }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); if (element.kind === "field") obj.initializer = element.initializer; return obj; }, toElementDescriptors: function (elementObjects) { if (elementObjects === undefined) return; return _toArray(elementObjects).map(function (elementObject) { var element = this.toElementDescriptor(elementObject); this.disallowProperty(elementObject, "finisher", "An element descriptor"); this.disallowProperty(elementObject, "extras", "An element descriptor"); return element; }, this); }, toElementDescriptor: function (elementObject) { var kind = String(elementObject.kind); if (kind !== "method" && kind !== "field") { throw new TypeError('An element descriptor\'s .kind property must be either "method" or' + ' "field", but a decorator created an element descriptor with' + ' .kind "' + kind + '"'); } var key = _toPropertyKey(elementObject.key); var placement = String(elementObject.placement); if (placement !== "static" && placement !== "prototype" && placement !== "own") { throw new TypeError('An element descriptor\'s .placement property must be one of "static",' + ' "prototype" or "own", but a decorator created an element descriptor' + ' with .placement "' + placement + '"'); } var descriptor = elementObject.descriptor; this.disallowProperty(elementObject, "elements", "An element descriptor"); var element = { kind: kind, key: key, placement: placement, descriptor: Object.assign({}, descriptor) }; if (kind !== "field") { this.disallowProperty(elementObject, "initializer", "A method descriptor"); } else { this.disallowProperty(descriptor, "get", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "set", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "value", "The property descriptor of a field descriptor"); element.initializer = elementObject.initializer; } return element; }, toElementFinisherExtras: function (elementObject) { var element = this.toElementDescriptor(elementObject); var finisher = _optionalCallableProperty(elementObject, "finisher"); var extras = this.toElementDescriptors(elementObject.extras); return { element: element, finisher: finisher, extras: extras }; }, fromClassDescriptor: function (elements) { var obj = { kind: "class", elements: elements.map(this.fromElementDescriptor, this) }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); return obj; }, toClassDescriptor: function (obj) { var kind = String(obj.kind); if (kind !== "class") { throw new TypeError('A class descriptor\'s .kind property must be "class", but a decorator' + ' created a class descriptor with .kind "' + kind + '"'); } this.disallowProperty(obj, "key", "A class descriptor"); this.disallowProperty(obj, "placement", "A class descriptor"); this.disallowProperty(obj, "descriptor", "A class descriptor"); this.disallowProperty(obj, "initializer", "A class descriptor"); this.disallowProperty(obj, "extras", "A class descriptor"); var finisher = _optionalCallableProperty(obj, "finisher"); var elements = this.toElementDescriptors(obj.elements); return { elements: elements, finisher: finisher }; }, runClassFinishers: function (constructor, finishers) { for (var i = 0; i < finishers.length; i++) { var newConstructor = (0, finishers[i])(constructor); if (newConstructor !== undefined) { if (typeof newConstructor !== "function") { throw new TypeError("Finishers must return a constructor."); } constructor = newConstructor; } } return constructor; }, disallowProperty: function (obj, name, objectType) { if (obj[name] !== undefined) { throw new TypeError(objectType + " can't have a ." + name + " property."); } } }; return api; }

function _createElementDescriptor(def) { var key = _toPropertyKey(def.key); var descriptor; if (def.kind === "method") { descriptor = { value: def.value, writable: true, configurable: true, enumerable: false }; } else if (def.kind === "get") { descriptor = { get: def.value, configurable: true, enumerable: false }; } else if (def.kind === "set") { descriptor = { set: def.value, configurable: true, enumerable: false }; } else if (def.kind === "field") { descriptor = { configurable: true, writable: true, enumerable: true }; } var element = { kind: def.kind === "field" ? "field" : "method", key: key, placement: def.static ? "static" : def.kind === "field" ? "own" : "prototype", descriptor: descriptor }; if (def.decorators) element.decorators = def.decorators; if (def.kind === "field") element.initializer = def.value; return element; }

function _coalesceGetterSetter(element, other) { if (element.descriptor.get !== undefined) { other.descriptor.get = element.descriptor.get; } else { other.descriptor.set = element.descriptor.set; } }

function _coalesceClassElements(elements) { var newElements = []; var isSameElement = function (other) { return other.kind === "method" && other.key === element.key && other.placement === element.placement; }; for (var i = 0; i < elements.length; i++) { var element = elements[i]; var other; if (element.kind === "method" && (other = newElements.find(isSameElement))) { if (_isDataDescriptor(element.descriptor) || _isDataDescriptor(other.descriptor)) { if (_hasDecorators(element) || _hasDecorators(other)) { throw new ReferenceError("Duplicated methods (" + element.key + ") can't be decorated."); } other.descriptor = element.descriptor; } else { if (_hasDecorators(element)) { if (_hasDecorators(other)) { throw new ReferenceError("Decorators can't be placed on different accessors with for " + "the same property (" + element.key + ")."); } other.decorators = element.decorators; } _coalesceGetterSetter(element, other); } } else { newElements.push(element); } } return newElements; }

function _hasDecorators(element) { return element.decorators && element.decorators.length; }

function _isDataDescriptor(desc) { return desc !== undefined && !(desc.value === undefined && desc.writable === undefined); }

function _optionalCallableProperty(obj, name) { var value = obj[name]; if (value !== undefined && typeof value !== "function") { throw new TypeError("Expected '" + name + "' to be a function"); } return value; }

function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }

function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }

function _toArray(arr) { return _arrayWithHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(n); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get; } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return _get(target, property, receiver || target); }

function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }












let HuiEntitiesCard = _decorate([Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["customElement"])("hui-entities-card")], function (_initialize, _LitElement) {
  class HuiEntitiesCard extends _LitElement {
    constructor(...args) {
      super(...args);

      _initialize(this);
    }

  }

  return {
    F: HuiEntitiesCard,
    d: [{
      kind: "method",
      static: true,
      key: "getConfigElement",
      value: async function getConfigElement() {
        await Promise.all(/*! import() | hui-entities-card-editor */[__webpack_require__.e(1), __webpack_require__.e(0), __webpack_require__.e(2), __webpack_require__.e(3), __webpack_require__.e(6), __webpack_require__.e(7), __webpack_require__.e(8), __webpack_require__.e("vendors~hui-alarm-panel-card-editor~hui-button-card-editor~hui-conditional-card-editor~hui-entities-~37aad430"), __webpack_require__.e("vendors~hui-entities-card-editor~hui-entity-card-editor"), __webpack_require__.e(10), __webpack_require__.e("hui-alarm-panel-card-editor~hui-button-card-editor~hui-dialog-edit-view~hui-entities-card-editor~hui~192a43f6"), __webpack_require__.e("hui-button-card-editor~hui-dialog-edit-view~hui-entities-card-editor~hui-entity-card-editor~hui-gaug~aa2f21d6"), __webpack_require__.e("hui-entities-card-editor")]).then(__webpack_require__.bind(null, /*! ../editor/config-elements/hui-entities-card-editor */ "./src/panels/lovelace/editor/config-elements/hui-entities-card-editor.ts"));
        return document.createElement("hui-entities-card-editor");
      }
    }, {
      kind: "method",
      static: true,
      key: "getStubConfig",
      value: function getStubConfig(hass, entities, entitiesFallback) {
        const maxEntities = 3;
        const foundEntities = Object(_common_find_entites__WEBPACK_IMPORTED_MODULE_5__["findEntities"])(hass, maxEntities, entities, entitiesFallback, ["light", "switch", "sensor"]);
        return {
          type: "entities",
          title: "My Title",
          entities: foundEntities
        };
      }
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "_config",
      value: void 0
    }, {
      kind: "field",
      key: "_hass",
      value: void 0
    }, {
      kind: "field",
      key: "_configEntities",
      value: void 0
    }, {
      kind: "field",
      key: "_showHeaderToggle",
      value: void 0
    }, {
      kind: "set",
      key: "hass",
      value: function hass(_hass) {
        this._hass = _hass;
        this.shadowRoot.querySelectorAll("#states > div > *").forEach(element => {
          element.hass = _hass;
        });
        this.shadowRoot.querySelectorAll(".header-footer > *").forEach(element => {
          element.hass = _hass;
        });
        const entitiesToggle = this.shadowRoot.querySelector("hui-entities-toggle");

        if (entitiesToggle) {
          entitiesToggle.hass = _hass;
        }
      }
    }, {
      kind: "method",
      key: "getCardSize",
      value: function getCardSize() {
        if (!this._config) {
          return 0;
        } // +1 for the header


        return (this._config.title ? 1 : 0) + this._config.entities.length;
      }
    }, {
      kind: "method",
      key: "setConfig",
      value: function setConfig(config) {
        const entities = Object(_common_process_config_entities__WEBPACK_IMPORTED_MODULE_6__["processConfigEntities"])(config.entities);
        this._config = config;
        this._configEntities = entities;

        if (config.show_header_toggle === undefined) {
          // Default value is show toggle if we can at least toggle 2 entities.
          let toggleable = 0;

          for (const rowConf of entities) {
            if (!rowConf.entity) {
              continue;
            }

            toggleable += Number(_common_const__WEBPACK_IMPORTED_MODULE_1__["DOMAINS_TOGGLE"].has(Object(_common_entity_compute_domain__WEBPACK_IMPORTED_MODULE_3__["computeDomain"])(rowConf.entity)));

            if (toggleable === 2) {
              break;
            }
          }

          this._showHeaderToggle = toggleable === 2;
        } else {
          this._showHeaderToggle = config.show_header_toggle;
        }
      }
    }, {
      kind: "method",
      key: "updated",
      value: function updated(changedProps) {
        _get(_getPrototypeOf(HuiEntitiesCard.prototype), "updated", this).call(this, changedProps);

        if (!this._config || !this._hass) {
          return;
        }

        const oldHass = changedProps.get("hass");
        const oldConfig = changedProps.get("_config");

        if (!oldHass || !oldConfig || oldHass.themes !== this.hass.themes || oldConfig.theme !== this._config.theme) {
          Object(_common_dom_apply_themes_on_element__WEBPACK_IMPORTED_MODULE_2__["applyThemesOnElement"])(this, this._hass.themes, this._config.theme);
        }
      }
    }, {
      kind: "method",
      key: "render",
      value: function render() {
        if (!this._config || !this._hass) {
          return lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]``;
        }

        return lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
      <ha-card>
        ${this._config.header ? this.renderHeaderFooter(this._config.header, "header") : ""}
        ${!this._config.title && !this._showHeaderToggle && !this._config.icon ? "" : lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
              <div class="card-header">
                <div class="name">
                  ${this._config.icon ? lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
                        <ha-icon
                          class="icon"
                          .icon="${this._config.icon}"
                        ></ha-icon>
                      ` : ""}
                  ${this._config.title}
                </div>
                ${!this._showHeaderToggle ? lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`` : lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
                      <hui-entities-toggle
                        .hass="${this._hass}"
                        .entities="${this._configEntities.map(conf => conf.entity)}"
                      ></hui-entities-toggle>
                    `}
              </div>
            `}
        <div id="states" class="card-content">
          ${this._configEntities.map(entityConf => this.renderEntity(entityConf))}
        </div>

        ${this._config.footer ? this.renderHeaderFooter(this._config.footer, "footer") : ""}
      </ha-card>
    `;
      }
    }, {
      kind: "get",
      static: true,
      key: "styles",
      value: function styles() {
        return lit_element__WEBPACK_IMPORTED_MODULE_0__["css"]`
      ha-card {
        height: 100%;
        display: flex;
        flex-direction: column;
        justify-content: space-between;
      }
      .card-header {
        display: flex;
        justify-content: space-between;
      }

      .card-header .name {
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
      }

      #states {
        flex: 1;
      }

      #states > * {
        margin: 8px 0;
      }

      #states > *:first-child {
        margin-top: 0;
      }

      #states > *:last-child {
        margin-bottom: 0;
      }

      #states > div > * {
        overflow: hidden;
      }

      #states > div {
        position: relative;
      }

      .icon {
        padding: 0px 18px 0px 8px;
      }

      .header {
        border-top-left-radius: var(--ha-card-border-radius, 2px);
        border-top-right-radius: var(--ha-card-border-radius, 2px);
        margin-bottom: 16px;
        overflow: hidden;
      }

      .footer {
        border-bottom-left-radius: var(--ha-card-border-radius, 2px);
        border-bottom-right-radius: var(--ha-card-border-radius, 2px);
        margin-top: -16px;
        overflow: hidden;
      }
    `;
      }
    }, {
      kind: "method",
      key: "renderHeaderFooter",
      value: function renderHeaderFooter(conf, className) {
        const element = Object(_create_element_create_header_footer_element__WEBPACK_IMPORTED_MODULE_8__["createHeaderFooterElement"])(conf);

        if (this._hass) {
          element.hass = this._hass;
        }

        return lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]` <div class=${"header-footer " + className}>${element}</div> `;
      }
    }, {
      kind: "method",
      key: "renderEntity",
      value: function renderEntity(entityConf) {
        const element = Object(_create_element_create_row_element__WEBPACK_IMPORTED_MODULE_9__["createRowElement"])(this._config.state_color ? Object.assign({
          state_color: true
        }, entityConf) : entityConf);

        if (this._hass) {
          element.hass = this._hass;
        }

        return lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]` <div>${element}</div> `;
      }
    }]
  };
}, lit_element__WEBPACK_IMPORTED_MODULE_0__["LitElement"]);

/***/ }),

/***/ "./src/panels/lovelace/cards/hui-entity-button-card.ts":
/*!*************************************************************!*\
  !*** ./src/panels/lovelace/cards/hui-entity-button-card.ts ***!
  \*************************************************************/
/*! no exports provided */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var lit_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lit-element */ "./node_modules/lit-element/lit-element.js");
/* harmony import */ var _hui_button_card__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./hui-button-card */ "./src/panels/lovelace/cards/hui-button-card.ts");
function _decorate(decorators, factory, superClass, mixins) { var api = _getDecoratorsApi(); if (mixins) { for (var i = 0; i < mixins.length; i++) { api = mixins[i](api); } } var r = factory(function initialize(O) { api.initializeInstanceElements(O, decorated.elements); }, superClass); var decorated = api.decorateClass(_coalesceClassElements(r.d.map(_createElementDescriptor)), decorators); api.initializeClassElements(r.F, decorated.elements); return api.runClassFinishers(r.F, decorated.finishers); }

function _getDecoratorsApi() { _getDecoratorsApi = function () { return api; }; var api = { elementsDefinitionOrder: [["method"], ["field"]], initializeInstanceElements: function (O, elements) { ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { if (element.kind === kind && element.placement === "own") { this.defineClassElement(O, element); } }, this); }, this); }, initializeClassElements: function (F, elements) { var proto = F.prototype; ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { var placement = element.placement; if (element.kind === kind && (placement === "static" || placement === "prototype")) { var receiver = placement === "static" ? F : proto; this.defineClassElement(receiver, element); } }, this); }, this); }, defineClassElement: function (receiver, element) { var descriptor = element.descriptor; if (element.kind === "field") { var initializer = element.initializer; descriptor = { enumerable: descriptor.enumerable, writable: descriptor.writable, configurable: descriptor.configurable, value: initializer === void 0 ? void 0 : initializer.call(receiver) }; } Object.defineProperty(receiver, element.key, descriptor); }, decorateClass: function (elements, decorators) { var newElements = []; var finishers = []; var placements = { static: [], prototype: [], own: [] }; elements.forEach(function (element) { this.addElementPlacement(element, placements); }, this); elements.forEach(function (element) { if (!_hasDecorators(element)) return newElements.push(element); var elementFinishersExtras = this.decorateElement(element, placements); newElements.push(elementFinishersExtras.element); newElements.push.apply(newElements, elementFinishersExtras.extras); finishers.push.apply(finishers, elementFinishersExtras.finishers); }, this); if (!decorators) { return { elements: newElements, finishers: finishers }; } var result = this.decorateConstructor(newElements, decorators); finishers.push.apply(finishers, result.finishers); result.finishers = finishers; return result; }, addElementPlacement: function (element, placements, silent) { var keys = placements[element.placement]; if (!silent && keys.indexOf(element.key) !== -1) { throw new TypeError("Duplicated element (" + element.key + ")"); } keys.push(element.key); }, decorateElement: function (element, placements) { var extras = []; var finishers = []; for (var decorators = element.decorators, i = decorators.length - 1; i >= 0; i--) { var keys = placements[element.placement]; keys.splice(keys.indexOf(element.key), 1); var elementObject = this.fromElementDescriptor(element); var elementFinisherExtras = this.toElementFinisherExtras((0, decorators[i])(elementObject) || elementObject); element = elementFinisherExtras.element; this.addElementPlacement(element, placements); if (elementFinisherExtras.finisher) { finishers.push(elementFinisherExtras.finisher); } var newExtras = elementFinisherExtras.extras; if (newExtras) { for (var j = 0; j < newExtras.length; j++) { this.addElementPlacement(newExtras[j], placements); } extras.push.apply(extras, newExtras); } } return { element: element, finishers: finishers, extras: extras }; }, decorateConstructor: function (elements, decorators) { var finishers = []; for (var i = decorators.length - 1; i >= 0; i--) { var obj = this.fromClassDescriptor(elements); var elementsAndFinisher = this.toClassDescriptor((0, decorators[i])(obj) || obj); if (elementsAndFinisher.finisher !== undefined) { finishers.push(elementsAndFinisher.finisher); } if (elementsAndFinisher.elements !== undefined) { elements = elementsAndFinisher.elements; for (var j = 0; j < elements.length - 1; j++) { for (var k = j + 1; k < elements.length; k++) { if (elements[j].key === elements[k].key && elements[j].placement === elements[k].placement) { throw new TypeError("Duplicated element (" + elements[j].key + ")"); } } } } } return { elements: elements, finishers: finishers }; }, fromElementDescriptor: function (element) { var obj = { kind: element.kind, key: element.key, placement: element.placement, descriptor: element.descriptor }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); if (element.kind === "field") obj.initializer = element.initializer; return obj; }, toElementDescriptors: function (elementObjects) { if (elementObjects === undefined) return; return _toArray(elementObjects).map(function (elementObject) { var element = this.toElementDescriptor(elementObject); this.disallowProperty(elementObject, "finisher", "An element descriptor"); this.disallowProperty(elementObject, "extras", "An element descriptor"); return element; }, this); }, toElementDescriptor: function (elementObject) { var kind = String(elementObject.kind); if (kind !== "method" && kind !== "field") { throw new TypeError('An element descriptor\'s .kind property must be either "method" or' + ' "field", but a decorator created an element descriptor with' + ' .kind "' + kind + '"'); } var key = _toPropertyKey(elementObject.key); var placement = String(elementObject.placement); if (placement !== "static" && placement !== "prototype" && placement !== "own") { throw new TypeError('An element descriptor\'s .placement property must be one of "static",' + ' "prototype" or "own", but a decorator created an element descriptor' + ' with .placement "' + placement + '"'); } var descriptor = elementObject.descriptor; this.disallowProperty(elementObject, "elements", "An element descriptor"); var element = { kind: kind, key: key, placement: placement, descriptor: Object.assign({}, descriptor) }; if (kind !== "field") { this.disallowProperty(elementObject, "initializer", "A method descriptor"); } else { this.disallowProperty(descriptor, "get", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "set", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "value", "The property descriptor of a field descriptor"); element.initializer = elementObject.initializer; } return element; }, toElementFinisherExtras: function (elementObject) { var element = this.toElementDescriptor(elementObject); var finisher = _optionalCallableProperty(elementObject, "finisher"); var extras = this.toElementDescriptors(elementObject.extras); return { element: element, finisher: finisher, extras: extras }; }, fromClassDescriptor: function (elements) { var obj = { kind: "class", elements: elements.map(this.fromElementDescriptor, this) }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); return obj; }, toClassDescriptor: function (obj) { var kind = String(obj.kind); if (kind !== "class") { throw new TypeError('A class descriptor\'s .kind property must be "class", but a decorator' + ' created a class descriptor with .kind "' + kind + '"'); } this.disallowProperty(obj, "key", "A class descriptor"); this.disallowProperty(obj, "placement", "A class descriptor"); this.disallowProperty(obj, "descriptor", "A class descriptor"); this.disallowProperty(obj, "initializer", "A class descriptor"); this.disallowProperty(obj, "extras", "A class descriptor"); var finisher = _optionalCallableProperty(obj, "finisher"); var elements = this.toElementDescriptors(obj.elements); return { elements: elements, finisher: finisher }; }, runClassFinishers: function (constructor, finishers) { for (var i = 0; i < finishers.length; i++) { var newConstructor = (0, finishers[i])(constructor); if (newConstructor !== undefined) { if (typeof newConstructor !== "function") { throw new TypeError("Finishers must return a constructor."); } constructor = newConstructor; } } return constructor; }, disallowProperty: function (obj, name, objectType) { if (obj[name] !== undefined) { throw new TypeError(objectType + " can't have a ." + name + " property."); } } }; return api; }

function _createElementDescriptor(def) { var key = _toPropertyKey(def.key); var descriptor; if (def.kind === "method") { descriptor = { value: def.value, writable: true, configurable: true, enumerable: false }; } else if (def.kind === "get") { descriptor = { get: def.value, configurable: true, enumerable: false }; } else if (def.kind === "set") { descriptor = { set: def.value, configurable: true, enumerable: false }; } else if (def.kind === "field") { descriptor = { configurable: true, writable: true, enumerable: true }; } var element = { kind: def.kind === "field" ? "field" : "method", key: key, placement: def.static ? "static" : def.kind === "field" ? "own" : "prototype", descriptor: descriptor }; if (def.decorators) element.decorators = def.decorators; if (def.kind === "field") element.initializer = def.value; return element; }

function _coalesceGetterSetter(element, other) { if (element.descriptor.get !== undefined) { other.descriptor.get = element.descriptor.get; } else { other.descriptor.set = element.descriptor.set; } }

function _coalesceClassElements(elements) { var newElements = []; var isSameElement = function (other) { return other.kind === "method" && other.key === element.key && other.placement === element.placement; }; for (var i = 0; i < elements.length; i++) { var element = elements[i]; var other; if (element.kind === "method" && (other = newElements.find(isSameElement))) { if (_isDataDescriptor(element.descriptor) || _isDataDescriptor(other.descriptor)) { if (_hasDecorators(element) || _hasDecorators(other)) { throw new ReferenceError("Duplicated methods (" + element.key + ") can't be decorated."); } other.descriptor = element.descriptor; } else { if (_hasDecorators(element)) { if (_hasDecorators(other)) { throw new ReferenceError("Decorators can't be placed on different accessors with for " + "the same property (" + element.key + ")."); } other.decorators = element.decorators; } _coalesceGetterSetter(element, other); } } else { newElements.push(element); } } return newElements; }

function _hasDecorators(element) { return element.decorators && element.decorators.length; }

function _isDataDescriptor(desc) { return desc !== undefined && !(desc.value === undefined && desc.writable === undefined); }

function _optionalCallableProperty(obj, name) { var value = obj[name]; if (value !== undefined && typeof value !== "function") { throw new TypeError("Expected '" + name + "' to be a function"); } return value; }

function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }

function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }

function _toArray(arr) { return _arrayWithHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(n); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }




let HuiEntityButtonCard = _decorate([Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["customElement"])("hui-entity-button-card")], function (_initialize, _HuiButtonCard) {
  class HuiEntityButtonCard extends _HuiButtonCard {
    constructor(...args) {
      super(...args);

      _initialize(this);
    }

  }

  return {
    F: HuiEntityButtonCard,
    d: []
  };
}, _hui_button_card__WEBPACK_IMPORTED_MODULE_1__["HuiButtonCard"]);

/***/ }),

/***/ "./src/panels/lovelace/cards/hui-entity-card.ts":
/*!******************************************************!*\
  !*** ./src/panels/lovelace/cards/hui-entity-card.ts ***!
  \******************************************************/
/*! exports provided: HuiEntityCard */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HuiEntityCard", function() { return HuiEntityCard; });
/* harmony import */ var lit_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lit-element */ "./node_modules/lit-element/lit-element.js");
/* harmony import */ var _common_dom_apply_themes_on_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../common/dom/apply_themes_on_element */ "./src/common/dom/apply_themes_on_element.ts");
/* harmony import */ var _common_dom_fire_event__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../common/dom/fire_event */ "./src/common/dom/fire_event.ts");
/* harmony import */ var _common_entity_compute_state_display__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../common/entity/compute_state_display */ "./src/common/entity/compute_state_display.ts");
/* harmony import */ var _common_entity_compute_state_name__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../common/entity/compute_state_name */ "./src/common/entity/compute_state_name.ts");
/* harmony import */ var _common_entity_state_icon__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../common/entity/state_icon */ "./src/common/entity/state_icon.ts");
/* harmony import */ var _common_entity_valid_entity_id__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../common/entity/valid_entity_id */ "./src/common/entity/valid_entity_id.ts");
/* harmony import */ var _components_ha_card__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../components/ha-card */ "./src/components/ha-card.ts");
/* harmony import */ var _components_ha_icon__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../components/ha-icon */ "./src/components/ha-icon.ts");
/* harmony import */ var _data_entity__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../../data/entity */ "./src/data/entity.ts");
/* harmony import */ var _common_directives_action_handler_directive__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../common/directives/action-handler-directive */ "./src/panels/lovelace/common/directives/action-handler-directive.ts");
/* harmony import */ var _common_find_entites__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../common/find-entites */ "./src/panels/lovelace/common/find-entites.ts");
/* harmony import */ var _common_has_changed__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../common/has-changed */ "./src/panels/lovelace/common/has-changed.ts");
/* harmony import */ var _components_hui_warning__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../components/hui-warning */ "./src/panels/lovelace/components/hui-warning.ts");
/* harmony import */ var _create_element_create_header_footer_element__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../create-element/create-header-footer-element */ "./src/panels/lovelace/create-element/create-header-footer-element.ts");
function _decorate(decorators, factory, superClass, mixins) { var api = _getDecoratorsApi(); if (mixins) { for (var i = 0; i < mixins.length; i++) { api = mixins[i](api); } } var r = factory(function initialize(O) { api.initializeInstanceElements(O, decorated.elements); }, superClass); var decorated = api.decorateClass(_coalesceClassElements(r.d.map(_createElementDescriptor)), decorators); api.initializeClassElements(r.F, decorated.elements); return api.runClassFinishers(r.F, decorated.finishers); }

function _getDecoratorsApi() { _getDecoratorsApi = function () { return api; }; var api = { elementsDefinitionOrder: [["method"], ["field"]], initializeInstanceElements: function (O, elements) { ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { if (element.kind === kind && element.placement === "own") { this.defineClassElement(O, element); } }, this); }, this); }, initializeClassElements: function (F, elements) { var proto = F.prototype; ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { var placement = element.placement; if (element.kind === kind && (placement === "static" || placement === "prototype")) { var receiver = placement === "static" ? F : proto; this.defineClassElement(receiver, element); } }, this); }, this); }, defineClassElement: function (receiver, element) { var descriptor = element.descriptor; if (element.kind === "field") { var initializer = element.initializer; descriptor = { enumerable: descriptor.enumerable, writable: descriptor.writable, configurable: descriptor.configurable, value: initializer === void 0 ? void 0 : initializer.call(receiver) }; } Object.defineProperty(receiver, element.key, descriptor); }, decorateClass: function (elements, decorators) { var newElements = []; var finishers = []; var placements = { static: [], prototype: [], own: [] }; elements.forEach(function (element) { this.addElementPlacement(element, placements); }, this); elements.forEach(function (element) { if (!_hasDecorators(element)) return newElements.push(element); var elementFinishersExtras = this.decorateElement(element, placements); newElements.push(elementFinishersExtras.element); newElements.push.apply(newElements, elementFinishersExtras.extras); finishers.push.apply(finishers, elementFinishersExtras.finishers); }, this); if (!decorators) { return { elements: newElements, finishers: finishers }; } var result = this.decorateConstructor(newElements, decorators); finishers.push.apply(finishers, result.finishers); result.finishers = finishers; return result; }, addElementPlacement: function (element, placements, silent) { var keys = placements[element.placement]; if (!silent && keys.indexOf(element.key) !== -1) { throw new TypeError("Duplicated element (" + element.key + ")"); } keys.push(element.key); }, decorateElement: function (element, placements) { var extras = []; var finishers = []; for (var decorators = element.decorators, i = decorators.length - 1; i >= 0; i--) { var keys = placements[element.placement]; keys.splice(keys.indexOf(element.key), 1); var elementObject = this.fromElementDescriptor(element); var elementFinisherExtras = this.toElementFinisherExtras((0, decorators[i])(elementObject) || elementObject); element = elementFinisherExtras.element; this.addElementPlacement(element, placements); if (elementFinisherExtras.finisher) { finishers.push(elementFinisherExtras.finisher); } var newExtras = elementFinisherExtras.extras; if (newExtras) { for (var j = 0; j < newExtras.length; j++) { this.addElementPlacement(newExtras[j], placements); } extras.push.apply(extras, newExtras); } } return { element: element, finishers: finishers, extras: extras }; }, decorateConstructor: function (elements, decorators) { var finishers = []; for (var i = decorators.length - 1; i >= 0; i--) { var obj = this.fromClassDescriptor(elements); var elementsAndFinisher = this.toClassDescriptor((0, decorators[i])(obj) || obj); if (elementsAndFinisher.finisher !== undefined) { finishers.push(elementsAndFinisher.finisher); } if (elementsAndFinisher.elements !== undefined) { elements = elementsAndFinisher.elements; for (var j = 0; j < elements.length - 1; j++) { for (var k = j + 1; k < elements.length; k++) { if (elements[j].key === elements[k].key && elements[j].placement === elements[k].placement) { throw new TypeError("Duplicated element (" + elements[j].key + ")"); } } } } } return { elements: elements, finishers: finishers }; }, fromElementDescriptor: function (element) { var obj = { kind: element.kind, key: element.key, placement: element.placement, descriptor: element.descriptor }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); if (element.kind === "field") obj.initializer = element.initializer; return obj; }, toElementDescriptors: function (elementObjects) { if (elementObjects === undefined) return; return _toArray(elementObjects).map(function (elementObject) { var element = this.toElementDescriptor(elementObject); this.disallowProperty(elementObject, "finisher", "An element descriptor"); this.disallowProperty(elementObject, "extras", "An element descriptor"); return element; }, this); }, toElementDescriptor: function (elementObject) { var kind = String(elementObject.kind); if (kind !== "method" && kind !== "field") { throw new TypeError('An element descriptor\'s .kind property must be either "method" or' + ' "field", but a decorator created an element descriptor with' + ' .kind "' + kind + '"'); } var key = _toPropertyKey(elementObject.key); var placement = String(elementObject.placement); if (placement !== "static" && placement !== "prototype" && placement !== "own") { throw new TypeError('An element descriptor\'s .placement property must be one of "static",' + ' "prototype" or "own", but a decorator created an element descriptor' + ' with .placement "' + placement + '"'); } var descriptor = elementObject.descriptor; this.disallowProperty(elementObject, "elements", "An element descriptor"); var element = { kind: kind, key: key, placement: placement, descriptor: Object.assign({}, descriptor) }; if (kind !== "field") { this.disallowProperty(elementObject, "initializer", "A method descriptor"); } else { this.disallowProperty(descriptor, "get", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "set", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "value", "The property descriptor of a field descriptor"); element.initializer = elementObject.initializer; } return element; }, toElementFinisherExtras: function (elementObject) { var element = this.toElementDescriptor(elementObject); var finisher = _optionalCallableProperty(elementObject, "finisher"); var extras = this.toElementDescriptors(elementObject.extras); return { element: element, finisher: finisher, extras: extras }; }, fromClassDescriptor: function (elements) { var obj = { kind: "class", elements: elements.map(this.fromElementDescriptor, this) }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); return obj; }, toClassDescriptor: function (obj) { var kind = String(obj.kind); if (kind !== "class") { throw new TypeError('A class descriptor\'s .kind property must be "class", but a decorator' + ' created a class descriptor with .kind "' + kind + '"'); } this.disallowProperty(obj, "key", "A class descriptor"); this.disallowProperty(obj, "placement", "A class descriptor"); this.disallowProperty(obj, "descriptor", "A class descriptor"); this.disallowProperty(obj, "initializer", "A class descriptor"); this.disallowProperty(obj, "extras", "A class descriptor"); var finisher = _optionalCallableProperty(obj, "finisher"); var elements = this.toElementDescriptors(obj.elements); return { elements: elements, finisher: finisher }; }, runClassFinishers: function (constructor, finishers) { for (var i = 0; i < finishers.length; i++) { var newConstructor = (0, finishers[i])(constructor); if (newConstructor !== undefined) { if (typeof newConstructor !== "function") { throw new TypeError("Finishers must return a constructor."); } constructor = newConstructor; } } return constructor; }, disallowProperty: function (obj, name, objectType) { if (obj[name] !== undefined) { throw new TypeError(objectType + " can't have a ." + name + " property."); } } }; return api; }

function _createElementDescriptor(def) { var key = _toPropertyKey(def.key); var descriptor; if (def.kind === "method") { descriptor = { value: def.value, writable: true, configurable: true, enumerable: false }; } else if (def.kind === "get") { descriptor = { get: def.value, configurable: true, enumerable: false }; } else if (def.kind === "set") { descriptor = { set: def.value, configurable: true, enumerable: false }; } else if (def.kind === "field") { descriptor = { configurable: true, writable: true, enumerable: true }; } var element = { kind: def.kind === "field" ? "field" : "method", key: key, placement: def.static ? "static" : def.kind === "field" ? "own" : "prototype", descriptor: descriptor }; if (def.decorators) element.decorators = def.decorators; if (def.kind === "field") element.initializer = def.value; return element; }

function _coalesceGetterSetter(element, other) { if (element.descriptor.get !== undefined) { other.descriptor.get = element.descriptor.get; } else { other.descriptor.set = element.descriptor.set; } }

function _coalesceClassElements(elements) { var newElements = []; var isSameElement = function (other) { return other.kind === "method" && other.key === element.key && other.placement === element.placement; }; for (var i = 0; i < elements.length; i++) { var element = elements[i]; var other; if (element.kind === "method" && (other = newElements.find(isSameElement))) { if (_isDataDescriptor(element.descriptor) || _isDataDescriptor(other.descriptor)) { if (_hasDecorators(element) || _hasDecorators(other)) { throw new ReferenceError("Duplicated methods (" + element.key + ") can't be decorated."); } other.descriptor = element.descriptor; } else { if (_hasDecorators(element)) { if (_hasDecorators(other)) { throw new ReferenceError("Decorators can't be placed on different accessors with for " + "the same property (" + element.key + ")."); } other.decorators = element.decorators; } _coalesceGetterSetter(element, other); } } else { newElements.push(element); } } return newElements; }

function _hasDecorators(element) { return element.decorators && element.decorators.length; }

function _isDataDescriptor(desc) { return desc !== undefined && !(desc.value === undefined && desc.writable === undefined); }

function _optionalCallableProperty(obj, name) { var value = obj[name]; if (value !== undefined && typeof value !== "function") { throw new TypeError("Expected '" + name + "' to be a function"); } return value; }

function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }

function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }

function _toArray(arr) { return _arrayWithHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(n); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get; } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return _get(target, property, receiver || target); }

function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
















let HuiEntityCard = _decorate([Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["customElement"])("hui-entity-card")], function (_initialize, _LitElement) {
  class HuiEntityCard extends _LitElement {
    constructor(...args) {
      super(...args);

      _initialize(this);
    }

  }

  return {
    F: HuiEntityCard,
    d: [{
      kind: "method",
      static: true,
      key: "getConfigElement",
      value: async function getConfigElement() {
        await Promise.all(/*! import() | hui-entity-card-editor */[__webpack_require__.e(1), __webpack_require__.e(0), __webpack_require__.e(2), __webpack_require__.e(3), __webpack_require__.e(6), __webpack_require__.e(7), __webpack_require__.e(8), __webpack_require__.e("vendors~hui-alarm-panel-card-editor~hui-button-card-editor~hui-conditional-card-editor~hui-entities-~37aad430"), __webpack_require__.e("vendors~hui-button-card-editor~hui-dialog-delete-card~hui-dialog-edit-card~hui-dialog-suggest-card~h~a8cf51a3"), __webpack_require__.e("vendors~hui-entities-card-editor~hui-entity-card-editor"), __webpack_require__.e(10), __webpack_require__.e("hui-alarm-panel-card-editor~hui-button-card-editor~hui-dialog-edit-view~hui-entities-card-editor~hui~192a43f6"), __webpack_require__.e("hui-button-card-editor~hui-dialog-edit-view~hui-entities-card-editor~hui-entity-card-editor~hui-gaug~aa2f21d6"), __webpack_require__.e("entity-editor-dialog~helper-detail-dialog~hui-button-card-editor~hui-entity-card-editor~hui-light-ca~1d54093c"), __webpack_require__.e("hui-button-card-editor~hui-entity-card-editor~hui-light-card-editor~hui-picture-card-editor~hui-pict~6832566a"), __webpack_require__.e("hui-entity-card-editor")]).then(__webpack_require__.bind(null, /*! ../editor/config-elements/hui-entity-card-editor */ "./src/panels/lovelace/editor/config-elements/hui-entity-card-editor.ts"));
        return document.createElement("hui-entity-card-editor");
      }
    }, {
      kind: "method",
      static: true,
      key: "getStubConfig",
      value: function getStubConfig(hass, entities, entitiesFill) {
        const includeDomains = ["sensor", "light", "switch"];
        const maxEntities = 1;
        const foundEntities = Object(_common_find_entites__WEBPACK_IMPORTED_MODULE_11__["findEntities"])(hass, maxEntities, entities, entitiesFill, includeDomains);
        return {
          entity: foundEntities[0] || ""
        };
      }
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "hass",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "_config",
      value: void 0
    }, {
      kind: "field",
      key: "_footerElement",
      value: void 0
    }, {
      kind: "method",
      key: "setConfig",
      value: function setConfig(config) {
        if (config.entity && !Object(_common_entity_valid_entity_id__WEBPACK_IMPORTED_MODULE_6__["isValidEntityId"])(config.entity)) {
          throw new Error("Invalid Entity");
        }

        this._config = config;

        if (this._config.footer) {
          this._footerElement = Object(_create_element_create_header_footer_element__WEBPACK_IMPORTED_MODULE_14__["createHeaderFooterElement"])(this._config.footer);
        } else if (this._footerElement) {
          this._footerElement = undefined;
        }
      }
    }, {
      kind: "method",
      key: "getCardSize",
      value: function getCardSize() {
        var _this$_config;

        return 1 + (((_this$_config = this._config) === null || _this$_config === void 0 ? void 0 : _this$_config.footer) ? 1 : 0);
      }
    }, {
      kind: "method",
      key: "render",
      value: function render() {
        if (!this._config || !this.hass) {
          return lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]``;
        }

        const stateObj = this.hass.states[this._config.entity];

        if (!stateObj) {
          return lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
        <hui-warning
          >${this.hass.localize("ui.panel.lovelace.warning.entity_not_found", "entity", this._config.entity)}</hui-warning
        >
      `;
        }

        const showUnit = this._config.attribute ? this._config.attribute in stateObj.attributes : !_data_entity__WEBPACK_IMPORTED_MODULE_9__["UNAVAILABLE_STATES"].includes(stateObj.state);
        return lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
      <ha-card>
        <div
          @action=${this._handleClick}
          .actionHandler=${Object(_common_directives_action_handler_directive__WEBPACK_IMPORTED_MODULE_10__["actionHandler"])()}
          tabindex="0"
        >
          <div class="header">
            <div class="name">
              ${this._config.name || Object(_common_entity_compute_state_name__WEBPACK_IMPORTED_MODULE_4__["computeStateName"])(stateObj)}
            </div>
            <div class="icon">
              <ha-icon
                .icon=${this._config.icon || Object(_common_entity_state_icon__WEBPACK_IMPORTED_MODULE_5__["stateIcon"])(stateObj)}
              ></ha-icon>
            </div>
          </div>
          <div class="info">
            <span class="value"
              >${"attribute" in this._config ? stateObj.attributes[this._config.attribute] || this.hass.localize("state.default.unknown") : stateObj.attributes.unit_of_measurement ? stateObj.state : Object(_common_entity_compute_state_display__WEBPACK_IMPORTED_MODULE_3__["computeStateDisplay"])(this.hass.localize, stateObj, this.hass.language)}</span
            >${showUnit ? lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
                  <span class="measurement"
                    >${this._config.unit || (this._config.attribute ? "" : stateObj.attributes.unit_of_measurement)}</span
                  >
                ` : ""}
          </div>
        </div>
        ${this._footerElement}
      </ha-card>
    `;
      }
    }, {
      kind: "method",
      key: "shouldUpdate",
      value: function shouldUpdate(changedProps) {
        // Side Effect used to update footer hass while keeping optimizations
        if (this._footerElement) {
          this._footerElement.hass = this.hass;
        }

        return Object(_common_has_changed__WEBPACK_IMPORTED_MODULE_12__["hasConfigOrEntityChanged"])(this, changedProps);
      }
    }, {
      kind: "method",
      key: "updated",
      value: function updated(changedProps) {
        _get(_getPrototypeOf(HuiEntityCard.prototype), "updated", this).call(this, changedProps);

        if (!this._config || !this.hass) {
          return;
        }

        const oldHass = changedProps.get("hass");
        const oldConfig = changedProps.get("_config");

        if (!oldHass || !oldConfig || oldHass.themes !== this.hass.themes || oldConfig.theme !== this._config.theme) {
          Object(_common_dom_apply_themes_on_element__WEBPACK_IMPORTED_MODULE_1__["applyThemesOnElement"])(this, this.hass.themes, this._config.theme);
        }
      }
    }, {
      kind: "method",
      key: "_handleClick",
      value: function _handleClick() {
        Object(_common_dom_fire_event__WEBPACK_IMPORTED_MODULE_2__["fireEvent"])(this, "hass-more-info", {
          entityId: this._config.entity
        });
      }
    }, {
      kind: "get",
      static: true,
      key: "styles",
      value: function styles() {
        return lit_element__WEBPACK_IMPORTED_MODULE_0__["css"]`
      ha-card {
        height: 100%;
        display: flex;
        flex-direction: column;
        justify-content: space-between;
      }
      ha-card > div {
        cursor: pointer;
      }

      .header {
        display: flex;
        padding: 8px 16px 0;
        justify-content: space-between;
      }

      .name {
        color: var(--secondary-text-color);
        line-height: 40px;
        font-weight: 500;
        font-size: 16px;
        overflow: hidden;
        white-space: nowrap;
        text-overflow: ellipsis;
      }

      .icon {
        color: var(--state-icon-color, #44739e);
        line-height: 40px;
      }

      .info {
        padding: 0px 16px 16px;
        margin-top: -4px;
        overflow: hidden;
        white-space: nowrap;
        text-overflow: ellipsis;
        line-height: 28px;
      }

      .value {
        font-size: 28px;
        margin-right: 4px;
      }

      .measurement {
        font-size: 18px;
        color: var(--secondary-text-color);
      }
    `;
      }
    }]
  };
}, lit_element__WEBPACK_IMPORTED_MODULE_0__["LitElement"]);

/***/ }),

/***/ "./src/panels/lovelace/cards/hui-glance-card.ts":
/*!******************************************************!*\
  !*** ./src/panels/lovelace/cards/hui-glance-card.ts ***!
  \******************************************************/
/*! exports provided: HuiGlanceCard */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HuiGlanceCard", function() { return HuiGlanceCard; });
/* harmony import */ var lit_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lit-element */ "./node_modules/lit-element/lit-element.js");
/* harmony import */ var lit_html_directives_class_map__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lit-html/directives/class-map */ "./node_modules/lit-html/directives/class-map.js");
/* harmony import */ var lit_html_directives_if_defined__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lit-html/directives/if-defined */ "./node_modules/lit-html/directives/if-defined.js");
/* harmony import */ var _common_datetime_relative_time__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../common/datetime/relative_time */ "./src/common/datetime/relative_time.ts");
/* harmony import */ var _common_dom_apply_themes_on_element__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../common/dom/apply_themes_on_element */ "./src/common/dom/apply_themes_on_element.ts");
/* harmony import */ var _common_entity_compute_domain__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../common/entity/compute_domain */ "./src/common/entity/compute_domain.ts");
/* harmony import */ var _common_entity_compute_state_display__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../common/entity/compute_state_display */ "./src/common/entity/compute_state_display.ts");
/* harmony import */ var _common_entity_compute_state_name__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../common/entity/compute_state_name */ "./src/common/entity/compute_state_name.ts");
/* harmony import */ var _components_entity_state_badge__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../components/entity/state-badge */ "./src/components/entity/state-badge.ts");
/* harmony import */ var _components_ha_card__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../../components/ha-card */ "./src/components/ha-card.ts");
/* harmony import */ var _components_ha_icon__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../../components/ha-icon */ "./src/components/ha-icon.ts");
/* harmony import */ var _data_entity__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../../data/entity */ "./src/data/entity.ts");
/* harmony import */ var _common_directives_action_handler_directive__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../common/directives/action-handler-directive */ "./src/panels/lovelace/common/directives/action-handler-directive.ts");
/* harmony import */ var _common_find_entites__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../common/find-entites */ "./src/panels/lovelace/common/find-entites.ts");
/* harmony import */ var _common_handle_action__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../common/handle-action */ "./src/panels/lovelace/common/handle-action.ts");
/* harmony import */ var _common_has_action__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../common/has-action */ "./src/panels/lovelace/common/has-action.ts");
/* harmony import */ var _common_process_config_entities__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../common/process-config-entities */ "./src/panels/lovelace/common/process-config-entities.ts");
/* harmony import */ var _components_hui_warning_element__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../components/hui-warning-element */ "./src/panels/lovelace/components/hui-warning-element.ts");
/* harmony import */ var _components_hui_timestamp_display__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../components/hui-timestamp-display */ "./src/panels/lovelace/components/hui-timestamp-display.ts");
function _decorate(decorators, factory, superClass, mixins) { var api = _getDecoratorsApi(); if (mixins) { for (var i = 0; i < mixins.length; i++) { api = mixins[i](api); } } var r = factory(function initialize(O) { api.initializeInstanceElements(O, decorated.elements); }, superClass); var decorated = api.decorateClass(_coalesceClassElements(r.d.map(_createElementDescriptor)), decorators); api.initializeClassElements(r.F, decorated.elements); return api.runClassFinishers(r.F, decorated.finishers); }

function _getDecoratorsApi() { _getDecoratorsApi = function () { return api; }; var api = { elementsDefinitionOrder: [["method"], ["field"]], initializeInstanceElements: function (O, elements) { ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { if (element.kind === kind && element.placement === "own") { this.defineClassElement(O, element); } }, this); }, this); }, initializeClassElements: function (F, elements) { var proto = F.prototype; ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { var placement = element.placement; if (element.kind === kind && (placement === "static" || placement === "prototype")) { var receiver = placement === "static" ? F : proto; this.defineClassElement(receiver, element); } }, this); }, this); }, defineClassElement: function (receiver, element) { var descriptor = element.descriptor; if (element.kind === "field") { var initializer = element.initializer; descriptor = { enumerable: descriptor.enumerable, writable: descriptor.writable, configurable: descriptor.configurable, value: initializer === void 0 ? void 0 : initializer.call(receiver) }; } Object.defineProperty(receiver, element.key, descriptor); }, decorateClass: function (elements, decorators) { var newElements = []; var finishers = []; var placements = { static: [], prototype: [], own: [] }; elements.forEach(function (element) { this.addElementPlacement(element, placements); }, this); elements.forEach(function (element) { if (!_hasDecorators(element)) return newElements.push(element); var elementFinishersExtras = this.decorateElement(element, placements); newElements.push(elementFinishersExtras.element); newElements.push.apply(newElements, elementFinishersExtras.extras); finishers.push.apply(finishers, elementFinishersExtras.finishers); }, this); if (!decorators) { return { elements: newElements, finishers: finishers }; } var result = this.decorateConstructor(newElements, decorators); finishers.push.apply(finishers, result.finishers); result.finishers = finishers; return result; }, addElementPlacement: function (element, placements, silent) { var keys = placements[element.placement]; if (!silent && keys.indexOf(element.key) !== -1) { throw new TypeError("Duplicated element (" + element.key + ")"); } keys.push(element.key); }, decorateElement: function (element, placements) { var extras = []; var finishers = []; for (var decorators = element.decorators, i = decorators.length - 1; i >= 0; i--) { var keys = placements[element.placement]; keys.splice(keys.indexOf(element.key), 1); var elementObject = this.fromElementDescriptor(element); var elementFinisherExtras = this.toElementFinisherExtras((0, decorators[i])(elementObject) || elementObject); element = elementFinisherExtras.element; this.addElementPlacement(element, placements); if (elementFinisherExtras.finisher) { finishers.push(elementFinisherExtras.finisher); } var newExtras = elementFinisherExtras.extras; if (newExtras) { for (var j = 0; j < newExtras.length; j++) { this.addElementPlacement(newExtras[j], placements); } extras.push.apply(extras, newExtras); } } return { element: element, finishers: finishers, extras: extras }; }, decorateConstructor: function (elements, decorators) { var finishers = []; for (var i = decorators.length - 1; i >= 0; i--) { var obj = this.fromClassDescriptor(elements); var elementsAndFinisher = this.toClassDescriptor((0, decorators[i])(obj) || obj); if (elementsAndFinisher.finisher !== undefined) { finishers.push(elementsAndFinisher.finisher); } if (elementsAndFinisher.elements !== undefined) { elements = elementsAndFinisher.elements; for (var j = 0; j < elements.length - 1; j++) { for (var k = j + 1; k < elements.length; k++) { if (elements[j].key === elements[k].key && elements[j].placement === elements[k].placement) { throw new TypeError("Duplicated element (" + elements[j].key + ")"); } } } } } return { elements: elements, finishers: finishers }; }, fromElementDescriptor: function (element) { var obj = { kind: element.kind, key: element.key, placement: element.placement, descriptor: element.descriptor }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); if (element.kind === "field") obj.initializer = element.initializer; return obj; }, toElementDescriptors: function (elementObjects) { if (elementObjects === undefined) return; return _toArray(elementObjects).map(function (elementObject) { var element = this.toElementDescriptor(elementObject); this.disallowProperty(elementObject, "finisher", "An element descriptor"); this.disallowProperty(elementObject, "extras", "An element descriptor"); return element; }, this); }, toElementDescriptor: function (elementObject) { var kind = String(elementObject.kind); if (kind !== "method" && kind !== "field") { throw new TypeError('An element descriptor\'s .kind property must be either "method" or' + ' "field", but a decorator created an element descriptor with' + ' .kind "' + kind + '"'); } var key = _toPropertyKey(elementObject.key); var placement = String(elementObject.placement); if (placement !== "static" && placement !== "prototype" && placement !== "own") { throw new TypeError('An element descriptor\'s .placement property must be one of "static",' + ' "prototype" or "own", but a decorator created an element descriptor' + ' with .placement "' + placement + '"'); } var descriptor = elementObject.descriptor; this.disallowProperty(elementObject, "elements", "An element descriptor"); var element = { kind: kind, key: key, placement: placement, descriptor: Object.assign({}, descriptor) }; if (kind !== "field") { this.disallowProperty(elementObject, "initializer", "A method descriptor"); } else { this.disallowProperty(descriptor, "get", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "set", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "value", "The property descriptor of a field descriptor"); element.initializer = elementObject.initializer; } return element; }, toElementFinisherExtras: function (elementObject) { var element = this.toElementDescriptor(elementObject); var finisher = _optionalCallableProperty(elementObject, "finisher"); var extras = this.toElementDescriptors(elementObject.extras); return { element: element, finisher: finisher, extras: extras }; }, fromClassDescriptor: function (elements) { var obj = { kind: "class", elements: elements.map(this.fromElementDescriptor, this) }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); return obj; }, toClassDescriptor: function (obj) { var kind = String(obj.kind); if (kind !== "class") { throw new TypeError('A class descriptor\'s .kind property must be "class", but a decorator' + ' created a class descriptor with .kind "' + kind + '"'); } this.disallowProperty(obj, "key", "A class descriptor"); this.disallowProperty(obj, "placement", "A class descriptor"); this.disallowProperty(obj, "descriptor", "A class descriptor"); this.disallowProperty(obj, "initializer", "A class descriptor"); this.disallowProperty(obj, "extras", "A class descriptor"); var finisher = _optionalCallableProperty(obj, "finisher"); var elements = this.toElementDescriptors(obj.elements); return { elements: elements, finisher: finisher }; }, runClassFinishers: function (constructor, finishers) { for (var i = 0; i < finishers.length; i++) { var newConstructor = (0, finishers[i])(constructor); if (newConstructor !== undefined) { if (typeof newConstructor !== "function") { throw new TypeError("Finishers must return a constructor."); } constructor = newConstructor; } } return constructor; }, disallowProperty: function (obj, name, objectType) { if (obj[name] !== undefined) { throw new TypeError(objectType + " can't have a ." + name + " property."); } } }; return api; }

function _createElementDescriptor(def) { var key = _toPropertyKey(def.key); var descriptor; if (def.kind === "method") { descriptor = { value: def.value, writable: true, configurable: true, enumerable: false }; } else if (def.kind === "get") { descriptor = { get: def.value, configurable: true, enumerable: false }; } else if (def.kind === "set") { descriptor = { set: def.value, configurable: true, enumerable: false }; } else if (def.kind === "field") { descriptor = { configurable: true, writable: true, enumerable: true }; } var element = { kind: def.kind === "field" ? "field" : "method", key: key, placement: def.static ? "static" : def.kind === "field" ? "own" : "prototype", descriptor: descriptor }; if (def.decorators) element.decorators = def.decorators; if (def.kind === "field") element.initializer = def.value; return element; }

function _coalesceGetterSetter(element, other) { if (element.descriptor.get !== undefined) { other.descriptor.get = element.descriptor.get; } else { other.descriptor.set = element.descriptor.set; } }

function _coalesceClassElements(elements) { var newElements = []; var isSameElement = function (other) { return other.kind === "method" && other.key === element.key && other.placement === element.placement; }; for (var i = 0; i < elements.length; i++) { var element = elements[i]; var other; if (element.kind === "method" && (other = newElements.find(isSameElement))) { if (_isDataDescriptor(element.descriptor) || _isDataDescriptor(other.descriptor)) { if (_hasDecorators(element) || _hasDecorators(other)) { throw new ReferenceError("Duplicated methods (" + element.key + ") can't be decorated."); } other.descriptor = element.descriptor; } else { if (_hasDecorators(element)) { if (_hasDecorators(other)) { throw new ReferenceError("Decorators can't be placed on different accessors with for " + "the same property (" + element.key + ")."); } other.decorators = element.decorators; } _coalesceGetterSetter(element, other); } } else { newElements.push(element); } } return newElements; }

function _hasDecorators(element) { return element.decorators && element.decorators.length; }

function _isDataDescriptor(desc) { return desc !== undefined && !(desc.value === undefined && desc.writable === undefined); }

function _optionalCallableProperty(obj, name) { var value = obj[name]; if (value !== undefined && typeof value !== "function") { throw new TypeError("Expected '" + name + "' to be a function"); } return value; }

function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }

function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }

function _toArray(arr) { return _arrayWithHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(n); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get; } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return _get(target, property, receiver || target); }

function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }




















let HuiGlanceCard = _decorate([Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["customElement"])("hui-glance-card")], function (_initialize, _LitElement) {
  class HuiGlanceCard extends _LitElement {
    constructor(...args) {
      super(...args);

      _initialize(this);
    }

  }

  return {
    F: HuiGlanceCard,
    d: [{
      kind: "method",
      static: true,
      key: "getConfigElement",
      value: async function getConfigElement() {
        await Promise.all(/*! import() | hui-glance-card-editor */[__webpack_require__.e(1), __webpack_require__.e(0), __webpack_require__.e(2), __webpack_require__.e(3), __webpack_require__.e(6), __webpack_require__.e(7), __webpack_require__.e(8), __webpack_require__.e("vendors~hui-alarm-panel-card-editor~hui-button-card-editor~hui-conditional-card-editor~hui-entities-~37aad430"), __webpack_require__.e("vendors~hui-glance-card-editor"), __webpack_require__.e(10), __webpack_require__.e("hui-alarm-panel-card-editor~hui-button-card-editor~hui-dialog-edit-view~hui-entities-card-editor~hui~192a43f6"), __webpack_require__.e("hui-button-card-editor~hui-dialog-edit-view~hui-entities-card-editor~hui-entity-card-editor~hui-gaug~aa2f21d6"), __webpack_require__.e("hui-glance-card-editor")]).then(__webpack_require__.bind(null, /*! ../editor/config-elements/hui-glance-card-editor */ "./src/panels/lovelace/editor/config-elements/hui-glance-card-editor.ts"));
        return document.createElement("hui-glance-card-editor");
      }
    }, {
      kind: "method",
      static: true,
      key: "getStubConfig",
      value: function getStubConfig(hass, entities, entitiesFallback) {
        const includeDomains = ["sensor"];
        const maxEntities = 3;
        const foundEntities = Object(_common_find_entites__WEBPACK_IMPORTED_MODULE_13__["findEntities"])(hass, maxEntities, entities, entitiesFallback, includeDomains);
        return {
          type: "glance",
          entities: foundEntities
        };
      }
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "hass",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "_config",
      value: void 0
    }, {
      kind: "field",
      key: "_configEntities",
      value: void 0
    }, {
      kind: "method",
      key: "getCardSize",
      value: function getCardSize() {
        return (this._config.title ? 1 : 0) + Math.ceil(this._configEntities.length / 5);
      }
    }, {
      kind: "method",
      key: "setConfig",
      value: function setConfig(config) {
        this._config = Object.assign({
          state_color: true
        }, config);
        const entities = Object(_common_process_config_entities__WEBPACK_IMPORTED_MODULE_16__["processConfigEntities"])(config.entities);

        for (const entity of entities) {
          if (entity.tap_action && entity.tap_action.action === "call-service" && !entity.tap_action.service || entity.hold_action && entity.hold_action.action === "call-service" && !entity.hold_action.service) {
            throw new Error('Missing required property "service" when tap_action or hold_action is call-service');
          }
        }

        const columns = config.columns || Math.min(config.entities.length, 5);
        this.style.setProperty("--glance-column-width", `${100 / columns}%`);
        this._configEntities = entities;

        if (this.hass) {
          this.requestUpdate();
        }
      }
    }, {
      kind: "method",
      key: "shouldUpdate",
      value: function shouldUpdate(changedProps) {
        if (changedProps.has("_config")) {
          return true;
        }

        const oldHass = changedProps.get("hass");

        if (!this._configEntities || !oldHass || oldHass.themes !== this.hass.themes || oldHass.language !== this.hass.language) {
          return true;
        }

        for (const entity of this._configEntities) {
          if (oldHass.states[entity.entity] !== this.hass.states[entity.entity]) {
            return true;
          }
        }

        return false;
      }
    }, {
      kind: "method",
      key: "render",
      value: function render() {
        if (!this._config || !this.hass) {
          return lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]``;
        }

        const {
          title
        } = this._config;
        return lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
      <ha-card .header="${title}">
        <div class="${Object(lit_html_directives_class_map__WEBPACK_IMPORTED_MODULE_1__["classMap"])({
          entities: true,
          "no-header": !title
        })}">
          ${this._configEntities.map(entityConf => this.renderEntity(entityConf))}
        </div>
      </ha-card>
    `;
      }
    }, {
      kind: "method",
      key: "updated",
      value: function updated(changedProps) {
        _get(_getPrototypeOf(HuiGlanceCard.prototype), "updated", this).call(this, changedProps);

        if (!this._config || !this.hass) {
          return;
        }

        const oldHass = changedProps.get("hass");
        const oldConfig = changedProps.get("_config");

        if (!oldHass || !oldConfig || oldHass.themes !== this.hass.themes || oldConfig.theme !== this._config.theme) {
          Object(_common_dom_apply_themes_on_element__WEBPACK_IMPORTED_MODULE_4__["applyThemesOnElement"])(this, this.hass.themes, this._config.theme);
        }
      }
    }, {
      kind: "get",
      static: true,
      key: "styles",
      value: function styles() {
        return lit_element__WEBPACK_IMPORTED_MODULE_0__["css"]`
      .entities {
        display: flex;
        padding: 0 16px 4px;
        flex-wrap: wrap;
      }
      .entities.no-header {
        padding-top: 16px;
      }
      .entity {
        box-sizing: border-box;
        padding: 0 4px;
        display: flex;
        flex-direction: column;
        align-items: center;
        cursor: pointer;
        margin-bottom: 12px;
        width: var(--glance-column-width, 20%);
      }
      .entity:focus {
        outline: none;
        background: var(--divider-color);
        border-radius: 14px;
        padding: 4px;
        margin: -4px 0;
      }
      .entity div {
        width: 100%;
        text-align: center;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
      }
      .name {
        min-height: var(--paper-font-body1_-_line-height, 20px);
      }
      state-badge {
        margin: 8px 0;
      }
    `;
      }
    }, {
      kind: "method",
      key: "renderEntity",
      value: function renderEntity(entityConf) {
        var _ref;

        const stateObj = this.hass.states[entityConf.entity];

        if (!stateObj) {
          return lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
        <hui-warning-element
          label=${this.hass.localize("ui.panel.lovelace.warning.entity_not_found", "entity", entityConf.entity)}
        ></hui-warning-element>
      `;
        }

        return lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
      <div
        class="entity"
        .config="${entityConf}"
        @action=${this._handleAction}
        .actionHandler=${Object(_common_directives_action_handler_directive__WEBPACK_IMPORTED_MODULE_12__["actionHandler"])({
          hasHold: Object(_common_has_action__WEBPACK_IMPORTED_MODULE_15__["hasAction"])(entityConf.hold_action),
          hasDoubleClick: Object(_common_has_action__WEBPACK_IMPORTED_MODULE_15__["hasAction"])(entityConf.double_tap_action)
        })}
        tabindex=${Object(lit_html_directives_if_defined__WEBPACK_IMPORTED_MODULE_2__["ifDefined"])(Object(_common_has_action__WEBPACK_IMPORTED_MODULE_15__["hasAction"])(entityConf.tap_action) ? "0" : undefined)}
      >
        ${this._config.show_name !== false ? lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
              <div class="name">
                ${"name" in entityConf ? entityConf.name : Object(_common_entity_compute_state_name__WEBPACK_IMPORTED_MODULE_7__["computeStateName"])(stateObj)}
              </div>
            ` : ""}
        ${this._config.show_icon !== false ? lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
              <state-badge
                .hass=${this.hass}
                .stateObj=${stateObj}
                .overrideIcon=${entityConf.icon}
                .overrideImage=${entityConf.image}
                .stateColor=${(_ref = entityConf.state_color === false || entityConf.state_color) !== null && _ref !== void 0 ? _ref : this._config.state_color}
              ></state-badge>
            ` : ""}
        ${this._config.show_state !== false && entityConf.show_state !== false ? lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
              <div>
                ${Object(_common_entity_compute_domain__WEBPACK_IMPORTED_MODULE_5__["computeDomain"])(entityConf.entity) === "sensor" && stateObj.attributes.device_class === "timestamp" && !_data_entity__WEBPACK_IMPORTED_MODULE_11__["UNAVAILABLE_STATES"].includes(stateObj.state) ? lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
                      <hui-timestamp-display
                        .hass=${this.hass}
                        .ts=${new Date(stateObj.state)}
                        .format=${entityConf.format}
                      ></hui-timestamp-display>
                    ` : entityConf.show_last_changed ? Object(_common_datetime_relative_time__WEBPACK_IMPORTED_MODULE_3__["default"])(new Date(stateObj.last_changed), this.hass.localize) : Object(_common_entity_compute_state_display__WEBPACK_IMPORTED_MODULE_6__["computeStateDisplay"])(this.hass.localize, stateObj, this.hass.language)}
              </div>
            ` : ""}
      </div>
    `;
      }
    }, {
      kind: "method",
      key: "_handleAction",
      value: function _handleAction(ev) {
        const config = ev.currentTarget.config;
        Object(_common_handle_action__WEBPACK_IMPORTED_MODULE_14__["handleAction"])(this, this.hass, config, ev.detail.action);
      }
    }]
  };
}, lit_element__WEBPACK_IMPORTED_MODULE_0__["LitElement"]);

/***/ }),

/***/ "./src/panels/lovelace/cards/hui-history-graph-card.ts":
/*!*************************************************************!*\
  !*** ./src/panels/lovelace/cards/hui-history-graph-card.ts ***!
  \*************************************************************/
/*! exports provided: HuiHistoryGraphCard */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HuiHistoryGraphCard", function() { return HuiHistoryGraphCard; });
/* harmony import */ var lit_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lit-element */ "./node_modules/lit-element/lit-element.js");
/* harmony import */ var lit_html_directives_class_map__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lit-html/directives/class-map */ "./node_modules/lit-html/directives/class-map.js");
/* harmony import */ var _components_ha_card__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../components/ha-card */ "./src/components/ha-card.ts");
/* harmony import */ var _components_state_history_charts__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../components/state-history-charts */ "./src/components/state-history-charts.js");
/* harmony import */ var _data_cached_history__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../data/cached-history */ "./src/data/cached-history.ts");
/* harmony import */ var _data_ha_state_history_data__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../data/ha-state-history-data */ "./src/data/ha-state-history-data.js");
/* harmony import */ var _common_find_entites__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../common/find-entites */ "./src/panels/lovelace/common/find-entites.ts");
/* harmony import */ var _common_process_config_entities__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../common/process-config-entities */ "./src/panels/lovelace/common/process-config-entities.ts");
function _decorate(decorators, factory, superClass, mixins) { var api = _getDecoratorsApi(); if (mixins) { for (var i = 0; i < mixins.length; i++) { api = mixins[i](api); } } var r = factory(function initialize(O) { api.initializeInstanceElements(O, decorated.elements); }, superClass); var decorated = api.decorateClass(_coalesceClassElements(r.d.map(_createElementDescriptor)), decorators); api.initializeClassElements(r.F, decorated.elements); return api.runClassFinishers(r.F, decorated.finishers); }

function _getDecoratorsApi() { _getDecoratorsApi = function () { return api; }; var api = { elementsDefinitionOrder: [["method"], ["field"]], initializeInstanceElements: function (O, elements) { ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { if (element.kind === kind && element.placement === "own") { this.defineClassElement(O, element); } }, this); }, this); }, initializeClassElements: function (F, elements) { var proto = F.prototype; ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { var placement = element.placement; if (element.kind === kind && (placement === "static" || placement === "prototype")) { var receiver = placement === "static" ? F : proto; this.defineClassElement(receiver, element); } }, this); }, this); }, defineClassElement: function (receiver, element) { var descriptor = element.descriptor; if (element.kind === "field") { var initializer = element.initializer; descriptor = { enumerable: descriptor.enumerable, writable: descriptor.writable, configurable: descriptor.configurable, value: initializer === void 0 ? void 0 : initializer.call(receiver) }; } Object.defineProperty(receiver, element.key, descriptor); }, decorateClass: function (elements, decorators) { var newElements = []; var finishers = []; var placements = { static: [], prototype: [], own: [] }; elements.forEach(function (element) { this.addElementPlacement(element, placements); }, this); elements.forEach(function (element) { if (!_hasDecorators(element)) return newElements.push(element); var elementFinishersExtras = this.decorateElement(element, placements); newElements.push(elementFinishersExtras.element); newElements.push.apply(newElements, elementFinishersExtras.extras); finishers.push.apply(finishers, elementFinishersExtras.finishers); }, this); if (!decorators) { return { elements: newElements, finishers: finishers }; } var result = this.decorateConstructor(newElements, decorators); finishers.push.apply(finishers, result.finishers); result.finishers = finishers; return result; }, addElementPlacement: function (element, placements, silent) { var keys = placements[element.placement]; if (!silent && keys.indexOf(element.key) !== -1) { throw new TypeError("Duplicated element (" + element.key + ")"); } keys.push(element.key); }, decorateElement: function (element, placements) { var extras = []; var finishers = []; for (var decorators = element.decorators, i = decorators.length - 1; i >= 0; i--) { var keys = placements[element.placement]; keys.splice(keys.indexOf(element.key), 1); var elementObject = this.fromElementDescriptor(element); var elementFinisherExtras = this.toElementFinisherExtras((0, decorators[i])(elementObject) || elementObject); element = elementFinisherExtras.element; this.addElementPlacement(element, placements); if (elementFinisherExtras.finisher) { finishers.push(elementFinisherExtras.finisher); } var newExtras = elementFinisherExtras.extras; if (newExtras) { for (var j = 0; j < newExtras.length; j++) { this.addElementPlacement(newExtras[j], placements); } extras.push.apply(extras, newExtras); } } return { element: element, finishers: finishers, extras: extras }; }, decorateConstructor: function (elements, decorators) { var finishers = []; for (var i = decorators.length - 1; i >= 0; i--) { var obj = this.fromClassDescriptor(elements); var elementsAndFinisher = this.toClassDescriptor((0, decorators[i])(obj) || obj); if (elementsAndFinisher.finisher !== undefined) { finishers.push(elementsAndFinisher.finisher); } if (elementsAndFinisher.elements !== undefined) { elements = elementsAndFinisher.elements; for (var j = 0; j < elements.length - 1; j++) { for (var k = j + 1; k < elements.length; k++) { if (elements[j].key === elements[k].key && elements[j].placement === elements[k].placement) { throw new TypeError("Duplicated element (" + elements[j].key + ")"); } } } } } return { elements: elements, finishers: finishers }; }, fromElementDescriptor: function (element) { var obj = { kind: element.kind, key: element.key, placement: element.placement, descriptor: element.descriptor }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); if (element.kind === "field") obj.initializer = element.initializer; return obj; }, toElementDescriptors: function (elementObjects) { if (elementObjects === undefined) return; return _toArray(elementObjects).map(function (elementObject) { var element = this.toElementDescriptor(elementObject); this.disallowProperty(elementObject, "finisher", "An element descriptor"); this.disallowProperty(elementObject, "extras", "An element descriptor"); return element; }, this); }, toElementDescriptor: function (elementObject) { var kind = String(elementObject.kind); if (kind !== "method" && kind !== "field") { throw new TypeError('An element descriptor\'s .kind property must be either "method" or' + ' "field", but a decorator created an element descriptor with' + ' .kind "' + kind + '"'); } var key = _toPropertyKey(elementObject.key); var placement = String(elementObject.placement); if (placement !== "static" && placement !== "prototype" && placement !== "own") { throw new TypeError('An element descriptor\'s .placement property must be one of "static",' + ' "prototype" or "own", but a decorator created an element descriptor' + ' with .placement "' + placement + '"'); } var descriptor = elementObject.descriptor; this.disallowProperty(elementObject, "elements", "An element descriptor"); var element = { kind: kind, key: key, placement: placement, descriptor: Object.assign({}, descriptor) }; if (kind !== "field") { this.disallowProperty(elementObject, "initializer", "A method descriptor"); } else { this.disallowProperty(descriptor, "get", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "set", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "value", "The property descriptor of a field descriptor"); element.initializer = elementObject.initializer; } return element; }, toElementFinisherExtras: function (elementObject) { var element = this.toElementDescriptor(elementObject); var finisher = _optionalCallableProperty(elementObject, "finisher"); var extras = this.toElementDescriptors(elementObject.extras); return { element: element, finisher: finisher, extras: extras }; }, fromClassDescriptor: function (elements) { var obj = { kind: "class", elements: elements.map(this.fromElementDescriptor, this) }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); return obj; }, toClassDescriptor: function (obj) { var kind = String(obj.kind); if (kind !== "class") { throw new TypeError('A class descriptor\'s .kind property must be "class", but a decorator' + ' created a class descriptor with .kind "' + kind + '"'); } this.disallowProperty(obj, "key", "A class descriptor"); this.disallowProperty(obj, "placement", "A class descriptor"); this.disallowProperty(obj, "descriptor", "A class descriptor"); this.disallowProperty(obj, "initializer", "A class descriptor"); this.disallowProperty(obj, "extras", "A class descriptor"); var finisher = _optionalCallableProperty(obj, "finisher"); var elements = this.toElementDescriptors(obj.elements); return { elements: elements, finisher: finisher }; }, runClassFinishers: function (constructor, finishers) { for (var i = 0; i < finishers.length; i++) { var newConstructor = (0, finishers[i])(constructor); if (newConstructor !== undefined) { if (typeof newConstructor !== "function") { throw new TypeError("Finishers must return a constructor."); } constructor = newConstructor; } } return constructor; }, disallowProperty: function (obj, name, objectType) { if (obj[name] !== undefined) { throw new TypeError(objectType + " can't have a ." + name + " property."); } } }; return api; }

function _createElementDescriptor(def) { var key = _toPropertyKey(def.key); var descriptor; if (def.kind === "method") { descriptor = { value: def.value, writable: true, configurable: true, enumerable: false }; } else if (def.kind === "get") { descriptor = { get: def.value, configurable: true, enumerable: false }; } else if (def.kind === "set") { descriptor = { set: def.value, configurable: true, enumerable: false }; } else if (def.kind === "field") { descriptor = { configurable: true, writable: true, enumerable: true }; } var element = { kind: def.kind === "field" ? "field" : "method", key: key, placement: def.static ? "static" : def.kind === "field" ? "own" : "prototype", descriptor: descriptor }; if (def.decorators) element.decorators = def.decorators; if (def.kind === "field") element.initializer = def.value; return element; }

function _coalesceGetterSetter(element, other) { if (element.descriptor.get !== undefined) { other.descriptor.get = element.descriptor.get; } else { other.descriptor.set = element.descriptor.set; } }

function _coalesceClassElements(elements) { var newElements = []; var isSameElement = function (other) { return other.kind === "method" && other.key === element.key && other.placement === element.placement; }; for (var i = 0; i < elements.length; i++) { var element = elements[i]; var other; if (element.kind === "method" && (other = newElements.find(isSameElement))) { if (_isDataDescriptor(element.descriptor) || _isDataDescriptor(other.descriptor)) { if (_hasDecorators(element) || _hasDecorators(other)) { throw new ReferenceError("Duplicated methods (" + element.key + ") can't be decorated."); } other.descriptor = element.descriptor; } else { if (_hasDecorators(element)) { if (_hasDecorators(other)) { throw new ReferenceError("Decorators can't be placed on different accessors with for " + "the same property (" + element.key + ")."); } other.decorators = element.decorators; } _coalesceGetterSetter(element, other); } } else { newElements.push(element); } } return newElements; }

function _hasDecorators(element) { return element.decorators && element.decorators.length; }

function _isDataDescriptor(desc) { return desc !== undefined && !(desc.value === undefined && desc.writable === undefined); }

function _optionalCallableProperty(obj, name) { var value = obj[name]; if (value !== undefined && typeof value !== "function") { throw new TypeError("Expected '" + name + "' to be a function"); } return value; }

function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }

function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }

function _toArray(arr) { return _arrayWithHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(n); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get; } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return _get(target, property, receiver || target); }

function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }









let HuiHistoryGraphCard = _decorate([Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["customElement"])("hui-history-graph-card")], function (_initialize, _LitElement) {
  class HuiHistoryGraphCard extends _LitElement {
    constructor(...args) {
      super(...args);

      _initialize(this);
    }

  }

  return {
    F: HuiHistoryGraphCard,
    d: [{
      kind: "method",
      static: true,
      key: "getConfigElement",
      value: async function getConfigElement() {
        await Promise.all(/*! import() | hui-history-graph-card-editor */[__webpack_require__.e(7), __webpack_require__.e(8), __webpack_require__.e("vendors~hui-alarm-panel-card-editor~hui-button-card-editor~hui-conditional-card-editor~hui-entities-~37aad430"), __webpack_require__.e("vendors~hui-history-graph-card-editor"), __webpack_require__.e(10), __webpack_require__.e("hui-button-card-editor~hui-dialog-edit-view~hui-entities-card-editor~hui-entity-card-editor~hui-gaug~aa2f21d6"), __webpack_require__.e("hui-history-graph-card-editor")]).then(__webpack_require__.bind(null, /*! ../editor/config-elements/hui-history-graph-card-editor */ "./src/panels/lovelace/editor/config-elements/hui-history-graph-card-editor.ts"));
        return document.createElement("hui-history-graph-card-editor");
      }
    }, {
      kind: "method",
      static: true,
      key: "getStubConfig",
      value: function getStubConfig(hass, entities, entitiesFallback) {
        const includeDomains = ["sensor"];
        const maxEntities = 1;
        const foundEntities = Object(_common_find_entites__WEBPACK_IMPORTED_MODULE_6__["findEntities"])(hass, maxEntities, entities, entitiesFallback, includeDomains);
        return {
          type: "history-graph",
          entities: foundEntities
        };
      }
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "hass",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "_stateHistory",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "_config",
      value: void 0
    }, {
      kind: "field",
      key: "_configEntities",
      value: void 0
    }, {
      kind: "field",
      key: "_names",

      value() {
        return {};
      }

    }, {
      kind: "field",
      key: "_cacheConfig",
      value: void 0
    }, {
      kind: "field",
      key: "_interval",
      value: void 0
    }, {
      kind: "method",
      key: "getCardSize",
      value: function getCardSize() {
        return 4;
      }
    }, {
      kind: "method",
      key: "setConfig",
      value: function setConfig(config) {
        if (!config.entities) {
          throw new Error("Entities must be defined");
        }

        if (config.entities && !Array.isArray(config.entities)) {
          throw new Error("Entities need to be an array");
        }

        this._config = config;
        this._configEntities = config.entities ? Object(_common_process_config_entities__WEBPACK_IMPORTED_MODULE_7__["processConfigEntities"])(config.entities) : [];
        const _entities = [];

        this._configEntities.forEach(entity => {
          _entities.push(entity.entity);

          if (entity.name) {
            this._names[entity.entity] = entity.name;
          }
        });

        this._cacheConfig = {
          cacheKey: _entities.join(),
          hoursToShow: config.hours_to_show || 24,
          refresh: config.refresh_interval || 0
        };
      }
    }, {
      kind: "method",
      key: "disconnectedCallback",
      value: function disconnectedCallback() {
        _get(_getPrototypeOf(HuiHistoryGraphCard.prototype), "disconnectedCallback", this).call(this);

        this._clearInterval();
      }
    }, {
      kind: "method",
      key: "updated",
      value: function updated(changedProps) {
        _get(_getPrototypeOf(HuiHistoryGraphCard.prototype), "updated", this).call(this, changedProps);

        if (!this._config || !this.hass || !this._cacheConfig) {
          return;
        }

        if (!changedProps.has("_config")) {
          return;
        }

        const oldConfig = changedProps.get("_config");

        if (oldConfig !== this._config) {
          this._getStateHistory();

          this._clearInterval();

          if (!this._interval && this._cacheConfig.refresh) {
            this._interval = window.setInterval(() => {
              this._getStateHistory();
            }, this._cacheConfig.refresh * 1000);
          }
        }
      }
    }, {
      kind: "method",
      key: "render",
      value: function render() {
        if (!this.hass || !this._config) {
          return lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]``;
        }

        return lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
      <ha-card .header="${this._config.title}">
        <div
          class="content ${Object(lit_html_directives_class_map__WEBPACK_IMPORTED_MODULE_1__["classMap"])({
          "has-header": !!this._config.title
        })}"
        >
          <state-history-charts
            .hass=${this.hass}
            .historyData=${this._stateHistory}
            .names=${this._names}
            .upToNow=${true}
            .noSingle=${true}
          ></state-history-charts>
        </div>
      </ha-card>
    `;
      }
    }, {
      kind: "method",
      key: "_getStateHistory",
      value: function _getStateHistory() {
        Object(_data_cached_history__WEBPACK_IMPORTED_MODULE_4__["getRecentWithCache"])(this.hass, this._cacheConfig.cacheKey, this._cacheConfig, this.hass.localize, this.hass.language).then(stateHistory => {
          this._stateHistory = Object.assign({}, this._stateHistory, {}, stateHistory);
        });
      }
    }, {
      kind: "method",
      key: "_clearInterval",
      value: function _clearInterval() {
        if (this._interval) {
          window.clearInterval(this._interval);
          this._interval = undefined;
        }
      }
    }, {
      kind: "get",
      static: true,
      key: "styles",
      value: function styles() {
        return lit_element__WEBPACK_IMPORTED_MODULE_0__["css"]`
      .content {
        padding: 16px;
      }
      .has-header {
        padding-top: 0;
      }
    `;
      }
    }]
  };
}, lit_element__WEBPACK_IMPORTED_MODULE_0__["LitElement"]);

/***/ }),

/***/ "./src/panels/lovelace/cards/hui-horizontal-stack-card.ts":
/*!****************************************************************!*\
  !*** ./src/panels/lovelace/cards/hui-horizontal-stack-card.ts ***!
  \****************************************************************/
/*! no exports provided */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var lit_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lit-element */ "./node_modules/lit-element/lit-element.js");
/* harmony import */ var _common_compute_card_size__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../common/compute-card-size */ "./src/panels/lovelace/common/compute-card-size.ts");
/* harmony import */ var _hui_stack_card__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./hui-stack-card */ "./src/panels/lovelace/cards/hui-stack-card.ts");




class HuiHorizontalStackCard extends _hui_stack_card__WEBPACK_IMPORTED_MODULE_2__["HuiStackCard"] {
  getCardSize() {
    let totalSize = 0;

    if (this._cards) {
      for (const element of this._cards) {
        const elementSize = Object(_common_compute_card_size__WEBPACK_IMPORTED_MODULE_1__["computeCardSize"])(element);
        totalSize = elementSize > totalSize ? elementSize : totalSize;
      }
    }

    return totalSize;
  }

  static get styles() {
    return [super.sharedStyles, lit_element__WEBPACK_IMPORTED_MODULE_0__["css"]`
        #root {
          display: flex;
        }
        #root > * {
          flex: 1 1 0;
          margin: 0 4px;
          min-width: 0;
        }
        #root > *:first-child {
          margin-left: 0;
        }
        #root > *:last-child {
          margin-right: 0;
        }
      `];
  }

}

customElements.define("hui-horizontal-stack-card", HuiHorizontalStackCard);

/***/ }),

/***/ "./src/panels/lovelace/cards/hui-light-card.ts":
/*!*****************************************************!*\
  !*** ./src/panels/lovelace/cards/hui-light-card.ts ***!
  \*****************************************************/
/*! exports provided: HuiLightCard */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HuiLightCard", function() { return HuiLightCard; });
/* harmony import */ var _polymer_paper_icon_button_paper_icon_button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @polymer/paper-icon-button/paper-icon-button */ "./node_modules/@polymer/paper-icon-button/paper-icon-button.js");
/* harmony import */ var _thomasloven_round_slider__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @thomasloven/round-slider */ "./node_modules/@thomasloven/round-slider/src/main.js");
/* harmony import */ var lit_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lit-element */ "./node_modules/lit-element/lit-element.js");
/* harmony import */ var lit_html_directives_class_map__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lit-html/directives/class-map */ "./node_modules/lit-html/directives/class-map.js");
/* harmony import */ var lit_html_directives_style_map__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! lit-html/directives/style-map */ "./node_modules/lit-html/directives/style-map.js");
/* harmony import */ var _common_dom_apply_themes_on_element__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../common/dom/apply_themes_on_element */ "./src/common/dom/apply_themes_on_element.ts");
/* harmony import */ var _common_dom_fire_event__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../common/dom/fire_event */ "./src/common/dom/fire_event.ts");
/* harmony import */ var _common_entity_compute_state_display__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../common/entity/compute_state_display */ "./src/common/entity/compute_state_display.ts");
/* harmony import */ var _common_entity_compute_state_name__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../common/entity/compute_state_name */ "./src/common/entity/compute_state_name.ts");
/* harmony import */ var _common_entity_state_icon__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../../common/entity/state_icon */ "./src/common/entity/state_icon.ts");
/* harmony import */ var _common_entity_supports_feature__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../../common/entity/supports-feature */ "./src/common/entity/supports-feature.ts");
/* harmony import */ var _components_ha_card__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../../components/ha-card */ "./src/components/ha-card.ts");
/* harmony import */ var _data_entity__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../../data/entity */ "./src/data/entity.ts");
/* harmony import */ var _data_light__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../../data/light */ "./src/data/light.ts");
/* harmony import */ var _common_directives_action_handler_directive__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../common/directives/action-handler-directive */ "./src/panels/lovelace/common/directives/action-handler-directive.ts");
/* harmony import */ var _common_find_entites__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../common/find-entites */ "./src/panels/lovelace/common/find-entites.ts");
/* harmony import */ var _common_handle_action__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../common/handle-action */ "./src/panels/lovelace/common/handle-action.ts");
/* harmony import */ var _common_has_action__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../common/has-action */ "./src/panels/lovelace/common/has-action.ts");
/* harmony import */ var _common_has_changed__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../common/has-changed */ "./src/panels/lovelace/common/has-changed.ts");
/* harmony import */ var _components_hui_warning__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../components/hui-warning */ "./src/panels/lovelace/components/hui-warning.ts");
function _decorate(decorators, factory, superClass, mixins) { var api = _getDecoratorsApi(); if (mixins) { for (var i = 0; i < mixins.length; i++) { api = mixins[i](api); } } var r = factory(function initialize(O) { api.initializeInstanceElements(O, decorated.elements); }, superClass); var decorated = api.decorateClass(_coalesceClassElements(r.d.map(_createElementDescriptor)), decorators); api.initializeClassElements(r.F, decorated.elements); return api.runClassFinishers(r.F, decorated.finishers); }

function _getDecoratorsApi() { _getDecoratorsApi = function () { return api; }; var api = { elementsDefinitionOrder: [["method"], ["field"]], initializeInstanceElements: function (O, elements) { ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { if (element.kind === kind && element.placement === "own") { this.defineClassElement(O, element); } }, this); }, this); }, initializeClassElements: function (F, elements) { var proto = F.prototype; ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { var placement = element.placement; if (element.kind === kind && (placement === "static" || placement === "prototype")) { var receiver = placement === "static" ? F : proto; this.defineClassElement(receiver, element); } }, this); }, this); }, defineClassElement: function (receiver, element) { var descriptor = element.descriptor; if (element.kind === "field") { var initializer = element.initializer; descriptor = { enumerable: descriptor.enumerable, writable: descriptor.writable, configurable: descriptor.configurable, value: initializer === void 0 ? void 0 : initializer.call(receiver) }; } Object.defineProperty(receiver, element.key, descriptor); }, decorateClass: function (elements, decorators) { var newElements = []; var finishers = []; var placements = { static: [], prototype: [], own: [] }; elements.forEach(function (element) { this.addElementPlacement(element, placements); }, this); elements.forEach(function (element) { if (!_hasDecorators(element)) return newElements.push(element); var elementFinishersExtras = this.decorateElement(element, placements); newElements.push(elementFinishersExtras.element); newElements.push.apply(newElements, elementFinishersExtras.extras); finishers.push.apply(finishers, elementFinishersExtras.finishers); }, this); if (!decorators) { return { elements: newElements, finishers: finishers }; } var result = this.decorateConstructor(newElements, decorators); finishers.push.apply(finishers, result.finishers); result.finishers = finishers; return result; }, addElementPlacement: function (element, placements, silent) { var keys = placements[element.placement]; if (!silent && keys.indexOf(element.key) !== -1) { throw new TypeError("Duplicated element (" + element.key + ")"); } keys.push(element.key); }, decorateElement: function (element, placements) { var extras = []; var finishers = []; for (var decorators = element.decorators, i = decorators.length - 1; i >= 0; i--) { var keys = placements[element.placement]; keys.splice(keys.indexOf(element.key), 1); var elementObject = this.fromElementDescriptor(element); var elementFinisherExtras = this.toElementFinisherExtras((0, decorators[i])(elementObject) || elementObject); element = elementFinisherExtras.element; this.addElementPlacement(element, placements); if (elementFinisherExtras.finisher) { finishers.push(elementFinisherExtras.finisher); } var newExtras = elementFinisherExtras.extras; if (newExtras) { for (var j = 0; j < newExtras.length; j++) { this.addElementPlacement(newExtras[j], placements); } extras.push.apply(extras, newExtras); } } return { element: element, finishers: finishers, extras: extras }; }, decorateConstructor: function (elements, decorators) { var finishers = []; for (var i = decorators.length - 1; i >= 0; i--) { var obj = this.fromClassDescriptor(elements); var elementsAndFinisher = this.toClassDescriptor((0, decorators[i])(obj) || obj); if (elementsAndFinisher.finisher !== undefined) { finishers.push(elementsAndFinisher.finisher); } if (elementsAndFinisher.elements !== undefined) { elements = elementsAndFinisher.elements; for (var j = 0; j < elements.length - 1; j++) { for (var k = j + 1; k < elements.length; k++) { if (elements[j].key === elements[k].key && elements[j].placement === elements[k].placement) { throw new TypeError("Duplicated element (" + elements[j].key + ")"); } } } } } return { elements: elements, finishers: finishers }; }, fromElementDescriptor: function (element) { var obj = { kind: element.kind, key: element.key, placement: element.placement, descriptor: element.descriptor }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); if (element.kind === "field") obj.initializer = element.initializer; return obj; }, toElementDescriptors: function (elementObjects) { if (elementObjects === undefined) return; return _toArray(elementObjects).map(function (elementObject) { var element = this.toElementDescriptor(elementObject); this.disallowProperty(elementObject, "finisher", "An element descriptor"); this.disallowProperty(elementObject, "extras", "An element descriptor"); return element; }, this); }, toElementDescriptor: function (elementObject) { var kind = String(elementObject.kind); if (kind !== "method" && kind !== "field") { throw new TypeError('An element descriptor\'s .kind property must be either "method" or' + ' "field", but a decorator created an element descriptor with' + ' .kind "' + kind + '"'); } var key = _toPropertyKey(elementObject.key); var placement = String(elementObject.placement); if (placement !== "static" && placement !== "prototype" && placement !== "own") { throw new TypeError('An element descriptor\'s .placement property must be one of "static",' + ' "prototype" or "own", but a decorator created an element descriptor' + ' with .placement "' + placement + '"'); } var descriptor = elementObject.descriptor; this.disallowProperty(elementObject, "elements", "An element descriptor"); var element = { kind: kind, key: key, placement: placement, descriptor: Object.assign({}, descriptor) }; if (kind !== "field") { this.disallowProperty(elementObject, "initializer", "A method descriptor"); } else { this.disallowProperty(descriptor, "get", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "set", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "value", "The property descriptor of a field descriptor"); element.initializer = elementObject.initializer; } return element; }, toElementFinisherExtras: function (elementObject) { var element = this.toElementDescriptor(elementObject); var finisher = _optionalCallableProperty(elementObject, "finisher"); var extras = this.toElementDescriptors(elementObject.extras); return { element: element, finisher: finisher, extras: extras }; }, fromClassDescriptor: function (elements) { var obj = { kind: "class", elements: elements.map(this.fromElementDescriptor, this) }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); return obj; }, toClassDescriptor: function (obj) { var kind = String(obj.kind); if (kind !== "class") { throw new TypeError('A class descriptor\'s .kind property must be "class", but a decorator' + ' created a class descriptor with .kind "' + kind + '"'); } this.disallowProperty(obj, "key", "A class descriptor"); this.disallowProperty(obj, "placement", "A class descriptor"); this.disallowProperty(obj, "descriptor", "A class descriptor"); this.disallowProperty(obj, "initializer", "A class descriptor"); this.disallowProperty(obj, "extras", "A class descriptor"); var finisher = _optionalCallableProperty(obj, "finisher"); var elements = this.toElementDescriptors(obj.elements); return { elements: elements, finisher: finisher }; }, runClassFinishers: function (constructor, finishers) { for (var i = 0; i < finishers.length; i++) { var newConstructor = (0, finishers[i])(constructor); if (newConstructor !== undefined) { if (typeof newConstructor !== "function") { throw new TypeError("Finishers must return a constructor."); } constructor = newConstructor; } } return constructor; }, disallowProperty: function (obj, name, objectType) { if (obj[name] !== undefined) { throw new TypeError(objectType + " can't have a ." + name + " property."); } } }; return api; }

function _createElementDescriptor(def) { var key = _toPropertyKey(def.key); var descriptor; if (def.kind === "method") { descriptor = { value: def.value, writable: true, configurable: true, enumerable: false }; } else if (def.kind === "get") { descriptor = { get: def.value, configurable: true, enumerable: false }; } else if (def.kind === "set") { descriptor = { set: def.value, configurable: true, enumerable: false }; } else if (def.kind === "field") { descriptor = { configurable: true, writable: true, enumerable: true }; } var element = { kind: def.kind === "field" ? "field" : "method", key: key, placement: def.static ? "static" : def.kind === "field" ? "own" : "prototype", descriptor: descriptor }; if (def.decorators) element.decorators = def.decorators; if (def.kind === "field") element.initializer = def.value; return element; }

function _coalesceGetterSetter(element, other) { if (element.descriptor.get !== undefined) { other.descriptor.get = element.descriptor.get; } else { other.descriptor.set = element.descriptor.set; } }

function _coalesceClassElements(elements) { var newElements = []; var isSameElement = function (other) { return other.kind === "method" && other.key === element.key && other.placement === element.placement; }; for (var i = 0; i < elements.length; i++) { var element = elements[i]; var other; if (element.kind === "method" && (other = newElements.find(isSameElement))) { if (_isDataDescriptor(element.descriptor) || _isDataDescriptor(other.descriptor)) { if (_hasDecorators(element) || _hasDecorators(other)) { throw new ReferenceError("Duplicated methods (" + element.key + ") can't be decorated."); } other.descriptor = element.descriptor; } else { if (_hasDecorators(element)) { if (_hasDecorators(other)) { throw new ReferenceError("Decorators can't be placed on different accessors with for " + "the same property (" + element.key + ")."); } other.decorators = element.decorators; } _coalesceGetterSetter(element, other); } } else { newElements.push(element); } } return newElements; }

function _hasDecorators(element) { return element.decorators && element.decorators.length; }

function _isDataDescriptor(desc) { return desc !== undefined && !(desc.value === undefined && desc.writable === undefined); }

function _optionalCallableProperty(obj, name) { var value = obj[name]; if (value !== undefined && typeof value !== "function") { throw new TypeError("Expected '" + name + "' to be a function"); } return value; }

function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }

function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }

function _toArray(arr) { return _arrayWithHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(n); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get; } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return _get(target, property, receiver || target); }

function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }





















let HuiLightCard = _decorate([Object(lit_element__WEBPACK_IMPORTED_MODULE_2__["customElement"])("hui-light-card")], function (_initialize, _LitElement) {
  class HuiLightCard extends _LitElement {
    constructor(...args) {
      super(...args);

      _initialize(this);
    }

  }

  return {
    F: HuiLightCard,
    d: [{
      kind: "method",
      static: true,
      key: "getConfigElement",
      value: async function getConfigElement() {
        await Promise.all(/*! import() | hui-light-card-editor */[__webpack_require__.e(1), __webpack_require__.e(0), __webpack_require__.e(2), __webpack_require__.e(3), __webpack_require__.e(6), __webpack_require__.e(7), __webpack_require__.e(8), __webpack_require__.e("vendors~hui-alarm-panel-card-editor~hui-button-card-editor~hui-conditional-card-editor~hui-entities-~37aad430"), __webpack_require__.e("vendors~hui-button-card-editor~hui-dialog-delete-card~hui-dialog-edit-card~hui-dialog-suggest-card~h~a8cf51a3"), __webpack_require__.e("vendors~hui-light-card-editor"), __webpack_require__.e(10), __webpack_require__.e("hui-alarm-panel-card-editor~hui-button-card-editor~hui-dialog-edit-view~hui-entities-card-editor~hui~192a43f6"), __webpack_require__.e("hui-button-card-editor~hui-dialog-edit-view~hui-entities-card-editor~hui-entity-card-editor~hui-gaug~aa2f21d6"), __webpack_require__.e("entity-editor-dialog~helper-detail-dialog~hui-button-card-editor~hui-entity-card-editor~hui-light-ca~1d54093c"), __webpack_require__.e("hui-button-card-editor~hui-entity-card-editor~hui-light-card-editor~hui-picture-card-editor~hui-pict~6832566a"), __webpack_require__.e("hui-light-card-editor")]).then(__webpack_require__.bind(null, /*! ../editor/config-elements/hui-light-card-editor */ "./src/panels/lovelace/editor/config-elements/hui-light-card-editor.ts"));
        return document.createElement("hui-light-card-editor");
      }
    }, {
      kind: "method",
      static: true,
      key: "getStubConfig",
      value: function getStubConfig(hass, entities, entitiesFallback) {
        const includeDomains = ["light"];
        const maxEntities = 1;
        const foundEntities = Object(_common_find_entites__WEBPACK_IMPORTED_MODULE_15__["findEntities"])(hass, maxEntities, entities, entitiesFallback, includeDomains);
        return {
          type: "light",
          entity: foundEntities[0] || ""
        };
      }
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_2__["property"])()],
      key: "hass",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_2__["property"])()],
      key: "_config",
      value: void 0
    }, {
      kind: "field",
      key: "_brightnessTimout",
      value: void 0
    }, {
      kind: "method",
      key: "getCardSize",
      value: function getCardSize() {
        return 2;
      }
    }, {
      kind: "method",
      key: "setConfig",
      value: function setConfig(config) {
        if (!config.entity || config.entity.split(".")[0] !== "light") {
          throw new Error("Specify an entity from within the light domain.");
        }

        this._config = Object.assign({}, config, {
          tap_action: {
            action: "toggle"
          }
        });
      }
    }, {
      kind: "method",
      key: "render",
      value: function render() {
        if (!this.hass || !this._config) {
          return lit_element__WEBPACK_IMPORTED_MODULE_2__["html"]``;
        }

        const stateObj = this.hass.states[this._config.entity];

        if (!stateObj) {
          return lit_element__WEBPACK_IMPORTED_MODULE_2__["html"]`
        <hui-warning
          >${this.hass.localize("ui.panel.lovelace.warning.entity_not_found", "entity", this._config.entity)}</hui-warning
        >
      `;
        }

        const brightness = Math.round(stateObj.attributes.brightness / 254 * 100) || 0;
        return lit_element__WEBPACK_IMPORTED_MODULE_2__["html"]`
      <ha-card>
        <paper-icon-button
          icon="hass:dots-vertical"
          class="more-info"
          @click=${this._handleMoreInfo}
          tabindex="0"
        ></paper-icon-button>

        <div class="content">
          <div id="controls">
            <div id="slider">
              <round-slider
                min="0"
                .value=${brightness}
                .disabled=${_data_entity__WEBPACK_IMPORTED_MODULE_12__["UNAVAILABLE_STATES"].includes(stateObj.state)}
                @value-changing=${this._dragEvent}
                @value-changed=${this._setBrightness}
                style=${Object(lit_html_directives_style_map__WEBPACK_IMPORTED_MODULE_4__["styleMap"])({
          visibility: Object(_common_entity_supports_feature__WEBPACK_IMPORTED_MODULE_10__["supportsFeature"])(stateObj, _data_light__WEBPACK_IMPORTED_MODULE_13__["SUPPORT_BRIGHTNESS"]) ? "visible" : "hidden"
        })}
              ></round-slider>
              <paper-icon-button
                class="light-button ${Object(lit_html_directives_class_map__WEBPACK_IMPORTED_MODULE_3__["classMap"])({
          "slider-center": Object(_common_entity_supports_feature__WEBPACK_IMPORTED_MODULE_10__["supportsFeature"])(stateObj, _data_light__WEBPACK_IMPORTED_MODULE_13__["SUPPORT_BRIGHTNESS"]),
          "state-on": stateObj.state === "on",
          "state-unavailable": stateObj.state === "unavailable"
        })}"
                .disabled=${_data_entity__WEBPACK_IMPORTED_MODULE_12__["UNAVAILABLE_STATES"].includes(stateObj.state)}
                .icon=${this._config.icon || Object(_common_entity_state_icon__WEBPACK_IMPORTED_MODULE_9__["stateIcon"])(stateObj)}
                style=${Object(lit_html_directives_style_map__WEBPACK_IMPORTED_MODULE_4__["styleMap"])({
          filter: this._computeBrightness(stateObj),
          color: this._computeColor(stateObj)
        })}
                @action=${this._handleAction}
                .actionHandler=${Object(_common_directives_action_handler_directive__WEBPACK_IMPORTED_MODULE_14__["actionHandler"])({
          hasHold: Object(_common_has_action__WEBPACK_IMPORTED_MODULE_17__["hasAction"])(this._config.hold_action),
          hasDoubleClick: Object(_common_has_action__WEBPACK_IMPORTED_MODULE_17__["hasAction"])(this._config.double_tap_action)
        })}
                tabindex="0"
              ></paper-icon-button>
            </div>
          </div>

          <div id="info">
            ${_data_entity__WEBPACK_IMPORTED_MODULE_12__["UNAVAILABLE_STATES"].includes(stateObj.state) ? lit_element__WEBPACK_IMPORTED_MODULE_2__["html"]`
                  <div>
                    ${Object(_common_entity_compute_state_display__WEBPACK_IMPORTED_MODULE_7__["computeStateDisplay"])(this.hass.localize, stateObj, this.hass.language)}
                  </div>
                ` : lit_element__WEBPACK_IMPORTED_MODULE_2__["html"]`
                  <div class="brightness">
                    %
                  </div>
                `}
            ${this._config.name || Object(_common_entity_compute_state_name__WEBPACK_IMPORTED_MODULE_8__["computeStateName"])(stateObj)}
          </div>
        </div>
      </ha-card>
    `;
      }
    }, {
      kind: "method",
      key: "shouldUpdate",
      value: function shouldUpdate(changedProps) {
        return Object(_common_has_changed__WEBPACK_IMPORTED_MODULE_18__["hasConfigOrEntityChanged"])(this, changedProps);
      }
    }, {
      kind: "method",
      key: "updated",
      value: function updated(changedProps) {
        _get(_getPrototypeOf(HuiLightCard.prototype), "updated", this).call(this, changedProps);

        if (!this._config || !this.hass) {
          return;
        }

        const stateObj = this.hass.states[this._config.entity];

        if (!stateObj) {
          return;
        }

        const oldHass = changedProps.get("hass");
        const oldConfig = changedProps.get("_config");

        if (!oldHass || !oldConfig || oldHass.themes !== this.hass.themes || oldConfig.theme !== this._config.theme) {
          Object(_common_dom_apply_themes_on_element__WEBPACK_IMPORTED_MODULE_5__["applyThemesOnElement"])(this, this.hass.themes, this._config.theme);
        }
      }
    }, {
      kind: "method",
      key: "_dragEvent",
      value: function _dragEvent(e) {
        this.shadowRoot.querySelector(".brightness").innerHTML = `${e.detail.value} %`;

        this._showBrightness();

        this._hideBrightness();
      }
    }, {
      kind: "method",
      key: "_showBrightness",
      value: function _showBrightness() {
        clearTimeout(this._brightnessTimout);
        this.shadowRoot.querySelector(".brightness").classList.add("show_brightness");
      }
    }, {
      kind: "method",
      key: "_hideBrightness",
      value: function _hideBrightness() {
        this._brightnessTimout = window.setTimeout(() => {
          this.shadowRoot.querySelector(".brightness").classList.remove("show_brightness");
        }, 500);
      }
    }, {
      kind: "method",
      key: "_setBrightness",
      value: function _setBrightness(e) {
        this.hass.callService("light", "turn_on", {
          entity_id: this._config.entity,
          brightness_pct: e.detail.value
        });
      }
    }, {
      kind: "method",
      key: "_computeBrightness",
      value: function _computeBrightness(stateObj) {
        if (stateObj.state === "off" || !stateObj.attributes.brightness) {
          return "";
        }

        const brightness = stateObj.attributes.brightness;
        return `brightness(${(brightness + 245) / 5}%)`;
      }
    }, {
      kind: "method",
      key: "_computeColor",
      value: function _computeColor(stateObj) {
        if (stateObj.state === "off" || !stateObj.attributes.hs_color) {
          return "";
        }

        const [hue, sat] = stateObj.attributes.hs_color;

        if (sat <= 10) {
          return "";
        }

        return `hsl(${hue}, 100%, ${100 - sat / 2}%)`;
      }
    }, {
      kind: "method",
      key: "_handleAction",
      value: function _handleAction(ev) {
        Object(_common_handle_action__WEBPACK_IMPORTED_MODULE_16__["handleAction"])(this, this.hass, this._config, ev.detail.action);
      }
    }, {
      kind: "method",
      key: "_handleMoreInfo",
      value: function _handleMoreInfo() {
        Object(_common_dom_fire_event__WEBPACK_IMPORTED_MODULE_6__["fireEvent"])(this, "hass-more-info", {
          entityId: this._config.entity
        });
      }
    }, {
      kind: "get",
      static: true,
      key: "styles",
      value: function styles() {
        return lit_element__WEBPACK_IMPORTED_MODULE_2__["css"]`
      :host {
        display: block;
      }

      ha-card {
        height: 100%;
        box-sizing: border-box;
        position: relative;
        overflow: hidden;
        text-align: center;
        --name-font-size: 1.2rem;
        --brightness-font-size: 1.2rem;
      }

      .more-info {
        position: absolute;
        cursor: pointer;
        top: 0;
        right: 0;
        border-radius: 100%;
        color: var(--secondary-text-color);
        z-index: 25;
      }

      .content {
        height: 100%;
        display: flex;
        flex-direction: column;
        justify-content: center;
      }

      #controls {
        display: flex;
        justify-content: center;
        padding: 16px;
        position: relative;
      }

      #slider {
        height: 100%;
        width: 100%;
        position: relative;
        max-width: 200px;
        min-width: 100px;
      }

      round-slider {
        --round-slider-path-color: var(--disabled-text-color);
        --round-slider-bar-color: var(--primary-color);
        padding-bottom: 10%;
      }

      .light-button {
        color: var(--paper-item-icon-color, #44739e);
        width: 60%;
        height: auto;
        position: absolute;
        max-width: calc(100% - 40px);
        box-sizing: border-box;
        border-radius: 100%;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
      }

      .light-button.state-on {
        color: var(--paper-item-icon-active-color, #fdd835);
      }

      .light-button.state-unavailable {
        color: var(--state-icon-unavailable-color);
      }

      #info {
        text-align: center;
        margin-top: -56px;
        padding: 16px;
        font-size: var(--name-font-size);
      }

      .brightness {
        font-size: var(--brightness-font-size);
        opacity: 0;
        transition: opacity 0.5s ease-in-out;
        -moz-transition: opacity 0.5s ease-in-out;
        -webkit-transition: opacity 0.5s ease-in-out;
      }

      .show_brightness {
        opacity: 1;
      }
    `;
      }
    }]
  };
}, lit_element__WEBPACK_IMPORTED_MODULE_2__["LitElement"]);

/***/ }),

/***/ "./src/panels/lovelace/cards/hui-sensor-card.ts":
/*!******************************************************!*\
  !*** ./src/panels/lovelace/cards/hui-sensor-card.ts ***!
  \******************************************************/
/*! no exports provided */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var lit_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lit-element */ "./node_modules/lit-element/lit-element.js");
/* harmony import */ var _common_find_entites__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../common/find-entites */ "./src/panels/lovelace/common/find-entites.ts");
/* harmony import */ var _hui_entity_card__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./hui-entity-card */ "./src/panels/lovelace/cards/hui-entity-card.ts");
function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _decorate(decorators, factory, superClass, mixins) { var api = _getDecoratorsApi(); if (mixins) { for (var i = 0; i < mixins.length; i++) { api = mixins[i](api); } } var r = factory(function initialize(O) { api.initializeInstanceElements(O, decorated.elements); }, superClass); var decorated = api.decorateClass(_coalesceClassElements(r.d.map(_createElementDescriptor)), decorators); api.initializeClassElements(r.F, decorated.elements); return api.runClassFinishers(r.F, decorated.finishers); }

function _getDecoratorsApi() { _getDecoratorsApi = function () { return api; }; var api = { elementsDefinitionOrder: [["method"], ["field"]], initializeInstanceElements: function (O, elements) { ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { if (element.kind === kind && element.placement === "own") { this.defineClassElement(O, element); } }, this); }, this); }, initializeClassElements: function (F, elements) { var proto = F.prototype; ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { var placement = element.placement; if (element.kind === kind && (placement === "static" || placement === "prototype")) { var receiver = placement === "static" ? F : proto; this.defineClassElement(receiver, element); } }, this); }, this); }, defineClassElement: function (receiver, element) { var descriptor = element.descriptor; if (element.kind === "field") { var initializer = element.initializer; descriptor = { enumerable: descriptor.enumerable, writable: descriptor.writable, configurable: descriptor.configurable, value: initializer === void 0 ? void 0 : initializer.call(receiver) }; } Object.defineProperty(receiver, element.key, descriptor); }, decorateClass: function (elements, decorators) { var newElements = []; var finishers = []; var placements = { static: [], prototype: [], own: [] }; elements.forEach(function (element) { this.addElementPlacement(element, placements); }, this); elements.forEach(function (element) { if (!_hasDecorators(element)) return newElements.push(element); var elementFinishersExtras = this.decorateElement(element, placements); newElements.push(elementFinishersExtras.element); newElements.push.apply(newElements, elementFinishersExtras.extras); finishers.push.apply(finishers, elementFinishersExtras.finishers); }, this); if (!decorators) { return { elements: newElements, finishers: finishers }; } var result = this.decorateConstructor(newElements, decorators); finishers.push.apply(finishers, result.finishers); result.finishers = finishers; return result; }, addElementPlacement: function (element, placements, silent) { var keys = placements[element.placement]; if (!silent && keys.indexOf(element.key) !== -1) { throw new TypeError("Duplicated element (" + element.key + ")"); } keys.push(element.key); }, decorateElement: function (element, placements) { var extras = []; var finishers = []; for (var decorators = element.decorators, i = decorators.length - 1; i >= 0; i--) { var keys = placements[element.placement]; keys.splice(keys.indexOf(element.key), 1); var elementObject = this.fromElementDescriptor(element); var elementFinisherExtras = this.toElementFinisherExtras((0, decorators[i])(elementObject) || elementObject); element = elementFinisherExtras.element; this.addElementPlacement(element, placements); if (elementFinisherExtras.finisher) { finishers.push(elementFinisherExtras.finisher); } var newExtras = elementFinisherExtras.extras; if (newExtras) { for (var j = 0; j < newExtras.length; j++) { this.addElementPlacement(newExtras[j], placements); } extras.push.apply(extras, newExtras); } } return { element: element, finishers: finishers, extras: extras }; }, decorateConstructor: function (elements, decorators) { var finishers = []; for (var i = decorators.length - 1; i >= 0; i--) { var obj = this.fromClassDescriptor(elements); var elementsAndFinisher = this.toClassDescriptor((0, decorators[i])(obj) || obj); if (elementsAndFinisher.finisher !== undefined) { finishers.push(elementsAndFinisher.finisher); } if (elementsAndFinisher.elements !== undefined) { elements = elementsAndFinisher.elements; for (var j = 0; j < elements.length - 1; j++) { for (var k = j + 1; k < elements.length; k++) { if (elements[j].key === elements[k].key && elements[j].placement === elements[k].placement) { throw new TypeError("Duplicated element (" + elements[j].key + ")"); } } } } } return { elements: elements, finishers: finishers }; }, fromElementDescriptor: function (element) { var obj = { kind: element.kind, key: element.key, placement: element.placement, descriptor: element.descriptor }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); if (element.kind === "field") obj.initializer = element.initializer; return obj; }, toElementDescriptors: function (elementObjects) { if (elementObjects === undefined) return; return _toArray(elementObjects).map(function (elementObject) { var element = this.toElementDescriptor(elementObject); this.disallowProperty(elementObject, "finisher", "An element descriptor"); this.disallowProperty(elementObject, "extras", "An element descriptor"); return element; }, this); }, toElementDescriptor: function (elementObject) { var kind = String(elementObject.kind); if (kind !== "method" && kind !== "field") { throw new TypeError('An element descriptor\'s .kind property must be either "method" or' + ' "field", but a decorator created an element descriptor with' + ' .kind "' + kind + '"'); } var key = _toPropertyKey(elementObject.key); var placement = String(elementObject.placement); if (placement !== "static" && placement !== "prototype" && placement !== "own") { throw new TypeError('An element descriptor\'s .placement property must be one of "static",' + ' "prototype" or "own", but a decorator created an element descriptor' + ' with .placement "' + placement + '"'); } var descriptor = elementObject.descriptor; this.disallowProperty(elementObject, "elements", "An element descriptor"); var element = { kind: kind, key: key, placement: placement, descriptor: Object.assign({}, descriptor) }; if (kind !== "field") { this.disallowProperty(elementObject, "initializer", "A method descriptor"); } else { this.disallowProperty(descriptor, "get", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "set", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "value", "The property descriptor of a field descriptor"); element.initializer = elementObject.initializer; } return element; }, toElementFinisherExtras: function (elementObject) { var element = this.toElementDescriptor(elementObject); var finisher = _optionalCallableProperty(elementObject, "finisher"); var extras = this.toElementDescriptors(elementObject.extras); return { element: element, finisher: finisher, extras: extras }; }, fromClassDescriptor: function (elements) { var obj = { kind: "class", elements: elements.map(this.fromElementDescriptor, this) }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); return obj; }, toClassDescriptor: function (obj) { var kind = String(obj.kind); if (kind !== "class") { throw new TypeError('A class descriptor\'s .kind property must be "class", but a decorator' + ' created a class descriptor with .kind "' + kind + '"'); } this.disallowProperty(obj, "key", "A class descriptor"); this.disallowProperty(obj, "placement", "A class descriptor"); this.disallowProperty(obj, "descriptor", "A class descriptor"); this.disallowProperty(obj, "initializer", "A class descriptor"); this.disallowProperty(obj, "extras", "A class descriptor"); var finisher = _optionalCallableProperty(obj, "finisher"); var elements = this.toElementDescriptors(obj.elements); return { elements: elements, finisher: finisher }; }, runClassFinishers: function (constructor, finishers) { for (var i = 0; i < finishers.length; i++) { var newConstructor = (0, finishers[i])(constructor); if (newConstructor !== undefined) { if (typeof newConstructor !== "function") { throw new TypeError("Finishers must return a constructor."); } constructor = newConstructor; } } return constructor; }, disallowProperty: function (obj, name, objectType) { if (obj[name] !== undefined) { throw new TypeError(objectType + " can't have a ." + name + " property."); } } }; return api; }

function _createElementDescriptor(def) { var key = _toPropertyKey(def.key); var descriptor; if (def.kind === "method") { descriptor = { value: def.value, writable: true, configurable: true, enumerable: false }; } else if (def.kind === "get") { descriptor = { get: def.value, configurable: true, enumerable: false }; } else if (def.kind === "set") { descriptor = { set: def.value, configurable: true, enumerable: false }; } else if (def.kind === "field") { descriptor = { configurable: true, writable: true, enumerable: true }; } var element = { kind: def.kind === "field" ? "field" : "method", key: key, placement: def.static ? "static" : def.kind === "field" ? "own" : "prototype", descriptor: descriptor }; if (def.decorators) element.decorators = def.decorators; if (def.kind === "field") element.initializer = def.value; return element; }

function _coalesceGetterSetter(element, other) { if (element.descriptor.get !== undefined) { other.descriptor.get = element.descriptor.get; } else { other.descriptor.set = element.descriptor.set; } }

function _coalesceClassElements(elements) { var newElements = []; var isSameElement = function (other) { return other.kind === "method" && other.key === element.key && other.placement === element.placement; }; for (var i = 0; i < elements.length; i++) { var element = elements[i]; var other; if (element.kind === "method" && (other = newElements.find(isSameElement))) { if (_isDataDescriptor(element.descriptor) || _isDataDescriptor(other.descriptor)) { if (_hasDecorators(element) || _hasDecorators(other)) { throw new ReferenceError("Duplicated methods (" + element.key + ") can't be decorated."); } other.descriptor = element.descriptor; } else { if (_hasDecorators(element)) { if (_hasDecorators(other)) { throw new ReferenceError("Decorators can't be placed on different accessors with for " + "the same property (" + element.key + ")."); } other.decorators = element.decorators; } _coalesceGetterSetter(element, other); } } else { newElements.push(element); } } return newElements; }

function _hasDecorators(element) { return element.decorators && element.decorators.length; }

function _isDataDescriptor(desc) { return desc !== undefined && !(desc.value === undefined && desc.writable === undefined); }

function _optionalCallableProperty(obj, name) { var value = obj[name]; if (value !== undefined && typeof value !== "function") { throw new TypeError("Expected '" + name + "' to be a function"); } return value; }

function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }

function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }

function _toArray(arr) { return _arrayWithHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(n); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get; } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return _get(target, property, receiver || target); }

function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }





let HuiSensorCard = _decorate([Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["customElement"])("hui-sensor-card")], function (_initialize, _HuiEntityCard) {
  class HuiSensorCard extends _HuiEntityCard {
    constructor(...args) {
      super(...args);

      _initialize(this);
    }

  }

  return {
    F: HuiSensorCard,
    d: [{
      kind: "method",
      static: true,
      key: "getConfigElement",
      value: async function getConfigElement() {
        await Promise.all(/*! import() | hui-sensor-card-editor */[__webpack_require__.e(1), __webpack_require__.e(0), __webpack_require__.e(2), __webpack_require__.e(3), __webpack_require__.e(6), __webpack_require__.e(7), __webpack_require__.e(8), __webpack_require__.e("vendors~hui-alarm-panel-card-editor~hui-button-card-editor~hui-conditional-card-editor~hui-entities-~37aad430"), __webpack_require__.e("vendors~hui-sensor-card-editor"), __webpack_require__.e(10), __webpack_require__.e("hui-alarm-panel-card-editor~hui-button-card-editor~hui-dialog-edit-view~hui-entities-card-editor~hui~192a43f6"), __webpack_require__.e("entity-editor-dialog~helper-detail-dialog~hui-button-card-editor~hui-entity-card-editor~hui-light-ca~1d54093c"), __webpack_require__.e("hui-sensor-card-editor")]).then(__webpack_require__.bind(null, /*! ../editor/config-elements/hui-sensor-card-editor */ "./src/panels/lovelace/editor/config-elements/hui-sensor-card-editor.ts"));
        return document.createElement("hui-sensor-card-editor");
      }
    }, {
      kind: "method",
      static: true,
      key: "getStubConfig",
      value: function getStubConfig(hass, entities, entitiesFallback) {
        const includeDomains = ["sensor"];
        const maxEntities = 1;

        const entityFilter = stateObj => {
          return !isNaN(Number(stateObj.state)) && !!stateObj.attributes.unit_of_measurement;
        };

        const foundEntities = Object(_common_find_entites__WEBPACK_IMPORTED_MODULE_1__["findEntities"])(hass, maxEntities, entities, entitiesFallback, includeDomains, entityFilter);
        return {
          type: "sensor",
          entity: foundEntities[0] || "",
          graph: "line"
        };
      }
    }, {
      kind: "method",
      key: "setConfig",
      value: function setConfig(config) {
        if (!config.entity || config.entity.split(".")[0] !== "sensor") {
          throw new Error("Specify an entity from within the sensor domain.");
        }

        const {
          graph,
          detail,
          hours_to_show
        } = config,
              cardConfig = _objectWithoutPropertiesLoose(config, ["graph", "detail", "hours_to_show"]);

        const entityCardConfig = Object.assign({}, cardConfig, {
          type: "entity"
        });

        if (graph === "line") {
          const footerConfig = {
            type: "graph",
            entity: config.entity,
            detail: detail || 1,
            hours_to_show: hours_to_show || 24
          };
          entityCardConfig.footer = footerConfig;
        }

        _get(_getPrototypeOf(HuiSensorCard.prototype), "setConfig", this).call(this, entityCardConfig);
      }
    }]
  };
}, _hui_entity_card__WEBPACK_IMPORTED_MODULE_2__["HuiEntityCard"]);

/***/ }),

/***/ "./src/panels/lovelace/cards/hui-stack-card.ts":
/*!*****************************************************!*\
  !*** ./src/panels/lovelace/cards/hui-stack-card.ts ***!
  \*****************************************************/
/*! exports provided: HuiStackCard */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HuiStackCard", function() { return HuiStackCard; });
/* harmony import */ var lit_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lit-element */ "./node_modules/lit-element/lit-element.js");
/* harmony import */ var _create_element_create_card_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../create-element/create-card-element */ "./src/panels/lovelace/create-element/create-card-element.ts");
function _decorate(decorators, factory, superClass, mixins) { var api = _getDecoratorsApi(); if (mixins) { for (var i = 0; i < mixins.length; i++) { api = mixins[i](api); } } var r = factory(function initialize(O) { api.initializeInstanceElements(O, decorated.elements); }, superClass); var decorated = api.decorateClass(_coalesceClassElements(r.d.map(_createElementDescriptor)), decorators); api.initializeClassElements(r.F, decorated.elements); return api.runClassFinishers(r.F, decorated.finishers); }

function _getDecoratorsApi() { _getDecoratorsApi = function () { return api; }; var api = { elementsDefinitionOrder: [["method"], ["field"]], initializeInstanceElements: function (O, elements) { ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { if (element.kind === kind && element.placement === "own") { this.defineClassElement(O, element); } }, this); }, this); }, initializeClassElements: function (F, elements) { var proto = F.prototype; ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { var placement = element.placement; if (element.kind === kind && (placement === "static" || placement === "prototype")) { var receiver = placement === "static" ? F : proto; this.defineClassElement(receiver, element); } }, this); }, this); }, defineClassElement: function (receiver, element) { var descriptor = element.descriptor; if (element.kind === "field") { var initializer = element.initializer; descriptor = { enumerable: descriptor.enumerable, writable: descriptor.writable, configurable: descriptor.configurable, value: initializer === void 0 ? void 0 : initializer.call(receiver) }; } Object.defineProperty(receiver, element.key, descriptor); }, decorateClass: function (elements, decorators) { var newElements = []; var finishers = []; var placements = { static: [], prototype: [], own: [] }; elements.forEach(function (element) { this.addElementPlacement(element, placements); }, this); elements.forEach(function (element) { if (!_hasDecorators(element)) return newElements.push(element); var elementFinishersExtras = this.decorateElement(element, placements); newElements.push(elementFinishersExtras.element); newElements.push.apply(newElements, elementFinishersExtras.extras); finishers.push.apply(finishers, elementFinishersExtras.finishers); }, this); if (!decorators) { return { elements: newElements, finishers: finishers }; } var result = this.decorateConstructor(newElements, decorators); finishers.push.apply(finishers, result.finishers); result.finishers = finishers; return result; }, addElementPlacement: function (element, placements, silent) { var keys = placements[element.placement]; if (!silent && keys.indexOf(element.key) !== -1) { throw new TypeError("Duplicated element (" + element.key + ")"); } keys.push(element.key); }, decorateElement: function (element, placements) { var extras = []; var finishers = []; for (var decorators = element.decorators, i = decorators.length - 1; i >= 0; i--) { var keys = placements[element.placement]; keys.splice(keys.indexOf(element.key), 1); var elementObject = this.fromElementDescriptor(element); var elementFinisherExtras = this.toElementFinisherExtras((0, decorators[i])(elementObject) || elementObject); element = elementFinisherExtras.element; this.addElementPlacement(element, placements); if (elementFinisherExtras.finisher) { finishers.push(elementFinisherExtras.finisher); } var newExtras = elementFinisherExtras.extras; if (newExtras) { for (var j = 0; j < newExtras.length; j++) { this.addElementPlacement(newExtras[j], placements); } extras.push.apply(extras, newExtras); } } return { element: element, finishers: finishers, extras: extras }; }, decorateConstructor: function (elements, decorators) { var finishers = []; for (var i = decorators.length - 1; i >= 0; i--) { var obj = this.fromClassDescriptor(elements); var elementsAndFinisher = this.toClassDescriptor((0, decorators[i])(obj) || obj); if (elementsAndFinisher.finisher !== undefined) { finishers.push(elementsAndFinisher.finisher); } if (elementsAndFinisher.elements !== undefined) { elements = elementsAndFinisher.elements; for (var j = 0; j < elements.length - 1; j++) { for (var k = j + 1; k < elements.length; k++) { if (elements[j].key === elements[k].key && elements[j].placement === elements[k].placement) { throw new TypeError("Duplicated element (" + elements[j].key + ")"); } } } } } return { elements: elements, finishers: finishers }; }, fromElementDescriptor: function (element) { var obj = { kind: element.kind, key: element.key, placement: element.placement, descriptor: element.descriptor }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); if (element.kind === "field") obj.initializer = element.initializer; return obj; }, toElementDescriptors: function (elementObjects) { if (elementObjects === undefined) return; return _toArray(elementObjects).map(function (elementObject) { var element = this.toElementDescriptor(elementObject); this.disallowProperty(elementObject, "finisher", "An element descriptor"); this.disallowProperty(elementObject, "extras", "An element descriptor"); return element; }, this); }, toElementDescriptor: function (elementObject) { var kind = String(elementObject.kind); if (kind !== "method" && kind !== "field") { throw new TypeError('An element descriptor\'s .kind property must be either "method" or' + ' "field", but a decorator created an element descriptor with' + ' .kind "' + kind + '"'); } var key = _toPropertyKey(elementObject.key); var placement = String(elementObject.placement); if (placement !== "static" && placement !== "prototype" && placement !== "own") { throw new TypeError('An element descriptor\'s .placement property must be one of "static",' + ' "prototype" or "own", but a decorator created an element descriptor' + ' with .placement "' + placement + '"'); } var descriptor = elementObject.descriptor; this.disallowProperty(elementObject, "elements", "An element descriptor"); var element = { kind: kind, key: key, placement: placement, descriptor: Object.assign({}, descriptor) }; if (kind !== "field") { this.disallowProperty(elementObject, "initializer", "A method descriptor"); } else { this.disallowProperty(descriptor, "get", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "set", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "value", "The property descriptor of a field descriptor"); element.initializer = elementObject.initializer; } return element; }, toElementFinisherExtras: function (elementObject) { var element = this.toElementDescriptor(elementObject); var finisher = _optionalCallableProperty(elementObject, "finisher"); var extras = this.toElementDescriptors(elementObject.extras); return { element: element, finisher: finisher, extras: extras }; }, fromClassDescriptor: function (elements) { var obj = { kind: "class", elements: elements.map(this.fromElementDescriptor, this) }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); return obj; }, toClassDescriptor: function (obj) { var kind = String(obj.kind); if (kind !== "class") { throw new TypeError('A class descriptor\'s .kind property must be "class", but a decorator' + ' created a class descriptor with .kind "' + kind + '"'); } this.disallowProperty(obj, "key", "A class descriptor"); this.disallowProperty(obj, "placement", "A class descriptor"); this.disallowProperty(obj, "descriptor", "A class descriptor"); this.disallowProperty(obj, "initializer", "A class descriptor"); this.disallowProperty(obj, "extras", "A class descriptor"); var finisher = _optionalCallableProperty(obj, "finisher"); var elements = this.toElementDescriptors(obj.elements); return { elements: elements, finisher: finisher }; }, runClassFinishers: function (constructor, finishers) { for (var i = 0; i < finishers.length; i++) { var newConstructor = (0, finishers[i])(constructor); if (newConstructor !== undefined) { if (typeof newConstructor !== "function") { throw new TypeError("Finishers must return a constructor."); } constructor = newConstructor; } } return constructor; }, disallowProperty: function (obj, name, objectType) { if (obj[name] !== undefined) { throw new TypeError(objectType + " can't have a ." + name + " property."); } } }; return api; }

function _createElementDescriptor(def) { var key = _toPropertyKey(def.key); var descriptor; if (def.kind === "method") { descriptor = { value: def.value, writable: true, configurable: true, enumerable: false }; } else if (def.kind === "get") { descriptor = { get: def.value, configurable: true, enumerable: false }; } else if (def.kind === "set") { descriptor = { set: def.value, configurable: true, enumerable: false }; } else if (def.kind === "field") { descriptor = { configurable: true, writable: true, enumerable: true }; } var element = { kind: def.kind === "field" ? "field" : "method", key: key, placement: def.static ? "static" : def.kind === "field" ? "own" : "prototype", descriptor: descriptor }; if (def.decorators) element.decorators = def.decorators; if (def.kind === "field") element.initializer = def.value; return element; }

function _coalesceGetterSetter(element, other) { if (element.descriptor.get !== undefined) { other.descriptor.get = element.descriptor.get; } else { other.descriptor.set = element.descriptor.set; } }

function _coalesceClassElements(elements) { var newElements = []; var isSameElement = function (other) { return other.kind === "method" && other.key === element.key && other.placement === element.placement; }; for (var i = 0; i < elements.length; i++) { var element = elements[i]; var other; if (element.kind === "method" && (other = newElements.find(isSameElement))) { if (_isDataDescriptor(element.descriptor) || _isDataDescriptor(other.descriptor)) { if (_hasDecorators(element) || _hasDecorators(other)) { throw new ReferenceError("Duplicated methods (" + element.key + ") can't be decorated."); } other.descriptor = element.descriptor; } else { if (_hasDecorators(element)) { if (_hasDecorators(other)) { throw new ReferenceError("Decorators can't be placed on different accessors with for " + "the same property (" + element.key + ")."); } other.decorators = element.decorators; } _coalesceGetterSetter(element, other); } } else { newElements.push(element); } } return newElements; }

function _hasDecorators(element) { return element.decorators && element.decorators.length; }

function _isDataDescriptor(desc) { return desc !== undefined && !(desc.value === undefined && desc.writable === undefined); }

function _optionalCallableProperty(obj, name) { var value = obj[name]; if (value !== undefined && typeof value !== "function") { throw new TypeError("Expected '" + name + "' to be a function"); } return value; }

function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }

function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }

function _toArray(arr) { return _arrayWithHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(n); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get; } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return _get(target, property, receiver || target); }

function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }



let HuiStackCard = _decorate(null, function (_initialize, _LitElement) {
  class HuiStackCard extends _LitElement {
    constructor(...args) {
      super(...args);

      _initialize(this);
    }

  }

  return {
    F: HuiStackCard,
    d: [{
      kind: "method",
      static: true,
      key: "getConfigElement",
      value: async function getConfigElement() {
        await Promise.all(/*! import() | hui-stack-card-editor */[__webpack_require__.e(0), __webpack_require__.e(2), __webpack_require__.e("vendors~hui-alarm-panel-card-editor~hui-button-card-editor~hui-conditional-card-editor~hui-entities-~37aad430"), __webpack_require__.e("vendors~entity-editor-dialog~hui-conditional-card-editor~hui-stack-card-editor~panel-developer-tools~838abec3"), __webpack_require__.e("vendors~dialog-config-flow~hui-conditional-card-editor~hui-dialog-edit-card~hui-stack-card-editor~pa~f9cbd3da"), __webpack_require__.e("dialog-config-flow~hui-conditional-card-editor~hui-dialog-edit-card~hui-stack-card-editor~hui-unused~c9cf7b12"), __webpack_require__.e("hui-conditional-card-editor~hui-dialog-edit-card~hui-stack-card-editor"), __webpack_require__.e("hui-stack-card-editor")]).then(__webpack_require__.bind(null, /*! ../editor/config-elements/hui-stack-card-editor */ "./src/panels/lovelace/editor/config-elements/hui-stack-card-editor.ts"));
        return document.createElement("hui-stack-card-editor");
      }
    }, {
      kind: "method",
      static: true,
      key: "getStubConfig",
      value: function getStubConfig() {
        return {
          cards: []
        };
      }
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "hass",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "editMode",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "_cards",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "_config",
      value: void 0
    }, {
      kind: "method",
      key: "getCardSize",
      value: function getCardSize() {
        return 1;
      }
    }, {
      kind: "method",
      key: "setConfig",
      value: function setConfig(config) {
        if (!config || !config.cards || !Array.isArray(config.cards)) {
          throw new Error("Card config incorrect");
        }

        this._config = config;
        this._cards = config.cards.map(card => {
          const element = this._createCardElement(card);

          return element;
        });
      }
    }, {
      kind: "method",
      key: "updated",
      value: function updated(changedProps) {
        _get(_getPrototypeOf(HuiStackCard.prototype), "updated", this).call(this, changedProps);

        if (!this._cards || !changedProps.has("hass") && !changedProps.has("editMode")) {
          return;
        }

        for (const element of this._cards) {
          element.hass = this.hass;
          element.editMode = this.editMode;
        }
      }
    }, {
      kind: "method",
      key: "render",
      value: function render() {
        if (!this._config || !this._cards) {
          return lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]``;
        }

        return lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
      ${this._config.title ? lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]` <div class="card-header">${this._config.title}</div> ` : ""}
      <div id="root">${this._cards}</div>
    `;
      }
    }, {
      kind: "get",
      static: true,
      key: "sharedStyles",
      value: function sharedStyles() {
        return lit_element__WEBPACK_IMPORTED_MODULE_0__["css"]`
      .card-header {
        color: var(--ha-card-header-color, --primary-text-color);
        font-family: var(--ha-card-header-font-family, inherit);
        font-size: var(--ha-card-header-font-size, 24px);
        letter-spacing: -0.012em;
        line-height: 32px;
        display: block;
        padding: 24px 16px 16px;
      }
    `;
      }
    }, {
      kind: "method",
      key: "_createCardElement",
      value: function _createCardElement(cardConfig) {
        const element = Object(_create_element_create_card_element__WEBPACK_IMPORTED_MODULE_1__["createCardElement"])(cardConfig);

        if (this.hass) {
          element.hass = this.hass;
        }

        element.addEventListener("ll-rebuild", ev => {
          ev.stopPropagation();

          this._rebuildCard(element, cardConfig);
        }, {
          once: true
        });
        return element;
      }
    }, {
      kind: "method",
      key: "_rebuildCard",
      value: function _rebuildCard(cardElToReplace, config) {
        const newCardEl = this._createCardElement(config);

        cardElToReplace.parentElement.replaceChild(newCardEl, cardElToReplace);
        this._cards = this._cards.map(curCardEl => curCardEl === cardElToReplace ? newCardEl : curCardEl);
      }
    }]
  };
}, lit_element__WEBPACK_IMPORTED_MODULE_0__["LitElement"]);

/***/ }),

/***/ "./src/panels/lovelace/cards/hui-thermostat-card.ts":
/*!**********************************************************!*\
  !*** ./src/panels/lovelace/cards/hui-thermostat-card.ts ***!
  \**********************************************************/
/*! exports provided: HuiThermostatCard */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HuiThermostatCard", function() { return HuiThermostatCard; });
/* harmony import */ var _polymer_paper_icon_button_paper_icon_button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @polymer/paper-icon-button/paper-icon-button */ "./node_modules/@polymer/paper-icon-button/paper-icon-button.js");
/* harmony import */ var _thomasloven_round_slider__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @thomasloven/round-slider */ "./node_modules/@thomasloven/round-slider/src/main.js");
/* harmony import */ var lit_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lit-element */ "./node_modules/lit-element/lit-element.js");
/* harmony import */ var lit_html_directives_class_map__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lit-html/directives/class-map */ "./node_modules/lit-html/directives/class-map.js");
/* harmony import */ var _common_const__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../common/const */ "./src/common/const.ts");
/* harmony import */ var _common_dom_apply_themes_on_element__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../common/dom/apply_themes_on_element */ "./src/common/dom/apply_themes_on_element.ts");
/* harmony import */ var _common_dom_fire_event__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../common/dom/fire_event */ "./src/common/dom/fire_event.ts");
/* harmony import */ var _common_entity_compute_state_name__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../common/entity/compute_state_name */ "./src/common/entity/compute_state_name.ts");
/* harmony import */ var _components_ha_card__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../components/ha-card */ "./src/components/ha-card.ts");
/* harmony import */ var _data_climate__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../../data/climate */ "./src/data/climate.ts");
/* harmony import */ var _data_entity__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../../data/entity */ "./src/data/entity.ts");
/* harmony import */ var _common_directives_action_handler_directive__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../common/directives/action-handler-directive */ "./src/panels/lovelace/common/directives/action-handler-directive.ts");
/* harmony import */ var _common_find_entites__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../common/find-entites */ "./src/panels/lovelace/common/find-entites.ts");
/* harmony import */ var _common_has_changed__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../common/has-changed */ "./src/panels/lovelace/common/has-changed.ts");
/* harmony import */ var _components_hui_warning__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../components/hui-warning */ "./src/panels/lovelace/components/hui-warning.ts");
function _decorate(decorators, factory, superClass, mixins) { var api = _getDecoratorsApi(); if (mixins) { for (var i = 0; i < mixins.length; i++) { api = mixins[i](api); } } var r = factory(function initialize(O) { api.initializeInstanceElements(O, decorated.elements); }, superClass); var decorated = api.decorateClass(_coalesceClassElements(r.d.map(_createElementDescriptor)), decorators); api.initializeClassElements(r.F, decorated.elements); return api.runClassFinishers(r.F, decorated.finishers); }

function _getDecoratorsApi() { _getDecoratorsApi = function () { return api; }; var api = { elementsDefinitionOrder: [["method"], ["field"]], initializeInstanceElements: function (O, elements) { ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { if (element.kind === kind && element.placement === "own") { this.defineClassElement(O, element); } }, this); }, this); }, initializeClassElements: function (F, elements) { var proto = F.prototype; ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { var placement = element.placement; if (element.kind === kind && (placement === "static" || placement === "prototype")) { var receiver = placement === "static" ? F : proto; this.defineClassElement(receiver, element); } }, this); }, this); }, defineClassElement: function (receiver, element) { var descriptor = element.descriptor; if (element.kind === "field") { var initializer = element.initializer; descriptor = { enumerable: descriptor.enumerable, writable: descriptor.writable, configurable: descriptor.configurable, value: initializer === void 0 ? void 0 : initializer.call(receiver) }; } Object.defineProperty(receiver, element.key, descriptor); }, decorateClass: function (elements, decorators) { var newElements = []; var finishers = []; var placements = { static: [], prototype: [], own: [] }; elements.forEach(function (element) { this.addElementPlacement(element, placements); }, this); elements.forEach(function (element) { if (!_hasDecorators(element)) return newElements.push(element); var elementFinishersExtras = this.decorateElement(element, placements); newElements.push(elementFinishersExtras.element); newElements.push.apply(newElements, elementFinishersExtras.extras); finishers.push.apply(finishers, elementFinishersExtras.finishers); }, this); if (!decorators) { return { elements: newElements, finishers: finishers }; } var result = this.decorateConstructor(newElements, decorators); finishers.push.apply(finishers, result.finishers); result.finishers = finishers; return result; }, addElementPlacement: function (element, placements, silent) { var keys = placements[element.placement]; if (!silent && keys.indexOf(element.key) !== -1) { throw new TypeError("Duplicated element (" + element.key + ")"); } keys.push(element.key); }, decorateElement: function (element, placements) { var extras = []; var finishers = []; for (var decorators = element.decorators, i = decorators.length - 1; i >= 0; i--) { var keys = placements[element.placement]; keys.splice(keys.indexOf(element.key), 1); var elementObject = this.fromElementDescriptor(element); var elementFinisherExtras = this.toElementFinisherExtras((0, decorators[i])(elementObject) || elementObject); element = elementFinisherExtras.element; this.addElementPlacement(element, placements); if (elementFinisherExtras.finisher) { finishers.push(elementFinisherExtras.finisher); } var newExtras = elementFinisherExtras.extras; if (newExtras) { for (var j = 0; j < newExtras.length; j++) { this.addElementPlacement(newExtras[j], placements); } extras.push.apply(extras, newExtras); } } return { element: element, finishers: finishers, extras: extras }; }, decorateConstructor: function (elements, decorators) { var finishers = []; for (var i = decorators.length - 1; i >= 0; i--) { var obj = this.fromClassDescriptor(elements); var elementsAndFinisher = this.toClassDescriptor((0, decorators[i])(obj) || obj); if (elementsAndFinisher.finisher !== undefined) { finishers.push(elementsAndFinisher.finisher); } if (elementsAndFinisher.elements !== undefined) { elements = elementsAndFinisher.elements; for (var j = 0; j < elements.length - 1; j++) { for (var k = j + 1; k < elements.length; k++) { if (elements[j].key === elements[k].key && elements[j].placement === elements[k].placement) { throw new TypeError("Duplicated element (" + elements[j].key + ")"); } } } } } return { elements: elements, finishers: finishers }; }, fromElementDescriptor: function (element) { var obj = { kind: element.kind, key: element.key, placement: element.placement, descriptor: element.descriptor }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); if (element.kind === "field") obj.initializer = element.initializer; return obj; }, toElementDescriptors: function (elementObjects) { if (elementObjects === undefined) return; return _toArray(elementObjects).map(function (elementObject) { var element = this.toElementDescriptor(elementObject); this.disallowProperty(elementObject, "finisher", "An element descriptor"); this.disallowProperty(elementObject, "extras", "An element descriptor"); return element; }, this); }, toElementDescriptor: function (elementObject) { var kind = String(elementObject.kind); if (kind !== "method" && kind !== "field") { throw new TypeError('An element descriptor\'s .kind property must be either "method" or' + ' "field", but a decorator created an element descriptor with' + ' .kind "' + kind + '"'); } var key = _toPropertyKey(elementObject.key); var placement = String(elementObject.placement); if (placement !== "static" && placement !== "prototype" && placement !== "own") { throw new TypeError('An element descriptor\'s .placement property must be one of "static",' + ' "prototype" or "own", but a decorator created an element descriptor' + ' with .placement "' + placement + '"'); } var descriptor = elementObject.descriptor; this.disallowProperty(elementObject, "elements", "An element descriptor"); var element = { kind: kind, key: key, placement: placement, descriptor: Object.assign({}, descriptor) }; if (kind !== "field") { this.disallowProperty(elementObject, "initializer", "A method descriptor"); } else { this.disallowProperty(descriptor, "get", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "set", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "value", "The property descriptor of a field descriptor"); element.initializer = elementObject.initializer; } return element; }, toElementFinisherExtras: function (elementObject) { var element = this.toElementDescriptor(elementObject); var finisher = _optionalCallableProperty(elementObject, "finisher"); var extras = this.toElementDescriptors(elementObject.extras); return { element: element, finisher: finisher, extras: extras }; }, fromClassDescriptor: function (elements) { var obj = { kind: "class", elements: elements.map(this.fromElementDescriptor, this) }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); return obj; }, toClassDescriptor: function (obj) { var kind = String(obj.kind); if (kind !== "class") { throw new TypeError('A class descriptor\'s .kind property must be "class", but a decorator' + ' created a class descriptor with .kind "' + kind + '"'); } this.disallowProperty(obj, "key", "A class descriptor"); this.disallowProperty(obj, "placement", "A class descriptor"); this.disallowProperty(obj, "descriptor", "A class descriptor"); this.disallowProperty(obj, "initializer", "A class descriptor"); this.disallowProperty(obj, "extras", "A class descriptor"); var finisher = _optionalCallableProperty(obj, "finisher"); var elements = this.toElementDescriptors(obj.elements); return { elements: elements, finisher: finisher }; }, runClassFinishers: function (constructor, finishers) { for (var i = 0; i < finishers.length; i++) { var newConstructor = (0, finishers[i])(constructor); if (newConstructor !== undefined) { if (typeof newConstructor !== "function") { throw new TypeError("Finishers must return a constructor."); } constructor = newConstructor; } } return constructor; }, disallowProperty: function (obj, name, objectType) { if (obj[name] !== undefined) { throw new TypeError(objectType + " can't have a ." + name + " property."); } } }; return api; }

function _createElementDescriptor(def) { var key = _toPropertyKey(def.key); var descriptor; if (def.kind === "method") { descriptor = { value: def.value, writable: true, configurable: true, enumerable: false }; } else if (def.kind === "get") { descriptor = { get: def.value, configurable: true, enumerable: false }; } else if (def.kind === "set") { descriptor = { set: def.value, configurable: true, enumerable: false }; } else if (def.kind === "field") { descriptor = { configurable: true, writable: true, enumerable: true }; } var element = { kind: def.kind === "field" ? "field" : "method", key: key, placement: def.static ? "static" : def.kind === "field" ? "own" : "prototype", descriptor: descriptor }; if (def.decorators) element.decorators = def.decorators; if (def.kind === "field") element.initializer = def.value; return element; }

function _coalesceGetterSetter(element, other) { if (element.descriptor.get !== undefined) { other.descriptor.get = element.descriptor.get; } else { other.descriptor.set = element.descriptor.set; } }

function _coalesceClassElements(elements) { var newElements = []; var isSameElement = function (other) { return other.kind === "method" && other.key === element.key && other.placement === element.placement; }; for (var i = 0; i < elements.length; i++) { var element = elements[i]; var other; if (element.kind === "method" && (other = newElements.find(isSameElement))) { if (_isDataDescriptor(element.descriptor) || _isDataDescriptor(other.descriptor)) { if (_hasDecorators(element) || _hasDecorators(other)) { throw new ReferenceError("Duplicated methods (" + element.key + ") can't be decorated."); } other.descriptor = element.descriptor; } else { if (_hasDecorators(element)) { if (_hasDecorators(other)) { throw new ReferenceError("Decorators can't be placed on different accessors with for " + "the same property (" + element.key + ")."); } other.decorators = element.decorators; } _coalesceGetterSetter(element, other); } } else { newElements.push(element); } } return newElements; }

function _hasDecorators(element) { return element.decorators && element.decorators.length; }

function _isDataDescriptor(desc) { return desc !== undefined && !(desc.value === undefined && desc.writable === undefined); }

function _optionalCallableProperty(obj, name) { var value = obj[name]; if (value !== undefined && typeof value !== "function") { throw new TypeError("Expected '" + name + "' to be a function"); } return value; }

function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }

function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }

function _toArray(arr) { return _arrayWithHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(n); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get; } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return _get(target, property, receiver || target); }

function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }
















const modeIcons = {
  auto: "hass:calendar-repeat",
  heat_cool: "hass:autorenew",
  heat: "hass:fire",
  cool: "hass:snowflake",
  off: "hass:power",
  fan_only: "hass:fan",
  dry: "hass:water-percent"
};
let HuiThermostatCard = _decorate([Object(lit_element__WEBPACK_IMPORTED_MODULE_2__["customElement"])("hui-thermostat-card")], function (_initialize, _LitElement) {
  class HuiThermostatCard extends _LitElement {
    constructor(...args) {
      super(...args);

      _initialize(this);
    }

  }

  return {
    F: HuiThermostatCard,
    d: [{
      kind: "method",
      static: true,
      key: "getConfigElement",
      value: async function getConfigElement() {
        await Promise.all(/*! import() | hui-thermostat-card-editor */[__webpack_require__.e(1), __webpack_require__.e(0), __webpack_require__.e(2), __webpack_require__.e(3), __webpack_require__.e(6), __webpack_require__.e(7), __webpack_require__.e(8), __webpack_require__.e("vendors~hui-alarm-panel-card-editor~hui-button-card-editor~hui-conditional-card-editor~hui-entities-~37aad430"), __webpack_require__.e("vendors~hui-thermostat-card-editor"), __webpack_require__.e(10), __webpack_require__.e("hui-alarm-panel-card-editor~hui-button-card-editor~hui-dialog-edit-view~hui-entities-card-editor~hui~192a43f6"), __webpack_require__.e("hui-thermostat-card-editor")]).then(__webpack_require__.bind(null, /*! ../editor/config-elements/hui-thermostat-card-editor */ "./src/panels/lovelace/editor/config-elements/hui-thermostat-card-editor.ts"));
        return document.createElement("hui-thermostat-card-editor");
      }
    }, {
      kind: "method",
      static: true,
      key: "getStubConfig",
      value: function getStubConfig(hass, entities, entitiesFallback) {
        const includeDomains = ["climate"];
        const maxEntities = 1;
        const foundEntities = Object(_common_find_entites__WEBPACK_IMPORTED_MODULE_12__["findEntities"])(hass, maxEntities, entities, entitiesFallback, includeDomains);
        return {
          type: "thermostat",
          entity: foundEntities[0] || ""
        };
      }
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_2__["property"])()],
      key: "hass",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_2__["property"])()],
      key: "_config",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_2__["property"])()],
      key: "_setTemp",
      value: void 0
    }, {
      kind: "method",
      key: "getCardSize",
      value: function getCardSize() {
        return 4;
      }
    }, {
      kind: "method",
      key: "setConfig",
      value: function setConfig(config) {
        if (!config.entity || config.entity.split(".")[0] !== "climate") {
          throw new Error("Specify an entity from within the climate domain.");
        }

        this._config = config;
      }
    }, {
      kind: "method",
      key: "connectedCallback",
      value: function connectedCallback() {
        _get(_getPrototypeOf(HuiThermostatCard.prototype), "connectedCallback", this).call(this);

        this.rescale_svg();
      }
    }, {
      kind: "method",
      key: "firstUpdated",
      value: function firstUpdated() {
        this.rescale_svg();
      }
    }, {
      kind: "method",
      key: "render",
      value: function render() {
        if (!this.hass || !this._config) {
          return lit_element__WEBPACK_IMPORTED_MODULE_2__["html"]``;
        }

        const stateObj = this.hass.states[this._config.entity];

        if (!stateObj) {
          return lit_element__WEBPACK_IMPORTED_MODULE_2__["html"]`
        <hui-warning
          >${this.hass.localize("ui.panel.lovelace.warning.entity_not_found", "entity", this._config.entity)}</hui-warning
        >
      `;
        }

        const mode = stateObj.state in modeIcons ? stateObj.state : "unknown-mode";
        const name = this._config.name || Object(_common_entity_compute_state_name__WEBPACK_IMPORTED_MODULE_7__["computeStateName"])(this.hass.states[this._config.entity]);
        const targetTemp = stateObj.attributes.temperature !== null && Number.isFinite(Number(stateObj.attributes.temperature)) ? stateObj.attributes.temperature : stateObj.attributes.min_temp;
        const slider = stateObj.state === _data_entity__WEBPACK_IMPORTED_MODULE_10__["UNAVAILABLE"] ? lit_element__WEBPACK_IMPORTED_MODULE_2__["html"]` <round-slider disabled="true"></round-slider> ` : lit_element__WEBPACK_IMPORTED_MODULE_2__["html"]`
            <round-slider
              .value=${targetTemp}
              .low=${stateObj.attributes.target_temp_low}
              .high=${stateObj.attributes.target_temp_high}
              .min=${stateObj.attributes.min_temp}
              .max=${stateObj.attributes.max_temp}
              .step=${this._stepSize}
              @value-changing=${this._dragEvent}
              @value-changed=${this._setTemperature}
            ></round-slider>
          `;
        const currentTemperature = !isNaN(stateObj.attributes.current_temperature) ? lit_element__WEBPACK_IMPORTED_MODULE_2__["svg"]`
          <svg viewBox="0 0 40 20">
            <text
              x="50%"
              dx="1"
              y="60%"
              text-anchor="middle"
              style="font-size: 13px;"
            >
              ${stateObj.attributes.current_temperature}
              <tspan dx="-3" dy="-6.5" style="font-size: 4px;">
                ${this.hass.config.unit_system.temperature}
              </tspan>
            </text>
          </svg>
        ` : "";
        const setValues = lit_element__WEBPACK_IMPORTED_MODULE_2__["svg"]`
      <svg id="set-values">
        <g>
          <text text-anchor="middle" class="set-value">
            ${this._setTemp === undefined || this._setTemp === null ? "" : Array.isArray(this._setTemp) ? this._stepSize === 1 ? lit_element__WEBPACK_IMPORTED_MODULE_2__["svg"]`
                      ${this._setTemp[0].toFixed()} -
                      ${this._setTemp[1].toFixed()}
                      ` : lit_element__WEBPACK_IMPORTED_MODULE_2__["svg"]`
                      ${this._setTemp[0].toFixed(1)} -
                      ${this._setTemp[1].toFixed(1)}
                      ` : this._stepSize === 1 ? lit_element__WEBPACK_IMPORTED_MODULE_2__["svg"]`
                      ${this._setTemp.toFixed()}
                      ` : lit_element__WEBPACK_IMPORTED_MODULE_2__["svg"]`
                      ${this._setTemp.toFixed(1)}
                      `}
          </text>
          <text
            dy="22"
            text-anchor="middle"
            id="set-mode"
          >
            ${stateObj.attributes.hvac_action ? this.hass.localize(`state_attributes.climate.hvac_action.${stateObj.attributes.hvac_action}`) : this.hass.localize(`component.climate.state._.${stateObj.state}`)}
            ${stateObj.attributes.preset_mode && stateObj.attributes.preset_mode !== _data_climate__WEBPACK_IMPORTED_MODULE_9__["CLIMATE_PRESET_NONE"] ? lit_element__WEBPACK_IMPORTED_MODULE_2__["html"]`
                    -
                    ${this.hass.localize(`state_attributes.climate.preset_mode.${stateObj.attributes.preset_mode}`) || stateObj.attributes.preset_mode}
                  ` : ""}
          </text>
        </g>
      </svg>
    `;
        return lit_element__WEBPACK_IMPORTED_MODULE_2__["html"]`
      <ha-card
        class=${Object(lit_html_directives_class_map__WEBPACK_IMPORTED_MODULE_3__["classMap"])({
          [mode]: true
        })}
      >
        <paper-icon-button
          icon="hass:dots-vertical"
          class="more-info"
          @click=${this._handleMoreInfo}
          tabindex="0"
        ></paper-icon-button>

        <div class="content">
          <div id="controls">
            <div id="slider">
              ${slider}
              <div id="slider-center">
                <div id="temperature">
                  ${currentTemperature} ${setValues}
                </div>
              </div>
            </div>
          </div>
          <div id="info">
            <div id="modes">
              ${(stateObj.attributes.hvac_modes || []).concat().sort(_data_climate__WEBPACK_IMPORTED_MODULE_9__["compareClimateHvacModes"]).map(modeItem => this._renderIcon(modeItem, mode))}
            </div>
            ${name}
          </div>
        </div>
      </ha-card>
    `;
      }
    }, {
      kind: "method",
      key: "shouldUpdate",
      value: function shouldUpdate(changedProps) {
        return Object(_common_has_changed__WEBPACK_IMPORTED_MODULE_13__["hasConfigOrEntityChanged"])(this, changedProps);
      }
    }, {
      kind: "method",
      key: "updated",
      value: function updated(changedProps) {
        _get(_getPrototypeOf(HuiThermostatCard.prototype), "updated", this).call(this, changedProps);

        if (!this._config || !this.hass || !changedProps.has("hass") && !changedProps.has("_config")) {
          return;
        }

        const oldHass = changedProps.get("hass");
        const oldConfig = changedProps.get("_config");

        if (!oldHass || !oldConfig || oldHass.themes !== this.hass.themes || oldConfig.theme !== this._config.theme) {
          Object(_common_dom_apply_themes_on_element__WEBPACK_IMPORTED_MODULE_5__["applyThemesOnElement"])(this, this.hass.themes, this._config.theme);
        }

        const stateObj = this.hass.states[this._config.entity];

        if (!stateObj) {
          return;
        }

        this._setTemp = this._getSetTemp(stateObj);
        this.rescale_svg();
      }
    }, {
      kind: "method",
      key: "rescale_svg",
      value: function rescale_svg() {
        // Set the viewbox of the SVG containing the set temperature to perfectly
        // fit the text
        // That way it will auto-scale correctly
        // This is not done to the SVG containing the current temperature, because
        // it should not be centered on the text, but only on the value
        if (this.shadowRoot && this.shadowRoot.querySelector("ha-card")) {
          this.shadowRoot.querySelector("ha-card").updateComplete.then(() => {
            const svgRoot = this.shadowRoot.querySelector("#set-values");
            const box = svgRoot.querySelector("g").getBBox();
            svgRoot.setAttribute("viewBox", `${box.x} ${box.y} ${box.width} ${box.height}`);
            svgRoot.setAttribute("width", `${box.width}`);
            svgRoot.setAttribute("height", `${box.height}`);
          });
        }
      }
    }, {
      kind: "get",
      key: "_stepSize",
      value: function _stepSize() {
        const stateObj = this.hass.states[this._config.entity];

        if (stateObj.attributes.target_temp_step) {
          return stateObj.attributes.target_temp_step;
        }

        return this.hass.config.unit_system.temperature === _common_const__WEBPACK_IMPORTED_MODULE_4__["UNIT_F"] ? 1 : 0.5;
      }
    }, {
      kind: "method",
      key: "_getSetTemp",
      value: function _getSetTemp(stateObj) {
        if (stateObj.state === _data_entity__WEBPACK_IMPORTED_MODULE_10__["UNAVAILABLE"]) {
          return this.hass.localize("state.default.unavailable");
        }

        if (stateObj.attributes.target_temp_low && stateObj.attributes.target_temp_high) {
          return [stateObj.attributes.target_temp_low, stateObj.attributes.target_temp_high];
        }

        return stateObj.attributes.temperature;
      }
    }, {
      kind: "method",
      key: "_dragEvent",
      value: function _dragEvent(e) {
        const stateObj = this.hass.states[this._config.entity];

        if (e.detail.low) {
          this._setTemp = [e.detail.low, stateObj.attributes.target_temp_high];
        } else if (e.detail.high) {
          this._setTemp = [stateObj.attributes.target_temp_low, e.detail.high];
        } else {
          this._setTemp = e.detail.value;
        }
      }
    }, {
      kind: "method",
      key: "_setTemperature",
      value: function _setTemperature(e) {
        const stateObj = this.hass.states[this._config.entity];

        if (e.detail.low) {
          this.hass.callService("climate", "set_temperature", {
            entity_id: this._config.entity,
            target_temp_low: e.detail.low,
            target_temp_high: stateObj.attributes.target_temp_high
          });
        } else if (e.detail.high) {
          this.hass.callService("climate", "set_temperature", {
            entity_id: this._config.entity,
            target_temp_low: stateObj.attributes.target_temp_low,
            target_temp_high: e.detail.high
          });
        } else {
          this.hass.callService("climate", "set_temperature", {
            entity_id: this._config.entity,
            temperature: e.detail.value
          });
        }
      }
    }, {
      kind: "method",
      key: "_renderIcon",
      value: function _renderIcon(mode, currentMode) {
        if (!modeIcons[mode]) {
          return lit_element__WEBPACK_IMPORTED_MODULE_2__["html"]``;
        }

        return lit_element__WEBPACK_IMPORTED_MODULE_2__["html"]`
      <paper-icon-button
        class="${Object(lit_html_directives_class_map__WEBPACK_IMPORTED_MODULE_3__["classMap"])({
          "selected-icon": currentMode === mode
        })}"
        .mode="${mode}"
        .icon="${modeIcons[mode]}"
        @action=${this._handleAction}
        .actionHandler=${Object(_common_directives_action_handler_directive__WEBPACK_IMPORTED_MODULE_11__["actionHandler"])()}
        tabindex="0"
      ></paper-icon-button>
    `;
      }
    }, {
      kind: "method",
      key: "_handleMoreInfo",
      value: function _handleMoreInfo() {
        Object(_common_dom_fire_event__WEBPACK_IMPORTED_MODULE_6__["fireEvent"])(this, "hass-more-info", {
          entityId: this._config.entity
        });
      }
    }, {
      kind: "method",
      key: "_handleAction",
      value: function _handleAction(e) {
        this.hass.callService("climate", "set_hvac_mode", {
          entity_id: this._config.entity,
          hvac_mode: e.currentTarget.mode
        });
      }
    }, {
      kind: "get",
      static: true,
      key: "styles",
      value: function styles() {
        return lit_element__WEBPACK_IMPORTED_MODULE_2__["css"]`
      :host {
        display: block;
      }

      ha-card {
        height: 100%;
        position: relative;
        overflow: hidden;
        --name-font-size: 1.2rem;
        --brightness-font-size: 1.2rem;
        --rail-border-color: transparent;
        --auto-color: green;
        --eco-color: springgreen;
        --cool-color: #2b9af9;
        --heat-color: #ff8100;
        --manual-color: #44739e;
        --off-color: #8a8a8a;
        --fan_only-color: #8a8a8a;
        --dry-color: #efbd07;
        --idle-color: #8a8a8a;
        --unknown-color: #bac;
      }
      .auto,
      .heat_cool {
        --mode-color: var(--auto-color);
      }
      .cool {
        --mode-color: var(--cool-color);
      }
      .heat {
        --mode-color: var(--heat-color);
      }
      .manual {
        --mode-color: var(--manual-color);
      }
      .off {
        --mode-color: var(--off-color);
      }
      .fan_only {
        --mode-color: var(--fan_only-color);
      }
      .eco {
        --mode-color: var(--eco-color);
      }
      .dry {
        --mode-color: var(--dry-color);
      }
      .idle {
        --mode-color: var(--idle-color);
      }
      .unknown-mode {
        --mode-color: var(--unknown-color);
      }

      .more-info {
        position: absolute;
        cursor: pointer;
        top: 0;
        right: 0;
        border-radius: 100%;
        color: var(--secondary-text-color);
        z-index: 25;
      }

      .content {
        height: 100%;
        display: flex;
        flex-direction: column;
        justify-content: center;
      }

      #controls {
        display: flex;
        justify-content: center;
        padding: 16px;
        position: relative;
      }

      #slider {
        height: 100%;
        width: 100%;
        position: relative;
        max-width: 250px;
        min-width: 100px;
      }

      round-slider {
        --round-slider-path-color: var(--disabled-text-color);
        --round-slider-bar-color: var(--mode-color);
        padding-bottom: 10%;
      }

      #slider-center {
        position: absolute;
        width: calc(100% - 40px);
        height: calc(100% - 40px);
        box-sizing: border-box;
        border-radius: 100%;
        left: 20px;
        top: 20px;
        text-align: center;
        overflow-wrap: break-word;
        pointer-events: none;
      }

      #temperature {
        position: absolute;
        transform: translate(-50%, -50%);
        width: 100%;
        height: 50%;
        top: 45%;
        left: 50%;
      }

      #set-values {
        max-width: 80%;
        transform: translate(0, -50%);
        font-size: 20px;
      }

      #set-mode {
        fill: var(--secondary-text-color);
        font-size: 16px;
      }

      #info {
        display: flex-vertical;
        justify-content: center;
        text-align: center;
        padding: 16px;
        margin-top: -60px;
        font-size: var(--name-font-size);
      }

      #modes > * {
        color: var(--disabled-text-color);
        cursor: pointer;
        display: inline-block;
      }

      #modes .selected-icon {
        color: var(--mode-color);
      }

      text {
        fill: var(--primary-text-color);
      }
    `;
      }
    }]
  };
}, lit_element__WEBPACK_IMPORTED_MODULE_2__["LitElement"]);

/***/ }),

/***/ "./src/panels/lovelace/cards/hui-vertical-stack-card.ts":
/*!**************************************************************!*\
  !*** ./src/panels/lovelace/cards/hui-vertical-stack-card.ts ***!
  \**************************************************************/
/*! no exports provided */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var lit_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lit-element */ "./node_modules/lit-element/lit-element.js");
/* harmony import */ var _common_compute_card_size__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../common/compute-card-size */ "./src/panels/lovelace/common/compute-card-size.ts");
/* harmony import */ var _hui_stack_card__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./hui-stack-card */ "./src/panels/lovelace/cards/hui-stack-card.ts");




class HuiVerticalStackCard extends _hui_stack_card__WEBPACK_IMPORTED_MODULE_2__["HuiStackCard"] {
  getCardSize() {
    let totalSize = 0;

    if (!this._cards) {
      return totalSize;
    }

    for (const element of this._cards) {
      totalSize += Object(_common_compute_card_size__WEBPACK_IMPORTED_MODULE_1__["computeCardSize"])(element);
    }

    return totalSize;
  }

  static get styles() {
    return [super.sharedStyles, lit_element__WEBPACK_IMPORTED_MODULE_0__["css"]`
        #root {
          display: flex;
          flex-direction: column;
        }
        #root > * {
          margin: 4px 0 4px 0;
        }
        #root > *:first-child {
          margin-top: 0;
        }
        #root > *:last-child {
          margin-bottom: 0;
        }
      `];
  }

}

customElements.define("hui-vertical-stack-card", HuiVerticalStackCard);

/***/ }),

/***/ "./src/panels/lovelace/cards/hui-weather-forecast-card.ts":
/*!****************************************************************!*\
  !*** ./src/panels/lovelace/cards/hui-weather-forecast-card.ts ***!
  \****************************************************************/
/*! no exports provided */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var lit_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lit-element */ "./node_modules/lit-element/lit-element.js");
/* harmony import */ var _common_dom_apply_themes_on_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../common/dom/apply_themes_on_element */ "./src/common/dom/apply_themes_on_element.ts");
/* harmony import */ var _common_dom_fire_event__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../common/dom/fire_event */ "./src/common/dom/fire_event.ts");
/* harmony import */ var _common_entity_compute_state_display__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../common/entity/compute_state_display */ "./src/common/entity/compute_state_display.ts");
/* harmony import */ var _common_entity_compute_state_name__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../common/entity/compute_state_name */ "./src/common/entity/compute_state_name.ts");
/* harmony import */ var _common_entity_state_icon__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../common/entity/state_icon */ "./src/common/entity/state_icon.ts");
/* harmony import */ var _common_entity_valid_entity_id__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../common/entity/valid_entity_id */ "./src/common/entity/valid_entity_id.ts");
/* harmony import */ var _common_util_debounce__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../common/util/debounce */ "./src/common/util/debounce.ts");
/* harmony import */ var _components_ha_card__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../components/ha-card */ "./src/components/ha-card.ts");
/* harmony import */ var _components_ha_icon__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../../components/ha-icon */ "./src/components/ha-icon.ts");
/* harmony import */ var _data_entity__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../../data/entity */ "./src/data/entity.ts");
/* harmony import */ var _data_weather__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../../data/weather */ "./src/data/weather.ts");
/* harmony import */ var _common_directives_action_handler_directive__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../common/directives/action-handler-directive */ "./src/panels/lovelace/common/directives/action-handler-directive.ts");
/* harmony import */ var _common_find_entites__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../common/find-entites */ "./src/panels/lovelace/common/find-entites.ts");
/* harmony import */ var _common_has_changed__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../common/has-changed */ "./src/panels/lovelace/common/has-changed.ts");
/* harmony import */ var _components_hui_warning__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../components/hui-warning */ "./src/panels/lovelace/components/hui-warning.ts");
function _decorate(decorators, factory, superClass, mixins) { var api = _getDecoratorsApi(); if (mixins) { for (var i = 0; i < mixins.length; i++) { api = mixins[i](api); } } var r = factory(function initialize(O) { api.initializeInstanceElements(O, decorated.elements); }, superClass); var decorated = api.decorateClass(_coalesceClassElements(r.d.map(_createElementDescriptor)), decorators); api.initializeClassElements(r.F, decorated.elements); return api.runClassFinishers(r.F, decorated.finishers); }

function _getDecoratorsApi() { _getDecoratorsApi = function () { return api; }; var api = { elementsDefinitionOrder: [["method"], ["field"]], initializeInstanceElements: function (O, elements) { ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { if (element.kind === kind && element.placement === "own") { this.defineClassElement(O, element); } }, this); }, this); }, initializeClassElements: function (F, elements) { var proto = F.prototype; ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { var placement = element.placement; if (element.kind === kind && (placement === "static" || placement === "prototype")) { var receiver = placement === "static" ? F : proto; this.defineClassElement(receiver, element); } }, this); }, this); }, defineClassElement: function (receiver, element) { var descriptor = element.descriptor; if (element.kind === "field") { var initializer = element.initializer; descriptor = { enumerable: descriptor.enumerable, writable: descriptor.writable, configurable: descriptor.configurable, value: initializer === void 0 ? void 0 : initializer.call(receiver) }; } Object.defineProperty(receiver, element.key, descriptor); }, decorateClass: function (elements, decorators) { var newElements = []; var finishers = []; var placements = { static: [], prototype: [], own: [] }; elements.forEach(function (element) { this.addElementPlacement(element, placements); }, this); elements.forEach(function (element) { if (!_hasDecorators(element)) return newElements.push(element); var elementFinishersExtras = this.decorateElement(element, placements); newElements.push(elementFinishersExtras.element); newElements.push.apply(newElements, elementFinishersExtras.extras); finishers.push.apply(finishers, elementFinishersExtras.finishers); }, this); if (!decorators) { return { elements: newElements, finishers: finishers }; } var result = this.decorateConstructor(newElements, decorators); finishers.push.apply(finishers, result.finishers); result.finishers = finishers; return result; }, addElementPlacement: function (element, placements, silent) { var keys = placements[element.placement]; if (!silent && keys.indexOf(element.key) !== -1) { throw new TypeError("Duplicated element (" + element.key + ")"); } keys.push(element.key); }, decorateElement: function (element, placements) { var extras = []; var finishers = []; for (var decorators = element.decorators, i = decorators.length - 1; i >= 0; i--) { var keys = placements[element.placement]; keys.splice(keys.indexOf(element.key), 1); var elementObject = this.fromElementDescriptor(element); var elementFinisherExtras = this.toElementFinisherExtras((0, decorators[i])(elementObject) || elementObject); element = elementFinisherExtras.element; this.addElementPlacement(element, placements); if (elementFinisherExtras.finisher) { finishers.push(elementFinisherExtras.finisher); } var newExtras = elementFinisherExtras.extras; if (newExtras) { for (var j = 0; j < newExtras.length; j++) { this.addElementPlacement(newExtras[j], placements); } extras.push.apply(extras, newExtras); } } return { element: element, finishers: finishers, extras: extras }; }, decorateConstructor: function (elements, decorators) { var finishers = []; for (var i = decorators.length - 1; i >= 0; i--) { var obj = this.fromClassDescriptor(elements); var elementsAndFinisher = this.toClassDescriptor((0, decorators[i])(obj) || obj); if (elementsAndFinisher.finisher !== undefined) { finishers.push(elementsAndFinisher.finisher); } if (elementsAndFinisher.elements !== undefined) { elements = elementsAndFinisher.elements; for (var j = 0; j < elements.length - 1; j++) { for (var k = j + 1; k < elements.length; k++) { if (elements[j].key === elements[k].key && elements[j].placement === elements[k].placement) { throw new TypeError("Duplicated element (" + elements[j].key + ")"); } } } } } return { elements: elements, finishers: finishers }; }, fromElementDescriptor: function (element) { var obj = { kind: element.kind, key: element.key, placement: element.placement, descriptor: element.descriptor }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); if (element.kind === "field") obj.initializer = element.initializer; return obj; }, toElementDescriptors: function (elementObjects) { if (elementObjects === undefined) return; return _toArray(elementObjects).map(function (elementObject) { var element = this.toElementDescriptor(elementObject); this.disallowProperty(elementObject, "finisher", "An element descriptor"); this.disallowProperty(elementObject, "extras", "An element descriptor"); return element; }, this); }, toElementDescriptor: function (elementObject) { var kind = String(elementObject.kind); if (kind !== "method" && kind !== "field") { throw new TypeError('An element descriptor\'s .kind property must be either "method" or' + ' "field", but a decorator created an element descriptor with' + ' .kind "' + kind + '"'); } var key = _toPropertyKey(elementObject.key); var placement = String(elementObject.placement); if (placement !== "static" && placement !== "prototype" && placement !== "own") { throw new TypeError('An element descriptor\'s .placement property must be one of "static",' + ' "prototype" or "own", but a decorator created an element descriptor' + ' with .placement "' + placement + '"'); } var descriptor = elementObject.descriptor; this.disallowProperty(elementObject, "elements", "An element descriptor"); var element = { kind: kind, key: key, placement: placement, descriptor: Object.assign({}, descriptor) }; if (kind !== "field") { this.disallowProperty(elementObject, "initializer", "A method descriptor"); } else { this.disallowProperty(descriptor, "get", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "set", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "value", "The property descriptor of a field descriptor"); element.initializer = elementObject.initializer; } return element; }, toElementFinisherExtras: function (elementObject) { var element = this.toElementDescriptor(elementObject); var finisher = _optionalCallableProperty(elementObject, "finisher"); var extras = this.toElementDescriptors(elementObject.extras); return { element: element, finisher: finisher, extras: extras }; }, fromClassDescriptor: function (elements) { var obj = { kind: "class", elements: elements.map(this.fromElementDescriptor, this) }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); return obj; }, toClassDescriptor: function (obj) { var kind = String(obj.kind); if (kind !== "class") { throw new TypeError('A class descriptor\'s .kind property must be "class", but a decorator' + ' created a class descriptor with .kind "' + kind + '"'); } this.disallowProperty(obj, "key", "A class descriptor"); this.disallowProperty(obj, "placement", "A class descriptor"); this.disallowProperty(obj, "descriptor", "A class descriptor"); this.disallowProperty(obj, "initializer", "A class descriptor"); this.disallowProperty(obj, "extras", "A class descriptor"); var finisher = _optionalCallableProperty(obj, "finisher"); var elements = this.toElementDescriptors(obj.elements); return { elements: elements, finisher: finisher }; }, runClassFinishers: function (constructor, finishers) { for (var i = 0; i < finishers.length; i++) { var newConstructor = (0, finishers[i])(constructor); if (newConstructor !== undefined) { if (typeof newConstructor !== "function") { throw new TypeError("Finishers must return a constructor."); } constructor = newConstructor; } } return constructor; }, disallowProperty: function (obj, name, objectType) { if (obj[name] !== undefined) { throw new TypeError(objectType + " can't have a ." + name + " property."); } } }; return api; }

function _createElementDescriptor(def) { var key = _toPropertyKey(def.key); var descriptor; if (def.kind === "method") { descriptor = { value: def.value, writable: true, configurable: true, enumerable: false }; } else if (def.kind === "get") { descriptor = { get: def.value, configurable: true, enumerable: false }; } else if (def.kind === "set") { descriptor = { set: def.value, configurable: true, enumerable: false }; } else if (def.kind === "field") { descriptor = { configurable: true, writable: true, enumerable: true }; } var element = { kind: def.kind === "field" ? "field" : "method", key: key, placement: def.static ? "static" : def.kind === "field" ? "own" : "prototype", descriptor: descriptor }; if (def.decorators) element.decorators = def.decorators; if (def.kind === "field") element.initializer = def.value; return element; }

function _coalesceGetterSetter(element, other) { if (element.descriptor.get !== undefined) { other.descriptor.get = element.descriptor.get; } else { other.descriptor.set = element.descriptor.set; } }

function _coalesceClassElements(elements) { var newElements = []; var isSameElement = function (other) { return other.kind === "method" && other.key === element.key && other.placement === element.placement; }; for (var i = 0; i < elements.length; i++) { var element = elements[i]; var other; if (element.kind === "method" && (other = newElements.find(isSameElement))) { if (_isDataDescriptor(element.descriptor) || _isDataDescriptor(other.descriptor)) { if (_hasDecorators(element) || _hasDecorators(other)) { throw new ReferenceError("Duplicated methods (" + element.key + ") can't be decorated."); } other.descriptor = element.descriptor; } else { if (_hasDecorators(element)) { if (_hasDecorators(other)) { throw new ReferenceError("Decorators can't be placed on different accessors with for " + "the same property (" + element.key + ")."); } other.decorators = element.decorators; } _coalesceGetterSetter(element, other); } } else { newElements.push(element); } } return newElements; }

function _hasDecorators(element) { return element.decorators && element.decorators.length; }

function _isDataDescriptor(desc) { return desc !== undefined && !(desc.value === undefined && desc.writable === undefined); }

function _optionalCallableProperty(obj, name) { var value = obj[name]; if (value !== undefined && typeof value !== "function") { throw new TypeError("Expected '" + name + "' to be a function"); } return value; }

function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }

function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }

function _toArray(arr) { return _arrayWithHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(n); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get; } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return _get(target, property, receiver || target); }

function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

















const DAY_IN_MILLISECONDS = 86400000;

let HuiWeatherForecastCard = _decorate([Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["customElement"])("hui-weather-forecast-card")], function (_initialize, _LitElement) {
  class HuiWeatherForecastCard extends _LitElement {
    constructor(...args) {
      super(...args);

      _initialize(this);
    }

  }

  return {
    F: HuiWeatherForecastCard,
    d: [{
      kind: "method",
      static: true,
      key: "getConfigElement",
      value: async function getConfigElement() {
        await Promise.all(/*! import() | hui-weather-forecast-card-editor */[__webpack_require__.e(1), __webpack_require__.e(0), __webpack_require__.e(2), __webpack_require__.e(3), __webpack_require__.e(6), __webpack_require__.e(7), __webpack_require__.e(8), __webpack_require__.e("vendors~hui-alarm-panel-card-editor~hui-button-card-editor~hui-conditional-card-editor~hui-entities-~37aad430"), __webpack_require__.e("vendors~hui-weather-forecast-card-editor"), __webpack_require__.e(10), __webpack_require__.e("hui-alarm-panel-card-editor~hui-button-card-editor~hui-dialog-edit-view~hui-entities-card-editor~hui~192a43f6"), __webpack_require__.e("hui-weather-forecast-card-editor")]).then(__webpack_require__.bind(null, /*! ../editor/config-elements/hui-weather-forecast-card-editor */ "./src/panels/lovelace/editor/config-elements/hui-weather-forecast-card-editor.ts"));
        return document.createElement("hui-weather-forecast-card-editor");
      }
    }, {
      kind: "method",
      static: true,
      key: "getStubConfig",
      value: function getStubConfig(hass, entities, entitiesFallback) {
        const includeDomains = ["weather"];
        const maxEntities = 1;
        const foundEntities = Object(_common_find_entites__WEBPACK_IMPORTED_MODULE_13__["findEntities"])(hass, maxEntities, entities, entitiesFallback, includeDomains);
        return {
          type: "weather-forecast",
          entity: foundEntities[0] || ""
        };
      }
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "hass",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "_config",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])({
        type: Boolean,
        reflect: true,
        attribute: "narrow"
      })],
      key: "_narrow",

      value() {
        return false;
      }

    }, {
      kind: "field",
      key: "_resizeObserver",
      value: void 0
    }, {
      kind: "method",
      key: "connectedCallback",
      value: function connectedCallback() {
        _get(_getPrototypeOf(HuiWeatherForecastCard.prototype), "connectedCallback", this).call(this);

        this.updateComplete.then(() => this._measureCard());
      }
    }, {
      kind: "method",
      key: "getCardSize",
      value: function getCardSize() {
        var _this$_config;

        return ((_this$_config = this._config) === null || _this$_config === void 0 ? void 0 : _this$_config.show_forecast) !== false ? 4 : 2;
      }
    }, {
      kind: "method",
      key: "setConfig",
      value: function setConfig(config) {
        if (!config || !config.entity) {
          throw new Error("Invalid card configuration");
        }

        if (!Object(_common_entity_valid_entity_id__WEBPACK_IMPORTED_MODULE_6__["isValidEntityId"])(config.entity)) {
          throw new Error("Invalid Entity");
        }

        this._config = config;
      }
    }, {
      kind: "method",
      key: "updated",
      value: function updated(changedProps) {
        _get(_getPrototypeOf(HuiWeatherForecastCard.prototype), "updated", this).call(this, changedProps);

        if (!this._config || !this.hass) {
          return;
        }

        const oldHass = changedProps.get("hass");
        const oldConfig = changedProps.get("_config");

        if (!oldHass || !oldConfig || oldHass.themes !== this.hass.themes || oldConfig.theme !== this._config.theme) {
          Object(_common_dom_apply_themes_on_element__WEBPACK_IMPORTED_MODULE_1__["applyThemesOnElement"])(this, this.hass.themes, this._config.theme);
        }
      }
    }, {
      kind: "method",
      key: "render",
      value: function render() {
        var _this$_config2, _stateObj$attributes$;

        if (!this._config || !this.hass) {
          return lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]``;
        }

        const stateObj = this.hass.states[this._config.entity];

        if (!stateObj) {
          return lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
        <hui-warning
          >${this.hass.localize("ui.panel.lovelace.warning.entity_not_found", "entity", this._config.entity)}</hui-warning
        >
      `;
        }

        if (stateObj.state === _data_entity__WEBPACK_IMPORTED_MODULE_10__["UNAVAILABLE"]) {
          return lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
        <ha-card class="unavailable" @click=${this._handleAction}>
          ${this.hass.localize("ui.panel.lovelace.warning.entity_unavailable", "entity", `${Object(_common_entity_compute_state_name__WEBPACK_IMPORTED_MODULE_4__["computeStateName"])(stateObj)} (${this._config.entity})`)}
        </ha-card>
      `;
        }

        const forecast = ((_this$_config2 = this._config) === null || _this$_config2 === void 0 ? void 0 : _this$_config2.show_forecast) !== false && ((_stateObj$attributes$ = stateObj.attributes.forecast) === null || _stateObj$attributes$ === void 0 ? void 0 : _stateObj$attributes$.length) ? stateObj.attributes.forecast.slice(0, this._narrow ? 3 : 5) : undefined;
        let hourly;

        if ((forecast === null || forecast === void 0 ? void 0 : forecast.length) && (forecast === null || forecast === void 0 ? void 0 : forecast.length) > 1) {
          const date1 = new Date(forecast[0].datetime);
          const date2 = new Date(forecast[1].datetime);
          const timeDiff = date2.getTime() - date1.getTime();
          hourly = timeDiff < DAY_IN_MILLISECONDS;
        }

        return lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
      <ha-card
        @action=${this._handleAction}
        .actionHandler=${Object(_common_directives_action_handler_directive__WEBPACK_IMPORTED_MODULE_12__["actionHandler"])()}
        tabindex="0"
      >
        <div class="content">
          <div class="icon-image">
            ${stateObj.state in _data_weather__WEBPACK_IMPORTED_MODULE_11__["weatherImages"] ? lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
                  <img
                    class="weather-image"
                    src="${_data_weather__WEBPACK_IMPORTED_MODULE_11__["weatherImages"][stateObj.state]}"
                  />
                ` : lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
                  <ha-icon
                    class="weather-icon"
                    .icon=${_data_weather__WEBPACK_IMPORTED_MODULE_11__["weatherIcons"][stateObj.state] || Object(_common_entity_state_icon__WEBPACK_IMPORTED_MODULE_5__["stateIcon"])(stateObj)}
                  ></ha-icon>
                `}
          </div>
          <div class="info">
            <div class="name-state">
              <div class="name">
                ${this._config.name || Object(_common_entity_compute_state_name__WEBPACK_IMPORTED_MODULE_4__["computeStateName"])(stateObj)}
              </div>
              <div class="state">
                ${Object(_common_entity_compute_state_display__WEBPACK_IMPORTED_MODULE_3__["computeStateDisplay"])(this.hass.localize, stateObj, this.hass.language)}
              </div>
            </div>
            <div class="temp-attribute">
              <div class="temp">
                ${stateObj.attributes.temperature}<span
                  >${Object(_data_weather__WEBPACK_IMPORTED_MODULE_11__["getWeatherUnit"])(this.hass, "temperature")}</span
                >
              </div>
              <div class="attribute">
                ${Object(_data_weather__WEBPACK_IMPORTED_MODULE_11__["getSecondaryWeatherAttribute"])(this.hass, stateObj)}
              </div>
            </div>
          </div>
        </div>
        ${forecast ? lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
              <div class="forecast">
                ${forecast.map(item => lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
                    <div>
                      <div>
                        ${hourly ? lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
                              ${new Date(item.datetime).toLocaleTimeString(this.hass.language, {
          hour: "numeric"
        })}
                            ` : lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
                              ${new Date(item.datetime).toLocaleDateString(this.hass.language, {
          weekday: "short"
        })}
                            `}
                      </div>
                      ${item.condition !== undefined && item.condition !== null ? lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
                            <div class="forecast-image-icon">
                              ${item.condition in _data_weather__WEBPACK_IMPORTED_MODULE_11__["weatherImages"] ? lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
                                    <img
                                      class="forecast-image"
                                      src="${_data_weather__WEBPACK_IMPORTED_MODULE_11__["weatherImages"][item.condition]}"
                                    />
                                  ` : item.condition in _data_weather__WEBPACK_IMPORTED_MODULE_11__["weatherIcons"] ? lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
                                    <ha-icon
                                      class="forecast-icon"
                                      .icon=${_data_weather__WEBPACK_IMPORTED_MODULE_11__["weatherIcons"][item.condition]}
                                    ></ha-icon>
                                  ` : ""}
                            </div>
                          ` : ""}
                      ${item.temperature !== undefined && item.temperature !== null ? lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
                            <div class="temp">
                              ${item.temperature}°
                            </div>
                          ` : ""}
                      ${item.templow !== undefined && item.templow !== null ? lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
                            <div class="templow">
                              ${item.templow}°
                            </div>
                          ` : ""}
                    </div>
                  `)}
              </div>
            ` : ""}
      </ha-card>
    `;
      }
    }, {
      kind: "method",
      key: "shouldUpdate",
      value: function shouldUpdate(changedProps) {
        return Object(_common_has_changed__WEBPACK_IMPORTED_MODULE_14__["hasConfigOrEntityChanged"])(this, changedProps);
      }
    }, {
      kind: "method",
      key: "firstUpdated",
      value: function firstUpdated() {
        this._attachObserver();
      }
    }, {
      kind: "method",
      key: "_handleAction",
      value: function _handleAction() {
        Object(_common_dom_fire_event__WEBPACK_IMPORTED_MODULE_2__["fireEvent"])(this, "hass-more-info", {
          entityId: this._config.entity
        });
      }
    }, {
      kind: "method",
      key: "_attachObserver",
      value: function _attachObserver() {
        if (typeof ResizeObserver !== "function") {
          __webpack_require__.e(/*! import() */ 25).then(__webpack_require__.t.bind(null, /*! resize-observer */ "./node_modules/resize-observer/lib/ResizeObserver.js", 7)).then(modules => {
            modules.install();

            this._attachObserver();
          });
          return;
        }

        this._resizeObserver = new ResizeObserver(Object(_common_util_debounce__WEBPACK_IMPORTED_MODULE_7__["debounce"])(() => this._measureCard(), 250, false));
        const card = this.shadowRoot.querySelector("ha-card"); // If we show an error or warning there is no ha-card

        if (!card) {
          return;
        }

        this._resizeObserver.observe(card);
      }
    }, {
      kind: "method",
      key: "_measureCard",
      value: function _measureCard() {
        this._narrow = this.offsetWidth < 375;

        if (this.offsetWidth < 300) {
          this.setAttribute("verynarrow", "");
        } else {
          this.removeAttribute("verynarrow");
        }

        if (this.offsetWidth < 225) {
          this.setAttribute("veryverynarrow", "");
        } else {
          this.removeAttribute("veryverynarrow");
        }
      }
    }, {
      kind: "get",
      static: true,
      key: "styles",
      value: function styles() {
        return lit_element__WEBPACK_IMPORTED_MODULE_0__["css"]`
      :host {
        display: block;
      }

      ha-card {
        cursor: pointer;
        padding: 16px;
      }

      .content {
        display: flex;
        flex-wrap: nowrap;
        justify-content: space-between;
        align-items: center;
      }

      .icon-image {
        display: flex;
        align-items: center;
        min-width: 64px;
        margin-right: 16px;
      }

      .weather-image,
      .weather-icon {
        flex: 0 0 64px;
      }

      .weather-icon {
        --iron-icon-width: 64px;
        --iron-icon-height: 64px;
      }

      .info {
        display: flex;
        justify-content: space-between;
        flex-grow: 1;
        overflow: hidden;
      }

      .temp-attribute {
        text-align: right;
      }

      .temp-attribute .temp {
        position: relative;
        margin-right: 24px;
      }

      .temp-attribute .temp span {
        position: absolute;
        font-size: 24px;
        top: 1px;
      }

      .name,
      .temp-attribute .temp {
        font-size: 28px;
        line-height: 1.2;
      }

      .state,
      .attribute {
        font-size: 14px;
        line-height: 1;
      }

      .name-state {
        overflow: hidden;
        padding-right: 12px;
        width: 100%;
      }

      .name,
      .state {
        overflow: hidden;
        text-overflow: ellipsis;
        white-space: nowrap;
      }

      .attribute {
        white-space: nowrap;
      }

      .forecast {
        display: flex;
        justify-content: space-around;
        padding-top: 16px;
      }

      .forecast > div {
        text-align: center;
      }

      .forecast .icon,
      .forecast .temp {
        margin: 4px 0;
      }

      .forecast .temp {
        font-size: 16px;
      }

      .forecast-image-icon {
        padding-top: 4px;
        padding-bottom: 4px;
      }

      .forecast-image {
        width: 40px;
      }

      .forecast-icon {
        --iron-icon-width: 40px;
        --iron-icon-height: 40px;
      }

      .attribute,
      .templow,
      .state {
        color: var(--secondary-text-color);
      }

      .unavailable {
        height: 100px;
        display: flex;
        justify-content: center;
        align-items: center;
        font-size: 16px;
        padding: 10px 20px;
        text-align: center;
      }

      /* ============= NARROW ============= */

      :host([narrow]) .icon-image {
        min-width: 52px;
      }

      :host([narrow]) .weather-image {
        flex: 0 0 52px;
        width: 52px;
      }

      :host([narrow]) .weather-icon {
        --iron-icon-width: 52px;
        --iron-icon-height: 52px;
      }

      :host([narrow]) .name,
      :host([narrow]) .temp-attribute .temp {
        font-size: 22px;
      }

      :host([narrow]) .temp-attribute .temp {
        margin-right: 16px;
      }

      :host([narrow]) .temp span {
        top: 1px;
        font-size: 16px;
      }

      /* ============= VERY NARROW ============= */

      :host([veryNarrow]) .state,
      :host([veryNarrow]) .attribute {
        display: none;
      }

      :host([veryNarrow]) .info {
        flex-direction: column;
        align-items: flex-start;
      }

      :host([veryNarrow]) .name-state {
        padding-right: 0;
      }

      /* ============= VERY VERY NARROW ============= */

      :host([veryVeryNarrow]) .info {
        padding-top: 4px;
        align-items: center;
      }

      :host([veryVeryNarrow]) .content {
        flex-wrap: wrap;
        justify-content: center;
        flex-direction: column;
      }

      :host([veryVeryNarrow]) .icon-image {
        margin-right: 0;
      }
    `;
      }
    }]
  };
}, lit_element__WEBPACK_IMPORTED_MODULE_0__["LitElement"]);

/***/ }),

/***/ "./src/panels/lovelace/common/compute-card-size.ts":
/*!*********************************************************!*\
  !*** ./src/panels/lovelace/common/compute-card-size.ts ***!
  \*********************************************************/
/*! exports provided: computeCardSize */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "computeCardSize", function() { return computeCardSize; });
const computeCardSize = card => {
  return typeof card.getCardSize === "function" ? card.getCardSize() : 1;
};

/***/ }),

/***/ "./src/panels/lovelace/common/entity/turn-on-off-entities.ts":
/*!*******************************************************************!*\
  !*** ./src/panels/lovelace/common/entity/turn-on-off-entities.ts ***!
  \*******************************************************************/
/*! exports provided: turnOnOffEntities */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "turnOnOffEntities", function() { return turnOnOffEntities; });
/* harmony import */ var _common_const__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../common/const */ "./src/common/const.ts");
/* harmony import */ var _common_entity_compute_domain__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../common/entity/compute_domain */ "./src/common/entity/compute_domain.ts");


const turnOnOffEntities = (hass, entityIds, turnOn = true) => {
  const domainsToCall = {};
  entityIds.forEach(entityId => {
    if (_common_const__WEBPACK_IMPORTED_MODULE_0__["STATES_OFF"].includes(hass.states[entityId].state) === turnOn) {
      const stateDomain = Object(_common_entity_compute_domain__WEBPACK_IMPORTED_MODULE_1__["computeDomain"])(entityId);
      const serviceDomain = ["cover", "lock"].includes(stateDomain) ? stateDomain : "homeassistant";

      if (!(serviceDomain in domainsToCall)) {
        domainsToCall[serviceDomain] = [];
      }

      domainsToCall[serviceDomain].push(entityId);
    }
  });
  Object.keys(domainsToCall).forEach(domain => {
    let service;

    switch (domain) {
      case "lock":
        service = turnOn ? "unlock" : "lock";
        break;

      case "cover":
        service = turnOn ? "open_cover" : "close_cover";
        break;

      default:
        service = turnOn ? "turn_on" : "turn_off";
    }

    const entities = domainsToCall[domain];
    hass.callService(domain, service, {
      entity_id: entities
    });
  });
};

/***/ }),

/***/ "./src/panels/lovelace/common/find-entites.ts":
/*!****************************************************!*\
  !*** ./src/panels/lovelace/common/find-entites.ts ***!
  \****************************************************/
/*! exports provided: findEntities */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "findEntities", function() { return findEntities; });
/* harmony import */ var _common_entity_compute_domain__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../common/entity/compute_domain */ "./src/common/entity/compute_domain.ts");


const arrayFilter = (array, conditions, maxSize) => {
  if (!maxSize || maxSize > array.length) {
    maxSize = array.length;
  }

  const filteredArray = [];

  for (let i = 0; i < array.length && filteredArray.length < maxSize; i++) {
    let meetsConditions = true;

    for (const condition of conditions) {
      if (!condition(array[i])) {
        meetsConditions = false;
        break;
      }
    }

    if (meetsConditions) {
      filteredArray.push(array[i]);
    }
  }

  return filteredArray;
};

const findEntities = (hass, maxEntities, entities, entitiesFallback, includeDomains, entityFilter) => {
  const conditions = [];

  if (includeDomains === null || includeDomains === void 0 ? void 0 : includeDomains.length) {
    conditions.push(eid => includeDomains.includes(Object(_common_entity_compute_domain__WEBPACK_IMPORTED_MODULE_0__["computeDomain"])(eid)));
  }

  if (entityFilter) {
    conditions.push(eid => hass.states[eid] && entityFilter(hass.states[eid]));
  }

  const entityIds = arrayFilter(entities, conditions, maxEntities);

  if (entityIds.length < maxEntities && entitiesFallback.length) {
    const fallbackEntityIds = findEntities(hass, maxEntities - entityIds.length, entitiesFallback, [], includeDomains, entityFilter);
    entityIds.push(...fallbackEntityIds);
  }

  return entityIds;
};

/***/ }),

/***/ "./src/panels/lovelace/common/generate-lovelace-config.ts":
/*!****************************************************************!*\
  !*** ./src/panels/lovelace/common/generate-lovelace-config.ts ***!
  \****************************************************************/
/*! exports provided: computeCards, generateDefaultViewConfig, generateLovelaceConfigFromData, generateLovelaceConfigFromHass */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "computeCards", function() { return computeCards; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "generateDefaultViewConfig", function() { return generateDefaultViewConfig; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "generateLovelaceConfigFromData", function() { return generateLovelaceConfigFromData; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "generateLovelaceConfigFromHass", function() { return generateLovelaceConfigFromHass; });
/* harmony import */ var _common_entity_compute_domain__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../common/entity/compute_domain */ "./src/common/entity/compute_domain.ts");
/* harmony import */ var _common_entity_compute_object_id__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../common/entity/compute_object_id */ "./src/common/entity/compute_object_id.ts");
/* harmony import */ var _common_entity_compute_state_domain__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../common/entity/compute_state_domain */ "./src/common/entity/compute_state_domain.ts");
/* harmony import */ var _common_entity_compute_state_name__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../common/entity/compute_state_name */ "./src/common/entity/compute_state_name.ts");
/* harmony import */ var _common_entity_extract_views__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../common/entity/extract_views */ "./src/common/entity/extract_views.ts");
/* harmony import */ var _common_entity_get_view_entities__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../common/entity/get_view_entities */ "./src/common/entity/get_view_entities.ts");
/* harmony import */ var _common_entity_split_by_groups__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../common/entity/split_by_groups */ "./src/common/entity/split_by_groups.ts");
/* harmony import */ var _common_string_compare__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../common/string/compare */ "./src/common/string/compare.ts");
/* harmony import */ var _common_util_subscribe_one__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../common/util/subscribe-one */ "./src/common/util/subscribe-one.ts");
/* harmony import */ var _data_area_registry__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../../data/area_registry */ "./src/data/area_registry.ts");
/* harmony import */ var _data_device_registry__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../../data/device_registry */ "./src/data/device_registry.ts");
/* harmony import */ var _data_entity_registry__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../../data/entity_registry */ "./src/data/entity_registry.ts");
/* harmony import */ var _data_integration__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../../data/integration */ "./src/data/integration.ts");
/* harmony import */ var _data_sensor__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../../data/sensor */ "./src/data/sensor.ts");
/* harmony import */ var _editor_process_editor_entities__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../editor/process-editor-entities */ "./src/panels/lovelace/editor/process-editor-entities.ts");















const DEFAULT_VIEW_ENTITY_ID = "group.default_view";
const DOMAINS_BADGES = ["binary_sensor", "mailbox", "person", "sensor", "sun", "timer"];
const HIDE_DOMAIN = new Set(["automation", "configurator", "device_tracker", "geo_location", "persistent_notification"]);
let subscribedRegistries = false;

const splitByAreas = (areaEntries, deviceEntries, entityEntries, entities) => {
  const allEntities = Object.assign({}, entities);
  const areasWithEntities = [];

  for (const area of areaEntries) {
    const areaEntities = [];
    const areaDevices = new Set(deviceEntries.filter(device => device.area_id === area.area_id).map(device => device.id));

    for (const entity of entityEntries) {
      if (areaDevices.has( // @ts-ignore
      entity.device_id) && entity.entity_id in allEntities) {
        areaEntities.push(allEntities[entity.entity_id]);
        delete allEntities[entity.entity_id];
      }
    }

    if (areaEntities.length > 0) {
      areasWithEntities.push([area, areaEntities]);
    }
  }

  return {
    areasWithEntities,
    otherEntities: allEntities
  };
};

const computeCards = (states, entityCardOptions, single = false) => {
  const cards = []; // For entity card

  const entities = [];
  const titlePrefix = entityCardOptions.title ? `${entityCardOptions.title} ` : undefined;

  for (const [entityId, stateObj] of states) {
    const domain = Object(_common_entity_compute_domain__WEBPACK_IMPORTED_MODULE_0__["computeDomain"])(entityId);

    if (domain === "alarm_control_panel") {
      const cardConfig = {
        type: "alarm-panel",
        entity: entityId
      };
      cards.push(cardConfig);
    } else if (domain === "camera") {
      const cardConfig = {
        type: "picture-entity",
        entity: entityId
      };
      cards.push(cardConfig);
    } else if (domain === "climate") {
      const cardConfig = {
        type: "thermostat",
        entity: entityId
      };
      cards.push(cardConfig);
    } else if (domain === "history_graph" && stateObj) {
      const cardConfig = {
        type: "history-graph",
        entities: stateObj.attributes.entity_id,
        hours_to_show: stateObj.attributes.hours_to_show,
        title: stateObj.attributes.friendly_name,
        refresh_interval: stateObj.attributes.refresh
      };
      cards.push(cardConfig);
    } else if (domain === "light" && single) {
      const cardConfig = {
        type: "light",
        entity: entityId
      };
      cards.push(cardConfig);
    } else if (domain === "media_player") {
      const cardConfig = {
        type: "media-control",
        entity: entityId
      };
      cards.push(cardConfig);
    } else if (domain === "plant") {
      const cardConfig = {
        type: "plant-status",
        entity: entityId
      };
      cards.push(cardConfig);
    } else if (domain === "weather") {
      const cardConfig = {
        type: "weather-forecast",
        entity: entityId
      };
      cards.push(cardConfig);
    } else if (domain === "weblink" && stateObj) {
      const conf = {
        type: "weblink",
        url: stateObj.state
      };

      if ("icon" in stateObj.attributes) {
        conf.icon = stateObj.attributes.icon;
      }

      entities.push(conf);
    } else if (domain === "sensor" && (stateObj === null || stateObj === void 0 ? void 0 : stateObj.attributes.device_class) === _data_sensor__WEBPACK_IMPORTED_MODULE_13__["SENSOR_DEVICE_CLASS_BATTERY"]) {// Do nothing.
    } else {
      let name;
      const entityConf = titlePrefix && stateObj && // eslint-disable-next-line no-cond-assign
      (name = Object(_common_entity_compute_state_name__WEBPACK_IMPORTED_MODULE_3__["computeStateName"])(stateObj)).startsWith(titlePrefix) ? {
        entity: entityId,
        name: name.substr(titlePrefix.length)
      } : entityId;
      entities.push(entityConf);
    }
  }

  if (entities.length > 0) {
    cards.unshift(Object.assign({
      type: "entities",
      entities
    }, entityCardOptions));
  }

  return cards;
};

const computeDefaultViewStates = entities => {
  const states = {};
  Object.keys(entities).forEach(entityId => {
    const stateObj = entities[entityId];

    if (!stateObj.attributes.hidden && !HIDE_DOMAIN.has(Object(_common_entity_compute_state_domain__WEBPACK_IMPORTED_MODULE_2__["computeStateDomain"])(stateObj))) {
      states[entityId] = entities[entityId];
    }
  });
  return states;
};

const generateViewConfig = (localize, path, title, icon, entities, groupOrders) => {
  const splitted = Object(_common_entity_split_by_groups__WEBPACK_IMPORTED_MODULE_6__["splitByGroups"])(entities);
  splitted.groups.sort((gr1, gr2) => groupOrders[gr1.entity_id] - groupOrders[gr2.entity_id]);
  const badgeEntities = {};
  const ungroupedEntitites = {}; // Organize ungrouped entities in badges/ungrouped things

  Object.keys(splitted.ungrouped).forEach(entityId => {
    const state = splitted.ungrouped[entityId];
    const domain = Object(_common_entity_compute_state_domain__WEBPACK_IMPORTED_MODULE_2__["computeStateDomain"])(state);
    const coll = DOMAINS_BADGES.includes(domain) ? badgeEntities : ungroupedEntitites;

    if (!(domain in coll)) {
      coll[domain] = [];
    }

    coll[domain].push(state.entity_id);
  });
  let badges = [];
  DOMAINS_BADGES.forEach(domain => {
    if (domain in badgeEntities) {
      badges = badges.concat(badgeEntities[domain]);
    }
  });
  let cards = [];
  splitted.groups.forEach(groupEntity => {
    cards = cards.concat(computeCards(groupEntity.attributes.entity_id.map(entityId => [entityId, entities[entityId]]), {
      title: Object(_common_entity_compute_state_name__WEBPACK_IMPORTED_MODULE_3__["computeStateName"])(groupEntity),
      show_header_toggle: groupEntity.attributes.control !== "hidden"
    }));
  });
  Object.keys(ungroupedEntitites).sort().forEach(domain => {
    cards = cards.concat(computeCards(ungroupedEntitites[domain].sort((a, b) => Object(_common_string_compare__WEBPACK_IMPORTED_MODULE_7__["compare"])(Object(_common_entity_compute_state_name__WEBPACK_IMPORTED_MODULE_3__["computeStateName"])(entities[a]), Object(_common_entity_compute_state_name__WEBPACK_IMPORTED_MODULE_3__["computeStateName"])(entities[b]))).map(entityId => [entityId, entities[entityId]]), {
      title: Object(_data_integration__WEBPACK_IMPORTED_MODULE_12__["domainToName"])(localize, domain)
    }));
  });
  const view = {
    path,
    title,
    badges: Object(_editor_process_editor_entities__WEBPACK_IMPORTED_MODULE_14__["processEditorEntities"])(badges),
    cards
  };

  if (icon) {
    view.icon = icon;
  }

  return view;
};

const generateDefaultViewConfig = (areaEntries, deviceEntries, entityEntries, entities, localize) => {
  const states = computeDefaultViewStates(entities);
  const path = "default_view";
  const title = "Home";
  const icon = undefined; // In the case of a default view, we want to use the group order attribute

  const groupOrders = {};
  Object.keys(states).forEach(entityId => {
    const stateObj = states[entityId];

    if (stateObj.attributes.order) {
      groupOrders[entityId] = stateObj.attributes.order;
    }
  });
  const splittedByAreas = splitByAreas(areaEntries, deviceEntries, entityEntries, states);
  const config = generateViewConfig(localize, path, title, icon, splittedByAreas.otherEntities, groupOrders);
  const areaCards = [];
  splittedByAreas.areasWithEntities.forEach(([area, areaEntities]) => {
    areaCards.push(...computeCards(areaEntities.map(entity => [entity.entity_id, entity]), {
      title: area.name
    }));
  });
  config.cards.unshift(...areaCards);
  return config;
};
const generateLovelaceConfigFromData = async (config, areaEntries, deviceEntries, entityEntries, entities, localize) => {
  if (config.safe_mode) {
    return {
      title: config.location_name,
      views: [{
        cards: [{
          type: "safe-mode"
        }]
      }]
    };
  }

  const viewEntities = Object(_common_entity_extract_views__WEBPACK_IMPORTED_MODULE_4__["extractViews"])(entities);
  const views = viewEntities.map(viewEntity => {
    const states = Object(_common_entity_get_view_entities__WEBPACK_IMPORTED_MODULE_5__["getViewEntities"])(entities, viewEntity); // In the case of a normal view, we use group order as specified in view

    const groupOrders = {};
    Object.keys(states).forEach((entityId, idx) => {
      groupOrders[entityId] = idx;
    });
    return generateViewConfig(localize, Object(_common_entity_compute_object_id__WEBPACK_IMPORTED_MODULE_1__["computeObjectId"])(viewEntity.entity_id), Object(_common_entity_compute_state_name__WEBPACK_IMPORTED_MODULE_3__["computeStateName"])(viewEntity), viewEntity.attributes.icon, states, groupOrders);
  });
  let title = config.location_name; // User can override default view. If they didn't, we will add one
  // that contains all entities.

  if (viewEntities.length === 0 || viewEntities[0].entity_id !== DEFAULT_VIEW_ENTITY_ID) {
    views.unshift(generateDefaultViewConfig(areaEntries, deviceEntries, entityEntries, entities, localize)); // Add map of geo locations to default view if loaded

    if (config.components.includes("geo_location")) {
      if (views[0] && views[0].cards) {
        views[0].cards.push({
          type: "map",
          geo_location_sources: ["all"]
        });
      }
    } // Make sure we don't have Home as title and first tab.


    if (views.length > 1 && title === "Home") {
      title = "Home Assistant";
    }
  } // User has no entities


  if (views.length === 1 && views[0].cards.length === 0) {
    views[0].cards.push({
      type: "empty-state"
    });
  }

  return {
    title,
    views
  };
};
const generateLovelaceConfigFromHass = async hass => {
  // We want to keep the registry subscriptions alive after generating the UI
  // so that we don't serve up stale data after changing areas.
  if (!subscribedRegistries) {
    subscribedRegistries = true;
    Object(_data_area_registry__WEBPACK_IMPORTED_MODULE_9__["subscribeAreaRegistry"])(hass.connection, () => undefined);
    Object(_data_device_registry__WEBPACK_IMPORTED_MODULE_10__["subscribeDeviceRegistry"])(hass.connection, () => undefined);
    Object(_data_entity_registry__WEBPACK_IMPORTED_MODULE_11__["subscribeEntityRegistry"])(hass.connection, () => undefined);
  }

  const [areaEntries, deviceEntries, entityEntries] = await Promise.all([Object(_common_util_subscribe_one__WEBPACK_IMPORTED_MODULE_8__["subscribeOne"])(hass.connection, _data_area_registry__WEBPACK_IMPORTED_MODULE_9__["subscribeAreaRegistry"]), Object(_common_util_subscribe_one__WEBPACK_IMPORTED_MODULE_8__["subscribeOne"])(hass.connection, _data_device_registry__WEBPACK_IMPORTED_MODULE_10__["subscribeDeviceRegistry"]), Object(_common_util_subscribe_one__WEBPACK_IMPORTED_MODULE_8__["subscribeOne"])(hass.connection, _data_entity_registry__WEBPACK_IMPORTED_MODULE_11__["subscribeEntityRegistry"])]);
  return generateLovelaceConfigFromData(hass.config, areaEntries, deviceEntries, entityEntries, hass.states, hass.localize);
};

/***/ }),

/***/ "./src/panels/lovelace/common/process-config-entities.ts":
/*!***************************************************************!*\
  !*** ./src/panels/lovelace/common/process-config-entities.ts ***!
  \***************************************************************/
/*! exports provided: processConfigEntities */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "processConfigEntities", function() { return processConfigEntities; });
/* harmony import */ var _common_entity_valid_entity_id__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../common/entity/valid_entity_id */ "./src/common/entity/valid_entity_id.ts");
// Parse array of entity objects from config

const processConfigEntities = entities => {
  if (!entities || !Array.isArray(entities)) {
    throw new Error("Entities need to be an array");
  }

  return entities.map((entityConf, index) => {
    if (typeof entityConf === "object" && !Array.isArray(entityConf) && entityConf.type) {
      return entityConf;
    }

    let config;

    if (typeof entityConf === "string") {
      config = {
        entity: entityConf
      };
    } else if (typeof entityConf === "object" && !Array.isArray(entityConf)) {
      if (!entityConf.entity) {
        throw new Error(`Entity object at position ${index} is missing entity field.`);
      }

      config = entityConf;
    } else {
      throw new Error(`Invalid entity specified at position ${index}.`);
    }

    if (!Object(_common_entity_valid_entity_id__WEBPACK_IMPORTED_MODULE_0__["isValidEntityId"])(config.entity)) {
      throw new Error(`Invalid entity ID at position ${index}: ${config.entity}`);
    }

    return config;
  });
};

/***/ }),

/***/ "./src/panels/lovelace/components/hui-entities-toggle.ts":
/*!***************************************************************!*\
  !*** ./src/panels/lovelace/components/hui-entities-toggle.ts ***!
  \***************************************************************/
/*! no exports provided */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var lit_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lit-element */ "./node_modules/lit-element/lit-element.js");
/* harmony import */ var _common_const__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../common/const */ "./src/common/const.ts");
/* harmony import */ var _components_ha_switch__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../components/ha-switch */ "./src/components/ha-switch.ts");
/* harmony import */ var _data_haptics__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../data/haptics */ "./src/data/haptics.ts");
/* harmony import */ var _common_entity_turn_on_off_entities__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../common/entity/turn-on-off-entities */ "./src/panels/lovelace/common/entity/turn-on-off-entities.ts");
function _decorate(decorators, factory, superClass, mixins) { var api = _getDecoratorsApi(); if (mixins) { for (var i = 0; i < mixins.length; i++) { api = mixins[i](api); } } var r = factory(function initialize(O) { api.initializeInstanceElements(O, decorated.elements); }, superClass); var decorated = api.decorateClass(_coalesceClassElements(r.d.map(_createElementDescriptor)), decorators); api.initializeClassElements(r.F, decorated.elements); return api.runClassFinishers(r.F, decorated.finishers); }

function _getDecoratorsApi() { _getDecoratorsApi = function () { return api; }; var api = { elementsDefinitionOrder: [["method"], ["field"]], initializeInstanceElements: function (O, elements) { ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { if (element.kind === kind && element.placement === "own") { this.defineClassElement(O, element); } }, this); }, this); }, initializeClassElements: function (F, elements) { var proto = F.prototype; ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { var placement = element.placement; if (element.kind === kind && (placement === "static" || placement === "prototype")) { var receiver = placement === "static" ? F : proto; this.defineClassElement(receiver, element); } }, this); }, this); }, defineClassElement: function (receiver, element) { var descriptor = element.descriptor; if (element.kind === "field") { var initializer = element.initializer; descriptor = { enumerable: descriptor.enumerable, writable: descriptor.writable, configurable: descriptor.configurable, value: initializer === void 0 ? void 0 : initializer.call(receiver) }; } Object.defineProperty(receiver, element.key, descriptor); }, decorateClass: function (elements, decorators) { var newElements = []; var finishers = []; var placements = { static: [], prototype: [], own: [] }; elements.forEach(function (element) { this.addElementPlacement(element, placements); }, this); elements.forEach(function (element) { if (!_hasDecorators(element)) return newElements.push(element); var elementFinishersExtras = this.decorateElement(element, placements); newElements.push(elementFinishersExtras.element); newElements.push.apply(newElements, elementFinishersExtras.extras); finishers.push.apply(finishers, elementFinishersExtras.finishers); }, this); if (!decorators) { return { elements: newElements, finishers: finishers }; } var result = this.decorateConstructor(newElements, decorators); finishers.push.apply(finishers, result.finishers); result.finishers = finishers; return result; }, addElementPlacement: function (element, placements, silent) { var keys = placements[element.placement]; if (!silent && keys.indexOf(element.key) !== -1) { throw new TypeError("Duplicated element (" + element.key + ")"); } keys.push(element.key); }, decorateElement: function (element, placements) { var extras = []; var finishers = []; for (var decorators = element.decorators, i = decorators.length - 1; i >= 0; i--) { var keys = placements[element.placement]; keys.splice(keys.indexOf(element.key), 1); var elementObject = this.fromElementDescriptor(element); var elementFinisherExtras = this.toElementFinisherExtras((0, decorators[i])(elementObject) || elementObject); element = elementFinisherExtras.element; this.addElementPlacement(element, placements); if (elementFinisherExtras.finisher) { finishers.push(elementFinisherExtras.finisher); } var newExtras = elementFinisherExtras.extras; if (newExtras) { for (var j = 0; j < newExtras.length; j++) { this.addElementPlacement(newExtras[j], placements); } extras.push.apply(extras, newExtras); } } return { element: element, finishers: finishers, extras: extras }; }, decorateConstructor: function (elements, decorators) { var finishers = []; for (var i = decorators.length - 1; i >= 0; i--) { var obj = this.fromClassDescriptor(elements); var elementsAndFinisher = this.toClassDescriptor((0, decorators[i])(obj) || obj); if (elementsAndFinisher.finisher !== undefined) { finishers.push(elementsAndFinisher.finisher); } if (elementsAndFinisher.elements !== undefined) { elements = elementsAndFinisher.elements; for (var j = 0; j < elements.length - 1; j++) { for (var k = j + 1; k < elements.length; k++) { if (elements[j].key === elements[k].key && elements[j].placement === elements[k].placement) { throw new TypeError("Duplicated element (" + elements[j].key + ")"); } } } } } return { elements: elements, finishers: finishers }; }, fromElementDescriptor: function (element) { var obj = { kind: element.kind, key: element.key, placement: element.placement, descriptor: element.descriptor }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); if (element.kind === "field") obj.initializer = element.initializer; return obj; }, toElementDescriptors: function (elementObjects) { if (elementObjects === undefined) return; return _toArray(elementObjects).map(function (elementObject) { var element = this.toElementDescriptor(elementObject); this.disallowProperty(elementObject, "finisher", "An element descriptor"); this.disallowProperty(elementObject, "extras", "An element descriptor"); return element; }, this); }, toElementDescriptor: function (elementObject) { var kind = String(elementObject.kind); if (kind !== "method" && kind !== "field") { throw new TypeError('An element descriptor\'s .kind property must be either "method" or' + ' "field", but a decorator created an element descriptor with' + ' .kind "' + kind + '"'); } var key = _toPropertyKey(elementObject.key); var placement = String(elementObject.placement); if (placement !== "static" && placement !== "prototype" && placement !== "own") { throw new TypeError('An element descriptor\'s .placement property must be one of "static",' + ' "prototype" or "own", but a decorator created an element descriptor' + ' with .placement "' + placement + '"'); } var descriptor = elementObject.descriptor; this.disallowProperty(elementObject, "elements", "An element descriptor"); var element = { kind: kind, key: key, placement: placement, descriptor: Object.assign({}, descriptor) }; if (kind !== "field") { this.disallowProperty(elementObject, "initializer", "A method descriptor"); } else { this.disallowProperty(descriptor, "get", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "set", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "value", "The property descriptor of a field descriptor"); element.initializer = elementObject.initializer; } return element; }, toElementFinisherExtras: function (elementObject) { var element = this.toElementDescriptor(elementObject); var finisher = _optionalCallableProperty(elementObject, "finisher"); var extras = this.toElementDescriptors(elementObject.extras); return { element: element, finisher: finisher, extras: extras }; }, fromClassDescriptor: function (elements) { var obj = { kind: "class", elements: elements.map(this.fromElementDescriptor, this) }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); return obj; }, toClassDescriptor: function (obj) { var kind = String(obj.kind); if (kind !== "class") { throw new TypeError('A class descriptor\'s .kind property must be "class", but a decorator' + ' created a class descriptor with .kind "' + kind + '"'); } this.disallowProperty(obj, "key", "A class descriptor"); this.disallowProperty(obj, "placement", "A class descriptor"); this.disallowProperty(obj, "descriptor", "A class descriptor"); this.disallowProperty(obj, "initializer", "A class descriptor"); this.disallowProperty(obj, "extras", "A class descriptor"); var finisher = _optionalCallableProperty(obj, "finisher"); var elements = this.toElementDescriptors(obj.elements); return { elements: elements, finisher: finisher }; }, runClassFinishers: function (constructor, finishers) { for (var i = 0; i < finishers.length; i++) { var newConstructor = (0, finishers[i])(constructor); if (newConstructor !== undefined) { if (typeof newConstructor !== "function") { throw new TypeError("Finishers must return a constructor."); } constructor = newConstructor; } } return constructor; }, disallowProperty: function (obj, name, objectType) { if (obj[name] !== undefined) { throw new TypeError(objectType + " can't have a ." + name + " property."); } } }; return api; }

function _createElementDescriptor(def) { var key = _toPropertyKey(def.key); var descriptor; if (def.kind === "method") { descriptor = { value: def.value, writable: true, configurable: true, enumerable: false }; } else if (def.kind === "get") { descriptor = { get: def.value, configurable: true, enumerable: false }; } else if (def.kind === "set") { descriptor = { set: def.value, configurable: true, enumerable: false }; } else if (def.kind === "field") { descriptor = { configurable: true, writable: true, enumerable: true }; } var element = { kind: def.kind === "field" ? "field" : "method", key: key, placement: def.static ? "static" : def.kind === "field" ? "own" : "prototype", descriptor: descriptor }; if (def.decorators) element.decorators = def.decorators; if (def.kind === "field") element.initializer = def.value; return element; }

function _coalesceGetterSetter(element, other) { if (element.descriptor.get !== undefined) { other.descriptor.get = element.descriptor.get; } else { other.descriptor.set = element.descriptor.set; } }

function _coalesceClassElements(elements) { var newElements = []; var isSameElement = function (other) { return other.kind === "method" && other.key === element.key && other.placement === element.placement; }; for (var i = 0; i < elements.length; i++) { var element = elements[i]; var other; if (element.kind === "method" && (other = newElements.find(isSameElement))) { if (_isDataDescriptor(element.descriptor) || _isDataDescriptor(other.descriptor)) { if (_hasDecorators(element) || _hasDecorators(other)) { throw new ReferenceError("Duplicated methods (" + element.key + ") can't be decorated."); } other.descriptor = element.descriptor; } else { if (_hasDecorators(element)) { if (_hasDecorators(other)) { throw new ReferenceError("Decorators can't be placed on different accessors with for " + "the same property (" + element.key + ")."); } other.decorators = element.decorators; } _coalesceGetterSetter(element, other); } } else { newElements.push(element); } } return newElements; }

function _hasDecorators(element) { return element.decorators && element.decorators.length; }

function _isDataDescriptor(desc) { return desc !== undefined && !(desc.value === undefined && desc.writable === undefined); }

function _optionalCallableProperty(obj, name) { var value = obj[name]; if (value !== undefined && typeof value !== "function") { throw new TypeError("Expected '" + name + "' to be a function"); } return value; }

function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }

function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }

function _toArray(arr) { return _arrayWithHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(n); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get; } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return _get(target, property, receiver || target); }

function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }







let HuiEntitiesToggle = _decorate([Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["customElement"])("hui-entities-toggle")], function (_initialize, _LitElement) {
  class HuiEntitiesToggle extends _LitElement {
    constructor(...args) {
      super(...args);

      _initialize(this);
    }

  }

  return {
    F: HuiEntitiesToggle,
    d: [{
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "entities",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "hass",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "_toggleEntities",
      value: void 0
    }, {
      kind: "method",
      key: "updated",
      value: function updated(changedProperties) {
        _get(_getPrototypeOf(HuiEntitiesToggle.prototype), "updated", this).call(this, changedProperties);

        if (changedProperties.has("entities")) {
          this._toggleEntities = this.entities.filter(entityId => entityId in this.hass.states && _common_const__WEBPACK_IMPORTED_MODULE_1__["DOMAINS_TOGGLE"].has(entityId.split(".", 1)[0]));
        }
      }
    }, {
      kind: "method",
      key: "render",
      value: function render() {
        if (!this._toggleEntities) {
          return lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]``;
        }

        return lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
      <ha-switch
        aria-label=${this.hass.localize("ui.panel.lovelace.card.entities.toggle")}
        .checked="${this._toggleEntities.some(entityId => {
          const stateObj = this.hass.states[entityId];
          return stateObj && stateObj.state === "on";
        })}"
        @change="${this._callService}"
      ></ha-switch>
    `;
      }
    }, {
      kind: "get",
      static: true,
      key: "styles",
      value: function styles() {
        return lit_element__WEBPACK_IMPORTED_MODULE_0__["css"]`
      :host {
        width: 38px;
        display: block;
      }
      ha-switch {
        padding: 13px 5px;
        margin: -4px -5px;
      }
    `;
      }
    }, {
      kind: "method",
      key: "_callService",
      value: function _callService(ev) {
        Object(_data_haptics__WEBPACK_IMPORTED_MODULE_3__["forwardHaptic"])("light");
        const turnOn = ev.target.checked;
        Object(_common_entity_turn_on_off_entities__WEBPACK_IMPORTED_MODULE_4__["turnOnOffEntities"])(this.hass, this._toggleEntities, turnOn);
      }
    }]
  };
}, lit_element__WEBPACK_IMPORTED_MODULE_0__["LitElement"]);

/***/ }),

/***/ "./src/panels/lovelace/components/hui-warning-element.ts":
/*!***************************************************************!*\
  !*** ./src/panels/lovelace/components/hui-warning-element.ts ***!
  \***************************************************************/
/*! exports provided: HuiWarningElement */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HuiWarningElement", function() { return HuiWarningElement; });
/* harmony import */ var lit_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lit-element */ "./node_modules/lit-element/lit-element.js");
/* harmony import */ var _components_ha_icon__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../components/ha-icon */ "./src/components/ha-icon.ts");
function _decorate(decorators, factory, superClass, mixins) { var api = _getDecoratorsApi(); if (mixins) { for (var i = 0; i < mixins.length; i++) { api = mixins[i](api); } } var r = factory(function initialize(O) { api.initializeInstanceElements(O, decorated.elements); }, superClass); var decorated = api.decorateClass(_coalesceClassElements(r.d.map(_createElementDescriptor)), decorators); api.initializeClassElements(r.F, decorated.elements); return api.runClassFinishers(r.F, decorated.finishers); }

function _getDecoratorsApi() { _getDecoratorsApi = function () { return api; }; var api = { elementsDefinitionOrder: [["method"], ["field"]], initializeInstanceElements: function (O, elements) { ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { if (element.kind === kind && element.placement === "own") { this.defineClassElement(O, element); } }, this); }, this); }, initializeClassElements: function (F, elements) { var proto = F.prototype; ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { var placement = element.placement; if (element.kind === kind && (placement === "static" || placement === "prototype")) { var receiver = placement === "static" ? F : proto; this.defineClassElement(receiver, element); } }, this); }, this); }, defineClassElement: function (receiver, element) { var descriptor = element.descriptor; if (element.kind === "field") { var initializer = element.initializer; descriptor = { enumerable: descriptor.enumerable, writable: descriptor.writable, configurable: descriptor.configurable, value: initializer === void 0 ? void 0 : initializer.call(receiver) }; } Object.defineProperty(receiver, element.key, descriptor); }, decorateClass: function (elements, decorators) { var newElements = []; var finishers = []; var placements = { static: [], prototype: [], own: [] }; elements.forEach(function (element) { this.addElementPlacement(element, placements); }, this); elements.forEach(function (element) { if (!_hasDecorators(element)) return newElements.push(element); var elementFinishersExtras = this.decorateElement(element, placements); newElements.push(elementFinishersExtras.element); newElements.push.apply(newElements, elementFinishersExtras.extras); finishers.push.apply(finishers, elementFinishersExtras.finishers); }, this); if (!decorators) { return { elements: newElements, finishers: finishers }; } var result = this.decorateConstructor(newElements, decorators); finishers.push.apply(finishers, result.finishers); result.finishers = finishers; return result; }, addElementPlacement: function (element, placements, silent) { var keys = placements[element.placement]; if (!silent && keys.indexOf(element.key) !== -1) { throw new TypeError("Duplicated element (" + element.key + ")"); } keys.push(element.key); }, decorateElement: function (element, placements) { var extras = []; var finishers = []; for (var decorators = element.decorators, i = decorators.length - 1; i >= 0; i--) { var keys = placements[element.placement]; keys.splice(keys.indexOf(element.key), 1); var elementObject = this.fromElementDescriptor(element); var elementFinisherExtras = this.toElementFinisherExtras((0, decorators[i])(elementObject) || elementObject); element = elementFinisherExtras.element; this.addElementPlacement(element, placements); if (elementFinisherExtras.finisher) { finishers.push(elementFinisherExtras.finisher); } var newExtras = elementFinisherExtras.extras; if (newExtras) { for (var j = 0; j < newExtras.length; j++) { this.addElementPlacement(newExtras[j], placements); } extras.push.apply(extras, newExtras); } } return { element: element, finishers: finishers, extras: extras }; }, decorateConstructor: function (elements, decorators) { var finishers = []; for (var i = decorators.length - 1; i >= 0; i--) { var obj = this.fromClassDescriptor(elements); var elementsAndFinisher = this.toClassDescriptor((0, decorators[i])(obj) || obj); if (elementsAndFinisher.finisher !== undefined) { finishers.push(elementsAndFinisher.finisher); } if (elementsAndFinisher.elements !== undefined) { elements = elementsAndFinisher.elements; for (var j = 0; j < elements.length - 1; j++) { for (var k = j + 1; k < elements.length; k++) { if (elements[j].key === elements[k].key && elements[j].placement === elements[k].placement) { throw new TypeError("Duplicated element (" + elements[j].key + ")"); } } } } } return { elements: elements, finishers: finishers }; }, fromElementDescriptor: function (element) { var obj = { kind: element.kind, key: element.key, placement: element.placement, descriptor: element.descriptor }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); if (element.kind === "field") obj.initializer = element.initializer; return obj; }, toElementDescriptors: function (elementObjects) { if (elementObjects === undefined) return; return _toArray(elementObjects).map(function (elementObject) { var element = this.toElementDescriptor(elementObject); this.disallowProperty(elementObject, "finisher", "An element descriptor"); this.disallowProperty(elementObject, "extras", "An element descriptor"); return element; }, this); }, toElementDescriptor: function (elementObject) { var kind = String(elementObject.kind); if (kind !== "method" && kind !== "field") { throw new TypeError('An element descriptor\'s .kind property must be either "method" or' + ' "field", but a decorator created an element descriptor with' + ' .kind "' + kind + '"'); } var key = _toPropertyKey(elementObject.key); var placement = String(elementObject.placement); if (placement !== "static" && placement !== "prototype" && placement !== "own") { throw new TypeError('An element descriptor\'s .placement property must be one of "static",' + ' "prototype" or "own", but a decorator created an element descriptor' + ' with .placement "' + placement + '"'); } var descriptor = elementObject.descriptor; this.disallowProperty(elementObject, "elements", "An element descriptor"); var element = { kind: kind, key: key, placement: placement, descriptor: Object.assign({}, descriptor) }; if (kind !== "field") { this.disallowProperty(elementObject, "initializer", "A method descriptor"); } else { this.disallowProperty(descriptor, "get", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "set", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "value", "The property descriptor of a field descriptor"); element.initializer = elementObject.initializer; } return element; }, toElementFinisherExtras: function (elementObject) { var element = this.toElementDescriptor(elementObject); var finisher = _optionalCallableProperty(elementObject, "finisher"); var extras = this.toElementDescriptors(elementObject.extras); return { element: element, finisher: finisher, extras: extras }; }, fromClassDescriptor: function (elements) { var obj = { kind: "class", elements: elements.map(this.fromElementDescriptor, this) }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); return obj; }, toClassDescriptor: function (obj) { var kind = String(obj.kind); if (kind !== "class") { throw new TypeError('A class descriptor\'s .kind property must be "class", but a decorator' + ' created a class descriptor with .kind "' + kind + '"'); } this.disallowProperty(obj, "key", "A class descriptor"); this.disallowProperty(obj, "placement", "A class descriptor"); this.disallowProperty(obj, "descriptor", "A class descriptor"); this.disallowProperty(obj, "initializer", "A class descriptor"); this.disallowProperty(obj, "extras", "A class descriptor"); var finisher = _optionalCallableProperty(obj, "finisher"); var elements = this.toElementDescriptors(obj.elements); return { elements: elements, finisher: finisher }; }, runClassFinishers: function (constructor, finishers) { for (var i = 0; i < finishers.length; i++) { var newConstructor = (0, finishers[i])(constructor); if (newConstructor !== undefined) { if (typeof newConstructor !== "function") { throw new TypeError("Finishers must return a constructor."); } constructor = newConstructor; } } return constructor; }, disallowProperty: function (obj, name, objectType) { if (obj[name] !== undefined) { throw new TypeError(objectType + " can't have a ." + name + " property."); } } }; return api; }

function _createElementDescriptor(def) { var key = _toPropertyKey(def.key); var descriptor; if (def.kind === "method") { descriptor = { value: def.value, writable: true, configurable: true, enumerable: false }; } else if (def.kind === "get") { descriptor = { get: def.value, configurable: true, enumerable: false }; } else if (def.kind === "set") { descriptor = { set: def.value, configurable: true, enumerable: false }; } else if (def.kind === "field") { descriptor = { configurable: true, writable: true, enumerable: true }; } var element = { kind: def.kind === "field" ? "field" : "method", key: key, placement: def.static ? "static" : def.kind === "field" ? "own" : "prototype", descriptor: descriptor }; if (def.decorators) element.decorators = def.decorators; if (def.kind === "field") element.initializer = def.value; return element; }

function _coalesceGetterSetter(element, other) { if (element.descriptor.get !== undefined) { other.descriptor.get = element.descriptor.get; } else { other.descriptor.set = element.descriptor.set; } }

function _coalesceClassElements(elements) { var newElements = []; var isSameElement = function (other) { return other.kind === "method" && other.key === element.key && other.placement === element.placement; }; for (var i = 0; i < elements.length; i++) { var element = elements[i]; var other; if (element.kind === "method" && (other = newElements.find(isSameElement))) { if (_isDataDescriptor(element.descriptor) || _isDataDescriptor(other.descriptor)) { if (_hasDecorators(element) || _hasDecorators(other)) { throw new ReferenceError("Duplicated methods (" + element.key + ") can't be decorated."); } other.descriptor = element.descriptor; } else { if (_hasDecorators(element)) { if (_hasDecorators(other)) { throw new ReferenceError("Decorators can't be placed on different accessors with for " + "the same property (" + element.key + ")."); } other.decorators = element.decorators; } _coalesceGetterSetter(element, other); } } else { newElements.push(element); } } return newElements; }

function _hasDecorators(element) { return element.decorators && element.decorators.length; }

function _isDataDescriptor(desc) { return desc !== undefined && !(desc.value === undefined && desc.writable === undefined); }

function _optionalCallableProperty(obj, name) { var value = obj[name]; if (value !== undefined && typeof value !== "function") { throw new TypeError("Expected '" + name + "' to be a function"); } return value; }

function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }

function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }

function _toArray(arr) { return _arrayWithHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(n); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }



let HuiWarningElement = _decorate([Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["customElement"])("hui-warning-element")], function (_initialize, _LitElement) {
  class HuiWarningElement extends _LitElement {
    constructor(...args) {
      super(...args);

      _initialize(this);
    }

  }

  return {
    F: HuiWarningElement,
    d: [{
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "label",
      value: void 0
    }, {
      kind: "method",
      key: "render",
      value: function render() {
        return lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]` <ha-icon icon="hass:alert" .title="${this.label}"></ha-icon> `;
      }
    }, {
      kind: "get",
      static: true,
      key: "styles",
      value: function styles() {
        return lit_element__WEBPACK_IMPORTED_MODULE_0__["css"]`
      ha-icon {
        color: #fce588;
      }
    `;
      }
    }]
  };
}, lit_element__WEBPACK_IMPORTED_MODULE_0__["LitElement"]);

/***/ }),

/***/ "./src/panels/lovelace/create-element/create-card-element.ts":
/*!*******************************************************************!*\
  !*** ./src/panels/lovelace/create-element/create-card-element.ts ***!
  \*******************************************************************/
/*! exports provided: createCardElement, getCardElementClass */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "createCardElement", function() { return createCardElement; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getCardElementClass", function() { return getCardElementClass; });
/* harmony import */ var _cards_hui_button_card__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../cards/hui-button-card */ "./src/panels/lovelace/cards/hui-button-card.ts");
/* harmony import */ var _cards_hui_entities_card__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../cards/hui-entities-card */ "./src/panels/lovelace/cards/hui-entities-card.ts");
/* harmony import */ var _cards_hui_entity_button_card__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../cards/hui-entity-button-card */ "./src/panels/lovelace/cards/hui-entity-button-card.ts");
/* harmony import */ var _cards_hui_entity_card__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../cards/hui-entity-card */ "./src/panels/lovelace/cards/hui-entity-card.ts");
/* harmony import */ var _cards_hui_glance_card__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../cards/hui-glance-card */ "./src/panels/lovelace/cards/hui-glance-card.ts");
/* harmony import */ var _cards_hui_history_graph_card__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../cards/hui-history-graph-card */ "./src/panels/lovelace/cards/hui-history-graph-card.ts");
/* harmony import */ var _cards_hui_horizontal_stack_card__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../cards/hui-horizontal-stack-card */ "./src/panels/lovelace/cards/hui-horizontal-stack-card.ts");
/* harmony import */ var _cards_hui_light_card__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../cards/hui-light-card */ "./src/panels/lovelace/cards/hui-light-card.ts");
/* harmony import */ var _cards_hui_sensor_card__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../cards/hui-sensor-card */ "./src/panels/lovelace/cards/hui-sensor-card.ts");
/* harmony import */ var _cards_hui_thermostat_card__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../cards/hui-thermostat-card */ "./src/panels/lovelace/cards/hui-thermostat-card.ts");
/* harmony import */ var _cards_hui_vertical_stack_card__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../cards/hui-vertical-stack-card */ "./src/panels/lovelace/cards/hui-vertical-stack-card.ts");
/* harmony import */ var _cards_hui_weather_forecast_card__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../cards/hui-weather-forecast-card */ "./src/panels/lovelace/cards/hui-weather-forecast-card.ts");
/* harmony import */ var _create_element_base__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./create-element-base */ "./src/panels/lovelace/create-element/create-element-base.ts");













const ALWAYS_LOADED_TYPES = new Set(["entity", "entities", "button", "entity-button", "glance", "history-graph", "horizontal-stack", "light", "sensor", "thermostat", "vertical-stack", "weather-forecast"]);
const LAZY_LOAD_TYPES = {
  "alarm-panel": () => Promise.all(/*! import() */[__webpack_require__.e(26), __webpack_require__.e(62)]).then(__webpack_require__.bind(null, /*! ../cards/hui-alarm-panel-card */ "./src/panels/lovelace/cards/hui-alarm-panel-card.ts")),
  error: () => Promise.all(/*! import() */[__webpack_require__.e(17), __webpack_require__.e(34)]).then(__webpack_require__.bind(null, /*! ../cards/hui-error-card */ "./src/panels/lovelace/cards/hui-error-card.ts")),
  "empty-state": () => __webpack_require__.e(/*! import() */ 73).then(__webpack_require__.bind(null, /*! ../cards/hui-empty-state-card */ "./src/panels/lovelace/cards/hui-empty-state-card.ts")),
  "entity-filter": () => __webpack_require__.e(/*! import() */ 68).then(__webpack_require__.bind(null, /*! ../cards/hui-entity-filter-card */ "./src/panels/lovelace/cards/hui-entity-filter-card.ts")),
  "media-control": () => Promise.all(/*! import() */[__webpack_require__.e(27), __webpack_require__.e(35), __webpack_require__.e(53)]).then(__webpack_require__.bind(null, /*! ../cards/hui-media-control-card */ "./src/panels/lovelace/cards/hui-media-control-card.ts")),
  "picture-elements": () => Promise.all(/*! import() */[__webpack_require__.e(20), __webpack_require__.e(22), __webpack_require__.e(26), __webpack_require__.e(28), __webpack_require__.e(30), __webpack_require__.e(59)]).then(__webpack_require__.bind(null, /*! ../cards/hui-picture-elements-card */ "./src/panels/lovelace/cards/hui-picture-elements-card.ts")),
  "picture-entity": () => Promise.all(/*! import() */[__webpack_require__.e(20), __webpack_require__.e(22), __webpack_require__.e(76)]).then(__webpack_require__.bind(null, /*! ../cards/hui-picture-entity-card */ "./src/panels/lovelace/cards/hui-picture-entity-card.ts")),
  "picture-glance": () => Promise.all(/*! import() */[__webpack_require__.e(20), __webpack_require__.e(22), __webpack_require__.e(77)]).then(__webpack_require__.bind(null, /*! ../cards/hui-picture-glance-card */ "./src/panels/lovelace/cards/hui-picture-glance-card.ts")),
  "plant-status": () => __webpack_require__.e(/*! import() */ 78).then(__webpack_require__.bind(null, /*! ../cards/hui-plant-status-card */ "./src/panels/lovelace/cards/hui-plant-status-card.ts")),
  "safe-mode": () => Promise.all(/*! import() */[__webpack_require__.e(31), __webpack_require__.e(79)]).then(__webpack_require__.bind(null, /*! ../cards/hui-safe-mode-card */ "./src/panels/lovelace/cards/hui-safe-mode-card.ts")),
  "shopping-list": () => Promise.all(/*! import() */[__webpack_require__.e(15), __webpack_require__.e(71), __webpack_require__.e(65)]).then(__webpack_require__.bind(null, /*! ../cards/hui-shopping-list-card */ "./src/panels/lovelace/cards/hui-shopping-list-card.ts")),
  conditional: () => Promise.all(/*! import() */[__webpack_require__.e(33), __webpack_require__.e(72)]).then(__webpack_require__.bind(null, /*! ../cards/hui-conditional-card */ "./src/panels/lovelace/cards/hui-conditional-card.ts")),
  gauge: () => __webpack_require__.e(/*! import() */ 74).then(__webpack_require__.bind(null, /*! ../cards/hui-gauge-card */ "./src/panels/lovelace/cards/hui-gauge-card.ts")),
  iframe: () => __webpack_require__.e(/*! import() */ 61).then(__webpack_require__.bind(null, /*! ../cards/hui-iframe-card */ "./src/panels/lovelace/cards/hui-iframe-card.ts")),
  map: () => Promise.all(/*! import() */[__webpack_require__.e(23), __webpack_require__.e(47)]).then(__webpack_require__.bind(null, /*! ../cards/hui-map-card */ "./src/panels/lovelace/cards/hui-map-card.ts")),
  markdown: () => Promise.all(/*! import() */[__webpack_require__.e(21), __webpack_require__.e(55)]).then(__webpack_require__.bind(null, /*! ../cards/hui-markdown-card */ "./src/panels/lovelace/cards/hui-markdown-card.ts")),
  picture: () => __webpack_require__.e(/*! import() */ 75).then(__webpack_require__.bind(null, /*! ../cards/hui-picture-card */ "./src/panels/lovelace/cards/hui-picture-card.ts"))
};
const createCardElement = config => Object(_create_element_base__WEBPACK_IMPORTED_MODULE_12__["createLovelaceElement"])("card", config, ALWAYS_LOADED_TYPES, LAZY_LOAD_TYPES, undefined, undefined);
const getCardElementClass = type => Object(_create_element_base__WEBPACK_IMPORTED_MODULE_12__["getLovelaceElementClass"])(type, "card", ALWAYS_LOADED_TYPES, LAZY_LOAD_TYPES);

/***/ }),

/***/ "./src/panels/lovelace/create-element/create-header-footer-element.ts":
/*!****************************************************************************!*\
  !*** ./src/panels/lovelace/create-element/create-header-footer-element.ts ***!
  \****************************************************************************/
/*! exports provided: createHeaderFooterElement */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "createHeaderFooterElement", function() { return createHeaderFooterElement; });
/* harmony import */ var _create_element_base__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./create-element-base */ "./src/panels/lovelace/create-element/create-element-base.ts");

const LAZY_LOAD_TYPES = {
  picture: () => __webpack_require__.e(/*! import() */ 84).then(__webpack_require__.bind(null, /*! ../header-footer/hui-picture-header-footer */ "./src/panels/lovelace/header-footer/hui-picture-header-footer.ts")),
  buttons: () => Promise.all(/*! import() */[__webpack_require__.e(32), __webpack_require__.e(83)]).then(__webpack_require__.bind(null, /*! ../header-footer/hui-buttons-header-footer */ "./src/panels/lovelace/header-footer/hui-buttons-header-footer.ts")),
  graph: () => __webpack_require__.e(/*! import() */ 42).then(__webpack_require__.bind(null, /*! ../header-footer/hui-graph-header-footer */ "./src/panels/lovelace/header-footer/hui-graph-header-footer.ts"))
};
const createHeaderFooterElement = config => Object(_create_element_base__WEBPACK_IMPORTED_MODULE_0__["createLovelaceElement"])("header-footer", config, undefined, LAZY_LOAD_TYPES, undefined, undefined);

/***/ }),

/***/ "./src/panels/lovelace/editor/card-editor/show-edit-card-dialog.ts":
/*!*************************************************************************!*\
  !*** ./src/panels/lovelace/editor/card-editor/show-edit-card-dialog.ts ***!
  \*************************************************************************/
/*! exports provided: showEditCardDialog */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "showEditCardDialog", function() { return showEditCardDialog; });
/* harmony import */ var _common_dom_fire_event__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../common/dom/fire_event */ "./src/common/dom/fire_event.ts");


const importEditCardDialog = () => Promise.all(/*! import() | hui-dialog-edit-card */[__webpack_require__.e(1), __webpack_require__.e("vendors~cloud-webhook-manage-dialog~config-entry-system-options~confirmation~device-registry-detail-~836e8839"), __webpack_require__.e("vendors~hui-button-card-editor~hui-dialog-delete-card~hui-dialog-edit-card~hui-dialog-suggest-card~h~a8cf51a3"), __webpack_require__.e(17), __webpack_require__.e("vendors~dialog-config-flow~hui-conditional-card-editor~hui-dialog-edit-card~hui-stack-card-editor~pa~f9cbd3da"), __webpack_require__.e("vendors~hui-dialog-edit-card"), __webpack_require__.e("dialog-config-flow~hui-conditional-card-editor~hui-dialog-edit-card~hui-stack-card-editor~hui-unused~c9cf7b12"), __webpack_require__.e(18), __webpack_require__.e("hui-conditional-card-editor~hui-dialog-edit-card~hui-stack-card-editor"), __webpack_require__.e("hui-dialog-edit-card")]).then(__webpack_require__.bind(null, /*! ./hui-dialog-edit-card */ "./src/panels/lovelace/editor/card-editor/hui-dialog-edit-card.ts"));

const showEditCardDialog = (element, editCardDialogParams) => {
  Object(_common_dom_fire_event__WEBPACK_IMPORTED_MODULE_0__["fireEvent"])(element, "show-dialog", {
    dialogTag: "hui-dialog-edit-card",
    dialogImport: importEditCardDialog,
    dialogParams: editCardDialogParams
  });
};

/***/ }),

/***/ "./src/panels/lovelace/editor/config-util.ts":
/*!***************************************************!*\
  !*** ./src/panels/lovelace/editor/config-util.ts ***!
  \***************************************************/
/*! exports provided: addCard, addCards, replaceCard, deleteCard, insertCard, swapCard, moveCard, addView, replaceView, swapView, deleteView */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "addCard", function() { return addCard; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "addCards", function() { return addCards; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "replaceCard", function() { return replaceCard; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "deleteCard", function() { return deleteCard; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "insertCard", function() { return insertCard; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "swapCard", function() { return swapCard; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "moveCard", function() { return moveCard; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "addView", function() { return addView; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "replaceView", function() { return replaceView; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "swapView", function() { return swapView; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "deleteView", function() { return deleteView; });
const addCard = (config, path, cardConfig) => {
  const [viewIndex] = path;
  const views = [];
  config.views.forEach((viewConf, index) => {
    if (index !== viewIndex) {
      views.push(config.views[index]);
      return;
    }

    const cards = viewConf.cards ? [...viewConf.cards, cardConfig] : [cardConfig];
    views.push(Object.assign({}, viewConf, {
      cards
    }));
  });
  return Object.assign({}, config, {
    views
  });
};
const addCards = (config, path, cardConfigs) => {
  const [viewIndex] = path;
  const views = [];
  config.views.forEach((viewConf, index) => {
    if (index !== viewIndex) {
      views.push(config.views[index]);
      return;
    }

    const cards = viewConf.cards ? [...viewConf.cards, ...cardConfigs] : [...cardConfigs];
    views.push(Object.assign({}, viewConf, {
      cards
    }));
  });
  return Object.assign({}, config, {
    views
  });
};
const replaceCard = (config, path, cardConfig) => {
  const [viewIndex, cardIndex] = path;
  const views = [];
  config.views.forEach((viewConf, index) => {
    if (index !== viewIndex) {
      views.push(config.views[index]);
      return;
    }

    views.push(Object.assign({}, viewConf, {
      cards: (viewConf.cards || []).map((origConf, ind) => ind === cardIndex ? cardConfig : origConf)
    }));
  });
  return Object.assign({}, config, {
    views
  });
};
const deleteCard = (config, path) => {
  const [viewIndex, cardIndex] = path;
  const views = [];
  config.views.forEach((viewConf, index) => {
    if (index !== viewIndex) {
      views.push(config.views[index]);
      return;
    }

    views.push(Object.assign({}, viewConf, {
      cards: (viewConf.cards || []).filter((_origConf, ind) => ind !== cardIndex)
    }));
  });
  return Object.assign({}, config, {
    views
  });
};
const insertCard = (config, path, cardConfig) => {
  const [viewIndex, cardIndex] = path;
  const views = [];
  config.views.forEach((viewConf, index) => {
    if (index !== viewIndex) {
      views.push(config.views[index]);
      return;
    }

    const cards = viewConf.cards ? [...viewConf.cards.slice(0, cardIndex), cardConfig, ...viewConf.cards.slice(cardIndex)] : [cardConfig];
    views.push(Object.assign({}, viewConf, {
      cards
    }));
  });
  return Object.assign({}, config, {
    views
  });
};
const swapCard = (config, path1, path2) => {
  const card1 = config.views[path1[0]].cards[path1[1]];
  const card2 = config.views[path2[0]].cards[path2[1]];
  const origView1 = config.views[path1[0]];
  const newView1 = Object.assign({}, origView1, {
    cards: origView1.cards.map((origCard, index) => index === path1[1] ? card2 : origCard)
  });
  const origView2 = path1[0] === path2[0] ? newView1 : config.views[path2[0]];
  const newView2 = Object.assign({}, origView2, {
    cards: origView2.cards.map((origCard, index) => index === path2[1] ? card1 : origCard)
  });
  return Object.assign({}, config, {
    views: config.views.map((origView, index) => index === path2[0] ? newView2 : index === path1[0] ? newView1 : origView)
  });
};
const moveCard = (config, fromPath, toPath) => {
  if (fromPath[0] === toPath[0]) {
    throw new Error("You can not move a card to the view it is in.");
  }

  const fromView = config.views[fromPath[0]];
  const card = fromView.cards[fromPath[1]];
  const newView1 = Object.assign({}, fromView, {
    cards: (fromView.cards || []).filter((_origConf, ind) => ind !== fromPath[1])
  });
  const toView = config.views[toPath[0]];
  const cards = toView.cards ? [...toView.cards, card] : [card];
  const newView2 = Object.assign({}, toView, {
    cards
  });
  return Object.assign({}, config, {
    views: config.views.map((origView, index) => index === toPath[0] ? newView2 : index === fromPath[0] ? newView1 : origView)
  });
};
const addView = (config, viewConfig) => Object.assign({}, config, {
  views: config.views.concat(viewConfig)
});
const replaceView = (config, viewIndex, viewConfig) => Object.assign({}, config, {
  views: config.views.map((origView, index) => index === viewIndex ? viewConfig : origView)
});
const swapView = (config, path1, path2) => {
  const view1 = config.views[path1];
  const view2 = config.views[path2];
  return Object.assign({}, config, {
    views: config.views.map((origView, index) => index === path2 ? view1 : index === path1 ? view2 : origView)
  });
};
const deleteView = (config, viewIndex) => Object.assign({}, config, {
  views: config.views.filter((_origView, index) => index !== viewIndex)
});

/***/ }),

/***/ "./src/panels/lovelace/editor/process-editor-entities.ts":
/*!***************************************************************!*\
  !*** ./src/panels/lovelace/editor/process-editor-entities.ts ***!
  \***************************************************************/
/*! exports provided: processEditorEntities */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "processEditorEntities", function() { return processEditorEntities; });
function processEditorEntities(entities) {
  return entities.map(entityConf => {
    if (typeof entityConf === "string") {
      return {
        entity: entityConf
      };
    }

    return entityConf;
  });
}

/***/ })

}]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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