(self["webpackJsonp"] = self["webpackJsonp"] || []).push([["hui-dialog-suggest-card~panel-config-devices~panel-lovelace"],{

/***/ "./src/common/datetime/relative_time.ts":
/*!**********************************************!*\
  !*** ./src/common/datetime/relative_time.ts ***!
  \**********************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return relativeTime; });
/**
 * Calculate a string representing a date object as relative time from now.
 *
 * Example output: 5 minutes ago, in 3 days.
 */
const tests = [60, 60, 24, 7];
const langKey = ["second", "minute", "hour", "day"];
function relativeTime(dateObj, localize, options = {}) {
  const compareTime = options.compareTime || new Date();
  let delta = (compareTime.getTime() - dateObj.getTime()) / 1000;
  const tense = delta >= 0 ? "past" : "future";
  delta = Math.abs(delta);
  let timeDesc;

  for (let i = 0; i < tests.length; i++) {
    if (delta < tests[i]) {
      delta = Math.floor(delta);
      timeDesc = localize(`ui.components.relative_time.duration.${langKey[i]}`, "count", delta);
      break;
    }

    delta /= tests[i];
  }

  if (timeDesc === undefined) {
    delta = Math.floor(delta);
    timeDesc = localize("ui.components.relative_time.duration.week", "count", delta);
  }

  return options.includeTense === false ? timeDesc : localize(`ui.components.relative_time.${tense}`, "time", timeDesc);
}

/***/ }),

/***/ "./src/common/entity/supports-feature.ts":
/*!***********************************************!*\
  !*** ./src/common/entity/supports-feature.ts ***!
  \***********************************************/
/*! exports provided: supportsFeature */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "supportsFeature", function() { return supportsFeature; });
const supportsFeature = (stateObj, feature) => {
  // eslint-disable-next-line:no-bitwise
  return (stateObj.attributes.supported_features & feature) !== 0;
};

/***/ }),

/***/ "./src/common/entity/valid_entity_id.ts":
/*!**********************************************!*\
  !*** ./src/common/entity/valid_entity_id.ts ***!
  \**********************************************/
/*! exports provided: isValidEntityId, createValidEntityId */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isValidEntityId", function() { return isValidEntityId; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "createValidEntityId", function() { return createValidEntityId; });
const validEntityId = /^(\w+)\.(\w+)$/;
const isValidEntityId = entityId => validEntityId.test(entityId);
const createValidEntityId = input => input.toLowerCase().replace(/\s|'/g, "_") // replace spaces and quotes with underscore
.replace(/\W/g, "") // remove not allowed chars
.replace(/_{2,}/g, "_") // replace multiple underscores with 1
.replace(/_$/, ""); // remove underscores at the end

/***/ }),

/***/ "./src/components/ha-relative-time.js":
/*!********************************************!*\
  !*** ./src/components/ha-relative-time.js ***!
  \********************************************/
/*! no exports provided */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _polymer_polymer_lib_legacy_polymer_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @polymer/polymer/lib/legacy/polymer.dom */ "./node_modules/@polymer/polymer/lib/legacy/polymer.dom.js");
/* harmony import */ var _polymer_polymer_polymer_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @polymer/polymer/polymer-element */ "./node_modules/@polymer/polymer/polymer-element.js");
/* harmony import */ var _common_datetime_relative_time__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../common/datetime/relative_time */ "./src/common/datetime/relative_time.ts");
/* harmony import */ var _mixins_localize_mixin__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../mixins/localize-mixin */ "./src/mixins/localize-mixin.js");

/* eslint-plugin-disable lit */




/*
 * @appliesMixin LocalizeMixin
 */

class HaRelativeTime extends Object(_mixins_localize_mixin__WEBPACK_IMPORTED_MODULE_3__["default"])(_polymer_polymer_polymer_element__WEBPACK_IMPORTED_MODULE_1__["PolymerElement"]) {
  static get properties() {
    return {
      hass: Object,
      datetime: {
        type: String,
        observer: "datetimeChanged"
      },
      datetimeObj: {
        type: Object,
        observer: "datetimeObjChanged"
      },
      parsedDateTime: Object
    };
  }

  constructor() {
    super();
    this.updateRelative = this.updateRelative.bind(this);
  }

  connectedCallback() {
    super.connectedCallback(); // update every 60 seconds

    this.updateInterval = setInterval(this.updateRelative, 60000);
  }

  disconnectedCallback() {
    super.disconnectedCallback();
    clearInterval(this.updateInterval);
  }

  datetimeChanged(newVal) {
    this.parsedDateTime = newVal ? new Date(newVal) : null;
    this.updateRelative();
  }

  datetimeObjChanged(newVal) {
    this.parsedDateTime = newVal;
    this.updateRelative();
  }

  updateRelative() {
    const root = Object(_polymer_polymer_lib_legacy_polymer_dom__WEBPACK_IMPORTED_MODULE_0__["dom"])(this);

    if (!this.parsedDateTime) {
      root.innerHTML = this.localize("ui.components.relative_time.never");
    } else {
      root.innerHTML = Object(_common_datetime_relative_time__WEBPACK_IMPORTED_MODULE_2__["default"])(this.parsedDateTime, this.localize);
    }
  }

}

customElements.define("ha-relative-time", HaRelativeTime);

/***/ }),

/***/ "./src/components/ha-slider.js":
/*!*************************************!*\
  !*** ./src/components/ha-slider.js ***!
  \*************************************/
/*! no exports provided */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _polymer_paper_slider__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @polymer/paper-slider */ "./node_modules/@polymer/paper-slider/paper-slider.js");

const PaperSliderClass = customElements.get("paper-slider");
let subTemplate;

class HaSlider extends PaperSliderClass {
  static get template() {
    if (!subTemplate) {
      subTemplate = PaperSliderClass.template.cloneNode(true);
      const superStyle = subTemplate.content.querySelector("style"); // append style to add mirroring of pin in RTL

      superStyle.appendChild(document.createTextNode(`
          :host([dir="rtl"]) #sliderContainer.pin.expand > .slider-knob > .slider-knob-inner::after {
            -webkit-transform: scale(1) translate(0, -17px) scaleX(-1) !important;
            transform: scale(1) translate(0, -17px) scaleX(-1) !important;
            }
        `));
    }

    return subTemplate;
  }

  _calcStep(value) {
    if (!this.step) {
      return parseFloat(value);
    }

    const numSteps = Math.round((value - this.min) / this.step);
    const stepStr = this.step.toString();
    const stepPointAt = stepStr.indexOf(".");

    if (stepPointAt !== -1) {
      /**
       * For small values of this.step, if we calculate the step using
       * For non-integer values of this.step, if we calculate the step using
       * `Math.round(value / step) * step` we may hit a precision point issue
       * eg. 0.1 * 0.2 =  0.020000000000000004
       * http://docs.oracle.com/cd/E19957-01/806-3568/ncg_goldberg.html
       *
       * as a work around we can round with the decimal precision of `step`
       */
      const precision = 10 ** (stepStr.length - stepPointAt - 1);
      return Math.round((numSteps * this.step + this.min) * precision) / precision;
    }

    return numSteps * this.step + this.min;
  }

}

customElements.define("ha-slider", HaSlider);

/***/ }),

/***/ "./src/data/integration.ts":
/*!*********************************!*\
  !*** ./src/data/integration.ts ***!
  \*********************************/
/*! exports provided: integrationIssuesUrl, domainToName, fetchIntegrationManifests, fetchIntegrationManifest */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "integrationIssuesUrl", function() { return integrationIssuesUrl; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "domainToName", function() { return domainToName; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "fetchIntegrationManifests", function() { return fetchIntegrationManifests; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "fetchIntegrationManifest", function() { return fetchIntegrationManifest; });
const integrationIssuesUrl = domain => `https://github.com/home-assistant/home-assistant/issues?q=is%3Aissue+is%3Aopen+label%3A%22integration%3A+${domain}%22`;
const domainToName = (localize, domain) => localize(`component.${domain}.title`) || domain;
const fetchIntegrationManifests = hass => hass.callWS({
  type: "manifest/list"
});
const fetchIntegrationManifest = (hass, integration) => hass.callWS({
  type: "manifest/get",
  integration
});

/***/ }),

/***/ "./src/data/lovelace_custom_cards.ts":
/*!*******************************************!*\
  !*** ./src/data/lovelace_custom_cards.ts ***!
  \*******************************************/
/*! exports provided: CUSTOM_TYPE_PREFIX, customCards, getCustomCardEntry */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CUSTOM_TYPE_PREFIX", function() { return CUSTOM_TYPE_PREFIX; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "customCards", function() { return customCards; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getCustomCardEntry", function() { return getCustomCardEntry; });
const CUSTOM_TYPE_PREFIX = "custom:";
const customCardsWindow = window;

if (!("customCards" in customCardsWindow)) {
  customCardsWindow.customCards = [];
}

const customCards = customCardsWindow.customCards;
const getCustomCardEntry = type => customCards.find(card => card.type === type);

/***/ }),

/***/ "./src/data/media-player.ts":
/*!**********************************!*\
  !*** ./src/data/media-player.ts ***!
  \**********************************/
/*! exports provided: SUPPORT_PAUSE, SUPPORT_SEEK, SUPPORT_VOLUME_SET, SUPPORT_VOLUME_MUTE, SUPPORT_PREVIOUS_TRACK, SUPPORT_NEXT_TRACK, SUPPORT_TURN_ON, SUPPORT_TURN_OFF, SUPPORT_PLAY_MEDIA, SUPPORT_VOLUME_BUTTONS, SUPPORT_SELECT_SOURCE, SUPPORT_STOP, SUPPORTS_PLAY, SUPPORT_SELECT_SOUND_MODE, CONTRAST_RATIO, getCurrentProgress, computeMediaDescription */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SUPPORT_PAUSE", function() { return SUPPORT_PAUSE; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SUPPORT_SEEK", function() { return SUPPORT_SEEK; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SUPPORT_VOLUME_SET", function() { return SUPPORT_VOLUME_SET; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SUPPORT_VOLUME_MUTE", function() { return SUPPORT_VOLUME_MUTE; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SUPPORT_PREVIOUS_TRACK", function() { return SUPPORT_PREVIOUS_TRACK; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SUPPORT_NEXT_TRACK", function() { return SUPPORT_NEXT_TRACK; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SUPPORT_TURN_ON", function() { return SUPPORT_TURN_ON; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SUPPORT_TURN_OFF", function() { return SUPPORT_TURN_OFF; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SUPPORT_PLAY_MEDIA", function() { return SUPPORT_PLAY_MEDIA; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SUPPORT_VOLUME_BUTTONS", function() { return SUPPORT_VOLUME_BUTTONS; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SUPPORT_SELECT_SOURCE", function() { return SUPPORT_SELECT_SOURCE; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SUPPORT_STOP", function() { return SUPPORT_STOP; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SUPPORTS_PLAY", function() { return SUPPORTS_PLAY; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SUPPORT_SELECT_SOUND_MODE", function() { return SUPPORT_SELECT_SOUND_MODE; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CONTRAST_RATIO", function() { return CONTRAST_RATIO; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getCurrentProgress", function() { return getCurrentProgress; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "computeMediaDescription", function() { return computeMediaDescription; });
const SUPPORT_PAUSE = 1;
const SUPPORT_SEEK = 2;
const SUPPORT_VOLUME_SET = 4;
const SUPPORT_VOLUME_MUTE = 8;
const SUPPORT_PREVIOUS_TRACK = 16;
const SUPPORT_NEXT_TRACK = 32;
const SUPPORT_TURN_ON = 128;
const SUPPORT_TURN_OFF = 256;
const SUPPORT_PLAY_MEDIA = 512;
const SUPPORT_VOLUME_BUTTONS = 1024;
const SUPPORT_SELECT_SOURCE = 2048;
const SUPPORT_STOP = 4096;
const SUPPORTS_PLAY = 16384;
const SUPPORT_SELECT_SOUND_MODE = 65536;
const CONTRAST_RATIO = 4.5;
const getCurrentProgress = stateObj => {
  let progress = stateObj.attributes.media_position;

  if (stateObj.state !== "playing") {
    return progress;
  }

  progress += (Date.now() - new Date(stateObj.attributes.media_position_updated_at).getTime()) / 1000.0;
  return progress;
};
const computeMediaDescription = stateObj => {
  let secondaryTitle;

  switch (stateObj.attributes.media_content_type) {
    case "music":
      secondaryTitle = stateObj.attributes.media_artist;
      break;

    case "playlist":
      secondaryTitle = stateObj.attributes.media_playlist;
      break;

    case "tvshow":
      secondaryTitle = stateObj.attributes.media_series_title;

      if (stateObj.attributes.media_season) {
        secondaryTitle += " S" + stateObj.attributes.media_season;

        if (stateObj.attributes.media_episode) {
          secondaryTitle += "E" + stateObj.attributes.media_episode;
        }
      }

      break;

    default:
      secondaryTitle = stateObj.attributes.app_name || "";
  }

  return secondaryTitle;
};

/***/ }),

/***/ "./src/data/scene.ts":
/*!***************************!*\
  !*** ./src/data/scene.ts ***!
  \***************************/
/*! exports provided: SCENE_IGNORED_DOMAINS, showSceneEditor, getSceneEditorInitData, activateScene, applyScene, getSceneConfig, saveScene, deleteScene */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SCENE_IGNORED_DOMAINS", function() { return SCENE_IGNORED_DOMAINS; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "showSceneEditor", function() { return showSceneEditor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getSceneEditorInitData", function() { return getSceneEditorInitData; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "activateScene", function() { return activateScene; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "applyScene", function() { return applyScene; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getSceneConfig", function() { return getSceneConfig; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "saveScene", function() { return saveScene; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "deleteScene", function() { return deleteScene; });
/* harmony import */ var _common_navigate__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../common/navigate */ "./src/common/navigate.ts");

const SCENE_IGNORED_DOMAINS = ["sensor", "binary_sensor", "device_tracker", "person", "persistent_notification", "configuration", "image_processing", "sun", "weather", "zone"];
let inititialSceneEditorData;
const showSceneEditor = (el, data) => {
  inititialSceneEditorData = data;
  Object(_common_navigate__WEBPACK_IMPORTED_MODULE_0__["navigate"])(el, "/config/scene/edit/new");
};
const getSceneEditorInitData = () => {
  const data = inititialSceneEditorData;
  inititialSceneEditorData = undefined;
  return data;
};
const activateScene = (hass, entityId) => hass.callService("scene", "turn_on", {
  entity_id: entityId
});
const applyScene = (hass, entities) => hass.callService("scene", "apply", {
  entities
});
const getSceneConfig = (hass, sceneId) => hass.callApi("GET", `config/scene/config/${sceneId}`);
const saveScene = (hass, sceneId, config) => hass.callApi("POST", `config/scene/config/${sceneId}`, config);
const deleteScene = (hass, id) => hass.callApi("DELETE", `config/scene/config/${id}`);

/***/ }),

/***/ "./src/data/sensor.ts":
/*!****************************!*\
  !*** ./src/data/sensor.ts ***!
  \****************************/
/*! exports provided: SENSOR_DEVICE_CLASS_BATTERY, SENSOR_DEVICE_CLASS_TIMESTAMP */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SENSOR_DEVICE_CLASS_BATTERY", function() { return SENSOR_DEVICE_CLASS_BATTERY; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SENSOR_DEVICE_CLASS_TIMESTAMP", function() { return SENSOR_DEVICE_CLASS_TIMESTAMP; });
const SENSOR_DEVICE_CLASS_BATTERY = "battery";
const SENSOR_DEVICE_CLASS_TIMESTAMP = "timestamp";

/***/ }),

/***/ "./src/panels/lovelace/common/directives/action-handler-directive.ts":
/*!***************************************************************************!*\
  !*** ./src/panels/lovelace/common/directives/action-handler-directive.ts ***!
  \***************************************************************************/
/*! exports provided: actionHandlerBind, actionHandler */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "actionHandlerBind", function() { return actionHandlerBind; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "actionHandler", function() { return actionHandler; });
/* harmony import */ var _material_mwc_ripple__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @material/mwc-ripple */ "./node_modules/@material/mwc-ripple/mwc-ripple.js");
/* harmony import */ var lit_html__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lit-html */ "./node_modules/lit-html/lit-html.js");
/* harmony import */ var _common_dom_fire_event__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../common/dom/fire_event */ "./src/common/dom/fire_event.ts");
function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }




const isTouch = "ontouchstart" in window || navigator.maxTouchPoints > 0 || navigator.msMaxTouchPoints > 0;

class ActionHandler extends HTMLElement {
  constructor() {
    super();

    _defineProperty(this, "holdTime", 500);

    _defineProperty(this, "ripple", void 0);

    _defineProperty(this, "timer", void 0);

    _defineProperty(this, "held", false);

    _defineProperty(this, "dblClickTimeout", void 0);

    this.ripple = document.createElement("mwc-ripple");
  }

  connectedCallback() {
    Object.assign(this.style, {
      position: "absolute",
      width: isTouch ? "100px" : "50px",
      height: isTouch ? "100px" : "50px",
      transform: "translate(-50%, -50%)",
      pointerEvents: "none",
      zIndex: "999"
    });
    this.appendChild(this.ripple);
    this.ripple.primary = true;
    ["touchcancel", "mouseout", "mouseup", "touchmove", "mousewheel", "wheel", "scroll"].forEach(ev => {
      document.addEventListener(ev, () => {
        clearTimeout(this.timer);
        this.stopAnimation();
        this.timer = undefined;
      }, {
        passive: true
      });
    });
  }

  bind(element, options) {
    if (element.actionHandler) {
      return;
    }

    element.actionHandler = true;
    element.addEventListener("contextmenu", ev => {
      const e = ev || window.event;

      if (e.preventDefault) {
        e.preventDefault();
      }

      if (e.stopPropagation) {
        e.stopPropagation();
      }

      e.cancelBubble = true;
      e.returnValue = false;
      return false;
    });

    const start = ev => {
      this.held = false;
      let x;
      let y;

      if (ev.touches) {
        x = ev.touches[0].pageX;
        y = ev.touches[0].pageY;
      } else {
        x = ev.pageX;
        y = ev.pageY;
      }

      this.timer = window.setTimeout(() => {
        this.startAnimation(x, y);
        this.held = true;
      }, this.holdTime);
    };

    const end = ev => {
      // Prevent mouse event if touch event
      ev.preventDefault();

      if (["touchend", "touchcancel"].includes(ev.type) && this.timer === undefined) {
        return;
      }

      clearTimeout(this.timer);
      this.stopAnimation();
      this.timer = undefined;

      if (this.held) {
        Object(_common_dom_fire_event__WEBPACK_IMPORTED_MODULE_2__["fireEvent"])(element, "action", {
          action: "hold"
        });
      } else if (options.hasDoubleClick) {
        if (ev.type === "click" && ev.detail < 2 || !this.dblClickTimeout) {
          this.dblClickTimeout = window.setTimeout(() => {
            this.dblClickTimeout = undefined;
            Object(_common_dom_fire_event__WEBPACK_IMPORTED_MODULE_2__["fireEvent"])(element, "action", {
              action: "tap"
            });
          }, 250);
        } else {
          clearTimeout(this.dblClickTimeout);
          this.dblClickTimeout = undefined;
          Object(_common_dom_fire_event__WEBPACK_IMPORTED_MODULE_2__["fireEvent"])(element, "action", {
            action: "double_tap"
          });
        }
      } else {
        Object(_common_dom_fire_event__WEBPACK_IMPORTED_MODULE_2__["fireEvent"])(element, "action", {
          action: "tap"
        });
      }
    };

    const handleEnter = ev => {
      if (ev.keyCode !== 13) {
        return;
      }

      end(ev);
    };

    element.addEventListener("touchstart", start, {
      passive: true
    });
    element.addEventListener("touchend", end);
    element.addEventListener("touchcancel", end);
    element.addEventListener("mousedown", start, {
      passive: true
    });
    element.addEventListener("click", end);
    element.addEventListener("keyup", handleEnter);
  }

  startAnimation(x, y) {
    Object.assign(this.style, {
      left: `${x}px`,
      top: `${y}px`,
      display: null
    });
    this.ripple.disabled = false;
    this.ripple.active = true;
    this.ripple.unbounded = true;
  }

  stopAnimation() {
    this.ripple.active = false;
    this.ripple.disabled = true;
    this.style.display = "none";
  }

}

customElements.define("action-handler", ActionHandler);

const getActionHandler = () => {
  const body = document.body;

  if (body.querySelector("action-handler")) {
    return body.querySelector("action-handler");
  }

  const actionhandler = document.createElement("action-handler");
  body.appendChild(actionhandler);
  return actionhandler;
};

const actionHandlerBind = (element, options) => {
  const actionhandler = getActionHandler();

  if (!actionhandler) {
    return;
  }

  actionhandler.bind(element, options);
};
const actionHandler = Object(lit_html__WEBPACK_IMPORTED_MODULE_1__["directive"])((options = {}) => part => {
  actionHandlerBind(part.committer.element, options);
});

/***/ }),

/***/ "./src/panels/lovelace/common/entity/toggle-entity.ts":
/*!************************************************************!*\
  !*** ./src/panels/lovelace/common/entity/toggle-entity.ts ***!
  \************************************************************/
/*! exports provided: toggleEntity */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "toggleEntity", function() { return toggleEntity; });
/* harmony import */ var _common_const__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../common/const */ "./src/common/const.ts");
/* harmony import */ var _turn_on_off_entity__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./turn-on-off-entity */ "./src/panels/lovelace/common/entity/turn-on-off-entity.ts");


const toggleEntity = (hass, entityId) => {
  const turnOn = _common_const__WEBPACK_IMPORTED_MODULE_0__["STATES_OFF"].includes(hass.states[entityId].state);
  return Object(_turn_on_off_entity__WEBPACK_IMPORTED_MODULE_1__["turnOnOffEntity"])(hass, entityId, turnOn);
};

/***/ }),

/***/ "./src/panels/lovelace/common/entity/turn-on-off-entity.ts":
/*!*****************************************************************!*\
  !*** ./src/panels/lovelace/common/entity/turn-on-off-entity.ts ***!
  \*****************************************************************/
/*! exports provided: turnOnOffEntity */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "turnOnOffEntity", function() { return turnOnOffEntity; });
/* harmony import */ var _common_entity_compute_domain__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../common/entity/compute_domain */ "./src/common/entity/compute_domain.ts");

const turnOnOffEntity = (hass, entityId, turnOn = true) => {
  const stateDomain = Object(_common_entity_compute_domain__WEBPACK_IMPORTED_MODULE_0__["computeDomain"])(entityId);
  const serviceDomain = stateDomain === "group" ? "homeassistant" : stateDomain;
  let service;

  switch (stateDomain) {
    case "lock":
      service = turnOn ? "unlock" : "lock";
      break;

    case "cover":
      service = turnOn ? "open_cover" : "close_cover";
      break;

    default:
      service = turnOn ? "turn_on" : "turn_off";
  }

  return hass.callService(serviceDomain, service, {
    entity_id: entityId
  });
};

/***/ }),

/***/ "./src/panels/lovelace/common/handle-action.ts":
/*!*****************************************************!*\
  !*** ./src/panels/lovelace/common/handle-action.ts ***!
  \*****************************************************/
/*! exports provided: handleAction */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "handleAction", function() { return handleAction; });
/* harmony import */ var _common_dom_fire_event__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../common/dom/fire_event */ "./src/common/dom/fire_event.ts");
/* harmony import */ var _common_navigate__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../common/navigate */ "./src/common/navigate.ts");
/* harmony import */ var _data_haptics__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../data/haptics */ "./src/data/haptics.ts");
/* harmony import */ var _entity_toggle_entity__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./entity/toggle-entity */ "./src/panels/lovelace/common/entity/toggle-entity.ts");




const handleAction = (node, hass, config, action) => {
  let actionConfig;

  if (action === "double_tap" && config.double_tap_action) {
    actionConfig = config.double_tap_action;
  } else if (action === "hold" && config.hold_action) {
    actionConfig = config.hold_action;
  } else if (action === "tap" && config.tap_action) {
    actionConfig = config.tap_action;
  }

  if (!actionConfig) {
    actionConfig = {
      action: "more-info"
    };
  }

  if (actionConfig.confirmation && (!actionConfig.confirmation.exemptions || !actionConfig.confirmation.exemptions.some(e => e.user === hass.user.id))) {
    Object(_data_haptics__WEBPACK_IMPORTED_MODULE_2__["forwardHaptic"])("warning");

    if (!confirm(actionConfig.confirmation.text || `Are you sure you want to ${actionConfig.action}?`)) {
      return;
    }
  }

  switch (actionConfig.action) {
    case "more-info":
      {
        if (config.entity || config.camera_image) {
          Object(_common_dom_fire_event__WEBPACK_IMPORTED_MODULE_0__["fireEvent"])(node, "hass-more-info", {
            entityId: config.entity ? config.entity : config.camera_image
          });
        }

        break;
      }

    case "navigate":
      if (actionConfig.navigation_path) {
        Object(_common_navigate__WEBPACK_IMPORTED_MODULE_1__["navigate"])(node, actionConfig.navigation_path);
      }

      break;

    case "url":
      {
        if (actionConfig.url_path) {
          window.open(actionConfig.url_path);
        }

        break;
      }

    case "toggle":
      {
        if (config.entity) {
          Object(_entity_toggle_entity__WEBPACK_IMPORTED_MODULE_3__["toggleEntity"])(hass, config.entity);
          Object(_data_haptics__WEBPACK_IMPORTED_MODULE_2__["forwardHaptic"])("light");
        }

        break;
      }

    case "call-service":
      {
        if (!actionConfig.service) {
          Object(_data_haptics__WEBPACK_IMPORTED_MODULE_2__["forwardHaptic"])("failure");
          return;
        }

        const [domain, service] = actionConfig.service.split(".", 2);
        hass.callService(domain, service, actionConfig.service_data);
        Object(_data_haptics__WEBPACK_IMPORTED_MODULE_2__["forwardHaptic"])("light");
        break;
      }

    case "fire-dom-event":
      {
        Object(_common_dom_fire_event__WEBPACK_IMPORTED_MODULE_0__["fireEvent"])(node, "ll-custom", actionConfig);
      }
  }
};

/***/ }),

/***/ "./src/panels/lovelace/common/has-action.ts":
/*!**************************************************!*\
  !*** ./src/panels/lovelace/common/has-action.ts ***!
  \**************************************************/
/*! exports provided: hasAction */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "hasAction", function() { return hasAction; });
function hasAction(config) {
  return config !== undefined && config.action !== "none";
}

/***/ }),

/***/ "./src/panels/lovelace/common/has-changed.ts":
/*!***************************************************!*\
  !*** ./src/panels/lovelace/common/has-changed.ts ***!
  \***************************************************/
/*! exports provided: hasConfigOrEntityChanged */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "hasConfigOrEntityChanged", function() { return hasConfigOrEntityChanged; });
// Check if config or Entity changed
function hasConfigOrEntityChanged(element, changedProps) {
  if (changedProps.has("_config")) {
    return true;
  }

  const oldHass = changedProps.get("hass");

  if (!oldHass) {
    return true;
  }

  if (oldHass.themes !== element.hass.themes || oldHass.language !== element.hass.language) {
    return true;
  }

  return oldHass.states[element._config.entity] !== element.hass.states[element._config.entity] || oldHass.localize !== element.hass.localize;
}

/***/ }),

/***/ "./src/panels/lovelace/components/hui-generic-entity-row.ts":
/*!******************************************************************!*\
  !*** ./src/panels/lovelace/components/hui-generic-entity-row.ts ***!
  \******************************************************************/
/*! no exports provided */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var lit_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lit-element */ "./node_modules/lit-element/lit-element.js");
/* harmony import */ var lit_html_directives_class_map__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lit-html/directives/class-map */ "./node_modules/lit-html/directives/class-map.js");
/* harmony import */ var lit_html_directives_if_defined__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! lit-html/directives/if-defined */ "./node_modules/lit-html/directives/if-defined.js");
/* harmony import */ var _common_const__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../common/const */ "./src/common/const.ts");
/* harmony import */ var _common_dom_toggle_attribute__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../common/dom/toggle_attribute */ "./src/common/dom/toggle_attribute.ts");
/* harmony import */ var _common_entity_compute_domain__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../common/entity/compute_domain */ "./src/common/entity/compute_domain.ts");
/* harmony import */ var _common_entity_compute_state_name__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../common/entity/compute_state_name */ "./src/common/entity/compute_state_name.ts");
/* harmony import */ var _common_util_compute_rtl__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../common/util/compute_rtl */ "./src/common/util/compute_rtl.ts");
/* harmony import */ var _components_entity_state_badge__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../../components/entity/state-badge */ "./src/components/entity/state-badge.ts");
/* harmony import */ var _components_ha_icon__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../../components/ha-icon */ "./src/components/ha-icon.ts");
/* harmony import */ var _components_ha_relative_time__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../../components/ha-relative-time */ "./src/components/ha-relative-time.js");
/* harmony import */ var _common_directives_action_handler_directive__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../common/directives/action-handler-directive */ "./src/panels/lovelace/common/directives/action-handler-directive.ts");
/* harmony import */ var _common_handle_action__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../common/handle-action */ "./src/panels/lovelace/common/handle-action.ts");
/* harmony import */ var _common_has_action__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../common/has-action */ "./src/panels/lovelace/common/has-action.ts");
/* harmony import */ var _hui_warning__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./hui-warning */ "./src/panels/lovelace/components/hui-warning.ts");
function _decorate(decorators, factory, superClass, mixins) { var api = _getDecoratorsApi(); if (mixins) { for (var i = 0; i < mixins.length; i++) { api = mixins[i](api); } } var r = factory(function initialize(O) { api.initializeInstanceElements(O, decorated.elements); }, superClass); var decorated = api.decorateClass(_coalesceClassElements(r.d.map(_createElementDescriptor)), decorators); api.initializeClassElements(r.F, decorated.elements); return api.runClassFinishers(r.F, decorated.finishers); }

function _getDecoratorsApi() { _getDecoratorsApi = function () { return api; }; var api = { elementsDefinitionOrder: [["method"], ["field"]], initializeInstanceElements: function (O, elements) { ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { if (element.kind === kind && element.placement === "own") { this.defineClassElement(O, element); } }, this); }, this); }, initializeClassElements: function (F, elements) { var proto = F.prototype; ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { var placement = element.placement; if (element.kind === kind && (placement === "static" || placement === "prototype")) { var receiver = placement === "static" ? F : proto; this.defineClassElement(receiver, element); } }, this); }, this); }, defineClassElement: function (receiver, element) { var descriptor = element.descriptor; if (element.kind === "field") { var initializer = element.initializer; descriptor = { enumerable: descriptor.enumerable, writable: descriptor.writable, configurable: descriptor.configurable, value: initializer === void 0 ? void 0 : initializer.call(receiver) }; } Object.defineProperty(receiver, element.key, descriptor); }, decorateClass: function (elements, decorators) { var newElements = []; var finishers = []; var placements = { static: [], prototype: [], own: [] }; elements.forEach(function (element) { this.addElementPlacement(element, placements); }, this); elements.forEach(function (element) { if (!_hasDecorators(element)) return newElements.push(element); var elementFinishersExtras = this.decorateElement(element, placements); newElements.push(elementFinishersExtras.element); newElements.push.apply(newElements, elementFinishersExtras.extras); finishers.push.apply(finishers, elementFinishersExtras.finishers); }, this); if (!decorators) { return { elements: newElements, finishers: finishers }; } var result = this.decorateConstructor(newElements, decorators); finishers.push.apply(finishers, result.finishers); result.finishers = finishers; return result; }, addElementPlacement: function (element, placements, silent) { var keys = placements[element.placement]; if (!silent && keys.indexOf(element.key) !== -1) { throw new TypeError("Duplicated element (" + element.key + ")"); } keys.push(element.key); }, decorateElement: function (element, placements) { var extras = []; var finishers = []; for (var decorators = element.decorators, i = decorators.length - 1; i >= 0; i--) { var keys = placements[element.placement]; keys.splice(keys.indexOf(element.key), 1); var elementObject = this.fromElementDescriptor(element); var elementFinisherExtras = this.toElementFinisherExtras((0, decorators[i])(elementObject) || elementObject); element = elementFinisherExtras.element; this.addElementPlacement(element, placements); if (elementFinisherExtras.finisher) { finishers.push(elementFinisherExtras.finisher); } var newExtras = elementFinisherExtras.extras; if (newExtras) { for (var j = 0; j < newExtras.length; j++) { this.addElementPlacement(newExtras[j], placements); } extras.push.apply(extras, newExtras); } } return { element: element, finishers: finishers, extras: extras }; }, decorateConstructor: function (elements, decorators) { var finishers = []; for (var i = decorators.length - 1; i >= 0; i--) { var obj = this.fromClassDescriptor(elements); var elementsAndFinisher = this.toClassDescriptor((0, decorators[i])(obj) || obj); if (elementsAndFinisher.finisher !== undefined) { finishers.push(elementsAndFinisher.finisher); } if (elementsAndFinisher.elements !== undefined) { elements = elementsAndFinisher.elements; for (var j = 0; j < elements.length - 1; j++) { for (var k = j + 1; k < elements.length; k++) { if (elements[j].key === elements[k].key && elements[j].placement === elements[k].placement) { throw new TypeError("Duplicated element (" + elements[j].key + ")"); } } } } } return { elements: elements, finishers: finishers }; }, fromElementDescriptor: function (element) { var obj = { kind: element.kind, key: element.key, placement: element.placement, descriptor: element.descriptor }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); if (element.kind === "field") obj.initializer = element.initializer; return obj; }, toElementDescriptors: function (elementObjects) { if (elementObjects === undefined) return; return _toArray(elementObjects).map(function (elementObject) { var element = this.toElementDescriptor(elementObject); this.disallowProperty(elementObject, "finisher", "An element descriptor"); this.disallowProperty(elementObject, "extras", "An element descriptor"); return element; }, this); }, toElementDescriptor: function (elementObject) { var kind = String(elementObject.kind); if (kind !== "method" && kind !== "field") { throw new TypeError('An element descriptor\'s .kind property must be either "method" or' + ' "field", but a decorator created an element descriptor with' + ' .kind "' + kind + '"'); } var key = _toPropertyKey(elementObject.key); var placement = String(elementObject.placement); if (placement !== "static" && placement !== "prototype" && placement !== "own") { throw new TypeError('An element descriptor\'s .placement property must be one of "static",' + ' "prototype" or "own", but a decorator created an element descriptor' + ' with .placement "' + placement + '"'); } var descriptor = elementObject.descriptor; this.disallowProperty(elementObject, "elements", "An element descriptor"); var element = { kind: kind, key: key, placement: placement, descriptor: Object.assign({}, descriptor) }; if (kind !== "field") { this.disallowProperty(elementObject, "initializer", "A method descriptor"); } else { this.disallowProperty(descriptor, "get", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "set", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "value", "The property descriptor of a field descriptor"); element.initializer = elementObject.initializer; } return element; }, toElementFinisherExtras: function (elementObject) { var element = this.toElementDescriptor(elementObject); var finisher = _optionalCallableProperty(elementObject, "finisher"); var extras = this.toElementDescriptors(elementObject.extras); return { element: element, finisher: finisher, extras: extras }; }, fromClassDescriptor: function (elements) { var obj = { kind: "class", elements: elements.map(this.fromElementDescriptor, this) }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); return obj; }, toClassDescriptor: function (obj) { var kind = String(obj.kind); if (kind !== "class") { throw new TypeError('A class descriptor\'s .kind property must be "class", but a decorator' + ' created a class descriptor with .kind "' + kind + '"'); } this.disallowProperty(obj, "key", "A class descriptor"); this.disallowProperty(obj, "placement", "A class descriptor"); this.disallowProperty(obj, "descriptor", "A class descriptor"); this.disallowProperty(obj, "initializer", "A class descriptor"); this.disallowProperty(obj, "extras", "A class descriptor"); var finisher = _optionalCallableProperty(obj, "finisher"); var elements = this.toElementDescriptors(obj.elements); return { elements: elements, finisher: finisher }; }, runClassFinishers: function (constructor, finishers) { for (var i = 0; i < finishers.length; i++) { var newConstructor = (0, finishers[i])(constructor); if (newConstructor !== undefined) { if (typeof newConstructor !== "function") { throw new TypeError("Finishers must return a constructor."); } constructor = newConstructor; } } return constructor; }, disallowProperty: function (obj, name, objectType) { if (obj[name] !== undefined) { throw new TypeError(objectType + " can't have a ." + name + " property."); } } }; return api; }

function _createElementDescriptor(def) { var key = _toPropertyKey(def.key); var descriptor; if (def.kind === "method") { descriptor = { value: def.value, writable: true, configurable: true, enumerable: false }; } else if (def.kind === "get") { descriptor = { get: def.value, configurable: true, enumerable: false }; } else if (def.kind === "set") { descriptor = { set: def.value, configurable: true, enumerable: false }; } else if (def.kind === "field") { descriptor = { configurable: true, writable: true, enumerable: true }; } var element = { kind: def.kind === "field" ? "field" : "method", key: key, placement: def.static ? "static" : def.kind === "field" ? "own" : "prototype", descriptor: descriptor }; if (def.decorators) element.decorators = def.decorators; if (def.kind === "field") element.initializer = def.value; return element; }

function _coalesceGetterSetter(element, other) { if (element.descriptor.get !== undefined) { other.descriptor.get = element.descriptor.get; } else { other.descriptor.set = element.descriptor.set; } }

function _coalesceClassElements(elements) { var newElements = []; var isSameElement = function (other) { return other.kind === "method" && other.key === element.key && other.placement === element.placement; }; for (var i = 0; i < elements.length; i++) { var element = elements[i]; var other; if (element.kind === "method" && (other = newElements.find(isSameElement))) { if (_isDataDescriptor(element.descriptor) || _isDataDescriptor(other.descriptor)) { if (_hasDecorators(element) || _hasDecorators(other)) { throw new ReferenceError("Duplicated methods (" + element.key + ") can't be decorated."); } other.descriptor = element.descriptor; } else { if (_hasDecorators(element)) { if (_hasDecorators(other)) { throw new ReferenceError("Decorators can't be placed on different accessors with for " + "the same property (" + element.key + ")."); } other.decorators = element.decorators; } _coalesceGetterSetter(element, other); } } else { newElements.push(element); } } return newElements; }

function _hasDecorators(element) { return element.decorators && element.decorators.length; }

function _isDataDescriptor(desc) { return desc !== undefined && !(desc.value === undefined && desc.writable === undefined); }

function _optionalCallableProperty(obj, name) { var value = obj[name]; if (value !== undefined && typeof value !== "function") { throw new TypeError("Expected '" + name + "' to be a function"); } return value; }

function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }

function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }

function _toArray(arr) { return _arrayWithHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(n); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get; } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return _get(target, property, receiver || target); }

function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

















let HuiGenericEntityRow = _decorate(null, function (_initialize, _LitElement) {
  class HuiGenericEntityRow extends _LitElement {
    constructor(...args) {
      super(...args);

      _initialize(this);
    }

  }

  return {
    F: HuiGenericEntityRow,
    d: [{
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "hass",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "config",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "secondaryText",
      value: void 0
    }, {
      kind: "method",
      key: "render",
      value: function render() {
        if (!this.hass || !this.config) {
          return lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]``;
        }

        const stateObj = this.config.entity ? this.hass.states[this.config.entity] : undefined;

        if (!stateObj) {
          return lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
        <hui-warning
          >${this.hass.localize("ui.panel.lovelace.warning.entity_not_found", "entity", this.config.entity)}</hui-warning
        >
      `;
        }

        const pointer = this.config.tap_action && this.config.tap_action.action !== "none" || this.config.entity && !_common_const__WEBPACK_IMPORTED_MODULE_3__["DOMAINS_HIDE_MORE_INFO"].includes(Object(_common_entity_compute_domain__WEBPACK_IMPORTED_MODULE_5__["computeDomain"])(this.config.entity));
        const hasSecondary = this.secondaryText || this.config.secondary_info;
        return lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
      <state-badge
        class=${Object(lit_html_directives_class_map__WEBPACK_IMPORTED_MODULE_1__["classMap"])({
          pointer
        })}
        .hass=${this.hass}
        .stateObj=${stateObj}
        .overrideIcon=${this.config.icon}
        .overrideImage=${this.config.image}
        .stateColor=${this.config.state_color}
        @action=${this._handleAction}
        .actionHandler=${Object(_common_directives_action_handler_directive__WEBPACK_IMPORTED_MODULE_11__["actionHandler"])({
          hasHold: Object(_common_has_action__WEBPACK_IMPORTED_MODULE_13__["hasAction"])(this.config.hold_action),
          hasDoubleClick: Object(_common_has_action__WEBPACK_IMPORTED_MODULE_13__["hasAction"])(this.config.double_tap_action)
        })}
        tabindex=${Object(lit_html_directives_if_defined__WEBPACK_IMPORTED_MODULE_2__["ifDefined"])(pointer ? "0" : undefined)}
      ></state-badge>
      <div
        class="info ${Object(lit_html_directives_class_map__WEBPACK_IMPORTED_MODULE_1__["classMap"])({
          pointer,
          "text-content": !hasSecondary
        })}"
        @action=${this._handleAction}
        .actionHandler=${Object(_common_directives_action_handler_directive__WEBPACK_IMPORTED_MODULE_11__["actionHandler"])({
          hasHold: Object(_common_has_action__WEBPACK_IMPORTED_MODULE_13__["hasAction"])(this.config.hold_action),
          hasDoubleClick: Object(_common_has_action__WEBPACK_IMPORTED_MODULE_13__["hasAction"])(this.config.double_tap_action)
        })}
      >
        ${this.config.name || Object(_common_entity_compute_state_name__WEBPACK_IMPORTED_MODULE_6__["computeStateName"])(stateObj)}
        ${hasSecondary ? lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
              <div class="secondary">
                ${this.secondaryText || (this.config.secondary_info === "entity-id" ? stateObj.entity_id : this.config.secondary_info === "last-changed" ? lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
                      <ha-relative-time
                        .hass=${this.hass}
                        .datetime=${stateObj.last_changed}
                      ></ha-relative-time>
                    ` : this.config.secondary_info === "last-triggered" ? stateObj.attributes.last_triggered ? lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
                        <ha-relative-time
                          .hass=${this.hass}
                          .datetime=${stateObj.attributes.last_triggered}
                        ></ha-relative-time>
                      ` : this.hass.localize("ui.panel.lovelace.cards.entities.never_triggered") : this.config.secondary_info === "position" && stateObj.attributes.current_position !== undefined ? `${this.hass.localize("ui.card.cover.position")}: ${stateObj.attributes.current_position}` : this.config.secondary_info === "tilt-position" && stateObj.attributes.current_tilt_position !== undefined ? `${this.hass.localize("ui.card.cover.tilt_position")}: ${stateObj.attributes.current_tilt_position}` : "")}
              </div>
            ` : ""}
      </div>
      <slot></slot>
    `;
      }
    }, {
      kind: "method",
      key: "updated",
      value: function updated(changedProps) {
        var _this$config;

        _get(_getPrototypeOf(HuiGenericEntityRow.prototype), "updated", this).call(this, changedProps);

        Object(_common_dom_toggle_attribute__WEBPACK_IMPORTED_MODULE_4__["toggleAttribute"])(this, "no-secondary", !this.secondaryText && !((_this$config = this.config) === null || _this$config === void 0 ? void 0 : _this$config.secondary_info));

        if (changedProps.has("hass")) {
          Object(_common_dom_toggle_attribute__WEBPACK_IMPORTED_MODULE_4__["toggleAttribute"])(this, "rtl", Object(_common_util_compute_rtl__WEBPACK_IMPORTED_MODULE_7__["computeRTL"])(this.hass));
        }
      }
    }, {
      kind: "method",
      key: "_handleAction",
      value: function _handleAction(ev) {
        Object(_common_handle_action__WEBPACK_IMPORTED_MODULE_12__["handleAction"])(this, this.hass, this.config, ev.detail.action);
      }
    }, {
      kind: "get",
      static: true,
      key: "styles",
      value: function styles() {
        return lit_element__WEBPACK_IMPORTED_MODULE_0__["css"]`
      :host {
        display: flex;
        align-items: center;
        flex-direction: row;
      }
      .info {
        margin-left: 16px;
        flex: 1 0 60px;
      }
      .info,
      .info > * {
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
      }
      .flex ::slotted(*) {
        margin-left: 8px;
        min-width: 0;
      }
      .flex ::slotted([slot="secondary"]) {
        margin-left: 0;
      }
      .secondary,
      ha-relative-time {
        display: block;
        color: var(--secondary-text-color);
      }
      state-badge {
        flex: 0 0 40px;
      }
      state-badge:focus {
        outline: none;
        background: var(--divider-color);
        border-radius: 100%;
      }
      :host([rtl]) .flex {
        margin-left: 0;
        margin-right: 16px;
      }
      :host([rtl]) .flex ::slotted(*) {
        margin-left: 0;
        margin-right: 8px;
      }
      .pointer {
        cursor: pointer;
      }
    `;
      }
    }]
  };
}, lit_element__WEBPACK_IMPORTED_MODULE_0__["LitElement"]);

customElements.define("hui-generic-entity-row", HuiGenericEntityRow);

/***/ }),

/***/ "./src/panels/lovelace/components/hui-timestamp-display.ts":
/*!*****************************************************************!*\
  !*** ./src/panels/lovelace/components/hui-timestamp-display.ts ***!
  \*****************************************************************/
/*! no exports provided */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var lit_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lit-element */ "./node_modules/lit-element/lit-element.js");
/* harmony import */ var _common_datetime_format_date__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../common/datetime/format_date */ "./src/common/datetime/format_date.ts");
/* harmony import */ var _common_datetime_format_date_time__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../common/datetime/format_date_time */ "./src/common/datetime/format_date_time.ts");
/* harmony import */ var _common_datetime_format_time__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../common/datetime/format_time */ "./src/common/datetime/format_time.ts");
/* harmony import */ var _common_datetime_relative_time__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../common/datetime/relative_time */ "./src/common/datetime/relative_time.ts");
function _decorate(decorators, factory, superClass, mixins) { var api = _getDecoratorsApi(); if (mixins) { for (var i = 0; i < mixins.length; i++) { api = mixins[i](api); } } var r = factory(function initialize(O) { api.initializeInstanceElements(O, decorated.elements); }, superClass); var decorated = api.decorateClass(_coalesceClassElements(r.d.map(_createElementDescriptor)), decorators); api.initializeClassElements(r.F, decorated.elements); return api.runClassFinishers(r.F, decorated.finishers); }

function _getDecoratorsApi() { _getDecoratorsApi = function () { return api; }; var api = { elementsDefinitionOrder: [["method"], ["field"]], initializeInstanceElements: function (O, elements) { ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { if (element.kind === kind && element.placement === "own") { this.defineClassElement(O, element); } }, this); }, this); }, initializeClassElements: function (F, elements) { var proto = F.prototype; ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { var placement = element.placement; if (element.kind === kind && (placement === "static" || placement === "prototype")) { var receiver = placement === "static" ? F : proto; this.defineClassElement(receiver, element); } }, this); }, this); }, defineClassElement: function (receiver, element) { var descriptor = element.descriptor; if (element.kind === "field") { var initializer = element.initializer; descriptor = { enumerable: descriptor.enumerable, writable: descriptor.writable, configurable: descriptor.configurable, value: initializer === void 0 ? void 0 : initializer.call(receiver) }; } Object.defineProperty(receiver, element.key, descriptor); }, decorateClass: function (elements, decorators) { var newElements = []; var finishers = []; var placements = { static: [], prototype: [], own: [] }; elements.forEach(function (element) { this.addElementPlacement(element, placements); }, this); elements.forEach(function (element) { if (!_hasDecorators(element)) return newElements.push(element); var elementFinishersExtras = this.decorateElement(element, placements); newElements.push(elementFinishersExtras.element); newElements.push.apply(newElements, elementFinishersExtras.extras); finishers.push.apply(finishers, elementFinishersExtras.finishers); }, this); if (!decorators) { return { elements: newElements, finishers: finishers }; } var result = this.decorateConstructor(newElements, decorators); finishers.push.apply(finishers, result.finishers); result.finishers = finishers; return result; }, addElementPlacement: function (element, placements, silent) { var keys = placements[element.placement]; if (!silent && keys.indexOf(element.key) !== -1) { throw new TypeError("Duplicated element (" + element.key + ")"); } keys.push(element.key); }, decorateElement: function (element, placements) { var extras = []; var finishers = []; for (var decorators = element.decorators, i = decorators.length - 1; i >= 0; i--) { var keys = placements[element.placement]; keys.splice(keys.indexOf(element.key), 1); var elementObject = this.fromElementDescriptor(element); var elementFinisherExtras = this.toElementFinisherExtras((0, decorators[i])(elementObject) || elementObject); element = elementFinisherExtras.element; this.addElementPlacement(element, placements); if (elementFinisherExtras.finisher) { finishers.push(elementFinisherExtras.finisher); } var newExtras = elementFinisherExtras.extras; if (newExtras) { for (var j = 0; j < newExtras.length; j++) { this.addElementPlacement(newExtras[j], placements); } extras.push.apply(extras, newExtras); } } return { element: element, finishers: finishers, extras: extras }; }, decorateConstructor: function (elements, decorators) { var finishers = []; for (var i = decorators.length - 1; i >= 0; i--) { var obj = this.fromClassDescriptor(elements); var elementsAndFinisher = this.toClassDescriptor((0, decorators[i])(obj) || obj); if (elementsAndFinisher.finisher !== undefined) { finishers.push(elementsAndFinisher.finisher); } if (elementsAndFinisher.elements !== undefined) { elements = elementsAndFinisher.elements; for (var j = 0; j < elements.length - 1; j++) { for (var k = j + 1; k < elements.length; k++) { if (elements[j].key === elements[k].key && elements[j].placement === elements[k].placement) { throw new TypeError("Duplicated element (" + elements[j].key + ")"); } } } } } return { elements: elements, finishers: finishers }; }, fromElementDescriptor: function (element) { var obj = { kind: element.kind, key: element.key, placement: element.placement, descriptor: element.descriptor }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); if (element.kind === "field") obj.initializer = element.initializer; return obj; }, toElementDescriptors: function (elementObjects) { if (elementObjects === undefined) return; return _toArray(elementObjects).map(function (elementObject) { var element = this.toElementDescriptor(elementObject); this.disallowProperty(elementObject, "finisher", "An element descriptor"); this.disallowProperty(elementObject, "extras", "An element descriptor"); return element; }, this); }, toElementDescriptor: function (elementObject) { var kind = String(elementObject.kind); if (kind !== "method" && kind !== "field") { throw new TypeError('An element descriptor\'s .kind property must be either "method" or' + ' "field", but a decorator created an element descriptor with' + ' .kind "' + kind + '"'); } var key = _toPropertyKey(elementObject.key); var placement = String(elementObject.placement); if (placement !== "static" && placement !== "prototype" && placement !== "own") { throw new TypeError('An element descriptor\'s .placement property must be one of "static",' + ' "prototype" or "own", but a decorator created an element descriptor' + ' with .placement "' + placement + '"'); } var descriptor = elementObject.descriptor; this.disallowProperty(elementObject, "elements", "An element descriptor"); var element = { kind: kind, key: key, placement: placement, descriptor: Object.assign({}, descriptor) }; if (kind !== "field") { this.disallowProperty(elementObject, "initializer", "A method descriptor"); } else { this.disallowProperty(descriptor, "get", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "set", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "value", "The property descriptor of a field descriptor"); element.initializer = elementObject.initializer; } return element; }, toElementFinisherExtras: function (elementObject) { var element = this.toElementDescriptor(elementObject); var finisher = _optionalCallableProperty(elementObject, "finisher"); var extras = this.toElementDescriptors(elementObject.extras); return { element: element, finisher: finisher, extras: extras }; }, fromClassDescriptor: function (elements) { var obj = { kind: "class", elements: elements.map(this.fromElementDescriptor, this) }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); return obj; }, toClassDescriptor: function (obj) { var kind = String(obj.kind); if (kind !== "class") { throw new TypeError('A class descriptor\'s .kind property must be "class", but a decorator' + ' created a class descriptor with .kind "' + kind + '"'); } this.disallowProperty(obj, "key", "A class descriptor"); this.disallowProperty(obj, "placement", "A class descriptor"); this.disallowProperty(obj, "descriptor", "A class descriptor"); this.disallowProperty(obj, "initializer", "A class descriptor"); this.disallowProperty(obj, "extras", "A class descriptor"); var finisher = _optionalCallableProperty(obj, "finisher"); var elements = this.toElementDescriptors(obj.elements); return { elements: elements, finisher: finisher }; }, runClassFinishers: function (constructor, finishers) { for (var i = 0; i < finishers.length; i++) { var newConstructor = (0, finishers[i])(constructor); if (newConstructor !== undefined) { if (typeof newConstructor !== "function") { throw new TypeError("Finishers must return a constructor."); } constructor = newConstructor; } } return constructor; }, disallowProperty: function (obj, name, objectType) { if (obj[name] !== undefined) { throw new TypeError(objectType + " can't have a ." + name + " property."); } } }; return api; }

function _createElementDescriptor(def) { var key = _toPropertyKey(def.key); var descriptor; if (def.kind === "method") { descriptor = { value: def.value, writable: true, configurable: true, enumerable: false }; } else if (def.kind === "get") { descriptor = { get: def.value, configurable: true, enumerable: false }; } else if (def.kind === "set") { descriptor = { set: def.value, configurable: true, enumerable: false }; } else if (def.kind === "field") { descriptor = { configurable: true, writable: true, enumerable: true }; } var element = { kind: def.kind === "field" ? "field" : "method", key: key, placement: def.static ? "static" : def.kind === "field" ? "own" : "prototype", descriptor: descriptor }; if (def.decorators) element.decorators = def.decorators; if (def.kind === "field") element.initializer = def.value; return element; }

function _coalesceGetterSetter(element, other) { if (element.descriptor.get !== undefined) { other.descriptor.get = element.descriptor.get; } else { other.descriptor.set = element.descriptor.set; } }

function _coalesceClassElements(elements) { var newElements = []; var isSameElement = function (other) { return other.kind === "method" && other.key === element.key && other.placement === element.placement; }; for (var i = 0; i < elements.length; i++) { var element = elements[i]; var other; if (element.kind === "method" && (other = newElements.find(isSameElement))) { if (_isDataDescriptor(element.descriptor) || _isDataDescriptor(other.descriptor)) { if (_hasDecorators(element) || _hasDecorators(other)) { throw new ReferenceError("Duplicated methods (" + element.key + ") can't be decorated."); } other.descriptor = element.descriptor; } else { if (_hasDecorators(element)) { if (_hasDecorators(other)) { throw new ReferenceError("Decorators can't be placed on different accessors with for " + "the same property (" + element.key + ")."); } other.decorators = element.decorators; } _coalesceGetterSetter(element, other); } } else { newElements.push(element); } } return newElements; }

function _hasDecorators(element) { return element.decorators && element.decorators.length; }

function _isDataDescriptor(desc) { return desc !== undefined && !(desc.value === undefined && desc.writable === undefined); }

function _optionalCallableProperty(obj, name) { var value = obj[name]; if (value !== undefined && typeof value !== "function") { throw new TypeError("Expected '" + name + "' to be a function"); } return value; }

function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }

function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }

function _toArray(arr) { return _arrayWithHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(n); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get; } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return _get(target, property, receiver || target); }

function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }






const FORMATS = {
  date: _common_datetime_format_date__WEBPACK_IMPORTED_MODULE_1__["formatDate"],
  datetime: _common_datetime_format_date_time__WEBPACK_IMPORTED_MODULE_2__["formatDateTime"],
  time: _common_datetime_format_time__WEBPACK_IMPORTED_MODULE_3__["formatTime"]
};
const INTERVAL_FORMAT = ["relative", "total"];

let HuiTimestampDisplay = _decorate([Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["customElement"])("hui-timestamp-display")], function (_initialize, _LitElement) {
  class HuiTimestampDisplay extends _LitElement {
    constructor(...args) {
      super(...args);

      _initialize(this);
    }

  }

  return {
    F: HuiTimestampDisplay,
    d: [{
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "hass",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "ts",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "format",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "_relative",
      value: void 0
    }, {
      kind: "field",
      key: "_connected",
      value: void 0
    }, {
      kind: "field",
      key: "_interval",
      value: void 0
    }, {
      kind: "method",
      key: "connectedCallback",
      value: function connectedCallback() {
        _get(_getPrototypeOf(HuiTimestampDisplay.prototype), "connectedCallback", this).call(this);

        this._connected = true;

        this._startInterval();
      }
    }, {
      kind: "method",
      key: "disconnectedCallback",
      value: function disconnectedCallback() {
        _get(_getPrototypeOf(HuiTimestampDisplay.prototype), "disconnectedCallback", this).call(this);

        this._connected = false;

        this._clearInterval();
      }
    }, {
      kind: "method",
      key: "render",
      value: function render() {
        if (!this.ts || !this.hass) {
          return lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]``;
        }

        if (isNaN(this.ts.getTime())) {
          return lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]` Invalid date `;
        }

        const format = this._format;

        if (INTERVAL_FORMAT.includes(format)) {
          return lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]` ${this._relative} `;
        }

        if (format in FORMATS) {
          return lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]` ${FORMATS[format](this.ts, this.hass.language)} `;
        }

        return lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]` Invalid format `;
      }
    }, {
      kind: "method",
      key: "updated",
      value: function updated(changedProperties) {
        _get(_getPrototypeOf(HuiTimestampDisplay.prototype), "updated", this).call(this, changedProperties);

        if (!changedProperties.has("format") || !this._connected) {
          return;
        }

        if (INTERVAL_FORMAT.includes("relative")) {
          this._startInterval();
        } else {
          this._clearInterval();
        }
      }
    }, {
      kind: "get",
      key: "_format",
      value: function _format() {
        return this.format || "relative";
      }
    }, {
      kind: "method",
      key: "_startInterval",
      value: function _startInterval() {
        this._clearInterval();

        if (this._connected && INTERVAL_FORMAT.includes(this._format)) {
          this._updateRelative();

          this._interval = window.setInterval(() => this._updateRelative(), 1000);
        }
      }
    }, {
      kind: "method",
      key: "_clearInterval",
      value: function _clearInterval() {
        if (this._interval) {
          clearInterval(this._interval);
          this._interval = undefined;
        }
      }
    }, {
      kind: "method",
      key: "_updateRelative",
      value: function _updateRelative() {
        if (this.ts && this.hass.localize) {
          this._relative = this._format === "relative" ? Object(_common_datetime_relative_time__WEBPACK_IMPORTED_MODULE_4__["default"])(this.ts, this.hass.localize) : this._relative = Object(_common_datetime_relative_time__WEBPACK_IMPORTED_MODULE_4__["default"])(new Date(), this.hass.localize, {
            compareTime: this.ts,
            includeTense: false
          });
        }
      }
    }]
  };
}, lit_element__WEBPACK_IMPORTED_MODULE_0__["LitElement"]);

/***/ }),

/***/ "./src/panels/lovelace/components/hui-warning.ts":
/*!*******************************************************!*\
  !*** ./src/panels/lovelace/components/hui-warning.ts ***!
  \*******************************************************/
/*! exports provided: HuiWarning */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HuiWarning", function() { return HuiWarning; });
/* harmony import */ var lit_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lit-element */ "./node_modules/lit-element/lit-element.js");
function _decorate(decorators, factory, superClass, mixins) { var api = _getDecoratorsApi(); if (mixins) { for (var i = 0; i < mixins.length; i++) { api = mixins[i](api); } } var r = factory(function initialize(O) { api.initializeInstanceElements(O, decorated.elements); }, superClass); var decorated = api.decorateClass(_coalesceClassElements(r.d.map(_createElementDescriptor)), decorators); api.initializeClassElements(r.F, decorated.elements); return api.runClassFinishers(r.F, decorated.finishers); }

function _getDecoratorsApi() { _getDecoratorsApi = function () { return api; }; var api = { elementsDefinitionOrder: [["method"], ["field"]], initializeInstanceElements: function (O, elements) { ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { if (element.kind === kind && element.placement === "own") { this.defineClassElement(O, element); } }, this); }, this); }, initializeClassElements: function (F, elements) { var proto = F.prototype; ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { var placement = element.placement; if (element.kind === kind && (placement === "static" || placement === "prototype")) { var receiver = placement === "static" ? F : proto; this.defineClassElement(receiver, element); } }, this); }, this); }, defineClassElement: function (receiver, element) { var descriptor = element.descriptor; if (element.kind === "field") { var initializer = element.initializer; descriptor = { enumerable: descriptor.enumerable, writable: descriptor.writable, configurable: descriptor.configurable, value: initializer === void 0 ? void 0 : initializer.call(receiver) }; } Object.defineProperty(receiver, element.key, descriptor); }, decorateClass: function (elements, decorators) { var newElements = []; var finishers = []; var placements = { static: [], prototype: [], own: [] }; elements.forEach(function (element) { this.addElementPlacement(element, placements); }, this); elements.forEach(function (element) { if (!_hasDecorators(element)) return newElements.push(element); var elementFinishersExtras = this.decorateElement(element, placements); newElements.push(elementFinishersExtras.element); newElements.push.apply(newElements, elementFinishersExtras.extras); finishers.push.apply(finishers, elementFinishersExtras.finishers); }, this); if (!decorators) { return { elements: newElements, finishers: finishers }; } var result = this.decorateConstructor(newElements, decorators); finishers.push.apply(finishers, result.finishers); result.finishers = finishers; return result; }, addElementPlacement: function (element, placements, silent) { var keys = placements[element.placement]; if (!silent && keys.indexOf(element.key) !== -1) { throw new TypeError("Duplicated element (" + element.key + ")"); } keys.push(element.key); }, decorateElement: function (element, placements) { var extras = []; var finishers = []; for (var decorators = element.decorators, i = decorators.length - 1; i >= 0; i--) { var keys = placements[element.placement]; keys.splice(keys.indexOf(element.key), 1); var elementObject = this.fromElementDescriptor(element); var elementFinisherExtras = this.toElementFinisherExtras((0, decorators[i])(elementObject) || elementObject); element = elementFinisherExtras.element; this.addElementPlacement(element, placements); if (elementFinisherExtras.finisher) { finishers.push(elementFinisherExtras.finisher); } var newExtras = elementFinisherExtras.extras; if (newExtras) { for (var j = 0; j < newExtras.length; j++) { this.addElementPlacement(newExtras[j], placements); } extras.push.apply(extras, newExtras); } } return { element: element, finishers: finishers, extras: extras }; }, decorateConstructor: function (elements, decorators) { var finishers = []; for (var i = decorators.length - 1; i >= 0; i--) { var obj = this.fromClassDescriptor(elements); var elementsAndFinisher = this.toClassDescriptor((0, decorators[i])(obj) || obj); if (elementsAndFinisher.finisher !== undefined) { finishers.push(elementsAndFinisher.finisher); } if (elementsAndFinisher.elements !== undefined) { elements = elementsAndFinisher.elements; for (var j = 0; j < elements.length - 1; j++) { for (var k = j + 1; k < elements.length; k++) { if (elements[j].key === elements[k].key && elements[j].placement === elements[k].placement) { throw new TypeError("Duplicated element (" + elements[j].key + ")"); } } } } } return { elements: elements, finishers: finishers }; }, fromElementDescriptor: function (element) { var obj = { kind: element.kind, key: element.key, placement: element.placement, descriptor: element.descriptor }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); if (element.kind === "field") obj.initializer = element.initializer; return obj; }, toElementDescriptors: function (elementObjects) { if (elementObjects === undefined) return; return _toArray(elementObjects).map(function (elementObject) { var element = this.toElementDescriptor(elementObject); this.disallowProperty(elementObject, "finisher", "An element descriptor"); this.disallowProperty(elementObject, "extras", "An element descriptor"); return element; }, this); }, toElementDescriptor: function (elementObject) { var kind = String(elementObject.kind); if (kind !== "method" && kind !== "field") { throw new TypeError('An element descriptor\'s .kind property must be either "method" or' + ' "field", but a decorator created an element descriptor with' + ' .kind "' + kind + '"'); } var key = _toPropertyKey(elementObject.key); var placement = String(elementObject.placement); if (placement !== "static" && placement !== "prototype" && placement !== "own") { throw new TypeError('An element descriptor\'s .placement property must be one of "static",' + ' "prototype" or "own", but a decorator created an element descriptor' + ' with .placement "' + placement + '"'); } var descriptor = elementObject.descriptor; this.disallowProperty(elementObject, "elements", "An element descriptor"); var element = { kind: kind, key: key, placement: placement, descriptor: Object.assign({}, descriptor) }; if (kind !== "field") { this.disallowProperty(elementObject, "initializer", "A method descriptor"); } else { this.disallowProperty(descriptor, "get", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "set", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "value", "The property descriptor of a field descriptor"); element.initializer = elementObject.initializer; } return element; }, toElementFinisherExtras: function (elementObject) { var element = this.toElementDescriptor(elementObject); var finisher = _optionalCallableProperty(elementObject, "finisher"); var extras = this.toElementDescriptors(elementObject.extras); return { element: element, finisher: finisher, extras: extras }; }, fromClassDescriptor: function (elements) { var obj = { kind: "class", elements: elements.map(this.fromElementDescriptor, this) }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); return obj; }, toClassDescriptor: function (obj) { var kind = String(obj.kind); if (kind !== "class") { throw new TypeError('A class descriptor\'s .kind property must be "class", but a decorator' + ' created a class descriptor with .kind "' + kind + '"'); } this.disallowProperty(obj, "key", "A class descriptor"); this.disallowProperty(obj, "placement", "A class descriptor"); this.disallowProperty(obj, "descriptor", "A class descriptor"); this.disallowProperty(obj, "initializer", "A class descriptor"); this.disallowProperty(obj, "extras", "A class descriptor"); var finisher = _optionalCallableProperty(obj, "finisher"); var elements = this.toElementDescriptors(obj.elements); return { elements: elements, finisher: finisher }; }, runClassFinishers: function (constructor, finishers) { for (var i = 0; i < finishers.length; i++) { var newConstructor = (0, finishers[i])(constructor); if (newConstructor !== undefined) { if (typeof newConstructor !== "function") { throw new TypeError("Finishers must return a constructor."); } constructor = newConstructor; } } return constructor; }, disallowProperty: function (obj, name, objectType) { if (obj[name] !== undefined) { throw new TypeError(objectType + " can't have a ." + name + " property."); } } }; return api; }

function _createElementDescriptor(def) { var key = _toPropertyKey(def.key); var descriptor; if (def.kind === "method") { descriptor = { value: def.value, writable: true, configurable: true, enumerable: false }; } else if (def.kind === "get") { descriptor = { get: def.value, configurable: true, enumerable: false }; } else if (def.kind === "set") { descriptor = { set: def.value, configurable: true, enumerable: false }; } else if (def.kind === "field") { descriptor = { configurable: true, writable: true, enumerable: true }; } var element = { kind: def.kind === "field" ? "field" : "method", key: key, placement: def.static ? "static" : def.kind === "field" ? "own" : "prototype", descriptor: descriptor }; if (def.decorators) element.decorators = def.decorators; if (def.kind === "field") element.initializer = def.value; return element; }

function _coalesceGetterSetter(element, other) { if (element.descriptor.get !== undefined) { other.descriptor.get = element.descriptor.get; } else { other.descriptor.set = element.descriptor.set; } }

function _coalesceClassElements(elements) { var newElements = []; var isSameElement = function (other) { return other.kind === "method" && other.key === element.key && other.placement === element.placement; }; for (var i = 0; i < elements.length; i++) { var element = elements[i]; var other; if (element.kind === "method" && (other = newElements.find(isSameElement))) { if (_isDataDescriptor(element.descriptor) || _isDataDescriptor(other.descriptor)) { if (_hasDecorators(element) || _hasDecorators(other)) { throw new ReferenceError("Duplicated methods (" + element.key + ") can't be decorated."); } other.descriptor = element.descriptor; } else { if (_hasDecorators(element)) { if (_hasDecorators(other)) { throw new ReferenceError("Decorators can't be placed on different accessors with for " + "the same property (" + element.key + ")."); } other.decorators = element.decorators; } _coalesceGetterSetter(element, other); } } else { newElements.push(element); } } return newElements; }

function _hasDecorators(element) { return element.decorators && element.decorators.length; }

function _isDataDescriptor(desc) { return desc !== undefined && !(desc.value === undefined && desc.writable === undefined); }

function _optionalCallableProperty(obj, name) { var value = obj[name]; if (value !== undefined && typeof value !== "function") { throw new TypeError("Expected '" + name + "' to be a function"); } return value; }

function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }

function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }

function _toArray(arr) { return _arrayWithHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(n); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }


let HuiWarning = _decorate([Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["customElement"])("hui-warning")], function (_initialize, _LitElement) {
  class HuiWarning extends _LitElement {
    constructor(...args) {
      super(...args);

      _initialize(this);
    }

  }

  return {
    F: HuiWarning,
    d: [{
      kind: "method",
      key: "render",
      value: function render() {
        return lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]` <slot></slot> `;
      }
    }, {
      kind: "get",
      static: true,
      key: "styles",
      value: function styles() {
        return lit_element__WEBPACK_IMPORTED_MODULE_0__["css"]`
      :host {
        display: block;
        color: black;
        background-color: #fce588;
        padding: 8px;
      }
    `;
      }
    }]
  };
}, lit_element__WEBPACK_IMPORTED_MODULE_0__["LitElement"]);

/***/ }),

/***/ "./src/panels/lovelace/create-element/create-element-base.ts":
/*!*******************************************************************!*\
  !*** ./src/panels/lovelace/create-element/create-element-base.ts ***!
  \*******************************************************************/
/*! exports provided: createErrorCardElement, createErrorCardConfig, createLovelaceElement, getLovelaceElementClass */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "createErrorCardElement", function() { return createErrorCardElement; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "createErrorCardConfig", function() { return createErrorCardConfig; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "createLovelaceElement", function() { return createLovelaceElement; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getLovelaceElementClass", function() { return getLovelaceElementClass; });
/* harmony import */ var _common_dom_fire_event__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../common/dom/fire_event */ "./src/common/dom/fire_event.ts");
/* harmony import */ var _data_lovelace_custom_cards__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../data/lovelace_custom_cards */ "./src/data/lovelace_custom_cards.ts");


const TIMEOUT = 2000;
const createErrorCardElement = config => {
  const el = document.createElement("hui-error-card");

  if (customElements.get("hui-error-card")) {
    el.setConfig(config);
  } else {
    Promise.all(/*! import() */[__webpack_require__.e(17), __webpack_require__.e(34)]).then(__webpack_require__.bind(null, /*! ../cards/hui-error-card */ "./src/panels/lovelace/cards/hui-error-card.ts"));
    customElements.whenDefined("hui-error-card").then(() => el.setConfig(config));
  }

  return el;
};
const createErrorCardConfig = (error, origConfig) => ({
  type: "error",
  error,
  origConfig
});

const _createElement = (tag, config) => {
  const element = document.createElement(tag);

  try {
    // @ts-ignore
    element.setConfig(config);
  } catch (err) {
    // eslint-disable-next-line
    console.error(tag, err); // eslint-disable-next-line @typescript-eslint/no-use-before-define

    return _createErrorElement(err.message, config);
  }

  return element;
};

const _createErrorElement = (error, config) => createErrorCardElement(createErrorCardConfig(error, config));

const _customCreate = (tag, config) => {
  if (customElements.get(tag)) {
    return _createElement(tag, config);
  }

  const element = _createErrorElement(`Custom element doesn't exist: ${tag}.`, config);

  element.style.display = "None";
  const timer = window.setTimeout(() => {
    element.style.display = "";
  }, TIMEOUT);
  customElements.whenDefined(tag).then(() => {
    clearTimeout(timer);
    Object(_common_dom_fire_event__WEBPACK_IMPORTED_MODULE_0__["fireEvent"])(element, "ll-rebuild");
  });
  return element;
};

const _lazyCreate = (tag, config) => {
  if (customElements.get(tag)) {
    return _createElement(tag, config);
  }

  const element = document.createElement(tag);
  customElements.whenDefined(tag).then(() => {
    try {
      // @ts-ignore
      element.setConfig(config);
    } catch (err) {
      // We let it rebuild and the error wil be handled by _createElement
      Object(_common_dom_fire_event__WEBPACK_IMPORTED_MODULE_0__["fireEvent"])(element, "ll-rebuild");
    }
  });
  return element;
};

const _getCustomTag = type => type.startsWith(_data_lovelace_custom_cards__WEBPACK_IMPORTED_MODULE_1__["CUSTOM_TYPE_PREFIX"]) ? type.substr(_data_lovelace_custom_cards__WEBPACK_IMPORTED_MODULE_1__["CUSTOM_TYPE_PREFIX"].length) : undefined;

const createLovelaceElement = (tagSuffix, config, alwaysLoadTypes, lazyLoadTypes, domainTypes, defaultType) => {
  if (!config || typeof config !== "object") {
    return _createErrorElement("Config is not an object", config);
  }

  if (!config.type && !defaultType && ( // If domain types is given, we can derive a type from "entity"
  !domainTypes || !("entity" in config))) {
    return _createErrorElement("No card type configured.", config);
  }

  const customTag = config.type ? _getCustomTag(config.type) : undefined;

  if (customTag) {
    return _customCreate(customTag, config);
  }

  let type; // config.type has priority over config.entity, but defaultType has not.
  // @ts-ignore

  if (domainTypes && !config.type && config.entity) {
    // @ts-ignore
    const domain = config.entity.split(".", 1)[0];
    type = `${domainTypes[domain] || domainTypes._domain_not_found}-entity`;
  } else {
    type = config.type || defaultType;
  }

  if (type === undefined) {
    return _createErrorElement(`No type specified`, config);
  }

  const tag = `hui-${type}-${tagSuffix}`;

  if (lazyLoadTypes && type in lazyLoadTypes) {
    lazyLoadTypes[type]();
    return _lazyCreate(tag, config);
  }

  if (alwaysLoadTypes && alwaysLoadTypes.has(type)) {
    return _createElement(tag, config);
  }

  return _createErrorElement(`Unknown type encountered: ${type}.`, config);
};
const getLovelaceElementClass = async (type, tagSuffix, alwaysLoadTypes, lazyLoadTypes) => {
  const customTag = _getCustomTag(type);

  if (customTag) {
    const customCls = customElements.get(customTag);
    return customCls || new Promise((resolve, reject) => {
      // We will give custom components up to TIMEOUT seconds to get defined
      setTimeout(() => reject(new Error(`Custom element not found: ${customTag}`)), TIMEOUT);
      customElements.whenDefined(customTag).then(() => resolve(customElements.get(customTag)));
    });
  }

  const tag = `hui-${type}-${tagSuffix}`;
  const cls = customElements.get(tag);

  if (alwaysLoadTypes && alwaysLoadTypes.has(type)) {
    return cls;
  }

  if (lazyLoadTypes && type in lazyLoadTypes) {
    return cls || lazyLoadTypes[type]().then(() => customElements.get(tag));
  }

  throw new Error(`Unknown type: ${type}`);
};

/***/ }),

/***/ "./src/panels/lovelace/create-element/create-row-element.ts":
/*!******************************************************************!*\
  !*** ./src/panels/lovelace/create-element/create-row-element.ts ***!
  \******************************************************************/
/*! exports provided: createRowElement */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "createRowElement", function() { return createRowElement; });
/* harmony import */ var _entity_rows_hui_media_player_entity_row__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../entity-rows/hui-media-player-entity-row */ "./src/panels/lovelace/entity-rows/hui-media-player-entity-row.ts");
/* harmony import */ var _entity_rows_hui_scene_entity_row__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../entity-rows/hui-scene-entity-row */ "./src/panels/lovelace/entity-rows/hui-scene-entity-row.ts");
/* harmony import */ var _entity_rows_hui_script_entity_row__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../entity-rows/hui-script-entity-row */ "./src/panels/lovelace/entity-rows/hui-script-entity-row.ts");
/* harmony import */ var _entity_rows_hui_sensor_entity_row__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../entity-rows/hui-sensor-entity-row */ "./src/panels/lovelace/entity-rows/hui-sensor-entity-row.ts");
/* harmony import */ var _entity_rows_hui_text_entity_row__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../entity-rows/hui-text-entity-row */ "./src/panels/lovelace/entity-rows/hui-text-entity-row.ts");
/* harmony import */ var _entity_rows_hui_toggle_entity_row__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../entity-rows/hui-toggle-entity-row */ "./src/panels/lovelace/entity-rows/hui-toggle-entity-row.ts");
/* harmony import */ var _special_rows_hui_attribute_row__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../special-rows/hui-attribute-row */ "./src/panels/lovelace/special-rows/hui-attribute-row.ts");
/* harmony import */ var _special_rows_hui_button_row__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../special-rows/hui-button-row */ "./src/panels/lovelace/special-rows/hui-button-row.ts");
/* harmony import */ var _special_rows_hui_call_service_row__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../special-rows/hui-call-service-row */ "./src/panels/lovelace/special-rows/hui-call-service-row.ts");
/* harmony import */ var _create_element_base__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./create-element-base */ "./src/panels/lovelace/create-element/create-element-base.ts");










const ALWAYS_LOADED_TYPES = new Set(["media-player-entity", "scene-entity", "script-entity", "sensor-entity", "text-entity", "toggle-entity", "button", "call-service"]);
const LAZY_LOAD_TYPES = {
  "climate-entity": () => __webpack_require__.e(/*! import() */ 57).then(__webpack_require__.bind(null, /*! ../entity-rows/hui-climate-entity-row */ "./src/panels/lovelace/entity-rows/hui-climate-entity-row.ts")),
  "cover-entity": () => __webpack_require__.e(/*! import() */ 45).then(__webpack_require__.bind(null, /*! ../entity-rows/hui-cover-entity-row */ "./src/panels/lovelace/entity-rows/hui-cover-entity-row.ts")),
  "group-entity": () => __webpack_require__.e(/*! import() */ 81).then(__webpack_require__.bind(null, /*! ../entity-rows/hui-group-entity-row */ "./src/panels/lovelace/entity-rows/hui-group-entity-row.ts")),
  "input-datetime-entity": () => Promise.all(/*! import() */[__webpack_require__.e(1), __webpack_require__.e(0), __webpack_require__.e(2), __webpack_require__.e(3), __webpack_require__.e(6), __webpack_require__.e(52)]).then(__webpack_require__.bind(null, /*! ../entity-rows/hui-input-datetime-entity-row */ "./src/panels/lovelace/entity-rows/hui-input-datetime-entity-row.ts")),
  "input-number-entity": () => __webpack_require__.e(/*! import() */ 63).then(__webpack_require__.bind(null, /*! ../entity-rows/hui-input-number-entity-row */ "./src/panels/lovelace/entity-rows/hui-input-number-entity-row.ts")),
  "input-select-entity": () => Promise.all(/*! import() */[__webpack_require__.e(1), __webpack_require__.e(0), __webpack_require__.e(2), __webpack_require__.e(3), __webpack_require__.e(6), __webpack_require__.e(51)]).then(__webpack_require__.bind(null, /*! ../entity-rows/hui-input-select-entity-row */ "./src/panels/lovelace/entity-rows/hui-input-select-entity-row.ts")),
  "input-text-entity": () => __webpack_require__.e(/*! import() */ 64).then(__webpack_require__.bind(null, /*! ../entity-rows/hui-input-text-entity-row */ "./src/panels/lovelace/entity-rows/hui-input-text-entity-row.ts")),
  "lock-entity": () => __webpack_require__.e(/*! import() */ 82).then(__webpack_require__.bind(null, /*! ../entity-rows/hui-lock-entity-row */ "./src/panels/lovelace/entity-rows/hui-lock-entity-row.ts")),
  "timer-entity": () => __webpack_require__.e(/*! import() */ 50).then(__webpack_require__.bind(null, /*! ../entity-rows/hui-timer-entity-row */ "./src/panels/lovelace/entity-rows/hui-timer-entity-row.ts")),
  conditional: () => Promise.all(/*! import() */[__webpack_require__.e(33), __webpack_require__.e(85)]).then(__webpack_require__.bind(null, /*! ../special-rows/hui-conditional-row */ "./src/panels/lovelace/special-rows/hui-conditional-row.ts")),
  "weather-entity": () => __webpack_require__.e(/*! import() */ 66).then(__webpack_require__.bind(null, /*! ../entity-rows/hui-weather-entity-row */ "./src/panels/lovelace/entity-rows/hui-weather-entity-row.ts")),
  divider: () => __webpack_require__.e(/*! import() */ 86).then(__webpack_require__.bind(null, /*! ../special-rows/hui-divider-row */ "./src/panels/lovelace/special-rows/hui-divider-row.ts")),
  section: () => __webpack_require__.e(/*! import() */ 87).then(__webpack_require__.bind(null, /*! ../special-rows/hui-section-row */ "./src/panels/lovelace/special-rows/hui-section-row.ts")),
  weblink: () => __webpack_require__.e(/*! import() */ 89).then(__webpack_require__.bind(null, /*! ../special-rows/hui-weblink-row */ "./src/panels/lovelace/special-rows/hui-weblink-row.ts")),
  cast: () => __webpack_require__.e(/*! import() */ 49).then(__webpack_require__.bind(null, /*! ../special-rows/hui-cast-row */ "./src/panels/lovelace/special-rows/hui-cast-row.ts")),
  buttons: () => Promise.all(/*! import() */[__webpack_require__.e(32), __webpack_require__.e(69)]).then(__webpack_require__.bind(null, /*! ../special-rows/hui-buttons-row */ "./src/panels/lovelace/special-rows/hui-buttons-row.ts")),
  attribute: () => Promise.resolve(/*! import() */).then(__webpack_require__.bind(null, /*! ../special-rows/hui-attribute-row */ "./src/panels/lovelace/special-rows/hui-attribute-row.ts")),
  text: () => __webpack_require__.e(/*! import() */ 88).then(__webpack_require__.bind(null, /*! ../special-rows/hui-text-row */ "./src/panels/lovelace/special-rows/hui-text-row.ts"))
};
const DOMAIN_TO_ELEMENT_TYPE = {
  _domain_not_found: "text",
  alert: "toggle",
  automation: "toggle",
  climate: "climate",
  cover: "cover",
  fan: "toggle",
  group: "group",
  input_boolean: "toggle",
  input_number: "input-number",
  input_select: "input-select",
  input_text: "input-text",
  light: "toggle",
  lock: "lock",
  media_player: "media-player",
  remote: "toggle",
  scene: "scene",
  script: "script",
  sensor: "sensor",
  timer: "timer",
  switch: "toggle",
  vacuum: "toggle",
  // Temporary. Once climate is rewritten,
  // water heater should get it's own row.
  water_heater: "climate",
  input_datetime: "input-datetime",
  weather: "weather"
};
const createRowElement = config => Object(_create_element_base__WEBPACK_IMPORTED_MODULE_9__["createLovelaceElement"])("row", config, ALWAYS_LOADED_TYPES, LAZY_LOAD_TYPES, DOMAIN_TO_ELEMENT_TYPE, undefined);

/***/ }),

/***/ "./src/panels/lovelace/entity-rows/hui-media-player-entity-row.ts":
/*!************************************************************************!*\
  !*** ./src/panels/lovelace/entity-rows/hui-media-player-entity-row.ts ***!
  \************************************************************************/
/*! no exports provided */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _polymer_paper_icon_button_paper_icon_button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @polymer/paper-icon-button/paper-icon-button */ "./node_modules/@polymer/paper-icon-button/paper-icon-button.js");
/* harmony import */ var lit_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lit-element */ "./node_modules/lit-element/lit-element.js");
/* harmony import */ var _common_entity_supports_feature__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../common/entity/supports-feature */ "./src/common/entity/supports-feature.ts");
/* harmony import */ var _common_util_compute_rtl__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../common/util/compute_rtl */ "./src/common/util/compute_rtl.ts");
/* harmony import */ var _common_util_debounce__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../common/util/debounce */ "./src/common/util/debounce.ts");
/* harmony import */ var _components_ha_slider__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../components/ha-slider */ "./src/components/ha-slider.js");
/* harmony import */ var _data_entity__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../data/entity */ "./src/data/entity.ts");
/* harmony import */ var _data_media_player__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../../data/media-player */ "./src/data/media-player.ts");
/* harmony import */ var _common_has_changed__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../common/has-changed */ "./src/panels/lovelace/common/has-changed.ts");
/* harmony import */ var _components_hui_generic_entity_row__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../components/hui-generic-entity-row */ "./src/panels/lovelace/components/hui-generic-entity-row.ts");
/* harmony import */ var _components_hui_warning__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../components/hui-warning */ "./src/panels/lovelace/components/hui-warning.ts");
function _decorate(decorators, factory, superClass, mixins) { var api = _getDecoratorsApi(); if (mixins) { for (var i = 0; i < mixins.length; i++) { api = mixins[i](api); } } var r = factory(function initialize(O) { api.initializeInstanceElements(O, decorated.elements); }, superClass); var decorated = api.decorateClass(_coalesceClassElements(r.d.map(_createElementDescriptor)), decorators); api.initializeClassElements(r.F, decorated.elements); return api.runClassFinishers(r.F, decorated.finishers); }

function _getDecoratorsApi() { _getDecoratorsApi = function () { return api; }; var api = { elementsDefinitionOrder: [["method"], ["field"]], initializeInstanceElements: function (O, elements) { ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { if (element.kind === kind && element.placement === "own") { this.defineClassElement(O, element); } }, this); }, this); }, initializeClassElements: function (F, elements) { var proto = F.prototype; ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { var placement = element.placement; if (element.kind === kind && (placement === "static" || placement === "prototype")) { var receiver = placement === "static" ? F : proto; this.defineClassElement(receiver, element); } }, this); }, this); }, defineClassElement: function (receiver, element) { var descriptor = element.descriptor; if (element.kind === "field") { var initializer = element.initializer; descriptor = { enumerable: descriptor.enumerable, writable: descriptor.writable, configurable: descriptor.configurable, value: initializer === void 0 ? void 0 : initializer.call(receiver) }; } Object.defineProperty(receiver, element.key, descriptor); }, decorateClass: function (elements, decorators) { var newElements = []; var finishers = []; var placements = { static: [], prototype: [], own: [] }; elements.forEach(function (element) { this.addElementPlacement(element, placements); }, this); elements.forEach(function (element) { if (!_hasDecorators(element)) return newElements.push(element); var elementFinishersExtras = this.decorateElement(element, placements); newElements.push(elementFinishersExtras.element); newElements.push.apply(newElements, elementFinishersExtras.extras); finishers.push.apply(finishers, elementFinishersExtras.finishers); }, this); if (!decorators) { return { elements: newElements, finishers: finishers }; } var result = this.decorateConstructor(newElements, decorators); finishers.push.apply(finishers, result.finishers); result.finishers = finishers; return result; }, addElementPlacement: function (element, placements, silent) { var keys = placements[element.placement]; if (!silent && keys.indexOf(element.key) !== -1) { throw new TypeError("Duplicated element (" + element.key + ")"); } keys.push(element.key); }, decorateElement: function (element, placements) { var extras = []; var finishers = []; for (var decorators = element.decorators, i = decorators.length - 1; i >= 0; i--) { var keys = placements[element.placement]; keys.splice(keys.indexOf(element.key), 1); var elementObject = this.fromElementDescriptor(element); var elementFinisherExtras = this.toElementFinisherExtras((0, decorators[i])(elementObject) || elementObject); element = elementFinisherExtras.element; this.addElementPlacement(element, placements); if (elementFinisherExtras.finisher) { finishers.push(elementFinisherExtras.finisher); } var newExtras = elementFinisherExtras.extras; if (newExtras) { for (var j = 0; j < newExtras.length; j++) { this.addElementPlacement(newExtras[j], placements); } extras.push.apply(extras, newExtras); } } return { element: element, finishers: finishers, extras: extras }; }, decorateConstructor: function (elements, decorators) { var finishers = []; for (var i = decorators.length - 1; i >= 0; i--) { var obj = this.fromClassDescriptor(elements); var elementsAndFinisher = this.toClassDescriptor((0, decorators[i])(obj) || obj); if (elementsAndFinisher.finisher !== undefined) { finishers.push(elementsAndFinisher.finisher); } if (elementsAndFinisher.elements !== undefined) { elements = elementsAndFinisher.elements; for (var j = 0; j < elements.length - 1; j++) { for (var k = j + 1; k < elements.length; k++) { if (elements[j].key === elements[k].key && elements[j].placement === elements[k].placement) { throw new TypeError("Duplicated element (" + elements[j].key + ")"); } } } } } return { elements: elements, finishers: finishers }; }, fromElementDescriptor: function (element) { var obj = { kind: element.kind, key: element.key, placement: element.placement, descriptor: element.descriptor }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); if (element.kind === "field") obj.initializer = element.initializer; return obj; }, toElementDescriptors: function (elementObjects) { if (elementObjects === undefined) return; return _toArray(elementObjects).map(function (elementObject) { var element = this.toElementDescriptor(elementObject); this.disallowProperty(elementObject, "finisher", "An element descriptor"); this.disallowProperty(elementObject, "extras", "An element descriptor"); return element; }, this); }, toElementDescriptor: function (elementObject) { var kind = String(elementObject.kind); if (kind !== "method" && kind !== "field") { throw new TypeError('An element descriptor\'s .kind property must be either "method" or' + ' "field", but a decorator created an element descriptor with' + ' .kind "' + kind + '"'); } var key = _toPropertyKey(elementObject.key); var placement = String(elementObject.placement); if (placement !== "static" && placement !== "prototype" && placement !== "own") { throw new TypeError('An element descriptor\'s .placement property must be one of "static",' + ' "prototype" or "own", but a decorator created an element descriptor' + ' with .placement "' + placement + '"'); } var descriptor = elementObject.descriptor; this.disallowProperty(elementObject, "elements", "An element descriptor"); var element = { kind: kind, key: key, placement: placement, descriptor: Object.assign({}, descriptor) }; if (kind !== "field") { this.disallowProperty(elementObject, "initializer", "A method descriptor"); } else { this.disallowProperty(descriptor, "get", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "set", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "value", "The property descriptor of a field descriptor"); element.initializer = elementObject.initializer; } return element; }, toElementFinisherExtras: function (elementObject) { var element = this.toElementDescriptor(elementObject); var finisher = _optionalCallableProperty(elementObject, "finisher"); var extras = this.toElementDescriptors(elementObject.extras); return { element: element, finisher: finisher, extras: extras }; }, fromClassDescriptor: function (elements) { var obj = { kind: "class", elements: elements.map(this.fromElementDescriptor, this) }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); return obj; }, toClassDescriptor: function (obj) { var kind = String(obj.kind); if (kind !== "class") { throw new TypeError('A class descriptor\'s .kind property must be "class", but a decorator' + ' created a class descriptor with .kind "' + kind + '"'); } this.disallowProperty(obj, "key", "A class descriptor"); this.disallowProperty(obj, "placement", "A class descriptor"); this.disallowProperty(obj, "descriptor", "A class descriptor"); this.disallowProperty(obj, "initializer", "A class descriptor"); this.disallowProperty(obj, "extras", "A class descriptor"); var finisher = _optionalCallableProperty(obj, "finisher"); var elements = this.toElementDescriptors(obj.elements); return { elements: elements, finisher: finisher }; }, runClassFinishers: function (constructor, finishers) { for (var i = 0; i < finishers.length; i++) { var newConstructor = (0, finishers[i])(constructor); if (newConstructor !== undefined) { if (typeof newConstructor !== "function") { throw new TypeError("Finishers must return a constructor."); } constructor = newConstructor; } } return constructor; }, disallowProperty: function (obj, name, objectType) { if (obj[name] !== undefined) { throw new TypeError(objectType + " can't have a ." + name + " property."); } } }; return api; }

function _createElementDescriptor(def) { var key = _toPropertyKey(def.key); var descriptor; if (def.kind === "method") { descriptor = { value: def.value, writable: true, configurable: true, enumerable: false }; } else if (def.kind === "get") { descriptor = { get: def.value, configurable: true, enumerable: false }; } else if (def.kind === "set") { descriptor = { set: def.value, configurable: true, enumerable: false }; } else if (def.kind === "field") { descriptor = { configurable: true, writable: true, enumerable: true }; } var element = { kind: def.kind === "field" ? "field" : "method", key: key, placement: def.static ? "static" : def.kind === "field" ? "own" : "prototype", descriptor: descriptor }; if (def.decorators) element.decorators = def.decorators; if (def.kind === "field") element.initializer = def.value; return element; }

function _coalesceGetterSetter(element, other) { if (element.descriptor.get !== undefined) { other.descriptor.get = element.descriptor.get; } else { other.descriptor.set = element.descriptor.set; } }

function _coalesceClassElements(elements) { var newElements = []; var isSameElement = function (other) { return other.kind === "method" && other.key === element.key && other.placement === element.placement; }; for (var i = 0; i < elements.length; i++) { var element = elements[i]; var other; if (element.kind === "method" && (other = newElements.find(isSameElement))) { if (_isDataDescriptor(element.descriptor) || _isDataDescriptor(other.descriptor)) { if (_hasDecorators(element) || _hasDecorators(other)) { throw new ReferenceError("Duplicated methods (" + element.key + ") can't be decorated."); } other.descriptor = element.descriptor; } else { if (_hasDecorators(element)) { if (_hasDecorators(other)) { throw new ReferenceError("Decorators can't be placed on different accessors with for " + "the same property (" + element.key + ")."); } other.decorators = element.decorators; } _coalesceGetterSetter(element, other); } } else { newElements.push(element); } } return newElements; }

function _hasDecorators(element) { return element.decorators && element.decorators.length; }

function _isDataDescriptor(desc) { return desc !== undefined && !(desc.value === undefined && desc.writable === undefined); }

function _optionalCallableProperty(obj, name) { var value = obj[name]; if (value !== undefined && typeof value !== "function") { throw new TypeError("Expected '" + name + "' to be a function"); } return value; }

function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }

function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }

function _toArray(arr) { return _arrayWithHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(n); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get; } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return _get(target, property, receiver || target); }

function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }













let HuiMediaPlayerEntityRow = _decorate([Object(lit_element__WEBPACK_IMPORTED_MODULE_1__["customElement"])("hui-media-player-entity-row")], function (_initialize, _LitElement) {
  class HuiMediaPlayerEntityRow extends _LitElement {
    constructor(...args) {
      super(...args);

      _initialize(this);
    }

  }

  return {
    F: HuiMediaPlayerEntityRow,
    d: [{
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_1__["property"])()],
      key: "hass",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_1__["property"])()],
      key: "_config",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_1__["property"])()],
      key: "_narrow",

      value() {
        return false;
      }

    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_1__["property"])()],
      key: "_veryNarrow",

      value() {
        return false;
      }

    }, {
      kind: "field",
      key: "_resizeObserver",
      value: void 0
    }, {
      kind: "field",
      key: "_debouncedResizeListener",

      value() {
        return Object(_common_util_debounce__WEBPACK_IMPORTED_MODULE_4__["debounce"])(() => {
          this._narrow = (this.clientWidth || 0) < 300;
          this._veryNarrow = (this.clientWidth || 0) < 225;
        }, 250, false);
      }

    }, {
      kind: "method",
      key: "setConfig",
      value: function setConfig(config) {
        if (!config || !config.entity) {
          throw new Error("Invalid Configuration: 'entity' required");
        }

        this._config = config;
      }
    }, {
      kind: "method",
      key: "connectedCallback",
      value: function connectedCallback() {
        _get(_getPrototypeOf(HuiMediaPlayerEntityRow.prototype), "connectedCallback", this).call(this);

        if (!this._resizeObserver) {
          this._attachObserver();
        }
      }
    }, {
      kind: "method",
      key: "disconnectedCallback",
      value: function disconnectedCallback() {
        var _this$_resizeObserver;

        (_this$_resizeObserver = this._resizeObserver) === null || _this$_resizeObserver === void 0 ? void 0 : _this$_resizeObserver.unobserve(this);
      }
    }, {
      kind: "method",
      key: "firstUpdated",
      value: function firstUpdated() {
        this._attachObserver();
      }
    }, {
      kind: "method",
      key: "shouldUpdate",
      value: function shouldUpdate(changedProps) {
        return Object(_common_has_changed__WEBPACK_IMPORTED_MODULE_8__["hasConfigOrEntityChanged"])(this, changedProps);
      }
    }, {
      kind: "method",
      key: "render",
      value: function render() {
        if (!this.hass || !this._config) {
          return lit_element__WEBPACK_IMPORTED_MODULE_1__["html"]``;
        }

        const stateObj = this.hass.states[this._config.entity];

        if (!stateObj) {
          return lit_element__WEBPACK_IMPORTED_MODULE_1__["html"]`
        <hui-warning
          >${this.hass.localize("ui.panel.lovelace.warning.entity_not_found", "entity", this._config.entity)}</hui-warning
        >
      `;
        }

        const buttons = lit_element__WEBPACK_IMPORTED_MODULE_1__["html"]`
      ${!this._narrow && Object(_common_entity_supports_feature__WEBPACK_IMPORTED_MODULE_2__["supportsFeature"])(stateObj, _data_media_player__WEBPACK_IMPORTED_MODULE_7__["SUPPORT_PREVIOUS_TRACK"]) ? lit_element__WEBPACK_IMPORTED_MODULE_1__["html"]`
            <paper-icon-button
              icon="hass:skip-previous"
              @click=${this._previousTrack}
            ></paper-icon-button>
          ` : ""}
      ${stateObj.state !== "playing" && !Object(_common_entity_supports_feature__WEBPACK_IMPORTED_MODULE_2__["supportsFeature"])(stateObj, _data_media_player__WEBPACK_IMPORTED_MODULE_7__["SUPPORTS_PLAY"]) ? "" : lit_element__WEBPACK_IMPORTED_MODULE_1__["html"]`
            <paper-icon-button
              icon=${this._computeControlIcon(stateObj)}
              @click=${this._playPause}
            ></paper-icon-button>
          `}
      ${Object(_common_entity_supports_feature__WEBPACK_IMPORTED_MODULE_2__["supportsFeature"])(stateObj, _data_media_player__WEBPACK_IMPORTED_MODULE_7__["SUPPORT_NEXT_TRACK"]) ? lit_element__WEBPACK_IMPORTED_MODULE_1__["html"]`
            <paper-icon-button
              icon="hass:skip-next"
              @click=${this._nextTrack}
            ></paper-icon-button>
          ` : ""}
    `;
        return lit_element__WEBPACK_IMPORTED_MODULE_1__["html"]`
      <hui-generic-entity-row
        .hass=${this.hass}
        .config=${this._config}
        .secondaryText=${this._computeMediaTitle(stateObj)}
      >
        <div class="controls">
          ${Object(_common_entity_supports_feature__WEBPACK_IMPORTED_MODULE_2__["supportsFeature"])(stateObj, _data_media_player__WEBPACK_IMPORTED_MODULE_7__["SUPPORT_TURN_ON"]) && stateObj.state === "off" ? lit_element__WEBPACK_IMPORTED_MODULE_1__["html"]`
                <paper-icon-button
                  icon="hass:power"
                  @click=${this._togglePower}
                ></paper-icon-button>
              ` : !Object(_common_entity_supports_feature__WEBPACK_IMPORTED_MODULE_2__["supportsFeature"])(stateObj, _data_media_player__WEBPACK_IMPORTED_MODULE_7__["SUPPORT_VOLUME_SET"]) && !Object(_common_entity_supports_feature__WEBPACK_IMPORTED_MODULE_2__["supportsFeature"])(stateObj, _data_media_player__WEBPACK_IMPORTED_MODULE_7__["SUPPORT_VOLUME_BUTTONS"]) ? buttons : Object(_common_entity_supports_feature__WEBPACK_IMPORTED_MODULE_2__["supportsFeature"])(stateObj, _data_media_player__WEBPACK_IMPORTED_MODULE_7__["SUPPORT_TURN_OFF"]) && stateObj.state !== "off" ? lit_element__WEBPACK_IMPORTED_MODULE_1__["html"]`
                <paper-icon-button
                  icon="hass:power"
                  @click=${this._togglePower}
                ></paper-icon-button>
              ` : ""}
        </div>
      </hui-generic-entity-row>
      ${(Object(_common_entity_supports_feature__WEBPACK_IMPORTED_MODULE_2__["supportsFeature"])(stateObj, _data_media_player__WEBPACK_IMPORTED_MODULE_7__["SUPPORT_VOLUME_SET"]) || Object(_common_entity_supports_feature__WEBPACK_IMPORTED_MODULE_2__["supportsFeature"])(stateObj, _data_media_player__WEBPACK_IMPORTED_MODULE_7__["SUPPORT_VOLUME_BUTTONS"])) && ![_data_entity__WEBPACK_IMPORTED_MODULE_6__["UNAVAILABLE"], _data_entity__WEBPACK_IMPORTED_MODULE_6__["UNKNOWN"], "off"].includes(stateObj.state) ? lit_element__WEBPACK_IMPORTED_MODULE_1__["html"]`
            <div class="flex">
              <div class="volume">
                ${Object(_common_entity_supports_feature__WEBPACK_IMPORTED_MODULE_2__["supportsFeature"])(stateObj, _data_media_player__WEBPACK_IMPORTED_MODULE_7__["SUPPORT_VOLUME_MUTE"]) ? lit_element__WEBPACK_IMPORTED_MODULE_1__["html"]`
                      <paper-icon-button
                        .icon=${stateObj.attributes.is_volume_muted ? "hass:volume-off" : "hass:volume-high"}
                        @click=${this._toggleMute}
                      ></paper-icon-button>
                    ` : ""}
                ${!this._veryNarrow && Object(_common_entity_supports_feature__WEBPACK_IMPORTED_MODULE_2__["supportsFeature"])(stateObj, _data_media_player__WEBPACK_IMPORTED_MODULE_7__["SUPPORT_VOLUME_SET"]) ? lit_element__WEBPACK_IMPORTED_MODULE_1__["html"]`
                      <ha-slider
                        .dir=${Object(_common_util_compute_rtl__WEBPACK_IMPORTED_MODULE_3__["computeRTLDirection"])(this.hass)}
                        .value=${Number(stateObj.attributes.volume_level) * 100}
                        pin
                        @change=${this._selectedValueChanged}
                        ignore-bar-touch
                        id="input"
                      ></ha-slider>
                    ` : !this._veryNarrow && Object(_common_entity_supports_feature__WEBPACK_IMPORTED_MODULE_2__["supportsFeature"])(stateObj, _data_media_player__WEBPACK_IMPORTED_MODULE_7__["SUPPORT_VOLUME_BUTTONS"]) ? lit_element__WEBPACK_IMPORTED_MODULE_1__["html"]`
                      <paper-icon-button
                        icon="hass:volume-minus"
                        @click=${this._volumeDown}
                      ></paper-icon-button>
                      <paper-icon-button
                        icon="hass:volume-plus"
                        @click=${this._volumeUp}
                      ></paper-icon-button>
                    ` : ""}
              </div>

              <div class="controls">
                ${buttons}
              </div>
            </div>
          ` : ""}
    `;
      }
    }, {
      kind: "method",
      key: "_attachObserver",
      value: function _attachObserver() {
        if (typeof ResizeObserver !== "function") {
          __webpack_require__.e(/*! import() */ 25).then(__webpack_require__.t.bind(null, /*! resize-observer */ "./node_modules/resize-observer/lib/ResizeObserver.js", 7)).then(modules => {
            modules.install();

            this._attachObserver();
          });
          return;
        }

        this._resizeObserver = new ResizeObserver(() => this._debouncedResizeListener());

        this._resizeObserver.observe(this);
      }
    }, {
      kind: "method",
      key: "_computeControlIcon",
      value: function _computeControlIcon(stateObj) {
        if (stateObj.state !== "playing") {
          return "hass:play";
        } // eslint-disable-next-line:no-bitwise


        return Object(_common_entity_supports_feature__WEBPACK_IMPORTED_MODULE_2__["supportsFeature"])(stateObj, _data_media_player__WEBPACK_IMPORTED_MODULE_7__["SUPPORT_PAUSE"]) ? "hass:pause" : "hass:stop";
      }
    }, {
      kind: "method",
      key: "_computeMediaTitle",
      value: function _computeMediaTitle(stateObj) {
        let prefix;
        let suffix;

        switch (stateObj.attributes.media_content_type) {
          case "music":
            prefix = stateObj.attributes.media_artist;
            suffix = stateObj.attributes.media_title;
            break;

          case "tvshow":
            prefix = stateObj.attributes.media_series_title;
            suffix = stateObj.attributes.media_title;
            break;

          default:
            prefix = stateObj.attributes.media_title || stateObj.attributes.app_name || stateObj.state;
            suffix = "";
        }

        return prefix && suffix ? `${prefix}: ${suffix}` : prefix || suffix || "";
      }
    }, {
      kind: "method",
      key: "_togglePower",
      value: function _togglePower() {
        const stateObj = this.hass.states[this._config.entity];
        this.hass.callService("media_player", stateObj.state === "off" || stateObj.state === "idle" ? "turn_on" : "turn_off", {
          entity_id: this._config.entity
        });
      }
    }, {
      kind: "method",
      key: "_playPause",
      value: function _playPause() {
        this.hass.callService("media_player", "media_play_pause", {
          entity_id: this._config.entity
        });
      }
    }, {
      kind: "method",
      key: "_previousTrack",
      value: function _previousTrack() {
        this.hass.callService("media_player", "media_previous_track", {
          entity_id: this._config.entity
        });
      }
    }, {
      kind: "method",
      key: "_nextTrack",
      value: function _nextTrack() {
        this.hass.callService("media_player", "media_next_track", {
          entity_id: this._config.entity
        });
      }
    }, {
      kind: "method",
      key: "_toggleMute",
      value: function _toggleMute() {
        this.hass.callService("media_player", "volume_mute", {
          entity_id: this._config.entity,
          is_volume_muted: !this.hass.states[this._config.entity].attributes.is_volume_muted
        });
      }
    }, {
      kind: "method",
      key: "_volumeDown",
      value: function _volumeDown() {
        this.hass.callService("media_player", "volume_down", {
          entity_id: this._config.entity
        });
      }
    }, {
      kind: "method",
      key: "_volumeUp",
      value: function _volumeUp() {
        this.hass.callService("media_player", "volume_up", {
          entity_id: this._config.entity
        });
      }
    }, {
      kind: "method",
      key: "_selectedValueChanged",
      value: function _selectedValueChanged(ev) {
        this.hass.callService("media_player", "volume_set", {
          entity_id: this._config.entity,
          volume_level: ev.target.value / 100
        });
      }
    }, {
      kind: "get",
      static: true,
      key: "styles",
      value: function styles() {
        return lit_element__WEBPACK_IMPORTED_MODULE_1__["css"]`
      :host {
        display: block;
      }
      .flex {
        display: flex;
        align-items: center;
        justify-content: space-between;
      }
      .volume {
        display: flex;
        flex-grow: 2;
        flex-shrink: 2;
      }
      .controls {
        white-space: nowrap;
      }
      ha-slider {
        flex-grow: 2;
        flex-shrink: 2;
        width: 100%;
        margin: 0 -8px 0 1px;
      }
    `;
      }
    }]
  };
}, lit_element__WEBPACK_IMPORTED_MODULE_1__["LitElement"]);

/***/ }),

/***/ "./src/panels/lovelace/entity-rows/hui-scene-entity-row.ts":
/*!*****************************************************************!*\
  !*** ./src/panels/lovelace/entity-rows/hui-scene-entity-row.ts ***!
  \*****************************************************************/
/*! no exports provided */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _material_mwc_button_mwc_button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @material/mwc-button/mwc-button */ "./node_modules/@material/mwc-button/mwc-button.js");
/* harmony import */ var lit_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lit-element */ "./node_modules/lit-element/lit-element.js");
/* harmony import */ var _components_entity_ha_entity_toggle__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../components/entity/ha-entity-toggle */ "./src/components/entity/ha-entity-toggle.ts");
/* harmony import */ var _data_entity__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../data/entity */ "./src/data/entity.ts");
/* harmony import */ var _data_scene__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../data/scene */ "./src/data/scene.ts");
/* harmony import */ var _common_has_changed__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../common/has-changed */ "./src/panels/lovelace/common/has-changed.ts");
/* harmony import */ var _components_hui_generic_entity_row__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../components/hui-generic-entity-row */ "./src/panels/lovelace/components/hui-generic-entity-row.ts");
/* harmony import */ var _components_hui_warning__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../components/hui-warning */ "./src/panels/lovelace/components/hui-warning.ts");
function _decorate(decorators, factory, superClass, mixins) { var api = _getDecoratorsApi(); if (mixins) { for (var i = 0; i < mixins.length; i++) { api = mixins[i](api); } } var r = factory(function initialize(O) { api.initializeInstanceElements(O, decorated.elements); }, superClass); var decorated = api.decorateClass(_coalesceClassElements(r.d.map(_createElementDescriptor)), decorators); api.initializeClassElements(r.F, decorated.elements); return api.runClassFinishers(r.F, decorated.finishers); }

function _getDecoratorsApi() { _getDecoratorsApi = function () { return api; }; var api = { elementsDefinitionOrder: [["method"], ["field"]], initializeInstanceElements: function (O, elements) { ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { if (element.kind === kind && element.placement === "own") { this.defineClassElement(O, element); } }, this); }, this); }, initializeClassElements: function (F, elements) { var proto = F.prototype; ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { var placement = element.placement; if (element.kind === kind && (placement === "static" || placement === "prototype")) { var receiver = placement === "static" ? F : proto; this.defineClassElement(receiver, element); } }, this); }, this); }, defineClassElement: function (receiver, element) { var descriptor = element.descriptor; if (element.kind === "field") { var initializer = element.initializer; descriptor = { enumerable: descriptor.enumerable, writable: descriptor.writable, configurable: descriptor.configurable, value: initializer === void 0 ? void 0 : initializer.call(receiver) }; } Object.defineProperty(receiver, element.key, descriptor); }, decorateClass: function (elements, decorators) { var newElements = []; var finishers = []; var placements = { static: [], prototype: [], own: [] }; elements.forEach(function (element) { this.addElementPlacement(element, placements); }, this); elements.forEach(function (element) { if (!_hasDecorators(element)) return newElements.push(element); var elementFinishersExtras = this.decorateElement(element, placements); newElements.push(elementFinishersExtras.element); newElements.push.apply(newElements, elementFinishersExtras.extras); finishers.push.apply(finishers, elementFinishersExtras.finishers); }, this); if (!decorators) { return { elements: newElements, finishers: finishers }; } var result = this.decorateConstructor(newElements, decorators); finishers.push.apply(finishers, result.finishers); result.finishers = finishers; return result; }, addElementPlacement: function (element, placements, silent) { var keys = placements[element.placement]; if (!silent && keys.indexOf(element.key) !== -1) { throw new TypeError("Duplicated element (" + element.key + ")"); } keys.push(element.key); }, decorateElement: function (element, placements) { var extras = []; var finishers = []; for (var decorators = element.decorators, i = decorators.length - 1; i >= 0; i--) { var keys = placements[element.placement]; keys.splice(keys.indexOf(element.key), 1); var elementObject = this.fromElementDescriptor(element); var elementFinisherExtras = this.toElementFinisherExtras((0, decorators[i])(elementObject) || elementObject); element = elementFinisherExtras.element; this.addElementPlacement(element, placements); if (elementFinisherExtras.finisher) { finishers.push(elementFinisherExtras.finisher); } var newExtras = elementFinisherExtras.extras; if (newExtras) { for (var j = 0; j < newExtras.length; j++) { this.addElementPlacement(newExtras[j], placements); } extras.push.apply(extras, newExtras); } } return { element: element, finishers: finishers, extras: extras }; }, decorateConstructor: function (elements, decorators) { var finishers = []; for (var i = decorators.length - 1; i >= 0; i--) { var obj = this.fromClassDescriptor(elements); var elementsAndFinisher = this.toClassDescriptor((0, decorators[i])(obj) || obj); if (elementsAndFinisher.finisher !== undefined) { finishers.push(elementsAndFinisher.finisher); } if (elementsAndFinisher.elements !== undefined) { elements = elementsAndFinisher.elements; for (var j = 0; j < elements.length - 1; j++) { for (var k = j + 1; k < elements.length; k++) { if (elements[j].key === elements[k].key && elements[j].placement === elements[k].placement) { throw new TypeError("Duplicated element (" + elements[j].key + ")"); } } } } } return { elements: elements, finishers: finishers }; }, fromElementDescriptor: function (element) { var obj = { kind: element.kind, key: element.key, placement: element.placement, descriptor: element.descriptor }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); if (element.kind === "field") obj.initializer = element.initializer; return obj; }, toElementDescriptors: function (elementObjects) { if (elementObjects === undefined) return; return _toArray(elementObjects).map(function (elementObject) { var element = this.toElementDescriptor(elementObject); this.disallowProperty(elementObject, "finisher", "An element descriptor"); this.disallowProperty(elementObject, "extras", "An element descriptor"); return element; }, this); }, toElementDescriptor: function (elementObject) { var kind = String(elementObject.kind); if (kind !== "method" && kind !== "field") { throw new TypeError('An element descriptor\'s .kind property must be either "method" or' + ' "field", but a decorator created an element descriptor with' + ' .kind "' + kind + '"'); } var key = _toPropertyKey(elementObject.key); var placement = String(elementObject.placement); if (placement !== "static" && placement !== "prototype" && placement !== "own") { throw new TypeError('An element descriptor\'s .placement property must be one of "static",' + ' "prototype" or "own", but a decorator created an element descriptor' + ' with .placement "' + placement + '"'); } var descriptor = elementObject.descriptor; this.disallowProperty(elementObject, "elements", "An element descriptor"); var element = { kind: kind, key: key, placement: placement, descriptor: Object.assign({}, descriptor) }; if (kind !== "field") { this.disallowProperty(elementObject, "initializer", "A method descriptor"); } else { this.disallowProperty(descriptor, "get", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "set", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "value", "The property descriptor of a field descriptor"); element.initializer = elementObject.initializer; } return element; }, toElementFinisherExtras: function (elementObject) { var element = this.toElementDescriptor(elementObject); var finisher = _optionalCallableProperty(elementObject, "finisher"); var extras = this.toElementDescriptors(elementObject.extras); return { element: element, finisher: finisher, extras: extras }; }, fromClassDescriptor: function (elements) { var obj = { kind: "class", elements: elements.map(this.fromElementDescriptor, this) }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); return obj; }, toClassDescriptor: function (obj) { var kind = String(obj.kind); if (kind !== "class") { throw new TypeError('A class descriptor\'s .kind property must be "class", but a decorator' + ' created a class descriptor with .kind "' + kind + '"'); } this.disallowProperty(obj, "key", "A class descriptor"); this.disallowProperty(obj, "placement", "A class descriptor"); this.disallowProperty(obj, "descriptor", "A class descriptor"); this.disallowProperty(obj, "initializer", "A class descriptor"); this.disallowProperty(obj, "extras", "A class descriptor"); var finisher = _optionalCallableProperty(obj, "finisher"); var elements = this.toElementDescriptors(obj.elements); return { elements: elements, finisher: finisher }; }, runClassFinishers: function (constructor, finishers) { for (var i = 0; i < finishers.length; i++) { var newConstructor = (0, finishers[i])(constructor); if (newConstructor !== undefined) { if (typeof newConstructor !== "function") { throw new TypeError("Finishers must return a constructor."); } constructor = newConstructor; } } return constructor; }, disallowProperty: function (obj, name, objectType) { if (obj[name] !== undefined) { throw new TypeError(objectType + " can't have a ." + name + " property."); } } }; return api; }

function _createElementDescriptor(def) { var key = _toPropertyKey(def.key); var descriptor; if (def.kind === "method") { descriptor = { value: def.value, writable: true, configurable: true, enumerable: false }; } else if (def.kind === "get") { descriptor = { get: def.value, configurable: true, enumerable: false }; } else if (def.kind === "set") { descriptor = { set: def.value, configurable: true, enumerable: false }; } else if (def.kind === "field") { descriptor = { configurable: true, writable: true, enumerable: true }; } var element = { kind: def.kind === "field" ? "field" : "method", key: key, placement: def.static ? "static" : def.kind === "field" ? "own" : "prototype", descriptor: descriptor }; if (def.decorators) element.decorators = def.decorators; if (def.kind === "field") element.initializer = def.value; return element; }

function _coalesceGetterSetter(element, other) { if (element.descriptor.get !== undefined) { other.descriptor.get = element.descriptor.get; } else { other.descriptor.set = element.descriptor.set; } }

function _coalesceClassElements(elements) { var newElements = []; var isSameElement = function (other) { return other.kind === "method" && other.key === element.key && other.placement === element.placement; }; for (var i = 0; i < elements.length; i++) { var element = elements[i]; var other; if (element.kind === "method" && (other = newElements.find(isSameElement))) { if (_isDataDescriptor(element.descriptor) || _isDataDescriptor(other.descriptor)) { if (_hasDecorators(element) || _hasDecorators(other)) { throw new ReferenceError("Duplicated methods (" + element.key + ") can't be decorated."); } other.descriptor = element.descriptor; } else { if (_hasDecorators(element)) { if (_hasDecorators(other)) { throw new ReferenceError("Decorators can't be placed on different accessors with for " + "the same property (" + element.key + ")."); } other.decorators = element.decorators; } _coalesceGetterSetter(element, other); } } else { newElements.push(element); } } return newElements; }

function _hasDecorators(element) { return element.decorators && element.decorators.length; }

function _isDataDescriptor(desc) { return desc !== undefined && !(desc.value === undefined && desc.writable === undefined); }

function _optionalCallableProperty(obj, name) { var value = obj[name]; if (value !== undefined && typeof value !== "function") { throw new TypeError("Expected '" + name + "' to be a function"); } return value; }

function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }

function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }

function _toArray(arr) { return _arrayWithHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(n); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }










let HuiSceneEntityRow = _decorate([Object(lit_element__WEBPACK_IMPORTED_MODULE_1__["customElement"])("hui-scene-entity-row")], function (_initialize, _LitElement) {
  class HuiSceneEntityRow extends _LitElement {
    constructor(...args) {
      super(...args);

      _initialize(this);
    }

  }

  return {
    F: HuiSceneEntityRow,
    d: [{
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_1__["property"])()],
      key: "hass",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_1__["property"])()],
      key: "_config",
      value: void 0
    }, {
      kind: "method",
      key: "setConfig",
      value: function setConfig(config) {
        if (!config) {
          throw new Error("Configuration error");
        }

        this._config = config;
      }
    }, {
      kind: "method",
      key: "shouldUpdate",
      value: function shouldUpdate(changedProps) {
        return Object(_common_has_changed__WEBPACK_IMPORTED_MODULE_5__["hasConfigOrEntityChanged"])(this, changedProps);
      }
    }, {
      kind: "method",
      key: "render",
      value: function render() {
        if (!this._config || !this.hass) {
          return lit_element__WEBPACK_IMPORTED_MODULE_1__["html"]``;
        }

        const stateObj = this.hass.states[this._config.entity];

        if (!stateObj) {
          return lit_element__WEBPACK_IMPORTED_MODULE_1__["html"]`
        <hui-warning
          >${this.hass.localize("ui.panel.lovelace.warning.entity_not_found", "entity", this._config.entity)}</hui-warning
        >
      `;
        }

        return lit_element__WEBPACK_IMPORTED_MODULE_1__["html"]`
      <hui-generic-entity-row .hass=${this.hass} .config=${this._config}>
        <mwc-button
          @click="${this._callService}"
          .disabled=${_data_entity__WEBPACK_IMPORTED_MODULE_3__["UNAVAILABLE_STATES"].includes(stateObj.state)}
          class="text-content"
        >
          ${this._config.action_name || this.hass.localize("ui.card.scene.activate")}
        </mwc-button>
      </hui-generic-entity-row>
    `;
      }
    }, {
      kind: "get",
      static: true,
      key: "styles",
      value: function styles() {
        return lit_element__WEBPACK_IMPORTED_MODULE_1__["css"]`
      mwc-button {
        margin-right: -0.57em;
      }
    `;
      }
    }, {
      kind: "method",
      key: "_callService",
      value: function _callService(ev) {
        ev.stopPropagation();
        Object(_data_scene__WEBPACK_IMPORTED_MODULE_4__["activateScene"])(this.hass, this._config.entity);
      }
    }]
  };
}, lit_element__WEBPACK_IMPORTED_MODULE_1__["LitElement"]);

/***/ }),

/***/ "./src/panels/lovelace/entity-rows/hui-script-entity-row.ts":
/*!******************************************************************!*\
  !*** ./src/panels/lovelace/entity-rows/hui-script-entity-row.ts ***!
  \******************************************************************/
/*! no exports provided */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _material_mwc_button_mwc_button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @material/mwc-button/mwc-button */ "./node_modules/@material/mwc-button/mwc-button.js");
/* harmony import */ var lit_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lit-element */ "./node_modules/lit-element/lit-element.js");
/* harmony import */ var _components_entity_ha_entity_toggle__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../components/entity/ha-entity-toggle */ "./src/components/entity/ha-entity-toggle.ts");
/* harmony import */ var _data_entity__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../data/entity */ "./src/data/entity.ts");
/* harmony import */ var _common_has_changed__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../common/has-changed */ "./src/panels/lovelace/common/has-changed.ts");
/* harmony import */ var _components_hui_generic_entity_row__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../components/hui-generic-entity-row */ "./src/panels/lovelace/components/hui-generic-entity-row.ts");
/* harmony import */ var _components_hui_warning__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../components/hui-warning */ "./src/panels/lovelace/components/hui-warning.ts");
function _decorate(decorators, factory, superClass, mixins) { var api = _getDecoratorsApi(); if (mixins) { for (var i = 0; i < mixins.length; i++) { api = mixins[i](api); } } var r = factory(function initialize(O) { api.initializeInstanceElements(O, decorated.elements); }, superClass); var decorated = api.decorateClass(_coalesceClassElements(r.d.map(_createElementDescriptor)), decorators); api.initializeClassElements(r.F, decorated.elements); return api.runClassFinishers(r.F, decorated.finishers); }

function _getDecoratorsApi() { _getDecoratorsApi = function () { return api; }; var api = { elementsDefinitionOrder: [["method"], ["field"]], initializeInstanceElements: function (O, elements) { ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { if (element.kind === kind && element.placement === "own") { this.defineClassElement(O, element); } }, this); }, this); }, initializeClassElements: function (F, elements) { var proto = F.prototype; ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { var placement = element.placement; if (element.kind === kind && (placement === "static" || placement === "prototype")) { var receiver = placement === "static" ? F : proto; this.defineClassElement(receiver, element); } }, this); }, this); }, defineClassElement: function (receiver, element) { var descriptor = element.descriptor; if (element.kind === "field") { var initializer = element.initializer; descriptor = { enumerable: descriptor.enumerable, writable: descriptor.writable, configurable: descriptor.configurable, value: initializer === void 0 ? void 0 : initializer.call(receiver) }; } Object.defineProperty(receiver, element.key, descriptor); }, decorateClass: function (elements, decorators) { var newElements = []; var finishers = []; var placements = { static: [], prototype: [], own: [] }; elements.forEach(function (element) { this.addElementPlacement(element, placements); }, this); elements.forEach(function (element) { if (!_hasDecorators(element)) return newElements.push(element); var elementFinishersExtras = this.decorateElement(element, placements); newElements.push(elementFinishersExtras.element); newElements.push.apply(newElements, elementFinishersExtras.extras); finishers.push.apply(finishers, elementFinishersExtras.finishers); }, this); if (!decorators) { return { elements: newElements, finishers: finishers }; } var result = this.decorateConstructor(newElements, decorators); finishers.push.apply(finishers, result.finishers); result.finishers = finishers; return result; }, addElementPlacement: function (element, placements, silent) { var keys = placements[element.placement]; if (!silent && keys.indexOf(element.key) !== -1) { throw new TypeError("Duplicated element (" + element.key + ")"); } keys.push(element.key); }, decorateElement: function (element, placements) { var extras = []; var finishers = []; for (var decorators = element.decorators, i = decorators.length - 1; i >= 0; i--) { var keys = placements[element.placement]; keys.splice(keys.indexOf(element.key), 1); var elementObject = this.fromElementDescriptor(element); var elementFinisherExtras = this.toElementFinisherExtras((0, decorators[i])(elementObject) || elementObject); element = elementFinisherExtras.element; this.addElementPlacement(element, placements); if (elementFinisherExtras.finisher) { finishers.push(elementFinisherExtras.finisher); } var newExtras = elementFinisherExtras.extras; if (newExtras) { for (var j = 0; j < newExtras.length; j++) { this.addElementPlacement(newExtras[j], placements); } extras.push.apply(extras, newExtras); } } return { element: element, finishers: finishers, extras: extras }; }, decorateConstructor: function (elements, decorators) { var finishers = []; for (var i = decorators.length - 1; i >= 0; i--) { var obj = this.fromClassDescriptor(elements); var elementsAndFinisher = this.toClassDescriptor((0, decorators[i])(obj) || obj); if (elementsAndFinisher.finisher !== undefined) { finishers.push(elementsAndFinisher.finisher); } if (elementsAndFinisher.elements !== undefined) { elements = elementsAndFinisher.elements; for (var j = 0; j < elements.length - 1; j++) { for (var k = j + 1; k < elements.length; k++) { if (elements[j].key === elements[k].key && elements[j].placement === elements[k].placement) { throw new TypeError("Duplicated element (" + elements[j].key + ")"); } } } } } return { elements: elements, finishers: finishers }; }, fromElementDescriptor: function (element) { var obj = { kind: element.kind, key: element.key, placement: element.placement, descriptor: element.descriptor }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); if (element.kind === "field") obj.initializer = element.initializer; return obj; }, toElementDescriptors: function (elementObjects) { if (elementObjects === undefined) return; return _toArray(elementObjects).map(function (elementObject) { var element = this.toElementDescriptor(elementObject); this.disallowProperty(elementObject, "finisher", "An element descriptor"); this.disallowProperty(elementObject, "extras", "An element descriptor"); return element; }, this); }, toElementDescriptor: function (elementObject) { var kind = String(elementObject.kind); if (kind !== "method" && kind !== "field") { throw new TypeError('An element descriptor\'s .kind property must be either "method" or' + ' "field", but a decorator created an element descriptor with' + ' .kind "' + kind + '"'); } var key = _toPropertyKey(elementObject.key); var placement = String(elementObject.placement); if (placement !== "static" && placement !== "prototype" && placement !== "own") { throw new TypeError('An element descriptor\'s .placement property must be one of "static",' + ' "prototype" or "own", but a decorator created an element descriptor' + ' with .placement "' + placement + '"'); } var descriptor = elementObject.descriptor; this.disallowProperty(elementObject, "elements", "An element descriptor"); var element = { kind: kind, key: key, placement: placement, descriptor: Object.assign({}, descriptor) }; if (kind !== "field") { this.disallowProperty(elementObject, "initializer", "A method descriptor"); } else { this.disallowProperty(descriptor, "get", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "set", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "value", "The property descriptor of a field descriptor"); element.initializer = elementObject.initializer; } return element; }, toElementFinisherExtras: function (elementObject) { var element = this.toElementDescriptor(elementObject); var finisher = _optionalCallableProperty(elementObject, "finisher"); var extras = this.toElementDescriptors(elementObject.extras); return { element: element, finisher: finisher, extras: extras }; }, fromClassDescriptor: function (elements) { var obj = { kind: "class", elements: elements.map(this.fromElementDescriptor, this) }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); return obj; }, toClassDescriptor: function (obj) { var kind = String(obj.kind); if (kind !== "class") { throw new TypeError('A class descriptor\'s .kind property must be "class", but a decorator' + ' created a class descriptor with .kind "' + kind + '"'); } this.disallowProperty(obj, "key", "A class descriptor"); this.disallowProperty(obj, "placement", "A class descriptor"); this.disallowProperty(obj, "descriptor", "A class descriptor"); this.disallowProperty(obj, "initializer", "A class descriptor"); this.disallowProperty(obj, "extras", "A class descriptor"); var finisher = _optionalCallableProperty(obj, "finisher"); var elements = this.toElementDescriptors(obj.elements); return { elements: elements, finisher: finisher }; }, runClassFinishers: function (constructor, finishers) { for (var i = 0; i < finishers.length; i++) { var newConstructor = (0, finishers[i])(constructor); if (newConstructor !== undefined) { if (typeof newConstructor !== "function") { throw new TypeError("Finishers must return a constructor."); } constructor = newConstructor; } } return constructor; }, disallowProperty: function (obj, name, objectType) { if (obj[name] !== undefined) { throw new TypeError(objectType + " can't have a ." + name + " property."); } } }; return api; }

function _createElementDescriptor(def) { var key = _toPropertyKey(def.key); var descriptor; if (def.kind === "method") { descriptor = { value: def.value, writable: true, configurable: true, enumerable: false }; } else if (def.kind === "get") { descriptor = { get: def.value, configurable: true, enumerable: false }; } else if (def.kind === "set") { descriptor = { set: def.value, configurable: true, enumerable: false }; } else if (def.kind === "field") { descriptor = { configurable: true, writable: true, enumerable: true }; } var element = { kind: def.kind === "field" ? "field" : "method", key: key, placement: def.static ? "static" : def.kind === "field" ? "own" : "prototype", descriptor: descriptor }; if (def.decorators) element.decorators = def.decorators; if (def.kind === "field") element.initializer = def.value; return element; }

function _coalesceGetterSetter(element, other) { if (element.descriptor.get !== undefined) { other.descriptor.get = element.descriptor.get; } else { other.descriptor.set = element.descriptor.set; } }

function _coalesceClassElements(elements) { var newElements = []; var isSameElement = function (other) { return other.kind === "method" && other.key === element.key && other.placement === element.placement; }; for (var i = 0; i < elements.length; i++) { var element = elements[i]; var other; if (element.kind === "method" && (other = newElements.find(isSameElement))) { if (_isDataDescriptor(element.descriptor) || _isDataDescriptor(other.descriptor)) { if (_hasDecorators(element) || _hasDecorators(other)) { throw new ReferenceError("Duplicated methods (" + element.key + ") can't be decorated."); } other.descriptor = element.descriptor; } else { if (_hasDecorators(element)) { if (_hasDecorators(other)) { throw new ReferenceError("Decorators can't be placed on different accessors with for " + "the same property (" + element.key + ")."); } other.decorators = element.decorators; } _coalesceGetterSetter(element, other); } } else { newElements.push(element); } } return newElements; }

function _hasDecorators(element) { return element.decorators && element.decorators.length; }

function _isDataDescriptor(desc) { return desc !== undefined && !(desc.value === undefined && desc.writable === undefined); }

function _optionalCallableProperty(obj, name) { var value = obj[name]; if (value !== undefined && typeof value !== "function") { throw new TypeError("Expected '" + name + "' to be a function"); } return value; }

function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }

function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }

function _toArray(arr) { return _arrayWithHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(n); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }









let HuiScriptEntityRow = _decorate([Object(lit_element__WEBPACK_IMPORTED_MODULE_1__["customElement"])("hui-script-entity-row")], function (_initialize, _LitElement) {
  class HuiScriptEntityRow extends _LitElement {
    constructor(...args) {
      super(...args);

      _initialize(this);
    }

  }

  return {
    F: HuiScriptEntityRow,
    d: [{
      kind: "field",
      key: "hass",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_1__["property"])()],
      key: "_config",
      value: void 0
    }, {
      kind: "method",
      key: "setConfig",
      value: function setConfig(config) {
        if (!config) {
          throw new Error("Configuration error");
        }

        this._config = config;
      }
    }, {
      kind: "method",
      key: "shouldUpdate",
      value: function shouldUpdate(changedProps) {
        return Object(_common_has_changed__WEBPACK_IMPORTED_MODULE_4__["hasConfigOrEntityChanged"])(this, changedProps);
      }
    }, {
      kind: "method",
      key: "render",
      value: function render() {
        if (!this._config || !this.hass) {
          return lit_element__WEBPACK_IMPORTED_MODULE_1__["html"]``;
        }

        const stateObj = this.hass.states[this._config.entity];

        if (!stateObj) {
          return lit_element__WEBPACK_IMPORTED_MODULE_1__["html"]`
        <hui-warning
          >${this.hass.localize("ui.panel.lovelace.warning.entity_not_found", "entity", this._config.entity)}</hui-warning
        >
      `;
        }

        return lit_element__WEBPACK_IMPORTED_MODULE_1__["html"]`
      <hui-generic-entity-row .hass=${this.hass} .config=${this._config}>
        ${stateObj.attributes.can_cancel ? lit_element__WEBPACK_IMPORTED_MODULE_1__["html"]`
              <ha-entity-toggle
                .disabled=${_data_entity__WEBPACK_IMPORTED_MODULE_3__["UNAVAILABLE_STATES"].includes(stateObj.state)}
                .hass=${this.hass}
                .stateObj=${stateObj}
              ></ha-entity-toggle>
            ` : lit_element__WEBPACK_IMPORTED_MODULE_1__["html"]`
              <mwc-button
                @click=${this._callService}
                .disabled=${_data_entity__WEBPACK_IMPORTED_MODULE_3__["UNAVAILABLE_STATES"].includes(stateObj.state)}
                class="text-content"
              >
                ${this._config.action_name || this.hass.localize("ui.card.script.execute")}
              </mwc-button>
            `}
      </hui-generic-entity-row>
    `;
      }
    }, {
      kind: "get",
      static: true,
      key: "styles",
      value: function styles() {
        return lit_element__WEBPACK_IMPORTED_MODULE_1__["css"]`
      mwc-button {
        margin-right: -0.57em;
      }
    `;
      }
    }, {
      kind: "method",
      key: "_callService",
      value: function _callService(ev) {
        ev.stopPropagation();
        this.hass.callService("script", "turn_on", {
          entity_id: this._config.entity
        });
      }
    }]
  };
}, lit_element__WEBPACK_IMPORTED_MODULE_1__["LitElement"]);

/***/ }),

/***/ "./src/panels/lovelace/entity-rows/hui-sensor-entity-row.ts":
/*!******************************************************************!*\
  !*** ./src/panels/lovelace/entity-rows/hui-sensor-entity-row.ts ***!
  \******************************************************************/
/*! no exports provided */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var lit_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lit-element */ "./node_modules/lit-element/lit-element.js");
/* harmony import */ var _common_entity_compute_state_display__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../common/entity/compute_state_display */ "./src/common/entity/compute_state_display.ts");
/* harmony import */ var _data_sensor__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../data/sensor */ "./src/data/sensor.ts");
/* harmony import */ var _common_has_changed__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../common/has-changed */ "./src/panels/lovelace/common/has-changed.ts");
/* harmony import */ var _components_hui_generic_entity_row__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../components/hui-generic-entity-row */ "./src/panels/lovelace/components/hui-generic-entity-row.ts");
/* harmony import */ var _components_hui_timestamp_display__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../components/hui-timestamp-display */ "./src/panels/lovelace/components/hui-timestamp-display.ts");
/* harmony import */ var _components_hui_warning__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../components/hui-warning */ "./src/panels/lovelace/components/hui-warning.ts");
function _decorate(decorators, factory, superClass, mixins) { var api = _getDecoratorsApi(); if (mixins) { for (var i = 0; i < mixins.length; i++) { api = mixins[i](api); } } var r = factory(function initialize(O) { api.initializeInstanceElements(O, decorated.elements); }, superClass); var decorated = api.decorateClass(_coalesceClassElements(r.d.map(_createElementDescriptor)), decorators); api.initializeClassElements(r.F, decorated.elements); return api.runClassFinishers(r.F, decorated.finishers); }

function _getDecoratorsApi() { _getDecoratorsApi = function () { return api; }; var api = { elementsDefinitionOrder: [["method"], ["field"]], initializeInstanceElements: function (O, elements) { ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { if (element.kind === kind && element.placement === "own") { this.defineClassElement(O, element); } }, this); }, this); }, initializeClassElements: function (F, elements) { var proto = F.prototype; ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { var placement = element.placement; if (element.kind === kind && (placement === "static" || placement === "prototype")) { var receiver = placement === "static" ? F : proto; this.defineClassElement(receiver, element); } }, this); }, this); }, defineClassElement: function (receiver, element) { var descriptor = element.descriptor; if (element.kind === "field") { var initializer = element.initializer; descriptor = { enumerable: descriptor.enumerable, writable: descriptor.writable, configurable: descriptor.configurable, value: initializer === void 0 ? void 0 : initializer.call(receiver) }; } Object.defineProperty(receiver, element.key, descriptor); }, decorateClass: function (elements, decorators) { var newElements = []; var finishers = []; var placements = { static: [], prototype: [], own: [] }; elements.forEach(function (element) { this.addElementPlacement(element, placements); }, this); elements.forEach(function (element) { if (!_hasDecorators(element)) return newElements.push(element); var elementFinishersExtras = this.decorateElement(element, placements); newElements.push(elementFinishersExtras.element); newElements.push.apply(newElements, elementFinishersExtras.extras); finishers.push.apply(finishers, elementFinishersExtras.finishers); }, this); if (!decorators) { return { elements: newElements, finishers: finishers }; } var result = this.decorateConstructor(newElements, decorators); finishers.push.apply(finishers, result.finishers); result.finishers = finishers; return result; }, addElementPlacement: function (element, placements, silent) { var keys = placements[element.placement]; if (!silent && keys.indexOf(element.key) !== -1) { throw new TypeError("Duplicated element (" + element.key + ")"); } keys.push(element.key); }, decorateElement: function (element, placements) { var extras = []; var finishers = []; for (var decorators = element.decorators, i = decorators.length - 1; i >= 0; i--) { var keys = placements[element.placement]; keys.splice(keys.indexOf(element.key), 1); var elementObject = this.fromElementDescriptor(element); var elementFinisherExtras = this.toElementFinisherExtras((0, decorators[i])(elementObject) || elementObject); element = elementFinisherExtras.element; this.addElementPlacement(element, placements); if (elementFinisherExtras.finisher) { finishers.push(elementFinisherExtras.finisher); } var newExtras = elementFinisherExtras.extras; if (newExtras) { for (var j = 0; j < newExtras.length; j++) { this.addElementPlacement(newExtras[j], placements); } extras.push.apply(extras, newExtras); } } return { element: element, finishers: finishers, extras: extras }; }, decorateConstructor: function (elements, decorators) { var finishers = []; for (var i = decorators.length - 1; i >= 0; i--) { var obj = this.fromClassDescriptor(elements); var elementsAndFinisher = this.toClassDescriptor((0, decorators[i])(obj) || obj); if (elementsAndFinisher.finisher !== undefined) { finishers.push(elementsAndFinisher.finisher); } if (elementsAndFinisher.elements !== undefined) { elements = elementsAndFinisher.elements; for (var j = 0; j < elements.length - 1; j++) { for (var k = j + 1; k < elements.length; k++) { if (elements[j].key === elements[k].key && elements[j].placement === elements[k].placement) { throw new TypeError("Duplicated element (" + elements[j].key + ")"); } } } } } return { elements: elements, finishers: finishers }; }, fromElementDescriptor: function (element) { var obj = { kind: element.kind, key: element.key, placement: element.placement, descriptor: element.descriptor }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); if (element.kind === "field") obj.initializer = element.initializer; return obj; }, toElementDescriptors: function (elementObjects) { if (elementObjects === undefined) return; return _toArray(elementObjects).map(function (elementObject) { var element = this.toElementDescriptor(elementObject); this.disallowProperty(elementObject, "finisher", "An element descriptor"); this.disallowProperty(elementObject, "extras", "An element descriptor"); return element; }, this); }, toElementDescriptor: function (elementObject) { var kind = String(elementObject.kind); if (kind !== "method" && kind !== "field") { throw new TypeError('An element descriptor\'s .kind property must be either "method" or' + ' "field", but a decorator created an element descriptor with' + ' .kind "' + kind + '"'); } var key = _toPropertyKey(elementObject.key); var placement = String(elementObject.placement); if (placement !== "static" && placement !== "prototype" && placement !== "own") { throw new TypeError('An element descriptor\'s .placement property must be one of "static",' + ' "prototype" or "own", but a decorator created an element descriptor' + ' with .placement "' + placement + '"'); } var descriptor = elementObject.descriptor; this.disallowProperty(elementObject, "elements", "An element descriptor"); var element = { kind: kind, key: key, placement: placement, descriptor: Object.assign({}, descriptor) }; if (kind !== "field") { this.disallowProperty(elementObject, "initializer", "A method descriptor"); } else { this.disallowProperty(descriptor, "get", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "set", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "value", "The property descriptor of a field descriptor"); element.initializer = elementObject.initializer; } return element; }, toElementFinisherExtras: function (elementObject) { var element = this.toElementDescriptor(elementObject); var finisher = _optionalCallableProperty(elementObject, "finisher"); var extras = this.toElementDescriptors(elementObject.extras); return { element: element, finisher: finisher, extras: extras }; }, fromClassDescriptor: function (elements) { var obj = { kind: "class", elements: elements.map(this.fromElementDescriptor, this) }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); return obj; }, toClassDescriptor: function (obj) { var kind = String(obj.kind); if (kind !== "class") { throw new TypeError('A class descriptor\'s .kind property must be "class", but a decorator' + ' created a class descriptor with .kind "' + kind + '"'); } this.disallowProperty(obj, "key", "A class descriptor"); this.disallowProperty(obj, "placement", "A class descriptor"); this.disallowProperty(obj, "descriptor", "A class descriptor"); this.disallowProperty(obj, "initializer", "A class descriptor"); this.disallowProperty(obj, "extras", "A class descriptor"); var finisher = _optionalCallableProperty(obj, "finisher"); var elements = this.toElementDescriptors(obj.elements); return { elements: elements, finisher: finisher }; }, runClassFinishers: function (constructor, finishers) { for (var i = 0; i < finishers.length; i++) { var newConstructor = (0, finishers[i])(constructor); if (newConstructor !== undefined) { if (typeof newConstructor !== "function") { throw new TypeError("Finishers must return a constructor."); } constructor = newConstructor; } } return constructor; }, disallowProperty: function (obj, name, objectType) { if (obj[name] !== undefined) { throw new TypeError(objectType + " can't have a ." + name + " property."); } } }; return api; }

function _createElementDescriptor(def) { var key = _toPropertyKey(def.key); var descriptor; if (def.kind === "method") { descriptor = { value: def.value, writable: true, configurable: true, enumerable: false }; } else if (def.kind === "get") { descriptor = { get: def.value, configurable: true, enumerable: false }; } else if (def.kind === "set") { descriptor = { set: def.value, configurable: true, enumerable: false }; } else if (def.kind === "field") { descriptor = { configurable: true, writable: true, enumerable: true }; } var element = { kind: def.kind === "field" ? "field" : "method", key: key, placement: def.static ? "static" : def.kind === "field" ? "own" : "prototype", descriptor: descriptor }; if (def.decorators) element.decorators = def.decorators; if (def.kind === "field") element.initializer = def.value; return element; }

function _coalesceGetterSetter(element, other) { if (element.descriptor.get !== undefined) { other.descriptor.get = element.descriptor.get; } else { other.descriptor.set = element.descriptor.set; } }

function _coalesceClassElements(elements) { var newElements = []; var isSameElement = function (other) { return other.kind === "method" && other.key === element.key && other.placement === element.placement; }; for (var i = 0; i < elements.length; i++) { var element = elements[i]; var other; if (element.kind === "method" && (other = newElements.find(isSameElement))) { if (_isDataDescriptor(element.descriptor) || _isDataDescriptor(other.descriptor)) { if (_hasDecorators(element) || _hasDecorators(other)) { throw new ReferenceError("Duplicated methods (" + element.key + ") can't be decorated."); } other.descriptor = element.descriptor; } else { if (_hasDecorators(element)) { if (_hasDecorators(other)) { throw new ReferenceError("Decorators can't be placed on different accessors with for " + "the same property (" + element.key + ")."); } other.decorators = element.decorators; } _coalesceGetterSetter(element, other); } } else { newElements.push(element); } } return newElements; }

function _hasDecorators(element) { return element.decorators && element.decorators.length; }

function _isDataDescriptor(desc) { return desc !== undefined && !(desc.value === undefined && desc.writable === undefined); }

function _optionalCallableProperty(obj, name) { var value = obj[name]; if (value !== undefined && typeof value !== "function") { throw new TypeError("Expected '" + name + "' to be a function"); } return value; }

function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }

function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }

function _toArray(arr) { return _arrayWithHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(n); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }









let HuiSensorEntityRow = _decorate([Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["customElement"])("hui-sensor-entity-row")], function (_initialize, _LitElement) {
  class HuiSensorEntityRow extends _LitElement {
    constructor(...args) {
      super(...args);

      _initialize(this);
    }

  }

  return {
    F: HuiSensorEntityRow,
    d: [{
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "hass",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "_config",
      value: void 0
    }, {
      kind: "method",
      key: "setConfig",
      value: function setConfig(config) {
        if (!config) {
          throw new Error("Configuration error");
        }

        this._config = config;
      }
    }, {
      kind: "method",
      key: "shouldUpdate",
      value: function shouldUpdate(changedProps) {
        return Object(_common_has_changed__WEBPACK_IMPORTED_MODULE_3__["hasConfigOrEntityChanged"])(this, changedProps);
      }
    }, {
      kind: "method",
      key: "render",
      value: function render() {
        if (!this._config || !this.hass) {
          return lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]``;
        }

        const stateObj = this.hass.states[this._config.entity];

        if (!stateObj) {
          return lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
        <hui-warning
          >${this.hass.localize("ui.panel.lovelace.warning.entity_not_found", "entity", this._config.entity)}</hui-warning
        >
      `;
        }

        return lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
      <hui-generic-entity-row .hass=${this.hass} .config=${this._config}>
        <div class="text-content">
          ${stateObj.attributes.device_class === _data_sensor__WEBPACK_IMPORTED_MODULE_2__["SENSOR_DEVICE_CLASS_TIMESTAMP"] && stateObj.state !== "unavailable" && stateObj.state !== "unknown" ? lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
                <hui-timestamp-display
                  .hass=${this.hass}
                  .ts=${new Date(stateObj.state)}
                  .format=${this._config.format}
                ></hui-timestamp-display>
              ` : Object(_common_entity_compute_state_display__WEBPACK_IMPORTED_MODULE_1__["computeStateDisplay"])(this.hass.localize, stateObj, this.hass.language)}
        </div>
      </hui-generic-entity-row>
    `;
      }
    }, {
      kind: "get",
      static: true,
      key: "styles",
      value: function styles() {
        return lit_element__WEBPACK_IMPORTED_MODULE_0__["css"]`
      div {
        text-align: right;
      }
    `;
      }
    }]
  };
}, lit_element__WEBPACK_IMPORTED_MODULE_0__["LitElement"]);

/***/ }),

/***/ "./src/panels/lovelace/entity-rows/hui-text-entity-row.ts":
/*!****************************************************************!*\
  !*** ./src/panels/lovelace/entity-rows/hui-text-entity-row.ts ***!
  \****************************************************************/
/*! no exports provided */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var lit_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lit-element */ "./node_modules/lit-element/lit-element.js");
/* harmony import */ var _common_entity_compute_state_display__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../common/entity/compute_state_display */ "./src/common/entity/compute_state_display.ts");
/* harmony import */ var _common_has_changed__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../common/has-changed */ "./src/panels/lovelace/common/has-changed.ts");
/* harmony import */ var _components_hui_generic_entity_row__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../components/hui-generic-entity-row */ "./src/panels/lovelace/components/hui-generic-entity-row.ts");
/* harmony import */ var _components_hui_warning__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../components/hui-warning */ "./src/panels/lovelace/components/hui-warning.ts");
function _decorate(decorators, factory, superClass, mixins) { var api = _getDecoratorsApi(); if (mixins) { for (var i = 0; i < mixins.length; i++) { api = mixins[i](api); } } var r = factory(function initialize(O) { api.initializeInstanceElements(O, decorated.elements); }, superClass); var decorated = api.decorateClass(_coalesceClassElements(r.d.map(_createElementDescriptor)), decorators); api.initializeClassElements(r.F, decorated.elements); return api.runClassFinishers(r.F, decorated.finishers); }

function _getDecoratorsApi() { _getDecoratorsApi = function () { return api; }; var api = { elementsDefinitionOrder: [["method"], ["field"]], initializeInstanceElements: function (O, elements) { ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { if (element.kind === kind && element.placement === "own") { this.defineClassElement(O, element); } }, this); }, this); }, initializeClassElements: function (F, elements) { var proto = F.prototype; ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { var placement = element.placement; if (element.kind === kind && (placement === "static" || placement === "prototype")) { var receiver = placement === "static" ? F : proto; this.defineClassElement(receiver, element); } }, this); }, this); }, defineClassElement: function (receiver, element) { var descriptor = element.descriptor; if (element.kind === "field") { var initializer = element.initializer; descriptor = { enumerable: descriptor.enumerable, writable: descriptor.writable, configurable: descriptor.configurable, value: initializer === void 0 ? void 0 : initializer.call(receiver) }; } Object.defineProperty(receiver, element.key, descriptor); }, decorateClass: function (elements, decorators) { var newElements = []; var finishers = []; var placements = { static: [], prototype: [], own: [] }; elements.forEach(function (element) { this.addElementPlacement(element, placements); }, this); elements.forEach(function (element) { if (!_hasDecorators(element)) return newElements.push(element); var elementFinishersExtras = this.decorateElement(element, placements); newElements.push(elementFinishersExtras.element); newElements.push.apply(newElements, elementFinishersExtras.extras); finishers.push.apply(finishers, elementFinishersExtras.finishers); }, this); if (!decorators) { return { elements: newElements, finishers: finishers }; } var result = this.decorateConstructor(newElements, decorators); finishers.push.apply(finishers, result.finishers); result.finishers = finishers; return result; }, addElementPlacement: function (element, placements, silent) { var keys = placements[element.placement]; if (!silent && keys.indexOf(element.key) !== -1) { throw new TypeError("Duplicated element (" + element.key + ")"); } keys.push(element.key); }, decorateElement: function (element, placements) { var extras = []; var finishers = []; for (var decorators = element.decorators, i = decorators.length - 1; i >= 0; i--) { var keys = placements[element.placement]; keys.splice(keys.indexOf(element.key), 1); var elementObject = this.fromElementDescriptor(element); var elementFinisherExtras = this.toElementFinisherExtras((0, decorators[i])(elementObject) || elementObject); element = elementFinisherExtras.element; this.addElementPlacement(element, placements); if (elementFinisherExtras.finisher) { finishers.push(elementFinisherExtras.finisher); } var newExtras = elementFinisherExtras.extras; if (newExtras) { for (var j = 0; j < newExtras.length; j++) { this.addElementPlacement(newExtras[j], placements); } extras.push.apply(extras, newExtras); } } return { element: element, finishers: finishers, extras: extras }; }, decorateConstructor: function (elements, decorators) { var finishers = []; for (var i = decorators.length - 1; i >= 0; i--) { var obj = this.fromClassDescriptor(elements); var elementsAndFinisher = this.toClassDescriptor((0, decorators[i])(obj) || obj); if (elementsAndFinisher.finisher !== undefined) { finishers.push(elementsAndFinisher.finisher); } if (elementsAndFinisher.elements !== undefined) { elements = elementsAndFinisher.elements; for (var j = 0; j < elements.length - 1; j++) { for (var k = j + 1; k < elements.length; k++) { if (elements[j].key === elements[k].key && elements[j].placement === elements[k].placement) { throw new TypeError("Duplicated element (" + elements[j].key + ")"); } } } } } return { elements: elements, finishers: finishers }; }, fromElementDescriptor: function (element) { var obj = { kind: element.kind, key: element.key, placement: element.placement, descriptor: element.descriptor }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); if (element.kind === "field") obj.initializer = element.initializer; return obj; }, toElementDescriptors: function (elementObjects) { if (elementObjects === undefined) return; return _toArray(elementObjects).map(function (elementObject) { var element = this.toElementDescriptor(elementObject); this.disallowProperty(elementObject, "finisher", "An element descriptor"); this.disallowProperty(elementObject, "extras", "An element descriptor"); return element; }, this); }, toElementDescriptor: function (elementObject) { var kind = String(elementObject.kind); if (kind !== "method" && kind !== "field") { throw new TypeError('An element descriptor\'s .kind property must be either "method" or' + ' "field", but a decorator created an element descriptor with' + ' .kind "' + kind + '"'); } var key = _toPropertyKey(elementObject.key); var placement = String(elementObject.placement); if (placement !== "static" && placement !== "prototype" && placement !== "own") { throw new TypeError('An element descriptor\'s .placement property must be one of "static",' + ' "prototype" or "own", but a decorator created an element descriptor' + ' with .placement "' + placement + '"'); } var descriptor = elementObject.descriptor; this.disallowProperty(elementObject, "elements", "An element descriptor"); var element = { kind: kind, key: key, placement: placement, descriptor: Object.assign({}, descriptor) }; if (kind !== "field") { this.disallowProperty(elementObject, "initializer", "A method descriptor"); } else { this.disallowProperty(descriptor, "get", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "set", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "value", "The property descriptor of a field descriptor"); element.initializer = elementObject.initializer; } return element; }, toElementFinisherExtras: function (elementObject) { var element = this.toElementDescriptor(elementObject); var finisher = _optionalCallableProperty(elementObject, "finisher"); var extras = this.toElementDescriptors(elementObject.extras); return { element: element, finisher: finisher, extras: extras }; }, fromClassDescriptor: function (elements) { var obj = { kind: "class", elements: elements.map(this.fromElementDescriptor, this) }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); return obj; }, toClassDescriptor: function (obj) { var kind = String(obj.kind); if (kind !== "class") { throw new TypeError('A class descriptor\'s .kind property must be "class", but a decorator' + ' created a class descriptor with .kind "' + kind + '"'); } this.disallowProperty(obj, "key", "A class descriptor"); this.disallowProperty(obj, "placement", "A class descriptor"); this.disallowProperty(obj, "descriptor", "A class descriptor"); this.disallowProperty(obj, "initializer", "A class descriptor"); this.disallowProperty(obj, "extras", "A class descriptor"); var finisher = _optionalCallableProperty(obj, "finisher"); var elements = this.toElementDescriptors(obj.elements); return { elements: elements, finisher: finisher }; }, runClassFinishers: function (constructor, finishers) { for (var i = 0; i < finishers.length; i++) { var newConstructor = (0, finishers[i])(constructor); if (newConstructor !== undefined) { if (typeof newConstructor !== "function") { throw new TypeError("Finishers must return a constructor."); } constructor = newConstructor; } } return constructor; }, disallowProperty: function (obj, name, objectType) { if (obj[name] !== undefined) { throw new TypeError(objectType + " can't have a ." + name + " property."); } } }; return api; }

function _createElementDescriptor(def) { var key = _toPropertyKey(def.key); var descriptor; if (def.kind === "method") { descriptor = { value: def.value, writable: true, configurable: true, enumerable: false }; } else if (def.kind === "get") { descriptor = { get: def.value, configurable: true, enumerable: false }; } else if (def.kind === "set") { descriptor = { set: def.value, configurable: true, enumerable: false }; } else if (def.kind === "field") { descriptor = { configurable: true, writable: true, enumerable: true }; } var element = { kind: def.kind === "field" ? "field" : "method", key: key, placement: def.static ? "static" : def.kind === "field" ? "own" : "prototype", descriptor: descriptor }; if (def.decorators) element.decorators = def.decorators; if (def.kind === "field") element.initializer = def.value; return element; }

function _coalesceGetterSetter(element, other) { if (element.descriptor.get !== undefined) { other.descriptor.get = element.descriptor.get; } else { other.descriptor.set = element.descriptor.set; } }

function _coalesceClassElements(elements) { var newElements = []; var isSameElement = function (other) { return other.kind === "method" && other.key === element.key && other.placement === element.placement; }; for (var i = 0; i < elements.length; i++) { var element = elements[i]; var other; if (element.kind === "method" && (other = newElements.find(isSameElement))) { if (_isDataDescriptor(element.descriptor) || _isDataDescriptor(other.descriptor)) { if (_hasDecorators(element) || _hasDecorators(other)) { throw new ReferenceError("Duplicated methods (" + element.key + ") can't be decorated."); } other.descriptor = element.descriptor; } else { if (_hasDecorators(element)) { if (_hasDecorators(other)) { throw new ReferenceError("Decorators can't be placed on different accessors with for " + "the same property (" + element.key + ")."); } other.decorators = element.decorators; } _coalesceGetterSetter(element, other); } } else { newElements.push(element); } } return newElements; }

function _hasDecorators(element) { return element.decorators && element.decorators.length; }

function _isDataDescriptor(desc) { return desc !== undefined && !(desc.value === undefined && desc.writable === undefined); }

function _optionalCallableProperty(obj, name) { var value = obj[name]; if (value !== undefined && typeof value !== "function") { throw new TypeError("Expected '" + name + "' to be a function"); } return value; }

function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }

function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }

function _toArray(arr) { return _arrayWithHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(n); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }







let HuiTextEntityRow = _decorate([Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["customElement"])("hui-text-entity-row")], function (_initialize, _LitElement) {
  class HuiTextEntityRow extends _LitElement {
    constructor(...args) {
      super(...args);

      _initialize(this);
    }

  }

  return {
    F: HuiTextEntityRow,
    d: [{
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "hass",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "_config",
      value: void 0
    }, {
      kind: "method",
      key: "setConfig",
      value: function setConfig(config) {
        if (!config) {
          throw new Error("Configuration error");
        }

        this._config = config;
      }
    }, {
      kind: "method",
      key: "shouldUpdate",
      value: function shouldUpdate(changedProps) {
        return Object(_common_has_changed__WEBPACK_IMPORTED_MODULE_2__["hasConfigOrEntityChanged"])(this, changedProps);
      }
    }, {
      kind: "method",
      key: "render",
      value: function render() {
        if (!this._config || !this.hass) {
          return lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]``;
        }

        const stateObj = this.hass.states[this._config.entity];

        if (!stateObj) {
          return lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
        <hui-warning
          >${this.hass.localize("ui.panel.lovelace.warning.entity_not_found", "entity", this._config.entity)}</hui-warning
        >
      `;
        }

        return lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
      <hui-generic-entity-row .hass=${this.hass} .config=${this._config}>
        <div class="text-content">
          ${Object(_common_entity_compute_state_display__WEBPACK_IMPORTED_MODULE_1__["computeStateDisplay"])(this.hass.localize, stateObj, this.hass.language)}
        </div>
      </hui-generic-entity-row>
    `;
      }
    }, {
      kind: "get",
      static: true,
      key: "styles",
      value: function styles() {
        return lit_element__WEBPACK_IMPORTED_MODULE_0__["css"]`
      div {
        text-align: right;
      }
    `;
      }
    }]
  };
}, lit_element__WEBPACK_IMPORTED_MODULE_0__["LitElement"]);

/***/ }),

/***/ "./src/panels/lovelace/entity-rows/hui-toggle-entity-row.ts":
/*!******************************************************************!*\
  !*** ./src/panels/lovelace/entity-rows/hui-toggle-entity-row.ts ***!
  \******************************************************************/
/*! no exports provided */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var lit_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lit-element */ "./node_modules/lit-element/lit-element.js");
/* harmony import */ var _common_entity_compute_state_display__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../common/entity/compute_state_display */ "./src/common/entity/compute_state_display.ts");
/* harmony import */ var _components_entity_ha_entity_toggle__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../components/entity/ha-entity-toggle */ "./src/components/entity/ha-entity-toggle.ts");
/* harmony import */ var _data_entity__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../data/entity */ "./src/data/entity.ts");
/* harmony import */ var _common_has_changed__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../common/has-changed */ "./src/panels/lovelace/common/has-changed.ts");
/* harmony import */ var _components_hui_generic_entity_row__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../components/hui-generic-entity-row */ "./src/panels/lovelace/components/hui-generic-entity-row.ts");
/* harmony import */ var _components_hui_warning__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../components/hui-warning */ "./src/panels/lovelace/components/hui-warning.ts");
function _decorate(decorators, factory, superClass, mixins) { var api = _getDecoratorsApi(); if (mixins) { for (var i = 0; i < mixins.length; i++) { api = mixins[i](api); } } var r = factory(function initialize(O) { api.initializeInstanceElements(O, decorated.elements); }, superClass); var decorated = api.decorateClass(_coalesceClassElements(r.d.map(_createElementDescriptor)), decorators); api.initializeClassElements(r.F, decorated.elements); return api.runClassFinishers(r.F, decorated.finishers); }

function _getDecoratorsApi() { _getDecoratorsApi = function () { return api; }; var api = { elementsDefinitionOrder: [["method"], ["field"]], initializeInstanceElements: function (O, elements) { ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { if (element.kind === kind && element.placement === "own") { this.defineClassElement(O, element); } }, this); }, this); }, initializeClassElements: function (F, elements) { var proto = F.prototype; ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { var placement = element.placement; if (element.kind === kind && (placement === "static" || placement === "prototype")) { var receiver = placement === "static" ? F : proto; this.defineClassElement(receiver, element); } }, this); }, this); }, defineClassElement: function (receiver, element) { var descriptor = element.descriptor; if (element.kind === "field") { var initializer = element.initializer; descriptor = { enumerable: descriptor.enumerable, writable: descriptor.writable, configurable: descriptor.configurable, value: initializer === void 0 ? void 0 : initializer.call(receiver) }; } Object.defineProperty(receiver, element.key, descriptor); }, decorateClass: function (elements, decorators) { var newElements = []; var finishers = []; var placements = { static: [], prototype: [], own: [] }; elements.forEach(function (element) { this.addElementPlacement(element, placements); }, this); elements.forEach(function (element) { if (!_hasDecorators(element)) return newElements.push(element); var elementFinishersExtras = this.decorateElement(element, placements); newElements.push(elementFinishersExtras.element); newElements.push.apply(newElements, elementFinishersExtras.extras); finishers.push.apply(finishers, elementFinishersExtras.finishers); }, this); if (!decorators) { return { elements: newElements, finishers: finishers }; } var result = this.decorateConstructor(newElements, decorators); finishers.push.apply(finishers, result.finishers); result.finishers = finishers; return result; }, addElementPlacement: function (element, placements, silent) { var keys = placements[element.placement]; if (!silent && keys.indexOf(element.key) !== -1) { throw new TypeError("Duplicated element (" + element.key + ")"); } keys.push(element.key); }, decorateElement: function (element, placements) { var extras = []; var finishers = []; for (var decorators = element.decorators, i = decorators.length - 1; i >= 0; i--) { var keys = placements[element.placement]; keys.splice(keys.indexOf(element.key), 1); var elementObject = this.fromElementDescriptor(element); var elementFinisherExtras = this.toElementFinisherExtras((0, decorators[i])(elementObject) || elementObject); element = elementFinisherExtras.element; this.addElementPlacement(element, placements); if (elementFinisherExtras.finisher) { finishers.push(elementFinisherExtras.finisher); } var newExtras = elementFinisherExtras.extras; if (newExtras) { for (var j = 0; j < newExtras.length; j++) { this.addElementPlacement(newExtras[j], placements); } extras.push.apply(extras, newExtras); } } return { element: element, finishers: finishers, extras: extras }; }, decorateConstructor: function (elements, decorators) { var finishers = []; for (var i = decorators.length - 1; i >= 0; i--) { var obj = this.fromClassDescriptor(elements); var elementsAndFinisher = this.toClassDescriptor((0, decorators[i])(obj) || obj); if (elementsAndFinisher.finisher !== undefined) { finishers.push(elementsAndFinisher.finisher); } if (elementsAndFinisher.elements !== undefined) { elements = elementsAndFinisher.elements; for (var j = 0; j < elements.length - 1; j++) { for (var k = j + 1; k < elements.length; k++) { if (elements[j].key === elements[k].key && elements[j].placement === elements[k].placement) { throw new TypeError("Duplicated element (" + elements[j].key + ")"); } } } } } return { elements: elements, finishers: finishers }; }, fromElementDescriptor: function (element) { var obj = { kind: element.kind, key: element.key, placement: element.placement, descriptor: element.descriptor }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); if (element.kind === "field") obj.initializer = element.initializer; return obj; }, toElementDescriptors: function (elementObjects) { if (elementObjects === undefined) return; return _toArray(elementObjects).map(function (elementObject) { var element = this.toElementDescriptor(elementObject); this.disallowProperty(elementObject, "finisher", "An element descriptor"); this.disallowProperty(elementObject, "extras", "An element descriptor"); return element; }, this); }, toElementDescriptor: function (elementObject) { var kind = String(elementObject.kind); if (kind !== "method" && kind !== "field") { throw new TypeError('An element descriptor\'s .kind property must be either "method" or' + ' "field", but a decorator created an element descriptor with' + ' .kind "' + kind + '"'); } var key = _toPropertyKey(elementObject.key); var placement = String(elementObject.placement); if (placement !== "static" && placement !== "prototype" && placement !== "own") { throw new TypeError('An element descriptor\'s .placement property must be one of "static",' + ' "prototype" or "own", but a decorator created an element descriptor' + ' with .placement "' + placement + '"'); } var descriptor = elementObject.descriptor; this.disallowProperty(elementObject, "elements", "An element descriptor"); var element = { kind: kind, key: key, placement: placement, descriptor: Object.assign({}, descriptor) }; if (kind !== "field") { this.disallowProperty(elementObject, "initializer", "A method descriptor"); } else { this.disallowProperty(descriptor, "get", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "set", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "value", "The property descriptor of a field descriptor"); element.initializer = elementObject.initializer; } return element; }, toElementFinisherExtras: function (elementObject) { var element = this.toElementDescriptor(elementObject); var finisher = _optionalCallableProperty(elementObject, "finisher"); var extras = this.toElementDescriptors(elementObject.extras); return { element: element, finisher: finisher, extras: extras }; }, fromClassDescriptor: function (elements) { var obj = { kind: "class", elements: elements.map(this.fromElementDescriptor, this) }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); return obj; }, toClassDescriptor: function (obj) { var kind = String(obj.kind); if (kind !== "class") { throw new TypeError('A class descriptor\'s .kind property must be "class", but a decorator' + ' created a class descriptor with .kind "' + kind + '"'); } this.disallowProperty(obj, "key", "A class descriptor"); this.disallowProperty(obj, "placement", "A class descriptor"); this.disallowProperty(obj, "descriptor", "A class descriptor"); this.disallowProperty(obj, "initializer", "A class descriptor"); this.disallowProperty(obj, "extras", "A class descriptor"); var finisher = _optionalCallableProperty(obj, "finisher"); var elements = this.toElementDescriptors(obj.elements); return { elements: elements, finisher: finisher }; }, runClassFinishers: function (constructor, finishers) { for (var i = 0; i < finishers.length; i++) { var newConstructor = (0, finishers[i])(constructor); if (newConstructor !== undefined) { if (typeof newConstructor !== "function") { throw new TypeError("Finishers must return a constructor."); } constructor = newConstructor; } } return constructor; }, disallowProperty: function (obj, name, objectType) { if (obj[name] !== undefined) { throw new TypeError(objectType + " can't have a ." + name + " property."); } } }; return api; }

function _createElementDescriptor(def) { var key = _toPropertyKey(def.key); var descriptor; if (def.kind === "method") { descriptor = { value: def.value, writable: true, configurable: true, enumerable: false }; } else if (def.kind === "get") { descriptor = { get: def.value, configurable: true, enumerable: false }; } else if (def.kind === "set") { descriptor = { set: def.value, configurable: true, enumerable: false }; } else if (def.kind === "field") { descriptor = { configurable: true, writable: true, enumerable: true }; } var element = { kind: def.kind === "field" ? "field" : "method", key: key, placement: def.static ? "static" : def.kind === "field" ? "own" : "prototype", descriptor: descriptor }; if (def.decorators) element.decorators = def.decorators; if (def.kind === "field") element.initializer = def.value; return element; }

function _coalesceGetterSetter(element, other) { if (element.descriptor.get !== undefined) { other.descriptor.get = element.descriptor.get; } else { other.descriptor.set = element.descriptor.set; } }

function _coalesceClassElements(elements) { var newElements = []; var isSameElement = function (other) { return other.kind === "method" && other.key === element.key && other.placement === element.placement; }; for (var i = 0; i < elements.length; i++) { var element = elements[i]; var other; if (element.kind === "method" && (other = newElements.find(isSameElement))) { if (_isDataDescriptor(element.descriptor) || _isDataDescriptor(other.descriptor)) { if (_hasDecorators(element) || _hasDecorators(other)) { throw new ReferenceError("Duplicated methods (" + element.key + ") can't be decorated."); } other.descriptor = element.descriptor; } else { if (_hasDecorators(element)) { if (_hasDecorators(other)) { throw new ReferenceError("Decorators can't be placed on different accessors with for " + "the same property (" + element.key + ")."); } other.decorators = element.decorators; } _coalesceGetterSetter(element, other); } } else { newElements.push(element); } } return newElements; }

function _hasDecorators(element) { return element.decorators && element.decorators.length; }

function _isDataDescriptor(desc) { return desc !== undefined && !(desc.value === undefined && desc.writable === undefined); }

function _optionalCallableProperty(obj, name) { var value = obj[name]; if (value !== undefined && typeof value !== "function") { throw new TypeError("Expected '" + name + "' to be a function"); } return value; }

function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }

function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }

function _toArray(arr) { return _arrayWithHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(n); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }









let HuiToggleEntityRow = _decorate([Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["customElement"])("hui-toggle-entity-row")], function (_initialize, _LitElement) {
  class HuiToggleEntityRow extends _LitElement {
    constructor(...args) {
      super(...args);

      _initialize(this);
    }

  }

  return {
    F: HuiToggleEntityRow,
    d: [{
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "hass",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "_config",
      value: void 0
    }, {
      kind: "method",
      key: "setConfig",
      value: function setConfig(config) {
        if (!config) {
          throw new Error("Configuration error");
        }

        this._config = config;
      }
    }, {
      kind: "method",
      key: "shouldUpdate",
      value: function shouldUpdate(changedProps) {
        return Object(_common_has_changed__WEBPACK_IMPORTED_MODULE_4__["hasConfigOrEntityChanged"])(this, changedProps);
      }
    }, {
      kind: "method",
      key: "render",
      value: function render() {
        if (!this._config || !this.hass) {
          return lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]``;
        }

        const stateObj = this.hass.states[this._config.entity];

        if (!stateObj) {
          return lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
        <hui-warning
          >${this.hass.localize("ui.panel.lovelace.warning.entity_not_found", "entity", this._config.entity)}</hui-warning
        >
      `;
        }

        return lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
      <hui-generic-entity-row .hass=${this.hass} .config=${this._config}>
        ${stateObj.state === "on" || stateObj.state === "off" || _data_entity__WEBPACK_IMPORTED_MODULE_3__["UNAVAILABLE_STATES"].includes(stateObj.state) ? lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
              <ha-entity-toggle
                .hass=${this.hass}
                .stateObj=${stateObj}
              ></ha-entity-toggle>
            ` : lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
              <div class="text-content">
                ${Object(_common_entity_compute_state_display__WEBPACK_IMPORTED_MODULE_1__["computeStateDisplay"])(this.hass.localize, stateObj, this.hass.language)}
              </div>
            `}
      </hui-generic-entity-row>
    `;
      }
    }]
  };
}, lit_element__WEBPACK_IMPORTED_MODULE_0__["LitElement"]);

/***/ }),

/***/ "./src/panels/lovelace/special-rows/hui-attribute-row.ts":
/*!***************************************************************!*\
  !*** ./src/panels/lovelace/special-rows/hui-attribute-row.ts ***!
  \***************************************************************/
/*! no exports provided */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var lit_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lit-element */ "./node_modules/lit-element/lit-element.js");
/* harmony import */ var _common_has_changed__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../common/has-changed */ "./src/panels/lovelace/common/has-changed.ts");
/* harmony import */ var _components_hui_generic_entity_row__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../components/hui-generic-entity-row */ "./src/panels/lovelace/components/hui-generic-entity-row.ts");
/* harmony import */ var _components_hui_warning__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../components/hui-warning */ "./src/panels/lovelace/components/hui-warning.ts");
function _decorate(decorators, factory, superClass, mixins) { var api = _getDecoratorsApi(); if (mixins) { for (var i = 0; i < mixins.length; i++) { api = mixins[i](api); } } var r = factory(function initialize(O) { api.initializeInstanceElements(O, decorated.elements); }, superClass); var decorated = api.decorateClass(_coalesceClassElements(r.d.map(_createElementDescriptor)), decorators); api.initializeClassElements(r.F, decorated.elements); return api.runClassFinishers(r.F, decorated.finishers); }

function _getDecoratorsApi() { _getDecoratorsApi = function () { return api; }; var api = { elementsDefinitionOrder: [["method"], ["field"]], initializeInstanceElements: function (O, elements) { ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { if (element.kind === kind && element.placement === "own") { this.defineClassElement(O, element); } }, this); }, this); }, initializeClassElements: function (F, elements) { var proto = F.prototype; ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { var placement = element.placement; if (element.kind === kind && (placement === "static" || placement === "prototype")) { var receiver = placement === "static" ? F : proto; this.defineClassElement(receiver, element); } }, this); }, this); }, defineClassElement: function (receiver, element) { var descriptor = element.descriptor; if (element.kind === "field") { var initializer = element.initializer; descriptor = { enumerable: descriptor.enumerable, writable: descriptor.writable, configurable: descriptor.configurable, value: initializer === void 0 ? void 0 : initializer.call(receiver) }; } Object.defineProperty(receiver, element.key, descriptor); }, decorateClass: function (elements, decorators) { var newElements = []; var finishers = []; var placements = { static: [], prototype: [], own: [] }; elements.forEach(function (element) { this.addElementPlacement(element, placements); }, this); elements.forEach(function (element) { if (!_hasDecorators(element)) return newElements.push(element); var elementFinishersExtras = this.decorateElement(element, placements); newElements.push(elementFinishersExtras.element); newElements.push.apply(newElements, elementFinishersExtras.extras); finishers.push.apply(finishers, elementFinishersExtras.finishers); }, this); if (!decorators) { return { elements: newElements, finishers: finishers }; } var result = this.decorateConstructor(newElements, decorators); finishers.push.apply(finishers, result.finishers); result.finishers = finishers; return result; }, addElementPlacement: function (element, placements, silent) { var keys = placements[element.placement]; if (!silent && keys.indexOf(element.key) !== -1) { throw new TypeError("Duplicated element (" + element.key + ")"); } keys.push(element.key); }, decorateElement: function (element, placements) { var extras = []; var finishers = []; for (var decorators = element.decorators, i = decorators.length - 1; i >= 0; i--) { var keys = placements[element.placement]; keys.splice(keys.indexOf(element.key), 1); var elementObject = this.fromElementDescriptor(element); var elementFinisherExtras = this.toElementFinisherExtras((0, decorators[i])(elementObject) || elementObject); element = elementFinisherExtras.element; this.addElementPlacement(element, placements); if (elementFinisherExtras.finisher) { finishers.push(elementFinisherExtras.finisher); } var newExtras = elementFinisherExtras.extras; if (newExtras) { for (var j = 0; j < newExtras.length; j++) { this.addElementPlacement(newExtras[j], placements); } extras.push.apply(extras, newExtras); } } return { element: element, finishers: finishers, extras: extras }; }, decorateConstructor: function (elements, decorators) { var finishers = []; for (var i = decorators.length - 1; i >= 0; i--) { var obj = this.fromClassDescriptor(elements); var elementsAndFinisher = this.toClassDescriptor((0, decorators[i])(obj) || obj); if (elementsAndFinisher.finisher !== undefined) { finishers.push(elementsAndFinisher.finisher); } if (elementsAndFinisher.elements !== undefined) { elements = elementsAndFinisher.elements; for (var j = 0; j < elements.length - 1; j++) { for (var k = j + 1; k < elements.length; k++) { if (elements[j].key === elements[k].key && elements[j].placement === elements[k].placement) { throw new TypeError("Duplicated element (" + elements[j].key + ")"); } } } } } return { elements: elements, finishers: finishers }; }, fromElementDescriptor: function (element) { var obj = { kind: element.kind, key: element.key, placement: element.placement, descriptor: element.descriptor }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); if (element.kind === "field") obj.initializer = element.initializer; return obj; }, toElementDescriptors: function (elementObjects) { if (elementObjects === undefined) return; return _toArray(elementObjects).map(function (elementObject) { var element = this.toElementDescriptor(elementObject); this.disallowProperty(elementObject, "finisher", "An element descriptor"); this.disallowProperty(elementObject, "extras", "An element descriptor"); return element; }, this); }, toElementDescriptor: function (elementObject) { var kind = String(elementObject.kind); if (kind !== "method" && kind !== "field") { throw new TypeError('An element descriptor\'s .kind property must be either "method" or' + ' "field", but a decorator created an element descriptor with' + ' .kind "' + kind + '"'); } var key = _toPropertyKey(elementObject.key); var placement = String(elementObject.placement); if (placement !== "static" && placement !== "prototype" && placement !== "own") { throw new TypeError('An element descriptor\'s .placement property must be one of "static",' + ' "prototype" or "own", but a decorator created an element descriptor' + ' with .placement "' + placement + '"'); } var descriptor = elementObject.descriptor; this.disallowProperty(elementObject, "elements", "An element descriptor"); var element = { kind: kind, key: key, placement: placement, descriptor: Object.assign({}, descriptor) }; if (kind !== "field") { this.disallowProperty(elementObject, "initializer", "A method descriptor"); } else { this.disallowProperty(descriptor, "get", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "set", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "value", "The property descriptor of a field descriptor"); element.initializer = elementObject.initializer; } return element; }, toElementFinisherExtras: function (elementObject) { var element = this.toElementDescriptor(elementObject); var finisher = _optionalCallableProperty(elementObject, "finisher"); var extras = this.toElementDescriptors(elementObject.extras); return { element: element, finisher: finisher, extras: extras }; }, fromClassDescriptor: function (elements) { var obj = { kind: "class", elements: elements.map(this.fromElementDescriptor, this) }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); return obj; }, toClassDescriptor: function (obj) { var kind = String(obj.kind); if (kind !== "class") { throw new TypeError('A class descriptor\'s .kind property must be "class", but a decorator' + ' created a class descriptor with .kind "' + kind + '"'); } this.disallowProperty(obj, "key", "A class descriptor"); this.disallowProperty(obj, "placement", "A class descriptor"); this.disallowProperty(obj, "descriptor", "A class descriptor"); this.disallowProperty(obj, "initializer", "A class descriptor"); this.disallowProperty(obj, "extras", "A class descriptor"); var finisher = _optionalCallableProperty(obj, "finisher"); var elements = this.toElementDescriptors(obj.elements); return { elements: elements, finisher: finisher }; }, runClassFinishers: function (constructor, finishers) { for (var i = 0; i < finishers.length; i++) { var newConstructor = (0, finishers[i])(constructor); if (newConstructor !== undefined) { if (typeof newConstructor !== "function") { throw new TypeError("Finishers must return a constructor."); } constructor = newConstructor; } } return constructor; }, disallowProperty: function (obj, name, objectType) { if (obj[name] !== undefined) { throw new TypeError(objectType + " can't have a ." + name + " property."); } } }; return api; }

function _createElementDescriptor(def) { var key = _toPropertyKey(def.key); var descriptor; if (def.kind === "method") { descriptor = { value: def.value, writable: true, configurable: true, enumerable: false }; } else if (def.kind === "get") { descriptor = { get: def.value, configurable: true, enumerable: false }; } else if (def.kind === "set") { descriptor = { set: def.value, configurable: true, enumerable: false }; } else if (def.kind === "field") { descriptor = { configurable: true, writable: true, enumerable: true }; } var element = { kind: def.kind === "field" ? "field" : "method", key: key, placement: def.static ? "static" : def.kind === "field" ? "own" : "prototype", descriptor: descriptor }; if (def.decorators) element.decorators = def.decorators; if (def.kind === "field") element.initializer = def.value; return element; }

function _coalesceGetterSetter(element, other) { if (element.descriptor.get !== undefined) { other.descriptor.get = element.descriptor.get; } else { other.descriptor.set = element.descriptor.set; } }

function _coalesceClassElements(elements) { var newElements = []; var isSameElement = function (other) { return other.kind === "method" && other.key === element.key && other.placement === element.placement; }; for (var i = 0; i < elements.length; i++) { var element = elements[i]; var other; if (element.kind === "method" && (other = newElements.find(isSameElement))) { if (_isDataDescriptor(element.descriptor) || _isDataDescriptor(other.descriptor)) { if (_hasDecorators(element) || _hasDecorators(other)) { throw new ReferenceError("Duplicated methods (" + element.key + ") can't be decorated."); } other.descriptor = element.descriptor; } else { if (_hasDecorators(element)) { if (_hasDecorators(other)) { throw new ReferenceError("Decorators can't be placed on different accessors with for " + "the same property (" + element.key + ")."); } other.decorators = element.decorators; } _coalesceGetterSetter(element, other); } } else { newElements.push(element); } } return newElements; }

function _hasDecorators(element) { return element.decorators && element.decorators.length; }

function _isDataDescriptor(desc) { return desc !== undefined && !(desc.value === undefined && desc.writable === undefined); }

function _optionalCallableProperty(obj, name) { var value = obj[name]; if (value !== undefined && typeof value !== "function") { throw new TypeError("Expected '" + name + "' to be a function"); } return value; }

function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }

function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }

function _toArray(arr) { return _arrayWithHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(n); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }






let HuiAttributeRow = _decorate([Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["customElement"])("hui-attribute-row")], function (_initialize, _LitElement) {
  class HuiAttributeRow extends _LitElement {
    constructor(...args) {
      super(...args);

      _initialize(this);
    }

  }

  return {
    F: HuiAttributeRow,
    d: [{
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "hass",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["property"])()],
      key: "_config",
      value: void 0
    }, {
      kind: "method",
      key: "setConfig",
      value: function setConfig(config) {
        if (!config) {
          throw new Error("Configuration error");
        }

        if (!config.entity) {
          throw new Error("Entity not defined");
        }

        if (!config.attribute) {
          throw new Error("Attribute not defined");
        }

        this._config = config;
      }
    }, {
      kind: "method",
      key: "shouldUpdate",
      value: function shouldUpdate(changedProps) {
        return Object(_common_has_changed__WEBPACK_IMPORTED_MODULE_1__["hasConfigOrEntityChanged"])(this, changedProps);
      }
    }, {
      kind: "method",
      key: "render",
      value: function render() {
        if (!this._config || !this.hass) {
          return lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]``;
        }

        const stateObj = this.hass.states[this._config.entity];
        const attribute = stateObj.attributes[this._config.attribute];

        if (!stateObj) {
          return lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
        <hui-warning
          >${this.hass.localize("ui.panel.lovelace.warning.entity_not_found", "entity", this._config.entity)}</hui-warning
        >
      `;
        }

        return lit_element__WEBPACK_IMPORTED_MODULE_0__["html"]`
      <hui-generic-entity-row .hass=${this.hass} .config=${this._config}>
        <div>
          ${this._config.prefix} ${attribute || "-"} ${this._config.suffix}
        </div>
      </hui-generic-entity-row>
    `;
      }
    }, {
      kind: "get",
      static: true,
      key: "styles",
      value: function styles() {
        return lit_element__WEBPACK_IMPORTED_MODULE_0__["css"]`
      div {
        text-align: right;
      }
    `;
      }
    }]
  };
}, lit_element__WEBPACK_IMPORTED_MODULE_0__["LitElement"]);

/***/ }),

/***/ "./src/panels/lovelace/special-rows/hui-button-row.ts":
/*!************************************************************!*\
  !*** ./src/panels/lovelace/special-rows/hui-button-row.ts ***!
  \************************************************************/
/*! exports provided: HuiButtonRow */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HuiButtonRow", function() { return HuiButtonRow; });
/* harmony import */ var _material_mwc_button__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @material/mwc-button */ "./node_modules/@material/mwc-button/mwc-button.js");
/* harmony import */ var lit_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lit-element */ "./node_modules/lit-element/lit-element.js");
/* harmony import */ var _components_ha_icon__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../components/ha-icon */ "./src/components/ha-icon.ts");
/* harmony import */ var _common_directives_action_handler_directive__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../common/directives/action-handler-directive */ "./src/panels/lovelace/common/directives/action-handler-directive.ts");
/* harmony import */ var _common_handle_action__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../common/handle-action */ "./src/panels/lovelace/common/handle-action.ts");
/* harmony import */ var _common_has_action__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../common/has-action */ "./src/panels/lovelace/common/has-action.ts");
function _decorate(decorators, factory, superClass, mixins) { var api = _getDecoratorsApi(); if (mixins) { for (var i = 0; i < mixins.length; i++) { api = mixins[i](api); } } var r = factory(function initialize(O) { api.initializeInstanceElements(O, decorated.elements); }, superClass); var decorated = api.decorateClass(_coalesceClassElements(r.d.map(_createElementDescriptor)), decorators); api.initializeClassElements(r.F, decorated.elements); return api.runClassFinishers(r.F, decorated.finishers); }

function _getDecoratorsApi() { _getDecoratorsApi = function () { return api; }; var api = { elementsDefinitionOrder: [["method"], ["field"]], initializeInstanceElements: function (O, elements) { ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { if (element.kind === kind && element.placement === "own") { this.defineClassElement(O, element); } }, this); }, this); }, initializeClassElements: function (F, elements) { var proto = F.prototype; ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { var placement = element.placement; if (element.kind === kind && (placement === "static" || placement === "prototype")) { var receiver = placement === "static" ? F : proto; this.defineClassElement(receiver, element); } }, this); }, this); }, defineClassElement: function (receiver, element) { var descriptor = element.descriptor; if (element.kind === "field") { var initializer = element.initializer; descriptor = { enumerable: descriptor.enumerable, writable: descriptor.writable, configurable: descriptor.configurable, value: initializer === void 0 ? void 0 : initializer.call(receiver) }; } Object.defineProperty(receiver, element.key, descriptor); }, decorateClass: function (elements, decorators) { var newElements = []; var finishers = []; var placements = { static: [], prototype: [], own: [] }; elements.forEach(function (element) { this.addElementPlacement(element, placements); }, this); elements.forEach(function (element) { if (!_hasDecorators(element)) return newElements.push(element); var elementFinishersExtras = this.decorateElement(element, placements); newElements.push(elementFinishersExtras.element); newElements.push.apply(newElements, elementFinishersExtras.extras); finishers.push.apply(finishers, elementFinishersExtras.finishers); }, this); if (!decorators) { return { elements: newElements, finishers: finishers }; } var result = this.decorateConstructor(newElements, decorators); finishers.push.apply(finishers, result.finishers); result.finishers = finishers; return result; }, addElementPlacement: function (element, placements, silent) { var keys = placements[element.placement]; if (!silent && keys.indexOf(element.key) !== -1) { throw new TypeError("Duplicated element (" + element.key + ")"); } keys.push(element.key); }, decorateElement: function (element, placements) { var extras = []; var finishers = []; for (var decorators = element.decorators, i = decorators.length - 1; i >= 0; i--) { var keys = placements[element.placement]; keys.splice(keys.indexOf(element.key), 1); var elementObject = this.fromElementDescriptor(element); var elementFinisherExtras = this.toElementFinisherExtras((0, decorators[i])(elementObject) || elementObject); element = elementFinisherExtras.element; this.addElementPlacement(element, placements); if (elementFinisherExtras.finisher) { finishers.push(elementFinisherExtras.finisher); } var newExtras = elementFinisherExtras.extras; if (newExtras) { for (var j = 0; j < newExtras.length; j++) { this.addElementPlacement(newExtras[j], placements); } extras.push.apply(extras, newExtras); } } return { element: element, finishers: finishers, extras: extras }; }, decorateConstructor: function (elements, decorators) { var finishers = []; for (var i = decorators.length - 1; i >= 0; i--) { var obj = this.fromClassDescriptor(elements); var elementsAndFinisher = this.toClassDescriptor((0, decorators[i])(obj) || obj); if (elementsAndFinisher.finisher !== undefined) { finishers.push(elementsAndFinisher.finisher); } if (elementsAndFinisher.elements !== undefined) { elements = elementsAndFinisher.elements; for (var j = 0; j < elements.length - 1; j++) { for (var k = j + 1; k < elements.length; k++) { if (elements[j].key === elements[k].key && elements[j].placement === elements[k].placement) { throw new TypeError("Duplicated element (" + elements[j].key + ")"); } } } } } return { elements: elements, finishers: finishers }; }, fromElementDescriptor: function (element) { var obj = { kind: element.kind, key: element.key, placement: element.placement, descriptor: element.descriptor }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); if (element.kind === "field") obj.initializer = element.initializer; return obj; }, toElementDescriptors: function (elementObjects) { if (elementObjects === undefined) return; return _toArray(elementObjects).map(function (elementObject) { var element = this.toElementDescriptor(elementObject); this.disallowProperty(elementObject, "finisher", "An element descriptor"); this.disallowProperty(elementObject, "extras", "An element descriptor"); return element; }, this); }, toElementDescriptor: function (elementObject) { var kind = String(elementObject.kind); if (kind !== "method" && kind !== "field") { throw new TypeError('An element descriptor\'s .kind property must be either "method" or' + ' "field", but a decorator created an element descriptor with' + ' .kind "' + kind + '"'); } var key = _toPropertyKey(elementObject.key); var placement = String(elementObject.placement); if (placement !== "static" && placement !== "prototype" && placement !== "own") { throw new TypeError('An element descriptor\'s .placement property must be one of "static",' + ' "prototype" or "own", but a decorator created an element descriptor' + ' with .placement "' + placement + '"'); } var descriptor = elementObject.descriptor; this.disallowProperty(elementObject, "elements", "An element descriptor"); var element = { kind: kind, key: key, placement: placement, descriptor: Object.assign({}, descriptor) }; if (kind !== "field") { this.disallowProperty(elementObject, "initializer", "A method descriptor"); } else { this.disallowProperty(descriptor, "get", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "set", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "value", "The property descriptor of a field descriptor"); element.initializer = elementObject.initializer; } return element; }, toElementFinisherExtras: function (elementObject) { var element = this.toElementDescriptor(elementObject); var finisher = _optionalCallableProperty(elementObject, "finisher"); var extras = this.toElementDescriptors(elementObject.extras); return { element: element, finisher: finisher, extras: extras }; }, fromClassDescriptor: function (elements) { var obj = { kind: "class", elements: elements.map(this.fromElementDescriptor, this) }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); return obj; }, toClassDescriptor: function (obj) { var kind = String(obj.kind); if (kind !== "class") { throw new TypeError('A class descriptor\'s .kind property must be "class", but a decorator' + ' created a class descriptor with .kind "' + kind + '"'); } this.disallowProperty(obj, "key", "A class descriptor"); this.disallowProperty(obj, "placement", "A class descriptor"); this.disallowProperty(obj, "descriptor", "A class descriptor"); this.disallowProperty(obj, "initializer", "A class descriptor"); this.disallowProperty(obj, "extras", "A class descriptor"); var finisher = _optionalCallableProperty(obj, "finisher"); var elements = this.toElementDescriptors(obj.elements); return { elements: elements, finisher: finisher }; }, runClassFinishers: function (constructor, finishers) { for (var i = 0; i < finishers.length; i++) { var newConstructor = (0, finishers[i])(constructor); if (newConstructor !== undefined) { if (typeof newConstructor !== "function") { throw new TypeError("Finishers must return a constructor."); } constructor = newConstructor; } } return constructor; }, disallowProperty: function (obj, name, objectType) { if (obj[name] !== undefined) { throw new TypeError(objectType + " can't have a ." + name + " property."); } } }; return api; }

function _createElementDescriptor(def) { var key = _toPropertyKey(def.key); var descriptor; if (def.kind === "method") { descriptor = { value: def.value, writable: true, configurable: true, enumerable: false }; } else if (def.kind === "get") { descriptor = { get: def.value, configurable: true, enumerable: false }; } else if (def.kind === "set") { descriptor = { set: def.value, configurable: true, enumerable: false }; } else if (def.kind === "field") { descriptor = { configurable: true, writable: true, enumerable: true }; } var element = { kind: def.kind === "field" ? "field" : "method", key: key, placement: def.static ? "static" : def.kind === "field" ? "own" : "prototype", descriptor: descriptor }; if (def.decorators) element.decorators = def.decorators; if (def.kind === "field") element.initializer = def.value; return element; }

function _coalesceGetterSetter(element, other) { if (element.descriptor.get !== undefined) { other.descriptor.get = element.descriptor.get; } else { other.descriptor.set = element.descriptor.set; } }

function _coalesceClassElements(elements) { var newElements = []; var isSameElement = function (other) { return other.kind === "method" && other.key === element.key && other.placement === element.placement; }; for (var i = 0; i < elements.length; i++) { var element = elements[i]; var other; if (element.kind === "method" && (other = newElements.find(isSameElement))) { if (_isDataDescriptor(element.descriptor) || _isDataDescriptor(other.descriptor)) { if (_hasDecorators(element) || _hasDecorators(other)) { throw new ReferenceError("Duplicated methods (" + element.key + ") can't be decorated."); } other.descriptor = element.descriptor; } else { if (_hasDecorators(element)) { if (_hasDecorators(other)) { throw new ReferenceError("Decorators can't be placed on different accessors with for " + "the same property (" + element.key + ")."); } other.decorators = element.decorators; } _coalesceGetterSetter(element, other); } } else { newElements.push(element); } } return newElements; }

function _hasDecorators(element) { return element.decorators && element.decorators.length; }

function _isDataDescriptor(desc) { return desc !== undefined && !(desc.value === undefined && desc.writable === undefined); }

function _optionalCallableProperty(obj, name) { var value = obj[name]; if (value !== undefined && typeof value !== "function") { throw new TypeError("Expected '" + name + "' to be a function"); } return value; }

function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }

function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }

function _toArray(arr) { return _arrayWithHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(n); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }







let HuiButtonRow = _decorate([Object(lit_element__WEBPACK_IMPORTED_MODULE_1__["customElement"])("hui-button-row")], function (_initialize, _LitElement) {
  class HuiButtonRow extends _LitElement {
    constructor(...args) {
      super(...args);

      _initialize(this);
    }

  }

  return {
    F: HuiButtonRow,
    d: [{
      kind: "field",
      key: "hass",
      value: void 0
    }, {
      kind: "field",
      decorators: [Object(lit_element__WEBPACK_IMPORTED_MODULE_1__["property"])()],
      key: "_config",
      value: void 0
    }, {
      kind: "method",
      key: "setConfig",
      value: function setConfig(config) {
        if (!config) {
          throw new Error("Error in card configuration.");
        }

        if (!config.name) {
          throw new Error("Error in card configuration. No name specified.");
        }

        if (!config.tap_action) {
          throw new Error("Error in card configuration. No action specified.");
        }

        this._config = config;
      }
    }, {
      kind: "method",
      key: "render",
      value: function render() {
        if (!this._config) {
          return lit_element__WEBPACK_IMPORTED_MODULE_1__["html"]``;
        }

        return lit_element__WEBPACK_IMPORTED_MODULE_1__["html"]`
      <ha-icon .icon=${this._config.icon || "hass:remote"}></ha-icon>
      <div class="flex">
        <div>${this._config.name}</div>
        <mwc-button
          @action=${this._handleAction}
          .actionHandler=${Object(_common_directives_action_handler_directive__WEBPACK_IMPORTED_MODULE_3__["actionHandler"])({
          hasHold: Object(_common_has_action__WEBPACK_IMPORTED_MODULE_5__["hasAction"])(this._config.hold_action),
          hasDoubleClick: Object(_common_has_action__WEBPACK_IMPORTED_MODULE_5__["hasAction"])(this._config.double_tap_action)
        })}
          >${this._config.action_name ? this._config.action_name : this.hass.localize("ui.card.service.run")}</mwc-button
        >
      </div>
    `;
      }
    }, {
      kind: "get",
      static: true,
      key: "styles",
      value: function styles() {
        return lit_element__WEBPACK_IMPORTED_MODULE_1__["css"]`
      :host {
        display: flex;
        align-items: center;
      }
      ha-icon {
        padding: 8px;
        color: var(--paper-item-icon-color);
      }
      .flex {
        flex: 1;
        overflow: hidden;
        margin-left: 16px;
        display: flex;
        justify-content: space-between;
        align-items: center;
      }
      .flex div {
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
      }
      mwc-button {
        margin-right: -0.57em;
      }
    `;
      }
    }, {
      kind: "method",
      key: "_handleAction",
      value: function _handleAction(ev) {
        Object(_common_handle_action__WEBPACK_IMPORTED_MODULE_4__["handleAction"])(this, this.hass, this._config, ev.detail.action);
      }
    }]
  };
}, lit_element__WEBPACK_IMPORTED_MODULE_1__["LitElement"]);

/***/ }),

/***/ "./src/panels/lovelace/special-rows/hui-call-service-row.ts":
/*!******************************************************************!*\
  !*** ./src/panels/lovelace/special-rows/hui-call-service-row.ts ***!
  \******************************************************************/
/*! exports provided: HuiCallServiceRow */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HuiCallServiceRow", function() { return HuiCallServiceRow; });
/* harmony import */ var lit_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! lit-element */ "./node_modules/lit-element/lit-element.js");
/* harmony import */ var _hui_button_row__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./hui-button-row */ "./src/panels/lovelace/special-rows/hui-button-row.ts");
function _decorate(decorators, factory, superClass, mixins) { var api = _getDecoratorsApi(); if (mixins) { for (var i = 0; i < mixins.length; i++) { api = mixins[i](api); } } var r = factory(function initialize(O) { api.initializeInstanceElements(O, decorated.elements); }, superClass); var decorated = api.decorateClass(_coalesceClassElements(r.d.map(_createElementDescriptor)), decorators); api.initializeClassElements(r.F, decorated.elements); return api.runClassFinishers(r.F, decorated.finishers); }

function _getDecoratorsApi() { _getDecoratorsApi = function () { return api; }; var api = { elementsDefinitionOrder: [["method"], ["field"]], initializeInstanceElements: function (O, elements) { ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { if (element.kind === kind && element.placement === "own") { this.defineClassElement(O, element); } }, this); }, this); }, initializeClassElements: function (F, elements) { var proto = F.prototype; ["method", "field"].forEach(function (kind) { elements.forEach(function (element) { var placement = element.placement; if (element.kind === kind && (placement === "static" || placement === "prototype")) { var receiver = placement === "static" ? F : proto; this.defineClassElement(receiver, element); } }, this); }, this); }, defineClassElement: function (receiver, element) { var descriptor = element.descriptor; if (element.kind === "field") { var initializer = element.initializer; descriptor = { enumerable: descriptor.enumerable, writable: descriptor.writable, configurable: descriptor.configurable, value: initializer === void 0 ? void 0 : initializer.call(receiver) }; } Object.defineProperty(receiver, element.key, descriptor); }, decorateClass: function (elements, decorators) { var newElements = []; var finishers = []; var placements = { static: [], prototype: [], own: [] }; elements.forEach(function (element) { this.addElementPlacement(element, placements); }, this); elements.forEach(function (element) { if (!_hasDecorators(element)) return newElements.push(element); var elementFinishersExtras = this.decorateElement(element, placements); newElements.push(elementFinishersExtras.element); newElements.push.apply(newElements, elementFinishersExtras.extras); finishers.push.apply(finishers, elementFinishersExtras.finishers); }, this); if (!decorators) { return { elements: newElements, finishers: finishers }; } var result = this.decorateConstructor(newElements, decorators); finishers.push.apply(finishers, result.finishers); result.finishers = finishers; return result; }, addElementPlacement: function (element, placements, silent) { var keys = placements[element.placement]; if (!silent && keys.indexOf(element.key) !== -1) { throw new TypeError("Duplicated element (" + element.key + ")"); } keys.push(element.key); }, decorateElement: function (element, placements) { var extras = []; var finishers = []; for (var decorators = element.decorators, i = decorators.length - 1; i >= 0; i--) { var keys = placements[element.placement]; keys.splice(keys.indexOf(element.key), 1); var elementObject = this.fromElementDescriptor(element); var elementFinisherExtras = this.toElementFinisherExtras((0, decorators[i])(elementObject) || elementObject); element = elementFinisherExtras.element; this.addElementPlacement(element, placements); if (elementFinisherExtras.finisher) { finishers.push(elementFinisherExtras.finisher); } var newExtras = elementFinisherExtras.extras; if (newExtras) { for (var j = 0; j < newExtras.length; j++) { this.addElementPlacement(newExtras[j], placements); } extras.push.apply(extras, newExtras); } } return { element: element, finishers: finishers, extras: extras }; }, decorateConstructor: function (elements, decorators) { var finishers = []; for (var i = decorators.length - 1; i >= 0; i--) { var obj = this.fromClassDescriptor(elements); var elementsAndFinisher = this.toClassDescriptor((0, decorators[i])(obj) || obj); if (elementsAndFinisher.finisher !== undefined) { finishers.push(elementsAndFinisher.finisher); } if (elementsAndFinisher.elements !== undefined) { elements = elementsAndFinisher.elements; for (var j = 0; j < elements.length - 1; j++) { for (var k = j + 1; k < elements.length; k++) { if (elements[j].key === elements[k].key && elements[j].placement === elements[k].placement) { throw new TypeError("Duplicated element (" + elements[j].key + ")"); } } } } } return { elements: elements, finishers: finishers }; }, fromElementDescriptor: function (element) { var obj = { kind: element.kind, key: element.key, placement: element.placement, descriptor: element.descriptor }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); if (element.kind === "field") obj.initializer = element.initializer; return obj; }, toElementDescriptors: function (elementObjects) { if (elementObjects === undefined) return; return _toArray(elementObjects).map(function (elementObject) { var element = this.toElementDescriptor(elementObject); this.disallowProperty(elementObject, "finisher", "An element descriptor"); this.disallowProperty(elementObject, "extras", "An element descriptor"); return element; }, this); }, toElementDescriptor: function (elementObject) { var kind = String(elementObject.kind); if (kind !== "method" && kind !== "field") { throw new TypeError('An element descriptor\'s .kind property must be either "method" or' + ' "field", but a decorator created an element descriptor with' + ' .kind "' + kind + '"'); } var key = _toPropertyKey(elementObject.key); var placement = String(elementObject.placement); if (placement !== "static" && placement !== "prototype" && placement !== "own") { throw new TypeError('An element descriptor\'s .placement property must be one of "static",' + ' "prototype" or "own", but a decorator created an element descriptor' + ' with .placement "' + placement + '"'); } var descriptor = elementObject.descriptor; this.disallowProperty(elementObject, "elements", "An element descriptor"); var element = { kind: kind, key: key, placement: placement, descriptor: Object.assign({}, descriptor) }; if (kind !== "field") { this.disallowProperty(elementObject, "initializer", "A method descriptor"); } else { this.disallowProperty(descriptor, "get", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "set", "The property descriptor of a field descriptor"); this.disallowProperty(descriptor, "value", "The property descriptor of a field descriptor"); element.initializer = elementObject.initializer; } return element; }, toElementFinisherExtras: function (elementObject) { var element = this.toElementDescriptor(elementObject); var finisher = _optionalCallableProperty(elementObject, "finisher"); var extras = this.toElementDescriptors(elementObject.extras); return { element: element, finisher: finisher, extras: extras }; }, fromClassDescriptor: function (elements) { var obj = { kind: "class", elements: elements.map(this.fromElementDescriptor, this) }; var desc = { value: "Descriptor", configurable: true }; Object.defineProperty(obj, Symbol.toStringTag, desc); return obj; }, toClassDescriptor: function (obj) { var kind = String(obj.kind); if (kind !== "class") { throw new TypeError('A class descriptor\'s .kind property must be "class", but a decorator' + ' created a class descriptor with .kind "' + kind + '"'); } this.disallowProperty(obj, "key", "A class descriptor"); this.disallowProperty(obj, "placement", "A class descriptor"); this.disallowProperty(obj, "descriptor", "A class descriptor"); this.disallowProperty(obj, "initializer", "A class descriptor"); this.disallowProperty(obj, "extras", "A class descriptor"); var finisher = _optionalCallableProperty(obj, "finisher"); var elements = this.toElementDescriptors(obj.elements); return { elements: elements, finisher: finisher }; }, runClassFinishers: function (constructor, finishers) { for (var i = 0; i < finishers.length; i++) { var newConstructor = (0, finishers[i])(constructor); if (newConstructor !== undefined) { if (typeof newConstructor !== "function") { throw new TypeError("Finishers must return a constructor."); } constructor = newConstructor; } } return constructor; }, disallowProperty: function (obj, name, objectType) { if (obj[name] !== undefined) { throw new TypeError(objectType + " can't have a ." + name + " property."); } } }; return api; }

function _createElementDescriptor(def) { var key = _toPropertyKey(def.key); var descriptor; if (def.kind === "method") { descriptor = { value: def.value, writable: true, configurable: true, enumerable: false }; } else if (def.kind === "get") { descriptor = { get: def.value, configurable: true, enumerable: false }; } else if (def.kind === "set") { descriptor = { set: def.value, configurable: true, enumerable: false }; } else if (def.kind === "field") { descriptor = { configurable: true, writable: true, enumerable: true }; } var element = { kind: def.kind === "field" ? "field" : "method", key: key, placement: def.static ? "static" : def.kind === "field" ? "own" : "prototype", descriptor: descriptor }; if (def.decorators) element.decorators = def.decorators; if (def.kind === "field") element.initializer = def.value; return element; }

function _coalesceGetterSetter(element, other) { if (element.descriptor.get !== undefined) { other.descriptor.get = element.descriptor.get; } else { other.descriptor.set = element.descriptor.set; } }

function _coalesceClassElements(elements) { var newElements = []; var isSameElement = function (other) { return other.kind === "method" && other.key === element.key && other.placement === element.placement; }; for (var i = 0; i < elements.length; i++) { var element = elements[i]; var other; if (element.kind === "method" && (other = newElements.find(isSameElement))) { if (_isDataDescriptor(element.descriptor) || _isDataDescriptor(other.descriptor)) { if (_hasDecorators(element) || _hasDecorators(other)) { throw new ReferenceError("Duplicated methods (" + element.key + ") can't be decorated."); } other.descriptor = element.descriptor; } else { if (_hasDecorators(element)) { if (_hasDecorators(other)) { throw new ReferenceError("Decorators can't be placed on different accessors with for " + "the same property (" + element.key + ")."); } other.decorators = element.decorators; } _coalesceGetterSetter(element, other); } } else { newElements.push(element); } } return newElements; }

function _hasDecorators(element) { return element.decorators && element.decorators.length; }

function _isDataDescriptor(desc) { return desc !== undefined && !(desc.value === undefined && desc.writable === undefined); }

function _optionalCallableProperty(obj, name) { var value = obj[name]; if (value !== undefined && typeof value !== "function") { throw new TypeError("Expected '" + name + "' to be a function"); } return value; }

function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }

function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); }

function _toArray(arr) { return _arrayWithHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(n); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) arr2[i] = arr[i]; return arr2; }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function _get(target, property, receiver) { if (typeof Reflect !== "undefined" && Reflect.get) { _get = Reflect.get; } else { _get = function _get(target, property, receiver) { var base = _superPropBase(target, property); if (!base) return; var desc = Object.getOwnPropertyDescriptor(base, property); if (desc.get) { return desc.get.call(receiver); } return desc.value; }; } return _get(target, property, receiver || target); }

function _superPropBase(object, property) { while (!Object.prototype.hasOwnProperty.call(object, property)) { object = _getPrototypeOf(object); if (object === null) break; } return object; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }



let HuiCallServiceRow = _decorate([Object(lit_element__WEBPACK_IMPORTED_MODULE_0__["customElement"])("hui-call-service-row")], function (_initialize, _HuiButtonRow) {
  class HuiCallServiceRow extends _HuiButtonRow {
    constructor(...args) {
      super(...args);

      _initialize(this);
    }

  }

  return {
    F: HuiCallServiceRow,
    d: [{
      kind: "method",
      key: "setConfig",
      value: function setConfig(config) {
        const callServiceConfig = config;

        if (!callServiceConfig) {
          throw new Error("Error in card configuration.");
        }

        if (!callServiceConfig.name) {
          throw new Error("Error in card configuration. No name specified.");
        }

        if (!callServiceConfig.service) {
          throw new Error("Error in card configuration. No service specified.");
        }

        _get(_getPrototypeOf(HuiCallServiceRow.prototype), "setConfig", this).call(this, Object.assign({
          tap_action: {
            action: "call-service",
            service: callServiceConfig.service,
            service_data: callServiceConfig.service_data
          }
        }, callServiceConfig, {
          type: "button"
        }));
      }
    }]
  };
}, _hui_button_row__WEBPACK_IMPORTED_MODULE_1__["HuiButtonRow"]);

/***/ })

}]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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