(self["webpackJsonp"] = self["webpackJsonp"] || []).push([[25],{

/***/ "./node_modules/resize-observer/lib/ContentRect.js":
/*!*********************************************************!*\
  !*** ./node_modules/resize-observer/lib/ContentRect.js ***!
  \*********************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var ContentRect = function (target) {
  if ('getBBox' in target) {
    var box = target.getBBox();
    return Object.freeze({
      height: box.height,
      left: 0,
      top: 0,
      width: box.width
    });
  } else {
    // if (target instanceof HTMLElement) { // also includes all other non-SVGGraphicsElements
    var styles = window.getComputedStyle(target);
    return Object.freeze({
      height: parseFloat(styles.height || '0'),
      left: parseFloat(styles.paddingLeft || '0'),
      top: parseFloat(styles.paddingTop || '0'),
      width: parseFloat(styles.width || '0')
    });
  }
};

exports.ContentRect = ContentRect;

/***/ }),

/***/ "./node_modules/resize-observer/lib/ResizeObservation.js":
/*!***************************************************************!*\
  !*** ./node_modules/resize-observer/lib/ResizeObservation.js ***!
  \***************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var ContentRect_1 = __webpack_require__(/*! ./ContentRect */ "./node_modules/resize-observer/lib/ContentRect.js");

var ResizeObservation =
/** @class */
function () {
  function ResizeObservation(target) {
    this.target = target;
    this.$$broadcastWidth = this.$$broadcastHeight = 0;
  }

  Object.defineProperty(ResizeObservation.prototype, "broadcastWidth", {
    get: function () {
      return this.$$broadcastWidth;
    },
    enumerable: true,
    configurable: true
  });
  Object.defineProperty(ResizeObservation.prototype, "broadcastHeight", {
    get: function () {
      return this.$$broadcastHeight;
    },
    enumerable: true,
    configurable: true
  });

  ResizeObservation.prototype.isActive = function () {
    var cr = ContentRect_1.ContentRect(this.target);
    return !!cr && (cr.width !== this.broadcastWidth || cr.height !== this.broadcastHeight);
  };

  return ResizeObservation;
}();

exports.ResizeObservation = ResizeObservation;

/***/ }),

/***/ "./node_modules/resize-observer/lib/ResizeObserver.js":
/*!************************************************************!*\
  !*** ./node_modules/resize-observer/lib/ResizeObserver.js ***!
  \************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var ResizeObservation_1 = __webpack_require__(/*! ./ResizeObservation */ "./node_modules/resize-observer/lib/ResizeObservation.js");

var ResizeObserverEntry_1 = __webpack_require__(/*! ./ResizeObserverEntry */ "./node_modules/resize-observer/lib/ResizeObserverEntry.js");

var resizeObservers = [];

var ResizeObserver =
/** @class */
function () {
  function ResizeObserver(callback) {
    /** @internal */
    this.$$observationTargets = [];
    /** @internal */

    this.$$activeTargets = [];
    /** @internal */

    this.$$skippedTargets = [];
    var message = callbackGuard(callback);

    if (message) {
      throw TypeError(message);
    }

    this.$$callback = callback;
    resizeObservers.push(this);
  }

  ResizeObserver.prototype.observe = function (target) {
    var message = targetGuard('observe', target);

    if (message) {
      throw TypeError(message);
    }

    var index = findTargetIndex(this.$$observationTargets, target);

    if (index > 0) {
      return;
    }

    this.$$observationTargets.push(new ResizeObservation_1.ResizeObservation(target));
    startLoop();
  };

  ResizeObserver.prototype.unobserve = function (target) {
    var message = targetGuard('unobserve', target);

    if (message) {
      throw TypeError(message);
    }

    var index = findTargetIndex(this.$$observationTargets, target);

    if (index < 0) {
      return;
    }

    this.$$observationTargets.splice(index, 1);
    checkStopLoop();
  };

  ResizeObserver.prototype.disconnect = function () {
    this.$$observationTargets = [];
    this.$$activeTargets = [];
  };

  return ResizeObserver;
}();

exports.ResizeObserver = ResizeObserver;

function callbackGuard(callback) {
  if (typeof callback === 'undefined') {
    return "Failed to construct 'ResizeObserver': 1 argument required, but only 0 present.";
  }

  if (typeof callback !== 'function') {
    return "Failed to construct 'ResizeObserver': The callback provided as parameter 1 is not a function.";
  }
}

function targetGuard(functionName, target) {
  if (typeof target === 'undefined') {
    return "Failed to execute '" + functionName + "' on 'ResizeObserver': 1 argument required, but only 0 present.";
  }

  if (!(target instanceof window.Element)) {
    return "Failed to execute '" + functionName + "' on 'ResizeObserver': parameter 1 is not of type 'Element'.";
  }
}

function findTargetIndex(collection, target) {
  for (var index = 0; index < collection.length; index += 1) {
    if (collection[index].target === target) {
      return index;
    }
  }

  return -1;
}

var gatherActiveObservationsAtDepth = function (depth) {
  resizeObservers.forEach(function (ro) {
    ro.$$activeTargets = [];
    ro.$$skippedTargets = [];
    ro.$$observationTargets.forEach(function (ot) {
      if (ot.isActive()) {
        var targetDepth = calculateDepthForNode(ot.target);

        if (targetDepth > depth) {
          ro.$$activeTargets.push(ot);
        } else {
          ro.$$skippedTargets.push(ot);
        }
      }
    });
  });
};

var hasActiveObservations = function () {
  return resizeObservers.some(function (ro) {
    return !!ro.$$activeTargets.length;
  });
};

var hasSkippedObservations = function () {
  return resizeObservers.some(function (ro) {
    return !!ro.$$skippedTargets.length;
  });
};

var broadcastActiveObservations = function () {
  var shallowestTargetDepth = Infinity;
  resizeObservers.forEach(function (ro) {
    if (!ro.$$activeTargets.length) {
      return;
    }

    var entries = [];
    ro.$$activeTargets.forEach(function (obs) {
      var entry = new ResizeObserverEntry_1.ResizeObserverEntry(obs.target);
      entries.push(entry);
      obs.$$broadcastWidth = entry.contentRect.width;
      obs.$$broadcastHeight = entry.contentRect.height;
      var targetDepth = calculateDepthForNode(obs.target);

      if (targetDepth < shallowestTargetDepth) {
        shallowestTargetDepth = targetDepth;
      }
    });
    ro.$$callback(entries, ro);
    ro.$$activeTargets = [];
  });
  return shallowestTargetDepth;
};

var deliverResizeLoopErrorNotification = function () {
  var errorEvent = new window.ErrorEvent('ResizeLoopError', {
    message: 'ResizeObserver loop completed with undelivered notifications.'
  });
  window.dispatchEvent(errorEvent);
};

var calculateDepthForNode = function (target) {
  var depth = 0;

  while (target.parentNode) {
    target = target.parentNode;
    depth += 1;
  }

  return depth;
};

var notificationIteration = function () {
  var depth = 0;
  gatherActiveObservationsAtDepth(depth);

  while (hasActiveObservations()) {
    depth = broadcastActiveObservations();
    gatherActiveObservationsAtDepth(depth);
  }

  if (hasSkippedObservations()) {
    deliverResizeLoopErrorNotification();
  }
};

var animationFrameCancelToken;

var startLoop = function () {
  if (animationFrameCancelToken) return;
  runLoop();
};

var runLoop = function () {
  animationFrameCancelToken = window.requestAnimationFrame(function () {
    notificationIteration();
    runLoop();
  });
};

var checkStopLoop = function () {
  if (animationFrameCancelToken && !resizeObservers.some(function (ro) {
    return !!ro.$$observationTargets.length;
  })) {
    window.cancelAnimationFrame(animationFrameCancelToken);
    animationFrameCancelToken = undefined;
  }
};

var install = function () {
  return window.ResizeObserver = ResizeObserver;
};

exports.install = install;

/***/ }),

/***/ "./node_modules/resize-observer/lib/ResizeObserverEntry.js":
/*!*****************************************************************!*\
  !*** ./node_modules/resize-observer/lib/ResizeObserverEntry.js ***!
  \*****************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
  value: true
});

var ContentRect_1 = __webpack_require__(/*! ./ContentRect */ "./node_modules/resize-observer/lib/ContentRect.js");

var ResizeObserverEntry =
/** @class */
function () {
  function ResizeObserverEntry(target) {
    this.target = target;
    this.contentRect = ContentRect_1.ContentRect(target);
  }

  return ResizeObserverEntry;
}();

exports.ResizeObserverEntry = ResizeObserverEntry;

/***/ })

}]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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