"""Main module."""

def return_iso(
    api_key,
    locations,
    range,
    profile='driving-car'
    ): 
    
    """ :param locations: pair of lng,lat coordinates in the format of: [[lng, lat], [-48.51057, -27.57482]]
    :type list of coordinates

    :param profile: mode of transportation. One of “driving-car”, “foot-walking”, “cycling-regular”. Defaults to driving-car
    :type string

    :param range: time in minutes that, coupled with the profile, define the equidistant isochrone
    :type integer

    :param api_key: key necessary for making requests to the open route service api. Get yours at: openrouteservice.org
    :type string """

    range_in_secs = [x * 60 for x in range] 

    body = {
        "locations":locations,
        "range": range_in_secs
    }

    headers = {
        'Accept': 'application/json, application/geo+json, application/gpx+xml, img/png; charset=utf-8',
        'Authorization': api_key,
        'Content-Type': 'application/json; charset=utf-8'
    }
    
    call = requests.post('https://api.openrouteservice.org/v2/isochrones/' + profile + '/geojson', json=body, headers=headers)

    print(call.status_code, call.reason)
    response=json.loads(call.text)

    return(response)