(self["webpackChunkweb_js"] = self["webpackChunkweb_js"] || []).push([["vendors-node_modules_monaco-editor_esm_vs_basic-languages_elixir_elixir_js"],{

/***/ "./node_modules/monaco-editor/esm/vs/basic-languages/elixir/elixir.js":
/*!****************************************************************************!*\
  !*** ./node_modules/monaco-editor/esm/vs/basic-languages/elixir/elixir.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "conf": () => (/* binding */ conf),
/* harmony export */   "language": () => (/* binding */ language)
/* harmony export */ });
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.34.1(547870b6881302c5b4ff32173c16d06009e3588f)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/

// src/basic-languages/elixir/elixir.ts
var conf = {
  comments: {
    lineComment: "#"
  },
  brackets: [
    ["{", "}"],
    ["[", "]"],
    ["(", ")"]
  ],
  surroundingPairs: [
    { open: "{", close: "}" },
    { open: "[", close: "]" },
    { open: "(", close: ")" },
    { open: "'", close: "'" },
    { open: '"', close: '"' }
  ],
  autoClosingPairs: [
    { open: "'", close: "'", notIn: ["string", "comment"] },
    { open: '"', close: '"', notIn: ["comment"] },
    { open: '"""', close: '"""' },
    { open: "`", close: "`", notIn: ["string", "comment"] },
    { open: "(", close: ")" },
    { open: "{", close: "}" },
    { open: "[", close: "]" },
    { open: "<<", close: ">>" }
  ],
  indentationRules: {
    increaseIndentPattern: /^\s*(after|else|catch|rescue|fn|[^#]*(do|<\-|\->|\{|\[|\=))\s*$/,
    decreaseIndentPattern: /^\s*((\}|\])\s*$|(after|else|catch|rescue|end)\b)/
  }
};
var language = {
  defaultToken: "source",
  tokenPostfix: ".elixir",
  brackets: [
    { open: "[", close: "]", token: "delimiter.square" },
    { open: "(", close: ")", token: "delimiter.parenthesis" },
    { open: "{", close: "}", token: "delimiter.curly" },
    { open: "<<", close: ">>", token: "delimiter.angle.special" }
  ],
  declarationKeywords: [
    "def",
    "defp",
    "defn",
    "defnp",
    "defguard",
    "defguardp",
    "defmacro",
    "defmacrop",
    "defdelegate",
    "defcallback",
    "defmacrocallback",
    "defmodule",
    "defprotocol",
    "defexception",
    "defimpl",
    "defstruct"
  ],
  operatorKeywords: ["and", "in", "not", "or", "when"],
  namespaceKeywords: ["alias", "import", "require", "use"],
  otherKeywords: [
    "after",
    "case",
    "catch",
    "cond",
    "do",
    "else",
    "end",
    "fn",
    "for",
    "if",
    "quote",
    "raise",
    "receive",
    "rescue",
    "super",
    "throw",
    "try",
    "unless",
    "unquote_splicing",
    "unquote",
    "with"
  ],
  constants: ["true", "false", "nil"],
  nameBuiltin: ["__MODULE__", "__DIR__", "__ENV__", "__CALLER__", "__STACKTRACE__"],
  operator: /-[->]?|!={0,2}|\*{1,2}|\/|\\\\|&{1,3}|\.\.?|\^(?:\^\^)?|\+\+?|<(?:-|<<|=|>|\|>|~>?)?|=~|={1,3}|>(?:=|>>)?|\|~>|\|>|\|{1,3}|~>>?|~~~|::/,
  variableName: /[a-z_][a-zA-Z0-9_]*[?!]?/,
  atomName: /[a-zA-Z_][a-zA-Z0-9_@]*[?!]?|@specialAtomName|@operator/,
  specialAtomName: /\.\.\.|<<>>|%\{\}|%|\{\}/,
  aliasPart: /[A-Z][a-zA-Z0-9_]*/,
  moduleName: /@aliasPart(?:\.@aliasPart)*/,
  sigilSymmetricDelimiter: /"""|'''|"|'|\/|\|/,
  sigilStartDelimiter: /@sigilSymmetricDelimiter|<|\{|\[|\(/,
  sigilEndDelimiter: /@sigilSymmetricDelimiter|>|\}|\]|\)/,
  sigilModifiers: /[a-zA-Z0-9]*/,
  decimal: /\d(?:_?\d)*/,
  hex: /[0-9a-fA-F](_?[0-9a-fA-F])*/,
  octal: /[0-7](_?[0-7])*/,
  binary: /[01](_?[01])*/,
  escape: /\\u[0-9a-fA-F]{4}|\\x[0-9a-fA-F]{2}|\\./,
  tokenizer: {
    root: [
      { include: "@whitespace" },
      { include: "@comments" },
      { include: "@keywordsShorthand" },
      { include: "@numbers" },
      { include: "@identifiers" },
      { include: "@strings" },
      { include: "@atoms" },
      { include: "@sigils" },
      { include: "@attributes" },
      { include: "@symbols" }
    ],
    whitespace: [[/\s+/, "white"]],
    comments: [[/(#)(.*)/, ["comment.punctuation", "comment"]]],
    keywordsShorthand: [
      [/(@atomName)(:)/, ["constant", "constant.punctuation"]],
      [
        /"(?=([^"]|#\{.*?\}|\\")*":)/,
        { token: "constant.delimiter", next: "@doubleQuotedStringKeyword" }
      ],
      [
        /'(?=([^']|#\{.*?\}|\\')*':)/,
        { token: "constant.delimiter", next: "@singleQuotedStringKeyword" }
      ]
    ],
    doubleQuotedStringKeyword: [
      [/":/, { token: "constant.delimiter", next: "@pop" }],
      { include: "@stringConstantContentInterpol" }
    ],
    singleQuotedStringKeyword: [
      [/':/, { token: "constant.delimiter", next: "@pop" }],
      { include: "@stringConstantContentInterpol" }
    ],
    numbers: [
      [/0b@binary/, "number.binary"],
      [/0o@octal/, "number.octal"],
      [/0x@hex/, "number.hex"],
      [/@decimal\.@decimal([eE]-?@decimal)?/, "number.float"],
      [/@decimal/, "number"]
    ],
    identifiers: [
      [
        /\b(defp?|defnp?|defmacrop?|defguardp?|defdelegate)(\s+)(@variableName)(?!\s+@operator)/,
        [
          "keyword.declaration",
          "white",
          {
            cases: {
              unquote: "keyword",
              "@default": "function"
            }
          }
        ]
      ],
      [
        /(@variableName)(?=\s*\.?\s*\()/,
        {
          cases: {
            "@declarationKeywords": "keyword.declaration",
            "@namespaceKeywords": "keyword",
            "@otherKeywords": "keyword",
            "@default": "function.call"
          }
        }
      ],
      [
        /(@moduleName)(\s*)(\.)(\s*)(@variableName)/,
        ["type.identifier", "white", "operator", "white", "function.call"]
      ],
      [
        /(:)(@atomName)(\s*)(\.)(\s*)(@variableName)/,
        ["constant.punctuation", "constant", "white", "operator", "white", "function.call"]
      ],
      [
        /(\|>)(\s*)(@variableName)/,
        [
          "operator",
          "white",
          {
            cases: {
              "@otherKeywords": "keyword",
              "@default": "function.call"
            }
          }
        ]
      ],
      [
        /(&)(\s*)(@variableName)/,
        ["operator", "white", "function.call"]
      ],
      [
        /@variableName/,
        {
          cases: {
            "@declarationKeywords": "keyword.declaration",
            "@operatorKeywords": "keyword.operator",
            "@namespaceKeywords": "keyword",
            "@otherKeywords": "keyword",
            "@constants": "constant.language",
            "@nameBuiltin": "variable.language",
            "_.*": "comment.unused",
            "@default": "identifier"
          }
        }
      ],
      [/@moduleName/, "type.identifier"]
    ],
    strings: [
      [/"""/, { token: "string.delimiter", next: "@doubleQuotedHeredoc" }],
      [/'''/, { token: "string.delimiter", next: "@singleQuotedHeredoc" }],
      [/"/, { token: "string.delimiter", next: "@doubleQuotedString" }],
      [/'/, { token: "string.delimiter", next: "@singleQuotedString" }]
    ],
    doubleQuotedHeredoc: [
      [/"""/, { token: "string.delimiter", next: "@pop" }],
      { include: "@stringContentInterpol" }
    ],
    singleQuotedHeredoc: [
      [/'''/, { token: "string.delimiter", next: "@pop" }],
      { include: "@stringContentInterpol" }
    ],
    doubleQuotedString: [
      [/"/, { token: "string.delimiter", next: "@pop" }],
      { include: "@stringContentInterpol" }
    ],
    singleQuotedString: [
      [/'/, { token: "string.delimiter", next: "@pop" }],
      { include: "@stringContentInterpol" }
    ],
    atoms: [
      [/(:)(@atomName)/, ["constant.punctuation", "constant"]],
      [/:"/, { token: "constant.delimiter", next: "@doubleQuotedStringAtom" }],
      [/:'/, { token: "constant.delimiter", next: "@singleQuotedStringAtom" }]
    ],
    doubleQuotedStringAtom: [
      [/"/, { token: "constant.delimiter", next: "@pop" }],
      { include: "@stringConstantContentInterpol" }
    ],
    singleQuotedStringAtom: [
      [/'/, { token: "constant.delimiter", next: "@pop" }],
      { include: "@stringConstantContentInterpol" }
    ],
    sigils: [
      [/~[a-z]@sigilStartDelimiter/, { token: "@rematch", next: "@sigil.interpol" }],
      [/~[A-Z]@sigilStartDelimiter/, { token: "@rematch", next: "@sigil.noInterpol" }]
    ],
    sigil: [
      [/~([a-zA-Z])\{/, { token: "@rematch", switchTo: "@sigilStart.$S2.$1.{.}" }],
      [/~([a-zA-Z])\[/, { token: "@rematch", switchTo: "@sigilStart.$S2.$1.[.]" }],
      [/~([a-zA-Z])\(/, { token: "@rematch", switchTo: "@sigilStart.$S2.$1.(.)" }],
      [/~([a-zA-Z])\</, { token: "@rematch", switchTo: "@sigilStart.$S2.$1.<.>" }],
      [
        /~([a-zA-Z])(@sigilSymmetricDelimiter)/,
        { token: "@rematch", switchTo: "@sigilStart.$S2.$1.$2.$2" }
      ]
    ],
    "sigilStart.interpol.s": [
      [
        /~s@sigilStartDelimiter/,
        {
          token: "string.delimiter",
          switchTo: "@sigilContinue.$S2.$S3.$S4.$S5"
        }
      ]
    ],
    "sigilContinue.interpol.s": [
      [
        /(@sigilEndDelimiter)@sigilModifiers/,
        {
          cases: {
            "$1==$S5": { token: "string.delimiter", next: "@pop" },
            "@default": "string"
          }
        }
      ],
      { include: "@stringContentInterpol" }
    ],
    "sigilStart.noInterpol.S": [
      [
        /~S@sigilStartDelimiter/,
        {
          token: "string.delimiter",
          switchTo: "@sigilContinue.$S2.$S3.$S4.$S5"
        }
      ]
    ],
    "sigilContinue.noInterpol.S": [
      [/(^|[^\\])\\@sigilEndDelimiter/, "string"],
      [
        /(@sigilEndDelimiter)@sigilModifiers/,
        {
          cases: {
            "$1==$S5": { token: "string.delimiter", next: "@pop" },
            "@default": "string"
          }
        }
      ],
      { include: "@stringContent" }
    ],
    "sigilStart.interpol.r": [
      [
        /~r@sigilStartDelimiter/,
        {
          token: "regexp.delimiter",
          switchTo: "@sigilContinue.$S2.$S3.$S4.$S5"
        }
      ]
    ],
    "sigilContinue.interpol.r": [
      [
        /(@sigilEndDelimiter)@sigilModifiers/,
        {
          cases: {
            "$1==$S5": { token: "regexp.delimiter", next: "@pop" },
            "@default": "regexp"
          }
        }
      ],
      { include: "@regexpContentInterpol" }
    ],
    "sigilStart.noInterpol.R": [
      [
        /~R@sigilStartDelimiter/,
        {
          token: "regexp.delimiter",
          switchTo: "@sigilContinue.$S2.$S3.$S4.$S5"
        }
      ]
    ],
    "sigilContinue.noInterpol.R": [
      [/(^|[^\\])\\@sigilEndDelimiter/, "regexp"],
      [
        /(@sigilEndDelimiter)@sigilModifiers/,
        {
          cases: {
            "$1==$S5": { token: "regexp.delimiter", next: "@pop" },
            "@default": "regexp"
          }
        }
      ],
      { include: "@regexpContent" }
    ],
    "sigilStart.interpol": [
      [
        /~([a-zA-Z])@sigilStartDelimiter/,
        {
          token: "sigil.delimiter",
          switchTo: "@sigilContinue.$S2.$S3.$S4.$S5"
        }
      ]
    ],
    "sigilContinue.interpol": [
      [
        /(@sigilEndDelimiter)@sigilModifiers/,
        {
          cases: {
            "$1==$S5": { token: "sigil.delimiter", next: "@pop" },
            "@default": "sigil"
          }
        }
      ],
      { include: "@sigilContentInterpol" }
    ],
    "sigilStart.noInterpol": [
      [
        /~([a-zA-Z])@sigilStartDelimiter/,
        {
          token: "sigil.delimiter",
          switchTo: "@sigilContinue.$S2.$S3.$S4.$S5"
        }
      ]
    ],
    "sigilContinue.noInterpol": [
      [/(^|[^\\])\\@sigilEndDelimiter/, "sigil"],
      [
        /(@sigilEndDelimiter)@sigilModifiers/,
        {
          cases: {
            "$1==$S5": { token: "sigil.delimiter", next: "@pop" },
            "@default": "sigil"
          }
        }
      ],
      { include: "@sigilContent" }
    ],
    attributes: [
      [
        /\@(module|type)?doc (~[sS])?"""/,
        {
          token: "comment.block.documentation",
          next: "@doubleQuotedHeredocDocstring"
        }
      ],
      [
        /\@(module|type)?doc (~[sS])?"/,
        {
          token: "comment.block.documentation",
          next: "@doubleQuotedStringDocstring"
        }
      ],
      [/\@(module|type)?doc false/, "comment.block.documentation"],
      [/\@(@variableName)/, "variable"]
    ],
    doubleQuotedHeredocDocstring: [
      [/"""/, { token: "comment.block.documentation", next: "@pop" }],
      { include: "@docstringContent" }
    ],
    doubleQuotedStringDocstring: [
      [/"/, { token: "comment.block.documentation", next: "@pop" }],
      { include: "@docstringContent" }
    ],
    symbols: [
      [/\?(\\.|[^\\\s])/, "number.constant"],
      [/&\d+/, "operator"],
      [/<<<|>>>/, "operator"],
      [/[()\[\]\{\}]|<<|>>/, "@brackets"],
      [/\.\.\./, "identifier"],
      [/=>/, "punctuation"],
      [/@operator/, "operator"],
      [/[:;,.%]/, "punctuation"]
    ],
    stringContentInterpol: [
      { include: "@interpolation" },
      { include: "@escapeChar" },
      { include: "@stringContent" }
    ],
    stringContent: [[/./, "string"]],
    stringConstantContentInterpol: [
      { include: "@interpolation" },
      { include: "@escapeChar" },
      { include: "@stringConstantContent" }
    ],
    stringConstantContent: [[/./, "constant"]],
    regexpContentInterpol: [
      { include: "@interpolation" },
      { include: "@escapeChar" },
      { include: "@regexpContent" }
    ],
    regexpContent: [
      [/(\s)(#)(\s.*)$/, ["white", "comment.punctuation", "comment"]],
      [/./, "regexp"]
    ],
    sigilContentInterpol: [
      { include: "@interpolation" },
      { include: "@escapeChar" },
      { include: "@sigilContent" }
    ],
    sigilContent: [[/./, "sigil"]],
    docstringContent: [[/./, "comment.block.documentation"]],
    escapeChar: [[/@escape/, "constant.character.escape"]],
    interpolation: [[/#{/, { token: "delimiter.bracket.embed", next: "@interpolationContinue" }]],
    interpolationContinue: [
      [/}/, { token: "delimiter.bracket.embed", next: "@pop" }],
      { include: "@root" }
    ]
  }
};



/***/ })

}])
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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