(self["webpackChunkweb_js"] = self["webpackChunkweb_js"] || []).push([["node_modules_monaco-editor_esm_vs_basic-languages_ecl_ecl_js"],{

/***/ "./node_modules/monaco-editor/esm/vs/basic-languages/ecl/ecl.js":
/*!**********************************************************************!*\
  !*** ./node_modules/monaco-editor/esm/vs/basic-languages/ecl/ecl.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "conf": () => (/* binding */ conf),
/* harmony export */   "language": () => (/* binding */ language)
/* harmony export */ });
/*!-----------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Version: 0.34.1(547870b6881302c5b4ff32173c16d06009e3588f)
 * Released under the MIT license
 * https://github.com/microsoft/monaco-editor/blob/main/LICENSE.txt
 *-----------------------------------------------------------------------------*/

// src/basic-languages/ecl/ecl.ts
var conf = {
  comments: {
    lineComment: "//",
    blockComment: ["/*", "*/"]
  },
  brackets: [
    ["{", "}"],
    ["[", "]"],
    ["(", ")"]
  ],
  autoClosingPairs: [
    { open: "{", close: "}" },
    { open: "[", close: "]" },
    { open: "(", close: ")" },
    { open: "'", close: "'", notIn: ["string", "comment"] },
    { open: '"', close: '"', notIn: ["string", "comment"] }
  ],
  surroundingPairs: [
    { open: "{", close: "}" },
    { open: "[", close: "]" },
    { open: "(", close: ")" },
    { open: "<", close: ">" },
    { open: "'", close: "'" },
    { open: '"', close: '"' }
  ]
};
var language = {
  defaultToken: "",
  tokenPostfix: ".ecl",
  ignoreCase: true,
  brackets: [
    { open: "{", close: "}", token: "delimiter.curly" },
    { open: "[", close: "]", token: "delimiter.square" },
    { open: "(", close: ")", token: "delimiter.parenthesis" },
    { open: "<", close: ">", token: "delimiter.angle" }
  ],
  pounds: [
    "append",
    "break",
    "declare",
    "demangle",
    "end",
    "for",
    "getdatatype",
    "if",
    "inmodule",
    "loop",
    "mangle",
    "onwarning",
    "option",
    "set",
    "stored",
    "uniquename"
  ].join("|"),
  keywords: [
    "__compressed__",
    "after",
    "all",
    "and",
    "any",
    "as",
    "atmost",
    "before",
    "beginc",
    "best",
    "between",
    "case",
    "cluster",
    "compressed",
    "compression",
    "const",
    "counter",
    "csv",
    "default",
    "descend",
    "embed",
    "encoding",
    "encrypt",
    "end",
    "endc",
    "endembed",
    "endmacro",
    "enum",
    "escape",
    "except",
    "exclusive",
    "expire",
    "export",
    "extend",
    "fail",
    "few",
    "fileposition",
    "first",
    "flat",
    "forward",
    "from",
    "full",
    "function",
    "functionmacro",
    "group",
    "grouped",
    "heading",
    "hole",
    "ifblock",
    "import",
    "in",
    "inner",
    "interface",
    "internal",
    "joined",
    "keep",
    "keyed",
    "last",
    "left",
    "limit",
    "linkcounted",
    "literal",
    "little_endian",
    "load",
    "local",
    "locale",
    "lookup",
    "lzw",
    "macro",
    "many",
    "maxcount",
    "maxlength",
    "min skew",
    "module",
    "mofn",
    "multiple",
    "named",
    "namespace",
    "nocase",
    "noroot",
    "noscan",
    "nosort",
    "not",
    "noxpath",
    "of",
    "onfail",
    "only",
    "opt",
    "or",
    "outer",
    "overwrite",
    "packed",
    "partition",
    "penalty",
    "physicallength",
    "pipe",
    "prefetch",
    "quote",
    "record",
    "repeat",
    "retry",
    "return",
    "right",
    "right1",
    "right2",
    "rows",
    "rowset",
    "scan",
    "scope",
    "self",
    "separator",
    "service",
    "shared",
    "skew",
    "skip",
    "smart",
    "soapaction",
    "sql",
    "stable",
    "store",
    "terminator",
    "thor",
    "threshold",
    "timelimit",
    "timeout",
    "token",
    "transform",
    "trim",
    "type",
    "unicodeorder",
    "unordered",
    "unsorted",
    "unstable",
    "update",
    "use",
    "validate",
    "virtual",
    "whole",
    "width",
    "wild",
    "within",
    "wnotrim",
    "xml",
    "xpath"
  ],
  functions: [
    "abs",
    "acos",
    "aggregate",
    "allnodes",
    "apply",
    "ascii",
    "asin",
    "assert",
    "asstring",
    "atan",
    "atan2",
    "ave",
    "build",
    "buildindex",
    "case",
    "catch",
    "choose",
    "choosen",
    "choosesets",
    "clustersize",
    "combine",
    "correlation",
    "cos",
    "cosh",
    "count",
    "covariance",
    "cron",
    "dataset",
    "dedup",
    "define",
    "denormalize",
    "dictionary",
    "distribute",
    "distributed",
    "distribution",
    "ebcdic",
    "enth",
    "error",
    "evaluate",
    "event",
    "eventextra",
    "eventname",
    "exists",
    "exp",
    "fail",
    "failcode",
    "failmessage",
    "fetch",
    "fromunicode",
    "fromxml",
    "getenv",
    "getisvalid",
    "global",
    "graph",
    "group",
    "hash",
    "hash32",
    "hash64",
    "hashcrc",
    "hashmd5",
    "having",
    "httpcall",
    "httpheader",
    "if",
    "iff",
    "index",
    "intformat",
    "isvalid",
    "iterate",
    "join",
    "keydiff",
    "keypatch",
    "keyunicode",
    "length",
    "library",
    "limit",
    "ln",
    "loadxml",
    "local",
    "log",
    "loop",
    "map",
    "matched",
    "matchlength",
    "matchposition",
    "matchtext",
    "matchunicode",
    "max",
    "merge",
    "mergejoin",
    "min",
    "nofold",
    "nolocal",
    "nonempty",
    "normalize",
    "nothor",
    "notify",
    "output",
    "parallel",
    "parse",
    "pipe",
    "power",
    "preload",
    "process",
    "project",
    "pull",
    "random",
    "range",
    "rank",
    "ranked",
    "realformat",
    "recordof",
    "regexfind",
    "regexreplace",
    "regroup",
    "rejected",
    "rollup",
    "round",
    "roundup",
    "row",
    "rowdiff",
    "sample",
    "sequential",
    "set",
    "sin",
    "sinh",
    "sizeof",
    "soapcall",
    "sort",
    "sorted",
    "sqrt",
    "stepped",
    "stored",
    "sum",
    "table",
    "tan",
    "tanh",
    "thisnode",
    "topn",
    "tounicode",
    "toxml",
    "transfer",
    "transform",
    "trim",
    "truncate",
    "typeof",
    "ungroup",
    "unicodeorder",
    "variance",
    "wait",
    "which",
    "workunit",
    "xmldecode",
    "xmlencode",
    "xmltext",
    "xmlunicode"
  ],
  typesint: ["integer", "unsigned"].join("|"),
  typesnum: ["data", "qstring", "string", "unicode", "utf8", "varstring", "varunicode"],
  typesone: [
    "ascii",
    "big_endian",
    "boolean",
    "data",
    "decimal",
    "ebcdic",
    "grouped",
    "integer",
    "linkcounted",
    "pattern",
    "qstring",
    "real",
    "record",
    "rule",
    "set of",
    "streamed",
    "string",
    "token",
    "udecimal",
    "unicode",
    "unsigned",
    "utf8",
    "varstring",
    "varunicode"
  ].join("|"),
  operators: ["+", "-", "/", ":=", "<", "<>", "=", ">", "\\", "and", "in", "not", "or"],
  symbols: /[=><!~?:&|+\-*\/\^%]+/,
  escapes: /\\(?:[abfnrtv\\"']|x[0-9A-Fa-f]{1,4}|u[0-9A-Fa-f]{4}|U[0-9A-Fa-f]{8})/,
  tokenizer: {
    root: [
      [/@typesint[4|8]/, "type"],
      [/#(@pounds)/, "type"],
      [/@typesone/, "type"],
      [
        /[a-zA-Z_$][\w-$]*/,
        {
          cases: {
            "@functions": "keyword.function",
            "@keywords": "keyword",
            "@operators": "operator"
          }
        }
      ],
      { include: "@whitespace" },
      [/[{}()\[\]]/, "@brackets"],
      [/[<>](?!@symbols)/, "@brackets"],
      [
        /@symbols/,
        {
          cases: {
            "@operators": "delimiter",
            "@default": ""
          }
        }
      ],
      [/[0-9_]*\.[0-9_]+([eE][\-+]?\d+)?/, "number.float"],
      [/0[xX][0-9a-fA-F_]+/, "number.hex"],
      [/0[bB][01]+/, "number.hex"],
      [/[0-9_]+/, "number"],
      [/[;,.]/, "delimiter"],
      [/"([^"\\]|\\.)*$/, "string.invalid"],
      [/"/, "string", "@string"],
      [/'[^\\']'/, "string"],
      [/(')(@escapes)(')/, ["string", "string.escape", "string"]],
      [/'/, "string.invalid"]
    ],
    whitespace: [
      [/[ \t\v\f\r\n]+/, ""],
      [/\/\*/, "comment", "@comment"],
      [/\/\/.*$/, "comment"]
    ],
    comment: [
      [/[^\/*]+/, "comment"],
      [/\*\//, "comment", "@pop"],
      [/[\/*]/, "comment"]
    ],
    string: [
      [/[^\\']+/, "string"],
      [/@escapes/, "string.escape"],
      [/\\./, "string.escape.invalid"],
      [/'/, "string", "@pop"]
    ]
  }
};



/***/ })

}])
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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