# bitwarden

Salt Extension Modules for Bitwarden

## Introduction
This extension for [Salt](https://saltproject.io) enables Salt to access and administer a
[Bitwarden])(https://bitwarden.com/) vault/instance.

This project aims to eventually have 100% coverage of the
[Bitwarden Vault Management API](https://bitwarden.com/help/vault-management-api/) and the
[Biwarden Public (Organization Management) API](https://bitwarden.com/help/api/).

## Requirements
This extension requires the `bw` Bitwarden CLI utility to be installed for functions that depend
on the `Bitwarden Vault Management API`. Installation instructions are available
[here](https://bitwarden.com/help/cli/#download-and-install). It also has dependencies on the
`validators` and `pyhumps` python packages, which are automatically installed.

## Installation
An example state file for installing and configuring this extension on EL8 (RHEL, AlmaLinux, Rocky
Linux, Oracle Linux, Scientific Linux, etc.):

```yaml
cmd_nodesource-el8.repo:
  cmd.run:
    - name: curl -fsSL https://rpm.nodesource.com/setup_18.x | bash -
    - creates:
        - /etc/yum.repos.d/nodesource-el8.repo

pkg_nodejs:
  pkg.installed:
    - name: nodejs
    - require:
        - cmd_nodesource-el8.repo

npm_bitwarden_cli:
  npm.installed:
    - name: '@bitwarden/cli'
    - require:
        - pkg_nodejs

pip_saltext.bitwarden:
  pip.installed:
    - name: saltext.bitwarden
    - require:
        - npm_bitwarden_cli

user_bitwarden:
  user.present:
    - name: bitwarden
    - usergroup: True
    - home: /var/lib/bitwarden
    - createhome: True
    - shell: /sbin/nologin
    - system: True
    - fullname: Bitwarden CLI REST API User
    - require:
        - npm_bitwarden_cli

file_/etc/sysconfig/bw-api:
  file.managed:
    - name: /etc/sysconfig/bw-api
    - user: root
    - group: root
    - mode: "0644"
    - contents: |
        # Command-line options for bw serve
        BITWARDENCLI_APPDATA_DIR=/var/lib/bitwarden
        OPTIONS="--hostname localhost --port 8087"
    - require:
        - user_bitwarden
    - watch_in:
        - service_bw-api

file_/etc/systemd/system/bw-api.service:
  file.managed:
    - name: /etc/systemd/system/bw-api.service
    - user: root
    - group: root
    - mode: "0644"
    - contents: |
        [Unit]
        Description=Bitwarden Vault Management API
        Documentation=https://bitwarden.com/help/cli/
        After=network.target

        [Service]
        EnvironmentFile=-/etc/sysconfig/bw-api
        User=bitwarden
        Group=bitwarden
        Type=simple
        WorkingDirectory=~
        ExecStart=/bin/bw serve $OPTIONS
        Restart=always

        [Install]
        WantedBy=multi-user.target
    - onchanges_in:
        - service_systemctl_reload
    - require:
        - file_/etc/sysconfig/bw-api
    - watch_in:
        - service_bw-api

# You must manually create two identical files in /etc/salt/master.d/bitwarden.conf
# and /etc/salt/minion.d/bitwarden.conf with the following contents (substituting values as
# appropriate)
#
#  bitwarden:
#    driver: bitwarden
#    cli_path: /bin/bw
#    cli_conf_dir: /etc/salt/.bitwarden
#    vault_url: https://bitwarden.com
#    email: user@example.com
#    password: CorrectHorseBatteryStaple
#    vault_api_url: http://localhost:8087
#    public_api_url: https://api.bitwarden.com
#    client_id: 25fa6fc6-deeb-4b42-a279-5e680b51aa58
#    client_secret: AofieD0oexiex1mie3eigi9oojooF3
#    org_client_id: organization.d0e19db4-38aa-4284-be3d-e80cff306e6c
#    org_client_secret: aWMk2MBf4NWXfaevrKyxa3uqNXYVQy

file_/etc/salt/master.d/bitwarden.conf:
  file.exists:
    - name: /etc/salt/master.d/bitwarden.conf
    - require:
        - pip_saltext.bitwarden

file_/etc/salt/minion.d/bitwarden.conf:
  file.exists:
    - name: /etc/salt/minion.d/bitwarden.conf
    - require:
        - pip_saltext.bitwarden

bitwarden_logged_in:
  bitwarden.logged_in:
    - name: logged_in
    - use_cli: True
    - profile: bitwarden

service_bw-api:
  service.running:
    - name: bw-api
    - enable: True
    - require:
        - bitwarden_logged_in

test_always_passes_systemctl:
  test.succeed_without_changes:
    - name: test_always_passes

service_systemctl_reload:
  module.run:
    - name: service.systemctl_reload
    - onchanges:
        - test_always_passes_systemctl
```

The configuration files required vary depending on which module you wish to use:

| module type | file type      |
|-------------|----------------|
| execution   | minion         |
| runner      | master         |
| sdb         | master, minion |
| state       | minion         |

## Usage

This extension currently provides only read-only access to Bitwarden vaults using the `sdb` module,
with other modules primarily for vault management such as logging in and unlocking the vault.

```bash
# SDB via runner module
salt-run sdb.get 'sdb://bitwarden/by-uuid/2fcd790a-70f7-43a2-b265-08a763873980/password'
CorrectHorseBatteryStaple
```

```bash
# SDB via execution module
salt-call sdb.get 'sdb://bitwarden/by-uuid/2fcd790a-70f7-43a2-b265-08a763873980/password'
local:
    CorrectHorseBatteryStaple
```

As always, you can also reference SDB modules in your pillar files:

```yaml
example_pillar:
  some_password: {{ salt['sdb.get']('sdb://bitwarden/by-uuid/2fcd790a-70f7-43a2-b265-08a763873980/password') }}
```

The format of the SDB URI is as follows:

`sdb://<profile>/by-uuid/<uuid>/<object>`

Where `<profile>` is the profile defined in the master or minion configuration
file, `<uuid>` is the UUID of the item, and `<object>` is one of:

- username
- password
- totp
- notes

The UUID of an item can be found using the Bitwarden CLI:

```bash
bw list items --search "Google Account" --pretty
[
  {
    "object": "item",
    "id": "2fa63ad5-e4e4-43d4-a089-3fadcf455be2",
    "organizationId": null,
    "folderId": null,
    "type": 1,
    "reprompt": 0,
    "name": "Google Account",
    "notes": null,
    "favorite": false,
    "login": {
      "uris": [
        {
          "match": null,
          "uri": "https://accounts.google.com"
        }
      ],
      "username": "user@example.com",
      "password": "aTjSsJvhQY5E24",
      "totp": "AEM1HEESIEV8YAED8THUBEHOOW",
      "passwordRevisionDate": null
    },
    "collectionIds": [],
    "revisionDate": "1970-01-01T00:00:00.000Z"
  }
]
```

## Docs
Docs are still a work in progress, although there are docstrings in each module with comprehensive
documentation of available functions and options.

## Contributing
All contributions are welcome.

## License
This project is licensed under the Apache Software License. See `LICENSE` for the licence text.
