from typing import Any, List, Optional, Tuple, Union

class CWrapper:
    ctype: Any
    deinit: Any
    def __init__(self, *args, **kwargs) -> None: ...
    def __del__(self) -> None: ...

class X509NameMeta(type):
    long_names: Any
    def __new__(cls, name, bases, dic): ...
    def add_property(instance, name, short_name): ...

class X509Name(str, metaclass=X509NameMeta):
    def __init__(self, dname) -> None: ...
    def __setattr__(self, name, value) -> None: ...

class AlternativeNames:
    def __init__(self, names) -> None: ...

class X509TrustList(CWrapper):
    def __new__(cls, *args, **kwargs): ...
    def __init__(self) -> None: ...
    def __del__(self) -> None: ...
    def add_ca(self, cert: X509Certificate, flags: int = ...) -> None: ...
    def add_certificate(self, cert: X509Certificate, flags: int = ...) -> None: ...

class X509Dn(CWrapper):
    ctype: Any
    deinit: Any
    def __init__(self, data: Any | None = ...) -> None: ...

class Pkcs7SignatureInfo(CWrapper):
    ctype: Any
    deinit: Any
    def __init__(self) -> None: ...
    @property
    def issuer_dn(self) -> X509Dn: ...
    @property
    def signing_time(self) -> int: ...
    @property
    def algo(self) -> int: ...
    @property
    def signer_serial(self) -> Optional[str]: ...
    @property
    def issuer_keyid(self) -> Optional[str]: ...

class Pkcs7(CWrapper):
    def __new__(cls, *args, **kwargs): ...
    def __init__(self) -> None: ...
    def __del__(self) -> None: ...
    def import_signature(self, buf: bytes, format: int = ...) -> None: ...
    def sign(self, cert: X509Certificate, privkey: Union[X509PrivateKey, PrivateKey], buf: bytes, hash_algo: Optional[int] = ..., flags: int = ...) -> None: ...
    def get_signature_count(self) -> int: ...
    def get_signature_info(self) -> List[Pkcs7SignatureInfo]: ...
    def verify_direct(self, cert: X509Certificate, buf: bytes, idx: int = ..., flags: int = ...) -> None: ...
    def verify(self, tl: X509TrustList, buf: bytes, idx: int = ..., flags: int = ...) -> None: ...
    def export(self, format: int = ...) -> bytes: ...

class PrivateKey:
    KEY_TYPE_NONE: int
    KEY_TYPE_RSA: int
    KEY_TYPE_DSA: int
    KEY_TYPE_EC: int
    def __new__(cls, *args, **kwargs): ...
    pk: Any
    uri: Any
    keytype: Any
    srk_password: Any
    key_password: Any
    def __init__(self, pk: Any | None = ..., uri: Any | None = ..., keytype=...) -> None: ...
    def __get__(self, obj, type_: Any | None = ...): ...
    def __set__(self, obj, value) -> None: ...
    def __del__(self) -> None: ...
    def is_pkcs11(self) -> bool: ...
    def get_uri(self) -> str: ...
    def import_x509(self, x509_privkey: X509PrivateKey, flags: int = ...) -> None: ...
    @staticmethod
    def upcast(algo, pk): ...
    @staticmethod
    def generate(algo=..., bits: int = ..., flags: int = ...): ...
    @classmethod
    def pk_algorithm_to_keytype(cls, algo: int) -> int: ...
    @staticmethod
    def import_uri(uri, flags: int = ..., srk_password: Any | None = ..., key_password: Any | None = ...): ...
    def sign_data(self, hash_algo, flags, buf): ...
    def sign_hash(self, hash_algo, flags, buf): ...
    def decrypt_data(self, flags, ciphertext): ...

class RSAPrivateKey(PrivateKey):
    srk_password: Any
    def __init__(self, pk) -> None: ...
    def get_public_key(self): ...

class DSAPrivateKey(PrivateKey):
    def __init__(self, pk) -> None: ...
    def get_public_key(self): ...
    @staticmethod
    def generate(algo=..., bits: int = ..., flags: int = ...): ...

class PublicKey:
    def __new__(cls, *args, **kwargs): ...
    pubkey: Any
    def __init__(self, pubkey: Any | None = ...) -> None: ...
    def __get__(self, obj, type_: Any | None = ...): ...
    def __set__(self, obj, value) -> None: ...
    def __del__(self) -> None: ...
    def import_x509(self, x509_cert, flags: int = ...) -> None: ...
    def get_preferred_hash_algorithm(self): ...
    @staticmethod
    def upcast(algo: int, pubkey: PublicKey) -> Union[PublicKey, RSAPublicKey, DSAPublicKey]: ...
    @staticmethod
    def import_uri(uri: str, flags: int = ..., srk_password: Optional[str] = ...) -> Union[PublicKey, RSAPublicKey, DSAPublicKey]: ...
    def verify_data2(self, sign_algo: int, flags: int, buf: bytes, signature: bytes) -> None: ...
    def verify_hash2(self, sign_algo: int, flags: int, hashbuf: bytes, signature: bytes) -> None: ...
    def encrypt_data(self, flags: int, plaintext: bytes) -> str: ...

class RSAPublicKey(PublicKey):
    def __init__(self, pubkey) -> None: ...
    @staticmethod
    def import_rsa_raw(m: bytes, e: bytes) -> RSAPublicKey: ...
    def export_rsa_raw(self) -> Tuple[str, str]: ...

class DSAPublicKey(PublicKey):
    def __init__(self, pubkey) -> None: ...
    @staticmethod
    def import_dsa_raw(p: bytes, q: bytes, g: bytes, y: bytes) -> DSAPublicKey: ...
    def export_dsa_raw(self) -> Tuple[str, str, str, str]: ...

class X509Certificate(CWrapper):
    def __new__(cls, *args, **kwargs): ...
    def __init__(self, buf: bytes, format: int = ...) -> None: ...
    def __del__(self) -> None: ...
    @property
    def subject(self) -> X509Name: ...
    @property
    def issuer(self) -> X509Name: ...
    @property
    def alternative_names(self) -> AlternativeNames: ...
    @property
    def serial_number(self) -> str: ...
    @property
    def activation_time(self) -> int: ...
    @property
    def expiration_time(self) -> int: ...
    @property
    def version(self) -> int: ...
    def has_issuer(self, issuer: X509Certificate) -> bool: ...
    def has_hostname(self, hostname: str) -> bool: ...
    def check_issuer(self, issuer: X509Certificate) -> None: ...
    def check_hostname(self, hostname: str) -> None: ...
    def export(self, format: int = ...) -> bytes: ...

class X509PrivateKey(CWrapper):
    def __new__(cls, *args, **kwargs): ...
    def __init__(self, buf, format=...) -> None: ...
    def __del__(self) -> None: ...
    def export(self, format: int = ...) -> bytes: ...

class X509Identity:
    cert: Any
    key: Any
    def __init__(self, cert, key) -> None: ...
    def __setattr__(self, name, value) -> None: ...
    def __delattr__(self, name) -> None: ...

class X509CRL(CWrapper):
    def __new__(cls, *args, **kwargs): ...
    def __init__(self, buf, format=...) -> None: ...
    def __del__(self) -> None: ...
    @property
    def count(self) -> int: ...
    @property
    def version(self) -> int: ...
    @property
    def issuer(self) -> X509Name: ...
    def is_revoked(self, cert: X509Certificate) -> bool: ...
    def check_revocation(self, cert: X509Certificate, cert_name: str = ...) -> None: ...
    def export(self, format: int = ...) -> bytes: ...

class DHParams(CWrapper):
    def __new__(cls, *args, **kwargs): ...
    def __init__(self, bits: int = ...) -> None: ...
    def __get__(self, obj, type_: Any | None = ...): ...
    def __set__(self, obj, value) -> None: ...
    def __del__(self) -> None: ...

class Cipher(CWrapper):
    ctype: Any
    algorithm: Any
    deinit: Any
    def __init__(self, algo, key, iv) -> None: ...
    def set_iv(self, iv: bytes) -> None: ...
    def add_auth(self, auth: bytes) -> None: ...
    def decrypt(self, cipher_text: bytes) -> bytes: ...
    def encrypt(self, plain_text: bytes) -> bytes: ...
    def cipher_tag(self, tag_size: int) -> bytes: ...

class AEADCipher(CWrapper):
    ctype: Any
    deinit: Any
    def __init__(self, algo, key) -> None: ...
    def encrypt(self, nonce: bytes, auth: bytes, tag_size: int, plain_text: bytes) -> bytes: ...
    def decrypt(self, nonce: bytes, auth: bytes, tag_size: int, cipher_text: bytes) -> bytes: ...
