from typing import Any, Optional

class _ServerNameIdentities(dict):
    def __init__(self, identities) -> None: ...
    def add(self, identity) -> None: ...
    def get(self, server_name, default: Any | None = ...): ...

class X509Credentials:
    def __new__(cls, *args, **kwargs): ...
    crl_list: Any
    server_name_identities: Any
    def __init__(self, cert: Any | None = ..., key: Any | None = ..., trusted=..., crl_list=..., identities=...) -> None: ...
    def __del__(self) -> None: ...
    def add_trusted(self, trusted) -> None: ...
    @property
    def cert(self): ...
    @property
    def key(self): ...
    @property
    def identities(self): ...
    @property
    def trusted(self): ...
    max_verify_length: Any
    max_verify_bits: Any
    def check_certificate(self, cert, cert_name: str = ...) -> None: ...
    def select_server_identity(self, session): ...

class TLSContextServerOptions:
    certificate_request: Any
    def __init__(self, certificate_request=...) -> None: ...

class TLSContext:
    credentials: Any
    server_options: Any
    def __init__(self, credentials, session_parameters: Any | None = ..., server_options: Any | None = ...) -> None: ...
    @property
    def session_parameters(self): ...
    @session_parameters.setter
    def session_parameters(self, value) -> None: ...

class Session:
    session_type: Optional[int]
    def __new__(cls, *args, **kwargs): ...
    socket: Any
    credentials: Any
    def __init__(self, socket, context) -> None: ...
    def __del__(self) -> None: ...
    def __getattr__(self, name): ...
    @property
    def protocol(self): ...
    @property
    def kx_algorithm(self): ...
    @property
    def cipher(self): ...
    @property
    def mac_algorithm(self): ...
    @property
    def compression(self): ...
    @property
    def peer_certificate(self): ...
    @property
    def interrupted_while_writing(self): ...
    @property
    def interrupted_while_reading(self): ...
    def handshake(self) -> None: ...
    def send(self, data): ...
    def sendall(self, data) -> None: ...
    def recv(self, limit): ...
    def send_alert(self, exception) -> None: ...
    def bye(self, how=...) -> None: ...
    def shutdown(self, how=...) -> None: ...
    def close(self) -> None: ...
    def verify_peer(self) -> None: ...

class ClientSession(Session):
    session_type: Any
    server_name: Any
    def __init__(self, socket, context, server_name: Any | None = ...) -> None: ...

class ServerSession(Session):
    session_type: Any
    def __init__(self, socket, context) -> None: ...
    @property
    def server_name(self): ...

class ServerSessionFactory:
    socket: Any
    context: Any
    session_class: Any
    def __init__(self, socket, context, session_class=...) -> None: ...
    def __getattr__(self, name): ...
    def bind(self, address) -> None: ...
    def listen(self, backlog) -> None: ...
    def accept(self): ...
    def shutdown(self, how=...) -> None: ...
    def close(self) -> None: ...
