# pyPcazip: PCA-based trajectory file compression and analysis. #

## NEWS: 07/08/2017: pyPcazip used by FFEA project. ##

pyPcazip is used by the "Fluctuating Finite Element" mesoscale simulation software suite - see [here](http://ffea.readthedocs.io/en/latest/) for details.


## NEWS: 13/03/2017: pyPcazip used in WCG "Help Stop TB" project ##

pyPcazip is used by the project team to analyse simulation data on the structure of mycolic acids - see [here](https://www.worldcommunitygrid.org/research/hst1/overview.do) for details.


## NEWS: 01/01/2017: pyPcazip 2.0 released ##

The latest release of pyPcazip features:

* Easier installation (no dependency on a fortran compiler)
* Faster data compression
* A VMD plugin

**Note**: Files produced by previous versions of pyPcazip (1.x) are NOT compatible with this release of the software.

## Introduction

*pyPcazip* is a Python-based suite of software tools for Principal Component Analysis of molecular dynamics simulation data, and also for its compression. It is compatible with trajectory file formats generated by most contemporary MD engines such as AMBER, CHARMM, GROMACS and NAMD, and is MPI parallelized to permit the efficient processing of very large datasets.

###Compression:
*pyPcazip* can compress MD trajectories to a small fraction (few percent) of their original size with no significant loss of information. The trade-off between degree of compression and precision (in terms of fraction of the total variance that is retained) is under complete user control. A *molfile plugin* is available to allow the compressed files to be read directly into VMD.

###Analysis:
Trajectory compression with *pyPcazip* provides the gateway to a range of analysis methods that provide objective, quantitative and comparative metrics related to convergence and sampling, and the similarity between one trajectory and another.

## For full information [see the Wiki pages](https://bitbucket.org/ramonbsc/pypcazip/wiki/Home).

## Who do I talk to? ##

* charles.laughton@nottingham.ac.uk
* ardita.shkurti@nottingham.ac.uk (Repo admin)
* rgoni@mmb.pcb.ub.es (Repo owner/admin)

## Other contributors: ##
* e.breitmoser@epcc.ed.ac.uk
* ibethune@epcc.ed.ac.uk
* kwabenantim@yahoo.com

![logos.jpg](https://bitbucket.org/repo/XRMEjz/images/965878357-logos.jpg)