# coding: utf-8

"""
    Pulp 3 API

    Fetch, Upload, Organize, and Distribute Software Packages  # noqa: E501

    The version of the OpenAPI document: v3
    Contact: pulp-list@redhat.com
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from pulpcore.client.pulp_certguard.api_client import ApiClient
from pulpcore.client.pulp_certguard.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class ContentguardsX509Api(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create(self, certguard_x509_cert_guard, **kwargs):  # noqa: E501
        """Create a x509 cert guard  # noqa: E501

        X509CertGuard API Viewsets.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create(certguard_x509_cert_guard, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param CertguardX509CertGuard certguard_x509_cert_guard: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CertguardX509CertGuardResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.create_with_http_info(certguard_x509_cert_guard, **kwargs)  # noqa: E501

    def create_with_http_info(self, certguard_x509_cert_guard, **kwargs):  # noqa: E501
        """Create a x509 cert guard  # noqa: E501

        X509CertGuard API Viewsets.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_with_http_info(certguard_x509_cert_guard, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param CertguardX509CertGuard certguard_x509_cert_guard: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CertguardX509CertGuardResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'certguard_x509_cert_guard'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'certguard_x509_cert_guard' is set
        if self.api_client.client_side_validation and ('certguard_x509_cert_guard' not in local_var_params or  # noqa: E501
                                                        local_var_params['certguard_x509_cert_guard'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `certguard_x509_cert_guard` when calling `create`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'certguard_x509_cert_guard' in local_var_params:
            body_params = local_var_params['certguard_x509_cert_guard']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '/pulp/api/v3/contentguards/certguard/x509/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CertguardX509CertGuardResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete(self, certguard_x509_cert_guard_href, **kwargs):  # noqa: E501
        """Delete a x509 cert guard  # noqa: E501

        X509CertGuard API Viewsets.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete(certguard_x509_cert_guard_href, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str certguard_x509_cert_guard_href: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_with_http_info(certguard_x509_cert_guard_href, **kwargs)  # noqa: E501

    def delete_with_http_info(self, certguard_x509_cert_guard_href, **kwargs):  # noqa: E501
        """Delete a x509 cert guard  # noqa: E501

        X509CertGuard API Viewsets.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_with_http_info(certguard_x509_cert_guard_href, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str certguard_x509_cert_guard_href: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'certguard_x509_cert_guard_href'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'certguard_x509_cert_guard_href' is set
        if self.api_client.client_side_validation and ('certguard_x509_cert_guard_href' not in local_var_params or  # noqa: E501
                                                        local_var_params['certguard_x509_cert_guard_href'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `certguard_x509_cert_guard_href` when calling `delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'certguard_x509_cert_guard_href' in local_var_params:
            path_params['certguard_x509_cert_guard_href'] = local_var_params['certguard_x509_cert_guard_href']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '{certguard_x509_cert_guard_href}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list(self, **kwargs):  # noqa: E501
        """List x509 cert guards  # noqa: E501

        X509CertGuard API Viewsets.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int limit: Number of results to return per page.
        :param str name:
        :param str name__contains: Filter results where name contains value
        :param str name__icontains: Filter results where name contains value
        :param list[str] name__in: Filter results where name is in a comma-separated list of values
        :param str name__startswith: Filter results where name starts with value
        :param int offset: The initial index from which to return the results.
        :param str ordering: Which field to use when ordering the results.
        :param str fields: A list of fields to include in the response.
        :param str exclude_fields: A list of fields to exclude from the response.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: PaginatedcertguardX509CertGuardResponseList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.list_with_http_info(**kwargs)  # noqa: E501

    def list_with_http_info(self, **kwargs):  # noqa: E501
        """List x509 cert guards  # noqa: E501

        X509CertGuard API Viewsets.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int limit: Number of results to return per page.
        :param str name:
        :param str name__contains: Filter results where name contains value
        :param str name__icontains: Filter results where name contains value
        :param list[str] name__in: Filter results where name is in a comma-separated list of values
        :param str name__startswith: Filter results where name starts with value
        :param int offset: The initial index from which to return the results.
        :param str ordering: Which field to use when ordering the results.
        :param str fields: A list of fields to include in the response.
        :param str exclude_fields: A list of fields to exclude from the response.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(PaginatedcertguardX509CertGuardResponseList, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'limit',
            'name',
            'name__contains',
            'name__icontains',
            'name__in',
            'name__startswith',
            'offset',
            'ordering',
            'fields',
            'exclude_fields'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'name__contains' in local_var_params and local_var_params['name__contains'] is not None:  # noqa: E501
            query_params.append(('name__contains', local_var_params['name__contains']))  # noqa: E501
        if 'name__icontains' in local_var_params and local_var_params['name__icontains'] is not None:  # noqa: E501
            query_params.append(('name__icontains', local_var_params['name__icontains']))  # noqa: E501
        if 'name__in' in local_var_params and local_var_params['name__in'] is not None:  # noqa: E501
            query_params.append(('name__in', local_var_params['name__in']))  # noqa: E501
            collection_formats['name__in'] = 'csv'  # noqa: E501
        if 'name__startswith' in local_var_params and local_var_params['name__startswith'] is not None:  # noqa: E501
            query_params.append(('name__startswith', local_var_params['name__startswith']))  # noqa: E501
        if 'offset' in local_var_params and local_var_params['offset'] is not None:  # noqa: E501
            query_params.append(('offset', local_var_params['offset']))  # noqa: E501
        if 'ordering' in local_var_params and local_var_params['ordering'] is not None:  # noqa: E501
            query_params.append(('ordering', local_var_params['ordering']))  # noqa: E501
        if 'fields' in local_var_params and local_var_params['fields'] is not None:  # noqa: E501
            query_params.append(('fields', local_var_params['fields']))  # noqa: E501
        if 'exclude_fields' in local_var_params and local_var_params['exclude_fields'] is not None:  # noqa: E501
            query_params.append(('exclude_fields', local_var_params['exclude_fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '/pulp/api/v3/contentguards/certguard/x509/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PaginatedcertguardX509CertGuardResponseList',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def partial_update(self, certguard_x509_cert_guard_href, patchedcertguard_x509_cert_guard, **kwargs):  # noqa: E501
        """Update a x509 cert guard  # noqa: E501

        X509CertGuard API Viewsets.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.partial_update(certguard_x509_cert_guard_href, patchedcertguard_x509_cert_guard, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str certguard_x509_cert_guard_href: (required)
        :param PatchedcertguardX509CertGuard patchedcertguard_x509_cert_guard: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CertguardX509CertGuardResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.partial_update_with_http_info(certguard_x509_cert_guard_href, patchedcertguard_x509_cert_guard, **kwargs)  # noqa: E501

    def partial_update_with_http_info(self, certguard_x509_cert_guard_href, patchedcertguard_x509_cert_guard, **kwargs):  # noqa: E501
        """Update a x509 cert guard  # noqa: E501

        X509CertGuard API Viewsets.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.partial_update_with_http_info(certguard_x509_cert_guard_href, patchedcertguard_x509_cert_guard, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str certguard_x509_cert_guard_href: (required)
        :param PatchedcertguardX509CertGuard patchedcertguard_x509_cert_guard: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CertguardX509CertGuardResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'certguard_x509_cert_guard_href',
            'patchedcertguard_x509_cert_guard'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method partial_update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'certguard_x509_cert_guard_href' is set
        if self.api_client.client_side_validation and ('certguard_x509_cert_guard_href' not in local_var_params or  # noqa: E501
                                                        local_var_params['certguard_x509_cert_guard_href'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `certguard_x509_cert_guard_href` when calling `partial_update`")  # noqa: E501
        # verify the required parameter 'patchedcertguard_x509_cert_guard' is set
        if self.api_client.client_side_validation and ('patchedcertguard_x509_cert_guard' not in local_var_params or  # noqa: E501
                                                        local_var_params['patchedcertguard_x509_cert_guard'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `patchedcertguard_x509_cert_guard` when calling `partial_update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'certguard_x509_cert_guard_href' in local_var_params:
            path_params['certguard_x509_cert_guard_href'] = local_var_params['certguard_x509_cert_guard_href']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'patchedcertguard_x509_cert_guard' in local_var_params:
            body_params = local_var_params['patchedcertguard_x509_cert_guard']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '{certguard_x509_cert_guard_href}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CertguardX509CertGuardResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def read(self, certguard_x509_cert_guard_href, **kwargs):  # noqa: E501
        """Inspect a x509 cert guard  # noqa: E501

        X509CertGuard API Viewsets.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.read(certguard_x509_cert_guard_href, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str certguard_x509_cert_guard_href: (required)
        :param str fields: A list of fields to include in the response.
        :param str exclude_fields: A list of fields to exclude from the response.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CertguardX509CertGuardResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.read_with_http_info(certguard_x509_cert_guard_href, **kwargs)  # noqa: E501

    def read_with_http_info(self, certguard_x509_cert_guard_href, **kwargs):  # noqa: E501
        """Inspect a x509 cert guard  # noqa: E501

        X509CertGuard API Viewsets.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.read_with_http_info(certguard_x509_cert_guard_href, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str certguard_x509_cert_guard_href: (required)
        :param str fields: A list of fields to include in the response.
        :param str exclude_fields: A list of fields to exclude from the response.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CertguardX509CertGuardResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'certguard_x509_cert_guard_href',
            'fields',
            'exclude_fields'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method read" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'certguard_x509_cert_guard_href' is set
        if self.api_client.client_side_validation and ('certguard_x509_cert_guard_href' not in local_var_params or  # noqa: E501
                                                        local_var_params['certguard_x509_cert_guard_href'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `certguard_x509_cert_guard_href` when calling `read`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'certguard_x509_cert_guard_href' in local_var_params:
            path_params['certguard_x509_cert_guard_href'] = local_var_params['certguard_x509_cert_guard_href']  # noqa: E501

        query_params = []
        if 'fields' in local_var_params and local_var_params['fields'] is not None:  # noqa: E501
            query_params.append(('fields', local_var_params['fields']))  # noqa: E501
        if 'exclude_fields' in local_var_params and local_var_params['exclude_fields'] is not None:  # noqa: E501
            query_params.append(('exclude_fields', local_var_params['exclude_fields']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '{certguard_x509_cert_guard_href}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CertguardX509CertGuardResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update(self, certguard_x509_cert_guard_href, certguard_x509_cert_guard, **kwargs):  # noqa: E501
        """Update a x509 cert guard  # noqa: E501

        X509CertGuard API Viewsets.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update(certguard_x509_cert_guard_href, certguard_x509_cert_guard, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str certguard_x509_cert_guard_href: (required)
        :param CertguardX509CertGuard certguard_x509_cert_guard: (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CertguardX509CertGuardResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.update_with_http_info(certguard_x509_cert_guard_href, certguard_x509_cert_guard, **kwargs)  # noqa: E501

    def update_with_http_info(self, certguard_x509_cert_guard_href, certguard_x509_cert_guard, **kwargs):  # noqa: E501
        """Update a x509 cert guard  # noqa: E501

        X509CertGuard API Viewsets.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_with_http_info(certguard_x509_cert_guard_href, certguard_x509_cert_guard, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str certguard_x509_cert_guard_href: (required)
        :param CertguardX509CertGuard certguard_x509_cert_guard: (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CertguardX509CertGuardResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'certguard_x509_cert_guard_href',
            'certguard_x509_cert_guard'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'certguard_x509_cert_guard_href' is set
        if self.api_client.client_side_validation and ('certguard_x509_cert_guard_href' not in local_var_params or  # noqa: E501
                                                        local_var_params['certguard_x509_cert_guard_href'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `certguard_x509_cert_guard_href` when calling `update`")  # noqa: E501
        # verify the required parameter 'certguard_x509_cert_guard' is set
        if self.api_client.client_side_validation and ('certguard_x509_cert_guard' not in local_var_params or  # noqa: E501
                                                        local_var_params['certguard_x509_cert_guard'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `certguard_x509_cert_guard` when calling `update`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'certguard_x509_cert_guard_href' in local_var_params:
            path_params['certguard_x509_cert_guard_href'] = local_var_params['certguard_x509_cert_guard_href']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'certguard_x509_cert_guard' in local_var_params:
            body_params = local_var_params['certguard_x509_cert_guard']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json', 'application/x-www-form-urlencoded', 'multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basicAuth', 'cookieAuth']  # noqa: E501

        return self.api_client.call_api(
            '{certguard_x509_cert_guard_href}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CertguardX509CertGuardResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
