# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from odahuflow.sdk.models.base_model_ import Model
from odahuflow.sdk.models.node_pool import NodePool  # noqa: F401,E501
from odahuflow.sdk.models.resource_requirements import ResourceRequirements  # noqa: F401,E501
from odahuflow.sdk.models import util


class ModelPackagingConfig(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, default_resources: ResourceRequirements=None, enabled: bool=None, model_packager_image: str=None, namespace: str=None, node_pools: List[NodePool]=None, output_connection_id: str=None, packager_integration_namespace: str=None, packaging_integration_repository_type: str=None, service_account: str=None, timeout: str=None, tolerations: str=None):  # noqa: E501
        """ModelPackagingConfig - a model defined in Swagger

        :param default_resources: The default_resources of this ModelPackagingConfig.  # noqa: E501
        :type default_resources: ResourceRequirements
        :param enabled: The enabled of this ModelPackagingConfig.  # noqa: E501
        :type enabled: bool
        :param model_packager_image: The model_packager_image of this ModelPackagingConfig.  # noqa: E501
        :type model_packager_image: str
        :param namespace: The namespace of this ModelPackagingConfig.  # noqa: E501
        :type namespace: str
        :param node_pools: The node_pools of this ModelPackagingConfig.  # noqa: E501
        :type node_pools: List[NodePool]
        :param output_connection_id: The output_connection_id of this ModelPackagingConfig.  # noqa: E501
        :type output_connection_id: str
        :param packager_integration_namespace: The packager_integration_namespace of this ModelPackagingConfig.  # noqa: E501
        :type packager_integration_namespace: str
        :param packaging_integration_repository_type: The packaging_integration_repository_type of this ModelPackagingConfig.  # noqa: E501
        :type packaging_integration_repository_type: str
        :param service_account: The service_account of this ModelPackagingConfig.  # noqa: E501
        :type service_account: str
        :param timeout: The timeout of this ModelPackagingConfig.  # noqa: E501
        :type timeout: str
        :param tolerations: The tolerations of this ModelPackagingConfig.  # noqa: E501
        :type tolerations: str
        """
        self.swagger_types = {
            'default_resources': ResourceRequirements,
            'enabled': bool,
            'model_packager_image': str,
            'namespace': str,
            'node_pools': List[NodePool],
            'output_connection_id': str,
            'packager_integration_namespace': str,
            'packaging_integration_repository_type': str,
            'service_account': str,
            'timeout': str,
            'tolerations': str
        }

        self.attribute_map = {
            'default_resources': 'defaultResources',
            'enabled': 'enabled',
            'model_packager_image': 'modelPackagerImage',
            'namespace': 'namespace',
            'node_pools': 'nodePools',
            'output_connection_id': 'outputConnectionID',
            'packager_integration_namespace': 'packagerIntegrationNamespace',
            'packaging_integration_repository_type': 'packagingIntegrationRepositoryType',
            'service_account': 'serviceAccount',
            'timeout': 'timeout',
            'tolerations': 'tolerations'
        }

        self._default_resources = default_resources
        self._enabled = enabled
        self._model_packager_image = model_packager_image
        self._namespace = namespace
        self._node_pools = node_pools
        self._output_connection_id = output_connection_id
        self._packager_integration_namespace = packager_integration_namespace
        self._packaging_integration_repository_type = packaging_integration_repository_type
        self._service_account = service_account
        self._timeout = timeout
        self._tolerations = tolerations

    @classmethod
    def from_dict(cls, dikt) -> 'ModelPackagingConfig':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The ModelPackagingConfig of this ModelPackagingConfig.  # noqa: E501
        :rtype: ModelPackagingConfig
        """
        return util.deserialize_model(dikt, cls)

    @property
    def default_resources(self) -> ResourceRequirements:
        """Gets the default_resources of this ModelPackagingConfig.

        Default resources for packaging pods  # noqa: E501

        :return: The default_resources of this ModelPackagingConfig.
        :rtype: ResourceRequirements
        """
        return self._default_resources

    @default_resources.setter
    def default_resources(self, default_resources: ResourceRequirements):
        """Sets the default_resources of this ModelPackagingConfig.

        Default resources for packaging pods  # noqa: E501

        :param default_resources: The default_resources of this ModelPackagingConfig.
        :type default_resources: ResourceRequirements
        """

        self._default_resources = default_resources

    @property
    def enabled(self) -> bool:
        """Gets the enabled of this ModelPackagingConfig.

        Enable packaging API/operator  # noqa: E501

        :return: The enabled of this ModelPackagingConfig.
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled: bool):
        """Sets the enabled of this ModelPackagingConfig.

        Enable packaging API/operator  # noqa: E501

        :param enabled: The enabled of this ModelPackagingConfig.
        :type enabled: bool
        """

        self._enabled = enabled

    @property
    def model_packager_image(self) -> str:
        """Gets the model_packager_image of this ModelPackagingConfig.


        :return: The model_packager_image of this ModelPackagingConfig.
        :rtype: str
        """
        return self._model_packager_image

    @model_packager_image.setter
    def model_packager_image(self, model_packager_image: str):
        """Sets the model_packager_image of this ModelPackagingConfig.


        :param model_packager_image: The model_packager_image of this ModelPackagingConfig.
        :type model_packager_image: str
        """

        self._model_packager_image = model_packager_image

    @property
    def namespace(self) -> str:
        """Gets the namespace of this ModelPackagingConfig.

        Kubernetes namespace, where model trainings will be deployed  # noqa: E501

        :return: The namespace of this ModelPackagingConfig.
        :rtype: str
        """
        return self._namespace

    @namespace.setter
    def namespace(self, namespace: str):
        """Sets the namespace of this ModelPackagingConfig.

        Kubernetes namespace, where model trainings will be deployed  # noqa: E501

        :param namespace: The namespace of this ModelPackagingConfig.
        :type namespace: str
        """

        self._namespace = namespace

    @property
    def node_pools(self) -> List[NodePool]:
        """Gets the node_pools of this ModelPackagingConfig.

        Node pools to run packaging tasks on  # noqa: E501

        :return: The node_pools of this ModelPackagingConfig.
        :rtype: List[NodePool]
        """
        return self._node_pools

    @node_pools.setter
    def node_pools(self, node_pools: List[NodePool]):
        """Sets the node_pools of this ModelPackagingConfig.

        Node pools to run packaging tasks on  # noqa: E501

        :param node_pools: The node_pools of this ModelPackagingConfig.
        :type node_pools: List[NodePool]
        """

        self._node_pools = node_pools

    @property
    def output_connection_id(self) -> str:
        """Gets the output_connection_id of this ModelPackagingConfig.


        :return: The output_connection_id of this ModelPackagingConfig.
        :rtype: str
        """
        return self._output_connection_id

    @output_connection_id.setter
    def output_connection_id(self, output_connection_id: str):
        """Sets the output_connection_id of this ModelPackagingConfig.


        :param output_connection_id: The output_connection_id of this ModelPackagingConfig.
        :type output_connection_id: str
        """

        self._output_connection_id = output_connection_id

    @property
    def packager_integration_namespace(self) -> str:
        """Gets the packager_integration_namespace of this ModelPackagingConfig.


        :return: The packager_integration_namespace of this ModelPackagingConfig.
        :rtype: str
        """
        return self._packager_integration_namespace

    @packager_integration_namespace.setter
    def packager_integration_namespace(self, packager_integration_namespace: str):
        """Sets the packager_integration_namespace of this ModelPackagingConfig.


        :param packager_integration_namespace: The packager_integration_namespace of this ModelPackagingConfig.
        :type packager_integration_namespace: str
        """

        self._packager_integration_namespace = packager_integration_namespace

    @property
    def packaging_integration_repository_type(self) -> str:
        """Gets the packaging_integration_repository_type of this ModelPackagingConfig.

        Storage backend for packaging integrations. Available options:   * kubernetes   * postgres  # noqa: E501

        :return: The packaging_integration_repository_type of this ModelPackagingConfig.
        :rtype: str
        """
        return self._packaging_integration_repository_type

    @packaging_integration_repository_type.setter
    def packaging_integration_repository_type(self, packaging_integration_repository_type: str):
        """Sets the packaging_integration_repository_type of this ModelPackagingConfig.

        Storage backend for packaging integrations. Available options:   * kubernetes   * postgres  # noqa: E501

        :param packaging_integration_repository_type: The packaging_integration_repository_type of this ModelPackagingConfig.
        :type packaging_integration_repository_type: str
        """

        self._packaging_integration_repository_type = packaging_integration_repository_type

    @property
    def service_account(self) -> str:
        """Gets the service_account of this ModelPackagingConfig.


        :return: The service_account of this ModelPackagingConfig.
        :rtype: str
        """
        return self._service_account

    @service_account.setter
    def service_account(self, service_account: str):
        """Sets the service_account of this ModelPackagingConfig.


        :param service_account: The service_account of this ModelPackagingConfig.
        :type service_account: str
        """

        self._service_account = service_account

    @property
    def timeout(self) -> str:
        """Gets the timeout of this ModelPackagingConfig.

        Timeout for full training process  # noqa: E501

        :return: The timeout of this ModelPackagingConfig.
        :rtype: str
        """
        return self._timeout

    @timeout.setter
    def timeout(self, timeout: str):
        """Sets the timeout of this ModelPackagingConfig.

        Timeout for full training process  # noqa: E501

        :param timeout: The timeout of this ModelPackagingConfig.
        :type timeout: str
        """

        self._timeout = timeout

    @property
    def tolerations(self) -> str:
        """Gets the tolerations of this ModelPackagingConfig.

        Kubernetes tolerations for model packaging pods  # noqa: E501

        :return: The tolerations of this ModelPackagingConfig.
        :rtype: str
        """
        return self._tolerations

    @tolerations.setter
    def tolerations(self, tolerations: str):
        """Sets the tolerations of this ModelPackagingConfig.

        Kubernetes tolerations for model packaging pods  # noqa: E501

        :param tolerations: The tolerations of this ModelPackagingConfig.
        :type tolerations: str
        """

        self._tolerations = tolerations
