# coding: utf-8

"""
    Sematext Cloud API

    API Explorer provides access and documentation for Sematext REST API. The REST API requires the API Key to be sent as part of `Authorization` header. E.g.: `Authorization : apiKey e5f18450-205a-48eb-8589-7d49edaea813`.  # noqa: E501

    OpenAPI spec version: v3

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class Invitation(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'app': 'App',
        'apps': 'list[App]',
        'id': 'int',
        'invite_date': 'datetime',
        'invite_status': 'str',
        'invitee_email': 'str',
        'invitee_role': 'str',
        'invitee_status': 'str',
        'inviter_email': 'str',
        'uuid': 'str'
    }

    attribute_map = {
        'app': 'app',
        'apps': 'apps',
        'id': 'id',
        'invite_date': 'inviteDate',
        'invite_status': 'inviteStatus',
        'invitee_email': 'inviteeEmail',
        'invitee_role': 'inviteeRole',
        'invitee_status': 'inviteeStatus',
        'inviter_email': 'inviterEmail',
        'uuid': 'uuid'
    }

    def __init__(self, app=None, apps=None, id=None, invite_date=None, invite_status=None, invitee_email=None, invitee_role=None, invitee_status=None, inviter_email=None, uuid=None):  # noqa: E501
        """Invitation - a model defined in Swagger"""  # noqa: E501

        self._app = None
        self._apps = None
        self._id = None
        self._invite_date = None
        self._invite_status = None
        self._invitee_email = None
        self._invitee_role = None
        self._invitee_status = None
        self._inviter_email = None
        self._uuid = None
        self.discriminator = None

        if app is not None:
            self.app = app
        if apps is not None:
            self.apps = apps
        if id is not None:
            self.id = id
        if invite_date is not None:
            self.invite_date = invite_date
        if invite_status is not None:
            self.invite_status = invite_status
        if invitee_email is not None:
            self.invitee_email = invitee_email
        if invitee_role is not None:
            self.invitee_role = invitee_role
        if invitee_status is not None:
            self.invitee_status = invitee_status
        if inviter_email is not None:
            self.inviter_email = inviter_email
        if uuid is not None:
            self.uuid = uuid

    @property
    def app(self):
        """Gets the app of this Invitation.  # noqa: E501

        For invite request, only app.id needs to be set.  # noqa: E501

        :return: The app of this Invitation.  # noqa: E501
        :rtype: App
        """
        return self._app

    @app.setter
    def app(self, app):
        """Sets the app of this Invitation.

        For invite request, only app.id needs to be set.  # noqa: E501

        :param app: The app of this Invitation.  # noqa: E501
        :type: App
        """

        self._app = app

    @property
    def apps(self):
        """Gets the apps of this Invitation.  # noqa: E501

        For invite request, only apps.id needs to be set.  # noqa: E501

        :return: The apps of this Invitation.  # noqa: E501
        :rtype: list[App]
        """
        return self._apps

    @apps.setter
    def apps(self, apps):
        """Sets the apps of this Invitation.

        For invite request, only apps.id needs to be set.  # noqa: E501

        :param apps: The apps of this Invitation.  # noqa: E501
        :type: list[App]
        """

        self._apps = apps

    @property
    def id(self):
        """Gets the id of this Invitation.  # noqa: E501


        :return: The id of this Invitation.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Invitation.


        :param id: The id of this Invitation.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def invite_date(self):
        """Gets the invite_date of this Invitation.  # noqa: E501


        :return: The invite_date of this Invitation.  # noqa: E501
        :rtype: datetime
        """
        return self._invite_date

    @invite_date.setter
    def invite_date(self, invite_date):
        """Sets the invite_date of this Invitation.


        :param invite_date: The invite_date of this Invitation.  # noqa: E501
        :type: datetime
        """

        self._invite_date = invite_date

    @property
    def invite_status(self):
        """Gets the invite_status of this Invitation.  # noqa: E501


        :return: The invite_status of this Invitation.  # noqa: E501
        :rtype: str
        """
        return self._invite_status

    @invite_status.setter
    def invite_status(self, invite_status):
        """Sets the invite_status of this Invitation.


        :param invite_status: The invite_status of this Invitation.  # noqa: E501
        :type: str
        """
        allowed_values = ["PENDING", "ACCEPTED", "CANCELLED", "DECLINED"]  # noqa: E501
        if invite_status not in allowed_values:
            raise ValueError(
                "Invalid value for `invite_status` ({0}), must be one of {1}"  # noqa: E501
                .format(invite_status, allowed_values)
            )

        self._invite_status = invite_status

    @property
    def invitee_email(self):
        """Gets the invitee_email of this Invitation.  # noqa: E501


        :return: The invitee_email of this Invitation.  # noqa: E501
        :rtype: str
        """
        return self._invitee_email

    @invitee_email.setter
    def invitee_email(self, invitee_email):
        """Sets the invitee_email of this Invitation.


        :param invitee_email: The invitee_email of this Invitation.  # noqa: E501
        :type: str
        """

        self._invitee_email = invitee_email

    @property
    def invitee_role(self):
        """Gets the invitee_role of this Invitation.  # noqa: E501


        :return: The invitee_role of this Invitation.  # noqa: E501
        :rtype: str
        """
        return self._invitee_role

    @invitee_role.setter
    def invitee_role(self, invitee_role):
        """Sets the invitee_role of this Invitation.


        :param invitee_role: The invitee_role of this Invitation.  # noqa: E501
        :type: str
        """
        allowed_values = ["SUPER_USER", "OWNER", "ADMIN", "USER", "DEMO", "ANONYMOUS"]  # noqa: E501
        if invitee_role not in allowed_values:
            raise ValueError(
                "Invalid value for `invitee_role` ({0}), must be one of {1}"  # noqa: E501
                .format(invitee_role, allowed_values)
            )

        self._invitee_role = invitee_role

    @property
    def invitee_status(self):
        """Gets the invitee_status of this Invitation.  # noqa: E501


        :return: The invitee_status of this Invitation.  # noqa: E501
        :rtype: str
        """
        return self._invitee_status

    @invitee_status.setter
    def invitee_status(self, invitee_status):
        """Sets the invitee_status of this Invitation.


        :param invitee_status: The invitee_status of this Invitation.  # noqa: E501
        :type: str
        """
        allowed_values = ["INACTIVE", "ACTIVE"]  # noqa: E501
        if invitee_status not in allowed_values:
            raise ValueError(
                "Invalid value for `invitee_status` ({0}), must be one of {1}"  # noqa: E501
                .format(invitee_status, allowed_values)
            )

        self._invitee_status = invitee_status

    @property
    def inviter_email(self):
        """Gets the inviter_email of this Invitation.  # noqa: E501


        :return: The inviter_email of this Invitation.  # noqa: E501
        :rtype: str
        """
        return self._inviter_email

    @inviter_email.setter
    def inviter_email(self, inviter_email):
        """Sets the inviter_email of this Invitation.


        :param inviter_email: The inviter_email of this Invitation.  # noqa: E501
        :type: str
        """

        self._inviter_email = inviter_email

    @property
    def uuid(self):
        """Gets the uuid of this Invitation.  # noqa: E501


        :return: The uuid of this Invitation.  # noqa: E501
        :rtype: str
        """
        return self._uuid

    @uuid.setter
    def uuid(self, uuid):
        """Sets the uuid of this Invitation.


        :param uuid: The uuid of this Invitation.  # noqa: E501
        :type: str
        """

        self._uuid = uuid

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Invitation, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Invitation):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
