# coding: utf-8

"""
    Sematext Cloud API

    API Explorer provides access and documentation for Sematext REST API. The REST API requires the API Key to be sent as part of `Authorization` header. E.g.: `Authorization : apiKey e5f18450-205a-48eb-8589-7d49edaea813`.  # noqa: E501

    OpenAPI spec version: v3

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class AppMetadata(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'aws_cloud_watch_access_key': 'str',
        'aws_cloud_watch_secret_key': 'str',
        'aws_fetch_frequency': 'str',
        'aws_region': 'str',
        'sub_types': 'list[str]'
    }

    attribute_map = {
        'aws_cloud_watch_access_key': 'awsCloudWatchAccessKey',
        'aws_cloud_watch_secret_key': 'awsCloudWatchSecretKey',
        'aws_fetch_frequency': 'awsFetchFrequency',
        'aws_region': 'awsRegion',
        'sub_types': 'subTypes'
    }

    def __init__(self, aws_cloud_watch_access_key=None, aws_cloud_watch_secret_key=None, aws_fetch_frequency=None, aws_region=None, sub_types=None):  # noqa: E501
        """AppMetadata - a model defined in Swagger"""  # noqa: E501

        self._aws_cloud_watch_access_key = None
        self._aws_cloud_watch_secret_key = None
        self._aws_fetch_frequency = None
        self._aws_region = None
        self._sub_types = None
        self.discriminator = None

        if aws_cloud_watch_access_key is not None:
            self.aws_cloud_watch_access_key = aws_cloud_watch_access_key
        if aws_cloud_watch_secret_key is not None:
            self.aws_cloud_watch_secret_key = aws_cloud_watch_secret_key
        if aws_fetch_frequency is not None:
            self.aws_fetch_frequency = aws_fetch_frequency
        if aws_region is not None:
            self.aws_region = aws_region
        if sub_types is not None:
            self.sub_types = sub_types

    @property
    def aws_cloud_watch_access_key(self):
        """Gets the aws_cloud_watch_access_key of this AppMetadata.  # noqa: E501


        :return: The aws_cloud_watch_access_key of this AppMetadata.  # noqa: E501
        :rtype: str
        """
        return self._aws_cloud_watch_access_key

    @aws_cloud_watch_access_key.setter
    def aws_cloud_watch_access_key(self, aws_cloud_watch_access_key):
        """Sets the aws_cloud_watch_access_key of this AppMetadata.


        :param aws_cloud_watch_access_key: The aws_cloud_watch_access_key of this AppMetadata.  # noqa: E501
        :type: str
        """

        self._aws_cloud_watch_access_key = aws_cloud_watch_access_key

    @property
    def aws_cloud_watch_secret_key(self):
        """Gets the aws_cloud_watch_secret_key of this AppMetadata.  # noqa: E501


        :return: The aws_cloud_watch_secret_key of this AppMetadata.  # noqa: E501
        :rtype: str
        """
        return self._aws_cloud_watch_secret_key

    @aws_cloud_watch_secret_key.setter
    def aws_cloud_watch_secret_key(self, aws_cloud_watch_secret_key):
        """Sets the aws_cloud_watch_secret_key of this AppMetadata.


        :param aws_cloud_watch_secret_key: The aws_cloud_watch_secret_key of this AppMetadata.  # noqa: E501
        :type: str
        """

        self._aws_cloud_watch_secret_key = aws_cloud_watch_secret_key

    @property
    def aws_fetch_frequency(self):
        """Gets the aws_fetch_frequency of this AppMetadata.  # noqa: E501


        :return: The aws_fetch_frequency of this AppMetadata.  # noqa: E501
        :rtype: str
        """
        return self._aws_fetch_frequency

    @aws_fetch_frequency.setter
    def aws_fetch_frequency(self, aws_fetch_frequency):
        """Sets the aws_fetch_frequency of this AppMetadata.


        :param aws_fetch_frequency: The aws_fetch_frequency of this AppMetadata.  # noqa: E501
        :type: str
        """
        allowed_values = ["MINUTE", "FIVE_MINUTES", "FIFTEEN_MINUTES"]  # noqa: E501
        if aws_fetch_frequency not in allowed_values:
            raise ValueError(
                "Invalid value for `aws_fetch_frequency` ({0}), must be one of {1}"  # noqa: E501
                .format(aws_fetch_frequency, allowed_values)
            )

        self._aws_fetch_frequency = aws_fetch_frequency

    @property
    def aws_region(self):
        """Gets the aws_region of this AppMetadata.  # noqa: E501


        :return: The aws_region of this AppMetadata.  # noqa: E501
        :rtype: str
        """
        return self._aws_region

    @aws_region.setter
    def aws_region(self, aws_region):
        """Sets the aws_region of this AppMetadata.


        :param aws_region: The aws_region of this AppMetadata.  # noqa: E501
        :type: str
        """
        allowed_values = ["US_EAST_1", "US_WEST_1", "EU_WEST_1", "US_WEST_2", "AP_SOUTHEAST_1", "AP_SOUTHEAST_2", "AP_NORTHEAST_1", "SA_EAST_1", "GovCloud", "CN_NORTH_1", "US_EAST_2", "AP_SOUTH_1", "AP_NORTHEAST_2", "CA_CENTRAL_1", "EU_CENTRAL_1", "EU_WEST_2"]  # noqa: E501
        if aws_region not in allowed_values:
            raise ValueError(
                "Invalid value for `aws_region` ({0}), must be one of {1}"  # noqa: E501
                .format(aws_region, allowed_values)
            )

        self._aws_region = aws_region

    @property
    def sub_types(self):
        """Gets the sub_types of this AppMetadata.  # noqa: E501

        Comma separated list of AWS types monitored by created app  # noqa: E501

        :return: The sub_types of this AppMetadata.  # noqa: E501
        :rtype: list[str]
        """
        return self._sub_types

    @sub_types.setter
    def sub_types(self, sub_types):
        """Sets the sub_types of this AppMetadata.

        Comma separated list of AWS types monitored by created app  # noqa: E501

        :param sub_types: The sub_types of this AppMetadata.  # noqa: E501
        :type: list[str]
        """
        allowed_values = ["aws_ec2", "aws_elb", "aws_ebs"]  # noqa: E501
        if not set(sub_types).issubset(set(allowed_values)):
            raise ValueError(
                "Invalid values for `sub_types` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(sub_types) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._sub_types = sub_types

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(AppMetadata, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AppMetadata):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
