import argparse
import sys

from PyQt5.QtWidgets import QApplication

from .config import load_config
from .control import Control
from .model import Model
from .view import View


# EXAMPLE:
#   Use a function like this in your package '__init__' file and add it to the entry_points in the setup.py.
#   This function will load functions that are decorated with '@exec_ui' from all modules in 'camtest.contingency'
#   and dynamically create the GUI executor for them.
#
#     def contingency_ui():
#         cmd = ExternalCommand("gui-executor --module-path camtest.contingency", asynchronous=True)
#         cmd.start()
#
#   Replace 'camtest.contingency' by a package that contains the scripts you want to execute from the GUI.
#
#       entry_points={
#         "gui_scripts": [
#             "contingency_ui=camtest.contingency.__init__:contingency_ui",
#         ]
#     },


def main():

    parser = argparse.ArgumentParser(prog='gui-executor')
    parser.add_argument('--location', help='location of the Python modules and scripts')
    parser.add_argument('--module-path', help='module path of the Python modules and scripts')
    parser.add_argument('--config', help='a YAML file that configures the executor')

    args = parser.parse_args()

    # We have only implemented the --module-path option for now

    if args.module_path is None:
        print("You need to provide the --module-path option.")
        parser.print_help()
        return

    if args.config:
        load_config(args.config)

    app = QApplication([])

    view = View()
    model = Model(args.module_path)
    Control(view, model)

    view.show()

    return app.exec()


if __name__ == "__main__":
    sys.exit(main())
