# This File is a part of File-Find made by Pixel-Master and licensed under the GNU GPL v3
# This script contains File operations and global variables

# Imports
import os
from pickle import load, dump, UnpicklingError

# Project Libraries
import FF_Additional_UI

# Creating File-Find dir and deleting Cache
userpath = os.path.expanduser("~")
os.chdir(userpath)

LibFolder = os.path.join(os.path.join(os.path.join(os.getcwd(), "Library"), "Application Support"), "File-Find")
Cached_SearchesFolder = os.path.join(LibFolder, "Cached Searches")
Saved_SearchFolder = os.path.join(LibFolder, "Saved Searches")
AssetsFolder = os.path.join(LibFolder, ".assets")

# Versions
VERSION: str = "pre-beta 30.oct.22-pyqt6"
VERSION_SHORT: str = "0.0"


def get_file_size(file):
    if os.path.isdir(file):
        file_size_list_obj = 0
        # Gets the size
        for path, dirs, files in os.walk(file):
            for file in files:
                try:
                    file_size_list_obj += os.path.getsize(os.path.join(path, file))
                except FileNotFoundError or ValueError:
                    continue
    elif os.path.isfile(file):
        try:
            file_size_list_obj = os.path.getsize(file)
        except FileNotFoundError or ValueError:
            return -1
    else:
        return -1
    if os.path.islink(file):
        return -1
    else:
        return file_size_list_obj


def conv_file_size(byte_size: int) -> str:
    if byte_size == -1:
        return f"**ERROR** (File does not exist or isn't valid)"
    elif byte_size > 1000000000:
        return f"{round(byte_size / 1000000000, 2)} GB"
    elif byte_size > 1000000:
        return f"{round(byte_size / 1000000, 2)} MB"
    elif byte_size > 1000:
        return f"{round(byte_size / 1000, 2)} KB"
    else:
        return f"{byte_size} Bytes"


def setup():
    os.makedirs(Saved_SearchFolder, exist_ok=True)
    os.makedirs(Cached_SearchesFolder, exist_ok=True)
    os.makedirs(AssetsFolder, exist_ok=True)

    # Write File for Excluded Files
    try:
        with open(os.path.join(LibFolder, "Excluded_Files.FFSave"), "rb") as ExcludedLoadFile:
            excluded_file = load(ExcludedLoadFile)
    except (UnpicklingError, EOFError, FileNotFoundError):
        excluded_file = []

    with open(os.path.join(LibFolder, "Excluded_Files.FFSave"), "wb") as ExcludedDumpFile:
        dump(excluded_file, ExcludedDumpFile)

    # Write the File-Find Logo in an Image
    open(os.path.join(AssetsFolder, "FFlogo_small.png"), "wb").write(
        b'\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x00x\x00\x00\x00x\x08\x03\x00\x00\x00\x0e\xba\xc6\xe0\x00\x00'
        b'\x00WPLTE\x00\x00\x00\xfa\xfa\xfa   '
        b'\x15\x15\x15SSS\n\n\n\xf3\xf3\xf3\x00\x00\x00\xff\xff\xffUUU\xd1\xd1\xd1...\x83\x83\x83\x9d\x9d\x9d\xc8\xc8'
        b'\xc8:::\xe3\xe3\xe3\x90\x90\x90\xdb\xdb\xdbkkk\xa9\xa9\xa9\xec\xec\xecaaaMMMwww\xb4\xb4\xb4\xbf\xbf'
        b'\xbfDDDZZZ\xfa\xa2\xbd\xe2\x00\x00\x00\x01tRNS\xdc\xcf\x83F\x99\x00\x00\x07\xa2IDATh\xde\xed\x9a\xd9\xba'
        b'\xa3*\x10\x85[E\xa2(N \xe2\xf0\xfe\xcfyP4\x11\x15)\xdc\xd9\xdd7\x87\x9b\x1e>\xe5\x0f\xb0\xa4\xa8E\xfdy\xfd'
        b'\x9b\xf6\xe7\xcf\xff\xe0\x07-\x1b\xc3\xe8\x9f\x80iP\x15<\x17^\xf8o\x80\xe3!Y\x1a\xf6\xc1;\xc01\xa4\x8f'
        b'\xb0IvM\xe3C\x1fp\x9c\x8dc\x97N\x82I\x99\xe75\xa5\x9c\xf7=\x03\xa0K\x9c\x9c\xda\x10z\x80#\x12\xa8fv\xd0'
        b'\xe6n\xf2t\xe6\x06\x98\xc6>\xe0\x8b\x0e\x82\xdaI\xce\xaf\xc0\x81\xf8!8I\xa8K,'
        b'\xf4\x0c\xc6A\xd2d\xf05..\xc1\t\xbf\'_\xbc\x96\xcc\xaf\xf5\xf1\x0f\xc0I\xd5\xb6Uu?fS\xd4\xebkM\xd5b\t\x06'
        b'\x0f\xe7\x1e\xdaF\xb5\n\xf9\x8a\x1a\xb7\r!\xb7\xca6\xc0}bi\xccS\xd4\xeb\x8f.\xa1\x1b\xc83pn{'
        b'\xab\x82\x8e\xf8\xc5m]HOQ\xebV\xc4P\xb0\xb5\x8b\xdcS\xd4\xba\xf1\xd7\xaf\x82\xafD\xed~\xcb\x04\xd7\xb6.jOQ'
        b'\xeb&~\x17l\x155.\xc1`\xab>\xe9\xd7E\r\x04\xf3\xaf\x8b\xda\x04\xcb\x07\xe0\x87\xa26\xc1\xcc\xd6G\xffuQC\xc1'
        b'\xf1\xb7Em\x82\x85\xad\x8f!\xfe\xb6\xa8M\xf0\xf4@\'\x0fEm\x82Q\xe0\x0f~('
        b'j\x13\xdc\xd9\xc0$\xfa\xb6\xa8M\xf0\xe8\x0f~*j\x13lUh\x13}[\xd4@\xb0]('
        b'OEm\x82\xb3\xd6\x1b\xfcT\xd4@pk=#\xf3\x87\xa26\xc1!\x00\x9ce\xd1\xbeKZ\xe1G\xa2>\x80+\'8\xee1\x19\xa8D\x1b'
        b'>\x0e\xcb)\xe7E\x83=E}\x007N\xa5\xaciN\xd06\x0b>\xb4\xe2\x85\x0f8\xb2\x81\x83\xf1('
        b'\x03E&\xc3\xd0\xf3:g\xc7\xd1/\x93\xef\x12\xf5\x01\xac\x86\xa3\x12U\x8c\xe7\xbc\xa5Q\xb9@\xa1\xfa\xee9'
        b'\xa5uhlnmA\xa5\x98\xd2\x14\xcd\xc9tN\x87B\x8d\xfe\r\xd2\xf8\xde\'?~\xc5H\xa4]7\x96e\x96\x85a\x18EQ\xac\x9a'
        b'\xf9\xbc\x8a\x9c\re)B\xa9nH\xfdu\x92}\x9b\x90\xd2\xcfJ\xf0\xf5@\xea\x8a\x8a7\xf5\xdd\x10\xe3\xd5\xe0g\xfcx'
        b'\x82c\xc9\xce\xd8\x99\x8c$\xd9\xe98\x8e\xd4\x8ceYY~\xbc\r\x11\xff\x04\x1c\x97\x1b\x16\xa1\xf9oH\xff\xb1\xfc'
        b'\x87\xa0\xe3g?S\x19\xa6Jp1\xc6ok\xa3=8\x0b\x1a\x1cG\xeb\x82\x9e\xd6\xd4h\xd1\xb8QS\xa5\xa9~Q\xb5\xdcf\x1eM,'
        b'\xba\xf5\x08\xcc,[\x83\x99R0)\n%b\xa5\xe2\x9es%\xe4<\xb2s\xa7|\xa8\xb6\x91\xe0\x86\xcbT\xa3\xa72\xb6g\x06'
        b'\xed\xc1Y\xd0\xe0\x8b\xad\x1e\x9f\x0c\x88x\\u\x9c\x133n\xe3A\xae\xa3.\xed`\xac\xde\xd9\x7fcvpp '
        b'\xc7\xa5\x1e\xaf\xe8\xcf\xbbsE\xa7\x85\x8c2k\xccj\xb1\xda\x1fx\x08\x01\x1f\xec\x9el\xfdp\xc8\xe5\xd6\xd6'
        b'\x8b\x85\xdcE\xb6\xcc\xa0%s\x93\x07\xb0ej\xf6&Y\xd4-`f\xdbU\x07M\x1ec['
        b'J\x12\x98\x99\x81\x15\xac\xa6&\xd8\x9bk\xe5\xcdx\xf5\xa1\x7fZ~Y\x06LI\xec\xe0ej\xa6w\xe0Z\xc63\rVn\x12P'
        b'=\xd91,3\xb0\x82\xe7\xae\x82Ob\xac\x07\\\x07vpR1\xb4\r\x19\x0c\xa6\xae\x8c\\\xafp\xc7\x93\xbb6\xa4\xdb'
        b'*\x03R\x12\x0787$]\xf6\xb7\xe0V\xceCF\xd1]J\x12y\x82G\xfd\x95\x92['
        b'p\xc2\xb7\xb9\x06\xa4$\x1a\xcc\x1d\xe0x\x99\xe9\xd1z\n\xdd\xce\xfd\xcb\'U\xde\xa4$\r\x14\xbc~\xf0\x91\x1eJ'
        b'\x17\xdc\x83\xf12\xd7J\xd7\xf6\x94$\xf4\x03\xeb%\x0eY\xc0+\x008\x82\xa4$\x1a\xdcC\xc0('
        b'\xaa\x83\\\x9d\xf0\xaa\xeat\x81\xb0u\xabcE\x04II\x16\xb0\xd3\xb6\xd5\xe0\xb0o\x11\xef\xd4:\xf2A\xd2\x96'
        b'\xf7Mp8N\x17:\x8e\x84\x90\x94\x04\x06^:\xec2RM\x94Q\x99\xd7T\x94\xb5\x90\xb2\x16\xa2\xc5u\xddW\x05\xc1\xf3'
        b'\xe6\xce\xd7%\x81d\x06\x1a<@F\xdc\x95-\x1e\nuP\xa8)b\xa8fL\x8e\x8c5\xd5H\xbb\xba\xeb\xa8\xfaw\x93\x87.0\x86'
        b'\x82\xc5~\xaaE\xb0\x05\xae\xa6 \x05\xcb8e5!c>\xe5u.\xbb~,'
        b'\xc4\xba$\x90\x94\xc4\x07l\xec\xe8MM\xdbD\x9d\xe7\x86\x8e\x92~\xa0\xbd\x14%)W\x11\xdaS\x12<\x9a`\xab\x911'
        b'\xedb\x13\xba\xdc\xdfZ\xa2okj\xc1\x9al\\\xe3SD\x9c\xb9\x90\x03\x9c\xeeb\x04\xcaoc\x13\xc1E\xa87\xb8\xd7\r'
        b'\xb83\xc0\x91\r\x1c\xa0\xdd9\x0f\x89\xc6\xb1Ug\xdbQ vu\xb8\x81\x9d?P/\xde}TL\xf2r\xd5\x96{'
        b'\xed\xc0\xe0e\xb3F\xac\xba\x07w[<v\xaa\xd5\t\x1e\x8d35\xa2\xee\x9dz9\x81\x00n\xb04\xd8\x9d\x90\x87\xfaK\xbe'
        b'\x0b\xc8<\xfd\x1cp\x7f\n\xfe|v\xeb\x90\xa5}\xb2\x0b\xf1\x1e0\xe4\x06k\x01\x036\x9a\xf5\x98\x89r\xdb\xf6O'
        b'\xd8\xe7\x90\t\xb9H\x02\x83u\xa0P\xe4\xea\x8e\x8b\xc2S\xba8['
        b'\x1b\x1fo\xc3\x9cj\xfb\x9e\xbe\x07k\xed\xa8\x0c\xdc\x9e\xc1l\x03~M\xb4\xces)\x99\x98\x8e\xde\x86?8\xed\xc5'
        b'\x96\x81\x1f\x1e\x0fH>m6A\x19\xfbX\x11QM\xf9\\\x02\xa1R\xedAe\xc9*\x83Xn\x8d\xd5\xecd\x86\xbd\xd0\xadi9\xa3'
        b'\xbb\x13\x00.j\xb1s\'\xa0\xe4\x8f\x15\x11\xbfVK '
        b'ZZ8\xbb\x18\xa1\xd9\xcbJVh!\xe90\xff\xba\xa2\xaf\xe5d\xba"@\xb2\x9f\x07\xb2y\x02\xb3\xf9\x91NBL\x13\xda\x99'
        b'"^d_\xd7\xa7\xdc\r\xcf\x18)C\xdb|\xc0\xc8\xde\xb5>,OO\x86\x13B\x9d\xe8\xd1\xcb\x8bl:{'
        b'\xcb\x02\xcf\x0e\xd5lQuHM\xe6\xc9\xa8\xae\x83!\xffL\xb0\x9ec&\xc3x\xf63}\xc8F\x01\n\x9f\x15\xbd8T\xed\xecP'
        b'\xcdq\x9f\x8cgK> \\\x8a\ti\x93kb9\xaf\xf0Z\x98\xe3A6\xc0\xcdE\x01\xca\xb1\x14C\xdb%AEfs\x95\xf2\x81\xb4\x81'
        b':\xd8n\xde\x01\x9c\xec.\xb9i\'\xe3\x05ym\x97l\xf6\xd9\x91\x1c\xef\x96/\xb3\x82\xafKnZ\xf6\xba\xbf\xf8\xd4'
        b'\xae\x053\xbf\xf5\xb4\xcb\x97\xba\xacaY\xbef6\x18\x1b\xe6Qr\xd3\xaa\xa56\xc8W\xbe\xcabYn7\xae\x1by\xaa\xf1'
        b'\xe9\xb1]\x8d\x96\xab\xe4f\xf6\x1aIQ\xfa\xdc\xb8\xbe\xf7\xb7#\x19\xefm$\xe3s\x1a.\x1d\x98\xc0\xa8|\x01\xd8'
        b'\x1b6\xf2,\xc2\xb7i\xe7]r\x03\xb9q\xb5\x90g\x11\xbe\xedB\xef\x92\x1b\xd0\x8d\xeb;\x8e\x19d\xac]\xc5\xf8\x19'
        b'\x18v\xe3z=f<\xefK\xebs\xde%7#\xec\xc6\xf5z\xcc;\x1b\x04\x06\xae!W\xbd\xe6\x85O\xb6\x9e\x0eN\xe4*|Vr\x93'
        b'\x01\xafz\xb3\xdeB\xbe\x02CJn\xa0W\xbdY[\\\x93W7\xe2{'
        b'\xe0\xc3U\xaf:@^\x93\xaf\xc0\x90\x92\x1b\x80\xaf\xf2~\xee\x92\xbc\x9e\\a\xe0\x1e\x00>\\c.I\xc2\x15\xf9\n'
        b'\x0c)\xb9\x01e\x1d\xef\xe0\xfe&\xf3c>\xe6]r\x03\xc8,\xf7\xc1}%\xefl\x8c`\xf4('
        b'\xb9\xd9\x83\xdd\xf6\x86\xf1\x9c&\xef\xbc\xfd\xf59\x03\x9c\x02\x02@\xe4\xb67\xcc\xe0\xae\xc8*\x01\xf8\xbc'
        b'\x15\xa4\xcfJn\x00\xf6\xc6!\xb8\x17R\xc8\xe1\xf4\x9cw\xc9\r\xc0\xde8>\x87\xcd\xca\tq\x01\x06\x04\x00\xa7'
        b'\xef\t,\xe4\x05\xd6\xfa\x84\xfe\x05\xba\x0e\x0f\xdc\xbf\xd6\x07Z\xa0\xcb=\xc0\xf6}\xf8\x01\xd8\x11\xdc\xfdk'
        b'}\xa0\x05\xba>`P\x00\x80\x9c\x16\x00\xc1\x1d\x06\xde\xef\xc3\xf5\xd5\t\x18\xab\x96\x03\xc1\xf4Q\xad\x8f'
        b'\x8a$\xa4\x98\xcba8\xadgc\x871\x957v\xe3XfY\x04\xac\xf4\xa2\xceZ\x9f\xb5\xfa\xa6\xad\xaa}Y\x8b\xabt\x02\x18'
        b'\xdc\xcd\xc4\x9c.\x85=\xbb\x91\xcc\x0eU\x16\x86\x11\xd4Dz\x08\xfejs\xdc\x9a\xffm\xb0Z>}\xaa\xf8=02\xea\xb2v'
        b'\xcb\x97\xfd\xf2\x88\xe3\xad0\xcbbE\xfc\x07o\xef\xcfQ\\2\x8a\xca\x00\x00\x00\x00IEND\xaeB`\x82')
    # The Find Button Image
    open(os.path.join(AssetsFolder, "Find_button_img_small.png"), "wb").write(
        b'\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x002\x00\x00\x002\x08\x06\x00\x00\x00\x1e?\x88\xb1\x00\x00'
        b'\x10JzTXtRaw profile type exif\x00\x00x\xda\xa5\x9air#;\xaeF\xffs\x15\xbd\x04N\xe0\xb0\x1c\x0e`D\xef\xe0'
        b'-\xbf\x0f\x98\xb2oy\xb8\x15\xe5zVY)K\x99L\x12\xc07\x80*\xa7\xff\xf7\xdf\xe3\xfe\xc3O.\xb9\xb9,'
        b'\xb5\x95^\x8a\xe7\'\xf7\xdc\xe3\xe0E\xf3\xcf\xcf\xb8\xcf\xc1\xe7\xfb|\x7fR|}\x16>\xbe\xef\xde?\x88\xbc\x95'
        b'\xec\xcc\xe7\xcfV^\xe7\xbf\xbd\x1f\xde\x07x\x0e\x83W\xf2\xcb@m\xbd>\x98\x1f?\xe8\xf95~\xfb4\xd0\xeb\xc6'
        b'\xc9fd\xaf\xf7k\xa0\xbe\xde\xa7|?\x08\xaf\x01\xc6\xb3,'
        b'_z\xab\xbf.a\xeas|]\xff\x84\x81_gO\xb9}\x9c\xf6\x97\xbf+\xd1\xdb\xc2}R\x8c\x9aB\xf2<\xa7\'('
        b')&\xfb\x8d.\r\xfb\x80go\x9f\xd8[\xef\xef\xe4{'
        b'jx\x02\xf2]\x9c\xde\x7f:3:6\xd5\xfc\xedI\x1f\xb2\xf2\xfe*|\xff\xbe\xfb\x9c\xad\x1c_\xa7\xa4OA.\xef\xc7o'
        b'\xdfwA>}\x90\xde\xef\x13\x7f\xbdsn\xafW\xf1\xe3\xfb{'
        b'</\x9c\xff\x14}\xfb=g\xb7s\xd7\xcc*\x06u\xdbsy-\xeam)\xf7\x15\xe7Mna\xb7n\x8e\xa9\x15_\xf9\x15\x86\xa8\xf7'
        b'\xd1y4\xaazQ\n\xdb/?y\xac\xd0C$\x07\'\xe4\xb0\xc3\x08\'\xe8=\xae\xb0\x98b\x8e\xeab\xe5E\x8c+\xa6\xfbfK5\xf6'
        b'\xb8\xc8Z k<\xc2\x895\xf5\xb4S#\x9f\xeb\xa6\x9dl\xbe\xcf%\xdc\xdbv\xbf\xdc\xbd['
        b'\xe3\xce;pj\x0c\x0c\x16n\x11\xfc\xf0\xe1~z\xc19\x06\x85\x10|{\x8f\x15\xf3\x8a\xd1\x82\xcd4,'
        b's\xf6\xccid$\x9cWP\xe5\x06\xf8\xed\xf1\xf9\xc7\xf2\x9a\xc8\xa0X\x94\r"\x9d\xc0\xceg\x88)\xe1\x1f&H7\xd1\x89'
        b'\x13\x85\xe3\x83\xc1P\xf7k\x00B\xc4\xad\x85\xc9\x84D\x06\xc8ZH\x12J\xf05\xc6\x1a\x02\x81l$\x88\xe2h1\xe58'
        b'\xc9@\x10\x89\x9bI\xc6\x9cR!7-\xda\xad\xb9\xa4\x86{'
        b'j\x94\xc8\xdb\x8e\xf7!32!\xa9\xa4Jnz\x1a$+g\xa1~jn\xd4\xd0\x90$YD\x8aTi\xd2e\x94Tr\x91RJ-F\x8a\xa3\xa6\x9a'
        b']\x95Zj\xad\xad\xf6:Zj\xb9I+\xad\xb6\xd6z\x1b=\xf6\x04iJ/\xbd\xf6\xd6{\x1f\x83{'
        b'\x0eF\x1e\\=8a\x8c\x19g\x9ay\x8a\x9be\xd6\xd9f\x9fcQ>+/Ye\xd5\xd5V_c\xc7\x9d6\xfc\xb1\xcb\xae\xbb\xed\xbe'
        b'\x87\x06\xa5\x944\xabh\xd1\xaaM\xbb\x8eC\xa9\x9d\xe4N>r\xca\xa9\xa7\x9d~\xc6{'
        b'\xd6^i\xfd\xf2\xf8A\xd6\xc2+k\xf1f\xcaN\xac\xefY\xe3\xddZ\xdf\x86\x08F\'b9#a\xd1\xe5@\xc6\xab\xa5\x80\x82'
        b'\x8e\x963\xdfB\xce\xd12g9\xf3=\x82\n\x89LR,'
        b'g;X\xc6\xc8`\xd6\x10\xe5\x84\xb7\xdc\xb9\xf8d\xd42\xf7\xff\xca\x9b\xab\xf9C\xde\xe2\xdff\xceY\xea~\x98\xb9'
        b'\xafy\xfb.k\xdbdh\xdd\x8c=(\xb4\xa0\xfa\x04\xfa\xf8\\\xdb\x88m\x98\xd8}9\xba\x7f\xfb\xe0\xa7\xc7\xbf\x1e'
        b'\xa8k\xa0\xa4\xc7l\x99\x84\xca\xccnGCF\\=\xf4\x12\xfaYq\xce]\x8f_\x8a\x96\xd75KK\xe9\x1c\xd9rX\xdc*\xcd\xa7'
        b'\xa5\xca\xf5\xe7\xd8\x08\xbc\xa7#\x06;\xba\xee\xeb93\x8e\xe7\xd4\x96\xcb\xc9\xcd^u\x82wV\xbb\xaf5\xc9\x98'
        b'\x9d\x99\xa8\xd4\xa3\xc1\xaaw\xb4\xc6K\x88\xf8\xe8\x1a\x9c\x84\xad\xf90\xee\xdb\xb0:F\xfb\xfd\x85\x9f\xafs'
        b'\x9f.T\xf2\xc3\xac*\x17\xa3Xm\x91\xc6tO\xe5\xfa\x19\xaa\xec\x1d\xd3\x99\xa1\x1c8j\xf2i\x9a5S\xe7{'
        b'\xbb\x99\x8a\xa6\x98\xdb*)\xd6\x1d\'* m\xcc\x92\x81\xc7\x18R\xf7\x90M\xa9H\x1ak\x83\xb3\xd3{'
        b'\xe4\xbe\xc4\x0fL-\x14OW\xdd\x0bk\xe2j\x07\xa8\x94['
        b'\x99T\x107\x01Gm\x8f\xba\xfbj\xa5\x98\x8b\x00\x87\xa5rc_\x19\xfd\xd4%%\x84\xed\x8f\xd4P\x18:\xd6<&\xab\x8fn'
        b'`\xfbz\xd5\xa5gf\x1fv\xee\x89\xc9yF#\xc7\x12\xb2\x98_\xfa\x93\xa3\xfb\xed\t2w*kr\x8f\x8a\x10\x8f]\xd7\x02'
        b'\x0e\x8b\xe7\xb5\'\xf8^\xd0\xca\xa8\xca\xe9\xdd\x95>+\xd8S\x0b\xe8\x04iZ\x00o\xdb\xfb\x00\x92\xb6\xb42I\x82'
        b';\xf4\xc0\x1b;\x8d\xad\xdb\xe0\xd7\x08H\x93\xa8\x12\xa3\xf8\x05\xd9\x14\xa7~\xb7\x154WM\xcc\xa1\x8f\xa4\xbd'
        b'\x9f\xddSi\xc7\xd7\xbeA\xa6v\xfc\x9e\xee\t\xb0\x19[\x89_\x1cg3\x0b\xf3\x89\x12\xdaX\xe3\xd6QOV\x81\xfd\xcc['
        b'\xbb\xadP),+\x8c\x99!2Q\xd8\xe4\xe4\xc5\x18\x80\xa1\x15]\xa7\xaf\x12\x8b\xef-\x13\xfeZ('
        b'\xd6\xbejX\xdbU*jC*\xd4\xdb\xb2\xa1\xe4>\xef\xa3\xc5\x8e\xe6\xf9N\x86\x82fK;\xb0\x1cp\xb4e@\x9b0\x05\xc9,'
        b'+\xd5r\xbc\xearDE\xef\x98\x96\xd9*\xf9h\x14\xfc\x84\xa6\xb2\xcd$MC\n\xe5x\'i,'
        b'\xe9g\xd9\xc0H\xe7\x9a\xf0_\xdc\xaa\xa9\xb2\xb6\xee\xf6\x983\xb4R\xf1\xa2\x9b\x15\x88\x9ce\x8b\x87\xff\xf8'
        b'\xe4\xce\xcak>#\xd7\x1e\xdaI6\x97pR\xad\'o\xf5\x87\xbc\xd5\xb2\xce\xa0\x0c\x9d\xe59,'
        b'\x0fG\x8eXOI\xa7\x87\xa3=h\xa5R\xe7<\xcd\n\x9f!j\xd2)=\x89\x0e\x14\x1eN\xddK7U\x81\xfcg\xb2\xa0z\\o\r\xb5 '
        b'\x9eTi\x1a\nm\xd4~\xca6\xde\x85\x81Y\xcbL\xacg\xf9\x91\xe0\x1bc\xa2u`\x9b\x926\x7f%\x88\xf7R\x14\xfe\xde'
        b'\xbd\xbd\xf8\xd3#\xe0\xd2 0\xbc\xce\xda\xc2\xa24\x00\xeah\xd95\x9d\r\x1b\x82u\xb1\xb5\xb5"\xcb\x1f\xbf\xf7'
        b'\x84\xcf\xfbJ7\xd0\xadlJ\x8crL\xb9N\xaa\xa8\xae}bP)\x04+\xcc\xb9p\x91\';B\xe5\x03\xeb\xaf\xfa\xba%\x1cQ'
        b'}\x94\x85\xe0\xd8\r\xe9\x16*w\xdc1\x96*\x0b\xafs\x02\xaaQ\xa3\x91%1\x0c\x19\x11\xa9\x88\xa9\xa3R\xc3&z1gm'
        b'\xdb7\x9ce\xcf\x813\x85n\xa6\xc4\xb4\xad\x84\xbegnnI@c\xe9\x87\x94\xba\xbd3\x05\xb7\x00\x06\x1c\x83\xf6\xde'
        b'\x9b\x92\xcfE\x81\xc6\x12\x9eB\xa5\x14/\x16Un\xfd\xb71L\xd2\xacXE('
        b'\xd6E\xfe\x1c\xa0\x1caG=]\x81\xd6\x15\xe2\xb6\x86\xf9\xf6@\x90\xa8\xe7\x05D\x86jY\xe5\xc4\x04\x11\xa4\xc6'
        b'\x1f\x11+L=5\xbfRWO\xc5lg\xc4\xb3\x04&\xcc\\\x82\x05\x87\xb1\xa82\xdc9\x14\xddb\x19\xeb\x16\x9a\nU\x8d\xb6'
        b'\x83\xec\x04,\xfd\x85\xd1\xa4\xe8w/\x13o\x00C\xfeX\xd2 '
        b'\xe3\x04\xc2l\xa8\x18\x81\xa9\xf9\xe5s\x8e3\xff\x9e0\x18jZ\x01U\xdeX\x14\x93\x84d\xd0\xabc\xdf\xae\x92H\x10'
        b'\x8b\xdc\xcf\xb1\xabQ>T\xfd\x9c\x9cl\xbar\x08\x9d\xc3\xb4n\x05\x02P.\x16\x00\xb0\xd8\x02\x1b\xe9\xcd\x12'
        b'\xb3\xd6\x98\xdfRW\x7f?S\xf7\xeb\x94\xeb"\x04\xc0\xbf\xeb\x04tL\xee)\xc7BZ\x06\xdc\xd8\x99g\x0cu^E#\xfe\xfd'
        b'\x1e\x83\xbfT\xe3\xe0\x9a\x8e\x18\t\x94\x89\xc3\x83Wo\xf5\xca\x84\x1a\xd2&\xc6\xc7\\+\xda\x1d=\xf5h\xc6W'
        b';\xc5/\x8a\xb6#\x7f\xbb" 8\xb7\x92\x1c\x16\x8aDo\x9c\xa12\xa94&\xe8\x95\xfc\xa8\xe7\x14f\x85\x9a1\x13J\x95'
        b'`I\xfeW\x0c\xfe\x0bh\x19\x10\x8fq\xc9w\xe2\x9d\xf6\xbc\xa8\xdb}\xccA1J]\xc1\x96y\xb6\xbd['
        b'.\xa7\xbaS\xca\x15l\xc6X\xe6-Y\x0e\x02\xd0&\xfa\x03\xe0\x16~\xad\x90\xbb\x8e,'
        b'c^\xa2Q \xb24X7\x0e\x858\xe6\xb8\xeb\xadv\x87\x9a\xdf\xa0fZ\x0f2\xf9\xc7\xe5\xd4\xc1\xeb\xc0\',\xdaD,'
        b'\xe9t4\xfcE\xa0L\xf5M\xb3\xa4{\x96\xa2\x84)\r\x13\xa3\x91N\x19g\xca\xdaW\xf0p\n\x07\x00\x95\x04|N\x0e\x16'
        b'\xf2A\x02%-\x17n\x12\xefrm\xb1\xb6f[\xab\xdaZ?\xcd\xffN\xdeR\x1d\xa1\xdc.\xb2('
        b'\x13t\x7fX\xedN\x96\xa6\x03\xea\x9c{\xf7\x8a\x08\t\xd5\xdd\x0e\xa9\x83\xc6\xa0\x87\x93\xaf\xd9\x19?\xf5\x90'
        b'\x90\xd4\xd7|\xbc\xd21\xbb\xdcD\xfe\x93\xc6W\x12\xad\x98[r\xbb\x18\x81\x1eD4r=\x90['
        b'2;\xc5\x854\xf0W\x83\x9di\xac\xbbRd\xd4('
        b'\xee!\xc4\t\xd0$\x99V\x9cmF\xcc\x9b~U\xd7u\xff\xc0\xbc\xe4]\xa6\xc7|\xc1M\x1e\x00`I\xd6\xeeA\x90['
        b'\x97\x92\x19\xfcb\x14<\xf2\xf1\xe0\xfeK\t\xd2\x10Lz\xd1\x8c\n\xc3n\x90\x1b\xf6\x0f?eb\xcd\x05\x1b\xaf\x87Z'
        b'\xbb\xca=\xe4\xd64\'\x05d\xa0\x8e\x92\xb1\x8f\x1b\x07\x98\xad\xa7\xda\x98\xc1\xd1H\xf0,'
        b'\x01\x1f\xe9\xd7\xa3\xaf\xc9\x04O\x0bA\xe2\xd6M\x86\xe3\xeej\x92\n\x1ff\xa6\x15\xc7Ol\x9a\xb1\x11N\xa0\xd1'
        b'\x9f9\xd62k\xd9\x01#\xd1\xdf\xe8,'
        b'\xae!\xe6H\x8d\x9816f\x9a\xd0eh\xfe\xf4M\x0e\x9b\x92\xd94qN\xe6\xc6\xcc*\xd2\xb3\xb9e\xcb\x91=1\x92\xf5D'
        b'\xc4iT\xd8\xb9"\xd0t\x03hY\xbc\x9b\x0b\r\x82\xabg\x18\xd5\xac1\xc2 '
        b'\xccy\xdb\x1d\x16l\xe8c\xc1\x8d\xd0\x1a\xe9F\xf9\x98R\xf2\x89\x92\xec\xa6\x95L\xd8\xba\x05H\t$i\xcd\x07c'
        b'\xc5T\xc3\xe9\x05\xecW\x1ff\x0b\x9a\x06\xe1f\xee\x15\x1c$\xb7J\xb8\xbc\xd7&\xb1j\xb6%\x84\xff\x9bt\\\x7f'
        b'\x00\xdc_Y\xd3}\xa6\xcd\xd1\xcdt#\xae\xe4\x8ay\xd7\x82\x99K\xf8C\xcc^R\xeb\xe6\x1aN\x05Fl\x8a/\xb5X\x0b'
        b'\xfaGC\xf9@\x04\xcb\xae\\\xf1dR\xdf\x13i\x8c\x9d\xcbD\xc6\xb0\xad4\x10\x81J\xdbtP\xb8\xc9np\xdc\xe6 '
        b'|6\x8f\x99_\xc1^\x99\x7f\x90l \xca\xf4Q\xb6\x8f\x19\xd6\xec\x14)]\x82u\x08t\xc9\xf2nd\xbf;\xba/\x1f\xbcVvd'
        b'\xd0N\xd8\xca*v=\x85\x8e#Z{\x99\xc0\xd2+\xb02T\x06"\xd9\t\xd1\x11\r\xdd\xf5('
        b'\xb0Z\xb8\xfbY@\xa5\xda\xbd\xaf; \xff\xd345X\xd4\xf4\x8d\xe0\xf2\xfcDps&tlz7\xf6M\x909\n:\'_t\x9a)\x14\xb3'
        b'\x141\xe0(*v\x02\xc1A+\t\x06\x96\xf56PeL\xb8\xbdc%\xb1,\x11\x96l\xc7\xad\x95\x99m\xf3{\xb1\x80\xd3\xea['
        b'\x01\xb5\x01\x13\xc2@\xfc}\x9a\x96\x9dL\xac\x1fSC(\xb1\x1f\xb6K`\x96\xa7\x99\x80o\xcc\xe8c\x81\x87\xd9C8['
        b'\x81F\xa6\x8e\x13\xb1\x0e3ci\xa1\xb4f\x1e\xa6\x19\xa1?zEW\xca\xbc\xb1\xabpoAO{'
        b'\x11\x1a\xbfS\xf1\xde\xb0r;C\xcd\xe3\x84A\xa1]~4/L\x8f\x08\xb2\xae\xc2U\xb3Y\xc6\xf6\xb4k5\x07\xae\xd7\x05'
        b'\xb6\xb0\xf0X\xc9\xe4l\xf320T\xc4\x00\x82\x8c\x89\x99Rc\x81\xf5\x14\xe56\x0c\xc2\x1c\xb4W\x19,'
        b'\x03\xeel{\x8f\xb67I\x88\xc1\t\x99\xf0F\x8d\xce\x12N\xff\x90hQ\xe9\x1f\xd1\xf9fJ\x9e\xa3fo\x90\xb1\x8d\x1a'
        b'\x11l\xad\x08}7e\x9aq)\x8b\xca\x9a\xb6wJ\x91%\xd0\xcbl\xf1\x90\x1a\th\xdc\x07\xb7\xcb\x1c\xf1\xa24Q\xe4c'
        b'\xd2\xb9y\nR\xc9.C\x0c\\n\'\x1e\xe6\xb0\xb1\xf3\x8ahc\xf4P#<ckR\x93\x83b\xa0\xe2?\xe6\xb1/\xbc\x86~G\xfa'
        b'\x8f\xe3\x08\xb2\x82`\n\xeevy\xf0H"XT\xa6E\xdf\x9c\x08\x997\xb6\xdf\x11\xea\xb0\xeeo\xed\xb6\x8d{'
        b'\xac\x13\xa5\x94\xa9@c\xf5\xee\x8e\x1fF\xdap`\xa5\xfc\x80\xba\xc0\xe6\xe0\xa2I1k\x9f\xca\xb8\xdfC\xe8^\x13C'
        b'\xbe\xbc\x9eK\xaf\xcc\xe6`\xa6pT\x98m\xe8 '
        b'8\x9bV\x01<\xbb\xf9\x8e\xba\xf8A\xdfC\x17\x8bRt\xfbFClgj\xe4ku\xba]\x8a)\x80L\x12\xdd\x07\xbd0\n\xfd4'
        b'\xcbu9L8\x1d0\x95\x86!\x03%\xe6\xb1\x1a\xf6\xf4<\x0cu}\x81\x7f\xf4V0\x02\xfb6eF7\xd1LC~;\xe7}Kc\xd7\x1dP'
        b'\xdcG\xb8\x8e\x11\xd2\xed\xd7\xea\xab_\xebO\xbff\xb5o\x8e\xe62\xd9\x1bY\x82\x1f\xdb\x02r5\xd3\x08\x02\x07'
        b'\xd2\x9b\x95\xb2\x99\xe4\x03\xee"4\xb2s\xa1t\xa1@\xc4\x1c\x8f\xd1\x9bra\x97L9Z/IE\xbf\xa8\x07\x0c\xe0F\x10'
        b'\x19\x0cM}5\x8e\xf9\xd6\x10\x13\xa9\xb4\xbe\xb8f+\xdd\x85Z\xe6@$\xa7\xed\xfd\\^\x1c=tNa\xae+,'
        b'\xdb\x0e\xc9\xceH\x07\x1bEZ\xf2n\xbcX\xa0g\xa0nh\xf6\xfd"`&8\xc4\xf4\xf5\xae\xcf"\x947\xc6\x0e\x13\x80{'
        b'\x9a\xf4\xf0\x1df\xa3\x07s1EH\x91\xb2]4\x1a\x12\xf6\xbf\x93\xe9\xef\x8f\x17k\x1b\x1c\x85\x81\xe6j\xb9{'
        b'E4\xc8\x97yl+CnPOF\x8c\x8f\xb97\xac\x02\xde\xf4\xac\x8e\x01/H\x05\xc9Pd\xa0\xb9p\xbd\xa0u\x90(B\t '
        b'w\xcc\x9acGR\xd7\x0e\x96\xa18\xe0\xca\x9b\x81\x88\x8aX\x08\xac=@wuZw@\x7f\xd3\xee\xfe\x11Rib4\x7f\xbb\x1f'
        b'\xb1\x15\xaeD\xa3 S\xce\x9bF\xcb\xf0\n\x84m\x04\xae\x05\xc08\xa4@\r\xe3\xd3l\x97P('
        b'%Q\xecj\x8d\x0c\x04K\xdb\xd6\xb0\xae\xba\xda\x1c\x08j\t\x19f\x05\x1c\xc8\x06$\x8e\x91('
        b'\xd3\xf4\x84Y\xba\xb7i\xd6_\xa6\xc9,'
        b'\x01cH\xd2PFp\x90\xf7\x1e\x96\x7f\xb1=\x88L\x1c\xa9V\xbc\xe1\xec\xa1i\xb3\xfd\xb4v\xfb\xb5\xefW\x9d\x19'
        b'\x87LW\xaf\x01A\x81\xc1\x84\xbe\x13CW\xe2\xaa\xe1\xde\xae\xd0\xfa\x07\xd8\xecI\x80\xcbH\xfa\x02pe\xa3\xab'
        b'\xe6x\xb8)\x1d\x9a\xf12-r6\x03p\xbd7%\x03\xb5\xcc\xa7\x18/\x8d\xdcbT\xe4\xef"\xda\x19\x91#\xae\xc4\xaf\xa4'
        b'\xc7\xb0\x03\xb9X\xa1g\x98\xbeB\x94X\xfci[?\xd4\x1aHoX('
        b'\x85\x96Y\\0d\x15=&q\x13\x7f\xb4p\xe9\xb2m\xb1\x14\xcd\xe8\x93F\x94\x07Zc\xb3('
        b'\x85\x94\'z\xbf\x98\xbb\xe94\x901\xa9I\xf5m\x1f\x1902\x81tcD\x7f\x8b\xc4\xb3p4\xd9\x8a\xac\x04\xf4\x18U'
        b'\x06Y\x18\xec\x91\x98nc6bf\x80V\xc2\xf6]\xda\x0c9\xd3\xdc\xad\x11\x02\x86\x07\xff7]\x101\xfa\x0b\xcaB\xea'
        b'\xb5\xde\x81\x82\x976M \xcd#\x14\xebz\xb3\x89\x1a\xcaC\xb8\xd5S\x11p\xa0u#\xfaO\x87\xe7\xfe|\x9f\xe6\xf7'
        b'\xc7o\x06\xea\x11\x15\xb0\xcd\xfb\xde0\xa6 '
        b'\x0e\xe1\xa6\xfbN;Eo}\xd7M\x12TC\xde\xaf\xf9\xb2Z\xafJ\xd6:\xc4\x05\ta,'
        b'{\xa1i\x9b4O\xfdn\xdb\xe29\xb0\xb0\xf0\xe4F\xb4mCk\xa3('
        b'\x10>\x9cHd\xda\x8a\xf4/\xe6\xfc\xad\x9f\xdc\xee\xdc\xad\xa9\xfa\xd6H\x81\xd4<\x11v\x18\x81y\x80$\xcd\xd6'
        b'\xe2\xd8\xb7\xc6\xbee\xdb\xe3\xec\x89\x88b\xc3\xb8\xf8\xc9\xc0\xb2\x0cl\xd7!|r\xd0\x18\x1b\x9c\xd1r\x03w'
        b'\xcd-\x98\x03\xd9\xcd\xae\x80D\xb8&Z\xcb+}\xa1T\x9b\xc1\xcb\xb4\xad\t\x9ca\xa2\xcf\xd7\\\xa3\xf3P\xec\xfc'
        b'\x10\xff\xbf;\xba?9\xf1\xb5\xe3$8^\x1a\x00\xc4`\xf4\x9a\xe9\x82Mk5\x9b\xeb*\xc3\xcd+Utx\xc3\xdb\xf6w\xc1*Dd'
        b'\x85\x84\x8c\x19a@\x7f\xbf\x7fZ\x85sl?\x12\x9bC\xeb`n?\x14\xaa\x9f\x95+D\xe8\xb7w\x0c\x88\xd1\xc3\xeaaQ\xed'
        b'\x8b\xaaU\xf03\xcb.1\x8f\xfcj\nq\xaa\x0c\xd1\x8c\xa9|\xa7\x05\xa1\\\xaf\x85\xc7\xe3\x9c\xd2"t+N\xea\xf5\xf0'
        b'\xe6\xb4\xeb\xe0lp\xd9\xac95\xa7\x80\x1f\xc6\xda\xd5\xd6\r\xc3\xd7\x9d\xd3\xdb\x08\xee\x9c\xaaRs\\+\xc2\xae'
        b'\xb6\xb1\x17\xb7+\xc7<:\x81\x0f\xa5Q\x12!\x9aG\x0fKr\xfd\x99\xc7q\x7fc\x8a\xbca\x11\x8b\xf8`\x11\xb37Vw\x0f'
        b'\x18\x91\xebm`\x9c\xb7\xcf\x12}\xf6#\xd0\x17\x82\x8bO\x83\xadw\x8e\xa7<X\xc7s\xee~\xa1n\xbf@\x1d\xb1\x14wSP'
        b'\xeb\xc8\xd5\xbeBAe\xd5\xb6\x85\xe7E\r7;\x16\x19tkyB\x83l\x11\x18\xec\xffK\xf2a\xdb\x8e\xc7\x1d\x01\x12\xa3'
        b'\xb2\x8d\xc6\xe5a1\xdb\xdc\r\x0f\x8b!\x13\xd6<\x9bJ\xd0\xd1\x17cE\xc0x|6V\xe4\xad\x82\xd6\xc1\x89\xd5<4'
        b']\xe5q\rO\xafd\x02\n\x1ffk\xe65@?w\x94.\xff]\xb4s\xb7\xbe\x1d\x17\xd1+~\x1a\x17\xe1P\x0c/\x08\xd4u\x11('
        b'\xf3-t\x96\xf1F\xe1\xe1\xf5\xbd\xe2\xbfS\xf84\xb5\x9f\x8e\xf5Wk\xd27\xe6\xd0\xdc\x80J\xa6\x9f\xb9\xdf\x9e'
        b'\xa8\xe7L\xc1\xd4\xda\xae-FO\xfcy\xbe\xa9\xd8\xf6\x9f&LHE\x08O\xb5\xaf\xaa\xd4}\x08\xcf\xf5 '
        b'4\xc7\xb4;\xf9ni\x9c\xf8\xec\x81\x96$\xddP2\xc5\xf6B\x81\xee\xf5\xd3\x82\x1c\xaa\xf9\xe9\xdd\x97\xe3\xc0'
        b'*\xae\x7f\xfbK\xcf\xfe\x1c\xdd\xdf\x9b\xfe/\x03\xe1\xadh\xe3\xdc\xff\x00&}\x8ban\xc0\xe0\x10\x00\x00\x01'
        b'\x84iCCPICC profile\x00\x00x\x9c}\x91=H\xc3@\x1c\xc5_S\xa5R*\x0ef\x10q\xc8P\xc5\xc1\x82\xa8\x88\xa3V\xa1'
        b'\x08\x15B\xad\xd0\xaa\x83\xc9\xa5_\xd0\xa4!Iqq\x14\\\x0b\x0e~,'
        b'V\x1d\\\x9cuup\x15\x04\xc1\x0f\x10G\'\'E\x17)\xf1\x7fi\xa1E\x8c\x07\xc7\xfdxw\xefq\xf7\x0e\x10\xeae\xa6\xdb'
        b']\xe3\x80n8V*\x11\x972\xd9U)\xf4\x8a0\x82\x10\x11\xc2\xa8\xc2lsN\x96\x93\xf0\x1d_\xf7\x08\xf0\xf5.\xc6\xb3'
        b'\xfc\xcf\xfd9z\xb5\x9c\xcd\x80\x80D<\xcbL\xcb!\xde '
        b'\x9e\xdetL\xce\xfb\xc4"+*\x1a\xf19\xf1\x98E\x17$~\xe4\xba\xda\xe47\xce\x05\x8f\x05\x9e)Z\xe9\xd4<\xb1H,'
        b'\x15:X\xed`V\xb4t\xe2)\xe2\xa8\xa6\x1b\x94/d\x9a\xacq\xde\xe2\xac\x97\xab\xacuO\xfe\xc2H\xceXY\xe6:\xcd!$'
        b'\xb0\x88%\xc8\x90\xa0\xa2\x8a\x12\xcap\x10\xa3\xd5 '
        b'\xc5F\x8a\xf6\xe3>\xfeA\xcf/\x93K%W\t\x8c\x1c\x0b\xa8@\x87\xe2\xf9\xc1\xff\xe0w\xb7v~r\xa2\x99\x14\x89\x03'
        b'\xdd/\xae\xfb1\x0c\x84v\x81F\xcdu\xbf\x8f]\xb7q\x02\x04\x9f\x81+\xa3\xed\xaf\xd4\x81\x99O\xd2km-z\x04\xf4m'
        b'\x03\x17\xd7mM\xdd\x03.w\x80\x81\'S\xb1\x14O\n\xd2\x14\xf2y\xe0\xfd\x8c\xbe)\x0b\xf4\xdf\x02\xe1\xb5fo\xad'
        b'}\x9c>\x00i\xea*y\x03\x1c\x1c\x02#\x05\xca^\xf7ywOgo\xff\x9ei\xf5\xf7\x036\xfdr\x8f\xab\x8fX['
        b'\x00\x00\rziTXtXML:com.adobe.xmp\x00\x00\x00\x00\x00<?xpacket begin="\xef\xbb\xbf" '
        b'id="W5M0MpCehiHzreSzNTczkc9d"?>\n<x:xmpmeta xmlns:x="adobe:ns:meta/" x:xmptk="XMP Core 4.4.0-Exiv2">\n '
        b'<rdf:RDF xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">\n  <rdf:Description rdf:about=""\n    '
        b'xmlns:xmpMM="http://ns.adobe.com/xap/1.0/mm/"\n    '
        b'xmlns:stEvt="http://ns.adobe.com/xap/1.0/sType/ResourceEvent#"\n    '
        b'xmlns:dc="http://purl.org/dc/elements/1.1/"\n    xmlns:GIMP="http://www.gimp.org/xmp/"\n    '
        b'xmlns:tiff="http://ns.adobe.com/tiff/1.0/"\n    xmlns:xmp="http://ns.adobe.com/xap/1.0/"\n   '
        b'xmpMM:DocumentID="gimp:docid:gimp:e69ae92a-3d19-4c60-ae9a-693ba7bfc5f9"\n   '
        b'xmpMM:InstanceID="xmp.iid:e69c906d-c618-4d3d-b8aa-85ec3cdb1c02"\n   '
        b'xmpMM:OriginalDocumentID="xmp.did:f9cd87d8-f01c-4e58-866b-ae1511ffdba4"\n   dc:Format="image/png"\n   '
        b'GIMP:API="2.0"\n   GIMP:Platform="Mac OS"\n   GIMP:TimeStamp="1664827852282793"\n   '
        b'GIMP:Version="2.10.32"\n   tiff:Orientation="1"\n   xmp:CreatorTool="GIMP 2.10"\n   '
        b'xmp:MetadataDate="2022:10:03T22:10:42+02:00"\n   xmp:ModifyDate="2022:10:03T22:10:42+02:00">\n   '
        b'<xmpMM:History>\n    <rdf:Seq>\n     <rdf:li\n      stEvt:action="saved"\n      stEvt:changed="/"\n      '
        b'stEvt:instanceID="xmp.iid:67275bf0-2778-4153-ad81-7fcf70d3fdca"\n      stEvt:softwareAgent="Gimp 2.10 (Mac '
        b'OS)"\n      stEvt:when="2022-10-03T22:10:52+02:00"/>\n    </rdf:Seq>\n   </xmpMM:History>\n  '
        b'</rdf:Description>\n </rdf:RDF>\n</x:xmpmeta>\n                                                             '
        b'                                       \n                                                                   '
        b'                                 \n                                                                         '
        b'                           \n                                                                               '
        b'                     \n                                                                                     '
        b'               \n                                                                                           '
        b'         \n                                                                                                 '
        b'   \n                                                                                                    \n '
        b'                                                                                                   \n       '
        b'                                                                                             \n             '
        b'                                                                                       \n                   '
        b'                                                                                 \n                         '
        b'                                                                           \n                               '
        b'                                                                     \n                                     '
        b'                                                               \n                                           '
        b'                                                         \n                                                 '
        b'                                                   \n                                                       '
        b'                                             \n                                                             '
        b'                                       \n                                                                   '
        b'                                 \n                           \n<?xpacket '
        b'end="w"?>\x9a&\x7fI\x00\x00\x00\x06bKGD\x00\xff\x00\xff\x00\xff\xa0\xbd\xa7\x93\x00\x00\x00\tpHYs\x00\x00'
        b'\x0b\x13\x00\x00\x0b\x13\x01\x00\x9a\x9c\x18\x00\x00\x00\x07tIME\x07\xe6\n\x03\x14\n4\x94\xb8\xf2\xe3\x00'
        b'\x00\x03\xffIDATh\xde\xed\x98Oh\x1cU\x1c\xc7\xbf\xbf7\xa9\x86\xbd\xa4\xf4T\x041\xd0\x93\xe9\xee\xa1"x1\xc7V'
        b'\xb1\xb5\xb6\x87\x9d\x89\x1b\xeb\x92z\xf2O=\x18T\xbcX\x04\x85B\x05=h\x14\x02j\xa4a\xe7\xbd=\x0b\r\xed'
        b'\xc1hED*[u\x82\x89R\x9a\xd2\x1e<\xc4C\n;-\xd9\xcc\xd7\xcb\xb4<\x87M\xdc\xec\xce\xecna\xbf\xa7\x99\xdf\xcc'
        b'\xbc\xdf~\xde\xef\xf7{\xef\xf7\x16\x18h\xa0\x81\xb6\x93\xb4\xfb\xa1\xe7y\xa3$\x0f\x91< '
        b'"\x0f\x01\xd8\x0b\xe0\x16\xc9\xab"\xb2\x02`\xd1\x18\xf3s_\x82\x94\xcbe\t\xc3\xf0\x04\xc9S\x00\x1eo\xe1\x93'
        b'\x1b\x00>\x15\x91\x19c\xccz_\x80\xb8\xae\xfb\x04\xc9/\x00\x8c\xb5\xe1gMD\xa6\x8d1s=\x05q]w\x9a\xe4\xd9m\xde'
        b'\xff\x1b\xc0M\x00#\x00\xf6m\xe9LD+\xa5N\xfa\xbe_\xef:\x88\xe7y3Q\x14\xbd\x9c0G"R%9\xef8\xce\xa2\xef\xfb'
        b'\xebV\xfa\xa90\x0c\xc7\x01\x1c#9\x15\xc3\xd9\xfa^)\xf5\xb4\xd6\xba\xde5\x908\x12\x1f&\xcc\x17\x95R\xafi\xad'
        b'\x97[\x98\x84\xdd$\xdf\'\xf9j\xe2\xd17\xd5j\xf5HW@\xe2\x9a\xf8\xd1~GD\xce\x1ac\xde\xda\xa9\x13\xd7u\x8f\x93'
        b'<\x07 g\x8d\xf5\x8e1\xe6L\xa6 \xe5rY\xea\xf5\xfa\xefva\xb7\x0bqW\xc5b\xf1 '
        b'\x80\x05\xcbg])5\xa6\xb5^M\x03D53\x86ax"\xb1:]\xec\x04\x02\x00\xaa\xd5\xea\x05\x00\xefY\xa6\\\x14E\xa7\xd3'
        b'\x8aHS\x90x\x9f\xb8W\xd8J\xa9Si8\x1b\x1a\x1a:\x03\xe0O\xcb\xf4\xbc\xe7y{'
        b'2\x01\xf1<o4\xb1\xd9U\xb5\xd6\x7f\xa4\xe1\xacR\xa9\xdc\x11\x91\x8f-\xd30\xc9g3\x01!y0\xb1\xf6\xcf\xa7\xb9'
        b'\xba(\xa5\xfc\x84\xbf\xa7\xb2\x02y\xcc\xbew\x1cg1M\x10\xdf\xf7\xff\x01P\xb3L\x8ff\x02\x127\x80\xf7v\xecJ'
        b'\xa5\x92E\x8f\xf4\xab\xe5o\x7fV\xc5\xbe\xd7\xba\xbe\x99Qkt\xdb\xca\x80]Y\x81\xdc\xb2\xaeG\xba\xd0\xe31\xab'
        b'\x1a\xb9j\xdd\xee+\x95JN\x06 y\xebz9\xab\x1a\xf9\xcf\xc0\x8dF\xe3\xc94\tJ\xa5\xd2.\x00\x07,'
        b'\xd3JV\xa9\xf5]\xe2\xfeX\x9a \x8dF\xe30\x80ak\xe2.e\x02\x12\x1fOoX\xa96\xe5y\xde\xee\xb4@H\xbe\x91<\xa3d'
        b'\xd6\xa2\x00\xf8\xc4.x\x92\x1f\xa4\xe1\xccu\xdd"\x80q\x0bbAk}=3\x10\x11\xf9\x0c\xc0\x9a5\x8b\xaf\xb8\xae{'
        b'\xbc\x13G\xc5bq\x94\xe4l\xc2\x9cm\xd3h\x8cY\x17\x91\xe9DJ\x9cs]\xf7P\xbb\x10\x00\xbe\xb5\x97s\x11\x995\xc6'
        b'\xfc\x94)H\x0c3\'"v_\x94#y\xbeX,'
        b'\x9e.\x95J\x0f\xee0\x9dj\x00\x1eI<\xfa\xa5kG\xdd\x89\x89\x89\xdc\xe6\xe6\xe6y;\xafc\xfd\x05\xe0#\xc7q\xb4'
        b'\xef\xfbk\xc9\xef&\'\'\x1f\xd8\xd8\xd8x&.\xec\xf1-\x86\x8f\x94R/i\xad\xbf\xea\xd6\x9f\x0f9\x92\x86\xe4\xe1'
        b'-^\xa9\x01\xf8\r@\x18\x8f\x97\x8f\xf7\x89\xe1\x16\xfcGJ\xa9\x93Z\xeb\xb9\xccA\xac\x14y\x9b\xe4\xbb\xf6\xb9{'
        b'G\x8eDf\x01\\&9\x93H\xe9T`Zn?\x82 \xf8\xa1P(\xcc\x93\x1c\x89['
        b'\xef\xa1\x16\x01\x16D\xe4\x05c\xcc\xe7A\x10\\.\x14\n\xab$\x8fZ\x93($\x8f\x16\n\x85\xd5 '
        b'\x08\xaed\x1e\x91D\xba\xed!y$>\x14\x8d\x89\xc8\xfe\xb8\x8be\xdc;\xad\x88\xc8%\x11\xd1\xcd\xf6\t\xcf\xf3'
        b'^\x8c\xa2\xe8\xcb4##\xe8\x91\xb6\x81ik\x01pz\x05\x12\x04\xc1\x954\xd3\xacg '
        b'\x16\xcc5\x92\xcfu\n\xd3S\x90\xbb0\xf9|~\x15@G\x91\xe99\x88\x05s\r@\xdb\x91\xe9\x0b\x90\x16`\xae\x07AP\xbb'
        b'/@:M\xb3\xbe\x02ia\x01\xd822}\x07\xd2nd\xfa\x12\xe4\xff"\x93\xcf\xe7kA\x10,'
        b'\xb7t\x1e\xe9\x07i\xad\xbf\x16\x91)\x00\x91\xfd\x9bI\xbe\xd9\xf2\xc1\xaa_d\x8ci\x06\xb3|\xdf\xa4V\x93\x9a'
        b'\xa9\x01xXD.\x00x}iii\x03\x03\r4P\xcb\xfa\x17#\x81\x10\xd1\\\x82^;\x00\x00\x00\x00IEND\xaeB`\x82')
    # The Image of the Button, next to the Find Button
    open(os.path.join(AssetsFolder, "More_button_img_small.png"), "wb").write(
        b'\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x00d\x00\x00\x00d\x08\x06\x00\x00\x00p\xe2\x95T\x00\x00\x01'
        b'\x84iCCPICC profile\x00\x00(\x91}\x91=H\xc3@\x1c\xc5_[E)\x15\x073\x888\x04Z\x9d,'
        b'\x88\x8a8j\x15\x8aP!\xd4\n\xad:\x98\\\xfa\x05M\x1a\x92\x14\x17G\xc1\xb5\xe0\xe0\xc7b\xd5\xc1\xc5YW\x07WA'
        b'\x10\xfc\x00qtrRt\x91\x12\xff\x97\x14Z\xc4xp\xdc\x8fw\xf7\x1ew\xef\x80`\xa3\xc24\xabk\x1c\xd0t\xdbL\'\x13b6'
        b'\xb7*\xf6\xbc"\x8c\x10\x04D\x11\x95\x99e\xccIR\n\xbe\xe3\xeb\x1e\x01\xbe\xde\xc5y\x96\xff\xb9?G\x9f\x9a\xb7'
        b'\x18\x10\x10\x89g\x99a\xda\xc4\x1b\xc4\xd3\x9b\xb6\xc1y\x9fX`%Y%>\'\x1e3\xe9\x82\xc4\x8f\\W<~\xe3\\t9\xc83'
        b'\x053\x93\x9e\'\x16\x88\xc5b\x07+\x1d\xccJ\xa6F<E\x1cS5\x9d\xf2\x83Y\x8fU\xce['
        b'\x9c\xb5J\x8d\xb5\xee\xc9_\x18\xc9\xeb+\xcb\\\xa79\x8c$\x16\xb1\x04\t"\x14\xd4PF\x056\xe2\xb4\xea\xa4XH\xd3'
        b'~\xc2\xc7?\xe4\xfa%r)\xe4*\x83\x91c\x01Uh\x90]?\xf8\x1f\xfc\xee\xd6*LNxI\x91\x04\xd0\xfd\xe28\x1f#@\xcf'
        b'.\xd0\xac;\xce\xf7\xb1\xe34O\x80\xd03p\xa5\xb7\xfd\xd5\x060\xf3Iz\xbd\xad\xc5\x8e\x80\xfem\xe0\xe2\xba\xad'
        b'){\xc0\xe5\x0e0\xf8d\xc8\xa6\xecJ!\x9a\xc1B\x01x?\xa3o\xca\x01\x03\xb7@x\xcd\xeb\xad\xb5\x8f\xd3\x07 '
        b'C]\xa5n\x80\x83C`\xb4H\xd9\xeb>\xef\xee\xed\xec\xed\xdf3\xad\xfe~\x00ppr\xa6\x9d\xdf\xe4\xa4\x00\x00\x00'
        b'\x06bKGD\x00\xff\x00\xff\x00\xff\xa0\xbd\xa7\x93\x00\x00\x00\tpHYs\x00\x00.#\x00\x00.#\x01x\xa5?v\x00\x00'
        b'\x00\x07tIME\x07\xe6\n\x03\x14-(Z|\x1c\xc9\x00\x00\x00\x19tEXtComment\x00Created with '
        b'GIMPW\x81\x0e\x17\x00\x00\x01zIDATx\xda\xed\xd7\xbf+Ea\x1c\x80\xf1\xc7\x8f\xa4\x0ct\x8b('
        b'\x83E\xdd\xb2\xc9d\xb2\xdc\x0c&\x7f\x006\x83;\x9a\xe4_p\xb3Y0\x99\x18\x95\x9d,'
        b'\x06\x9bD\x12\x19\x14\x19n\x14ap\x0c\xder\xd39\xe7\xbd&\xea<\x9f\xba\xcb\xe9<\x9dz\xdf\xd3\xf7\xbc\x17$I'
        b'\x92$I\x92$I\x92$I\x92$I\x92$I\x92$I\x92$I\x92$I\x85\xd3\xf2\xc7\xcf\x1f\x04\x96\x812\x90\x00\x07\xc0*\xf0'
        b'\x14\xe9&\x81y\xa0\x04<\x03[\xc0v\xa4\xe9\x00\xaa\xc0\x14\xd0\x06\xdc\x005\xe0\xc4\xd7\xe0\xcb\x18P\x0f\x1b'
        b'\xd1\xf8;\x07\xfar\xba\xa5\x94&\x016s\x9a.\xe0('
        b'\xa5y\x03\xa6\xdd\nh\x07\xae2\x166\x01v3\xba\xf1\x9c&\x01f2\xbaZN\xf3\x18y\x01\na"\xb2\xb0\x1f@oJ\xb7\x11'
        b'\xe9\xf63\xc6r=\xd2U\xff\xcb\xc2\xb4\xfe\xd1s\xcbM|\xdbFR\xae\x0fE\xba\x81\x8coGO\xa4\xeb/\xfa\x86\\6q\xcfE'
        b'\xca\xb5\xdbH\xf3\x90r\xed\x1dx\x89t\xf5\xa2\x8f\xacN\xe0\xee\x97\xa3\x07\xa0\x12\x19=\x0b\x19\xddzN\xf3'
        b'\x1aN{\x85W\t\x8b\xf1s\x81\xee\x81\xe1\x9cn-\xe7 \x90u\x8c/\x01\xa7\x19\xdd\x9c['
        b'\xf1m\x14\xd8\t\xa3\xe6:|\xb4\x9b\x99\xe7\xb3\xc0a\x18E\xc7\xc0b\xf8o\x91\xa7\x1bX\x01\xce\xc2\xc9j/\x1c.$I'
        b'\x92$I\x92$I\x92$I\x92$I\x92$I\x92$I\x92$I\x92$I\x92\x1a|\x025>\x86\xd0\xdb\x17S\x8d\x00\x00\x00\x00IEND'
        b'\xaeB`\x82')
    # The Image for the Help Buttton
    open(os.path.join(AssetsFolder, "Info_button_img_small.png"), "wb").write(
        b'\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x00d\x00\x00\x00d\x08\x06\x00\x00\x00p\xe2\x95T\x00\x00\x02'
        b'\xf4zTXtRaw profile type exif\x00\x00x\xda\xed\x97Q\x92\xe3*\x0cE\xffY\xc5,'
        b'\xc1\x92\x10\x12\xcb\xc1`\xaaf\x07\xb3\xfc\xb9`\xe2\xe9\xa43\x1fy\xefk\xaa\x0c\x15 '
        b'\x02_\xc9:@\xba\xc3\xf1\xebg\x0f?P({\nQ\xcdSNiC\x899f.\x18\xf8v\x962['
        b'\xda\xe2lgIq\xcd\xd1\xb3=\\\x13\x0c\x93\xa0\x97\xf3\xab\xa7\xb5\xfea\xa7K\xe0\xec\nF\xfaE\xc8\xeb\x9a\xd8'
        b'\x9f\'\xf2r\xc0\xfe"\xb4\x1c\xc9\x88\x881hK('
        b'/!\xe1s\x82\x96@)\xebU\xb2\xdb\xd7W\xd8\x8f\xb3_\xcf\x9fi\xc0\'\x8c\xa6W\xce\xc3\xa6\xfb9\xf7\xfa=\x1a\xb2'
        b'\xd7\x14~\x84\xf9\x10\x92\r\xad\x08\x9f\x01\xc8\xf8p\x902&\xd0ncf\x980V\xf1i\xb1\x15\t\x12\xf2.OW\x81\xdb'
        b'\xd0G\xa8\xf1\xed\xa2\'*\xd7\x88\xde\xdb\xc3+\xad\xc8k\x89\xbc$9]\xfd[{ '
        b'}Oe\xa6\xfe\x8b\xe7\xe8k\xc4\xcfv\x93S*l/\xd9\x9f\xc9\xef\xcd\xfb|g\xbcE\x89\t\xa9N\xeb\xa5\x1e\xaf2GX\x07'
        b'\x1cq\xb8\xf6\x00\xbd\xb4\x19>\n\t\x9b5\xa3:vu\xc5Vh['
        b'\xddv\xd4J\x99\x18T:EjT\xa8\xd31\xfbJ\x15!F>\x02\x1b\x06\xcc\x95e\x1a]\x8c3W\x10#\x89\xa3Rg\x93,'
        b'\r\x1cY\xea\xc4\x1e\x85\xafXh\xba\xcd[\r\xd3\x9b\xc3s#,'
        b'e\x82\x18\xcdM\xf0a\r\x9f>\xd0\xfb8\nD\x9b_\xb9B\\\xcc#\xd9\x08c\x90\x1b-\x96\x81\x08\xf5\x95T\x9d\t~\xd4'
        b'\xd72\xb8\n\x08\xea\xc8\xf28"\x19\x89\xddO\x89]\xe9\xcfM \x13\xb4`\xa1\xa2?\xcf Y['
        b'\x02H\x11\\+\x82!\x01\x01P#QJ\xb4\x19\xb3\x11!\x91\x0e@\x05\xa1\xb3D\xdeA\x80T\xb9!H\x8e"\tl\x9c\x87k<b4'
        b'\x97\xb22\xcc\x01v\\f \xa1\x92\xc4\xc0&K\x01\xac\x18\x15\xfb\xc7\xa2c\x0f\x15\x15\x8d\xaa\x9a\xd4\xd45kI'
        b'\x92b\xd2\x94\x92\xa5q)\x16\x13\x8b\xc1\xd4\x92\x99\xb9e+.\x1e]=\xb9\xb9{\xf6\x929\x0b.M\xcd)['
        b'\xf6\x9cs)\xf0Y\xa0\\\xf0t\xc1\x82Rv\xdee\x8f\xbb\x86=\xed\xb6\xfb\x9e\xf7R\xb1}j\xacZS\xb5\xea5\xd7\xd2'
        b'\xb8I\xc3\xfd\xd1R\xb3\xe6-\xb7r\xd0\x81\xadt\xc4C\x8ft\xd8\xe1G>J\xc7V\xeb\x12z\xec\xdaS\xb7\xee=\xf7rQ['
        b'X\xbf\xd5\x0f\xa8\xd1\xa2\xc6\x93\xd4Xh\x175X\xcd\x1e\x124\xae\x13\x1d\xcc\x00\x8cC$\x10\xb7\x81\x00\x1b'
        b'\x9a\x07\xb3\xcd)F\x1e\xe4\x06\xb3-3N\x852\x82\xd4\xc1\xac\xd1 \x06\x82\xf1 '
        b'\xd6N\x0fv\x81O\xa2\x83\xdc\xff\xe2\x16,'
        b'>q\xe3\xffJ.\x0ct\x1f\x92\xfb\xce\xed\x1d\xb56~\x86\xea$v\x9e\xc2\x91\xd4Mp\xfa0\x7fxa/\xe3\xc7\xee['
        b'\x1f\xfe6\xf1i\x7f\x0b\xddB\xb7\xd0-t\x0b\xddB\xb7\xd0?$\xd4\xf1\xc7\xc3\xf8/\xf07\t\xf8\xa8\xd9\xae\x13'
        b'>\x84\x00\x00\x01\x84iCCPICC profile\x00\x00x\x9c}\x91=H\xc3@\x1c\xc5_[E)\x15\x073\x888\x04Z\x9d,'
        b'\x88\x8a8j\x15\x8aP!\xd4\n\xad:\x98\\\xfa\x05M\x1a\x92\x14\x17G\xc1\xb5\xe0\xe0\xc7b\xd5\xc1\xc5YW\x07WA'
        b'\x10\xfc\x00qtrRt\x91\x12\xff\x97\x14Z\xc4xp\xdc\x8fw\xf7\x1ew\xef\x80`\xa3\xc24\xabk\x1c\xd0t\xdbL\'\x13b6'
        b'\xb7*\xf6\xbc"\x8c\x10\x04D\x11\x95\x99e\xccIR\n\xbe\xe3\xeb\x1e\x01\xbe\xde\xc5y\x96\xff\xb9?G\x9f\x9a\xb7'
        b'\x18\x10\x10\x89g\x99a\xda\xc4\x1b\xc4\xd3\x9b\xb6\xc1y\x9fX`%Y%>\'\x1e3\xe9\x82\xc4\x8f\\W<~\xe3\\t9\xc83'
        b'\x053\x93\x9e\'\x16\x88\xc5b\x07+\x1d\xccJ\xa6F<E\x1cS5\x9d\xf2\x83Y\x8fU\xce['
        b'\x9c\xb5J\x8d\xb5\xee\xc9_\x18\xc9\xeb+\xcb\\\xa79\x8c$\x16\xb1\x04\t"\x14\xd4PF\x056\xe2\xb4\xea\xa4XH\xd3'
        b'~\xc2\xc7?\xe4\xfa%r)\xe4*\x83\x91c\x01Uh\x90]?\xf8\x1f\xfc\xee\xd6*LNxI\x91\x04\xd0\xfd\xe28\x1f#@\xcf'
        b'.\xd0\xac;\xce\xf7\xb1\xe34O\x80\xd03p\xa5\xb7\xfd\xd5\x060\xf3Iz\xbd\xad\xc5\x8e\x80\xfem\xe0\xe2\xba\xad'
        b'){\xc0\xe5\x0e0\xf8d\xc8\xa6\xecJ!\x9a\xc1B\x01x?\xa3o\xca\x01\x03\xb7@x\xcd\xeb\xad\xb5\x8f\xd3\x07 '
        b'C]\xa5n\x80\x83C`\xb4H\xd9\xeb>\xef\xee\xed\xec\xed\xdf3\xad\xfe~\x00ppr\xa6#('
        b'\x0e\xe9\x00\x00\rziTXtXML:com.adobe.xmp\x00\x00\x00\x00\x00<?xpacket begin="\xef\xbb\xbf" '
        b'id="W5M0MpCehiHzreSzNTczkc9d"?>\n<x:xmpmeta xmlns:x="adobe:ns:meta/" x:xmptk="XMP Core 4.4.0-Exiv2">\n '
        b'<rdf:RDF xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">\n  <rdf:Description rdf:about=""\n    '
        b'xmlns:xmpMM="http://ns.adobe.com/xap/1.0/mm/"\n    '
        b'xmlns:stEvt="http://ns.adobe.com/xap/1.0/sType/ResourceEvent#"\n    '
        b'xmlns:dc="http://purl.org/dc/elements/1.1/"\n    xmlns:GIMP="http://www.gimp.org/xmp/"\n    '
        b'xmlns:tiff="http://ns.adobe.com/tiff/1.0/"\n    xmlns:xmp="http://ns.adobe.com/xap/1.0/"\n   '
        b'xmpMM:DocumentID="gimp:docid:gimp:6ed11942-c2a0-4ee1-b0d8-1d9a3b9f096f"\n   '
        b'xmpMM:InstanceID="xmp.iid:29e56949-d947-4f09-87d9-2bfcadb63bc2"\n   '
        b'xmpMM:OriginalDocumentID="xmp.did:4ed4bff5-b749-4784-af1a-007d126d1bf1"\n   dc:Format="image/png"\n   '
        b'GIMP:API="2.0"\n   GIMP:Platform="Mac OS"\n   GIMP:TimeStamp="1664830691720569"\n   '
        b'GIMP:Version="2.10.32"\n   tiff:Orientation="1"\n   xmp:CreatorTool="GIMP 2.10"\n   '
        b'xmp:MetadataDate="2022:10:03T22:58:07+02:00"\n   xmp:ModifyDate="2022:10:03T22:58:07+02:00">\n   '
        b'<xmpMM:History>\n    <rdf:Seq>\n     <rdf:li\n      stEvt:action="saved"\n      stEvt:changed="/"\n      '
        b'stEvt:instanceID="xmp.iid:cb33bf7e-d988-4e27-8f69-df2063e2d697"\n      stEvt:softwareAgent="Gimp 2.10 (Mac '
        b'OS)"\n      stEvt:when="2022-10-03T22:58:11+02:00"/>\n    </rdf:Seq>\n   </xmpMM:History>\n  '
        b'</rdf:Description>\n </rdf:RDF>\n</x:xmpmeta>\n                                                             '
        b'                                       \n                                                                   '
        b'                                 \n                                                                         '
        b'                           \n                                                                               '
        b'                     \n                                                                                     '
        b'               \n                                                                                           '
        b'         \n                                                                                                 '
        b'   \n                                                                                                    \n '
        b'                                                                                                   \n       '
        b'                                                                                             \n             '
        b'                                                                                       \n                   '
        b'                                                                                 \n                         '
        b'                                                                           \n                               '
        b'                                                                     \n                                     '
        b'                                                               \n                                           '
        b'                                                         \n                                                 '
        b'                                                   \n                                                       '
        b'                                             \n                                                             '
        b'                                       \n                                                                   '
        b'                                 \n                           \n<?xpacket '
        b'end="w"?>\x9d\x88\xadM\x00\x00\x00\x06bKGD\x00\xff\x00\xff\x00\xff\xa0\xbd\xa7\x93\x00\x00\x00\tpHYs\x00'
        b'\x00.#\x00\x00.#\x01x\xa5?v\x00\x00\x00\x07tIME\x07\xe6\n\x03\x14:\x0b\xfd\x98\xe9-\x00\x00\x06_IDATx\xda'
        b'\xed\x9dklTE\x14\xc7\x7f\xbdH\x80\x80F\x8dm)R4F\x0b6R\x1e\x82\xcf\xf20\x81h\xbf\xa9\x1f\x8c\xf1\x15\xdf\xc6'
        b'\x04c\x8c\x8a\t&\x1aL\xd4\x18\xbf\x80Q\x13\x14\xcb\xc3*>\xe2\x17\xd1\x04\x81\x0fV\xb4U\x13\xb1\xb6\x12'
        b'\xd0JQJi\x91G\xb1`\xda"\xdd\xf5\xc3\xcc&\xcb\xd2m\xf71{'
        b'\xe7\xcc\xdd\xf9\'\x93l\x9a\xdd\xdbs\xee\xff\xce\x993\xe7\xcc=\xa7\x04\xf9('
        b'\x03f\x01\xb3\x81\xc9\xc0L`<P\xa9\xc7\x98\x94\xef\x0f\x01]\xc0_\xc0 '
        b'\xd0\x06\xf4\x00-\xfas\xb7deK\x04\xca4\x1dX\n,\x02n\x00\xa6\x18\xbe\xfeA\xa0\x19h\x04\xb6\x01{'
        b'\xf08\x0bW\x03\xab\x80\xbd@<\xe4\xd1\x01\xac\xd62\x145\xca\x80\xe5@\xbb\x05\x12\xd2\x8dv\xe0Y\xa0\xb4\x98'
        b'\x88\x98\x01\xac\xd3\xf6=.t\x0c\x02\xf5\xda|F\x16W\x02\x9f\x08&!\xdd\xf8('
        b'j\xc4\x94\x01k\x80\x98\x83d$F\x0cx\x1b\xb8\xc8e"J\x80\'\x80^\x87\x89H\x1d\xc7\x80\xc7]$\xa3\n\xf86BD\xa4'
        b'\x8eF\xe02W\xc8x\x088\x11a2\x12\xe3\x1f\xe0^\xc9DL\x02>('
        b'\x02"R\xc7z`\x8242\xa6\x02?\x17!\x19\x89\xb1S\x87uD\x84N\xe6\x00_Y\xd8L\x9d\x06\xb6\x03?\x00\x87\xf5\xdfJ'
        b'\x81kt\xe8\xe5\x9c\x90\xe5\xe9\x06\xea\x80_l\xce\x8c\x1b\xb5-\r\xf3i<\r\xbc\xaa\xdd\xe9t('
        b'\x05^\xd1\xdf\rS\xb6^`\xbe-2\x96\x00\'CV\xb8\'\xcb\x98\xd3\\\xfd\xe4\x86)c\x9f~PCE\xad\x052\x8e\xe6\xb8c'
        b'\xae\xd2\xbf\r\x9b\x94ya\x911\xc7\x82\x99\x8ak\xfb\x9c+\xea,'
        b'\xc8\xdb\x0b\xd4\x14\x9a\x8cJ\xbd\x80\x86\xad\xdc\x16\x03\xb2o\xb1 '
        b'w\x17P^\xc8}F\x8b%\xb7\xf26\x03\xf2\xdfnI\xf6\x9fP\x19N\xe3\xd8dI\xa1!`\xac\x01\xf9\xc7Z\x0cp\xd6\x9b&\xe3Q'
        b'\x8b\x9b\xae\x16\x83z\xb4Y\xd4\xe3\x1e\x93\t\xa5\x93\x16\x15\xf9\xda '
        b'!\x8d\x96c_\x97\x8e&`\x90\xc1N\xbe\x1e\x98hq\xf39\xc1\xf0:h\x0b\xe7\x01\x1b\xf2\xbd\xc8S\x02\xe2D\x03\x86B'
        b'<%\xc0)\x01\xfa<\x96\xab\x02\xe5\xc0q!\xc1\xbbE\x06\x08\xb9I\x88.G\xc91\xf3\xb8VP4\xf5}\x03\x844\x08\xd2'
        b'\xe7\xcdl\x85\xbfJXx;\x96g(b.\xb2r\xfa1\xe0\x8al\x14\xf8L`\xcea7pA\x0ed\x9c\x0f\xec\x12\xa8\xcf\x87\xae\xce'
        b'\x8e\xd4DP6\xf6\xf7B\xbdS\x96\xaaOF\xb3d\xa3\xf0\xec\xdc\xdf\xc0]\x19\xe8q\x87\x85\xd0{'
        b'\xb6c\xedh\x19\xc3\xc9@\xa7\x85l[.\xe8@\x1db\xdb\xa1#\xab\t\xf3T\x0b\xdc\t\\\xee\x80\x0e\x83\xa8\xf4\xf7'
        b'\x91t_X!\xfc\x89\x8a\xe2xf\xa4\x19\xb2\x17\x87\xce\x1bE\x04\xbf\'\'\xde\x92C\'\xd7y2\xac\xa0J\'\xfd '
        b'e\xad\xb8\xdb1EN\x01_\x02\xdf\x03\xad\xda\x1eO\x03\xae\xd7\xf9\x932\x87t\xb9\x0fu\x8c\xea\x0c\xecs\xc4\xe6'
        b'\x0e\x01/k\x976\x1d\xc6\x01\xcfY\x8eRg3\xfeHU\xa0\xda\x11\xc1{'
        b'Q\xaf\xb9e\x8a\x1a\xe0\x80#\xbaU%\xaf!K\x1c\x98\xd6q\xe0V\xa0)\x8b\xdf\xb4\xea\xa0b\xaf\x03\xfa-M&d\xb1\x03'
        b'\x02\xbf\xa1\x13L\xd9\xa2]\xa7\x11\xa4\xe3\x0c\x0ez\x1cX7*\xf2\xcc\x85\xfc)\\\xc7\x03\x89\x19RA\x01\x8f\xaa'
        b'\x18\xc2w\xe4\xf7~y\x1c\xf8\\\xb8\x8e\x17\x03\xe5\x01\xeaE|\xe9h2p\x8d}\x0e\xe8Y\x13\xa0*$HG\xbf\x81kt:\xa0'
        b'\xe7\xec O\xdb\xec\x12\xe2\x0e\xc889@\xe5?\x8a\x01%\x0e\xc883\xd0\xbbZO\x88\x0c\x8c\x0f\x80K\x8a\xe4f\xba'
        b'@He\xa0\xdd\xadb\xb0\xff\xce\x102\x06\x0f)\x18\x13\x14\x91\xb2.\xcc\x10<!\x9e\x10O\xc8h\x84\x0cy\xd3-\x06'
        b'\xa7\x03t\x94\xd1C\x04\xf6\x07\xc0~\x7f\x1f\xc4\xa0+@\x1d\x0e(\x06\xb8\x10\xcb\xea\x0fP\xef\xddy\xc8@['
        b'\x80\xca\x16z\xc8@w\x80\xd9\xb7\\=\xf2CK\x80:\x99\xe1!\x03\xad\t\x93u\xd0\xdf\x0b\xeb\xe8\x04\x0e\'v\xea'
        b'\xcd~\xa7n\x1d\xcd\x89\x9d:\xe4v\xde\xc9\x13b\x16\x8d\xc9\x84l/\x02B\xa4\xc7\xed\xb6&\x0b\xb9\x1bu\x90\xcc'
        b'\x13b\x07\xed\xe8\x03\xd7\xc9Bn\xf6\x84X\xc3\xe6\xe1\x84l\xf0\x84X\xc3\xc6\xe1\x84\xfc\x11\xf5J['
        b'T!5U\xfd\x1bI\xa5eS\x9f\x9a\xf7<!\xa1\xe3\x9d\x91\xa6q=\xf0\x9f7Y\xa1a \xd9\\\r\'\xe4!T)?OH8h '
        b'\xe5\x1d\xf5\xe1\x84|\xddo\x0cC\xc3k\x99<5\xbf\xa2\x8a\xcfx\x14\x16\x9b\x18\xe6e\xcft\xd3\xf8\xc5\x08\xde'
        b'\x80\x98 Y\xe2\xc0\x0b\xd9\xd8\xd5]\x11\xf4\xb8$\x11\xf2\xd6p\xb3c\xb4\x85\xeeyT%\xcd\xa8@\x8a\xf7x\x0cX'
        b'\x99\x8b\xe7qh\xa4\x1fzBr\xc6\nF\xa8\xfe3\x9a+\xb8\x8a\xe8\xe4J\x06\x04\xc8\xf0\r\xaa\x85`\xce\xbey\x1cx'
        b'\x10\xf87\x02.k\xbfe\x1d\xfa\x80\xfbMl\x96\xf6\x00OG`\x86\xd8>\x97\xb5\x8c\x0c\xde\x04\xcet\xf7\xba\x06U'
        b'\xbd\xcd\x16L\xc4\xa1l\xb6O\xdd\x80\x99R\xb7g\xc0f\xbb\x8a/\x0c\xc8o\xab\x96\xe4N\n\xd8Vo\x1av\x1a\xba\x1c'
        b'\'\xbf\x96\x15\xe7b\xa7+P7\x86\xda\xe9\x8d\x04[-\x8f\x1e\xceC\xe6\x95\xd8)%5+,\x9b\xb8@{^a*x\x04U\xc13['
        b'\xd4\x12~\xfb\xbc>\xe0\xda\xb0\x17\xaa\x9b-\x90\xb2+\xcb\xc5\xb9\x8e\xf0\x1b\n\xf4\x01\x0bmy\x0f\x0b,'
        b'\x98\xaf\x13\xc0K\xa3\xd8\xe6J\xed\x19\xda0Sy\xcd\x0cS\xadW\xb7\x12~\xf3\xf7\x18\xea\x1c@\x93&\tTQ\xcf\xc5'
        b'\xa82\x80a\xe7?\x0e\x01\xb7 \xe4\xf0z\xa5E\x97XJMzqE|&a\xaf\x93\x9b\xed\xde&\x13\x11\x8cGp\xa7<k\xbe\x8b'
        b'\xf7\x03\xae\xc4\x8d\xa6\xa3\xca\xf2E\x95\x8c\x1d\xb8Q\xec\xff,'
        b'\x87\xe1I\xe4\xf4\xb12\xe5E-\xc3\x91"\x04\xe9P\x06\xbc\xeb8\x111\xedF\x97\x12!T\x03\x9f:H\xc6\xc7\xa8\xe6'
        b'\x9a\x91E5\xb0\x1e\x19=\x05\xd3\x8dA`]\xd4\x89HE9\xaa`~\xbb "\xda\x81\xe5\xb8\xd5Y\xa1 '
        b'\x98\x0f\xacF\x9d\xbe\x0f\x9b\x84\x0e\xfd\xbf\xe7I\xb8\x11\x12\xbd\x85\x19\xa8\xc2\xf4\x0bu\x08d\x8a\xe1'
        b'\xebw\xebpK#\xb0\r\x95\xa2\x16\xe5\x9a\xba`\xdajP\x05\x9f+P\x95\xb8\xc7\xa1\x92eS9;\xbd;\x84\xaap\xb4_\xaf'
        b'\x05m\x9a\x84\x16\xfdYt\xe5\x8a\xff\x01]\xbaO\x9bZo\xe7\xdb\x00\x00\x00\x00IEND\xaeB`\x82')
    # The Image for the Time
    open(os.path.join(AssetsFolder, "Time_button_img_small.png"), "wb").write(
        b'\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x00d\x00\x00\x00d\x08\x06\x00\x00\x00p\xe2\x95T\x00\x00\x01'
        b'\x84iCCPICC profile\x00\x00(\x91}\x91=H\xc3@\x1c\xc5_[E)\x15\x073\x888\x04Z\x9d,'
        b'\x88\x8a8j\x15\x8aP!\xd4\n\xad:\x98\\\xfa\x05M\x1a\x92\x14\x17G\xc1\xb5\xe0\xe0\xc7b\xd5\xc1\xc5YW\x07WA'
        b'\x10\xfc\x00qtrRt\x91\x12\xff\x97\x14Z\xc4xp\xdc\x8fw\xf7\x1ew\xef\x80`\xa3\xc24\xabk\x1c\xd0t\xdbL\'\x13b6'
        b'\xb7*\xf6\xbc"\x8c\x10\x04D\x11\x95\x99e\xccIR\n\xbe\xe3\xeb\x1e\x01\xbe\xde\xc5y\x96\xff\xb9?G\x9f\x9a\xb7'
        b'\x18\x10\x10\x89g\x99a\xda\xc4\x1b\xc4\xd3\x9b\xb6\xc1y\x9fX`%Y%>\'\x1e3\xe9\x82\xc4\x8f\\W<~\xe3\\t9\xc83'
        b'\x053\x93\x9e\'\x16\x88\xc5b\x07+\x1d\xccJ\xa6F<E\x1cS5\x9d\xf2\x83Y\x8fU\xce['
        b'\x9c\xb5J\x8d\xb5\xee\xc9_\x18\xc9\xeb+\xcb\\\xa79\x8c$\x16\xb1\x04\t"\x14\xd4PF\x056\xe2\xb4\xea\xa4XH\xd3'
        b'~\xc2\xc7?\xe4\xfa%r)\xe4*\x83\x91c\x01Uh\x90]?\xf8\x1f\xfc\xee\xd6*LNxI\x91\x04\xd0\xfd\xe28\x1f#@\xcf'
        b'.\xd0\xac;\xce\xf7\xb1\xe34O\x80\xd03p\xa5\xb7\xfd\xd5\x060\xf3Iz\xbd\xad\xc5\x8e\x80\xfem\xe0\xe2\xba\xad'
        b'){\xc0\xe5\x0e0\xf8d\xc8\xa6\xecJ!\x9a\xc1B\x01x?\xa3o\xca\x01\x03\xb7@x\xcd\xeb\xad\xb5\x8f\xd3\x07 '
        b'C]\xa5n\x80\x83C`\xb4H\xd9\xeb>\xef\xee\xed\xec\xed\xdf3\xad\xfe~\x00ppr\xa6\x9d\xdf\xe4\xa4\x00\x00\x00'
        b'\x06bKGD\x00\xff\x00\xff\x00\xff\xa0\xbd\xa7\x93\x00\x00\x00\tpHYs\x00\x00.#\x00\x00.#\x01x\xa5?v\x00\x00'
        b'\x00\x07tIME\x07\xe6\n\x04\x120!E\x96\x8cz\x00\x00\x0b4IDATx\xda\xed\x9di\x8c\x1c\xc5\x15\x80\xebUwuu\xf51'
        b'=g\x8fgvgvg\xd8\x0b\x8c\x17{}@\x16\x1bac\x91('
        b'&\x96\x16C\xb0\x88\x14CNA\x10!QH\x1c)\x12\x91\x13#E\x1c\x8e\x81@,'
        b'\xe1\xdcJ\x10D$\x10\x85\x04\x0b\x0c\x11\x180$\x868\xc4\x98\x18cl\x13\x1c\xaf\xf7\xb0\xf7\x9c\xbb\xf3##\xdb'
        b'\xd9\xed\x9e\xbdz\xa6gv\xfaI\xfd\xa7\xa4\x99\xf7\xba\xbe\xaaW\xefU\xd7\x81\x90+\xae\xb8b-\\\xad\x19\xdc\xdd'
        b'\xdd\xed\x1d\x1e\x1e\xfeX\xa1PX\x9b\xcf\xe7W\x00\xc0RQ\x14\x13\xf1x<788\xd8\xef"\xad\x80\xe8\xba~\x01!\xe4'
        b'.A\x10\xfe\x86\x102\xac\x1e\x9e\xe7O\x12B~\xc9\x18[\xb7i\xd3&\xec\xd6\\\x19D\x14\xc5G\x11B\x85R ,'
        b'\xe0|\xa8\xebz\xbc\xd6\xde\xb7\xea[Q:\x9d^\x82\x10\x82\x99\xfe.\x97\xcb5\xe4r\xb9\xa0\x0b\xc4\x15\x17\x88'
        b'\x0b\xc4\x15\x17\x88\x0b\xc4\x15\x17\x88+.\x10\x17\x88+.\x90\xf2T\x1c\xc6['
        b'\x04A\xb8/\x16\x8b%\xea\xea\xc5\x01\xa0\xe4\xfcU\xa9\xc7\xef\xf7w\x95\xc9\xac{'
        b'\xce\xd3\x93\'\x84\xfc4\x16\x8b5\xcc[\x08\xb1X,'
        b'\xa2i\xda\r\x8c\xb1\xfb\x01`p\xb6@\x08!\x7f\x90e\xf9\xeb\xc1`p\xc5\xd6\xad['
        b'\xc1&\xf3\xee3\xd3\x05\x00\xc3\x8c\xb1\xaf\xce\x1b\x08\x91H\xe4\x12J\xe9\xf7$I\xfa\xc7l\x01\x94z\x00`\x80'
        b'\x10\xf2\xb8\xaa\xaa\xd7uuuI\xb34s\xdbTz8\x8e{'
        b'R\x96eV\x93\x10\x12\x89\x84&\x08\xc2\xed<\xcf\xef/\x07\x84\x12p\x86('
        b'\xa5\x8f\xfa|\xbee3p\x9d?\x9c\xc1\xff\xefnmm\x15j\x06D8\x1c^ '
        b'\x8a\xe26\x8c\xf1P%A\x98=\x18\xe3\x974M\xfb\xc4\x14\x03\xf8\x03\xb3\xf8\xdfG\xaa\x1e\x84$I\x1a\xc7q\xf7'
        b'"\x84F\x9d\x06\x81&\x7f?yM\x96\xe5\x95&=\xe3\xc1\xd9\xfe\xa7\xcf\xe7[7\xe3 \xa6R0\x08!7e\xb3\xd9{'
        b'\x11B\x81\x99\xfc\x8eR\xda\'\x08\xc2['
        b'\xb9\\\xee\xa0a\x18\xef0\xc6\xfau]?z\xf2\xe4\xc9l*\x95\x02\x9e\xe7\x91,'
        b'\xcb\x06\xcf\xf3\xfa\xe8\xe8h\x14\x00\xe2\x99L\xa6\xd50\x8cK\xc6\xc6\xc6.\x9a\xa9\x9d<\xcf?\x861\xbe#\x93'
        b'\xc9\x9c\x04\x80\x87\x0c\xc3\xf8\xca\x1c"\xc4\x0f\x9a\x9b\x9b/<r\xe4H\xaajz\x85\xa6iq\x8c\xf1s3\xf0\xbfiI'
        b'\x92\x9eV\x14\xe5\xd6H$\xd26\x17\xddmmm\x9a\xa2(\xeb('
        b'\xa5\xdb\x01\xe0\xd8\x0cl\x18\xc4\x18?mG\xcf#\x84\xdcV50DQ\xdc\x80\x10\x9a\xd68!\x08\xc2\xab\x1e\x8f\xe7s'
        b'\x9d\x9d\x9dZ\xb9\xec\t\x85B\x97\x17?\t\x0fW\xd0\x15\x1e\xef\xee\xeevv1\xc9\xea\xd5\xab9A\x10\xee\x9f\xa6'
        b'\xc1Oh\x9a\xb6\xa2\x92\xf6\xb5\xb7\xb7{\t!\x9b\x01\xe0T%\xa00\xc6\xd68\xd9+d\x00xv\x1a '
        b'v\xab\xaa\xba\xc4\xe1hO\x15\x04\xe1.\x84\xd0H\x19C\xec\x1d\x8e\xbd`0\x18\x0c`\x8c\xf7Na\xe0G\x94\xd2\xeb'
        b'\xe7\xaa\xab\xad\xad\x8d\xb5\xb7\xb7/\x0b\x04\x02s^Y\x12\x08\x04b\x84\x90\xa7\xca\x10R\xff\xd81\x18\xba\xae'
        b'\x071\xc6\xfb\xa7\xc8b\x9fH&\x93\xde\xb9\xea\x12\x04a%\xc6\xb8\xf7\xbc\xde\xb6\xdd\xa6\x00\xe43\xd3\x1d\xf3'
        b'\xaa\x1aF2\x99T1\xc6\xa5&\x01S\x82 \xdcb\xe3L\xeb\xe1\x89:DQ\\g\x13\x94$\x00\xfc}\x8e0\x9cK\n\x1b\x1a\x1a'
        b'\x04\x00x\xa1\x84\x8b\xea\xa3\x94\xae\xb4K\x9f\xa2('
        b'\x01\x8b$\xecn\xbbtPJe\x8e\xe3\x9e\x9a%\x8c\x87\x1d\x8d\xa88\x8e\xdbQ\xc2\xc0c\xaa\xaa\xb6\xd8\xa9\xcf\xef'
        b'\xf7\x87,\xc2\xe6\xfb\xec\xd4\xd3\xd3\xd3\x03\x18\xe3\x1d3\x84\xf1\x90\xa30('
        b'\xa5\x9f/a\xe0Q]\xd7\x9b\xec\xd6Y) \xe7e\xdb\x0fO\x13\xc6\x83\x8e\xc2\x90e\xf9"\xab9)\x00\xf8\x0f\xa54Y\x0e'
        b'\xbd\x95\x06R\x9cN\xf9\xc9\x140\x1epz\xda\x9cX\r\xe2\x000&\x8a\xe2e\xe5\xd2\xed\x04\x90\xa6\xa6&\xc2q\xdcn+ '
        b'\xa2(^\xe9(\x10\xc6\xd8f+\xe3dY\xfel9u;\x01\x04!\x84\xe2\xf1\xb8\x1f\x00\x8eX4\xc2\xf7|>\x9f3\x1f\xa54M'
        b'\x8bYe\xb6<\xcf\xef,\xb7~\xa7\x80 \x84\x90$I\xcb\x10B\x19\x0b\xfd['
        b'\x1c\x01B\x08\xf9\x85E+9\x9cH$\xe4\xf9\x0c\xa4\x98\x94~\xc7\xc2;\x8c\x06\x83\xc1\xc6\x8a\xc2\xf0z\xbd\x97X'
        b'\xb9*J\xe9\xdaJ\xd8\xe04\x90\xd6\xd6VB\x081M\x1c\t!\x95\xcd\xce\x19c\x8f['
        b'M\x89T\xca\x06\xa7\x81\x14]\xd7\xe5\x16\r3\x13\n\x85b\x151\xc2\xe7\xf3\xb5 '
        b'\x93\xade\x18\xe3\xb4\xae\xeb\xc9z\x02Rt\xdd\xbf\xb5\x88\xb8\xb6U\xaaUl\xb3\xe8\x1d\x15\x9d\xb7\xa9\x16 '
        b'\x8a\xa2,2k\xa0\x00p\xba\xa3\xa3C)\xab\xf2\xae\xae.\n\x00\xfd&\x15QhllL\xd4#\x90\xe2\x00o:\xdf\xe5\xf5zo'
        b'*\xabbUU{,*\xe1\xc9JWB5\x01\x91e\xf9*\x8b\xc1\xfd\xf9\xd9\xfe\xe7\xb4\x16['
        b'\xe7r\xb9\x8d\x16sY\x8f\xa2:\x96\xd1\xd1\xd1\xe7\t!\x87\'\x96g\xb3\xd9\xd5\xf1x<\\\x16 '
        b'\xeb\xd7\xaf\xe7S\xa9\xd4\xc7\'\xfd\x10\xe3S7\xdex\xe3\x9fP\x9d\x0b\xa5\xf4W&\xc5\xd0\xd7\xd7\xb7\xae'
        b'\\.\xe2\nd\xfe\xe1\xde\x91/b\xd5\xe4\xb2\x8a\xd1\xe7B\x8bh\xeb\x89\xb2\xf4\x90\x91\x91\x91+-r\x92\xba\xef'
        b'\x1d\x08!488\xf8O\x8e\xe3\x8e\x9b\xb8\xad+\xca\x02\x04c|\xa9I\xb1\xa1\xeb\xfa\x0b.\x8e\xb3u4i\x10\xcf\xe7'
        b'\xf3z,\x16K\xda\x0e\xc40\x8c\xa5&~\xf3\xed\x83\x07\x0f\x0e\xb9('
        b'\xfe\'\x9a\xa6\xed1+\x1f\x18\x18Xj+\x90\xce\xceN_:\x9d\x0e\x9b@\xfa\xab\x8b\xe1\xbc\x11\x1c\xe0-\xb3r\x9e'
        b'\xe7/\xb6\x15\xc8\xfb\xef\xbf\x7f\x81Ed\xf1\xb6\x8b\xe1\x9c,'
        b'_\xbe|?\x00\x18\x13\xcbS\xa9T\xb3\xad@$Ij\xb5\xc8P\x8f\xbb\x18\xce\xc93\xcf<\x93\x11\x04\xe1\xc4\xc4rBH\xab'
        b'\xad@\x86\x86\x86L\x17>{\xbd\xde#.\x86IQ\xd5\t\x13\x97%\xdb\n\xc4\xe7\xf3\xf9\xcc\xca\xfb\xfa\xfa\xc6\\\x04'
        b'\x93\x1a\xe9\xc0\xc4\xb2\xd3\xa7O\xc7l\x05r\xe2\xc4\t\xbfY\xf9\xc6\x8d\x1b{'
        b']\x04\x93\x06\xf6\x01\xb3\x1e\x92\xcf\xe7\xc16 '
        b'\x08!\xb3.g\xec\xda\xb5\xcb\xb1\x1dA\x85B\xc1\xb4\\\x14\xc5\x82\x93@\x86\x87\x87GL\xa2Q\x0ec\x8c\xec\x04'
        b'\x925k\x0ck\xd6\xacql\x87\xe9\xda\xb5k\xfb0\xc6}\x13\xcb\xd3\xe9\xf4\x9bN\x02\x91$I4I\x18\r\xc30\xecS\x12'
        b'\x8b\xc5\xbe\x8bL\xe6i\x16/^\xdc\xe2\xe4\xcb\x13B6\x02\xc0\xd9\xd5\x1f\x00\xf0\xdc\x92%Kx\'m\n\x06\x83\x7fD'
        b'\x93?V\x8d\xd8\xaaDU\xd5\xdb\xcc\x80\x04\x02\x81\xa5\xc8aI&\x93\tB\xc8\x17\x82\xc1\xe0\'7l\xd8\x00N\xdb'
        b'\xc3q\xdc\xa4}1~\xbf\xff\xa0\xadJdY\xbe\xd9\x0cH<\x1e_\x87\\\x99\xe8\xb2\x0e\xa1\xc9\xeb\r\xde\xb05\xcaRU'
        b'\xf5_f\xe5\xfd\xfd\xfdq\x17\xc19\xd9\xb2e\x0b\x1e\x1f\x1fO\x9a\xd4\xdf\x11['
        b'\x81\xf8\xfd\xfe\x0f-\x92\xa0\x8b]\x0c\xe7d\xe7\xce\x9d\xed\x86aL\xaa\xcb\\.w\xccV '
        b'\x07\x0e\x1c8\x8a1\x1e5\xf1\x97\x8b]\x0c\xe7ddd\xa4\xd3\xac\xdc0\x8c\x03\xb6\x02)&7\xfb&\x96\xa5R\xa9\xa5'
        b'\xabV\xad".\x8a\xb3@.\xb3\xf00\xfb\xca\x01d\xaf\tyz\xe8\xd0\xa1n\x17\xc5\xd9d\xf5*\x93\x1cd\xfc\xdak\xaf'
        b'\xddo\xbb2\x8f\xc7\xb3\x1e\x99/u\xd9\xea\xa2@(\x16\x8bE\x91\xf9Z\xe7gg\xf3\x7fS\xf6\x90h4\xfa"B('
        b'o\xd2K\xaewq t\xe6\xcc\x99\r\x16\xc9\xeb\xee\xb2)\x95ey\x97Y+\xf0x<K\xeb\x1d\x08\xcf\xf3/\x9b\xd5M8\x1c'
        b'\xee(\'\x90[\xcc\x94J\x92\xf4p=\xc3\x08\x04\x02\x17Y\xb8\xf3\x03eU\xac\xebz\x00\x00\xd2&\xca\x87\xdb\xda'
        b'\xda\xb4z\x05B\x08y\xc4b\xfc\xf8v\xd9\x95\x8b\xa2\xf8k\x8b\xd6\xb0\xb9\x1ea\x84\xc3a\x1d\x00&\xedB\x06\x80'
        b'\\4\x1a\r\x97\xdd\x00\x9f\xcf\xb7\x12\x99o\t\xee\x8fD"u\xd7K(\xa5\xdb,'
        b'\x1a\xe8c\x153\x82\xe3\xb8\xd7\x90\xf9\x1e\x91\x1f\xd4\x13\x8c`0\x98D\x08\x8d[\x04:\xcb+f\x88,'
        b'\xcb\xd7 \xf3\r\x9f)I\x92\xda\xea\x05\x88 \x08\xbfC\xe6\xbb\x90\xff\\qc8\x8e{'
        b'\xc5\xa2\x97\xd4\xc5\xd2RQ\x14\xafC\x16\x1b_UU]Vq\x83dY^\x81\xacO\x89\xfb\xc6|\x86\xd1\xd8\xd8\x18\xb5:\x16'
        b'\x90\xe7\xf9\x9f;f\x18clg\t\xd7u\xe9<\x8d\xaa\xb8\x12\xc7k\x0c\x05\x02\x81\xa8c\xc6\xe9\xba\xee\x03\x80\x93'
        b'\x16P\x8ey<\x9e\xc8|\x03\xc2q\x9c\xe5Q\xe3\x84\x90/;n '
        b'c\xec\x1ad}:\xce\xeb\xaa\xaa\xca\xf3\x05\x06c\xecVd}la\xf5\xec\x93\xc1\x18oG\xd6\'\xc9\xfd\xc5\xef\xf7\xb3Z'
        b'\x87!\x08\xc2&d}\xf5\xeb\t\xc6\xd8\x82\xaa16\x1e\x8f\x0b\x18\xe3\x97K\xf4\x94\x17=\x1eO\xcd\xf6\x14\x00\xb8'
        b'\x19c\x9c\xb7hp\x19UUWU\x9d\xd1\x9a\xa6E0\xc6GK@yMQ\x94\x9a\x1bSDQ\xbc\x13\x95>B\xfc\x8bUk\xbc\xc7\xe3\xe9'
        b'\xc0\x18\xf7\x97x\x81\xa3\xb2,/\xab\x05\x10\xa1P\x88\xf1<\xff3T\xfa\xa4\xea\xefW\xfd\x8b\xa8\xaa\xba\x1c'
        b'\x958\xf3\x16\x00\xc6)\xa5U}%\x10\xa5\xb4\xa3\xb8\x1b\xaa\xd4q~?\xaa\xa5\xd0p\xb9 '
        b'\x08}S\xbc\xd0.BH\xb2\x9a\xec\xbe\xfa\xea\xab9\xc6\xd87\xcdfo\'$\x7f\xdbQ\xad\x89\xd7\xeb\xbd\x10!\xf4\x01'
        b'*}\x8a\xe7(\xc7q[\x02\x81\x80\xe3\x03\xbe$Ik8\x8e\x9b\xf2\xca%Q\x14\xbfU\xb3\xa1\xa2\xa2('
        b'\x11\x8c\xf1+h\xea\xa3U{%I\xba\xbd\xa5\xa5E\xa9\xb4\x8d\x1e\x8f\xe7r\x9e\xe7\xa7s\xaf\xc9('
        b'!\xe4\xd35\x9fL%\x12\tJ\x08\x99\xd6\xddM\x18\xe3\x01A\x10\xeeY\xb0`Ak9mZ\xb4h\x91\xa4('
        b'\xca\xa6\xa9.\x0c8o\xdc{WQ\x94\xf9\xb5JS\x14\xc5O\x01@/\x9a\xfe\x05('
        b'\xaf+\x8a\xb29\x18\x0c\xdaR\x11\x0b\x17.\xf4+\x8ar\xbd('
        b'\x8a\xbf\xc1\x18\x0f\xcf\xc0\x8e\x1d\xa1P\xa8\xe2.\xb5"\xcb\xf8\x9b\x9b\x9b}\xbd\xbd\xbd\xdb\xc6\xc6\xc66'
        b'\xcd\xe4w\x84\x90^A\x10^5\x0c\xe3MB\xc8;\xb2,'
        b'\xbf\x97H$\x8e\xed\xd9\xb3\xa7\xcf\xa4\xe2Y&\x93i\x1a\x18\x18\x88\xe6r\xb9\x0e\xc30\x16\x8f\x8f\x8f_V\\\x87'
        b'<\xed\xf7\x04\x80\xc3\x84\x90/e2\x99\xddh\xbe\x0bc\xac\x1b\x00\xde@\xf6\\\x94R@\x08\xa5\x01 '
        b'\x8f\x10*\x14\xf7\x89\xcf\xe5\x19"\x84l\x8e\xc5b"\xaa7Q\x14e\xfd\x14\xd7['
        b'T\xf2\xba\xbc\xd3\x8c\xb1\xbb\xc3\xe1\xb0\x0f\xd5\xbbx<\x9e+%Iz\x12\x00\xb2\x0e\x80xG\x14\xc5;\xe2\xf1\xb8'
        b'\x07\xb9\xf2\xff\xd2\xd4\xd4\xa43\xc6\xbe\xc6\x18{\tY\xcf\xac\xce\xf9\xe18\xee#I\x92\x1e\x92$i\xa5['
        b'\xeb\xd3\x94\x8e\x8e\x8e\x90\xd7\xeb\xbd\x81\x10\xf2\x08c\xec\xcd\xe2\x181+\x00\x94\xd2\x7fSJ\x7fO\x08\xb93'
        b'\x1a\x8d\xd6\xc4\x9e\x16\xa8v\x03{zz\xb8\xbd{\xf7^\x9c\xc9dZ0\xc6\xe13g\xce4g\xb3Y\xadP('
        b'@\xd1~\x03\x00\x10\xcf\xf3iQ\x14\x8fg\xb3\xd9S\x9a\xa6\xbd\xdb\xd0\xd0ph\xdf\xbe}\xa7\xdc&\xee\x8a+\xae\xb8'
        b'\xe2J\xbd\xc8\x7f\x01TC\xbe}r\xbb|\xfc\x00\x00\x00\x00IEND\xaeB`\x82')


def remove_cache(show_popup: bool = False, parent=None):
    for (main, folder, data) in os.walk(Cached_SearchesFolder):
        for cacheobj in data:
            os.remove(os.path.join(main, cacheobj))
    if show_popup:
        FF_Additional_UI.msg.show_info_messagebox("Cleared Cache", "Cleared Cache successfully!", parent)
