# Any library uses this setup.py file:

# Always prefer setuptools over distutils
from setuptools import setup, find_packages

# To use a consistent encoding
from codecs import open
from os import path

# The directory containing this file
HERE = path.abspath(path.dirname(__file__))

# Get the long description from the README file
with open(path.join(HERE, 'README.md'), encoding='utf-8') as f:
    readme = f.read()

# This call to setup() does all the work
setup(
    name="botiverse",
    version="0.0.10",
    description="botiverse is a chatbot library that offers a high-level API to access a diverse set of chatbot models.",
    long_description=readme,
    long_description_content_type="text/markdown",
    url="https://botiverse.readthedocs.io/",
    author="Essam W., Mohamed Saad, Yousef Atef, Karim Taha",
    author_email="essamwisam@outlook.com",
    license="GPLv3",
    classifiers=[                               # https://pypi.org/classifiers/
        "Intended Audience :: Developers",
        "License :: OSI Approved :: MIT License",
        "Programming Language :: Python",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Operating System :: OS Independent"
    ],
    packages=["botiverse"],
    include_package_data=True,
    install_requires=["numpy", "torch"]            # just as was in requirements.txt
)


# TODO: upload to test PyPI by running: twine upload --repository-url https://test.pypi.org/legacy/ dist/*
# DONE: upload to PyPI by running: twine upload dist/*