from typing import Any


class SingletonMeta(type):
    _instances = {}

    def __call__(cls, *args: Any, **kwargs: Any):
        if cls not in cls._instances:
            cls._instances[cls] = super().__call__(*args, **kwargs)
        return cls._instances[cls]


class Para_SingletonMeta(type):
    _instances = {}

    def __call__(cls, *args: Any, **kwargs: Any):
        key = (cls, args, frozenset(kwargs.items()))
        if key not in cls._instances:
            cls._instances[key] = super().__call__(*args, **kwargs)
        return cls._instances[key]
