#  Drakkar-Software OctoBot
#  Copyright (c) Drakkar-Software, All rights reserved.
#
#  This library is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Lesser General Public
#  License as published by the Free Software Foundation; either
#  version 3.0 of the License, or (at your option) any later version.
#
#  This library is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Lesser General Public License for more details.
#
#  You should have received a copy of the GNU Lesser General Public
#  License along with this library.

from octobot.community import community_fields
from octobot.community.community_fields import (
    CommunityFields,
)

from octobot.community import community_analysis
from octobot.community import community_manager
from octobot.community import authentication
from octobot.community import community_tentacles_package
from octobot.community import community_supports
from octobot.community import community_donation

from octobot.community.community_analysis import (
    get_community_metrics,
    get_current_octobots_stats,
    can_read_metrics,
)
from octobot.community.community_manager import (
    CommunityManager,
)
from octobot.community.authentication import (
    CommunityAuthentication,
)
from octobot.community.community_tentacles_package import (
    CommunityTentaclesPackage
)
from octobot.community.community_supports import (
    CommunitySupports
)
from octobot.community.community_donation import (
    CommunityDonation
)

__all__ = [
    "CommunityFields",
    "get_community_metrics",
    "get_current_octobots_stats",
    "can_read_metrics",
    "CommunityManager",
    "CommunityAuthentication",
    "CommunityTentaclesPackage",
    "CommunitySupports",
    "CommunityDonation",
]
