///////////////////////////////////////////////////////////////////////////////
// BSD 3-Clause License
//
// Copyright (c) 2019, Nefelus Inc
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
// * Redistributions of source code must retain the above copyright notice, this
//   list of conditions and the following disclaimer.
//
// * Redistributions in binary form must reproduce the above copyright notice,
//   this list of conditions and the following disclaimer in the documentation
//   and/or other materials provided with the distribution.
//
// * Neither the name of the copyright holder nor the names of its
//   contributors may be used to endorse or promote products derived from
//   this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
// LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.

#include "odb/defout.h"

#include <stdio.h>

#include "defout_impl.h"
#include "odb/db.h"

namespace odb {

defout::defout(utl::Logger* logger)
{
  _writer = new defout_impl(logger);
  assert(_writer);
}

defout::~defout()
{
  delete _writer;
}

void defout::setUseLayerAlias(bool value)
{
  _writer->setUseLayerAlias(value);
}

void defout::setUseNetInstIds(bool value)
{
  _writer->setUseNetInstIds(value);
}

void defout::setUseMasterIds(bool value)
{
  _writer->setUseMasterIds(value);
}

void defout::selectNet(dbNet* net)
{
  _writer->selectNet(net);
}

void defout::setVersion(Version v)
{
  _writer->setVersion(v);
}

bool defout::writeBlock(dbBlock* block, const char* def_file)
{
  return _writer->writeBlock(block, def_file);
}

}  // namespace odb
