// *****************************************************************************
// *****************************************************************************
// Copyright 2013, Cadence Design Systems
//
// This  file  is  part  of  the  Cadence  LEF/DEF  Open   Source
// Distribution,  Product Version 5.8.
//
// Licensed under the Apache License, Version 2.0 (the "License");
//    you may not use this file except in compliance with the License.
//    You may obtain a copy of the License at
//
//        http://www.apache.org/licenses/LICENSE-2.0
//
//    Unless required by applicable law or agreed to in writing, software
//    distributed under the License is distributed on an "AS IS" BASIS,
//    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
//    implied. See the License for the specific language governing
//    permissions and limitations under the License.
//
// For updates, support, or to become part of the LEF/DEF Community,
// check www.openeda.org for details.
//
//  $Author: dell $
//  $Revision: #1 $
//  $Date: 2017/06/06 $
//  $State:  $
// *****************************************************************************
// *****************************************************************************

#ifndef defiRegion_h
#define defiRegion_h

#include <stdio.h>

#include "defiKRDefs.hpp"

BEGIN_LEFDEF_PARSER_NAMESPACE

class defrData;

// Struct holds the data for one property.
class defiRegion
{
 public:
  defiRegion(defrData* data);
  void Init();

  void Destroy();
  ~defiRegion();

  void clear();
  void setup(const char* name);
  void addRect(int xl, int yl, int xh, int yh);
  void addProperty(const char* name, const char* value, const char type);
  void addNumProperty(const char* name,
                      const double d,
                      const char* value,
                      const char type);
  void setType(const char* type);  // 5.4.1

  const char* name() const;

  int numProps() const;
  const char* propName(int index) const;
  const char* propValue(int index) const;
  double propNumber(int index) const;
  char propType(int index) const;
  int propIsNumber(int index) const;
  int propIsString(int index) const;

  int hasType() const;       // 5.4.1
  const char* type() const;  // 5.4.1

  int numRectangles() const;
  int xl(int index) const;
  int yl(int index) const;
  int xh(int index) const;
  int yh(int index) const;

  void print(FILE* f) const;

 protected:
  char* name_;
  int nameLength_;

  int numRectangles_;
  int rectanglesAllocated_;
  int* xl_;
  int* yl_;
  int* xh_;
  int* yh_;

  int numProps_;
  int propsAllocated_;
  char** propNames_;
  char** propValues_;
  double* propDValues_;
  char* propTypes_;

  char* type_;

  defrData* defData;
};

END_LEFDEF_PARSER_NAMESPACE

USE_LEFDEF_PARSER_NAMESPACE

#endif
