[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)
![PyPI](https://img.shields.io/pypi/v/zeversolarlocal)
[![codecov](https://codecov.io/gh/sander76/zeversolarlocal/branch/master/graph/badge.svg?token=FED6T168H0)](https://codecov.io/gh/sander76/zeversolarlocal)

# zeversolarlocal

Access solar energy data from your local Zeversolar inverter.

## Principle

This library accesses the `home.cgi` endpoint which returns a bytes object, which is parsed returning current power generation and the daily generated energy.
The inverter is powered by the solar energy generated by the connected solar panels.
This means that some generated errors can mean different things depending on circumstances.

If the inverter cannot be reached a `ZeverTimeout` is raised. Which could mean:

1. The ip-address of the inverter is wrong.
2. The inverter is switched off (no solar power). But can be considered expected behavior.

If returning data cannot be parsed properly a `ZeverError` is raised. Which could mean:

1. The returned data is wrong and is indeed an error.
1. Sometimes some other data is returned (which meaning is currently unknown), which cannot be parsed, but everything else is fine.

## installation

`pip install zeversolarlocal`

## usage

```python
import asyncio
import zeversolarlocal

loop = asyncio.get_event_loop()

def get():

    address = "192.168.1.12"  # ip address of your zeversolar inverter.
    url = zeversolarlocal.default_url(address)
    
    solar_data = loop.run_until_complete(zeversolarlocal.solardata(url))

    print(solar_data)

```

## CLI

from the commandline use:

`python -m zeversolarlocal 192.168.1.12`

# Changelog

## 1.0.0

- First release
