"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RosCondition = void 0;
const ros_element_1 = require("./ros-element");
/**
 * Represents a RosTemplate condition, for resources which must be conditionally created and
 * the determination must be made at deploy time.
 */
class RosCondition extends ros_element_1.RosElement {
    /**
     * Build a new condition. The condition must be constructed with a condition token,
     * that the condition is based on.
     */
    constructor(scope, id, props) {
        super(scope, id);
        this.expression = props && props.expression;
    }
    /**
     * @internal
     */
    _toRosTemplate() {
        if (!this.expression) {
            return {};
        }
        return {
            Conditions: {
                [this.logicalId]: this.expression,
            },
        };
    }
    /**
     * Synthesizes the condition.
     */
    resolve(_context) {
        return { Condition: this.logicalId };
    }
}
exports.RosCondition = RosCondition;
//# sourceMappingURL=data:application/json;base64,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