# A simple draw GUI for Python3.

[](---------------------------------------------------------------------------)
## CONTENT

This python3 package contains two modules that were developed as easy to use
graphical libraries for programming beginners or for people who just wish to
easily draw simple graphical objects in a window. They are based on the tkinter
canvas object, but unlike tkinter they are synchronous.

The main module is `tkdraw.screen`. It is synchronous, which means that you
don't have to handle asynchronous calls to predefined functions to react to the
interface events. It provides the class `tkdraw.screen.Screen` that opens a
tkinter window containing a canvas where you can draw a rectangular board
containing pieces, or just draw pixels. There is a single function waiting for
an event to occur and there are various drawing functions.
Check the demo:
`python3 -m tkdraw.screen`.

The `tkdraw.basic` module provides four elementary functions: to open a window,
plot a pixel, refresh the window, and wait for the user to close it. It can be
used by complete python beginners to learn how to write loops, and get a visual
immediate result.
Check the demo:
`python3 -m tkdraw.basic`

Some examples are available
[here](https://github.com/vincentloechner/pytkdraw/tree/master/examples).

[](---------------------------------------------------------------------------)
## DOCUMENTATION

The complete documentation is available on the web
[here](https://vincentloechner.github.io/pytkdraw/)
(it was auto-generated by [pdoc3](https://pdoc3.github.io/pdoc/)).

It is also available directly in the python3 interpreter:
```sh
$ python3
>>> import tkdraw.basic
>>> help(tkdraw.basic)
```
```sh
$ python3
>>> import tkdraw.screen
>>> help(tkdraw.screen)
```


[](---------------------------------------------------------------------------)
## INSTALLATION

- If you don't have it yet, install tkinter for python3
  (on most **Linux** distributions `sudo apt install python3-tk`,
    on **MacOS** it should be installed by default, on **Windows** you have to
    select the option at install time, or reinstall python3 if you didn't).

- Install tkdraw using pip:
```
python3 -m pip install tkdraw
```

- Try the following code:
```py
"""Example usage of the tkdraw screen module."""
import tkdraw.screen

# open a window containing a 8x8 board, each tile is 100 pixels wide
g = tkdraw.screen.Screen((8, 8), 100)

# draw checkered tiles
for i in range(8):
    for j in range(8):
        if (i+j) % 2 == 0:
            g.draw_tile((i, j), "grey")

# draw a black piece in tile (1, 5)
g.draw_piece((1, 5))
# draw a green piece below
g.draw_piece((2, 5), color="green")

# wait for the user to close the window
while g.wait_event()[0] != "END":
    pass

# cleanup
g.close()
```
Run with python3.

[](---------------------------------------------------------------------------)
## HISTORY

The `screen` module was first written in 2018, when Vincent was in charge of
the *Algorithms & Programming* course based on python3, in the first year of
Strasbourg University Bachelor degree in Mathematics and Computer Science.
Its original name was `graph.py`. The simplified `basic` module was written
in 2019, for complete python3 beginners to feel more comfortable with very
basic function calls (no classes or methods calls).

Since then it is used by some 400 students applying to this diploma and
learning to program in python3 each year.

In 2021 it was translated to English, fully documented, updated to fit the
PEP and coding style standards,
and finally made freely available under the MIT license on
[github](https://github.com/vincentloechner/pytkdraw).
The python easy to install package was published on
[PyPI](https://pypi.org/project/tkdraw/).

[](---------------------------------------------------------------------------)
## COPYRIGHT

Copyright © 2018-2021, Vincent Loechner.

Distributed under the MIT license.
