window.pdocSearch = (function(){
/** elasticlunr - http://weixsong.github.io * Copyright (C) 2017 Oliver Nightingale * Copyright (C) 2017 Wei Song * MIT Licensed */!function(){function e(e){if(null===e||"object"!=typeof e)return e;var t=e.constructor();for(var n in e)e.hasOwnProperty(n)&&(t[n]=e[n]);return t}var t=function(e){var n=new t.Index;return n.pipeline.add(t.trimmer,t.stopWordFilter,t.stemmer),e&&e.call(n,n),n};t.version="0.9.5",lunr=t,t.utils={},t.utils.warn=function(e){return function(t){e.console&&console.warn&&console.warn(t)}}(this),t.utils.toString=function(e){return void 0===e||null===e?"":e.toString()},t.EventEmitter=function(){this.events={}},t.EventEmitter.prototype.addListener=function(){var e=Array.prototype.slice.call(arguments),t=e.pop(),n=e;if("function"!=typeof t)throw new TypeError("last argument must be a function");n.forEach(function(e){this.hasHandler(e)||(this.events[e]=[]),this.events[e].push(t)},this)},t.EventEmitter.prototype.removeListener=function(e,t){if(this.hasHandler(e)){var n=this.events[e].indexOf(t);-1!==n&&(this.events[e].splice(n,1),0==this.events[e].length&&delete this.events[e])}},t.EventEmitter.prototype.emit=function(e){if(this.hasHandler(e)){var t=Array.prototype.slice.call(arguments,1);this.events[e].forEach(function(e){e.apply(void 0,t)},this)}},t.EventEmitter.prototype.hasHandler=function(e){return e in this.events},t.tokenizer=function(e){if(!arguments.length||null===e||void 0===e)return[];if(Array.isArray(e)){var n=e.filter(function(e){return null===e||void 0===e?!1:!0});n=n.map(function(e){return t.utils.toString(e).toLowerCase()});var i=[];return n.forEach(function(e){var n=e.split(t.tokenizer.seperator);i=i.concat(n)},this),i}return e.toString().trim().toLowerCase().split(t.tokenizer.seperator)},t.tokenizer.defaultSeperator=/[\s\-]+/,t.tokenizer.seperator=t.tokenizer.defaultSeperator,t.tokenizer.setSeperator=function(e){null!==e&&void 0!==e&&"object"==typeof e&&(t.tokenizer.seperator=e)},t.tokenizer.resetSeperator=function(){t.tokenizer.seperator=t.tokenizer.defaultSeperator},t.tokenizer.getSeperator=function(){return t.tokenizer.seperator},t.Pipeline=function(){this._queue=[]},t.Pipeline.registeredFunctions={},t.Pipeline.registerFunction=function(e,n){n in t.Pipeline.registeredFunctions&&t.utils.warn("Overwriting existing registered function: "+n),e.label=n,t.Pipeline.registeredFunctions[n]=e},t.Pipeline.getRegisteredFunction=function(e){return e in t.Pipeline.registeredFunctions!=!0?null:t.Pipeline.registeredFunctions[e]},t.Pipeline.warnIfFunctionNotRegistered=function(e){var n=e.label&&e.label in this.registeredFunctions;n||t.utils.warn("Function is not registered with pipeline. This may cause problems when serialising the index.\n",e)},t.Pipeline.load=function(e){var n=new t.Pipeline;return e.forEach(function(e){var i=t.Pipeline.getRegisteredFunction(e);if(!i)throw new Error("Cannot load un-registered function: "+e);n.add(i)}),n},t.Pipeline.prototype.add=function(){var e=Array.prototype.slice.call(arguments);e.forEach(function(e){t.Pipeline.warnIfFunctionNotRegistered(e),this._queue.push(e)},this)},t.Pipeline.prototype.after=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i+1,0,n)},t.Pipeline.prototype.before=function(e,n){t.Pipeline.warnIfFunctionNotRegistered(n);var i=this._queue.indexOf(e);if(-1===i)throw new Error("Cannot find existingFn");this._queue.splice(i,0,n)},t.Pipeline.prototype.remove=function(e){var t=this._queue.indexOf(e);-1!==t&&this._queue.splice(t,1)},t.Pipeline.prototype.run=function(e){for(var t=[],n=e.length,i=this._queue.length,o=0;n>o;o++){for(var r=e[o],s=0;i>s&&(r=this._queue[s](r,o,e),void 0!==r&&null!==r);s++);void 0!==r&&null!==r&&t.push(r)}return t},t.Pipeline.prototype.reset=function(){this._queue=[]},t.Pipeline.prototype.get=function(){return this._queue},t.Pipeline.prototype.toJSON=function(){return this._queue.map(function(e){return t.Pipeline.warnIfFunctionNotRegistered(e),e.label})},t.Index=function(){this._fields=[],this._ref="id",this.pipeline=new t.Pipeline,this.documentStore=new t.DocumentStore,this.index={},this.eventEmitter=new t.EventEmitter,this._idfCache={},this.on("add","remove","update",function(){this._idfCache={}}.bind(this))},t.Index.prototype.on=function(){var e=Array.prototype.slice.call(arguments);return this.eventEmitter.addListener.apply(this.eventEmitter,e)},t.Index.prototype.off=function(e,t){return this.eventEmitter.removeListener(e,t)},t.Index.load=function(e){e.version!==t.version&&t.utils.warn("version mismatch: current "+t.version+" importing "+e.version);var n=new this;n._fields=e.fields,n._ref=e.ref,n.documentStore=t.DocumentStore.load(e.documentStore),n.pipeline=t.Pipeline.load(e.pipeline),n.index={};for(var i in e.index)n.index[i]=t.InvertedIndex.load(e.index[i]);return n},t.Index.prototype.addField=function(e){return this._fields.push(e),this.index[e]=new t.InvertedIndex,this},t.Index.prototype.setRef=function(e){return this._ref=e,this},t.Index.prototype.saveDocument=function(e){return this.documentStore=new t.DocumentStore(e),this},t.Index.prototype.addDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.addDoc(i,e),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));this.documentStore.addFieldLength(i,n,o.length);var r={};o.forEach(function(e){e in r?r[e]+=1:r[e]=1},this);for(var s in r){var u=r[s];u=Math.sqrt(u),this.index[n].addToken(s,{ref:i,tf:u})}},this),n&&this.eventEmitter.emit("add",e,this)}},t.Index.prototype.removeDocByRef=function(e){if(e&&this.documentStore.isDocStored()!==!1&&this.documentStore.hasDoc(e)){var t=this.documentStore.getDoc(e);this.removeDoc(t,!1)}},t.Index.prototype.removeDoc=function(e,n){if(e){var n=void 0===n?!0:n,i=e[this._ref];this.documentStore.hasDoc(i)&&(this.documentStore.removeDoc(i),this._fields.forEach(function(n){var o=this.pipeline.run(t.tokenizer(e[n]));o.forEach(function(e){this.index[n].removeToken(e,i)},this)},this),n&&this.eventEmitter.emit("remove",e,this))}},t.Index.prototype.updateDoc=function(e,t){var t=void 0===t?!0:t;this.removeDocByRef(e[this._ref],!1),this.addDoc(e,!1),t&&this.eventEmitter.emit("update",e,this)},t.Index.prototype.idf=function(e,t){var n="@"+t+"/"+e;if(Object.prototype.hasOwnProperty.call(this._idfCache,n))return this._idfCache[n];var i=this.index[t].getDocFreq(e),o=1+Math.log(this.documentStore.length/(i+1));return this._idfCache[n]=o,o},t.Index.prototype.getFields=function(){return this._fields.slice()},t.Index.prototype.search=function(e,n){if(!e)return[];e="string"==typeof e?{any:e}:JSON.parse(JSON.stringify(e));var i=null;null!=n&&(i=JSON.stringify(n));for(var o=new t.Configuration(i,this.getFields()).get(),r={},s=Object.keys(e),u=0;u<s.length;u++){var a=s[u];r[a]=this.pipeline.run(t.tokenizer(e[a]))}var l={};for(var c in o){var d=r[c]||r.any;if(d){var f=this.fieldSearch(d,c,o),h=o[c].boost;for(var p in f)f[p]=f[p]*h;for(var p in f)p in l?l[p]+=f[p]:l[p]=f[p]}}var v,g=[];for(var p in l)v={ref:p,score:l[p]},this.documentStore.hasDoc(p)&&(v.doc=this.documentStore.getDoc(p)),g.push(v);return g.sort(function(e,t){return t.score-e.score}),g},t.Index.prototype.fieldSearch=function(e,t,n){var i=n[t].bool,o=n[t].expand,r=n[t].boost,s=null,u={};return 0!==r?(e.forEach(function(e){var n=[e];1==o&&(n=this.index[t].expandToken(e));var r={};n.forEach(function(n){var o=this.index[t].getDocs(n),a=this.idf(n,t);if(s&&"AND"==i){var l={};for(var c in s)c in o&&(l[c]=o[c]);o=l}n==e&&this.fieldSearchStats(u,n,o);for(var c in o){var d=this.index[t].getTermFrequency(n,c),f=this.documentStore.getFieldLength(c,t),h=1;0!=f&&(h=1/Math.sqrt(f));var p=1;n!=e&&(p=.15*(1-(n.length-e.length)/n.length));var v=d*a*h*p;c in r?r[c]+=v:r[c]=v}},this),s=this.mergeScores(s,r,i)},this),s=this.coordNorm(s,u,e.length)):void 0},t.Index.prototype.mergeScores=function(e,t,n){if(!e)return t;if("AND"==n){var i={};for(var o in t)o in e&&(i[o]=e[o]+t[o]);return i}for(var o in t)o in e?e[o]+=t[o]:e[o]=t[o];return e},t.Index.prototype.fieldSearchStats=function(e,t,n){for(var i in n)i in e?e[i].push(t):e[i]=[t]},t.Index.prototype.coordNorm=function(e,t,n){for(var i in e)if(i in t){var o=t[i].length;e[i]=e[i]*o/n}return e},t.Index.prototype.toJSON=function(){var e={};return this._fields.forEach(function(t){e[t]=this.index[t].toJSON()},this),{version:t.version,fields:this._fields,ref:this._ref,documentStore:this.documentStore.toJSON(),index:e,pipeline:this.pipeline.toJSON()}},t.Index.prototype.use=function(e){var t=Array.prototype.slice.call(arguments,1);t.unshift(this),e.apply(this,t)},t.DocumentStore=function(e){this._save=null===e||void 0===e?!0:e,this.docs={},this.docInfo={},this.length=0},t.DocumentStore.load=function(e){var t=new this;return t.length=e.length,t.docs=e.docs,t.docInfo=e.docInfo,t._save=e.save,t},t.DocumentStore.prototype.isDocStored=function(){return this._save},t.DocumentStore.prototype.addDoc=function(t,n){this.hasDoc(t)||this.length++,this.docs[t]=this._save===!0?e(n):null},t.DocumentStore.prototype.getDoc=function(e){return this.hasDoc(e)===!1?null:this.docs[e]},t.DocumentStore.prototype.hasDoc=function(e){return e in this.docs},t.DocumentStore.prototype.removeDoc=function(e){this.hasDoc(e)&&(delete this.docs[e],delete this.docInfo[e],this.length--)},t.DocumentStore.prototype.addFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&(this.docInfo[e]||(this.docInfo[e]={}),this.docInfo[e][t]=n)},t.DocumentStore.prototype.updateFieldLength=function(e,t,n){null!==e&&void 0!==e&&0!=this.hasDoc(e)&&this.addFieldLength(e,t,n)},t.DocumentStore.prototype.getFieldLength=function(e,t){return null===e||void 0===e?0:e in this.docs&&t in this.docInfo[e]?this.docInfo[e][t]:0},t.DocumentStore.prototype.toJSON=function(){return{docs:this.docs,docInfo:this.docInfo,length:this.length,save:this._save}},t.stemmer=function(){var e={ational:"ate",tional:"tion",enci:"ence",anci:"ance",izer:"ize",bli:"ble",alli:"al",entli:"ent",eli:"e",ousli:"ous",ization:"ize",ation:"ate",ator:"ate",alism:"al",iveness:"ive",fulness:"ful",ousness:"ous",aliti:"al",iviti:"ive",biliti:"ble",logi:"log"},t={icate:"ic",ative:"",alize:"al",iciti:"ic",ical:"ic",ful:"",ness:""},n="[^aeiou]",i="[aeiouy]",o=n+"[^aeiouy]*",r=i+"[aeiou]*",s="^("+o+")?"+r+o,u="^("+o+")?"+r+o+"("+r+")?$",a="^("+o+")?"+r+o+r+o,l="^("+o+")?"+i,c=new RegExp(s),d=new RegExp(a),f=new RegExp(u),h=new RegExp(l),p=/^(.+?)(ss|i)es$/,v=/^(.+?)([^s])s$/,g=/^(.+?)eed$/,m=/^(.+?)(ed|ing)$/,y=/.$/,S=/(at|bl|iz)$/,x=new RegExp("([^aeiouylsz])\\1$"),w=new RegExp("^"+o+i+"[^aeiouwxy]$"),I=/^(.+?[^aeiou])y$/,b=/^(.+?)(ational|tional|enci|anci|izer|bli|alli|entli|eli|ousli|ization|ation|ator|alism|iveness|fulness|ousness|aliti|iviti|biliti|logi)$/,E=/^(.+?)(icate|ative|alize|iciti|ical|ful|ness)$/,D=/^(.+?)(al|ance|ence|er|ic|able|ible|ant|ement|ment|ent|ou|ism|ate|iti|ous|ive|ize)$/,F=/^(.+?)(s|t)(ion)$/,_=/^(.+?)e$/,P=/ll$/,k=new RegExp("^"+o+i+"[^aeiouwxy]$"),z=function(n){var i,o,r,s,u,a,l;if(n.length<3)return n;if(r=n.substr(0,1),"y"==r&&(n=r.toUpperCase()+n.substr(1)),s=p,u=v,s.test(n)?n=n.replace(s,"$1$2"):u.test(n)&&(n=n.replace(u,"$1$2")),s=g,u=m,s.test(n)){var z=s.exec(n);s=c,s.test(z[1])&&(s=y,n=n.replace(s,""))}else if(u.test(n)){var z=u.exec(n);i=z[1],u=h,u.test(i)&&(n=i,u=S,a=x,l=w,u.test(n)?n+="e":a.test(n)?(s=y,n=n.replace(s,"")):l.test(n)&&(n+="e"))}if(s=I,s.test(n)){var z=s.exec(n);i=z[1],n=i+"i"}if(s=b,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+e[o])}if(s=E,s.test(n)){var z=s.exec(n);i=z[1],o=z[2],s=c,s.test(i)&&(n=i+t[o])}if(s=D,u=F,s.test(n)){var z=s.exec(n);i=z[1],s=d,s.test(i)&&(n=i)}else if(u.test(n)){var z=u.exec(n);i=z[1]+z[2],u=d,u.test(i)&&(n=i)}if(s=_,s.test(n)){var z=s.exec(n);i=z[1],s=d,u=f,a=k,(s.test(i)||u.test(i)&&!a.test(i))&&(n=i)}return s=P,u=d,s.test(n)&&u.test(n)&&(s=y,n=n.replace(s,"")),"y"==r&&(n=r.toLowerCase()+n.substr(1)),n};return z}(),t.Pipeline.registerFunction(t.stemmer,"stemmer"),t.stopWordFilter=function(e){return e&&t.stopWordFilter.stopWords[e]!==!0?e:void 0},t.clearStopWords=function(){t.stopWordFilter.stopWords={}},t.addStopWords=function(e){null!=e&&Array.isArray(e)!==!1&&e.forEach(function(e){t.stopWordFilter.stopWords[e]=!0},this)},t.resetStopWords=function(){t.stopWordFilter.stopWords=t.defaultStopWords},t.defaultStopWords={"":!0,a:!0,able:!0,about:!0,across:!0,after:!0,all:!0,almost:!0,also:!0,am:!0,among:!0,an:!0,and:!0,any:!0,are:!0,as:!0,at:!0,be:!0,because:!0,been:!0,but:!0,by:!0,can:!0,cannot:!0,could:!0,dear:!0,did:!0,"do":!0,does:!0,either:!0,"else":!0,ever:!0,every:!0,"for":!0,from:!0,get:!0,got:!0,had:!0,has:!0,have:!0,he:!0,her:!0,hers:!0,him:!0,his:!0,how:!0,however:!0,i:!0,"if":!0,"in":!0,into:!0,is:!0,it:!0,its:!0,just:!0,least:!0,let:!0,like:!0,likely:!0,may:!0,me:!0,might:!0,most:!0,must:!0,my:!0,neither:!0,no:!0,nor:!0,not:!0,of:!0,off:!0,often:!0,on:!0,only:!0,or:!0,other:!0,our:!0,own:!0,rather:!0,said:!0,say:!0,says:!0,she:!0,should:!0,since:!0,so:!0,some:!0,than:!0,that:!0,the:!0,their:!0,them:!0,then:!0,there:!0,these:!0,they:!0,"this":!0,tis:!0,to:!0,too:!0,twas:!0,us:!0,wants:!0,was:!0,we:!0,were:!0,what:!0,when:!0,where:!0,which:!0,"while":!0,who:!0,whom:!0,why:!0,will:!0,"with":!0,would:!0,yet:!0,you:!0,your:!0},t.stopWordFilter.stopWords=t.defaultStopWords,t.Pipeline.registerFunction(t.stopWordFilter,"stopWordFilter"),t.trimmer=function(e){if(null===e||void 0===e)throw new Error("token should not be undefined");return e.replace(/^\W+/,"").replace(/\W+$/,"")},t.Pipeline.registerFunction(t.trimmer,"trimmer"),t.InvertedIndex=function(){this.root={docs:{},df:0}},t.InvertedIndex.load=function(e){var t=new this;return t.root=e.root,t},t.InvertedIndex.prototype.addToken=function(e,t,n){for(var n=n||this.root,i=0;i<=e.length-1;){var o=e[i];o in n||(n[o]={docs:{},df:0}),i+=1,n=n[o]}var r=t.ref;n.docs[r]?n.docs[r]={tf:t.tf}:(n.docs[r]={tf:t.tf},n.df+=1)},t.InvertedIndex.prototype.hasToken=function(e){if(!e)return!1;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return!1;t=t[e[n]]}return!0},t.InvertedIndex.prototype.getNode=function(e){if(!e)return null;for(var t=this.root,n=0;n<e.length;n++){if(!t[e[n]])return null;t=t[e[n]]}return t},t.InvertedIndex.prototype.getDocs=function(e){var t=this.getNode(e);return null==t?{}:t.docs},t.InvertedIndex.prototype.getTermFrequency=function(e,t){var n=this.getNode(e);return null==n?0:t in n.docs?n.docs[t].tf:0},t.InvertedIndex.prototype.getDocFreq=function(e){var t=this.getNode(e);return null==t?0:t.df},t.InvertedIndex.prototype.removeToken=function(e,t){if(e){var n=this.getNode(e);null!=n&&t in n.docs&&(delete n.docs[t],n.df-=1)}},t.InvertedIndex.prototype.expandToken=function(e,t,n){if(null==e||""==e)return[];var t=t||[];if(void 0==n&&(n=this.getNode(e),null==n))return t;n.df>0&&t.push(e);for(var i in n)"docs"!==i&&"df"!==i&&this.expandToken(e+i,t,n[i]);return t},t.InvertedIndex.prototype.toJSON=function(){return{root:this.root}},t.Configuration=function(e,n){var e=e||"";if(void 0==n||null==n)throw new Error("fields should not be null");this.config={};var i;try{i=JSON.parse(e),this.buildUserConfig(i,n)}catch(o){t.utils.warn("user configuration parse failed, will use default configuration"),this.buildDefaultConfig(n)}},t.Configuration.prototype.buildDefaultConfig=function(e){this.reset(),e.forEach(function(e){this.config[e]={boost:1,bool:"OR",expand:!1}},this)},t.Configuration.prototype.buildUserConfig=function(e,n){var i="OR",o=!1;if(this.reset(),"bool"in e&&(i=e.bool||i),"expand"in e&&(o=e.expand||o),"fields"in e)for(var r in e.fields)if(n.indexOf(r)>-1){var s=e.fields[r],u=o;void 0!=s.expand&&(u=s.expand),this.config[r]={boost:s.boost||0===s.boost?s.boost:1,bool:s.bool||i,expand:u}}else t.utils.warn("field name in user configuration not found in index instance fields");else this.addAllFields2UserConfig(i,o,n)},t.Configuration.prototype.addAllFields2UserConfig=function(e,t,n){n.forEach(function(n){this.config[n]={boost:1,bool:e,expand:t}},this)},t.Configuration.prototype.get=function(){return this.config},t.Configuration.prototype.reset=function(){this.config={}},lunr.SortedSet=function(){this.length=0,this.elements=[]},lunr.SortedSet.load=function(e){var t=new this;return t.elements=e,t.length=e.length,t},lunr.SortedSet.prototype.add=function(){var e,t;for(e=0;e<arguments.length;e++)t=arguments[e],~this.indexOf(t)||this.elements.splice(this.locationFor(t),0,t);this.length=this.elements.length},lunr.SortedSet.prototype.toArray=function(){return this.elements.slice()},lunr.SortedSet.prototype.map=function(e,t){return this.elements.map(e,t)},lunr.SortedSet.prototype.forEach=function(e,t){return this.elements.forEach(e,t)},lunr.SortedSet.prototype.indexOf=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;){if(r===e)return o;e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o]}return r===e?o:-1},lunr.SortedSet.prototype.locationFor=function(e){for(var t=0,n=this.elements.length,i=n-t,o=t+Math.floor(i/2),r=this.elements[o];i>1;)e>r&&(t=o),r>e&&(n=o),i=n-t,o=t+Math.floor(i/2),r=this.elements[o];return r>e?o:e>r?o+1:void 0},lunr.SortedSet.prototype.intersect=function(e){for(var t=new lunr.SortedSet,n=0,i=0,o=this.length,r=e.length,s=this.elements,u=e.elements;;){if(n>o-1||i>r-1)break;s[n]!==u[i]?s[n]<u[i]?n++:s[n]>u[i]&&i++:(t.add(s[n]),n++,i++)}return t},lunr.SortedSet.prototype.clone=function(){var e=new lunr.SortedSet;return e.elements=this.toArray(),e.length=e.elements.length,e},lunr.SortedSet.prototype.union=function(e){var t,n,i;this.length>=e.length?(t=this,n=e):(t=e,n=this),i=t.clone();for(var o=0,r=n.toArray();o<r.length;o++)i.add(r[o]);return i},lunr.SortedSet.prototype.toJSON=function(){return this.toArray()},function(e,t){"function"==typeof define&&define.amd?define(t):"object"==typeof exports?module.exports=t():e.elasticlunr=t()}(this,function(){return t})}();
    /** pdoc search index */const docs = [{"fullname": "seleniumuser", "modulename": "seleniumuser", "kind": "module", "doc": "<p></p>\n"}, {"fullname": "seleniumuser.seleniumuser", "modulename": "seleniumuser.seleniumuser", "kind": "module", "doc": "<p></p>\n"}, {"fullname": "seleniumuser.seleniumuser.User", "modulename": "seleniumuser.seleniumuser", "qualname": "User", "kind": "class", "doc": "<p>Sits on top of selenium to streamline\nautomation and scraping tasks.</p>\n"}, {"fullname": "seleniumuser.seleniumuser.User.__init__", "modulename": "seleniumuser.seleniumuser", "qualname": "User.__init__", "kind": "function", "doc": "<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><p><strong>headless</strong>:  If True, browser window will not be visible.</p></li>\n<li><p><strong>browser_type</strong>:  Which browser to use. Can be 'firefox' or 'chrome'.</p></li>\n<li><p><strong>implicit_wait</strong>:  Number of seconds to look for a specified element before\nselenium considers it missing and throws an exception.</p></li>\n<li><p><strong>page_load_timeout</strong>:  Time in seconds for selenium to wait for a page to load\nbefore throwing an exception.</p></li>\n<li><p><strong>open_browser</strong>:  If True, opens a browser window when a User object is created.\nIf False, a manual call to self.open_browser() must be made.</p></li>\n<li><p><strong>locator_method</strong>:  The locator type User should expect to be given.\nCan be 'xpath', 'id', 'className', 'name', or 'cssSelector'.\nEvery member function with a 'locator' argument refers to a string matching\nthe current locator_method.</p></li>\n<li><p><strong>randomize_user_agent</strong>:  If True, a random useragent will be used whenever\nthe browser is opened. If False, the native useragent will be used.</p></li>\n<li><p><strong>user_agent_rotation_period</strong>:  If not None, the browser window will be closed\nand reopened with a new useragent every user_agent_rotation_period number of minutes.\nRotation occurs on the first call to self.get() after the time period has elapsed.\nIgnored if randomize_user_agent is False.</p></li>\n<li><p><strong>move_window_by</strong>:  The x and y amount of pixels to move the browser window by after opening.</p></li>\n<li><p><strong>download_dir</strong>:  The download folder to use. If None, the default folder will be used.</p></li>\n<li><p><strong>driver_path</strong>:  The path to the webdriver executable selenium should use.\nIf None, the system PATH will be checked for the executable.\nIf the executable isn't found, the parent directories and the immediate child directories\nof the current working directory will be searched.</p></li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"n\">headless</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span>,</span><span class=\"param\">\t<span class=\"n\">browser_type</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;firefox&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">implicit_wait</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">10</span>,</span><span class=\"param\">\t<span class=\"n\">page_load_timeout</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">60</span>,</span><span class=\"param\">\t<span class=\"n\">open_browser</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">locator_method</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;xpath&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">randomize_user_agent</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">user_agent_rotation_period</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">move_window_by</span><span class=\"p\">:</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">int</span><span class=\"p\">,</span> <span class=\"nb\">int</span><span class=\"p\">]</span> <span class=\"o\">=</span> <span class=\"p\">(</span><span class=\"mi\">0</span><span class=\"p\">,</span> <span class=\"o\">-</span><span class=\"mi\">1000</span><span class=\"p\">)</span>,</span><span class=\"param\">\t<span class=\"n\">download_dir</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">driver_path</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"n\">pathlib</span><span class=\"o\">.</span><span class=\"n\">Path</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span>)</span>"}, {"fullname": "seleniumuser.seleniumuser.User.configure_firefox", "modulename": "seleniumuser.seleniumuser", "qualname": "User.configure_firefox", "kind": "function", "doc": "<p>Configure options and profile for firefox.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">selenium</span><span class=\"o\">.</span><span class=\"n\">webdriver</span><span class=\"o\">.</span><span class=\"n\">firefox</span><span class=\"o\">.</span><span class=\"n\">service</span><span class=\"o\">.</span><span class=\"n\">Service</span>:</span></span>", "funcdef": "def"}, {"fullname": "seleniumuser.seleniumuser.User.configure_chrome", "modulename": "seleniumuser.seleniumuser", "qualname": "User.configure_chrome", "kind": "function", "doc": "<p>Configure options and profile for chrome.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">selenium</span><span class=\"o\">.</span><span class=\"n\">webdriver</span><span class=\"o\">.</span><span class=\"n\">chrome</span><span class=\"o\">.</span><span class=\"n\">service</span><span class=\"o\">.</span><span class=\"n\">Service</span>:</span></span>", "funcdef": "def"}, {"fullname": "seleniumuser.seleniumuser.User.search_for_driver", "modulename": "seleniumuser.seleniumuser", "qualname": "User.search_for_driver", "kind": "function", "doc": "<p>Searches for the webdriver executable.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "seleniumuser.seleniumuser.User.set_implicit_wait", "modulename": "seleniumuser.seleniumuser", "qualname": "User.set_implicit_wait", "kind": "function", "doc": "<p>Sets to default time if no arg given.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">wait_time</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "seleniumuser.seleniumuser.User.open_browser", "modulename": "seleniumuser.seleniumuser", "qualname": "User.open_browser", "kind": "function", "doc": "<p>Configures and opens selenium browser.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "seleniumuser.seleniumuser.User.close_browser", "modulename": "seleniumuser.seleniumuser", "qualname": "User.close_browser", "kind": "function", "doc": "<p>Close browser window.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "seleniumuser.seleniumuser.User.open_tab", "modulename": "seleniumuser.seleniumuser", "qualname": "User.open_tab", "kind": "function", "doc": "<p>Opens new tab and, if provided, goes to url.</p>\n\n<p>New tab is inserted after currently active tab.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">url</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;&#39;</span>, </span><span class=\"param\"><span class=\"n\">switch_to_tab</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "seleniumuser.seleniumuser.User.switch_to_tab", "modulename": "seleniumuser.seleniumuser", "qualname": "User.switch_to_tab", "kind": "function", "doc": "<p>Switch to a tab in browser, zero indexed.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">tab_index</span><span class=\"p\">:</span> <span class=\"nb\">int</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "seleniumuser.seleniumuser.User.get_num_tabs", "modulename": "seleniumuser.seleniumuser", "qualname": "User.get_num_tabs", "kind": "function", "doc": "<p>Returns number of tabs open.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">int</span>:</span></span>", "funcdef": "def"}, {"fullname": "seleniumuser.seleniumuser.User.close_tab", "modulename": "seleniumuser.seleniumuser", "qualname": "User.close_tab", "kind": "function", "doc": "<p>Close specified tab and\nswitches to tab index 0.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">tab_index</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">1</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "seleniumuser.seleniumuser.User.get", "modulename": "seleniumuser.seleniumuser", "qualname": "User.get", "kind": "function", "doc": "<p>Requests webpage at given url and rotates userAgent if necessary.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">url</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "seleniumuser.seleniumuser.User.get_soup", "modulename": "seleniumuser.seleniumuser", "qualname": "User.get_soup", "kind": "function", "doc": "<p>Returns a BeautifulSoup object\nof the current page source.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"n\">bs4</span><span class=\"o\">.</span><span class=\"n\">BeautifulSoup</span>:</span></span>", "funcdef": "def"}, {"fullname": "seleniumuser.seleniumuser.User.current_url", "modulename": "seleniumuser.seleniumuser", "qualname": "User.current_url", "kind": "function", "doc": "<p>Returns current url of active tab.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, {"fullname": "seleniumuser.seleniumuser.User.delete_cookies", "modulename": "seleniumuser.seleniumuser", "qualname": "User.delete_cookies", "kind": "function", "doc": "<p>Delete all cookies for\nthis browser instance.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "seleniumuser.seleniumuser.User.turbo", "modulename": "seleniumuser.seleniumuser", "qualname": "User.turbo", "kind": "function", "doc": "<p>When engaged, strings will be sent\nto elements all at once and there will be\nno waiting after actions.</p>\n\n<p>When disengaged, strings will be sent to elements\n'one key at a time' with randomized amounts of\ntime between successive keys and after actions.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">engage</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "seleniumuser.seleniumuser.User.chill", "modulename": "seleniumuser.seleniumuser", "qualname": "User.chill", "kind": "function", "doc": "<p>Sleeps a random amount\nbetween min_max[0] and min_max[1].</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">min_max</span><span class=\"p\">:</span> <span class=\"nb\">tuple</span><span class=\"p\">[</span><span class=\"nb\">float</span><span class=\"p\">,</span> <span class=\"nb\">float</span><span class=\"p\">]</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "seleniumuser.seleniumuser.User.script", "modulename": "seleniumuser.seleniumuser", "qualname": "User.script", "kind": "function", "doc": "<p>Execute javascript code and returns result.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">script</span><span class=\"p\">:</span> <span class=\"nb\">str</span>, </span><span class=\"param\"><span class=\"n\">args</span><span class=\"p\">:</span> <span class=\"n\">Any</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">Any</span>:</span></span>", "funcdef": "def"}, {"fullname": "seleniumuser.seleniumuser.User.remove", "modulename": "seleniumuser.seleniumuser", "qualname": "User.remove", "kind": "function", "doc": "<p>Removes element from DOM.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">locator</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "seleniumuser.seleniumuser.User.get_length", "modulename": "seleniumuser.seleniumuser", "qualname": "User.get_length", "kind": "function", "doc": "<p>Returns number of child elements for a given element.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">locator</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">int</span>:</span></span>", "funcdef": "def"}, {"fullname": "seleniumuser.seleniumuser.User.find", "modulename": "seleniumuser.seleniumuser", "qualname": "User.find", "kind": "function", "doc": "<p>Finds and returns a WebElement.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">locator</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">selenium</span><span class=\"o\">.</span><span class=\"n\">webdriver</span><span class=\"o\">.</span><span class=\"n\">remote</span><span class=\"o\">.</span><span class=\"n\">webelement</span><span class=\"o\">.</span><span class=\"n\">WebElement</span>:</span></span>", "funcdef": "def"}, {"fullname": "seleniumuser.seleniumuser.User.find_children", "modulename": "seleniumuser.seleniumuser", "qualname": "User.find_children", "kind": "function", "doc": "<p>Returns a list of child WebElements\nfor given locator arg.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">locator</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"n\">selenium</span><span class=\"o\">.</span><span class=\"n\">webdriver</span><span class=\"o\">.</span><span class=\"n\">remote</span><span class=\"o\">.</span><span class=\"n\">webelement</span><span class=\"o\">.</span><span class=\"n\">WebElement</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, {"fullname": "seleniumuser.seleniumuser.User.scroll", "modulename": "seleniumuser.seleniumuser", "qualname": "User.scroll", "kind": "function", "doc": "<p>Scroll web page.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><p><strong>amount</strong>:  The number of lines to scroll if not None.</p></li>\n<li><p><strong>fraction</strong>:  The amount between 0.0 and 1.0\nof the page height to scroll.</p></li>\n</ul>\n\n<p>If values are provided for both arguments,\namount will be used.</p>\n\n<p>If values are provided for neither argument,\nthe entire page length will be scrolled.</p>\n\n<p>Scrolls one line at a time if self.turbo is False.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">amount</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>, </span><span class=\"param\"><span class=\"n\">fraction</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "seleniumuser.seleniumuser.User.scroll_into_view", "modulename": "seleniumuser.seleniumuser", "qualname": "User.scroll_into_view", "kind": "function", "doc": "<p>Scrolls to a given element and returns the element.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">locator</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">selenium</span><span class=\"o\">.</span><span class=\"n\">webdriver</span><span class=\"o\">.</span><span class=\"n\">remote</span><span class=\"o\">.</span><span class=\"n\">webelement</span><span class=\"o\">.</span><span class=\"n\">WebElement</span>:</span></span>", "funcdef": "def"}, {"fullname": "seleniumuser.seleniumuser.User.text", "modulename": "seleniumuser.seleniumuser", "qualname": "User.text", "kind": "function", "doc": "<p>Returns text of WebElement.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">locator</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">str</span>:</span></span>", "funcdef": "def"}, {"fullname": "seleniumuser.seleniumuser.User.click", "modulename": "seleniumuser.seleniumuser", "qualname": "User.click", "kind": "function", "doc": "<p>Clicks on and returns WebElement.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">locator</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">selenium</span><span class=\"o\">.</span><span class=\"n\">webdriver</span><span class=\"o\">.</span><span class=\"n\">remote</span><span class=\"o\">.</span><span class=\"n\">webelement</span><span class=\"o\">.</span><span class=\"n\">WebElement</span>:</span></span>", "funcdef": "def"}, {"fullname": "seleniumuser.seleniumuser.User.clear", "modulename": "seleniumuser.seleniumuser", "qualname": "User.clear", "kind": "function", "doc": "<p>Clears content of WebElement if able\nand then returns WebElement.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">locator</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">) -> <span class=\"n\">selenium</span><span class=\"o\">.</span><span class=\"n\">webdriver</span><span class=\"o\">.</span><span class=\"n\">remote</span><span class=\"o\">.</span><span class=\"n\">webelement</span><span class=\"o\">.</span><span class=\"n\">WebElement</span>:</span></span>", "funcdef": "def"}, {"fullname": "seleniumuser.seleniumuser.User.switch_to_iframe", "modulename": "seleniumuser.seleniumuser", "qualname": "User.switch_to_iframe", "kind": "function", "doc": "<p>Switch to an iframe from given locator.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span>, </span><span class=\"param\"><span class=\"n\">locator</span><span class=\"p\">:</span> <span class=\"nb\">str</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "seleniumuser.seleniumuser.User.switch_to_parent_frame", "modulename": "seleniumuser.seleniumuser", "qualname": "User.switch_to_parent_frame", "kind": "function", "doc": "<p>Move up a frame level from current frame.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "seleniumuser.seleniumuser.User.select", "modulename": "seleniumuser.seleniumuser", "qualname": "User.select", "kind": "function", "doc": "<p>Select a choice from Select element.\nReturns the Select element from the locator string,\nnot the option element that is selected.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><p><strong>method</strong>:  Can be 'value' or 'index'</p></li>\n<li><p><strong>choice</strong>:  The option to select.</p></li>\n</ul>\n\n<p>If method is 'value', then choice should be\nthe html 'value' attribute of the desired option.</p>\n\n<p>If method is 'index', choice can either be a single\nint for the desired option or it can be a two-tuple.\nIf the tuple is provided, a random option between the\ntwo indicies (inclusive) will be selected.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">locator</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">method</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">choice</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">int</span> <span class=\"o\">|</span> <span class=\"nb\">tuple</span></span><span class=\"return-annotation\">) -> <span class=\"n\">selenium</span><span class=\"o\">.</span><span class=\"n\">webdriver</span><span class=\"o\">.</span><span class=\"n\">remote</span><span class=\"o\">.</span><span class=\"n\">webelement</span><span class=\"o\">.</span><span class=\"n\">WebElement</span>:</span></span>", "funcdef": "def"}, {"fullname": "seleniumuser.seleniumuser.User.click_elements", "modulename": "seleniumuser.seleniumuser", "qualname": "User.click_elements", "kind": "function", "doc": "<p>Click a random number of WebElements\nand return the last WebElement clicked.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><p><strong>locators</strong>:  A list of element locators to choose from.</p></li>\n<li><p><strong>max_selections</strong>:  The maximum number of elements to click.\nIf None, the maximum will be the length of the locators list.</p></li>\n<li><p><strong>min_selections</strong>:  The minimum number of elements to click.</p></li>\n</ul>\n\n<p>e.g. self.click_elements([xpath1, xpath2, xpath3, xpath4], max_selections=3)\nwill click between 1 and 3 random elements from the list.</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">locators</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">max_selections</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"kc\">None</span>,</span><span class=\"param\">\t<span class=\"n\">min_selections</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">1</span></span><span class=\"return-annotation\">) -> <span class=\"n\">selenium</span><span class=\"o\">.</span><span class=\"n\">webdriver</span><span class=\"o\">.</span><span class=\"n\">remote</span><span class=\"o\">.</span><span class=\"n\">webelement</span><span class=\"o\">.</span><span class=\"n\">WebElement</span>:</span></span>", "funcdef": "def"}, {"fullname": "seleniumuser.seleniumuser.User.get_click_list", "modulename": "seleniumuser.seleniumuser", "qualname": "User.get_click_list", "kind": "function", "doc": "<p>Similar to self.click_elements(), but for use with the self.fill_next() method.</p>\n\n<p>Creates a list of length 'num_options' where every element is 'skip'.</p>\n\n<p>A random number of elements in the list between 'min_choices' and 'max_choices' are\nreplaced with 'keys.SPACE' (interpreted as a click by almost all web forms).</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">num_options</span><span class=\"p\">:</span> <span class=\"nb\">int</span>,</span><span class=\"param\">\t<span class=\"n\">max_choices</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">1</span>,</span><span class=\"param\">\t<span class=\"n\">min_choices</span><span class=\"p\">:</span> <span class=\"nb\">int</span> <span class=\"o\">=</span> <span class=\"mi\">1</span></span><span class=\"return-annotation\">) -> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span><span class=\"p\">]</span>:</span></span>", "funcdef": "def"}, {"fullname": "seleniumuser.seleniumuser.User.send_keys", "modulename": "seleniumuser.seleniumuser", "qualname": "User.send_keys", "kind": "function", "doc": "<p>Types data into element and returns the element.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><p><strong>data</strong>:  The string to send to the element.</p></li>\n<li><p><strong>click_first</strong>:  If True, the element is clicked on\nbefore the data is sent.</p></li>\n<li><p><strong>clear_first</strong>:  If True, the current text of the element\nis cleared before the data is sent.</p></li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">locator</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"nb\">str</span>,</span><span class=\"param\">\t<span class=\"n\">click_first</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">True</span>,</span><span class=\"param\">\t<span class=\"n\">clear_first</span><span class=\"p\">:</span> <span class=\"nb\">bool</span> <span class=\"o\">=</span> <span class=\"kc\">False</span></span><span class=\"return-annotation\">) -> <span class=\"n\">selenium</span><span class=\"o\">.</span><span class=\"n\">webdriver</span><span class=\"o\">.</span><span class=\"n\">remote</span><span class=\"o\">.</span><span class=\"n\">webelement</span><span class=\"o\">.</span><span class=\"n\">WebElement</span>:</span></span>", "funcdef": "def"}, {"fullname": "seleniumuser.seleniumuser.User.fill_next", "modulename": "seleniumuser.seleniumuser", "qualname": "User.fill_next", "kind": "function", "doc": "<p>Fills a form by tabbing from the current WebElement\nto the next one and using the corresponding item in data.\nReturns the last WebElement.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>data</strong>:  A list of form data. If an item is a string (except for 'skip')\nit will be typed into the current WebElement.</li>\n</ul>\n\n<p>An item in data can be a two-tuple of the form\n('downArrow', numberOfPresses:int|tuple[int, int]).</p>\n\n<p>If numberOfPresses is a single int, Keys.ARROW_DOWN will be sent\nthat many times to the WebElement.</p>\n\n<p>If numberOfPresses is a tuple, Keys.ARROW_DOWN will be sent a random\nnumber of times between numberOfPresses[0] and numberOfPresses[1] inclusive.\nThis is typically for use with Select elements.</p>\n\n<p>An item in data can also be 'skip', which will perform no action on the current\nWebElement and will continue to the next one.</p>\n\n<p>An item in data can also be 'click=n', where 'n' is an integer b/t 0 and 100,\nrepresenting a percent chance an element will be clicked or skipped:</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">user</span><span class=\"o\">.</span><span class=\"n\">fill_next</span><span class=\"p\">([</span><span class=\"s2\">&quot;click=70&quot;</span><span class=\"p\">])</span>\n</code></pre>\n</div>\n\n<p>has a 70% chance of being</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">user</span><span class=\"o\">.</span><span class=\"n\">fill_next</span><span class=\"p\">([</span><span class=\"n\">user</span><span class=\"o\">.</span><span class=\"n\">keys</span><span class=\"o\">.</span><span class=\"n\">SPACE</span><span class=\"p\">])</span>\n</code></pre>\n</div>\n\n<p>and a 30% chance of being</p>\n\n<div class=\"pdoc-code codehilite\">\n<pre><span></span><code><span class=\"gp\">&gt;&gt;&gt; </span><span class=\"n\">user</span><span class=\"o\">.</span><span class=\"n\">fill_next</span><span class=\"p\">([</span><span class=\"s2\">&quot;skip&quot;</span><span class=\"p\">])</span>\n</code></pre>\n</div>\n\n<ul>\n<li><strong>start_element</strong>:  The WebElement to start tabbing from.\nThe currently active element will be used if start_element is None.</li>\n</ul>\n\n<p>Note: The function tabs to the next element before sending data,\nso the start_element should the WebElement before the one\nthat should receive data[0].</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">data</span><span class=\"p\">:</span> <span class=\"nb\">list</span><span class=\"p\">[</span><span class=\"nb\">str</span> <span class=\"o\">|</span> <span class=\"nb\">tuple</span><span class=\"p\">]</span>,</span><span class=\"param\">\t<span class=\"n\">start_element</span><span class=\"p\">:</span> <span class=\"n\">selenium</span><span class=\"o\">.</span><span class=\"n\">webdriver</span><span class=\"o\">.</span><span class=\"n\">remote</span><span class=\"o\">.</span><span class=\"n\">webelement</span><span class=\"o\">.</span><span class=\"n\">WebElement</span> <span class=\"o\">=</span> <span class=\"kc\">None</span></span><span class=\"return-annotation\">) -> <span class=\"n\">selenium</span><span class=\"o\">.</span><span class=\"n\">webdriver</span><span class=\"o\">.</span><span class=\"n\">remote</span><span class=\"o\">.</span><span class=\"n\">webelement</span><span class=\"o\">.</span><span class=\"n\">WebElement</span>:</span></span>", "funcdef": "def"}, {"fullname": "seleniumuser.seleniumuser.User.wait_until", "modulename": "seleniumuser.seleniumuser", "qualname": "User.wait_until", "kind": "function", "doc": "<p>Checks condition repeatedly until either it is true,\nor the max_wait is exceeded.</p>\n\n<p>Raises a TimeoutError if the condition doesn't success within max_wait.</p>\n\n<p>Useful for determing whether a form has been successfully submitted.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><p><strong>condition</strong>:  The condition function to check.</p></li>\n<li><p><strong>max_wait</strong>:  Number of seconds to continue checking condition\nbefore throwing a TimeoutError.</p></li>\n<li><p><strong>polling_interval</strong>:  The number of seconds to sleep before\nchecking the condition function again after it fails.</p></li>\n</ul>\n\n<p>e.g. self.wait_until(lambda: 'Successfully Submitted' in self.text('//p[@id=\"form-output\"]))</p>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">condition</span><span class=\"p\">:</span> <span class=\"n\">function</span>,</span><span class=\"param\">\t<span class=\"n\">max_wait</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mi\">10</span>,</span><span class=\"param\">\t<span class=\"n\">polling_interval</span><span class=\"p\">:</span> <span class=\"nb\">float</span> <span class=\"o\">=</span> <span class=\"mf\">0.1</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "seleniumuser.seleniumuser.User.dismiss_alert", "modulename": "seleniumuser.seleniumuser", "qualname": "User.dismiss_alert", "kind": "function", "doc": "<p>Dismiss alert dialog.</p>\n", "signature": "<span class=\"signature pdoc-code condensed\">(<span class=\"param\"><span class=\"bp\">self</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}, {"fullname": "seleniumuser.seleniumuser.User.solve_recaptcha_v3", "modulename": "seleniumuser.seleniumuser", "qualname": "User.solve_recaptcha_v3", "kind": "function", "doc": "<p>Pass google recaptcha v3 by solving an audio puzzle.</p>\n\n<h6 id=\"parameters\">Parameters</h6>\n\n<ul>\n<li><strong>outer_iframe_xpath</strong>:  Xpath to the iframe containing the recaptcha checkbox.\nIf it's the recaptcha without the initial checkbox that just shows the image puzzle,\npass None to this argument.</li>\n</ul>\n", "signature": "<span class=\"signature pdoc-code multiline\">(<span class=\"param\">\t<span class=\"bp\">self</span>,</span><span class=\"param\">\t<span class=\"n\">outer_iframe_xpath</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;//iframe[@title=&quot;reCAPTCHA&quot;]&#39;</span>,</span><span class=\"param\">\t<span class=\"n\">inner_iframe_xpath</span><span class=\"p\">:</span> <span class=\"nb\">str</span> <span class=\"o\">=</span> <span class=\"s1\">&#39;//iframe[@title=&quot;recaptcha challenge expires in two minutes&quot;]&#39;</span></span><span class=\"return-annotation\">):</span></span>", "funcdef": "def"}];

    // mirrored in build-search-index.js (part 1)
    // Also split on html tags. this is a cheap heuristic, but good enough.
    elasticlunr.tokenizer.setSeperator(/[\s\-.;&_'"=,()]+|<[^>]*>/);

    let searchIndex;
    if (docs._isPrebuiltIndex) {
        console.info("using precompiled search index");
        searchIndex = elasticlunr.Index.load(docs);
    } else {
        console.time("building search index");
        // mirrored in build-search-index.js (part 2)
        searchIndex = elasticlunr(function () {
            this.pipeline.remove(elasticlunr.stemmer);
            this.pipeline.remove(elasticlunr.stopWordFilter);
            this.addField("qualname");
            this.addField("fullname");
            this.addField("annotation");
            this.addField("default_value");
            this.addField("signature");
            this.addField("bases");
            this.addField("doc");
            this.setRef("fullname");
        });
        for (let doc of docs) {
            searchIndex.addDoc(doc);
        }
        console.timeEnd("building search index");
    }

    return (term) => searchIndex.search(term, {
        fields: {
            qualname: {boost: 4},
            fullname: {boost: 2},
            annotation: {boost: 2},
            default_value: {boost: 2},
            signature: {boost: 2},
            bases: {boost: 2},
            doc: {boost: 1},
        },
        expand: true
    });
})();