# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['snooze',
 'snooze.alerta',
 'snooze.api',
 'snooze.cli',
 'snooze.db',
 'snooze.db.file',
 'snooze.db.mongo',
 'snooze.plugins',
 'snooze.plugins.core',
 'snooze.plugins.core.action',
 'snooze.plugins.core.action.falcon',
 'snooze.plugins.core.aggregaterule',
 'snooze.plugins.core.audit',
 'snooze.plugins.core.basic',
 'snooze.plugins.core.basic.falcon',
 'snooze.plugins.core.comment',
 'snooze.plugins.core.comment.falcon',
 'snooze.plugins.core.grafana',
 'snooze.plugins.core.grafana.falcon',
 'snooze.plugins.core.influxdb2',
 'snooze.plugins.core.influxdb2.falcon',
 'snooze.plugins.core.kapacitor',
 'snooze.plugins.core.kapacitor.falcon',
 'snooze.plugins.core.kv',
 'snooze.plugins.core.mail',
 'snooze.plugins.core.notification',
 'snooze.plugins.core.profile',
 'snooze.plugins.core.profile.falcon',
 'snooze.plugins.core.prometheus',
 'snooze.plugins.core.prometheus.falcon',
 'snooze.plugins.core.rule',
 'snooze.plugins.core.script',
 'snooze.plugins.core.settings',
 'snooze.plugins.core.settings.falcon',
 'snooze.plugins.core.snooze',
 'snooze.plugins.core.snooze.falcon',
 'snooze.plugins.core.stats',
 'snooze.plugins.core.stats.falcon',
 'snooze.plugins.core.user',
 'snooze.plugins.core.user.falcon',
 'snooze.plugins.core.webhook',
 'snooze.plugins.core.widget',
 'snooze.plugins.core.widget.falcon',
 'snooze.utils']

package_data = \
{'': ['*'],
 'snooze': ['defaults/*', 'defaults/web/*'],
 'snooze.plugins.core': ['environment/*', 'record/*', 'role/*']}

install_requires = \
['Jinja2>=3.0.1,<4.0.0',
 'MarkupSafe>=2.0.1,<3.0.0',
 'PyJWT>=2.3.0,<3.0.0',
 'PyYAML==5.4.1',
 'click>=8.0.1,<9.0.0',
 'falcon>=3.1.0,<4.0.0',
 'filelock>=3.7.0,<4.0.0',
 'kombu>=5.1.0,<6.0.0',
 'ldap3>=2.9.1,<3.0.0',
 'netifaces>=0.11.0,<0.12.0',
 'pathlib>=1.0.1,<2.0.0',
 'prometheus-client>=0.13.1,<0.14.0',
 'pydantic>=1.9.0,<2.0.0',
 'pymongo==3.12.1',
 'pyparsing>=2.4.7,<3.0.0',
 'python-dateutil>=2.8.2,<3.0.0',
 'requests-unixsocket>=0.2.0,<0.3.0',
 'requests>=2.26.0,<3.0.0',
 'tenacity>=8.0.1,<9.0.0',
 'tinydb==4.5.2',
 'waitress>=2.0.0,<3.0.0']

entry_points = \
{'console_scripts': ['check_snooze_server = '
                     'snooze.cli.health:check_snooze_server',
                     'snooze = snooze.cli.__main__:snooze',
                     'snooze-server = snooze.__main__:main']}

setup_kwargs = {
    'name': 'snooze-server',
    'version': '1.5.0',
    'description': 'Monitoring tool for logs aggregation and alerting',
    'long_description': '![Snoozeweb Logo](https://github.com/snoozeweb/snooze/raw/master/web/public/img/logo.png)\n\n# About\n\nSnooze is a powerful monitoring tool used for log aggregation and alerting. It comes with the following features:\n* Backend + Web interface\n* Local / LDAP / JWT token based authentication\n* Built-in clustering for scalability\n* Large number of sources as inputs\n* Log aggregation\n* Log manipulation\n* Log archiving\n* Alerting policies\n* Various alerting methods\n* Auto housekeeping\n* Auto backups\n* Metrics\n* Audit logs\n\nTry it now on: https://try.snoozeweb.net\n\n![Alerts](https://github.com/snoozeweb/snooze/raw/master/docs/_build/html/_images/web_alerts.png)\n\n# Installation\n\nInstallation on CentOS/RHEL\n\n```bash\n$ wget https://rpm.snoozeweb.net -O snooze-server-latest.rpm\n$ sudo yum localinstall snooze-server-latest.rpm\n$ sudo systemctl start snooze-server\n```\n\nInstallation on Ubuntu/Debian\n\n```bash\n$ wget https://deb.snoozeweb.net -O snooze-server-latest.deb\n$ sudo apt install snooze-server-latest.deb\n$ sudo systemctl start snooze-server\n```\n\nDocker deployment\n\n```\n$ docker run --name snoozeweb -d -p <port>:5200 snoozeweb/snooze\n```\n\nWeb interface URL:\n\n```\nhttp://localhost:5200\n```\n\nDefault login credentials are `root:root`\n\n# Documentation\n\n[Documentation page](https://docs.snoozeweb.net)\n\n# License\n\n```\nSnooze - Log aggregation and alerting\n\nCopyright 2018-2020 Florian Dematraz <florian.dematraz@snoozeweb.net>\nCopyright 2018-2020 Guillaume Ludinard <guillaume.ludi@gmail.com>\nCopyright 2020-2022 Japannext Co., Ltd. <https://www.japannext.co.jp/>\n\nThis program is free software: you can redistribute it and/or modify\nit under the terms of the GNU Affero General Public License as\npublished by the Free Software Foundation, either version 3 of the\nLicense, or (at your option) any later version.\n\nThis program is distributed in the hope that it will be useful,\nbut WITHOUT ANY WARRANTY; without even the implied warranty of\nMERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\nGNU Affero General Public License for more details.\n\nYou should have received a copy of the GNU Affero General Public License\nalong with this program.  If not, see <https://www.gnu.org/licenses/>.\n```\n',
    'author': 'Florian Dematraz',
    'author_email': 'florian.dematraz@snoozeweb.net',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
