# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._enums import *
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 attributes: pulumi.Input['InstanceAttributesArgs'],
                 identity_management_type: pulumi.Input['InstanceIdentityManagementType'],
                 directory_id: Optional[pulumi.Input[str]] = None,
                 instance_alias: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input['InstanceAttributesArgs'] attributes: The attributes for the instance.
        :param pulumi.Input['InstanceIdentityManagementType'] identity_management_type: Specifies the type of directory integration for new instance.
        :param pulumi.Input[str] directory_id: Existing directoryId user wants to map to the new Connect instance.
        :param pulumi.Input[str] instance_alias: Alias of the new directory created as part of new instance creation.
        """
        pulumi.set(__self__, "attributes", attributes)
        pulumi.set(__self__, "identity_management_type", identity_management_type)
        if directory_id is not None:
            pulumi.set(__self__, "directory_id", directory_id)
        if instance_alias is not None:
            pulumi.set(__self__, "instance_alias", instance_alias)

    @property
    @pulumi.getter
    def attributes(self) -> pulumi.Input['InstanceAttributesArgs']:
        """
        The attributes for the instance.
        """
        return pulumi.get(self, "attributes")

    @attributes.setter
    def attributes(self, value: pulumi.Input['InstanceAttributesArgs']):
        pulumi.set(self, "attributes", value)

    @property
    @pulumi.getter(name="identityManagementType")
    def identity_management_type(self) -> pulumi.Input['InstanceIdentityManagementType']:
        """
        Specifies the type of directory integration for new instance.
        """
        return pulumi.get(self, "identity_management_type")

    @identity_management_type.setter
    def identity_management_type(self, value: pulumi.Input['InstanceIdentityManagementType']):
        pulumi.set(self, "identity_management_type", value)

    @property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> Optional[pulumi.Input[str]]:
        """
        Existing directoryId user wants to map to the new Connect instance.
        """
        return pulumi.get(self, "directory_id")

    @directory_id.setter
    def directory_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "directory_id", value)

    @property
    @pulumi.getter(name="instanceAlias")
    def instance_alias(self) -> Optional[pulumi.Input[str]]:
        """
        Alias of the new directory created as part of new instance creation.
        """
        return pulumi.get(self, "instance_alias")

    @instance_alias.setter
    def instance_alias(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_alias", value)


class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attributes: Optional[pulumi.Input[pulumi.InputType['InstanceAttributesArgs']]] = None,
                 directory_id: Optional[pulumi.Input[str]] = None,
                 identity_management_type: Optional[pulumi.Input['InstanceIdentityManagementType']] = None,
                 instance_alias: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Resource Type definition for AWS::Connect::Instance

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['InstanceAttributesArgs']] attributes: The attributes for the instance.
        :param pulumi.Input[str] directory_id: Existing directoryId user wants to map to the new Connect instance.
        :param pulumi.Input['InstanceIdentityManagementType'] identity_management_type: Specifies the type of directory integration for new instance.
        :param pulumi.Input[str] instance_alias: Alias of the new directory created as part of new instance creation.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Resource Type definition for AWS::Connect::Instance

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 attributes: Optional[pulumi.Input[pulumi.InputType['InstanceAttributesArgs']]] = None,
                 directory_id: Optional[pulumi.Input[str]] = None,
                 identity_management_type: Optional[pulumi.Input['InstanceIdentityManagementType']] = None,
                 instance_alias: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            if attributes is None and not opts.urn:
                raise TypeError("Missing required property 'attributes'")
            __props__.__dict__["attributes"] = attributes
            __props__.__dict__["directory_id"] = directory_id
            if identity_management_type is None and not opts.urn:
                raise TypeError("Missing required property 'identity_management_type'")
            __props__.__dict__["identity_management_type"] = identity_management_type
            __props__.__dict__["instance_alias"] = instance_alias
            __props__.__dict__["arn"] = None
            __props__.__dict__["created_time"] = None
            __props__.__dict__["instance_status"] = None
            __props__.__dict__["service_role"] = None
        super(Instance, __self__).__init__(
            'aws-native:connect:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = InstanceArgs.__new__(InstanceArgs)

        __props__.__dict__["arn"] = None
        __props__.__dict__["attributes"] = None
        __props__.__dict__["created_time"] = None
        __props__.__dict__["directory_id"] = None
        __props__.__dict__["identity_management_type"] = None
        __props__.__dict__["instance_alias"] = None
        __props__.__dict__["instance_status"] = None
        __props__.__dict__["service_role"] = None
        return Instance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def arn(self) -> pulumi.Output[str]:
        """
        An instanceArn is automatically generated on creation based on instanceId.
        """
        return pulumi.get(self, "arn")

    @property
    @pulumi.getter
    def attributes(self) -> pulumi.Output['outputs.InstanceAttributes']:
        """
        The attributes for the instance.
        """
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter(name="createdTime")
    def created_time(self) -> pulumi.Output[str]:
        """
        Timestamp of instance creation logged as part of instance creation.
        """
        return pulumi.get(self, "created_time")

    @property
    @pulumi.getter(name="directoryId")
    def directory_id(self) -> pulumi.Output[Optional[str]]:
        """
        Existing directoryId user wants to map to the new Connect instance.
        """
        return pulumi.get(self, "directory_id")

    @property
    @pulumi.getter(name="identityManagementType")
    def identity_management_type(self) -> pulumi.Output['InstanceIdentityManagementType']:
        """
        Specifies the type of directory integration for new instance.
        """
        return pulumi.get(self, "identity_management_type")

    @property
    @pulumi.getter(name="instanceAlias")
    def instance_alias(self) -> pulumi.Output[Optional[str]]:
        """
        Alias of the new directory created as part of new instance creation.
        """
        return pulumi.get(self, "instance_alias")

    @property
    @pulumi.getter(name="instanceStatus")
    def instance_status(self) -> pulumi.Output['InstanceStatus']:
        """
        Specifies the creation status of new instance.
        """
        return pulumi.get(self, "instance_status")

    @property
    @pulumi.getter(name="serviceRole")
    def service_role(self) -> pulumi.Output[str]:
        """
        Service linked role created as part of instance creation.
        """
        return pulumi.get(self, "service_role")

