c file:                  taugas.f
c
c external routines:     kdistr,absint,taugas
c                        gasinit, gasset, depthscl, readk
c
c internal routines:     slf296,slf260,frn296,sint,c4dta,hno3,
c                        hertda,o2cont,o2int,o3hht,o3int,o3uv,
c                        c8dta,cxdta,abcdta,schrun,volmix
c
c modules:               gasblk, trcblk, kdstblk
c
c=======================================================================
      module gasblk
      use params, only: mxly, kr
      integer, parameter :: nta=9

      real(kr) :: bma(11), bmb(11), bmc(11), bms(11), cps(11)

      real(kr) :: cph2o(3515), cpo3(447), cpco2(1219), cpco(173),
     &        cpch4(493), cpn2o(704), cpo2(382), cpnh3(431), cpno(62),
     &        cpno2(142), cpso2(226)

      integer :: iwlh2o(15), iwlo3(6), iwlco2(11), iwlco(4), iwlch4(5), 
     &           iwln2o(12), iwlo2(7), iwlnh3(3), iwlno(2), iwlno2(4),
     &           iwlso2(5), iwhh2o(15), iwho3(6), iwhco2(11), iwhco(4),
     &           iwhch4(5), iwhn2o(12), iwho2(7), iwhnh3(3), iwhno(2),
     &           iwhno2(4), iwhso2(5), ibnd(11)


c --- double exponential fit parameters for h2o  

      data cph2o(1:100)/
     &  -0.59366,  -0.16679,   0.42846,   0.87819,   1.26357, 
     &   1.59247,   1.86372,   2.11483,   2.31810,   2.44040, 
     &   2.55998,   2.69879,   2.79810,   2.89747,   2.98118, 
     &   3.04863,   3.09568,   3.15381,   3.22984,   3.23785, 
     &   3.20991,   3.14246,   3.03461,   2.98864,   3.03520, 
     &   3.08981,   3.10027,   3.11302,   3.10266,   3.05765, 
     &   3.06166,   3.01593,   2.95500,   2.95328,   2.95297, 
     &   2.91497,   2.83753,   2.74642,   2.70474,   2.75606, 
     &   2.84097,   2.89052,   2.89886,   2.86150,   2.78032, 
     &   2.67212,   2.52752,   2.39301,   2.38109,   2.43965, 
     &   2.46195,   2.39329,   2.22943,   2.15815,   2.16157, 
     &   2.29683,   2.40335,   2.35569,   2.29239,   2.12968, 
     &   2.03781,   1.94313,   1.86282,   1.87312,   1.88177, 
     &   1.95321,   1.94145,   1.92602,   1.92812,   1.90587, 
     &   2.04943,   1.95396,   1.78078,   1.60325,   1.55071, 
     &   1.49473,   1.46485,   1.50231,   1.39831,   1.30664, 
     &   1.14704,   0.96109,   0.93139,   1.00613,   1.11827, 
     &   1.13529,   1.07767,   0.96652,   0.90777,   0.91973, 
     &   0.90622,   0.93883,   0.90861,   0.81968,   0.79852, 
     &   0.69385,   0.56997,   0.49693,   0.40867,   0.37846/
      data cph2o(101:200)/
     &   0.44490,   0.53554,   0.59020,   0.59196,   0.50771, 
     &   0.34361,   0.20796,   0.15417,   0.13600,   0.14235, 
     &   0.12700,   0.08853,   0.06715,   0.11430,   0.15016, 
     &   0.15016,   0.13964,   0.04897,  -0.04476,  -0.16953, 
     &  -0.30196,  -0.39901,  -0.42462,  -0.39340,  -0.35671, 
     &  -0.30771,  -0.31570,  -0.35021,  -0.47016,  -0.62308, 
     &  -0.77946,  -0.85086,  -0.82482,  -0.83468,  -0.83991, 
     &  -0.89726,  -0.90918,  -0.84484,  -0.71025,  -0.62777, 
     &  -0.66324,  -0.76848,  -1.03341,  -1.27044,  -1.49576, 
     &  -1.61769,  -1.53549,  -1.47958,  -1.33160,  -1.29625, 
     &  -1.40768,  -1.52411,  -1.72765,  -1.82510,  -1.76468, 
     &  -1.70983,  -1.59977,  -1.50730,  -1.46683,  -1.39464, 
     &  -1.43093,  -1.58947,  -1.78778,  -2.06146,  -2.33634, 
     &  -2.40749,  -2.49065,  -2.44182,  -2.25150,  -2.19801, 
     &  -2.08624,  -2.10309,  -2.27174,  -2.36492,  -2.45781, 
     &  -2.44508,  -2.36196,  -2.38101,  -2.48058,  -2.61957, 
     &  -2.74895,  -2.74245,  -2.63961,  -2.61588,  -2.61569, 
     &  -2.71770,  -2.92220,  -3.01021,  -2.99432,  -2.89456, 
     &  -2.79847,  -2.73359,  -2.69055,  -2.65898,  -2.60837, 
     &  -2.63170,  -2.79096,  -2.97394,  -3.15934,  -3.17057/
      data cph2o(201:300)/
     &  -2.95258,  -2.78308,  -2.69196,  -2.60867,  -2.62239, 
     &  -2.62637,  -2.62950,  -2.71010,  -2.72574,  -2.71317, 
     &  -2.61321,  -2.51967,  -2.42437,  -2.38734,  -2.45056, 
     &  -2.47843,  -2.58702,  -2.56472,  -2.44706,  -2.30814, 
     &  -2.12582,  -2.02697,  -1.99880,  -2.05659,  -2.05701, 
     &  -2.06643,  -2.04721,  -1.90723,  -1.90946,  -1.92812, 
     &  -1.86522,  -1.88820,  -1.77270,  -1.60669,  -1.51740, 
     &  -1.40182,  -1.38758,  -1.38799,  -1.41620,  -1.43182, 
     &  -1.37124,  -1.28249,  -1.09992,  -0.99724,  -0.97950, 
     &  -0.99952,  -1.09066,  -1.09980,  -1.00750,  -0.87259, 
     &  -0.70131,  -0.48309,  -0.30502,  -0.20407,  -0.13886, 
     &  -0.19661,  -0.24505,  -0.28415,  -0.34466,  -0.34496, 
     &  -0.28657,  -0.09485,   0.16770,   0.38311,   0.48553, 
     &   0.49475,   0.49074,   0.52493,   0.57439,   0.60303, 
     &   0.66919,   0.75656,   0.90385,   1.04976,   1.13836, 
     &   1.20132,   1.21963,   1.30344,   1.41212,   1.46770, 
     &   1.47630,   1.45559,   1.43315,   1.49679,   1.62749, 
     &   1.68517,   1.70120,   1.66090,   1.59891,   1.64107, 
     &   1.76792,   1.93419,   2.09362,   2.13280,   2.07959, 
     &   2.01987,   1.96835,   2.03073,   2.17591,   2.32257/
      data cph2o(301:400)/
     &   2.49261,   2.60881,   2.66112,   2.68139,   2.70360, 
     &   2.70568,   2.67997,   2.66478,   2.63655,   2.59716, 
     &   2.57555,   2.58781,   2.58940,   2.50826,   2.28771, 
     &   1.95070,   1.59144,   1.31269,   1.21786,   1.22507, 
     &   1.31945,   1.53875,   1.78543,   2.02655,   2.22881, 
     &   2.32061,   2.34163,   2.39432,   2.43073,   2.53438, 
     &   2.55861,   2.51156,   2.46499,   2.46254,   2.51561, 
     &   2.56373,   2.62430,   2.67999,   2.68386,   2.68780, 
     &   2.68227,   2.59536,   2.42505,   2.29307,   2.17816, 
     &   2.11945,   2.20521,   2.32197,   2.38083,   2.38052, 
     &   2.25417,   2.11473,   2.06142,   2.02788,   2.01508, 
     &   1.97680,   1.91586,   1.87253,   1.83706,   1.80766, 
     &   1.67367,   1.45528,   1.29956,   1.18809,   1.20246, 
     &   1.33650,   1.45778,   1.48886,   1.40546,   1.22716, 
     &   1.01444,   0.91282,   0.87247,   0.83576,   0.80170, 
     &   0.71481,   0.66927,   0.65846,   0.66839,   0.68503, 
     &   0.66215,   0.72413,   0.78703,   0.77831,   0.71136, 
     &   0.51200,   0.35931,   0.30680,   0.33365,   0.36267, 
     &   0.32095,   0.25710,   0.12363,  -0.02266,  -0.18001, 
     &  -0.28048,  -0.27808,  -0.19047,  -0.08151,  -0.09169/
      data cph2o(401:500)/
     &  -0.16662,  -0.24404,  -0.27238,  -0.27345,  -0.32244, 
     &  -0.42037,  -0.54071,  -0.63500,  -0.69930,  -0.77174, 
     &  -0.83521,  -0.86639,  -0.82329,  -0.78820,  -0.82340, 
     &  -0.83838,  -0.91387,  -0.96524,  -0.96364,  -1.05757, 
     &  -1.12747,  -1.19973,  -1.27071,  -1.30173,  -1.34436, 
     &  -1.35556,  -1.35990,  -1.30386,  -1.26726,  -1.28022, 
     &  -1.32843,  -1.43599,  -1.55929,  -1.69416,  -1.79362, 
     &  -1.86416,  -1.90037,  -1.91305,  -1.94866,  -1.95483, 
     &  -1.92284,  -1.87535,  -1.83065,  -1.86043,  -1.93470, 
     &  -2.01410,  -2.07677,  -2.07980,  -2.01822,  -1.96078, 
     &  -1.95185,  -1.96638,  -2.05704,  -2.17667,  -2.24120, 
     &  -2.27833,  -2.33268,  -2.37375,  -2.43075,  -2.54346, 
     &  -2.60789,  -2.68442,  -2.78402,  -2.83736,  -2.89622, 
     &  -2.95598,  -3.03170,  -3.13338,  -3.26736,  -3.41725, 
     &  -3.51456,  -3.61586,  -3.67210,  -3.67841,  -3.72135, 
     &  -3.74941,  -3.78822,  -3.85868,  -3.90419,  -3.91592, 
     &  -3.97897,  -4.00562,  -4.08675,  -4.18795,  -4.15833, 
     &  -4.18094,  -4.18872,  -4.25849,  -4.42026,  -4.57444, 
     &  -4.64021,  -4.58636,  -4.51788,  -4.46274,  -4.44165, 
     &  -4.45450,  -4.42101,  -4.35067,  -4.30493,  -4.23157/
      data cph2o(501:600)/
     &  -4.11952,  -4.01918,  -3.93341,  -3.81424,  -3.70572, 
     &  -3.62484,  -3.48143,  -3.35886,  -3.26514,  -3.15517, 
     &  -3.02814,  -2.95147,  -2.83444,  -2.68908,  -2.62390, 
     &  -2.50458,  -2.39841,  -2.35516,  -2.24360,  -2.18204, 
     &  -2.16652,  -2.08381,  -2.02597,  -1.99880,  -1.90122, 
     &  -1.84045,  -1.82575,  -1.74889,  -1.70489,  -1.66792, 
     &  -1.60475,  -1.59789,  -1.59221,  -1.60854,  -1.66569, 
     &  -1.68527,  -1.72998,  -1.79886,  -1.81356,  -1.82715, 
     &  -1.79425,  -1.61106,  -1.40549,  -1.24369,  -1.15433, 
     &  -1.23589,  -1.44178,  -1.64717,  -1.78560,  -1.84622, 
     &  -1.77824,  -1.69071,  -1.66066,  -1.58765,  -1.54222, 
     &  -1.51960,  -1.45477,  -1.39881,  -1.38659,  -1.37586, 
     &  -1.36025,  -1.39179,  -1.36927,  -1.35455,  -1.38734, 
     &  -1.40292,  -1.45598,  -1.51545,  -1.56173,  -1.62478, 
     &  -1.69200,  -1.75192,  -1.81120,  -1.83354,  -1.87063, 
     &  -1.89006,  -1.88485,  -1.90298,  -1.85403,  -1.82001, 
     &  -1.82495,  -1.82901,  -1.90076,  -1.93649,  -1.83304, 
     &  -1.70268,  -1.52380,  -1.41443,  -1.41301,  -1.39373, 
     &  -1.34561,  -1.20932,  -1.03186,  -0.85296,  -0.71145, 
     &  -0.59825,  -0.51884,  -0.51690,  -0.51723,  -0.52224/
      data cph2o(601:700)/
     &  -0.50043,  -0.40989,  -0.32204,  -0.24881,  -0.18653, 
     &  -0.17548,  -0.22729,  -0.32885,  -0.46183,  -0.47994, 
     &  -0.36042,  -0.23072,  -0.12160,  -0.06422,  -0.14924, 
     &  -0.21674,  -0.17913,  -0.15803,  -0.04515,   0.14450, 
     &   0.28118,   0.39718,   0.49818,   0.51040,   0.44761, 
     &   0.29666,   0.01147,  -0.32421,  -0.66518,  -0.96090, 
     &  -1.13017,  -1.18009,  -1.08032,  -0.80133,  -0.52001, 
     &  -0.33748,  -0.22519,  -0.20871,  -0.26962,  -0.22592, 
     &  -0.15919,  -0.07358,   0.09367,   0.20019,   0.25965, 
     &   0.27816,   0.28577,   0.22305,   0.17722,   0.14469, 
     &   0.06694,   0.07268,   0.10103,   0.14554,   0.20352, 
     &   0.25681,   0.25790,   0.21316,   0.15965,   0.08703, 
     &   0.01638,  -0.03529,  -0.03274,  -0.08812,  -0.12524, 
     &  -0.13536,  -0.23808,  -0.28262,  -0.30082,  -0.29252, 
     &  -0.13320,   0.05226,   0.17657,   0.21670,   0.12268, 
     &   0.00438,  -0.03051,  -0.00359,   0.02967,   0.04460, 
     &  -0.01109,  -0.06041,  -0.07485,  -0.02511,   0.07116, 
     &   0.18506,   0.27668,   0.32130,   0.35452,   0.39867, 
     &   0.36470,   0.34978,   0.36519,   0.38993,   0.47009, 
     &   0.54349,   0.60193,   0.67101,   0.73253,   0.84100/
      data cph2o(701:800)/
     &   0.92974,   1.00406,   1.06301,   1.07261,   1.09629, 
     &   1.10790,   1.10959,   1.11710,   1.15716,   1.24152, 
     &   1.34834,   1.45152,   1.53939,   1.59331,   1.60894, 
     &   1.63833,   1.67031,   1.74144,   1.82069,   1.90463, 
     &   1.98593,   2.02996,   2.10254,   2.16357,   2.16140, 
     &   2.11190,   2.06655,   2.02241,   2.02978,   2.06771, 
     &   2.04985,   2.02048,   1.99566,   2.01593,   2.11269, 
     &   2.22805,   2.27037,   2.23480,   2.16907,   2.09990, 
     &   2.08096,   2.10710,   2.15298,   2.19061,   2.25811, 
     &   2.34221,   2.43200,   2.59765,   2.72007,   2.77243, 
     &   2.71671,   2.56246,   2.33896,   2.14412,   1.97864, 
     &   1.79640,   1.73371,   1.71380,   1.74950,   1.91932, 
     &   2.10063,   2.26262,   2.36884,   2.42988,   2.47605, 
     &   2.51875,   2.53371,   2.51476,   2.47425,   2.40051, 
     &   2.39254,   2.39540,   2.35342,   2.33460,   2.26830, 
     &   2.17169,   2.09605,   2.04747,   2.01127,   1.89721, 
     &   1.74928,   1.55948,   1.38069,   1.34831,   1.35751, 
     &   1.35809,   1.34286,   1.25929,   1.16743,   1.09595, 
     &   1.00365,   0.87965,   0.76257,   0.64206,   0.56343, 
     &   0.49943,   0.40691,   0.29104,   0.18437,   0.12690/
      data cph2o(801:900)/
     &   0.09157,   0.13377,   0.18899,   0.20257,   0.19155, 
     &   0.09384,  -0.01238,  -0.14283,  -0.26122,  -0.31851, 
     &  -0.45610,  -0.58273,  -0.65867,  -0.73100,  -0.66169, 
     &  -0.52264,  -0.46798,  -0.50258,  -0.59104,  -0.72925, 
     &  -0.81067,  -0.80914,  -0.86943,  -0.92975,  -0.92524, 
     &  -0.88289,  -0.79203,  -0.69250,  -0.68167,  -0.75444, 
     &  -0.86193,  -0.97556,  -1.10473,  -1.20018,  -1.24824, 
     &  -1.27702,  -1.22693,  -1.18773,  -1.13552,  -1.14015, 
     &  -1.21589,  -1.26394,  -1.39464,  -1.46192,  -1.52629, 
     &  -1.64635,  -1.71511,  -1.78752,  -1.79358,  -1.77801, 
     &  -1.75599,  -1.77196,  -1.83224,  -1.89985,  -1.98528, 
     &  -2.09408,  -2.24126,  -2.37607,  -2.43218,  -2.43830, 
     &  -2.38400,  -2.33538,  -2.43573,  -2.52275,  -2.67290, 
     &  -2.83451,  -2.93019,  -3.01749,  -3.02463,  -2.99666, 
     &  -2.95414,  -2.91300,  -2.96493,  -3.07471,  -3.25693, 
     &  -3.47657,  -3.67222,  -3.88925,  -3.97727,  -3.94079, 
     &  -3.81920,  -3.66194,  -3.59739,  -3.64351,  -3.74016, 
     &  -3.90037,  -4.04679,  -4.07663,  -4.03256,  -3.91836, 
     &  -3.80990,  -3.76032,  -3.77951,  -3.84240,  -3.90305, 
     &  -3.92223,  -3.82628,  -3.65450,  -3.44339,  -3.25756/
      data cph2o(901:1000)/
     &  -3.09919,  -3.00901,  -2.95747,  -2.88271,  -2.82108, 
     &  -2.72633,  -2.59367,  -2.46775,  -2.36235,  -2.28438, 
     &  -2.27343,  -2.30886,  -2.33620,  -2.27813,  -2.20677, 
     &  -2.16170,  -2.14594,  -2.24245,  -2.36299,  -2.42996, 
     &  -2.50866,  -2.55678,  -2.50968,  -2.47465,  -2.42796, 
     &  -2.37981,  -2.34092,  -2.30518,  -2.26753,  -2.27390, 
     &  -2.44156,  -2.72384,  -3.06108,  -3.38056,  -3.48970, 
     &  -3.41674,  -3.36528,  -3.27790,  -3.15495,  -3.01945, 
     &  -2.81869,  -2.66003,  -2.56096,  -2.49017,  -2.46335, 
     &  -2.51454,  -2.59743,  -2.67025,  -2.78841,  -2.77863, 
     &  -2.63881,  -2.54169,  -2.40240,  -2.37146,  -2.46253, 
     &  -2.54291,  -2.65346,  -2.69467,  -2.69130,  -2.65025, 
     &  -2.59152,  -2.56343,  -2.50785,  -2.44665,  -2.41418, 
     &  -2.34553,  -2.28223,  -2.25278,  -2.20694,  -2.16892, 
     &  -2.14295,  -2.14341,  -2.16443,  -2.24853,  -2.38594, 
     &  -2.49449,  -2.58047,  -2.55462,  -2.41673,  -2.35641, 
     &  -2.32619,  -2.34603,  -2.40102,  -2.30576,  -2.20532, 
     &  -2.09307,  -2.00782,  -2.00039,  -1.91252,  -1.80383, 
     &  -1.65749,  -1.55728,  -1.59262,  -1.70939,  -1.83569, 
     &  -1.84895,  -1.71457,  -1.53813,  -1.41904,  -1.37588/
      data cph2o(1001:1100)/
     &  -1.39458,  -1.39135,  -1.35232,  -1.30470,  -1.24821, 
     &  -1.20394,  -1.19607,  -1.15995,  -1.13948,  -1.11024, 
     &  -1.03785,  -0.99804,  -0.95430,  -0.92707,  -0.93592, 
     &  -0.93528,  -0.86881,  -0.75121,  -0.55836,  -0.35056, 
     &  -0.22085,  -0.13412,  -0.12673,  -0.13867,  -0.11656, 
     &  -0.07357,   0.01888,   0.11050,   0.20428,   0.29291, 
     &   0.35923,   0.43608,   0.47266,   0.49792,   0.54978, 
     &   0.60489,   0.67778,   0.71787,   0.73606,   0.74796, 
     &   0.75193,   0.81728,   0.87972,   0.95990,   1.07451, 
     &   1.13098,   1.17565,   1.19031,   1.20334,   1.27687, 
     &   1.35910,   1.41924,   1.37988,   1.28213,   1.16286, 
     &   1.08658,   1.06554,   1.03702,   1.01290,   0.95519, 
     &   0.94231,   0.94216,   0.95764,   1.03405,   1.11309, 
     &   1.27076,   1.48131,   1.66125,   1.76502,   1.68299, 
     &   1.50126,   1.28195,   1.13724,   1.09863,   1.12031, 
     &   1.23502,   1.34328,   1.39556,   1.40851,   1.40939, 
     &   1.40259,   1.39505,   1.38427,   1.33724,   1.29860, 
     &   1.34354,   1.43194,   1.50874,   1.54493,   1.48740, 
     &   1.37260,   1.26973,   1.21297,   1.11026,   0.97625, 
     &   0.87238,   0.76100,   0.71825,   0.73936,   0.69604/
      data cph2o(1101:1200)/
     &   0.64138,   0.59585,   0.51097,   0.44903,   0.40524, 
     &   0.29892,   0.21583,   0.19145,   0.15378,   0.13759, 
     &   0.09412,  -0.04455,  -0.18870,  -0.28538,  -0.37204, 
     &  -0.46390,  -0.57884,  -0.70647,  -0.78911,  -0.79511, 
     &  -0.76645,  -0.76146,  -0.80163,  -0.83155,  -0.86672, 
     &  -0.92994,  -0.99971,  -1.10990,  -1.25701,  -1.32841, 
     &  -1.33350,  -1.35269,  -1.31799,  -1.35095,  -1.48830, 
     &  -1.57874,  -1.67539,  -1.72874,  -1.68087,  -1.67518, 
     &  -1.73066,  -1.77654,  -1.79238,  -1.81386,  -1.77187, 
     &  -1.73774,  -1.78673,  -1.82129,  -1.86174,  -1.87867, 
     &  -1.92986,  -1.95895,  -1.98042,  -2.10738,  -2.14350, 
     &  -2.22883,  -2.35165,  -2.30593,  -2.31343,  -2.23607, 
     &  -2.17791,  -2.29047,  -2.40740,  -2.60466,  -2.70413, 
     &  -2.67647,  -2.64479,  -2.62274,  -2.66727,  -2.67591, 
     &  -2.66531,  -2.64576,  -2.69566,  -2.79611,  -2.90809, 
     &  -2.99381,  -2.94495,  -2.94833,  -2.97002,  -3.01283, 
     &  -3.07907,  -3.08348,  -3.06412,  -3.08084,  -3.20105, 
     &  -3.32453,  -3.49652,  -3.63219,  -3.65897,  -3.69476, 
     &  -3.63741,  -3.54369,  -3.44992,  -3.41310,  -3.43168, 
     &  -3.48306,  -3.57513,  -3.59385,  -3.59684,  -3.60814/
      data cph2o(1201:1300)/
     &  -3.50612,  -3.41284,  -3.34107,  -3.27248,  -3.26950, 
     &  -3.31027,  -3.32205,  -3.29589,  -3.29768,  -3.28777, 
     &  -3.29950,  -3.39843,  -3.43784,  -3.47042,  -3.54250, 
     &  -3.55457,  -3.69278,  -3.82390,  -3.91709,  -4.02428, 
     &  -3.97802,  -4.04945,  -3.99837,  -3.96096,  -4.01515, 
     &  -4.01286,  -4.27890,  -4.64526,  -4.92520,  -5.20714, 
     &  -5.02961,  -4.88315,  -4.85584,  -4.76921,  -4.54440, 
     &  -4.33075,  -4.16671,  -4.04406,  -4.09564,  -4.11792, 
     &  -4.14522,  -4.19109,  -4.14906,  -4.22221,  -4.35301, 
     &  -4.47867,  -4.50537,  -4.41913,  -4.24856,  -4.05892, 
     &  -3.91396,  -3.73977,  -3.60042,  -3.52610,  -3.50040, 
     &  -3.55218,  -3.66025,  -3.77097,  -3.87835,  -3.96454, 
     &  -3.93046,  -3.92926,  -3.96805,  -3.99038,  -4.10179, 
     &  -4.21981,  -4.24013,  -4.26190,  -4.27753,  -4.25594, 
     &  -4.28500,  -4.29071,  -4.26155,  -4.16114,  -4.04160, 
     &  -3.91756,  -3.82524,  -3.76258,  -3.74207,  -3.77017, 
     &  -3.80666,  -3.92858,  -4.01356,  -4.10145,  -4.16708, 
     &  -4.09123,  -4.00345,  -3.88032,  -3.81171,  -3.80771, 
     &  -3.83212,  -3.88507,  -3.81399,  -3.70048,  -3.58376, 
     &  -3.46350,  -3.42785,  -3.41629,  -3.40329,  -3.36172/
      data cph2o(1301:1400)/
     &  -3.26599,  -3.16908,  -3.10954,  -3.03394,  -2.95828, 
     &  -2.85536,  -2.71469,  -2.60076,  -2.48946,  -2.38513, 
     &  -2.32220,  -2.30051,  -2.34186,  -2.37590,  -2.33267, 
     &  -2.21087,  -2.03216,  -1.91013,  -1.82328,  -1.77996, 
     &  -1.76714,  -1.72488,  -1.71325,  -1.67669,  -1.62963, 
     &  -1.60411,  -1.54027,  -1.47681,  -1.37155,  -1.25978, 
     &  -1.23494,  -1.26986,  -1.33751,  -1.37220,  -1.28322, 
     &  -1.14853,  -1.03021,  -0.89832,  -0.84340,  -0.83317, 
     &  -0.78856,  -0.76905,  -0.69209,  -0.53147,  -0.37401, 
     &  -0.25508,  -0.21755,  -0.22627,  -0.23936,  -0.22223, 
     &  -0.17345,  -0.11880,  -0.10331,  -0.15444,  -0.20353, 
     &  -0.25350,  -0.26628,  -0.13441,   0.02358,   0.13657, 
     &   0.22032,   0.19637,   0.12621,   0.07999,   0.04393, 
     &  -0.01900,  -0.06543,  -0.08129,  -0.14847,  -0.17765, 
     &  -0.23113,  -0.29309,  -0.28723,  -0.27521,  -0.20013, 
     &  -0.11575,  -0.00428,   0.10976,   0.16530,   0.18309, 
     &   0.13200,   0.10610,   0.10394,   0.13621,   0.17117, 
     &   0.17251,   0.18671,   0.16161,   0.16640,   0.18417, 
     &   0.18573,   0.24876,   0.26103,   0.28476,   0.33612, 
     &   0.30642,   0.30150,   0.27173,   0.21976,   0.23130/
      data cph2o(1401:1500)/
     &   0.27376,   0.30887,   0.34334,   0.34765,   0.31180, 
     &   0.30774,   0.31256,   0.35423,   0.42454,   0.44493, 
     &   0.43846,   0.44507,   0.43684,   0.49327,   0.53868, 
     &   0.51933,   0.54592,   0.54951,   0.63201,   0.74737, 
     &   0.80266,   0.88719,   0.87874,   0.84412,   0.84352, 
     &   0.81737,   0.86380,   0.94765,   0.95553,   0.93965, 
     &   0.90241,   0.91481,   1.00917,   1.11552,   1.15202, 
     &   1.06885,   0.96737,   0.85164,   0.80701,   0.82571, 
     &   0.87391,   0.98520,   1.07042,   1.18051,   1.29004, 
     &   1.37755,   1.48278,   1.47663,   1.40851,   1.27508, 
     &   1.11986,   0.98454,   0.88260,   0.82338,   0.79509, 
     &   0.83355,   0.91046,   1.04503,   1.21868,   1.36672, 
     &   1.46155,   1.47085,   1.46520,   1.42619,   1.37940, 
     &   1.41333,   1.43128,   1.45974,   1.54526,   1.53032, 
     &   1.48103,   1.39624,   1.26267,   1.17261,   1.09232, 
     &   1.05888,   1.01929,   0.94626,   0.87615,   0.73334, 
     &   0.61962,   0.52576,   0.40124,   0.32424,   0.20042, 
     &   0.05769,  -0.09325,  -0.27407,  -0.40779,  -0.52559, 
     &  -0.58490,  -0.57916,  -0.54457,  -0.50743,  -0.45937, 
     &  -0.41861,  -0.41520,  -0.39164,  -0.36510,  -0.30857/
      data cph2o(1501:1600)/
     &  -0.23157,  -0.18280,  -0.15878,  -0.21295,  -0.29332, 
     &  -0.39457,  -0.54826,  -0.71006,  -0.87700,  -0.96819, 
     &  -0.98703,  -0.93748,  -0.83916,  -0.78698,  -0.76209, 
     &  -0.80754,  -0.93347,  -1.06076,  -1.15801,  -1.16256, 
     &  -1.09618,  -1.03195,  -1.05522,  -1.13586,  -1.23387, 
     &  -1.33214,  -1.32682,  -1.33648,  -1.38038,  -1.42553, 
     &  -1.49769,  -1.52950,  -1.54445,  -1.56745,  -1.61707, 
     &  -1.69148,  -1.76787,  -1.82556,  -1.84347,  -1.86221, 
     &  -1.87097,  -1.84614,  -1.88659,  -1.98535,  -2.12108, 
     &  -2.27740,  -2.39335,  -2.39886,  -2.33846,  -2.30442, 
     &  -2.27409,  -2.29854,  -2.39124,  -2.56427,  -2.73609, 
     &  -2.88840,  -3.00443,  -3.02685,  -3.09379,  -3.16003, 
     &  -3.13090,  -3.06189,  -3.00807,  -2.95169,  -3.01568, 
     &  -3.11918,  -3.18931,  -3.35446,  -3.46712,  -3.51002, 
     &  -3.48618,  -3.36603,  -3.29278,  -3.32935,  -3.47177, 
     &  -3.61763,  -3.68930,  -3.67420,  -3.62078,  -3.67644, 
     &  -3.76717,  -3.78944,  -3.79818,  -3.75336,  -3.74321, 
     &  -3.86778,  -3.96899,  -4.05004,  -4.15451,  -4.17979, 
     &  -4.22704,  -4.28851,  -4.25560,  -4.21920,  -4.27564, 
     &  -4.42921,  -4.58506,  -4.70967,  -4.80136,  -4.64650/
      data cph2o(1601:1700)/
     &  -4.65341,  -4.51995,  -4.42433,  -4.42137,  -4.44853, 
     &  -4.44819,  -4.49132,  -4.49176,  -4.52929,  -4.58468, 
     &  -4.60533,  -4.62362,  -4.60168,  -4.59803,  -4.45292, 
     &  -4.26920,  -4.09891,  -3.92615,  -3.86016,  -3.69436, 
     &  -3.53699,  -3.38584,  -3.23356,  -3.19281,  -3.14232, 
     &  -3.11326,  -3.04386,  -2.90514,  -2.80270,  -2.68808, 
     &  -2.62726,  -2.61349,  -2.57111,  -2.54465,  -2.47142, 
     &  -2.42795,  -2.40936,  -2.37936,  -2.41255,  -2.40417, 
     &  -2.41017,  -2.39774,  -2.33861,  -2.23985,  -2.08388, 
     &  -2.00350,  -1.93767,  -1.91020,  -1.92815,  -1.89802, 
     &  -1.85648,  -1.84229,  -1.86062,  -1.89799,  -1.95863, 
     &  -2.01858,  -2.05596,  -2.06508,  -2.02824,  -1.93392, 
     &  -1.83965,  -1.74890,  -1.71252,  -1.72275,  -1.71193, 
     &  -1.68781,  -1.66945,  -1.64316,  -1.63675,  -1.69286, 
     &  -1.70297,  -1.72751,  -1.75100,  -1.73714,  -1.79804, 
     &  -1.84371,  -1.86235,  -1.88812,  -1.83704,  -1.77649, 
     &  -1.70661,  -1.60188,  -1.50341,  -1.43505,  -1.46076, 
     &  -1.51651,  -1.57911,  -1.61619,  -1.55812,  -1.49706, 
     &  -1.45230,  -1.42832,  -1.44314,  -1.52138,  -1.60752, 
     &  -1.62106,  -1.64265,  -1.64250,  -1.64573,  -1.74951/
      data cph2o(1701:1800)/
     &  -1.80667,  -1.76036,  -1.68790,  -1.57515,  -1.53228, 
     &  -1.57292,  -1.61350,  -1.65583,  -1.63563,  -1.58694, 
     &  -1.56417,  -1.53128,  -1.54079,  -1.55014,  -1.53022, 
     &  -1.53190,  -1.50230,  -1.50260,  -1.49991,  -1.45992, 
     &  -1.41944,  -1.31703,  -1.21850,  -1.14990,  -1.08809, 
     &  -1.04748,  -1.01748,  -0.95109,  -0.84680,  -0.74538, 
     &  -0.60472,  -0.50362,  -0.46372,  -0.42447,  -0.44838, 
     &  -0.44419,  -0.40683,  -0.38084,  -0.33053,  -0.32846, 
     &  -0.33572,  -0.31158,  -0.29906,  -0.20305,  -0.13083, 
     &  -0.09973,  -0.06963,  -0.12740,  -0.20199,  -0.29978, 
     &  -0.35896,  -0.38843,  -0.41730,  -0.45017,  -0.51507, 
     &  -0.56213,  -0.57297,  -0.50844,  -0.42276,  -0.29372, 
     &  -0.08843,   0.09240,   0.25840,   0.28311,   0.13891, 
     &  -0.06768,  -0.28207,  -0.39760,  -0.40444,  -0.31138, 
     &  -0.14305,  -0.02128,   0.04782,   0.08894,   0.10200, 
     &   0.09648,   0.10814,   0.09787,   0.04275,   0.07559, 
     &   0.12150,   0.14186,   0.19034,   0.13856,   0.07934, 
     &   0.05903,  -0.00117,  -0.04140,  -0.11747,  -0.21938, 
     &  -0.28241,  -0.37335,  -0.49225,  -0.58631,  -0.68229, 
     &  -0.75086,  -0.77623,  -0.84652,  -0.93691,  -1.00829/
      data cph2o(1801:1900)/
     &  -1.07836,  -1.10936,  -1.10990,  -1.10672,  -1.07623, 
     &  -1.03447,  -1.01613,  -1.00369,  -0.99511,  -1.06778, 
     &  -1.12221,  -1.14258,  -1.19379,  -1.17257,  -1.15262, 
     &  -1.17033,  -1.16389,  -1.14503,  -1.13643,  -1.12323, 
     &  -1.19203,  -1.33003,  -1.47540,  -1.65339,  -1.68424, 
     &  -1.66968,  -1.67118,  -1.61782,  -1.65910,  -1.73337, 
     &  -1.81449,  -1.93135,  -2.03554,  -2.03827,  -1.99609, 
     &  -2.00710,  -2.03895,  -2.19678,  -2.30931,  -2.30301, 
     &  -2.23226,  -2.07787,  -2.03277,  -2.03851,  -2.10514, 
     &  -2.23452,  -2.33474,  -2.44465,  -2.43944,  -2.37675, 
     &  -2.35973,  -2.37611,  -2.48915,  -2.59681,  -2.62562, 
     &  -2.61907,  -2.61274,  -2.73225,  -2.84636,  -2.91882, 
     &  -2.95084,  -2.84617,  -2.83687,  -2.84531,  -2.82928, 
     &  -2.88406,  -2.93621,  -3.00526,  -3.09956,  -3.16051, 
     &  -3.18338,  -3.25056,  -3.38003,  -3.56102,  -3.72396, 
     &  -3.80811,  -3.82369,  -3.79760,  -3.90921,  -4.04910, 
     &  -4.14132,  -4.22416,  -4.16634,  -4.21193,  -4.37375, 
     &  -4.54004,  -4.54848,  -4.34009,  -4.10097,  -3.93945, 
     &  -3.99014,  -4.18155,  -4.46321,  -4.84035,  -4.95672, 
     &  -4.88529,  -4.92967,  -5.09480,  -5.27981,  -5.39165/
      data cph2o(1901:2000)/
     &  -5.32774,  -5.16805,  -5.26308,  -5.53619,  -5.93153, 
     &  -6.48485,  -6.38350,  -6.02883,  -5.76237,  -5.65535, 
     &  -5.58220,  -5.58090,  -5.69939,  -5.87562,  -6.23761, 
     &  -6.45380,  -6.50710,  -6.40861,  -6.18069,  -6.15034, 
     &  -6.12957,  -6.08168,  -6.05912,  -6.20029,  -6.35916, 
     &  -6.63834,  -7.22799,  -6.87579,  -6.38557,  -6.05701, 
     &  -5.77145,  -5.71889,  -5.54063,  -5.34887,  -5.20440, 
     &  -5.01687,  -4.88229,  -4.75732,  -4.61829,  -4.47540, 
     &  -4.40382,  -4.22901,  -4.07893,  -3.91067,  -3.71540, 
     &  -3.66982,  -3.60413,  -3.59635,  -3.66139,  -3.67630, 
     &  -3.61574,  -3.49060,  -3.33033,  -3.18950,  -3.19004, 
     &  -3.27293,  -3.43811,  -3.58539,  -3.69658,  -3.64411, 
     &  -3.52966,  -3.51758,  -3.45900,  -3.56858,  -3.67516, 
     &  -3.75396,  -3.80574,  -3.77074,  -3.74231,  -3.63809, 
     &  -3.64323,  -3.59911,  -3.62673,  -3.64385,  -3.54801, 
     &  -3.49160,  -3.38461,  -3.33358,  -3.21719,  -3.04173, 
     &  -2.89493,  -2.77334,  -2.79171,  -2.91085,  -3.04844, 
     &  -3.23627,  -3.31742,  -3.35484,  -3.39756,  -3.34285, 
     &  -3.36017,  -3.34117,  -3.26031,  -3.20256,  -3.07615, 
     &  -2.98533,  -3.01199,  -3.13943,  -3.33780,  -3.54162/
      data cph2o(2001:2100)/
     &  -3.64413,  -3.59251,  -3.59490,  -3.60162,  -3.66139, 
     &  -3.81236,  -3.87304,  -4.04749,  -4.11623,  -4.09447, 
     &  -4.12708,  -3.91916,  -3.77960,  -3.62012,  -3.44890, 
     &  -3.42739,  -3.42156,  -3.36932,  -3.34675,  -3.22941, 
     &  -3.12258,  -3.12447,  -3.07216,  -3.06608,  -3.04637, 
     &  -2.99581,  -3.00597,  -2.94524,  -2.83430,  -2.69244, 
     &  -2.53460,  -2.44553,  -2.36211,  -2.25128,  -2.12504, 
     &  -1.99329,  -1.94694,  -1.96858,  -2.02552,  -2.02890, 
     &  -1.95458,  -1.83064,  -1.68469,  -1.63148,  -1.63055, 
     &  -1.64868,  -1.68433,  -1.65098,  -1.54445,  -1.45543, 
     &  -1.39405,  -1.35500,  -1.38974,  -1.43708,  -1.49729, 
     &  -1.58141,  -1.63709,  -1.71988,  -1.74834,  -1.78729, 
     &  -1.81439,  -1.79445,  -1.80727,  -1.78446,  -1.77116, 
     &  -1.69515,  -1.57106,  -1.41358,  -1.22505,  -1.11749, 
     &  -1.06719,  -1.05722,  -1.05923,  -1.08022,  -1.08249, 
     &  -1.05940,  -1.05527,  -0.97884,  -0.90009,  -0.86984, 
     &  -0.84202,  -0.84891,  -0.86571,  -0.87771,  -0.86436, 
     &  -0.89675,  -0.95811,  -0.95681,  -0.98685,  -0.91920, 
     &  -0.79481,  -0.73405,  -0.63486,  -0.61580,  -0.66083, 
     &  -0.69059,  -0.75323,  -0.74477,  -0.65052,  -0.58475/
      data cph2o(2101:2200)/
     &  -0.56151,  -0.61494,  -0.70313,  -0.70147,  -0.64776, 
     &  -0.57626,  -0.52669,  -0.56405,  -0.57813,  -0.57452, 
     &  -0.57656,  -0.52371,  -0.48121,  -0.47066,  -0.44204, 
     &  -0.42321,  -0.43939,  -0.40019,  -0.34592,  -0.36666, 
     &  -0.36117,  -0.41494,  -0.53334,  -0.63311,  -0.73668, 
     &  -0.83196,  -0.91543,  -0.92801,  -0.91893,  -0.82619, 
     &  -0.64369,  -0.45814,  -0.28838,  -0.20295,  -0.12845, 
     &  -0.12789,  -0.14668,  -0.10804,  -0.12206,  -0.08664, 
     &  -0.05495,  -0.09929,  -0.16477,  -0.24481,  -0.32305, 
     &  -0.39276,  -0.44000,  -0.52873,  -0.60139,  -0.69141, 
     &  -0.79857,  -0.89923,  -1.00968,  -1.08832,  -1.14958, 
     &  -1.21303,  -1.28067,  -1.38492,  -1.47822,  -1.51729, 
     &  -1.55518,  -1.53633,  -1.51062,  -1.50327,  -1.51801, 
     &  -1.57645,  -1.65941,  -1.73134,  -1.75165,  -1.72655, 
     &  -1.71606,  -1.73263,  -1.74728,  -1.79286,  -1.73848, 
     &  -1.66180,  -1.56283,  -1.40366,  -1.32738,  -1.25309, 
     &  -1.25065,  -1.26987,  -1.24009,  -1.22822,  -1.19404, 
     &  -1.20867,  -1.23645,  -1.19332,  -1.13591,  -1.08205, 
     &  -1.04976,  -1.14128,  -1.23489,  -1.27858,  -1.33065, 
     &  -1.28360,  -1.22682,  -1.18706,  -1.15823,  -1.14067/
      data cph2o(2201:2300)/
     &  -1.16633,  -1.17506,  -1.15970,  -1.19126,  -1.19843, 
     &  -1.30385,  -1.42862,  -1.58004,  -1.72327,  -1.78743, 
     &  -1.86895,  -1.85190,  -1.80529,  -1.69422,  -1.49103, 
     &  -1.32529,  -1.20009,  -1.13762,  -1.11678,  -1.13199, 
     &  -1.16550,  -1.16402,  -1.17932,  -1.17405,  -1.15184, 
     &  -1.20924,  -1.29157,  -1.34831,  -1.38571,  -1.42632, 
     &  -1.43812,  -1.50800,  -1.62119,  -1.70590,  -1.86161, 
     &  -2.00714,  -2.11745,  -2.25960,  -2.34777,  -2.44254, 
     &  -2.64264,  -2.83979,  -3.04320,  -3.29364,  -3.41153, 
     &  -3.49359,  -3.60572,  -3.67873,  -3.78090,  -3.85398, 
     &  -3.88200,  -3.83753,  -3.77740,  -3.85401,  -3.79646, 
     &  -3.72746,  -3.70451,  -3.59083,  -3.70223,  -3.88363, 
     &  -4.03077,  -4.20725,  -4.19594,  -4.16725,  -4.13410, 
     &  -4.16791,  -4.12138,  -4.08875,  -4.14355,  -4.10163, 
     &  -4.19018,  -4.25695,  -4.31184,  -4.47906,  -4.51148, 
     &  -4.57929,  -4.59458,  -4.62081,  -4.83031,  -5.02522, 
     &  -5.15710,  -5.27403,  -5.22837,  -5.32058,  -5.55260, 
     &  -5.72630,  -5.86735,  -5.86402,  -5.84419,  -5.89720, 
     &  -6.15533,  -6.51283,  -6.98011,  -7.28495,  -7.08784, 
     &  -6.77605,  -6.49215,  -6.43947,  -6.42083,  -6.59354/
      data cph2o(2301:2400)/
     &  -6.78419,  -6.98883,  -7.11018,  -6.93420,  -6.83581, 
     &  -6.87136,  -6.96133,  -7.28561,  -8.27079,  -8.59451, 
     &  -9.45197,  -8.33631,  -8.21424,  -6.89777,  -6.27923, 
     &  -5.89945,  -5.66364,  -5.69459,  -5.87082,  -5.81185, 
     &  -5.70141,  -5.45890,  -5.24048,  -5.30703,  -5.32430, 
     &  -5.18694,  -5.03410,  -4.82279,  -4.72208,  -4.55097, 
     &  -4.36284,  -4.20326,  -4.04534,  -4.05883,  -4.01183, 
     &  -3.93857,  -3.83212,  -3.66113,  -3.56021,  -3.45969, 
     &  -3.38518,  -3.33373,  -3.32721,  -3.34771,  -3.35412, 
     &  -3.34584,  -3.22701,  -3.14293,  -3.09481,  -3.05706, 
     &  -3.13587,  -3.18156,  -3.26336,  -3.34559,  -3.38498, 
     &  -3.39054,  -3.33695,  -3.34959,  -3.36191,  -3.53258, 
     &  -3.66238,  -3.68946,  -3.69155,  -3.52990,  -3.48606, 
     &  -3.41160,  -3.34144,  -3.31933,  -3.26341,  -3.22609, 
     &  -3.18298,  -3.12800,  -3.02166,  -2.93903,  -2.84135, 
     &  -2.69864,  -2.63582,  -2.60853,  -2.59699,  -2.64799, 
     &  -2.71846,  -2.70856,  -2.67797,  -2.67978,  -2.58432, 
     &  -2.57052,  -2.57883,  -2.48977,  -2.47541,  -2.43446, 
     &  -2.39253,  -2.42823,  -2.44830,  -2.49704,  -2.54904, 
     &  -2.54865,  -2.51223,  -2.39407,  -2.28582,  -2.22341/
      data cph2o(2401:2500)/
     &  -2.18280,  -2.17308,  -2.15234,  -2.10486,  -2.08564, 
     &  -2.08578,  -2.09615,  -2.11136,  -2.10200,  -2.06832, 
     &  -2.04134,  -2.00194,  -1.95185,  -1.92025,  -1.85931, 
     &  -1.85988,  -1.91696,  -2.01129,  -2.15097,  -2.20539, 
     &  -2.21302,  -2.22309,  -2.24412,  -2.30471,  -2.33847, 
     &  -2.25445,  -2.08096,  -1.85098,  -1.61538,  -1.45841, 
     &  -1.42089,  -1.54484,  -1.74234,  -1.96839,  -2.18038, 
     &  -2.28394,  -2.31701,  -2.24125,  -2.05966,  -1.88694, 
     &  -1.78105,  -1.69960,  -1.64107,  -1.62909,  -1.58168, 
     &  -1.56599,  -1.59412,  -1.56739,  -1.56346,  -1.54456, 
     &  -1.55619,  -1.61000,  -1.67072,  -1.75312,  -1.82511, 
     &  -1.87588,  -1.89436,  -1.94377,  -1.96038,  -2.02291, 
     &  -2.14131,  -2.19637,  -2.27114,  -2.33418,  -2.36152, 
     &  -2.44688,  -2.53819,  -2.61011,  -2.69105,  -2.73774, 
     &  -2.76700,  -2.82031,  -2.85910,  -2.88525,  -2.95422, 
     &  -2.99210,  -3.06247,  -3.12280,  -3.12274,  -3.13972, 
     &  -3.09998,  -3.11771,  -3.10670,  -3.00116,  -2.91302, 
     &  -2.75838,  -2.66379,  -2.65726,  -2.62212,  -2.59431, 
     &  -2.55351,  -2.49874,  -2.47486,  -2.52563,  -2.54608, 
     &  -2.54311,  -2.54938,  -2.49038,  -2.49664,  -2.52688/
      data cph2o(2501:2600)/
     &  -2.58688,  -2.67000,  -2.71830,  -2.77113,  -2.80244, 
     &  -2.84845,  -2.87062,  -2.83368,  -2.69338,  -2.52225, 
     &  -2.40864,  -2.34429,  -2.40612,  -2.55941,  -2.73915, 
     &  -2.94409,  -3.12344,  -3.27308,  -3.32104,  -3.27077, 
     &  -3.13129,  -2.92504,  -2.78515,  -2.71007,  -2.66733, 
     &  -2.62518,  -2.62279,  -2.59906,  -2.56745,  -2.59548, 
     &  -2.53657,  -2.50849,  -2.47640,  -2.46021,  -2.53747, 
     &  -2.62220,  -2.76449,  -2.88041,  -2.96357,  -3.02153, 
     &  -3.06178,  -3.14581,  -3.25318,  -3.44687,  -3.69634, 
     &  -3.90497,  -4.09399,  -4.22346,  -4.29749,  -4.51957, 
     &  -4.79572,  -5.03708,  -5.27140,  -5.34657,  -5.44757, 
     &  -5.52207,  -5.57087,  -5.64385,  -5.80294,  -5.90763, 
     &  -5.94797,  -5.85439,  -5.62721,  -5.45121,  -5.40324, 
     &  -5.38540,  -5.39409,  -5.59404,  -5.69955,  -5.76877, 
     &  -5.86764,  -5.78129,  -5.88887,  -6.12206,  -6.37505, 
     &  -6.85575,  -7.13884,  -6.98622,  -6.96112,  -6.84830, 
     &  -6.72456,  -6.67530,  -6.65251,  -6.66033,  -6.88151, 
     &  -7.11199,  -7.33922,  -7.61766,  -7.66585,  -7.87464, 
     &  -8.59519,  -9.04047,  -9.30602,  -9.51273,  -8.93688, 
     &  -9.43151,  -8.84005, -10.00000,  -9.65151,  -8.98420/
      data cph2o(2601:2700)/
     & -10.00000,  -9.43151,  -9.68331, -10.00000,  -9.43067, 
     &  -9.90527, -10.00000,  -9.98810,  -9.65151,  -9.74384, 
     &  -9.20004, -10.00000,  -9.20004, -10.00000, -10.00000, 
     &  -9.85239,  -8.09585,  -7.66916,  -7.89183,  -8.46587, 
     &  -8.79342,  -8.93440,  -8.68356,  -8.83423,  -8.01626, 
     &  -7.91911,  -8.27604,  -9.44864,  -9.69462, -10.00000, 
     &  -9.69462,  -8.31857,  -7.91867,  -7.86404,  -8.32240, 
     &  -8.68705,  -9.61515,  -9.25284,  -8.68705,  -8.28789, 
     &  -7.63730,  -8.25919, -10.00000,  -9.51758, -10.00000, 
     & -10.00000,  -9.51758,  -8.05261,  -7.76848,  -8.24255, 
     &  -9.34171,  -9.19941,  -8.56505,  -7.78955,  -7.23750, 
     &  -6.64136,  -6.41854,  -6.14335,  -5.86704,  -5.70840, 
     &  -5.48179,  -5.23814,  -5.00650,  -4.80407,  -4.69986, 
     &  -4.70404,  -4.80846,  -4.99355,  -5.19947,  -5.33300, 
     &  -5.30550,  -5.17017,  -5.05309,  -4.95685,  -4.79959, 
     &  -4.65496,  -4.54077,  -4.44407,  -4.43768,  -4.47167, 
     &  -4.40429,  -4.30236,  -4.22549,  -4.15283,  -4.06900, 
     &  -3.99244,  -3.87562,  -3.76949,  -3.78198,  -3.77003, 
     &  -3.67364,  -3.52061,  -3.34459,  -3.20426,  -3.15993, 
     &  -3.13851,  -3.09692,  -3.07747,  -3.02936,  -3.02192/
      data cph2o(2701:2800)/
     &  -2.96720,  -2.90584,  -2.79069,  -2.65042,  -2.62072, 
     &  -2.53133,  -2.50554,  -2.48745,  -2.41611,  -2.43532, 
     &  -2.40913,  -2.38723,  -2.33337,  -2.21812,  -2.15072, 
     &  -2.08313,  -2.06151,  -2.10585,  -2.13670,  -2.18757, 
     &  -2.23995,  -2.26992,  -2.34229,  -2.38059,  -2.38087, 
     &  -2.33246,  -2.21618,  -2.14795,  -2.12707,  -2.09130, 
     &  -2.05043,  -1.95550,  -1.77077,  -1.66044,  -1.58224, 
     &  -1.51702,  -1.54004,  -1.54074,  -1.53712,  -1.54938, 
     &  -1.52352,  -1.49404,  -1.51985,  -1.57774,  -1.64393, 
     &  -1.65332,  -1.56238,  -1.45105,  -1.39264,  -1.40635, 
     &  -1.46167,  -1.50365,  -1.47751,  -1.47268,  -1.45992, 
     &  -1.46654,  -1.50223,  -1.47576,  -1.47730,  -1.46977, 
     &  -1.45630,  -1.44490,  -1.43097,  -1.43664,  -1.49313, 
     &  -1.63372,  -1.81848,  -1.97938,  -2.06009,  -2.10124, 
     &  -2.02376,  -1.95095,  -1.86835,  -1.70161,  -1.54835, 
     &  -1.37614,  -1.25130,  -1.17408,  -1.17670,  -1.19790, 
     &  -1.21344,  -1.27252,  -1.28030,  -1.31031,  -1.34321, 
     &  -1.34056,  -1.35264,  -1.38137,  -1.44648,  -1.56735, 
     &  -1.72096,  -1.88960,  -2.06793,  -2.19583,  -2.29229, 
     &  -2.34400,  -2.34120,  -2.36407,  -2.39688,  -2.45450/
      data cph2o(2801:2900)/
     &  -2.53132,  -2.58327,  -2.60585,  -2.60773,  -2.60606, 
     &  -2.64243,  -2.71853,  -2.78182,  -2.84459,  -2.83665, 
     &  -2.78522,  -2.71157,  -2.61628,  -2.53314,  -2.45692, 
     &  -2.41679,  -2.41535,  -2.45500,  -2.51120,  -2.57918, 
     &  -2.62854,  -2.63617,  -2.61204,  -2.53833,  -2.43992, 
     &  -2.37490,  -2.34880,  -2.34476,  -2.36650,  -2.36553, 
     &  -2.34094,  -2.33633,  -2.30483,  -2.26933,  -2.25141, 
     &  -2.22841,  -2.27610,  -2.33673,  -2.37913,  -2.44271, 
     &  -2.48571,  -2.57146,  -2.64200,  -2.61103,  -2.47198, 
     &  -2.27897,  -2.15874,  -2.06557,  -2.05371,  -2.06333, 
     &  -2.04641,  -2.04429,  -2.01040,  -2.00804,  -1.99416, 
     &  -2.05499,  -2.09948,  -2.09706,  -2.10517,  -2.01267, 
     &  -1.99934,  -2.03719,  -2.12114,  -2.29537,  -2.44295, 
     &  -2.55926,  -2.66007,  -2.73808,  -2.75972,  -2.78032, 
     &  -2.67031,  -2.44995,  -2.27133,  -2.11654,  -2.02598, 
     &  -2.01402,  -2.04264,  -2.04511,  -2.02975,  -2.00687, 
     &  -1.94840,  -1.93975,  -1.97104,  -2.01554,  -2.09336, 
     &  -2.15829,  -2.26705,  -2.40356,  -2.55216,  -2.78858, 
     &  -3.00697,  -3.22778,  -3.44413,  -3.55439,  -3.66412, 
     &  -3.73884,  -3.92224,  -4.18922,  -4.41150,  -4.55122/
      data cph2o(2901:3000)/
     &  -4.48637,  -4.29339,  -4.19248,  -4.28419,  -4.41178, 
     &  -4.60369,  -4.81645,  -4.83716,  -4.93818,  -4.87772, 
     &  -4.65255,  -4.40133,  -4.14378,  -4.05431,  -4.02425, 
     &  -4.04257,  -4.11794,  -4.12153,  -4.16374,  -4.17459, 
     &  -4.10274,  -4.04733,  -4.00176,  -4.01760,  -4.13393, 
     &  -4.29085,  -4.38409,  -4.39975,  -4.33916,  -4.31515, 
     &  -4.35426,  -4.44628,  -4.51842,  -4.52596,  -4.53399, 
     &  -4.54590,  -4.63864,  -4.75657,  -4.86504,  -4.95580, 
     &  -5.03365,  -5.14879,  -5.33868,  -5.62972,  -5.92584, 
     &  -6.30299,  -6.62922,  -6.70773,  -6.97810,  -7.35919, 
     &  -7.64909,  -8.62765,  -8.55378,  -7.76305,  -7.47054, 
     &  -7.07789,  -7.11538,  -7.34052,  -7.75694,  -9.17126, 
     & -10.00000,  -9.86547,  -8.71424,  -8.66552,  -8.31602, 
     &  -8.41339,  -7.92192,  -8.66385,  -8.99856,  -9.65437, 
     &  -9.36822,  -9.46517,  -9.43986,  -8.65941, -10.00000, 
     & -10.00000,  -8.82641,  -8.56244,  -7.93689,  -7.68823, 
     &  -7.55818,  -7.05113,  -6.76446,  -6.49313,  -6.24749, 
     &  -6.12617,  -6.05220,  -6.13798,  -6.07909,  -5.86845, 
     &  -5.69141,  -5.50496,  -5.48376,  -5.56108,  -5.42768, 
     &  -5.29615,  -5.10664,  -4.88111,  -4.78669,  -4.62385/
      data cph2o(3001:3100)/
     &  -4.52174,  -4.49073,  -4.45792,  -4.54129,  -4.54480, 
     &  -4.51341,  -4.47258,  -4.27643,  -4.18091,  -4.09557, 
     &  -4.04222,  -4.11247,  -4.14851,  -4.16970,  -4.11065, 
     &  -4.04809,  -4.00745,  -3.99879,  -4.07978,  -4.12451, 
     &  -4.19723,  -4.17393,  -4.09022,  -4.02101,  -3.87998, 
     &  -3.79109,  -3.66411,  -3.50066,  -3.40580,  -3.32713, 
     &  -3.30194,  -3.35131,  -3.35137,  -3.29933,  -3.20658, 
     &  -3.06263,  -2.97995,  -2.98759,  -2.99176,  -3.00756, 
     &  -2.97359,  -2.85849,  -2.81640,  -2.77094,  -2.75469, 
     &  -2.77297,  -2.71165,  -2.69187,  -2.64524,  -2.60542, 
     &  -2.60059,  -2.57842,  -2.59991,  -2.58577,  -2.60792, 
     &  -2.66006,  -2.70803,  -2.79094,  -2.81048,  -2.79532, 
     &  -2.79499,  -2.84578,  -2.90638,  -2.96270,  -2.90633, 
     &  -2.71535,  -2.54313,  -2.37822,  -2.31125,  -2.35246, 
     &  -2.49011,  -2.68215,  -2.83136,  -2.96357,  -2.95873, 
     &  -2.90544,  -2.84387,  -2.70352,  -2.58329,  -2.49207, 
     &  -2.41735,  -2.35522,  -2.30279,  -2.25786,  -2.22067, 
     &  -2.20741,  -2.19735,  -2.20181,  -2.22358,  -2.27247, 
     &  -2.33737,  -2.39631,  -2.45029,  -2.49867,  -2.56939, 
     &  -2.64313,  -2.77129,  -2.92580,  -3.05513,  -3.23728/
      data cph2o(3101:3200)/
     &  -3.31415,  -3.33588,  -3.39544,  -3.43947,  -3.57455, 
     &  -3.69955,  -3.77227,  -3.76260,  -3.70753,  -3.70942, 
     &  -3.73899,  -3.82827,  -3.93052,  -4.10437,  -4.24931, 
     &  -4.35000,  -4.42069,  -4.25644,  -4.21454,  -4.17061, 
     &  -4.11168,  -4.16038,  -4.16686,  -4.19465,  -4.23251, 
     &  -4.27305,  -4.21672,  -4.13963,  -4.07622,  -3.97332, 
     &  -3.96263,  -3.95541,  -3.97392,  -4.03776,  -4.07778, 
     &  -4.01771,  -3.87070,  -3.70710,  -3.59495,  -3.62243, 
     &  -3.69528,  -3.76171,  -3.76582,  -3.65793,  -3.61555, 
     &  -3.59708,  -3.63113,  -3.63691,  -3.57465,  -3.55435, 
     &  -3.47507,  -3.49075,  -3.53253,  -3.57495,  -3.68837, 
     &  -3.68628,  -3.68771,  -3.64979,  -3.60831,  -3.56633, 
     &  -3.48250,  -3.37856,  -3.22908,  -3.14286,  -3.11346, 
     &  -3.13691,  -3.26625,  -3.44333,  -3.64611,  -3.86925, 
     &  -4.08285,  -4.22794,  -4.25115,  -4.14282,  -3.85944, 
     &  -3.59027,  -3.43514,  -3.31856,  -3.24442,  -3.22555, 
     &  -3.18795,  -3.20363,  -3.30589,  -3.41248,  -3.60718, 
     &  -3.70563,  -3.65431,  -3.57332,  -3.47347,  -3.47521, 
     &  -3.53388,  -3.72003,  -3.97569,  -4.31048,  -4.87330, 
     &  -5.39648,  -6.27322,  -8.18185,  -8.07588,  -8.20933/
      data cph2o(3201:3300)/
     &  -8.60643,  -8.83713,  -9.01727,  -9.15690,  -9.41970, 
     &  -9.51520,  -9.63843,  -9.87539,  -9.94314, -10.00000, 
     & -10.00000,  -9.99542,  -9.97748,  -9.94374,  -9.93287, 
     &  -9.90450,  -9.85082,  -9.82140,  -9.73549,  -9.64536, 
     &  -9.59412,  -9.54635,  -9.26735,  -9.23243,  -9.05763, 
     &  -8.93240,  -8.74549,  -8.52992,  -8.25637,  -8.13836, 
     &  -7.66071,  -7.35897,  -7.37375,  -7.09925,  -6.98326, 
     &  -6.89298,  -6.79545,  -6.97172,  -6.67558,  -6.37369, 
     &  -6.21189,  -5.94606,  -5.84975,  -5.83536,  -5.82878, 
     &  -5.78456,  -5.68334,  -5.44809,  -5.28421,  -5.06970, 
     &  -4.89514,  -4.80192,  -4.73588,  -4.78558,  -4.78127, 
     &  -4.73462,  -4.54889,  -4.33093,  -4.18543,  -4.09190, 
     &  -4.11204,  -4.13402,  -4.13401,  -3.97210,  -3.79621, 
     &  -3.65860,  -3.55511,  -3.57549,  -3.57633,  -3.53833, 
     &  -3.46143,  -3.34082,  -3.23729,  -3.17300,  -3.14437, 
     &  -3.10547,  -3.05061,  -2.96941,  -2.86694,  -2.79500, 
     &  -2.75350,  -2.75307,  -2.77146,  -2.79530,  -2.76451, 
     &  -2.68758,  -2.63931,  -2.57797,  -2.58894,  -2.59717, 
     &  -2.52817,  -2.47282,  -2.42360,  -2.45382,  -2.56145, 
     &  -2.61304,  -2.59963,  -2.52689,  -2.46472,  -2.46461/
      data cph2o(3301:3400)/
     &  -2.45407,  -2.39432,  -2.25523,  -2.14408,  -2.05525, 
     &  -2.01888,  -2.07413,  -2.12889,  -2.25990,  -2.39692, 
     &  -2.48925,  -2.54855,  -2.53415,  -2.54460,  -2.50455, 
     &  -2.46921,  -2.42259,  -2.28066,  -2.22625,  -2.17393, 
     &  -2.13289,  -2.19687,  -2.21326,  -2.23949,  -2.27620, 
     &  -2.26819,  -2.29009,  -2.29281,  -2.25201,  -2.17355, 
     &  -2.07947,  -2.03121,  -2.01967,  -2.04954,  -2.08143, 
     &  -2.06833,  -2.05240,  -2.05599,  -2.06967,  -2.12334, 
     &  -2.21510,  -2.29897,  -2.40035,  -2.52428,  -2.62702, 
     &  -2.73003,  -2.87671,  -2.99894,  -3.10548,  -3.25316, 
     &  -3.32982,  -3.39709,  -3.53992,  -3.63406,  -3.74020, 
     &  -3.92706,  -3.96893,  -3.93910,  -3.93559,  -3.82934, 
     &  -3.82006,  -3.87551,  -3.89939,  -3.94509,  -3.95617, 
     &  -3.96332,  -3.96114,  -3.99122,  -4.01273,  -4.01717, 
     &  -4.02888,  -4.04697,  -4.10112,  -4.14864,  -4.27169, 
     &  -4.32135,  -4.33175,  -4.41165,  -4.36331,  -4.39914, 
     &  -4.42505,  -4.40381,  -4.48901,  -4.44885,  -4.38473, 
     &  -4.32458,  -4.19760,  -4.16511,  -4.15683,  -4.14102, 
     &  -4.11365,  -4.10673,  -4.13026,  -4.13652,  -4.19636, 
     &  -4.19684,  -4.14832,  -4.05676,  -3.96205,  -3.90165/
      data cph2o(3401:3500)/
     &  -3.84404,  -3.86524,  -3.83773,  -3.69609,  -3.55481, 
     &  -3.42043,  -3.33841,  -3.37637,  -3.44611,  -3.49193, 
     &  -3.52932,  -3.44601,  -3.36757,  -3.31227,  -3.23777, 
     &  -3.21254,  -3.19842,  -3.22310,  -3.28352,  -3.27914, 
     &  -3.23481,  -3.12437,  -3.04729,  -3.06777,  -3.09818, 
     &  -3.19530,  -3.24569,  -3.24974,  -3.30729,  -3.27728, 
     &  -3.25317,  -3.22055,  -3.15996,  -3.17334,  -3.17694, 
     &  -3.12288,  -3.04593,  -2.99049,  -2.98361,  -3.06492, 
     &  -3.19818,  -3.31628,  -3.42190,  -3.47775,  -3.55095, 
     &  -3.56669,  -3.53409,  -3.38883,  -3.17115,  -3.00955, 
     &  -2.89158,  -2.83770,  -2.86055,  -2.86096,  -2.83436, 
     &  -2.82886,  -2.78602,  -2.80289,  -2.85454,  -2.89629, 
     &  -2.99573,  -3.11206,  -3.27394,  -3.47183,  -3.64849, 
     &  -3.79741,  -3.91130,  -4.08705,  -4.24317,  -4.41275, 
     &  -4.55729,  -4.55082,  -4.66958,  -4.82149,  -4.94204, 
     &  -5.13772,  -5.22105,  -5.20710,  -5.18691,  -5.09729, 
     &  -5.03217,  -4.96344,  -4.97810,  -5.03506,  -5.05380, 
     &  -5.08007,  -5.10835,  -5.13285,  -5.24491,  -5.44530, 
     &  -5.65236,  -5.80563,  -5.75192,  -5.58691,  -5.38023, 
     &  -5.31721,  -5.30923,  -5.34087,  -5.39044,  -5.38089/
      data cph2o(3501:3515)/
     &  -5.43438,  -5.52124,  -5.79590,  -6.25048,  -6.78272, 
     &  -8.29899,  -8.50913,  -8.77871,  -8.91512,  -9.13453, 
     &  -9.37455,  -9.56578,  -9.71290,  -9.89385, -10.00000/

c --- double exponential fit parameters for o3   

      data cpo3(1:100)/
     &  -2.04270,  -1.89660,  -1.62630,  -1.38960,  -1.21700, 
     &  -1.09960,  -1.02140,  -0.96730,  -0.92490,  -0.88960, 
     &  -0.86120,  -0.84170,  -0.83600,  -0.84830,  -0.87850, 
     &  -0.92730,  -0.99320,  -1.07200,  -1.16390,  -1.26620, 
     &  -1.37710,  -1.49760,  -1.62740,  -1.77120,  -1.92890, 
     &  -2.10270,  -2.29480,  -2.49870,  -2.73210,  -2.99920, 
     &  -3.30450,  -3.69940,  -4.10220,  -4.64670,  -5.13280, 
     &  -5.64810,  -6.16340,  -6.67870,  -7.19400,  -7.70930, 
     &  -8.00000,  -7.92740,  -7.64180,  -7.35620,  -7.07060, 
     &  -6.78500,  -6.49940,  -6.21380,  -5.92820,  -5.64260, 
     &  -5.35700,  -5.07140,  -4.78580,  -4.50020,  -4.21460, 
     &  -3.92900,  -3.62130,  -3.34070,  -3.07220,  -2.82260, 
     &  -2.59140,  -2.37780,  -2.18230,  -2.00570,  -1.84560, 
     &  -1.69910,  -1.56590,  -1.44360,  -1.33230,  -1.23190, 
     &  -1.14070,  -1.05500,  -0.97330,  -0.90330,  -0.85840, 
     &  -0.85270,  -0.88380,  -0.92190,  -0.93600,  -0.90250, 
     &  -0.84020,  -0.79130,  -0.77940,  -0.81230,  -0.87500, 
     &  -0.94840,  -1.02060,  -1.08640,  -1.15200,  -1.22020, 
     &  -1.29280,  -1.37450,  -1.46410,  -1.56110,  -1.66690, 
     &  -1.78160,  -1.90510,  -2.03830,  -2.17960,  -2.33120/
      data cpo3(101:200)/
     &  -2.49060,  -2.65690,  -2.83540,  -3.01790,  -3.21210, 
     &  -3.41060,  -3.62080,  -3.83320,  -4.05840,  -4.28540, 
     &  -4.49790,  -4.71750,  -4.91090,  -5.12460,  -5.33440, 
     &  -5.54420,  -5.75400,  -5.96380,  -6.17360,  -6.38340, 
     &  -6.59320,  -6.80300,  -7.01280,  -6.90110,  -6.25900, 
     &  -5.81190,  -5.16030,  -4.33270,  -3.68490,  -3.12530, 
     &  -2.63040,  -2.19030,  -1.80190,  -1.45850,  -1.15330, 
     &  -0.87700,  -0.61660,  -0.36300,  -0.11020,   0.13360, 
     &   0.35250,   0.53260,   0.66780,   0.75100,   0.77520, 
     &   0.78260,   0.78740,   0.80060,   0.82410,   0.76140, 
     &   0.56620,   0.19490,  -0.27700,  -0.61990,  -0.83470, 
     &  -0.95860,  -1.01680,  -1.05010,  -1.08160,  -1.09800, 
     &  -1.08330,  -1.04240,  -0.99720,  -0.97240,  -0.98550, 
     &  -1.03650,  -1.11870,  -1.21500,  -1.31420,  -1.41030, 
     &  -1.49980,  -1.59330,  -1.69380,  -1.80610,  -1.93320, 
     &  -2.07370,  -2.22790,  -2.39660,  -2.57870,  -2.77550, 
     &  -2.98550,  -3.20900,  -3.44650,  -3.69670,  -3.96330, 
     &  -4.24610,  -4.55020,  -4.89120,  -5.28450,  -5.76540, 
     &  -6.41940,  -6.92880,  -7.43820,  -7.94760,  -8.00000, 
     &  -7.54320,  -6.92730,  -6.31150,  -5.54310,  -4.95630/
      data cpo3(201:300)/
     &  -4.46400,  -4.03710,  -3.65330,  -3.30690,  -2.98770, 
     &  -2.70420,  -2.45070,  -2.23550,  -2.06510,  -1.94770, 
     &  -1.87050,  -1.84220,  -1.82350,  -1.77820,  -1.73670, 
     &  -1.70120,  -1.72080,  -1.83530,  -2.03310,  -2.30770, 
     &  -2.59960,  -2.75170,  -2.72630,  -2.66710,  -2.64150, 
     &  -2.64490,  -2.66130,  -2.65890,  -2.60830,  -2.52500, 
     &  -2.45290,  -2.41570,  -2.42980,  -2.49060,  -2.58230, 
     &  -2.68730,  -2.78080,  -2.86120,  -2.93030,  -3.00220, 
     &  -3.08730,  -3.18440,  -3.29290,  -3.41580,  -3.53610, 
     &  -3.67100,  -3.80620,  -3.95200,  -4.11400,  -4.26350, 
     &  -4.43950,  -4.61380,  -4.83720,  -5.08370,  -5.33020, 
     &  -5.36650,  -5.43580,  -5.06510,  -4.84160,  -4.52930, 
     &  -4.25470,  -4.00390,  -3.78180,  -3.58500,  -3.40910, 
     &  -3.25090,  -3.09340,  -2.94850,  -2.80550,  -2.67050, 
     &  -2.54820,  -2.43620,  -2.33800,  -2.24860,  -2.16450, 
     &  -2.08340,  -2.00350,  -1.90810,  -1.76810,  -1.57680, 
     &  -1.36150,  -1.14630,  -0.94820,  -0.78000,  -0.63360, 
     &  -0.50920,  -0.41050,  -0.34950,  -0.32740,  -0.31330, 
     &  -0.30230,  -0.28590,  -0.30550,  -0.43740,  -0.69720, 
     &  -1.10640,  -1.49040,  -1.96870,  -2.44980,  -2.59710/
      data cpo3(301:400)/
     &  -2.52200,  -2.43010,  -2.34670,  -2.29010,  -2.27460, 
     &  -2.30210,  -2.36350,  -2.44200,  -2.50880,  -2.54850, 
     &  -2.56170,  -2.56560,  -2.57710,  -2.61340,  -2.68220, 
     &  -2.78850,  -2.93790,  -3.12000,  -3.32600,  -3.54640, 
     &  -3.77360,  -4.03110,  -4.36510,  -4.77940,  -5.51520, 
     &  -6.12400,  -7.21930,  -8.00000,  -7.97210,  -7.61180, 
     &  -7.25150,  -6.89130,  -6.53100,  -6.17070,  -5.81050, 
     &  -5.45020,  -5.08990,  -4.72970,  -4.36940,  -3.94620, 
     &  -3.60220,  -3.28860,  -3.02340,  -2.78630,  -2.57970, 
     &  -2.40730,  -2.27600,  -2.18940,  -2.13590,  -2.11600, 
     &  -2.08080,  -2.01510,  -1.96660,  -1.94090,  -1.98680, 
     &  -2.14500,  -2.39650,  -2.80420,  -3.55000,  -4.82750, 
     &  -5.63780,  -6.44820,  -7.25850,  -8.00000,  -8.00000, 
     &  -7.62780,  -7.25560,  -6.88340,  -6.51110,  -6.13890, 
     &  -5.76670,  -5.39450,  -5.02230,  -4.65010,  -4.27790, 
     &  -3.90560,  -3.53340,  -3.38280,  -3.24520,  -3.14110, 
     &  -3.04030,  -2.94280,  -2.84360,  -2.75730,  -2.68530, 
     &  -2.60400,  -2.52180,  -2.41210,  -2.35470,  -2.19700, 
     &  -2.06680,  -1.91210,  -1.76170,  -1.61530,  -1.46880, 
     &  -1.40220,  -1.34470,  -1.26690,  -1.19020,  -1.18050/
      data cpo3(401:447)/
     &  -1.17070,  -1.16090,  -1.16090,  -1.18050,  -1.19990, 
     &  -1.42140,  -1.63480,  -1.75190,  -1.97300,  -2.20780, 
     &  -2.46080,  -2.53370,  -2.59230,  -2.66160,  -2.63840, 
     &  -2.62710,  -2.61540,  -2.55700,  -2.49830,  -2.44800, 
     &  -2.38900,  -2.36630,  -2.34310,  -2.33140,  -2.32000, 
     &  -2.32000,  -2.33140,  -2.34310,  -2.35470,  -2.37770, 
     &  -2.40040,  -2.52180,  -2.64990,  -2.76940,  -2.90570, 
     &  -3.02860,  -3.15430,  -3.36960,  -3.60530,  -4.19770, 
     &  -4.78110,  -5.29330,  -5.75540,  -6.45420,  -7.02390, 
     &  -7.59370,  -8.00000/

c --- double exponential fit parameters for co2  

      data cpco2(1:100)/
     &  -9.84950,  -9.64840,  -9.44720,  -9.24610,  -9.04490, 
     &  -8.95440,  -8.61270,  -8.40760,  -8.27100,  -8.03910, 
     &  -7.94850,  -7.96380,  -7.78490,  -7.62780,  -7.14180, 
     &  -6.78230,  -6.38260,  -6.03230,  -5.75010,  -5.52490, 
     &  -5.33040,  -5.01050,  -4.77030,  -4.57140,  -4.39190, 
     &  -4.29740,  -4.13700,  -3.87610,  -3.59360,  -3.28520, 
     &  -3.00160,  -2.73030,  -2.48680,  -2.27410,  -2.09360, 
     &  -1.94240,  -1.80920,  -1.68430,  -1.53720,  -1.38030, 
     &  -1.20430,  -0.99300,  -0.77240,  -0.55090,  -0.34650, 
     &  -0.17850,  -0.04700,   0.04490,   0.11140,   0.13670, 
     &   0.09100,   0.00660,  -0.12690,  -0.29940,  -0.49340, 
     &  -0.71010,  -0.90870,  -1.10040,  -1.26940,  -1.40640, 
     &  -1.56220,  -1.68100,  -1.78410,  -1.89730,  -2.02740, 
     &  -2.20790,  -2.42640,  -2.67630,  -2.93120,  -3.18960, 
     &  -3.42620,  -3.59790,  -3.70510,  -3.73720,  -3.79830, 
     &  -3.91540,  -4.05200,  -4.25670,  -4.46610,  -4.66700, 
     &  -4.92260,  -5.22030,  -5.55970,  -5.64030,  -5.70390, 
     &  -5.76740,  -5.83100,  -5.89480,  -5.95030,  -6.02170, 
     &  -6.03920,  -5.98550,  -5.86200,  -5.68340,  -5.50830, 
     &  -5.34730,  -5.20280,  -5.07990,  -4.96280,  -4.83790/
      data cpco2(101:200)/
     &  -4.70320,  -4.55840,  -4.42130,  -4.31980,  -4.27860, 
     &  -4.28430,  -4.30990,  -4.32100,  -4.27690,  -4.22290, 
     &  -4.21790,  -4.29500,  -4.47890,  -4.75500,  -5.09020, 
     &  -5.43290,  -5.66890,  -5.66080,  -5.45820,  -5.19690, 
     &  -4.94190,  -4.71060,  -4.50840,  -4.34090,  -4.22110, 
     &  -4.15630,  -4.12590,  -4.11080,  -4.08030,  -4.02110, 
     &  -3.98240,  -4.00530,  -4.12210,  -4.35040,  -4.67410, 
     &  -5.08260,  -5.58570,  -6.23010,  -7.08290,  -8.13440, 
     &  -8.86010,  -9.04570,  -9.12310,  -9.07280,  -9.14130, 
     &  -9.12210,  -9.18820,  -9.27520,  -9.22370,  -9.36040, 
     &  -9.30580,  -9.54550,  -9.55670,  -9.37540,  -8.77560, 
     &  -8.09040,  -7.48270,  -6.95850,  -6.50950,  -6.11940, 
     &  -5.78240,  -5.49100,  -5.25320,  -5.08400,  -4.99200, 
     &  -4.95770,  -4.96380,  -4.97410,  -4.95550,  -4.94660, 
     &  -4.97740,  -5.07190,  -5.25580,  -5.52130,  -5.86330, 
     &  -6.28770,  -6.78780,  -7.26020,  -7.29400,  -6.85240, 
     &  -6.33720,  -5.88540,  -5.50650,  -5.20110,  -4.97760, 
     &  -4.84710,  -4.78850,  -4.77830,  -4.78150,  -4.75380, 
     &  -4.72280,  -4.72590,  -4.78600,  -4.92310,  -5.12700, 
     &  -5.38310,  -5.68490,  -6.03510,  -6.44370,  -6.91600/
      data cpco2(201:300)/
     &  -7.48150,  -8.14370,  -8.94490,  -9.85640,  -9.89030, 
     &  -9.43650,  -8.98260,  -8.52880,  -8.11840,  -7.65550, 
     &  -7.16730,  -6.72260,  -6.34230,  -6.04100,  -5.81540, 
     &  -5.65190,  -5.51860,  -5.38590,  -5.22790,  -5.02380, 
     &  -4.78650,  -4.53430,  -4.28460,  -4.05600,  -3.87170, 
     &  -3.76240,  -3.72310,  -3.73350,  -3.83120,  -3.98540, 
     &  -4.19300,  -4.48950,  -4.73940,  -4.88920,  -4.94990, 
     &  -4.93920,  -4.97870,  -5.11290,  -5.33300,  -5.60930, 
     &  -5.88620,  -6.05810,  -6.02740,  -5.83560,  -5.59890, 
     &  -5.37380,  -5.16610,  -4.94720,  -4.70200,  -4.43540, 
     &  -4.14390,  -3.85610,  -3.59440,  -3.36940,  -3.21000, 
     &  -3.10410,  -3.04110,  -3.04710,  -3.10770,  -3.23050, 
     &  -3.42740,  -3.61150,  -3.75420,  -3.86660,  -3.93380, 
     &  -4.00790,  -4.09620,  -4.21420,  -4.14330,  -4.28700, 
     &  -4.47960,  -4.66180,  -4.82040,  -4.94990,  -4.98620, 
     &  -5.01710,  -5.02820,  -5.05800,  -5.03980,  -4.94650, 
     &  -4.78160,  -4.55380,  -4.29750,  -4.02860,  -3.75280, 
     &  -3.47150,  -3.18990,  -2.90410,  -2.61270,  -2.32120, 
     &  -2.04350,  -1.78940,  -1.55310,  -1.33820,  -1.15150, 
     &  -0.99900,  -0.88330,  -0.80060,  -0.72270,  -0.62880/
      data cpco2(301:400)/
     &  -0.49770,  -0.32490,  -0.13490,   0.05760,   0.24870, 
     &   0.43860,   0.62600,   0.80810,   0.96810,   1.08590, 
     &   1.15220,   1.18610,   1.20390,   1.22550,   1.25870, 
     &   1.24730,   1.14570,   0.91390,   0.52500,   0.01730, 
     &  -0.57960,  -1.39440,  -2.38410,  -2.72440,  -2.92640, 
     &  -3.06890,  -3.21200,  -3.33530,  -3.45100,  -3.55660, 
     &  -3.65180,  -3.74600,  -3.85000,  -3.96800,  -4.09810, 
     &  -4.22590,  -4.33690,  -4.43290,  -4.53050,  -4.62640, 
     &  -4.74380,  -4.88420,  -5.02480,  -5.14480,  -5.23710, 
     &  -5.27810,  -5.32990,  -5.37660,  -5.42330,  -5.46990, 
     &  -5.51660,  -5.56330,  -5.66460,  -5.75930,  -5.84610, 
     &  -5.92290,  -5.98180,  -6.00650,  -5.97470,  -5.87410, 
     &  -5.72300,  -5.56200,  -5.43890,  -5.37880,  -5.36790, 
     &  -5.38270,  -5.38370,  -5.34600,  -5.31860,  -5.33940, 
     &  -5.43200,  -5.60950,  -5.84460,  -6.09920,  -6.33990, 
     &  -6.54990,  -6.74340,  -6.93590,  -7.12190,  -7.28180, 
     &  -7.39840,  -7.48810,  -7.54520,  -7.59940,  -7.64450, 
     &  -7.67340,  -7.64220,  -7.50570,  -7.26500,  -6.99750, 
     &  -6.77490,  -6.63980,  -6.58750,  -6.59120,  -6.61920, 
     &  -6.61550,  -6.58660,  -6.58510,  -6.63820,  -6.77360/
      data cpco2(401:500)/
     &  -7.00090,  -7.28960,  -7.63270,  -7.97670,  -8.26330, 
     &  -8.47440,  -8.54550,  -8.58130,  -8.60250,  -8.64590, 
     &  -8.89480,  -9.14360,  -9.39250,  -9.64130,  -9.89020, 
     &  -9.80060,  -9.50490,  -9.19470,  -8.72540,  -8.44100, 
     &  -8.17810,  -8.01820,  -7.93810,  -7.87930,  -7.76360, 
     &  -7.55490,  -7.29620,  -7.02440,  -6.75560,  -6.48880, 
     &  -6.24430,  -6.04220,  -5.90880,  -5.85900,  -5.88900, 
     &  -5.98500,  -6.09490,  -6.11640,  -6.02070,  -5.85920, 
     &  -5.71100,  -5.63280,  -5.63690,  -5.72740,  -5.90690, 
     &  -6.17200,  -6.52030,  -6.95860,  -7.47760,  -8.06070, 
     &  -8.55140,  -8.70110,  -8.42320,  -7.92740,  -7.61590, 
     &  -7.38360,  -7.19690,  -7.05230,  -6.76850,  -6.40220, 
     &  -6.03540,  -5.71250,  -5.46590,  -5.30880,  -5.25460, 
     &  -5.29910,  -5.38190,  -5.46150,  -5.41170,  -5.21070, 
     &  -5.01030,  -4.82320,  -4.70710,  -4.68500,  -4.73850, 
     &  -4.87970,  -5.10240,  -5.40150,  -5.77580,  -6.22250, 
     &  -6.66810,  -6.91270,  -6.89190,  -6.69720,  -6.50120, 
     &  -6.31230,  -6.10910,  -5.86410,  -5.58890,  -5.30570, 
     &  -5.03400,  -4.78260,  -4.54760,  -4.32770,  -4.12240, 
     &  -3.93330,  -3.76750,  -3.63240,  -3.51630,  -3.40430/
      data cpco2(501:600)/
     &  -3.27440,  -3.11800,  -2.95570,  -2.82540,  -2.73590, 
     &  -2.67210,  -2.60840,  -2.51050,  -2.37720,  -2.23170, 
     &  -2.08660,  -1.95210,  -1.82920,  -1.71100,  -1.59920, 
     &  -1.48730,  -1.36460,  -1.22600,  -1.07210,  -0.92810, 
     &  -0.83790,  -0.81230,  -0.82610,  -0.84830,  -0.83050, 
     &  -0.77920,  -0.76260,  -0.82280,  -0.99080,  -1.25030, 
     &  -1.53470,  -1.79340,  -1.98370,  -2.07150,  -2.03750, 
     &  -1.89750,  -1.69060,  -1.44970,  -1.20480,  -0.98310, 
     &  -0.81250,  -0.71570,  -0.67070,  -0.65320,  -0.62970, 
     &  -0.57060,  -0.52630,  -0.54890,  -0.68570,  -0.97930, 
     &  -1.39620,  -1.86730,  -2.36550,  -3.54360,  -4.04240, 
     &  -4.40840,  -4.68480,  -4.86630,  -4.95160,  -4.97900, 
     &  -4.99230,  -5.02070,  -5.05960,  -5.09580,  -5.10180, 
     &  -5.06360,  -5.03540,  -5.05460,  -5.14540,  -5.32740, 
     &  -5.58630,  -5.88890,  -6.17700,  -6.35550,  -6.40960, 
     &  -6.43710,  -6.51120,  -6.66800,  -6.91830,  -7.24180, 
     &  -7.58270,  -7.87040,  -8.05510,  -8.17050,  -8.25000, 
     &  -8.35540,  -8.39610,  -8.43540,  -8.39200,  -8.27850, 
     &  -8.04990,  -7.74370,  -7.41300,  -7.11530,  -6.88610, 
     &  -6.74220,  -6.67860,  -6.67740,  -6.70530,  -6.70900/
      data cpco2(601:700)/
     &  -6.67940,  -6.60550,  -6.48270,  -6.34540,  -6.24010, 
     &  -6.19920,  -6.26760,  -6.48330,  -6.84900,  -7.43100, 
     &  -8.46060,  -9.73640,  -9.87710,  -9.88400,  -9.95590, 
     &  -9.94890,  -9.60030,  -9.09100,  -8.57930,  -8.20590, 
     &  -7.90990,  -7.71570,  -7.61450,  -7.59640,  -7.59420, 
     &  -7.52560,  -7.31900,  -6.99860,  -6.68840,  -6.41020, 
     &  -6.17690,  -5.98820,  -5.84210,  -5.74990,  -5.72010, 
     &  -5.71890,  -5.71080,  -5.66690,  -5.59550,  -5.56860, 
     &  -5.62870,  -5.80000,  -6.08550,  -6.43980,  -6.77930, 
     &  -6.94270,  -6.92050,  -6.83630,  -6.70590,  -6.52720, 
     &  -6.29030,  -6.00850,  -5.72240,  -5.47220,  -5.27720, 
     &  -5.15010,  -5.07680,  -5.02190,  -4.95790,  -4.85550, 
     &  -4.72130,  -4.58680,  -4.45940,  -4.33870,  -4.22190, 
     &  -4.10020,  -3.98120,  -3.88760,  -3.82070,  -3.76730, 
     &  -3.71200,  -3.62230,  -3.49120,  -3.34440,  -3.19830, 
     &  -3.07320,  -3.02620,  -3.00780,  -3.01230,  -3.02130, 
     &  -2.99570,  -2.92610,  -2.87700,  -2.88870,  -2.98530, 
     &  -3.16090,  -3.36430,  -3.54680,  -3.67590,  -3.74880, 
     &  -3.77040,  -3.75350,  -3.71130,  -3.63680,  -3.52770, 
     &  -3.38120,  -3.20200,  -3.00430,  -2.80200,  -2.61220/
      data cpco2(701:800)/
     &  -2.45240,  -2.34050,  -2.28380,  -2.25210,  -2.23190, 
     &  -2.19600,  -2.15620,  -2.17320,  -2.29130,  -2.54760, 
     &  -2.93820,  -3.39660,  -3.85250,  -4.25410,  -4.56820, 
     &  -4.73760,  -4.75240,  -4.67330,  -4.51700,  -4.31230, 
     &  -4.08910,  -3.85650,  -3.62180,  -3.39090,  -3.17850, 
     &  -3.01000,  -2.91050,  -2.85880,  -2.82860,  -2.79120, 
     &  -2.72070,  -2.67290,  -2.68580,  -2.77450,  -2.94140, 
     &  -3.14450,  -3.36170,  -3.59540,  -3.85080,  -4.17390, 
     &  -4.51220,  -4.89850,  -5.34260,  -5.87370,  -6.47340, 
     &  -7.07150,  -7.50420,  -7.60340,  -7.51430,  -7.43580, 
     &  -7.40890,  -7.39690,  -7.38130,  -7.30180,  -7.18580, 
     &  -7.06330,  -6.99620,  -6.99050,  -7.03190,  -7.13310, 
     &  -7.20540,  -7.18560,  -7.05610,  -6.79660,  -6.47710, 
     &  -6.19960,  -5.95930,  -5.75600,  -5.53700,  -5.28360, 
     &  -5.09660,  -4.95830,  -4.91260,  -5.00220,  -5.13700, 
     &  -5.34650,  -5.62790,  -5.93640,  -6.36950,  -6.96020, 
     &  -7.68230,  -8.27010,  -8.64270,  -9.07280,  -9.53660, 
     &  -9.95880,  -9.98710,  -9.67620,  -9.33580,  -8.99540, 
     &  -8.51400,  -8.20660,  -7.97420,  -7.85790,  -7.80730, 
     &  -7.78940,  -7.74660,  -7.70090,  -7.63930,  -7.58890/
      data cpco2(801:900)/
     &  -7.56970,  -7.52000,  -7.39080,  -7.17960,  -6.96100, 
     &  -6.78690,  -6.69720,  -6.67350,  -6.67750,  -6.64950, 
     &  -6.52920,  -6.34350,  -6.13710,  -5.92680,  -5.72540, 
     &  -5.54330,  -5.40230,  -5.32920,  -5.30900,  -5.31710, 
     &  -5.31930,  -5.27050,  -5.20850,  -5.18350,  -5.21860, 
     &  -5.33670,  -5.53050,  -5.77250,  -6.02280,  -6.21500, 
     &  -6.28570,  -6.26340,  -6.22500,  -6.22340,  -6.26160, 
     &  -6.29310,  -6.25080,  -6.09710,  -5.86790,  -5.61950, 
     &  -5.39060,  -5.19440,  -5.02160,  -4.85660,  -4.69190, 
     &  -4.52550,  -4.37850,  -4.28790,  -4.25830,  -4.26360, 
     &  -4.27680,  -4.24840,  -4.18530,  -4.15860,  -4.20790, 
     &  -4.36510,  -4.64070,  -5.01410,  -5.47190,  -6.00150, 
     &  -6.51730,  -6.78290,  -6.68050,  -6.41800,  -6.07930, 
     &  -5.74040,  -5.42040,  -5.12650,  -4.86340,  -4.63780, 
     &  -4.45590,  -4.33600,  -4.27520,  -4.24610,  -4.22570, 
     &  -4.17680,  -4.10680,  -4.07430,  -4.11930,  -4.27320, 
     &  -4.54640,  -4.92560,  -5.40900,  -6.01840,  -6.79850, 
     &  -7.70780,  -8.34570,  -8.51600,  -8.61060,  -8.81750, 
     &  -9.19220,  -9.67750,  -9.74230,  -9.19800,  -8.41200, 
     &  -7.74990,  -7.16850,  -6.68170,  -6.27010,  -5.93010/
      data cpco2(901:1000)/
     &  -5.65670,  -5.45210,  -5.32890,  -5.27760,  -5.26300, 
     &  -5.25470,  -5.20830,  -5.12960,  -5.08230,  -5.09140, 
     &  -5.18060,  -5.35030,  -5.56000,  -5.78770,  -5.99360, 
     &  -6.17200,  -6.38010,  -6.63710,  -6.99640,  -7.50100, 
     &  -8.16280,  -8.99510,  -9.89310, -10.00000, -10.00000, 
     & -10.00000, -10.00000, -10.00000, -10.00000, -10.00000, 
     & -10.00000,  -9.49670,  -8.91980,  -8.50810,  -8.12550, 
     &  -7.82860,  -7.54780,  -7.14870,  -6.78530,  -6.55370, 
     &  -6.39310,  -6.41070,  -6.50870,  -6.66070,  -6.90260, 
     &  -7.21040,  -7.44450,  -7.63030,  -7.63460,  -7.45210, 
     &  -7.22110,  -7.00430,  -6.79030,  -6.56660,  -6.34990, 
     &  -6.15340,  -5.99880,  -5.90330,  -5.87600,  -5.86930, 
     &  -5.82770,  -5.72820,  -5.62620,  -5.58650,  -5.66650, 
     &  -5.92280,  -6.33990,  -7.01800,  -8.42300, -10.00000, 
     & -10.00000, -10.00000,  -9.40900,  -8.82720,  -8.30570, 
     &  -7.88850,  -7.50440,  -7.15600,  -6.82920,  -6.52500, 
     &  -6.24610,  -5.99040,  -5.75330,  -5.52950,  -5.31350, 
     &  -5.10580,  -4.91520,  -4.74630,  -4.60540,  -4.49370, 
     &  -4.39280,  -4.28380,  -4.16260,  -4.03870,  -3.92950, 
     &  -3.86120,  -3.85010,  -3.86470,  -3.86250,  -3.80990/
      data cpco2(1001:1100)/
     &  -3.73510,  -3.71790,  -3.85490,  -4.23120,  -4.76320, 
     &  -5.42700,  -6.42000,  -8.14140,  -9.04510,  -9.53260, 
     &  -9.83010,  -9.94720,  -9.82740,  -8.97970,  -8.42980, 
     &  -7.89060,  -7.44770,  -7.07500,  -6.76980,  -6.53380, 
     &  -6.37390,  -6.29800,  -6.27390,  -6.27260,  -6.25550, 
     &  -6.19890,  -6.15290,  -6.16540,  -6.25840,  -6.46100, 
     &  -6.78050,  -7.22350,  -7.81910,  -8.58500,  -9.60840, 
     & -10.00000, -10.00000,  -9.91990,  -9.10930,  -8.44900, 
     &  -7.91580,  -7.43640,  -7.04000,  -6.69580,  -6.41310, 
     &  -6.18550,  -6.01580,  -5.91230,  -5.87000,  -5.85300, 
     &  -5.83400,  -5.78660,  -5.72240,  -5.70480,  -5.76530, 
     &  -5.92810,  -6.22340,  -6.66460,  -7.29570,  -8.27990, 
     &  -9.94570, -10.00000, -10.00000, -10.00000, -10.00000, 
     & -10.00000, -10.00000, -10.00000,  -9.27660,  -8.62010, 
     &  -8.07640,  -7.63740,  -7.27520,  -6.98020,  -6.75780, 
     &  -6.61630,  -6.55460,  -6.53920,  -6.53970,  -6.51320, 
     &  -6.45310,  -6.41610,  -6.44820,  -6.56830,  -6.80860, 
     &  -7.17620,  -7.67720,  -8.35740,  -9.21880, -10.00000, 
     & -10.00000,  -9.53500,  -8.96860,  -8.53290,  -8.19200, 
     &  -7.92370,  -7.67970,  -7.50390,  -7.36670,  -7.28560/
      data cpco2(1101:1200)/
     &  -7.19690,  -7.07450,  -6.93300,  -6.79260,  -6.68180, 
     &  -6.61440,  -6.56430,  -6.51830,  -6.49100,  -6.44810, 
     &  -6.35670,  -6.21770,  -6.05660,  -5.90960,  -5.79750, 
     &  -5.70930,  -5.61650,  -5.51270,  -5.41240,  -5.34260, 
     &  -5.30610,  -5.26480,  -5.18640,  -5.08760,  -5.02260, 
     &  -5.03970,  -5.19050,  -5.48580,  -5.91010,  -6.48510, 
     &  -6.78620,  -6.53680,  -6.27650,  -6.03980,  -5.82600, 
     &  -5.63970,  -5.47990,  -5.34380,  -5.22740,  -5.14110, 
     &  -5.09170,  -5.04730,  -4.98200,  -4.91140,  -4.86340, 
     &  -4.88440,  -5.03630,  -5.33510,  -5.78020,  -6.53870, 
     &  -8.37350,  -9.99770,  -9.75060,  -9.18870,  -8.68240, 
     &  -8.34880,  -8.05330,  -7.86640,  -7.73460,  -7.69340, 
     &  -7.66740,  -7.62680,  -7.54510,  -7.46770,  -7.45200, 
     &  -7.54710,  -7.79130,  -8.19170,  -8.88350, -10.00000, 
     & -10.00000, -10.00000, -10.00000, -10.00000,  -9.72340, 
     &  -8.99690,  -8.57760,  -8.17370,  -7.86400,  -7.57290, 
     &  -7.31860,  -7.09730,  -6.91310,  -6.77820,  -6.70730, 
     &  -6.67680,  -6.63030,  -6.54060,  -6.45090,  -6.39500, 
     &  -6.43450,  -6.62700,  -6.95070,  -7.50280,  -8.64280, 
     & -10.00000, -10.00000, -10.00000, -10.00000,  -9.53030/
      data cpco2(1201:1219)/
     &  -8.93690,  -8.49520,  -8.14650,  -7.85670,  -7.61770, 
     &  -7.42490,  -7.28760,  -7.22060,  -7.19480,  -7.15520, 
     &  -7.07730,  -6.98840,  -6.94020,  -6.98390,  -7.17730, 
     &  -7.49990,  -8.06430,  -9.14800, -10.00000/

c --- double exponential fit parameters for co   

      data cpco(1:100)/
     &  -4.68680,  -4.41270,  -3.94610,  -3.56620,  -3.29210, 
     &  -3.10810,  -2.98070,  -2.89770,  -2.85800,  -2.84610, 
     &  -2.85870,  -2.90290,  -2.96460,  -3.04800,  -3.15890, 
     &  -3.28360,  -3.42770,  -3.59930,  -3.79630,  -4.01640, 
     &  -4.27990,  -4.57500,  -4.87220,  -5.27410,  -5.68190, 
     &  -6.07990,  -6.48280,  -6.88570,  -7.28860,  -7.69150, 
     &  -8.09440,  -8.49730,  -8.90020,  -9.30310,  -9.70600, 
     & -10.00000, -10.00000,  -9.53120,  -8.89770,  -8.26420, 
     &  -7.57670,  -6.99720,  -6.54080,  -6.12190,  -5.67340, 
     &  -5.26580,  -4.86860,  -4.49180,  -4.14230,  -3.81330, 
     &  -3.49980,  -3.21040,  -2.94430,  -2.71380,  -2.50840, 
     &  -2.31090,  -2.12450,  -1.93870,  -1.76080,  -1.60540, 
     &  -1.47330,  -1.35940,  -1.25400,  -1.14800,  -1.03410, 
     &  -0.92160,  -0.81890,  -0.72350,  -0.63620,  -0.55490, 
     &  -0.48560,  -0.44010,  -0.42680,  -0.46570,  -0.55710, 
     &  -0.65730,  -0.74040,  -0.75230,  -0.66010,  -0.53800, 
     &  -0.42110,  -0.33670,  -0.31670,  -0.33200,  -0.37530, 
     &  -0.44890,  -0.54380,  -0.66530,  -0.80520,  -0.96900, 
     &  -1.15060,  -1.35220,  -1.57910,  -1.82480,  -2.10730, 
     &  -2.42460,  -2.78770,  -3.21520,  -3.70890,  -4.28320/
      data cpco(101:173)/
     &  -4.95180,  -5.72510,  -6.53190,  -7.48790,  -9.08850, 
     & -10.00000, -10.00000,  -9.56110,  -9.08750,  -8.61390, 
     &  -7.97470,  -7.52500,  -7.19310,  -6.85960,  -6.57410, 
     &  -6.29220,  -6.00980,  -5.76690,  -5.53450,  -5.32290, 
     &  -5.14610,  -4.98820,  -4.84930,  -4.72390,  -4.60640, 
     &  -4.50090,  -4.40710,  -4.33220,  -4.26610,  -4.19260, 
     &  -4.09560,  -3.96110,  -3.79840,  -3.63140,  -3.47570, 
     &  -3.34080,  -3.22370,  -3.12190,  -3.03250,  -2.94940, 
     &  -2.87650,  -2.81170,  -2.75310,  -2.70230,  -2.66350, 
     &  -2.64400,  -2.65500,  -2.72250,  -2.81610,  -2.90150, 
     &  -2.92410,  -2.82280,  -2.67260,  -2.53200,  -2.42910, 
     &  -2.37720,  -2.37320,  -2.39950,  -2.45740,  -2.54860, 
     &  -2.66640,  -2.82090,  -3.01290,  -3.25160,  -3.54820, 
     &  -3.91650,  -4.37140,  -4.93260,  -5.63940,  -6.51630, 
     &  -7.60630,  -9.35750, -10.00000/

c --- double exponential fit parameters for ch4  

      data cpch4(1:100)/
     & -10.00000,  -9.45770,  -8.88660,  -8.22460,  -7.79400, 
     &  -7.17340,  -6.79650,  -6.56950,  -6.19290,  -5.91690, 
     &  -5.74520,  -5.47310,  -5.30010,  -5.18720,  -4.96720, 
     &  -4.84740,  -4.69390,  -4.52100,  -4.33770,  -4.13460, 
     &  -3.93220,  -3.73390,  -3.50770,  -3.27190,  -3.02960, 
     &  -2.81240,  -2.61990,  -2.44790,  -2.25020,  -2.05410, 
     &  -1.88000,  -1.70920,  -1.57910,  -1.43790,  -1.29920, 
     &  -1.17350,  -1.05100,  -0.96460,  -0.87790,  -0.80020, 
     &  -0.75740,  -0.73560,  -0.74780,  -0.75120,  -0.69060, 
     &  -0.55940,  -0.44170,  -0.40190,  -0.50270,  -0.76280, 
     &  -0.96250,  -1.04310,  -1.00680,  -0.87810,  -0.75590, 
     &  -0.66280,  -0.61280,  -0.61180,  -0.65750,  -0.76200, 
     &  -0.92170,  -1.12640,  -1.36600,  -1.63520,  -1.92640, 
     &  -2.22660,  -2.51230,  -2.74720,  -2.88200,  -2.91290, 
     &  -2.91450,  -2.88540,  -2.85080,  -2.85120,  -2.82020, 
     &  -2.80230,  -2.80040,  -2.78000,  -2.81750,  -2.84130, 
     &  -2.89430,  -2.98760,  -3.06880,  -3.24240,  -3.40640, 
     &  -3.57590,  -3.76300,  -3.89250,  -4.07740,  -4.32430, 
     &  -4.59640,  -3.86540,  -3.09740,  -2.59670,  -2.24820, 
     &  -2.10160,  -2.14880,  -2.32610,  -2.64480,  -3.04460/
      data cpch4(101:200)/
     &  -3.39580,  -3.65100,  -3.70490,  -3.72400,  -3.59920, 
     &  -3.49370,  -3.36760,  -3.22300,  -3.16300,  -3.06910, 
     &  -3.07760,  -3.08720,  -3.09740,  -3.12230,  -3.12850, 
     &  -3.12120,  -3.13330,  -3.16740,  -3.16680,  -3.24330, 
     &  -3.23980,  -3.31350,  -3.39750,  -3.44270,  -3.64340, 
     &  -3.75280,  -3.94660,  -4.19400,  -4.33620,  -4.55390, 
     &  -4.74100,  -4.91550,  -5.13450,  -5.39080,  -5.55920, 
     &  -5.82700,  -6.02890,  -6.23650,  -6.67300,  -7.05380, 
     &  -7.62160,  -8.56970,  -9.84830, -10.00000,  -9.35770, 
     &  -8.59500,  -7.83230,  -7.06960,  -6.30690,  -5.54420, 
     &  -5.15010,  -4.88530,  -4.69000,  -4.52620,  -4.39570, 
     &  -4.28230,  -4.27360,  -4.20540,  -4.11680,  -3.99860, 
     &  -3.87120,  -3.86920,  -3.87770,  -3.89650,  -3.90920, 
     &  -3.87880,  -3.76610,  -3.69000,  -3.62390,  -3.55970, 
     &  -3.51930,  -3.49060,  -3.44150,  -3.37300,  -3.35790, 
     &  -3.34270,  -3.32080,  -3.30480,  -3.31360,  -3.29040, 
     &  -3.25450,  -3.22410,  -3.14530,  -3.01870,  -2.94270, 
     &  -2.86300,  -2.81460,  -2.86040,  -2.89220,  -2.96500, 
     &  -2.99590,  -2.89200,  -2.79890,  -2.70280,  -2.65060, 
     &  -2.72850,  -2.84200,  -2.93040,  -2.96220,  -2.87260/
      data cpch4(201:300)/
     &  -2.75660,  -2.67450,  -2.63370,  -2.65330,  -2.68000, 
     &  -2.70980,  -2.74790,  -2.68590,  -2.62160,  -2.57010, 
     &  -2.46830,  -2.44260,  -2.44630,  -2.41940,  -2.45780, 
     &  -2.48940,  -2.46390,  -2.48250,  -2.49980,  -2.43810, 
     &  -2.41230,  -2.36540,  -2.26980,  -2.23870,  -2.23640, 
     &  -2.20290,  -2.17800,  -2.14330,  -2.03550,  -1.94580, 
     &  -1.87230,  -1.79360,  -1.76390,  -1.77820,  -1.80220, 
     &  -1.81150,  -1.78180,  -1.69860,  -1.61690,  -1.59750, 
     &  -1.65450,  -1.77420,  -1.89370,  -1.95440,  -1.89420, 
     &  -1.77610,  -1.63920,  -1.52360,  -1.45510,  -1.42210, 
     &  -1.42450,  -1.41740,  -1.41770,  -1.37760,  -1.33490, 
     &  -1.29090,  -1.24700,  -1.21620,  -1.18500,  -1.16770, 
     &  -1.14490,  -1.12290,  -1.10310,  -1.07950,  -1.06870, 
     &  -1.06920,  -1.09040,  -1.11660,  -1.15110,  -1.19510, 
     &  -1.23210,  -1.28310,  -1.27160,  -1.19020,  -0.97150, 
     &  -0.66540,  -0.41030,  -0.30110,  -0.50490,  -0.86590, 
     &  -1.17770,  -1.38470,  -1.43590,  -1.39080,  -1.29920, 
     &  -1.19230,  -1.09510,  -1.02130,  -0.95780,  -0.92990, 
     &  -0.92070,  -0.92920,  -0.97250,  -1.01260,  -1.07500, 
     &  -1.11490,  -1.16360,  -1.20590,  -1.26380,  -1.33270/
      data cpch4(301:400)/
     &  -1.40790,  -1.49830,  -1.57110,  -1.68720,  -1.78700, 
     &  -1.92660,  -2.07740,  -2.21190,  -2.38750,  -2.51550, 
     &  -2.68220,  -2.83720,  -3.00320,  -3.24130,  -3.50580, 
     &  -3.95080,  -4.51330,  -5.35360,  -8.08150,  -8.90810, 
     &  -9.81550, -10.00000,  -7.47570,  -5.16020,  -4.24540, 
     &  -3.76400,  -3.32560,  -3.01030,  -2.77260,  -2.55100, 
     &  -2.38490,  -2.23180,  -2.10800,  -2.00860,  -1.92900, 
     &  -1.89020,  -1.87500,  -1.87000,  -1.84760,  -1.73900, 
     &  -1.57240,  -1.42840,  -1.34250,  -1.37910,  -1.51320, 
     &  -1.65080,  -1.72830,  -1.66840,  -1.54320,  -1.44470, 
     &  -1.37730,  -1.34900,  -1.36420,  -1.40160,  -1.47130, 
     &  -1.58360,  -1.69840,  -1.80850,  -1.84860,  -1.74640, 
     &  -1.63380,  -1.55550,  -1.55520,  -1.69350,  -1.81650, 
     &  -1.84170,  -1.76970,  -1.63460,  -1.55890,  -1.54660, 
     &  -1.56040,  -1.63070,  -1.68670,  -1.75930,  -1.80510, 
     &  -1.81670,  -1.85180,  -1.85590,  -1.85470,  -1.89070, 
     &  -1.88510,  -1.89330,  -1.90810,  -1.90250,  -1.94510, 
     &  -1.99240,  -2.03210,  -2.08160,  -2.10260,  -2.11370, 
     &  -2.13510,  -2.16290,  -2.18760,  -2.23400,  -2.29600, 
     &  -2.37470,  -2.49700,  -2.62440,  -2.76410,  -2.89120/
      data cpch4(401:493)/
     &  -3.03280,  -3.19440,  -3.38770,  -3.45660,  -3.16620, 
     &  -2.72530,  -2.39920,  -2.22140,  -2.20220,  -2.39780, 
     &  -2.74490,  -3.26390,  -3.93110,  -4.14700,  -3.93510, 
     &  -3.74710,  -3.62450,  -3.47910,  -3.47100,  -3.42100, 
     &  -3.41250,  -3.44750,  -3.41400,  -3.49080,  -3.51640, 
     &  -3.59440,  -3.74030,  -3.81920,  -4.01770,  -4.18330, 
     &  -4.35180,  -4.64860,  -4.87780,  -5.25420,  -5.78340, 
     &  -6.34510,  -7.72120, -10.00000,  -9.91340,  -7.91810, 
     &  -6.08150,  -5.43970,  -4.98750,  -4.61540,  -4.48460, 
     &  -4.35410,  -4.30370,  -4.30730,  -4.24710,  -4.25930, 
     &  -4.19840,  -4.18950,  -4.16970,  -4.15780,  -4.19500, 
     &  -4.18780,  -4.22990,  -4.22090,  -4.26460,  -4.31230, 
     &  -4.39110,  -4.45880,  -4.18730,  -3.83530,  -3.52820, 
     &  -3.30550,  -3.33510,  -3.56710,  -3.87500,  -4.26450, 
     &  -4.47860,  -4.42930,  -4.31830,  -4.19960,  -4.08790, 
     &  -4.01690,  -3.97870,  -3.95360,  -3.94540,  -3.92830, 
     &  -3.91660,  -3.91520,  -3.93360,  -3.95610,  -3.99320, 
     &  -4.09340,  -4.23170,  -4.50840,  -4.94600,  -5.49580, 
     &  -6.54920,  -8.56040,  -9.62020/

c --- double exponential fit parameters for n2o  

      data cpn2o(1:100)/
     &  -2.80030,  -2.66280,  -2.43130,  -2.25790,  -2.17000, 
     &  -2.17020,  -2.24900,  -2.40030,  -2.62640,  -2.92190, 
     &  -3.29540,  -3.76840,  -4.26210,  -4.75580,  -5.24950, 
     &  -5.74320,  -6.23690,  -6.73060,  -7.22430,  -7.71800, 
     &  -8.21170,  -8.70540,  -9.19910,  -9.69280, -10.00000, 
     &  -9.71850,  -8.89260,  -8.06670,  -7.23070,  -6.41490, 
     &  -5.48720,  -4.70830,  -4.03190,  -3.47520,  -3.01550, 
     &  -2.60460,  -2.20570,  -1.81370,  -1.47410,  -1.19140, 
     &  -0.96030,  -0.79230,  -0.66290,  -0.58490,  -0.54020, 
     &  -0.49750,  -0.51480,  -0.55920,  -0.65210,  -0.81480, 
     &  -1.01860,  -1.27640,  -1.58730,  -1.96380,  -2.38810, 
     &  -2.80830,  -3.23920,  -3.69340,  -4.06820,  -4.13660, 
     &  -3.94230,  -3.71430,  -3.49750,  -3.26020,  -3.09760, 
     &  -2.98150,  -2.91530,  -2.95960,  -3.02810,  -3.12640, 
     &  -3.26500,  -3.39060,  -3.57170,  -3.83120,  -4.17060, 
     &  -4.60770,  -5.18390,  -5.92240,  -6.98620,  -7.69010, 
     &  -8.39400,  -9.09790,  -9.80180,  -9.91540,  -9.22710, 
     &  -8.53880,  -7.85040,  -7.16210,  -6.24280,  -5.60510, 
     &  -5.09710,  -4.72370,  -4.41040,  -4.20500,  -4.06810, 
     &  -4.02780,  -4.03070,  -4.04920,  -4.03330,  -3.97100/
      data cpn2o(101:200)/
     &  -3.92490,  -3.93600,  -4.03160,  -4.23170,  -4.54140, 
     &  -4.97870,  -5.56230,  -6.33350,  -7.99680,  -9.66010, 
     &  -9.54860,  -8.85170,  -8.15480,  -7.45790,  -6.76100, 
     &  -6.06410,  -5.36720,  -4.67030,  -3.69180,  -3.06560, 
     &  -2.57960,  -2.18760,  -1.86460,  -1.59190,  -1.35870, 
     &  -1.16840,  -1.02860,  -0.94700,  -0.92710,  -0.94420, 
     &  -0.96950,  -0.97530,  -0.95730,  -0.95500,  -1.00000, 
     &  -1.10700,  -1.27910,  -1.49760,  -1.72810,  -1.92770, 
     &  -2.02270,  -1.95770,  -1.76250,  -1.50200,  -1.21860, 
     &  -0.92700,  -0.63260,  -0.34290,  -0.07680,   0.15000, 
     &   0.32150,   0.41040,   0.43850,   0.42880,   0.41850, 
     &   0.45700,   0.49720,   0.49870,   0.42160,   0.23600, 
     &  -0.03190,  -0.37140,  -0.75390,  -1.15340,  -1.58550, 
     &  -2.06100,  -2.60680,  -3.26350,  -4.10380,  -5.27610, 
     &  -6.14370,  -7.00790,  -7.94400,  -8.88010,  -9.81620, 
     & -10.00000,  -9.59510,  -9.13050,  -8.66590,  -8.20130, 
     &  -7.73670,  -7.27210,  -6.80750,  -6.15980,  -5.86950, 
     &  -5.35100,  -4.94910,  -4.63100,  -4.38460,  -4.07840, 
     &  -3.77630,  -3.59010,  -3.46070,  -3.43860,  -3.54810, 
     &  -3.70140,  -3.93100,  -4.22510,  -4.45930,  -4.82100/
      data cpn2o(201:300)/
     &  -5.34940,  -6.12860,  -7.59810, -10.00000, -10.00000, 
     & -10.00000, -10.00000,  -6.37430,  -5.55920,  -5.01290, 
     &  -4.60750,  -4.31710,  -4.09280,  -3.75370,  -3.54060, 
     &  -3.38690,  -3.29130,  -3.36330,  -3.49320,  -3.69240, 
     &  -4.00740,  -4.25040,  -4.53890,  -4.94250,  -5.47410, 
     &  -6.20690,  -7.59810, -10.00000, -10.00000, -10.00000, 
     &  -6.92150,  -6.07980,  -5.19340,  -4.62880,  -4.13160, 
     &  -3.73220,  -3.40890,  -3.15730,  -2.95730,  -2.72980, 
     &  -2.56150,  -2.43820,  -2.35230,  -2.37740,  -2.45080, 
     &  -2.57550,  -2.77570,  -2.99040,  -3.27330,  -3.65240, 
     &  -4.15990,  -4.79520,  -5.70040,  -6.87620,  -6.98220, 
     &  -6.24840,  -5.76130,  -5.25860,  -4.86740,  -4.66330, 
     &  -4.53320,  -4.51580,  -4.65930,  -4.84270,  -5.09170, 
     &  -5.57810,  -6.06450,  -6.55090,  -7.03730,  -7.52370, 
     &  -8.01010,  -8.49650,  -8.98290,  -9.46930,  -9.95570, 
     &  -9.71300,  -8.66090,  -7.60890,  -6.55680,  -5.08800, 
     &  -4.45270,  -3.93020,  -3.44380,  -2.97010,  -2.54230, 
     &  -2.16160,  -1.80760,  -1.47630,  -1.15800,  -0.84450, 
     &  -0.54550,  -0.25060,   0.02340,   0.27750,   0.51130, 
     &   0.71540,   0.89290,   1.03590,   1.13060,   1.16970/
      data cpn2o(301:400)/
     &   1.18070,   1.18030,   1.19740,   1.24660,   1.26290, 
     &   1.20680,   1.04720,   0.76950,   0.40830,  -0.02440, 
     &  -0.54770,  -1.22020,  -2.10670,  -2.95080,  -3.21070, 
     &  -3.15870,  -2.96000,  -2.76410,  -2.63240,  -2.56710, 
     &  -2.56640,  -2.60880,  -2.64250,  -2.66060,  -2.68950, 
     &  -2.75510,  -2.88370,  -3.08840,  -3.37460,  -3.70780, 
     &  -4.09750,  -4.62720,  -5.24840, -10.00000, -10.00000, 
     & -10.00000,  -7.35710,  -5.02870,  -4.30470,  -3.64310, 
     &  -3.10260,  -2.61220,  -2.19410,  -1.84540,  -1.57260, 
     &  -1.38290,  -1.28180,  -1.25050,  -1.25790,  -1.27310, 
     &  -1.25020,  -1.20920,  -1.20440,  -1.25770,  -1.39420, 
     &  -1.62620,  -1.93470,  -2.28300,  -2.53860,  -2.48010, 
     &  -2.16710,  -1.80610,  -1.47260,  -1.17970,  -0.93770, 
     &  -0.75420,  -0.63920,  -0.58990,  -0.57430,  -0.56690, 
     &  -0.53390,  -0.47450,  -0.44710,  -0.47790,  -0.58770, 
     &  -0.79640,  -1.09420,  -1.48120,  -1.95930,  -2.51400, 
     &  -3.13500,  -3.81020,  -4.58250,  -5.59820,  -6.41930, 
     &  -7.24030,  -8.06140,  -8.88250,  -9.70350,  -9.89100, 
     &  -8.98760,  -8.08430,  -7.18090,  -6.15010,  -5.37420, 
     &  -4.73520,  -4.20510,  -3.75250,  -3.35620,  -2.99160/
      data cpn2o(401:500)/
     &  -2.66490,  -2.38720,  -2.14990,  -1.97470,  -1.79820, 
     &  -1.65180,  -1.55820,  -1.48380,  -1.50040,  -1.58210, 
     &  -1.69120,  -1.86730,  -2.07560,  -2.33510,  -2.70200, 
     &  -3.19210,  -3.84090,  -4.70850,  -5.95880,  -6.58290, 
     &  -8.55850,  -9.85840,  -9.97230,  -9.42150,  -8.87070, 
     &  -8.31990,  -7.76910,  -7.21830,  -6.55670,  -6.43450, 
     &  -5.64480,  -5.05290,  -4.46430,  -3.96240,  -3.52310, 
     &  -3.13950,  -2.80670,  -2.52320,  -2.28580,  -2.08200, 
     &  -1.90490,  -1.75540,  -1.64850,  -1.59590,  -1.58380, 
     &  -1.59610,  -1.59970,  -1.57340,  -1.56150,  -1.59740, 
     &  -1.70590,  -1.90340,  -2.16310,  -2.41810,  -2.54270, 
     &  -2.45920,  -2.25130,  -2.01870,  -1.78790,  -1.56120, 
     &  -1.33990,  -1.12650,  -0.92260,  -0.73790,  -0.57900, 
     &  -0.45730,  -0.39520,  -0.36830,  -0.35110,  -0.32160, 
     &  -0.25560,  -0.21260,  -0.25930,  -0.43610,  -0.77020, 
     &  -1.20890,  -1.70600,  -2.29370,  -3.11330,  -4.44190, 
     &  -6.01190,  -6.94570, -10.00000, -10.00000, -10.00000, 
     & -10.00000,  -7.03940,  -5.96370,  -5.23170,  -4.64190, 
     &  -4.16630,  -3.78740,  -3.50000,  -3.30860,  -3.21430, 
     &  -3.19260,  -3.21050,  -3.23080,  -3.19710,  -3.15100/
      data cpn2o(501:600)/
     &  -3.14020,  -3.19690,  -3.34770,  -3.60050,  -3.95340, 
     &  -4.41170,  -4.97290,  -5.60090,  -6.21790,  -5.98450, 
     &  -5.55020,  -4.90100,  -4.34010,  -3.82320,  -3.38020, 
     &  -2.99720,  -2.67470,  -2.41430,  -2.22090,  -2.10800, 
     &  -2.06820,  -2.06870,  -2.07750,  -2.04850,  -1.98470, 
     &  -1.95310,  -1.98700,  -2.11100,  -2.33660,  -2.62930, 
     &  -2.89220,  -2.94740,  -2.76270,  -2.49990,  -2.25540, 
     &  -2.05370,  -1.90620,  -1.82680,  -1.79410,  -1.77660, 
     &  -1.74680,  -1.67670,  -1.61300,  -1.60850,  -1.68490, 
     &  -1.85990,  -2.12580,  -2.45380,  -2.82050,  -3.20280, 
     &  -3.59880,  -4.06910,  -4.71170,  -5.63200,  -6.48060, 
     &  -7.37310,  -8.26020,  -9.14740, -10.00000, -10.00000, 
     &  -9.53400,  -9.02820,  -8.52240,  -8.01660,  -7.51090, 
     &  -7.00510,  -6.41170,  -6.01480,  -5.48780,  -5.17420, 
     &  -4.88590,  -4.48730,  -4.22490,  -4.02850,  -3.86690, 
     &  -3.82470,  -3.76520,  -3.65210,  -3.49060,  -3.26130, 
     &  -3.03070,  -2.81560,  -2.61720,  -2.42640,  -2.24420, 
     &  -2.07750,  -1.94320,  -1.87030,  -1.85230,  -1.85520, 
     &  -1.84430,  -1.78140,  -1.71040,  -1.70430,  -1.79520, 
     &  -2.02050,  -2.39680,  -2.93740,  -3.76890,  -5.31590/
      data cpn2o(601:700)/
     &  -7.41390,  -9.51190,  -9.79650,  -9.15110,  -8.50570, 
     &  -7.86030,  -7.21490,  -6.56950,  -6.24150,  -5.58290, 
     &  -5.02960,  -4.56600,  -4.17220,  -3.83640,  -3.55510, 
     &  -3.33980,  -3.19700,  -3.13630,  -3.12320,  -3.12570, 
     &  -3.09990,  -3.02880,  -2.97460,  -2.98750,  -3.09250, 
     &  -3.31370,  -3.64960,  -4.02760,  -4.19580,  -3.97600, 
     &  -3.61790,  -3.27250,  -2.96530,  -2.69620,  -2.46770, 
     &  -2.28280,  -2.15470,  -2.09490,  -2.07630,  -2.06060, 
     &  -2.01420,  -1.92390,  -1.86180,  -1.88130,  -2.00990, 
     &  -2.28250,  -2.70710,  -3.32770,  -4.33000,  -6.21510, 
     &  -8.35430, -10.00000,  -9.72750,  -9.12570,  -8.52390, 
     &  -7.92210,  -7.32030,  -6.71850,  -6.60890,  -5.88770, 
     &  -5.45270,  -5.08790,  -4.65980,  -4.38060,  -4.18300, 
     &  -4.04260,  -4.01750,  -4.01780,  -3.98110,  -3.92440, 
     &  -3.80560,  -3.69680,  -3.64350,  -3.63260,  -3.63390, 
     &  -3.61570,  -3.54780,  -3.48260,  -3.48070,  -3.56650, 
     &  -3.76500,  -4.07180,  -4.39800,  -4.50750,  -4.33580, 
     &  -4.07650,  -3.86740,  -3.72210,  -3.65880,  -3.64290, 
     &  -3.63710,  -3.60140,  -3.52090,  -3.46160,  -3.47740, 
     &  -3.59570,  -3.84810,  -4.25980,  -4.87840,  -5.82660/
      data cpn2o(701:704)/
     &  -6.74680,  -8.13520,  -9.22080, -10.00000/

c --- double exponential fit parameters for o2   

      data cpo2(1:100)/
     &  -6.13630,  -6.17940,  -6.25380,  -6.37050,  -6.51100, 
     &  -6.61620,  -6.75050,  -6.78960,  -6.83050,  -6.84710, 
     &  -6.82820,  -6.87720,  -6.86800,  -6.93320,  -6.95110, 
     &  -7.00480,  -7.06620,  -7.10430,  -7.20550,  -7.24430, 
     &  -7.35200,  -7.40790,  -7.49980,  -7.59240,  -7.66820, 
     &  -7.79930,  -7.87120,  -8.01610,  -8.11020,  -8.24850, 
     &  -8.37580,  -8.49420,  -8.65320,  -8.75540,  -8.94530, 
     &  -9.06650,  -9.26310,  -9.43870,  -9.63250,  -9.87570, 
     & -10.06280, -10.37610, -10.54780, -10.91470, -11.20520, 
     & -11.51290, -11.82060, -12.12830, -12.43600, -12.74370, 
     & -13.05140, -13.35910, -13.66680, -13.97450, -13.94580, 
     & -13.76920, -13.50480, -13.14220, -13.02420, -12.66840, 
     & -12.35710, -12.24280, -11.84920, -11.64270, -11.51730, 
     & -11.21080, -11.15840, -11.01960, -10.80400, -10.80590, 
     & -10.58280, -10.45800, -10.41700, -10.18230, -10.14350, 
     & -10.00300,  -9.81360,  -9.77720,  -9.56800,  -9.45950, 
     &  -9.35020,  -9.14110,  -9.04760,  -8.86280,  -8.70510, 
     &  -8.58380,  -8.42820,  -8.32710,  -8.19580,  -8.08380, 
     &  -7.96520,  -7.83710,  -7.74760,  -7.64310,  -7.57360, 
     &  -7.51490,  -7.41940,  -7.26880,  -7.07220,  -6.88150/
      data cpo2(101:200)/
     &  -6.76270,  -6.80550,  -6.91140,  -6.99360,  -7.05190, 
     &  -7.05970,  -7.06800,  -7.12420,  -7.20880,  -7.32650, 
     &  -7.46730,  -7.63260,  -7.81100,  -8.00960,  -8.21040, 
     &  -8.40360,  -8.58530,  -8.72520,  -8.85110,  -8.94270, 
     &  -9.03750,  -9.12280,  -9.22460,  -9.32910,  -9.44360, 
     &  -9.57160,  -9.69510,  -9.84080,  -9.97590, -10.14890, 
     & -10.30270, -10.51780, -10.72650, -10.97870, -11.29390, 
     & -11.55520, -11.95950, -12.24360, -12.69420, -13.20110, 
     & -13.81910, -13.92160, -13.72930, -13.53700, -13.34470, 
     & -13.15230, -12.96000, -12.76770, -12.57540, -12.38300, 
     & -12.19070, -11.99480, -11.77590, -11.59260, -11.42140, 
     & -11.24930, -11.10940, -10.94770, -10.83320, -10.73230, 
     & -10.63800, -10.57250, -10.44090, -10.20130,  -9.88390, 
     &  -9.65460,  -9.50530,  -9.46380,  -9.55260,  -9.65580, 
     &  -9.74300,  -9.79580,  -9.78960,  -9.83200,  -9.94470, 
     & -10.12210, -10.37070, -10.66230, -10.97610, -11.22710, 
     & -11.40910, -11.49210, -11.60150, -11.69450, -11.83330, 
     & -11.99850, -12.17880, -12.38220, -12.66050, -13.07960, 
     & -13.35280, -13.64630, -13.93980, -13.70340, -13.31500, 
     & -13.11770, -12.64620, -12.48680, -12.22050, -11.96500/
      data cpo2(201:300)/
     & -11.69410, -11.43770, -11.21360, -10.95670, -10.79800, 
     & -10.55460, -10.39520, -10.24030, -10.04910,  -9.92260, 
     &  -9.78710,  -9.65570,  -9.61060,  -9.51420,  -9.47630, 
     &  -9.41630,  -9.23480,  -9.10880,  -8.79460,  -8.58760, 
     &  -8.31280,  -8.09450,  -7.91270,  -7.72290,  -7.58600, 
     &  -7.42150,  -7.27260,  -7.11790,  -6.95160,  -6.80750, 
     &  -6.64130,  -6.50430,  -6.35190,  -6.21120,  -6.08390, 
     &  -5.93370,  -5.83210,  -5.69690,  -5.59230,  -5.50760, 
     &  -5.40020,  -5.34130,  -5.28260,  -5.24580,  -5.28770, 
     &  -5.37430,  -5.46540,  -5.52620,  -5.44290,  -5.24300, 
     &  -5.02840,  -4.84640,  -4.75340,  -4.78250,  -4.94620, 
     &  -5.22900,  -5.64400,  -6.18890,  -6.84270,  -7.77310, 
     &  -9.16880,  -9.68930, -10.18530, -10.76700, -11.46110, 
     & -12.30810, -13.14760, -13.81920, -13.58710, -13.21890, 
     & -12.97050, -12.48250, -12.13010, -11.94300, -11.66360, 
     & -11.31970, -11.16780, -10.89670, -10.60020, -10.48570, 
     & -10.19860,  -9.97310,  -9.85470,  -9.58170,  -9.43820, 
     &  -9.30420,  -9.07550,  -8.99440,  -8.80600,  -8.65430, 
     &  -8.54410,  -8.35560,  -8.25570,  -8.09590,  -7.97170, 
     &  -7.84530,  -7.70760,  -7.59100,  -7.45670,  -7.34390/
      data cpo2(301:382)/
     &  -7.22480,  -7.12360,  -7.02090,  -6.93450,  -6.84040, 
     &  -6.75600,  -6.67440,  -6.58700,  -6.52780,  -6.48090, 
     &  -6.50420,  -6.57970,  -6.65640,  -6.69390,  -6.59120, 
     &  -6.37760,  -6.14380,  -6.00620,  -6.04690,  -6.30810, 
     &  -6.81990,  -7.43070,  -8.13450,  -9.11900, -10.42030, 
     & -11.46980, -12.59420, -13.53160, -13.86930, -13.93920, 
     & -13.68850, -13.43770, -13.18690, -12.93620, -12.68540, 
     & -12.37200, -12.28520, -11.93310, -11.75750, -11.62970, 
     & -11.32900, -11.12050, -11.00840, -10.72430, -10.55430, 
     & -10.44850, -10.17640, -10.07590,  -9.93040,  -9.71960, 
     &  -9.66300,  -9.47740,  -9.36380,  -9.26750,  -9.11210, 
     &  -9.03680,  -8.90250,  -8.80280,  -8.70120,  -8.59090, 
     &  -8.51210,  -8.41410,  -8.34440,  -8.26870,  -8.20030, 
     &  -8.15710,  -8.11410,  -8.12610,  -8.18480,  -8.23950, 
     &  -8.24780,  -8.08770,  -7.78800,  -7.56110,  -7.44870, 
     &  -7.48800,  -7.76440,  -8.21420,  -8.87650, -10.10910, 
     & -12.44830, -13.72280/

c --- double exponential fit parameters for nh3  

      data cpnh3(1:100)/
     &  -5.71420,  -5.28540,  -4.51630,  -3.97950,  -3.43930, 
     &  -2.87350,  -2.49470,  -2.22900,  -2.06240,  -1.96160, 
     &  -1.87070,  -1.77120,  -1.64730,  -1.53760,  -1.43150, 
     &  -1.33280,  -1.23910,  -1.17680,  -1.13020,  -1.07550, 
     &  -1.02720,  -0.98840,  -0.95010,  -0.92870,  -0.91010, 
     &  -0.89820,  -0.88880,  -0.87090,  -0.86200,  -0.86450, 
     &  -0.86760,  -0.89100,  -0.90840,  -0.93280,  -0.95460, 
     &  -0.97430,  -0.99830,  -1.02020,  -1.05690,  -1.08240, 
     &  -1.10860,  -1.14750,  -1.17900,  -1.20590,  -1.26680, 
     &  -1.32370,  -1.38010,  -1.42710,  -1.49200,  -1.54030, 
     &  -1.58480,  -1.64980,  -1.73820,  -1.82940,  -1.92030, 
     &  -2.06940,  -2.21340,  -2.36220,  -2.55160,  -2.76330, 
     &  -2.93440,  -3.11720,  -3.35430,  -3.56710,  -3.75040, 
     &  -3.98840,  -4.26330,  -4.55050,  -4.78370,  -5.03500, 
     &  -5.37330,  -5.64780,  -5.88560,  -6.10410,  -6.33750, 
     &  -6.57090,  -6.80430,  -7.03770,  -7.26200,  -7.09500, 
     &  -6.92790,  -6.76080,  -6.59380,  -6.42670,  -6.25970, 
     &  -6.09260,  -5.88420,  -5.75600,  -5.58440,  -5.42480, 
     &  -5.25730,  -5.07710,  -4.92440,  -4.79030,  -4.65120, 
     &  -4.51690,  -4.39610,  -4.26070,  -4.17050,  -4.12940/
      data cpnh3(101:200)/
     &  -4.06110,  -3.95380,  -3.88210,  -3.75920,  -3.67540, 
     &  -3.68300,  -3.69770,  -3.69250,  -3.66320,  -3.58990, 
     &  -3.52180,  -3.52650,  -3.65350,  -3.80680,  -3.98180, 
     &  -4.05740,  -3.97890,  -3.88580,  -3.81200,  -3.89270, 
     &  -3.87990,  -3.86230,  -3.39840,  -2.88570,  -2.58140, 
     &  -2.40660,  -2.38500,  -2.54150,  -2.81610,  -3.22650, 
     &  -3.71770,  -3.99320,  -4.06830,  -4.07850,  -3.99120, 
     &  -3.74180,  -3.47420,  -3.26510,  -3.07150,  -2.95000, 
     &  -2.86690,  -2.77230,  -2.66140,  -2.56130,  -2.43720, 
     &  -2.30850,  -2.16960,  -2.03020,  -1.91660,  -1.80710, 
     &  -1.72210,  -1.63700,  -1.54530,  -1.44870,  -1.35390, 
     &  -1.25700,  -1.16180,  -1.11310,  -1.08240,  -1.05590, 
     &  -1.01900,  -0.97210,  -0.92180,  -0.86800,  -0.85560, 
     &  -0.85680,  -0.87130,  -0.89840,  -0.90760,  -0.90240, 
     &  -0.88820,  -0.89680,  -0.94920,  -1.00890,  -1.08460, 
     &  -1.15560,  -1.17920,  -1.19460,  -1.19640,  -1.21730, 
     &  -1.24240,  -1.17440,  -0.97430,  -0.63500,  -0.29750, 
     &  -0.07050,   0.01440,  -0.09780,  -0.35360,  -0.56300, 
     &  -0.54790,  -0.37840,  -0.17970,  -0.11510,  -0.30850, 
     &  -0.61800,  -0.97180,  -1.29260,  -1.27480,  -1.12170/
      data cpnh3(201:300)/
     &  -1.01970,  -0.93000,  -0.88170,  -0.87230,  -0.83090, 
     &  -0.78040,  -0.70750,  -0.64310,  -0.61760,  -0.60120, 
     &  -0.60790,  -0.62720,  -0.63040,  -0.61930,  -0.60260, 
     &  -0.58820,  -0.60290,  -0.63170,  -0.68620,  -0.74470, 
     &  -0.79210,  -0.82750,  -0.85950,  -0.88560,  -0.92360, 
     &  -0.99340,  -1.06930,  -1.14600,  -1.21000,  -1.28630, 
     &  -1.35930,  -1.42920,  -1.50290,  -1.60540,  -1.70670, 
     &  -1.81100,  -1.93500,  -2.03460,  -2.13050,  -2.22940, 
     &  -2.37240,  -2.49170,  -2.62180,  -2.80560,  -2.96930, 
     &  -3.11010,  -3.27900,  -3.53150,  -3.70110,  -3.89520, 
     &  -4.15270,  -4.41210,  -4.52440,  -4.85990,  -5.19400, 
     &  -5.55890,  -5.81700,  -6.14020,  -6.46330,  -6.78650, 
     &  -7.10960,  -7.43280,  -7.75590,  -8.00000,  -7.81990, 
     &  -7.59880,  -7.37780,  -7.15670,  -6.93570,  -6.71460, 
     &  -6.49360,  -6.27250,  -6.05150,  -5.83040,  -5.59630, 
     &  -5.38830,  -5.23190,  -5.05360,  -4.90290,  -4.77890, 
     &  -4.58670,  -4.34140,  -4.13990,  -3.97840,  -3.75530, 
     &  -3.57730,  -3.41230,  -3.22540,  -3.03840,  -2.92430, 
     &  -2.77550,  -2.58090,  -2.47260,  -2.32060,  -2.12090, 
     &  -2.03310,  -1.90160,  -1.74580,  -1.69270,  -1.59580/
      data cpnh3(301:400)/
     &  -1.48630,  -1.44920,  -1.37300,  -1.28590,  -1.25540, 
     &  -1.21290,  -1.16890,  -1.18020,  -1.19480,  -1.18820, 
     &  -1.21850,  -1.24640,  -1.25220,  -1.29460,  -1.35870, 
     &  -1.39710,  -1.44880,  -1.52610,  -1.54950,  -1.54780, 
     &  -1.49260,  -1.31150,  -1.04550,  -0.79870,  -0.59720, 
     &  -0.46640,  -0.42440,  -0.44260,  -0.49520,  -0.57720, 
     &  -0.68450,  -0.80970,  -0.94430,  -1.09040,  -1.22320, 
     &  -1.28530,  -1.29490,  -1.27080,  -1.18960,  -1.14670, 
     &  -1.11870,  -1.07000,  -1.03920,  -1.02270,  -1.01780, 
     &  -1.00890,  -1.00210,  -0.97060,  -0.95690,  -0.99280, 
     &  -1.03100,  -1.07670,  -1.10530,  -1.12410,  -1.17170, 
     &  -1.22030,  -1.27720,  -1.33560,  -1.38550,  -1.47340, 
     &  -1.57010,  -1.65720,  -1.76380,  -1.86520,  -1.99180, 
     &  -2.14490,  -2.23880,  -2.32510,  -2.39360,  -2.45250, 
     &  -2.59980,  -2.71470,  -2.77040,  -2.78520,  -2.75240, 
     &  -2.76460,  -2.85070,  -3.04220,  -3.26420,  -3.52010, 
     &  -3.63280,  -3.76240,  -3.95050,  -4.13990,  -4.30870, 
     &  -4.38590,  -4.42950,  -4.44930,  -4.33170,  -4.18920, 
     &  -4.05450,  -3.93560,  -3.91170,  -4.00010,  -4.06270, 
     &  -4.08330,  -4.09970,  -4.06590,  -4.02640,  -4.08930/
      data cpnh3(401:431)/
     &  -4.18320,  -4.25220,  -4.31820,  -4.39490,  -4.41910, 
     &  -4.45800,  -4.59970,  -4.72820,  -4.83700,  -5.00410, 
     &  -5.16440,  -5.21010,  -5.41450,  -5.51140,  -5.69860, 
     &  -5.80570,  -5.95290,  -6.10000,  -6.24720,  -6.39430, 
     &  -6.54150,  -6.68860,  -6.83580,  -6.98290,  -7.13010, 
     &  -7.27720,  -7.42440,  -7.57150,  -7.71870,  -7.86580, 
     &  -8.00000/

c --- double exponential fit parameters for no   

      data cpno/
     &  -7.92650,  -7.56490,  -7.20330,  -6.84180,  -6.48020, 
     &  -6.06470,  -5.71930,  -5.39550,  -5.14750,  -4.82330, 
     &  -4.51940,  -4.31840,  -3.96640,  -3.70450,  -3.33980, 
     &  -3.03680,  -2.72820,  -2.44480,  -2.17910,  -1.93150, 
     &  -1.70460,  -1.49840,  -1.31330,  -1.14860,  -1.00360, 
     &  -0.87760,  -0.76990,  -0.68110,  -0.61240,  -0.56630, 
     &  -0.54880,  -0.56730,  -0.60760,  -0.67910,  -0.75530, 
     &  -0.78110,  -0.77110,  -0.68400,  -0.57040,  -0.47910, 
     &  -0.41380,  -0.39500,  -0.41890,  -0.47940,  -0.57510, 
     &  -0.70620,  -0.87510,  -1.08520,  -1.34060,  -1.64730, 
     &  -2.00680,  -2.43350,  -2.90680,  -3.45950,  -4.03700, 
     &  -4.67950,  -5.27040,  -5.86130,  -6.45220,  -7.04310, 
     &  -7.63400,  -8.00000/

c --- double exponential fit parameters for no2  

      data cpno2(1:100)/
     &  -6.00000,  -5.84190,  -5.53130,  -5.10480,  -4.95120, 
     &  -4.58300,  -4.26760,  -3.97830,  -3.71500,  -3.47820, 
     &  -3.25410,  -3.05970,  -2.86250,  -2.69890,  -2.53230, 
     &  -2.39040,  -2.25610,  -2.13460,  -2.03200,  -1.92840, 
     &  -1.85840,  -1.77780,  -1.72220,  -1.67760,  -1.60240, 
     &  -1.56580,  -1.49170,  -1.41170,  -1.37060,  -1.30450, 
     &  -1.29140,  -1.32920,  -1.36660,  -1.42680,  -1.45640, 
     &  -1.40760,  -1.32840,  -1.28040,  -1.24970,  -1.25190, 
     &  -1.31230,  -1.37040,  -1.41920,  -1.48780,  -1.53010, 
     &  -1.55750,  -1.59120,  -1.62500,  -1.65440,  -1.68490, 
     &  -1.73400,  -1.77480,  -1.81710,  -1.86790,  -1.92560, 
     &  -1.98090,  -2.03860,  -2.11120,  -2.17690,  -2.24620, 
     &  -2.31990,  -2.41290,  -2.51560,  -2.65750,  -2.88250, 
     &  -3.18310,  -3.62090,  -4.22710,  -5.52900,  -6.00000, 
     &  -6.00000,  -5.54150,  -4.89640,  -4.25130,  -3.60630, 
     &  -2.96120,  -2.17330,  -1.55140,  -1.02600,  -0.58170, 
     &  -0.20300,   0.12310,   0.40980,   0.66530,   0.88850, 
     &   1.07160,   1.20250,   1.26970,   1.29260,   1.30060, 
     &   1.31280,   1.34490,   1.36560,   1.32450,   1.18680, 
     &   0.93100,   0.59070,   0.20560,  -0.23370,  -0.76330/
      data cpno2(101:142)/
     &  -1.45410,  -2.44510,  -3.18220,  -3.91930,  -4.65650, 
     &  -5.39360,  -6.00000,  -6.00000,  -5.76060,  -5.34220, 
     &  -4.92380,  -4.50550,  -4.08710,  -3.66870,  -3.25040, 
     &  -2.83200,  -2.37360,  -1.95650,  -1.57690,  -1.24000, 
     &  -0.93840,  -0.67810,  -0.46300,  -0.29440,  -0.17830, 
     &  -0.12130,  -0.10330,  -0.09340,  -0.07230,  -0.02670, 
     &   0.00160,  -0.03940,  -0.17000,  -0.41410,  -0.78610, 
     &  -1.29510,  -2.03790,  -3.09840,  -3.86920,  -4.63990, 
     &  -5.41070,  -6.00000/

c --- double exponential fit parameters for so2  

      data cpso2(1:100)/
     &  -0.93120,  -0.81010,  -0.57290,  -0.35900,  -0.20160, 
     &  -0.09710,  -0.03330,   0.00480,   0.02280,   0.02140, 
     &  -0.00440,  -0.05670,  -0.13340,  -0.23150,  -0.34510, 
     &  -0.47410,  -0.61980,  -0.78540,  -0.97640,  -1.19220, 
     &  -1.43260,  -1.69510,  -1.96870,  -2.27880,  -2.60340, 
     &  -2.93980,  -3.35510,  -3.77040,  -4.18570,  -4.60100, 
     &  -5.01630,  -5.43160,  -5.84690,  -6.26220,  -6.67750, 
     &  -7.09280,  -7.50810,  -7.92340,  -8.00000,  -7.42090, 
     &  -6.69940,  -5.97780,  -5.25630,  -4.42480,  -3.73690, 
     &  -3.09170,  -2.52000,  -2.03030,  -1.63070,  -1.30560, 
     &  -1.03730,  -0.81890,  -0.63950,  -0.48800,  -0.35740, 
     &  -0.23690,  -0.12370,  -0.02610,   0.02500,   0.01860, 
     &  -0.01940,  -0.06590,  -0.06380,  -0.00650,   0.04680, 
     &   0.06820,   0.03550,  -0.04310,  -0.13340,  -0.21750, 
     &  -0.29540,  -0.37380,  -0.45880,  -0.55710,  -0.67290, 
     &  -0.81310,  -0.98050,  -1.18310,  -1.43340,  -1.73540, 
     &  -2.10650,  -2.57050,  -3.12380,  -3.76910,  -4.57930, 
     &  -5.70120,  -6.56030,  -7.41950,  -8.00000,  -7.93020, 
     &  -7.65630,  -7.38240,  -7.10850,  -6.83460,  -6.56070, 
     &  -6.28680,  -6.01290,  -5.73900,  -5.46510,  -5.19120/
      data cpso2(101:200)/
     &  -4.91730,  -4.64340,  -4.36950,  -4.09560,  -3.82170, 
     &  -3.54780,  -3.27390,  -3.00000,  -2.72610,  -2.45220, 
     &  -2.17830,  -1.93170,  -1.70730,  -1.50040,  -1.31360, 
     &  -1.14440,  -0.99010,  -0.85050,  -0.72380,  -0.60830, 
     &  -0.50250,  -0.40160,  -0.30470,  -0.21120,  -0.12630, 
     &  -0.06560,  -0.04140,  -0.05090,  -0.07310,  -0.08020, 
     &  -0.04830,   0.00320,   0.03390,   0.02490,  -0.02960, 
     &  -0.11700,  -0.21410,  -0.30690,  -0.39680,  -0.48810, 
     &  -0.58810,  -0.70190,  -0.82990,  -0.97290,  -1.13050, 
     &  -1.30360,  -1.49240,  -1.70000,  -1.93060,  -2.19060, 
     &  -2.49590,  -2.86130,  -3.31760,  -3.92360,  -4.68470, 
     &  -5.25610,  -4.70820,  -4.11100,  -3.65820,  -3.19630, 
     &  -2.70630,  -1.96430,  -1.30890,  -0.68560,  -0.04120, 
     &   0.36780,   0.67120,   0.90310,   1.05770,   1.11450, 
     &   1.12720,   1.13000,   1.12370,   1.14590,   1.10470, 
     &   0.96170,   0.71070,   0.32540,  -0.23220,  -1.06120, 
     &  -1.77150,  -2.60890,  -3.02250,  -3.35420,  -3.73390, 
     &  -4.19860,  -4.78520,  -5.63900,  -6.27400,  -6.90910, 
     &  -7.54410,  -8.00000,  -8.00000,  -7.56980,  -6.88150, 
     &  -6.19330,  -5.35300,  -4.86020,  -4.12860,  -2.99220/
      data cpso2(201:226)/
     &  -2.35250,  -1.89050,  -1.51780,  -1.22950,  -1.00820, 
     &  -0.84840,  -0.76340,  -0.73400,  -0.72030,  -0.71670, 
     &  -0.70970,  -0.72970,  -0.83910,  -1.04720,  -1.36070, 
     &  -1.77200,  -2.29570,  -3.05660,  -4.10730,  -4.53370, 
     &  -4.94810,  -5.45420,  -6.24450,  -6.81480,  -7.38500, 
     &  -7.95530/

c     wavenumber-low and wavenumber-high specify a band region
c     for a molecular absorber.  -999 indicates the end of
c     absorption bands for any specific absorber.

c --- wavelength index limits for h2o 

      data iwlh2o/
     &      0,    350,   1005,   1645,   2535,   3425,   4315, 
     &   6155,   8005,   9620,  11545,  13075,  14865,  16340, 
     &   -999/
      data iwhh2o/
     &    345,   1000,   1640,   2530,   3420,   4310,   6150, 
     &   8000,   9615,  11540,  13070,  14860,  16045,  17860, 
     &   -999/

c --- wavelength index limits for o3  

      data iwlo3/
     &      0,    515,   1630,   2670,   2850,   -999/
      data iwho3/
     &    200,   1275,   2295,   2845,   3260,   -999/

c --- wavelength index limits for co2 

      data iwlco2/
     &    425,    840,   1805,   3070,   3760,   4530,   5905, 
     &   7395,   8030,   9340,   -999/
      data iwhco2/
     &    835,   1440,   2855,   3755,   4065,   5380,   7025, 
     &   7785,   8335,   9670,   -999/

c --- wavelength index limits for co  

      data iwlco/
     &      0,   1940,   4040,   -999/
      data iwhco/
     &    175,   2285,   4370,   -999/

c --- wavelength index limits for ch4 

      data iwlch4/
     &   1065,   2345,   4110,   5865,   -999/
      data iwhch4/
     &   1775,   3230,   4690,   6135,   -999/

c --- wavelength index limits for n2o 

      data iwln2o/
     &      0,    490,    865,   1065,   1545,   2090,   2705, 
     &   3245,   4260,   4540,   4910,   -999/
      data iwhn2o/
     &    120,    775,    995,   1385,   2040,   2655,   2865, 
     &   3925,   4470,   4785,   5165,   -999/

c --- wavelength index limits for o2  

      data iwlo2/
     &      0,   7650,   9235,  12850,  14300,  15695,   -999/
      data iwho2/
     &    265,   8080,   9490,  13220,  14600,  15955,   -999/

c --- wavelength index limits for nh3 

      data iwlnh3/
     &      0,    390,   -999/
      data iwhnh3/
     &    385,   2150,   -999/

c --- wavelength index limits for no  

      data iwlno/
     &   1700,   -999/
      data iwhno/
     &   2005,   -999/

c --- wavelength index limits for no2 

      data iwlno2/
     &    580,   1515,   2800,   -999/
      data iwhno2/
     &    925,   1695,   2970,   -999/

c --- wavelength index limits for so2 

      data iwlso2/
     &      0,    400,    950,   2415,   -999/
      data iwhso2/
     &    185,    650,   1460,   2580,   -999/

      end module gasblk
c=======================================================================
      subroutine kdistr(nz,mxly,mxq,uu,dtauk,tauk,wtk,twgp)

c   PURPOSE: compute 3 component k-distribution optical depths
c            and weights.  The parameters in /aabbcc/
c            are set up by routine TAUGAS, which should be called
c            before KDISTR at each new wavelength.
c
c   input parameters:
c   ----------------
c     nz       number of active layers
c     mxly     dimensioned size of first subscript of dtauk,tauk,wtk,twgp
c     mxq      dimensioned size of first subscript of uu
c     uu       absorption integrals from ABSINT 
c
c   output parameters:
c   -----------------
c   dtauk(nz,3)   molecular optical thickness of layer n, term k 
c   tauk(nz,3)    cumulative optical depth upto layer n, term k
c   wtk(nz,3)     layer by layer weighting for k-distribution fit
c     
c
c   internal working array (dimensioned in calling routine)
c   -------------------------------------------------------
c   twgp(nz,3)  - sum of optical depth * probability by molecule
c
c   new varables          11 molecules  by joseph h pierluissi
c   dpwj  probability for each molecule  fit double exponential
c   gkwj  band dependent  scaling of densitys to get k  amount
c   cps is the stored values of Pierluissi band model coefficients
c   cp1s = 10**cps
c   ibnd maps bands to molecules
c   wtk  is the  effective probability by layer
c   dtaum is defined as the sum of the optical depths by molecule

      use params, only: kr
      use gasblk, only: bma,bmb,bmc,bms,cps,ibnd
      implicit none

      integer, parameter :: nk=3

      integer :: mxly, mxq, m, k, mol, iw, n, nz, nm, ib

      real(kr) ::  dtauk(mxly,nk), tauk(mxly,nk), wtk(mxly,nk),
     &     twgp(mxly,nk), fac(nk),gkwj(nk,11),dpwj(nk,11),cp1s(11),
     &     taudb(11), uu(mxq,mxly), dpc, taukk, duu, wpth, smwtk

      data fac /1.0,0.09,0.015/

cccc

      dpc = 1./3.
      
      do 20 m = 1,11
        cp1s(m)= 10.**cps(m)
        taudb(m)=0.
 20   continue

      do  40   k = 1,nk
        do  30  mol = 1,11
          iw = ibnd(mol)
          gkwj(k,mol) = 0.
          dpwj(k,mol) = 0.
          if(iw .gt. 0) then
            gkwj(k,mol) = fac(k) * bmc(mol)
            if(k .eq. 1) dpwj(k,mol)=bma(mol)
            if(k .eq. 2) dpwj(k,mol)=bmb(mol)
            if(k .eq. 3) dpwj(k,mol)=1.-bma(mol)-bmb(mol)
          endif
 30     continue
 40   continue
      
c   evaluate the weighted k distribution quantities for
c   water vapor, ozone and uniformly mixed gases

      taukk=0.
      do 80 k=1, nk
        do 70 n=1,nz
          tauk(n,k)=0.
          dtauk(n,k)= 0.
          nm=nz-n+1

          twgp(n,k)=0.
          do 60 mol=1,11
            ib = ibnd(mol)
            if(ib.lt.0) go to 60
            if(nm.eq.nz) then
              duu=uu(ib,nm)
            else
              duu=uu(ib,nm)-uu(ib,nm+1)
            endif
            wpth = duu*gkwj(k,mol)
            dtauk(n,k)=dtauk(n,k)+wpth*cp1s(mol)
            twgp(n,k)=twgp(n,k)+wpth*cp1s(mol)*dpwj(k,mol)
 60       continue
          
          wtk(n,k) = dpc
          if(dtauk(n,k).ne.0) wtk(n,k)=twgp(n,k)/dtauk(n,k)
          
c     effective probability by layer, wtk is based on 
c     molecular probability weighted by optical depth
          
 70     continue
 80   continue
      
      do 100 n=1,nz
        smwtk = wtk(n,1) + wtk(n,2) + wtk(n,3)
        if(smwtk .eq. .0) write(8, *) 'smwtk == 0'
        do 90 k=1, nk
          wtk(n,k) = wtk(n,k)/smwtk
          if(n.eq.1) then
            tauk(n,k) = dtauk(n,k)
          else
            tauk(n,k) = dtauk(n,k)+tauk(n-1,k)
          endif
 90     continue
 100  continue
      
      return
      end

c=======================================================================

      subroutine absint(uu,nz,z,p,t,wh,wo,idb)
c
c     calculates absorber integrals from top to bottom of atmosphere
c
c    input:  nz         number of atmospheric layers
c            z          layer altitudes
c            p          pressure in mb
c            t          temperature in kelvin 
c            wh         water vapor mass density in g/m3
c            wo         o3 mass density in g/m3
c            idb        if non-zero, write diagnostic print out 
c
c    output: uu         absorption integrals
c
c
c     k      absorption process
c    ----    --------------------------------------
c     1-2    temp dep o2  1395 to 1760
c     3      o2*o2 and o2*n2 continuum (solomon et al 1998) 
c     4      n2 continuum
c     5      h2o self broadened continuum at 296 k
c     6      molecular (rayliegh) scattering
c     7      not used
c     8      ultraviolet and visible ozone
c     9      h2o self continuum 296-260  (tx(9) total trans)
c    10      h2o foriegn continuum
c    11      hno3 (nitric acid)
c    12-16   not used
c    17-30   h2o (line absorption) (double exponential models)
c    31-35   o3  (line absorption) (double exponential models)
c    36-43   co2 (line absorption) (double exponential models)
c    44-45   co  (line absorption) (double exponential models)
c    46      ch4 (line absorption) (double exponential models)
c    47      n2o (line absorption) (double exponential models)
c    50-51   o2  (line absorption) (double exponential models)
c    52-53   nh3 (line absorption) (double exponential models)
c    54      no  (line absorption) (double exponential models)
c    55      no2 (line absorption) (double exponential models)
c    56-57   so2 (line absorption) (double exponential models)
c    58      o2  hertzberg continuum (uv)
c    59-60   temp dep o3
c    61-62   not used
c    63      o2  1395 to 1760

      use params, only: mxly,mxq,one,zero,pzero,tzero,alosch,pmo,kr

      implicit none      

      real(kr), parameter :: 
     &                   xlosch=alosch*1.e5, 
     &                   conjoe=0.1/alosch,  
     &                   con=3.3429e21,      
     &                   rhzero=tzero/296.0  

c conjoe = 1.e5(cm/km) * 1.e-6(ppmv) / alosch
c con    = 0.1/molecular_mass_of_h2o 
c          con/xlosch = conversion from g/m3 => density in loschmidts



      real(kr) ::  z(mxly), p(mxly), t(mxly), wh(mxly), wo(mxly),
     &     uu(mxq,mxly), dd(mxq,mxly), tt, vfo3, vfn2, vfo2, vfco2,
     &     vfch4, vfn2o, vfco, vfno2, vfso2, vfnh3, vfno, vfhno3, pp,
     &     pss, tss, f1, f2, wair, rhoair, rhoh2o, rhofrn, wo2d, conh2o,
     &     cono3, conco2, conco, conch4, conn2o, conno2, connh3, conno,
     &     conso2, cono2, scfac, airwt, sclht, ztop, ptop, ttop, dz,
     &     tbar, dp, drho, den1, uutop, den2, denmin, denave, du, 
     &     du5=0, du8=0, tfac
      
      integer :: i, nz, idb, j, k
      logical :: ozn
cccc

      uu=0.

      if(maxval(p).eq.0.) return

      do 100 i=1,nz
        call volmix(z(i),vfn2,vfo2,vfco2,vfch4,vfn2o,vfco,
     &       vfno2,vfso2,vfnh3,vfno,vfhno3)
        tt=t(i)
        pp=p(i)
        pss=pp/pzero
        tss=tzero/tt
        f1=(pp/pzero)/(tt/tzero)
        f2=(pp/pzero)*sqrt(tzero/tt)
        wair=alosch*f1

        rhoair=f1
        rhoh2o=con*wh(i)/xlosch     
        rhofrn=rhoair-rhoh2o
        wo2d=conjoe*wair*vfo2*pss
        vfo3=wo(i)/(3*pmo*wair)
c
c                             rhoair - air density in loschmidts
c                             rhoh2o - water vapor density in loschmidts
c                             
c
c vfo3 = o3 volume fraction in parts per million
c
        dd(1,i)=wo2d*tt
        dd(2,i)=wo2d*(tt-220.)**2
        dd(3,i)=f1**2
        dd(4,i)=1.e-6*vfn2*f1*f2
        dd(5,i)=xlosch*rhoh2o**2/rhzero
        dd(6,i)=f1
        dd(8,i)=conjoe*wair*vfo3
        dd(10,i)=xlosch*rhoh2o*rhofrn/rhzero
        dd(11,i)=f1*vfhno3*(1.e-6*1.e5)
        dd(63,i)=wo2d
c
c for h2o
c    wh(i) is in g/m3,  conh2o is in g/cm2/km
c
        conh2o=wh(i)*.1
        dd(17,i)=conh2o*pss**0.9810*tss**( 0.3324) !     0-  345 cm-1 
        dd(18,i)=conh2o*pss**1.1406*tss**(-2.6343) !   350- 1000 cm-1 
        dd(19,i)=conh2o*pss**0.9834*tss**(-2.5294) !  1005- 1640 cm-1 
        dd(20,i)=conh2o*pss**1.0443*tss**(-2.4359) !  1645- 2530 cm-1 
        dd(21,i)=conh2o*pss**0.9681*tss**(-1.9537) !  2535- 3420 cm-1 
        dd(22,i)=conh2o*pss**0.9555*tss**(-1.5378) !  3425- 4310 cm-1 
        dd(23,i)=conh2o*pss**0.9362*tss**(-1.6338) !  4315- 6150 cm-1 
        dd(24,i)=conh2o*pss**0.9233*tss**(-0.9398) !  6155- 8000 cm-1 
        dd(25,i)=conh2o*pss**0.8658*tss**(-0.1034) !  8005- 9615 cm-1 
        dd(26,i)=conh2o*pss**0.8874*tss**(-0.2576) !  9620-11540 cm-1 
        dd(27,i)=conh2o*pss**0.7982*tss**( 0.0588) ! 11545-13070 cm-1 
        dd(28,i)=conh2o*pss**0.8088*tss**( 0.2816) ! 13075-14860 cm-1 
        dd(29,i)=conh2o*pss**0.6642*tss**( 0.2764) ! 14865-16045 cm-1 
        dd(30,i)=conh2o*pss**0.6656*tss**( 0.5061) ! 16340-17860 cm-1 
c
c for o3
c    cono3 in units of (1.e5 loschmidts)=(1 atm cm/km)=(2.6868e24 cm-3)
c
        cono3 = conjoe*wair*vfo3
        dd(31,i)=cono3 *pss**0.4200*tss**( 1.3909) !     0-  200 cm-1
        dd(32,i)=cono3 *pss**0.4221*tss**( 0.7678) !   515- 1275 cm-1
        dd(33,i)=cono3 *pss**0.3739*tss**( 0.1225) !  1630- 2295 cm-1
        dd(34,i)=cono3 *pss**0.1770*tss**( 0.9827) !  2670- 2845 cm-1
        dd(35,i)=cono3 *pss**0.3921*tss**( 0.1942) !  2850- 3260 cm-1
c
c for co2
c
        conco2= conjoe*wair*vfco2
        dd(36,i)=conco2*pss**0.6705*tss**(-2.2560)
        dd(37,i)=conco2*pss**0.7038*tss**(-5.0768)
        dd(38,i)=conco2*pss**0.7258*tss**(-1.6740)
        dd(39,i)=conco2*pss**0.6982*tss**(-1.8107)
        dd(40,i)=conco2*pss**0.8867*tss**(-0.5327)
        dd(41,i)=conco2*pss**0.7883*tss**(-1.3244)
        dd(42,i)=conco2*pss**0.6899*tss**(-0.8152)
        dd(43,i)=conco2*pss**0.6035*tss**( 0.6026)
c
c for co
c
        conco = conjoe*wair*vfco
        dd(44,i)=conco *pss**0.7589*tss**( 0.6911)
        dd(45,i)=conco *pss**0.9267*tss**( 0.1716)
c
c for ch4
c
        conch4= conjoe*wair*vfch4
        dd(46,i)=conch4*pss**0.7139*tss**(-0.4185)
c
c for n2o
c
        conn2o= conjoe*wair*vfn2o
        dd(47,i)=conn2o*pss**0.3783*tss**( 0.9399)
        dd(48,i)=conn2o*pss**0.7203*tss**(-0.1836)
        dd(49,i)=conn2o*pss**0.7764*tss**( 1.1931)
c
c for o2
c
        cono2 = conjoe*wair*vfo2
        dd(50,i)=cono2 *pss**1.1879*tss**( 2.9738) !     0-  265 cm-1
        dd(51,i)=cono2 *pss**0.9353*tss**( 0.1936) !  7650-52710 cm-1
c
c for nh3
c
        connh3= conjoe*wair*vfnh3
        dd(52,i)=connh3*pss**0.8023*tss**(-0.9111)
        dd(53,i)=connh3*pss**0.6968*tss**( 0.3377)
c
c for no
c
        conno = conjoe*wair*vfno
        dd(54,i)=conno *pss**0.5265*tss**(-0.4702)
c
c for no2
c
        conno2= conjoe*wair*vfno2
        dd(55,i)=conno2*pss**0.3956*tss**(-0.0545)
c
c for so2
c
        conso2= conjoe*wair*vfso2
        dd(56,i)=conso2*pss**0.2943*tss**( 1.2316)
        dd(57,i)=conso2*pss**0.2135*tss**( 0.0733)
c
c   herzberg continuum pressure dependence calculation, shardanand 1977
c      and   yoshino et al 1988
c
        dd(58,i)=(1.+.83*f1)*cono2
c
        if(idb.ne.0) then
          if(i.eq.1) print 800
          print '(i4,0pf9.2,f9.3,f7.1,1x,11es9.2)',
     &       i,z(i),p(i),t(i), dd(17,i),dd(31,i),
     &       dd(36,i),dd(44,i),dd(46,i),dd(47,i),
     &       dd(50,i),dd(52,i),dd(54,i),dd(55,i),dd(56,i)
        endif

 100  continue
c
c absorption integrals
c
      do 120 j=1,nz
        do 110 k=1,mxq
          uu(k,j)=0.
 110    continue
 120  continue
c
c use scale height to get first step of integration
c
      scfac=exp(-1.)
      airwt=(2.66e-23*(vfo2+1.e6-vfn2)+2.24e-23*vfn2)*1.e-6
      sclht=1.e-5*1.38e-16*t(nz)/(airwt*980.67)
c     
      do 200 i=nz,1,-1
        if(i.eq.nz) then
          ztop=2*z(i)-z(i-1)
          ptop=p(i)**2/p(i-1)
          ttop=t(i)
        else
          ztop=z(i+1)
          ptop=p(i+1)
          ttop=t(i+1)
        endif
        dz=ztop-z(i)
        if(p(i).eq.ptop) then 
          tbar=.5*(ttop+t(i))
        else 
          dp=(p(i)-ptop)/log(p(i)/ptop)
          drho=(p(i)/t(i)-ptop/ttop)/log(p(i)*ttop/(ptop*t(i)))
          tbar=dp/drho
        endif
        do 150 k=1,mxq
          den1=dd(k,i)
          if(i.eq.nz) then
            uutop=0.
            den2=dd(k,i)*scfac
          else
            uutop=uu(k,i+1)
            den2=dd(k,i+1)
          endif
          ozn=.false.
          if(k.eq.8) ozn=.true.
          if(k.ge.31.and.k.le.35) ozn=.true.
          if(k.ge.59.and.k.le.60) ozn=.true.
          denmin=min(den1,den2)
          denave=.5*(den1+den2)
          if(denmin.gt.0..and.denmin.lt.0.999*denave.and..not.ozn) then
            du=dz*(den1-den2)/log(den1/den2)
          else
            du=dz*denave
          endif
          if(k.eq.5) du5=du
          if(k.eq.8) du8=du
          if(k.eq.9) then
            tfac=(296.-tbar)/(296.-260.)
            tfac=max(zero,min(one,tfac))
            uu(9,i)=uutop+du5*tfac
          elseif(k.eq.59) then
            uu(59,i)=uutop+.269*du8*(tbar-273.15)
          elseif(k.eq.60) then
            uu(60,i)=uutop+.269*du8*(tbar-273.15)**2
          else
            uu(k,i)=uutop+du
          endif
 150    continue
        if(idb.ne.0) then
          if(i.eq.nz) print 900
          print '(i4,0pf9.2,f9.3,f7.1,1x,11es9.2)',
     &       i,z(i),p(i),t(i), uu(17,i),uu(31,i),
     &       uu(36,i),uu(44,i),uu(46,i),uu(47,i),
     &       uu(50,i),uu(52,i),uu(54,i),uu(55,i),uu(56,i)
        endif

 200  continue
c
 800  format('1',/,'  atmospheric profiles',//,
     + '  (if a molecule has more than one band, then the data for the',
     + ' first band are shown.)'//
     1 '   i      z       p       t      h2o      o3       co2',
     2 '      co       ch4      n2o      o2       nh3      no ',
     3 '      no2      so2'/
     4 '         (km)    (mb)    (k) g/cm**2/km  (            ',
     5 '          atm cm/km                                   ',
     6 '                  )')
 900  format('1',/,'  absorption integrals',//,
     + '  (if a molecule has more than one band, then the data for the',
     + ' first band are shown.)'//
     1 '   i      z       p       t      h2o      o3       co2',
     2 '      co       ch4      n2o      o2       nh3      no ',
     3 '      no2      so2'/
     4 '         (km)    (mb)    (k) g/cm**2     (            ',
     5 '          atm cm                                      ',
     6 '                  )')

      return
      end
c=======================================================================

      subroutine taugas(wl,uu,amu0,nz,z,dtauc,dtaul,idb)
c
c     calculates optical depth due to atmospheric gases and aerosols
c
c  input:  wl        wavelength in microns
c          uu        path integral uu(mxq,nxlayr) computed by ABSINT
c          amu0      cosine of solar zenith angle (at surface)
c          nz        number of atmospheric layers
c                    nz=1  => integration to bottom level only
c          z         heights of atmospheric layers
c          idb       if non-zero print optical depth profiles
c
c  output: 
c          dtauc(k)  the optical depth of a single layer, k, due to 
c                    continuum processes (follows Beer's law).
c
c          dtaul(k)  the negative log of the mean transmission through
c                    a single layer k, due to line absorption (no
c                    continuum processes).  BE AWARE OF THIS: the
c                    negative log of the transmission through a given
c                    layer depends on the column density of absorbers 
c                    above that layer.
c
c          NOTE: the order of the depth layers are reversed in this routine,
c                uu(k,1) will be used to compute the optical depth dtauc(nz)
c                    
c
c                    continuum and line absorption due to 
c
c                    1. uniformly mixed atmospheric gases (co2,n2,o2...), 
c                    2. h2o
c                    3. ozone
c                    4. trace gases.
c
c          gasabs    gas absorption diagnostics at surface, gasabs(9),
c                    due to both line and continuum processes
c                   1    2     3   4    5   6     7    8      9  
c                  h2o  h2o_c co2  o3  n2o  co  ch4  o2+n2  trace
c     
      use params, only: mxq, mxly, kr, pzero, re, grav
      use gasblk, only: cps, iwlh2o, iwhh2o, iwlco2, iwhco2,
     &     iwlo3, iwho3, iwln2o, iwhn2o, iwlco, iwhco, iwlch4, iwhch4,
     &     iwlo2, iwho2, iwlno, iwhno, iwlso2, iwhso2, iwlno2, iwhno2,
     &     iwlnh3, iwhnh3, cph2o, cpco2, cpo3, cpn2o, cpco, cpch4,
     &     cpo2, cpno, cpso2, cpno2, cpnh3, ibnd, bms
      implicit none

      real(kr), parameter ::
     &     bigexp=87.,
     &     airrho=1.273,        ! air density at stp (kg m-3)
     &     awlmax=20.,          ! maximum exponent
     &     amfac=10.*grav*airrho/pzero ! convert scale height to airmass

      integer :: i, nz, indh2o, indo3, indco2, indco, indch4, indn2o,
     &     indo2, indnh3, indno, indno2, indso2, iv, im, k, ib, idb

      real(kr) ::  uu(mxq,nz),w(mxq),dtauc(*),dtaul(*),
     &     tauc(mxly),taul(mxly),z(*), tau(11), amu0, 
     &     wl, v, sh2ot1, fh2o, t0, t1, alpha2, xh2o, vtemp, xd,
     &     radfn0, radfn1, wfac, ya, yb, fdg, abn2, abno3, abo2,
     &     sigo20, sigo2a, sigo2b, sigo4, doz1, doz2, doz3, c0,
     &     ct1, ct2, abo3a, sh2ot0, rayla, zim, zi, zbar, tcunif,
     &     tch2o, tco3, tctrc, cp, awl, gasabs(9)

      real(kr), external :: raysig
      logical, save :: first=.true.

      data indh2o,indo3,indco2,indco,indch4/5*1./
      data indn2o,indo2,indnh3,indno,indno2,indso2/6*1./
      


cccc
      do 10 i=1,nz
        tauc(i)=0.
        taul(i)=0.
 10   continue

c convert from wavelength in microns to wavenumber in cm-1

      iv=5*(int(10000.0/wl)/5)
      v=float(iv)
      v=10000./wl

c water continuum (v < 10000 cm-1)
c slf296 loads self-broadened water vapor continuum at 296k
c slf260 loads self-broadened water vapor continuum at 296k
c frn296 loads foreign-broadened water vapor continuum at 296k

      call slf296(v,sh2ot0)
      call slf260(v,sh2ot1)
      call frn296(v,fh2o)
      t0=296.
      t1=260.
      if(sh2ot0.gt.0.) then
        alpha2=200.**2
        xh2o=(1.-0.2333*(alpha2/((v-1050.)**2+alpha2)) )
        sh2ot0=sh2ot0*xh2o
        sh2ot1=sh2ot1*xh2o
      endif

c protect against exponential underflow at high frequency

      vtemp=v/0.6952
      if(vtemp/t1.le.bigexp) then
        xd=exp(-v/(t0*0.6952))
        radfn0=v*(1.-xd)/(1.+xd)
        xd=exp(-v/(t1*0.6952))
        radfn1=v*(1.-xd)/(1.+xd)
      else
        radfn0=v
        radfn1=v
      endif

      wfac=1.e-20
      ya=exp(-log(1.025*3.159e-8)+(2.75e-4)*v)
      yb=exp(-log(8.97e-6)+(1.300e-3)*v)
      fdg=1./(ya+yb)

c  n2 continuum absorption coefficient (2080 < v < 2740)

      call c4dta(abn2,v)

c hno3 absorption calculation (850 < v < 1735)

      call hno3(v,abno3)

c hertda computes hertzburg uv o2 absorption ( v > 36000 )  
c o2cont computes o2 continuum ( 1395 < v < 1760 )

      call hertda(abo2,v)
      call o2cont(v,sigo20,sigo2a,sigo2b)

c o2 * o2 collision-radiative process 

      call o4cont(wl,sigo4)

c diffuse ozone

c o3uv computes uv ozone for 40800-54054cm-1 (185-245nm)

c o3hht ozone hartley band for 24370-40800 cm-1 (245-410 nm)
c   temperature dependent coefficient

c c8dta ozone chappius band for 13000-24200 cm-1 (413-769nm)


      doz1=0.
      doz2=0.
      doz3=0.
      if(v.gt.40800) then       ! wl < 0.245um
        call o3uv(v,c0)
        doz1=.269*c0
      elseif(v.gt.24370) then   ! wl < 0.410
        call o3hht(v,c0,ct1,ct2)
        doz1=.269*c0
        doz2=c0*ct1
        doz3=c0*ct2
      elseif(v.ge.13000. .and. v.le.24200) then ! 0.413 < wl < 0.76923
        call c8dta(abo3a,v)
        doz1=abo3a
      endif

c rayleigh scattering (included here for print out only)

      rayla=raysig(v)

c cxdta locates coefficient for double exponential

      call cxdta(cps(1),v,iwlh2o,iwhh2o,cph2o,indh2o)
      call cxdta(cps(2),v,iwlco2,iwhco2,cpco2,indco2)
      call cxdta(cps(3),v,iwlo3, iwho3, cpo3, indo3 )
      call cxdta(cps(4),v,iwln2o,iwhn2o,cpn2o,indn2o)
      call cxdta(cps(5),v,iwlco, iwhco, cpco, indco )
      call cxdta(cps(6),v,iwlch4,iwhch4,cpch4,indch4)
      call cxdta(cps(7),v,iwlo2, iwho2, cpo2, indo2 )
      call cxdta(cps(8),v,iwlno, iwhno, cpno, indno )
      call cxdta(cps(9),v,iwlso2,iwhso2,cpso2,indso2)
      call cxdta(cps(10),v,iwlno2,iwhno2,cpno2,indno2)
      call cxdta(cps(11),v,iwlnh3,iwhnh3,cpnh3,indnh3)

c  abcdta moves double exponential coefficients to new bm? arrays

      call abcdta(iv)

c schrun computes uv o2 schumann-runge band model parameters

      if(v.gt.49600) call schrun(v,cps(7))

      zim=z(nz)
      do 40 i=nz,1,-1
        im=nz-i+1
        zi=z(i)
        zbar=0.5*(zi+zim)
        zim=zi
        do 20 k=1,mxq
          if (i .eq. nz) then
            w(k)=uu(k,i)/amuz(zi)
          else
            w(k)=w(k)+(uu(k,i)-uu(k,i+1))/amuz(zbar)
          endif
 20     continue

        tcunif=+sigo4*w(3)
     &         +abn2*w(4)
     &         +sigo20*(w(63)
     &         +sigo2a*(w(1)-220*w(63))
     &         +sigo2b*w(2))
     &         +abo2*w(58)

        tch2o=sh2ot0*radfn0*(wfac*w(5))
     &        +((sh2ot1*radfn1)-(sh2ot0*radfn0))*(wfac*w(9))
     &        +(fh2o+fdg)*radfn0*(wfac*w(10))

        tco3=doz1*w(8)+doz2*w(59)+doz3*w(60)
        tctrc=abno3*w(11)

c  compute transmitance from double exponential band model for
c       1    2    3    4    5    6    7    8    9   10   11
c      h2o, co2,  o3, n2o,  co, ch4,  o2,  no, so2, no2, nh3

        tauc(im)=tcunif+tch2o+tco3+tctrc

c        write(*,'(a/(10i11))') 'ibnd:',(ibnd(k),k=1,11)
c        write(*,'(a/(10es11.3))') 'cps:',(cps(k),k=1,11)
c        write(*,'(a/(10es11.3))') 'w:',(w(ibnd(k)),k=1,11)

        do k=1,11
          ib=ibnd(k)
          if(ib.gt.0) then 
            cp=cps(k)
            if(cp.gt.-awlmax .and. w(ib).gt.1.e-20) then
              awl=bms(k)*(cp+log10(w(ib)))
              awl=min(awl,awlmax)              
              tau(k)=10.**awl
            else
              tau(k)=0.
            endif
            taul(im)=taul(im)+tau(k)
          endif
        enddo

c  gas absorption diagnostics in gasabs(9)
c    1    2      3   4    5   6     7      8    9   
c   h2o  h2o_c  co2  o3  n2o  co  ch4  o2+n2  trace 

        gasabs(1)=tau(1)
        gasabs(2)=tch2o
        gasabs(3)=tau(2)
        gasabs(4)=tau(3)+tco3
        gasabs(5)=tau(4)            
        gasabs(6)=tau(5)         
        gasabs(7)=tau(6)
        gasabs(8)=tau(7)+tcunif
        gasabs(9)=tau(8)+tau(9)+tau(10)+tau(11)

        if(idb.ge.2) then
          if(i.eq.nz) then
            print '(/,a,f11.4,5x,a,f8.2)','wl=',wl,'wavenumber=',v
            print '(3x,11a11)','z','h2o','h2o_c','co2','o3',
     &           'n2o','co','ch4','o2+n2','trace','total'
          endif            
          print '(i3,11es11.3)', i,z(i),gasabs(1:9),sum(gasabs(1:9))
        elseif(idb.eq.1.and.i.eq.1) then
c         wl h2o co2 o3 n2o co ch4 o2+n2 trace total
          print '(f11.4,9es11.3)',
     &      wl,gasabs(1)+gasabs(2),gasabs(3:9),sum(gasabs(1:9))
        endif
 40   continue
      
      dtauc(1)=tauc(1)
      dtaul(1)=taul(1)
 9876 format(/a,4(/10es11.3))
c      write(*,*) 'taugasx    amu0=',amu0
c      write(*,9876) 'tauc+taul',(tauc(i)+taul(i),i=1,nz)

      do 50 i=2,nz
        dtauc(i)=tauc(i)-tauc(i-1)
        dtaul(i)=taul(i)-taul(i-1)
 50   continue
c      write(*,9876) 'dtauc+dtaul',(dtauc(i)+dtaul(i),i=1,nz)
      return

      contains

c non-spherical earth correction to the cosine of the solar zenith angle
c Draw a line extending from a point on the earths surface out to space
c if amu0 is the solar zenith angle at the surface then amuz(zzz) is the
c angle between the line and the local zenith direction at altitude zzz. 

c statement function:

      real(kr) function amuz(zzz)
      real(kr) zzz
      amuz = sqrt(1.-(1.-amu0**2)*(re/(re+zzz))**2)
      return
      end function

      end
c=======================================================================

c
      subroutine slf296(v,sh2ot0)

c     water vapor self continuum at 296K

      use params, only: kr
      implicit none
      integer, parameter :: npts=2003
      real(kr) :: v, sh2ot0, v1=-20, v2=20000.0, dv=10., s(npts)


      ! units of (cm**3/mol) * 1.e-20

      data s(1:100)/
     &  1.1109e-01 ,1.0573e-01, 1.0162e-01, 1.0573e-01, 1.1109e-01,
     &  1.2574e-01, 1.3499e-01, 1.4327e-01, 1.5065e-01, 1.5164e-01,
     &  1.5022e-01, 1.3677e-01, 1.3115e-01, 1.2253e-01, 1.1271e-01,
     &  1.0070e-01, 8.7495e-02, 8.0118e-02, 6.9940e-02, 6.2034e-02,
     &  5.6051e-02, 4.7663e-02, 4.2450e-02, 3.6690e-02, 3.3441e-02,
     &  3.0711e-02, 2.5205e-02, 2.2113e-02, 1.8880e-02, 1.6653e-02,
     &  1.4626e-02, 1.2065e-02, 1.0709e-02, 9.1783e-03, 7.7274e-03,
     &  6.7302e-03, 5.6164e-03, 4.9089e-03, 4.1497e-03, 3.5823e-03,
     &  3.1124e-03, 2.6414e-03, 2.3167e-03, 2.0156e-03, 1.7829e-03,
     &  1.5666e-03, 1.3928e-03, 1.2338e-03, 1.0932e-03, 9.7939e-04,
     &  8.8241e-04, 7.9173e-04, 7.1296e-04, 6.4179e-04, 5.8031e-04,
     &  5.2647e-04, 4.7762e-04, 4.3349e-04, 3.9355e-04, 3.5887e-04,
     &  3.2723e-04, 2.9919e-04, 2.7363e-04, 2.5013e-04, 2.2876e-04,
     &  2.0924e-04, 1.9193e-04, 1.7618e-04, 1.6188e-04, 1.4891e-04,
     &  1.3717e-04, 1.2647e-04, 1.1671e-04, 1.0786e-04, 9.9785e-05,
     &  9.2350e-05, 8.5539e-05, 7.9377e-05, 7.3781e-05, 6.8677e-05,
     &  6.3993e-05, 5.9705e-05, 5.5788e-05, 5.2196e-05, 4.8899e-05,
     &  4.5865e-05, 4.3079e-05, 4.0526e-05, 3.8182e-05, 3.6025e-05,
     &  3.4038e-05, 3.2203e-05, 3.0511e-05, 2.8949e-05, 2.7505e-05,
     &  2.6170e-05, 2.4933e-05, 2.3786e-05, 2.2722e-05, 2.1736e-05/
      data s(101:200)/
     &  2.0819e-05, 1.9968e-05, 1.9178e-05, 1.8442e-05, 1.7760e-05,
     &  1.7127e-05, 1.6541e-05, 1.5997e-05, 1.5495e-05, 1.5034e-05,
     &  1.4614e-05, 1.4230e-05, 1.3883e-05, 1.3578e-05, 1.3304e-05,
     &  1.3069e-05, 1.2876e-05, 1.2732e-05, 1.2626e-05, 1.2556e-05,
     &  1.2544e-05, 1.2604e-05, 1.2719e-05, 1.2883e-05, 1.3164e-05,
     &  1.3581e-05, 1.4187e-05, 1.4866e-05, 1.5669e-05, 1.6717e-05,
     &  1.8148e-05, 2.0268e-05, 2.2456e-05, 2.5582e-05, 2.9183e-05,
     &  3.3612e-05, 3.9996e-05, 4.6829e-05, 5.5055e-05, 6.5897e-05,
     &  7.5360e-05, 8.7213e-05, 1.0046e-04, 1.1496e-04, 1.2943e-04,
     &  1.5049e-04, 1.6973e-04, 1.8711e-04, 2.0286e-04, 2.2823e-04,
     &  2.6780e-04, 2.8766e-04, 3.1164e-04, 3.3640e-04, 3.6884e-04,
     &  3.9159e-04, 3.8712e-04, 3.7433e-04, 3.4503e-04, 3.1003e-04,
     &  2.8027e-04, 2.5253e-04, 2.3408e-04, 2.2836e-04, 2.4442e-04,
     &  2.7521e-04, 2.9048e-04, 3.0489e-04, 3.2646e-04, 3.3880e-04,
     &  3.3492e-04, 3.0987e-04, 2.9482e-04, 2.8711e-04, 2.6068e-04,
     &  2.2683e-04, 1.9996e-04, 1.7788e-04, 1.6101e-04, 1.3911e-04,
     &  1.2013e-04, 1.0544e-04, 9.4224e-05, 8.1256e-05, 7.3667e-05,
     &  6.2233e-05, 5.5906e-05, 5.1619e-05, 4.5140e-05, 4.0273e-05,
     &  3.3268e-05, 3.0258e-05, 2.6440e-05, 2.3103e-05, 2.0749e-05,
     &  1.8258e-05, 1.6459e-05, 1.4097e-05, 1.2052e-05, 1.0759e-05/
      data s(201:300)/
     &  9.1400e-06, 8.1432e-06, 7.1460e-06, 6.4006e-06, 5.6995e-06,
     &  4.9372e-06, 4.4455e-06, 3.9033e-06, 3.4740e-06, 3.1269e-06,
     &  2.8059e-06, 2.5558e-06, 2.2919e-06, 2.0846e-06, 1.8983e-06,
     &  1.7329e-06, 1.5929e-06, 1.4631e-06, 1.3513e-06, 1.2461e-06,
     &  1.1519e-06, 1.0682e-06, 9.9256e-07, 9.2505e-07, 8.6367e-07,
     &  8.0857e-07, 7.5674e-07, 7.0934e-07, 6.6580e-07, 6.2580e-07,
     &  5.8853e-07, 5.5333e-07, 5.2143e-07, 4.9169e-07, 4.6431e-07,
     &  4.3898e-07, 4.1564e-07, 3.9405e-07, 3.7403e-07, 3.5544e-07,
     &  3.3819e-07, 3.2212e-07, 3.0714e-07, 2.9313e-07, 2.8003e-07,
     &  2.6777e-07, 2.5628e-07, 2.4551e-07, 2.3540e-07, 2.2591e-07,
     &  2.1701e-07, 2.0866e-07, 2.0082e-07, 1.9349e-07, 1.8665e-07,
     &  1.8027e-07, 1.7439e-07, 1.6894e-07, 1.6400e-07, 1.5953e-07,
     &  1.5557e-07, 1.5195e-07, 1.4888e-07, 1.4603e-07, 1.4337e-07,
     &  1.4093e-07, 1.3828e-07, 1.3569e-07, 1.3270e-07, 1.2984e-07,
     &  1.2714e-07, 1.2541e-07, 1.2399e-07, 1.2102e-07, 1.1878e-07,
     &  1.1728e-07, 1.1644e-07, 1.1491e-07, 1.1305e-07, 1.1235e-07,
     &  1.1228e-07, 1.1224e-07, 1.1191e-07, 1.1151e-07, 1.1098e-07,
     &  1.1068e-07, 1.1109e-07, 1.1213e-07, 1.1431e-07, 1.1826e-07,
     &  1.2322e-07, 1.3025e-07, 1.4066e-07, 1.5657e-07, 1.7214e-07,
     &  1.9449e-07, 2.2662e-07, 2.6953e-07, 3.1723e-07, 3.7028e-07/
      data s(301:400)/
     &  4.4482e-07, 5.3852e-07, 6.2639e-07, 7.2175e-07, 7.7626e-07,
     &  8.7248e-07, 9.6759e-07, 1.0102e-06, 1.0620e-06, 1.1201e-06,
     &  1.2107e-06, 1.2998e-06, 1.3130e-06, 1.2856e-06, 1.2350e-06,
     &  1.1489e-06, 1.0819e-06, 1.0120e-06, 9.4795e-07, 9.2858e-07,
     &  9.8060e-07, 1.0999e-06, 1.1967e-06, 1.2672e-06, 1.3418e-06,
     &  1.3864e-06, 1.4330e-06, 1.4592e-06, 1.4598e-06, 1.4774e-06,
     &  1.4726e-06, 1.4820e-06, 1.5050e-06, 1.4984e-06, 1.5181e-06,
     &  1.5888e-06, 1.6850e-06, 1.7690e-06, 1.9277e-06, 2.1107e-06,
     &  2.3068e-06, 2.5347e-06, 2.8069e-06, 3.1345e-06, 3.5822e-06,
     &  3.9051e-06, 4.3422e-06, 4.8704e-06, 5.5351e-06, 6.3454e-06,
     &  7.2690e-06, 8.2974e-06, 9.7609e-06, 1.1237e-05, 1.3187e-05,
     &  1.5548e-05, 1.8784e-05, 2.1694e-05, 2.5487e-05, 3.0092e-05,
     &  3.5385e-05, 4.2764e-05, 4.9313e-05, 5.5800e-05, 6.2968e-05,
     &  7.1060e-05, 7.7699e-05, 8.7216e-05, 8.9335e-05, 9.2151e-05,
     &  9.2779e-05, 9.4643e-05, 9.7978e-05, 1.0008e-04, 1.0702e-04,
     &  1.1026e-04, 1.0828e-04, 1.0550e-04, 1.0432e-04, 1.0428e-04,
     &  9.8980e-05, 9.4992e-05, 9.5159e-05, 1.0058e-04, 1.0738e-04,
     &  1.1550e-04, 1.1229e-04, 1.0596e-04, 1.0062e-04, 9.1742e-05,
     &  8.4492e-05, 6.8099e-05, 5.6295e-05, 4.6502e-05, 3.8071e-05,
     &  3.0721e-05, 2.3297e-05, 1.8688e-05, 1.4830e-05, 1.2049e-05/
      data s(401:500)/
     &  9.6754e-06, 7.9192e-06, 6.6673e-06, 5.6468e-06, 4.8904e-06,
     &  4.2289e-06, 3.6880e-06, 3.2396e-06, 2.8525e-06, 2.5363e-06,
     &  2.2431e-06, 1.9949e-06, 1.7931e-06, 1.6164e-06, 1.4431e-06,
     &  1.2997e-06, 1.1559e-06, 1.0404e-06, 9.4300e-07, 8.4597e-07,
     &  7.6133e-07, 6.8623e-07, 6.2137e-07, 5.6345e-07, 5.1076e-07,
     &  4.6246e-07, 4.1906e-07, 3.8063e-07, 3.4610e-07, 3.1554e-07,
     &  2.8795e-07, 2.6252e-07, 2.3967e-07, 2.1901e-07, 2.0052e-07,
     &  1.8384e-07, 1.6847e-07, 1.5459e-07, 1.4204e-07, 1.3068e-07,
     &  1.2036e-07, 1.1095e-07, 1.0237e-07, 9.4592e-08, 8.7530e-08,
     &  8.1121e-08, 7.5282e-08, 6.9985e-08, 6.5189e-08, 6.0874e-08,
     &  5.6989e-08, 5.3530e-08, 5.0418e-08, 4.7745e-08, 4.5367e-08,
     &  4.3253e-08, 4.1309e-08, 3.9695e-08, 3.8094e-08, 3.6482e-08,
     &  3.4897e-08, 3.3500e-08, 3.2302e-08, 3.0854e-08, 2.9698e-08,
     &  2.8567e-08, 2.7600e-08, 2.6746e-08, 2.5982e-08, 2.5510e-08,
     &  2.5121e-08, 2.4922e-08, 2.4909e-08, 2.5013e-08, 2.5216e-08,
     &  2.5589e-08, 2.6049e-08, 2.6451e-08, 2.6978e-08, 2.7687e-08,
     &  2.8600e-08, 2.9643e-08, 3.0701e-08, 3.2058e-08, 3.3695e-08,
     &  3.5558e-08, 3.7634e-08, 3.9875e-08, 4.2458e-08, 4.5480e-08,
     &  4.8858e-08, 5.2599e-08, 5.7030e-08, 6.2067e-08, 6.7911e-08,
     &  7.4579e-08, 8.1902e-08, 8.9978e-08, 9.9870e-08, 1.1102e-07/
      data s(501:600)/
     &  1.2343e-07, 1.3732e-07, 1.5394e-07, 1.7318e-07, 1.9383e-07,
     &  2.1819e-07, 2.4666e-07, 2.8109e-07, 3.2236e-07, 3.7760e-07,
     &  4.4417e-07, 5.2422e-07, 6.1941e-07, 7.4897e-07, 9.2041e-07,
     &  1.1574e-06, 1.4126e-06, 1.7197e-06, 2.1399e-06, 2.6266e-06,
     &  3.3424e-06, 3.8418e-06, 4.5140e-06, 5.0653e-06, 5.8485e-06,
     &  6.5856e-06, 6.8937e-06, 6.9121e-06, 6.9005e-06, 6.9861e-06,
     &  6.8200e-06, 6.6089e-06, 6.5809e-06, 7.3496e-06, 8.0311e-06,
     &  8.3186e-06, 8.4260e-06, 9.0644e-06, 9.4965e-06, 9.4909e-06,
     &  9.0160e-06, 9.1494e-06, 9.3629e-06, 9.5944e-06, 9.5459e-06,
     &  8.9919e-06, 8.6040e-06, 7.8613e-06, 7.1567e-06, 6.2677e-06,
     &  5.1899e-06, 4.4188e-06, 3.7167e-06, 3.0636e-06, 2.5573e-06,
     &  2.0317e-06, 1.6371e-06, 1.3257e-06, 1.0928e-06, 8.9986e-07,
     &  7.4653e-07, 6.1111e-07, 5.1395e-07, 4.3500e-07, 3.7584e-07,
     &  3.2633e-07, 2.8413e-07, 2.4723e-07, 2.1709e-07, 1.9294e-07,
     &  1.7258e-07, 1.5492e-07, 1.3820e-07, 1.2389e-07, 1.1189e-07,
     &  1.0046e-07, 9.0832e-08, 8.2764e-08, 7.4191e-08, 6.7085e-08,
     &  6.0708e-08, 5.4963e-08, 4.9851e-08, 4.5044e-08, 4.0916e-08,
     &  3.7220e-08, 3.3678e-08, 3.0663e-08, 2.7979e-08, 2.5495e-08,
     &  2.3286e-08, 2.1233e-08, 1.9409e-08, 1.7770e-08, 1.6260e-08,
     &  1.4885e-08, 1.3674e-08, 1.2543e-08, 1.1551e-08, 1.0655e-08/
      data s(601:700)/
     &  9.8585e-09, 9.1398e-09, 8.4806e-09, 7.8899e-09, 7.3547e-09,
     &  6.8670e-09, 6.4131e-09, 5.9930e-09, 5.6096e-09, 5.2592e-09,
     &  4.9352e-09, 4.6354e-09, 4.3722e-09, 4.1250e-09, 3.9081e-09,
     &  3.7118e-09, 3.5372e-09, 3.3862e-09, 3.2499e-09, 3.1324e-09,
     &  3.0313e-09, 2.9438e-09, 2.8686e-09, 2.8050e-09, 2.7545e-09,
     &  2.7149e-09, 2.6907e-09, 2.6724e-09, 2.6649e-09, 2.6642e-09,
     &  2.6725e-09, 2.6871e-09, 2.7056e-09, 2.7357e-09, 2.7781e-09,
     &  2.8358e-09, 2.9067e-09, 2.9952e-09, 3.1020e-09, 3.2253e-09,
     &  3.3647e-09, 3.5232e-09, 3.7037e-09, 3.9076e-09, 4.1385e-09,
     &  4.3927e-09, 4.6861e-09, 5.0238e-09, 5.4027e-09, 5.8303e-09,
     &  6.3208e-09, 6.8878e-09, 7.5419e-09, 8.3130e-09, 9.1952e-09,
     &  1.0228e-08, 1.1386e-08, 1.2792e-08, 1.4521e-08, 1.6437e-08,
     &  1.8674e-08, 2.1160e-08, 2.4506e-08, 2.8113e-08, 3.2636e-08,
     &  3.7355e-08, 4.2234e-08, 4.9282e-08, 5.7358e-08, 6.6743e-08,
     &  7.8821e-08, 9.4264e-08, 1.1542e-07, 1.3684e-07, 1.6337e-07,
     &  2.0056e-07, 2.3252e-07, 2.6127e-07, 2.9211e-07, 3.3804e-07,
     &  3.7397e-07, 3.8205e-07, 3.8810e-07, 3.9499e-07, 3.9508e-07,
     &  3.7652e-07, 3.5859e-07, 3.6198e-07, 3.7871e-07, 4.0925e-07,
     &  4.2717e-07, 4.8241e-07, 5.2008e-07, 5.6530e-07, 5.9531e-07,
     &  6.1994e-07, 6.5080e-07, 6.6355e-07, 6.9193e-07, 6.9930e-07/
      data s(701:800)/
     &  7.3058e-07, 7.4678e-07, 7.9193e-07, 8.3627e-07, 9.1267e-07,
     &  1.0021e-06, 1.1218e-06, 1.2899e-06, 1.4447e-06, 1.7268e-06,
     &  2.0025e-06, 2.3139e-06, 2.5599e-06, 2.8920e-06, 3.3059e-06,
     &  3.5425e-06, 3.9522e-06, 4.0551e-06, 4.2818e-06, 4.2892e-06,
     &  4.4210e-06, 4.5614e-06, 4.6739e-06, 4.9482e-06, 5.1118e-06,
     &  5.0986e-06, 4.9417e-06, 4.9022e-06, 4.8449e-06, 4.8694e-06,
     &  4.8111e-06, 4.9378e-06, 5.3231e-06, 5.7362e-06, 6.2350e-06,
     &  6.0951e-06, 5.7281e-06, 5.4585e-06, 4.9032e-06, 4.3009e-06,
     &  3.4776e-06, 2.8108e-06, 2.2993e-06, 1.7999e-06, 1.3870e-06,
     &  1.0750e-06, 8.5191e-07, 6.7951e-07, 5.5336e-07, 4.6439e-07,
     &  4.0243e-07, 3.5368e-07, 3.1427e-07, 2.7775e-07, 2.4486e-07,
     &  2.1788e-07, 1.9249e-07, 1.7162e-07, 1.5115e-07, 1.3478e-07,
     &  1.2236e-07, 1.1139e-07, 1.0092e-07, 9.0795e-08, 8.2214e-08,
     &  7.4691e-08, 6.7486e-08, 6.0414e-08, 5.4584e-08, 4.8754e-08,
     &  4.3501e-08, 3.8767e-08, 3.4363e-08, 3.0703e-08, 2.7562e-08,
     &  2.4831e-08, 2.2241e-08, 1.9939e-08, 1.8049e-08, 1.6368e-08,
     &  1.4863e-08, 1.3460e-08, 1.2212e-08, 1.1155e-08, 1.0185e-08,
     &  9.3417e-09, 8.5671e-09, 7.8292e-09, 7.1749e-09, 6.5856e-09,
     &  6.0588e-09, 5.5835e-09, 5.1350e-09, 4.7395e-09, 4.3771e-09,
     &  4.0476e-09, 3.7560e-09, 3.4861e-09, 3.2427e-09, 3.0240e-09/
      data s(801:900)/
     &  2.8278e-09, 2.6531e-09, 2.4937e-09, 2.3511e-09, 2.2245e-09,
     &  2.1133e-09, 2.0159e-09, 1.9330e-09, 1.8669e-09, 1.8152e-09,
     &  1.7852e-09, 1.7752e-09, 1.7823e-09, 1.8194e-09, 1.8866e-09,
     &  1.9759e-09, 2.0736e-09, 2.2083e-09, 2.3587e-09, 2.4984e-09,
     &  2.6333e-09, 2.8160e-09, 3.0759e-09, 3.3720e-09, 3.6457e-09,
     &  4.0668e-09, 4.4541e-09, 4.7976e-09, 5.0908e-09, 5.4811e-09,
     &  6.1394e-09, 6.3669e-09, 6.5714e-09, 6.8384e-09, 7.1918e-09,
     &  7.3741e-09, 7.2079e-09, 7.2172e-09, 7.2572e-09, 7.3912e-09,
     &  7.6188e-09, 8.3291e-09, 8.7885e-09, 9.2412e-09, 1.0021e-08,
     &  1.0752e-08, 1.1546e-08, 1.1607e-08, 1.1949e-08, 1.2346e-08,
     &  1.2516e-08, 1.2826e-08, 1.3053e-08, 1.3556e-08, 1.4221e-08,
     &  1.5201e-08, 1.6661e-08, 1.8385e-08, 2.0585e-08, 2.3674e-08,
     &  2.7928e-08, 3.3901e-08, 4.1017e-08, 4.9595e-08, 6.0432e-08,
     &  7.6304e-08, 9.0764e-08, 1.0798e-07, 1.2442e-07, 1.4404e-07,
     &  1.6331e-07, 1.8339e-07, 2.0445e-07, 2.2288e-07, 2.3083e-07,
     &  2.3196e-07, 2.3919e-07, 2.3339e-07, 2.3502e-07, 2.3444e-07,
     &  2.6395e-07, 2.9928e-07, 3.0025e-07, 3.0496e-07, 3.1777e-07,
     &  3.4198e-07, 3.4739e-07, 3.2696e-07, 3.4100e-07, 3.5405e-07,
     &  3.7774e-07, 3.8285e-07, 3.6797e-07, 3.5800e-07, 3.2283e-07,
     &  2.9361e-07, 2.4881e-07, 2.0599e-07, 1.7121e-07, 1.3641e-07/
      data s(901:1000)/
     &  1.1111e-07, 8.9413e-08, 7.3455e-08, 6.2078e-08, 5.2538e-08,
     &  4.5325e-08, 3.9005e-08, 3.4772e-08, 3.1203e-08, 2.8132e-08,
     &  2.5250e-08, 2.2371e-08, 2.0131e-08, 1.7992e-08, 1.6076e-08,
     &  1.4222e-08, 1.2490e-08, 1.1401e-08, 1.0249e-08, 9.2279e-09,
     &  8.5654e-09, 7.6227e-09, 6.9648e-09, 6.2466e-09, 5.7252e-09,
     &  5.3800e-09, 4.6960e-09, 4.2194e-09, 3.7746e-09, 3.3813e-09,
     &  3.0656e-09, 2.6885e-09, 2.4311e-09, 2.1572e-09, 1.8892e-09,
     &  1.7038e-09, 1.4914e-09, 1.3277e-09, 1.1694e-09, 1.0391e-09,
     &  9.2779e-10, 8.3123e-10, 7.4968e-10, 6.8385e-10, 6.2915e-10,
     &  5.7784e-10, 5.2838e-10, 4.8382e-10, 4.4543e-10, 4.1155e-10,
     &  3.7158e-10, 3.3731e-10, 3.0969e-10, 2.8535e-10, 2.6416e-10,
     &  2.4583e-10, 2.2878e-10, 2.1379e-10, 2.0073e-10, 1.8907e-10,
     &  1.7866e-10, 1.6936e-10, 1.6119e-10, 1.5424e-10, 1.4847e-10,
     &  1.4401e-10, 1.4068e-10, 1.3937e-10, 1.3943e-10, 1.4281e-10,
     &  1.4766e-10, 1.5701e-10, 1.7079e-10, 1.8691e-10, 2.0081e-10,
     &  2.1740e-10, 2.4847e-10, 2.6463e-10, 2.7087e-10, 2.7313e-10,
     &  2.8352e-10, 2.9511e-10, 2.8058e-10, 2.7227e-10, 2.7356e-10,
     &  2.8012e-10, 2.8034e-10, 2.9031e-10, 3.1030e-10, 3.3745e-10,
     &  3.8152e-10, 4.0622e-10, 4.2673e-10, 4.3879e-10, 4.5488e-10,
     &  4.7179e-10, 4.6140e-10, 4.6339e-10, 4.6716e-10, 4.7024e-10/
      data s(1001:1100)/
     &  4.7931e-10, 4.8503e-10, 4.9589e-10, 4.9499e-10, 5.0363e-10,
     &  5.3184e-10, 5.6451e-10, 6.0932e-10, 6.6469e-10, 7.4076e-10,
     &  8.3605e-10, 9.4898e-10, 1.0935e-09, 1.2593e-09, 1.4913e-09,
     &  1.8099e-09, 2.1842e-09, 2.7284e-09, 3.2159e-09, 3.7426e-09,
     &  4.5226e-09, 5.3512e-09, 6.1787e-09, 6.8237e-09, 7.9421e-09,
     &  9.0002e-09, 9.6841e-09, 9.9558e-09, 1.0232e-08, 1.0591e-08,
     &  1.0657e-08, 1.0441e-08, 1.0719e-08, 1.1526e-08, 1.2962e-08,
     &  1.4336e-08, 1.6150e-08, 1.8417e-08, 2.0725e-08, 2.3426e-08,
     &  2.5619e-08, 2.7828e-08, 3.0563e-08, 3.3438e-08, 3.6317e-08,
     &  4.0400e-08, 4.4556e-08, 5.0397e-08, 5.3315e-08, 5.9185e-08,
     &  6.5311e-08, 6.9188e-08, 7.7728e-08, 7.9789e-08, 8.6598e-08,
     &  8.7768e-08, 9.1773e-08, 9.7533e-08, 1.0007e-07, 1.0650e-07,
     &  1.0992e-07, 1.0864e-07, 1.0494e-07, 1.0303e-07, 1.0031e-07,
     &  1.0436e-07, 1.0537e-07, 1.1184e-07, 1.2364e-07, 1.3651e-07,
     &  1.4881e-07, 1.4723e-07, 1.4118e-07, 1.3371e-07, 1.1902e-07,
     &  1.0007e-07, 7.9628e-08, 6.4362e-08, 5.0243e-08, 3.8133e-08,
     &  2.9400e-08, 2.3443e-08, 1.9319e-08, 1.6196e-08, 1.4221e-08,
     &  1.2817e-08, 1.1863e-08, 1.1383e-08, 1.1221e-08, 1.1574e-08,
     &  1.1661e-08, 1.2157e-08, 1.2883e-08, 1.3295e-08, 1.4243e-08,
     &  1.4240e-08, 1.4614e-08, 1.4529e-08, 1.4685e-08, 1.4974e-08/
      data s(1101:1200)/
     &  1.4790e-08, 1.4890e-08, 1.4704e-08, 1.4142e-08, 1.3374e-08,
     &  1.2746e-08, 1.2172e-08, 1.2336e-08, 1.2546e-08, 1.3065e-08,
     &  1.4090e-08, 1.5215e-08, 1.6540e-08, 1.6144e-08, 1.5282e-08,
     &  1.4358e-08, 1.2849e-08, 1.0998e-08, 8.6956e-09, 7.0881e-09,
     &  5.5767e-09, 4.2792e-09, 3.2233e-09, 2.5020e-09, 1.9985e-09,
     &  1.5834e-09, 1.3015e-09, 1.0948e-09, 9.4141e-10, 8.1465e-10,
     &  7.1517e-10, 6.2906e-10, 5.5756e-10, 4.9805e-10, 4.3961e-10,
     &  3.9181e-10, 3.5227e-10, 3.1670e-10, 2.8667e-10, 2.5745e-10,
     &  2.3212e-10, 2.0948e-10, 1.8970e-10, 1.7239e-10, 1.5659e-10,
     &  1.4301e-10, 1.3104e-10, 1.2031e-10, 1.1095e-10, 1.0262e-10,
     &  9.5130e-11, 8.8595e-11, 8.2842e-11, 7.7727e-11, 7.3199e-11,
     &  6.9286e-11, 6.5994e-11, 6.3316e-11, 6.1244e-11, 5.9669e-11,
     &  5.8843e-11, 5.8832e-11, 5.9547e-11, 6.1635e-11, 6.4926e-11,
     &  7.0745e-11, 7.8802e-11, 8.6724e-11, 1.0052e-10, 1.1575e-10,
     &  1.3626e-10, 1.5126e-10, 1.6751e-10, 1.9239e-10, 2.1748e-10,
     &  2.2654e-10, 2.2902e-10, 2.3240e-10, 2.4081e-10, 2.3930e-10,
     &  2.2378e-10, 2.2476e-10, 2.2791e-10, 2.4047e-10, 2.5305e-10,
     &  2.8073e-10, 3.1741e-10, 3.6592e-10, 4.1495e-10, 4.6565e-10,
     &  5.0990e-10, 5.5607e-10, 6.1928e-10, 6.6779e-10, 7.3350e-10,
     &  8.1434e-10, 8.9635e-10, 9.9678e-10, 1.1256e-09, 1.2999e-09/
      data s(1201:1300)/
     &  1.4888e-09, 1.7642e-09, 1.9606e-09, 2.2066e-09, 2.4601e-09,
     &  2.7218e-09, 3.0375e-09, 3.1591e-09, 3.2852e-09, 3.2464e-09,
     &  3.3046e-09, 3.2710e-09, 3.2601e-09, 3.3398e-09, 3.7446e-09,
     &  4.0795e-09, 4.0284e-09, 4.0584e-09, 4.1677e-09, 4.5358e-09,
     &  4.4097e-09, 4.2744e-09, 4.5449e-09, 4.8147e-09, 5.2656e-09,
     &  5.2476e-09, 5.0275e-09, 4.7968e-09, 4.3654e-09, 3.9530e-09,
     &  3.2447e-09, 2.6489e-09, 2.1795e-09, 1.7880e-09, 1.4309e-09,
     &  1.1256e-09, 9.1903e-10, 7.6533e-10, 6.3989e-10, 5.5496e-10,
     &  4.9581e-10, 4.5722e-10, 4.3898e-10, 4.3505e-10, 4.3671e-10,
     &  4.5329e-10, 4.6827e-10, 4.9394e-10, 5.1122e-10, 5.1649e-10,
     &  5.0965e-10, 4.9551e-10, 4.8928e-10, 4.7947e-10, 4.7989e-10,
     &  4.9071e-10, 4.8867e-10, 4.7260e-10, 4.5756e-10, 4.5400e-10,
     &  4.5993e-10, 4.4042e-10, 4.3309e-10, 4.4182e-10, 4.6735e-10,
     &  5.0378e-10, 5.2204e-10, 5.0166e-10, 4.6799e-10, 4.3119e-10,
     &  3.8803e-10, 3.3291e-10, 2.6289e-10, 2.1029e-10, 1.7011e-10,
     &  1.3345e-10, 1.0224e-10, 7.8207e-11, 6.2451e-11, 5.0481e-11,
     &  4.1507e-11, 3.5419e-11, 3.0582e-11, 2.6900e-11, 2.3778e-11,
     &  2.1343e-11, 1.9182e-11, 1.7162e-11, 1.5391e-11, 1.3877e-11,
     &  1.2619e-11, 1.1450e-11, 1.0461e-11, 9.6578e-12, 8.9579e-12,
     &  8.3463e-12, 7.8127e-12, 7.3322e-12, 6.9414e-12, 6.6037e-12/
      data s(1301:1400)/
     &  6.3285e-12, 6.1095e-12, 5.9387e-12, 5.8118e-12, 5.7260e-12,
     &  5.6794e-12, 5.6711e-12, 5.7003e-12, 5.7670e-12, 5.8717e-12,
     &  6.0151e-12, 6.1984e-12, 6.4232e-12, 6.6918e-12, 7.0065e-12,
     &  7.3705e-12, 7.7873e-12, 8.2612e-12, 8.7972e-12, 9.4009e-12,
     &  1.0079e-11, 1.0840e-11, 1.1692e-11, 1.2648e-11, 1.3723e-11,
     &  1.4935e-11, 1.6313e-11, 1.7905e-11, 1.9740e-11, 2.1898e-11,
     &  2.4419e-11, 2.7426e-11, 3.0869e-11, 3.4235e-11, 3.7841e-11,
     &  4.1929e-11, 4.6776e-11, 5.2123e-11, 5.8497e-11, 6.5294e-11,
     &  7.4038e-11, 8.4793e-11, 9.6453e-11, 1.1223e-10, 1.2786e-10,
     &  1.4882e-10, 1.7799e-10, 2.0766e-10, 2.4523e-10, 2.8591e-10,
     &  3.3386e-10, 4.0531e-10, 4.7663e-10, 5.4858e-10, 6.3377e-10,
     &  7.1688e-10, 8.4184e-10, 9.5144e-10, 1.0481e-09, 1.1356e-09,
     &  1.2339e-09, 1.3396e-09, 1.4375e-09, 1.5831e-09, 1.7323e-09,
     &  1.9671e-09, 2.2976e-09, 2.6679e-09, 3.0777e-09, 3.4321e-09,
     &  3.8192e-09, 4.2711e-09, 4.4903e-09, 4.8931e-09, 5.2253e-09,
     &  5.4040e-09, 5.6387e-09, 5.6704e-09, 6.0345e-09, 6.1079e-09,
     &  6.2576e-09, 6.4039e-09, 6.3776e-09, 6.1878e-09, 5.8616e-09,
     &  5.7036e-09, 5.5840e-09, 5.6905e-09, 5.8931e-09, 6.2478e-09,
     &  6.8291e-09, 7.4528e-09, 7.6078e-09, 7.3898e-09, 6.7573e-09,
     &  5.9827e-09, 5.0927e-09, 4.0099e-09, 3.1933e-09, 2.4296e-09/
      data s(1401:1500)/
     &  1.8485e-09, 1.4595e-09, 1.2017e-09, 1.0164e-09, 8.7433e-10,
     &  7.7108e-10, 7.0049e-10, 6.5291e-10, 6.1477e-10, 5.9254e-10,
     &  5.8150e-10, 5.7591e-10, 5.8490e-10, 5.8587e-10, 5.9636e-10,
     &  6.2408e-10, 6.5479e-10, 7.0480e-10, 7.2313e-10, 7.5524e-10,
     &  8.0863e-10, 8.3386e-10, 9.2342e-10, 9.6754e-10, 1.0293e-09,
     &  1.0895e-09, 1.1330e-09, 1.2210e-09, 1.2413e-09, 1.2613e-09,
     &  1.2671e-09, 1.2225e-09, 1.1609e-09, 1.0991e-09, 1.0600e-09,
     &  1.0570e-09, 1.0818e-09, 1.1421e-09, 1.2270e-09, 1.3370e-09,
     &  1.4742e-09, 1.4946e-09, 1.4322e-09, 1.3210e-09, 1.1749e-09,
     &  1.0051e-09, 7.8387e-10, 6.1844e-10, 4.6288e-10, 3.4164e-10,
     &  2.5412e-10, 1.9857e-10, 1.5876e-10, 1.2966e-10, 1.0920e-10,
     &  9.4811e-11, 8.3733e-11, 7.3906e-11, 6.7259e-11, 6.1146e-11,
     &  5.7119e-11, 5.3546e-11, 4.8625e-11, 4.4749e-11, 4.1089e-11,
     &  3.7825e-11, 3.4465e-11, 3.1018e-11, 2.8109e-11, 2.5610e-11,
     &  2.2859e-11, 2.0490e-11, 1.8133e-11, 1.5835e-11, 1.3949e-11,
     &  1.2295e-11, 1.0799e-11, 9.6544e-12, 8.7597e-12, 7.9990e-12,
     &  7.3973e-12, 6.9035e-12, 6.4935e-12, 6.1195e-12, 5.8235e-12,
     &  5.5928e-12, 5.4191e-12, 5.2993e-12, 5.2338e-12, 5.2272e-12,
     &  5.2923e-12, 5.4252e-12, 5.6523e-12, 5.9433e-12, 6.3197e-12,
     &  6.9016e-12, 7.5016e-12, 8.2885e-12, 9.4050e-12, 1.0605e-11/
      data s(1501:1600)/
     &  1.2257e-11, 1.3622e-11, 1.5353e-11, 1.7543e-11, 1.9809e-11,
     &  2.2197e-11, 2.4065e-11, 2.6777e-11, 2.9751e-11, 3.2543e-11,
     &  3.5536e-11, 3.9942e-11, 4.6283e-11, 5.4556e-11, 6.5490e-11,
     &  7.6803e-11, 9.0053e-11, 1.0852e-10, 1.2946e-10, 1.4916e-10,
     &  1.7748e-10, 2.0073e-10, 2.2485e-10, 2.5114e-10, 2.7715e-10,
     &  3.1319e-10, 3.3305e-10, 3.5059e-10, 3.5746e-10, 3.6311e-10,
     &  3.7344e-10, 3.6574e-10, 3.7539e-10, 3.9434e-10, 4.3510e-10,
     &  4.3340e-10, 4.2588e-10, 4.3977e-10, 4.6062e-10, 4.7687e-10,
     &  4.6457e-10, 4.8578e-10, 5.2344e-10, 5.6752e-10, 5.8702e-10,
     &  5.6603e-10, 5.3784e-10, 4.9181e-10, 4.3272e-10, 3.5681e-10,
     &  2.8814e-10, 2.3320e-10, 1.8631e-10, 1.4587e-10, 1.1782e-10,
     &  9.8132e-11, 8.2528e-11, 6.9174e-11, 6.1056e-11, 5.3459e-11,
     &  4.7116e-11, 4.1878e-11, 3.8125e-11, 3.6347e-11, 3.5071e-11,
     &  3.3897e-11, 3.3541e-11, 3.3563e-11, 3.5469e-11, 3.8111e-11,
     &  3.8675e-11, 4.1333e-11, 4.3475e-11, 4.6476e-11, 4.9761e-11,
     &  5.1380e-11, 5.4135e-11, 5.3802e-11, 5.5158e-11, 5.6864e-11,
     &  5.9311e-11, 6.3827e-11, 6.7893e-11, 6.8230e-11, 6.6694e-11,
     &  6.6018e-11, 6.4863e-11, 6.5893e-11, 6.3813e-11, 6.4741e-11,
     &  6.8630e-11, 7.0255e-11, 7.0667e-11, 6.8810e-11, 6.4104e-11,
     &  5.8136e-11, 4.7242e-11, 3.7625e-11, 3.1742e-11, 2.5581e-11/
      data s(1601:1700)/
     &  1.8824e-11, 1.3303e-11, 9.6919e-12, 7.5353e-12, 6.0986e-12,
     &  5.0742e-12, 4.3094e-12, 3.7190e-12, 3.2520e-12, 2.8756e-12,
     &  2.5680e-12, 2.3139e-12, 2.1025e-12, 1.9257e-12, 1.7777e-12,
     &  1.6539e-12, 1.5508e-12, 1.4657e-12, 1.3966e-12, 1.3417e-12,
     &  1.2998e-12, 1.2700e-12, 1.2514e-12, 1.2437e-12, 1.2463e-12,
     &  1.2592e-12, 1.2823e-12, 1.3157e-12, 1.3596e-12, 1.4144e-12,
     &  1.4806e-12, 1.5588e-12, 1.6497e-12, 1.7544e-12, 1.8738e-12,
     &  2.0094e-12, 2.1626e-12, 2.3354e-12, 2.5297e-12, 2.7483e-12,
     &  2.9941e-12, 3.2708e-12, 3.5833e-12, 3.9374e-12, 4.3415e-12,
     &  4.8079e-12, 5.3602e-12, 5.9816e-12, 6.7436e-12, 7.6368e-12,
     &  8.6812e-12, 9.8747e-12, 1.1350e-11, 1.3181e-11, 1.5406e-11,
     &  1.7868e-11, 2.0651e-11, 2.4504e-11, 2.9184e-11, 3.4159e-11,
     &  3.9979e-11, 4.8704e-11, 5.7856e-11, 6.7576e-11, 7.9103e-11,
     &  9.4370e-11, 1.1224e-10, 1.3112e-10, 1.5674e-10, 1.8206e-10,
     &  2.0576e-10, 2.3187e-10, 2.7005e-10, 3.0055e-10, 3.3423e-10,
     &  3.6956e-10, 3.8737e-10, 4.2630e-10, 4.5154e-10, 4.8383e-10,
     &  5.3582e-10, 5.8109e-10, 6.3741e-10, 6.3874e-10, 6.3870e-10,
     &  6.5818e-10, 6.5056e-10, 6.5291e-10, 6.3159e-10, 6.3984e-10,
     &  6.4549e-10, 6.5444e-10, 6.7035e-10, 6.7665e-10, 6.9124e-10,
     &  6.8451e-10, 6.9255e-10, 6.9923e-10, 7.0396e-10, 6.7715e-10/
      data s(1701:1800)/
     &  6.0371e-10, 5.3774e-10, 4.6043e-10, 3.7635e-10, 2.9484e-10,
     &  2.2968e-10, 1.8185e-10, 1.4191e-10, 1.1471e-10, 9.4790e-11,
     &  7.9613e-11, 6.7989e-11, 5.9391e-11, 5.2810e-11, 4.7136e-11,
     &  4.2618e-11, 3.8313e-11, 3.4686e-11, 3.1669e-11, 2.9110e-11,
     &  2.6871e-11, 2.5074e-11, 2.4368e-11, 2.3925e-11, 2.4067e-11,
     &  2.4336e-11, 2.4704e-11, 2.5823e-11, 2.7177e-11, 2.9227e-11,
     &  3.1593e-11, 3.5730e-11, 4.0221e-11, 4.3994e-11, 4.8448e-11,
     &  5.3191e-11, 5.8552e-11, 6.3458e-11, 6.6335e-11, 7.2457e-11,
     &  7.9091e-11, 8.2234e-11, 8.7668e-11, 8.7951e-11, 9.2952e-11,
     &  9.6157e-11, 9.5926e-11, 1.0120e-10, 1.0115e-10, 9.9577e-11,
     &  9.6633e-11, 9.2891e-11, 9.3315e-11, 9.5584e-11, 1.0064e-10,
     &  1.0509e-10, 1.1455e-10, 1.2443e-10, 1.2963e-10, 1.2632e-10,
     &  1.1308e-10, 1.0186e-10, 8.5880e-11, 6.7863e-11, 5.1521e-11,
     &  3.7780e-11, 2.8842e-11, 2.2052e-11, 1.7402e-11, 1.4406e-11,
     &  1.1934e-11, 1.0223e-11, 8.9544e-12, 7.9088e-12, 7.0675e-12,
     &  6.2222e-12, 5.6051e-12, 5.0502e-12, 4.5578e-12, 4.2636e-12,
     &  3.9461e-12, 3.7599e-12, 3.5215e-12, 3.2467e-12, 3.0018e-12,
     &  2.6558e-12, 2.3928e-12, 2.0707e-12, 1.7575e-12, 1.5114e-12,
     &  1.2941e-12, 1.1004e-12, 9.5175e-13, 8.2894e-13, 7.3253e-13,
     &  6.5551e-13, 5.9098e-13, 5.3548e-13, 4.8697e-13, 4.4413e-13/
      data s(1801:1900)/
     &  4.0600e-13, 3.7188e-13, 3.4121e-13, 3.1356e-13, 2.8856e-13,
     &  2.6590e-13, 2.4533e-13, 2.2663e-13, 2.0960e-13, 1.9407e-13,
     &  1.7990e-13, 1.6695e-13, 1.5512e-13, 1.4429e-13, 1.3437e-13,
     &  1.2527e-13, 1.1693e-13, 1.0927e-13, 1.0224e-13, 9.5767e-14,
     &  8.9816e-14, 8.4335e-14, 7.9285e-14, 7.4626e-14, 7.0325e-14,
     &  6.6352e-14, 6.2676e-14, 5.9274e-14, 5.6121e-14, 5.3195e-14,
     &  5.0479e-14, 4.7953e-14, 4.5602e-14, 4.3411e-14, 4.1367e-14,
     &  3.9456e-14, 3.7670e-14, 3.5996e-14, 3.4427e-14, 3.2952e-14,
     &  3.1566e-14, 3.0261e-14, 2.9030e-14, 2.7868e-14, 2.6770e-14,
     &  2.5730e-14, 2.4745e-14, 2.3809e-14, 2.2921e-14, 2.2076e-14,
     &  2.1271e-14, 2.0504e-14, 1.9772e-14, 1.9073e-14, 1.8404e-14,
     &  1.7764e-14, 1.7151e-14, 1.6564e-14, 1.6000e-14, 1.5459e-14,
     &  1.4939e-14, 1.4439e-14, 1.3958e-14, 1.3495e-14, 1.3049e-14,
     &  1.2620e-14, 1.2206e-14, 1.1807e-14, 1.1422e-14, 1.1050e-14,
     &  1.0691e-14, 1.0345e-14, 1.0010e-14, 9.6870e-15, 9.3747e-15,
     &  9.0727e-15, 8.7808e-15, 8.4986e-15, 8.2257e-15, 7.9617e-15,
     &  7.7064e-15, 7.4594e-15, 7.2204e-15, 6.9891e-15, 6.7653e-15,
     &  6.5488e-15, 6.3392e-15, 6.1363e-15, 5.9399e-15, 5.7499e-15,
     &  5.5659e-15, 5.3878e-15, 5.2153e-15, 5.0484e-15, 4.8868e-15,
     &  4.7303e-15, 4.5788e-15, 4.4322e-15, 4.2902e-15, 4.1527e-15/
      data s(1901:2003)/
     &  4.0196e-15, 3.8907e-15, 3.7659e-15, 3.6451e-15, 3.5281e-15,
     &  3.4149e-15, 3.3052e-15, 3.1991e-15, 3.0963e-15, 2.9967e-15,
     &  2.9004e-15, 2.8071e-15, 2.7167e-15, 2.6293e-15, 2.5446e-15,
     &  2.4626e-15, 2.3833e-15, 2.3064e-15, 2.2320e-15, 2.1600e-15,
     &  2.0903e-15, 2.0228e-15, 1.9574e-15, 1.8942e-15, 1.8329e-15,
     &  1.7736e-15, 1.7163e-15, 1.6607e-15, 1.6069e-15, 1.5548e-15,
     &  1.5044e-15, 1.4557e-15, 1.4084e-15, 1.3627e-15, 1.3185e-15,
     &  1.2757e-15, 1.2342e-15, 1.1941e-15, 1.1552e-15, 1.1177e-15,
     &  1.0813e-15, 1.0461e-15, 1.0120e-15, 9.7900e-16, 9.4707e-16,
     &  9.1618e-16, 8.8628e-16, 8.5734e-16, 8.2933e-16, 8.0223e-16,
     &  7.7600e-16, 7.5062e-16, 7.2606e-16, 7.0229e-16, 6.7929e-16,
     &  6.5703e-16, 6.3550e-16, 6.1466e-16, 5.9449e-16, 5.7498e-16,
     &  5.5610e-16, 5.3783e-16, 5.2015e-16, 5.0305e-16, 4.8650e-16,
     &  4.7049e-16, 4.5500e-16, 4.4002e-16, 4.2552e-16, 4.1149e-16,
     &  3.9792e-16, 3.8479e-16, 3.7209e-16, 3.5981e-16, 3.4792e-16,
     &  3.3642e-16, 3.2530e-16, 3.1454e-16, 3.0413e-16, 2.9406e-16,
     &  2.8432e-16, 2.7490e-16, 2.6579e-16, 2.5697e-16, 2.4845e-16,
     &  2.4020e-16, 2.3223e-16, 2.2451e-16, 2.1705e-16, 2.0984e-16,
     &  2.0286e-16, 1.9611e-16, 1.8958e-16, 1.8327e-16, 1.7716e-16,
     &  1.7126e-16, 1.6555e-16, 1.6003e-16, 1.5469e-16, 1.4952e-16,
     &  1.4453e-16, 1.3970e-16, 1.3503e-16/
cccc

      call sint(v1,v,dv,npts,s,sh2ot0)
      return
      end
c=======================================================================
      subroutine slf260(v,sh2ot1)

c     water vapor self continuum at 260K

      use params, only: kr
      implicit none
      integer, parameter :: npts=2003
      real(kr) :: v, sh2ot1, v1=-20, v2=20000.0, dv=10., s(npts)

      ! units of (cm**3/mol) * 1.e-20

      data s(1:100)/
     &  1.7750e-01, 1.7045e-01, 1.6457e-01, 1.7045e-01, 1.7750e-01,
     &  2.0036e-01, 2.1347e-01, 2.2454e-01, 2.3428e-01, 2.3399e-01,
     &  2.3022e-01, 2.0724e-01, 1.9712e-01, 1.8317e-01, 1.6724e-01,
     &  1.4780e-01, 1.2757e-01, 1.1626e-01, 1.0098e-01, 8.9033e-02,
     &  7.9770e-02, 6.7416e-02, 5.9588e-02, 5.1117e-02, 4.6218e-02,
     &  4.2179e-02, 3.4372e-02, 2.9863e-02, 2.5252e-02, 2.2075e-02,
     &  1.9209e-02, 1.5816e-02, 1.3932e-02, 1.1943e-02, 1.0079e-02,
     &  8.7667e-03, 7.4094e-03, 6.4967e-03, 5.5711e-03, 4.8444e-03,
     &  4.2552e-03, 3.6953e-03, 3.2824e-03, 2.9124e-03, 2.6102e-03,
     &  2.3370e-03, 2.1100e-03, 1.9008e-03, 1.7145e-03, 1.5573e-03,
     &  1.4206e-03, 1.2931e-03, 1.1803e-03, 1.0774e-03, 9.8616e-04,
     &  9.0496e-04, 8.3071e-04, 7.6319e-04, 7.0149e-04, 6.4637e-04,
     &  5.9566e-04, 5.4987e-04, 5.0768e-04, 4.6880e-04, 4.3317e-04,
     &  4.0037e-04, 3.7064e-04, 3.4325e-04, 3.1809e-04, 2.9501e-04,
     &  2.7382e-04, 2.5430e-04, 2.3630e-04, 2.1977e-04, 2.0452e-04,
     &  1.9042e-04, 1.7740e-04, 1.6544e-04, 1.5442e-04, 1.4425e-04,
     &  1.3486e-04, 1.2618e-04, 1.1817e-04, 1.1076e-04, 1.0391e-04,
     &  9.7563e-05, 9.1696e-05, 8.6272e-05, 8.1253e-05, 7.6607e-05,
     &  7.2302e-05, 6.8311e-05, 6.4613e-05, 6.1183e-05, 5.8001e-05,
     &  5.5048e-05, 5.2307e-05, 4.9761e-05, 4.7395e-05, 4.5197e-05/
      data s(101:200)/
     &  4.3155e-05, 4.1256e-05, 3.9491e-05, 3.7849e-05, 3.6324e-05,
     &  3.4908e-05, 3.3594e-05, 3.2374e-05, 3.1244e-05, 3.0201e-05,
     &  2.9240e-05, 2.8356e-05, 2.7547e-05, 2.6814e-05, 2.6147e-05,
     &  2.5551e-05, 2.5029e-05, 2.4582e-05, 2.4203e-05, 2.3891e-05,
     &  2.3663e-05, 2.3531e-05, 2.3483e-05, 2.3516e-05, 2.3694e-05,
     &  2.4032e-05, 2.4579e-05, 2.5234e-05, 2.6032e-05, 2.7119e-05,
     &  2.8631e-05, 3.0848e-05, 3.3262e-05, 3.6635e-05, 4.0732e-05,
     &  4.5923e-05, 5.3373e-05, 6.1875e-05, 7.2031e-05, 8.5980e-05,
     &  9.8642e-05, 1.1469e-04, 1.3327e-04, 1.5390e-04, 1.7513e-04,
     &  2.0665e-04, 2.3609e-04, 2.6220e-04, 2.8677e-04, 3.2590e-04,
     &  3.8624e-04, 4.1570e-04, 4.5207e-04, 4.9336e-04, 5.4500e-04,
     &  5.8258e-04, 5.8086e-04, 5.6977e-04, 5.3085e-04, 4.8020e-04,
     &  4.3915e-04, 4.0343e-04, 3.7853e-04, 3.7025e-04, 3.9637e-04,
     &  4.4675e-04, 4.7072e-04, 4.9022e-04, 5.2076e-04, 5.3676e-04,
     &  5.2755e-04, 4.8244e-04, 4.5473e-04, 4.3952e-04, 3.9614e-04,
     &  3.4086e-04, 2.9733e-04, 2.6367e-04, 2.3767e-04, 2.0427e-04,
     &  1.7595e-04, 1.5493e-04, 1.3851e-04, 1.1874e-04, 1.0735e-04,
     &  9.0490e-05, 8.1149e-05, 7.4788e-05, 6.5438e-05, 5.8248e-05,
     &  4.8076e-05, 4.3488e-05, 3.7856e-05, 3.3034e-05, 2.9592e-05,
     &  2.6088e-05, 2.3497e-05, 2.0279e-05, 1.7526e-05, 1.5714e-05/
      data s(201:300)/
     &  1.3553e-05, 1.2145e-05, 1.0802e-05, 9.7681e-06, 8.8196e-06,
     &  7.8291e-06, 7.1335e-06, 6.4234e-06, 5.8391e-06, 5.3532e-06,
     &  4.9079e-06, 4.5378e-06, 4.1716e-06, 3.8649e-06, 3.5893e-06,
     &  3.3406e-06, 3.1199e-06, 2.9172e-06, 2.7348e-06, 2.5644e-06,
     &  2.4086e-06, 2.2664e-06, 2.1359e-06, 2.0159e-06, 1.9051e-06,
     &  1.8031e-06, 1.7074e-06, 1.6185e-06, 1.5356e-06, 1.4584e-06,
     &  1.3861e-06, 1.3179e-06, 1.2545e-06, 1.1951e-06, 1.1395e-06,
     &  1.0873e-06, 1.0384e-06, 9.9250e-07, 9.4935e-07, 9.0873e-07,
     &  8.7050e-07, 8.3446e-07, 8.0046e-07, 7.6834e-07, 7.3800e-07,
     &  7.0931e-07, 6.8217e-07, 6.5648e-07, 6.3214e-07, 6.0909e-07,
     &  5.8725e-07, 5.6655e-07, 5.4693e-07, 5.2835e-07, 5.1077e-07,
     &  4.9416e-07, 4.7853e-07, 4.6381e-07, 4.5007e-07, 4.3728e-07,
     &  4.2550e-07, 4.1450e-07, 4.0459e-07, 3.9532e-07, 3.8662e-07,
     &  3.7855e-07, 3.7041e-07, 3.6254e-07, 3.5420e-07, 3.4617e-07,
     &  3.3838e-07, 3.3212e-07, 3.2655e-07, 3.1865e-07, 3.1203e-07,
     &  3.0670e-07, 3.0252e-07, 2.9749e-07, 2.9184e-07, 2.8795e-07,
     &  2.8501e-07, 2.8202e-07, 2.7856e-07, 2.7509e-07, 2.7152e-07,
     &  2.6844e-07, 2.6642e-07, 2.6548e-07, 2.6617e-07, 2.6916e-07,
     &  2.7372e-07, 2.8094e-07, 2.9236e-07, 3.1035e-07, 3.2854e-07,
     &  3.5481e-07, 3.9377e-07, 4.4692e-07, 5.0761e-07, 5.7715e-07/
      data s(301:400)/
     &  6.7725e-07, 8.0668e-07, 9.3716e-07, 1.0797e-06, 1.1689e-06,
     &  1.3217e-06, 1.4814e-06, 1.5627e-06, 1.6519e-06, 1.7601e-06,
     &  1.9060e-06, 2.0474e-06, 2.0716e-06, 2.0433e-06, 1.9752e-06,
     &  1.8466e-06, 1.7526e-06, 1.6657e-06, 1.5870e-06, 1.5633e-06,
     &  1.6520e-06, 1.8471e-06, 1.9953e-06, 2.0975e-06, 2.2016e-06,
     &  2.2542e-06, 2.3081e-06, 2.3209e-06, 2.2998e-06, 2.3056e-06,
     &  2.2757e-06, 2.2685e-06, 2.2779e-06, 2.2348e-06, 2.2445e-06,
     &  2.3174e-06, 2.4284e-06, 2.5290e-06, 2.7340e-06, 2.9720e-06,
     &  3.2332e-06, 3.5392e-06, 3.9013e-06, 4.3334e-06, 4.9088e-06,
     &  5.3428e-06, 5.9142e-06, 6.6106e-06, 7.4709e-06, 8.5019e-06,
     &  9.6835e-06, 1.0984e-05, 1.2831e-05, 1.4664e-05, 1.7080e-05,
     &  2.0103e-05, 2.4148e-05, 2.7948e-05, 3.2855e-05, 3.9046e-05,
     &  4.6429e-05, 5.6633e-05, 6.6305e-05, 7.6048e-05, 8.7398e-05,
     &  1.0034e-04, 1.1169e-04, 1.2813e-04, 1.3354e-04, 1.3952e-04,
     &  1.4204e-04, 1.4615e-04, 1.5144e-04, 1.5475e-04, 1.6561e-04,
     &  1.7135e-04, 1.6831e-04, 1.6429e-04, 1.6353e-04, 1.6543e-04,
     &  1.5944e-04, 1.5404e-04, 1.5458e-04, 1.6287e-04, 1.7277e-04,
     &  1.8387e-04, 1.7622e-04, 1.6360e-04, 1.5273e-04, 1.3667e-04,
     &  1.2364e-04, 9.7576e-05, 7.9140e-05, 6.4241e-05, 5.1826e-05,
     &  4.1415e-05, 3.1347e-05, 2.5125e-05, 2.0027e-05, 1.6362e-05/
      data s(401:500)/
     &  1.3364e-05, 1.1117e-05, 9.4992e-06, 8.1581e-06, 7.1512e-06,
     &  6.2692e-06, 5.5285e-06, 4.9000e-06, 4.3447e-06, 3.8906e-06,
     &  3.4679e-06, 3.1089e-06, 2.8115e-06, 2.5496e-06, 2.2982e-06,
     &  2.0861e-06, 1.8763e-06, 1.7035e-06, 1.5548e-06, 1.4107e-06,
     &  1.2839e-06, 1.1706e-06, 1.0709e-06, 9.8099e-07, 8.9901e-07,
     &  8.2394e-07, 7.5567e-07, 6.9434e-07, 6.3867e-07, 5.8845e-07,
     &  5.4263e-07, 5.0033e-07, 4.6181e-07, 4.2652e-07, 3.9437e-07,
     &  3.6497e-07, 3.3781e-07, 3.1292e-07, 2.9011e-07, 2.6915e-07,
     &  2.4989e-07, 2.3215e-07, 2.1582e-07, 2.0081e-07, 1.8700e-07,
     &  1.7432e-07, 1.6264e-07, 1.5191e-07, 1.4207e-07, 1.3306e-07,
     &  1.2484e-07, 1.1737e-07, 1.1056e-07, 1.0451e-07, 9.9060e-08,
     &  9.4135e-08, 8.9608e-08, 8.5697e-08, 8.1945e-08, 7.8308e-08,
     &  7.4808e-08, 7.1686e-08, 6.8923e-08, 6.5869e-08, 6.3308e-08,
     &  6.0840e-08, 5.8676e-08, 5.6744e-08, 5.5016e-08, 5.3813e-08,
     &  5.2792e-08, 5.2097e-08, 5.1737e-08, 5.1603e-08, 5.1656e-08,
     &  5.1989e-08, 5.2467e-08, 5.2918e-08, 5.3589e-08, 5.4560e-08,
     &  5.5869e-08, 5.7403e-08, 5.8968e-08, 6.0973e-08, 6.3432e-08,
     &  6.6245e-08, 6.9353e-08, 7.2686e-08, 7.6541e-08, 8.0991e-08,
     &  8.5950e-08, 9.1429e-08, 9.7851e-08, 1.0516e-07, 1.1349e-07,
     &  1.2295e-07, 1.3335e-07, 1.4488e-07, 1.5864e-07, 1.7412e-07/
      data s(501:600)/
     &  1.9140e-07, 2.1078e-07, 2.3369e-07, 2.5996e-07, 2.8848e-07,
     &  3.2169e-07, 3.5991e-07, 4.0566e-07, 4.5969e-07, 5.3094e-07,
     &  6.1458e-07, 7.1155e-07, 8.3045e-07, 9.9021e-07, 1.2042e-06,
     &  1.4914e-06, 1.8145e-06, 2.2210e-06, 2.7831e-06, 3.4533e-06,
     &  4.4446e-06, 5.1989e-06, 6.2289e-06, 7.1167e-06, 8.3949e-06,
     &  9.6417e-06, 1.0313e-05, 1.0485e-05, 1.0641e-05, 1.0898e-05,
     &  1.0763e-05, 1.0506e-05, 1.0497e-05, 1.1696e-05, 1.2654e-05,
     &  1.3029e-05, 1.3175e-05, 1.4264e-05, 1.4985e-05, 1.4999e-05,
     &  1.4317e-05, 1.4616e-05, 1.4963e-05, 1.5208e-05, 1.4942e-05,
     &  1.3879e-05, 1.3087e-05, 1.1727e-05, 1.0515e-05, 9.0073e-06,
     &  7.3133e-06, 6.1181e-06, 5.0623e-06, 4.1105e-06, 3.3915e-06,
     &  2.6711e-06, 2.1464e-06, 1.7335e-06, 1.4302e-06, 1.1847e-06,
     &  9.9434e-07, 8.2689e-07, 7.0589e-07, 6.0750e-07, 5.3176e-07,
     &  4.6936e-07, 4.1541e-07, 3.6625e-07, 3.2509e-07, 2.9156e-07,
     &  2.6308e-07, 2.3819e-07, 2.1421e-07, 1.9366e-07, 1.7626e-07,
     &  1.5982e-07, 1.4567e-07, 1.3354e-07, 1.2097e-07, 1.1029e-07,
     &  1.0063e-07, 9.2003e-08, 8.4245e-08, 7.7004e-08, 7.0636e-08,
     &  6.4923e-08, 5.9503e-08, 5.4742e-08, 5.0450e-08, 4.6470e-08,
     &  4.2881e-08, 3.9550e-08, 3.6541e-08, 3.3803e-08, 3.1279e-08,
     &  2.8955e-08, 2.6858e-08, 2.4905e-08, 2.3146e-08, 2.1539e-08/
      data s(601:700)/
     &  2.0079e-08, 1.8746e-08, 1.7517e-08, 1.6396e-08, 1.5369e-08,
     &  1.4426e-08, 1.3543e-08, 1.2724e-08, 1.1965e-08, 1.1267e-08,
     &  1.0617e-08, 1.0010e-08, 9.4662e-09, 8.9553e-09, 8.4988e-09,
     &  8.0807e-09, 7.7043e-09, 7.3721e-09, 7.0707e-09, 6.8047e-09,
     &  6.5702e-09, 6.3634e-09, 6.1817e-09, 6.0239e-09, 5.8922e-09,
     &  5.7824e-09, 5.7019e-09, 5.6368e-09, 5.5940e-09, 5.5669e-09,
     &  5.5583e-09, 5.5653e-09, 5.5837e-09, 5.6243e-09, 5.6883e-09,
     &  5.7800e-09, 5.8964e-09, 6.0429e-09, 6.2211e-09, 6.4282e-09,
     &  6.6634e-09, 6.9306e-09, 7.2336e-09, 7.5739e-09, 7.9562e-09,
     &  8.3779e-09, 8.8575e-09, 9.3992e-09, 1.0004e-08, 1.0684e-08,
     &  1.1450e-08, 1.2320e-08, 1.3311e-08, 1.4455e-08, 1.5758e-08,
     &  1.7254e-08, 1.8927e-08, 2.0930e-08, 2.3348e-08, 2.6074e-08,
     &  2.9221e-08, 3.2770e-08, 3.7485e-08, 4.2569e-08, 4.8981e-08,
     &  5.5606e-08, 6.2393e-08, 7.1901e-08, 8.2921e-08, 9.5513e-08,
     &  1.1111e-07, 1.3143e-07, 1.5971e-07, 1.8927e-07, 2.2643e-07,
     &  2.7860e-07, 3.2591e-07, 3.7024e-07, 4.2059e-07, 4.9432e-07,
     &  5.5543e-07, 5.7498e-07, 5.9210e-07, 6.1005e-07, 6.1577e-07,
     &  5.9193e-07, 5.6602e-07, 5.7403e-07, 6.0050e-07, 6.4723e-07,
     &  6.7073e-07, 7.5415e-07, 8.0982e-07, 8.7658e-07, 9.1430e-07,
     &  9.4459e-07, 9.8347e-07, 9.8768e-07, 1.0153e-06, 1.0066e-06/
      data s(701:800)/
     &  1.0353e-06, 1.0353e-06, 1.0722e-06, 1.1138e-06, 1.1923e-06,
     &  1.2947e-06, 1.4431e-06, 1.6537e-06, 1.8662e-06, 2.2473e-06,
     &  2.6464e-06, 3.1041e-06, 3.4858e-06, 4.0167e-06, 4.6675e-06,
     &  5.0983e-06, 5.7997e-06, 6.0503e-06, 6.4687e-06, 6.5396e-06,
     &  6.7986e-06, 7.0244e-06, 7.2305e-06, 7.6732e-06, 7.9783e-06,
     &  7.9846e-06, 7.7617e-06, 7.7657e-06, 7.7411e-06, 7.8816e-06,
     &  7.8136e-06, 8.0051e-06, 8.5799e-06, 9.1659e-06, 9.8646e-06,
     &  9.4920e-06, 8.7670e-06, 8.2034e-06, 7.2297e-06, 6.2324e-06,
     &  4.9315e-06, 3.9128e-06, 3.1517e-06, 2.4469e-06, 1.8815e-06,
     &  1.4627e-06, 1.1698e-06, 9.4686e-07, 7.8486e-07, 6.6970e-07,
     &  5.8811e-07, 5.2198e-07, 4.6809e-07, 4.1671e-07, 3.7006e-07,
     &  3.3066e-07, 2.9387e-07, 2.6415e-07, 2.3409e-07, 2.0991e-07,
     &  1.9132e-07, 1.7519e-07, 1.5939e-07, 1.4368e-07, 1.3050e-07,
     &  1.1883e-07, 1.0772e-07, 9.6884e-08, 8.7888e-08, 7.8956e-08,
     &  7.1024e-08, 6.3824e-08, 5.7256e-08, 5.1769e-08, 4.7037e-08,
     &  4.2901e-08, 3.8970e-08, 3.5467e-08, 3.2502e-08, 2.9827e-08,
     &  2.7389e-08, 2.5111e-08, 2.3056e-08, 2.1267e-08, 1.9610e-08,
     &  1.8133e-08, 1.6775e-08, 1.5491e-08, 1.4329e-08, 1.3265e-08,
     &  1.2300e-08, 1.1420e-08, 1.0593e-08, 9.8475e-09, 9.1585e-09,
     &  8.5256e-09, 7.9525e-09, 7.4226e-09, 6.9379e-09, 6.4950e-09/
      data s(801:900)/
     &  6.0911e-09, 5.7242e-09, 5.3877e-09, 5.0821e-09, 4.8051e-09,
     &  4.5554e-09, 4.3315e-09, 4.1336e-09, 3.9632e-09, 3.8185e-09,
     &  3.7080e-09, 3.6296e-09, 3.5804e-09, 3.5776e-09, 3.6253e-09,
     &  3.7115e-09, 3.8151e-09, 3.9804e-09, 4.1742e-09, 4.3581e-09,
     &  4.5306e-09, 4.7736e-09, 5.1297e-09, 5.5291e-09, 5.9125e-09,
     &  6.4956e-09, 7.0362e-09, 7.5318e-09, 7.9947e-09, 8.6438e-09,
     &  9.7227e-09, 1.0130e-08, 1.0549e-08, 1.1064e-08, 1.1702e-08,
     &  1.2043e-08, 1.1781e-08, 1.1838e-08, 1.1917e-08, 1.2131e-08,
     &  1.2476e-08, 1.3611e-08, 1.4360e-08, 1.5057e-08, 1.6247e-08,
     &  1.7284e-08, 1.8420e-08, 1.8352e-08, 1.8722e-08, 1.9112e-08,
     &  1.9092e-08, 1.9311e-08, 1.9411e-08, 1.9884e-08, 2.0508e-08,
     &  2.1510e-08, 2.3143e-08, 2.5050e-08, 2.7596e-08, 3.1231e-08,
     &  3.6260e-08, 4.3410e-08, 5.2240e-08, 6.3236e-08, 7.7522e-08,
     &  9.8688e-08, 1.1859e-07, 1.4341e-07, 1.6798e-07, 1.9825e-07,
     &  2.2898e-07, 2.6257e-07, 2.9884e-07, 3.3247e-07, 3.4936e-07,
     &  3.5583e-07, 3.7150e-07, 3.6580e-07, 3.7124e-07, 3.7030e-07,
     &  4.1536e-07, 4.6656e-07, 4.6677e-07, 4.7507e-07, 4.9653e-07,
     &  5.3795e-07, 5.4957e-07, 5.2238e-07, 5.4690e-07, 5.6569e-07,
     &  5.9844e-07, 5.9835e-07, 5.6522e-07, 5.4123e-07, 4.7904e-07,
     &  4.2851e-07, 3.5603e-07, 2.8932e-07, 2.3655e-07, 1.8592e-07/
      data s(901:1000)/
     &  1.4943e-07, 1.1971e-07, 9.8482e-08, 8.3675e-08, 7.1270e-08,
     &  6.2496e-08, 5.4999e-08, 4.9821e-08, 4.5387e-08, 4.1340e-08,
     &  3.7453e-08, 3.3298e-08, 3.0120e-08, 2.7032e-08, 2.4236e-08,
     &  2.1500e-08, 1.8988e-08, 1.7414e-08, 1.5706e-08, 1.4192e-08,
     &  1.3204e-08, 1.1759e-08, 1.0737e-08, 9.6309e-09, 8.8179e-09,
     &  8.2619e-09, 7.2264e-09, 6.4856e-09, 5.8037e-09, 5.2093e-09,
     &  4.7205e-09, 4.1749e-09, 3.7852e-09, 3.3915e-09, 3.0089e-09,
     &  2.7335e-09, 2.4398e-09, 2.2031e-09, 1.9786e-09, 1.7890e-09,
     &  1.6266e-09, 1.4830e-09, 1.3576e-09, 1.2518e-09, 1.1587e-09,
     &  1.0726e-09, 9.9106e-10, 9.1673e-10, 8.5084e-10, 7.9147e-10,
     &  7.2882e-10, 6.7342e-10, 6.2593e-10, 5.8294e-10, 5.4435e-10,
     &  5.0997e-10, 4.7806e-10, 4.4931e-10, 4.2357e-10, 4.0023e-10,
     &  3.7909e-10, 3.5999e-10, 3.4285e-10, 3.2776e-10, 3.1468e-10,
     &  3.0377e-10, 2.9479e-10, 2.8877e-10, 2.8512e-10, 2.8617e-10,
     &  2.8976e-10, 3.0001e-10, 3.1718e-10, 3.3898e-10, 3.5857e-10,
     &  3.8358e-10, 4.3131e-10, 4.5741e-10, 4.6948e-10, 4.7594e-10,
     &  4.9529e-10, 5.1563e-10, 4.9475e-10, 4.8369e-10, 4.8829e-10,
     &  5.0047e-10, 5.0203e-10, 5.1954e-10, 5.5352e-10, 5.9928e-10,
     &  6.7148e-10, 7.1121e-10, 7.4317e-10, 7.6039e-10, 7.8313e-10,
     &  8.0684e-10, 7.8553e-10, 7.8312e-10, 7.8537e-10, 7.8872e-10/
      data s(1001:1100)/
     &  8.0185e-10, 8.1004e-10, 8.2608e-10, 8.2525e-10, 8.3857e-10,
     &  8.7920e-10, 9.2451e-10, 9.8661e-10, 1.0629e-09, 1.1659e-09,
     &  1.2922e-09, 1.4387e-09, 1.6254e-09, 1.8425e-09, 2.1428e-09,
     &  2.5477e-09, 3.0379e-09, 3.7570e-09, 4.4354e-09, 5.1802e-09,
     &  6.2769e-09, 7.4894e-09, 8.7474e-09, 9.8037e-09, 1.1582e-08,
     &  1.3293e-08, 1.4471e-08, 1.5025e-08, 1.5580e-08, 1.6228e-08,
     &  1.6413e-08, 1.6020e-08, 1.6393e-08, 1.7545e-08, 1.9590e-08,
     &  2.1449e-08, 2.3856e-08, 2.7050e-08, 3.0214e-08, 3.3733e-08,
     &  3.6487e-08, 3.9353e-08, 4.2660e-08, 4.6385e-08, 4.9955e-08,
     &  5.5313e-08, 6.0923e-08, 6.8948e-08, 7.3649e-08, 8.2602e-08,
     &  9.2212e-08, 9.9080e-08, 1.1319e-07, 1.1790e-07, 1.2941e-07,
     &  1.3199e-07, 1.3914e-07, 1.4843e-07, 1.5300e-07, 1.6419e-07,
     &  1.7095e-07, 1.6988e-07, 1.6494e-07, 1.6327e-07, 1.6067e-07,
     &  1.6909e-07, 1.7118e-07, 1.8106e-07, 1.9857e-07, 2.1696e-07,
     &  2.3385e-07, 2.2776e-07, 2.1402e-07, 1.9882e-07, 1.7362e-07,
     &  1.4308e-07, 1.1158e-07, 8.8781e-08, 6.8689e-08, 5.2062e-08,
     &  4.0427e-08, 3.2669e-08, 2.7354e-08, 2.3200e-08, 2.0580e-08,
     &  1.8676e-08, 1.7329e-08, 1.6621e-08, 1.6433e-08, 1.6953e-08,
     &  1.7134e-08, 1.7948e-08, 1.9107e-08, 1.9875e-08, 2.1416e-08,
     &  2.1556e-08, 2.2265e-08, 2.2171e-08, 2.2534e-08, 2.3029e-08/
      data s(1101:1200)/
     &  2.2828e-08, 2.3143e-08, 2.2965e-08, 2.2223e-08, 2.1108e-08,
     &  2.0265e-08, 1.9516e-08, 1.9941e-08, 2.0312e-08, 2.1080e-08,
     &  2.2611e-08, 2.4210e-08, 2.6069e-08, 2.5097e-08, 2.3318e-08,
     &  2.1543e-08, 1.8942e-08, 1.5960e-08, 1.2386e-08, 9.9340e-09,
     &  7.7502e-09, 5.9462e-09, 4.5113e-09, 3.5523e-09, 2.8844e-09,
     &  2.3394e-09, 1.9584e-09, 1.6749e-09, 1.4624e-09, 1.2809e-09,
     &  1.1359e-09, 1.0087e-09, 9.0166e-10, 8.1079e-10, 7.2219e-10,
     &  6.4922e-10, 5.8803e-10, 5.3290e-10, 4.8590e-10, 4.4111e-10,
     &  4.0184e-10, 3.6644e-10, 3.3529e-10, 3.0789e-10, 2.8286e-10,
     &  2.6089e-10, 2.4125e-10, 2.2355e-10, 2.0783e-10, 1.9370e-10,
     &  1.8088e-10, 1.6948e-10, 1.5929e-10, 1.5013e-10, 1.4193e-10,
     &  1.3470e-10, 1.2841e-10, 1.2307e-10, 1.1865e-10, 1.1502e-10,
     &  1.1243e-10, 1.1099e-10, 1.1066e-10, 1.1216e-10, 1.1529e-10,
     &  1.2171e-10, 1.3128e-10, 1.4153e-10, 1.5962e-10, 1.8048e-10,
     &  2.0936e-10, 2.3165e-10, 2.5746e-10, 2.9600e-10, 3.3707e-10,
     &  3.5267e-10, 3.5953e-10, 3.6822e-10, 3.8363e-10, 3.8286e-10,
     &  3.5883e-10, 3.6154e-10, 3.6653e-10, 3.8507e-10, 4.0250e-10,
     &  4.4435e-10, 4.9889e-10, 5.6932e-10, 6.3599e-10, 7.0281e-10,
     &  7.5777e-10, 8.1279e-10, 8.8910e-10, 9.3400e-10, 1.0076e-09,
     &  1.0945e-09, 1.1898e-09, 1.3108e-09, 1.4725e-09, 1.7028e-09/
      data s(1201:1300)/
     &  1.9619e-09, 2.3527e-09, 2.6488e-09, 3.0327e-09, 3.4396e-09,
     &  3.8797e-09, 4.4115e-09, 4.6853e-09, 4.9553e-09, 4.9551e-09,
     &  5.1062e-09, 5.0996e-09, 5.1119e-09, 5.2283e-09, 5.8297e-09,
     &  6.3439e-09, 6.2675e-09, 6.3296e-09, 6.5173e-09, 7.1685e-09,
     &  7.0528e-09, 6.8856e-09, 7.3182e-09, 7.6990e-09, 8.3461e-09,
     &  8.1946e-09, 7.7153e-09, 7.2411e-09, 6.4511e-09, 5.7336e-09,
     &  4.6105e-09, 3.6962e-09, 2.9944e-09, 2.4317e-09, 1.9399e-09,
     &  1.5331e-09, 1.2633e-09, 1.0613e-09, 9.0136e-10, 7.9313e-10,
     &  7.1543e-10, 6.6485e-10, 6.4225e-10, 6.3980e-10, 6.4598e-10,
     &  6.7428e-10, 7.0270e-10, 7.4694e-10, 7.7946e-10, 7.9395e-10,
     &  7.8716e-10, 7.6933e-10, 7.6220e-10, 7.4825e-10, 7.4805e-10,
     &  7.6511e-10, 7.6492e-10, 7.4103e-10, 7.1979e-10, 7.1686e-10,
     &  7.3403e-10, 7.1142e-10, 7.0212e-10, 7.1548e-10, 7.5253e-10,
     &  8.0444e-10, 8.2378e-10, 7.8004e-10, 7.1712e-10, 6.4978e-10,
     &  5.7573e-10, 4.8675e-10, 3.7945e-10, 3.0118e-10, 2.4241e-10,
     &  1.9100e-10, 1.4816e-10, 1.1567e-10, 9.4183e-11, 7.7660e-11,
     &  6.5270e-11, 5.6616e-11, 4.9576e-11, 4.4137e-11, 3.9459e-11,
     &  3.5759e-11, 3.2478e-11, 2.9419e-11, 2.6703e-11, 2.4365e-11,
     &  2.2412e-11, 2.0606e-11, 1.9067e-11, 1.7800e-11, 1.6695e-11,
     &  1.5729e-11, 1.4887e-11, 1.4135e-11, 1.3519e-11, 1.2992e-11/
      data s(1301:1400)/
     &  1.2563e-11, 1.2223e-11, 1.1962e-11, 1.1775e-11, 1.1657e-11,
     &  1.1605e-11, 1.1619e-11, 1.1697e-11, 1.1839e-11, 1.2046e-11,
     &  1.2319e-11, 1.2659e-11, 1.3070e-11, 1.3553e-11, 1.4113e-11,
     &  1.4754e-11, 1.5480e-11, 1.6298e-11, 1.7214e-11, 1.8236e-11,
     &  1.9372e-11, 2.0635e-11, 2.2036e-11, 2.3590e-11, 2.5317e-11,
     &  2.7242e-11, 2.9400e-11, 3.1849e-11, 3.4654e-11, 3.7923e-11,
     &  4.1695e-11, 4.6055e-11, 5.0940e-11, 5.5624e-11, 6.0667e-11,
     &  6.6261e-11, 7.2692e-11, 7.9711e-11, 8.7976e-11, 9.6884e-11,
     &  1.0775e-10, 1.2093e-10, 1.3531e-10, 1.5404e-10, 1.7315e-10,
     &  1.9862e-10, 2.3341e-10, 2.7014e-10, 3.1716e-10, 3.6957e-10,
     &  4.3233e-10, 5.2566e-10, 6.2251e-10, 7.2149e-10, 8.3958e-10,
     &  9.5931e-10, 1.1388e-09, 1.2973e-09, 1.4442e-09, 1.5638e-09,
     &  1.6974e-09, 1.8489e-09, 1.9830e-09, 2.1720e-09, 2.3662e-09,
     &  2.6987e-09, 3.1697e-09, 3.6907e-09, 4.2625e-09, 4.7946e-09,
     &  5.3848e-09, 6.0897e-09, 6.4730e-09, 7.1483e-09, 7.7432e-09,
     &  8.0851e-09, 8.5013e-09, 8.5909e-09, 9.1890e-09, 9.3124e-09,
     &  9.5936e-09, 9.8787e-09, 9.9036e-09, 9.6712e-09, 9.2036e-09,
     &  9.0466e-09, 8.9380e-09, 9.1815e-09, 9.5092e-09, 1.0027e-08,
     &  1.0876e-08, 1.1744e-08, 1.1853e-08, 1.1296e-08, 1.0134e-08,
     &  8.8245e-09, 7.3930e-09, 5.7150e-09, 4.4884e-09, 3.4027e-09/
      data s(1401:1500)/
     &  2.6054e-09, 2.0790e-09, 1.7267e-09, 1.4724e-09, 1.2722e-09,
     &  1.1234e-09, 1.0186e-09, 9.4680e-10, 8.8854e-10, 8.5127e-10,
     &  8.3157e-10, 8.2226e-10, 8.3395e-10, 8.3294e-10, 8.4725e-10,
     &  8.8814e-10, 9.3697e-10, 1.0112e-09, 1.0412e-09, 1.0948e-09,
     &  1.1810e-09, 1.2267e-09, 1.3690e-09, 1.4512e-09, 1.5568e-09,
     &  1.6552e-09, 1.7321e-09, 1.8797e-09, 1.9210e-09, 1.9686e-09,
     &  1.9917e-09, 1.9357e-09, 1.8486e-09, 1.7575e-09, 1.7113e-09,
     &  1.7163e-09, 1.7623e-09, 1.8536e-09, 1.9765e-09, 2.1334e-09,
     &  2.3237e-09, 2.3259e-09, 2.1833e-09, 1.9785e-09, 1.7308e-09,
     &  1.4596e-09, 1.1198e-09, 8.7375e-10, 6.5381e-10, 4.8677e-10,
     &  3.6756e-10, 2.9155e-10, 2.3735e-10, 1.9590e-10, 1.6638e-10,
     &  1.4549e-10, 1.2947e-10, 1.1511e-10, 1.0548e-10, 9.6511e-11,
     &  9.0469e-11, 8.5170e-11, 7.7804e-11, 7.1971e-11, 6.6213e-11,
     &  6.1063e-11, 5.5881e-11, 5.0508e-11, 4.5932e-11, 4.1997e-11,
     &  3.7672e-11, 3.3972e-11, 3.0318e-11, 2.6769e-11, 2.3874e-11,
     &  2.1336e-11, 1.9073e-11, 1.7313e-11, 1.5904e-11, 1.4684e-11,
     &  1.3698e-11, 1.2873e-11, 1.2175e-11, 1.1542e-11, 1.1024e-11,
     &  1.0602e-11, 1.0267e-11, 1.0012e-11, 9.8379e-12, 9.7482e-12,
     &  9.7564e-12, 9.8613e-12, 1.0092e-11, 1.0418e-11, 1.0868e-11,
     &  1.1585e-11, 1.2351e-11, 1.3372e-11, 1.4841e-11, 1.6457e-11/
      data s(1501:1600)/
     &  1.8681e-11, 2.0550e-11, 2.2912e-11, 2.5958e-11, 2.9137e-11,
     &  3.2368e-11, 3.4848e-11, 3.8462e-11, 4.2190e-11, 4.5629e-11,
     &  4.9022e-11, 5.4232e-11, 6.1900e-11, 7.1953e-11, 8.5368e-11,
     &  9.9699e-11, 1.1734e-10, 1.4185e-10, 1.7017e-10, 1.9813e-10,
     &  2.3859e-10, 2.7304e-10, 3.0971e-10, 3.5129e-10, 3.9405e-10,
     &  4.5194e-10, 4.8932e-10, 5.2436e-10, 5.4098e-10, 5.5542e-10,
     &  5.7794e-10, 5.6992e-10, 5.8790e-10, 6.1526e-10, 6.8034e-10,
     &  6.7956e-10, 6.6864e-10, 6.9329e-10, 7.2971e-10, 7.6546e-10,
     &  7.5078e-10, 7.8406e-10, 8.3896e-10, 9.0111e-10, 9.1994e-10,
     &  8.7189e-10, 8.1426e-10, 7.3097e-10, 6.3357e-10, 5.1371e-10,
     &  4.0936e-10, 3.2918e-10, 2.6255e-10, 2.0724e-10, 1.6879e-10,
     &  1.4165e-10, 1.1989e-10, 1.0125e-10, 8.9629e-11, 7.8458e-11,
     &  6.8826e-11, 6.0935e-11, 5.5208e-11, 5.2262e-11, 5.0260e-11,
     &  4.8457e-11, 4.7888e-11, 4.8032e-11, 5.0838e-11, 5.4668e-11,
     &  5.5790e-11, 6.0056e-11, 6.3811e-11, 6.8848e-11, 7.4590e-11,
     &  7.8249e-11, 8.3371e-11, 8.3641e-11, 8.6591e-11, 8.9599e-11,
     &  9.3487e-11, 1.0066e-10, 1.0765e-10, 1.0851e-10, 1.0619e-10,
     &  1.0557e-10, 1.0460e-10, 1.0796e-10, 1.0523e-10, 1.0674e-10,
     &  1.1261e-10, 1.1431e-10, 1.1408e-10, 1.0901e-10, 9.9105e-11,
     &  8.8077e-11, 6.9928e-11, 5.4595e-11, 4.5401e-11, 3.6313e-11/
      data s(1601:1700)/
     &  2.6986e-11, 1.9463e-11, 1.4577e-11, 1.1583e-11, 9.5492e-12,
     &  8.0770e-12, 6.9642e-12, 6.0966e-12, 5.4046e-12, 4.8431e-12,
     &  4.3815e-12, 3.9987e-12, 3.6790e-12, 3.4113e-12, 3.1868e-12,
     &  2.9992e-12, 2.8434e-12, 2.7153e-12, 2.6120e-12, 2.5311e-12,
     &  2.4705e-12, 2.4290e-12, 2.4053e-12, 2.3988e-12, 2.4087e-12,
     &  2.4349e-12, 2.4771e-12, 2.5355e-12, 2.6103e-12, 2.7019e-12,
     &  2.8110e-12, 2.9383e-12, 3.0848e-12, 3.2518e-12, 3.4405e-12,
     &  3.6527e-12, 3.8902e-12, 4.1555e-12, 4.4510e-12, 4.7801e-12,
     &  5.1462e-12, 5.5539e-12, 6.0086e-12, 6.5171e-12, 7.0884e-12,
     &  7.7357e-12, 8.4831e-12, 9.3096e-12, 1.0282e-11, 1.1407e-11,
     &  1.2690e-11, 1.4148e-11, 1.5888e-11, 1.7992e-11, 2.0523e-11,
     &  2.3342e-11, 2.6578e-11, 3.0909e-11, 3.6228e-11, 4.2053e-11,
     &  4.9059e-11, 5.9273e-11, 7.0166e-11, 8.2298e-11, 9.7071e-11,
     &  1.1673e-10, 1.4010e-10, 1.6621e-10, 2.0127e-10, 2.3586e-10,
     &  2.7050e-10, 3.0950e-10, 3.6584e-10, 4.1278e-10, 4.6591e-10,
     &  5.2220e-10, 5.5246e-10, 6.1500e-10, 6.5878e-10, 7.1167e-10,
     &  7.9372e-10, 8.6975e-10, 9.6459e-10, 9.7368e-10, 9.8142e-10,
     &  1.0202e-09, 1.0200e-09, 1.0356e-09, 1.0092e-09, 1.0269e-09,
     &  1.0366e-09, 1.0490e-09, 1.0717e-09, 1.0792e-09, 1.1016e-09,
     &  1.0849e-09, 1.0929e-09, 1.0971e-09, 1.0969e-09, 1.0460e-09/
      data s(1701:1800)/
     &  9.2026e-10, 8.1113e-10, 6.8635e-10, 5.5369e-10, 4.2908e-10,
     &  3.3384e-10, 2.6480e-10, 2.0810e-10, 1.6915e-10, 1.4051e-10,
     &  1.1867e-10, 1.0158e-10, 8.8990e-11, 7.9175e-11, 7.0440e-11,
     &  6.3453e-11, 5.7009e-11, 5.1662e-11, 4.7219e-11, 4.3454e-11,
     &  4.0229e-11, 3.7689e-11, 3.6567e-11, 3.5865e-11, 3.5955e-11,
     &  3.5928e-11, 3.6298e-11, 3.7629e-11, 3.9300e-11, 4.1829e-11,
     &  4.4806e-11, 5.0534e-11, 5.6672e-11, 6.2138e-11, 6.8678e-11,
     &  7.6111e-11, 8.4591e-11, 9.2634e-11, 9.8085e-11, 1.0830e-10,
     &  1.1949e-10, 1.2511e-10, 1.3394e-10, 1.3505e-10, 1.4342e-10,
     &  1.4874e-10, 1.4920e-10, 1.5872e-10, 1.5972e-10, 1.5821e-10,
     &  1.5425e-10, 1.4937e-10, 1.5089e-10, 1.5521e-10, 1.6325e-10,
     &  1.6924e-10, 1.8265e-10, 1.9612e-10, 2.0176e-10, 1.9359e-10,
     &  1.7085e-10, 1.5197e-10, 1.2646e-10, 9.8552e-11, 7.4530e-11,
     &  5.5052e-11, 4.2315e-11, 3.2736e-11, 2.6171e-11, 2.1909e-11,
     &  1.8286e-11, 1.5752e-11, 1.3859e-11, 1.2288e-11, 1.1002e-11,
     &  9.7534e-12, 8.8412e-12, 8.0169e-12, 7.2855e-12, 6.8734e-12,
     &  6.4121e-12, 6.1471e-12, 5.7780e-12, 5.3478e-12, 4.9652e-12,
     &  4.4043e-12, 3.9862e-12, 3.4684e-12, 2.9681e-12, 2.5791e-12,
     &  2.2339e-12, 1.9247e-12, 1.6849e-12, 1.4863e-12, 1.3291e-12,
     &  1.2021e-12, 1.0947e-12, 1.0015e-12, 9.1935e-13, 8.4612e-13/
      data s(1801:1900)/
     &  7.8036e-13, 7.2100e-13, 6.6718e-13, 6.1821e-13, 5.7353e-13,
     &  5.3269e-13, 4.9526e-13, 4.6093e-13, 4.2937e-13, 4.0034e-13,
     &  3.7361e-13, 3.4895e-13, 3.2621e-13, 3.0520e-13, 2.8578e-13,
     &  2.6782e-13, 2.5120e-13, 2.3581e-13, 2.2154e-13, 2.0832e-13,
     &  1.9605e-13, 1.8466e-13, 1.7408e-13, 1.6425e-13, 1.5511e-13,
     &  1.4661e-13, 1.3869e-13, 1.3131e-13, 1.2444e-13, 1.1803e-13,
     &  1.1205e-13, 1.0646e-13, 1.0124e-13, 9.6358e-14, 9.1789e-14,
     &  8.7509e-14, 8.3498e-14, 7.9735e-14, 7.6202e-14, 7.2882e-14,
     &  6.9760e-14, 6.6822e-14, 6.4053e-14, 6.1442e-14, 5.8978e-14,
     &  5.6650e-14, 5.4448e-14, 5.2364e-14, 5.0389e-14, 4.8516e-14,
     &  4.6738e-14, 4.5048e-14, 4.3441e-14, 4.1911e-14, 4.0453e-14,
     &  3.9063e-14, 3.7735e-14, 3.6467e-14, 3.5254e-14, 3.4093e-14,
     &  3.2980e-14, 3.1914e-14, 3.0891e-14, 2.9909e-14, 2.8965e-14,
     &  2.8058e-14, 2.7185e-14, 2.6344e-14, 2.5535e-14, 2.4755e-14,
     &  2.4002e-14, 2.3276e-14, 2.2576e-14, 2.1899e-14, 2.1245e-14,
     &  2.0613e-14, 2.0002e-14, 1.9411e-14, 1.8839e-14, 1.8285e-14,
     &  1.7749e-14, 1.7230e-14, 1.6727e-14, 1.6240e-14, 1.5768e-14,
     &  1.5310e-14, 1.4867e-14, 1.4436e-14, 1.4019e-14, 1.3614e-14,
     &  1.3221e-14, 1.2840e-14, 1.2471e-14, 1.2112e-14, 1.1764e-14,
     &  1.1425e-14, 1.1097e-14, 1.0779e-14, 1.0469e-14, 1.0169e-14/
      data s(1901:2000)/
     &  9.8775e-15, 9.5943e-15, 9.3193e-15, 9.0522e-15, 8.7928e-15,
     &  8.5409e-15, 8.2962e-15, 8.0586e-15, 7.8278e-15, 7.6036e-15,
     &  7.3858e-15, 7.1742e-15, 6.9687e-15, 6.7691e-15, 6.5752e-15,
     &  6.3868e-15, 6.2038e-15, 6.0260e-15, 5.8533e-15, 5.6856e-15,
     &  5.5226e-15, 5.3642e-15, 5.2104e-15, 5.0610e-15, 4.9158e-15,
     &  4.7748e-15, 4.6378e-15, 4.5047e-15, 4.3753e-15, 4.2497e-15,
     &  4.1277e-15, 4.0091e-15, 3.8939e-15, 3.7820e-15, 3.6733e-15,
     &  3.5677e-15, 3.4651e-15, 3.3655e-15, 3.2686e-15, 3.1746e-15,
     &  3.0832e-15, 2.9944e-15, 2.9082e-15, 2.8244e-15, 2.7431e-15,
     &  2.6640e-15, 2.5872e-15, 2.5126e-15, 2.4401e-15, 2.3697e-15,
     &  2.3014e-15, 2.2349e-15, 2.1704e-15, 2.1077e-15, 2.0468e-15,
     &  1.9877e-15, 1.9302e-15, 1.8744e-15, 1.8202e-15, 1.7675e-15,
     &  1.7164e-15, 1.6667e-15, 1.6184e-15, 1.5716e-15, 1.5260e-15,
     &  1.4818e-15, 1.4389e-15, 1.3971e-15, 1.3566e-15, 1.3172e-15,
     &  1.2790e-15, 1.2419e-15, 1.2058e-15, 1.1708e-15, 1.1368e-15,
     &  1.1037e-15, 1.0716e-15, 1.0405e-15, 1.0102e-15, 9.8079e-16,
     &  9.5224e-16, 9.2451e-16, 8.9758e-16, 8.7142e-16, 8.4602e-16,
     &  8.2136e-16, 7.9740e-16, 7.7414e-16, 7.5154e-16, 7.2961e-16,
     &  7.0830e-16, 6.8761e-16, 6.6752e-16, 6.4801e-16, 6.2906e-16,
     &  6.1066e-16, 5.9280e-16, 5.7545e-16, 5.5860e-16, 5.4224e-16/
      data s(2001:2003)/
     &  5.2636e-16, 5.1094e-16, 4.9596e-16/

cccc
      call sint(v1,v,dv,npts,s,sh2ot1)
      return
      end
c=======================================================================
      subroutine frn296(v,fh2o)

c     water vapor foreign continuum at 296K

      use params, only: kr
      implicit none
      integer, parameter :: npts=2003
      real(kr) :: v, fh2o, v1=-20, v2=20000.0, dv=10., f(npts)

      ! units of (cm**3/mol) * 1.e-20

      data f(1:100)/
     & 1.2859e-02, 1.1715e-02, 1.1038e-02, 1.1715e-02, 1.2859e-02, 
     & 1.5326e-02, 1.6999e-02, 1.8321e-02, 1.9402e-02, 1.9570e-02, 
     & 1.9432e-02, 1.7572e-02, 1.6760e-02, 1.5480e-02, 1.3984e-02, 
     & 1.2266e-02, 1.0467e-02, 9.4526e-03, 8.0485e-03, 6.9484e-03, 
     & 6.1416e-03, 5.0941e-03, 4.4836e-03, 3.8133e-03, 3.4608e-03, 
     & 3.1487e-03, 2.4555e-03, 2.0977e-03, 1.7266e-03, 1.4920e-03, 
     & 1.2709e-03, 9.8081e-04, 8.5063e-04, 6.8822e-04, 5.3809e-04, 
     & 4.4679e-04, 3.3774e-04, 2.7979e-04, 2.1047e-04, 1.6511e-04, 
     & 1.2993e-04, 9.3033e-05, 7.4360e-05, 5.6428e-05, 4.5442e-05, 
     & 3.4575e-05, 2.7903e-05, 2.1374e-05, 1.6075e-05, 1.3022e-05, 
     & 1.0962e-05, 8.5959e-06, 6.9125e-06, 5.3808e-06, 4.3586e-06, 
     & 3.6394e-06, 2.9552e-06, 2.3547e-06, 1.8463e-06, 1.6036e-06, 
     & 1.3483e-06, 1.1968e-06, 1.0333e-06, 8.4484e-07, 6.7195e-07, 
     & 5.0947e-07, 4.2343e-07, 3.4453e-07, 2.7830e-07, 2.3063e-07, 
     & 1.9951e-07, 1.7087e-07, 1.4393e-07, 1.2575e-07, 1.0750e-07, 
     & 8.2325e-08, 5.7524e-08, 4.4482e-08, 3.8106e-08, 3.4315e-08, 
     & 2.9422e-08, 2.5069e-08, 2.2402e-08, 1.9349e-08, 1.6152e-08, 
     & 1.2208e-08, 8.9660e-09, 7.1322e-09, 6.1028e-09, 5.2938e-09, 
     & 4.5350e-09, 3.4977e-09, 2.9511e-09, 2.4734e-09, 2.0508e-09, 
     & 1.8507e-09, 1.6373e-09, 1.5171e-09, 1.3071e-09, 1.2462e-09/
      data f(101:200)/
     & 1.2148e-09, 1.2590e-09, 1.3153e-09, 1.3301e-09, 1.4483e-09, 
     & 1.6944e-09, 2.0559e-09, 2.2954e-09, 2.6221e-09, 3.2606e-09, 
     & 4.2392e-09, 5.2171e-09, 6.2553e-09, 8.2548e-09, 9.5842e-09, 
     & 1.1280e-08, 1.3628e-08, 1.7635e-08, 2.1576e-08, 2.4835e-08, 
     & 3.0014e-08, 3.8485e-08, 4.7440e-08, 5.5202e-08, 7.0897e-08, 
     & 9.6578e-08, 1.3976e-07, 1.8391e-07, 2.3207e-07, 2.9960e-07, 
     & 4.0408e-07, 5.9260e-07, 7.8487e-07, 1.0947e-06, 1.4676e-06, 
     & 1.9325e-06, 2.6587e-06, 3.4534e-06, 4.4376e-06, 5.8061e-06, 
     & 7.0141e-06, 8.4937e-06, 1.0186e-05, 1.2034e-05, 1.3837e-05, 
     & 1.6595e-05, 1.9259e-05, 2.1620e-05, 2.3681e-05, 2.7064e-05, 
     & 3.2510e-05, 3.5460e-05, 3.9109e-05, 4.2891e-05, 4.7757e-05, 
     & 5.0981e-05, 5.0527e-05, 4.8618e-05, 4.4001e-05, 3.7982e-05, 
     & 3.2667e-05, 2.7794e-05, 2.4910e-05, 2.4375e-05, 2.7316e-05, 
     & 3.2579e-05, 3.5499e-05, 3.8010e-05, 4.1353e-05, 4.3323e-05, 
     & 4.3004e-05, 3.9790e-05, 3.7718e-05, 3.6360e-05, 3.2386e-05, 
     & 2.7409e-05, 2.3626e-05, 2.0631e-05, 1.8371e-05, 1.5445e-05, 
     & 1.2989e-05, 1.1098e-05, 9.6552e-06, 8.0649e-06, 7.2365e-06, 
     & 5.9137e-06, 5.2759e-06, 4.8860e-06, 4.1321e-06, 3.5918e-06, 
     & 2.7640e-06, 2.4892e-06, 2.1018e-06, 1.7848e-06, 1.5855e-06, 
     & 1.3569e-06, 1.1986e-06, 9.4693e-07, 7.4097e-07, 6.3443e-07/
      data f(201:300)/
     & 4.8131e-07, 4.0942e-07, 3.3316e-07, 2.8488e-07, 2.3461e-07, 
     & 1.7397e-07, 1.4684e-07, 1.0953e-07, 8.5396e-08, 6.9261e-08, 
     & 5.4001e-08, 4.5430e-08, 3.2791e-08, 2.5995e-08, 2.0225e-08, 
     & 1.5710e-08, 1.3027e-08, 1.0229e-08, 8.5277e-09, 6.5249e-09, 
     & 5.0117e-09, 3.9906e-09, 3.2332e-09, 2.7847e-09, 2.4570e-09, 
     & 2.3359e-09, 2.0599e-09, 1.8436e-09, 1.6559e-09, 1.4910e-09, 
     & 1.2794e-09, 9.8229e-10, 8.0054e-10, 6.0769e-10, 4.5646e-10, 
     & 3.3111e-10, 2.4428e-10, 1.8007e-10, 1.3291e-10, 9.7974e-11, 
     & 7.8271e-11, 6.3833e-11, 5.4425e-11, 4.6471e-11, 4.0209e-11, 
     & 3.5227e-11, 3.1212e-11, 2.8840e-11, 2.7762e-11, 2.7935e-11, 
     & 3.2012e-11, 3.9525e-11, 5.0303e-11, 6.8027e-11, 9.3954e-11, 
     & 1.2986e-10, 1.8478e-10, 2.5331e-10, 3.4827e-10, 4.6968e-10, 
     & 6.2380e-10, 7.9106e-10, 1.0026e-09, 1.2102e-09, 1.4146e-09, 
     & 1.6154e-09, 1.7510e-09, 1.8575e-09, 1.8742e-09, 1.8700e-09, 
     & 1.8582e-09, 1.9657e-09, 2.1204e-09, 2.0381e-09, 2.0122e-09, 
     & 2.0436e-09, 2.1213e-09, 2.0742e-09, 1.9870e-09, 2.0465e-09, 
     & 2.1556e-09, 2.2222e-09, 2.1977e-09, 2.1047e-09, 1.9334e-09, 
     & 1.7357e-09, 1.5754e-09, 1.4398e-09, 1.4018e-09, 1.5459e-09, 
     & 1.7576e-09, 2.1645e-09, 2.9480e-09, 4.4439e-09, 5.8341e-09, 
     & 8.0757e-09, 1.1658e-08, 1.6793e-08, 2.2694e-08, 2.9468e-08/
      data f(301:400)/
     & 3.9278e-08, 5.2145e-08, 6.4378e-08, 7.7947e-08, 8.5321e-08, 
     & 9.7848e-08, 1.0999e-07, 1.1489e-07, 1.2082e-07, 1.2822e-07, 
     & 1.4053e-07, 1.5238e-07, 1.5454e-07, 1.5018e-07, 1.4048e-07, 
     & 1.2359e-07, 1.0858e-07, 9.3486e-08, 8.1638e-08, 7.7690e-08, 
     & 8.4625e-08, 1.0114e-07, 1.1430e-07, 1.2263e-07, 1.3084e-07, 
     & 1.3380e-07, 1.3573e-07, 1.3441e-07, 1.2962e-07, 1.2638e-07, 
     & 1.1934e-07, 1.1371e-07, 1.0871e-07, 9.8843e-08, 9.1877e-08, 
     & 9.1050e-08, 9.3213e-08, 9.2929e-08, 1.0155e-07, 1.1263e-07, 
     & 1.2370e-07, 1.3636e-07, 1.5400e-07, 1.7656e-07, 2.1329e-07, 
     & 2.3045e-07, 2.5811e-07, 2.9261e-07, 3.4259e-07, 4.0770e-07, 
     & 4.8771e-07, 5.8081e-07, 7.2895e-07, 8.7482e-07, 1.0795e-06, 
     & 1.3384e-06, 1.7208e-06, 2.0677e-06, 2.5294e-06, 3.1123e-06, 
     & 3.7900e-06, 4.7752e-06, 5.6891e-06, 6.6261e-06, 7.6246e-06, 
     & 8.7730e-06, 9.6672e-06, 1.0980e-05, 1.1287e-05, 1.1670e-05, 
     & 1.1635e-05, 1.1768e-05, 1.2039e-05, 1.2253e-05, 1.3294e-05, 
     & 1.4005e-05, 1.3854e-05, 1.3420e-05, 1.3003e-05, 1.2645e-05, 
     & 1.1715e-05, 1.1258e-05, 1.1516e-05, 1.2494e-05, 1.3655e-05, 
     & 1.4931e-05, 1.4649e-05, 1.3857e-05, 1.3120e-05, 1.1791e-05, 
     & 1.0637e-05, 8.2760e-06, 6.5821e-06, 5.1959e-06, 4.0158e-06, 
     & 3.0131e-06, 2.0462e-06, 1.4853e-06, 1.0365e-06, 7.3938e-07/
      data f(401:500)/
     & 4.9752e-07, 3.4148e-07, 2.4992e-07, 1.8363e-07, 1.4591e-07, 
     & 1.1380e-07, 9.0588e-08, 7.3697e-08, 6.0252e-08, 5.1868e-08, 
     & 4.2660e-08, 3.6163e-08, 3.2512e-08, 2.9258e-08, 2.4238e-08, 
     & 2.1209e-08, 1.6362e-08, 1.3871e-08, 1.2355e-08, 9.6940e-09, 
     & 7.7735e-09, 6.2278e-09, 5.2282e-09, 4.3799e-09, 3.5545e-09, 
     & 2.7527e-09, 2.0950e-09, 1.6344e-09, 1.2689e-09, 1.0403e-09, 
     & 8.4880e-10, 6.3461e-10, 4.7657e-10, 3.5220e-10, 2.7879e-10, 
     & 2.3021e-10, 1.6167e-10, 1.1732e-10, 8.9206e-11, 7.0596e-11, 
     & 5.8310e-11, 4.4084e-11, 3.1534e-11, 2.5068e-11, 2.2088e-11, 
     & 2.2579e-11, 2.2637e-11, 2.5705e-11, 3.2415e-11, 4.6116e-11, 
     & 6.5346e-11, 9.4842e-11, 1.2809e-10, 1.8211e-10, 2.4052e-10, 
     & 3.0270e-10, 3.5531e-10, 4.2402e-10, 4.6730e-10, 4.7942e-10, 
     & 4.6813e-10, 4.5997e-10, 4.5788e-10, 4.0311e-10, 3.7367e-10, 
     & 3.3149e-10, 2.9281e-10, 2.5231e-10, 2.1152e-10, 1.9799e-10, 
     & 1.8636e-10, 1.9085e-10, 2.0786e-10, 2.2464e-10, 2.3785e-10, 
     & 2.5684e-10, 2.7499e-10, 2.6962e-10, 2.6378e-10, 2.6297e-10, 
     & 2.6903e-10, 2.7035e-10, 2.5394e-10, 2.5655e-10, 2.7184e-10, 
     & 2.9013e-10, 3.0585e-10, 3.0791e-10, 3.1667e-10, 3.4343e-10, 
     & 3.7365e-10, 4.0269e-10, 4.7260e-10, 5.6584e-10, 6.9791e-10, 
     & 8.6569e-10, 1.0393e-09, 1.2067e-09, 1.5047e-09, 1.8583e-09/
      data f(501:600)/
     & 2.2357e-09, 2.6498e-09, 3.2483e-09, 3.9927e-09, 4.6618e-09, 
     & 5.5555e-09, 6.6609e-09, 8.2139e-09, 1.0285e-08, 1.3919e-08, 
     & 1.8786e-08, 2.5150e-08, 3.3130e-08, 4.5442e-08, 6.3370e-08, 
     & 9.0628e-08, 1.2118e-07, 1.5927e-07, 2.1358e-07, 2.7825e-07, 
     & 3.7671e-07, 4.4894e-07, 5.4442e-07, 6.2240e-07, 7.3004e-07, 
     & 8.3384e-07, 8.7933e-07, 8.8080e-07, 8.6939e-07, 8.6541e-07, 
     & 8.2055e-07, 7.7278e-07, 7.5989e-07, 8.6909e-07, 9.7945e-07, 
     & 1.0394e-06, 1.0646e-06, 1.1509e-06, 1.2017e-06, 1.1915e-06, 
     & 1.1259e-06, 1.1549e-06, 1.1938e-06, 1.2356e-06, 1.2404e-06, 
     & 1.1716e-06, 1.1149e-06, 1.0073e-06, 8.9845e-07, 7.6639e-07, 
     & 6.1517e-07, 5.0887e-07, 4.1269e-07, 3.2474e-07, 2.5698e-07, 
     & 1.8893e-07, 1.4009e-07, 1.0340e-07, 7.7724e-08, 5.7302e-08, 
     & 4.2178e-08, 2.9603e-08, 2.1945e-08, 1.6301e-08, 1.2806e-08, 
     & 1.0048e-08, 7.8970e-09, 6.1133e-09, 4.9054e-09, 4.1985e-09, 
     & 3.6944e-09, 3.2586e-09, 2.7362e-09, 2.3647e-09, 2.1249e-09, 
     & 1.8172e-09, 1.6224e-09, 1.5158e-09, 1.2361e-09, 1.0682e-09, 
     & 9.2312e-10, 7.9220e-10, 6.8174e-10, 5.6147e-10, 4.8268e-10, 
     & 4.1534e-10, 3.3106e-10, 2.8275e-10, 2.4584e-10, 2.0742e-10, 
     & 1.7840e-10, 1.4664e-10, 1.2390e-10, 1.0497e-10, 8.5038e-11, 
     & 6.7008e-11, 5.6355e-11, 4.3323e-11, 3.6914e-11, 3.2262e-11/
      data f(601:700)/
     & 3.0749e-11, 3.0318e-11, 2.9447e-11, 2.9918e-11, 3.0668e-11, 
     & 3.1315e-11, 3.0329e-11, 2.8259e-11, 2.6065e-11, 2.3578e-11, 
     & 2.0469e-11, 1.6908e-11, 1.4912e-11, 1.1867e-11, 9.9730e-12, 
     & 8.1014e-12, 6.7528e-12, 6.3133e-12, 5.8599e-12, 6.0145e-12, 
     & 6.5105e-12, 7.0537e-12, 7.4973e-12, 7.8519e-12, 8.5039e-12, 
     & 9.1995e-12, 1.0694e-11, 1.1659e-11, 1.2685e-11, 1.3087e-11, 
     & 1.3222e-11, 1.2634e-11, 1.1077e-11, 9.6259e-12, 8.3202e-12, 
     & 7.4857e-12, 6.8069e-12, 6.7496e-12, 7.3116e-12, 8.0171e-12, 
     & 8.6394e-12, 9.2659e-12, 1.0048e-11, 1.0941e-11, 1.2226e-11, 
     & 1.3058e-11, 1.5193e-11, 1.8923e-11, 2.3334e-11, 2.8787e-11, 
     & 3.6693e-11, 4.8295e-11, 6.4260e-11, 8.8269e-11, 1.1865e-10, 
     & 1.5961e-10, 2.0605e-10, 2.7349e-10, 3.7193e-10, 4.8216e-10, 
     & 6.1966e-10, 7.7150e-10, 1.0195e-09, 1.2859e-09, 1.6535e-09, 
     & 2.0316e-09, 2.3913e-09, 3.0114e-09, 3.7495e-09, 4.6504e-09, 
     & 5.9145e-09, 7.6840e-09, 1.0304e-08, 1.3010e-08, 1.6441e-08, 
     & 2.1475e-08, 2.5892e-08, 2.9788e-08, 3.3820e-08, 4.0007e-08, 
     & 4.4888e-08, 4.5765e-08, 4.6131e-08, 4.6239e-08, 4.4849e-08, 
     & 4.0729e-08, 3.6856e-08, 3.6164e-08, 3.7606e-08, 4.1457e-08, 
     & 4.3750e-08, 5.1150e-08, 5.6054e-08, 6.1586e-08, 6.4521e-08, 
     & 6.6494e-08, 6.9024e-08, 6.8893e-08, 7.0901e-08, 6.9760e-08/
      data f(701:800)/
     & 7.1485e-08, 7.0740e-08, 7.3764e-08, 7.6618e-08, 8.4182e-08, 
     & 9.3838e-08, 1.0761e-07, 1.2851e-07, 1.4748e-07, 1.8407e-07, 
     & 2.2109e-07, 2.6392e-07, 2.9887e-07, 3.4493e-07, 4.0336e-07, 
     & 4.3551e-07, 4.9231e-07, 5.0728e-07, 5.3781e-07, 5.3285e-07, 
     & 5.4496e-07, 5.5707e-07, 5.6944e-07, 6.1123e-07, 6.4317e-07, 
     & 6.4581e-07, 6.1999e-07, 6.0191e-07, 5.7762e-07, 5.7241e-07, 
     & 5.7013e-07, 6.0160e-07, 6.6905e-07, 7.4095e-07, 8.2121e-07, 
     & 8.0947e-07, 7.6145e-07, 7.2193e-07, 6.3722e-07, 5.4316e-07, 
     & 4.2186e-07, 3.2528e-07, 2.5207e-07, 1.8213e-07, 1.2658e-07, 
     & 8.6746e-08, 6.0216e-08, 4.1122e-08, 2.8899e-08, 2.1740e-08, 
     & 1.7990e-08, 1.5593e-08, 1.3970e-08, 1.2238e-08, 1.0539e-08, 
     & 9.2386e-09, 7.8481e-09, 6.8704e-09, 5.7615e-09, 5.0434e-09, 
     & 4.6886e-09, 4.3770e-09, 3.9768e-09, 3.5202e-09, 3.1854e-09, 
     & 2.9009e-09, 2.5763e-09, 2.2135e-09, 1.9455e-09, 1.6248e-09, 
     & 1.3368e-09, 1.0842e-09, 8.4254e-10, 6.7414e-10, 5.4667e-10, 
     & 4.5005e-10, 3.4932e-10, 2.6745e-10, 2.2053e-10, 1.8162e-10, 
     & 1.4935e-10, 1.1618e-10, 9.1888e-11, 8.0672e-11, 6.8746e-11, 
     & 6.2668e-11, 5.5715e-11, 4.5074e-11, 3.7669e-11, 3.2082e-11, 
     & 2.8085e-11, 2.4838e-11, 1.9791e-11, 1.6964e-11, 1.3887e-11, 
     & 1.1179e-11, 9.7499e-12, 7.8255e-12, 6.3698e-12, 5.3265e-12/
      data f(801:900)/
     & 4.6588e-12, 4.4498e-12, 3.9984e-12, 3.7513e-12, 3.7176e-12, 
     & 3.9148e-12, 4.2702e-12, 5.0090e-12, 6.5801e-12, 8.7787e-12, 
     & 1.2718e-11, 1.8375e-11, 2.5304e-11, 3.5403e-11, 4.8842e-11, 
     & 6.4840e-11, 8.0911e-11, 1.0136e-10, 1.2311e-10, 1.4203e-10, 
     & 1.5869e-10, 1.8093e-10, 2.1370e-10, 2.5228e-10, 2.8816e-10, 
     & 3.4556e-10, 3.9860e-10, 4.4350e-10, 4.7760e-10, 5.2357e-10, 
     & 6.0827e-10, 6.3635e-10, 6.5886e-10, 6.8753e-10, 7.2349e-10, 
     & 7.2789e-10, 6.8232e-10, 6.6081e-10, 6.4232e-10, 6.3485e-10, 
     & 6.4311e-10, 7.2235e-10, 7.7263e-10, 8.1668e-10, 9.0324e-10, 
     & 9.7643e-10, 1.0535e-09, 1.0195e-09, 1.0194e-09, 1.0156e-09, 
     & 9.6792e-10, 9.2725e-10, 8.7347e-10, 8.4484e-10, 8.2647e-10, 
     & 8.4363e-10, 9.1261e-10, 1.0051e-09, 1.1511e-09, 1.4037e-09, 
     & 1.8066e-09, 2.4483e-09, 3.2739e-09, 4.3194e-09, 5.6902e-09, 
     & 7.7924e-09, 9.7376e-09, 1.2055e-08, 1.4303e-08, 1.6956e-08, 
     & 1.9542e-08, 2.2233e-08, 2.5186e-08, 2.7777e-08, 2.8943e-08, 
     & 2.8873e-08, 2.9417e-08, 2.7954e-08, 2.7524e-08, 2.7040e-08, 
     & 3.1254e-08, 3.6843e-08, 3.7797e-08, 3.8713e-08, 4.0135e-08, 
     & 4.2824e-08, 4.3004e-08, 4.0279e-08, 4.2781e-08, 4.5220e-08, 
     & 4.8948e-08, 5.0172e-08, 4.8499e-08, 4.7182e-08, 4.2204e-08, 
     & 3.7701e-08, 3.0972e-08, 2.4654e-08, 1.9543e-08, 1.4609e-08/
      data f(901:1000)/
     & 1.1171e-08, 8.3367e-09, 6.3791e-09, 5.0790e-09, 4.0655e-09, 
     & 3.3658e-09, 2.7882e-09, 2.4749e-09, 2.2287e-09, 2.0217e-09, 
     & 1.8191e-09, 1.5897e-09, 1.4191e-09, 1.2448e-09, 1.0884e-09, 
     & 9.3585e-10, 7.9429e-10, 7.3214e-10, 6.5008e-10, 5.7549e-10, 
     & 5.4300e-10, 4.7251e-10, 4.3451e-10, 3.8446e-10, 3.5589e-10, 
     & 3.4432e-10, 2.8209e-10, 2.4620e-10, 2.1278e-10, 1.8406e-10, 
     & 1.6314e-10, 1.3261e-10, 1.1696e-10, 9.6865e-11, 7.6814e-11, 
     & 6.6411e-11, 5.0903e-11, 4.0827e-11, 3.0476e-11, 2.3230e-11, 
     & 1.7707e-11, 1.3548e-11, 1.0719e-11, 9.3026e-12, 8.7967e-12, 
     & 8.3136e-12, 7.3918e-12, 6.5293e-12, 5.9243e-12, 5.3595e-12, 
     & 3.5266e-12, 2.2571e-12, 1.6150e-12, 1.1413e-12, 8.4998e-13, 
     & 7.0803e-13, 5.1747e-13, 4.0694e-13, 3.6528e-13, 3.3670e-13, 
     & 3.1341e-13, 2.9390e-13, 2.8680e-13, 3.1283e-13, 3.7294e-13, 
     & 5.0194e-13, 6.7919e-13, 1.0455e-12, 1.5230e-12, 2.3932e-12, 
     & 3.4231e-12, 5.0515e-12, 7.3193e-12, 9.9406e-12, 1.2193e-11, 
     & 1.4742e-11, 1.9269e-11, 2.1816e-11, 2.2750e-11, 2.2902e-11, 
     & 2.3888e-11, 2.4902e-11, 2.2160e-11, 2.0381e-11, 1.9903e-11, 
     & 2.0086e-11, 1.9304e-11, 2.0023e-11, 2.2244e-11, 2.5450e-11, 
     & 3.1228e-11, 3.4560e-11, 3.6923e-11, 3.7486e-11, 3.8124e-11, 
     & 3.8317e-11, 3.4737e-11, 3.3037e-11, 3.1724e-11, 2.9840e-11/
      data f(1001:1100)/
     & 2.8301e-11, 2.5857e-11, 2.3708e-11, 1.9452e-11, 1.6232e-11, 
     & 1.5174e-11, 1.4206e-11, 1.4408e-11, 1.5483e-11, 1.8642e-11, 
     & 2.3664e-11, 3.0181e-11, 4.0160e-11, 5.2287e-11, 7.2754e-11, 
     & 1.0511e-10, 1.4531e-10, 2.0998e-10, 2.6883e-10, 3.3082e-10, 
     & 4.2638e-10, 5.3132e-10, 6.3617e-10, 7.1413e-10, 8.5953e-10, 
     & 9.9715e-10, 1.0796e-09, 1.0978e-09, 1.1052e-09, 1.1095e-09, 
     & 1.0641e-09, 9.7881e-10, 9.6590e-10, 1.0332e-09, 1.1974e-09, 
     & 1.3612e-09, 1.5829e-09, 1.8655e-09, 2.1465e-09, 2.4779e-09, 
     & 2.7370e-09, 2.9915e-09, 3.3037e-09, 3.6347e-09, 3.9587e-09, 
     & 4.4701e-09, 5.0122e-09, 5.8044e-09, 6.1916e-09, 6.9613e-09, 
     & 7.7863e-09, 8.2820e-09, 9.4359e-09, 9.7387e-09, 1.0656e-08, 
     & 1.0746e-08, 1.1210e-08, 1.1905e-08, 1.2194e-08, 1.3145e-08, 
     & 1.3738e-08, 1.3634e-08, 1.3011e-08, 1.2511e-08, 1.1805e-08, 
     & 1.2159e-08, 1.2390e-08, 1.3625e-08, 1.5678e-08, 1.7886e-08, 
     & 1.9933e-08, 1.9865e-08, 1.9000e-08, 1.7812e-08, 1.5521e-08, 
     & 1.2593e-08, 9.5635e-09, 7.2987e-09, 5.2489e-09, 3.5673e-09, 
     & 2.4206e-09, 1.6977e-09, 1.2456e-09, 9.3744e-10, 7.8379e-10, 
     & 6.9960e-10, 6.6451e-10, 6.8521e-10, 7.4234e-10, 8.6658e-10, 
     & 9.4972e-10, 1.0791e-09, 1.2359e-09, 1.3363e-09, 1.5025e-09, 
     & 1.5368e-09, 1.6152e-09, 1.6184e-09, 1.6557e-09, 1.7035e-09/
      data f(1101:1200)/
     & 1.6916e-09, 1.7237e-09, 1.7175e-09, 1.6475e-09, 1.5335e-09, 
     & 1.4272e-09, 1.3282e-09, 1.3459e-09, 1.4028e-09, 1.5192e-09, 
     & 1.7068e-09, 1.9085e-09, 2.1318e-09, 2.1020e-09, 1.9942e-09, 
     & 1.8654e-09, 1.6391e-09, 1.3552e-09, 1.0186e-09, 7.8540e-10, 
     & 5.7022e-10, 3.9247e-10, 2.5441e-10, 1.6699e-10, 1.1132e-10, 
     & 6.8989e-11, 4.5255e-11, 3.1106e-11, 2.3161e-11, 1.7618e-11, 
     & 1.4380e-11, 1.1601e-11, 9.7148e-12, 8.4519e-12, 6.5392e-12, 
     & 5.4113e-12, 4.7624e-12, 4.0617e-12, 3.6173e-12, 2.8608e-12, 
     & 2.2724e-12, 1.7436e-12, 1.3424e-12, 1.0358e-12, 7.3064e-13, 
     & 5.4500e-13, 4.0551e-13, 2.8642e-13, 2.1831e-13, 1.6860e-13, 
     & 1.2086e-13, 1.0150e-13, 9.3550e-14, 8.4105e-14, 7.3051e-14, 
     & 6.9796e-14, 7.9949e-14, 1.0742e-13, 1.5639e-13, 2.1308e-13, 
     & 3.1226e-13, 4.6853e-13, 6.6917e-13, 1.0088e-12, 1.4824e-12, 
     & 2.2763e-12, 3.3917e-12, 4.4585e-12, 6.3187e-12, 8.4189e-12, 
     & 1.1302e-11, 1.3431e-11, 1.5679e-11, 1.9044e-11, 2.2463e-11, 
     & 2.3605e-11, 2.3619e-11, 2.3505e-11, 2.3805e-11, 2.2549e-11, 
     & 1.9304e-11, 1.8382e-11, 1.7795e-11, 1.8439e-11, 1.9146e-11, 
     & 2.1966e-11, 2.6109e-11, 3.1883e-11, 3.7872e-11, 4.3966e-11, 
     & 4.8789e-11, 5.3264e-11, 5.9705e-11, 6.3744e-11, 7.0163e-11, 
     & 7.9114e-11, 8.8287e-11, 9.9726e-11, 1.1498e-10, 1.3700e-10/
      data f(1201:1300)/
     & 1.6145e-10, 1.9913e-10, 2.2778e-10, 2.6216e-10, 2.9770e-10, 
     & 3.3405e-10, 3.7821e-10, 3.9552e-10, 4.1322e-10, 4.0293e-10, 
     & 4.0259e-10, 3.8853e-10, 3.7842e-10, 3.8551e-10, 4.4618e-10, 
     & 5.0527e-10, 5.0695e-10, 5.1216e-10, 5.1930e-10, 5.5794e-10, 
     & 5.3320e-10, 5.2008e-10, 5.6888e-10, 6.1883e-10, 6.9006e-10, 
     & 6.9505e-10, 6.6768e-10, 6.3290e-10, 5.6753e-10, 5.0327e-10, 
     & 3.9830e-10, 3.1147e-10, 2.4416e-10, 1.8860e-10, 1.3908e-10, 
     & 9.9156e-11, 7.3779e-11, 5.6048e-11, 4.2457e-11, 3.4505e-11, 
     & 2.9881e-11, 2.7865e-11, 2.8471e-11, 3.1065e-11, 3.4204e-11, 
     & 3.9140e-11, 4.3606e-11, 4.9075e-11, 5.3069e-11, 5.5236e-11, 
     & 5.5309e-11, 5.3832e-11, 5.3183e-11, 5.1783e-11, 5.2042e-11, 
     & 5.4422e-11, 5.5656e-11, 5.4409e-11, 5.2659e-11, 5.1696e-11, 
     & 5.1726e-11, 4.9003e-11, 4.9050e-11, 5.1700e-11, 5.6818e-11, 
     & 6.3129e-11, 6.6542e-11, 6.4367e-11, 5.9908e-11, 5.4470e-11, 
     & 4.7903e-11, 3.9669e-11, 2.9651e-11, 2.2286e-11, 1.6742e-11, 
     & 1.1827e-11, 7.7739e-12, 4.8805e-12, 3.1747e-12, 2.0057e-12, 
     & 1.2550e-12, 8.7434e-13, 6.2755e-13, 4.9752e-13, 4.0047e-13, 
     & 3.5602e-13, 3.0930e-13, 2.4903e-13, 1.9316e-13, 1.4995e-13, 
     & 1.2059e-13, 8.7242e-14, 6.4511e-14, 5.3300e-14, 4.3741e-14, 
     & 3.4916e-14, 2.6560e-14, 1.6923e-14, 1.1816e-14, 6.7071e-15/
      data f(1301:1400)/
     & 3.6474e-15, 2.0686e-15, 1.1925e-15, 6.8948e-16, 3.9661e-16, 
     & 2.2576e-16, 1.2669e-16, 6.9908e-17, 3.7896e-17, 2.0280e-17, 
     & 1.1016e-17, 6.7816e-18, 6.0958e-18, 8.9913e-18, 1.7201e-17, 
     & 3.4964e-17, 7.0722e-17, 1.4020e-16, 2.7167e-16, 5.1478e-16, 
     & 9.5500e-16, 1.7376e-15, 3.1074e-15, 5.4789e-15, 9.5640e-15, 
     & 1.6635e-14, 2.9145e-14, 5.2179e-14, 8.8554e-14, 1.4764e-13, 
     & 2.3331e-13, 3.5996e-13, 5.2132e-13, 6.3519e-13, 7.3174e-13, 
     & 8.3752e-13, 9.8916e-13, 1.1515e-12, 1.4034e-12, 1.6594e-12, 
     & 2.1021e-12, 2.7416e-12, 3.4135e-12, 4.5517e-12, 5.5832e-12, 
     & 7.2303e-12, 9.9484e-12, 1.2724e-11, 1.6478e-11, 2.0588e-11, 
     & 2.5543e-11, 3.3625e-11, 4.1788e-11, 5.0081e-11, 6.0144e-11, 
     & 6.9599e-11, 8.4408e-11, 9.7143e-11, 1.0805e-10, 1.1713e-10, 
     & 1.2711e-10, 1.3727e-10, 1.4539e-10, 1.6049e-10, 1.7680e-10, 
     & 2.0557e-10, 2.4967e-10, 3.0096e-10, 3.5816e-10, 4.0851e-10, 
     & 4.6111e-10, 5.2197e-10, 5.5043e-10, 6.0324e-10, 6.4983e-10, 
     & 6.7498e-10, 7.0545e-10, 7.0680e-10, 7.5218e-10, 7.5723e-10, 
     & 7.7840e-10, 8.0081e-10, 8.0223e-10, 7.7271e-10, 7.1676e-10, 
     & 6.7819e-10, 6.4753e-10, 6.5844e-10, 7.0163e-10, 7.7503e-10, 
     & 8.8152e-10, 9.9022e-10, 1.0229e-09, 9.9296e-10, 8.9911e-10, 
     & 7.7813e-10, 6.3785e-10, 4.7491e-10, 3.5280e-10, 2.4349e-10/
      data f(1401:1500)/
     & 1.6502e-10, 1.1622e-10, 8.6715e-11, 6.7360e-11, 5.3910e-11, 
     & 4.5554e-11, 4.1300e-11, 3.9728e-11, 3.9000e-11, 3.9803e-11, 
     & 4.1514e-11, 4.3374e-11, 4.6831e-11, 4.8921e-11, 5.1995e-11, 
     & 5.7242e-11, 6.2759e-11, 7.0801e-11, 7.4555e-11, 7.9754e-11, 
     & 8.7616e-11, 9.1171e-11, 1.0349e-10, 1.1047e-10, 1.2024e-10, 
     & 1.2990e-10, 1.3725e-10, 1.5005e-10, 1.5268e-10, 1.5535e-10, 
     & 1.5623e-10, 1.5009e-10, 1.4034e-10, 1.3002e-10, 1.2225e-10, 
     & 1.1989e-10, 1.2411e-10, 1.3612e-10, 1.5225e-10, 1.7202e-10, 
     & 1.9471e-10, 1.9931e-10, 1.9079e-10, 1.7478e-10, 1.5259e-10, 
     & 1.2625e-10, 9.3332e-11, 6.8796e-11, 4.6466e-11, 2.9723e-11, 
     & 1.8508e-11, 1.2106e-11, 8.0142e-12, 5.4066e-12, 3.9329e-12, 
     & 3.1665e-12, 2.7420e-12, 2.3996e-12, 2.3804e-12, 2.3242e-12, 
     & 2.4476e-12, 2.5331e-12, 2.3595e-12, 2.2575e-12, 2.1298e-12, 
     & 2.0088e-12, 1.8263e-12, 1.6114e-12, 1.4422e-12, 1.2946e-12, 
     & 1.0837e-12, 9.1282e-13, 7.2359e-13, 5.3307e-13, 3.8837e-13, 
     & 2.6678e-13, 1.6769e-13, 1.0826e-13, 7.2364e-14, 4.5201e-14, 
     & 3.0808e-14, 2.2377e-14, 1.7040e-14, 9.2181e-15, 5.2934e-15, 
     & 3.5774e-15, 3.1431e-15, 3.7647e-15, 5.6428e-15, 9.5139e-15, 
     & 1.7322e-14, 2.8829e-14, 4.7708e-14, 6.9789e-14, 9.7267e-14, 
     & 1.4662e-13, 1.9429e-13, 2.5998e-13, 3.6636e-13, 4.7960e-13/
      data f(1501:1600)/
     & 6.5129e-13, 7.7638e-13, 9.3774e-13, 1.1467e-12, 1.3547e-12, 
     & 1.5686e-12, 1.6893e-12, 1.9069e-12, 2.1352e-12, 2.3071e-12, 
     & 2.4759e-12, 2.8247e-12, 3.4365e-12, 4.3181e-12, 5.6107e-12, 
     & 7.0017e-12, 8.6408e-12, 1.0974e-11, 1.3742e-11, 1.6337e-11, 
     & 2.0157e-11, 2.3441e-11, 2.6733e-11, 3.0247e-11, 3.3737e-11, 
     & 3.8618e-11, 4.1343e-11, 4.3870e-11, 4.4685e-11, 4.4881e-11, 
     & 4.5526e-11, 4.3628e-11, 4.4268e-11, 4.6865e-11, 5.3426e-11, 
     & 5.4020e-11, 5.3218e-11, 5.4587e-11, 5.6360e-11, 5.7740e-11, 
     & 5.6426e-11, 6.0399e-11, 6.6981e-11, 7.4319e-11, 7.7977e-11, 
     & 7.5539e-11, 7.1610e-11, 6.4606e-11, 5.5498e-11, 4.3944e-11, 
     & 3.3769e-11, 2.5771e-11, 1.9162e-11, 1.3698e-11, 1.0173e-11, 
     & 7.8925e-12, 6.1938e-12, 4.7962e-12, 4.0811e-12, 3.3912e-12, 
     & 2.8625e-12, 2.4504e-12, 2.2188e-12, 2.2139e-12, 2.2499e-12, 
     & 2.2766e-12, 2.3985e-12, 2.5459e-12, 2.9295e-12, 3.4196e-12, 
     & 3.6155e-12, 4.0733e-12, 4.4610e-12, 4.9372e-12, 5.4372e-12, 
     & 5.7304e-12, 6.1640e-12, 6.1278e-12, 6.2940e-12, 6.4947e-12, 
     & 6.8174e-12, 7.5190e-12, 8.2608e-12, 8.4971e-12, 8.3484e-12, 
     & 8.1888e-12, 7.8552e-12, 7.8468e-12, 7.5943e-12, 7.9096e-12, 
     & 8.6869e-12, 9.1303e-12, 9.2547e-12, 8.9322e-12, 8.2177e-12, 
     & 7.3408e-12, 5.7956e-12, 4.4470e-12, 3.5881e-12, 2.6748e-12/
      data f(1601:1700)/
     & 1.7074e-12, 9.6700e-13, 5.2645e-13, 2.9943e-13, 1.7316e-13, 
     & 1.0039e-13, 5.7859e-14, 3.2968e-14, 1.8499e-14, 1.0192e-14, 
     & 5.5015e-15, 2.9040e-15, 1.4968e-15, 7.5244e-16, 3.6852e-16, 
     & 1.7568e-16, 8.1464e-17, 3.6717e-17, 1.6076e-17, 6.8341e-18, 
     & 2.8195e-18, 1.1286e-18, 0.0000e+00, 0.0000e+00, 0.0000e+00, 
     & 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 
     & 0.0000e+00, 1.4070e-18, 3.0405e-18, 6.4059e-18, 1.3169e-17, 
     & 2.6443e-17, 5.1917e-17, 9.9785e-17, 1.8802e-16, 3.4788e-16, 
     & 6.3328e-16, 1.1370e-15, 2.0198e-15, 3.5665e-15, 6.3053e-15, 
     & 1.1309e-14, 2.1206e-14, 3.2858e-14, 5.5165e-14, 8.6231e-14, 
     & 1.2776e-13, 1.7780e-13, 2.5266e-13, 3.6254e-13, 5.1398e-13, 
     & 6.8289e-13, 8.7481e-13, 1.1914e-12, 1.6086e-12, 2.0469e-12, 
     & 2.5761e-12, 3.4964e-12, 4.4980e-12, 5.5356e-12, 6.7963e-12, 
     & 8.5720e-12, 1.0700e-11, 1.2983e-11, 1.6270e-11, 1.9609e-11, 
     & 2.2668e-11, 2.5963e-11, 3.0918e-11, 3.4930e-11, 3.9330e-11, 
     & 4.4208e-11, 4.6431e-11, 5.1141e-11, 5.4108e-11, 5.8077e-11, 
     & 6.5050e-11, 7.2126e-11, 8.1064e-11, 8.1973e-11, 8.1694e-11, 
     & 8.3081e-11, 8.0240e-11, 7.9225e-11, 7.6256e-11, 7.8468e-11, 
     & 8.0041e-11, 8.1585e-11, 8.3485e-11, 8.3774e-11, 8.5870e-11, 
     & 8.6104e-11, 8.8516e-11, 9.0814e-11, 9.2522e-11, 8.8913e-11/
      data f(1701:1800)/
     & 7.8381e-11, 6.8568e-11, 5.6797e-11, 4.4163e-11, 3.2369e-11, 
     & 2.3259e-11, 1.6835e-11, 1.1733e-11, 8.5273e-12, 6.3805e-12, 
     & 4.8983e-12, 3.8831e-12, 3.2610e-12, 2.8577e-12, 2.5210e-12, 
     & 2.2913e-12, 2.0341e-12, 1.8167e-12, 1.6395e-12, 1.4890e-12, 
     & 1.3516e-12, 1.2542e-12, 1.2910e-12, 1.3471e-12, 1.4689e-12, 
     & 1.5889e-12, 1.6989e-12, 1.8843e-12, 2.0902e-12, 2.3874e-12, 
     & 2.7294e-12, 3.3353e-12, 4.0186e-12, 4.5868e-12, 5.2212e-12, 
     & 5.8856e-12, 6.5991e-12, 7.2505e-12, 7.6637e-12, 8.5113e-12, 
     & 9.4832e-12, 9.9678e-12, 1.0723e-11, 1.0749e-11, 1.1380e-11, 
     & 1.1774e-11, 1.1743e-11, 1.2493e-11, 1.2559e-11, 1.2332e-11, 
     & 1.1782e-11, 1.1086e-11, 1.0945e-11, 1.1178e-11, 1.2083e-11, 
     & 1.3037e-11, 1.4730e-11, 1.6450e-11, 1.7403e-11, 1.7004e-11, 
     & 1.5117e-11, 1.3339e-11, 1.0844e-11, 8.0915e-12, 5.6615e-12, 
     & 3.7196e-12, 2.5194e-12, 1.6569e-12, 1.1201e-12, 8.2335e-13, 
     & 6.0270e-13, 4.8205e-13, 4.1313e-13, 3.6243e-13, 3.2575e-13, 
     & 2.7730e-13, 2.5292e-13, 2.3062e-13, 2.1126e-13, 2.1556e-13, 
     & 2.1213e-13, 2.2103e-13, 2.1927e-13, 2.0794e-13, 1.9533e-13, 
     & 1.6592e-13, 1.4521e-13, 1.1393e-13, 8.3772e-14, 6.2077e-14, 
     & 4.3337e-14, 2.7165e-14, 1.6821e-14, 9.5407e-15, 5.3093e-15, 
     & 3.0320e-15, 1.7429e-15, 9.9828e-16, 5.6622e-16, 3.1672e-16/
      data f(1801:1900)/
     & 1.7419e-16, 9.3985e-17, 4.9656e-17, 2.5652e-17, 1.2942e-17, 
     & 6.3695e-18, 3.0554e-18, 1.4273e-18, 0.0000e+00, 0.0000e+00, 
     & 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 
     & 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 
     & 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 
     & 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 
     & 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 
     & 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 
     & 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 
     & 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 
     & 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 
     & 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 
     & 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 
     & 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 
     & 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 
     & 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 
     & 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 
     & 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 
     & 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 
     & 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00/
      data f(1901:2000)/
     & 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 
     & 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 
     & 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 
     & 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 
     & 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 
     & 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 
     & 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 
     & 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 
     & 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 
     & 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 
     & 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 
     & 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 
     & 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 
     & 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 
     & 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 
     & 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 
     & 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 
     & 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 
     & 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 
     & 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00, 0.0000e+00/
      data f(2001:2003)/
     & 0.0000e+00, 0.0000e+00, 0.0000e+00/
cccc
      call sint(v1,v,dv,npts,f,fh2o)
      return
      end
c=======================================================================
      subroutine sint(v1,v,dv,npt,conti,conto)
c
c     interpolation for continuum 
c
      use params, only: kr
      implicit none
      real(kr) ::  conti(*), v1, v, dv, conto
      integer :: i, npt, imod

      conto=0.
      i=(v-v1)/dv+1.00001
      if(i.ge.npt)go to 10
      conto=conti(i)
      imod=mod(int(v),10)
      if(imod.gt.0) conto=(conti(i)+conti(i+1))/2.
10    continue
      return
      end
c=======================================================================
      subroutine c4dta(c4l,v)

c  n2 continuum absorption coefficient (2080 < v < 2740)

      use params, only: kr
      implicit none
      integer :: iv, l
      real(kr) :: c4l, v, c4(133)

      data c4(1:100)/
     &  2.93e-04, 3.86e-04, 5.09e-04, 6.56e-04, 8.85e-04, 1.06e-03,
     &  1.31e-03, 1.73e-03, 2.27e-03, 2.73e-03, 3.36e-03, 3.95e-03,
     &  5.46e-03, 7.19e-03, 9.00e-03, 1.13e-02, 1.36e-02, 1.66e-02,
     &  1.96e-02, 2.16e-02, 2.36e-02, 2.63e-02, 2.90e-02, 3.15e-02,
     &  3.40e-02, 3.66e-02, 3.92e-02, 4.26e-02, 4.60e-02, 4.95e-02,
     &  5.30e-02, 5.65e-02, 6.00e-02, 6.30e-02, 6.60e-02, 6.89e-02,
     &  7.18e-02, 7.39e-02, 7.60e-02, 7.84e-02, 8.08e-02, 8.39e-02,
     &  8.70e-02, 9.13e-02, 9.56e-02, 1.08e-01, 1.20e-01, 1.36e-01,
     &  1.52e-01, 1.60e-01, 1.69e-01, 1.60e-01, 1.51e-01, 1.37e-01,
     &  1.23e-01, 1.19e-01, 1.16e-01, 1.14e-01, 1.12e-01, 1.12e-01,
     &  1.11e-01, 1.11e-01, 1.12e-01, 1.14e-01, 1.13e-01, 1.12e-01,
     &  1.09e-01, 1.07e-01, 1.02e-01, 9.90e-02, 9.50e-02, 9.00e-02,
     &  8.65e-02, 8.20e-02, 7.65e-02, 7.05e-02, 6.50e-02, 6.10e-02,
     &  5.50e-02, 4.95e-02, 4.50e-02, 4.00e-02, 3.75e-02, 3.50e-02,
     &  3.10e-02, 2.65e-02, 2.50e-02, 2.20e-02, 1.95e-02, 1.75e-02,
     &  1.60e-02, 1.40e-02, 1.20e-02, 1.05e-02, 9.50e-03, 9.00e-03,
     &  8.00e-03, 7.00e-03, 6.50e-03, 6.00e-03/
      data c4(101:133)/
     &  5.50e-03, 4.75e-03, 4.00e-03, 3.75e-03, 3.50e-03, 3.00e-03,
     &  2.50e-03, 2.25e-03, 2.00e-03, 1.85e-03, 1.70e-03, 1.60e-03,
     &  1.50e-03, 1.50e-03, 1.54e-03, 1.50e-03, 1.47e-03, 1.34e-03,
     &  1.25e-03, 1.06e-03, 9.06e-04, 7.53e-04, 6.41e-04, 5.09e-04,
     &  4.04e-04, 3.36e-04, 2.86e-04, 2.32e-04, 1.94e-04, 1.57e-04,
     &  1.31e-04, 1.02e-04, 8.07e-05/

cccc
      c4l=0.
      if(v.lt.2080.) return
      if(v.gt.2740.) return
      iv=v
      l=(iv-2080)/5+1
      c4l=c4(l)
      return
      end
c=======================================================================
      subroutine hno3(v,habs)
c
c     hno3  statistical band parameters
c
      use params, only: kr
      implicit none
      integer :: i
      real(kr) ::  v, habs, h1(15), h2(16), h3(13)

c     array h1 contains hno3 abs, coef(cm-1atm-1) from  850 to 920 cm-1
      data h1/2.197,3.911,6.154,8.150,9.217,9.461,11.56,11.10,11.17,12.4
     10,10.49,7.509,6.136,4.899,2.866/
c     array h2 contains hno3 abs, coef(cm-1atm-1) from 1275 to 1350 cm-1
      data h2/2.828,4.611,6.755,8.759,10.51,13.74,18.00,21.51,23.09,21.6
     18,21.32,16.82,16.42,17.87,14.86,8.716/
c     array h3 contains hno3 abs, coef(cm-1atm-1) from 1675 to 1735 cm-1
      data h3/5.003,8.803,14.12,19.83,23.31,23.58,23.22,21.09,26.99,25.8
     14,24.79,17.68,9.420/
cccc
      habs=0.
      if (v.ge.850.0.and.v.le.920.0) go to 5
      if (v.ge.1275.0.and.v.le.1350.0) go to 10
      if (v.ge.1675.0.and.v.le.1735.0) go to 15
      return
    5 i=(v-845.)/5.
      habs=h1(i)
      return
   10 i=(v-1270.)/5.
      habs=h2(i)
      return
   15 i=(v-1670.)/5.
      habs=h3(i)
      return
      end
c=======================================================================
      subroutine hertda(herz,v)
c
c     herzberg o2 absorption
c     hall,1987 private communication, based on:
c
c     ref. johnston et.al, jgr,89,11661-11665,1984
c         nicolet, 1987 (recent studies in atomic & molecular processes,
c                        plemun publishing corp, ny 1987)
c     and yoshino, et.al., 1988 (preprint of "improved absorption
c         cross sections of oxygen in the wavelength region 205-240nm
c         of the herzberg continuum")
c
      use params, only: kr
      implicit none
      real(kr) :: herz, v, corr, rlosch, yratio
cccc

      herz=0.0
      if(v.le.36000.00) return
c
c     extrapolate smoothly through the herzberg band region
c     note: herzberg bands are not correctly included
c
      corr=0.
      if(v.le.40000.)corr=((40000.-v)/4000.)*7.917e-27
c
c     conversion to atm-cm /km
c
      rlosch = 2.6868 e24 * 1.0e-5
c
c     hall's new herzberg  (least sqrs fit, ln(p))
c
c     yratio=2048.7/wl(i)  ****in angstoms****
c           =.20487/wn(i)     in microns
c           =wcm(i)/48811.0   in cm-1
c
      yratio=v/48811.0
      herz=6.884e-24*(yratio)*exp(-69.738*(log(yratio))**2)-corr
      herz=herz*rlosch
      return
      end
c=======================================================================
      subroutine o2cont(v,sigma,alpha,beta)
c
c     this routine is driven by frequency, returning only the
c     o2 coefficients, independent of temperature.
c
c  *******************************************************************
c  *  these comments apply to the colume arrays for:                 *
c  *       pbar*ubar(o2)                                             *
c  *       pbar*ubar(o2)*dt                                          *
c  *   and pbar*ubar(o2)*dt*dt    where:  dt=tbar-220.               *
c  *  that have been compiled in other parts of the lowtran code     *
c  *                                                                 *
c  *  lowtran7 compatible:                                           *
c  *  o2 continuum routine for 1395-1760cm-1                         *
c  *  modified by g.p. anderson, april '88                           *
c  *                                                                 *
c  *  the exponential temperature employed in the fascod2 algorithm  *
c  *  (see below) is not readily suitable for lowtran.  therefore    *
c  *  the exponentials have been linearly expanded, keeping only the *
c  *  linear and quadratic terms:                                    *
c  *                                                                 *
c  *  exp(a*dt)=1.+ a*dt + (a*dt)**2/2. + ....                       *
c  *                                                                 *
c  *     exp(b*dt*dt)=1.+ b*dt*dt + (b*dt*dt)**2/2. + ....           *
c  *                                                                 *
c  *  the product of the two terms is:                               *
c  *                                                                 *
c  *     (1. + a*dt + (a*a/2. + b)*dt*dt )                           *
c  *                                                                 *
c  *  this expansion only works well for small values of x in exp(x) *
c  *                                                                 *
c  *  since dt = t-220., the approximation is very good until        *
c  *  t.gt.260. or dt.gt.40.   at t=280, the maximum errors are still*
c  *  less than 10% but at t=300, those errors are as large as 20%   *
c  *******************************************************************
c
c     the following comments are excerpted directly from fascod2
c
c      this routine contains the rogers and walshaw
c      equivalent coefficients derived from the theoretical
c      values supplied by roland drayson. these values use
c      the same data as timofeyev and agree with timofeyev's results.
c      the data are in the form of strengths(o2so) and two
c      coefficients (o2a & o2b),  which are used to correct for
c      temperature. the dependency on pressure squared
c      is contained in the p*wo2 part of the constant.
c      note that since the coefficients are for air, the
c      the strengths are divided by the o2 mixing ratio for
c      dry air of 0.20946 (this is assumed constant).
c      original formulation of the coefficients was by larry gordley.
c      this version written by earl thompson, july 1984.
c
c

      use params, only: kr
      implicit none

      integer, parameter :: np=74

      real(kr) :: a, b, c, sigma, alpha, beta, v,
     &     v1=1395.0, v2=1760.0,  dv=5.0,
     &     o2s0(np), o2a(np), o2b(np)

      integer :: i

      data o2s0/
     &  0.000e+00,  1.100e-09,  2.200e-09,  4.400e-09,  8.810e-09, 
     &  1.760e-08,  3.530e-08,  7.050e-08,  1.410e-07,  1.580e-07, 
     &  1.740e-07,  1.900e-07,  2.070e-07,  2.530e-07,  3.070e-07, 
     &  3.570e-07,  4.010e-07,  4.450e-07,  5.080e-07,  5.700e-07, 
     &  5.990e-07,  6.270e-07,  6.500e-07,  6.720e-07,  7.630e-07, 
     &  8.730e-07,  1.010e-06,  1.090e-06,  1.210e-06,  1.330e-06, 
     &  1.390e-06,  1.450e-06,  1.480e-06,  1.400e-06,  1.340e-06, 
     &  1.260e-06,  1.180e-06,  1.140e-06,  1.090e-06,  1.050e-06, 
     &  1.050e-06,  1.050e-06,  1.040e-06,  1.030e-06,  9.920e-07, 
     &  9.450e-07,  8.760e-07,  8.060e-07,  7.660e-07,  7.260e-07, 
     &  6.400e-07,  5.550e-07,  4.690e-07,  4.160e-07,  3.640e-07, 
     &  3.110e-07,  2.660e-07,  2.220e-07,  1.770e-07,  1.700e-07, 
     &  1.620e-07,  1.550e-07,  1.430e-07,  1.300e-07,  1.180e-07, 
     &  9.050e-08,  6.290e-08,  3.160e-08,  1.570e-08,  7.860e-09, 
     &  3.930e-09,  1.960e-09,  9.820e-10,  0.000e+00/

      data o2a/
     &  0.000e+00,  1.470e-04,  1.470e-04,  1.470e-04,  1.470e-04, 
     &  1.470e-04,  1.470e-04,  1.470e-04,  1.470e-04,  1.220e-03, 
     &  2.040e-03,  2.170e-03,  2.260e-03,  1.260e-03,  3.620e-04, 
     & -1.980e-03, -5.450e-03, -7.860e-03, -6.240e-03, -4.750e-03, 
     & -5.060e-03, -5.330e-03, -5.860e-03, -6.350e-03, -6.440e-03, 
     & -6.790e-03, -7.410e-03, -7.690e-03, -7.800e-03, -7.880e-03, 
     & -8.440e-03, -8.940e-03, -8.990e-03, -9.220e-03, -8.920e-03, 
     & -8.570e-03, -8.390e-03, -8.540e-03, -8.710e-03, -8.890e-03, 
     & -8.560e-03, -8.230e-03, -7.960e-03, -7.680e-03, -7.150e-03, 
     & -6.380e-03, -5.700e-03, -4.910e-03, -4.680e-03, -4.430e-03, 
     & -3.330e-03, -1.840e-03,  3.130e-04, -1.640e-05, -4.170e-04, 
     & -9.160e-04, -2.060e-03, -3.430e-03, -5.150e-03, -3.650e-03, 
     & -1.720e-03,  9.260e-04,  1.680e-03,  2.620e-03,  3.800e-03, 
     &  5.510e-03,  8.890e-03,  8.890e-03,  8.890e-03,  8.890e-03, 
     &  8.890e-03,  8.890e-03,  8.890e-03,  0.000e+00/

      data o2b/
     &  0.000e+00,  3.060e-05, -3.060e-05, -3.060e-05, -3.060e-05, 
     & -3.060e-05, -3.060e-05, -3.060e-05, -3.060e-05, -2.180e-05, 
     & -1.590e-05, -3.460e-06,  6.420e-06,  3.600e-06, -1.400e-06, 
     &  1.570e-05,  4.710e-05,  6.560e-05,  3.030e-05, -1.920e-06, 
     &  7.050e-06,  1.490e-05,  2.000e-05,  2.450e-05,  1.580e-05, 
     &  8.410e-06,  2.010e-06,  5.550e-06,  1.080e-05,  1.500e-05, 
     &  1.930e-05,  2.300e-05,  2.430e-05,  2.260e-05,  1.840e-05, 
     &  1.570e-05,  1.690e-05,  1.970e-05,  2.260e-05,  2.580e-05, 
     &  2.350e-05,  2.120e-05,  1.850e-05,  1.560e-05,  1.250e-05, 
     &  8.720e-06,  7.600e-06,  5.770e-06,  3.340e-08, -6.520e-06, 
     & -9.770e-06, -1.570e-05, -2.730e-05, -1.800e-05, -6.410e-06, 
     &  8.170e-06,  3.260e-05,  6.260e-05,  1.010e-04,  7.550e-05, 
     &  4.300e-05, -1.130e-06, -5.780e-06, -1.200e-05, -2.080e-05, 
     & -2.350e-05, -3.640e-05,  3.640e-05, -3.640e-05, -3.640e-05, 
     & -3.640e-05, -3.640e-05, -3.640e-05,  0.000e+00/
cccc
      sigma =0
      alpha =0
      beta  =0
      if(v .lt. 1395) return
      if(v .gt. 1760) return
c
c
      i=(v-v1)/dv+1.00001
      if(i.lt.1.or.i.gt.np) then
        c=0.
        a=0.
        b=0.
      else
        c=o2s0(i)
        a=o2a(i)
        b=o2b(i)
      endif
c
c
c
c     old 'fascod2' temperature dependence using block data arrays
c
c     c(j)=o2s0(i)* exp(o2a(i)*td+o2b(i)*td*td) /(0.20946*vj)
c
c     new coefficient definitions for lowtran formulation
c
      alpha= a
      beta=a**2/2.+b
      sigma=c/0.20946
c
c     new 'lowtran7' temperature dependence
c
c     this would be the coding for the lowtran7 formulation, but
c       because the t-dependence is included in the amounts, only
c       the coefficients (sigma, alpha & beta) are being returned
c
c     c(j)=sigma*(1.+alpha*td+beta*td*td)
c

      end
c=======================================================================
      subroutine o3hht(v,c0,c1,c2)

c     o3 hartley huggins cross sections for 273k
c               units of (cm**2/mol)*1.e-20
c
c     now includes molina & molina at 273k with the temperature
c     dependence determined from the 195k harvard measurements,
c     employing the bass algorithm (c0*(1+c1*t+c2*t^2); this is
c     only for the wavelength range from .34 to .35 microns;
c     otherwise, the bass data alone have been employed between
c     .34 and .245 microns.
c
c     new t-dependent x-sections between .345 and .36 microns
c     have now been added, based on work by cacciani, disarra
c     and fiocco, university of rome, 1987.  quadratic temp
c     has been derived, as above.
c
c     molina & molina have again been used between .245 and .185
c     microns (no temperature dependence)
c
c     agreement amongst the four data sets is reasonable (<10%)
c     and often excellent (0-3%)
c
c     s(488:) is from Bass junk 1985


      use params, only: kr
      implicit none

      integer, parameter :: npts=2687

      real(kr) :: v1=27370., v2=40800., dv=5.,
     &     s0(npts), s1(npts), s2(npts),
     &     c0, c1, c2, v

      integer :: i

      data s0(1:100)/
     &  1.00000e-03, 1.15000e-03, 1.25000e-03, 1.40000e-03,
     &  1.50000e-03, 1.59304e-03, 1.62396e-03, 1.76216e-03,
     &  1.90036e-03, 2.03856e-03, 2.16538e-03, 2.02324e-03,
     &  1.88110e-03, 1.73896e-03, 1.59682e-03, 1.45468e-03,
     &  1.31253e-03, 1.17039e-03, 1.02825e-03, 8.86108e-04,
     &  7.43963e-04, 6.01821e-04, 4.59679e-04, 5.14820e-04,
     &  5.73044e-04, 6.31269e-04, 6.89493e-04, 7.47718e-04,
     &  8.05942e-04, 8.64167e-04, 9.22392e-04, 9.80617e-04,
     &  1.03884e-03, 1.09707e-03, 1.15528e-03, 1.21351e-03,
     &  1.27173e-03, 1.32996e-03, 1.38818e-03, 1.44641e-03,
     &  1.50463e-03, 1.56286e-03, 1.62108e-03, 1.67931e-03,
     &  1.73753e-03, 1.79575e-03, 1.85398e-03, 1.91220e-03,
     &  1.97043e-03, 2.02865e-03, 2.08688e-03, 2.14510e-03,
     &  2.20333e-03, 2.26155e-03, 2.31978e-03, 2.37800e-03,
     &  2.43623e-03, 2.49444e-03, 2.55267e-03, 2.61089e-03,
     &  2.66912e-03, 2.72734e-03, 2.78557e-03, 2.84379e-03,
     &  2.90202e-03, 2.96024e-03, 3.01847e-03, 3.07669e-03,
     &  3.13491e-03, 3.19313e-03, 3.25136e-03, 3.30958e-03,
     &  3.36781e-03, 3.31660e-03, 3.21583e-03, 3.11505e-03,
     &  3.22165e-03, 3.46058e-03, 3.69953e-03, 3.93846e-03,
     &  4.17739e-03, 4.41633e-03, 4.42256e-03, 4.13791e-03,
     &  4.17894e-03, 4.25583e-03, 4.33273e-03, 4.40963e-03,
     &  4.49259e-03, 4.44532e-03, 4.17540e-03, 3.84814e-03,
     &  3.41823e-03, 3.11003e-03, 2.86548e-03, 2.73912e-03,
     &  2.70800e-03, 2.70882e-03, 2.70866e-03, 2.70816e-03/
      data s0(101:200)/
     &  2.71228e-03, 2.78044e-03, 2.86135e-03, 3.00163e-03,
     &  3.15222e-03, 3.33394e-03, 3.48231e-03, 3.64966e-03,
     &  3.83242e-03, 3.97733e-03, 4.10299e-03, 4.26332e-03,
     &  4.41165e-03, 4.54040e-03, 4.65544e-03, 4.91897e-03,
     &  5.23429e-03, 5.45390e-03, 5.74420e-03, 5.96314e-03,
     &  6.07198e-03, 6.07338e-03, 5.99162e-03, 5.95079e-03,
     &  6.04655e-03, 6.18239e-03, 6.56998e-03, 6.93885e-03,
     &  7.38561e-03, 7.73029e-03, 7.90493e-03, 7.72072e-03,
     &  7.40226e-03, 6.53860e-03, 5.30328e-03, 4.23000e-03,
     &  3.45735e-03, 3.21167e-03, 3.16694e-03, 3.30966e-03,
     &  3.47431e-03, 3.68089e-03, 3.92006e-03, 4.05246e-03,
     &  4.16408e-03, 4.08710e-03, 3.98224e-03, 4.07316e-03,
     &  4.19498e-03, 4.44990e-03, 4.77881e-03, 5.08270e-03,
     &  5.37384e-03, 5.70240e-03, 5.91906e-03, 5.96745e-03,
     &  5.92363e-03, 5.80363e-03, 5.60812e-03, 5.37450e-03,
     &  5.16202e-03, 4.98389e-03, 4.95294e-03, 5.04930e-03,
     &  5.17576e-03, 5.26042e-03, 5.22957e-03, 5.32404e-03,
     &  5.39630e-03, 5.53353e-03, 5.68057e-03, 5.78679e-03,
     &  5.83795e-03, 5.93810e-03, 6.09330e-03, 6.40001e-03,
     &  6.69056e-03, 7.04863e-03, 7.41339e-03, 7.87421e-03,
     &  8.35570e-03, 8.97672e-03, 9.58486e-03, 1.01972e-02,
     &  1.08463e-02, 1.14105e-02, 1.18935e-02, 1.22404e-02,
     &  1.25053e-02, 1.28759e-02, 1.32169e-02, 1.37796e-02,
     &  1.46488e-02, 1.57324e-02, 1.68897e-02, 1.78560e-02,
     &  1.87101e-02, 1.92197e-02, 1.94106e-02, 1.90711e-02/
      data s0(201:300)/
     &  1.86585e-02, 1.82149e-02, 1.82219e-02, 1.85639e-02,
     &  1.91924e-02, 2.01342e-02, 2.12312e-02, 2.26362e-02,
     &  2.39610e-02, 2.55156e-02, 2.71338e-02, 2.87904e-02,
     &  3.04268e-02, 3.17055e-02, 3.28248e-02, 3.36026e-02,
     &  3.36867e-02, 3.26393e-02, 2.99356e-02, 2.56607e-02,
     &  2.11545e-02, 1.79508e-02, 1.59757e-02, 1.49569e-02,
     &  1.46214e-02, 1.46214e-02, 1.48217e-02, 1.51379e-02,
     &  1.53816e-02, 1.58087e-02, 1.62186e-02, 1.66627e-02,
     &  1.70961e-02, 1.76101e-02, 1.81759e-02, 1.86154e-02,
     &  1.88889e-02, 1.89577e-02, 1.89316e-02, 1.88826e-02,
     &  1.90915e-02, 1.95550e-02, 2.02707e-02, 2.11620e-02,
     &  2.21844e-02, 2.30920e-02, 2.37270e-02, 2.37422e-02,
     &  2.33578e-02, 2.20358e-02, 1.96239e-02, 1.73329e-02,
     &  1.57013e-02, 1.50566e-02, 1.49248e-02, 1.52044e-02,
     &  1.57658e-02, 1.63436e-02, 1.68986e-02, 1.74180e-02,
     &  1.78192e-02, 1.80677e-02, 1.79927e-02, 1.77900e-02,
     &  1.75599e-02, 1.74982e-02, 1.76674e-02, 1.81633e-02,
     &  1.87826e-02, 1.96898e-02, 2.06898e-02, 2.17167e-02,
     &  2.28231e-02, 2.40702e-02, 2.55084e-02, 2.69701e-02,
     &  2.86915e-02, 3.05796e-02, 3.22328e-02, 3.42637e-02,
     &  3.61708e-02, 3.79118e-02, 3.94418e-02, 4.07333e-02,
     &  4.17158e-02, 4.17081e-02, 4.01127e-02, 3.65411e-02,
     &  3.25123e-02, 2.98737e-02, 2.83616e-02, 2.79907e-02,
     &  2.80571e-02, 2.84778e-02, 2.91698e-02, 2.99500e-02,
     &  3.07468e-02, 3.13903e-02, 3.19811e-02, 3.24616e-02/
      data s0(301:400)/
     &  3.26503e-02, 3.26829e-02, 3.27688e-02, 3.36446e-02,
     &  3.55133e-02, 3.88447e-02, 4.28854e-02, 4.55381e-02,
     &  4.77161e-02, 4.93567e-02, 4.95127e-02, 5.00492e-02,
     &  5.06233e-02, 5.12739e-02, 5.20327e-02, 5.29001e-02,
     &  5.38677e-02, 5.49272e-02, 5.60703e-02, 5.72886e-02,
     &  5.85739e-02, 5.99178e-02, 6.13170e-02, 6.28474e-02,
     &  6.46499e-02, 6.68672e-02, 6.96421e-02, 7.31174e-02,
     &  7.74361e-02, 8.27413e-02, 8.91756e-02, 9.67018e-02,
     &  1.04844e-01, 1.13063e-01, 1.20818e-01, 1.27567e-01,
     &  1.32771e-01, 1.35888e-01, 1.36377e-01, 1.33780e-01,
     &  1.28385e-01, 1.20887e-01, 1.11978e-01, 1.02354e-01,
     &  9.27108e-02, 8.37418e-02, 7.61423e-02, 7.06032e-02,
     &  6.74255e-02, 6.62092e-02, 6.64813e-02, 6.77689e-02,
     &  6.95995e-02, 7.15004e-02, 7.29991e-02, 7.36229e-02,
     &  7.29641e-02, 7.11015e-02, 6.83345e-02, 6.49638e-02,
     &  6.12897e-02, 5.76125e-02, 5.42326e-02, 5.14504e-02,
     &  4.95645e-02, 4.87078e-02, 4.87234e-02, 4.94254e-02,
     &  5.06280e-02, 5.21454e-02, 5.37919e-02, 5.53818e-02,
     &  5.67293e-02, 5.76709e-02, 5.82319e-02, 5.85334e-02,
     &  5.86968e-02, 5.88439e-02, 5.90963e-02, 5.95756e-02,
     &  6.04035e-02, 6.17016e-02, 6.35548e-02, 6.59664e-02,
     &  6.89282e-02, 7.24326e-02, 7.64718e-02, 8.10380e-02,
     &  8.61236e-02, 9.17211e-02, 9.78192e-02, 1.04353e-01,
     &  1.11218e-01, 1.18308e-01, 1.25519e-01, 1.32745e-01,
     &  1.39881e-01, 1.46821e-01, 1.53461e-01, 1.59687e-01/
      data s0(401:500)/
     &  1.65365e-01, 1.70353e-01, 1.74507e-01, 1.77686e-01,
     &  1.79748e-01, 1.80549e-01, 1.79948e-01, 1.81094e-01,
     &  1.57760e-01, 1.37336e-01, 1.19475e-01, 1.17191e-01,
     &  1.14331e-01, 1.15984e-01, 1.10412e-01, 1.12660e-01,
     &  1.16014e-01, 1.15060e-01, 1.12041e-01, 1.11611e-01,
     &  1.00378e-01, 9.54850e-02, 9.87528e-02, 9.46153e-02,
     &  9.53093e-02, 9.72653e-02, 9.66468e-02, 9.39750e-02,
     &  1.03552e-01, 1.01361e-01, 1.04315e-01, 1.12842e-01,
     &  1.02800e-01, 1.09576e-01, 1.05577e-01, 1.17334e-01,
     &  1.25763e-01, 1.27597e-01, 1.34267e-01, 1.44799e-01,
     &  1.57366e-01, 1.67369e-01, 1.81778e-01, 1.89207e-01,
     &  2.01376e-01, 2.10310e-01, 2.21721e-01, 2.43162e-01,
     &  2.55542e-01, 2.75312e-01, 2.88576e-01, 3.02505e-01,
     &  3.15141e-01, 3.28908e-01, 3.49000e-01, 3.56620e-01,
     &  3.59852e-01, 3.57517e-01, 3.12924e-01, 2.63610e-01,
     &  2.50854e-01, 2.25642e-01, 2.15954e-01, 2.12099e-01,
     &  2.13039e-01, 2.12286e-01, 2.17214e-01, 2.28784e-01,
     &  2.28276e-01, 2.34677e-01, 2.30730e-01, 2.16107e-01,
     &  1.99471e-01, 1.85629e-01, 1.72730e-01, 1.56229e-01,
     &  1.38156e-01, 1.37641e-01, 1.33169e-01, 1.32759e-01,
     &  1.30102e-01, 1.35396e-01, 1.37976e-01, 1.41571e-01,
     &  1.46448e-01, 1.44508e-01, 1.47612e-01, 1.47424e-01,
     &  1.48173e-01, 1.52936e-01, 1.58908e-01, 1.58808e-01,
     &  1.59860e-01, 1.73936e-01, 1.84109e-01, 1.95143e-01,
     &  2.08267e-01, 2.19256e-01, 2.31653e-01, 2.46400e-01/
      data s0(501:600)/
     &  2.60437e-01, 2.70792e-01, 2.79749e-01, 2.91068e-01,
     &  2.98080e-01, 3.10421e-01, 3.24540e-01, 3.39003e-01,
     &  3.58322e-01, 3.81520e-01, 4.02798e-01, 4.35972e-01,
     &  4.56220e-01, 4.79037e-01, 5.02597e-01, 5.24648e-01,
     &  5.33964e-01, 5.39211e-01, 5.43613e-01, 5.28793e-01,
     &  4.94103e-01, 4.34481e-01, 3.76792e-01, 3.37161e-01,
     &  3.15750e-01, 3.11042e-01, 3.08745e-01, 3.09195e-01,
     &  3.05859e-01, 3.01443e-01, 2.88111e-01, 2.81303e-01,
     &  2.75329e-01, 2.60812e-01, 2.59337e-01, 2.45576e-01,
     &  2.40470e-01, 2.39705e-01, 2.45389e-01, 2.49801e-01,
     &  2.53235e-01, 2.54387e-01, 2.64311e-01, 2.74146e-01,
     &  2.89737e-01, 2.96673e-01, 3.07337e-01, 3.24380e-01,
     &  3.42266e-01, 3.59522e-01, 3.78005e-01, 3.97178e-01,
     &  4.23351e-01, 4.45925e-01, 4.63029e-01, 4.94843e-01,
     &  5.19418e-01, 5.49928e-01, 5.69115e-01, 6.02396e-01,
     &  6.43471e-01, 6.76401e-01, 7.14024e-01, 7.42425e-01,
     &  7.60916e-01, 7.83319e-01, 7.98299e-01, 7.76672e-01,
     &  7.22769e-01, 6.45967e-01, 5.80850e-01, 5.76514e-01,
     &  5.79380e-01, 5.90359e-01, 6.21721e-01, 6.37540e-01,
     &  6.52572e-01, 6.63442e-01, 6.69026e-01, 6.69038e-01,
     &  6.53319e-01, 6.21950e-01, 5.47619e-01, 4.58994e-01,
     &  4.14888e-01, 3.97736e-01, 3.88775e-01, 3.87424e-01,
     &  3.93567e-01, 4.03442e-01, 4.05217e-01, 4.12848e-01,
     &  4.12246e-01, 4.16620e-01, 4.13195e-01, 4.08467e-01,
     &  4.13104e-01, 4.24498e-01, 4.32002e-01, 4.46361e-01/
      data s0(601:700)/
     &  4.61131e-01, 4.77228e-01, 4.96519e-01, 5.16764e-01,
     &  5.38966e-01, 5.54187e-01, 5.73748e-01, 6.07260e-01,
     &  6.34358e-01, 6.60286e-01, 6.95533e-01, 7.37090e-01,
     &  7.83894e-01, 8.19557e-01, 8.49244e-01, 8.91832e-01,
     &  9.44885e-01, 9.86271e-01, 1.02262e+00, 1.07242e+00,
     &  1.12162e+00, 1.18287e+00, 1.22402e+00, 1.24978e+00,
     &  1.24392e+00, 1.19668e+00, 1.11562e+00, 1.03983e+00,
     &  9.31884e-01, 8.35307e-01, 7.92620e-01, 7.81980e-01,
     &  7.89623e-01, 8.05987e-01, 8.27344e-01, 8.57514e-01,
     &  8.66302e-01, 8.72092e-01, 8.66840e-01, 8.40536e-01,
     &  7.87360e-01, 7.35743e-01, 6.92039e-01, 6.64032e-01,
     &  6.48360e-01, 6.46288e-01, 6.49505e-01, 6.69937e-01,
     &  6.81006e-01, 7.00969e-01, 7.19834e-01, 7.26964e-01,
     &  7.50591e-01, 7.73600e-01, 8.00673e-01, 8.20347e-01,
     &  8.37855e-01, 8.66780e-01, 9.04297e-01, 9.46300e-01,
     &  9.69134e-01, 9.97928e-01, 1.06388e+00, 1.11032e+00,
     &  1.15221e+00, 1.21324e+00, 1.24462e+00, 1.31978e+00,
     &  1.35617e+00, 1.38792e+00, 1.39196e+00, 1.35161e+00,
     &  1.29381e+00, 1.30295e+00, 1.32965e+00, 1.37024e+00,
     &  1.44064e+00, 1.50484e+00, 1.57200e+00, 1.62097e+00,
     &  1.67874e+00, 1.72676e+00, 1.73383e+00, 1.66091e+00,
     &  1.54936e+00, 1.35454e+00, 1.20070e+00, 1.14609e+00,
     &  1.13642e+00, 1.13784e+00, 1.14609e+00, 1.14531e+00,
     &  1.16024e+00, 1.16891e+00, 1.16111e+00, 1.14192e+00,
     &  1.09903e+00, 1.05745e+00, 1.02341e+00, 1.00121e+00/
      data s0(701:800)/
     &  1.00036e+00, 1.00576e+00, 1.02405e+00, 1.04379e+00,
     &  1.07623e+00, 1.11347e+00, 1.17305e+00, 1.20016e+00,
     &  1.22697e+00, 1.27479e+00, 1.32572e+00, 1.38690e+00,
     &  1.43768e+00, 1.48379e+00, 1.55317e+00, 1.64020e+00,
     &  1.71268e+00, 1.77183e+00, 1.85824e+00, 1.95131e+00,
     &  2.04609e+00, 2.13151e+00, 2.17777e+00, 2.22832e+00,
     &  2.26886e+00, 2.19775e+00, 2.05087e+00, 1.96103e+00,
     &  1.95554e+00, 1.98037e+00, 2.05440e+00, 2.11629e+00,
     &  2.17893e+00, 2.24384e+00, 2.30464e+00, 2.32525e+00,
     &  2.29945e+00, 2.21712e+00, 2.03430e+00, 1.82139e+00,
     &  1.70354e+00, 1.64631e+00, 1.62164e+00, 1.61356e+00,
     &  1.63900e+00, 1.66313e+00, 1.67409e+00, 1.69143e+00,
     &  1.70181e+00, 1.69165e+00, 1.67699e+00, 1.67879e+00,
     &  1.67312e+00, 1.68133e+00, 1.70002e+00, 1.72500e+00,
     &  1.76308e+00, 1.80634e+00, 1.87548e+00, 1.94924e+00,
     &  1.99812e+00, 2.05333e+00, 2.14035e+00, 2.21847e+00,
     &  2.27412e+00, 2.29752e+00, 2.30750e+00, 2.36165e+00,
     &  2.44394e+00, 2.52782e+00, 2.61343e+00, 2.71640e+00,
     &  2.81613e+00, 2.93679e+00, 3.01577e+00, 3.15995e+00,
     &  3.15931e+00, 2.96658e+00, 2.73295e+00, 2.67480e+00,
     &  2.66652e+00, 2.69393e+00, 2.75102e+00, 2.86503e+00,
     &  2.99163e+00, 2.99576e+00, 3.02603e+00, 2.98415e+00,
     &  2.79309e+00, 2.65337e+00, 2.50962e+00, 2.43207e+00,
     &  2.34812e+00, 2.34872e+00, 2.35186e+00, 2.39477e+00,
     &  2.42629e+00, 2.48068e+00, 2.55087e+00, 2.55952e+00/
      data s0(801:900)/
     &  2.56497e+00, 2.64323e+00, 2.67961e+00, 2.66263e+00,
     &  2.70243e+00, 2.74911e+00, 2.81786e+00, 2.88684e+00,
     &  2.97790e+00, 3.04305e+00, 3.13053e+00, 3.23857e+00,
     &  3.35582e+00, 3.40654e+00, 3.38117e+00, 3.36296e+00,
     &  3.39480e+00, 3.49066e+00, 3.60832e+00, 3.71817e+00,
     &  3.83924e+00, 3.96355e+00, 4.03656e+00, 4.00518e+00,
     &  3.90389e+00, 3.74790e+00, 3.61385e+00, 3.57066e+00,
     &  3.59438e+00, 3.66182e+00, 3.71176e+00, 3.75255e+00,
     &  3.79101e+00, 3.85278e+00, 3.85027e+00, 3.81112e+00,
     &  3.72553e+00, 3.61017e+00, 3.54384e+00, 3.52406e+00,
     &  3.54097e+00, 3.59375e+00, 3.66312e+00, 3.72632e+00,
     &  3.76825e+00, 3.86798e+00, 3.92916e+00, 3.95610e+00,
     &  4.00120e+00, 4.05865e+00, 4.11981e+00, 4.14634e+00,
     &  4.19109e+00, 4.20317e+00, 4.25754e+00, 4.35131e+00,
     &  4.48573e+00, 4.58716e+00, 4.67462e+00, 4.78228e+00,
     &  4.91196e+00, 5.01871e+00, 5.10663e+00, 5.17780e+00,
     &  5.21393e+00, 5.18144e+00, 5.04379e+00, 4.86504e+00,
     &  4.78569e+00, 4.72717e+00, 4.69132e+00, 4.65797e+00,
     &  4.60305e+00, 4.59798e+00, 4.65300e+00, 4.69707e+00,
     &  4.74790e+00, 4.82581e+00, 4.80953e+00, 4.80517e+00,
     &  4.82685e+00, 4.82321e+00, 4.84806e+00, 4.88591e+00,
     &  4.91759e+00, 4.98074e+00, 5.07071e+00, 5.18733e+00,
     &  5.30567e+00, 5.38670e+00, 5.43942e+00, 5.51797e+00,
     &  5.62652e+00, 5.71228e+00, 5.82347e+00, 5.91434e+00,
     &  6.00171e+00, 6.06977e+00, 6.13040e+00, 6.21990e+00/
      data s0(901:1000)/
     &  6.29980e+00, 6.37206e+00, 6.48233e+00, 6.53068e+00,
     &  6.53275e+00, 6.56858e+00, 6.54577e+00, 6.50472e+00,
     &  6.41504e+00, 6.33853e+00, 6.31184e+00, 6.21253e+00,
     &  6.22034e+00, 6.26918e+00, 6.28982e+00, 6.29461e+00,
     &  6.35418e+00, 6.40956e+00, 6.38020e+00, 6.39784e+00,
     &  6.45383e+00, 6.50134e+00, 6.56808e+00, 6.58850e+00,
     &  6.58882e+00, 6.65097e+00, 6.75259e+00, 6.83256e+00,
     &  6.92593e+00, 6.98083e+00, 7.03632e+00, 7.11147e+00,
     &  7.15622e+00, 7.21106e+00, 7.27319e+00, 7.33382e+00,
     &  7.38601e+00, 7.48971e+00, 7.61459e+00, 7.70134e+00,
     &  7.76194e+00, 7.85534e+00, 7.99519e+00, 8.12227e+00,
     &  8.25461e+00, 8.34670e+00, 8.42733e+00, 8.51806e+00,
     &  8.57638e+00, 8.56481e+00, 8.55461e+00, 8.55593e+00,
     &  8.58756e+00, 8.50070e+00, 8.54400e+00, 8.57575e+00,
     &  8.62083e+00, 8.60684e+00, 8.67824e+00, 8.72069e+00,
     &  8.79127e+00, 8.85479e+00, 8.86770e+00, 8.90574e+00,
     &  8.91531e+00, 8.94800e+00, 9.00167e+00, 9.14051e+00,
     &  9.25421e+00, 9.39694e+00, 9.50896e+00, 9.53190e+00,
     &  9.55977e+00, 9.53482e+00, 9.49662e+00, 9.53359e+00,
     &  9.54007e+00, 9.49809e+00, 9.49373e+00, 9.53282e+00,
     &  9.63757e+00, 9.67855e+00, 9.67633e+00, 9.67045e+00,
     &  9.79481e+00, 9.93420e+00, 1.00234e+01, 1.01372e+01,
     &  1.02577e+01, 1.05056e+01, 1.07873e+01, 1.09967e+01,
     &  1.10873e+01, 1.11624e+01, 1.13006e+01, 1.14875e+01,
     &  1.16106e+01, 1.16744e+01, 1.17582e+01, 1.17709e+01/
      data s0(1001:1100)/
     &  1.18537e+01, 1.19623e+01, 1.19763e+01, 1.19879e+01,
     &  1.20384e+01, 1.20763e+01, 1.20826e+01, 1.20449e+01,
     &  1.19747e+01, 1.20227e+01, 1.21805e+01, 1.23134e+01,
     &  1.24042e+01, 1.25614e+01, 1.26828e+01, 1.26645e+01,
     &  1.26963e+01, 1.28226e+01, 1.28720e+01, 1.28981e+01,
     &  1.29462e+01, 1.29363e+01, 1.29199e+01, 1.29797e+01,
     &  1.28860e+01, 1.29126e+01, 1.30205e+01, 1.31327e+01,
     &  1.31722e+01, 1.31901e+01, 1.33189e+01, 1.34833e+01,
     &  1.36228e+01, 1.37474e+01, 1.38548e+01, 1.39450e+01,
     &  1.40926e+01, 1.43099e+01, 1.44836e+01, 1.46257e+01,
     &  1.47755e+01, 1.49163e+01, 1.51038e+01, 1.53308e+01,
     &  1.54194e+01, 1.54852e+01, 1.55968e+01, 1.57025e+01,
     &  1.58667e+01, 1.60365e+01, 1.61427e+01, 1.62967e+01,
     &  1.64735e+01, 1.66123e+01, 1.67268e+01, 1.67673e+01,
     &  1.67825e+01, 1.68898e+01, 1.68178e+01, 1.68216e+01,
     &  1.68574e+01, 1.68799e+01, 1.70317e+01, 1.70767e+01,
     &  1.71508e+01, 1.72965e+01, 1.73421e+01, 1.73937e+01,
     &  1.74420e+01, 1.74535e+01, 1.75110e+01, 1.75497e+01,
     &  1.75149e+01, 1.75955e+01, 1.78260e+01, 1.78271e+01,
     &  1.79750e+01, 1.80600e+01, 1.81597e+01, 1.83454e+01,
     &  1.85243e+01, 1.87382e+01, 1.88904e+01, 1.90395e+01,
     &  1.92759e+01, 1.95398e+01, 1.97712e+01, 1.98487e+01,
     &  1.99522e+01, 2.02363e+01, 2.03271e+01, 2.07090e+01,
     &  2.09195e+01, 2.10974e+01, 2.11702e+01, 2.12964e+01,
     &  2.14339e+01, 2.15764e+01, 2.17351e+01, 2.18486e+01/
      data s0(1101:1200)/
     &  2.19700e+01, 2.21663e+01, 2.24244e+01, 2.24813e+01,
     &  2.25248e+01, 2.26357e+01, 2.26457e+01, 2.27249e+01,
     &  2.27172e+01, 2.27123e+01, 2.26859e+01, 2.27216e+01,
     &  2.29306e+01, 2.30711e+01, 2.31374e+01, 2.31815e+01,
     &  2.33423e+01, 2.33810e+01, 2.36430e+01, 2.36807e+01,
     &  2.36676e+01, 2.38607e+01, 2.41559e+01, 2.43413e+01,
     &  2.44401e+01, 2.45968e+01, 2.47927e+01, 2.50743e+01,
     &  2.53667e+01, 2.55749e+01, 2.57357e+01, 2.58927e+01,
     &  2.61523e+01, 2.64110e+01, 2.66650e+01, 2.68829e+01,
     &  2.70635e+01, 2.72797e+01, 2.75064e+01, 2.77229e+01,
     &  2.80341e+01, 2.82003e+01, 2.83346e+01, 2.83909e+01,
     &  2.86212e+01, 2.88006e+01, 2.89577e+01, 2.90965e+01,
     &  2.91834e+01, 2.93224e+01, 2.94094e+01, 2.94848e+01,
     &  2.96584e+01, 2.96749e+01, 2.97760e+01, 2.99163e+01,
     &  3.00238e+01, 3.01290e+01, 3.02307e+01, 3.03663e+01,
     &  3.05897e+01, 3.07937e+01, 3.10403e+01, 3.11778e+01,
     &  3.13271e+01, 3.15799e+01, 3.18435e+01, 3.21614e+01,
     &  3.25097e+01, 3.27701e+01, 3.29600e+01, 3.32583e+01,
     &  3.36348e+01, 3.40282e+01, 3.41751e+01, 3.44128e+01,
     &  3.46199e+01, 3.49363e+01, 3.52087e+01, 3.54056e+01,
     &  3.55596e+01, 3.56694e+01, 3.58104e+01, 3.60276e+01,
     &  3.62818e+01, 3.63505e+01, 3.66069e+01, 3.67544e+01,
     &  3.70664e+01, 3.72525e+01, 3.73491e+01, 3.76006e+01,
     &  3.77102e+01, 3.78970e+01, 3.81254e+01, 3.82728e+01,
     &  3.81720e+01, 3.82781e+01, 3.84982e+01, 3.87202e+01/
      data s0(1201:1300)/
     &  3.89958e+01, 3.94148e+01, 3.98434e+01, 3.98952e+01,
     &  4.01573e+01, 4.06014e+01, 4.09651e+01, 4.12821e+01,
     &  4.16849e+01, 4.19899e+01, 4.22719e+01, 4.27736e+01,
     &  4.32254e+01, 4.33883e+01, 4.39831e+01, 4.39414e+01,
     &  4.42613e+01, 4.46503e+01, 4.49027e+01, 4.50384e+01,
     &  4.52929e+01, 4.57269e+01, 4.56433e+01, 4.57350e+01,
     &  4.60128e+01, 4.60487e+01, 4.61183e+01, 4.64397e+01,
     &  4.68211e+01, 4.70706e+01, 4.72821e+01, 4.74972e+01,
     &  4.78253e+01, 4.81615e+01, 4.84480e+01, 4.85703e+01,
     &  4.87397e+01, 4.90015e+01, 4.93673e+01, 4.97291e+01,
     &  4.99836e+01, 5.02975e+01, 5.05572e+01, 5.08226e+01,
     &  5.13433e+01, 5.17112e+01, 5.19703e+01, 5.23128e+01,
     &  5.27305e+01, 5.30599e+01, 5.34555e+01, 5.39625e+01,
     &  5.43627e+01, 5.45446e+01, 5.49263e+01, 5.53511e+01,
     &  5.57270e+01, 5.60904e+01, 5.63875e+01, 5.68475e+01,
     &  5.73172e+01, 5.81134e+01, 5.86399e+01, 5.90384e+01,
     &  5.91417e+01, 5.90883e+01, 5.93610e+01, 5.95794e+01,
     &  5.99600e+01, 5.98493e+01, 5.99441e+01, 6.02748e+01,
     &  6.04778e+01, 6.05233e+01, 6.07194e+01, 6.11589e+01,
     &  6.13324e+01, 6.17685e+01, 6.23166e+01, 6.31055e+01,
     &  6.38211e+01, 6.42320e+01, 6.45195e+01, 6.51125e+01,
     &  6.56765e+01, 6.59286e+01, 6.62716e+01, 6.65693e+01,
     &  6.68906e+01, 6.72246e+01, 6.75177e+01, 6.78476e+01,
     &  6.82599e+01, 6.84400e+01, 6.89072e+01, 6.95720e+01,
     &  7.01410e+01, 7.05519e+01, 7.09367e+01, 7.13975e+01/
      data s0(1301:1400)/
     &  7.22128e+01, 7.28222e+01, 7.33808e+01, 7.38828e+01,
     &  7.44496e+01, 7.49983e+01, 7.54178e+01, 7.60554e+01,
     &  7.62484e+01, 7.67892e+01, 7.71262e+01, 7.76235e+01,
     &  7.81413e+01, 7.85694e+01, 7.91248e+01, 7.94715e+01,
     &  7.96200e+01, 8.00270e+01, 8.03783e+01, 8.07100e+01,
     &  8.11929e+01, 8.17375e+01, 8.18410e+01, 8.23341e+01,
     &  8.26754e+01, 8.30893e+01, 8.34232e+01, 8.35533e+01,
     &  8.36017e+01, 8.38589e+01, 8.43366e+01, 8.47593e+01,
     &  8.51614e+01, 8.55271e+01, 8.58979e+01, 8.64892e+01,
     &  8.74367e+01, 8.82440e+01, 8.89105e+01, 8.90980e+01,
     &  8.97266e+01, 9.04886e+01, 9.12709e+01, 9.21243e+01,
     &  9.26673e+01, 9.31331e+01, 9.38190e+01, 9.44877e+01,
     &  9.50636e+01, 9.57445e+01, 9.65211e+01, 9.68623e+01,
     &  9.75356e+01, 9.81991e+01, 9.88881e+01, 9.94554e+01,
     &  9.99292e+01, 1.00357e+02, 1.00670e+02, 1.01227e+02,
     &  1.01529e+02, 1.01889e+02, 1.02033e+02, 1.02254e+02,
     &  1.02731e+02, 1.02914e+02, 1.03120e+02, 1.03674e+02,
     &  1.03768e+02, 1.04146e+02, 1.04850e+02, 1.05525e+02,
     &  1.06263e+02, 1.06653e+02, 1.07084e+02, 1.07461e+02,
     &  1.08052e+02, 1.08793e+02, 1.09395e+02, 1.09811e+02,
     &  1.10079e+02, 1.10656e+02, 1.11575e+02, 1.12544e+02,
     &  1.13453e+02, 1.14440e+02, 1.15292e+02, 1.15869e+02,
     &  1.16925e+02, 1.17854e+02, 1.18723e+02, 1.19574e+02,
     &  1.19940e+02, 1.21108e+02, 1.21807e+02, 1.22490e+02,
     &  1.23278e+02, 1.24094e+02, 1.24816e+02, 1.25469e+02/
      data s0(1401:1500)/
     &  1.26217e+02, 1.26878e+02, 1.27536e+02, 1.28168e+02,
     &  1.28682e+02, 1.29076e+02, 1.30171e+02, 1.30667e+02,
     &  1.31242e+02, 1.31665e+02, 1.31961e+02, 1.32347e+02,
     &  1.32805e+02, 1.33152e+02, 1.33869e+02, 1.34261e+02,
     &  1.34498e+02, 1.35028e+02, 1.36049e+02, 1.36577e+02,
     &  1.37491e+02, 1.38078e+02, 1.38389e+02, 1.38819e+02,
     &  1.39653e+02, 1.39770e+02, 1.40812e+02, 1.40926e+02,
     &  1.41267e+02, 1.41872e+02, 1.42233e+02, 1.43447e+02,
     &  1.44641e+02, 1.45500e+02, 1.45996e+02, 1.47040e+02,
     &  1.48767e+02, 1.48785e+02, 1.49525e+02, 1.50266e+02,
     &  1.50814e+02, 1.51443e+02, 1.52272e+02, 1.52846e+02,
     &  1.54000e+02, 1.54629e+02, 1.54907e+02, 1.55527e+02,
     &  1.56642e+02, 1.57436e+02, 1.59036e+02, 1.59336e+02,
     &  1.59661e+02, 1.60287e+02, 1.61202e+02, 1.62410e+02,
     &  1.63040e+02, 1.62872e+02, 1.63248e+02, 1.63776e+02,
     &  1.64313e+02, 1.65782e+02, 1.65692e+02, 1.66049e+02,
     &  1.66701e+02, 1.67786e+02, 1.69150e+02, 1.69996e+02,
     &  1.71634e+02, 1.71137e+02, 1.71372e+02, 1.72525e+02,
     &  1.73816e+02, 1.75219e+02, 1.76091e+02, 1.78260e+02,
     &  1.79299e+02, 1.79904e+02, 1.81718e+02, 1.83807e+02,
     &  1.85488e+02, 1.85929e+02, 1.86787e+02, 1.88282e+02,
     &  1.89546e+02, 1.91489e+02, 1.92646e+02, 1.93399e+02,
     &  1.93838e+02, 1.94406e+02, 1.95829e+02, 1.96745e+02,
     &  1.96978e+02, 1.97243e+02, 1.97636e+02, 1.98025e+02,
     &  1.98227e+02, 1.99552e+02, 2.00304e+02, 2.01031e+02/
      data s0(1501:1600)/
     &  2.01788e+02, 2.02432e+02, 2.03817e+02, 2.04866e+02,
     &  2.05561e+02, 2.06180e+02, 2.07024e+02, 2.08303e+02,
     &  2.09426e+02, 2.10575e+02, 2.11637e+02, 2.12559e+02,
     &  2.13361e+02, 2.14191e+02, 2.15264e+02, 2.16366e+02,
     &  2.17316e+02, 2.17717e+02, 2.17154e+02, 2.19172e+02,
     &  2.20346e+02, 2.20849e+02, 2.21539e+02, 2.22810e+02,
     &  2.22740e+02, 2.22824e+02, 2.23285e+02, 2.23696e+02,
     &  2.23864e+02, 2.23968e+02, 2.23544e+02, 2.24804e+02,
     &  2.25953e+02, 2.26753e+02, 2.27732e+02, 2.29505e+02,
     &  2.30108e+02, 2.31232e+02, 2.32552e+02, 2.33979e+02,
     &  2.36677e+02, 2.38481e+02, 2.41797e+02, 2.44025e+02,
     &  2.45113e+02, 2.47373e+02, 2.47258e+02, 2.48617e+02,
     &  2.49790e+02, 2.50562e+02, 2.51198e+02, 2.51289e+02,
     &  2.52509e+02, 2.54136e+02, 2.55335e+02, 2.55808e+02,
     &  2.56567e+02, 2.57977e+02, 2.58987e+02, 2.59622e+02,
     &  2.60170e+02, 2.61127e+02, 2.60655e+02, 2.62129e+02,
     &  2.64020e+02, 2.65659e+02, 2.67086e+02, 2.67615e+02,
     &  2.69800e+02, 2.71452e+02, 2.73314e+02, 2.76972e+02,
     &  2.78005e+02, 2.79815e+02, 2.81709e+02, 2.84043e+02,
     &  2.87070e+02, 2.88842e+02, 2.90555e+02, 2.92401e+02,
     &  2.94314e+02, 2.96074e+02, 2.97103e+02, 2.98037e+02,
     &  2.98113e+02, 2.97705e+02, 2.97350e+02, 2.97329e+02,
     &  2.97016e+02, 2.96752e+02, 2.96599e+02, 2.96637e+02,
     &  2.97057e+02, 2.97585e+02, 2.98179e+02, 2.98997e+02,
     &  3.00012e+02, 3.00806e+02, 3.00908e+02, 3.02369e+02/
      data s0(1601:1700)/
     &  3.04063e+02, 3.05325e+02, 3.06737e+02, 3.08066e+02,
     &  3.09694e+02, 3.11530e+02, 3.13132e+02, 3.13296e+02,
     &  3.15513e+02, 3.16887e+02, 3.17682e+02, 3.18296e+02,
     &  3.18654e+02, 3.18912e+02, 3.19236e+02, 3.19626e+02,
     &  3.20020e+02, 3.20186e+02, 3.20709e+02, 3.21628e+02,
     &  3.22625e+02, 3.23504e+02, 3.25479e+02, 3.26825e+02,
     &  3.28146e+02, 3.29404e+02, 3.30512e+02, 3.32634e+02,
     &  3.34422e+02, 3.35602e+02, 3.36833e+02, 3.39372e+02,
     &  3.43446e+02, 3.46374e+02, 3.48719e+02, 3.50881e+02,
     &  3.53160e+02, 3.54890e+02, 3.57162e+02, 3.59284e+02,
     &  3.60876e+02, 3.62295e+02, 3.63987e+02, 3.64835e+02,
     &  3.65257e+02, 3.65738e+02, 3.65904e+02, 3.65976e+02,
     &  3.66460e+02, 3.67087e+02, 3.67377e+02, 3.69079e+02,
     &  3.70694e+02, 3.70940e+02, 3.70557e+02, 3.72693e+02,
     &  3.73852e+02, 3.75679e+02, 3.77863e+02, 3.79964e+02,
     &  3.81368e+02, 3.82716e+02, 3.85556e+02, 3.89072e+02,
     &  3.91796e+02, 3.92766e+02, 3.96551e+02, 3.97833e+02,
     &  3.97285e+02, 4.01929e+02, 4.02158e+02, 4.04553e+02,
     &  4.06451e+02, 4.06236e+02, 4.08135e+02, 4.07797e+02,
     &  4.08415e+02, 4.10111e+02, 4.11781e+02, 4.12735e+02,
     &  4.11547e+02, 4.11606e+02, 4.13548e+02, 4.12557e+02,
     &  4.12923e+02, 4.12866e+02, 4.13009e+02, 4.14447e+02,
     &  4.16032e+02, 4.17032e+02, 4.19064e+02, 4.22458e+02,
     &  4.26021e+02, 4.25192e+02, 4.25684e+02, 4.27536e+02,
     &  4.29972e+02, 4.31994e+02, 4.36037e+02, 4.39132e+02/
      data s0(1701:1800)/
     &  4.40363e+02, 4.40716e+02, 4.40342e+02, 4.42063e+02,
     &  4.44408e+02, 4.45454e+02, 4.47835e+02, 4.48256e+02,
     &  4.48831e+02, 4.50257e+02, 4.51427e+02, 4.52373e+02,
     &  4.53899e+02, 4.55496e+02, 4.56311e+02, 4.57314e+02,
     &  4.59922e+02, 4.61048e+02, 4.59840e+02, 4.62144e+02,
     &  4.63152e+02, 4.64565e+02, 4.66715e+02, 4.69380e+02,
     &  4.70751e+02, 4.72012e+02, 4.73482e+02, 4.75524e+02,
     &  4.79307e+02, 4.82035e+02, 4.84423e+02, 4.86712e+02,
     &  4.88754e+02, 4.90102e+02, 4.92047e+02, 4.94150e+02,
     &  4.95375e+02, 4.95828e+02, 4.97555e+02, 4.98559e+02,
     &  4.97618e+02, 4.99265e+02, 4.99979e+02, 5.00681e+02,
     &  5.01386e+02, 5.00868e+02, 5.01935e+02, 5.03151e+02,
     &  5.04329e+02, 5.05546e+02, 5.08259e+02, 5.09222e+02,
     &  5.09818e+02, 5.11397e+02, 5.12391e+02, 5.13326e+02,
     &  5.14329e+02, 5.15443e+02, 5.16533e+02, 5.21417e+02,
     &  5.25071e+02, 5.26581e+02, 5.27762e+02, 5.29274e+02,
     &  5.31704e+02, 5.34310e+02, 5.35727e+02, 5.36838e+02,
     &  5.37082e+02, 5.36733e+02, 5.36170e+02, 5.36063e+02,
     &  5.36451e+02, 5.37870e+02, 5.40475e+02, 5.42268e+02,
     &  5.41972e+02, 5.42532e+02, 5.44764e+02, 5.46844e+02,
     &  5.47525e+02, 5.49150e+02, 5.52049e+02, 5.55423e+02,
     &  5.56259e+02, 5.57424e+02, 5.59189e+02, 5.61167e+02,
     &  5.64512e+02, 5.66753e+02, 5.68183e+02, 5.69628e+02,
     &  5.73474e+02, 5.76192e+02, 5.78058e+02, 5.79588e+02,
     &  5.81619e+02, 5.83530e+02, 5.84852e+02, 5.85326e+02/
      data s0(1801:1900)/
     &  5.88130e+02, 5.90570e+02, 5.91785e+02, 5.91371e+02,
     &  5.90931e+02, 5.90942e+02, 5.91168e+02, 5.91291e+02,
     &  5.89791e+02, 5.91146e+02, 5.90804e+02, 5.87847e+02,
     &  5.89067e+02, 5.91027e+02, 5.90951e+02, 5.89227e+02,
     &  5.93389e+02, 5.92921e+02, 5.92739e+02, 5.94544e+02,
     &  5.98941e+02, 6.02302e+02, 6.03908e+02, 6.04265e+02,
     &  6.06737e+02, 6.08560e+02, 6.11272e+02, 6.14992e+02,
     &  6.18595e+02, 6.20930e+02, 6.22107e+02, 6.22957e+02,
     &  6.26710e+02, 6.28657e+02, 6.30132e+02, 6.31543e+02,
     &  6.33043e+02, 6.36932e+02, 6.38248e+02, 6.37126e+02,
     &  6.41648e+02, 6.48274e+02, 6.52638e+02, 6.53922e+02,
     &  6.56647e+02, 6.59351e+02, 6.60525e+02, 6.60130e+02,
     &  6.61375e+02, 6.62660e+02, 6.63976e+02, 6.65181e+02,
     &  6.64820e+02, 6.64458e+02, 6.64927e+02, 6.66555e+02,
     &  6.66759e+02, 6.68218e+02, 6.70323e+02, 6.72703e+02,
     &  6.76085e+02, 6.79180e+02, 6.80850e+02, 6.80017e+02,
     &  6.79928e+02, 6.80886e+02, 6.82038e+02, 6.82271e+02,
     &  6.84057e+02, 6.85309e+02, 6.86816e+02, 6.90180e+02,
     &  6.93205e+02, 6.95870e+02, 6.98794e+02, 7.03776e+02,
     &  7.04010e+02, 7.05041e+02, 7.07254e+02, 7.07432e+02,
     &  7.10736e+02, 7.13791e+02, 7.15542e+02, 7.16468e+02,
     &  7.17412e+02, 7.17783e+02, 7.17340e+02, 7.18184e+02,
     &  7.18716e+02, 7.18809e+02, 7.18282e+02, 7.20317e+02,
     &  7.18568e+02, 7.16274e+02, 7.19119e+02, 7.20852e+02,
     &  7.21727e+02, 7.22607e+02, 7.26369e+02, 7.26412e+02/
      data s0(1901:2000)/
     &  7.27101e+02, 7.29404e+02, 7.30786e+02, 7.30910e+02,
     &  7.30656e+02, 7.30566e+02, 7.33408e+02, 7.37064e+02,
     &  7.39178e+02, 7.36713e+02, 7.37365e+02, 7.40861e+02,
     &  7.45281e+02, 7.46178e+02, 7.46991e+02, 7.48035e+02,
     &  7.49777e+02, 7.54665e+02, 7.56585e+02, 7.57408e+02,
     &  7.58131e+02, 7.58155e+02, 7.60838e+02, 7.64792e+02,
     &  7.68161e+02, 7.69263e+02, 7.73166e+02, 7.79006e+02,
     &  7.82037e+02, 7.83109e+02, 7.84674e+02, 7.87444e+02,
     &  7.89510e+02, 7.90130e+02, 7.91364e+02, 7.95225e+02,
     &  8.03599e+02, 8.06340e+02, 8.05105e+02, 8.05120e+02,
     &  8.08515e+02, 8.10907e+02, 8.11388e+02, 8.13432e+02,
     &  8.12579e+02, 8.10564e+02, 8.08719e+02, 8.07682e+02,
     &  8.05009e+02, 8.01754e+02, 8.01013e+02, 7.99926e+02,
     &  7.99067e+02, 7.98369e+02, 7.94090e+02, 7.92883e+02,
     &  7.94244e+02, 7.98220e+02, 7.98201e+02, 7.98332e+02,
     &  7.99289e+02, 8.02355e+02, 8.03621e+02, 8.05302e+02,
     &  8.08368e+02, 8.09983e+02, 8.11529e+02, 8.13068e+02,
     &  8.14717e+02, 8.16441e+02, 8.19241e+02, 8.22944e+02,
     &  8.23768e+02, 8.25030e+02, 8.26103e+02, 8.26374e+02,
     &  8.28331e+02, 8.32620e+02, 8.38618e+02, 8.43666e+02,
     &  8.45212e+02, 8.46324e+02, 8.48536e+02, 8.50192e+02,
     &  8.53083e+02, 8.56653e+02, 8.59614e+02, 8.62000e+02,
     &  8.64593e+02, 8.67678e+02, 8.70908e+02, 8.73408e+02,
     &  8.74779e+02, 8.74005e+02, 8.76718e+02, 8.80445e+02,
     &  8.84365e+02, 8.83806e+02, 8.84292e+02, 8.85539e+02/
      data s0(2001:2100)/
     &  8.87474e+02, 8.84905e+02, 8.84039e+02, 8.85105e+02,
     &  8.83733e+02, 8.82224e+02, 8.79865e+02, 8.75663e+02,
     &  8.75575e+02, 8.73144e+02, 8.68602e+02, 8.70278e+02,
     &  8.69659e+02, 8.68701e+02, 8.69250e+02, 8.71057e+02,
     &  8.72860e+02, 8.74361e+02, 8.74458e+02, 8.77576e+02,
     &  8.81613e+02, 8.84358e+02, 8.87440e+02, 8.91549e+02,
     &  8.96568e+02, 8.99836e+02, 9.02880e+02, 9.05428e+02,
     &  9.06891e+02, 9.07349e+02, 9.10151e+02, 9.15917e+02,
     &  9.16197e+02, 9.18571e+02, 9.21219e+02, 9.20292e+02,
     &  9.21949e+02, 9.24509e+02, 9.27454e+02, 9.29474e+02,
     &  9.31348e+02, 9.32818e+02, 9.32658e+02, 9.36280e+02,
     &  9.39512e+02, 9.39667e+02, 9.44078e+02, 9.47196e+02,
     &  9.48291e+02, 9.46150e+02, 9.46918e+02, 9.49093e+02,
     &  9.51372e+02, 9.53109e+02, 9.56308e+02, 9.61335e+02,
     &  9.58214e+02, 9.56188e+02, 9.55660e+02, 9.58633e+02,
     &  9.57541e+02, 9.54879e+02, 9.51663e+02, 9.52839e+02,
     &  9.52055e+02, 9.49253e+02, 9.50187e+02, 9.50323e+02,
     &  9.50937e+02, 9.54362e+02, 9.55855e+02, 9.56350e+02,
     &  9.55908e+02, 9.57963e+02, 9.61866e+02, 9.66948e+02,
     &  9.69786e+02, 9.74302e+02, 9.79061e+02, 9.82465e+02,
     &  9.86019e+02, 9.89930e+02, 9.94294e+02, 9.97011e+02,
     &  9.98207e+02, 9.98607e+02, 1.00175e+03, 1.00275e+03,
     &  1.00284e+03, 1.00294e+03, 1.00485e+03, 1.00593e+03,
     &  1.00524e+03, 1.00415e+03, 1.00335e+03, 1.00278e+03,
     &  1.00185e+03, 9.99982e+02, 9.98177e+02, 9.97959e+02/
      data s0(2101:2200)/
     &  9.99161e+02, 9.98810e+02, 9.95415e+02, 9.94342e+02,
     &  9.92998e+02, 9.91340e+02, 9.90900e+02, 9.90407e+02,
     &  9.89232e+02, 9.85447e+02, 9.86312e+02, 9.87461e+02,
     &  9.86090e+02, 9.86670e+02, 9.85534e+02, 9.81877e+02,
     &  9.84946e+02, 9.86392e+02, 9.86709e+02, 9.88086e+02,
     &  9.90269e+02, 9.92566e+02, 9.94029e+02, 9.95795e+02,
     &  9.97788e+02, 1.00005e+03, 1.00287e+03, 1.00566e+03,
     &  1.00833e+03, 1.00982e+03, 1.01348e+03, 1.01862e+03,
     &  1.02322e+03, 1.02786e+03, 1.03179e+03, 1.03339e+03,
     &  1.03833e+03, 1.04317e+03, 1.04598e+03, 1.04753e+03,
     &  1.04981e+03, 1.05321e+03, 1.05492e+03, 1.05721e+03,
     &  1.05978e+03, 1.06033e+03, 1.06107e+03, 1.06155e+03,
     &  1.06035e+03, 1.05838e+03, 1.05649e+03, 1.05553e+03,
     &  1.05498e+03, 1.05387e+03, 1.05171e+03, 1.04877e+03,
     &  1.04725e+03, 1.04748e+03, 1.04733e+03, 1.04704e+03,
     &  1.04643e+03, 1.04411e+03, 1.04435e+03, 1.04520e+03,
     &  1.04233e+03, 1.04047e+03, 1.03992e+03, 1.04192e+03,
     &  1.04171e+03, 1.04140e+03, 1.04197e+03, 1.04415e+03,
     &  1.04548e+03, 1.04533e+03, 1.04616e+03, 1.04705e+03,
     &  1.04800e+03, 1.05025e+03, 1.05219e+03, 1.05412e+03,
     &  1.05808e+03, 1.06062e+03, 1.06292e+03, 1.06780e+03,
     &  1.07219e+03, 1.07610e+03, 1.07913e+03, 1.08405e+03,
     &  1.08798e+03, 1.08835e+03, 1.09140e+03, 1.09447e+03,
     &  1.09676e+03, 1.10015e+03, 1.10272e+03, 1.10410e+03,
     &  1.10749e+03, 1.10991e+03, 1.11121e+03, 1.10981e+03/
      data s0(2201:2300)/
     &  1.10981e+03, 1.11063e+03, 1.10714e+03, 1.10500e+03,
     &  1.10357e+03, 1.10093e+03, 1.09898e+03, 1.09679e+03,
     &  1.09188e+03, 1.09088e+03, 1.09040e+03, 1.08586e+03,
     &  1.08178e+03, 1.07752e+03, 1.07243e+03, 1.07178e+03,
     &  1.07084e+03, 1.06693e+03, 1.06527e+03, 1.06405e+03,
     &  1.06285e+03, 1.06287e+03, 1.06276e+03, 1.06221e+03,
     &  1.06464e+03, 1.06579e+03, 1.06498e+03, 1.06596e+03,
     &  1.06812e+03, 1.07159e+03, 1.07361e+03, 1.07556e+03,
     &  1.07751e+03, 1.08128e+03, 1.08523e+03, 1.08927e+03,
     &  1.09193e+03, 1.09612e+03, 1.10133e+03, 1.10435e+03,
     &  1.10781e+03, 1.11168e+03, 1.11641e+03, 1.12217e+03,
     &  1.12839e+03, 1.13298e+03, 1.13575e+03, 1.13742e+03,
     &  1.13929e+03, 1.14132e+03, 1.14340e+03, 1.14518e+03,
     &  1.14742e+03, 1.14943e+03, 1.14935e+03, 1.14975e+03,
     &  1.15086e+03, 1.15420e+03, 1.15267e+03, 1.15007e+03,
     &  1.15155e+03, 1.14982e+03, 1.14663e+03, 1.14301e+03,
     &  1.13986e+03, 1.13676e+03, 1.13307e+03, 1.12898e+03,
     &  1.12516e+03, 1.12284e+03, 1.12068e+03, 1.11855e+03,
     &  1.11632e+03, 1.11464e+03, 1.11318e+03, 1.11180e+03,
     &  1.11163e+03, 1.11160e+03, 1.11035e+03, 1.11178e+03,
     &  1.11395e+03, 1.11447e+03, 1.11439e+03, 1.11440e+03,
     &  1.11582e+03, 1.11560e+03, 1.11478e+03, 1.11448e+03,
     &  1.11454e+03, 1.11494e+03, 1.11607e+03, 1.11736e+03,
     &  1.11854e+03, 1.11875e+03, 1.11989e+03, 1.12165e+03,
     &  1.12427e+03, 1.12620e+03, 1.12758e+03, 1.12774e+03/
      data s0(2301:2400)/
     &  1.12870e+03, 1.13001e+03, 1.13006e+03, 1.13078e+03,
     &  1.13172e+03, 1.12971e+03, 1.12857e+03, 1.12810e+03,
     &  1.12740e+03, 1.12659e+03, 1.12564e+03, 1.12338e+03,
     &  1.12117e+03, 1.11902e+03, 1.11878e+03, 1.11855e+03,
     &  1.11828e+03, 1.11791e+03, 1.11784e+03, 1.11815e+03,
     &  1.11957e+03, 1.12046e+03, 1.12042e+03, 1.11929e+03,
     &  1.12074e+03, 1.12708e+03, 1.12600e+03, 1.12538e+03,
     &  1.12871e+03, 1.13167e+03, 1.13388e+03, 1.13444e+03,
     &  1.13595e+03, 1.13801e+03, 1.14096e+03, 1.14230e+03,
     &  1.14304e+03, 1.14421e+03, 1.14580e+03, 1.14767e+03,
     &  1.15000e+03, 1.15126e+03, 1.15181e+03, 1.15197e+03,
     &  1.15364e+03, 1.15626e+03, 1.15538e+03, 1.15636e+03,
     &  1.15908e+03, 1.16024e+03, 1.16188e+03, 1.16411e+03,
     &  1.16310e+03, 1.16430e+03, 1.16927e+03, 1.17035e+03,
     &  1.17052e+03, 1.17013e+03, 1.16968e+03, 1.16969e+03,
     &  1.17106e+03, 1.17123e+03, 1.17006e+03, 1.16536e+03,
     &  1.16087e+03, 1.15691e+03, 1.15608e+03, 1.15388e+03,
     &  1.15077e+03, 1.14967e+03, 1.14793e+03, 1.14554e+03,
     &  1.14212e+03, 1.13908e+03, 1.13654e+03, 1.13499e+03,
     &  1.13308e+03, 1.13033e+03, 1.13051e+03, 1.13073e+03,
     &  1.12898e+03, 1.12941e+03, 1.13051e+03, 1.13086e+03,
     &  1.13189e+03, 1.13304e+03, 1.13192e+03, 1.13131e+03,
     &  1.13110e+03, 1.13499e+03, 1.13914e+03, 1.14359e+03,
     &  1.14383e+03, 1.14390e+03, 1.14435e+03, 1.14540e+03,
     &  1.14646e+03, 1.14716e+03, 1.14880e+03, 1.15062e+03/
      data s0(2401:2500)/
     &  1.15170e+03, 1.15093e+03, 1.14926e+03, 1.15133e+03,
     &  1.15167e+03, 1.15043e+03, 1.15134e+03, 1.15135e+03,
     &  1.15000e+03, 1.15087e+03, 1.15118e+03, 1.14935e+03,
     &  1.14780e+03, 1.14647e+03, 1.14560e+03, 1.14404e+03,
     &  1.14238e+03, 1.14406e+03, 1.14245e+03, 1.13781e+03,
     &  1.13664e+03, 1.13653e+03, 1.13778e+03, 1.13813e+03,
     &  1.13794e+03, 1.13681e+03, 1.13515e+03, 1.13328e+03,
     &  1.13132e+03, 1.13080e+03, 1.13130e+03, 1.13400e+03,
     &  1.13526e+03, 1.13494e+03, 1.13193e+03, 1.12898e+03,
     &  1.12654e+03, 1.12739e+03, 1.12849e+03, 1.12774e+03,
     &  1.12733e+03, 1.12733e+03, 1.12943e+03, 1.13014e+03,
     &  1.12967e+03, 1.12731e+03, 1.12671e+03, 1.12885e+03,
     &  1.13050e+03, 1.13201e+03, 1.13345e+03, 1.13488e+03,
     &  1.13605e+03, 1.13530e+03, 1.13737e+03, 1.14186e+03,
     &  1.14250e+03, 1.14305e+03, 1.14383e+03, 1.14510e+03,
     &  1.14659e+03, 1.14848e+03, 1.14949e+03, 1.14995e+03,
     &  1.14934e+03, 1.15058e+03, 1.15368e+03, 1.15435e+03,
     &  1.15422e+03, 1.15296e+03, 1.15228e+03, 1.15189e+03,
     &  1.15198e+03, 1.15081e+03, 1.14881e+03, 1.14562e+03,
     &  1.14276e+03, 1.14030e+03, 1.13637e+03, 1.13254e+03,
     &  1.12942e+03, 1.12653e+03, 1.12362e+03, 1.11987e+03,
     &  1.11712e+03, 1.11522e+03, 1.11403e+03, 1.11226e+03,
     &  1.10947e+03, 1.10956e+03, 1.10976e+03, 1.10748e+03,
     &  1.10673e+03, 1.10688e+03, 1.10675e+03, 1.10533e+03,
     &  1.10230e+03, 1.10384e+03, 1.10496e+03, 1.10274e+03/
      data s0(2501:2600)/
     &  1.10197e+03, 1.10196e+03, 1.10278e+03, 1.10257e+03,
     &  1.10147e+03, 1.10205e+03, 1.10308e+03, 1.10478e+03,
     &  1.10358e+03, 1.10197e+03, 1.10305e+03, 1.10390e+03,
     &  1.10456e+03, 1.10526e+03, 1.10588e+03, 1.10640e+03,
     &  1.10747e+03, 1.10904e+03, 1.11214e+03, 1.11350e+03,
     &  1.11359e+03, 1.11604e+03, 1.11706e+03, 1.11594e+03,
     &  1.11600e+03, 1.11616e+03, 1.11561e+03, 1.11556e+03,
     &  1.11547e+03, 1.11370e+03, 1.11289e+03, 1.11276e+03,
     &  1.11338e+03, 1.11437e+03, 1.11595e+03, 1.11309e+03,
     &  1.10958e+03, 1.10887e+03, 1.10573e+03, 1.10068e+03,
     &  1.10194e+03, 1.10165e+03, 1.09813e+03, 1.09973e+03,
     &  1.10233e+03, 1.10121e+03, 1.10097e+03, 1.10149e+03,
     &  1.10162e+03, 1.10222e+03, 1.10389e+03, 1.10315e+03,
     &  1.10158e+03, 1.10193e+03, 1.10186e+03, 1.10135e+03,
     &  1.10336e+03, 1.10500e+03, 1.10459e+03, 1.10592e+03,
     &  1.10784e+03, 1.10076e+03, 1.09615e+03, 1.09496e+03,
     &  1.09422e+03, 1.09350e+03, 1.09244e+03, 1.08955e+03,
     &  1.08535e+03, 1.08379e+03, 1.08184e+03, 1.07889e+03,
     &  1.07563e+03, 1.07238e+03, 1.07042e+03, 1.06882e+03,
     &  1.06761e+03, 1.06816e+03, 1.06772e+03, 1.06327e+03,
     &  1.06313e+03, 1.06563e+03, 1.06254e+03, 1.06072e+03,
     &  1.06095e+03, 1.06173e+03, 1.06269e+03, 1.06361e+03,
     &  1.06438e+03, 1.06501e+03, 1.06465e+03, 1.06481e+03,
     &  1.06685e+03, 1.06642e+03, 1.06447e+03, 1.06701e+03,
     &  1.06791e+03, 1.06612e+03, 1.06471e+03, 1.06403e+03/
      data s0(2601:2687)/
     &  1.06774e+03, 1.06823e+03, 1.06524e+03, 1.06479e+03,
     &  1.06453e+03, 1.06346e+03, 1.06175e+03, 1.05958e+03,
     &  1.05941e+03, 1.05936e+03, 1.05938e+03, 1.05736e+03,
     &  1.05449e+03, 1.05307e+03, 1.05180e+03, 1.05074e+03,
     &  1.04810e+03, 1.04536e+03, 1.04477e+03, 1.04389e+03,
     &  1.04272e+03, 1.04006e+03, 1.03739e+03, 1.03533e+03,
     &  1.03476e+03, 1.03516e+03, 1.03275e+03, 1.03093e+03,
     &  1.03062e+03, 1.02997e+03, 1.02919e+03, 1.02993e+03,
     &  1.02983e+03, 1.02837e+03, 1.02611e+03, 1.02386e+03,
     &  1.02426e+03, 1.02542e+03, 1.02750e+03, 1.02638e+03,
     &  1.02496e+03, 1.02608e+03, 1.02568e+03, 1.02388e+03,
     &  1.02522e+03, 1.02692e+03, 1.02834e+03, 1.02828e+03,
     &  1.02716e+03, 1.02667e+03, 1.02607e+03, 1.02503e+03,
     &  1.02723e+03, 1.03143e+03, 1.02881e+03, 1.02646e+03,
     &  1.02500e+03, 1.02569e+03, 1.02743e+03, 1.02608e+03,
     &  1.02548e+03, 1.02620e+03, 1.02733e+03, 1.02839e+03,
     &  1.02575e+03, 1.02432e+03, 1.02471e+03, 1.02392e+03,
     &  1.02267e+03, 1.02077e+03, 1.01964e+03, 1.01957e+03,
     &  1.01848e+03, 1.01704e+03, 1.01524e+03, 1.01352e+03,
     &  1.01191e+03, 1.01066e+03, 1.00952e+03, 1.00849e+03,
     &  1.00660e+03, 1.00368e+03, 9.99713e+02, 9.95921e+02,
     &  9.94845e+02, 9.93286e+02, 9.91204e+02/

      data s1(1:100)/
     &  1.30000e-03, 1.30000e-03, 1.30000e-03, 1.30000e-03,
     &  1.30000e-03, 1.30000e-03, 1.30000e-03, 1.30000e-03,
     &  1.30000e-03, 1.30000e-03, 1.30000e-03, 1.30000e-03,
     &  1.30000e-03, 1.30000e-03, 1.30000e-03, 1.30000e-03,
     &  1.30000e-03, 1.30000e-03, 1.30000e-03, 1.30000e-03,
     &  1.30000e-03, 1.30000e-03, 1.30000e-03, 1.30000e-03,
     &  1.30000e-03, 1.30000e-03, 1.30000e-03, 1.30000e-03,
     &  1.30000e-03, 1.30000e-03, 1.30000e-03, 1.30000e-03,
     &  1.30000e-03, 1.30000e-03, 1.30000e-03, 1.30000e-03,
     &  1.30000e-03, 1.30000e-03, 1.30000e-03, 1.30000e-03,
     &  1.30000e-03, 1.30000e-03, 1.30000e-03, 1.30000e-03,
     &  1.30000e-03, 1.30000e-03, 1.30000e-03, 1.30000e-03,
     &  1.30000e-03, 1.30000e-03, 1.30000e-03, 1.30000e-03,
     &  1.30000e-03, 1.30000e-03, 1.30000e-03, 1.30000e-03,
     &  1.30000e-03, 1.30000e-03, 1.30000e-03, 1.30000e-03,
     &  1.30000e-03, 1.30000e-03, 1.30000e-03, 1.30000e-03,
     &  1.30000e-03, 1.30000e-03, 1.30000e-03, 1.30000e-03,
     &  1.30000e-03, 1.30000e-03, 1.30000e-03, 1.30000e-03,
     &  1.30000e-03, 1.30000e-03, 1.30000e-03, 1.30000e-03,
     &  1.30000e-03, 1.30000e-03, 1.30000e-03, 1.30000e-03,
     &  1.30000e-03, 1.30000e-03, 1.30000e-03, 1.30000e-03,
     &  1.30000e-03, 1.30000e-03, 1.30000e-03, 1.30000e-03,
     &  1.37330e-03, 1.62821e-03, 2.01703e-03, 2.54574e-03,
     &  3.20275e-03, 3.89777e-03, 4.62165e-03, 5.26292e-03,
     &  5.86986e-03, 6.41494e-03, 6.96761e-03, 7.48539e-03/
      data s1(101:200)/
     &  7.89600e-03, 7.87305e-03, 7.81981e-03, 7.63864e-03,
     &  7.67455e-03, 7.72586e-03, 7.69784e-03, 7.57367e-03,
     &  7.27336e-03, 7.14064e-03, 7.24207e-03, 7.09851e-03,
     &  6.93654e-03, 6.89385e-03, 7.05768e-03, 6.85578e-03,
     &  6.58301e-03, 6.50848e-03, 6.52083e-03, 6.46590e-03,
     &  6.70692e-03, 6.92053e-03, 7.17734e-03, 7.05364e-03,
     &  6.63440e-03, 6.54702e-03, 6.27173e-03, 5.98150e-03,
     &  5.66579e-03, 5.51549e-03, 5.50291e-03, 5.93271e-03,
     &  6.36950e-03, 7.18562e-03, 7.51767e-03, 6.53815e-03,
     &  7.22341e-03, 8.63056e-03, 9.11740e-03, 8.80903e-03,
     &  8.59902e-03, 7.74287e-03, 7.33509e-03, 7.50180e-03,
     &  7.81686e-03, 7.85635e-03, 8.08554e-03, 7.21968e-03,
     &  7.99028e-03, 9.90724e-03, 1.29121e-02, 1.54686e-02,
     &  1.60876e-02, 1.59530e-02, 1.57040e-02, 1.59499e-02,
     &  1.63961e-02, 1.72670e-02, 1.81634e-02, 1.95519e-02,
     &  2.14181e-02, 2.28670e-02, 2.33506e-02, 2.22736e-02,
     &  2.14296e-02, 2.15271e-02, 2.30730e-02, 2.36220e-02,
     &  2.44466e-02, 2.44476e-02, 2.39223e-02, 2.41386e-02,
     &  2.53687e-02, 2.67491e-02, 2.80425e-02, 2.77558e-02,
     &  2.82626e-02, 2.86776e-02, 2.88781e-02, 2.89248e-02,
     &  2.89983e-02, 2.85534e-02, 2.87102e-02, 2.83695e-02,
     &  2.76719e-02, 2.76091e-02, 2.90733e-02, 2.80388e-02,
     &  2.73706e-02, 2.65055e-02, 2.61268e-02, 2.45892e-02,
     &  2.37213e-02, 2.22542e-02, 2.10116e-02, 2.02852e-02,
     &  1.97635e-02, 1.94079e-02, 1.90997e-02, 1.85598e-02/
      data s1(201:300)/
     &  1.79221e-02, 1.77887e-02, 1.73709e-02, 1.67263e-02,
     &  1.60932e-02, 1.50775e-02, 1.39563e-02, 1.23691e-02,
     &  1.07402e-02, 9.35859e-03, 8.43786e-03, 7.92075e-03,
     &  7.33239e-03, 6.73638e-03, 6.28740e-03, 5.85640e-03,
     &  5.85384e-03, 6.10577e-03, 7.26050e-03, 9.66384e-03,
     &  1.29629e-02, 1.69596e-02, 2.03465e-02, 2.26429e-02,
     &  2.39653e-02, 2.47970e-02, 2.51993e-02, 2.51383e-02,
     &  2.52014e-02, 2.47766e-02, 2.47171e-02, 2.47478e-02,
     &  2.43986e-02, 2.43498e-02, 2.40537e-02, 2.40574e-02,
     &  2.40446e-02, 2.40847e-02, 2.39400e-02, 2.42127e-02,
     &  2.47123e-02, 2.52914e-02, 2.52103e-02, 2.51421e-02,
     &  2.43229e-02, 2.37902e-02, 2.30865e-02, 2.28174e-02,
     &  2.28830e-02, 2.33671e-02, 2.38274e-02, 2.46699e-02,
     &  2.56739e-02, 2.61408e-02, 2.62898e-02, 2.64228e-02,
     &  2.55561e-02, 2.47095e-02, 2.39071e-02, 2.34319e-02,
     &  2.28738e-02, 2.23434e-02, 2.18888e-02, 2.13639e-02,
     &  2.11937e-02, 2.10110e-02, 2.07672e-02, 2.00697e-02,
     &  1.97605e-02, 1.91208e-02, 1.82056e-02, 1.73945e-02,
     &  1.64542e-02, 1.53969e-02, 1.41816e-02, 1.35665e-02,
     &  1.27109e-02, 1.18254e-02, 1.11489e-02, 1.03984e-02,
     &  1.00760e-02, 9.86649e-03, 9.76766e-03, 9.41662e-03,
     &  9.19082e-03, 9.44272e-03, 1.04547e-02, 1.24713e-02,
     &  1.49310e-02, 1.70272e-02, 1.86057e-02, 1.93555e-02,
     &  1.98350e-02, 2.00041e-02, 2.01233e-02, 2.01917e-02,
     &  1.98918e-02, 1.96649e-02, 1.95162e-02, 2.01044e-02/
      data s1(301:400)/
     &  2.06711e-02, 2.08881e-02, 2.04812e-02, 1.92249e-02,
     &  1.80188e-02, 1.69496e-02, 1.60488e-02, 1.52865e-02,
     &  1.46940e-02, 1.41067e-02, 1.35675e-02, 1.31094e-02,
     &  1.27542e-02, 1.30730e-02, 1.27950e-02, 1.27530e-02,
     &  1.28680e-02, 1.28850e-02, 1.25540e-02, 1.21060e-02,
     &  1.16160e-02, 1.13940e-02, 1.10920e-02, 1.06820e-02,
     &  1.05190e-02, 9.72190e-03, 9.34340e-03, 8.52600e-03,
     &  8.33330e-03, 7.85820e-03, 6.82950e-03, 6.79630e-03,
     &  6.75160e-03, 6.29300e-03, 6.16150e-03, 6.12500e-03,
     &  5.90110e-03, 5.78230e-03, 5.46880e-03, 5.09780e-03,
     &  4.45260e-03, 3.80900e-03, 3.23100e-03, 3.01280e-03,
     &  3.90630e-03, 6.79110e-03, 9.31610e-03, 1.02560e-02,
     &  1.01830e-02, 9.82890e-03, 9.56830e-03, 9.04060e-03,
     &  8.71480e-03, 8.52840e-03, 8.61490e-03, 8.72380e-03,
     &  9.36790e-03, 1.06830e-02, 1.20160e-02, 1.30970e-02,
     &  1.36100e-02, 1.35880e-02, 1.38050e-02, 1.39280e-02,
     &  1.39030e-02, 1.34460e-02, 1.32580e-02, 1.31940e-02,
     &  1.27030e-02, 1.23930e-02, 1.24870e-02, 1.23410e-02,
     &  1.23880e-02, 1.20610e-02, 1.21220e-02, 1.18500e-02,
     &  1.20320e-02, 1.18060e-02, 1.18100e-02, 1.15720e-02,
     &  1.13970e-02, 1.09800e-02, 1.10120e-02, 1.05240e-02,
     &  1.05180e-02, 1.02270e-02, 9.68370e-03, 9.64250e-03,
     &  8.99380e-03, 9.14880e-03, 8.85950e-03, 8.59760e-03,
     &  8.44470e-03, 8.07310e-03, 8.02830e-03, 7.78270e-03,
     &  7.76380e-03, 7.24380e-03, 6.82460e-03, 6.34570e-03/
      data s1(401:500)/
     &  5.66320e-03, 5.25000e-03, 4.35930e-03, 3.94310e-03,
     &  3.15800e-03, 2.22980e-03, 1.78180e-03, 1.45130e-03,
     &  1.31880e-03, 2.10340e-03, 6.45621e-03, 7.11308e-03,
     &  1.06130e-02, 1.36338e-02, 1.27746e-02, 1.42152e-02,
     &  1.41144e-02, 1.64830e-02, 1.67110e-02, 1.57368e-02,
     &  1.54644e-02, 1.45248e-02, 1.43206e-02, 1.56946e-02,
     &  1.54268e-02, 1.37500e-02, 1.50224e-02, 1.60919e-02,
     &  1.49099e-02, 1.53960e-02, 1.61871e-02, 1.46539e-02,
     &  1.38258e-02, 1.32571e-02, 1.21580e-02, 1.39596e-02,
     &  1.16029e-02, 1.47042e-02, 1.07441e-02, 1.08999e-02,
     &  1.05562e-02, 1.00589e-02, 9.60711e-03, 9.36950e-03,
     &  7.65303e-03, 6.86216e-03, 7.05344e-03, 6.90728e-03,
     &  6.78627e-03, 6.97435e-03, 5.75456e-03, 5.81685e-03,
     &  5.00915e-03, 4.90259e-03, 4.42545e-03, 4.14633e-03,
     &  3.61657e-03, 3.08178e-03, 2.91680e-03, 2.94554e-03,
     &  3.35794e-03, 5.49025e-03, 7.09867e-03, 6.82592e-03,
     &  8.84835e-03, 9.15718e-03, 9.17935e-03, 8.31848e-03,
     &  7.79481e-03, 7.75125e-03, 6.95844e-03, 7.34506e-03,
     &  7.53823e-03, 7.03272e-03, 7.57051e-03, 9.20239e-03,
     &  1.10864e-02, 1.16188e-02, 1.30029e-02, 1.44364e-02,
     &  1.29292e-02, 1.36031e-02, 1.35967e-02, 1.30412e-02,
     &  1.29874e-02, 1.14829e-02, 1.18009e-02, 1.20829e-02,
     &  1.17831e-02, 1.21489e-02, 1.27019e-02, 1.25557e-02,
     &  1.23812e-02, 1.20158e-02, 1.26749e-02, 1.17139e-02,
     &  1.14552e-02, 1.11268e-02, 9.79143e-03, 8.79741e-03/
      data s1(501:600)/
     &  8.85709e-03, 8.57653e-03, 8.93908e-03, 8.46205e-03,
     &  8.56506e-03, 8.14319e-03, 8.14415e-03, 7.74205e-03,
     &  7.80727e-03, 7.49886e-03, 7.71114e-03, 6.55963e-03,
     &  6.87550e-03, 6.39162e-03, 5.55359e-03, 5.43275e-03,
     &  4.90649e-03, 4.41165e-03, 4.21875e-03, 3.62592e-03,
     &  3.40700e-03, 2.40267e-03, 2.61479e-03, 2.75677e-03,
     &  4.10842e-03, 5.79601e-03, 7.10708e-03, 8.07826e-03,
     &  8.16166e-03, 8.72620e-03, 8.85878e-03, 8.72755e-03,
     &  8.25811e-03, 8.12100e-03, 7.78534e-03, 7.39762e-03,
     &  8.43880e-03, 8.53789e-03, 9.90072e-03, 1.01668e-02,
     &  1.00827e-02, 9.73556e-03, 9.57462e-03, 1.01289e-02,
     &  1.10670e-02, 1.03508e-02, 1.00929e-02, 9.10236e-03,
     &  9.39459e-03, 8.79601e-03, 8.67936e-03, 8.53862e-03,
     &  7.95459e-03, 8.04037e-03, 7.95361e-03, 7.87432e-03,
     &  6.99165e-03, 7.37107e-03, 6.09187e-03, 6.21030e-03,
     &  5.33277e-03, 5.04633e-03, 4.45811e-03, 4.34153e-03,
     &  3.98596e-03, 3.84225e-03, 3.41943e-03, 3.60535e-03,
     &  2.81691e-03, 2.49771e-03, 2.35046e-03, 2.50947e-03,
     &  3.75462e-03, 4.92349e-03, 5.09294e-03, 4.98312e-03,
     &  5.19325e-03, 4.41827e-03, 4.25192e-03, 4.46745e-03,
     &  4.08731e-03, 3.84776e-03, 3.67507e-03, 3.76845e-03,
     &  3.69210e-03, 4.59864e-03, 6.42677e-03, 7.83255e-03,
     &  7.89247e-03, 8.10883e-03, 8.00825e-03, 8.40322e-03,
     &  7.97108e-03, 8.24714e-03, 8.39006e-03, 8.68787e-03,
     &  8.61108e-03, 8.81552e-03, 9.36996e-03, 9.08243e-03/
      data s1(601:700)/
     &  9.69116e-03, 9.66185e-03, 9.22856e-03, 9.65086e-03,
     &  9.35398e-03, 9.06358e-03, 8.76851e-03, 8.43072e-03,
     &  7.85659e-03, 7.93936e-03, 7.49712e-03, 7.20199e-03,
     &  6.94581e-03, 6.64086e-03, 6.12627e-03, 6.13967e-03,
     &  5.67310e-03, 5.09928e-03, 4.59112e-03, 3.95257e-03,
     &  3.67652e-03, 3.28781e-03, 2.77471e-03, 2.74494e-03,
     &  2.15529e-03, 1.95283e-03, 1.75043e-03, 1.60419e-03,
     &  1.82688e-03, 2.34667e-03, 2.92502e-03, 3.88322e-03,
     &  4.39984e-03, 4.67814e-03, 4.80395e-03, 4.69130e-03,
     &  4.54564e-03, 4.46773e-03, 4.59178e-03, 4.37498e-03,
     &  4.12706e-03, 4.18299e-03, 4.57267e-03, 5.60127e-03,
     &  6.51936e-03, 7.10498e-03, 7.49870e-03, 7.89554e-03,
     &  7.97428e-03, 8.21044e-03, 8.06324e-03, 7.76648e-03,
     &  7.62238e-03, 7.77675e-03, 7.46905e-03, 7.61115e-03,
     &  7.42715e-03, 7.28461e-03, 7.51514e-03, 7.38782e-03,
     &  6.97206e-03, 6.52738e-03, 6.10147e-03, 5.87553e-03,
     &  5.49218e-03, 4.94873e-03, 4.47920e-03, 4.25005e-03,
     &  3.98094e-03, 3.92084e-03, 3.41707e-03, 3.30501e-03,
     &  3.09208e-03, 3.19686e-03, 3.55283e-03, 4.20775e-03,
     &  4.11155e-03, 3.72193e-03, 3.52000e-03, 3.13572e-03,
     &  2.87629e-03, 2.64251e-03, 2.33451e-03, 2.22426e-03,
     &  2.05800e-03, 1.75214e-03, 2.32530e-03, 2.68651e-03,
     &  3.66315e-03, 4.93904e-03, 5.32850e-03, 5.43978e-03,
     &  5.32656e-03, 5.15649e-03, 5.42096e-03, 5.37193e-03,
     &  5.23454e-03, 5.34557e-03, 5.50533e-03, 6.13216e-03/
      data s1(701:800)/
     &  6.65129e-03, 7.09357e-03, 7.46042e-03, 7.68605e-03,
     &  7.91866e-03, 7.52953e-03, 7.48272e-03, 7.17800e-03,
     &  6.80060e-03, 6.60427e-03, 6.43049e-03, 6.45975e-03,
     &  6.20534e-03, 5.93094e-03, 5.67360e-03, 5.38584e-03,
     &  5.19364e-03, 4.92599e-03, 4.60655e-03, 4.24669e-03,
     &  3.94253e-03, 3.55894e-03, 3.24256e-03, 2.92974e-03,
     &  2.62760e-03, 2.52238e-03, 2.24714e-03, 2.26350e-03,
     &  2.44380e-03, 3.03798e-03, 3.50000e-03, 3.55416e-03,
     &  3.43661e-03, 3.19814e-03, 3.02155e-03, 2.73890e-03,
     &  2.50078e-03, 2.34595e-03, 2.18282e-03, 2.19285e-03,
     &  2.49482e-03, 3.13434e-03, 4.18947e-03, 4.72069e-03,
     &  5.29712e-03, 5.39004e-03, 5.44846e-03, 5.37952e-03,
     &  5.09935e-03, 5.08741e-03, 5.05257e-03, 5.10339e-03,
     &  5.17968e-03, 5.31841e-03, 5.58106e-03, 5.65031e-03,
     &  5.65680e-03, 5.76184e-03, 5.71213e-03, 5.48515e-03,
     &  5.32168e-03, 5.18505e-03, 4.99640e-03, 4.78746e-03,
     &  4.57244e-03, 4.32728e-03, 4.14464e-03, 3.97659e-03,
     &  4.01874e-03, 4.10588e-03, 3.99644e-03, 3.84584e-03,
     &  3.64222e-03, 3.39590e-03, 3.00386e-03, 2.73790e-03,
     &  2.45095e-03, 2.29068e-03, 1.64530e-03, 1.68602e-03,
     &  2.32934e-03, 3.14851e-03, 3.65706e-03, 3.70878e-03,
     &  3.75103e-03, 3.79183e-03, 3.32032e-03, 2.42604e-03,
     &  2.48775e-03, 2.34603e-03, 2.36349e-03, 3.33744e-03,
     &  3.44617e-03, 4.27280e-03, 4.61076e-03, 5.20165e-03,
     &  5.14851e-03, 5.22909e-03, 5.08278e-03, 5.16125e-03/
      data s1(801:900)/
     &  5.01572e-03, 4.51685e-03, 4.67541e-03, 4.83421e-03,
     &  4.57546e-03, 4.55111e-03, 5.03093e-03, 4.67838e-03,
     &  4.44282e-03, 4.40774e-03, 4.48123e-03, 4.24410e-03,
     &  4.03559e-03, 3.73969e-03, 3.45458e-03, 3.18217e-03,
     &  3.16115e-03, 3.36877e-03, 3.62026e-03, 3.69898e-03,
     &  3.49845e-03, 3.13839e-03, 2.77731e-03, 2.40106e-03,
     &  2.03935e-03, 1.84377e-03, 2.07757e-03, 2.39550e-03,
     &  2.86272e-03, 3.27900e-03, 3.42304e-03, 3.50211e-03,
     &  3.29197e-03, 3.24784e-03, 3.20864e-03, 3.28063e-03,
     &  3.01328e-03, 3.00379e-03, 3.19562e-03, 3.45113e-03,
     &  3.75149e-03, 3.98520e-03, 4.19181e-03, 4.15773e-03,
     &  4.02490e-03, 3.95936e-03, 3.79001e-03, 3.77647e-03,
     &  3.48528e-03, 3.55768e-03, 3.62812e-03, 3.48650e-03,
     &  3.35434e-03, 3.20088e-03, 3.25316e-03, 3.04467e-03,
     &  3.12633e-03, 3.23602e-03, 3.07723e-03, 2.80070e-03,
     &  2.72498e-03, 2.74752e-03, 2.58943e-03, 2.32482e-03,
     &  2.20218e-03, 2.10846e-03, 2.05991e-03, 2.01844e-03,
     &  2.16224e-03, 2.48456e-03, 2.88022e-03, 2.93939e-03,
     &  3.01176e-03, 2.98886e-03, 2.96947e-03, 3.38082e-03,
     &  3.61657e-03, 3.42654e-03, 3.41274e-03, 3.22475e-03,
     &  2.97658e-03, 3.21944e-03, 3.32032e-03, 3.33273e-03,
     &  3.58854e-03, 3.67023e-03, 3.64069e-03, 3.74557e-03,
     &  3.77703e-03, 3.64042e-03, 3.39468e-03, 3.22657e-03,
     &  3.16466e-03, 3.24224e-03, 3.24801e-03, 3.19487e-03,
     &  3.40155e-03, 3.16940e-03, 2.92293e-03, 3.00998e-03/
      data s1(901:1000)/
     &  2.82851e-03, 2.60381e-03, 2.59242e-03, 2.48530e-03,
     &  2.76677e-03, 2.45506e-03, 2.21845e-03, 2.30407e-03,
     &  2.28136e-03, 2.37278e-03, 2.25313e-03, 2.47836e-03,
     &  2.77858e-03, 2.89803e-03, 2.86131e-03, 3.14118e-03,
     &  3.14119e-03, 2.88881e-03, 3.19502e-03, 2.99538e-03,
     &  2.91212e-03, 3.22739e-03, 3.05960e-03, 3.18901e-03,
     &  3.05805e-03, 3.12205e-03, 2.95636e-03, 3.24111e-03,
     &  3.29433e-03, 3.09206e-03, 3.06696e-03, 2.97735e-03,
     &  2.90897e-03, 2.88979e-03, 2.75105e-03, 2.92156e-03,
     &  3.03445e-03, 2.91664e-03, 2.85559e-03, 2.98405e-03,
     &  2.95376e-03, 2.80234e-03, 2.78349e-03, 2.73421e-03,
     &  2.70035e-03, 2.60074e-03, 2.34840e-03, 2.37626e-03,
     &  2.32927e-03, 2.20842e-03, 2.31080e-03, 2.42771e-03,
     &  2.43339e-03, 2.53280e-03, 2.37093e-03, 2.37377e-03,
     &  2.73453e-03, 2.60836e-03, 2.55568e-03, 2.44062e-03,
     &  2.71093e-03, 2.64421e-03, 2.66969e-03, 2.55560e-03,
     &  2.71800e-03, 2.79534e-03, 2.59070e-03, 2.55373e-03,
     &  2.45272e-03, 2.55571e-03, 2.54606e-03, 2.57349e-03,
     &  2.46807e-03, 2.35634e-03, 2.44470e-03, 2.47050e-03,
     &  2.57131e-03, 2.71649e-03, 2.58800e-03, 2.54524e-03,
     &  2.69505e-03, 2.89122e-03, 2.77399e-03, 2.63306e-03,
     &  2.82269e-03, 2.95684e-03, 3.07415e-03, 2.70594e-03,
     &  2.65650e-03, 2.90613e-03, 2.96666e-03, 2.94767e-03,
     &  2.81765e-03, 2.64829e-03, 2.43062e-03, 2.33816e-03,
     &  2.38210e-03, 2.45701e-03, 2.38508e-03, 2.40746e-03/
      data s1(1001:1100)/
     &  2.49779e-03, 2.28209e-03, 2.26185e-03, 2.26604e-03,
     &  2.19232e-03, 2.19160e-03, 2.32246e-03, 2.11108e-03,
     &  2.26220e-03, 2.26849e-03, 2.34787e-03, 2.49323e-03,
     &  2.46872e-03, 2.52974e-03, 2.35858e-03, 2.36865e-03,
     &  2.33533e-03, 2.21338e-03, 2.24610e-03, 2.24776e-03,
     &  2.24423e-03, 2.29276e-03, 2.18487e-03, 2.27621e-03,
     &  2.31141e-03, 2.44095e-03, 2.45198e-03, 2.56919e-03,
     &  2.56823e-03, 2.41982e-03, 2.39968e-03, 2.62447e-03,
     &  2.55339e-03, 2.51556e-03, 2.47477e-03, 2.50276e-03,
     &  2.48381e-03, 2.48484e-03, 2.48316e-03, 2.38541e-03,
     &  2.41183e-03, 2.55888e-03, 2.42810e-03, 2.43356e-03,
     &  2.25996e-03, 2.34736e-03, 2.10305e-03, 2.13870e-03,
     &  2.17472e-03, 2.05354e-03, 2.11572e-03, 2.19557e-03,
     &  2.09545e-03, 2.07831e-03, 1.94425e-03, 1.89333e-03,
     &  1.98025e-03, 1.98328e-03, 2.01702e-03, 1.98333e-03,
     &  2.01150e-03, 2.02484e-03, 2.10759e-03, 2.11892e-03,
     &  2.10175e-03, 2.05314e-03, 2.13338e-03, 2.25764e-03,
     &  2.19055e-03, 2.10818e-03, 2.05100e-03, 2.05685e-03,
     &  2.10843e-03, 2.10228e-03, 2.10646e-03, 2.22640e-03,
     &  2.31253e-03, 2.31230e-03, 2.21885e-03, 2.19568e-03,
     &  2.23583e-03, 2.34754e-03, 2.28622e-03, 2.21876e-03,
     &  2.26679e-03, 2.30828e-03, 2.24944e-03, 2.13851e-03,
     &  2.02938e-03, 1.96770e-03, 2.05953e-03, 2.13814e-03,
     &  2.03158e-03, 2.24655e-03, 1.95119e-03, 2.12979e-03,
     &  2.08581e-03, 2.02434e-03, 1.98926e-03, 1.98792e-03/
      data s1(1101:1200)/
     &  1.97237e-03, 1.93397e-03, 1.92360e-03, 1.90805e-03,
     &  1.89300e-03, 1.83548e-03, 1.87215e-03, 1.85589e-03,
     &  1.85718e-03, 1.79361e-03, 1.77984e-03, 1.91506e-03,
     &  2.04256e-03, 2.04095e-03, 1.94031e-03, 1.90447e-03,
     &  2.02049e-03, 1.98360e-03, 2.04364e-03, 2.02519e-03,
     &  2.20802e-03, 1.96964e-03, 1.94559e-03, 2.09922e-03,
     &  2.11184e-03, 2.05706e-03, 2.02257e-03, 2.01781e-03,
     &  2.01055e-03, 1.86538e-03, 1.86899e-03, 1.76798e-03,
     &  1.85871e-03, 1.95363e-03, 1.96404e-03, 1.84169e-03,
     &  1.82851e-03, 1.84582e-03, 1.81997e-03, 1.76461e-03,
     &  1.68384e-03, 1.65530e-03, 1.73550e-03, 1.62463e-03,
     &  1.68793e-03, 1.60472e-03, 1.67560e-03, 1.67431e-03,
     &  1.61779e-03, 1.66446e-03, 1.66403e-03, 1.55724e-03,
     &  1.62351e-03, 1.71545e-03, 1.69645e-03, 1.59540e-03,
     &  1.62948e-03, 1.66784e-03, 1.66416e-03, 1.66131e-03,
     &  1.71502e-03, 1.76555e-03, 1.75182e-03, 1.72327e-03,
     &  1.72338e-03, 1.69993e-03, 1.78819e-03, 1.73517e-03,
     &  1.74802e-03, 1.81751e-03, 1.70973e-03, 1.65075e-03,
     &  1.70784e-03, 1.73655e-03, 1.71670e-03, 1.67367e-03,
     &  1.69338e-03, 1.61772e-03, 1.54914e-03, 1.56009e-03,
     &  1.59467e-03, 1.60761e-03, 1.57117e-03, 1.54045e-03,
     &  1.53102e-03, 1.44516e-03, 1.49898e-03, 1.56048e-03,
     &  1.60087e-03, 1.62636e-03, 1.62472e-03, 1.53931e-03,
     &  1.55536e-03, 1.61649e-03, 1.66493e-03, 1.86915e-03,
     &  1.59984e-03, 1.60483e-03, 1.66549e-03, 1.73449e-03/
      data s1(1201:1300)/
     &  1.73673e-03, 1.68393e-03, 1.67434e-03, 1.77880e-03,
     &  1.76154e-03, 1.43028e-03, 1.69651e-03, 1.60934e-03,
     &  1.69413e-03, 1.70514e-03, 1.62471e-03, 1.74854e-03,
     &  1.76480e-03, 1.63495e-03, 1.59364e-03, 1.39603e-03,
     &  1.47897e-03, 1.49509e-03, 1.70002e-03, 1.63048e-03,
     &  1.44807e-03, 1.45071e-03, 1.53998e-03, 1.45276e-03,
     &  1.29129e-03, 1.52900e-03, 1.64444e-03, 1.37450e-03,
     &  1.42574e-03, 1.47355e-03, 1.51202e-03, 1.54376e-03,
     &  1.51421e-03, 1.43989e-03, 1.45732e-03, 1.42912e-03,
     &  1.59906e-03, 1.56748e-03, 1.52383e-03, 1.47665e-03,
     &  1.51465e-03, 1.55582e-03, 1.54521e-03, 1.55189e-03,
     &  1.56772e-03, 1.45401e-03, 1.55775e-03, 1.43120e-03,
     &  1.39659e-03, 1.41451e-03, 1.45157e-03, 1.48303e-03,
     &  1.42540e-03, 1.26387e-03, 1.37479e-03, 1.46381e-03,
     &  1.38134e-03, 1.32733e-03, 1.38030e-03, 1.44619e-03,
     &  1.41344e-03, 1.31982e-03, 1.24944e-03, 1.20096e-03,
     &  1.21107e-03, 1.27999e-03, 1.22523e-03, 1.22193e-03,
     &  1.35957e-03, 1.41427e-03, 1.35679e-03, 1.15438e-03,
     &  1.41184e-03, 1.49093e-03, 1.32193e-03, 1.25009e-03,
     &  1.37625e-03, 1.49022e-03, 1.44180e-03, 1.27628e-03,
     &  1.29670e-03, 1.31636e-03, 1.28874e-03, 1.31177e-03,
     &  1.35732e-03, 1.33854e-03, 1.30253e-03, 1.31374e-03,
     &  1.27379e-03, 1.18339e-03, 1.22016e-03, 1.26551e-03,
     &  1.26371e-03, 1.28180e-03, 1.36024e-03, 1.45759e-03,
     &  1.29413e-03, 1.35858e-03, 1.26528e-03, 1.18623e-03/
      data s1(1301:1400)/
     &  1.21812e-03, 1.28799e-03, 1.37028e-03, 1.29268e-03,
     &  1.27639e-03, 1.19487e-03, 1.23542e-03, 1.25010e-03,
     &  1.17418e-03, 1.13914e-03, 1.21951e-03, 1.13780e-03,
     &  1.16443e-03, 1.17883e-03, 1.11982e-03, 1.05708e-03,
     &  1.04865e-03, 1.05884e-03, 1.06599e-03, 1.13828e-03,
     &  1.10373e-03, 1.07739e-03, 1.04632e-03, 1.06118e-03,
     &  1.15445e-03, 1.17300e-03, 1.00675e-03, 1.04235e-03,
     &  1.08398e-03, 1.06587e-03, 1.05536e-03, 1.08614e-03,
     &  1.09026e-03, 1.09141e-03, 1.13051e-03, 1.08667e-03,
     &  1.04016e-03, 1.04897e-03, 1.08894e-03, 1.09682e-03,
     &  1.09638e-03, 9.79254e-04, 1.00668e-03, 1.02569e-03,
     &  1.00581e-03, 9.74433e-04, 9.66321e-04, 9.78440e-04,
     &  9.01587e-04, 1.02149e-03, 9.87464e-04, 9.41872e-04,
     &  9.05021e-04, 8.59547e-04, 9.03963e-04, 8.66415e-04,
     &  8.84726e-04, 8.77087e-04, 8.70584e-04, 8.81338e-04,
     &  8.97658e-04, 8.97586e-04, 9.19028e-04, 8.82438e-04,
     &  9.00710e-04, 9.54329e-04, 9.54490e-04, 9.10940e-04,
     &  9.95472e-04, 9.50134e-04, 9.17127e-04, 9.70916e-04,
     &  9.87575e-04, 9.65026e-04, 9.71779e-04, 1.00967e-03,
     &  1.00053e-03, 9.26063e-04, 9.34721e-04, 9.76354e-04,
     &  9.78436e-04, 9.36012e-04, 9.64448e-04, 9.95903e-04,
     &  9.89960e-04, 9.41143e-04, 9.04393e-04, 8.84719e-04,
     &  8.41396e-04, 8.67234e-04, 8.55864e-04, 8.63314e-04,
     &  8.72317e-04, 8.40899e-04, 7.79593e-04, 7.88481e-04,
     &  8.21075e-04, 7.38342e-04, 7.56537e-04, 7.57278e-04/
      data s1(1401:1500)/
     &  7.35854e-04, 7.32765e-04, 6.67398e-04, 7.45338e-04,
     &  7.33094e-04, 7.01840e-04, 6.85595e-04, 6.95740e-04,
     &  7.24015e-04, 7.00907e-04, 7.28498e-04, 6.89410e-04,
     &  6.91728e-04, 7.40601e-04, 7.62775e-04, 7.40912e-04,
     &  7.35021e-04, 7.07799e-04, 7.54113e-04, 8.44845e-04,
     &  8.53956e-04, 6.42186e-04, 7.40557e-04, 7.54340e-04,
     &  7.55544e-04, 7.88986e-04, 7.97902e-04, 6.98460e-04,
     &  7.74873e-04, 6.81178e-04, 7.15567e-04, 7.56723e-04,
     &  7.98438e-04, 8.83150e-04, 8.45671e-04, 7.40924e-04,
     &  7.35498e-04, 7.77829e-04, 6.93566e-04, 5.10188e-04,
     &  7.52717e-04, 6.94185e-04, 6.71928e-04, 6.73286e-04,
     &  6.89415e-04, 7.22917e-04, 7.89448e-04, 8.53812e-04,
     &  7.45132e-04, 7.68732e-04, 8.10104e-04, 7.55615e-04,
     &  7.09145e-04, 6.80676e-04, 7.54594e-04, 7.89416e-04,
     &  7.88579e-04, 7.49805e-04, 6.13534e-04, 7.22491e-04,
     &  7.95410e-04, 7.80604e-04, 7.74283e-04, 7.93224e-04,
     &  6.86522e-04, 8.06038e-04, 8.30285e-04, 8.37763e-04,
     &  8.03863e-04, 7.33526e-04, 7.42588e-04, 6.31046e-04,
     &  8.16153e-04, 8.95391e-04, 8.61330e-04, 8.38726e-04,
     &  8.16761e-04, 8.16118e-04, 6.37058e-04, 6.30868e-04,
     &  7.26410e-04, 7.03464e-04, 5.93454e-04, 6.01985e-04,
     &  6.51157e-04, 6.68569e-04, 6.56297e-04, 6.58732e-04,
     &  5.99721e-04, 5.34301e-04, 5.33271e-04, 5.57992e-04,
     &  5.70096e-04, 5.59932e-04, 5.32110e-04, 5.64713e-04,
     &  6.25026e-04, 6.38973e-04, 6.05323e-04, 7.17460e-04/
      data s1(1501:1600)/
     &  6.19407e-04, 5.90228e-04, 5.43682e-04, 5.38446e-04,
     &  6.56146e-04, 6.09081e-04, 6.04737e-04, 6.45526e-04,
     &  6.46978e-04, 5.89738e-04, 5.63852e-04, 6.18018e-04,
     &  5.71768e-04, 5.75433e-04, 6.05766e-04, 5.93065e-04,
     &  5.31708e-04, 5.41187e-04, 5.76985e-04, 5.78176e-04,
     &  5.75339e-04, 6.85426e-04, 5.51038e-04, 6.02049e-04,
     &  6.20406e-04, 5.80169e-04, 5.36399e-04, 5.59608e-04,
     &  5.46575e-04, 5.66979e-04, 5.94982e-04, 6.18469e-04,
     &  6.56281e-04, 8.22124e-04, 7.81716e-04, 7.29616e-04,
     &  7.14460e-04, 7.08969e-04, 6.53794e-04, 7.33138e-04,
     &  8.29513e-04, 8.99395e-04, 9.05526e-04, 7.98257e-04,
     &  7.86935e-04, 6.10797e-04, 4.63912e-04, 4.05675e-04,
     &  3.66230e-04, 4.86472e-04, 5.31818e-04, 5.15865e-04,
     &  4.87344e-04, 4.99857e-04, 5.35479e-04, 5.27561e-04,
     &  4.99000e-04, 4.77056e-04, 4.74242e-04, 4.66595e-04,
     &  4.66325e-04, 4.94704e-04, 5.12842e-04, 5.01795e-04,
     &  4.80789e-04, 5.73709e-04, 5.65214e-04, 5.11321e-04,
     &  4.55242e-04, 4.29330e-04, 5.09792e-04, 4.70489e-04,
     &  4.82859e-04, 4.99195e-04, 4.07724e-04, 4.99951e-04,
     &  4.55755e-04, 4.42528e-04, 4.19433e-04, 3.31325e-04,
     &  3.70517e-04, 3.77708e-04, 2.97923e-04, 2.27470e-04,
     &  2.47389e-04, 2.38324e-04, 2.56706e-04, 2.45046e-04,
     &  2.62539e-04, 3.37054e-04, 3.33930e-04, 3.01390e-04,
     &  3.08028e-04, 3.41464e-04, 3.70574e-04, 3.47893e-04,
     &  3.28433e-04, 3.46976e-04, 3.60351e-04, 3.50559e-04/
      data s1(1601:1700)/
     &  3.56070e-04, 3.62782e-04, 3.37330e-04, 3.33763e-04,
     &  3.57046e-04, 3.08784e-04, 2.93898e-04, 2.80842e-04,
     &  2.54114e-04, 2.38198e-04, 3.48753e-04, 2.97334e-04,
     &  2.82929e-04, 2.94150e-04, 3.07875e-04, 3.21129e-04,
     &  3.38335e-04, 3.49826e-04, 3.47647e-04, 3.35438e-04,
     &  3.58145e-04, 3.72391e-04, 3.59372e-04, 3.64755e-04,
     &  4.16867e-04, 3.43614e-04, 3.34932e-04, 3.12782e-04,
     &  3.28220e-04, 4.32595e-04, 3.49513e-04, 3.51861e-04,
     &  3.81166e-04, 3.91194e-04, 3.38944e-04, 2.63445e-04,
     &  2.49520e-04, 2.46184e-04, 2.33203e-04, 2.16315e-04,
     &  1.89536e-04, 1.95730e-04, 1.99664e-04, 1.77139e-04,
     &  1.27969e-04, 5.17216e-05, 7.60445e-05, 1.24418e-04,
     &  1.30989e-04, 2.31539e-04, 2.21334e-04, 2.08757e-04,
     &  2.18351e-04, 2.46202e-04, 2.29824e-04, 2.28909e-04,
     &  2.88826e-04, 3.58039e-04, 2.60800e-04, 2.33025e-04,
     &  2.52667e-04, 2.61394e-04, 2.31384e-04, 2.29388e-04,
     &  2.54701e-04, 2.21158e-04, 1.61506e-04, 1.36752e-04,
     &  1.69481e-04, 8.64539e-05, 1.64407e-04, 3.65674e-04,
     &  3.18233e-04, 4.00755e-04, 3.33375e-04, 2.62930e-04,
     &  2.87052e-04, 2.51395e-04, 2.85274e-04, 2.66915e-04,
     &  2.10866e-04, 1.89517e-04, 1.67378e-04, 2.79951e-04,
     &  2.97224e-04, 1.89222e-04, 3.33825e-04, 3.56386e-04,
     &  3.89727e-04, 4.30407e-04, 4.45922e-04, 4.23446e-04,
     &  4.41347e-04, 4.06723e-04, 3.00181e-04, 1.85243e-04,
     &  3.13176e-04, 4.08991e-04, 4.24776e-04, 3.56412e-04/
      data s1(1701:1800)/
     &  3.84760e-04, 2.30602e-04, 1.77702e-04, 2.62329e-04,
     &  2.49442e-04, 3.76212e-04, 3.69176e-04, 2.97681e-04,
     &  2.71662e-04, 2.05694e-04, 2.11418e-04, 2.25439e-04,
     &  2.27013e-04, 2.47845e-04, 3.14603e-04, 2.68802e-04,
     &  2.04334e-04, 2.77399e-04, 2.68273e-04, 2.04991e-04,
     &  2.24441e-04, 3.55074e-04, 2.90135e-04, 3.35680e-04,
     &  3.59358e-04, 3.44716e-04, 3.24496e-04, 3.48146e-04,
     &  3.49042e-04, 3.54848e-04, 3.86418e-04, 3.59198e-04,
     &  3.47608e-04, 3.20522e-04, 2.78401e-04, 2.64579e-04,
     &  2.23694e-04, 2.34370e-04, 2.52559e-04, 1.88475e-04,
     &  2.01258e-04, 1.63979e-04, 1.45384e-04, 1.91215e-04,
     &  1.76958e-04, 1.69167e-04, 1.71767e-04, 1.86595e-04,
     &  2.14969e-04, 2.48345e-04, 2.46691e-04, 2.25234e-04,
     &  2.26755e-04, 1.64112e-04, 1.87750e-04, 2.22984e-04,
     &  2.00443e-04, 2.38863e-04, 2.77590e-04, 2.91953e-04,
     &  2.80611e-04, 3.08215e-04, 1.79095e-04, 1.46920e-04,
     &  2.29177e-04, 2.54685e-04, 2.68866e-04, 2.13346e-04,
     &  1.20122e-04, 5.55240e-05, 5.99017e-05, 1.07768e-04,
     &  1.67810e-04, 2.06886e-04, 2.36232e-04, 2.24598e-04,
     &  2.30792e-04, 2.71274e-04, 1.29062e-04, 1.92624e-04,
     &  2.38438e-04, 1.98994e-04, 1.81687e-04, 2.55733e-04,
     &  2.84379e-04, 2.54459e-04, 2.30884e-04, 2.68873e-04,
     &  3.07231e-04, 3.15063e-04, 2.46725e-04, 2.60370e-04,
     &  2.66391e-04, 2.50708e-04, 2.04296e-04, 1.66011e-04,
     &  1.19164e-04, 1.06700e-04, 1.77576e-04, 1.91741e-04/
      data s1(1801:1900)/
     &  1.66618e-04, 1.49824e-04, 1.80699e-04, 2.20905e-04,
     &  1.38754e-04, 6.27971e-05, 7.52567e-05, 1.89995e-04,
     &  1.72489e-04, 1.40424e-04, 1.52384e-04, 1.63942e-04,
     &  1.19901e-04, 1.49234e-04, 2.68313e-04, 2.08815e-04,
     &  1.17218e-04, 1.42235e-04, 2.71237e-04, 1.38192e-04,
     &  2.15643e-04, 2.84476e-04, 2.78117e-04, 2.19234e-04,
     &  1.59128e-04, 1.78819e-04, 2.67785e-04, 2.66786e-04,
     &  2.58545e-04, 2.68476e-04, 2.88542e-04, 2.59726e-04,
     &  3.00936e-04, 3.11237e-04, 2.61275e-04, 1.37136e-04,
     &  2.76566e-04, 3.82888e-04, 3.97564e-04, 4.43655e-04,
     &  3.15415e-04, 2.60869e-04, 3.19171e-04, 3.34205e-04,
     &  2.02914e-04, 1.16223e-04, 1.14737e-04, 6.10978e-05,
     & -8.03695e-06,-1.07062e-05, 6.50664e-05, 1.12586e-04,
     &  1.56727e-04, 1.57927e-04, 1.05762e-04, 1.03646e-04,
     &  1.72520e-04, 2.23668e-04, 2.12775e-04, 2.33525e-04,
     &  2.75558e-04, 2.34256e-04, 5.10062e-05, 1.76007e-04,
     &  1.70850e-04, 1.43266e-04, 1.89626e-04, 2.97283e-04,
     &  3.02773e-04, 2.74401e-04, 3.00754e-04, 3.66813e-04,
     &  3.54383e-04, 2.90580e-04, 2.32206e-04, 1.58405e-04,
     &  1.54663e-04, 1.84598e-04, 1.26408e-04, 2.14481e-04,
     &  2.00791e-04, 1.05796e-04, 2.39794e-04, 1.66105e-04,
     &  7.88615e-05, 4.30615e-05, 7.37518e-05, 1.24926e-04,
     &  1.38295e-04, 8.54356e-05, 6.12641e-05, 6.54466e-05,
     &  6.17727e-05, 1.30688e-05, 6.00462e-05, 1.52612e-04,
     &  2.11656e-04, 9.67692e-05, 8.67858e-05, 1.34888e-04/
      data s1(1901:2000)/
     &  1.90899e-04, 1.03234e-04, 1.03837e-04, 1.49767e-04,
     &  2.19058e-04, 2.26549e-04, 2.11506e-04, 1.85238e-04,
     &  1.53774e-04, 1.32313e-04, 6.10658e-05, 2.37782e-05,
     &  1.24450e-04, 1.87610e-04, 1.44775e-04, 5.60937e-05,
     &  6.64032e-05, 1.28073e-04, 1.77512e-04, 1.84684e-04,
     &  5.73677e-05, 5.29679e-05, 9.95510e-05, 1.61423e-04,
     &  3.19036e-04, 3.17383e-04, 2.36505e-04, 1.80844e-04,
     &  1.63722e-04, 1.21478e-04, 6.85823e-05, 7.42058e-05,
     &  1.14838e-04, 1.21131e-04, 8.01009e-05, 1.52058e-04,
     &  2.18368e-04, 2.53416e-04, 2.27116e-04, 1.25336e-04,
     &  6.26421e-05, 5.32471e-05, 1.34705e-04, 2.07005e-05,
     & -5.18630e-05,-3.25696e-05,-8.06171e-05,-1.09430e-04,
     & -1.05637e-04,-4.96066e-05,-7.76138e-05,-4.85930e-05,
     &  3.65111e-06,-2.86933e-05,-4.61366e-05,-4.88820e-05,
     & -3.08816e-05, 8.43778e-05, 1.40484e-04, 1.31125e-04,
     &  3.55198e-05, 8.47412e-05, 1.23408e-04, 1.36799e-04,
     &  1.21147e-04, 1.25585e-04, 1.32337e-04, 1.34092e-04,
     &  1.26652e-04, 1.12131e-04, 1.00927e-04, 1.13828e-04,
     &  1.06053e-04, 9.43643e-05, 8.33628e-05, 8.65842e-05,
     &  7.59315e-05, 8.28623e-05, 1.39681e-04, 1.80492e-04,
     &  1.65779e-04, 1.03843e-04, 3.10284e-05, 1.94408e-05,
     &  4.57525e-05, 1.02436e-04, 1.39750e-04, 1.43342e-04,
     &  1.11999e-04, 2.94197e-05, 2.76980e-05, 5.51685e-05,
     &  9.39909e-05, 1.16108e-04, 7.72703e-05, 4.37409e-05,
     &  1.13925e-04, 8.18872e-05, 2.87657e-05,-2.41413e-05/
      data s1(2001:2100)/
     &  1.24699e-05, 2.19589e-05,-5.88247e-06,-9.66151e-05,
     & -2.06255e-05,-1.83148e-06,-5.63625e-05,-8.65590e-05,
     & -8.26020e-05,-5.06239e-05, 1.28065e-05,-1.34669e-05,
     &  1.59701e-05, 9.44755e-05, 1.63032e-05, 2.51304e-05,
     &  7.38226e-05, 1.28405e-04, 1.17413e-04, 9.92387e-05,
     &  9.51533e-05, 2.17008e-04, 2.25854e-04, 1.90448e-04,
     &  1.77207e-04, 1.80844e-04, 1.53501e-04, 9.80430e-05,
     &  1.27404e-04, 1.16465e-04, 9.98611e-05, 1.25556e-04,
     &  1.73627e-04, 1.12347e-04,-7.73523e-05, 5.66599e-05,
     &  5.36347e-05, 1.20227e-06, 6.96325e-05, 4.79010e-05,
     & -1.09886e-05,-9.16457e-05,-7.09170e-05,-5.31410e-05,
     & -2.68376e-05, 6.32641e-05, 8.06052e-06,-4.99262e-05,
     & -2.56644e-05,-8.76854e-05,-8.21360e-05,-5.02403e-06,
     &  4.66629e-05, 6.93127e-05, 5.53828e-05,-2.32399e-05,
     & -2.07514e-05,-7.33240e-05,-2.10483e-04,-1.53757e-04,
     & -7.13861e-05,-1.07356e-05,-1.26578e-04,-7.48854e-05,
     &  3.25418e-06, 2.97068e-05, 3.35685e-05, 3.15022e-05,
     &  2.68904e-05, 3.87401e-05, 5.12522e-05, 5.12172e-05,
     &  1.05053e-05, 1.65321e-05, 3.47537e-05, 5.62503e-05,
     &  4.18666e-05, 3.13970e-05, 3.11750e-05, 7.21547e-05,
     &  2.55262e-05,-2.76061e-05, 5.43449e-06,-5.20575e-05,
     & -1.08627e-04,-1.40475e-04,-1.59926e-04,-1.32237e-04,
     & -8.15458e-05,-1.31738e-04,-1.64036e-04,-1.69351e-04,
     & -1.24797e-04,-1.61950e-04,-2.01904e-04,-2.22995e-04,
     & -1.87647e-04,-1.70817e-04,-1.64583e-04,-1.12811e-04/
      data s1(2101:2200)/
     & -8.38306e-05,-8.62707e-05,-1.54362e-04,-1.98090e-04,
     & -2.12920e-04,-1.89358e-04,-2.02988e-04,-1.72791e-04,
     & -1.02863e-04,-1.09877e-04,-1.04257e-04,-8.20734e-05,
     & -2.18346e-05,-2.94593e-05,-4.18226e-05,-1.86891e-05,
     & -6.14620e-05,-3.21912e-05, 1.00844e-04, 6.92419e-05,
     &  3.16713e-05, 5.62042e-07, 5.18900e-05, 7.48835e-05,
     &  8.03381e-05, 7.24685e-05, 9.55588e-05, 9.22801e-05,
     &  2.87159e-05, 2.26234e-05, 2.62790e-05, 3.58332e-05,
     &  6.23297e-05, 5.01998e-05, 1.81446e-05, 3.33564e-05,
     &  3.97765e-06,-2.60624e-05, 7.01802e-06,-4.16797e-05,
     & -8.70108e-05,-8.22182e-05,-6.64886e-05,-7.88704e-05,
     & -1.28305e-04,-1.29990e-04,-1.12646e-04,-8.68394e-05,
     & -1.29584e-04,-1.44352e-04,-1.42082e-04,-1.33790e-04,
     & -1.27963e-04,-1.21233e-04,-1.09965e-04,-1.02233e-04,
     & -1.03804e-04,-1.19503e-04,-7.74707e-05,-4.66805e-05,
     & -3.52201e-05,-4.07406e-05,-4.66887e-05,-5.05962e-05,
     & -3.30333e-05,-3.47981e-05,-3.60962e-05, 1.44242e-05,
     &  4.10478e-05, 3.68984e-05,-2.81300e-05, 2.83171e-05,
     &  7.48062e-05, 4.29333e-05, 8.50076e-06, 4.98135e-06,
     &  4.44854e-05, 2.51860e-05, 3.12189e-05, 6.39424e-05,
     &  7.20715e-05, 9.89688e-05, 1.33768e-04, 1.07781e-04,
     &  9.76731e-05, 9.21479e-05, 6.72624e-05, 5.41295e-05,
     &  4.89022e-05, 5.28039e-05,-4.48737e-06,-5.15409e-05,
     & -3.57396e-05,-1.94752e-05,-2.09521e-05,-5.13096e-05,
     & -2.62781e-05,-2.75451e-05,-6.98423e-05,-1.25462e-04/
      data s1(2201:2300)/
     & -1.68362e-04,-1.97456e-04,-1.90669e-04,-2.06890e-04,
     & -2.36699e-04,-1.97732e-04,-1.76504e-04,-1.67505e-04,
     & -1.60694e-04,-1.85851e-04,-2.01567e-04,-9.82507e-05,
     & -1.33338e-04,-1.95199e-04,-1.40781e-04,-8.90988e-05,
     & -3.63239e-05, 2.16510e-05,-1.56807e-05,-4.21285e-05,
     &  5.50505e-06, 6.78937e-07, 3.12346e-06, 3.64202e-05,
     &  3.50651e-05, 6.20423e-05, 1.38667e-04, 7.74738e-05,
     &  6.77036e-05, 1.38367e-04, 1.17359e-04, 1.06637e-04,
     &  1.12404e-04, 9.78586e-05, 1.03178e-04, 1.28717e-04,
     &  1.56642e-04, 1.62544e-04, 1.50109e-04, 1.43214e-04,
     &  1.33651e-04, 1.24352e-04, 1.41420e-04, 1.36340e-04,
     &  1.18769e-04, 1.31656e-04, 8.81533e-05, 1.55214e-05,
     & -3.68736e-07,-1.76213e-05,-2.85341e-05, 4.65155e-06,
     &  5.41350e-06,-7.01247e-06, 6.57918e-06,-2.45784e-05,
     & -6.89104e-05,-6.90953e-05,-6.23937e-05,-6.72978e-05,
     & -1.39547e-04,-1.44228e-04,-1.42543e-04,-2.31080e-04,
     & -2.12756e-04,-1.62089e-04,-1.66063e-04,-1.61872e-04,
     & -1.59764e-04,-1.80217e-04,-1.38355e-04,-8.45661e-05,
     & -7.58308e-05,-4.65144e-05,-2.76855e-05,-7.48714e-05,
     & -8.28561e-05,-6.45277e-05,-7.08509e-06,-1.05566e-05,
     & -1.96352e-05, 3.55561e-05, 2.24676e-05,-1.25648e-05,
     & -1.87661e-05, 6.99061e-06, 2.33676e-05,-5.25111e-05,
     & -3.86758e-05, 1.03585e-06,-1.65901e-05,-1.04855e-05,
     &  5.03694e-06, 1.25937e-05,-8.31340e-06,-4.37906e-05,
     & -7.91444e-05,-4.62167e-05, 5.14238e-06,-4.52863e-05/
      data s1(2301:2400)/
     & -5.86455e-05,-4.98093e-05,-3.03495e-05,-5.09377e-05,
     & -8.88116e-05,-6.21360e-05,-7.38148e-05,-1.07502e-04,
     & -7.55276e-05,-6.39257e-05,-6.86921e-05,-8.05504e-05,
     & -9.24178e-05,-1.03991e-04,-1.00468e-04,-6.71447e-05,
     & -3.84897e-06,-5.99067e-06,-2.21894e-05,-5.21766e-05,
     & -3.93796e-05,-4.06712e-05,-6.21649e-05,-1.13073e-04,
     & -1.20560e-04,-5.92397e-05, 5.24432e-05, 9.41628e-05,
     & -3.47458e-07, 5.33267e-05, 8.92961e-05, 2.75694e-05,
     & -7.48460e-06,-2.15504e-05, 1.05501e-06, 6.30910e-06,
     &  5.94620e-07,-2.45194e-05,-1.59657e-05, 7.93610e-07,
     & -1.05319e-05,-2.36584e-05,-3.95700e-05,-6.57225e-05,
     & -5.23797e-05,-1.82588e-05,-1.43240e-05,-3.29989e-05,
     & -6.48909e-05,-2.41326e-05,-1.89195e-05,-4.64607e-05,
     & -1.00739e-05,-1.35033e-05,-6.49945e-05,-5.19986e-05,
     & -6.68505e-05,-1.31530e-04,-1.45464e-04,-1.46815e-04,
     & -1.39684e-04,-1.23205e-04,-1.26738e-04,-1.93822e-04,
     & -2.37508e-04,-2.52917e-04,-1.91110e-04,-1.36217e-04,
     & -9.41093e-05,-1.20601e-04,-1.17295e-04,-9.57420e-05,
     & -1.57227e-04,-1.62795e-04,-1.12201e-04,-1.20419e-04,
     & -1.10597e-04,-7.61223e-05,-6.27167e-05,-5.54733e-05,
     & -5.50437e-05,-5.14148e-05,-3.59591e-05, 1.09906e-05,
     &  5.94396e-06,-1.38597e-05,-8.80857e-06,-3.13101e-05,
     & -6.31715e-05,-4.04264e-05,-1.66405e-05, 7.94396e-06,
     & -3.41772e-06,-4.03175e-05,-1.06888e-04,-9.50526e-05,
     & -7.46111e-05,-5.09617e-05,-6.70981e-05,-7.93529e-05/
      data s1(2401:2500)/
     & -5.58423e-05,-1.01523e-04,-1.62269e-04,-1.69958e-04,
     & -1.37786e-04,-8.79862e-05,-1.46838e-04,-1.66938e-04,
     & -1.51380e-04,-1.62184e-04,-1.61105e-04,-1.42088e-04,
     & -1.57033e-04,-1.65294e-04,-1.45079e-04,-9.76982e-05,
     & -6.09891e-05,-1.01719e-04,-1.03049e-04,-8.85546e-05,
     & -1.47754e-04,-1.44542e-04,-8.34620e-05,-8.99440e-05,
     & -7.11901e-05,-1.57480e-05,-8.81797e-05,-1.56314e-04,
     & -1.65952e-04,-1.80986e-04,-2.04610e-04,-2.58669e-04,
     & -2.16016e-04,-1.21582e-04,-1.44929e-04,-1.72886e-04,
     & -2.05950e-04,-1.93829e-04,-1.67518e-04,-1.22969e-04,
     & -1.13060e-04,-1.14854e-04,-1.26198e-04,-1.24288e-04,
     & -1.19519e-04,-1.50456e-04,-1.53286e-04,-1.32231e-04,
     & -7.42672e-05,-2.23129e-05, 1.79115e-05, 1.42073e-05,
     & -1.21676e-05,-7.56567e-05,-1.03423e-04,-1.10373e-04,
     & -8.77244e-05,-6.43485e-05,-4.05156e-05,-6.24405e-05,
     & -5.70375e-05,-2.36695e-06,-3.75929e-05,-7.97119e-05,
     & -6.70419e-05,-6.99475e-05,-8.19748e-05,-1.06895e-04,
     & -1.31422e-04,-1.55438e-04,-1.61937e-04,-1.62626e-04,
     & -1.54977e-04,-1.77814e-04,-2.00386e-04,-1.87407e-04,
     & -2.07243e-04,-2.44672e-04,-2.19014e-04,-2.13695e-04,
     & -2.32440e-04,-1.85194e-04,-1.51172e-04,-1.69834e-04,
     & -1.73780e-04,-1.75232e-04,-2.00698e-04,-1.82826e-04,
     & -1.27786e-04,-1.33633e-04,-1.21317e-04,-7.50390e-05,
     & -1.06743e-04,-1.40805e-04,-1.06336e-04,-9.46654e-05,
     & -9.78182e-05,-1.19906e-04,-1.14160e-04,-7.28186e-05/
      data s1(2501:2600)/
     & -1.07652e-04,-1.20978e-04,-3.79658e-05,-3.16113e-05,
     & -6.02417e-05,-7.51148e-05,-5.56145e-05,-6.77421e-06,
     & -1.74321e-05,-4.67952e-05,-1.05000e-04,-6.29932e-05,
     & -4.74356e-06,-2.83397e-05,-4.65192e-05,-6.04574e-05,
     & -4.33970e-05,-3.18311e-05,-3.02321e-05,-4.49667e-05,
     & -6.85347e-05,-1.11375e-04,-1.16293e-04,-9.38757e-05,
     & -1.38594e-04,-1.60483e-04,-1.48344e-04,-1.33436e-04,
     & -1.27387e-04,-1.59508e-04,-1.74026e-04,-1.72170e-04,
     & -1.49196e-04,-1.33233e-04,-1.22382e-04,-1.78156e-04,
     & -2.21349e-04,-2.41846e-04,-2.06549e-04,-1.68283e-04,
     & -1.89512e-04,-1.44523e-04,-4.67953e-05,-1.00334e-04,
     & -1.23478e-04,-8.14024e-05,-9.18016e-05,-1.17536e-04,
     & -1.36160e-04,-1.38780e-04,-1.27749e-04,-1.45598e-04,
     & -1.55964e-04,-1.45120e-04,-1.25544e-04,-1.05692e-04,
     & -1.17639e-04,-1.24142e-04,-1.24749e-04,-1.63878e-04,
     & -1.97021e-04,-1.98617e-04,-2.69136e-04,-3.68357e-04,
     & -2.33702e-04,-1.61830e-04,-1.78578e-04,-2.01839e-04,
     & -2.28731e-04,-2.63606e-04,-2.44698e-04,-1.86451e-04,
     & -2.20546e-04,-2.22752e-04,-1.55169e-04,-1.25100e-04,
     & -1.09794e-04,-9.59016e-05,-1.03857e-04,-1.35573e-04,
     & -1.73780e-04,-1.82457e-04,-9.39821e-05,-1.18245e-04,
     & -2.11563e-04,-1.37392e-04,-9.28173e-05,-9.71073e-05,
     & -9.72535e-05,-9.39557e-05,-7.50117e-05,-6.70754e-05,
     & -7.01186e-05,-5.76151e-05,-5.18785e-05,-7.14209e-05,
     & -7.01682e-05,-5.61614e-05,-8.92769e-05,-1.06238e-04/
      data s1(2601:2687)/
     & -9.70294e-05,-6.70229e-05,-4.69214e-05,-1.53105e-04,
     & -2.02326e-04,-1.90395e-04,-2.04367e-04,-2.16787e-04,
     & -2.08725e-04,-1.78119e-04,-1.31043e-04,-1.32204e-04,
     & -1.51522e-04,-2.05143e-04,-1.77144e-04,-1.16130e-04,
     & -1.44440e-04,-1.66010e-04,-1.78206e-04,-1.61163e-04,
     & -1.46351e-04,-1.96722e-04,-2.27027e-04,-2.37243e-04,
     & -2.25235e-04,-1.99552e-04,-1.40238e-04,-1.26311e-04,
     & -1.42746e-04,-1.19028e-04,-1.18750e-04,-1.72076e-04,
     & -1.72120e-04,-1.48285e-04,-1.85116e-04,-1.98602e-04,
     & -1.74016e-04,-1.37913e-04,-1.01221e-04,-9.69581e-05,
     & -1.08794e-04,-1.39433e-04,-1.38575e-04,-1.32088e-04,
     & -1.37431e-04,-1.30033e-04,-1.10829e-04,-1.35604e-04,
     & -1.66515e-04,-1.98167e-04,-1.97716e-04,-1.74019e-04,
     & -1.64719e-04,-1.64779e-04,-1.85725e-04,-2.28526e-04,
     & -2.84329e-04,-1.82449e-04,-1.30747e-04,-1.93620e-04,
     & -2.28529e-04,-2.47361e-04,-1.90001e-04,-1.66278e-04,
     & -2.02540e-04,-2.31811e-04,-2.53772e-04,-2.08629e-04,
     & -1.85021e-04,-1.93989e-04,-2.16568e-04,-2.38288e-04,
     & -1.94453e-04,-1.87154e-04,-2.30493e-04,-2.34696e-04,
     & -2.30351e-04,-2.60562e-04,-2.86427e-04,-3.06699e-04,
     & -2.79131e-04,-2.49392e-04,-3.03389e-04,-3.10346e-04,
     & -2.61782e-04,-2.30905e-04,-2.11669e-04/

      data s2(1:100)/
     &  1.00000e-05, 1.00000e-05, 1.00000e-05, 1.00000e-05,
     &  1.00000e-05, 1.00000e-05, 1.00000e-05, 1.00000e-05,
     &  1.00000e-05, 1.00000e-05, 1.00000e-05, 1.00000e-05,
     &  1.00000e-05, 1.00000e-05, 1.00000e-05, 1.00000e-05,
     &  1.00000e-05, 1.00000e-05, 1.00000e-05, 1.00000e-05,
     &  1.00000e-05, 1.00000e-05, 1.00000e-05, 1.00000e-05,
     &  1.00000e-05, 1.00000e-05, 1.00000e-05, 1.00000e-05,
     &  1.00000e-05, 1.00000e-05, 1.00000e-05, 1.00000e-05,
     &  1.00000e-05, 1.00000e-05, 1.00000e-05, 1.00000e-05,
     &  1.00000e-05, 1.00000e-05, 1.00000e-05, 1.00000e-05,
     &  1.00000e-05, 1.00000e-05, 1.00000e-05, 1.00000e-05,
     &  1.00000e-05, 1.00000e-05, 1.00000e-05, 1.00000e-05,
     &  1.00000e-05, 1.00000e-05, 1.00000e-05, 1.00000e-05,
     &  1.00000e-05, 1.00000e-05, 1.00000e-05, 1.00000e-05,
     &  1.00000e-05, 1.00000e-05, 1.00000e-05, 1.00000e-05,
     &  1.00000e-05, 1.00000e-05, 1.00000e-05, 1.00000e-05,
     &  1.00000e-05, 1.00000e-05, 1.00000e-05, 1.00000e-05,
     &  1.00000e-05, 1.00000e-05, 1.00000e-05, 1.00000e-05,
     &  1.00000e-05, 1.00000e-05, 1.00000e-05, 1.00000e-05,
     &  1.00000e-05, 1.00000e-05, 1.00000e-05, 1.00000e-05,
     &  1.00000e-05, 1.00000e-05, 1.00000e-05, 1.00000e-05,
     &  1.00000e-05, 1.00000e-05, 1.00000e-05, 1.00000e-05,
     &  1.29359e-05, 1.55806e-05, 2.00719e-05, 2.64912e-05,
     &  3.48207e-05, 4.36986e-05, 5.31318e-05, 6.13173e-05,
     &  6.89465e-05, 7.56793e-05, 8.26345e-05, 8.90916e-05/
      data s2(101:200)/
     &  9.38759e-05, 9.22998e-05, 9.03184e-05, 8.65369e-05,
     &  8.58531e-05, 8.55635e-05, 8.40418e-05, 8.11983e-05,
     &  7.58246e-05, 7.29282e-05, 7.32629e-05, 7.04060e-05,
     &  6.71451e-05, 6.56515e-05, 6.68943e-05, 6.32785e-05,
     &  5.88386e-05, 5.70860e-05, 5.64435e-05, 5.49441e-05,
     &  5.70845e-05, 5.89357e-05, 6.14433e-05, 5.91790e-05,
     &  5.31727e-05, 5.14007e-05, 4.74318e-05, 4.35356e-05,
     &  3.93903e-05, 3.70963e-05, 3.63867e-05, 4.05296e-05,
     &  4.48891e-05, 5.37190e-05, 5.70440e-05, 4.60408e-05,
     &  5.25778e-05, 6.81728e-05, 7.27275e-05, 6.81353e-05,
     &  6.48386e-05, 5.46521e-05, 4.93098e-05, 5.04438e-05,
     &  5.30309e-05, 5.28788e-05, 5.47387e-05, 4.52523e-05,
     &  5.29451e-05, 7.42215e-05, 1.08971e-04, 1.40085e-04,
     &  1.46553e-04, 1.43526e-04, 1.39051e-04, 1.40983e-04,
     &  1.45564e-04, 1.55589e-04, 1.66142e-04, 1.82840e-04,
     &  2.06486e-04, 2.24339e-04, 2.29268e-04, 2.13109e-04,
     &  2.00305e-04, 1.99955e-04, 2.18566e-04, 2.24182e-04,
     &  2.33505e-04, 2.31824e-04, 2.22666e-04, 2.23905e-04,
     &  2.38131e-04, 2.54322e-04, 2.69548e-04, 2.62953e-04,
     &  2.67609e-04, 2.70567e-04, 2.70689e-04, 2.68251e-04,
     &  2.66029e-04, 2.60053e-04, 2.61689e-04, 2.56582e-04,
     &  2.43655e-04, 2.38792e-04, 2.45309e-04, 2.31061e-04,
     &  2.22837e-04, 2.16440e-04, 2.19032e-04, 1.85634e-04,
     &  1.74638e-04, 1.51767e-04, 1.38480e-04, 1.32506e-04,
     &  1.28317e-04, 1.26855e-04, 1.27123e-04, 1.24040e-04/
      data s2(201:300)/
     &  1.19202e-04, 1.28649e-04, 1.36271e-04, 1.42080e-04,
     &  1.47804e-04, 1.39534e-04, 1.27284e-04, 1.09554e-04,
     &  8.69470e-05, 6.72096e-05, 5.23407e-05, 5.12433e-05,
     &  5.15794e-05, 4.94683e-05, 4.95809e-05, 4.07499e-05,
     &  3.14984e-05, 1.46457e-05, 6.98660e-06, 1.85313e-05,
     &  5.48879e-05, 1.09447e-04, 1.52536e-04, 1.78778e-04,
     &  1.91128e-04, 1.99161e-04, 2.02937e-04, 1.95527e-04,
     &  1.92214e-04, 1.83376e-04, 1.81710e-04, 1.82283e-04,
     &  1.75182e-04, 1.72406e-04, 1.68170e-04, 1.67400e-04,
     &  1.69469e-04, 1.69092e-04, 1.65985e-04, 1.66912e-04,
     &  1.74226e-04, 1.85036e-04, 1.85517e-04, 1.85805e-04,
     &  1.73809e-04, 1.67628e-04, 1.57690e-04, 1.54952e-04,
     &  1.53707e-04, 1.57710e-04, 1.58175e-04, 1.67253e-04,
     &  1.82079e-04, 1.91285e-04, 1.96564e-04, 2.03822e-04,
     &  1.93736e-04, 1.82924e-04, 1.73610e-04, 1.69904e-04,
     &  1.66725e-04, 1.63747e-04, 1.63129e-04, 1.62435e-04,
     &  1.67218e-04, 1.69507e-04, 1.70744e-04, 1.65839e-04,
     &  1.72077e-04, 1.67734e-04, 1.51487e-04, 1.43770e-04,
     &  1.37435e-04, 1.25172e-04, 1.12395e-04, 1.07991e-04,
     &  1.00345e-04, 9.36611e-05, 9.59763e-05, 9.26600e-05,
     &  1.00120e-04, 1.04746e-04, 1.10222e-04, 1.03308e-04,
     &  8.97457e-05, 7.91634e-05, 7.50275e-05, 8.30832e-05,
     &  1.01191e-04, 1.21560e-04, 1.34840e-04, 1.38712e-04,
     &  1.41746e-04, 1.39578e-04, 1.37052e-04, 1.33850e-04,
     &  1.26641e-04, 1.21342e-04, 1.17669e-04, 1.25973e-04/
      data s2(301:400)/
     &  1.33623e-04, 1.33839e-04, 1.24427e-04, 1.02462e-04,
     &  8.76101e-05, 8.27912e-05, 8.29040e-05, 7.78590e-05,
     &  7.39042e-05, 6.45765e-05, 5.70151e-05, 5.11846e-05,
     &  4.83163e-05, 5.44700e-05, 5.33120e-05, 5.31350e-05,
     &  5.36190e-05, 5.36860e-05, 5.23080e-05, 5.04410e-05,
     &  4.84020e-05, 4.74760e-05, 4.62150e-05, 4.45070e-05,
     &  4.38300e-05, 4.05080e-05, 3.89310e-05, 3.55250e-05,
     &  3.47220e-05, 3.27430e-05, 2.84560e-05, 2.83180e-05,
     &  2.81320e-05, 2.62210e-05, 2.56730e-05, 2.55210e-05,
     &  2.45880e-05, 2.40930e-05, 2.27870e-05, 2.12410e-05,
     &  1.85530e-05, 1.58710e-05, 1.34620e-05, 1.25530e-05,
     &  1.62760e-05, 2.82960e-05, 3.88170e-05, 4.27330e-05,
     &  4.24290e-05, 4.09540e-05, 3.98680e-05, 3.76690e-05,
     &  3.63120e-05, 3.55350e-05, 3.58950e-05, 3.63490e-05,
     &  3.90330e-05, 4.45120e-05, 5.00660e-05, 5.45720e-05,
     &  5.67100e-05, 5.66150e-05, 5.75200e-05, 5.80340e-05,
     &  5.79270e-05, 5.60270e-05, 5.52420e-05, 5.49740e-05,
     &  5.29270e-05, 5.16380e-05, 5.20270e-05, 5.14200e-05,
     &  5.16180e-05, 5.02530e-05, 5.05090e-05, 4.93760e-05,
     &  5.01350e-05, 4.91910e-05, 4.92100e-05, 4.82160e-05,
     &  4.74870e-05, 4.57490e-05, 4.58840e-05, 4.38520e-05,
     &  4.38240e-05, 4.26120e-05, 4.03490e-05, 4.01770e-05,
     &  3.74740e-05, 3.81200e-05, 3.69150e-05, 3.58230e-05,
     &  3.51860e-05, 3.36380e-05, 3.34510e-05, 3.24280e-05,
     &  3.23490e-05, 3.01830e-05, 2.84360e-05, 2.64400e-05/
      data s2(401:500)/
     &  2.35970e-05, 2.18750e-05, 1.81640e-05, 1.64300e-05,
     &  1.31590e-05, 9.29070e-06, 7.42430e-06, 6.04690e-06,
     &  5.49510e-06, 8.76420e-06, 2.16295e-05, 1.69111e-05,
     &  5.39633e-05, 1.01866e-04, 8.28657e-05, 9.16593e-05,
     &  8.88666e-05, 1.37764e-04, 1.44322e-04, 1.20659e-04,
     &  1.10332e-04, 1.01317e-04, 9.09964e-05, 1.17148e-04,
     &  1.18000e-04, 7.21801e-05, 1.10550e-04, 1.32672e-04,
     &  1.02474e-04, 1.10434e-04, 1.38759e-04, 8.92135e-05,
     &  9.18239e-05, 9.08256e-05, 7.02969e-05, 1.12827e-04,
     &  8.25561e-05, 1.39555e-04, 6.72239e-05, 7.82804e-05,
     &  8.56258e-05, 8.61068e-05, 7.16732e-05, 6.25720e-05,
     &  5.23957e-05, 3.78801e-05, 4.37281e-05, 4.99821e-05,
     &  5.96976e-05, 7.19070e-05, 3.89579e-05, 5.30171e-05,
     &  3.92507e-05, 4.93901e-05, 4.53047e-05, 4.89955e-05,
     &  4.61649e-05, 3.75742e-05, 3.14124e-05, 2.37893e-05,
     &  3.34899e-06, 3.08080e-05, 5.35883e-05, 3.39838e-05,
     &  7.02334e-05, 7.24784e-05, 7.46533e-05, 6.22257e-05,
     &  6.38945e-05, 6.73423e-05, 4.51321e-05, 5.91854e-05,
     &  5.51601e-05, 4.41923e-05, 3.59217e-05, 4.08520e-05,
     &  6.15981e-05, 6.66549e-05, 8.26031e-05, 1.13556e-04,
     &  8.72988e-05, 9.71052e-05, 9.31839e-05, 8.73745e-05,
     &  8.61717e-05, 6.05645e-05, 6.51131e-05, 6.93393e-05,
     &  7.01096e-05, 6.43565e-05, 7.36929e-05, 7.66881e-05,
     &  7.60815e-05, 7.13570e-05, 8.40487e-05, 8.51489e-05,
     &  7.54168e-05, 6.72694e-05, 4.75508e-05, 3.59379e-05/
      data s2(501:600)/
     &  4.24698e-05, 4.17850e-05, 4.56047e-05, 4.12779e-05,
     &  4.55933e-05, 4.27941e-05, 4.42230e-05, 3.68525e-05,
     &  3.83392e-05, 3.83722e-05, 4.64904e-05, 3.33878e-05,
     &  3.53027e-05, 3.54694e-05, 2.36233e-05, 2.99641e-05,
     &  2.56097e-05, 2.14134e-05, 2.74403e-05, 2.83896e-05,
     &  3.17082e-05, 1.75526e-05, 2.80382e-05, 3.18009e-05,
     &  4.08715e-05, 4.77807e-05, 5.00609e-05, 5.12459e-05,
     &  4.44062e-05, 4.74942e-05, 4.99882e-05, 5.18837e-05,
     &  5.03246e-05, 5.55168e-05, 5.35853e-05, 4.81834e-05,
     &  6.66231e-05, 5.26670e-05, 6.84700e-05, 6.53412e-05,
     &  5.71740e-05, 4.61076e-05, 3.90239e-05, 4.72924e-05,
     &  6.32194e-05, 5.20868e-05, 4.81039e-05, 3.71748e-05,
     &  4.37492e-05, 3.63959e-05, 3.79823e-05, 3.72225e-05,
     &  3.02360e-05, 3.22961e-05, 3.43398e-05, 3.57176e-05,
     &  2.65446e-05, 3.29388e-05, 1.65455e-05, 2.66173e-05,
     &  1.74277e-05, 1.74324e-05, 1.27879e-05, 1.46247e-05,
     &  1.92378e-05, 2.20049e-05, 1.44790e-05, 2.49244e-05,
     &  2.29209e-05, 1.76192e-05, 1.84528e-05, 2.54350e-05,
     &  3.33972e-05, 3.69190e-05, 2.92139e-05, 2.47666e-05,
     &  2.86764e-05, 1.48163e-05, 1.80461e-05, 2.84545e-05,
     &  2.41064e-05, 2.85721e-05, 3.31996e-05, 3.75973e-05,
     &  3.73874e-05, 4.69293e-05, 5.12665e-05, 5.35607e-05,
     &  4.64577e-05, 3.59887e-05, 3.39168e-05, 3.89746e-05,
     &  3.12196e-05, 3.70907e-05, 3.95172e-05, 4.61642e-05,
     &  4.26029e-05, 4.17856e-05, 4.51437e-05, 4.04189e-05/
      data s2(601:700)/
     &  4.19251e-05, 4.53977e-05, 3.69860e-05, 4.20904e-05,
     &  3.69735e-05, 3.57898e-05, 3.47729e-05, 3.14280e-05,
     &  2.71197e-05, 3.34380e-05, 2.69843e-05, 2.88036e-05,
     &  2.51912e-05, 2.45699e-05, 2.23184e-05, 2.50563e-05,
     &  2.24493e-05, 1.77101e-05, 1.64763e-05, 1.34978e-05,
     &  1.57081e-05, 1.45966e-05, 1.02722e-05, 2.07177e-05,
     &  1.47662e-05, 1.50721e-05, 1.24431e-05, 1.51572e-05,
     &  1.92210e-05, 2.06047e-05, 2.02921e-05, 3.22062e-05,
     &  2.37112e-05, 1.94803e-05, 2.40726e-05, 2.11531e-05,
     &  1.89158e-05, 2.46957e-05, 2.63175e-05, 2.57747e-05,
     &  2.22047e-05, 2.52755e-05, 2.80848e-05, 3.75157e-05,
     &  4.09915e-05, 4.04853e-05, 3.21661e-05, 3.15652e-05,
     &  3.21576e-05, 3.67060e-05, 3.13071e-05, 2.84939e-05,
     &  2.71169e-05, 2.99559e-05, 2.94631e-05, 3.26716e-05,
     &  2.99028e-05, 2.60045e-05, 3.15375e-05, 3.12895e-05,
     &  2.77767e-05, 2.43976e-05, 2.10764e-05, 2.22725e-05,
     &  2.04581e-05, 1.63509e-05, 1.60028e-05, 1.60294e-05,
     &  1.62366e-05, 1.89293e-05, 1.79675e-05, 1.89259e-05,
     &  1.68300e-05, 1.99460e-05, 2.42370e-05, 2.64738e-05,
     &  1.93137e-05, 1.39460e-05, 1.32222e-05, 1.38752e-05,
     &  1.62071e-05, 1.79652e-05, 1.63772e-05, 1.56251e-05,
     &  1.81918e-05, 1.46111e-05, 2.92174e-05, 2.94263e-05,
     &  2.46180e-05, 2.93333e-05, 3.13657e-05, 2.97686e-05,
     &  2.78387e-05, 2.40924e-05, 2.93369e-05, 2.93747e-05,
     &  2.77665e-05, 3.00814e-05, 3.01068e-05, 3.62275e-05/
      data s2(701:800)/
     &  3.56613e-05, 3.66913e-05, 3.56280e-05, 3.52856e-05,
     &  3.63928e-05, 2.96738e-05, 2.90314e-05, 2.62972e-05,
     &  2.15250e-05, 1.97910e-05, 2.02314e-05, 2.20209e-05,
     &  2.05131e-05, 2.12017e-05, 1.96689e-05, 1.61907e-05,
     &  1.57662e-05, 1.58239e-05, 1.54650e-05, 1.46376e-05,
     &  1.32891e-05, 1.30511e-05, 1.17635e-05, 1.28585e-05,
     &  1.12887e-05, 1.32627e-05, 1.31833e-05, 1.68679e-05,
     &  1.98092e-05, 2.70744e-05, 2.22033e-05, 1.63430e-05,
     &  1.61104e-05, 1.50865e-05, 1.54382e-05, 1.55654e-05,
     &  1.67924e-05, 1.89185e-05, 1.96791e-05, 2.14894e-05,
     &  2.76137e-05, 2.67339e-05, 2.79423e-05, 2.54664e-05,
     &  3.10707e-05, 2.72745e-05, 2.60940e-05, 2.47736e-05,
     &  2.21105e-05, 2.20357e-05, 2.26499e-05, 2.34137e-05,
     &  2.29537e-05, 2.36157e-05, 2.48244e-05, 2.26667e-05,
     &  2.07781e-05, 2.11702e-05, 1.91214e-05, 1.62172e-05,
     &  1.61285e-05, 1.63952e-05, 1.68156e-05, 1.61236e-05,
     &  1.56611e-05, 1.47697e-05, 1.50856e-05, 1.44169e-05,
     &  1.63816e-05, 1.74283e-05, 1.49853e-05, 1.62444e-05,
     &  1.70007e-05, 1.60371e-05, 1.22713e-05, 1.45518e-05,
     &  1.35051e-05, 1.40787e-05,-1.54925e-05,-2.15204e-05,
     & -4.04516e-06, 2.22439e-05, 3.21262e-05, 3.83792e-05,
     &  4.44462e-05, 4.44192e-05, 2.77328e-05, 4.10549e-06,
     &  4.48758e-06,-1.27771e-05,-2.17204e-05,-1.23979e-05,
     & -1.04928e-05, 7.43085e-06, 1.55350e-05, 3.15204e-05,
     &  3.17601e-05, 2.93677e-05, 3.42485e-05, 3.87087e-05/
      data s2(801:900)/
     &  3.61242e-05, 2.62406e-05, 3.31686e-05, 3.54314e-05,
     &  2.50625e-05, 2.60444e-05, 4.10729e-05, 3.47247e-05,
     &  3.31716e-05, 3.34778e-05, 4.03029e-05, 4.09241e-05,
     &  3.96717e-05, 3.53410e-05, 2.81048e-05, 1.98891e-05,
     &  1.92314e-05, 2.82525e-05, 3.76641e-05, 4.34135e-05,
     &  4.24570e-05, 3.98429e-05, 3.29417e-05, 2.16679e-05,
     &  8.88085e-06,-5.05319e-06,-8.14815e-06,-5.01930e-06,
     &  7.13565e-06, 2.00949e-05, 2.65988e-05, 2.77656e-05,
     &  2.09299e-05, 1.98968e-05, 2.04835e-05, 1.75254e-05,
     &  6.48674e-06, 3.14323e-06, 1.93242e-06, 3.86745e-06,
     &  1.39727e-05, 2.10731e-05, 2.66432e-05, 2.69551e-05,
     &  2.57453e-05, 2.72834e-05, 2.58860e-05, 2.51266e-05,
     &  1.76048e-05, 2.03072e-05, 2.61960e-05, 2.36230e-05,
     &  1.81172e-05, 1.33972e-05, 1.60959e-05, 1.61081e-05,
     &  2.34099e-05, 2.64979e-05, 2.36894e-05, 2.13665e-05,
     &  2.16774e-05, 2.52566e-05, 1.99785e-05, 1.40414e-05,
     &  1.39948e-05, 1.32637e-05, 7.24742e-06, 1.11395e-06,
     & -1.27323e-06, 4.56637e-07, 6.93250e-06, 5.07198e-06,
     &  7.90632e-06, 9.08149e-06, 1.03602e-05, 2.17425e-05,
     &  2.71741e-05, 2.16875e-05, 1.95088e-05, 1.56568e-05,
     &  8.41152e-06, 1.26749e-05, 1.17673e-05, 9.96037e-06,
     &  1.21982e-05, 1.31854e-05, 1.50216e-05, 1.72214e-05,
     &  2.02773e-05, 2.09625e-05, 1.66656e-05, 1.45666e-05,
     &  1.66608e-05, 2.04989e-05, 2.21395e-05, 2.35993e-05,
     &  2.69390e-05, 2.13921e-05, 1.72643e-05, 1.70995e-05/
      data s2(901:1000)/
     &  1.78241e-05, 1.85308e-05, 1.80360e-05, 1.48619e-05,
     &  1.90369e-05, 1.51089e-05, 1.22705e-05, 1.62608e-05,
     &  1.41637e-05, 1.23786e-05, 7.02677e-06, 8.89811e-06,
     &  1.07379e-05, 1.23677e-05, 1.48196e-05, 2.05770e-05,
     &  1.70994e-05, 1.00072e-05, 1.76119e-05, 1.41779e-05,
     &  1.34358e-05, 1.58674e-05, 1.65837e-05, 1.69569e-05,
     &  1.40381e-05, 1.46118e-05, 1.30556e-05, 1.97204e-05,
     &  1.97488e-05, 1.64524e-05, 1.73764e-05, 1.66355e-05,
     &  1.64419e-05, 1.65486e-05, 1.21523e-05, 1.51513e-05,
     &  1.60354e-05, 1.38528e-05, 1.45538e-05, 1.71702e-05,
     &  1.56336e-05, 1.31279e-05, 1.47346e-05, 1.70719e-05,
     &  1.75588e-05, 1.55187e-05, 1.29598e-05, 1.38463e-05,
     &  1.35382e-05, 1.16062e-05, 1.37014e-05, 1.34487e-05,
     &  1.15536e-05, 1.33597e-05, 9.24478e-06, 7.28477e-06,
     &  1.40321e-05, 1.31518e-05, 1.03118e-05, 8.59764e-06,
     &  1.57138e-05, 1.20792e-05, 1.49440e-05, 1.34375e-05,
     &  1.54686e-05, 1.65346e-05, 1.33823e-05, 1.37238e-05,
     &  1.36128e-05, 1.46206e-05, 1.40777e-05, 1.59980e-05,
     &  1.30180e-05, 1.01390e-05, 1.12366e-05, 9.86099e-06,
     &  1.10702e-05, 1.26783e-05, 9.51072e-06, 8.07299e-06,
     &  1.22955e-05, 1.53506e-05, 1.29711e-05, 9.78759e-06,
     &  1.28800e-05, 1.39702e-05, 1.64832e-05, 1.06473e-05,
     &  1.15419e-05, 1.63795e-05, 1.69837e-05, 1.72726e-05,
     &  1.77231e-05, 1.62337e-05, 1.20881e-05, 1.13210e-05,
     &  1.20531e-05, 1.31374e-05, 1.22259e-05, 1.27802e-05/
      data s2(1001:1100)/
     &  1.38962e-05, 8.87355e-06, 9.42264e-06, 1.02075e-05,
     &  7.91816e-06, 9.66835e-06, 1.24921e-05, 8.43227e-06,
     &  1.10637e-05, 1.03958e-05, 9.40996e-06, 1.22922e-05,
     &  1.21088e-05, 1.30116e-05, 1.18776e-05, 1.42245e-05,
     &  1.34745e-05, 1.11165e-05, 1.29914e-05, 1.29801e-05,
     &  1.10895e-05, 1.12331e-05, 9.03490e-06, 9.33726e-06,
     &  9.63923e-06, 1.11299e-05, 9.53481e-06, 1.21708e-05,
     &  1.11951e-05, 7.22558e-06, 6.66928e-06, 1.08926e-05,
     &  1.07870e-05, 9.23485e-06, 8.50452e-06, 9.41914e-06,
     &  8.74027e-06, 8.93322e-06, 9.79061e-06, 8.26490e-06,
     &  8.37630e-06, 1.17064e-05, 1.10176e-05, 1.11587e-05,
     &  9.45563e-06, 1.18352e-05, 7.79327e-06, 9.22766e-06,
     &  1.01868e-05, 8.23925e-06, 9.23706e-06, 1.04428e-05,
     &  8.80392e-06, 9.37098e-06, 7.43126e-06, 7.01424e-06,
     &  9.29360e-06, 8.97171e-06, 9.31718e-06, 9.87118e-06,
     &  8.11419e-06, 8.77416e-06, 9.96927e-06, 8.87533e-06,
     &  9.33163e-06, 7.41505e-06, 9.39988e-06, 1.17932e-05,
     &  1.03287e-05, 9.17415e-06, 8.43035e-06, 8.00040e-06,
     &  8.33346e-06, 7.66787e-06, 7.18411e-06, 1.06236e-05,
     &  1.05559e-05, 8.49187e-06, 9.22472e-06, 8.16512e-06,
     &  8.35687e-06, 1.06325e-05, 9.80273e-06, 9.01599e-06,
     &  9.20499e-06, 9.98417e-06, 9.23191e-06, 6.98769e-06,
     &  5.17748e-06, 4.57130e-06, 8.18492e-06, 9.98095e-06,
     &  7.52148e-06, 1.33038e-05, 8.17630e-06, 1.02454e-05,
     &  9.62706e-06, 9.44304e-06, 8.86704e-06, 8.88116e-06/
      data s2(1101:1200)/
     &  8.79062e-06, 8.20042e-06, 8.55789e-06, 9.26249e-06,
     &  1.00467e-05, 7.96012e-06, 9.08773e-06, 1.01481e-05,
     &  8.84360e-06, 7.94928e-06, 6.68425e-06, 8.56576e-06,
     &  1.05282e-05, 1.10647e-05, 9.91625e-06, 7.95356e-06,
     &  8.66443e-06, 9.13551e-06, 1.04870e-05, 9.79244e-06,
     &  1.26214e-05, 8.42148e-06, 8.13468e-06, 1.11338e-05,
     &  1.06780e-05, 8.54578e-06, 7.82119e-06, 8.33258e-06,
     &  8.23644e-06, 5.95583e-06, 5.85592e-06, 4.05898e-06,
     &  6.39260e-06, 8.43280e-06, 8.76251e-06, 6.70423e-06,
     &  6.81368e-06, 7.43506e-06, 7.14376e-06, 6.51065e-06,
     &  5.65633e-06, 5.42394e-06, 7.10817e-06, 4.78831e-06,
     &  6.29380e-06, 4.87344e-06, 6.81764e-06, 6.51611e-06,
     &  5.70526e-06, 6.50590e-06, 6.61568e-06, 5.39248e-06,
     &  6.32002e-06, 7.98976e-06, 7.73795e-06, 4.85788e-06,
     &  5.83443e-06, 6.11694e-06, 5.40408e-06, 5.00946e-06,
     &  5.62153e-06, 6.30263e-06, 6.05764e-06, 5.53274e-06,
     &  5.80664e-06, 5.18684e-06, 6.85555e-06, 6.22889e-06,
     &  6.06959e-06, 6.49228e-06, 5.64064e-06, 4.92690e-06,
     &  5.77661e-06, 7.18450e-06, 7.38658e-06, 6.77379e-06,
     &  5.74668e-06, 6.68355e-06, 6.13655e-06, 6.43266e-06,
     &  7.08896e-06, 7.71187e-06, 7.37273e-06, 6.75882e-06,
     &  6.39307e-06, 4.59520e-06, 5.10323e-06, 5.80178e-06,
     &  6.88172e-06, 6.68825e-06, 7.50416e-06, 6.14975e-06,
     &  6.51422e-06, 7.74942e-06, 8.11492e-06, 1.19607e-05,
     &  7.92722e-06, 4.47848e-06, 6.02524e-06, 9.74067e-06/
      data s2(1201:1300)/
     &  1.02429e-05, 8.60819e-06, 8.57044e-06, 1.09196e-05,
     &  1.02048e-05, 3.86222e-06, 9.26104e-06, 7.33341e-06,
     &  9.08181e-06, 1.05569e-05, 1.06776e-05, 1.10247e-05,
     &  1.04520e-05, 8.78328e-06, 7.60679e-06, 7.27896e-06,
     &  9.72776e-06, 5.16039e-06, 1.03134e-05, 1.09088e-05,
     &  8.12575e-06, 7.61685e-06, 8.16346e-06, 5.91269e-06,
     &  3.61448e-06, 8.74336e-06, 1.03990e-05, 6.25691e-06,
     &  7.04541e-06, 7.94348e-06, 8.39807e-06, 8.67342e-06,
     &  8.32173e-06, 7.56015e-06, 8.31782e-06, 6.36556e-06,
     &  6.99328e-06, 6.24490e-06, 6.73080e-06, 6.95852e-06,
     &  7.55508e-06, 7.74168e-06, 7.90414e-06, 8.94934e-06,
     &  7.99809e-06, 6.12528e-06, 9.04115e-06, 7.14535e-06,
     &  5.88625e-06, 6.43941e-06, 7.11566e-06, 7.47425e-06,
     &  8.23805e-06, 6.19919e-06, 7.31614e-06, 8.24852e-06,
     &  6.82172e-06, 5.45362e-06, 6.66115e-06, 8.44300e-06,
     &  8.07530e-06, 7.22735e-06, 5.85614e-06, 5.13900e-06,
     &  6.03215e-06, 6.59491e-06, 4.81592e-06, 4.48587e-06,
     &  7.11525e-06, 8.36201e-06, 7.11669e-06, 2.80033e-06,
     &  6.50756e-06, 9.43974e-06, 5.22402e-06, 3.82334e-06,
     &  7.29963e-06, 8.62313e-06, 7.42018e-06, 4.56506e-06,
     &  5.29972e-06, 5.62787e-06, 4.63852e-06, 5.18329e-06,
     &  7.01884e-06, 7.24888e-06, 5.18157e-06, 5.40219e-06,
     &  5.92412e-06, 4.97977e-06, 5.29040e-06, 5.33812e-06,
     &  4.76620e-06, 4.65759e-06, 5.10546e-06, 6.49525e-06,
     &  4.43416e-06, 5.30223e-06, 3.27044e-06, 2.55324e-06/
      data s2(1301:1400)/
     &  4.85017e-06, 7.46556e-06, 8.04448e-06, 5.14009e-06,
     &  6.09755e-06, 5.38381e-06, 6.41959e-06, 6.59233e-06,
     &  4.83160e-06, 3.81289e-06, 5.37013e-06, 5.69212e-06,
     &  5.54983e-06, 5.73495e-06, 4.00639e-06, 2.33817e-06,
     &  2.55751e-06, 3.29627e-06, 3.59845e-06, 6.20623e-06,
     &  4.47088e-06, 3.49267e-06, 3.09273e-06, 3.32506e-06,
     &  4.83353e-06, 6.39001e-06, 3.78074e-06, 4.07848e-06,
     &  4.01811e-06, 3.19767e-06, 3.34053e-06, 4.34246e-06,
     &  3.68003e-06, 3.01090e-06, 3.98545e-06, 2.72338e-06,
     &  1.90024e-06, 2.77553e-06, 3.73381e-06, 2.58685e-06,
     &  1.70987e-06,-5.48480e-07, 1.64591e-06, 2.43481e-06,
     &  2.52116e-06, 2.19316e-06, 1.32392e-06, 1.75370e-06,
     &  2.65409e-07, 2.22278e-06, 2.53079e-06, 2.87260e-06,
     &  1.87600e-06,-3.84453e-07, 1.80836e-06, 9.28123e-07,
     &  1.94986e-06, 2.40483e-06, 2.79865e-06, 2.86361e-06,
     &  2.63868e-06, 3.34704e-06, 3.32132e-06, 2.58463e-06,
     &  2.45684e-06, 3.35043e-06, 3.19848e-06, 1.73037e-06,
     &  2.98206e-06, 2.77491e-06, 6.51674e-07, 2.52219e-06,
     &  2.97136e-06, 1.96700e-06, 2.29350e-06, 3.01956e-06,
     &  3.20811e-06, 1.30467e-06, 1.68172e-06, 2.56264e-06,
     &  2.46167e-06, 1.78221e-06, 2.31647e-06, 2.69480e-06,
     &  2.63619e-06, 1.81319e-06, 1.83448e-06, 2.23432e-06,
     &  8.14045e-07, 8.75863e-07, 1.61350e-06, 1.59796e-06,
     &  2.08419e-06, 1.89665e-06, 6.93584e-07, 1.09880e-06,
     &  3.79031e-07,-3.36470e-07, 1.04326e-06, 1.06497e-06/
      data s2(1401:1500)/
     &  2.15108e-07, 3.28774e-07,-5.17613e-07, 1.27762e-06,
     &  8.22924e-07, 4.92835e-07, 2.24698e-08,-1.99111e-07,
     &  1.30262e-06,-3.81299e-07, 9.55084e-07, 2.17641e-07,
     & -6.03874e-08, 8.44121e-07, 1.72391e-06, 1.66921e-06,
     &  2.19855e-06, 1.17655e-06, 1.79637e-06, 3.31670e-06,
     &  3.40206e-06, 6.05670e-07, 2.08299e-06, 2.10121e-06,
     &  1.68598e-06, 2.21155e-06, 2.43221e-06, 5.81282e-08,
     &  1.62613e-06,-5.49850e-07, 2.14143e-07, 1.21751e-06,
     &  2.30470e-06, 4.27911e-06, 2.96622e-06, 8.67534e-07,
     &  9.12041e-07, 2.48797e-06, 9.43519e-07,-3.60949e-06,
     &  2.01928e-06, 1.88873e-06, 8.06749e-07, 7.33519e-07,
     &  1.17440e-06, 1.69744e-06, 3.64492e-06, 3.11556e-06,
     &  8.89471e-07, 1.93064e-06, 3.02787e-06, 1.92575e-06,
     &  1.73720e-06,-1.32700e-07, 1.41743e-06, 2.24632e-06,
     &  2.47945e-06, 2.05151e-06,-9.56031e-07, 2.57317e-07,
     &  3.00980e-06, 3.07981e-06, 2.78202e-06, 3.02555e-06,
     &  5.48784e-09, 2.37693e-06, 2.90011e-06, 2.93608e-06,
     &  2.14837e-06, 6.55832e-07, 3.41155e-07,-2.13884e-06,
     &  2.52553e-06, 4.27109e-06, 3.33766e-06, 3.07708e-06,
     &  2.66405e-06, 3.22850e-06,-5.78879e-07,-6.06194e-07,
     &  1.72864e-06, 1.57072e-06,-3.39701e-07, 7.21540e-08,
     &  1.67012e-06, 2.48568e-06, 2.70214e-06, 3.62383e-06,
     &  2.20408e-06, 1.19395e-06, 1.53825e-06, 2.37511e-06,
     &  2.66754e-06, 1.77020e-06, 5.40420e-07, 2.01156e-06,
     &  3.27498e-06, 3.04720e-06, 1.96213e-06, 3.71633e-06/
      data s2(1501:1600)/
     &  2.07886e-06, 1.60069e-06, 5.33370e-07, 1.33966e-07,
     &  2.16073e-06, 8.81457e-07, 1.12880e-06, 2.40509e-06,
     &  2.94252e-06, 2.22899e-06, 1.80941e-06, 2.68577e-06,
     &  2.44584e-06, 2.51720e-06, 2.64857e-06, 2.24182e-06,
     &  1.62007e-06, 2.60421e-06, 3.09782e-06, 3.11099e-06,
     &  3.81513e-06, 6.91606e-06, 3.28767e-06, 3.44175e-06,
     &  4.16771e-06, 3.75452e-06, 2.21050e-06, 2.99939e-06,
     &  2.86993e-06, 2.47080e-06, 2.33607e-06, 2.68568e-06,
     &  3.39344e-06, 6.09518e-06, 5.10422e-06, 4.04027e-06,
     &  4.01363e-06, 4.53142e-06, 2.94424e-06, 4.76694e-06,
     &  6.44206e-06, 7.86435e-06, 8.55564e-06, 6.00857e-06,
     &  5.48073e-06, 1.56287e-06,-1.16619e-06,-1.85215e-06,
     & -3.04762e-06,-3.45420e-07, 2.48111e-07,-1.39302e-07,
     & -6.27593e-07,-5.26792e-07, 4.81454e-08,-3.08631e-08,
     & -1.02976e-06,-1.54919e-06,-9.34044e-07,-1.02507e-06,
     & -1.39794e-06,-1.15709e-06,-1.04875e-06,-1.64379e-06,
     & -2.97514e-06,-3.22236e-07,-1.18978e-06,-2.85325e-06,
     & -3.93143e-06,-4.15349e-06,-2.33228e-06,-3.27125e-06,
     & -2.44987e-06,-1.44460e-06,-3.59727e-06,-7.18516e-07,
     & -1.53237e-06,-1.53526e-06,-1.56450e-06,-2.91088e-06,
     & -8.52134e-07,-1.44575e-07,-1.50350e-06,-2.92806e-06,
     & -2.47710e-06,-9.71202e-07,-9.82754e-07,-1.09924e-06,
     & -6.08199e-07, 3.62885e-07,-6.67372e-07,-1.00033e-06,
     & -1.12001e-06,-1.06624e-06,-9.23789e-07,-9.83788e-07,
     & -2.11656e-06,-2.45001e-06,-2.75874e-06,-3.36003e-06/
      data s2(1601:1700)/
     & -3.38364e-06,-2.63747e-06,-3.11047e-06,-3.75258e-06,
     & -3.83211e-06,-3.52833e-06,-3.48464e-06,-3.77021e-06,
     & -4.26887e-06,-4.23917e-06,-1.42438e-06,-2.48477e-06,
     & -2.84719e-06,-2.70247e-06,-2.50588e-06,-2.22900e-06,
     & -1.78393e-06,-1.76826e-06,-2.16396e-06,-2.67543e-06,
     & -2.23706e-06,-2.31793e-06,-2.87590e-06,-3.07803e-06,
     & -2.50493e-06,-4.54223e-06,-5.15511e-06,-5.39690e-06,
     & -4.89633e-06,-3.33710e-06,-4.56583e-06,-4.78877e-06,
     & -3.93508e-06,-3.29027e-06,-4.95668e-06,-6.01801e-06,
     & -5.76016e-06,-5.34657e-06,-5.29080e-06,-5.57133e-06,
     & -5.73135e-06,-5.39374e-06,-5.09808e-06,-5.12874e-06,
     & -5.20269e-06,-7.30702e-06,-7.04220e-06,-5.96514e-06,
     & -5.74802e-06,-4.53961e-06,-4.42127e-06,-4.63922e-06,
     & -4.80622e-06,-4.69659e-06,-5.96786e-06,-6.29800e-06,
     & -4.75452e-06,-2.85907e-06,-5.33662e-06,-5.31681e-06,
     & -5.04646e-06,-5.21729e-06,-5.93409e-06,-5.73462e-06,
     & -5.44926e-06,-6.43325e-06,-7.74451e-06,-7.83147e-06,
     & -5.51568e-06,-7.37048e-06,-4.25726e-06, 2.32917e-06,
     & -5.61131e-07, 2.05234e-06, 3.74631e-07,-7.66493e-07,
     &  1.42689e-06,-7.79683e-07, 9.06809e-07, 5.13642e-07,
     & -1.52504e-06,-2.12058e-06,-2.50316e-06, 1.03637e-08,
     &  5.60002e-07,-1.48075e-06, 1.94155e-06, 1.91846e-06,
     &  2.78507e-06, 3.90146e-06, 3.61409e-06, 3.23677e-06,
     &  4.00022e-06, 3.19157e-06, 4.03034e-07,-2.03929e-06,
     &  1.23366e-06, 3.28589e-06, 3.94168e-06, 3.94672e-06/
      data s2(1701:1800)/
     &  3.84619e-06, 2.30400e-07,-2.07799e-06,-1.75115e-06,
     & -5.71958e-07, 2.33425e-06, 2.01664e-06, 6.05673e-07,
     &  9.57363e-07,-8.89924e-07,-4.71331e-07, 2.82826e-07,
     &  5.10859e-07, 3.63512e-07, 9.86288e-07,-4.86309e-07,
     & -2.23163e-06,-1.23370e-06,-2.43131e-07,-2.11498e-06,
     & -1.56756e-06, 2.70905e-06, 1.87606e-08, 7.83721e-08,
     &  1.58444e-06, 2.88574e-06, 1.40306e-06, 2.40883e-06,
     &  2.84063e-06, 3.13820e-06, 3.71016e-06, 3.12975e-06,
     &  3.21981e-06, 2.56191e-06, 1.04624e-06, 1.87464e-07,
     &  7.25329e-07, 1.03650e-06, 7.23663e-07,-4.18739e-07,
     &  9.95744e-07,-1.80878e-07,-1.04044e-06, 3.86965e-07,
     & -9.36186e-07,-4.02271e-07,-2.00231e-07,-5.94965e-07,
     &  4.94038e-07, 3.34585e-07, 4.82255e-07, 1.12599e-06,
     &  2.11763e-06, 2.66807e-07, 2.29324e-07, 7.07005e-07,
     &  3.41907e-07,-1.17115e-07, 9.03089e-07, 1.76844e-06,
     &  1.87134e-06, 2.64057e-06, 4.00395e-07,-4.19679e-07,
     &  6.30769e-07, 1.02725e-06, 1.05876e-06,-4.08660e-07,
     & -2.32668e-06,-2.73468e-06,-2.40600e-06,-1.81203e-06,
     & -7.96431e-07, 7.40789e-07, 2.73188e-07, 1.68367e-07,
     & -1.27227e-07,-1.05041e-06,-3.51726e-06,-1.64956e-06,
     & -5.63840e-07,-1.61242e-06,-1.33264e-06, 1.56604e-06,
     &  2.35083e-06, 9.26708e-07, 5.41983e-07, 3.54277e-07,
     &  8.53743e-07, 1.54196e-06, 1.19902e-06, 1.10552e-06,
     &  1.63179e-06, 1.96366e-06, 7.82848e-07,-3.34741e-08,
     & -7.90842e-07,-6.45131e-07, 1.36158e-06, 1.62453e-06/
      data s2(1801:1900)/
     &  6.68965e-07,-4.86203e-08, 6.83561e-07, 1.89652e-06,
     & -2.80988e-07,-2.30536e-06,-1.90777e-06, 1.31617e-06,
     &  1.27309e-06, 5.90825e-07, 5.65686e-07, 1.23631e-07,
     & -1.70279e-06,-1.60768e-06, 9.69543e-07, 1.01108e-07,
     & -2.02473e-06,-1.75146e-06, 6.33201e-07,-3.59110e-06,
     & -9.71706e-07, 9.16822e-07, 1.40681e-07,-7.16745e-07,
     & -2.11376e-06,-1.00951e-06, 2.12465e-06, 1.06982e-06,
     &  1.44032e-06, 1.49692e-06, 1.07277e-06, 1.37006e-06,
     &  1.66932e-06, 1.75820e-06, 1.41859e-06,-5.84947e-08,
     &  2.17349e-06, 4.27053e-06, 5.27286e-06, 5.87085e-06,
     &  2.42692e-06, 2.39305e-06, 6.19573e-06, 5.12518e-06,
     &  1.27171e-06,-6.81963e-07, 4.16199e-08,-1.36608e-06,
     & -2.53272e-06,-2.37700e-06,-7.96719e-07, 3.85367e-07,
     & -1.08393e-07,-9.04587e-07,-1.54917e-06,-3.11945e-06,
     & -5.58484e-07, 1.61347e-06, 1.11736e-06, 2.11889e-06,
     &  2.43534e-06, 1.46709e-06,-1.05429e-06, 1.09978e-06,
     &  7.22493e-07, 8.53307e-08, 1.22733e-06, 2.99380e-06,
     &  3.62416e-06, 3.81404e-06, 4.46735e-06, 4.70753e-06,
     &  4.54494e-06, 3.83002e-06, 2.28067e-06, 2.03102e-06,
     &  2.43844e-06, 2.93132e-06, 2.17555e-06, 3.92919e-06,
     &  3.53089e-06, 1.61388e-06, 5.09498e-06, 3.40067e-06,
     &  1.58876e-06, 1.17367e-06, 1.13344e-06, 1.17798e-06,
     &  1.10976e-06, 7.90635e-07,-4.15989e-07,-1.00581e-06,
     & -9.60236e-07,-1.79111e-07,-5.70733e-07, 1.49766e-06,
     &  3.44374e-06, 6.45914e-07, 1.00532e-06, 2.01068e-06/
      data s2(1901:2000)/
     &  2.59092e-06, 9.35770e-08, 6.00121e-07, 1.54409e-06,
     &  2.03537e-06, 8.10358e-07, 1.34126e-06, 1.88873e-06,
     &  1.43283e-06,-2.05029e-07,-1.09782e-06,-6.56149e-07,
     &  2.01650e-06, 1.84770e-06, 4.39586e-08,-2.03588e-06,
     & -1.46366e-06,-3.45189e-07, 4.02577e-07, 3.10362e-07,
     & -2.16073e-06,-1.91861e-06,-2.90520e-07, 2.03692e-06,
     &  3.47996e-06, 4.21761e-06, 3.89000e-06, 1.86138e-06,
     &  1.56143e-06, 4.88964e-07,-9.28184e-07,-4.34315e-07,
     &  8.74954e-07, 1.58417e-06, 1.36880e-06, 2.65016e-06,
     &  4.62623e-06, 5.81990e-06, 4.72139e-06, 1.95905e-06,
     &  1.54151e-06, 2.95768e-06, 4.71536e-06, 2.62359e-06,
     &  9.11513e-07, 4.75677e-07,-1.53801e-06,-2.32382e-06,
     & -2.25220e-06,-1.46641e-06,-2.23014e-06,-2.12604e-06,
     & -1.66259e-06,-2.48856e-06,-2.38895e-06,-2.18158e-06,
     & -1.95841e-06, 4.43899e-07, 1.08517e-06, 1.66370e-07,
     & -2.42342e-06,-7.19331e-07, 3.19532e-07, 3.58690e-07,
     & -2.01979e-07, 5.07242e-07, 1.10562e-06, 1.00419e-06,
     &  1.22379e-06, 7.05180e-07, 1.42283e-07, 8.61092e-07,
     &  8.95236e-07, 1.18043e-07,-1.23589e-06,-6.16316e-07,
     & -1.18947e-06,-1.45838e-06,-1.47522e-09, 1.33867e-06,
     &  9.18310e-07,-8.98949e-07,-2.27314e-06,-1.71510e-06,
     & -7.16704e-07, 8.60666e-09, 5.68015e-07, 1.31219e-06,
     &  1.75478e-06, 5.11790e-07, 3.35270e-07, 5.39243e-07,
     &  9.08467e-07, 1.39382e-06, 1.08806e-06, 1.18589e-06,
     &  3.58461e-06, 2.78668e-06, 1.25964e-06,-2.72255e-07/
      data s2(2001:2100)/
     &  1.72305e-06, 1.82937e-06, 7.46252e-07,-1.10555e-06,
     &  2.24967e-07, 6.45674e-07,-1.87591e-07,-8.84068e-07,
     & -1.75433e-06,-2.17670e-06,-1.37112e-06,-2.31722e-06,
     & -2.23860e-06,-1.16796e-06,-2.23765e-06,-1.86406e-06,
     & -1.03517e-06,-5.90824e-07,-6.57710e-07,-7.00941e-07,
     & -4.46064e-07, 1.77205e-06, 2.45066e-06, 2.39371e-06,
     &  2.30736e-06, 2.35355e-06, 1.85070e-06, 9.62711e-07,
     &  2.59644e-06, 2.05304e-06, 9.70090e-07, 1.50942e-06,
     &  3.79439e-06, 2.94597e-06,-1.91789e-06, 6.44324e-08,
     & -3.92094e-07,-1.55398e-06, 4.46701e-08,-4.78760e-07,
     & -1.70061e-06,-3.17252e-06,-2.93173e-06,-2.01455e-06,
     & -7.76298e-07,-2.74577e-07,-1.39907e-06,-2.16470e-06,
     & -1.26010e-06,-2.76845e-06,-2.38226e-06,-5.49068e-08,
     &  9.65258e-07, 1.08650e-06, 5.64738e-07,-5.78379e-07,
     & -5.68918e-07,-1.90177e-06,-5.08874e-06,-3.03648e-06,
     & -1.30527e-06,-4.87669e-07,-2.83326e-06,-1.97823e-06,
     & -5.94313e-07,-1.50961e-07,-1.15908e-06,-1.43260e-06,
     & -9.29331e-07,-1.39459e-06,-1.27237e-06,-1.50189e-06,
     & -3.79292e-06,-3.92038e-06,-3.58490e-06,-3.26439e-06,
     & -2.42138e-06,-2.70516e-06,-3.58080e-06,-1.71822e-06,
     & -2.41567e-06,-3.50193e-06,-2.62394e-06,-3.08424e-06,
     & -3.89604e-06,-4.84127e-06,-4.41385e-06,-3.22673e-06,
     & -1.80987e-06,-2.93027e-06,-3.17366e-06,-2.79721e-06,
     & -1.78848e-06,-2.80254e-06,-3.55572e-06,-3.34632e-06,
     & -2.83979e-06,-2.48022e-06,-2.15090e-06,-1.08311e-06/
      data s2(2101:2200)/
     & -6.15216e-07,-7.13008e-07,-1.70841e-06,-2.96098e-06,
     & -3.57134e-06,-3.04405e-06,-3.35280e-06,-2.97780e-06,
     & -1.97966e-06,-2.33197e-06,-2.76708e-06,-2.70409e-06,
     & -4.51094e-07,-1.43068e-06,-2.83719e-06,-2.98921e-06,
     & -4.14949e-06,-3.63780e-06,-8.10138e-07,-1.61597e-06,
     & -2.25394e-06,-2.58110e-06,-1.57781e-06,-1.71520e-06,
     & -2.30016e-06,-2.61268e-06,-1.96696e-06,-1.86744e-06,
     & -3.15645e-06,-3.59354e-06,-3.61015e-06,-3.21793e-06,
     & -2.57436e-06,-2.74347e-06,-3.33319e-06,-2.93400e-06,
     & -3.25986e-06,-3.46384e-06,-2.22114e-06,-2.92650e-06,
     & -3.73666e-06,-3.70485e-06,-2.75963e-06,-2.40652e-06,
     & -2.93107e-06,-1.77517e-06,-1.57096e-06,-2.17533e-06,
     & -2.80190e-06,-2.27942e-06,-1.37371e-06,-1.65974e-06,
     & -1.26079e-06,-8.08050e-07,-8.41278e-07,-1.53860e-06,
     & -1.66687e-06,-6.56592e-07,-3.05110e-08, 1.08623e-07,
     & -2.87222e-07,-2.63555e-07,-7.89575e-07,-1.56059e-06,
     & -6.42174e-07,-9.43333e-07,-1.38671e-06, 6.50443e-07,
     &  1.35301e-06, 9.27981e-07,-1.21705e-06,-9.63848e-08,
     &  8.73593e-07,-3.47278e-08,-1.79042e-06,-2.15544e-06,
     & -4.48668e-07,-1.17414e-06,-1.35437e-06,-8.90688e-07,
     & -4.54757e-07, 2.41484e-09, 3.88010e-07,-1.85349e-08,
     &  1.58011e-07, 3.70566e-07,-7.30268e-07,-8.42354e-07,
     & -4.13738e-07, 3.96796e-07,-5.55763e-07,-1.26877e-06,
     & -2.89854e-07, 5.78676e-07, 9.51356e-07, 5.56912e-07,
     &  1.05014e-06, 9.75896e-07, 5.91573e-08,-6.15073e-07/
      data s2(2201:2300)/
     & -1.48803e-06,-2.53397e-06,-1.77027e-06,-2.08546e-06,
     & -3.10452e-06,-1.65227e-06,-1.15981e-06,-1.25849e-06,
     & -9.65711e-07,-1.90319e-06,-2.71831e-06,-5.71559e-08,
     & -1.20368e-06,-3.16820e-06,-2.22766e-06,-1.19828e-06,
     & -2.82573e-07, 2.53850e-07,-9.10547e-07,-1.65529e-06,
     & -6.00138e-07,-4.98898e-07,-3.45799e-07, 2.25160e-07,
     &  1.14332e-07, 3.16082e-07, 1.12681e-06,-6.04876e-07,
     & -7.24616e-07, 1.48177e-06, 1.05680e-06, 5.91076e-07,
     &  2.07187e-07, 3.82385e-07, 5.91560e-07, 8.26519e-07,
     &  1.22139e-06, 1.63501e-06, 2.06423e-06, 2.50038e-06,
     &  2.38037e-06, 1.91688e-06, 2.46702e-06, 2.45066e-06,
     &  2.16732e-06, 3.13517e-06, 2.68221e-06, 1.39877e-06,
     &  8.58945e-07, 6.83181e-07, 8.46816e-07, 1.73491e-06,
     &  1.98732e-06, 1.94059e-06, 2.19284e-06, 1.73215e-06,
     &  1.06865e-06, 1.14117e-06, 1.43213e-06, 1.42275e-06,
     & -4.15449e-07,-2.39911e-07, 3.46498e-08,-2.75022e-06,
     & -2.43736e-06,-1.06489e-06,-7.81941e-07,-8.04801e-07,
     & -1.04984e-06,-1.65734e-06,-1.03167e-06,-3.18255e-08,
     &  5.70283e-07, 6.19050e-07, 2.92257e-07,-6.01436e-07,
     & -7.04005e-07,-3.70875e-07, 4.12830e-07, 1.31319e-07,
     & -1.61570e-07, 9.76170e-07, 7.99907e-07, 1.41860e-07,
     & -1.98022e-07, 3.13766e-07, 7.43982e-07,-6.11287e-07,
     & -5.21146e-07, 1.11156e-07, 3.91719e-07, 5.45566e-07,
     &  6.39059e-07, 7.29515e-07, 4.59167e-07, 6.13179e-08,
     & -3.48146e-08, 5.32046e-07, 1.19736e-06, 3.83982e-07/
      data s2(2301:2400)/
     &  1.73267e-07, 3.54304e-07, 9.34657e-07, 5.53819e-07,
     & -2.86678e-07, 2.01853e-08,-1.56159e-07,-6.08130e-07,
     & -2.14929e-07, 1.66317e-08, 9.32462e-08,-4.83623e-07,
     & -9.16323e-07,-1.22772e-06,-1.61586e-06,-1.27409e-06,
     & -1.98119e-07,-3.69182e-08,-1.41061e-07,-5.12562e-07,
     & -4.55495e-07,-8.12132e-07,-1.71772e-06,-2.70741e-06,
     & -2.98751e-06,-2.19520e-06, 3.01900e-07, 1.17806e-06,
     & -1.23067e-06, 4.17086e-07, 1.68113e-06, 4.81677e-07,
     & -1.55187e-07,-3.35287e-07, 2.94916e-07, 4.57124e-07,
     &  3.38692e-07,-2.49203e-07,-3.62585e-07,-2.39653e-07,
     &  3.72675e-08,-7.79964e-09,-2.83285e-07,-9.74713e-07,
     & -6.91171e-07, 1.21925e-07, 3.39940e-07, 3.68441e-08,
     & -5.82188e-07, 2.12605e-07, 4.65144e-07, 2.17190e-07,
     &  7.50119e-07, 8.62008e-07, 4.63016e-07, 1.25620e-06,
     &  1.04567e-06,-8.17037e-07,-1.20023e-06,-1.06224e-06,
     & -3.77100e-07,-1.28057e-07,-2.76183e-07,-1.24304e-06,
     & -2.56776e-06,-3.36699e-06,-1.49408e-06,-1.01189e-07,
     &  7.41870e-07,-6.45425e-07,-7.47111e-07, 4.79055e-10,
     & -1.32339e-06,-1.86135e-06,-1.61074e-06,-1.82039e-06,
     & -1.68040e-06,-1.08025e-06,-8.61965e-07,-7.00131e-07,
     & -5.63105e-07,-8.09843e-07,-8.09221e-07, 1.69474e-07,
     & -1.33941e-07,-7.49558e-07,-5.19013e-07,-8.53534e-07,
     & -1.33703e-06,-3.11161e-07, 8.99037e-07, 2.25330e-06,
     &  1.44822e-06, 3.07437e-07,-1.22366e-06,-7.64217e-07,
     &  2.13156e-08, 1.07909e-06, 6.10755e-07, 1.81483e-07/
      data s2(2401:2500)/
     &  8.12405e-07,-9.13283e-08,-1.35885e-06,-1.58366e-06,
     & -7.88594e-07, 4.48283e-07,-1.23754e-06,-1.65105e-06,
     & -8.93014e-07,-1.48622e-06,-1.67948e-06,-1.24310e-06,
     & -1.54411e-06,-1.65677e-06,-1.04998e-06,-1.46985e-07,
     &  4.61778e-07,-4.87832e-07,-4.89452e-07,-1.24840e-07,
     & -1.70101e-06,-1.66976e-06,-1.48528e-07,-1.12621e-07,
     & -2.30607e-08, 1.82301e-07,-8.58152e-07,-1.89794e-06,
     & -2.46464e-06,-2.32745e-06,-2.02112e-06,-2.07656e-06,
     & -1.43824e-06,-5.16583e-07,-1.80702e-06,-2.93490e-06,
     & -3.89216e-06,-3.36211e-06,-2.41393e-06,-9.53406e-07,
     & -1.16269e-06,-1.66431e-06,-1.77150e-06,-1.82496e-06,
     & -1.93095e-06,-2.75759e-06,-2.83618e-06,-2.27908e-06,
     & -6.33348e-07, 5.61257e-07, 1.00142e-06, 7.73337e-07,
     &  3.17721e-07,-3.69804e-07,-8.82058e-07,-1.17364e-06,
     & -4.53480e-07,-2.47824e-07,-4.79624e-07,-5.17032e-07,
     & -3.46498e-07, 1.42669e-07,-1.59168e-07,-5.06580e-07,
     & -3.18573e-07,-2.74092e-07,-2.68860e-07, 1.32811e-07,
     & -2.35567e-09,-6.71971e-07,-9.75302e-07,-8.70978e-07,
     & -3.59071e-08,-3.01726e-07,-8.27641e-07,-1.14899e-06,
     & -1.50160e-06,-1.83660e-06,-1.26290e-06,-1.07659e-06,
     & -1.34878e-06,-5.24626e-07,-7.85094e-08,-8.79473e-07,
     & -1.19291e-06,-1.33298e-06,-1.59750e-06,-1.31836e-06,
     & -5.73079e-07,-1.10349e-06,-1.11807e-06,-1.99530e-07,
     & -8.10496e-07,-1.42679e-06,-5.34617e-07,-2.05001e-07,
     & -2.51690e-07,-1.01740e-06,-1.02841e-06,-7.48750e-08/
      data s2(2501:2600)/
     & -1.01770e-06,-1.50413e-06, 1.80898e-07, 3.63788e-07,
     & -1.97900e-07,-1.16721e-06,-1.05497e-06,-2.07218e-08,
     & -1.90590e-07,-8.25501e-07,-2.21142e-06,-1.19905e-06,
     &  2.16271e-07,-2.52574e-07,-4.35837e-07,-3.95272e-07,
     &  5.97065e-08, 2.76639e-07, 9.22569e-08, 1.20142e-07,
     & -2.95030e-09,-1.08216e-06,-1.32386e-06,-9.62248e-07,
     & -1.99430e-06,-2.13890e-06,-9.56082e-07,-6.94022e-07,
     & -7.75721e-07,-1.31048e-06,-1.50080e-06,-1.35873e-06,
     & -7.48378e-07,-4.83436e-07,-4.69624e-07,-1.51156e-06,
     & -2.48221e-06,-3.30134e-06,-2.79114e-06,-2.08976e-06,
     & -2.24768e-06,-1.06947e-06, 1.17462e-06,-2.51423e-07,
     & -7.85729e-07, 5.37467e-07,-9.39876e-08,-1.11303e-06,
     & -7.46860e-07,-9.36220e-07,-1.59880e-06,-1.61420e-06,
     & -1.54368e-06,-1.41036e-06,-7.20350e-07, 1.35544e-07,
     &  3.14481e-07, 6.29265e-07, 1.09161e-06,-1.36044e-07,
     & -1.22932e-06,-1.29847e-06,-3.26429e-06,-6.01062e-06,
     & -2.09945e-06, 1.26878e-07,-2.88050e-08,-6.82802e-07,
     & -1.39340e-06,-1.82986e-06,-1.67208e-06,-1.07994e-06,
     & -1.89195e-06,-2.10782e-06,-1.04519e-06,-3.27672e-07,
     &  1.95516e-07, 1.63838e-07,-2.29575e-07,-1.01609e-06,
     & -2.19286e-06,-2.71850e-06,-9.77485e-07,-1.48830e-06,
     & -3.37826e-06,-1.59130e-06,-5.74498e-07,-8.27962e-07,
     & -9.92211e-07,-1.14422e-06,-1.41420e-06,-1.11629e-06,
     & -2.51575e-07, 1.60805e-07, 1.82934e-07,-7.28868e-07,
     & -2.57062e-07, 1.06520e-06, 4.16488e-07, 2.97049e-08/
      data s2(2601:2687)/
     &  6.62797e-08, 8.29435e-07, 1.29657e-06,-2.27961e-06,
     & -3.40386e-06,-1.88594e-06,-2.29732e-06,-2.72594e-06,
     & -2.09847e-06,-1.31771e-06,-4.23693e-07,-4.96348e-07,
     & -9.40209e-07,-2.08707e-06,-1.21368e-06, 4.79409e-07,
     & -1.12548e-08,-4.57316e-07,-8.40885e-07,-5.03210e-07,
     & -1.61036e-07,-1.05835e-06,-1.66417e-06,-1.97827e-06,
     & -1.63737e-06,-1.11711e-06,-3.16081e-07,-6.81746e-07,
     & -1.82599e-06,-1.12895e-06,-9.19712e-07,-1.91707e-06,
     & -2.14767e-06,-2.03629e-06,-2.86441e-06,-3.07735e-06,
     & -2.28656e-06,-1.40256e-06,-5.50649e-07,-3.11627e-07,
     & -7.90261e-07,-2.10728e-06,-1.89739e-06,-1.53762e-06,
     & -2.39947e-06,-2.28765e-06,-1.27564e-06,-2.15154e-06,
     & -3.17932e-06,-3.84234e-06,-3.65102e-06,-2.84055e-06,
     & -2.48744e-06,-2.27683e-06,-2.33087e-06,-3.44460e-06,
     & -5.19613e-06,-2.85882e-06,-1.39921e-06,-2.00579e-06,
     & -2.80593e-06,-3.65940e-06,-2.39526e-06,-1.70389e-06,
     & -2.03532e-06,-2.71522e-06,-3.42227e-06,-2.23606e-06,
     & -1.77845e-06,-2.42071e-06,-2.61515e-06,-2.56413e-06,
     & -1.49601e-06,-1.23245e-06,-2.08440e-06,-2.11121e-06,
     & -1.93424e-06,-2.27439e-06,-2.58183e-06,-2.84705e-06,
     & -2.32183e-06,-1.80966e-06,-3.04089e-06,-3.14334e-06,
     & -1.91331e-06,-1.51037e-06,-1.43610e-06/
cccc

      i=(v-v1)/dv+1.00001
      if(i.lt.1 .or. i.gt.npts) then
        c0=0.
        c1=0.
        c2=0.
      else
        c0=s0(i)
        c1=s1(i)
        c2=s2(i)
      endif
      
      return
      end
c=======================================================================
      subroutine o3uv(v,c)

c  uv ozone for 40800-54000 cm-1 (185-245nm)

      use params, only: kr
      implicit none
      integer, parameter :: npts=133
      real(kr) :: v1=40800., v2=54000., dv=100., s(npts),
     &     c, vr, am, c0, v
      integer :: i

      data s(1:100)/
     &  9.91204e+02,  9.76325e+02,  9.72050e+02,  9.51049e+02, 
     &  9.23530e+02,  9.02306e+02,  8.90510e+02,  8.60115e+02, 
     &  8.39094e+02,  8.27926e+02,  7.95525e+02,  7.73583e+02, 
     &  7.55018e+02,  7.31076e+02,  7.10415e+02,  6.87747e+02, 
     &  6.66639e+02,  6.39484e+02,  6.27101e+02,  6.01019e+02, 
     &  5.77594e+02,  5.60403e+02,  5.40837e+02,  5.21289e+02, 
     &  4.99329e+02,  4.81742e+02,  4.61608e+02,  4.45707e+02, 
     &  4.28261e+02,  4.09672e+02,  3.93701e+02,  3.77835e+02, 
     &  3.61440e+02,  3.45194e+02,  3.30219e+02,  3.15347e+02, 
     &  3.01164e+02,  2.87788e+02,  2.74224e+02,  2.61339e+02, 
     &  2.48868e+02,  2.36872e+02,  2.25747e+02,  2.14782e+02, 
     &  2.03997e+02,  1.94281e+02,  1.84525e+02,  1.75275e+02, 
     &  1.67151e+02,  1.58813e+02,  1.50725e+02,  1.43019e+02, 
     &  1.35825e+02,  1.28878e+02,  1.22084e+02,  1.15515e+02, 
     &  1.09465e+02,  1.03841e+02,  9.83780e+01,  9.31932e+01, 
     &  8.83466e+01,  8.38631e+01,  7.96631e+01,  7.54331e+01, 
     &  7.13805e+01,  6.78474e+01,  6.44340e+01,  6.13104e+01, 
     &  5.81777e+01,  5.53766e+01,  5.27036e+01,  5.03555e+01, 
     &  4.82633e+01,  4.61483e+01,  4.42014e+01,  4.23517e+01, 
     &  4.07774e+01,  3.93060e+01,  3.80135e+01,  3.66348e+01, 
     &  3.53665e+01,  3.47884e+01,  3.39690e+01,  3.34288e+01, 
     &  3.29135e+01,  3.23104e+01,  3.18875e+01,  3.16800e+01, 
     &  3.15925e+01,  3.12932e+01,  3.12956e+01,  3.15522e+01, 
     &  3.14950e+01,  3.15924e+01,  3.19059e+01,  3.23109e+01, 
     &  3.27873e+01,  3.33788e+01,  3.39804e+01,  3.44925e+01/
      data s(101:133)/
     &  3.50502e+01,  3.55853e+01,  3.59416e+01,  3.68933e+01, 
     &  3.78284e+01,  3.86413e+01,  3.98049e+01,  4.04700e+01, 
     &  4.12958e+01,  4.23482e+01,  4.31203e+01,  4.41885e+01, 
     &  4.52651e+01,  4.61492e+01,  4.70493e+01,  4.80497e+01, 
     &  4.90242e+01,  4.99652e+01,  5.10316e+01,  5.21510e+01, 
     &  5.32130e+01,  5.43073e+01,  5.56207e+01,  5.61756e+01, 
     &  5.66799e+01,  5.85545e+01,  5.92409e+01,  5.96168e+01, 
     &  6.12497e+01,  6.20231e+01,  6.24621e+01,  6.34160e+01, 
     &  6.43622e+01/
cccc
      c=0.
      i=(v-v1)/dv+1.00001
      if(i.lt.1 .or. i.gt.npts) then
        c=0.
      else
        vr=i*dv+v1
        if(vr.le.(v+.1) .and .vr.ge.(v-.1)) then
          c=s(i)
        else
          if(i.eq.npts) i=npts-1
          am=(s(i+1)-s(i))/dv
          c0=s(i)-am*vr
          c=am*v+c0
        endif
      endif
c
      return
      end
c=======================================================================
      subroutine c8dta(c8l,v)

c     ozone chappius band (1300-24200 cm-1) (413-769nm)

      use params, only: kr
      implicit none
      integer :: iv, n
      real(kr) :: c8l, v, c8(102), xi, xd

      data c8/
     &  4.50e-03,  8.00e-03,  1.07e-02,  1.10e-02,  1.27e-02, 
     &  1.71e-02,  2.00e-02,  2.45e-02,  3.07e-02,  3.84e-02, 
     &  4.78e-02,  5.67e-02,  6.54e-02,  7.62e-02,  9.15e-02, 
     &  1.00e-01,  1.09e-01,  1.20e-01,  1.28e-01,  1.12e-01, 
     &  1.11e-01,  1.16e-01,  1.19e-01,  1.13e-01,  1.03e-01, 
     &  9.24e-02,  8.28e-02,  7.57e-02,  7.07e-02,  6.58e-02, 
     &  5.56e-02,  4.77e-02,  4.06e-02,  3.87e-02,  3.82e-02, 
     &  2.94e-02,  2.09e-02,  1.80e-02,  1.91e-02,  1.66e-02, 
     &  1.17e-02,  7.70e-03,  6.10e-03,  8.50e-03,  6.10e-03, 
     &  3.70e-03,  3.20e-03,  3.10e-03,  2.55e-03,  1.98e-03, 
     &  1.40e-03,  8.25e-04,  2.50e-04,  0.00e+00,  0.00e+00, 
     &  0.00e+00,  5.65e-04,  2.04e-03,  7.35e-03,  2.03e-02, 
     &  4.98e-02,  1.18e-01,  2.46e-01,  5.18e-01,  1.02e+00, 
     &  1.95e+00,  3.79e+00,  6.65e+00,  1.24e+01,  2.20e+01, 
     &  3.67e+01,  5.95e+01,  8.50e+01,  1.26e+02,  1.68e+02, 
     &  2.06e+02,  2.42e+02,  2.71e+02,  2.91e+02,  3.02e+02, 
     &  3.03e+02,  2.94e+02,  2.77e+02,  2.54e+02,  2.26e+02, 
     &  1.96e+02,  1.68e+02,  1.44e+02,  1.17e+02,  9.75e+01, 
     &  7.65e+01,  6.04e+01,  4.62e+01,  3.46e+01,  2.52e+01, 
     &  2.00e+01,  1.57e+01,  1.20e+01,  1.00e+01,  8.80e+00, 
     &  8.30e+00,  8.60e+00/
cccc      
      c8l=0.
      if(v.lt.13000.) return
      if(v.gt.50000.) return
      iv=v
      if(iv.gt.24200.and.iv.lt.27500) return
      xi=(v-13000.0)/200.0+1.
      if(iv.ge.27500) xi=(v-27500.0)/500.+57.
      n=xi+1.001
      xd=xi-float(n)
      c8l=c8(n)+xd*(c8(n)-c8(n-1))
      return
      end
c=======================================================================
      subroutine cxdta(cprime,v,iwl,iwh,cp,ind)

c     purpose:  finds the cprime for the wavenumber v.
c
c     input:         v --- wavenumber
c            (iwl,iwh) --- wavenumber pair specifies the absorption
c                          region. both are arrays and terminated
c                          with the value -999
c                   cp --- array contains the cprimes
c     output:   cprime --- the cprime corresponding to v
c     i/o:         ind --- indicator indicates the absorption region
c                          where the wavenumber is expected to be in
c                          or nearby (it serves for the purpose
c                          to speed up the searching process)
      use params, only: kr
      implicit none
      integer ::  iwl(*),iwh(*), iv, ic, ind, indm1, i
      real(kr) :: cp(*), cprime, v
cccc
      iv=v
      cprime=-20.0
      if (iwl(ind+1) .eq. -999 .and. iv .gt. iwh(ind)) return
      if (iv .lt. iwl(1)) return
      ic=0
  100 if (iv .ge. iwl(ind) .and. iv .le. iwh(ind)) go to 200
      if (iv .gt. iwh(ind) .and. iv .lt. iwl(ind+1)) return
      ind=ind+1
      if (iwl(ind) .ne. -999) go to 100
      ind=ind-1
      if (iv .gt. iwh(ind)) return
      ind=1
      go to 100
  200 if (ind .eq. 1) go to 400
      indm1=ind-1
      do 300 i=1,indm1
        ic=ic+(iwh(i)-iwl(i))/5+1
  300 continue
  400 ic=ic+(iv-iwl(ind))/5+1
      cprime=cp(ic)
      return
      end
c=======================================================================
      subroutine abcdta(iv)
c
      use params, only: kr
      use gasblk, only: bma,bmb,bmc,bms,cps,ibnd
      implicit none

      integer :: iw, imol, iv, iband

      real(kr) :: anh3(2), aco2(10), aco(3),  ach4(4),
     &     ano2(3), an2o(11), ao2(6), ao3(5), aso2(4), ah2o(14), ano,
     &     aanh3(2), bbnh3(2), ccnh3(2), aaco2(10), bbco2(10),
     &     ccco2(10), aaco(3), bbco(3), ccco(3), aach4(4), bbch4(4),
     &     ccch4(4), aano2(3), bbno2(3), ccno2(3), aan2o(11), bbn2o(11),
     &     ccn2o(11), aao2(6), bbo2(6), cco2(6), aao3(5), bbo3(5),
     &     cco3(5), aaso2(4), bbso2(4), ccso2(4), aah2o(14), bbh2o(14),
     &     cch2o(14), aano, bbno, ccno

      data anh3/.4704,.6035/
      data aco2/.6176,.6810,.6033,.6146,.6513,.6050,
     & .6160,.7070,.7070,.7070/
      data aco/.6397,.6133,.6133/
      data ach4/.5844,.5844,.5844,.5844/
      data ano/.6613/
      data ano2/.7249,.7249,.7249/
      data an2o/.8997,.7201,.7201,.7201,.7201,.7201,
     & .6933,.6933,.6933,.6933,.6933/
      data ao2/.6011,.5641,.5641,.5641,.5641,.5641/
      data ao3/.8559,.7593,.7819,.9175,.7703/
      data aso2/.8907,.8466,.8466,.8466/
      data ah2o/.5274,.5299,.5416,.5479,.5495,.5464,.5454,
     & .5474,.5579,.5621,.5847,.6076,.6508,.6570/
      data aanh3/.285772,.134244/
      data bbnh3/.269839,.353937/
      data ccnh3/19.9507,27.8458/
      data aaco2/.120300,.069728,.134448,.123189,.090948,
     & .132717,.121835,.054348,.054348,.054348/
      data bbco2/.348172,.303510,.354002,.349583,.327160,
     & .353435,.348936,.280674,.280674,.280674/
      data ccco2/29.4277,37.0842,27.8241,29.0834,33.4608,
     & 28.0093,29.2436,40.1951,40.1951,40.1951/
      data aaco/.100401,.124454,.124454/
      data bbco/.335296,.350165,.350165/
      data ccco/32.0496,28.9354,28.9354/
      data aach4/.154447,.154447,.154447,.154447/
      data bbch4/.357657,.357657,.357657,.357657/
      data ccch4/25.8920,25.8920,25.8920,25.8920/
      data aano/.083336/
      data bbno/.319585/
      data ccno/34.6834/
      data aano2/.045281,.045281,.045281/
      data bbno2/.264248,.264248,.264248/
      data ccno2/42.2784,42.2784,42.2784/
      data aan2o/.001679,.047599,.047599,.047599,.047599,
     & .047599,.062106,.062106,.062106,.062106,.062106/
      data bbn2o/.095621,.268696,.268696,.268696,.268696,
     & .268696,.292891,.292891,.292891,.292891,.292891/
      data ccn2o/59.3660,41.7251,41.7251,41.7251,41.7251,
     & 41.7251,38.5667,38.5667,38.5667,38.5667,38.5667/
      data aao2/.136706,.177087,.177087,.177087,.177087,.177087/
      data bbo2/.354683,.355447,.355447,.355447,.355447,.355447/
      data cco2/27.5869,24.1314,24.1314,24.1314,24.1314,24.1314/
      data aao3/.006712,.030870,.023278,.000458,.027004/
      data bbo3/.138026,.231722,.209952,.078492,.221153/
      data cco3/55.6442,46.1189,48.5155,60.7802,47.2982/
      data aaso2/.002468,.008192,.008192,.008192/
      data bbso2/.104307,.147065,.147065,.147065/
      data ccso2/58.6298,54.8078,54.8078,54.8078/
      data aah2o/.219312,.216415,.206349,.196196,.194540,.198500,
     & .198500,.196196,.184148,.179360,.154120,.130095,.091341,.086549/
      data bbh2o/.334884,.336904,.343272,.348610,.349810,.347498,
     & .347498,.348610,.353429,.354864,.357640,.352497,.327526,.322898/
      data cch2o/21.8352,21.9588,22.4234,22.9517,23.0750,22.8262,
     & 22.8262,22.9517,23.6654,23.9774,25.9207,28.2957,33.3998,34.1575/
c
c
c    mol
c     1    h2o (all regions) (double exponential models)
c     2    co2 (all regions) (double exponential models)
c     3    o3  (all regions) (double exponential models)
c     4    n2o (all regions) (double exponential models)
c     5    co  (all regions) (double exponential models)
c     6    ch4 (all regions) (double exponential models)
c     7    o2  (all regions) (double exponential models)
c     8    no  (all regions) (double exponential models)
c     9    so2 (all regions) (double exponential models)
c    10    no2 (all regions) (double exponential models)
c    11    nh3 (all regions) (double exponential models)
c
c  ---h2o
      imol = 1
      iw = -1
      if(iv.ge.     0.and.iv.le.   345) iw = 17
      if(iv.ge.   350.and.iv.le.  1000) iw = 18
      if(iv.ge.  1005.and.iv.le.  1640) iw = 19
      if(iv.ge.  1645.and.iv.le.  2530) iw = 20
      if(iv.ge.  2535.and.iv.le.  3420) iw = 21
      if(iv.ge.  3425.and.iv.le.  4310) iw = 22
      if(iv.ge.  4315.and.iv.le.  6150) iw = 23
      if(iv.ge.  6155.and.iv.le.  8000) iw = 24
      if(iv.ge.  8005.and.iv.le.  9615) iw = 25
      if(iv.ge.  9620.and.iv.le. 11540) iw = 26
      if(iv.ge. 11545.and.iv.le. 13070) iw = 27
      if(iv.ge. 13075.and.iv.le. 14860) iw = 28
      if(iv.ge. 14865.and.iv.le. 16045) iw = 29
      if(iv.ge. 16340.and.iv.le. 17860) iw = 30
      iband = iw - 16
      ibnd(imol) = iw
      if(iw .gt.  0) then
           bms(imol)  =   ah2o(iband)
           bma(imol)  = aah2o(iband)
           bmb(imol)  = bbh2o(iband)
           bmc(imol)  = cch2o(iband)
      endif
c  ---o3
      imol = 3
      iw = -1
      if (iv .ge.     0 .and. iv .le.   200)  iw = 31
      if (iv .ge.   515 .and. iv .le.  1275)  iw = 32
      if (iv .ge.  1630 .and. iv .le.  2295)  iw = 33
      if (iv .ge.  2670 .and. iv .le.  2845)  iw = 34
      if (iv .ge.  2850 .and. iv .le.  3260)  iw = 35
      iband      = iw - 30
      ibnd(imol) = iw
      if(iw .gt.  0) then
           bms(imol)  =  ao3(iband)
           bma(imol) = aao3(iband)
           bmb(imol) = bbo3(iband)
           bmc(imol) = cco3(iband)
      endif
c  ---co2
      imol = 2
      iw = -1
      if (iv .ge.   425 .and. iv .le.   835)  iw = 36
      if (iv .ge.   840 .and. iv .le.  1440)  iw = 37
      if (iv .ge.  1805 .and. iv .le.  2855)  iw = 38
      if (iv .ge.  3070 .and. iv .le.  3755)  iw = 39
      if (iv .ge.  3760 .and. iv .le.  4065)  iw = 40
      if (iv .ge.  4530 .and. iv .le.  5380)  iw = 41
      if (iv .ge.  5905 .and. iv .le.  7025)  iw = 42
      if((iv .ge.  7395 .and. iv .le.  7785) .or.
     *   (iv .ge.  8030 .and. iv .le.  8335) .or.
     *   (iv .ge.  9340 .and. iv .le.  9670)) iw = 43
      iband = iw - 35
      ibnd(imol) = iw
      if(iw .gt.  0) then
           bms(imol)  =  aco2(iband)
           bma(imol) = aaco2(iband)
           bmb(imol) = bbco2(iband)
           bmc(imol) = ccco2(iband)
      endif
c  ---co
      imol = 5
      iw = -1
      if (iv .ge.     0 .and. iv .le.   175) iw = 44
      if((iv .ge.  1940 .and. iv .le.  2285) .or.
     *   (iv .ge.  4040 .and. iv .le.  4370)) iw = 45
      iband = iw - 43
      ibnd(imol) = iw
      if(iw .gt.  0) then
           bms(imol)  =  aco(iband)
           bma(imol) = aaco(iband)
           bmb(imol) = bbco(iband)
           bmc(imol) = ccco(iband)
      endif
c  ---ch4
      imol = 6
      iw = -1
      if((iv .ge.  1065 .and. iv .le.  1775) .or.
     *   (iv .ge.  2345 .and. iv .le.  3230) .or.
     *   (iv .ge.  4110 .and. iv .le.  4690) .or.
     *   (iv .ge.  5865 .and. iv .le.  6135))iw = 46
      iband = iw - 45
      ibnd(imol) = iw
      if(iw .gt.  0) then
           bms(imol)  =  ach4(iband)
           bma(imol) = aach4(iband)
           bmb(imol) = bbch4(iband)
           bmc(imol) = ccch4(iband)
      endif
c  ---n2o
      imol = 4
      iw = -1
      if (iv .ge.     0 .and. iv .le.   120)  iw = 47
      if((iv .ge.   490 .and. iv .le.   775) .or.
     *   (iv .ge.   865 .and. iv .le.   995) .or.
     *   (iv .ge.  1065 .and. iv .le.  1385) .or.
     *   (iv .ge.  1545 .and. iv .le.  2040) .or.
     *   (iv .ge.  2090 .and. iv .le.  2655)) iw = 48
      if((iv .ge.  2705 .and. iv .le.  2865) .or.
     *   (iv .ge.  3245 .and. iv .le.  3925) .or.
     *   (iv .ge.  4260 .and. iv .le.  4470) .or.
     *   (iv .ge.  4540 .and. iv .le.  4785) .or.
     *   (iv .ge.  4910 .and. iv .le.  5165)) iw = 49
      iband = iw - 46
      ibnd(imol) = iw
      if(iw .gt.  0) then
           bms(imol)  =  an2o(iband)
           bma(imol) = aan2o(iband)
           bmb(imol) = bbn2o(iband)
           bmc(imol) = ccn2o(iband)
      endif
c  ---o2
      imol = 7
      iw = -1
      if (iv .ge.     0 .and. iv .le.   265)  iw = 50
      if((iv .ge.  7650 .and. iv .le.  8080) .or.
     *   (iv .ge.  9235 .and. iv .le.  9490) .or.
     *   (iv .ge. 12850 .and. iv .le. 13220) .or.
     *   (iv .ge. 14300 .and. iv .le. 14600) .or.
     *   (iv .ge. 15695 .and. iv .le. 15955)) iw = 51
       if(iv .ge. 49600 .and. iv .le. 52710)  iw = 51
      iband = iw - 49
      ibnd(imol) = iw
      if(iw .gt.  0) then
           bms(imol)  =  ao2(iband)
           if(iv.ge.49600 .and. iv.le.52710)  bms(imol)  = .4704
           bma(imol) = aao2(iband)
           bmb(imol) = bbo2(iband)
           bmc(imol) = cco2(iband)
      endif
c  ---nh3
      imol = 11
      iw = -1
      if (iv .ge.     0 .and. iv .le.   385)  iw = 52
      if (iv .ge.   390 .and. iv .le.  2150)  iw = 53
      iband = iw - 51
      ibnd(imol) = iw
      if(iw .gt.  0) then
           bms(imol)  =  anh3(iband)
           bma(imol) = aanh3(iband)
           bmb(imol) = bbnh3(iband)
           bmc(imol) = ccnh3(iband)
      endif
c  ---no
      imol = 8
      iw = -1
      if (iv .ge.  1700 .and. iv .le.  2005) iw  = 54
      iband = iw - 53
      ibnd(imol) = iw
      if(iw .gt.  0) then
           bms(imol)  =  ano
           bma(imol) = aano
           bmb(imol) = bbno
           bmc(imol) = ccno
      endif
c  ---no2
      iw = -1
      imol = 10
      if((iv .ge.   580 .and. iv .le.   925) .or.
     *   (iv .ge.  1515 .and. iv .le.  1695) .or.
     *   (iv .ge.  2800 .and. iv .le.  2970)) iw = 55
      iband = iw - 54
      ibnd(imol) = iw
      if(iw .gt.  0) then
           bms(imol)  =  ano2(iband)
           bma(imol) = aano2(iband)
           bmb(imol) = bbno2(iband)
           bmc(imol) = ccno2(iband)
      endif
c  ---so2
      imol = 9
      iw = -1
      if (iv .ge.     0 .and. iv .le.   185)  iw = 56
      if((iv .ge.   400 .and. iv .le.   650) .or.
     *   (iv .ge.   950 .and. iv .le.  1460) .or.
     *   (iv .ge.  2415 .and. iv .le.  2580)) iw = 57
      iband = iw - 55
      ibnd(imol) = iw
      if(iw .gt.  0) then
           bms(imol)  =  aso2(iband)
           bma(imol) = aaso2(iband)
           bmb(imol) = bbso2(iband)
           bmc(imol) = ccso2(iband)
      endif
      return
      end
c=======================================================================

      subroutine schrun(v,cprun)

c     schumann-runge o2 band model

      use params, only: kr
      implicit none
      integer, parameter :: npts=423
      integer :: i
      real(kr) :: shn(npts), v1=49600., v2=51710., dv=5., cprun, v

      data shn(1:100)/
     & -8.00000,-8.00000,-8.00000,-6.30103,-6.00000,-5.94896,-5.94896,
     & -5.55139,-5.17613,-4.90612,-4.56059,-4.30010,-4.30739,-4.34455,
     & -4.35231,-4.50777,-4.41705,-3.93569,-3.70298,-3.84254,-4.01007,
     & -4.13821,-3.92122,-3.55006,-3.22681,-3.17363,-3.55224,-3.66208,
     & -3.32331,-3.00804,-2.99732,-3.30951,-3.20867,-2.69141,-2.49670,
     & -2.74355,-2.69834,-2.67293,-2.67371,-2.89603,-3.13808,-3.45473,
     & -3.54812,-3.00636,-2.72446,-2.90208,-2.93847,-3.03693,-3.15944,
     & -3.43764,-3.67262,-3.53970,-2.84182,-2.51909,-2.50557,-2.44459,
     & -2.72040,-2.95979,-3.02842,-2.92391,-2.61329,-2.24839,-2.03988,
     & -1.98147,-1.97078,-2.14548,-2.51734,-2.47024,-2.02579,-1.70360,
     & -1.64178,-2.05789,-2.41111,-2.30034,-1.91818,-1.50450,-1.32084,
     & -1.80380,-2.13878,-1.94658,-1.61627,-1.55771,-1.88813,-1.64415,
     & -1.43970,-1.72633,-1.50064,-1.29499,-1.47224,-1.42286,-1.84903,
     & -2.42249,-2.95877,-3.43342,-3.85023,-4.92183,-4.92959,-4.80852,
     & -4.67030,-4.72573/
      data shn(101:200)/
     & -4.84445,-4.86951,-4.90354,-4.80891,-4.61211,-4.48205,-4.51391,
     & -4.66502,-4.84670,-4.88606,-4.82391,-4.69897,-4.51203,-4.13960,
     & -3.87805,-3.80311,-3.77114,-3.88260,-4.14615,-4.39649,-4.62899,
     & -4.78494,-4.69514,-4.27200,-3.92731,-3.72681,-3.60335,-3.49142,
     & -3.38223,-3.52349,-3.64037,-3.58526,-3.48978,-3.36320,-3.37270,
     & -3.58359,-3.83908,-4.06157,-3.96920,-3.24875,-2.78627,-2.54861,
     & -2.56192,-2.79838,-2.89008,-2.97200,-2.91496,-2.85783,-3.00554,
     & -3.22285,-3.17575,-2.82405,-2.44375,-2.24512,-2.13519,-2.17638,
     & -2.12548,-2.24833,-2.42286,-2.48889,-2.57284,-2.67481,-2.84576,
     & -2.57849,-2.23621,-1.97914,-2.01655,-2.08918,-2.25852,-2.60669,
     & -2.91101,-3.24343,-3.54870,-3.05507,-2.41260,-1.97192,-1.74591,
     & -1.70757,-1.86170,-2.21955,-2.52520,-2.86220,-2.96082,-2.42138,
     & -1.96791,-1.71099,-1.68871,-1.86617,-2.21148,-2.51694,-2.77760,
     & -2.37949,-1.89083,-1.58900,-1.52710,-1.68850,-2.03635,-2.31319,
     & -2.17366,-1.60655/
      data shn(201:300)/
     & -1.27097,-1.14262,-1.34089,-1.68119,-1.78236,-1.45853,-1.19063,
     & -1.11210,-1.38628,-1.48342,-1.12039,-0.85543,-0.77060,-1.05684,
     & -1.05423,-0.93689,-0.86922,-0.94306,-0.76850,-0.59062,-0.50208,
     & -0.53499,-0.88884,-1.18360,-1.52243,-1.84564,-2.17740,-2.50559,
     & -2.83351,-3.15308,-3.41587,-3.41025,-3.23752,-3.13656,-3.30149,
     & -3.55280,-3.77885,-3.71929,-3.36467,-3.06275,-2.83782,-2.68294,
     & -2.55793,-2.63001,-2.90714,-3.18561,-3.46714,-3.70067,-3.62895,
     & -3.02605,-2.65584,-2.46195,-2.48991,-2.44044,-2.29494,-2.28839,
     & -2.29827,-2.22063,-2.12801,-2.18940,-2.48029,-2.74669,-2.83833,
     & -2.45937,-2.16507,-2.02067,-2.03314,-1.80888,-1.51479,-1.38580,
     & -1.37993,-1.63534,-1.83905,-1.87999,-1.82492,-1.89398,-1.90149,
     & -1.78545,-1.65285,-1.40144,-1.17488,-1.07228,-1.15343,-1.37759,
     & -1.70025,-2.01075,-2.33004,-2.62771,-2.87105,-2.84082,-2.00293,
     & -1.31932,-0.92860,-0.76253,-0.84790,-1.16306,-1.46677,-1.79051,
     & -2.09491,-2.34556/
      data shn(301:400)/
     & -2.13867,-1.37321,-0.82048,-0.53990,-0.47636,-0.72816,-1.03484,
     & -1.33688,-1.61955,-1.78843,-1.43388,-0.81369,-0.44878,-0.28512,
     & -0.40431,-0.72200,-1.00945,-1.28895,-1.31856,-0.85686,-0.42072,
     & -0.19421,-0.18317,-0.46858,-0.73309,-0.93390,-0.77552,-0.37922,
     & -0.12965,-0.05480,-0.26659,-0.48423,-0.50987,-0.24666,-0.01742,
     &  0.07660,-0.06367,-0.20185,-0.11253, 0.06726, 0.17955, 0.14879,
     &  0.15975, 0.28769, 0.41632, 0.49995, 0.61664, 0.76706, 0.82624,
     &  0.76615, 0.43165, 0.13821,-0.18926,-0.48784,-0.77913,-1.08972,
     & -1.39948,-1.70006,-1.94700,-1.96249,-1.67500,-1.41241,-1.29981,
     & -1.40100,-1.69529,-1.96904,-2.25253,-2.44942,-2.13985,-1.80460,
     & -1.60216,-1.72517,-1.98472,-2.08115,-1.62632,-1.12971,-0.86160,
     & -0.81141,-1.07504,-1.34407,-1.50074,-1.47345,-1.41077,-1.59810,
     & -1.67103,-1.53208,-1.36215,-1.26724,-0.91307,-0.50826,-0.27840,
     & -0.24468,-0.46373,-0.76619,-1.07304,-1.37968,-1.66148,-1.89046,
     & -2.02811,-1.97679/
      data shn(401:423)/
     & -1.55840,-0.94089,-0.46463,-0.21757,-0.16985,-0.41642,-0.69469,
     & -0.98624,-1.26028,-1.48661,-1.58100,-1.42675,-1.01563,-0.52312,
     & -0.13686, 0.06300, 0.07682,-0.16825,-0.42809,-0.69506,-0.91898,
     & -1.03253,-0.90609/

cccc      
      cprun = -20.
      i=(v-v1)/dv+1.0001
      if(i.ge.1.and.i.le.npts) cprun=shn(i)
      return
      end
c=======================================================================
      module trcblk

      use params, only: kr
      implicit none

      real(kr) :: xo4

      integer, parameter :: mz=33

      integer :: modify=0   ! indicates when trace gas profies are modified

      real(kr) ::  alt(mz), n2(mz), o2(mz), co2(mz), ch4(mz),
     &     n2o(mz), co(mz), no2(mz), so2(mz), nh3(mz), no(mz), hno3(mz),
     &     un2=1., uo2=1., uco2=1., uch4=1., un2o=1.,
     &     uco=1., uno2=1., uso2=1., unh3=1., uno=1., uhno3=1.

      data alt/
     &    0.0,  1.0,  2.0,  3.0, 4.0,   5.0,  6.0,  7.0,  8.0,  9.0,
     &   10.0, 11.0, 12.0, 13.0, 14.0, 15.0, 16.0, 17.0, 18.0, 19.0,
     &   20.0, 21.0, 22.0, 23.0, 24.0, 25.0, 30.0, 35.0, 40.0, 45.0,
     &   50.0, 70.0,100.0/
      data n2/
     &  7.81e+05,  7.81e+05,  7.81e+05,  7.81e+05,  7.81e+05,
     &  7.81e+05,  7.81e+05,  7.81e+05,  7.81e+05,  7.81e+05,
     &  7.81e+05,  7.81e+05,  7.81e+05,  7.81e+05,  7.81e+05,
     &  7.81e+05,  7.81e+05,  7.81e+05,  7.81e+05,  7.81e+05,
     &  7.81e+05,  7.81e+05,  7.81e+05,  7.81e+05,  7.81e+05,
     &  7.81e+05,  7.81e+05,  7.81e+05,  7.81e+05,  7.81e+05,
     &  7.81e+05,  7.81e+05,  7.77e+05/
      data o2/
     & 2.090e+05, 2.090e+05, 2.090e+05, 2.090e+05, 2.090e+05,
     & 2.090e+05, 2.090e+05, 2.090e+05, 2.090e+05, 2.090e+05,
     & 2.090e+05, 2.090e+05, 2.090e+05, 2.090e+05, 2.090e+05,
     & 2.090e+05, 2.090e+05, 2.090e+05, 2.090e+05, 2.090e+05,
     & 2.090e+05, 2.090e+05, 2.090e+05, 2.090e+05, 2.090e+05,
     & 2.090e+05, 2.090e+05, 2.090e+05, 2.090e+05, 2.090e+05,
     & 2.090e+05, 2.090e+05, 1.600e+05/

c Keeling Mouna Loa CO2 as of jan96

      data co2/
     & 3.600e+02, 3.600e+02, 3.600e+02, 3.600e+02, 3.600e+02,
     & 3.600e+02, 3.600e+02, 3.600e+02, 3.600e+02, 3.600e+02,
     & 3.600e+02, 3.600e+02, 3.600e+02, 3.600e+02, 3.600e+02,
     & 3.600e+02, 3.600e+02, 3.600e+02, 3.600e+02, 3.600e+02,
     & 3.600e+02, 3.600e+02, 3.600e+02, 3.600e+02, 3.600e+02,
     & 3.600e+02, 3.600e+02, 3.600e+02, 3.600e+02, 3.600e+02,
     & 3.600e+02, 3.600e+02, 2.130e+02/
      data  ch4/
     & 1.700e+00, 1.700e+00, 1.700e+00, 1.700e+00, 1.700e+00,
     & 1.700e+00, 1.700e+00, 1.699e+00, 1.697e+00, 1.693e+00,
     & 1.685e+00, 1.675e+00, 1.662e+00, 1.645e+00, 1.626e+00,
     & 1.605e+00, 1.582e+00, 1.553e+00, 1.521e+00, 1.480e+00,
     & 1.424e+00, 1.355e+00, 1.272e+00, 1.191e+00, 1.118e+00,
     & 1.055e+00, 9.136e-01, 7.460e-01, 5.638e-01, 3.631e-01,
     & 2.100e-01, 1.500e-01, 1.200e-01/
      data  n2o/
     & 3.200e-01, 3.200e-01, 3.200e-01, 3.200e-01, 3.200e-01,
     & 3.200e-01, 3.200e-01, 3.200e-01, 3.200e-01, 3.195e-01,
     & 3.179e-01, 3.140e-01, 3.095e-01, 3.048e-01, 2.999e-01,
     & 2.944e-01, 2.877e-01, 2.783e-01, 2.671e-01, 2.527e-01,
     & 2.365e-01, 2.194e-01, 2.051e-01, 1.967e-01, 1.875e-01,
     & 1.756e-01, 1.416e-01, 9.275e-02, 4.513e-02, 1.591e-02,
     & 4.752e-03, 1.149e-03, 3.323e-04/
      data co/
     & 1.500e-01, 1.450e-01, 1.399e-01, 1.349e-01, 1.312e-01,
     & 1.303e-01, 1.288e-01, 1.247e-01, 1.185e-01, 1.094e-01,
     & 9.962e-02, 8.964e-02, 7.814e-02, 6.374e-02, 5.025e-02,
     & 3.941e-02, 3.069e-02, 2.489e-02, 1.966e-02, 1.549e-02,
     & 1.331e-02, 1.232e-02, 1.232e-02, 1.307e-02, 1.400e-02,
     & 1.498e-02, 1.710e-02, 2.009e-02, 2.497e-02, 3.241e-02,
     & 4.597e-02, 3.059e-01, 1.692e+01/
      data no2/
     &  2.30e-05,  2.30e-05,  2.30e-05,  2.30e-05,  2.30e-05,
     &  2.30e-05,  2.30e-05,  2.30e-05,  2.30e-05,  2.32e-05,
     &  2.38e-05,  2.62e-05,  3.15e-05,  4.45e-05,  7.48e-05,
     &  1.71e-04,  3.19e-04,  5.19e-04,  7.71e-04,  1.06e-03,
     &  1.39e-03,  1.76e-03,  2.16e-03,  2.58e-03,  3.06e-03,
     &  3.74e-03,  6.16e-03,  7.28e-03,  4.03e-03,  1.15e-03,
     &  4.43e-04,  2.31e-04,  1.70e-04/
      data so2/
     &  3.00e-04,  2.74e-04,  2.36e-04,  1.90e-04,  1.46e-04,
     &  1.18e-04,  9.71e-05,  8.30e-05,  7.21e-05,  6.56e-05,
     &  6.08e-05,  5.79e-05,  5.60e-05,  5.59e-05,  5.64e-05,
     &  5.75e-05,  5.75e-05,  5.37e-05,  4.78e-05,  3.97e-05,
     &  3.19e-05,  2.67e-05,  2.28e-05,  2.07e-05,  1.90e-05,
     &  1.75e-05,  1.34e-05,  1.16e-05,  1.36e-05,  2.10e-05,
     &  3.56e-05,  4.32e-05,  3.58e-07/
      data nh3/
     &  5.00e-04,  5.00e-04,  4.63e-04,  3.80e-04,  2.88e-04,
     &  2.04e-04,  1.46e-04,  9.88e-05,  6.48e-05,  3.77e-05,
     &  2.03e-05,  1.09e-05,  6.30e-06,  3.12e-06,  1.11e-06,
     &  4.47e-07,  2.11e-07,  1.10e-07,  6.70e-08,  3.97e-08,
     &  2.41e-08,  1.92e-08,  1.72e-08,  1.59e-08,  1.44e-08,
     &  1.23e-08,  6.35e-09,  1.82e-09,  2.94e-10,  2.98e-11,
     &  7.13e-12,  2.57e-12,  1.48e-12/
      data no/
     &  3.00e-04,  3.00e-04,  3.00e-04,  3.00e-04,  3.00e-04,
     &  3.00e-04,  3.00e-04,  3.00e-04,  3.00e-04,  3.00e-04,
     &  3.00e-04,  3.00e-04,  3.00e-04,  2.99e-04,  2.95e-04,
     &  2.83e-04,  2.68e-04,  2.52e-04,  2.40e-04,  2.44e-04,
     &  2.55e-04,  2.77e-04,  3.07e-04,  3.60e-04,  4.51e-04,
     &  6.85e-04,  2.45e-03,  7.14e-03,  1.12e-02,  1.17e-02,
     &  1.03e-02,  1.15e-02,  2.08e+00/
      data hno3/
     &  5.00e-05,  5.96e-05,  6.93e-05,  7.91e-05,  8.87e-05,
     &  9.75e-05,  1.11e-04,  1.26e-04,  1.39e-04,  1.53e-04,
     &  1.74e-04,  2.02e-04,  2.41e-04,  2.76e-04,  3.33e-04,
     &  4.52e-04,  7.37e-04,  1.31e-03,  2.11e-03,  3.17e-03,
     &  4.20e-03,  4.94e-03,  5.46e-03,  5.74e-03,  5.84e-03,
     &  5.61e-03,  3.74e-03,  1.64e-03,  5.33e-04,  1.21e-04,
     &  5.55e-05,  3.27e-05,  2.73e-05/

cccc
      end module

c=======================================================================
      subroutine o4cont(wl,sigo4)
c
c radiative cross-sections of o2 * o2 and o2 * n2 molecular complex
c
c input:
c  wl      wavelength in microns
c 
c output
c
c  sigo4   cross-section in km-1 
c          the optical depth across a layer due to o2*o2 and o2*n2
c          process is given by tau= sigo4*ff(z)*dz 
c
c          where ff(z)  = ((p(z)/pzero)*(tzero/t(z)))**2
c
c
c where the volume fractions of o2 and n2 have already been included in
c the sigo4 parameter.  The O2*N2 contribution is only included in the
c 1.26um band.  In this band (1.2-1.35um) a collisional efficiency of
c 0.2 of N2 * O2 comparaed to O2 * O2 is used.  Solomon et al. (1998)
c use a collisional efficiency of .1 to .3 compared to O2 this is the
c colored region in the figure).

c
c collisional efficiency of 0.1 is from Cho et al., 1963
c collisional efficiency of 0.3 is from Badger et al., 1965
c

      use params, only: kr
      use trcblk, only: xo4

      implicit none
      real(kr), parameter ::
     &     fraco2=.209,         ! volume fraction of o2
     &     fracn2=.781,         ! volume fraction of n2
     &     effn2=.2             ! efficiency factor for n2 * o2
                                ! compared to o2 * o2 collisions
      integer :: i, inm
      real(kr) ::  sig(1016), wnm, wl, f, sigo4, factor

c the strength of o2*o2 (and o2*n2) continuum absorption can be
c modified by calling o4cfac with a correction factor other than 1.0
c o4cfac is an entry point contained within this routine.

c o2*o2 cross-section for wavelength 335 to 1350 nm by 1 nm increments
c in units of km-1 loschmidt-2

      data (sig(i),i=1,100)/
     &   1.629e-03, 1.514e-03, 1.778e-03, 1.968e-03, 2.328e-03,
     &   3.308e-03, 5.013e-03, 7.222e-03, 8.699e-03, 7.791e-03,
     &   4.242e-03, 2.248e-03, 1.465e-03, 1.254e-03, 1.440e-03,
     &   1.658e-03, 2.137e-03, 2.743e-03, 3.510e-03, 4.703e-03,
     &   6.922e-03, 1.021e-02, 1.577e-02, 2.231e-02, 2.757e-02,
     &   2.889e-02, 2.148e-02, 1.135e-02, 5.251e-03, 2.520e-03,
     &   1.262e-03, 6.393e-04, 5.156e-04, 4.372e-04, 3.836e-04,
     &   4.187e-04, 4.413e-04, 4.661e-04, 5.012e-04, 8.247e-04,
     &   1.538e-03, 3.139e-03, 6.278e-03, 1.135e-02, 1.561e-02,
     &   1.658e-02, 1.277e-02, 7.392e-03, 3.853e-03, 1.906e-03,
     &   9.322e-04, 5.259e-04, 3.630e-04, 3.300e-04, 2.867e-04,
     &   2.268e-04, 2.145e-04, 1.670e-04, 1.073e-04, 6.600e-05,
     &   6.601e-05, 4.132e-06, 2.063e-05, 4.743e-05, 6.600e-05,
     &   2.142e-04, 2.331e-04, 2.310e-04, 2.226e-04, 2.142e-04,
     &   2.561e-04, 2.435e-04, 2.057e-04, 1.637e-04, 1.428e-04,
     &   1.344e-04, 1.469e-04, 1.973e-04, 1.763e-04, 2.015e-04,
     &   1.931e-04, 2.687e-04, 3.485e-04, 3.947e-04, 4.808e-04,
     &   5.647e-04, 5.857e-04, 5.500e-04, 4.829e-04, 4.115e-04,
     &   4.492e-04, 4.955e-04, 5.332e-04, 5.500e-04, 5.542e-04,
     &   5.962e-04, 6.046e-04, 6.298e-04, 6.550e-04, 6.634e-04/
      data (sig(i),i=101,200)/
     &   6.760e-04, 7.136e-04, 7.727e-04, 8.610e-04, 9.237e-04,
     &   1.092e-03, 1.306e-03, 1.610e-03, 1.999e-03, 2.479e-03,
     &   3.120e-03, 4.001e-03, 4.295e-03, 3.604e-03, 2.606e-03,
     &   1.772e-03, 1.222e-03, 9.066e-04, 7.435e-04, 6.970e-04,
     &   6.508e-04, 7.136e-04, 6.550e-04, 6.298e-04, 7.222e-04,
     &   7.852e-04, 8.482e-04, 9.992e-04, 1.209e-03, 1.469e-03,
     &   1.818e-03, 2.288e-03, 2.945e-03, 3.846e-03, 5.248e-03,
     &   7.243e-03, 9.928e-03, 1.310e-02, 1.686e-02, 2.128e-02,
     &   2.820e-02, 3.765e-02, 4.482e-02, 4.162e-02, 3.307e-02,
     &   2.325e-02, 1.544e-02, 9.686e-03, 5.672e-03, 3.271e-03,
     &   1.881e-03, 1.092e-03, 7.054e-04, 5.668e-04, 5.290e-04,
     &   5.248e-04, 5.165e-04, 5.878e-04, 6.172e-04, 7.642e-04,
     &   8.379e-04, 7.873e-04, 6.319e-04, 4.618e-04, 4.031e-04,
     &   3.312e-04, 3.525e-04, 3.142e-04, 2.506e-04, 2.505e-04,
     &   3.312e-04, 4.161e-04, 4.798e-04, 4.883e-04, 5.138e-04,
     &   6.242e-04, 7.385e-04, 8.368e-04, 9.088e-04, 9.935e-04,
     &   1.070e-03, 1.155e-03, 1.299e-03, 1.465e-03, 1.630e-03,
     &   1.770e-03, 2.046e-03, 2.526e-03, 3.407e-03, 4.204e-03,
     &   5.209e-03, 5.790e-03, 6.583e-03, 7.392e-03, 8.176e-03,
     &   8.867e-03, 9.486e-03, 9.793e-03, 9.771e-03, 8.860e-03/
      data (sig(i),i=201,300)/
     &   7.385e-03, 6.021e-03, 4.993e-03, 4.333e-03, 3.864e-03,
     &   3.562e-03, 3.312e-03, 3.155e-03, 3.062e-03, 3.057e-03,
     &   3.064e-03, 3.108e-03, 3.076e-03, 3.087e-03, 3.087e-03,
     &   3.108e-03, 3.270e-03, 3.376e-03, 3.605e-03, 3.876e-03,
     &   4.161e-03, 4.480e-03, 4.983e-03, 5.545e-03, 6.212e-03,
     &   7.165e-03, 8.375e-03, 9.835e-03, 1.157e-02, 1.371e-02,
     &   1.656e-02, 2.000e-02, 2.389e-02, 2.879e-02, 3.468e-02,
     &   4.097e-02, 4.793e-02, 5.485e-02, 6.183e-02, 6.747e-02,
     &   7.246e-02, 7.610e-02, 7.798e-02, 7.741e-02, 7.157e-02,
     &   5.942e-02, 4.494e-02, 3.408e-02, 2.577e-02, 1.958e-02,
     &   1.469e-02, 1.107e-02, 8.276e-03, 6.199e-03, 4.696e-03,
     &   3.562e-03, 2.667e-03, 2.046e-03, 1.660e-03, 1.420e-03,
     &   1.308e-03, 1.240e-03, 1.223e-03, 1.223e-03, 1.227e-03,
     &   1.355e-03, 1.470e-03, 1.559e-03, 1.708e-03, 1.810e-03,
     &   1.950e-03, 2.379e-03, 2.932e-03, 3.176e-03, 3.611e-03,
     &   4.036e-03, 4.673e-03, 5.417e-03, 6.331e-03, 7.400e-03,
     &   8.454e-03, 9.700e-03, 1.124e-02, 1.308e-02, 1.538e-02,
     &   1.794e-02, 2.098e-02, 2.450e-02, 2.885e-02, 3.305e-02,
     &   3.751e-02, 4.163e-02, 4.562e-02, 4.862e-02, 5.059e-02,
     &   5.112e-02, 5.071e-02, 4.858e-02, 4.496e-02, 4.035e-02/
      data (sig(i),i=301,400)/
     &   3.510e-02, 2.993e-02, 2.491e-02, 2.077e-02, 1.699e-02,
     &   1.368e-02, 1.059e-02, 8.098e-03, 6.182e-03, 4.686e-03,
     &   3.527e-03, 2.585e-03, 1.920e-03, 1.461e-03, 1.147e-03,
     &   9.009e-04, 7.264e-04, 5.651e-04, 4.291e-04, 3.059e-04,
     &   1.869e-04, 8.069e-05, 3.399e-04, 3.781e-04, 3.803e-04,
     &   2.740e-04, 1.487e-04, 0.000e+00, 0.000e+00, 0.000e+00,
     &   0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00,
     &   0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00,
     &   0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00,
     &   0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00,
     &   0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00,
     &   0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00,
     &   0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00,
     &   0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00,
     &   0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00,
     &   0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00,
     &   0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00,
     &   0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00,
     &   0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00,
     &   0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00/
      data (sig(i),i=401,500)/100*0./
      data (sig(i),i=501,600)/100*0./
      data (sig(i),i=601,700)/
     &   0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00,
     &   0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00,
     &   0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00,
     &   0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00,
     &   0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00,
     &   0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00,
     &   0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00,
     &   0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00,
     &   0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00,
     &   0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00,
     &   0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00,
     &   0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00,
     &   0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00,
     &   0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00, 0.000e+00,
     &   0.000e+00, 3.856e-04, 4.152e-04, 4.873e-04, 6.440e-04,
     &   7.585e-04, 9.614e-04, 1.110e-03, 1.389e-03, 1.604e-03,
     &   1.915e-03, 2.169e-03, 2.366e-03, 2.680e-03, 2.904e-03,
     &   3.216e-03, 3.485e-03, 3.936e-03, 4.402e-03, 4.898e-03,
     &   5.292e-03, 5.885e-03, 6.376e-03, 7.093e-03, 7.692e-03,
     &   8.397e-03, 9.116e-03, 1.002e-02, 1.090e-02, 1.193e-02/
      data (sig(i),i=701,800)/
     &   1.298e-02, 1.394e-02, 1.513e-02, 1.620e-02, 1.746e-02,
     &   1.880e-02, 2.046e-02, 2.200e-02, 2.347e-02, 2.516e-02,
     &   2.703e-02, 2.872e-02, 3.090e-02, 3.312e-02, 3.547e-02,
     &   3.829e-02, 4.120e-02, 4.441e-02, 4.798e-02, 5.221e-02,
     &   5.628e-02, 6.090e-02, 6.519e-02, 6.978e-02, 7.357e-02,
     &   7.699e-02, 7.934e-02, 8.133e-02, 8.311e-02, 8.479e-02,
     &   8.532e-02, 8.525e-02, 8.368e-02, 8.105e-02, 7.656e-02,
     &   7.211e-02, 6.772e-02, 6.382e-02, 5.976e-02, 5.551e-02,
     &   5.163e-02, 4.797e-02, 4.445e-02, 4.119e-02, 3.795e-02,
     &   3.539e-02, 3.286e-02, 3.062e-02, 2.823e-02, 2.623e-02,
     &   2.438e-02, 2.258e-02, 2.102e-02, 1.946e-02, 1.811e-02,
     &   1.669e-02, 1.542e-02, 1.383e-02, 1.297e-02, 1.212e-02,
     &   1.135e-02, 1.078e-02, 9.703e-03, 8.981e-03, 7.984e-03,
     &   7.335e-03, 6.876e-03, 5.910e-03, 5.756e-03, 5.756e-03,
     &   5.211e-03, 4.707e-03, 4.176e-03, 3.589e-03, 3.347e-03,
     &   2.909e-03, 2.461e-03, 2.072e-03, 2.260e-03, 2.118e-03,
     &   2.042e-03, 1.796e-03, 2.025e-03, 1.483e-03, 1.550e-03,
     &   1.047e-03, 8.005e-04, 7.918e-04, 1.038e-03, 9.066e-04,
     &   6.864e-04, 8.303e-04, 3.433e-04, 7.118e-04, 3.685e-04,
     &   2.225e-04, 1.950e-04, 1.694e-04, 0.000e+00, 3.816e-05/
      data (sig(i),i=801,900)/
     &   0.000e+00, 0.000e+00, 8.448e-05, 8.314e-05, 8.179e-05,
     &   8.047e-05, 7.912e-05, 7.778e-05, 7.643e-05, 7.509e-05,
     &   7.376e-05, 7.242e-05, 7.107e-05, 6.973e-05, 6.838e-05,
     &   6.706e-05, 6.571e-05, 6.437e-05, 6.302e-05, 6.168e-05,
     &   6.033e-05, 5.901e-05, 5.767e-05, 5.632e-05, 5.498e-05,
     &   5.363e-05, 5.231e-05, 5.096e-05, 4.962e-05, 4.827e-05,
     &   4.693e-05, 4.560e-05, 4.426e-05, 4.291e-05, 4.157e-05,
     &   4.022e-05, 3.888e-05, 3.755e-05, 3.621e-05, 3.486e-05,
     &   3.352e-05, 3.217e-05, 3.085e-05, 2.951e-05, 2.816e-05,
     &   2.682e-05, 2.547e-05, 2.415e-05, 2.280e-05, 2.146e-05,
     &   2.011e-05, 1.877e-05, 1.744e-05, 1.610e-05, 1.475e-05,
     &   1.341e-05, 1.206e-05, 1.072e-05, 9.394e-06, 8.049e-06,
     &   6.704e-06, 5.359e-06, 4.014e-06, 2.690e-06, 1.345e-06,
     &   1.631e-07, 7.642e-04, 7.021e-04, 9.978e-04, 1.181e-03,
     &   1.376e-03, 1.540e-03, 1.945e-03, 2.219e-03, 2.785e-03,
     &   3.181e-03, 3.620e-03, 4.111e-03, 4.435e-03, 4.940e-03,
     &   5.498e-03, 5.845e-03, 6.406e-03, 6.792e-03, 7.535e-03,
     &   8.471e-03, 9.123e-03, 9.928e-03, 1.090e-02, 1.184e-02,
     &   1.273e-02, 1.382e-02, 1.504e-02, 1.614e-02, 1.745e-02,
     &   1.873e-02, 2.049e-02, 2.211e-02, 2.381e-02, 2.564e-02/
      data (sig(i),i=901,1000)/
     &   2.708e-02, 2.929e-02, 3.117e-02, 3.308e-02, 3.547e-02,
     &   3.795e-02, 4.085e-02, 4.368e-02, 4.584e-02, 4.911e-02,
     &   5.217e-02, 5.514e-02, 5.829e-02, 6.244e-02, 6.611e-02,
     &   7.059e-02, 7.524e-02, 8.019e-02, 8.511e-02, 9.144e-02,
     &   9.839e-02, 1.053e-01, 1.135e-01, 1.206e-01, 1.291e-01,
     &   1.364e-01, 1.437e-01, 1.502e-01, 1.553e-01, 1.592e-01,
     &   1.625e-01, 1.659e-01, 1.689e-01, 1.702e-01, 1.705e-01,
     &   1.692e-01, 1.657e-01, 1.593e-01, 1.517e-01, 1.439e-01,
     &   1.370e-01, 1.290e-01, 1.215e-01, 1.144e-01, 1.078e-01,
     &   1.006e-01, 9.426e-02, 8.862e-02, 8.332e-02, 7.684e-02,
     &   7.239e-02, 6.768e-02, 6.348e-02, 5.964e-02, 5.561e-02,
     &   5.205e-02, 4.867e-02, 4.585e-02, 4.268e-02, 4.010e-02,
     &   3.758e-02, 3.519e-02, 3.295e-02, 3.035e-02, 2.761e-02,
     &   2.599e-02, 2.470e-02, 2.290e-02, 2.144e-02, 1.951e-02,
     &   1.870e-02, 1.704e-02, 1.621e-02, 1.464e-02, 1.326e-02,
     &   1.290e-02, 1.173e-02, 1.145e-02, 1.100e-02, 9.337e-03,
     &   8.774e-03, 8.380e-03, 7.983e-03, 6.775e-03, 6.369e-03,
     &   5.582e-03, 4.838e-03, 4.415e-03, 4.322e-03, 3.789e-03,
     &   4.077e-03, 3.747e-03, 3.262e-03, 3.115e-03, 3.155e-03,
     &   2.567e-03, 2.656e-03, 1.878e-03, 1.418e-03, 1.919e-03/
      data (sig(i),i=1001,1016)/
     &   1.899e-03, 1.936e-03, 1.750e-03, 1.886e-03, 1.701e-03,
     &   7.949e-04, 4.906e-04, 4.434e-04, 1.006e-03, 5.243e-04,
     &   5.159e-04, 1.691e-04, 0.000e+00, 1.606e-04, 2.963e-05,
     &   0.000e+00/
cccc
      wnm=1000.*wl
      inm=wnm
      f=wnm-inm
      inm=inm-335+1
      sigo4=0.
      if(inm.ge.1.and.inm.le.1015) then 
        factor=fraco2**2
        if(wl.gt.1.2) factor=fraco2*(fraco2+effn2*fracn2)
        sigo4=xo4*factor*(sig(inm)*(1.-f)+sig(inm+1)*f)
        !write(*,*) 'wl,wnm,inm,f,sig(inm),sig(inm+1),sigo4'
        !write(*,*) wl,wnm,inm,f,sig(inm),sig(inm+1),sigo4
      endif
      return
      end
c=======================================================================
      subroutine volmix(zz,vfn2,vfo2,vfco2,vfch4,vfn2o,vfco,
     &                  vfno2,vfso2,vfnh3,vfno,vfhno3)
c
c   called by module absint
c
c volume fractions in ppm
c   input:   z         altitude in km
c
c   output:  vf??      volume fraction of atmospheric specie in ppm
c                      the volume fractions are based on LOWTRAN's 
c                      US standard atmosphere, 1976 

      use params, only: kr
      use trcblk, only: alt, n2, o2, co2, ch4, n2o, co, no2, so2, nh3,
     &     no, hno3, modify, un2, uo2, uco2, uch4, un2o, uco, uno2,
     &     uso2, unh3, uno, uhno3

      implicit none

      integer :: k=0, kp

      real(kr), parameter :: zbot=0., ztop=100.
      real(kr) ::  z, zz, f, vfn2, vfo2, vfco2, vfch4, vfn2o, vfco,
     &     vfno2, vfso2, vfnh3, vfno, vfhno3

      z=max(zbot,min(zz,ztop))

      if(z.lt.25.) then
        k=int(z)+1
      elseif(z.lt.50.) then
        k=26+(z-25.)/5.
      elseif(z.lt.70.) then
        k=31
      elseif(z.le.100.) then
        k=32
      endif

      kp=k+1
      f=(z-alt(k))/(alt(kp)-alt(k))

      vfn2     = n2(k)  * (1.-f) + n2(kp)  * f 
      vfo2     = o2(k)  * (1.-f) + o2(kp)  * f 
      vfco2    = co2(k) * (1.-f) + co2(kp) * f 
      vfch4    = ch4(k) * (1.-f) + ch4(kp) * f 
      vfn2o    = n2o(k) * (1.-f) + n2o(kp) * f 
      vfco     = co(k)  * (1.-f) + co(kp)  * f 
      vfno2    = no2(k) * (1.-f) + no2(kp) * f 
      vfso2    = so2(k) * (1.-f) + so2(kp) * f 
      vfnh3    = nh3(k) * (1.-f) + nh3(kp) * f 
      vfno     = no(k)  * (1.-f) + no(kp)  * f 
      vfhno3   = hno3(k)* (1.-f) + hno3(kp)* f 

      if(modify.eq.1) then
        vfn2     =  vfn2  * un2  
        vfo2     =  vfo2  * uo2  
        vfco2    =  vfco2 * uco2 
        vfch4    =  vfch4 * uch4 
        vfn2o    =  vfn2o * un2o 
        vfco     =  vfco  * uco  
        vfno2    =  vfno2 * uno2 
        vfso2    =  vfso2 * uso2 
        vfnh3    =  vfnh3 * unh3 
        vfno     =  vfno  * uno  
        vfhno3   =  vfhno3* uhno3
      endif

c      if(z.lt. .5) then
c        write(*,'(a/(10es11.3))') 'alt',alt
c        write(*,'(a/(10es11.3))') 'o2',o2
c        write(*,'(a/(10es11.3))') 'n2',n2
c        write(*,'(a/(10es11.3))') 'co2',co2
c      endif
c
c      write(*,'(a,(10es11.3))') 'alt,o2,n2,co2 ',z,vfo2,vfn2,vfco2

      return
      end
c=======================================================================      
      subroutine modmix(xn2,xo2,xco2,xch4,xn2o,xco,xno2,
     &     xso2,xnh3,xno,xhno3,xxo4)

c Modify values of un2 uo2 uco2 uch4 un2o uco uno2 uso2 unh3 uno uhno3
c and xo4 stored in module trcblk

      use params, only: kr
      use trcblk, only: n2, o2, co2, ch4, n2o, co, no2, so2, nh3,
     &     no, hno3, modify, un2, uo2, uco2, uch4, un2o, uco, uno2,
     &     uso2, unh3, uno, uhno3, xo4
      implicit none

      real(kr) ::  xn2, xo2, xco2, xch4, xn2o, xco, xno2, xso2, xnh3,
     &     xno, xhno3, xxo4, test

      if(xn2  .ge. 0. )  un2  = xn2  / n2(1)   
      if(xo2  .ge. 0. )  uo2  = xo2  / o2(1)   
      if(xco2 .ge. 0. )  uco2 = xco2 / co2(1)  
      if(xch4 .ge. 0. )  uch4 = xch4 / ch4(1)  
      if(xn2o .ge. 0. )  un2o = xn2o / n2o(1)  
      if(xco  .ge. 0. )  uco  = xco  / co(1)   
      if(xno2 .ge. 0. )  uno2 = xno2 / no2(1)  
      if(xso2 .ge. 0. )  uso2 = xso2 / so2(1)  
      if(xnh3 .ge. 0. )  unh3 = xnh3 / nh3(1)  
      if(xno  .ge. 0. )  uno  = xno  / no(1)   
      if(xhno3.ge. 0. )  uhno3= xhno3/ hno3(1) 

      xo4=xxo4

      test=max(xn2,xo2,xco2,xch4,xn2o,xco,xno2,xso2,xnh3,xno,xhno3)

      if(test .gt. -0.99) modify=1

c 1    format(a,11es11.3)
c      write(*,1) 'x',xn2,xo2,xco2,xch4,xn2o,xco,xno2,xso2,xnh3,xno,xhno3
c      write(*,1) 'u',un2,uo2,uco2,uch4,un2o,uco,uno2,uso2,unh3,uno,uhno3

      return
      end   
c=======================================================================

      subroutine gasinit(wllo,wlhi,nvnu,nz,z,p,t,rhaer,idb)
c 
c purpose:  read in CKATM file, initialize k-distribution arrays
c
c input:
c   wllo    lower wavelength limit 
c   wlhi    upper wavelength limit 
c           NOTE: wllo and wlhi are ignored if wllo == wlhi
c
c   idb     diagnostics print flag (print if non-zero)
c   
c
c output:
c   nz      number of computational levels
c   z       altitude array z(1:nz) z(1)=0
c   p       pressure array p(1:nz)
c   t       temperature array t(1:nz)
c   rhaer   relative humidity of bottom layer
c   nvnu    number of wavenumber points

      use params, only: mxly, kr

      implicit none

      real :: vnu,vnu1,vnu2
      real(kr) :: h2oden,z(mxly),p(mxly),t(mxly),rhaer,relhum,wvhi,
     &     wllo,wlhi,vnulo,vnuhi,vn
      integer :: i, j, nz, nvnu, idb, iv, ib, nbands, nk, niter

      open(12, file='CKATM',status='old',form='formatted')

      read(12,*) nz,h2oden
      read(12,*) z(1:nz)
      read(12,*) p(1:nz)
      read(12,*) t(1:nz)

      if(z(1).gt.z(nz)) then    ! invert atmospheric profile arrays
        z(1:nz)=z(nz:1:-1)
        p(1:nz)=p(nz:1:-1)
        t(1:nz)=t(nz:1:-1)
      endif
      if(nz.gt.mxly) then
        print *,'gasinit --- nz gt mxly ',nz,mxly
        stop
      endif
      if(rhaer.lt.0.) rhaer=relhum(t(1),h2oden)

      if(idb.gt.0) then
        print '(2a15)','nz','whnz'
        print '(i15,f15.5)',nz,h2oden
        print '(a/(10es11.3))','z',z(1:nz)
        print '(a/(10es11.3))','p',p(1:nz)
        print '(a/(10es11.3))','t',t(1:nz)
      endif

      close(12)
     
      open(12,file='CKTAU',status='old',form='unformatted')
      nvnu=0
      niter=0
      if(wllo.eq.wlhi) then
        vnulo=0.
        vnuhi=huge(0.)
      else
        vnuhi=10000./wllo
        vnulo=10000./wlhi
      endif
      if(idb.eq.2) print '(4a5,3a10)',
     &     'iv','ib','nbnd','nk','vnu','vnu1','vnu2'
      do
        read(12,end=10) iv,ib,nbands,nk,vnu,vnu1,vnu2
        if(vnu.gt.vnuhi) cycle
        if(vnu.lt.vnulo) exit
        if(idb.eq.2) print '(4i5,3f10.2)',iv,ib,nbands,nk,vnu,vnu1,vnu2
        niter=niter+nk
        if(ib.eq.1) nvnu=nvnu+1
        if(wvhi.eq.0.) wvhi=vnu
      enddo
      if(nvnu.eq.0) then
        print *,'Error --- gasinit'
        print *,'no frequency samples within ',wllo,wlhi
        stop
      endif
 10   continue
      if(idb.ne.0) then
        print '(2a10,4a12)','nwl','niter','wv1','wv2','wl1','wl2'
        print '(2i10,4f12.4)',nvnu,niter,vnu,wvhi,10000./wvhi,10000./vnu
        stop
      endif
      close(12)

      return 
      end

c=======================================================================
      subroutine gasset(kdist,wl,uu,amu0,nz,z,nk,gwk,dtauk,dtaugc,idb)

c  setup lowtran k-distribution model, 
 
c input:
c   kdist   k-distribution mode index
c            0  tau set to -log(transmission_vertical_path)
c            1  no renormalization of lowtran k-distribution tau
c            2  renormalize (clear sky situation)
c            3  ramp correction factor to one as tauscat goes > 1
c   wl      wavelength
c   uu      absorption integrals
c   amu0    cosine of solar zenith
c   nz      number of levels
c   z       altitude array
c   idb     debug flag
c output:
c   gwk     k-distribution weights
c   dtauk   k-distribution optical depth increments
c   dtaugc  continuum

c in lowtran mode (kdist.ge.1) gas optical depth increments corrected
c for solar zenith angle are stored in  dtauk(i,4:6).
c Uncorrected values are stored in      dtauk(i,1:3)


      use params, only: mxly, kr, mxq, one, mxkd
      implicit none

      integer, parameter :: mk=3

      real(kr) :: dtcs(mxly), dtls(mxly), dtcv(mxly), dtlv(mxly),
     &     tk(mxly,mk), dtk(mxly,mk), wtk(mxly,mk), work(mxly,mk),
     &     tgl(mk), tglc(mk), test, tauls, cf, amu0, wl, wnorm,
     &     uu(mxq,mxly), z(mxly), gwk(mxkd), dtauk(mxly,mxkd),
     &     dtaugc(mxly),eps=tiny(one)

      integer :: idb,nk,kdist,nz,k,j

      call taugas(wl,uu,one,nz,z,dtcv,dtlv,idb) ! vertical path
      if(amu0.gt.0.) then
        call taugas(wl,uu,amu0,nz,z,dtcs,dtls,0) ! slant path
      else
        dtcs=dtcv
        dtls=dtlv
      endif
      
      dtaugc(1:nz)=dtcv(1:nz)
      
      if(kdist.eq.0.or.sum(dtlv(1:nz)).lt..01) then
        nk=1
        gwk(1)=1.
      else
        call kdistr(nz,mxly,mxq,uu,dtk,tk,wtk,work) 
        test=max(tk(nz,1),tk(nz,2),tk(nz,3))
        if(test.lt.0.01) then
          nk=1
          gwk(1)=1.
        else
          nk=3
          do k=1,nk
            gwk(k)=sum(dtlv(1:nz)*wtk(1:nz,k))
          enddo
          wnorm=sum(gwk(1:nk))
          if(wnorm.eq.0) then
            gwk(1)=1.
          else
            gwk(1:nk)=gwk(1:nk)/wnorm
          endif
        endif            
      endif
      
c NOTE: gas continua absorption is grouped with other continuous
c       opacities,  this assumes dtcs=dtcv/amu
      
      if(kdist.eq.0.or.nk.eq.1) then
        dtauk(1:nz,1)=dtlv(1:nz)
        dtauk(1:nz,1+mk)=amu0*dtls(1:nz)
      else
        do k=1,nk
          dtauk(1:nz,k)=dtk(1:nz,k)
          dtauk(1:nz,k+mk)=dtk(1:nz,k)
        enddo
        
        if(kdist.ge.2.and.amu0.gt.0.) then
          tauls=0.
          tgl(1:3)=0.
          tglc(1:3)=0.          ! corrected to match slant path transmission
          do j=1,nz
            tauls=tauls+dtls(j)
            tgl(1:3)=dtk(j,1:3)+tgl(1:3)
            tglc(1:3)=dtk(j,1:3)+tglc(1:3)
            call taucor(gwk,tglc,amu0,tauls,cf)
            dtauk(j,4:6)=tglc(1:3)*(cf-1.0)+dtk(j,1:3)
            tglc(1:3)=cf*tglc(1:3)
          enddo
        endif
      endif
      
      if(amu0.le.0.) dtauk(1:nz,1+mk)=dtlv(1:nz)
      
      if(idb.eq.3) then
        if(nk.gt.1) then
          print '(a,f11.4,a,3es11.3)','wl=',wl,'  w1,w2,w3: ',gwk(1:3)
          print '(7a13)','dtauk1','dtauk2','dtauk3',
     &         '-ln(trns)','-ln(trns_c)'
          tglc(1:3)=0.
          tgl(1:3)=0. 
          do j=1,nz
            tglc(1:3)=tglc(1:3)+dtauk(j,1:3) ! reuse tglc
            tgl(1:3)=tgl(1:3)+dtauk(j,mk+1:mk+3) ! reuse tglc
            print '(5es13.3)',dtk(j,1:3),
     &           -log(max(sum(gwk(1:3)*exp(-tglc(1:3))),eps)),
     &           -log(max(sum(gwk(1:3)*exp(-tgl(1:3))),eps))
          enddo
        endif
      endif
      return
      end
c=======================================================================
      subroutine depthscl(kdist, kd, nk, ib, nz, wl, dtaur, dtaua,
     &     waer, dtauc, wcld, spowder, gwk, dtauk, dtaugc, wt,
     &     dtau, wreal, idb)

c input:
c   kdist   k-distribution mode index
c           -1  read k-distribution dtauk, gwk from LOUTF
c            0  tau set to -log(transmission_vertical_path)
c               slant optical depth used when tau_scat < 1 and wl < 4
c            1  no renormalization of lowtran k-distribution tau
c            2  corrected to solar beam slant path transmission
c            3  corrected to solar beam slant path transmission when
c               tau_scat < 1 and wl < 4
c
c  kd      k-distribution index
c  nk      number of k-distribution passes
c  ib      sub-band index
c  nz      number of vertical layers
c  wl      wavelength
c  dtaur   rayleigh scattering optical depth increment
c  dtaua   aerosol scattering optical depth increment
c  waer    aerosol single scattering albedo
c  dtauc   cloud optical depth increment
c  wcld    cloud single scattering albedo
c  spowder surface powder flag
c  gwk     k-distribution weights
c  dtauk   k-distribution optical depths for absorption by molecular lines
c  dtaugc  gas continuum optical depth
c  idb     debug flag
c
c output:
c  dtau   atmospheric optical depth increment
c  wreal   weighted single scattering albedo


      use params, only: kr, one, mxly
      implicit none
      
      integer :: kd, nk, nz, idb, kdist, i, ib, iw

      integer, parameter :: mk=3 ! number of lowtran k-dist terms

      real(kr) :: dtaur(*), dtaua(*), waer(*), dtauc(*), wcld(*),
     &     dtau(*), wreal(*), wt, dtaug(nz), afac, tglv, tgls,
     &     tsc, ramp, wl, gwk(*), dtauk(mxly,*), dtaugc(*)

      logical :: spowder
                                ! get gas optical depth

      wt=gwk(kd)
      if(kdist.eq.-1) then      ! tau from LOUTF
        dtaug(1:nz)=dtauk(1:nz,kd)
      elseif(kdist.eq.0.or.nk.eq.1) then   ! tau=-log(transmission)
        wt=1.
        tsc=0.
        tglv=0.
        tgls=0.
        do i=1,nz
          tglv=tglv+dtauk(i,1) ! vertical path
          tgls=tgls+dtauk(i,1+mk) ! amu0 * slant path
          tsc=tsc+dtaur(i)+dtauc(i)+dtaua(i)
          afac=1.
          if(tglv.gt..001) afac=tgls/tglv
          call rolloff(wl,tsc,ramp)
          afac=afac*ramp+1.-ramp
          dtaug(i)=dtaugc(i)+dtauk(i,1)*afac
        enddo
      elseif(kdist.eq.1) then   ! uncorrected
        dtaug(1:nz)=dtaugc(1:nz)+dtauk(1:nz,kd)
      elseif(kdist.eq.2) then   ! corrected to slant path transmission
        dtaug(1:nz)=dtaugc(1:nz)+dtauk(1:nz,kd+mk)
      else                      ! ramp to uncorrected 
        tsc=0.
        do i=1,nz
          tsc=tsc+dtaur(i)+dtauc(i)+dtaua(i)
          call rolloff(wl,tsc,ramp)
          dtaug(i)=dtaugc(i)+dtauk(i,kd)*(1.-ramp)+dtauk(i,kd+mk)*ramp
        enddo
      endif
                                ! zero out optical depth in sub-surface layer
      if(spowder) then 
        dtaur(nz)=0.
        dtaug(nz)=0.
      endif
                                ! total optical depth and ssa
      do i=1,nz
        dtau(i)=dtaug(i)+dtauc(i)+dtaua(i)+dtaur(i)
        if(dtau(i).gt.tiny(one)) then
          wreal(i)=(dtauc(i)*wcld(i)+dtaua(i)*waer(i)+dtaur(i))/dtau(i)
        else
          wreal(i)=0.
        endif
      enddo

      if(idb.ne.0) then
        print '(a,f10.3,5x,a,i2,":",i2,5x,a,i2,5x,a,f12.6)',
     &       "wl=",wl,"kd=",kd,nk,"ib=",ib,"wt=",wt
        print '(5x,8a11)','dtauc','wcld','dtaua','waer','dtaur',
     &       'dtaug','wreal','dtau'
        do i=1,nz
          print '(i5,8es11.3)',i,dtauc(i),wcld(i),dtaua(i),waer(i),
     &         dtaur(i),dtaug(i),wreal(i),dtau(i)
        enddo
        print '(5x,8a11)','---------','','---------','',
     &       '---------','---------','','---------'
        print '(5x,es11.3,11x,es11.3,11x,2es11.3,11x,es11.3)',
     &       sum(dtauc(1:nz)),sum(dtaua(1:nz)),sum(dtaur(1:nz)),
     &       sum(dtaug(1:nz)),sum(dtau(1:nz))
      endif
      return
c-----
      contains
c-----
      subroutine rolloff(wl,tsc,ramp)

c purpose: compute roll-off factor for transition from full slant-path
c          correction to uncorrected vertical optical depths. 
c
c input:
c  wl      wavelength
c  tsc     scattering optical depth
c output:
c  ramp    roll-off factor (drops to zero when either the scattering
c          optical depth is large, or the wavelength exceeds wlhi)

      use params, only: one,zero
      real(kr) :: wl, tsc, ramp
      real(kr), parameter :: wllo=3.9,  ! wavelength roll-off lower limit
     &                       wlhi=4.1   ! wavelength roll-off upper limit

      ramp=(wlhi-wl)/(wlhi-wllo)
      ramp=max(min(one,ramp),zero)
      ramp=ramp*exp(1.-max(tsc,one))     
      return
      end subroutine rolloff

      end subroutine depthscl
c=======================================================================
      subroutine taucor(gwk,tau,amu,utau,cf)
c
c purpose: find a correction factor, cf, which corrects the
c  k-distribution optical depths so that 
c
c   sum(gwk(1:3)*exp(-cf*tau(1:3)/amu))=exp(-utau)
c
c input:
c 
c   gwk         k-distribution weights
c   tau         k-distribution optical depths
c   amu         cosine of solar zenith
c   utau        optical depth along slant path due to line absorption
c
c output:
c   cf          correction factor,  tau_corrected=cf*tau_uncorrected
c
c  
      use params, only: kr
      implicit none
      integer :: i
      real(kr) :: tau(3), gwk(3), amu, utau, cf, ff, f, fp, dcf

      cf=1.

      if(utau.gt.12.0) return

      do i=1,20
        ff=sum(gwk*exp(-cf*tau/amu))
        f=log(ff)+utau
        if(abs(f) .lt. 0.000001) return
        fp=-sum(gwk*exp(-cf*tau/amu)*tau)/(ff*amu) ! df/dcf
        dcf=-f/fp
        cf=cf+dcf
      enddo

      write(*,'(8a12)') '------------','gwk  ','------------',
     &                  '------------','tau  ','------------',
     &     'amu','utau'
      write(*,'(8es12.4)') gwk(1:3),tau(1:3),amu,utau
      stop 'TAUCOR: iteration did not converge'

      end

c=======================================================================
      subroutine readk(nz,wllo,wlhi,wl,wvnmlo,wvnmhi,
     &     ib,nb,nk,etirr,ewcoef,gwk,dtauk,idb)
c
c purpose: read k-distribution file LLKDST
c
c input: 
c  nz       number of atmospheric levels (read from CKATM by gasinit)
c  nf       solar model selector
c  wllo     lower wavelength limit
c  wlhi     upper wavelength limit 
c           (if wllo=wlhi, all wavelengths in CKTAU are used)
c  idb      debug flag
c
c output:
c  wl       wavelength
c  wvnmlo   lower limit wavelength
c  wvnmhi   upper limit wavelenght
c  ib       band index (counts down to 1)
c  nb       number of sub-bands
c  nk       number of k-distribution terms (returns zero at eof)
c  etirr    extra-terrestrial direct normal flux (w/m2)
c  ewcoef   equivalent_width/full_width
c  gwk      k-distribution weights 
c  dtauk    k-distribution optical depth increments

      use params, only: kr, mxkd, mxly
      implicit none
      
      integer :: nf,iv,ib,nb,nk,nz,idb,iostat,k
      logical :: first=.true. 
      
      real(kr) :: wllo,wlhi,vnu,wvnmlo,wvnmhi,wl,etirr,ewcoef,
     &     gwk(mxkd),dtauk(mxly,mxkd),dwl,vnulo,vnuhi,bedge

      real(4) :: vnu0,vnu1,vnu2,etf,ewc,gw(mxkd),dtk(mxly,mxkd)

      real(kr),save :: transum=0.,solsum=0.

c.....

      if(first) open(12,file='CKTAU',status='old',form='unformatted')

      if(wllo.eq.wlhi) then 
        vnulo=0.
        vnuhi=huge(0.)
      else
        vnulo=10000./wlhi
        vnuhi=10000./wllo
      endif

      nk=0

      do 
        read(12,end=10) iv,ib,nb,nk,vnu0,vnu1,vnu2,etf,ewc,
     &       gw(1:nk), dtk(1:nz,1:nk)
        if(vnu0.lt.vnulo) then
          nk=0
          return
        endif
        if(vnu0.le.vnuhi) exit
      enddo
                                ! convert to real kind kr
      wvnmlo=vnu1
      wvnmhi=vnu2
      vnu=vnu0
      etirr=etf 
      
      ewcoef=ewc
      gwk(1:nk)=gw(1:nk)
      dtauk(1:nz,1:nk)=dtk(1:nz,1:nk)

      if(min(wvnmlo,wvnmhi).le.0.) then
        print *,'readk --- wvnmlo,wvnmhi: ',wvnmlo,wvnmhi
        stop
      endif

      wl=10000./vnu0
      dwl=10000./wvnmlo-10000./wvnmhi

      if(minval(dtauk).lt.0.) then
        call prntau
        stop 'readk --- negative dtauk'
      endif

      if(idb.eq.1) call prntrns
      if(idb.eq.2) call prntsol
      if(idb.eq.3) call prntau
        
      first=.false.
      return

 10   continue

      nk=0
      close(12)

      return

      contains
c.......................................................................
      subroutine prntau
      integer :: i
      print '(3a10,5a12)',
     &     'iv','ib','nk','vnu','wvnmlo','wvnmhi','etirr','ewcoef' 
      print '(3i10,5f12.4)',iv,ib,nk,vnu,wvnmlo,wvnmhi,etirr,ewcoef
      print '(a/(16es11.3))','gwk',gwk(1:nk)
      print '(16(a9,i2.2))',("    tauk_",i,i=1,nk)
      do i=1,nz
        print '(16es11.3)',dtauk(i,1:nk)
      enddo
      end subroutine prntau
c.......................................................................

      subroutine prntrns
      real(kr) :: etxxx,etmin=1.e-10
      etxxx=max(etirr,etmin)
      solsum=solsum+etxxx
      transum=transum+etxxx*sum(gw(1:nk)*exp(-sum(dtauk(1:nz,1:nk),1)))
      if(ib.eq.1) then
        print '("wl,trans: ",2f13.6)',10000./vnu,transum/solsum
        transum=0.
        solsum=0.
      endif
      return
      end subroutine prntrns
c.......................................................................

      subroutine prntsol
      solsum=solsum+etirr
      transum=transum+dwl*ewcoef
      if(ib.eq.1) then
        print '("wl,solirr: ",2f13.6)', 10000./vnu,solsum/transum 
        transum=0.
        solsum=0.
      endif
      return
      end subroutine prntsol

c.......................................................................

      end
