nbdev_cards
================

<!-- WARNING: THIS FILE WAS AUTOGENERATED! DO NOT EDIT! -->

A deck of cards demo of [nbdev](https://nbdev.fast.ai) based on ideas
from “Think Python 2nd Edition” by Allen B. Downey.

## pip install

The [nbdev-cards2022](https://pypi.org/project/nbdev-cards2022/) package
was uploaded to [PyPI](https://pypi.org/) and can be easily installed
using the below command.

`pip install nbdev-cards2022`

## conda install

The [nbdev-cards2022](https://anaconda.org/hdocmsu/nbdev-cards2022) was
also uploaded to [Anaconda](https://anaconda.org/) and can be installed
using the below command.

`conda install -c hdocmsu nbdev-cards2022`

## How to use

import the card and deck modules

``` python
from nbdev_cards.card import *
from nbdev_cards.deck import *
```

This lib provids a
[`Card`](https://hdocmsu.github.io/nbdev_cards/card.html#card) class
that you can use to create, display, and compare playing cards.

``` python
Card(2,3)
```

    3♥

display all suits

``` python
suits
```

    ['♣', '♦', '♥', '♠']

display all ranks

``` python
ranks
```

    [None, 'A', '2', '3', '4', '5', '6', '7', '8', '9', '10', 'J', 'Q', 'K']

[`Deck`](https://hdocmsu.github.io/nbdev_cards/deck.html#deck) class can
be called to generate a deck of playing card. Initially, the deck is
ordered.

``` python
deck = Deck()
deck
```

    A♣; 2♣; 3♣; 4♣; 5♣; 6♣; 7♣; 8♣; 9♣; 10♣; J♣; Q♣; K♣; A♦; 2♦; 3♦; 4♦; 5♦; 6♦; 7♦; 8♦; 9♦; 10♦; J♦; Q♦; K♦; A♥; 2♥; 3♥; 4♥; 5♥; 6♥; 7♥; 8♥; 9♥; 10♥; J♥; Q♥; K♥; A♠; 2♠; 3♠; 4♠; 5♠; 6♠; 7♠; 8♠; 9♠; 10♠; J♠; Q♠; K♠

`shuffle()` method could be used to shuffle the deck.

``` python
deck.shuffle()
deck
```

    6♠; A♦; 8♣; 3♠; A♣; 7♠; K♥; 9♠; 6♣; A♠; 4♥; 5♦; K♠; 3♣; 3♦; 6♦; 2♦; Q♥; 5♠; 9♦; 2♠; K♣; 7♣; 9♣; 5♣; 10♦; A♥; 8♥; 10♥; 3♥; 4♠; 10♠; J♦; 4♦; 8♠; Q♠; J♠; Q♦; 9♥; 2♣; J♣; 7♥; K♦; 5♥; Q♣; 7♦; J♥; 10♣; 4♣; 2♥; 6♥; 8♦

`draw_n()` function can be used to draw n card with or without
replacement.

let’s draw 10 cards with replacement.

``` python
draw_n(10, replace=True)
```

    [4♣, 10♥, 4♣, 9♠, K♦, 3♥, 8♠, Q♦, Q♣, 3♠]

now let’s draw 10 cards without replacement.

``` python
draw_n(10, replace=False)
```

    [K♦, 4♦, 3♠, Q♦, 7♥, A♦, 4♥, 10♥, 6♠, J♦]

**Example**: One can draw two sets of cards each set contains four cards
and compare to see which one has higher rank.

## Developer install

If you want to develop nbdev_cards yourself :smiley:, please use an
editable installation of nbdev_cards.

    git clone https://github.com/hdocmsu/nbdev_cards.git
    pip install -e "nbdev_cards[dev]"

You also need to use an editable installation of
[nbdev](https://github.com/fastai/nbdev),
[fastcore](https://github.com/fastai/fastcore), and
[excnb](https://github.com/fastai/execnb).

Happy Coding!!!
