/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
/// <reference types="node" />
import { SecretsManager } from 'aws-sdk';
import { Key } from '../kms';
export declare function sanitizeSecretName(name: string): string;
export declare class Secret {
    static readonly API_VERSION = "2017-10-17";
    static fromArn(arn: string, client: SecretsManager): Secret;
    /**
     * Creates a Secret with the given name and, optionally, containing the given 'data'. Tags the
     * secret with the given 'tags' if provided.
     * @param args
     * @throws Error if the request fails.
     * @returns A new Secret object for the newly created secret.
     */
    static create(args: {
        name: string;
        client: SecretsManager;
        encryptionKey?: Key;
        description?: string;
        data?: Buffer | string;
        tags?: Array<{
            Key: string;
            Value: string;
        }>;
    }): Promise<Secret | undefined>;
    arn: string | undefined;
    protected readonly client: SecretsManager;
    protected constructor(arn: string, client: SecretsManager);
    /**
     * Deletes this Secret in AWS SecretsManager
     * @param force If true, then force the delete with no recovery.
     * @throws Error if the request fails.
     */
    delete(force?: boolean): Promise<void>;
    /**
     * Store the given 'data' in the Secret. Text is stored in the 'SecretString'
     * of the Secret, whereas bytes are stored base64-encoded in the 'SecretBinary'
     * of the Secret.
     * @param data
     * @throws Error if the request fails.
     */
    putValue(data: string | Buffer): Promise<void>;
    /**
     * Get the latest version of the data stored in the secret.
     */
    getValue(): Promise<string | Buffer | undefined>;
}
