"use strict";
/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.Key = void 0;
const validation_1 = require("./validation");
class Key {
    constructor(arn) {
        if (!validation_1.isArn(arn)) {
            throw Error(`Not a KMS ARN: ${arn}`);
        }
        this.arn = arn;
    }
    static fromArn(arn) {
        return new Key(arn);
    }
}
exports.Key = Key;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoia2V5LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsia2V5LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7QUFBQTs7O0dBR0c7OztBQUVILDZDQUFxQztBQUVyQyxNQUFhLEdBQUc7SUFPZCxZQUFzQixHQUFXO1FBQy9CLElBQUksQ0FBQyxrQkFBSyxDQUFDLEdBQUcsQ0FBQyxFQUFFO1lBQ2YsTUFBTSxLQUFLLENBQUMsa0JBQWtCLEdBQUcsRUFBRSxDQUFDLENBQUM7U0FDdEM7UUFDRCxJQUFJLENBQUMsR0FBRyxHQUFHLEdBQUcsQ0FBQztJQUNqQixDQUFDO0lBWE0sTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFXO1FBQy9CLE9BQU8sSUFBSSxHQUFHLENBQUMsR0FBRyxDQUFDLENBQUM7SUFDdEIsQ0FBQztDQVVGO0FBYkQsa0JBYUMiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIENvcHlyaWdodCBBbWF6b24uY29tLCBJbmMuIG9yIGl0cyBhZmZpbGlhdGVzLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuICogU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IEFwYWNoZS0yLjBcbiAqL1xuXG5pbXBvcnQgeyBpc0FybiB9IGZyb20gJy4vdmFsaWRhdGlvbic7XG5cbmV4cG9ydCBjbGFzcyBLZXkge1xuICBwdWJsaWMgc3RhdGljIGZyb21Bcm4oYXJuOiBzdHJpbmcpIHtcbiAgICByZXR1cm4gbmV3IEtleShhcm4pO1xuICB9XG5cbiAgcHVibGljIHJlYWRvbmx5IGFybjogc3RyaW5nO1xuXG4gIHByb3RlY3RlZCBjb25zdHJ1Y3Rvcihhcm46IHN0cmluZykge1xuICAgIGlmICghaXNBcm4oYXJuKSkge1xuICAgICAgdGhyb3cgRXJyb3IoYE5vdCBhIEtNUyBBUk46ICR7YXJufWApO1xuICAgIH1cbiAgICB0aGlzLmFybiA9IGFybjtcbiAgfVxufVxuIl19